# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CustomModelArgs', 'CustomModel']

@pulumi.input_type
class CustomModelArgs:
    def __init__(__self__, *,
                 base_environment_id: Optional[pulumi.Input[str]] = None,
                 base_environment_version_id: Optional[pulumi.Input[str]] = None,
                 class_labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 class_labels_file: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 files: Optional[Any] = None,
                 folder_path: Optional[pulumi.Input[str]] = None,
                 guard_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['CustomModelGuardConfigurationArgs']]]] = None,
                 is_proxy: Optional[pulumi.Input[bool]] = None,
                 language: Optional[pulumi.Input[str]] = None,
                 memory_mb: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 negative_class_label: Optional[pulumi.Input[str]] = None,
                 network_access: Optional[pulumi.Input[str]] = None,
                 overall_moderation_configuration: Optional[pulumi.Input['CustomModelOverallModerationConfigurationArgs']] = None,
                 positive_class_label: Optional[pulumi.Input[str]] = None,
                 prediction_threshold: Optional[pulumi.Input[float]] = None,
                 replicas: Optional[pulumi.Input[int]] = None,
                 resource_bundle_id: Optional[pulumi.Input[str]] = None,
                 runtime_parameter_values: Optional[pulumi.Input[Sequence[pulumi.Input['CustomModelRuntimeParameterValueArgs']]]] = None,
                 source_llm_blueprint_id: Optional[pulumi.Input[str]] = None,
                 source_remote_repositories: Optional[pulumi.Input[Sequence[pulumi.Input['CustomModelSourceRemoteRepositoryArgs']]]] = None,
                 target_name: Optional[pulumi.Input[str]] = None,
                 target_type: Optional[pulumi.Input[str]] = None,
                 training_data_partition_column: Optional[pulumi.Input[str]] = None,
                 training_dataset_id: Optional[pulumi.Input[str]] = None,
                 use_case_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a CustomModel resource.
        :param pulumi.Input[str] base_environment_id: The ID of the base environment for the Custom Model.
        :param pulumi.Input[str] base_environment_version_id: The ID of the base environment version for the Custom Model.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] class_labels: Class labels for multiclass classification. Cannot be used with class*labels*file.
        :param pulumi.Input[str] class_labels_file: Path to file containing newline separated class labels for multiclass classification. Cannot be used with class_labels.
        :param pulumi.Input[str] description: The description of the Custom Model.
        :param Any files: The list of tuples, where values in each tuple are the local filesystem path and the path the file should be placed in the Custom Model. If list is of strings, then basenames will be used for tuples.
        :param pulumi.Input[str] folder_path: The path to a folder containing files to build the Custom Model. Each file in the folder is uploaded under path relative to a folder path.
        :param pulumi.Input[Sequence[pulumi.Input['CustomModelGuardConfigurationArgs']]] guard_configurations: The guard configurations for the Custom Model.
        :param pulumi.Input[bool] is_proxy: Flag indicating if the Custom Model is a proxy model.
        :param pulumi.Input[str] language: The language used to build the Custom Model.
        :param pulumi.Input[int] memory_mb: The memory in MB for the Custom Model.
        :param pulumi.Input[str] name: The name of the Custom Model.
        :param pulumi.Input[str] negative_class_label: The negative class label of the Custom Model.
        :param pulumi.Input[str] network_access: The network access for the Custom Model.
        :param pulumi.Input['CustomModelOverallModerationConfigurationArgs'] overall_moderation_configuration: The overall moderation configuration for the Custom Model.
        :param pulumi.Input[str] positive_class_label: The positive class label of the Custom Model.
        :param pulumi.Input[float] prediction_threshold: The prediction threshold of the Custom Model.
        :param pulumi.Input[int] replicas: The replicas for the Custom Model.
        :param pulumi.Input[str] resource_bundle_id: A single identifier that represents a bundle of resources: Memory, CPU, GPU, etc.
        :param pulumi.Input[Sequence[pulumi.Input['CustomModelRuntimeParameterValueArgs']]] runtime_parameter_values: The runtime parameter values for the Custom Model.
        :param pulumi.Input[str] source_llm_blueprint_id: The ID of the source LLM Blueprint for the Custom Model.
        :param pulumi.Input[Sequence[pulumi.Input['CustomModelSourceRemoteRepositoryArgs']]] source_remote_repositories: The source remote repositories for the Custom Model.
        :param pulumi.Input[str] target_name: The target name of the Custom Model.
        :param pulumi.Input[str] target_type: The target type of the Custom Model.
        :param pulumi.Input[str] training_data_partition_column: The name of the partition column in the training dataset assigned to the Custom Model.
        :param pulumi.Input[str] training_dataset_id: The ID of the training dataset assigned to the Custom Model.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] use_case_ids: The list of Use Case IDs to add the Custom Model version to.
        """
        if base_environment_id is not None:
            pulumi.set(__self__, "base_environment_id", base_environment_id)
        if base_environment_version_id is not None:
            pulumi.set(__self__, "base_environment_version_id", base_environment_version_id)
        if class_labels is not None:
            pulumi.set(__self__, "class_labels", class_labels)
        if class_labels_file is not None:
            pulumi.set(__self__, "class_labels_file", class_labels_file)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if files is not None:
            pulumi.set(__self__, "files", files)
        if folder_path is not None:
            pulumi.set(__self__, "folder_path", folder_path)
        if guard_configurations is not None:
            pulumi.set(__self__, "guard_configurations", guard_configurations)
        if is_proxy is not None:
            pulumi.set(__self__, "is_proxy", is_proxy)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if memory_mb is not None:
            pulumi.set(__self__, "memory_mb", memory_mb)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if negative_class_label is not None:
            pulumi.set(__self__, "negative_class_label", negative_class_label)
        if network_access is not None:
            pulumi.set(__self__, "network_access", network_access)
        if overall_moderation_configuration is not None:
            pulumi.set(__self__, "overall_moderation_configuration", overall_moderation_configuration)
        if positive_class_label is not None:
            pulumi.set(__self__, "positive_class_label", positive_class_label)
        if prediction_threshold is not None:
            pulumi.set(__self__, "prediction_threshold", prediction_threshold)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if resource_bundle_id is not None:
            pulumi.set(__self__, "resource_bundle_id", resource_bundle_id)
        if runtime_parameter_values is not None:
            pulumi.set(__self__, "runtime_parameter_values", runtime_parameter_values)
        if source_llm_blueprint_id is not None:
            pulumi.set(__self__, "source_llm_blueprint_id", source_llm_blueprint_id)
        if source_remote_repositories is not None:
            pulumi.set(__self__, "source_remote_repositories", source_remote_repositories)
        if target_name is not None:
            pulumi.set(__self__, "target_name", target_name)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)
        if training_data_partition_column is not None:
            pulumi.set(__self__, "training_data_partition_column", training_data_partition_column)
        if training_dataset_id is not None:
            pulumi.set(__self__, "training_dataset_id", training_dataset_id)
        if use_case_ids is not None:
            pulumi.set(__self__, "use_case_ids", use_case_ids)

    @property
    @pulumi.getter(name="baseEnvironmentId")
    def base_environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the base environment for the Custom Model.
        """
        return pulumi.get(self, "base_environment_id")

    @base_environment_id.setter
    def base_environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_environment_id", value)

    @property
    @pulumi.getter(name="baseEnvironmentVersionId")
    def base_environment_version_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the base environment version for the Custom Model.
        """
        return pulumi.get(self, "base_environment_version_id")

    @base_environment_version_id.setter
    def base_environment_version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_environment_version_id", value)

    @property
    @pulumi.getter(name="classLabels")
    def class_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Class labels for multiclass classification. Cannot be used with class*labels*file.
        """
        return pulumi.get(self, "class_labels")

    @class_labels.setter
    def class_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "class_labels", value)

    @property
    @pulumi.getter(name="classLabelsFile")
    def class_labels_file(self) -> Optional[pulumi.Input[str]]:
        """
        Path to file containing newline separated class labels for multiclass classification. Cannot be used with class_labels.
        """
        return pulumi.get(self, "class_labels_file")

    @class_labels_file.setter
    def class_labels_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "class_labels_file", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Custom Model.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def files(self) -> Optional[Any]:
        """
        The list of tuples, where values in each tuple are the local filesystem path and the path the file should be placed in the Custom Model. If list is of strings, then basenames will be used for tuples.
        """
        return pulumi.get(self, "files")

    @files.setter
    def files(self, value: Optional[Any]):
        pulumi.set(self, "files", value)

    @property
    @pulumi.getter(name="folderPath")
    def folder_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to a folder containing files to build the Custom Model. Each file in the folder is uploaded under path relative to a folder path.
        """
        return pulumi.get(self, "folder_path")

    @folder_path.setter
    def folder_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_path", value)

    @property
    @pulumi.getter(name="guardConfigurations")
    def guard_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomModelGuardConfigurationArgs']]]]:
        """
        The guard configurations for the Custom Model.
        """
        return pulumi.get(self, "guard_configurations")

    @guard_configurations.setter
    def guard_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomModelGuardConfigurationArgs']]]]):
        pulumi.set(self, "guard_configurations", value)

    @property
    @pulumi.getter(name="isProxy")
    def is_proxy(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag indicating if the Custom Model is a proxy model.
        """
        return pulumi.get(self, "is_proxy")

    @is_proxy.setter
    def is_proxy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_proxy", value)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[str]]:
        """
        The language used to build the Custom Model.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter(name="memoryMb")
    def memory_mb(self) -> Optional[pulumi.Input[int]]:
        """
        The memory in MB for the Custom Model.
        """
        return pulumi.get(self, "memory_mb")

    @memory_mb.setter
    def memory_mb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_mb", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Custom Model.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="negativeClassLabel")
    def negative_class_label(self) -> Optional[pulumi.Input[str]]:
        """
        The negative class label of the Custom Model.
        """
        return pulumi.get(self, "negative_class_label")

    @negative_class_label.setter
    def negative_class_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "negative_class_label", value)

    @property
    @pulumi.getter(name="networkAccess")
    def network_access(self) -> Optional[pulumi.Input[str]]:
        """
        The network access for the Custom Model.
        """
        return pulumi.get(self, "network_access")

    @network_access.setter
    def network_access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_access", value)

    @property
    @pulumi.getter(name="overallModerationConfiguration")
    def overall_moderation_configuration(self) -> Optional[pulumi.Input['CustomModelOverallModerationConfigurationArgs']]:
        """
        The overall moderation configuration for the Custom Model.
        """
        return pulumi.get(self, "overall_moderation_configuration")

    @overall_moderation_configuration.setter
    def overall_moderation_configuration(self, value: Optional[pulumi.Input['CustomModelOverallModerationConfigurationArgs']]):
        pulumi.set(self, "overall_moderation_configuration", value)

    @property
    @pulumi.getter(name="positiveClassLabel")
    def positive_class_label(self) -> Optional[pulumi.Input[str]]:
        """
        The positive class label of the Custom Model.
        """
        return pulumi.get(self, "positive_class_label")

    @positive_class_label.setter
    def positive_class_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "positive_class_label", value)

    @property
    @pulumi.getter(name="predictionThreshold")
    def prediction_threshold(self) -> Optional[pulumi.Input[float]]:
        """
        The prediction threshold of the Custom Model.
        """
        return pulumi.get(self, "prediction_threshold")

    @prediction_threshold.setter
    def prediction_threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "prediction_threshold", value)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[int]]:
        """
        The replicas for the Custom Model.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter(name="resourceBundleId")
    def resource_bundle_id(self) -> Optional[pulumi.Input[str]]:
        """
        A single identifier that represents a bundle of resources: Memory, CPU, GPU, etc.
        """
        return pulumi.get(self, "resource_bundle_id")

    @resource_bundle_id.setter
    def resource_bundle_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_bundle_id", value)

    @property
    @pulumi.getter(name="runtimeParameterValues")
    def runtime_parameter_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomModelRuntimeParameterValueArgs']]]]:
        """
        The runtime parameter values for the Custom Model.
        """
        return pulumi.get(self, "runtime_parameter_values")

    @runtime_parameter_values.setter
    def runtime_parameter_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomModelRuntimeParameterValueArgs']]]]):
        pulumi.set(self, "runtime_parameter_values", value)

    @property
    @pulumi.getter(name="sourceLlmBlueprintId")
    def source_llm_blueprint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the source LLM Blueprint for the Custom Model.
        """
        return pulumi.get(self, "source_llm_blueprint_id")

    @source_llm_blueprint_id.setter
    def source_llm_blueprint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_llm_blueprint_id", value)

    @property
    @pulumi.getter(name="sourceRemoteRepositories")
    def source_remote_repositories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomModelSourceRemoteRepositoryArgs']]]]:
        """
        The source remote repositories for the Custom Model.
        """
        return pulumi.get(self, "source_remote_repositories")

    @source_remote_repositories.setter
    def source_remote_repositories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomModelSourceRemoteRepositoryArgs']]]]):
        pulumi.set(self, "source_remote_repositories", value)

    @property
    @pulumi.getter(name="targetName")
    def target_name(self) -> Optional[pulumi.Input[str]]:
        """
        The target name of the Custom Model.
        """
        return pulumi.get(self, "target_name")

    @target_name.setter
    def target_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_name", value)

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[pulumi.Input[str]]:
        """
        The target type of the Custom Model.
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_type", value)

    @property
    @pulumi.getter(name="trainingDataPartitionColumn")
    def training_data_partition_column(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the partition column in the training dataset assigned to the Custom Model.
        """
        return pulumi.get(self, "training_data_partition_column")

    @training_data_partition_column.setter
    def training_data_partition_column(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "training_data_partition_column", value)

    @property
    @pulumi.getter(name="trainingDatasetId")
    def training_dataset_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the training dataset assigned to the Custom Model.
        """
        return pulumi.get(self, "training_dataset_id")

    @training_dataset_id.setter
    def training_dataset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "training_dataset_id", value)

    @property
    @pulumi.getter(name="useCaseIds")
    def use_case_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of Use Case IDs to add the Custom Model version to.
        """
        return pulumi.get(self, "use_case_ids")

    @use_case_ids.setter
    def use_case_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "use_case_ids", value)


@pulumi.input_type
class _CustomModelState:
    def __init__(__self__, *,
                 base_environment_id: Optional[pulumi.Input[str]] = None,
                 base_environment_version_id: Optional[pulumi.Input[str]] = None,
                 class_labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 class_labels_file: Optional[pulumi.Input[str]] = None,
                 deployments_count: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 files: Optional[Any] = None,
                 files_hashes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 folder_path: Optional[pulumi.Input[str]] = None,
                 folder_path_hash: Optional[pulumi.Input[str]] = None,
                 guard_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['CustomModelGuardConfigurationArgs']]]] = None,
                 is_proxy: Optional[pulumi.Input[bool]] = None,
                 language: Optional[pulumi.Input[str]] = None,
                 memory_mb: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 negative_class_label: Optional[pulumi.Input[str]] = None,
                 network_access: Optional[pulumi.Input[str]] = None,
                 overall_moderation_configuration: Optional[pulumi.Input['CustomModelOverallModerationConfigurationArgs']] = None,
                 positive_class_label: Optional[pulumi.Input[str]] = None,
                 prediction_threshold: Optional[pulumi.Input[float]] = None,
                 replicas: Optional[pulumi.Input[int]] = None,
                 resource_bundle_id: Optional[pulumi.Input[str]] = None,
                 runtime_parameter_values: Optional[pulumi.Input[Sequence[pulumi.Input['CustomModelRuntimeParameterValueArgs']]]] = None,
                 source_llm_blueprint_id: Optional[pulumi.Input[str]] = None,
                 source_remote_repositories: Optional[pulumi.Input[Sequence[pulumi.Input['CustomModelSourceRemoteRepositoryArgs']]]] = None,
                 target_name: Optional[pulumi.Input[str]] = None,
                 target_type: Optional[pulumi.Input[str]] = None,
                 training_data_partition_column: Optional[pulumi.Input[str]] = None,
                 training_dataset_id: Optional[pulumi.Input[str]] = None,
                 training_dataset_name: Optional[pulumi.Input[str]] = None,
                 training_dataset_version_id: Optional[pulumi.Input[str]] = None,
                 use_case_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 version_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CustomModel resources.
        :param pulumi.Input[str] base_environment_id: The ID of the base environment for the Custom Model.
        :param pulumi.Input[str] base_environment_version_id: The ID of the base environment version for the Custom Model.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] class_labels: Class labels for multiclass classification. Cannot be used with class*labels*file.
        :param pulumi.Input[str] class_labels_file: Path to file containing newline separated class labels for multiclass classification. Cannot be used with class_labels.
        :param pulumi.Input[int] deployments_count: The number of deployments for the Custom Model.
        :param pulumi.Input[str] description: The description of the Custom Model.
        :param Any files: The list of tuples, where values in each tuple are the local filesystem path and the path the file should be placed in the Custom Model. If list is of strings, then basenames will be used for tuples.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] files_hashes: The hash of file contents for each file in files.
        :param pulumi.Input[str] folder_path: The path to a folder containing files to build the Custom Model. Each file in the folder is uploaded under path relative to a folder path.
        :param pulumi.Input[str] folder_path_hash: The hash of the folder path contents.
        :param pulumi.Input[Sequence[pulumi.Input['CustomModelGuardConfigurationArgs']]] guard_configurations: The guard configurations for the Custom Model.
        :param pulumi.Input[bool] is_proxy: Flag indicating if the Custom Model is a proxy model.
        :param pulumi.Input[str] language: The language used to build the Custom Model.
        :param pulumi.Input[int] memory_mb: The memory in MB for the Custom Model.
        :param pulumi.Input[str] name: The name of the Custom Model.
        :param pulumi.Input[str] negative_class_label: The negative class label of the Custom Model.
        :param pulumi.Input[str] network_access: The network access for the Custom Model.
        :param pulumi.Input['CustomModelOverallModerationConfigurationArgs'] overall_moderation_configuration: The overall moderation configuration for the Custom Model.
        :param pulumi.Input[str] positive_class_label: The positive class label of the Custom Model.
        :param pulumi.Input[float] prediction_threshold: The prediction threshold of the Custom Model.
        :param pulumi.Input[int] replicas: The replicas for the Custom Model.
        :param pulumi.Input[str] resource_bundle_id: A single identifier that represents a bundle of resources: Memory, CPU, GPU, etc.
        :param pulumi.Input[Sequence[pulumi.Input['CustomModelRuntimeParameterValueArgs']]] runtime_parameter_values: The runtime parameter values for the Custom Model.
        :param pulumi.Input[str] source_llm_blueprint_id: The ID of the source LLM Blueprint for the Custom Model.
        :param pulumi.Input[Sequence[pulumi.Input['CustomModelSourceRemoteRepositoryArgs']]] source_remote_repositories: The source remote repositories for the Custom Model.
        :param pulumi.Input[str] target_name: The target name of the Custom Model.
        :param pulumi.Input[str] target_type: The target type of the Custom Model.
        :param pulumi.Input[str] training_data_partition_column: The name of the partition column in the training dataset assigned to the Custom Model.
        :param pulumi.Input[str] training_dataset_id: The ID of the training dataset assigned to the Custom Model.
        :param pulumi.Input[str] training_dataset_name: The name of the training dataset assigned to the Custom Model.
        :param pulumi.Input[str] training_dataset_version_id: The version ID of the training dataset assigned to the Custom Model.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] use_case_ids: The list of Use Case IDs to add the Custom Model version to.
        :param pulumi.Input[str] version_id: The ID of the latest Custom Model version.
        """
        if base_environment_id is not None:
            pulumi.set(__self__, "base_environment_id", base_environment_id)
        if base_environment_version_id is not None:
            pulumi.set(__self__, "base_environment_version_id", base_environment_version_id)
        if class_labels is not None:
            pulumi.set(__self__, "class_labels", class_labels)
        if class_labels_file is not None:
            pulumi.set(__self__, "class_labels_file", class_labels_file)
        if deployments_count is not None:
            pulumi.set(__self__, "deployments_count", deployments_count)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if files is not None:
            pulumi.set(__self__, "files", files)
        if files_hashes is not None:
            pulumi.set(__self__, "files_hashes", files_hashes)
        if folder_path is not None:
            pulumi.set(__self__, "folder_path", folder_path)
        if folder_path_hash is not None:
            pulumi.set(__self__, "folder_path_hash", folder_path_hash)
        if guard_configurations is not None:
            pulumi.set(__self__, "guard_configurations", guard_configurations)
        if is_proxy is not None:
            pulumi.set(__self__, "is_proxy", is_proxy)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if memory_mb is not None:
            pulumi.set(__self__, "memory_mb", memory_mb)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if negative_class_label is not None:
            pulumi.set(__self__, "negative_class_label", negative_class_label)
        if network_access is not None:
            pulumi.set(__self__, "network_access", network_access)
        if overall_moderation_configuration is not None:
            pulumi.set(__self__, "overall_moderation_configuration", overall_moderation_configuration)
        if positive_class_label is not None:
            pulumi.set(__self__, "positive_class_label", positive_class_label)
        if prediction_threshold is not None:
            pulumi.set(__self__, "prediction_threshold", prediction_threshold)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if resource_bundle_id is not None:
            pulumi.set(__self__, "resource_bundle_id", resource_bundle_id)
        if runtime_parameter_values is not None:
            pulumi.set(__self__, "runtime_parameter_values", runtime_parameter_values)
        if source_llm_blueprint_id is not None:
            pulumi.set(__self__, "source_llm_blueprint_id", source_llm_blueprint_id)
        if source_remote_repositories is not None:
            pulumi.set(__self__, "source_remote_repositories", source_remote_repositories)
        if target_name is not None:
            pulumi.set(__self__, "target_name", target_name)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)
        if training_data_partition_column is not None:
            pulumi.set(__self__, "training_data_partition_column", training_data_partition_column)
        if training_dataset_id is not None:
            pulumi.set(__self__, "training_dataset_id", training_dataset_id)
        if training_dataset_name is not None:
            pulumi.set(__self__, "training_dataset_name", training_dataset_name)
        if training_dataset_version_id is not None:
            pulumi.set(__self__, "training_dataset_version_id", training_dataset_version_id)
        if use_case_ids is not None:
            pulumi.set(__self__, "use_case_ids", use_case_ids)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)

    @property
    @pulumi.getter(name="baseEnvironmentId")
    def base_environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the base environment for the Custom Model.
        """
        return pulumi.get(self, "base_environment_id")

    @base_environment_id.setter
    def base_environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_environment_id", value)

    @property
    @pulumi.getter(name="baseEnvironmentVersionId")
    def base_environment_version_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the base environment version for the Custom Model.
        """
        return pulumi.get(self, "base_environment_version_id")

    @base_environment_version_id.setter
    def base_environment_version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_environment_version_id", value)

    @property
    @pulumi.getter(name="classLabels")
    def class_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Class labels for multiclass classification. Cannot be used with class*labels*file.
        """
        return pulumi.get(self, "class_labels")

    @class_labels.setter
    def class_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "class_labels", value)

    @property
    @pulumi.getter(name="classLabelsFile")
    def class_labels_file(self) -> Optional[pulumi.Input[str]]:
        """
        Path to file containing newline separated class labels for multiclass classification. Cannot be used with class_labels.
        """
        return pulumi.get(self, "class_labels_file")

    @class_labels_file.setter
    def class_labels_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "class_labels_file", value)

    @property
    @pulumi.getter(name="deploymentsCount")
    def deployments_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of deployments for the Custom Model.
        """
        return pulumi.get(self, "deployments_count")

    @deployments_count.setter
    def deployments_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "deployments_count", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Custom Model.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def files(self) -> Optional[Any]:
        """
        The list of tuples, where values in each tuple are the local filesystem path and the path the file should be placed in the Custom Model. If list is of strings, then basenames will be used for tuples.
        """
        return pulumi.get(self, "files")

    @files.setter
    def files(self, value: Optional[Any]):
        pulumi.set(self, "files", value)

    @property
    @pulumi.getter(name="filesHashes")
    def files_hashes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The hash of file contents for each file in files.
        """
        return pulumi.get(self, "files_hashes")

    @files_hashes.setter
    def files_hashes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "files_hashes", value)

    @property
    @pulumi.getter(name="folderPath")
    def folder_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to a folder containing files to build the Custom Model. Each file in the folder is uploaded under path relative to a folder path.
        """
        return pulumi.get(self, "folder_path")

    @folder_path.setter
    def folder_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_path", value)

    @property
    @pulumi.getter(name="folderPathHash")
    def folder_path_hash(self) -> Optional[pulumi.Input[str]]:
        """
        The hash of the folder path contents.
        """
        return pulumi.get(self, "folder_path_hash")

    @folder_path_hash.setter
    def folder_path_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_path_hash", value)

    @property
    @pulumi.getter(name="guardConfigurations")
    def guard_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomModelGuardConfigurationArgs']]]]:
        """
        The guard configurations for the Custom Model.
        """
        return pulumi.get(self, "guard_configurations")

    @guard_configurations.setter
    def guard_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomModelGuardConfigurationArgs']]]]):
        pulumi.set(self, "guard_configurations", value)

    @property
    @pulumi.getter(name="isProxy")
    def is_proxy(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag indicating if the Custom Model is a proxy model.
        """
        return pulumi.get(self, "is_proxy")

    @is_proxy.setter
    def is_proxy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_proxy", value)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[str]]:
        """
        The language used to build the Custom Model.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter(name="memoryMb")
    def memory_mb(self) -> Optional[pulumi.Input[int]]:
        """
        The memory in MB for the Custom Model.
        """
        return pulumi.get(self, "memory_mb")

    @memory_mb.setter
    def memory_mb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_mb", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Custom Model.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="negativeClassLabel")
    def negative_class_label(self) -> Optional[pulumi.Input[str]]:
        """
        The negative class label of the Custom Model.
        """
        return pulumi.get(self, "negative_class_label")

    @negative_class_label.setter
    def negative_class_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "negative_class_label", value)

    @property
    @pulumi.getter(name="networkAccess")
    def network_access(self) -> Optional[pulumi.Input[str]]:
        """
        The network access for the Custom Model.
        """
        return pulumi.get(self, "network_access")

    @network_access.setter
    def network_access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_access", value)

    @property
    @pulumi.getter(name="overallModerationConfiguration")
    def overall_moderation_configuration(self) -> Optional[pulumi.Input['CustomModelOverallModerationConfigurationArgs']]:
        """
        The overall moderation configuration for the Custom Model.
        """
        return pulumi.get(self, "overall_moderation_configuration")

    @overall_moderation_configuration.setter
    def overall_moderation_configuration(self, value: Optional[pulumi.Input['CustomModelOverallModerationConfigurationArgs']]):
        pulumi.set(self, "overall_moderation_configuration", value)

    @property
    @pulumi.getter(name="positiveClassLabel")
    def positive_class_label(self) -> Optional[pulumi.Input[str]]:
        """
        The positive class label of the Custom Model.
        """
        return pulumi.get(self, "positive_class_label")

    @positive_class_label.setter
    def positive_class_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "positive_class_label", value)

    @property
    @pulumi.getter(name="predictionThreshold")
    def prediction_threshold(self) -> Optional[pulumi.Input[float]]:
        """
        The prediction threshold of the Custom Model.
        """
        return pulumi.get(self, "prediction_threshold")

    @prediction_threshold.setter
    def prediction_threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "prediction_threshold", value)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[int]]:
        """
        The replicas for the Custom Model.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter(name="resourceBundleId")
    def resource_bundle_id(self) -> Optional[pulumi.Input[str]]:
        """
        A single identifier that represents a bundle of resources: Memory, CPU, GPU, etc.
        """
        return pulumi.get(self, "resource_bundle_id")

    @resource_bundle_id.setter
    def resource_bundle_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_bundle_id", value)

    @property
    @pulumi.getter(name="runtimeParameterValues")
    def runtime_parameter_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomModelRuntimeParameterValueArgs']]]]:
        """
        The runtime parameter values for the Custom Model.
        """
        return pulumi.get(self, "runtime_parameter_values")

    @runtime_parameter_values.setter
    def runtime_parameter_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomModelRuntimeParameterValueArgs']]]]):
        pulumi.set(self, "runtime_parameter_values", value)

    @property
    @pulumi.getter(name="sourceLlmBlueprintId")
    def source_llm_blueprint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the source LLM Blueprint for the Custom Model.
        """
        return pulumi.get(self, "source_llm_blueprint_id")

    @source_llm_blueprint_id.setter
    def source_llm_blueprint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_llm_blueprint_id", value)

    @property
    @pulumi.getter(name="sourceRemoteRepositories")
    def source_remote_repositories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomModelSourceRemoteRepositoryArgs']]]]:
        """
        The source remote repositories for the Custom Model.
        """
        return pulumi.get(self, "source_remote_repositories")

    @source_remote_repositories.setter
    def source_remote_repositories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomModelSourceRemoteRepositoryArgs']]]]):
        pulumi.set(self, "source_remote_repositories", value)

    @property
    @pulumi.getter(name="targetName")
    def target_name(self) -> Optional[pulumi.Input[str]]:
        """
        The target name of the Custom Model.
        """
        return pulumi.get(self, "target_name")

    @target_name.setter
    def target_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_name", value)

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[pulumi.Input[str]]:
        """
        The target type of the Custom Model.
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_type", value)

    @property
    @pulumi.getter(name="trainingDataPartitionColumn")
    def training_data_partition_column(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the partition column in the training dataset assigned to the Custom Model.
        """
        return pulumi.get(self, "training_data_partition_column")

    @training_data_partition_column.setter
    def training_data_partition_column(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "training_data_partition_column", value)

    @property
    @pulumi.getter(name="trainingDatasetId")
    def training_dataset_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the training dataset assigned to the Custom Model.
        """
        return pulumi.get(self, "training_dataset_id")

    @training_dataset_id.setter
    def training_dataset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "training_dataset_id", value)

    @property
    @pulumi.getter(name="trainingDatasetName")
    def training_dataset_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the training dataset assigned to the Custom Model.
        """
        return pulumi.get(self, "training_dataset_name")

    @training_dataset_name.setter
    def training_dataset_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "training_dataset_name", value)

    @property
    @pulumi.getter(name="trainingDatasetVersionId")
    def training_dataset_version_id(self) -> Optional[pulumi.Input[str]]:
        """
        The version ID of the training dataset assigned to the Custom Model.
        """
        return pulumi.get(self, "training_dataset_version_id")

    @training_dataset_version_id.setter
    def training_dataset_version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "training_dataset_version_id", value)

    @property
    @pulumi.getter(name="useCaseIds")
    def use_case_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of Use Case IDs to add the Custom Model version to.
        """
        return pulumi.get(self, "use_case_ids")

    @use_case_ids.setter
    def use_case_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "use_case_ids", value)

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the latest Custom Model version.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_id", value)


class CustomModel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_environment_id: Optional[pulumi.Input[str]] = None,
                 base_environment_version_id: Optional[pulumi.Input[str]] = None,
                 class_labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 class_labels_file: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 files: Optional[Any] = None,
                 folder_path: Optional[pulumi.Input[str]] = None,
                 guard_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomModelGuardConfigurationArgs', 'CustomModelGuardConfigurationArgsDict']]]]] = None,
                 is_proxy: Optional[pulumi.Input[bool]] = None,
                 language: Optional[pulumi.Input[str]] = None,
                 memory_mb: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 negative_class_label: Optional[pulumi.Input[str]] = None,
                 network_access: Optional[pulumi.Input[str]] = None,
                 overall_moderation_configuration: Optional[pulumi.Input[Union['CustomModelOverallModerationConfigurationArgs', 'CustomModelOverallModerationConfigurationArgsDict']]] = None,
                 positive_class_label: Optional[pulumi.Input[str]] = None,
                 prediction_threshold: Optional[pulumi.Input[float]] = None,
                 replicas: Optional[pulumi.Input[int]] = None,
                 resource_bundle_id: Optional[pulumi.Input[str]] = None,
                 runtime_parameter_values: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomModelRuntimeParameterValueArgs', 'CustomModelRuntimeParameterValueArgsDict']]]]] = None,
                 source_llm_blueprint_id: Optional[pulumi.Input[str]] = None,
                 source_remote_repositories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomModelSourceRemoteRepositoryArgs', 'CustomModelSourceRemoteRepositoryArgsDict']]]]] = None,
                 target_name: Optional[pulumi.Input[str]] = None,
                 target_type: Optional[pulumi.Input[str]] = None,
                 training_data_partition_column: Optional[pulumi.Input[str]] = None,
                 training_dataset_id: Optional[pulumi.Input[str]] = None,
                 use_case_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Custom Model

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datarobot as datarobot

        example_remote_repository = datarobot.RemoteRepository("exampleRemoteRepository",
            description="GitHub repository with Datarobot user models",
            location="https://github.com/datarobot/datarobot-user-models",
            source_type="github")
        # set the credential id for private repositories
        # credential_id = datarobot_api_token_credential.example.id
        example_custom_model = datarobot.CustomModel("exampleCustomModel",
            description="An example custom model from GitHub repository",
            files=[
                "file1.py",
                "file2.py",
            ],
            target_type="Binary",
            target_name="my_label",
            base_environment_id="65f9b27eab986d30d4c64268")
        # Optional
        # source_remote_repositories = [
        #   {
        #     id  = datarobot_remote_repository.example.id
        #     ref = "master"
        #     source_paths = [
        #       "model_templates/python3_dummy_binary",
        #     ]
        #   }
        # ]
        # guard_configurations = [
        #   {
        #     template_name = "Rouge 1"
        #     name          = "Rouge 1 response"
        #     stages        = ["response"]
        #     intervention = {
        #       action  = "block"
        #       message = "response has been blocked by Rogue 1 guard"
        #       condition = jsonencode({
        #         "comparand": 0.5, 
        #         "comparator": "greaterThan"
        #       })
        #     }
        #   },
        # ]
        # overall_moderation_configuration = {
        #   timeout_sec    = 120
        #   timeout_action = "score"
        # }
        # memory_mb      = 512
        # replicas       = 2
        # network_access = "NONE"
        pulumi.export("exampleId", example_custom_model.id)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] base_environment_id: The ID of the base environment for the Custom Model.
        :param pulumi.Input[str] base_environment_version_id: The ID of the base environment version for the Custom Model.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] class_labels: Class labels for multiclass classification. Cannot be used with class*labels*file.
        :param pulumi.Input[str] class_labels_file: Path to file containing newline separated class labels for multiclass classification. Cannot be used with class_labels.
        :param pulumi.Input[str] description: The description of the Custom Model.
        :param Any files: The list of tuples, where values in each tuple are the local filesystem path and the path the file should be placed in the Custom Model. If list is of strings, then basenames will be used for tuples.
        :param pulumi.Input[str] folder_path: The path to a folder containing files to build the Custom Model. Each file in the folder is uploaded under path relative to a folder path.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomModelGuardConfigurationArgs', 'CustomModelGuardConfigurationArgsDict']]]] guard_configurations: The guard configurations for the Custom Model.
        :param pulumi.Input[bool] is_proxy: Flag indicating if the Custom Model is a proxy model.
        :param pulumi.Input[str] language: The language used to build the Custom Model.
        :param pulumi.Input[int] memory_mb: The memory in MB for the Custom Model.
        :param pulumi.Input[str] name: The name of the Custom Model.
        :param pulumi.Input[str] negative_class_label: The negative class label of the Custom Model.
        :param pulumi.Input[str] network_access: The network access for the Custom Model.
        :param pulumi.Input[Union['CustomModelOverallModerationConfigurationArgs', 'CustomModelOverallModerationConfigurationArgsDict']] overall_moderation_configuration: The overall moderation configuration for the Custom Model.
        :param pulumi.Input[str] positive_class_label: The positive class label of the Custom Model.
        :param pulumi.Input[float] prediction_threshold: The prediction threshold of the Custom Model.
        :param pulumi.Input[int] replicas: The replicas for the Custom Model.
        :param pulumi.Input[str] resource_bundle_id: A single identifier that represents a bundle of resources: Memory, CPU, GPU, etc.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomModelRuntimeParameterValueArgs', 'CustomModelRuntimeParameterValueArgsDict']]]] runtime_parameter_values: The runtime parameter values for the Custom Model.
        :param pulumi.Input[str] source_llm_blueprint_id: The ID of the source LLM Blueprint for the Custom Model.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomModelSourceRemoteRepositoryArgs', 'CustomModelSourceRemoteRepositoryArgsDict']]]] source_remote_repositories: The source remote repositories for the Custom Model.
        :param pulumi.Input[str] target_name: The target name of the Custom Model.
        :param pulumi.Input[str] target_type: The target type of the Custom Model.
        :param pulumi.Input[str] training_data_partition_column: The name of the partition column in the training dataset assigned to the Custom Model.
        :param pulumi.Input[str] training_dataset_id: The ID of the training dataset assigned to the Custom Model.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] use_case_ids: The list of Use Case IDs to add the Custom Model version to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CustomModelArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Custom Model

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datarobot as datarobot

        example_remote_repository = datarobot.RemoteRepository("exampleRemoteRepository",
            description="GitHub repository with Datarobot user models",
            location="https://github.com/datarobot/datarobot-user-models",
            source_type="github")
        # set the credential id for private repositories
        # credential_id = datarobot_api_token_credential.example.id
        example_custom_model = datarobot.CustomModel("exampleCustomModel",
            description="An example custom model from GitHub repository",
            files=[
                "file1.py",
                "file2.py",
            ],
            target_type="Binary",
            target_name="my_label",
            base_environment_id="65f9b27eab986d30d4c64268")
        # Optional
        # source_remote_repositories = [
        #   {
        #     id  = datarobot_remote_repository.example.id
        #     ref = "master"
        #     source_paths = [
        #       "model_templates/python3_dummy_binary",
        #     ]
        #   }
        # ]
        # guard_configurations = [
        #   {
        #     template_name = "Rouge 1"
        #     name          = "Rouge 1 response"
        #     stages        = ["response"]
        #     intervention = {
        #       action  = "block"
        #       message = "response has been blocked by Rogue 1 guard"
        #       condition = jsonencode({
        #         "comparand": 0.5, 
        #         "comparator": "greaterThan"
        #       })
        #     }
        #   },
        # ]
        # overall_moderation_configuration = {
        #   timeout_sec    = 120
        #   timeout_action = "score"
        # }
        # memory_mb      = 512
        # replicas       = 2
        # network_access = "NONE"
        pulumi.export("exampleId", example_custom_model.id)
        ```

        :param str resource_name: The name of the resource.
        :param CustomModelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomModelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_environment_id: Optional[pulumi.Input[str]] = None,
                 base_environment_version_id: Optional[pulumi.Input[str]] = None,
                 class_labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 class_labels_file: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 files: Optional[Any] = None,
                 folder_path: Optional[pulumi.Input[str]] = None,
                 guard_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomModelGuardConfigurationArgs', 'CustomModelGuardConfigurationArgsDict']]]]] = None,
                 is_proxy: Optional[pulumi.Input[bool]] = None,
                 language: Optional[pulumi.Input[str]] = None,
                 memory_mb: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 negative_class_label: Optional[pulumi.Input[str]] = None,
                 network_access: Optional[pulumi.Input[str]] = None,
                 overall_moderation_configuration: Optional[pulumi.Input[Union['CustomModelOverallModerationConfigurationArgs', 'CustomModelOverallModerationConfigurationArgsDict']]] = None,
                 positive_class_label: Optional[pulumi.Input[str]] = None,
                 prediction_threshold: Optional[pulumi.Input[float]] = None,
                 replicas: Optional[pulumi.Input[int]] = None,
                 resource_bundle_id: Optional[pulumi.Input[str]] = None,
                 runtime_parameter_values: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomModelRuntimeParameterValueArgs', 'CustomModelRuntimeParameterValueArgsDict']]]]] = None,
                 source_llm_blueprint_id: Optional[pulumi.Input[str]] = None,
                 source_remote_repositories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomModelSourceRemoteRepositoryArgs', 'CustomModelSourceRemoteRepositoryArgsDict']]]]] = None,
                 target_name: Optional[pulumi.Input[str]] = None,
                 target_type: Optional[pulumi.Input[str]] = None,
                 training_data_partition_column: Optional[pulumi.Input[str]] = None,
                 training_dataset_id: Optional[pulumi.Input[str]] = None,
                 use_case_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomModelArgs.__new__(CustomModelArgs)

            __props__.__dict__["base_environment_id"] = base_environment_id
            __props__.__dict__["base_environment_version_id"] = base_environment_version_id
            __props__.__dict__["class_labels"] = class_labels
            __props__.__dict__["class_labels_file"] = class_labels_file
            __props__.__dict__["description"] = description
            __props__.__dict__["files"] = files
            __props__.__dict__["folder_path"] = folder_path
            __props__.__dict__["guard_configurations"] = guard_configurations
            __props__.__dict__["is_proxy"] = is_proxy
            __props__.__dict__["language"] = language
            __props__.__dict__["memory_mb"] = memory_mb
            __props__.__dict__["name"] = name
            __props__.__dict__["negative_class_label"] = negative_class_label
            __props__.__dict__["network_access"] = network_access
            __props__.__dict__["overall_moderation_configuration"] = overall_moderation_configuration
            __props__.__dict__["positive_class_label"] = positive_class_label
            __props__.__dict__["prediction_threshold"] = prediction_threshold
            __props__.__dict__["replicas"] = replicas
            __props__.__dict__["resource_bundle_id"] = resource_bundle_id
            __props__.__dict__["runtime_parameter_values"] = runtime_parameter_values
            __props__.__dict__["source_llm_blueprint_id"] = source_llm_blueprint_id
            __props__.__dict__["source_remote_repositories"] = source_remote_repositories
            __props__.__dict__["target_name"] = target_name
            __props__.__dict__["target_type"] = target_type
            __props__.__dict__["training_data_partition_column"] = training_data_partition_column
            __props__.__dict__["training_dataset_id"] = training_dataset_id
            __props__.__dict__["use_case_ids"] = use_case_ids
            __props__.__dict__["deployments_count"] = None
            __props__.__dict__["files_hashes"] = None
            __props__.__dict__["folder_path_hash"] = None
            __props__.__dict__["training_dataset_name"] = None
            __props__.__dict__["training_dataset_version_id"] = None
            __props__.__dict__["version_id"] = None
        super(CustomModel, __self__).__init__(
            'datarobot:index/customModel:CustomModel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            base_environment_id: Optional[pulumi.Input[str]] = None,
            base_environment_version_id: Optional[pulumi.Input[str]] = None,
            class_labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            class_labels_file: Optional[pulumi.Input[str]] = None,
            deployments_count: Optional[pulumi.Input[int]] = None,
            description: Optional[pulumi.Input[str]] = None,
            files: Optional[Any] = None,
            files_hashes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            folder_path: Optional[pulumi.Input[str]] = None,
            folder_path_hash: Optional[pulumi.Input[str]] = None,
            guard_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomModelGuardConfigurationArgs', 'CustomModelGuardConfigurationArgsDict']]]]] = None,
            is_proxy: Optional[pulumi.Input[bool]] = None,
            language: Optional[pulumi.Input[str]] = None,
            memory_mb: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            negative_class_label: Optional[pulumi.Input[str]] = None,
            network_access: Optional[pulumi.Input[str]] = None,
            overall_moderation_configuration: Optional[pulumi.Input[Union['CustomModelOverallModerationConfigurationArgs', 'CustomModelOverallModerationConfigurationArgsDict']]] = None,
            positive_class_label: Optional[pulumi.Input[str]] = None,
            prediction_threshold: Optional[pulumi.Input[float]] = None,
            replicas: Optional[pulumi.Input[int]] = None,
            resource_bundle_id: Optional[pulumi.Input[str]] = None,
            runtime_parameter_values: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomModelRuntimeParameterValueArgs', 'CustomModelRuntimeParameterValueArgsDict']]]]] = None,
            source_llm_blueprint_id: Optional[pulumi.Input[str]] = None,
            source_remote_repositories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomModelSourceRemoteRepositoryArgs', 'CustomModelSourceRemoteRepositoryArgsDict']]]]] = None,
            target_name: Optional[pulumi.Input[str]] = None,
            target_type: Optional[pulumi.Input[str]] = None,
            training_data_partition_column: Optional[pulumi.Input[str]] = None,
            training_dataset_id: Optional[pulumi.Input[str]] = None,
            training_dataset_name: Optional[pulumi.Input[str]] = None,
            training_dataset_version_id: Optional[pulumi.Input[str]] = None,
            use_case_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            version_id: Optional[pulumi.Input[str]] = None) -> 'CustomModel':
        """
        Get an existing CustomModel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] base_environment_id: The ID of the base environment for the Custom Model.
        :param pulumi.Input[str] base_environment_version_id: The ID of the base environment version for the Custom Model.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] class_labels: Class labels for multiclass classification. Cannot be used with class*labels*file.
        :param pulumi.Input[str] class_labels_file: Path to file containing newline separated class labels for multiclass classification. Cannot be used with class_labels.
        :param pulumi.Input[int] deployments_count: The number of deployments for the Custom Model.
        :param pulumi.Input[str] description: The description of the Custom Model.
        :param Any files: The list of tuples, where values in each tuple are the local filesystem path and the path the file should be placed in the Custom Model. If list is of strings, then basenames will be used for tuples.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] files_hashes: The hash of file contents for each file in files.
        :param pulumi.Input[str] folder_path: The path to a folder containing files to build the Custom Model. Each file in the folder is uploaded under path relative to a folder path.
        :param pulumi.Input[str] folder_path_hash: The hash of the folder path contents.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomModelGuardConfigurationArgs', 'CustomModelGuardConfigurationArgsDict']]]] guard_configurations: The guard configurations for the Custom Model.
        :param pulumi.Input[bool] is_proxy: Flag indicating if the Custom Model is a proxy model.
        :param pulumi.Input[str] language: The language used to build the Custom Model.
        :param pulumi.Input[int] memory_mb: The memory in MB for the Custom Model.
        :param pulumi.Input[str] name: The name of the Custom Model.
        :param pulumi.Input[str] negative_class_label: The negative class label of the Custom Model.
        :param pulumi.Input[str] network_access: The network access for the Custom Model.
        :param pulumi.Input[Union['CustomModelOverallModerationConfigurationArgs', 'CustomModelOverallModerationConfigurationArgsDict']] overall_moderation_configuration: The overall moderation configuration for the Custom Model.
        :param pulumi.Input[str] positive_class_label: The positive class label of the Custom Model.
        :param pulumi.Input[float] prediction_threshold: The prediction threshold of the Custom Model.
        :param pulumi.Input[int] replicas: The replicas for the Custom Model.
        :param pulumi.Input[str] resource_bundle_id: A single identifier that represents a bundle of resources: Memory, CPU, GPU, etc.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomModelRuntimeParameterValueArgs', 'CustomModelRuntimeParameterValueArgsDict']]]] runtime_parameter_values: The runtime parameter values for the Custom Model.
        :param pulumi.Input[str] source_llm_blueprint_id: The ID of the source LLM Blueprint for the Custom Model.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomModelSourceRemoteRepositoryArgs', 'CustomModelSourceRemoteRepositoryArgsDict']]]] source_remote_repositories: The source remote repositories for the Custom Model.
        :param pulumi.Input[str] target_name: The target name of the Custom Model.
        :param pulumi.Input[str] target_type: The target type of the Custom Model.
        :param pulumi.Input[str] training_data_partition_column: The name of the partition column in the training dataset assigned to the Custom Model.
        :param pulumi.Input[str] training_dataset_id: The ID of the training dataset assigned to the Custom Model.
        :param pulumi.Input[str] training_dataset_name: The name of the training dataset assigned to the Custom Model.
        :param pulumi.Input[str] training_dataset_version_id: The version ID of the training dataset assigned to the Custom Model.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] use_case_ids: The list of Use Case IDs to add the Custom Model version to.
        :param pulumi.Input[str] version_id: The ID of the latest Custom Model version.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomModelState.__new__(_CustomModelState)

        __props__.__dict__["base_environment_id"] = base_environment_id
        __props__.__dict__["base_environment_version_id"] = base_environment_version_id
        __props__.__dict__["class_labels"] = class_labels
        __props__.__dict__["class_labels_file"] = class_labels_file
        __props__.__dict__["deployments_count"] = deployments_count
        __props__.__dict__["description"] = description
        __props__.__dict__["files"] = files
        __props__.__dict__["files_hashes"] = files_hashes
        __props__.__dict__["folder_path"] = folder_path
        __props__.__dict__["folder_path_hash"] = folder_path_hash
        __props__.__dict__["guard_configurations"] = guard_configurations
        __props__.__dict__["is_proxy"] = is_proxy
        __props__.__dict__["language"] = language
        __props__.__dict__["memory_mb"] = memory_mb
        __props__.__dict__["name"] = name
        __props__.__dict__["negative_class_label"] = negative_class_label
        __props__.__dict__["network_access"] = network_access
        __props__.__dict__["overall_moderation_configuration"] = overall_moderation_configuration
        __props__.__dict__["positive_class_label"] = positive_class_label
        __props__.__dict__["prediction_threshold"] = prediction_threshold
        __props__.__dict__["replicas"] = replicas
        __props__.__dict__["resource_bundle_id"] = resource_bundle_id
        __props__.__dict__["runtime_parameter_values"] = runtime_parameter_values
        __props__.__dict__["source_llm_blueprint_id"] = source_llm_blueprint_id
        __props__.__dict__["source_remote_repositories"] = source_remote_repositories
        __props__.__dict__["target_name"] = target_name
        __props__.__dict__["target_type"] = target_type
        __props__.__dict__["training_data_partition_column"] = training_data_partition_column
        __props__.__dict__["training_dataset_id"] = training_dataset_id
        __props__.__dict__["training_dataset_name"] = training_dataset_name
        __props__.__dict__["training_dataset_version_id"] = training_dataset_version_id
        __props__.__dict__["use_case_ids"] = use_case_ids
        __props__.__dict__["version_id"] = version_id
        return CustomModel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="baseEnvironmentId")
    def base_environment_id(self) -> pulumi.Output[str]:
        """
        The ID of the base environment for the Custom Model.
        """
        return pulumi.get(self, "base_environment_id")

    @property
    @pulumi.getter(name="baseEnvironmentVersionId")
    def base_environment_version_id(self) -> pulumi.Output[str]:
        """
        The ID of the base environment version for the Custom Model.
        """
        return pulumi.get(self, "base_environment_version_id")

    @property
    @pulumi.getter(name="classLabels")
    def class_labels(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Class labels for multiclass classification. Cannot be used with class*labels*file.
        """
        return pulumi.get(self, "class_labels")

    @property
    @pulumi.getter(name="classLabelsFile")
    def class_labels_file(self) -> pulumi.Output[Optional[str]]:
        """
        Path to file containing newline separated class labels for multiclass classification. Cannot be used with class_labels.
        """
        return pulumi.get(self, "class_labels_file")

    @property
    @pulumi.getter(name="deploymentsCount")
    def deployments_count(self) -> pulumi.Output[int]:
        """
        The number of deployments for the Custom Model.
        """
        return pulumi.get(self, "deployments_count")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the Custom Model.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def files(self) -> pulumi.Output[Optional[Any]]:
        """
        The list of tuples, where values in each tuple are the local filesystem path and the path the file should be placed in the Custom Model. If list is of strings, then basenames will be used for tuples.
        """
        return pulumi.get(self, "files")

    @property
    @pulumi.getter(name="filesHashes")
    def files_hashes(self) -> pulumi.Output[Sequence[str]]:
        """
        The hash of file contents for each file in files.
        """
        return pulumi.get(self, "files_hashes")

    @property
    @pulumi.getter(name="folderPath")
    def folder_path(self) -> pulumi.Output[Optional[str]]:
        """
        The path to a folder containing files to build the Custom Model. Each file in the folder is uploaded under path relative to a folder path.
        """
        return pulumi.get(self, "folder_path")

    @property
    @pulumi.getter(name="folderPathHash")
    def folder_path_hash(self) -> pulumi.Output[str]:
        """
        The hash of the folder path contents.
        """
        return pulumi.get(self, "folder_path_hash")

    @property
    @pulumi.getter(name="guardConfigurations")
    def guard_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.CustomModelGuardConfiguration']]]:
        """
        The guard configurations for the Custom Model.
        """
        return pulumi.get(self, "guard_configurations")

    @property
    @pulumi.getter(name="isProxy")
    def is_proxy(self) -> pulumi.Output[bool]:
        """
        Flag indicating if the Custom Model is a proxy model.
        """
        return pulumi.get(self, "is_proxy")

    @property
    @pulumi.getter
    def language(self) -> pulumi.Output[Optional[str]]:
        """
        The language used to build the Custom Model.
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter(name="memoryMb")
    def memory_mb(self) -> pulumi.Output[int]:
        """
        The memory in MB for the Custom Model.
        """
        return pulumi.get(self, "memory_mb")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Custom Model.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="negativeClassLabel")
    def negative_class_label(self) -> pulumi.Output[str]:
        """
        The negative class label of the Custom Model.
        """
        return pulumi.get(self, "negative_class_label")

    @property
    @pulumi.getter(name="networkAccess")
    def network_access(self) -> pulumi.Output[str]:
        """
        The network access for the Custom Model.
        """
        return pulumi.get(self, "network_access")

    @property
    @pulumi.getter(name="overallModerationConfiguration")
    def overall_moderation_configuration(self) -> pulumi.Output[Optional['outputs.CustomModelOverallModerationConfiguration']]:
        """
        The overall moderation configuration for the Custom Model.
        """
        return pulumi.get(self, "overall_moderation_configuration")

    @property
    @pulumi.getter(name="positiveClassLabel")
    def positive_class_label(self) -> pulumi.Output[str]:
        """
        The positive class label of the Custom Model.
        """
        return pulumi.get(self, "positive_class_label")

    @property
    @pulumi.getter(name="predictionThreshold")
    def prediction_threshold(self) -> pulumi.Output[float]:
        """
        The prediction threshold of the Custom Model.
        """
        return pulumi.get(self, "prediction_threshold")

    @property
    @pulumi.getter
    def replicas(self) -> pulumi.Output[int]:
        """
        The replicas for the Custom Model.
        """
        return pulumi.get(self, "replicas")

    @property
    @pulumi.getter(name="resourceBundleId")
    def resource_bundle_id(self) -> pulumi.Output[Optional[str]]:
        """
        A single identifier that represents a bundle of resources: Memory, CPU, GPU, etc.
        """
        return pulumi.get(self, "resource_bundle_id")

    @property
    @pulumi.getter(name="runtimeParameterValues")
    def runtime_parameter_values(self) -> pulumi.Output[Sequence['outputs.CustomModelRuntimeParameterValue']]:
        """
        The runtime parameter values for the Custom Model.
        """
        return pulumi.get(self, "runtime_parameter_values")

    @property
    @pulumi.getter(name="sourceLlmBlueprintId")
    def source_llm_blueprint_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the source LLM Blueprint for the Custom Model.
        """
        return pulumi.get(self, "source_llm_blueprint_id")

    @property
    @pulumi.getter(name="sourceRemoteRepositories")
    def source_remote_repositories(self) -> pulumi.Output[Optional[Sequence['outputs.CustomModelSourceRemoteRepository']]]:
        """
        The source remote repositories for the Custom Model.
        """
        return pulumi.get(self, "source_remote_repositories")

    @property
    @pulumi.getter(name="targetName")
    def target_name(self) -> pulumi.Output[str]:
        """
        The target name of the Custom Model.
        """
        return pulumi.get(self, "target_name")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> pulumi.Output[str]:
        """
        The target type of the Custom Model.
        """
        return pulumi.get(self, "target_type")

    @property
    @pulumi.getter(name="trainingDataPartitionColumn")
    def training_data_partition_column(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the partition column in the training dataset assigned to the Custom Model.
        """
        return pulumi.get(self, "training_data_partition_column")

    @property
    @pulumi.getter(name="trainingDatasetId")
    def training_dataset_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the training dataset assigned to the Custom Model.
        """
        return pulumi.get(self, "training_dataset_id")

    @property
    @pulumi.getter(name="trainingDatasetName")
    def training_dataset_name(self) -> pulumi.Output[str]:
        """
        The name of the training dataset assigned to the Custom Model.
        """
        return pulumi.get(self, "training_dataset_name")

    @property
    @pulumi.getter(name="trainingDatasetVersionId")
    def training_dataset_version_id(self) -> pulumi.Output[str]:
        """
        The version ID of the training dataset assigned to the Custom Model.
        """
        return pulumi.get(self, "training_dataset_version_id")

    @property
    @pulumi.getter(name="useCaseIds")
    def use_case_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of Use Case IDs to add the Custom Model version to.
        """
        return pulumi.get(self, "use_case_ids")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[str]:
        """
        The ID of the latest Custom Model version.
        """
        return pulumi.get(self, "version_id")

