# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CustomMetricJobArgs', 'CustomMetricJob']

@pulumi.input_type
class CustomMetricJobArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 directionality: Optional[pulumi.Input[str]] = None,
                 egress_network_policy: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 environment_version_id: Optional[pulumi.Input[str]] = None,
                 files: Optional[Any] = None,
                 folder_path: Optional[pulumi.Input[str]] = None,
                 is_model_specific: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resource_bundle_id: Optional[pulumi.Input[str]] = None,
                 runtime_parameter_values: Optional[pulumi.Input[Sequence[pulumi.Input['CustomMetricJobRuntimeParameterValueArgs']]]] = None,
                 time_step: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 units: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CustomMetricJob resource.
        :param pulumi.Input[str] description: The description of the Custom Metric Job.
        :param pulumi.Input[str] directionality: The directionality of the Custom Metric.
        :param pulumi.Input[str] egress_network_policy: The egress network policy for the Job.
        :param pulumi.Input[str] environment_id: The ID of the environment to use with the Job.
        :param pulumi.Input[str] environment_version_id: The ID of the environment version to use with the Job.
        :param Any files: The list of tuples, where values in each tuple are the local filesystem path and the path the file should be placed in the Job. If list is of strings, then basenames will be used for tuples.
        :param pulumi.Input[str] folder_path: The path to a folder containing files to be uploaded. Each file in the folder is uploaded under path relative to a folder path.
        :param pulumi.Input[bool] is_model_specific: Determines whether the metric is related to the model or deployment.
        :param pulumi.Input[str] name: The name of the Custom Metric Job.
        :param pulumi.Input[str] resource_bundle_id: A single identifier that represents a bundle of resources: Memory, CPU, GPU, etc.
        :param pulumi.Input[Sequence[pulumi.Input['CustomMetricJobRuntimeParameterValueArgs']]] runtime_parameter_values: Additional parameters to be injected into a Job at runtime.
        :param pulumi.Input[str] time_step: Custom metric time bucket size.
        :param pulumi.Input[str] type: The aggregation type of the custom metric.
        :param pulumi.Input[str] units: The units, or the y-axis label, of the given custom metric.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if directionality is not None:
            pulumi.set(__self__, "directionality", directionality)
        if egress_network_policy is not None:
            pulumi.set(__self__, "egress_network_policy", egress_network_policy)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if environment_version_id is not None:
            pulumi.set(__self__, "environment_version_id", environment_version_id)
        if files is not None:
            pulumi.set(__self__, "files", files)
        if folder_path is not None:
            pulumi.set(__self__, "folder_path", folder_path)
        if is_model_specific is not None:
            pulumi.set(__self__, "is_model_specific", is_model_specific)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_bundle_id is not None:
            pulumi.set(__self__, "resource_bundle_id", resource_bundle_id)
        if runtime_parameter_values is not None:
            pulumi.set(__self__, "runtime_parameter_values", runtime_parameter_values)
        if time_step is not None:
            pulumi.set(__self__, "time_step", time_step)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if units is not None:
            pulumi.set(__self__, "units", units)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Custom Metric Job.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def directionality(self) -> Optional[pulumi.Input[str]]:
        """
        The directionality of the Custom Metric.
        """
        return pulumi.get(self, "directionality")

    @directionality.setter
    def directionality(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "directionality", value)

    @property
    @pulumi.getter(name="egressNetworkPolicy")
    def egress_network_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The egress network policy for the Job.
        """
        return pulumi.get(self, "egress_network_policy")

    @egress_network_policy.setter
    def egress_network_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "egress_network_policy", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the environment to use with the Job.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="environmentVersionId")
    def environment_version_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the environment version to use with the Job.
        """
        return pulumi.get(self, "environment_version_id")

    @environment_version_id.setter
    def environment_version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_version_id", value)

    @property
    @pulumi.getter
    def files(self) -> Optional[Any]:
        """
        The list of tuples, where values in each tuple are the local filesystem path and the path the file should be placed in the Job. If list is of strings, then basenames will be used for tuples.
        """
        return pulumi.get(self, "files")

    @files.setter
    def files(self, value: Optional[Any]):
        pulumi.set(self, "files", value)

    @property
    @pulumi.getter(name="folderPath")
    def folder_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to a folder containing files to be uploaded. Each file in the folder is uploaded under path relative to a folder path.
        """
        return pulumi.get(self, "folder_path")

    @folder_path.setter
    def folder_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_path", value)

    @property
    @pulumi.getter(name="isModelSpecific")
    def is_model_specific(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether the metric is related to the model or deployment.
        """
        return pulumi.get(self, "is_model_specific")

    @is_model_specific.setter
    def is_model_specific(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_model_specific", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Custom Metric Job.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceBundleId")
    def resource_bundle_id(self) -> Optional[pulumi.Input[str]]:
        """
        A single identifier that represents a bundle of resources: Memory, CPU, GPU, etc.
        """
        return pulumi.get(self, "resource_bundle_id")

    @resource_bundle_id.setter
    def resource_bundle_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_bundle_id", value)

    @property
    @pulumi.getter(name="runtimeParameterValues")
    def runtime_parameter_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomMetricJobRuntimeParameterValueArgs']]]]:
        """
        Additional parameters to be injected into a Job at runtime.
        """
        return pulumi.get(self, "runtime_parameter_values")

    @runtime_parameter_values.setter
    def runtime_parameter_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomMetricJobRuntimeParameterValueArgs']]]]):
        pulumi.set(self, "runtime_parameter_values", value)

    @property
    @pulumi.getter(name="timeStep")
    def time_step(self) -> Optional[pulumi.Input[str]]:
        """
        Custom metric time bucket size.
        """
        return pulumi.get(self, "time_step")

    @time_step.setter
    def time_step(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_step", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The aggregation type of the custom metric.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def units(self) -> Optional[pulumi.Input[str]]:
        """
        The units, or the y-axis label, of the given custom metric.
        """
        return pulumi.get(self, "units")

    @units.setter
    def units(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "units", value)


@pulumi.input_type
class _CustomMetricJobState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 directionality: Optional[pulumi.Input[str]] = None,
                 egress_network_policy: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 environment_version_id: Optional[pulumi.Input[str]] = None,
                 files: Optional[Any] = None,
                 files_hashes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 folder_path: Optional[pulumi.Input[str]] = None,
                 folder_path_hash: Optional[pulumi.Input[str]] = None,
                 is_model_specific: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resource_bundle_id: Optional[pulumi.Input[str]] = None,
                 runtime_parameter_values: Optional[pulumi.Input[Sequence[pulumi.Input['CustomMetricJobRuntimeParameterValueArgs']]]] = None,
                 time_step: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 units: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CustomMetricJob resources.
        :param pulumi.Input[str] description: The description of the Custom Metric Job.
        :param pulumi.Input[str] directionality: The directionality of the Custom Metric.
        :param pulumi.Input[str] egress_network_policy: The egress network policy for the Job.
        :param pulumi.Input[str] environment_id: The ID of the environment to use with the Job.
        :param pulumi.Input[str] environment_version_id: The ID of the environment version to use with the Job.
        :param Any files: The list of tuples, where values in each tuple are the local filesystem path and the path the file should be placed in the Job. If list is of strings, then basenames will be used for tuples.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] files_hashes: The hash of file contents for each file in files.
        :param pulumi.Input[str] folder_path: The path to a folder containing files to be uploaded. Each file in the folder is uploaded under path relative to a folder path.
        :param pulumi.Input[str] folder_path_hash: The hash of the folder path contents.
        :param pulumi.Input[bool] is_model_specific: Determines whether the metric is related to the model or deployment.
        :param pulumi.Input[str] name: The name of the Custom Metric Job.
        :param pulumi.Input[str] resource_bundle_id: A single identifier that represents a bundle of resources: Memory, CPU, GPU, etc.
        :param pulumi.Input[Sequence[pulumi.Input['CustomMetricJobRuntimeParameterValueArgs']]] runtime_parameter_values: Additional parameters to be injected into a Job at runtime.
        :param pulumi.Input[str] time_step: Custom metric time bucket size.
        :param pulumi.Input[str] type: The aggregation type of the custom metric.
        :param pulumi.Input[str] units: The units, or the y-axis label, of the given custom metric.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if directionality is not None:
            pulumi.set(__self__, "directionality", directionality)
        if egress_network_policy is not None:
            pulumi.set(__self__, "egress_network_policy", egress_network_policy)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if environment_version_id is not None:
            pulumi.set(__self__, "environment_version_id", environment_version_id)
        if files is not None:
            pulumi.set(__self__, "files", files)
        if files_hashes is not None:
            pulumi.set(__self__, "files_hashes", files_hashes)
        if folder_path is not None:
            pulumi.set(__self__, "folder_path", folder_path)
        if folder_path_hash is not None:
            pulumi.set(__self__, "folder_path_hash", folder_path_hash)
        if is_model_specific is not None:
            pulumi.set(__self__, "is_model_specific", is_model_specific)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_bundle_id is not None:
            pulumi.set(__self__, "resource_bundle_id", resource_bundle_id)
        if runtime_parameter_values is not None:
            pulumi.set(__self__, "runtime_parameter_values", runtime_parameter_values)
        if time_step is not None:
            pulumi.set(__self__, "time_step", time_step)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if units is not None:
            pulumi.set(__self__, "units", units)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Custom Metric Job.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def directionality(self) -> Optional[pulumi.Input[str]]:
        """
        The directionality of the Custom Metric.
        """
        return pulumi.get(self, "directionality")

    @directionality.setter
    def directionality(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "directionality", value)

    @property
    @pulumi.getter(name="egressNetworkPolicy")
    def egress_network_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The egress network policy for the Job.
        """
        return pulumi.get(self, "egress_network_policy")

    @egress_network_policy.setter
    def egress_network_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "egress_network_policy", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the environment to use with the Job.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="environmentVersionId")
    def environment_version_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the environment version to use with the Job.
        """
        return pulumi.get(self, "environment_version_id")

    @environment_version_id.setter
    def environment_version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_version_id", value)

    @property
    @pulumi.getter
    def files(self) -> Optional[Any]:
        """
        The list of tuples, where values in each tuple are the local filesystem path and the path the file should be placed in the Job. If list is of strings, then basenames will be used for tuples.
        """
        return pulumi.get(self, "files")

    @files.setter
    def files(self, value: Optional[Any]):
        pulumi.set(self, "files", value)

    @property
    @pulumi.getter(name="filesHashes")
    def files_hashes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The hash of file contents for each file in files.
        """
        return pulumi.get(self, "files_hashes")

    @files_hashes.setter
    def files_hashes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "files_hashes", value)

    @property
    @pulumi.getter(name="folderPath")
    def folder_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to a folder containing files to be uploaded. Each file in the folder is uploaded under path relative to a folder path.
        """
        return pulumi.get(self, "folder_path")

    @folder_path.setter
    def folder_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_path", value)

    @property
    @pulumi.getter(name="folderPathHash")
    def folder_path_hash(self) -> Optional[pulumi.Input[str]]:
        """
        The hash of the folder path contents.
        """
        return pulumi.get(self, "folder_path_hash")

    @folder_path_hash.setter
    def folder_path_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_path_hash", value)

    @property
    @pulumi.getter(name="isModelSpecific")
    def is_model_specific(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether the metric is related to the model or deployment.
        """
        return pulumi.get(self, "is_model_specific")

    @is_model_specific.setter
    def is_model_specific(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_model_specific", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Custom Metric Job.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceBundleId")
    def resource_bundle_id(self) -> Optional[pulumi.Input[str]]:
        """
        A single identifier that represents a bundle of resources: Memory, CPU, GPU, etc.
        """
        return pulumi.get(self, "resource_bundle_id")

    @resource_bundle_id.setter
    def resource_bundle_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_bundle_id", value)

    @property
    @pulumi.getter(name="runtimeParameterValues")
    def runtime_parameter_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomMetricJobRuntimeParameterValueArgs']]]]:
        """
        Additional parameters to be injected into a Job at runtime.
        """
        return pulumi.get(self, "runtime_parameter_values")

    @runtime_parameter_values.setter
    def runtime_parameter_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomMetricJobRuntimeParameterValueArgs']]]]):
        pulumi.set(self, "runtime_parameter_values", value)

    @property
    @pulumi.getter(name="timeStep")
    def time_step(self) -> Optional[pulumi.Input[str]]:
        """
        Custom metric time bucket size.
        """
        return pulumi.get(self, "time_step")

    @time_step.setter
    def time_step(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_step", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The aggregation type of the custom metric.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def units(self) -> Optional[pulumi.Input[str]]:
        """
        The units, or the y-axis label, of the given custom metric.
        """
        return pulumi.get(self, "units")

    @units.setter
    def units(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "units", value)


class CustomMetricJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 directionality: Optional[pulumi.Input[str]] = None,
                 egress_network_policy: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 environment_version_id: Optional[pulumi.Input[str]] = None,
                 files: Optional[Any] = None,
                 folder_path: Optional[pulumi.Input[str]] = None,
                 is_model_specific: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resource_bundle_id: Optional[pulumi.Input[str]] = None,
                 runtime_parameter_values: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomMetricJobRuntimeParameterValueArgs', 'CustomMetricJobRuntimeParameterValueArgsDict']]]]] = None,
                 time_step: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 units: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Custom Job

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datarobot as datarobot

        example = datarobot.CustomMetricJob("example",
            files=[
                "file1.py",
                "file2.py",
            ],
            environment_id="65f9b27eab986d30d4c64268",
            description="Example Custom Metric Job Description",
            runtime_parameter_values=[{
                "key": "EXAMPLE_PARAM",
                "type": "string",
                "value": "val",
            }],
            egress_network_policy="none",
            resource_bundle_id="cpu.micro",
            units="count",
            directionality="lowerIsBetter",
            type="sum",
            is_model_specific=False)
        pulumi.export("exampleId", example.id)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the Custom Metric Job.
        :param pulumi.Input[str] directionality: The directionality of the Custom Metric.
        :param pulumi.Input[str] egress_network_policy: The egress network policy for the Job.
        :param pulumi.Input[str] environment_id: The ID of the environment to use with the Job.
        :param pulumi.Input[str] environment_version_id: The ID of the environment version to use with the Job.
        :param Any files: The list of tuples, where values in each tuple are the local filesystem path and the path the file should be placed in the Job. If list is of strings, then basenames will be used for tuples.
        :param pulumi.Input[str] folder_path: The path to a folder containing files to be uploaded. Each file in the folder is uploaded under path relative to a folder path.
        :param pulumi.Input[bool] is_model_specific: Determines whether the metric is related to the model or deployment.
        :param pulumi.Input[str] name: The name of the Custom Metric Job.
        :param pulumi.Input[str] resource_bundle_id: A single identifier that represents a bundle of resources: Memory, CPU, GPU, etc.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomMetricJobRuntimeParameterValueArgs', 'CustomMetricJobRuntimeParameterValueArgsDict']]]] runtime_parameter_values: Additional parameters to be injected into a Job at runtime.
        :param pulumi.Input[str] time_step: Custom metric time bucket size.
        :param pulumi.Input[str] type: The aggregation type of the custom metric.
        :param pulumi.Input[str] units: The units, or the y-axis label, of the given custom metric.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CustomMetricJobArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Custom Job

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datarobot as datarobot

        example = datarobot.CustomMetricJob("example",
            files=[
                "file1.py",
                "file2.py",
            ],
            environment_id="65f9b27eab986d30d4c64268",
            description="Example Custom Metric Job Description",
            runtime_parameter_values=[{
                "key": "EXAMPLE_PARAM",
                "type": "string",
                "value": "val",
            }],
            egress_network_policy="none",
            resource_bundle_id="cpu.micro",
            units="count",
            directionality="lowerIsBetter",
            type="sum",
            is_model_specific=False)
        pulumi.export("exampleId", example.id)
        ```

        :param str resource_name: The name of the resource.
        :param CustomMetricJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomMetricJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 directionality: Optional[pulumi.Input[str]] = None,
                 egress_network_policy: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 environment_version_id: Optional[pulumi.Input[str]] = None,
                 files: Optional[Any] = None,
                 folder_path: Optional[pulumi.Input[str]] = None,
                 is_model_specific: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resource_bundle_id: Optional[pulumi.Input[str]] = None,
                 runtime_parameter_values: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomMetricJobRuntimeParameterValueArgs', 'CustomMetricJobRuntimeParameterValueArgsDict']]]]] = None,
                 time_step: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 units: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomMetricJobArgs.__new__(CustomMetricJobArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["directionality"] = directionality
            __props__.__dict__["egress_network_policy"] = egress_network_policy
            __props__.__dict__["environment_id"] = environment_id
            __props__.__dict__["environment_version_id"] = environment_version_id
            __props__.__dict__["files"] = files
            __props__.__dict__["folder_path"] = folder_path
            __props__.__dict__["is_model_specific"] = is_model_specific
            __props__.__dict__["name"] = name
            __props__.__dict__["resource_bundle_id"] = resource_bundle_id
            __props__.__dict__["runtime_parameter_values"] = runtime_parameter_values
            __props__.__dict__["time_step"] = time_step
            __props__.__dict__["type"] = type
            __props__.__dict__["units"] = units
            __props__.__dict__["files_hashes"] = None
            __props__.__dict__["folder_path_hash"] = None
        super(CustomMetricJob, __self__).__init__(
            'datarobot:index/customMetricJob:CustomMetricJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            directionality: Optional[pulumi.Input[str]] = None,
            egress_network_policy: Optional[pulumi.Input[str]] = None,
            environment_id: Optional[pulumi.Input[str]] = None,
            environment_version_id: Optional[pulumi.Input[str]] = None,
            files: Optional[Any] = None,
            files_hashes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            folder_path: Optional[pulumi.Input[str]] = None,
            folder_path_hash: Optional[pulumi.Input[str]] = None,
            is_model_specific: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            resource_bundle_id: Optional[pulumi.Input[str]] = None,
            runtime_parameter_values: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomMetricJobRuntimeParameterValueArgs', 'CustomMetricJobRuntimeParameterValueArgsDict']]]]] = None,
            time_step: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            units: Optional[pulumi.Input[str]] = None) -> 'CustomMetricJob':
        """
        Get an existing CustomMetricJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the Custom Metric Job.
        :param pulumi.Input[str] directionality: The directionality of the Custom Metric.
        :param pulumi.Input[str] egress_network_policy: The egress network policy for the Job.
        :param pulumi.Input[str] environment_id: The ID of the environment to use with the Job.
        :param pulumi.Input[str] environment_version_id: The ID of the environment version to use with the Job.
        :param Any files: The list of tuples, where values in each tuple are the local filesystem path and the path the file should be placed in the Job. If list is of strings, then basenames will be used for tuples.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] files_hashes: The hash of file contents for each file in files.
        :param pulumi.Input[str] folder_path: The path to a folder containing files to be uploaded. Each file in the folder is uploaded under path relative to a folder path.
        :param pulumi.Input[str] folder_path_hash: The hash of the folder path contents.
        :param pulumi.Input[bool] is_model_specific: Determines whether the metric is related to the model or deployment.
        :param pulumi.Input[str] name: The name of the Custom Metric Job.
        :param pulumi.Input[str] resource_bundle_id: A single identifier that represents a bundle of resources: Memory, CPU, GPU, etc.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomMetricJobRuntimeParameterValueArgs', 'CustomMetricJobRuntimeParameterValueArgsDict']]]] runtime_parameter_values: Additional parameters to be injected into a Job at runtime.
        :param pulumi.Input[str] time_step: Custom metric time bucket size.
        :param pulumi.Input[str] type: The aggregation type of the custom metric.
        :param pulumi.Input[str] units: The units, or the y-axis label, of the given custom metric.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomMetricJobState.__new__(_CustomMetricJobState)

        __props__.__dict__["description"] = description
        __props__.__dict__["directionality"] = directionality
        __props__.__dict__["egress_network_policy"] = egress_network_policy
        __props__.__dict__["environment_id"] = environment_id
        __props__.__dict__["environment_version_id"] = environment_version_id
        __props__.__dict__["files"] = files
        __props__.__dict__["files_hashes"] = files_hashes
        __props__.__dict__["folder_path"] = folder_path
        __props__.__dict__["folder_path_hash"] = folder_path_hash
        __props__.__dict__["is_model_specific"] = is_model_specific
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_bundle_id"] = resource_bundle_id
        __props__.__dict__["runtime_parameter_values"] = runtime_parameter_values
        __props__.__dict__["time_step"] = time_step
        __props__.__dict__["type"] = type
        __props__.__dict__["units"] = units
        return CustomMetricJob(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the Custom Metric Job.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def directionality(self) -> pulumi.Output[str]:
        """
        The directionality of the Custom Metric.
        """
        return pulumi.get(self, "directionality")

    @property
    @pulumi.getter(name="egressNetworkPolicy")
    def egress_network_policy(self) -> pulumi.Output[str]:
        """
        The egress network policy for the Job.
        """
        return pulumi.get(self, "egress_network_policy")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[str]:
        """
        The ID of the environment to use with the Job.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="environmentVersionId")
    def environment_version_id(self) -> pulumi.Output[str]:
        """
        The ID of the environment version to use with the Job.
        """
        return pulumi.get(self, "environment_version_id")

    @property
    @pulumi.getter
    def files(self) -> pulumi.Output[Optional[Any]]:
        """
        The list of tuples, where values in each tuple are the local filesystem path and the path the file should be placed in the Job. If list is of strings, then basenames will be used for tuples.
        """
        return pulumi.get(self, "files")

    @property
    @pulumi.getter(name="filesHashes")
    def files_hashes(self) -> pulumi.Output[Sequence[str]]:
        """
        The hash of file contents for each file in files.
        """
        return pulumi.get(self, "files_hashes")

    @property
    @pulumi.getter(name="folderPath")
    def folder_path(self) -> pulumi.Output[Optional[str]]:
        """
        The path to a folder containing files to be uploaded. Each file in the folder is uploaded under path relative to a folder path.
        """
        return pulumi.get(self, "folder_path")

    @property
    @pulumi.getter(name="folderPathHash")
    def folder_path_hash(self) -> pulumi.Output[str]:
        """
        The hash of the folder path contents.
        """
        return pulumi.get(self, "folder_path_hash")

    @property
    @pulumi.getter(name="isModelSpecific")
    def is_model_specific(self) -> pulumi.Output[bool]:
        """
        Determines whether the metric is related to the model or deployment.
        """
        return pulumi.get(self, "is_model_specific")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Custom Metric Job.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceBundleId")
    def resource_bundle_id(self) -> pulumi.Output[Optional[str]]:
        """
        A single identifier that represents a bundle of resources: Memory, CPU, GPU, etc.
        """
        return pulumi.get(self, "resource_bundle_id")

    @property
    @pulumi.getter(name="runtimeParameterValues")
    def runtime_parameter_values(self) -> pulumi.Output[Sequence['outputs.CustomMetricJobRuntimeParameterValue']]:
        """
        Additional parameters to be injected into a Job at runtime.
        """
        return pulumi.get(self, "runtime_parameter_values")

    @property
    @pulumi.getter(name="timeStep")
    def time_step(self) -> pulumi.Output[str]:
        """
        Custom metric time bucket size.
        """
        return pulumi.get(self, "time_step")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The aggregation type of the custom metric.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def units(self) -> pulumi.Output[str]:
        """
        The units, or the y-axis label, of the given custom metric.
        """
        return pulumi.get(self, "units")

