# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CustomMetricFromJobArgs', 'CustomMetricFromJob']

@pulumi.input_type
class CustomMetricFromJobArgs:
    def __init__(__self__, *,
                 custom_job_id: pulumi.Input[str],
                 deployment_id: pulumi.Input[str],
                 baseline_value: Optional[pulumi.Input[float]] = None,
                 batch: Optional[pulumi.Input['CustomMetricFromJobBatchArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameter_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['CustomMetricFromJobParameterOverrideArgs']]]] = None,
                 sample_count: Optional[pulumi.Input['CustomMetricFromJobSampleCountArgs']] = None,
                 schedule: Optional[pulumi.Input['CustomMetricFromJobScheduleArgs']] = None,
                 timestamp: Optional[pulumi.Input['CustomMetricFromJobTimestampArgs']] = None,
                 value: Optional[pulumi.Input['CustomMetricFromJobValueArgs']] = None):
        """
        The set of arguments for constructing a CustomMetricFromJob resource.
        :param pulumi.Input[str] custom_job_id: ID of the Custom Job.
        :param pulumi.Input[str] deployment_id: ID of the Deployment.
        :param pulumi.Input[float] baseline_value: Baseline value for the metric.
        :param pulumi.Input['CustomMetricFromJobBatchArgs'] batch: Batch ID source when reading values from columnar dataset like a file.
        :param pulumi.Input[str] description: Description of the metric.
        :param pulumi.Input[str] name: Name of the metric.
        :param pulumi.Input[Sequence[pulumi.Input['CustomMetricFromJobParameterOverrideArgs']]] parameter_overrides: Additional parameters to be injected into the Metric Job at runtime.
        :param pulumi.Input['CustomMetricFromJobSampleCountArgs'] sample_count: Points to a weight column if users provide pre-aggregated metric values. Used with columnar datasets.
        :param pulumi.Input['CustomMetricFromJobScheduleArgs'] schedule: Defines at what intervals the metric job should run.
        :param pulumi.Input['CustomMetricFromJobTimestampArgs'] timestamp: Timestamp spoofing when reading values from file, like dataset. By default, we replicate pd.to_datetime formatting behaviour.
        :param pulumi.Input['CustomMetricFromJobValueArgs'] value: Value source when reading values from columnar dataset like a file.
        """
        pulumi.set(__self__, "custom_job_id", custom_job_id)
        pulumi.set(__self__, "deployment_id", deployment_id)
        if baseline_value is not None:
            pulumi.set(__self__, "baseline_value", baseline_value)
        if batch is not None:
            pulumi.set(__self__, "batch", batch)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameter_overrides is not None:
            pulumi.set(__self__, "parameter_overrides", parameter_overrides)
        if sample_count is not None:
            pulumi.set(__self__, "sample_count", sample_count)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if timestamp is not None:
            pulumi.set(__self__, "timestamp", timestamp)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="customJobId")
    def custom_job_id(self) -> pulumi.Input[str]:
        """
        ID of the Custom Job.
        """
        return pulumi.get(self, "custom_job_id")

    @custom_job_id.setter
    def custom_job_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "custom_job_id", value)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> pulumi.Input[str]:
        """
        ID of the Deployment.
        """
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "deployment_id", value)

    @property
    @pulumi.getter(name="baselineValue")
    def baseline_value(self) -> Optional[pulumi.Input[float]]:
        """
        Baseline value for the metric.
        """
        return pulumi.get(self, "baseline_value")

    @baseline_value.setter
    def baseline_value(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "baseline_value", value)

    @property
    @pulumi.getter
    def batch(self) -> Optional[pulumi.Input['CustomMetricFromJobBatchArgs']]:
        """
        Batch ID source when reading values from columnar dataset like a file.
        """
        return pulumi.get(self, "batch")

    @batch.setter
    def batch(self, value: Optional[pulumi.Input['CustomMetricFromJobBatchArgs']]):
        pulumi.set(self, "batch", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the metric.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the metric.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parameterOverrides")
    def parameter_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomMetricFromJobParameterOverrideArgs']]]]:
        """
        Additional parameters to be injected into the Metric Job at runtime.
        """
        return pulumi.get(self, "parameter_overrides")

    @parameter_overrides.setter
    def parameter_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomMetricFromJobParameterOverrideArgs']]]]):
        pulumi.set(self, "parameter_overrides", value)

    @property
    @pulumi.getter(name="sampleCount")
    def sample_count(self) -> Optional[pulumi.Input['CustomMetricFromJobSampleCountArgs']]:
        """
        Points to a weight column if users provide pre-aggregated metric values. Used with columnar datasets.
        """
        return pulumi.get(self, "sample_count")

    @sample_count.setter
    def sample_count(self, value: Optional[pulumi.Input['CustomMetricFromJobSampleCountArgs']]):
        pulumi.set(self, "sample_count", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['CustomMetricFromJobScheduleArgs']]:
        """
        Defines at what intervals the metric job should run.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['CustomMetricFromJobScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter
    def timestamp(self) -> Optional[pulumi.Input['CustomMetricFromJobTimestampArgs']]:
        """
        Timestamp spoofing when reading values from file, like dataset. By default, we replicate pd.to_datetime formatting behaviour.
        """
        return pulumi.get(self, "timestamp")

    @timestamp.setter
    def timestamp(self, value: Optional[pulumi.Input['CustomMetricFromJobTimestampArgs']]):
        pulumi.set(self, "timestamp", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input['CustomMetricFromJobValueArgs']]:
        """
        Value source when reading values from columnar dataset like a file.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input['CustomMetricFromJobValueArgs']]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class _CustomMetricFromJobState:
    def __init__(__self__, *,
                 baseline_value: Optional[pulumi.Input[float]] = None,
                 batch: Optional[pulumi.Input['CustomMetricFromJobBatchArgs']] = None,
                 custom_job_id: Optional[pulumi.Input[str]] = None,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameter_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['CustomMetricFromJobParameterOverrideArgs']]]] = None,
                 sample_count: Optional[pulumi.Input['CustomMetricFromJobSampleCountArgs']] = None,
                 schedule: Optional[pulumi.Input['CustomMetricFromJobScheduleArgs']] = None,
                 timestamp: Optional[pulumi.Input['CustomMetricFromJobTimestampArgs']] = None,
                 value: Optional[pulumi.Input['CustomMetricFromJobValueArgs']] = None):
        """
        Input properties used for looking up and filtering CustomMetricFromJob resources.
        :param pulumi.Input[float] baseline_value: Baseline value for the metric.
        :param pulumi.Input['CustomMetricFromJobBatchArgs'] batch: Batch ID source when reading values from columnar dataset like a file.
        :param pulumi.Input[str] custom_job_id: ID of the Custom Job.
        :param pulumi.Input[str] deployment_id: ID of the Deployment.
        :param pulumi.Input[str] description: Description of the metric.
        :param pulumi.Input[str] name: Name of the metric.
        :param pulumi.Input[Sequence[pulumi.Input['CustomMetricFromJobParameterOverrideArgs']]] parameter_overrides: Additional parameters to be injected into the Metric Job at runtime.
        :param pulumi.Input['CustomMetricFromJobSampleCountArgs'] sample_count: Points to a weight column if users provide pre-aggregated metric values. Used with columnar datasets.
        :param pulumi.Input['CustomMetricFromJobScheduleArgs'] schedule: Defines at what intervals the metric job should run.
        :param pulumi.Input['CustomMetricFromJobTimestampArgs'] timestamp: Timestamp spoofing when reading values from file, like dataset. By default, we replicate pd.to_datetime formatting behaviour.
        :param pulumi.Input['CustomMetricFromJobValueArgs'] value: Value source when reading values from columnar dataset like a file.
        """
        if baseline_value is not None:
            pulumi.set(__self__, "baseline_value", baseline_value)
        if batch is not None:
            pulumi.set(__self__, "batch", batch)
        if custom_job_id is not None:
            pulumi.set(__self__, "custom_job_id", custom_job_id)
        if deployment_id is not None:
            pulumi.set(__self__, "deployment_id", deployment_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameter_overrides is not None:
            pulumi.set(__self__, "parameter_overrides", parameter_overrides)
        if sample_count is not None:
            pulumi.set(__self__, "sample_count", sample_count)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if timestamp is not None:
            pulumi.set(__self__, "timestamp", timestamp)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="baselineValue")
    def baseline_value(self) -> Optional[pulumi.Input[float]]:
        """
        Baseline value for the metric.
        """
        return pulumi.get(self, "baseline_value")

    @baseline_value.setter
    def baseline_value(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "baseline_value", value)

    @property
    @pulumi.getter
    def batch(self) -> Optional[pulumi.Input['CustomMetricFromJobBatchArgs']]:
        """
        Batch ID source when reading values from columnar dataset like a file.
        """
        return pulumi.get(self, "batch")

    @batch.setter
    def batch(self, value: Optional[pulumi.Input['CustomMetricFromJobBatchArgs']]):
        pulumi.set(self, "batch", value)

    @property
    @pulumi.getter(name="customJobId")
    def custom_job_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the Custom Job.
        """
        return pulumi.get(self, "custom_job_id")

    @custom_job_id.setter
    def custom_job_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_job_id", value)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the Deployment.
        """
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the metric.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the metric.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parameterOverrides")
    def parameter_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomMetricFromJobParameterOverrideArgs']]]]:
        """
        Additional parameters to be injected into the Metric Job at runtime.
        """
        return pulumi.get(self, "parameter_overrides")

    @parameter_overrides.setter
    def parameter_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomMetricFromJobParameterOverrideArgs']]]]):
        pulumi.set(self, "parameter_overrides", value)

    @property
    @pulumi.getter(name="sampleCount")
    def sample_count(self) -> Optional[pulumi.Input['CustomMetricFromJobSampleCountArgs']]:
        """
        Points to a weight column if users provide pre-aggregated metric values. Used with columnar datasets.
        """
        return pulumi.get(self, "sample_count")

    @sample_count.setter
    def sample_count(self, value: Optional[pulumi.Input['CustomMetricFromJobSampleCountArgs']]):
        pulumi.set(self, "sample_count", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['CustomMetricFromJobScheduleArgs']]:
        """
        Defines at what intervals the metric job should run.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['CustomMetricFromJobScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter
    def timestamp(self) -> Optional[pulumi.Input['CustomMetricFromJobTimestampArgs']]:
        """
        Timestamp spoofing when reading values from file, like dataset. By default, we replicate pd.to_datetime formatting behaviour.
        """
        return pulumi.get(self, "timestamp")

    @timestamp.setter
    def timestamp(self, value: Optional[pulumi.Input['CustomMetricFromJobTimestampArgs']]):
        pulumi.set(self, "timestamp", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input['CustomMetricFromJobValueArgs']]:
        """
        Value source when reading values from columnar dataset like a file.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input['CustomMetricFromJobValueArgs']]):
        pulumi.set(self, "value", value)


class CustomMetricFromJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 baseline_value: Optional[pulumi.Input[float]] = None,
                 batch: Optional[pulumi.Input[Union['CustomMetricFromJobBatchArgs', 'CustomMetricFromJobBatchArgsDict']]] = None,
                 custom_job_id: Optional[pulumi.Input[str]] = None,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameter_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomMetricFromJobParameterOverrideArgs', 'CustomMetricFromJobParameterOverrideArgsDict']]]]] = None,
                 sample_count: Optional[pulumi.Input[Union['CustomMetricFromJobSampleCountArgs', 'CustomMetricFromJobSampleCountArgsDict']]] = None,
                 schedule: Optional[pulumi.Input[Union['CustomMetricFromJobScheduleArgs', 'CustomMetricFromJobScheduleArgsDict']]] = None,
                 timestamp: Optional[pulumi.Input[Union['CustomMetricFromJobTimestampArgs', 'CustomMetricFromJobTimestampArgsDict']]] = None,
                 value: Optional[pulumi.Input[Union['CustomMetricFromJobValueArgs', 'CustomMetricFromJobValueArgsDict']]] = None,
                 __props__=None):
        """
        Custom Metric From Job

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datarobot as datarobot

        example = datarobot.CustomMetricFromJob("example",
            deployment_id=datarobot_deployment["example"]["id"],
            custom_job_id=datarobot_custom_metric_job["example"]["id"])
        pulumi.export("exampleId", example.id)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] baseline_value: Baseline value for the metric.
        :param pulumi.Input[Union['CustomMetricFromJobBatchArgs', 'CustomMetricFromJobBatchArgsDict']] batch: Batch ID source when reading values from columnar dataset like a file.
        :param pulumi.Input[str] custom_job_id: ID of the Custom Job.
        :param pulumi.Input[str] deployment_id: ID of the Deployment.
        :param pulumi.Input[str] description: Description of the metric.
        :param pulumi.Input[str] name: Name of the metric.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomMetricFromJobParameterOverrideArgs', 'CustomMetricFromJobParameterOverrideArgsDict']]]] parameter_overrides: Additional parameters to be injected into the Metric Job at runtime.
        :param pulumi.Input[Union['CustomMetricFromJobSampleCountArgs', 'CustomMetricFromJobSampleCountArgsDict']] sample_count: Points to a weight column if users provide pre-aggregated metric values. Used with columnar datasets.
        :param pulumi.Input[Union['CustomMetricFromJobScheduleArgs', 'CustomMetricFromJobScheduleArgsDict']] schedule: Defines at what intervals the metric job should run.
        :param pulumi.Input[Union['CustomMetricFromJobTimestampArgs', 'CustomMetricFromJobTimestampArgsDict']] timestamp: Timestamp spoofing when reading values from file, like dataset. By default, we replicate pd.to_datetime formatting behaviour.
        :param pulumi.Input[Union['CustomMetricFromJobValueArgs', 'CustomMetricFromJobValueArgsDict']] value: Value source when reading values from columnar dataset like a file.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomMetricFromJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Custom Metric From Job

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datarobot as datarobot

        example = datarobot.CustomMetricFromJob("example",
            deployment_id=datarobot_deployment["example"]["id"],
            custom_job_id=datarobot_custom_metric_job["example"]["id"])
        pulumi.export("exampleId", example.id)
        ```

        :param str resource_name: The name of the resource.
        :param CustomMetricFromJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomMetricFromJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 baseline_value: Optional[pulumi.Input[float]] = None,
                 batch: Optional[pulumi.Input[Union['CustomMetricFromJobBatchArgs', 'CustomMetricFromJobBatchArgsDict']]] = None,
                 custom_job_id: Optional[pulumi.Input[str]] = None,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameter_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomMetricFromJobParameterOverrideArgs', 'CustomMetricFromJobParameterOverrideArgsDict']]]]] = None,
                 sample_count: Optional[pulumi.Input[Union['CustomMetricFromJobSampleCountArgs', 'CustomMetricFromJobSampleCountArgsDict']]] = None,
                 schedule: Optional[pulumi.Input[Union['CustomMetricFromJobScheduleArgs', 'CustomMetricFromJobScheduleArgsDict']]] = None,
                 timestamp: Optional[pulumi.Input[Union['CustomMetricFromJobTimestampArgs', 'CustomMetricFromJobTimestampArgsDict']]] = None,
                 value: Optional[pulumi.Input[Union['CustomMetricFromJobValueArgs', 'CustomMetricFromJobValueArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomMetricFromJobArgs.__new__(CustomMetricFromJobArgs)

            __props__.__dict__["baseline_value"] = baseline_value
            __props__.__dict__["batch"] = batch
            if custom_job_id is None and not opts.urn:
                raise TypeError("Missing required property 'custom_job_id'")
            __props__.__dict__["custom_job_id"] = custom_job_id
            if deployment_id is None and not opts.urn:
                raise TypeError("Missing required property 'deployment_id'")
            __props__.__dict__["deployment_id"] = deployment_id
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["parameter_overrides"] = parameter_overrides
            __props__.__dict__["sample_count"] = sample_count
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["timestamp"] = timestamp
            __props__.__dict__["value"] = value
        super(CustomMetricFromJob, __self__).__init__(
            'datarobot:index/customMetricFromJob:CustomMetricFromJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            baseline_value: Optional[pulumi.Input[float]] = None,
            batch: Optional[pulumi.Input[Union['CustomMetricFromJobBatchArgs', 'CustomMetricFromJobBatchArgsDict']]] = None,
            custom_job_id: Optional[pulumi.Input[str]] = None,
            deployment_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            parameter_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomMetricFromJobParameterOverrideArgs', 'CustomMetricFromJobParameterOverrideArgsDict']]]]] = None,
            sample_count: Optional[pulumi.Input[Union['CustomMetricFromJobSampleCountArgs', 'CustomMetricFromJobSampleCountArgsDict']]] = None,
            schedule: Optional[pulumi.Input[Union['CustomMetricFromJobScheduleArgs', 'CustomMetricFromJobScheduleArgsDict']]] = None,
            timestamp: Optional[pulumi.Input[Union['CustomMetricFromJobTimestampArgs', 'CustomMetricFromJobTimestampArgsDict']]] = None,
            value: Optional[pulumi.Input[Union['CustomMetricFromJobValueArgs', 'CustomMetricFromJobValueArgsDict']]] = None) -> 'CustomMetricFromJob':
        """
        Get an existing CustomMetricFromJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] baseline_value: Baseline value for the metric.
        :param pulumi.Input[Union['CustomMetricFromJobBatchArgs', 'CustomMetricFromJobBatchArgsDict']] batch: Batch ID source when reading values from columnar dataset like a file.
        :param pulumi.Input[str] custom_job_id: ID of the Custom Job.
        :param pulumi.Input[str] deployment_id: ID of the Deployment.
        :param pulumi.Input[str] description: Description of the metric.
        :param pulumi.Input[str] name: Name of the metric.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomMetricFromJobParameterOverrideArgs', 'CustomMetricFromJobParameterOverrideArgsDict']]]] parameter_overrides: Additional parameters to be injected into the Metric Job at runtime.
        :param pulumi.Input[Union['CustomMetricFromJobSampleCountArgs', 'CustomMetricFromJobSampleCountArgsDict']] sample_count: Points to a weight column if users provide pre-aggregated metric values. Used with columnar datasets.
        :param pulumi.Input[Union['CustomMetricFromJobScheduleArgs', 'CustomMetricFromJobScheduleArgsDict']] schedule: Defines at what intervals the metric job should run.
        :param pulumi.Input[Union['CustomMetricFromJobTimestampArgs', 'CustomMetricFromJobTimestampArgsDict']] timestamp: Timestamp spoofing when reading values from file, like dataset. By default, we replicate pd.to_datetime formatting behaviour.
        :param pulumi.Input[Union['CustomMetricFromJobValueArgs', 'CustomMetricFromJobValueArgsDict']] value: Value source when reading values from columnar dataset like a file.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomMetricFromJobState.__new__(_CustomMetricFromJobState)

        __props__.__dict__["baseline_value"] = baseline_value
        __props__.__dict__["batch"] = batch
        __props__.__dict__["custom_job_id"] = custom_job_id
        __props__.__dict__["deployment_id"] = deployment_id
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["parameter_overrides"] = parameter_overrides
        __props__.__dict__["sample_count"] = sample_count
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["timestamp"] = timestamp
        __props__.__dict__["value"] = value
        return CustomMetricFromJob(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="baselineValue")
    def baseline_value(self) -> pulumi.Output[Optional[float]]:
        """
        Baseline value for the metric.
        """
        return pulumi.get(self, "baseline_value")

    @property
    @pulumi.getter
    def batch(self) -> pulumi.Output[Optional['outputs.CustomMetricFromJobBatch']]:
        """
        Batch ID source when reading values from columnar dataset like a file.
        """
        return pulumi.get(self, "batch")

    @property
    @pulumi.getter(name="customJobId")
    def custom_job_id(self) -> pulumi.Output[str]:
        """
        ID of the Custom Job.
        """
        return pulumi.get(self, "custom_job_id")

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> pulumi.Output[str]:
        """
        ID of the Deployment.
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the metric.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the metric.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parameterOverrides")
    def parameter_overrides(self) -> pulumi.Output[Optional[Sequence['outputs.CustomMetricFromJobParameterOverride']]]:
        """
        Additional parameters to be injected into the Metric Job at runtime.
        """
        return pulumi.get(self, "parameter_overrides")

    @property
    @pulumi.getter(name="sampleCount")
    def sample_count(self) -> pulumi.Output[Optional['outputs.CustomMetricFromJobSampleCount']]:
        """
        Points to a weight column if users provide pre-aggregated metric values. Used with columnar datasets.
        """
        return pulumi.get(self, "sample_count")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[Optional['outputs.CustomMetricFromJobSchedule']]:
        """
        Defines at what intervals the metric job should run.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter
    def timestamp(self) -> pulumi.Output[Optional['outputs.CustomMetricFromJobTimestamp']]:
        """
        Timestamp spoofing when reading values from file, like dataset. By default, we replicate pd.to_datetime formatting behaviour.
        """
        return pulumi.get(self, "timestamp")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[Optional['outputs.CustomMetricFromJobValue']]:
        """
        Value source when reading values from columnar dataset like a file.
        """
        return pulumi.get(self, "value")

