# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CustomApplicationArgs', 'CustomApplication']

@pulumi.input_type
class CustomApplicationArgs:
    def __init__(__self__, *,
                 source_version_id: pulumi.Input[str],
                 allow_auto_stopping: Optional[pulumi.Input[bool]] = None,
                 external_access_enabled: Optional[pulumi.Input[bool]] = None,
                 external_access_recipients: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 use_case_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a CustomApplication resource.
        :param pulumi.Input[str] source_version_id: The version ID of the Custom Application Source.
        :param pulumi.Input[bool] allow_auto_stopping: Whether auto stopping is allowed for the Custom Application.
        :param pulumi.Input[bool] external_access_enabled: Whether external access is enabled for the Custom Application.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] external_access_recipients: The list of external email addresses that have access to the Custom Application.
        :param pulumi.Input[str] name: The name of the Custom Application.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] use_case_ids: The list of Use Case IDs to add the Custom Application to.
        """
        pulumi.set(__self__, "source_version_id", source_version_id)
        if allow_auto_stopping is not None:
            pulumi.set(__self__, "allow_auto_stopping", allow_auto_stopping)
        if external_access_enabled is not None:
            pulumi.set(__self__, "external_access_enabled", external_access_enabled)
        if external_access_recipients is not None:
            pulumi.set(__self__, "external_access_recipients", external_access_recipients)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if use_case_ids is not None:
            pulumi.set(__self__, "use_case_ids", use_case_ids)

    @property
    @pulumi.getter(name="sourceVersionId")
    def source_version_id(self) -> pulumi.Input[str]:
        """
        The version ID of the Custom Application Source.
        """
        return pulumi.get(self, "source_version_id")

    @source_version_id.setter
    def source_version_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_version_id", value)

    @property
    @pulumi.getter(name="allowAutoStopping")
    def allow_auto_stopping(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether auto stopping is allowed for the Custom Application.
        """
        return pulumi.get(self, "allow_auto_stopping")

    @allow_auto_stopping.setter
    def allow_auto_stopping(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_auto_stopping", value)

    @property
    @pulumi.getter(name="externalAccessEnabled")
    def external_access_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether external access is enabled for the Custom Application.
        """
        return pulumi.get(self, "external_access_enabled")

    @external_access_enabled.setter
    def external_access_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "external_access_enabled", value)

    @property
    @pulumi.getter(name="externalAccessRecipients")
    def external_access_recipients(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of external email addresses that have access to the Custom Application.
        """
        return pulumi.get(self, "external_access_recipients")

    @external_access_recipients.setter
    def external_access_recipients(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "external_access_recipients", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Custom Application.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="useCaseIds")
    def use_case_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of Use Case IDs to add the Custom Application to.
        """
        return pulumi.get(self, "use_case_ids")

    @use_case_ids.setter
    def use_case_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "use_case_ids", value)


@pulumi.input_type
class _CustomApplicationState:
    def __init__(__self__, *,
                 allow_auto_stopping: Optional[pulumi.Input[bool]] = None,
                 application_url: Optional[pulumi.Input[str]] = None,
                 external_access_enabled: Optional[pulumi.Input[bool]] = None,
                 external_access_recipients: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 source_id: Optional[pulumi.Input[str]] = None,
                 source_version_id: Optional[pulumi.Input[str]] = None,
                 use_case_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering CustomApplication resources.
        :param pulumi.Input[bool] allow_auto_stopping: Whether auto stopping is allowed for the Custom Application.
        :param pulumi.Input[str] application_url: The URL of the Custom Application.
        :param pulumi.Input[bool] external_access_enabled: Whether external access is enabled for the Custom Application.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] external_access_recipients: The list of external email addresses that have access to the Custom Application.
        :param pulumi.Input[str] name: The name of the Custom Application.
        :param pulumi.Input[str] source_id: The ID of the Custom Application Source.
        :param pulumi.Input[str] source_version_id: The version ID of the Custom Application Source.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] use_case_ids: The list of Use Case IDs to add the Custom Application to.
        """
        if allow_auto_stopping is not None:
            pulumi.set(__self__, "allow_auto_stopping", allow_auto_stopping)
        if application_url is not None:
            pulumi.set(__self__, "application_url", application_url)
        if external_access_enabled is not None:
            pulumi.set(__self__, "external_access_enabled", external_access_enabled)
        if external_access_recipients is not None:
            pulumi.set(__self__, "external_access_recipients", external_access_recipients)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_id is not None:
            pulumi.set(__self__, "source_id", source_id)
        if source_version_id is not None:
            pulumi.set(__self__, "source_version_id", source_version_id)
        if use_case_ids is not None:
            pulumi.set(__self__, "use_case_ids", use_case_ids)

    @property
    @pulumi.getter(name="allowAutoStopping")
    def allow_auto_stopping(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether auto stopping is allowed for the Custom Application.
        """
        return pulumi.get(self, "allow_auto_stopping")

    @allow_auto_stopping.setter
    def allow_auto_stopping(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_auto_stopping", value)

    @property
    @pulumi.getter(name="applicationUrl")
    def application_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the Custom Application.
        """
        return pulumi.get(self, "application_url")

    @application_url.setter
    def application_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_url", value)

    @property
    @pulumi.getter(name="externalAccessEnabled")
    def external_access_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether external access is enabled for the Custom Application.
        """
        return pulumi.get(self, "external_access_enabled")

    @external_access_enabled.setter
    def external_access_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "external_access_enabled", value)

    @property
    @pulumi.getter(name="externalAccessRecipients")
    def external_access_recipients(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of external email addresses that have access to the Custom Application.
        """
        return pulumi.get(self, "external_access_recipients")

    @external_access_recipients.setter
    def external_access_recipients(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "external_access_recipients", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Custom Application.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Custom Application Source.
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_id", value)

    @property
    @pulumi.getter(name="sourceVersionId")
    def source_version_id(self) -> Optional[pulumi.Input[str]]:
        """
        The version ID of the Custom Application Source.
        """
        return pulumi.get(self, "source_version_id")

    @source_version_id.setter
    def source_version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_version_id", value)

    @property
    @pulumi.getter(name="useCaseIds")
    def use_case_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of Use Case IDs to add the Custom Application to.
        """
        return pulumi.get(self, "use_case_ids")

    @use_case_ids.setter
    def use_case_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "use_case_ids", value)


class CustomApplication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_auto_stopping: Optional[pulumi.Input[bool]] = None,
                 external_access_enabled: Optional[pulumi.Input[bool]] = None,
                 external_access_recipients: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 source_version_id: Optional[pulumi.Input[str]] = None,
                 use_case_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Custom Application

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datarobot as datarobot

        example_application_source = datarobot.ApplicationSource("exampleApplicationSource", files=[
            ["start-app.sh"],
            ["streamlit-app.py"],
        ])
        example_custom_application = datarobot.CustomApplication("exampleCustomApplication",
            source_version_id=example_application_source.version_id,
            external_access_enabled=True,
            external_access_recipients=["recipient@example.com"],
            allow_auto_stopping=False)
        pulumi.export("datarobotCustomApplicationId", example_custom_application.id)
        pulumi.export("datarobotCustomApplicationSourceId", example_custom_application.source_id)
        pulumi.export("datarobotCustomApplicationSourceVersionId", example_custom_application.source_version_id)
        pulumi.export("datarobotCustomApplicationUrl", example_custom_application.application_url)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_auto_stopping: Whether auto stopping is allowed for the Custom Application.
        :param pulumi.Input[bool] external_access_enabled: Whether external access is enabled for the Custom Application.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] external_access_recipients: The list of external email addresses that have access to the Custom Application.
        :param pulumi.Input[str] name: The name of the Custom Application.
        :param pulumi.Input[str] source_version_id: The version ID of the Custom Application Source.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] use_case_ids: The list of Use Case IDs to add the Custom Application to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Custom Application

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datarobot as datarobot

        example_application_source = datarobot.ApplicationSource("exampleApplicationSource", files=[
            ["start-app.sh"],
            ["streamlit-app.py"],
        ])
        example_custom_application = datarobot.CustomApplication("exampleCustomApplication",
            source_version_id=example_application_source.version_id,
            external_access_enabled=True,
            external_access_recipients=["recipient@example.com"],
            allow_auto_stopping=False)
        pulumi.export("datarobotCustomApplicationId", example_custom_application.id)
        pulumi.export("datarobotCustomApplicationSourceId", example_custom_application.source_id)
        pulumi.export("datarobotCustomApplicationSourceVersionId", example_custom_application.source_version_id)
        pulumi.export("datarobotCustomApplicationUrl", example_custom_application.application_url)
        ```

        :param str resource_name: The name of the resource.
        :param CustomApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_auto_stopping: Optional[pulumi.Input[bool]] = None,
                 external_access_enabled: Optional[pulumi.Input[bool]] = None,
                 external_access_recipients: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 source_version_id: Optional[pulumi.Input[str]] = None,
                 use_case_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomApplicationArgs.__new__(CustomApplicationArgs)

            __props__.__dict__["allow_auto_stopping"] = allow_auto_stopping
            __props__.__dict__["external_access_enabled"] = external_access_enabled
            __props__.__dict__["external_access_recipients"] = external_access_recipients
            __props__.__dict__["name"] = name
            if source_version_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_version_id'")
            __props__.__dict__["source_version_id"] = source_version_id
            __props__.__dict__["use_case_ids"] = use_case_ids
            __props__.__dict__["application_url"] = None
            __props__.__dict__["source_id"] = None
        super(CustomApplication, __self__).__init__(
            'datarobot:index/customApplication:CustomApplication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_auto_stopping: Optional[pulumi.Input[bool]] = None,
            application_url: Optional[pulumi.Input[str]] = None,
            external_access_enabled: Optional[pulumi.Input[bool]] = None,
            external_access_recipients: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            source_id: Optional[pulumi.Input[str]] = None,
            source_version_id: Optional[pulumi.Input[str]] = None,
            use_case_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'CustomApplication':
        """
        Get an existing CustomApplication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_auto_stopping: Whether auto stopping is allowed for the Custom Application.
        :param pulumi.Input[str] application_url: The URL of the Custom Application.
        :param pulumi.Input[bool] external_access_enabled: Whether external access is enabled for the Custom Application.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] external_access_recipients: The list of external email addresses that have access to the Custom Application.
        :param pulumi.Input[str] name: The name of the Custom Application.
        :param pulumi.Input[str] source_id: The ID of the Custom Application Source.
        :param pulumi.Input[str] source_version_id: The version ID of the Custom Application Source.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] use_case_ids: The list of Use Case IDs to add the Custom Application to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomApplicationState.__new__(_CustomApplicationState)

        __props__.__dict__["allow_auto_stopping"] = allow_auto_stopping
        __props__.__dict__["application_url"] = application_url
        __props__.__dict__["external_access_enabled"] = external_access_enabled
        __props__.__dict__["external_access_recipients"] = external_access_recipients
        __props__.__dict__["name"] = name
        __props__.__dict__["source_id"] = source_id
        __props__.__dict__["source_version_id"] = source_version_id
        __props__.__dict__["use_case_ids"] = use_case_ids
        return CustomApplication(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowAutoStopping")
    def allow_auto_stopping(self) -> pulumi.Output[bool]:
        """
        Whether auto stopping is allowed for the Custom Application.
        """
        return pulumi.get(self, "allow_auto_stopping")

    @property
    @pulumi.getter(name="applicationUrl")
    def application_url(self) -> pulumi.Output[str]:
        """
        The URL of the Custom Application.
        """
        return pulumi.get(self, "application_url")

    @property
    @pulumi.getter(name="externalAccessEnabled")
    def external_access_enabled(self) -> pulumi.Output[bool]:
        """
        Whether external access is enabled for the Custom Application.
        """
        return pulumi.get(self, "external_access_enabled")

    @property
    @pulumi.getter(name="externalAccessRecipients")
    def external_access_recipients(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of external email addresses that have access to the Custom Application.
        """
        return pulumi.get(self, "external_access_recipients")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Custom Application.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> pulumi.Output[str]:
        """
        The ID of the Custom Application Source.
        """
        return pulumi.get(self, "source_id")

    @property
    @pulumi.getter(name="sourceVersionId")
    def source_version_id(self) -> pulumi.Output[str]:
        """
        The version ID of the Custom Application Source.
        """
        return pulumi.get(self, "source_version_id")

    @property
    @pulumi.getter(name="useCaseIds")
    def use_case_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of Use Case IDs to add the Custom Application to.
        """
        return pulumi.get(self, "use_case_ids")

