# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BatchPredictionJobDefinitionArgs', 'BatchPredictionJobDefinition']

@pulumi.input_type
class BatchPredictionJobDefinitionArgs:
    def __init__(__self__, *,
                 deployment_id: pulumi.Input[str],
                 intake_settings: pulumi.Input['BatchPredictionJobDefinitionIntakeSettingsArgs'],
                 abort_on_error: Optional[pulumi.Input[bool]] = None,
                 chunk_size: Optional[Any] = None,
                 column_names_remapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 csv_settings: Optional[pulumi.Input['BatchPredictionJobDefinitionCsvSettingsArgs']] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 explanation_algorithm: Optional[pulumi.Input[str]] = None,
                 include_prediction_status: Optional[pulumi.Input[bool]] = None,
                 include_probabilities: Optional[pulumi.Input[bool]] = None,
                 include_probabilities_classes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_explanations: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 num_concurrent: Optional[pulumi.Input[int]] = None,
                 output_settings: Optional[pulumi.Input['BatchPredictionJobDefinitionOutputSettingsArgs']] = None,
                 passthrough_columns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 passthrough_columns_set: Optional[pulumi.Input[str]] = None,
                 prediction_instance: Optional[pulumi.Input['BatchPredictionJobDefinitionPredictionInstanceArgs']] = None,
                 prediction_threshold: Optional[pulumi.Input[float]] = None,
                 prediction_warning_enabled: Optional[pulumi.Input[bool]] = None,
                 schedule: Optional[pulumi.Input['BatchPredictionJobDefinitionScheduleArgs']] = None,
                 skip_drift_tracking: Optional[pulumi.Input[bool]] = None,
                 threshold_high: Optional[pulumi.Input[float]] = None,
                 threshold_low: Optional[pulumi.Input[float]] = None,
                 timeseries_settings: Optional[pulumi.Input['BatchPredictionJobDefinitionTimeseriesSettingsArgs']] = None):
        """
        The set of arguments for constructing a BatchPredictionJobDefinition resource.
        :param pulumi.Input[str] deployment_id: The ID of the deployment to use for the batch prediction job.
        :param pulumi.Input['BatchPredictionJobDefinitionIntakeSettingsArgs'] intake_settings: A dict configuring how data is coming from.
        :param pulumi.Input[bool] abort_on_error: Default behavior is to abort the job if too many rows fail scoring. This will free up resources for other jobs that may score successfully. Set to false to unconditionally score every row no matter how many errors are encountered. Defaults to True.
        :param Any chunk_size: Which strategy should be used to determine the chunk size. Can be either a named strategy or a fixed size in bytes.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] column_names_remapping: Mapping with column renaming for output table.
        :param pulumi.Input['BatchPredictionJobDefinitionCsvSettingsArgs'] csv_settings: CSV intake and output settings.
        :param pulumi.Input[bool] enabled: Whether or not the job definition should be active on a scheduled basis. If True, schedule is required.
        :param pulumi.Input[str] explanation_algorithm: Which algorithm will be used to calculate prediction explanations.
        :param pulumi.Input[bool] include_prediction_status: Include the prediction_status column in the output. Defaults to False.
        :param pulumi.Input[bool] include_probabilities: Flag that enables returning of all probability columns. Defaults to True.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] include_probabilities_classes: List the subset of classes if a user doesn’t want all the classes. Defaults to [].
        :param pulumi.Input[int] max_explanations: Compute prediction explanations for this amount of features.
        :param pulumi.Input[str] name: The name you want your job to be identified with. Must be unique across the organization’s existing jobs.
        :param pulumi.Input[int] num_concurrent: Number of concurrent chunks to score simultaneously. Defaults to the available number of cores of the deployment. Lower it to leave resources for real-time scoring.
        :param pulumi.Input['BatchPredictionJobDefinitionOutputSettingsArgs'] output_settings: A dict configuring how scored data is to be saved.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] passthrough_columns: Keep these columns from the scoring dataset in the scored dataset. This is useful for correlating predictions with source data.
        :param pulumi.Input[str] passthrough_columns_set: To pass through every column from the scoring dataset, set this to all.
        :param pulumi.Input['BatchPredictionJobDefinitionPredictionInstanceArgs'] prediction_instance: Defaults to instance specified by deployment or system configuration.
        :param pulumi.Input[float] prediction_threshold: Threshold is the point that sets the class boundary for a predicted value. This value can be set between 0.0 and 1.0.
        :param pulumi.Input[bool] prediction_warning_enabled: Add prediction warnings to the scored data. Currently only supported for regression models. Defaults to False.
        :param pulumi.Input['BatchPredictionJobDefinitionScheduleArgs'] schedule: Defines at what intervals the job should run.
        :param pulumi.Input[bool] skip_drift_tracking: Skips drift tracking on any predictions made from this job. This is useful when running non-production workloads to not affect drift tracking and cause unnecessary alerts. Defaults to false.
        :param pulumi.Input[float] threshold_high: Only compute prediction explanations for predictions above this threshold. Can be combined with threshold_low.
        :param pulumi.Input[float] threshold_low: Only compute prediction explanations for predictions below this threshold. Can be combined with threshold_high.
        :param pulumi.Input['BatchPredictionJobDefinitionTimeseriesSettingsArgs'] timeseries_settings: Configuration for time-series scoring.
        """
        pulumi.set(__self__, "deployment_id", deployment_id)
        pulumi.set(__self__, "intake_settings", intake_settings)
        if abort_on_error is not None:
            pulumi.set(__self__, "abort_on_error", abort_on_error)
        if chunk_size is not None:
            pulumi.set(__self__, "chunk_size", chunk_size)
        if column_names_remapping is not None:
            pulumi.set(__self__, "column_names_remapping", column_names_remapping)
        if csv_settings is not None:
            pulumi.set(__self__, "csv_settings", csv_settings)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if explanation_algorithm is not None:
            pulumi.set(__self__, "explanation_algorithm", explanation_algorithm)
        if include_prediction_status is not None:
            pulumi.set(__self__, "include_prediction_status", include_prediction_status)
        if include_probabilities is not None:
            pulumi.set(__self__, "include_probabilities", include_probabilities)
        if include_probabilities_classes is not None:
            pulumi.set(__self__, "include_probabilities_classes", include_probabilities_classes)
        if max_explanations is not None:
            pulumi.set(__self__, "max_explanations", max_explanations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if num_concurrent is not None:
            pulumi.set(__self__, "num_concurrent", num_concurrent)
        if output_settings is not None:
            pulumi.set(__self__, "output_settings", output_settings)
        if passthrough_columns is not None:
            pulumi.set(__self__, "passthrough_columns", passthrough_columns)
        if passthrough_columns_set is not None:
            pulumi.set(__self__, "passthrough_columns_set", passthrough_columns_set)
        if prediction_instance is not None:
            pulumi.set(__self__, "prediction_instance", prediction_instance)
        if prediction_threshold is not None:
            pulumi.set(__self__, "prediction_threshold", prediction_threshold)
        if prediction_warning_enabled is not None:
            pulumi.set(__self__, "prediction_warning_enabled", prediction_warning_enabled)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if skip_drift_tracking is not None:
            pulumi.set(__self__, "skip_drift_tracking", skip_drift_tracking)
        if threshold_high is not None:
            pulumi.set(__self__, "threshold_high", threshold_high)
        if threshold_low is not None:
            pulumi.set(__self__, "threshold_low", threshold_low)
        if timeseries_settings is not None:
            pulumi.set(__self__, "timeseries_settings", timeseries_settings)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> pulumi.Input[str]:
        """
        The ID of the deployment to use for the batch prediction job.
        """
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "deployment_id", value)

    @property
    @pulumi.getter(name="intakeSettings")
    def intake_settings(self) -> pulumi.Input['BatchPredictionJobDefinitionIntakeSettingsArgs']:
        """
        A dict configuring how data is coming from.
        """
        return pulumi.get(self, "intake_settings")

    @intake_settings.setter
    def intake_settings(self, value: pulumi.Input['BatchPredictionJobDefinitionIntakeSettingsArgs']):
        pulumi.set(self, "intake_settings", value)

    @property
    @pulumi.getter(name="abortOnError")
    def abort_on_error(self) -> Optional[pulumi.Input[bool]]:
        """
        Default behavior is to abort the job if too many rows fail scoring. This will free up resources for other jobs that may score successfully. Set to false to unconditionally score every row no matter how many errors are encountered. Defaults to True.
        """
        return pulumi.get(self, "abort_on_error")

    @abort_on_error.setter
    def abort_on_error(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "abort_on_error", value)

    @property
    @pulumi.getter(name="chunkSize")
    def chunk_size(self) -> Optional[Any]:
        """
        Which strategy should be used to determine the chunk size. Can be either a named strategy or a fixed size in bytes.
        """
        return pulumi.get(self, "chunk_size")

    @chunk_size.setter
    def chunk_size(self, value: Optional[Any]):
        pulumi.set(self, "chunk_size", value)

    @property
    @pulumi.getter(name="columnNamesRemapping")
    def column_names_remapping(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Mapping with column renaming for output table.
        """
        return pulumi.get(self, "column_names_remapping")

    @column_names_remapping.setter
    def column_names_remapping(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "column_names_remapping", value)

    @property
    @pulumi.getter(name="csvSettings")
    def csv_settings(self) -> Optional[pulumi.Input['BatchPredictionJobDefinitionCsvSettingsArgs']]:
        """
        CSV intake and output settings.
        """
        return pulumi.get(self, "csv_settings")

    @csv_settings.setter
    def csv_settings(self, value: Optional[pulumi.Input['BatchPredictionJobDefinitionCsvSettingsArgs']]):
        pulumi.set(self, "csv_settings", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the job definition should be active on a scheduled basis. If True, schedule is required.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="explanationAlgorithm")
    def explanation_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        Which algorithm will be used to calculate prediction explanations.
        """
        return pulumi.get(self, "explanation_algorithm")

    @explanation_algorithm.setter
    def explanation_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "explanation_algorithm", value)

    @property
    @pulumi.getter(name="includePredictionStatus")
    def include_prediction_status(self) -> Optional[pulumi.Input[bool]]:
        """
        Include the prediction_status column in the output. Defaults to False.
        """
        return pulumi.get(self, "include_prediction_status")

    @include_prediction_status.setter
    def include_prediction_status(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_prediction_status", value)

    @property
    @pulumi.getter(name="includeProbabilities")
    def include_probabilities(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag that enables returning of all probability columns. Defaults to True.
        """
        return pulumi.get(self, "include_probabilities")

    @include_probabilities.setter
    def include_probabilities(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_probabilities", value)

    @property
    @pulumi.getter(name="includeProbabilitiesClasses")
    def include_probabilities_classes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List the subset of classes if a user doesn’t want all the classes. Defaults to [].
        """
        return pulumi.get(self, "include_probabilities_classes")

    @include_probabilities_classes.setter
    def include_probabilities_classes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "include_probabilities_classes", value)

    @property
    @pulumi.getter(name="maxExplanations")
    def max_explanations(self) -> Optional[pulumi.Input[int]]:
        """
        Compute prediction explanations for this amount of features.
        """
        return pulumi.get(self, "max_explanations")

    @max_explanations.setter
    def max_explanations(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_explanations", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name you want your job to be identified with. Must be unique across the organization’s existing jobs.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numConcurrent")
    def num_concurrent(self) -> Optional[pulumi.Input[int]]:
        """
        Number of concurrent chunks to score simultaneously. Defaults to the available number of cores of the deployment. Lower it to leave resources for real-time scoring.
        """
        return pulumi.get(self, "num_concurrent")

    @num_concurrent.setter
    def num_concurrent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_concurrent", value)

    @property
    @pulumi.getter(name="outputSettings")
    def output_settings(self) -> Optional[pulumi.Input['BatchPredictionJobDefinitionOutputSettingsArgs']]:
        """
        A dict configuring how scored data is to be saved.
        """
        return pulumi.get(self, "output_settings")

    @output_settings.setter
    def output_settings(self, value: Optional[pulumi.Input['BatchPredictionJobDefinitionOutputSettingsArgs']]):
        pulumi.set(self, "output_settings", value)

    @property
    @pulumi.getter(name="passthroughColumns")
    def passthrough_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Keep these columns from the scoring dataset in the scored dataset. This is useful for correlating predictions with source data.
        """
        return pulumi.get(self, "passthrough_columns")

    @passthrough_columns.setter
    def passthrough_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "passthrough_columns", value)

    @property
    @pulumi.getter(name="passthroughColumnsSet")
    def passthrough_columns_set(self) -> Optional[pulumi.Input[str]]:
        """
        To pass through every column from the scoring dataset, set this to all.
        """
        return pulumi.get(self, "passthrough_columns_set")

    @passthrough_columns_set.setter
    def passthrough_columns_set(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "passthrough_columns_set", value)

    @property
    @pulumi.getter(name="predictionInstance")
    def prediction_instance(self) -> Optional[pulumi.Input['BatchPredictionJobDefinitionPredictionInstanceArgs']]:
        """
        Defaults to instance specified by deployment or system configuration.
        """
        return pulumi.get(self, "prediction_instance")

    @prediction_instance.setter
    def prediction_instance(self, value: Optional[pulumi.Input['BatchPredictionJobDefinitionPredictionInstanceArgs']]):
        pulumi.set(self, "prediction_instance", value)

    @property
    @pulumi.getter(name="predictionThreshold")
    def prediction_threshold(self) -> Optional[pulumi.Input[float]]:
        """
        Threshold is the point that sets the class boundary for a predicted value. This value can be set between 0.0 and 1.0.
        """
        return pulumi.get(self, "prediction_threshold")

    @prediction_threshold.setter
    def prediction_threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "prediction_threshold", value)

    @property
    @pulumi.getter(name="predictionWarningEnabled")
    def prediction_warning_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Add prediction warnings to the scored data. Currently only supported for regression models. Defaults to False.
        """
        return pulumi.get(self, "prediction_warning_enabled")

    @prediction_warning_enabled.setter
    def prediction_warning_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "prediction_warning_enabled", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['BatchPredictionJobDefinitionScheduleArgs']]:
        """
        Defines at what intervals the job should run.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['BatchPredictionJobDefinitionScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="skipDriftTracking")
    def skip_drift_tracking(self) -> Optional[pulumi.Input[bool]]:
        """
        Skips drift tracking on any predictions made from this job. This is useful when running non-production workloads to not affect drift tracking and cause unnecessary alerts. Defaults to false.
        """
        return pulumi.get(self, "skip_drift_tracking")

    @skip_drift_tracking.setter
    def skip_drift_tracking(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_drift_tracking", value)

    @property
    @pulumi.getter(name="thresholdHigh")
    def threshold_high(self) -> Optional[pulumi.Input[float]]:
        """
        Only compute prediction explanations for predictions above this threshold. Can be combined with threshold_low.
        """
        return pulumi.get(self, "threshold_high")

    @threshold_high.setter
    def threshold_high(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "threshold_high", value)

    @property
    @pulumi.getter(name="thresholdLow")
    def threshold_low(self) -> Optional[pulumi.Input[float]]:
        """
        Only compute prediction explanations for predictions below this threshold. Can be combined with threshold_high.
        """
        return pulumi.get(self, "threshold_low")

    @threshold_low.setter
    def threshold_low(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "threshold_low", value)

    @property
    @pulumi.getter(name="timeseriesSettings")
    def timeseries_settings(self) -> Optional[pulumi.Input['BatchPredictionJobDefinitionTimeseriesSettingsArgs']]:
        """
        Configuration for time-series scoring.
        """
        return pulumi.get(self, "timeseries_settings")

    @timeseries_settings.setter
    def timeseries_settings(self, value: Optional[pulumi.Input['BatchPredictionJobDefinitionTimeseriesSettingsArgs']]):
        pulumi.set(self, "timeseries_settings", value)


@pulumi.input_type
class _BatchPredictionJobDefinitionState:
    def __init__(__self__, *,
                 abort_on_error: Optional[pulumi.Input[bool]] = None,
                 chunk_size: Optional[Any] = None,
                 column_names_remapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 csv_settings: Optional[pulumi.Input['BatchPredictionJobDefinitionCsvSettingsArgs']] = None,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 explanation_algorithm: Optional[pulumi.Input[str]] = None,
                 include_prediction_status: Optional[pulumi.Input[bool]] = None,
                 include_probabilities: Optional[pulumi.Input[bool]] = None,
                 include_probabilities_classes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 intake_settings: Optional[pulumi.Input['BatchPredictionJobDefinitionIntakeSettingsArgs']] = None,
                 max_explanations: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 num_concurrent: Optional[pulumi.Input[int]] = None,
                 output_settings: Optional[pulumi.Input['BatchPredictionJobDefinitionOutputSettingsArgs']] = None,
                 passthrough_columns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 passthrough_columns_set: Optional[pulumi.Input[str]] = None,
                 prediction_instance: Optional[pulumi.Input['BatchPredictionJobDefinitionPredictionInstanceArgs']] = None,
                 prediction_threshold: Optional[pulumi.Input[float]] = None,
                 prediction_warning_enabled: Optional[pulumi.Input[bool]] = None,
                 schedule: Optional[pulumi.Input['BatchPredictionJobDefinitionScheduleArgs']] = None,
                 skip_drift_tracking: Optional[pulumi.Input[bool]] = None,
                 threshold_high: Optional[pulumi.Input[float]] = None,
                 threshold_low: Optional[pulumi.Input[float]] = None,
                 timeseries_settings: Optional[pulumi.Input['BatchPredictionJobDefinitionTimeseriesSettingsArgs']] = None):
        """
        Input properties used for looking up and filtering BatchPredictionJobDefinition resources.
        :param pulumi.Input[bool] abort_on_error: Default behavior is to abort the job if too many rows fail scoring. This will free up resources for other jobs that may score successfully. Set to false to unconditionally score every row no matter how many errors are encountered. Defaults to True.
        :param Any chunk_size: Which strategy should be used to determine the chunk size. Can be either a named strategy or a fixed size in bytes.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] column_names_remapping: Mapping with column renaming for output table.
        :param pulumi.Input['BatchPredictionJobDefinitionCsvSettingsArgs'] csv_settings: CSV intake and output settings.
        :param pulumi.Input[str] deployment_id: The ID of the deployment to use for the batch prediction job.
        :param pulumi.Input[bool] enabled: Whether or not the job definition should be active on a scheduled basis. If True, schedule is required.
        :param pulumi.Input[str] explanation_algorithm: Which algorithm will be used to calculate prediction explanations.
        :param pulumi.Input[bool] include_prediction_status: Include the prediction_status column in the output. Defaults to False.
        :param pulumi.Input[bool] include_probabilities: Flag that enables returning of all probability columns. Defaults to True.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] include_probabilities_classes: List the subset of classes if a user doesn’t want all the classes. Defaults to [].
        :param pulumi.Input['BatchPredictionJobDefinitionIntakeSettingsArgs'] intake_settings: A dict configuring how data is coming from.
        :param pulumi.Input[int] max_explanations: Compute prediction explanations for this amount of features.
        :param pulumi.Input[str] name: The name you want your job to be identified with. Must be unique across the organization’s existing jobs.
        :param pulumi.Input[int] num_concurrent: Number of concurrent chunks to score simultaneously. Defaults to the available number of cores of the deployment. Lower it to leave resources for real-time scoring.
        :param pulumi.Input['BatchPredictionJobDefinitionOutputSettingsArgs'] output_settings: A dict configuring how scored data is to be saved.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] passthrough_columns: Keep these columns from the scoring dataset in the scored dataset. This is useful for correlating predictions with source data.
        :param pulumi.Input[str] passthrough_columns_set: To pass through every column from the scoring dataset, set this to all.
        :param pulumi.Input['BatchPredictionJobDefinitionPredictionInstanceArgs'] prediction_instance: Defaults to instance specified by deployment or system configuration.
        :param pulumi.Input[float] prediction_threshold: Threshold is the point that sets the class boundary for a predicted value. This value can be set between 0.0 and 1.0.
        :param pulumi.Input[bool] prediction_warning_enabled: Add prediction warnings to the scored data. Currently only supported for regression models. Defaults to False.
        :param pulumi.Input['BatchPredictionJobDefinitionScheduleArgs'] schedule: Defines at what intervals the job should run.
        :param pulumi.Input[bool] skip_drift_tracking: Skips drift tracking on any predictions made from this job. This is useful when running non-production workloads to not affect drift tracking and cause unnecessary alerts. Defaults to false.
        :param pulumi.Input[float] threshold_high: Only compute prediction explanations for predictions above this threshold. Can be combined with threshold_low.
        :param pulumi.Input[float] threshold_low: Only compute prediction explanations for predictions below this threshold. Can be combined with threshold_high.
        :param pulumi.Input['BatchPredictionJobDefinitionTimeseriesSettingsArgs'] timeseries_settings: Configuration for time-series scoring.
        """
        if abort_on_error is not None:
            pulumi.set(__self__, "abort_on_error", abort_on_error)
        if chunk_size is not None:
            pulumi.set(__self__, "chunk_size", chunk_size)
        if column_names_remapping is not None:
            pulumi.set(__self__, "column_names_remapping", column_names_remapping)
        if csv_settings is not None:
            pulumi.set(__self__, "csv_settings", csv_settings)
        if deployment_id is not None:
            pulumi.set(__self__, "deployment_id", deployment_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if explanation_algorithm is not None:
            pulumi.set(__self__, "explanation_algorithm", explanation_algorithm)
        if include_prediction_status is not None:
            pulumi.set(__self__, "include_prediction_status", include_prediction_status)
        if include_probabilities is not None:
            pulumi.set(__self__, "include_probabilities", include_probabilities)
        if include_probabilities_classes is not None:
            pulumi.set(__self__, "include_probabilities_classes", include_probabilities_classes)
        if intake_settings is not None:
            pulumi.set(__self__, "intake_settings", intake_settings)
        if max_explanations is not None:
            pulumi.set(__self__, "max_explanations", max_explanations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if num_concurrent is not None:
            pulumi.set(__self__, "num_concurrent", num_concurrent)
        if output_settings is not None:
            pulumi.set(__self__, "output_settings", output_settings)
        if passthrough_columns is not None:
            pulumi.set(__self__, "passthrough_columns", passthrough_columns)
        if passthrough_columns_set is not None:
            pulumi.set(__self__, "passthrough_columns_set", passthrough_columns_set)
        if prediction_instance is not None:
            pulumi.set(__self__, "prediction_instance", prediction_instance)
        if prediction_threshold is not None:
            pulumi.set(__self__, "prediction_threshold", prediction_threshold)
        if prediction_warning_enabled is not None:
            pulumi.set(__self__, "prediction_warning_enabled", prediction_warning_enabled)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if skip_drift_tracking is not None:
            pulumi.set(__self__, "skip_drift_tracking", skip_drift_tracking)
        if threshold_high is not None:
            pulumi.set(__self__, "threshold_high", threshold_high)
        if threshold_low is not None:
            pulumi.set(__self__, "threshold_low", threshold_low)
        if timeseries_settings is not None:
            pulumi.set(__self__, "timeseries_settings", timeseries_settings)

    @property
    @pulumi.getter(name="abortOnError")
    def abort_on_error(self) -> Optional[pulumi.Input[bool]]:
        """
        Default behavior is to abort the job if too many rows fail scoring. This will free up resources for other jobs that may score successfully. Set to false to unconditionally score every row no matter how many errors are encountered. Defaults to True.
        """
        return pulumi.get(self, "abort_on_error")

    @abort_on_error.setter
    def abort_on_error(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "abort_on_error", value)

    @property
    @pulumi.getter(name="chunkSize")
    def chunk_size(self) -> Optional[Any]:
        """
        Which strategy should be used to determine the chunk size. Can be either a named strategy or a fixed size in bytes.
        """
        return pulumi.get(self, "chunk_size")

    @chunk_size.setter
    def chunk_size(self, value: Optional[Any]):
        pulumi.set(self, "chunk_size", value)

    @property
    @pulumi.getter(name="columnNamesRemapping")
    def column_names_remapping(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Mapping with column renaming for output table.
        """
        return pulumi.get(self, "column_names_remapping")

    @column_names_remapping.setter
    def column_names_remapping(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "column_names_remapping", value)

    @property
    @pulumi.getter(name="csvSettings")
    def csv_settings(self) -> Optional[pulumi.Input['BatchPredictionJobDefinitionCsvSettingsArgs']]:
        """
        CSV intake and output settings.
        """
        return pulumi.get(self, "csv_settings")

    @csv_settings.setter
    def csv_settings(self, value: Optional[pulumi.Input['BatchPredictionJobDefinitionCsvSettingsArgs']]):
        pulumi.set(self, "csv_settings", value)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the deployment to use for the batch prediction job.
        """
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_id", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the job definition should be active on a scheduled basis. If True, schedule is required.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="explanationAlgorithm")
    def explanation_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        Which algorithm will be used to calculate prediction explanations.
        """
        return pulumi.get(self, "explanation_algorithm")

    @explanation_algorithm.setter
    def explanation_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "explanation_algorithm", value)

    @property
    @pulumi.getter(name="includePredictionStatus")
    def include_prediction_status(self) -> Optional[pulumi.Input[bool]]:
        """
        Include the prediction_status column in the output. Defaults to False.
        """
        return pulumi.get(self, "include_prediction_status")

    @include_prediction_status.setter
    def include_prediction_status(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_prediction_status", value)

    @property
    @pulumi.getter(name="includeProbabilities")
    def include_probabilities(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag that enables returning of all probability columns. Defaults to True.
        """
        return pulumi.get(self, "include_probabilities")

    @include_probabilities.setter
    def include_probabilities(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_probabilities", value)

    @property
    @pulumi.getter(name="includeProbabilitiesClasses")
    def include_probabilities_classes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List the subset of classes if a user doesn’t want all the classes. Defaults to [].
        """
        return pulumi.get(self, "include_probabilities_classes")

    @include_probabilities_classes.setter
    def include_probabilities_classes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "include_probabilities_classes", value)

    @property
    @pulumi.getter(name="intakeSettings")
    def intake_settings(self) -> Optional[pulumi.Input['BatchPredictionJobDefinitionIntakeSettingsArgs']]:
        """
        A dict configuring how data is coming from.
        """
        return pulumi.get(self, "intake_settings")

    @intake_settings.setter
    def intake_settings(self, value: Optional[pulumi.Input['BatchPredictionJobDefinitionIntakeSettingsArgs']]):
        pulumi.set(self, "intake_settings", value)

    @property
    @pulumi.getter(name="maxExplanations")
    def max_explanations(self) -> Optional[pulumi.Input[int]]:
        """
        Compute prediction explanations for this amount of features.
        """
        return pulumi.get(self, "max_explanations")

    @max_explanations.setter
    def max_explanations(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_explanations", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name you want your job to be identified with. Must be unique across the organization’s existing jobs.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numConcurrent")
    def num_concurrent(self) -> Optional[pulumi.Input[int]]:
        """
        Number of concurrent chunks to score simultaneously. Defaults to the available number of cores of the deployment. Lower it to leave resources for real-time scoring.
        """
        return pulumi.get(self, "num_concurrent")

    @num_concurrent.setter
    def num_concurrent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_concurrent", value)

    @property
    @pulumi.getter(name="outputSettings")
    def output_settings(self) -> Optional[pulumi.Input['BatchPredictionJobDefinitionOutputSettingsArgs']]:
        """
        A dict configuring how scored data is to be saved.
        """
        return pulumi.get(self, "output_settings")

    @output_settings.setter
    def output_settings(self, value: Optional[pulumi.Input['BatchPredictionJobDefinitionOutputSettingsArgs']]):
        pulumi.set(self, "output_settings", value)

    @property
    @pulumi.getter(name="passthroughColumns")
    def passthrough_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Keep these columns from the scoring dataset in the scored dataset. This is useful for correlating predictions with source data.
        """
        return pulumi.get(self, "passthrough_columns")

    @passthrough_columns.setter
    def passthrough_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "passthrough_columns", value)

    @property
    @pulumi.getter(name="passthroughColumnsSet")
    def passthrough_columns_set(self) -> Optional[pulumi.Input[str]]:
        """
        To pass through every column from the scoring dataset, set this to all.
        """
        return pulumi.get(self, "passthrough_columns_set")

    @passthrough_columns_set.setter
    def passthrough_columns_set(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "passthrough_columns_set", value)

    @property
    @pulumi.getter(name="predictionInstance")
    def prediction_instance(self) -> Optional[pulumi.Input['BatchPredictionJobDefinitionPredictionInstanceArgs']]:
        """
        Defaults to instance specified by deployment or system configuration.
        """
        return pulumi.get(self, "prediction_instance")

    @prediction_instance.setter
    def prediction_instance(self, value: Optional[pulumi.Input['BatchPredictionJobDefinitionPredictionInstanceArgs']]):
        pulumi.set(self, "prediction_instance", value)

    @property
    @pulumi.getter(name="predictionThreshold")
    def prediction_threshold(self) -> Optional[pulumi.Input[float]]:
        """
        Threshold is the point that sets the class boundary for a predicted value. This value can be set between 0.0 and 1.0.
        """
        return pulumi.get(self, "prediction_threshold")

    @prediction_threshold.setter
    def prediction_threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "prediction_threshold", value)

    @property
    @pulumi.getter(name="predictionWarningEnabled")
    def prediction_warning_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Add prediction warnings to the scored data. Currently only supported for regression models. Defaults to False.
        """
        return pulumi.get(self, "prediction_warning_enabled")

    @prediction_warning_enabled.setter
    def prediction_warning_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "prediction_warning_enabled", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['BatchPredictionJobDefinitionScheduleArgs']]:
        """
        Defines at what intervals the job should run.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['BatchPredictionJobDefinitionScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="skipDriftTracking")
    def skip_drift_tracking(self) -> Optional[pulumi.Input[bool]]:
        """
        Skips drift tracking on any predictions made from this job. This is useful when running non-production workloads to not affect drift tracking and cause unnecessary alerts. Defaults to false.
        """
        return pulumi.get(self, "skip_drift_tracking")

    @skip_drift_tracking.setter
    def skip_drift_tracking(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_drift_tracking", value)

    @property
    @pulumi.getter(name="thresholdHigh")
    def threshold_high(self) -> Optional[pulumi.Input[float]]:
        """
        Only compute prediction explanations for predictions above this threshold. Can be combined with threshold_low.
        """
        return pulumi.get(self, "threshold_high")

    @threshold_high.setter
    def threshold_high(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "threshold_high", value)

    @property
    @pulumi.getter(name="thresholdLow")
    def threshold_low(self) -> Optional[pulumi.Input[float]]:
        """
        Only compute prediction explanations for predictions below this threshold. Can be combined with threshold_high.
        """
        return pulumi.get(self, "threshold_low")

    @threshold_low.setter
    def threshold_low(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "threshold_low", value)

    @property
    @pulumi.getter(name="timeseriesSettings")
    def timeseries_settings(self) -> Optional[pulumi.Input['BatchPredictionJobDefinitionTimeseriesSettingsArgs']]:
        """
        Configuration for time-series scoring.
        """
        return pulumi.get(self, "timeseries_settings")

    @timeseries_settings.setter
    def timeseries_settings(self, value: Optional[pulumi.Input['BatchPredictionJobDefinitionTimeseriesSettingsArgs']]):
        pulumi.set(self, "timeseries_settings", value)


class BatchPredictionJobDefinition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 abort_on_error: Optional[pulumi.Input[bool]] = None,
                 chunk_size: Optional[Any] = None,
                 column_names_remapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 csv_settings: Optional[pulumi.Input[Union['BatchPredictionJobDefinitionCsvSettingsArgs', 'BatchPredictionJobDefinitionCsvSettingsArgsDict']]] = None,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 explanation_algorithm: Optional[pulumi.Input[str]] = None,
                 include_prediction_status: Optional[pulumi.Input[bool]] = None,
                 include_probabilities: Optional[pulumi.Input[bool]] = None,
                 include_probabilities_classes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 intake_settings: Optional[pulumi.Input[Union['BatchPredictionJobDefinitionIntakeSettingsArgs', 'BatchPredictionJobDefinitionIntakeSettingsArgsDict']]] = None,
                 max_explanations: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 num_concurrent: Optional[pulumi.Input[int]] = None,
                 output_settings: Optional[pulumi.Input[Union['BatchPredictionJobDefinitionOutputSettingsArgs', 'BatchPredictionJobDefinitionOutputSettingsArgsDict']]] = None,
                 passthrough_columns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 passthrough_columns_set: Optional[pulumi.Input[str]] = None,
                 prediction_instance: Optional[pulumi.Input[Union['BatchPredictionJobDefinitionPredictionInstanceArgs', 'BatchPredictionJobDefinitionPredictionInstanceArgsDict']]] = None,
                 prediction_threshold: Optional[pulumi.Input[float]] = None,
                 prediction_warning_enabled: Optional[pulumi.Input[bool]] = None,
                 schedule: Optional[pulumi.Input[Union['BatchPredictionJobDefinitionScheduleArgs', 'BatchPredictionJobDefinitionScheduleArgsDict']]] = None,
                 skip_drift_tracking: Optional[pulumi.Input[bool]] = None,
                 threshold_high: Optional[pulumi.Input[float]] = None,
                 threshold_low: Optional[pulumi.Input[float]] = None,
                 timeseries_settings: Optional[pulumi.Input[Union['BatchPredictionJobDefinitionTimeseriesSettingsArgs', 'BatchPredictionJobDefinitionTimeseriesSettingsArgsDict']]] = None,
                 __props__=None):
        """
        Batch Prediction Job Definition

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] abort_on_error: Default behavior is to abort the job if too many rows fail scoring. This will free up resources for other jobs that may score successfully. Set to false to unconditionally score every row no matter how many errors are encountered. Defaults to True.
        :param Any chunk_size: Which strategy should be used to determine the chunk size. Can be either a named strategy or a fixed size in bytes.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] column_names_remapping: Mapping with column renaming for output table.
        :param pulumi.Input[Union['BatchPredictionJobDefinitionCsvSettingsArgs', 'BatchPredictionJobDefinitionCsvSettingsArgsDict']] csv_settings: CSV intake and output settings.
        :param pulumi.Input[str] deployment_id: The ID of the deployment to use for the batch prediction job.
        :param pulumi.Input[bool] enabled: Whether or not the job definition should be active on a scheduled basis. If True, schedule is required.
        :param pulumi.Input[str] explanation_algorithm: Which algorithm will be used to calculate prediction explanations.
        :param pulumi.Input[bool] include_prediction_status: Include the prediction_status column in the output. Defaults to False.
        :param pulumi.Input[bool] include_probabilities: Flag that enables returning of all probability columns. Defaults to True.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] include_probabilities_classes: List the subset of classes if a user doesn’t want all the classes. Defaults to [].
        :param pulumi.Input[Union['BatchPredictionJobDefinitionIntakeSettingsArgs', 'BatchPredictionJobDefinitionIntakeSettingsArgsDict']] intake_settings: A dict configuring how data is coming from.
        :param pulumi.Input[int] max_explanations: Compute prediction explanations for this amount of features.
        :param pulumi.Input[str] name: The name you want your job to be identified with. Must be unique across the organization’s existing jobs.
        :param pulumi.Input[int] num_concurrent: Number of concurrent chunks to score simultaneously. Defaults to the available number of cores of the deployment. Lower it to leave resources for real-time scoring.
        :param pulumi.Input[Union['BatchPredictionJobDefinitionOutputSettingsArgs', 'BatchPredictionJobDefinitionOutputSettingsArgsDict']] output_settings: A dict configuring how scored data is to be saved.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] passthrough_columns: Keep these columns from the scoring dataset in the scored dataset. This is useful for correlating predictions with source data.
        :param pulumi.Input[str] passthrough_columns_set: To pass through every column from the scoring dataset, set this to all.
        :param pulumi.Input[Union['BatchPredictionJobDefinitionPredictionInstanceArgs', 'BatchPredictionJobDefinitionPredictionInstanceArgsDict']] prediction_instance: Defaults to instance specified by deployment or system configuration.
        :param pulumi.Input[float] prediction_threshold: Threshold is the point that sets the class boundary for a predicted value. This value can be set between 0.0 and 1.0.
        :param pulumi.Input[bool] prediction_warning_enabled: Add prediction warnings to the scored data. Currently only supported for regression models. Defaults to False.
        :param pulumi.Input[Union['BatchPredictionJobDefinitionScheduleArgs', 'BatchPredictionJobDefinitionScheduleArgsDict']] schedule: Defines at what intervals the job should run.
        :param pulumi.Input[bool] skip_drift_tracking: Skips drift tracking on any predictions made from this job. This is useful when running non-production workloads to not affect drift tracking and cause unnecessary alerts. Defaults to false.
        :param pulumi.Input[float] threshold_high: Only compute prediction explanations for predictions above this threshold. Can be combined with threshold_low.
        :param pulumi.Input[float] threshold_low: Only compute prediction explanations for predictions below this threshold. Can be combined with threshold_high.
        :param pulumi.Input[Union['BatchPredictionJobDefinitionTimeseriesSettingsArgs', 'BatchPredictionJobDefinitionTimeseriesSettingsArgsDict']] timeseries_settings: Configuration for time-series scoring.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BatchPredictionJobDefinitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Batch Prediction Job Definition

        :param str resource_name: The name of the resource.
        :param BatchPredictionJobDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BatchPredictionJobDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 abort_on_error: Optional[pulumi.Input[bool]] = None,
                 chunk_size: Optional[Any] = None,
                 column_names_remapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 csv_settings: Optional[pulumi.Input[Union['BatchPredictionJobDefinitionCsvSettingsArgs', 'BatchPredictionJobDefinitionCsvSettingsArgsDict']]] = None,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 explanation_algorithm: Optional[pulumi.Input[str]] = None,
                 include_prediction_status: Optional[pulumi.Input[bool]] = None,
                 include_probabilities: Optional[pulumi.Input[bool]] = None,
                 include_probabilities_classes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 intake_settings: Optional[pulumi.Input[Union['BatchPredictionJobDefinitionIntakeSettingsArgs', 'BatchPredictionJobDefinitionIntakeSettingsArgsDict']]] = None,
                 max_explanations: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 num_concurrent: Optional[pulumi.Input[int]] = None,
                 output_settings: Optional[pulumi.Input[Union['BatchPredictionJobDefinitionOutputSettingsArgs', 'BatchPredictionJobDefinitionOutputSettingsArgsDict']]] = None,
                 passthrough_columns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 passthrough_columns_set: Optional[pulumi.Input[str]] = None,
                 prediction_instance: Optional[pulumi.Input[Union['BatchPredictionJobDefinitionPredictionInstanceArgs', 'BatchPredictionJobDefinitionPredictionInstanceArgsDict']]] = None,
                 prediction_threshold: Optional[pulumi.Input[float]] = None,
                 prediction_warning_enabled: Optional[pulumi.Input[bool]] = None,
                 schedule: Optional[pulumi.Input[Union['BatchPredictionJobDefinitionScheduleArgs', 'BatchPredictionJobDefinitionScheduleArgsDict']]] = None,
                 skip_drift_tracking: Optional[pulumi.Input[bool]] = None,
                 threshold_high: Optional[pulumi.Input[float]] = None,
                 threshold_low: Optional[pulumi.Input[float]] = None,
                 timeseries_settings: Optional[pulumi.Input[Union['BatchPredictionJobDefinitionTimeseriesSettingsArgs', 'BatchPredictionJobDefinitionTimeseriesSettingsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BatchPredictionJobDefinitionArgs.__new__(BatchPredictionJobDefinitionArgs)

            __props__.__dict__["abort_on_error"] = abort_on_error
            __props__.__dict__["chunk_size"] = chunk_size
            __props__.__dict__["column_names_remapping"] = column_names_remapping
            __props__.__dict__["csv_settings"] = csv_settings
            if deployment_id is None and not opts.urn:
                raise TypeError("Missing required property 'deployment_id'")
            __props__.__dict__["deployment_id"] = deployment_id
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["explanation_algorithm"] = explanation_algorithm
            __props__.__dict__["include_prediction_status"] = include_prediction_status
            __props__.__dict__["include_probabilities"] = include_probabilities
            __props__.__dict__["include_probabilities_classes"] = include_probabilities_classes
            if intake_settings is None and not opts.urn:
                raise TypeError("Missing required property 'intake_settings'")
            __props__.__dict__["intake_settings"] = intake_settings
            __props__.__dict__["max_explanations"] = max_explanations
            __props__.__dict__["name"] = name
            __props__.__dict__["num_concurrent"] = num_concurrent
            __props__.__dict__["output_settings"] = output_settings
            __props__.__dict__["passthrough_columns"] = passthrough_columns
            __props__.__dict__["passthrough_columns_set"] = passthrough_columns_set
            __props__.__dict__["prediction_instance"] = prediction_instance
            __props__.__dict__["prediction_threshold"] = prediction_threshold
            __props__.__dict__["prediction_warning_enabled"] = prediction_warning_enabled
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["skip_drift_tracking"] = skip_drift_tracking
            __props__.__dict__["threshold_high"] = threshold_high
            __props__.__dict__["threshold_low"] = threshold_low
            __props__.__dict__["timeseries_settings"] = timeseries_settings
        super(BatchPredictionJobDefinition, __self__).__init__(
            'datarobot:index/batchPredictionJobDefinition:BatchPredictionJobDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            abort_on_error: Optional[pulumi.Input[bool]] = None,
            chunk_size: Optional[Any] = None,
            column_names_remapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            csv_settings: Optional[pulumi.Input[Union['BatchPredictionJobDefinitionCsvSettingsArgs', 'BatchPredictionJobDefinitionCsvSettingsArgsDict']]] = None,
            deployment_id: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            explanation_algorithm: Optional[pulumi.Input[str]] = None,
            include_prediction_status: Optional[pulumi.Input[bool]] = None,
            include_probabilities: Optional[pulumi.Input[bool]] = None,
            include_probabilities_classes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            intake_settings: Optional[pulumi.Input[Union['BatchPredictionJobDefinitionIntakeSettingsArgs', 'BatchPredictionJobDefinitionIntakeSettingsArgsDict']]] = None,
            max_explanations: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            num_concurrent: Optional[pulumi.Input[int]] = None,
            output_settings: Optional[pulumi.Input[Union['BatchPredictionJobDefinitionOutputSettingsArgs', 'BatchPredictionJobDefinitionOutputSettingsArgsDict']]] = None,
            passthrough_columns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            passthrough_columns_set: Optional[pulumi.Input[str]] = None,
            prediction_instance: Optional[pulumi.Input[Union['BatchPredictionJobDefinitionPredictionInstanceArgs', 'BatchPredictionJobDefinitionPredictionInstanceArgsDict']]] = None,
            prediction_threshold: Optional[pulumi.Input[float]] = None,
            prediction_warning_enabled: Optional[pulumi.Input[bool]] = None,
            schedule: Optional[pulumi.Input[Union['BatchPredictionJobDefinitionScheduleArgs', 'BatchPredictionJobDefinitionScheduleArgsDict']]] = None,
            skip_drift_tracking: Optional[pulumi.Input[bool]] = None,
            threshold_high: Optional[pulumi.Input[float]] = None,
            threshold_low: Optional[pulumi.Input[float]] = None,
            timeseries_settings: Optional[pulumi.Input[Union['BatchPredictionJobDefinitionTimeseriesSettingsArgs', 'BatchPredictionJobDefinitionTimeseriesSettingsArgsDict']]] = None) -> 'BatchPredictionJobDefinition':
        """
        Get an existing BatchPredictionJobDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] abort_on_error: Default behavior is to abort the job if too many rows fail scoring. This will free up resources for other jobs that may score successfully. Set to false to unconditionally score every row no matter how many errors are encountered. Defaults to True.
        :param Any chunk_size: Which strategy should be used to determine the chunk size. Can be either a named strategy or a fixed size in bytes.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] column_names_remapping: Mapping with column renaming for output table.
        :param pulumi.Input[Union['BatchPredictionJobDefinitionCsvSettingsArgs', 'BatchPredictionJobDefinitionCsvSettingsArgsDict']] csv_settings: CSV intake and output settings.
        :param pulumi.Input[str] deployment_id: The ID of the deployment to use for the batch prediction job.
        :param pulumi.Input[bool] enabled: Whether or not the job definition should be active on a scheduled basis. If True, schedule is required.
        :param pulumi.Input[str] explanation_algorithm: Which algorithm will be used to calculate prediction explanations.
        :param pulumi.Input[bool] include_prediction_status: Include the prediction_status column in the output. Defaults to False.
        :param pulumi.Input[bool] include_probabilities: Flag that enables returning of all probability columns. Defaults to True.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] include_probabilities_classes: List the subset of classes if a user doesn’t want all the classes. Defaults to [].
        :param pulumi.Input[Union['BatchPredictionJobDefinitionIntakeSettingsArgs', 'BatchPredictionJobDefinitionIntakeSettingsArgsDict']] intake_settings: A dict configuring how data is coming from.
        :param pulumi.Input[int] max_explanations: Compute prediction explanations for this amount of features.
        :param pulumi.Input[str] name: The name you want your job to be identified with. Must be unique across the organization’s existing jobs.
        :param pulumi.Input[int] num_concurrent: Number of concurrent chunks to score simultaneously. Defaults to the available number of cores of the deployment. Lower it to leave resources for real-time scoring.
        :param pulumi.Input[Union['BatchPredictionJobDefinitionOutputSettingsArgs', 'BatchPredictionJobDefinitionOutputSettingsArgsDict']] output_settings: A dict configuring how scored data is to be saved.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] passthrough_columns: Keep these columns from the scoring dataset in the scored dataset. This is useful for correlating predictions with source data.
        :param pulumi.Input[str] passthrough_columns_set: To pass through every column from the scoring dataset, set this to all.
        :param pulumi.Input[Union['BatchPredictionJobDefinitionPredictionInstanceArgs', 'BatchPredictionJobDefinitionPredictionInstanceArgsDict']] prediction_instance: Defaults to instance specified by deployment or system configuration.
        :param pulumi.Input[float] prediction_threshold: Threshold is the point that sets the class boundary for a predicted value. This value can be set between 0.0 and 1.0.
        :param pulumi.Input[bool] prediction_warning_enabled: Add prediction warnings to the scored data. Currently only supported for regression models. Defaults to False.
        :param pulumi.Input[Union['BatchPredictionJobDefinitionScheduleArgs', 'BatchPredictionJobDefinitionScheduleArgsDict']] schedule: Defines at what intervals the job should run.
        :param pulumi.Input[bool] skip_drift_tracking: Skips drift tracking on any predictions made from this job. This is useful when running non-production workloads to not affect drift tracking and cause unnecessary alerts. Defaults to false.
        :param pulumi.Input[float] threshold_high: Only compute prediction explanations for predictions above this threshold. Can be combined with threshold_low.
        :param pulumi.Input[float] threshold_low: Only compute prediction explanations for predictions below this threshold. Can be combined with threshold_high.
        :param pulumi.Input[Union['BatchPredictionJobDefinitionTimeseriesSettingsArgs', 'BatchPredictionJobDefinitionTimeseriesSettingsArgsDict']] timeseries_settings: Configuration for time-series scoring.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BatchPredictionJobDefinitionState.__new__(_BatchPredictionJobDefinitionState)

        __props__.__dict__["abort_on_error"] = abort_on_error
        __props__.__dict__["chunk_size"] = chunk_size
        __props__.__dict__["column_names_remapping"] = column_names_remapping
        __props__.__dict__["csv_settings"] = csv_settings
        __props__.__dict__["deployment_id"] = deployment_id
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["explanation_algorithm"] = explanation_algorithm
        __props__.__dict__["include_prediction_status"] = include_prediction_status
        __props__.__dict__["include_probabilities"] = include_probabilities
        __props__.__dict__["include_probabilities_classes"] = include_probabilities_classes
        __props__.__dict__["intake_settings"] = intake_settings
        __props__.__dict__["max_explanations"] = max_explanations
        __props__.__dict__["name"] = name
        __props__.__dict__["num_concurrent"] = num_concurrent
        __props__.__dict__["output_settings"] = output_settings
        __props__.__dict__["passthrough_columns"] = passthrough_columns
        __props__.__dict__["passthrough_columns_set"] = passthrough_columns_set
        __props__.__dict__["prediction_instance"] = prediction_instance
        __props__.__dict__["prediction_threshold"] = prediction_threshold
        __props__.__dict__["prediction_warning_enabled"] = prediction_warning_enabled
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["skip_drift_tracking"] = skip_drift_tracking
        __props__.__dict__["threshold_high"] = threshold_high
        __props__.__dict__["threshold_low"] = threshold_low
        __props__.__dict__["timeseries_settings"] = timeseries_settings
        return BatchPredictionJobDefinition(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="abortOnError")
    def abort_on_error(self) -> pulumi.Output[bool]:
        """
        Default behavior is to abort the job if too many rows fail scoring. This will free up resources for other jobs that may score successfully. Set to false to unconditionally score every row no matter how many errors are encountered. Defaults to True.
        """
        return pulumi.get(self, "abort_on_error")

    @property
    @pulumi.getter(name="chunkSize")
    def chunk_size(self) -> pulumi.Output[Optional[Any]]:
        """
        Which strategy should be used to determine the chunk size. Can be either a named strategy or a fixed size in bytes.
        """
        return pulumi.get(self, "chunk_size")

    @property
    @pulumi.getter(name="columnNamesRemapping")
    def column_names_remapping(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Mapping with column renaming for output table.
        """
        return pulumi.get(self, "column_names_remapping")

    @property
    @pulumi.getter(name="csvSettings")
    def csv_settings(self) -> pulumi.Output['outputs.BatchPredictionJobDefinitionCsvSettings']:
        """
        CSV intake and output settings.
        """
        return pulumi.get(self, "csv_settings")

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> pulumi.Output[str]:
        """
        The ID of the deployment to use for the batch prediction job.
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        Whether or not the job definition should be active on a scheduled basis. If True, schedule is required.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="explanationAlgorithm")
    def explanation_algorithm(self) -> pulumi.Output[str]:
        """
        Which algorithm will be used to calculate prediction explanations.
        """
        return pulumi.get(self, "explanation_algorithm")

    @property
    @pulumi.getter(name="includePredictionStatus")
    def include_prediction_status(self) -> pulumi.Output[bool]:
        """
        Include the prediction_status column in the output. Defaults to False.
        """
        return pulumi.get(self, "include_prediction_status")

    @property
    @pulumi.getter(name="includeProbabilities")
    def include_probabilities(self) -> pulumi.Output[bool]:
        """
        Flag that enables returning of all probability columns. Defaults to True.
        """
        return pulumi.get(self, "include_probabilities")

    @property
    @pulumi.getter(name="includeProbabilitiesClasses")
    def include_probabilities_classes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List the subset of classes if a user doesn’t want all the classes. Defaults to [].
        """
        return pulumi.get(self, "include_probabilities_classes")

    @property
    @pulumi.getter(name="intakeSettings")
    def intake_settings(self) -> pulumi.Output['outputs.BatchPredictionJobDefinitionIntakeSettings']:
        """
        A dict configuring how data is coming from.
        """
        return pulumi.get(self, "intake_settings")

    @property
    @pulumi.getter(name="maxExplanations")
    def max_explanations(self) -> pulumi.Output[int]:
        """
        Compute prediction explanations for this amount of features.
        """
        return pulumi.get(self, "max_explanations")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name you want your job to be identified with. Must be unique across the organization’s existing jobs.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numConcurrent")
    def num_concurrent(self) -> pulumi.Output[Optional[int]]:
        """
        Number of concurrent chunks to score simultaneously. Defaults to the available number of cores of the deployment. Lower it to leave resources for real-time scoring.
        """
        return pulumi.get(self, "num_concurrent")

    @property
    @pulumi.getter(name="outputSettings")
    def output_settings(self) -> pulumi.Output['outputs.BatchPredictionJobDefinitionOutputSettings']:
        """
        A dict configuring how scored data is to be saved.
        """
        return pulumi.get(self, "output_settings")

    @property
    @pulumi.getter(name="passthroughColumns")
    def passthrough_columns(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Keep these columns from the scoring dataset in the scored dataset. This is useful for correlating predictions with source data.
        """
        return pulumi.get(self, "passthrough_columns")

    @property
    @pulumi.getter(name="passthroughColumnsSet")
    def passthrough_columns_set(self) -> pulumi.Output[Optional[str]]:
        """
        To pass through every column from the scoring dataset, set this to all.
        """
        return pulumi.get(self, "passthrough_columns_set")

    @property
    @pulumi.getter(name="predictionInstance")
    def prediction_instance(self) -> pulumi.Output[Optional['outputs.BatchPredictionJobDefinitionPredictionInstance']]:
        """
        Defaults to instance specified by deployment or system configuration.
        """
        return pulumi.get(self, "prediction_instance")

    @property
    @pulumi.getter(name="predictionThreshold")
    def prediction_threshold(self) -> pulumi.Output[Optional[float]]:
        """
        Threshold is the point that sets the class boundary for a predicted value. This value can be set between 0.0 and 1.0.
        """
        return pulumi.get(self, "prediction_threshold")

    @property
    @pulumi.getter(name="predictionWarningEnabled")
    def prediction_warning_enabled(self) -> pulumi.Output[bool]:
        """
        Add prediction warnings to the scored data. Currently only supported for regression models. Defaults to False.
        """
        return pulumi.get(self, "prediction_warning_enabled")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[Optional['outputs.BatchPredictionJobDefinitionSchedule']]:
        """
        Defines at what intervals the job should run.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="skipDriftTracking")
    def skip_drift_tracking(self) -> pulumi.Output[bool]:
        """
        Skips drift tracking on any predictions made from this job. This is useful when running non-production workloads to not affect drift tracking and cause unnecessary alerts. Defaults to false.
        """
        return pulumi.get(self, "skip_drift_tracking")

    @property
    @pulumi.getter(name="thresholdHigh")
    def threshold_high(self) -> pulumi.Output[Optional[float]]:
        """
        Only compute prediction explanations for predictions above this threshold. Can be combined with threshold_low.
        """
        return pulumi.get(self, "threshold_high")

    @property
    @pulumi.getter(name="thresholdLow")
    def threshold_low(self) -> pulumi.Output[Optional[float]]:
        """
        Only compute prediction explanations for predictions below this threshold. Can be combined with threshold_high.
        """
        return pulumi.get(self, "threshold_low")

    @property
    @pulumi.getter(name="timeseriesSettings")
    def timeseries_settings(self) -> pulumi.Output[Optional['outputs.BatchPredictionJobDefinitionTimeseriesSettings']]:
        """
        Configuration for time-series scoring.
        """
        return pulumi.get(self, "timeseries_settings")

