"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScheduledFargateTask = void 0;
const aws_ecs_1 = require("@aws-cdk/aws-ecs");
const scheduled_task_base_1 = require("../base/scheduled-task-base");
/**
 * A scheduled Fargate task that will be initiated off of CloudWatch Events.
 */
class ScheduledFargateTask extends scheduled_task_base_1.ScheduledTaskBase {
    /**
     * Constructs a new instance of the ScheduledFargateTask class.
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        if (props.scheduledFargateTaskDefinitionOptions && props.scheduledFargateTaskImageOptions) {
            throw new Error('You must specify either a scheduledFargateTaskDefinitionOptions or scheduledFargateTaskOptions, not both.');
        }
        else if (props.scheduledFargateTaskDefinitionOptions) {
            this.taskDefinition = props.scheduledFargateTaskDefinitionOptions.taskDefinition;
        }
        else if (props.scheduledFargateTaskImageOptions) {
            const taskImageOptions = props.scheduledFargateTaskImageOptions;
            this.taskDefinition = new aws_ecs_1.FargateTaskDefinition(this, 'ScheduledTaskDef', {
                memoryLimitMiB: taskImageOptions.memoryLimitMiB || 512,
                cpu: taskImageOptions.cpu || 256,
            });
            this.taskDefinition.addContainer('ScheduledContainer', {
                image: taskImageOptions.image,
                command: taskImageOptions.command,
                environment: taskImageOptions.environment,
                secrets: taskImageOptions.secrets,
                logging: taskImageOptions.logDriver !== undefined ? taskImageOptions.logDriver : this.createAWSLogDriver(this.node.id),
            });
        }
        else {
            throw new Error('You must specify one of: taskDefinition or image');
        }
        this.addTaskDefinitionToEventTarget(this.taskDefinition);
    }
}
exports.ScheduledFargateTask = ScheduledFargateTask;
//# sourceMappingURL=data:application/json;base64,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