"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventbridgeToSns = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("aws-cdk-lib/aws-events");
const defaults = require("@aws-solutions-constructs/core");
const cdk = require("aws-cdk-lib");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
const core_1 = require("@aws-solutions-constructs/core");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
class EventbridgeToSns extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the EventbridgeToSns class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {EventbridgeToSnsProps} props - user provided props for the construct.
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckSnsProps(props);
        defaults.CheckEventBridgeProps(props);
        let enableEncryptionParam = props.enableEncryptionWithCustomerManagedKey;
        if (props.enableEncryptionWithCustomerManagedKey === undefined ||
            props.enableEncryptionWithCustomerManagedKey === true) {
            enableEncryptionParam = true;
        }
        // Setup the sns topic.
        const buildTopicResponse = defaults.buildTopic(this, {
            existingTopicObj: props.existingTopicObj,
            topicProps: props.topicProps,
            enableEncryptionWithCustomerManagedKey: enableEncryptionParam,
            encryptionKey: props.encryptionKey,
            encryptionKeyProps: props.encryptionKeyProps
        });
        this.snsTopic = buildTopicResponse.topic;
        this.encryptionKey = buildTopicResponse.key;
        // Setup the event rule target as sns topic.
        // The CDK generally avoids resource names that are too long, but in this case the maximum SNS topic name is 256 characters and the maximum
        // binding id is 64 characters, so a long SNS topic name (driven by Stack id, Construct id, etc.) breaks upon launch. Because of this, we take
        // control of the physical name ourselves.
        const maxBindingIdLength = 64;
        const nameParts = [
            cdk.Stack.of(scope).stackName,
            id,
        ];
        const generatedTopicName = defaults.generatePhysicalName("", nameParts, maxBindingIdLength);
        const topicEventTarget = {
            bind: () => ({
                id: generatedTopicName,
                arn: this.snsTopic.topicArn
            })
        };
        // build an event bus if existingEventBus is provided or eventBusProps are provided
        this.eventBus = defaults.buildEventBus(this, {
            existingEventBusInterface: props.existingEventBusInterface,
            eventBusProps: props.eventBusProps
        });
        // Setup up the event rule property.
        const defaultEventsRuleProps = defaults.DefaultEventsRuleProps([topicEventTarget], this.eventBus);
        const eventsRuleProps = core_1.overrideProps(defaultEventsRuleProps, props.eventRuleProps, true);
        // Setup up the event rule.
        this.eventsRule = new events.Rule(this, 'EventsRule', eventsRuleProps);
        // Setup up the grant policy for event to be able to publish to the sns topic.
        this.snsTopic.grantPublish(new aws_iam_1.ServicePrincipal('events.amazonaws.com'));
        // Grant EventBridge service access to the SNS Topic encryption key
        this.encryptionKey?.grant(new aws_iam_1.ServicePrincipal('events.amazonaws.com'), "kms:Decrypt", "kms:Encrypt", "kms:ReEncrypt*", "kms:GenerateDataKey*");
    }
}
exports.EventbridgeToSns = EventbridgeToSns;
_a = JSII_RTTI_SYMBOL_1;
EventbridgeToSns[_a] = { fqn: "@aws-solutions-constructs/aws-eventbridge-sns.EventbridgeToSns", version: "2.48.0" };
//# sourceMappingURL=data:application/json;base64,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