"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualServiceProvider = exports.VirtualService = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const appmesh_generated_1 = require("./appmesh.generated");
const mesh_1 = require("./mesh");
const utils_1 = require("./private/utils");
/**
 * VirtualService represents a service inside an AppMesh
 *
 * It routes traffic either to a Virtual Node or to a Virtual Router.
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_services.html
 */
class VirtualService extends cdk.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.virtualServiceName || cdk.Lazy.string({ produce: () => cdk.Names.uniqueId(this) }),
        });
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_VirtualServiceProps(props);
        const providerConfig = props.virtualServiceProvider.bind(this);
        this.mesh = providerConfig.mesh;
        const svc = new appmesh_generated_1.CfnVirtualService(this, 'Resource', {
            meshName: this.mesh.meshName,
            meshOwner: utils_1.renderMeshOwner(this.env.account, this.mesh.env.account),
            virtualServiceName: this.physicalName,
            spec: {
                provider: providerConfig.virtualNodeProvider || providerConfig.virtualRouterProvider
                    ? {
                        virtualNode: providerConfig.virtualNodeProvider,
                        virtualRouter: providerConfig.virtualRouterProvider,
                    }
                    : undefined,
            },
        });
        this.virtualServiceName = this.getResourceNameAttribute(svc.attrVirtualServiceName);
        this.virtualServiceArn = this.getResourceArnAttribute(svc.ref, {
            service: 'appmesh',
            resource: `mesh/${this.mesh.meshName}/virtualService`,
            resourceName: this.physicalName,
        });
    }
    /**
     * Import an existing VirtualService given an ARN
     */
    static fromVirtualServiceArn(scope, id, virtualServiceArn) {
        return new class extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.virtualServiceArn = virtualServiceArn;
                this.parsedArn = cdk.Fn.split('/', cdk.Stack.of(scope).splitArn(virtualServiceArn, cdk.ArnFormat.SLASH_RESOURCE_NAME).resourceName);
                this.virtualServiceName = cdk.Fn.select(2, this.parsedArn);
                this.mesh = mesh_1.Mesh.fromMeshName(this, 'Mesh', cdk.Fn.select(0, this.parsedArn));
            }
        }(scope, id);
    }
    /**
     * Import an existing VirtualService given its attributes
     */
    static fromVirtualServiceAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_VirtualServiceAttributes(attrs);
        return new class extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.virtualServiceName = attrs.virtualServiceName;
                this.mesh = attrs.mesh;
                this.virtualServiceArn = cdk.Stack.of(this).formatArn({
                    service: 'appmesh',
                    resource: `mesh/${attrs.mesh.meshName}/virtualService`,
                    resourceName: this.virtualServiceName,
                });
            }
        }(scope, id);
    }
}
exports.VirtualService = VirtualService;
_a = JSII_RTTI_SYMBOL_1;
VirtualService[_a] = { fqn: "@aws-cdk/aws-appmesh.VirtualService", version: "1.146.0" };
/**
 * Represents the properties needed to define the provider for a VirtualService
 */
class VirtualServiceProvider {
    /**
     * Returns a VirtualNode based Provider for a VirtualService
     */
    static virtualNode(virtualNode) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_IVirtualNode(virtualNode);
        return new VirtualServiceProviderImpl(virtualNode, undefined);
    }
    /**
     * Returns a VirtualRouter based Provider for a VirtualService
     */
    static virtualRouter(virtualRouter) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_IVirtualRouter(virtualRouter);
        return new VirtualServiceProviderImpl(undefined, virtualRouter);
    }
    /**
     * Returns an Empty Provider for a VirtualService. This provides no routing capabilities
     * and should only be used as a placeholder
     */
    static none(mesh) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_IMesh(mesh);
        return new VirtualServiceProviderImpl(undefined, undefined, mesh);
    }
}
exports.VirtualServiceProvider = VirtualServiceProvider;
_b = JSII_RTTI_SYMBOL_1;
VirtualServiceProvider[_b] = { fqn: "@aws-cdk/aws-appmesh.VirtualServiceProvider", version: "1.146.0" };
class VirtualServiceProviderImpl extends VirtualServiceProvider {
    constructor(virtualNode, virtualRouter, mesh) {
        var _c, _d, _e, _f;
        super();
        this.virtualNode = virtualNode;
        this.virtualRouter = virtualRouter;
        const providedMesh = (_f = (_d = (_c = this.virtualNode) === null || _c === void 0 ? void 0 : _c.mesh) !== null && _d !== void 0 ? _d : (_e = this.virtualRouter) === null || _e === void 0 ? void 0 : _e.mesh) !== null && _f !== void 0 ? _f : mesh;
        this.mesh = providedMesh;
    }
    bind(_construct) {
        return {
            mesh: this.mesh,
            virtualNodeProvider: this.virtualNode
                ? {
                    virtualNodeName: this.virtualNode.virtualNodeName,
                }
                : undefined,
            virtualRouterProvider: this.virtualRouter
                ? {
                    virtualRouterName: this.virtualRouter.virtualRouterName,
                }
                : undefined,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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