"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceDiscovery = exports.DnsResponseType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Enum of DNS service discovery response type
 */
var DnsResponseType;
(function (DnsResponseType) {
    /**
     * DNS resolver returns a loadbalanced set of endpoints and the traffic would be sent to the given endpoints.
     * It would not drain existing connections to other endpoints that are not part of this list.
     */
    DnsResponseType["LOAD_BALANCER"] = "LOADBALANCER";
    /**
     * DNS resolver is returning all the endpoints.
     * This also means that if an endpoint is missing, it would drain the current connections to the missing endpoint.
     */
    DnsResponseType["ENDPOINTS"] = "ENDPOINTS";
})(DnsResponseType = exports.DnsResponseType || (exports.DnsResponseType = {}));
/**
 * Provides the Service Discovery method a VirtualNode uses
 */
class ServiceDiscovery {
    /**
     * Returns DNS based service discovery
     *
     * @param hostname
     * @param responseType Specifies the DNS response type for the virtual node.
     *  The default is `DnsResponseType.LOAD_BALANCER`.
     */
    static dns(hostname, responseType) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_DnsResponseType(responseType);
        return new DnsServiceDiscovery(hostname, responseType);
    }
    /**
     * Returns Cloud Map based service discovery
     *
     * @param service The AWS Cloud Map Service to use for service discovery
     * @param instanceAttributes A string map that contains attributes with values that you can use to
     *  filter instances by any custom attribute that you specified when you
     *  registered the instance. Only instances that match all of the specified
     *  key/value pairs will be returned.
     */
    static cloudMap(service, instanceAttributes) {
        return new CloudMapServiceDiscovery(service, instanceAttributes);
    }
}
exports.ServiceDiscovery = ServiceDiscovery;
_a = JSII_RTTI_SYMBOL_1;
ServiceDiscovery[_a] = { fqn: "@aws-cdk/aws-appmesh.ServiceDiscovery", version: "1.146.0" };
class DnsServiceDiscovery extends ServiceDiscovery {
    constructor(hostname, responseType) {
        super();
        this.hostname = hostname;
        this.responseType = responseType;
    }
    bind(_scope) {
        return {
            dns: {
                hostname: this.hostname,
                responseType: this.responseType,
            },
        };
    }
}
class CloudMapServiceDiscovery extends ServiceDiscovery {
    constructor(service, instanceAttributes) {
        super();
        this.service = service;
        this.instanceAttributes = instanceAttributes;
    }
    bind(_scope) {
        return {
            cloudmap: {
                namespaceName: this.service.namespace.namespaceName,
                serviceName: this.service.serviceName,
                attributes: renderAttributes(this.instanceAttributes),
            },
        };
    }
}
function renderAttributes(attrs) {
    if (attrs === undefined) {
        return undefined;
    }
    return Object.entries(attrs).map(([key, value]) => ({ key, value }));
}
//# sourceMappingURL=data:application/json;base64,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