"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mesh = exports.MeshFilterType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const appmesh_generated_1 = require("./appmesh.generated");
const virtual_gateway_1 = require("./virtual-gateway");
const virtual_node_1 = require("./virtual-node");
const virtual_router_1 = require("./virtual-router");
/**
 * A utility enum defined for the egressFilter type property, the default of DROP_ALL,
 * allows traffic only to other resources inside the mesh, or API calls to amazon resources.
 *
 * @default DROP_ALL
 */
var MeshFilterType;
(function (MeshFilterType) {
    /**
     * Allows all outbound traffic
     */
    MeshFilterType["ALLOW_ALL"] = "ALLOW_ALL";
    /**
     * Allows traffic only to other resources inside the mesh, or API calls to amazon resources
     */
    MeshFilterType["DROP_ALL"] = "DROP_ALL";
})(MeshFilterType = exports.MeshFilterType || (exports.MeshFilterType = {}));
/**
 * Represents a new or imported AppMesh mesh
 */
class MeshBase extends cdk.Resource {
    /**
     * Adds a VirtualRouter to the Mesh with the given id and props
     */
    addVirtualRouter(id, props = {}) {
        return new virtual_router_1.VirtualRouter(this, id, {
            ...props,
            mesh: this,
        });
    }
    /**
     * Adds a VirtualNode to the Mesh
     */
    addVirtualNode(id, props = {}) {
        return new virtual_node_1.VirtualNode(this, id, {
            ...props,
            mesh: this,
        });
    }
    /**
     * Adds a VirtualGateway to the Mesh
     */
    addVirtualGateway(id, props) {
        return new virtual_gateway_1.VirtualGateway(this, id, {
            ...props,
            mesh: this,
        });
    }
}
/**
 * Define a new AppMesh mesh
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/meshes.html
 */
class Mesh extends MeshBase {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.meshName || cdk.Lazy.string({ produce: () => cdk.Names.uniqueId(this) }),
        });
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_MeshProps(props);
        const mesh = new appmesh_generated_1.CfnMesh(this, 'Resource', {
            meshName: this.physicalName,
            spec: {
                egressFilter: props.egressFilter ? {
                    type: props.egressFilter,
                } : undefined,
            },
        });
        this.meshName = this.getResourceNameAttribute(mesh.attrMeshName);
        this.meshArn = this.getResourceArnAttribute(mesh.ref, {
            service: 'appmesh',
            resource: 'mesh',
            resourceName: this.physicalName,
        });
    }
    /**
     * Import an existing mesh by arn
     */
    static fromMeshArn(scope, id, meshArn) {
        const parts = cdk.Stack.of(scope).splitArn(meshArn, cdk.ArnFormat.SLASH_RESOURCE_NAME);
        class Import extends MeshBase {
            constructor() {
                super(...arguments);
                this.meshName = parts.resourceName || '';
                this.meshArn = meshArn;
            }
        }
        return new Import(scope, id, {
            environmentFromArn: meshArn,
        });
    }
    /**
     * Import an existing mesh by name
     */
    static fromMeshName(scope, id, meshName) {
        const arn = cdk.Stack.of(scope).formatArn({
            service: 'appmesh',
            resource: 'mesh',
            resourceName: meshName,
        });
        class Import extends MeshBase {
            constructor() {
                super(...arguments);
                this.meshName = meshName;
                this.meshArn = arn;
            }
        }
        return new Import(scope, id);
    }
}
exports.Mesh = Mesh;
_a = JSII_RTTI_SYMBOL_1;
Mesh[_a] = { fqn: "@aws-cdk/aws-appmesh.Mesh", version: "1.146.0" };
//# sourceMappingURL=data:application/json;base64,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