from __future__ import absolute_import, print_function, unicode_literals
from builtins import dict, str
from indra.statements import *
from indra.assemblers.graph import GraphAssembler


def test_phosphorylation():
    st = [Phosphorylation(Agent('MAP2K1'), Agent('MAPK1'))]
    ga = GraphAssembler()
    ga.add_statements(st)
    model = ga.make_model()
    assert 'MAP2K1' in model
    assert len(ga.graph.nodes()) == 2
    assert len(ga.graph.edges()) == 1


def test_phosphorylation_noenz():
    st = [Phosphorylation(None, Agent('MAPK1'))]
    ga = GraphAssembler()
    ga.add_statements(st)
    ga.make_model()
    assert len(ga.graph.nodes()) == 0
    assert len(ga.graph.edges()) == 0


def test_dephosphorylation():
    st = [Dephosphorylation(Agent('DUSP4'), Agent('MAPK1'))]
    ga = GraphAssembler()
    ga.add_statements(st)
    ga.make_model()
    assert len(ga.graph.nodes()) == 2
    assert len(ga.graph.edges()) == 1


def test_dephosphorylation_noenz():
    st = [Dephosphorylation(None, Agent('MAPK1'))]
    ga = GraphAssembler()
    ga.add_statements(st)
    ga.make_model()
    assert len(ga.graph.nodes()) == 0
    assert len(ga.graph.edges()) == 0


def test_activation():
    st = [Activation(Agent('MAP2K1'), Agent('MAPK1'))]
    ga = GraphAssembler()
    ga.add_statements(st)
    ga.make_model()
    assert len(ga.graph.nodes()) == 2
    assert len(ga.graph.edges()) == 1


def test_inactivation():
    st = [Inhibition(Agent('DUSP4'), Agent('MAPK1'))]
    ga = GraphAssembler()
    ga.add_statements(st)
    ga.make_model()
    assert len(ga.graph.nodes()) == 2
    assert len(ga.graph.edges()) == 1


def test_complex():
    st = [Complex([Agent('BRAF'), Agent('RAF1'), Agent('YWAH')])]
    ga = GraphAssembler()
    ga.add_statements(st)
    ga.make_model()
    assert len(ga.graph.nodes()) == 3
    assert len(ga.graph.edges()) == 3


def test_inactivation():
    st = [Inhibition(Agent('DUSP4'), Agent('MAPK1'))]
    ga = GraphAssembler()
    ga.add_statements(st)
    ga.make_model()
    assert len(ga.graph.nodes()) == 2
    assert len(ga.graph.edges()) == 1


def test_influence():
    # Add an extra standalone event just to make sure it doesn't error
    st = [Influence(Event(Concept('a')), Event(Concept('b'))),
          Event(Concept('a'))]
    ga = GraphAssembler()
    ga.add_statements(st)
    ga.make_model()
    assert len(ga.graph.nodes()) == 2
    assert len(ga.graph.edges()) == 1


def test_association():
    st = [Association([Event(Concept('a')), Event(Concept('b'))])]
    ga = GraphAssembler()
    ga.add_statements(st)
    ga.make_model()
    assert len(ga.graph.nodes()) == 2
    assert len(ga.graph.edges()) == 1


def test_duplicates():
    st = [Complex([Agent('BRAF'), Agent('RAF1'), Agent('YWAH')])]
    st += [Complex([Agent('BRAF'), Agent('RAF1')])]
    ga = GraphAssembler()
    ga.add_statements(st)
    ga.make_model()
    assert len(ga.graph.nodes()) == 3
    assert len(ga.graph.edges()) == 3


def test_get_string():
    st = [Phosphorylation(Agent('MAP2K1'), Agent('MAPK1'))]
    ga = GraphAssembler()
    ga.add_statements(st)
    ga.make_model()
    graph_str = ga.get_string()
    assert graph_str


def test_save_dot():
    st = [Phosphorylation(Agent('MAP2K1'), Agent('MAPK1'))]
    ga = GraphAssembler()
    ga.add_statements(st)
    ga.make_model()
    ga.save_dot('/dev/null')


def test_save_pdf():
    st = [Phosphorylation(Agent('MAP2K1'), Agent('MAPK1'))]
    ga = GraphAssembler()
    ga.add_statements(st)
    ga.make_model()
    ga.save_pdf('/dev/null')
