phosphoelm_mapping = {
    'Aurora A': ('HGNC', '11393'),
    'Aurora B': ('HGNC', '11390'),
    'CCDPK': (None, None),  # Non-human gene: https://www.uniprot.org/uniprot/Q9U5L0
    'CK1_delta': ('HGNC', '2452'),  # CSNK1D?? https://www.ncbi.nlm.nih.gov/gene/1453/
    'CK1_epsilon': ('HGNC', '2453'),  # CSNK1E?? https://www.ncbi.nlm.nih.gov/gene/1454
    'CK2_alpha': ('HGNC', '2459'),  # CSNK2A2?? https://www.ncbi.nlm.nih.gov/gene/1459/
    'CK2_beta': ('HGNC', '2460'),  # CSNK2B?? https://www.uniprot.org/uniprot/P67870
    'Eg3 kinase': ('HGNC', '16870'),  # MELK?? https://www.ncbi.nlm.nih.gov/gene/9833
    'MAP2K_group': ('FPLX', 'MAP2K'),
    'PDHK1': ('HGNC', '8809'),  # PDK1: https://www.phosphosite.org/proteinAction.action?id=2352
    'PDHK3': ('HGNC', '8811'),  # PDK3: https://www.uniprot.org/uniprot/Q15120
    'PDHK4': ('HGNC', '8812'),  # PDK4: https://www.uniprot.org/uniprot/Q16654
    'PDKC': (None, None),  # Unknown alias, could be PKC or SDK1 from source: http://www.jbc.org/content/273/34/21834.long
    'PKA_alpha': ('HGNC', '9380'),  # PRKACA?? https://en.wikipedia.org/wiki/PRKACA
    'PKC_eta': ('HGNC', '9403'),  # PRKCH?? https://www.ncbi.nlm.nih.gov/gene/5583
    'PKC_iota': ('HGNC', '9404'),  # PRKCI?? https://www.uniprot.org/uniprot/P41743
    'PKC_zeta': ('HGNC', '9412'),  # PRKCZ?? https://www.ncbi.nlm.nih.gov/gene/5590
    'RSK-5': ('HGNC', '10434'),  # RPS6KA5: https://www.uniprot.org/uniprot/O75582
    'Titin kinase': ('HGNC', '12403')
}
