# -*- coding: utf-8 -*-
#
# This file is part of Invenio.
# Copyright (C) 2015-2018 CERN.
#
# Invenio is free software; you can redistribute it and/or modify it
# under the terms of the MIT License; see LICENSE file for more details.

"""Jinja utilities for Invenio."""

import os

from setuptools import find_packages, setup

readme = open('README.rst').read()
history = open('CHANGES.rst').read()

tests_require = [
    'pytest-invenio~=1.4.1',
]

extras_require = {
    'docs': [
        'Sphinx>=1.8.0',
    ],
    # CairoSVG 2.0.0 only supports Python 3
    'badges:python_version<"3.0"': [
        'CairoSVG>=1.0.20,<2.0.0',
    ],
    'badges:python_version>="3.0"': [
        'CairoSVG>=1.0.20',
    ],
    'badges': [
        'Pillow>=3.2.0',
    ],
    'tests': tests_require,
}

extras_require['all'] = []
for reqs in extras_require.values():
    extras_require['all'].extend(reqs)

setup_requires = [
    'Babel>=1.3',
    'pytest-runner>=2.7.0',

]

install_requires = [
    'bleach>=3.1.0',
    'Flask>=1.1.4,<2.0',
    'arrow>=0.7.0',
    'Flask-BabelEx>=0.9.4',
    'invenio-i18n>=1.2.0',
]

packages = find_packages()


# Get the version string. Cannot be done with import!
g = {}
with open(os.path.join('invenio_formatter', 'version.py'), 'rt') as fp:
    exec(fp.read(), g)
    version = g['__version__']

setup(
    name='invenio-formatter',
    version=version,
    description=__doc__,
    long_description=readme + '\n\n' + history,
    keywords='invenio jinja2 flask',
    license='MIT',
    author='CERN',
    author_email='info@inveniosoftware.org',
    url='https://github.com/inveniosoftware/invenio-formatter',
    packages=packages,
    zip_safe=False,
    include_package_data=True,
    platforms='any',
    entry_points={
        'invenio_base.apps': [
            'invenio_formatter = invenio_formatter:InvenioFormatter',
        ],
        'invenio_i18n.translations': [
            'messages = invenio_formatter',
        ],
    },
    extras_require=extras_require,
    install_requires=install_requires,
    setup_requires=setup_requires,
    tests_require=tests_require,
    classifiers=[
        'Environment :: Web Environment',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: Implementation :: CPython',
        'Development Status :: 5 - Production/Stable',
    ],
)
