# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from digitaleye_msgs/GetScheduleRequest.msg. Do not edit."""
import codecs
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct


class GetScheduleRequest(genpy.Message):
  _md5sum = "d767b3ad20ae4020fcbe6daefd388da5"
  _type = "digitaleye_msgs/GetScheduleRequest"
  _has_header = False  # flag to mark the presence of a Header object
  _full_text = """# Returns a list of zones to which an IOT tag has been granted
# access during the specified time window

# unique identifier of the IOT tag for which to return permission grants
uint64 tag_id

# beginning of the time window for which to return permission grants
# (Epoch timestamp in seconds)
uint32 start

# end of the time window for which to return permission grants
# (Epoch timestamp in seconds)
uint32 end

"""
  __slots__ = ['tag_id','start','end']
  _slot_types = ['uint64','uint32','uint32']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       tag_id,start,end

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(GetScheduleRequest, self).__init__(*args, **kwds)
      # message fields cannot be None, assign default values for those that are
      if self.tag_id is None:
        self.tag_id = 0
      if self.start is None:
        self.start = 0
      if self.end is None:
        self.end = 0
    else:
      self.tag_id = 0
      self.start = 0
      self.end = 0

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self
      buff.write(_get_struct_Q2I().pack(_x.tag_id, _x.start, _x.end))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      end = 0
      _x = self
      start = end
      end += 16
      (_x.tag_id, _x.start, _x.end,) = _get_struct_Q2I().unpack(str[start:end])
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self
      buff.write(_get_struct_Q2I().pack(_x.tag_id, _x.start, _x.end))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      end = 0
      _x = self
      start = end
      end += 16
      (_x.tag_id, _x.start, _x.end,) = _get_struct_Q2I().unpack(str[start:end])
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_Q2I = None
def _get_struct_Q2I():
    global _struct_Q2I
    if _struct_Q2I is None:
        _struct_Q2I = struct.Struct("<Q2I")
    return _struct_Q2I
# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from digitaleye_msgs/GetScheduleResponse.msg. Do not edit."""
import codecs
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct

import digitaleye_msgs.msg

class GetScheduleResponse(genpy.Message):
  _md5sum = "7424d12ed06d7bc9e3ecccf1bc7ec2a5"
  _type = "digitaleye_msgs/GetScheduleResponse"
  _has_header = False  # flag to mark the presence of a Header object
  _full_text = """
# permission grants
digitaleye_msgs/AccessSchedule schedule


================================================================================
MSG: digitaleye_msgs/AccessSchedule
# List of authorisations for an object

# id of the object
uint64 object_id

# list of authorisation(s)
digitaleye_msgs/TimeSlot[] schedule

================================================================================
MSG: digitaleye_msgs/TimeSlot
# Zone authorisation

# TOLZ to which access has been granted
uint32 zone_id

# start time of authorisation (included) (Epoch timestamp in seconds)
uint32 start

# end time of authorisation (included) (Epoch timestamp in seconds)
uint32 end
"""
  __slots__ = ['schedule']
  _slot_types = ['digitaleye_msgs/AccessSchedule']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       schedule

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(GetScheduleResponse, self).__init__(*args, **kwds)
      # message fields cannot be None, assign default values for those that are
      if self.schedule is None:
        self.schedule = digitaleye_msgs.msg.AccessSchedule()
    else:
      self.schedule = digitaleye_msgs.msg.AccessSchedule()

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self.schedule.object_id
      buff.write(_get_struct_Q().pack(_x))
      length = len(self.schedule.schedule)
      buff.write(_struct_I.pack(length))
      for val1 in self.schedule.schedule:
        _x = val1
        buff.write(_get_struct_3I().pack(_x.zone_id, _x.start, _x.end))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.schedule is None:
        self.schedule = digitaleye_msgs.msg.AccessSchedule()
      end = 0
      start = end
      end += 8
      (self.schedule.object_id,) = _get_struct_Q().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.schedule.schedule = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.TimeSlot()
        _x = val1
        start = end
        end += 12
        (_x.zone_id, _x.start, _x.end,) = _get_struct_3I().unpack(str[start:end])
        self.schedule.schedule.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self.schedule.object_id
      buff.write(_get_struct_Q().pack(_x))
      length = len(self.schedule.schedule)
      buff.write(_struct_I.pack(length))
      for val1 in self.schedule.schedule:
        _x = val1
        buff.write(_get_struct_3I().pack(_x.zone_id, _x.start, _x.end))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.schedule is None:
        self.schedule = digitaleye_msgs.msg.AccessSchedule()
      end = 0
      start = end
      end += 8
      (self.schedule.object_id,) = _get_struct_Q().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.schedule.schedule = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.TimeSlot()
        _x = val1
        start = end
        end += 12
        (_x.zone_id, _x.start, _x.end,) = _get_struct_3I().unpack(str[start:end])
        self.schedule.schedule.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_3I = None
def _get_struct_3I():
    global _struct_3I
    if _struct_3I is None:
        _struct_3I = struct.Struct("<3I")
    return _struct_3I
_struct_Q = None
def _get_struct_Q():
    global _struct_Q
    if _struct_Q is None:
        _struct_Q = struct.Struct("<Q")
    return _struct_Q
class GetSchedule(object):
  _type          = 'digitaleye_msgs/GetSchedule'
  _md5sum = 'c9d090f422f7f08dd94c94be5bb64ff8'
  _request_class  = GetScheduleRequest
  _response_class = GetScheduleResponse
