# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from digitaleye_msgs/UavIntReportList.msg. Do not edit."""
import codecs
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct

import digitaleye_msgs.msg
import geometry_msgs.msg
import std_msgs.msg

class UavIntReportList(genpy.Message):
  _md5sum = "0059135ebfb1387c59850458a0b10bf6"
  _type = "digitaleye_msgs/UavIntReportList"
  _has_header = True  # flag to mark the presence of a Header object
  _full_text = """# List of internal generic UAV report(s)

# information on the time at which report was sent
# (epoch time)
std_msgs/Header header

# safety of the MAS:
#  - False if the MAS has a UAV non conforming/uninvolved,
#  - True otherwise
bool safe

# list of UAVs' description
digitaleye_msgs/UavIntReport[] uavs

================================================================================
MSG: std_msgs/Header
# Standard metadata for higher-level stamped data types.
# This is generally used to communicate timestamped data 
# in a particular coordinate frame.
# 
# sequence ID: consecutively increasing ID 
uint32 seq
#Two-integer timestamp that is expressed as:
# * stamp.sec: seconds (stamp_secs) since epoch (in Python the variable is called 'secs')
# * stamp.nsec: nanoseconds since stamp_secs (in Python the variable is called 'nsecs')
# time-handling sugar is provided by the client library
time stamp
#Frame this data is associated with
string frame_id

================================================================================
MSG: digitaleye_msgs/UavIntReport
# Generic internal UAV report

# information on the time at which the object
# was reported (epoch time) and its reference frame
std_msgs/Header header

# list of internal metric(s), using UAV_INT_ constants 
digitaleye_msgs/Metric[] uav_metric

# list of point(s) linked to msg_type
digitaleye_msgs/Flightpath flight_path

# Constants for Metric of uav_metric

# internal id, uint
string UAV_INT_ID = Internal ID

# internal status: STATUS_UNKNOWN,
# STATUS_BOOKED, STATUS_HANDOVER_AIR, 
# STATUS_HANDOVER_GROUND, STATUS_TAKE_OFF_PREP
# STATUS_TAKING_OFF, STATUS_LANDING
# STATUS_FLYING_IN, STATUS_FLYING_OUT
# STATUS_HELD_FLY_IN, STATUS_HELD_FLY_OUT
# STATUS_HELD_TAKE_OFF, STATUS_HELD_LANDING
# STATUS_LANDED, STATUS_EXITING
string UAV_INT_STATUS = Internal status

# conformance status:
# CONF_UNKNOWN, CONF_KO_UNKNOWN_UAV
# CONF_WAITING_ENTRY, CONF_KO_AIR_ENTRY
# CONF_OK_AIR_ENTRY, CONF_KO_GROUND_ENTRY
# CONF_OK_GROUND_ENTRY, CONF_KO_FLIGHT_PATH
# CONF_OK_FLIGHT_PATH, CONF_READY_LAND
# CONF_READY_FLY_OUT
string UAV_INT_CONF_STATUS = Conformance status

================================================================================
MSG: digitaleye_msgs/Metric
# Performance indicator for a subsystem,
# component or sensor

# name of the performance indicator
string name

# value of the performance indicator
string value

================================================================================
MSG: digitaleye_msgs/Flightpath
# Fligh path definition

# TOLZ id (0 = N/A)
uint32 tolz_id

# list of flight point(s)
digitaleye_msgs/Flightpoint[] flight_points

================================================================================
MSG: digitaleye_msgs/Flightpoint
# Flight point definition

# local coordinates of point (meters)
geometry_msgs/Point coord

# desired speed to reach this point (m/s)
float32 speed

================================================================================
MSG: geometry_msgs/Point
# This contains the position of a point in free space
float64 x
float64 y
float64 z
"""
  __slots__ = ['header','safe','uavs']
  _slot_types = ['std_msgs/Header','bool','digitaleye_msgs/UavIntReport[]']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       header,safe,uavs

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(UavIntReportList, self).__init__(*args, **kwds)
      # message fields cannot be None, assign default values for those that are
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.safe is None:
        self.safe = False
      if self.uavs is None:
        self.uavs = []
    else:
      self.header = std_msgs.msg.Header()
      self.safe = False
      self.uavs = []

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self
      buff.write(_get_struct_3I().pack(_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs))
      _x = self.header.frame_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self.safe
      buff.write(_get_struct_B().pack(_x))
      length = len(self.uavs)
      buff.write(_struct_I.pack(length))
      for val1 in self.uavs:
        _v1 = val1.header
        _x = _v1.seq
        buff.write(_get_struct_I().pack(_x))
        _v2 = _v1.stamp
        _x = _v2
        buff.write(_get_struct_2I().pack(_x.secs, _x.nsecs))
        _x = _v1.frame_id
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
        length = len(val1.uav_metric)
        buff.write(_struct_I.pack(length))
        for val2 in val1.uav_metric:
          _x = val2.name
          length = len(_x)
          if python3 or type(_x) == unicode:
            _x = _x.encode('utf-8')
            length = len(_x)
          buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
          _x = val2.value
          length = len(_x)
          if python3 or type(_x) == unicode:
            _x = _x.encode('utf-8')
            length = len(_x)
          buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
        _v3 = val1.flight_path
        _x = _v3.tolz_id
        buff.write(_get_struct_I().pack(_x))
        length = len(_v3.flight_points)
        buff.write(_struct_I.pack(length))
        for val3 in _v3.flight_points:
          _v4 = val3.coord
          _x = _v4
          buff.write(_get_struct_3d().pack(_x.x, _x.y, _x.z))
          _x = val3.speed
          buff.write(_get_struct_f().pack(_x))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.uavs is None:
        self.uavs = None
      end = 0
      _x = self
      start = end
      end += 12
      (_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs,) = _get_struct_3I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.header.frame_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.header.frame_id = str[start:end]
      start = end
      end += 1
      (self.safe,) = _get_struct_B().unpack(str[start:end])
      self.safe = bool(self.safe)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.uavs = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.UavIntReport()
        _v5 = val1.header
        start = end
        end += 4
        (_v5.seq,) = _get_struct_I().unpack(str[start:end])
        _v6 = _v5.stamp
        _x = _v6
        start = end
        end += 8
        (_x.secs, _x.nsecs,) = _get_struct_2I().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          _v5.frame_id = str[start:end].decode('utf-8', 'rosmsg')
        else:
          _v5.frame_id = str[start:end]
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        val1.uav_metric = []
        for i in range(0, length):
          val2 = digitaleye_msgs.msg.Metric()
          start = end
          end += 4
          (length,) = _struct_I.unpack(str[start:end])
          start = end
          end += length
          if python3:
            val2.name = str[start:end].decode('utf-8', 'rosmsg')
          else:
            val2.name = str[start:end]
          start = end
          end += 4
          (length,) = _struct_I.unpack(str[start:end])
          start = end
          end += length
          if python3:
            val2.value = str[start:end].decode('utf-8', 'rosmsg')
          else:
            val2.value = str[start:end]
          val1.uav_metric.append(val2)
        _v7 = val1.flight_path
        start = end
        end += 4
        (_v7.tolz_id,) = _get_struct_I().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        _v7.flight_points = []
        for i in range(0, length):
          val3 = digitaleye_msgs.msg.Flightpoint()
          _v8 = val3.coord
          _x = _v8
          start = end
          end += 24
          (_x.x, _x.y, _x.z,) = _get_struct_3d().unpack(str[start:end])
          start = end
          end += 4
          (val3.speed,) = _get_struct_f().unpack(str[start:end])
          _v7.flight_points.append(val3)
        self.uavs.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self
      buff.write(_get_struct_3I().pack(_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs))
      _x = self.header.frame_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self.safe
      buff.write(_get_struct_B().pack(_x))
      length = len(self.uavs)
      buff.write(_struct_I.pack(length))
      for val1 in self.uavs:
        _v9 = val1.header
        _x = _v9.seq
        buff.write(_get_struct_I().pack(_x))
        _v10 = _v9.stamp
        _x = _v10
        buff.write(_get_struct_2I().pack(_x.secs, _x.nsecs))
        _x = _v9.frame_id
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
        length = len(val1.uav_metric)
        buff.write(_struct_I.pack(length))
        for val2 in val1.uav_metric:
          _x = val2.name
          length = len(_x)
          if python3 or type(_x) == unicode:
            _x = _x.encode('utf-8')
            length = len(_x)
          buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
          _x = val2.value
          length = len(_x)
          if python3 or type(_x) == unicode:
            _x = _x.encode('utf-8')
            length = len(_x)
          buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
        _v11 = val1.flight_path
        _x = _v11.tolz_id
        buff.write(_get_struct_I().pack(_x))
        length = len(_v11.flight_points)
        buff.write(_struct_I.pack(length))
        for val3 in _v11.flight_points:
          _v12 = val3.coord
          _x = _v12
          buff.write(_get_struct_3d().pack(_x.x, _x.y, _x.z))
          _x = val3.speed
          buff.write(_get_struct_f().pack(_x))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.uavs is None:
        self.uavs = None
      end = 0
      _x = self
      start = end
      end += 12
      (_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs,) = _get_struct_3I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.header.frame_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.header.frame_id = str[start:end]
      start = end
      end += 1
      (self.safe,) = _get_struct_B().unpack(str[start:end])
      self.safe = bool(self.safe)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.uavs = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.UavIntReport()
        _v13 = val1.header
        start = end
        end += 4
        (_v13.seq,) = _get_struct_I().unpack(str[start:end])
        _v14 = _v13.stamp
        _x = _v14
        start = end
        end += 8
        (_x.secs, _x.nsecs,) = _get_struct_2I().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          _v13.frame_id = str[start:end].decode('utf-8', 'rosmsg')
        else:
          _v13.frame_id = str[start:end]
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        val1.uav_metric = []
        for i in range(0, length):
          val2 = digitaleye_msgs.msg.Metric()
          start = end
          end += 4
          (length,) = _struct_I.unpack(str[start:end])
          start = end
          end += length
          if python3:
            val2.name = str[start:end].decode('utf-8', 'rosmsg')
          else:
            val2.name = str[start:end]
          start = end
          end += 4
          (length,) = _struct_I.unpack(str[start:end])
          start = end
          end += length
          if python3:
            val2.value = str[start:end].decode('utf-8', 'rosmsg')
          else:
            val2.value = str[start:end]
          val1.uav_metric.append(val2)
        _v15 = val1.flight_path
        start = end
        end += 4
        (_v15.tolz_id,) = _get_struct_I().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        _v15.flight_points = []
        for i in range(0, length):
          val3 = digitaleye_msgs.msg.Flightpoint()
          _v16 = val3.coord
          _x = _v16
          start = end
          end += 24
          (_x.x, _x.y, _x.z,) = _get_struct_3d().unpack(str[start:end])
          start = end
          end += 4
          (val3.speed,) = _get_struct_f().unpack(str[start:end])
          _v15.flight_points.append(val3)
        self.uavs.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_2I = None
def _get_struct_2I():
    global _struct_2I
    if _struct_2I is None:
        _struct_2I = struct.Struct("<2I")
    return _struct_2I
_struct_3I = None
def _get_struct_3I():
    global _struct_3I
    if _struct_3I is None:
        _struct_3I = struct.Struct("<3I")
    return _struct_3I
_struct_3d = None
def _get_struct_3d():
    global _struct_3d
    if _struct_3d is None:
        _struct_3d = struct.Struct("<3d")
    return _struct_3d
_struct_B = None
def _get_struct_B():
    global _struct_B
    if _struct_B is None:
        _struct_B = struct.Struct("<B")
    return _struct_B
_struct_f = None
def _get_struct_f():
    global _struct_f
    if _struct_f is None:
        _struct_f = struct.Struct("<f")
    return _struct_f
