# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from digitaleye_msgs/UavIntReport.msg. Do not edit."""
import codecs
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct

import digitaleye_msgs.msg
import geometry_msgs.msg
import std_msgs.msg

class UavIntReport(genpy.Message):
  _md5sum = "ea537077c811950b2420709728140eae"
  _type = "digitaleye_msgs/UavIntReport"
  _has_header = True  # flag to mark the presence of a Header object
  _full_text = """# Generic internal UAV report

# information on the time at which the object
# was reported (epoch time) and its reference frame
std_msgs/Header header

# list of internal metric(s), using UAV_INT_ constants 
digitaleye_msgs/Metric[] uav_metric

# list of point(s) linked to msg_type
digitaleye_msgs/Flightpath flight_path

# Constants for Metric of uav_metric

# internal id, uint
string UAV_INT_ID = Internal ID

# internal status: STATUS_UNKNOWN,
# STATUS_BOOKED, STATUS_HANDOVER_AIR, 
# STATUS_HANDOVER_GROUND, STATUS_TAKE_OFF_PREP
# STATUS_TAKING_OFF, STATUS_LANDING
# STATUS_FLYING_IN, STATUS_FLYING_OUT
# STATUS_HELD_FLY_IN, STATUS_HELD_FLY_OUT
# STATUS_HELD_TAKE_OFF, STATUS_HELD_LANDING
# STATUS_LANDED, STATUS_EXITING
string UAV_INT_STATUS = Internal status

# conformance status:
# CONF_UNKNOWN, CONF_KO_UNKNOWN_UAV
# CONF_WAITING_ENTRY, CONF_KO_AIR_ENTRY
# CONF_OK_AIR_ENTRY, CONF_KO_GROUND_ENTRY
# CONF_OK_GROUND_ENTRY, CONF_KO_FLIGHT_PATH
# CONF_OK_FLIGHT_PATH, CONF_READY_LAND
# CONF_READY_FLY_OUT
string UAV_INT_CONF_STATUS = Conformance status

================================================================================
MSG: std_msgs/Header
# Standard metadata for higher-level stamped data types.
# This is generally used to communicate timestamped data 
# in a particular coordinate frame.
# 
# sequence ID: consecutively increasing ID 
uint32 seq
#Two-integer timestamp that is expressed as:
# * stamp.sec: seconds (stamp_secs) since epoch (in Python the variable is called 'secs')
# * stamp.nsec: nanoseconds since stamp_secs (in Python the variable is called 'nsecs')
# time-handling sugar is provided by the client library
time stamp
#Frame this data is associated with
string frame_id

================================================================================
MSG: digitaleye_msgs/Metric
# Performance indicator for a subsystem,
# component or sensor

# name of the performance indicator
string name

# value of the performance indicator
string value

================================================================================
MSG: digitaleye_msgs/Flightpath
# Fligh path definition

# TOLZ id (0 = N/A)
uint32 tolz_id

# list of flight point(s)
digitaleye_msgs/Flightpoint[] flight_points

================================================================================
MSG: digitaleye_msgs/Flightpoint
# Flight point definition

# local coordinates of point (meters)
geometry_msgs/Point coord

# desired speed to reach this point (m/s)
float32 speed

================================================================================
MSG: geometry_msgs/Point
# This contains the position of a point in free space
float64 x
float64 y
float64 z
"""
  # Pseudo-constants
  UAV_INT_ID = 'Internal ID'
  UAV_INT_STATUS = 'Internal status'
  UAV_INT_CONF_STATUS = 'Conformance status'

  __slots__ = ['header','uav_metric','flight_path']
  _slot_types = ['std_msgs/Header','digitaleye_msgs/Metric[]','digitaleye_msgs/Flightpath']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       header,uav_metric,flight_path

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(UavIntReport, self).__init__(*args, **kwds)
      # message fields cannot be None, assign default values for those that are
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.uav_metric is None:
        self.uav_metric = []
      if self.flight_path is None:
        self.flight_path = digitaleye_msgs.msg.Flightpath()
    else:
      self.header = std_msgs.msg.Header()
      self.uav_metric = []
      self.flight_path = digitaleye_msgs.msg.Flightpath()

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self
      buff.write(_get_struct_3I().pack(_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs))
      _x = self.header.frame_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      length = len(self.uav_metric)
      buff.write(_struct_I.pack(length))
      for val1 in self.uav_metric:
        _x = val1.name
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
        _x = val1.value
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self.flight_path.tolz_id
      buff.write(_get_struct_I().pack(_x))
      length = len(self.flight_path.flight_points)
      buff.write(_struct_I.pack(length))
      for val1 in self.flight_path.flight_points:
        _v1 = val1.coord
        _x = _v1
        buff.write(_get_struct_3d().pack(_x.x, _x.y, _x.z))
        _x = val1.speed
        buff.write(_get_struct_f().pack(_x))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.uav_metric is None:
        self.uav_metric = None
      if self.flight_path is None:
        self.flight_path = digitaleye_msgs.msg.Flightpath()
      end = 0
      _x = self
      start = end
      end += 12
      (_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs,) = _get_struct_3I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.header.frame_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.header.frame_id = str[start:end]
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.uav_metric = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.Metric()
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1.name = str[start:end].decode('utf-8', 'rosmsg')
        else:
          val1.name = str[start:end]
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1.value = str[start:end].decode('utf-8', 'rosmsg')
        else:
          val1.value = str[start:end]
        self.uav_metric.append(val1)
      start = end
      end += 4
      (self.flight_path.tolz_id,) = _get_struct_I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.flight_path.flight_points = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.Flightpoint()
        _v2 = val1.coord
        _x = _v2
        start = end
        end += 24
        (_x.x, _x.y, _x.z,) = _get_struct_3d().unpack(str[start:end])
        start = end
        end += 4
        (val1.speed,) = _get_struct_f().unpack(str[start:end])
        self.flight_path.flight_points.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self
      buff.write(_get_struct_3I().pack(_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs))
      _x = self.header.frame_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      length = len(self.uav_metric)
      buff.write(_struct_I.pack(length))
      for val1 in self.uav_metric:
        _x = val1.name
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
        _x = val1.value
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self.flight_path.tolz_id
      buff.write(_get_struct_I().pack(_x))
      length = len(self.flight_path.flight_points)
      buff.write(_struct_I.pack(length))
      for val1 in self.flight_path.flight_points:
        _v3 = val1.coord
        _x = _v3
        buff.write(_get_struct_3d().pack(_x.x, _x.y, _x.z))
        _x = val1.speed
        buff.write(_get_struct_f().pack(_x))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.uav_metric is None:
        self.uav_metric = None
      if self.flight_path is None:
        self.flight_path = digitaleye_msgs.msg.Flightpath()
      end = 0
      _x = self
      start = end
      end += 12
      (_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs,) = _get_struct_3I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.header.frame_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.header.frame_id = str[start:end]
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.uav_metric = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.Metric()
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1.name = str[start:end].decode('utf-8', 'rosmsg')
        else:
          val1.name = str[start:end]
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1.value = str[start:end].decode('utf-8', 'rosmsg')
        else:
          val1.value = str[start:end]
        self.uav_metric.append(val1)
      start = end
      end += 4
      (self.flight_path.tolz_id,) = _get_struct_I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.flight_path.flight_points = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.Flightpoint()
        _v4 = val1.coord
        _x = _v4
        start = end
        end += 24
        (_x.x, _x.y, _x.z,) = _get_struct_3d().unpack(str[start:end])
        start = end
        end += 4
        (val1.speed,) = _get_struct_f().unpack(str[start:end])
        self.flight_path.flight_points.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_3I = None
def _get_struct_3I():
    global _struct_3I
    if _struct_3I is None:
        _struct_3I = struct.Struct("<3I")
    return _struct_3I
_struct_3d = None
def _get_struct_3d():
    global _struct_3d
    if _struct_3d is None:
        _struct_3d = struct.Struct("<3d")
    return _struct_3d
_struct_f = None
def _get_struct_f():
    global _struct_f
    if _struct_f is None:
        _struct_f = struct.Struct("<f")
    return _struct_f
