# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from digitaleye_msgs/UavExtReport.msg. Do not edit."""
import codecs
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct

import digitaleye_msgs.msg
import std_msgs.msg

class UavExtReport(genpy.Message):
  _md5sum = "1fdcffea6b7c0e675e6ae9d5c7a5c276"
  _type = "digitaleye_msgs/UavExtReport"
  _has_header = True  # flag to mark the presence of a Header object
  _full_text = """# Generic external UAV report from

# information on the time at which the object
# was reported (epoch time) and its reference frame
std_msgs/Header header

# list of external metric(s), using UAV_EXT_ constants 
digitaleye_msgs/Metric[] uav_metric


# Constants for Metric of uav_metric

# internal ID (uint)
string UAV_EXT_INT_ID = Internal ID

# agent registration (string)
string UAV_EXT_AGENT_REG = Agent registration

# absolute position lat:long:alt
# (lat, long in degrees and alt in meters - WGS84 ellipsoid)
string UAV_EXT_ABS_POS = Absolute position

# object’s estimated position in the
# local reference frame x:y:z (meters)
string UAV_EXT_LOC_POS = Local position

# ground speed x:y:z (m/s)
string UAV_EXT_GND_SPEED = Ground speed

# GNSS fix-type code (FIX_ constants)
# FIX_UKNOWN, FIX_NO_GNSS, FIX_NO_FIX, FIX_2D, FIX_3D,
# FIX_DGPS, FIX_RTK_FLOAT, FIX_RTK_FIXED, FIX_STATIC, FIX_PPP
string UAV_EXT_FIX_TYPE = Fix-type

# HDOP horizontal dilution of position (float unitless)
string UAV_EXT_HDOP = HDOP

# VDOP horizontal dilution of position (float unitless)
string UAV_EXT_VDOP = VDOP

# number of visible satellites by the UAV
string UAV_EXT_NB_SATS_VIS = Nb sat vis

# percentage of battery remaining (uint)
string UAV_EXT_BATT_REMAIN = Battery remaining

# reported state: UAV_ST_UNKNOWN, UAV_ST_NOT_READY,
# UAV_ST_READY_TO (ready take off), UAV_ST_TAKING_OFF,
# UAV_ST_FLYING, UAV_ST_HELD, UAV_ST_LANDING
string UAV_EXT_STATE = External state

# SQUAWK code (uint)
string UAV_EXT_SQUAWK_CODE = SQUAWK code

# handover origin (string)
string UAV_EXT_HAND_ORIGIN = Handover Origin

# handover confirmation (string)
string UAV_EXT_HAND_DEST_CONFIRM = Handover destination confirmation

================================================================================
MSG: std_msgs/Header
# Standard metadata for higher-level stamped data types.
# This is generally used to communicate timestamped data 
# in a particular coordinate frame.
# 
# sequence ID: consecutively increasing ID 
uint32 seq
#Two-integer timestamp that is expressed as:
# * stamp.sec: seconds (stamp_secs) since epoch (in Python the variable is called 'secs')
# * stamp.nsec: nanoseconds since stamp_secs (in Python the variable is called 'nsecs')
# time-handling sugar is provided by the client library
time stamp
#Frame this data is associated with
string frame_id

================================================================================
MSG: digitaleye_msgs/Metric
# Performance indicator for a subsystem,
# component or sensor

# name of the performance indicator
string name

# value of the performance indicator
string value
"""
  # Pseudo-constants
  UAV_EXT_INT_ID = 'Internal ID'
  UAV_EXT_AGENT_REG = 'Agent registration'
  UAV_EXT_ABS_POS = 'Absolute position'
  UAV_EXT_LOC_POS = 'Local position'
  UAV_EXT_GND_SPEED = 'Ground speed'
  UAV_EXT_FIX_TYPE = 'Fix-type'
  UAV_EXT_HDOP = 'HDOP'
  UAV_EXT_VDOP = 'VDOP'
  UAV_EXT_NB_SATS_VIS = 'Nb sat vis'
  UAV_EXT_BATT_REMAIN = 'Battery remaining'
  UAV_EXT_STATE = 'External state'
  UAV_EXT_SQUAWK_CODE = 'SQUAWK code'
  UAV_EXT_HAND_ORIGIN = 'Handover Origin'
  UAV_EXT_HAND_DEST_CONFIRM = 'Handover destination confirmation'

  __slots__ = ['header','uav_metric']
  _slot_types = ['std_msgs/Header','digitaleye_msgs/Metric[]']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       header,uav_metric

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(UavExtReport, self).__init__(*args, **kwds)
      # message fields cannot be None, assign default values for those that are
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.uav_metric is None:
        self.uav_metric = []
    else:
      self.header = std_msgs.msg.Header()
      self.uav_metric = []

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self
      buff.write(_get_struct_3I().pack(_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs))
      _x = self.header.frame_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      length = len(self.uav_metric)
      buff.write(_struct_I.pack(length))
      for val1 in self.uav_metric:
        _x = val1.name
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
        _x = val1.value
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.uav_metric is None:
        self.uav_metric = None
      end = 0
      _x = self
      start = end
      end += 12
      (_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs,) = _get_struct_3I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.header.frame_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.header.frame_id = str[start:end]
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.uav_metric = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.Metric()
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1.name = str[start:end].decode('utf-8', 'rosmsg')
        else:
          val1.name = str[start:end]
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1.value = str[start:end].decode('utf-8', 'rosmsg')
        else:
          val1.value = str[start:end]
        self.uav_metric.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self
      buff.write(_get_struct_3I().pack(_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs))
      _x = self.header.frame_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      length = len(self.uav_metric)
      buff.write(_struct_I.pack(length))
      for val1 in self.uav_metric:
        _x = val1.name
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
        _x = val1.value
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.uav_metric is None:
        self.uav_metric = None
      end = 0
      _x = self
      start = end
      end += 12
      (_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs,) = _get_struct_3I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.header.frame_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.header.frame_id = str[start:end]
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.uav_metric = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.Metric()
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1.name = str[start:end].decode('utf-8', 'rosmsg')
        else:
          val1.name = str[start:end]
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1.value = str[start:end].decode('utf-8', 'rosmsg')
        else:
          val1.value = str[start:end]
        self.uav_metric.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_3I = None
def _get_struct_3I():
    global _struct_3I
    if _struct_3I is None:
        _struct_3I = struct.Struct("<3I")
    return _struct_3I
