# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from digitaleye_msgs/SensorPose.msg. Do not edit."""
import codecs
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct

import geometry_msgs.msg

class SensorPose(genpy.Message):
  _md5sum = "91c546ba42164d05edd8e32ab5e5bc7a"
  _type = "digitaleye_msgs/SensorPose"
  _has_header = False  # flag to mark the presence of a Header object
  _full_text = """# Pose of a PORTAL sensor

# Position of the pole
uint32 perception_id

# unique identifier of the sensor
# e.g. hardware serial number
string sensor_id

# type of sensor being described
# e.g. camera, LIDAR, etc.
uint32 type

# Position of the sensor w.r.t the pole it is on
geometry_msgs/Pose pose

# Orientation of the sensor w.r.t the pole it is on
float32 orientation

================================================================================
MSG: geometry_msgs/Pose
# A representation of pose in free space, composed of position and orientation. 
Point position
Quaternion orientation

================================================================================
MSG: geometry_msgs/Point
# This contains the position of a point in free space
float64 x
float64 y
float64 z

================================================================================
MSG: geometry_msgs/Quaternion
# This represents an orientation in free space in quaternion form.

float64 x
float64 y
float64 z
float64 w
"""
  __slots__ = ['perception_id','sensor_id','type','pose','orientation']
  _slot_types = ['uint32','string','uint32','geometry_msgs/Pose','float32']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       perception_id,sensor_id,type,pose,orientation

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(SensorPose, self).__init__(*args, **kwds)
      # message fields cannot be None, assign default values for those that are
      if self.perception_id is None:
        self.perception_id = 0
      if self.sensor_id is None:
        self.sensor_id = ''
      if self.type is None:
        self.type = 0
      if self.pose is None:
        self.pose = geometry_msgs.msg.Pose()
      if self.orientation is None:
        self.orientation = 0.
    else:
      self.perception_id = 0
      self.sensor_id = ''
      self.type = 0
      self.pose = geometry_msgs.msg.Pose()
      self.orientation = 0.

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self.perception_id
      buff.write(_get_struct_I().pack(_x))
      _x = self.sensor_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self
      buff.write(_get_struct_I7df().pack(_x.type, _x.pose.position.x, _x.pose.position.y, _x.pose.position.z, _x.pose.orientation.x, _x.pose.orientation.y, _x.pose.orientation.z, _x.pose.orientation.w, _x.orientation))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.pose is None:
        self.pose = geometry_msgs.msg.Pose()
      end = 0
      start = end
      end += 4
      (self.perception_id,) = _get_struct_I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.sensor_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.sensor_id = str[start:end]
      _x = self
      start = end
      end += 64
      (_x.type, _x.pose.position.x, _x.pose.position.y, _x.pose.position.z, _x.pose.orientation.x, _x.pose.orientation.y, _x.pose.orientation.z, _x.pose.orientation.w, _x.orientation,) = _get_struct_I7df().unpack(str[start:end])
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self.perception_id
      buff.write(_get_struct_I().pack(_x))
      _x = self.sensor_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self
      buff.write(_get_struct_I7df().pack(_x.type, _x.pose.position.x, _x.pose.position.y, _x.pose.position.z, _x.pose.orientation.x, _x.pose.orientation.y, _x.pose.orientation.z, _x.pose.orientation.w, _x.orientation))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.pose is None:
        self.pose = geometry_msgs.msg.Pose()
      end = 0
      start = end
      end += 4
      (self.perception_id,) = _get_struct_I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.sensor_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.sensor_id = str[start:end]
      _x = self
      start = end
      end += 64
      (_x.type, _x.pose.position.x, _x.pose.position.y, _x.pose.position.z, _x.pose.orientation.x, _x.pose.orientation.y, _x.pose.orientation.z, _x.pose.orientation.w, _x.orientation,) = _get_struct_I7df().unpack(str[start:end])
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_I7df = None
def _get_struct_I7df():
    global _struct_I7df
    if _struct_I7df is None:
        _struct_I7df = struct.Struct("<I7df")
    return _struct_I7df
