# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from digitaleye_msgs/ObjectList.msg. Do not edit."""
import codecs
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct

import digitaleye_msgs.msg
import genpy
import geometry_msgs.msg
import std_msgs.msg
import visualization_msgs.msg

class ObjectList(genpy.Message):
  _md5sum = "f1860269ed96ba6ad58e8b3de0619ddc"
  _type = "digitaleye_msgs/ObjectList"
  _has_header = True  # flag to mark the presence of a Header object
  _full_text = """# List of objects reported within the Monitered Space

# information on the time at which objects
# were reported (epoch time) and their reference frame
std_msgs/Header header

# list of reported object(s)
digitaleye_msgs/Object[] objects

================================================================================
MSG: std_msgs/Header
# Standard metadata for higher-level stamped data types.
# This is generally used to communicate timestamped data 
# in a particular coordinate frame.
# 
# sequence ID: consecutively increasing ID 
uint32 seq
#Two-integer timestamp that is expressed as:
# * stamp.sec: seconds (stamp_secs) since epoch (in Python the variable is called 'secs')
# * stamp.nsec: nanoseconds since stamp_secs (in Python the variable is called 'nsecs')
# time-handling sugar is provided by the client library
time stamp
#Frame this data is associated with
string frame_id

================================================================================
MSG: digitaleye_msgs/Object
# Description of an object in the Monitored Space

# information on the time at which the object
# was reported (epoch time) and its reference frame
std_msgs/Header header

# id assigned to the reported object
uint64 object_id

# list of ID(s) of reported object(s) which
# constitute it (if fused)
uint64[] fused_ids

# coordinates of the object’s estimated position
# in the local reference frame (meters)
geometry_msgs/Point position

# 3D covariance of the object position, represents the quality
# of the position estimate, higher covariances mean
# a worse estimate. XX, XY, XZ, YX, YY, YZ, ZX, ZY, ZZ
float32[9] pos_covariance

# estimated accuracy radius of object's position (meters)
float32 accuracy

# estimated velocity of the object (m/s)
geometry_msgs/Vector3 velocity

# estimated acceleration of the object (m/s2)
geometry_msgs/Accel acceleration

# estimated size of the object (meters)
float32 size

# object’s category
# e.g. Personnel, Package, Passenger, UAV, etc.
string classification

# list of zone(s) in which the object is
ZoneObjectStatus[] zones

# Object visualisation marker
visualization_msgs/Marker bounding_cylinder

================================================================================
MSG: geometry_msgs/Point
# This contains the position of a point in free space
float64 x
float64 y
float64 z

================================================================================
MSG: geometry_msgs/Vector3
# This represents a vector in free space. 
# It is only meant to represent a direction. Therefore, it does not
# make sense to apply a translation to it (e.g., when applying a 
# generic rigid transformation to a Vector3, tf2 will only apply the
# rotation). If you want your data to be translatable too, use the
# geometry_msgs/Point message instead.

float64 x
float64 y
float64 z
================================================================================
MSG: geometry_msgs/Accel
# This expresses acceleration in free space broken into its linear and angular parts.
Vector3  linear
Vector3  angular

================================================================================
MSG: digitaleye_msgs/ZoneObjectStatus
# Status of the object within the specified zone

# identifier of the zone the object is in
uint32 zone_id

# whether or not the object is allowed in the zone
bool allowed

# time the object was first detected in this zone
# (ros timestamp in epoch time)
time first_detected

# time the object was last detected in this zone
# (ros timestamp in epoch time)
time last_detected

================================================================================
MSG: visualization_msgs/Marker
# See http://www.ros.org/wiki/rviz/DisplayTypes/Marker and http://www.ros.org/wiki/rviz/Tutorials/Markers%3A%20Basic%20Shapes for more information on using this message with rviz

uint8 ARROW=0
uint8 CUBE=1
uint8 SPHERE=2
uint8 CYLINDER=3
uint8 LINE_STRIP=4
uint8 LINE_LIST=5
uint8 CUBE_LIST=6
uint8 SPHERE_LIST=7
uint8 POINTS=8
uint8 TEXT_VIEW_FACING=9
uint8 MESH_RESOURCE=10
uint8 TRIANGLE_LIST=11

uint8 ADD=0
uint8 MODIFY=0
uint8 DELETE=2
uint8 DELETEALL=3

Header header                        # header for time/frame information
string ns                            # Namespace to place this object in... used in conjunction with id to create a unique name for the object
int32 id 		                         # object ID useful in conjunction with the namespace for manipulating and deleting the object later
int32 type 		                       # Type of object
int32 action 	                       # 0 add/modify an object, 1 (deprecated), 2 deletes an object, 3 deletes all objects
geometry_msgs/Pose pose                 # Pose of the object
geometry_msgs/Vector3 scale             # Scale of the object 1,1,1 means default (usually 1 meter square)
std_msgs/ColorRGBA color             # Color [0.0-1.0]
duration lifetime                    # How long the object should last before being automatically deleted.  0 means forever
bool frame_locked                    # If this marker should be frame-locked, i.e. retransformed into its frame every timestep

#Only used if the type specified has some use for them (eg. POINTS, LINE_STRIP, ...)
geometry_msgs/Point[] points
#Only used if the type specified has some use for them (eg. POINTS, LINE_STRIP, ...)
#number of colors must either be 0 or equal to the number of points
#NOTE: alpha is not yet used
std_msgs/ColorRGBA[] colors

# NOTE: only used for text markers
string text

# NOTE: only used for MESH_RESOURCE markers
string mesh_resource
bool mesh_use_embedded_materials

================================================================================
MSG: geometry_msgs/Pose
# A representation of pose in free space, composed of position and orientation. 
Point position
Quaternion orientation

================================================================================
MSG: geometry_msgs/Quaternion
# This represents an orientation in free space in quaternion form.

float64 x
float64 y
float64 z
float64 w

================================================================================
MSG: std_msgs/ColorRGBA
float32 r
float32 g
float32 b
float32 a
"""
  __slots__ = ['header','objects']
  _slot_types = ['std_msgs/Header','digitaleye_msgs/Object[]']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       header,objects

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(ObjectList, self).__init__(*args, **kwds)
      # message fields cannot be None, assign default values for those that are
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.objects is None:
        self.objects = []
    else:
      self.header = std_msgs.msg.Header()
      self.objects = []

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self
      buff.write(_get_struct_3I().pack(_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs))
      _x = self.header.frame_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      length = len(self.objects)
      buff.write(_struct_I.pack(length))
      for val1 in self.objects:
        _v1 = val1.header
        _x = _v1.seq
        buff.write(_get_struct_I().pack(_x))
        _v2 = _v1.stamp
        _x = _v2
        buff.write(_get_struct_2I().pack(_x.secs, _x.nsecs))
        _x = _v1.frame_id
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
        _x = val1.object_id
        buff.write(_get_struct_Q().pack(_x))
        length = len(val1.fused_ids)
        buff.write(_struct_I.pack(length))
        pattern = '<%sQ'%length
        buff.write(struct.Struct(pattern).pack(*val1.fused_ids))
        _v3 = val1.position
        _x = _v3
        buff.write(_get_struct_3d().pack(_x.x, _x.y, _x.z))
        buff.write(_get_struct_9f().pack(*val1.pos_covariance))
        _x = val1.accuracy
        buff.write(_get_struct_f().pack(_x))
        _v4 = val1.velocity
        _x = _v4
        buff.write(_get_struct_3d().pack(_x.x, _x.y, _x.z))
        _v5 = val1.acceleration
        _v6 = _v5.linear
        _x = _v6
        buff.write(_get_struct_3d().pack(_x.x, _x.y, _x.z))
        _v7 = _v5.angular
        _x = _v7
        buff.write(_get_struct_3d().pack(_x.x, _x.y, _x.z))
        _x = val1.size
        buff.write(_get_struct_f().pack(_x))
        _x = val1.classification
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
        length = len(val1.zones)
        buff.write(_struct_I.pack(length))
        for val2 in val1.zones:
          _x = val2
          buff.write(_get_struct_IB().pack(_x.zone_id, _x.allowed))
          _v8 = val2.first_detected
          _x = _v8
          buff.write(_get_struct_2I().pack(_x.secs, _x.nsecs))
          _v9 = val2.last_detected
          _x = _v9
          buff.write(_get_struct_2I().pack(_x.secs, _x.nsecs))
        _v10 = val1.bounding_cylinder
        _v11 = _v10.header
        _x = _v11.seq
        buff.write(_get_struct_I().pack(_x))
        _v12 = _v11.stamp
        _x = _v12
        buff.write(_get_struct_2I().pack(_x.secs, _x.nsecs))
        _x = _v11.frame_id
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
        _x = _v10.ns
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
        _x = _v10
        buff.write(_get_struct_3i().pack(_x.id, _x.type, _x.action))
        _v13 = _v10.pose
        _v14 = _v13.position
        _x = _v14
        buff.write(_get_struct_3d().pack(_x.x, _x.y, _x.z))
        _v15 = _v13.orientation
        _x = _v15
        buff.write(_get_struct_4d().pack(_x.x, _x.y, _x.z, _x.w))
        _v16 = _v10.scale
        _x = _v16
        buff.write(_get_struct_3d().pack(_x.x, _x.y, _x.z))
        _v17 = _v10.color
        _x = _v17
        buff.write(_get_struct_4f().pack(_x.r, _x.g, _x.b, _x.a))
        _v18 = _v10.lifetime
        _x = _v18
        buff.write(_get_struct_2i().pack(_x.secs, _x.nsecs))
        _x = _v10.frame_locked
        buff.write(_get_struct_B().pack(_x))
        length = len(_v10.points)
        buff.write(_struct_I.pack(length))
        for val3 in _v10.points:
          _x = val3
          buff.write(_get_struct_3d().pack(_x.x, _x.y, _x.z))
        length = len(_v10.colors)
        buff.write(_struct_I.pack(length))
        for val3 in _v10.colors:
          _x = val3
          buff.write(_get_struct_4f().pack(_x.r, _x.g, _x.b, _x.a))
        _x = _v10.text
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
        _x = _v10.mesh_resource
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
        _x = _v10.mesh_use_embedded_materials
        buff.write(_get_struct_B().pack(_x))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.objects is None:
        self.objects = None
      end = 0
      _x = self
      start = end
      end += 12
      (_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs,) = _get_struct_3I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.header.frame_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.header.frame_id = str[start:end]
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.objects = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.Object()
        _v19 = val1.header
        start = end
        end += 4
        (_v19.seq,) = _get_struct_I().unpack(str[start:end])
        _v20 = _v19.stamp
        _x = _v20
        start = end
        end += 8
        (_x.secs, _x.nsecs,) = _get_struct_2I().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          _v19.frame_id = str[start:end].decode('utf-8', 'rosmsg')
        else:
          _v19.frame_id = str[start:end]
        start = end
        end += 8
        (val1.object_id,) = _get_struct_Q().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sQ'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.fused_ids = s.unpack(str[start:end])
        _v21 = val1.position
        _x = _v21
        start = end
        end += 24
        (_x.x, _x.y, _x.z,) = _get_struct_3d().unpack(str[start:end])
        start = end
        end += 36
        val1.pos_covariance = _get_struct_9f().unpack(str[start:end])
        start = end
        end += 4
        (val1.accuracy,) = _get_struct_f().unpack(str[start:end])
        _v22 = val1.velocity
        _x = _v22
        start = end
        end += 24
        (_x.x, _x.y, _x.z,) = _get_struct_3d().unpack(str[start:end])
        _v23 = val1.acceleration
        _v24 = _v23.linear
        _x = _v24
        start = end
        end += 24
        (_x.x, _x.y, _x.z,) = _get_struct_3d().unpack(str[start:end])
        _v25 = _v23.angular
        _x = _v25
        start = end
        end += 24
        (_x.x, _x.y, _x.z,) = _get_struct_3d().unpack(str[start:end])
        start = end
        end += 4
        (val1.size,) = _get_struct_f().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1.classification = str[start:end].decode('utf-8', 'rosmsg')
        else:
          val1.classification = str[start:end]
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        val1.zones = []
        for i in range(0, length):
          val2 = digitaleye_msgs.msg.ZoneObjectStatus()
          _x = val2
          start = end
          end += 5
          (_x.zone_id, _x.allowed,) = _get_struct_IB().unpack(str[start:end])
          val2.allowed = bool(val2.allowed)
          _v26 = val2.first_detected
          _x = _v26
          start = end
          end += 8
          (_x.secs, _x.nsecs,) = _get_struct_2I().unpack(str[start:end])
          _v27 = val2.last_detected
          _x = _v27
          start = end
          end += 8
          (_x.secs, _x.nsecs,) = _get_struct_2I().unpack(str[start:end])
          val1.zones.append(val2)
        _v28 = val1.bounding_cylinder
        _v29 = _v28.header
        start = end
        end += 4
        (_v29.seq,) = _get_struct_I().unpack(str[start:end])
        _v30 = _v29.stamp
        _x = _v30
        start = end
        end += 8
        (_x.secs, _x.nsecs,) = _get_struct_2I().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          _v29.frame_id = str[start:end].decode('utf-8', 'rosmsg')
        else:
          _v29.frame_id = str[start:end]
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          _v28.ns = str[start:end].decode('utf-8', 'rosmsg')
        else:
          _v28.ns = str[start:end]
        _x = _v28
        start = end
        end += 12
        (_x.id, _x.type, _x.action,) = _get_struct_3i().unpack(str[start:end])
        _v31 = _v28.pose
        _v32 = _v31.position
        _x = _v32
        start = end
        end += 24
        (_x.x, _x.y, _x.z,) = _get_struct_3d().unpack(str[start:end])
        _v33 = _v31.orientation
        _x = _v33
        start = end
        end += 32
        (_x.x, _x.y, _x.z, _x.w,) = _get_struct_4d().unpack(str[start:end])
        _v34 = _v28.scale
        _x = _v34
        start = end
        end += 24
        (_x.x, _x.y, _x.z,) = _get_struct_3d().unpack(str[start:end])
        _v35 = _v28.color
        _x = _v35
        start = end
        end += 16
        (_x.r, _x.g, _x.b, _x.a,) = _get_struct_4f().unpack(str[start:end])
        _v36 = _v28.lifetime
        _x = _v36
        start = end
        end += 8
        (_x.secs, _x.nsecs,) = _get_struct_2i().unpack(str[start:end])
        start = end
        end += 1
        (_v28.frame_locked,) = _get_struct_B().unpack(str[start:end])
        _v28.frame_locked = bool(_v28.frame_locked)
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        _v28.points = []
        for i in range(0, length):
          val3 = geometry_msgs.msg.Point()
          _x = val3
          start = end
          end += 24
          (_x.x, _x.y, _x.z,) = _get_struct_3d().unpack(str[start:end])
          _v28.points.append(val3)
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        _v28.colors = []
        for i in range(0, length):
          val3 = std_msgs.msg.ColorRGBA()
          _x = val3
          start = end
          end += 16
          (_x.r, _x.g, _x.b, _x.a,) = _get_struct_4f().unpack(str[start:end])
          _v28.colors.append(val3)
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          _v28.text = str[start:end].decode('utf-8', 'rosmsg')
        else:
          _v28.text = str[start:end]
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          _v28.mesh_resource = str[start:end].decode('utf-8', 'rosmsg')
        else:
          _v28.mesh_resource = str[start:end]
        start = end
        end += 1
        (_v28.mesh_use_embedded_materials,) = _get_struct_B().unpack(str[start:end])
        _v28.mesh_use_embedded_materials = bool(_v28.mesh_use_embedded_materials)
        self.objects.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self
      buff.write(_get_struct_3I().pack(_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs))
      _x = self.header.frame_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      length = len(self.objects)
      buff.write(_struct_I.pack(length))
      for val1 in self.objects:
        _v37 = val1.header
        _x = _v37.seq
        buff.write(_get_struct_I().pack(_x))
        _v38 = _v37.stamp
        _x = _v38
        buff.write(_get_struct_2I().pack(_x.secs, _x.nsecs))
        _x = _v37.frame_id
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
        _x = val1.object_id
        buff.write(_get_struct_Q().pack(_x))
        length = len(val1.fused_ids)
        buff.write(_struct_I.pack(length))
        pattern = '<%sQ'%length
        buff.write(val1.fused_ids.tostring())
        _v39 = val1.position
        _x = _v39
        buff.write(_get_struct_3d().pack(_x.x, _x.y, _x.z))
        buff.write(val1.pos_covariance.tostring())
        _x = val1.accuracy
        buff.write(_get_struct_f().pack(_x))
        _v40 = val1.velocity
        _x = _v40
        buff.write(_get_struct_3d().pack(_x.x, _x.y, _x.z))
        _v41 = val1.acceleration
        _v42 = _v41.linear
        _x = _v42
        buff.write(_get_struct_3d().pack(_x.x, _x.y, _x.z))
        _v43 = _v41.angular
        _x = _v43
        buff.write(_get_struct_3d().pack(_x.x, _x.y, _x.z))
        _x = val1.size
        buff.write(_get_struct_f().pack(_x))
        _x = val1.classification
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
        length = len(val1.zones)
        buff.write(_struct_I.pack(length))
        for val2 in val1.zones:
          _x = val2
          buff.write(_get_struct_IB().pack(_x.zone_id, _x.allowed))
          _v44 = val2.first_detected
          _x = _v44
          buff.write(_get_struct_2I().pack(_x.secs, _x.nsecs))
          _v45 = val2.last_detected
          _x = _v45
          buff.write(_get_struct_2I().pack(_x.secs, _x.nsecs))
        _v46 = val1.bounding_cylinder
        _v47 = _v46.header
        _x = _v47.seq
        buff.write(_get_struct_I().pack(_x))
        _v48 = _v47.stamp
        _x = _v48
        buff.write(_get_struct_2I().pack(_x.secs, _x.nsecs))
        _x = _v47.frame_id
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
        _x = _v46.ns
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
        _x = _v46
        buff.write(_get_struct_3i().pack(_x.id, _x.type, _x.action))
        _v49 = _v46.pose
        _v50 = _v49.position
        _x = _v50
        buff.write(_get_struct_3d().pack(_x.x, _x.y, _x.z))
        _v51 = _v49.orientation
        _x = _v51
        buff.write(_get_struct_4d().pack(_x.x, _x.y, _x.z, _x.w))
        _v52 = _v46.scale
        _x = _v52
        buff.write(_get_struct_3d().pack(_x.x, _x.y, _x.z))
        _v53 = _v46.color
        _x = _v53
        buff.write(_get_struct_4f().pack(_x.r, _x.g, _x.b, _x.a))
        _v54 = _v46.lifetime
        _x = _v54
        buff.write(_get_struct_2i().pack(_x.secs, _x.nsecs))
        _x = _v46.frame_locked
        buff.write(_get_struct_B().pack(_x))
        length = len(_v46.points)
        buff.write(_struct_I.pack(length))
        for val3 in _v46.points:
          _x = val3
          buff.write(_get_struct_3d().pack(_x.x, _x.y, _x.z))
        length = len(_v46.colors)
        buff.write(_struct_I.pack(length))
        for val3 in _v46.colors:
          _x = val3
          buff.write(_get_struct_4f().pack(_x.r, _x.g, _x.b, _x.a))
        _x = _v46.text
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
        _x = _v46.mesh_resource
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
        _x = _v46.mesh_use_embedded_materials
        buff.write(_get_struct_B().pack(_x))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.objects is None:
        self.objects = None
      end = 0
      _x = self
      start = end
      end += 12
      (_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs,) = _get_struct_3I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.header.frame_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.header.frame_id = str[start:end]
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.objects = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.Object()
        _v55 = val1.header
        start = end
        end += 4
        (_v55.seq,) = _get_struct_I().unpack(str[start:end])
        _v56 = _v55.stamp
        _x = _v56
        start = end
        end += 8
        (_x.secs, _x.nsecs,) = _get_struct_2I().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          _v55.frame_id = str[start:end].decode('utf-8', 'rosmsg')
        else:
          _v55.frame_id = str[start:end]
        start = end
        end += 8
        (val1.object_id,) = _get_struct_Q().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sQ'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.fused_ids = numpy.frombuffer(str[start:end], dtype=numpy.uint64, count=length)
        _v57 = val1.position
        _x = _v57
        start = end
        end += 24
        (_x.x, _x.y, _x.z,) = _get_struct_3d().unpack(str[start:end])
        start = end
        end += 36
        val1.pos_covariance = numpy.frombuffer(str[start:end], dtype=numpy.float32, count=9)
        start = end
        end += 4
        (val1.accuracy,) = _get_struct_f().unpack(str[start:end])
        _v58 = val1.velocity
        _x = _v58
        start = end
        end += 24
        (_x.x, _x.y, _x.z,) = _get_struct_3d().unpack(str[start:end])
        _v59 = val1.acceleration
        _v60 = _v59.linear
        _x = _v60
        start = end
        end += 24
        (_x.x, _x.y, _x.z,) = _get_struct_3d().unpack(str[start:end])
        _v61 = _v59.angular
        _x = _v61
        start = end
        end += 24
        (_x.x, _x.y, _x.z,) = _get_struct_3d().unpack(str[start:end])
        start = end
        end += 4
        (val1.size,) = _get_struct_f().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1.classification = str[start:end].decode('utf-8', 'rosmsg')
        else:
          val1.classification = str[start:end]
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        val1.zones = []
        for i in range(0, length):
          val2 = digitaleye_msgs.msg.ZoneObjectStatus()
          _x = val2
          start = end
          end += 5
          (_x.zone_id, _x.allowed,) = _get_struct_IB().unpack(str[start:end])
          val2.allowed = bool(val2.allowed)
          _v62 = val2.first_detected
          _x = _v62
          start = end
          end += 8
          (_x.secs, _x.nsecs,) = _get_struct_2I().unpack(str[start:end])
          _v63 = val2.last_detected
          _x = _v63
          start = end
          end += 8
          (_x.secs, _x.nsecs,) = _get_struct_2I().unpack(str[start:end])
          val1.zones.append(val2)
        _v64 = val1.bounding_cylinder
        _v65 = _v64.header
        start = end
        end += 4
        (_v65.seq,) = _get_struct_I().unpack(str[start:end])
        _v66 = _v65.stamp
        _x = _v66
        start = end
        end += 8
        (_x.secs, _x.nsecs,) = _get_struct_2I().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          _v65.frame_id = str[start:end].decode('utf-8', 'rosmsg')
        else:
          _v65.frame_id = str[start:end]
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          _v64.ns = str[start:end].decode('utf-8', 'rosmsg')
        else:
          _v64.ns = str[start:end]
        _x = _v64
        start = end
        end += 12
        (_x.id, _x.type, _x.action,) = _get_struct_3i().unpack(str[start:end])
        _v67 = _v64.pose
        _v68 = _v67.position
        _x = _v68
        start = end
        end += 24
        (_x.x, _x.y, _x.z,) = _get_struct_3d().unpack(str[start:end])
        _v69 = _v67.orientation
        _x = _v69
        start = end
        end += 32
        (_x.x, _x.y, _x.z, _x.w,) = _get_struct_4d().unpack(str[start:end])
        _v70 = _v64.scale
        _x = _v70
        start = end
        end += 24
        (_x.x, _x.y, _x.z,) = _get_struct_3d().unpack(str[start:end])
        _v71 = _v64.color
        _x = _v71
        start = end
        end += 16
        (_x.r, _x.g, _x.b, _x.a,) = _get_struct_4f().unpack(str[start:end])
        _v72 = _v64.lifetime
        _x = _v72
        start = end
        end += 8
        (_x.secs, _x.nsecs,) = _get_struct_2i().unpack(str[start:end])
        start = end
        end += 1
        (_v64.frame_locked,) = _get_struct_B().unpack(str[start:end])
        _v64.frame_locked = bool(_v64.frame_locked)
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        _v64.points = []
        for i in range(0, length):
          val3 = geometry_msgs.msg.Point()
          _x = val3
          start = end
          end += 24
          (_x.x, _x.y, _x.z,) = _get_struct_3d().unpack(str[start:end])
          _v64.points.append(val3)
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        _v64.colors = []
        for i in range(0, length):
          val3 = std_msgs.msg.ColorRGBA()
          _x = val3
          start = end
          end += 16
          (_x.r, _x.g, _x.b, _x.a,) = _get_struct_4f().unpack(str[start:end])
          _v64.colors.append(val3)
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          _v64.text = str[start:end].decode('utf-8', 'rosmsg')
        else:
          _v64.text = str[start:end]
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          _v64.mesh_resource = str[start:end].decode('utf-8', 'rosmsg')
        else:
          _v64.mesh_resource = str[start:end]
        start = end
        end += 1
        (_v64.mesh_use_embedded_materials,) = _get_struct_B().unpack(str[start:end])
        _v64.mesh_use_embedded_materials = bool(_v64.mesh_use_embedded_materials)
        self.objects.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_2I = None
def _get_struct_2I():
    global _struct_2I
    if _struct_2I is None:
        _struct_2I = struct.Struct("<2I")
    return _struct_2I
_struct_2i = None
def _get_struct_2i():
    global _struct_2i
    if _struct_2i is None:
        _struct_2i = struct.Struct("<2i")
    return _struct_2i
_struct_3I = None
def _get_struct_3I():
    global _struct_3I
    if _struct_3I is None:
        _struct_3I = struct.Struct("<3I")
    return _struct_3I
_struct_3d = None
def _get_struct_3d():
    global _struct_3d
    if _struct_3d is None:
        _struct_3d = struct.Struct("<3d")
    return _struct_3d
_struct_3i = None
def _get_struct_3i():
    global _struct_3i
    if _struct_3i is None:
        _struct_3i = struct.Struct("<3i")
    return _struct_3i
_struct_4d = None
def _get_struct_4d():
    global _struct_4d
    if _struct_4d is None:
        _struct_4d = struct.Struct("<4d")
    return _struct_4d
_struct_4f = None
def _get_struct_4f():
    global _struct_4f
    if _struct_4f is None:
        _struct_4f = struct.Struct("<4f")
    return _struct_4f
_struct_9f = None
def _get_struct_9f():
    global _struct_9f
    if _struct_9f is None:
        _struct_9f = struct.Struct("<9f")
    return _struct_9f
_struct_B = None
def _get_struct_B():
    global _struct_B
    if _struct_B is None:
        _struct_B = struct.Struct("<B")
    return _struct_B
_struct_IB = None
def _get_struct_IB():
    global _struct_IB
    if _struct_IB is None:
        _struct_IB = struct.Struct("<IB")
    return _struct_IB
_struct_Q = None
def _get_struct_Q():
    global _struct_Q
    if _struct_Q is None:
        _struct_Q = struct.Struct("<Q")
    return _struct_Q
_struct_f = None
def _get_struct_f():
    global _struct_f
    if _struct_f is None:
        _struct_f = struct.Struct("<f")
    return _struct_f
