# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from digitaleye_msgs/Object.msg. Do not edit."""
import codecs
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct

import digitaleye_msgs.msg
import genpy
import geometry_msgs.msg
import std_msgs.msg
import visualization_msgs.msg

class Object(genpy.Message):
  _md5sum = "50a51e88bc1d873cad22eaf4e5964098"
  _type = "digitaleye_msgs/Object"
  _has_header = True  # flag to mark the presence of a Header object
  _full_text = """# Description of an object in the Monitored Space

# information on the time at which the object
# was reported (epoch time) and its reference frame
std_msgs/Header header

# id assigned to the reported object
uint64 object_id

# list of ID(s) of reported object(s) which
# constitute it (if fused)
uint64[] fused_ids

# coordinates of the object’s estimated position
# in the local reference frame (meters)
geometry_msgs/Point position

# 3D covariance of the object position, represents the quality
# of the position estimate, higher covariances mean
# a worse estimate. XX, XY, XZ, YX, YY, YZ, ZX, ZY, ZZ
float32[9] pos_covariance

# estimated accuracy radius of object's position (meters)
float32 accuracy

# estimated velocity of the object (m/s)
geometry_msgs/Vector3 velocity

# estimated acceleration of the object (m/s2)
geometry_msgs/Accel acceleration

# estimated size of the object (meters)
float32 size

# object’s category
# e.g. Personnel, Package, Passenger, UAV, etc.
string classification

# list of zone(s) in which the object is
ZoneObjectStatus[] zones

# Object visualisation marker
visualization_msgs/Marker bounding_cylinder

================================================================================
MSG: std_msgs/Header
# Standard metadata for higher-level stamped data types.
# This is generally used to communicate timestamped data 
# in a particular coordinate frame.
# 
# sequence ID: consecutively increasing ID 
uint32 seq
#Two-integer timestamp that is expressed as:
# * stamp.sec: seconds (stamp_secs) since epoch (in Python the variable is called 'secs')
# * stamp.nsec: nanoseconds since stamp_secs (in Python the variable is called 'nsecs')
# time-handling sugar is provided by the client library
time stamp
#Frame this data is associated with
string frame_id

================================================================================
MSG: geometry_msgs/Point
# This contains the position of a point in free space
float64 x
float64 y
float64 z

================================================================================
MSG: geometry_msgs/Vector3
# This represents a vector in free space. 
# It is only meant to represent a direction. Therefore, it does not
# make sense to apply a translation to it (e.g., when applying a 
# generic rigid transformation to a Vector3, tf2 will only apply the
# rotation). If you want your data to be translatable too, use the
# geometry_msgs/Point message instead.

float64 x
float64 y
float64 z
================================================================================
MSG: geometry_msgs/Accel
# This expresses acceleration in free space broken into its linear and angular parts.
Vector3  linear
Vector3  angular

================================================================================
MSG: digitaleye_msgs/ZoneObjectStatus
# Status of the object within the specified zone

# identifier of the zone the object is in
uint32 zone_id

# whether or not the object is allowed in the zone
bool allowed

# time the object was first detected in this zone
# (ros timestamp in epoch time)
time first_detected

# time the object was last detected in this zone
# (ros timestamp in epoch time)
time last_detected

================================================================================
MSG: visualization_msgs/Marker
# See http://www.ros.org/wiki/rviz/DisplayTypes/Marker and http://www.ros.org/wiki/rviz/Tutorials/Markers%3A%20Basic%20Shapes for more information on using this message with rviz

uint8 ARROW=0
uint8 CUBE=1
uint8 SPHERE=2
uint8 CYLINDER=3
uint8 LINE_STRIP=4
uint8 LINE_LIST=5
uint8 CUBE_LIST=6
uint8 SPHERE_LIST=7
uint8 POINTS=8
uint8 TEXT_VIEW_FACING=9
uint8 MESH_RESOURCE=10
uint8 TRIANGLE_LIST=11

uint8 ADD=0
uint8 MODIFY=0
uint8 DELETE=2
uint8 DELETEALL=3

Header header                        # header for time/frame information
string ns                            # Namespace to place this object in... used in conjunction with id to create a unique name for the object
int32 id 		                         # object ID useful in conjunction with the namespace for manipulating and deleting the object later
int32 type 		                       # Type of object
int32 action 	                       # 0 add/modify an object, 1 (deprecated), 2 deletes an object, 3 deletes all objects
geometry_msgs/Pose pose                 # Pose of the object
geometry_msgs/Vector3 scale             # Scale of the object 1,1,1 means default (usually 1 meter square)
std_msgs/ColorRGBA color             # Color [0.0-1.0]
duration lifetime                    # How long the object should last before being automatically deleted.  0 means forever
bool frame_locked                    # If this marker should be frame-locked, i.e. retransformed into its frame every timestep

#Only used if the type specified has some use for them (eg. POINTS, LINE_STRIP, ...)
geometry_msgs/Point[] points
#Only used if the type specified has some use for them (eg. POINTS, LINE_STRIP, ...)
#number of colors must either be 0 or equal to the number of points
#NOTE: alpha is not yet used
std_msgs/ColorRGBA[] colors

# NOTE: only used for text markers
string text

# NOTE: only used for MESH_RESOURCE markers
string mesh_resource
bool mesh_use_embedded_materials

================================================================================
MSG: geometry_msgs/Pose
# A representation of pose in free space, composed of position and orientation. 
Point position
Quaternion orientation

================================================================================
MSG: geometry_msgs/Quaternion
# This represents an orientation in free space in quaternion form.

float64 x
float64 y
float64 z
float64 w

================================================================================
MSG: std_msgs/ColorRGBA
float32 r
float32 g
float32 b
float32 a
"""
  __slots__ = ['header','object_id','fused_ids','position','pos_covariance','accuracy','velocity','acceleration','size','classification','zones','bounding_cylinder']
  _slot_types = ['std_msgs/Header','uint64','uint64[]','geometry_msgs/Point','float32[9]','float32','geometry_msgs/Vector3','geometry_msgs/Accel','float32','string','digitaleye_msgs/ZoneObjectStatus[]','visualization_msgs/Marker']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       header,object_id,fused_ids,position,pos_covariance,accuracy,velocity,acceleration,size,classification,zones,bounding_cylinder

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(Object, self).__init__(*args, **kwds)
      # message fields cannot be None, assign default values for those that are
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.object_id is None:
        self.object_id = 0
      if self.fused_ids is None:
        self.fused_ids = []
      if self.position is None:
        self.position = geometry_msgs.msg.Point()
      if self.pos_covariance is None:
        self.pos_covariance = [0.] * 9
      if self.accuracy is None:
        self.accuracy = 0.
      if self.velocity is None:
        self.velocity = geometry_msgs.msg.Vector3()
      if self.acceleration is None:
        self.acceleration = geometry_msgs.msg.Accel()
      if self.size is None:
        self.size = 0.
      if self.classification is None:
        self.classification = ''
      if self.zones is None:
        self.zones = []
      if self.bounding_cylinder is None:
        self.bounding_cylinder = visualization_msgs.msg.Marker()
    else:
      self.header = std_msgs.msg.Header()
      self.object_id = 0
      self.fused_ids = []
      self.position = geometry_msgs.msg.Point()
      self.pos_covariance = [0.] * 9
      self.accuracy = 0.
      self.velocity = geometry_msgs.msg.Vector3()
      self.acceleration = geometry_msgs.msg.Accel()
      self.size = 0.
      self.classification = ''
      self.zones = []
      self.bounding_cylinder = visualization_msgs.msg.Marker()

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self
      buff.write(_get_struct_3I().pack(_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs))
      _x = self.header.frame_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self.object_id
      buff.write(_get_struct_Q().pack(_x))
      length = len(self.fused_ids)
      buff.write(_struct_I.pack(length))
      pattern = '<%sQ'%length
      buff.write(struct.Struct(pattern).pack(*self.fused_ids))
      _x = self
      buff.write(_get_struct_3d().pack(_x.position.x, _x.position.y, _x.position.z))
      buff.write(_get_struct_9f().pack(*self.pos_covariance))
      _x = self
      buff.write(_get_struct_f9df().pack(_x.accuracy, _x.velocity.x, _x.velocity.y, _x.velocity.z, _x.acceleration.linear.x, _x.acceleration.linear.y, _x.acceleration.linear.z, _x.acceleration.angular.x, _x.acceleration.angular.y, _x.acceleration.angular.z, _x.size))
      _x = self.classification
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      length = len(self.zones)
      buff.write(_struct_I.pack(length))
      for val1 in self.zones:
        _x = val1
        buff.write(_get_struct_IB().pack(_x.zone_id, _x.allowed))
        _v1 = val1.first_detected
        _x = _v1
        buff.write(_get_struct_2I().pack(_x.secs, _x.nsecs))
        _v2 = val1.last_detected
        _x = _v2
        buff.write(_get_struct_2I().pack(_x.secs, _x.nsecs))
      _x = self
      buff.write(_get_struct_3I().pack(_x.bounding_cylinder.header.seq, _x.bounding_cylinder.header.stamp.secs, _x.bounding_cylinder.header.stamp.nsecs))
      _x = self.bounding_cylinder.header.frame_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self.bounding_cylinder.ns
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self
      buff.write(_get_struct_3i10d4f2iB().pack(_x.bounding_cylinder.id, _x.bounding_cylinder.type, _x.bounding_cylinder.action, _x.bounding_cylinder.pose.position.x, _x.bounding_cylinder.pose.position.y, _x.bounding_cylinder.pose.position.z, _x.bounding_cylinder.pose.orientation.x, _x.bounding_cylinder.pose.orientation.y, _x.bounding_cylinder.pose.orientation.z, _x.bounding_cylinder.pose.orientation.w, _x.bounding_cylinder.scale.x, _x.bounding_cylinder.scale.y, _x.bounding_cylinder.scale.z, _x.bounding_cylinder.color.r, _x.bounding_cylinder.color.g, _x.bounding_cylinder.color.b, _x.bounding_cylinder.color.a, _x.bounding_cylinder.lifetime.secs, _x.bounding_cylinder.lifetime.nsecs, _x.bounding_cylinder.frame_locked))
      length = len(self.bounding_cylinder.points)
      buff.write(_struct_I.pack(length))
      for val1 in self.bounding_cylinder.points:
        _x = val1
        buff.write(_get_struct_3d().pack(_x.x, _x.y, _x.z))
      length = len(self.bounding_cylinder.colors)
      buff.write(_struct_I.pack(length))
      for val1 in self.bounding_cylinder.colors:
        _x = val1
        buff.write(_get_struct_4f().pack(_x.r, _x.g, _x.b, _x.a))
      _x = self.bounding_cylinder.text
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self.bounding_cylinder.mesh_resource
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self.bounding_cylinder.mesh_use_embedded_materials
      buff.write(_get_struct_B().pack(_x))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.position is None:
        self.position = geometry_msgs.msg.Point()
      if self.velocity is None:
        self.velocity = geometry_msgs.msg.Vector3()
      if self.acceleration is None:
        self.acceleration = geometry_msgs.msg.Accel()
      if self.zones is None:
        self.zones = None
      if self.bounding_cylinder is None:
        self.bounding_cylinder = visualization_msgs.msg.Marker()
      end = 0
      _x = self
      start = end
      end += 12
      (_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs,) = _get_struct_3I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.header.frame_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.header.frame_id = str[start:end]
      start = end
      end += 8
      (self.object_id,) = _get_struct_Q().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      pattern = '<%sQ'%length
      start = end
      s = struct.Struct(pattern)
      end += s.size
      self.fused_ids = s.unpack(str[start:end])
      _x = self
      start = end
      end += 24
      (_x.position.x, _x.position.y, _x.position.z,) = _get_struct_3d().unpack(str[start:end])
      start = end
      end += 36
      self.pos_covariance = _get_struct_9f().unpack(str[start:end])
      _x = self
      start = end
      end += 80
      (_x.accuracy, _x.velocity.x, _x.velocity.y, _x.velocity.z, _x.acceleration.linear.x, _x.acceleration.linear.y, _x.acceleration.linear.z, _x.acceleration.angular.x, _x.acceleration.angular.y, _x.acceleration.angular.z, _x.size,) = _get_struct_f9df().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.classification = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.classification = str[start:end]
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.zones = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.ZoneObjectStatus()
        _x = val1
        start = end
        end += 5
        (_x.zone_id, _x.allowed,) = _get_struct_IB().unpack(str[start:end])
        val1.allowed = bool(val1.allowed)
        _v3 = val1.first_detected
        _x = _v3
        start = end
        end += 8
        (_x.secs, _x.nsecs,) = _get_struct_2I().unpack(str[start:end])
        _v4 = val1.last_detected
        _x = _v4
        start = end
        end += 8
        (_x.secs, _x.nsecs,) = _get_struct_2I().unpack(str[start:end])
        self.zones.append(val1)
      _x = self
      start = end
      end += 12
      (_x.bounding_cylinder.header.seq, _x.bounding_cylinder.header.stamp.secs, _x.bounding_cylinder.header.stamp.nsecs,) = _get_struct_3I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.bounding_cylinder.header.frame_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.bounding_cylinder.header.frame_id = str[start:end]
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.bounding_cylinder.ns = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.bounding_cylinder.ns = str[start:end]
      _x = self
      start = end
      end += 117
      (_x.bounding_cylinder.id, _x.bounding_cylinder.type, _x.bounding_cylinder.action, _x.bounding_cylinder.pose.position.x, _x.bounding_cylinder.pose.position.y, _x.bounding_cylinder.pose.position.z, _x.bounding_cylinder.pose.orientation.x, _x.bounding_cylinder.pose.orientation.y, _x.bounding_cylinder.pose.orientation.z, _x.bounding_cylinder.pose.orientation.w, _x.bounding_cylinder.scale.x, _x.bounding_cylinder.scale.y, _x.bounding_cylinder.scale.z, _x.bounding_cylinder.color.r, _x.bounding_cylinder.color.g, _x.bounding_cylinder.color.b, _x.bounding_cylinder.color.a, _x.bounding_cylinder.lifetime.secs, _x.bounding_cylinder.lifetime.nsecs, _x.bounding_cylinder.frame_locked,) = _get_struct_3i10d4f2iB().unpack(str[start:end])
      self.bounding_cylinder.frame_locked = bool(self.bounding_cylinder.frame_locked)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.bounding_cylinder.points = []
      for i in range(0, length):
        val1 = geometry_msgs.msg.Point()
        _x = val1
        start = end
        end += 24
        (_x.x, _x.y, _x.z,) = _get_struct_3d().unpack(str[start:end])
        self.bounding_cylinder.points.append(val1)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.bounding_cylinder.colors = []
      for i in range(0, length):
        val1 = std_msgs.msg.ColorRGBA()
        _x = val1
        start = end
        end += 16
        (_x.r, _x.g, _x.b, _x.a,) = _get_struct_4f().unpack(str[start:end])
        self.bounding_cylinder.colors.append(val1)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.bounding_cylinder.text = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.bounding_cylinder.text = str[start:end]
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.bounding_cylinder.mesh_resource = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.bounding_cylinder.mesh_resource = str[start:end]
      start = end
      end += 1
      (self.bounding_cylinder.mesh_use_embedded_materials,) = _get_struct_B().unpack(str[start:end])
      self.bounding_cylinder.mesh_use_embedded_materials = bool(self.bounding_cylinder.mesh_use_embedded_materials)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self
      buff.write(_get_struct_3I().pack(_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs))
      _x = self.header.frame_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self.object_id
      buff.write(_get_struct_Q().pack(_x))
      length = len(self.fused_ids)
      buff.write(_struct_I.pack(length))
      pattern = '<%sQ'%length
      buff.write(self.fused_ids.tostring())
      _x = self
      buff.write(_get_struct_3d().pack(_x.position.x, _x.position.y, _x.position.z))
      buff.write(self.pos_covariance.tostring())
      _x = self
      buff.write(_get_struct_f9df().pack(_x.accuracy, _x.velocity.x, _x.velocity.y, _x.velocity.z, _x.acceleration.linear.x, _x.acceleration.linear.y, _x.acceleration.linear.z, _x.acceleration.angular.x, _x.acceleration.angular.y, _x.acceleration.angular.z, _x.size))
      _x = self.classification
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      length = len(self.zones)
      buff.write(_struct_I.pack(length))
      for val1 in self.zones:
        _x = val1
        buff.write(_get_struct_IB().pack(_x.zone_id, _x.allowed))
        _v5 = val1.first_detected
        _x = _v5
        buff.write(_get_struct_2I().pack(_x.secs, _x.nsecs))
        _v6 = val1.last_detected
        _x = _v6
        buff.write(_get_struct_2I().pack(_x.secs, _x.nsecs))
      _x = self
      buff.write(_get_struct_3I().pack(_x.bounding_cylinder.header.seq, _x.bounding_cylinder.header.stamp.secs, _x.bounding_cylinder.header.stamp.nsecs))
      _x = self.bounding_cylinder.header.frame_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self.bounding_cylinder.ns
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self
      buff.write(_get_struct_3i10d4f2iB().pack(_x.bounding_cylinder.id, _x.bounding_cylinder.type, _x.bounding_cylinder.action, _x.bounding_cylinder.pose.position.x, _x.bounding_cylinder.pose.position.y, _x.bounding_cylinder.pose.position.z, _x.bounding_cylinder.pose.orientation.x, _x.bounding_cylinder.pose.orientation.y, _x.bounding_cylinder.pose.orientation.z, _x.bounding_cylinder.pose.orientation.w, _x.bounding_cylinder.scale.x, _x.bounding_cylinder.scale.y, _x.bounding_cylinder.scale.z, _x.bounding_cylinder.color.r, _x.bounding_cylinder.color.g, _x.bounding_cylinder.color.b, _x.bounding_cylinder.color.a, _x.bounding_cylinder.lifetime.secs, _x.bounding_cylinder.lifetime.nsecs, _x.bounding_cylinder.frame_locked))
      length = len(self.bounding_cylinder.points)
      buff.write(_struct_I.pack(length))
      for val1 in self.bounding_cylinder.points:
        _x = val1
        buff.write(_get_struct_3d().pack(_x.x, _x.y, _x.z))
      length = len(self.bounding_cylinder.colors)
      buff.write(_struct_I.pack(length))
      for val1 in self.bounding_cylinder.colors:
        _x = val1
        buff.write(_get_struct_4f().pack(_x.r, _x.g, _x.b, _x.a))
      _x = self.bounding_cylinder.text
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self.bounding_cylinder.mesh_resource
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self.bounding_cylinder.mesh_use_embedded_materials
      buff.write(_get_struct_B().pack(_x))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.position is None:
        self.position = geometry_msgs.msg.Point()
      if self.velocity is None:
        self.velocity = geometry_msgs.msg.Vector3()
      if self.acceleration is None:
        self.acceleration = geometry_msgs.msg.Accel()
      if self.zones is None:
        self.zones = None
      if self.bounding_cylinder is None:
        self.bounding_cylinder = visualization_msgs.msg.Marker()
      end = 0
      _x = self
      start = end
      end += 12
      (_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs,) = _get_struct_3I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.header.frame_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.header.frame_id = str[start:end]
      start = end
      end += 8
      (self.object_id,) = _get_struct_Q().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      pattern = '<%sQ'%length
      start = end
      s = struct.Struct(pattern)
      end += s.size
      self.fused_ids = numpy.frombuffer(str[start:end], dtype=numpy.uint64, count=length)
      _x = self
      start = end
      end += 24
      (_x.position.x, _x.position.y, _x.position.z,) = _get_struct_3d().unpack(str[start:end])
      start = end
      end += 36
      self.pos_covariance = numpy.frombuffer(str[start:end], dtype=numpy.float32, count=9)
      _x = self
      start = end
      end += 80
      (_x.accuracy, _x.velocity.x, _x.velocity.y, _x.velocity.z, _x.acceleration.linear.x, _x.acceleration.linear.y, _x.acceleration.linear.z, _x.acceleration.angular.x, _x.acceleration.angular.y, _x.acceleration.angular.z, _x.size,) = _get_struct_f9df().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.classification = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.classification = str[start:end]
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.zones = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.ZoneObjectStatus()
        _x = val1
        start = end
        end += 5
        (_x.zone_id, _x.allowed,) = _get_struct_IB().unpack(str[start:end])
        val1.allowed = bool(val1.allowed)
        _v7 = val1.first_detected
        _x = _v7
        start = end
        end += 8
        (_x.secs, _x.nsecs,) = _get_struct_2I().unpack(str[start:end])
        _v8 = val1.last_detected
        _x = _v8
        start = end
        end += 8
        (_x.secs, _x.nsecs,) = _get_struct_2I().unpack(str[start:end])
        self.zones.append(val1)
      _x = self
      start = end
      end += 12
      (_x.bounding_cylinder.header.seq, _x.bounding_cylinder.header.stamp.secs, _x.bounding_cylinder.header.stamp.nsecs,) = _get_struct_3I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.bounding_cylinder.header.frame_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.bounding_cylinder.header.frame_id = str[start:end]
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.bounding_cylinder.ns = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.bounding_cylinder.ns = str[start:end]
      _x = self
      start = end
      end += 117
      (_x.bounding_cylinder.id, _x.bounding_cylinder.type, _x.bounding_cylinder.action, _x.bounding_cylinder.pose.position.x, _x.bounding_cylinder.pose.position.y, _x.bounding_cylinder.pose.position.z, _x.bounding_cylinder.pose.orientation.x, _x.bounding_cylinder.pose.orientation.y, _x.bounding_cylinder.pose.orientation.z, _x.bounding_cylinder.pose.orientation.w, _x.bounding_cylinder.scale.x, _x.bounding_cylinder.scale.y, _x.bounding_cylinder.scale.z, _x.bounding_cylinder.color.r, _x.bounding_cylinder.color.g, _x.bounding_cylinder.color.b, _x.bounding_cylinder.color.a, _x.bounding_cylinder.lifetime.secs, _x.bounding_cylinder.lifetime.nsecs, _x.bounding_cylinder.frame_locked,) = _get_struct_3i10d4f2iB().unpack(str[start:end])
      self.bounding_cylinder.frame_locked = bool(self.bounding_cylinder.frame_locked)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.bounding_cylinder.points = []
      for i in range(0, length):
        val1 = geometry_msgs.msg.Point()
        _x = val1
        start = end
        end += 24
        (_x.x, _x.y, _x.z,) = _get_struct_3d().unpack(str[start:end])
        self.bounding_cylinder.points.append(val1)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.bounding_cylinder.colors = []
      for i in range(0, length):
        val1 = std_msgs.msg.ColorRGBA()
        _x = val1
        start = end
        end += 16
        (_x.r, _x.g, _x.b, _x.a,) = _get_struct_4f().unpack(str[start:end])
        self.bounding_cylinder.colors.append(val1)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.bounding_cylinder.text = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.bounding_cylinder.text = str[start:end]
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.bounding_cylinder.mesh_resource = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.bounding_cylinder.mesh_resource = str[start:end]
      start = end
      end += 1
      (self.bounding_cylinder.mesh_use_embedded_materials,) = _get_struct_B().unpack(str[start:end])
      self.bounding_cylinder.mesh_use_embedded_materials = bool(self.bounding_cylinder.mesh_use_embedded_materials)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_2I = None
def _get_struct_2I():
    global _struct_2I
    if _struct_2I is None:
        _struct_2I = struct.Struct("<2I")
    return _struct_2I
_struct_3I = None
def _get_struct_3I():
    global _struct_3I
    if _struct_3I is None:
        _struct_3I = struct.Struct("<3I")
    return _struct_3I
_struct_3d = None
def _get_struct_3d():
    global _struct_3d
    if _struct_3d is None:
        _struct_3d = struct.Struct("<3d")
    return _struct_3d
_struct_3i10d4f2iB = None
def _get_struct_3i10d4f2iB():
    global _struct_3i10d4f2iB
    if _struct_3i10d4f2iB is None:
        _struct_3i10d4f2iB = struct.Struct("<3i10d4f2iB")
    return _struct_3i10d4f2iB
_struct_4f = None
def _get_struct_4f():
    global _struct_4f
    if _struct_4f is None:
        _struct_4f = struct.Struct("<4f")
    return _struct_4f
_struct_9f = None
def _get_struct_9f():
    global _struct_9f
    if _struct_9f is None:
        _struct_9f = struct.Struct("<9f")
    return _struct_9f
_struct_B = None
def _get_struct_B():
    global _struct_B
    if _struct_B is None:
        _struct_B = struct.Struct("<B")
    return _struct_B
_struct_IB = None
def _get_struct_IB():
    global _struct_IB
    if _struct_IB is None:
        _struct_IB = struct.Struct("<IB")
    return _struct_IB
_struct_Q = None
def _get_struct_Q():
    global _struct_Q
    if _struct_Q is None:
        _struct_Q = struct.Struct("<Q")
    return _struct_Q
_struct_f9df = None
def _get_struct_f9df():
    global _struct_f9df
    if _struct_f9df is None:
        _struct_f9df = struct.Struct("<f9df")
    return _struct_f9df
