# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from digitaleye_msgs/MASDefinition.msg. Do not edit."""
import codecs
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct

import geometry_msgs.msg

class MASDefinition(genpy.Message):
  _md5sum = "cfbe6fd67311fc566e5fa0739b4d6c8d"
  _type = "digitaleye_msgs/MASDefinition"
  _has_header = False  # flag to mark the presence of a Header object
  _full_text = """# Definition of MAS related spaces:
# MAS cylinder, proximity radiuses & conformance cylinder

# MAS centre in local reference frame (meters)
geometry_msgs/Point mas_center

# MAS radius (meters)
float32 mas_radius

# MAS upper boundary (meters)
float32 mas_height

# radius of proximity for handshake (meters)
float32 handshake_radius

# radius of proximity for landing command (meters)
float32 landing_conf_radius

# radius of conformance cylinder when flying (meters)
float32 flying_conf_radius

================================================================================
MSG: geometry_msgs/Point
# This contains the position of a point in free space
float64 x
float64 y
float64 z
"""
  __slots__ = ['mas_center','mas_radius','mas_height','handshake_radius','landing_conf_radius','flying_conf_radius']
  _slot_types = ['geometry_msgs/Point','float32','float32','float32','float32','float32']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       mas_center,mas_radius,mas_height,handshake_radius,landing_conf_radius,flying_conf_radius

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(MASDefinition, self).__init__(*args, **kwds)
      # message fields cannot be None, assign default values for those that are
      if self.mas_center is None:
        self.mas_center = geometry_msgs.msg.Point()
      if self.mas_radius is None:
        self.mas_radius = 0.
      if self.mas_height is None:
        self.mas_height = 0.
      if self.handshake_radius is None:
        self.handshake_radius = 0.
      if self.landing_conf_radius is None:
        self.landing_conf_radius = 0.
      if self.flying_conf_radius is None:
        self.flying_conf_radius = 0.
    else:
      self.mas_center = geometry_msgs.msg.Point()
      self.mas_radius = 0.
      self.mas_height = 0.
      self.handshake_radius = 0.
      self.landing_conf_radius = 0.
      self.flying_conf_radius = 0.

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self
      buff.write(_get_struct_3d5f().pack(_x.mas_center.x, _x.mas_center.y, _x.mas_center.z, _x.mas_radius, _x.mas_height, _x.handshake_radius, _x.landing_conf_radius, _x.flying_conf_radius))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.mas_center is None:
        self.mas_center = geometry_msgs.msg.Point()
      end = 0
      _x = self
      start = end
      end += 44
      (_x.mas_center.x, _x.mas_center.y, _x.mas_center.z, _x.mas_radius, _x.mas_height, _x.handshake_radius, _x.landing_conf_radius, _x.flying_conf_radius,) = _get_struct_3d5f().unpack(str[start:end])
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self
      buff.write(_get_struct_3d5f().pack(_x.mas_center.x, _x.mas_center.y, _x.mas_center.z, _x.mas_radius, _x.mas_height, _x.handshake_radius, _x.landing_conf_radius, _x.flying_conf_radius))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.mas_center is None:
        self.mas_center = geometry_msgs.msg.Point()
      end = 0
      _x = self
      start = end
      end += 44
      (_x.mas_center.x, _x.mas_center.y, _x.mas_center.z, _x.mas_radius, _x.mas_height, _x.handshake_radius, _x.landing_conf_radius, _x.flying_conf_radius,) = _get_struct_3d5f().unpack(str[start:end])
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_3d5f = None
def _get_struct_3d5f():
    global _struct_3d5f
    if _struct_3d5f is None:
        _struct_3d5f = struct.Struct("<3d5f")
    return _struct_3d5f
