# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from digitaleye_msgs/IMUValue.msg. Do not edit."""
import codecs
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct

import geometry_msgs.msg
import sensor_msgs.msg
import std_msgs.msg

class IMUValue(genpy.Message):
  _md5sum = "f810a9fb96b5c545a796b5013e14dd23"
  _type = "digitaleye_msgs/IMUValue"
  _has_header = False  # flag to mark the presence of a Header object
  _full_text = """# Description of an IMU value reading

# Imu heading
float32 heading

# Unique identifier of the sensor
# e.g. hardware serial number
string device_id

# Imu measurements
sensor_msgs/Imu imu

# Magenetometer readings
geometry_msgs/Vector3 magnetic_field

# Imu reading of roll
float32 roll

# Imu reading of pitch
float32 pitch

# Calibration status
bool deviceCalibrated

================================================================================
MSG: sensor_msgs/Imu
# This is a message to hold data from an IMU (Inertial Measurement Unit)
#
# Accelerations should be in m/s^2 (not in g's), and rotational velocity should be in rad/sec
#
# If the covariance of the measurement is known, it should be filled in (if all you know is the 
# variance of each measurement, e.g. from the datasheet, just put those along the diagonal)
# A covariance matrix of all zeros will be interpreted as "covariance unknown", and to use the
# data a covariance will have to be assumed or gotten from some other source
#
# If you have no estimate for one of the data elements (e.g. your IMU doesn't produce an orientation 
# estimate), please set element 0 of the associated covariance matrix to -1
# If you are interpreting this message, please check for a value of -1 in the first element of each 
# covariance matrix, and disregard the associated estimate.

Header header

geometry_msgs/Quaternion orientation
float64[9] orientation_covariance # Row major about x, y, z axes

geometry_msgs/Vector3 angular_velocity
float64[9] angular_velocity_covariance # Row major about x, y, z axes

geometry_msgs/Vector3 linear_acceleration
float64[9] linear_acceleration_covariance # Row major x, y z 

================================================================================
MSG: std_msgs/Header
# Standard metadata for higher-level stamped data types.
# This is generally used to communicate timestamped data 
# in a particular coordinate frame.
# 
# sequence ID: consecutively increasing ID 
uint32 seq
#Two-integer timestamp that is expressed as:
# * stamp.sec: seconds (stamp_secs) since epoch (in Python the variable is called 'secs')
# * stamp.nsec: nanoseconds since stamp_secs (in Python the variable is called 'nsecs')
# time-handling sugar is provided by the client library
time stamp
#Frame this data is associated with
string frame_id

================================================================================
MSG: geometry_msgs/Quaternion
# This represents an orientation in free space in quaternion form.

float64 x
float64 y
float64 z
float64 w

================================================================================
MSG: geometry_msgs/Vector3
# This represents a vector in free space. 
# It is only meant to represent a direction. Therefore, it does not
# make sense to apply a translation to it (e.g., when applying a 
# generic rigid transformation to a Vector3, tf2 will only apply the
# rotation). If you want your data to be translatable too, use the
# geometry_msgs/Point message instead.

float64 x
float64 y
float64 z"""
  __slots__ = ['heading','device_id','imu','magnetic_field','roll','pitch','deviceCalibrated']
  _slot_types = ['float32','string','sensor_msgs/Imu','geometry_msgs/Vector3','float32','float32','bool']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       heading,device_id,imu,magnetic_field,roll,pitch,deviceCalibrated

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(IMUValue, self).__init__(*args, **kwds)
      # message fields cannot be None, assign default values for those that are
      if self.heading is None:
        self.heading = 0.
      if self.device_id is None:
        self.device_id = ''
      if self.imu is None:
        self.imu = sensor_msgs.msg.Imu()
      if self.magnetic_field is None:
        self.magnetic_field = geometry_msgs.msg.Vector3()
      if self.roll is None:
        self.roll = 0.
      if self.pitch is None:
        self.pitch = 0.
      if self.deviceCalibrated is None:
        self.deviceCalibrated = False
    else:
      self.heading = 0.
      self.device_id = ''
      self.imu = sensor_msgs.msg.Imu()
      self.magnetic_field = geometry_msgs.msg.Vector3()
      self.roll = 0.
      self.pitch = 0.
      self.deviceCalibrated = False

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self.heading
      buff.write(_get_struct_f().pack(_x))
      _x = self.device_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self
      buff.write(_get_struct_3I().pack(_x.imu.header.seq, _x.imu.header.stamp.secs, _x.imu.header.stamp.nsecs))
      _x = self.imu.header.frame_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self
      buff.write(_get_struct_4d().pack(_x.imu.orientation.x, _x.imu.orientation.y, _x.imu.orientation.z, _x.imu.orientation.w))
      buff.write(_get_struct_9d().pack(*self.imu.orientation_covariance))
      _x = self
      buff.write(_get_struct_3d().pack(_x.imu.angular_velocity.x, _x.imu.angular_velocity.y, _x.imu.angular_velocity.z))
      buff.write(_get_struct_9d().pack(*self.imu.angular_velocity_covariance))
      _x = self
      buff.write(_get_struct_3d().pack(_x.imu.linear_acceleration.x, _x.imu.linear_acceleration.y, _x.imu.linear_acceleration.z))
      buff.write(_get_struct_9d().pack(*self.imu.linear_acceleration_covariance))
      _x = self
      buff.write(_get_struct_3d2fB().pack(_x.magnetic_field.x, _x.magnetic_field.y, _x.magnetic_field.z, _x.roll, _x.pitch, _x.deviceCalibrated))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.imu is None:
        self.imu = sensor_msgs.msg.Imu()
      if self.magnetic_field is None:
        self.magnetic_field = geometry_msgs.msg.Vector3()
      end = 0
      start = end
      end += 4
      (self.heading,) = _get_struct_f().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.device_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.device_id = str[start:end]
      _x = self
      start = end
      end += 12
      (_x.imu.header.seq, _x.imu.header.stamp.secs, _x.imu.header.stamp.nsecs,) = _get_struct_3I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.imu.header.frame_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.imu.header.frame_id = str[start:end]
      _x = self
      start = end
      end += 32
      (_x.imu.orientation.x, _x.imu.orientation.y, _x.imu.orientation.z, _x.imu.orientation.w,) = _get_struct_4d().unpack(str[start:end])
      start = end
      end += 72
      self.imu.orientation_covariance = _get_struct_9d().unpack(str[start:end])
      _x = self
      start = end
      end += 24
      (_x.imu.angular_velocity.x, _x.imu.angular_velocity.y, _x.imu.angular_velocity.z,) = _get_struct_3d().unpack(str[start:end])
      start = end
      end += 72
      self.imu.angular_velocity_covariance = _get_struct_9d().unpack(str[start:end])
      _x = self
      start = end
      end += 24
      (_x.imu.linear_acceleration.x, _x.imu.linear_acceleration.y, _x.imu.linear_acceleration.z,) = _get_struct_3d().unpack(str[start:end])
      start = end
      end += 72
      self.imu.linear_acceleration_covariance = _get_struct_9d().unpack(str[start:end])
      _x = self
      start = end
      end += 33
      (_x.magnetic_field.x, _x.magnetic_field.y, _x.magnetic_field.z, _x.roll, _x.pitch, _x.deviceCalibrated,) = _get_struct_3d2fB().unpack(str[start:end])
      self.deviceCalibrated = bool(self.deviceCalibrated)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self.heading
      buff.write(_get_struct_f().pack(_x))
      _x = self.device_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self
      buff.write(_get_struct_3I().pack(_x.imu.header.seq, _x.imu.header.stamp.secs, _x.imu.header.stamp.nsecs))
      _x = self.imu.header.frame_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self
      buff.write(_get_struct_4d().pack(_x.imu.orientation.x, _x.imu.orientation.y, _x.imu.orientation.z, _x.imu.orientation.w))
      buff.write(self.imu.orientation_covariance.tostring())
      _x = self
      buff.write(_get_struct_3d().pack(_x.imu.angular_velocity.x, _x.imu.angular_velocity.y, _x.imu.angular_velocity.z))
      buff.write(self.imu.angular_velocity_covariance.tostring())
      _x = self
      buff.write(_get_struct_3d().pack(_x.imu.linear_acceleration.x, _x.imu.linear_acceleration.y, _x.imu.linear_acceleration.z))
      buff.write(self.imu.linear_acceleration_covariance.tostring())
      _x = self
      buff.write(_get_struct_3d2fB().pack(_x.magnetic_field.x, _x.magnetic_field.y, _x.magnetic_field.z, _x.roll, _x.pitch, _x.deviceCalibrated))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.imu is None:
        self.imu = sensor_msgs.msg.Imu()
      if self.magnetic_field is None:
        self.magnetic_field = geometry_msgs.msg.Vector3()
      end = 0
      start = end
      end += 4
      (self.heading,) = _get_struct_f().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.device_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.device_id = str[start:end]
      _x = self
      start = end
      end += 12
      (_x.imu.header.seq, _x.imu.header.stamp.secs, _x.imu.header.stamp.nsecs,) = _get_struct_3I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.imu.header.frame_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.imu.header.frame_id = str[start:end]
      _x = self
      start = end
      end += 32
      (_x.imu.orientation.x, _x.imu.orientation.y, _x.imu.orientation.z, _x.imu.orientation.w,) = _get_struct_4d().unpack(str[start:end])
      start = end
      end += 72
      self.imu.orientation_covariance = numpy.frombuffer(str[start:end], dtype=numpy.float64, count=9)
      _x = self
      start = end
      end += 24
      (_x.imu.angular_velocity.x, _x.imu.angular_velocity.y, _x.imu.angular_velocity.z,) = _get_struct_3d().unpack(str[start:end])
      start = end
      end += 72
      self.imu.angular_velocity_covariance = numpy.frombuffer(str[start:end], dtype=numpy.float64, count=9)
      _x = self
      start = end
      end += 24
      (_x.imu.linear_acceleration.x, _x.imu.linear_acceleration.y, _x.imu.linear_acceleration.z,) = _get_struct_3d().unpack(str[start:end])
      start = end
      end += 72
      self.imu.linear_acceleration_covariance = numpy.frombuffer(str[start:end], dtype=numpy.float64, count=9)
      _x = self
      start = end
      end += 33
      (_x.magnetic_field.x, _x.magnetic_field.y, _x.magnetic_field.z, _x.roll, _x.pitch, _x.deviceCalibrated,) = _get_struct_3d2fB().unpack(str[start:end])
      self.deviceCalibrated = bool(self.deviceCalibrated)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_3I = None
def _get_struct_3I():
    global _struct_3I
    if _struct_3I is None:
        _struct_3I = struct.Struct("<3I")
    return _struct_3I
_struct_3d = None
def _get_struct_3d():
    global _struct_3d
    if _struct_3d is None:
        _struct_3d = struct.Struct("<3d")
    return _struct_3d
_struct_3d2fB = None
def _get_struct_3d2fB():
    global _struct_3d2fB
    if _struct_3d2fB is None:
        _struct_3d2fB = struct.Struct("<3d2fB")
    return _struct_3d2fB
_struct_4d = None
def _get_struct_4d():
    global _struct_4d
    if _struct_4d is None:
        _struct_4d = struct.Struct("<4d")
    return _struct_4d
_struct_9d = None
def _get_struct_9d():
    global _struct_9d
    if _struct_9d is None:
        _struct_9d = struct.Struct("<9d")
    return _struct_9d
_struct_f = None
def _get_struct_f():
    global _struct_f
    if _struct_f is None:
        _struct_f = struct.Struct("<f")
    return _struct_f
