# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from digitaleye_msgs/GNSSPosition.msg. Do not edit."""
import codecs
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct


class GNSSPosition(genpy.Message):
  _md5sum = "729c5edec3333409ae5a9ac6c0795330"
  _type = "digitaleye_msgs/GNSSPosition"
  _has_header = False  # flag to mark the presence of a Header object
  _full_text = """# Description of a GNSS position reading

# Reported latitude of the receiver
float32 latitude

# Reported longitude of the receiver
float32 longitude

# Reported altitude of the receiver (WGS-84 Ellipsoid)
float32 altitude

# Reported altitude of the receiver (Mean Sea Level)
float32 altitude_msl

# Reported vertical dilution of precision
float32 vDOP

# Reported horizontal dilution of precision
float32 hDOP
"""
  __slots__ = ['latitude','longitude','altitude','altitude_msl','vDOP','hDOP']
  _slot_types = ['float32','float32','float32','float32','float32','float32']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       latitude,longitude,altitude,altitude_msl,vDOP,hDOP

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(GNSSPosition, self).__init__(*args, **kwds)
      # message fields cannot be None, assign default values for those that are
      if self.latitude is None:
        self.latitude = 0.
      if self.longitude is None:
        self.longitude = 0.
      if self.altitude is None:
        self.altitude = 0.
      if self.altitude_msl is None:
        self.altitude_msl = 0.
      if self.vDOP is None:
        self.vDOP = 0.
      if self.hDOP is None:
        self.hDOP = 0.
    else:
      self.latitude = 0.
      self.longitude = 0.
      self.altitude = 0.
      self.altitude_msl = 0.
      self.vDOP = 0.
      self.hDOP = 0.

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self
      buff.write(_get_struct_6f().pack(_x.latitude, _x.longitude, _x.altitude, _x.altitude_msl, _x.vDOP, _x.hDOP))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      end = 0
      _x = self
      start = end
      end += 24
      (_x.latitude, _x.longitude, _x.altitude, _x.altitude_msl, _x.vDOP, _x.hDOP,) = _get_struct_6f().unpack(str[start:end])
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self
      buff.write(_get_struct_6f().pack(_x.latitude, _x.longitude, _x.altitude, _x.altitude_msl, _x.vDOP, _x.hDOP))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      end = 0
      _x = self
      start = end
      end += 24
      (_x.latitude, _x.longitude, _x.altitude, _x.altitude_msl, _x.vDOP, _x.hDOP,) = _get_struct_6f().unpack(str[start:end])
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_6f = None
def _get_struct_6f():
    global _struct_6f
    if _struct_6f is None:
        _struct_6f = struct.Struct("<6f")
    return _struct_6f
