# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from digitaleye_msgs/ConformanceStatus.msg. Do not edit."""
import codecs
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct

import digitaleye_msgs.msg
import std_msgs.msg

class ConformanceStatus(genpy.Message):
  _md5sum = "66aaf31254dcae6ac15c16f15599ecaa"
  _type = "digitaleye_msgs/ConformanceStatus"
  _has_header = True  # flag to mark the presence of a Header object
  _full_text = """# conformance status of all UAV objects 

# information on the time at which the status(es)
# was reported (epoch time)
std_msgs/Header header

# list of conforming status of all UAV(s)
digitaleye_msgs/ConformanceUavStatus[] uavs_conforming_status

================================================================================
MSG: std_msgs/Header
# Standard metadata for higher-level stamped data types.
# This is generally used to communicate timestamped data 
# in a particular coordinate frame.
# 
# sequence ID: consecutively increasing ID 
uint32 seq
#Two-integer timestamp that is expressed as:
# * stamp.sec: seconds (stamp_secs) since epoch (in Python the variable is called 'secs')
# * stamp.nsec: nanoseconds since stamp_secs (in Python the variable is called 'nsecs')
# time-handling sugar is provided by the client library
time stamp
#Frame this data is associated with
string frame_id

================================================================================
MSG: digitaleye_msgs/ConformanceUavStatus
# Conformance status details for a UAV

# unique internal UAV id
uint64 uav_id

# state of the conformance of the UAV
# using CONF_ constants
uint32 conformance_state

# indicator of the position of the UAV
# - true: inside MAS
# - false: outside of MAS but inside of extended MAS
bool is_inside_MAS
"""
  __slots__ = ['header','uavs_conforming_status']
  _slot_types = ['std_msgs/Header','digitaleye_msgs/ConformanceUavStatus[]']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       header,uavs_conforming_status

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(ConformanceStatus, self).__init__(*args, **kwds)
      # message fields cannot be None, assign default values for those that are
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.uavs_conforming_status is None:
        self.uavs_conforming_status = []
    else:
      self.header = std_msgs.msg.Header()
      self.uavs_conforming_status = []

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self
      buff.write(_get_struct_3I().pack(_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs))
      _x = self.header.frame_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      length = len(self.uavs_conforming_status)
      buff.write(_struct_I.pack(length))
      for val1 in self.uavs_conforming_status:
        _x = val1
        buff.write(_get_struct_QIB().pack(_x.uav_id, _x.conformance_state, _x.is_inside_MAS))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.uavs_conforming_status is None:
        self.uavs_conforming_status = None
      end = 0
      _x = self
      start = end
      end += 12
      (_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs,) = _get_struct_3I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.header.frame_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.header.frame_id = str[start:end]
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.uavs_conforming_status = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.ConformanceUavStatus()
        _x = val1
        start = end
        end += 13
        (_x.uav_id, _x.conformance_state, _x.is_inside_MAS,) = _get_struct_QIB().unpack(str[start:end])
        val1.is_inside_MAS = bool(val1.is_inside_MAS)
        self.uavs_conforming_status.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self
      buff.write(_get_struct_3I().pack(_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs))
      _x = self.header.frame_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      length = len(self.uavs_conforming_status)
      buff.write(_struct_I.pack(length))
      for val1 in self.uavs_conforming_status:
        _x = val1
        buff.write(_get_struct_QIB().pack(_x.uav_id, _x.conformance_state, _x.is_inside_MAS))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.header is None:
        self.header = std_msgs.msg.Header()
      if self.uavs_conforming_status is None:
        self.uavs_conforming_status = None
      end = 0
      _x = self
      start = end
      end += 12
      (_x.header.seq, _x.header.stamp.secs, _x.header.stamp.nsecs,) = _get_struct_3I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.header.frame_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.header.frame_id = str[start:end]
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.uavs_conforming_status = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.ConformanceUavStatus()
        _x = val1
        start = end
        end += 13
        (_x.uav_id, _x.conformance_state, _x.is_inside_MAS,) = _get_struct_QIB().unpack(str[start:end])
        val1.is_inside_MAS = bool(val1.is_inside_MAS)
        self.uavs_conforming_status.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_3I = None
def _get_struct_3I():
    global _struct_3I
    if _struct_3I is None:
        _struct_3I = struct.Struct("<3I")
    return _struct_3I
_struct_QIB = None
def _get_struct_QIB():
    global _struct_QIB
    if _struct_QIB is None:
        _struct_QIB = struct.Struct("<QIB")
    return _struct_QIB
