# caos-reborn

CLI для кокосика.


<img src="examples/usecase.gif" alt="caos-reborn" height="300">

# Установка
 Просто выполняем 2 команды:

```
$ pip3 install caos-reborn
$ caos init
```

*если команда caos не появлась смотри FAQ*

 После этого во стоит прописать все данные:

 1) Свои данные на [ejudge](https://caos.ejudge.ru/) - ```$ caos login```

 2) Папку в который вы хотите хранить все такси - ```$ caos folder```

 *надо указывать абсолютный путь*, узнать который можно набрав  ``` $pwd ```

 3) Установить clang-format ```$ apt-get install clang-format```, ```$ yum install clang-format``` или через любой другой менеджер пакетов

 Но это опционально тк фичи, которые используют эти данные и так потребуют их.

 <img src="examples/login.gif" alt="login example" height="300">

 Пока я нахожусь в стадии активной разработки также полезно выполнять:

```
$ pip3 install --upgrade caos-reborn
```

(обновлять библиотеку)

# Список команд

1. Страница help если что-то забудите

```$ caos help```

<img src="examples/help.png" alt="help example" height="300">

2. Вывести список всех задач. Выполняем команду

```$ caos status```

<img src="examples/status-new.png" alt="caos status" height="300">

флаг `-s` или `--solved` для решённых

3. Вывести таблицу результатов. Достаточно бесполезно, но если вы уж решили совсем не заходить на caos.ejudge.ru, то лучше трекать результаты.

```$ caos info```

Теперь мощные фичи:

4. Синкануться с ejudge'ем. Для этого надо прописать ```$ caos folder```. Вас попросят ввести путь до папки, в которой вы хотите хранить все задачи с решениями.

Можно выкачивать данные контестов с [ejudge](https://caos.ejudge.ru/):

```$ caos sync```

Это создаст папки под все контесты, в каждом контесте папки под все задачи. Для каждой задачи создадутся файлы `*task_name*.c, generator.py`, а также папка `tests`.

Опциональные параметры:

```--sync-samples, -ssa``` - Выкачать семплы из условий в папку `tests`. По умолчанию они будут `000.dat` и `000.ans`.

```--sync-statements, -sst``` - Выкачать условия для каждой задачи по пути `contest/task/statement.txt`. В будущем можно будет вспомнить о чём задача, в настоящем можно лишний раз не заходить на сайт.

```--sync-all, -sa``` - Выкачать и семплы и условия. Объединяет параметры выше.

<img src="examples/sync-new.png" alt="caos sync" height="500">

Пару слов про `gen.py`: Для каждой задачи нужно генерить свои тесты для проверки. Для удобного сохранения написал save_test, вызвав который вы сохраните новый тест в папку с тестами. Также проверяет на дубликаты.

```$ caos gen``` -  вызвать генератор (просто запускает питоновский файл)

Пример простейшего генератора, который просто записывает пары, которые забили руками(но очев лучше писать что-то более осмысленное):

<img src="examples/generator copy.png" alt="generator example" height="300">

5. Прогоняем свои тесты. Она пробегается по всем файлам из папки `tests`, компилирует код на этих входных данных и сравнивает вывод с эталонным. Для этого, конечно, сначала надо сгенерить тесты (но можно и на исходных запустить).

Запустить можем literally в любой папке, где есть файл с расширением *.c и папка с тестами: ```$ caos test```

Если хотим проверить таску в папке с sync надо передать два параметра --- номер контеста и номер задачи в контесте

```$ caos test -c sm02 -t 3```

<img src="examples/test-new.png" alt="caos test" height="400">

Успешные тесты отмечаются ОКом, по упавшему тесту приходит инфа о первых 10ти различающихся строках.

Если хочется посмотреть на отдельные тесты ```$ caos test -c sm02 -t 3 -d 001 002```

Если без номеров тестов, то просто прогонит по 000 - тесту из условия ```$ caos test -c sm02 -t 3 -d```

6. Отформатировать код. Для этого нужно иметь установленный `clang-format`. Запускаем:

```$ caos style --all```

чтобы отформатировать все исходники, лежащие в вашей папке с контестами

<img src="examples/format.png" alt="format example" height="300">

или

```$ caos style -c sm02 -t 3```

чтобы отформатировать определенную задачу

Чтобы команда работала нужно установить clang-format(зависит от архитектуры, так что в загрузить вместе с caos-reborn не можем):

```$ apt-get install clang-format```, ```$ yum install clang-format``` или установить через любой другой менеджер пакетов

Работает с `clang-format` версии 8+.

# FAQ

### - После установки через pip не находит команду caos

Возможно у вас беды с питоновскими bash скриптами (Скорее всего они не находятся в `$PATH`).

Быстро пофиксить эту проблему можно просто закинув файл [caos](https://github.com/DoomzD/caos-reborn/blob/work_in_progress/caos) из этого репозитория в папку, которая входит в `$PATH` (Например, сохранить в файл ```/usr/local/bin/caos```)

*не забудьте потом сделать его исполняемым* ```chmod +x /usr/local/bin/caos```

### - Где хранятся данные?

Ваш и логин и пароль хранятся локально в вашем компьтере в папке ```.../python3.*/site-packages/caoslib/files/config.ini```, которая лежит с остальными библиотеками в вашем питоне.

Информация об активной сессии с edjude так же храниться там

# Комент автора

Изначально сделано @DoomzD. Сейчас поддерживается @hi_melnikov. По любым вопросам/предложениям пишите в тг.
