# Generated by Django 3.1.2 on 2020-12-05 21:56

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("eveonline", "0012_index_additions"),
        ("eveuniverse", "0004_effect_longer_name"),
        ("authentication", "0017_remove_fleetup_permission"),
    ]

    operations = [
        migrations.CreateModel(
            name="Blueprints",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "permissions": (
                    ("basic_access", "Can access this app"),
                    ("add_blueprint_owner", "Can add blueprint owners"),
                    ("view_alliance_blueprints", "Can view alliance's blueprints"),
                ),
                "managed": False,
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="Owner",
            fields=[
                (
                    "corporation",
                    models.OneToOneField(
                        help_text="Corporation owning blueprints",
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        related_name="+",
                        serialize=False,
                        to="eveonline.evecorporationinfo",
                    ),
                ),
                (
                    "blueprints_last_sync",
                    models.DateTimeField(
                        blank=True,
                        default=None,
                        help_text="when the last sync happened",
                        null=True,
                    ),
                ),
                (
                    "blueprints_last_error",
                    models.IntegerField(
                        choices=[
                            (0, "No error"),
                            (1, "Invalid token"),
                            (2, "Expired token"),
                            (3, "Insufficient permissions"),
                            (4, "No character set for fetching data from ESI"),
                            (5, "ESI API is currently unavailable"),
                            (6, "Operaton mode does not match with current setting"),
                            (99, "Unknown error"),
                        ],
                        default=0,
                        help_text="error that occurred at the last sync atttempt (if any)",
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(
                        default=True,
                        help_text="whether this owner is currently included in the sync process",
                    ),
                ),
                (
                    "character",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        help_text="character used for syncing blueprints",
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="+",
                        to="authentication.characterownership",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Location",
            fields=[
                (
                    "id",
                    models.PositiveBigIntegerField(
                        help_text="Eve Online location ID, either item ID for stations or structure ID for structures",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="In-game name of this station or structure",
                        max_length=100,
                    ),
                ),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "eve_solar_system",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="+",
                        to="eveuniverse.evesolarsystem",
                    ),
                ),
                (
                    "eve_type",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="+",
                        to="eveuniverse.evetype",
                    ),
                ),
                (
                    "owner",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        help_text="corporation this station or structure belongs to",
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="+",
                        to="eveuniverse.eveentity",
                    ),
                ),
            ],
            options={
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="Blueprint",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "location_flag",
                    models.CharField(
                        choices=[
                            ("AssetSafety", "AssetSafety"),
                            ("AutoFit", "AutoFit"),
                            ("Bonus", "Bonus"),
                            ("Booster", "Booster"),
                            ("BoosterBay", "BoosterBay"),
                            ("Capsule", "Capsule"),
                            ("Cargo", "Cargo"),
                            ("CorpDeliveries", "CorpDeliveries"),
                            ("CorpSAG1", "CorpSAG1"),
                            ("CorpSAG2", "CorpSAG2"),
                            ("CorpSAG3", "CorpSAG3"),
                            ("CorpSAG4", "CorpSAG4"),
                            ("CorpSAG5", "CorpSAG5"),
                            ("CorpSAG6", "CorpSAG6"),
                            ("CorpSAG7", "CorpSAG7"),
                            ("CrateLoot", "CrateLoot"),
                            ("Deliveries", "Deliveries"),
                            ("DroneBay", "DroneBay"),
                            ("DustBattle", "DustBattle"),
                            ("DustDatabank", "DustDatabank"),
                            ("FighterBay", "FighterBay"),
                            ("FighterTube0", "FighterTube0"),
                            ("FighterTube1", "FighterTube1"),
                            ("FighterTube2", "FighterTube2"),
                            ("FighterTube3", "FighterTube3"),
                            ("FighterTube4", "FighterTube4"),
                            ("FleetHangar", "FleetHangar"),
                            ("FrigateEscapeBay", "FrigateEscapeBay"),
                            ("Hangar", "Hangar"),
                            ("HangarAll", "HangarAll"),
                            ("HiSlot0", "HiSlot0"),
                            ("HiSlot1", "HiSlot1"),
                            ("HiSlot2", "HiSlot2"),
                            ("HiSlot3", "HiSlot3"),
                            ("HiSlot4", "HiSlot4"),
                            ("HiSlot5", "HiSlot5"),
                            ("HiSlot6", "HiSlot6"),
                            ("HiSlot7", "HiSlot7"),
                            ("HiddenModifiers", "HiddenModifiers"),
                            ("Implant", "Implant"),
                            ("Impounded", "Impounded"),
                            ("JunkyardReprocessed", "JunkyardReprocessed"),
                            ("JunkyardTrashed", "JunkyardTrashed"),
                            ("LoSlot0", "LoSlot0"),
                            ("LoSlot1", "LoSlot1"),
                            ("LoSlot2", "LoSlot2"),
                            ("LoSlot3", "LoSlot3"),
                            ("LoSlot4", "LoSlot4"),
                            ("LoSlot5", "LoSlot5"),
                            ("LoSlot6", "LoSlot6"),
                            ("LoSlot7", "LoSlot7"),
                            ("Locked", "Locked"),
                            ("MedSlot0", "MedSlot0"),
                            ("MedSlot1", "MedSlot1"),
                            ("MedSlot2", "MedSlot2"),
                            ("MedSlot3", "MedSlot3"),
                            ("MedSlot4", "MedSlot4"),
                            ("MedSlot5", "MedSlot5"),
                            ("MedSlot6", "MedSlot6"),
                            ("MedSlot7", "MedSlot7"),
                            ("OfficeFolder", "OfficeFolder"),
                            ("Pilot", "Pilot"),
                            ("PlanetSurface", "PlanetSurface"),
                            ("QuafeBay", "QuafeBay"),
                            ("Reward", "Reward"),
                            ("RigSlot0", "RigSlot0"),
                            ("RigSlot1", "RigSlot1"),
                            ("RigSlot2", "RigSlot2"),
                            ("RigSlot3", "RigSlot3"),
                            ("RigSlot4", "RigSlot4"),
                            ("RigSlot5", "RigSlot5"),
                            ("RigSlot6", "RigSlot6"),
                            ("RigSlot7", "RigSlot7"),
                            ("SecondaryStorage", "SecondaryStorage"),
                            ("ServiceSlot0", "ServiceSlot0"),
                            ("ServiceSlot1", "ServiceSlot1"),
                            ("ServiceSlot2", "ServiceSlot2"),
                            ("ServiceSlot3", "ServiceSlot3"),
                            ("ServiceSlot4", "ServiceSlot4"),
                            ("ServiceSlot5", "ServiceSlot5"),
                            ("ServiceSlot6", "ServiceSlot6"),
                            ("ServiceSlot7", "ServiceSlot7"),
                            ("ShipHangar", "ShipHangar"),
                            ("ShipOffline", "ShipOffline"),
                            ("Skill", "Skill"),
                            ("SkillInTraining", "SkillInTraining"),
                            ("SpecializedAmmoHold", "SpecializedAmmoHold"),
                            (
                                "SpecializedCommandCenterHold",
                                "SpecializedCommandCenterHold",
                            ),
                            ("SpecializedFuelBay", "SpecializedFuelBay"),
                            ("SpecializedGasHold", "SpecializedGasHold"),
                            (
                                "SpecializedIndustrialShipHold",
                                "SpecializedIndustrialShipHold",
                            ),
                            ("SpecializedLargeShipHold", "SpecializedLargeShipHold"),
                            ("SpecializedMaterialBay", "SpecializedMaterialBay"),
                            ("SpecializedMediumShipHold", "SpecializedMediumShipHold"),
                            ("SpecializedMineralHold", "SpecializedMineralHold"),
                            ("SpecializedOreHold", "SpecializedOreHold"),
                            (
                                "SpecializedPlanetaryCommoditiesHold",
                                "SpecializedPlanetaryCommoditiesHold",
                            ),
                            ("SpecializedSalvageHold", "SpecializedSalvageHold"),
                            ("SpecializedShipHold", "SpecializedShipHold"),
                            ("SpecializedSmallShipHold", "SpecializedSmallShipHold"),
                            ("StructureActive", "StructureActive"),
                            ("StructureFuel", "StructureFuel"),
                            ("StructureInactive", "StructureInactive"),
                            ("StructureOffline", "StructureOffline"),
                            ("SubSystemBay", "SubSystemBay"),
                            ("SubSystemSlot0", "SubSystemSlot0"),
                            ("SubSystemSlot1", "SubSystemSlot1"),
                            ("SubSystemSlot2", "SubSystemSlot2"),
                            ("SubSystemSlot3", "SubSystemSlot3"),
                            ("SubSystemSlot4", "SubSystemSlot4"),
                            ("SubSystemSlot5", "SubSystemSlot5"),
                            ("SubSystemSlot6", "SubSystemSlot6"),
                            ("SubSystemSlot7", "SubSystemSlot7"),
                            ("Unlocked", "Unlocked"),
                            ("Wallet", "Wallet"),
                            ("Wardrobe", "Wardrobe"),
                        ],
                        help_text="Specific location of the blueprint",
                        max_length=36,
                    ),
                ),
                (
                    "quantity",
                    models.PositiveIntegerField(
                        default=1, help_text="Number of blueprints"
                    ),
                ),
                (
                    "runs",
                    models.PositiveIntegerField(
                        blank=True, help_text="Runs remaining, if applicable", null=True
                    ),
                ),
                (
                    "material_efficiency",
                    models.PositiveIntegerField(
                        help_text="Material efficiency of the blueprint"
                    ),
                ),
                (
                    "time_efficiency",
                    models.PositiveIntegerField(
                        help_text="Time efficiency of the blueprint"
                    ),
                ),
                (
                    "eve_type",
                    models.ForeignKey(
                        help_text="Blueprint Type",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="eveuniverse.evetype",
                    ),
                ),
                (
                    "location",
                    models.ForeignKey(
                        help_text="Location of the blueprints",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="blueprints.location",
                    ),
                ),
                (
                    "owner",
                    models.ForeignKey(
                        help_text="Corporation that owns the blueprint",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="blueprints.owner",
                    ),
                ),
            ],
        ),
        migrations.AddConstraint(
            model_name="blueprint",
            constraint=models.UniqueConstraint(
                fields=(
                    "owner",
                    "location",
                    "location_flag",
                    "eve_type",
                    "runs",
                    "material_efficiency",
                    "time_efficiency",
                ),
                name="unique_blueprint_constraint",
            ),
        ),
    ]
