import asyncio
from typing import Callable

from autogen_core.models import ChatCompletionClient

from spoox.agents.UbuntuMASGroupAgent.BaseGroupChatAgent import BaseGroupChatAgent
from spoox.agents.UbuntuMASGroupAgent.StructuredFlow.agents.utils import get_TESTER_SYSTEM_MESSAGE
from spoox.environment.Environment import Environment
from spoox.interface.Interface import Interface


class TesterAgent(BaseGroupChatAgent):

    def __init__(
            self,
            topic_type: str,
            group_chat_topic_type: str,
            environment: Environment,
            model_client: ChatCompletionClient,
            interface: Interface,
            usage_stats: dict,
            save_logs_f: Callable,
            previous_agent_topic_type: str,
            next_agent_topic_type: str,
            return_next_time_possible_event: asyncio.Event
    ) -> None:

        super().__init__(
            group_chat_topic_type=group_chat_topic_type,
            description="Agent tasked to test the solution of the given task.",
            system_message=get_TESTER_SYSTEM_MESSAGE(topic_type, previous_agent_topic_type, next_agent_topic_type,
                                                     environment.get_additional_tool_descriptions(self)),
            environment=environment,
            model_client=model_client,
            interface=interface,
            usage_stats=usage_stats,
            save_logs_f=save_logs_f,
            return_next_time_possible_event=return_next_time_possible_event,
            next_agent_topic_types=[previous_agent_topic_type, next_agent_topic_type],
            max_internal_iterations=100,
        )
