"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const aws_kinesisstreams_lambda_1 = require("@aws-solutions-constructs/aws-kinesisstreams-lambda");
const lambda = require("@aws-cdk/aws-lambda");
const core_2 = require("@aws-solutions-constructs/core");
const defaults = require("@aws-solutions-constructs/core");
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, core_2.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for aws-kinesisstreams-kinesisfirehose-s3';
const construct = new aws_kinesisstreams_lambda_1.KinesisStreamsToLambda(stack, 'test-kinesis-lambda', {
    lambdaFunctionProps: {
        runtime: lambda.Runtime.NODEJS_14_X,
        handler: 'index.handler',
        code: lambda.Code.fromAsset(`${__dirname}/lambda`)
    },
});
const streamFirehoseS3 = new lib_1.KinesisStreamsToKinesisFirehoseToS3(stack, 'test-existing-stream-firehose-s3-stack', {
    existingStreamObj: construct.kinesisStream,
    createCloudWatchAlarms: false,
    bucketProps: {
        removalPolicy: core_1.RemovalPolicy.DESTROY,
    },
    logGroupProps: {
        removalPolicy: core_1.RemovalPolicy.DESTROY
    },
    logS3AccessLogs: false
});
const s3Bucket = streamFirehoseS3.s3Bucket;
defaults.addCfnSuppressRules(s3Bucket, [
    { id: 'W35',
        reason: 'This S3 bucket is created for unit/ integration testing purposes only.' },
]);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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