"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PropagateTags = exports.SchedulingStrategy = exports.EcsService = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const aws_ecs_1 = require("@aws-cdk/aws-ecs");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
class EcsService extends core_1.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id);
        const { cluster, serviceName, launchType = aws_ecs_1.LaunchType.FARGATE, platformVersion = '1.4.0', desiredCount = 1, prodTargetGroup, testTargetGroup, taskDefinition, healthCheckGracePeriod = core_1.Duration.seconds(60), } = props;
        this.tags = new core_1.TagManager(core_1.TagType.KEY_VALUE, 'TagManager');
        const containerPort = (_b = props.containerPort) !== null && _b !== void 0 ? _b : taskDefinition.containerPort;
        const { vpc } = cluster;
        this.node.addDependency(prodTargetGroup, testTargetGroup);
        const securityGroups = props.securityGroups || [
            new aws_ec2_1.SecurityGroup(this, 'SecurityGroup', {
                description: `Security group for ${this.node.id} service`,
                vpc,
            }),
        ];
        const serviceToken = new aws_lambda_1.Function(this, 'Function', {
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'ecs-service')),
            handler: 'index.handler',
            timeout: core_1.Duration.minutes(15),
        });
        serviceToken.addToRolePolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['ecs:CreateService', 'ecs:UpdateService', 'ecs:DeleteService', 'ecs:DescribeServices', 'ecs:TagResource', 'ecs:UntagResource'],
            resources: ['*'],
        }));
        serviceToken.addToRolePolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['iam:PassRole'],
            resources: [taskDefinition.executionRole.roleArn],
        }));
        const service = new core_1.CustomResource(this, 'CustomResource', {
            serviceToken: serviceToken.functionArn,
            resourceType: 'Custom::BlueGreenService',
            properties: {
                Cluster: cluster.clusterName,
                ServiceName: serviceName,
                ContainerName: taskDefinition.containerName,
                TaskDefinition: taskDefinition.taskDefinitionArn,
                LaunchType: launchType,
                PlatformVersion: platformVersion,
                DesiredCount: desiredCount,
                Subnets: vpc.privateSubnets.map((sn) => sn.subnetId),
                SecurityGroups: securityGroups.map((sg) => sg.securityGroupId),
                TargetGroupArn: prodTargetGroup.targetGroupArn,
                ContainerPort: containerPort,
                SchedulingStrategy: SchedulingStrategy.REPLICA,
                HealthCheckGracePeriodSeconds: healthCheckGracePeriod.toSeconds(),
                PropagateTags: props.propagateTags,
                DeploymentConfiguration: {
                    maximumPercent: (_c = props.maxHealthyPercent) !== null && _c !== void 0 ? _c : 200,
                    minimumHealthyPercent: (_d = props.minHealthyPercent) !== null && _d !== void 0 ? _d : 50,
                    deploymentCircuitBreaker: props.circuitBreaker
                        ? {
                            enable: true,
                            rollback: (_e = props.circuitBreaker.rollback) !== null && _e !== void 0 ? _e : false,
                        }
                        : undefined,
                },
                Tags: core_1.Lazy.any({ produce: () => this.tags.renderTags() }),
            },
        });
        service.node.addDependency(prodTargetGroup.loadBalancerAttached);
        this.serviceName = service.getAttString('ServiceName');
        this.clusterName = cluster.clusterName;
        this.connections = new aws_ec2_1.Connections({
            securityGroups,
            defaultPort: aws_ec2_1.Port.tcp(containerPort),
        });
    }
}
exports.EcsService = EcsService;
_a = JSII_RTTI_SYMBOL_1;
EcsService[_a] = { fqn: "@cloudcomponents/cdk-blue-green-container-deployment.EcsService", version: "1.49.0" };
var SchedulingStrategy;
(function (SchedulingStrategy) {
    SchedulingStrategy["REPLICA"] = "REPLICA";
    SchedulingStrategy["DAEMON"] = "DAEMON";
})(SchedulingStrategy = exports.SchedulingStrategy || (exports.SchedulingStrategy = {}));
var PropagateTags;
(function (PropagateTags) {
    PropagateTags["TASK_DEFINITION"] = "TASK_DEFINITION";
    PropagateTags["SERVICE"] = "SERVICE";
})(PropagateTags = exports.PropagateTags || (exports.PropagateTags = {}));
//# sourceMappingURL=data:application/json;base64,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