"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcsDeploymentConfig = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_codedeploy_1 = require("@aws-cdk/aws-codedeploy");
const core_1 = require("@aws-cdk/core");
class EcsDeploymentConfig extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        const cfnDeploymentConfig = new aws_codedeploy_1.CfnDeploymentConfig(this, 'EcsDeploymentConfiguration', {
            computePlatform: 'ECS',
            ...props,
        });
        this.deploymentConfigName = cfnDeploymentConfig.ref;
        this.deploymentConfigArn = arnForDeploymentConfig(this.deploymentConfigName);
    }
    /**
     * Import a custom Deployment Configuration for an ECS Deployment Group defined outside the CDK.
     *
     * @param _scope the parent Construct for this new Construct.
     * @param _id the logical ID of this new Construct.
     * @param ecsDeploymentConfigName the name of the referenced custom Deployment Configuration.
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     */
    static fromEcsDeploymentConfigName(_scope, _id, ecsDeploymentConfigName) {
        return deploymentConfig(ecsDeploymentConfigName);
    }
}
exports.EcsDeploymentConfig = EcsDeploymentConfig;
_a = JSII_RTTI_SYMBOL_1;
EcsDeploymentConfig[_a] = { fqn: "@cloudcomponents/cdk-blue-green-container-deployment.EcsDeploymentConfig", version: "1.49.0" };
EcsDeploymentConfig.LINEAR_10PERCENT_EVERY_1MINUTE = deploymentConfig('CodeDeployDefault.ECSLinear10PercentEvery1Minutes');
EcsDeploymentConfig.LINEAR_10PERCENT_EVERY_3MINUTES = deploymentConfig('CodeDeployDefault.ECSLinear10PercentEvery3Minutes');
EcsDeploymentConfig.CANARY_10PERCENT_5MINUTES = deploymentConfig('CodeDeployDefault.ECSCanary10Percent5Minutes');
EcsDeploymentConfig.CANARY_10PERCENT_15MINUTES = deploymentConfig('CodeDeployDefault.ECSCanary10Percent15Minutes');
EcsDeploymentConfig.ALL_AT_ONCE = deploymentConfig('CodeDeployDefault.ECSAllAtOnce');
function deploymentConfig(name) {
    return {
        deploymentConfigName: name,
        deploymentConfigArn: arnForDeploymentConfig(name),
    };
}
function arnForDeploymentConfig(name) {
    return `arn:${core_1.Aws.PARTITION}:codedeploy:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:deploymentconfig:${name}`;
}
//# sourceMappingURL=data:application/json;base64,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