# This code is part of OpenFE and is licensed under the MIT license.
# For details, see https://github.com/OpenFreeEnergy/gufe

from typing import TypeVar
from rdkit import Chem

try:
    from typing import TypeAlias  # type: ignore
except ImportError:
    from typing_extensions import TypeAlias

RDKitMol: TypeAlias = Chem.rdchem.Mol
OEMol = TypeVar('OEMol')
