# Generated by Django 5.1.3 on 2024-12-16 21:49

import django.db.models.deletion
import lamindb.base.fields
import lamindb.base.ids
import lamindb.base.users
import lamindb.models
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("bionty", "0041_squashed"),
        ("lamindb", "0069_squashed"),
        ("wetlab", "0028_remove_combinationperturbation_compounds_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="ArtifactBiologic",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(auto_now_add=True, db_index=True),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "label_ref_is_name",
                    lamindb.base.fields.BooleanField(
                        blank=True, default=None, null=True
                    ),
                ),
                (
                    "feature_ref_is_name",
                    lamindb.base.fields.BooleanField(
                        blank=True, default=None, null=True
                    ),
                ),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_biologic",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactbiologic",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(lamindb.models.LinkORM, models.Model),
        ),
        migrations.CreateModel(
            name="Biologic",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(auto_now_add=True, db_index=True),
                ),
                (
                    "updated_at",
                    lamindb.base.fields.DateTimeField(auto_now=True, db_index=True),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    lamindb.base.fields.CharField(
                        blank=True,
                        default=lamindb.base.ids.base62_12,
                        max_length=12,
                        unique=True,
                    ),
                ),
                (
                    "name",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=255,
                        unique=True,
                    ),
                ),
                (
                    "type",
                    lamindb.base.fields.CharField(
                        blank=True, db_index=True, default=None, max_length=32
                    ),
                ),
                (
                    "abbr",
                    lamindb.base.fields.CharField(
                        blank=True,
                        db_index=True,
                        default=None,
                        max_length=32,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "synonyms",
                    lamindb.base.fields.TextField(blank=True, default=None, null=True),
                ),
                (
                    "description",
                    lamindb.base.fields.TextField(blank=True, default=None, null=True),
                ),
                (
                    "_previous_runs",
                    models.ManyToManyField(related_name="+", to="lamindb.run"),
                ),
                (
                    "artifacts",
                    models.ManyToManyField(
                        related_name="biologics",
                        through="wetlab.ArtifactBiologic",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "proteins",
                    models.ManyToManyField(
                        related_name="biologics", to="bionty.protein"
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "targets",
                    models.ManyToManyField(
                        related_name="biologic_targets", to="wetlab.perturbationtarget"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(lamindb.models.CanCurate, models.Model),
        ),
        migrations.AddField(
            model_name="artifactbiologic",
            name="biologic",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="links_artifact",
                to="wetlab.biologic",
            ),
        ),
    ]
