# Generated by Django 5.2 on 2024-09-16 17:17

import bionty.ids
import django.db.models.deletion
import lamindb.base.users
import lamindb.models
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("bionty", "0039_alter_cellline_source_alter_cellmarker_source_and_more"),
        ("lamindb", "0066_alter_artifact__feature_values_and_more"),
        ("wetlab", "0021_alter_compoundtreatment_duration_unit_and_more"),
    ]

    operations = [
        migrations.RemoveField(
            model_name="experiment",
            name="experiment_type",
        ),
        migrations.RemoveField(
            model_name="biosample",
            name="collections",
        ),
        migrations.RemoveField(
            model_name="compoundtreatment",
            name="duration",
        ),
        migrations.RemoveField(
            model_name="compoundtreatment",
            name="duration_unit",
        ),
        migrations.RemoveField(
            model_name="compoundtreatment",
            name="ontology_id",
        ),
        migrations.RemoveField(
            model_name="compoundtreatment",
            name="pubchem_id",
        ),
        migrations.RemoveField(
            model_name="environmentaltreatment",
            name="duration",
        ),
        migrations.RemoveField(
            model_name="environmentaltreatment",
            name="duration_unit",
        ),
        migrations.RemoveField(
            model_name="experiment",
            name="collections",
        ),
        migrations.RemoveField(
            model_name="well",
            name="collections",
        ),
        migrations.AddField(
            model_name="biosample",
            name="_previous_runs",
            field=models.ManyToManyField(related_name="+", to="lamindb.run"),
        ),
        migrations.AddField(
            model_name="biosample",
            name="artifacts",
            field=models.ManyToManyField(
                related_name="biosamples", to="lamindb.artifact"
            ),
        ),
        migrations.AddField(
            model_name="biosample",
            name="created_by",
            field=models.ForeignKey(
                default=lamindb.base.users.current_user_id,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.AddField(
            model_name="biosample",
            name="organism",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="biosamples",
                to="bionty.organism",
            ),
        ),
        migrations.AddField(
            model_name="biosample",
            name="run",
            field=models.ForeignKey(
                default=lamindb.models.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="combinationtreatment",
            name="_previous_runs",
            field=models.ManyToManyField(related_name="+", to="lamindb.run"),
        ),
        migrations.AddField(
            model_name="combinationtreatment",
            name="run",
            field=models.ForeignKey(
                default=lamindb.models.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="compoundtreatment",
            name="_previous_runs",
            field=models.ManyToManyField(related_name="+", to="lamindb.run"),
        ),
        migrations.AddField(
            model_name="compoundtreatment",
            name="run",
            field=models.ForeignKey(
                default=lamindb.models.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="environmentaltreatment",
            name="_previous_runs",
            field=models.ManyToManyField(related_name="+", to="lamindb.run"),
        ),
        migrations.AddField(
            model_name="environmentaltreatment",
            name="run",
            field=models.ForeignKey(
                default=lamindb.models.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="experiment",
            name="_previous_runs",
            field=models.ManyToManyField(related_name="+", to="lamindb.run"),
        ),
        migrations.AddField(
            model_name="experiment",
            name="run",
            field=models.ForeignKey(
                default=lamindb.models.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="genetictreatment",
            name="_previous_runs",
            field=models.ManyToManyField(related_name="+", to="lamindb.run"),
        ),
        migrations.AddField(
            model_name="genetictreatment",
            name="run",
            field=models.ForeignKey(
                default=lamindb.models.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="techsample",
            name="_previous_runs",
            field=models.ManyToManyField(related_name="+", to="lamindb.run"),
        ),
        migrations.AddField(
            model_name="techsample",
            name="artifacts",
            field=models.ManyToManyField(
                related_name="techsamples", to="lamindb.artifact"
            ),
        ),
        migrations.AddField(
            model_name="techsample",
            name="run",
            field=models.ForeignKey(
                default=lamindb.models.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="treatmenttarget",
            name="_previous_runs",
            field=models.ManyToManyField(related_name="+", to="lamindb.run"),
        ),
        migrations.AddField(
            model_name="treatmenttarget",
            name="run",
            field=models.ForeignKey(
                default=lamindb.models.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AddField(
            model_name="well",
            name="_previous_runs",
            field=models.ManyToManyField(related_name="+", to="lamindb.run"),
        ),
        migrations.AddField(
            model_name="well",
            name="run",
            field=models.ForeignKey(
                default=lamindb.models.current_run,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.run",
            ),
        ),
        migrations.AlterField(
            model_name="combinationtreatment",
            name="created_by",
            field=models.ForeignKey(
                default=lamindb.base.users.current_user_id,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.AlterField(
            model_name="compoundtreatment",
            name="created_by",
            field=models.ForeignKey(
                default=lamindb.base.users.current_user_id,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.AlterField(
            model_name="environmentaltreatment",
            name="created_by",
            field=models.ForeignKey(
                default=lamindb.base.users.current_user_id,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.AlterField(
            model_name="experiment",
            name="created_by",
            field=models.ForeignKey(
                default=lamindb.base.users.current_user_id,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.AlterField(
            model_name="genetictreatment",
            name="created_by",
            field=models.ForeignKey(
                default=lamindb.base.users.current_user_id,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.AlterField(
            model_name="techsample",
            name="created_by",
            field=models.ForeignKey(
                default=lamindb.base.users.current_user_id,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.AlterField(
            model_name="treatmenttarget",
            name="created_by",
            field=models.ForeignKey(
                default=lamindb.base.users.current_user_id,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.AlterField(
            model_name="well",
            name="created_by",
            field=models.ForeignKey(
                default=lamindb.base.users.current_user_id,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="lamindb.user",
            ),
        ),
        migrations.CreateModel(
            name="ArtifactBiosample",
            fields=[
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("label_ref_is_name", models.BooleanField(default=None, null=True)),
                ("feature_ref_is_name", models.BooleanField(default=None, null=True)),
                (
                    "artifact",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_biosample",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "biosample",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifact",
                        to="wetlab.biosample",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=lamindb.base.users.current_user_id,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactbiosample",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    models.ForeignKey(
                        default=lamindb.models.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(lamindb.models.LinkORM, models.Model),
        ),
        migrations.CreateModel(
            name="ArtifactCombinationTreatment",
            fields=[
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("label_ref_is_name", models.BooleanField(default=None, null=True)),
                ("feature_ref_is_name", models.BooleanField(default=None, null=True)),
                (
                    "artifact",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_combination_treatment",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "combinationtreatment",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifact",
                        to="wetlab.combinationtreatment",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=lamindb.base.users.current_user_id,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactcombinationtreatment",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    models.ForeignKey(
                        default=lamindb.models.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(lamindb.models.LinkORM, models.Model),
        ),
        migrations.CreateModel(
            name="ArtifactCompoundTreatment",
            fields=[
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("label_ref_is_name", models.BooleanField(default=None, null=True)),
                ("feature_ref_is_name", models.BooleanField(default=None, null=True)),
                (
                    "artifact",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_compound_treatment",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "compoundtreatment",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifact",
                        to="wetlab.compoundtreatment",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=lamindb.base.users.current_user_id,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactcompoundtreatment",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    models.ForeignKey(
                        default=lamindb.models.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(lamindb.models.LinkORM, models.Model),
        ),
        migrations.CreateModel(
            name="ArtifactEnvironmentalTreatment",
            fields=[
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("label_ref_is_name", models.BooleanField(default=None, null=True)),
                ("feature_ref_is_name", models.BooleanField(default=None, null=True)),
                (
                    "artifact",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_environmental_treatment",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=lamindb.base.users.current_user_id,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "environmentaltreatment",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifact",
                        to="wetlab.environmentaltreatment",
                    ),
                ),
                (
                    "feature",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactenvironmentaltreatment",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    models.ForeignKey(
                        default=lamindb.models.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(lamindb.models.LinkORM, models.Model),
        ),
        migrations.CreateModel(
            name="ArtifactExperiment",
            fields=[
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("label_ref_is_name", models.BooleanField(default=None, null=True)),
                ("feature_ref_is_name", models.BooleanField(default=None, null=True)),
                (
                    "artifact",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_experiment",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=lamindb.base.users.current_user_id,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "experiment",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifact",
                        to="wetlab.experiment",
                    ),
                ),
                (
                    "feature",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactexperiment",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    models.ForeignKey(
                        default=lamindb.models.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(lamindb.models.LinkORM, models.Model),
        ),
        migrations.CreateModel(
            name="ArtifactGeneticTreatment",
            fields=[
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("label_ref_is_name", models.BooleanField(default=None, null=True)),
                ("feature_ref_is_name", models.BooleanField(default=None, null=True)),
                (
                    "artifact",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_genetic_treatment",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=lamindb.base.users.current_user_id,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactgenetictreatment",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "genetictreatment",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifact",
                        to="wetlab.genetictreatment",
                    ),
                ),
                (
                    "run",
                    models.ForeignKey(
                        default=lamindb.models.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(lamindb.models.LinkORM, models.Model),
        ),
        migrations.CreateModel(
            name="ArtifactTechsample",
            fields=[
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("label_ref_is_name", models.BooleanField(default=None, null=True)),
                ("feature_ref_is_name", models.BooleanField(default=None, null=True)),
                (
                    "artifact",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_techsample",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=lamindb.base.users.current_user_id,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifacttechsample",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    models.ForeignKey(
                        default=lamindb.models.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "techsample",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifact",
                        to="wetlab.techsample",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(lamindb.models.LinkORM, models.Model),
        ),
        migrations.CreateModel(
            name="ArtifactTreatmentTarget",
            fields=[
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("label_ref_is_name", models.BooleanField(default=None, null=True)),
                ("feature_ref_is_name", models.BooleanField(default=None, null=True)),
                (
                    "artifact",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_treatment_target",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=lamindb.base.users.current_user_id,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifacttreatmenttarget",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    models.ForeignKey(
                        default=lamindb.models.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "treatmenttarget",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifact",
                        to="wetlab.treatmenttarget",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(lamindb.models.LinkORM, models.Model),
        ),
        migrations.CreateModel(
            name="ArtifactWell",
            fields=[
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("label_ref_is_name", models.BooleanField(default=None, null=True)),
                ("feature_ref_is_name", models.BooleanField(default=None, null=True)),
                (
                    "artifact",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_well",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=lamindb.base.users.current_user_id,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactwell",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    models.ForeignKey(
                        default=lamindb.models.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "well",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifact",
                        to="wetlab.well",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(lamindb.models.LinkORM, models.Model),
        ),
        migrations.CreateModel(
            name="Compound",
            fields=[
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("updated_at", models.DateTimeField(auto_now=True, db_index=True)),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "uid",
                    models.CharField(
                        default=bionty.ids.ontology, max_length=8, unique=True
                    ),
                ),
                ("name", models.CharField(db_index=True, max_length=256)),
                (
                    "ontology_id",
                    models.CharField(
                        db_index=True, default=None, max_length=32, null=True
                    ),
                ),
                (
                    "abbr",
                    models.CharField(
                        db_index=True,
                        default=None,
                        max_length=32,
                        null=True,
                        unique=True,
                    ),
                ),
                ("synonyms", models.TextField(default=None, null=True)),
                ("description", models.TextField(default=None, null=True)),
                (
                    "_previous_runs",
                    models.ManyToManyField(related_name="+", to="lamindb.run"),
                ),
                (
                    "artifacts",
                    models.ManyToManyField(
                        related_name="compounds", to="lamindb.artifact"
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=lamindb.base.users.current_user_id,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "parents",
                    models.ManyToManyField(
                        related_name="children", to="wetlab.compound"
                    ),
                ),
                (
                    "run",
                    models.ForeignKey(
                        default=lamindb.models.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "source",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="bionty.source",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(
                models.Model,
                lamindb.models.HasParents,
                lamindb.models.CanCurate,
            ),
        ),
        migrations.CreateModel(
            name="ArtifactCompound",
            fields=[
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("label_ref_is_name", models.BooleanField(default=None, null=True)),
                ("feature_ref_is_name", models.BooleanField(default=None, null=True)),
                (
                    "artifact",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_compound",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=lamindb.base.users.current_user_id,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactcompound",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "run",
                    models.ForeignKey(
                        default=lamindb.models.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "compound",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifact",
                        to="wetlab.compound",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(lamindb.models.LinkORM, models.Model),
        ),
        migrations.AddField(
            model_name="compoundtreatment",
            name="compounds",
            field=models.ManyToManyField(
                related_name="compounds", to="wetlab.compound"
            ),
        ),
        migrations.DeleteModel(
            name="ExperimentType",
        ),
    ]
