/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var r=Object.freeze;return e(r)||(r=function(e){return e}),r}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var r=function(e,r){return void 0!==e?e:r};return r.EMPTY_OBJECT=e({}),r}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var r=function(e){this.name="DeveloperError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r.throwInstantiationError=function(){throw new r("This function defines an interface and should not be called directly.")},r}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var t;for(this.mti==this.N+1&&this.init_genrand(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^r[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^r[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^r[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.signNotZero=function(e){return 0>e?-1:1},i.toSNorm=function(e){return Math.round(255*(.5*i.clamp(e,-1,1)+.5))},i.fromSNorm=function(e){return i.clamp(e,0,255)/255*2-1},i.sinh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r-t)},i.cosh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r+t)},i.lerp=function(e,r,t){return(1-t)*e+t*r},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=3*Math.PI*.5,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){if(!t(e))throw new n("degrees is required.");return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){if(!t(e))throw new n("radians is required.");return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){if(!t(e))throw new n("angle is required.");var r=i.TWO_PI,o=e-Math.floor(e/r)*r;return o<-Math.PI?o+r:o>=Math.PI?o-r:o},i.negativePiToPi=function(e){if(!t(e))throw new n("x is required.");return i.zeroToTwoPi(e+i.PI)-i.PI},i.zeroToTwoPi=function(e){if(!t(e))throw new n("x is required.");var r=i.mod(e,i.TWO_PI);return Math.abs(r)<i.EPSILON14&&Math.abs(e)>i.EPSILON14?i.TWO_PI:r},i.mod=function(e,r){if(!t(e))throw new n("m is required.");if(!t(r))throw new n("n is required.");return(e%r+r)%r},i.equalsEpsilon=function(e,i,o,a){if(!t(e))throw new n("left is required.");if(!t(i))throw new n("right is required.");if(!t(o))throw new n("relativeEpsilon is required.");a=r(a,o);var u=Math.abs(e-i);return a>=u||u<=o*Math.max(Math.abs(e),Math.abs(i))};var o=[1];i.factorial=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");var r=o.length;if(e>=r)for(var t=o[r-1],i=r;e>=i;i++)o.push(t*i);return o[e]},i.incrementWrap=function(e,i,o){if(o=r(o,0),!t(e))throw new n("n is required.");if(o>=i)throw new n("maximumValue must be greater than minimumValue.");return++e,e>i&&(e=o),e},i.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,r,i){if(!t(e))throw new n("value is required");if(!t(r))throw new n("min is required.");if(!t(i))throw new n("max is required.");return r>e?r:e>i?i:e};var a=new e;return i.setRandomNumberSeed=function(r){if(!t(r))throw new n("seed is required.");a=new e(r)},i.nextRandomNumber=function(){return a.random()},i.acosClamped=function(e){if(!t(e))throw new n("value is required.");return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){if(!t(e))throw new n("value is required.");return Math.asin(i.clamp(e,-1,1))},i.chordLength=function(e,r){if(!t(e))throw new n("angle is required.");if(!t(r))throw new n("radius is required.");return 2*r*Math.sin(.5*e)},i}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t){this.x=e(r,0),this.y=e(t,0)};o.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new o(e,t)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t):new o(e.x,e.y):void 0},o.fromCartesian3=o.clone,o.fromCartesian4=o.clone,o.packedLength=2,o.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.x,i[o]=n.y},o.unpack=function(n,i,a){if(!r(n))throw new t("array is required");return i=e(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i],a},o.fromArray=o.unpack,o.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y)},o.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y)},o.minimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i},o.maximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitude(a)},o.distanceSquared=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitudeSquared(a)},o.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=o.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n},o.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y},o.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i},o.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i},o.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i},o.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i},o.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i},o.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n},o.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n};var u=new o;o.lerp=function(e,n,i,a){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(n,i,u),a=o.multiplyByScalar(e,1-i,a),o.add(u,a,a)};var s=new o,f=new o;o.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return o.normalize(e,s),o.normalize(n,f),i.acosClamped(o.dot(s,f))};var h=new o;return o.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=o.normalize(e,h);return o.abs(i,i),n=i.x<=i.y?o.clone(o.UNIT_X,n):o.clone(o.UNIT_Y,n)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},o.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]},o.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)},o.ZERO=n(new o(0,0)),o.UNIT_X=n(new o(1,0)),o.UNIT_Y=n(new o(0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r,t){return o.equalsEpsilon(this,e,r,t)},o.prototype.toString=function(){return"("+this.x+", "+this.y+")"},o}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t,n){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0)};o.fromSpherical=function(n,i){if(!r(n))throw new t("spherical is required");r(i)||(i=new o);var a=n.clock,u=n.cone,s=e(n.magnitude,1),f=s*Math.sin(u);return i.x=f*Math.cos(a),i.y=f*Math.sin(a),i.z=s*Math.cos(u),i},o.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new o(e,t,n)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new o(e.x,e.y,e.z):void 0},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.x,i[o++]=n.y,i[o]=n.z},o.unpack=function(n,i,a){if(!r(n))throw new t("array is required");return i=e(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i],a},o.fromArray=o.unpack,o.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z)},o.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z)},o.minimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i},o.maximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitude(a)},o.distanceSquared=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitudeSquared(a)},o.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=o.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n},o.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z},o.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i},o.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i},o.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i},o.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i},o.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i},o.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n},o.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n};var u=new o;o.lerp=function(e,n,i,a){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(n,i,u),a=o.multiplyByScalar(e,1-i,a),o.add(u,a,a)};var s=new o,f=new o;o.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");o.normalize(e,s),o.normalize(n,f);var i=o.dot(s,f),a=o.magnitude(o.cross(s,f,s));return Math.atan2(a,i)};var h=new o;o.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=o.normalize(e,h);return o.abs(i,i),n=i.x<=i.y?i.x<=i.z?o.clone(o.UNIT_X,n):o.clone(o.UNIT_Z,n):i.y<=i.z?o.clone(o.UNIT_Y,n):o.clone(o.UNIT_Z,n)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},o.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]&&e.z===r[t+2]},o.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)&&i.equalsEpsilon(e.z,t.z,n,o)},o.cross=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");var o=e.x,a=e.y,u=e.z,s=n.x,f=n.y,h=n.z,d=a*h-u*f,c=u*s-o*h,l=o*f-a*s;return i.x=d,i.y=c,i.z=l,i},o.fromDegrees=function(e,n,a,u,s){if(!r(e))throw new t("longitude is required");if(!r(n))throw new t("latitude is required");var f=i.toRadians(e),h=i.toRadians(n);return o.fromRadians(f,h,a,u,s)};var d=new o,c=new o,l=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(n,i,a,u,s){if(!r(n))throw new t("longitude is required");if(!r(i))throw new t("latitude is required");a=e(a,0);var f=r(u)?u.radiiSquared:l,h=Math.cos(i);d.x=h*Math.cos(n),d.y=h*Math.sin(n),d.z=Math.sin(i),d=o.normalize(d,d),o.multiplyComponents(f,d,c);var w=Math.sqrt(o.dot(d,c));return c=o.divideByScalar(c,w,c),d=o.multiplyByScalar(d,a,d),r(s)||(s=new o),o.add(c,d,s)},o.fromDegreesArray=function(e,n,a){if(!r(e))throw new t("positions is required.");for(var u=new Array(e.length),s=0;s<e.length;s++)u[s]=i.toRadians(e[s]);return o.fromRadiansArray(u,n,a)},o.fromRadiansArray=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<2)throw new t("positions length cannot be less than 2.");if(e.length%2!==0)throw new t("positions length must be a multiple of 2.");var a=e.length;r(i)?i.length=a/2:i=new Array(a/2);for(var u=0;a>u;u+=2){var s=e[u],f=e[u+1];i[u/2]=o.fromRadians(s,f,0,n,i[u/2])}return i},o.fromDegreesArrayHeights=function(e,n,a){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(e.length%3!==0)throw new t("positions length must be a multiple of 3.");for(var u=new Array(e.length),s=0;s<e.length;s+=3)u[s]=i.toRadians(e[s]),u[s+1]=i.toRadians(e[s+1]),u[s+2]=e[s+2];return o.fromRadiansArrayHeights(u,n,a)},o.fromRadiansArrayHeights=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(e.length%3!==0)throw new t("positions length must be a multiple of 3.");var a=e.length;r(i)?i.length=a/3:i=new Array(a/3);for(var u=0;a>u;u+=3){var s=e[u],f=e[u+1],h=e[u+2];i[u/3]=o.fromRadians(s,f,h,n,i[u/3])}return i},o.ZERO=n(new o(0,0,0)),o.UNIT_X=n(new o(1,0,0)),o.UNIT_Y=n(new o(0,1,0)),o.UNIT_Z=n(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r,t){return o.equalsEpsilon(this,e,r,t)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,r,t,n,i){"use strict";var o={};o.octEncode=function(e,o){if(!t(e))throw new n("vector is required.");if(!t(o))throw new n("result is required.");var a=r.magnitudeSquared(e);if(Math.abs(a-1)>i.EPSILON6)throw new n("vector must be normalized.");if(o.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),o.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var u=o.x,s=o.y;o.x=(1-Math.abs(s))*i.signNotZero(u),o.y=(1-Math.abs(u))*i.signNotZero(s)}return o.x=i.toSNorm(o.x),o.y=i.toSNorm(o.y),o},o.octDecode=function(e,o,a){if(!t(a))throw new n("result is required.");if(0>e||e>255||0>o||o>255)throw new n("x and y must be a signed normalized integer between 0 and 255");if(a.x=i.fromSNorm(e),a.y=i.fromSNorm(o),a.z=1-(Math.abs(a.x)+Math.abs(a.y)),a.z<0){var u=a.x;a.x=(1-Math.abs(a.y))*i.signNotZero(u),a.y=(1-Math.abs(u))*i.signNotZero(a.y)}return r.normalize(a,a)},o.octPackFloat=function(e){if(!t(e))throw new n("encoded is required.");return 256*e.x+e.y};var a=new e;return o.octEncodeFloat=function(e){return o.octEncode(e,a),o.octPackFloat(a)},o.octDecodeFloat=function(e,r){if(!t(e))throw new n("value is required.");var i=e/256,a=Math.floor(i),u=256*(i-a);return o.octDecode(a,u,r)},o.octPack=function(e,r,i,u){if(!t(e))throw new n("v1 is required.");if(!t(r))throw new n("v2 is required.");if(!t(i))throw new n("v3 is required.");if(!t(u))throw new n("result is required.");var s=o.octEncodeFloat(e),f=o.octEncodeFloat(r),h=o.octEncode(i,a);return u.x=65536*h.x+s,u.y=65536*h.y+f,u},o.octUnpack=function(e,r,i,a){if(!t(e))throw new n("packed is required.");if(!t(r))throw new n("v1 is required.");if(!t(i))throw new n("v2 is required.");if(!t(a))throw new n("v3 is required.");var u=e.x/65536,s=Math.floor(u),f=65536*(u-s);u=e.y/65536;var h=Math.floor(u),d=65536*(u-h);o.octDecodeFloat(f,r),o.octDecodeFloat(d,i),o.octDecode(s,h,a)},o.compressTextureCoordinates=function(e){if(!t(e))throw new n("textureCoordinates is required.");var r=1===e.x?4095:4096*e.x|0,i=1===e.y?4095:4096*e.y|0;return 4096*r+i},o.decompressTextureCoordinates=function(e,r){if(!t(e))throw new n("compressed is required.");if(!t(r))throw new n("result is required.");var i=e/4096;return r.x=Math.floor(i)/4096,r.y=i-Math.floor(i),r},o}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t,n){this.longitude=e(r,0),this.latitude=e(t,0),this.height=e(n,0)};return o.fromRadians=function(n,i,a,u){if(!r(n))throw new t("longitude is required.");if(!r(i))throw new t("latitude is required.");return a=e(a,0),r(u)?(u.longitude=n,u.latitude=i,u.height=a,u):new o(n,i,a)},o.fromDegrees=function(e,n,a,u){if(!r(e))throw new t("longitude is required.");if(!r(n))throw new t("latitude is required.");return e=i.toRadians(e),n=i.toRadians(n),o.fromRadians(e,n,a,u)},o.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new o(e.longitude,e.latitude,e.height):void 0},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},o.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.longitude-n.longitude)<=i&&Math.abs(e.latitude-n.latitude)<=i&&Math.abs(e.height-n.height)<=i},o.ZERO=n(new o(0,0,0)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r){return o.equalsEpsilon(this,e,r)},o.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},o}),define("Core/deprecationWarning",["./defined","./DeveloperError"],function(e,r){"use strict";var t={},n=function(n,i){if(!e(n)||!e(i))throw new r("identifier and message are required.");e(t[n])||(t[n]=!0,console.log(i))};return n}),define("Core/defineProperties",["./defined"],function(e){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),t=Object.defineProperties;return r&&e(t)||(t=function(e){return e}),t}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,o,a,u){"use strict";function s(r,n,i,a){if(n=t(n,0),i=t(i,0),a=t(a,0),0>n||0>i||0>a)throw new o("All radii components must be greater than or equal to zero.");r._radii=new e(n,i,a),r._radiiSquared=new e(n*n,i*i,a*a),r._radiiToTheFourth=new e(n*n*n*n,i*i*i*i,a*a*a*a),r._oneOverRadii=new e(0===n?0:1/n,0===i?0:1/i,0===a?0:1/a),r._oneOverRadiiSquared=new e(0===n?0:1/(n*n),0===i?0:1/(i*i),0===a?0:1/(a*a)),r._minimumRadius=Math.min(n,i,a),r._maximumRadius=Math.max(n,i,a),r._centerToleranceSquared=u.EPSILON1}var f=function(e,r,t){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,s(this,e,r,t)};i(f.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),f.clone=function(r,t){if(!n(r))return void 0;var i=r._radii;return n(t)?(e.clone(i,t._radii),e.clone(r._radiiSquared,t._radiiSquared),e.clone(r._radiiToTheFourth,t._radiiToTheFourth),e.clone(r._oneOverRadii,t._oneOverRadii),e.clone(r._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=r._minimumRadius,t._maximumRadius=r._maximumRadius,t._centerToleranceSquared=r._centerToleranceSquared,t):new f(i.x,i.y,i.z)},f.fromCartesian3=function(e,r){return n(r)||(r=new f),n(e)?(s(r,e.x,e.y,e.z),r):r},f.WGS84=a(new f(6378137,6378137,6356752.314245179)),f.UNIT_SPHERE=a(new f(1,1,1)),f.MOON=a(new f(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),f.prototype.clone=function(e){return f.clone(this,e)},f.packedLength=e.packedLength,f.pack=function(r,i,a){if(!n(r))throw new o("value is required");if(!n(i))throw new o("array is required");a=t(a,0),e.pack(r._radii,i,a)},f.unpack=function(r,i,a){if(!n(r))throw new o("array is required");i=t(i,0);var u=e.unpack(r,i);return f.fromCartesian3(u,a)},f.prototype.geocentricSurfaceNormal=e.normalize,f.prototype.geodeticSurfaceNormalCartographic=function(r,t){if(!n(r))throw new o("cartographic is required.");var i=r.longitude,a=r.latitude,u=Math.cos(a),s=u*Math.cos(i),f=u*Math.sin(i),h=Math.sin(a);return n(t)||(t=new e),t.x=s,t.y=f,t.z=h,e.normalize(t,t)},f.prototype.geodeticSurfaceNormal=function(r,t){return n(t)||(t=new e),t=e.multiplyComponents(r,this._oneOverRadiiSquared,t),e.normalize(t,t)};var h=new e,d=new e;f.prototype.cartographicToCartesian=function(r,t){var i=h,o=d;this.geodeticSurfaceNormalCartographic(r,i),e.multiplyComponents(this._radiiSquared,i,o);var a=Math.sqrt(e.dot(i,o));return e.divideByScalar(o,a,o),e.multiplyByScalar(i,r.height,i),n(t)||(t=new e),e.add(o,i,t)},f.prototype.cartographicArrayToCartesianArray=function(e,r){if(!n(e))throw new o("cartographics is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;i++)r[i]=this.cartographicToCartesian(e[i],r[i]);return r};var c=new e,l=new e,w=new e;f.prototype.cartesianToCartographic=function(t,i){var o=this.scaleToGeodeticSurface(t,l);if(!n(o))return void 0;var a=this.geodeticSurfaceNormal(o,c),s=e.subtract(t,o,w),f=Math.atan2(a.y,a.x),h=Math.asin(a.z),d=u.sign(e.dot(s,t))*e.magnitude(s);return n(i)?(i.longitude=f,i.latitude=h,i.height=d,i):new r(f,h,d)},f.prototype.cartesianArrayToCartographicArray=function(e,r){if(!n(e))throw new o("cartesians is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;++i)r[i]=this.cartesianToCartographic(e[i],r[i]);return r};var m=new e,E=new e;return f.prototype.scaleToGeodeticSurface=function(r,t){if(!n(r))throw new o("cartesian is required.");var i=r.x,a=r.y,s=r.z,f=this._oneOverRadii,h=f.x,d=f.y,c=f.z,l=i*i*h*h,w=a*a*d*d,p=s*s*c*c,_=l+w+p,y=Math.sqrt(1/_),R=e.multiplyByScalar(r,y,m);if(_<this._centerToleranceSquared)return isFinite(y)?e.clone(R,t):void 0;var T=this._oneOverRadiiSquared,A=T.x,S=T.y,v=T.z,N=E;N.x=R.x*A*2,N.y=R.y*S*2,N.z=R.z*v*2;var q,g,M,I,O,x,C,P,U,b,D,L=(1-y)*e.magnitude(r)/(.5*e.magnitude(N)),F=0;do{L-=F,M=1/(1+L*A),I=1/(1+L*S),O=1/(1+L*v),x=M*M,C=I*I,P=O*O,U=x*M,b=C*I,D=P*O,q=l*x+w*C+p*P-1,g=l*U*A+w*b*S+p*D*v;var B=-2*g;F=q/B}while(Math.abs(q)>u.EPSILON12);return n(t)?(t.x=i*M,t.y=a*I,t.z=s*O,t):new e(i*M,a*I,s*O)},f.prototype.scaleToGeocentricSurface=function(r,t){if(!n(r))throw new o("cartesian is required.");n(t)||(t=new e);var i=r.x,a=r.y,u=r.z,s=this._oneOverRadiiSquared,f=1/Math.sqrt(i*i*s.x+a*a*s.y+u*u*s.z);return e.multiplyByScalar(r,f,t)},f.prototype.transformPositionToScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._oneOverRadii,t)},f.prototype.transformPositionFromScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._radii,t)},f.prototype.equals=function(r){return this===r||n(r)&&e.equals(this._radii,r._radii)},f.prototype.toString=function(){return this._radii.toString()},f}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,r,t,n,i,o,a){"use strict";var u=function(e){this._ellipsoid=t(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(r,t){var i=this._semimajorAxis,o=r.longitude*i,a=r.latitude*i,u=r.height;return n(t)?(t.x=o,t.y=a,t.z=u,t):new e(o,a,u)},u.prototype.unproject=function(e,t){if(!n(e))throw new o("cartesian is required");var i=this._oneOverSemimajorAxis,a=e.x*i,u=e.y*i,s=e.z;return n(t)?(t.longitude=a,t.latitude=u,t.height=s,t):new r(a,u,s)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var r={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(r)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var r=function(r,t){this.start=e(r,0),this.stop=e(t,0)};return r}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t,n,i){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0),this.w=e(i,0)};o.fromElements=function(e,t,n,i,a){return r(a)?(a.x=e,a.y=t,a.z=n,a.w=i,a):new o(e,t,n,i)},o.fromColor=function(e,n){if(!r(e))throw new t("color is required");return r(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new o(e.red,e.green,e.blue,e.alpha)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new o(e.x,e.y,e.z,e.w):void 0},o.packedLength=4,o.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.x,i[o++]=n.y,i[o++]=n.z,i[o]=n.w},o.unpack=function(n,i,a){if(!r(n))throw new t("array is required");return i=e(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i++],a.w=n[i],a},o.fromArray=o.unpack,o.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z,e.w)},o.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z,e.w)},o.minimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i.w=Math.min(e.w,n.w),i},o.maximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i.w=Math.max(e.w,n.w),i},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitude(a)},o.distanceSquared=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitudeSquared(a)},o.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=o.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n.w=e.w/i,n},o.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z+e.w*n.w},o.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i.w=e.w*n.w,i},o.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i.w=e.w+n.w,i},o.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i.w=e.w-n.w,i},o.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i.w=e.w*n,i},o.divideByScalar=function(e,n,i){
if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i.w=e.w/n,i},o.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n.w=-e.w,n},o.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n.w=Math.abs(e.w),n};var u=new o;o.lerp=function(e,n,i,a){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(n,i,u),a=o.multiplyByScalar(e,1-i,a),o.add(u,a,a)};var s=new o;return o.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=o.normalize(e,s);return o.abs(i,i),n=i.x<=i.y?i.x<=i.z?i.x<=i.w?o.clone(o.UNIT_X,n):o.clone(o.UNIT_W,n):i.z<=i.w?o.clone(o.UNIT_Z,n):o.clone(o.UNIT_W,n):i.y<=i.z?i.y<=i.w?o.clone(o.UNIT_Y,n):o.clone(o.UNIT_W,n):i.z<=i.w?o.clone(o.UNIT_Z,n):o.clone(o.UNIT_W,n)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},o.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]&&e.z===r[t+2]&&e.w===r[t+3]},o.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)&&i.equalsEpsilon(e.z,t.z,n,o)&&i.equalsEpsilon(e.w,t.w,n,o)},o.ZERO=n(new o(0,0,0,0)),o.UNIT_X=n(new o(1,0,0,0)),o.UNIT_Y=n(new o(0,1,0,0)),o.UNIT_Z=n(new o(0,0,1,0)),o.UNIT_W=n(new o(0,0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r,t){return o.equalsEpsilon(this,e,r,t)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},o}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,o){"use strict";function a(e){for(var r=0,t=0;9>t;++t){var n=e[t];r+=n*n}return Math.sqrt(r)}function u(e){for(var r=0,t=0;3>t;++t){var n=e[f.getElementIndex(l[t],c[t])];r+=2*n*n}return Math.sqrt(r)}function s(e,r){for(var t=o.EPSILON15,n=0,i=1,a=0;3>a;++a){var u=Math.abs(e[f.getElementIndex(l[a],c[a])]);u>n&&(i=a,n=u)}var s=1,h=0,d=c[i],w=l[i];if(Math.abs(e[f.getElementIndex(w,d)])>t){var m,E=e[f.getElementIndex(w,w)],p=e[f.getElementIndex(d,d)],_=e[f.getElementIndex(w,d)],y=(E-p)/2/_;m=0>y?-1/(-y+Math.sqrt(1+y*y)):1/(y+Math.sqrt(1+y*y)),s=1/Math.sqrt(1+m*m),h=m*s}return r=f.clone(f.IDENTITY,r),r[f.getElementIndex(d,d)]=r[f.getElementIndex(w,w)]=s,r[f.getElementIndex(w,d)]=h,r[f.getElementIndex(d,w)]=-h,r}var f=function(e,t,n,i,o,a,u,s,f){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(o,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(a,0),this[8]=r(f,0)};f.packedLength=9,f.pack=function(e,i,o){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");o=r(o,0),i[o++]=e[0],i[o++]=e[1],i[o++]=e[2],i[o++]=e[3],i[o++]=e[4],i[o++]=e[5],i[o++]=e[6],i[o++]=e[7],i[o++]=e[8]},f.unpack=function(e,i,o){if(!t(e))throw new n("array is required");return i=r(i,0),t(o)||(o=new f),o[0]=e[i++],o[1]=e[i++],o[2]=e[i++],o[3]=e[i++],o[4]=e[i++],o[5]=e[i++],o[6]=e[i++],o[7]=e[i++],o[8]=e[i++],o},f.clone=function(e,r){return t(e)?t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):new f(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},f.fromArray=function(e,i,o){if(!t(e))throw new n("array is required");return i=r(i,0),t(o)||(o=new f),o[0]=e[i],o[1]=e[i+1],o[2]=e[i+2],o[3]=e[i+3],o[4]=e[i+4],o[5]=e[i+5],o[6]=e[i+6],o[7]=e[i+7],o[8]=e[i+8],o},f.fromColumnMajorArray=function(e,r){if(!t(e))throw new n("values parameter is required");return f.clone(e,r)},f.fromRowMajorArray=function(e,r){if(!t(e))throw new n("values is required.");return t(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},f.fromQuaternion=function(e,r){if(!t(e))throw new n("quaternion is required");var i=e.x*e.x,o=e.x*e.y,a=e.x*e.z,u=e.x*e.w,s=e.y*e.y,h=e.y*e.z,d=e.y*e.w,c=e.z*e.z,l=e.z*e.w,w=e.w*e.w,m=i-s-c+w,E=2*(o-l),p=2*(a+d),_=2*(o+l),y=-i+s-c+w,R=2*(h-u),T=2*(a-d),A=2*(h+u),S=-i-s+c+w;return t(r)?(r[0]=m,r[1]=_,r[2]=T,r[3]=E,r[4]=y,r[5]=A,r[6]=p,r[7]=R,r[8]=S,r):new f(m,E,p,_,y,R,T,A,S)},f.fromScale=function(e,r){if(!t(e))throw new n("scale is required.");return t(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new f(e.x,0,0,0,e.y,0,0,0,e.z)},f.fromUniformScale=function(e,r){if("number"!=typeof e)throw new n("scale is required.");return t(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new f(e,0,0,0,e,0,0,0,e)},f.fromCrossProduct=function(e,r){if(!t(e))throw new n("vector is required.");return t(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new f(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},f.fromRotationX=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=o,r[6]=0,r[7]=-o,r[8]=i,r):new f(1,0,0,0,i,-o,0,o,i)},f.fromRotationY=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=i,r[1]=0,r[2]=-o,r[3]=0,r[4]=1,r[5]=0,r[6]=o,r[7]=0,r[8]=i,r):new f(i,0,o,0,1,0,-o,0,i)},f.fromRotationZ=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=i,r[1]=o,r[2]=0,r[3]=-o,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new f(i,-o,0,o,i,0,0,0,1)},f.toArray=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},f.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>2)throw new n("row must be 0, 1, or 2.");if("number"!=typeof e||0>e||e>2)throw new n("column must be 0, 1, or 2.");return 3*e+r},f.getColumn=function(e,r,i){if(!t(e))throw new n("matrix is required.");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(i))throw new n("result is required");var o=3*r,a=e[o],u=e[o+1],s=e[o+2];return i.x=a,i.y=u,i.z=s,i},f.setColumn=function(e,r,i,o){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(o))throw new n("result is required");o=f.clone(e,o);var a=3*r;return o[a]=i.x,o[a+1]=i.y,o[a+2]=i.z,o},f.getRow=function(e,r,i){if(!t(e))throw new n("matrix is required.");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(i))throw new n("result is required");var o=e[r],a=e[r+3],u=e[r+6];return i.x=o,i.y=a,i.z=u,i},f.setRow=function(e,r,i,o){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(o))throw new n("result is required");return o=f.clone(e,o),o[r]=i.x,o[r+3]=i.y,o[r+6]=i.z,o};var h=new e;f.getScale=function(r,i){if(!t(r))throw new n("matrix is required.");if(!t(i))throw new n("result is required");return i.x=e.magnitude(e.fromElements(r[0],r[1],r[2],h)),i.y=e.magnitude(e.fromElements(r[3],r[4],r[5],h)),i.z=e.magnitude(e.fromElements(r[6],r[7],r[8],h)),i};var d=new e;f.getMaximumScale=function(r){return f.getScale(r,d),e.maximumComponent(d)},f.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");var o=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],a=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],u=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],s=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],f=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],h=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],d=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],c=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],l=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return i[0]=o,i[1]=a,i[2]=u,i[3]=s,i[4]=f,i[5]=h,i[6]=d,i[7]=c,i[8]=l,i},f.add=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i[0]=e[0]+r[0],i[1]=e[1]+r[1],i[2]=e[2]+r[2],i[3]=e[3]+r[3],i[4]=e[4]+r[4],i[5]=e[5]+r[5],i[6]=e[6]+r[6],i[7]=e[7]+r[7],i[8]=e[8]+r[8],i},f.subtract=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],i[3]=e[3]-r[3],i[4]=e[4]-r[4],i[5]=e[5]-r[5],i[6]=e[6]-r[6],i[7]=e[7]-r[7],i[8]=e[8]-r[8],i},f.multiplyByVector=function(e,r,i){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("cartesian is required");if(!t(i))throw new n("result is required");var o=r.x,a=r.y,u=r.z,s=e[0]*o+e[3]*a+e[6]*u,f=e[1]*o+e[4]*a+e[7]*u,h=e[2]*o+e[5]*a+e[8]*u;return i.x=s,i.y=f,i.z=h,i},f.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scalar must be a number");if(!t(i))throw new n("result is required");return i[0]=e[0]*r,i[1]=e[1]*r,i[2]=e[2]*r,i[3]=e[3]*r,i[4]=e[4]*r,i[5]=e[5]*r,i[6]=e[6]*r,i[7]=e[7]*r,i[8]=e[8]*r,i},f.multiplyByScale=function(e,r,i){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("scale is required");if(!t(i))throw new n("result is required");return i[0]=e[0]*r.x,i[1]=e[1]*r.x,i[2]=e[2]*r.x,i[3]=e[3]*r.y,i[4]=e[4]*r.y,i[5]=e[5]*r.y,i[6]=e[6]*r.z,i[7]=e[7]*r.z,i[8]=e[8]*r.z,i},f.negate=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");return r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},f.transpose=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");var i=e[0],o=e[3],a=e[6],u=e[1],s=e[4],f=e[7],h=e[2],d=e[5],c=e[8];return r[0]=i,r[1]=o,r[2]=a,r[3]=u,r[4]=s,r[5]=f,r[6]=h,r[7]=d,r[8]=c,r};var c=[1,0,0],l=[2,2,1],w=new f,m=new f;return f.computeEigenDecomposition=function(e,r){if(!t(e))throw new n("matrix is required.");var i=o.EPSILON20,h=10,d=0,c=0;t(r)||(r={});for(var l=r.unitary=f.clone(f.IDENTITY,r.unitary),E=r.diagonal=f.clone(e,r.diagonal),p=i*a(E);h>c&&u(E)>p;)s(E,w),f.transpose(w,m),f.multiply(E,w,E),f.multiply(m,E,E),f.multiply(l,w,l),++d>2&&(++c,d=0);return r},f.abs=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");return r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},f.determinant=function(e){if(!t(e))throw new n("matrix is required");var r=e[0],i=e[3],o=e[6],a=e[1],u=e[4],s=e[7],f=e[2],h=e[5],d=e[8];return r*(u*d-h*s)+a*(h*o-i*d)+f*(i*s-u*o)},f.inverse=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");var i=e[0],a=e[1],u=e[2],s=e[3],h=e[4],d=e[5],c=e[6],l=e[7],w=e[8],m=f.determinant(e);if(Math.abs(m)<=o.EPSILON15)throw new n("matrix is not invertible");r[0]=h*w-l*d,r[1]=l*u-a*w,r[2]=a*d-h*u,r[3]=c*d-s*w,r[4]=i*w-c*u,r[5]=s*u-i*d,r[6]=s*l-c*h,r[7]=c*a-i*l,r[8]=i*h-s*a;var E=1/m;return f.multiplyByScalar(r,E,r)},f.equals=function(e,r){return e===r||t(e)&&t(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]},f.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon must be a number");return e===r||t(e)&&t(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},f.IDENTITY=i(new f(1,0,0,0,1,0,0,0,1)),f.ZERO=i(new f(0,0,0,0,0,0,0,0,0)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN1ROW0=3,f.COLUMN1ROW1=4,f.COLUMN1ROW2=5,f.COLUMN2ROW0=6,f.COLUMN2ROW1=7,f.COLUMN2ROW2=8,f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.equalsArray=function(e,r,t){return e[0]===r[t]&&e[1]===r[t+1]&&e[2]===r[t+2]&&e[3]===r[t+3]&&e[4]===r[t+4]&&e[5]===r[t+5]&&e[6]===r[t+6]&&e[7]===r[t+7]&&e[8]===r[t+8]},f.prototype.equalsEpsilon=function(e,r){return f.equalsEpsilon(this,e,r)},f.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},f}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var r=function(e){this.name="RuntimeError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,r,t,n,i,o,a,u,s){"use strict";var f=function(e,r,n,i,o,a,u,s,f,h,d,c,l,w,m,E){this[0]=t(e,0),this[1]=t(o,0),this[2]=t(f,0),this[3]=t(l,0),this[4]=t(r,0),this[5]=t(a,0),this[6]=t(h,0),this[7]=t(w,0),this[8]=t(n,0),this[9]=t(u,0),this[10]=t(d,0),this[11]=t(m,0),this[12]=t(i,0),this[13]=t(s,0),this[14]=t(c,0),this[15]=t(E,0)};f.packedLength=16,f.pack=function(e,r,o){if(!n(e))throw new i("value is required");if(!n(r))throw new i("array is required");o=t(o,0),r[o++]=e[0],r[o++]=e[1],r[o++]=e[2],r[o++]=e[3],r[o++]=e[4],r[o++]=e[5],r[o++]=e[6],r[o++]=e[7],r[o++]=e[8],r[o++]=e[9],r[o++]=e[10],r[o++]=e[11],r[o++]=e[12],r[o++]=e[13],r[o++]=e[14],r[o]=e[15]},f.unpack=function(e,r,o){if(!n(e))throw new i("array is required");return r=t(r,0),n(o)||(o=new f),o[0]=e[r++],o[1]=e[r++],o[2]=e[r++],o[3]=e[r++],o[4]=e[r++],o[5]=e[r++],o[6]=e[r++],o[7]=e[r++],o[8]=e[r++],o[9]=e[r++],o[10]=e[r++],o[11]=e[r++],o[12]=e[r++],o[13]=e[r++],o[14]=e[r++],o[15]=e[r],o},f.clone=function(e,r){return n(e)?n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):new f(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},f.fromArray=f.unpack,f.fromColumnMajorArray=function(e,r){if(!n(e))throw new i("values is required");return f.clone(e,r)},f.fromRowMajorArray=function(e,r){if(!n(e))throw new i("values is required.");return n(r)?(r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=e[1],r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=e[2],r[9]=e[6],r[10]=e[10],r[11]=e[14],r[12]=e[3],r[13]=e[7],r[14]=e[11],r[15]=e[15],r):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},f.fromRotationTranslation=function(r,o,a){if(!n(r))throw new i("rotation is required.");return o=t(o,e.ZERO),n(a)?(a[0]=r[0],a[1]=r[1],a[2]=r[2],a[3]=0,a[4]=r[3],a[5]=r[4],a[6]=r[5],a[7]=0,a[8]=r[6],a[9]=r[7],a[10]=r[8],a[11]=0,a[12]=o.x,a[13]=o.y,a[14]=o.z,a[15]=1,a):new f(r[0],r[3],r[6],o.x,r[1],r[4],r[7],o.y,r[2],r[5],r[8],o.z,0,0,0,1)},f.fromTranslationQuaternionRotationScale=function(e,r,t,o){if(!n(e))throw new i("translation is required.");if(!n(r))throw new i("rotation is required.");if(!n(t))throw new i("scale is required.");n(o)||(o=new f);var a=t.x,u=t.y,s=t.z,h=r.x*r.x,d=r.x*r.y,c=r.x*r.z,l=r.x*r.w,w=r.y*r.y,m=r.y*r.z,E=r.y*r.w,p=r.z*r.z,_=r.z*r.w,y=r.w*r.w,R=h-w-p+y,T=2*(d-_),A=2*(c+E),S=2*(d+_),v=-h+w-p+y,N=2*(m-l),q=2*(c-E),g=2*(m+l),M=-h-w+p+y;return o[0]=R*a,o[1]=S*a,o[2]=q*a,o[3]=0,o[4]=T*u,o[5]=v*u,o[6]=g*u,o[7]=0,o[8]=A*s,o[9]=N*s,o[10]=M*s,o[11]=0,o[12]=e.x,o[13]=e.y,o[14]=e.z,o[15]=1,o},f.fromTranslation=function(e,r){if(!n(e))throw new i("translation is required.");return f.fromRotationTranslation(u.IDENTITY,e,r)},f.fromScale=function(e,r){if(!n(e))throw new i("scale is required.");return n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e.y,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e.z,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new f(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},f.fromUniformScale=function(e,r){if("number"!=typeof e)throw new i("scale is required.");return n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new f(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var h=new e,d=new e,c=new e;f.fromCamera=function(r,t){if(!n(r))throw new i("camera is required.");var o=r.eye,a=r.target,u=r.up;if(!n(o))throw new i("camera.eye is required.");if(!n(a))throw new i("camera.target is required.");if(!n(u))throw new i("camera.up is required.");e.normalize(e.subtract(a,o,h),h),e.normalize(e.cross(h,u,d),d),e.normalize(e.cross(d,h,c),c);var s=d.x,l=d.y,w=d.z,m=h.x,E=h.y,p=h.z,_=c.x,y=c.y,R=c.z,T=o.x,A=o.y,S=o.z,v=s*-T+l*-A+w*-S,N=_*-T+y*-A+R*-S,q=m*T+E*A+p*S;return n(t)?(t[0]=s,t[1]=_,t[2]=-m,t[3]=0,t[4]=l,t[5]=y,t[6]=-E,t[7]=0,t[8]=w,t[9]=R,t[10]=-p,t[11]=0,t[12]=v,t[13]=N,t[14]=q,t[15]=1,t):new f(s,l,w,v,_,y,R,N,-m,-E,-p,q,0,0,0,1)},f.computePerspectiveFieldOfView=function(e,r,t,o,a){if(0>=e||e>Math.PI)throw new i("fovY must be in [0, PI).");if(0>=r)throw new i("aspectRatio must be greater than zero.");if(0>=t)throw new i("near must be greater than zero.");if(0>=o)throw new i("far must be greater than zero.");if(!n(a))throw new i("result is required");var u=Math.tan(.5*e),s=1/u,f=s/r,h=(o+t)/(t-o),d=2*o*t/(t-o);return a[0]=f,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=s,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=h,a[11]=-1,a[12]=0,a[13]=0,a[14]=d,a[15]=0,a},f.computeOrthographicOffCenter=function(e,r,t,o,a,u,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(o))throw new i("top is required.");if(!n(a))throw new i("near is required.");if(!n(u))throw new i("far is required.");if(!n(s))throw new i("result is required");var f=1/(r-e),h=1/(o-t),d=1/(u-a),c=-(r+e)*f,l=-(o+t)*h,w=-(u+a)*d;return f*=2,h*=2,d*=-2,s[0]=f,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=h,s[6]=0,s[7]=0,s[8]=0,s[9]=0,s[10]=d,s[11]=0,s[12]=c,s[13]=l,s[14]=w,s[15]=1,s},f.computePerspectiveOffCenter=function(e,r,t,o,a,u,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(o))throw new i("top is required.");if(!n(a))throw new i("near is required.");if(!n(u))throw new i("far is required.");if(!n(s))throw new i("result is required");var f=2*a/(r-e),h=2*a/(o-t),d=(r+e)/(r-e),c=(o+t)/(o-t),l=-(u+a)/(u-a),w=-1,m=-2*u*a/(u-a);return s[0]=f,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=h,s[6]=0,s[7]=0,s[8]=d,s[9]=c,s[10]=l,s[11]=w,s[12]=0,s[13]=0,s[14]=m,s[15]=0,s},f.computeInfinitePerspectiveOffCenter=function(e,r,t,o,a,u){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(o))throw new i("top is required.");if(!n(a))throw new i("near is required.");if(!n(u))throw new i("result is required");var s=2*a/(r-e),f=2*a/(o-t),h=(r+e)/(r-e),d=(o+t)/(o-t),c=-1,l=-1,w=-2*a;return u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=f,u[6]=0,u[7]=0,u[8]=h,u[9]=d,u[10]=c,u[11]=l,u[12]=0,u[13]=0,u[14]=w,u[15]=0,u},f.computeViewportTransformation=function(e,r,o,a){if(!n(a))throw new i("result is required");e=t(e,t.EMPTY_OBJECT);var u=t(e.x,0),s=t(e.y,0),f=t(e.width,0),h=t(e.height,0);r=t(r,0),o=t(o,1);var d=.5*f,c=.5*h,l=.5*(o-r),w=d,m=c,E=l,p=u+d,_=s+c,y=r+l,R=1;return a[0]=w,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=m,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=E,a[11]=0,a[12]=p,a[13]=_,a[14]=y,a[15]=R,a},f.toArray=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},f.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>3)throw new i("row must be 0, 1, 2, or 3.");if("number"!=typeof e||0>e||e>3)throw new i("column must be 0, 1, 2, or 3.");return 4*e+r},f.getColumn=function(e,r,t){if(!n(e))throw new i("matrix is required.");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(t))throw new i("result is required");var o=4*r,a=e[o],u=e[o+1],s=e[o+2],f=e[o+3];return t.x=a,t.y=u,t.z=s,t.w=f,t},f.setColumn=function(e,r,t,o){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(o))throw new i("result is required");o=f.clone(e,o);var a=4*r;return o[a]=t.x,o[a+1]=t.y,o[a+2]=t.z,o[a+3]=t.w,o},f.setTranslation=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("translation is required");if(!n(t))throw new i("result is required");return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=r.x,t[13]=r.y,t[14]=r.z,t[15]=e[15],t},f.getRow=function(e,r,t){if(!n(e))throw new i("matrix is required.");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(t))throw new i("result is required");var o=e[r],a=e[r+4],u=e[r+8],s=e[r+12];return t.x=o,t.y=a,t.z=u,t.w=s,t},f.setRow=function(e,r,t,o){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(o))throw new i("result is required");return o=f.clone(e,o),o[r]=t.x,o[r+4]=t.y,o[r+8]=t.z,o[r+12]=t.w,o};var l=new e;f.getScale=function(r,t){if(!n(r))throw new i("matrix is required.");if(!n(t))throw new i("result is required");return t.x=e.magnitude(e.fromElements(r[0],r[1],r[2],l)),t.y=e.magnitude(e.fromElements(r[4],r[5],r[6],l)),t.z=e.magnitude(e.fromElements(r[8],r[9],r[10],l)),t};var w=new e;f.getMaximumScale=function(r){return f.getScale(r,w),e.maximumComponent(w)},f.multiply=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");var o=e[0],a=e[1],u=e[2],s=e[3],f=e[4],h=e[5],d=e[6],c=e[7],l=e[8],w=e[9],m=e[10],E=e[11],p=e[12],_=e[13],y=e[14],R=e[15],T=r[0],A=r[1],S=r[2],v=r[3],N=r[4],q=r[5],g=r[6],M=r[7],I=r[8],O=r[9],x=r[10],C=r[11],P=r[12],U=r[13],b=r[14],D=r[15],L=o*T+f*A+l*S+p*v,F=a*T+h*A+w*S+_*v,B=u*T+d*A+m*S+y*v,z=s*T+c*A+E*S+R*v,G=o*N+f*q+l*g+p*M,W=a*N+h*q+w*g+_*M,X=u*N+d*q+m*g+y*M,V=s*N+c*q+E*g+R*M,H=o*I+f*O+l*x+p*C,Y=a*I+h*O+w*x+_*C,Z=u*I+d*O+m*x+y*C,j=s*I+c*O+E*x+R*C,k=o*P+f*U+l*b+p*D,K=a*P+h*U+w*b+_*D,J=u*P+d*U+m*b+y*D,Q=s*P+c*U+E*b+R*D;return t[0]=L,t[1]=F,t[2]=B,t[3]=z,t[4]=G,t[5]=W,t[6]=X,t[7]=V,t[8]=H,t[9]=Y,t[10]=Z,t[11]=j,t[12]=k,t[13]=K,t[14]=J,t[15]=Q,t},f.add=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t[6]=e[6]+r[6],t[7]=e[7]+r[7],t[8]=e[8]+r[8],t[9]=e[9]+r[9],t[10]=e[10]+r[10],t[11]=e[11]+r[11],t[12]=e[12]+r[12],t[13]=e[13]+r[13],t[14]=e[14]+r[14],t[15]=e[15]+r[15],t},f.subtract=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t[4]=e[4]-r[4],t[5]=e[5]-r[5],t[6]=e[6]-r[6],t[7]=e[7]-r[7],t[8]=e[8]-r[8],t[9]=e[9]-r[9],t[10]=e[10]-r[10],t[11]=e[11]-r[11],t[12]=e[12]-r[12],t[13]=e[13]-r[13],t[14]=e[14]-r[14],t[15]=e[15]-r[15],t},f.multiplyTransformation=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");var o=e[0],a=e[1],u=e[2],s=e[4],f=e[5],h=e[6],d=e[8],c=e[9],l=e[10],w=e[12],m=e[13],E=e[14],p=r[0],_=r[1],y=r[2],R=r[4],T=r[5],A=r[6],S=r[8],v=r[9],N=r[10],q=r[12],g=r[13],M=r[14],I=o*p+s*_+d*y,O=a*p+f*_+c*y,x=u*p+h*_+l*y,C=o*R+s*T+d*A,P=a*R+f*T+c*A,U=u*R+h*T+l*A,b=o*S+s*v+d*N,D=a*S+f*v+c*N,L=u*S+h*v+l*N,F=o*q+s*g+d*M+w,B=a*q+f*g+c*M+m,z=u*q+h*g+l*M+E;return t[0]=I,t[1]=O,t[2]=x,t[3]=0,t[4]=C,t[5]=P,t[6]=U,t[7]=0,t[8]=b,t[9]=D,t[10]=L,t[11]=0,t[12]=F,t[13]=B,t[14]=z,t[15]=1,t},f.multiplyByMatrix3=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("rotation is required");if(!n(t))throw new i("result is required");var o=e[0],a=e[1],u=e[2],s=e[4],f=e[5],h=e[6],d=e[8],c=e[9],l=e[10],w=r[0],m=r[1],E=r[2],p=r[3],_=r[4],y=r[5],R=r[6],T=r[7],A=r[8],S=o*w+s*m+d*E,v=a*w+f*m+c*E,N=u*w+h*m+l*E,q=o*p+s*_+d*y,g=a*p+f*_+c*y,M=u*p+h*_+l*y,I=o*R+s*T+d*A,O=a*R+f*T+c*A,x=u*R+h*T+l*A;return t[0]=S,t[1]=v,t[2]=N,t[3]=0,t[4]=q,t[5]=g,t[6]=M,t[7]=0,t[8]=I,t[9]=O,t[10]=x,t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},f.multiplyByTranslation=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("translation is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,u=r.z,s=o*e[0]+a*e[4]+u*e[8]+e[12],f=o*e[1]+a*e[5]+u*e[9]+e[13],h=o*e[2]+a*e[6]+u*e[10]+e[14];return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=s,t[13]=f,t[14]=h,t[15]=e[15],t};var m=new e;f.multiplyByUniformScale=function(e,r,t){if(!n(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scale is required");if(!n(t))throw new i("result is required");return m.x=r,m.y=r,m.z=r,f.multiplyByScale(e,m,t)},f.multiplyByScale=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("scale is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,u=r.z;return 1===o&&1===a&&1===u?f.clone(e,t):(t[0]=o*e[0],t[1]=o*e[1],t[2]=o*e[2],t[3]=0,t[4]=a*e[4],t[5]=a*e[5],t[6]=a*e[6],t[7]=0,t[8]=u*e[8],t[9]=u*e[9],t[10]=u*e[10],t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=1,t)},f.multiplyByVector=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,u=r.z,s=r.w,f=e[0]*o+e[4]*a+e[8]*u+e[12]*s,h=e[1]*o+e[5]*a+e[9]*u+e[13]*s,d=e[2]*o+e[6]*a+e[10]*u+e[14]*s,c=e[3]*o+e[7]*a+e[11]*u+e[15]*s;return t.x=f,t.y=h,t.z=d,t.w=c,t},f.multiplyByPointAsVector=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,u=r.z,s=e[0]*o+e[4]*a+e[8]*u,f=e[1]*o+e[5]*a+e[9]*u,h=e[2]*o+e[6]*a+e[10]*u;return t.x=s,t.y=f,t.z=h,t},f.multiplyByPoint=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,u=r.z,s=e[0]*o+e[4]*a+e[8]*u+e[12],f=e[1]*o+e[5]*a+e[9]*u+e[13],h=e[2]*o+e[6]*a+e[10]*u+e[14];return t.x=s,t.y=f,t.z=h,t},f.multiplyByScalar=function(e,r,t){if(!n(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scalar must be a number");if(!n(t))throw new i("result is required");return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t},f.negate=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r[9]=-e[9],r[10]=-e[10],r[11]=-e[11],r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=-e[15],r},f.transpose=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");var t=e[1],o=e[2],a=e[3],u=e[6],s=e[7],f=e[11];return r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=t,r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=o,r[9]=u,r[10]=e[10],r[11]=e[14],r[12]=a,r[13]=s,r[14]=f,r[15]=e[15],r},f.abs=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r[9]=Math.abs(e[9]),r[10]=Math.abs(e[10]),r[11]=Math.abs(e[11]),r[12]=Math.abs(e[12]),r[13]=Math.abs(e[13]),r[14]=Math.abs(e[14]),r[15]=Math.abs(e[15]),r},f.equals=function(e,r){return e===r||n(e)&&n(r)&&e[12]===r[12]&&e[13]===r[13]&&e[14]===r[14]&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[8]===r[8]&&e[9]===r[9]&&e[10]===r[10]&&e[3]===r[3]&&e[7]===r[7]&&e[11]===r[11]&&e[15]===r[15]},f.equalsEpsilon=function(e,r,t){if("number"!=typeof t)throw new i("epsilon must be a number");return e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=t&&Math.abs(e[1]-r[1])<=t&&Math.abs(e[2]-r[2])<=t&&Math.abs(e[3]-r[3])<=t&&Math.abs(e[4]-r[4])<=t&&Math.abs(e[5]-r[5])<=t&&Math.abs(e[6]-r[6])<=t&&Math.abs(e[7]-r[7])<=t&&Math.abs(e[8]-r[8])<=t&&Math.abs(e[9]-r[9])<=t&&Math.abs(e[10]-r[10])<=t&&Math.abs(e[11]-r[11])<=t&&Math.abs(e[12]-r[12])<=t&&Math.abs(e[13]-r[13])<=t&&Math.abs(e[14]-r[14])<=t&&Math.abs(e[15]-r[15])<=t},f.getTranslation=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r.x=e[12],r.y=e[13],r.z=e[14],r},f.getRotation=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[4],r[4]=e[5],r[5]=e[6],r[6]=e[8],r[7]=e[9],r[8]=e[10],r};var E=new u,p=new u,_=new r,y=new r(0,0,0,1);return f.inverse=function(e,t){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("result is required");if(u.equalsEpsilon(f.getRotation(e,E),p,a.EPSILON7)&&r.equals(f.getRow(e,3,_),y))return t[0]=0,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=0,t[11]=0,t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=1,t;var o=e[0],h=e[4],d=e[8],c=e[12],l=e[1],w=e[5],m=e[9],R=e[13],T=e[2],A=e[6],S=e[10],v=e[14],N=e[3],q=e[7],g=e[11],M=e[15],I=S*M,O=v*g,x=A*M,C=v*q,P=A*g,U=S*q,b=T*M,D=v*N,L=T*g,F=S*N,B=T*q,z=A*N,G=I*w+C*m+P*R-(O*w+x*m+U*R),W=O*l+b*m+F*R-(I*l+D*m+L*R),X=x*l+D*w+B*R-(C*l+b*w+z*R),V=U*l+L*w+z*m-(P*l+F*w+B*m),H=O*h+x*d+U*c-(I*h+C*d+P*c),Y=I*o+D*d+L*c-(O*o+b*d+F*c),Z=C*o+b*h+z*c-(x*o+D*h+B*c),j=P*o+F*h+B*d-(U*o+L*h+z*d);I=d*R,O=c*m,x=h*R,C=c*w,P=h*m,U=d*w,b=o*R,D=c*l,L=o*m,F=d*l,B=o*w,z=h*l;var k=I*q+C*g+P*M-(O*q+x*g+U*M),K=O*N+b*g+F*M-(I*N+D*g+L*M),J=x*N+D*q+B*M-(C*N+b*q+z*M),Q=U*N+L*q+z*g-(P*N+F*q+B*g),$=x*S+U*v+O*A-(P*v+I*A+C*S),ee=L*v+I*T+D*S-(b*S+F*v+O*T),re=b*A+z*v+C*T-(B*v+x*T+D*A),te=B*S+P*T+F*A-(L*A+z*S+U*T),ne=o*G+h*W+d*X+c*V;if(Math.abs(ne)<a.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return ne=1/ne,t[0]=G*ne,t[1]=W*ne,t[2]=X*ne,t[3]=V*ne,t[4]=H*ne,t[5]=Y*ne,t[6]=Z*ne,t[7]=j*ne,t[8]=k*ne,t[9]=K*ne,t[10]=J*ne,t[11]=Q*ne,t[12]=$*ne,t[13]=ee*ne,t[14]=re*ne,t[15]=te*ne,t},f.inverseTransformation=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");var t=e[0],o=e[1],a=e[2],u=e[4],s=e[5],f=e[6],h=e[8],d=e[9],c=e[10],l=e[12],w=e[13],m=e[14],E=-t*l-o*w-a*m,p=-u*l-s*w-f*m,_=-h*l-d*w-c*m;return r[0]=t,r[1]=u,r[2]=h,r[3]=0,r[4]=o,r[5]=s,r[6]=d,r[7]=0,r[8]=a,r[9]=f,r[10]=c,r[11]=0,r[12]=E,r[13]=p,r[14]=_,r[15]=1,r},f.IDENTITY=o(new f(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),f.ZERO=o(new f(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN0ROW3=3,f.COLUMN1ROW0=4,f.COLUMN1ROW1=5,f.COLUMN1ROW2=6,f.COLUMN1ROW3=7,f.COLUMN2ROW0=8,f.COLUMN2ROW1=9,f.COLUMN2ROW2=10,f.COLUMN2ROW3=11,f.COLUMN3ROW0=12,f.COLUMN3ROW1=13,f.COLUMN3ROW2=14,f.COLUMN3ROW3=15,f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e);
},f.equalsArray=function(e,r,t){return e[0]===r[t]&&e[1]===r[t+1]&&e[2]===r[t+2]&&e[3]===r[t+3]&&e[4]===r[t+4]&&e[5]===r[t+5]&&e[6]===r[t+6]&&e[7]===r[t+7]&&e[8]===r[t+8]&&e[9]===r[t+9]&&e[10]===r[t+10]&&e[11]===r[t+11]&&e[12]===r[t+12]&&e[13]===r[t+13]&&e[14]===r[t+14]&&e[15]===r[t+15]},f.prototype.equalsEpsilon=function(e,r){return f.equalsEpsilon(this,e,r)},f.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},f}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,r,t,n){"use strict";var i=function(n,i){if(!r(n))throw new t("normal is required.");if(!r(i))throw new t("distance is required.");this.normal=e.clone(n),this.distance=i};i.fromPointNormal=function(n,o,a){if(!r(n))throw new t("point is required.");if(!r(o))throw new t("normal is required.");var u=-e.dot(o,n);return r(a)?(e.clone(o,a.normal),a.distance=u,a):new i(o,u)};var o=new e;return i.fromCartesian4=function(n,a){if(!r(n))throw new t("coefficients is required.");var u=e.fromCartesian4(n,o),s=n.w;return r(a)?(e.clone(u,a.normal),a.distance=s,a):new i(u,s)},i.getPointDistance=function(n,i){if(!r(n))throw new t("plane is required.");if(!r(i))throw new t("point is required.");return e.dot(n.normal,i)+n.distance},i.ORIGIN_XY_PLANE=n(new i(e.UNIT_Z,0)),i.ORIGIN_YZ_PLANE=n(new i(e.UNIT_X,0)),i.ORIGIN_ZX_PLANE=n(new i(e.UNIT_Y,0)),i}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,r,t,n,i,o,a,u){"use strict";var s=function(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)};n(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,o){if(!t(e))throw new i("value is required");if(!t(n))throw new i("array is required");o=r(o,0),n[o++]=e.west,n[o++]=e.south,n[o++]=e.east,n[o]=e.north},s.unpack=function(e,n,o){if(!t(e))throw new i("array is required");return n=r(n,0),t(o)||(o=new s),o.west=e[n++],o.south=e[n++],o.east=e[n++],o.north=e[n],o},s.computeWidth=function(e){if(!t(e))throw new i("rectangle is required.");var r=e.east,n=e.west;return n>r&&(r+=u.TWO_PI),r-n},s.computeHeight=function(e){if(!t(e))throw new i("rectangle is required.");return e.north-e.south},s.fromDegrees=function(e,n,i,o,a){return e=u.toRadians(r(e,0)),n=u.toRadians(r(n,0)),i=u.toRadians(r(i,0)),o=u.toRadians(r(o,0)),t(a)?(a.west=e,a.south=n,a.east=i,a.north=o,a):new s(e,n,i,o)},s.fromCartographicArray=function(e,r){if(!t(e))throw new i("cartographics is required.");for(var n=Number.MAX_VALUE,o=-Number.MAX_VALUE,a=Number.MAX_VALUE,u=-Number.MAX_VALUE,f=0,h=e.length;h>f;f++){var d=e[f];n=Math.min(n,d.longitude),o=Math.max(o,d.longitude),a=Math.min(a,d.latitude),u=Math.max(u,d.latitude)}return t(r)?(r.west=n,r.south=a,r.east=o,r.north=u,r):new s(n,a,o,u)},s.clone=function(e,r){return t(e)?t(r)?(r.west=e.west,r.south=e.south,r.east=e.east,r.north=e.north,r):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.west===r.west&&e.south===r.south&&e.east===r.east&&e.north===r.north},s.prototype.equalsEpsilon=function(e,r){if("number"!=typeof r)throw new i("epsilon is required and must be a number.");return t(e)&&Math.abs(this.west-e.west)<=r&&Math.abs(this.south-e.south)<=r&&Math.abs(this.east-e.east)<=r&&Math.abs(this.north-e.north)<=r},s.validate=function(e){if(!t(e))throw new i("rectangle is required");var r=e.north;if("number"!=typeof r)throw new i("north is required to be a number.");if(r<-u.PI_OVER_TWO||r>u.PI_OVER_TWO)throw new i("north must be in the interval [-Pi/2, Pi/2].");var n=e.south;if("number"!=typeof n)throw new i("south is required to be a number.");if(n<-u.PI_OVER_TWO||n>u.PI_OVER_TWO)throw new i("south must be in the interval [-Pi/2, Pi/2].");var o=e.west;if("number"!=typeof o)throw new i("west is required to be a number.");if(o<-Math.PI||o>Math.PI)throw new i("west must be in the interval [-Pi, Pi].");var a=e.east;if("number"!=typeof a)throw new i("east is required to be a number.");if(a<-Math.PI||a>Math.PI)throw new i("east must be in the interval [-Pi, Pi].")},s.southwest=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.west,n.latitude=r.south,n.height=0,n):new e(r.west,r.south)},s.northwest=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.west,n.latitude=r.north,n.height=0,n):new e(r.west,r.north)},s.northeast=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.east,n.latitude=r.north,n.height=0,n):new e(r.east,r.north)},s.southeast=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.east,n.latitude=r.south,n.height=0,n):new e(r.east,r.south)},s.center=function(r,n){if(!t(r))throw new i("rectangle is required");var o=r.east,a=r.west;a>o&&(o+=u.TWO_PI);var s=u.negativePiToPi(.5*(a+o)),f=.5*(r.south+r.north);return t(n)?(n.longitude=s,n.latitude=f,n.height=0,n):new e(s,f)},s.intersection=function(e,r,n){if(!t(e))throw new i("rectangle is required");if(!t(r))throw new i("otherRectangle is required.");var o=e.east,a=e.west,f=r.east,h=r.west;a>o&&f>0?o+=u.TWO_PI:h>f&&o>0&&(f+=u.TWO_PI),a>o&&0>h?h+=u.TWO_PI:h>f&&0>a&&(a+=u.TWO_PI);var d=u.negativePiToPi(Math.max(a,h)),c=u.negativePiToPi(Math.min(o,f));if((e.west<e.east||r.west<r.east)&&d>=c)return void 0;var l=Math.max(e.south,r.south),w=Math.min(e.north,r.north);return l>=w?void 0:t(n)?(n.west=d,n.south=l,n.east=c,n.north=w,n):new s(d,l,c,w)},s.contains=function(e,r){if(!t(e))throw new i("rectangle is required");if(!t(r))throw new i("cartographic is required.");var n=r.longitude,o=r.latitude,a=e.west,s=e.east;return a>s&&(s+=u.TWO_PI,0>n&&(n+=u.TWO_PI)),(n>a||u.equalsEpsilon(n,a,u.EPSILON14))&&(s>n||u.equalsEpsilon(n,s,u.EPSILON14))&&o>=e.south&&o<=e.north};var f=new e;return s.subsample=function(e,n,a,h){if(!t(e))throw new i("rectangle is required");n=r(n,o.WGS84),a=r(a,0),t(h)||(h=[]);var d=0,c=e.north,l=e.south,w=e.east,m=e.west,E=f;E.height=a,E.longitude=m,E.latitude=c,h[d]=n.cartographicToCartesian(E,h[d]),d++,E.longitude=w,h[d]=n.cartographicToCartesian(E,h[d]),d++,E.latitude=l,h[d]=n.cartographicToCartesian(E,h[d]),d++,E.longitude=m,h[d]=n.cartographicToCartesian(E,h[d]),d++,0>c?E.latitude=c:l>0?E.latitude=l:E.latitude=0;for(var p=1;8>p;++p)E.longitude=-Math.PI+p*u.PI_OVER_TWO,s.contains(e,E)&&(h[d]=n.cartographicToCartesian(E,h[d]),d++);return 0===E.latitude&&(E.longitude=m,h[d]=n.cartographicToCartesian(E,h[d]),d++,E.longitude=w,h[d]=n.cartographicToCartesian(E,h[d]),d++),h.length=d,h},s.MAX_VALUE=a(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Plane","./Rectangle"],function(e,r,t,n,i,o,a,u,s,f,h,d,c){"use strict";var l=function(r,n){this.center=e.clone(t(r,e.ZERO)),this.radius=t(n,0)},w=new e,m=new e,E=new e,p=new e,_=new e,y=new e,R=new e,T=new e,A=new e,S=new e,v=new e,N=new e;l.fromPoints=function(r,t){if(n(t)||(t=new l),!n(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;for(var i=e.clone(r[0],R),o=e.clone(i,w),a=e.clone(i,m),u=e.clone(i,E),s=e.clone(i,p),f=e.clone(i,_),h=e.clone(i,y),d=r.length,c=1;d>c;c++){e.clone(r[c],i);var q=i.x,g=i.y,M=i.z;q<o.x&&e.clone(i,o),q>s.x&&e.clone(i,s),g<a.y&&e.clone(i,a),g>f.y&&e.clone(i,f),M<u.z&&e.clone(i,u),M>h.z&&e.clone(i,h)}var I=e.magnitudeSquared(e.subtract(s,o,T)),O=e.magnitudeSquared(e.subtract(f,a,T)),x=e.magnitudeSquared(e.subtract(h,u,T)),C=o,P=s,U=I;O>U&&(U=O,C=a,P=f),x>U&&(U=x,C=u,P=h);var b=A;b.x=.5*(C.x+P.x),b.y=.5*(C.y+P.y),b.z=.5*(C.z+P.z);var D=e.magnitudeSquared(e.subtract(P,b,T)),L=Math.sqrt(D),F=S;F.x=o.x,F.y=a.y,F.z=u.z;var B=v;B.x=s.x,B.y=f.y,B.z=h.z;var z=e.multiplyByScalar(e.add(F,B,T),.5,N),G=0;for(c=0;d>c;c++){e.clone(r[c],i);var W=e.magnitude(e.subtract(i,z,T));W>G&&(G=W);var X=e.magnitudeSquared(e.subtract(i,b,T));if(X>D){var V=Math.sqrt(X);L=.5*(L+V),D=L*L;var H=V-L;b.x=(L*b.x+H*i.x)/V,b.y=(L*b.y+H*i.y)/V,b.z=(L*b.z+H*i.z)/V}}return G>L?(e.clone(b,t.center),t.radius=L):(e.clone(z,t.center),t.radius=G),t};var q=new u,g=new e,M=new e,I=new r,O=new r;l.fromRectangle2D=function(e,r,t){return l.fromRectangleWithHeights2D(e,r,0,0,t)},l.fromRectangleWithHeights2D=function(r,i,o,a,u){if(n(u)||(u=new l),!n(r))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;i=t(i,q),c.southwest(r,I),I.height=o,c.northeast(r,O),O.height=a;var s=i.project(I,g),f=i.project(O,M),h=f.x-s.x,d=f.y-s.y,w=f.z-s.z;u.radius=.5*Math.sqrt(h*h+d*d+w*w);var m=u.center;return m.x=s.x+.5*h,m.y=s.y+.5*d,m.z=s.z+.5*w,u};var x=[];l.fromRectangle3D=function(e,r,i,o){r=t(r,a.WGS84),i=t(i,0);var u;return n(e)&&(u=c.subsample(e,r,i,x)),l.fromPoints(u,o)},l.fromVertices=function(r,i,a,u){if(n(u)||(u=new l),!n(r)||0===r.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;if(i=t(i,e.ZERO),a=t(a,3),3>a)throw new o("stride must be 3 or greater.");var s=R;s.x=r[0]+i.x,s.y=r[1]+i.y,s.z=r[2]+i.z;for(var f=e.clone(s,w),h=e.clone(s,m),d=e.clone(s,E),c=e.clone(s,p),q=e.clone(s,_),g=e.clone(s,y),M=r.length,I=0;M>I;I+=a){var O=r[I]+i.x,x=r[I+1]+i.y,C=r[I+2]+i.z;s.x=O,s.y=x,s.z=C,O<f.x&&e.clone(s,f),O>c.x&&e.clone(s,c),x<h.y&&e.clone(s,h),x>q.y&&e.clone(s,q),C<d.z&&e.clone(s,d),C>g.z&&e.clone(s,g)}var P=e.magnitudeSquared(e.subtract(c,f,T)),U=e.magnitudeSquared(e.subtract(q,h,T)),b=e.magnitudeSquared(e.subtract(g,d,T)),D=f,L=c,F=P;U>F&&(F=U,D=h,L=q),b>F&&(F=b,D=d,L=g);var B=A;B.x=.5*(D.x+L.x),B.y=.5*(D.y+L.y),B.z=.5*(D.z+L.z);var z=e.magnitudeSquared(e.subtract(L,B,T)),G=Math.sqrt(z),W=S;W.x=f.x,W.y=h.y,W.z=d.z;var X=v;X.x=c.x,X.y=q.y,X.z=g.z;var V=e.multiplyByScalar(e.add(W,X,T),.5,N),H=0;for(I=0;M>I;I+=a){s.x=r[I]+i.x,s.y=r[I+1]+i.y,s.z=r[I+2]+i.z;var Y=e.magnitude(e.subtract(s,V,T));Y>H&&(H=Y);var Z=e.magnitudeSquared(e.subtract(s,B,T));if(Z>z){var j=Math.sqrt(Z);G=.5*(G+j),z=G*G;var k=j-G;B.x=(G*B.x+k*s.x)/j,B.y=(G*B.y+k*s.y)/j,B.z=(G*B.z+k*s.z)/j}}return H>G?(e.clone(B,u.center),u.radius=G):(e.clone(V,u.center),u.radius=H),u},l.fromCornerPoints=function(r,t,i){if(!n(r)||!n(t))throw new o("corner and oppositeCorner are required.");n(i)||(i=new l);var a=i.center;return e.add(r,t,a),e.multiplyByScalar(a,.5,a),i.radius=e.distance(a,t),i},l.fromEllipsoid=function(r,t){if(!n(r))throw new o("ellipsoid is required.");return n(t)||(t=new l),e.clone(e.ZERO,t.center),t.radius=r.maximumRadius,t};var C=new e;l.fromBoundingSpheres=function(r,t){if(n(t)||(t=new l),!n(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;var i=r.length;if(1===i)return l.clone(r[0],t);if(2===i)return l.union(r[0],r[1],t);for(var o=[],a=0;i>a;a++)o.push(r[a].center);t=l.fromPoints(o,t);var u=t.center,s=t.radius;for(a=0;i>a;a++){var f=r[a];s=Math.max(s,e.distance(u,f.center,C)+f.radius)}return t.radius=s,t},l.clone=function(r,t){return n(r)?n(t)?(t.center=e.clone(r.center,t.center),t.radius=r.radius,t):new l(r.center,r.radius):void 0},l.packedLength=4,l.pack=function(e,r,i){if(!n(e))throw new o("value is required");if(!n(r))throw new o("array is required");i=t(i,0);var a=e.center;r[i++]=a.x,r[i++]=a.y,r[i++]=a.z,r[i]=e.radius},l.unpack=function(e,r,i){if(!n(e))throw new o("array is required");r=t(r,0),n(i)||(i=new l);var a=i.center;return a.x=e[r++],a.y=e[r++],a.z=e[r++],i.radius=e[r],i};var P=new e,U=new e;l.union=function(r,t,i){if(!n(r))throw new o("left is required.");if(!n(t))throw new o("right is required.");n(i)||(i=new l);var a=r.center,u=r.radius,s=t.center,f=t.radius,h=e.subtract(s,a,P),d=e.magnitude(h);if(u>=d+f)return r.clone(i),i;if(f>=d+u)return t.clone(i),i;var c=.5*(u+d+f),w=e.multiplyByScalar(h,(-u+c)/d,U);return e.add(w,a,w),e.clone(w,i.center),i.radius=c,i};var b=new e;l.expand=function(r,t,i){if(!n(r))throw new o("sphere is required.");if(!n(t))throw new o("point is required.");i=l.clone(r,i);var a=e.magnitude(e.subtract(t,i.center,b));return a>i.radius&&(i.radius=a),i},l.intersectPlane=function(r,t){if(!n(r))throw new o("sphere is required.");if(!n(t))throw new o("plane is required.");var i=r.center,a=r.radius,u=t.normal,f=e.dot(u,i)+t.distance;return-a>f?s.OUTSIDE:a>f?s.INTERSECTING:s.INSIDE},l.transform=function(e,r,t){if(!n(e))throw new o("sphere is required.");if(!n(r))throw new o("transform is required.");return n(t)||(t=new l),t.center=h.multiplyByPoint(r,e.center,t.center),t.radius=h.getMaximumScale(r)*e.radius,t};var D=new e;l.distanceSquaredTo=function(r,t){if(!n(r))throw new o("sphere is required.");if(!n(t))throw new o("cartesian is required.");var i=e.subtract(r.center,t,D);return e.magnitudeSquared(i)-r.radius*r.radius},l.transformWithoutScale=function(e,r,t){if(!n(e))throw new o("sphere is required.");if(!n(r))throw new o("transform is required.");return n(t)||(t=new l),t.center=h.multiplyByPoint(r,e.center,t.center),t.radius=e.radius,t};var L=new e;l.computePlaneDistances=function(r,t,i,a){if(!n(r))throw new o("sphere is required.");if(!n(t))throw new o("position is required.");if(!n(i))throw new o("direction is required.");n(a)||(a=new f);var u=e.subtract(r.center,t,L),s=e.dot(i,u);return a.start=s-r.radius,a.stop=s+r.radius,a};for(var F=new e,B=new e,z=new e,G=new e,W=new e,X=new r,V=new Array(8),H=0;8>H;++H)V[H]=new e;var Y=new u;return l.projectTo2D=function(r,i,a){if(!n(r))throw new o("sphere is required.");i=t(i,Y);var u=i.ellipsoid,s=r.center,f=r.radius,h=u.geodeticSurfaceNormal(s,F),d=e.cross(e.UNIT_Z,h,B);e.normalize(d,d);var c=e.cross(h,d,z);e.normalize(c,c),e.multiplyByScalar(h,f,h),e.multiplyByScalar(c,f,c),e.multiplyByScalar(d,f,d);var w=e.negate(c,W),m=e.negate(d,G),E=V,p=E[0];e.add(h,c,p),e.add(p,d,p),p=E[1],e.add(h,c,p),e.add(p,m,p),p=E[2],e.add(h,w,p),e.add(p,m,p),p=E[3],e.add(h,w,p),e.add(p,d,p),e.negate(h,h),p=E[4],e.add(h,c,p),e.add(p,d,p),p=E[5],e.add(h,c,p),e.add(p,m,p),p=E[6],e.add(h,w,p),e.add(p,m,p),p=E[7],e.add(h,w,p),e.add(p,d,p);for(var _=E.length,y=0;_>y;++y){var R=E[y];e.add(s,R,R);var T=u.cartesianToCartographic(R,X);i.project(T,R)}a=l.fromPoints(E,a),s=a.center;var A=s.x,S=s.y,v=s.z;return s.x=v,s.y=A,s.z=S,a},l.isOccluded=function(e,r){if(!n(e))throw new o("sphere is required.");if(!n(r))throw new o("occluder is required.");return!r.isBoundingSphereVisible(e)},l.equals=function(r,t){return r===t||n(r)&&n(t)&&e.equals(r.center,t.center)&&r.radius===t.radius},l.prototype.intersectPlane=function(e){return l.intersectPlane(this,e)},l.prototype.distanceSquaredTo=function(e){return l.distanceSquaredTo(this,e)},l.prototype.computePlaneDistances=function(e,r,t){return l.computePlaneDistances(this,e,r,t)},l.prototype.isOccluded=function(e){return l.isOccluded(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.prototype.clone=function(e){return l.clone(this,e)},l}),define("Core/EllipsoidalOccluder",["./BoundingSphere","./Cartesian3","./defaultValue","./defined","./defineProperties","./DeveloperError","./Rectangle"],function(e,r,t,n,i,o,a){"use strict";function u(e,t,n){var i=e.transformPositionToScaledSpace(t,w),o=r.magnitudeSquared(i),a=Math.sqrt(o),u=r.divideByScalar(i,a,m);o=Math.max(1,o),a=Math.max(1,a);var s=r.dot(u,n),f=r.magnitude(r.cross(u,n,u)),h=1/a,d=Math.sqrt(o-1)*h;return 1/(s*h-f*d)}function s(e,t,n){return 0>=t||t===1/0||t!==t?void 0:r.multiplyByScalar(e,t,n)}function f(e,t){return e.transformPositionToScaledSpace(t,E),r.normalize(E,E)}var h=function(e,t){if(!n(e))throw new o("ellipsoid is required.");this._ellipsoid=e,this._cameraPosition=new r,this._cameraPositionInScaledSpace=new r,this._distanceToLimbInScaledSpaceSquared=0,n(t)&&(this.cameraPosition=t)};i(h.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},cameraPosition:{get:function(){return this._cameraPosition},set:function(e){var t=this._ellipsoid,n=t.transformPositionToScaledSpace(e,this._cameraPositionInScaledSpace),i=r.magnitudeSquared(n)-1;r.clone(e,this._cameraPosition),this._cameraPositionInScaledSpace=n,this._distanceToLimbInScaledSpaceSquared=i}}});var d=new r;h.prototype.isPointVisible=function(e){var r=this._ellipsoid,t=r.transformPositionToScaledSpace(e,d);return this.isScaledSpacePointVisible(t)},h.prototype.isScaledSpacePointVisible=function(e){if(this._distanceToLimbInScaledSpaceSquared<0)return!0;var t=this._cameraPositionInScaledSpace,n=this._distanceToLimbInScaledSpaceSquared,i=r.subtract(e,t,d),o=-r.dot(i,t),a=o>n&&o*o/r.magnitudeSquared(i)>n;return!a},h.prototype.computeHorizonCullingPoint=function(e,t,i){if(!n(e))throw new o("directionToPoint is required");if(!n(t))throw new o("positions is required");n(i)||(i=new r);for(var a=this._ellipsoid,h=f(a,e),d=0,c=0,l=t.length;l>c;++c){var w=t[c],m=u(a,w,h);d=Math.max(d,m)}return s(h,d,i)};var c=new r;h.prototype.computeHorizonCullingPointFromVertices=function(e,i,a,h,d){if(!n(e))throw new o("directionToPoint is required");if(!n(i))throw new o("vertices is required");if(!n(a))throw new o("stride is required");n(d)||(d=new r),h=t(h,r.ZERO);for(var l=this._ellipsoid,w=f(l,e),m=0,E=0,p=i.length;p>E;E+=a){c.x=i[E]+h.x,c.y=i[E+1]+h.y,c.z=i[E+2]+h.z;var _=u(l,c,w);m=Math.max(m,_)}return s(w,m,d)};var l=[];h.prototype.computeHorizonCullingPointFromRectangle=function(t,i,u){if(!n(t))throw new o("rectangle is required.");var s=a.subsample(t,i,0,l),f=e.fromPoints(s);return r.magnitude(f.center)<.1*i.minimumRadius?void 0:this.computeHorizonCullingPoint(f.center,s,u)};var w=new r,m=new r,E=new r;return h}),define("Renderer/WebGLConstants",["../Core/freezeObject"],function(e){"use strict";var r={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return e(r)}),define("Core/IndexDatatype",["../Renderer/WebGLConstants","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o={UNSIGNED_BYTE:e.UNSIGNED_BYTE,UNSIGNED_SHORT:e.UNSIGNED_SHORT,UNSIGNED_INT:e.UNSIGNED_INT};return o.getSizeInBytes=function(e){switch(e){case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},o.validate=function(e){return r(e)&&(e===o.UNSIGNED_BYTE||e===o.UNSIGNED_SHORT||e===o.UNSIGNED_INT)},o.createTypedArray=function(e,n){if(!r(e))throw new t("numberOfVertices is required.");return e>=i.SIXTY_FOUR_KILOBYTES?new Uint32Array(n):new Uint16Array(n)},o.createTypedArrayFromArrayBuffer=function(e,n,o,a){if(!r(e))throw new t("numberOfVertices is required.");if(!r(n))throw new t("sourceArray is required.");if(!r(o))throw new t("byteOffset is required.");return e>=i.SIXTY_FOUR_KILOBYTES?new Uint32Array(n,o,a):new Uint16Array(n,o,a)},n(o)}),
define("Core/Intersections2D",["./Cartesian3","./defined","./DeveloperError"],function(e,r,t){"use strict";var n={};return n.clipTriangleAtAxisAlignedThreshold=function(e,n,i,o,a,u){if(!r(e))throw new t("threshold is required.");if(!r(n))throw new t("keepAbove is required.");if(!r(i))throw new t("u0 is required.");if(!r(o))throw new t("u1 is required.");if(!r(a))throw new t("u2 is required.");r(u)?u.length=0:u=[];var s,f,h;n?(s=e>i,f=e>o,h=e>a):(s=i>e,f=o>e,h=a>e);var d,c,l,w,m,E,p=s+f+h;return 1===p?s?(d=(e-i)/(o-i),c=(e-i)/(a-i),u.push(1),u.push(2),1!==c&&(u.push(-1),u.push(0),u.push(2),u.push(c)),1!==d&&(u.push(-1),u.push(0),u.push(1),u.push(d))):f?(l=(e-o)/(a-o),w=(e-o)/(i-o),u.push(2),u.push(0),1!==w&&(u.push(-1),u.push(1),u.push(0),u.push(w)),1!==l&&(u.push(-1),u.push(1),u.push(2),u.push(l))):h&&(m=(e-a)/(i-a),E=(e-a)/(o-a),u.push(0),u.push(1),1!==E&&(u.push(-1),u.push(2),u.push(1),u.push(E)),1!==m&&(u.push(-1),u.push(2),u.push(0),u.push(m))):2===p?s||i===e?f||o===e?h||a===e||(c=(e-i)/(a-i),l=(e-o)/(a-o),u.push(2),u.push(-1),u.push(0),u.push(2),u.push(c),u.push(-1),u.push(1),u.push(2),u.push(l)):(E=(e-a)/(o-a),d=(e-i)/(o-i),u.push(1),u.push(-1),u.push(2),u.push(1),u.push(E),u.push(-1),u.push(0),u.push(1),u.push(d)):(w=(e-o)/(i-o),m=(e-a)/(i-a),u.push(0),u.push(-1),u.push(1),u.push(0),u.push(w),u.push(-1),u.push(2),u.push(0),u.push(m)):3===p||(u.push(0),u.push(1),u.push(2)),u},n.computeBarycentricCoordinates=function(n,i,o,a,u,s,f,h,d){if(!r(n))throw new t("x is required.");if(!r(i))throw new t("y is required.");if(!r(o))throw new t("x1 is required.");if(!r(a))throw new t("y1 is required.");if(!r(u))throw new t("x2 is required.");if(!r(s))throw new t("y2 is required.");if(!r(f))throw new t("x3 is required.");if(!r(h))throw new t("y3 is required.");var c=o-f,l=f-u,w=s-h,m=a-h,E=1/(w*c+l*m),p=i-h,_=n-f,y=(w*_+l*p)*E,R=(-m*_+c*p)*E,T=1-y-R;return r(d)?(d.x=y,d.y=R,d.z=T,d):new e(y,R,T)},n}),define("Core/AxisAlignedBoundingBox",["./Cartesian3","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Intersect","./Plane"],function(e,r,t,n,i,o,a){"use strict";var u=function(n,i,o){this.minimum=e.clone(r(n,e.ZERO)),this.maximum=e.clone(r(i,e.ZERO)),t(o)?o=e.clone(o):(o=e.add(this.minimum,this.maximum,new e),e.multiplyByScalar(o,.5,o)),this.center=o};u.fromPoints=function(r,n){if(t(n)||(n=new u),!t(r)||0===r.length)return n.minimum=e.clone(e.ZERO,n.minimum),n.maximum=e.clone(e.ZERO,n.maximum),n.center=e.clone(e.ZERO,n.center),n;for(var i=r[0].x,o=r[0].y,a=r[0].z,s=r[0].x,f=r[0].y,h=r[0].z,d=r.length,c=1;d>c;c++){var l=r[c],w=l.x,m=l.y,E=l.z;i=Math.min(w,i),s=Math.max(w,s),o=Math.min(m,o),f=Math.max(m,f),a=Math.min(E,a),h=Math.max(E,h)}var p=n.minimum;p.x=i,p.y=o,p.z=a;var _=n.maximum;_.x=s,_.y=f,_.z=h;var y=e.add(p,_,n.center);return e.multiplyByScalar(y,.5,y),n},u.clone=function(r,n){return t(r)?t(n)?(n.minimum=e.clone(r.minimum,n.minimum),n.maximum=e.clone(r.maximum,n.maximum),n.center=e.clone(r.center,n.center),n):new u(r.minimum,r.maximum):void 0},u.equals=function(r,n){return r===n||t(r)&&t(n)&&e.equals(r.center,n.center)&&e.equals(r.minimum,n.minimum)&&e.equals(r.maximum,n.maximum)};var s=new e;return u.intersectPlane=function(r,n){if(!t(r))throw new i("box is required.");if(!t(n))throw new i("plane is required.");s=e.subtract(r.maximum,r.minimum,s);var a=e.multiplyByScalar(s,.5,s),u=n.normal,f=a.x*Math.abs(u.x)+a.y*Math.abs(u.y)+a.z*Math.abs(u.z),h=e.dot(r.center,u)+n.distance;return h-f>0?o.INSIDE:0>h+f?o.OUTSIDE:o.INTERSECTING},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.intersectPlane=function(e){return u.intersectPlane(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,r){"use strict";function t(e,t,n){var i=e+t;return r.sign(e)!==r.sign(t)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(t)))<n?0:i}var n={};return n.computeDiscriminant=function(r,t,n){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");var i=t*t-4*r*n;return i},n.computeRealRoots=function(n,i,o){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");var a;if(0===n)return 0===i?[]:[-o/i];if(0===i){if(0===o)return[0,0];var u=Math.abs(o),s=Math.abs(n);if(s>u&&u/s<r.EPSILON14)return[0,0];if(u>s&&s/u<r.EPSILON14)return[];if(a=-o/n,0>a)return[];var f=Math.sqrt(a);return[-f,f]}if(0===o)return a=-i/n,0>a?[a,0]:[0,a];var h=i*i,d=4*n*o,c=t(h,-d,r.EPSILON14);if(0>c)return[];var l=-.5*t(i,r.sign(i)*Math.sqrt(c),r.EPSILON14);return i>0?[l/n,o/l]:[o/l,l/n]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,r){"use strict";function t(e,r,t,n){var i,o,a=e,u=r/3,s=t/3,f=n,h=a*s,d=u*f,c=u*u,l=s*s,w=a*s-c,m=a*f-u*s,E=u*f-l,p=4*w*E-m*m;if(0>p){var _,y,R;c*d>=h*l?(_=a,y=w,R=-2*u*w+a*m):(_=f,y=E,R=-f*m+2*s*E);var T=0>R?-1:1,A=-T*Math.abs(_)*Math.sqrt(-p);o=-R+A;var S=o/2,v=0>S?-Math.pow(-S,1/3):Math.pow(S,1/3),N=o===A?-v:-y/v;return i=0>=y?v+N:-R/(v*v+N*N+y),c*d>=h*l?[(i-u)/a]:[-f/(i+s)]}var q=w,g=-2*u*w+a*m,M=E,I=-f*m+2*s*E,O=Math.sqrt(p),x=Math.sqrt(3)/2,C=Math.abs(Math.atan2(a*O,-g)/3);i=2*Math.sqrt(-q);var P=Math.cos(C);o=i*P;var U=i*(-P/2-x*Math.sin(C)),b=o+U>2*u?o-u:U-u,D=a,L=b/D;C=Math.abs(Math.atan2(f*O,-I)/3),i=2*Math.sqrt(-M),P=Math.cos(C),o=i*P,U=i*(-P/2-x*Math.sin(C));var F=-f,B=2*s>o+U?o+s:U+s,z=F/B,G=D*B,W=-b*B-D*F,X=b*F,V=(s*W-u*X)/(-u*W+s*G);return V>=L?z>=L?z>=V?[L,V,z]:[L,z,V]:[z,L,V]:z>=L?[V,L,z]:z>=V?[V,z,L]:[z,V,L]}var n={};return n.computeDiscriminant=function(r,t,n,i){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var o=r*r,a=t*t,u=n*n,s=i*i,f=18*r*t*n*i+a*u-27*o*s-4*(r*u*n+a*t*i);return f},n.computeRealRoots=function(n,i,o,a){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");if("number"!=typeof a)throw new e("d is a required number.");var u,s;if(0===n)return r.computeRealRoots(i,o,a);if(0===i){if(0===o){if(0===a)return[0,0,0];s=-a/n;var f=0>s?-Math.pow(-s,1/3):Math.pow(s,1/3);return[f,f,f]}return 0===a?(u=r.computeRealRoots(n,0,o),0===u.Length?[0]:[u[0],0,u[1]]):t(n,0,o,a)}return 0===o?0===a?(s=-i/n,0>s?[s,0,0]:[0,0,s]):t(n,i,0,a):0===a?(u=r.computeRealRoots(n,i,o),0===u.length?[0]:u[1]<=0?[u[0],u[1],0]:u[0]>=0?[0,u[0],u[1]]:[u[0],0,u[1]]):t(n,i,o,a)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,r,t,n){"use strict";function i(r,i,o,a){var u=r*r,s=i-3*u/8,f=o-i*r/2+u*r/8,h=a-o*r/4+i*u/16-3*u*u/256,d=e.computeRealRoots(1,2*s,s*s-4*h,-f*f);if(d.length>0){var c=-r/4,l=d[d.length-1];if(Math.abs(l)<t.EPSILON14){var w=n.computeRealRoots(1,s,h);if(2===w.length){var m,E=w[0],p=w[1];if(E>=0&&p>=0){var _=Math.sqrt(E),y=Math.sqrt(p);return[c-y,c-_,c+_,c+y]}if(E>=0&&0>p)return m=Math.sqrt(E),[c-m,c+m];if(0>E&&p>=0)return m=Math.sqrt(p),[c-m,c+m]}return[]}if(l>0){var R=Math.sqrt(l),T=(s+l-f/R)/2,A=(s+l+f/R)/2,S=n.computeRealRoots(1,R,T),v=n.computeRealRoots(1,-R,A);return 0!==S.length?(S[0]+=c,S[1]+=c,0!==v.length?(v[0]+=c,v[1]+=c,S[1]<=v[0]?[S[0],S[1],v[0],v[1]]:v[1]<=S[0]?[v[0],v[1],S[0],S[1]]:S[0]>=v[0]&&S[1]<=v[1]?[v[0],S[0],S[1],v[1]]:v[0]>=S[0]&&v[1]<=S[1]?[S[0],v[0],v[1],S[1]]:S[0]>v[0]&&S[0]<v[1]?[v[0],S[0],v[1],S[1]]:[S[0],v[0],S[1],v[1]]):S):0!==v.length?(v[0]+=c,v[1]+=c,v):[]}}return[]}function o(r,i,o,a){var u=o*o,s=i*i,f=r*r,h=-2*i,d=o*r+s-4*a,c=f*a-o*i*r+u,l=e.computeRealRoots(1,h,d,c);if(l.length>0){var w,m,E=l[0],p=i-E,_=p*p,y=r/2,R=p/2,T=_-4*a,A=_+4*Math.abs(a),S=f-4*E,v=f+4*Math.abs(E);if(0>E||S*A>T*v){var N=Math.sqrt(S);w=N/2,m=0===N?0:(r*R-o)/N}else{var q=Math.sqrt(T);w=0===q?0:(r*R-o)/q,m=q/2}var g,M;0===y&&0===w?(g=0,M=0):t.sign(y)===t.sign(w)?(g=y+w,M=E/g):(M=y-w,g=E/M);var I,O;0===R&&0===m?(I=0,O=0):t.sign(R)===t.sign(m)?(I=R+m,O=a/I):(O=R-m,I=a/O);var x=n.computeRealRoots(1,g,I),C=n.computeRealRoots(1,M,O);if(0!==x.length)return 0!==C.length?x[1]<=C[0]?[x[0],x[1],C[0],C[1]]:C[1]<=x[0]?[C[0],C[1],x[0],x[1]]:x[0]>=C[0]&&x[1]<=C[1]?[C[0],x[0],x[1],C[1]]:C[0]>=x[0]&&C[1]<=x[1]?[x[0],C[0],C[1],x[1]]:x[0]>C[0]&&x[0]<C[1]?[C[0],x[0],C[1],x[1]]:[x[0],C[0],x[1],C[1]]:x;if(0!==C.length)return C}return[]}var a={};return a.computeDiscriminant=function(e,t,n,i,o){if("number"!=typeof e)throw new r("a is a required number.");if("number"!=typeof t)throw new r("b is a required number.");if("number"!=typeof n)throw new r("c is a required number.");if("number"!=typeof i)throw new r("d is a required number.");if("number"!=typeof o)throw new r("e is a required number.");var a=e*e,u=a*e,s=t*t,f=s*t,h=n*n,d=h*n,c=i*i,l=c*i,w=o*o,m=w*o,E=s*h*c-4*f*l-4*e*d*c+18*e*t*n*l-27*a*c*c+256*u*m+o*(18*f*n*i-4*s*d+16*e*h*h-80*e*t*h*i-6*e*s*c+144*a*n*c)+w*(144*e*s*n-27*s*s-128*a*h-192*a*t*i);return E},a.computeRealRoots=function(n,a,u,s,f){if("number"!=typeof n)throw new r("a is a required number.");if("number"!=typeof a)throw new r("b is a required number.");if("number"!=typeof u)throw new r("c is a required number.");if("number"!=typeof s)throw new r("d is a required number.");if("number"!=typeof f)throw new r("e is a required number.");if(Math.abs(n)<t.EPSILON15)return e.computeRealRoots(a,u,s,f);var h=a/n,d=u/n,c=s/n,l=f/n,w=0>h?1:0;switch(w+=0>d?w+1:w,w+=0>c?w+1:w,w+=0>l?w+1:w){case 0:return i(h,d,c,l);case 1:return o(h,d,c,l);case 2:return o(h,d,c,l);case 3:return i(h,d,c,l);case 4:return i(h,d,c,l);case 5:return o(h,d,c,l);case 6:return i(h,d,c,l);case 7:return i(h,d,c,l);case 8:return o(h,d,c,l);case 9:return i(h,d,c,l);case 10:return i(h,d,c,l);case 11:return o(h,d,c,l);case 12:return i(h,d,c,l);case 13:return i(h,d,c,l);case 14:return i(h,d,c,l);case 15:return i(h,d,c,l);default:return void 0}},a}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i=function(t,n){n=e.clone(r(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(r(t,e.ZERO)),this.direction=n};return i.getPoint=function(r,i,o){if(!t(r))throw new n("ray is requred");if("number"!=typeof i)throw new n("t is a required number");return t(o)||(o=new e),o=e.multiplyByScalar(r.direction,i,o),e.add(r.origin,o,o)},i}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,r,t,n,i,o,a,u,s,f){"use strict";function h(r,a,u,s,f){if(!n(r))throw new i("ray is required.");if(!n(a))throw new i("p0 is required.");if(!n(u))throw new i("p1 is required.");if(!n(s))throw new i("p2 is required.");f=t(f,!1);var h,d,c,l,w,m=r.origin,T=r.direction,A=e.subtract(u,a,E),S=e.subtract(s,a,p),v=e.cross(T,S,_),N=e.dot(A,v);if(f){if(N<o.EPSILON6)return void 0;if(h=e.subtract(m,a,y),c=e.dot(h,v),0>c||c>N)return void 0;if(d=e.cross(h,A,R),l=e.dot(T,d),0>l||c+l>N)return void 0;w=e.dot(S,d)/N}else{if(Math.abs(N)<o.EPSILON6)return void 0;var q=1/N;if(h=e.subtract(m,a,y),c=e.dot(h,v)*q,0>c||c>1)return void 0;if(d=e.cross(h,A,R),l=e.dot(T,d)*q,0>l||c+l>1)return void 0;w=e.dot(S,d)*q}return w}function d(e,r,t,n){var i=r*r-4*e*t;if(0>i)return void 0;if(i>0){var o=1/(2*e),a=Math.sqrt(i),u=(-r+a)*o,s=(-r-a)*o;return s>u?(n.root0=u,n.root1=s):(n.root0=s,n.root1=u),n}var f=-r/(2*e);return 0===f?void 0:(n.root0=n.root1=f,n)}function c(r,t,i){n(i)||(i={});var o=r.origin,a=r.direction,u=t.center,s=t.radius*t.radius,f=e.subtract(o,u,_),h=e.dot(a,a),c=2*e.dot(a,f),l=e.magnitudeSquared(f)-s,w=d(h,c,l,A);return n(w)?(i.start=w.root0,i.stop=w.root1,i):void 0}function l(e,r,t){var n=e+r;return o.sign(e)!==o.sign(r)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(r)))<t?0:n}function w(r,t,n,i,f){var h,d=i*i,c=f*f,w=(r[a.COLUMN1ROW1]-r[a.COLUMN2ROW2])*c,m=f*(i*l(r[a.COLUMN1ROW0],r[a.COLUMN0ROW1],o.EPSILON15)+t.y),E=r[a.COLUMN0ROW0]*d+r[a.COLUMN2ROW2]*c+i*t.x+n,p=c*l(r[a.COLUMN2ROW1],r[a.COLUMN1ROW2],o.EPSILON15),_=f*(i*l(r[a.COLUMN2ROW0],r[a.COLUMN0ROW2])+t.z),y=[];if(0===_&&0===p){if(h=u.computeRealRoots(w,m,E),0===h.length)return y;var R=h[0],T=Math.sqrt(Math.max(1-R*R,0));if(y.push(new e(i,f*R,f*-T)),y.push(new e(i,f*R,f*T)),2===h.length){var A=h[1],S=Math.sqrt(Math.max(1-A*A,0));y.push(new e(i,f*A,f*-S)),y.push(new e(i,f*A,f*S))}return y}var v=_*_,N=p*p,q=w*w,g=_*p,M=q+N,I=2*(m*w+g),O=2*E*w+m*m-N+v,x=2*(E*m-g),C=E*E-v;if(0===M&&0===I&&0===O&&0===x)return y;h=s.computeRealRoots(M,I,O,x,C);var P=h.length;if(0===P)return y;for(var U=0;P>U;++U){var b,D=h[U],L=D*D,F=Math.max(1-L,0),B=Math.sqrt(F);b=o.sign(w)===o.sign(E)?l(w*L+E,m*D,o.EPSILON12):o.sign(E)===o.sign(m*D)?l(w*L,m*D+E,o.EPSILON12):l(w*L+m*D,E,o.EPSILON12);var z=l(p*D,_,o.EPSILON15),G=b*z;0>G?y.push(new e(i,f*D,f*B)):G>0?y.push(new e(i,f*D,f*-B)):0!==B?(y.push(new e(i,f*D,f*-B)),y.push(new e(i,f*D,f*B)),++U):y.push(new e(i,f*D,f*B))}return y}var m={};m.rayPlane=function(r,t,a){if(!n(r))throw new i("ray is required.");if(!n(t))throw new i("plane is required.");n(a)||(a=new e);var u=r.origin,s=r.direction,f=t.normal,h=e.dot(f,s);if(Math.abs(h)<o.EPSILON15)return void 0;var d=(-t.distance-e.dot(f,u))/h;return 0>d?void 0:(a=e.multiplyByScalar(s,d,a),e.add(u,a,a))};var E=new e,p=new e,_=new e,y=new e,R=new e;m.rayTriangle=function(r,t,i,o,a,u){var s=h(r,t,i,o,a);return!n(s)||0>s?void 0:(n(u)||(u=new e),e.multiplyByScalar(r.direction,s,u),e.add(r.origin,u,u))};var T=new f;m.lineSegmentTriangle=function(r,t,o,a,u,s,f){if(!n(r))throw new i("v0 is required.");if(!n(t))throw new i("v1 is required.");var d=T;e.clone(r,d.origin),e.subtract(t,r,d.direction),e.normalize(d.direction,d.direction);var c=h(d,o,a,u,s);return!n(c)||0>c||c>e.distance(r,t)?void 0:(n(f)||(f=new e),e.multiplyByScalar(d.direction,c,f),e.add(d.origin,f,f))};var A={root0:0,root1:0};m.raySphere=function(e,r,t){if(!n(e))throw new i("ray is required.");if(!n(r))throw new i("sphere is required.");return t=c(e,r,t),!n(t)||t.stop<0?void 0:(t.start=Math.max(t.start,0),t)};var S=new f;m.lineSegmentSphere=function(r,t,o,a){if(!n(r))throw new i("p0 is required.");if(!n(t))throw new i("p1 is required.");if(!n(o))throw new i("sphere is required.");var u=S,s=(e.clone(r,u.origin),e.subtract(t,r,u.direction)),f=e.magnitude(s);return e.normalize(s,s),a=c(u,o,a),!n(a)||a.stop<0||a.start>f?void 0:(a.start=Math.max(a.start,0),a.stop=Math.min(a.stop,f),a)};var v=new e,N=new e;m.rayEllipsoid=function(r,t){if(!n(r))throw new i("ray is required.");if(!n(t))throw new i("ellipsoid is required.");var o,a,u,s,f,h=t.oneOverRadii,d=e.multiplyComponents(h,r.origin,v),c=e.multiplyComponents(h,r.direction,N),l=e.magnitudeSquared(d),w=e.dot(d,c);if(l>1){if(w>=0)return void 0;var m=w*w;if(o=l-1,a=e.magnitudeSquared(c),u=a*o,u>m)return void 0;if(m>u){s=w*w-u,f=-w+Math.sqrt(s);var E=f/a,p=o/f;return p>E?{start:E,stop:p}:{start:p,stop:E}}var _=Math.sqrt(o/a);return{start:_,stop:_}}return 1>l?(o=l-1,a=e.magnitudeSquared(c),u=a*o,s=w*w-u,f=-w+Math.sqrt(s),{start:0,stop:f/a}):0>w?(a=e.magnitudeSquared(c),{start:0,stop:-w/a}):void 0};var q=new e,g=new e,M=new e,I=new e,O=new e,x=new a,C=new a,P=new a,U=new a,b=new a,D=new a,L=new a,F=new e,B=new e,z=new r;m.grazingAltitudeLocation=function(r,t){if(!n(r))throw new i("ray is required.");if(!n(t))throw new i("ellipsoid is required.");var u=r.origin,s=r.direction,f=t.geodeticSurfaceNormal(u,q);if(e.dot(s,f)>=0)return u;var h=n(this.rayEllipsoid(r,t)),d=t.transformPositionToScaledSpace(s,q),c=e.normalize(d,d),l=e.mostOrthogonalAxis(d,I),m=e.normalize(e.cross(l,c,g),g),E=e.normalize(e.cross(c,m,M),M),p=x;p[0]=c.x,p[1]=c.y,p[2]=c.z,p[3]=m.x,p[4]=m.y,p[5]=m.z,p[6]=E.x,p[7]=E.y,p[8]=E.z;var _=a.transpose(p,C),y=a.fromScale(t.radii,P),R=a.fromScale(t.oneOverRadii,U),T=b;T[0]=0,T[1]=-s.z,T[2]=s.y,T[3]=s.z,T[4]=0,T[5]=-s.x,T[6]=-s.y,T[7]=s.x,T[8]=0;var A,S,v=a.multiply(a.multiply(_,R,D),T,D),N=a.multiply(a.multiply(v,y,L),p,L),G=a.multiplyByVector(v,u,O),W=w(N,e.negate(G,q),0,0,1),X=W.length;if(X>0){for(var V=e.clone(e.ZERO,B),H=Number.NEGATIVE_INFINITY,Y=0;X>Y;++Y){A=a.multiplyByVector(y,a.multiplyByVector(p,W[Y],F),F);var Z=e.normalize(e.subtract(A,u,I),I),j=e.dot(Z,s);j>H&&(H=j,V=e.clone(A,V))}var k=t.cartesianToCartographic(V,z);return H=o.clamp(H,0,1),S=e.magnitude(e.subtract(V,u,I))*Math.sqrt(1-H*H),S=h?-S:S,k.height=S,t.cartographicToCartesian(k,new e)}return void 0};var G=new e;return m.lineSegmentPlane=function(r,t,a,u){if(!n(r))throw new i("endPoint0 is required.");if(!n(t))throw new i("endPoint1 is required.");if(!n(a))throw new i("plane is required.");n(u)||(u=new e);var s=e.subtract(t,r,G),f=a.normal,h=e.dot(f,s);if(Math.abs(h)<o.EPSILON6)return void 0;var d=e.dot(f,r),c=-(a.distance+d)/h;return 0>c||c>1?void 0:(e.multiplyByScalar(s,c,u),e.add(r,u,u),u)},m.trianglePlaneIntersection=function(r,t,o,a){if(!(n(r)&&n(t)&&n(o)&&n(a)))throw new i("p0, p1, p2, and plane are required.");var u=a.normal,s=a.distance,f=e.dot(u,r)+s<0,h=e.dot(u,t)+s<0,d=e.dot(u,o)+s<0,c=0;c+=f?1:0,c+=h?1:0,c+=d?1:0;var l,w;if((1===c||2===c)&&(l=new e,w=new e),1===c){if(f)return m.lineSegmentPlane(r,t,a,l),m.lineSegmentPlane(r,o,a,w),{positions:[r,t,o,l,w],indices:[0,3,4,1,2,4,1,4,3]};if(h)return m.lineSegmentPlane(t,o,a,l),m.lineSegmentPlane(t,r,a,w),{positions:[r,t,o,l,w],indices:[1,3,4,2,0,4,2,4,3]};if(d)return m.lineSegmentPlane(o,r,a,l),m.lineSegmentPlane(o,t,a,w),{positions:[r,t,o,l,w],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===c){if(!f)return m.lineSegmentPlane(t,r,a,l),m.lineSegmentPlane(o,r,a,w),{positions:[r,t,o,l,w],indices:[1,2,4,1,4,3,0,3,4]};if(!h)return m.lineSegmentPlane(o,t,a,l),m.lineSegmentPlane(r,t,a,w),{positions:[r,t,o,l,w],indices:[2,0,4,2,4,3,1,3,4]};if(!d)return m.lineSegmentPlane(r,o,a,l),m.lineSegmentPlane(t,o,a,w),{positions:[r,t,o,l,w],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},m}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,t,n,i){return r(e).then(t,n,i)}function r(e){var r,t;return e instanceof n?r=e:u(e)?(t=a(),e.then(function(e){t.resolve(e)},function(e){t.reject(e)},function(e){t.progress(e)}),r=t.promise):r=i(e),r}function t(r){return e(r,o)}function n(e){this.then=e}function i(e){var t=new n(function(t){try{return r(t?t(e):e)}catch(n){return o(n)}});return t}function o(e){var t=new n(function(t,n){try{return n?r(n(e)):o(e)}catch(i){return o(i)}});return t}function a(){function e(e,r,t){return c(e,r,t)}function t(e){return w(e)}function i(e){return w(o(e))}function u(e){return l(e)}var s,f,h,d,c,l,w;return f=new n(e),s={then:e,resolve:t,reject:i,progress:u,promise:f,resolver:{resolve:t,reject:i,progress:u}},h=[],d=[],c=function(e,r,t){var n,i;return n=a(),i="function"==typeof t?function(e){try{n.progress(t(e))}catch(r){n.progress(r)}}:function(e){n.progress(e)},h.push(function(t){t.then(e,r).then(n.resolve,n.reject,i)}),d.push(i),n.promise},l=function(e){return m(d,e),e},w=function(e){return e=r(e),c=e.then,w=r,l=p,m(h,e),d=h=T,e},s}function u(e){return e&&"function"==typeof e.then}function s(r,t,n,i,o){return E(2,arguments),e(r,function(r){function u(e){m(e)}function s(e){w(e)}var f,h,d,c,l,w,m,E,_,y;if(_=r.length>>>0,f=Math.max(0,Math.min(t,_)),d=[],h=_-f+1,c=[],l=a(),f)for(E=l.progress,m=function(e){c.push(e),--h||(w=m=p,l.reject(c))},w=function(e){d.push(e),--f||(w=m=p,l.resolve(d))},y=0;_>y;++y)y in r&&e(r[y],s,u,E);else l.resolve(d);return l.then(n,i,o)})}function f(e,r,t,n){function i(e){return r?r(e[0]):e[0]}return s(e,1,i,t,n)}function h(e,r,t,n){return E(1,arguments),c(e,_).then(r,t,n)}function d(){return c(arguments,_)}function c(r,t){return e(r,function(r){var n,i,o,u,s,f;if(o=i=r.length>>>0,n=[],f=a(),o)for(u=function(r,i){e(r,t).then(function(e){n[i]=e,--o||f.resolve(n)},f.reject)},s=0;i>s;s++)s in r?u(r[s],s):--o;else f.resolve(n);return f.promise})}function l(r,t){var n=R.call(arguments,1);return e(r,function(r){var i;return i=r.length,n[0]=function(r,n,o){return e(r,function(r){return e(n,function(e){return t(r,e,o,i)})})},y.apply(r,n)})}function w(r,t,n){var i=arguments.length>2;return e(r,function(e){return e=i?n:e,t.resolve(e),e},function(e){return t.reject(e),o(e)},t.progress)}function m(e,r){for(var t,n=0;t=e[n++];)t(r)}function E(e,r){for(var t,n=r.length;n>e;)if(t=r[--n],null!=t&&"function"!=typeof t)throw new Error("arg "+n+" must be a function")}function p(){}function _(e){return e}var y,R,T;return e.defer=a,e.resolve=r,e.reject=t,e.join=d,e.all=h,e.map=c,e.reduce=l,e.any=f,e.some=s,e.chain=w,e.isPromise=u,n.prototype={always:function(e,r){return this.then(e,e,r)},otherwise:function(e){return this.then(T,e)},"yield":function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(r){return h(r,function(r){return e.apply(T,r)})})}},R=[].slice,y=[].reduce||function(e){var r,t,n,i,o;if(o=0,r=Object(this),i=r.length>>>0,t=arguments,t.length<=1)for(;;){if(o in r){n=r[o++];break}if(++o>=i)throw new TypeError}else n=t[1];for(;i>o;++o)o in r&&(n=e(n,r[o],o,r));return n},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./defined","./DeveloperError"],function(e,r){"use strict";var t=function(t,n,i){if(!e(t))throw new r("array is required.");if(!e(n))throw new r("itemToFind is required.");if(!e(i))throw new r("comparator is required.");for(var o,a,u=0,s=t.length-1;s>=u;)if(o=~~((u+s)/2),a=i(t[o],n),0>a)u=o+1;else{if(!(a>0))return o;s=o-1}return~(s+1)};return t}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";var e=function(e,r,t,n,i){this.xPoleWander=e,this.yPoleWander=r,this.xPoleOffset=t,this.yPoleOffset=n,this.ut1MinusUtc=i};return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,r=arguments,t=0,n=r[t++],i=function(e,r,t,n){t||(t=" ");var i=e.length>=r?"":Array(1+r-e.length>>>0).join(t);return n?e+i:i+e},o=function(e,r,t,n,o,a){var u=n-e.length;return u>0&&(e=t||!o?i(e,n,a,t):e.slice(0,r.length)+i("",u,"0",!0)+e.slice(r.length)),e},a=function(e,r,t,n,a,u,s){var f=e>>>0;return t=t&&f&&{2:"0b",8:"0",16:"0x"}[r]||"",e=t+i(f.toString(r),u||0,"0",!1),o(e,t,n,a,s)},u=function(e,r,t,n,i,a){return null!=n&&(e=e.slice(0,n)),o(e,"",r,t,i,a)},s=function(e,n,s,f,h,d,c){var l,w,m,E,p;if("%%"==e)return"%";for(var _=!1,y="",R=!1,T=!1,A=" ",S=s.length,v=0;s&&S>v;v++)switch(s.charAt(v)){case" ":y=" ";break;case"+":y="+";break;case"-":_=!0;break;case"'":A=s.charAt(v+1);break;case"0":R=!0;break;case"#":T=!0}if(f=f?"*"==f?+r[t++]:"*"==f.charAt(0)?+r[f.slice(1,-1)]:+f:0,0>f&&(f=-f,_=!0),!isFinite(f))throw new Error("sprintf: (minimum-)width must be finite");switch(d=d?"*"==d?+r[t++]:"*"==d.charAt(0)?+r[d.slice(1,-1)]:+d:"fFeE".indexOf(c)>-1?6:"d"==c?0:void 0,p=n?r[n.slice(0,-1)]:r[t++],c){case"s":return u(String(p),_,f,d,R,A);case"c":return u(String.fromCharCode(+p),_,f,d,R);case"b":return a(p,2,T,_,f,d,R);case"o":return a(p,8,T,_,f,d,R);case"x":return a(p,16,T,_,f,d,R);case"X":return a(p,16,T,_,f,d,R).toUpperCase();case"u":return a(p,10,T,_,f,d,R);case"i":case"d":return l=+p||0,l=Math.round(l-l%1),w=0>l?"-":y,p=w+i(String(Math.abs(l)),d,"0",!1),o(p,w,_,f,R);case"e":case"E":case"f":case"F":case"g":case"G":return l=+p,w=0>l?"-":y,m=["toExponential","toFixed","toPrecision"]["efg".indexOf(c.toLowerCase())],E=["toString","toUpperCase"]["eEfFgG".indexOf(c)%2],p=w+Math.abs(l)[m](d),o(p,w,_,f,R)[E]();default:return e}};return n.replace(e,s)}return e}),define("Core/GregorianDate",[],function(){"use strict";var e=function(e,r,t,n,i,o,a,u){this.year=e,this.month=r,this.day=t,this.hour=n,this.minute=i,this.second=o,this.millisecond=a,this.isLeapSecond=u};return e}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function r(r){if(null===r||isNaN(r))throw new e("year is required and must be a number.");return r%4===0&&r%100!==0||r%400===0}return r}),define("Core/LeapSecond",[],function(){"use strict";var e=function(e,r){this.julianDate=e,this.offset=r};return e}),define("Core/TimeConstants",["./freezeObject"],function(e){"use strict";var r={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e(r)}),define("Core/TimeStandard",["./freezeObject"],function(e){"use strict";var r={UTC:0,TAI:1};return e(r)}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,r,t,n,i,o,a,u,s,f){"use strict";function h(e,r){return I.compare(e.julianDate,r.julianDate)}function d(e){_.julianDate=e;var t=I.leapSeconds,n=r(t,_,h);0>n&&(n=~n),n>=t.length&&(n=t.length-1);var i=t[n].offset;if(n>0){var o=I.secondsDifference(t[n].julianDate,e);o>i&&(n--,i=t[n].offset)}I.addSeconds(e,i,e)}function c(e,t){_.julianDate=e;var n=I.leapSeconds,i=r(n,_,h);if(0>i&&(i=~i),0===i)return I.addSeconds(e,-n[0].offset,t);if(i>=n.length)return I.addSeconds(e,-n[i-1].offset,t);var o=I.secondsDifference(n[i].julianDate,e);return 0===o?I.addSeconds(e,-n[i].offset,t):1>=o?void 0:I.addSeconds(e,-n[--i].offset,t)}function l(e,r,t){var n=r/s.SECONDS_PER_DAY|0;return e+=n,r-=s.SECONDS_PER_DAY*n,0>r&&(e--,r+=s.SECONDS_PER_DAY),t.dayNumber=e,t.secondsOfDay=r,t}function w(e,r,t,n,i,o,a){var u=(r-14)/12|0,f=e+4800+u,h=(1461*f/4|0)+(367*(r-2-12*u)/12|0)-(3*((f+100)/100|0)/4|0)+t-32075;n-=12,0>n&&(n+=24);var d=o+(n*s.SECONDS_PER_HOUR+i*s.SECONDS_PER_MINUTE+a*s.SECONDS_PER_MILLISECOND);return d>=43200&&(h-=1),[h,d]}var m=new o,E=[31,28,31,30,31,30,31,31,30,31,30,31],p=29,_=new u,y=/^(\d{4})$/,R=/^(\d{4})-(\d{2})$/,T=/^(\d{4})-?(\d{3})$/,A=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,S=/^(\d{4})-?(\d{2})-?(\d{2})$/,v=/([Z+\-])?(\d{2})?:?(\d{2})?$/,N=/^(\d{2})(\.\d+)?/.source+v.source,q=/^(\d{2}):?(\d{2})(\.\d+)?/.source+v.source,g=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+v.source,M="Invalid ISO 8601 date.",I=function(e,r,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=t(e,0),r=t(r,0),n=t(n,f.UTC);var i=0|e;r+=(e-i)*s.SECONDS_PER_DAY,l(i,r,this),n===f.UTC&&d(this)};I.fromDate=function(e,r){if(!(e instanceof Date)||isNaN(e.getTime()))throw new i("date must be a valid JavaScript Date.");var t=w(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(r)?(l(t[0],t[1],r),d(r),r):new I(t[0],t[1],f.UTC)},I.fromIso8601=function(e,r){if("string"!=typeof e)throw new i(M);e=e.replace(",",".");var t,o,u,s=e.split("T"),h=1,c=1,m=0,_=0,v=0,O=0,x=s[0],C=s[1];if(!n(x))throw new i(M);var P;if(s=x.match(S),null!==s){if(P=x.split("-").length-1,P>0&&2!==P)throw new i(M);t=+s[1],h=+s[2],c=+s[3]}else if(s=x.match(R),null!==s)t=+s[1],h=+s[2];else if(s=x.match(y),null!==s)t=+s[1];else{var U;if(s=x.match(T),null!==s){if(t=+s[1],U=+s[2],u=a(t),1>U||u&&U>366||!u&&U>365)throw new i(M)}else{if(s=x.match(A),null===s)throw new i(M);t=+s[1];var b=+s[2],D=+s[3]||0;if(P=x.split("-").length-1,P>0&&(!n(s[3])&&1!==P||n(s[3])&&2!==P))throw new i(M);var L=new Date(Date.UTC(t,0,4));U=7*b+D-L.getUTCDay()-3}o=new Date(Date.UTC(t,0,1)),o.setUTCDate(U),h=o.getUTCMonth()+1,c=o.getUTCDate()}if(u=a(t),1>h||h>12||1>c||(2!==h||!u)&&c>E[h-1]||u&&2===h&&c>p)throw new i(M);var F;if(n(C)){if(s=C.match(g),null!==s){if(P=C.split(":").length-1,P>0&&2!==P&&3!==P)throw new i(M);m=+s[1],_=+s[2],v=+s[3],O=1e3*+(s[4]||0),F=5}else if(s=C.match(q),null!==s){if(P=C.split(":").length-1,P>0&&1!==P)throw new i(M);m=+s[1],_=+s[2],v=60*+(s[3]||0),F=4}else{if(s=C.match(N),null===s)throw new i(M);m=+s[1],_=60*+(s[2]||0),F=3}if(_>=60||v>=61||m>24||24===m&&(_>0||v>0||O>0))throw new i(M);var B=s[F],z=+s[F+1],G=+(s[F+2]||0);switch(B){case"+":m-=z,_-=G;break;case"-":m+=z,_+=G;break;case"Z":break;default:_+=new Date(Date.UTC(t,h-1,c,m,_)).getTimezoneOffset()}}else _+=new Date(t,h-1,c).getTimezoneOffset();var W=60===v;for(W&&v--;_>=60;)_-=60,m++;for(;m>=24;)m-=24,c++;for(o=u&&2===h?p:E[h-1];c>o;)c-=o,h++,h>12&&(h-=12,t++),o=u&&2===h?p:E[h-1];for(;0>_;)_+=60,m--;for(;0>m;)m+=24,c--;for(;1>c;)h--,1>h&&(h+=12,t--),o=u&&2===h?p:E[h-1],c+=o;var X=w(t,h,c,m,_,v,O);return n(r)?(l(X[0],X[1],r),d(r)):r=new I(X[0],X[1],f.UTC),W&&I.addSeconds(r,1,r),r},I.now=function(e){return I.fromDate(new Date,e)};var O=new I(0,0,f.TAI);return I.toGregorianDate=function(e,r){if(!n(e))throw new i("julianDate is required.");var t=!1,a=c(e,O);n(a)||(I.addSeconds(e,-1,O),a=c(O,O),t=!0);var u=a.dayNumber,f=a.secondsOfDay;f>=43200&&(u+=1);var h=u+68569|0,d=4*h/146097|0;h=h-((146097*d+3)/4|0)|0;var l=4e3*(h+1)/1461001|0;h=h-(1461*l/4|0)+31|0;var w=80*h/2447|0,m=h-(2447*w/80|0)|0;h=w/11|0;var E=w+2-12*h|0,p=100*(d-49)+l+h|0,_=f/s.SECONDS_PER_HOUR|0,y=f-_*s.SECONDS_PER_HOUR,R=y/s.SECONDS_PER_MINUTE|0;y-=R*s.SECONDS_PER_MINUTE;var T=0|y,A=(y-T)/s.SECONDS_PER_MILLISECOND;return _+=12,_>23&&(_-=24),t&&(T+=1),n(r)?(r.year=p,r.month=E,r.day=m,r.hour=_,r.minute=R,r.second=T,r.millisecond=A,r.isLeapSecond=t,r):new o(p,E,m,_,R,T,A,t)},I.toDate=function(e){if(!n(e))throw new i("julianDate is required.");var r=I.toGregorianDate(e,m),t=r.second;return r.isLeapSecond&&(t-=1),new Date(Date.UTC(r.year,r.month-1,r.day,r.hour,r.minute,t,r.millisecond))},I.toIso8601=function(r,t){if(!n(r))throw new i("julianDate is required.");var o,a=I.toGregorianDate(r,a);return n(t)||0===a.millisecond?n(t)&&0!==t?(o=(.01*a.millisecond).toFixed(t).replace(".","").slice(0,t),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",a.year,a.month,a.day,a.hour,a.minute,a.second,o)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",a.year,a.month,a.day,a.hour,a.minute,a.second):(o=(.01*a.millisecond).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",a.year,a.month,a.day,a.hour,a.minute,a.second,o))},I.clone=function(e,r){return n(e)?n(r)?(r.dayNumber=e.dayNumber,r.secondsOfDay=e.secondsOfDay,r):new I(e.dayNumber,e.secondsOfDay,f.TAI):void 0},I.compare=function(e,r){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");var t=e.dayNumber-r.dayNumber;return 0!==t?t:e.secondsOfDay-r.secondsOfDay},I.equals=function(e,r){return e===r||n(e)&&n(r)&&e.dayNumber===r.dayNumber&&e.secondsOfDay===r.secondsOfDay},I.equalsEpsilon=function(e,r,t){if(!n(t))throw new i("epsilon is required.");return e===r||n(e)&&n(r)&&Math.abs(I.secondsDifference(e,r))<=t},I.totalDays=function(e){if(!n(e))throw new i("julianDate is required.");return e.dayNumber+e.secondsOfDay/s.SECONDS_PER_DAY},I.secondsDifference=function(e,r){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");var t=(e.dayNumber-r.dayNumber)*s.SECONDS_PER_DAY;return t+(e.secondsOfDay-r.secondsOfDay)},I.daysDifference=function(e,r){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");var t=e.dayNumber-r.dayNumber,o=(e.secondsOfDay-r.secondsOfDay)/s.SECONDS_PER_DAY;return t+o},I.computeTaiMinusUtc=function(e){_.julianDate=e;var t=I.leapSeconds,n=r(t,_,h);return 0>n&&(n=~n,--n,0>n&&(n=0)),t[n].offset},I.addSeconds=function(e,r,t){if(!n(e))throw new i("julianDate is required.");if(!n(r))throw new i("seconds is required.");if(!n(t))throw new i("result is required.");return l(e.dayNumber,e.secondsOfDay+r,t)},I.addMinutes=function(e,r,t){if(!n(e))throw new i("julianDate is required.");if(!n(r))throw new i("minutes is required.");if(!n(t))throw new i("result is required.");var o=e.secondsOfDay+r*s.SECONDS_PER_MINUTE;return l(e.dayNumber,o,t)},I.addHours=function(e,r,t){if(!n(e))throw new i("julianDate is required.");
if(!n(r))throw new i("hours is required.");if(!n(t))throw new i("result is required.");var o=e.secondsOfDay+r*s.SECONDS_PER_HOUR;return l(e.dayNumber,o,t)},I.addDays=function(e,r,t){if(!n(e))throw new i("julianDate is required.");if(!n(r))throw new i("days is required.");if(!n(t))throw new i("result is required.");var o=e.dayNumber+r;return l(o,e.secondsOfDay,t)},I.lessThan=function(e,r){return I.compare(e,r)<0},I.lessThanOrEquals=function(e,r){return I.compare(e,r)<=0},I.greaterThan=function(e,r){return I.compare(e,r)>0},I.greaterThanOrEquals=function(e,r){return I.compare(e,r)>=0},I.prototype.clone=function(e){return I.clone(this,e)},I.prototype.equals=function(e){return I.equals(this,e)},I.prototype.equalsEpsilon=function(e,r){return I.equalsEpsilon(this,e,r)},I.prototype.toString=function(){return I.toIso8601(this)},I.leapSeconds=[new u(new I(2441317,43210,f.TAI),10),new u(new I(2441499,43211,f.TAI),11),new u(new I(2441683,43212,f.TAI),12),new u(new I(2442048,43213,f.TAI),13),new u(new I(2442413,43214,f.TAI),14),new u(new I(2442778,43215,f.TAI),15),new u(new I(2443144,43216,f.TAI),16),new u(new I(2443509,43217,f.TAI),17),new u(new I(2443874,43218,f.TAI),18),new u(new I(2444239,43219,f.TAI),19),new u(new I(2444786,43220,f.TAI),20),new u(new I(2445151,43221,f.TAI),21),new u(new I(2445516,43222,f.TAI),22),new u(new I(2446247,43223,f.TAI),23),new u(new I(2447161,43224,f.TAI),24),new u(new I(2447892,43225,f.TAI),25),new u(new I(2448257,43226,f.TAI),26),new u(new I(2448804,43227,f.TAI),27),new u(new I(2449169,43228,f.TAI),28),new u(new I(2449534,43229,f.TAI),29),new u(new I(2450083,43230,f.TAI),30),new u(new I(2450630,43231,f.TAI),31),new u(new I(2451179,43232,f.TAI),32),new u(new I(2453736,43233,f.TAI),33),new u(new I(2454832,43234,f.TAI),34),new u(new I(2456109,43235,f.TAI),35),new u(new I(2457204,43236,f.TAI),36)],I}),define("Core/clone",["./defaultValue"],function(e){"use strict";var r=function(t,n){if(null===t||"object"!=typeof t)return t;n=e(n,!1);var i=new t.constructor;for(var o in t)if(t.hasOwnProperty(o)){var a=t[o];n&&(a=r(a,n)),i[o]=a}return i};return r}),define("Core/parseResponseHeaders",[],function(){"use strict";var e=function(e){var r={};if(!e)return r;for(var t=e.split("\r\n"),n=0;n<t.length;++n){var i=t[n],o=i.indexOf(": ");if(o>0){var a=i.substring(0,o),u=i.substring(o+2);r[a]=u}}return r};return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,r){"use strict";var t=function(e,t,n){this.statusCode=e,this.response=t,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=r(this.responseHeaders))};return t.prototype.toString=function(){var r="Request has failed.";return e(this.statusCode)&&(r+=" Status Code: "+this.statusCode),r},t}),define("Core/loadWithXhr",["../ThirdParty/when","./defaultValue","./defined","./DeveloperError","./RequestErrorEvent","./RuntimeError"],function(e,r,t,n,i,o){"use strict";function a(e,r){var t=decodeURIComponent(r);return e?atob(t):t}function u(e,r){for(var t=a(e,r),n=new ArrayBuffer(t.length),i=new Uint8Array(n),o=0;o<t.length;o++)i[o]=t.charCodeAt(o);return n}function s(e,t){t=r(t,"");var i=e[1],o=!!e[2],s=e[3];switch(t){case"":case"text":return a(o,s);case"arraybuffer":return u(o,s);case"blob":var f=u(o,s);return new Blob([f],{type:i});case"document":var h=new DOMParser;return h.parseFromString(a(o,s),i);case"json":return JSON.parse(a(o,s));default:throw new n("Unhandled responseType: "+t)}}var f=function(i){if(i=r(i,r.EMPTY_OBJECT),!t(i.url))throw new n("options.url is required.");var o=i.responseType,a=r(i.method,"GET"),u=i.data,s=i.headers,h=i.overrideMimeType;return e(i.url,function(r){var t=e.defer();return f.load(r,o,a,u,s,t,h),t.promise})},h=/^data:(.*?)(;base64)?,(.*)$/;return f.load=function(e,r,n,a,u,f,d){var c=h.exec(e);if(null!==c)return void f.resolve(s(c,r));var l=new XMLHttpRequest;if(t(d)&&t(l.overrideMimeType)&&l.overrideMimeType(d),l.open(n,e,!0),t(u))for(var w in u)u.hasOwnProperty(w)&&l.setRequestHeader(w,u[w]);t(r)&&(l.responseType=r),l.onload=function(){200===l.status?t(l.response)?f.resolve(l.response):t(l.responseXML)&&l.responseXML.hasChildNodes()?f.resolve(l.responseXML):t(l.responseText)?f.resolve(l.responseText):f.reject(new o("unknown XMLHttpRequest response type.")):f.reject(new i(l.status,l.response,l.getAllResponseHeaders()))},l.onerror=function(e){f.reject(new i)},l.send(a)},f.defaultLoad=f.load,f}),define("Core/loadText",["./loadWithXhr"],function(e){"use strict";var r=function(r,t){return e({url:r,headers:t})};return r}),define("Core/loadJson",["./clone","./defined","./DeveloperError","./loadText"],function(e,r,t,n){"use strict";var i={Accept:"application/json,*/*;q=0.01"},o=function(o,a){if(!r(o))throw new t("url is required.");return r(a)?r(a.Accept)||(a=e(a),a.Accept=i.Accept):a=i,n(o,a).then(function(e){return JSON.parse(e)})};return o}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./loadJson","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,r,t,n,i,o,a,u,s,f,h,d){"use strict";function c(e,r){return a.compare(e.julianDate,r)}function l(e,t){if(!n(t.columnNames))return void(e._dataError="Error in loaded EOP data: The columnNames property is required.");if(!n(t.samples))return void(e._dataError="Error in loaded EOP data: The samples property is required.");var i=t.columnNames.indexOf("modifiedJulianDateUtc"),o=t.columnNames.indexOf("xPoleWanderRadians"),s=t.columnNames.indexOf("yPoleWanderRadians"),f=t.columnNames.indexOf("ut1MinusUtcSeconds"),l=t.columnNames.indexOf("xCelestialPoleOffsetRadians"),w=t.columnNames.indexOf("yCelestialPoleOffsetRadians"),m=t.columnNames.indexOf("taiMinusUtcSeconds");if(0>i||0>o||0>s||0>f||0>l||0>w||0>m)return void(e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns");var E=e._samples=t.samples,p=e._dates=[];e._dateColumn=i,e._xPoleWanderRadiansColumn=o,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=f,e._xCelestialPoleOffsetRadiansColumn=l,e._yCelestialPoleOffsetRadiansColumn=w,e._taiMinusUtcSecondsColumn=m,e._columnCount=t.columnNames.length,e._lastIndex=void 0;for(var _,y=e._addNewLeapSeconds,R=0,T=E.length;T>R;R+=e._columnCount){var A=E[R+i],S=E[R+m],v=A+h.MODIFIED_JULIAN_DATE_DIFFERENCE,N=new a(v,S,d.TAI);if(p.push(N),y){if(S!==_&&n(_)){var q=a.leapSeconds,g=r(q,N,c);if(0>g){var M=new u(N,S);q.splice(~g,0,M)}}_=S}}}function w(e,r,t,n,i){var o=t*n;i.xPoleWander=r[o+e._xPoleWanderRadiansColumn],i.yPoleWander=r[o+e._yPoleWanderRadiansColumn],i.xPoleOffset=r[o+e._xCelestialPoleOffsetRadiansColumn],i.yPoleOffset=r[o+e._yCelestialPoleOffsetRadiansColumn],i.ut1MinusUtc=r[o+e._ut1MinusUtcSecondsColumn]}function m(e,r,t){return r+e*(t-r)}function E(e,r,t,n,i,o,u){var s=e._columnCount;if(o>r.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var f=r[i],h=r[o];if(f.equals(h)||n.equals(f))return w(e,t,i,s,u),u;if(n.equals(h))return w(e,t,o,s,u),u;var d=a.secondsDifference(n,f)/a.secondsDifference(h,f),c=i*s,l=o*s,E=t[c+e._ut1MinusUtcSecondsColumn],p=t[l+e._ut1MinusUtcSecondsColumn],_=p-E;if(_>.5||-.5>_){var y=t[c+e._taiMinusUtcSecondsColumn],R=t[l+e._taiMinusUtcSecondsColumn];y!==R&&(h.equals(n)?E=p:p-=R-y)}return u.xPoleWander=m(d,t[c+e._xPoleWanderRadiansColumn],t[l+e._xPoleWanderRadiansColumn]),u.yPoleWander=m(d,t[c+e._yPoleWanderRadiansColumn],t[l+e._yPoleWanderRadiansColumn]),u.xPoleOffset=m(d,t[c+e._xCelestialPoleOffsetRadiansColumn],t[l+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=m(d,t[c+e._yCelestialPoleOffsetRadiansColumn],t[l+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=m(d,E,p),u}var p=function(r){if(r=t(r,t.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=t(r.addNewLeapSeconds,!0),n(r.data))l(this,r.data);else if(n(r.url)){var i=this;this._downloadPromise=e(s(r.url),function(e){l(i,e)},function(){i._dataError="An error occurred while retrieving the EOP data from the URL "+r.url+"."})}else l(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})};return p.NONE=o({getPromiseToLoad:function(){return e()},compute:function(e,r){return n(r)?(r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0):r=new i(0,0,0,0,0),r}}),p.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},p.prototype.compute=function(e,t){if(!n(this._samples)){if(n(this._dataError))throw new f(this._dataError);return void 0}if(n(t)||(t=new i(0,0,0,0,0)),0===this._samples.length)return t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0,t;var o=this._dates,u=this._lastIndex,s=0,h=0;if(n(u)){var d=o[u],c=o[u+1],l=a.lessThanOrEquals(d,e),w=!n(c),m=w||a.greaterThanOrEquals(c,e);if(l&&m)return s=u,!w&&c.equals(e)&&++s,h=s+1,E(this,o,this._samples,e,s,h,t),t}var p=r(o,e,a.compare,this._dateColumn);return p>=0?(p<o.length-1&&o[p+1].equals(e)&&++p,s=p,h=p):(h=~p,s=h-1,0>s&&(s=0)),this._lastIndex=s,E(this,o,this._samples,e,s,h,t),t},p}),define("ThirdParty/Uri",[],function(){function e(r){if(r instanceof e)this.scheme=r.scheme,this.authority=r.authority,this.path=r.path,this.query=r.query,this.fragment=r.fragment;else if(r){var t=n.exec(r);this.scheme=t[1],this.authority=t[2],this.path=t[3],this.query=t[4],this.fragment=t[5]}}function r(e){var r=unescape(e);return o.test(r)?r:e.toUpperCase()}function t(e,r,t,n){return(r||"")+t.toLowerCase()+(n||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var n=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(a,t).replace(i,r)),this.path&&(this.path=this.path.replace(i,r)),this.query&&(this.query=this.query.replace(i,r)),this.fragment&&(this.fragment=this.fragment.replace(i,r))};var i=/%[0-9a-z]{2}/gi,o=/[a-zA-Z0-9\-\._~]/,a=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(r){var t=new e;return this.scheme?(t.scheme=this.scheme,t.authority=this.authority,t.path=this.path,t.query=this.query):(t.scheme=r.scheme,this.authority?(t.authority=this.authority,t.path=this.path,t.query=this.query):(t.authority=r.authority,""==this.path?(t.path=r.path,t.query=this.query||r.query):("/"==this.path.charAt(0)?(t.path=this.path,t.removeDotSegments()):(r.authority&&""==r.path?t.path="/"+this.path:t.path=r.path.substring(0,r.path.lastIndexOf("/")+1)+this.path,t.removeDotSegments()),t.query=this.query))),t.fragment=this.fragment,t},e.prototype.removeDotSegments=function(){var e,r=this.path.split("/"),t=[],n=""==r[0];n&&r.shift();for(""==r[0]?r.shift():null;r.length;)e=r.shift(),".."==e?t.pop():"."!=e&&t.push(e);("."==e||".."==e)&&t.push(""),n&&t.unshift(""),this.path=t.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/buildModuleUrl",["../ThirdParty/Uri","./defined","./DeveloperError","require"],function(e,r,t,n){"use strict";function i(){for(var e=document.getElementsByTagName("script"),r=0,t=e.length;t>r;++r){var n=e[r].getAttribute("src"),i=d.exec(n);if(null!==i)return i[1]}return void 0}function o(){if(r(s))return s;var n;if(n="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:i(),!r(n))throw new t("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return s=new e(n).resolve(new e(document.location.href))}function a(e){return n.toUrl("../"+e)}function u(r){return new e(r).resolve(o()).toString()}var s,f,h,d=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i,c=function(e){r(f)||(f=r(n.toUrl)?a:u),r(h)||(h=document.createElement("a"));var t=f(e);return h.href=t,h.href=h.href,h.href};return c._cesiumScriptRegex=d,c.setBaseUrl=function(r){s=new e(r).resolve(new e(document.location.href))},c}),define("Core/Iau2006XysSample",[],function(){"use strict";var e=function(e,r,t){this.x=e,this.y=r,this.s=t};return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./loadJson","./TimeStandard"],function(e,r,t,n,i,o,a,u){"use strict";function s(e,r,t){var n=d;return n.dayNumber=r,n.secondsOfDay=t,o.daysDifference(n,e._sampleZeroDateTT)}function f(t,i){if(t._chunkDownloadsInProgress[i])return t._chunkDownloadsInProgress[i];var o=e.defer();t._chunkDownloadsInProgress[i]=o;var u,s=t._xysFileUrlTemplate;return u=n(s)?s.replace("{0}",i):r("Assets/IAU2006_XYS/IAU2006_XYS_"+i+".json"),e(a(u),function(e){t._chunkDownloadsInProgress[i]=!1;for(var r=t._samples,n=e.samples,a=i*t._samplesPerXysFile*3,u=0,s=n.length;s>u;++u)r[a+u]=n[u];o.resolve()}),o.promise}var h=function(e){e=t(e,t.EMPTY_OBJECT),this._xysFileUrlTemplate=e.xysFileUrlTemplate,this._interpolationOrder=t(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=t(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new o(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=t(e.stepSizeDays,1),this._samplesPerXysFile=t(e.samplesPerXysFile,1e3),this._totalSamples=t(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var r=this._interpolationOrder,n=this._denominators=new Array(r+1),i=this._xTable=new Array(r+1),a=Math.pow(this._stepSizeDays,r),s=0;r>=s;++s){n[s]=a,i[s]=s*this._stepSizeDays;for(var f=0;r>=f;++f)f!==s&&(n[s]*=s-f);n[s]=1/n[s]}this._work=new Array(r+1),this._coef=new Array(r+1)},d=new o(0,0,u.TAI);return h.prototype.preload=function(r,t,n,i){var o=s(this,r,t),a=s(this,n,i),u=o/this._stepSizeDays-this._interpolationOrder/2|0;0>u&&(u=0);var h=a/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;h>=this._totalSamples&&(h=this._totalSamples-1);for(var d=u/this._samplesPerXysFile|0,c=h/this._samplesPerXysFile|0,l=[],w=d;c>=w;++w)l.push(f(this,w));return e.all(l)},h.prototype.computeXysRadians=function(e,r,t){var o=s(this,e,r);if(0>o)return void 0;var a=o/this._stepSizeDays|0;if(a>=this._totalSamples)return void 0;var u=this._interpolationOrder,h=a-(u/2|0);0>h&&(h=0);var d=h+u;d>=this._totalSamples&&(d=this._totalSamples-1,h=d-u,0>h&&(h=0));var c=!1,l=this._samples;if(n(l[3*h])||(f(this,h/this._samplesPerXysFile|0),c=!0),n(l[3*d])||(f(this,d/this._samplesPerXysFile|0),c=!0),c)return void 0;n(t)?(t.x=0,t.y=0,t.s=0):t=new i(0,0,0);var w,m,E=o-h*this._stepSizeDays,p=this._work,_=this._denominators,y=this._coef,R=this._xTable;for(w=0;u>=w;++w)p[w]=E-R[w];for(w=0;u>=w;++w){for(y[w]=1,m=0;u>=m;++m)m!==w&&(y[w]*=p[m]);y[w]*=_[w];var T=3*(h+w);t.x+=y[w]*l[T++],t.y+=y[w]*l[T++],t.s+=y[w]*l[T]}return t},h}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,r){"use strict";var t,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return r(i,{element:{get:function(){return i.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(t))return t;t=!1;var r=document.body;if("function"==typeof r.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",t=!0;for(var i,o=["webkit","moz","o","ms","khtml"],a=0,u=o.length;u>a;++a){var s=o[a];i=s+"RequestFullscreen","function"==typeof r[i]?(n.requestFullscreen=i,t=!0):(i=s+"RequestFullScreen","function"==typeof r[i]&&(n.requestFullscreen=i,t=!0)),i=s+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=s+"FullscreenEnabled",e(document[i])?n.fullscreenEnabled=i:(i=s+"FullScreenEnabled",e(document[i])&&(n.fullscreenEnabled=i)),i=s+"FullscreenElement",e(document[i])?n.fullscreenElement=i:(i=s+"FullScreenElement",e(document[i])&&(n.fullscreenElement=i)),i=s+"fullscreenchange",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=s+"fullscreenerror",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenError"),n.fullscreenerror=i)}return t},i.requestFullscreen=function(e){i.supportsFullscreen()&&e[n.requestFullscreen]()},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,r,t){"use strict";function n(e){for(var r=e.split("."),t=0,n=r.length;n>t;++t)r[t]=parseInt(r[t],10);return r}function i(){if(!r(E)){E=!1;var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(E=!0,p=n(e[1]))}return E}function o(){return i()&&p}function a(){if(!r(_)&&(_=!1,!i()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(_=!0,y=n(e[1]))}return _}function u(){return a()&&y}function s(){if(!r(R)){R=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==e&&(R=!0,T=n(e[1]),T.isNightly=!!e[2])}return R}function f(){return s()&&T}function h(){if(!r(A)){A=!1;var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(A=!0,S=n(e[1]))):"Netscape"===navigator.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(A=!0,S=n(e[1])))}return A}function d(){return h()&&S}function c(){if(!r(v)){v=!1;var e=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(v=!0,N=n(e[1]))}return v}function l(){return r(q)||(q=/Windows/i.test(navigator.appVersion)),q}function w(){return c()&&N}function m(){return r(g)||(g=r(window.PointerEvent)&&(!r(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),g}var E,p,_,y,R,T,A,S,v,N,q,g,M={isChrome:i,chromeVersion:o,isSafari:a,safariVersion:u,isWebkit:s,webkitVersion:f,isInternetExplorer:h,internetExplorerVersion:d,isFirefox:c,firefoxVersion:w,isWindows:l,hardwareConcurrency:e(navigator.hardwareConcurrency,3),supportsPointerEvents:m};return M.supportsFullscreen=function(){return t.supportsFullscreen()},M.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},M.supportsWebWorkers=function(){return"undefined"!=typeof Worker},M}),define("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,r,t,n,i,o,a,u){"use strict";var s=function(e,t,n,i){this.x=r(e,0),this.y=r(t,0),this.z=r(n,0),this.w=r(i,0)},f=new e;s.fromAxisAngle=function(r,i,o){if(!t(r))throw new n("axis is required.");if("number"!=typeof i)throw new n("angle is required and must be a number.");var a=i/2,u=Math.sin(a);f=e.normalize(r,f);var h=f.x*u,d=f.y*u,c=f.z*u,l=Math.cos(a);return t(o)?(o.x=h,o.y=d,o.z=c,o.w=l,o):new s(h,d,c,l)};var h=[1,2,0],d=new Array(3);s.fromRotationMatrix=function(e,r){if(!t(e))throw new n("matrix is required.");var i,o,a,f,c,l=e[u.COLUMN0ROW0],w=e[u.COLUMN1ROW1],m=e[u.COLUMN2ROW2],E=l+w+m;if(E>0)i=Math.sqrt(E+1),c=.5*i,i=.5/i,o=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*i,a=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*i,f=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*i;else{var p=h,_=0;w>l&&(_=1),m>l&&m>w&&(_=2);var y=p[_],R=p[y];i=Math.sqrt(e[u.getElementIndex(_,_)]-e[u.getElementIndex(y,y)]-e[u.getElementIndex(R,R)]+1);var T=d;T[_]=.5*i,i=.5/i,c=(e[u.getElementIndex(R,y)]-e[u.getElementIndex(y,R)])*i,T[y]=(e[u.getElementIndex(y,_)]+e[u.getElementIndex(_,y)])*i,T[R]=(e[u.getElementIndex(R,_)]+e[u.getElementIndex(_,R)])*i,o=-T[0],a=-T[1],f=-T[2]}return t(r)?(r.x=o,r.y=a,r.z=f,r.w=c,r):new s(o,a,f,c)};var c=new s;s.fromHeadingPitchRoll=function(r,i,o,a){if(!t(r))throw new n("heading is required.");if(!t(i))throw new n("pitch is required.");if(!t(o))throw new n("roll is required.");var u=s.fromAxisAngle(e.UNIT_X,o,c),f=s.fromAxisAngle(e.UNIT_Y,-i,a);a=s.multiply(f,u,f);var h=s.fromAxisAngle(e.UNIT_Z,-r,c);return s.multiply(h,a,a)};var l=new e,w=new e,m=new s,E=new s,p=new s;s.packedLength=4,s.pack=function(e,i,o){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");o=r(o,0),i[o++]=e.x,i[o++]=e.y,i[o++]=e.z,i[o]=e.w},s.unpack=function(e,i,o){if(!t(e))throw new n("array is required");return i=r(i,0),t(o)||(o=new s),o.x=e[i],o.y=e[i+1],o.z=e[i+2],o.w=e[i+3],o},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,r,t,n){s.unpack(e,4*t,p),s.conjugate(p,p);for(var i=0,o=t-r+1;o>i;i++){var a=3*i;s.unpack(e,4*(r+i),m),s.multiply(m,p,m),m.w<0&&s.negate(m,m),s.computeAxis(m,l);var u=s.computeAngle(m);n[a]=l.x*u,n[a+1]=l.y*u,n[a+2]=l.z*u}},s.unpackInterpolationResult=function(r,n,i,o,a){t(a)||(a=new s),e.fromArray(r,0,w);var u=e.magnitude(w);return s.unpack(n,4*o,E),0===u?s.clone(s.IDENTITY,m):s.fromAxisAngle(w,u,m),s.multiply(m,E,a)},s.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,r){if(!t(e))throw new n("quaternion is required");if(!t(r))throw new n("result is required");return r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=e.w,r},s.magnitudeSquared=function(e){if(!t(e))throw new n("quaternion is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,r){if(!t(r))throw new n("result is required");var i=1/s.magnitude(e),o=e.x*i,a=e.y*i,u=e.z*i,f=e.w*i;return r.x=o,r.y=a,r.z=u,r.w=f,r},s.inverse=function(e,r){if(!t(r))throw new n("result is required");var i=s.magnitudeSquared(e);return r=s.conjugate(e,r),s.multiplyByScalar(r,1/i,r)},s.add=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i.x=e.x+r.x,i.y=e.y+r.y,i.z=e.z+r.z,i.w=e.w+r.w,i},s.subtract=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i.x=e.x-r.x,i.y=e.y-r.y,i.z=e.z-r.z,i.w=e.w-r.w,i},s.negate=function(e,r){if(!t(e))throw new n("quaternion is required");if(!t(r))throw new n("result is required");return r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r},s.dot=function(e,r){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");return e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w},s.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");var o=e.x,a=e.y,u=e.z,s=e.w,f=r.x,h=r.y,d=r.z,c=r.w,l=s*f+o*c+a*d-u*h,w=s*h-o*d+a*c+u*f,m=s*d+o*h-a*f+u*c,E=s*c-o*f-a*h-u*d;return i.x=l,i.y=w,i.z=m,i.w=E,i},s.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("quaternion is required");if("number"!=typeof r)throw new n("scalar is required and must be a number.");if(!t(i))throw new n("result is required");return i.x=e.x*r,i.y=e.y*r,i.z=e.z*r,i.w=e.w*r,i},s.divideByScalar=function(e,r,i){if(!t(e))throw new n("quaternion is required");if("number"!=typeof r)throw new n("scalar is required and must be a number.");if(!t(i))throw new n("result is required");return i.x=e.x/r,i.y=e.y/r,i.z=e.z/r,i.w=e.w/r,i},s.computeAxis=function(e,r){if(!t(e))throw new n("quaternion is required");if(!t(r))throw new n("result is required");var i=e.w;if(Math.abs(i-1)<a.EPSILON6)return r.x=r.y=r.z=0,r;var o=1/Math.sqrt(1-i*i);return r.x=e.x*o,r.y=e.y*o,r.z=e.z*o,r},s.computeAngle=function(e){if(!t(e))throw new n("quaternion is required");return Math.abs(e.w-1)<a.EPSILON6?0:2*Math.acos(e.w)};var _=new s;s.lerp=function(e,r,i,o){if(!t(e))throw new n("start is required.");if(!t(r))throw new n("end is required.");if("number"!=typeof i)throw new n("t is required and must be a number.");if(!t(o))throw new n("result is required");return _=s.multiplyByScalar(r,i,_),o=s.multiplyByScalar(e,1-i,o),s.add(_,o,o)};var y=new s,R=new s,T=new s;s.slerp=function(e,r,i,o){if(!t(e))throw new n("start is required.");if(!t(r))throw new n("end is required.");if("number"!=typeof i)throw new n("t is required and must be a number.");if(!t(o))throw new n("result is required");var u=s.dot(e,r),f=r;if(0>u&&(u=-u,f=y=s.negate(r,y)),1-u<a.EPSILON6)return s.lerp(e,f,i,o);var h=Math.acos(u);return R=s.multiplyByScalar(e,Math.sin((1-i)*h),R),T=s.multiplyByScalar(f,Math.sin(i*h),T),o=s.add(R,T,o),s.multiplyByScalar(o,1/Math.sin(h),o)},s.log=function(r,i){if(!t(r))throw new n("quaternion is required.");if(!t(i))throw new n("result is required");var o=a.acosClamped(r.w),u=0;return 0!==o&&(u=o/Math.sin(o)),e.multiplyByScalar(r,u,i)},s.exp=function(r,i){if(!t(r))throw new n("cartesian is required.");if(!t(i))throw new n("result is required");var o=e.magnitude(r),a=0;return 0!==o&&(a=Math.sin(o)/o),i.x=r.x*a,i.y=r.y*a,i.z=r.z*a,i.w=Math.cos(o),i};var A=new e,S=new e,v=new s,N=new s;s.computeInnerQuadrangle=function(r,i,o,a){if(!t(r)||!t(i)||!t(o))throw new n("q0, q1, and q2 are required.");if(!t(a))throw new n("result is required");var u=s.conjugate(i,v);s.multiply(u,o,N);var f=s.log(N,A);s.multiply(u,r,N);var h=s.log(N,S);return e.add(f,h,f),e.multiplyByScalar(f,.25,f),e.negate(f,f),s.exp(f,v),s.multiply(i,v,a)},s.squad=function(e,r,i,o,a,u){if(!(t(e)&&t(r)&&t(i)&&t(o)))throw new n("q0, q1, s0, and s1 are required.");if("number"!=typeof a)throw new n("t is required and must be a number.");if(!t(u))throw new n("result is required");var f=s.slerp(e,r,a,v),h=s.slerp(i,o,a,N);return s.slerp(f,h,2*a*(1-a),u)};for(var q=new s,g=1.9011074535173003,M=i.supportsTypedArrays()?new Float32Array(8):[],I=i.supportsTypedArrays()?new Float32Array(8):[],O=i.supportsTypedArrays()?new Float32Array(8):[],x=i.supportsTypedArrays()?new Float32Array(8):[],C=0;7>C;++C){var P=C+1,U=2*P+1;M[C]=1/(P*U),I[C]=P/U}return M[7]=g/136,I[7]=8*g/17,s.fastSlerp=function(e,r,i,o){if(!t(e))throw new n("start is required.");if(!t(r))throw new n("end is required.");if("number"!=typeof i)throw new n("t is required and must be a number.");if(!t(o))throw new n("result is required");var a,u=s.dot(e,r);u>=0?a=1:(a=-1,u=-u);for(var f=u-1,h=1-i,d=i*i,c=h*h,l=7;l>=0;--l)O[l]=(M[l]*d-I[l])*f,x[l]=(M[l]*c-I[l])*f;var w=a*i*(1+O[0]*(1+O[1]*(1+O[2]*(1+O[3]*(1+O[4]*(1+O[5]*(1+O[6]*(1+O[7])))))))),m=h*(1+x[0]*(1+x[1]*(1+x[2]*(1+x[3]*(1+x[4]*(1+x[5]*(1+x[6]*(1+x[7])))))))),E=s.multiplyByScalar(e,m,q);return s.multiplyByScalar(r,w,o),s.add(E,o,o)},s.fastSquad=function(e,r,i,o,a,u){if(!(t(e)&&t(r)&&t(i)&&t(o)))throw new n("q0, q1, s0, and s1 are required.");if("number"!=typeof a)throw new n("t is required and must be a number.");if(!t(u))throw new n("result is required");var f=s.fastSlerp(e,r,a,v),h=s.fastSlerp(i,o,a,N);return s.fastSlerp(f,h,2*a*(1-a),u)},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},s.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon is required and must be a number.");return e===r||t(e)&&t(r)&&Math.abs(e.x-r.x)<=i&&Math.abs(e.y-r.y)<=i&&Math.abs(e.z-r.z)<=i&&Math.abs(e.w-r.w)<=i},s.ZERO=o(new s(0,0,0,0)),s.IDENTITY=o(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,r){return s.equalsEpsilon(this,e,r)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],function(e,r,t,n,i,o,a,u,s,f,h,d,c,l,w,m,E,p){"use strict";var _={},y=new t,R=new t,T=new t;_.eastNorthUpToFixedFrame=function(e,r,n){if(!o(e))throw new a("origin is required.");if(l.equalsEpsilon(e.x,0,l.EPSILON14)&&l.equalsEpsilon(e.y,0,l.EPSILON14)){var u=l.sign(e.z);return o(n)?(n[0]=0,n[1]=1,n[2]=0,n[3]=0,n[4]=-u,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=u,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(0,-u,0,e.x,1,0,0,e.y,0,0,u,e.z,0,0,0,1)}var s=y,h=R,d=T;return r=i(r,f.WGS84),r.geodeticSurfaceNormal(e,s),h.x=-e.y,h.y=e.x,h.z=0,t.normalize(h,h),t.cross(s,h,d),o(n)?(n[0]=h.x,n[1]=h.y,n[2]=h.z,n[3]=0,n[4]=d.x,n[5]=d.y,n[6]=d.z,n[7]=0,n[8]=s.x,n[9]=s.y,n[10]=s.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(h.x,d.x,s.x,e.x,h.y,d.y,s.y,e.y,h.z,d.z,s.z,e.z,0,0,0,1)};var A=new t,S=new t,v=new t;_.northEastDownToFixedFrame=function(e,r,n){if(!o(e))throw new a("origin is required.");if(l.equalsEpsilon(e.x,0,l.EPSILON14)&&l.equalsEpsilon(e.y,0,l.EPSILON14)){var u=l.sign(e.z);return o(n)?(n[0]=-u,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=1,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=-u,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(-u,0,0,e.x,0,1,0,e.y,0,0,-u,e.z,0,0,0,1)}var s=A,h=S,d=v;return r=i(r,f.WGS84),r.geodeticSurfaceNormal(e,s),h.x=-e.y,h.y=e.x,h.z=0,t.normalize(h,h),t.cross(s,h,d),o(n)?(n[0]=d.x,n[1]=d.y,n[2]=d.z,n[3]=0,n[4]=h.x,n[5]=h.y,n[6]=h.z,n[7]=0,n[8]=-s.x,n[9]=-s.y,n[10]=-s.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(d.x,h.x,-s.x,e.x,d.y,h.y,-s.y,e.y,d.z,h.z,-s.z,e.z,0,0,0,1)},_.northUpEastToFixedFrame=function(e,r,n){if(!o(e))throw new a("origin is required.");if(l.equalsEpsilon(e.x,0,l.EPSILON14)&&l.equalsEpsilon(e.y,0,l.EPSILON14)){var u=l.sign(e.z);return o(n)?(n[0]=-u,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=u,n[7]=0,n[8]=0,n[9]=1,n[10]=0,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(-u,0,0,e.x,0,0,1,e.y,0,u,0,e.z,0,0,0,1)}var s=y,h=R,d=T;return r=i(r,f.WGS84),r.geodeticSurfaceNormal(e,s),h.x=-e.y,h.y=e.x,h.z=0,t.normalize(h,h),t.cross(s,h,d),o(n)?(n[0]=d.x,n[1]=d.y,n[2]=d.z,n[3]=0,n[4]=s.x,n[5]=s.y,n[6]=s.z,n[7]=0,n[8]=h.x,n[9]=h.y,n[10]=h.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(d.x,s.x,h.x,e.x,d.y,s.y,h.y,e.y,d.z,s.z,h.z,e.z,0,0,0,1)};var N=new E,q=new t(1,1,1),g=new m;_.headingPitchRollToFixedFrame=function(e,r,n,i,o,a){var u=E.fromHeadingPitchRoll(r,n,i,N),s=m.fromTranslationQuaternionRotationScale(t.ZERO,u,q,g);return a=_.eastNorthUpToFixedFrame(e,o,a),m.multiply(a,s,a);
};var M=new m,I=new w;_.headingPitchRollQuaternion=function(e,r,t,n,i,o){var a=_.headingPitchRollToFixedFrame(e,r,t,n,i,M),u=m.getRotation(a,I);return E.fromRotationMatrix(u,o)};var O=24110.54841,x=8640184.812866,C=.093104,P=-62e-7,U=1.1772758384668e-19,b=72921158553e-15,D=l.TWO_PI/86400,L=new c;_.computeTemeToPseudoFixedMatrix=function(e,r){if(!o(e))throw new a("date is required.");L=c.addSeconds(e,-c.computeTaiMinusUtc(e),L);var t,n=L.dayNumber,i=L.secondsOfDay,u=n-2451545;t=i>=43200?(u+.5)/p.DAYS_PER_JULIAN_CENTURY:(u-.5)/p.DAYS_PER_JULIAN_CENTURY;var s=O+t*(x+t*(C+t*P)),f=s*D%l.TWO_PI,h=b+U*(n-2451545.5),d=(i+.5*p.SECONDS_PER_DAY)%p.SECONDS_PER_DAY,m=f+h*d,E=Math.cos(m),_=Math.sin(m);return o(r)?(r[0]=E,r[1]=-_,r[2]=0,r[3]=_,r[4]=E,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new w(E,_,0,-_,E,0,0,0,1)},_.iau2006XysData=new h,_.earthOrientationParameters=u.NONE;var F=32.184,B=2451545;_.preloadIcrfFixed=function(r){var t=r.start.dayNumber,n=r.start.secondsOfDay+F,i=r.stop.dayNumber,o=r.stop.secondsOfDay+F,a=_.iau2006XysData.preload(t,n,i,o),u=_.earthOrientationParameters.getPromiseToLoad();return e.all([a,u])},_.computeIcrfToFixedMatrix=function(e,r){if(!o(e))throw new a("date is required.");o(r)||(r=new w);var t=_.computeFixedToIcrfMatrix(e,r);return o(t)?w.transpose(t,r):void 0};var z=new d(0,0,0),G=new s(0,0,0,0,0,0),W=new w,X=new w;_.computeFixedToIcrfMatrix=function(e,r){if(!o(e))throw new a("date is required.");o(r)||(r=new w);var t=_.earthOrientationParameters.compute(e,G);if(!o(t))return void 0;var n=e.dayNumber,i=e.secondsOfDay+F,u=_.iau2006XysData.computeXysRadians(n,i,z);if(!o(u))return void 0;var s=u.x+t.xPoleOffset,f=u.y+t.yPoleOffset,h=1/(1+Math.sqrt(1-s*s-f*f)),d=W;d[0]=1-h*s*s,d[3]=-h*s*f,d[6]=s,d[1]=-h*s*f,d[4]=1-h*f*f,d[7]=f,d[2]=-s,d[5]=-f,d[8]=1-h*(s*s+f*f);var m=w.fromRotationZ(-u.s,X),E=w.multiply(d,m,W),y=e.dayNumber,R=e.secondsOfDay-c.computeTaiMinusUtc(e)+t.ut1MinusUtc,T=y-2451545,A=R/p.SECONDS_PER_DAY,S=.779057273264+A+.00273781191135448*(T+A);S=S%1*l.TWO_PI;var v=w.fromRotationZ(S,X),N=w.multiply(E,v,W),q=Math.cos(t.xPoleWander),g=Math.cos(t.yPoleWander),M=Math.sin(t.xPoleWander),I=Math.sin(t.yPoleWander),O=n-B+i/p.SECONDS_PER_DAY;O/=36525;var x=-47e-6*O*l.RADIANS_PER_DEGREE/3600,C=Math.cos(x),P=Math.sin(x),U=X;return U[0]=q*C,U[1]=q*P,U[2]=M,U[3]=-g*P+I*M*C,U[4]=g*C+I*M*P,U[5]=-I*q,U[6]=-I*P-g*M*C,U[7]=I*C-g*M*P,U[8]=g*q,w.multiply(N,U,r)};var V=new n;_.pointToWindowCoordinates=function(e,r,t,n){return n=_.pointToGLWindowCoordinates(e,r,t,n),n.y=2*r[5]-n.y,n},_.pointToGLWindowCoordinates=function(e,t,i,u){if(!o(e))throw new a("modelViewProjectionMatrix is required.");if(!o(t))throw new a("viewportTransformation is required.");if(!o(i))throw new a("point is required.");o(u)||(u=new r);var s=V;return m.multiplyByVector(e,n.fromElements(i.x,i.y,i.z,1,s),s),n.multiplyByScalar(s,1/s.w,s),m.multiplyByVector(t,s,s),r.fromCartesian4(s,u)};var H=new t,Y=new t,Z=new t;return _.rotationMatrixFromPositionVelocity=function(e,r,n,u){if(!o(e))throw new a("position is required.");if(!o(r))throw new a("velocity is required.");var s=i(n,f.WGS84).geodeticSurfaceNormal(e,H),h=t.cross(r,s,Y);t.equalsEpsilon(h,t.ZERO,l.EPSILON6)&&(h=t.clone(t.UNIT_X,h));var d=t.cross(h,r,Z);return t.cross(r,d,h),t.negate(h,h),o(u)||(u=new w),u[0]=r.x,u[1]=r.y,u[2]=r.z,u[3]=h.x,u[4]=h.y,u[5]=h.z,u[6]=d.x,u[7]=d.y,u[8]=d.z,u},_}),define("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix3","./Matrix4","./Plane","./Ray","./Transforms"],function(e,r,t,n,i,o,a,u,s,f,h,d,c,l,w){"use strict";var m=new n,E=function(e,r){if(!o(e))throw new u("origin is required.");if(r=i(r,s.WGS84),e=r.scaleToGeodeticSurface(e),!o(e))throw new u("origin must not be at the center of the ellipsoid.");var n=w.eastNorthUpToFixedFrame(e,r);this._ellipsoid=r,this._origin=e,this._xAxis=t.fromCartesian4(d.getColumn(n,0,m)),this._yAxis=t.fromCartesian4(d.getColumn(n,1,m));var a=t.fromCartesian4(d.getColumn(n,2,m));this._plane=c.fromPointNormal(e,a)};a(E.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}},plane:{get:function(){return this._plane}},xAxis:{get:function(){return this._xAxis}},yAxis:{get:function(){return this._yAxis}},zAxis:{get:function(){return this._plane.normal}}});var p=new e;E.fromPoints=function(r,t){if(!o(r))throw new u("cartesians is required.");var n=e.fromPoints(r,p);return new E(n.center,t)};var _=new l,y=new t;E.prototype.projectPointOntoPlane=function(e,n){if(!o(e))throw new u("cartesian is required.");var i=_;i.origin=e,t.normalize(e,i.direction);var a=f.rayPlane(i,this._plane,y);if(o(a)||(t.negate(i.direction,i.direction),a=f.rayPlane(i,this._plane,y)),o(a)){var s=t.subtract(a,this._origin,a),h=t.dot(this._xAxis,s),d=t.dot(this._yAxis,s);return o(n)?(n.x=h,n.y=d,n):new r(h,d)}return void 0},E.prototype.projectPointsOntoPlane=function(e,r){if(!o(e))throw new u("cartesians is required.");o(r)||(r=[]);for(var t=0,n=e.length,i=0;n>i;i++){var a=this.projectPointOntoPlane(e[i],r[t]);o(a)&&(r[t]=a,t++)}return r.length=t,r},E.prototype.projectPointToNearestOnPlane=function(e,n){if(!o(e))throw new u("cartesian is required.");o(n)||(n=new r);var i=_;i.origin=e,t.clone(this._plane.normal,i.direction);var a=f.rayPlane(i,this._plane,y);o(a)||(t.negate(i.direction,i.direction),a=f.rayPlane(i,this._plane,y));var s=t.subtract(a,this._origin,a),h=t.dot(this._xAxis,s),d=t.dot(this._yAxis,s);return n.x=h,n.y=d,n},E.prototype.projectPointsToNearestOnPlane=function(e,r){if(!o(e))throw new u("cartesians is required.");o(r)||(r=[]);var t=e.length;r.length=t;for(var n=0;t>n;n++)r[n]=this.projectPointToNearestOnPlane(e[n],r[n]);return r};var R=new t;return E.prototype.projectPointsOntoEllipsoid=function(e,r){if(!o(e))throw new u("cartesians is required.");var n=e.length;o(r)?r.length=n:r=new Array(n);for(var i=this._ellipsoid,a=this._origin,s=this._xAxis,f=this._yAxis,h=R,d=0;n>d;++d){var c=e[d];t.multiplyByScalar(s,c.x,h),o(r[d])||(r[d]=new t);var l=t.add(a,h,r[d]);t.multiplyByScalar(f,c.y,h),t.add(l,h,l),i.scaleToGeocentricSurface(l,l)}return r},E}),define("Core/OrientedBoundingBox",["./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Intersect","./Interval","./Math","./Matrix3","./Plane","./Rectangle"],function(e,r,t,n,i,o,a,u,s,f,h,d,c,l,w){"use strict";var m=function(e,r){this.center=t.clone(i(e,t.ZERO)),this.halfAxes=c.clone(i(r,c.ZERO))},E=new t,p=new t,_=new t,y=new t,R=new t,T=new c,A={unitary:new c,diagonal:new c};m.fromPoints=function(e,r){if(o(r)||(r=new m),!o(e)||0===e.length)return r.halfAxes=c.ZERO,r.center=t.ZERO,r;var n,i=e.length,a=t.clone(e[0],E);for(n=1;i>n;n++)t.add(a,e[n],a);var u=1/i;t.multiplyByScalar(a,u,a);var s,f=0,h=0,d=0,l=0,w=0,S=0;for(n=0;i>n;n++)s=t.subtract(e[n],a,p),f+=s.x*s.x,h+=s.x*s.y,d+=s.x*s.z,l+=s.y*s.y,w+=s.y*s.z,S+=s.z*s.z;f*=u,h*=u,d*=u,l*=u,w*=u,S*=u;var v=T;v[0]=f,v[1]=h,v[2]=d,v[3]=h,v[4]=l,v[5]=w,v[6]=d,v[7]=w,v[8]=S;var N=c.computeEigenDecomposition(v,A),q=c.transpose(N.unitary,r.halfAxes);s=t.subtract(e[0],a,p);var g=c.multiplyByVector(q,s,_),M=t.clone(g,y),I=t.clone(g,R);for(n=1;i>n;n++)s=t.subtract(e[n],a,s),c.multiplyByVector(q,s,g),t.minimumByComponent(I,g,I),t.maximumByComponent(M,g,M);var O=t.add(I,M,_);t.multiplyByScalar(O,.5,O),c.multiplyByVector(q,O,O),t.add(a,O,r.center);var x=t.subtract(M,I,_);return t.multiplyByScalar(x,.5,x),c.multiplyByScale(r.halfAxes,x,r.halfAxes),r};var S=new t,v=new t,N=function(e,r,n,i,u,s,f,h){if(!(o(r)&&o(n)&&o(i)&&o(u)&&o(s)&&o(f)))throw new a("all extents (minimum/maximum X/Y/Z) are required.");o(h)||(h=new m);var d=h.halfAxes;c.setColumn(d,0,e.xAxis,d),c.setColumn(d,1,e.yAxis,d),c.setColumn(d,2,e.zAxis,d);var l=S;l.x=(r+n)/2,l.y=(i+u)/2,l.z=(s+f)/2;var w=v;w.x=(n-r)/2,w.y=(u-i)/2,w.z=(f-s)/2;var E=h.center;return l=c.multiplyByVector(d,l,l),t.add(e.origin,l,E),c.multiplyByScale(d,w,d),h},q=new n,g=new t,M=[new n,new n,new n,new n,new n,new n,new n,new n],I=[new t,new t,new t,new t,new t,new t,new t,new t],O=[new r,new r,new r,new r,new r,new r,new r,new r];m.fromRectangle=function(e,r,t,n,f){if(!o(e))throw new a("rectangle is required");if(e.width<0||e.width>d.PI)throw new a("Rectangle width must be between 0 and pi");if(e.height<0||e.height>d.PI)throw new a("Rectangle height must be between 0 and pi");if(o(n)&&!d.equalsEpsilon(n.radii.x,n.radii.y,d.EPSILON15))throw new a("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");r=i(r,0),t=i(t,0),n=i(n,u.WGS84);var h=w.center(e,q),c=n.cartographicToCartesian(h,g),m=new s(c,n),E=m.plane,p=M[0],_=M[1],y=M[2],R=M[3],T=M[4],A=M[5],S=M[6],v=M[7],x=h.longitude,C=e.south<0&&e.north>0?0:h.latitude;S.latitude=A.latitude=T.latitude=e.south,v.latitude=R.latitude=C,p.latitude=_.latitude=y.latitude=e.north,S.longitude=v.longitude=p.longitude=e.west,A.longitude=_.longitude=x,T.longitude=R.longitude=y.longitude=e.east,y.height=_.height=p.height=v.height=S.height=A.height=T.height=R.height=t,n.cartographicArrayToCartesianArray(M,I),m.projectPointsToNearestOnPlane(I,O);var P=Math.min(O[6].x,O[7].x,O[0].x),U=Math.max(O[2].x,O[3].x,O[4].x),b=Math.min(O[4].y,O[5].y,O[6].y),D=Math.max(O[0].y,O[1].y,O[2].y);y.height=p.height=T.height=S.height=r,n.cartographicArrayToCartesianArray(M,I);var L=Math.min(l.getPointDistance(E,I[0]),l.getPointDistance(E,I[2]),l.getPointDistance(E,I[4]),l.getPointDistance(E,I[6])),F=t;return N(m,P,U,b,D,L,F,f)},m.clone=function(e,r){return o(e)?o(r)?(t.clone(e.center,r.center),c.clone(e.halfAxes,r.halfAxes),r):new m(e.center,e.halfAxes):void 0},m.intersectPlane=function(e,r){if(!o(e))throw new a("box is required.");if(!o(r))throw new a("plane is required.");var n=e.center,i=r.normal,u=e.halfAxes,s=i.x,h=i.y,d=i.z,l=Math.abs(s*u[c.COLUMN0ROW0]+h*u[c.COLUMN0ROW1]+d*u[c.COLUMN0ROW2])+Math.abs(s*u[c.COLUMN1ROW0]+h*u[c.COLUMN1ROW1]+d*u[c.COLUMN1ROW2])+Math.abs(s*u[c.COLUMN2ROW0]+h*u[c.COLUMN2ROW1]+d*u[c.COLUMN2ROW2]),w=t.dot(i,n)+r.distance;return-l>=w?f.OUTSIDE:w>=l?f.INSIDE:f.INTERSECTING};var x=new t,C=new t,P=new t,U=new t;m.distanceSquaredTo=function(e,r){if(!o(e))throw new a("box is required.");if(!o(r))throw new a("cartesian is required.");var n=t.subtract(r,e.center,S),i=e.halfAxes,u=c.getColumn(i,0,x),s=c.getColumn(i,1,C),f=c.getColumn(i,2,P),h=t.magnitude(u),d=t.magnitude(s),l=t.magnitude(f);t.normalize(u,u),t.normalize(s,s),t.normalize(f,f);var w=U;w.x=t.dot(n,u),w.y=t.dot(n,s),w.z=t.dot(n,f);var m,E=0;return w.x<-h?(m=w.x+h,E+=m*m):w.x>h&&(m=w.x-h,E+=m*m),w.y<-d?(m=w.y+d,E+=m*m):w.y>d&&(m=w.y-d,E+=m*m),w.z<-l?(m=w.z+l,E+=m*m):w.z>l&&(m=w.z-l,E+=m*m),E};var b=new t,D=new t;new t;m.computePlaneDistances=function(e,r,n,i){if(!o(e))throw new a("box is required.");if(!o(r))throw new a("position is required.");if(!o(n))throw new a("direction is required.");o(i)||(i=new h);var u=Number.POSITIVE_INFINITY,s=Number.NEGATIVE_INFINITY,f=e.center,d=e.halfAxes,l=c.getColumn(d,0,x),w=c.getColumn(d,1,C),m=c.getColumn(d,2,P),E=t.add(l,w,b);t.add(E,m,E),t.add(E,f,E);var p=t.subtract(E,r,D),_=t.dot(n,p);return u=Math.min(_,u),s=Math.max(_,s),t.add(f,l,E),t.add(E,w,E),t.subtract(E,m,E),t.subtract(E,r,p),_=t.dot(n,p),u=Math.min(_,u),s=Math.max(_,s),t.add(f,l,E),t.subtract(E,w,E),t.add(E,m,E),t.subtract(E,r,p),_=t.dot(n,p),u=Math.min(_,u),s=Math.max(_,s),t.add(f,l,E),t.subtract(E,w,E),t.subtract(E,m,E),t.subtract(E,r,p),_=t.dot(n,p),u=Math.min(_,u),s=Math.max(_,s),t.subtract(f,l,E),t.add(E,w,E),t.add(E,m,E),t.subtract(E,r,p),_=t.dot(n,p),u=Math.min(_,u),s=Math.max(_,s),t.subtract(f,l,E),t.add(E,w,E),t.subtract(E,m,E),t.subtract(E,r,p),_=t.dot(n,p),u=Math.min(_,u),s=Math.max(_,s),t.subtract(f,l,E),t.subtract(E,w,E),t.add(E,m,E),t.subtract(E,r,p),_=t.dot(n,p),u=Math.min(_,u),s=Math.max(_,s),t.subtract(f,l,E),t.subtract(E,w,E),t.subtract(E,m,E),t.subtract(E,r,p),_=t.dot(n,p),u=Math.min(_,u),s=Math.max(_,s),i.start=u,i.stop=s,i};var L=new e;return m.isOccluded=function(e,r){if(!o(e))throw new a("box is required.");if(!o(r))throw new a("occluder is required.");var n=e.halfAxes,i=c.getColumn(n,0,x),u=c.getColumn(n,1,C),s=c.getColumn(n,2,P),f=t.magnitude(i),h=t.magnitude(u),d=t.magnitude(s),l=L;return l.center=t.clone(e.center,l.center),l.radius=Math.max(f,h,d),!r.isBoundingSphereVisible(l)},m.prototype.intersectPlane=function(e){return m.intersectPlane(this,e)},m.prototype.distanceSquaredTo=function(e){return m.distanceSquaredTo(this,e)},m.prototype.computePlaneDistances=function(e,r,t){return m.computePlaneDistances(this,e,r,t)},m.prototype.isOccluded=function(e){return m.isOccluded(this,e)},m.equals=function(e,r){return e===r||o(e)&&o(r)&&t.equals(e.center,r.center)&&c.equals(e.halfAxes,r.halfAxes)},m.prototype.clone=function(e){return m.clone(this,e)},m.prototype.equals=function(e){return m.equals(this,e)},m}),define("Core/formatError",["./defined"],function(e){"use strict";var r=function(r){var t,n=r.name,i=r.message;t=e(n)&&e(i)?n+": "+i:r.toString();var o=r.stack;return e(o)&&(t+="\n"+o),t};return r}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined","../Core/formatError"],function(e,r,t){"use strict";var n=function(n){var i,o=[],a={id:void 0,result:void 0,error:void 0};return function(u){var s=u.data;o.length=0,a.id=s.id,a.error=void 0,a.result=void 0;try{a.result=n(s.parameters,o)}catch(f){f instanceof Error?a.error={name:f.name,message:f.message,stack:f.stack}:a.error=f}r(i)||(i=e(self.webkitPostMessage,self.postMessage)),s.canTransferArrayBuffer||(o.length=0);try{i(a,o)}catch(f){a.result=void 0,a.error="postMessage failed with error: "+t(f)+"\n  with responseMessage: "+JSON.stringify(a),i(a)}}};return n}),define("Workers/upsampleQuantizedTerrainMesh",["../Core/AttributeCompression","../Core/BoundingSphere","../Core/Cartesian2","../Core/Cartesian3","../Core/Cartographic","../Core/defined","../Core/Ellipsoid","../Core/EllipsoidalOccluder","../Core/IndexDatatype","../Core/Intersections2D","../Core/Math","../Core/OrientedBoundingBox","./createTaskProcessorWorker"],function(e,r,t,n,i,o,a,u,s,f,h,d,c){"use strict";function l(e,t){var i=e.isEastChild,c=e.isNorthChild,l=i?_:0,m=i?p:_,C=c?_:0,P=c?p:_,U=v,b=N,D=q,L=M;U.length=0,b.length=0,D.length=0,L.length=0;var F=g;F.length=0;var B,z,G,W,X={},V=e.vertices,H=e.encodedNormals,Y=e.indices,Z=V.length/3,j=V.subarray(0,Z),k=V.subarray(Z,2*Z),K=V.subarray(2*Z,3*Z),J=0,Q=o(H);for(B=0,z=0;Z>B;++B,z+=2)G=j[B],W=k[B],(i&&G>=_||!i&&_>=G)&&(c&&W>=_||!c&&_>=W)&&(X[B]=J,U.push(G),b.push(W),D.push(K[B]),Q&&(L.push(H[z]),L.push(H[z+1])),++J);var $=[];$.push(new w),$.push(new w),$.push(new w);var ee=[];ee.push(new w),ee.push(new w),ee.push(new w);var re,te;for(B=0;B<Y.length;B+=3){var ne=Y[B],ie=Y[B+1],oe=Y[B+2],ae=j[ne],ue=j[ie],se=j[oe];$[0].initializeIndexed(j,k,K,H,ne),$[1].initializeIndexed(j,k,K,H,ie),$[2].initializeIndexed(j,k,K,H,oe);var fe=f.clipTriangleAtAxisAlignedThreshold(_,i,ae,ue,se,y);re=0,re>=fe.length||(re=ee[0].initializeFromClipResult(fe,re,$),re>=fe.length||(re=ee[1].initializeFromClipResult(fe,re,$),re>=fe.length||(re=ee[2].initializeFromClipResult(fe,re,$),te=f.clipTriangleAtAxisAlignedThreshold(_,c,ee[0].getV(),ee[1].getV(),ee[2].getV(),R),E(U,b,D,L,F,X,te,ee,Q),re<fe.length&&(ee[2].clone(ee[1]),ee[2].initializeFromClipResult(fe,re,$),te=f.clipTriangleAtAxisAlignedThreshold(_,c,ee[0].getV(),ee[1].getV(),ee[2].getV(),R),E(U,b,D,L,F,X,te,ee,Q)))))}var he=i?-p:0,de=c?-p:0,ce=e.minimumHeight,le=e.maximumHeight,we=[],me=[],Ee=[],pe=[],_e=Number.MAX_VALUE,ye=-_e,Re=T;Re.length=0;var Te=a.clone(e.ellipsoid),Ae=e.childRectangle,Se=Ae.north,ve=Ae.south,Ne=Ae.east,qe=Ae.west;for(qe>Ne&&(Ne+=h.TWO_PI),B=0;B<U.length;++B){G=Math.round(U[B]),l>=G?(we.push(B),G=0):G>=m?(Ee.push(B),G=p):G=2*G+he,U[B]=G,W=Math.round(b[B]),C>=W?(me.push(B),W=0):W>=P?(pe.push(B),W=p):W=2*W+de,b[B]=W;var ge=h.lerp(ce,le,D[B]/p);_e>ge&&(_e=ge),ge>ye&&(ye=ge),D[B]=ge,A.longitude=h.lerp(qe,Ne,G/p),A.latitude=h.lerp(ve,Se,W/p),A.height=ge,Te.cartographicToCartesian(A,S),Re.push(S.x),Re.push(S.y),Re.push(S.z)}var Me=r.fromVertices(Re,n.ZERO,3,O),Ie=d.fromRectangle(Ae,_e,ye,Te,x),Oe=new u(Te),xe=Oe.computeHorizonCullingPointFromVertices(Me.center,Re,3,Me.center,I),Ce=ye-_e,Pe=new Uint16Array(U.length+b.length+D.length);for(B=0;B<U.length;++B)Pe[B]=U[B];var Ue=U.length;for(B=0;B<b.length;++B)Pe[Ue+B]=b[B];for(Ue+=b.length,B=0;B<D.length;++B)Pe[Ue+B]=p*(D[B]-_e)/Ce;var be,De=s.createTypedArray(U.length,F);if(Q){var Le=new Uint8Array(L);t.push(Pe.buffer,De.buffer,Le.buffer),be=Le.buffer}else t.push(Pe.buffer,De.buffer);return{vertices:Pe.buffer,encodedNormals:be,indices:De.buffer,minimumHeight:_e,maximumHeight:ye,westIndices:we,southIndices:me,eastIndices:Ee,northIndices:pe,boundingSphere:Me,orientedBoundingBox:Ie,horizonOcclusionPoint:xe}}function w(){this.vertexBuffer=void 0,this.index=void 0,this.first=void 0,this.second=void 0,this.ratio=void 0}function m(r,t){++P;var i=U[P],o=b[P];return i=e.octDecode(r.first.getNormalX(),r.first.getNormalY(),i),o=e.octDecode(r.second.getNormalX(),r.second.getNormalY(),o),S=n.lerp(i,o,r.ratio,S),n.normalize(S,S),e.octEncode(S,t),--P,t}function E(e,r,t,n,i,a,u,s,f){if(0!==u.length){for(var h=0,d=0;d<u.length;)d=D[h++].initializeFromClipResult(u,d,s);for(var c=0;h>c;++c){var l=D[c];if(l.isIndexed())l.newIndex=a[l.index],l.uBuffer=e,l.vBuffer=r,l.heightBuffer=t,f&&(l.normalBuffer=n);else{var w=l.getKey();if(o(a[w]))l.newIndex=a[w];else{var m=e.length;e.push(l.getU()),r.push(l.getV()),t.push(l.getH()),f&&(n.push(l.getNormalX()),n.push(l.getNormalY())),l.newIndex=m,a[w]=m}}}3===h?(i.push(D[0].newIndex),i.push(D[1].newIndex),i.push(D[2].newIndex)):4===h&&(i.push(D[0].newIndex),i.push(D[1].newIndex),i.push(D[2].newIndex),i.push(D[0].newIndex),i.push(D[2].newIndex),i.push(D[3].newIndex))}}var p=32767,_=p/2|0,y=[],R=[],T=[],A=new i,S=new n,v=[],N=[],q=[],g=[],M=[],I=new n,O=new r,x=new d;w.prototype.clone=function(e){return o(e)||(e=new w),e.uBuffer=this.uBuffer,e.vBuffer=this.vBuffer,e.heightBuffer=this.heightBuffer,e.normalBuffer=this.normalBuffer,e.index=this.index,e.first=this.first,e.second=this.second,e.ratio=this.ratio,e},w.prototype.initializeIndexed=function(e,r,t,n,i){this.uBuffer=e,this.vBuffer=r,this.heightBuffer=t,this.normalBuffer=n,this.index=i,this.first=void 0,this.second=void 0,this.ratio=void 0},w.prototype.initializeInterpolated=function(e,r,t){this.vertexBuffer=void 0,this.index=void 0,this.newIndex=void 0,this.first=e,this.second=r,this.ratio=t},w.prototype.initializeFromClipResult=function(e,r,t){var n=r+1;return-1!==e[r]?t[e[r]].clone(this):(this.vertexBuffer=void 0,this.index=void 0,this.first=t[e[n]],++n,this.second=t[e[n]],++n,this.ratio=e[n],++n),n},w.prototype.getKey=function(){return this.isIndexed()?this.index:JSON.stringify({first:this.first.getKey(),second:this.second.getKey(),ratio:this.ratio})},w.prototype.isIndexed=function(){return o(this.index)},w.prototype.getH=function(){return o(this.index)?this.heightBuffer[this.index]:h.lerp(this.first.getH(),this.second.getH(),this.ratio)},w.prototype.getU=function(){return o(this.index)?this.uBuffer[this.index]:h.lerp(this.first.getU(),this.second.getU(),this.ratio)},w.prototype.getV=function(){return o(this.index)?this.vBuffer[this.index]:h.lerp(this.first.getV(),this.second.getV(),this.ratio)};var C=new t,P=-1,U=[new n,new n],b=[new n,new n];w.prototype.getNormalX=function(){return o(this.index)?this.normalBuffer[2*this.index]:(C=m(this,C),C.x)},w.prototype.getNormalY=function(){return o(this.index)?this.normalBuffer[2*this.index+1]:(C=m(this,C),C.y)};var D=[];return D.push(new w),D.push(new w),D.push(new w),D.push(new w),c(l)})}();