/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var r=Object.freeze;return e(r)||(r=function(e){return e}),r}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var r=function(e,r){return void 0!==e?e:r};return r.EMPTY_OBJECT=e({}),r}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var r=function(e){this.name="DeveloperError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r.throwInstantiationError=function(){throw new r("This function defines an interface and should not be called directly.")},r}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var t;for(this.mti==this.N+1&&this.init_genrand(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^r[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^r[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^r[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,r,t,i){"use strict";var n={};n.EPSILON1=.1,n.EPSILON2=.01,n.EPSILON3=.001,n.EPSILON4=1e-4,n.EPSILON5=1e-5,n.EPSILON6=1e-6,n.EPSILON7=1e-7,n.EPSILON8=1e-8,n.EPSILON9=1e-9,n.EPSILON10=1e-10,n.EPSILON11=1e-11,n.EPSILON12=1e-12,n.EPSILON13=1e-13,n.EPSILON14=1e-14,n.EPSILON15=1e-15,n.EPSILON16=1e-16,n.EPSILON17=1e-17,n.EPSILON18=1e-18,n.EPSILON19=1e-19,n.EPSILON20=1e-20,n.GRAVITATIONALPARAMETER=3986004418e5,n.SOLAR_RADIUS=6955e5,n.LUNAR_RADIUS=1737400,n.SIXTY_FOUR_KILOBYTES=65536,n.sign=function(e){return e>0?1:0>e?-1:0},n.signNotZero=function(e){return 0>e?-1:1},n.toSNorm=function(e){return Math.round(255*(.5*n.clamp(e,-1,1)+.5))},n.fromSNorm=function(e){return n.clamp(e,0,255)/255*2-1},n.sinh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r-t)},n.cosh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r+t)},n.lerp=function(e,r,t){return(1-t)*e+t*r},n.PI=Math.PI,n.ONE_OVER_PI=1/Math.PI,n.PI_OVER_TWO=.5*Math.PI,n.PI_OVER_THREE=Math.PI/3,n.PI_OVER_FOUR=Math.PI/4,n.PI_OVER_SIX=Math.PI/6,n.THREE_PI_OVER_TWO=3*Math.PI*.5,n.TWO_PI=2*Math.PI,n.ONE_OVER_TWO_PI=1/(2*Math.PI),n.RADIANS_PER_DEGREE=Math.PI/180,n.DEGREES_PER_RADIAN=180/Math.PI,n.RADIANS_PER_ARCSECOND=n.RADIANS_PER_DEGREE/3600,n.toRadians=function(e){if(!t(e))throw new i("degrees is required.");return e*n.RADIANS_PER_DEGREE},n.toDegrees=function(e){if(!t(e))throw new i("radians is required.");return e*n.DEGREES_PER_RADIAN},n.convertLongitudeRange=function(e){if(!t(e))throw new i("angle is required.");var r=n.TWO_PI,E=e-Math.floor(e/r)*r;return E<-Math.PI?E+r:E>=Math.PI?E-r:E},n.negativePiToPi=function(e){if(!t(e))throw new i("x is required.");return n.zeroToTwoPi(e+n.PI)-n.PI},n.zeroToTwoPi=function(e){if(!t(e))throw new i("x is required.");var r=n.mod(e,n.TWO_PI);return Math.abs(r)<n.EPSILON14&&Math.abs(e)>n.EPSILON14?n.TWO_PI:r},n.mod=function(e,r){if(!t(e))throw new i("m is required.");if(!t(r))throw new i("n is required.");return(e%r+r)%r},n.equalsEpsilon=function(e,n,E,_){if(!t(e))throw new i("left is required.");if(!t(n))throw new i("right is required.");if(!t(E))throw new i("relativeEpsilon is required.");_=r(_,E);var o=Math.abs(e-n);return _>=o||o<=E*Math.max(Math.abs(e),Math.abs(n))};var E=[1];n.factorial=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");var r=E.length;if(e>=r)for(var t=E[r-1],n=r;e>=n;n++)E.push(t*n);return E[e]},n.incrementWrap=function(e,n,E){if(E=r(E,0),!t(e))throw new i("n is required.");if(E>=n)throw new i("maximumValue must be greater than minimumValue.");return++e,e>n&&(e=E),e},n.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},n.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},n.clamp=function(e,r,n){if(!t(e))throw new i("value is required");if(!t(r))throw new i("min is required.");if(!t(n))throw new i("max is required.");return r>e?r:e>n?n:e};var _=new e;return n.setRandomNumberSeed=function(r){if(!t(r))throw new i("seed is required.");_=new e(r)},n.nextRandomNumber=function(){return _.random()},n.acosClamped=function(e){if(!t(e))throw new i("value is required.");return Math.acos(n.clamp(e,-1,1))},n.asinClamped=function(e){if(!t(e))throw new i("value is required.");return Math.asin(n.clamp(e,-1,1))},n.chordLength=function(e,r){if(!t(e))throw new i("angle is required.");if(!t(r))throw new i("radius is required.");return 2*r*Math.sin(.5*e)},n}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n){"use strict";var E=function(r,t){this.x=e(r,0),this.y=e(t,0)};E.fromElements=function(e,t,i){return r(i)?(i.x=e,i.y=t,i):new E(e,t)},E.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t):new E(e.x,e.y):void 0},E.fromCartesian3=E.clone,E.fromCartesian4=E.clone,E.packedLength=2,E.pack=function(i,n,E){if(!r(i))throw new t("value is required");if(!r(n))throw new t("array is required");E=e(E,0),n[E++]=i.x,n[E]=i.y},E.unpack=function(i,n,_){if(!r(i))throw new t("array is required");return n=e(n,0),r(_)||(_=new E),_.x=i[n++],_.y=i[n],_},E.fromArray=E.unpack,E.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y)},E.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y)},E.minimumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.min(e.x,i.x),n.y=Math.min(e.y,i.y),n},E.maximumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.max(e.x,i.x),n.y=Math.max(e.y,i.y),n},E.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y},E.magnitude=function(e){return Math.sqrt(E.magnitudeSquared(e))};var _=new E;E.distance=function(e,i){if(!r(e)||!r(i))throw new t("left and right are required.");return E.subtract(e,i,_),E.magnitude(_)},E.distanceSquared=function(e,i){if(!r(e)||!r(i))throw new t("left and right are required.");return E.subtract(e,i,_),E.magnitudeSquared(_)},E.normalize=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");var n=E.magnitude(e);return i.x=e.x/n,i.y=e.y/n,i},E.dot=function(e,i){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");return e.x*i.x+e.y*i.y},E.multiplyComponents=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x*i.x,n.y=e.y*i.y,n},E.add=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x+i.x,n.y=e.y+i.y,n},E.subtract=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x-i.x,n.y=e.y-i.y,n},E.multiplyByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x*i,n.y=e.y*i,n},E.divideByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x/i,n.y=e.y/i,n},E.negate=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=-e.x,i.y=-e.y,i},E.abs=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=Math.abs(e.x),i.y=Math.abs(e.y),i};var o=new E;E.lerp=function(e,i,n,_){if(!r(e))throw new t("start is required.");if(!r(i))throw new t("end is required.");if("number"!=typeof n)throw new t("t is required and must be a number.");if(!r(_))throw new t("result is required.");return E.multiplyByScalar(i,n,o),_=E.multiplyByScalar(e,1-n,_),E.add(o,_,_)};var a=new E,u=new E;E.angleBetween=function(e,i){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");return E.normalize(e,a),E.normalize(i,u),n.acosClamped(E.dot(a,u))};var R=new E;return E.mostOrthogonalAxis=function(e,i){if(!r(e))throw new t("cartesian is required.");if(!r(i))throw new t("result is required.");var n=E.normalize(e,R);return E.abs(n,n),i=n.x<=n.y?E.clone(E.UNIT_X,i):E.clone(E.UNIT_Y,i)},E.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},E.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]},E.equalsEpsilon=function(e,t,i,E){return e===t||r(e)&&r(t)&&n.equalsEpsilon(e.x,t.x,i,E)&&n.equalsEpsilon(e.y,t.y,i,E)},E.ZERO=i(new E(0,0)),E.UNIT_X=i(new E(1,0)),E.UNIT_Y=i(new E(0,1)),E.prototype.clone=function(e){return E.clone(this,e)},E.prototype.equals=function(e){return E.equals(this,e)},E.prototype.equalsEpsilon=function(e,r,t){return E.equalsEpsilon(this,e,r,t)},E.prototype.toString=function(){return"("+this.x+", "+this.y+")"},E}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n){"use strict";var E=function(r,t,i){this.x=e(r,0),this.y=e(t,0),this.z=e(i,0)};E.fromSpherical=function(i,n){if(!r(i))throw new t("spherical is required");r(n)||(n=new E);var _=i.clock,o=i.cone,a=e(i.magnitude,1),u=a*Math.sin(o);return n.x=u*Math.cos(_),n.y=u*Math.sin(_),n.z=a*Math.cos(o),n},E.fromElements=function(e,t,i,n){return r(n)?(n.x=e,n.y=t,n.z=i,n):new E(e,t,i)},E.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new E(e.x,e.y,e.z):void 0},E.fromCartesian4=E.clone,E.packedLength=3,E.pack=function(i,n,E){if(!r(i))throw new t("value is required");if(!r(n))throw new t("array is required");E=e(E,0),n[E++]=i.x,n[E++]=i.y,n[E]=i.z},E.unpack=function(i,n,_){if(!r(i))throw new t("array is required");return n=e(n,0),r(_)||(_=new E),_.x=i[n++],_.y=i[n++],_.z=i[n],_},E.fromArray=E.unpack,E.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z)},E.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z)},E.minimumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.min(e.x,i.x),n.y=Math.min(e.y,i.y),n.z=Math.min(e.z,i.z),n},E.maximumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.max(e.x,i.x),n.y=Math.max(e.y,i.y),n.z=Math.max(e.z,i.z),n},E.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z},E.magnitude=function(e){return Math.sqrt(E.magnitudeSquared(e))};var _=new E;E.distance=function(e,i){if(!r(e)||!r(i))throw new t("left and right are required.");return E.subtract(e,i,_),E.magnitude(_)},E.distanceSquared=function(e,i){if(!r(e)||!r(i))throw new t("left and right are required.");return E.subtract(e,i,_),E.magnitudeSquared(_)},E.normalize=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");var n=E.magnitude(e);return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i},E.dot=function(e,i){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");return e.x*i.x+e.y*i.y+e.z*i.z},E.multiplyComponents=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x*i.x,n.y=e.y*i.y,n.z=e.z*i.z,n},E.add=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x+i.x,n.y=e.y+i.y,n.z=e.z+i.z,n},E.subtract=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x-i.x,n.y=e.y-i.y,n.z=e.z-i.z,n},E.multiplyByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x*i,n.y=e.y*i,n.z=e.z*i,n},E.divideByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n},E.negate=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=-e.x,i.y=-e.y,i.z=-e.z,i},E.abs=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=Math.abs(e.x),i.y=Math.abs(e.y),i.z=Math.abs(e.z),i};var o=new E;E.lerp=function(e,i,n,_){if(!r(e))throw new t("start is required.");if(!r(i))throw new t("end is required.");if("number"!=typeof n)throw new t("t is required and must be a number.");if(!r(_))throw new t("result is required.");return E.multiplyByScalar(i,n,o),_=E.multiplyByScalar(e,1-n,_),E.add(o,_,_)};var a=new E,u=new E;E.angleBetween=function(e,i){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");E.normalize(e,a),E.normalize(i,u);var n=E.dot(a,u),_=E.magnitude(E.cross(a,u,a));return Math.atan2(_,n)};var R=new E;E.mostOrthogonalAxis=function(e,i){if(!r(e))throw new t("cartesian is required.");if(!r(i))throw new t("result is required.");var n=E.normalize(e,R);return E.abs(n,n),i=n.x<=n.y?n.x<=n.z?E.clone(E.UNIT_X,i):E.clone(E.UNIT_Z,i):n.y<=n.z?E.clone(E.UNIT_Y,i):E.clone(E.UNIT_Z,i)},E.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},E.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]&&e.z===r[t+2]},E.equalsEpsilon=function(e,t,i,E){return e===t||r(e)&&r(t)&&n.equalsEpsilon(e.x,t.x,i,E)&&n.equalsEpsilon(e.y,t.y,i,E)&&n.equalsEpsilon(e.z,t.z,i,E)},E.cross=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");var E=e.x,_=e.y,o=e.z,a=i.x,u=i.y,R=i.z,T=_*R-o*u,s=o*a-E*R,A=E*u-_*a;return n.x=T,n.y=s,n.z=A,n},E.fromDegrees=function(e,i,_,o,a){if(!r(e))throw new t("longitude is required");if(!r(i))throw new t("latitude is required");var u=n.toRadians(e),R=n.toRadians(i);return E.fromRadians(u,R,_,o,a)};var T=new E,s=new E,A=new E(40680631590769,40680631590769,40408299984661.445);return E.fromRadians=function(i,n,_,o,a){if(!r(i))throw new t("longitude is required");if(!r(n))throw new t("latitude is required");_=e(_,0);var u=r(o)?o.radiiSquared:A,R=Math.cos(n);T.x=R*Math.cos(i),T.y=R*Math.sin(i),T.z=Math.sin(n),T=E.normalize(T,T),E.multiplyComponents(u,T,s);var N=Math.sqrt(E.dot(T,s));return s=E.divideByScalar(s,N,s),T=E.multiplyByScalar(T,_,T),r(a)||(a=new E),E.add(s,T,a)},E.fromDegreesArray=function(e,i,_){if(!r(e))throw new t("positions is required.");for(var o=new Array(e.length),a=0;a<e.length;a++)o[a]=n.toRadians(e[a]);return E.fromRadiansArray(o,i,_)},E.fromRadiansArray=function(e,i,n){if(!r(e))throw new t("positions is required.");if(e.length<2)throw new t("positions length cannot be less than 2.");if(e.length%2!==0)throw new t("positions length must be a multiple of 2.");var _=e.length;r(n)?n.length=_/2:n=new Array(_/2);for(var o=0;_>o;o+=2){var a=e[o],u=e[o+1];n[o/2]=E.fromRadians(a,u,0,i,n[o/2])}return n},E.fromDegreesArrayHeights=function(e,i,_){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(e.length%3!==0)throw new t("positions length must be a multiple of 3.");for(var o=new Array(e.length),a=0;a<e.length;a+=3)o[a]=n.toRadians(e[a]),o[a+1]=n.toRadians(e[a+1]),o[a+2]=e[a+2];return E.fromRadiansArrayHeights(o,i,_)},E.fromRadiansArrayHeights=function(e,i,n){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(e.length%3!==0)throw new t("positions length must be a multiple of 3.");var _=e.length;r(n)?n.length=_/3:n=new Array(_/3);for(var o=0;_>o;o+=3){var a=e[o],u=e[o+1],R=e[o+2];n[o/3]=E.fromRadians(a,u,R,i,n[o/3])}return n},E.ZERO=i(new E(0,0,0)),E.UNIT_X=i(new E(1,0,0)),E.UNIT_Y=i(new E(0,1,0)),E.UNIT_Z=i(new E(0,0,1)),E.prototype.clone=function(e){return E.clone(this,e)},E.prototype.equals=function(e){return E.equals(this,e)},E.prototype.equalsEpsilon=function(e,r,t){return E.equalsEpsilon(this,e,r,t)},E.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},E}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,r,t,i,n){"use strict";var E={};E.octEncode=function(e,E){if(!t(e))throw new i("vector is required.");if(!t(E))throw new i("result is required.");var _=r.magnitudeSquared(e);if(Math.abs(_-1)>n.EPSILON6)throw new i("vector must be normalized.");if(E.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),E.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var o=E.x,a=E.y;E.x=(1-Math.abs(a))*n.signNotZero(o),E.y=(1-Math.abs(o))*n.signNotZero(a)}return E.x=n.toSNorm(E.x),E.y=n.toSNorm(E.y),E},E.octDecode=function(e,E,_){if(!t(_))throw new i("result is required.");if(0>e||e>255||0>E||E>255)throw new i("x and y must be a signed normalized integer between 0 and 255");if(_.x=n.fromSNorm(e),_.y=n.fromSNorm(E),_.z=1-(Math.abs(_.x)+Math.abs(_.y)),_.z<0){var o=_.x;_.x=(1-Math.abs(_.y))*n.signNotZero(o),_.y=(1-Math.abs(o))*n.signNotZero(_.y)}return r.normalize(_,_)},E.octPackFloat=function(e){if(!t(e))throw new i("encoded is required.");return 256*e.x+e.y};var _=new e;return E.octEncodeFloat=function(e){return E.octEncode(e,_),E.octPackFloat(_)},E.octDecodeFloat=function(e,r){if(!t(e))throw new i("value is required.");var n=e/256,_=Math.floor(n),o=256*(n-_);return E.octDecode(_,o,r)},E.octPack=function(e,r,n,o){if(!t(e))throw new i("v1 is required.");if(!t(r))throw new i("v2 is required.");if(!t(n))throw new i("v3 is required.");if(!t(o))throw new i("result is required.");var a=E.octEncodeFloat(e),u=E.octEncodeFloat(r),R=E.octEncode(n,_);return o.x=65536*R.x+a,o.y=65536*R.y+u,o},E.octUnpack=function(e,r,n,_){if(!t(e))throw new i("packed is required.");if(!t(r))throw new i("v1 is required.");if(!t(n))throw new i("v2 is required.");if(!t(_))throw new i("v3 is required.");var o=e.x/65536,a=Math.floor(o),u=65536*(o-a);o=e.y/65536;var R=Math.floor(o),T=65536*(o-R);E.octDecodeFloat(u,r),E.octDecodeFloat(T,n),E.octDecode(a,R,_)},E.compressTextureCoordinates=function(e){if(!t(e))throw new i("textureCoordinates is required.");var r=1===e.x?4095:4096*e.x|0,n=1===e.y?4095:4096*e.y|0;return 4096*r+n},E.decompressTextureCoordinates=function(e,r){if(!t(e))throw new i("compressed is required.");if(!t(r))throw new i("result is required.");var n=e/4096;return r.x=Math.floor(n)/4096,r.y=n-Math.floor(n),r},E}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n){"use strict";var E=function(r,t,i){this.longitude=e(r,0),this.latitude=e(t,0),this.height=e(i,0)};return E.fromRadians=function(i,n,_,o){if(!r(i))throw new t("longitude is required.");if(!r(n))throw new t("latitude is required.");return _=e(_,0),r(o)?(o.longitude=i,o.latitude=n,o.height=_,o):new E(i,n,_)},E.fromDegrees=function(e,i,_,o){if(!r(e))throw new t("longitude is required.");if(!r(i))throw new t("latitude is required.");return e=n.toRadians(e),i=n.toRadians(i),E.fromRadians(e,i,_,o)},E.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new E(e.longitude,e.latitude,e.height):void 0},E.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},E.equalsEpsilon=function(e,i,n){if("number"!=typeof n)throw new t("epsilon is required and must be a number.");return e===i||r(e)&&r(i)&&Math.abs(e.longitude-i.longitude)<=n&&Math.abs(e.latitude-i.latitude)<=n&&Math.abs(e.height-i.height)<=n},E.ZERO=i(new E(0,0,0)),E.prototype.clone=function(e){return E.clone(this,e)},E.prototype.equals=function(e){return E.equals(this,e)},E.prototype.equalsEpsilon=function(e,r){return E.equalsEpsilon(this,e,r)},E.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},E}),define("Core/defineProperties",["./defined"],function(e){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),t=Object.defineProperties;return r&&e(t)||(t=function(e){return e}),t}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n,E,_,o){"use strict";function a(r,i,n,_){if(i=t(i,0),n=t(n,0),_=t(_,0),0>i||0>n||0>_)throw new E("All radii components must be greater than or equal to zero.");r._radii=new e(i,n,_),r._radiiSquared=new e(i*i,n*n,_*_),r._radiiToTheFourth=new e(i*i*i*i,n*n*n*n,_*_*_*_),r._oneOverRadii=new e(0===i?0:1/i,0===n?0:1/n,0===_?0:1/_),r._oneOverRadiiSquared=new e(0===i?0:1/(i*i),0===n?0:1/(n*n),0===_?0:1/(_*_)),r._minimumRadius=Math.min(i,n,_),r._maximumRadius=Math.max(i,n,_),r._centerToleranceSquared=o.EPSILON1}var u=function(e,r,t){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,a(this,e,r,t)};n(u.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),u.clone=function(r,t){if(!i(r))return void 0;var n=r._radii;return i(t)?(e.clone(n,t._radii),e.clone(r._radiiSquared,t._radiiSquared),e.clone(r._radiiToTheFourth,t._radiiToTheFourth),e.clone(r._oneOverRadii,t._oneOverRadii),e.clone(r._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=r._minimumRadius,t._maximumRadius=r._maximumRadius,t._centerToleranceSquared=r._centerToleranceSquared,t):new u(n.x,n.y,n.z)},u.fromCartesian3=function(e,r){return i(r)||(r=new u),i(e)?(a(r,e.x,e.y,e.z),r):r},u.WGS84=_(new u(6378137,6378137,6356752.314245179)),u.UNIT_SPHERE=_(new u(1,1,1)),u.MOON=_(new u(o.LUNAR_RADIUS,o.LUNAR_RADIUS,o.LUNAR_RADIUS)),u.prototype.clone=function(e){return u.clone(this,e)},u.packedLength=e.packedLength,u.pack=function(r,n,_){if(!i(r))throw new E("value is required");if(!i(n))throw new E("array is required");_=t(_,0),e.pack(r._radii,n,_)},u.unpack=function(r,n,_){if(!i(r))throw new E("array is required");n=t(n,0);var o=e.unpack(r,n);return u.fromCartesian3(o,_)},u.prototype.geocentricSurfaceNormal=e.normalize,u.prototype.geodeticSurfaceNormalCartographic=function(r,t){if(!i(r))throw new E("cartographic is required.");var n=r.longitude,_=r.latitude,o=Math.cos(_),a=o*Math.cos(n),u=o*Math.sin(n),R=Math.sin(_);return i(t)||(t=new e),t.x=a,t.y=u,t.z=R,e.normalize(t,t)},u.prototype.geodeticSurfaceNormal=function(r,t){return i(t)||(t=new e),t=e.multiplyComponents(r,this._oneOverRadiiSquared,t),e.normalize(t,t)};var R=new e,T=new e;u.prototype.cartographicToCartesian=function(r,t){var n=R,E=T;this.geodeticSurfaceNormalCartographic(r,n),e.multiplyComponents(this._radiiSquared,n,E);var _=Math.sqrt(e.dot(n,E));return e.divideByScalar(E,_,E),e.multiplyByScalar(n,r.height,n),i(t)||(t=new e),e.add(E,n,t)},u.prototype.cartographicArrayToCartesianArray=function(e,r){if(!i(e))throw new E("cartographics is required.");var t=e.length;i(r)?r.length=t:r=new Array(t);for(var n=0;t>n;n++)r[n]=this.cartographicToCartesian(e[n],r[n]);return r};var s=new e,A=new e,N=new e;u.prototype.cartesianToCartographic=function(t,n){var E=this.scaleToGeodeticSurface(t,A);if(!i(E))return void 0;var _=this.geodeticSurfaceNormal(E,s),a=e.subtract(t,E,N),u=Math.atan2(_.y,_.x),R=Math.asin(_.z),T=o.sign(e.dot(a,t))*e.magnitude(a);return i(n)?(n.longitude=u,n.latitude=R,n.height=T,n):new r(u,R,T)},u.prototype.cartesianArrayToCartographicArray=function(e,r){if(!i(e))throw new E("cartesians is required.");var t=e.length;i(r)?r.length=t:r=new Array(t);for(var n=0;t>n;++n)r[n]=this.cartesianToCartographic(e[n],r[n]);return r};var h=new e,I=new e;return u.prototype.scaleToGeodeticSurface=function(r,t){if(!i(r))throw new E("cartesian is required.");var n=r.x,_=r.y,a=r.z,u=this._oneOverRadii,R=u.x,T=u.y,s=u.z,A=n*n*R*R,N=_*_*T*T,d=a*a*s*s,S=A+N+d,f=Math.sqrt(1/S),c=e.multiplyByScalar(r,f,h);if(S<this._centerToleranceSquared)return isFinite(f)?e.clone(c,t):void 0;var M=this._oneOverRadiiSquared,O=M.x,w=M.y,C=M.z,l=I;l.x=c.x*O*2,l.y=c.y*w*2,l.z=c.z*C*2;var F,U,L,D,P,m,B,y,q,p,g,G=(1-f)*e.magnitude(r)/(.5*e.magnitude(l)),v=0;do{G-=v,L=1/(1+G*O),D=1/(1+G*w),P=1/(1+G*C),m=L*L,B=D*D,y=P*P,q=m*L,p=B*D,g=y*P,F=A*m+N*B+d*y-1,U=A*q*O+N*p*w+d*g*C;var x=-2*U;v=F/x}while(Math.abs(F)>o.EPSILON12);return i(t)?(t.x=n*L,t.y=_*D,t.z=a*P,t):new e(n*L,_*D,a*P)},u.prototype.scaleToGeocentricSurface=function(r,t){if(!i(r))throw new E("cartesian is required.");i(t)||(t=new e);var n=r.x,_=r.y,o=r.z,a=this._oneOverRadiiSquared,u=1/Math.sqrt(n*n*a.x+_*_*a.y+o*o*a.z);return e.multiplyByScalar(r,u,t)},u.prototype.transformPositionToScaledSpace=function(r,t){return i(t)||(t=new e),e.multiplyComponents(r,this._oneOverRadii,t)},u.prototype.transformPositionFromScaledSpace=function(r,t){return i(t)||(t=new e),e.multiplyComponents(r,this._radii,t)},u.prototype.equals=function(r){return this===r||i(r)&&e.equals(this._radii,r._radii)},u.prototype.toString=function(){return this._radii.toString()},u}),define("Renderer/WebGLConstants",["../Core/freezeObject"],function(e){"use strict";var r={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,
BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return e(r)}),define("Core/IndexDatatype",["../Renderer/WebGLConstants","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n){"use strict";var E={UNSIGNED_BYTE:e.UNSIGNED_BYTE,UNSIGNED_SHORT:e.UNSIGNED_SHORT,UNSIGNED_INT:e.UNSIGNED_INT};return E.getSizeInBytes=function(e){switch(e){case E.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case E.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case E.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},E.validate=function(e){return r(e)&&(e===E.UNSIGNED_BYTE||e===E.UNSIGNED_SHORT||e===E.UNSIGNED_INT)},E.createTypedArray=function(e,i){if(!r(e))throw new t("numberOfVertices is required.");return e>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},E.createTypedArrayFromArrayBuffer=function(e,i,E,_){if(!r(e))throw new t("numberOfVertices is required.");if(!r(i))throw new t("sourceArray is required.");if(!r(E))throw new t("byteOffset is required.");return e>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(i,E,_):new Uint16Array(i,E,_)},i(E)}),define("Core/formatError",["./defined"],function(e){"use strict";var r=function(r){var t,i=r.name,n=r.message;t=e(i)&&e(n)?i+": "+n:r.toString();var E=r.stack;return e(E)&&(t+="\n"+E),t};return r}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined","../Core/formatError"],function(e,r,t){"use strict";var i=function(i){var n,E=[],_={id:void 0,result:void 0,error:void 0};return function(o){var a=o.data;E.length=0,_.id=a.id,_.error=void 0,_.result=void 0;try{_.result=i(a.parameters,E)}catch(u){u instanceof Error?_.error={name:u.name,message:u.message,stack:u.stack}:_.error=u}r(n)||(n=e(self.webkitPostMessage,self.postMessage)),a.canTransferArrayBuffer||(E.length=0);try{n(_,E)}catch(u){_.result=void 0,_.error="postMessage failed with error: "+t(u)+"\n  with responseMessage: "+JSON.stringify(_),n(_)}}};return i}),define("Workers/createVerticesFromQuantizedTerrainMesh",["../Core/AttributeCompression","../Core/Cartesian2","../Core/Cartesian3","../Core/Cartographic","../Core/defined","../Core/Ellipsoid","../Core/IndexDatatype","../Core/Math","./createTaskProcessorWorker"],function(e,r,t,i,n,E,_,o,a){"use strict";function u(r,t){var i=r.quantizedVertices,a=i.length/3,u=r.octEncodedNormals,O=r.westIndices.length+r.eastIndices.length+r.southIndices.length+r.northIndices.length,w=r.minimumHeight,C=r.maximumHeight,l=r.relativeToCenter,F=r.rectangle,U=F.west,L=F.south,D=F.east,P=F.north,m=E.clone(r.ellipsoid),B=i.subarray(0,a),y=i.subarray(a,2*a),q=i.subarray(2*a,3*a),p=n(u),g=6;p&&(g+=1);for(var G=new Float32Array(a*g+O*g),v=0,x=0,X=0;a>v;++v,x+=g,X+=2){var H=B[v]/T,V=y[v]/T,b=o.lerp(w,C,q[v]/T);c.longitude=o.lerp(U,D,H),c.latitude=o.lerp(L,P,V),c.height=b,m.cartographicToCartesian(c,f),G[x+s]=f.x-l.x,G[x+A]=f.y-l.y,G[x+N]=f.z-l.z,G[x+h]=b,G[x+I]=H,G[x+d]=V,p&&(M.x=u[X],M.y=u[X+1],G[x+S]=e.octPackFloat(M))}var z=Math.max(0,2*(O-4)),Y=r.indices.length+3*z,W=_.createTypedArray(a+O,Y);W.set(r.indices,0);var K=a*g,Z=r.indices.length;return Z=R(G,K,W,Z,r.westIndices,l,m,F,r.westSkirtHeight,!0,p),K+=r.westIndices.length*g,Z=R(G,K,W,Z,r.southIndices,l,m,F,r.southSkirtHeight,!1,p),K+=r.southIndices.length*g,Z=R(G,K,W,Z,r.eastIndices,l,m,F,r.eastSkirtHeight,!1,p),K+=r.eastIndices.length*g,Z=R(G,K,W,Z,r.northIndices,l,m,F,r.northSkirtHeight,!0,p),K+=r.northIndices.length*g,t.push(G.buffer,W.buffer),{vertices:G.buffer,indices:W.buffer}}function R(e,r,i,n,E,_,a,u,R,T,s){var A,N,M,O=6;s&&(O+=1),T?(A=E.length-1,N=-1,M=-1):(A=0,N=E.length,M=1);var w=-1,C=r/O,l=u.north,F=u.south,U=u.east,L=u.west;L>U&&(U+=o.TWO_PI);for(var D=A;D!==N;D+=M){var P=E[D],m=P*O,B=e[m+I],y=e[m+d],q=e[m+h];c.longitude=o.lerp(L,U,B),c.latitude=o.lerp(F,l,y),c.height=q-R;var p=a.cartographicToCartesian(c,f);t.subtract(p,_,p),e[r++]=p.x,e[r++]=p.y,e[r++]=p.z,e[r++]=c.height,e[r++]=B,e[r++]=y,s&&(e[r++]=e[m+S]),-1!==w&&(i[n++]=w,i[n++]=C-1,i[n++]=P,i[n++]=C-1,i[n++]=C,i[n++]=P),w=P,++C}return n}var T=32767,s=0,A=1,N=2,h=3,I=4,d=5,S=6,f=new t,c=new i,M=new r;return a(u)})}();