/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var r=Object.freeze;return e(r)||(r=function(e){return e}),r}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var r=function(e,r){return void 0!==e?e:r};return r.EMPTY_OBJECT=e({}),r}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var r=function(e){this.name="DeveloperError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r.throwInstantiationError=function(){throw new r("This function defines an interface and should not be called directly.")},r}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var t;for(this.mti==this.N+1&&this.init_genrand(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^r[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^r[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^r[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.signNotZero=function(e){return 0>e?-1:1},i.toSNorm=function(e){return Math.round(255*(.5*i.clamp(e,-1,1)+.5))},i.fromSNorm=function(e){return i.clamp(e,0,255)/255*2-1},i.sinh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r-t)},i.cosh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r+t)},i.lerp=function(e,r,t){return(1-t)*e+t*r},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=3*Math.PI*.5,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){if(!t(e))throw new n("degrees is required.");return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){if(!t(e))throw new n("radians is required.");return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){if(!t(e))throw new n("angle is required.");var r=i.TWO_PI,a=e-Math.floor(e/r)*r;return a<-Math.PI?a+r:a>=Math.PI?a-r:a},i.negativePiToPi=function(e){if(!t(e))throw new n("x is required.");return i.zeroToTwoPi(e+i.PI)-i.PI},i.zeroToTwoPi=function(e){if(!t(e))throw new n("x is required.");var r=i.mod(e,i.TWO_PI);return Math.abs(r)<i.EPSILON14&&Math.abs(e)>i.EPSILON14?i.TWO_PI:r},i.mod=function(e,r){if(!t(e))throw new n("m is required.");if(!t(r))throw new n("n is required.");return(e%r+r)%r},i.equalsEpsilon=function(e,i,a,o){if(!t(e))throw new n("left is required.");if(!t(i))throw new n("right is required.");if(!t(a))throw new n("relativeEpsilon is required.");o=r(o,a);var u=Math.abs(e-i);return o>=u||u<=a*Math.max(Math.abs(e),Math.abs(i))};var a=[1];i.factorial=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");var r=a.length;if(e>=r)for(var t=a[r-1],i=r;e>=i;i++)a.push(t*i);return a[e]},i.incrementWrap=function(e,i,a){if(a=r(a,0),!t(e))throw new n("n is required.");if(a>=i)throw new n("maximumValue must be greater than minimumValue.");return++e,e>i&&(e=a),e},i.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,r,i){if(!t(e))throw new n("value is required");if(!t(r))throw new n("min is required.");if(!t(i))throw new n("max is required.");return r>e?r:e>i?i:e};var o=new e;return i.setRandomNumberSeed=function(r){if(!t(r))throw new n("seed is required.");o=new e(r)},i.nextRandomNumber=function(){return o.random()},i.acosClamped=function(e){if(!t(e))throw new n("value is required.");return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){if(!t(e))throw new n("value is required.");return Math.asin(i.clamp(e,-1,1))},i.chordLength=function(e,r){if(!t(e))throw new n("angle is required.");if(!t(r))throw new n("radius is required.");return 2*r*Math.sin(.5*e)},i}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t,n){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0)};a.fromSpherical=function(n,i){if(!r(n))throw new t("spherical is required");r(i)||(i=new a);var o=n.clock,u=n.cone,s=e(n.magnitude,1),f=s*Math.sin(u);return i.x=f*Math.cos(o),i.y=f*Math.sin(o),i.z=s*Math.cos(u),i},a.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new a(e,t,n)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new a(e.x,e.y,e.z):void 0},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.x,i[a++]=n.y,i[a]=n.z},a.unpack=function(n,i,o){if(!r(n))throw new t("array is required");return i=e(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i++],o.z=n[i],o},a.fromArray=a.unpack,a.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z)},a.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z)},a.minimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i},a.maximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i},a.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitude(o)},a.distanceSquared=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitudeSquared(o)},a.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=a.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n},a.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z},a.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i},a.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i},a.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i},a.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i},a.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i},a.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n},a.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n};var u=new a;a.lerp=function(e,n,i,o){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(o))throw new t("result is required.");return a.multiplyByScalar(n,i,u),o=a.multiplyByScalar(e,1-i,o),a.add(u,o,o)};var s=new a,f=new a;a.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");a.normalize(e,s),a.normalize(n,f);var i=a.dot(s,f),o=a.magnitude(a.cross(s,f,s));return Math.atan2(o,i)};var l=new a;a.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=a.normalize(e,l);return a.abs(i,i),n=i.x<=i.y?i.x<=i.z?a.clone(a.UNIT_X,n):a.clone(a.UNIT_Z,n):i.y<=i.z?a.clone(a.UNIT_Y,n):a.clone(a.UNIT_Z,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},a.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]&&e.z===r[t+2]},a.equalsEpsilon=function(e,t,n,a){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,a)&&i.equalsEpsilon(e.y,t.y,n,a)&&i.equalsEpsilon(e.z,t.z,n,a)},a.cross=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");var a=e.x,o=e.y,u=e.z,s=n.x,f=n.y,l=n.z,c=o*l-u*f,d=u*s-a*l,h=a*f-o*s;return i.x=c,i.y=d,i.z=h,i},a.fromDegrees=function(e,n,o,u,s){if(!r(e))throw new t("longitude is required");if(!r(n))throw new t("latitude is required");var f=i.toRadians(e),l=i.toRadians(n);return a.fromRadians(f,l,o,u,s)};var c=new a,d=new a,h=new a(40680631590769,40680631590769,40408299984661.445);return a.fromRadians=function(n,i,o,u,s){if(!r(n))throw new t("longitude is required");if(!r(i))throw new t("latitude is required");o=e(o,0);var f=r(u)?u.radiiSquared:h,l=Math.cos(i);c.x=l*Math.cos(n),c.y=l*Math.sin(n),c.z=Math.sin(i),c=a.normalize(c,c),a.multiplyComponents(f,c,d);var w=Math.sqrt(a.dot(c,d));return d=a.divideByScalar(d,w,d),c=a.multiplyByScalar(c,o,c),r(s)||(s=new a),a.add(d,c,s)},a.fromDegreesArray=function(e,n,o){if(!r(e))throw new t("positions is required.");for(var u=new Array(e.length),s=0;s<e.length;s++)u[s]=i.toRadians(e[s]);return a.fromRadiansArray(u,n,o)},a.fromRadiansArray=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<2)throw new t("positions length cannot be less than 2.");if(e.length%2!==0)throw new t("positions length must be a multiple of 2.");var o=e.length;r(i)?i.length=o/2:i=new Array(o/2);for(var u=0;o>u;u+=2){var s=e[u],f=e[u+1];i[u/2]=a.fromRadians(s,f,0,n,i[u/2])}return i},a.fromDegreesArrayHeights=function(e,n,o){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(e.length%3!==0)throw new t("positions length must be a multiple of 3.");for(var u=new Array(e.length),s=0;s<e.length;s+=3)u[s]=i.toRadians(e[s]),u[s+1]=i.toRadians(e[s+1]),u[s+2]=e[s+2];return a.fromRadiansArrayHeights(u,n,o)},a.fromRadiansArrayHeights=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(e.length%3!==0)throw new t("positions length must be a multiple of 3.");var o=e.length;r(i)?i.length=o/3:i=new Array(o/3);for(var u=0;o>u;u+=3){var s=e[u],f=e[u+1],l=e[u+2];i[u/3]=a.fromRadians(s,f,l,n,i[u/3])}return i},a.ZERO=n(new a(0,0,0)),a.UNIT_X=n(new a(1,0,0)),a.UNIT_Y=n(new a(0,1,0)),a.UNIT_Z=n(new a(0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r,t){return a.equalsEpsilon(this,e,r,t)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t,n){this.longitude=e(r,0),this.latitude=e(t,0),this.height=e(n,0)};return a.fromRadians=function(n,i,o,u){if(!r(n))throw new t("longitude is required.");if(!r(i))throw new t("latitude is required.");return o=e(o,0),r(u)?(u.longitude=n,u.latitude=i,u.height=o,u):new a(n,i,o)},a.fromDegrees=function(e,n,o,u){if(!r(e))throw new t("longitude is required.");if(!r(n))throw new t("latitude is required.");return e=i.toRadians(e),n=i.toRadians(n),a.fromRadians(e,n,o,u)},a.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new a(e.longitude,e.latitude,e.height):void 0},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},a.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.longitude-n.longitude)<=i&&Math.abs(e.latitude-n.latitude)<=i&&Math.abs(e.height-n.height)<=i},a.ZERO=n(new a(0,0,0)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r){return a.equalsEpsilon(this,e,r)},a.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},a}),define("Core/deprecationWarning",["./defined","./DeveloperError"],function(e,r){"use strict";var t={},n=function(n,i){if(!e(n)||!e(i))throw new r("identifier and message are required.");e(t[n])||(t[n]=!0,console.log(i))};return n}),define("Core/defineProperties",["./defined"],function(e){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),t=Object.defineProperties;return r&&e(t)||(t=function(e){return e}),t}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,a,o,u){"use strict";function s(r,n,i,o){if(n=t(n,0),i=t(i,0),o=t(o,0),0>n||0>i||0>o)throw new a("All radii components must be greater than or equal to zero.");r._radii=new e(n,i,o),r._radiiSquared=new e(n*n,i*i,o*o),r._radiiToTheFourth=new e(n*n*n*n,i*i*i*i,o*o*o*o),r._oneOverRadii=new e(0===n?0:1/n,0===i?0:1/i,0===o?0:1/o),r._oneOverRadiiSquared=new e(0===n?0:1/(n*n),0===i?0:1/(i*i),0===o?0:1/(o*o)),r._minimumRadius=Math.min(n,i,o),r._maximumRadius=Math.max(n,i,o),r._centerToleranceSquared=u.EPSILON1}var f=function(e,r,t){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,s(this,e,r,t)};i(f.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),f.clone=function(r,t){if(!n(r))return void 0;var i=r._radii;return n(t)?(e.clone(i,t._radii),e.clone(r._radiiSquared,t._radiiSquared),e.clone(r._radiiToTheFourth,t._radiiToTheFourth),e.clone(r._oneOverRadii,t._oneOverRadii),e.clone(r._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=r._minimumRadius,t._maximumRadius=r._maximumRadius,t._centerToleranceSquared=r._centerToleranceSquared,t):new f(i.x,i.y,i.z)},f.fromCartesian3=function(e,r){return n(r)||(r=new f),n(e)?(s(r,e.x,e.y,e.z),r):r},f.WGS84=o(new f(6378137,6378137,6356752.314245179)),f.UNIT_SPHERE=o(new f(1,1,1)),f.MOON=o(new f(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),f.prototype.clone=function(e){return f.clone(this,e)},f.packedLength=e.packedLength,f.pack=function(r,i,o){if(!n(r))throw new a("value is required");if(!n(i))throw new a("array is required");o=t(o,0),e.pack(r._radii,i,o)},f.unpack=function(r,i,o){if(!n(r))throw new a("array is required");i=t(i,0);var u=e.unpack(r,i);return f.fromCartesian3(u,o)},f.prototype.geocentricSurfaceNormal=e.normalize,f.prototype.geodeticSurfaceNormalCartographic=function(r,t){if(!n(r))throw new a("cartographic is required.");var i=r.longitude,o=r.latitude,u=Math.cos(o),s=u*Math.cos(i),f=u*Math.sin(i),l=Math.sin(o);return n(t)||(t=new e),t.x=s,t.y=f,t.z=l,e.normalize(t,t)},f.prototype.geodeticSurfaceNormal=function(r,t){return n(t)||(t=new e),t=e.multiplyComponents(r,this._oneOverRadiiSquared,t),e.normalize(t,t)};var l=new e,c=new e;f.prototype.cartographicToCartesian=function(r,t){var i=l,a=c;this.geodeticSurfaceNormalCartographic(r,i),e.multiplyComponents(this._radiiSquared,i,a);var o=Math.sqrt(e.dot(i,a));return e.divideByScalar(a,o,a),e.multiplyByScalar(i,r.height,i),n(t)||(t=new e),e.add(a,i,t)},f.prototype.cartographicArrayToCartesianArray=function(e,r){if(!n(e))throw new a("cartographics is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;i++)r[i]=this.cartographicToCartesian(e[i],r[i]);return r};var d=new e,h=new e,w=new e;f.prototype.cartesianToCartographic=function(t,i){var a=this.scaleToGeodeticSurface(t,h);if(!n(a))return void 0;var o=this.geodeticSurfaceNormal(a,d),s=e.subtract(t,a,w),f=Math.atan2(o.y,o.x),l=Math.asin(o.z),c=u.sign(e.dot(s,t))*e.magnitude(s);return n(i)?(i.longitude=f,i.latitude=l,i.height=c,i):new r(f,l,c)},f.prototype.cartesianArrayToCartographicArray=function(e,r){if(!n(e))throw new a("cartesians is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;++i)r[i]=this.cartesianToCartographic(e[i],r[i]);return r};var m=new e,p=new e;return f.prototype.scaleToGeodeticSurface=function(r,t){if(!n(r))throw new a("cartesian is required.");var i=r.x,o=r.y,s=r.z,f=this._oneOverRadii,l=f.x,c=f.y,d=f.z,h=i*i*l*l,w=o*o*c*c,y=s*s*d*d,v=h+w+y,q=Math.sqrt(1/v),g=e.multiplyByScalar(r,q,m);if(v<this._centerToleranceSquared)return isFinite(q)?e.clone(g,t):void 0;var x=this._oneOverRadiiSquared,S=x.x,b=x.y,E=x.z,M=p;M.x=g.x*S*2,M.y=g.y*b*2,M.z=g.z*E*2;var O,P,_,R,C,z,T,I,N,A,D,U=(1-q)*e.magnitude(r)/(.5*e.magnitude(M)),L=0;do{U-=L,_=1/(1+U*S),R=1/(1+U*b),C=1/(1+U*E),z=_*_,T=R*R,I=C*C,N=z*_,A=T*R,D=I*C,O=h*z+w*T+y*I-1,P=h*N*S+w*A*b+y*D*E;var W=-2*P;L=O/W}while(Math.abs(O)>u.EPSILON12);return n(t)?(t.x=i*_,t.y=o*R,t.z=s*C,t):new e(i*_,o*R,s*C)},f.prototype.scaleToGeocentricSurface=function(r,t){if(!n(r))throw new a("cartesian is required.");n(t)||(t=new e);var i=r.x,o=r.y,u=r.z,s=this._oneOverRadiiSquared,f=1/Math.sqrt(i*i*s.x+o*o*s.y+u*u*s.z);return e.multiplyByScalar(r,f,t)},f.prototype.transformPositionToScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._oneOverRadii,t)},f.prototype.transformPositionFromScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._radii,t)},f.prototype.equals=function(r){return this===r||n(r)&&e.equals(this._radii,r._radii)},f.prototype.toString=function(){return this._radii.toString()},f}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,r,t,n,i,a,o){"use strict";var u=function(e){this._ellipsoid=t(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(r,t){var i=this._semimajorAxis,a=r.longitude*i,o=r.latitude*i,u=r.height;return n(t)?(t.x=a,t.y=o,t.z=u,t):new e(a,o,u)},u.prototype.unproject=function(e,t){if(!n(e))throw new a("cartesian is required");var i=this._oneOverSemimajorAxis,o=e.x*i,u=e.y*i,s=e.z;return n(t)?(t.longitude=o,t.latitude=u,t.height=s,t):new r(o,u,s)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var r={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(r)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var r=function(r,t){this.start=e(r,0),this.stop=e(t,0)};return r}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t,n,i){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0),this.w=e(i,0)};a.fromElements=function(e,t,n,i,o){return r(o)?(o.x=e,o.y=t,o.z=n,o.w=i,o):new a(e,t,n,i)},a.fromColor=function(e,n){if(!r(e))throw new t("color is required");return r(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new a(e.red,e.green,e.blue,e.alpha)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new a(e.x,e.y,e.z,e.w):void 0},a.packedLength=4,a.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.x,i[a++]=n.y,i[a++]=n.z,i[a]=n.w},a.unpack=function(n,i,o){if(!r(n))throw new t("array is required");return i=e(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i++],o.z=n[i++],o.w=n[i],o},a.fromArray=a.unpack,a.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z,e.w)},a.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z,e.w)},a.minimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i.w=Math.min(e.w,n.w),i},a.maximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i.w=Math.max(e.w,n.w),i},a.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitude(o)},a.distanceSquared=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitudeSquared(o)},a.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=a.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n.w=e.w/i,n},a.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z+e.w*n.w},a.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i.w=e.w*n.w,i},a.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i.w=e.w+n.w,i},a.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i.w=e.w-n.w,i},a.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i.w=e.w*n,i},a.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i.w=e.w/n,i},a.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n.w=-e.w,n},a.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n.w=Math.abs(e.w),n};var u=new a;a.lerp=function(e,n,i,o){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(o))throw new t("result is required.");return a.multiplyByScalar(n,i,u),o=a.multiplyByScalar(e,1-i,o),a.add(u,o,o)};var s=new a;return a.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=a.normalize(e,s);return a.abs(i,i),n=i.x<=i.y?i.x<=i.z?i.x<=i.w?a.clone(a.UNIT_X,n):a.clone(a.UNIT_W,n):i.z<=i.w?a.clone(a.UNIT_Z,n):a.clone(a.UNIT_W,n):i.y<=i.z?i.y<=i.w?a.clone(a.UNIT_Y,n):a.clone(a.UNIT_W,n):i.z<=i.w?a.clone(a.UNIT_Z,n):a.clone(a.UNIT_W,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},a.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]&&e.z===r[t+2]&&e.w===r[t+3]},a.equalsEpsilon=function(e,t,n,a){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,a)&&i.equalsEpsilon(e.y,t.y,n,a)&&i.equalsEpsilon(e.z,t.z,n,a)&&i.equalsEpsilon(e.w,t.w,n,a)},a.ZERO=n(new a(0,0,0,0)),a.UNIT_X=n(new a(1,0,0,0)),a.UNIT_Y=n(new a(0,1,0,0)),a.UNIT_Z=n(new a(0,0,1,0)),a.UNIT_W=n(new a(0,0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r,t){return a.equalsEpsilon(this,e,r,t)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},a}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,a){"use strict";function o(e){for(var r=0,t=0;9>t;++t){var n=e[t];r+=n*n}return Math.sqrt(r)}function u(e){for(var r=0,t=0;3>t;++t){var n=e[f.getElementIndex(h[t],d[t])];r+=2*n*n}return Math.sqrt(r)}function s(e,r){for(var t=a.EPSILON15,n=0,i=1,o=0;3>o;++o){var u=Math.abs(e[f.getElementIndex(h[o],d[o])]);u>n&&(i=o,n=u)}var s=1,l=0,c=d[i],w=h[i];if(Math.abs(e[f.getElementIndex(w,c)])>t){var m,p=e[f.getElementIndex(w,w)],y=e[f.getElementIndex(c,c)],v=e[f.getElementIndex(w,c)],q=(p-y)/2/v;m=0>q?-1/(-q+Math.sqrt(1+q*q)):1/(q+Math.sqrt(1+q*q)),s=1/Math.sqrt(1+m*m),l=m*s}return r=f.clone(f.IDENTITY,r),r[f.getElementIndex(c,c)]=r[f.getElementIndex(w,w)]=s,r[f.getElementIndex(w,c)]=l,r[f.getElementIndex(c,w)]=-l,r}var f=function(e,t,n,i,a,o,u,s,f){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(a,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(o,0),this[8]=r(f,0)};f.packedLength=9,f.pack=function(e,i,a){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");a=r(a,0),i[a++]=e[0],i[a++]=e[1],i[a++]=e[2],i[a++]=e[3],i[a++]=e[4],i[a++]=e[5],i[a++]=e[6],i[a++]=e[7],i[a++]=e[8]},f.unpack=function(e,i,a){if(!t(e))throw new n("array is required");return i=r(i,0),t(a)||(a=new f),a[0]=e[i++],a[1]=e[i++],a[2]=e[i++],a[3]=e[i++],a[4]=e[i++],a[5]=e[i++],a[6]=e[i++],a[7]=e[i++],a[8]=e[i++],a},f.clone=function(e,r){return t(e)?t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):new f(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},f.fromArray=function(e,i,a){if(!t(e))throw new n("array is required");return i=r(i,0),t(a)||(a=new f),a[0]=e[i],a[1]=e[i+1],a[2]=e[i+2],a[3]=e[i+3],a[4]=e[i+4],a[5]=e[i+5],a[6]=e[i+6],a[7]=e[i+7],a[8]=e[i+8],a},f.fromColumnMajorArray=function(e,r){if(!t(e))throw new n("values parameter is required");return f.clone(e,r)},f.fromRowMajorArray=function(e,r){if(!t(e))throw new n("values is required.");return t(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},f.fromQuaternion=function(e,r){if(!t(e))throw new n("quaternion is required");var i=e.x*e.x,a=e.x*e.y,o=e.x*e.z,u=e.x*e.w,s=e.y*e.y,l=e.y*e.z,c=e.y*e.w,d=e.z*e.z,h=e.z*e.w,w=e.w*e.w,m=i-s-d+w,p=2*(a-h),y=2*(o+c),v=2*(a+h),q=-i+s-d+w,g=2*(l-u),x=2*(o-c),S=2*(l+u),b=-i-s+d+w;return t(r)?(r[0]=m,r[1]=v,r[2]=x,r[3]=p,r[4]=q,r[5]=S,r[6]=y,r[7]=g,r[8]=b,r):new f(m,p,y,v,q,g,x,S,b)},f.fromScale=function(e,r){if(!t(e))throw new n("scale is required.");return t(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new f(e.x,0,0,0,e.y,0,0,0,e.z)},f.fromUniformScale=function(e,r){if("number"!=typeof e)throw new n("scale is required.");return t(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new f(e,0,0,0,e,0,0,0,e)},f.fromCrossProduct=function(e,r){if(!t(e))throw new n("vector is required.");return t(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new f(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},f.fromRotationX=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=a,r[6]=0,r[7]=-a,r[8]=i,r):new f(1,0,0,0,i,-a,0,a,i)},f.fromRotationY=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=i,r[1]=0,r[2]=-a,r[3]=0,r[4]=1,r[5]=0,r[6]=a,r[7]=0,r[8]=i,r):new f(i,0,a,0,1,0,-a,0,i)},f.fromRotationZ=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=i,r[1]=a,r[2]=0,r[3]=-a,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new f(i,-a,0,a,i,0,0,0,1)},f.toArray=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},f.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>2)throw new n("row must be 0, 1, or 2.");if("number"!=typeof e||0>e||e>2)throw new n("column must be 0, 1, or 2.");return 3*e+r},f.getColumn=function(e,r,i){if(!t(e))throw new n("matrix is required.");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(i))throw new n("result is required");var a=3*r,o=e[a],u=e[a+1],s=e[a+2];return i.x=o,i.y=u,i.z=s,i},f.setColumn=function(e,r,i,a){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(a))throw new n("result is required");a=f.clone(e,a);var o=3*r;return a[o]=i.x,a[o+1]=i.y,a[o+2]=i.z,a},f.getRow=function(e,r,i){if(!t(e))throw new n("matrix is required.");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(i))throw new n("result is required");var a=e[r],o=e[r+3],u=e[r+6];
return i.x=a,i.y=o,i.z=u,i},f.setRow=function(e,r,i,a){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(a))throw new n("result is required");return a=f.clone(e,a),a[r]=i.x,a[r+3]=i.y,a[r+6]=i.z,a};var l=new e;f.getScale=function(r,i){if(!t(r))throw new n("matrix is required.");if(!t(i))throw new n("result is required");return i.x=e.magnitude(e.fromElements(r[0],r[1],r[2],l)),i.y=e.magnitude(e.fromElements(r[3],r[4],r[5],l)),i.z=e.magnitude(e.fromElements(r[6],r[7],r[8],l)),i};var c=new e;f.getMaximumScale=function(r){return f.getScale(r,c),e.maximumComponent(c)},f.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");var a=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],o=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],u=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],s=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],f=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],l=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],c=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],d=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],h=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return i[0]=a,i[1]=o,i[2]=u,i[3]=s,i[4]=f,i[5]=l,i[6]=c,i[7]=d,i[8]=h,i},f.add=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i[0]=e[0]+r[0],i[1]=e[1]+r[1],i[2]=e[2]+r[2],i[3]=e[3]+r[3],i[4]=e[4]+r[4],i[5]=e[5]+r[5],i[6]=e[6]+r[6],i[7]=e[7]+r[7],i[8]=e[8]+r[8],i},f.subtract=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],i[3]=e[3]-r[3],i[4]=e[4]-r[4],i[5]=e[5]-r[5],i[6]=e[6]-r[6],i[7]=e[7]-r[7],i[8]=e[8]-r[8],i},f.multiplyByVector=function(e,r,i){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("cartesian is required");if(!t(i))throw new n("result is required");var a=r.x,o=r.y,u=r.z,s=e[0]*a+e[3]*o+e[6]*u,f=e[1]*a+e[4]*o+e[7]*u,l=e[2]*a+e[5]*o+e[8]*u;return i.x=s,i.y=f,i.z=l,i},f.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scalar must be a number");if(!t(i))throw new n("result is required");return i[0]=e[0]*r,i[1]=e[1]*r,i[2]=e[2]*r,i[3]=e[3]*r,i[4]=e[4]*r,i[5]=e[5]*r,i[6]=e[6]*r,i[7]=e[7]*r,i[8]=e[8]*r,i},f.multiplyByScale=function(e,r,i){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("scale is required");if(!t(i))throw new n("result is required");return i[0]=e[0]*r.x,i[1]=e[1]*r.x,i[2]=e[2]*r.x,i[3]=e[3]*r.y,i[4]=e[4]*r.y,i[5]=e[5]*r.y,i[6]=e[6]*r.z,i[7]=e[7]*r.z,i[8]=e[8]*r.z,i},f.negate=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");return r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},f.transpose=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");var i=e[0],a=e[3],o=e[6],u=e[1],s=e[4],f=e[7],l=e[2],c=e[5],d=e[8];return r[0]=i,r[1]=a,r[2]=o,r[3]=u,r[4]=s,r[5]=f,r[6]=l,r[7]=c,r[8]=d,r};var d=[1,0,0],h=[2,2,1],w=new f,m=new f;return f.computeEigenDecomposition=function(e,r){if(!t(e))throw new n("matrix is required.");var i=a.EPSILON20,l=10,c=0,d=0;t(r)||(r={});for(var h=r.unitary=f.clone(f.IDENTITY,r.unitary),p=r.diagonal=f.clone(e,r.diagonal),y=i*o(p);l>d&&u(p)>y;)s(p,w),f.transpose(w,m),f.multiply(p,w,p),f.multiply(m,p,p),f.multiply(h,w,h),++c>2&&(++d,c=0);return r},f.abs=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");return r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},f.determinant=function(e){if(!t(e))throw new n("matrix is required");var r=e[0],i=e[3],a=e[6],o=e[1],u=e[4],s=e[7],f=e[2],l=e[5],c=e[8];return r*(u*c-l*s)+o*(l*a-i*c)+f*(i*s-u*a)},f.inverse=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");var i=e[0],o=e[1],u=e[2],s=e[3],l=e[4],c=e[5],d=e[6],h=e[7],w=e[8],m=f.determinant(e);if(Math.abs(m)<=a.EPSILON15)throw new n("matrix is not invertible");r[0]=l*w-h*c,r[1]=h*u-o*w,r[2]=o*c-l*u,r[3]=d*c-s*w,r[4]=i*w-d*u,r[5]=s*u-i*c,r[6]=s*h-d*l,r[7]=d*o-i*h,r[8]=i*l-s*o;var p=1/m;return f.multiplyByScalar(r,p,r)},f.equals=function(e,r){return e===r||t(e)&&t(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]},f.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon must be a number");return e===r||t(e)&&t(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},f.IDENTITY=i(new f(1,0,0,0,1,0,0,0,1)),f.ZERO=i(new f(0,0,0,0,0,0,0,0,0)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN1ROW0=3,f.COLUMN1ROW1=4,f.COLUMN1ROW2=5,f.COLUMN2ROW0=6,f.COLUMN2ROW1=7,f.COLUMN2ROW2=8,f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.equalsArray=function(e,r,t){return e[0]===r[t]&&e[1]===r[t+1]&&e[2]===r[t+2]&&e[3]===r[t+3]&&e[4]===r[t+4]&&e[5]===r[t+5]&&e[6]===r[t+6]&&e[7]===r[t+7]&&e[8]===r[t+8]},f.prototype.equalsEpsilon=function(e,r){return f.equalsEpsilon(this,e,r)},f.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},f}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var r=function(e){this.name="RuntimeError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,r,t,n,i,a,o,u,s){"use strict";var f=function(e,r,n,i,a,o,u,s,f,l,c,d,h,w,m,p){this[0]=t(e,0),this[1]=t(a,0),this[2]=t(f,0),this[3]=t(h,0),this[4]=t(r,0),this[5]=t(o,0),this[6]=t(l,0),this[7]=t(w,0),this[8]=t(n,0),this[9]=t(u,0),this[10]=t(c,0),this[11]=t(m,0),this[12]=t(i,0),this[13]=t(s,0),this[14]=t(d,0),this[15]=t(p,0)};f.packedLength=16,f.pack=function(e,r,a){if(!n(e))throw new i("value is required");if(!n(r))throw new i("array is required");a=t(a,0),r[a++]=e[0],r[a++]=e[1],r[a++]=e[2],r[a++]=e[3],r[a++]=e[4],r[a++]=e[5],r[a++]=e[6],r[a++]=e[7],r[a++]=e[8],r[a++]=e[9],r[a++]=e[10],r[a++]=e[11],r[a++]=e[12],r[a++]=e[13],r[a++]=e[14],r[a]=e[15]},f.unpack=function(e,r,a){if(!n(e))throw new i("array is required");return r=t(r,0),n(a)||(a=new f),a[0]=e[r++],a[1]=e[r++],a[2]=e[r++],a[3]=e[r++],a[4]=e[r++],a[5]=e[r++],a[6]=e[r++],a[7]=e[r++],a[8]=e[r++],a[9]=e[r++],a[10]=e[r++],a[11]=e[r++],a[12]=e[r++],a[13]=e[r++],a[14]=e[r++],a[15]=e[r],a},f.clone=function(e,r){return n(e)?n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):new f(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},f.fromArray=f.unpack,f.fromColumnMajorArray=function(e,r){if(!n(e))throw new i("values is required");return f.clone(e,r)},f.fromRowMajorArray=function(e,r){if(!n(e))throw new i("values is required.");return n(r)?(r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=e[1],r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=e[2],r[9]=e[6],r[10]=e[10],r[11]=e[14],r[12]=e[3],r[13]=e[7],r[14]=e[11],r[15]=e[15],r):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},f.fromRotationTranslation=function(r,a,o){if(!n(r))throw new i("rotation is required.");return a=t(a,e.ZERO),n(o)?(o[0]=r[0],o[1]=r[1],o[2]=r[2],o[3]=0,o[4]=r[3],o[5]=r[4],o[6]=r[5],o[7]=0,o[8]=r[6],o[9]=r[7],o[10]=r[8],o[11]=0,o[12]=a.x,o[13]=a.y,o[14]=a.z,o[15]=1,o):new f(r[0],r[3],r[6],a.x,r[1],r[4],r[7],a.y,r[2],r[5],r[8],a.z,0,0,0,1)},f.fromTranslationQuaternionRotationScale=function(e,r,t,a){if(!n(e))throw new i("translation is required.");if(!n(r))throw new i("rotation is required.");if(!n(t))throw new i("scale is required.");n(a)||(a=new f);var o=t.x,u=t.y,s=t.z,l=r.x*r.x,c=r.x*r.y,d=r.x*r.z,h=r.x*r.w,w=r.y*r.y,m=r.y*r.z,p=r.y*r.w,y=r.z*r.z,v=r.z*r.w,q=r.w*r.w,g=l-w-y+q,x=2*(c-v),S=2*(d+p),b=2*(c+v),E=-l+w-y+q,M=2*(m-h),O=2*(d-p),P=2*(m+h),_=-l-w+y+q;return a[0]=g*o,a[1]=b*o,a[2]=O*o,a[3]=0,a[4]=x*u,a[5]=E*u,a[6]=P*u,a[7]=0,a[8]=S*s,a[9]=M*s,a[10]=_*s,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},f.fromTranslation=function(e,r){if(!n(e))throw new i("translation is required.");return f.fromRotationTranslation(u.IDENTITY,e,r)},f.fromScale=function(e,r){if(!n(e))throw new i("scale is required.");return n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e.y,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e.z,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new f(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},f.fromUniformScale=function(e,r){if("number"!=typeof e)throw new i("scale is required.");return n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new f(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,c=new e,d=new e;f.fromCamera=function(r,t){if(!n(r))throw new i("camera is required.");var a=r.eye,o=r.target,u=r.up;if(!n(a))throw new i("camera.eye is required.");if(!n(o))throw new i("camera.target is required.");if(!n(u))throw new i("camera.up is required.");e.normalize(e.subtract(o,a,l),l),e.normalize(e.cross(l,u,c),c),e.normalize(e.cross(c,l,d),d);var s=c.x,h=c.y,w=c.z,m=l.x,p=l.y,y=l.z,v=d.x,q=d.y,g=d.z,x=a.x,S=a.y,b=a.z,E=s*-x+h*-S+w*-b,M=v*-x+q*-S+g*-b,O=m*x+p*S+y*b;return n(t)?(t[0]=s,t[1]=v,t[2]=-m,t[3]=0,t[4]=h,t[5]=q,t[6]=-p,t[7]=0,t[8]=w,t[9]=g,t[10]=-y,t[11]=0,t[12]=E,t[13]=M,t[14]=O,t[15]=1,t):new f(s,h,w,E,v,q,g,M,-m,-p,-y,O,0,0,0,1)},f.computePerspectiveFieldOfView=function(e,r,t,a,o){if(0>=e||e>Math.PI)throw new i("fovY must be in [0, PI).");if(0>=r)throw new i("aspectRatio must be greater than zero.");if(0>=t)throw new i("near must be greater than zero.");if(0>=a)throw new i("far must be greater than zero.");if(!n(o))throw new i("result is required");var u=Math.tan(.5*e),s=1/u,f=s/r,l=(a+t)/(t-a),c=2*a*t/(t-a);return o[0]=f,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=l,o[11]=-1,o[12]=0,o[13]=0,o[14]=c,o[15]=0,o},f.computeOrthographicOffCenter=function(e,r,t,a,o,u,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");if(!n(u))throw new i("far is required.");if(!n(s))throw new i("result is required");var f=1/(r-e),l=1/(a-t),c=1/(u-o),d=-(r+e)*f,h=-(a+t)*l,w=-(u+o)*c;return f*=2,l*=2,c*=-2,s[0]=f,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=l,s[6]=0,s[7]=0,s[8]=0,s[9]=0,s[10]=c,s[11]=0,s[12]=d,s[13]=h,s[14]=w,s[15]=1,s},f.computePerspectiveOffCenter=function(e,r,t,a,o,u,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");if(!n(u))throw new i("far is required.");if(!n(s))throw new i("result is required");var f=2*o/(r-e),l=2*o/(a-t),c=(r+e)/(r-e),d=(a+t)/(a-t),h=-(u+o)/(u-o),w=-1,m=-2*u*o/(u-o);return s[0]=f,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=l,s[6]=0,s[7]=0,s[8]=c,s[9]=d,s[10]=h,s[11]=w,s[12]=0,s[13]=0,s[14]=m,s[15]=0,s},f.computeInfinitePerspectiveOffCenter=function(e,r,t,a,o,u){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");if(!n(u))throw new i("result is required");var s=2*o/(r-e),f=2*o/(a-t),l=(r+e)/(r-e),c=(a+t)/(a-t),d=-1,h=-1,w=-2*o;return u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=f,u[6]=0,u[7]=0,u[8]=l,u[9]=c,u[10]=d,u[11]=h,u[12]=0,u[13]=0,u[14]=w,u[15]=0,u},f.computeViewportTransformation=function(e,r,a,o){if(!n(o))throw new i("result is required");e=t(e,t.EMPTY_OBJECT);var u=t(e.x,0),s=t(e.y,0),f=t(e.width,0),l=t(e.height,0);r=t(r,0),a=t(a,1);var c=.5*f,d=.5*l,h=.5*(a-r),w=c,m=d,p=h,y=u+c,v=s+d,q=r+h,g=1;return o[0]=w,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=m,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=p,o[11]=0,o[12]=y,o[13]=v,o[14]=q,o[15]=g,o},f.toArray=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},f.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>3)throw new i("row must be 0, 1, 2, or 3.");if("number"!=typeof e||0>e||e>3)throw new i("column must be 0, 1, 2, or 3.");return 4*e+r},f.getColumn=function(e,r,t){if(!n(e))throw new i("matrix is required.");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(t))throw new i("result is required");var a=4*r,o=e[a],u=e[a+1],s=e[a+2],f=e[a+3];return t.x=o,t.y=u,t.z=s,t.w=f,t},f.setColumn=function(e,r,t,a){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(a))throw new i("result is required");a=f.clone(e,a);var o=4*r;return a[o]=t.x,a[o+1]=t.y,a[o+2]=t.z,a[o+3]=t.w,a},f.setTranslation=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("translation is required");if(!n(t))throw new i("result is required");return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=r.x,t[13]=r.y,t[14]=r.z,t[15]=e[15],t},f.getRow=function(e,r,t){if(!n(e))throw new i("matrix is required.");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(t))throw new i("result is required");var a=e[r],o=e[r+4],u=e[r+8],s=e[r+12];return t.x=a,t.y=o,t.z=u,t.w=s,t},f.setRow=function(e,r,t,a){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(a))throw new i("result is required");return a=f.clone(e,a),a[r]=t.x,a[r+4]=t.y,a[r+8]=t.z,a[r+12]=t.w,a};var h=new e;f.getScale=function(r,t){if(!n(r))throw new i("matrix is required.");if(!n(t))throw new i("result is required");return t.x=e.magnitude(e.fromElements(r[0],r[1],r[2],h)),t.y=e.magnitude(e.fromElements(r[4],r[5],r[6],h)),t.z=e.magnitude(e.fromElements(r[8],r[9],r[10],h)),t};var w=new e;f.getMaximumScale=function(r){return f.getScale(r,w),e.maximumComponent(w)},f.multiply=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");var a=e[0],o=e[1],u=e[2],s=e[3],f=e[4],l=e[5],c=e[6],d=e[7],h=e[8],w=e[9],m=e[10],p=e[11],y=e[12],v=e[13],q=e[14],g=e[15],x=r[0],S=r[1],b=r[2],E=r[3],M=r[4],O=r[5],P=r[6],_=r[7],R=r[8],C=r[9],z=r[10],T=r[11],I=r[12],N=r[13],A=r[14],D=r[15],U=a*x+f*S+h*b+y*E,L=o*x+l*S+w*b+v*E,W=u*x+c*S+m*b+q*E,B=s*x+d*S+p*b+g*E,F=a*M+f*O+h*P+y*_,V=o*M+l*O+w*P+v*_,j=u*M+c*O+m*P+q*_,k=s*M+d*O+p*P+g*_,Z=a*R+f*C+h*z+y*T,H=o*R+l*C+w*z+v*T,Y=u*R+c*C+m*z+q*T,X=s*R+d*C+p*z+g*T,G=a*I+f*N+h*A+y*D,J=o*I+l*N+w*A+v*D,Q=u*I+c*N+m*A+q*D,$=s*I+d*N+p*A+g*D;return t[0]=U,t[1]=L,t[2]=W,t[3]=B,t[4]=F,t[5]=V,t[6]=j,t[7]=k,t[8]=Z,t[9]=H,t[10]=Y,t[11]=X,t[12]=G,t[13]=J,t[14]=Q,t[15]=$,t},f.add=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t[6]=e[6]+r[6],t[7]=e[7]+r[7],t[8]=e[8]+r[8],t[9]=e[9]+r[9],t[10]=e[10]+r[10],t[11]=e[11]+r[11],t[12]=e[12]+r[12],t[13]=e[13]+r[13],t[14]=e[14]+r[14],t[15]=e[15]+r[15],t},f.subtract=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t[4]=e[4]-r[4],t[5]=e[5]-r[5],t[6]=e[6]-r[6],t[7]=e[7]-r[7],t[8]=e[8]-r[8],t[9]=e[9]-r[9],t[10]=e[10]-r[10],t[11]=e[11]-r[11],t[12]=e[12]-r[12],t[13]=e[13]-r[13],t[14]=e[14]-r[14],t[15]=e[15]-r[15],t},f.multiplyTransformation=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");var a=e[0],o=e[1],u=e[2],s=e[4],f=e[5],l=e[6],c=e[8],d=e[9],h=e[10],w=e[12],m=e[13],p=e[14],y=r[0],v=r[1],q=r[2],g=r[4],x=r[5],S=r[6],b=r[8],E=r[9],M=r[10],O=r[12],P=r[13],_=r[14],R=a*y+s*v+c*q,C=o*y+f*v+d*q,z=u*y+l*v+h*q,T=a*g+s*x+c*S,I=o*g+f*x+d*S,N=u*g+l*x+h*S,A=a*b+s*E+c*M,D=o*b+f*E+d*M,U=u*b+l*E+h*M,L=a*O+s*P+c*_+w,W=o*O+f*P+d*_+m,B=u*O+l*P+h*_+p;return t[0]=R,t[1]=C,t[2]=z,t[3]=0,t[4]=T,t[5]=I,t[6]=N,t[7]=0,t[8]=A,t[9]=D,t[10]=U,t[11]=0,t[12]=L,t[13]=W,t[14]=B,t[15]=1,t},f.multiplyByMatrix3=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("rotation is required");if(!n(t))throw new i("result is required");var a=e[0],o=e[1],u=e[2],s=e[4],f=e[5],l=e[6],c=e[8],d=e[9],h=e[10],w=r[0],m=r[1],p=r[2],y=r[3],v=r[4],q=r[5],g=r[6],x=r[7],S=r[8],b=a*w+s*m+c*p,E=o*w+f*m+d*p,M=u*w+l*m+h*p,O=a*y+s*v+c*q,P=o*y+f*v+d*q,_=u*y+l*v+h*q,R=a*g+s*x+c*S,C=o*g+f*x+d*S,z=u*g+l*x+h*S;return t[0]=b,t[1]=E,t[2]=M,t[3]=0,t[4]=O,t[5]=P,t[6]=_,t[7]=0,t[8]=R,t[9]=C,t[10]=z,t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},f.multiplyByTranslation=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("translation is required");if(!n(t))throw new i("result is required");var a=r.x,o=r.y,u=r.z,s=a*e[0]+o*e[4]+u*e[8]+e[12],f=a*e[1]+o*e[5]+u*e[9]+e[13],l=a*e[2]+o*e[6]+u*e[10]+e[14];return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=s,t[13]=f,t[14]=l,t[15]=e[15],t};var m=new e;f.multiplyByUniformScale=function(e,r,t){if(!n(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scale is required");if(!n(t))throw new i("result is required");return m.x=r,m.y=r,m.z=r,f.multiplyByScale(e,m,t)},f.multiplyByScale=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("scale is required");if(!n(t))throw new i("result is required");var a=r.x,o=r.y,u=r.z;return 1===a&&1===o&&1===u?f.clone(e,t):(t[0]=a*e[0],t[1]=a*e[1],t[2]=a*e[2],t[3]=0,t[4]=o*e[4],t[5]=o*e[5],t[6]=o*e[6],t[7]=0,t[8]=u*e[8],t[9]=u*e[9],t[10]=u*e[10],t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=1,t)},f.multiplyByVector=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if(!n(t))throw new i("result is required");var a=r.x,o=r.y,u=r.z,s=r.w,f=e[0]*a+e[4]*o+e[8]*u+e[12]*s,l=e[1]*a+e[5]*o+e[9]*u+e[13]*s,c=e[2]*a+e[6]*o+e[10]*u+e[14]*s,d=e[3]*a+e[7]*o+e[11]*u+e[15]*s;return t.x=f,t.y=l,t.z=c,t.w=d,t},f.multiplyByPointAsVector=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if(!n(t))throw new i("result is required");var a=r.x,o=r.y,u=r.z,s=e[0]*a+e[4]*o+e[8]*u,f=e[1]*a+e[5]*o+e[9]*u,l=e[2]*a+e[6]*o+e[10]*u;return t.x=s,t.y=f,t.z=l,t},f.multiplyByPoint=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if(!n(t))throw new i("result is required");var a=r.x,o=r.y,u=r.z,s=e[0]*a+e[4]*o+e[8]*u+e[12],f=e[1]*a+e[5]*o+e[9]*u+e[13],l=e[2]*a+e[6]*o+e[10]*u+e[14];return t.x=s,t.y=f,t.z=l,t},f.multiplyByScalar=function(e,r,t){if(!n(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scalar must be a number");if(!n(t))throw new i("result is required");return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t},f.negate=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r[9]=-e[9],r[10]=-e[10],r[11]=-e[11],r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=-e[15],r},f.transpose=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");var t=e[1],a=e[2],o=e[3],u=e[6],s=e[7],f=e[11];return r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=t,r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=a,r[9]=u,r[10]=e[10],r[11]=e[14],r[12]=o,r[13]=s,r[14]=f,r[15]=e[15],r},f.abs=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r[9]=Math.abs(e[9]),r[10]=Math.abs(e[10]),r[11]=Math.abs(e[11]),r[12]=Math.abs(e[12]),r[13]=Math.abs(e[13]),r[14]=Math.abs(e[14]),r[15]=Math.abs(e[15]),r},f.equals=function(e,r){return e===r||n(e)&&n(r)&&e[12]===r[12]&&e[13]===r[13]&&e[14]===r[14]&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[8]===r[8]&&e[9]===r[9]&&e[10]===r[10]&&e[3]===r[3]&&e[7]===r[7]&&e[11]===r[11]&&e[15]===r[15]},f.equalsEpsilon=function(e,r,t){if("number"!=typeof t)throw new i("epsilon must be a number");return e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=t&&Math.abs(e[1]-r[1])<=t&&Math.abs(e[2]-r[2])<=t&&Math.abs(e[3]-r[3])<=t&&Math.abs(e[4]-r[4])<=t&&Math.abs(e[5]-r[5])<=t&&Math.abs(e[6]-r[6])<=t&&Math.abs(e[7]-r[7])<=t&&Math.abs(e[8]-r[8])<=t&&Math.abs(e[9]-r[9])<=t&&Math.abs(e[10]-r[10])<=t&&Math.abs(e[11]-r[11])<=t&&Math.abs(e[12]-r[12])<=t&&Math.abs(e[13]-r[13])<=t&&Math.abs(e[14]-r[14])<=t&&Math.abs(e[15]-r[15])<=t},f.getTranslation=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r.x=e[12],r.y=e[13],r.z=e[14],r},f.getRotation=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[4],r[4]=e[5],r[5]=e[6],r[6]=e[8],r[7]=e[9],r[8]=e[10],r};var p=new u,y=new u,v=new r,q=new r(0,0,0,1);return f.inverse=function(e,t){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("result is required");if(u.equalsEpsilon(f.getRotation(e,p),y,o.EPSILON7)&&r.equals(f.getRow(e,3,v),q))return t[0]=0,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=0,t[11]=0,t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=1,t;var a=e[0],l=e[4],c=e[8],d=e[12],h=e[1],w=e[5],m=e[9],g=e[13],x=e[2],S=e[6],b=e[10],E=e[14],M=e[3],O=e[7],P=e[11],_=e[15],R=b*_,C=E*P,z=S*_,T=E*O,I=S*P,N=b*O,A=x*_,D=E*M,U=x*P,L=b*M,W=x*O,B=S*M,F=R*w+T*m+I*g-(C*w+z*m+N*g),V=C*h+A*m+L*g-(R*h+D*m+U*g),j=z*h+D*w+W*g-(T*h+A*w+B*g),k=N*h+U*w+B*m-(I*h+L*w+W*m),Z=C*l+z*c+N*d-(R*l+T*c+I*d),H=R*a+D*c+U*d-(C*a+A*c+L*d),Y=T*a+A*l+B*d-(z*a+D*l+W*d),X=I*a+L*l+W*c-(N*a+U*l+B*c);R=c*g,C=d*m,z=l*g,T=d*w,I=l*m,N=c*w,A=a*g,D=d*h,U=a*m,L=c*h,W=a*w,B=l*h;var G=R*O+T*P+I*_-(C*O+z*P+N*_),J=C*M+A*P+L*_-(R*M+D*P+U*_),Q=z*M+D*O+W*_-(T*M+A*O+B*_),$=N*M+U*O+B*P-(I*M+L*O+W*P),K=z*b+N*E+C*S-(I*E+R*S+T*b),ee=U*E+R*x+D*b-(A*b+L*E+C*x),re=A*S+B*E+T*x-(W*E+z*x+D*S),te=W*b+I*x+L*S-(U*S+B*b+N*x),ne=a*F+l*V+c*j+d*k;if(Math.abs(ne)<o.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return ne=1/ne,t[0]=F*ne,t[1]=V*ne,t[2]=j*ne,t[3]=k*ne,t[4]=Z*ne,t[5]=H*ne,t[6]=Y*ne,t[7]=X*ne,t[8]=G*ne,t[9]=J*ne,t[10]=Q*ne,t[11]=$*ne,t[12]=K*ne,t[13]=ee*ne,t[14]=re*ne,t[15]=te*ne,t},f.inverseTransformation=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");var t=e[0],a=e[1],o=e[2],u=e[4],s=e[5],f=e[6],l=e[8],c=e[9],d=e[10],h=e[12],w=e[13],m=e[14],p=-t*h-a*w-o*m,y=-u*h-s*w-f*m,v=-l*h-c*w-d*m;return r[0]=t,r[1]=u,r[2]=l,r[3]=0,r[4]=a,r[5]=s,r[6]=c,r[7]=0,r[8]=o,r[9]=f,r[10]=d,r[11]=0,r[12]=p,r[13]=y,r[14]=v,r[15]=1,r},f.IDENTITY=a(new f(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),f.ZERO=a(new f(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN0ROW3=3,f.COLUMN1ROW0=4,f.COLUMN1ROW1=5,f.COLUMN1ROW2=6,f.COLUMN1ROW3=7,f.COLUMN2ROW0=8,f.COLUMN2ROW1=9,f.COLUMN2ROW2=10,f.COLUMN2ROW3=11,f.COLUMN3ROW0=12,f.COLUMN3ROW1=13,f.COLUMN3ROW2=14,f.COLUMN3ROW3=15,f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.equalsArray=function(e,r,t){return e[0]===r[t]&&e[1]===r[t+1]&&e[2]===r[t+2]&&e[3]===r[t+3]&&e[4]===r[t+4]&&e[5]===r[t+5]&&e[6]===r[t+6]&&e[7]===r[t+7]&&e[8]===r[t+8]&&e[9]===r[t+9]&&e[10]===r[t+10]&&e[11]===r[t+11]&&e[12]===r[t+12]&&e[13]===r[t+13]&&e[14]===r[t+14]&&e[15]===r[t+15]},f.prototype.equalsEpsilon=function(e,r){return f.equalsEpsilon(this,e,r)},f.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},f}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,r,t,n){"use strict";var i=function(n,i){if(!r(n))throw new t("normal is required.");if(!r(i))throw new t("distance is required.");this.normal=e.clone(n),this.distance=i};i.fromPointNormal=function(n,a,o){if(!r(n))throw new t("point is required.");if(!r(a))throw new t("normal is required.");var u=-e.dot(a,n);return r(o)?(e.clone(a,o.normal),o.distance=u,o):new i(a,u)};var a=new e;return i.fromCartesian4=function(n,o){if(!r(n))throw new t("coefficients is required.");var u=e.fromCartesian4(n,a),s=n.w;return r(o)?(e.clone(u,o.normal),o.distance=s,o):new i(u,s)},i.getPointDistance=function(n,i){if(!r(n))throw new t("plane is required.");if(!r(i))throw new t("point is required.");return e.dot(n.normal,i)+n.distance},i.ORIGIN_XY_PLANE=n(new i(e.UNIT_Z,0)),i.ORIGIN_YZ_PLANE=n(new i(e.UNIT_X,0)),i.ORIGIN_ZX_PLANE=n(new i(e.UNIT_Y,0)),i}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,r,t,n,i,a,o,u){"use strict";var s=function(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)};n(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,a){if(!t(e))throw new i("value is required");if(!t(n))throw new i("array is required");a=r(a,0),n[a++]=e.west,n[a++]=e.south,n[a++]=e.east,n[a]=e.north},s.unpack=function(e,n,a){if(!t(e))throw new i("array is required");return n=r(n,0),t(a)||(a=new s),a.west=e[n++],a.south=e[n++],a.east=e[n++],a.north=e[n],a},s.computeWidth=function(e){if(!t(e))throw new i("rectangle is required.");var r=e.east,n=e.west;return n>r&&(r+=u.TWO_PI),r-n},s.computeHeight=function(e){if(!t(e))throw new i("rectangle is required.");return e.north-e.south},s.fromDegrees=function(e,n,i,a,o){return e=u.toRadians(r(e,0)),n=u.toRadians(r(n,0)),i=u.toRadians(r(i,0)),a=u.toRadians(r(a,0)),t(o)?(o.west=e,o.south=n,o.east=i,o.north=a,o):new s(e,n,i,a)},s.fromCartographicArray=function(e,r){if(!t(e))throw new i("cartographics is required.");for(var n=Number.MAX_VALUE,a=-Number.MAX_VALUE,o=Number.MAX_VALUE,u=-Number.MAX_VALUE,f=0,l=e.length;l>f;f++){var c=e[f];n=Math.min(n,c.longitude),a=Math.max(a,c.longitude),o=Math.min(o,c.latitude),u=Math.max(u,c.latitude)}return t(r)?(r.west=n,r.south=o,r.east=a,r.north=u,r):new s(n,o,a,u)},s.clone=function(e,r){return t(e)?t(r)?(r.west=e.west,r.south=e.south,r.east=e.east,r.north=e.north,r):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.west===r.west&&e.south===r.south&&e.east===r.east&&e.north===r.north},s.prototype.equalsEpsilon=function(e,r){if("number"!=typeof r)throw new i("epsilon is required and must be a number.");return t(e)&&Math.abs(this.west-e.west)<=r&&Math.abs(this.south-e.south)<=r&&Math.abs(this.east-e.east)<=r&&Math.abs(this.north-e.north)<=r},s.validate=function(e){if(!t(e))throw new i("rectangle is required");var r=e.north;if("number"!=typeof r)throw new i("north is required to be a number.");if(r<-u.PI_OVER_TWO||r>u.PI_OVER_TWO)throw new i("north must be in the interval [-Pi/2, Pi/2].");var n=e.south;if("number"!=typeof n)throw new i("south is required to be a number.");if(n<-u.PI_OVER_TWO||n>u.PI_OVER_TWO)throw new i("south must be in the interval [-Pi/2, Pi/2].");var a=e.west;if("number"!=typeof a)throw new i("west is required to be a number.");if(a<-Math.PI||a>Math.PI)throw new i("west must be in the interval [-Pi, Pi].");var o=e.east;if("number"!=typeof o)throw new i("east is required to be a number.");if(o<-Math.PI||o>Math.PI)throw new i("east must be in the interval [-Pi, Pi].")},s.southwest=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.west,n.latitude=r.south,n.height=0,n):new e(r.west,r.south)},s.northwest=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.west,n.latitude=r.north,n.height=0,n):new e(r.west,r.north)},s.northeast=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.east,n.latitude=r.north,n.height=0,n):new e(r.east,r.north)},s.southeast=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.east,n.latitude=r.south,n.height=0,n):new e(r.east,r.south)},s.center=function(r,n){if(!t(r))throw new i("rectangle is required");var a=r.east,o=r.west;o>a&&(a+=u.TWO_PI);var s=u.negativePiToPi(.5*(o+a)),f=.5*(r.south+r.north);return t(n)?(n.longitude=s,n.latitude=f,n.height=0,n):new e(s,f)},s.intersection=function(e,r,n){if(!t(e))throw new i("rectangle is required");if(!t(r))throw new i("otherRectangle is required.");var a=e.east,o=e.west,f=r.east,l=r.west;o>a&&f>0?a+=u.TWO_PI:l>f&&a>0&&(f+=u.TWO_PI),o>a&&0>l?l+=u.TWO_PI:l>f&&0>o&&(o+=u.TWO_PI);var c=u.negativePiToPi(Math.max(o,l)),d=u.negativePiToPi(Math.min(a,f));if((e.west<e.east||r.west<r.east)&&c>=d)return void 0;var h=Math.max(e.south,r.south),w=Math.min(e.north,r.north);return h>=w?void 0:t(n)?(n.west=c,n.south=h,n.east=d,n.north=w,n):new s(c,h,d,w)},s.contains=function(e,r){if(!t(e))throw new i("rectangle is required");if(!t(r))throw new i("cartographic is required.");var n=r.longitude,a=r.latitude,o=e.west,s=e.east;return o>s&&(s+=u.TWO_PI,0>n&&(n+=u.TWO_PI)),(n>o||u.equalsEpsilon(n,o,u.EPSILON14))&&(s>n||u.equalsEpsilon(n,s,u.EPSILON14))&&a>=e.south&&a<=e.north};var f=new e;return s.subsample=function(e,n,o,l){if(!t(e))throw new i("rectangle is required");n=r(n,a.WGS84),o=r(o,0),t(l)||(l=[]);var c=0,d=e.north,h=e.south,w=e.east,m=e.west,p=f;p.height=o,p.longitude=m,p.latitude=d,l[c]=n.cartographicToCartesian(p,l[c]),c++,p.longitude=w,l[c]=n.cartographicToCartesian(p,l[c]),c++,p.latitude=h,l[c]=n.cartographicToCartesian(p,l[c]),c++,p.longitude=m,l[c]=n.cartographicToCartesian(p,l[c]),c++,0>d?p.latitude=d:h>0?p.latitude=h:p.latitude=0;for(var y=1;8>y;++y)p.longitude=-Math.PI+y*u.PI_OVER_TWO,s.contains(e,p)&&(l[c]=n.cartographicToCartesian(p,l[c]),c++);return 0===p.latitude&&(p.longitude=m,l[c]=n.cartographicToCartesian(p,l[c]),c++,p.longitude=w,l[c]=n.cartographicToCartesian(p,l[c]),c++),l.length=c,l},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Plane","./Rectangle"],function(e,r,t,n,i,a,o,u,s,f,l,c,d){
"use strict";var h=function(r,n){this.center=e.clone(t(r,e.ZERO)),this.radius=t(n,0)},w=new e,m=new e,p=new e,y=new e,v=new e,q=new e,g=new e,x=new e,S=new e,b=new e,E=new e,M=new e;h.fromPoints=function(r,t){if(n(t)||(t=new h),!n(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;for(var i=e.clone(r[0],g),a=e.clone(i,w),o=e.clone(i,m),u=e.clone(i,p),s=e.clone(i,y),f=e.clone(i,v),l=e.clone(i,q),c=r.length,d=1;c>d;d++){e.clone(r[d],i);var O=i.x,P=i.y,_=i.z;O<a.x&&e.clone(i,a),O>s.x&&e.clone(i,s),P<o.y&&e.clone(i,o),P>f.y&&e.clone(i,f),_<u.z&&e.clone(i,u),_>l.z&&e.clone(i,l)}var R=e.magnitudeSquared(e.subtract(s,a,x)),C=e.magnitudeSquared(e.subtract(f,o,x)),z=e.magnitudeSquared(e.subtract(l,u,x)),T=a,I=s,N=R;C>N&&(N=C,T=o,I=f),z>N&&(N=z,T=u,I=l);var A=S;A.x=.5*(T.x+I.x),A.y=.5*(T.y+I.y),A.z=.5*(T.z+I.z);var D=e.magnitudeSquared(e.subtract(I,A,x)),U=Math.sqrt(D),L=b;L.x=a.x,L.y=o.y,L.z=u.z;var W=E;W.x=s.x,W.y=f.y,W.z=l.z;var B=e.multiplyByScalar(e.add(L,W,x),.5,M),F=0;for(d=0;c>d;d++){e.clone(r[d],i);var V=e.magnitude(e.subtract(i,B,x));V>F&&(F=V);var j=e.magnitudeSquared(e.subtract(i,A,x));if(j>D){var k=Math.sqrt(j);U=.5*(U+k),D=U*U;var Z=k-U;A.x=(U*A.x+Z*i.x)/k,A.y=(U*A.y+Z*i.y)/k,A.z=(U*A.z+Z*i.z)/k}}return F>U?(e.clone(A,t.center),t.radius=U):(e.clone(B,t.center),t.radius=F),t};var O=new u,P=new e,_=new e,R=new r,C=new r;h.fromRectangle2D=function(e,r,t){return h.fromRectangleWithHeights2D(e,r,0,0,t)},h.fromRectangleWithHeights2D=function(r,i,a,o,u){if(n(u)||(u=new h),!n(r))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;i=t(i,O),d.southwest(r,R),R.height=a,d.northeast(r,C),C.height=o;var s=i.project(R,P),f=i.project(C,_),l=f.x-s.x,c=f.y-s.y,w=f.z-s.z;u.radius=.5*Math.sqrt(l*l+c*c+w*w);var m=u.center;return m.x=s.x+.5*l,m.y=s.y+.5*c,m.z=s.z+.5*w,u};var z=[];h.fromRectangle3D=function(e,r,i,a){r=t(r,o.WGS84),i=t(i,0);var u;return n(e)&&(u=d.subsample(e,r,i,z)),h.fromPoints(u,a)},h.fromVertices=function(r,i,o,u){if(n(u)||(u=new h),!n(r)||0===r.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;if(i=t(i,e.ZERO),o=t(o,3),3>o)throw new a("stride must be 3 or greater.");var s=g;s.x=r[0]+i.x,s.y=r[1]+i.y,s.z=r[2]+i.z;for(var f=e.clone(s,w),l=e.clone(s,m),c=e.clone(s,p),d=e.clone(s,y),O=e.clone(s,v),P=e.clone(s,q),_=r.length,R=0;_>R;R+=o){var C=r[R]+i.x,z=r[R+1]+i.y,T=r[R+2]+i.z;s.x=C,s.y=z,s.z=T,C<f.x&&e.clone(s,f),C>d.x&&e.clone(s,d),z<l.y&&e.clone(s,l),z>O.y&&e.clone(s,O),T<c.z&&e.clone(s,c),T>P.z&&e.clone(s,P)}var I=e.magnitudeSquared(e.subtract(d,f,x)),N=e.magnitudeSquared(e.subtract(O,l,x)),A=e.magnitudeSquared(e.subtract(P,c,x)),D=f,U=d,L=I;N>L&&(L=N,D=l,U=O),A>L&&(L=A,D=c,U=P);var W=S;W.x=.5*(D.x+U.x),W.y=.5*(D.y+U.y),W.z=.5*(D.z+U.z);var B=e.magnitudeSquared(e.subtract(U,W,x)),F=Math.sqrt(B),V=b;V.x=f.x,V.y=l.y,V.z=c.z;var j=E;j.x=d.x,j.y=O.y,j.z=P.z;var k=e.multiplyByScalar(e.add(V,j,x),.5,M),Z=0;for(R=0;_>R;R+=o){s.x=r[R]+i.x,s.y=r[R+1]+i.y,s.z=r[R+2]+i.z;var H=e.magnitude(e.subtract(s,k,x));H>Z&&(Z=H);var Y=e.magnitudeSquared(e.subtract(s,W,x));if(Y>B){var X=Math.sqrt(Y);F=.5*(F+X),B=F*F;var G=X-F;W.x=(F*W.x+G*s.x)/X,W.y=(F*W.y+G*s.y)/X,W.z=(F*W.z+G*s.z)/X}}return Z>F?(e.clone(W,u.center),u.radius=F):(e.clone(k,u.center),u.radius=Z),u},h.fromCornerPoints=function(r,t,i){if(!n(r)||!n(t))throw new a("corner and oppositeCorner are required.");n(i)||(i=new h);var o=i.center;return e.add(r,t,o),e.multiplyByScalar(o,.5,o),i.radius=e.distance(o,t),i},h.fromEllipsoid=function(r,t){if(!n(r))throw new a("ellipsoid is required.");return n(t)||(t=new h),e.clone(e.ZERO,t.center),t.radius=r.maximumRadius,t};var T=new e;h.fromBoundingSpheres=function(r,t){if(n(t)||(t=new h),!n(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;var i=r.length;if(1===i)return h.clone(r[0],t);if(2===i)return h.union(r[0],r[1],t);for(var a=[],o=0;i>o;o++)a.push(r[o].center);t=h.fromPoints(a,t);var u=t.center,s=t.radius;for(o=0;i>o;o++){var f=r[o];s=Math.max(s,e.distance(u,f.center,T)+f.radius)}return t.radius=s,t},h.clone=function(r,t){return n(r)?n(t)?(t.center=e.clone(r.center,t.center),t.radius=r.radius,t):new h(r.center,r.radius):void 0},h.packedLength=4,h.pack=function(e,r,i){if(!n(e))throw new a("value is required");if(!n(r))throw new a("array is required");i=t(i,0);var o=e.center;r[i++]=o.x,r[i++]=o.y,r[i++]=o.z,r[i]=e.radius},h.unpack=function(e,r,i){if(!n(e))throw new a("array is required");r=t(r,0),n(i)||(i=new h);var o=i.center;return o.x=e[r++],o.y=e[r++],o.z=e[r++],i.radius=e[r],i};var I=new e,N=new e;h.union=function(r,t,i){if(!n(r))throw new a("left is required.");if(!n(t))throw new a("right is required.");n(i)||(i=new h);var o=r.center,u=r.radius,s=t.center,f=t.radius,l=e.subtract(s,o,I),c=e.magnitude(l);if(u>=c+f)return r.clone(i),i;if(f>=c+u)return t.clone(i),i;var d=.5*(u+c+f),w=e.multiplyByScalar(l,(-u+d)/c,N);return e.add(w,o,w),e.clone(w,i.center),i.radius=d,i};var A=new e;h.expand=function(r,t,i){if(!n(r))throw new a("sphere is required.");if(!n(t))throw new a("point is required.");i=h.clone(r,i);var o=e.magnitude(e.subtract(t,i.center,A));return o>i.radius&&(i.radius=o),i},h.intersectPlane=function(r,t){if(!n(r))throw new a("sphere is required.");if(!n(t))throw new a("plane is required.");var i=r.center,o=r.radius,u=t.normal,f=e.dot(u,i)+t.distance;return-o>f?s.OUTSIDE:o>f?s.INTERSECTING:s.INSIDE},h.transform=function(e,r,t){if(!n(e))throw new a("sphere is required.");if(!n(r))throw new a("transform is required.");return n(t)||(t=new h),t.center=l.multiplyByPoint(r,e.center,t.center),t.radius=l.getMaximumScale(r)*e.radius,t};var D=new e;h.distanceSquaredTo=function(r,t){if(!n(r))throw new a("sphere is required.");if(!n(t))throw new a("cartesian is required.");var i=e.subtract(r.center,t,D);return e.magnitudeSquared(i)-r.radius*r.radius},h.transformWithoutScale=function(e,r,t){if(!n(e))throw new a("sphere is required.");if(!n(r))throw new a("transform is required.");return n(t)||(t=new h),t.center=l.multiplyByPoint(r,e.center,t.center),t.radius=e.radius,t};var U=new e;h.computePlaneDistances=function(r,t,i,o){if(!n(r))throw new a("sphere is required.");if(!n(t))throw new a("position is required.");if(!n(i))throw new a("direction is required.");n(o)||(o=new f);var u=e.subtract(r.center,t,U),s=e.dot(i,u);return o.start=s-r.radius,o.stop=s+r.radius,o};for(var L=new e,W=new e,B=new e,F=new e,V=new e,j=new r,k=new Array(8),Z=0;8>Z;++Z)k[Z]=new e;var H=new u;return h.projectTo2D=function(r,i,o){if(!n(r))throw new a("sphere is required.");i=t(i,H);var u=i.ellipsoid,s=r.center,f=r.radius,l=u.geodeticSurfaceNormal(s,L),c=e.cross(e.UNIT_Z,l,W);e.normalize(c,c);var d=e.cross(l,c,B);e.normalize(d,d),e.multiplyByScalar(l,f,l),e.multiplyByScalar(d,f,d),e.multiplyByScalar(c,f,c);var w=e.negate(d,V),m=e.negate(c,F),p=k,y=p[0];e.add(l,d,y),e.add(y,c,y),y=p[1],e.add(l,d,y),e.add(y,m,y),y=p[2],e.add(l,w,y),e.add(y,m,y),y=p[3],e.add(l,w,y),e.add(y,c,y),e.negate(l,l),y=p[4],e.add(l,d,y),e.add(y,c,y),y=p[5],e.add(l,d,y),e.add(y,m,y),y=p[6],e.add(l,w,y),e.add(y,m,y),y=p[7],e.add(l,w,y),e.add(y,c,y);for(var v=p.length,q=0;v>q;++q){var g=p[q];e.add(s,g,g);var x=u.cartesianToCartographic(g,j);i.project(x,g)}o=h.fromPoints(p,o),s=o.center;var S=s.x,b=s.y,E=s.z;return s.x=E,s.y=S,s.z=b,o},h.isOccluded=function(e,r){if(!n(e))throw new a("sphere is required.");if(!n(r))throw new a("occluder is required.");return!r.isBoundingSphereVisible(e)},h.equals=function(r,t){return r===t||n(r)&&n(t)&&e.equals(r.center,t.center)&&r.radius===t.radius},h.prototype.intersectPlane=function(e){return h.intersectPlane(this,e)},h.prototype.distanceSquaredTo=function(e){return h.distanceSquaredTo(this,e)},h.prototype.computePlaneDistances=function(e,r,t){return h.computePlaneDistances(this,e,r,t)},h.prototype.isOccluded=function(e){return h.isOccluded(this,e)},h.prototype.equals=function(e){return h.equals(this,e)},h.prototype.clone=function(e){return h.clone(this,e)},h}),define("Core/EllipsoidalOccluder",["./BoundingSphere","./Cartesian3","./defaultValue","./defined","./defineProperties","./DeveloperError","./Rectangle"],function(e,r,t,n,i,a,o){"use strict";function u(e,t,n){var i=e.transformPositionToScaledSpace(t,w),a=r.magnitudeSquared(i),o=Math.sqrt(a),u=r.divideByScalar(i,o,m);a=Math.max(1,a),o=Math.max(1,o);var s=r.dot(u,n),f=r.magnitude(r.cross(u,n,u)),l=1/o,c=Math.sqrt(a-1)*l;return 1/(s*l-f*c)}function s(e,t,n){return 0>=t||t===1/0||t!==t?void 0:r.multiplyByScalar(e,t,n)}function f(e,t){return e.transformPositionToScaledSpace(t,p),r.normalize(p,p)}var l=function(e,t){if(!n(e))throw new a("ellipsoid is required.");this._ellipsoid=e,this._cameraPosition=new r,this._cameraPositionInScaledSpace=new r,this._distanceToLimbInScaledSpaceSquared=0,n(t)&&(this.cameraPosition=t)};i(l.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},cameraPosition:{get:function(){return this._cameraPosition},set:function(e){var t=this._ellipsoid,n=t.transformPositionToScaledSpace(e,this._cameraPositionInScaledSpace),i=r.magnitudeSquared(n)-1;r.clone(e,this._cameraPosition),this._cameraPositionInScaledSpace=n,this._distanceToLimbInScaledSpaceSquared=i}}});var c=new r;l.prototype.isPointVisible=function(e){var r=this._ellipsoid,t=r.transformPositionToScaledSpace(e,c);return this.isScaledSpacePointVisible(t)},l.prototype.isScaledSpacePointVisible=function(e){if(this._distanceToLimbInScaledSpaceSquared<0)return!0;var t=this._cameraPositionInScaledSpace,n=this._distanceToLimbInScaledSpaceSquared,i=r.subtract(e,t,c),a=-r.dot(i,t),o=a>n&&a*a/r.magnitudeSquared(i)>n;return!o},l.prototype.computeHorizonCullingPoint=function(e,t,i){if(!n(e))throw new a("directionToPoint is required");if(!n(t))throw new a("positions is required");n(i)||(i=new r);for(var o=this._ellipsoid,l=f(o,e),c=0,d=0,h=t.length;h>d;++d){var w=t[d],m=u(o,w,l);c=Math.max(c,m)}return s(l,c,i)};var d=new r;l.prototype.computeHorizonCullingPointFromVertices=function(e,i,o,l,c){if(!n(e))throw new a("directionToPoint is required");if(!n(i))throw new a("vertices is required");if(!n(o))throw new a("stride is required");n(c)||(c=new r),l=t(l,r.ZERO);for(var h=this._ellipsoid,w=f(h,e),m=0,p=0,y=i.length;y>p;p+=o){d.x=i[p]+l.x,d.y=i[p+1]+l.y,d.z=i[p+2]+l.z;var v=u(h,d,w);m=Math.max(m,v)}return s(w,m,c)};var h=[];l.prototype.computeHorizonCullingPointFromRectangle=function(t,i,u){if(!n(t))throw new a("rectangle is required.");var s=o.subsample(t,i,0,h),f=e.fromPoints(s);return r.magnitude(f.center)<.1*i.minimumRadius?void 0:this.computeHorizonCullingPoint(f.center,s,u)};var w=new r,m=new r,p=new r;return l}),define("Core/HeightmapTessellator",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./freezeObject","./Math","./Rectangle"],function(e,r,t,n,i,a,o,u){"use strict";var s={};return s.DEFAULT_STRUCTURE=a({heightScale:1,heightOffset:0,elementsPerHeight:1,stride:1,elementMultiplier:256,isBigEndian:!1}),s.computeVertices=function(a){if(!t(a)||!t(a.heightmap))throw new n("options.heightmap is required.");if(!t(a.width)||!t(a.height))throw new n("options.width and options.height are required.");if(!t(a.vertices))throw new n("options.vertices is required.");if(!t(a.nativeRectangle))throw new n("options.nativeRectangle is required.");if(!t(a.skirtHeight))throw new n("options.skirtHeight is required.");var f,l,c,d,h=Math.cos,w=Math.sin,m=Math.sqrt,p=Math.atan,y=Math.exp,v=o.PI_OVER_TWO,q=o.toRadians,g=a.vertices,x=a.heightmap,S=a.width,b=a.height,E=a.skirtHeight,M=r(a.isGeographic,!0),O=r(a.ellipsoid,i.WGS84),P=1/O.maximumRadius,_=a.nativeRectangle,R=a.rectangle;t(R)?(f=R.west,l=R.south,c=R.east,d=R.north):M?(f=q(_.west),l=q(_.south),c=q(_.east),d=q(_.north)):(f=_.west*P,l=v-2*p(y(-_.south*P)),c=_.east*P,d=v-2*p(y(-_.north*P)));var C=r(a.relativeToCenter,e.ZERO),z=r(a.structure,s.DEFAULT_STRUCTURE),T=r(z.heightScale,s.DEFAULT_STRUCTURE.heightScale),I=r(z.heightOffset,s.DEFAULT_STRUCTURE.heightOffset),N=r(z.elementsPerHeight,s.DEFAULT_STRUCTURE.elementsPerHeight),A=r(z.stride,s.DEFAULT_STRUCTURE.stride),D=r(z.elementMultiplier,s.DEFAULT_STRUCTURE.elementMultiplier),U=r(z.isBigEndian,s.DEFAULT_STRUCTURE.isBigEndian),L=u.computeWidth(_)/(S-1),W=u.computeHeight(_)/(b-1),B=O.radiiSquared,F=B.x,V=B.y,j=B.z,k=0,Z=65536,H=-65536,Y=0,X=b,G=0,J=S;E>0&&(--Y,++X,--G,++J);for(var Q=Y;X>Q;++Q){var $=Q;0>$&&($=0),$>=b&&($=b-1);var K=_.north-W*$;K=M?q(K):v-2*p(y(-K*P));for(var ee=h(K),re=w(K),te=j*re,ne=(K-l)/(d-l),ie=G;J>ie;++ie){var ae=ie;0>ae&&(ae=0),ae>=S&&(ae=S-1);var oe=_.west+L*ae;M?oe=q(oe):oe*=P;var ue,se=$*S*A+ae*A;if(1===N)ue=x[se];else{ue=0;var fe;if(U)for(fe=0;N>fe;++fe)ue=ue*D+x[se+fe];else for(fe=N-1;fe>=0;--fe)ue=ue*D+x[se+fe]}ue=ue*T+I,H=Math.max(H,ue),Z=Math.min(Z,ue),(ie!==ae||Q!==$)&&(ue-=E);var le=ee*h(oe),ce=ee*w(oe),de=F*le,he=V*ce,we=m(de*le+he*ce+te*re),me=1/we,pe=de*me,ye=he*me,ve=te*me;g[k++]=pe+le*ue-C.x,g[k++]=ye+ce*ue-C.y,g[k++]=ve+re*ue-C.z,g[k++]=ue;var qe=(oe-f)/(c-f);g[k++]=qe,g[k++]=ne}}return{maximumHeight:H,minimumHeight:Z}},s}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t){this.x=e(r,0),this.y=e(t,0)};a.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new a(e,t)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t):new a(e.x,e.y):void 0},a.fromCartesian3=a.clone,a.fromCartesian4=a.clone,a.packedLength=2,a.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.x,i[a]=n.y},a.unpack=function(n,i,o){if(!r(n))throw new t("array is required");return i=e(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i],o},a.fromArray=a.unpack,a.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y)},a.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y)},a.minimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i},a.maximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i},a.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitude(o)},a.distanceSquared=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitudeSquared(o)},a.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=a.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n},a.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y},a.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i},a.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i},a.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i},a.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i},a.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i},a.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n},a.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n};var u=new a;a.lerp=function(e,n,i,o){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(o))throw new t("result is required.");return a.multiplyByScalar(n,i,u),o=a.multiplyByScalar(e,1-i,o),a.add(u,o,o)};var s=new a,f=new a;a.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return a.normalize(e,s),a.normalize(n,f),i.acosClamped(a.dot(s,f))};var l=new a;return a.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=a.normalize(e,l);return a.abs(i,i),n=i.x<=i.y?a.clone(a.UNIT_X,n):a.clone(a.UNIT_Y,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},a.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]},a.equalsEpsilon=function(e,t,n,a){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,a)&&i.equalsEpsilon(e.y,t.y,n,a)},a.ZERO=n(new a(0,0)),a.UNIT_X=n(new a(1,0)),a.UNIT_Y=n(new a(0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r,t){return a.equalsEpsilon(this,e,r,t)},a.prototype.toString=function(){return"("+this.x+", "+this.y+")"},a}),define("Core/AxisAlignedBoundingBox",["./Cartesian3","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Intersect","./Plane"],function(e,r,t,n,i,a,o){"use strict";var u=function(n,i,a){this.minimum=e.clone(r(n,e.ZERO)),this.maximum=e.clone(r(i,e.ZERO)),t(a)?a=e.clone(a):(a=e.add(this.minimum,this.maximum,new e),e.multiplyByScalar(a,.5,a)),this.center=a};u.fromPoints=function(r,n){if(t(n)||(n=new u),!t(r)||0===r.length)return n.minimum=e.clone(e.ZERO,n.minimum),n.maximum=e.clone(e.ZERO,n.maximum),n.center=e.clone(e.ZERO,n.center),n;for(var i=r[0].x,a=r[0].y,o=r[0].z,s=r[0].x,f=r[0].y,l=r[0].z,c=r.length,d=1;c>d;d++){var h=r[d],w=h.x,m=h.y,p=h.z;i=Math.min(w,i),s=Math.max(w,s),a=Math.min(m,a),f=Math.max(m,f),o=Math.min(p,o),l=Math.max(p,l)}var y=n.minimum;y.x=i,y.y=a,y.z=o;var v=n.maximum;v.x=s,v.y=f,v.z=l;var q=e.add(y,v,n.center);return e.multiplyByScalar(q,.5,q),n},u.clone=function(r,n){return t(r)?t(n)?(n.minimum=e.clone(r.minimum,n.minimum),n.maximum=e.clone(r.maximum,n.maximum),n.center=e.clone(r.center,n.center),n):new u(r.minimum,r.maximum):void 0},u.equals=function(r,n){return r===n||t(r)&&t(n)&&e.equals(r.center,n.center)&&e.equals(r.minimum,n.minimum)&&e.equals(r.maximum,n.maximum)};var s=new e;return u.intersectPlane=function(r,n){if(!t(r))throw new i("box is required.");if(!t(n))throw new i("plane is required.");s=e.subtract(r.maximum,r.minimum,s);var o=e.multiplyByScalar(s,.5,s),u=n.normal,f=o.x*Math.abs(u.x)+o.y*Math.abs(u.y)+o.z*Math.abs(u.z),l=e.dot(r.center,u)+n.distance;return l-f>0?a.INSIDE:0>l+f?a.OUTSIDE:a.INTERSECTING},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.intersectPlane=function(e){return u.intersectPlane(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,r){"use strict";function t(e,t,n){var i=e+t;return r.sign(e)!==r.sign(t)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(t)))<n?0:i}var n={};return n.computeDiscriminant=function(r,t,n){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");var i=t*t-4*r*n;return i},n.computeRealRoots=function(n,i,a){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");var o;if(0===n)return 0===i?[]:[-a/i];if(0===i){if(0===a)return[0,0];var u=Math.abs(a),s=Math.abs(n);if(s>u&&u/s<r.EPSILON14)return[0,0];if(u>s&&s/u<r.EPSILON14)return[];if(o=-a/n,0>o)return[];var f=Math.sqrt(o);return[-f,f]}if(0===a)return o=-i/n,0>o?[o,0]:[0,o];var l=i*i,c=4*n*a,d=t(l,-c,r.EPSILON14);if(0>d)return[];var h=-.5*t(i,r.sign(i)*Math.sqrt(d),r.EPSILON14);return i>0?[h/n,a/h]:[a/h,h/n]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,r){"use strict";function t(e,r,t,n){var i,a,o=e,u=r/3,s=t/3,f=n,l=o*s,c=u*f,d=u*u,h=s*s,w=o*s-d,m=o*f-u*s,p=u*f-h,y=4*w*p-m*m;if(0>y){var v,q,g;d*c>=l*h?(v=o,q=w,g=-2*u*w+o*m):(v=f,q=p,g=-f*m+2*s*p);var x=0>g?-1:1,S=-x*Math.abs(v)*Math.sqrt(-y);a=-g+S;var b=a/2,E=0>b?-Math.pow(-b,1/3):Math.pow(b,1/3),M=a===S?-E:-q/E;return i=0>=q?E+M:-g/(E*E+M*M+q),d*c>=l*h?[(i-u)/o]:[-f/(i+s)]}var O=w,P=-2*u*w+o*m,_=p,R=-f*m+2*s*p,C=Math.sqrt(y),z=Math.sqrt(3)/2,T=Math.abs(Math.atan2(o*C,-P)/3);i=2*Math.sqrt(-O);var I=Math.cos(T);a=i*I;var N=i*(-I/2-z*Math.sin(T)),A=a+N>2*u?a-u:N-u,D=o,U=A/D;T=Math.abs(Math.atan2(f*C,-R)/3),i=2*Math.sqrt(-_),I=Math.cos(T),a=i*I,N=i*(-I/2-z*Math.sin(T));var L=-f,W=2*s>a+N?a+s:N+s,B=L/W,F=D*W,V=-A*W-D*L,j=A*L,k=(s*V-u*j)/(-u*V+s*F);return k>=U?B>=U?B>=k?[U,k,B]:[U,B,k]:[B,U,k]:B>=U?[k,U,B]:B>=k?[k,B,U]:[B,k,U]}var n={};return n.computeDiscriminant=function(r,t,n,i){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var a=r*r,o=t*t,u=n*n,s=i*i,f=18*r*t*n*i+o*u-27*a*s-4*(r*u*n+o*t*i);return f},n.computeRealRoots=function(n,i,a,o){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");if("number"!=typeof o)throw new e("d is a required number.");var u,s;if(0===n)return r.computeRealRoots(i,a,o);if(0===i){if(0===a){if(0===o)return[0,0,0];s=-o/n;var f=0>s?-Math.pow(-s,1/3):Math.pow(s,1/3);return[f,f,f]}return 0===o?(u=r.computeRealRoots(n,0,a),0===u.Length?[0]:[u[0],0,u[1]]):t(n,0,a,o)}return 0===a?0===o?(s=-i/n,0>s?[s,0,0]:[0,0,s]):t(n,i,0,o):0===o?(u=r.computeRealRoots(n,i,a),0===u.length?[0]:u[1]<=0?[u[0],u[1],0]:u[0]>=0?[0,u[0],u[1]]:[u[0],0,u[1]]):t(n,i,a,o)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,r,t,n){"use strict";function i(r,i,a,o){var u=r*r,s=i-3*u/8,f=a-i*r/2+u*r/8,l=o-a*r/4+i*u/16-3*u*u/256,c=e.computeRealRoots(1,2*s,s*s-4*l,-f*f);if(c.length>0){var d=-r/4,h=c[c.length-1];if(Math.abs(h)<t.EPSILON14){var w=n.computeRealRoots(1,s,l);if(2===w.length){var m,p=w[0],y=w[1];if(p>=0&&y>=0){var v=Math.sqrt(p),q=Math.sqrt(y);return[d-q,d-v,d+v,d+q]}if(p>=0&&0>y)return m=Math.sqrt(p),[d-m,d+m];if(0>p&&y>=0)return m=Math.sqrt(y),[d-m,d+m]}return[]}if(h>0){var g=Math.sqrt(h),x=(s+h-f/g)/2,S=(s+h+f/g)/2,b=n.computeRealRoots(1,g,x),E=n.computeRealRoots(1,-g,S);return 0!==b.length?(b[0]+=d,b[1]+=d,0!==E.length?(E[0]+=d,E[1]+=d,b[1]<=E[0]?[b[0],b[1],E[0],E[1]]:E[1]<=b[0]?[E[0],E[1],b[0],b[1]]:b[0]>=E[0]&&b[1]<=E[1]?[E[0],b[0],b[1],E[1]]:E[0]>=b[0]&&E[1]<=b[1]?[b[0],E[0],E[1],b[1]]:b[0]>E[0]&&b[0]<E[1]?[E[0],b[0],E[1],b[1]]:[b[0],E[0],b[1],E[1]]):b):0!==E.length?(E[0]+=d,E[1]+=d,E):[]}}return[]}function a(r,i,a,o){var u=a*a,s=i*i,f=r*r,l=-2*i,c=a*r+s-4*o,d=f*o-a*i*r+u,h=e.computeRealRoots(1,l,c,d);if(h.length>0){var w,m,p=h[0],y=i-p,v=y*y,q=r/2,g=y/2,x=v-4*o,S=v+4*Math.abs(o),b=f-4*p,E=f+4*Math.abs(p);if(0>p||b*S>x*E){var M=Math.sqrt(b);w=M/2,m=0===M?0:(r*g-a)/M}else{var O=Math.sqrt(x);w=0===O?0:(r*g-a)/O,m=O/2}var P,_;0===q&&0===w?(P=0,_=0):t.sign(q)===t.sign(w)?(P=q+w,_=p/P):(_=q-w,P=p/_);var R,C;0===g&&0===m?(R=0,C=0):t.sign(g)===t.sign(m)?(R=g+m,C=o/R):(C=g-m,R=o/C);var z=n.computeRealRoots(1,P,R),T=n.computeRealRoots(1,_,C);if(0!==z.length)return 0!==T.length?z[1]<=T[0]?[z[0],z[1],T[0],T[1]]:T[1]<=z[0]?[T[0],T[1],z[0],z[1]]:z[0]>=T[0]&&z[1]<=T[1]?[T[0],z[0],z[1],T[1]]:T[0]>=z[0]&&T[1]<=z[1]?[z[0],T[0],T[1],z[1]]:z[0]>T[0]&&z[0]<T[1]?[T[0],z[0],T[1],z[1]]:[z[0],T[0],z[1],T[1]]:z;if(0!==T.length)return T}return[]}var o={};return o.computeDiscriminant=function(e,t,n,i,a){if("number"!=typeof e)throw new r("a is a required number.");if("number"!=typeof t)throw new r("b is a required number.");if("number"!=typeof n)throw new r("c is a required number.");if("number"!=typeof i)throw new r("d is a required number.");if("number"!=typeof a)throw new r("e is a required number.");var o=e*e,u=o*e,s=t*t,f=s*t,l=n*n,c=l*n,d=i*i,h=d*i,w=a*a,m=w*a,p=s*l*d-4*f*h-4*e*c*d+18*e*t*n*h-27*o*d*d+256*u*m+a*(18*f*n*i-4*s*c+16*e*l*l-80*e*t*l*i-6*e*s*d+144*o*n*d)+w*(144*e*s*n-27*s*s-128*o*l-192*o*t*i);return p},o.computeRealRoots=function(n,o,u,s,f){if("number"!=typeof n)throw new r("a is a required number.");if("number"!=typeof o)throw new r("b is a required number.");if("number"!=typeof u)throw new r("c is a required number.");if("number"!=typeof s)throw new r("d is a required number.");if("number"!=typeof f)throw new r("e is a required number.");if(Math.abs(n)<t.EPSILON15)return e.computeRealRoots(o,u,s,f);var l=o/n,c=u/n,d=s/n,h=f/n,w=0>l?1:0;switch(w+=0>c?w+1:w,w+=0>d?w+1:w,w+=0>h?w+1:w){case 0:return i(l,c,d,h);case 1:return a(l,c,d,h);case 2:return a(l,c,d,h);case 3:return i(l,c,d,h);case 4:return i(l,c,d,h);case 5:return a(l,c,d,h);case 6:return i(l,c,d,h);case 7:return i(l,c,d,h);case 8:return a(l,c,d,h);case 9:return i(l,c,d,h);case 10:return i(l,c,d,h);case 11:return a(l,c,d,h);case 12:return i(l,c,d,h);case 13:return i(l,c,d,h);case 14:return i(l,c,d,h);case 15:return i(l,c,d,h);default:return void 0}},o}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i=function(t,n){n=e.clone(r(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(r(t,e.ZERO)),this.direction=n};return i.getPoint=function(r,i,a){if(!t(r))throw new n("ray is requred");if("number"!=typeof i)throw new n("t is a required number");return t(a)||(a=new e),a=e.multiplyByScalar(r.direction,i,a),e.add(r.origin,a,a)},i}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,r,t,n,i,a,o,u,s,f){"use strict";function l(r,o,u,s,f){if(!n(r))throw new i("ray is required.");if(!n(o))throw new i("p0 is required.");if(!n(u))throw new i("p1 is required.");if(!n(s))throw new i("p2 is required.");f=t(f,!1);var l,c,d,h,w,m=r.origin,x=r.direction,S=e.subtract(u,o,p),b=e.subtract(s,o,y),E=e.cross(x,b,v),M=e.dot(S,E);if(f){if(M<a.EPSILON6)return void 0;if(l=e.subtract(m,o,q),d=e.dot(l,E),0>d||d>M)return void 0;if(c=e.cross(l,S,g),h=e.dot(x,c),0>h||d+h>M)return void 0;w=e.dot(b,c)/M}else{if(Math.abs(M)<a.EPSILON6)return void 0;var O=1/M;if(l=e.subtract(m,o,q),d=e.dot(l,E)*O,0>d||d>1)return void 0;if(c=e.cross(l,S,g),h=e.dot(x,c)*O,0>h||d+h>1)return void 0;w=e.dot(b,c)*O}return w}function c(e,r,t,n){var i=r*r-4*e*t;if(0>i)return void 0;if(i>0){var a=1/(2*e),o=Math.sqrt(i),u=(-r+o)*a,s=(-r-o)*a;return s>u?(n.root0=u,n.root1=s):(n.root0=s,n.root1=u),n}var f=-r/(2*e);return 0===f?void 0:(n.root0=n.root1=f,n)}function d(r,t,i){n(i)||(i={});var a=r.origin,o=r.direction,u=t.center,s=t.radius*t.radius,f=e.subtract(a,u,v),l=e.dot(o,o),d=2*e.dot(o,f),h=e.magnitudeSquared(f)-s,w=c(l,d,h,S);return n(w)?(i.start=w.root0,i.stop=w.root1,i):void 0}function h(e,r,t){var n=e+r;return a.sign(e)!==a.sign(r)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(r)))<t?0:n}function w(r,t,n,i,f){var l,c=i*i,d=f*f,w=(r[o.COLUMN1ROW1]-r[o.COLUMN2ROW2])*d,m=f*(i*h(r[o.COLUMN1ROW0],r[o.COLUMN0ROW1],a.EPSILON15)+t.y),p=r[o.COLUMN0ROW0]*c+r[o.COLUMN2ROW2]*d+i*t.x+n,y=d*h(r[o.COLUMN2ROW1],r[o.COLUMN1ROW2],a.EPSILON15),v=f*(i*h(r[o.COLUMN2ROW0],r[o.COLUMN0ROW2])+t.z),q=[];if(0===v&&0===y){if(l=u.computeRealRoots(w,m,p),0===l.length)return q;var g=l[0],x=Math.sqrt(Math.max(1-g*g,0));if(q.push(new e(i,f*g,f*-x)),q.push(new e(i,f*g,f*x)),2===l.length){var S=l[1],b=Math.sqrt(Math.max(1-S*S,0));q.push(new e(i,f*S,f*-b)),q.push(new e(i,f*S,f*b))}return q}var E=v*v,M=y*y,O=w*w,P=v*y,_=O+M,R=2*(m*w+P),C=2*p*w+m*m-M+E,z=2*(p*m-P),T=p*p-E;if(0===_&&0===R&&0===C&&0===z)return q;l=s.computeRealRoots(_,R,C,z,T);var I=l.length;if(0===I)return q;for(var N=0;I>N;++N){var A,D=l[N],U=D*D,L=Math.max(1-U,0),W=Math.sqrt(L);A=a.sign(w)===a.sign(p)?h(w*U+p,m*D,a.EPSILON12):a.sign(p)===a.sign(m*D)?h(w*U,m*D+p,a.EPSILON12):h(w*U+m*D,p,a.EPSILON12);var B=h(y*D,v,a.EPSILON15),F=A*B;0>F?q.push(new e(i,f*D,f*W)):F>0?q.push(new e(i,f*D,f*-W)):0!==W?(q.push(new e(i,f*D,f*-W)),q.push(new e(i,f*D,f*W)),++N):q.push(new e(i,f*D,f*W))}return q}var m={};m.rayPlane=function(r,t,o){if(!n(r))throw new i("ray is required.");if(!n(t))throw new i("plane is required.");n(o)||(o=new e);var u=r.origin,s=r.direction,f=t.normal,l=e.dot(f,s);if(Math.abs(l)<a.EPSILON15)return void 0;var c=(-t.distance-e.dot(f,u))/l;return 0>c?void 0:(o=e.multiplyByScalar(s,c,o),e.add(u,o,o))};var p=new e,y=new e,v=new e,q=new e,g=new e;m.rayTriangle=function(r,t,i,a,o,u){var s=l(r,t,i,a,o);return!n(s)||0>s?void 0:(n(u)||(u=new e),e.multiplyByScalar(r.direction,s,u),e.add(r.origin,u,u))};var x=new f;m.lineSegmentTriangle=function(r,t,a,o,u,s,f){if(!n(r))throw new i("v0 is required.");if(!n(t))throw new i("v1 is required.");var c=x;e.clone(r,c.origin),e.subtract(t,r,c.direction),e.normalize(c.direction,c.direction);var d=l(c,a,o,u,s);return!n(d)||0>d||d>e.distance(r,t)?void 0:(n(f)||(f=new e),e.multiplyByScalar(c.direction,d,f),e.add(c.origin,f,f))};var S={root0:0,root1:0};m.raySphere=function(e,r,t){if(!n(e))throw new i("ray is required.");if(!n(r))throw new i("sphere is required.");return t=d(e,r,t),!n(t)||t.stop<0?void 0:(t.start=Math.max(t.start,0),t)};var b=new f;m.lineSegmentSphere=function(r,t,a,o){if(!n(r))throw new i("p0 is required.");if(!n(t))throw new i("p1 is required.");if(!n(a))throw new i("sphere is required.");var u=b,s=(e.clone(r,u.origin),e.subtract(t,r,u.direction)),f=e.magnitude(s);return e.normalize(s,s),o=d(u,a,o),!n(o)||o.stop<0||o.start>f?void 0:(o.start=Math.max(o.start,0),o.stop=Math.min(o.stop,f),o)};var E=new e,M=new e;m.rayEllipsoid=function(r,t){if(!n(r))throw new i("ray is required.");if(!n(t))throw new i("ellipsoid is required.");var a,o,u,s,f,l=t.oneOverRadii,c=e.multiplyComponents(l,r.origin,E),d=e.multiplyComponents(l,r.direction,M),h=e.magnitudeSquared(c),w=e.dot(c,d);if(h>1){if(w>=0)return void 0;var m=w*w;if(a=h-1,o=e.magnitudeSquared(d),u=o*a,u>m)return void 0;if(m>u){s=w*w-u,f=-w+Math.sqrt(s);var p=f/o,y=a/f;return y>p?{start:p,stop:y}:{start:y,stop:p}}var v=Math.sqrt(a/o);return{start:v,stop:v}}return 1>h?(a=h-1,o=e.magnitudeSquared(d),u=o*a,s=w*w-u,f=-w+Math.sqrt(s),{start:0,stop:f/o}):0>w?(o=e.magnitudeSquared(d),{start:0,stop:-w/o}):void 0};var O=new e,P=new e,_=new e,R=new e,C=new e,z=new o,T=new o,I=new o,N=new o,A=new o,D=new o,U=new o,L=new e,W=new e,B=new r;m.grazingAltitudeLocation=function(r,t){if(!n(r))throw new i("ray is required.");if(!n(t))throw new i("ellipsoid is required.");var u=r.origin,s=r.direction,f=t.geodeticSurfaceNormal(u,O);if(e.dot(s,f)>=0)return u;var l=n(this.rayEllipsoid(r,t)),c=t.transformPositionToScaledSpace(s,O),d=e.normalize(c,c),h=e.mostOrthogonalAxis(c,R),m=e.normalize(e.cross(h,d,P),P),p=e.normalize(e.cross(d,m,_),_),y=z;y[0]=d.x,y[1]=d.y,y[2]=d.z,y[3]=m.x,y[4]=m.y,y[5]=m.z,y[6]=p.x,y[7]=p.y,y[8]=p.z;var v=o.transpose(y,T),q=o.fromScale(t.radii,I),g=o.fromScale(t.oneOverRadii,N),x=A;x[0]=0,x[1]=-s.z,x[2]=s.y,x[3]=s.z,x[4]=0,x[5]=-s.x,x[6]=-s.y,x[7]=s.x,x[8]=0;var S,b,E=o.multiply(o.multiply(v,g,D),x,D),M=o.multiply(o.multiply(E,q,U),y,U),F=o.multiplyByVector(E,u,C),V=w(M,e.negate(F,O),0,0,1),j=V.length;
if(j>0){for(var k=e.clone(e.ZERO,W),Z=Number.NEGATIVE_INFINITY,H=0;j>H;++H){S=o.multiplyByVector(q,o.multiplyByVector(y,V[H],L),L);var Y=e.normalize(e.subtract(S,u,R),R),X=e.dot(Y,s);X>Z&&(Z=X,k=e.clone(S,k))}var G=t.cartesianToCartographic(k,B);return Z=a.clamp(Z,0,1),b=e.magnitude(e.subtract(k,u,R))*Math.sqrt(1-Z*Z),b=l?-b:b,G.height=b,t.cartographicToCartesian(G,new e)}return void 0};var F=new e;return m.lineSegmentPlane=function(r,t,o,u){if(!n(r))throw new i("endPoint0 is required.");if(!n(t))throw new i("endPoint1 is required.");if(!n(o))throw new i("plane is required.");n(u)||(u=new e);var s=e.subtract(t,r,F),f=o.normal,l=e.dot(f,s);if(Math.abs(l)<a.EPSILON6)return void 0;var c=e.dot(f,r),d=-(o.distance+c)/l;return 0>d||d>1?void 0:(e.multiplyByScalar(s,d,u),e.add(r,u,u),u)},m.trianglePlaneIntersection=function(r,t,a,o){if(!(n(r)&&n(t)&&n(a)&&n(o)))throw new i("p0, p1, p2, and plane are required.");var u=o.normal,s=o.distance,f=e.dot(u,r)+s<0,l=e.dot(u,t)+s<0,c=e.dot(u,a)+s<0,d=0;d+=f?1:0,d+=l?1:0,d+=c?1:0;var h,w;if((1===d||2===d)&&(h=new e,w=new e),1===d){if(f)return m.lineSegmentPlane(r,t,o,h),m.lineSegmentPlane(r,a,o,w),{positions:[r,t,a,h,w],indices:[0,3,4,1,2,4,1,4,3]};if(l)return m.lineSegmentPlane(t,a,o,h),m.lineSegmentPlane(t,r,o,w),{positions:[r,t,a,h,w],indices:[1,3,4,2,0,4,2,4,3]};if(c)return m.lineSegmentPlane(a,r,o,h),m.lineSegmentPlane(a,t,o,w),{positions:[r,t,a,h,w],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===d){if(!f)return m.lineSegmentPlane(t,r,o,h),m.lineSegmentPlane(a,r,o,w),{positions:[r,t,a,h,w],indices:[1,2,4,1,4,3,0,3,4]};if(!l)return m.lineSegmentPlane(a,t,o,h),m.lineSegmentPlane(r,t,o,w),{positions:[r,t,a,h,w],indices:[2,0,4,2,4,3,1,3,4]};if(!c)return m.lineSegmentPlane(r,a,o,h),m.lineSegmentPlane(t,a,o,w),{positions:[r,t,a,h,w],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},m}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,t,n,i){return r(e).then(t,n,i)}function r(e){var r,t;return e instanceof n?r=e:u(e)?(t=o(),e.then(function(e){t.resolve(e)},function(e){t.reject(e)},function(e){t.progress(e)}),r=t.promise):r=i(e),r}function t(r){return e(r,a)}function n(e){this.then=e}function i(e){var t=new n(function(t){try{return r(t?t(e):e)}catch(n){return a(n)}});return t}function a(e){var t=new n(function(t,n){try{return n?r(n(e)):a(e)}catch(i){return a(i)}});return t}function o(){function e(e,r,t){return d(e,r,t)}function t(e){return w(e)}function i(e){return w(a(e))}function u(e){return h(e)}var s,f,l,c,d,h,w;return f=new n(e),s={then:e,resolve:t,reject:i,progress:u,promise:f,resolver:{resolve:t,reject:i,progress:u}},l=[],c=[],d=function(e,r,t){var n,i;return n=o(),i="function"==typeof t?function(e){try{n.progress(t(e))}catch(r){n.progress(r)}}:function(e){n.progress(e)},l.push(function(t){t.then(e,r).then(n.resolve,n.reject,i)}),c.push(i),n.promise},h=function(e){return m(c,e),e},w=function(e){return e=r(e),d=e.then,w=r,h=y,m(l,e),c=l=x,e},s}function u(e){return e&&"function"==typeof e.then}function s(r,t,n,i,a){return p(2,arguments),e(r,function(r){function u(e){m(e)}function s(e){w(e)}var f,l,c,d,h,w,m,p,v,q;if(v=r.length>>>0,f=Math.max(0,Math.min(t,v)),c=[],l=v-f+1,d=[],h=o(),f)for(p=h.progress,m=function(e){d.push(e),--l||(w=m=y,h.reject(d))},w=function(e){c.push(e),--f||(w=m=y,h.resolve(c))},q=0;v>q;++q)q in r&&e(r[q],s,u,p);else h.resolve(c);return h.then(n,i,a)})}function f(e,r,t,n){function i(e){return r?r(e[0]):e[0]}return s(e,1,i,t,n)}function l(e,r,t,n){return p(1,arguments),d(e,v).then(r,t,n)}function c(){return d(arguments,v)}function d(r,t){return e(r,function(r){var n,i,a,u,s,f;if(a=i=r.length>>>0,n=[],f=o(),a)for(u=function(r,i){e(r,t).then(function(e){n[i]=e,--a||f.resolve(n)},f.reject)},s=0;i>s;s++)s in r?u(r[s],s):--a;else f.resolve(n);return f.promise})}function h(r,t){var n=g.call(arguments,1);return e(r,function(r){var i;return i=r.length,n[0]=function(r,n,a){return e(r,function(r){return e(n,function(e){return t(r,e,a,i)})})},q.apply(r,n)})}function w(r,t,n){var i=arguments.length>2;return e(r,function(e){return e=i?n:e,t.resolve(e),e},function(e){return t.reject(e),a(e)},t.progress)}function m(e,r){for(var t,n=0;t=e[n++];)t(r)}function p(e,r){for(var t,n=r.length;n>e;)if(t=r[--n],null!=t&&"function"!=typeof t)throw new Error("arg "+n+" must be a function")}function y(){}function v(e){return e}var q,g,x;return e.defer=o,e.resolve=r,e.reject=t,e.join=c,e.all=l,e.map=d,e.reduce=h,e.any=f,e.some=s,e.chain=w,e.isPromise=u,n.prototype={always:function(e,r){return this.then(e,e,r)},otherwise:function(e){return this.then(x,e)},"yield":function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(r){return l(r,function(r){return e.apply(x,r)})})}},g=[].slice,q=[].reduce||function(e){var r,t,n,i,a;if(a=0,r=Object(this),i=r.length>>>0,t=arguments,t.length<=1)for(;;){if(a in r){n=r[a++];break}if(++a>=i)throw new TypeError}else n=t[1];for(;i>a;++a)a in r&&(n=e(n,r[a],a,r));return n},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./defined","./DeveloperError"],function(e,r){"use strict";var t=function(t,n,i){if(!e(t))throw new r("array is required.");if(!e(n))throw new r("itemToFind is required.");if(!e(i))throw new r("comparator is required.");for(var a,o,u=0,s=t.length-1;s>=u;)if(a=~~((u+s)/2),o=i(t[a],n),0>o)u=a+1;else{if(!(o>0))return a;s=a-1}return~(s+1)};return t}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";var e=function(e,r,t,n,i){this.xPoleWander=e,this.yPoleWander=r,this.xPoleOffset=t,this.yPoleOffset=n,this.ut1MinusUtc=i};return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,r=arguments,t=0,n=r[t++],i=function(e,r,t,n){t||(t=" ");var i=e.length>=r?"":Array(1+r-e.length>>>0).join(t);return n?e+i:i+e},a=function(e,r,t,n,a,o){var u=n-e.length;return u>0&&(e=t||!a?i(e,n,o,t):e.slice(0,r.length)+i("",u,"0",!0)+e.slice(r.length)),e},o=function(e,r,t,n,o,u,s){var f=e>>>0;return t=t&&f&&{2:"0b",8:"0",16:"0x"}[r]||"",e=t+i(f.toString(r),u||0,"0",!1),a(e,t,n,o,s)},u=function(e,r,t,n,i,o){return null!=n&&(e=e.slice(0,n)),a(e,"",r,t,i,o)},s=function(e,n,s,f,l,c,d){var h,w,m,p,y;if("%%"==e)return"%";for(var v=!1,q="",g=!1,x=!1,S=" ",b=s.length,E=0;s&&b>E;E++)switch(s.charAt(E)){case" ":q=" ";break;case"+":q="+";break;case"-":v=!0;break;case"'":S=s.charAt(E+1);break;case"0":g=!0;break;case"#":x=!0}if(f=f?"*"==f?+r[t++]:"*"==f.charAt(0)?+r[f.slice(1,-1)]:+f:0,0>f&&(f=-f,v=!0),!isFinite(f))throw new Error("sprintf: (minimum-)width must be finite");switch(c=c?"*"==c?+r[t++]:"*"==c.charAt(0)?+r[c.slice(1,-1)]:+c:"fFeE".indexOf(d)>-1?6:"d"==d?0:void 0,y=n?r[n.slice(0,-1)]:r[t++],d){case"s":return u(String(y),v,f,c,g,S);case"c":return u(String.fromCharCode(+y),v,f,c,g);case"b":return o(y,2,x,v,f,c,g);case"o":return o(y,8,x,v,f,c,g);case"x":return o(y,16,x,v,f,c,g);case"X":return o(y,16,x,v,f,c,g).toUpperCase();case"u":return o(y,10,x,v,f,c,g);case"i":case"d":return h=+y||0,h=Math.round(h-h%1),w=0>h?"-":q,y=w+i(String(Math.abs(h)),c,"0",!1),a(y,w,v,f,g);case"e":case"E":case"f":case"F":case"g":case"G":return h=+y,w=0>h?"-":q,m=["toExponential","toFixed","toPrecision"]["efg".indexOf(d.toLowerCase())],p=["toString","toUpperCase"]["eEfFgG".indexOf(d)%2],y=w+Math.abs(h)[m](c),a(y,w,v,f,g)[p]();default:return e}};return n.replace(e,s)}return e}),define("Core/GregorianDate",[],function(){"use strict";var e=function(e,r,t,n,i,a,o,u){this.year=e,this.month=r,this.day=t,this.hour=n,this.minute=i,this.second=a,this.millisecond=o,this.isLeapSecond=u};return e}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function r(r){if(null===r||isNaN(r))throw new e("year is required and must be a number.");return r%4===0&&r%100!==0||r%400===0}return r}),define("Core/LeapSecond",[],function(){"use strict";var e=function(e,r){this.julianDate=e,this.offset=r};return e}),define("Core/TimeConstants",["./freezeObject"],function(e){"use strict";var r={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e(r)}),define("Core/TimeStandard",["./freezeObject"],function(e){"use strict";var r={UTC:0,TAI:1};return e(r)}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,r,t,n,i,a,o,u,s,f){"use strict";function l(e,r){return R.compare(e.julianDate,r.julianDate)}function c(e){v.julianDate=e;var t=R.leapSeconds,n=r(t,v,l);0>n&&(n=~n),n>=t.length&&(n=t.length-1);var i=t[n].offset;if(n>0){var a=R.secondsDifference(t[n].julianDate,e);a>i&&(n--,i=t[n].offset)}R.addSeconds(e,i,e)}function d(e,t){v.julianDate=e;var n=R.leapSeconds,i=r(n,v,l);if(0>i&&(i=~i),0===i)return R.addSeconds(e,-n[0].offset,t);if(i>=n.length)return R.addSeconds(e,-n[i-1].offset,t);var a=R.secondsDifference(n[i].julianDate,e);return 0===a?R.addSeconds(e,-n[i].offset,t):1>=a?void 0:R.addSeconds(e,-n[--i].offset,t)}function h(e,r,t){var n=r/s.SECONDS_PER_DAY|0;return e+=n,r-=s.SECONDS_PER_DAY*n,0>r&&(e--,r+=s.SECONDS_PER_DAY),t.dayNumber=e,t.secondsOfDay=r,t}function w(e,r,t,n,i,a,o){var u=(r-14)/12|0,f=e+4800+u,l=(1461*f/4|0)+(367*(r-2-12*u)/12|0)-(3*((f+100)/100|0)/4|0)+t-32075;n-=12,0>n&&(n+=24);var c=a+(n*s.SECONDS_PER_HOUR+i*s.SECONDS_PER_MINUTE+o*s.SECONDS_PER_MILLISECOND);return c>=43200&&(l-=1),[l,c]}var m=new a,p=[31,28,31,30,31,30,31,31,30,31,30,31],y=29,v=new u,q=/^(\d{4})$/,g=/^(\d{4})-(\d{2})$/,x=/^(\d{4})-?(\d{3})$/,S=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,b=/^(\d{4})-?(\d{2})-?(\d{2})$/,E=/([Z+\-])?(\d{2})?:?(\d{2})?$/,M=/^(\d{2})(\.\d+)?/.source+E.source,O=/^(\d{2}):?(\d{2})(\.\d+)?/.source+E.source,P=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+E.source,_="Invalid ISO 8601 date.",R=function(e,r,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=t(e,0),r=t(r,0),n=t(n,f.UTC);var i=0|e;r+=(e-i)*s.SECONDS_PER_DAY,h(i,r,this),n===f.UTC&&c(this)};R.fromDate=function(e,r){if(!(e instanceof Date)||isNaN(e.getTime()))throw new i("date must be a valid JavaScript Date.");var t=w(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(r)?(h(t[0],t[1],r),c(r),r):new R(t[0],t[1],f.UTC)},R.fromIso8601=function(e,r){if("string"!=typeof e)throw new i(_);e=e.replace(",",".");var t,a,u,s=e.split("T"),l=1,d=1,m=0,v=0,E=0,C=0,z=s[0],T=s[1];if(!n(z))throw new i(_);var I;if(s=z.match(b),null!==s){if(I=z.split("-").length-1,I>0&&2!==I)throw new i(_);t=+s[1],l=+s[2],d=+s[3]}else if(s=z.match(g),null!==s)t=+s[1],l=+s[2];else if(s=z.match(q),null!==s)t=+s[1];else{var N;if(s=z.match(x),null!==s){if(t=+s[1],N=+s[2],u=o(t),1>N||u&&N>366||!u&&N>365)throw new i(_)}else{if(s=z.match(S),null===s)throw new i(_);t=+s[1];var A=+s[2],D=+s[3]||0;if(I=z.split("-").length-1,I>0&&(!n(s[3])&&1!==I||n(s[3])&&2!==I))throw new i(_);var U=new Date(Date.UTC(t,0,4));N=7*A+D-U.getUTCDay()-3}a=new Date(Date.UTC(t,0,1)),a.setUTCDate(N),l=a.getUTCMonth()+1,d=a.getUTCDate()}if(u=o(t),1>l||l>12||1>d||(2!==l||!u)&&d>p[l-1]||u&&2===l&&d>y)throw new i(_);var L;if(n(T)){if(s=T.match(P),null!==s){if(I=T.split(":").length-1,I>0&&2!==I&&3!==I)throw new i(_);m=+s[1],v=+s[2],E=+s[3],C=1e3*+(s[4]||0),L=5}else if(s=T.match(O),null!==s){if(I=T.split(":").length-1,I>0&&1!==I)throw new i(_);m=+s[1],v=+s[2],E=60*+(s[3]||0),L=4}else{if(s=T.match(M),null===s)throw new i(_);m=+s[1],v=60*+(s[2]||0),L=3}if(v>=60||E>=61||m>24||24===m&&(v>0||E>0||C>0))throw new i(_);var W=s[L],B=+s[L+1],F=+(s[L+2]||0);switch(W){case"+":m-=B,v-=F;break;case"-":m+=B,v+=F;break;case"Z":break;default:v+=new Date(Date.UTC(t,l-1,d,m,v)).getTimezoneOffset()}}else v+=new Date(t,l-1,d).getTimezoneOffset();var V=60===E;for(V&&E--;v>=60;)v-=60,m++;for(;m>=24;)m-=24,d++;for(a=u&&2===l?y:p[l-1];d>a;)d-=a,l++,l>12&&(l-=12,t++),a=u&&2===l?y:p[l-1];for(;0>v;)v+=60,m--;for(;0>m;)m+=24,d--;for(;1>d;)l--,1>l&&(l+=12,t--),a=u&&2===l?y:p[l-1],d+=a;var j=w(t,l,d,m,v,E,C);return n(r)?(h(j[0],j[1],r),c(r)):r=new R(j[0],j[1],f.UTC),V&&R.addSeconds(r,1,r),r},R.now=function(e){return R.fromDate(new Date,e)};var C=new R(0,0,f.TAI);return R.toGregorianDate=function(e,r){if(!n(e))throw new i("julianDate is required.");var t=!1,o=d(e,C);n(o)||(R.addSeconds(e,-1,C),o=d(C,C),t=!0);var u=o.dayNumber,f=o.secondsOfDay;f>=43200&&(u+=1);var l=u+68569|0,c=4*l/146097|0;l=l-((146097*c+3)/4|0)|0;var h=4e3*(l+1)/1461001|0;l=l-(1461*h/4|0)+31|0;var w=80*l/2447|0,m=l-(2447*w/80|0)|0;l=w/11|0;var p=w+2-12*l|0,y=100*(c-49)+h+l|0,v=f/s.SECONDS_PER_HOUR|0,q=f-v*s.SECONDS_PER_HOUR,g=q/s.SECONDS_PER_MINUTE|0;q-=g*s.SECONDS_PER_MINUTE;var x=0|q,S=(q-x)/s.SECONDS_PER_MILLISECOND;return v+=12,v>23&&(v-=24),t&&(x+=1),n(r)?(r.year=y,r.month=p,r.day=m,r.hour=v,r.minute=g,r.second=x,r.millisecond=S,r.isLeapSecond=t,r):new a(y,p,m,v,g,x,S,t)},R.toDate=function(e){if(!n(e))throw new i("julianDate is required.");var r=R.toGregorianDate(e,m),t=r.second;return r.isLeapSecond&&(t-=1),new Date(Date.UTC(r.year,r.month-1,r.day,r.hour,r.minute,t,r.millisecond))},R.toIso8601=function(r,t){if(!n(r))throw new i("julianDate is required.");var a,o=R.toGregorianDate(r,o);return n(t)||0===o.millisecond?n(t)&&0!==t?(a=(.01*o.millisecond).toFixed(t).replace(".","").slice(0,t),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o.year,o.month,o.day,o.hour,o.minute,o.second,a)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",o.year,o.month,o.day,o.hour,o.minute,o.second):(a=(.01*o.millisecond).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o.year,o.month,o.day,o.hour,o.minute,o.second,a))},R.clone=function(e,r){return n(e)?n(r)?(r.dayNumber=e.dayNumber,r.secondsOfDay=e.secondsOfDay,r):new R(e.dayNumber,e.secondsOfDay,f.TAI):void 0},R.compare=function(e,r){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");var t=e.dayNumber-r.dayNumber;return 0!==t?t:e.secondsOfDay-r.secondsOfDay},R.equals=function(e,r){return e===r||n(e)&&n(r)&&e.dayNumber===r.dayNumber&&e.secondsOfDay===r.secondsOfDay},R.equalsEpsilon=function(e,r,t){if(!n(t))throw new i("epsilon is required.");return e===r||n(e)&&n(r)&&Math.abs(R.secondsDifference(e,r))<=t},R.totalDays=function(e){if(!n(e))throw new i("julianDate is required.");return e.dayNumber+e.secondsOfDay/s.SECONDS_PER_DAY},R.secondsDifference=function(e,r){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");var t=(e.dayNumber-r.dayNumber)*s.SECONDS_PER_DAY;return t+(e.secondsOfDay-r.secondsOfDay)},R.daysDifference=function(e,r){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");var t=e.dayNumber-r.dayNumber,a=(e.secondsOfDay-r.secondsOfDay)/s.SECONDS_PER_DAY;return t+a},R.computeTaiMinusUtc=function(e){v.julianDate=e;var t=R.leapSeconds,n=r(t,v,l);return 0>n&&(n=~n,--n,0>n&&(n=0)),t[n].offset},R.addSeconds=function(e,r,t){if(!n(e))throw new i("julianDate is required.");if(!n(r))throw new i("seconds is required.");if(!n(t))throw new i("result is required.");return h(e.dayNumber,e.secondsOfDay+r,t)},R.addMinutes=function(e,r,t){if(!n(e))throw new i("julianDate is required.");if(!n(r))throw new i("minutes is required.");if(!n(t))throw new i("result is required.");var a=e.secondsOfDay+r*s.SECONDS_PER_MINUTE;return h(e.dayNumber,a,t)},R.addHours=function(e,r,t){if(!n(e))throw new i("julianDate is required.");if(!n(r))throw new i("hours is required.");if(!n(t))throw new i("result is required.");var a=e.secondsOfDay+r*s.SECONDS_PER_HOUR;return h(e.dayNumber,a,t)},R.addDays=function(e,r,t){if(!n(e))throw new i("julianDate is required.");if(!n(r))throw new i("days is required.");if(!n(t))throw new i("result is required.");var a=e.dayNumber+r;return h(a,e.secondsOfDay,t)},R.lessThan=function(e,r){return R.compare(e,r)<0},R.lessThanOrEquals=function(e,r){return R.compare(e,r)<=0},R.greaterThan=function(e,r){return R.compare(e,r)>0},R.greaterThanOrEquals=function(e,r){return R.compare(e,r)>=0},R.prototype.clone=function(e){return R.clone(this,e)},R.prototype.equals=function(e){return R.equals(this,e)},R.prototype.equalsEpsilon=function(e,r){return R.equalsEpsilon(this,e,r)},R.prototype.toString=function(){return R.toIso8601(this)},R.leapSeconds=[new u(new R(2441317,43210,f.TAI),10),new u(new R(2441499,43211,f.TAI),11),new u(new R(2441683,43212,f.TAI),12),new u(new R(2442048,43213,f.TAI),13),new u(new R(2442413,43214,f.TAI),14),new u(new R(2442778,43215,f.TAI),15),new u(new R(2443144,43216,f.TAI),16),new u(new R(2443509,43217,f.TAI),17),new u(new R(2443874,43218,f.TAI),18),new u(new R(2444239,43219,f.TAI),19),new u(new R(2444786,43220,f.TAI),20),new u(new R(2445151,43221,f.TAI),21),new u(new R(2445516,43222,f.TAI),22),new u(new R(2446247,43223,f.TAI),23),new u(new R(2447161,43224,f.TAI),24),new u(new R(2447892,43225,f.TAI),25),new u(new R(2448257,43226,f.TAI),26),new u(new R(2448804,43227,f.TAI),27),new u(new R(2449169,43228,f.TAI),28),new u(new R(2449534,43229,f.TAI),29),new u(new R(2450083,43230,f.TAI),30),new u(new R(2450630,43231,f.TAI),31),new u(new R(2451179,43232,f.TAI),32),new u(new R(2453736,43233,f.TAI),33),new u(new R(2454832,43234,f.TAI),34),new u(new R(2456109,43235,f.TAI),35),new u(new R(2457204,43236,f.TAI),36)],R}),define("Core/clone",["./defaultValue"],function(e){"use strict";var r=function(t,n){if(null===t||"object"!=typeof t)return t;n=e(n,!1);var i=new t.constructor;for(var a in t)if(t.hasOwnProperty(a)){var o=t[a];n&&(o=r(o,n)),i[a]=o}return i};return r}),define("Core/parseResponseHeaders",[],function(){"use strict";var e=function(e){var r={};if(!e)return r;for(var t=e.split("\r\n"),n=0;n<t.length;++n){var i=t[n],a=i.indexOf(": ");if(a>0){var o=i.substring(0,a),u=i.substring(a+2);r[o]=u}}return r};return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,r){"use strict";var t=function(e,t,n){this.statusCode=e,this.response=t,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=r(this.responseHeaders))};return t.prototype.toString=function(){var r="Request has failed.";return e(this.statusCode)&&(r+=" Status Code: "+this.statusCode),r},t}),define("Core/loadWithXhr",["../ThirdParty/when","./defaultValue","./defined","./DeveloperError","./RequestErrorEvent","./RuntimeError"],function(e,r,t,n,i,a){"use strict";function o(e,r){var t=decodeURIComponent(r);return e?atob(t):t}function u(e,r){for(var t=o(e,r),n=new ArrayBuffer(t.length),i=new Uint8Array(n),a=0;a<t.length;a++)i[a]=t.charCodeAt(a);return n}function s(e,t){t=r(t,"");var i=e[1],a=!!e[2],s=e[3];switch(t){case"":case"text":return o(a,s);case"arraybuffer":return u(a,s);case"blob":var f=u(a,s);return new Blob([f],{type:i});case"document":var l=new DOMParser;return l.parseFromString(o(a,s),i);case"json":return JSON.parse(o(a,s));default:throw new n("Unhandled responseType: "+t)}}var f=function(i){if(i=r(i,r.EMPTY_OBJECT),!t(i.url))throw new n("options.url is required.");var a=i.responseType,o=r(i.method,"GET"),u=i.data,s=i.headers,l=i.overrideMimeType;return e(i.url,function(r){var t=e.defer();return f.load(r,a,o,u,s,t,l),t.promise})},l=/^data:(.*?)(;base64)?,(.*)$/;return f.load=function(e,r,n,o,u,f,c){var d=l.exec(e);if(null!==d)return void f.resolve(s(d,r));var h=new XMLHttpRequest;if(t(c)&&t(h.overrideMimeType)&&h.overrideMimeType(c),h.open(n,e,!0),t(u))for(var w in u)u.hasOwnProperty(w)&&h.setRequestHeader(w,u[w]);t(r)&&(h.responseType=r),h.onload=function(){200===h.status?t(h.response)?f.resolve(h.response):t(h.responseXML)&&h.responseXML.hasChildNodes()?f.resolve(h.responseXML):t(h.responseText)?f.resolve(h.responseText):f.reject(new a("unknown XMLHttpRequest response type.")):f.reject(new i(h.status,h.response,h.getAllResponseHeaders()))},h.onerror=function(e){f.reject(new i)},h.send(o)},f.defaultLoad=f.load,f}),define("Core/loadText",["./loadWithXhr"],function(e){"use strict";var r=function(r,t){return e({url:r,headers:t})};return r}),define("Core/loadJson",["./clone","./defined","./DeveloperError","./loadText"],function(e,r,t,n){"use strict";var i={Accept:"application/json,*/*;q=0.01"},a=function(a,o){if(!r(a))throw new t("url is required.");return r(o)?r(o.Accept)||(o=e(o),o.Accept=i.Accept):o=i,n(a,o).then(function(e){return JSON.parse(e)})};return a}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./loadJson","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,r,t,n,i,a,o,u,s,f,l,c){"use strict";function d(e,r){return o.compare(e.julianDate,r)}function h(e,t){if(!n(t.columnNames))return void(e._dataError="Error in loaded EOP data: The columnNames property is required.");if(!n(t.samples))return void(e._dataError="Error in loaded EOP data: The samples property is required.");var i=t.columnNames.indexOf("modifiedJulianDateUtc"),a=t.columnNames.indexOf("xPoleWanderRadians"),s=t.columnNames.indexOf("yPoleWanderRadians"),f=t.columnNames.indexOf("ut1MinusUtcSeconds"),h=t.columnNames.indexOf("xCelestialPoleOffsetRadians"),w=t.columnNames.indexOf("yCelestialPoleOffsetRadians"),m=t.columnNames.indexOf("taiMinusUtcSeconds");if(0>i||0>a||0>s||0>f||0>h||0>w||0>m)return void(e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns");var p=e._samples=t.samples,y=e._dates=[];e._dateColumn=i,e._xPoleWanderRadiansColumn=a,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=f,e._xCelestialPoleOffsetRadiansColumn=h,e._yCelestialPoleOffsetRadiansColumn=w,e._taiMinusUtcSecondsColumn=m,e._columnCount=t.columnNames.length,e._lastIndex=void 0;for(var v,q=e._addNewLeapSeconds,g=0,x=p.length;x>g;g+=e._columnCount){var S=p[g+i],b=p[g+m],E=S+l.MODIFIED_JULIAN_DATE_DIFFERENCE,M=new o(E,b,c.TAI);if(y.push(M),q){if(b!==v&&n(v)){var O=o.leapSeconds,P=r(O,M,d);if(0>P){var _=new u(M,b);O.splice(~P,0,_)}}v=b}}}function w(e,r,t,n,i){var a=t*n;i.xPoleWander=r[a+e._xPoleWanderRadiansColumn],i.yPoleWander=r[a+e._yPoleWanderRadiansColumn],i.xPoleOffset=r[a+e._xCelestialPoleOffsetRadiansColumn],i.yPoleOffset=r[a+e._yCelestialPoleOffsetRadiansColumn],i.ut1MinusUtc=r[a+e._ut1MinusUtcSecondsColumn]}function m(e,r,t){return r+e*(t-r)}function p(e,r,t,n,i,a,u){var s=e._columnCount;if(a>r.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var f=r[i],l=r[a];if(f.equals(l)||n.equals(f))return w(e,t,i,s,u),u;if(n.equals(l))return w(e,t,a,s,u),u;var c=o.secondsDifference(n,f)/o.secondsDifference(l,f),d=i*s,h=a*s,p=t[d+e._ut1MinusUtcSecondsColumn],y=t[h+e._ut1MinusUtcSecondsColumn],v=y-p;if(v>.5||-.5>v){var q=t[d+e._taiMinusUtcSecondsColumn],g=t[h+e._taiMinusUtcSecondsColumn];q!==g&&(l.equals(n)?p=y:y-=g-q)}return u.xPoleWander=m(c,t[d+e._xPoleWanderRadiansColumn],t[h+e._xPoleWanderRadiansColumn]),u.yPoleWander=m(c,t[d+e._yPoleWanderRadiansColumn],t[h+e._yPoleWanderRadiansColumn]),u.xPoleOffset=m(c,t[d+e._xCelestialPoleOffsetRadiansColumn],t[h+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=m(c,t[d+e._yCelestialPoleOffsetRadiansColumn],t[h+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=m(c,p,y),u}var y=function(r){if(r=t(r,t.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=t(r.addNewLeapSeconds,!0),n(r.data))h(this,r.data);else if(n(r.url)){var i=this;this._downloadPromise=e(s(r.url),function(e){h(i,e)},function(){i._dataError="An error occurred while retrieving the EOP data from the URL "+r.url+"."})}else h(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})};return y.NONE=a({getPromiseToLoad:function(){return e()},compute:function(e,r){return n(r)?(r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0):r=new i(0,0,0,0,0),r}}),y.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},y.prototype.compute=function(e,t){if(!n(this._samples)){if(n(this._dataError))throw new f(this._dataError);return void 0}if(n(t)||(t=new i(0,0,0,0,0)),0===this._samples.length)return t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0,t;var a=this._dates,u=this._lastIndex,s=0,l=0;if(n(u)){var c=a[u],d=a[u+1],h=o.lessThanOrEquals(c,e),w=!n(d),m=w||o.greaterThanOrEquals(d,e);if(h&&m)return s=u,!w&&d.equals(e)&&++s,l=s+1,p(this,a,this._samples,e,s,l,t),t}var y=r(a,e,o.compare,this._dateColumn);return y>=0?(y<a.length-1&&a[y+1].equals(e)&&++y,s=y,l=y):(l=~y,s=l-1,0>s&&(s=0)),this._lastIndex=s,p(this,a,this._samples,e,s,l,t),t},y}),define("ThirdParty/Uri",[],function(){function e(r){if(r instanceof e)this.scheme=r.scheme,this.authority=r.authority,this.path=r.path,this.query=r.query,this.fragment=r.fragment;else if(r){var t=n.exec(r);this.scheme=t[1],this.authority=t[2],this.path=t[3],this.query=t[4],this.fragment=t[5]}}function r(e){var r=unescape(e);return a.test(r)?r:e.toUpperCase()}function t(e,r,t,n){return(r||"")+t.toLowerCase()+(n||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var n=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(o,t).replace(i,r)),this.path&&(this.path=this.path.replace(i,r)),this.query&&(this.query=this.query.replace(i,r)),this.fragment&&(this.fragment=this.fragment.replace(i,r))};var i=/%[0-9a-z]{2}/gi,a=/[a-zA-Z0-9\-\._~]/,o=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(r){var t=new e;return this.scheme?(t.scheme=this.scheme,t.authority=this.authority,t.path=this.path,t.query=this.query):(t.scheme=r.scheme,this.authority?(t.authority=this.authority,t.path=this.path,t.query=this.query):(t.authority=r.authority,""==this.path?(t.path=r.path,t.query=this.query||r.query):("/"==this.path.charAt(0)?(t.path=this.path,t.removeDotSegments()):(r.authority&&""==r.path?t.path="/"+this.path:t.path=r.path.substring(0,r.path.lastIndexOf("/")+1)+this.path,t.removeDotSegments()),t.query=this.query))),t.fragment=this.fragment,t},e.prototype.removeDotSegments=function(){var e,r=this.path.split("/"),t=[],n=""==r[0];n&&r.shift();for(""==r[0]?r.shift():null;r.length;)e=r.shift(),".."==e?t.pop():"."!=e&&t.push(e);("."==e||".."==e)&&t.push(""),n&&t.unshift(""),this.path=t.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/buildModuleUrl",["../ThirdParty/Uri","./defined","./DeveloperError","require"],function(e,r,t,n){"use strict";function i(){for(var e=document.getElementsByTagName("script"),r=0,t=e.length;t>r;++r){var n=e[r].getAttribute("src"),i=c.exec(n);if(null!==i)return i[1]}return void 0}function a(){if(r(s))return s;var n;if(n="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:i(),!r(n))throw new t("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return s=new e(n).resolve(new e(document.location.href))}function o(e){return n.toUrl("../"+e)}function u(r){return new e(r).resolve(a()).toString()}var s,f,l,c=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i,d=function(e){r(f)||(f=r(n.toUrl)?o:u),r(l)||(l=document.createElement("a"));var t=f(e);return l.href=t,l.href=l.href,l.href};return d._cesiumScriptRegex=c,d.setBaseUrl=function(r){s=new e(r).resolve(new e(document.location.href))},d}),define("Core/Iau2006XysSample",[],function(){"use strict";var e=function(e,r,t){this.x=e,this.y=r,this.s=t};return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./loadJson","./TimeStandard"],function(e,r,t,n,i,a,o,u){"use strict";function s(e,r,t){var n=c;return n.dayNumber=r,n.secondsOfDay=t,a.daysDifference(n,e._sampleZeroDateTT)}function f(t,i){if(t._chunkDownloadsInProgress[i])return t._chunkDownloadsInProgress[i];var a=e.defer();t._chunkDownloadsInProgress[i]=a;var u,s=t._xysFileUrlTemplate;return u=n(s)?s.replace("{0}",i):r("Assets/IAU2006_XYS/IAU2006_XYS_"+i+".json"),e(o(u),function(e){t._chunkDownloadsInProgress[i]=!1;for(var r=t._samples,n=e.samples,o=i*t._samplesPerXysFile*3,u=0,s=n.length;s>u;++u)r[o+u]=n[u];a.resolve()}),a.promise}var l=function(e){e=t(e,t.EMPTY_OBJECT),this._xysFileUrlTemplate=e.xysFileUrlTemplate,this._interpolationOrder=t(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=t(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new a(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=t(e.stepSizeDays,1),this._samplesPerXysFile=t(e.samplesPerXysFile,1e3),this._totalSamples=t(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var r=this._interpolationOrder,n=this._denominators=new Array(r+1),i=this._xTable=new Array(r+1),o=Math.pow(this._stepSizeDays,r),s=0;r>=s;++s){n[s]=o,i[s]=s*this._stepSizeDays;for(var f=0;r>=f;++f)f!==s&&(n[s]*=s-f);n[s]=1/n[s]}this._work=new Array(r+1),this._coef=new Array(r+1)},c=new a(0,0,u.TAI);return l.prototype.preload=function(r,t,n,i){var a=s(this,r,t),o=s(this,n,i),u=a/this._stepSizeDays-this._interpolationOrder/2|0;0>u&&(u=0);var l=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;l>=this._totalSamples&&(l=this._totalSamples-1);for(var c=u/this._samplesPerXysFile|0,d=l/this._samplesPerXysFile|0,h=[],w=c;d>=w;++w)h.push(f(this,w));return e.all(h)},l.prototype.computeXysRadians=function(e,r,t){var a=s(this,e,r);if(0>a)return void 0;var o=a/this._stepSizeDays|0;if(o>=this._totalSamples)return void 0;var u=this._interpolationOrder,l=o-(u/2|0);0>l&&(l=0);var c=l+u;c>=this._totalSamples&&(c=this._totalSamples-1,l=c-u,0>l&&(l=0));var d=!1,h=this._samples;if(n(h[3*l])||(f(this,l/this._samplesPerXysFile|0),d=!0),n(h[3*c])||(f(this,c/this._samplesPerXysFile|0),d=!0),d)return void 0;n(t)?(t.x=0,t.y=0,t.s=0):t=new i(0,0,0);var w,m,p=a-l*this._stepSizeDays,y=this._work,v=this._denominators,q=this._coef,g=this._xTable;for(w=0;u>=w;++w)y[w]=p-g[w];for(w=0;u>=w;++w){for(q[w]=1,m=0;u>=m;++m)m!==w&&(q[w]*=y[m]);q[w]*=v[w];var x=3*(l+w);t.x+=q[w]*h[x++],t.y+=q[w]*h[x++],t.s+=q[w]*h[x]}return t},l}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,r){"use strict";var t,n={requestFullscreen:void 0,exitFullscreen:void 0,
fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return r(i,{element:{get:function(){return i.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(t))return t;t=!1;var r=document.body;if("function"==typeof r.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",t=!0;for(var i,a=["webkit","moz","o","ms","khtml"],o=0,u=a.length;u>o;++o){var s=a[o];i=s+"RequestFullscreen","function"==typeof r[i]?(n.requestFullscreen=i,t=!0):(i=s+"RequestFullScreen","function"==typeof r[i]&&(n.requestFullscreen=i,t=!0)),i=s+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=s+"FullscreenEnabled",e(document[i])?n.fullscreenEnabled=i:(i=s+"FullScreenEnabled",e(document[i])&&(n.fullscreenEnabled=i)),i=s+"FullscreenElement",e(document[i])?n.fullscreenElement=i:(i=s+"FullScreenElement",e(document[i])&&(n.fullscreenElement=i)),i=s+"fullscreenchange",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=s+"fullscreenerror",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenError"),n.fullscreenerror=i)}return t},i.requestFullscreen=function(e){i.supportsFullscreen()&&e[n.requestFullscreen]()},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,r,t){"use strict";function n(e){for(var r=e.split("."),t=0,n=r.length;n>t;++t)r[t]=parseInt(r[t],10);return r}function i(){if(!r(p)){p=!1;var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(p=!0,y=n(e[1]))}return p}function a(){return i()&&y}function o(){if(!r(v)&&(v=!1,!i()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(v=!0,q=n(e[1]))}return v}function u(){return o()&&q}function s(){if(!r(g)){g=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==e&&(g=!0,x=n(e[1]),x.isNightly=!!e[2])}return g}function f(){return s()&&x}function l(){if(!r(S)){S=!1;var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(S=!0,b=n(e[1]))):"Netscape"===navigator.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(S=!0,b=n(e[1])))}return S}function c(){return l()&&b}function d(){if(!r(E)){E=!1;var e=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(E=!0,M=n(e[1]))}return E}function h(){return r(O)||(O=/Windows/i.test(navigator.appVersion)),O}function w(){return d()&&M}function m(){return r(P)||(P=r(window.PointerEvent)&&(!r(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),P}var p,y,v,q,g,x,S,b,E,M,O,P,_={isChrome:i,chromeVersion:a,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:f,isInternetExplorer:l,internetExplorerVersion:c,isFirefox:d,firefoxVersion:w,isWindows:h,hardwareConcurrency:e(navigator.hardwareConcurrency,3),supportsPointerEvents:m};return _.supportsFullscreen=function(){return t.supportsFullscreen()},_.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},_.supportsWebWorkers=function(){return"undefined"!=typeof Worker},_}),define("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,r,t,n,i,a,o,u){"use strict";var s=function(e,t,n,i){this.x=r(e,0),this.y=r(t,0),this.z=r(n,0),this.w=r(i,0)},f=new e;s.fromAxisAngle=function(r,i,a){if(!t(r))throw new n("axis is required.");if("number"!=typeof i)throw new n("angle is required and must be a number.");var o=i/2,u=Math.sin(o);f=e.normalize(r,f);var l=f.x*u,c=f.y*u,d=f.z*u,h=Math.cos(o);return t(a)?(a.x=l,a.y=c,a.z=d,a.w=h,a):new s(l,c,d,h)};var l=[1,2,0],c=new Array(3);s.fromRotationMatrix=function(e,r){if(!t(e))throw new n("matrix is required.");var i,a,o,f,d,h=e[u.COLUMN0ROW0],w=e[u.COLUMN1ROW1],m=e[u.COLUMN2ROW2],p=h+w+m;if(p>0)i=Math.sqrt(p+1),d=.5*i,i=.5/i,a=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*i,o=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*i,f=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*i;else{var y=l,v=0;w>h&&(v=1),m>h&&m>w&&(v=2);var q=y[v],g=y[q];i=Math.sqrt(e[u.getElementIndex(v,v)]-e[u.getElementIndex(q,q)]-e[u.getElementIndex(g,g)]+1);var x=c;x[v]=.5*i,i=.5/i,d=(e[u.getElementIndex(g,q)]-e[u.getElementIndex(q,g)])*i,x[q]=(e[u.getElementIndex(q,v)]+e[u.getElementIndex(v,q)])*i,x[g]=(e[u.getElementIndex(g,v)]+e[u.getElementIndex(v,g)])*i,a=-x[0],o=-x[1],f=-x[2]}return t(r)?(r.x=a,r.y=o,r.z=f,r.w=d,r):new s(a,o,f,d)};var d=new s;s.fromHeadingPitchRoll=function(r,i,a,o){if(!t(r))throw new n("heading is required.");if(!t(i))throw new n("pitch is required.");if(!t(a))throw new n("roll is required.");var u=s.fromAxisAngle(e.UNIT_X,a,d),f=s.fromAxisAngle(e.UNIT_Y,-i,o);o=s.multiply(f,u,f);var l=s.fromAxisAngle(e.UNIT_Z,-r,d);return s.multiply(l,o,o)};var h=new e,w=new e,m=new s,p=new s,y=new s;s.packedLength=4,s.pack=function(e,i,a){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");a=r(a,0),i[a++]=e.x,i[a++]=e.y,i[a++]=e.z,i[a]=e.w},s.unpack=function(e,i,a){if(!t(e))throw new n("array is required");return i=r(i,0),t(a)||(a=new s),a.x=e[i],a.y=e[i+1],a.z=e[i+2],a.w=e[i+3],a},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,r,t,n){s.unpack(e,4*t,y),s.conjugate(y,y);for(var i=0,a=t-r+1;a>i;i++){var o=3*i;s.unpack(e,4*(r+i),m),s.multiply(m,y,m),m.w<0&&s.negate(m,m),s.computeAxis(m,h);var u=s.computeAngle(m);n[o]=h.x*u,n[o+1]=h.y*u,n[o+2]=h.z*u}},s.unpackInterpolationResult=function(r,n,i,a,o){t(o)||(o=new s),e.fromArray(r,0,w);var u=e.magnitude(w);return s.unpack(n,4*a,p),0===u?s.clone(s.IDENTITY,m):s.fromAxisAngle(w,u,m),s.multiply(m,p,o)},s.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,r){if(!t(e))throw new n("quaternion is required");if(!t(r))throw new n("result is required");return r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=e.w,r},s.magnitudeSquared=function(e){if(!t(e))throw new n("quaternion is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,r){if(!t(r))throw new n("result is required");var i=1/s.magnitude(e),a=e.x*i,o=e.y*i,u=e.z*i,f=e.w*i;return r.x=a,r.y=o,r.z=u,r.w=f,r},s.inverse=function(e,r){if(!t(r))throw new n("result is required");var i=s.magnitudeSquared(e);return r=s.conjugate(e,r),s.multiplyByScalar(r,1/i,r)},s.add=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i.x=e.x+r.x,i.y=e.y+r.y,i.z=e.z+r.z,i.w=e.w+r.w,i},s.subtract=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i.x=e.x-r.x,i.y=e.y-r.y,i.z=e.z-r.z,i.w=e.w-r.w,i},s.negate=function(e,r){if(!t(e))throw new n("quaternion is required");if(!t(r))throw new n("result is required");return r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r},s.dot=function(e,r){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");return e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w},s.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");var a=e.x,o=e.y,u=e.z,s=e.w,f=r.x,l=r.y,c=r.z,d=r.w,h=s*f+a*d+o*c-u*l,w=s*l-a*c+o*d+u*f,m=s*c+a*l-o*f+u*d,p=s*d-a*f-o*l-u*c;return i.x=h,i.y=w,i.z=m,i.w=p,i},s.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("quaternion is required");if("number"!=typeof r)throw new n("scalar is required and must be a number.");if(!t(i))throw new n("result is required");return i.x=e.x*r,i.y=e.y*r,i.z=e.z*r,i.w=e.w*r,i},s.divideByScalar=function(e,r,i){if(!t(e))throw new n("quaternion is required");if("number"!=typeof r)throw new n("scalar is required and must be a number.");if(!t(i))throw new n("result is required");return i.x=e.x/r,i.y=e.y/r,i.z=e.z/r,i.w=e.w/r,i},s.computeAxis=function(e,r){if(!t(e))throw new n("quaternion is required");if(!t(r))throw new n("result is required");var i=e.w;if(Math.abs(i-1)<o.EPSILON6)return r.x=r.y=r.z=0,r;var a=1/Math.sqrt(1-i*i);return r.x=e.x*a,r.y=e.y*a,r.z=e.z*a,r},s.computeAngle=function(e){if(!t(e))throw new n("quaternion is required");return Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var v=new s;s.lerp=function(e,r,i,a){if(!t(e))throw new n("start is required.");if(!t(r))throw new n("end is required.");if("number"!=typeof i)throw new n("t is required and must be a number.");if(!t(a))throw new n("result is required");return v=s.multiplyByScalar(r,i,v),a=s.multiplyByScalar(e,1-i,a),s.add(v,a,a)};var q=new s,g=new s,x=new s;s.slerp=function(e,r,i,a){if(!t(e))throw new n("start is required.");if(!t(r))throw new n("end is required.");if("number"!=typeof i)throw new n("t is required and must be a number.");if(!t(a))throw new n("result is required");var u=s.dot(e,r),f=r;if(0>u&&(u=-u,f=q=s.negate(r,q)),1-u<o.EPSILON6)return s.lerp(e,f,i,a);var l=Math.acos(u);return g=s.multiplyByScalar(e,Math.sin((1-i)*l),g),x=s.multiplyByScalar(f,Math.sin(i*l),x),a=s.add(g,x,a),s.multiplyByScalar(a,1/Math.sin(l),a)},s.log=function(r,i){if(!t(r))throw new n("quaternion is required.");if(!t(i))throw new n("result is required");var a=o.acosClamped(r.w),u=0;return 0!==a&&(u=a/Math.sin(a)),e.multiplyByScalar(r,u,i)},s.exp=function(r,i){if(!t(r))throw new n("cartesian is required.");if(!t(i))throw new n("result is required");var a=e.magnitude(r),o=0;return 0!==a&&(o=Math.sin(a)/a),i.x=r.x*o,i.y=r.y*o,i.z=r.z*o,i.w=Math.cos(a),i};var S=new e,b=new e,E=new s,M=new s;s.computeInnerQuadrangle=function(r,i,a,o){if(!t(r)||!t(i)||!t(a))throw new n("q0, q1, and q2 are required.");if(!t(o))throw new n("result is required");var u=s.conjugate(i,E);s.multiply(u,a,M);var f=s.log(M,S);s.multiply(u,r,M);var l=s.log(M,b);return e.add(f,l,f),e.multiplyByScalar(f,.25,f),e.negate(f,f),s.exp(f,E),s.multiply(i,E,o)},s.squad=function(e,r,i,a,o,u){if(!(t(e)&&t(r)&&t(i)&&t(a)))throw new n("q0, q1, s0, and s1 are required.");if("number"!=typeof o)throw new n("t is required and must be a number.");if(!t(u))throw new n("result is required");var f=s.slerp(e,r,o,E),l=s.slerp(i,a,o,M);return s.slerp(f,l,2*o*(1-o),u)};for(var O=new s,P=1.9011074535173003,_=i.supportsTypedArrays()?new Float32Array(8):[],R=i.supportsTypedArrays()?new Float32Array(8):[],C=i.supportsTypedArrays()?new Float32Array(8):[],z=i.supportsTypedArrays()?new Float32Array(8):[],T=0;7>T;++T){var I=T+1,N=2*I+1;_[T]=1/(I*N),R[T]=I/N}return _[7]=P/136,R[7]=8*P/17,s.fastSlerp=function(e,r,i,a){if(!t(e))throw new n("start is required.");if(!t(r))throw new n("end is required.");if("number"!=typeof i)throw new n("t is required and must be a number.");if(!t(a))throw new n("result is required");var o,u=s.dot(e,r);u>=0?o=1:(o=-1,u=-u);for(var f=u-1,l=1-i,c=i*i,d=l*l,h=7;h>=0;--h)C[h]=(_[h]*c-R[h])*f,z[h]=(_[h]*d-R[h])*f;var w=o*i*(1+C[0]*(1+C[1]*(1+C[2]*(1+C[3]*(1+C[4]*(1+C[5]*(1+C[6]*(1+C[7])))))))),m=l*(1+z[0]*(1+z[1]*(1+z[2]*(1+z[3]*(1+z[4]*(1+z[5]*(1+z[6]*(1+z[7])))))))),p=s.multiplyByScalar(e,m,O);return s.multiplyByScalar(r,w,a),s.add(p,a,a)},s.fastSquad=function(e,r,i,a,o,u){if(!(t(e)&&t(r)&&t(i)&&t(a)))throw new n("q0, q1, s0, and s1 are required.");if("number"!=typeof o)throw new n("t is required and must be a number.");if(!t(u))throw new n("result is required");var f=s.fastSlerp(e,r,o,E),l=s.fastSlerp(i,a,o,M);return s.fastSlerp(f,l,2*o*(1-o),u)},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},s.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon is required and must be a number.");return e===r||t(e)&&t(r)&&Math.abs(e.x-r.x)<=i&&Math.abs(e.y-r.y)<=i&&Math.abs(e.z-r.z)<=i&&Math.abs(e.w-r.w)<=i},s.ZERO=a(new s(0,0,0,0)),s.IDENTITY=a(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,r){return s.equalsEpsilon(this,e,r)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],function(e,r,t,n,i,a,o,u,s,f,l,c,d,h,w,m,p,y){"use strict";var v={},q=new t,g=new t,x=new t;v.eastNorthUpToFixedFrame=function(e,r,n){if(!a(e))throw new o("origin is required.");if(h.equalsEpsilon(e.x,0,h.EPSILON14)&&h.equalsEpsilon(e.y,0,h.EPSILON14)){var u=h.sign(e.z);return a(n)?(n[0]=0,n[1]=1,n[2]=0,n[3]=0,n[4]=-u,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=u,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(0,-u,0,e.x,1,0,0,e.y,0,0,u,e.z,0,0,0,1)}var s=q,l=g,c=x;return r=i(r,f.WGS84),r.geodeticSurfaceNormal(e,s),l.x=-e.y,l.y=e.x,l.z=0,t.normalize(l,l),t.cross(s,l,c),a(n)?(n[0]=l.x,n[1]=l.y,n[2]=l.z,n[3]=0,n[4]=c.x,n[5]=c.y,n[6]=c.z,n[7]=0,n[8]=s.x,n[9]=s.y,n[10]=s.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(l.x,c.x,s.x,e.x,l.y,c.y,s.y,e.y,l.z,c.z,s.z,e.z,0,0,0,1)};var S=new t,b=new t,E=new t;v.northEastDownToFixedFrame=function(e,r,n){if(!a(e))throw new o("origin is required.");if(h.equalsEpsilon(e.x,0,h.EPSILON14)&&h.equalsEpsilon(e.y,0,h.EPSILON14)){var u=h.sign(e.z);return a(n)?(n[0]=-u,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=1,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=-u,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(-u,0,0,e.x,0,1,0,e.y,0,0,-u,e.z,0,0,0,1)}var s=S,l=b,c=E;return r=i(r,f.WGS84),r.geodeticSurfaceNormal(e,s),l.x=-e.y,l.y=e.x,l.z=0,t.normalize(l,l),t.cross(s,l,c),a(n)?(n[0]=c.x,n[1]=c.y,n[2]=c.z,n[3]=0,n[4]=l.x,n[5]=l.y,n[6]=l.z,n[7]=0,n[8]=-s.x,n[9]=-s.y,n[10]=-s.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(c.x,l.x,-s.x,e.x,c.y,l.y,-s.y,e.y,c.z,l.z,-s.z,e.z,0,0,0,1)},v.northUpEastToFixedFrame=function(e,r,n){if(!a(e))throw new o("origin is required.");if(h.equalsEpsilon(e.x,0,h.EPSILON14)&&h.equalsEpsilon(e.y,0,h.EPSILON14)){var u=h.sign(e.z);return a(n)?(n[0]=-u,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=u,n[7]=0,n[8]=0,n[9]=1,n[10]=0,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(-u,0,0,e.x,0,0,1,e.y,0,u,0,e.z,0,0,0,1)}var s=q,l=g,c=x;return r=i(r,f.WGS84),r.geodeticSurfaceNormal(e,s),l.x=-e.y,l.y=e.x,l.z=0,t.normalize(l,l),t.cross(s,l,c),a(n)?(n[0]=c.x,n[1]=c.y,n[2]=c.z,n[3]=0,n[4]=s.x,n[5]=s.y,n[6]=s.z,n[7]=0,n[8]=l.x,n[9]=l.y,n[10]=l.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(c.x,s.x,l.x,e.x,c.y,s.y,l.y,e.y,c.z,s.z,l.z,e.z,0,0,0,1)};var M=new p,O=new t(1,1,1),P=new m;v.headingPitchRollToFixedFrame=function(e,r,n,i,a,o){var u=p.fromHeadingPitchRoll(r,n,i,M),s=m.fromTranslationQuaternionRotationScale(t.ZERO,u,O,P);return o=v.eastNorthUpToFixedFrame(e,a,o),m.multiply(o,s,o)};var _=new m,R=new w;v.headingPitchRollQuaternion=function(e,r,t,n,i,a){var o=v.headingPitchRollToFixedFrame(e,r,t,n,i,_),u=m.getRotation(o,R);return p.fromRotationMatrix(u,a)};var C=24110.54841,z=8640184.812866,T=.093104,I=-62e-7,N=1.1772758384668e-19,A=72921158553e-15,D=h.TWO_PI/86400,U=new d;v.computeTemeToPseudoFixedMatrix=function(e,r){if(!a(e))throw new o("date is required.");U=d.addSeconds(e,-d.computeTaiMinusUtc(e),U);var t,n=U.dayNumber,i=U.secondsOfDay,u=n-2451545;t=i>=43200?(u+.5)/y.DAYS_PER_JULIAN_CENTURY:(u-.5)/y.DAYS_PER_JULIAN_CENTURY;var s=C+t*(z+t*(T+t*I)),f=s*D%h.TWO_PI,l=A+N*(n-2451545.5),c=(i+.5*y.SECONDS_PER_DAY)%y.SECONDS_PER_DAY,m=f+l*c,p=Math.cos(m),v=Math.sin(m);return a(r)?(r[0]=p,r[1]=-v,r[2]=0,r[3]=v,r[4]=p,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new w(p,v,0,-v,p,0,0,0,1)},v.iau2006XysData=new l,v.earthOrientationParameters=u.NONE;var L=32.184,W=2451545;v.preloadIcrfFixed=function(r){var t=r.start.dayNumber,n=r.start.secondsOfDay+L,i=r.stop.dayNumber,a=r.stop.secondsOfDay+L,o=v.iau2006XysData.preload(t,n,i,a),u=v.earthOrientationParameters.getPromiseToLoad();return e.all([o,u])},v.computeIcrfToFixedMatrix=function(e,r){if(!a(e))throw new o("date is required.");a(r)||(r=new w);var t=v.computeFixedToIcrfMatrix(e,r);return a(t)?w.transpose(t,r):void 0};var B=new c(0,0,0),F=new s(0,0,0,0,0,0),V=new w,j=new w;v.computeFixedToIcrfMatrix=function(e,r){if(!a(e))throw new o("date is required.");a(r)||(r=new w);var t=v.earthOrientationParameters.compute(e,F);if(!a(t))return void 0;var n=e.dayNumber,i=e.secondsOfDay+L,u=v.iau2006XysData.computeXysRadians(n,i,B);if(!a(u))return void 0;var s=u.x+t.xPoleOffset,f=u.y+t.yPoleOffset,l=1/(1+Math.sqrt(1-s*s-f*f)),c=V;c[0]=1-l*s*s,c[3]=-l*s*f,c[6]=s,c[1]=-l*s*f,c[4]=1-l*f*f,c[7]=f,c[2]=-s,c[5]=-f,c[8]=1-l*(s*s+f*f);var m=w.fromRotationZ(-u.s,j),p=w.multiply(c,m,V),q=e.dayNumber,g=e.secondsOfDay-d.computeTaiMinusUtc(e)+t.ut1MinusUtc,x=q-2451545,S=g/y.SECONDS_PER_DAY,b=.779057273264+S+.00273781191135448*(x+S);b=b%1*h.TWO_PI;var E=w.fromRotationZ(b,j),M=w.multiply(p,E,V),O=Math.cos(t.xPoleWander),P=Math.cos(t.yPoleWander),_=Math.sin(t.xPoleWander),R=Math.sin(t.yPoleWander),C=n-W+i/y.SECONDS_PER_DAY;C/=36525;var z=-47e-6*C*h.RADIANS_PER_DEGREE/3600,T=Math.cos(z),I=Math.sin(z),N=j;return N[0]=O*T,N[1]=O*I,N[2]=_,N[3]=-P*I+R*_*T,N[4]=P*T+R*_*I,N[5]=-R*O,N[6]=-R*I-P*_*T,N[7]=R*T-P*_*I,N[8]=P*O,w.multiply(M,N,r)};var k=new n;v.pointToWindowCoordinates=function(e,r,t,n){return n=v.pointToGLWindowCoordinates(e,r,t,n),n.y=2*r[5]-n.y,n},v.pointToGLWindowCoordinates=function(e,t,i,u){if(!a(e))throw new o("modelViewProjectionMatrix is required.");if(!a(t))throw new o("viewportTransformation is required.");if(!a(i))throw new o("point is required.");a(u)||(u=new r);var s=k;return m.multiplyByVector(e,n.fromElements(i.x,i.y,i.z,1,s),s),n.multiplyByScalar(s,1/s.w,s),m.multiplyByVector(t,s,s),r.fromCartesian4(s,u)};var Z=new t,H=new t,Y=new t;return v.rotationMatrixFromPositionVelocity=function(e,r,n,u){if(!a(e))throw new o("position is required.");if(!a(r))throw new o("velocity is required.");var s=i(n,f.WGS84).geodeticSurfaceNormal(e,Z),l=t.cross(r,s,H);t.equalsEpsilon(l,t.ZERO,h.EPSILON6)&&(l=t.clone(t.UNIT_X,l));var c=t.cross(l,r,Y);return t.cross(r,c,l),t.negate(l,l),a(u)||(u=new w),u[0]=r.x,u[1]=r.y,u[2]=r.z,u[3]=l.x,u[4]=l.y,u[5]=l.z,u[6]=c.x,u[7]=c.y,u[8]=c.z,u},v}),define("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix3","./Matrix4","./Plane","./Ray","./Transforms"],function(e,r,t,n,i,a,o,u,s,f,l,c,d,h,w){"use strict";var m=new n,p=function(e,r){if(!a(e))throw new u("origin is required.");if(r=i(r,s.WGS84),e=r.scaleToGeodeticSurface(e),!a(e))throw new u("origin must not be at the center of the ellipsoid.");var n=w.eastNorthUpToFixedFrame(e,r);this._ellipsoid=r,this._origin=e,this._xAxis=t.fromCartesian4(c.getColumn(n,0,m)),this._yAxis=t.fromCartesian4(c.getColumn(n,1,m));var o=t.fromCartesian4(c.getColumn(n,2,m));this._plane=d.fromPointNormal(e,o)};o(p.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}},plane:{get:function(){return this._plane}},xAxis:{get:function(){return this._xAxis}},yAxis:{get:function(){return this._yAxis}},zAxis:{get:function(){return this._plane.normal}}});var y=new e;p.fromPoints=function(r,t){if(!a(r))throw new u("cartesians is required.");var n=e.fromPoints(r,y);return new p(n.center,t)};var v=new h,q=new t;p.prototype.projectPointOntoPlane=function(e,n){if(!a(e))throw new u("cartesian is required.");var i=v;i.origin=e,t.normalize(e,i.direction);var o=f.rayPlane(i,this._plane,q);if(a(o)||(t.negate(i.direction,i.direction),o=f.rayPlane(i,this._plane,q)),a(o)){var s=t.subtract(o,this._origin,o),l=t.dot(this._xAxis,s),c=t.dot(this._yAxis,s);return a(n)?(n.x=l,n.y=c,n):new r(l,c)}return void 0},p.prototype.projectPointsOntoPlane=function(e,r){if(!a(e))throw new u("cartesians is required.");a(r)||(r=[]);for(var t=0,n=e.length,i=0;n>i;i++){var o=this.projectPointOntoPlane(e[i],r[t]);a(o)&&(r[t]=o,t++)}return r.length=t,r},p.prototype.projectPointToNearestOnPlane=function(e,n){if(!a(e))throw new u("cartesian is required.");a(n)||(n=new r);var i=v;i.origin=e,t.clone(this._plane.normal,i.direction);var o=f.rayPlane(i,this._plane,q);a(o)||(t.negate(i.direction,i.direction),o=f.rayPlane(i,this._plane,q));var s=t.subtract(o,this._origin,o),l=t.dot(this._xAxis,s),c=t.dot(this._yAxis,s);return n.x=l,n.y=c,n},p.prototype.projectPointsToNearestOnPlane=function(e,r){if(!a(e))throw new u("cartesians is required.");a(r)||(r=[]);var t=e.length;r.length=t;for(var n=0;t>n;n++)r[n]=this.projectPointToNearestOnPlane(e[n],r[n]);return r};var g=new t;return p.prototype.projectPointsOntoEllipsoid=function(e,r){if(!a(e))throw new u("cartesians is required.");var n=e.length;a(r)?r.length=n:r=new Array(n);for(var i=this._ellipsoid,o=this._origin,s=this._xAxis,f=this._yAxis,l=g,c=0;n>c;++c){var d=e[c];t.multiplyByScalar(s,d.x,l),a(r[c])||(r[c]=new t);var h=t.add(o,l,r[c]);t.multiplyByScalar(f,d.y,l),t.add(h,l,h),i.scaleToGeocentricSurface(h,h)}return r},p}),define("Core/OrientedBoundingBox",["./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Intersect","./Interval","./Math","./Matrix3","./Plane","./Rectangle"],function(e,r,t,n,i,a,o,u,s,f,l,c,d,h,w){"use strict";var m=function(e,r){this.center=t.clone(i(e,t.ZERO)),this.halfAxes=d.clone(i(r,d.ZERO))},p=new t,y=new t,v=new t,q=new t,g=new t,x=new d,S={unitary:new d,diagonal:new d};m.fromPoints=function(e,r){if(a(r)||(r=new m),!a(e)||0===e.length)return r.halfAxes=d.ZERO,r.center=t.ZERO,r;var n,i=e.length,o=t.clone(e[0],p);for(n=1;i>n;n++)t.add(o,e[n],o);var u=1/i;t.multiplyByScalar(o,u,o);var s,f=0,l=0,c=0,h=0,w=0,b=0;for(n=0;i>n;n++)s=t.subtract(e[n],o,y),f+=s.x*s.x,l+=s.x*s.y,c+=s.x*s.z,h+=s.y*s.y,w+=s.y*s.z,b+=s.z*s.z;f*=u,l*=u,c*=u,h*=u,w*=u,b*=u;var E=x;E[0]=f,E[1]=l,E[2]=c,E[3]=l,E[4]=h,E[5]=w,E[6]=c,E[7]=w,E[8]=b;var M=d.computeEigenDecomposition(E,S),O=d.transpose(M.unitary,r.halfAxes);s=t.subtract(e[0],o,y);var P=d.multiplyByVector(O,s,v),_=t.clone(P,q),R=t.clone(P,g);for(n=1;i>n;n++)s=t.subtract(e[n],o,s),d.multiplyByVector(O,s,P),t.minimumByComponent(R,P,R),t.maximumByComponent(_,P,_);var C=t.add(R,_,v);t.multiplyByScalar(C,.5,C),d.multiplyByVector(O,C,C),t.add(o,C,r.center);var z=t.subtract(_,R,v);return t.multiplyByScalar(z,.5,z),d.multiplyByScale(r.halfAxes,z,r.halfAxes),r};var b=new t,E=new t,M=function(e,r,n,i,u,s,f,l){if(!(a(r)&&a(n)&&a(i)&&a(u)&&a(s)&&a(f)))throw new o("all extents (minimum/maximum X/Y/Z) are required.");a(l)||(l=new m);var c=l.halfAxes;d.setColumn(c,0,e.xAxis,c),d.setColumn(c,1,e.yAxis,c),d.setColumn(c,2,e.zAxis,c);var h=b;h.x=(r+n)/2,h.y=(i+u)/2,h.z=(s+f)/2;var w=E;w.x=(n-r)/2,w.y=(u-i)/2,w.z=(f-s)/2;var p=l.center;return h=d.multiplyByVector(c,h,h),t.add(e.origin,h,p),d.multiplyByScale(c,w,c),l},O=new n,P=new t,_=[new n,new n,new n,new n,new n,new n,new n,new n],R=[new t,new t,new t,new t,new t,new t,new t,new t],C=[new r,new r,new r,new r,new r,new r,new r,new r];m.fromRectangle=function(e,r,t,n,f){if(!a(e))throw new o("rectangle is required");if(e.width<0||e.width>c.PI)throw new o("Rectangle width must be between 0 and pi");if(e.height<0||e.height>c.PI)throw new o("Rectangle height must be between 0 and pi");if(a(n)&&!c.equalsEpsilon(n.radii.x,n.radii.y,c.EPSILON15))throw new o("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");r=i(r,0),t=i(t,0),n=i(n,u.WGS84);var l=w.center(e,O),d=n.cartographicToCartesian(l,P),m=new s(d,n),p=m.plane,y=_[0],v=_[1],q=_[2],g=_[3],x=_[4],S=_[5],b=_[6],E=_[7],z=l.longitude,T=e.south<0&&e.north>0?0:l.latitude;b.latitude=S.latitude=x.latitude=e.south,E.latitude=g.latitude=T,y.latitude=v.latitude=q.latitude=e.north,b.longitude=E.longitude=y.longitude=e.west,S.longitude=v.longitude=z,x.longitude=g.longitude=q.longitude=e.east,q.height=v.height=y.height=E.height=b.height=S.height=x.height=g.height=t,n.cartographicArrayToCartesianArray(_,R),m.projectPointsToNearestOnPlane(R,C);var I=Math.min(C[6].x,C[7].x,C[0].x),N=Math.max(C[2].x,C[3].x,C[4].x),A=Math.min(C[4].y,C[5].y,C[6].y),D=Math.max(C[0].y,C[1].y,C[2].y);q.height=y.height=x.height=b.height=r,n.cartographicArrayToCartesianArray(_,R);var U=Math.min(h.getPointDistance(p,R[0]),h.getPointDistance(p,R[2]),h.getPointDistance(p,R[4]),h.getPointDistance(p,R[6])),L=t;return M(m,I,N,A,D,U,L,f)},m.clone=function(e,r){return a(e)?a(r)?(t.clone(e.center,r.center),d.clone(e.halfAxes,r.halfAxes),r):new m(e.center,e.halfAxes):void 0},m.intersectPlane=function(e,r){if(!a(e))throw new o("box is required.");if(!a(r))throw new o("plane is required.");var n=e.center,i=r.normal,u=e.halfAxes,s=i.x,l=i.y,c=i.z,h=Math.abs(s*u[d.COLUMN0ROW0]+l*u[d.COLUMN0ROW1]+c*u[d.COLUMN0ROW2])+Math.abs(s*u[d.COLUMN1ROW0]+l*u[d.COLUMN1ROW1]+c*u[d.COLUMN1ROW2])+Math.abs(s*u[d.COLUMN2ROW0]+l*u[d.COLUMN2ROW1]+c*u[d.COLUMN2ROW2]),w=t.dot(i,n)+r.distance;return-h>=w?f.OUTSIDE:w>=h?f.INSIDE:f.INTERSECTING};var z=new t,T=new t,I=new t,N=new t;m.distanceSquaredTo=function(e,r){if(!a(e))throw new o("box is required.");if(!a(r))throw new o("cartesian is required.");var n=t.subtract(r,e.center,b),i=e.halfAxes,u=d.getColumn(i,0,z),s=d.getColumn(i,1,T),f=d.getColumn(i,2,I),l=t.magnitude(u),c=t.magnitude(s),h=t.magnitude(f);t.normalize(u,u),t.normalize(s,s),t.normalize(f,f);var w=N;w.x=t.dot(n,u),w.y=t.dot(n,s),w.z=t.dot(n,f);var m,p=0;return w.x<-l?(m=w.x+l,p+=m*m):w.x>l&&(m=w.x-l,p+=m*m),w.y<-c?(m=w.y+c,p+=m*m):w.y>c&&(m=w.y-c,p+=m*m),w.z<-h?(m=w.z+h,p+=m*m):w.z>h&&(m=w.z-h,p+=m*m),p};var A=new t,D=new t;new t;m.computePlaneDistances=function(e,r,n,i){if(!a(e))throw new o("box is required.");if(!a(r))throw new o("position is required.");if(!a(n))throw new o("direction is required.");a(i)||(i=new l);var u=Number.POSITIVE_INFINITY,s=Number.NEGATIVE_INFINITY,f=e.center,c=e.halfAxes,h=d.getColumn(c,0,z),w=d.getColumn(c,1,T),m=d.getColumn(c,2,I),p=t.add(h,w,A);t.add(p,m,p),t.add(p,f,p);var y=t.subtract(p,r,D),v=t.dot(n,y);return u=Math.min(v,u),s=Math.max(v,s),t.add(f,h,p),t.add(p,w,p),t.subtract(p,m,p),t.subtract(p,r,y),v=t.dot(n,y),u=Math.min(v,u),s=Math.max(v,s),t.add(f,h,p),t.subtract(p,w,p),t.add(p,m,p),t.subtract(p,r,y),v=t.dot(n,y),u=Math.min(v,u),s=Math.max(v,s),t.add(f,h,p),t.subtract(p,w,p),t.subtract(p,m,p),t.subtract(p,r,y),v=t.dot(n,y),u=Math.min(v,u),s=Math.max(v,s),t.subtract(f,h,p),t.add(p,w,p),t.add(p,m,p),t.subtract(p,r,y),v=t.dot(n,y),u=Math.min(v,u),s=Math.max(v,s),t.subtract(f,h,p),t.add(p,w,p),t.subtract(p,m,p),t.subtract(p,r,y),v=t.dot(n,y),u=Math.min(v,u),s=Math.max(v,s),t.subtract(f,h,p),t.subtract(p,w,p),t.add(p,m,p),t.subtract(p,r,y),v=t.dot(n,y),u=Math.min(v,u),s=Math.max(v,s),t.subtract(f,h,p),t.subtract(p,w,p),t.subtract(p,m,p),t.subtract(p,r,y),v=t.dot(n,y),u=Math.min(v,u),s=Math.max(v,s),i.start=u,i.stop=s,i};var U=new e;return m.isOccluded=function(e,r){if(!a(e))throw new o("box is required.");if(!a(r))throw new o("occluder is required.");var n=e.halfAxes,i=d.getColumn(n,0,z),u=d.getColumn(n,1,T),s=d.getColumn(n,2,I),f=t.magnitude(i),l=t.magnitude(u),c=t.magnitude(s),h=U;return h.center=t.clone(e.center,h.center),h.radius=Math.max(f,l,c),!r.isBoundingSphereVisible(h)},m.prototype.intersectPlane=function(e){return m.intersectPlane(this,e)},m.prototype.distanceSquaredTo=function(e){return m.distanceSquaredTo(this,e)},m.prototype.computePlaneDistances=function(e,r,t){return m.computePlaneDistances(this,e,r,t)},m.prototype.isOccluded=function(e){return m.isOccluded(this,e)},m.equals=function(e,r){return e===r||a(e)&&a(r)&&t.equals(e.center,r.center)&&d.equals(e.halfAxes,r.halfAxes)},m.prototype.clone=function(e){return m.clone(this,e)},m.prototype.equals=function(e){return m.equals(this,e)},m}),define("Core/formatError",["./defined"],function(e){"use strict";var r=function(r){var t,n=r.name,i=r.message;t=e(n)&&e(i)?n+": "+i:r.toString();var a=r.stack;return e(a)&&(t+="\n"+a),t};return r}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined","../Core/formatError"],function(e,r,t){"use strict";var n=function(n){var i,a=[],o={id:void 0,result:void 0,error:void 0};return function(u){var s=u.data;a.length=0,o.id=s.id,o.error=void 0,o.result=void 0;try{o.result=n(s.parameters,a)}catch(f){f instanceof Error?o.error={name:f.name,message:f.message,stack:f.stack}:o.error=f}r(i)||(i=e(self.webkitPostMessage,self.postMessage)),s.canTransferArrayBuffer||(a.length=0);try{i(o,a)}catch(f){o.result=void 0,o.error="postMessage failed with error: "+t(f)+"\n  with responseMessage: "+JSON.stringify(o),i(o)}}};return n}),define("Workers/createVerticesFromHeightmap",["../Core/BoundingSphere","../Core/Ellipsoid","../Core/EllipsoidalOccluder","../Core/HeightmapTessellator","../Core/Math","../Core/OrientedBoundingBox","../Core/Rectangle","./createTaskProcessorWorker"],function(e,r,t,n,i,a,o,u){"use strict";function s(u,s){var f=6,l=u.width,c=u.height;u.skirtHeight>0&&(l+=2,c+=2);var d=new Float32Array(l*c*f);s.push(d.buffer),u.ellipsoid=r.clone(u.ellipsoid),u.rectangle=o.clone(u.rectangle),u.vertices=d;var h,w=n.computeVertices(u),m=e.fromVertices(d,u.relativeToCenter,f);u.rectangle.width<i.PI_OVER_TWO+i.EPSILON5&&(h=a.fromRectangle(u.rectangle,w.minimumHeight,w.maximumHeight,u.ellipsoid));var p=u.ellipsoid,y=new t(p),v=y.computeHorizonCullingPointFromVertices(u.relativeToCenter,d,f,u.relativeToCenter);return{vertices:d.buffer,numberOfAttributes:f,minimumHeight:w.minimumHeight,maximumHeight:w.maximumHeight,gridWidth:l,gridHeight:c,boundingSphere3D:m,orientedBoundingBox:h,occludeePointInScaledSpace:v}}return u(s)})}();