/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var r=Object.freeze;return e(r)||(r=function(e){return e}),r}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var r=function(e,r){return void 0!==e?e:r};return r.EMPTY_OBJECT=e({}),r}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var r=function(e){this.name="DeveloperError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r.throwInstantiationError=function(){throw new r("This function defines an interface and should not be called directly.")},r}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var t;for(this.mti==this.N+1&&this.init_genrand(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^r[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^r[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^r[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,r,t,i){"use strict";var n={};n.EPSILON1=.1,n.EPSILON2=.01,n.EPSILON3=.001,n.EPSILON4=1e-4,n.EPSILON5=1e-5,n.EPSILON6=1e-6,n.EPSILON7=1e-7,n.EPSILON8=1e-8,n.EPSILON9=1e-9,n.EPSILON10=1e-10,n.EPSILON11=1e-11,n.EPSILON12=1e-12,n.EPSILON13=1e-13,n.EPSILON14=1e-14,n.EPSILON15=1e-15,n.EPSILON16=1e-16,n.EPSILON17=1e-17,n.EPSILON18=1e-18,n.EPSILON19=1e-19,n.EPSILON20=1e-20,n.GRAVITATIONALPARAMETER=3986004418e5,n.SOLAR_RADIUS=6955e5,n.LUNAR_RADIUS=1737400,n.SIXTY_FOUR_KILOBYTES=65536,n.sign=function(e){return e>0?1:0>e?-1:0},n.signNotZero=function(e){return 0>e?-1:1},n.toSNorm=function(e){return Math.round(255*(.5*n.clamp(e,-1,1)+.5))},n.fromSNorm=function(e){return n.clamp(e,0,255)/255*2-1},n.sinh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r-t)},n.cosh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r+t)},n.lerp=function(e,r,t){return(1-t)*e+t*r},n.PI=Math.PI,n.ONE_OVER_PI=1/Math.PI,n.PI_OVER_TWO=.5*Math.PI,n.PI_OVER_THREE=Math.PI/3,n.PI_OVER_FOUR=Math.PI/4,n.PI_OVER_SIX=Math.PI/6,n.THREE_PI_OVER_TWO=3*Math.PI*.5,n.TWO_PI=2*Math.PI,n.ONE_OVER_TWO_PI=1/(2*Math.PI),n.RADIANS_PER_DEGREE=Math.PI/180,n.DEGREES_PER_RADIAN=180/Math.PI,n.RADIANS_PER_ARCSECOND=n.RADIANS_PER_DEGREE/3600,n.toRadians=function(e){if(!t(e))throw new i("degrees is required.");return e*n.RADIANS_PER_DEGREE},n.toDegrees=function(e){if(!t(e))throw new i("radians is required.");return e*n.DEGREES_PER_RADIAN},n.convertLongitudeRange=function(e){if(!t(e))throw new i("angle is required.");var r=n.TWO_PI,o=e-Math.floor(e/r)*r;return o<-Math.PI?o+r:o>=Math.PI?o-r:o},n.negativePiToPi=function(e){if(!t(e))throw new i("x is required.");return n.zeroToTwoPi(e+n.PI)-n.PI},n.zeroToTwoPi=function(e){if(!t(e))throw new i("x is required.");var r=n.mod(e,n.TWO_PI);return Math.abs(r)<n.EPSILON14&&Math.abs(e)>n.EPSILON14?n.TWO_PI:r},n.mod=function(e,r){if(!t(e))throw new i("m is required.");if(!t(r))throw new i("n is required.");return(e%r+r)%r},n.equalsEpsilon=function(e,n,o,a){if(!t(e))throw new i("left is required.");if(!t(n))throw new i("right is required.");if(!t(o))throw new i("relativeEpsilon is required.");a=r(a,o);var u=Math.abs(e-n);return a>=u||u<=o*Math.max(Math.abs(e),Math.abs(n))};var o=[1];n.factorial=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");var r=o.length;if(e>=r)for(var t=o[r-1],n=r;e>=n;n++)o.push(t*n);return o[e]},n.incrementWrap=function(e,n,o){if(o=r(o,0),!t(e))throw new i("n is required.");if(o>=n)throw new i("maximumValue must be greater than minimumValue.");return++e,e>n&&(e=o),e},n.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},n.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},n.clamp=function(e,r,n){if(!t(e))throw new i("value is required");if(!t(r))throw new i("min is required.");if(!t(n))throw new i("max is required.");return r>e?r:e>n?n:e};var a=new e;return n.setRandomNumberSeed=function(r){if(!t(r))throw new i("seed is required.");a=new e(r)},n.nextRandomNumber=function(){return a.random()},n.acosClamped=function(e){if(!t(e))throw new i("value is required.");return Math.acos(n.clamp(e,-1,1))},n.asinClamped=function(e){if(!t(e))throw new i("value is required.");return Math.asin(n.clamp(e,-1,1))},n.chordLength=function(e,r){if(!t(e))throw new i("angle is required.");if(!t(r))throw new i("radius is required.");return 2*r*Math.sin(.5*e)},n}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n){"use strict";var o=function(r,t,i){this.x=e(r,0),this.y=e(t,0),this.z=e(i,0)};o.fromSpherical=function(i,n){if(!r(i))throw new t("spherical is required");r(n)||(n=new o);var a=i.clock,u=i.cone,s=e(i.magnitude,1),E=s*Math.sin(u);return n.x=E*Math.cos(a),n.y=E*Math.sin(a),n.z=s*Math.cos(u),n},o.fromElements=function(e,t,i,n){return r(n)?(n.x=e,n.y=t,n.z=i,n):new o(e,t,i)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new o(e.x,e.y,e.z):void 0},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(i,n,o){if(!r(i))throw new t("value is required");if(!r(n))throw new t("array is required");o=e(o,0),n[o++]=i.x,n[o++]=i.y,n[o]=i.z},o.unpack=function(i,n,a){if(!r(i))throw new t("array is required");return n=e(n,0),r(a)||(a=new o),a.x=i[n++],a.y=i[n++],a.z=i[n],a},o.fromArray=o.unpack,o.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z)},o.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z)},o.minimumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.min(e.x,i.x),n.y=Math.min(e.y,i.y),n.z=Math.min(e.z,i.z),n},o.maximumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.max(e.x,i.x),n.y=Math.max(e.y,i.y),n.z=Math.max(e.z,i.z),n},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,i){if(!r(e)||!r(i))throw new t("left and right are required.");return o.subtract(e,i,a),o.magnitude(a)},o.distanceSquared=function(e,i){if(!r(e)||!r(i))throw new t("left and right are required.");return o.subtract(e,i,a),o.magnitudeSquared(a)},o.normalize=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");var n=o.magnitude(e);return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i},o.dot=function(e,i){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");return e.x*i.x+e.y*i.y+e.z*i.z},o.multiplyComponents=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x*i.x,n.y=e.y*i.y,n.z=e.z*i.z,n},o.add=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x+i.x,n.y=e.y+i.y,n.z=e.z+i.z,n},o.subtract=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x-i.x,n.y=e.y-i.y,n.z=e.z-i.z,n},o.multiplyByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x*i,n.y=e.y*i,n.z=e.z*i,n},o.divideByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n},o.negate=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=-e.x,i.y=-e.y,i.z=-e.z,i},o.abs=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=Math.abs(e.x),i.y=Math.abs(e.y),i.z=Math.abs(e.z),i};var u=new o;o.lerp=function(e,i,n,a){if(!r(e))throw new t("start is required.");if(!r(i))throw new t("end is required.");if("number"!=typeof n)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(i,n,u),a=o.multiplyByScalar(e,1-n,a),o.add(u,a,a)};var s=new o,E=new o;o.angleBetween=function(e,i){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");o.normalize(e,s),o.normalize(i,E);var n=o.dot(s,E),a=o.magnitude(o.cross(s,E,s));return Math.atan2(a,n)};var f=new o;o.mostOrthogonalAxis=function(e,i){if(!r(e))throw new t("cartesian is required.");if(!r(i))throw new t("result is required.");var n=o.normalize(e,f);return o.abs(n,n),i=n.x<=n.y?n.x<=n.z?o.clone(o.UNIT_X,i):o.clone(o.UNIT_Z,i):n.y<=n.z?o.clone(o.UNIT_Y,i):o.clone(o.UNIT_Z,i)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},o.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]&&e.z===r[t+2]},o.equalsEpsilon=function(e,t,i,o){return e===t||r(e)&&r(t)&&n.equalsEpsilon(e.x,t.x,i,o)&&n.equalsEpsilon(e.y,t.y,i,o)&&n.equalsEpsilon(e.z,t.z,i,o)},o.cross=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");var o=e.x,a=e.y,u=e.z,s=i.x,E=i.y,f=i.z,c=a*f-u*E,h=u*s-o*f,w=o*E-a*s;return n.x=c,n.y=h,n.z=w,n},o.fromDegrees=function(e,i,a,u,s){if(!r(e))throw new t("longitude is required");if(!r(i))throw new t("latitude is required");var E=n.toRadians(e),f=n.toRadians(i);return o.fromRadians(E,f,a,u,s)};var c=new o,h=new o,w=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(i,n,a,u,s){if(!r(i))throw new t("longitude is required");if(!r(n))throw new t("latitude is required");a=e(a,0);var E=r(u)?u.radiiSquared:w,f=Math.cos(n);c.x=f*Math.cos(i),c.y=f*Math.sin(i),c.z=Math.sin(n),c=o.normalize(c,c),o.multiplyComponents(E,c,h);var d=Math.sqrt(o.dot(c,h));return h=o.divideByScalar(h,d,h),c=o.multiplyByScalar(c,a,c),r(s)||(s=new o),o.add(h,c,s)},o.fromDegreesArray=function(e,i,a){if(!r(e))throw new t("positions is required.");for(var u=new Array(e.length),s=0;s<e.length;s++)u[s]=n.toRadians(e[s]);return o.fromRadiansArray(u,i,a)},o.fromRadiansArray=function(e,i,n){if(!r(e))throw new t("positions is required.");if(e.length<2)throw new t("positions length cannot be less than 2.");if(e.length%2!==0)throw new t("positions length must be a multiple of 2.");var a=e.length;r(n)?n.length=a/2:n=new Array(a/2);for(var u=0;a>u;u+=2){var s=e[u],E=e[u+1];n[u/2]=o.fromRadians(s,E,0,i,n[u/2])}return n},o.fromDegreesArrayHeights=function(e,i,a){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(e.length%3!==0)throw new t("positions length must be a multiple of 3.");for(var u=new Array(e.length),s=0;s<e.length;s+=3)u[s]=n.toRadians(e[s]),u[s+1]=n.toRadians(e[s+1]),u[s+2]=e[s+2];return o.fromRadiansArrayHeights(u,i,a)},o.fromRadiansArrayHeights=function(e,i,n){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(e.length%3!==0)throw new t("positions length must be a multiple of 3.");var a=e.length;r(n)?n.length=a/3:n=new Array(a/3);for(var u=0;a>u;u+=3){var s=e[u],E=e[u+1],f=e[u+2];n[u/3]=o.fromRadians(s,E,f,i,n[u/3])}return n},o.ZERO=i(new o(0,0,0)),o.UNIT_X=i(new o(1,0,0)),o.UNIT_Y=i(new o(0,1,0)),o.UNIT_Z=i(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r,t){return o.equalsEpsilon(this,e,r,t)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n){"use strict";var o=function(r,t,i){this.longitude=e(r,0),this.latitude=e(t,0),this.height=e(i,0)};return o.fromRadians=function(i,n,a,u){if(!r(i))throw new t("longitude is required.");if(!r(n))throw new t("latitude is required.");return a=e(a,0),r(u)?(u.longitude=i,u.latitude=n,u.height=a,u):new o(i,n,a)},o.fromDegrees=function(e,i,a,u){if(!r(e))throw new t("longitude is required.");if(!r(i))throw new t("latitude is required.");return e=n.toRadians(e),i=n.toRadians(i),o.fromRadians(e,i,a,u)},o.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new o(e.longitude,e.latitude,e.height):void 0},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},o.equalsEpsilon=function(e,i,n){if("number"!=typeof n)throw new t("epsilon is required and must be a number.");return e===i||r(e)&&r(i)&&Math.abs(e.longitude-i.longitude)<=n&&Math.abs(e.latitude-i.latitude)<=n&&Math.abs(e.height-i.height)<=n},o.ZERO=i(new o(0,0,0)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r){return o.equalsEpsilon(this,e,r)},o.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},o}),define("Core/deprecationWarning",["./defined","./DeveloperError"],function(e,r){"use strict";var t={},i=function(i,n){if(!e(i)||!e(n))throw new r("identifier and message are required.");e(t[i])||(t[i]=!0,console.log(n))};return i}),define("Core/defineProperties",["./defined"],function(e){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),t=Object.defineProperties;return r&&e(t)||(t=function(e){return e}),t}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n,o,a,u){"use strict";function s(r,i,n,a){if(i=t(i,0),n=t(n,0),a=t(a,0),0>i||0>n||0>a)throw new o("All radii components must be greater than or equal to zero.");r._radii=new e(i,n,a),r._radiiSquared=new e(i*i,n*n,a*a),r._radiiToTheFourth=new e(i*i*i*i,n*n*n*n,a*a*a*a),r._oneOverRadii=new e(0===i?0:1/i,0===n?0:1/n,0===a?0:1/a),r._oneOverRadiiSquared=new e(0===i?0:1/(i*i),0===n?0:1/(n*n),0===a?0:1/(a*a)),r._minimumRadius=Math.min(i,n,a),r._maximumRadius=Math.max(i,n,a),r._centerToleranceSquared=u.EPSILON1}var E=function(e,r,t){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,s(this,e,r,t)};n(E.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),E.clone=function(r,t){if(!i(r))return void 0;var n=r._radii;return i(t)?(e.clone(n,t._radii),e.clone(r._radiiSquared,t._radiiSquared),e.clone(r._radiiToTheFourth,t._radiiToTheFourth),e.clone(r._oneOverRadii,t._oneOverRadii),e.clone(r._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=r._minimumRadius,t._maximumRadius=r._maximumRadius,t._centerToleranceSquared=r._centerToleranceSquared,t):new E(n.x,n.y,n.z)},E.fromCartesian3=function(e,r){return i(r)||(r=new E),i(e)?(s(r,e.x,e.y,e.z),r):r},E.WGS84=a(new E(6378137,6378137,6356752.314245179)),E.UNIT_SPHERE=a(new E(1,1,1)),E.MOON=a(new E(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),E.prototype.clone=function(e){return E.clone(this,e)},E.packedLength=e.packedLength,E.pack=function(r,n,a){if(!i(r))throw new o("value is required");if(!i(n))throw new o("array is required");a=t(a,0),e.pack(r._radii,n,a)},E.unpack=function(r,n,a){if(!i(r))throw new o("array is required");n=t(n,0);var u=e.unpack(r,n);return E.fromCartesian3(u,a)},E.prototype.geocentricSurfaceNormal=e.normalize,E.prototype.geodeticSurfaceNormalCartographic=function(r,t){if(!i(r))throw new o("cartographic is required.");var n=r.longitude,a=r.latitude,u=Math.cos(a),s=u*Math.cos(n),E=u*Math.sin(n),f=Math.sin(a);return i(t)||(t=new e),t.x=s,t.y=E,t.z=f,e.normalize(t,t)},E.prototype.geodeticSurfaceNormal=function(r,t){return i(t)||(t=new e),t=e.multiplyComponents(r,this._oneOverRadiiSquared,t),e.normalize(t,t)};var f=new e,c=new e;E.prototype.cartographicToCartesian=function(r,t){var n=f,o=c;this.geodeticSurfaceNormalCartographic(r,n),e.multiplyComponents(this._radiiSquared,n,o);var a=Math.sqrt(e.dot(n,o));return e.divideByScalar(o,a,o),e.multiplyByScalar(n,r.height,n),i(t)||(t=new e),e.add(o,n,t)},E.prototype.cartographicArrayToCartesianArray=function(e,r){if(!i(e))throw new o("cartographics is required.");var t=e.length;i(r)?r.length=t:r=new Array(t);for(var n=0;t>n;n++)r[n]=this.cartographicToCartesian(e[n],r[n]);return r};var h=new e,w=new e,d=new e;E.prototype.cartesianToCartographic=function(t,n){var o=this.scaleToGeodeticSurface(t,w);if(!i(o))return void 0;var a=this.geodeticSurfaceNormal(o,h),s=e.subtract(t,o,d),E=Math.atan2(a.y,a.x),f=Math.asin(a.z),c=u.sign(e.dot(s,t))*e.magnitude(s);return i(n)?(n.longitude=E,n.latitude=f,n.height=c,n):new r(E,f,c)},E.prototype.cartesianArrayToCartographicArray=function(e,r){if(!i(e))throw new o("cartesians is required.");var t=e.length;i(r)?r.length=t:r=new Array(t);for(var n=0;t>n;++n)r[n]=this.cartesianToCartographic(e[n],r[n]);return r};var _=new e,l=new e;return E.prototype.scaleToGeodeticSurface=function(r,t){if(!i(r))throw new o("cartesian is required.");var n=r.x,a=r.y,s=r.z,E=this._oneOverRadii,f=E.x,c=E.y,h=E.z,w=n*n*f*f,d=a*a*c*c,R=s*s*h*h,T=w+d+R,A=Math.sqrt(1/T),N=e.multiplyByScalar(r,A,_);if(T<this._centerToleranceSquared)return isFinite(A)?e.clone(N,t):void 0;var m=this._oneOverRadiiSquared,I=m.x,S=m.y,O=m.z,M=l;M.x=N.x*I*2,M.y=N.y*S*2,M.z=N.z*O*2;var p,y,q,C,U,P,L,F,v,g,D,B=(1-A)*e.magnitude(r)/(.5*e.magnitude(M)),x=0;do{B-=x,q=1/(1+B*I),C=1/(1+B*S),U=1/(1+B*O),P=q*q,L=C*C,F=U*U,v=P*q,g=L*C,D=F*U,p=w*P+d*L+R*F-1,y=w*v*I+d*g*S+R*D*O;var b=-2*y;x=p/b}while(Math.abs(p)>u.EPSILON12);return i(t)?(t.x=n*q,t.y=a*C,t.z=s*U,t):new e(n*q,a*C,s*U)},E.prototype.scaleToGeocentricSurface=function(r,t){if(!i(r))throw new o("cartesian is required.");i(t)||(t=new e);var n=r.x,a=r.y,u=r.z,s=this._oneOverRadiiSquared,E=1/Math.sqrt(n*n*s.x+a*a*s.y+u*u*s.z);return e.multiplyByScalar(r,E,t)},E.prototype.transformPositionToScaledSpace=function(r,t){return i(t)||(t=new e),e.multiplyComponents(r,this._oneOverRadii,t)},E.prototype.transformPositionFromScaledSpace=function(r,t){return i(t)||(t=new e),e.multiplyComponents(r,this._radii,t)},E.prototype.equals=function(r){return this===r||i(r)&&e.equals(this._radii,r._radii)},E.prototype.toString=function(){return this._radii.toString()},E}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,r,t,i,n,o,a){"use strict";var u=function(e){this._ellipsoid=t(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return n(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(r,t){var n=this._semimajorAxis,o=r.longitude*n,a=r.latitude*n,u=r.height;return i(t)?(t.x=o,t.y=a,t.z=u,t):new e(o,a,u)},u.prototype.unproject=function(e,t){if(!i(e))throw new o("cartesian is required");var n=this._oneOverSemimajorAxis,a=e.x*n,u=e.y*n,s=e.z;return i(t)?(t.longitude=a,t.latitude=u,t.height=s,t):new r(a,u,s)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var r={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(r)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var r=function(r,t){this.start=e(r,0),this.stop=e(t,0)};return r}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n){"use strict";var o=function(r,t,i,n){this.x=e(r,0),this.y=e(t,0),this.z=e(i,0),this.w=e(n,0)};o.fromElements=function(e,t,i,n,a){return r(a)?(a.x=e,a.y=t,a.z=i,a.w=n,a):new o(e,t,i,n)},o.fromColor=function(e,i){if(!r(e))throw new t("color is required");return r(i)?(i.x=e.red,i.y=e.green,i.z=e.blue,i.w=e.alpha,i):new o(e.red,e.green,e.blue,e.alpha)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new o(e.x,e.y,e.z,e.w):void 0},o.packedLength=4,o.pack=function(i,n,o){if(!r(i))throw new t("value is required");if(!r(n))throw new t("array is required");o=e(o,0),n[o++]=i.x,n[o++]=i.y,n[o++]=i.z,n[o]=i.w},o.unpack=function(i,n,a){if(!r(i))throw new t("array is required");return n=e(n,0),r(a)||(a=new o),a.x=i[n++],a.y=i[n++],a.z=i[n++],a.w=i[n],a},o.fromArray=o.unpack,o.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z,e.w)},o.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z,e.w)},o.minimumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.min(e.x,i.x),n.y=Math.min(e.y,i.y),n.z=Math.min(e.z,i.z),n.w=Math.min(e.w,i.w),n},o.maximumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.max(e.x,i.x),n.y=Math.max(e.y,i.y),n.z=Math.max(e.z,i.z),n.w=Math.max(e.w,i.w),n},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,i){if(!r(e)||!r(i))throw new t("left and right are required.");return o.subtract(e,i,a),o.magnitude(a)},o.distanceSquared=function(e,i){if(!r(e)||!r(i))throw new t("left and right are required.");return o.subtract(e,i,a),o.magnitudeSquared(a)},o.normalize=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");var n=o.magnitude(e);return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i.w=e.w/n,i},o.dot=function(e,i){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");return e.x*i.x+e.y*i.y+e.z*i.z+e.w*i.w},o.multiplyComponents=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x*i.x,n.y=e.y*i.y,n.z=e.z*i.z,n.w=e.w*i.w,n},o.add=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x+i.x,n.y=e.y+i.y,n.z=e.z+i.z,n.w=e.w+i.w,n},o.subtract=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x-i.x,n.y=e.y-i.y,n.z=e.z-i.z,n.w=e.w-i.w,n},o.multiplyByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x*i,n.y=e.y*i,n.z=e.z*i,n.w=e.w*i,n},o.divideByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n.w=e.w/i,n},o.negate=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=-e.x,i.y=-e.y,i.z=-e.z,i.w=-e.w,i},o.abs=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=Math.abs(e.x),i.y=Math.abs(e.y),i.z=Math.abs(e.z),i.w=Math.abs(e.w),i};var u=new o;o.lerp=function(e,i,n,a){if(!r(e))throw new t("start is required.");if(!r(i))throw new t("end is required.");if("number"!=typeof n)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(i,n,u),a=o.multiplyByScalar(e,1-n,a),o.add(u,a,a)};var s=new o;return o.mostOrthogonalAxis=function(e,i){if(!r(e))throw new t("cartesian is required.");if(!r(i))throw new t("result is required.");var n=o.normalize(e,s);return o.abs(n,n),i=n.x<=n.y?n.x<=n.z?n.x<=n.w?o.clone(o.UNIT_X,i):o.clone(o.UNIT_W,i):n.z<=n.w?o.clone(o.UNIT_Z,i):o.clone(o.UNIT_W,i):n.y<=n.z?n.y<=n.w?o.clone(o.UNIT_Y,i):o.clone(o.UNIT_W,i):n.z<=n.w?o.clone(o.UNIT_Z,i):o.clone(o.UNIT_W,i)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},o.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]&&e.z===r[t+2]&&e.w===r[t+3]},o.equalsEpsilon=function(e,t,i,o){return e===t||r(e)&&r(t)&&n.equalsEpsilon(e.x,t.x,i,o)&&n.equalsEpsilon(e.y,t.y,i,o)&&n.equalsEpsilon(e.z,t.z,i,o)&&n.equalsEpsilon(e.w,t.w,i,o)},o.ZERO=i(new o(0,0,0,0)),o.UNIT_X=i(new o(1,0,0,0)),o.UNIT_Y=i(new o(0,1,0,0)),o.UNIT_Z=i(new o(0,0,1,0)),o.UNIT_W=i(new o(0,0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r,t){return o.equalsEpsilon(this,e,r,t)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},o}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n,o){"use strict";function a(e){for(var r=0,t=0;9>t;++t){var i=e[t];r+=i*i}return Math.sqrt(r)}function u(e){for(var r=0,t=0;3>t;++t){var i=e[E.getElementIndex(w[t],h[t])];r+=2*i*i}return Math.sqrt(r)}function s(e,r){for(var t=o.EPSILON15,i=0,n=1,a=0;3>a;++a){var u=Math.abs(e[E.getElementIndex(w[a],h[a])]);u>i&&(n=a,i=u)}var s=1,f=0,c=h[n],d=w[n];if(Math.abs(e[E.getElementIndex(d,c)])>t){var _,l=e[E.getElementIndex(d,d)],R=e[E.getElementIndex(c,c)],T=e[E.getElementIndex(d,c)],A=(l-R)/2/T;_=0>A?-1/(-A+Math.sqrt(1+A*A)):1/(A+Math.sqrt(1+A*A)),s=1/Math.sqrt(1+_*_),f=_*s}return r=E.clone(E.IDENTITY,r),r[E.getElementIndex(c,c)]=r[E.getElementIndex(d,d)]=s,r[E.getElementIndex(d,c)]=f,r[E.getElementIndex(c,d)]=-f,r}var E=function(e,t,i,n,o,a,u,s,E){this[0]=r(e,0),this[1]=r(n,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(o,0),this[5]=r(s,0),this[6]=r(i,0),this[7]=r(a,0),this[8]=r(E,0)};E.packedLength=9,E.pack=function(e,n,o){if(!t(e))throw new i("value is required");if(!t(n))throw new i("array is required");o=r(o,0),n[o++]=e[0],n[o++]=e[1],n[o++]=e[2],n[o++]=e[3],n[o++]=e[4],n[o++]=e[5],n[o++]=e[6],n[o++]=e[7],n[o++]=e[8]},E.unpack=function(e,n,o){if(!t(e))throw new i("array is required");return n=r(n,0),t(o)||(o=new E),o[0]=e[n++],o[1]=e[n++],o[2]=e[n++],o[3]=e[n++],o[4]=e[n++],o[5]=e[n++],o[6]=e[n++],o[7]=e[n++],o[8]=e[n++],o},E.clone=function(e,r){return t(e)?t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):new E(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},E.fromArray=function(e,n,o){if(!t(e))throw new i("array is required");return n=r(n,0),t(o)||(o=new E),o[0]=e[n],o[1]=e[n+1],o[2]=e[n+2],o[3]=e[n+3],o[4]=e[n+4],o[5]=e[n+5],o[6]=e[n+6],o[7]=e[n+7],o[8]=e[n+8],o},E.fromColumnMajorArray=function(e,r){if(!t(e))throw new i("values parameter is required");return E.clone(e,r)},E.fromRowMajorArray=function(e,r){if(!t(e))throw new i("values is required.");return t(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new E(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},E.fromQuaternion=function(e,r){if(!t(e))throw new i("quaternion is required");var n=e.x*e.x,o=e.x*e.y,a=e.x*e.z,u=e.x*e.w,s=e.y*e.y,f=e.y*e.z,c=e.y*e.w,h=e.z*e.z,w=e.z*e.w,d=e.w*e.w,_=n-s-h+d,l=2*(o-w),R=2*(a+c),T=2*(o+w),A=-n+s-h+d,N=2*(f-u),m=2*(a-c),I=2*(f+u),S=-n-s+h+d;return t(r)?(r[0]=_,r[1]=T,r[2]=m,r[3]=l,r[4]=A,r[5]=I,r[6]=R,r[7]=N,r[8]=S,r):new E(_,l,R,T,A,N,m,I,S)},E.fromScale=function(e,r){if(!t(e))throw new i("scale is required.");return t(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new E(e.x,0,0,0,e.y,0,0,0,e.z)},E.fromUniformScale=function(e,r){if("number"!=typeof e)throw new i("scale is required.");return t(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new E(e,0,0,0,e,0,0,0,e)},E.fromCrossProduct=function(e,r){if(!t(e))throw new i("vector is required.");return t(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new E(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},E.fromRotationX=function(e,r){if(!t(e))throw new i("angle is required.");var n=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=n,r[5]=o,r[6]=0,r[7]=-o,r[8]=n,r):new E(1,0,0,0,n,-o,0,o,n)},E.fromRotationY=function(e,r){if(!t(e))throw new i("angle is required.");var n=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=n,r[1]=0,r[2]=-o,r[3]=0,r[4]=1,r[5]=0,r[6]=o,r[7]=0,r[8]=n,r):new E(n,0,o,0,1,0,-o,0,n)},E.fromRotationZ=function(e,r){if(!t(e))throw new i("angle is required.");var n=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=n,r[1]=o,r[2]=0,r[3]=-o,r[4]=n,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new E(n,-o,0,o,n,0,0,0,1)},E.toArray=function(e,r){if(!t(e))throw new i("matrix is required");return t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},E.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>2)throw new i("row must be 0, 1, or 2.");if("number"!=typeof e||0>e||e>2)throw new i("column must be 0, 1, or 2.");return 3*e+r},E.getColumn=function(e,r,n){if(!t(e))throw new i("matrix is required.");if("number"!=typeof r||0>r||r>2)throw new i("index must be 0, 1, or 2.");if(!t(n))throw new i("result is required");var o=3*r,a=e[o],u=e[o+1],s=e[o+2];return n.x=a,n.y=u,n.z=s,n},E.setColumn=function(e,r,n,o){if(!t(e))throw new i("matrix is required");if(!t(n))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new i("index must be 0, 1, or 2.");if(!t(o))throw new i("result is required");o=E.clone(e,o);var a=3*r;return o[a]=n.x,o[a+1]=n.y,o[a+2]=n.z,o},E.getRow=function(e,r,n){if(!t(e))throw new i("matrix is required.");if("number"!=typeof r||0>r||r>2)throw new i("index must be 0, 1, or 2.");if(!t(n))throw new i("result is required");var o=e[r],a=e[r+3],u=e[r+6];
return n.x=o,n.y=a,n.z=u,n},E.setRow=function(e,r,n,o){if(!t(e))throw new i("matrix is required");if(!t(n))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new i("index must be 0, 1, or 2.");if(!t(o))throw new i("result is required");return o=E.clone(e,o),o[r]=n.x,o[r+3]=n.y,o[r+6]=n.z,o};var f=new e;E.getScale=function(r,n){if(!t(r))throw new i("matrix is required.");if(!t(n))throw new i("result is required");return n.x=e.magnitude(e.fromElements(r[0],r[1],r[2],f)),n.y=e.magnitude(e.fromElements(r[3],r[4],r[5],f)),n.z=e.magnitude(e.fromElements(r[6],r[7],r[8],f)),n};var c=new e;E.getMaximumScale=function(r){return E.getScale(r,c),e.maximumComponent(c)},E.multiply=function(e,r,n){if(!t(e))throw new i("left is required");if(!t(r))throw new i("right is required");if(!t(n))throw new i("result is required");var o=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],a=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],u=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],s=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],E=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],f=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],c=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],h=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],w=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return n[0]=o,n[1]=a,n[2]=u,n[3]=s,n[4]=E,n[5]=f,n[6]=c,n[7]=h,n[8]=w,n},E.add=function(e,r,n){if(!t(e))throw new i("left is required");if(!t(r))throw new i("right is required");if(!t(n))throw new i("result is required");return n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n[4]=e[4]+r[4],n[5]=e[5]+r[5],n[6]=e[6]+r[6],n[7]=e[7]+r[7],n[8]=e[8]+r[8],n},E.subtract=function(e,r,n){if(!t(e))throw new i("left is required");if(!t(r))throw new i("right is required");if(!t(n))throw new i("result is required");return n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n[4]=e[4]-r[4],n[5]=e[5]-r[5],n[6]=e[6]-r[6],n[7]=e[7]-r[7],n[8]=e[8]-r[8],n},E.multiplyByVector=function(e,r,n){if(!t(e))throw new i("matrix is required");if(!t(r))throw new i("cartesian is required");if(!t(n))throw new i("result is required");var o=r.x,a=r.y,u=r.z,s=e[0]*o+e[3]*a+e[6]*u,E=e[1]*o+e[4]*a+e[7]*u,f=e[2]*o+e[5]*a+e[8]*u;return n.x=s,n.y=E,n.z=f,n},E.multiplyByScalar=function(e,r,n){if(!t(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scalar must be a number");if(!t(n))throw new i("result is required");return n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*r,n[7]=e[7]*r,n[8]=e[8]*r,n},E.multiplyByScale=function(e,r,n){if(!t(e))throw new i("matrix is required");if(!t(r))throw new i("scale is required");if(!t(n))throw new i("result is required");return n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.x,n[3]=e[3]*r.y,n[4]=e[4]*r.y,n[5]=e[5]*r.y,n[6]=e[6]*r.z,n[7]=e[7]*r.z,n[8]=e[8]*r.z,n},E.negate=function(e,r){if(!t(e))throw new i("matrix is required");if(!t(r))throw new i("result is required");return r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},E.transpose=function(e,r){if(!t(e))throw new i("matrix is required");if(!t(r))throw new i("result is required");var n=e[0],o=e[3],a=e[6],u=e[1],s=e[4],E=e[7],f=e[2],c=e[5],h=e[8];return r[0]=n,r[1]=o,r[2]=a,r[3]=u,r[4]=s,r[5]=E,r[6]=f,r[7]=c,r[8]=h,r};var h=[1,0,0],w=[2,2,1],d=new E,_=new E;return E.computeEigenDecomposition=function(e,r){if(!t(e))throw new i("matrix is required.");var n=o.EPSILON20,f=10,c=0,h=0;t(r)||(r={});for(var w=r.unitary=E.clone(E.IDENTITY,r.unitary),l=r.diagonal=E.clone(e,r.diagonal),R=n*a(l);f>h&&u(l)>R;)s(l,d),E.transpose(d,_),E.multiply(l,d,l),E.multiply(_,l,l),E.multiply(w,d,w),++c>2&&(++h,c=0);return r},E.abs=function(e,r){if(!t(e))throw new i("matrix is required");if(!t(r))throw new i("result is required");return r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},E.determinant=function(e){if(!t(e))throw new i("matrix is required");var r=e[0],n=e[3],o=e[6],a=e[1],u=e[4],s=e[7],E=e[2],f=e[5],c=e[8];return r*(u*c-f*s)+a*(f*o-n*c)+E*(n*s-u*o)},E.inverse=function(e,r){if(!t(e))throw new i("matrix is required");if(!t(r))throw new i("result is required");var n=e[0],a=e[1],u=e[2],s=e[3],f=e[4],c=e[5],h=e[6],w=e[7],d=e[8],_=E.determinant(e);if(Math.abs(_)<=o.EPSILON15)throw new i("matrix is not invertible");r[0]=f*d-w*c,r[1]=w*u-a*d,r[2]=a*c-f*u,r[3]=h*c-s*d,r[4]=n*d-h*u,r[5]=s*u-n*c,r[6]=s*w-h*f,r[7]=h*a-n*w,r[8]=n*f-s*a;var l=1/_;return E.multiplyByScalar(r,l,r)},E.equals=function(e,r){return e===r||t(e)&&t(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]},E.equalsEpsilon=function(e,r,n){if("number"!=typeof n)throw new i("epsilon must be a number");return e===r||t(e)&&t(r)&&Math.abs(e[0]-r[0])<=n&&Math.abs(e[1]-r[1])<=n&&Math.abs(e[2]-r[2])<=n&&Math.abs(e[3]-r[3])<=n&&Math.abs(e[4]-r[4])<=n&&Math.abs(e[5]-r[5])<=n&&Math.abs(e[6]-r[6])<=n&&Math.abs(e[7]-r[7])<=n&&Math.abs(e[8]-r[8])<=n},E.IDENTITY=n(new E(1,0,0,0,1,0,0,0,1)),E.ZERO=n(new E(0,0,0,0,0,0,0,0,0)),E.COLUMN0ROW0=0,E.COLUMN0ROW1=1,E.COLUMN0ROW2=2,E.COLUMN1ROW0=3,E.COLUMN1ROW1=4,E.COLUMN1ROW2=5,E.COLUMN2ROW0=6,E.COLUMN2ROW1=7,E.COLUMN2ROW2=8,E.prototype.clone=function(e){return E.clone(this,e)},E.prototype.equals=function(e){return E.equals(this,e)},E.equalsArray=function(e,r,t){return e[0]===r[t]&&e[1]===r[t+1]&&e[2]===r[t+2]&&e[3]===r[t+3]&&e[4]===r[t+4]&&e[5]===r[t+5]&&e[6]===r[t+6]&&e[7]===r[t+7]&&e[8]===r[t+8]},E.prototype.equalsEpsilon=function(e,r){return E.equalsEpsilon(this,e,r)},E.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},E}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var r=function(e){this.name="RuntimeError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,r,t,i,n,o,a,u,s){"use strict";var E=function(e,r,i,n,o,a,u,s,E,f,c,h,w,d,_,l){this[0]=t(e,0),this[1]=t(o,0),this[2]=t(E,0),this[3]=t(w,0),this[4]=t(r,0),this[5]=t(a,0),this[6]=t(f,0),this[7]=t(d,0),this[8]=t(i,0),this[9]=t(u,0),this[10]=t(c,0),this[11]=t(_,0),this[12]=t(n,0),this[13]=t(s,0),this[14]=t(h,0),this[15]=t(l,0)};E.packedLength=16,E.pack=function(e,r,o){if(!i(e))throw new n("value is required");if(!i(r))throw new n("array is required");o=t(o,0),r[o++]=e[0],r[o++]=e[1],r[o++]=e[2],r[o++]=e[3],r[o++]=e[4],r[o++]=e[5],r[o++]=e[6],r[o++]=e[7],r[o++]=e[8],r[o++]=e[9],r[o++]=e[10],r[o++]=e[11],r[o++]=e[12],r[o++]=e[13],r[o++]=e[14],r[o]=e[15]},E.unpack=function(e,r,o){if(!i(e))throw new n("array is required");return r=t(r,0),i(o)||(o=new E),o[0]=e[r++],o[1]=e[r++],o[2]=e[r++],o[3]=e[r++],o[4]=e[r++],o[5]=e[r++],o[6]=e[r++],o[7]=e[r++],o[8]=e[r++],o[9]=e[r++],o[10]=e[r++],o[11]=e[r++],o[12]=e[r++],o[13]=e[r++],o[14]=e[r++],o[15]=e[r],o},E.clone=function(e,r){return i(e)?i(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):new E(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},E.fromArray=E.unpack,E.fromColumnMajorArray=function(e,r){if(!i(e))throw new n("values is required");return E.clone(e,r)},E.fromRowMajorArray=function(e,r){if(!i(e))throw new n("values is required.");return i(r)?(r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=e[1],r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=e[2],r[9]=e[6],r[10]=e[10],r[11]=e[14],r[12]=e[3],r[13]=e[7],r[14]=e[11],r[15]=e[15],r):new E(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},E.fromRotationTranslation=function(r,o,a){if(!i(r))throw new n("rotation is required.");return o=t(o,e.ZERO),i(a)?(a[0]=r[0],a[1]=r[1],a[2]=r[2],a[3]=0,a[4]=r[3],a[5]=r[4],a[6]=r[5],a[7]=0,a[8]=r[6],a[9]=r[7],a[10]=r[8],a[11]=0,a[12]=o.x,a[13]=o.y,a[14]=o.z,a[15]=1,a):new E(r[0],r[3],r[6],o.x,r[1],r[4],r[7],o.y,r[2],r[5],r[8],o.z,0,0,0,1)},E.fromTranslationQuaternionRotationScale=function(e,r,t,o){if(!i(e))throw new n("translation is required.");if(!i(r))throw new n("rotation is required.");if(!i(t))throw new n("scale is required.");i(o)||(o=new E);var a=t.x,u=t.y,s=t.z,f=r.x*r.x,c=r.x*r.y,h=r.x*r.z,w=r.x*r.w,d=r.y*r.y,_=r.y*r.z,l=r.y*r.w,R=r.z*r.z,T=r.z*r.w,A=r.w*r.w,N=f-d-R+A,m=2*(c-T),I=2*(h+l),S=2*(c+T),O=-f+d-R+A,M=2*(_-w),p=2*(h-l),y=2*(_+w),q=-f-d+R+A;return o[0]=N*a,o[1]=S*a,o[2]=p*a,o[3]=0,o[4]=m*u,o[5]=O*u,o[6]=y*u,o[7]=0,o[8]=I*s,o[9]=M*s,o[10]=q*s,o[11]=0,o[12]=e.x,o[13]=e.y,o[14]=e.z,o[15]=1,o},E.fromTranslation=function(e,r){if(!i(e))throw new n("translation is required.");return E.fromRotationTranslation(u.IDENTITY,e,r)},E.fromScale=function(e,r){if(!i(e))throw new n("scale is required.");return i(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e.y,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e.z,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new E(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},E.fromUniformScale=function(e,r){if("number"!=typeof e)throw new n("scale is required.");return i(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new E(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var f=new e,c=new e,h=new e;E.fromCamera=function(r,t){if(!i(r))throw new n("camera is required.");var o=r.eye,a=r.target,u=r.up;if(!i(o))throw new n("camera.eye is required.");if(!i(a))throw new n("camera.target is required.");if(!i(u))throw new n("camera.up is required.");e.normalize(e.subtract(a,o,f),f),e.normalize(e.cross(f,u,c),c),e.normalize(e.cross(c,f,h),h);var s=c.x,w=c.y,d=c.z,_=f.x,l=f.y,R=f.z,T=h.x,A=h.y,N=h.z,m=o.x,I=o.y,S=o.z,O=s*-m+w*-I+d*-S,M=T*-m+A*-I+N*-S,p=_*m+l*I+R*S;return i(t)?(t[0]=s,t[1]=T,t[2]=-_,t[3]=0,t[4]=w,t[5]=A,t[6]=-l,t[7]=0,t[8]=d,t[9]=N,t[10]=-R,t[11]=0,t[12]=O,t[13]=M,t[14]=p,t[15]=1,t):new E(s,w,d,O,T,A,N,M,-_,-l,-R,p,0,0,0,1)},E.computePerspectiveFieldOfView=function(e,r,t,o,a){if(0>=e||e>Math.PI)throw new n("fovY must be in [0, PI).");if(0>=r)throw new n("aspectRatio must be greater than zero.");if(0>=t)throw new n("near must be greater than zero.");if(0>=o)throw new n("far must be greater than zero.");if(!i(a))throw new n("result is required");var u=Math.tan(.5*e),s=1/u,E=s/r,f=(o+t)/(t-o),c=2*o*t/(t-o);return a[0]=E,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=s,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=f,a[11]=-1,a[12]=0,a[13]=0,a[14]=c,a[15]=0,a},E.computeOrthographicOffCenter=function(e,r,t,o,a,u,s){if(!i(e))throw new n("left is required.");if(!i(r))throw new n("right is required.");if(!i(t))throw new n("bottom is required.");if(!i(o))throw new n("top is required.");if(!i(a))throw new n("near is required.");if(!i(u))throw new n("far is required.");if(!i(s))throw new n("result is required");var E=1/(r-e),f=1/(o-t),c=1/(u-a),h=-(r+e)*E,w=-(o+t)*f,d=-(u+a)*c;return E*=2,f*=2,c*=-2,s[0]=E,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=f,s[6]=0,s[7]=0,s[8]=0,s[9]=0,s[10]=c,s[11]=0,s[12]=h,s[13]=w,s[14]=d,s[15]=1,s},E.computePerspectiveOffCenter=function(e,r,t,o,a,u,s){if(!i(e))throw new n("left is required.");if(!i(r))throw new n("right is required.");if(!i(t))throw new n("bottom is required.");if(!i(o))throw new n("top is required.");if(!i(a))throw new n("near is required.");if(!i(u))throw new n("far is required.");if(!i(s))throw new n("result is required");var E=2*a/(r-e),f=2*a/(o-t),c=(r+e)/(r-e),h=(o+t)/(o-t),w=-(u+a)/(u-a),d=-1,_=-2*u*a/(u-a);return s[0]=E,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=f,s[6]=0,s[7]=0,s[8]=c,s[9]=h,s[10]=w,s[11]=d,s[12]=0,s[13]=0,s[14]=_,s[15]=0,s},E.computeInfinitePerspectiveOffCenter=function(e,r,t,o,a,u){if(!i(e))throw new n("left is required.");if(!i(r))throw new n("right is required.");if(!i(t))throw new n("bottom is required.");if(!i(o))throw new n("top is required.");if(!i(a))throw new n("near is required.");if(!i(u))throw new n("result is required");var s=2*a/(r-e),E=2*a/(o-t),f=(r+e)/(r-e),c=(o+t)/(o-t),h=-1,w=-1,d=-2*a;return u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=E,u[6]=0,u[7]=0,u[8]=f,u[9]=c,u[10]=h,u[11]=w,u[12]=0,u[13]=0,u[14]=d,u[15]=0,u},E.computeViewportTransformation=function(e,r,o,a){if(!i(a))throw new n("result is required");e=t(e,t.EMPTY_OBJECT);var u=t(e.x,0),s=t(e.y,0),E=t(e.width,0),f=t(e.height,0);r=t(r,0),o=t(o,1);var c=.5*E,h=.5*f,w=.5*(o-r),d=c,_=h,l=w,R=u+c,T=s+h,A=r+w,N=1;return a[0]=d,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=_,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=l,a[11]=0,a[12]=R,a[13]=T,a[14]=A,a[15]=N,a},E.toArray=function(e,r){if(!i(e))throw new n("matrix is required");return i(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},E.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>3)throw new n("row must be 0, 1, 2, or 3.");if("number"!=typeof e||0>e||e>3)throw new n("column must be 0, 1, 2, or 3.");return 4*e+r},E.getColumn=function(e,r,t){if(!i(e))throw new n("matrix is required.");if("number"!=typeof r||0>r||r>3)throw new n("index must be 0, 1, 2, or 3.");if(!i(t))throw new n("result is required");var o=4*r,a=e[o],u=e[o+1],s=e[o+2],E=e[o+3];return t.x=a,t.y=u,t.z=s,t.w=E,t},E.setColumn=function(e,r,t,o){if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new n("index must be 0, 1, 2, or 3.");if(!i(o))throw new n("result is required");o=E.clone(e,o);var a=4*r;return o[a]=t.x,o[a+1]=t.y,o[a+2]=t.z,o[a+3]=t.w,o},E.setTranslation=function(e,r,t){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("translation is required");if(!i(t))throw new n("result is required");return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=r.x,t[13]=r.y,t[14]=r.z,t[15]=e[15],t},E.getRow=function(e,r,t){if(!i(e))throw new n("matrix is required.");if("number"!=typeof r||0>r||r>3)throw new n("index must be 0, 1, 2, or 3.");if(!i(t))throw new n("result is required");var o=e[r],a=e[r+4],u=e[r+8],s=e[r+12];return t.x=o,t.y=a,t.z=u,t.w=s,t},E.setRow=function(e,r,t,o){if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new n("index must be 0, 1, 2, or 3.");if(!i(o))throw new n("result is required");return o=E.clone(e,o),o[r]=t.x,o[r+4]=t.y,o[r+8]=t.z,o[r+12]=t.w,o};var w=new e;E.getScale=function(r,t){if(!i(r))throw new n("matrix is required.");if(!i(t))throw new n("result is required");return t.x=e.magnitude(e.fromElements(r[0],r[1],r[2],w)),t.y=e.magnitude(e.fromElements(r[4],r[5],r[6],w)),t.z=e.magnitude(e.fromElements(r[8],r[9],r[10],w)),t};var d=new e;E.getMaximumScale=function(r){return E.getScale(r,d),e.maximumComponent(d)},E.multiply=function(e,r,t){if(!i(e))throw new n("left is required");if(!i(r))throw new n("right is required");if(!i(t))throw new n("result is required");var o=e[0],a=e[1],u=e[2],s=e[3],E=e[4],f=e[5],c=e[6],h=e[7],w=e[8],d=e[9],_=e[10],l=e[11],R=e[12],T=e[13],A=e[14],N=e[15],m=r[0],I=r[1],S=r[2],O=r[3],M=r[4],p=r[5],y=r[6],q=r[7],C=r[8],U=r[9],P=r[10],L=r[11],F=r[12],v=r[13],g=r[14],D=r[15],B=o*m+E*I+w*S+R*O,x=a*m+f*I+d*S+T*O,b=u*m+c*I+_*S+A*O,G=s*m+h*I+l*S+N*O,z=o*M+E*p+w*y+R*q,X=a*M+f*p+d*y+T*q,V=u*M+c*p+_*y+A*q,H=s*M+h*p+l*y+N*q,W=o*C+E*U+w*P+R*L,Y=a*C+f*U+d*P+T*L,K=u*C+c*U+_*P+A*L,k=s*C+h*U+l*P+N*L,Z=o*F+E*v+w*g+R*D,j=a*F+f*v+d*g+T*D,Q=u*F+c*v+_*g+A*D,J=s*F+h*v+l*g+N*D;return t[0]=B,t[1]=x,t[2]=b,t[3]=G,t[4]=z,t[5]=X,t[6]=V,t[7]=H,t[8]=W,t[9]=Y,t[10]=K,t[11]=k,t[12]=Z,t[13]=j,t[14]=Q,t[15]=J,t},E.add=function(e,r,t){if(!i(e))throw new n("left is required");if(!i(r))throw new n("right is required");if(!i(t))throw new n("result is required");return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t[6]=e[6]+r[6],t[7]=e[7]+r[7],t[8]=e[8]+r[8],t[9]=e[9]+r[9],t[10]=e[10]+r[10],t[11]=e[11]+r[11],t[12]=e[12]+r[12],t[13]=e[13]+r[13],t[14]=e[14]+r[14],t[15]=e[15]+r[15],t},E.subtract=function(e,r,t){if(!i(e))throw new n("left is required");if(!i(r))throw new n("right is required");if(!i(t))throw new n("result is required");return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t[4]=e[4]-r[4],t[5]=e[5]-r[5],t[6]=e[6]-r[6],t[7]=e[7]-r[7],t[8]=e[8]-r[8],t[9]=e[9]-r[9],t[10]=e[10]-r[10],t[11]=e[11]-r[11],t[12]=e[12]-r[12],t[13]=e[13]-r[13],t[14]=e[14]-r[14],t[15]=e[15]-r[15],t},E.multiplyTransformation=function(e,r,t){if(!i(e))throw new n("left is required");if(!i(r))throw new n("right is required");if(!i(t))throw new n("result is required");var o=e[0],a=e[1],u=e[2],s=e[4],E=e[5],f=e[6],c=e[8],h=e[9],w=e[10],d=e[12],_=e[13],l=e[14],R=r[0],T=r[1],A=r[2],N=r[4],m=r[5],I=r[6],S=r[8],O=r[9],M=r[10],p=r[12],y=r[13],q=r[14],C=o*R+s*T+c*A,U=a*R+E*T+h*A,P=u*R+f*T+w*A,L=o*N+s*m+c*I,F=a*N+E*m+h*I,v=u*N+f*m+w*I,g=o*S+s*O+c*M,D=a*S+E*O+h*M,B=u*S+f*O+w*M,x=o*p+s*y+c*q+d,b=a*p+E*y+h*q+_,G=u*p+f*y+w*q+l;return t[0]=C,t[1]=U,t[2]=P,t[3]=0,t[4]=L,t[5]=F,t[6]=v,t[7]=0,t[8]=g,t[9]=D,t[10]=B,t[11]=0,t[12]=x,t[13]=b,t[14]=G,t[15]=1,t},E.multiplyByMatrix3=function(e,r,t){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("rotation is required");if(!i(t))throw new n("result is required");var o=e[0],a=e[1],u=e[2],s=e[4],E=e[5],f=e[6],c=e[8],h=e[9],w=e[10],d=r[0],_=r[1],l=r[2],R=r[3],T=r[4],A=r[5],N=r[6],m=r[7],I=r[8],S=o*d+s*_+c*l,O=a*d+E*_+h*l,M=u*d+f*_+w*l,p=o*R+s*T+c*A,y=a*R+E*T+h*A,q=u*R+f*T+w*A,C=o*N+s*m+c*I,U=a*N+E*m+h*I,P=u*N+f*m+w*I;return t[0]=S,t[1]=O,t[2]=M,t[3]=0,t[4]=p,t[5]=y,t[6]=q,t[7]=0,t[8]=C,t[9]=U,t[10]=P,t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},E.multiplyByTranslation=function(e,r,t){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("translation is required");if(!i(t))throw new n("result is required");var o=r.x,a=r.y,u=r.z,s=o*e[0]+a*e[4]+u*e[8]+e[12],E=o*e[1]+a*e[5]+u*e[9]+e[13],f=o*e[2]+a*e[6]+u*e[10]+e[14];return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=s,t[13]=E,t[14]=f,t[15]=e[15],t};var _=new e;E.multiplyByUniformScale=function(e,r,t){if(!i(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scale is required");if(!i(t))throw new n("result is required");return _.x=r,_.y=r,_.z=r,E.multiplyByScale(e,_,t)},E.multiplyByScale=function(e,r,t){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("scale is required");if(!i(t))throw new n("result is required");var o=r.x,a=r.y,u=r.z;return 1===o&&1===a&&1===u?E.clone(e,t):(t[0]=o*e[0],t[1]=o*e[1],t[2]=o*e[2],t[3]=0,t[4]=a*e[4],t[5]=a*e[5],t[6]=a*e[6],t[7]=0,t[8]=u*e[8],t[9]=u*e[9],t[10]=u*e[10],t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=1,t)},E.multiplyByVector=function(e,r,t){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("cartesian is required");if(!i(t))throw new n("result is required");var o=r.x,a=r.y,u=r.z,s=r.w,E=e[0]*o+e[4]*a+e[8]*u+e[12]*s,f=e[1]*o+e[5]*a+e[9]*u+e[13]*s,c=e[2]*o+e[6]*a+e[10]*u+e[14]*s,h=e[3]*o+e[7]*a+e[11]*u+e[15]*s;return t.x=E,t.y=f,t.z=c,t.w=h,t},E.multiplyByPointAsVector=function(e,r,t){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("cartesian is required");if(!i(t))throw new n("result is required");var o=r.x,a=r.y,u=r.z,s=e[0]*o+e[4]*a+e[8]*u,E=e[1]*o+e[5]*a+e[9]*u,f=e[2]*o+e[6]*a+e[10]*u;return t.x=s,t.y=E,t.z=f,t},E.multiplyByPoint=function(e,r,t){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("cartesian is required");if(!i(t))throw new n("result is required");var o=r.x,a=r.y,u=r.z,s=e[0]*o+e[4]*a+e[8]*u+e[12],E=e[1]*o+e[5]*a+e[9]*u+e[13],f=e[2]*o+e[6]*a+e[10]*u+e[14];return t.x=s,t.y=E,t.z=f,t},E.multiplyByScalar=function(e,r,t){if(!i(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scalar must be a number");if(!i(t))throw new n("result is required");return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t},E.negate=function(e,r){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("result is required");return r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r[9]=-e[9],r[10]=-e[10],r[11]=-e[11],r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=-e[15],r},E.transpose=function(e,r){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("result is required");var t=e[1],o=e[2],a=e[3],u=e[6],s=e[7],E=e[11];return r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=t,r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=o,r[9]=u,r[10]=e[10],r[11]=e[14],r[12]=a,r[13]=s,r[14]=E,r[15]=e[15],r},E.abs=function(e,r){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("result is required");return r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r[9]=Math.abs(e[9]),r[10]=Math.abs(e[10]),r[11]=Math.abs(e[11]),r[12]=Math.abs(e[12]),r[13]=Math.abs(e[13]),r[14]=Math.abs(e[14]),r[15]=Math.abs(e[15]),r},E.equals=function(e,r){return e===r||i(e)&&i(r)&&e[12]===r[12]&&e[13]===r[13]&&e[14]===r[14]&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[8]===r[8]&&e[9]===r[9]&&e[10]===r[10]&&e[3]===r[3]&&e[7]===r[7]&&e[11]===r[11]&&e[15]===r[15]},E.equalsEpsilon=function(e,r,t){if("number"!=typeof t)throw new n("epsilon must be a number");return e===r||i(e)&&i(r)&&Math.abs(e[0]-r[0])<=t&&Math.abs(e[1]-r[1])<=t&&Math.abs(e[2]-r[2])<=t&&Math.abs(e[3]-r[3])<=t&&Math.abs(e[4]-r[4])<=t&&Math.abs(e[5]-r[5])<=t&&Math.abs(e[6]-r[6])<=t&&Math.abs(e[7]-r[7])<=t&&Math.abs(e[8]-r[8])<=t&&Math.abs(e[9]-r[9])<=t&&Math.abs(e[10]-r[10])<=t&&Math.abs(e[11]-r[11])<=t&&Math.abs(e[12]-r[12])<=t&&Math.abs(e[13]-r[13])<=t&&Math.abs(e[14]-r[14])<=t&&Math.abs(e[15]-r[15])<=t},E.getTranslation=function(e,r){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("result is required");return r.x=e[12],r.y=e[13],r.z=e[14],r},E.getRotation=function(e,r){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("result is required");return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[4],r[4]=e[5],r[5]=e[6],r[6]=e[8],r[7]=e[9],r[8]=e[10],r};var l=new u,R=new u,T=new r,A=new r(0,0,0,1);return E.inverse=function(e,t){if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("result is required");if(u.equalsEpsilon(E.getRotation(e,l),R,a.EPSILON7)&&r.equals(E.getRow(e,3,T),A))return t[0]=0,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=0,t[11]=0,t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=1,t;var o=e[0],f=e[4],c=e[8],h=e[12],w=e[1],d=e[5],_=e[9],N=e[13],m=e[2],I=e[6],S=e[10],O=e[14],M=e[3],p=e[7],y=e[11],q=e[15],C=S*q,U=O*y,P=I*q,L=O*p,F=I*y,v=S*p,g=m*q,D=O*M,B=m*y,x=S*M,b=m*p,G=I*M,z=C*d+L*_+F*N-(U*d+P*_+v*N),X=U*w+g*_+x*N-(C*w+D*_+B*N),V=P*w+D*d+b*N-(L*w+g*d+G*N),H=v*w+B*d+G*_-(F*w+x*d+b*_),W=U*f+P*c+v*h-(C*f+L*c+F*h),Y=C*o+D*c+B*h-(U*o+g*c+x*h),K=L*o+g*f+G*h-(P*o+D*f+b*h),k=F*o+x*f+b*c-(v*o+B*f+G*c);C=c*N,U=h*_,P=f*N,L=h*d,F=f*_,v=c*d,g=o*N,D=h*w,B=o*_,x=c*w,b=o*d,G=f*w;var Z=C*p+L*y+F*q-(U*p+P*y+v*q),j=U*M+g*y+x*q-(C*M+D*y+B*q),Q=P*M+D*p+b*q-(L*M+g*p+G*q),J=v*M+B*p+G*y-(F*M+x*p+b*y),$=P*S+v*O+U*I-(F*O+C*I+L*S),ee=B*O+C*m+D*S-(g*S+x*O+U*m),re=g*I+G*O+L*m-(b*O+P*m+D*I),te=b*S+F*m+x*I-(B*I+G*S+v*m),ie=o*z+f*X+c*V+h*H;if(Math.abs(ie)<a.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return ie=1/ie,t[0]=z*ie,t[1]=X*ie,t[2]=V*ie,t[3]=H*ie,t[4]=W*ie,t[5]=Y*ie,t[6]=K*ie,t[7]=k*ie,t[8]=Z*ie,t[9]=j*ie,t[10]=Q*ie,t[11]=J*ie,t[12]=$*ie,t[13]=ee*ie,t[14]=re*ie,t[15]=te*ie,t},E.inverseTransformation=function(e,r){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("result is required");var t=e[0],o=e[1],a=e[2],u=e[4],s=e[5],E=e[6],f=e[8],c=e[9],h=e[10],w=e[12],d=e[13],_=e[14],l=-t*w-o*d-a*_,R=-u*w-s*d-E*_,T=-f*w-c*d-h*_;return r[0]=t,r[1]=u,r[2]=f,r[3]=0,r[4]=o,r[5]=s,r[6]=c,r[7]=0,r[8]=a,r[9]=E,r[10]=h,r[11]=0,r[12]=l,r[13]=R,r[14]=T,r[15]=1,r},E.IDENTITY=o(new E(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),E.ZERO=o(new E(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),E.COLUMN0ROW0=0,E.COLUMN0ROW1=1,E.COLUMN0ROW2=2,E.COLUMN0ROW3=3,E.COLUMN1ROW0=4,E.COLUMN1ROW1=5,E.COLUMN1ROW2=6,E.COLUMN1ROW3=7,E.COLUMN2ROW0=8,E.COLUMN2ROW1=9,E.COLUMN2ROW2=10,E.COLUMN2ROW3=11,E.COLUMN3ROW0=12,E.COLUMN3ROW1=13,E.COLUMN3ROW2=14,E.COLUMN3ROW3=15,E.prototype.clone=function(e){return E.clone(this,e)},E.prototype.equals=function(e){return E.equals(this,e)},E.equalsArray=function(e,r,t){return e[0]===r[t]&&e[1]===r[t+1]&&e[2]===r[t+2]&&e[3]===r[t+3]&&e[4]===r[t+4]&&e[5]===r[t+5]&&e[6]===r[t+6]&&e[7]===r[t+7]&&e[8]===r[t+8]&&e[9]===r[t+9]&&e[10]===r[t+10]&&e[11]===r[t+11]&&e[12]===r[t+12]&&e[13]===r[t+13]&&e[14]===r[t+14]&&e[15]===r[t+15]},E.prototype.equalsEpsilon=function(e,r){return E.equalsEpsilon(this,e,r)},E.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},E}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,r,t,i){"use strict";var n=function(i,n){if(!r(i))throw new t("normal is required.");if(!r(n))throw new t("distance is required.");this.normal=e.clone(i),this.distance=n};n.fromPointNormal=function(i,o,a){if(!r(i))throw new t("point is required.");if(!r(o))throw new t("normal is required.");var u=-e.dot(o,i);return r(a)?(e.clone(o,a.normal),a.distance=u,a):new n(o,u)};var o=new e;return n.fromCartesian4=function(i,a){if(!r(i))throw new t("coefficients is required.");var u=e.fromCartesian4(i,o),s=i.w;return r(a)?(e.clone(u,a.normal),a.distance=s,a):new n(u,s)},n.getPointDistance=function(i,n){if(!r(i))throw new t("plane is required.");if(!r(n))throw new t("point is required.");return e.dot(i.normal,n)+i.distance},n.ORIGIN_XY_PLANE=i(new n(e.UNIT_Z,0)),n.ORIGIN_YZ_PLANE=i(new n(e.UNIT_X,0)),n.ORIGIN_ZX_PLANE=i(new n(e.UNIT_Y,0)),n}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,r,t,i,n,o,a,u){"use strict";var s=function(e,t,i,n){this.west=r(e,0),this.south=r(t,0),this.east=r(i,0),this.north=r(n,0)};i(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,i,o){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");o=r(o,0),i[o++]=e.west,i[o++]=e.south,i[o++]=e.east,i[o]=e.north},s.unpack=function(e,i,o){if(!t(e))throw new n("array is required");return i=r(i,0),t(o)||(o=new s),o.west=e[i++],o.south=e[i++],o.east=e[i++],o.north=e[i],o},s.computeWidth=function(e){if(!t(e))throw new n("rectangle is required.");var r=e.east,i=e.west;return i>r&&(r+=u.TWO_PI),r-i},s.computeHeight=function(e){if(!t(e))throw new n("rectangle is required.");return e.north-e.south},s.fromDegrees=function(e,i,n,o,a){return e=u.toRadians(r(e,0)),i=u.toRadians(r(i,0)),n=u.toRadians(r(n,0)),o=u.toRadians(r(o,0)),t(a)?(a.west=e,a.south=i,a.east=n,a.north=o,a):new s(e,i,n,o)},s.fromCartographicArray=function(e,r){if(!t(e))throw new n("cartographics is required.");for(var i=Number.MAX_VALUE,o=-Number.MAX_VALUE,a=Number.MAX_VALUE,u=-Number.MAX_VALUE,E=0,f=e.length;f>E;E++){var c=e[E];i=Math.min(i,c.longitude),o=Math.max(o,c.longitude),a=Math.min(a,c.latitude),u=Math.max(u,c.latitude)}return t(r)?(r.west=i,r.south=a,r.east=o,r.north=u,r):new s(i,a,o,u)},s.clone=function(e,r){return t(e)?t(r)?(r.west=e.west,r.south=e.south,r.east=e.east,r.north=e.north,r):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.west===r.west&&e.south===r.south&&e.east===r.east&&e.north===r.north},s.prototype.equalsEpsilon=function(e,r){if("number"!=typeof r)throw new n("epsilon is required and must be a number.");return t(e)&&Math.abs(this.west-e.west)<=r&&Math.abs(this.south-e.south)<=r&&Math.abs(this.east-e.east)<=r&&Math.abs(this.north-e.north)<=r},s.validate=function(e){if(!t(e))throw new n("rectangle is required");var r=e.north;if("number"!=typeof r)throw new n("north is required to be a number.");if(r<-u.PI_OVER_TWO||r>u.PI_OVER_TWO)throw new n("north must be in the interval [-Pi/2, Pi/2].");var i=e.south;if("number"!=typeof i)throw new n("south is required to be a number.");if(i<-u.PI_OVER_TWO||i>u.PI_OVER_TWO)throw new n("south must be in the interval [-Pi/2, Pi/2].");var o=e.west;if("number"!=typeof o)throw new n("west is required to be a number.");if(o<-Math.PI||o>Math.PI)throw new n("west must be in the interval [-Pi, Pi].");var a=e.east;if("number"!=typeof a)throw new n("east is required to be a number.");if(a<-Math.PI||a>Math.PI)throw new n("east must be in the interval [-Pi, Pi].")},s.southwest=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.west,i.latitude=r.south,i.height=0,i):new e(r.west,r.south)},s.northwest=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.west,i.latitude=r.north,i.height=0,i):new e(r.west,r.north)},s.northeast=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.east,i.latitude=r.north,i.height=0,i):new e(r.east,r.north)},s.southeast=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.east,i.latitude=r.south,i.height=0,i):new e(r.east,r.south)},s.center=function(r,i){if(!t(r))throw new n("rectangle is required");var o=r.east,a=r.west;a>o&&(o+=u.TWO_PI);var s=u.negativePiToPi(.5*(a+o)),E=.5*(r.south+r.north);return t(i)?(i.longitude=s,i.latitude=E,i.height=0,i):new e(s,E)},s.intersection=function(e,r,i){if(!t(e))throw new n("rectangle is required");if(!t(r))throw new n("otherRectangle is required.");var o=e.east,a=e.west,E=r.east,f=r.west;a>o&&E>0?o+=u.TWO_PI:f>E&&o>0&&(E+=u.TWO_PI),a>o&&0>f?f+=u.TWO_PI:f>E&&0>a&&(a+=u.TWO_PI);var c=u.negativePiToPi(Math.max(a,f)),h=u.negativePiToPi(Math.min(o,E));if((e.west<e.east||r.west<r.east)&&c>=h)return void 0;var w=Math.max(e.south,r.south),d=Math.min(e.north,r.north);return w>=d?void 0:t(i)?(i.west=c,i.south=w,i.east=h,i.north=d,i):new s(c,w,h,d)},s.contains=function(e,r){if(!t(e))throw new n("rectangle is required");if(!t(r))throw new n("cartographic is required.");var i=r.longitude,o=r.latitude,a=e.west,s=e.east;return a>s&&(s+=u.TWO_PI,0>i&&(i+=u.TWO_PI)),(i>a||u.equalsEpsilon(i,a,u.EPSILON14))&&(s>i||u.equalsEpsilon(i,s,u.EPSILON14))&&o>=e.south&&o<=e.north};var E=new e;return s.subsample=function(e,i,a,f){if(!t(e))throw new n("rectangle is required");i=r(i,o.WGS84),a=r(a,0),t(f)||(f=[]);var c=0,h=e.north,w=e.south,d=e.east,_=e.west,l=E;l.height=a,l.longitude=_,l.latitude=h,f[c]=i.cartographicToCartesian(l,f[c]),c++,l.longitude=d,f[c]=i.cartographicToCartesian(l,f[c]),c++,l.latitude=w,f[c]=i.cartographicToCartesian(l,f[c]),c++,l.longitude=_,f[c]=i.cartographicToCartesian(l,f[c]),c++,0>h?l.latitude=h:w>0?l.latitude=w:l.latitude=0;for(var R=1;8>R;++R)l.longitude=-Math.PI+R*u.PI_OVER_TWO,s.contains(e,l)&&(f[c]=i.cartographicToCartesian(l,f[c]),c++);return 0===l.latitude&&(l.longitude=_,f[c]=i.cartographicToCartesian(l,f[c]),c++,l.longitude=d,f[c]=i.cartographicToCartesian(l,f[c]),c++),f.length=c,f},s.MAX_VALUE=a(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Plane","./Rectangle"],function(e,r,t,i,n,o,a,u,s,E,f,c,h){
"use strict";var w=function(r,i){this.center=e.clone(t(r,e.ZERO)),this.radius=t(i,0)},d=new e,_=new e,l=new e,R=new e,T=new e,A=new e,N=new e,m=new e,I=new e,S=new e,O=new e,M=new e;w.fromPoints=function(r,t){if(i(t)||(t=new w),!i(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;for(var n=e.clone(r[0],N),o=e.clone(n,d),a=e.clone(n,_),u=e.clone(n,l),s=e.clone(n,R),E=e.clone(n,T),f=e.clone(n,A),c=r.length,h=1;c>h;h++){e.clone(r[h],n);var p=n.x,y=n.y,q=n.z;p<o.x&&e.clone(n,o),p>s.x&&e.clone(n,s),y<a.y&&e.clone(n,a),y>E.y&&e.clone(n,E),q<u.z&&e.clone(n,u),q>f.z&&e.clone(n,f)}var C=e.magnitudeSquared(e.subtract(s,o,m)),U=e.magnitudeSquared(e.subtract(E,a,m)),P=e.magnitudeSquared(e.subtract(f,u,m)),L=o,F=s,v=C;U>v&&(v=U,L=a,F=E),P>v&&(v=P,L=u,F=f);var g=I;g.x=.5*(L.x+F.x),g.y=.5*(L.y+F.y),g.z=.5*(L.z+F.z);var D=e.magnitudeSquared(e.subtract(F,g,m)),B=Math.sqrt(D),x=S;x.x=o.x,x.y=a.y,x.z=u.z;var b=O;b.x=s.x,b.y=E.y,b.z=f.z;var G=e.multiplyByScalar(e.add(x,b,m),.5,M),z=0;for(h=0;c>h;h++){e.clone(r[h],n);var X=e.magnitude(e.subtract(n,G,m));X>z&&(z=X);var V=e.magnitudeSquared(e.subtract(n,g,m));if(V>D){var H=Math.sqrt(V);B=.5*(B+H),D=B*B;var W=H-B;g.x=(B*g.x+W*n.x)/H,g.y=(B*g.y+W*n.y)/H,g.z=(B*g.z+W*n.z)/H}}return z>B?(e.clone(g,t.center),t.radius=B):(e.clone(G,t.center),t.radius=z),t};var p=new u,y=new e,q=new e,C=new r,U=new r;w.fromRectangle2D=function(e,r,t){return w.fromRectangleWithHeights2D(e,r,0,0,t)},w.fromRectangleWithHeights2D=function(r,n,o,a,u){if(i(u)||(u=new w),!i(r))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;n=t(n,p),h.southwest(r,C),C.height=o,h.northeast(r,U),U.height=a;var s=n.project(C,y),E=n.project(U,q),f=E.x-s.x,c=E.y-s.y,d=E.z-s.z;u.radius=.5*Math.sqrt(f*f+c*c+d*d);var _=u.center;return _.x=s.x+.5*f,_.y=s.y+.5*c,_.z=s.z+.5*d,u};var P=[];w.fromRectangle3D=function(e,r,n,o){r=t(r,a.WGS84),n=t(n,0);var u;return i(e)&&(u=h.subsample(e,r,n,P)),w.fromPoints(u,o)},w.fromVertices=function(r,n,a,u){if(i(u)||(u=new w),!i(r)||0===r.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;if(n=t(n,e.ZERO),a=t(a,3),3>a)throw new o("stride must be 3 or greater.");var s=N;s.x=r[0]+n.x,s.y=r[1]+n.y,s.z=r[2]+n.z;for(var E=e.clone(s,d),f=e.clone(s,_),c=e.clone(s,l),h=e.clone(s,R),p=e.clone(s,T),y=e.clone(s,A),q=r.length,C=0;q>C;C+=a){var U=r[C]+n.x,P=r[C+1]+n.y,L=r[C+2]+n.z;s.x=U,s.y=P,s.z=L,U<E.x&&e.clone(s,E),U>h.x&&e.clone(s,h),P<f.y&&e.clone(s,f),P>p.y&&e.clone(s,p),L<c.z&&e.clone(s,c),L>y.z&&e.clone(s,y)}var F=e.magnitudeSquared(e.subtract(h,E,m)),v=e.magnitudeSquared(e.subtract(p,f,m)),g=e.magnitudeSquared(e.subtract(y,c,m)),D=E,B=h,x=F;v>x&&(x=v,D=f,B=p),g>x&&(x=g,D=c,B=y);var b=I;b.x=.5*(D.x+B.x),b.y=.5*(D.y+B.y),b.z=.5*(D.z+B.z);var G=e.magnitudeSquared(e.subtract(B,b,m)),z=Math.sqrt(G),X=S;X.x=E.x,X.y=f.y,X.z=c.z;var V=O;V.x=h.x,V.y=p.y,V.z=y.z;var H=e.multiplyByScalar(e.add(X,V,m),.5,M),W=0;for(C=0;q>C;C+=a){s.x=r[C]+n.x,s.y=r[C+1]+n.y,s.z=r[C+2]+n.z;var Y=e.magnitude(e.subtract(s,H,m));Y>W&&(W=Y);var K=e.magnitudeSquared(e.subtract(s,b,m));if(K>G){var k=Math.sqrt(K);z=.5*(z+k),G=z*z;var Z=k-z;b.x=(z*b.x+Z*s.x)/k,b.y=(z*b.y+Z*s.y)/k,b.z=(z*b.z+Z*s.z)/k}}return W>z?(e.clone(b,u.center),u.radius=z):(e.clone(H,u.center),u.radius=W),u},w.fromCornerPoints=function(r,t,n){if(!i(r)||!i(t))throw new o("corner and oppositeCorner are required.");i(n)||(n=new w);var a=n.center;return e.add(r,t,a),e.multiplyByScalar(a,.5,a),n.radius=e.distance(a,t),n},w.fromEllipsoid=function(r,t){if(!i(r))throw new o("ellipsoid is required.");return i(t)||(t=new w),e.clone(e.ZERO,t.center),t.radius=r.maximumRadius,t};var L=new e;w.fromBoundingSpheres=function(r,t){if(i(t)||(t=new w),!i(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;var n=r.length;if(1===n)return w.clone(r[0],t);if(2===n)return w.union(r[0],r[1],t);for(var o=[],a=0;n>a;a++)o.push(r[a].center);t=w.fromPoints(o,t);var u=t.center,s=t.radius;for(a=0;n>a;a++){var E=r[a];s=Math.max(s,e.distance(u,E.center,L)+E.radius)}return t.radius=s,t},w.clone=function(r,t){return i(r)?i(t)?(t.center=e.clone(r.center,t.center),t.radius=r.radius,t):new w(r.center,r.radius):void 0},w.packedLength=4,w.pack=function(e,r,n){if(!i(e))throw new o("value is required");if(!i(r))throw new o("array is required");n=t(n,0);var a=e.center;r[n++]=a.x,r[n++]=a.y,r[n++]=a.z,r[n]=e.radius},w.unpack=function(e,r,n){if(!i(e))throw new o("array is required");r=t(r,0),i(n)||(n=new w);var a=n.center;return a.x=e[r++],a.y=e[r++],a.z=e[r++],n.radius=e[r],n};var F=new e,v=new e;w.union=function(r,t,n){if(!i(r))throw new o("left is required.");if(!i(t))throw new o("right is required.");i(n)||(n=new w);var a=r.center,u=r.radius,s=t.center,E=t.radius,f=e.subtract(s,a,F),c=e.magnitude(f);if(u>=c+E)return r.clone(n),n;if(E>=c+u)return t.clone(n),n;var h=.5*(u+c+E),d=e.multiplyByScalar(f,(-u+h)/c,v);return e.add(d,a,d),e.clone(d,n.center),n.radius=h,n};var g=new e;w.expand=function(r,t,n){if(!i(r))throw new o("sphere is required.");if(!i(t))throw new o("point is required.");n=w.clone(r,n);var a=e.magnitude(e.subtract(t,n.center,g));return a>n.radius&&(n.radius=a),n},w.intersectPlane=function(r,t){if(!i(r))throw new o("sphere is required.");if(!i(t))throw new o("plane is required.");var n=r.center,a=r.radius,u=t.normal,E=e.dot(u,n)+t.distance;return-a>E?s.OUTSIDE:a>E?s.INTERSECTING:s.INSIDE},w.transform=function(e,r,t){if(!i(e))throw new o("sphere is required.");if(!i(r))throw new o("transform is required.");return i(t)||(t=new w),t.center=f.multiplyByPoint(r,e.center,t.center),t.radius=f.getMaximumScale(r)*e.radius,t};var D=new e;w.distanceSquaredTo=function(r,t){if(!i(r))throw new o("sphere is required.");if(!i(t))throw new o("cartesian is required.");var n=e.subtract(r.center,t,D);return e.magnitudeSquared(n)-r.radius*r.radius},w.transformWithoutScale=function(e,r,t){if(!i(e))throw new o("sphere is required.");if(!i(r))throw new o("transform is required.");return i(t)||(t=new w),t.center=f.multiplyByPoint(r,e.center,t.center),t.radius=e.radius,t};var B=new e;w.computePlaneDistances=function(r,t,n,a){if(!i(r))throw new o("sphere is required.");if(!i(t))throw new o("position is required.");if(!i(n))throw new o("direction is required.");i(a)||(a=new E);var u=e.subtract(r.center,t,B),s=e.dot(n,u);return a.start=s-r.radius,a.stop=s+r.radius,a};for(var x=new e,b=new e,G=new e,z=new e,X=new e,V=new r,H=new Array(8),W=0;8>W;++W)H[W]=new e;var Y=new u;return w.projectTo2D=function(r,n,a){if(!i(r))throw new o("sphere is required.");n=t(n,Y);var u=n.ellipsoid,s=r.center,E=r.radius,f=u.geodeticSurfaceNormal(s,x),c=e.cross(e.UNIT_Z,f,b);e.normalize(c,c);var h=e.cross(f,c,G);e.normalize(h,h),e.multiplyByScalar(f,E,f),e.multiplyByScalar(h,E,h),e.multiplyByScalar(c,E,c);var d=e.negate(h,X),_=e.negate(c,z),l=H,R=l[0];e.add(f,h,R),e.add(R,c,R),R=l[1],e.add(f,h,R),e.add(R,_,R),R=l[2],e.add(f,d,R),e.add(R,_,R),R=l[3],e.add(f,d,R),e.add(R,c,R),e.negate(f,f),R=l[4],e.add(f,h,R),e.add(R,c,R),R=l[5],e.add(f,h,R),e.add(R,_,R),R=l[6],e.add(f,d,R),e.add(R,_,R),R=l[7],e.add(f,d,R),e.add(R,c,R);for(var T=l.length,A=0;T>A;++A){var N=l[A];e.add(s,N,N);var m=u.cartesianToCartographic(N,V);n.project(m,N)}a=w.fromPoints(l,a),s=a.center;var I=s.x,S=s.y,O=s.z;return s.x=O,s.y=I,s.z=S,a},w.isOccluded=function(e,r){if(!i(e))throw new o("sphere is required.");if(!i(r))throw new o("occluder is required.");return!r.isBoundingSphereVisible(e)},w.equals=function(r,t){return r===t||i(r)&&i(t)&&e.equals(r.center,t.center)&&r.radius===t.radius},w.prototype.intersectPlane=function(e){return w.intersectPlane(this,e)},w.prototype.distanceSquaredTo=function(e){return w.distanceSquaredTo(this,e)},w.prototype.computePlaneDistances=function(e,r,t){return w.computePlaneDistances(this,e,r,t)},w.prototype.isOccluded=function(e){return w.isOccluded(this,e)},w.prototype.equals=function(e){return w.equals(this,e)},w.prototype.clone=function(e){return w.clone(this,e)},w}),define("Renderer/WebGLConstants",["../Core/freezeObject"],function(e){"use strict";var r={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return e(r)}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,r){"use strict";var t,i={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},n={};return r(n,{element:{get:function(){return n.supportsFullscreen()?document[i.fullscreenElement]:void 0}},changeEventName:{get:function(){return n.supportsFullscreen()?i.fullscreenchange:void 0}},errorEventName:{get:function(){return n.supportsFullscreen()?i.fullscreenerror:void 0}},enabled:{get:function(){return n.supportsFullscreen()?document[i.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return n.supportsFullscreen()?null!==n.element:void 0}}}),n.supportsFullscreen=function(){if(e(t))return t;t=!1;var r=document.body;if("function"==typeof r.requestFullscreen)return i.requestFullscreen="requestFullscreen",i.exitFullscreen="exitFullscreen",i.fullscreenEnabled="fullscreenEnabled",i.fullscreenElement="fullscreenElement",i.fullscreenchange="fullscreenchange",i.fullscreenerror="fullscreenerror",t=!0;for(var n,o=["webkit","moz","o","ms","khtml"],a=0,u=o.length;u>a;++a){var s=o[a];n=s+"RequestFullscreen","function"==typeof r[n]?(i.requestFullscreen=n,t=!0):(n=s+"RequestFullScreen","function"==typeof r[n]&&(i.requestFullscreen=n,t=!0)),n=s+"ExitFullscreen","function"==typeof document[n]?i.exitFullscreen=n:(n=s+"CancelFullScreen","function"==typeof document[n]&&(i.exitFullscreen=n)),n=s+"FullscreenEnabled",e(document[n])?i.fullscreenEnabled=n:(n=s+"FullScreenEnabled",e(document[n])&&(i.fullscreenEnabled=n)),n=s+"FullscreenElement",e(document[n])?i.fullscreenElement=n:(n=s+"FullScreenElement",e(document[n])&&(i.fullscreenElement=n)),n=s+"fullscreenchange",e(document["on"+n])&&("ms"===s&&(n="MSFullscreenChange"),i.fullscreenchange=n),n=s+"fullscreenerror",e(document["on"+n])&&("ms"===s&&(n="MSFullscreenError"),i.fullscreenerror=n)}return t},n.requestFullscreen=function(e){n.supportsFullscreen()&&e[i.requestFullscreen]()},n.exitFullscreen=function(){n.supportsFullscreen()&&document[i.exitFullscreen]()},n}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,r,t){"use strict";function i(e){for(var r=e.split("."),t=0,i=r.length;i>t;++t)r[t]=parseInt(r[t],10);return r}function n(){if(!r(l)){l=!1;var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(l=!0,R=i(e[1]))}return l}function o(){return n()&&R}function a(){if(!r(T)&&(T=!1,!n()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(T=!0,A=i(e[1]))}return T}function u(){return a()&&A}function s(){if(!r(N)){N=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==e&&(N=!0,m=i(e[1]),m.isNightly=!!e[2])}return N}function E(){return s()&&m}function f(){if(!r(I)){I=!1;var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(I=!0,S=i(e[1]))):"Netscape"===navigator.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(I=!0,S=i(e[1])))}return I}function c(){return f()&&S}function h(){if(!r(O)){O=!1;var e=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(O=!0,M=i(e[1]))}return O}function w(){return r(p)||(p=/Windows/i.test(navigator.appVersion)),p}function d(){return h()&&M}function _(){return r(y)||(y=r(window.PointerEvent)&&(!r(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),y}var l,R,T,A,N,m,I,S,O,M,p,y,q={isChrome:n,chromeVersion:o,isSafari:a,safariVersion:u,isWebkit:s,webkitVersion:E,isInternetExplorer:f,internetExplorerVersion:c,isFirefox:h,firefoxVersion:d,isWindows:w,hardwareConcurrency:e(navigator.hardwareConcurrency,3),supportsPointerEvents:_};return q.supportsFullscreen=function(){return t.supportsFullscreen()},q.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},q.supportsWebWorkers=function(){return"undefined"!=typeof Worker},q}),define("Core/ComponentDatatype",["../Renderer/WebGLConstants","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,r,t,i,n,o){"use strict";if(!n.supportsTypedArrays())return{};var a={BYTE:e.BYTE,UNSIGNED_BYTE:e.UNSIGNED_BYTE,SHORT:e.SHORT,UNSIGNED_SHORT:e.UNSIGNED_SHORT,FLOAT:e.FLOAT,DOUBLE:e.DOUBLE};return a.getSizeInBytes=function(e){if(!t(e))throw new i("value is required.");switch(e){case a.BYTE:return Int8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.SHORT:return Int16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case a.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new i("componentDatatype is not a valid value.")}},a.fromTypedArray=function(e){return e instanceof Int8Array?a.BYTE:e instanceof Uint8Array?a.UNSIGNED_BYTE:e instanceof Int16Array?a.SHORT:e instanceof Uint16Array?a.UNSIGNED_SHORT:e instanceof Float32Array?a.FLOAT:e instanceof Float64Array?a.DOUBLE:void 0},a.validate=function(e){return t(e)&&(e===a.BYTE||e===a.UNSIGNED_BYTE||e===a.SHORT||e===a.UNSIGNED_SHORT||e===a.FLOAT||e===a.DOUBLE)},a.createTypedArray=function(e,r){if(!t(e))throw new i("componentDatatype is required.");if(!t(r))throw new i("valuesOrLength is required.");switch(e){case a.BYTE:return new Int8Array(r);case a.UNSIGNED_BYTE:return new Uint8Array(r);case a.SHORT:return new Int16Array(r);case a.UNSIGNED_SHORT:return new Uint16Array(r);case a.FLOAT:return new Float32Array(r);case a.DOUBLE:return new Float64Array(r);default:throw new i("componentDatatype is not a valid value.")}},a.createArrayBufferView=function(e,n,o,u){if(!t(e))throw new i("componentDatatype is required.");if(!t(n))throw new i("buffer is required.");switch(o=r(o,0),u=r(u,(n.byteLength-o)/a.getSizeInBytes(e)),e){case a.BYTE:return new Int8Array(n,o,u);case a.UNSIGNED_BYTE:return new Uint8Array(n,o,u);case a.SHORT:return new Int16Array(n,o,u);case a.UNSIGNED_SHORT:return new Uint16Array(n,o,u);case a.FLOAT:return new Float32Array(n,o,u);case a.DOUBLE:return new Float64Array(n,o,u);default:throw new i("componentDatatype is not a valid value.")}},o(a)}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var r={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(r)}),define("Core/PrimitiveType",["../Renderer/WebGLConstants","./freezeObject"],function(e,r){"use strict";var t={POINTS:e.POINTS,LINES:e.LINES,LINE_LOOP:e.LINE_LOOP,LINE_STRIP:e.LINE_STRIP,TRIANGLES:e.TRIANGLES,TRIANGLE_STRIP:e.TRIANGLE_STRIP,TRIANGLE_FAN:e.TRIANGLE_FAN,validate:function(e){return e===t.POINTS||e===t.LINES||e===t.LINE_LOOP||e===t.LINE_STRIP||e===t.TRIANGLES||e===t.TRIANGLE_STRIP||e===t.TRIANGLE_FAN}};return r(t)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,r,t,i,n){"use strict";var o=function(o){if(o=e(o,e.EMPTY_OBJECT),!r(o.attributes))throw new t("options.attributes is required.");this.attributes=o.attributes,this.indices=o.indices,this.primitiveType=e(o.primitiveType,n.TRIANGLES),this.boundingSphere=o.boundingSphere,this.geometryType=e(o.geometryType,i.NONE),this.boundingSphereCV=void 0};return o.computeNumberOfVertices=function(e){if(!r(e))throw new t("geometry is required.");var i=-1;for(var n in e.attributes)if(e.attributes.hasOwnProperty(n)&&r(e.attributes[n])&&r(e.attributes[n].values)){var o=e.attributes[n],a=o.values.length/o.componentsPerAttribute;if(i!==a&&-1!==i)throw new t("All attribute lists must have the same number of attributes.");i=a}return i},o}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var i=function(i){if(i=e(i,e.EMPTY_OBJECT),!r(i.componentDatatype))throw new t("options.componentDatatype is required.");if(!r(i.componentsPerAttribute))throw new t("options.componentsPerAttribute is required.");if(i.componentsPerAttribute<1||i.componentsPerAttribute>4)throw new t("options.componentsPerAttribute must be between 1 and 4.");if(!r(i.values))throw new t("options.values is required.");this.componentDatatype=i.componentDatatype,this.componentsPerAttribute=i.componentsPerAttribute,this.normalize=e(i.normalize,!1),this.values=i.values};return i}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var r=function(r){r=e(r,e.EMPTY_OBJECT),this.position=r.position,this.normal=r.normal,this.st=r.st,this.binormal=r.binormal,this.tangent=r.tangent,this.color=r.color};return r}),define("Core/IndexDatatype",["../Renderer/WebGLConstants","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n){"use strict";var o={UNSIGNED_BYTE:e.UNSIGNED_BYTE,UNSIGNED_SHORT:e.UNSIGNED_SHORT,UNSIGNED_INT:e.UNSIGNED_INT};return o.getSizeInBytes=function(e){switch(e){case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},o.validate=function(e){return r(e)&&(e===o.UNSIGNED_BYTE||e===o.UNSIGNED_SHORT||e===o.UNSIGNED_INT)},o.createTypedArray=function(e,i){if(!r(e))throw new t("numberOfVertices is required.");return e>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},o.createTypedArrayFromArrayBuffer=function(e,i,o,a){if(!r(e))throw new t("numberOfVertices is required.");if(!r(i))throw new t("sourceArray is required.");if(!r(o))throw new t("byteOffset is required.");return e>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(i,o,a):new Uint16Array(i,o,a)},i(o)}),define("Core/EllipsoidOutlineGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType"],function(e,r,t,i,n,o,a,u,s,E,f,c,h){"use strict";var w=new r(1,1,1),d=Math.cos,_=Math.sin,l=function(e){e=i(e,i.EMPTY_OBJECT);var t=i(e.radii,w),n=i(e.stackPartitions,10),a=i(e.slicePartitions,8),u=i(e.subdivisions,128);if(1>n)throw new o("options.stackPartitions cannot be less than 1");if(0>a)throw new o("options.slicePartitions cannot be less than 0");if(0>u)throw new o("options.subdivisions must be greater than or equal to zero.");this._radii=r.clone(t),this._stackPartitions=n,this._slicePartitions=a,this._subdivisions=u,this._workerName="createEllipsoidOutlineGeometry"};l.packedLength=r.packedLength+3,l.pack=function(e,t,a){if(!n(e))throw new o("value is required");if(!n(t))throw new o("array is required");a=i(a,0),r.pack(e._radii,t,a),a+=r.packedLength,t[a++]=e._stackPartitions,t[a++]=e._slicePartitions,t[a]=e._subdivisions};var R=new r,T={radii:R,stackPartitions:void 0,slicePartitions:void 0,subdivisions:void 0};return l.unpack=function(e,t,a){if(!n(e))throw new o("array is required");t=i(t,0);var u=r.unpack(e,t,R);t+=r.packedLength;var s=e[t++],E=e[t++],f=e[t++];return n(a)?(a._radii=r.clone(u,a._radii),a._stackPartitions=s,a._slicePartitions=E,a._subdivisions=f,
a):(T.stackPartitions=s,T.slicePartitions=E,T.subdivisions=f,new l(T))},l.createGeometry=function(r){var i,n,o,w,l,R,T=r._radii,A=a.fromCartesian3(T),N=r._stackPartitions,m=r._slicePartitions,I=r._subdivisions,S=I*(N+m-1),O=S-m+2,M=new Float64Array(3*O),p=f.createTypedArray(O,2*S),y=0,q=new Array(I),C=new Array(I);for(i=0;I>i;i++)o=c.TWO_PI*i/I,q[i]=d(o),C[i]=_(o);for(i=1;N>i;i++)for(w=Math.PI*i/N,l=d(w),R=_(w),n=0;I>n;n++)M[y++]=T.x*q[n]*R,M[y++]=T.y*C[n]*R,M[y++]=T.z*l;for(q.length=m,C.length=m,i=0;m>i;i++)o=c.TWO_PI*i/m,q[i]=d(o),C[i]=_(o);for(M[y++]=0,M[y++]=0,M[y++]=T.z,i=1;I>i;i++)for(w=Math.PI*i/I,l=d(w),R=_(w),n=0;m>n;n++)M[y++]=T.x*q[n]*R,M[y++]=T.y*C[n]*R,M[y++]=T.z*l;for(M[y++]=0,M[y++]=0,M[y++]=-T.z,y=0,i=0;N-1>i;++i){var U=i*I;for(n=0;I-1>n;++n)p[y++]=U+n,p[y++]=U+n+1;p[y++]=U+I-1,p[y++]=U}var P=I*(N-1);for(n=1;m+1>n;++n)p[y++]=P,p[y++]=P+n;for(i=0;I-2>i;++i){var L=i*m+1+P,F=(i+1)*m+1+P;for(n=0;m-1>n;++n)p[y++]=F+n,p[y++]=L+n;p[y++]=F+m-1,p[y++]=L+m-1}var v=M.length/3-1;for(n=v-1;n>v-m-1;--n)p[y++]=v,p[y++]=n;var g=new E({position:new s({componentDatatype:t.DOUBLE,componentsPerAttribute:3,values:M})});return new u({attributes:g,indices:p,primitiveType:h.LINES,boundingSphere:e.fromEllipsoid(A)})},l}),define("Core/SphereOutlineGeometry",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./EllipsoidOutlineGeometry"],function(e,r,t,i,n){"use strict";var o=function(t){var i=r(t.radius,1),o=new e(i,i,i),a={radii:o,stackPartitions:t.stackPartitions,slicePartitions:t.slicePartitions,subdivisions:t.subdivisions};this._ellipsoidGeometry=new n(a),this._workerName="createSphereOutlineGeometry"};o.packedLength=n.packedLength,o.pack=function(e,r,o){if(!t(e))throw new i("value is required");n.pack(e._ellipsoidGeometry,r,o)};var a=new n,u={radius:void 0,radii:new e,stackPartitions:void 0,slicePartitions:void 0,subdivisions:void 0};return o.unpack=function(r,i,s){var E=n.unpack(r,i,a);return u.stackPartitions=E._stackPartitions,u.slicePartitions=E._slicePartitions,u.subdivisions=E._subdivisions,t(s)?(e.clone(E._radii,u.radii),s._ellipsoidGeometry=new n(u),s):(u.radius=E._radii.x,new o(u))},o.createGeometry=function(e){return n.createGeometry(e._ellipsoidGeometry)},o}),define("Workers/createSphereOutlineGeometry",["../Core/defined","../Core/SphereOutlineGeometry"],function(e,r){"use strict";return function(t,i){return e(i)&&(t=r.unpack(t,i)),r.createGeometry(t)}})}();