/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var r=Object.freeze;return e(r)||(r=function(e){return e}),r}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var r=function(e,r){return void 0!==e?e:r};return r.EMPTY_OBJECT=e({}),r}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var r=function(e){this.name="DeveloperError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r.throwInstantiationError=function(){throw new r("This function defines an interface and should not be called directly.")},r}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var t;for(this.mti==this.N+1&&this.init_genrand(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^r[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^r[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^r[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.signNotZero=function(e){return 0>e?-1:1},i.toSNorm=function(e){return Math.round(255*(.5*i.clamp(e,-1,1)+.5))},i.fromSNorm=function(e){return i.clamp(e,0,255)/255*2-1},i.sinh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r-t)},i.cosh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r+t)},i.lerp=function(e,r,t){return(1-t)*e+t*r},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=3*Math.PI*.5,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){if(!t(e))throw new n("degrees is required.");return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){if(!t(e))throw new n("radians is required.");return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){if(!t(e))throw new n("angle is required.");var r=i.TWO_PI,a=e-Math.floor(e/r)*r;return a<-Math.PI?a+r:a>=Math.PI?a-r:a},i.negativePiToPi=function(e){if(!t(e))throw new n("x is required.");return i.zeroToTwoPi(e+i.PI)-i.PI},i.zeroToTwoPi=function(e){if(!t(e))throw new n("x is required.");var r=i.mod(e,i.TWO_PI);return Math.abs(r)<i.EPSILON14&&Math.abs(e)>i.EPSILON14?i.TWO_PI:r},i.mod=function(e,r){if(!t(e))throw new n("m is required.");if(!t(r))throw new n("n is required.");return(e%r+r)%r},i.equalsEpsilon=function(e,i,a,o){if(!t(e))throw new n("left is required.");if(!t(i))throw new n("right is required.");if(!t(a))throw new n("relativeEpsilon is required.");o=r(o,a);var u=Math.abs(e-i);return o>=u||u<=a*Math.max(Math.abs(e),Math.abs(i))};var a=[1];i.factorial=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");var r=a.length;if(e>=r)for(var t=a[r-1],i=r;e>=i;i++)a.push(t*i);return a[e]},i.incrementWrap=function(e,i,a){if(a=r(a,0),!t(e))throw new n("n is required.");if(a>=i)throw new n("maximumValue must be greater than minimumValue.");return++e,e>i&&(e=a),e},i.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,r,i){if(!t(e))throw new n("value is required");if(!t(r))throw new n("min is required.");if(!t(i))throw new n("max is required.");return r>e?r:e>i?i:e};var o=new e;return i.setRandomNumberSeed=function(r){if(!t(r))throw new n("seed is required.");o=new e(r)},i.nextRandomNumber=function(){return o.random()},i.acosClamped=function(e){if(!t(e))throw new n("value is required.");return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){if(!t(e))throw new n("value is required.");return Math.asin(i.clamp(e,-1,1))},i.chordLength=function(e,r){if(!t(e))throw new n("angle is required.");if(!t(r))throw new n("radius is required.");return 2*r*Math.sin(.5*e)},i}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t,n){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0)};a.fromSpherical=function(n,i){if(!r(n))throw new t("spherical is required");r(i)||(i=new a);var o=n.clock,u=n.cone,s=e(n.magnitude,1),f=s*Math.sin(u);return i.x=f*Math.cos(o),i.y=f*Math.sin(o),i.z=s*Math.cos(u),i},a.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new a(e,t,n)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new a(e.x,e.y,e.z):void 0},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.x,i[a++]=n.y,i[a]=n.z},a.unpack=function(n,i,o){if(!r(n))throw new t("array is required");return i=e(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i++],o.z=n[i],o},a.fromArray=a.unpack,a.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z)},a.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z)},a.minimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i},a.maximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i},a.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitude(o)},a.distanceSquared=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitudeSquared(o)},a.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=a.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n},a.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z},a.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i},a.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i},a.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i},a.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i},a.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i},a.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n},a.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n};var u=new a;a.lerp=function(e,n,i,o){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(o))throw new t("result is required.");return a.multiplyByScalar(n,i,u),o=a.multiplyByScalar(e,1-i,o),a.add(u,o,o)};var s=new a,f=new a;a.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");a.normalize(e,s),a.normalize(n,f);var i=a.dot(s,f),o=a.magnitude(a.cross(s,f,s));return Math.atan2(o,i)};var c=new a;a.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=a.normalize(e,c);return a.abs(i,i),n=i.x<=i.y?i.x<=i.z?a.clone(a.UNIT_X,n):a.clone(a.UNIT_Z,n):i.y<=i.z?a.clone(a.UNIT_Y,n):a.clone(a.UNIT_Z,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},a.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]&&e.z===r[t+2]},a.equalsEpsilon=function(e,t,n,a){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,a)&&i.equalsEpsilon(e.y,t.y,n,a)&&i.equalsEpsilon(e.z,t.z,n,a)},a.cross=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");var a=e.x,o=e.y,u=e.z,s=n.x,f=n.y,c=n.z,l=o*c-u*f,h=u*s-a*c,d=a*f-o*s;return i.x=l,i.y=h,i.z=d,i},a.fromDegrees=function(e,n,o,u,s){if(!r(e))throw new t("longitude is required");if(!r(n))throw new t("latitude is required");var f=i.toRadians(e),c=i.toRadians(n);return a.fromRadians(f,c,o,u,s)};var l=new a,h=new a,d=new a(40680631590769,40680631590769,40408299984661.445);return a.fromRadians=function(n,i,o,u,s){if(!r(n))throw new t("longitude is required");if(!r(i))throw new t("latitude is required");o=e(o,0);var f=r(u)?u.radiiSquared:d,c=Math.cos(i);l.x=c*Math.cos(n),l.y=c*Math.sin(n),l.z=Math.sin(i),l=a.normalize(l,l),a.multiplyComponents(f,l,h);var w=Math.sqrt(a.dot(l,h));return h=a.divideByScalar(h,w,h),l=a.multiplyByScalar(l,o,l),r(s)||(s=new a),a.add(h,l,s)},a.fromDegreesArray=function(e,n,o){if(!r(e))throw new t("positions is required.");for(var u=new Array(e.length),s=0;s<e.length;s++)u[s]=i.toRadians(e[s]);return a.fromRadiansArray(u,n,o)},a.fromRadiansArray=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<2)throw new t("positions length cannot be less than 2.");if(e.length%2!==0)throw new t("positions length must be a multiple of 2.");var o=e.length;r(i)?i.length=o/2:i=new Array(o/2);for(var u=0;o>u;u+=2){var s=e[u],f=e[u+1];i[u/2]=a.fromRadians(s,f,0,n,i[u/2])}return i},a.fromDegreesArrayHeights=function(e,n,o){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(e.length%3!==0)throw new t("positions length must be a multiple of 3.");for(var u=new Array(e.length),s=0;s<e.length;s+=3)u[s]=i.toRadians(e[s]),u[s+1]=i.toRadians(e[s+1]),u[s+2]=e[s+2];return a.fromRadiansArrayHeights(u,n,o)},a.fromRadiansArrayHeights=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(e.length%3!==0)throw new t("positions length must be a multiple of 3.");var o=e.length;r(i)?i.length=o/3:i=new Array(o/3);for(var u=0;o>u;u+=3){var s=e[u],f=e[u+1],c=e[u+2];i[u/3]=a.fromRadians(s,f,c,n,i[u/3])}return i},a.ZERO=n(new a(0,0,0)),a.UNIT_X=n(new a(1,0,0)),a.UNIT_Y=n(new a(0,1,0)),a.UNIT_Z=n(new a(0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r,t){return a.equalsEpsilon(this,e,r,t)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t,n){this.longitude=e(r,0),this.latitude=e(t,0),this.height=e(n,0)};return a.fromRadians=function(n,i,o,u){if(!r(n))throw new t("longitude is required.");if(!r(i))throw new t("latitude is required.");return o=e(o,0),r(u)?(u.longitude=n,u.latitude=i,u.height=o,u):new a(n,i,o)},a.fromDegrees=function(e,n,o,u){if(!r(e))throw new t("longitude is required.");if(!r(n))throw new t("latitude is required.");return e=i.toRadians(e),n=i.toRadians(n),a.fromRadians(e,n,o,u)},a.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new a(e.longitude,e.latitude,e.height):void 0},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},a.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.longitude-n.longitude)<=i&&Math.abs(e.latitude-n.latitude)<=i&&Math.abs(e.height-n.height)<=i},a.ZERO=n(new a(0,0,0)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r){return a.equalsEpsilon(this,e,r)},a.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},a}),define("Core/defineProperties",["./defined"],function(e){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),t=Object.defineProperties;return r&&e(t)||(t=function(e){return e}),t}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,a,o,u){"use strict";function s(r,n,i,o){if(n=t(n,0),i=t(i,0),o=t(o,0),0>n||0>i||0>o)throw new a("All radii components must be greater than or equal to zero.");r._radii=new e(n,i,o),r._radiiSquared=new e(n*n,i*i,o*o),r._radiiToTheFourth=new e(n*n*n*n,i*i*i*i,o*o*o*o),r._oneOverRadii=new e(0===n?0:1/n,0===i?0:1/i,0===o?0:1/o),r._oneOverRadiiSquared=new e(0===n?0:1/(n*n),0===i?0:1/(i*i),0===o?0:1/(o*o)),r._minimumRadius=Math.min(n,i,o),r._maximumRadius=Math.max(n,i,o),r._centerToleranceSquared=u.EPSILON1}var f=function(e,r,t){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,s(this,e,r,t)};i(f.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),f.clone=function(r,t){if(!n(r))return void 0;var i=r._radii;return n(t)?(e.clone(i,t._radii),e.clone(r._radiiSquared,t._radiiSquared),e.clone(r._radiiToTheFourth,t._radiiToTheFourth),e.clone(r._oneOverRadii,t._oneOverRadii),e.clone(r._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=r._minimumRadius,t._maximumRadius=r._maximumRadius,t._centerToleranceSquared=r._centerToleranceSquared,t):new f(i.x,i.y,i.z)},f.fromCartesian3=function(e,r){return n(r)||(r=new f),n(e)?(s(r,e.x,e.y,e.z),r):r},f.WGS84=o(new f(6378137,6378137,6356752.314245179)),f.UNIT_SPHERE=o(new f(1,1,1)),f.MOON=o(new f(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),f.prototype.clone=function(e){return f.clone(this,e)},f.packedLength=e.packedLength,f.pack=function(r,i,o){if(!n(r))throw new a("value is required");if(!n(i))throw new a("array is required");o=t(o,0),e.pack(r._radii,i,o)},f.unpack=function(r,i,o){if(!n(r))throw new a("array is required");i=t(i,0);var u=e.unpack(r,i);return f.fromCartesian3(u,o)},f.prototype.geocentricSurfaceNormal=e.normalize,f.prototype.geodeticSurfaceNormalCartographic=function(r,t){if(!n(r))throw new a("cartographic is required.");var i=r.longitude,o=r.latitude,u=Math.cos(o),s=u*Math.cos(i),f=u*Math.sin(i),c=Math.sin(o);return n(t)||(t=new e),t.x=s,t.y=f,t.z=c,e.normalize(t,t)},f.prototype.geodeticSurfaceNormal=function(r,t){return n(t)||(t=new e),t=e.multiplyComponents(r,this._oneOverRadiiSquared,t),e.normalize(t,t)};var c=new e,l=new e;f.prototype.cartographicToCartesian=function(r,t){var i=c,a=l;this.geodeticSurfaceNormalCartographic(r,i),e.multiplyComponents(this._radiiSquared,i,a);var o=Math.sqrt(e.dot(i,a));return e.divideByScalar(a,o,a),e.multiplyByScalar(i,r.height,i),n(t)||(t=new e),e.add(a,i,t)},f.prototype.cartographicArrayToCartesianArray=function(e,r){if(!n(e))throw new a("cartographics is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;i++)r[i]=this.cartographicToCartesian(e[i],r[i]);return r};var h=new e,d=new e,w=new e;f.prototype.cartesianToCartographic=function(t,i){var a=this.scaleToGeodeticSurface(t,d);if(!n(a))return void 0;var o=this.geodeticSurfaceNormal(a,h),s=e.subtract(t,a,w),f=Math.atan2(o.y,o.x),c=Math.asin(o.z),l=u.sign(e.dot(s,t))*e.magnitude(s);return n(i)?(i.longitude=f,i.latitude=c,i.height=l,i):new r(f,c,l)},f.prototype.cartesianArrayToCartographicArray=function(e,r){if(!n(e))throw new a("cartesians is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;++i)r[i]=this.cartesianToCartographic(e[i],r[i]);return r};var E=new e,m=new e;return f.prototype.scaleToGeodeticSurface=function(r,t){if(!n(r))throw new a("cartesian is required.");var i=r.x,o=r.y,s=r.z,f=this._oneOverRadii,c=f.x,l=f.y,h=f.z,d=i*i*c*c,w=o*o*l*l,p=s*s*h*h,_=d+w+p,y=Math.sqrt(1/_),R=e.multiplyByScalar(r,y,E);if(_<this._centerToleranceSquared)return isFinite(y)?e.clone(R,t):void 0;var T=this._oneOverRadiiSquared,v=T.x,A=T.y,S=T.z,g=m;g.x=R.x*v*2,g.y=R.y*A*2,g.z=R.z*S*2;var q,N,M,O,I,x,C,P,b,D,U,L=(1-y)*e.magnitude(r)/(.5*e.magnitude(g)),F=0;do{L-=F,M=1/(1+L*v),O=1/(1+L*A),I=1/(1+L*S),x=M*M,C=O*O,P=I*I,b=x*M,D=C*O,U=P*I,q=d*x+w*C+p*P-1,N=d*b*v+w*D*A+p*U*S;var B=-2*N;F=q/B}while(Math.abs(q)>u.EPSILON12);return n(t)?(t.x=i*M,t.y=o*O,t.z=s*I,t):new e(i*M,o*O,s*I)},f.prototype.scaleToGeocentricSurface=function(r,t){if(!n(r))throw new a("cartesian is required.");n(t)||(t=new e);var i=r.x,o=r.y,u=r.z,s=this._oneOverRadiiSquared,f=1/Math.sqrt(i*i*s.x+o*o*s.y+u*u*s.z);return e.multiplyByScalar(r,f,t)},f.prototype.transformPositionToScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._oneOverRadii,t)},f.prototype.transformPositionFromScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._radii,t)},f.prototype.equals=function(r){return this===r||n(r)&&e.equals(this._radii,r._radii)},f.prototype.toString=function(){return this._radii.toString()},f}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,r,t,n,i,a,o,u){"use strict";var s=function(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)};n(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,a){if(!t(e))throw new i("value is required");if(!t(n))throw new i("array is required");a=r(a,0),n[a++]=e.west,n[a++]=e.south,n[a++]=e.east,n[a]=e.north},s.unpack=function(e,n,a){if(!t(e))throw new i("array is required");return n=r(n,0),t(a)||(a=new s),a.west=e[n++],a.south=e[n++],a.east=e[n++],a.north=e[n],a},s.computeWidth=function(e){if(!t(e))throw new i("rectangle is required.");var r=e.east,n=e.west;return n>r&&(r+=u.TWO_PI),r-n},s.computeHeight=function(e){if(!t(e))throw new i("rectangle is required.");return e.north-e.south},s.fromDegrees=function(e,n,i,a,o){return e=u.toRadians(r(e,0)),n=u.toRadians(r(n,0)),i=u.toRadians(r(i,0)),a=u.toRadians(r(a,0)),t(o)?(o.west=e,o.south=n,o.east=i,o.north=a,o):new s(e,n,i,a)},s.fromCartographicArray=function(e,r){if(!t(e))throw new i("cartographics is required.");for(var n=Number.MAX_VALUE,a=-Number.MAX_VALUE,o=Number.MAX_VALUE,u=-Number.MAX_VALUE,f=0,c=e.length;c>f;f++){var l=e[f];n=Math.min(n,l.longitude),a=Math.max(a,l.longitude),o=Math.min(o,l.latitude),u=Math.max(u,l.latitude)}return t(r)?(r.west=n,r.south=o,r.east=a,r.north=u,r):new s(n,o,a,u)},s.clone=function(e,r){return t(e)?t(r)?(r.west=e.west,r.south=e.south,r.east=e.east,r.north=e.north,r):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.west===r.west&&e.south===r.south&&e.east===r.east&&e.north===r.north},s.prototype.equalsEpsilon=function(e,r){if("number"!=typeof r)throw new i("epsilon is required and must be a number.");return t(e)&&Math.abs(this.west-e.west)<=r&&Math.abs(this.south-e.south)<=r&&Math.abs(this.east-e.east)<=r&&Math.abs(this.north-e.north)<=r},s.validate=function(e){if(!t(e))throw new i("rectangle is required");var r=e.north;if("number"!=typeof r)throw new i("north is required to be a number.");if(r<-u.PI_OVER_TWO||r>u.PI_OVER_TWO)throw new i("north must be in the interval [-Pi/2, Pi/2].");var n=e.south;if("number"!=typeof n)throw new i("south is required to be a number.");if(n<-u.PI_OVER_TWO||n>u.PI_OVER_TWO)throw new i("south must be in the interval [-Pi/2, Pi/2].");var a=e.west;if("number"!=typeof a)throw new i("west is required to be a number.");if(a<-Math.PI||a>Math.PI)throw new i("west must be in the interval [-Pi, Pi].");var o=e.east;if("number"!=typeof o)throw new i("east is required to be a number.");if(o<-Math.PI||o>Math.PI)throw new i("east must be in the interval [-Pi, Pi].")},s.southwest=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.west,n.latitude=r.south,n.height=0,n):new e(r.west,r.south)},s.northwest=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.west,n.latitude=r.north,n.height=0,n):new e(r.west,r.north)},s.northeast=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.east,n.latitude=r.north,n.height=0,n):new e(r.east,r.north)},s.southeast=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.east,n.latitude=r.south,n.height=0,n):new e(r.east,r.south)},s.center=function(r,n){if(!t(r))throw new i("rectangle is required");var a=r.east,o=r.west;o>a&&(a+=u.TWO_PI);var s=u.negativePiToPi(.5*(o+a)),f=.5*(r.south+r.north);return t(n)?(n.longitude=s,n.latitude=f,n.height=0,n):new e(s,f)},s.intersection=function(e,r,n){if(!t(e))throw new i("rectangle is required");if(!t(r))throw new i("otherRectangle is required.");var a=e.east,o=e.west,f=r.east,c=r.west;o>a&&f>0?a+=u.TWO_PI:c>f&&a>0&&(f+=u.TWO_PI),o>a&&0>c?c+=u.TWO_PI:c>f&&0>o&&(o+=u.TWO_PI);var l=u.negativePiToPi(Math.max(o,c)),h=u.negativePiToPi(Math.min(a,f));if((e.west<e.east||r.west<r.east)&&l>=h)return void 0;var d=Math.max(e.south,r.south),w=Math.min(e.north,r.north);return d>=w?void 0:t(n)?(n.west=l,n.south=d,n.east=h,n.north=w,n):new s(l,d,h,w)},s.contains=function(e,r){if(!t(e))throw new i("rectangle is required");if(!t(r))throw new i("cartographic is required.");var n=r.longitude,a=r.latitude,o=e.west,s=e.east;return o>s&&(s+=u.TWO_PI,0>n&&(n+=u.TWO_PI)),(n>o||u.equalsEpsilon(n,o,u.EPSILON14))&&(s>n||u.equalsEpsilon(n,s,u.EPSILON14))&&a>=e.south&&a<=e.north};var f=new e;return s.subsample=function(e,n,o,c){if(!t(e))throw new i("rectangle is required");n=r(n,a.WGS84),o=r(o,0),t(c)||(c=[]);var l=0,h=e.north,d=e.south,w=e.east,E=e.west,m=f;m.height=o,m.longitude=E,m.latitude=h,c[l]=n.cartographicToCartesian(m,c[l]),l++,m.longitude=w,c[l]=n.cartographicToCartesian(m,c[l]),l++,m.latitude=d,c[l]=n.cartographicToCartesian(m,c[l]),l++,m.longitude=E,c[l]=n.cartographicToCartesian(m,c[l]),l++,0>h?m.latitude=h:d>0?m.latitude=d:m.latitude=0;for(var p=1;8>p;++p)m.longitude=-Math.PI+p*u.PI_OVER_TWO,s.contains(e,m)&&(c[l]=n.cartographicToCartesian(m,c[l]),l++);return 0===m.latitude&&(m.longitude=E,c[l]=n.cartographicToCartesian(m,c[l]),l++,m.longitude=w,c[l]=n.cartographicToCartesian(m,c[l]),l++),c.length=l,c},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/deprecationWarning",["./defined","./DeveloperError"],function(e,r){"use strict";var t={},n=function(n,i){if(!e(n)||!e(i))throw new r("identifier and message are required.");e(t[n])||(t[n]=!0,console.log(i))};return n}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,r,t,n,i,a,o){"use strict";var u=function(e){this._ellipsoid=t(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(r,t){var i=this._semimajorAxis,a=r.longitude*i,o=r.latitude*i,u=r.height;return n(t)?(t.x=a,t.y=o,t.z=u,t):new e(a,o,u)},u.prototype.unproject=function(e,t){if(!n(e))throw new a("cartesian is required");var i=this._oneOverSemimajorAxis,o=e.x*i,u=e.y*i,s=e.z;return n(t)?(t.longitude=o,t.latitude=u,t.height=s,t):new r(o,u,s)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var r={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(r)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var r=function(r,t){this.start=e(r,0),this.stop=e(t,0)};return r}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t,n,i){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0),this.w=e(i,0)};a.fromElements=function(e,t,n,i,o){return r(o)?(o.x=e,o.y=t,o.z=n,o.w=i,o):new a(e,t,n,i)},a.fromColor=function(e,n){if(!r(e))throw new t("color is required");return r(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new a(e.red,e.green,e.blue,e.alpha)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new a(e.x,e.y,e.z,e.w):void 0},a.packedLength=4,a.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.x,i[a++]=n.y,i[a++]=n.z,i[a]=n.w},a.unpack=function(n,i,o){if(!r(n))throw new t("array is required");return i=e(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i++],o.z=n[i++],o.w=n[i],o},a.fromArray=a.unpack,a.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z,e.w)},a.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z,e.w)},a.minimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i.w=Math.min(e.w,n.w),i},a.maximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i.w=Math.max(e.w,n.w),i},a.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitude(o)},a.distanceSquared=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitudeSquared(o)},a.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=a.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n.w=e.w/i,n},a.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z+e.w*n.w},a.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i.w=e.w*n.w,i},a.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i.w=e.w+n.w,i},a.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i.w=e.w-n.w,i},a.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i.w=e.w*n,i},a.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i.w=e.w/n,i},a.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n.w=-e.w,n},a.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n.w=Math.abs(e.w),n};var u=new a;a.lerp=function(e,n,i,o){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(o))throw new t("result is required.");return a.multiplyByScalar(n,i,u),o=a.multiplyByScalar(e,1-i,o),a.add(u,o,o)};var s=new a;return a.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=a.normalize(e,s);return a.abs(i,i),n=i.x<=i.y?i.x<=i.z?i.x<=i.w?a.clone(a.UNIT_X,n):a.clone(a.UNIT_W,n):i.z<=i.w?a.clone(a.UNIT_Z,n):a.clone(a.UNIT_W,n):i.y<=i.z?i.y<=i.w?a.clone(a.UNIT_Y,n):a.clone(a.UNIT_W,n):i.z<=i.w?a.clone(a.UNIT_Z,n):a.clone(a.UNIT_W,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},a.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]&&e.z===r[t+2]&&e.w===r[t+3]},a.equalsEpsilon=function(e,t,n,a){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,a)&&i.equalsEpsilon(e.y,t.y,n,a)&&i.equalsEpsilon(e.z,t.z,n,a)&&i.equalsEpsilon(e.w,t.w,n,a);
},a.ZERO=n(new a(0,0,0,0)),a.UNIT_X=n(new a(1,0,0,0)),a.UNIT_Y=n(new a(0,1,0,0)),a.UNIT_Z=n(new a(0,0,1,0)),a.UNIT_W=n(new a(0,0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r,t){return a.equalsEpsilon(this,e,r,t)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},a}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,a){"use strict";function o(e){for(var r=0,t=0;9>t;++t){var n=e[t];r+=n*n}return Math.sqrt(r)}function u(e){for(var r=0,t=0;3>t;++t){var n=e[f.getElementIndex(d[t],h[t])];r+=2*n*n}return Math.sqrt(r)}function s(e,r){for(var t=a.EPSILON15,n=0,i=1,o=0;3>o;++o){var u=Math.abs(e[f.getElementIndex(d[o],h[o])]);u>n&&(i=o,n=u)}var s=1,c=0,l=h[i],w=d[i];if(Math.abs(e[f.getElementIndex(w,l)])>t){var E,m=e[f.getElementIndex(w,w)],p=e[f.getElementIndex(l,l)],_=e[f.getElementIndex(w,l)],y=(m-p)/2/_;E=0>y?-1/(-y+Math.sqrt(1+y*y)):1/(y+Math.sqrt(1+y*y)),s=1/Math.sqrt(1+E*E),c=E*s}return r=f.clone(f.IDENTITY,r),r[f.getElementIndex(l,l)]=r[f.getElementIndex(w,w)]=s,r[f.getElementIndex(w,l)]=c,r[f.getElementIndex(l,w)]=-c,r}var f=function(e,t,n,i,a,o,u,s,f){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(a,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(o,0),this[8]=r(f,0)};f.packedLength=9,f.pack=function(e,i,a){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");a=r(a,0),i[a++]=e[0],i[a++]=e[1],i[a++]=e[2],i[a++]=e[3],i[a++]=e[4],i[a++]=e[5],i[a++]=e[6],i[a++]=e[7],i[a++]=e[8]},f.unpack=function(e,i,a){if(!t(e))throw new n("array is required");return i=r(i,0),t(a)||(a=new f),a[0]=e[i++],a[1]=e[i++],a[2]=e[i++],a[3]=e[i++],a[4]=e[i++],a[5]=e[i++],a[6]=e[i++],a[7]=e[i++],a[8]=e[i++],a},f.clone=function(e,r){return t(e)?t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):new f(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},f.fromArray=function(e,i,a){if(!t(e))throw new n("array is required");return i=r(i,0),t(a)||(a=new f),a[0]=e[i],a[1]=e[i+1],a[2]=e[i+2],a[3]=e[i+3],a[4]=e[i+4],a[5]=e[i+5],a[6]=e[i+6],a[7]=e[i+7],a[8]=e[i+8],a},f.fromColumnMajorArray=function(e,r){if(!t(e))throw new n("values parameter is required");return f.clone(e,r)},f.fromRowMajorArray=function(e,r){if(!t(e))throw new n("values is required.");return t(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},f.fromQuaternion=function(e,r){if(!t(e))throw new n("quaternion is required");var i=e.x*e.x,a=e.x*e.y,o=e.x*e.z,u=e.x*e.w,s=e.y*e.y,c=e.y*e.z,l=e.y*e.w,h=e.z*e.z,d=e.z*e.w,w=e.w*e.w,E=i-s-h+w,m=2*(a-d),p=2*(o+l),_=2*(a+d),y=-i+s-h+w,R=2*(c-u),T=2*(o-l),v=2*(c+u),A=-i-s+h+w;return t(r)?(r[0]=E,r[1]=_,r[2]=T,r[3]=m,r[4]=y,r[5]=v,r[6]=p,r[7]=R,r[8]=A,r):new f(E,m,p,_,y,R,T,v,A)},f.fromScale=function(e,r){if(!t(e))throw new n("scale is required.");return t(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new f(e.x,0,0,0,e.y,0,0,0,e.z)},f.fromUniformScale=function(e,r){if("number"!=typeof e)throw new n("scale is required.");return t(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new f(e,0,0,0,e,0,0,0,e)},f.fromCrossProduct=function(e,r){if(!t(e))throw new n("vector is required.");return t(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new f(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},f.fromRotationX=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=a,r[6]=0,r[7]=-a,r[8]=i,r):new f(1,0,0,0,i,-a,0,a,i)},f.fromRotationY=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=i,r[1]=0,r[2]=-a,r[3]=0,r[4]=1,r[5]=0,r[6]=a,r[7]=0,r[8]=i,r):new f(i,0,a,0,1,0,-a,0,i)},f.fromRotationZ=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=i,r[1]=a,r[2]=0,r[3]=-a,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new f(i,-a,0,a,i,0,0,0,1)},f.toArray=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},f.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>2)throw new n("row must be 0, 1, or 2.");if("number"!=typeof e||0>e||e>2)throw new n("column must be 0, 1, or 2.");return 3*e+r},f.getColumn=function(e,r,i){if(!t(e))throw new n("matrix is required.");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(i))throw new n("result is required");var a=3*r,o=e[a],u=e[a+1],s=e[a+2];return i.x=o,i.y=u,i.z=s,i},f.setColumn=function(e,r,i,a){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(a))throw new n("result is required");a=f.clone(e,a);var o=3*r;return a[o]=i.x,a[o+1]=i.y,a[o+2]=i.z,a},f.getRow=function(e,r,i){if(!t(e))throw new n("matrix is required.");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(i))throw new n("result is required");var a=e[r],o=e[r+3],u=e[r+6];return i.x=a,i.y=o,i.z=u,i},f.setRow=function(e,r,i,a){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(a))throw new n("result is required");return a=f.clone(e,a),a[r]=i.x,a[r+3]=i.y,a[r+6]=i.z,a};var c=new e;f.getScale=function(r,i){if(!t(r))throw new n("matrix is required.");if(!t(i))throw new n("result is required");return i.x=e.magnitude(e.fromElements(r[0],r[1],r[2],c)),i.y=e.magnitude(e.fromElements(r[3],r[4],r[5],c)),i.z=e.magnitude(e.fromElements(r[6],r[7],r[8],c)),i};var l=new e;f.getMaximumScale=function(r){return f.getScale(r,l),e.maximumComponent(l)},f.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");var a=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],o=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],u=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],s=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],f=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],c=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],l=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],h=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],d=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return i[0]=a,i[1]=o,i[2]=u,i[3]=s,i[4]=f,i[5]=c,i[6]=l,i[7]=h,i[8]=d,i},f.add=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i[0]=e[0]+r[0],i[1]=e[1]+r[1],i[2]=e[2]+r[2],i[3]=e[3]+r[3],i[4]=e[4]+r[4],i[5]=e[5]+r[5],i[6]=e[6]+r[6],i[7]=e[7]+r[7],i[8]=e[8]+r[8],i},f.subtract=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],i[3]=e[3]-r[3],i[4]=e[4]-r[4],i[5]=e[5]-r[5],i[6]=e[6]-r[6],i[7]=e[7]-r[7],i[8]=e[8]-r[8],i},f.multiplyByVector=function(e,r,i){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("cartesian is required");if(!t(i))throw new n("result is required");var a=r.x,o=r.y,u=r.z,s=e[0]*a+e[3]*o+e[6]*u,f=e[1]*a+e[4]*o+e[7]*u,c=e[2]*a+e[5]*o+e[8]*u;return i.x=s,i.y=f,i.z=c,i},f.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scalar must be a number");if(!t(i))throw new n("result is required");return i[0]=e[0]*r,i[1]=e[1]*r,i[2]=e[2]*r,i[3]=e[3]*r,i[4]=e[4]*r,i[5]=e[5]*r,i[6]=e[6]*r,i[7]=e[7]*r,i[8]=e[8]*r,i},f.multiplyByScale=function(e,r,i){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("scale is required");if(!t(i))throw new n("result is required");return i[0]=e[0]*r.x,i[1]=e[1]*r.x,i[2]=e[2]*r.x,i[3]=e[3]*r.y,i[4]=e[4]*r.y,i[5]=e[5]*r.y,i[6]=e[6]*r.z,i[7]=e[7]*r.z,i[8]=e[8]*r.z,i},f.negate=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");return r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},f.transpose=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");var i=e[0],a=e[3],o=e[6],u=e[1],s=e[4],f=e[7],c=e[2],l=e[5],h=e[8];return r[0]=i,r[1]=a,r[2]=o,r[3]=u,r[4]=s,r[5]=f,r[6]=c,r[7]=l,r[8]=h,r};var h=[1,0,0],d=[2,2,1],w=new f,E=new f;return f.computeEigenDecomposition=function(e,r){if(!t(e))throw new n("matrix is required.");var i=a.EPSILON20,c=10,l=0,h=0;t(r)||(r={});for(var d=r.unitary=f.clone(f.IDENTITY,r.unitary),m=r.diagonal=f.clone(e,r.diagonal),p=i*o(m);c>h&&u(m)>p;)s(m,w),f.transpose(w,E),f.multiply(m,w,m),f.multiply(E,m,m),f.multiply(d,w,d),++l>2&&(++h,l=0);return r},f.abs=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");return r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},f.determinant=function(e){if(!t(e))throw new n("matrix is required");var r=e[0],i=e[3],a=e[6],o=e[1],u=e[4],s=e[7],f=e[2],c=e[5],l=e[8];return r*(u*l-c*s)+o*(c*a-i*l)+f*(i*s-u*a)},f.inverse=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");var i=e[0],o=e[1],u=e[2],s=e[3],c=e[4],l=e[5],h=e[6],d=e[7],w=e[8],E=f.determinant(e);if(Math.abs(E)<=a.EPSILON15)throw new n("matrix is not invertible");r[0]=c*w-d*l,r[1]=d*u-o*w,r[2]=o*l-c*u,r[3]=h*l-s*w,r[4]=i*w-h*u,r[5]=s*u-i*l,r[6]=s*d-h*c,r[7]=h*o-i*d,r[8]=i*c-s*o;var m=1/E;return f.multiplyByScalar(r,m,r)},f.equals=function(e,r){return e===r||t(e)&&t(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]},f.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon must be a number");return e===r||t(e)&&t(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},f.IDENTITY=i(new f(1,0,0,0,1,0,0,0,1)),f.ZERO=i(new f(0,0,0,0,0,0,0,0,0)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN1ROW0=3,f.COLUMN1ROW1=4,f.COLUMN1ROW2=5,f.COLUMN2ROW0=6,f.COLUMN2ROW1=7,f.COLUMN2ROW2=8,f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.equalsArray=function(e,r,t){return e[0]===r[t]&&e[1]===r[t+1]&&e[2]===r[t+2]&&e[3]===r[t+3]&&e[4]===r[t+4]&&e[5]===r[t+5]&&e[6]===r[t+6]&&e[7]===r[t+7]&&e[8]===r[t+8]},f.prototype.equalsEpsilon=function(e,r){return f.equalsEpsilon(this,e,r)},f.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},f}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var r=function(e){this.name="RuntimeError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,r,t,n,i,a,o,u,s){"use strict";var f=function(e,r,n,i,a,o,u,s,f,c,l,h,d,w,E,m){this[0]=t(e,0),this[1]=t(a,0),this[2]=t(f,0),this[3]=t(d,0),this[4]=t(r,0),this[5]=t(o,0),this[6]=t(c,0),this[7]=t(w,0),this[8]=t(n,0),this[9]=t(u,0),this[10]=t(l,0),this[11]=t(E,0),this[12]=t(i,0),this[13]=t(s,0),this[14]=t(h,0),this[15]=t(m,0)};f.packedLength=16,f.pack=function(e,r,a){if(!n(e))throw new i("value is required");if(!n(r))throw new i("array is required");a=t(a,0),r[a++]=e[0],r[a++]=e[1],r[a++]=e[2],r[a++]=e[3],r[a++]=e[4],r[a++]=e[5],r[a++]=e[6],r[a++]=e[7],r[a++]=e[8],r[a++]=e[9],r[a++]=e[10],r[a++]=e[11],r[a++]=e[12],r[a++]=e[13],r[a++]=e[14],r[a]=e[15]},f.unpack=function(e,r,a){if(!n(e))throw new i("array is required");return r=t(r,0),n(a)||(a=new f),a[0]=e[r++],a[1]=e[r++],a[2]=e[r++],a[3]=e[r++],a[4]=e[r++],a[5]=e[r++],a[6]=e[r++],a[7]=e[r++],a[8]=e[r++],a[9]=e[r++],a[10]=e[r++],a[11]=e[r++],a[12]=e[r++],a[13]=e[r++],a[14]=e[r++],a[15]=e[r],a},f.clone=function(e,r){return n(e)?n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):new f(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},f.fromArray=f.unpack,f.fromColumnMajorArray=function(e,r){if(!n(e))throw new i("values is required");return f.clone(e,r)},f.fromRowMajorArray=function(e,r){if(!n(e))throw new i("values is required.");return n(r)?(r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=e[1],r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=e[2],r[9]=e[6],r[10]=e[10],r[11]=e[14],r[12]=e[3],r[13]=e[7],r[14]=e[11],r[15]=e[15],r):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},f.fromRotationTranslation=function(r,a,o){if(!n(r))throw new i("rotation is required.");return a=t(a,e.ZERO),n(o)?(o[0]=r[0],o[1]=r[1],o[2]=r[2],o[3]=0,o[4]=r[3],o[5]=r[4],o[6]=r[5],o[7]=0,o[8]=r[6],o[9]=r[7],o[10]=r[8],o[11]=0,o[12]=a.x,o[13]=a.y,o[14]=a.z,o[15]=1,o):new f(r[0],r[3],r[6],a.x,r[1],r[4],r[7],a.y,r[2],r[5],r[8],a.z,0,0,0,1)},f.fromTranslationQuaternionRotationScale=function(e,r,t,a){if(!n(e))throw new i("translation is required.");if(!n(r))throw new i("rotation is required.");if(!n(t))throw new i("scale is required.");n(a)||(a=new f);var o=t.x,u=t.y,s=t.z,c=r.x*r.x,l=r.x*r.y,h=r.x*r.z,d=r.x*r.w,w=r.y*r.y,E=r.y*r.z,m=r.y*r.w,p=r.z*r.z,_=r.z*r.w,y=r.w*r.w,R=c-w-p+y,T=2*(l-_),v=2*(h+m),A=2*(l+_),S=-c+w-p+y,g=2*(E-d),q=2*(h-m),N=2*(E+d),M=-c-w+p+y;return a[0]=R*o,a[1]=A*o,a[2]=q*o,a[3]=0,a[4]=T*u,a[5]=S*u,a[6]=N*u,a[7]=0,a[8]=v*s,a[9]=g*s,a[10]=M*s,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},f.fromTranslation=function(e,r){if(!n(e))throw new i("translation is required.");return f.fromRotationTranslation(u.IDENTITY,e,r)},f.fromScale=function(e,r){if(!n(e))throw new i("scale is required.");return n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e.y,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e.z,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new f(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},f.fromUniformScale=function(e,r){if("number"!=typeof e)throw new i("scale is required.");return n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new f(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var c=new e,l=new e,h=new e;f.fromCamera=function(r,t){if(!n(r))throw new i("camera is required.");var a=r.eye,o=r.target,u=r.up;if(!n(a))throw new i("camera.eye is required.");if(!n(o))throw new i("camera.target is required.");if(!n(u))throw new i("camera.up is required.");e.normalize(e.subtract(o,a,c),c),e.normalize(e.cross(c,u,l),l),e.normalize(e.cross(l,c,h),h);var s=l.x,d=l.y,w=l.z,E=c.x,m=c.y,p=c.z,_=h.x,y=h.y,R=h.z,T=a.x,v=a.y,A=a.z,S=s*-T+d*-v+w*-A,g=_*-T+y*-v+R*-A,q=E*T+m*v+p*A;return n(t)?(t[0]=s,t[1]=_,t[2]=-E,t[3]=0,t[4]=d,t[5]=y,t[6]=-m,t[7]=0,t[8]=w,t[9]=R,t[10]=-p,t[11]=0,t[12]=S,t[13]=g,t[14]=q,t[15]=1,t):new f(s,d,w,S,_,y,R,g,-E,-m,-p,q,0,0,0,1)},f.computePerspectiveFieldOfView=function(e,r,t,a,o){if(0>=e||e>Math.PI)throw new i("fovY must be in [0, PI).");if(0>=r)throw new i("aspectRatio must be greater than zero.");if(0>=t)throw new i("near must be greater than zero.");if(0>=a)throw new i("far must be greater than zero.");if(!n(o))throw new i("result is required");var u=Math.tan(.5*e),s=1/u,f=s/r,c=(a+t)/(t-a),l=2*a*t/(t-a);return o[0]=f,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=-1,o[12]=0,o[13]=0,o[14]=l,o[15]=0,o},f.computeOrthographicOffCenter=function(e,r,t,a,o,u,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");if(!n(u))throw new i("far is required.");if(!n(s))throw new i("result is required");var f=1/(r-e),c=1/(a-t),l=1/(u-o),h=-(r+e)*f,d=-(a+t)*c,w=-(u+o)*l;return f*=2,c*=2,l*=-2,s[0]=f,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=c,s[6]=0,s[7]=0,s[8]=0,s[9]=0,s[10]=l,s[11]=0,s[12]=h,s[13]=d,s[14]=w,s[15]=1,s},f.computePerspectiveOffCenter=function(e,r,t,a,o,u,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");if(!n(u))throw new i("far is required.");if(!n(s))throw new i("result is required");var f=2*o/(r-e),c=2*o/(a-t),l=(r+e)/(r-e),h=(a+t)/(a-t),d=-(u+o)/(u-o),w=-1,E=-2*u*o/(u-o);return s[0]=f,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=c,s[6]=0,s[7]=0,s[8]=l,s[9]=h,s[10]=d,s[11]=w,s[12]=0,s[13]=0,s[14]=E,s[15]=0,s},f.computeInfinitePerspectiveOffCenter=function(e,r,t,a,o,u){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");if(!n(u))throw new i("result is required");var s=2*o/(r-e),f=2*o/(a-t),c=(r+e)/(r-e),l=(a+t)/(a-t),h=-1,d=-1,w=-2*o;return u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=f,u[6]=0,u[7]=0,u[8]=c,u[9]=l,u[10]=h,u[11]=d,u[12]=0,u[13]=0,u[14]=w,u[15]=0,u},f.computeViewportTransformation=function(e,r,a,o){if(!n(o))throw new i("result is required");e=t(e,t.EMPTY_OBJECT);var u=t(e.x,0),s=t(e.y,0),f=t(e.width,0),c=t(e.height,0);r=t(r,0),a=t(a,1);var l=.5*f,h=.5*c,d=.5*(a-r),w=l,E=h,m=d,p=u+l,_=s+h,y=r+d,R=1;return o[0]=w,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=E,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=m,o[11]=0,o[12]=p,o[13]=_,o[14]=y,o[15]=R,o},f.toArray=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},f.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>3)throw new i("row must be 0, 1, 2, or 3.");if("number"!=typeof e||0>e||e>3)throw new i("column must be 0, 1, 2, or 3.");return 4*e+r},f.getColumn=function(e,r,t){if(!n(e))throw new i("matrix is required.");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(t))throw new i("result is required");var a=4*r,o=e[a],u=e[a+1],s=e[a+2],f=e[a+3];return t.x=o,t.y=u,t.z=s,t.w=f,t},f.setColumn=function(e,r,t,a){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(a))throw new i("result is required");a=f.clone(e,a);var o=4*r;return a[o]=t.x,a[o+1]=t.y,a[o+2]=t.z,a[o+3]=t.w,a},f.setTranslation=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("translation is required");if(!n(t))throw new i("result is required");return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=r.x,t[13]=r.y,t[14]=r.z,t[15]=e[15],t},f.getRow=function(e,r,t){if(!n(e))throw new i("matrix is required.");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(t))throw new i("result is required");var a=e[r],o=e[r+4],u=e[r+8],s=e[r+12];return t.x=a,t.y=o,t.z=u,t.w=s,t},f.setRow=function(e,r,t,a){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(a))throw new i("result is required");return a=f.clone(e,a),a[r]=t.x,a[r+4]=t.y,a[r+8]=t.z,a[r+12]=t.w,a};var d=new e;f.getScale=function(r,t){if(!n(r))throw new i("matrix is required.");if(!n(t))throw new i("result is required");return t.x=e.magnitude(e.fromElements(r[0],r[1],r[2],d)),t.y=e.magnitude(e.fromElements(r[4],r[5],r[6],d)),t.z=e.magnitude(e.fromElements(r[8],r[9],r[10],d)),t};var w=new e;f.getMaximumScale=function(r){return f.getScale(r,w),e.maximumComponent(w)},f.multiply=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");var a=e[0],o=e[1],u=e[2],s=e[3],f=e[4],c=e[5],l=e[6],h=e[7],d=e[8],w=e[9],E=e[10],m=e[11],p=e[12],_=e[13],y=e[14],R=e[15],T=r[0],v=r[1],A=r[2],S=r[3],g=r[4],q=r[5],N=r[6],M=r[7],O=r[8],I=r[9],x=r[10],C=r[11],P=r[12],b=r[13],D=r[14],U=r[15],L=a*T+f*v+d*A+p*S,F=o*T+c*v+w*A+_*S,B=u*T+l*v+E*A+y*S,z=s*T+h*v+m*A+R*S,G=a*g+f*q+d*N+p*M,W=o*g+c*q+w*N+_*M,X=u*g+l*q+E*N+y*M,H=s*g+h*q+m*N+R*M,V=a*O+f*I+d*x+p*C,Y=o*O+c*I+w*x+_*C,j=u*O+l*I+E*x+y*C,k=s*O+h*I+m*x+R*C,Z=a*P+f*b+d*D+p*U,K=o*P+c*b+w*D+_*U,J=u*P+l*b+E*D+y*U,Q=s*P+h*b+m*D+R*U;return t[0]=L,t[1]=F,t[2]=B,t[3]=z,t[4]=G,t[5]=W,t[6]=X,t[7]=H,t[8]=V,t[9]=Y,t[10]=j,t[11]=k,t[12]=Z,t[13]=K,t[14]=J,t[15]=Q,t},f.add=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t[6]=e[6]+r[6],t[7]=e[7]+r[7],t[8]=e[8]+r[8],t[9]=e[9]+r[9],t[10]=e[10]+r[10],t[11]=e[11]+r[11],t[12]=e[12]+r[12],t[13]=e[13]+r[13],t[14]=e[14]+r[14],t[15]=e[15]+r[15],t},f.subtract=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t[4]=e[4]-r[4],t[5]=e[5]-r[5],t[6]=e[6]-r[6],t[7]=e[7]-r[7],t[8]=e[8]-r[8],t[9]=e[9]-r[9],t[10]=e[10]-r[10],t[11]=e[11]-r[11],t[12]=e[12]-r[12],t[13]=e[13]-r[13],t[14]=e[14]-r[14],t[15]=e[15]-r[15],t},f.multiplyTransformation=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");var a=e[0],o=e[1],u=e[2],s=e[4],f=e[5],c=e[6],l=e[8],h=e[9],d=e[10],w=e[12],E=e[13],m=e[14],p=r[0],_=r[1],y=r[2],R=r[4],T=r[5],v=r[6],A=r[8],S=r[9],g=r[10],q=r[12],N=r[13],M=r[14],O=a*p+s*_+l*y,I=o*p+f*_+h*y,x=u*p+c*_+d*y,C=a*R+s*T+l*v,P=o*R+f*T+h*v,b=u*R+c*T+d*v,D=a*A+s*S+l*g,U=o*A+f*S+h*g,L=u*A+c*S+d*g,F=a*q+s*N+l*M+w,B=o*q+f*N+h*M+E,z=u*q+c*N+d*M+m;return t[0]=O,t[1]=I,t[2]=x,t[3]=0,t[4]=C,t[5]=P,t[6]=b,t[7]=0,t[8]=D,t[9]=U,t[10]=L,t[11]=0,t[12]=F,t[13]=B,t[14]=z,t[15]=1,t},f.multiplyByMatrix3=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("rotation is required");if(!n(t))throw new i("result is required");var a=e[0],o=e[1],u=e[2],s=e[4],f=e[5],c=e[6],l=e[8],h=e[9],d=e[10],w=r[0],E=r[1],m=r[2],p=r[3],_=r[4],y=r[5],R=r[6],T=r[7],v=r[8],A=a*w+s*E+l*m,S=o*w+f*E+h*m,g=u*w+c*E+d*m,q=a*p+s*_+l*y,N=o*p+f*_+h*y,M=u*p+c*_+d*y,O=a*R+s*T+l*v,I=o*R+f*T+h*v,x=u*R+c*T+d*v;return t[0]=A,t[1]=S,t[2]=g,t[3]=0,t[4]=q,t[5]=N,t[6]=M,t[7]=0,t[8]=O,t[9]=I,t[10]=x,t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},f.multiplyByTranslation=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("translation is required");if(!n(t))throw new i("result is required");var a=r.x,o=r.y,u=r.z,s=a*e[0]+o*e[4]+u*e[8]+e[12],f=a*e[1]+o*e[5]+u*e[9]+e[13],c=a*e[2]+o*e[6]+u*e[10]+e[14];return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=s,t[13]=f,t[14]=c,t[15]=e[15],t};var E=new e;f.multiplyByUniformScale=function(e,r,t){if(!n(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scale is required");if(!n(t))throw new i("result is required");return E.x=r,E.y=r,E.z=r,f.multiplyByScale(e,E,t)},f.multiplyByScale=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("scale is required");if(!n(t))throw new i("result is required");var a=r.x,o=r.y,u=r.z;return 1===a&&1===o&&1===u?f.clone(e,t):(t[0]=a*e[0],t[1]=a*e[1],t[2]=a*e[2],t[3]=0,t[4]=o*e[4],t[5]=o*e[5],t[6]=o*e[6],t[7]=0,t[8]=u*e[8],t[9]=u*e[9],t[10]=u*e[10],t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=1,t)},f.multiplyByVector=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if(!n(t))throw new i("result is required");var a=r.x,o=r.y,u=r.z,s=r.w,f=e[0]*a+e[4]*o+e[8]*u+e[12]*s,c=e[1]*a+e[5]*o+e[9]*u+e[13]*s,l=e[2]*a+e[6]*o+e[10]*u+e[14]*s,h=e[3]*a+e[7]*o+e[11]*u+e[15]*s;return t.x=f,t.y=c,t.z=l,t.w=h,t},f.multiplyByPointAsVector=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if(!n(t))throw new i("result is required");var a=r.x,o=r.y,u=r.z,s=e[0]*a+e[4]*o+e[8]*u,f=e[1]*a+e[5]*o+e[9]*u,c=e[2]*a+e[6]*o+e[10]*u;return t.x=s,t.y=f,t.z=c,t},f.multiplyByPoint=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if(!n(t))throw new i("result is required");var a=r.x,o=r.y,u=r.z,s=e[0]*a+e[4]*o+e[8]*u+e[12],f=e[1]*a+e[5]*o+e[9]*u+e[13],c=e[2]*a+e[6]*o+e[10]*u+e[14];return t.x=s,t.y=f,t.z=c,t},f.multiplyByScalar=function(e,r,t){if(!n(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scalar must be a number");if(!n(t))throw new i("result is required");return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t},f.negate=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r[9]=-e[9],r[10]=-e[10],r[11]=-e[11],r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=-e[15],r},f.transpose=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");var t=e[1],a=e[2],o=e[3],u=e[6],s=e[7],f=e[11];return r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=t,r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=a,r[9]=u,r[10]=e[10],r[11]=e[14],r[12]=o,r[13]=s,r[14]=f,r[15]=e[15],r},f.abs=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r[9]=Math.abs(e[9]),r[10]=Math.abs(e[10]),r[11]=Math.abs(e[11]),r[12]=Math.abs(e[12]),r[13]=Math.abs(e[13]),r[14]=Math.abs(e[14]),r[15]=Math.abs(e[15]),r},f.equals=function(e,r){return e===r||n(e)&&n(r)&&e[12]===r[12]&&e[13]===r[13]&&e[14]===r[14]&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[8]===r[8]&&e[9]===r[9]&&e[10]===r[10]&&e[3]===r[3]&&e[7]===r[7]&&e[11]===r[11]&&e[15]===r[15]},f.equalsEpsilon=function(e,r,t){if("number"!=typeof t)throw new i("epsilon must be a number");return e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=t&&Math.abs(e[1]-r[1])<=t&&Math.abs(e[2]-r[2])<=t&&Math.abs(e[3]-r[3])<=t&&Math.abs(e[4]-r[4])<=t&&Math.abs(e[5]-r[5])<=t&&Math.abs(e[6]-r[6])<=t&&Math.abs(e[7]-r[7])<=t&&Math.abs(e[8]-r[8])<=t&&Math.abs(e[9]-r[9])<=t&&Math.abs(e[10]-r[10])<=t&&Math.abs(e[11]-r[11])<=t&&Math.abs(e[12]-r[12])<=t&&Math.abs(e[13]-r[13])<=t&&Math.abs(e[14]-r[14])<=t&&Math.abs(e[15]-r[15])<=t},f.getTranslation=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r.x=e[12],r.y=e[13],r.z=e[14],r},f.getRotation=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[4],r[4]=e[5],r[5]=e[6],r[6]=e[8],r[7]=e[9],r[8]=e[10],r};var m=new u,p=new u,_=new r,y=new r(0,0,0,1);return f.inverse=function(e,t){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("result is required");if(u.equalsEpsilon(f.getRotation(e,m),p,o.EPSILON7)&&r.equals(f.getRow(e,3,_),y))return t[0]=0,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=0,t[11]=0,t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=1,t;var a=e[0],c=e[4],l=e[8],h=e[12],d=e[1],w=e[5],E=e[9],R=e[13],T=e[2],v=e[6],A=e[10],S=e[14],g=e[3],q=e[7],N=e[11],M=e[15],O=A*M,I=S*N,x=v*M,C=S*q,P=v*N,b=A*q,D=T*M,U=S*g,L=T*N,F=A*g,B=T*q,z=v*g,G=O*w+C*E+P*R-(I*w+x*E+b*R),W=I*d+D*E+F*R-(O*d+U*E+L*R),X=x*d+U*w+B*R-(C*d+D*w+z*R),H=b*d+L*w+z*E-(P*d+F*w+B*E),V=I*c+x*l+b*h-(O*c+C*l+P*h),Y=O*a+U*l+L*h-(I*a+D*l+F*h),j=C*a+D*c+z*h-(x*a+U*c+B*h),k=P*a+F*c+B*l-(b*a+L*c+z*l);O=l*R,I=h*E,x=c*R,C=h*w,P=c*E,b=l*w,D=a*R,U=h*d,L=a*E,F=l*d,B=a*w,z=c*d;var Z=O*q+C*N+P*M-(I*q+x*N+b*M),K=I*g+D*N+F*M-(O*g+U*N+L*M),J=x*g+U*q+B*M-(C*g+D*q+z*M),Q=b*g+L*q+z*N-(P*g+F*q+B*N),$=x*A+b*S+I*v-(P*S+O*v+C*A),ee=L*S+O*T+U*A-(D*A+F*S+I*T),re=D*v+z*S+C*T-(B*S+x*T+U*v),te=B*A+P*T+F*v-(L*v+z*A+b*T),ne=a*G+c*W+l*X+h*H;if(Math.abs(ne)<o.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return ne=1/ne,t[0]=G*ne,t[1]=W*ne,t[2]=X*ne,t[3]=H*ne,t[4]=V*ne,t[5]=Y*ne,t[6]=j*ne,t[7]=k*ne,t[8]=Z*ne,t[9]=K*ne,t[10]=J*ne,t[11]=Q*ne,t[12]=$*ne,t[13]=ee*ne,t[14]=re*ne,t[15]=te*ne,t},f.inverseTransformation=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");var t=e[0],a=e[1],o=e[2],u=e[4],s=e[5],f=e[6],c=e[8],l=e[9],h=e[10],d=e[12],w=e[13],E=e[14],m=-t*d-a*w-o*E,p=-u*d-s*w-f*E,_=-c*d-l*w-h*E;return r[0]=t,r[1]=u,r[2]=c,r[3]=0,r[4]=a,r[5]=s,r[6]=l,r[7]=0,r[8]=o,r[9]=f,r[10]=h,r[11]=0,r[12]=m,r[13]=p,r[14]=_,r[15]=1,r},f.IDENTITY=a(new f(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),f.ZERO=a(new f(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN0ROW3=3,f.COLUMN1ROW0=4,f.COLUMN1ROW1=5,f.COLUMN1ROW2=6,f.COLUMN1ROW3=7,f.COLUMN2ROW0=8,f.COLUMN2ROW1=9,f.COLUMN2ROW2=10,f.COLUMN2ROW3=11,f.COLUMN3ROW0=12,f.COLUMN3ROW1=13,f.COLUMN3ROW2=14,f.COLUMN3ROW3=15,f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.equalsArray=function(e,r,t){return e[0]===r[t]&&e[1]===r[t+1]&&e[2]===r[t+2]&&e[3]===r[t+3]&&e[4]===r[t+4]&&e[5]===r[t+5]&&e[6]===r[t+6]&&e[7]===r[t+7]&&e[8]===r[t+8]&&e[9]===r[t+9]&&e[10]===r[t+10]&&e[11]===r[t+11]&&e[12]===r[t+12]&&e[13]===r[t+13]&&e[14]===r[t+14]&&e[15]===r[t+15]},f.prototype.equalsEpsilon=function(e,r){return f.equalsEpsilon(this,e,r)},f.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},f}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,r,t,n){"use strict";var i=function(n,i){if(!r(n))throw new t("normal is required.");if(!r(i))throw new t("distance is required.");this.normal=e.clone(n),this.distance=i};i.fromPointNormal=function(n,a,o){if(!r(n))throw new t("point is required.");if(!r(a))throw new t("normal is required.");var u=-e.dot(a,n);return r(o)?(e.clone(a,o.normal),o.distance=u,o):new i(a,u)};var a=new e;return i.fromCartesian4=function(n,o){if(!r(n))throw new t("coefficients is required.");var u=e.fromCartesian4(n,a),s=n.w;return r(o)?(e.clone(u,o.normal),o.distance=s,o):new i(u,s)},i.getPointDistance=function(n,i){if(!r(n))throw new t("plane is required.");if(!r(i))throw new t("point is required.");return e.dot(n.normal,i)+n.distance},i.ORIGIN_XY_PLANE=n(new i(e.UNIT_Z,0)),i.ORIGIN_YZ_PLANE=n(new i(e.UNIT_X,0)),i.ORIGIN_ZX_PLANE=n(new i(e.UNIT_Y,0)),i}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Plane","./Rectangle"],function(e,r,t,n,i,a,o,u,s,f,c,l,h){
"use strict";var d=function(r,n){this.center=e.clone(t(r,e.ZERO)),this.radius=t(n,0)},w=new e,E=new e,m=new e,p=new e,_=new e,y=new e,R=new e,T=new e,v=new e,A=new e,S=new e,g=new e;d.fromPoints=function(r,t){if(n(t)||(t=new d),!n(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;for(var i=e.clone(r[0],R),a=e.clone(i,w),o=e.clone(i,E),u=e.clone(i,m),s=e.clone(i,p),f=e.clone(i,_),c=e.clone(i,y),l=r.length,h=1;l>h;h++){e.clone(r[h],i);var q=i.x,N=i.y,M=i.z;q<a.x&&e.clone(i,a),q>s.x&&e.clone(i,s),N<o.y&&e.clone(i,o),N>f.y&&e.clone(i,f),M<u.z&&e.clone(i,u),M>c.z&&e.clone(i,c)}var O=e.magnitudeSquared(e.subtract(s,a,T)),I=e.magnitudeSquared(e.subtract(f,o,T)),x=e.magnitudeSquared(e.subtract(c,u,T)),C=a,P=s,b=O;I>b&&(b=I,C=o,P=f),x>b&&(b=x,C=u,P=c);var D=v;D.x=.5*(C.x+P.x),D.y=.5*(C.y+P.y),D.z=.5*(C.z+P.z);var U=e.magnitudeSquared(e.subtract(P,D,T)),L=Math.sqrt(U),F=A;F.x=a.x,F.y=o.y,F.z=u.z;var B=S;B.x=s.x,B.y=f.y,B.z=c.z;var z=e.multiplyByScalar(e.add(F,B,T),.5,g),G=0;for(h=0;l>h;h++){e.clone(r[h],i);var W=e.magnitude(e.subtract(i,z,T));W>G&&(G=W);var X=e.magnitudeSquared(e.subtract(i,D,T));if(X>U){var H=Math.sqrt(X);L=.5*(L+H),U=L*L;var V=H-L;D.x=(L*D.x+V*i.x)/H,D.y=(L*D.y+V*i.y)/H,D.z=(L*D.z+V*i.z)/H}}return G>L?(e.clone(D,t.center),t.radius=L):(e.clone(z,t.center),t.radius=G),t};var q=new u,N=new e,M=new e,O=new r,I=new r;d.fromRectangle2D=function(e,r,t){return d.fromRectangleWithHeights2D(e,r,0,0,t)},d.fromRectangleWithHeights2D=function(r,i,a,o,u){if(n(u)||(u=new d),!n(r))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;i=t(i,q),h.southwest(r,O),O.height=a,h.northeast(r,I),I.height=o;var s=i.project(O,N),f=i.project(I,M),c=f.x-s.x,l=f.y-s.y,w=f.z-s.z;u.radius=.5*Math.sqrt(c*c+l*l+w*w);var E=u.center;return E.x=s.x+.5*c,E.y=s.y+.5*l,E.z=s.z+.5*w,u};var x=[];d.fromRectangle3D=function(e,r,i,a){r=t(r,o.WGS84),i=t(i,0);var u;return n(e)&&(u=h.subsample(e,r,i,x)),d.fromPoints(u,a)},d.fromVertices=function(r,i,o,u){if(n(u)||(u=new d),!n(r)||0===r.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;if(i=t(i,e.ZERO),o=t(o,3),3>o)throw new a("stride must be 3 or greater.");var s=R;s.x=r[0]+i.x,s.y=r[1]+i.y,s.z=r[2]+i.z;for(var f=e.clone(s,w),c=e.clone(s,E),l=e.clone(s,m),h=e.clone(s,p),q=e.clone(s,_),N=e.clone(s,y),M=r.length,O=0;M>O;O+=o){var I=r[O]+i.x,x=r[O+1]+i.y,C=r[O+2]+i.z;s.x=I,s.y=x,s.z=C,I<f.x&&e.clone(s,f),I>h.x&&e.clone(s,h),x<c.y&&e.clone(s,c),x>q.y&&e.clone(s,q),C<l.z&&e.clone(s,l),C>N.z&&e.clone(s,N)}var P=e.magnitudeSquared(e.subtract(h,f,T)),b=e.magnitudeSquared(e.subtract(q,c,T)),D=e.magnitudeSquared(e.subtract(N,l,T)),U=f,L=h,F=P;b>F&&(F=b,U=c,L=q),D>F&&(F=D,U=l,L=N);var B=v;B.x=.5*(U.x+L.x),B.y=.5*(U.y+L.y),B.z=.5*(U.z+L.z);var z=e.magnitudeSquared(e.subtract(L,B,T)),G=Math.sqrt(z),W=A;W.x=f.x,W.y=c.y,W.z=l.z;var X=S;X.x=h.x,X.y=q.y,X.z=N.z;var H=e.multiplyByScalar(e.add(W,X,T),.5,g),V=0;for(O=0;M>O;O+=o){s.x=r[O]+i.x,s.y=r[O+1]+i.y,s.z=r[O+2]+i.z;var Y=e.magnitude(e.subtract(s,H,T));Y>V&&(V=Y);var j=e.magnitudeSquared(e.subtract(s,B,T));if(j>z){var k=Math.sqrt(j);G=.5*(G+k),z=G*G;var Z=k-G;B.x=(G*B.x+Z*s.x)/k,B.y=(G*B.y+Z*s.y)/k,B.z=(G*B.z+Z*s.z)/k}}return V>G?(e.clone(B,u.center),u.radius=G):(e.clone(H,u.center),u.radius=V),u},d.fromCornerPoints=function(r,t,i){if(!n(r)||!n(t))throw new a("corner and oppositeCorner are required.");n(i)||(i=new d);var o=i.center;return e.add(r,t,o),e.multiplyByScalar(o,.5,o),i.radius=e.distance(o,t),i},d.fromEllipsoid=function(r,t){if(!n(r))throw new a("ellipsoid is required.");return n(t)||(t=new d),e.clone(e.ZERO,t.center),t.radius=r.maximumRadius,t};var C=new e;d.fromBoundingSpheres=function(r,t){if(n(t)||(t=new d),!n(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;var i=r.length;if(1===i)return d.clone(r[0],t);if(2===i)return d.union(r[0],r[1],t);for(var a=[],o=0;i>o;o++)a.push(r[o].center);t=d.fromPoints(a,t);var u=t.center,s=t.radius;for(o=0;i>o;o++){var f=r[o];s=Math.max(s,e.distance(u,f.center,C)+f.radius)}return t.radius=s,t},d.clone=function(r,t){return n(r)?n(t)?(t.center=e.clone(r.center,t.center),t.radius=r.radius,t):new d(r.center,r.radius):void 0},d.packedLength=4,d.pack=function(e,r,i){if(!n(e))throw new a("value is required");if(!n(r))throw new a("array is required");i=t(i,0);var o=e.center;r[i++]=o.x,r[i++]=o.y,r[i++]=o.z,r[i]=e.radius},d.unpack=function(e,r,i){if(!n(e))throw new a("array is required");r=t(r,0),n(i)||(i=new d);var o=i.center;return o.x=e[r++],o.y=e[r++],o.z=e[r++],i.radius=e[r],i};var P=new e,b=new e;d.union=function(r,t,i){if(!n(r))throw new a("left is required.");if(!n(t))throw new a("right is required.");n(i)||(i=new d);var o=r.center,u=r.radius,s=t.center,f=t.radius,c=e.subtract(s,o,P),l=e.magnitude(c);if(u>=l+f)return r.clone(i),i;if(f>=l+u)return t.clone(i),i;var h=.5*(u+l+f),w=e.multiplyByScalar(c,(-u+h)/l,b);return e.add(w,o,w),e.clone(w,i.center),i.radius=h,i};var D=new e;d.expand=function(r,t,i){if(!n(r))throw new a("sphere is required.");if(!n(t))throw new a("point is required.");i=d.clone(r,i);var o=e.magnitude(e.subtract(t,i.center,D));return o>i.radius&&(i.radius=o),i},d.intersectPlane=function(r,t){if(!n(r))throw new a("sphere is required.");if(!n(t))throw new a("plane is required.");var i=r.center,o=r.radius,u=t.normal,f=e.dot(u,i)+t.distance;return-o>f?s.OUTSIDE:o>f?s.INTERSECTING:s.INSIDE},d.transform=function(e,r,t){if(!n(e))throw new a("sphere is required.");if(!n(r))throw new a("transform is required.");return n(t)||(t=new d),t.center=c.multiplyByPoint(r,e.center,t.center),t.radius=c.getMaximumScale(r)*e.radius,t};var U=new e;d.distanceSquaredTo=function(r,t){if(!n(r))throw new a("sphere is required.");if(!n(t))throw new a("cartesian is required.");var i=e.subtract(r.center,t,U);return e.magnitudeSquared(i)-r.radius*r.radius},d.transformWithoutScale=function(e,r,t){if(!n(e))throw new a("sphere is required.");if(!n(r))throw new a("transform is required.");return n(t)||(t=new d),t.center=c.multiplyByPoint(r,e.center,t.center),t.radius=e.radius,t};var L=new e;d.computePlaneDistances=function(r,t,i,o){if(!n(r))throw new a("sphere is required.");if(!n(t))throw new a("position is required.");if(!n(i))throw new a("direction is required.");n(o)||(o=new f);var u=e.subtract(r.center,t,L),s=e.dot(i,u);return o.start=s-r.radius,o.stop=s+r.radius,o};for(var F=new e,B=new e,z=new e,G=new e,W=new e,X=new r,H=new Array(8),V=0;8>V;++V)H[V]=new e;var Y=new u;return d.projectTo2D=function(r,i,o){if(!n(r))throw new a("sphere is required.");i=t(i,Y);var u=i.ellipsoid,s=r.center,f=r.radius,c=u.geodeticSurfaceNormal(s,F),l=e.cross(e.UNIT_Z,c,B);e.normalize(l,l);var h=e.cross(c,l,z);e.normalize(h,h),e.multiplyByScalar(c,f,c),e.multiplyByScalar(h,f,h),e.multiplyByScalar(l,f,l);var w=e.negate(h,W),E=e.negate(l,G),m=H,p=m[0];e.add(c,h,p),e.add(p,l,p),p=m[1],e.add(c,h,p),e.add(p,E,p),p=m[2],e.add(c,w,p),e.add(p,E,p),p=m[3],e.add(c,w,p),e.add(p,l,p),e.negate(c,c),p=m[4],e.add(c,h,p),e.add(p,l,p),p=m[5],e.add(c,h,p),e.add(p,E,p),p=m[6],e.add(c,w,p),e.add(p,E,p),p=m[7],e.add(c,w,p),e.add(p,l,p);for(var _=m.length,y=0;_>y;++y){var R=m[y];e.add(s,R,R);var T=u.cartesianToCartographic(R,X);i.project(T,R)}o=d.fromPoints(m,o),s=o.center;var v=s.x,A=s.y,S=s.z;return s.x=S,s.y=v,s.z=A,o},d.isOccluded=function(e,r){if(!n(e))throw new a("sphere is required.");if(!n(r))throw new a("occluder is required.");return!r.isBoundingSphereVisible(e)},d.equals=function(r,t){return r===t||n(r)&&n(t)&&e.equals(r.center,t.center)&&r.radius===t.radius},d.prototype.intersectPlane=function(e){return d.intersectPlane(this,e)},d.prototype.distanceSquaredTo=function(e){return d.distanceSquaredTo(this,e)},d.prototype.computePlaneDistances=function(e,r,t){return d.computePlaneDistances(this,e,r,t)},d.prototype.isOccluded=function(e){return d.isOccluded(this,e)},d.prototype.equals=function(e){return d.equals(this,e)},d.prototype.clone=function(e){return d.clone(this,e)},d}),define("Renderer/WebGLConstants",["../Core/freezeObject"],function(e){"use strict";var r={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return e(r)}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,r){"use strict";var t,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return r(i,{element:{get:function(){return i.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(t))return t;t=!1;var r=document.body;if("function"==typeof r.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",t=!0;for(var i,a=["webkit","moz","o","ms","khtml"],o=0,u=a.length;u>o;++o){var s=a[o];i=s+"RequestFullscreen","function"==typeof r[i]?(n.requestFullscreen=i,t=!0):(i=s+"RequestFullScreen","function"==typeof r[i]&&(n.requestFullscreen=i,t=!0)),i=s+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=s+"FullscreenEnabled",e(document[i])?n.fullscreenEnabled=i:(i=s+"FullScreenEnabled",e(document[i])&&(n.fullscreenEnabled=i)),i=s+"FullscreenElement",e(document[i])?n.fullscreenElement=i:(i=s+"FullScreenElement",e(document[i])&&(n.fullscreenElement=i)),i=s+"fullscreenchange",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=s+"fullscreenerror",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenError"),n.fullscreenerror=i)}return t},i.requestFullscreen=function(e){i.supportsFullscreen()&&e[n.requestFullscreen]()},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,r,t){"use strict";function n(e){for(var r=e.split("."),t=0,n=r.length;n>t;++t)r[t]=parseInt(r[t],10);return r}function i(){if(!r(m)){m=!1;var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(m=!0,p=n(e[1]))}return m}function a(){return i()&&p}function o(){if(!r(_)&&(_=!1,!i()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(_=!0,y=n(e[1]))}return _}function u(){return o()&&y}function s(){if(!r(R)){R=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==e&&(R=!0,T=n(e[1]),T.isNightly=!!e[2])}return R}function f(){return s()&&T}function c(){if(!r(v)){v=!1;var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(v=!0,A=n(e[1]))):"Netscape"===navigator.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(v=!0,A=n(e[1])))}return v}function l(){return c()&&A}function h(){if(!r(S)){S=!1;var e=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(S=!0,g=n(e[1]))}return S}function d(){return r(q)||(q=/Windows/i.test(navigator.appVersion)),q}function w(){return h()&&g}function E(){return r(N)||(N=r(window.PointerEvent)&&(!r(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),N}var m,p,_,y,R,T,v,A,S,g,q,N,M={isChrome:i,chromeVersion:a,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:f,isInternetExplorer:c,internetExplorerVersion:l,isFirefox:h,firefoxVersion:w,isWindows:d,hardwareConcurrency:e(navigator.hardwareConcurrency,3),supportsPointerEvents:E};return M.supportsFullscreen=function(){return t.supportsFullscreen()},M.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},M.supportsWebWorkers=function(){return"undefined"!=typeof Worker},M}),define("Core/ComponentDatatype",["../Renderer/WebGLConstants","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,r,t,n,i,a){"use strict";if(!i.supportsTypedArrays())return{};var o={BYTE:e.BYTE,UNSIGNED_BYTE:e.UNSIGNED_BYTE,SHORT:e.SHORT,UNSIGNED_SHORT:e.UNSIGNED_SHORT,FLOAT:e.FLOAT,DOUBLE:e.DOUBLE};return o.getSizeInBytes=function(e){if(!t(e))throw new n("value is required.");switch(e){case o.BYTE:return Int8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.SHORT:return Int16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case o.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new n("componentDatatype is not a valid value.")}},o.fromTypedArray=function(e){return e instanceof Int8Array?o.BYTE:e instanceof Uint8Array?o.UNSIGNED_BYTE:e instanceof Int16Array?o.SHORT:e instanceof Uint16Array?o.UNSIGNED_SHORT:e instanceof Float32Array?o.FLOAT:e instanceof Float64Array?o.DOUBLE:void 0},o.validate=function(e){return t(e)&&(e===o.BYTE||e===o.UNSIGNED_BYTE||e===o.SHORT||e===o.UNSIGNED_SHORT||e===o.FLOAT||e===o.DOUBLE)},o.createTypedArray=function(e,r){if(!t(e))throw new n("componentDatatype is required.");if(!t(r))throw new n("valuesOrLength is required.");switch(e){case o.BYTE:return new Int8Array(r);case o.UNSIGNED_BYTE:return new Uint8Array(r);case o.SHORT:return new Int16Array(r);case o.UNSIGNED_SHORT:return new Uint16Array(r);case o.FLOAT:return new Float32Array(r);case o.DOUBLE:return new Float64Array(r);default:throw new n("componentDatatype is not a valid value.")}},o.createArrayBufferView=function(e,i,a,u){if(!t(e))throw new n("componentDatatype is required.");if(!t(i))throw new n("buffer is required.");switch(a=r(a,0),u=r(u,(i.byteLength-a)/o.getSizeInBytes(e)),e){case o.BYTE:return new Int8Array(i,a,u);case o.UNSIGNED_BYTE:return new Uint8Array(i,a,u);case o.SHORT:return new Int16Array(i,a,u);case o.UNSIGNED_SHORT:return new Uint16Array(i,a,u);case o.FLOAT:return new Float32Array(i,a,u);case o.DOUBLE:return new Float64Array(i,a,u);default:throw new n("componentDatatype is not a valid value.")}},a(o)}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var r={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(r)}),define("Core/PrimitiveType",["../Renderer/WebGLConstants","./freezeObject"],function(e,r){"use strict";var t={POINTS:e.POINTS,LINES:e.LINES,LINE_LOOP:e.LINE_LOOP,LINE_STRIP:e.LINE_STRIP,TRIANGLES:e.TRIANGLES,TRIANGLE_STRIP:e.TRIANGLE_STRIP,TRIANGLE_FAN:e.TRIANGLE_FAN,validate:function(e){return e===t.POINTS||e===t.LINES||e===t.LINE_LOOP||e===t.LINE_STRIP||e===t.TRIANGLES||e===t.TRIANGLE_STRIP||e===t.TRIANGLE_FAN}};return r(t)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,r,t,n,i){"use strict";var a=function(a){if(a=e(a,e.EMPTY_OBJECT),!r(a.attributes))throw new t("options.attributes is required.");this.attributes=a.attributes,this.indices=a.indices,this.primitiveType=e(a.primitiveType,i.TRIANGLES),this.boundingSphere=a.boundingSphere,this.geometryType=e(a.geometryType,n.NONE),this.boundingSphereCV=void 0};return a.computeNumberOfVertices=function(e){if(!r(e))throw new t("geometry is required.");var n=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&r(e.attributes[i])&&r(e.attributes[i].values)){var a=e.attributes[i],o=a.values.length/a.componentsPerAttribute;if(n!==o&&-1!==n)throw new t("All attribute lists must have the same number of attributes.");n=o}return n},a}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.componentDatatype))throw new t("options.componentDatatype is required.");if(!r(n.componentsPerAttribute))throw new t("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new t("options.componentsPerAttribute must be between 1 and 4.");if(!r(n.values))throw new t("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values};return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var r=function(r){r=e(r,e.EMPTY_OBJECT),this.position=r.position,this.normal=r.normal,this.st=r.st,this.binormal=r.binormal,this.tangent=r.tangent,this.color=r.color};return r}),define("Core/IndexDatatype",["../Renderer/WebGLConstants","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a={UNSIGNED_BYTE:e.UNSIGNED_BYTE,UNSIGNED_SHORT:e.UNSIGNED_SHORT,UNSIGNED_INT:e.UNSIGNED_INT};return a.getSizeInBytes=function(e){switch(e){case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},a.validate=function(e){return r(e)&&(e===a.UNSIGNED_BYTE||e===a.UNSIGNED_SHORT||e===a.UNSIGNED_INT)},a.createTypedArray=function(e,n){if(!r(e))throw new t("numberOfVertices is required.");return e>=i.SIXTY_FOUR_KILOBYTES?new Uint32Array(n):new Uint16Array(n)},a.createTypedArrayFromArrayBuffer=function(e,n,a,o){if(!r(e))throw new t("numberOfVertices is required.");if(!r(n))throw new t("sourceArray is required.");if(!r(a))throw new t("byteOffset is required.");return e>=i.SIXTY_FOUR_KILOBYTES?new Uint32Array(n,a,o):new Uint16Array(n,a,o)},n(a)}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t){this.x=e(r,0),this.y=e(t,0)};a.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new a(e,t)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t):new a(e.x,e.y):void 0},a.fromCartesian3=a.clone,a.fromCartesian4=a.clone,a.packedLength=2,a.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.x,i[a]=n.y},a.unpack=function(n,i,o){if(!r(n))throw new t("array is required");return i=e(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i],o},a.fromArray=a.unpack,a.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y)},a.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y)},a.minimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i},a.maximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i},a.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y},a.magnitude=function(e){
return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitude(o)},a.distanceSquared=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitudeSquared(o)},a.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=a.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n},a.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y},a.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i},a.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i},a.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i},a.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i},a.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i},a.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n},a.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n};var u=new a;a.lerp=function(e,n,i,o){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(o))throw new t("result is required.");return a.multiplyByScalar(n,i,u),o=a.multiplyByScalar(e,1-i,o),a.add(u,o,o)};var s=new a,f=new a;a.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return a.normalize(e,s),a.normalize(n,f),i.acosClamped(a.dot(s,f))};var c=new a;return a.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=a.normalize(e,c);return a.abs(i,i),n=i.x<=i.y?a.clone(a.UNIT_X,n):a.clone(a.UNIT_Y,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},a.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]},a.equalsEpsilon=function(e,t,n,a){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,a)&&i.equalsEpsilon(e.y,t.y,n,a)},a.ZERO=n(new a(0,0)),a.UNIT_X=n(new a(1,0)),a.UNIT_Y=n(new a(0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r,t){return a.equalsEpsilon(this,e,r,t)},a.prototype.toString=function(){return"("+this.x+", "+this.y+")"},a}),define("Core/AxisAlignedBoundingBox",["./Cartesian3","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Intersect","./Plane"],function(e,r,t,n,i,a,o){"use strict";var u=function(n,i,a){this.minimum=e.clone(r(n,e.ZERO)),this.maximum=e.clone(r(i,e.ZERO)),t(a)?a=e.clone(a):(a=e.add(this.minimum,this.maximum,new e),e.multiplyByScalar(a,.5,a)),this.center=a};u.fromPoints=function(r,n){if(t(n)||(n=new u),!t(r)||0===r.length)return n.minimum=e.clone(e.ZERO,n.minimum),n.maximum=e.clone(e.ZERO,n.maximum),n.center=e.clone(e.ZERO,n.center),n;for(var i=r[0].x,a=r[0].y,o=r[0].z,s=r[0].x,f=r[0].y,c=r[0].z,l=r.length,h=1;l>h;h++){var d=r[h],w=d.x,E=d.y,m=d.z;i=Math.min(w,i),s=Math.max(w,s),a=Math.min(E,a),f=Math.max(E,f),o=Math.min(m,o),c=Math.max(m,c)}var p=n.minimum;p.x=i,p.y=a,p.z=o;var _=n.maximum;_.x=s,_.y=f,_.z=c;var y=e.add(p,_,n.center);return e.multiplyByScalar(y,.5,y),n},u.clone=function(r,n){return t(r)?t(n)?(n.minimum=e.clone(r.minimum,n.minimum),n.maximum=e.clone(r.maximum,n.maximum),n.center=e.clone(r.center,n.center),n):new u(r.minimum,r.maximum):void 0},u.equals=function(r,n){return r===n||t(r)&&t(n)&&e.equals(r.center,n.center)&&e.equals(r.minimum,n.minimum)&&e.equals(r.maximum,n.maximum)};var s=new e;return u.intersectPlane=function(r,n){if(!t(r))throw new i("box is required.");if(!t(n))throw new i("plane is required.");s=e.subtract(r.maximum,r.minimum,s);var o=e.multiplyByScalar(s,.5,s),u=n.normal,f=o.x*Math.abs(u.x)+o.y*Math.abs(u.y)+o.z*Math.abs(u.z),c=e.dot(r.center,u)+n.distance;return c-f>0?a.INSIDE:0>c+f?a.OUTSIDE:a.INTERSECTING},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.intersectPlane=function(e){return u.intersectPlane(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,r){"use strict";function t(e,t,n){var i=e+t;return r.sign(e)!==r.sign(t)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(t)))<n?0:i}var n={};return n.computeDiscriminant=function(r,t,n){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");var i=t*t-4*r*n;return i},n.computeRealRoots=function(n,i,a){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");var o;if(0===n)return 0===i?[]:[-a/i];if(0===i){if(0===a)return[0,0];var u=Math.abs(a),s=Math.abs(n);if(s>u&&u/s<r.EPSILON14)return[0,0];if(u>s&&s/u<r.EPSILON14)return[];if(o=-a/n,0>o)return[];var f=Math.sqrt(o);return[-f,f]}if(0===a)return o=-i/n,0>o?[o,0]:[0,o];var c=i*i,l=4*n*a,h=t(c,-l,r.EPSILON14);if(0>h)return[];var d=-.5*t(i,r.sign(i)*Math.sqrt(h),r.EPSILON14);return i>0?[d/n,a/d]:[a/d,d/n]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,r){"use strict";function t(e,r,t,n){var i,a,o=e,u=r/3,s=t/3,f=n,c=o*s,l=u*f,h=u*u,d=s*s,w=o*s-h,E=o*f-u*s,m=u*f-d,p=4*w*m-E*E;if(0>p){var _,y,R;h*l>=c*d?(_=o,y=w,R=-2*u*w+o*E):(_=f,y=m,R=-f*E+2*s*m);var T=0>R?-1:1,v=-T*Math.abs(_)*Math.sqrt(-p);a=-R+v;var A=a/2,S=0>A?-Math.pow(-A,1/3):Math.pow(A,1/3),g=a===v?-S:-y/S;return i=0>=y?S+g:-R/(S*S+g*g+y),h*l>=c*d?[(i-u)/o]:[-f/(i+s)]}var q=w,N=-2*u*w+o*E,M=m,O=-f*E+2*s*m,I=Math.sqrt(p),x=Math.sqrt(3)/2,C=Math.abs(Math.atan2(o*I,-N)/3);i=2*Math.sqrt(-q);var P=Math.cos(C);a=i*P;var b=i*(-P/2-x*Math.sin(C)),D=a+b>2*u?a-u:b-u,U=o,L=D/U;C=Math.abs(Math.atan2(f*I,-O)/3),i=2*Math.sqrt(-M),P=Math.cos(C),a=i*P,b=i*(-P/2-x*Math.sin(C));var F=-f,B=2*s>a+b?a+s:b+s,z=F/B,G=U*B,W=-D*B-U*F,X=D*F,H=(s*W-u*X)/(-u*W+s*G);return H>=L?z>=L?z>=H?[L,H,z]:[L,z,H]:[z,L,H]:z>=L?[H,L,z]:z>=H?[H,z,L]:[z,H,L]}var n={};return n.computeDiscriminant=function(r,t,n,i){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var a=r*r,o=t*t,u=n*n,s=i*i,f=18*r*t*n*i+o*u-27*a*s-4*(r*u*n+o*t*i);return f},n.computeRealRoots=function(n,i,a,o){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");if("number"!=typeof o)throw new e("d is a required number.");var u,s;if(0===n)return r.computeRealRoots(i,a,o);if(0===i){if(0===a){if(0===o)return[0,0,0];s=-o/n;var f=0>s?-Math.pow(-s,1/3):Math.pow(s,1/3);return[f,f,f]}return 0===o?(u=r.computeRealRoots(n,0,a),0===u.Length?[0]:[u[0],0,u[1]]):t(n,0,a,o)}return 0===a?0===o?(s=-i/n,0>s?[s,0,0]:[0,0,s]):t(n,i,0,o):0===o?(u=r.computeRealRoots(n,i,a),0===u.length?[0]:u[1]<=0?[u[0],u[1],0]:u[0]>=0?[0,u[0],u[1]]:[u[0],0,u[1]]):t(n,i,a,o)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,r,t,n){"use strict";function i(r,i,a,o){var u=r*r,s=i-3*u/8,f=a-i*r/2+u*r/8,c=o-a*r/4+i*u/16-3*u*u/256,l=e.computeRealRoots(1,2*s,s*s-4*c,-f*f);if(l.length>0){var h=-r/4,d=l[l.length-1];if(Math.abs(d)<t.EPSILON14){var w=n.computeRealRoots(1,s,c);if(2===w.length){var E,m=w[0],p=w[1];if(m>=0&&p>=0){var _=Math.sqrt(m),y=Math.sqrt(p);return[h-y,h-_,h+_,h+y]}if(m>=0&&0>p)return E=Math.sqrt(m),[h-E,h+E];if(0>m&&p>=0)return E=Math.sqrt(p),[h-E,h+E]}return[]}if(d>0){var R=Math.sqrt(d),T=(s+d-f/R)/2,v=(s+d+f/R)/2,A=n.computeRealRoots(1,R,T),S=n.computeRealRoots(1,-R,v);return 0!==A.length?(A[0]+=h,A[1]+=h,0!==S.length?(S[0]+=h,S[1]+=h,A[1]<=S[0]?[A[0],A[1],S[0],S[1]]:S[1]<=A[0]?[S[0],S[1],A[0],A[1]]:A[0]>=S[0]&&A[1]<=S[1]?[S[0],A[0],A[1],S[1]]:S[0]>=A[0]&&S[1]<=A[1]?[A[0],S[0],S[1],A[1]]:A[0]>S[0]&&A[0]<S[1]?[S[0],A[0],S[1],A[1]]:[A[0],S[0],A[1],S[1]]):A):0!==S.length?(S[0]+=h,S[1]+=h,S):[]}}return[]}function a(r,i,a,o){var u=a*a,s=i*i,f=r*r,c=-2*i,l=a*r+s-4*o,h=f*o-a*i*r+u,d=e.computeRealRoots(1,c,l,h);if(d.length>0){var w,E,m=d[0],p=i-m,_=p*p,y=r/2,R=p/2,T=_-4*o,v=_+4*Math.abs(o),A=f-4*m,S=f+4*Math.abs(m);if(0>m||A*v>T*S){var g=Math.sqrt(A);w=g/2,E=0===g?0:(r*R-a)/g}else{var q=Math.sqrt(T);w=0===q?0:(r*R-a)/q,E=q/2}var N,M;0===y&&0===w?(N=0,M=0):t.sign(y)===t.sign(w)?(N=y+w,M=m/N):(M=y-w,N=m/M);var O,I;0===R&&0===E?(O=0,I=0):t.sign(R)===t.sign(E)?(O=R+E,I=o/O):(I=R-E,O=o/I);var x=n.computeRealRoots(1,N,O),C=n.computeRealRoots(1,M,I);if(0!==x.length)return 0!==C.length?x[1]<=C[0]?[x[0],x[1],C[0],C[1]]:C[1]<=x[0]?[C[0],C[1],x[0],x[1]]:x[0]>=C[0]&&x[1]<=C[1]?[C[0],x[0],x[1],C[1]]:C[0]>=x[0]&&C[1]<=x[1]?[x[0],C[0],C[1],x[1]]:x[0]>C[0]&&x[0]<C[1]?[C[0],x[0],C[1],x[1]]:[x[0],C[0],x[1],C[1]]:x;if(0!==C.length)return C}return[]}var o={};return o.computeDiscriminant=function(e,t,n,i,a){if("number"!=typeof e)throw new r("a is a required number.");if("number"!=typeof t)throw new r("b is a required number.");if("number"!=typeof n)throw new r("c is a required number.");if("number"!=typeof i)throw new r("d is a required number.");if("number"!=typeof a)throw new r("e is a required number.");var o=e*e,u=o*e,s=t*t,f=s*t,c=n*n,l=c*n,h=i*i,d=h*i,w=a*a,E=w*a,m=s*c*h-4*f*d-4*e*l*h+18*e*t*n*d-27*o*h*h+256*u*E+a*(18*f*n*i-4*s*l+16*e*c*c-80*e*t*c*i-6*e*s*h+144*o*n*h)+w*(144*e*s*n-27*s*s-128*o*c-192*o*t*i);return m},o.computeRealRoots=function(n,o,u,s,f){if("number"!=typeof n)throw new r("a is a required number.");if("number"!=typeof o)throw new r("b is a required number.");if("number"!=typeof u)throw new r("c is a required number.");if("number"!=typeof s)throw new r("d is a required number.");if("number"!=typeof f)throw new r("e is a required number.");if(Math.abs(n)<t.EPSILON15)return e.computeRealRoots(o,u,s,f);var c=o/n,l=u/n,h=s/n,d=f/n,w=0>c?1:0;switch(w+=0>l?w+1:w,w+=0>h?w+1:w,w+=0>d?w+1:w){case 0:return i(c,l,h,d);case 1:return a(c,l,h,d);case 2:return a(c,l,h,d);case 3:return i(c,l,h,d);case 4:return i(c,l,h,d);case 5:return a(c,l,h,d);case 6:return i(c,l,h,d);case 7:return i(c,l,h,d);case 8:return a(c,l,h,d);case 9:return i(c,l,h,d);case 10:return i(c,l,h,d);case 11:return a(c,l,h,d);case 12:return i(c,l,h,d);case 13:return i(c,l,h,d);case 14:return i(c,l,h,d);case 15:return i(c,l,h,d);default:return void 0}},o}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i=function(t,n){n=e.clone(r(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(r(t,e.ZERO)),this.direction=n};return i.getPoint=function(r,i,a){if(!t(r))throw new n("ray is requred");if("number"!=typeof i)throw new n("t is a required number");return t(a)||(a=new e),a=e.multiplyByScalar(r.direction,i,a),e.add(r.origin,a,a)},i}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,r,t,n,i,a,o,u,s,f){"use strict";function c(r,o,u,s,f){if(!n(r))throw new i("ray is required.");if(!n(o))throw new i("p0 is required.");if(!n(u))throw new i("p1 is required.");if(!n(s))throw new i("p2 is required.");f=t(f,!1);var c,l,h,d,w,E=r.origin,T=r.direction,v=e.subtract(u,o,m),A=e.subtract(s,o,p),S=e.cross(T,A,_),g=e.dot(v,S);if(f){if(g<a.EPSILON6)return void 0;if(c=e.subtract(E,o,y),h=e.dot(c,S),0>h||h>g)return void 0;if(l=e.cross(c,v,R),d=e.dot(T,l),0>d||h+d>g)return void 0;w=e.dot(A,l)/g}else{if(Math.abs(g)<a.EPSILON6)return void 0;var q=1/g;if(c=e.subtract(E,o,y),h=e.dot(c,S)*q,0>h||h>1)return void 0;if(l=e.cross(c,v,R),d=e.dot(T,l)*q,0>d||h+d>1)return void 0;w=e.dot(A,l)*q}return w}function l(e,r,t,n){var i=r*r-4*e*t;if(0>i)return void 0;if(i>0){var a=1/(2*e),o=Math.sqrt(i),u=(-r+o)*a,s=(-r-o)*a;return s>u?(n.root0=u,n.root1=s):(n.root0=s,n.root1=u),n}var f=-r/(2*e);return 0===f?void 0:(n.root0=n.root1=f,n)}function h(r,t,i){n(i)||(i={});var a=r.origin,o=r.direction,u=t.center,s=t.radius*t.radius,f=e.subtract(a,u,_),c=e.dot(o,o),h=2*e.dot(o,f),d=e.magnitudeSquared(f)-s,w=l(c,h,d,v);return n(w)?(i.start=w.root0,i.stop=w.root1,i):void 0}function d(e,r,t){var n=e+r;return a.sign(e)!==a.sign(r)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(r)))<t?0:n}function w(r,t,n,i,f){var c,l=i*i,h=f*f,w=(r[o.COLUMN1ROW1]-r[o.COLUMN2ROW2])*h,E=f*(i*d(r[o.COLUMN1ROW0],r[o.COLUMN0ROW1],a.EPSILON15)+t.y),m=r[o.COLUMN0ROW0]*l+r[o.COLUMN2ROW2]*h+i*t.x+n,p=h*d(r[o.COLUMN2ROW1],r[o.COLUMN1ROW2],a.EPSILON15),_=f*(i*d(r[o.COLUMN2ROW0],r[o.COLUMN0ROW2])+t.z),y=[];if(0===_&&0===p){if(c=u.computeRealRoots(w,E,m),0===c.length)return y;var R=c[0],T=Math.sqrt(Math.max(1-R*R,0));if(y.push(new e(i,f*R,f*-T)),y.push(new e(i,f*R,f*T)),2===c.length){var v=c[1],A=Math.sqrt(Math.max(1-v*v,0));y.push(new e(i,f*v,f*-A)),y.push(new e(i,f*v,f*A))}return y}var S=_*_,g=p*p,q=w*w,N=_*p,M=q+g,O=2*(E*w+N),I=2*m*w+E*E-g+S,x=2*(m*E-N),C=m*m-S;if(0===M&&0===O&&0===I&&0===x)return y;c=s.computeRealRoots(M,O,I,x,C);var P=c.length;if(0===P)return y;for(var b=0;P>b;++b){var D,U=c[b],L=U*U,F=Math.max(1-L,0),B=Math.sqrt(F);D=a.sign(w)===a.sign(m)?d(w*L+m,E*U,a.EPSILON12):a.sign(m)===a.sign(E*U)?d(w*L,E*U+m,a.EPSILON12):d(w*L+E*U,m,a.EPSILON12);var z=d(p*U,_,a.EPSILON15),G=D*z;0>G?y.push(new e(i,f*U,f*B)):G>0?y.push(new e(i,f*U,f*-B)):0!==B?(y.push(new e(i,f*U,f*-B)),y.push(new e(i,f*U,f*B)),++b):y.push(new e(i,f*U,f*B))}return y}var E={};E.rayPlane=function(r,t,o){if(!n(r))throw new i("ray is required.");if(!n(t))throw new i("plane is required.");n(o)||(o=new e);var u=r.origin,s=r.direction,f=t.normal,c=e.dot(f,s);if(Math.abs(c)<a.EPSILON15)return void 0;var l=(-t.distance-e.dot(f,u))/c;return 0>l?void 0:(o=e.multiplyByScalar(s,l,o),e.add(u,o,o))};var m=new e,p=new e,_=new e,y=new e,R=new e;E.rayTriangle=function(r,t,i,a,o,u){var s=c(r,t,i,a,o);return!n(s)||0>s?void 0:(n(u)||(u=new e),e.multiplyByScalar(r.direction,s,u),e.add(r.origin,u,u))};var T=new f;E.lineSegmentTriangle=function(r,t,a,o,u,s,f){if(!n(r))throw new i("v0 is required.");if(!n(t))throw new i("v1 is required.");var l=T;e.clone(r,l.origin),e.subtract(t,r,l.direction),e.normalize(l.direction,l.direction);var h=c(l,a,o,u,s);return!n(h)||0>h||h>e.distance(r,t)?void 0:(n(f)||(f=new e),e.multiplyByScalar(l.direction,h,f),e.add(l.origin,f,f))};var v={root0:0,root1:0};E.raySphere=function(e,r,t){if(!n(e))throw new i("ray is required.");if(!n(r))throw new i("sphere is required.");return t=h(e,r,t),!n(t)||t.stop<0?void 0:(t.start=Math.max(t.start,0),t)};var A=new f;E.lineSegmentSphere=function(r,t,a,o){if(!n(r))throw new i("p0 is required.");if(!n(t))throw new i("p1 is required.");if(!n(a))throw new i("sphere is required.");var u=A,s=(e.clone(r,u.origin),e.subtract(t,r,u.direction)),f=e.magnitude(s);return e.normalize(s,s),o=h(u,a,o),!n(o)||o.stop<0||o.start>f?void 0:(o.start=Math.max(o.start,0),o.stop=Math.min(o.stop,f),o)};var S=new e,g=new e;E.rayEllipsoid=function(r,t){if(!n(r))throw new i("ray is required.");if(!n(t))throw new i("ellipsoid is required.");var a,o,u,s,f,c=t.oneOverRadii,l=e.multiplyComponents(c,r.origin,S),h=e.multiplyComponents(c,r.direction,g),d=e.magnitudeSquared(l),w=e.dot(l,h);if(d>1){if(w>=0)return void 0;var E=w*w;if(a=d-1,o=e.magnitudeSquared(h),u=o*a,u>E)return void 0;if(E>u){s=w*w-u,f=-w+Math.sqrt(s);var m=f/o,p=a/f;return p>m?{start:m,stop:p}:{start:p,stop:m}}var _=Math.sqrt(a/o);return{start:_,stop:_}}return 1>d?(a=d-1,o=e.magnitudeSquared(h),u=o*a,s=w*w-u,f=-w+Math.sqrt(s),{start:0,stop:f/o}):0>w?(o=e.magnitudeSquared(h),{start:0,stop:-w/o}):void 0};var q=new e,N=new e,M=new e,O=new e,I=new e,x=new o,C=new o,P=new o,b=new o,D=new o,U=new o,L=new o,F=new e,B=new e,z=new r;E.grazingAltitudeLocation=function(r,t){if(!n(r))throw new i("ray is required.");if(!n(t))throw new i("ellipsoid is required.");var u=r.origin,s=r.direction,f=t.geodeticSurfaceNormal(u,q);if(e.dot(s,f)>=0)return u;var c=n(this.rayEllipsoid(r,t)),l=t.transformPositionToScaledSpace(s,q),h=e.normalize(l,l),d=e.mostOrthogonalAxis(l,O),E=e.normalize(e.cross(d,h,N),N),m=e.normalize(e.cross(h,E,M),M),p=x;p[0]=h.x,p[1]=h.y,p[2]=h.z,p[3]=E.x,p[4]=E.y,p[5]=E.z,p[6]=m.x,p[7]=m.y,p[8]=m.z;var _=o.transpose(p,C),y=o.fromScale(t.radii,P),R=o.fromScale(t.oneOverRadii,b),T=D;T[0]=0,T[1]=-s.z,T[2]=s.y,T[3]=s.z,T[4]=0,T[5]=-s.x,T[6]=-s.y,T[7]=s.x,T[8]=0;var v,A,S=o.multiply(o.multiply(_,R,U),T,U),g=o.multiply(o.multiply(S,y,L),p,L),G=o.multiplyByVector(S,u,I),W=w(g,e.negate(G,q),0,0,1),X=W.length;if(X>0){for(var H=e.clone(e.ZERO,B),V=Number.NEGATIVE_INFINITY,Y=0;X>Y;++Y){v=o.multiplyByVector(y,o.multiplyByVector(p,W[Y],F),F);var j=e.normalize(e.subtract(v,u,O),O),k=e.dot(j,s);k>V&&(V=k,H=e.clone(v,H))}var Z=t.cartesianToCartographic(H,z);return V=a.clamp(V,0,1),A=e.magnitude(e.subtract(H,u,O))*Math.sqrt(1-V*V),A=c?-A:A,Z.height=A,t.cartographicToCartesian(Z,new e)}return void 0};var G=new e;return E.lineSegmentPlane=function(r,t,o,u){if(!n(r))throw new i("endPoint0 is required.");if(!n(t))throw new i("endPoint1 is required.");if(!n(o))throw new i("plane is required.");n(u)||(u=new e);var s=e.subtract(t,r,G),f=o.normal,c=e.dot(f,s);if(Math.abs(c)<a.EPSILON6)return void 0;var l=e.dot(f,r),h=-(o.distance+l)/c;return 0>h||h>1?void 0:(e.multiplyByScalar(s,h,u),e.add(r,u,u),u)},E.trianglePlaneIntersection=function(r,t,a,o){if(!(n(r)&&n(t)&&n(a)&&n(o)))throw new i("p0, p1, p2, and plane are required.");var u=o.normal,s=o.distance,f=e.dot(u,r)+s<0,c=e.dot(u,t)+s<0,l=e.dot(u,a)+s<0,h=0;h+=f?1:0,h+=c?1:0,h+=l?1:0;var d,w;if((1===h||2===h)&&(d=new e,w=new e),1===h){if(f)return E.lineSegmentPlane(r,t,o,d),E.lineSegmentPlane(r,a,o,w),{positions:[r,t,a,d,w],indices:[0,3,4,1,2,4,1,4,3]};if(c)return E.lineSegmentPlane(t,a,o,d),E.lineSegmentPlane(t,r,o,w),{positions:[r,t,a,d,w],indices:[1,3,4,2,0,4,2,4,3]};if(l)return E.lineSegmentPlane(a,r,o,d),E.lineSegmentPlane(a,t,o,w),{positions:[r,t,a,d,w],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===h){if(!f)return E.lineSegmentPlane(t,r,o,d),E.lineSegmentPlane(a,r,o,w),{positions:[r,t,a,d,w],indices:[1,2,4,1,4,3,0,3,4]};if(!c)return E.lineSegmentPlane(a,t,o,d),E.lineSegmentPlane(r,t,o,w),{positions:[r,t,a,d,w],indices:[2,0,4,2,4,3,1,3,4]};if(!l)return E.lineSegmentPlane(r,a,o,d),E.lineSegmentPlane(t,a,o,w),{positions:[r,t,a,d,w],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},E}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,t,n,i){return r(e).then(t,n,i)}function r(e){var r,t;return e instanceof n?r=e:u(e)?(t=o(),e.then(function(e){t.resolve(e)},function(e){t.reject(e)},function(e){t.progress(e)}),r=t.promise):r=i(e),r}function t(r){return e(r,a)}function n(e){this.then=e}function i(e){var t=new n(function(t){try{return r(t?t(e):e)}catch(n){return a(n)}});return t}function a(e){var t=new n(function(t,n){try{return n?r(n(e)):a(e)}catch(i){return a(i)}});return t}function o(){function e(e,r,t){return h(e,r,t)}function t(e){return w(e)}function i(e){return w(a(e))}function u(e){return d(e)}var s,f,c,l,h,d,w;return f=new n(e),s={then:e,resolve:t,reject:i,progress:u,promise:f,resolver:{resolve:t,reject:i,progress:u}},c=[],l=[],h=function(e,r,t){var n,i;return n=o(),i="function"==typeof t?function(e){try{n.progress(t(e))}catch(r){n.progress(r)}}:function(e){n.progress(e)},c.push(function(t){t.then(e,r).then(n.resolve,n.reject,i)}),l.push(i),n.promise},d=function(e){return E(l,e),e},w=function(e){return e=r(e),h=e.then,w=r,d=p,E(c,e),l=c=T,e},s}function u(e){return e&&"function"==typeof e.then}function s(r,t,n,i,a){return m(2,arguments),e(r,function(r){function u(e){E(e)}function s(e){w(e)}var f,c,l,h,d,w,E,m,_,y;if(_=r.length>>>0,f=Math.max(0,Math.min(t,_)),l=[],c=_-f+1,h=[],d=o(),f)for(m=d.progress,E=function(e){h.push(e),--c||(w=E=p,d.reject(h))},w=function(e){l.push(e),--f||(w=E=p,d.resolve(l))},y=0;_>y;++y)y in r&&e(r[y],s,u,m);else d.resolve(l);return d.then(n,i,a)})}function f(e,r,t,n){function i(e){return r?r(e[0]):e[0]}return s(e,1,i,t,n)}function c(e,r,t,n){return m(1,arguments),h(e,_).then(r,t,n)}function l(){return h(arguments,_)}function h(r,t){return e(r,function(r){var n,i,a,u,s,f;if(a=i=r.length>>>0,n=[],f=o(),a)for(u=function(r,i){e(r,t).then(function(e){n[i]=e,--a||f.resolve(n)},f.reject)},s=0;i>s;s++)s in r?u(r[s],s):--a;else f.resolve(n);return f.promise})}function d(r,t){var n=R.call(arguments,1);return e(r,function(r){var i;return i=r.length,n[0]=function(r,n,a){return e(r,function(r){return e(n,function(e){return t(r,e,a,i)})})},y.apply(r,n)})}function w(r,t,n){var i=arguments.length>2;return e(r,function(e){return e=i?n:e,t.resolve(e),e},function(e){return t.reject(e),a(e)},t.progress)}function E(e,r){for(var t,n=0;t=e[n++];)t(r)}function m(e,r){for(var t,n=r.length;n>e;)if(t=r[--n],null!=t&&"function"!=typeof t)throw new Error("arg "+n+" must be a function")}function p(){}function _(e){return e}var y,R,T;return e.defer=o,e.resolve=r,e.reject=t,e.join=l,e.all=c,e.map=h,e.reduce=d,e.any=f,e.some=s,e.chain=w,e.isPromise=u,n.prototype={always:function(e,r){return this.then(e,e,r)},otherwise:function(e){return this.then(T,e)},"yield":function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(r){return c(r,function(r){return e.apply(T,r)})})}},R=[].slice,y=[].reduce||function(e){var r,t,n,i,a;if(a=0,r=Object(this),i=r.length>>>0,t=arguments,t.length<=1)for(;;){if(a in r){n=r[a++];break}if(++a>=i)throw new TypeError}else n=t[1];for(;i>a;++a)a in r&&(n=e(n,r[a],a,r));return n},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./defined","./DeveloperError"],function(e,r){"use strict";var t=function(t,n,i){if(!e(t))throw new r("array is required.");if(!e(n))throw new r("itemToFind is required.");if(!e(i))throw new r("comparator is required.");for(var a,o,u=0,s=t.length-1;s>=u;)if(a=~~((u+s)/2),o=i(t[a],n),0>o)u=a+1;else{if(!(o>0))return a;s=a-1}return~(s+1)};return t}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";var e=function(e,r,t,n,i){this.xPoleWander=e,this.yPoleWander=r,this.xPoleOffset=t,this.yPoleOffset=n,this.ut1MinusUtc=i};return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,r=arguments,t=0,n=r[t++],i=function(e,r,t,n){t||(t=" ");var i=e.length>=r?"":Array(1+r-e.length>>>0).join(t);return n?e+i:i+e},a=function(e,r,t,n,a,o){var u=n-e.length;return u>0&&(e=t||!a?i(e,n,o,t):e.slice(0,r.length)+i("",u,"0",!0)+e.slice(r.length)),e},o=function(e,r,t,n,o,u,s){var f=e>>>0;return t=t&&f&&{2:"0b",8:"0",16:"0x"}[r]||"",e=t+i(f.toString(r),u||0,"0",!1),a(e,t,n,o,s)},u=function(e,r,t,n,i,o){return null!=n&&(e=e.slice(0,n)),a(e,"",r,t,i,o)},s=function(e,n,s,f,c,l,h){var d,w,E,m,p;if("%%"==e)return"%";for(var _=!1,y="",R=!1,T=!1,v=" ",A=s.length,S=0;s&&A>S;S++)switch(s.charAt(S)){case" ":y=" ";break;case"+":y="+";break;case"-":_=!0;break;case"'":v=s.charAt(S+1);break;case"0":R=!0;break;case"#":T=!0}if(f=f?"*"==f?+r[t++]:"*"==f.charAt(0)?+r[f.slice(1,-1)]:+f:0,0>f&&(f=-f,_=!0),!isFinite(f))throw new Error("sprintf: (minimum-)width must be finite");switch(l=l?"*"==l?+r[t++]:"*"==l.charAt(0)?+r[l.slice(1,-1)]:+l:"fFeE".indexOf(h)>-1?6:"d"==h?0:void 0,p=n?r[n.slice(0,-1)]:r[t++],h){case"s":return u(String(p),_,f,l,R,v);case"c":return u(String.fromCharCode(+p),_,f,l,R);case"b":return o(p,2,T,_,f,l,R);case"o":return o(p,8,T,_,f,l,R);case"x":return o(p,16,T,_,f,l,R);case"X":return o(p,16,T,_,f,l,R).toUpperCase();case"u":return o(p,10,T,_,f,l,R);case"i":case"d":return d=+p||0,d=Math.round(d-d%1),w=0>d?"-":y,p=w+i(String(Math.abs(d)),l,"0",!1),a(p,w,_,f,R);case"e":case"E":case"f":case"F":case"g":case"G":return d=+p,w=0>d?"-":y,E=["toExponential","toFixed","toPrecision"]["efg".indexOf(h.toLowerCase())],m=["toString","toUpperCase"]["eEfFgG".indexOf(h)%2],p=w+Math.abs(d)[E](l),a(p,w,_,f,R)[m]();default:return e}};return n.replace(e,s)}return e}),define("Core/GregorianDate",[],function(){"use strict";var e=function(e,r,t,n,i,a,o,u){this.year=e,this.month=r,this.day=t,this.hour=n,this.minute=i,this.second=a,this.millisecond=o,this.isLeapSecond=u};return e}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function r(r){if(null===r||isNaN(r))throw new e("year is required and must be a number.");return r%4===0&&r%100!==0||r%400===0}return r}),define("Core/LeapSecond",[],function(){"use strict";var e=function(e,r){this.julianDate=e,this.offset=r};return e}),define("Core/TimeConstants",["./freezeObject"],function(e){"use strict";var r={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e(r)}),define("Core/TimeStandard",["./freezeObject"],function(e){"use strict";var r={UTC:0,TAI:1};return e(r)}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,r,t,n,i,a,o,u,s,f){"use strict";function c(e,r){return O.compare(e.julianDate,r.julianDate)}function l(e){_.julianDate=e;var t=O.leapSeconds,n=r(t,_,c);0>n&&(n=~n),n>=t.length&&(n=t.length-1);var i=t[n].offset;if(n>0){var a=O.secondsDifference(t[n].julianDate,e);a>i&&(n--,i=t[n].offset)}O.addSeconds(e,i,e)}function h(e,t){_.julianDate=e;var n=O.leapSeconds,i=r(n,_,c);if(0>i&&(i=~i),0===i)return O.addSeconds(e,-n[0].offset,t);if(i>=n.length)return O.addSeconds(e,-n[i-1].offset,t);var a=O.secondsDifference(n[i].julianDate,e);return 0===a?O.addSeconds(e,-n[i].offset,t):1>=a?void 0:O.addSeconds(e,-n[--i].offset,t)}function d(e,r,t){var n=r/s.SECONDS_PER_DAY|0;return e+=n,r-=s.SECONDS_PER_DAY*n,0>r&&(e--,r+=s.SECONDS_PER_DAY),t.dayNumber=e,t.secondsOfDay=r,t}function w(e,r,t,n,i,a,o){var u=(r-14)/12|0,f=e+4800+u,c=(1461*f/4|0)+(367*(r-2-12*u)/12|0)-(3*((f+100)/100|0)/4|0)+t-32075;n-=12,0>n&&(n+=24);var l=a+(n*s.SECONDS_PER_HOUR+i*s.SECONDS_PER_MINUTE+o*s.SECONDS_PER_MILLISECOND);return l>=43200&&(c-=1),[c,l]}var E=new a,m=[31,28,31,30,31,30,31,31,30,31,30,31],p=29,_=new u,y=/^(\d{4})$/,R=/^(\d{4})-(\d{2})$/,T=/^(\d{4})-?(\d{3})$/,v=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,A=/^(\d{4})-?(\d{2})-?(\d{2})$/,S=/([Z+\-])?(\d{2})?:?(\d{2})?$/,g=/^(\d{2})(\.\d+)?/.source+S.source,q=/^(\d{2}):?(\d{2})(\.\d+)?/.source+S.source,N=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+S.source,M="Invalid ISO 8601 date.",O=function(e,r,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=t(e,0),r=t(r,0),n=t(n,f.UTC);var i=0|e;r+=(e-i)*s.SECONDS_PER_DAY,d(i,r,this),n===f.UTC&&l(this)};O.fromDate=function(e,r){if(!(e instanceof Date)||isNaN(e.getTime()))throw new i("date must be a valid JavaScript Date.");var t=w(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(r)?(d(t[0],t[1],r),l(r),r):new O(t[0],t[1],f.UTC)},O.fromIso8601=function(e,r){if("string"!=typeof e)throw new i(M);e=e.replace(",",".");var t,a,u,s=e.split("T"),c=1,h=1,E=0,_=0,S=0,I=0,x=s[0],C=s[1];if(!n(x))throw new i(M);var P;if(s=x.match(A),null!==s){if(P=x.split("-").length-1,P>0&&2!==P)throw new i(M);t=+s[1],c=+s[2],h=+s[3]}else if(s=x.match(R),null!==s)t=+s[1],c=+s[2];else if(s=x.match(y),null!==s)t=+s[1];else{var b;if(s=x.match(T),null!==s){if(t=+s[1],b=+s[2],u=o(t),1>b||u&&b>366||!u&&b>365)throw new i(M)}else{if(s=x.match(v),null===s)throw new i(M);t=+s[1];var D=+s[2],U=+s[3]||0;if(P=x.split("-").length-1,P>0&&(!n(s[3])&&1!==P||n(s[3])&&2!==P))throw new i(M);var L=new Date(Date.UTC(t,0,4));b=7*D+U-L.getUTCDay()-3}a=new Date(Date.UTC(t,0,1)),a.setUTCDate(b),c=a.getUTCMonth()+1,h=a.getUTCDate()}if(u=o(t),1>c||c>12||1>h||(2!==c||!u)&&h>m[c-1]||u&&2===c&&h>p)throw new i(M);var F;if(n(C)){if(s=C.match(N),null!==s){if(P=C.split(":").length-1,P>0&&2!==P&&3!==P)throw new i(M);E=+s[1],_=+s[2],S=+s[3],I=1e3*+(s[4]||0),F=5}else if(s=C.match(q),null!==s){if(P=C.split(":").length-1,P>0&&1!==P)throw new i(M);E=+s[1],_=+s[2],S=60*+(s[3]||0),F=4}else{if(s=C.match(g),null===s)throw new i(M);E=+s[1],_=60*+(s[2]||0),F=3}if(_>=60||S>=61||E>24||24===E&&(_>0||S>0||I>0))throw new i(M);var B=s[F],z=+s[F+1],G=+(s[F+2]||0);switch(B){case"+":E-=z,_-=G;break;case"-":E+=z,_+=G;break;case"Z":break;default:_+=new Date(Date.UTC(t,c-1,h,E,_)).getTimezoneOffset()}}else _+=new Date(t,c-1,h).getTimezoneOffset();var W=60===S;for(W&&S--;_>=60;)_-=60,E++;for(;E>=24;)E-=24,h++;for(a=u&&2===c?p:m[c-1];h>a;)h-=a,c++,c>12&&(c-=12,t++),a=u&&2===c?p:m[c-1];for(;0>_;)_+=60,E--;for(;0>E;)E+=24,h--;for(;1>h;)c--,1>c&&(c+=12,t--),a=u&&2===c?p:m[c-1],h+=a;var X=w(t,c,h,E,_,S,I);return n(r)?(d(X[0],X[1],r),l(r)):r=new O(X[0],X[1],f.UTC),W&&O.addSeconds(r,1,r),r},O.now=function(e){return O.fromDate(new Date,e)};var I=new O(0,0,f.TAI);return O.toGregorianDate=function(e,r){if(!n(e))throw new i("julianDate is required.");var t=!1,o=h(e,I);n(o)||(O.addSeconds(e,-1,I),o=h(I,I),t=!0);var u=o.dayNumber,f=o.secondsOfDay;f>=43200&&(u+=1);var c=u+68569|0,l=4*c/146097|0;c=c-((146097*l+3)/4|0)|0;var d=4e3*(c+1)/1461001|0;c=c-(1461*d/4|0)+31|0;var w=80*c/2447|0,E=c-(2447*w/80|0)|0;c=w/11|0;var m=w+2-12*c|0,p=100*(l-49)+d+c|0,_=f/s.SECONDS_PER_HOUR|0,y=f-_*s.SECONDS_PER_HOUR,R=y/s.SECONDS_PER_MINUTE|0;y-=R*s.SECONDS_PER_MINUTE;var T=0|y,v=(y-T)/s.SECONDS_PER_MILLISECOND;return _+=12,_>23&&(_-=24),t&&(T+=1),n(r)?(r.year=p,r.month=m,r.day=E,r.hour=_,r.minute=R,r.second=T,r.millisecond=v,r.isLeapSecond=t,r):new a(p,m,E,_,R,T,v,t)},O.toDate=function(e){if(!n(e))throw new i("julianDate is required.");var r=O.toGregorianDate(e,E),t=r.second;return r.isLeapSecond&&(t-=1),new Date(Date.UTC(r.year,r.month-1,r.day,r.hour,r.minute,t,r.millisecond))},O.toIso8601=function(r,t){if(!n(r))throw new i("julianDate is required.");var a,o=O.toGregorianDate(r,o);return n(t)||0===o.millisecond?n(t)&&0!==t?(a=(.01*o.millisecond).toFixed(t).replace(".","").slice(0,t),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o.year,o.month,o.day,o.hour,o.minute,o.second,a)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",o.year,o.month,o.day,o.hour,o.minute,o.second):(a=(.01*o.millisecond).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o.year,o.month,o.day,o.hour,o.minute,o.second,a))},O.clone=function(e,r){return n(e)?n(r)?(r.dayNumber=e.dayNumber,r.secondsOfDay=e.secondsOfDay,r):new O(e.dayNumber,e.secondsOfDay,f.TAI):void 0},O.compare=function(e,r){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");var t=e.dayNumber-r.dayNumber;return 0!==t?t:e.secondsOfDay-r.secondsOfDay},O.equals=function(e,r){return e===r||n(e)&&n(r)&&e.dayNumber===r.dayNumber&&e.secondsOfDay===r.secondsOfDay;
},O.equalsEpsilon=function(e,r,t){if(!n(t))throw new i("epsilon is required.");return e===r||n(e)&&n(r)&&Math.abs(O.secondsDifference(e,r))<=t},O.totalDays=function(e){if(!n(e))throw new i("julianDate is required.");return e.dayNumber+e.secondsOfDay/s.SECONDS_PER_DAY},O.secondsDifference=function(e,r){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");var t=(e.dayNumber-r.dayNumber)*s.SECONDS_PER_DAY;return t+(e.secondsOfDay-r.secondsOfDay)},O.daysDifference=function(e,r){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");var t=e.dayNumber-r.dayNumber,a=(e.secondsOfDay-r.secondsOfDay)/s.SECONDS_PER_DAY;return t+a},O.computeTaiMinusUtc=function(e){_.julianDate=e;var t=O.leapSeconds,n=r(t,_,c);return 0>n&&(n=~n,--n,0>n&&(n=0)),t[n].offset},O.addSeconds=function(e,r,t){if(!n(e))throw new i("julianDate is required.");if(!n(r))throw new i("seconds is required.");if(!n(t))throw new i("result is required.");return d(e.dayNumber,e.secondsOfDay+r,t)},O.addMinutes=function(e,r,t){if(!n(e))throw new i("julianDate is required.");if(!n(r))throw new i("minutes is required.");if(!n(t))throw new i("result is required.");var a=e.secondsOfDay+r*s.SECONDS_PER_MINUTE;return d(e.dayNumber,a,t)},O.addHours=function(e,r,t){if(!n(e))throw new i("julianDate is required.");if(!n(r))throw new i("hours is required.");if(!n(t))throw new i("result is required.");var a=e.secondsOfDay+r*s.SECONDS_PER_HOUR;return d(e.dayNumber,a,t)},O.addDays=function(e,r,t){if(!n(e))throw new i("julianDate is required.");if(!n(r))throw new i("days is required.");if(!n(t))throw new i("result is required.");var a=e.dayNumber+r;return d(a,e.secondsOfDay,t)},O.lessThan=function(e,r){return O.compare(e,r)<0},O.lessThanOrEquals=function(e,r){return O.compare(e,r)<=0},O.greaterThan=function(e,r){return O.compare(e,r)>0},O.greaterThanOrEquals=function(e,r){return O.compare(e,r)>=0},O.prototype.clone=function(e){return O.clone(this,e)},O.prototype.equals=function(e){return O.equals(this,e)},O.prototype.equalsEpsilon=function(e,r){return O.equalsEpsilon(this,e,r)},O.prototype.toString=function(){return O.toIso8601(this)},O.leapSeconds=[new u(new O(2441317,43210,f.TAI),10),new u(new O(2441499,43211,f.TAI),11),new u(new O(2441683,43212,f.TAI),12),new u(new O(2442048,43213,f.TAI),13),new u(new O(2442413,43214,f.TAI),14),new u(new O(2442778,43215,f.TAI),15),new u(new O(2443144,43216,f.TAI),16),new u(new O(2443509,43217,f.TAI),17),new u(new O(2443874,43218,f.TAI),18),new u(new O(2444239,43219,f.TAI),19),new u(new O(2444786,43220,f.TAI),20),new u(new O(2445151,43221,f.TAI),21),new u(new O(2445516,43222,f.TAI),22),new u(new O(2446247,43223,f.TAI),23),new u(new O(2447161,43224,f.TAI),24),new u(new O(2447892,43225,f.TAI),25),new u(new O(2448257,43226,f.TAI),26),new u(new O(2448804,43227,f.TAI),27),new u(new O(2449169,43228,f.TAI),28),new u(new O(2449534,43229,f.TAI),29),new u(new O(2450083,43230,f.TAI),30),new u(new O(2450630,43231,f.TAI),31),new u(new O(2451179,43232,f.TAI),32),new u(new O(2453736,43233,f.TAI),33),new u(new O(2454832,43234,f.TAI),34),new u(new O(2456109,43235,f.TAI),35),new u(new O(2457204,43236,f.TAI),36)],O}),define("Core/clone",["./defaultValue"],function(e){"use strict";var r=function(t,n){if(null===t||"object"!=typeof t)return t;n=e(n,!1);var i=new t.constructor;for(var a in t)if(t.hasOwnProperty(a)){var o=t[a];n&&(o=r(o,n)),i[a]=o}return i};return r}),define("Core/parseResponseHeaders",[],function(){"use strict";var e=function(e){var r={};if(!e)return r;for(var t=e.split("\r\n"),n=0;n<t.length;++n){var i=t[n],a=i.indexOf(": ");if(a>0){var o=i.substring(0,a),u=i.substring(a+2);r[o]=u}}return r};return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,r){"use strict";var t=function(e,t,n){this.statusCode=e,this.response=t,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=r(this.responseHeaders))};return t.prototype.toString=function(){var r="Request has failed.";return e(this.statusCode)&&(r+=" Status Code: "+this.statusCode),r},t}),define("Core/loadWithXhr",["../ThirdParty/when","./defaultValue","./defined","./DeveloperError","./RequestErrorEvent","./RuntimeError"],function(e,r,t,n,i,a){"use strict";function o(e,r){var t=decodeURIComponent(r);return e?atob(t):t}function u(e,r){for(var t=o(e,r),n=new ArrayBuffer(t.length),i=new Uint8Array(n),a=0;a<t.length;a++)i[a]=t.charCodeAt(a);return n}function s(e,t){t=r(t,"");var i=e[1],a=!!e[2],s=e[3];switch(t){case"":case"text":return o(a,s);case"arraybuffer":return u(a,s);case"blob":var f=u(a,s);return new Blob([f],{type:i});case"document":var c=new DOMParser;return c.parseFromString(o(a,s),i);case"json":return JSON.parse(o(a,s));default:throw new n("Unhandled responseType: "+t)}}var f=function(i){if(i=r(i,r.EMPTY_OBJECT),!t(i.url))throw new n("options.url is required.");var a=i.responseType,o=r(i.method,"GET"),u=i.data,s=i.headers,c=i.overrideMimeType;return e(i.url,function(r){var t=e.defer();return f.load(r,a,o,u,s,t,c),t.promise})},c=/^data:(.*?)(;base64)?,(.*)$/;return f.load=function(e,r,n,o,u,f,l){var h=c.exec(e);if(null!==h)return void f.resolve(s(h,r));var d=new XMLHttpRequest;if(t(l)&&t(d.overrideMimeType)&&d.overrideMimeType(l),d.open(n,e,!0),t(u))for(var w in u)u.hasOwnProperty(w)&&d.setRequestHeader(w,u[w]);t(r)&&(d.responseType=r),d.onload=function(){200===d.status?t(d.response)?f.resolve(d.response):t(d.responseXML)&&d.responseXML.hasChildNodes()?f.resolve(d.responseXML):t(d.responseText)?f.resolve(d.responseText):f.reject(new a("unknown XMLHttpRequest response type.")):f.reject(new i(d.status,d.response,d.getAllResponseHeaders()))},d.onerror=function(e){f.reject(new i)},d.send(o)},f.defaultLoad=f.load,f}),define("Core/loadText",["./loadWithXhr"],function(e){"use strict";var r=function(r,t){return e({url:r,headers:t})};return r}),define("Core/loadJson",["./clone","./defined","./DeveloperError","./loadText"],function(e,r,t,n){"use strict";var i={Accept:"application/json,*/*;q=0.01"},a=function(a,o){if(!r(a))throw new t("url is required.");return r(o)?r(o.Accept)||(o=e(o),o.Accept=i.Accept):o=i,n(a,o).then(function(e){return JSON.parse(e)})};return a}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./loadJson","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,r,t,n,i,a,o,u,s,f,c,l){"use strict";function h(e,r){return o.compare(e.julianDate,r)}function d(e,t){if(!n(t.columnNames))return void(e._dataError="Error in loaded EOP data: The columnNames property is required.");if(!n(t.samples))return void(e._dataError="Error in loaded EOP data: The samples property is required.");var i=t.columnNames.indexOf("modifiedJulianDateUtc"),a=t.columnNames.indexOf("xPoleWanderRadians"),s=t.columnNames.indexOf("yPoleWanderRadians"),f=t.columnNames.indexOf("ut1MinusUtcSeconds"),d=t.columnNames.indexOf("xCelestialPoleOffsetRadians"),w=t.columnNames.indexOf("yCelestialPoleOffsetRadians"),E=t.columnNames.indexOf("taiMinusUtcSeconds");if(0>i||0>a||0>s||0>f||0>d||0>w||0>E)return void(e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns");var m=e._samples=t.samples,p=e._dates=[];e._dateColumn=i,e._xPoleWanderRadiansColumn=a,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=f,e._xCelestialPoleOffsetRadiansColumn=d,e._yCelestialPoleOffsetRadiansColumn=w,e._taiMinusUtcSecondsColumn=E,e._columnCount=t.columnNames.length,e._lastIndex=void 0;for(var _,y=e._addNewLeapSeconds,R=0,T=m.length;T>R;R+=e._columnCount){var v=m[R+i],A=m[R+E],S=v+c.MODIFIED_JULIAN_DATE_DIFFERENCE,g=new o(S,A,l.TAI);if(p.push(g),y){if(A!==_&&n(_)){var q=o.leapSeconds,N=r(q,g,h);if(0>N){var M=new u(g,A);q.splice(~N,0,M)}}_=A}}}function w(e,r,t,n,i){var a=t*n;i.xPoleWander=r[a+e._xPoleWanderRadiansColumn],i.yPoleWander=r[a+e._yPoleWanderRadiansColumn],i.xPoleOffset=r[a+e._xCelestialPoleOffsetRadiansColumn],i.yPoleOffset=r[a+e._yCelestialPoleOffsetRadiansColumn],i.ut1MinusUtc=r[a+e._ut1MinusUtcSecondsColumn]}function E(e,r,t){return r+e*(t-r)}function m(e,r,t,n,i,a,u){var s=e._columnCount;if(a>r.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var f=r[i],c=r[a];if(f.equals(c)||n.equals(f))return w(e,t,i,s,u),u;if(n.equals(c))return w(e,t,a,s,u),u;var l=o.secondsDifference(n,f)/o.secondsDifference(c,f),h=i*s,d=a*s,m=t[h+e._ut1MinusUtcSecondsColumn],p=t[d+e._ut1MinusUtcSecondsColumn],_=p-m;if(_>.5||-.5>_){var y=t[h+e._taiMinusUtcSecondsColumn],R=t[d+e._taiMinusUtcSecondsColumn];y!==R&&(c.equals(n)?m=p:p-=R-y)}return u.xPoleWander=E(l,t[h+e._xPoleWanderRadiansColumn],t[d+e._xPoleWanderRadiansColumn]),u.yPoleWander=E(l,t[h+e._yPoleWanderRadiansColumn],t[d+e._yPoleWanderRadiansColumn]),u.xPoleOffset=E(l,t[h+e._xCelestialPoleOffsetRadiansColumn],t[d+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=E(l,t[h+e._yCelestialPoleOffsetRadiansColumn],t[d+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=E(l,m,p),u}var p=function(r){if(r=t(r,t.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=t(r.addNewLeapSeconds,!0),n(r.data))d(this,r.data);else if(n(r.url)){var i=this;this._downloadPromise=e(s(r.url),function(e){d(i,e)},function(){i._dataError="An error occurred while retrieving the EOP data from the URL "+r.url+"."})}else d(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})};return p.NONE=a({getPromiseToLoad:function(){return e()},compute:function(e,r){return n(r)?(r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0):r=new i(0,0,0,0,0),r}}),p.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},p.prototype.compute=function(e,t){if(!n(this._samples)){if(n(this._dataError))throw new f(this._dataError);return void 0}if(n(t)||(t=new i(0,0,0,0,0)),0===this._samples.length)return t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0,t;var a=this._dates,u=this._lastIndex,s=0,c=0;if(n(u)){var l=a[u],h=a[u+1],d=o.lessThanOrEquals(l,e),w=!n(h),E=w||o.greaterThanOrEquals(h,e);if(d&&E)return s=u,!w&&h.equals(e)&&++s,c=s+1,m(this,a,this._samples,e,s,c,t),t}var p=r(a,e,o.compare,this._dateColumn);return p>=0?(p<a.length-1&&a[p+1].equals(e)&&++p,s=p,c=p):(c=~p,s=c-1,0>s&&(s=0)),this._lastIndex=s,m(this,a,this._samples,e,s,c,t),t},p}),define("ThirdParty/Uri",[],function(){function e(r){if(r instanceof e)this.scheme=r.scheme,this.authority=r.authority,this.path=r.path,this.query=r.query,this.fragment=r.fragment;else if(r){var t=n.exec(r);this.scheme=t[1],this.authority=t[2],this.path=t[3],this.query=t[4],this.fragment=t[5]}}function r(e){var r=unescape(e);return a.test(r)?r:e.toUpperCase()}function t(e,r,t,n){return(r||"")+t.toLowerCase()+(n||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var n=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(o,t).replace(i,r)),this.path&&(this.path=this.path.replace(i,r)),this.query&&(this.query=this.query.replace(i,r)),this.fragment&&(this.fragment=this.fragment.replace(i,r))};var i=/%[0-9a-z]{2}/gi,a=/[a-zA-Z0-9\-\._~]/,o=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(r){var t=new e;return this.scheme?(t.scheme=this.scheme,t.authority=this.authority,t.path=this.path,t.query=this.query):(t.scheme=r.scheme,this.authority?(t.authority=this.authority,t.path=this.path,t.query=this.query):(t.authority=r.authority,""==this.path?(t.path=r.path,t.query=this.query||r.query):("/"==this.path.charAt(0)?(t.path=this.path,t.removeDotSegments()):(r.authority&&""==r.path?t.path="/"+this.path:t.path=r.path.substring(0,r.path.lastIndexOf("/")+1)+this.path,t.removeDotSegments()),t.query=this.query))),t.fragment=this.fragment,t},e.prototype.removeDotSegments=function(){var e,r=this.path.split("/"),t=[],n=""==r[0];n&&r.shift();for(""==r[0]?r.shift():null;r.length;)e=r.shift(),".."==e?t.pop():"."!=e&&t.push(e);("."==e||".."==e)&&t.push(""),n&&t.unshift(""),this.path=t.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/buildModuleUrl",["../ThirdParty/Uri","./defined","./DeveloperError","require"],function(e,r,t,n){"use strict";function i(){for(var e=document.getElementsByTagName("script"),r=0,t=e.length;t>r;++r){var n=e[r].getAttribute("src"),i=l.exec(n);if(null!==i)return i[1]}return void 0}function a(){if(r(s))return s;var n;if(n="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:i(),!r(n))throw new t("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return s=new e(n).resolve(new e(document.location.href))}function o(e){return n.toUrl("../"+e)}function u(r){return new e(r).resolve(a()).toString()}var s,f,c,l=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i,h=function(e){r(f)||(f=r(n.toUrl)?o:u),r(c)||(c=document.createElement("a"));var t=f(e);return c.href=t,c.href=c.href,c.href};return h._cesiumScriptRegex=l,h.setBaseUrl=function(r){s=new e(r).resolve(new e(document.location.href))},h}),define("Core/Iau2006XysSample",[],function(){"use strict";var e=function(e,r,t){this.x=e,this.y=r,this.s=t};return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./loadJson","./TimeStandard"],function(e,r,t,n,i,a,o,u){"use strict";function s(e,r,t){var n=l;return n.dayNumber=r,n.secondsOfDay=t,a.daysDifference(n,e._sampleZeroDateTT)}function f(t,i){if(t._chunkDownloadsInProgress[i])return t._chunkDownloadsInProgress[i];var a=e.defer();t._chunkDownloadsInProgress[i]=a;var u,s=t._xysFileUrlTemplate;return u=n(s)?s.replace("{0}",i):r("Assets/IAU2006_XYS/IAU2006_XYS_"+i+".json"),e(o(u),function(e){t._chunkDownloadsInProgress[i]=!1;for(var r=t._samples,n=e.samples,o=i*t._samplesPerXysFile*3,u=0,s=n.length;s>u;++u)r[o+u]=n[u];a.resolve()}),a.promise}var c=function(e){e=t(e,t.EMPTY_OBJECT),this._xysFileUrlTemplate=e.xysFileUrlTemplate,this._interpolationOrder=t(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=t(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new a(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=t(e.stepSizeDays,1),this._samplesPerXysFile=t(e.samplesPerXysFile,1e3),this._totalSamples=t(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var r=this._interpolationOrder,n=this._denominators=new Array(r+1),i=this._xTable=new Array(r+1),o=Math.pow(this._stepSizeDays,r),s=0;r>=s;++s){n[s]=o,i[s]=s*this._stepSizeDays;for(var f=0;r>=f;++f)f!==s&&(n[s]*=s-f);n[s]=1/n[s]}this._work=new Array(r+1),this._coef=new Array(r+1)},l=new a(0,0,u.TAI);return c.prototype.preload=function(r,t,n,i){var a=s(this,r,t),o=s(this,n,i),u=a/this._stepSizeDays-this._interpolationOrder/2|0;0>u&&(u=0);var c=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;c>=this._totalSamples&&(c=this._totalSamples-1);for(var l=u/this._samplesPerXysFile|0,h=c/this._samplesPerXysFile|0,d=[],w=l;h>=w;++w)d.push(f(this,w));return e.all(d)},c.prototype.computeXysRadians=function(e,r,t){var a=s(this,e,r);if(0>a)return void 0;var o=a/this._stepSizeDays|0;if(o>=this._totalSamples)return void 0;var u=this._interpolationOrder,c=o-(u/2|0);0>c&&(c=0);var l=c+u;l>=this._totalSamples&&(l=this._totalSamples-1,c=l-u,0>c&&(c=0));var h=!1,d=this._samples;if(n(d[3*c])||(f(this,c/this._samplesPerXysFile|0),h=!0),n(d[3*l])||(f(this,l/this._samplesPerXysFile|0),h=!0),h)return void 0;n(t)?(t.x=0,t.y=0,t.s=0):t=new i(0,0,0);var w,E,m=a-c*this._stepSizeDays,p=this._work,_=this._denominators,y=this._coef,R=this._xTable;for(w=0;u>=w;++w)p[w]=m-R[w];for(w=0;u>=w;++w){for(y[w]=1,E=0;u>=E;++E)E!==w&&(y[w]*=p[E]);y[w]*=_[w];var T=3*(c+w);t.x+=y[w]*d[T++],t.y+=y[w]*d[T++],t.s+=y[w]*d[T]}return t},c}),define("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,r,t,n,i,a,o,u){"use strict";var s=function(e,t,n,i){this.x=r(e,0),this.y=r(t,0),this.z=r(n,0),this.w=r(i,0)},f=new e;s.fromAxisAngle=function(r,i,a){if(!t(r))throw new n("axis is required.");if("number"!=typeof i)throw new n("angle is required and must be a number.");var o=i/2,u=Math.sin(o);f=e.normalize(r,f);var c=f.x*u,l=f.y*u,h=f.z*u,d=Math.cos(o);return t(a)?(a.x=c,a.y=l,a.z=h,a.w=d,a):new s(c,l,h,d)};var c=[1,2,0],l=new Array(3);s.fromRotationMatrix=function(e,r){if(!t(e))throw new n("matrix is required.");var i,a,o,f,h,d=e[u.COLUMN0ROW0],w=e[u.COLUMN1ROW1],E=e[u.COLUMN2ROW2],m=d+w+E;if(m>0)i=Math.sqrt(m+1),h=.5*i,i=.5/i,a=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*i,o=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*i,f=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*i;else{var p=c,_=0;w>d&&(_=1),E>d&&E>w&&(_=2);var y=p[_],R=p[y];i=Math.sqrt(e[u.getElementIndex(_,_)]-e[u.getElementIndex(y,y)]-e[u.getElementIndex(R,R)]+1);var T=l;T[_]=.5*i,i=.5/i,h=(e[u.getElementIndex(R,y)]-e[u.getElementIndex(y,R)])*i,T[y]=(e[u.getElementIndex(y,_)]+e[u.getElementIndex(_,y)])*i,T[R]=(e[u.getElementIndex(R,_)]+e[u.getElementIndex(_,R)])*i,a=-T[0],o=-T[1],f=-T[2]}return t(r)?(r.x=a,r.y=o,r.z=f,r.w=h,r):new s(a,o,f,h)};var h=new s;s.fromHeadingPitchRoll=function(r,i,a,o){if(!t(r))throw new n("heading is required.");if(!t(i))throw new n("pitch is required.");if(!t(a))throw new n("roll is required.");var u=s.fromAxisAngle(e.UNIT_X,a,h),f=s.fromAxisAngle(e.UNIT_Y,-i,o);o=s.multiply(f,u,f);var c=s.fromAxisAngle(e.UNIT_Z,-r,h);return s.multiply(c,o,o)};var d=new e,w=new e,E=new s,m=new s,p=new s;s.packedLength=4,s.pack=function(e,i,a){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");a=r(a,0),i[a++]=e.x,i[a++]=e.y,i[a++]=e.z,i[a]=e.w},s.unpack=function(e,i,a){if(!t(e))throw new n("array is required");return i=r(i,0),t(a)||(a=new s),a.x=e[i],a.y=e[i+1],a.z=e[i+2],a.w=e[i+3],a},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,r,t,n){s.unpack(e,4*t,p),s.conjugate(p,p);for(var i=0,a=t-r+1;a>i;i++){var o=3*i;s.unpack(e,4*(r+i),E),s.multiply(E,p,E),E.w<0&&s.negate(E,E),s.computeAxis(E,d);var u=s.computeAngle(E);n[o]=d.x*u,n[o+1]=d.y*u,n[o+2]=d.z*u}},s.unpackInterpolationResult=function(r,n,i,a,o){t(o)||(o=new s),e.fromArray(r,0,w);var u=e.magnitude(w);return s.unpack(n,4*a,m),0===u?s.clone(s.IDENTITY,E):s.fromAxisAngle(w,u,E),s.multiply(E,m,o)},s.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,r){if(!t(e))throw new n("quaternion is required");if(!t(r))throw new n("result is required");return r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=e.w,r},s.magnitudeSquared=function(e){if(!t(e))throw new n("quaternion is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,r){if(!t(r))throw new n("result is required");var i=1/s.magnitude(e),a=e.x*i,o=e.y*i,u=e.z*i,f=e.w*i;return r.x=a,r.y=o,r.z=u,r.w=f,r},s.inverse=function(e,r){if(!t(r))throw new n("result is required");var i=s.magnitudeSquared(e);return r=s.conjugate(e,r),s.multiplyByScalar(r,1/i,r)},s.add=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i.x=e.x+r.x,i.y=e.y+r.y,i.z=e.z+r.z,i.w=e.w+r.w,i},s.subtract=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i.x=e.x-r.x,i.y=e.y-r.y,i.z=e.z-r.z,i.w=e.w-r.w,i},s.negate=function(e,r){if(!t(e))throw new n("quaternion is required");if(!t(r))throw new n("result is required");return r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r},s.dot=function(e,r){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");return e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w},s.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");var a=e.x,o=e.y,u=e.z,s=e.w,f=r.x,c=r.y,l=r.z,h=r.w,d=s*f+a*h+o*l-u*c,w=s*c-a*l+o*h+u*f,E=s*l+a*c-o*f+u*h,m=s*h-a*f-o*c-u*l;return i.x=d,i.y=w,i.z=E,i.w=m,i},s.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("quaternion is required");if("number"!=typeof r)throw new n("scalar is required and must be a number.");if(!t(i))throw new n("result is required");return i.x=e.x*r,i.y=e.y*r,i.z=e.z*r,i.w=e.w*r,i},s.divideByScalar=function(e,r,i){if(!t(e))throw new n("quaternion is required");if("number"!=typeof r)throw new n("scalar is required and must be a number.");if(!t(i))throw new n("result is required");return i.x=e.x/r,i.y=e.y/r,i.z=e.z/r,i.w=e.w/r,i},s.computeAxis=function(e,r){if(!t(e))throw new n("quaternion is required");if(!t(r))throw new n("result is required");var i=e.w;if(Math.abs(i-1)<o.EPSILON6)return r.x=r.y=r.z=0,r;var a=1/Math.sqrt(1-i*i);return r.x=e.x*a,r.y=e.y*a,r.z=e.z*a,r},s.computeAngle=function(e){if(!t(e))throw new n("quaternion is required");return Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var _=new s;s.lerp=function(e,r,i,a){if(!t(e))throw new n("start is required.");if(!t(r))throw new n("end is required.");if("number"!=typeof i)throw new n("t is required and must be a number.");if(!t(a))throw new n("result is required");return _=s.multiplyByScalar(r,i,_),a=s.multiplyByScalar(e,1-i,a),s.add(_,a,a)};var y=new s,R=new s,T=new s;s.slerp=function(e,r,i,a){if(!t(e))throw new n("start is required.");if(!t(r))throw new n("end is required.");if("number"!=typeof i)throw new n("t is required and must be a number.");if(!t(a))throw new n("result is required");var u=s.dot(e,r),f=r;if(0>u&&(u=-u,f=y=s.negate(r,y)),1-u<o.EPSILON6)return s.lerp(e,f,i,a);var c=Math.acos(u);return R=s.multiplyByScalar(e,Math.sin((1-i)*c),R),T=s.multiplyByScalar(f,Math.sin(i*c),T),a=s.add(R,T,a),s.multiplyByScalar(a,1/Math.sin(c),a)},s.log=function(r,i){if(!t(r))throw new n("quaternion is required.");if(!t(i))throw new n("result is required");var a=o.acosClamped(r.w),u=0;return 0!==a&&(u=a/Math.sin(a)),e.multiplyByScalar(r,u,i)},s.exp=function(r,i){if(!t(r))throw new n("cartesian is required.");if(!t(i))throw new n("result is required");var a=e.magnitude(r),o=0;return 0!==a&&(o=Math.sin(a)/a),i.x=r.x*o,i.y=r.y*o,i.z=r.z*o,i.w=Math.cos(a),i};var v=new e,A=new e,S=new s,g=new s;s.computeInnerQuadrangle=function(r,i,a,o){if(!t(r)||!t(i)||!t(a))throw new n("q0, q1, and q2 are required.");if(!t(o))throw new n("result is required");var u=s.conjugate(i,S);s.multiply(u,a,g);var f=s.log(g,v);s.multiply(u,r,g);var c=s.log(g,A);return e.add(f,c,f),e.multiplyByScalar(f,.25,f),e.negate(f,f),s.exp(f,S),s.multiply(i,S,o)},s.squad=function(e,r,i,a,o,u){if(!(t(e)&&t(r)&&t(i)&&t(a)))throw new n("q0, q1, s0, and s1 are required.");if("number"!=typeof o)throw new n("t is required and must be a number.");if(!t(u))throw new n("result is required");var f=s.slerp(e,r,o,S),c=s.slerp(i,a,o,g);return s.slerp(f,c,2*o*(1-o),u)};for(var q=new s,N=1.9011074535173003,M=i.supportsTypedArrays()?new Float32Array(8):[],O=i.supportsTypedArrays()?new Float32Array(8):[],I=i.supportsTypedArrays()?new Float32Array(8):[],x=i.supportsTypedArrays()?new Float32Array(8):[],C=0;7>C;++C){var P=C+1,b=2*P+1;M[C]=1/(P*b),O[C]=P/b}return M[7]=N/136,O[7]=8*N/17,s.fastSlerp=function(e,r,i,a){if(!t(e))throw new n("start is required.");if(!t(r))throw new n("end is required.");if("number"!=typeof i)throw new n("t is required and must be a number.");if(!t(a))throw new n("result is required");var o,u=s.dot(e,r);u>=0?o=1:(o=-1,u=-u);for(var f=u-1,c=1-i,l=i*i,h=c*c,d=7;d>=0;--d)I[d]=(M[d]*l-O[d])*f,x[d]=(M[d]*h-O[d])*f;var w=o*i*(1+I[0]*(1+I[1]*(1+I[2]*(1+I[3]*(1+I[4]*(1+I[5]*(1+I[6]*(1+I[7])))))))),E=c*(1+x[0]*(1+x[1]*(1+x[2]*(1+x[3]*(1+x[4]*(1+x[5]*(1+x[6]*(1+x[7])))))))),m=s.multiplyByScalar(e,E,q);return s.multiplyByScalar(r,w,a),s.add(m,a,a)},s.fastSquad=function(e,r,i,a,o,u){if(!(t(e)&&t(r)&&t(i)&&t(a)))throw new n("q0, q1, s0, and s1 are required.");if("number"!=typeof o)throw new n("t is required and must be a number.");if(!t(u))throw new n("result is required");var f=s.fastSlerp(e,r,o,S),c=s.fastSlerp(i,a,o,g);return s.fastSlerp(f,c,2*o*(1-o),u)},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},s.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon is required and must be a number.");return e===r||t(e)&&t(r)&&Math.abs(e.x-r.x)<=i&&Math.abs(e.y-r.y)<=i&&Math.abs(e.z-r.z)<=i&&Math.abs(e.w-r.w)<=i},s.ZERO=a(new s(0,0,0,0)),s.IDENTITY=a(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,r){return s.equalsEpsilon(this,e,r)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],function(e,r,t,n,i,a,o,u,s,f,c,l,h,d,w,E,m,p){"use strict";var _={},y=new t,R=new t,T=new t;_.eastNorthUpToFixedFrame=function(e,r,n){if(!a(e))throw new o("origin is required.");if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var u=d.sign(e.z);return a(n)?(n[0]=0,n[1]=1,n[2]=0,n[3]=0,n[4]=-u,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=u,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new E(0,-u,0,e.x,1,0,0,e.y,0,0,u,e.z,0,0,0,1)}var s=y,c=R,l=T;return r=i(r,f.WGS84),r.geodeticSurfaceNormal(e,s),c.x=-e.y,c.y=e.x,c.z=0,t.normalize(c,c),t.cross(s,c,l),a(n)?(n[0]=c.x,n[1]=c.y,n[2]=c.z,n[3]=0,n[4]=l.x,n[5]=l.y,n[6]=l.z,n[7]=0,n[8]=s.x,n[9]=s.y,n[10]=s.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new E(c.x,l.x,s.x,e.x,c.y,l.y,s.y,e.y,c.z,l.z,s.z,e.z,0,0,0,1)};var v=new t,A=new t,S=new t;_.northEastDownToFixedFrame=function(e,r,n){if(!a(e))throw new o("origin is required.");if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var u=d.sign(e.z);return a(n)?(n[0]=-u,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=1,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=-u,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new E(-u,0,0,e.x,0,1,0,e.y,0,0,-u,e.z,0,0,0,1)}var s=v,c=A,l=S;return r=i(r,f.WGS84),r.geodeticSurfaceNormal(e,s),c.x=-e.y,c.y=e.x,c.z=0,t.normalize(c,c),t.cross(s,c,l),a(n)?(n[0]=l.x,n[1]=l.y,n[2]=l.z,n[3]=0,n[4]=c.x,n[5]=c.y,n[6]=c.z,n[7]=0,n[8]=-s.x,n[9]=-s.y,n[10]=-s.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new E(l.x,c.x,-s.x,e.x,l.y,c.y,-s.y,e.y,l.z,c.z,-s.z,e.z,0,0,0,1)},_.northUpEastToFixedFrame=function(e,r,n){if(!a(e))throw new o("origin is required.");if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var u=d.sign(e.z);return a(n)?(n[0]=-u,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=u,n[7]=0,n[8]=0,n[9]=1,n[10]=0,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new E(-u,0,0,e.x,0,0,1,e.y,0,u,0,e.z,0,0,0,1)}var s=y,c=R,l=T;return r=i(r,f.WGS84),r.geodeticSurfaceNormal(e,s),c.x=-e.y,c.y=e.x,c.z=0,t.normalize(c,c),t.cross(s,c,l),a(n)?(n[0]=l.x,n[1]=l.y,n[2]=l.z,n[3]=0,n[4]=s.x,n[5]=s.y,n[6]=s.z,n[7]=0,n[8]=c.x,n[9]=c.y,n[10]=c.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new E(l.x,s.x,c.x,e.x,l.y,s.y,c.y,e.y,l.z,s.z,c.z,e.z,0,0,0,1)};var g=new m,q=new t(1,1,1),N=new E;_.headingPitchRollToFixedFrame=function(e,r,n,i,a,o){var u=m.fromHeadingPitchRoll(r,n,i,g),s=E.fromTranslationQuaternionRotationScale(t.ZERO,u,q,N);return o=_.eastNorthUpToFixedFrame(e,a,o),E.multiply(o,s,o)};var M=new E,O=new w;_.headingPitchRollQuaternion=function(e,r,t,n,i,a){var o=_.headingPitchRollToFixedFrame(e,r,t,n,i,M),u=E.getRotation(o,O);return m.fromRotationMatrix(u,a)};var I=24110.54841,x=8640184.812866,C=.093104,P=-62e-7,b=1.1772758384668e-19,D=72921158553e-15,U=d.TWO_PI/86400,L=new h;_.computeTemeToPseudoFixedMatrix=function(e,r){if(!a(e))throw new o("date is required.");L=h.addSeconds(e,-h.computeTaiMinusUtc(e),L);var t,n=L.dayNumber,i=L.secondsOfDay,u=n-2451545;t=i>=43200?(u+.5)/p.DAYS_PER_JULIAN_CENTURY:(u-.5)/p.DAYS_PER_JULIAN_CENTURY;var s=I+t*(x+t*(C+t*P)),f=s*U%d.TWO_PI,c=D+b*(n-2451545.5),l=(i+.5*p.SECONDS_PER_DAY)%p.SECONDS_PER_DAY,E=f+c*l,m=Math.cos(E),_=Math.sin(E);return a(r)?(r[0]=m,r[1]=-_,r[2]=0,r[3]=_,r[4]=m,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new w(m,_,0,-_,m,0,0,0,1)},_.iau2006XysData=new c,_.earthOrientationParameters=u.NONE;var F=32.184,B=2451545;_.preloadIcrfFixed=function(r){var t=r.start.dayNumber,n=r.start.secondsOfDay+F,i=r.stop.dayNumber,a=r.stop.secondsOfDay+F,o=_.iau2006XysData.preload(t,n,i,a),u=_.earthOrientationParameters.getPromiseToLoad();return e.all([o,u])},_.computeIcrfToFixedMatrix=function(e,r){if(!a(e))throw new o("date is required.");a(r)||(r=new w);var t=_.computeFixedToIcrfMatrix(e,r);return a(t)?w.transpose(t,r):void 0};var z=new l(0,0,0),G=new s(0,0,0,0,0,0),W=new w,X=new w;_.computeFixedToIcrfMatrix=function(e,r){if(!a(e))throw new o("date is required.");a(r)||(r=new w);var t=_.earthOrientationParameters.compute(e,G);if(!a(t))return void 0;var n=e.dayNumber,i=e.secondsOfDay+F,u=_.iau2006XysData.computeXysRadians(n,i,z);if(!a(u))return void 0;var s=u.x+t.xPoleOffset,f=u.y+t.yPoleOffset,c=1/(1+Math.sqrt(1-s*s-f*f)),l=W;l[0]=1-c*s*s,l[3]=-c*s*f,l[6]=s,l[1]=-c*s*f,l[4]=1-c*f*f,l[7]=f,l[2]=-s,l[5]=-f,l[8]=1-c*(s*s+f*f);var E=w.fromRotationZ(-u.s,X),m=w.multiply(l,E,W),y=e.dayNumber,R=e.secondsOfDay-h.computeTaiMinusUtc(e)+t.ut1MinusUtc,T=y-2451545,v=R/p.SECONDS_PER_DAY,A=.779057273264+v+.00273781191135448*(T+v);A=A%1*d.TWO_PI;var S=w.fromRotationZ(A,X),g=w.multiply(m,S,W),q=Math.cos(t.xPoleWander),N=Math.cos(t.yPoleWander),M=Math.sin(t.xPoleWander),O=Math.sin(t.yPoleWander),I=n-B+i/p.SECONDS_PER_DAY;I/=36525;var x=-47e-6*I*d.RADIANS_PER_DEGREE/3600,C=Math.cos(x),P=Math.sin(x),b=X;return b[0]=q*C,b[1]=q*P,b[2]=M,b[3]=-N*P+O*M*C,b[4]=N*C+O*M*P,b[5]=-O*q,b[6]=-O*P-N*M*C,b[7]=O*C-N*M*P,b[8]=N*q,w.multiply(g,b,r)};var H=new n;_.pointToWindowCoordinates=function(e,r,t,n){return n=_.pointToGLWindowCoordinates(e,r,t,n),n.y=2*r[5]-n.y,n},_.pointToGLWindowCoordinates=function(e,t,i,u){if(!a(e))throw new o("modelViewProjectionMatrix is required.");if(!a(t))throw new o("viewportTransformation is required.");
if(!a(i))throw new o("point is required.");a(u)||(u=new r);var s=H;return E.multiplyByVector(e,n.fromElements(i.x,i.y,i.z,1,s),s),n.multiplyByScalar(s,1/s.w,s),E.multiplyByVector(t,s,s),r.fromCartesian4(s,u)};var V=new t,Y=new t,j=new t;return _.rotationMatrixFromPositionVelocity=function(e,r,n,u){if(!a(e))throw new o("position is required.");if(!a(r))throw new o("velocity is required.");var s=i(n,f.WGS84).geodeticSurfaceNormal(e,V),c=t.cross(r,s,Y);t.equalsEpsilon(c,t.ZERO,d.EPSILON6)&&(c=t.clone(t.UNIT_X,c));var l=t.cross(c,r,j);return t.cross(r,l,c),t.negate(c,c),a(u)||(u=new w),u[0]=r.x,u[1]=r.y,u[2]=r.z,u[3]=c.x,u[4]=c.y,u[5]=c.z,u[6]=l.x,u[7]=l.y,u[8]=l.z,u},_}),define("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix3","./Matrix4","./Plane","./Ray","./Transforms"],function(e,r,t,n,i,a,o,u,s,f,c,l,h,d,w){"use strict";var E=new n,m=function(e,r){if(!a(e))throw new u("origin is required.");if(r=i(r,s.WGS84),e=r.scaleToGeodeticSurface(e),!a(e))throw new u("origin must not be at the center of the ellipsoid.");var n=w.eastNorthUpToFixedFrame(e,r);this._ellipsoid=r,this._origin=e,this._xAxis=t.fromCartesian4(l.getColumn(n,0,E)),this._yAxis=t.fromCartesian4(l.getColumn(n,1,E));var o=t.fromCartesian4(l.getColumn(n,2,E));this._plane=h.fromPointNormal(e,o)};o(m.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}},plane:{get:function(){return this._plane}},xAxis:{get:function(){return this._xAxis}},yAxis:{get:function(){return this._yAxis}},zAxis:{get:function(){return this._plane.normal}}});var p=new e;m.fromPoints=function(r,t){if(!a(r))throw new u("cartesians is required.");var n=e.fromPoints(r,p);return new m(n.center,t)};var _=new d,y=new t;m.prototype.projectPointOntoPlane=function(e,n){if(!a(e))throw new u("cartesian is required.");var i=_;i.origin=e,t.normalize(e,i.direction);var o=f.rayPlane(i,this._plane,y);if(a(o)||(t.negate(i.direction,i.direction),o=f.rayPlane(i,this._plane,y)),a(o)){var s=t.subtract(o,this._origin,o),c=t.dot(this._xAxis,s),l=t.dot(this._yAxis,s);return a(n)?(n.x=c,n.y=l,n):new r(c,l)}return void 0},m.prototype.projectPointsOntoPlane=function(e,r){if(!a(e))throw new u("cartesians is required.");a(r)||(r=[]);for(var t=0,n=e.length,i=0;n>i;i++){var o=this.projectPointOntoPlane(e[i],r[t]);a(o)&&(r[t]=o,t++)}return r.length=t,r},m.prototype.projectPointToNearestOnPlane=function(e,n){if(!a(e))throw new u("cartesian is required.");a(n)||(n=new r);var i=_;i.origin=e,t.clone(this._plane.normal,i.direction);var o=f.rayPlane(i,this._plane,y);a(o)||(t.negate(i.direction,i.direction),o=f.rayPlane(i,this._plane,y));var s=t.subtract(o,this._origin,o),c=t.dot(this._xAxis,s),l=t.dot(this._yAxis,s);return n.x=c,n.y=l,n},m.prototype.projectPointsToNearestOnPlane=function(e,r){if(!a(e))throw new u("cartesians is required.");a(r)||(r=[]);var t=e.length;r.length=t;for(var n=0;t>n;n++)r[n]=this.projectPointToNearestOnPlane(e[n],r[n]);return r};var R=new t;return m.prototype.projectPointsOntoEllipsoid=function(e,r){if(!a(e))throw new u("cartesians is required.");var n=e.length;a(r)?r.length=n:r=new Array(n);for(var i=this._ellipsoid,o=this._origin,s=this._xAxis,f=this._yAxis,c=R,l=0;n>l;++l){var h=e[l];t.multiplyByScalar(s,h.x,c),a(r[l])||(r[l]=new t);var d=t.add(o,c,r[l]);t.multiplyByScalar(f,h.y,c),t.add(d,c,d),i.scaleToGeocentricSurface(d,d)}return r},m}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i=new r,a=new r,o=new r,u=function(u,s,f,c,l){if(!(t(u)&&t(s)&&t(f)&&t(c)))throw new n("point, p0, p1, and p2 are required.");t(l)||(l=new r);var h,d,w,E,m,p,_,y;t(s.z)?(h=r.subtract(f,s,i),d=r.subtract(c,s,a),w=r.subtract(u,s,o),E=r.dot(h,h),m=r.dot(h,d),p=r.dot(h,w),_=r.dot(d,d),y=r.dot(d,w)):(h=e.subtract(f,s,i),d=e.subtract(c,s,a),w=e.subtract(u,s,o),E=e.dot(h,h),m=e.dot(h,d),p=e.dot(h,w),_=e.dot(d,d),y=e.dot(d,w));var R=1/(E*_-m*m);return l.y=(_*p-m*y)*R,l.z=(E*y-m*p)*R,l.x=1-l.y-l.z,l};return u}),define("Core/pointInsideTriangle",["./barycentricCoordinates","./Cartesian3"],function(e,r){"use strict";var t=new r,n=function(r,n,i,a){return e(r,n,i,a,t),t.x>0&&t.y>0&&t.z>0};return n}),define("Core/EllipsoidGeodesic",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,r,t,n,i,a,o,u){"use strict";function s(e){var r=e._uSquared,t=e._ellipsoid.maximumRadius,n=e._ellipsoid.minimumRadius,i=(t-n)/t,a=Math.cos(e._startHeading),o=Math.sin(e._startHeading),u=(1-i)*Math.tan(e._start.latitude),s=1/Math.sqrt(1+u*u),f=s*u,c=Math.atan2(u,a),l=s*o,h=l*l,d=1-h,w=Math.sqrt(d),E=r/4,m=E*E,p=m*E,_=m*m,y=1+E-3*m/4+5*p/4-175*_/64,R=1-E+15*m/8-35*p/8,T=1-3*E+35*m/4,v=1-5*E,A=y*c-R*Math.sin(2*c)*E/2-T*Math.sin(4*c)*m/16-v*Math.sin(6*c)*p/48-5*Math.sin(8*c)*_/512,S=e._constants;S.a=t,S.b=n,S.f=i,S.cosineHeading=a,S.sineHeading=o,S.tanU=u,S.cosineU=s,S.sineU=f,S.sigma=c,S.sineAlpha=l,S.sineSquaredAlpha=h,S.cosineSquaredAlpha=d,S.cosineAlpha=w,S.u2Over4=E,S.u4Over16=m,S.u6Over64=p,S.u8Over256=_,S.a0=y,S.a1=R,S.a2=T,S.a3=v,S.distanceRatio=A}function f(e,r){return e*r*(4+e*(4-3*r))/16}function c(e,r,t,n,i,a,o){var u=f(e,t);return(1-u)*e*r*(n+u*i*(o+u*a*(2*o*o-1)))}function l(e,r,t,n,i,a,o){var s,f,l,h,d,w=(r-t)/r,E=a-n,m=Math.atan((1-w)*Math.tan(i)),p=Math.atan((1-w)*Math.tan(o)),_=Math.cos(m),y=Math.sin(m),R=Math.cos(p),T=Math.sin(p),v=_*R,A=_*T,S=y*T,g=y*R,q=E,N=u.TWO_PI,M=Math.cos(q),O=Math.sin(q);do{M=Math.cos(q),O=Math.sin(q);var I=A-g*M;l=Math.sqrt(R*R*O*O+I*I),f=S+v*M,s=Math.atan2(l,f);var x;0===l?(x=0,h=1):(x=v*O/l,h=1-x*x),N=q,d=f-2*S/h,isNaN(d)&&(d=0),q=E+c(w,x,h,s,l,f,d)}while(Math.abs(q-N)>u.EPSILON12);var C=h*(r*r-t*t)/(t*t),P=1+C*(4096+C*(C*(320-175*C)-768))/16384,b=C*(256+C*(C*(74-47*C)-128))/1024,D=d*d,U=b*l*(d+b*(f*(2*D-1)-b*d*(4*l*l-3)*(4*D-3)/6)/4),L=t*P*(s-U),F=Math.atan2(R*O,A-g*M),B=Math.atan2(_*O,A*M-g);e._distance=L,e._startHeading=F,e._endHeading=B,e._uSquared=C}function h(t,n,i,o){var u=e.normalize(o.cartographicToCartesian(n,w),d),f=e.normalize(o.cartographicToCartesian(i,w),w);if(Math.abs(Math.abs(e.angleBetween(u,f))-Math.PI)<.0125)throw new a("geodesic position is not unique");l(t,o.maximumRadius,o.minimumRadius,n.longitude,n.latitude,i.longitude,i.latitude),t._start=r.clone(n,t._start),t._end=r.clone(i,t._end),t._start.height=0,t._end.height=0,s(t)}var d=new e,w=new e,E=function(e,i,a){var u=t(a,o.WGS84);this._ellipsoid=u,this._start=new r,this._end=new r,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,n(e)&&n(i)&&h(this,e,i,u)};return i(E.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){if(!n(this._distance))throw new a("set end positions before getting surfaceDistance");return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){if(!n(this._distance))throw new a("set end positions before getting startHeading");return this._startHeading}},endHeading:{get:function(){if(!n(this._distance))throw new a("set end positions before getting endHeading");return this._endHeading}}}),E.prototype.setEndPoints=function(e,r){if(!n(e))throw new a("start cartographic position is required");if(!n(r))throw new a("end cartgraphic position is required");h(this,e,r,this._ellipsoid)},E.prototype.interpolateUsingFraction=function(e,r){return this.interpolateUsingSurfaceDistance(this._distance*e,r)},E.prototype.interpolateUsingSurfaceDistance=function(e,t){if(!n(this._distance))throw new a("start and end must be set before calling funciton interpolateUsingSurfaceDistance");var i=this._constants,o=i.distanceRatio+e/i.b,u=Math.cos(2*o),s=Math.cos(4*o),f=Math.cos(6*o),l=Math.sin(2*o),h=Math.sin(4*o),d=Math.sin(6*o),w=Math.sin(8*o),E=o*o,m=o*E,p=i.u8Over256,_=i.u2Over4,y=i.u6Over64,R=i.u4Over16,T=2*m*p*u/3+o*(1-_+7*R/4-15*y/4+579*p/64-(R-15*y/4+187*p/16)*u-(5*y/4-115*p/16)*s-29*p*f/16)+(_/2-R+71*y/32-85*p/16)*l+(5*R/16-5*y/4+383*p/96)*h-E*((y-11*p/2)*l+5*p*h/2)+(29*y/96-29*p/16)*d+539*p*w/1536,v=Math.asin(Math.sin(T)*i.cosineAlpha),A=Math.atan(i.a/i.b*Math.tan(v));T-=i.sigma;var S=Math.cos(2*i.sigma+T),g=Math.sin(T),q=Math.cos(T),N=i.cosineU*q,M=i.sineU*g,O=Math.atan2(g*i.sineHeading,N-M*i.cosineHeading),I=O-c(i.f,i.sineAlpha,i.cosineSquaredAlpha,T,g,q,S);return n(t)?(t.longitude=this._start.longitude+I,t.latitude=A,t.height=0,t):new r(this._start.longitude+I,A,0)},E}),define("Core/isArray",["./defined"],function(e){"use strict";var r=Array.isArray;return e(r)||(r=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),r}),define("Core/PolylinePipeline",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidGeodesic","./IntersectionTests","./isArray","./Math","./Matrix4","./Plane"],function(e,r,t,n,i,a,o,u,s,f,c,l){"use strict";function h(e,r,t){var n=S;n.length=e;var i;if(r===t){for(i=0;e>i;i++)n[i]=r;return n}var a=t-r,o=a/e;for(i=0;e>i;i++){var u=r+i*o;n[i]=u}return n}function d(r,t,n,i,a,o,u,s){var f=i.scaleToGeodeticSurface(r,M),c=i.scaleToGeodeticSurface(t,O),l=w.numberOfPoints(r,t,n),d=i.cartesianToCartographic(f,g),E=i.cartesianToCartographic(c,q),m=h(l,a,o);I.setEndPoints(d,E);var p=I.surfaceDistance/l,_=s;d.height=a;var y=i.cartographicToCartesian(d,N);e.pack(y,u,_),_+=3;for(var R=1;l>R;R++){var T=I.interpolateUsingSurfaceDistance(R*p,q);T.height=m[R],y=i.cartographicToCartesian(T,N),e.pack(y,u,_),_+=3}return _}var w={};w.numberOfPoints=function(r,t,n){var i=e.distance(r,t);return Math.ceil(i/n)};var E=new r;w.extractHeights=function(e,r){for(var t=e.length,n=new Array(t),i=0;t>i;i++){var a=e[i];n[i]=r.cartesianToCartographic(a,E).height}return n};var m=new c,p=new e,_=new e,y=new l(e.ZERO,0),R=new e,T=new l(e.ZERO,0),v=new e,A=new e,S=[],g=new r,q=new r,N=new e,M=new e,O=new e,I=new o;w.wrapLongitude=function(r,i){var a=[],o=[];if(n(r)&&r.length>0){i=t(i,c.IDENTITY);var s=c.inverseTransformation(i,m),f=c.multiplyByPoint(s,e.ZERO,p),h=c.multiplyByPointAsVector(s,e.UNIT_Y,_),d=l.fromPointNormal(f,h,y),w=c.multiplyByPointAsVector(s,e.UNIT_X,R),E=l.fromPointNormal(f,w,T),S=1;a.push(e.clone(r[0]));for(var g=a[0],q=r.length,N=1;q>N;++N){var M=r[N];if(l.getPointDistance(E,g)<0||l.getPointDistance(E,M)<0){var O=u.lineSegmentPlane(g,M,d,v);if(n(O)){var I=e.multiplyByScalar(h,5e-9,A);l.getPointDistance(d,g)<0&&e.negate(I,I),a.push(e.add(O,I,new e)),o.push(S+1),e.negate(I,I),a.push(e.add(O,I,new e)),S=1}}a.push(e.clone(r[N])),S++,g=M}o.push(S)}return{positions:a,lengths:o}};var x=f.EPSILON7;return w.removeDuplicates=function(r){if(!n(r))throw new i("positions is required.");var t=r.length;if(2>t)return r;var a,o,u;for(a=1;t>a&&(o=r[a-1],u=r[a],!e.equalsEpsilon(o,u,x));++a);if(a===t)return r;for(var s=r.slice(0,a);t>a;++a)u=r[a],e.equalsEpsilon(o,u,x)||(s.push(e.clone(u)),o=u);return s},w.generateArc=function(r){n(r)||(r={});var o=r.positions;if(!n(o))throw new i("options.positions is required.");var u=o.length,c=t(r.ellipsoid,a.WGS84),l=t(r.height,0);if(1>u)return[];if(1===u){var h=c.scaleToGeodeticSurface(o[0],M);if(0!==l){var E=c.geodeticSurfaceNormal(h,N);e.multiplyByScalar(E,l,E),e.add(h,E,h)}return[h.x,h.y,h.z]}var m=r.minDistance;if(!n(m)){var p=t(r.granularity,f.RADIANS_PER_DEGREE);m=f.chordLength(p,c.maximumRadius)}var _,y=0;for(_=0;u-1>_;_++)y+=w.numberOfPoints(o[_],o[_+1],m);var R=3*(y+1),T=new Array(R),v=0,A=s(l);for(_=0;u-1>_;_++){var q=o[_],O=o[_+1],I=A?l[_]:l,x=A?l[_+1]:l;v=d(q,O,m,c,I,x,T,v)}S.length=0;var C=o[u-1],P=c.cartesianToCartographic(C,g);P.height=A?l[u-1]:l;var b=c.cartographicToCartesian(P,N);return e.pack(b,T,R-3),T},w.generateCartesianArc=function(r){for(var t=w.generateArc(r),n=t.length/3,i=new Array(n),a=0;n>a;a++)i[a]=e.unpack(t,3*a);return i},w}),define("Core/Queue",[],function(){"use strict";var e=function(){this._array=[],this._offset=0,this.length=0};return e.prototype.enqueue=function(e){this._array.push(e),this.length++},e.prototype.dequeue=function(){if(0===this.length)return void 0;var e=this._array,r=this._offset,t=e[r];return e[r]=void 0,r++,r>10&&2*r>e.length&&(this._array=e.slice(r),r=0),this._offset=r,this.length--,t},e.prototype.contains=function(e){return-1!==this._array.indexOf(e)},e.prototype.clear=function(){this._array.length=this._offset=this.length=0},e.prototype.sort=function(e){this._offset>0&&(this._array=this._array.slice(this._offset),this._offset=0),this._array.sort(e)},e}),define("Core/WindingOrder",["../Renderer/WebGLConstants","./freezeObject"],function(e,r){"use strict";var t={CLOCKWISE:e.CW,COUNTER_CLOCKWISE:e.CCW,validate:function(e){return e===t.CLOCKWISE||e===t.COUNTER_CLOCKWISE}};return r(t)}),define("Core/PolygonPipeline",["./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./Math","./pointInsideTriangle","./PolylinePipeline","./PrimitiveType","./Queue","./WindingOrder"],function(e,r,t,n,i,a,o,u,s,f,c,l,h,d,w,E){"use strict";function m(r,t,n){var i=e.subtract(t,r,U),a=e.subtract(n,t,L);return i.x*a.y-i.y*a.x>=0}function p(e){for(var r=e[0].x,t=0,n=0;n<e.length;n++)e[n].x>r&&(r=e[n].x,t=n);return t}function _(e){for(var r=e[0][0].x,t=0,n=0;n<e.length;n++){var i=e[n][p(e[n])].x;i>r&&(r=i,t=n)}return t}function y(e){for(var r=[],t=0;t<e.length;t++){var n=e[(t-1+e.length)%e.length],i=e[t],a=e[(t+1)%e.length];m(n,i,a)||r.push(i)}return r}function R(r,t){for(var n=0;n<r.length;n++)if(e.equals(t,r[n]))return n;return-1}function T(t,i,a){a=n(a,[]);var o=Number.MAX_VALUE,u=p(i),s=new e(i[u].x,t.y);a.push(u),a.push((u+1)%i.length);for(var f=i[0].x,c=f,l=1;l<i.length;++l)i[l].x<f?f=i[l].x:i[l].x>c&&(c=i[l].x);c+=c-f;var h=new r(c,t.y,0);for(l=0;l<i.length;l++){var d=i[l],w=i[(l+1)%i.length];if((d.x>=t.x||w.x>=t.x)&&(d.y>=t.y&&w.y<=t.y||d.y<=t.y&&w.y>=t.y)){var E=(w.y-d.y)*(h.x-t.x)-(w.x-d.x)*(h.y-t.y);if(0!==E){E=1/E;var m=((w.x-d.x)*(t.y-d.y)-(w.y-d.y)*(t.x-d.x))*E,_=((h.x-t.x)*(t.y-d.y)-(h.y-t.y)*(t.x-d.x))*E;if(m>=0&&1>=m&&_>=0&&1>=_){var y=new e(t.x+m*(h.x-t.x),t.y+m*(h.y-t.y)),R=e.subtract(y,t,F);E=e.magnitudeSquared(R),o>E&&(s=y,o=E,a[0]=l,a[1]=(l+1)%i.length)}}}}return s}function v(r,t){var n=_(t),i=t[n],a=p(i),o=i[a],u=[],s=T(o,r,u),f=R(r,s);if(-1!==f)return f;var h=e.magnitudeSquared(e.subtract(r[u[0]],o,B)),d=e.magnitudeSquared(e.subtract(r[u[1]],o,B)),w=d>h?r[u[0]]:r[u[1]],E=y(r),m=E.indexOf(w);-1!==m&&E.splice(m,1);for(var v=[],A=0;A<E.length;A++){var S=E[A];l(S,o,s,w)&&v.push(S)}var g=Number.MAX_VALUE;if(v.length>0){var q=e.fromElements(1,0,B);for(A=0;A<v.length;A++){var N=e.subtract(v[A],o,z),M=e.magnitude(q)*e.magnitudeSquared(N);if(0!==M){var O=Math.abs(c.acosClamped(e.dot(q,N)/M));g>O&&(g=O,w=v[A])}}}return r.indexOf(w)}function A(e,t,n){for(var i=ee.computeWindingOrder2D(e),a=0;a<t.length;a++){var o=t[a];r.equals(o[0],o[o.length-1])||o.push(o[0]);var s=ee.computeWindingOrder2D(o);s===i&&o.reverse()}var f=u.fromPoints(e,n),c=f.projectPointsOntoPlane(e),l=[];for(a=0;a<t.length;a++)l.push(f.projectPointsOntoPlane(t[a]));var h=v(c,l),d=_(l),w=p(l[d]),E=t[d],m=[];for(a=0;a<e.length;a++)m.push(e[a]);var y,R=[];if(0!==w)for(y=0;y<=E.length;y++){var T=(y+w)%E.length;0!==T&&R.push(E[T])}else for(y=0;y<E.length;y++)R.push(E[(y+w)%E.length]);var A=m.lastIndexOf(e[h]);R.push(e[A]);var S=m.slice(0,A+1),g=m.slice(A+1);return m=S.concat(R,g),t.splice(d,1),m}function S(e){var r=c.nextRandomNumber(),t=Math.floor(r*e);return t===e&&t--,t}function g(e,r,t,n){var i=n[e].position,a=n[r].position,o=n[t].position,u=o.x,s=o.y,f=i.x-u,c=i.y-s,l=a.x-u,h=a.y-s;return f*h-c*l}function q(e,r){return e.x*r.y-e.y*r.x}function N(e,r){var t=r.length,n=c.mod(e-1,t),i=c.mod(e+1,t);return 0===g(n,i,e,r)?!1:!0}function M(r,t){return e.magnitudeSquared(t)<e.magnitudeSquared(r)}function O(r,t,n){if(!N(r,n))return r;var i=n[r].position,a=n[t].position,o=n.length,u=c.mod(r-1,o);if(!N(u,n))return u;var s=c.mod(r+1,o);if(!N(s,n))return s;var f=e.subtract(n[u].position,i,X),l=e.subtract(n[s].position,i,H),h=e.subtract(a,i,V),d=q(f,h),w=q(l,h);if(0===d)return M(f,h)?G:W;if(0===w)return M(l,h)?G:W;var E=q(f,l);return 0>E?0>d&&w>0?G:W:E>0?d>0&&0>w?W:G:void 0}function I(e,r,t){return(e>r||e>t)&&(r>e||t>e)||r===t&&r===e}function x(r,t,n,i){var a=e.subtract(n,r,j),o=t.x*i.y-t.y*i.x,u=o*o,s=e.magnitudeSquared(t),f=e.magnitudeSquared(i);if(u>Y*s*f){var c=(a.x*i.y-a.y*i.x)/o;return e.add(r,e.multiplyByScalar(t,c,j),j)}return void 0}function C(r,t,n){for(var a=e.subtract(t,r,k),o=n.length,u=0;o>u;u++){var s=n[u].position,f=n[c.mod(u+1,o)].position;if(!(e.equals(r,s)||e.equals(t,f)||e.equals(r,f)||e.equals(t,s))){var l=e.subtract(f,s,Z),h=x(r,a,s,l);if(i(h)&&!(e.equals(h,r)||e.equals(h,t)||e.equals(h,s)||e.equals(h,f))){var d=h.x,w=h.y,E=I(d,r.x,t.x)&&I(w,r.y,t.y)&&I(d,s.x,f.x)&&I(w,s.y,f.y);if(E)return!0}}}return!1}function P(r,t,n){var i=O(r,t,n);if(i>=0)return i;var a=O(t,r,n);return a>=0?a:i!==G||a!==G||C(n[r].position,n[t].position,n)||e.equals(n[r].position,n[t].position)?J:K}function b(e){return 0===g(1,2,0,e)}function D(e){var r=e.length;if(3===r)return b(e)?[]:[e[0].index,e[1].index,e[2].index];if(e.length<3)throw new a("Invalid polygon: must have at least three vertices.");for(var t,n,i=0,o=10*e.length,u=J;K>u&&i++<o;){for(t=S(e.length),n=t+1;Math.abs(t-n)<2||Math.abs(t-n)>e.length-2;)n=S(e.length);if(t>n){var s=t;t=n,n=s}u=P(t,n,e)}if(u===K){var f=e.splice(t,n-t+1,e[t],e[n]);return D(e).concat(D(f))}return u>=0?(e.splice(u,1),D(e)):[]}var U=new e,L=new e,F=new e,B=new e(1,0),z=new e,G=-1,W=-2,X=new r,H=new r,V=new r,Y=c.EPSILON14,j=new e,k=(new e,new e),Z=new e,K=-1,J=-2,Q=new r,$=new r,ee={};ee.removeDuplicates=function(e){if(!i(e))throw new a("positions is required.");var t=h.removeDuplicates(e);return r.equals(t[0],t[t.length-1])?t.slice(1):t},ee.computeArea2D=function(e){if(!i(e))throw new a("positions is required.");if(e.length<3)throw new a("At least three positions are required.");for(var r=e.length,t=0,n=r-1,o=0;r>o;n=o++){var u=e[n],s=e[o];t+=u.x*s.y-s.x*u.y}return.5*t},ee.computeWindingOrder2D=function(e){var r=ee.computeArea2D(e);return r>0?E.COUNTER_CLOCKWISE:E.CLOCKWISE},ee.triangulate=function(e){if(!i(e))throw new a("positions is required.");if(e.length<3)throw new a("At least three positions are required.");for(var r=e.length,t=[],n=0;r>n;++n)t[n]={position:e[n],index:n};return D(t)};var re=new r,te=new r,ne=new r,ie=new r,ae=new r,oe=new r,ue=new r;return ee.computeSubdivision=function(e,o,u,l){if(l=n(l,c.RADIANS_PER_DEGREE),!i(e))throw new a("ellipsoid is required.");if(!i(o))throw new a("positions is required.");if(!i(u))throw new a("indices is required.");if(u.length<3)throw new a("At least three indices are required.");if(u.length%3!==0)throw new a("The number of indices must be divisable by three.");if(0>=l)throw new a("granularity must be greater than zero.");var h,w=u.slice(0),E=o.length,m=new Array(3*E),p=0;for(h=0;E>h;h++){var _=o[h];m[p++]=_.x,m[p++]=_.y,m[p++]=_.z}for(var y=[],R={},T=e.maximumRadius,v=c.chordLength(l,T),A=v*v;w.length>0;){var S,g,q=w.pop(),N=w.pop(),M=w.pop(),O=r.fromArray(m,3*M,re),I=r.fromArray(m,3*N,te),x=r.fromArray(m,3*q,ne),C=r.multiplyByScalar(r.normalize(O,ie),T,ie),P=r.multiplyByScalar(r.normalize(I,ae),T,ae),b=r.multiplyByScalar(r.normalize(x,oe),T,oe),D=r.magnitudeSquared(r.subtract(C,P,ue)),U=r.magnitudeSquared(r.subtract(P,b,ue)),L=r.magnitudeSquared(r.subtract(b,C,ue)),F=Math.max(D,U,L);F>A?D===F?(S=Math.min(M,N)+" "+Math.max(M,N),h=R[S],i(h)||(g=r.add(O,I,ue),r.multiplyByScalar(g,.5,g),m.push(g.x,g.y,g.z),h=m.length/3-1,R[S]=h),w.push(M,h,q),w.push(h,N,q)):U===F?(S=Math.min(N,q)+" "+Math.max(N,q),h=R[S],i(h)||(g=r.add(I,x,ue),r.multiplyByScalar(g,.5,g),m.push(g.x,g.y,g.z),h=m.length/3-1,R[S]=h),w.push(N,h,M),w.push(h,q,M)):L===F&&(S=Math.min(q,M)+" "+Math.max(q,M),h=R[S],i(h)||(g=r.add(x,O,ue),r.multiplyByScalar(g,.5,g),m.push(g.x,g.y,g.z),h=m.length/3-1,R[S]=h),w.push(q,h,N),w.push(h,M,N)):(y.push(M),y.push(N),y.push(q))}return new s({attributes:{position:new f({componentDatatype:t.DOUBLE,componentsPerAttribute:3,values:m})},indices:y,primitiveType:d.TRIANGLES})},ee.scaleToGeodeticHeight=function(e,t,a,u){a=n(a,o.WGS84);var s=Q,f=$;if(t=n(t,0),u=n(u,!0),i(e)&&i(e.attributes)&&i(e.attributes.position))for(var c=e.attributes.position.values,l=c.length,h=0;l>h;h+=3)r.fromArray(c,h,f),u&&(f=a.scaleToGeodeticSurface(f,f)),s=a.geodeticSurfaceNormal(f,s),r.multiplyByScalar(s,t,s),r.add(f,s,f),c[h]=f.x,c[h+1]=f.y,c[h+2]=f.z;return e},ee.eliminateHoles=function(e,t,u){if(!i(e))throw new a("outerRing is required.");if(0===e.length)throw new a("outerRing must not be empty.");if(!i(t))throw new a("innerRings is required.");u=n(u,o.WGS84);for(var s=[],f=0;f<t.length;f++){for(var c=[],l=0;l<t[f].length;l++)c.push(r.clone(t[f][l]));s.push(c)}for(var h=e;s.length>0;)h=A(h,s,u);return h},ee}),define("Core/Matrix2",["./Cartesian2","./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,r,t,n,i){"use strict";var a=function(e,t,n,i){this[0]=r(e,0),this[1]=r(n,0),this[2]=r(t,0),this[3]=r(i,0)};a.packedLength=4,a.pack=function(e,i,a){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");a=r(a,0),i[a++]=e[0],i[a++]=e[1],i[a++]=e[2],i[a++]=e[3]},a.unpack=function(e,i,o){if(!t(e))throw new n("array is required");return i=r(i,0),t(o)||(o=new a),o[0]=e[i++],o[1]=e[i++],o[2]=e[i++],o[3]=e[i++],o},a.clone=function(e,r){return t(e)?t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r):new a(e[0],e[2],e[1],e[3]):void 0},a.fromArray=function(e,i,o){if(!t(e))throw new n("array is required");return i=r(i,0),t(o)||(o=new a),o[0]=e[i],o[1]=e[i+1],o[2]=e[i+2],o[3]=e[i+3],o},a.fromColumnMajorArray=function(e,r){if(!t(e))throw new n("values parameter is required");return a.clone(e,r)},a.fromRowMajorArray=function(e,r){if(!t(e))throw new n("values is required.");return t(r)?(r[0]=e[0],r[1]=e[2],r[2]=e[1],r[3]=e[3],r):new a(e[0],e[1],e[2],e[3])},a.fromScale=function(e,r){if(!t(e))throw new n("scale is required.");return t(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=e.y,r):new a(e.x,0,0,e.y)},a.fromUniformScale=function(e,r){if("number"!=typeof e)throw new n("scale is required.");return t(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=e,r):new a(e,0,0,e)},a.fromRotation=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=i,r[1]=o,r[2]=-o,r[3]=i,r):new a(i,-o,o,i)},a.toArray=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r):[e[0],e[1],e[2],e[3]]},a.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>1)throw new n("row must be 0 or 1.");if("number"!=typeof e||0>e||e>1)throw new n("column must be 0 or 1.");return 2*e+r},a.getColumn=function(e,r,i){if(!t(e))throw new n("matrix is required.");if("number"!=typeof r||0>r||r>1)throw new n("index must be 0 or 1.");if(!t(i))throw new n("result is required");var a=2*r,o=e[a],u=e[a+1];return i.x=o,i.y=u,i},a.setColumn=function(e,r,i,o){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>1)throw new n("index must be 0 or 1.");if(!t(o))throw new n("result is required");o=a.clone(e,o);var u=2*r;return o[u]=i.x,o[u+1]=i.y,o},a.getRow=function(e,r,i){if(!t(e))throw new n("matrix is required.");if("number"!=typeof r||0>r||r>1)throw new n("index must be 0 or 1.");if(!t(i))throw new n("result is required");var a=e[r],o=e[r+2];return i.x=a,i.y=o,i},a.setRow=function(e,r,i,o){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>1)throw new n("index must be 0 or 1.");if(!t(o))throw new n("result is required");return o=a.clone(e,o),o[r]=i.x,o[r+2]=i.y,o};var o=new e;a.getScale=function(r,i){if(!t(r))throw new n("matrix is required.");if(!t(i))throw new n("result is required");return i.x=e.magnitude(e.fromElements(r[0],r[1],o)),i.y=e.magnitude(e.fromElements(r[2],r[3],o)),i};var u=new e;return a.getMaximumScale=function(r){return a.getScale(r,u),e.maximumComponent(u)},a.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");var a=e[0]*r[0]+e[2]*r[1],o=e[0]*r[2]+e[2]*r[3],u=e[1]*r[0]+e[3]*r[1],s=e[1]*r[2]+e[3]*r[3];return i[0]=a,i[1]=u,i[2]=o,i[3]=s,i},a.add=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i[0]=e[0]+r[0],i[1]=e[1]+r[1],i[2]=e[2]+r[2],i[3]=e[3]+r[3],i},a.subtract=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],i[3]=e[3]-r[3],i},a.multiplyByVector=function(e,r,i){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("cartesian is required");if(!t(i))throw new n("result is required");var a=e[0]*r.x+e[2]*r.y,o=e[1]*r.x+e[3]*r.y;return i.x=a,i.y=o,i},a.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scalar is required and must be a number");if(!t(i))throw new n("result is required");return i[0]=e[0]*r,i[1]=e[1]*r,i[2]=e[2]*r,i[3]=e[3]*r,i},a.multiplyByScale=function(e,r,i){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("scale is required");if(!t(i))throw new n("result is required");return i[0]=e[0]*r.x,i[1]=e[1]*r.x,i[2]=e[2]*r.y,i[3]=e[3]*r.y,i},a.negate=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");return r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r},a.transpose=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");var i=e[0],a=e[2],o=e[1],u=e[3];return r[0]=i,r[1]=a,r[2]=o,r[3]=u,r},a.abs=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");return r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r},a.equals=function(e,r){return e===r||t(e)&&t(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]},a.equalsArray=function(e,r,t){return e[0]===r[t]&&e[1]===r[t+1]&&e[2]===r[t+2]&&e[3]===r[t+3]},a.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon must be a number");return e===r||t(e)&&t(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i},a.IDENTITY=i(new a(1,0,0,1)),a.ZERO=i(new a(0,0,0,0)),a.COLUMN0ROW0=0,a.COLUMN0ROW1=1,a.COLUMN1ROW0=2,a.COLUMN1ROW1=3,a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r){return a.equalsEpsilon(this,e,r)},a.prototype.toString=function(){return"("+this[0]+", "+this[2]+")\n("+this[1]+", "+this[3]+")"},a}),define("Core/RectangleGeometryLibrary",["./Cartesian3","./Cartographic","./defined","./DeveloperError","./GeographicProjection","./Math","./Matrix2","./Rectangle"],function(e,r,t,n,i,a,o,u){"use strict";var s=Math.cos,f=Math.sin,c=Math.sqrt,l={};l.computePosition=function(e,r,n,i,a){var u=e.ellipsoid.radiiSquared,l=e.nwCorner,h=e.rectangle,d=l.latitude-e.granYCos*r+n*e.granXSin,w=s(d),E=f(d),m=u.z*E,p=l.longitude+r*e.granYSin+n*e.granXCos,_=w*s(p),y=w*f(p),R=u.x*_,T=u.y*y,v=c(R*_+T*y+m*E);i.x=R/v,i.y=T/v,i.z=m/v,t(e.vertexFormat)&&e.vertexFormat.st&&(a.x=(p-h.west)*e.lonScalar-.5,a.y=(d-h.south)*e.latScalar-.5,o.multiplyByVector(e.textureMatrix,a,a),a.x+=.5,a.y+=.5)};var h=new o,d=new e,w=new r,E=new e,m=new i;return l.computeOptions=function(r,i,s){var f,c,l,p,_,y=r._granularity,R=r._ellipsoid,T=r._surfaceHeight,v=r._rotation,A=r._extrudedHeight,S=i.east,g=i.west,q=i.north,N=i.south,M=q-N;g>S?(_=a.TWO_PI-g+S,f=Math.ceil(_/y)+1,c=Math.ceil(M/y)+1,l=_/(f-1),p=M/(c-1)):(_=S-g,f=Math.ceil(_/y)+1,c=Math.ceil(M/y)+1,l=_/(f-1),p=M/(c-1)),s=u.northwest(i,s);var O=u.center(i,w),I=p,x=l,C=0,P=0;if(t(v)){var b=Math.cos(v);I*=b,x*=b;var D=Math.sin(v);C=p*D,P=l*D,d=m.project(s,d),E=m.project(O,E),d=e.subtract(d,E,d);var U=o.fromRotation(v,h);d=o.multiplyByVector(U,d,d),d=e.add(d,E,d),s=m.unproject(d,s);var L=s.latitude,F=L+(f-1)*P,B=L-I*(c-1),z=L-I*(c-1)+(f-1)*P;q=Math.max(L,F,B,z),N=Math.min(L,F,B,z);var G=s.longitude,W=G+(f-1)*x,X=G+(c-1)*C,H=G+(c-1)*C+(f-1)*x;if(S=Math.max(G,W,X,H),g=Math.min(G,W,X,H),q<-a.PI_OVER_TWO||q>a.PI_OVER_TWO||N<-a.PI_OVER_TWO||N>a.PI_OVER_TWO)throw new n("Rotated extent is invalid.");i.north=q,i.south=N,i.east=S,i.west=g}return{granYCos:I,granYSin:C,granXCos:x,granXSin:P,ellipsoid:R,width:f,height:c,surfaceHeight:T,extrudedHeight:A,nwCorner:s,rectangle:i}},l}),define("Core/RectangleOutlineGeometry",["./BoundingSphere","./Cartesian3","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PolygonPipeline","./PrimitiveType","./Rectangle","./RectangleGeometryLibrary"],function(e,r,t,n,i,a,o,u,s,f,c,l,h,d,w,E,m){"use strict";function p(e){var r,t=e.size,i=e.height,a=e.width,o=new Float64Array(3*t),u=0,h=0,d=T;for(r=0;a>r;r++)m.computePosition(e,h,r,d),o[u++]=d.x,o[u++]=d.y,o[u++]=d.z;for(r=a-1,h=1;i>h;h++)m.computePosition(e,h,r,d),o[u++]=d.x,o[u++]=d.y,o[u++]=d.z;for(h=i-1,r=a-2;r>=0;r--)m.computePosition(e,h,r,d),o[u++]=d.x,o[u++]=d.y,o[u++]=d.z;for(r=0,h=i-2;h>0;h--)m.computePosition(e,h,r,d),o[u++]=d.x,o[u++]=d.y,o[u++]=d.z;for(var E=o.length/3*2,p=l.createTypedArray(o.length/3,E),_=0,y=0;y<o.length/3-1;y++)p[_++]=y,p[_++]=y+1;p[_++]=o.length/3-1,p[_++]=0;var R=new s({attributes:new c,primitiveType:w.LINES});return R.attributes.position=new f({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:o}),R.indices=p,R}function _(e){var r=e.surfaceHeight,t=e.extrudedHeight,n=e.ellipsoid,i=Math.min(t,r),a=Math.max(t,r),o=p(e);if(h.equalsEpsilon(i,a,h.EPSILON10))return o;var u=e.height,s=e.width;o=d.scaleToGeodeticHeight(o,a,n,!1);var f=o.attributes.position.values,c=f.length,w=new Float64Array(2*c);w.set(f),o=d.scaleToGeodeticHeight(o,i,n);var E=o.attributes.position.values;w.set(E,c),o.attributes.position.values=w;var m=w.length/3*2+8,_=l.createTypedArray(w.length/3,m);c=w.length/6;for(var y=0,R=0;c-1>R;R++)_[y++]=R,_[y++]=R+1,_[y++]=R+c,_[y++]=R+c+1;return _[y++]=c-1,_[y++]=0,_[y++]=c+c-1,_[y++]=c,_[y++]=0,_[y++]=c,_[y++]=s-1,_[y++]=c+s-1,_[y++]=s+u-2,_[y++]=s+u-2+c,_[y++]=2*s+u-3,_[y++]=2*s+u-3+c,o.indices=_,o}var y=new e,R=new e,T=new r,v=new E,A=function(e){e=i(e,i.EMPTY_OBJECT);var r=e.rectangle,t=i(e.granularity,h.RADIANS_PER_DEGREE),n=i(e.ellipsoid,u.WGS84),s=i(e.height,0),f=i(e.rotation,0),c=e.extrudedHeight;if(!a(r))throw new o("rectangle is required.");if(E.validate(r),r.north<r.south)throw new o("options.rectangle.north must be greater than options.rectangle.south");this._rectangle=r,this._granularity=t,this._ellipsoid=n,this._surfaceHeight=s,this._rotation=f,this._extrudedHeight=c,this._workerName="createRectangleOutlineGeometry"};A.packedLength=E.packedLength+u.packedLength+5,A.pack=function(e,r,t){if(!a(e))throw new o("value is required");if(!a(r))throw new o("array is required");t=i(t,0),E.pack(e._rectangle,r,t),t+=E.packedLength,u.pack(e._ellipsoid,r,t),t+=u.packedLength,r[t++]=e._granularity,r[t++]=e._surfaceHeight,r[t++]=e._rotation,r[t++]=a(e._extrudedHeight)?1:0,r[t]=i(e._extrudedHeight,0)};var S=new E,g=u.clone(u.UNIT_SPHERE),q={rectangle:S,ellipsoid:g,granularity:void 0,height:void 0,rotation:void 0,extrudedHeight:void 0};A.unpack=function(e,r,t){if(!a(e))throw new o("array is required");r=i(r,0);var n=E.unpack(e,r,S);r+=E.packedLength;var s=u.unpack(e,r,g);r+=u.packedLength;var f=e[r++],c=e[r++],l=e[r++],h=e[r++],d=e[r];return a(t)?(t._rectangle=E.clone(n,t._rectangle),
t._ellipsoid=u.clone(s,t._ellipsoid),t._surfaceHeight=c,t._rotation=l,t._extrudedHeight=h?d:void 0,t):(q.granularity=f,q.height=c,q.rotation=l,q.extrudedHeight=h?d:void 0,new A(q))};var N=new t;return A.createGeometry=function(r){var t=E.clone(r._rectangle,v),n=r._ellipsoid,i=r._surfaceHeight,o=r._extrudedHeight,u=m.computeOptions(r,t,N);u.size=2*u.width+2*u.height-4;var f,c;if(t=r._rectangle,a(o)){f=_(u);var l=e.fromRectangle3D(t,n,i,R),h=e.fromRectangle3D(t,n,o,y);c=e.union(l,h)}else f=p(u),f=d.scaleToGeodeticHeight(f,i,n,!1),c=e.fromRectangle3D(t,n,i);return new s({attributes:f.attributes,indices:f.indices,primitiveType:w.LINES,boundingSphere:c})},A}),define("Workers/createRectangleOutlineGeometry",["../Core/defined","../Core/Ellipsoid","../Core/Rectangle","../Core/RectangleOutlineGeometry"],function(e,r,t,n){"use strict";function i(i,a){return e(a)&&(i=n.unpack(i,a)),i._ellipsoid=r.clone(i._ellipsoid),i._rectangle=t.clone(i._rectangle),n.createGeometry(i)}return i})}();