/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var r=Object.freeze;return e(r)||(r=function(e){return e}),r}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var r=function(e,r){return void 0!==e?e:r};return r.EMPTY_OBJECT=e({}),r}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var r=function(e){this.name="DeveloperError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r.throwInstantiationError=function(){throw new r("This function defines an interface and should not be called directly.")},r}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var t;for(this.mti==this.N+1&&this.init_genrand(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^r[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^r[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^r[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.signNotZero=function(e){return 0>e?-1:1},i.toSNorm=function(e){return Math.round(255*(.5*i.clamp(e,-1,1)+.5))},i.fromSNorm=function(e){return i.clamp(e,0,255)/255*2-1},i.sinh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r-t)},i.cosh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r+t)},i.lerp=function(e,r,t){return(1-t)*e+t*r},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=3*Math.PI*.5,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){if(!t(e))throw new n("degrees is required.");return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){if(!t(e))throw new n("radians is required.");return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){if(!t(e))throw new n("angle is required.");var r=i.TWO_PI,o=e-Math.floor(e/r)*r;return o<-Math.PI?o+r:o>=Math.PI?o-r:o},i.negativePiToPi=function(e){if(!t(e))throw new n("x is required.");return i.zeroToTwoPi(e+i.PI)-i.PI},i.zeroToTwoPi=function(e){if(!t(e))throw new n("x is required.");var r=i.mod(e,i.TWO_PI);return Math.abs(r)<i.EPSILON14&&Math.abs(e)>i.EPSILON14?i.TWO_PI:r},i.mod=function(e,r){if(!t(e))throw new n("m is required.");if(!t(r))throw new n("n is required.");return(e%r+r)%r},i.equalsEpsilon=function(e,i,o,a){if(!t(e))throw new n("left is required.");if(!t(i))throw new n("right is required.");if(!t(o))throw new n("relativeEpsilon is required.");a=r(a,o);var s=Math.abs(e-i);return a>=s||s<=o*Math.max(Math.abs(e),Math.abs(i))};var o=[1];i.factorial=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");var r=o.length;if(e>=r)for(var t=o[r-1],i=r;e>=i;i++)o.push(t*i);return o[e]},i.incrementWrap=function(e,i,o){if(o=r(o,0),!t(e))throw new n("n is required.");if(o>=i)throw new n("maximumValue must be greater than minimumValue.");return++e,e>i&&(e=o),e},i.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,r,i){if(!t(e))throw new n("value is required");if(!t(r))throw new n("min is required.");if(!t(i))throw new n("max is required.");return r>e?r:e>i?i:e};var a=new e;return i.setRandomNumberSeed=function(r){if(!t(r))throw new n("seed is required.");a=new e(r)},i.nextRandomNumber=function(){return a.random()},i.acosClamped=function(e){if(!t(e))throw new n("value is required.");return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){if(!t(e))throw new n("value is required.");return Math.asin(i.clamp(e,-1,1))},i.chordLength=function(e,r){if(!t(e))throw new n("angle is required.");if(!t(r))throw new n("radius is required.");return 2*r*Math.sin(.5*e)},i}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t,n){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0)};o.fromSpherical=function(n,i){if(!r(n))throw new t("spherical is required");r(i)||(i=new o);var a=n.clock,s=n.cone,u=e(n.magnitude,1),f=u*Math.sin(s);return i.x=f*Math.cos(a),i.y=f*Math.sin(a),i.z=u*Math.cos(s),i},o.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new o(e,t,n)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new o(e.x,e.y,e.z):void 0},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.x,i[o++]=n.y,i[o]=n.z},o.unpack=function(n,i,a){if(!r(n))throw new t("array is required");return i=e(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i],a},o.fromArray=o.unpack,o.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z)},o.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z)},o.minimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i},o.maximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitude(a)},o.distanceSquared=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitudeSquared(a)},o.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=o.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n},o.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z},o.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i},o.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i},o.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i},o.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i},o.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i},o.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n},o.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n};var s=new o;o.lerp=function(e,n,i,a){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(n,i,s),a=o.multiplyByScalar(e,1-i,a),o.add(s,a,a)};var u=new o,f=new o;o.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");o.normalize(e,u),o.normalize(n,f);var i=o.dot(u,f),a=o.magnitude(o.cross(u,f,u));return Math.atan2(a,i)};var l=new o;o.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=o.normalize(e,l);return o.abs(i,i),n=i.x<=i.y?i.x<=i.z?o.clone(o.UNIT_X,n):o.clone(o.UNIT_Z,n):i.y<=i.z?o.clone(o.UNIT_Y,n):o.clone(o.UNIT_Z,n)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},o.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]&&e.z===r[t+2]},o.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)&&i.equalsEpsilon(e.z,t.z,n,o)},o.cross=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");var o=e.x,a=e.y,s=e.z,u=n.x,f=n.y,l=n.z,E=a*l-s*f,h=s*u-o*l,c=o*f-a*u;return i.x=E,i.y=h,i.z=c,i},o.fromDegrees=function(e,n,a,s,u){if(!r(e))throw new t("longitude is required");if(!r(n))throw new t("latitude is required");var f=i.toRadians(e),l=i.toRadians(n);return o.fromRadians(f,l,a,s,u)};var E=new o,h=new o,c=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(n,i,a,s,u){if(!r(n))throw new t("longitude is required");if(!r(i))throw new t("latitude is required");a=e(a,0);var f=r(s)?s.radiiSquared:c,l=Math.cos(i);E.x=l*Math.cos(n),E.y=l*Math.sin(n),E.z=Math.sin(i),E=o.normalize(E,E),o.multiplyComponents(f,E,h);var d=Math.sqrt(o.dot(E,h));return h=o.divideByScalar(h,d,h),E=o.multiplyByScalar(E,a,E),r(u)||(u=new o),o.add(h,E,u)},o.fromDegreesArray=function(e,n,a){if(!r(e))throw new t("positions is required.");for(var s=new Array(e.length),u=0;u<e.length;u++)s[u]=i.toRadians(e[u]);return o.fromRadiansArray(s,n,a)},o.fromRadiansArray=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<2)throw new t("positions length cannot be less than 2.");if(e.length%2!==0)throw new t("positions length must be a multiple of 2.");var a=e.length;r(i)?i.length=a/2:i=new Array(a/2);for(var s=0;a>s;s+=2){var u=e[s],f=e[s+1];i[s/2]=o.fromRadians(u,f,0,n,i[s/2])}return i},o.fromDegreesArrayHeights=function(e,n,a){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(e.length%3!==0)throw new t("positions length must be a multiple of 3.");for(var s=new Array(e.length),u=0;u<e.length;u+=3)s[u]=i.toRadians(e[u]),s[u+1]=i.toRadians(e[u+1]),s[u+2]=e[u+2];return o.fromRadiansArrayHeights(s,n,a)},o.fromRadiansArrayHeights=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(e.length%3!==0)throw new t("positions length must be a multiple of 3.");var a=e.length;r(i)?i.length=a/3:i=new Array(a/3);for(var s=0;a>s;s+=3){var u=e[s],f=e[s+1],l=e[s+2];i[s/3]=o.fromRadians(u,f,l,n,i[s/3])}return i},o.ZERO=n(new o(0,0,0)),o.UNIT_X=n(new o(1,0,0)),o.UNIT_Y=n(new o(0,1,0)),o.UNIT_Z=n(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r,t){return o.equalsEpsilon(this,e,r,t)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t,n){this.longitude=e(r,0),this.latitude=e(t,0),this.height=e(n,0)};return o.fromRadians=function(n,i,a,s){if(!r(n))throw new t("longitude is required.");if(!r(i))throw new t("latitude is required.");return a=e(a,0),r(s)?(s.longitude=n,s.latitude=i,s.height=a,s):new o(n,i,a)},o.fromDegrees=function(e,n,a,s){if(!r(e))throw new t("longitude is required.");if(!r(n))throw new t("latitude is required.");return e=i.toRadians(e),n=i.toRadians(n),o.fromRadians(e,n,a,s)},o.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new o(e.longitude,e.latitude,e.height):void 0},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},o.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.longitude-n.longitude)<=i&&Math.abs(e.latitude-n.latitude)<=i&&Math.abs(e.height-n.height)<=i},o.ZERO=n(new o(0,0,0)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r){return o.equalsEpsilon(this,e,r)},o.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},o}),define("Core/defineProperties",["./defined"],function(e){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),t=Object.defineProperties;return r&&e(t)||(t=function(e){return e}),t}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,o,a,s){"use strict";function u(r,n,i,a){if(n=t(n,0),i=t(i,0),a=t(a,0),0>n||0>i||0>a)throw new o("All radii components must be greater than or equal to zero.");r._radii=new e(n,i,a),r._radiiSquared=new e(n*n,i*i,a*a),r._radiiToTheFourth=new e(n*n*n*n,i*i*i*i,a*a*a*a),r._oneOverRadii=new e(0===n?0:1/n,0===i?0:1/i,0===a?0:1/a),r._oneOverRadiiSquared=new e(0===n?0:1/(n*n),0===i?0:1/(i*i),0===a?0:1/(a*a)),r._minimumRadius=Math.min(n,i,a),r._maximumRadius=Math.max(n,i,a),r._centerToleranceSquared=s.EPSILON1}var f=function(e,r,t){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,u(this,e,r,t)};i(f.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),f.clone=function(r,t){if(!n(r))return void 0;var i=r._radii;return n(t)?(e.clone(i,t._radii),e.clone(r._radiiSquared,t._radiiSquared),e.clone(r._radiiToTheFourth,t._radiiToTheFourth),e.clone(r._oneOverRadii,t._oneOverRadii),e.clone(r._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=r._minimumRadius,t._maximumRadius=r._maximumRadius,t._centerToleranceSquared=r._centerToleranceSquared,t):new f(i.x,i.y,i.z)},f.fromCartesian3=function(e,r){return n(r)||(r=new f),n(e)?(u(r,e.x,e.y,e.z),r):r},f.WGS84=a(new f(6378137,6378137,6356752.314245179)),f.UNIT_SPHERE=a(new f(1,1,1)),f.MOON=a(new f(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),f.prototype.clone=function(e){return f.clone(this,e)},f.packedLength=e.packedLength,f.pack=function(r,i,a){if(!n(r))throw new o("value is required");if(!n(i))throw new o("array is required");a=t(a,0),e.pack(r._radii,i,a)},f.unpack=function(r,i,a){if(!n(r))throw new o("array is required");i=t(i,0);var s=e.unpack(r,i);return f.fromCartesian3(s,a)},f.prototype.geocentricSurfaceNormal=e.normalize,f.prototype.geodeticSurfaceNormalCartographic=function(r,t){if(!n(r))throw new o("cartographic is required.");var i=r.longitude,a=r.latitude,s=Math.cos(a),u=s*Math.cos(i),f=s*Math.sin(i),l=Math.sin(a);return n(t)||(t=new e),t.x=u,t.y=f,t.z=l,e.normalize(t,t)},f.prototype.geodeticSurfaceNormal=function(r,t){return n(t)||(t=new e),t=e.multiplyComponents(r,this._oneOverRadiiSquared,t),e.normalize(t,t)};var l=new e,E=new e;f.prototype.cartographicToCartesian=function(r,t){var i=l,o=E;this.geodeticSurfaceNormalCartographic(r,i),e.multiplyComponents(this._radiiSquared,i,o);var a=Math.sqrt(e.dot(i,o));return e.divideByScalar(o,a,o),e.multiplyByScalar(i,r.height,i),n(t)||(t=new e),e.add(o,i,t)},f.prototype.cartographicArrayToCartesianArray=function(e,r){if(!n(e))throw new o("cartographics is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;i++)r[i]=this.cartographicToCartesian(e[i],r[i]);return r};var h=new e,c=new e,d=new e;f.prototype.cartesianToCartographic=function(t,i){var o=this.scaleToGeodeticSurface(t,c);if(!n(o))return void 0;var a=this.geodeticSurfaceNormal(o,h),u=e.subtract(t,o,d),f=Math.atan2(a.y,a.x),l=Math.asin(a.z),E=s.sign(e.dot(u,t))*e.magnitude(u);return n(i)?(i.longitude=f,i.latitude=l,i.height=E,i):new r(f,l,E)},f.prototype.cartesianArrayToCartographicArray=function(e,r){if(!n(e))throw new o("cartesians is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;++i)r[i]=this.cartesianToCartographic(e[i],r[i]);return r};var w=new e,_=new e;return f.prototype.scaleToGeodeticSurface=function(r,t){if(!n(r))throw new o("cartesian is required.");var i=r.x,a=r.y,u=r.z,f=this._oneOverRadii,l=f.x,E=f.y,h=f.z,c=i*i*l*l,d=a*a*E*E,R=u*u*h*h,m=c+d+R,T=Math.sqrt(1/m),A=e.multiplyByScalar(r,T,w);if(m<this._centerToleranceSquared)return isFinite(T)?e.clone(A,t):void 0;var S=this._oneOverRadiiSquared,p=S.x,C=S.y,N=S.z,I=_;I.x=A.x*p*2,I.y=A.y*C*2,I.z=A.z*N*2;var g,M,O,y,v,F,q,L,D,P,U,B=(1-T)*e.magnitude(r)/(.5*e.magnitude(I)),b=0;do{B-=b,O=1/(1+B*p),y=1/(1+B*C),v=1/(1+B*N),F=O*O,q=y*y,L=v*v,D=F*O,P=q*y,U=L*v,g=c*F+d*q+R*L-1,M=c*D*p+d*P*C+R*U*N;var x=-2*M;b=g/x}while(Math.abs(g)>s.EPSILON12);return n(t)?(t.x=i*O,t.y=a*y,t.z=u*v,t):new e(i*O,a*y,u*v)},f.prototype.scaleToGeocentricSurface=function(r,t){if(!n(r))throw new o("cartesian is required.");n(t)||(t=new e);var i=r.x,a=r.y,s=r.z,u=this._oneOverRadiiSquared,f=1/Math.sqrt(i*i*u.x+a*a*u.y+s*s*u.z);return e.multiplyByScalar(r,f,t)},f.prototype.transformPositionToScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._oneOverRadii,t)},f.prototype.transformPositionFromScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._radii,t)},f.prototype.equals=function(r){return this===r||n(r)&&e.equals(this._radii,r._radii)},f.prototype.toString=function(){return this._radii.toString()},f}),define("Core/deprecationWarning",["./defined","./DeveloperError"],function(e,r){"use strict";var t={},n=function(n,i){if(!e(n)||!e(i))throw new r("identifier and message are required.");e(t[n])||(t[n]=!0,console.log(i))};return n}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,r,t,n,i,o,a){"use strict";var s=function(e){this._ellipsoid=t(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),s.prototype.project=function(r,t){var i=this._semimajorAxis,o=r.longitude*i,a=r.latitude*i,s=r.height;return n(t)?(t.x=o,t.y=a,t.z=s,t):new e(o,a,s)},s.prototype.unproject=function(e,t){if(!n(e))throw new o("cartesian is required");var i=this._oneOverSemimajorAxis,a=e.x*i,s=e.y*i,u=e.z;return n(t)?(t.longitude=a,t.latitude=s,t.height=u,t):new r(a,s,u)},s}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var r={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(r)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var r=function(r,t){this.start=e(r,0),this.stop=e(t,0)};return r}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t,n,i){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0),this.w=e(i,0)};o.fromElements=function(e,t,n,i,a){return r(a)?(a.x=e,a.y=t,a.z=n,a.w=i,a):new o(e,t,n,i)},o.fromColor=function(e,n){if(!r(e))throw new t("color is required");return r(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new o(e.red,e.green,e.blue,e.alpha)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new o(e.x,e.y,e.z,e.w):void 0},o.packedLength=4,o.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.x,i[o++]=n.y,i[o++]=n.z,i[o]=n.w},o.unpack=function(n,i,a){if(!r(n))throw new t("array is required");return i=e(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i++],a.w=n[i],a},o.fromArray=o.unpack,o.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z,e.w)},o.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z,e.w)},o.minimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i.w=Math.min(e.w,n.w),i},o.maximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i.w=Math.max(e.w,n.w),i},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitude(a)},o.distanceSquared=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitudeSquared(a)},o.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=o.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n.w=e.w/i,n},o.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z+e.w*n.w},o.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i.w=e.w*n.w,i},o.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i.w=e.w+n.w,i},o.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i.w=e.w-n.w,i},o.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i.w=e.w*n,i},o.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i.w=e.w/n,i},o.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n.w=-e.w,n},o.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n.w=Math.abs(e.w),n};var s=new o;o.lerp=function(e,n,i,a){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(n,i,s),a=o.multiplyByScalar(e,1-i,a),o.add(s,a,a)};var u=new o;return o.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=o.normalize(e,u);return o.abs(i,i),n=i.x<=i.y?i.x<=i.z?i.x<=i.w?o.clone(o.UNIT_X,n):o.clone(o.UNIT_W,n):i.z<=i.w?o.clone(o.UNIT_Z,n):o.clone(o.UNIT_W,n):i.y<=i.z?i.y<=i.w?o.clone(o.UNIT_Y,n):o.clone(o.UNIT_W,n):i.z<=i.w?o.clone(o.UNIT_Z,n):o.clone(o.UNIT_W,n)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},o.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]&&e.z===r[t+2]&&e.w===r[t+3]},o.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)&&i.equalsEpsilon(e.z,t.z,n,o)&&i.equalsEpsilon(e.w,t.w,n,o)},o.ZERO=n(new o(0,0,0,0)),o.UNIT_X=n(new o(1,0,0,0)),o.UNIT_Y=n(new o(0,1,0,0)),o.UNIT_Z=n(new o(0,0,1,0)),o.UNIT_W=n(new o(0,0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r,t){return o.equalsEpsilon(this,e,r,t)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},o}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,o){"use strict";function a(e){for(var r=0,t=0;9>t;++t){var n=e[t];r+=n*n}return Math.sqrt(r)}function s(e){for(var r=0,t=0;3>t;++t){var n=e[f.getElementIndex(c[t],h[t])];r+=2*n*n}return Math.sqrt(r)}function u(e,r){for(var t=o.EPSILON15,n=0,i=1,a=0;3>a;++a){var s=Math.abs(e[f.getElementIndex(c[a],h[a])]);s>n&&(i=a,n=s)}var u=1,l=0,E=h[i],d=c[i];if(Math.abs(e[f.getElementIndex(d,E)])>t){var w,_=e[f.getElementIndex(d,d)],R=e[f.getElementIndex(E,E)],m=e[f.getElementIndex(d,E)],T=(_-R)/2/m;w=0>T?-1/(-T+Math.sqrt(1+T*T)):1/(T+Math.sqrt(1+T*T)),u=1/Math.sqrt(1+w*w),l=w*u}return r=f.clone(f.IDENTITY,r),r[f.getElementIndex(E,E)]=r[f.getElementIndex(d,d)]=u,r[f.getElementIndex(d,E)]=l,r[f.getElementIndex(E,d)]=-l,r}var f=function(e,t,n,i,o,a,s,u,f){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(s,0),this[3]=r(t,0),this[4]=r(o,0),this[5]=r(u,0),this[6]=r(n,0),this[7]=r(a,0),this[8]=r(f,0)};f.packedLength=9,f.pack=function(e,i,o){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");o=r(o,0),i[o++]=e[0],i[o++]=e[1],i[o++]=e[2],i[o++]=e[3],i[o++]=e[4],i[o++]=e[5],i[o++]=e[6],i[o++]=e[7],i[o++]=e[8]},f.unpack=function(e,i,o){if(!t(e))throw new n("array is required");return i=r(i,0),t(o)||(o=new f),o[0]=e[i++],o[1]=e[i++],o[2]=e[i++],o[3]=e[i++],o[4]=e[i++],o[5]=e[i++],o[6]=e[i++],o[7]=e[i++],o[8]=e[i++],o},f.clone=function(e,r){return t(e)?t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):new f(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},f.fromArray=function(e,i,o){if(!t(e))throw new n("array is required");return i=r(i,0),t(o)||(o=new f),o[0]=e[i],o[1]=e[i+1],o[2]=e[i+2],o[3]=e[i+3],o[4]=e[i+4],o[5]=e[i+5],o[6]=e[i+6],o[7]=e[i+7],o[8]=e[i+8],o},f.fromColumnMajorArray=function(e,r){if(!t(e))throw new n("values parameter is required");return f.clone(e,r)},f.fromRowMajorArray=function(e,r){if(!t(e))throw new n("values is required.");return t(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},f.fromQuaternion=function(e,r){if(!t(e))throw new n("quaternion is required");var i=e.x*e.x,o=e.x*e.y,a=e.x*e.z,s=e.x*e.w,u=e.y*e.y,l=e.y*e.z,E=e.y*e.w,h=e.z*e.z,c=e.z*e.w,d=e.w*e.w,w=i-u-h+d,_=2*(o-c),R=2*(a+E),m=2*(o+c),T=-i+u-h+d,A=2*(l-s),S=2*(a-E),p=2*(l+s),C=-i-u+h+d;return t(r)?(r[0]=w,r[1]=m,r[2]=S,r[3]=_,r[4]=T,r[5]=p,r[6]=R,r[7]=A,r[8]=C,r):new f(w,_,R,m,T,A,S,p,C)},f.fromScale=function(e,r){if(!t(e))throw new n("scale is required.");return t(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new f(e.x,0,0,0,e.y,0,0,0,e.z)},f.fromUniformScale=function(e,r){if("number"!=typeof e)throw new n("scale is required.");return t(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new f(e,0,0,0,e,0,0,0,e)},f.fromCrossProduct=function(e,r){if(!t(e))throw new n("vector is required.");return t(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new f(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},f.fromRotationX=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=o,r[6]=0,r[7]=-o,r[8]=i,r):new f(1,0,0,0,i,-o,0,o,i)},f.fromRotationY=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=i,r[1]=0,r[2]=-o,r[3]=0,r[4]=1,r[5]=0,r[6]=o,r[7]=0,r[8]=i,r):new f(i,0,o,0,1,0,-o,0,i)},f.fromRotationZ=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=i,r[1]=o,r[2]=0,r[3]=-o,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new f(i,-o,0,o,i,0,0,0,1)},f.toArray=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},f.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>2)throw new n("row must be 0, 1, or 2.");if("number"!=typeof e||0>e||e>2)throw new n("column must be 0, 1, or 2.");return 3*e+r},f.getColumn=function(e,r,i){if(!t(e))throw new n("matrix is required.");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(i))throw new n("result is required");var o=3*r,a=e[o],s=e[o+1],u=e[o+2];return i.x=a,i.y=s,i.z=u,i},f.setColumn=function(e,r,i,o){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(o))throw new n("result is required");o=f.clone(e,o);var a=3*r;return o[a]=i.x,o[a+1]=i.y,o[a+2]=i.z,o},f.getRow=function(e,r,i){if(!t(e))throw new n("matrix is required.");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(i))throw new n("result is required");var o=e[r],a=e[r+3],s=e[r+6];
return i.x=o,i.y=a,i.z=s,i},f.setRow=function(e,r,i,o){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(o))throw new n("result is required");return o=f.clone(e,o),o[r]=i.x,o[r+3]=i.y,o[r+6]=i.z,o};var l=new e;f.getScale=function(r,i){if(!t(r))throw new n("matrix is required.");if(!t(i))throw new n("result is required");return i.x=e.magnitude(e.fromElements(r[0],r[1],r[2],l)),i.y=e.magnitude(e.fromElements(r[3],r[4],r[5],l)),i.z=e.magnitude(e.fromElements(r[6],r[7],r[8],l)),i};var E=new e;f.getMaximumScale=function(r){return f.getScale(r,E),e.maximumComponent(E)},f.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");var o=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],a=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],s=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],u=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],f=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],l=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],E=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],h=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],c=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return i[0]=o,i[1]=a,i[2]=s,i[3]=u,i[4]=f,i[5]=l,i[6]=E,i[7]=h,i[8]=c,i},f.add=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i[0]=e[0]+r[0],i[1]=e[1]+r[1],i[2]=e[2]+r[2],i[3]=e[3]+r[3],i[4]=e[4]+r[4],i[5]=e[5]+r[5],i[6]=e[6]+r[6],i[7]=e[7]+r[7],i[8]=e[8]+r[8],i},f.subtract=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],i[3]=e[3]-r[3],i[4]=e[4]-r[4],i[5]=e[5]-r[5],i[6]=e[6]-r[6],i[7]=e[7]-r[7],i[8]=e[8]-r[8],i},f.multiplyByVector=function(e,r,i){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("cartesian is required");if(!t(i))throw new n("result is required");var o=r.x,a=r.y,s=r.z,u=e[0]*o+e[3]*a+e[6]*s,f=e[1]*o+e[4]*a+e[7]*s,l=e[2]*o+e[5]*a+e[8]*s;return i.x=u,i.y=f,i.z=l,i},f.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scalar must be a number");if(!t(i))throw new n("result is required");return i[0]=e[0]*r,i[1]=e[1]*r,i[2]=e[2]*r,i[3]=e[3]*r,i[4]=e[4]*r,i[5]=e[5]*r,i[6]=e[6]*r,i[7]=e[7]*r,i[8]=e[8]*r,i},f.multiplyByScale=function(e,r,i){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("scale is required");if(!t(i))throw new n("result is required");return i[0]=e[0]*r.x,i[1]=e[1]*r.x,i[2]=e[2]*r.x,i[3]=e[3]*r.y,i[4]=e[4]*r.y,i[5]=e[5]*r.y,i[6]=e[6]*r.z,i[7]=e[7]*r.z,i[8]=e[8]*r.z,i},f.negate=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");return r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},f.transpose=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");var i=e[0],o=e[3],a=e[6],s=e[1],u=e[4],f=e[7],l=e[2],E=e[5],h=e[8];return r[0]=i,r[1]=o,r[2]=a,r[3]=s,r[4]=u,r[5]=f,r[6]=l,r[7]=E,r[8]=h,r};var h=[1,0,0],c=[2,2,1],d=new f,w=new f;return f.computeEigenDecomposition=function(e,r){if(!t(e))throw new n("matrix is required.");var i=o.EPSILON20,l=10,E=0,h=0;t(r)||(r={});for(var c=r.unitary=f.clone(f.IDENTITY,r.unitary),_=r.diagonal=f.clone(e,r.diagonal),R=i*a(_);l>h&&s(_)>R;)u(_,d),f.transpose(d,w),f.multiply(_,d,_),f.multiply(w,_,_),f.multiply(c,d,c),++E>2&&(++h,E=0);return r},f.abs=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");return r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},f.determinant=function(e){if(!t(e))throw new n("matrix is required");var r=e[0],i=e[3],o=e[6],a=e[1],s=e[4],u=e[7],f=e[2],l=e[5],E=e[8];return r*(s*E-l*u)+a*(l*o-i*E)+f*(i*u-s*o)},f.inverse=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");var i=e[0],a=e[1],s=e[2],u=e[3],l=e[4],E=e[5],h=e[6],c=e[7],d=e[8],w=f.determinant(e);if(Math.abs(w)<=o.EPSILON15)throw new n("matrix is not invertible");r[0]=l*d-c*E,r[1]=c*s-a*d,r[2]=a*E-l*s,r[3]=h*E-u*d,r[4]=i*d-h*s,r[5]=u*s-i*E,r[6]=u*c-h*l,r[7]=h*a-i*c,r[8]=i*l-u*a;var _=1/w;return f.multiplyByScalar(r,_,r)},f.equals=function(e,r){return e===r||t(e)&&t(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]},f.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon must be a number");return e===r||t(e)&&t(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},f.IDENTITY=i(new f(1,0,0,0,1,0,0,0,1)),f.ZERO=i(new f(0,0,0,0,0,0,0,0,0)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN1ROW0=3,f.COLUMN1ROW1=4,f.COLUMN1ROW2=5,f.COLUMN2ROW0=6,f.COLUMN2ROW1=7,f.COLUMN2ROW2=8,f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.equalsArray=function(e,r,t){return e[0]===r[t]&&e[1]===r[t+1]&&e[2]===r[t+2]&&e[3]===r[t+3]&&e[4]===r[t+4]&&e[5]===r[t+5]&&e[6]===r[t+6]&&e[7]===r[t+7]&&e[8]===r[t+8]},f.prototype.equalsEpsilon=function(e,r){return f.equalsEpsilon(this,e,r)},f.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},f}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var r=function(e){this.name="RuntimeError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,r,t,n,i,o,a,s,u){"use strict";var f=function(e,r,n,i,o,a,s,u,f,l,E,h,c,d,w,_){this[0]=t(e,0),this[1]=t(o,0),this[2]=t(f,0),this[3]=t(c,0),this[4]=t(r,0),this[5]=t(a,0),this[6]=t(l,0),this[7]=t(d,0),this[8]=t(n,0),this[9]=t(s,0),this[10]=t(E,0),this[11]=t(w,0),this[12]=t(i,0),this[13]=t(u,0),this[14]=t(h,0),this[15]=t(_,0)};f.packedLength=16,f.pack=function(e,r,o){if(!n(e))throw new i("value is required");if(!n(r))throw new i("array is required");o=t(o,0),r[o++]=e[0],r[o++]=e[1],r[o++]=e[2],r[o++]=e[3],r[o++]=e[4],r[o++]=e[5],r[o++]=e[6],r[o++]=e[7],r[o++]=e[8],r[o++]=e[9],r[o++]=e[10],r[o++]=e[11],r[o++]=e[12],r[o++]=e[13],r[o++]=e[14],r[o]=e[15]},f.unpack=function(e,r,o){if(!n(e))throw new i("array is required");return r=t(r,0),n(o)||(o=new f),o[0]=e[r++],o[1]=e[r++],o[2]=e[r++],o[3]=e[r++],o[4]=e[r++],o[5]=e[r++],o[6]=e[r++],o[7]=e[r++],o[8]=e[r++],o[9]=e[r++],o[10]=e[r++],o[11]=e[r++],o[12]=e[r++],o[13]=e[r++],o[14]=e[r++],o[15]=e[r],o},f.clone=function(e,r){return n(e)?n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):new f(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},f.fromArray=f.unpack,f.fromColumnMajorArray=function(e,r){if(!n(e))throw new i("values is required");return f.clone(e,r)},f.fromRowMajorArray=function(e,r){if(!n(e))throw new i("values is required.");return n(r)?(r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=e[1],r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=e[2],r[9]=e[6],r[10]=e[10],r[11]=e[14],r[12]=e[3],r[13]=e[7],r[14]=e[11],r[15]=e[15],r):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},f.fromRotationTranslation=function(r,o,a){if(!n(r))throw new i("rotation is required.");return o=t(o,e.ZERO),n(a)?(a[0]=r[0],a[1]=r[1],a[2]=r[2],a[3]=0,a[4]=r[3],a[5]=r[4],a[6]=r[5],a[7]=0,a[8]=r[6],a[9]=r[7],a[10]=r[8],a[11]=0,a[12]=o.x,a[13]=o.y,a[14]=o.z,a[15]=1,a):new f(r[0],r[3],r[6],o.x,r[1],r[4],r[7],o.y,r[2],r[5],r[8],o.z,0,0,0,1)},f.fromTranslationQuaternionRotationScale=function(e,r,t,o){if(!n(e))throw new i("translation is required.");if(!n(r))throw new i("rotation is required.");if(!n(t))throw new i("scale is required.");n(o)||(o=new f);var a=t.x,s=t.y,u=t.z,l=r.x*r.x,E=r.x*r.y,h=r.x*r.z,c=r.x*r.w,d=r.y*r.y,w=r.y*r.z,_=r.y*r.w,R=r.z*r.z,m=r.z*r.w,T=r.w*r.w,A=l-d-R+T,S=2*(E-m),p=2*(h+_),C=2*(E+m),N=-l+d-R+T,I=2*(w-c),g=2*(h-_),M=2*(w+c),O=-l-d+R+T;return o[0]=A*a,o[1]=C*a,o[2]=g*a,o[3]=0,o[4]=S*s,o[5]=N*s,o[6]=M*s,o[7]=0,o[8]=p*u,o[9]=I*u,o[10]=O*u,o[11]=0,o[12]=e.x,o[13]=e.y,o[14]=e.z,o[15]=1,o},f.fromTranslation=function(e,r){if(!n(e))throw new i("translation is required.");return f.fromRotationTranslation(s.IDENTITY,e,r)},f.fromScale=function(e,r){if(!n(e))throw new i("scale is required.");return n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e.y,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e.z,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new f(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},f.fromUniformScale=function(e,r){if("number"!=typeof e)throw new i("scale is required.");return n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new f(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,E=new e,h=new e;f.fromCamera=function(r,t){if(!n(r))throw new i("camera is required.");var o=r.eye,a=r.target,s=r.up;if(!n(o))throw new i("camera.eye is required.");if(!n(a))throw new i("camera.target is required.");if(!n(s))throw new i("camera.up is required.");e.normalize(e.subtract(a,o,l),l),e.normalize(e.cross(l,s,E),E),e.normalize(e.cross(E,l,h),h);var u=E.x,c=E.y,d=E.z,w=l.x,_=l.y,R=l.z,m=h.x,T=h.y,A=h.z,S=o.x,p=o.y,C=o.z,N=u*-S+c*-p+d*-C,I=m*-S+T*-p+A*-C,g=w*S+_*p+R*C;return n(t)?(t[0]=u,t[1]=m,t[2]=-w,t[3]=0,t[4]=c,t[5]=T,t[6]=-_,t[7]=0,t[8]=d,t[9]=A,t[10]=-R,t[11]=0,t[12]=N,t[13]=I,t[14]=g,t[15]=1,t):new f(u,c,d,N,m,T,A,I,-w,-_,-R,g,0,0,0,1)},f.computePerspectiveFieldOfView=function(e,r,t,o,a){if(0>=e||e>Math.PI)throw new i("fovY must be in [0, PI).");if(0>=r)throw new i("aspectRatio must be greater than zero.");if(0>=t)throw new i("near must be greater than zero.");if(0>=o)throw new i("far must be greater than zero.");if(!n(a))throw new i("result is required");var s=Math.tan(.5*e),u=1/s,f=u/r,l=(o+t)/(t-o),E=2*o*t/(t-o);return a[0]=f,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=l,a[11]=-1,a[12]=0,a[13]=0,a[14]=E,a[15]=0,a},f.computeOrthographicOffCenter=function(e,r,t,o,a,s,u){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(o))throw new i("top is required.");if(!n(a))throw new i("near is required.");if(!n(s))throw new i("far is required.");if(!n(u))throw new i("result is required");var f=1/(r-e),l=1/(o-t),E=1/(s-a),h=-(r+e)*f,c=-(o+t)*l,d=-(s+a)*E;return f*=2,l*=2,E*=-2,u[0]=f,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=l,u[6]=0,u[7]=0,u[8]=0,u[9]=0,u[10]=E,u[11]=0,u[12]=h,u[13]=c,u[14]=d,u[15]=1,u},f.computePerspectiveOffCenter=function(e,r,t,o,a,s,u){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(o))throw new i("top is required.");if(!n(a))throw new i("near is required.");if(!n(s))throw new i("far is required.");if(!n(u))throw new i("result is required");var f=2*a/(r-e),l=2*a/(o-t),E=(r+e)/(r-e),h=(o+t)/(o-t),c=-(s+a)/(s-a),d=-1,w=-2*s*a/(s-a);return u[0]=f,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=l,u[6]=0,u[7]=0,u[8]=E,u[9]=h,u[10]=c,u[11]=d,u[12]=0,u[13]=0,u[14]=w,u[15]=0,u},f.computeInfinitePerspectiveOffCenter=function(e,r,t,o,a,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(o))throw new i("top is required.");if(!n(a))throw new i("near is required.");if(!n(s))throw new i("result is required");var u=2*a/(r-e),f=2*a/(o-t),l=(r+e)/(r-e),E=(o+t)/(o-t),h=-1,c=-1,d=-2*a;return s[0]=u,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=f,s[6]=0,s[7]=0,s[8]=l,s[9]=E,s[10]=h,s[11]=c,s[12]=0,s[13]=0,s[14]=d,s[15]=0,s},f.computeViewportTransformation=function(e,r,o,a){if(!n(a))throw new i("result is required");e=t(e,t.EMPTY_OBJECT);var s=t(e.x,0),u=t(e.y,0),f=t(e.width,0),l=t(e.height,0);r=t(r,0),o=t(o,1);var E=.5*f,h=.5*l,c=.5*(o-r),d=E,w=h,_=c,R=s+E,m=u+h,T=r+c,A=1;return a[0]=d,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=w,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=_,a[11]=0,a[12]=R,a[13]=m,a[14]=T,a[15]=A,a},f.toArray=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},f.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>3)throw new i("row must be 0, 1, 2, or 3.");if("number"!=typeof e||0>e||e>3)throw new i("column must be 0, 1, 2, or 3.");return 4*e+r},f.getColumn=function(e,r,t){if(!n(e))throw new i("matrix is required.");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(t))throw new i("result is required");var o=4*r,a=e[o],s=e[o+1],u=e[o+2],f=e[o+3];return t.x=a,t.y=s,t.z=u,t.w=f,t},f.setColumn=function(e,r,t,o){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(o))throw new i("result is required");o=f.clone(e,o);var a=4*r;return o[a]=t.x,o[a+1]=t.y,o[a+2]=t.z,o[a+3]=t.w,o},f.setTranslation=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("translation is required");if(!n(t))throw new i("result is required");return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=r.x,t[13]=r.y,t[14]=r.z,t[15]=e[15],t},f.getRow=function(e,r,t){if(!n(e))throw new i("matrix is required.");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(t))throw new i("result is required");var o=e[r],a=e[r+4],s=e[r+8],u=e[r+12];return t.x=o,t.y=a,t.z=s,t.w=u,t},f.setRow=function(e,r,t,o){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(o))throw new i("result is required");return o=f.clone(e,o),o[r]=t.x,o[r+4]=t.y,o[r+8]=t.z,o[r+12]=t.w,o};var c=new e;f.getScale=function(r,t){if(!n(r))throw new i("matrix is required.");if(!n(t))throw new i("result is required");return t.x=e.magnitude(e.fromElements(r[0],r[1],r[2],c)),t.y=e.magnitude(e.fromElements(r[4],r[5],r[6],c)),t.z=e.magnitude(e.fromElements(r[8],r[9],r[10],c)),t};var d=new e;f.getMaximumScale=function(r){return f.getScale(r,d),e.maximumComponent(d)},f.multiply=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");var o=e[0],a=e[1],s=e[2],u=e[3],f=e[4],l=e[5],E=e[6],h=e[7],c=e[8],d=e[9],w=e[10],_=e[11],R=e[12],m=e[13],T=e[14],A=e[15],S=r[0],p=r[1],C=r[2],N=r[3],I=r[4],g=r[5],M=r[6],O=r[7],y=r[8],v=r[9],F=r[10],q=r[11],L=r[12],D=r[13],P=r[14],U=r[15],B=o*S+f*p+c*C+R*N,b=a*S+l*p+d*C+m*N,x=s*S+E*p+w*C+T*N,G=u*S+h*p+_*C+A*N,z=o*I+f*g+c*M+R*O,H=a*I+l*g+d*M+m*O,V=s*I+E*g+w*M+T*O,W=u*I+h*g+_*M+A*O,X=o*y+f*v+c*F+R*q,Y=a*y+l*v+d*F+m*q,K=s*y+E*v+w*F+T*q,k=u*y+h*v+_*F+A*q,Z=o*L+f*D+c*P+R*U,j=a*L+l*D+d*P+m*U,Q=s*L+E*D+w*P+T*U,J=u*L+h*D+_*P+A*U;return t[0]=B,t[1]=b,t[2]=x,t[3]=G,t[4]=z,t[5]=H,t[6]=V,t[7]=W,t[8]=X,t[9]=Y,t[10]=K,t[11]=k,t[12]=Z,t[13]=j,t[14]=Q,t[15]=J,t},f.add=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t[6]=e[6]+r[6],t[7]=e[7]+r[7],t[8]=e[8]+r[8],t[9]=e[9]+r[9],t[10]=e[10]+r[10],t[11]=e[11]+r[11],t[12]=e[12]+r[12],t[13]=e[13]+r[13],t[14]=e[14]+r[14],t[15]=e[15]+r[15],t},f.subtract=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t[4]=e[4]-r[4],t[5]=e[5]-r[5],t[6]=e[6]-r[6],t[7]=e[7]-r[7],t[8]=e[8]-r[8],t[9]=e[9]-r[9],t[10]=e[10]-r[10],t[11]=e[11]-r[11],t[12]=e[12]-r[12],t[13]=e[13]-r[13],t[14]=e[14]-r[14],t[15]=e[15]-r[15],t},f.multiplyTransformation=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");var o=e[0],a=e[1],s=e[2],u=e[4],f=e[5],l=e[6],E=e[8],h=e[9],c=e[10],d=e[12],w=e[13],_=e[14],R=r[0],m=r[1],T=r[2],A=r[4],S=r[5],p=r[6],C=r[8],N=r[9],I=r[10],g=r[12],M=r[13],O=r[14],y=o*R+u*m+E*T,v=a*R+f*m+h*T,F=s*R+l*m+c*T,q=o*A+u*S+E*p,L=a*A+f*S+h*p,D=s*A+l*S+c*p,P=o*C+u*N+E*I,U=a*C+f*N+h*I,B=s*C+l*N+c*I,b=o*g+u*M+E*O+d,x=a*g+f*M+h*O+w,G=s*g+l*M+c*O+_;return t[0]=y,t[1]=v,t[2]=F,t[3]=0,t[4]=q,t[5]=L,t[6]=D,t[7]=0,t[8]=P,t[9]=U,t[10]=B,t[11]=0,t[12]=b,t[13]=x,t[14]=G,t[15]=1,t},f.multiplyByMatrix3=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("rotation is required");if(!n(t))throw new i("result is required");var o=e[0],a=e[1],s=e[2],u=e[4],f=e[5],l=e[6],E=e[8],h=e[9],c=e[10],d=r[0],w=r[1],_=r[2],R=r[3],m=r[4],T=r[5],A=r[6],S=r[7],p=r[8],C=o*d+u*w+E*_,N=a*d+f*w+h*_,I=s*d+l*w+c*_,g=o*R+u*m+E*T,M=a*R+f*m+h*T,O=s*R+l*m+c*T,y=o*A+u*S+E*p,v=a*A+f*S+h*p,F=s*A+l*S+c*p;return t[0]=C,t[1]=N,t[2]=I,t[3]=0,t[4]=g,t[5]=M,t[6]=O,t[7]=0,t[8]=y,t[9]=v,t[10]=F,t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},f.multiplyByTranslation=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("translation is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,s=r.z,u=o*e[0]+a*e[4]+s*e[8]+e[12],f=o*e[1]+a*e[5]+s*e[9]+e[13],l=o*e[2]+a*e[6]+s*e[10]+e[14];return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=u,t[13]=f,t[14]=l,t[15]=e[15],t};var w=new e;f.multiplyByUniformScale=function(e,r,t){if(!n(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scale is required");if(!n(t))throw new i("result is required");return w.x=r,w.y=r,w.z=r,f.multiplyByScale(e,w,t)},f.multiplyByScale=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("scale is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,s=r.z;return 1===o&&1===a&&1===s?f.clone(e,t):(t[0]=o*e[0],t[1]=o*e[1],t[2]=o*e[2],t[3]=0,t[4]=a*e[4],t[5]=a*e[5],t[6]=a*e[6],t[7]=0,t[8]=s*e[8],t[9]=s*e[9],t[10]=s*e[10],t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=1,t)},f.multiplyByVector=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,s=r.z,u=r.w,f=e[0]*o+e[4]*a+e[8]*s+e[12]*u,l=e[1]*o+e[5]*a+e[9]*s+e[13]*u,E=e[2]*o+e[6]*a+e[10]*s+e[14]*u,h=e[3]*o+e[7]*a+e[11]*s+e[15]*u;return t.x=f,t.y=l,t.z=E,t.w=h,t},f.multiplyByPointAsVector=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,s=r.z,u=e[0]*o+e[4]*a+e[8]*s,f=e[1]*o+e[5]*a+e[9]*s,l=e[2]*o+e[6]*a+e[10]*s;return t.x=u,t.y=f,t.z=l,t},f.multiplyByPoint=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,s=r.z,u=e[0]*o+e[4]*a+e[8]*s+e[12],f=e[1]*o+e[5]*a+e[9]*s+e[13],l=e[2]*o+e[6]*a+e[10]*s+e[14];return t.x=u,t.y=f,t.z=l,t},f.multiplyByScalar=function(e,r,t){if(!n(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scalar must be a number");if(!n(t))throw new i("result is required");return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t},f.negate=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r[9]=-e[9],r[10]=-e[10],r[11]=-e[11],r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=-e[15],r},f.transpose=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");var t=e[1],o=e[2],a=e[3],s=e[6],u=e[7],f=e[11];return r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=t,r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=o,r[9]=s,r[10]=e[10],r[11]=e[14],r[12]=a,r[13]=u,r[14]=f,r[15]=e[15],r},f.abs=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r[9]=Math.abs(e[9]),r[10]=Math.abs(e[10]),r[11]=Math.abs(e[11]),r[12]=Math.abs(e[12]),r[13]=Math.abs(e[13]),r[14]=Math.abs(e[14]),r[15]=Math.abs(e[15]),r},f.equals=function(e,r){return e===r||n(e)&&n(r)&&e[12]===r[12]&&e[13]===r[13]&&e[14]===r[14]&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[8]===r[8]&&e[9]===r[9]&&e[10]===r[10]&&e[3]===r[3]&&e[7]===r[7]&&e[11]===r[11]&&e[15]===r[15]},f.equalsEpsilon=function(e,r,t){if("number"!=typeof t)throw new i("epsilon must be a number");return e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=t&&Math.abs(e[1]-r[1])<=t&&Math.abs(e[2]-r[2])<=t&&Math.abs(e[3]-r[3])<=t&&Math.abs(e[4]-r[4])<=t&&Math.abs(e[5]-r[5])<=t&&Math.abs(e[6]-r[6])<=t&&Math.abs(e[7]-r[7])<=t&&Math.abs(e[8]-r[8])<=t&&Math.abs(e[9]-r[9])<=t&&Math.abs(e[10]-r[10])<=t&&Math.abs(e[11]-r[11])<=t&&Math.abs(e[12]-r[12])<=t&&Math.abs(e[13]-r[13])<=t&&Math.abs(e[14]-r[14])<=t&&Math.abs(e[15]-r[15])<=t},f.getTranslation=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r.x=e[12],r.y=e[13],r.z=e[14],r},f.getRotation=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[4],r[4]=e[5],r[5]=e[6],r[6]=e[8],r[7]=e[9],r[8]=e[10],r};var _=new s,R=new s,m=new r,T=new r(0,0,0,1);return f.inverse=function(e,t){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("result is required");if(s.equalsEpsilon(f.getRotation(e,_),R,a.EPSILON7)&&r.equals(f.getRow(e,3,m),T))return t[0]=0,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=0,t[11]=0,t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=1,t;var o=e[0],l=e[4],E=e[8],h=e[12],c=e[1],d=e[5],w=e[9],A=e[13],S=e[2],p=e[6],C=e[10],N=e[14],I=e[3],g=e[7],M=e[11],O=e[15],y=C*O,v=N*M,F=p*O,q=N*g,L=p*M,D=C*g,P=S*O,U=N*I,B=S*M,b=C*I,x=S*g,G=p*I,z=y*d+q*w+L*A-(v*d+F*w+D*A),H=v*c+P*w+b*A-(y*c+U*w+B*A),V=F*c+U*d+x*A-(q*c+P*d+G*A),W=D*c+B*d+G*w-(L*c+b*d+x*w),X=v*l+F*E+D*h-(y*l+q*E+L*h),Y=y*o+U*E+B*h-(v*o+P*E+b*h),K=q*o+P*l+G*h-(F*o+U*l+x*h),k=L*o+b*l+x*E-(D*o+B*l+G*E);y=E*A,v=h*w,F=l*A,q=h*d,L=l*w,D=E*d,P=o*A,U=h*c,B=o*w,b=E*c,x=o*d,G=l*c;var Z=y*g+q*M+L*O-(v*g+F*M+D*O),j=v*I+P*M+b*O-(y*I+U*M+B*O),Q=F*I+U*g+x*O-(q*I+P*g+G*O),J=D*I+B*g+G*M-(L*I+b*g+x*M),$=F*C+D*N+v*p-(L*N+y*p+q*C),ee=B*N+y*S+U*C-(P*C+b*N+v*S),re=P*p+G*N+q*S-(x*N+F*S+U*p),te=x*C+L*S+b*p-(B*p+G*C+D*S),ne=o*z+l*H+E*V+h*W;if(Math.abs(ne)<a.EPSILON20)throw new u("matrix is not invertible because its determinate is zero.");return ne=1/ne,t[0]=z*ne,t[1]=H*ne,t[2]=V*ne,t[3]=W*ne,t[4]=X*ne,t[5]=Y*ne,t[6]=K*ne,t[7]=k*ne,t[8]=Z*ne,t[9]=j*ne,t[10]=Q*ne,t[11]=J*ne,t[12]=$*ne,t[13]=ee*ne,t[14]=re*ne,t[15]=te*ne,t},f.inverseTransformation=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");var t=e[0],o=e[1],a=e[2],s=e[4],u=e[5],f=e[6],l=e[8],E=e[9],h=e[10],c=e[12],d=e[13],w=e[14],_=-t*c-o*d-a*w,R=-s*c-u*d-f*w,m=-l*c-E*d-h*w;return r[0]=t,r[1]=s,r[2]=l,r[3]=0,r[4]=o,r[5]=u,r[6]=E,r[7]=0,r[8]=a,r[9]=f,r[10]=h,r[11]=0,r[12]=_,r[13]=R,r[14]=m,r[15]=1,r},f.IDENTITY=o(new f(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),f.ZERO=o(new f(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN0ROW3=3,f.COLUMN1ROW0=4,f.COLUMN1ROW1=5,f.COLUMN1ROW2=6,f.COLUMN1ROW3=7,f.COLUMN2ROW0=8,f.COLUMN2ROW1=9,f.COLUMN2ROW2=10,f.COLUMN2ROW3=11,f.COLUMN3ROW0=12,f.COLUMN3ROW1=13,f.COLUMN3ROW2=14,f.COLUMN3ROW3=15,f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.equalsArray=function(e,r,t){return e[0]===r[t]&&e[1]===r[t+1]&&e[2]===r[t+2]&&e[3]===r[t+3]&&e[4]===r[t+4]&&e[5]===r[t+5]&&e[6]===r[t+6]&&e[7]===r[t+7]&&e[8]===r[t+8]&&e[9]===r[t+9]&&e[10]===r[t+10]&&e[11]===r[t+11]&&e[12]===r[t+12]&&e[13]===r[t+13]&&e[14]===r[t+14]&&e[15]===r[t+15]},f.prototype.equalsEpsilon=function(e,r){return f.equalsEpsilon(this,e,r)},f.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},f}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,r,t,n){"use strict";var i=function(n,i){if(!r(n))throw new t("normal is required.");if(!r(i))throw new t("distance is required.");this.normal=e.clone(n),this.distance=i};i.fromPointNormal=function(n,o,a){if(!r(n))throw new t("point is required.");if(!r(o))throw new t("normal is required.");var s=-e.dot(o,n);return r(a)?(e.clone(o,a.normal),a.distance=s,a):new i(o,s)};var o=new e;return i.fromCartesian4=function(n,a){if(!r(n))throw new t("coefficients is required.");var s=e.fromCartesian4(n,o),u=n.w;return r(a)?(e.clone(s,a.normal),a.distance=u,a):new i(s,u)},i.getPointDistance=function(n,i){if(!r(n))throw new t("plane is required.");if(!r(i))throw new t("point is required.");return e.dot(n.normal,i)+n.distance},i.ORIGIN_XY_PLANE=n(new i(e.UNIT_Z,0)),i.ORIGIN_YZ_PLANE=n(new i(e.UNIT_X,0)),i.ORIGIN_ZX_PLANE=n(new i(e.UNIT_Y,0)),i}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,r,t,n,i,o,a,s){"use strict";var u=function(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)};n(u.prototype,{width:{get:function(){return u.computeWidth(this)}},height:{get:function(){return u.computeHeight(this)}}}),u.packedLength=4,u.pack=function(e,n,o){if(!t(e))throw new i("value is required");if(!t(n))throw new i("array is required");o=r(o,0),n[o++]=e.west,n[o++]=e.south,n[o++]=e.east,n[o]=e.north},u.unpack=function(e,n,o){if(!t(e))throw new i("array is required");return n=r(n,0),t(o)||(o=new u),o.west=e[n++],o.south=e[n++],o.east=e[n++],o.north=e[n],o},u.computeWidth=function(e){if(!t(e))throw new i("rectangle is required.");var r=e.east,n=e.west;return n>r&&(r+=s.TWO_PI),r-n},u.computeHeight=function(e){if(!t(e))throw new i("rectangle is required.");return e.north-e.south},u.fromDegrees=function(e,n,i,o,a){return e=s.toRadians(r(e,0)),n=s.toRadians(r(n,0)),i=s.toRadians(r(i,0)),o=s.toRadians(r(o,0)),t(a)?(a.west=e,a.south=n,a.east=i,a.north=o,a):new u(e,n,i,o)},u.fromCartographicArray=function(e,r){if(!t(e))throw new i("cartographics is required.");for(var n=Number.MAX_VALUE,o=-Number.MAX_VALUE,a=Number.MAX_VALUE,s=-Number.MAX_VALUE,f=0,l=e.length;l>f;f++){var E=e[f];n=Math.min(n,E.longitude),o=Math.max(o,E.longitude),a=Math.min(a,E.latitude),s=Math.max(s,E.latitude)}return t(r)?(r.west=n,r.south=a,r.east=o,r.north=s,r):new u(n,a,o,s)},u.clone=function(e,r){return t(e)?t(r)?(r.west=e.west,r.south=e.south,r.east=e.east,r.north=e.north,r):new u(e.west,e.south,e.east,e.north):void 0},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.equals=function(e,r){return e===r||t(e)&&t(r)&&e.west===r.west&&e.south===r.south&&e.east===r.east&&e.north===r.north},u.prototype.equalsEpsilon=function(e,r){if("number"!=typeof r)throw new i("epsilon is required and must be a number.");return t(e)&&Math.abs(this.west-e.west)<=r&&Math.abs(this.south-e.south)<=r&&Math.abs(this.east-e.east)<=r&&Math.abs(this.north-e.north)<=r},u.validate=function(e){if(!t(e))throw new i("rectangle is required");var r=e.north;if("number"!=typeof r)throw new i("north is required to be a number.");if(r<-s.PI_OVER_TWO||r>s.PI_OVER_TWO)throw new i("north must be in the interval [-Pi/2, Pi/2].");var n=e.south;if("number"!=typeof n)throw new i("south is required to be a number.");if(n<-s.PI_OVER_TWO||n>s.PI_OVER_TWO)throw new i("south must be in the interval [-Pi/2, Pi/2].");var o=e.west;if("number"!=typeof o)throw new i("west is required to be a number.");if(o<-Math.PI||o>Math.PI)throw new i("west must be in the interval [-Pi, Pi].");var a=e.east;if("number"!=typeof a)throw new i("east is required to be a number.");if(a<-Math.PI||a>Math.PI)throw new i("east must be in the interval [-Pi, Pi].")},u.southwest=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.west,n.latitude=r.south,n.height=0,n):new e(r.west,r.south)},u.northwest=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.west,n.latitude=r.north,n.height=0,n):new e(r.west,r.north)},u.northeast=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.east,n.latitude=r.north,n.height=0,n):new e(r.east,r.north)},u.southeast=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.east,n.latitude=r.south,n.height=0,n):new e(r.east,r.south)},u.center=function(r,n){if(!t(r))throw new i("rectangle is required");var o=r.east,a=r.west;a>o&&(o+=s.TWO_PI);var u=s.negativePiToPi(.5*(a+o)),f=.5*(r.south+r.north);return t(n)?(n.longitude=u,n.latitude=f,n.height=0,n):new e(u,f)},u.intersection=function(e,r,n){if(!t(e))throw new i("rectangle is required");if(!t(r))throw new i("otherRectangle is required.");var o=e.east,a=e.west,f=r.east,l=r.west;a>o&&f>0?o+=s.TWO_PI:l>f&&o>0&&(f+=s.TWO_PI),a>o&&0>l?l+=s.TWO_PI:l>f&&0>a&&(a+=s.TWO_PI);var E=s.negativePiToPi(Math.max(a,l)),h=s.negativePiToPi(Math.min(o,f));if((e.west<e.east||r.west<r.east)&&E>=h)return void 0;var c=Math.max(e.south,r.south),d=Math.min(e.north,r.north);return c>=d?void 0:t(n)?(n.west=E,n.south=c,n.east=h,n.north=d,n):new u(E,c,h,d)},u.contains=function(e,r){if(!t(e))throw new i("rectangle is required");if(!t(r))throw new i("cartographic is required.");var n=r.longitude,o=r.latitude,a=e.west,u=e.east;return a>u&&(u+=s.TWO_PI,0>n&&(n+=s.TWO_PI)),(n>a||s.equalsEpsilon(n,a,s.EPSILON14))&&(u>n||s.equalsEpsilon(n,u,s.EPSILON14))&&o>=e.south&&o<=e.north};var f=new e;return u.subsample=function(e,n,a,l){if(!t(e))throw new i("rectangle is required");n=r(n,o.WGS84),a=r(a,0),t(l)||(l=[]);var E=0,h=e.north,c=e.south,d=e.east,w=e.west,_=f;_.height=a,_.longitude=w,_.latitude=h,l[E]=n.cartographicToCartesian(_,l[E]),E++,_.longitude=d,l[E]=n.cartographicToCartesian(_,l[E]),E++,_.latitude=c,l[E]=n.cartographicToCartesian(_,l[E]),E++,_.longitude=w,l[E]=n.cartographicToCartesian(_,l[E]),E++,0>h?_.latitude=h:c>0?_.latitude=c:_.latitude=0;for(var R=1;8>R;++R)_.longitude=-Math.PI+R*s.PI_OVER_TWO,u.contains(e,_)&&(l[E]=n.cartographicToCartesian(_,l[E]),E++);return 0===_.latitude&&(_.longitude=w,l[E]=n.cartographicToCartesian(_,l[E]),E++,_.longitude=d,l[E]=n.cartographicToCartesian(_,l[E]),E++),l.length=E,l},u.MAX_VALUE=a(new u(-Math.PI,-s.PI_OVER_TWO,Math.PI,s.PI_OVER_TWO)),u}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Plane","./Rectangle"],function(e,r,t,n,i,o,a,s,u,f,l,E,h){
"use strict";var c=function(r,n){this.center=e.clone(t(r,e.ZERO)),this.radius=t(n,0)},d=new e,w=new e,_=new e,R=new e,m=new e,T=new e,A=new e,S=new e,p=new e,C=new e,N=new e,I=new e;c.fromPoints=function(r,t){if(n(t)||(t=new c),!n(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;for(var i=e.clone(r[0],A),o=e.clone(i,d),a=e.clone(i,w),s=e.clone(i,_),u=e.clone(i,R),f=e.clone(i,m),l=e.clone(i,T),E=r.length,h=1;E>h;h++){e.clone(r[h],i);var g=i.x,M=i.y,O=i.z;g<o.x&&e.clone(i,o),g>u.x&&e.clone(i,u),M<a.y&&e.clone(i,a),M>f.y&&e.clone(i,f),O<s.z&&e.clone(i,s),O>l.z&&e.clone(i,l)}var y=e.magnitudeSquared(e.subtract(u,o,S)),v=e.magnitudeSquared(e.subtract(f,a,S)),F=e.magnitudeSquared(e.subtract(l,s,S)),q=o,L=u,D=y;v>D&&(D=v,q=a,L=f),F>D&&(D=F,q=s,L=l);var P=p;P.x=.5*(q.x+L.x),P.y=.5*(q.y+L.y),P.z=.5*(q.z+L.z);var U=e.magnitudeSquared(e.subtract(L,P,S)),B=Math.sqrt(U),b=C;b.x=o.x,b.y=a.y,b.z=s.z;var x=N;x.x=u.x,x.y=f.y,x.z=l.z;var G=e.multiplyByScalar(e.add(b,x,S),.5,I),z=0;for(h=0;E>h;h++){e.clone(r[h],i);var H=e.magnitude(e.subtract(i,G,S));H>z&&(z=H);var V=e.magnitudeSquared(e.subtract(i,P,S));if(V>U){var W=Math.sqrt(V);B=.5*(B+W),U=B*B;var X=W-B;P.x=(B*P.x+X*i.x)/W,P.y=(B*P.y+X*i.y)/W,P.z=(B*P.z+X*i.z)/W}}return z>B?(e.clone(P,t.center),t.radius=B):(e.clone(G,t.center),t.radius=z),t};var g=new s,M=new e,O=new e,y=new r,v=new r;c.fromRectangle2D=function(e,r,t){return c.fromRectangleWithHeights2D(e,r,0,0,t)},c.fromRectangleWithHeights2D=function(r,i,o,a,s){if(n(s)||(s=new c),!n(r))return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;i=t(i,g),h.southwest(r,y),y.height=o,h.northeast(r,v),v.height=a;var u=i.project(y,M),f=i.project(v,O),l=f.x-u.x,E=f.y-u.y,d=f.z-u.z;s.radius=.5*Math.sqrt(l*l+E*E+d*d);var w=s.center;return w.x=u.x+.5*l,w.y=u.y+.5*E,w.z=u.z+.5*d,s};var F=[];c.fromRectangle3D=function(e,r,i,o){r=t(r,a.WGS84),i=t(i,0);var s;return n(e)&&(s=h.subsample(e,r,i,F)),c.fromPoints(s,o)},c.fromVertices=function(r,i,a,s){if(n(s)||(s=new c),!n(r)||0===r.length)return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;if(i=t(i,e.ZERO),a=t(a,3),3>a)throw new o("stride must be 3 or greater.");var u=A;u.x=r[0]+i.x,u.y=r[1]+i.y,u.z=r[2]+i.z;for(var f=e.clone(u,d),l=e.clone(u,w),E=e.clone(u,_),h=e.clone(u,R),g=e.clone(u,m),M=e.clone(u,T),O=r.length,y=0;O>y;y+=a){var v=r[y]+i.x,F=r[y+1]+i.y,q=r[y+2]+i.z;u.x=v,u.y=F,u.z=q,v<f.x&&e.clone(u,f),v>h.x&&e.clone(u,h),F<l.y&&e.clone(u,l),F>g.y&&e.clone(u,g),q<E.z&&e.clone(u,E),q>M.z&&e.clone(u,M)}var L=e.magnitudeSquared(e.subtract(h,f,S)),D=e.magnitudeSquared(e.subtract(g,l,S)),P=e.magnitudeSquared(e.subtract(M,E,S)),U=f,B=h,b=L;D>b&&(b=D,U=l,B=g),P>b&&(b=P,U=E,B=M);var x=p;x.x=.5*(U.x+B.x),x.y=.5*(U.y+B.y),x.z=.5*(U.z+B.z);var G=e.magnitudeSquared(e.subtract(B,x,S)),z=Math.sqrt(G),H=C;H.x=f.x,H.y=l.y,H.z=E.z;var V=N;V.x=h.x,V.y=g.y,V.z=M.z;var W=e.multiplyByScalar(e.add(H,V,S),.5,I),X=0;for(y=0;O>y;y+=a){u.x=r[y]+i.x,u.y=r[y+1]+i.y,u.z=r[y+2]+i.z;var Y=e.magnitude(e.subtract(u,W,S));Y>X&&(X=Y);var K=e.magnitudeSquared(e.subtract(u,x,S));if(K>G){var k=Math.sqrt(K);z=.5*(z+k),G=z*z;var Z=k-z;x.x=(z*x.x+Z*u.x)/k,x.y=(z*x.y+Z*u.y)/k,x.z=(z*x.z+Z*u.z)/k}}return X>z?(e.clone(x,s.center),s.radius=z):(e.clone(W,s.center),s.radius=X),s},c.fromCornerPoints=function(r,t,i){if(!n(r)||!n(t))throw new o("corner and oppositeCorner are required.");n(i)||(i=new c);var a=i.center;return e.add(r,t,a),e.multiplyByScalar(a,.5,a),i.radius=e.distance(a,t),i},c.fromEllipsoid=function(r,t){if(!n(r))throw new o("ellipsoid is required.");return n(t)||(t=new c),e.clone(e.ZERO,t.center),t.radius=r.maximumRadius,t};var q=new e;c.fromBoundingSpheres=function(r,t){if(n(t)||(t=new c),!n(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;var i=r.length;if(1===i)return c.clone(r[0],t);if(2===i)return c.union(r[0],r[1],t);for(var o=[],a=0;i>a;a++)o.push(r[a].center);t=c.fromPoints(o,t);var s=t.center,u=t.radius;for(a=0;i>a;a++){var f=r[a];u=Math.max(u,e.distance(s,f.center,q)+f.radius)}return t.radius=u,t},c.clone=function(r,t){return n(r)?n(t)?(t.center=e.clone(r.center,t.center),t.radius=r.radius,t):new c(r.center,r.radius):void 0},c.packedLength=4,c.pack=function(e,r,i){if(!n(e))throw new o("value is required");if(!n(r))throw new o("array is required");i=t(i,0);var a=e.center;r[i++]=a.x,r[i++]=a.y,r[i++]=a.z,r[i]=e.radius},c.unpack=function(e,r,i){if(!n(e))throw new o("array is required");r=t(r,0),n(i)||(i=new c);var a=i.center;return a.x=e[r++],a.y=e[r++],a.z=e[r++],i.radius=e[r],i};var L=new e,D=new e;c.union=function(r,t,i){if(!n(r))throw new o("left is required.");if(!n(t))throw new o("right is required.");n(i)||(i=new c);var a=r.center,s=r.radius,u=t.center,f=t.radius,l=e.subtract(u,a,L),E=e.magnitude(l);if(s>=E+f)return r.clone(i),i;if(f>=E+s)return t.clone(i),i;var h=.5*(s+E+f),d=e.multiplyByScalar(l,(-s+h)/E,D);return e.add(d,a,d),e.clone(d,i.center),i.radius=h,i};var P=new e;c.expand=function(r,t,i){if(!n(r))throw new o("sphere is required.");if(!n(t))throw new o("point is required.");i=c.clone(r,i);var a=e.magnitude(e.subtract(t,i.center,P));return a>i.radius&&(i.radius=a),i},c.intersectPlane=function(r,t){if(!n(r))throw new o("sphere is required.");if(!n(t))throw new o("plane is required.");var i=r.center,a=r.radius,s=t.normal,f=e.dot(s,i)+t.distance;return-a>f?u.OUTSIDE:a>f?u.INTERSECTING:u.INSIDE},c.transform=function(e,r,t){if(!n(e))throw new o("sphere is required.");if(!n(r))throw new o("transform is required.");return n(t)||(t=new c),t.center=l.multiplyByPoint(r,e.center,t.center),t.radius=l.getMaximumScale(r)*e.radius,t};var U=new e;c.distanceSquaredTo=function(r,t){if(!n(r))throw new o("sphere is required.");if(!n(t))throw new o("cartesian is required.");var i=e.subtract(r.center,t,U);return e.magnitudeSquared(i)-r.radius*r.radius},c.transformWithoutScale=function(e,r,t){if(!n(e))throw new o("sphere is required.");if(!n(r))throw new o("transform is required.");return n(t)||(t=new c),t.center=l.multiplyByPoint(r,e.center,t.center),t.radius=e.radius,t};var B=new e;c.computePlaneDistances=function(r,t,i,a){if(!n(r))throw new o("sphere is required.");if(!n(t))throw new o("position is required.");if(!n(i))throw new o("direction is required.");n(a)||(a=new f);var s=e.subtract(r.center,t,B),u=e.dot(i,s);return a.start=u-r.radius,a.stop=u+r.radius,a};for(var b=new e,x=new e,G=new e,z=new e,H=new e,V=new r,W=new Array(8),X=0;8>X;++X)W[X]=new e;var Y=new s;return c.projectTo2D=function(r,i,a){if(!n(r))throw new o("sphere is required.");i=t(i,Y);var s=i.ellipsoid,u=r.center,f=r.radius,l=s.geodeticSurfaceNormal(u,b),E=e.cross(e.UNIT_Z,l,x);e.normalize(E,E);var h=e.cross(l,E,G);e.normalize(h,h),e.multiplyByScalar(l,f,l),e.multiplyByScalar(h,f,h),e.multiplyByScalar(E,f,E);var d=e.negate(h,H),w=e.negate(E,z),_=W,R=_[0];e.add(l,h,R),e.add(R,E,R),R=_[1],e.add(l,h,R),e.add(R,w,R),R=_[2],e.add(l,d,R),e.add(R,w,R),R=_[3],e.add(l,d,R),e.add(R,E,R),e.negate(l,l),R=_[4],e.add(l,h,R),e.add(R,E,R),R=_[5],e.add(l,h,R),e.add(R,w,R),R=_[6],e.add(l,d,R),e.add(R,w,R),R=_[7],e.add(l,d,R),e.add(R,E,R);for(var m=_.length,T=0;m>T;++T){var A=_[T];e.add(u,A,A);var S=s.cartesianToCartographic(A,V);i.project(S,A)}a=c.fromPoints(_,a),u=a.center;var p=u.x,C=u.y,N=u.z;return u.x=N,u.y=p,u.z=C,a},c.isOccluded=function(e,r){if(!n(e))throw new o("sphere is required.");if(!n(r))throw new o("occluder is required.");return!r.isBoundingSphereVisible(e)},c.equals=function(r,t){return r===t||n(r)&&n(t)&&e.equals(r.center,t.center)&&r.radius===t.radius},c.prototype.intersectPlane=function(e){return c.intersectPlane(this,e)},c.prototype.distanceSquaredTo=function(e){return c.distanceSquaredTo(this,e)},c.prototype.computePlaneDistances=function(e,r,t){return c.computePlaneDistances(this,e,r,t)},c.prototype.isOccluded=function(e){return c.isOccluded(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.prototype.clone=function(e){return c.clone(this,e)},c}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,r){"use strict";var t,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return r(i,{element:{get:function(){return i.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(t))return t;t=!1;var r=document.body;if("function"==typeof r.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",t=!0;for(var i,o=["webkit","moz","o","ms","khtml"],a=0,s=o.length;s>a;++a){var u=o[a];i=u+"RequestFullscreen","function"==typeof r[i]?(n.requestFullscreen=i,t=!0):(i=u+"RequestFullScreen","function"==typeof r[i]&&(n.requestFullscreen=i,t=!0)),i=u+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=u+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=u+"FullscreenEnabled",e(document[i])?n.fullscreenEnabled=i:(i=u+"FullScreenEnabled",e(document[i])&&(n.fullscreenEnabled=i)),i=u+"FullscreenElement",e(document[i])?n.fullscreenElement=i:(i=u+"FullScreenElement",e(document[i])&&(n.fullscreenElement=i)),i=u+"fullscreenchange",e(document["on"+i])&&("ms"===u&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=u+"fullscreenerror",e(document["on"+i])&&("ms"===u&&(i="MSFullscreenError"),n.fullscreenerror=i)}return t},i.requestFullscreen=function(e){i.supportsFullscreen()&&e[n.requestFullscreen]()},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,r,t){"use strict";function n(e){for(var r=e.split("."),t=0,n=r.length;n>t;++t)r[t]=parseInt(r[t],10);return r}function i(){if(!r(_)){_=!1;var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(_=!0,R=n(e[1]))}return _}function o(){return i()&&R}function a(){if(!r(m)&&(m=!1,!i()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(m=!0,T=n(e[1]))}return m}function s(){return a()&&T}function u(){if(!r(A)){A=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==e&&(A=!0,S=n(e[1]),S.isNightly=!!e[2])}return A}function f(){return u()&&S}function l(){if(!r(p)){p=!1;var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(p=!0,C=n(e[1]))):"Netscape"===navigator.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(p=!0,C=n(e[1])))}return p}function E(){return l()&&C}function h(){if(!r(N)){N=!1;var e=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(N=!0,I=n(e[1]))}return N}function c(){return r(g)||(g=/Windows/i.test(navigator.appVersion)),g}function d(){return h()&&I}function w(){return r(M)||(M=r(window.PointerEvent)&&(!r(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),M}var _,R,m,T,A,S,p,C,N,I,g,M,O={isChrome:i,chromeVersion:o,isSafari:a,safariVersion:s,isWebkit:u,webkitVersion:f,isInternetExplorer:l,internetExplorerVersion:E,isFirefox:h,firefoxVersion:d,isWindows:c,hardwareConcurrency:e(navigator.hardwareConcurrency,3),supportsPointerEvents:w};return O.supportsFullscreen=function(){return t.supportsFullscreen()},O.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},O.supportsWebWorkers=function(){return"undefined"!=typeof Worker},O}),define("Core/Color",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math"],function(e,r,t,n,i,o){"use strict";function a(e,r,t){return 0>t&&(t+=1),t>1&&(t-=1),1>6*t?e+6*(r-e)*t:1>2*t?r:2>3*t?e+(r-e)*(2/3-t)*6:e}var s=function(r,t,n,i){this.red=e(r,1),this.green=e(t,1),this.blue=e(n,1),this.alpha=e(i,1)};s.fromCartesian4=function(e,n){if(!r(e))throw new t("cartesian is required");return r(n)?(n.red=e.x,n.green=e.y,n.blue=e.z,n.alpha=e.w,n):new s(e.x,e.y,e.z,e.w)},s.fromBytes=function(t,n,i,o,a){return t=s.byteToFloat(e(t,255)),n=s.byteToFloat(e(n,255)),i=s.byteToFloat(e(i,255)),o=s.byteToFloat(e(o,255)),r(a)?(a.red=t,a.green=n,a.blue=i,a.alpha=o,a):new s(t,n,i,o)},s.fromAlpha=function(e,n,i){if(!r(e))throw new t("color is required");if(!r(n))throw new t("alpha is required");return r(i)?(i.red=e.red,i.green=e.green,i.blue=e.blue,i.alpha=n,i):new s(e.red,e.green,e.blue,n)};var u,f,l;n.supportsTypedArrays()&&(u=new ArrayBuffer(4),f=new Uint32Array(u),l=new Uint8Array(u)),s.fromRgba=function(e){return f[0]=e,s.fromBytes(l[0],l[1],l[2],l[3])},s.fromHsl=function(r,t,n,i){r=e(r,0)%1,t=e(t,0),n=e(n,0),i=e(i,1);var o=n,u=n,f=n;if(0!==t){var l;l=.5>n?n*(1+t):n+t-n*t;var E=2*n-l;o=a(E,l,r+1/3),u=a(E,l,r),f=a(E,l,r-1/3)}return new s(o,u,f,i)},s.fromRandom=function(n,i){n=e(n,e.EMPTY_OBJECT);var a=n.red;if(!r(a)){var u=e(n.minimumRed,0),f=e(n.maximumRed,1);if(u>f)throw new t("minimumRed must be less than or equal to maximumRed");a=u+o.nextRandomNumber()*(f-u)}var l=n.green;if(!r(l)){var E=e(n.minimumGreen,0),h=e(n.maximumGreen,1);if(E>h)throw new t("minimumGreen must be less than or equal to maximumGreen");l=E+o.nextRandomNumber()*(h-E)}var c=n.blue;if(!r(c)){var d=e(n.minimumBlue,0),w=e(n.maximumBlue,1);if(d>w)throw new t("minimumBlue must be less than or equal to maximumBlue");c=d+o.nextRandomNumber()*(w-d)}var _=n.alpha;if(!r(_)){var R=e(n.minimumAlpha,0),m=e(n.maximumAlpha,1);if(R>m)throw new t("minimumAlpha must be less than or equal to maximumAlpha");_=R+o.nextRandomNumber()*(m-R)}return r(i)?(i.red=a,i.green=l,i.blue=c,i.alpha=_,i):new s(a,l,c,_)};var E=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,h=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,c=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,d=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return s.fromCssColorString=function(n){if(!r(n))throw new t("color is required");var i=s[n.toUpperCase()];if(r(i))return s.clone(i);var o=E.exec(n);return null!==o?new s(parseInt(o[1],16)/15,parseInt(o[2],16)/15,parseInt(o[3],16)/15):(o=h.exec(n),null!==o?new s(parseInt(o[1],16)/255,parseInt(o[2],16)/255,parseInt(o[3],16)/255):(o=c.exec(n),null!==o?new s(parseFloat(o[1])/("%"===o[1].substr(-1)?100:255),parseFloat(o[2])/("%"===o[2].substr(-1)?100:255),parseFloat(o[3])/("%"===o[3].substr(-1)?100:255),parseFloat(e(o[4],"1.0"))):(o=d.exec(n),null!==o?s.fromHsl(parseFloat(o[1])/360,parseFloat(o[2])/100,parseFloat(o[3])/100,parseFloat(e(o[4],"1.0"))):void 0)))},s.packedLength=4,s.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.red,i[o++]=n.green,i[o++]=n.blue,i[o]=n.alpha},s.unpack=function(n,i,o){if(!r(n))throw new t("array is required");return i=e(i,0),r(o)||(o=new s),o.red=n[i++],o.green=n[i++],o.blue=n[i++],o.alpha=n[i],o},s.byteToFloat=function(e){return e/255},s.floatToByte=function(e){return 1===e?255:256*e|0},s.clone=function(e,t){return r(e)?r(t)?(t.red=e.red,t.green=e.green,t.blue=e.blue,t.alpha=e.alpha,t):new s(e.red,e.green,e.blue,e.alpha):void 0},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.red===t.red&&e.green===t.green&&e.blue===t.blue&&e.alpha===t.alpha},s.equalsArray=function(e,r,t){return e.red===r[t]&&e.green===r[t+1]&&e.blue===r[t+2]&&e.alpha===r[t+3]},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return this===e||r(e)&&Math.abs(this.red-e.red)<=t&&Math.abs(this.green-e.green)<=t&&Math.abs(this.blue-e.blue)<=t&&Math.abs(this.alpha-e.alpha)<=t},s.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},s.prototype.toCssColorString=function(){var e=s.floatToByte(this.red),r=s.floatToByte(this.green),t=s.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+r+","+t+")":"rgba("+e+","+r+","+t+","+this.alpha+")"},s.prototype.toBytes=function(e){var t=s.floatToByte(this.red),n=s.floatToByte(this.green),i=s.floatToByte(this.blue),o=s.floatToByte(this.alpha);return r(e)?(e[0]=t,e[1]=n,e[2]=i,e[3]=o,e):[t,n,i,o]},s.prototype.toRgba=function(){return l[0]=s.floatToByte(this.red),l[1]=s.floatToByte(this.green),l[2]=s.floatToByte(this.blue),l[3]=s.floatToByte(this.alpha),f[0]},s.prototype.brighten=function(e,n){if(!r(e))throw new t("magnitude is required.");if(0>e)throw new t("magnitude must be positive.");if(!r(n))throw new t("result is required.");return e=1-e,n.red=1-(1-this.red)*e,n.green=1-(1-this.green)*e,n.blue=1-(1-this.blue)*e,n.alpha=this.alpha,n},s.prototype.darken=function(e,n){if(!r(e))throw new t("magnitude is required.");if(0>e)throw new t("magnitude must be positive.");if(!r(n))throw new t("result is required.");return e=1-e,n.red=this.red*e,n.green=this.green*e,n.blue=this.blue*e,n.alpha=this.alpha,n},s.prototype.withAlpha=function(e,r){return s.fromAlpha(this,e,r)},s.ALICEBLUE=i(s.fromCssColorString("#F0F8FF")),s.ANTIQUEWHITE=i(s.fromCssColorString("#FAEBD7")),s.AQUA=i(s.fromCssColorString("#00FFFF")),s.AQUAMARINE=i(s.fromCssColorString("#7FFFD4")),s.AZURE=i(s.fromCssColorString("#F0FFFF")),s.BEIGE=i(s.fromCssColorString("#F5F5DC")),s.BISQUE=i(s.fromCssColorString("#FFE4C4")),s.BLACK=i(s.fromCssColorString("#000000")),s.BLANCHEDALMOND=i(s.fromCssColorString("#FFEBCD")),s.BLUE=i(s.fromCssColorString("#0000FF")),s.BLUEVIOLET=i(s.fromCssColorString("#8A2BE2")),s.BROWN=i(s.fromCssColorString("#A52A2A")),s.BURLYWOOD=i(s.fromCssColorString("#DEB887")),s.CADETBLUE=i(s.fromCssColorString("#5F9EA0")),s.CHARTREUSE=i(s.fromCssColorString("#7FFF00")),s.CHOCOLATE=i(s.fromCssColorString("#D2691E")),s.CORAL=i(s.fromCssColorString("#FF7F50")),s.CORNFLOWERBLUE=i(s.fromCssColorString("#6495ED")),s.CORNSILK=i(s.fromCssColorString("#FFF8DC")),s.CRIMSON=i(s.fromCssColorString("#DC143C")),s.CYAN=i(s.fromCssColorString("#00FFFF")),s.DARKBLUE=i(s.fromCssColorString("#00008B")),s.DARKCYAN=i(s.fromCssColorString("#008B8B")),s.DARKGOLDENROD=i(s.fromCssColorString("#B8860B")),s.DARKGRAY=i(s.fromCssColorString("#A9A9A9")),s.DARKGREEN=i(s.fromCssColorString("#006400")),s.DARKGREY=s.DARKGRAY,s.DARKKHAKI=i(s.fromCssColorString("#BDB76B")),s.DARKMAGENTA=i(s.fromCssColorString("#8B008B")),s.DARKOLIVEGREEN=i(s.fromCssColorString("#556B2F")),s.DARKORANGE=i(s.fromCssColorString("#FF8C00")),s.DARKORCHID=i(s.fromCssColorString("#9932CC")),s.DARKRED=i(s.fromCssColorString("#8B0000")),s.DARKSALMON=i(s.fromCssColorString("#E9967A")),s.DARKSEAGREEN=i(s.fromCssColorString("#8FBC8F")),s.DARKSLATEBLUE=i(s.fromCssColorString("#483D8B")),s.DARKSLATEGRAY=i(s.fromCssColorString("#2F4F4F")),s.DARKSLATEGREY=s.DARKSLATEGRAY,s.DARKTURQUOISE=i(s.fromCssColorString("#00CED1")),s.DARKVIOLET=i(s.fromCssColorString("#9400D3")),s.DEEPPINK=i(s.fromCssColorString("#FF1493")),s.DEEPSKYBLUE=i(s.fromCssColorString("#00BFFF")),s.DIMGRAY=i(s.fromCssColorString("#696969")),s.DIMGREY=s.DIMGRAY,s.DODGERBLUE=i(s.fromCssColorString("#1E90FF")),s.FIREBRICK=i(s.fromCssColorString("#B22222")),s.FLORALWHITE=i(s.fromCssColorString("#FFFAF0")),s.FORESTGREEN=i(s.fromCssColorString("#228B22")),s.FUSCHIA=i(s.fromCssColorString("#FF00FF")),s.GAINSBORO=i(s.fromCssColorString("#DCDCDC")),s.GHOSTWHITE=i(s.fromCssColorString("#F8F8FF")),s.GOLD=i(s.fromCssColorString("#FFD700")),s.GOLDENROD=i(s.fromCssColorString("#DAA520")),s.GRAY=i(s.fromCssColorString("#808080")),s.GREEN=i(s.fromCssColorString("#008000")),s.GREENYELLOW=i(s.fromCssColorString("#ADFF2F")),s.GREY=s.GRAY,s.HONEYDEW=i(s.fromCssColorString("#F0FFF0")),s.HOTPINK=i(s.fromCssColorString("#FF69B4")),s.INDIANRED=i(s.fromCssColorString("#CD5C5C")),s.INDIGO=i(s.fromCssColorString("#4B0082")),s.IVORY=i(s.fromCssColorString("#FFFFF0")),s.KHAKI=i(s.fromCssColorString("#F0E68C")),s.LAVENDER=i(s.fromCssColorString("#E6E6FA")),s.LAVENDAR_BLUSH=i(s.fromCssColorString("#FFF0F5")),s.LAWNGREEN=i(s.fromCssColorString("#7CFC00")),s.LEMONCHIFFON=i(s.fromCssColorString("#FFFACD")),s.LIGHTBLUE=i(s.fromCssColorString("#ADD8E6")),s.LIGHTCORAL=i(s.fromCssColorString("#F08080")),s.LIGHTCYAN=i(s.fromCssColorString("#E0FFFF")),s.LIGHTGOLDENRODYELLOW=i(s.fromCssColorString("#FAFAD2")),s.LIGHTGRAY=i(s.fromCssColorString("#D3D3D3")),s.LIGHTGREEN=i(s.fromCssColorString("#90EE90")),s.LIGHTGREY=s.LIGHTGRAY,s.LIGHTPINK=i(s.fromCssColorString("#FFB6C1")),s.LIGHTSEAGREEN=i(s.fromCssColorString("#20B2AA")),s.LIGHTSKYBLUE=i(s.fromCssColorString("#87CEFA")),s.LIGHTSLATEGRAY=i(s.fromCssColorString("#778899")),s.LIGHTSLATEGREY=s.LIGHTSLATEGRAY,s.LIGHTSTEELBLUE=i(s.fromCssColorString("#B0C4DE")),s.LIGHTYELLOW=i(s.fromCssColorString("#FFFFE0")),s.LIME=i(s.fromCssColorString("#00FF00")),s.LIMEGREEN=i(s.fromCssColorString("#32CD32")),s.LINEN=i(s.fromCssColorString("#FAF0E6")),s.MAGENTA=i(s.fromCssColorString("#FF00FF")),s.MAROON=i(s.fromCssColorString("#800000")),s.MEDIUMAQUAMARINE=i(s.fromCssColorString("#66CDAA")),s.MEDIUMBLUE=i(s.fromCssColorString("#0000CD")),s.MEDIUMORCHID=i(s.fromCssColorString("#BA55D3")),s.MEDIUMPURPLE=i(s.fromCssColorString("#9370DB")),s.MEDIUMSEAGREEN=i(s.fromCssColorString("#3CB371")),s.MEDIUMSLATEBLUE=i(s.fromCssColorString("#7B68EE")),s.MEDIUMSPRINGGREEN=i(s.fromCssColorString("#00FA9A")),s.MEDIUMTURQUOISE=i(s.fromCssColorString("#48D1CC")),s.MEDIUMVIOLETRED=i(s.fromCssColorString("#C71585")),s.MIDNIGHTBLUE=i(s.fromCssColorString("#191970")),s.MINTCREAM=i(s.fromCssColorString("#F5FFFA")),s.MISTYROSE=i(s.fromCssColorString("#FFE4E1")),s.MOCCASIN=i(s.fromCssColorString("#FFE4B5")),s.NAVAJOWHITE=i(s.fromCssColorString("#FFDEAD")),s.NAVY=i(s.fromCssColorString("#000080")),s.OLDLACE=i(s.fromCssColorString("#FDF5E6")),s.OLIVE=i(s.fromCssColorString("#808000")),s.OLIVEDRAB=i(s.fromCssColorString("#6B8E23")),s.ORANGE=i(s.fromCssColorString("#FFA500")),s.ORANGERED=i(s.fromCssColorString("#FF4500")),s.ORCHID=i(s.fromCssColorString("#DA70D6")),s.PALEGOLDENROD=i(s.fromCssColorString("#EEE8AA")),s.PALEGREEN=i(s.fromCssColorString("#98FB98")),s.PALETURQUOISE=i(s.fromCssColorString("#AFEEEE")),s.PALEVIOLETRED=i(s.fromCssColorString("#DB7093")),s.PAPAYAWHIP=i(s.fromCssColorString("#FFEFD5")),s.PEACHPUFF=i(s.fromCssColorString("#FFDAB9")),s.PERU=i(s.fromCssColorString("#CD853F")),s.PINK=i(s.fromCssColorString("#FFC0CB")),s.PLUM=i(s.fromCssColorString("#DDA0DD")),s.POWDERBLUE=i(s.fromCssColorString("#B0E0E6")),s.PURPLE=i(s.fromCssColorString("#800080")),s.RED=i(s.fromCssColorString("#FF0000")),s.ROSYBROWN=i(s.fromCssColorString("#BC8F8F")),s.ROYALBLUE=i(s.fromCssColorString("#4169E1")),s.SADDLEBROWN=i(s.fromCssColorString("#8B4513")),s.SALMON=i(s.fromCssColorString("#FA8072")),s.SANDYBROWN=i(s.fromCssColorString("#F4A460")),s.SEAGREEN=i(s.fromCssColorString("#2E8B57")),s.SEASHELL=i(s.fromCssColorString("#FFF5EE")),s.SIENNA=i(s.fromCssColorString("#A0522D")),s.SILVER=i(s.fromCssColorString("#C0C0C0")),s.SKYBLUE=i(s.fromCssColorString("#87CEEB")),s.SLATEBLUE=i(s.fromCssColorString("#6A5ACD")),s.SLATEGRAY=i(s.fromCssColorString("#708090")),s.SLATEGREY=s.SLATEGRAY,s.SNOW=i(s.fromCssColorString("#FFFAFA")),s.SPRINGGREEN=i(s.fromCssColorString("#00FF7F")),s.STEELBLUE=i(s.fromCssColorString("#4682B4")),s.TAN=i(s.fromCssColorString("#D2B48C")),s.TEAL=i(s.fromCssColorString("#008080")),s.THISTLE=i(s.fromCssColorString("#D8BFD8")),s.TOMATO=i(s.fromCssColorString("#FF6347")),s.TURQUOISE=i(s.fromCssColorString("#40E0D0")),s.VIOLET=i(s.fromCssColorString("#EE82EE")),s.WHEAT=i(s.fromCssColorString("#F5DEB3")),s.WHITE=i(s.fromCssColorString("#FFFFFF")),s.WHITESMOKE=i(s.fromCssColorString("#F5F5F5")),s.YELLOW=i(s.fromCssColorString("#FFFF00")),s.YELLOWGREEN=i(s.fromCssColorString("#9ACD32")),s.TRANSPARENT=i(new s(0,0,0,0)),s}),define("Renderer/WebGLConstants",["../Core/freezeObject"],function(e){"use strict";var r={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,
SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return e(r)}),define("Core/ComponentDatatype",["../Renderer/WebGLConstants","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,r,t,n,i,o){"use strict";if(!i.supportsTypedArrays())return{};var a={BYTE:e.BYTE,UNSIGNED_BYTE:e.UNSIGNED_BYTE,SHORT:e.SHORT,UNSIGNED_SHORT:e.UNSIGNED_SHORT,FLOAT:e.FLOAT,DOUBLE:e.DOUBLE};return a.getSizeInBytes=function(e){if(!t(e))throw new n("value is required.");switch(e){case a.BYTE:return Int8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.SHORT:return Int16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case a.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new n("componentDatatype is not a valid value.")}},a.fromTypedArray=function(e){return e instanceof Int8Array?a.BYTE:e instanceof Uint8Array?a.UNSIGNED_BYTE:e instanceof Int16Array?a.SHORT:e instanceof Uint16Array?a.UNSIGNED_SHORT:e instanceof Float32Array?a.FLOAT:e instanceof Float64Array?a.DOUBLE:void 0},a.validate=function(e){return t(e)&&(e===a.BYTE||e===a.UNSIGNED_BYTE||e===a.SHORT||e===a.UNSIGNED_SHORT||e===a.FLOAT||e===a.DOUBLE)},a.createTypedArray=function(e,r){if(!t(e))throw new n("componentDatatype is required.");if(!t(r))throw new n("valuesOrLength is required.");switch(e){case a.BYTE:return new Int8Array(r);case a.UNSIGNED_BYTE:return new Uint8Array(r);case a.SHORT:return new Int16Array(r);case a.UNSIGNED_SHORT:return new Uint16Array(r);case a.FLOAT:return new Float32Array(r);case a.DOUBLE:return new Float64Array(r);default:throw new n("componentDatatype is not a valid value.")}},a.createArrayBufferView=function(e,i,o,s){if(!t(e))throw new n("componentDatatype is required.");if(!t(i))throw new n("buffer is required.");switch(o=r(o,0),s=r(s,(i.byteLength-o)/a.getSizeInBytes(e)),e){case a.BYTE:return new Int8Array(i,o,s);case a.UNSIGNED_BYTE:return new Uint8Array(i,o,s);case a.SHORT:return new Int16Array(i,o,s);case a.UNSIGNED_SHORT:return new Uint16Array(i,o,s);case a.FLOAT:return new Float32Array(i,o,s);case a.DOUBLE:return new Float64Array(i,o,s);default:throw new n("componentDatatype is not a valid value.")}},o(a)}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var r={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(r)}),define("Core/PrimitiveType",["../Renderer/WebGLConstants","./freezeObject"],function(e,r){"use strict";var t={POINTS:e.POINTS,LINES:e.LINES,LINE_LOOP:e.LINE_LOOP,LINE_STRIP:e.LINE_STRIP,TRIANGLES:e.TRIANGLES,TRIANGLE_STRIP:e.TRIANGLE_STRIP,TRIANGLE_FAN:e.TRIANGLE_FAN,validate:function(e){return e===t.POINTS||e===t.LINES||e===t.LINE_LOOP||e===t.LINE_STRIP||e===t.TRIANGLES||e===t.TRIANGLE_STRIP||e===t.TRIANGLE_FAN}};return r(t)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,r,t,n,i){"use strict";var o=function(o){if(o=e(o,e.EMPTY_OBJECT),!r(o.attributes))throw new t("options.attributes is required.");this.attributes=o.attributes,this.indices=o.indices,this.primitiveType=e(o.primitiveType,i.TRIANGLES),this.boundingSphere=o.boundingSphere,this.geometryType=e(o.geometryType,n.NONE),this.boundingSphereCV=void 0};return o.computeNumberOfVertices=function(e){if(!r(e))throw new t("geometry is required.");var n=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&r(e.attributes[i])&&r(e.attributes[i].values)){var o=e.attributes[i],a=o.values.length/o.componentsPerAttribute;if(n!==a&&-1!==n)throw new t("All attribute lists must have the same number of attributes.");n=a}return n},o}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.componentDatatype))throw new t("options.componentDatatype is required.");if(!r(n.componentsPerAttribute))throw new t("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new t("options.componentsPerAttribute must be between 1 and 4.");if(!r(n.values))throw new t("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values};return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var r=function(r){r=e(r,e.EMPTY_OBJECT),this.position=r.position,this.normal=r.normal,this.st=r.st,this.binormal=r.binormal,this.tangent=r.tangent,this.color=r.color};return r}),define("Core/IndexDatatype",["../Renderer/WebGLConstants","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o={UNSIGNED_BYTE:e.UNSIGNED_BYTE,UNSIGNED_SHORT:e.UNSIGNED_SHORT,UNSIGNED_INT:e.UNSIGNED_INT};return o.getSizeInBytes=function(e){switch(e){case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},o.validate=function(e){return r(e)&&(e===o.UNSIGNED_BYTE||e===o.UNSIGNED_SHORT||e===o.UNSIGNED_INT)},o.createTypedArray=function(e,n){if(!r(e))throw new t("numberOfVertices is required.");return e>=i.SIXTY_FOUR_KILOBYTES?new Uint32Array(n):new Uint16Array(n)},o.createTypedArrayFromArrayBuffer=function(e,n,o,a){if(!r(e))throw new t("numberOfVertices is required.");if(!r(n))throw new t("sourceArray is required.");if(!r(o))throw new t("byteOffset is required.");return e>=i.SIXTY_FOUR_KILOBYTES?new Uint32Array(n,o,a):new Uint16Array(n,o,a)},n(o)}),define("Core/EllipsoidGeodesic",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,r,t,n,i,o,a,s){"use strict";function u(e){var r=e._uSquared,t=e._ellipsoid.maximumRadius,n=e._ellipsoid.minimumRadius,i=(t-n)/t,o=Math.cos(e._startHeading),a=Math.sin(e._startHeading),s=(1-i)*Math.tan(e._start.latitude),u=1/Math.sqrt(1+s*s),f=u*s,l=Math.atan2(s,o),E=u*a,h=E*E,c=1-h,d=Math.sqrt(c),w=r/4,_=w*w,R=_*w,m=_*_,T=1+w-3*_/4+5*R/4-175*m/64,A=1-w+15*_/8-35*R/8,S=1-3*w+35*_/4,p=1-5*w,C=T*l-A*Math.sin(2*l)*w/2-S*Math.sin(4*l)*_/16-p*Math.sin(6*l)*R/48-5*Math.sin(8*l)*m/512,N=e._constants;N.a=t,N.b=n,N.f=i,N.cosineHeading=o,N.sineHeading=a,N.tanU=s,N.cosineU=u,N.sineU=f,N.sigma=l,N.sineAlpha=E,N.sineSquaredAlpha=h,N.cosineSquaredAlpha=c,N.cosineAlpha=d,N.u2Over4=w,N.u4Over16=_,N.u6Over64=R,N.u8Over256=m,N.a0=T,N.a1=A,N.a2=S,N.a3=p,N.distanceRatio=C}function f(e,r){return e*r*(4+e*(4-3*r))/16}function l(e,r,t,n,i,o,a){var s=f(e,t);return(1-s)*e*r*(n+s*i*(a+s*o*(2*a*a-1)))}function E(e,r,t,n,i,o,a){var u,f,E,h,c,d=(r-t)/r,w=o-n,_=Math.atan((1-d)*Math.tan(i)),R=Math.atan((1-d)*Math.tan(a)),m=Math.cos(_),T=Math.sin(_),A=Math.cos(R),S=Math.sin(R),p=m*A,C=m*S,N=T*S,I=T*A,g=w,M=s.TWO_PI,O=Math.cos(g),y=Math.sin(g);do{O=Math.cos(g),y=Math.sin(g);var v=C-I*O;E=Math.sqrt(A*A*y*y+v*v),f=N+p*O,u=Math.atan2(E,f);var F;0===E?(F=0,h=1):(F=p*y/E,h=1-F*F),M=g,c=f-2*N/h,isNaN(c)&&(c=0),g=w+l(d,F,h,u,E,f,c)}while(Math.abs(g-M)>s.EPSILON12);var q=h*(r*r-t*t)/(t*t),L=1+q*(4096+q*(q*(320-175*q)-768))/16384,D=q*(256+q*(q*(74-47*q)-128))/1024,P=c*c,U=D*E*(c+D*(f*(2*P-1)-D*c*(4*E*E-3)*(4*P-3)/6)/4),B=t*L*(u-U),b=Math.atan2(A*y,C-I*O),x=Math.atan2(m*y,C*O-I);e._distance=B,e._startHeading=b,e._endHeading=x,e._uSquared=q}function h(t,n,i,a){var s=e.normalize(a.cartographicToCartesian(n,d),c),f=e.normalize(a.cartographicToCartesian(i,d),d);if(Math.abs(Math.abs(e.angleBetween(s,f))-Math.PI)<.0125)throw new o("geodesic position is not unique");E(t,a.maximumRadius,a.minimumRadius,n.longitude,n.latitude,i.longitude,i.latitude),t._start=r.clone(n,t._start),t._end=r.clone(i,t._end),t._start.height=0,t._end.height=0,u(t)}var c=new e,d=new e,w=function(e,i,o){var s=t(o,a.WGS84);this._ellipsoid=s,this._start=new r,this._end=new r,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,n(e)&&n(i)&&h(this,e,i,s)};return i(w.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){if(!n(this._distance))throw new o("set end positions before getting surfaceDistance");return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){if(!n(this._distance))throw new o("set end positions before getting startHeading");return this._startHeading}},endHeading:{get:function(){if(!n(this._distance))throw new o("set end positions before getting endHeading");return this._endHeading}}}),w.prototype.setEndPoints=function(e,r){if(!n(e))throw new o("start cartographic position is required");if(!n(r))throw new o("end cartgraphic position is required");h(this,e,r,this._ellipsoid)},w.prototype.interpolateUsingFraction=function(e,r){return this.interpolateUsingSurfaceDistance(this._distance*e,r)},w.prototype.interpolateUsingSurfaceDistance=function(e,t){if(!n(this._distance))throw new o("start and end must be set before calling funciton interpolateUsingSurfaceDistance");var i=this._constants,a=i.distanceRatio+e/i.b,s=Math.cos(2*a),u=Math.cos(4*a),f=Math.cos(6*a),E=Math.sin(2*a),h=Math.sin(4*a),c=Math.sin(6*a),d=Math.sin(8*a),w=a*a,_=a*w,R=i.u8Over256,m=i.u2Over4,T=i.u6Over64,A=i.u4Over16,S=2*_*R*s/3+a*(1-m+7*A/4-15*T/4+579*R/64-(A-15*T/4+187*R/16)*s-(5*T/4-115*R/16)*u-29*R*f/16)+(m/2-A+71*T/32-85*R/16)*E+(5*A/16-5*T/4+383*R/96)*h-w*((T-11*R/2)*E+5*R*h/2)+(29*T/96-29*R/16)*c+539*R*d/1536,p=Math.asin(Math.sin(S)*i.cosineAlpha),C=Math.atan(i.a/i.b*Math.tan(p));S-=i.sigma;var N=Math.cos(2*i.sigma+S),I=Math.sin(S),g=Math.cos(S),M=i.cosineU*g,O=i.sineU*I,y=Math.atan2(I*i.sineHeading,M-O*i.cosineHeading),v=y-l(i.f,i.sineAlpha,i.cosineSquaredAlpha,S,I,g,N);return n(t)?(t.longitude=this._start.longitude+v,t.latitude=C,t.height=0,t):new r(this._start.longitude+v,C,0)},w}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,r){"use strict";function t(e,t,n){var i=e+t;return r.sign(e)!==r.sign(t)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(t)))<n?0:i}var n={};return n.computeDiscriminant=function(r,t,n){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");var i=t*t-4*r*n;return i},n.computeRealRoots=function(n,i,o){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");var a;if(0===n)return 0===i?[]:[-o/i];if(0===i){if(0===o)return[0,0];var s=Math.abs(o),u=Math.abs(n);if(u>s&&s/u<r.EPSILON14)return[0,0];if(s>u&&u/s<r.EPSILON14)return[];if(a=-o/n,0>a)return[];var f=Math.sqrt(a);return[-f,f]}if(0===o)return a=-i/n,0>a?[a,0]:[0,a];var l=i*i,E=4*n*o,h=t(l,-E,r.EPSILON14);if(0>h)return[];var c=-.5*t(i,r.sign(i)*Math.sqrt(h),r.EPSILON14);return i>0?[c/n,o/c]:[o/c,c/n]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,r){"use strict";function t(e,r,t,n){var i,o,a=e,s=r/3,u=t/3,f=n,l=a*u,E=s*f,h=s*s,c=u*u,d=a*u-h,w=a*f-s*u,_=s*f-c,R=4*d*_-w*w;if(0>R){var m,T,A;h*E>=l*c?(m=a,T=d,A=-2*s*d+a*w):(m=f,T=_,A=-f*w+2*u*_);var S=0>A?-1:1,p=-S*Math.abs(m)*Math.sqrt(-R);o=-A+p;var C=o/2,N=0>C?-Math.pow(-C,1/3):Math.pow(C,1/3),I=o===p?-N:-T/N;return i=0>=T?N+I:-A/(N*N+I*I+T),h*E>=l*c?[(i-s)/a]:[-f/(i+u)]}var g=d,M=-2*s*d+a*w,O=_,y=-f*w+2*u*_,v=Math.sqrt(R),F=Math.sqrt(3)/2,q=Math.abs(Math.atan2(a*v,-M)/3);i=2*Math.sqrt(-g);var L=Math.cos(q);o=i*L;var D=i*(-L/2-F*Math.sin(q)),P=o+D>2*s?o-s:D-s,U=a,B=P/U;q=Math.abs(Math.atan2(f*v,-y)/3),i=2*Math.sqrt(-O),L=Math.cos(q),o=i*L,D=i*(-L/2-F*Math.sin(q));var b=-f,x=2*u>o+D?o+u:D+u,G=b/x,z=U*x,H=-P*x-U*b,V=P*b,W=(u*H-s*V)/(-s*H+u*z);return W>=B?G>=B?G>=W?[B,W,G]:[B,G,W]:[G,B,W]:G>=B?[W,B,G]:G>=W?[W,G,B]:[G,W,B]}var n={};return n.computeDiscriminant=function(r,t,n,i){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var o=r*r,a=t*t,s=n*n,u=i*i,f=18*r*t*n*i+a*s-27*o*u-4*(r*s*n+a*t*i);return f},n.computeRealRoots=function(n,i,o,a){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");if("number"!=typeof a)throw new e("d is a required number.");var s,u;if(0===n)return r.computeRealRoots(i,o,a);if(0===i){if(0===o){if(0===a)return[0,0,0];u=-a/n;var f=0>u?-Math.pow(-u,1/3):Math.pow(u,1/3);return[f,f,f]}return 0===a?(s=r.computeRealRoots(n,0,o),0===s.Length?[0]:[s[0],0,s[1]]):t(n,0,o,a)}return 0===o?0===a?(u=-i/n,0>u?[u,0,0]:[0,0,u]):t(n,i,0,a):0===a?(s=r.computeRealRoots(n,i,o),0===s.length?[0]:s[1]<=0?[s[0],s[1],0]:s[0]>=0?[0,s[0],s[1]]:[s[0],0,s[1]]):t(n,i,o,a)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,r,t,n){"use strict";function i(r,i,o,a){var s=r*r,u=i-3*s/8,f=o-i*r/2+s*r/8,l=a-o*r/4+i*s/16-3*s*s/256,E=e.computeRealRoots(1,2*u,u*u-4*l,-f*f);if(E.length>0){var h=-r/4,c=E[E.length-1];if(Math.abs(c)<t.EPSILON14){var d=n.computeRealRoots(1,u,l);if(2===d.length){var w,_=d[0],R=d[1];if(_>=0&&R>=0){var m=Math.sqrt(_),T=Math.sqrt(R);return[h-T,h-m,h+m,h+T]}if(_>=0&&0>R)return w=Math.sqrt(_),[h-w,h+w];if(0>_&&R>=0)return w=Math.sqrt(R),[h-w,h+w]}return[]}if(c>0){var A=Math.sqrt(c),S=(u+c-f/A)/2,p=(u+c+f/A)/2,C=n.computeRealRoots(1,A,S),N=n.computeRealRoots(1,-A,p);return 0!==C.length?(C[0]+=h,C[1]+=h,0!==N.length?(N[0]+=h,N[1]+=h,C[1]<=N[0]?[C[0],C[1],N[0],N[1]]:N[1]<=C[0]?[N[0],N[1],C[0],C[1]]:C[0]>=N[0]&&C[1]<=N[1]?[N[0],C[0],C[1],N[1]]:N[0]>=C[0]&&N[1]<=C[1]?[C[0],N[0],N[1],C[1]]:C[0]>N[0]&&C[0]<N[1]?[N[0],C[0],N[1],C[1]]:[C[0],N[0],C[1],N[1]]):C):0!==N.length?(N[0]+=h,N[1]+=h,N):[]}}return[]}function o(r,i,o,a){var s=o*o,u=i*i,f=r*r,l=-2*i,E=o*r+u-4*a,h=f*a-o*i*r+s,c=e.computeRealRoots(1,l,E,h);if(c.length>0){var d,w,_=c[0],R=i-_,m=R*R,T=r/2,A=R/2,S=m-4*a,p=m+4*Math.abs(a),C=f-4*_,N=f+4*Math.abs(_);if(0>_||C*p>S*N){var I=Math.sqrt(C);d=I/2,w=0===I?0:(r*A-o)/I}else{var g=Math.sqrt(S);d=0===g?0:(r*A-o)/g,w=g/2}var M,O;0===T&&0===d?(M=0,O=0):t.sign(T)===t.sign(d)?(M=T+d,O=_/M):(O=T-d,M=_/O);var y,v;0===A&&0===w?(y=0,v=0):t.sign(A)===t.sign(w)?(y=A+w,v=a/y):(v=A-w,y=a/v);var F=n.computeRealRoots(1,M,y),q=n.computeRealRoots(1,O,v);if(0!==F.length)return 0!==q.length?F[1]<=q[0]?[F[0],F[1],q[0],q[1]]:q[1]<=F[0]?[q[0],q[1],F[0],F[1]]:F[0]>=q[0]&&F[1]<=q[1]?[q[0],F[0],F[1],q[1]]:q[0]>=F[0]&&q[1]<=F[1]?[F[0],q[0],q[1],F[1]]:F[0]>q[0]&&F[0]<q[1]?[q[0],F[0],q[1],F[1]]:[F[0],q[0],F[1],q[1]]:F;if(0!==q.length)return q}return[]}var a={};return a.computeDiscriminant=function(e,t,n,i,o){if("number"!=typeof e)throw new r("a is a required number.");if("number"!=typeof t)throw new r("b is a required number.");if("number"!=typeof n)throw new r("c is a required number.");if("number"!=typeof i)throw new r("d is a required number.");if("number"!=typeof o)throw new r("e is a required number.");var a=e*e,s=a*e,u=t*t,f=u*t,l=n*n,E=l*n,h=i*i,c=h*i,d=o*o,w=d*o,_=u*l*h-4*f*c-4*e*E*h+18*e*t*n*c-27*a*h*h+256*s*w+o*(18*f*n*i-4*u*E+16*e*l*l-80*e*t*l*i-6*e*u*h+144*a*n*h)+d*(144*e*u*n-27*u*u-128*a*l-192*a*t*i);return _},a.computeRealRoots=function(n,a,s,u,f){if("number"!=typeof n)throw new r("a is a required number.");if("number"!=typeof a)throw new r("b is a required number.");if("number"!=typeof s)throw new r("c is a required number.");if("number"!=typeof u)throw new r("d is a required number.");if("number"!=typeof f)throw new r("e is a required number.");if(Math.abs(n)<t.EPSILON15)return e.computeRealRoots(a,s,u,f);var l=a/n,E=s/n,h=u/n,c=f/n,d=0>l?1:0;switch(d+=0>E?d+1:d,d+=0>h?d+1:d,d+=0>c?d+1:d){case 0:return i(l,E,h,c);case 1:return o(l,E,h,c);case 2:return o(l,E,h,c);case 3:return i(l,E,h,c);case 4:return i(l,E,h,c);case 5:return o(l,E,h,c);case 6:return i(l,E,h,c);case 7:return i(l,E,h,c);case 8:return o(l,E,h,c);case 9:return i(l,E,h,c);case 10:return i(l,E,h,c);case 11:return o(l,E,h,c);case 12:return i(l,E,h,c);case 13:return i(l,E,h,c);case 14:return i(l,E,h,c);case 15:return i(l,E,h,c);default:return void 0}},a}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i=function(t,n){n=e.clone(r(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(r(t,e.ZERO)),this.direction=n};return i.getPoint=function(r,i,o){if(!t(r))throw new n("ray is requred");if("number"!=typeof i)throw new n("t is a required number");return t(o)||(o=new e),o=e.multiplyByScalar(r.direction,i,o),e.add(r.origin,o,o)},i}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,r,t,n,i,o,a,s,u,f){"use strict";function l(r,a,s,u,f){if(!n(r))throw new i("ray is required.");if(!n(a))throw new i("p0 is required.");if(!n(s))throw new i("p1 is required.");if(!n(u))throw new i("p2 is required.");f=t(f,!1);var l,E,h,c,d,w=r.origin,S=r.direction,p=e.subtract(s,a,_),C=e.subtract(u,a,R),N=e.cross(S,C,m),I=e.dot(p,N);if(f){if(I<o.EPSILON6)return void 0;if(l=e.subtract(w,a,T),h=e.dot(l,N),0>h||h>I)return void 0;if(E=e.cross(l,p,A),c=e.dot(S,E),0>c||h+c>I)return void 0;d=e.dot(C,E)/I}else{if(Math.abs(I)<o.EPSILON6)return void 0;var g=1/I;if(l=e.subtract(w,a,T),h=e.dot(l,N)*g,0>h||h>1)return void 0;if(E=e.cross(l,p,A),c=e.dot(S,E)*g,0>c||h+c>1)return void 0;d=e.dot(C,E)*g}return d}function E(e,r,t,n){var i=r*r-4*e*t;if(0>i)return void 0;if(i>0){var o=1/(2*e),a=Math.sqrt(i),s=(-r+a)*o,u=(-r-a)*o;return u>s?(n.root0=s,n.root1=u):(n.root0=u,n.root1=s),n}var f=-r/(2*e);return 0===f?void 0:(n.root0=n.root1=f,n)}function h(r,t,i){n(i)||(i={});var o=r.origin,a=r.direction,s=t.center,u=t.radius*t.radius,f=e.subtract(o,s,m),l=e.dot(a,a),h=2*e.dot(a,f),c=e.magnitudeSquared(f)-u,d=E(l,h,c,p);return n(d)?(i.start=d.root0,i.stop=d.root1,i):void 0}function c(e,r,t){var n=e+r;return o.sign(e)!==o.sign(r)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(r)))<t?0:n}function d(r,t,n,i,f){var l,E=i*i,h=f*f,d=(r[a.COLUMN1ROW1]-r[a.COLUMN2ROW2])*h,w=f*(i*c(r[a.COLUMN1ROW0],r[a.COLUMN0ROW1],o.EPSILON15)+t.y),_=r[a.COLUMN0ROW0]*E+r[a.COLUMN2ROW2]*h+i*t.x+n,R=h*c(r[a.COLUMN2ROW1],r[a.COLUMN1ROW2],o.EPSILON15),m=f*(i*c(r[a.COLUMN2ROW0],r[a.COLUMN0ROW2])+t.z),T=[];if(0===m&&0===R){if(l=s.computeRealRoots(d,w,_),0===l.length)return T;var A=l[0],S=Math.sqrt(Math.max(1-A*A,0));if(T.push(new e(i,f*A,f*-S)),T.push(new e(i,f*A,f*S)),2===l.length){var p=l[1],C=Math.sqrt(Math.max(1-p*p,0));T.push(new e(i,f*p,f*-C)),T.push(new e(i,f*p,f*C))}return T}var N=m*m,I=R*R,g=d*d,M=m*R,O=g+I,y=2*(w*d+M),v=2*_*d+w*w-I+N,F=2*(_*w-M),q=_*_-N;if(0===O&&0===y&&0===v&&0===F)return T;l=u.computeRealRoots(O,y,v,F,q);var L=l.length;if(0===L)return T;for(var D=0;L>D;++D){var P,U=l[D],B=U*U,b=Math.max(1-B,0),x=Math.sqrt(b);P=o.sign(d)===o.sign(_)?c(d*B+_,w*U,o.EPSILON12):o.sign(_)===o.sign(w*U)?c(d*B,w*U+_,o.EPSILON12):c(d*B+w*U,_,o.EPSILON12);var G=c(R*U,m,o.EPSILON15),z=P*G;0>z?T.push(new e(i,f*U,f*x)):z>0?T.push(new e(i,f*U,f*-x)):0!==x?(T.push(new e(i,f*U,f*-x)),T.push(new e(i,f*U,f*x)),++D):T.push(new e(i,f*U,f*x))}return T}var w={};w.rayPlane=function(r,t,a){if(!n(r))throw new i("ray is required.");if(!n(t))throw new i("plane is required.");n(a)||(a=new e);var s=r.origin,u=r.direction,f=t.normal,l=e.dot(f,u);if(Math.abs(l)<o.EPSILON15)return void 0;var E=(-t.distance-e.dot(f,s))/l;return 0>E?void 0:(a=e.multiplyByScalar(u,E,a),e.add(s,a,a))};var _=new e,R=new e,m=new e,T=new e,A=new e;w.rayTriangle=function(r,t,i,o,a,s){var u=l(r,t,i,o,a);return!n(u)||0>u?void 0:(n(s)||(s=new e),e.multiplyByScalar(r.direction,u,s),e.add(r.origin,s,s))};var S=new f;w.lineSegmentTriangle=function(r,t,o,a,s,u,f){if(!n(r))throw new i("v0 is required.");if(!n(t))throw new i("v1 is required.");var E=S;e.clone(r,E.origin),e.subtract(t,r,E.direction),e.normalize(E.direction,E.direction);var h=l(E,o,a,s,u);return!n(h)||0>h||h>e.distance(r,t)?void 0:(n(f)||(f=new e),e.multiplyByScalar(E.direction,h,f),e.add(E.origin,f,f))};var p={root0:0,root1:0};w.raySphere=function(e,r,t){if(!n(e))throw new i("ray is required.");if(!n(r))throw new i("sphere is required.");return t=h(e,r,t),!n(t)||t.stop<0?void 0:(t.start=Math.max(t.start,0),t)};var C=new f;w.lineSegmentSphere=function(r,t,o,a){if(!n(r))throw new i("p0 is required.");if(!n(t))throw new i("p1 is required.");if(!n(o))throw new i("sphere is required.");var s=C,u=(e.clone(r,s.origin),e.subtract(t,r,s.direction)),f=e.magnitude(u);return e.normalize(u,u),a=h(s,o,a),!n(a)||a.stop<0||a.start>f?void 0:(a.start=Math.max(a.start,0),a.stop=Math.min(a.stop,f),a)};var N=new e,I=new e;w.rayEllipsoid=function(r,t){if(!n(r))throw new i("ray is required.");if(!n(t))throw new i("ellipsoid is required.");var o,a,s,u,f,l=t.oneOverRadii,E=e.multiplyComponents(l,r.origin,N),h=e.multiplyComponents(l,r.direction,I),c=e.magnitudeSquared(E),d=e.dot(E,h);if(c>1){if(d>=0)return void 0;var w=d*d;if(o=c-1,a=e.magnitudeSquared(h),s=a*o,s>w)return void 0;if(w>s){u=d*d-s,f=-d+Math.sqrt(u);var _=f/a,R=o/f;return R>_?{start:_,stop:R}:{start:R,stop:_}}var m=Math.sqrt(o/a);return{start:m,stop:m}}return 1>c?(o=c-1,a=e.magnitudeSquared(h),s=a*o,u=d*d-s,f=-d+Math.sqrt(u),{start:0,stop:f/a}):0>d?(a=e.magnitudeSquared(h),{start:0,stop:-d/a}):void 0};var g=new e,M=new e,O=new e,y=new e,v=new e,F=new a,q=new a,L=new a,D=new a,P=new a,U=new a,B=new a,b=new e,x=new e,G=new r;w.grazingAltitudeLocation=function(r,t){if(!n(r))throw new i("ray is required.");if(!n(t))throw new i("ellipsoid is required.");var s=r.origin,u=r.direction,f=t.geodeticSurfaceNormal(s,g);if(e.dot(u,f)>=0)return s;var l=n(this.rayEllipsoid(r,t)),E=t.transformPositionToScaledSpace(u,g),h=e.normalize(E,E),c=e.mostOrthogonalAxis(E,y),w=e.normalize(e.cross(c,h,M),M),_=e.normalize(e.cross(h,w,O),O),R=F;R[0]=h.x,R[1]=h.y,R[2]=h.z,R[3]=w.x,R[4]=w.y,R[5]=w.z,R[6]=_.x,R[7]=_.y,R[8]=_.z;var m=a.transpose(R,q),T=a.fromScale(t.radii,L),A=a.fromScale(t.oneOverRadii,D),S=P;S[0]=0,S[1]=-u.z,S[2]=u.y,S[3]=u.z,S[4]=0,S[5]=-u.x,S[6]=-u.y,S[7]=u.x,S[8]=0;var p,C,N=a.multiply(a.multiply(m,A,U),S,U),I=a.multiply(a.multiply(N,T,B),R,B),z=a.multiplyByVector(N,s,v),H=d(I,e.negate(z,g),0,0,1),V=H.length;if(V>0){for(var W=e.clone(e.ZERO,x),X=Number.NEGATIVE_INFINITY,Y=0;V>Y;++Y){p=a.multiplyByVector(T,a.multiplyByVector(R,H[Y],b),b);var K=e.normalize(e.subtract(p,s,y),y),k=e.dot(K,u);k>X&&(X=k,W=e.clone(p,W))}var Z=t.cartesianToCartographic(W,G);return X=o.clamp(X,0,1),C=e.magnitude(e.subtract(W,s,y))*Math.sqrt(1-X*X),C=l?-C:C,Z.height=C,t.cartographicToCartesian(Z,new e)}return void 0};var z=new e;return w.lineSegmentPlane=function(r,t,a,s){if(!n(r))throw new i("endPoint0 is required.");if(!n(t))throw new i("endPoint1 is required.");if(!n(a))throw new i("plane is required.");n(s)||(s=new e);var u=e.subtract(t,r,z),f=a.normal,l=e.dot(f,u);if(Math.abs(l)<o.EPSILON6)return void 0;var E=e.dot(f,r),h=-(a.distance+E)/l;return 0>h||h>1?void 0:(e.multiplyByScalar(u,h,s),e.add(r,s,s),s)},w.trianglePlaneIntersection=function(r,t,o,a){if(!(n(r)&&n(t)&&n(o)&&n(a)))throw new i("p0, p1, p2, and plane are required.");var s=a.normal,u=a.distance,f=e.dot(s,r)+u<0,l=e.dot(s,t)+u<0,E=e.dot(s,o)+u<0,h=0;h+=f?1:0,h+=l?1:0,h+=E?1:0;var c,d;if((1===h||2===h)&&(c=new e,d=new e),1===h){if(f)return w.lineSegmentPlane(r,t,a,c),w.lineSegmentPlane(r,o,a,d),{positions:[r,t,o,c,d],indices:[0,3,4,1,2,4,1,4,3]};if(l)return w.lineSegmentPlane(t,o,a,c),w.lineSegmentPlane(t,r,a,d),{positions:[r,t,o,c,d],indices:[1,3,4,2,0,4,2,4,3]};if(E)return w.lineSegmentPlane(o,r,a,c),w.lineSegmentPlane(o,t,a,d),{positions:[r,t,o,c,d],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===h){if(!f)return w.lineSegmentPlane(t,r,a,c),w.lineSegmentPlane(o,r,a,d),{positions:[r,t,o,c,d],indices:[1,2,4,1,4,3,0,3,4]};if(!l)return w.lineSegmentPlane(o,t,a,c),w.lineSegmentPlane(r,t,a,d),{positions:[r,t,o,c,d],indices:[2,0,4,2,4,3,1,3,4]};if(!E)return w.lineSegmentPlane(r,o,a,c),w.lineSegmentPlane(t,o,a,d),{positions:[r,t,o,c,d],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},w}),define("Core/isArray",["./defined"],function(e){"use strict";var r=Array.isArray;return e(r)||(r=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),r}),define("Core/PolylinePipeline",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidGeodesic","./IntersectionTests","./isArray","./Math","./Matrix4","./Plane"],function(e,r,t,n,i,o,a,s,u,f,l,E){"use strict";function h(e,r,t){var n=N;n.length=e;var i;if(r===t){for(i=0;e>i;i++)n[i]=r;return n}var o=t-r,a=o/e;for(i=0;e>i;i++){var s=r+i*a;n[i]=s}return n}function c(r,t,n,i,o,a,s,u){var f=i.scaleToGeodeticSurface(r,O),l=i.scaleToGeodeticSurface(t,y),E=d.numberOfPoints(r,t,n),c=i.cartesianToCartographic(f,I),w=i.cartesianToCartographic(l,g),_=h(E,o,a);v.setEndPoints(c,w);var R=v.surfaceDistance/E,m=u;c.height=o;var T=i.cartographicToCartesian(c,M);e.pack(T,s,m),m+=3;for(var A=1;E>A;A++){var S=v.interpolateUsingSurfaceDistance(A*R,g);S.height=_[A],T=i.cartographicToCartesian(S,M),e.pack(T,s,m),m+=3}return m}var d={};d.numberOfPoints=function(r,t,n){var i=e.distance(r,t);return Math.ceil(i/n)};var w=new r;d.extractHeights=function(e,r){for(var t=e.length,n=new Array(t),i=0;t>i;i++){var o=e[i];n[i]=r.cartesianToCartographic(o,w).height}return n};var _=new l,R=new e,m=new e,T=new E(e.ZERO,0),A=new e,S=new E(e.ZERO,0),p=new e,C=new e,N=[],I=new r,g=new r,M=new e,O=new e,y=new e,v=new a;d.wrapLongitude=function(r,i){var o=[],a=[];if(n(r)&&r.length>0){i=t(i,l.IDENTITY);var u=l.inverseTransformation(i,_),f=l.multiplyByPoint(u,e.ZERO,R),h=l.multiplyByPointAsVector(u,e.UNIT_Y,m),c=E.fromPointNormal(f,h,T),d=l.multiplyByPointAsVector(u,e.UNIT_X,A),w=E.fromPointNormal(f,d,S),N=1;o.push(e.clone(r[0]));for(var I=o[0],g=r.length,M=1;g>M;++M){var O=r[M];if(E.getPointDistance(w,I)<0||E.getPointDistance(w,O)<0){var y=s.lineSegmentPlane(I,O,c,p);if(n(y)){var v=e.multiplyByScalar(h,5e-9,C);E.getPointDistance(c,I)<0&&e.negate(v,v),o.push(e.add(y,v,new e)),a.push(N+1),e.negate(v,v),o.push(e.add(y,v,new e)),N=1}}o.push(e.clone(r[M])),N++,I=O}a.push(N)}return{positions:o,lengths:a}};var F=f.EPSILON7;return d.removeDuplicates=function(r){if(!n(r))throw new i("positions is required.");var t=r.length;if(2>t)return r;var o,a,s;for(o=1;t>o&&(a=r[o-1],s=r[o],!e.equalsEpsilon(a,s,F));++o);if(o===t)return r;for(var u=r.slice(0,o);t>o;++o)s=r[o],e.equalsEpsilon(a,s,F)||(u.push(e.clone(s)),a=s);return u},d.generateArc=function(r){n(r)||(r={});var a=r.positions;
if(!n(a))throw new i("options.positions is required.");var s=a.length,l=t(r.ellipsoid,o.WGS84),E=t(r.height,0);if(1>s)return[];if(1===s){var h=l.scaleToGeodeticSurface(a[0],O);if(0!==E){var w=l.geodeticSurfaceNormal(h,M);e.multiplyByScalar(w,E,w),e.add(h,w,h)}return[h.x,h.y,h.z]}var _=r.minDistance;if(!n(_)){var R=t(r.granularity,f.RADIANS_PER_DEGREE);_=f.chordLength(R,l.maximumRadius)}var m,T=0;for(m=0;s-1>m;m++)T+=d.numberOfPoints(a[m],a[m+1],_);var A=3*(T+1),S=new Array(A),p=0,C=u(E);for(m=0;s-1>m;m++){var g=a[m],y=a[m+1],v=C?E[m]:E,F=C?E[m+1]:E;p=c(g,y,_,l,v,F,S,p)}N.length=0;var q=a[s-1],L=l.cartesianToCartographic(q,I);L.height=C?E[s-1]:E;var D=l.cartographicToCartesian(L,M);return e.pack(D,S,A-3),S},d.generateCartesianArc=function(r){for(var t=d.generateArc(r),n=t.length/3,i=new Array(n),o=0;n>o;o++)i[o]=e.unpack(t,3*o);return i},d}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,r,t,n){"use strict";var i=function(r){r=e(r,e.EMPTY_OBJECT),this.position=e(r.position,!1),this.normal=e(r.normal,!1),this.st=e(r.st,!1),this.binormal=e(r.binormal,!1),this.tangent=e(r.tangent,!1),this.color=e(r.color,!1)};return i.POSITION_ONLY=n(new i({position:!0})),i.POSITION_AND_NORMAL=n(new i({position:!0,normal:!0})),i.POSITION_NORMAL_AND_ST=n(new i({position:!0,normal:!0,st:!0})),i.POSITION_AND_ST=n(new i({position:!0,st:!0})),i.POSITION_AND_COLOR=n(new i({position:!0,color:!0})),i.ALL=n(new i({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),i.DEFAULT=i.POSITION_NORMAL_AND_ST,i.packedLength=6,i.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.position?1:0,i[o++]=n.normal?1:0,i[o++]=n.st?1:0,i[o++]=n.binormal?1:0,i[o++]=n.tangent?1:0,i[o++]=n.color?1:0},i.unpack=function(n,o,a){if(!r(n))throw new t("array is required");return o=e(o,0),r(a)||(a=new i),a.position=1===n[o++],a.normal=1===n[o++],a.st=1===n[o++],a.binormal=1===n[o++],a.tangent=1===n[o++],a.color=1===n[o++],a},i.clone=function(e,t){return r(e)?(r(t)||(t=new i),t.position=e.position,t.normal=e.normal,t.st=e.st,t.binormal=e.binormal,t.tangent=e.tangent,t.color=e.color,t):void 0},i}),define("Core/PolylineGeometry",["./BoundingSphere","./Cartesian3","./Color","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryType","./IndexDatatype","./Math","./PolylinePipeline","./PrimitiveType","./VertexFormat"],function(e,r,t,n,i,o,a,s,u,f,l,E,h,c,d,w,_){"use strict";function R(e,r,n,i,o){var a=m;a.length=o;var s,u=n.red,f=n.green,l=n.blue,E=n.alpha,h=i.red,c=i.green,d=i.blue,w=i.alpha;if(t.equals(n,i)){for(s=0;o>s;s++)a[s]=t.clone(n);return a}var _=(h-u)/o,R=(c-f)/o,T=(d-l)/o,A=(w-E)/o;for(s=0;o>s;s++)a[s]=new t(u+s*_,f+s*R,l+s*T,E+s*A);return a}var m=[],T=function(e){e=i(e,i.EMPTY_OBJECT);var n=e.positions,u=e.colors,f=i(e.width,1),l=i(e.colorsPerVertex,!1);if(!o(n)||n.length<2)throw new a("At least two positions are required.");if(1>f)throw new a("width must be greater than or equal to one.");if(o(u)&&(l&&u.length<n.length||!l&&u.length<n.length-1))throw new a("colors has an invalid length.");this._positions=n,this._colors=u,this._width=f,this._colorsPerVertex=l,this._vertexFormat=_.clone(i(e.vertexFormat,_.DEFAULT)),this._followSurface=i(e.followSurface,!0),this._granularity=i(e.granularity,c.RADIANS_PER_DEGREE),this._ellipsoid=s.clone(i(e.ellipsoid,s.WGS84)),this._workerName="createPolylineGeometry";var E=1+n.length*r.packedLength;E+=o(u)?1+u.length*t.packedLength:1,this.packedLength=E+s.packedLength+_.packedLength+4};T.pack=function(e,n,u){if(!o(e))throw new a("value is required");if(!o(n))throw new a("array is required");u=i(u,0);var f,l=e._positions,E=l.length;for(n[u++]=E,f=0;E>f;++f,u+=r.packedLength)r.pack(l[f],n,u);var h=e._colors;for(E=o(h)?h.length:0,n[u++]=E,f=0;E>f;++f,u+=t.packedLength)t.pack(h[f],n,u);s.pack(e._ellipsoid,n,u),u+=s.packedLength,_.pack(e._vertexFormat,n,u),u+=_.packedLength,n[u++]=e._width,n[u++]=e._colorsPerVertex?1:0,n[u++]=e._followSurface?1:0,n[u]=e._granularity};var A=s.clone(s.UNIT_SPHERE),S=new _,p={positions:void 0,colors:void 0,ellipsoid:A,vertexFormat:S,width:void 0,colorsPerVertex:void 0,followSurface:void 0,granularity:void 0};T.unpack=function(e,n,u){if(!o(e))throw new a("array is required");n=i(n,0);var f,l=e[n++],E=new Array(l);for(f=0;l>f;++f,n+=r.packedLength)E[f]=r.unpack(e,n);l=e[n++];var h=l>0?new Array(l):void 0;for(f=0;l>f;++f,n+=t.packedLength)h[f]=t.unpack(e,n);var c=s.unpack(e,n,A);n+=s.packedLength;var d=_.unpack(e,n,S);n+=_.packedLength;var w=e[n++],R=1===e[n++],m=1===e[n++],C=e[n];return o(u)?(u._positions=E,u._colors=h,u._ellipsoid=s.clone(c,u._ellipsoid),u._vertexFormat=_.clone(d,u._vertexFormat),u._width=w,u._colorsPerVertex=R,u._followSurface=m,u._granularity=C,u):(p.positions=E,p.colors=h,p.width=w,p.colorsPerVertex=R,p.followSurface=m,p.granularity=C,new T(p))};var C=new r,N=new r,I=new r,g=new r;return T.createGeometry=function(i){var a,s,_,T=i._width,A=i._vertexFormat,S=i._colors,p=i._colorsPerVertex,M=i._followSurface,O=i._granularity,y=i._ellipsoid,v=c.chordLength(O,y.maximumRadius),F=d.removeDuplicates(i._positions),q=F.length;if(2>q)return void 0;if(M){var L=d.extractHeights(F,y);if(o(S)){var D=1;for(a=0;q-1>a;++a)D+=d.numberOfPoints(F[a],F[a+1],v);var P=new Array(D),U=0;for(a=0;q-1>a;++a){var B=F[a],b=F[a+1],x=S[a],G=d.numberOfPoints(B,b,v);if(p&&D>a){var z=S[a+1],H=R(B,b,x,z,G),V=H.length;for(s=0;V>s;++s)P[U++]=H[s]}else for(s=0;G>s;++s)P[U++]=t.clone(x)}P[U]=t.clone(S[S.length-1]),S=P,m.length=0}F=d.generateCartesianArc({positions:F,minDistance:v,ellipsoid:y,height:L})}q=F.length;var W,X=4*q-4,Y=new Float64Array(3*X),K=new Float64Array(3*X),k=new Float64Array(3*X),Z=new Float32Array(2*X),j=A.st?new Float32Array(2*X):void 0,Q=o(S)?new Uint8Array(4*X):void 0,J=0,$=0,ee=0,re=0;for(s=0;q>s;++s){0===s?(W=C,r.subtract(F[0],F[1],W),r.add(F[0],W,W)):W=F[s-1],r.clone(W,I),r.clone(F[s],N),s===q-1?(W=C,r.subtract(F[q-1],F[q-2],W),r.add(F[q-1],W,W)):W=F[s+1],r.clone(W,g);var te,ne;o(Q)&&(te=0===s||p?S[s]:S[s-1],s!==q-1&&(ne=S[s]));var ie=0===s?2:0,oe=s===q-1?2:4;for(_=ie;oe>_;++_){r.pack(N,Y,J),r.pack(I,K,J),r.pack(g,k,J),J+=3;var ae=0>_-2?-1:1;if(Z[$++]=2*(_%2)-1,Z[$++]=ae*T,A.st&&(j[ee++]=s/(q-1),j[ee++]=Math.max(Z[$-2],0)),o(Q)){var se=2>_?te:ne;Q[re++]=t.floatToByte(se.red),Q[re++]=t.floatToByte(se.green),Q[re++]=t.floatToByte(se.blue),Q[re++]=t.floatToByte(se.alpha)}}}var ue=new l;ue.position=new f({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:Y}),ue.prevPosition=new f({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:K}),ue.nextPosition=new f({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:k}),ue.expandAndWidth=new f({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:Z}),A.st&&(ue.st=new f({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:j})),o(Q)&&(ue.color=new f({componentDatatype:n.UNSIGNED_BYTE,componentsPerAttribute:4,values:Q,normalize:!0}));var fe=h.createTypedArray(X,6*q-6),le=0,Ee=0,he=q-1;for(s=0;he>s;++s)fe[Ee++]=le,fe[Ee++]=le+2,fe[Ee++]=le+1,fe[Ee++]=le+1,fe[Ee++]=le+2,fe[Ee++]=le+3,le+=4;return new u({attributes:ue,indices:fe,primitiveType:w.TRIANGLES,boundingSphere:e.fromPoints(F),geometryType:E.POLYLINES})},T}),define("Workers/createPolylineGeometry",["../Core/defined","../Core/Ellipsoid","../Core/PolylineGeometry"],function(e,r,t){"use strict";function n(n,i){return e(i)&&(n=t.unpack(n,i)),n._ellipsoid=r.clone(n._ellipsoid),t.createGeometry(n)}return n})}();