/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var r=Object.freeze;return e(r)||(r=function(e){return e}),r}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var r=function(e,r){return void 0!==e?e:r};return r.EMPTY_OBJECT=e({}),r}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var r=function(e){this.name="DeveloperError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r.throwInstantiationError=function(){throw new r("This function defines an interface and should not be called directly.")},r}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var t;for(this.mti==this.N+1&&this.init_genrand(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^r[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^r[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^r[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.signNotZero=function(e){return 0>e?-1:1},i.toSNorm=function(e){return Math.round(255*(.5*i.clamp(e,-1,1)+.5))},i.fromSNorm=function(e){return i.clamp(e,0,255)/255*2-1},i.sinh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r-t)},i.cosh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r+t)},i.lerp=function(e,r,t){return(1-t)*e+t*r},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=3*Math.PI*.5,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){if(!t(e))throw new n("degrees is required.");return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){if(!t(e))throw new n("radians is required.");return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){if(!t(e))throw new n("angle is required.");var r=i.TWO_PI,a=e-Math.floor(e/r)*r;return a<-Math.PI?a+r:a>=Math.PI?a-r:a},i.negativePiToPi=function(e){if(!t(e))throw new n("x is required.");return i.zeroToTwoPi(e+i.PI)-i.PI},i.zeroToTwoPi=function(e){if(!t(e))throw new n("x is required.");var r=i.mod(e,i.TWO_PI);return Math.abs(r)<i.EPSILON14&&Math.abs(e)>i.EPSILON14?i.TWO_PI:r},i.mod=function(e,r){if(!t(e))throw new n("m is required.");if(!t(r))throw new n("n is required.");return(e%r+r)%r},i.equalsEpsilon=function(e,i,a,o){if(!t(e))throw new n("left is required.");if(!t(i))throw new n("right is required.");if(!t(a))throw new n("relativeEpsilon is required.");o=r(o,a);var u=Math.abs(e-i);return o>=u||u<=a*Math.max(Math.abs(e),Math.abs(i))};var a=[1];i.factorial=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");var r=a.length;if(e>=r)for(var t=a[r-1],i=r;e>=i;i++)a.push(t*i);return a[e]},i.incrementWrap=function(e,i,a){if(a=r(a,0),!t(e))throw new n("n is required.");if(a>=i)throw new n("maximumValue must be greater than minimumValue.");return++e,e>i&&(e=a),e},i.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,r,i){if(!t(e))throw new n("value is required");if(!t(r))throw new n("min is required.");if(!t(i))throw new n("max is required.");return r>e?r:e>i?i:e};var o=new e;return i.setRandomNumberSeed=function(r){if(!t(r))throw new n("seed is required.");o=new e(r)},i.nextRandomNumber=function(){return o.random()},i.acosClamped=function(e){if(!t(e))throw new n("value is required.");return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){if(!t(e))throw new n("value is required.");return Math.asin(i.clamp(e,-1,1))},i.chordLength=function(e,r){if(!t(e))throw new n("angle is required.");if(!t(r))throw new n("radius is required.");return 2*r*Math.sin(.5*e)},i}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t,n){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0)};a.fromSpherical=function(n,i){if(!r(n))throw new t("spherical is required");r(i)||(i=new a);var o=n.clock,u=n.cone,s=e(n.magnitude,1),l=s*Math.sin(u);return i.x=l*Math.cos(o),i.y=l*Math.sin(o),i.z=s*Math.cos(u),i},a.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new a(e,t,n)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new a(e.x,e.y,e.z):void 0},a.fromCartesian4=a.clone,a.packedLength=3,a.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.x,i[a++]=n.y,i[a]=n.z},a.unpack=function(n,i,o){if(!r(n))throw new t("array is required");return i=e(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i++],o.z=n[i],o},a.fromArray=a.unpack,a.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z)},a.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z)},a.minimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i},a.maximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i},a.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitude(o)},a.distanceSquared=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitudeSquared(o)},a.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=a.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n},a.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z},a.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i},a.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i},a.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i},a.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i},a.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i},a.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n},a.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n};var u=new a;a.lerp=function(e,n,i,o){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(o))throw new t("result is required.");return a.multiplyByScalar(n,i,u),o=a.multiplyByScalar(e,1-i,o),a.add(u,o,o)};var s=new a,l=new a;a.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");a.normalize(e,s),a.normalize(n,l);var i=a.dot(s,l),o=a.magnitude(a.cross(s,l,s));return Math.atan2(o,i)};var c=new a;a.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=a.normalize(e,c);return a.abs(i,i),n=i.x<=i.y?i.x<=i.z?a.clone(a.UNIT_X,n):a.clone(a.UNIT_Z,n):i.y<=i.z?a.clone(a.UNIT_Y,n):a.clone(a.UNIT_Z,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},a.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]&&e.z===r[t+2]},a.equalsEpsilon=function(e,t,n,a){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,a)&&i.equalsEpsilon(e.y,t.y,n,a)&&i.equalsEpsilon(e.z,t.z,n,a)},a.cross=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");var a=e.x,o=e.y,u=e.z,s=n.x,l=n.y,c=n.z,f=o*c-u*l,h=u*s-a*c,d=a*l-o*s;return i.x=f,i.y=h,i.z=d,i},a.fromDegrees=function(e,n,o,u,s){if(!r(e))throw new t("longitude is required");if(!r(n))throw new t("latitude is required");var l=i.toRadians(e),c=i.toRadians(n);return a.fromRadians(l,c,o,u,s)};var f=new a,h=new a,d=new a(40680631590769,40680631590769,40408299984661.445);return a.fromRadians=function(n,i,o,u,s){if(!r(n))throw new t("longitude is required");if(!r(i))throw new t("latitude is required");o=e(o,0);var l=r(u)?u.radiiSquared:d,c=Math.cos(i);f.x=c*Math.cos(n),f.y=c*Math.sin(n),f.z=Math.sin(i),f=a.normalize(f,f),a.multiplyComponents(l,f,h);var w=Math.sqrt(a.dot(f,h));return h=a.divideByScalar(h,w,h),f=a.multiplyByScalar(f,o,f),r(s)||(s=new a),a.add(h,f,s)},a.fromDegreesArray=function(e,n,o){if(!r(e))throw new t("positions is required.");for(var u=new Array(e.length),s=0;s<e.length;s++)u[s]=i.toRadians(e[s]);return a.fromRadiansArray(u,n,o)},a.fromRadiansArray=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<2)throw new t("positions length cannot be less than 2.");if(e.length%2!==0)throw new t("positions length must be a multiple of 2.");var o=e.length;r(i)?i.length=o/2:i=new Array(o/2);for(var u=0;o>u;u+=2){var s=e[u],l=e[u+1];i[u/2]=a.fromRadians(s,l,0,n,i[u/2])}return i},a.fromDegreesArrayHeights=function(e,n,o){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(e.length%3!==0)throw new t("positions length must be a multiple of 3.");for(var u=new Array(e.length),s=0;s<e.length;s+=3)u[s]=i.toRadians(e[s]),u[s+1]=i.toRadians(e[s+1]),u[s+2]=e[s+2];return a.fromRadiansArrayHeights(u,n,o)},a.fromRadiansArrayHeights=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(e.length%3!==0)throw new t("positions length must be a multiple of 3.");var o=e.length;r(i)?i.length=o/3:i=new Array(o/3);for(var u=0;o>u;u+=3){var s=e[u],l=e[u+1],c=e[u+2];i[u/3]=a.fromRadians(s,l,c,n,i[u/3])}return i},a.ZERO=n(new a(0,0,0)),a.UNIT_X=n(new a(1,0,0)),a.UNIT_Y=n(new a(0,1,0)),a.UNIT_Z=n(new a(0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r,t){return a.equalsEpsilon(this,e,r,t)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},a}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t,n){this.longitude=e(r,0),this.latitude=e(t,0),this.height=e(n,0)};return a.fromRadians=function(n,i,o,u){if(!r(n))throw new t("longitude is required.");if(!r(i))throw new t("latitude is required.");return o=e(o,0),r(u)?(u.longitude=n,u.latitude=i,u.height=o,u):new a(n,i,o)},a.fromDegrees=function(e,n,o,u){if(!r(e))throw new t("longitude is required.");if(!r(n))throw new t("latitude is required.");return e=i.toRadians(e),n=i.toRadians(n),a.fromRadians(e,n,o,u)},a.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new a(e.longitude,e.latitude,e.height):void 0},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},a.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.longitude-n.longitude)<=i&&Math.abs(e.latitude-n.latitude)<=i&&Math.abs(e.height-n.height)<=i},a.ZERO=n(new a(0,0,0)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r){return a.equalsEpsilon(this,e,r)},a.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},a}),define("Core/defineProperties",["./defined"],function(e){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),t=Object.defineProperties;return r&&e(t)||(t=function(e){return e}),t}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,a,o,u){"use strict";function s(r,n,i,o){if(n=t(n,0),i=t(i,0),o=t(o,0),0>n||0>i||0>o)throw new a("All radii components must be greater than or equal to zero.");r._radii=new e(n,i,o),r._radiiSquared=new e(n*n,i*i,o*o),r._radiiToTheFourth=new e(n*n*n*n,i*i*i*i,o*o*o*o),r._oneOverRadii=new e(0===n?0:1/n,0===i?0:1/i,0===o?0:1/o),r._oneOverRadiiSquared=new e(0===n?0:1/(n*n),0===i?0:1/(i*i),0===o?0:1/(o*o)),r._minimumRadius=Math.min(n,i,o),r._maximumRadius=Math.max(n,i,o),r._centerToleranceSquared=u.EPSILON1}var l=function(e,r,t){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,s(this,e,r,t)};i(l.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),l.clone=function(r,t){if(!n(r))return void 0;var i=r._radii;return n(t)?(e.clone(i,t._radii),e.clone(r._radiiSquared,t._radiiSquared),e.clone(r._radiiToTheFourth,t._radiiToTheFourth),e.clone(r._oneOverRadii,t._oneOverRadii),e.clone(r._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=r._minimumRadius,t._maximumRadius=r._maximumRadius,t._centerToleranceSquared=r._centerToleranceSquared,t):new l(i.x,i.y,i.z)},l.fromCartesian3=function(e,r){return n(r)||(r=new l),n(e)?(s(r,e.x,e.y,e.z),r):r},l.WGS84=o(new l(6378137,6378137,6356752.314245179)),l.UNIT_SPHERE=o(new l(1,1,1)),l.MOON=o(new l(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),l.prototype.clone=function(e){return l.clone(this,e)},l.packedLength=e.packedLength,l.pack=function(r,i,o){if(!n(r))throw new a("value is required");if(!n(i))throw new a("array is required");o=t(o,0),e.pack(r._radii,i,o)},l.unpack=function(r,i,o){if(!n(r))throw new a("array is required");i=t(i,0);var u=e.unpack(r,i);return l.fromCartesian3(u,o)},l.prototype.geocentricSurfaceNormal=e.normalize,l.prototype.geodeticSurfaceNormalCartographic=function(r,t){if(!n(r))throw new a("cartographic is required.");var i=r.longitude,o=r.latitude,u=Math.cos(o),s=u*Math.cos(i),l=u*Math.sin(i),c=Math.sin(o);return n(t)||(t=new e),t.x=s,t.y=l,t.z=c,e.normalize(t,t)},l.prototype.geodeticSurfaceNormal=function(r,t){return n(t)||(t=new e),t=e.multiplyComponents(r,this._oneOverRadiiSquared,t),e.normalize(t,t)};var c=new e,f=new e;l.prototype.cartographicToCartesian=function(r,t){var i=c,a=f;this.geodeticSurfaceNormalCartographic(r,i),e.multiplyComponents(this._radiiSquared,i,a);var o=Math.sqrt(e.dot(i,a));return e.divideByScalar(a,o,a),e.multiplyByScalar(i,r.height,i),n(t)||(t=new e),e.add(a,i,t)},l.prototype.cartographicArrayToCartesianArray=function(e,r){if(!n(e))throw new a("cartographics is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;i++)r[i]=this.cartographicToCartesian(e[i],r[i]);return r};var h=new e,d=new e,w=new e;l.prototype.cartesianToCartographic=function(t,i){var a=this.scaleToGeodeticSurface(t,d);if(!n(a))return void 0;var o=this.geodeticSurfaceNormal(a,h),s=e.subtract(t,a,w),l=Math.atan2(o.y,o.x),c=Math.asin(o.z),f=u.sign(e.dot(s,t))*e.magnitude(s);return n(i)?(i.longitude=l,i.latitude=c,i.height=f,i):new r(l,c,f)},l.prototype.cartesianArrayToCartographicArray=function(e,r){if(!n(e))throw new a("cartesians is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;++i)r[i]=this.cartesianToCartographic(e[i],r[i]);return r};var m=new e,p=new e;return l.prototype.scaleToGeodeticSurface=function(r,t){if(!n(r))throw new a("cartesian is required.");var i=r.x,o=r.y,s=r.z,l=this._oneOverRadii,c=l.x,f=l.y,h=l.z,d=i*i*c*c,w=o*o*f*f,y=s*s*h*h,E=d+w+y,v=Math.sqrt(1/E),_=e.multiplyByScalar(r,v,m);if(E<this._centerToleranceSquared)return isFinite(v)?e.clone(_,t):void 0;var T=this._oneOverRadiiSquared,g=T.x,R=T.y,A=T.z,S=p;S.x=_.x*g*2,S.y=_.y*R*2,S.z=_.z*A*2;var N,I,O,q,x,M,b,P,C,D,L,U=(1-v)*e.magnitude(r)/(.5*e.magnitude(S)),F=0;do{U-=F,O=1/(1+U*g),q=1/(1+U*R),x=1/(1+U*A),M=O*O,b=q*q,P=x*x,C=M*O,D=b*q,L=P*x,N=d*M+w*b+y*P-1,I=d*C*g+w*D*R+y*L*A;var z=-2*I;F=N/z}while(Math.abs(N)>u.EPSILON12);return n(t)?(t.x=i*O,t.y=o*q,t.z=s*x,t):new e(i*O,o*q,s*x)},l.prototype.scaleToGeocentricSurface=function(r,t){if(!n(r))throw new a("cartesian is required.");n(t)||(t=new e);var i=r.x,o=r.y,u=r.z,s=this._oneOverRadiiSquared,l=1/Math.sqrt(i*i*s.x+o*o*s.y+u*u*s.z);return e.multiplyByScalar(r,l,t)},l.prototype.transformPositionToScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._oneOverRadii,t)},l.prototype.transformPositionFromScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._radii,t)},l.prototype.equals=function(r){return this===r||n(r)&&e.equals(this._radii,r._radii)},l.prototype.toString=function(){return this._radii.toString()},l}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t){this.x=e(r,0),this.y=e(t,0)};a.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new a(e,t)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t):new a(e.x,e.y):void 0},a.fromCartesian3=a.clone,a.fromCartesian4=a.clone,a.packedLength=2,a.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.x,i[a]=n.y},a.unpack=function(n,i,o){if(!r(n))throw new t("array is required");return i=e(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i],o},a.fromArray=a.unpack,a.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y)},a.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y)},a.minimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i},a.maximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i},a.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitude(o)},a.distanceSquared=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitudeSquared(o)},a.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=a.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n},a.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y},a.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i},a.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i},a.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i},a.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i},a.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i},a.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n},a.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n};var u=new a;a.lerp=function(e,n,i,o){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(o))throw new t("result is required.");return a.multiplyByScalar(n,i,u),o=a.multiplyByScalar(e,1-i,o),a.add(u,o,o)};var s=new a,l=new a;a.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return a.normalize(e,s),a.normalize(n,l),i.acosClamped(a.dot(s,l))};var c=new a;return a.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=a.normalize(e,c);return a.abs(i,i),n=i.x<=i.y?a.clone(a.UNIT_X,n):a.clone(a.UNIT_Y,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},a.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]},a.equalsEpsilon=function(e,t,n,a){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,a)&&i.equalsEpsilon(e.y,t.y,n,a)},a.ZERO=n(new a(0,0)),a.UNIT_X=n(new a(1,0)),a.UNIT_Y=n(new a(0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r,t){return a.equalsEpsilon(this,e,r,t)},a.prototype.toString=function(){return"("+this.x+", "+this.y+")"},a}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,r,t,n,i,a,o){"use strict";var u=function(e){this._ellipsoid=t(e,o.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(r,t){var i=this._semimajorAxis,a=r.longitude*i,o=r.latitude*i,u=r.height;return n(t)?(t.x=a,t.y=o,t.z=u,t):new e(a,o,u)},u.prototype.unproject=function(e,t){if(!n(e))throw new a("cartesian is required");var i=this._oneOverSemimajorAxis,o=e.x*i,u=e.y*i,s=e.z;return n(t)?(t.longitude=o,t.latitude=u,t.height=s,t):new r(o,u,s)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var r={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(r)}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,r,t,n,i,a,o,u){"use strict";var s=function(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)};n(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,a){if(!t(e))throw new i("value is required");if(!t(n))throw new i("array is required");a=r(a,0),n[a++]=e.west,n[a++]=e.south,n[a++]=e.east,n[a]=e.north},s.unpack=function(e,n,a){if(!t(e))throw new i("array is required");return n=r(n,0),t(a)||(a=new s),a.west=e[n++],a.south=e[n++],a.east=e[n++],a.north=e[n],a},s.computeWidth=function(e){if(!t(e))throw new i("rectangle is required.");var r=e.east,n=e.west;return n>r&&(r+=u.TWO_PI),r-n},s.computeHeight=function(e){if(!t(e))throw new i("rectangle is required.");return e.north-e.south},s.fromDegrees=function(e,n,i,a,o){return e=u.toRadians(r(e,0)),n=u.toRadians(r(n,0)),i=u.toRadians(r(i,0)),a=u.toRadians(r(a,0)),t(o)?(o.west=e,o.south=n,o.east=i,o.north=a,o):new s(e,n,i,a)},s.fromCartographicArray=function(e,r){if(!t(e))throw new i("cartographics is required.");for(var n=Number.MAX_VALUE,a=-Number.MAX_VALUE,o=Number.MAX_VALUE,u=-Number.MAX_VALUE,l=0,c=e.length;c>l;l++){var f=e[l];n=Math.min(n,f.longitude),a=Math.max(a,f.longitude),o=Math.min(o,f.latitude),u=Math.max(u,f.latitude)}return t(r)?(r.west=n,r.south=o,r.east=a,r.north=u,r):new s(n,o,a,u)},s.clone=function(e,r){return t(e)?t(r)?(r.west=e.west,r.south=e.south,r.east=e.east,r.north=e.north,r):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.west===r.west&&e.south===r.south&&e.east===r.east&&e.north===r.north},s.prototype.equalsEpsilon=function(e,r){if("number"!=typeof r)throw new i("epsilon is required and must be a number.");return t(e)&&Math.abs(this.west-e.west)<=r&&Math.abs(this.south-e.south)<=r&&Math.abs(this.east-e.east)<=r&&Math.abs(this.north-e.north)<=r},s.validate=function(e){if(!t(e))throw new i("rectangle is required");var r=e.north;if("number"!=typeof r)throw new i("north is required to be a number.");if(r<-u.PI_OVER_TWO||r>u.PI_OVER_TWO)throw new i("north must be in the interval [-Pi/2, Pi/2].");var n=e.south;if("number"!=typeof n)throw new i("south is required to be a number.");if(n<-u.PI_OVER_TWO||n>u.PI_OVER_TWO)throw new i("south must be in the interval [-Pi/2, Pi/2].");var a=e.west;if("number"!=typeof a)throw new i("west is required to be a number.");if(a<-Math.PI||a>Math.PI)throw new i("west must be in the interval [-Pi, Pi].");var o=e.east;if("number"!=typeof o)throw new i("east is required to be a number.");if(o<-Math.PI||o>Math.PI)throw new i("east must be in the interval [-Pi, Pi].")},s.southwest=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.west,n.latitude=r.south,n.height=0,n):new e(r.west,r.south)},s.northwest=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.west,n.latitude=r.north,n.height=0,n):new e(r.west,r.north)},s.northeast=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.east,n.latitude=r.north,n.height=0,n):new e(r.east,r.north)},s.southeast=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.east,n.latitude=r.south,n.height=0,n):new e(r.east,r.south)},s.center=function(r,n){if(!t(r))throw new i("rectangle is required");var a=r.east,o=r.west;o>a&&(a+=u.TWO_PI);var s=u.negativePiToPi(.5*(o+a)),l=.5*(r.south+r.north);return t(n)?(n.longitude=s,n.latitude=l,n.height=0,n):new e(s,l)},s.intersection=function(e,r,n){if(!t(e))throw new i("rectangle is required");if(!t(r))throw new i("otherRectangle is required.");var a=e.east,o=e.west,l=r.east,c=r.west;o>a&&l>0?a+=u.TWO_PI:c>l&&a>0&&(l+=u.TWO_PI),o>a&&0>c?c+=u.TWO_PI:c>l&&0>o&&(o+=u.TWO_PI);var f=u.negativePiToPi(Math.max(o,c)),h=u.negativePiToPi(Math.min(a,l));if((e.west<e.east||r.west<r.east)&&f>=h)return void 0;var d=Math.max(e.south,r.south),w=Math.min(e.north,r.north);return d>=w?void 0:t(n)?(n.west=f,n.south=d,n.east=h,n.north=w,n):new s(f,d,h,w)},s.contains=function(e,r){if(!t(e))throw new i("rectangle is required");if(!t(r))throw new i("cartographic is required.");var n=r.longitude,a=r.latitude,o=e.west,s=e.east;return o>s&&(s+=u.TWO_PI,0>n&&(n+=u.TWO_PI)),(n>o||u.equalsEpsilon(n,o,u.EPSILON14))&&(s>n||u.equalsEpsilon(n,s,u.EPSILON14))&&a>=e.south&&a<=e.north};var l=new e;return s.subsample=function(e,n,o,c){if(!t(e))throw new i("rectangle is required");n=r(n,a.WGS84),o=r(o,0),t(c)||(c=[]);var f=0,h=e.north,d=e.south,w=e.east,m=e.west,p=l;p.height=o,p.longitude=m,p.latitude=h,c[f]=n.cartographicToCartesian(p,c[f]),f++,p.longitude=w,c[f]=n.cartographicToCartesian(p,c[f]),f++,p.latitude=d,c[f]=n.cartographicToCartesian(p,c[f]),f++,p.longitude=m,c[f]=n.cartographicToCartesian(p,c[f]),f++,0>h?p.latitude=h:d>0?p.latitude=d:p.latitude=0;for(var y=1;8>y;++y)p.longitude=-Math.PI+y*u.PI_OVER_TWO,s.contains(e,p)&&(c[f]=n.cartographicToCartesian(p,c[f]),f++);return 0===p.latitude&&(p.longitude=m,c[f]=n.cartographicToCartesian(p,c[f]),f++,p.longitude=w,c[f]=n.cartographicToCartesian(p,c[f]),f++),c.length=f,c},s.MAX_VALUE=o(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingRectangle",["./Cartesian2","./Cartographic","./defaultValue","./defined","./DeveloperError","./GeographicProjection","./Intersect","./Rectangle"],function(e,r,t,n,i,a,o,u){"use strict";var s=function(e,r,n,i){this.x=t(e,0),this.y=t(r,0),this.width=t(n,0),this.height=t(i,0)};s.fromPoints=function(e,r){if(n(r)||(r=new s),!n(e)||0===e.length)return r.x=0,r.y=0,r.width=0,r.height=0,r;for(var t=e.length,i=e[0].x,a=e[0].y,o=e[0].x,u=e[0].y,l=1;t>l;l++){var c=e[l],f=c.x,h=c.y;i=Math.min(f,i),o=Math.max(f,o),a=Math.min(h,a),u=Math.max(h,u)}return r.x=i,r.y=a,r.width=o-i,
r.height=u-a,r};var l=new a,c=new r,f=new r;return s.fromRectangle=function(r,i,a){if(n(a)||(a=new s),!n(r))return a.x=0,a.y=0,a.width=0,a.height=0,a;i=t(i,l);var o=i.project(u.southwest(r,c)),h=i.project(u.northeast(r,f));return e.subtract(h,o,h),a.x=o.x,a.y=o.y,a.width=h.x,a.height=h.y,a},s.clone=function(e,r){return n(e)?n(r)?(r.x=e.x,r.y=e.y,r.width=e.width,r.height=e.height,r):new s(e.x,e.y,e.width,e.height):void 0},s.union=function(e,r,t){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");n(t)||(t=new s);var a=Math.min(e.x,r.x),o=Math.min(e.y,r.y),u=Math.max(e.x+e.width,r.x+r.width),l=Math.max(e.y+e.height,r.y+r.height);return t.x=a,t.y=o,t.width=u-a,t.height=l-o,t},s.expand=function(e,r,t){if(!n(e))throw new i("rectangle is required.");if(!n(r))throw new i("point is required.");t=s.clone(e,t);var a=r.x-t.x,o=r.y-t.y;return a>t.width?t.width=a:0>a&&(t.width-=a,t.x=r.x),o>t.height?t.height=o:0>o&&(t.height-=o,t.y=r.y),t},s.intersect=function(e,r){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");var t=e.x,a=e.y,u=r.x,s=r.y;return t>u+r.width||t+e.width<u||a+e.height<s||a>s+r.height?o.OUTSIDE:o.INTERSECTING},s.equals=function(e,r){return e===r||n(e)&&n(r)&&e.x===r.x&&e.y===r.y&&e.width===r.width&&e.height===r.height},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.intersect=function(e){return s.intersect(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s}),define("Core/deprecationWarning",["./defined","./DeveloperError"],function(e,r){"use strict";var t={},n=function(n,i){if(!e(n)||!e(i))throw new r("identifier and message are required.");e(t[n])||(t[n]=!0,console.log(i))};return n}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var r=function(r,t){this.start=e(r,0),this.stop=e(t,0)};return r}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a=function(r,t,n,i){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0),this.w=e(i,0)};a.fromElements=function(e,t,n,i,o){return r(o)?(o.x=e,o.y=t,o.z=n,o.w=i,o):new a(e,t,n,i)},a.fromColor=function(e,n){if(!r(e))throw new t("color is required");return r(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new a(e.red,e.green,e.blue,e.alpha)},a.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new a(e.x,e.y,e.z,e.w):void 0},a.packedLength=4,a.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.x,i[a++]=n.y,i[a++]=n.z,i[a]=n.w},a.unpack=function(n,i,o){if(!r(n))throw new t("array is required");return i=e(i,0),r(o)||(o=new a),o.x=n[i++],o.y=n[i++],o.z=n[i++],o.w=n[i],o},a.fromArray=a.unpack,a.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z,e.w)},a.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z,e.w)},a.minimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i.w=Math.min(e.w,n.w),i},a.maximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i.w=Math.max(e.w,n.w),i},a.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},a.magnitude=function(e){return Math.sqrt(a.magnitudeSquared(e))};var o=new a;a.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitude(o)},a.distanceSquared=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return a.subtract(e,n,o),a.magnitudeSquared(o)},a.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=a.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n.w=e.w/i,n},a.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z+e.w*n.w},a.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i.w=e.w*n.w,i},a.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i.w=e.w+n.w,i},a.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i.w=e.w-n.w,i},a.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i.w=e.w*n,i},a.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i.w=e.w/n,i},a.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n.w=-e.w,n},a.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n.w=Math.abs(e.w),n};var u=new a;a.lerp=function(e,n,i,o){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(o))throw new t("result is required.");return a.multiplyByScalar(n,i,u),o=a.multiplyByScalar(e,1-i,o),a.add(u,o,o)};var s=new a;return a.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=a.normalize(e,s);return a.abs(i,i),n=i.x<=i.y?i.x<=i.z?i.x<=i.w?a.clone(a.UNIT_X,n):a.clone(a.UNIT_W,n):i.z<=i.w?a.clone(a.UNIT_Z,n):a.clone(a.UNIT_W,n):i.y<=i.z?i.y<=i.w?a.clone(a.UNIT_Y,n):a.clone(a.UNIT_W,n):i.z<=i.w?a.clone(a.UNIT_Z,n):a.clone(a.UNIT_W,n)},a.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},a.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]&&e.z===r[t+2]&&e.w===r[t+3]},a.equalsEpsilon=function(e,t,n,a){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,a)&&i.equalsEpsilon(e.y,t.y,n,a)&&i.equalsEpsilon(e.z,t.z,n,a)&&i.equalsEpsilon(e.w,t.w,n,a)},a.ZERO=n(new a(0,0,0,0)),a.UNIT_X=n(new a(1,0,0,0)),a.UNIT_Y=n(new a(0,1,0,0)),a.UNIT_Z=n(new a(0,0,1,0)),a.UNIT_W=n(new a(0,0,0,1)),a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e){return a.equals(this,e)},a.prototype.equalsEpsilon=function(e,r,t){return a.equalsEpsilon(this,e,r,t)},a.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},a}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,a){"use strict";function o(e){for(var r=0,t=0;9>t;++t){var n=e[t];r+=n*n}return Math.sqrt(r)}function u(e){for(var r=0,t=0;3>t;++t){var n=e[l.getElementIndex(d[t],h[t])];r+=2*n*n}return Math.sqrt(r)}function s(e,r){for(var t=a.EPSILON15,n=0,i=1,o=0;3>o;++o){var u=Math.abs(e[l.getElementIndex(d[o],h[o])]);u>n&&(i=o,n=u)}var s=1,c=0,f=h[i],w=d[i];if(Math.abs(e[l.getElementIndex(w,f)])>t){var m,p=e[l.getElementIndex(w,w)],y=e[l.getElementIndex(f,f)],E=e[l.getElementIndex(w,f)],v=(p-y)/2/E;m=0>v?-1/(-v+Math.sqrt(1+v*v)):1/(v+Math.sqrt(1+v*v)),s=1/Math.sqrt(1+m*m),c=m*s}return r=l.clone(l.IDENTITY,r),r[l.getElementIndex(f,f)]=r[l.getElementIndex(w,w)]=s,r[l.getElementIndex(w,f)]=c,r[l.getElementIndex(f,w)]=-c,r}var l=function(e,t,n,i,a,o,u,s,l){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(a,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(o,0),this[8]=r(l,0)};l.packedLength=9,l.pack=function(e,i,a){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");a=r(a,0),i[a++]=e[0],i[a++]=e[1],i[a++]=e[2],i[a++]=e[3],i[a++]=e[4],i[a++]=e[5],i[a++]=e[6],i[a++]=e[7],i[a++]=e[8]},l.unpack=function(e,i,a){if(!t(e))throw new n("array is required");return i=r(i,0),t(a)||(a=new l),a[0]=e[i++],a[1]=e[i++],a[2]=e[i++],a[3]=e[i++],a[4]=e[i++],a[5]=e[i++],a[6]=e[i++],a[7]=e[i++],a[8]=e[i++],a},l.clone=function(e,r){return t(e)?t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):new l(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},l.fromArray=function(e,i,a){if(!t(e))throw new n("array is required");return i=r(i,0),t(a)||(a=new l),a[0]=e[i],a[1]=e[i+1],a[2]=e[i+2],a[3]=e[i+3],a[4]=e[i+4],a[5]=e[i+5],a[6]=e[i+6],a[7]=e[i+7],a[8]=e[i+8],a},l.fromColumnMajorArray=function(e,r){if(!t(e))throw new n("values parameter is required");return l.clone(e,r)},l.fromRowMajorArray=function(e,r){if(!t(e))throw new n("values is required.");return t(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},l.fromQuaternion=function(e,r){if(!t(e))throw new n("quaternion is required");var i=e.x*e.x,a=e.x*e.y,o=e.x*e.z,u=e.x*e.w,s=e.y*e.y,c=e.y*e.z,f=e.y*e.w,h=e.z*e.z,d=e.z*e.w,w=e.w*e.w,m=i-s-h+w,p=2*(a-d),y=2*(o+f),E=2*(a+d),v=-i+s-h+w,_=2*(c-u),T=2*(o-f),g=2*(c+u),R=-i-s+h+w;return t(r)?(r[0]=m,r[1]=E,r[2]=T,r[3]=p,r[4]=v,r[5]=g,r[6]=y,r[7]=_,r[8]=R,r):new l(m,p,y,E,v,_,T,g,R)},l.fromScale=function(e,r){if(!t(e))throw new n("scale is required.");return t(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new l(e.x,0,0,0,e.y,0,0,0,e.z)},l.fromUniformScale=function(e,r){if("number"!=typeof e)throw new n("scale is required.");return t(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new l(e,0,0,0,e,0,0,0,e)},l.fromCrossProduct=function(e,r){if(!t(e))throw new n("vector is required.");return t(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new l(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},l.fromRotationX=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=a,r[6]=0,r[7]=-a,r[8]=i,r):new l(1,0,0,0,i,-a,0,a,i)},l.fromRotationY=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=i,r[1]=0,r[2]=-a,r[3]=0,r[4]=1,r[5]=0,r[6]=a,r[7]=0,r[8]=i,r):new l(i,0,a,0,1,0,-a,0,i)},l.fromRotationZ=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),a=Math.sin(e);return t(r)?(r[0]=i,r[1]=a,r[2]=0,r[3]=-a,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new l(i,-a,0,a,i,0,0,0,1)},l.toArray=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},l.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>2)throw new n("row must be 0, 1, or 2.");if("number"!=typeof e||0>e||e>2)throw new n("column must be 0, 1, or 2.");return 3*e+r},l.getColumn=function(e,r,i){if(!t(e))throw new n("matrix is required.");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(i))throw new n("result is required");var a=3*r,o=e[a],u=e[a+1],s=e[a+2];return i.x=o,i.y=u,i.z=s,i},l.setColumn=function(e,r,i,a){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(a))throw new n("result is required");a=l.clone(e,a);var o=3*r;return a[o]=i.x,a[o+1]=i.y,a[o+2]=i.z,a},l.getRow=function(e,r,i){if(!t(e))throw new n("matrix is required.");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(i))throw new n("result is required");var a=e[r],o=e[r+3],u=e[r+6];return i.x=a,i.y=o,i.z=u,i},l.setRow=function(e,r,i,a){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(a))throw new n("result is required");return a=l.clone(e,a),a[r]=i.x,a[r+3]=i.y,a[r+6]=i.z,a};var c=new e;l.getScale=function(r,i){if(!t(r))throw new n("matrix is required.");if(!t(i))throw new n("result is required");return i.x=e.magnitude(e.fromElements(r[0],r[1],r[2],c)),i.y=e.magnitude(e.fromElements(r[3],r[4],r[5],c)),i.z=e.magnitude(e.fromElements(r[6],r[7],r[8],c)),i};var f=new e;l.getMaximumScale=function(r){return l.getScale(r,f),e.maximumComponent(f)},l.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");var a=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],o=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],u=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],s=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],l=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],c=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],f=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],h=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],d=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return i[0]=a,i[1]=o,i[2]=u,i[3]=s,i[4]=l,i[5]=c,i[6]=f,i[7]=h,i[8]=d,i},l.add=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i[0]=e[0]+r[0],i[1]=e[1]+r[1],i[2]=e[2]+r[2],i[3]=e[3]+r[3],i[4]=e[4]+r[4],i[5]=e[5]+r[5],i[6]=e[6]+r[6],i[7]=e[7]+r[7],i[8]=e[8]+r[8],i},l.subtract=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],i[3]=e[3]-r[3],i[4]=e[4]-r[4],i[5]=e[5]-r[5],i[6]=e[6]-r[6],i[7]=e[7]-r[7],i[8]=e[8]-r[8],i},l.multiplyByVector=function(e,r,i){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("cartesian is required");if(!t(i))throw new n("result is required");var a=r.x,o=r.y,u=r.z,s=e[0]*a+e[3]*o+e[6]*u,l=e[1]*a+e[4]*o+e[7]*u,c=e[2]*a+e[5]*o+e[8]*u;return i.x=s,i.y=l,i.z=c,i},l.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scalar must be a number");if(!t(i))throw new n("result is required");return i[0]=e[0]*r,i[1]=e[1]*r,i[2]=e[2]*r,i[3]=e[3]*r,i[4]=e[4]*r,i[5]=e[5]*r,i[6]=e[6]*r,i[7]=e[7]*r,i[8]=e[8]*r,i},l.multiplyByScale=function(e,r,i){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("scale is required");if(!t(i))throw new n("result is required");return i[0]=e[0]*r.x,i[1]=e[1]*r.x,i[2]=e[2]*r.x,i[3]=e[3]*r.y,i[4]=e[4]*r.y,i[5]=e[5]*r.y,i[6]=e[6]*r.z,i[7]=e[7]*r.z,i[8]=e[8]*r.z,i},l.negate=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");return r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},l.transpose=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");var i=e[0],a=e[3],o=e[6],u=e[1],s=e[4],l=e[7],c=e[2],f=e[5],h=e[8];return r[0]=i,r[1]=a,r[2]=o,r[3]=u,r[4]=s,r[5]=l,r[6]=c,r[7]=f,r[8]=h,r};var h=[1,0,0],d=[2,2,1],w=new l,m=new l;return l.computeEigenDecomposition=function(e,r){if(!t(e))throw new n("matrix is required.");var i=a.EPSILON20,c=10,f=0,h=0;t(r)||(r={});for(var d=r.unitary=l.clone(l.IDENTITY,r.unitary),p=r.diagonal=l.clone(e,r.diagonal),y=i*o(p);c>h&&u(p)>y;)s(p,w),l.transpose(w,m),l.multiply(p,w,p),l.multiply(m,p,p),l.multiply(d,w,d),++f>2&&(++h,f=0);return r},l.abs=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");return r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},l.determinant=function(e){if(!t(e))throw new n("matrix is required");var r=e[0],i=e[3],a=e[6],o=e[1],u=e[4],s=e[7],l=e[2],c=e[5],f=e[8];return r*(u*f-c*s)+o*(c*a-i*f)+l*(i*s-u*a)},l.inverse=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");var i=e[0],o=e[1],u=e[2],s=e[3],c=e[4],f=e[5],h=e[6],d=e[7],w=e[8],m=l.determinant(e);if(Math.abs(m)<=a.EPSILON15)throw new n("matrix is not invertible");r[0]=c*w-d*f,r[1]=d*u-o*w,r[2]=o*f-c*u,r[3]=h*f-s*w,r[4]=i*w-h*u,r[5]=s*u-i*f,r[6]=s*d-h*c,r[7]=h*o-i*d,r[8]=i*c-s*o;var p=1/m;return l.multiplyByScalar(r,p,r)},l.equals=function(e,r){return e===r||t(e)&&t(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]},l.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon must be a number");return e===r||t(e)&&t(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},l.IDENTITY=i(new l(1,0,0,0,1,0,0,0,1)),l.ZERO=i(new l(0,0,0,0,0,0,0,0,0)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN1ROW0=3,l.COLUMN1ROW1=4,l.COLUMN1ROW2=5,l.COLUMN2ROW0=6,l.COLUMN2ROW1=7,l.COLUMN2ROW2=8,l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.equalsArray=function(e,r,t){return e[0]===r[t]&&e[1]===r[t+1]&&e[2]===r[t+2]&&e[3]===r[t+3]&&e[4]===r[t+4]&&e[5]===r[t+5]&&e[6]===r[t+6]&&e[7]===r[t+7]&&e[8]===r[t+8]},l.prototype.equalsEpsilon=function(e,r){return l.equalsEpsilon(this,e,r)},l.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},l}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var r=function(e){this.name="RuntimeError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,r,t,n,i,a,o,u,s){"use strict";var l=function(e,r,n,i,a,o,u,s,l,c,f,h,d,w,m,p){this[0]=t(e,0),this[1]=t(a,0),this[2]=t(l,0),this[3]=t(d,0),this[4]=t(r,0),this[5]=t(o,0),this[6]=t(c,0),this[7]=t(w,0),this[8]=t(n,0),this[9]=t(u,0),this[10]=t(f,0),this[11]=t(m,0),this[12]=t(i,0),this[13]=t(s,0),this[14]=t(h,0),this[15]=t(p,0)};l.packedLength=16,l.pack=function(e,r,a){if(!n(e))throw new i("value is required");if(!n(r))throw new i("array is required");a=t(a,0),r[a++]=e[0],r[a++]=e[1],r[a++]=e[2],r[a++]=e[3],r[a++]=e[4],r[a++]=e[5],r[a++]=e[6],r[a++]=e[7],r[a++]=e[8],r[a++]=e[9],r[a++]=e[10],r[a++]=e[11],r[a++]=e[12],r[a++]=e[13],r[a++]=e[14],r[a]=e[15]},l.unpack=function(e,r,a){if(!n(e))throw new i("array is required");return r=t(r,0),n(a)||(a=new l),a[0]=e[r++],a[1]=e[r++],a[2]=e[r++],a[3]=e[r++],a[4]=e[r++],a[5]=e[r++],a[6]=e[r++],a[7]=e[r++],a[8]=e[r++],a[9]=e[r++],a[10]=e[r++],a[11]=e[r++],a[12]=e[r++],a[13]=e[r++],a[14]=e[r++],a[15]=e[r],a},l.clone=function(e,r){return n(e)?n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):new l(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},l.fromArray=l.unpack,l.fromColumnMajorArray=function(e,r){if(!n(e))throw new i("values is required");return l.clone(e,r)},l.fromRowMajorArray=function(e,r){if(!n(e))throw new i("values is required.");return n(r)?(r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=e[1],r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=e[2],r[9]=e[6],r[10]=e[10],r[11]=e[14],r[12]=e[3],r[13]=e[7],r[14]=e[11],r[15]=e[15],r):new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},l.fromRotationTranslation=function(r,a,o){if(!n(r))throw new i("rotation is required.");return a=t(a,e.ZERO),n(o)?(o[0]=r[0],o[1]=r[1],o[2]=r[2],o[3]=0,o[4]=r[3],o[5]=r[4],o[6]=r[5],o[7]=0,o[8]=r[6],o[9]=r[7],o[10]=r[8],o[11]=0,o[12]=a.x,o[13]=a.y,o[14]=a.z,o[15]=1,o):new l(r[0],r[3],r[6],a.x,r[1],r[4],r[7],a.y,r[2],r[5],r[8],a.z,0,0,0,1)},l.fromTranslationQuaternionRotationScale=function(e,r,t,a){if(!n(e))throw new i("translation is required.");if(!n(r))throw new i("rotation is required.");if(!n(t))throw new i("scale is required.");n(a)||(a=new l);var o=t.x,u=t.y,s=t.z,c=r.x*r.x,f=r.x*r.y,h=r.x*r.z,d=r.x*r.w,w=r.y*r.y,m=r.y*r.z,p=r.y*r.w,y=r.z*r.z,E=r.z*r.w,v=r.w*r.w,_=c-w-y+v,T=2*(f-E),g=2*(h+p),R=2*(f+E),A=-c+w-y+v,S=2*(m-d),N=2*(h-p),I=2*(m+d),O=-c-w+y+v;return a[0]=_*o,a[1]=R*o,a[2]=N*o,a[3]=0,a[4]=T*u,a[5]=A*u,a[6]=I*u,a[7]=0,a[8]=g*s,a[9]=S*s,a[10]=O*s,a[11]=0,a[12]=e.x,a[13]=e.y,a[14]=e.z,a[15]=1,a},l.fromTranslation=function(e,r){if(!n(e))throw new i("translation is required.");return l.fromRotationTranslation(u.IDENTITY,e,r)},l.fromScale=function(e,r){if(!n(e))throw new i("scale is required.");return n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e.y,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e.z,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new l(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},l.fromUniformScale=function(e,r){if("number"!=typeof e)throw new i("scale is required.");return n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new l(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var c=new e,f=new e,h=new e;l.fromCamera=function(r,t){if(!n(r))throw new i("camera is required.");var a=r.eye,o=r.target,u=r.up;if(!n(a))throw new i("camera.eye is required.");if(!n(o))throw new i("camera.target is required.");if(!n(u))throw new i("camera.up is required.");e.normalize(e.subtract(o,a,c),c),e.normalize(e.cross(c,u,f),f),e.normalize(e.cross(f,c,h),h);var s=f.x,d=f.y,w=f.z,m=c.x,p=c.y,y=c.z,E=h.x,v=h.y,_=h.z,T=a.x,g=a.y,R=a.z,A=s*-T+d*-g+w*-R,S=E*-T+v*-g+_*-R,N=m*T+p*g+y*R;return n(t)?(t[0]=s,t[1]=E,t[2]=-m,t[3]=0,t[4]=d,t[5]=v,t[6]=-p,t[7]=0,t[8]=w,t[9]=_,t[10]=-y,t[11]=0,t[12]=A,t[13]=S,t[14]=N,t[15]=1,t):new l(s,d,w,A,E,v,_,S,-m,-p,-y,N,0,0,0,1)},l.computePerspectiveFieldOfView=function(e,r,t,a,o){if(0>=e||e>Math.PI)throw new i("fovY must be in [0, PI).");if(0>=r)throw new i("aspectRatio must be greater than zero.");if(0>=t)throw new i("near must be greater than zero.");if(0>=a)throw new i("far must be greater than zero.");if(!n(o))throw new i("result is required");var u=Math.tan(.5*e),s=1/u,l=s/r,c=(a+t)/(t-a),f=2*a*t/(t-a);return o[0]=l,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=s,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=c,o[11]=-1,o[12]=0,o[13]=0,o[14]=f,o[15]=0,o},l.computeOrthographicOffCenter=function(e,r,t,a,o,u,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");if(!n(u))throw new i("far is required.");if(!n(s))throw new i("result is required");var l=1/(r-e),c=1/(a-t),f=1/(u-o),h=-(r+e)*l,d=-(a+t)*c,w=-(u+o)*f;return l*=2,c*=2,f*=-2,s[0]=l,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=c,s[6]=0,s[7]=0,s[8]=0,s[9]=0,s[10]=f,s[11]=0,s[12]=h,s[13]=d,s[14]=w,s[15]=1,s},l.computePerspectiveOffCenter=function(e,r,t,a,o,u,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");if(!n(u))throw new i("far is required.");if(!n(s))throw new i("result is required");var l=2*o/(r-e),c=2*o/(a-t),f=(r+e)/(r-e),h=(a+t)/(a-t),d=-(u+o)/(u-o),w=-1,m=-2*u*o/(u-o);return s[0]=l,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=c,s[6]=0,s[7]=0,s[8]=f,s[9]=h,s[10]=d,s[11]=w,s[12]=0,s[13]=0,s[14]=m,s[15]=0,s},l.computeInfinitePerspectiveOffCenter=function(e,r,t,a,o,u){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(a))throw new i("top is required.");if(!n(o))throw new i("near is required.");if(!n(u))throw new i("result is required");var s=2*o/(r-e),l=2*o/(a-t),c=(r+e)/(r-e),f=(a+t)/(a-t),h=-1,d=-1,w=-2*o;return u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=l,u[6]=0,u[7]=0,u[8]=c,u[9]=f,u[10]=h,u[11]=d,u[12]=0,u[13]=0,u[14]=w,u[15]=0,u},l.computeViewportTransformation=function(e,r,a,o){if(!n(o))throw new i("result is required");e=t(e,t.EMPTY_OBJECT);var u=t(e.x,0),s=t(e.y,0),l=t(e.width,0),c=t(e.height,0);r=t(r,0),a=t(a,1);var f=.5*l,h=.5*c,d=.5*(a-r),w=f,m=h,p=d,y=u+f,E=s+h,v=r+d,_=1;return o[0]=w,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=m,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=p,o[11]=0,o[12]=y,o[13]=E,o[14]=v,o[15]=_,o},l.toArray=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},l.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>3)throw new i("row must be 0, 1, 2, or 3.");if("number"!=typeof e||0>e||e>3)throw new i("column must be 0, 1, 2, or 3.");return 4*e+r},l.getColumn=function(e,r,t){if(!n(e))throw new i("matrix is required.");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(t))throw new i("result is required");var a=4*r,o=e[a],u=e[a+1],s=e[a+2],l=e[a+3];return t.x=o,t.y=u,t.z=s,t.w=l,t},l.setColumn=function(e,r,t,a){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(a))throw new i("result is required");a=l.clone(e,a);var o=4*r;return a[o]=t.x,a[o+1]=t.y,a[o+2]=t.z,a[o+3]=t.w,a},l.setTranslation=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("translation is required");if(!n(t))throw new i("result is required");return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=r.x,t[13]=r.y,t[14]=r.z,t[15]=e[15],t},l.getRow=function(e,r,t){if(!n(e))throw new i("matrix is required.");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(t))throw new i("result is required");var a=e[r],o=e[r+4],u=e[r+8],s=e[r+12];return t.x=a,t.y=o,t.z=u,t.w=s,t},l.setRow=function(e,r,t,a){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(a))throw new i("result is required");return a=l.clone(e,a),a[r]=t.x,a[r+4]=t.y,a[r+8]=t.z,a[r+12]=t.w,a};var d=new e;l.getScale=function(r,t){if(!n(r))throw new i("matrix is required.");if(!n(t))throw new i("result is required");return t.x=e.magnitude(e.fromElements(r[0],r[1],r[2],d)),t.y=e.magnitude(e.fromElements(r[4],r[5],r[6],d)),t.z=e.magnitude(e.fromElements(r[8],r[9],r[10],d)),t};var w=new e;l.getMaximumScale=function(r){return l.getScale(r,w),e.maximumComponent(w)},l.multiply=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");var a=e[0],o=e[1],u=e[2],s=e[3],l=e[4],c=e[5],f=e[6],h=e[7],d=e[8],w=e[9],m=e[10],p=e[11],y=e[12],E=e[13],v=e[14],_=e[15],T=r[0],g=r[1],R=r[2],A=r[3],S=r[4],N=r[5],I=r[6],O=r[7],q=r[8],x=r[9],M=r[10],b=r[11],P=r[12],C=r[13],D=r[14],L=r[15],U=a*T+l*g+d*R+y*A,F=o*T+c*g+w*R+E*A,z=u*T+f*g+m*R+v*A,B=s*T+h*g+p*R+_*A,G=a*S+l*N+d*I+y*O,W=o*S+c*N+w*I+E*O,H=u*S+f*N+m*I+v*O,V=s*S+h*N+p*I+_*O,X=a*q+l*x+d*M+y*b,Y=o*q+c*x+w*M+E*b,k=u*q+f*x+m*M+v*b,j=s*q+h*x+p*M+_*b,Z=a*P+l*C+d*D+y*L,K=o*P+c*C+w*D+E*L,J=u*P+f*C+m*D+v*L,Q=s*P+h*C+p*D+_*L;return t[0]=U,t[1]=F,t[2]=z,t[3]=B,t[4]=G,t[5]=W,t[6]=H,t[7]=V,t[8]=X,t[9]=Y,t[10]=k,t[11]=j,t[12]=Z,t[13]=K,t[14]=J,t[15]=Q,t},l.add=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t[6]=e[6]+r[6],t[7]=e[7]+r[7],t[8]=e[8]+r[8],t[9]=e[9]+r[9],t[10]=e[10]+r[10],t[11]=e[11]+r[11],t[12]=e[12]+r[12],t[13]=e[13]+r[13],t[14]=e[14]+r[14],t[15]=e[15]+r[15],t},l.subtract=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t[4]=e[4]-r[4],t[5]=e[5]-r[5],t[6]=e[6]-r[6],t[7]=e[7]-r[7],t[8]=e[8]-r[8],t[9]=e[9]-r[9],t[10]=e[10]-r[10],t[11]=e[11]-r[11],t[12]=e[12]-r[12],t[13]=e[13]-r[13],t[14]=e[14]-r[14],t[15]=e[15]-r[15],t},l.multiplyTransformation=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");var a=e[0],o=e[1],u=e[2],s=e[4],l=e[5],c=e[6],f=e[8],h=e[9],d=e[10],w=e[12],m=e[13],p=e[14],y=r[0],E=r[1],v=r[2],_=r[4],T=r[5],g=r[6],R=r[8],A=r[9],S=r[10],N=r[12],I=r[13],O=r[14],q=a*y+s*E+f*v,x=o*y+l*E+h*v,M=u*y+c*E+d*v,b=a*_+s*T+f*g,P=o*_+l*T+h*g,C=u*_+c*T+d*g,D=a*R+s*A+f*S,L=o*R+l*A+h*S,U=u*R+c*A+d*S,F=a*N+s*I+f*O+w,z=o*N+l*I+h*O+m,B=u*N+c*I+d*O+p;return t[0]=q,t[1]=x,t[2]=M,t[3]=0,t[4]=b,t[5]=P,t[6]=C,t[7]=0,t[8]=D,t[9]=L,t[10]=U,t[11]=0,t[12]=F,t[13]=z,t[14]=B,t[15]=1,t},l.multiplyByMatrix3=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("rotation is required");if(!n(t))throw new i("result is required");var a=e[0],o=e[1],u=e[2],s=e[4],l=e[5],c=e[6],f=e[8],h=e[9],d=e[10],w=r[0],m=r[1],p=r[2],y=r[3],E=r[4],v=r[5],_=r[6],T=r[7],g=r[8],R=a*w+s*m+f*p,A=o*w+l*m+h*p,S=u*w+c*m+d*p,N=a*y+s*E+f*v,I=o*y+l*E+h*v,O=u*y+c*E+d*v,q=a*_+s*T+f*g,x=o*_+l*T+h*g,M=u*_+c*T+d*g;return t[0]=R,t[1]=A,t[2]=S,t[3]=0,t[4]=N,t[5]=I,t[6]=O,t[7]=0,t[8]=q,t[9]=x,t[10]=M,t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},l.multiplyByTranslation=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("translation is required");if(!n(t))throw new i("result is required");var a=r.x,o=r.y,u=r.z,s=a*e[0]+o*e[4]+u*e[8]+e[12],l=a*e[1]+o*e[5]+u*e[9]+e[13],c=a*e[2]+o*e[6]+u*e[10]+e[14];return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=s,t[13]=l,t[14]=c,t[15]=e[15],t};var m=new e;l.multiplyByUniformScale=function(e,r,t){if(!n(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scale is required");if(!n(t))throw new i("result is required");return m.x=r,m.y=r,m.z=r,l.multiplyByScale(e,m,t)},l.multiplyByScale=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("scale is required");if(!n(t))throw new i("result is required");var a=r.x,o=r.y,u=r.z;return 1===a&&1===o&&1===u?l.clone(e,t):(t[0]=a*e[0],t[1]=a*e[1],t[2]=a*e[2],t[3]=0,t[4]=o*e[4],t[5]=o*e[5],t[6]=o*e[6],t[7]=0,t[8]=u*e[8],t[9]=u*e[9],t[10]=u*e[10],t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=1,t)},l.multiplyByVector=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if(!n(t))throw new i("result is required");var a=r.x,o=r.y,u=r.z,s=r.w,l=e[0]*a+e[4]*o+e[8]*u+e[12]*s,c=e[1]*a+e[5]*o+e[9]*u+e[13]*s,f=e[2]*a+e[6]*o+e[10]*u+e[14]*s,h=e[3]*a+e[7]*o+e[11]*u+e[15]*s;return t.x=l,t.y=c,t.z=f,t.w=h,t},l.multiplyByPointAsVector=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if(!n(t))throw new i("result is required");var a=r.x,o=r.y,u=r.z,s=e[0]*a+e[4]*o+e[8]*u,l=e[1]*a+e[5]*o+e[9]*u,c=e[2]*a+e[6]*o+e[10]*u;
return t.x=s,t.y=l,t.z=c,t},l.multiplyByPoint=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if(!n(t))throw new i("result is required");var a=r.x,o=r.y,u=r.z,s=e[0]*a+e[4]*o+e[8]*u+e[12],l=e[1]*a+e[5]*o+e[9]*u+e[13],c=e[2]*a+e[6]*o+e[10]*u+e[14];return t.x=s,t.y=l,t.z=c,t},l.multiplyByScalar=function(e,r,t){if(!n(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scalar must be a number");if(!n(t))throw new i("result is required");return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t},l.negate=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r[9]=-e[9],r[10]=-e[10],r[11]=-e[11],r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=-e[15],r},l.transpose=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");var t=e[1],a=e[2],o=e[3],u=e[6],s=e[7],l=e[11];return r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=t,r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=a,r[9]=u,r[10]=e[10],r[11]=e[14],r[12]=o,r[13]=s,r[14]=l,r[15]=e[15],r},l.abs=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r[9]=Math.abs(e[9]),r[10]=Math.abs(e[10]),r[11]=Math.abs(e[11]),r[12]=Math.abs(e[12]),r[13]=Math.abs(e[13]),r[14]=Math.abs(e[14]),r[15]=Math.abs(e[15]),r},l.equals=function(e,r){return e===r||n(e)&&n(r)&&e[12]===r[12]&&e[13]===r[13]&&e[14]===r[14]&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[8]===r[8]&&e[9]===r[9]&&e[10]===r[10]&&e[3]===r[3]&&e[7]===r[7]&&e[11]===r[11]&&e[15]===r[15]},l.equalsEpsilon=function(e,r,t){if("number"!=typeof t)throw new i("epsilon must be a number");return e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=t&&Math.abs(e[1]-r[1])<=t&&Math.abs(e[2]-r[2])<=t&&Math.abs(e[3]-r[3])<=t&&Math.abs(e[4]-r[4])<=t&&Math.abs(e[5]-r[5])<=t&&Math.abs(e[6]-r[6])<=t&&Math.abs(e[7]-r[7])<=t&&Math.abs(e[8]-r[8])<=t&&Math.abs(e[9]-r[9])<=t&&Math.abs(e[10]-r[10])<=t&&Math.abs(e[11]-r[11])<=t&&Math.abs(e[12]-r[12])<=t&&Math.abs(e[13]-r[13])<=t&&Math.abs(e[14]-r[14])<=t&&Math.abs(e[15]-r[15])<=t},l.getTranslation=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r.x=e[12],r.y=e[13],r.z=e[14],r},l.getRotation=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[4],r[4]=e[5],r[5]=e[6],r[6]=e[8],r[7]=e[9],r[8]=e[10],r};var p=new u,y=new u,E=new r,v=new r(0,0,0,1);return l.inverse=function(e,t){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("result is required");if(u.equalsEpsilon(l.getRotation(e,p),y,o.EPSILON7)&&r.equals(l.getRow(e,3,E),v))return t[0]=0,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=0,t[11]=0,t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=1,t;var a=e[0],c=e[4],f=e[8],h=e[12],d=e[1],w=e[5],m=e[9],_=e[13],T=e[2],g=e[6],R=e[10],A=e[14],S=e[3],N=e[7],I=e[11],O=e[15],q=R*O,x=A*I,M=g*O,b=A*N,P=g*I,C=R*N,D=T*O,L=A*S,U=T*I,F=R*S,z=T*N,B=g*S,G=q*w+b*m+P*_-(x*w+M*m+C*_),W=x*d+D*m+F*_-(q*d+L*m+U*_),H=M*d+L*w+z*_-(b*d+D*w+B*_),V=C*d+U*w+B*m-(P*d+F*w+z*m),X=x*c+M*f+C*h-(q*c+b*f+P*h),Y=q*a+L*f+U*h-(x*a+D*f+F*h),k=b*a+D*c+B*h-(M*a+L*c+z*h),j=P*a+F*c+z*f-(C*a+U*c+B*f);q=f*_,x=h*m,M=c*_,b=h*w,P=c*m,C=f*w,D=a*_,L=h*d,U=a*m,F=f*d,z=a*w,B=c*d;var Z=q*N+b*I+P*O-(x*N+M*I+C*O),K=x*S+D*I+F*O-(q*S+L*I+U*O),J=M*S+L*N+z*O-(b*S+D*N+B*O),Q=C*S+U*N+B*I-(P*S+F*N+z*I),$=M*R+C*A+x*g-(P*A+q*g+b*R),ee=U*A+q*T+L*R-(D*R+F*A+x*T),re=D*g+B*A+b*T-(z*A+M*T+L*g),te=z*R+P*T+F*g-(U*g+B*R+C*T),ne=a*G+c*W+f*H+h*V;if(Math.abs(ne)<o.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return ne=1/ne,t[0]=G*ne,t[1]=W*ne,t[2]=H*ne,t[3]=V*ne,t[4]=X*ne,t[5]=Y*ne,t[6]=k*ne,t[7]=j*ne,t[8]=Z*ne,t[9]=K*ne,t[10]=J*ne,t[11]=Q*ne,t[12]=$*ne,t[13]=ee*ne,t[14]=re*ne,t[15]=te*ne,t},l.inverseTransformation=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");var t=e[0],a=e[1],o=e[2],u=e[4],s=e[5],l=e[6],c=e[8],f=e[9],h=e[10],d=e[12],w=e[13],m=e[14],p=-t*d-a*w-o*m,y=-u*d-s*w-l*m,E=-c*d-f*w-h*m;return r[0]=t,r[1]=u,r[2]=c,r[3]=0,r[4]=a,r[5]=s,r[6]=f,r[7]=0,r[8]=o,r[9]=l,r[10]=h,r[11]=0,r[12]=p,r[13]=y,r[14]=E,r[15]=1,r},l.IDENTITY=a(new l(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),l.ZERO=a(new l(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN0ROW3=3,l.COLUMN1ROW0=4,l.COLUMN1ROW1=5,l.COLUMN1ROW2=6,l.COLUMN1ROW3=7,l.COLUMN2ROW0=8,l.COLUMN2ROW1=9,l.COLUMN2ROW2=10,l.COLUMN2ROW3=11,l.COLUMN3ROW0=12,l.COLUMN3ROW1=13,l.COLUMN3ROW2=14,l.COLUMN3ROW3=15,l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.equalsArray=function(e,r,t){return e[0]===r[t]&&e[1]===r[t+1]&&e[2]===r[t+2]&&e[3]===r[t+3]&&e[4]===r[t+4]&&e[5]===r[t+5]&&e[6]===r[t+6]&&e[7]===r[t+7]&&e[8]===r[t+8]&&e[9]===r[t+9]&&e[10]===r[t+10]&&e[11]===r[t+11]&&e[12]===r[t+12]&&e[13]===r[t+13]&&e[14]===r[t+14]&&e[15]===r[t+15]},l.prototype.equalsEpsilon=function(e,r){return l.equalsEpsilon(this,e,r)},l.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},l}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,r,t,n){"use strict";var i=function(n,i){if(!r(n))throw new t("normal is required.");if(!r(i))throw new t("distance is required.");this.normal=e.clone(n),this.distance=i};i.fromPointNormal=function(n,a,o){if(!r(n))throw new t("point is required.");if(!r(a))throw new t("normal is required.");var u=-e.dot(a,n);return r(o)?(e.clone(a,o.normal),o.distance=u,o):new i(a,u)};var a=new e;return i.fromCartesian4=function(n,o){if(!r(n))throw new t("coefficients is required.");var u=e.fromCartesian4(n,a),s=n.w;return r(o)?(e.clone(u,o.normal),o.distance=s,o):new i(u,s)},i.getPointDistance=function(n,i){if(!r(n))throw new t("plane is required.");if(!r(i))throw new t("point is required.");return e.dot(n.normal,i)+n.distance},i.ORIGIN_XY_PLANE=n(new i(e.UNIT_Z,0)),i.ORIGIN_YZ_PLANE=n(new i(e.UNIT_X,0)),i.ORIGIN_ZX_PLANE=n(new i(e.UNIT_Y,0)),i}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Plane","./Rectangle"],function(e,r,t,n,i,a,o,u,s,l,c,f,h){"use strict";var d=function(r,n){this.center=e.clone(t(r,e.ZERO)),this.radius=t(n,0)},w=new e,m=new e,p=new e,y=new e,E=new e,v=new e,_=new e,T=new e,g=new e,R=new e,A=new e,S=new e;d.fromPoints=function(r,t){if(n(t)||(t=new d),!n(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;for(var i=e.clone(r[0],_),a=e.clone(i,w),o=e.clone(i,m),u=e.clone(i,p),s=e.clone(i,y),l=e.clone(i,E),c=e.clone(i,v),f=r.length,h=1;f>h;h++){e.clone(r[h],i);var N=i.x,I=i.y,O=i.z;N<a.x&&e.clone(i,a),N>s.x&&e.clone(i,s),I<o.y&&e.clone(i,o),I>l.y&&e.clone(i,l),O<u.z&&e.clone(i,u),O>c.z&&e.clone(i,c)}var q=e.magnitudeSquared(e.subtract(s,a,T)),x=e.magnitudeSquared(e.subtract(l,o,T)),M=e.magnitudeSquared(e.subtract(c,u,T)),b=a,P=s,C=q;x>C&&(C=x,b=o,P=l),M>C&&(C=M,b=u,P=c);var D=g;D.x=.5*(b.x+P.x),D.y=.5*(b.y+P.y),D.z=.5*(b.z+P.z);var L=e.magnitudeSquared(e.subtract(P,D,T)),U=Math.sqrt(L),F=R;F.x=a.x,F.y=o.y,F.z=u.z;var z=A;z.x=s.x,z.y=l.y,z.z=c.z;var B=e.multiplyByScalar(e.add(F,z,T),.5,S),G=0;for(h=0;f>h;h++){e.clone(r[h],i);var W=e.magnitude(e.subtract(i,B,T));W>G&&(G=W);var H=e.magnitudeSquared(e.subtract(i,D,T));if(H>L){var V=Math.sqrt(H);U=.5*(U+V),L=U*U;var X=V-U;D.x=(U*D.x+X*i.x)/V,D.y=(U*D.y+X*i.y)/V,D.z=(U*D.z+X*i.z)/V}}return G>U?(e.clone(D,t.center),t.radius=U):(e.clone(B,t.center),t.radius=G),t};var N=new u,I=new e,O=new e,q=new r,x=new r;d.fromRectangle2D=function(e,r,t){return d.fromRectangleWithHeights2D(e,r,0,0,t)},d.fromRectangleWithHeights2D=function(r,i,a,o,u){if(n(u)||(u=new d),!n(r))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;i=t(i,N),h.southwest(r,q),q.height=a,h.northeast(r,x),x.height=o;var s=i.project(q,I),l=i.project(x,O),c=l.x-s.x,f=l.y-s.y,w=l.z-s.z;u.radius=.5*Math.sqrt(c*c+f*f+w*w);var m=u.center;return m.x=s.x+.5*c,m.y=s.y+.5*f,m.z=s.z+.5*w,u};var M=[];d.fromRectangle3D=function(e,r,i,a){r=t(r,o.WGS84),i=t(i,0);var u;return n(e)&&(u=h.subsample(e,r,i,M)),d.fromPoints(u,a)},d.fromVertices=function(r,i,o,u){if(n(u)||(u=new d),!n(r)||0===r.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;if(i=t(i,e.ZERO),o=t(o,3),3>o)throw new a("stride must be 3 or greater.");var s=_;s.x=r[0]+i.x,s.y=r[1]+i.y,s.z=r[2]+i.z;for(var l=e.clone(s,w),c=e.clone(s,m),f=e.clone(s,p),h=e.clone(s,y),N=e.clone(s,E),I=e.clone(s,v),O=r.length,q=0;O>q;q+=o){var x=r[q]+i.x,M=r[q+1]+i.y,b=r[q+2]+i.z;s.x=x,s.y=M,s.z=b,x<l.x&&e.clone(s,l),x>h.x&&e.clone(s,h),M<c.y&&e.clone(s,c),M>N.y&&e.clone(s,N),b<f.z&&e.clone(s,f),b>I.z&&e.clone(s,I)}var P=e.magnitudeSquared(e.subtract(h,l,T)),C=e.magnitudeSquared(e.subtract(N,c,T)),D=e.magnitudeSquared(e.subtract(I,f,T)),L=l,U=h,F=P;C>F&&(F=C,L=c,U=N),D>F&&(F=D,L=f,U=I);var z=g;z.x=.5*(L.x+U.x),z.y=.5*(L.y+U.y),z.z=.5*(L.z+U.z);var B=e.magnitudeSquared(e.subtract(U,z,T)),G=Math.sqrt(B),W=R;W.x=l.x,W.y=c.y,W.z=f.z;var H=A;H.x=h.x,H.y=N.y,H.z=I.z;var V=e.multiplyByScalar(e.add(W,H,T),.5,S),X=0;for(q=0;O>q;q+=o){s.x=r[q]+i.x,s.y=r[q+1]+i.y,s.z=r[q+2]+i.z;var Y=e.magnitude(e.subtract(s,V,T));Y>X&&(X=Y);var k=e.magnitudeSquared(e.subtract(s,z,T));if(k>B){var j=Math.sqrt(k);G=.5*(G+j),B=G*G;var Z=j-G;z.x=(G*z.x+Z*s.x)/j,z.y=(G*z.y+Z*s.y)/j,z.z=(G*z.z+Z*s.z)/j}}return X>G?(e.clone(z,u.center),u.radius=G):(e.clone(V,u.center),u.radius=X),u},d.fromCornerPoints=function(r,t,i){if(!n(r)||!n(t))throw new a("corner and oppositeCorner are required.");n(i)||(i=new d);var o=i.center;return e.add(r,t,o),e.multiplyByScalar(o,.5,o),i.radius=e.distance(o,t),i},d.fromEllipsoid=function(r,t){if(!n(r))throw new a("ellipsoid is required.");return n(t)||(t=new d),e.clone(e.ZERO,t.center),t.radius=r.maximumRadius,t};var b=new e;d.fromBoundingSpheres=function(r,t){if(n(t)||(t=new d),!n(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;var i=r.length;if(1===i)return d.clone(r[0],t);if(2===i)return d.union(r[0],r[1],t);for(var a=[],o=0;i>o;o++)a.push(r[o].center);t=d.fromPoints(a,t);var u=t.center,s=t.radius;for(o=0;i>o;o++){var l=r[o];s=Math.max(s,e.distance(u,l.center,b)+l.radius)}return t.radius=s,t},d.clone=function(r,t){return n(r)?n(t)?(t.center=e.clone(r.center,t.center),t.radius=r.radius,t):new d(r.center,r.radius):void 0},d.packedLength=4,d.pack=function(e,r,i){if(!n(e))throw new a("value is required");if(!n(r))throw new a("array is required");i=t(i,0);var o=e.center;r[i++]=o.x,r[i++]=o.y,r[i++]=o.z,r[i]=e.radius},d.unpack=function(e,r,i){if(!n(e))throw new a("array is required");r=t(r,0),n(i)||(i=new d);var o=i.center;return o.x=e[r++],o.y=e[r++],o.z=e[r++],i.radius=e[r],i};var P=new e,C=new e;d.union=function(r,t,i){if(!n(r))throw new a("left is required.");if(!n(t))throw new a("right is required.");n(i)||(i=new d);var o=r.center,u=r.radius,s=t.center,l=t.radius,c=e.subtract(s,o,P),f=e.magnitude(c);if(u>=f+l)return r.clone(i),i;if(l>=f+u)return t.clone(i),i;var h=.5*(u+f+l),w=e.multiplyByScalar(c,(-u+h)/f,C);return e.add(w,o,w),e.clone(w,i.center),i.radius=h,i};var D=new e;d.expand=function(r,t,i){if(!n(r))throw new a("sphere is required.");if(!n(t))throw new a("point is required.");i=d.clone(r,i);var o=e.magnitude(e.subtract(t,i.center,D));return o>i.radius&&(i.radius=o),i},d.intersectPlane=function(r,t){if(!n(r))throw new a("sphere is required.");if(!n(t))throw new a("plane is required.");var i=r.center,o=r.radius,u=t.normal,l=e.dot(u,i)+t.distance;return-o>l?s.OUTSIDE:o>l?s.INTERSECTING:s.INSIDE},d.transform=function(e,r,t){if(!n(e))throw new a("sphere is required.");if(!n(r))throw new a("transform is required.");return n(t)||(t=new d),t.center=c.multiplyByPoint(r,e.center,t.center),t.radius=c.getMaximumScale(r)*e.radius,t};var L=new e;d.distanceSquaredTo=function(r,t){if(!n(r))throw new a("sphere is required.");if(!n(t))throw new a("cartesian is required.");var i=e.subtract(r.center,t,L);return e.magnitudeSquared(i)-r.radius*r.radius},d.transformWithoutScale=function(e,r,t){if(!n(e))throw new a("sphere is required.");if(!n(r))throw new a("transform is required.");return n(t)||(t=new d),t.center=c.multiplyByPoint(r,e.center,t.center),t.radius=e.radius,t};var U=new e;d.computePlaneDistances=function(r,t,i,o){if(!n(r))throw new a("sphere is required.");if(!n(t))throw new a("position is required.");if(!n(i))throw new a("direction is required.");n(o)||(o=new l);var u=e.subtract(r.center,t,U),s=e.dot(i,u);return o.start=s-r.radius,o.stop=s+r.radius,o};for(var F=new e,z=new e,B=new e,G=new e,W=new e,H=new r,V=new Array(8),X=0;8>X;++X)V[X]=new e;var Y=new u;return d.projectTo2D=function(r,i,o){if(!n(r))throw new a("sphere is required.");i=t(i,Y);var u=i.ellipsoid,s=r.center,l=r.radius,c=u.geodeticSurfaceNormal(s,F),f=e.cross(e.UNIT_Z,c,z);e.normalize(f,f);var h=e.cross(c,f,B);e.normalize(h,h),e.multiplyByScalar(c,l,c),e.multiplyByScalar(h,l,h),e.multiplyByScalar(f,l,f);var w=e.negate(h,W),m=e.negate(f,G),p=V,y=p[0];e.add(c,h,y),e.add(y,f,y),y=p[1],e.add(c,h,y),e.add(y,m,y),y=p[2],e.add(c,w,y),e.add(y,m,y),y=p[3],e.add(c,w,y),e.add(y,f,y),e.negate(c,c),y=p[4],e.add(c,h,y),e.add(y,f,y),y=p[5],e.add(c,h,y),e.add(y,m,y),y=p[6],e.add(c,w,y),e.add(y,m,y),y=p[7],e.add(c,w,y),e.add(y,f,y);for(var E=p.length,v=0;E>v;++v){var _=p[v];e.add(s,_,_);var T=u.cartesianToCartographic(_,H);i.project(T,_)}o=d.fromPoints(p,o),s=o.center;var g=s.x,R=s.y,A=s.z;return s.x=A,s.y=g,s.z=R,o},d.isOccluded=function(e,r){if(!n(e))throw new a("sphere is required.");if(!n(r))throw new a("occluder is required.");return!r.isBoundingSphereVisible(e)},d.equals=function(r,t){return r===t||n(r)&&n(t)&&e.equals(r.center,t.center)&&r.radius===t.radius},d.prototype.intersectPlane=function(e){return d.intersectPlane(this,e)},d.prototype.distanceSquaredTo=function(e){return d.distanceSquaredTo(this,e)},d.prototype.computePlaneDistances=function(e,r,t){return d.computePlaneDistances(this,e,r,t)},d.prototype.isOccluded=function(e){return d.isOccluded(this,e)},d.prototype.equals=function(e){return d.equals(this,e)},d.prototype.clone=function(e){return d.clone(this,e)},d}),define("Renderer/WebGLConstants",["../Core/freezeObject"],function(e){"use strict";var r={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return e(r)}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,r){"use strict";var t,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return r(i,{element:{get:function(){return i.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(t))return t;t=!1;var r=document.body;if("function"==typeof r.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",t=!0;for(var i,a=["webkit","moz","o","ms","khtml"],o=0,u=a.length;u>o;++o){var s=a[o];i=s+"RequestFullscreen","function"==typeof r[i]?(n.requestFullscreen=i,t=!0):(i=s+"RequestFullScreen","function"==typeof r[i]&&(n.requestFullscreen=i,t=!0)),i=s+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=s+"FullscreenEnabled",e(document[i])?n.fullscreenEnabled=i:(i=s+"FullScreenEnabled",e(document[i])&&(n.fullscreenEnabled=i)),i=s+"FullscreenElement",e(document[i])?n.fullscreenElement=i:(i=s+"FullScreenElement",e(document[i])&&(n.fullscreenElement=i)),i=s+"fullscreenchange",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=s+"fullscreenerror",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenError"),n.fullscreenerror=i)}return t},i.requestFullscreen=function(e){i.supportsFullscreen()&&e[n.requestFullscreen]()},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,r,t){"use strict";function n(e){for(var r=e.split("."),t=0,n=r.length;n>t;++t)r[t]=parseInt(r[t],10);return r}function i(){if(!r(p)){p=!1;var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(p=!0,y=n(e[1]))}return p}function a(){return i()&&y}function o(){if(!r(E)&&(E=!1,!i()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(E=!0,v=n(e[1]))}return E}function u(){return o()&&v}function s(){if(!r(_)){_=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==e&&(_=!0,T=n(e[1]),T.isNightly=!!e[2])}return _}function l(){return s()&&T}function c(){if(!r(g)){g=!1;var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(g=!0,R=n(e[1]))):"Netscape"===navigator.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(g=!0,R=n(e[1])))}return g}function f(){return c()&&R}function h(){if(!r(A)){A=!1;var e=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(A=!0,S=n(e[1]))}return A}function d(){return r(N)||(N=/Windows/i.test(navigator.appVersion)),N}function w(){return h()&&S}function m(){return r(I)||(I=r(window.PointerEvent)&&(!r(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),I}var p,y,E,v,_,T,g,R,A,S,N,I,O={isChrome:i,chromeVersion:a,isSafari:o,safariVersion:u,isWebkit:s,webkitVersion:l,isInternetExplorer:c,internetExplorerVersion:f,isFirefox:h,firefoxVersion:w,isWindows:d,hardwareConcurrency:e(navigator.hardwareConcurrency,3),supportsPointerEvents:m};return O.supportsFullscreen=function(){return t.supportsFullscreen()},O.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},O.supportsWebWorkers=function(){return"undefined"!=typeof Worker},O}),define("Core/ComponentDatatype",["../Renderer/WebGLConstants","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,r,t,n,i,a){
"use strict";if(!i.supportsTypedArrays())return{};var o={BYTE:e.BYTE,UNSIGNED_BYTE:e.UNSIGNED_BYTE,SHORT:e.SHORT,UNSIGNED_SHORT:e.UNSIGNED_SHORT,FLOAT:e.FLOAT,DOUBLE:e.DOUBLE};return o.getSizeInBytes=function(e){if(!t(e))throw new n("value is required.");switch(e){case o.BYTE:return Int8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.SHORT:return Int16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case o.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new n("componentDatatype is not a valid value.")}},o.fromTypedArray=function(e){return e instanceof Int8Array?o.BYTE:e instanceof Uint8Array?o.UNSIGNED_BYTE:e instanceof Int16Array?o.SHORT:e instanceof Uint16Array?o.UNSIGNED_SHORT:e instanceof Float32Array?o.FLOAT:e instanceof Float64Array?o.DOUBLE:void 0},o.validate=function(e){return t(e)&&(e===o.BYTE||e===o.UNSIGNED_BYTE||e===o.SHORT||e===o.UNSIGNED_SHORT||e===o.FLOAT||e===o.DOUBLE)},o.createTypedArray=function(e,r){if(!t(e))throw new n("componentDatatype is required.");if(!t(r))throw new n("valuesOrLength is required.");switch(e){case o.BYTE:return new Int8Array(r);case o.UNSIGNED_BYTE:return new Uint8Array(r);case o.SHORT:return new Int16Array(r);case o.UNSIGNED_SHORT:return new Uint16Array(r);case o.FLOAT:return new Float32Array(r);case o.DOUBLE:return new Float64Array(r);default:throw new n("componentDatatype is not a valid value.")}},o.createArrayBufferView=function(e,i,a,u){if(!t(e))throw new n("componentDatatype is required.");if(!t(i))throw new n("buffer is required.");switch(a=r(a,0),u=r(u,(i.byteLength-a)/o.getSizeInBytes(e)),e){case o.BYTE:return new Int8Array(i,a,u);case o.UNSIGNED_BYTE:return new Uint8Array(i,a,u);case o.SHORT:return new Int16Array(i,a,u);case o.UNSIGNED_SHORT:return new Uint16Array(i,a,u);case o.FLOAT:return new Float32Array(i,a,u);case o.DOUBLE:return new Float64Array(i,a,u);default:throw new n("componentDatatype is not a valid value.")}},a(o)}),define("Core/AxisAlignedBoundingBox",["./Cartesian3","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Intersect","./Plane"],function(e,r,t,n,i,a,o){"use strict";var u=function(n,i,a){this.minimum=e.clone(r(n,e.ZERO)),this.maximum=e.clone(r(i,e.ZERO)),t(a)?a=e.clone(a):(a=e.add(this.minimum,this.maximum,new e),e.multiplyByScalar(a,.5,a)),this.center=a};u.fromPoints=function(r,n){if(t(n)||(n=new u),!t(r)||0===r.length)return n.minimum=e.clone(e.ZERO,n.minimum),n.maximum=e.clone(e.ZERO,n.maximum),n.center=e.clone(e.ZERO,n.center),n;for(var i=r[0].x,a=r[0].y,o=r[0].z,s=r[0].x,l=r[0].y,c=r[0].z,f=r.length,h=1;f>h;h++){var d=r[h],w=d.x,m=d.y,p=d.z;i=Math.min(w,i),s=Math.max(w,s),a=Math.min(m,a),l=Math.max(m,l),o=Math.min(p,o),c=Math.max(p,c)}var y=n.minimum;y.x=i,y.y=a,y.z=o;var E=n.maximum;E.x=s,E.y=l,E.z=c;var v=e.add(y,E,n.center);return e.multiplyByScalar(v,.5,v),n},u.clone=function(r,n){return t(r)?t(n)?(n.minimum=e.clone(r.minimum,n.minimum),n.maximum=e.clone(r.maximum,n.maximum),n.center=e.clone(r.center,n.center),n):new u(r.minimum,r.maximum):void 0},u.equals=function(r,n){return r===n||t(r)&&t(n)&&e.equals(r.center,n.center)&&e.equals(r.minimum,n.minimum)&&e.equals(r.maximum,n.maximum)};var s=new e;return u.intersectPlane=function(r,n){if(!t(r))throw new i("box is required.");if(!t(n))throw new i("plane is required.");s=e.subtract(r.maximum,r.minimum,s);var o=e.multiplyByScalar(s,.5,s),u=n.normal,l=o.x*Math.abs(u.x)+o.y*Math.abs(u.y)+o.z*Math.abs(u.z),c=e.dot(r.center,u)+n.distance;return c-l>0?a.INSIDE:0>c+l?a.OUTSIDE:a.INTERSECTING},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.intersectPlane=function(e){return u.intersectPlane(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,r){"use strict";function t(e,t,n){var i=e+t;return r.sign(e)!==r.sign(t)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(t)))<n?0:i}var n={};return n.computeDiscriminant=function(r,t,n){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");var i=t*t-4*r*n;return i},n.computeRealRoots=function(n,i,a){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");var o;if(0===n)return 0===i?[]:[-a/i];if(0===i){if(0===a)return[0,0];var u=Math.abs(a),s=Math.abs(n);if(s>u&&u/s<r.EPSILON14)return[0,0];if(u>s&&s/u<r.EPSILON14)return[];if(o=-a/n,0>o)return[];var l=Math.sqrt(o);return[-l,l]}if(0===a)return o=-i/n,0>o?[o,0]:[0,o];var c=i*i,f=4*n*a,h=t(c,-f,r.EPSILON14);if(0>h)return[];var d=-.5*t(i,r.sign(i)*Math.sqrt(h),r.EPSILON14);return i>0?[d/n,a/d]:[a/d,d/n]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,r){"use strict";function t(e,r,t,n){var i,a,o=e,u=r/3,s=t/3,l=n,c=o*s,f=u*l,h=u*u,d=s*s,w=o*s-h,m=o*l-u*s,p=u*l-d,y=4*w*p-m*m;if(0>y){var E,v,_;h*f>=c*d?(E=o,v=w,_=-2*u*w+o*m):(E=l,v=p,_=-l*m+2*s*p);var T=0>_?-1:1,g=-T*Math.abs(E)*Math.sqrt(-y);a=-_+g;var R=a/2,A=0>R?-Math.pow(-R,1/3):Math.pow(R,1/3),S=a===g?-A:-v/A;return i=0>=v?A+S:-_/(A*A+S*S+v),h*f>=c*d?[(i-u)/o]:[-l/(i+s)]}var N=w,I=-2*u*w+o*m,O=p,q=-l*m+2*s*p,x=Math.sqrt(y),M=Math.sqrt(3)/2,b=Math.abs(Math.atan2(o*x,-I)/3);i=2*Math.sqrt(-N);var P=Math.cos(b);a=i*P;var C=i*(-P/2-M*Math.sin(b)),D=a+C>2*u?a-u:C-u,L=o,U=D/L;b=Math.abs(Math.atan2(l*x,-q)/3),i=2*Math.sqrt(-O),P=Math.cos(b),a=i*P,C=i*(-P/2-M*Math.sin(b));var F=-l,z=2*s>a+C?a+s:C+s,B=F/z,G=L*z,W=-D*z-L*F,H=D*F,V=(s*W-u*H)/(-u*W+s*G);return V>=U?B>=U?B>=V?[U,V,B]:[U,B,V]:[B,U,V]:B>=U?[V,U,B]:B>=V?[V,B,U]:[B,V,U]}var n={};return n.computeDiscriminant=function(r,t,n,i){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var a=r*r,o=t*t,u=n*n,s=i*i,l=18*r*t*n*i+o*u-27*a*s-4*(r*u*n+o*t*i);return l},n.computeRealRoots=function(n,i,a,o){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof a)throw new e("c is a required number.");if("number"!=typeof o)throw new e("d is a required number.");var u,s;if(0===n)return r.computeRealRoots(i,a,o);if(0===i){if(0===a){if(0===o)return[0,0,0];s=-o/n;var l=0>s?-Math.pow(-s,1/3):Math.pow(s,1/3);return[l,l,l]}return 0===o?(u=r.computeRealRoots(n,0,a),0===u.Length?[0]:[u[0],0,u[1]]):t(n,0,a,o)}return 0===a?0===o?(s=-i/n,0>s?[s,0,0]:[0,0,s]):t(n,i,0,o):0===o?(u=r.computeRealRoots(n,i,a),0===u.length?[0]:u[1]<=0?[u[0],u[1],0]:u[0]>=0?[0,u[0],u[1]]:[u[0],0,u[1]]):t(n,i,a,o)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,r,t,n){"use strict";function i(r,i,a,o){var u=r*r,s=i-3*u/8,l=a-i*r/2+u*r/8,c=o-a*r/4+i*u/16-3*u*u/256,f=e.computeRealRoots(1,2*s,s*s-4*c,-l*l);if(f.length>0){var h=-r/4,d=f[f.length-1];if(Math.abs(d)<t.EPSILON14){var w=n.computeRealRoots(1,s,c);if(2===w.length){var m,p=w[0],y=w[1];if(p>=0&&y>=0){var E=Math.sqrt(p),v=Math.sqrt(y);return[h-v,h-E,h+E,h+v]}if(p>=0&&0>y)return m=Math.sqrt(p),[h-m,h+m];if(0>p&&y>=0)return m=Math.sqrt(y),[h-m,h+m]}return[]}if(d>0){var _=Math.sqrt(d),T=(s+d-l/_)/2,g=(s+d+l/_)/2,R=n.computeRealRoots(1,_,T),A=n.computeRealRoots(1,-_,g);return 0!==R.length?(R[0]+=h,R[1]+=h,0!==A.length?(A[0]+=h,A[1]+=h,R[1]<=A[0]?[R[0],R[1],A[0],A[1]]:A[1]<=R[0]?[A[0],A[1],R[0],R[1]]:R[0]>=A[0]&&R[1]<=A[1]?[A[0],R[0],R[1],A[1]]:A[0]>=R[0]&&A[1]<=R[1]?[R[0],A[0],A[1],R[1]]:R[0]>A[0]&&R[0]<A[1]?[A[0],R[0],A[1],R[1]]:[R[0],A[0],R[1],A[1]]):R):0!==A.length?(A[0]+=h,A[1]+=h,A):[]}}return[]}function a(r,i,a,o){var u=a*a,s=i*i,l=r*r,c=-2*i,f=a*r+s-4*o,h=l*o-a*i*r+u,d=e.computeRealRoots(1,c,f,h);if(d.length>0){var w,m,p=d[0],y=i-p,E=y*y,v=r/2,_=y/2,T=E-4*o,g=E+4*Math.abs(o),R=l-4*p,A=l+4*Math.abs(p);if(0>p||R*g>T*A){var S=Math.sqrt(R);w=S/2,m=0===S?0:(r*_-a)/S}else{var N=Math.sqrt(T);w=0===N?0:(r*_-a)/N,m=N/2}var I,O;0===v&&0===w?(I=0,O=0):t.sign(v)===t.sign(w)?(I=v+w,O=p/I):(O=v-w,I=p/O);var q,x;0===_&&0===m?(q=0,x=0):t.sign(_)===t.sign(m)?(q=_+m,x=o/q):(x=_-m,q=o/x);var M=n.computeRealRoots(1,I,q),b=n.computeRealRoots(1,O,x);if(0!==M.length)return 0!==b.length?M[1]<=b[0]?[M[0],M[1],b[0],b[1]]:b[1]<=M[0]?[b[0],b[1],M[0],M[1]]:M[0]>=b[0]&&M[1]<=b[1]?[b[0],M[0],M[1],b[1]]:b[0]>=M[0]&&b[1]<=M[1]?[M[0],b[0],b[1],M[1]]:M[0]>b[0]&&M[0]<b[1]?[b[0],M[0],b[1],M[1]]:[M[0],b[0],M[1],b[1]]:M;if(0!==b.length)return b}return[]}var o={};return o.computeDiscriminant=function(e,t,n,i,a){if("number"!=typeof e)throw new r("a is a required number.");if("number"!=typeof t)throw new r("b is a required number.");if("number"!=typeof n)throw new r("c is a required number.");if("number"!=typeof i)throw new r("d is a required number.");if("number"!=typeof a)throw new r("e is a required number.");var o=e*e,u=o*e,s=t*t,l=s*t,c=n*n,f=c*n,h=i*i,d=h*i,w=a*a,m=w*a,p=s*c*h-4*l*d-4*e*f*h+18*e*t*n*d-27*o*h*h+256*u*m+a*(18*l*n*i-4*s*f+16*e*c*c-80*e*t*c*i-6*e*s*h+144*o*n*h)+w*(144*e*s*n-27*s*s-128*o*c-192*o*t*i);return p},o.computeRealRoots=function(n,o,u,s,l){if("number"!=typeof n)throw new r("a is a required number.");if("number"!=typeof o)throw new r("b is a required number.");if("number"!=typeof u)throw new r("c is a required number.");if("number"!=typeof s)throw new r("d is a required number.");if("number"!=typeof l)throw new r("e is a required number.");if(Math.abs(n)<t.EPSILON15)return e.computeRealRoots(o,u,s,l);var c=o/n,f=u/n,h=s/n,d=l/n,w=0>c?1:0;switch(w+=0>f?w+1:w,w+=0>h?w+1:w,w+=0>d?w+1:w){case 0:return i(c,f,h,d);case 1:return a(c,f,h,d);case 2:return a(c,f,h,d);case 3:return i(c,f,h,d);case 4:return i(c,f,h,d);case 5:return a(c,f,h,d);case 6:return i(c,f,h,d);case 7:return i(c,f,h,d);case 8:return a(c,f,h,d);case 9:return i(c,f,h,d);case 10:return i(c,f,h,d);case 11:return a(c,f,h,d);case 12:return i(c,f,h,d);case 13:return i(c,f,h,d);case 14:return i(c,f,h,d);case 15:return i(c,f,h,d);default:return void 0}},o}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i=function(t,n){n=e.clone(r(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(r(t,e.ZERO)),this.direction=n};return i.getPoint=function(r,i,a){if(!t(r))throw new n("ray is requred");if("number"!=typeof i)throw new n("t is a required number");return t(a)||(a=new e),a=e.multiplyByScalar(r.direction,i,a),e.add(r.origin,a,a)},i}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,r,t,n,i,a,o,u,s,l){"use strict";function c(r,o,u,s,l){if(!n(r))throw new i("ray is required.");if(!n(o))throw new i("p0 is required.");if(!n(u))throw new i("p1 is required.");if(!n(s))throw new i("p2 is required.");l=t(l,!1);var c,f,h,d,w,m=r.origin,T=r.direction,g=e.subtract(u,o,p),R=e.subtract(s,o,y),A=e.cross(T,R,E),S=e.dot(g,A);if(l){if(S<a.EPSILON6)return void 0;if(c=e.subtract(m,o,v),h=e.dot(c,A),0>h||h>S)return void 0;if(f=e.cross(c,g,_),d=e.dot(T,f),0>d||h+d>S)return void 0;w=e.dot(R,f)/S}else{if(Math.abs(S)<a.EPSILON6)return void 0;var N=1/S;if(c=e.subtract(m,o,v),h=e.dot(c,A)*N,0>h||h>1)return void 0;if(f=e.cross(c,g,_),d=e.dot(T,f)*N,0>d||h+d>1)return void 0;w=e.dot(R,f)*N}return w}function f(e,r,t,n){var i=r*r-4*e*t;if(0>i)return void 0;if(i>0){var a=1/(2*e),o=Math.sqrt(i),u=(-r+o)*a,s=(-r-o)*a;return s>u?(n.root0=u,n.root1=s):(n.root0=s,n.root1=u),n}var l=-r/(2*e);return 0===l?void 0:(n.root0=n.root1=l,n)}function h(r,t,i){n(i)||(i={});var a=r.origin,o=r.direction,u=t.center,s=t.radius*t.radius,l=e.subtract(a,u,E),c=e.dot(o,o),h=2*e.dot(o,l),d=e.magnitudeSquared(l)-s,w=f(c,h,d,g);return n(w)?(i.start=w.root0,i.stop=w.root1,i):void 0}function d(e,r,t){var n=e+r;return a.sign(e)!==a.sign(r)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(r)))<t?0:n}function w(r,t,n,i,l){var c,f=i*i,h=l*l,w=(r[o.COLUMN1ROW1]-r[o.COLUMN2ROW2])*h,m=l*(i*d(r[o.COLUMN1ROW0],r[o.COLUMN0ROW1],a.EPSILON15)+t.y),p=r[o.COLUMN0ROW0]*f+r[o.COLUMN2ROW2]*h+i*t.x+n,y=h*d(r[o.COLUMN2ROW1],r[o.COLUMN1ROW2],a.EPSILON15),E=l*(i*d(r[o.COLUMN2ROW0],r[o.COLUMN0ROW2])+t.z),v=[];if(0===E&&0===y){if(c=u.computeRealRoots(w,m,p),0===c.length)return v;var _=c[0],T=Math.sqrt(Math.max(1-_*_,0));if(v.push(new e(i,l*_,l*-T)),v.push(new e(i,l*_,l*T)),2===c.length){var g=c[1],R=Math.sqrt(Math.max(1-g*g,0));v.push(new e(i,l*g,l*-R)),v.push(new e(i,l*g,l*R))}return v}var A=E*E,S=y*y,N=w*w,I=E*y,O=N+S,q=2*(m*w+I),x=2*p*w+m*m-S+A,M=2*(p*m-I),b=p*p-A;if(0===O&&0===q&&0===x&&0===M)return v;c=s.computeRealRoots(O,q,x,M,b);var P=c.length;if(0===P)return v;for(var C=0;P>C;++C){var D,L=c[C],U=L*L,F=Math.max(1-U,0),z=Math.sqrt(F);D=a.sign(w)===a.sign(p)?d(w*U+p,m*L,a.EPSILON12):a.sign(p)===a.sign(m*L)?d(w*U,m*L+p,a.EPSILON12):d(w*U+m*L,p,a.EPSILON12);var B=d(y*L,E,a.EPSILON15),G=D*B;0>G?v.push(new e(i,l*L,l*z)):G>0?v.push(new e(i,l*L,l*-z)):0!==z?(v.push(new e(i,l*L,l*-z)),v.push(new e(i,l*L,l*z)),++C):v.push(new e(i,l*L,l*z))}return v}var m={};m.rayPlane=function(r,t,o){if(!n(r))throw new i("ray is required.");if(!n(t))throw new i("plane is required.");n(o)||(o=new e);var u=r.origin,s=r.direction,l=t.normal,c=e.dot(l,s);if(Math.abs(c)<a.EPSILON15)return void 0;var f=(-t.distance-e.dot(l,u))/c;return 0>f?void 0:(o=e.multiplyByScalar(s,f,o),e.add(u,o,o))};var p=new e,y=new e,E=new e,v=new e,_=new e;m.rayTriangle=function(r,t,i,a,o,u){var s=c(r,t,i,a,o);return!n(s)||0>s?void 0:(n(u)||(u=new e),e.multiplyByScalar(r.direction,s,u),e.add(r.origin,u,u))};var T=new l;m.lineSegmentTriangle=function(r,t,a,o,u,s,l){if(!n(r))throw new i("v0 is required.");if(!n(t))throw new i("v1 is required.");var f=T;e.clone(r,f.origin),e.subtract(t,r,f.direction),e.normalize(f.direction,f.direction);var h=c(f,a,o,u,s);return!n(h)||0>h||h>e.distance(r,t)?void 0:(n(l)||(l=new e),e.multiplyByScalar(f.direction,h,l),e.add(f.origin,l,l))};var g={root0:0,root1:0};m.raySphere=function(e,r,t){if(!n(e))throw new i("ray is required.");if(!n(r))throw new i("sphere is required.");return t=h(e,r,t),!n(t)||t.stop<0?void 0:(t.start=Math.max(t.start,0),t)};var R=new l;m.lineSegmentSphere=function(r,t,a,o){if(!n(r))throw new i("p0 is required.");if(!n(t))throw new i("p1 is required.");if(!n(a))throw new i("sphere is required.");var u=R,s=(e.clone(r,u.origin),e.subtract(t,r,u.direction)),l=e.magnitude(s);return e.normalize(s,s),o=h(u,a,o),!n(o)||o.stop<0||o.start>l?void 0:(o.start=Math.max(o.start,0),o.stop=Math.min(o.stop,l),o)};var A=new e,S=new e;m.rayEllipsoid=function(r,t){if(!n(r))throw new i("ray is required.");if(!n(t))throw new i("ellipsoid is required.");var a,o,u,s,l,c=t.oneOverRadii,f=e.multiplyComponents(c,r.origin,A),h=e.multiplyComponents(c,r.direction,S),d=e.magnitudeSquared(f),w=e.dot(f,h);if(d>1){if(w>=0)return void 0;var m=w*w;if(a=d-1,o=e.magnitudeSquared(h),u=o*a,u>m)return void 0;if(m>u){s=w*w-u,l=-w+Math.sqrt(s);var p=l/o,y=a/l;return y>p?{start:p,stop:y}:{start:y,stop:p}}var E=Math.sqrt(a/o);return{start:E,stop:E}}return 1>d?(a=d-1,o=e.magnitudeSquared(h),u=o*a,s=w*w-u,l=-w+Math.sqrt(s),{start:0,stop:l/o}):0>w?(o=e.magnitudeSquared(h),{start:0,stop:-w/o}):void 0};var N=new e,I=new e,O=new e,q=new e,x=new e,M=new o,b=new o,P=new o,C=new o,D=new o,L=new o,U=new o,F=new e,z=new e,B=new r;m.grazingAltitudeLocation=function(r,t){if(!n(r))throw new i("ray is required.");if(!n(t))throw new i("ellipsoid is required.");var u=r.origin,s=r.direction,l=t.geodeticSurfaceNormal(u,N);if(e.dot(s,l)>=0)return u;var c=n(this.rayEllipsoid(r,t)),f=t.transformPositionToScaledSpace(s,N),h=e.normalize(f,f),d=e.mostOrthogonalAxis(f,q),m=e.normalize(e.cross(d,h,I),I),p=e.normalize(e.cross(h,m,O),O),y=M;y[0]=h.x,y[1]=h.y,y[2]=h.z,y[3]=m.x,y[4]=m.y,y[5]=m.z,y[6]=p.x,y[7]=p.y,y[8]=p.z;var E=o.transpose(y,b),v=o.fromScale(t.radii,P),_=o.fromScale(t.oneOverRadii,C),T=D;T[0]=0,T[1]=-s.z,T[2]=s.y,T[3]=s.z,T[4]=0,T[5]=-s.x,T[6]=-s.y,T[7]=s.x,T[8]=0;var g,R,A=o.multiply(o.multiply(E,_,L),T,L),S=o.multiply(o.multiply(A,v,U),y,U),G=o.multiplyByVector(A,u,x),W=w(S,e.negate(G,N),0,0,1),H=W.length;if(H>0){for(var V=e.clone(e.ZERO,z),X=Number.NEGATIVE_INFINITY,Y=0;H>Y;++Y){g=o.multiplyByVector(v,o.multiplyByVector(y,W[Y],F),F);var k=e.normalize(e.subtract(g,u,q),q),j=e.dot(k,s);j>X&&(X=j,V=e.clone(g,V))}var Z=t.cartesianToCartographic(V,B);return X=a.clamp(X,0,1),R=e.magnitude(e.subtract(V,u,q))*Math.sqrt(1-X*X),R=c?-R:R,Z.height=R,t.cartographicToCartesian(Z,new e)}return void 0};var G=new e;return m.lineSegmentPlane=function(r,t,o,u){if(!n(r))throw new i("endPoint0 is required.");if(!n(t))throw new i("endPoint1 is required.");if(!n(o))throw new i("plane is required.");n(u)||(u=new e);var s=e.subtract(t,r,G),l=o.normal,c=e.dot(l,s);if(Math.abs(c)<a.EPSILON6)return void 0;var f=e.dot(l,r),h=-(o.distance+f)/c;return 0>h||h>1?void 0:(e.multiplyByScalar(s,h,u),e.add(r,u,u),u)},m.trianglePlaneIntersection=function(r,t,a,o){if(!(n(r)&&n(t)&&n(a)&&n(o)))throw new i("p0, p1, p2, and plane are required.");var u=o.normal,s=o.distance,l=e.dot(u,r)+s<0,c=e.dot(u,t)+s<0,f=e.dot(u,a)+s<0,h=0;h+=l?1:0,h+=c?1:0,h+=f?1:0;var d,w;if((1===h||2===h)&&(d=new e,w=new e),1===h){if(l)return m.lineSegmentPlane(r,t,o,d),m.lineSegmentPlane(r,a,o,w),{positions:[r,t,a,d,w],indices:[0,3,4,1,2,4,1,4,3]};if(c)return m.lineSegmentPlane(t,a,o,d),m.lineSegmentPlane(t,r,o,w),{positions:[r,t,a,d,w],indices:[1,3,4,2,0,4,2,4,3]};if(f)return m.lineSegmentPlane(a,r,o,d),m.lineSegmentPlane(a,t,o,w),{positions:[r,t,a,d,w],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===h){if(!l)return m.lineSegmentPlane(t,r,o,d),m.lineSegmentPlane(a,r,o,w),{positions:[r,t,a,d,w],indices:[1,2,4,1,4,3,0,3,4]};if(!c)return m.lineSegmentPlane(a,t,o,d),m.lineSegmentPlane(r,t,o,w),{positions:[r,t,a,d,w],indices:[2,0,4,2,4,3,1,3,4]};if(!f)return m.lineSegmentPlane(r,a,o,d),m.lineSegmentPlane(t,a,o,w),{positions:[r,t,a,d,w],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},m}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,t,n,i){return r(e).then(t,n,i)}function r(e){var r,t;return e instanceof n?r=e:u(e)?(t=o(),e.then(function(e){t.resolve(e)},function(e){t.reject(e)},function(e){t.progress(e)}),r=t.promise):r=i(e),r}function t(r){return e(r,a)}function n(e){this.then=e}function i(e){var t=new n(function(t){try{return r(t?t(e):e)}catch(n){return a(n)}});return t}function a(e){var t=new n(function(t,n){try{return n?r(n(e)):a(e)}catch(i){return a(i)}});return t}function o(){function e(e,r,t){return h(e,r,t)}function t(e){return w(e)}function i(e){return w(a(e))}function u(e){return d(e)}var s,l,c,f,h,d,w;return l=new n(e),s={then:e,resolve:t,reject:i,progress:u,promise:l,resolver:{resolve:t,reject:i,progress:u}},c=[],f=[],h=function(e,r,t){var n,i;return n=o(),i="function"==typeof t?function(e){try{n.progress(t(e))}catch(r){n.progress(r)}}:function(e){n.progress(e)},c.push(function(t){t.then(e,r).then(n.resolve,n.reject,i)}),f.push(i),n.promise},d=function(e){return m(f,e),e},w=function(e){return e=r(e),h=e.then,w=r,d=y,m(c,e),f=c=T,e},s}function u(e){return e&&"function"==typeof e.then}function s(r,t,n,i,a){return p(2,arguments),e(r,function(r){function u(e){m(e)}function s(e){w(e)}var l,c,f,h,d,w,m,p,E,v;if(E=r.length>>>0,l=Math.max(0,Math.min(t,E)),f=[],c=E-l+1,h=[],d=o(),l)for(p=d.progress,m=function(e){h.push(e),--c||(w=m=y,d.reject(h))},w=function(e){f.push(e),--l||(w=m=y,d.resolve(f))},v=0;E>v;++v)v in r&&e(r[v],s,u,p);else d.resolve(f);return d.then(n,i,a)})}function l(e,r,t,n){function i(e){return r?r(e[0]):e[0]}return s(e,1,i,t,n)}function c(e,r,t,n){return p(1,arguments),h(e,E).then(r,t,n)}function f(){return h(arguments,E)}function h(r,t){return e(r,function(r){var n,i,a,u,s,l;if(a=i=r.length>>>0,n=[],l=o(),a)for(u=function(r,i){e(r,t).then(function(e){n[i]=e,--a||l.resolve(n)},l.reject)},s=0;i>s;s++)s in r?u(r[s],s):--a;else l.resolve(n);return l.promise})}function d(r,t){var n=_.call(arguments,1);return e(r,function(r){var i;return i=r.length,n[0]=function(r,n,a){return e(r,function(r){return e(n,function(e){return t(r,e,a,i)})})},v.apply(r,n)})}function w(r,t,n){var i=arguments.length>2;return e(r,function(e){return e=i?n:e,t.resolve(e),e},function(e){return t.reject(e),a(e)},t.progress)}function m(e,r){for(var t,n=0;t=e[n++];)t(r)}function p(e,r){for(var t,n=r.length;n>e;)if(t=r[--n],null!=t&&"function"!=typeof t)throw new Error("arg "+n+" must be a function")}function y(){}function E(e){return e}var v,_,T;return e.defer=o,e.resolve=r,e.reject=t,e.join=f,e.all=c,e.map=h,e.reduce=d,e.any=l,e.some=s,e.chain=w,e.isPromise=u,n.prototype={always:function(e,r){return this.then(e,e,r)},otherwise:function(e){return this.then(T,e)},"yield":function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(r){return c(r,function(r){return e.apply(T,r)})})}},_=[].slice,v=[].reduce||function(e){var r,t,n,i,a;if(a=0,r=Object(this),i=r.length>>>0,t=arguments,t.length<=1)for(;;){if(a in r){n=r[a++];break}if(++a>=i)throw new TypeError}else n=t[1];for(;i>a;++a)a in r&&(n=e(n,r[a],a,r));return n},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/binarySearch",["./defined","./DeveloperError"],function(e,r){"use strict";var t=function(t,n,i){if(!e(t))throw new r("array is required.");if(!e(n))throw new r("itemToFind is required.");if(!e(i))throw new r("comparator is required.");for(var a,o,u=0,s=t.length-1;s>=u;)if(a=~~((u+s)/2),o=i(t[a],n),0>o)u=a+1;else{if(!(o>0))return a;s=a-1}return~(s+1)};return t}),define("Core/EarthOrientationParametersSample",[],function(){"use strict";var e=function(e,r,t,n,i){this.xPoleWander=e,this.yPoleWander=r,this.xPoleOffset=t,this.yPoleOffset=n,this.ut1MinusUtc=i};return e}),define("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,r=arguments,t=0,n=r[t++],i=function(e,r,t,n){t||(t=" ");var i=e.length>=r?"":Array(1+r-e.length>>>0).join(t);return n?e+i:i+e},a=function(e,r,t,n,a,o){var u=n-e.length;return u>0&&(e=t||!a?i(e,n,o,t):e.slice(0,r.length)+i("",u,"0",!0)+e.slice(r.length)),e},o=function(e,r,t,n,o,u,s){var l=e>>>0;return t=t&&l&&{2:"0b",8:"0",16:"0x"}[r]||"",e=t+i(l.toString(r),u||0,"0",!1),a(e,t,n,o,s)},u=function(e,r,t,n,i,o){return null!=n&&(e=e.slice(0,n)),a(e,"",r,t,i,o)},s=function(e,n,s,l,c,f,h){var d,w,m,p,y;if("%%"==e)return"%";for(var E=!1,v="",_=!1,T=!1,g=" ",R=s.length,A=0;s&&R>A;A++)switch(s.charAt(A)){case" ":v=" ";break;case"+":v="+";break;case"-":E=!0;break;case"'":g=s.charAt(A+1);break;case"0":_=!0;break;case"#":T=!0}if(l=l?"*"==l?+r[t++]:"*"==l.charAt(0)?+r[l.slice(1,-1)]:+l:0,0>l&&(l=-l,E=!0),!isFinite(l))throw new Error("sprintf: (minimum-)width must be finite");switch(f=f?"*"==f?+r[t++]:"*"==f.charAt(0)?+r[f.slice(1,-1)]:+f:"fFeE".indexOf(h)>-1?6:"d"==h?0:void 0,y=n?r[n.slice(0,-1)]:r[t++],h){case"s":return u(String(y),E,l,f,_,g);case"c":return u(String.fromCharCode(+y),E,l,f,_);case"b":return o(y,2,T,E,l,f,_);case"o":return o(y,8,T,E,l,f,_);case"x":return o(y,16,T,E,l,f,_);case"X":return o(y,16,T,E,l,f,_).toUpperCase();case"u":return o(y,10,T,E,l,f,_);case"i":case"d":return d=+y||0,d=Math.round(d-d%1),w=0>d?"-":v,y=w+i(String(Math.abs(d)),f,"0",!1),a(y,w,E,l,_);case"e":case"E":case"f":case"F":case"g":case"G":return d=+y,w=0>d?"-":v,m=["toExponential","toFixed","toPrecision"]["efg".indexOf(h.toLowerCase())],p=["toString","toUpperCase"]["eEfFgG".indexOf(h)%2],y=w+Math.abs(d)[m](f),a(y,w,E,l,_)[p]();default:return e}};return n.replace(e,s)}return e}),define("Core/GregorianDate",[],function(){"use strict";var e=function(e,r,t,n,i,a,o,u){this.year=e,this.month=r,this.day=t,this.hour=n,this.minute=i,this.second=a,this.millisecond=o,this.isLeapSecond=u};return e}),define("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function r(r){if(null===r||isNaN(r))throw new e("year is required and must be a number.");return r%4===0&&r%100!==0||r%400===0}return r}),define("Core/LeapSecond",[],function(){"use strict";var e=function(e,r){this.julianDate=e,this.offset=r};return e}),define("Core/TimeConstants",["./freezeObject"],function(e){"use strict";var r={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e(r)}),define("Core/TimeStandard",["./freezeObject"],function(e){"use strict";var r={UTC:0,TAI:1};return e(r)}),define("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,r,t,n,i,a,o,u,s,l){"use strict";function c(e,r){return q.compare(e.julianDate,r.julianDate)}function f(e){E.julianDate=e;var t=q.leapSeconds,n=r(t,E,c);0>n&&(n=~n),n>=t.length&&(n=t.length-1);var i=t[n].offset;if(n>0){var a=q.secondsDifference(t[n].julianDate,e);a>i&&(n--,i=t[n].offset)}q.addSeconds(e,i,e)}function h(e,t){E.julianDate=e;var n=q.leapSeconds,i=r(n,E,c);if(0>i&&(i=~i),0===i)return q.addSeconds(e,-n[0].offset,t);if(i>=n.length)return q.addSeconds(e,-n[i-1].offset,t);var a=q.secondsDifference(n[i].julianDate,e);return 0===a?q.addSeconds(e,-n[i].offset,t):1>=a?void 0:q.addSeconds(e,-n[--i].offset,t)}function d(e,r,t){var n=r/s.SECONDS_PER_DAY|0;return e+=n,r-=s.SECONDS_PER_DAY*n,0>r&&(e--,r+=s.SECONDS_PER_DAY),t.dayNumber=e,t.secondsOfDay=r,t}function w(e,r,t,n,i,a,o){var u=(r-14)/12|0,l=e+4800+u,c=(1461*l/4|0)+(367*(r-2-12*u)/12|0)-(3*((l+100)/100|0)/4|0)+t-32075;n-=12,0>n&&(n+=24);var f=a+(n*s.SECONDS_PER_HOUR+i*s.SECONDS_PER_MINUTE+o*s.SECONDS_PER_MILLISECOND);return f>=43200&&(c-=1),[c,f]}var m=new a,p=[31,28,31,30,31,30,31,31,30,31,30,31],y=29,E=new u,v=/^(\d{4})$/,_=/^(\d{4})-(\d{2})$/,T=/^(\d{4})-?(\d{3})$/,g=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,R=/^(\d{4})-?(\d{2})-?(\d{2})$/,A=/([Z+\-])?(\d{2})?:?(\d{2})?$/,S=/^(\d{2})(\.\d+)?/.source+A.source,N=/^(\d{2}):?(\d{2})(\.\d+)?/.source+A.source,I=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+A.source,O="Invalid ISO 8601 date.",q=function(e,r,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=t(e,0),r=t(r,0),n=t(n,l.UTC);var i=0|e;r+=(e-i)*s.SECONDS_PER_DAY,d(i,r,this),n===l.UTC&&f(this)};q.fromDate=function(e,r){if(!(e instanceof Date)||isNaN(e.getTime()))throw new i("date must be a valid JavaScript Date.");var t=w(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return n(r)?(d(t[0],t[1],r),f(r),r):new q(t[0],t[1],l.UTC)},q.fromIso8601=function(e,r){if("string"!=typeof e)throw new i(O);e=e.replace(",",".");var t,a,u,s=e.split("T"),c=1,h=1,m=0,E=0,A=0,x=0,M=s[0],b=s[1];if(!n(M))throw new i(O);var P;if(s=M.match(R),null!==s){if(P=M.split("-").length-1,P>0&&2!==P)throw new i(O);t=+s[1],c=+s[2],h=+s[3]}else if(s=M.match(_),null!==s)t=+s[1],c=+s[2];else if(s=M.match(v),null!==s)t=+s[1];else{var C;if(s=M.match(T),null!==s){if(t=+s[1],C=+s[2],u=o(t),1>C||u&&C>366||!u&&C>365)throw new i(O)}else{if(s=M.match(g),null===s)throw new i(O);t=+s[1];var D=+s[2],L=+s[3]||0;if(P=M.split("-").length-1,P>0&&(!n(s[3])&&1!==P||n(s[3])&&2!==P))throw new i(O);var U=new Date(Date.UTC(t,0,4));C=7*D+L-U.getUTCDay()-3}a=new Date(Date.UTC(t,0,1)),a.setUTCDate(C),c=a.getUTCMonth()+1,h=a.getUTCDate()}if(u=o(t),1>c||c>12||1>h||(2!==c||!u)&&h>p[c-1]||u&&2===c&&h>y)throw new i(O);var F;if(n(b)){if(s=b.match(I),null!==s){if(P=b.split(":").length-1,P>0&&2!==P&&3!==P)throw new i(O);m=+s[1],E=+s[2],A=+s[3],x=1e3*+(s[4]||0),F=5}else if(s=b.match(N),null!==s){if(P=b.split(":").length-1,P>0&&1!==P)throw new i(O);m=+s[1],E=+s[2],A=60*+(s[3]||0),F=4}else{if(s=b.match(S),null===s)throw new i(O);m=+s[1],E=60*+(s[2]||0),F=3}if(E>=60||A>=61||m>24||24===m&&(E>0||A>0||x>0))throw new i(O);var z=s[F],B=+s[F+1],G=+(s[F+2]||0);switch(z){case"+":m-=B,E-=G;break;case"-":m+=B,E+=G;break;case"Z":break;default:E+=new Date(Date.UTC(t,c-1,h,m,E)).getTimezoneOffset()}}else E+=new Date(t,c-1,h).getTimezoneOffset();var W=60===A;for(W&&A--;E>=60;)E-=60,m++;for(;m>=24;)m-=24,h++;for(a=u&&2===c?y:p[c-1];h>a;)h-=a,c++,c>12&&(c-=12,t++),a=u&&2===c?y:p[c-1];for(;0>E;)E+=60,m--;for(;0>m;)m+=24,h--;for(;1>h;)c--,1>c&&(c+=12,t--),a=u&&2===c?y:p[c-1],h+=a;var H=w(t,c,h,m,E,A,x);return n(r)?(d(H[0],H[1],r),f(r)):r=new q(H[0],H[1],l.UTC),W&&q.addSeconds(r,1,r),r},q.now=function(e){return q.fromDate(new Date,e)};var x=new q(0,0,l.TAI);return q.toGregorianDate=function(e,r){if(!n(e))throw new i("julianDate is required.");var t=!1,o=h(e,x);n(o)||(q.addSeconds(e,-1,x),o=h(x,x),t=!0);var u=o.dayNumber,l=o.secondsOfDay;l>=43200&&(u+=1);var c=u+68569|0,f=4*c/146097|0;c=c-((146097*f+3)/4|0)|0;var d=4e3*(c+1)/1461001|0;c=c-(1461*d/4|0)+31|0;var w=80*c/2447|0,m=c-(2447*w/80|0)|0;c=w/11|0;var p=w+2-12*c|0,y=100*(f-49)+d+c|0,E=l/s.SECONDS_PER_HOUR|0,v=l-E*s.SECONDS_PER_HOUR,_=v/s.SECONDS_PER_MINUTE|0;v-=_*s.SECONDS_PER_MINUTE;var T=0|v,g=(v-T)/s.SECONDS_PER_MILLISECOND;return E+=12,E>23&&(E-=24),t&&(T+=1),n(r)?(r.year=y,r.month=p,r.day=m,r.hour=E,r.minute=_,r.second=T,r.millisecond=g,r.isLeapSecond=t,r):new a(y,p,m,E,_,T,g,t)},q.toDate=function(e){if(!n(e))throw new i("julianDate is required.");var r=q.toGregorianDate(e,m),t=r.second;return r.isLeapSecond&&(t-=1),new Date(Date.UTC(r.year,r.month-1,r.day,r.hour,r.minute,t,r.millisecond))},q.toIso8601=function(r,t){if(!n(r))throw new i("julianDate is required.");var a,o=q.toGregorianDate(r,o);return n(t)||0===o.millisecond?n(t)&&0!==t?(a=(.01*o.millisecond).toFixed(t).replace(".","").slice(0,t),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o.year,o.month,o.day,o.hour,o.minute,o.second,a)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",o.year,o.month,o.day,o.hour,o.minute,o.second):(a=(.01*o.millisecond).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o.year,o.month,o.day,o.hour,o.minute,o.second,a))},q.clone=function(e,r){return n(e)?n(r)?(r.dayNumber=e.dayNumber,r.secondsOfDay=e.secondsOfDay,r):new q(e.dayNumber,e.secondsOfDay,l.TAI):void 0},q.compare=function(e,r){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");var t=e.dayNumber-r.dayNumber;return 0!==t?t:e.secondsOfDay-r.secondsOfDay},q.equals=function(e,r){return e===r||n(e)&&n(r)&&e.dayNumber===r.dayNumber&&e.secondsOfDay===r.secondsOfDay},q.equalsEpsilon=function(e,r,t){if(!n(t))throw new i("epsilon is required.");return e===r||n(e)&&n(r)&&Math.abs(q.secondsDifference(e,r))<=t},q.totalDays=function(e){if(!n(e))throw new i("julianDate is required.");return e.dayNumber+e.secondsOfDay/s.SECONDS_PER_DAY},q.secondsDifference=function(e,r){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");var t=(e.dayNumber-r.dayNumber)*s.SECONDS_PER_DAY;return t+(e.secondsOfDay-r.secondsOfDay)},q.daysDifference=function(e,r){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");var t=e.dayNumber-r.dayNumber,a=(e.secondsOfDay-r.secondsOfDay)/s.SECONDS_PER_DAY;return t+a},q.computeTaiMinusUtc=function(e){E.julianDate=e;var t=q.leapSeconds,n=r(t,E,c);return 0>n&&(n=~n,--n,0>n&&(n=0)),t[n].offset},q.addSeconds=function(e,r,t){if(!n(e))throw new i("julianDate is required.");if(!n(r))throw new i("seconds is required.");if(!n(t))throw new i("result is required.");return d(e.dayNumber,e.secondsOfDay+r,t)},q.addMinutes=function(e,r,t){if(!n(e))throw new i("julianDate is required.");if(!n(r))throw new i("minutes is required.");if(!n(t))throw new i("result is required.");var a=e.secondsOfDay+r*s.SECONDS_PER_MINUTE;
return d(e.dayNumber,a,t)},q.addHours=function(e,r,t){if(!n(e))throw new i("julianDate is required.");if(!n(r))throw new i("hours is required.");if(!n(t))throw new i("result is required.");var a=e.secondsOfDay+r*s.SECONDS_PER_HOUR;return d(e.dayNumber,a,t)},q.addDays=function(e,r,t){if(!n(e))throw new i("julianDate is required.");if(!n(r))throw new i("days is required.");if(!n(t))throw new i("result is required.");var a=e.dayNumber+r;return d(a,e.secondsOfDay,t)},q.lessThan=function(e,r){return q.compare(e,r)<0},q.lessThanOrEquals=function(e,r){return q.compare(e,r)<=0},q.greaterThan=function(e,r){return q.compare(e,r)>0},q.greaterThanOrEquals=function(e,r){return q.compare(e,r)>=0},q.prototype.clone=function(e){return q.clone(this,e)},q.prototype.equals=function(e){return q.equals(this,e)},q.prototype.equalsEpsilon=function(e,r){return q.equalsEpsilon(this,e,r)},q.prototype.toString=function(){return q.toIso8601(this)},q.leapSeconds=[new u(new q(2441317,43210,l.TAI),10),new u(new q(2441499,43211,l.TAI),11),new u(new q(2441683,43212,l.TAI),12),new u(new q(2442048,43213,l.TAI),13),new u(new q(2442413,43214,l.TAI),14),new u(new q(2442778,43215,l.TAI),15),new u(new q(2443144,43216,l.TAI),16),new u(new q(2443509,43217,l.TAI),17),new u(new q(2443874,43218,l.TAI),18),new u(new q(2444239,43219,l.TAI),19),new u(new q(2444786,43220,l.TAI),20),new u(new q(2445151,43221,l.TAI),21),new u(new q(2445516,43222,l.TAI),22),new u(new q(2446247,43223,l.TAI),23),new u(new q(2447161,43224,l.TAI),24),new u(new q(2447892,43225,l.TAI),25),new u(new q(2448257,43226,l.TAI),26),new u(new q(2448804,43227,l.TAI),27),new u(new q(2449169,43228,l.TAI),28),new u(new q(2449534,43229,l.TAI),29),new u(new q(2450083,43230,l.TAI),30),new u(new q(2450630,43231,l.TAI),31),new u(new q(2451179,43232,l.TAI),32),new u(new q(2453736,43233,l.TAI),33),new u(new q(2454832,43234,l.TAI),34),new u(new q(2456109,43235,l.TAI),35),new u(new q(2457204,43236,l.TAI),36)],q}),define("Core/clone",["./defaultValue"],function(e){"use strict";var r=function(t,n){if(null===t||"object"!=typeof t)return t;n=e(n,!1);var i=new t.constructor;for(var a in t)if(t.hasOwnProperty(a)){var o=t[a];n&&(o=r(o,n)),i[a]=o}return i};return r}),define("Core/parseResponseHeaders",[],function(){"use strict";var e=function(e){var r={};if(!e)return r;for(var t=e.split("\r\n"),n=0;n<t.length;++n){var i=t[n],a=i.indexOf(": ");if(a>0){var o=i.substring(0,a),u=i.substring(a+2);r[o]=u}}return r};return e}),define("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,r){"use strict";var t=function(e,t,n){this.statusCode=e,this.response=t,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=r(this.responseHeaders))};return t.prototype.toString=function(){var r="Request has failed.";return e(this.statusCode)&&(r+=" Status Code: "+this.statusCode),r},t}),define("Core/loadWithXhr",["../ThirdParty/when","./defaultValue","./defined","./DeveloperError","./RequestErrorEvent","./RuntimeError"],function(e,r,t,n,i,a){"use strict";function o(e,r){var t=decodeURIComponent(r);return e?atob(t):t}function u(e,r){for(var t=o(e,r),n=new ArrayBuffer(t.length),i=new Uint8Array(n),a=0;a<t.length;a++)i[a]=t.charCodeAt(a);return n}function s(e,t){t=r(t,"");var i=e[1],a=!!e[2],s=e[3];switch(t){case"":case"text":return o(a,s);case"arraybuffer":return u(a,s);case"blob":var l=u(a,s);return new Blob([l],{type:i});case"document":var c=new DOMParser;return c.parseFromString(o(a,s),i);case"json":return JSON.parse(o(a,s));default:throw new n("Unhandled responseType: "+t)}}var l=function(i){if(i=r(i,r.EMPTY_OBJECT),!t(i.url))throw new n("options.url is required.");var a=i.responseType,o=r(i.method,"GET"),u=i.data,s=i.headers,c=i.overrideMimeType;return e(i.url,function(r){var t=e.defer();return l.load(r,a,o,u,s,t,c),t.promise})},c=/^data:(.*?)(;base64)?,(.*)$/;return l.load=function(e,r,n,o,u,l,f){var h=c.exec(e);if(null!==h)return void l.resolve(s(h,r));var d=new XMLHttpRequest;if(t(f)&&t(d.overrideMimeType)&&d.overrideMimeType(f),d.open(n,e,!0),t(u))for(var w in u)u.hasOwnProperty(w)&&d.setRequestHeader(w,u[w]);t(r)&&(d.responseType=r),d.onload=function(){200===d.status?t(d.response)?l.resolve(d.response):t(d.responseXML)&&d.responseXML.hasChildNodes()?l.resolve(d.responseXML):t(d.responseText)?l.resolve(d.responseText):l.reject(new a("unknown XMLHttpRequest response type.")):l.reject(new i(d.status,d.response,d.getAllResponseHeaders()))},d.onerror=function(e){l.reject(new i)},d.send(o)},l.defaultLoad=l.load,l}),define("Core/loadText",["./loadWithXhr"],function(e){"use strict";var r=function(r,t){return e({url:r,headers:t})};return r}),define("Core/loadJson",["./clone","./defined","./DeveloperError","./loadText"],function(e,r,t,n){"use strict";var i={Accept:"application/json,*/*;q=0.01"},a=function(a,o){if(!r(a))throw new t("url is required.");return r(o)?r(o.Accept)||(o=e(o),o.Accept=i.Accept):o=i,n(a,o).then(function(e){return JSON.parse(e)})};return a}),define("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./loadJson","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,r,t,n,i,a,o,u,s,l,c,f){"use strict";function h(e,r){return o.compare(e.julianDate,r)}function d(e,t){if(!n(t.columnNames))return void(e._dataError="Error in loaded EOP data: The columnNames property is required.");if(!n(t.samples))return void(e._dataError="Error in loaded EOP data: The samples property is required.");var i=t.columnNames.indexOf("modifiedJulianDateUtc"),a=t.columnNames.indexOf("xPoleWanderRadians"),s=t.columnNames.indexOf("yPoleWanderRadians"),l=t.columnNames.indexOf("ut1MinusUtcSeconds"),d=t.columnNames.indexOf("xCelestialPoleOffsetRadians"),w=t.columnNames.indexOf("yCelestialPoleOffsetRadians"),m=t.columnNames.indexOf("taiMinusUtcSeconds");if(0>i||0>a||0>s||0>l||0>d||0>w||0>m)return void(e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns");var p=e._samples=t.samples,y=e._dates=[];e._dateColumn=i,e._xPoleWanderRadiansColumn=a,e._yPoleWanderRadiansColumn=s,e._ut1MinusUtcSecondsColumn=l,e._xCelestialPoleOffsetRadiansColumn=d,e._yCelestialPoleOffsetRadiansColumn=w,e._taiMinusUtcSecondsColumn=m,e._columnCount=t.columnNames.length,e._lastIndex=void 0;for(var E,v=e._addNewLeapSeconds,_=0,T=p.length;T>_;_+=e._columnCount){var g=p[_+i],R=p[_+m],A=g+c.MODIFIED_JULIAN_DATE_DIFFERENCE,S=new o(A,R,f.TAI);if(y.push(S),v){if(R!==E&&n(E)){var N=o.leapSeconds,I=r(N,S,h);if(0>I){var O=new u(S,R);N.splice(~I,0,O)}}E=R}}}function w(e,r,t,n,i){var a=t*n;i.xPoleWander=r[a+e._xPoleWanderRadiansColumn],i.yPoleWander=r[a+e._yPoleWanderRadiansColumn],i.xPoleOffset=r[a+e._xCelestialPoleOffsetRadiansColumn],i.yPoleOffset=r[a+e._yCelestialPoleOffsetRadiansColumn],i.ut1MinusUtc=r[a+e._ut1MinusUtcSecondsColumn]}function m(e,r,t){return r+e*(t-r)}function p(e,r,t,n,i,a,u){var s=e._columnCount;if(a>r.length-1)return u.xPoleWander=0,u.yPoleWander=0,u.xPoleOffset=0,u.yPoleOffset=0,u.ut1MinusUtc=0,u;var l=r[i],c=r[a];if(l.equals(c)||n.equals(l))return w(e,t,i,s,u),u;if(n.equals(c))return w(e,t,a,s,u),u;var f=o.secondsDifference(n,l)/o.secondsDifference(c,l),h=i*s,d=a*s,p=t[h+e._ut1MinusUtcSecondsColumn],y=t[d+e._ut1MinusUtcSecondsColumn],E=y-p;if(E>.5||-.5>E){var v=t[h+e._taiMinusUtcSecondsColumn],_=t[d+e._taiMinusUtcSecondsColumn];v!==_&&(c.equals(n)?p=y:y-=_-v)}return u.xPoleWander=m(f,t[h+e._xPoleWanderRadiansColumn],t[d+e._xPoleWanderRadiansColumn]),u.yPoleWander=m(f,t[h+e._yPoleWanderRadiansColumn],t[d+e._yPoleWanderRadiansColumn]),u.xPoleOffset=m(f,t[h+e._xCelestialPoleOffsetRadiansColumn],t[d+e._xCelestialPoleOffsetRadiansColumn]),u.yPoleOffset=m(f,t[h+e._yCelestialPoleOffsetRadiansColumn],t[d+e._yCelestialPoleOffsetRadiansColumn]),u.ut1MinusUtc=m(f,p,y),u}var y=function(r){if(r=t(r,t.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=t(r.addNewLeapSeconds,!0),n(r.data))d(this,r.data);else if(n(r.url)){var i=this;this._downloadPromise=e(s(r.url),function(e){d(i,e)},function(){i._dataError="An error occurred while retrieving the EOP data from the URL "+r.url+"."})}else d(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})};return y.NONE=a({getPromiseToLoad:function(){return e()},compute:function(e,r){return n(r)?(r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0):r=new i(0,0,0,0,0),r}}),y.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},y.prototype.compute=function(e,t){if(!n(this._samples)){if(n(this._dataError))throw new l(this._dataError);return void 0}if(n(t)||(t=new i(0,0,0,0,0)),0===this._samples.length)return t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0,t;var a=this._dates,u=this._lastIndex,s=0,c=0;if(n(u)){var f=a[u],h=a[u+1],d=o.lessThanOrEquals(f,e),w=!n(h),m=w||o.greaterThanOrEquals(h,e);if(d&&m)return s=u,!w&&h.equals(e)&&++s,c=s+1,p(this,a,this._samples,e,s,c,t),t}var y=r(a,e,o.compare,this._dateColumn);return y>=0?(y<a.length-1&&a[y+1].equals(e)&&++y,s=y,c=y):(c=~y,s=c-1,0>s&&(s=0)),this._lastIndex=s,p(this,a,this._samples,e,s,c,t),t},y}),define("ThirdParty/Uri",[],function(){function e(r){if(r instanceof e)this.scheme=r.scheme,this.authority=r.authority,this.path=r.path,this.query=r.query,this.fragment=r.fragment;else if(r){var t=n.exec(r);this.scheme=t[1],this.authority=t[2],this.path=t[3],this.query=t[4],this.fragment=t[5]}}function r(e){var r=unescape(e);return a.test(r)?r:e.toUpperCase()}function t(e,r,t,n){return(r||"")+t.toLowerCase()+(n||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var n=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(o,t).replace(i,r)),this.path&&(this.path=this.path.replace(i,r)),this.query&&(this.query=this.query.replace(i,r)),this.fragment&&(this.fragment=this.fragment.replace(i,r))};var i=/%[0-9a-z]{2}/gi,a=/[a-zA-Z0-9\-\._~]/,o=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(r){var t=new e;return this.scheme?(t.scheme=this.scheme,t.authority=this.authority,t.path=this.path,t.query=this.query):(t.scheme=r.scheme,this.authority?(t.authority=this.authority,t.path=this.path,t.query=this.query):(t.authority=r.authority,""==this.path?(t.path=r.path,t.query=this.query||r.query):("/"==this.path.charAt(0)?(t.path=this.path,t.removeDotSegments()):(r.authority&&""==r.path?t.path="/"+this.path:t.path=r.path.substring(0,r.path.lastIndexOf("/")+1)+this.path,t.removeDotSegments()),t.query=this.query))),t.fragment=this.fragment,t},e.prototype.removeDotSegments=function(){var e,r=this.path.split("/"),t=[],n=""==r[0];n&&r.shift();for(""==r[0]?r.shift():null;r.length;)e=r.shift(),".."==e?t.pop():"."!=e&&t.push(e);("."==e||".."==e)&&t.push(""),n&&t.unshift(""),this.path=t.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),define("Core/buildModuleUrl",["../ThirdParty/Uri","./defined","./DeveloperError","require"],function(e,r,t,n){"use strict";function i(){for(var e=document.getElementsByTagName("script"),r=0,t=e.length;t>r;++r){var n=e[r].getAttribute("src"),i=f.exec(n);if(null!==i)return i[1]}return void 0}function a(){if(r(s))return s;var n;if(n="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:i(),!r(n))throw new t("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return s=new e(n).resolve(new e(document.location.href))}function o(e){return n.toUrl("../"+e)}function u(r){return new e(r).resolve(a()).toString()}var s,l,c,f=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i,h=function(e){r(l)||(l=r(n.toUrl)?o:u),r(c)||(c=document.createElement("a"));var t=l(e);return c.href=t,c.href=c.href,c.href};return h._cesiumScriptRegex=f,h.setBaseUrl=function(r){s=new e(r).resolve(new e(document.location.href))},h}),define("Core/Iau2006XysSample",[],function(){"use strict";var e=function(e,r,t){this.x=e,this.y=r,this.s=t};return e}),define("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./loadJson","./TimeStandard"],function(e,r,t,n,i,a,o,u){"use strict";function s(e,r,t){var n=f;return n.dayNumber=r,n.secondsOfDay=t,a.daysDifference(n,e._sampleZeroDateTT)}function l(t,i){if(t._chunkDownloadsInProgress[i])return t._chunkDownloadsInProgress[i];var a=e.defer();t._chunkDownloadsInProgress[i]=a;var u,s=t._xysFileUrlTemplate;return u=n(s)?s.replace("{0}",i):r("Assets/IAU2006_XYS/IAU2006_XYS_"+i+".json"),e(o(u),function(e){t._chunkDownloadsInProgress[i]=!1;for(var r=t._samples,n=e.samples,o=i*t._samplesPerXysFile*3,u=0,s=n.length;s>u;++u)r[o+u]=n[u];a.resolve()}),a.promise}var c=function(e){e=t(e,t.EMPTY_OBJECT),this._xysFileUrlTemplate=e.xysFileUrlTemplate,this._interpolationOrder=t(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=t(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new a(this._sampleZeroJulianEphemerisDate,0,u.TAI),this._stepSizeDays=t(e.stepSizeDays,1),this._samplesPerXysFile=t(e.samplesPerXysFile,1e3),this._totalSamples=t(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var r=this._interpolationOrder,n=this._denominators=new Array(r+1),i=this._xTable=new Array(r+1),o=Math.pow(this._stepSizeDays,r),s=0;r>=s;++s){n[s]=o,i[s]=s*this._stepSizeDays;for(var l=0;r>=l;++l)l!==s&&(n[s]*=s-l);n[s]=1/n[s]}this._work=new Array(r+1),this._coef=new Array(r+1)},f=new a(0,0,u.TAI);return c.prototype.preload=function(r,t,n,i){var a=s(this,r,t),o=s(this,n,i),u=a/this._stepSizeDays-this._interpolationOrder/2|0;0>u&&(u=0);var c=o/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;c>=this._totalSamples&&(c=this._totalSamples-1);for(var f=u/this._samplesPerXysFile|0,h=c/this._samplesPerXysFile|0,d=[],w=f;h>=w;++w)d.push(l(this,w));return e.all(d)},c.prototype.computeXysRadians=function(e,r,t){var a=s(this,e,r);if(0>a)return void 0;var o=a/this._stepSizeDays|0;if(o>=this._totalSamples)return void 0;var u=this._interpolationOrder,c=o-(u/2|0);0>c&&(c=0);var f=c+u;f>=this._totalSamples&&(f=this._totalSamples-1,c=f-u,0>c&&(c=0));var h=!1,d=this._samples;if(n(d[3*c])||(l(this,c/this._samplesPerXysFile|0),h=!0),n(d[3*f])||(l(this,f/this._samplesPerXysFile|0),h=!0),h)return void 0;n(t)?(t.x=0,t.y=0,t.s=0):t=new i(0,0,0);var w,m,p=a-c*this._stepSizeDays,y=this._work,E=this._denominators,v=this._coef,_=this._xTable;for(w=0;u>=w;++w)y[w]=p-_[w];for(w=0;u>=w;++w){for(v[w]=1,m=0;u>=m;++m)m!==w&&(v[w]*=y[m]);v[w]*=E[w];var T=3*(c+w);t.x+=v[w]*d[T++],t.y+=v[w]*d[T++],t.s+=v[w]*d[T]}return t},c}),define("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,r,t,n,i,a,o,u){"use strict";var s=function(e,t,n,i){this.x=r(e,0),this.y=r(t,0),this.z=r(n,0),this.w=r(i,0)},l=new e;s.fromAxisAngle=function(r,i,a){if(!t(r))throw new n("axis is required.");if("number"!=typeof i)throw new n("angle is required and must be a number.");var o=i/2,u=Math.sin(o);l=e.normalize(r,l);var c=l.x*u,f=l.y*u,h=l.z*u,d=Math.cos(o);return t(a)?(a.x=c,a.y=f,a.z=h,a.w=d,a):new s(c,f,h,d)};var c=[1,2,0],f=new Array(3);s.fromRotationMatrix=function(e,r){if(!t(e))throw new n("matrix is required.");var i,a,o,l,h,d=e[u.COLUMN0ROW0],w=e[u.COLUMN1ROW1],m=e[u.COLUMN2ROW2],p=d+w+m;if(p>0)i=Math.sqrt(p+1),h=.5*i,i=.5/i,a=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*i,o=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*i,l=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*i;else{var y=c,E=0;w>d&&(E=1),m>d&&m>w&&(E=2);var v=y[E],_=y[v];i=Math.sqrt(e[u.getElementIndex(E,E)]-e[u.getElementIndex(v,v)]-e[u.getElementIndex(_,_)]+1);var T=f;T[E]=.5*i,i=.5/i,h=(e[u.getElementIndex(_,v)]-e[u.getElementIndex(v,_)])*i,T[v]=(e[u.getElementIndex(v,E)]+e[u.getElementIndex(E,v)])*i,T[_]=(e[u.getElementIndex(_,E)]+e[u.getElementIndex(E,_)])*i,a=-T[0],o=-T[1],l=-T[2]}return t(r)?(r.x=a,r.y=o,r.z=l,r.w=h,r):new s(a,o,l,h)};var h=new s;s.fromHeadingPitchRoll=function(r,i,a,o){if(!t(r))throw new n("heading is required.");if(!t(i))throw new n("pitch is required.");if(!t(a))throw new n("roll is required.");var u=s.fromAxisAngle(e.UNIT_X,a,h),l=s.fromAxisAngle(e.UNIT_Y,-i,o);o=s.multiply(l,u,l);var c=s.fromAxisAngle(e.UNIT_Z,-r,h);return s.multiply(c,o,o)};var d=new e,w=new e,m=new s,p=new s,y=new s;s.packedLength=4,s.pack=function(e,i,a){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");a=r(a,0),i[a++]=e.x,i[a++]=e.y,i[a++]=e.z,i[a]=e.w},s.unpack=function(e,i,a){if(!t(e))throw new n("array is required");return i=r(i,0),t(a)||(a=new s),a.x=e[i],a.y=e[i+1],a.z=e[i+2],a.w=e[i+3],a},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,r,t,n){s.unpack(e,4*t,y),s.conjugate(y,y);for(var i=0,a=t-r+1;a>i;i++){var o=3*i;s.unpack(e,4*(r+i),m),s.multiply(m,y,m),m.w<0&&s.negate(m,m),s.computeAxis(m,d);var u=s.computeAngle(m);n[o]=d.x*u,n[o+1]=d.y*u,n[o+2]=d.z*u}},s.unpackInterpolationResult=function(r,n,i,a,o){t(o)||(o=new s),e.fromArray(r,0,w);var u=e.magnitude(w);return s.unpack(n,4*a,p),0===u?s.clone(s.IDENTITY,m):s.fromAxisAngle(w,u,m),s.multiply(m,p,o)},s.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,r){if(!t(e))throw new n("quaternion is required");if(!t(r))throw new n("result is required");return r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=e.w,r},s.magnitudeSquared=function(e){if(!t(e))throw new n("quaternion is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,r){if(!t(r))throw new n("result is required");var i=1/s.magnitude(e),a=e.x*i,o=e.y*i,u=e.z*i,l=e.w*i;return r.x=a,r.y=o,r.z=u,r.w=l,r},s.inverse=function(e,r){if(!t(r))throw new n("result is required");var i=s.magnitudeSquared(e);return r=s.conjugate(e,r),s.multiplyByScalar(r,1/i,r)},s.add=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i.x=e.x+r.x,i.y=e.y+r.y,i.z=e.z+r.z,i.w=e.w+r.w,i},s.subtract=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i.x=e.x-r.x,i.y=e.y-r.y,i.z=e.z-r.z,i.w=e.w-r.w,i},s.negate=function(e,r){if(!t(e))throw new n("quaternion is required");if(!t(r))throw new n("result is required");return r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r},s.dot=function(e,r){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");return e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w},s.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");var a=e.x,o=e.y,u=e.z,s=e.w,l=r.x,c=r.y,f=r.z,h=r.w,d=s*l+a*h+o*f-u*c,w=s*c-a*f+o*h+u*l,m=s*f+a*c-o*l+u*h,p=s*h-a*l-o*c-u*f;return i.x=d,i.y=w,i.z=m,i.w=p,i},s.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("quaternion is required");if("number"!=typeof r)throw new n("scalar is required and must be a number.");if(!t(i))throw new n("result is required");return i.x=e.x*r,i.y=e.y*r,i.z=e.z*r,i.w=e.w*r,i},s.divideByScalar=function(e,r,i){if(!t(e))throw new n("quaternion is required");if("number"!=typeof r)throw new n("scalar is required and must be a number.");if(!t(i))throw new n("result is required");return i.x=e.x/r,i.y=e.y/r,i.z=e.z/r,i.w=e.w/r,i},s.computeAxis=function(e,r){if(!t(e))throw new n("quaternion is required");if(!t(r))throw new n("result is required");var i=e.w;if(Math.abs(i-1)<o.EPSILON6)return r.x=r.y=r.z=0,r;var a=1/Math.sqrt(1-i*i);return r.x=e.x*a,r.y=e.y*a,r.z=e.z*a,r},s.computeAngle=function(e){if(!t(e))throw new n("quaternion is required");return Math.abs(e.w-1)<o.EPSILON6?0:2*Math.acos(e.w)};var E=new s;s.lerp=function(e,r,i,a){if(!t(e))throw new n("start is required.");if(!t(r))throw new n("end is required.");if("number"!=typeof i)throw new n("t is required and must be a number.");if(!t(a))throw new n("result is required");return E=s.multiplyByScalar(r,i,E),a=s.multiplyByScalar(e,1-i,a),s.add(E,a,a)};var v=new s,_=new s,T=new s;s.slerp=function(e,r,i,a){if(!t(e))throw new n("start is required.");if(!t(r))throw new n("end is required.");if("number"!=typeof i)throw new n("t is required and must be a number.");if(!t(a))throw new n("result is required");var u=s.dot(e,r),l=r;if(0>u&&(u=-u,l=v=s.negate(r,v)),1-u<o.EPSILON6)return s.lerp(e,l,i,a);var c=Math.acos(u);return _=s.multiplyByScalar(e,Math.sin((1-i)*c),_),T=s.multiplyByScalar(l,Math.sin(i*c),T),a=s.add(_,T,a),s.multiplyByScalar(a,1/Math.sin(c),a)},s.log=function(r,i){if(!t(r))throw new n("quaternion is required.");if(!t(i))throw new n("result is required");var a=o.acosClamped(r.w),u=0;return 0!==a&&(u=a/Math.sin(a)),e.multiplyByScalar(r,u,i)},s.exp=function(r,i){if(!t(r))throw new n("cartesian is required.");if(!t(i))throw new n("result is required");var a=e.magnitude(r),o=0;return 0!==a&&(o=Math.sin(a)/a),i.x=r.x*o,i.y=r.y*o,i.z=r.z*o,i.w=Math.cos(a),i};var g=new e,R=new e,A=new s,S=new s;s.computeInnerQuadrangle=function(r,i,a,o){if(!t(r)||!t(i)||!t(a))throw new n("q0, q1, and q2 are required.");if(!t(o))throw new n("result is required");var u=s.conjugate(i,A);s.multiply(u,a,S);var l=s.log(S,g);s.multiply(u,r,S);var c=s.log(S,R);return e.add(l,c,l),e.multiplyByScalar(l,.25,l),e.negate(l,l),s.exp(l,A),s.multiply(i,A,o)},s.squad=function(e,r,i,a,o,u){if(!(t(e)&&t(r)&&t(i)&&t(a)))throw new n("q0, q1, s0, and s1 are required.");if("number"!=typeof o)throw new n("t is required and must be a number.");if(!t(u))throw new n("result is required");var l=s.slerp(e,r,o,A),c=s.slerp(i,a,o,S);return s.slerp(l,c,2*o*(1-o),u)};for(var N=new s,I=1.9011074535173003,O=i.supportsTypedArrays()?new Float32Array(8):[],q=i.supportsTypedArrays()?new Float32Array(8):[],x=i.supportsTypedArrays()?new Float32Array(8):[],M=i.supportsTypedArrays()?new Float32Array(8):[],b=0;7>b;++b){var P=b+1,C=2*P+1;O[b]=1/(P*C),q[b]=P/C}return O[7]=I/136,q[7]=8*I/17,s.fastSlerp=function(e,r,i,a){if(!t(e))throw new n("start is required.");if(!t(r))throw new n("end is required.");if("number"!=typeof i)throw new n("t is required and must be a number.");if(!t(a))throw new n("result is required");var o,u=s.dot(e,r);u>=0?o=1:(o=-1,u=-u);for(var l=u-1,c=1-i,f=i*i,h=c*c,d=7;d>=0;--d)x[d]=(O[d]*f-q[d])*l,M[d]=(O[d]*h-q[d])*l;var w=o*i*(1+x[0]*(1+x[1]*(1+x[2]*(1+x[3]*(1+x[4]*(1+x[5]*(1+x[6]*(1+x[7])))))))),m=c*(1+M[0]*(1+M[1]*(1+M[2]*(1+M[3]*(1+M[4]*(1+M[5]*(1+M[6]*(1+M[7])))))))),p=s.multiplyByScalar(e,m,N);return s.multiplyByScalar(r,w,a),s.add(p,a,a)},s.fastSquad=function(e,r,i,a,o,u){if(!(t(e)&&t(r)&&t(i)&&t(a)))throw new n("q0, q1, s0, and s1 are required.");if("number"!=typeof o)throw new n("t is required and must be a number.");if(!t(u))throw new n("result is required");var l=s.fastSlerp(e,r,o,A),c=s.fastSlerp(i,a,o,S);return s.fastSlerp(l,c,2*o*(1-o),u)},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},s.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon is required and must be a number.");return e===r||t(e)&&t(r)&&Math.abs(e.x-r.x)<=i&&Math.abs(e.y-r.y)<=i&&Math.abs(e.z-r.z)<=i&&Math.abs(e.w-r.w)<=i},s.ZERO=a(new s(0,0,0,0)),s.IDENTITY=a(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,r){return s.equalsEpsilon(this,e,r)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],function(e,r,t,n,i,a,o,u,s,l,c,f,h,d,w,m,p,y){"use strict";var E={},v=new t,_=new t,T=new t;E.eastNorthUpToFixedFrame=function(e,r,n){if(!a(e))throw new o("origin is required.");if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var u=d.sign(e.z);return a(n)?(n[0]=0,n[1]=1,n[2]=0,n[3]=0,n[4]=-u,n[5]=0,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=u,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(0,-u,0,e.x,1,0,0,e.y,0,0,u,e.z,0,0,0,1)}var s=v,c=_,f=T;return r=i(r,l.WGS84),r.geodeticSurfaceNormal(e,s),c.x=-e.y,c.y=e.x,c.z=0,t.normalize(c,c),t.cross(s,c,f),a(n)?(n[0]=c.x,n[1]=c.y,n[2]=c.z,n[3]=0,n[4]=f.x,n[5]=f.y,n[6]=f.z,n[7]=0,n[8]=s.x,n[9]=s.y,n[10]=s.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(c.x,f.x,s.x,e.x,c.y,f.y,s.y,e.y,c.z,f.z,s.z,e.z,0,0,0,1)};var g=new t,R=new t,A=new t;E.northEastDownToFixedFrame=function(e,r,n){if(!a(e))throw new o("origin is required.");if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var u=d.sign(e.z);return a(n)?(n[0]=-u,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=1,n[6]=0,n[7]=0,n[8]=0,n[9]=0,n[10]=-u,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(-u,0,0,e.x,0,1,0,e.y,0,0,-u,e.z,0,0,0,1)}var s=g,c=R,f=A;return r=i(r,l.WGS84),r.geodeticSurfaceNormal(e,s),c.x=-e.y,c.y=e.x,c.z=0,t.normalize(c,c),t.cross(s,c,f),a(n)?(n[0]=f.x,n[1]=f.y,n[2]=f.z,n[3]=0,n[4]=c.x,n[5]=c.y,n[6]=c.z,n[7]=0,n[8]=-s.x,n[9]=-s.y,n[10]=-s.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(f.x,c.x,-s.x,e.x,f.y,c.y,-s.y,e.y,f.z,c.z,-s.z,e.z,0,0,0,1)},E.northUpEastToFixedFrame=function(e,r,n){if(!a(e))throw new o("origin is required.");if(d.equalsEpsilon(e.x,0,d.EPSILON14)&&d.equalsEpsilon(e.y,0,d.EPSILON14)){var u=d.sign(e.z);return a(n)?(n[0]=-u,n[1]=0,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=u,n[7]=0,n[8]=0,n[9]=1,n[10]=0,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(-u,0,0,e.x,0,0,1,e.y,0,u,0,e.z,0,0,0,1)}var s=v,c=_,f=T;return r=i(r,l.WGS84),r.geodeticSurfaceNormal(e,s),c.x=-e.y,c.y=e.x,c.z=0,t.normalize(c,c),t.cross(s,c,f),a(n)?(n[0]=f.x,n[1]=f.y,n[2]=f.z,n[3]=0,n[4]=s.x,n[5]=s.y,n[6]=s.z,n[7]=0,n[8]=c.x,n[9]=c.y,n[10]=c.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n):new m(f.x,s.x,c.x,e.x,f.y,s.y,c.y,e.y,f.z,s.z,c.z,e.z,0,0,0,1)};var S=new p,N=new t(1,1,1),I=new m;E.headingPitchRollToFixedFrame=function(e,r,n,i,a,o){var u=p.fromHeadingPitchRoll(r,n,i,S),s=m.fromTranslationQuaternionRotationScale(t.ZERO,u,N,I);return o=E.eastNorthUpToFixedFrame(e,a,o),m.multiply(o,s,o)};var O=new m,q=new w;E.headingPitchRollQuaternion=function(e,r,t,n,i,a){var o=E.headingPitchRollToFixedFrame(e,r,t,n,i,O),u=m.getRotation(o,q);return p.fromRotationMatrix(u,a)};var x=24110.54841,M=8640184.812866,b=.093104,P=-62e-7,C=1.1772758384668e-19,D=72921158553e-15,L=d.TWO_PI/86400,U=new h;E.computeTemeToPseudoFixedMatrix=function(e,r){if(!a(e))throw new o("date is required.");U=h.addSeconds(e,-h.computeTaiMinusUtc(e),U);var t,n=U.dayNumber,i=U.secondsOfDay,u=n-2451545;t=i>=43200?(u+.5)/y.DAYS_PER_JULIAN_CENTURY:(u-.5)/y.DAYS_PER_JULIAN_CENTURY;var s=x+t*(M+t*(b+t*P)),l=s*L%d.TWO_PI,c=D+C*(n-2451545.5),f=(i+.5*y.SECONDS_PER_DAY)%y.SECONDS_PER_DAY,m=l+c*f,p=Math.cos(m),E=Math.sin(m);return a(r)?(r[0]=p,r[1]=-E,r[2]=0,r[3]=E,r[4]=p,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new w(p,E,0,-E,p,0,0,0,1)},E.iau2006XysData=new c,E.earthOrientationParameters=u.NONE;var F=32.184,z=2451545;E.preloadIcrfFixed=function(r){var t=r.start.dayNumber,n=r.start.secondsOfDay+F,i=r.stop.dayNumber,a=r.stop.secondsOfDay+F,o=E.iau2006XysData.preload(t,n,i,a),u=E.earthOrientationParameters.getPromiseToLoad();return e.all([o,u])},E.computeIcrfToFixedMatrix=function(e,r){if(!a(e))throw new o("date is required.");a(r)||(r=new w);var t=E.computeFixedToIcrfMatrix(e,r);return a(t)?w.transpose(t,r):void 0};var B=new f(0,0,0),G=new s(0,0,0,0,0,0),W=new w,H=new w;E.computeFixedToIcrfMatrix=function(e,r){if(!a(e))throw new o("date is required.");a(r)||(r=new w);var t=E.earthOrientationParameters.compute(e,G);if(!a(t))return void 0;var n=e.dayNumber,i=e.secondsOfDay+F,u=E.iau2006XysData.computeXysRadians(n,i,B);if(!a(u))return void 0;var s=u.x+t.xPoleOffset,l=u.y+t.yPoleOffset,c=1/(1+Math.sqrt(1-s*s-l*l)),f=W;f[0]=1-c*s*s,f[3]=-c*s*l,f[6]=s,f[1]=-c*s*l,f[4]=1-c*l*l,f[7]=l,f[2]=-s,f[5]=-l,f[8]=1-c*(s*s+l*l);var m=w.fromRotationZ(-u.s,H),p=w.multiply(f,m,W),v=e.dayNumber,_=e.secondsOfDay-h.computeTaiMinusUtc(e)+t.ut1MinusUtc,T=v-2451545,g=_/y.SECONDS_PER_DAY,R=.779057273264+g+.00273781191135448*(T+g);R=R%1*d.TWO_PI;var A=w.fromRotationZ(R,H),S=w.multiply(p,A,W),N=Math.cos(t.xPoleWander),I=Math.cos(t.yPoleWander),O=Math.sin(t.xPoleWander),q=Math.sin(t.yPoleWander),x=n-z+i/y.SECONDS_PER_DAY;x/=36525;var M=-47e-6*x*d.RADIANS_PER_DEGREE/3600,b=Math.cos(M),P=Math.sin(M),C=H;return C[0]=N*b,C[1]=N*P,C[2]=O,C[3]=-I*P+q*O*b,C[4]=I*b+q*O*P,C[5]=-q*N,C[6]=-q*P-I*O*b,C[7]=q*b-I*O*P,C[8]=I*N,w.multiply(S,C,r)};var V=new n;E.pointToWindowCoordinates=function(e,r,t,n){return n=E.pointToGLWindowCoordinates(e,r,t,n),n.y=2*r[5]-n.y,n},E.pointToGLWindowCoordinates=function(e,t,i,u){if(!a(e))throw new o("modelViewProjectionMatrix is required.");if(!a(t))throw new o("viewportTransformation is required.");if(!a(i))throw new o("point is required.");a(u)||(u=new r);var s=V;return m.multiplyByVector(e,n.fromElements(i.x,i.y,i.z,1,s),s),n.multiplyByScalar(s,1/s.w,s),m.multiplyByVector(t,s,s),r.fromCartesian4(s,u)};var X=new t,Y=new t,k=new t;return E.rotationMatrixFromPositionVelocity=function(e,r,n,u){if(!a(e))throw new o("position is required.");if(!a(r))throw new o("velocity is required.");var s=i(n,l.WGS84).geodeticSurfaceNormal(e,X),c=t.cross(r,s,Y);t.equalsEpsilon(c,t.ZERO,d.EPSILON6)&&(c=t.clone(t.UNIT_X,c));var f=t.cross(c,r,k);return t.cross(r,f,c),t.negate(c,c),a(u)||(u=new w),u[0]=r.x,u[1]=r.y,u[2]=r.z,u[3]=c.x,u[4]=c.y,u[5]=c.z,u[6]=f.x,u[7]=f.y,u[8]=f.z,u},E}),define("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix3","./Matrix4","./Plane","./Ray","./Transforms"],function(e,r,t,n,i,a,o,u,s,l,c,f,h,d,w){"use strict";var m=new n,p=function(e,r){if(!a(e))throw new u("origin is required.");if(r=i(r,s.WGS84),e=r.scaleToGeodeticSurface(e),!a(e))throw new u("origin must not be at the center of the ellipsoid.");
var n=w.eastNorthUpToFixedFrame(e,r);this._ellipsoid=r,this._origin=e,this._xAxis=t.fromCartesian4(f.getColumn(n,0,m)),this._yAxis=t.fromCartesian4(f.getColumn(n,1,m));var o=t.fromCartesian4(f.getColumn(n,2,m));this._plane=h.fromPointNormal(e,o)};o(p.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}},plane:{get:function(){return this._plane}},xAxis:{get:function(){return this._xAxis}},yAxis:{get:function(){return this._yAxis}},zAxis:{get:function(){return this._plane.normal}}});var y=new e;p.fromPoints=function(r,t){if(!a(r))throw new u("cartesians is required.");var n=e.fromPoints(r,y);return new p(n.center,t)};var E=new d,v=new t;p.prototype.projectPointOntoPlane=function(e,n){if(!a(e))throw new u("cartesian is required.");var i=E;i.origin=e,t.normalize(e,i.direction);var o=l.rayPlane(i,this._plane,v);if(a(o)||(t.negate(i.direction,i.direction),o=l.rayPlane(i,this._plane,v)),a(o)){var s=t.subtract(o,this._origin,o),c=t.dot(this._xAxis,s),f=t.dot(this._yAxis,s);return a(n)?(n.x=c,n.y=f,n):new r(c,f)}return void 0},p.prototype.projectPointsOntoPlane=function(e,r){if(!a(e))throw new u("cartesians is required.");a(r)||(r=[]);for(var t=0,n=e.length,i=0;n>i;i++){var o=this.projectPointOntoPlane(e[i],r[t]);a(o)&&(r[t]=o,t++)}return r.length=t,r},p.prototype.projectPointToNearestOnPlane=function(e,n){if(!a(e))throw new u("cartesian is required.");a(n)||(n=new r);var i=E;i.origin=e,t.clone(this._plane.normal,i.direction);var o=l.rayPlane(i,this._plane,v);a(o)||(t.negate(i.direction,i.direction),o=l.rayPlane(i,this._plane,v));var s=t.subtract(o,this._origin,o),c=t.dot(this._xAxis,s),f=t.dot(this._yAxis,s);return n.x=c,n.y=f,n},p.prototype.projectPointsToNearestOnPlane=function(e,r){if(!a(e))throw new u("cartesians is required.");a(r)||(r=[]);var t=e.length;r.length=t;for(var n=0;t>n;n++)r[n]=this.projectPointToNearestOnPlane(e[n],r[n]);return r};var _=new t;return p.prototype.projectPointsOntoEllipsoid=function(e,r){if(!a(e))throw new u("cartesians is required.");var n=e.length;a(r)?r.length=n:r=new Array(n);for(var i=this._ellipsoid,o=this._origin,s=this._xAxis,l=this._yAxis,c=_,f=0;n>f;++f){var h=e[f];t.multiplyByScalar(s,h.x,c),a(r[f])||(r[f]=new t);var d=t.add(o,c,r[f]);t.multiplyByScalar(l,h.y,c),t.add(d,c,d),i.scaleToGeocentricSurface(d,d)}return r},p}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var r={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(r)}),define("Core/PrimitiveType",["../Renderer/WebGLConstants","./freezeObject"],function(e,r){"use strict";var t={POINTS:e.POINTS,LINES:e.LINES,LINE_LOOP:e.LINE_LOOP,LINE_STRIP:e.LINE_STRIP,TRIANGLES:e.TRIANGLES,TRIANGLE_STRIP:e.TRIANGLE_STRIP,TRIANGLE_FAN:e.TRIANGLE_FAN,validate:function(e){return e===t.POINTS||e===t.LINES||e===t.LINE_LOOP||e===t.LINE_STRIP||e===t.TRIANGLES||e===t.TRIANGLE_STRIP||e===t.TRIANGLE_FAN}};return r(t)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,r,t,n,i){"use strict";var a=function(a){if(a=e(a,e.EMPTY_OBJECT),!r(a.attributes))throw new t("options.attributes is required.");this.attributes=a.attributes,this.indices=a.indices,this.primitiveType=e(a.primitiveType,i.TRIANGLES),this.boundingSphere=a.boundingSphere,this.geometryType=e(a.geometryType,n.NONE),this.boundingSphereCV=void 0};return a.computeNumberOfVertices=function(e){if(!r(e))throw new t("geometry is required.");var n=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&r(e.attributes[i])&&r(e.attributes[i].values)){var a=e.attributes[i],o=a.values.length/a.componentsPerAttribute;if(n!==o&&-1!==n)throw new t("All attribute lists must have the same number of attributes.");n=o}return n},a}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.componentDatatype))throw new t("options.componentDatatype is required.");if(!r(n.componentsPerAttribute))throw new t("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new t("options.componentsPerAttribute must be between 1 and 4.");if(!r(n.values))throw new t("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values};return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var r=function(r){r=e(r,e.EMPTY_OBJECT),this.position=r.position,this.normal=r.normal,this.st=r.st,this.binormal=r.binormal,this.tangent=r.tangent,this.color=r.color};return r}),define("Core/GeometryInstance",["./defaultValue","./defined","./DeveloperError","./Matrix4"],function(e,r,t,n){"use strict";var i=function(i){if(i=e(i,e.EMPTY_OBJECT),!r(i.geometry))throw new t("options.geometry is required.");this.geometry=i.geometry,this.modelMatrix=n.clone(e(i.modelMatrix,n.IDENTITY)),this.id=i.id,this.pickPrimitive=i.pickPrimitive,this.attributes=e(i.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0};return i}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,r,t,n,i){"use strict";var a={};a.octEncode=function(e,a){if(!t(e))throw new n("vector is required.");if(!t(a))throw new n("result is required.");var o=r.magnitudeSquared(e);if(Math.abs(o-1)>i.EPSILON6)throw new n("vector must be normalized.");if(a.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),a.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var u=a.x,s=a.y;a.x=(1-Math.abs(s))*i.signNotZero(u),a.y=(1-Math.abs(u))*i.signNotZero(s)}return a.x=i.toSNorm(a.x),a.y=i.toSNorm(a.y),a},a.octDecode=function(e,a,o){if(!t(o))throw new n("result is required.");if(0>e||e>255||0>a||a>255)throw new n("x and y must be a signed normalized integer between 0 and 255");if(o.x=i.fromSNorm(e),o.y=i.fromSNorm(a),o.z=1-(Math.abs(o.x)+Math.abs(o.y)),o.z<0){var u=o.x;o.x=(1-Math.abs(o.y))*i.signNotZero(u),o.y=(1-Math.abs(u))*i.signNotZero(o.y)}return r.normalize(o,o)},a.octPackFloat=function(e){if(!t(e))throw new n("encoded is required.");return 256*e.x+e.y};var o=new e;return a.octEncodeFloat=function(e){return a.octEncode(e,o),a.octPackFloat(o)},a.octDecodeFloat=function(e,r){if(!t(e))throw new n("value is required.");var i=e/256,o=Math.floor(i),u=256*(i-o);return a.octDecode(o,u,r)},a.octPack=function(e,r,i,u){if(!t(e))throw new n("v1 is required.");if(!t(r))throw new n("v2 is required.");if(!t(i))throw new n("v3 is required.");if(!t(u))throw new n("result is required.");var s=a.octEncodeFloat(e),l=a.octEncodeFloat(r),c=a.octEncode(i,o);return u.x=65536*c.x+s,u.y=65536*c.y+l,u},a.octUnpack=function(e,r,i,o){if(!t(e))throw new n("packed is required.");if(!t(r))throw new n("v1 is required.");if(!t(i))throw new n("v2 is required.");if(!t(o))throw new n("v3 is required.");var u=e.x/65536,s=Math.floor(u),l=65536*(u-s);u=e.y/65536;var c=Math.floor(u),f=65536*(u-c);a.octDecodeFloat(l,r),a.octDecodeFloat(f,i),a.octDecode(s,c,o)},a.compressTextureCoordinates=function(e){if(!t(e))throw new n("textureCoordinates is required.");var r=1===e.x?4095:4096*e.x|0,i=1===e.y?4095:4096*e.y|0;return 4096*r+i},a.decompressTextureCoordinates=function(e,r){if(!t(e))throw new n("compressed is required.");if(!t(r))throw new n("result is required.");var i=e/4096;return r.x=Math.floor(i)/4096,r.y=i-Math.floor(i),r},a}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i=new r,a=new r,o=new r,u=function(u,s,l,c,f){if(!(t(u)&&t(s)&&t(l)&&t(c)))throw new n("point, p0, p1, and p2 are required.");t(f)||(f=new r);var h,d,w,m,p,y,E,v;t(s.z)?(h=r.subtract(l,s,i),d=r.subtract(c,s,a),w=r.subtract(u,s,o),m=r.dot(h,h),p=r.dot(h,d),y=r.dot(h,w),E=r.dot(d,d),v=r.dot(d,w)):(h=e.subtract(l,s,i),d=e.subtract(c,s,a),w=e.subtract(u,s,o),m=e.dot(h,h),p=e.dot(h,d),y=e.dot(h,w),E=e.dot(d,d),v=e.dot(d,w));var _=1/(m*E-p*p);return f.y=(E*y-p*v)*_,f.z=(m*v-p*y)*_,f.x=1-f.y-f.z,f};return u}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)};n.encode=function(e,n){if(!r(e))throw new t("value is required");r(n)||(n={high:0,low:0});var i;return e>=0?(i=65536*Math.floor(e/65536),n.high=i,n.low=e-i):(i=65536*Math.floor(-e/65536),n.high=-i,n.low=e+i),n};var i={high:0,low:0};n.fromCartesian=function(e,a){if(!r(e))throw new t("cartesian is required");r(a)||(a=new n);var o=a.high,u=a.low;return n.encode(e.x,i),o.x=i.high,u.x=i.low,n.encode(e.y,i),o.y=i.high,u.y=i.low,n.encode(e.z,i),o.z=i.high,u.z=i.low,a};var a=new n;return n.writeElements=function(e,i,o){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("cartesianArray is required");if("number"!=typeof o||0>o)throw new t("index must be a number greater than or equal to 0.");n.fromCartesian(e,a);var u=a.high,s=a.low;i[o]=u.x,i[o+1]=u.y,i[o+2]=u.z,i[o+3]=s.x,i[o+4]=s.y,i[o+5]=s.z},n}),define("Core/IndexDatatype",["../Renderer/WebGLConstants","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var a={UNSIGNED_BYTE:e.UNSIGNED_BYTE,UNSIGNED_SHORT:e.UNSIGNED_SHORT,UNSIGNED_INT:e.UNSIGNED_INT};return a.getSizeInBytes=function(e){switch(e){case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},a.validate=function(e){return r(e)&&(e===a.UNSIGNED_BYTE||e===a.UNSIGNED_SHORT||e===a.UNSIGNED_INT)},a.createTypedArray=function(e,n){if(!r(e))throw new t("numberOfVertices is required.");return e>=i.SIXTY_FOUR_KILOBYTES?new Uint32Array(n):new Uint16Array(n)},a.createTypedArrayFromArrayBuffer=function(e,n,a,o){if(!r(e))throw new t("numberOfVertices is required.");if(!r(n))throw new t("sourceArray is required.");if(!r(a))throw new t("byteOffset is required.");return e>=i.SIXTY_FOUR_KILOBYTES?new Uint32Array(n,a,o):new Uint16Array(n,a,o)},n(a)}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n={};return n.calculateACMR=function(n){n=e(n,e.EMPTY_OBJECT);var i=n.indices,a=n.maximumIndex,o=e(n.cacheSize,24);if(!r(i))throw new t("indices is required.");var u=i.length;if(3>u||u%3!==0)throw new t("indices length must be a multiple of three.");if(0>=a)throw new t("maximumIndex must be greater than zero.");if(3>o)throw new t("cacheSize must be greater than two.");if(!r(a)){a=0;for(var s=0,l=i[s];u>s;)l>a&&(a=l),++s,l=i[s]}for(var c=[],f=0;a+1>f;f++)c[f]=0;for(var h=o+1,d=0;u>d;++d)h-c[i[d]]>o&&(c[i[d]]=h,++h);return(h-o+1)/(u/3)},n.tipsify=function(n){function i(e,r,t,n){for(;r.length>=1;){var i=r[r.length-1];if(r.splice(r.length-1,1),e[i].numLiveTriangles>0)return i}for(;n>o;){if(e[o].numLiveTriangles>0)return++o,o-1;++o}return-1}function a(e,r,t,n,a,o,u){for(var s,l=-1,c=-1,f=0;f<t.length;){var h=t[f];n[h].numLiveTriangles&&(s=0,a-n[h].timeStamp+2*n[h].numLiveTriangles<=r&&(s=a-n[h].timeStamp),(s>c||-1===c)&&(c=s,l=h)),++f}return-1===l?i(n,o,e,u):l}n=e(n,e.EMPTY_OBJECT);var o,u=n.indices,s=n.maximumIndex,l=e(n.cacheSize,24);if(!r(u))throw new t("indices is required.");var c=u.length;if(3>c||c%3!==0)throw new t("indices length must be a multiple of three.");if(0>=s)throw new t("maximumIndex must be greater than zero.");if(3>l)throw new t("cacheSize must be greater than two.");var f=0,h=0,d=u[h],w=c;if(r(s))f=s+1;else{for(;w>h;)d>f&&(f=d),++h,d=u[h];if(-1===f)return 0;++f}for(var m=[],p=0;f>p;p++)m[p]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};h=0;for(var y=0;w>h;)m[u[h]].vertexTriangles.push(y),++m[u[h]].numLiveTriangles,m[u[h+1]].vertexTriangles.push(y),++m[u[h+1]].numLiveTriangles,m[u[h+2]].vertexTriangles.push(y),++m[u[h+2]].numLiveTriangles,++y,h+=3;var E=0,v=l+1;o=1;var _,T,g=[],R=[],A=0,S=[],N=c/3,I=[];for(p=0;N>p;p++)I[p]=!1;for(var O,q;-1!==E;){g=[],T=m[E],q=T.vertexTriangles.length;for(var x=0;q>x;++x)if(y=T.vertexTriangles[x],!I[y]){I[y]=!0,h=y+y+y;for(var M=0;3>M;++M)O=u[h],g.push(O),R.push(O),S[A]=O,++A,_=m[O],--_.numLiveTriangles,v-_.timeStamp>l&&(_.timeStamp=v,++v),++h}E=a(u,l,g,m,v,R,f)}return S},n}),define("Core/GeometryPipeline",["./AttributeCompression","./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryInstance","./GeometryType","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],function(e,r,t,n,i,a,o,u,s,l,c,f,h,d,w,m,p,y,E,v,_,T,g,R,A,S){"use strict";function N(e,r,t,n,i){e[r++]=t,e[r++]=n,e[r++]=n,e[r++]=i,e[r++]=i,e[r]=t}function I(e){for(var r=e.length,t=r/3*6,n=y.createTypedArray(r,t),i=0,a=0;r>a;a+=3,i+=6)N(n,i,e[a],e[a+1],e[a+2]);return n}function O(e){var r=e.length;if(r>=3){var t=6*(r-2),n=y.createTypedArray(r,t);N(n,0,e[0],e[1],e[2]);for(var i=6,a=3;r>a;++a,i+=6)N(n,i,e[a-1],e[a],e[a-2]);return n}return new Uint16Array}function q(e){if(e.length>0){for(var r=e.length-1,t=6*(r-1),n=y.createTypedArray(r,t),i=e[0],a=0,o=1;r>o;++o,a+=6)N(n,a,i,e[o],e[o+1]);return n}return new Uint16Array}function x(e){var r={};for(var t in e)if(e.hasOwnProperty(t)&&l(e[t])&&l(e[t].values)){var n=e[t];r[t]=new w({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return r}function M(e,r,t){for(var n in r)if(r.hasOwnProperty(n)&&l(r[n])&&l(r[n].values))for(var i=r[n],a=0;a<i.componentsPerAttribute;++a)e[n].values.push(i.values[t*i.componentsPerAttribute+a])}function b(e,r){if(l(r))for(var t=r.values,n=t.length,a=0;n>a;a+=3)i.unpack(t,a,ae),g.multiplyByPoint(e,ae,ae),i.pack(ae,t,a)}function P(e,r){if(l(r))for(var t=r.values,n=t.length,a=0;n>a;a+=3)i.unpack(t,a,ae),T.multiplyByVector(e,ae,ae),ae=i.normalize(ae,ae),i.pack(ae,t,a)}function C(e,r){var t,n=e.length,i={},a=e[0][r].attributes;for(t in a)if(a.hasOwnProperty(t)&&l(a[t])&&l(a[t].values)){for(var o=a[t],s=o.values.length,c=!0,f=1;n>f;++f){var h=e[f][r].attributes[t];if(!l(h)||o.componentDatatype!==h.componentDatatype||o.componentsPerAttribute!==h.componentsPerAttribute||o.normalize!==h.normalize){c=!1;break}s+=h.values.length}c&&(i[t]=new w({componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,values:u.createTypedArray(o.componentDatatype,s)}))}return i}function D(e,r){var n,a,o,u,s=e.length,f=e[0].modelMatrix,h=l(e[0][r].indices),w=e[0][r].primitiveType;for(a=1;s>a;++a){if(!g.equals(e[a].modelMatrix,f))throw new c("All instances must have the same modelMatrix.");if(l(e[a][r].indices)!==h)throw new c("All instance geometries must have an indices or not have one.");if(e[a][r].primitiveType!==w)throw new c("All instance geometries must have the same primitiveType.")}var m,p,E,v=C(e,r);for(n in v)if(v.hasOwnProperty(n))for(m=v[n].values,u=0,a=0;s>a;++a)for(p=e[a][r].attributes[n].values,E=p.length,o=0;E>o;++o)m[u++]=p[o];var _;if(h){var T=0;for(a=0;s>a;++a)T+=e[a][r].indices.length;var R=d.computeNumberOfVertices(new d({attributes:v,primitiveType:A.POINTS})),S=y.createTypedArray(R,T),N=0,I=0;for(a=0;s>a;++a){var O=e[a][r].indices,q=O.length;for(u=0;q>u;++u)S[N++]=I+O[u];I+=d.computeNumberOfVertices(e[a][r])}_=S}var x,M=new i,b=0;for(a=0;s>a;++a){if(x=e[a][r].boundingSphere,!l(x)){M=void 0;break}i.add(x.center,M,M)}if(l(M))for(i.divideByScalar(M,s,M),a=0;s>a;++a){x=e[a][r].boundingSphere;var P=i.magnitude(i.subtract(x.center,M,se))+x.radius;P>b&&(b=P)}return new d({attributes:v,indices:_,primitiveType:w,boundingSphere:l(M)?new t(M,b):void 0})}function L(e){if(l(e.indices))return e;var r=d.computeNumberOfVertices(e);if(3>r)throw new c("The number of vertices must be at least three.");if(r%3!==0)throw new c("The number of vertices must be a multiple of three.");for(var t=y.createTypedArray(r,r),n=0;r>n;++n)t[n]=n;return e.indices=t,e}function U(e){var r=d.computeNumberOfVertices(e);if(3>r)throw new c("The number of vertices must be at least three.");var t=y.createTypedArray(r,3*(r-2));t[0]=1,t[1]=0,t[2]=2;for(var n=3,i=3;r>i;++i)t[n++]=i-1,t[n++]=0,t[n++]=i;return e.indices=t,e.primitiveType=A.TRIANGLES,e}function F(e){var r=d.computeNumberOfVertices(e);if(3>r)throw new c("The number of vertices must be at least 3.");var t=y.createTypedArray(r,3*(r-2));t[0]=0,t[1]=1,t[2]=2,r>3&&(t[3]=0,t[4]=2,t[5]=3);for(var n=6,i=3;r-1>i;i+=2)t[n++]=i,t[n++]=i-1,t[n++]=i+1,r>i+2&&(t[n++]=i,t[n++]=i+1,t[n++]=i+2);return e.indices=t,e.primitiveType=A.TRIANGLES,e}function z(e){if(l(e.indices))return e;var r=d.computeNumberOfVertices(e);if(2>r)throw new c("The number of vertices must be at least two.");if(r%2!==0)throw new c("The number of vertices must be a multiple of 2.");for(var t=y.createTypedArray(r,r),n=0;r>n;++n)t[n]=n;return e.indices=t,e}function B(e){var r=d.computeNumberOfVertices(e);if(2>r)throw new c("The number of vertices must be at least two.");var t=y.createTypedArray(r,2*(r-1));t[0]=0,t[1]=1;for(var n=2,i=2;r>i;++i)t[n++]=i-1,t[n++]=i;return e.indices=t,e.primitiveType=A.LINES,e}function G(e){var r=d.computeNumberOfVertices(e);if(2>r)throw new c("The number of vertices must be at least two.");var t=y.createTypedArray(r,2*r);t[0]=0,t[1]=1;for(var n=2,i=2;r>i;++i)t[n++]=i-1,t[n++]=i;return t[n++]=r-1,t[n]=0,e.indices=t,e.primitiveType=A.LINES,e}function W(e){switch(e.primitiveType){case A.TRIANGLE_FAN:return U(e);case A.TRIANGLE_STRIP:return F(e);case A.TRIANGLES:return L(e);case A.LINE_STRIP:return B(e);case A.LINE_LOOP:return G(e);case A.LINES:return z(e)}return e}function H(e,r){Math.abs(e.y)<_.EPSILON6&&(r?e.y=-_.EPSILON6:e.y=_.EPSILON6)}function V(e,r,t){if(0!==e.y&&0!==r.y&&0!==t.y)return H(e,e.y<0),H(r,r.y<0),void H(t,t.y<0);var n,i=Math.abs(e.y),a=Math.abs(r.y),o=Math.abs(t.y);n=i>a?i>o?_.sign(e.y):_.sign(t.y):a>o?_.sign(r.y):_.sign(t.y);var u=0>n;H(e,u),H(r,u),H(t,u)}function X(e,r,t,n){i.add(e,i.multiplyByScalar(i.subtract(r,e,_e),e.y/(e.y-r.y),_e),t),i.clone(t,n),H(t,!0),H(n,!1)}function Y(e,r,t){if(e.x>=0||r.x>=0||t.x>=0)return void 0;V(e,r,t);var n=e.y<0,i=r.y<0,a=t.y<0,o=0;o+=n?1:0,o+=i?1:0,o+=a?1:0;var u=Se.indices;1===o?(u[1]=3,u[2]=4,u[5]=6,u[7]=6,u[8]=5,n?(X(e,r,Te,Re),X(e,t,ge,Ae),u[0]=0,u[3]=1,u[4]=2,u[6]=1):i?(X(r,t,Te,Re),X(r,e,ge,Ae),u[0]=1,u[3]=2,u[4]=0,u[6]=2):a&&(X(t,e,Te,Re),X(t,r,ge,Ae),u[0]=2,u[3]=0,u[4]=1,u[6]=0)):2===o&&(u[2]=4,u[4]=4,u[5]=3,u[7]=5,u[8]=6,n?i?a||(X(t,e,Te,Re),X(t,r,ge,Ae),u[0]=0,u[1]=1,u[3]=0,u[6]=2):(X(r,t,Te,Re),X(r,e,ge,Ae),u[0]=2,u[1]=0,u[3]=2,u[6]=1):(X(e,r,Te,Re),X(e,t,ge,Ae),u[0]=1,u[1]=2,u[3]=1,u[6]=0));var s=Se.positions;return s[0]=e,s[1]=r,s[2]=t,s.length=3,(1===o||2===o)&&(s[3]=Te,s[4]=ge,s[5]=Re,s[6]=Ae,s.length=7),Se}function k(e,r){var n=e.attributes;if(0===n.position.values.length)return void 0;for(var i in n)if(n.hasOwnProperty(i)&&l(n[i])&&l(n[i].values)){var a=n[i];a.values=u.createTypedArray(a.componentDatatype,a.values)}var o=d.computeNumberOfVertices(e);return e.indices=y.createTypedArray(o,e.indices),r&&(e.boundingSphere=t.fromVertices(n.position.values)),e}function j(e){var r=e.attributes,t={};for(var n in r)if(r.hasOwnProperty(n)&&l(r[n])&&l(r[n].values)){var i=r[n];t[n]=new w({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]})}return new d({attributes:t,indices:[],primitiveType:e.primitiveType})}function Z(e,r,t){var n=l(e.geometry.boundingSphere);r=k(r,n),t=k(t,n),l(t)&&!l(r)?e.geometry=t:!l(t)&&l(r)?e.geometry=r:(e.westHemisphereGeometry=r,e.eastHemisphereGeometry=t,e.geometry=void 0)}function K(e,t,a,o,u,s,c,f,h,d,w){if(l(s)||l(c)||l(f)||l(h)){var m=i.fromArray(u,3*e,Ne),p=i.fromArray(u,3*t,Ie),y=i.fromArray(u,3*a,Oe),E=r(o,m,p,y,qe);if(l(s)){var v=i.fromArray(s,3*e,Ne),_=i.fromArray(s,3*t,Ie),T=i.fromArray(s,3*a,Oe);i.multiplyByScalar(v,E.x,v),i.multiplyByScalar(_,E.y,_),i.multiplyByScalar(T,E.z,T);var g=i.add(v,_,v);i.add(g,T,g),i.normalize(g,g),i.pack(g,d.normal.values,3*w)}if(l(c)){var R=i.fromArray(c,3*e,Ne),A=i.fromArray(c,3*t,Ie),S=i.fromArray(c,3*a,Oe);i.multiplyByScalar(R,E.x,R),i.multiplyByScalar(A,E.y,A),i.multiplyByScalar(S,E.z,S);var N=i.add(R,A,R);i.add(N,S,N),i.normalize(N,N),i.pack(N,d.binormal.values,3*w)}if(l(f)){var I=i.fromArray(f,3*e,Ne),O=i.fromArray(f,3*t,Ie),q=i.fromArray(f,3*a,Oe);i.multiplyByScalar(I,E.x,I),i.multiplyByScalar(O,E.y,O),i.multiplyByScalar(q,E.z,q);var x=i.add(I,O,I);i.add(x,q,x),i.normalize(x,x),i.pack(x,d.tangent.values,3*w)}if(l(h)){var M=n.fromArray(h,2*e,xe),b=n.fromArray(h,2*t,Me),P=n.fromArray(h,2*a,be);n.multiplyByScalar(M,E.x,M),n.multiplyByScalar(b,E.y,b),n.multiplyByScalar(P,E.z,P);var C=n.add(M,b,M);n.add(C,P,C),n.pack(C,d.st.values,2*w)}}}function J(e,r,t,n,i,a){var o=e.position.values.length/3;if(-1!==i){var u=n[i],s=t[u];return-1===s?(t[u]=o,e.position.values.push(a.x,a.y,a.z),r.push(o),o):(r.push(s),s)}return e.position.values.push(a.x,a.y,a.z),r.push(o),o}function Q(e){var r,t,n,a,o,u=e.geometry,s=u.attributes,c=s.position.values,f=l(s.normal)?s.normal.values:void 0,h=l(s.binormal)?s.binormal.values:void 0,d=l(s.tangent)?s.tangent.values:void 0,w=l(s.st)?s.st.values:void 0,m=u.indices,p=j(u),y=j(u),E=[];E.length=c.length/3;var v=[];for(v.length=c.length/3,o=0;o<E.length;++o)E[o]=-1,v[o]=-1;var _=m.length;for(o=0;_>o;o+=3){var T=m[o],g=m[o+1],R=m[o+2],A=i.fromArray(c,3*T),S=i.fromArray(c,3*g),N=i.fromArray(c,3*R),I=Y(A,S,N);if(l(I)&&I.positions.length>3)for(var O=I.positions,q=I.indices,x=q.length,M=0;x>M;++M){var b=q[M],P=O[b];P.y<0?(r=y.attributes,t=y.indices,n=E):(r=p.attributes,t=p.indices,n=v),a=J(r,t,n,m,3>b?o+b:-1,P),K(T,g,R,P,c,f,h,d,w,r,a)}else l(I)&&(A=I.positions[0],S=I.positions[1],N=I.positions[2]),A.y<0?(r=y.attributes,t=y.indices,n=E):(r=p.attributes,t=p.indices,n=v),a=J(r,t,n,m,o,A),K(T,g,R,A,c,f,h,d,w,r,a),a=J(r,t,n,m,o+1,S),K(T,g,R,S,c,f,h,d,w,r,a),a=J(r,t,n,m,o+2,N),K(T,g,R,N,c,f,h,d,w,r,a)}Z(e,y,p)}function $(e){var r,t=e.geometry,n=t.attributes,a=n.position.values,o=t.indices,u=j(t),s=j(t),c=o.length,f=[];f.length=a.length/3;var h=[];for(h.length=a.length/3,r=0;r<f.length;++r)f[r]=-1,h[r]=-1;for(r=0;c>r;r+=2){var d=o[r],w=o[r+1],m=i.fromArray(a,3*d,Ne),p=i.fromArray(a,3*w,Ie);Math.abs(m.y)<_.EPSILON6&&(m.y<0?m.y=-_.EPSILON6:m.y=_.EPSILON6),Math.abs(p.y)<_.EPSILON6&&(p.y<0?p.y=-_.EPSILON6:p.y=_.EPSILON6);var y=u.attributes,E=u.indices,T=h,g=s.attributes,R=s.indices,A=f,S=v.lineSegmentPlane(m,p,Pe,Oe);if(l(S)){var N=i.multiplyByScalar(i.UNIT_Y,5*_.EPSILON9,Ce);m.y<0&&(i.negate(N,N),y=s.attributes,E=s.indices,T=f,g=u.attributes,R=u.indices,A=h);var I=i.add(S,N,De);J(y,E,T,o,r,m),J(y,E,T,o,-1,I),i.negate(N,N),i.add(S,N,I),J(g,R,A,o,-1,I),J(g,R,A,o,r+1,p)}else{var O,q,x;m.y<0?(O=s.attributes,q=s.indices,x=f):(O=u.attributes,q=u.indices,x=h),J(O,q,x,o,r,m),J(O,q,x,o,r+1,p)}}Z(e,s,u)}function ee(e){var r,t,o,u=e.geometry,s=u.attributes,c=s.position.values,f=s.prevPosition.values,h=s.nextPosition.values,d=s.expandAndWidth.values,w=(u.indices,l(s.st)?s.st.values:void 0),m=l(s.color)?s.color.values:void 0,p=j(u),y=j(u),E=c.length/3;for(r=0;E>r;r+=4){var T=r,g=r+1,R=r+2,A=r+3,S=i.fromArray(c,3*T,Fe),N=i.fromArray(c,3*g,ze),I=i.fromArray(c,3*R,Be),O=i.fromArray(c,3*A,Ge);Math.abs(S.y)<_.EPSILON6&&(S.y=_.EPSILON6*(I.y<0?-1:1),N.y=S.y),Math.abs(I.y)<_.EPSILON6&&(I.y=_.EPSILON6*(S.y<0?-1:1),O.y=I.y);var q=p.attributes,x=p.indices,M=y.attributes,b=y.indices,P=v.lineSegmentPlane(S,I,Pe,We);if(l(P)){var C=i.multiplyByScalar(i.UNIT_Y,5*_.EPSILON9,He);S.y<0&&(i.negate(C,C),q=y.attributes,x=y.indices,M=p.attributes,b=p.indices);var D=i.add(P,C,Ve);for(q.position.values.push(S.x,S.y,S.z,N.x,N.y,N.z),q.position.values.push(D.x,D.y,D.z),q.position.values.push(D.x,D.y,D.z),i.negate(C,C),i.add(P,C,D),M.position.values.push(D.x,D.y,D.z),M.position.values.push(D.x,D.y,D.z),M.position.values.push(I.x,I.y,I.z,O.x,O.y,O.z),t=3*T;3*T+6>t;++t)q.prevPosition.values.push(f[t]);for(q.prevPosition.values.push(S.x,S.y,S.z,S.x,S.y,S.z),M.prevPosition.values.push(S.x,S.y,S.z,S.x,S.y,S.z),t=3*R;3*R+6>t;++t)M.prevPosition.values.push(f[t]);for(t=3*T;3*T+6>t;++t)q.nextPosition.values.push(h[t]);for(q.nextPosition.values.push(I.x,I.y,I.z,I.x,I.y,I.z),M.nextPosition.values.push(I.x,I.y,I.z,I.x,I.y,I.z),t=3*R;3*R+6>t;++t)M.nextPosition.values.push(h[t]);var L=n.fromArray(d,2*T,Le),U=Math.abs(L.y);q.expandAndWidth.values.push(-1,U,1,U),q.expandAndWidth.values.push(-1,-U,1,-U),M.expandAndWidth.values.push(-1,U,1,U),M.expandAndWidth.values.push(-1,-U,1,-U);var F=i.magnitudeSquared(i.subtract(P,S,Ge));if(F/=i.magnitudeSquared(i.subtract(I,S,Ge)),l(m)){var z=a.fromArray(m,4*T,Xe),B=a.fromArray(m,4*R,Xe),G=_.lerp(z.x,B.x,F),W=_.lerp(z.y,B.y,F),H=_.lerp(z.z,B.z,F),V=_.lerp(z.w,B.w,F);for(t=4*T;4*T+8>t;++t)q.color.values.push(m[t]);for(q.color.values.push(G,W,H,V),q.color.values.push(G,W,H,V),M.color.values.push(G,W,H,V),M.color.values.push(G,W,H,V),t=4*R;4*R+8>t;++t)M.color.values.push(m[t])}if(l(w)){var X=n.fromArray(w,2*T,Le),Y=n.fromArray(w,2*(r+3),Ue),k=_.lerp(X.x,Y.x,F);for(t=2*T;2*T+4>t;++t)q.st.values.push(w[t]);for(q.st.values.push(k,X.y),q.st.values.push(k,Y.y),M.st.values.push(k,X.y),M.st.values.push(k,Y.y),t=2*R;2*R+4>t;++t)M.st.values.push(w[t])}o=q.position.values.length/3-4,x.push(o,o+2,o+1),x.push(o+1,o+2,o+3),o=M.position.values.length/3-4,b.push(o,o+2,o+1),b.push(o+1,o+2,o+3)}else{var K,J;for(S.y<0?(K=y.attributes,J=y.indices):(K=p.attributes,J=p.indices),K.position.values.push(S.x,S.y,S.z),K.position.values.push(N.x,N.y,N.z),K.position.values.push(I.x,I.y,I.z),K.position.values.push(O.x,O.y,O.z),t=3*r;3*r+12>t;++t)K.prevPosition.values.push(f[t]),K.nextPosition.values.push(h[t]);for(t=2*r;2*r+8>t;++t)K.expandAndWidth.values.push(d[t]),l(w)&&K.st.values.push(w[t]);if(l(m))for(t=4*r;4*r+16>t;++t)K.color.values.push(m[t]);o=K.position.values.length/3-4,J.push(o,o+2,o+1),J.push(o+1,o+2,o+3)}}Z(e,y,p)}var re={};re.toWireframe=function(e){if(!l(e))throw new c("geometry is required.");var r=e.indices;if(l(r)){switch(e.primitiveType){case A.TRIANGLES:e.indices=I(r);break;case A.TRIANGLE_STRIP:e.indices=O(r);break;case A.TRIANGLE_FAN:e.indices=q(r);break;default:throw new c("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=A.LINES}return e},re.createLineSegmentsForVectors=function(e,r,n){if(r=s(r,"normal"),!l(e))throw new c("geometry is required.");if(!l(e.attributes.position))throw new c("geometry.attributes.position is required.");if(!l(e.attributes[r]))throw new c("geometry.attributes must have an attribute with the same name as the attributeName parameter, "+r+".");n=s(n,1e4);for(var i=e.attributes.position.values,a=e.attributes[r].values,o=i.length,f=new Float64Array(2*o),h=0,m=0;o>m;m+=3)f[h++]=i[m],f[h++]=i[m+1],f[h++]=i[m+2],f[h++]=i[m]+a[m]*n,f[h++]=i[m+1]+a[m+1]*n,f[h++]=i[m+2]+a[m+2]*n;var p,y=e.boundingSphere;return l(y)&&(p=new t(y.center,y.radius+n)),new d({attributes:{position:new w({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:f})},primitiveType:A.LINES,boundingSphere:p})},re.createAttributeLocations=function(e){if(!l(e))throw new c("geometry is required.");var r,t=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent","compressedAttributes"],n=e.attributes,i={},a=0,o=t.length;for(r=0;o>r;++r){var u=t[r];l(n[u])&&(i[u]=a++)}for(var s in n)n.hasOwnProperty(s)&&!l(i[s])&&(i[s]=a++);return i},re.reorderForPreVertexCache=function(e){if(!l(e))throw new c("geometry is required.");var r=d.computeNumberOfVertices(e),t=e.indices;if(l(t)){for(var n=new Int32Array(r),i=0;r>i;i++)n[i]=-1;for(var a,o=t,s=o.length,f=y.createTypedArray(r,s),h=0,w=0,m=0;s>h;)a=n[o[h]],-1!==a?f[w]=a:(a=o[h],n[a]=m,f[w]=m,++m),++h,++w;e.indices=f;var p=e.attributes;for(var E in p)if(p.hasOwnProperty(E)&&l(p[E])&&l(p[E].values)){for(var v=p[E],_=v.values,T=0,g=v.componentsPerAttribute,R=u.createTypedArray(v.componentDatatype,m*g);r>T;){var A=n[T];if(-1!==A)for(i=0;g>i;i++)R[g*A+i]=_[g*T+i];++T}v.values=R}}return e},re.reorderForPostVertexCache=function(e,r){if(!l(e))throw new c("geometry is required.");var t=e.indices;if(e.primitiveType===A.TRIANGLES&&l(t)){for(var n=t.length,i=0,a=0;n>a;a++)t[a]>i&&(i=t[a]);e.indices=S.tipsify({indices:t,maximumIndex:i,cacheSize:r})}return e},re.fitToUnsignedShortIndices=function(e){if(!l(e))throw new c("geometry is required.");if(l(e.indices)&&e.primitiveType!==A.TRIANGLES&&e.primitiveType!==A.LINES&&e.primitiveType!==A.POINTS)throw new c("geometry.primitiveType must equal to PrimitiveType.TRIANGLES, PrimitiveType.LINES, or PrimitiveType.POINTS.");var r=[],t=d.computeNumberOfVertices(e);if(l(e.indices)&&t>=_.SIXTY_FOUR_KILOBYTES){var n,i=[],a=[],o=0,u=x(e.attributes),s=e.indices,f=s.length;e.primitiveType===A.TRIANGLES?n=3:e.primitiveType===A.LINES?n=2:e.primitiveType===A.POINTS&&(n=1);for(var h=0;f>h;h+=n){for(var w=0;n>w;++w){var m=s[h+w],p=i[m];l(p)||(p=o++,i[m]=p,M(u,e.attributes,m)),a.push(p)}o+n>=_.SIXTY_FOUR_KILOBYTES&&(r.push(new d({attributes:u,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),i=[],a=[],o=0,u=x(e.attributes))}0!==a.length&&r.push(new d({attributes:u,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else r.push(e);return r};var te=new i,ne=new o;re.projectTo2D=function(e,r,t,n,a){if(!l(e))throw new c("geometry is required.");if(!l(r))throw new c("attributeName is required.");if(!l(t))throw new c("attributeName3D is required.");if(!l(n))throw new c("attributeName2D is required.");if(!l(e.attributes[r]))throw new c("geometry must have attribute matching the attributeName argument: "+r+".");if(e.attributes[r].componentDatatype!==u.DOUBLE)throw new c("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");var o=e.attributes[r];a=l(a)?a:new h;for(var s=a.ellipsoid,f=o.values,d=new Float64Array(f.length),m=0,p=0;p<f.length;p+=3){var y=i.fromArray(f,p,te),E=s.cartesianToCartographic(y,ne);if(!l(E))throw new c("Could not project point ("+y.x+", "+y.y+", "+y.z+") to 2D.");var v=a.project(E,te);d[m++]=v.x,d[m++]=v.y,d[m++]=v.z}return e.attributes[t]=o,e.attributes[n]=new w({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:d}),delete e.attributes[r],e};var ie={high:0,low:0};re.encodeAttribute=function(e,r,t,n){if(!l(e))throw new c("geometry is required.");if(!l(r))throw new c("attributeName is required.");if(!l(t))throw new c("attributeHighName is required.");if(!l(n))throw new c("attributeLowName is required.");if(!l(e.attributes[r]))throw new c("geometry must have attribute matching the attributeName argument: "+r+".");if(e.attributes[r].componentDatatype!==u.DOUBLE)throw new c("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");for(var i=e.attributes[r],a=i.values,o=a.length,s=new Float32Array(o),h=new Float32Array(o),d=0;o>d;++d)f.encode(a[d],ie),s[d]=ie.high,h[d]=ie.low;var m=i.componentsPerAttribute;return e.attributes[t]=new w({componentDatatype:u.FLOAT,componentsPerAttribute:m,values:s}),e.attributes[n]=new w({componentDatatype:u.FLOAT,componentsPerAttribute:m,values:h}),delete e.attributes[r],e};var ae=new i,oe=new g,ue=new T;re.transformToWorldCoordinates=function(e){if(!l(e))throw new c("instance is required.");var r=e.modelMatrix;if(g.equals(r,g.IDENTITY))return e;var n=e.geometry.attributes;b(r,n.position),b(r,n.prevPosition),b(r,n.nextPosition),(l(n.normal)||l(n.binormal)||l(n.tangent))&&(g.inverse(r,oe),g.transpose(oe,oe),g.getRotation(oe,ue),P(ue,n.normal),P(ue,n.binormal),P(ue,n.tangent));var i=e.geometry.boundingSphere;return l(i)&&(e.geometry.boundingSphere=t.transform(i,r,i)),
e.modelMatrix=g.clone(g.IDENTITY),e};var se=new i;re.combineInstances=function(e){if(!l(e)||e.length<1)throw new c("instances is required and must have length greater than zero.");for(var r=[],t=[],n=e.length,i=0;n>i;++i){var a=e[i];l(a.geometry)?r.push(a):t.push(a)}var o=[];return r.length>0&&o.push(D(r,"geometry")),t.length>0&&(o.push(D(t,"westHemisphereGeometry")),o.push(D(t,"eastHemisphereGeometry"))),o};var le=new i,ce=new i,fe=new i,he=new i;re.computeNormal=function(e){if(!l(e))throw new c("geometry is required.");if(!l(e.attributes.position)||!l(e.attributes.position.values))throw new c("geometry.attributes.position.values is required.");if(!l(e.indices))throw new c("geometry.indices is required.");if(e.indices.length<2||e.indices.length%3!==0)throw new c("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==A.TRIANGLES)throw new c("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var r=e.indices,t=e.attributes,n=t.position.values,a=t.position.values.length/3,o=r.length,s=new Array(a),f=new Array(o/3),h=new Array(o),d=0;a>d;d++)s[d]={indexOffset:0,count:0,currentCount:0};var m=0;for(d=0;o>d;d+=3){var p=r[d],y=r[d+1],E=r[d+2],v=3*p,_=3*y,T=3*E;ce.x=n[v],ce.y=n[v+1],ce.z=n[v+2],fe.x=n[_],fe.y=n[_+1],fe.z=n[_+2],he.x=n[T],he.y=n[T+1],he.z=n[T+2],s[p].count++,s[y].count++,s[E].count++,i.subtract(fe,ce,fe),i.subtract(he,ce,he),f[m]=i.cross(fe,he,new i),m++}var g=0;for(d=0;a>d;d++)s[d].indexOffset+=g,g+=s[d].count;m=0;var R;for(d=0;o>d;d+=3){R=s[r[d]];var S=R.indexOffset+R.currentCount;h[S]=m,R.currentCount++,R=s[r[d+1]],S=R.indexOffset+R.currentCount,h[S]=m,R.currentCount++,R=s[r[d+2]],S=R.indexOffset+R.currentCount,h[S]=m,R.currentCount++,m++}var N=new Float32Array(3*a);for(d=0;a>d;d++){var I=3*d;if(R=s[d],R.count>0){for(i.clone(i.ZERO,le),m=0;m<R.count;m++)i.add(le,f[h[R.indexOffset+m]],le);i.normalize(le,le),N[I]=le.x,N[I+1]=le.y,N[I+2]=le.z}else N[I]=0,N[I+1]=0,N[I+2]=1}return e.attributes.normal=new w({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:N}),e};var de=new i,we=new i,me=new i;re.computeBinormalAndTangent=function(e){if(!l(e))throw new c("geometry is required.");var r=e.attributes,t=e.indices;if(!l(r.position)||!l(r.position.values))throw new c("geometry.attributes.position.values is required.");if(!l(r.normal)||!l(r.normal.values))throw new c("geometry.attributes.normal.values is required.");if(!l(r.st)||!l(r.st.values))throw new c("geometry.attributes.st.values is required.");if(!l(t))throw new c("geometry.indices is required.");if(t.length<2||t.length%3!==0)throw new c("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==A.TRIANGLES)throw new c("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var n=e.attributes.position.values,a=e.attributes.normal.values,o=e.attributes.st.values,s=e.attributes.position.values.length/3,f=t.length,h=new Array(3*s),d=0;d<h.length;d++)h[d]=0;var m,p,y;for(d=0;f>d;d+=3){var E=t[d],v=t[d+1],_=t[d+2];m=3*E,p=3*v,y=3*_;var T=2*E,g=2*v,R=2*_,S=n[m],N=n[m+1],I=n[m+2],O=o[T],q=o[T+1],x=o[g+1]-q,M=o[R+1]-q,b=1/((o[g]-O)*M-(o[R]-O)*x),P=(M*(n[p]-S)-x*(n[y]-S))*b,C=(M*(n[p+1]-N)-x*(n[y+1]-N))*b,D=(M*(n[p+2]-I)-x*(n[y+2]-I))*b;h[m]+=P,h[m+1]+=C,h[m+2]+=D,h[p]+=P,h[p+1]+=C,h[p+2]+=D,h[y]+=P,h[y+1]+=C,h[y+2]+=D}var L=new Float32Array(3*s),U=new Float32Array(3*s);for(d=0;s>d;d++){m=3*d,p=m+1,y=m+2;var F=i.fromArray(a,m,de),z=i.fromArray(h,m,me),B=i.dot(F,z);i.multiplyByScalar(F,B,we),i.normalize(i.subtract(z,we,z),z),U[m]=z.x,U[p]=z.y,U[y]=z.z,i.normalize(i.cross(F,z,z),z),L[m]=z.x,L[p]=z.y,L[y]=z.z}return e.attributes.tangent=new w({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:U}),e.attributes.binormal=new w({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:L}),e};var pe=new n,ye=new i,Ee=new i,ve=new i;re.compressVertices=function(r){if(!l(r))throw new c("geometry is required.");var t=r.attributes.normal,a=r.attributes.st;if(!l(t)&&!l(a))return r;var o,s,f,h,d=r.attributes.tangent,m=r.attributes.binormal;l(t)&&(o=t.values),l(a)&&(s=a.values),l(d)&&(f=d.values),m&&(h=m.values);var p=l(o)?o.length:s.length,y=l(o)?3:2,E=p/y,v=E,_=l(s)&&l(o)?2:1;_+=l(f)||l(h)?1:0,v*=_;for(var T=new Float32Array(v),g=0,R=0;E>R;++R){l(s)&&(n.fromArray(s,2*R,pe),T[g++]=e.compressTextureCoordinates(pe));var A=3*R;l(o)&&l(f)&&l(h)?(i.fromArray(o,A,ye),i.fromArray(f,A,Ee),i.fromArray(h,A,ve),e.octPack(ye,Ee,ve,pe),T[g++]=pe.x,T[g++]=pe.y):(l(o)&&(i.fromArray(o,A,ye),T[g++]=e.octEncodeFloat(ye)),l(f)&&(i.fromArray(f,A,ye),T[g++]=e.octEncodeFloat(ye)),l(h)&&(i.fromArray(h,A,ye),T[g++]=e.octEncodeFloat(ye)))}return r.attributes.compressedAttributes=new w({componentDatatype:u.FLOAT,componentsPerAttribute:_,values:T}),l(o)&&delete r.attributes.normal,l(s)&&delete r.attributes.st,l(f)&&delete r.attributes.tangent,l(h)&&delete r.attributes.binormal,r};var _e=new i,Te=new i,ge=new i,Re=new i,Ae=new i,Se={positions:new Array(7),indices:new Array(9)},Ne=new i,Ie=new i,Oe=new i,qe=new i,xe=new n,Me=new n,be=new n,Pe=R.fromPointNormal(i.ZERO,i.UNIT_Y),Ce=new i,De=new i,Le=new n,Ue=new n,Fe=new i,ze=new i,Be=new i,Ge=new i,We=new i,He=new i,Ve=new i,Xe=new a;new a;return re.splitLongitude=function(e){if(!l(e))throw new c("instance is required.");var r=e.geometry,n=r.boundingSphere;if(l(n)){var i=n.center.x-n.radius;if(i>0||t.intersectPlane(n,R.ORIGIN_ZX_PLANE)!==E.INTERSECTING)return e}if(r.geometryType!==p.NONE)switch(r.geometryType){case p.POLYLINES:ee(e);break;case p.TRIANGLES:Q(e);break;case p.LINES:$(e)}else W(r),r.primitiveType===A.TRIANGLES?Q(e):r.primitiveType===A.LINES&&$(e);return e},re}),define("Core/pointInsideTriangle",["./barycentricCoordinates","./Cartesian3"],function(e,r){"use strict";var t=new r,n=function(r,n,i,a){return e(r,n,i,a,t),t.x>0&&t.y>0&&t.z>0};return n}),define("Core/EllipsoidGeodesic",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,r,t,n,i,a,o,u){"use strict";function s(e){var r=e._uSquared,t=e._ellipsoid.maximumRadius,n=e._ellipsoid.minimumRadius,i=(t-n)/t,a=Math.cos(e._startHeading),o=Math.sin(e._startHeading),u=(1-i)*Math.tan(e._start.latitude),s=1/Math.sqrt(1+u*u),l=s*u,c=Math.atan2(u,a),f=s*o,h=f*f,d=1-h,w=Math.sqrt(d),m=r/4,p=m*m,y=p*m,E=p*p,v=1+m-3*p/4+5*y/4-175*E/64,_=1-m+15*p/8-35*y/8,T=1-3*m+35*p/4,g=1-5*m,R=v*c-_*Math.sin(2*c)*m/2-T*Math.sin(4*c)*p/16-g*Math.sin(6*c)*y/48-5*Math.sin(8*c)*E/512,A=e._constants;A.a=t,A.b=n,A.f=i,A.cosineHeading=a,A.sineHeading=o,A.tanU=u,A.cosineU=s,A.sineU=l,A.sigma=c,A.sineAlpha=f,A.sineSquaredAlpha=h,A.cosineSquaredAlpha=d,A.cosineAlpha=w,A.u2Over4=m,A.u4Over16=p,A.u6Over64=y,A.u8Over256=E,A.a0=v,A.a1=_,A.a2=T,A.a3=g,A.distanceRatio=R}function l(e,r){return e*r*(4+e*(4-3*r))/16}function c(e,r,t,n,i,a,o){var u=l(e,t);return(1-u)*e*r*(n+u*i*(o+u*a*(2*o*o-1)))}function f(e,r,t,n,i,a,o){var s,l,f,h,d,w=(r-t)/r,m=a-n,p=Math.atan((1-w)*Math.tan(i)),y=Math.atan((1-w)*Math.tan(o)),E=Math.cos(p),v=Math.sin(p),_=Math.cos(y),T=Math.sin(y),g=E*_,R=E*T,A=v*T,S=v*_,N=m,I=u.TWO_PI,O=Math.cos(N),q=Math.sin(N);do{O=Math.cos(N),q=Math.sin(N);var x=R-S*O;f=Math.sqrt(_*_*q*q+x*x),l=A+g*O,s=Math.atan2(f,l);var M;0===f?(M=0,h=1):(M=g*q/f,h=1-M*M),I=N,d=l-2*A/h,isNaN(d)&&(d=0),N=m+c(w,M,h,s,f,l,d)}while(Math.abs(N-I)>u.EPSILON12);var b=h*(r*r-t*t)/(t*t),P=1+b*(4096+b*(b*(320-175*b)-768))/16384,C=b*(256+b*(b*(74-47*b)-128))/1024,D=d*d,L=C*f*(d+C*(l*(2*D-1)-C*d*(4*f*f-3)*(4*D-3)/6)/4),U=t*P*(s-L),F=Math.atan2(_*q,R-S*O),z=Math.atan2(E*q,R*O-S);e._distance=U,e._startHeading=F,e._endHeading=z,e._uSquared=b}function h(t,n,i,o){var u=e.normalize(o.cartographicToCartesian(n,w),d),l=e.normalize(o.cartographicToCartesian(i,w),w);if(Math.abs(Math.abs(e.angleBetween(u,l))-Math.PI)<.0125)throw new a("geodesic position is not unique");f(t,o.maximumRadius,o.minimumRadius,n.longitude,n.latitude,i.longitude,i.latitude),t._start=r.clone(n,t._start),t._end=r.clone(i,t._end),t._start.height=0,t._end.height=0,s(t)}var d=new e,w=new e,m=function(e,i,a){var u=t(a,o.WGS84);this._ellipsoid=u,this._start=new r,this._end=new r,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,n(e)&&n(i)&&h(this,e,i,u)};return i(m.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){if(!n(this._distance))throw new a("set end positions before getting surfaceDistance");return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){if(!n(this._distance))throw new a("set end positions before getting startHeading");return this._startHeading}},endHeading:{get:function(){if(!n(this._distance))throw new a("set end positions before getting endHeading");return this._endHeading}}}),m.prototype.setEndPoints=function(e,r){if(!n(e))throw new a("start cartographic position is required");if(!n(r))throw new a("end cartgraphic position is required");h(this,e,r,this._ellipsoid)},m.prototype.interpolateUsingFraction=function(e,r){return this.interpolateUsingSurfaceDistance(this._distance*e,r)},m.prototype.interpolateUsingSurfaceDistance=function(e,t){if(!n(this._distance))throw new a("start and end must be set before calling funciton interpolateUsingSurfaceDistance");var i=this._constants,o=i.distanceRatio+e/i.b,u=Math.cos(2*o),s=Math.cos(4*o),l=Math.cos(6*o),f=Math.sin(2*o),h=Math.sin(4*o),d=Math.sin(6*o),w=Math.sin(8*o),m=o*o,p=o*m,y=i.u8Over256,E=i.u2Over4,v=i.u6Over64,_=i.u4Over16,T=2*p*y*u/3+o*(1-E+7*_/4-15*v/4+579*y/64-(_-15*v/4+187*y/16)*u-(5*v/4-115*y/16)*s-29*y*l/16)+(E/2-_+71*v/32-85*y/16)*f+(5*_/16-5*v/4+383*y/96)*h-m*((v-11*y/2)*f+5*y*h/2)+(29*v/96-29*y/16)*d+539*y*w/1536,g=Math.asin(Math.sin(T)*i.cosineAlpha),R=Math.atan(i.a/i.b*Math.tan(g));T-=i.sigma;var A=Math.cos(2*i.sigma+T),S=Math.sin(T),N=Math.cos(T),I=i.cosineU*N,O=i.sineU*S,q=Math.atan2(S*i.sineHeading,I-O*i.cosineHeading),x=q-c(i.f,i.sineAlpha,i.cosineSquaredAlpha,T,S,N,A);return n(t)?(t.longitude=this._start.longitude+x,t.latitude=R,t.height=0,t):new r(this._start.longitude+x,R,0)},m}),define("Core/isArray",["./defined"],function(e){"use strict";var r=Array.isArray;return e(r)||(r=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),r}),define("Core/PolylinePipeline",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidGeodesic","./IntersectionTests","./isArray","./Math","./Matrix4","./Plane"],function(e,r,t,n,i,a,o,u,s,l,c,f){"use strict";function h(e,r,t){var n=A;n.length=e;var i;if(r===t){for(i=0;e>i;i++)n[i]=r;return n}var a=t-r,o=a/e;for(i=0;e>i;i++){var u=r+i*o;n[i]=u}return n}function d(r,t,n,i,a,o,u,s){var l=i.scaleToGeodeticSurface(r,O),c=i.scaleToGeodeticSurface(t,q),f=w.numberOfPoints(r,t,n),d=i.cartesianToCartographic(l,S),m=i.cartesianToCartographic(c,N),p=h(f,a,o);x.setEndPoints(d,m);var y=x.surfaceDistance/f,E=s;d.height=a;var v=i.cartographicToCartesian(d,I);e.pack(v,u,E),E+=3;for(var _=1;f>_;_++){var T=x.interpolateUsingSurfaceDistance(_*y,N);T.height=p[_],v=i.cartographicToCartesian(T,I),e.pack(v,u,E),E+=3}return E}var w={};w.numberOfPoints=function(r,t,n){var i=e.distance(r,t);return Math.ceil(i/n)};var m=new r;w.extractHeights=function(e,r){for(var t=e.length,n=new Array(t),i=0;t>i;i++){var a=e[i];n[i]=r.cartesianToCartographic(a,m).height}return n};var p=new c,y=new e,E=new e,v=new f(e.ZERO,0),_=new e,T=new f(e.ZERO,0),g=new e,R=new e,A=[],S=new r,N=new r,I=new e,O=new e,q=new e,x=new o;w.wrapLongitude=function(r,i){var a=[],o=[];if(n(r)&&r.length>0){i=t(i,c.IDENTITY);var s=c.inverseTransformation(i,p),l=c.multiplyByPoint(s,e.ZERO,y),h=c.multiplyByPointAsVector(s,e.UNIT_Y,E),d=f.fromPointNormal(l,h,v),w=c.multiplyByPointAsVector(s,e.UNIT_X,_),m=f.fromPointNormal(l,w,T),A=1;a.push(e.clone(r[0]));for(var S=a[0],N=r.length,I=1;N>I;++I){var O=r[I];if(f.getPointDistance(m,S)<0||f.getPointDistance(m,O)<0){var q=u.lineSegmentPlane(S,O,d,g);if(n(q)){var x=e.multiplyByScalar(h,5e-9,R);f.getPointDistance(d,S)<0&&e.negate(x,x),a.push(e.add(q,x,new e)),o.push(A+1),e.negate(x,x),a.push(e.add(q,x,new e)),A=1}}a.push(e.clone(r[I])),A++,S=O}o.push(A)}return{positions:a,lengths:o}};var M=l.EPSILON7;return w.removeDuplicates=function(r){if(!n(r))throw new i("positions is required.");var t=r.length;if(2>t)return r;var a,o,u;for(a=1;t>a&&(o=r[a-1],u=r[a],!e.equalsEpsilon(o,u,M));++a);if(a===t)return r;for(var s=r.slice(0,a);t>a;++a)u=r[a],e.equalsEpsilon(o,u,M)||(s.push(e.clone(u)),o=u);return s},w.generateArc=function(r){n(r)||(r={});var o=r.positions;if(!n(o))throw new i("options.positions is required.");var u=o.length,c=t(r.ellipsoid,a.WGS84),f=t(r.height,0);if(1>u)return[];if(1===u){var h=c.scaleToGeodeticSurface(o[0],O);if(0!==f){var m=c.geodeticSurfaceNormal(h,I);e.multiplyByScalar(m,f,m),e.add(h,m,h)}return[h.x,h.y,h.z]}var p=r.minDistance;if(!n(p)){var y=t(r.granularity,l.RADIANS_PER_DEGREE);p=l.chordLength(y,c.maximumRadius)}var E,v=0;for(E=0;u-1>E;E++)v+=w.numberOfPoints(o[E],o[E+1],p);var _=3*(v+1),T=new Array(_),g=0,R=s(f);for(E=0;u-1>E;E++){var N=o[E],q=o[E+1],x=R?f[E]:f,M=R?f[E+1]:f;g=d(N,q,p,c,x,M,T,g)}A.length=0;var b=o[u-1],P=c.cartesianToCartographic(b,S);P.height=R?f[u-1]:f;var C=c.cartographicToCartesian(P,I);return e.pack(C,T,_-3),T},w.generateCartesianArc=function(r){for(var t=w.generateArc(r),n=t.length/3,i=new Array(n),a=0;n>a;a++)i[a]=e.unpack(t,3*a);return i},w}),define("Core/Queue",[],function(){"use strict";var e=function(){this._array=[],this._offset=0,this.length=0};return e.prototype.enqueue=function(e){this._array.push(e),this.length++},e.prototype.dequeue=function(){if(0===this.length)return void 0;var e=this._array,r=this._offset,t=e[r];return e[r]=void 0,r++,r>10&&2*r>e.length&&(this._array=e.slice(r),r=0),this._offset=r,this.length--,t},e.prototype.contains=function(e){return-1!==this._array.indexOf(e)},e.prototype.clear=function(){this._array.length=this._offset=this.length=0},e.prototype.sort=function(e){this._offset>0&&(this._array=this._array.slice(this._offset),this._offset=0),this._array.sort(e)},e}),define("Core/WindingOrder",["../Renderer/WebGLConstants","./freezeObject"],function(e,r){"use strict";var t={CLOCKWISE:e.CW,COUNTER_CLOCKWISE:e.CCW,validate:function(e){return e===t.CLOCKWISE||e===t.COUNTER_CLOCKWISE}};return r(t)}),define("Core/PolygonPipeline",["./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./Math","./pointInsideTriangle","./PolylinePipeline","./PrimitiveType","./Queue","./WindingOrder"],function(e,r,t,n,i,a,o,u,s,l,c,f,h,d,w,m){"use strict";function p(r,t,n){var i=e.subtract(t,r,L),a=e.subtract(n,t,U);return i.x*a.y-i.y*a.x>=0}function y(e){for(var r=e[0].x,t=0,n=0;n<e.length;n++)e[n].x>r&&(r=e[n].x,t=n);return t}function E(e){for(var r=e[0][0].x,t=0,n=0;n<e.length;n++){var i=e[n][y(e[n])].x;i>r&&(r=i,t=n)}return t}function v(e){for(var r=[],t=0;t<e.length;t++){var n=e[(t-1+e.length)%e.length],i=e[t],a=e[(t+1)%e.length];p(n,i,a)||r.push(i)}return r}function _(r,t){for(var n=0;n<r.length;n++)if(e.equals(t,r[n]))return n;return-1}function T(t,i,a){a=n(a,[]);var o=Number.MAX_VALUE,u=y(i),s=new e(i[u].x,t.y);a.push(u),a.push((u+1)%i.length);for(var l=i[0].x,c=l,f=1;f<i.length;++f)i[f].x<l?l=i[f].x:i[f].x>c&&(c=i[f].x);c+=c-l;var h=new r(c,t.y,0);for(f=0;f<i.length;f++){var d=i[f],w=i[(f+1)%i.length];if((d.x>=t.x||w.x>=t.x)&&(d.y>=t.y&&w.y<=t.y||d.y<=t.y&&w.y>=t.y)){var m=(w.y-d.y)*(h.x-t.x)-(w.x-d.x)*(h.y-t.y);if(0!==m){m=1/m;var p=((w.x-d.x)*(t.y-d.y)-(w.y-d.y)*(t.x-d.x))*m,E=((h.x-t.x)*(t.y-d.y)-(h.y-t.y)*(t.x-d.x))*m;if(p>=0&&1>=p&&E>=0&&1>=E){var v=new e(t.x+p*(h.x-t.x),t.y+p*(h.y-t.y)),_=e.subtract(v,t,F);m=e.magnitudeSquared(_),o>m&&(s=v,o=m,a[0]=f,a[1]=(f+1)%i.length)}}}}return s}function g(r,t){var n=E(t),i=t[n],a=y(i),o=i[a],u=[],s=T(o,r,u),l=_(r,s);if(-1!==l)return l;var h=e.magnitudeSquared(e.subtract(r[u[0]],o,z)),d=e.magnitudeSquared(e.subtract(r[u[1]],o,z)),w=d>h?r[u[0]]:r[u[1]],m=v(r),p=m.indexOf(w);-1!==p&&m.splice(p,1);for(var g=[],R=0;R<m.length;R++){var A=m[R];f(A,o,s,w)&&g.push(A)}var S=Number.MAX_VALUE;if(g.length>0){var N=e.fromElements(1,0,z);for(R=0;R<g.length;R++){var I=e.subtract(g[R],o,B),O=e.magnitude(N)*e.magnitudeSquared(I);if(0!==O){var q=Math.abs(c.acosClamped(e.dot(N,I)/O));S>q&&(S=q,w=g[R])}}}return r.indexOf(w)}function R(e,t,n){for(var i=ee.computeWindingOrder2D(e),a=0;a<t.length;a++){var o=t[a];r.equals(o[0],o[o.length-1])||o.push(o[0]);var s=ee.computeWindingOrder2D(o);s===i&&o.reverse()}var l=u.fromPoints(e,n),c=l.projectPointsOntoPlane(e),f=[];for(a=0;a<t.length;a++)f.push(l.projectPointsOntoPlane(t[a]));var h=g(c,f),d=E(f),w=y(f[d]),m=t[d],p=[];for(a=0;a<e.length;a++)p.push(e[a]);var v,_=[];if(0!==w)for(v=0;v<=m.length;v++){var T=(v+w)%m.length;0!==T&&_.push(m[T])}else for(v=0;v<m.length;v++)_.push(m[(v+w)%m.length]);var R=p.lastIndexOf(e[h]);_.push(e[R]);var A=p.slice(0,R+1),S=p.slice(R+1);return p=A.concat(_,S),t.splice(d,1),p}function A(e){var r=c.nextRandomNumber(),t=Math.floor(r*e);return t===e&&t--,t}function S(e,r,t,n){var i=n[e].position,a=n[r].position,o=n[t].position,u=o.x,s=o.y,l=i.x-u,c=i.y-s,f=a.x-u,h=a.y-s;return l*h-c*f}function N(e,r){return e.x*r.y-e.y*r.x}function I(e,r){var t=r.length,n=c.mod(e-1,t),i=c.mod(e+1,t);return 0===S(n,i,e,r)?!1:!0}function O(r,t){return e.magnitudeSquared(t)<e.magnitudeSquared(r)}function q(r,t,n){if(!I(r,n))return r;var i=n[r].position,a=n[t].position,o=n.length,u=c.mod(r-1,o);if(!I(u,n))return u;var s=c.mod(r+1,o);if(!I(s,n))return s;var l=e.subtract(n[u].position,i,H),f=e.subtract(n[s].position,i,V),h=e.subtract(a,i,X),d=N(l,h),w=N(f,h);if(0===d)return O(l,h)?G:W;if(0===w)return O(f,h)?G:W;var m=N(l,f);return 0>m?0>d&&w>0?G:W:m>0?d>0&&0>w?W:G:void 0}function x(e,r,t){return(e>r||e>t)&&(r>e||t>e)||r===t&&r===e}function M(r,t,n,i){var a=e.subtract(n,r,k),o=t.x*i.y-t.y*i.x,u=o*o,s=e.magnitudeSquared(t),l=e.magnitudeSquared(i);if(u>Y*s*l){var c=(a.x*i.y-a.y*i.x)/o;return e.add(r,e.multiplyByScalar(t,c,k),k)}return void 0}function b(r,t,n){for(var a=e.subtract(t,r,j),o=n.length,u=0;o>u;u++){var s=n[u].position,l=n[c.mod(u+1,o)].position;if(!(e.equals(r,s)||e.equals(t,l)||e.equals(r,l)||e.equals(t,s))){var f=e.subtract(l,s,Z),h=M(r,a,s,f);if(i(h)&&!(e.equals(h,r)||e.equals(h,t)||e.equals(h,s)||e.equals(h,l))){var d=h.x,w=h.y,m=x(d,r.x,t.x)&&x(w,r.y,t.y)&&x(d,s.x,l.x)&&x(w,s.y,l.y);if(m)return!0}}}return!1}function P(r,t,n){var i=q(r,t,n);if(i>=0)return i;var a=q(t,r,n);return a>=0?a:i!==G||a!==G||b(n[r].position,n[t].position,n)||e.equals(n[r].position,n[t].position)?J:K}function C(e){return 0===S(1,2,0,e)}function D(e){var r=e.length;if(3===r)return C(e)?[]:[e[0].index,e[1].index,e[2].index];if(e.length<3)throw new a("Invalid polygon: must have at least three vertices.");for(var t,n,i=0,o=10*e.length,u=J;K>u&&i++<o;){for(t=A(e.length),n=t+1;Math.abs(t-n)<2||Math.abs(t-n)>e.length-2;)n=A(e.length);if(t>n){var s=t;t=n,n=s}u=P(t,n,e)}if(u===K){var l=e.splice(t,n-t+1,e[t],e[n]);return D(e).concat(D(l))}return u>=0?(e.splice(u,1),D(e)):[]}var L=new e,U=new e,F=new e,z=new e(1,0),B=new e,G=-1,W=-2,H=new r,V=new r,X=new r,Y=c.EPSILON14,k=new e,j=(new e,new e),Z=new e,K=-1,J=-2,Q=new r,$=new r,ee={};ee.removeDuplicates=function(e){if(!i(e))throw new a("positions is required.");var t=h.removeDuplicates(e);return r.equals(t[0],t[t.length-1])?t.slice(1):t},ee.computeArea2D=function(e){if(!i(e))throw new a("positions is required.");if(e.length<3)throw new a("At least three positions are required.");for(var r=e.length,t=0,n=r-1,o=0;r>o;n=o++){var u=e[n],s=e[o];t+=u.x*s.y-s.x*u.y}return.5*t},ee.computeWindingOrder2D=function(e){var r=ee.computeArea2D(e);return r>0?m.COUNTER_CLOCKWISE:m.CLOCKWISE},ee.triangulate=function(e){if(!i(e))throw new a("positions is required.");if(e.length<3)throw new a("At least three positions are required.");for(var r=e.length,t=[],n=0;r>n;++n)t[n]={position:e[n],index:n};return D(t)};var re=new r,te=new r,ne=new r,ie=new r,ae=new r,oe=new r,ue=new r;return ee.computeSubdivision=function(e,o,u,f){if(f=n(f,c.RADIANS_PER_DEGREE),!i(e))throw new a("ellipsoid is required.");if(!i(o))throw new a("positions is required.");if(!i(u))throw new a("indices is required.");if(u.length<3)throw new a("At least three indices are required.");if(u.length%3!==0)throw new a("The number of indices must be divisable by three.");if(0>=f)throw new a("granularity must be greater than zero.");var h,w=u.slice(0),m=o.length,p=new Array(3*m),y=0;for(h=0;m>h;h++){var E=o[h];p[y++]=E.x,p[y++]=E.y,p[y++]=E.z}for(var v=[],_={},T=e.maximumRadius,g=c.chordLength(f,T),R=g*g;w.length>0;){var A,S,N=w.pop(),I=w.pop(),O=w.pop(),q=r.fromArray(p,3*O,re),x=r.fromArray(p,3*I,te),M=r.fromArray(p,3*N,ne),b=r.multiplyByScalar(r.normalize(q,ie),T,ie),P=r.multiplyByScalar(r.normalize(x,ae),T,ae),C=r.multiplyByScalar(r.normalize(M,oe),T,oe),D=r.magnitudeSquared(r.subtract(b,P,ue)),L=r.magnitudeSquared(r.subtract(P,C,ue)),U=r.magnitudeSquared(r.subtract(C,b,ue)),F=Math.max(D,L,U);F>R?D===F?(A=Math.min(O,I)+" "+Math.max(O,I),h=_[A],i(h)||(S=r.add(q,x,ue),r.multiplyByScalar(S,.5,S),p.push(S.x,S.y,S.z),h=p.length/3-1,_[A]=h),w.push(O,h,N),w.push(h,I,N)):L===F?(A=Math.min(I,N)+" "+Math.max(I,N),h=_[A],i(h)||(S=r.add(x,M,ue),r.multiplyByScalar(S,.5,S),p.push(S.x,S.y,S.z),h=p.length/3-1,_[A]=h),w.push(I,h,O),w.push(h,N,O)):U===F&&(A=Math.min(N,O)+" "+Math.max(N,O),h=_[A],i(h)||(S=r.add(M,q,ue),r.multiplyByScalar(S,.5,S),p.push(S.x,S.y,S.z),h=p.length/3-1,_[A]=h),w.push(N,h,I),w.push(h,O,I)):(v.push(O),v.push(I),v.push(N))}return new s({attributes:{position:new l({componentDatatype:t.DOUBLE,componentsPerAttribute:3,values:p})},indices:v,primitiveType:d.TRIANGLES})},ee.scaleToGeodeticHeight=function(e,t,a,u){a=n(a,o.WGS84);var s=Q,l=$;if(t=n(t,0),u=n(u,!0),i(e)&&i(e.attributes)&&i(e.attributes.position))for(var c=e.attributes.position.values,f=c.length,h=0;f>h;h+=3)r.fromArray(c,h,l),u&&(l=a.scaleToGeodeticSurface(l,l)),s=a.geodeticSurfaceNormal(l,s),r.multiplyByScalar(s,t,s),r.add(l,s,l),c[h]=l.x,c[h+1]=l.y,c[h+2]=l.z;return e},ee.eliminateHoles=function(e,t,u){if(!i(e))throw new a("outerRing is required.");if(0===e.length)throw new a("outerRing must not be empty.");if(!i(t))throw new a("innerRings is required.");u=n(u,o.WGS84);for(var s=[],l=0;l<t.length;l++){for(var c=[],f=0;f<t[l].length;f++)c.push(r.clone(t[l][f]));s.push(c)}for(var h=e;s.length>0;)h=R(h,s,u);return h},ee}),define("Core/PolygonGeometryLibrary",["./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PolygonPipeline","./PrimitiveType","./Queue","./WindingOrder"],function(e,r,t,n,i,a,o,u,s,l,c,f,h,d,w){"use strict";function m(r,t,n,i){return e.subtract(t,r,y),e.multiplyByScalar(y,n/i,y),e.add(r,y,y),[y.x,y.y,y.z]}var p={};p.computeHierarchyPackedLength=function(r){for(var t=0,i=[r];i.length>0;){var a=i.pop();if(n(a)){t+=2;var o=a.positions,u=a.holes;if(n(o)&&(t+=o.length*e.packedLength),n(u))for(var s=u.length,l=0;s>l;++l)i.push(u[l])}}return t},p.packPolygonHierarchy=function(r,t,i){for(var a=[r];a.length>0;){var o=a.pop();if(n(o)){var u=o.positions,s=o.holes;if(t[i++]=n(u)?u.length:0,t[i++]=n(s)?s.length:0,n(u))for(var l=u.length,c=0;l>c;++c,i+=3)e.pack(u[c],t,i);if(n(s))for(var f=s.length,h=0;f>h;++h)a.push(s[h])}}return i},p.unpackPolygonHierarchy=function(r,t){for(var n=r[t++],i=r[t++],a=new Array(n),o=i>0?new Array(i):void 0,u=0;n>u;++u,t+=e.packedLength)a[u]=e.unpack(r,t);for(var s=0;i>s;++s)o[s]=p.unpackPolygonHierarchy(r,t),t=o[s].startingIndex,delete o[s].startingIndex;return{positions:a,holes:o,startingIndex:t}};var y=new e;p.subdivideLineCount=function(r,t,n){var i=e.distance(r,t),a=i/n,o=Math.max(0,Math.ceil(Math.log(a)/Math.log(2)));return Math.pow(2,o)},p.subdivideLine=function(r,t,i,a){var o=p.subdivideLineCount(r,t,i),u=e.distance(r,t),s=u/o;n(a)||(a=[]);var l=a;l.length=3*o;for(var c=0,f=0;o>f;f++){var h=m(r,t,f*s,u);l[c++]=h[0],l[c++]=h[1],l[c++]=h[2]}return l};var E=new e,v=new e,_=new e,T=new e;p.scaleToGeodeticHeightExtruded=function(r,a,o,u,s){u=t(u,i.WGS84);var l=E,c=v,f=_,h=T;if(n(r)&&n(r.attributes)&&n(r.attributes.position))for(var d=r.attributes.position.values,w=d.length/2,m=0;w>m;m+=3)e.fromArray(d,m,f),u.geodeticSurfaceNormal(f,l),h=u.scaleToGeodeticSurface(f,h),c=e.multiplyByScalar(l,o,c),c=e.add(h,c,c),d[m+w]=c.x,d[m+1+w]=c.y,d[m+2+w]=c.z,s&&(h=e.clone(f,h)),c=e.multiplyByScalar(l,a,c),c=e.add(h,c,c),d[m]=c.x,d[m+1]=c.y,d[m+2]=c.z;return r},p.polygonsFromHierarchy=function(e){var r=[],t=[],i=new d;for(i.enqueue(e);0!==i.length;){var a=i.dequeue(),o=a.positions,u=a.holes;if(o=f.removeDuplicates(o),!(o.length<3)){for(var s=n(u)?u.length:0,l=[],c=0;s>c;c++){var h=u[c];if(h.positions=f.removeDuplicates(h.positions),!(h.positions.length<3)){l.push(h.positions);var w=0;n(h.holes)&&(w=h.holes.length);for(var m=0;w>m;m++)i.enqueue(h.holes[m])}}t.push({outerRing:o,holes:l});var p=l.length>0?f.eliminateHoles(o,l):o;r.push(p)}}return{hierarchy:t,polygons:r}};var g=[];p.createGeometryFromPositions=function(e,t,n,i){var s=a.fromPoints(t,e),l=s.projectPointsOntoPlane(t,g),c=f.computeWindingOrder2D(l);c===w.CLOCKWISE&&(l.reverse(),t=t.slice().reverse());var d=f.triangulate(l);if(d.length<3&&(d=[0,1,2]),i){for(var m=t.length,p=new Array(3*m),y=0,E=0;m>E;E++){var v=t[E];p[y++]=v.x,p[y++]=v.y,p[y++]=v.z}return new o({attributes:{position:new u({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:p})},indices:d,primitiveType:h.TRIANGLES})}return f.computeSubdivision(e,t,d,n)};var R=[],A=new e,S=new e;return p.computeWallGeometry=function(t,n,i,a){var f,d,w,m,y,E=t.length,v=0;if(a)for(d=3*E*2,f=new Array(2*d),w=0;E>w;w++)m=t[w],y=t[(w+1)%E],f[v]=f[v+d]=m.x,++v,f[v]=f[v+d]=m.y,++v,f[v]=f[v+d]=m.z,++v,f[v]=f[v+d]=y.x,++v,f[v]=f[v+d]=y.y,++v,f[v]=f[v+d]=y.z,++v;else{var _=c.chordLength(i,n.maximumRadius),T=0;for(w=0;E>w;w++)T+=p.subdivideLineCount(t[w],t[(w+1)%E],_);for(d=3*(T+E),f=new Array(2*d),w=0;E>w;w++){m=t[w],y=t[(w+1)%E];for(var g=p.subdivideLine(m,y,_,R),N=g.length,I=0;N>I;++I,++v)f[v]=g[I],f[v+d]=g[I];f[v]=y.x,f[v+d]=y.x,++v,f[v]=y.y,f[v+d]=y.y,++v,f[v]=y.z,f[v+d]=y.z,++v}}E=f.length;var O=l.createTypedArray(E/3,E-6*t.length),q=0;for(E/=6,w=0;E>w;w++){var x=w,M=x+1,b=x+E,P=b+1;m=e.fromArray(f,3*x,A),y=e.fromArray(f,3*M,S),e.equalsEpsilon(m,y,c.EPSILON14)||(O[q++]=x,O[q++]=b,O[q++]=M,O[q++]=M,O[q++]=b,O[q++]=P)}return new o({attributes:new s({position:new u({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:f})}),indices:O,primitiveType:h.TRIANGLES})},p}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,r,t,n){"use strict";var i=function(r){r=e(r,e.EMPTY_OBJECT),this.position=e(r.position,!1),this.normal=e(r.normal,!1),this.st=e(r.st,!1),this.binormal=e(r.binormal,!1),this.tangent=e(r.tangent,!1),this.color=e(r.color,!1)};return i.POSITION_ONLY=n(new i({position:!0})),i.POSITION_AND_NORMAL=n(new i({position:!0,normal:!0})),i.POSITION_NORMAL_AND_ST=n(new i({position:!0,normal:!0,st:!0})),i.POSITION_AND_ST=n(new i({position:!0,st:!0})),i.POSITION_AND_COLOR=n(new i({position:!0,color:!0})),i.ALL=n(new i({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),i.DEFAULT=i.POSITION_NORMAL_AND_ST,i.packedLength=6,i.pack=function(n,i,a){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");a=e(a,0),i[a++]=n.position?1:0,i[a++]=n.normal?1:0,i[a++]=n.st?1:0,i[a++]=n.binormal?1:0,i[a++]=n.tangent?1:0,i[a++]=n.color?1:0},i.unpack=function(n,a,o){if(!r(n))throw new t("array is required");return a=e(a,0),r(o)||(o=new i),o.position=1===n[a++],o.normal=1===n[a++],o.st=1===n[a++],o.binormal=1===n[a++],o.tangent=1===n[a++],o.color=1===n[a++],o},i.clone=function(e,t){return r(e)?(r(t)||(t=new i),t.position=e.position,t.normal=e.normal,t.st=e.st,t.binormal=e.binormal,t.tangent=e.tangent,t.color=e.color,t):void 0},i}),define("Core/PolygonGeometry",["./BoundingRectangle","./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./Matrix3","./PolygonGeometryLibrary","./PolygonPipeline","./Quaternion","./VertexFormat","./WindingOrder"],function(e,r,t,n,i,a,o,u,s,l,c,f,h,d,w,m,p,y,E,v,_,T,g){"use strict";function R(e,r,t,i){for(var a=_.fromAxisAngle(e._plane.normal,t,O),u=y.fromQuaternion(a,q),s=Number.POSITIVE_INFINITY,l=Number.NEGATIVE_INFINITY,c=Number.POSITIVE_INFINITY,f=Number.NEGATIVE_INFINITY,h=r.length,d=0;h>d;++d){var w=n.clone(r[d],I);y.multiplyByVector(u,w,w);var m=e.projectPointOntoPlane(w,N);o(m)&&(s=Math.min(s,m.x),l=Math.max(l,m.x),c=Math.min(c,m.y),f=Math.max(f,m.y))}return i.x=s,i.y=c,i.width=l-s,i.height=f-c,i}function A(e,r,a,o,u,s,c){if(e.st||e.normal||e.tangent||e.binormal){var h=l.fromPoints(a,o),d=R(h,a,u,x),w=U;w.x=d.x,w.y=d.y;var m=r.attributes.position.values,E=m.length,v=e.st?new Float32Array(2*(E/3)):void 0,T=e.normal?new Float32Array(E):void 0,g=e.tangent?new Float32Array(E):void 0,A=e.binormal?new Float32Array(E):void 0,S=0,N=0,I=b,O=P,q=C,W=!0,H=_.fromAxisAngle(h._plane.normal,u,B),V=y.fromQuaternion(H,G),X=E/2,Y=E/3;s&&(E/=2);for(var k=0;E>k;k+=3){var j=n.fromArray(m,k,z);if(e.st){var Z=y.multiplyByVector(V,j,M),K=h.projectPointOntoPlane(Z,F);t.subtract(K,w,K),s&&(v[S+Y]=K.x/d.width,v[S+1+Y]=K.y/d.height),v[S]=K.x/d.width,v[S+1]=K.y/d.height,S+=2}if(e.normal||e.tangent||e.binormal){var J=N+1,Q=N+2;if(c){if(E>k+3){var $=n.fromArray(m,k+3,D);if(W){var ee=n.fromArray(m,k+E,L);n.subtract($,j,$),n.subtract(ee,j,ee),I=n.normalize(n.cross(ee,$,I),I),W=!1}n.equalsEpsilon($,j,p.EPSILON10)&&(W=!0)}(e.tangent||e.binormal)&&(q=o.geodeticSurfaceNormal(j,q),e.tangent&&(O=n.normalize(n.cross(q,I,O),O)))}else I=o.geodeticSurfaceNormal(j,I),(e.tangent||e.binormal)&&(O=n.cross(n.UNIT_Z,I,O),O=n.normalize(y.multiplyByVector(V,O,O),O),e.binormal&&(q=n.normalize(n.cross(I,O,q),q)));e.normal&&(s&&!c?(T[N+X]=-I.x,T[J+X]=-I.y,T[Q+X]=-I.z):(T[N+X]=I.x,T[J+X]=I.y,T[Q+X]=I.z),T[N]=I.x,T[J]=I.y,T[Q]=I.z),e.tangent&&(s&&!c?(g[N+X]=-O.x,g[J+X]=-O.y,g[Q+X]=-O.z):(g[N+X]=O.x,g[J+X]=O.y,g[Q+X]=O.z),g[N]=O.x,g[J]=O.y,g[Q]=O.z),e.binormal&&(s&&(A[N+X]=q.x,A[J+X]=q.y,A[Q+X]=q.z),A[N]=q.x,A[J]=q.y,A[Q]=q.z),N+=3}}e.st&&(r.attributes.st=new f({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:v})),e.normal&&(r.attributes.normal=new f({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:T})),e.tangent&&(r.attributes.tangent=new f({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:g})),e.binormal&&(r.attributes.binormal=new f({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:A}))}return r}function S(e,r,t,n,a){var o=E.createGeometryFromPositions(e,r,t,a),u=o.attributes.position.values,s=o.indices,w=u.concat(u),p=w.length/3,y=m.createTypedArray(p,2*s.length);y.set(s);var _,T=s.length,R=p/2;for(_=0;T>_;_+=3){var A=y[_]+R,S=y[_+1]+R,N=y[_+2]+R;y[_+T]=N,y[_+1+T]=S,y[_+2+T]=A}var I=new c({attributes:new h({position:new f({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:w})}),indices:y,primitiveType:o.primitiveType}),O={topAndBottom:new d({geometry:I}),walls:[]},q=n.outerRing,x=l.fromPoints(q,e),M=x.projectPointsOntoPlane(q,W),b=v.computeWindingOrder2D(M);b===g.CLOCKWISE&&(q=q.slice().reverse());var P=E.computeWallGeometry(q,e,t,a);O.walls.push(new d({geometry:P}));var C=n.holes;for(_=0;_<C.length;_++){var D=C[_];x=l.fromPoints(D,e),M=x.projectPointsOntoPlane(D,W),b=v.computeWindingOrder2D(M),b===g.COUNTER_CLOCKWISE&&(D=D.slice().reverse()),P=E.computeWallGeometry(D,e,t),O.walls.push(new d({geometry:P}))}return O}var N=new t,I=new n,O=new _,q=new y,x=new e,M=new n,b=new n,P=new n,C=new n,D=new n,L=new n,U=new t,F=new t,z=new n,B=new _,G=new y,W=[],H=function(e){
if(!o(e)||!o(e.polygonHierarchy))throw new u("options.polygonHierarchy is required.");var r=e.polygonHierarchy,t=a(e.vertexFormat,T.DEFAULT),n=a(e.ellipsoid,s.WGS84),i=a(e.granularity,p.RADIANS_PER_DEGREE),l=a(e.stRotation,0),c=a(e.height,0),f=a(e.perPositionHeight,!1),h=e.extrudedHeight,d=o(h);if(d&&!f){var w=h;h=Math.min(w,c),c=Math.max(w,c)}this._vertexFormat=T.clone(t),this._ellipsoid=s.clone(n),this._granularity=i,this._stRotation=l,this._height=c,this._extrudedHeight=a(h,0),this._extrude=d,this._polygonHierarchy=r,this._perPositionHeight=f,this._workerName="createPolygonGeometry",this.packedLength=E.computeHierarchyPackedLength(r)+s.packedLength+T.packedLength+7};H.fromPositions=function(e){if(e=a(e,a.EMPTY_OBJECT),!o(e.positions))throw new u("options.positions is required.");var r={polygonHierarchy:{positions:e.positions},height:e.height,extrudedHeight:e.extrudedHeight,vertexFormat:e.vertexFormat,stRotation:e.stRotation,ellipsoid:e.ellipsoid,granularity:e.granularity,perPositionHeight:e.perPositionHeight};return new H(r)},H.pack=function(e,r,t){if(!o(e))throw new u("value is required");if(!o(r))throw new u("array is required");t=a(t,0),t=E.packPolygonHierarchy(e._polygonHierarchy,r,t),s.pack(e._ellipsoid,r,t),t+=s.packedLength,T.pack(e._vertexFormat,r,t),t+=T.packedLength,r[t++]=e._height,r[t++]=e._extrudedHeight,r[t++]=e._granularity,r[t++]=e._stRotation,r[t++]=e._extrude?1:0,r[t++]=e._perPositionHeight?1:0,r[t]=e.packedLength};var V=s.clone(s.UNIT_SPHERE),X=new T,Y={polygonHierarchy:{}};return H.unpack=function(e,r,t){if(!o(e))throw new u("array is required");r=a(r,0);var n=E.unpackPolygonHierarchy(e,r);r=n.startingIndex,delete n.startingIndex;var i=s.unpack(e,r,V);r+=s.packedLength;var l=T.unpack(e,r,X);r+=T.packedLength;var c=e[r++],f=e[r++],h=e[r++],d=e[r++],w=1===e[r++],m=1===e[r++],p=e[r];return o(t)||(t=new H(Y)),t._polygonHierarchy=n,t._ellipsoid=s.clone(i,t._ellipsoid),t._vertexFormat=T.clone(l,t._vertexFormat),t._height=c,t._extrudedHeight=f,t._granularity=h,t._stRotation=d,t._extrude=w,t._perPositionHeight=m,t.packedLength=p,t},H.createGeometry=function(e){var t,n,i,a=e._vertexFormat,o=e._ellipsoid,u=e._granularity,s=e._stRotation,l=e._height,f=e._extrudedHeight,h=e._extrude,p=e._polygonHierarchy,y=e._perPositionHeight,_=E.polygonsFromHierarchy(p),T=_.hierarchy,g=_.polygons;if(0===g.length)return void 0;i=g[0];var R,N,I=[];if(h)for(N=0;N<g.length;N++){R=S(o,g[N],u,T[N],y),n=R.topAndBottom,n.geometry=E.scaleToGeodeticHeightExtruded(n.geometry,l,f,o,y),n.geometry=A(a,n.geometry,i,o,s,!0,!1),I.push(n),t=R.walls;for(var O=0;O<t.length;O++){var q=t[O];q.geometry=E.scaleToGeodeticHeightExtruded(q.geometry,l,f,o,y),q.geometry=A(a,q.geometry,i,o,s,!0,!0),I.push(q)}}else for(N=0;N<g.length;N++)R=new d({geometry:E.createGeometryFromPositions(o,g[N],u,y)}),R.geometry=v.scaleToGeodeticHeight(R.geometry,l,o,!y),R.geometry=A(a,R.geometry,i,o,s,!1,!1),I.push(R);R=w.combineInstances(I)[0],R.attributes.position.values=new Float64Array(R.attributes.position.values),R.indices=m.createTypedArray(R.attributes.position.values.length/3,R.indices);var x=R.attributes,M=r.fromVertices(x.position.values);return a.position||delete x.position,new c({attributes:x,indices:R.indices,primitiveType:R.primitiveType,boundingSphere:M})},H.createShadowVolume=function(e,r,t){var n=e._granularity,i=e._ellipsoid,a=r(n,i),o=t(n,i);return new H({polygonHierarchy:e._polygonHierarchy,ellipsoid:i,stRotation:e._stRotation,granularity:n,perPositionHeight:!1,extrudedHeight:a,height:o,vertexFormat:T.POSITION_ONLY})},H}),define("Workers/createPolygonGeometry",["../Core/defined","../Core/Ellipsoid","../Core/PolygonGeometry"],function(e,r,t){"use strict";function n(n,i){return e(i)&&(n=t.unpack(n,i)),n._ellipsoid=r.clone(n._ellipsoid),t.createGeometry(n)}return n})}();