/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var r=Object.freeze;return e(r)||(r=function(e){return e}),r}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var r=function(e,r){return void 0!==e?e:r};return r.EMPTY_OBJECT=e({}),r}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var r=function(e){this.name="DeveloperError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r.throwInstantiationError=function(){throw new r("This function defines an interface and should not be called directly.")},r}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var t;for(this.mti==this.N+1&&this.init_genrand(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^r[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^r[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^r[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.signNotZero=function(e){return 0>e?-1:1},i.toSNorm=function(e){return Math.round(255*(.5*i.clamp(e,-1,1)+.5))},i.fromSNorm=function(e){return i.clamp(e,0,255)/255*2-1},i.sinh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r-t)},i.cosh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r+t)},i.lerp=function(e,r,t){return(1-t)*e+t*r},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=3*Math.PI*.5,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){if(!t(e))throw new n("degrees is required.");return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){if(!t(e))throw new n("radians is required.");return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){if(!t(e))throw new n("angle is required.");var r=i.TWO_PI,o=e-Math.floor(e/r)*r;return o<-Math.PI?o+r:o>=Math.PI?o-r:o},i.negativePiToPi=function(e){if(!t(e))throw new n("x is required.");return i.zeroToTwoPi(e+i.PI)-i.PI},i.zeroToTwoPi=function(e){if(!t(e))throw new n("x is required.");var r=i.mod(e,i.TWO_PI);return Math.abs(r)<i.EPSILON14&&Math.abs(e)>i.EPSILON14?i.TWO_PI:r},i.mod=function(e,r){if(!t(e))throw new n("m is required.");if(!t(r))throw new n("n is required.");return(e%r+r)%r},i.equalsEpsilon=function(e,i,o,a){if(!t(e))throw new n("left is required.");if(!t(i))throw new n("right is required.");if(!t(o))throw new n("relativeEpsilon is required.");a=r(a,o);var u=Math.abs(e-i);return a>=u||u<=o*Math.max(Math.abs(e),Math.abs(i))};var o=[1];i.factorial=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");var r=o.length;if(e>=r)for(var t=o[r-1],i=r;e>=i;i++)o.push(t*i);return o[e]},i.incrementWrap=function(e,i,o){if(o=r(o,0),!t(e))throw new n("n is required.");if(o>=i)throw new n("maximumValue must be greater than minimumValue.");return++e,e>i&&(e=o),e},i.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,r,i){if(!t(e))throw new n("value is required");if(!t(r))throw new n("min is required.");if(!t(i))throw new n("max is required.");return r>e?r:e>i?i:e};var a=new e;return i.setRandomNumberSeed=function(r){if(!t(r))throw new n("seed is required.");a=new e(r)},i.nextRandomNumber=function(){return a.random()},i.acosClamped=function(e){if(!t(e))throw new n("value is required.");return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){if(!t(e))throw new n("value is required.");return Math.asin(i.clamp(e,-1,1))},i.chordLength=function(e,r){if(!t(e))throw new n("angle is required.");if(!t(r))throw new n("radius is required.");return 2*r*Math.sin(.5*e)},i}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t,n){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0)};o.fromSpherical=function(n,i){if(!r(n))throw new t("spherical is required");r(i)||(i=new o);var a=n.clock,u=n.cone,s=e(n.magnitude,1),f=s*Math.sin(u);return i.x=f*Math.cos(a),i.y=f*Math.sin(a),i.z=s*Math.cos(u),i},o.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new o(e,t,n)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new o(e.x,e.y,e.z):void 0},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.x,i[o++]=n.y,i[o]=n.z},o.unpack=function(n,i,a){if(!r(n))throw new t("array is required");return i=e(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i],a},o.fromArray=o.unpack,o.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z)},o.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z)},o.minimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i},o.maximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitude(a)},o.distanceSquared=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitudeSquared(a)},o.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=o.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n},o.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z},o.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i},o.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i},o.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i},o.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i},o.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i},o.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n},o.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n};var u=new o;o.lerp=function(e,n,i,a){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(n,i,u),a=o.multiplyByScalar(e,1-i,a),o.add(u,a,a)};var s=new o,f=new o;o.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");o.normalize(e,s),o.normalize(n,f);var i=o.dot(s,f),a=o.magnitude(o.cross(s,f,s));return Math.atan2(a,i)};var l=new o;o.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=o.normalize(e,l);return o.abs(i,i),n=i.x<=i.y?i.x<=i.z?o.clone(o.UNIT_X,n):o.clone(o.UNIT_Z,n):i.y<=i.z?o.clone(o.UNIT_Y,n):o.clone(o.UNIT_Z,n)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},o.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]&&e.z===r[t+2]},o.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)&&i.equalsEpsilon(e.z,t.z,n,o)},o.cross=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");var o=e.x,a=e.y,u=e.z,s=n.x,f=n.y,l=n.z,c=a*l-u*f,h=u*s-o*l,d=o*f-a*s;return i.x=c,i.y=h,i.z=d,i},o.fromDegrees=function(e,n,a,u,s){if(!r(e))throw new t("longitude is required");if(!r(n))throw new t("latitude is required");var f=i.toRadians(e),l=i.toRadians(n);return o.fromRadians(f,l,a,u,s)};var c=new o,h=new o,d=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(n,i,a,u,s){if(!r(n))throw new t("longitude is required");if(!r(i))throw new t("latitude is required");a=e(a,0);var f=r(u)?u.radiiSquared:d,l=Math.cos(i);c.x=l*Math.cos(n),c.y=l*Math.sin(n),c.z=Math.sin(i),c=o.normalize(c,c),o.multiplyComponents(f,c,h);var w=Math.sqrt(o.dot(c,h));return h=o.divideByScalar(h,w,h),c=o.multiplyByScalar(c,a,c),r(s)||(s=new o),o.add(h,c,s)},o.fromDegreesArray=function(e,n,a){if(!r(e))throw new t("positions is required.");for(var u=new Array(e.length),s=0;s<e.length;s++)u[s]=i.toRadians(e[s]);return o.fromRadiansArray(u,n,a)},o.fromRadiansArray=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<2)throw new t("positions length cannot be less than 2.");if(e.length%2!==0)throw new t("positions length must be a multiple of 2.");var a=e.length;r(i)?i.length=a/2:i=new Array(a/2);for(var u=0;a>u;u+=2){var s=e[u],f=e[u+1];i[u/2]=o.fromRadians(s,f,0,n,i[u/2])}return i},o.fromDegreesArrayHeights=function(e,n,a){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(e.length%3!==0)throw new t("positions length must be a multiple of 3.");for(var u=new Array(e.length),s=0;s<e.length;s+=3)u[s]=i.toRadians(e[s]),u[s+1]=i.toRadians(e[s+1]),u[s+2]=e[s+2];return o.fromRadiansArrayHeights(u,n,a)},o.fromRadiansArrayHeights=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(e.length%3!==0)throw new t("positions length must be a multiple of 3.");var a=e.length;r(i)?i.length=a/3:i=new Array(a/3);for(var u=0;a>u;u+=3){var s=e[u],f=e[u+1],l=e[u+2];i[u/3]=o.fromRadians(s,f,l,n,i[u/3])}return i},o.ZERO=n(new o(0,0,0)),o.UNIT_X=n(new o(1,0,0)),o.UNIT_Y=n(new o(0,1,0)),o.UNIT_Z=n(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r,t){return o.equalsEpsilon(this,e,r,t)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t,n){this.longitude=e(r,0),this.latitude=e(t,0),this.height=e(n,0)};return o.fromRadians=function(n,i,a,u){if(!r(n))throw new t("longitude is required.");if(!r(i))throw new t("latitude is required.");return a=e(a,0),r(u)?(u.longitude=n,u.latitude=i,u.height=a,u):new o(n,i,a)},o.fromDegrees=function(e,n,a,u){if(!r(e))throw new t("longitude is required.");if(!r(n))throw new t("latitude is required.");return e=i.toRadians(e),n=i.toRadians(n),o.fromRadians(e,n,a,u)},o.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new o(e.longitude,e.latitude,e.height):void 0},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},o.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.longitude-n.longitude)<=i&&Math.abs(e.latitude-n.latitude)<=i&&Math.abs(e.height-n.height)<=i},o.ZERO=n(new o(0,0,0)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r){return o.equalsEpsilon(this,e,r)},o.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},o}),define("Core/deprecationWarning",["./defined","./DeveloperError"],function(e,r){"use strict";var t={},n=function(n,i){if(!e(n)||!e(i))throw new r("identifier and message are required.");e(t[n])||(t[n]=!0,console.log(i))};return n}),define("Core/defineProperties",["./defined"],function(e){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),t=Object.defineProperties;return r&&e(t)||(t=function(e){return e}),t}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,o,a,u){"use strict";function s(r,n,i,a){if(n=t(n,0),i=t(i,0),a=t(a,0),0>n||0>i||0>a)throw new o("All radii components must be greater than or equal to zero.");r._radii=new e(n,i,a),r._radiiSquared=new e(n*n,i*i,a*a),r._radiiToTheFourth=new e(n*n*n*n,i*i*i*i,a*a*a*a),r._oneOverRadii=new e(0===n?0:1/n,0===i?0:1/i,0===a?0:1/a),r._oneOverRadiiSquared=new e(0===n?0:1/(n*n),0===i?0:1/(i*i),0===a?0:1/(a*a)),r._minimumRadius=Math.min(n,i,a),r._maximumRadius=Math.max(n,i,a),r._centerToleranceSquared=u.EPSILON1}var f=function(e,r,t){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,s(this,e,r,t)};i(f.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),f.clone=function(r,t){if(!n(r))return void 0;var i=r._radii;return n(t)?(e.clone(i,t._radii),e.clone(r._radiiSquared,t._radiiSquared),e.clone(r._radiiToTheFourth,t._radiiToTheFourth),e.clone(r._oneOverRadii,t._oneOverRadii),e.clone(r._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=r._minimumRadius,t._maximumRadius=r._maximumRadius,t._centerToleranceSquared=r._centerToleranceSquared,t):new f(i.x,i.y,i.z)},f.fromCartesian3=function(e,r){return n(r)||(r=new f),n(e)?(s(r,e.x,e.y,e.z),r):r},f.WGS84=a(new f(6378137,6378137,6356752.314245179)),f.UNIT_SPHERE=a(new f(1,1,1)),f.MOON=a(new f(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),f.prototype.clone=function(e){return f.clone(this,e)},f.packedLength=e.packedLength,f.pack=function(r,i,a){if(!n(r))throw new o("value is required");if(!n(i))throw new o("array is required");a=t(a,0),e.pack(r._radii,i,a)},f.unpack=function(r,i,a){if(!n(r))throw new o("array is required");i=t(i,0);var u=e.unpack(r,i);return f.fromCartesian3(u,a)},f.prototype.geocentricSurfaceNormal=e.normalize,f.prototype.geodeticSurfaceNormalCartographic=function(r,t){if(!n(r))throw new o("cartographic is required.");var i=r.longitude,a=r.latitude,u=Math.cos(a),s=u*Math.cos(i),f=u*Math.sin(i),l=Math.sin(a);return n(t)||(t=new e),t.x=s,t.y=f,t.z=l,e.normalize(t,t)},f.prototype.geodeticSurfaceNormal=function(r,t){return n(t)||(t=new e),t=e.multiplyComponents(r,this._oneOverRadiiSquared,t),e.normalize(t,t)};var l=new e,c=new e;f.prototype.cartographicToCartesian=function(r,t){var i=l,o=c;this.geodeticSurfaceNormalCartographic(r,i),e.multiplyComponents(this._radiiSquared,i,o);var a=Math.sqrt(e.dot(i,o));return e.divideByScalar(o,a,o),e.multiplyByScalar(i,r.height,i),n(t)||(t=new e),e.add(o,i,t)},f.prototype.cartographicArrayToCartesianArray=function(e,r){if(!n(e))throw new o("cartographics is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;i++)r[i]=this.cartographicToCartesian(e[i],r[i]);return r};var h=new e,d=new e,w=new e;f.prototype.cartesianToCartographic=function(t,i){var o=this.scaleToGeodeticSurface(t,d);if(!n(o))return void 0;var a=this.geodeticSurfaceNormal(o,h),s=e.subtract(t,o,w),f=Math.atan2(a.y,a.x),l=Math.asin(a.z),c=u.sign(e.dot(s,t))*e.magnitude(s);return n(i)?(i.longitude=f,i.latitude=l,i.height=c,i):new r(f,l,c)},f.prototype.cartesianArrayToCartographicArray=function(e,r){if(!n(e))throw new o("cartesians is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;++i)r[i]=this.cartesianToCartographic(e[i],r[i]);return r};var E=new e,m=new e;return f.prototype.scaleToGeodeticSurface=function(r,t){if(!n(r))throw new o("cartesian is required.");var i=r.x,a=r.y,s=r.z,f=this._oneOverRadii,l=f.x,c=f.y,h=f.z,d=i*i*l*l,w=a*a*c*c,p=s*s*h*h,y=d+w+p,T=Math.sqrt(1/y),A=e.multiplyByScalar(r,T,E);if(y<this._centerToleranceSquared)return isFinite(T)?e.clone(A,t):void 0;var R=this._oneOverRadiiSquared,v=R.x,_=R.y,g=R.z,S=m;S.x=A.x*v*2,S.y=A.y*_*2,S.z=A.z*g*2;var C,N,I,O,b,M,q,L,F,P,D,x=(1-T)*e.magnitude(r)/(.5*e.magnitude(S)),U=0;do{x-=U,I=1/(1+x*v),O=1/(1+x*_),b=1/(1+x*g),M=I*I,q=O*O,L=b*b,F=M*I,P=q*O,D=L*b,C=d*M+w*q+p*L-1,N=d*F*v+w*P*_+p*D*g;var B=-2*N;U=C/B}while(Math.abs(C)>u.EPSILON12);return n(t)?(t.x=i*I,t.y=a*O,t.z=s*b,t):new e(i*I,a*O,s*b)},f.prototype.scaleToGeocentricSurface=function(r,t){if(!n(r))throw new o("cartesian is required.");n(t)||(t=new e);var i=r.x,a=r.y,u=r.z,s=this._oneOverRadiiSquared,f=1/Math.sqrt(i*i*s.x+a*a*s.y+u*u*s.z);return e.multiplyByScalar(r,f,t)},f.prototype.transformPositionToScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._oneOverRadii,t)},f.prototype.transformPositionFromScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._radii,t)},f.prototype.equals=function(r){return this===r||n(r)&&e.equals(this._radii,r._radii)},f.prototype.toString=function(){return this._radii.toString()},f}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,r,t,n,i,o,a){"use strict";var u=function(e){this._ellipsoid=t(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(r,t){var i=this._semimajorAxis,o=r.longitude*i,a=r.latitude*i,u=r.height;return n(t)?(t.x=o,t.y=a,t.z=u,t):new e(o,a,u)},u.prototype.unproject=function(e,t){if(!n(e))throw new o("cartesian is required");var i=this._oneOverSemimajorAxis,a=e.x*i,u=e.y*i,s=e.z;return n(t)?(t.longitude=a,t.latitude=u,t.height=s,t):new r(a,u,s)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var r={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(r)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var r=function(r,t){this.start=e(r,0),this.stop=e(t,0)};return r}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t,n,i){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0),this.w=e(i,0)};o.fromElements=function(e,t,n,i,a){return r(a)?(a.x=e,a.y=t,a.z=n,a.w=i,a):new o(e,t,n,i)},o.fromColor=function(e,n){if(!r(e))throw new t("color is required");return r(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new o(e.red,e.green,e.blue,e.alpha)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new o(e.x,e.y,e.z,e.w):void 0},o.packedLength=4,o.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.x,i[o++]=n.y,i[o++]=n.z,i[o]=n.w},o.unpack=function(n,i,a){if(!r(n))throw new t("array is required");return i=e(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i++],a.w=n[i],a},o.fromArray=o.unpack,o.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z,e.w)},o.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z,e.w)},o.minimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i.w=Math.min(e.w,n.w),i},o.maximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i.w=Math.max(e.w,n.w),i},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitude(a)},o.distanceSquared=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitudeSquared(a)},o.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=o.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n.w=e.w/i,n},o.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z+e.w*n.w},o.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i.w=e.w*n.w,i},o.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i.w=e.w+n.w,i},o.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i.w=e.w-n.w,i},o.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i.w=e.w*n,i},o.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i.w=e.w/n,i},o.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n.w=-e.w,n},o.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n.w=Math.abs(e.w),n};var u=new o;o.lerp=function(e,n,i,a){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(n,i,u),a=o.multiplyByScalar(e,1-i,a),o.add(u,a,a)};var s=new o;return o.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=o.normalize(e,s);return o.abs(i,i),n=i.x<=i.y?i.x<=i.z?i.x<=i.w?o.clone(o.UNIT_X,n):o.clone(o.UNIT_W,n):i.z<=i.w?o.clone(o.UNIT_Z,n):o.clone(o.UNIT_W,n):i.y<=i.z?i.y<=i.w?o.clone(o.UNIT_Y,n):o.clone(o.UNIT_W,n):i.z<=i.w?o.clone(o.UNIT_Z,n):o.clone(o.UNIT_W,n)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},o.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]&&e.z===r[t+2]&&e.w===r[t+3]},o.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)&&i.equalsEpsilon(e.z,t.z,n,o)&&i.equalsEpsilon(e.w,t.w,n,o)},o.ZERO=n(new o(0,0,0,0)),o.UNIT_X=n(new o(1,0,0,0)),o.UNIT_Y=n(new o(0,1,0,0)),o.UNIT_Z=n(new o(0,0,1,0)),o.UNIT_W=n(new o(0,0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r,t){return o.equalsEpsilon(this,e,r,t)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},o}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,o){"use strict";function a(e){for(var r=0,t=0;9>t;++t){var n=e[t];r+=n*n}return Math.sqrt(r)}function u(e){for(var r=0,t=0;3>t;++t){var n=e[f.getElementIndex(d[t],h[t])];r+=2*n*n}return Math.sqrt(r)}function s(e,r){for(var t=o.EPSILON15,n=0,i=1,a=0;3>a;++a){var u=Math.abs(e[f.getElementIndex(d[a],h[a])]);u>n&&(i=a,n=u)}var s=1,l=0,c=h[i],w=d[i];if(Math.abs(e[f.getElementIndex(w,c)])>t){var E,m=e[f.getElementIndex(w,w)],p=e[f.getElementIndex(c,c)],y=e[f.getElementIndex(w,c)],T=(m-p)/2/y;E=0>T?-1/(-T+Math.sqrt(1+T*T)):1/(T+Math.sqrt(1+T*T)),s=1/Math.sqrt(1+E*E),l=E*s}return r=f.clone(f.IDENTITY,r),r[f.getElementIndex(c,c)]=r[f.getElementIndex(w,w)]=s,r[f.getElementIndex(w,c)]=l,r[f.getElementIndex(c,w)]=-l,r}var f=function(e,t,n,i,o,a,u,s,f){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(o,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(a,0),this[8]=r(f,0)};f.packedLength=9,f.pack=function(e,i,o){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");o=r(o,0),i[o++]=e[0],i[o++]=e[1],i[o++]=e[2],i[o++]=e[3],i[o++]=e[4],i[o++]=e[5],i[o++]=e[6],i[o++]=e[7],i[o++]=e[8]},f.unpack=function(e,i,o){if(!t(e))throw new n("array is required");return i=r(i,0),t(o)||(o=new f),o[0]=e[i++],o[1]=e[i++],o[2]=e[i++],o[3]=e[i++],o[4]=e[i++],o[5]=e[i++],o[6]=e[i++],o[7]=e[i++],o[8]=e[i++],o},f.clone=function(e,r){return t(e)?t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):new f(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},f.fromArray=function(e,i,o){if(!t(e))throw new n("array is required");return i=r(i,0),t(o)||(o=new f),o[0]=e[i],o[1]=e[i+1],o[2]=e[i+2],o[3]=e[i+3],o[4]=e[i+4],o[5]=e[i+5],o[6]=e[i+6],o[7]=e[i+7],o[8]=e[i+8],o},f.fromColumnMajorArray=function(e,r){if(!t(e))throw new n("values parameter is required");return f.clone(e,r)},f.fromRowMajorArray=function(e,r){if(!t(e))throw new n("values is required.");return t(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},f.fromQuaternion=function(e,r){if(!t(e))throw new n("quaternion is required");var i=e.x*e.x,o=e.x*e.y,a=e.x*e.z,u=e.x*e.w,s=e.y*e.y,l=e.y*e.z,c=e.y*e.w,h=e.z*e.z,d=e.z*e.w,w=e.w*e.w,E=i-s-h+w,m=2*(o-d),p=2*(a+c),y=2*(o+d),T=-i+s-h+w,A=2*(l-u),R=2*(a-c),v=2*(l+u),_=-i-s+h+w;return t(r)?(r[0]=E,r[1]=y,r[2]=R,r[3]=m,r[4]=T,r[5]=v,r[6]=p,r[7]=A,r[8]=_,r):new f(E,m,p,y,T,A,R,v,_)},f.fromScale=function(e,r){if(!t(e))throw new n("scale is required.");return t(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new f(e.x,0,0,0,e.y,0,0,0,e.z)},f.fromUniformScale=function(e,r){if("number"!=typeof e)throw new n("scale is required.");return t(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new f(e,0,0,0,e,0,0,0,e)},f.fromCrossProduct=function(e,r){if(!t(e))throw new n("vector is required.");return t(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new f(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},f.fromRotationX=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=o,r[6]=0,r[7]=-o,r[8]=i,r):new f(1,0,0,0,i,-o,0,o,i)},f.fromRotationY=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=i,r[1]=0,r[2]=-o,r[3]=0,r[4]=1,r[5]=0,r[6]=o,r[7]=0,r[8]=i,r):new f(i,0,o,0,1,0,-o,0,i)},f.fromRotationZ=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=i,r[1]=o,r[2]=0,r[3]=-o,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new f(i,-o,0,o,i,0,0,0,1)},f.toArray=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},f.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>2)throw new n("row must be 0, 1, or 2.");if("number"!=typeof e||0>e||e>2)throw new n("column must be 0, 1, or 2.");return 3*e+r},f.getColumn=function(e,r,i){if(!t(e))throw new n("matrix is required.");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(i))throw new n("result is required");var o=3*r,a=e[o],u=e[o+1],s=e[o+2];return i.x=a,i.y=u,i.z=s,i},f.setColumn=function(e,r,i,o){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(o))throw new n("result is required");o=f.clone(e,o);var a=3*r;return o[a]=i.x,o[a+1]=i.y,o[a+2]=i.z,o},f.getRow=function(e,r,i){if(!t(e))throw new n("matrix is required.");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(i))throw new n("result is required");var o=e[r],a=e[r+3],u=e[r+6];
return i.x=o,i.y=a,i.z=u,i},f.setRow=function(e,r,i,o){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(o))throw new n("result is required");return o=f.clone(e,o),o[r]=i.x,o[r+3]=i.y,o[r+6]=i.z,o};var l=new e;f.getScale=function(r,i){if(!t(r))throw new n("matrix is required.");if(!t(i))throw new n("result is required");return i.x=e.magnitude(e.fromElements(r[0],r[1],r[2],l)),i.y=e.magnitude(e.fromElements(r[3],r[4],r[5],l)),i.z=e.magnitude(e.fromElements(r[6],r[7],r[8],l)),i};var c=new e;f.getMaximumScale=function(r){return f.getScale(r,c),e.maximumComponent(c)},f.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");var o=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],a=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],u=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],s=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],f=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],l=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],c=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],h=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],d=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return i[0]=o,i[1]=a,i[2]=u,i[3]=s,i[4]=f,i[5]=l,i[6]=c,i[7]=h,i[8]=d,i},f.add=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i[0]=e[0]+r[0],i[1]=e[1]+r[1],i[2]=e[2]+r[2],i[3]=e[3]+r[3],i[4]=e[4]+r[4],i[5]=e[5]+r[5],i[6]=e[6]+r[6],i[7]=e[7]+r[7],i[8]=e[8]+r[8],i},f.subtract=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],i[3]=e[3]-r[3],i[4]=e[4]-r[4],i[5]=e[5]-r[5],i[6]=e[6]-r[6],i[7]=e[7]-r[7],i[8]=e[8]-r[8],i},f.multiplyByVector=function(e,r,i){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("cartesian is required");if(!t(i))throw new n("result is required");var o=r.x,a=r.y,u=r.z,s=e[0]*o+e[3]*a+e[6]*u,f=e[1]*o+e[4]*a+e[7]*u,l=e[2]*o+e[5]*a+e[8]*u;return i.x=s,i.y=f,i.z=l,i},f.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scalar must be a number");if(!t(i))throw new n("result is required");return i[0]=e[0]*r,i[1]=e[1]*r,i[2]=e[2]*r,i[3]=e[3]*r,i[4]=e[4]*r,i[5]=e[5]*r,i[6]=e[6]*r,i[7]=e[7]*r,i[8]=e[8]*r,i},f.multiplyByScale=function(e,r,i){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("scale is required");if(!t(i))throw new n("result is required");return i[0]=e[0]*r.x,i[1]=e[1]*r.x,i[2]=e[2]*r.x,i[3]=e[3]*r.y,i[4]=e[4]*r.y,i[5]=e[5]*r.y,i[6]=e[6]*r.z,i[7]=e[7]*r.z,i[8]=e[8]*r.z,i},f.negate=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");return r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},f.transpose=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");var i=e[0],o=e[3],a=e[6],u=e[1],s=e[4],f=e[7],l=e[2],c=e[5],h=e[8];return r[0]=i,r[1]=o,r[2]=a,r[3]=u,r[4]=s,r[5]=f,r[6]=l,r[7]=c,r[8]=h,r};var h=[1,0,0],d=[2,2,1],w=new f,E=new f;return f.computeEigenDecomposition=function(e,r){if(!t(e))throw new n("matrix is required.");var i=o.EPSILON20,l=10,c=0,h=0;t(r)||(r={});for(var d=r.unitary=f.clone(f.IDENTITY,r.unitary),m=r.diagonal=f.clone(e,r.diagonal),p=i*a(m);l>h&&u(m)>p;)s(m,w),f.transpose(w,E),f.multiply(m,w,m),f.multiply(E,m,m),f.multiply(d,w,d),++c>2&&(++h,c=0);return r},f.abs=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");return r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},f.determinant=function(e){if(!t(e))throw new n("matrix is required");var r=e[0],i=e[3],o=e[6],a=e[1],u=e[4],s=e[7],f=e[2],l=e[5],c=e[8];return r*(u*c-l*s)+a*(l*o-i*c)+f*(i*s-u*o)},f.inverse=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");var i=e[0],a=e[1],u=e[2],s=e[3],l=e[4],c=e[5],h=e[6],d=e[7],w=e[8],E=f.determinant(e);if(Math.abs(E)<=o.EPSILON15)throw new n("matrix is not invertible");r[0]=l*w-d*c,r[1]=d*u-a*w,r[2]=a*c-l*u,r[3]=h*c-s*w,r[4]=i*w-h*u,r[5]=s*u-i*c,r[6]=s*d-h*l,r[7]=h*a-i*d,r[8]=i*l-s*a;var m=1/E;return f.multiplyByScalar(r,m,r)},f.equals=function(e,r){return e===r||t(e)&&t(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]},f.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon must be a number");return e===r||t(e)&&t(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},f.IDENTITY=i(new f(1,0,0,0,1,0,0,0,1)),f.ZERO=i(new f(0,0,0,0,0,0,0,0,0)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN1ROW0=3,f.COLUMN1ROW1=4,f.COLUMN1ROW2=5,f.COLUMN2ROW0=6,f.COLUMN2ROW1=7,f.COLUMN2ROW2=8,f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.equalsArray=function(e,r,t){return e[0]===r[t]&&e[1]===r[t+1]&&e[2]===r[t+2]&&e[3]===r[t+3]&&e[4]===r[t+4]&&e[5]===r[t+5]&&e[6]===r[t+6]&&e[7]===r[t+7]&&e[8]===r[t+8]},f.prototype.equalsEpsilon=function(e,r){return f.equalsEpsilon(this,e,r)},f.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},f}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var r=function(e){this.name="RuntimeError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,r,t,n,i,o,a,u,s){"use strict";var f=function(e,r,n,i,o,a,u,s,f,l,c,h,d,w,E,m){this[0]=t(e,0),this[1]=t(o,0),this[2]=t(f,0),this[3]=t(d,0),this[4]=t(r,0),this[5]=t(a,0),this[6]=t(l,0),this[7]=t(w,0),this[8]=t(n,0),this[9]=t(u,0),this[10]=t(c,0),this[11]=t(E,0),this[12]=t(i,0),this[13]=t(s,0),this[14]=t(h,0),this[15]=t(m,0)};f.packedLength=16,f.pack=function(e,r,o){if(!n(e))throw new i("value is required");if(!n(r))throw new i("array is required");o=t(o,0),r[o++]=e[0],r[o++]=e[1],r[o++]=e[2],r[o++]=e[3],r[o++]=e[4],r[o++]=e[5],r[o++]=e[6],r[o++]=e[7],r[o++]=e[8],r[o++]=e[9],r[o++]=e[10],r[o++]=e[11],r[o++]=e[12],r[o++]=e[13],r[o++]=e[14],r[o]=e[15]},f.unpack=function(e,r,o){if(!n(e))throw new i("array is required");return r=t(r,0),n(o)||(o=new f),o[0]=e[r++],o[1]=e[r++],o[2]=e[r++],o[3]=e[r++],o[4]=e[r++],o[5]=e[r++],o[6]=e[r++],o[7]=e[r++],o[8]=e[r++],o[9]=e[r++],o[10]=e[r++],o[11]=e[r++],o[12]=e[r++],o[13]=e[r++],o[14]=e[r++],o[15]=e[r],o},f.clone=function(e,r){return n(e)?n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):new f(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},f.fromArray=f.unpack,f.fromColumnMajorArray=function(e,r){if(!n(e))throw new i("values is required");return f.clone(e,r)},f.fromRowMajorArray=function(e,r){if(!n(e))throw new i("values is required.");return n(r)?(r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=e[1],r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=e[2],r[9]=e[6],r[10]=e[10],r[11]=e[14],r[12]=e[3],r[13]=e[7],r[14]=e[11],r[15]=e[15],r):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},f.fromRotationTranslation=function(r,o,a){if(!n(r))throw new i("rotation is required.");return o=t(o,e.ZERO),n(a)?(a[0]=r[0],a[1]=r[1],a[2]=r[2],a[3]=0,a[4]=r[3],a[5]=r[4],a[6]=r[5],a[7]=0,a[8]=r[6],a[9]=r[7],a[10]=r[8],a[11]=0,a[12]=o.x,a[13]=o.y,a[14]=o.z,a[15]=1,a):new f(r[0],r[3],r[6],o.x,r[1],r[4],r[7],o.y,r[2],r[5],r[8],o.z,0,0,0,1)},f.fromTranslationQuaternionRotationScale=function(e,r,t,o){if(!n(e))throw new i("translation is required.");if(!n(r))throw new i("rotation is required.");if(!n(t))throw new i("scale is required.");n(o)||(o=new f);var a=t.x,u=t.y,s=t.z,l=r.x*r.x,c=r.x*r.y,h=r.x*r.z,d=r.x*r.w,w=r.y*r.y,E=r.y*r.z,m=r.y*r.w,p=r.z*r.z,y=r.z*r.w,T=r.w*r.w,A=l-w-p+T,R=2*(c-y),v=2*(h+m),_=2*(c+y),g=-l+w-p+T,S=2*(E-d),C=2*(h-m),N=2*(E+d),I=-l-w+p+T;return o[0]=A*a,o[1]=_*a,o[2]=C*a,o[3]=0,o[4]=R*u,o[5]=g*u,o[6]=N*u,o[7]=0,o[8]=v*s,o[9]=S*s,o[10]=I*s,o[11]=0,o[12]=e.x,o[13]=e.y,o[14]=e.z,o[15]=1,o},f.fromTranslation=function(e,r){if(!n(e))throw new i("translation is required.");return f.fromRotationTranslation(u.IDENTITY,e,r)},f.fromScale=function(e,r){if(!n(e))throw new i("scale is required.");return n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e.y,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e.z,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new f(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},f.fromUniformScale=function(e,r){if("number"!=typeof e)throw new i("scale is required.");return n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new f(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,c=new e,h=new e;f.fromCamera=function(r,t){if(!n(r))throw new i("camera is required.");var o=r.eye,a=r.target,u=r.up;if(!n(o))throw new i("camera.eye is required.");if(!n(a))throw new i("camera.target is required.");if(!n(u))throw new i("camera.up is required.");e.normalize(e.subtract(a,o,l),l),e.normalize(e.cross(l,u,c),c),e.normalize(e.cross(c,l,h),h);var s=c.x,d=c.y,w=c.z,E=l.x,m=l.y,p=l.z,y=h.x,T=h.y,A=h.z,R=o.x,v=o.y,_=o.z,g=s*-R+d*-v+w*-_,S=y*-R+T*-v+A*-_,C=E*R+m*v+p*_;return n(t)?(t[0]=s,t[1]=y,t[2]=-E,t[3]=0,t[4]=d,t[5]=T,t[6]=-m,t[7]=0,t[8]=w,t[9]=A,t[10]=-p,t[11]=0,t[12]=g,t[13]=S,t[14]=C,t[15]=1,t):new f(s,d,w,g,y,T,A,S,-E,-m,-p,C,0,0,0,1)},f.computePerspectiveFieldOfView=function(e,r,t,o,a){if(0>=e||e>Math.PI)throw new i("fovY must be in [0, PI).");if(0>=r)throw new i("aspectRatio must be greater than zero.");if(0>=t)throw new i("near must be greater than zero.");if(0>=o)throw new i("far must be greater than zero.");if(!n(a))throw new i("result is required");var u=Math.tan(.5*e),s=1/u,f=s/r,l=(o+t)/(t-o),c=2*o*t/(t-o);return a[0]=f,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=s,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=l,a[11]=-1,a[12]=0,a[13]=0,a[14]=c,a[15]=0,a},f.computeOrthographicOffCenter=function(e,r,t,o,a,u,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(o))throw new i("top is required.");if(!n(a))throw new i("near is required.");if(!n(u))throw new i("far is required.");if(!n(s))throw new i("result is required");var f=1/(r-e),l=1/(o-t),c=1/(u-a),h=-(r+e)*f,d=-(o+t)*l,w=-(u+a)*c;return f*=2,l*=2,c*=-2,s[0]=f,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=l,s[6]=0,s[7]=0,s[8]=0,s[9]=0,s[10]=c,s[11]=0,s[12]=h,s[13]=d,s[14]=w,s[15]=1,s},f.computePerspectiveOffCenter=function(e,r,t,o,a,u,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(o))throw new i("top is required.");if(!n(a))throw new i("near is required.");if(!n(u))throw new i("far is required.");if(!n(s))throw new i("result is required");var f=2*a/(r-e),l=2*a/(o-t),c=(r+e)/(r-e),h=(o+t)/(o-t),d=-(u+a)/(u-a),w=-1,E=-2*u*a/(u-a);return s[0]=f,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=l,s[6]=0,s[7]=0,s[8]=c,s[9]=h,s[10]=d,s[11]=w,s[12]=0,s[13]=0,s[14]=E,s[15]=0,s},f.computeInfinitePerspectiveOffCenter=function(e,r,t,o,a,u){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(o))throw new i("top is required.");if(!n(a))throw new i("near is required.");if(!n(u))throw new i("result is required");var s=2*a/(r-e),f=2*a/(o-t),l=(r+e)/(r-e),c=(o+t)/(o-t),h=-1,d=-1,w=-2*a;return u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=f,u[6]=0,u[7]=0,u[8]=l,u[9]=c,u[10]=h,u[11]=d,u[12]=0,u[13]=0,u[14]=w,u[15]=0,u},f.computeViewportTransformation=function(e,r,o,a){if(!n(a))throw new i("result is required");e=t(e,t.EMPTY_OBJECT);var u=t(e.x,0),s=t(e.y,0),f=t(e.width,0),l=t(e.height,0);r=t(r,0),o=t(o,1);var c=.5*f,h=.5*l,d=.5*(o-r),w=c,E=h,m=d,p=u+c,y=s+h,T=r+d,A=1;return a[0]=w,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=E,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=m,a[11]=0,a[12]=p,a[13]=y,a[14]=T,a[15]=A,a},f.toArray=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},f.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>3)throw new i("row must be 0, 1, 2, or 3.");if("number"!=typeof e||0>e||e>3)throw new i("column must be 0, 1, 2, or 3.");return 4*e+r},f.getColumn=function(e,r,t){if(!n(e))throw new i("matrix is required.");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(t))throw new i("result is required");var o=4*r,a=e[o],u=e[o+1],s=e[o+2],f=e[o+3];return t.x=a,t.y=u,t.z=s,t.w=f,t},f.setColumn=function(e,r,t,o){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(o))throw new i("result is required");o=f.clone(e,o);var a=4*r;return o[a]=t.x,o[a+1]=t.y,o[a+2]=t.z,o[a+3]=t.w,o},f.setTranslation=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("translation is required");if(!n(t))throw new i("result is required");return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=r.x,t[13]=r.y,t[14]=r.z,t[15]=e[15],t},f.getRow=function(e,r,t){if(!n(e))throw new i("matrix is required.");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(t))throw new i("result is required");var o=e[r],a=e[r+4],u=e[r+8],s=e[r+12];return t.x=o,t.y=a,t.z=u,t.w=s,t},f.setRow=function(e,r,t,o){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(o))throw new i("result is required");return o=f.clone(e,o),o[r]=t.x,o[r+4]=t.y,o[r+8]=t.z,o[r+12]=t.w,o};var d=new e;f.getScale=function(r,t){if(!n(r))throw new i("matrix is required.");if(!n(t))throw new i("result is required");return t.x=e.magnitude(e.fromElements(r[0],r[1],r[2],d)),t.y=e.magnitude(e.fromElements(r[4],r[5],r[6],d)),t.z=e.magnitude(e.fromElements(r[8],r[9],r[10],d)),t};var w=new e;f.getMaximumScale=function(r){return f.getScale(r,w),e.maximumComponent(w)},f.multiply=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");var o=e[0],a=e[1],u=e[2],s=e[3],f=e[4],l=e[5],c=e[6],h=e[7],d=e[8],w=e[9],E=e[10],m=e[11],p=e[12],y=e[13],T=e[14],A=e[15],R=r[0],v=r[1],_=r[2],g=r[3],S=r[4],C=r[5],N=r[6],I=r[7],O=r[8],b=r[9],M=r[10],q=r[11],L=r[12],F=r[13],P=r[14],D=r[15],x=o*R+f*v+d*_+p*g,U=a*R+l*v+w*_+y*g,B=u*R+c*v+E*_+T*g,G=s*R+h*v+m*_+A*g,z=o*S+f*C+d*N+p*I,V=a*S+l*C+w*N+y*I,H=u*S+c*C+E*N+T*I,W=s*S+h*C+m*N+A*I,Y=o*O+f*b+d*M+p*q,X=a*O+l*b+w*M+y*q,k=u*O+c*b+E*M+T*q,K=s*O+h*b+m*M+A*q,Z=o*L+f*F+d*P+p*D,j=a*L+l*F+w*P+y*D,Q=u*L+c*F+E*P+T*D,J=s*L+h*F+m*P+A*D;return t[0]=x,t[1]=U,t[2]=B,t[3]=G,t[4]=z,t[5]=V,t[6]=H,t[7]=W,t[8]=Y,t[9]=X,t[10]=k,t[11]=K,t[12]=Z,t[13]=j,t[14]=Q,t[15]=J,t},f.add=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t[6]=e[6]+r[6],t[7]=e[7]+r[7],t[8]=e[8]+r[8],t[9]=e[9]+r[9],t[10]=e[10]+r[10],t[11]=e[11]+r[11],t[12]=e[12]+r[12],t[13]=e[13]+r[13],t[14]=e[14]+r[14],t[15]=e[15]+r[15],t},f.subtract=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t[4]=e[4]-r[4],t[5]=e[5]-r[5],t[6]=e[6]-r[6],t[7]=e[7]-r[7],t[8]=e[8]-r[8],t[9]=e[9]-r[9],t[10]=e[10]-r[10],t[11]=e[11]-r[11],t[12]=e[12]-r[12],t[13]=e[13]-r[13],t[14]=e[14]-r[14],t[15]=e[15]-r[15],t},f.multiplyTransformation=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");var o=e[0],a=e[1],u=e[2],s=e[4],f=e[5],l=e[6],c=e[8],h=e[9],d=e[10],w=e[12],E=e[13],m=e[14],p=r[0],y=r[1],T=r[2],A=r[4],R=r[5],v=r[6],_=r[8],g=r[9],S=r[10],C=r[12],N=r[13],I=r[14],O=o*p+s*y+c*T,b=a*p+f*y+h*T,M=u*p+l*y+d*T,q=o*A+s*R+c*v,L=a*A+f*R+h*v,F=u*A+l*R+d*v,P=o*_+s*g+c*S,D=a*_+f*g+h*S,x=u*_+l*g+d*S,U=o*C+s*N+c*I+w,B=a*C+f*N+h*I+E,G=u*C+l*N+d*I+m;return t[0]=O,t[1]=b,t[2]=M,t[3]=0,t[4]=q,t[5]=L,t[6]=F,t[7]=0,t[8]=P,t[9]=D,t[10]=x,t[11]=0,t[12]=U,t[13]=B,t[14]=G,t[15]=1,t},f.multiplyByMatrix3=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("rotation is required");if(!n(t))throw new i("result is required");var o=e[0],a=e[1],u=e[2],s=e[4],f=e[5],l=e[6],c=e[8],h=e[9],d=e[10],w=r[0],E=r[1],m=r[2],p=r[3],y=r[4],T=r[5],A=r[6],R=r[7],v=r[8],_=o*w+s*E+c*m,g=a*w+f*E+h*m,S=u*w+l*E+d*m,C=o*p+s*y+c*T,N=a*p+f*y+h*T,I=u*p+l*y+d*T,O=o*A+s*R+c*v,b=a*A+f*R+h*v,M=u*A+l*R+d*v;return t[0]=_,t[1]=g,t[2]=S,t[3]=0,t[4]=C,t[5]=N,t[6]=I,t[7]=0,t[8]=O,t[9]=b,t[10]=M,t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},f.multiplyByTranslation=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("translation is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,u=r.z,s=o*e[0]+a*e[4]+u*e[8]+e[12],f=o*e[1]+a*e[5]+u*e[9]+e[13],l=o*e[2]+a*e[6]+u*e[10]+e[14];return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=s,t[13]=f,t[14]=l,t[15]=e[15],t};var E=new e;f.multiplyByUniformScale=function(e,r,t){if(!n(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scale is required");if(!n(t))throw new i("result is required");return E.x=r,E.y=r,E.z=r,f.multiplyByScale(e,E,t)},f.multiplyByScale=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("scale is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,u=r.z;return 1===o&&1===a&&1===u?f.clone(e,t):(t[0]=o*e[0],t[1]=o*e[1],t[2]=o*e[2],t[3]=0,t[4]=a*e[4],t[5]=a*e[5],t[6]=a*e[6],t[7]=0,t[8]=u*e[8],t[9]=u*e[9],t[10]=u*e[10],t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=1,t)},f.multiplyByVector=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,u=r.z,s=r.w,f=e[0]*o+e[4]*a+e[8]*u+e[12]*s,l=e[1]*o+e[5]*a+e[9]*u+e[13]*s,c=e[2]*o+e[6]*a+e[10]*u+e[14]*s,h=e[3]*o+e[7]*a+e[11]*u+e[15]*s;return t.x=f,t.y=l,t.z=c,t.w=h,t},f.multiplyByPointAsVector=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,u=r.z,s=e[0]*o+e[4]*a+e[8]*u,f=e[1]*o+e[5]*a+e[9]*u,l=e[2]*o+e[6]*a+e[10]*u;return t.x=s,t.y=f,t.z=l,t},f.multiplyByPoint=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,u=r.z,s=e[0]*o+e[4]*a+e[8]*u+e[12],f=e[1]*o+e[5]*a+e[9]*u+e[13],l=e[2]*o+e[6]*a+e[10]*u+e[14];return t.x=s,t.y=f,t.z=l,t},f.multiplyByScalar=function(e,r,t){if(!n(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scalar must be a number");if(!n(t))throw new i("result is required");return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t},f.negate=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r[9]=-e[9],r[10]=-e[10],r[11]=-e[11],r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=-e[15],r},f.transpose=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");var t=e[1],o=e[2],a=e[3],u=e[6],s=e[7],f=e[11];return r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=t,r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=o,r[9]=u,r[10]=e[10],r[11]=e[14],r[12]=a,r[13]=s,r[14]=f,r[15]=e[15],r},f.abs=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r[9]=Math.abs(e[9]),r[10]=Math.abs(e[10]),r[11]=Math.abs(e[11]),r[12]=Math.abs(e[12]),r[13]=Math.abs(e[13]),r[14]=Math.abs(e[14]),r[15]=Math.abs(e[15]),r},f.equals=function(e,r){return e===r||n(e)&&n(r)&&e[12]===r[12]&&e[13]===r[13]&&e[14]===r[14]&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[8]===r[8]&&e[9]===r[9]&&e[10]===r[10]&&e[3]===r[3]&&e[7]===r[7]&&e[11]===r[11]&&e[15]===r[15]},f.equalsEpsilon=function(e,r,t){if("number"!=typeof t)throw new i("epsilon must be a number");return e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=t&&Math.abs(e[1]-r[1])<=t&&Math.abs(e[2]-r[2])<=t&&Math.abs(e[3]-r[3])<=t&&Math.abs(e[4]-r[4])<=t&&Math.abs(e[5]-r[5])<=t&&Math.abs(e[6]-r[6])<=t&&Math.abs(e[7]-r[7])<=t&&Math.abs(e[8]-r[8])<=t&&Math.abs(e[9]-r[9])<=t&&Math.abs(e[10]-r[10])<=t&&Math.abs(e[11]-r[11])<=t&&Math.abs(e[12]-r[12])<=t&&Math.abs(e[13]-r[13])<=t&&Math.abs(e[14]-r[14])<=t&&Math.abs(e[15]-r[15])<=t},f.getTranslation=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r.x=e[12],r.y=e[13],r.z=e[14],r},f.getRotation=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[4],r[4]=e[5],r[5]=e[6],r[6]=e[8],r[7]=e[9],r[8]=e[10],r};var m=new u,p=new u,y=new r,T=new r(0,0,0,1);return f.inverse=function(e,t){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("result is required");if(u.equalsEpsilon(f.getRotation(e,m),p,a.EPSILON7)&&r.equals(f.getRow(e,3,y),T))return t[0]=0,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=0,t[11]=0,t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=1,t;var o=e[0],l=e[4],c=e[8],h=e[12],d=e[1],w=e[5],E=e[9],A=e[13],R=e[2],v=e[6],_=e[10],g=e[14],S=e[3],C=e[7],N=e[11],I=e[15],O=_*I,b=g*N,M=v*I,q=g*C,L=v*N,F=_*C,P=R*I,D=g*S,x=R*N,U=_*S,B=R*C,G=v*S,z=O*w+q*E+L*A-(b*w+M*E+F*A),V=b*d+P*E+U*A-(O*d+D*E+x*A),H=M*d+D*w+B*A-(q*d+P*w+G*A),W=F*d+x*w+G*E-(L*d+U*w+B*E),Y=b*l+M*c+F*h-(O*l+q*c+L*h),X=O*o+D*c+x*h-(b*o+P*c+U*h),k=q*o+P*l+G*h-(M*o+D*l+B*h),K=L*o+U*l+B*c-(F*o+x*l+G*c);O=c*A,b=h*E,M=l*A,q=h*w,L=l*E,F=c*w,P=o*A,D=h*d,x=o*E,U=c*d,B=o*w,G=l*d;var Z=O*C+q*N+L*I-(b*C+M*N+F*I),j=b*S+P*N+U*I-(O*S+D*N+x*I),Q=M*S+D*C+B*I-(q*S+P*C+G*I),J=F*S+x*C+G*N-(L*S+U*C+B*N),$=M*_+F*g+b*v-(L*g+O*v+q*_),ee=x*g+O*R+D*_-(P*_+U*g+b*R),re=P*v+G*g+q*R-(B*g+M*R+D*v),te=B*_+L*R+U*v-(x*v+G*_+F*R),ne=o*z+l*V+c*H+h*W;if(Math.abs(ne)<a.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return ne=1/ne,t[0]=z*ne,t[1]=V*ne,t[2]=H*ne,t[3]=W*ne,t[4]=Y*ne,t[5]=X*ne,t[6]=k*ne,t[7]=K*ne,t[8]=Z*ne,t[9]=j*ne,t[10]=Q*ne,t[11]=J*ne,t[12]=$*ne,t[13]=ee*ne,t[14]=re*ne,t[15]=te*ne,t},f.inverseTransformation=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");var t=e[0],o=e[1],a=e[2],u=e[4],s=e[5],f=e[6],l=e[8],c=e[9],h=e[10],d=e[12],w=e[13],E=e[14],m=-t*d-o*w-a*E,p=-u*d-s*w-f*E,y=-l*d-c*w-h*E;return r[0]=t,r[1]=u,r[2]=l,r[3]=0,r[4]=o,r[5]=s,r[6]=c,r[7]=0,r[8]=a,r[9]=f,r[10]=h,r[11]=0,r[12]=m,r[13]=p,r[14]=y,r[15]=1,r},f.IDENTITY=o(new f(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),f.ZERO=o(new f(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN0ROW3=3,f.COLUMN1ROW0=4,f.COLUMN1ROW1=5,f.COLUMN1ROW2=6,f.COLUMN1ROW3=7,f.COLUMN2ROW0=8,f.COLUMN2ROW1=9,f.COLUMN2ROW2=10,f.COLUMN2ROW3=11,f.COLUMN3ROW0=12,f.COLUMN3ROW1=13,f.COLUMN3ROW2=14,f.COLUMN3ROW3=15,f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.equalsArray=function(e,r,t){return e[0]===r[t]&&e[1]===r[t+1]&&e[2]===r[t+2]&&e[3]===r[t+3]&&e[4]===r[t+4]&&e[5]===r[t+5]&&e[6]===r[t+6]&&e[7]===r[t+7]&&e[8]===r[t+8]&&e[9]===r[t+9]&&e[10]===r[t+10]&&e[11]===r[t+11]&&e[12]===r[t+12]&&e[13]===r[t+13]&&e[14]===r[t+14]&&e[15]===r[t+15]},f.prototype.equalsEpsilon=function(e,r){return f.equalsEpsilon(this,e,r)},f.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},f}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,r,t,n){"use strict";var i=function(n,i){if(!r(n))throw new t("normal is required.");if(!r(i))throw new t("distance is required.");this.normal=e.clone(n),this.distance=i};i.fromPointNormal=function(n,o,a){if(!r(n))throw new t("point is required.");if(!r(o))throw new t("normal is required.");var u=-e.dot(o,n);return r(a)?(e.clone(o,a.normal),a.distance=u,a):new i(o,u)};var o=new e;return i.fromCartesian4=function(n,a){if(!r(n))throw new t("coefficients is required.");var u=e.fromCartesian4(n,o),s=n.w;return r(a)?(e.clone(u,a.normal),a.distance=s,a):new i(u,s)},i.getPointDistance=function(n,i){if(!r(n))throw new t("plane is required.");if(!r(i))throw new t("point is required.");return e.dot(n.normal,i)+n.distance},i.ORIGIN_XY_PLANE=n(new i(e.UNIT_Z,0)),i.ORIGIN_YZ_PLANE=n(new i(e.UNIT_X,0)),i.ORIGIN_ZX_PLANE=n(new i(e.UNIT_Y,0)),i}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,r,t,n,i,o,a,u){"use strict";var s=function(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)};n(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,o){if(!t(e))throw new i("value is required");if(!t(n))throw new i("array is required");o=r(o,0),n[o++]=e.west,n[o++]=e.south,n[o++]=e.east,n[o]=e.north},s.unpack=function(e,n,o){if(!t(e))throw new i("array is required");return n=r(n,0),t(o)||(o=new s),o.west=e[n++],o.south=e[n++],o.east=e[n++],o.north=e[n],o},s.computeWidth=function(e){if(!t(e))throw new i("rectangle is required.");var r=e.east,n=e.west;return n>r&&(r+=u.TWO_PI),r-n},s.computeHeight=function(e){if(!t(e))throw new i("rectangle is required.");return e.north-e.south},s.fromDegrees=function(e,n,i,o,a){return e=u.toRadians(r(e,0)),n=u.toRadians(r(n,0)),i=u.toRadians(r(i,0)),o=u.toRadians(r(o,0)),t(a)?(a.west=e,a.south=n,a.east=i,a.north=o,a):new s(e,n,i,o)},s.fromCartographicArray=function(e,r){if(!t(e))throw new i("cartographics is required.");for(var n=Number.MAX_VALUE,o=-Number.MAX_VALUE,a=Number.MAX_VALUE,u=-Number.MAX_VALUE,f=0,l=e.length;l>f;f++){var c=e[f];n=Math.min(n,c.longitude),o=Math.max(o,c.longitude),a=Math.min(a,c.latitude),u=Math.max(u,c.latitude)}return t(r)?(r.west=n,r.south=a,r.east=o,r.north=u,r):new s(n,a,o,u)},s.clone=function(e,r){return t(e)?t(r)?(r.west=e.west,r.south=e.south,r.east=e.east,r.north=e.north,r):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.west===r.west&&e.south===r.south&&e.east===r.east&&e.north===r.north},s.prototype.equalsEpsilon=function(e,r){if("number"!=typeof r)throw new i("epsilon is required and must be a number.");return t(e)&&Math.abs(this.west-e.west)<=r&&Math.abs(this.south-e.south)<=r&&Math.abs(this.east-e.east)<=r&&Math.abs(this.north-e.north)<=r},s.validate=function(e){if(!t(e))throw new i("rectangle is required");var r=e.north;if("number"!=typeof r)throw new i("north is required to be a number.");if(r<-u.PI_OVER_TWO||r>u.PI_OVER_TWO)throw new i("north must be in the interval [-Pi/2, Pi/2].");var n=e.south;if("number"!=typeof n)throw new i("south is required to be a number.");if(n<-u.PI_OVER_TWO||n>u.PI_OVER_TWO)throw new i("south must be in the interval [-Pi/2, Pi/2].");var o=e.west;if("number"!=typeof o)throw new i("west is required to be a number.");if(o<-Math.PI||o>Math.PI)throw new i("west must be in the interval [-Pi, Pi].");var a=e.east;if("number"!=typeof a)throw new i("east is required to be a number.");if(a<-Math.PI||a>Math.PI)throw new i("east must be in the interval [-Pi, Pi].")},s.southwest=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.west,n.latitude=r.south,n.height=0,n):new e(r.west,r.south)},s.northwest=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.west,n.latitude=r.north,n.height=0,n):new e(r.west,r.north)},s.northeast=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.east,n.latitude=r.north,n.height=0,n):new e(r.east,r.north)},s.southeast=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.east,n.latitude=r.south,n.height=0,n):new e(r.east,r.south)},s.center=function(r,n){if(!t(r))throw new i("rectangle is required");var o=r.east,a=r.west;a>o&&(o+=u.TWO_PI);var s=u.negativePiToPi(.5*(a+o)),f=.5*(r.south+r.north);return t(n)?(n.longitude=s,n.latitude=f,n.height=0,n):new e(s,f)},s.intersection=function(e,r,n){if(!t(e))throw new i("rectangle is required");if(!t(r))throw new i("otherRectangle is required.");var o=e.east,a=e.west,f=r.east,l=r.west;a>o&&f>0?o+=u.TWO_PI:l>f&&o>0&&(f+=u.TWO_PI),a>o&&0>l?l+=u.TWO_PI:l>f&&0>a&&(a+=u.TWO_PI);var c=u.negativePiToPi(Math.max(a,l)),h=u.negativePiToPi(Math.min(o,f));if((e.west<e.east||r.west<r.east)&&c>=h)return void 0;var d=Math.max(e.south,r.south),w=Math.min(e.north,r.north);return d>=w?void 0:t(n)?(n.west=c,n.south=d,n.east=h,n.north=w,n):new s(c,d,h,w)},s.contains=function(e,r){if(!t(e))throw new i("rectangle is required");if(!t(r))throw new i("cartographic is required.");var n=r.longitude,o=r.latitude,a=e.west,s=e.east;return a>s&&(s+=u.TWO_PI,0>n&&(n+=u.TWO_PI)),(n>a||u.equalsEpsilon(n,a,u.EPSILON14))&&(s>n||u.equalsEpsilon(n,s,u.EPSILON14))&&o>=e.south&&o<=e.north};var f=new e;return s.subsample=function(e,n,a,l){if(!t(e))throw new i("rectangle is required");n=r(n,o.WGS84),a=r(a,0),t(l)||(l=[]);var c=0,h=e.north,d=e.south,w=e.east,E=e.west,m=f;m.height=a,m.longitude=E,m.latitude=h,l[c]=n.cartographicToCartesian(m,l[c]),c++,m.longitude=w,l[c]=n.cartographicToCartesian(m,l[c]),c++,m.latitude=d,l[c]=n.cartographicToCartesian(m,l[c]),c++,m.longitude=E,l[c]=n.cartographicToCartesian(m,l[c]),c++,0>h?m.latitude=h:d>0?m.latitude=d:m.latitude=0;for(var p=1;8>p;++p)m.longitude=-Math.PI+p*u.PI_OVER_TWO,s.contains(e,m)&&(l[c]=n.cartographicToCartesian(m,l[c]),c++);return 0===m.latitude&&(m.longitude=E,l[c]=n.cartographicToCartesian(m,l[c]),c++,m.longitude=w,l[c]=n.cartographicToCartesian(m,l[c]),c++),l.length=c,l},s.MAX_VALUE=a(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Plane","./Rectangle"],function(e,r,t,n,i,o,a,u,s,f,l,c,h){
"use strict";var d=function(r,n){this.center=e.clone(t(r,e.ZERO)),this.radius=t(n,0)},w=new e,E=new e,m=new e,p=new e,y=new e,T=new e,A=new e,R=new e,v=new e,_=new e,g=new e,S=new e;d.fromPoints=function(r,t){if(n(t)||(t=new d),!n(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;for(var i=e.clone(r[0],A),o=e.clone(i,w),a=e.clone(i,E),u=e.clone(i,m),s=e.clone(i,p),f=e.clone(i,y),l=e.clone(i,T),c=r.length,h=1;c>h;h++){e.clone(r[h],i);var C=i.x,N=i.y,I=i.z;C<o.x&&e.clone(i,o),C>s.x&&e.clone(i,s),N<a.y&&e.clone(i,a),N>f.y&&e.clone(i,f),I<u.z&&e.clone(i,u),I>l.z&&e.clone(i,l)}var O=e.magnitudeSquared(e.subtract(s,o,R)),b=e.magnitudeSquared(e.subtract(f,a,R)),M=e.magnitudeSquared(e.subtract(l,u,R)),q=o,L=s,F=O;b>F&&(F=b,q=a,L=f),M>F&&(F=M,q=u,L=l);var P=v;P.x=.5*(q.x+L.x),P.y=.5*(q.y+L.y),P.z=.5*(q.z+L.z);var D=e.magnitudeSquared(e.subtract(L,P,R)),x=Math.sqrt(D),U=_;U.x=o.x,U.y=a.y,U.z=u.z;var B=g;B.x=s.x,B.y=f.y,B.z=l.z;var G=e.multiplyByScalar(e.add(U,B,R),.5,S),z=0;for(h=0;c>h;h++){e.clone(r[h],i);var V=e.magnitude(e.subtract(i,G,R));V>z&&(z=V);var H=e.magnitudeSquared(e.subtract(i,P,R));if(H>D){var W=Math.sqrt(H);x=.5*(x+W),D=x*x;var Y=W-x;P.x=(x*P.x+Y*i.x)/W,P.y=(x*P.y+Y*i.y)/W,P.z=(x*P.z+Y*i.z)/W}}return z>x?(e.clone(P,t.center),t.radius=x):(e.clone(G,t.center),t.radius=z),t};var C=new u,N=new e,I=new e,O=new r,b=new r;d.fromRectangle2D=function(e,r,t){return d.fromRectangleWithHeights2D(e,r,0,0,t)},d.fromRectangleWithHeights2D=function(r,i,o,a,u){if(n(u)||(u=new d),!n(r))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;i=t(i,C),h.southwest(r,O),O.height=o,h.northeast(r,b),b.height=a;var s=i.project(O,N),f=i.project(b,I),l=f.x-s.x,c=f.y-s.y,w=f.z-s.z;u.radius=.5*Math.sqrt(l*l+c*c+w*w);var E=u.center;return E.x=s.x+.5*l,E.y=s.y+.5*c,E.z=s.z+.5*w,u};var M=[];d.fromRectangle3D=function(e,r,i,o){r=t(r,a.WGS84),i=t(i,0);var u;return n(e)&&(u=h.subsample(e,r,i,M)),d.fromPoints(u,o)},d.fromVertices=function(r,i,a,u){if(n(u)||(u=new d),!n(r)||0===r.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;if(i=t(i,e.ZERO),a=t(a,3),3>a)throw new o("stride must be 3 or greater.");var s=A;s.x=r[0]+i.x,s.y=r[1]+i.y,s.z=r[2]+i.z;for(var f=e.clone(s,w),l=e.clone(s,E),c=e.clone(s,m),h=e.clone(s,p),C=e.clone(s,y),N=e.clone(s,T),I=r.length,O=0;I>O;O+=a){var b=r[O]+i.x,M=r[O+1]+i.y,q=r[O+2]+i.z;s.x=b,s.y=M,s.z=q,b<f.x&&e.clone(s,f),b>h.x&&e.clone(s,h),M<l.y&&e.clone(s,l),M>C.y&&e.clone(s,C),q<c.z&&e.clone(s,c),q>N.z&&e.clone(s,N)}var L=e.magnitudeSquared(e.subtract(h,f,R)),F=e.magnitudeSquared(e.subtract(C,l,R)),P=e.magnitudeSquared(e.subtract(N,c,R)),D=f,x=h,U=L;F>U&&(U=F,D=l,x=C),P>U&&(U=P,D=c,x=N);var B=v;B.x=.5*(D.x+x.x),B.y=.5*(D.y+x.y),B.z=.5*(D.z+x.z);var G=e.magnitudeSquared(e.subtract(x,B,R)),z=Math.sqrt(G),V=_;V.x=f.x,V.y=l.y,V.z=c.z;var H=g;H.x=h.x,H.y=C.y,H.z=N.z;var W=e.multiplyByScalar(e.add(V,H,R),.5,S),Y=0;for(O=0;I>O;O+=a){s.x=r[O]+i.x,s.y=r[O+1]+i.y,s.z=r[O+2]+i.z;var X=e.magnitude(e.subtract(s,W,R));X>Y&&(Y=X);var k=e.magnitudeSquared(e.subtract(s,B,R));if(k>G){var K=Math.sqrt(k);z=.5*(z+K),G=z*z;var Z=K-z;B.x=(z*B.x+Z*s.x)/K,B.y=(z*B.y+Z*s.y)/K,B.z=(z*B.z+Z*s.z)/K}}return Y>z?(e.clone(B,u.center),u.radius=z):(e.clone(W,u.center),u.radius=Y),u},d.fromCornerPoints=function(r,t,i){if(!n(r)||!n(t))throw new o("corner and oppositeCorner are required.");n(i)||(i=new d);var a=i.center;return e.add(r,t,a),e.multiplyByScalar(a,.5,a),i.radius=e.distance(a,t),i},d.fromEllipsoid=function(r,t){if(!n(r))throw new o("ellipsoid is required.");return n(t)||(t=new d),e.clone(e.ZERO,t.center),t.radius=r.maximumRadius,t};var q=new e;d.fromBoundingSpheres=function(r,t){if(n(t)||(t=new d),!n(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;var i=r.length;if(1===i)return d.clone(r[0],t);if(2===i)return d.union(r[0],r[1],t);for(var o=[],a=0;i>a;a++)o.push(r[a].center);t=d.fromPoints(o,t);var u=t.center,s=t.radius;for(a=0;i>a;a++){var f=r[a];s=Math.max(s,e.distance(u,f.center,q)+f.radius)}return t.radius=s,t},d.clone=function(r,t){return n(r)?n(t)?(t.center=e.clone(r.center,t.center),t.radius=r.radius,t):new d(r.center,r.radius):void 0},d.packedLength=4,d.pack=function(e,r,i){if(!n(e))throw new o("value is required");if(!n(r))throw new o("array is required");i=t(i,0);var a=e.center;r[i++]=a.x,r[i++]=a.y,r[i++]=a.z,r[i]=e.radius},d.unpack=function(e,r,i){if(!n(e))throw new o("array is required");r=t(r,0),n(i)||(i=new d);var a=i.center;return a.x=e[r++],a.y=e[r++],a.z=e[r++],i.radius=e[r],i};var L=new e,F=new e;d.union=function(r,t,i){if(!n(r))throw new o("left is required.");if(!n(t))throw new o("right is required.");n(i)||(i=new d);var a=r.center,u=r.radius,s=t.center,f=t.radius,l=e.subtract(s,a,L),c=e.magnitude(l);if(u>=c+f)return r.clone(i),i;if(f>=c+u)return t.clone(i),i;var h=.5*(u+c+f),w=e.multiplyByScalar(l,(-u+h)/c,F);return e.add(w,a,w),e.clone(w,i.center),i.radius=h,i};var P=new e;d.expand=function(r,t,i){if(!n(r))throw new o("sphere is required.");if(!n(t))throw new o("point is required.");i=d.clone(r,i);var a=e.magnitude(e.subtract(t,i.center,P));return a>i.radius&&(i.radius=a),i},d.intersectPlane=function(r,t){if(!n(r))throw new o("sphere is required.");if(!n(t))throw new o("plane is required.");var i=r.center,a=r.radius,u=t.normal,f=e.dot(u,i)+t.distance;return-a>f?s.OUTSIDE:a>f?s.INTERSECTING:s.INSIDE},d.transform=function(e,r,t){if(!n(e))throw new o("sphere is required.");if(!n(r))throw new o("transform is required.");return n(t)||(t=new d),t.center=l.multiplyByPoint(r,e.center,t.center),t.radius=l.getMaximumScale(r)*e.radius,t};var D=new e;d.distanceSquaredTo=function(r,t){if(!n(r))throw new o("sphere is required.");if(!n(t))throw new o("cartesian is required.");var i=e.subtract(r.center,t,D);return e.magnitudeSquared(i)-r.radius*r.radius},d.transformWithoutScale=function(e,r,t){if(!n(e))throw new o("sphere is required.");if(!n(r))throw new o("transform is required.");return n(t)||(t=new d),t.center=l.multiplyByPoint(r,e.center,t.center),t.radius=e.radius,t};var x=new e;d.computePlaneDistances=function(r,t,i,a){if(!n(r))throw new o("sphere is required.");if(!n(t))throw new o("position is required.");if(!n(i))throw new o("direction is required.");n(a)||(a=new f);var u=e.subtract(r.center,t,x),s=e.dot(i,u);return a.start=s-r.radius,a.stop=s+r.radius,a};for(var U=new e,B=new e,G=new e,z=new e,V=new e,H=new r,W=new Array(8),Y=0;8>Y;++Y)W[Y]=new e;var X=new u;return d.projectTo2D=function(r,i,a){if(!n(r))throw new o("sphere is required.");i=t(i,X);var u=i.ellipsoid,s=r.center,f=r.radius,l=u.geodeticSurfaceNormal(s,U),c=e.cross(e.UNIT_Z,l,B);e.normalize(c,c);var h=e.cross(l,c,G);e.normalize(h,h),e.multiplyByScalar(l,f,l),e.multiplyByScalar(h,f,h),e.multiplyByScalar(c,f,c);var w=e.negate(h,V),E=e.negate(c,z),m=W,p=m[0];e.add(l,h,p),e.add(p,c,p),p=m[1],e.add(l,h,p),e.add(p,E,p),p=m[2],e.add(l,w,p),e.add(p,E,p),p=m[3],e.add(l,w,p),e.add(p,c,p),e.negate(l,l),p=m[4],e.add(l,h,p),e.add(p,c,p),p=m[5],e.add(l,h,p),e.add(p,E,p),p=m[6],e.add(l,w,p),e.add(p,E,p),p=m[7],e.add(l,w,p),e.add(p,c,p);for(var y=m.length,T=0;y>T;++T){var A=m[T];e.add(s,A,A);var R=u.cartesianToCartographic(A,H);i.project(R,A)}a=d.fromPoints(m,a),s=a.center;var v=s.x,_=s.y,g=s.z;return s.x=g,s.y=v,s.z=_,a},d.isOccluded=function(e,r){if(!n(e))throw new o("sphere is required.");if(!n(r))throw new o("occluder is required.");return!r.isBoundingSphereVisible(e)},d.equals=function(r,t){return r===t||n(r)&&n(t)&&e.equals(r.center,t.center)&&r.radius===t.radius},d.prototype.intersectPlane=function(e){return d.intersectPlane(this,e)},d.prototype.distanceSquaredTo=function(e){return d.distanceSquaredTo(this,e)},d.prototype.computePlaneDistances=function(e,r,t){return d.computePlaneDistances(this,e,r,t)},d.prototype.isOccluded=function(e){return d.isOccluded(this,e)},d.prototype.equals=function(e){return d.equals(this,e)},d.prototype.clone=function(e){return d.clone(this,e)},d}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,r){"use strict";var t,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return r(i,{element:{get:function(){return i.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(t))return t;t=!1;var r=document.body;if("function"==typeof r.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",t=!0;for(var i,o=["webkit","moz","o","ms","khtml"],a=0,u=o.length;u>a;++a){var s=o[a];i=s+"RequestFullscreen","function"==typeof r[i]?(n.requestFullscreen=i,t=!0):(i=s+"RequestFullScreen","function"==typeof r[i]&&(n.requestFullscreen=i,t=!0)),i=s+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=s+"FullscreenEnabled",e(document[i])?n.fullscreenEnabled=i:(i=s+"FullScreenEnabled",e(document[i])&&(n.fullscreenEnabled=i)),i=s+"FullscreenElement",e(document[i])?n.fullscreenElement=i:(i=s+"FullScreenElement",e(document[i])&&(n.fullscreenElement=i)),i=s+"fullscreenchange",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=s+"fullscreenerror",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenError"),n.fullscreenerror=i)}return t},i.requestFullscreen=function(e){i.supportsFullscreen()&&e[n.requestFullscreen]()},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,r,t){"use strict";function n(e){for(var r=e.split("."),t=0,n=r.length;n>t;++t)r[t]=parseInt(r[t],10);return r}function i(){if(!r(m)){m=!1;var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(m=!0,p=n(e[1]))}return m}function o(){return i()&&p}function a(){if(!r(y)&&(y=!1,!i()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(y=!0,T=n(e[1]))}return y}function u(){return a()&&T}function s(){if(!r(A)){A=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==e&&(A=!0,R=n(e[1]),R.isNightly=!!e[2])}return A}function f(){return s()&&R}function l(){if(!r(v)){v=!1;var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(v=!0,_=n(e[1]))):"Netscape"===navigator.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(v=!0,_=n(e[1])))}return v}function c(){return l()&&_}function h(){if(!r(g)){g=!1;var e=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(g=!0,S=n(e[1]))}return g}function d(){return r(C)||(C=/Windows/i.test(navigator.appVersion)),C}function w(){return h()&&S}function E(){return r(N)||(N=r(window.PointerEvent)&&(!r(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),N}var m,p,y,T,A,R,v,_,g,S,C,N,I={isChrome:i,chromeVersion:o,isSafari:a,safariVersion:u,isWebkit:s,webkitVersion:f,isInternetExplorer:l,internetExplorerVersion:c,isFirefox:h,firefoxVersion:w,isWindows:d,hardwareConcurrency:e(navigator.hardwareConcurrency,3),supportsPointerEvents:E};return I.supportsFullscreen=function(){return t.supportsFullscreen()},I.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},I.supportsWebWorkers=function(){return"undefined"!=typeof Worker},I}),define("Core/Color",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math"],function(e,r,t,n,i,o){"use strict";function a(e,r,t){return 0>t&&(t+=1),t>1&&(t-=1),1>6*t?e+6*(r-e)*t:1>2*t?r:2>3*t?e+(r-e)*(2/3-t)*6:e}var u=function(r,t,n,i){this.red=e(r,1),this.green=e(t,1),this.blue=e(n,1),this.alpha=e(i,1)};u.fromCartesian4=function(e,n){if(!r(e))throw new t("cartesian is required");return r(n)?(n.red=e.x,n.green=e.y,n.blue=e.z,n.alpha=e.w,n):new u(e.x,e.y,e.z,e.w)},u.fromBytes=function(t,n,i,o,a){return t=u.byteToFloat(e(t,255)),n=u.byteToFloat(e(n,255)),i=u.byteToFloat(e(i,255)),o=u.byteToFloat(e(o,255)),r(a)?(a.red=t,a.green=n,a.blue=i,a.alpha=o,a):new u(t,n,i,o)},u.fromAlpha=function(e,n,i){if(!r(e))throw new t("color is required");if(!r(n))throw new t("alpha is required");return r(i)?(i.red=e.red,i.green=e.green,i.blue=e.blue,i.alpha=n,i):new u(e.red,e.green,e.blue,n)};var s,f,l;n.supportsTypedArrays()&&(s=new ArrayBuffer(4),f=new Uint32Array(s),l=new Uint8Array(s)),u.fromRgba=function(e){return f[0]=e,u.fromBytes(l[0],l[1],l[2],l[3])},u.fromHsl=function(r,t,n,i){r=e(r,0)%1,t=e(t,0),n=e(n,0),i=e(i,1);var o=n,s=n,f=n;if(0!==t){var l;l=.5>n?n*(1+t):n+t-n*t;var c=2*n-l;o=a(c,l,r+1/3),s=a(c,l,r),f=a(c,l,r-1/3)}return new u(o,s,f,i)},u.fromRandom=function(n,i){n=e(n,e.EMPTY_OBJECT);var a=n.red;if(!r(a)){var s=e(n.minimumRed,0),f=e(n.maximumRed,1);if(s>f)throw new t("minimumRed must be less than or equal to maximumRed");a=s+o.nextRandomNumber()*(f-s)}var l=n.green;if(!r(l)){var c=e(n.minimumGreen,0),h=e(n.maximumGreen,1);if(c>h)throw new t("minimumGreen must be less than or equal to maximumGreen");l=c+o.nextRandomNumber()*(h-c)}var d=n.blue;if(!r(d)){var w=e(n.minimumBlue,0),E=e(n.maximumBlue,1);if(w>E)throw new t("minimumBlue must be less than or equal to maximumBlue");d=w+o.nextRandomNumber()*(E-w)}var m=n.alpha;if(!r(m)){var p=e(n.minimumAlpha,0),y=e(n.maximumAlpha,1);if(p>y)throw new t("minimumAlpha must be less than or equal to maximumAlpha");m=p+o.nextRandomNumber()*(y-p)}return r(i)?(i.red=a,i.green=l,i.blue=d,i.alpha=m,i):new u(a,l,d,m)};var c=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,h=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,d=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,w=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return u.fromCssColorString=function(n){if(!r(n))throw new t("color is required");var i=u[n.toUpperCase()];if(r(i))return u.clone(i);var o=c.exec(n);return null!==o?new u(parseInt(o[1],16)/15,parseInt(o[2],16)/15,parseInt(o[3],16)/15):(o=h.exec(n),null!==o?new u(parseInt(o[1],16)/255,parseInt(o[2],16)/255,parseInt(o[3],16)/255):(o=d.exec(n),null!==o?new u(parseFloat(o[1])/("%"===o[1].substr(-1)?100:255),parseFloat(o[2])/("%"===o[2].substr(-1)?100:255),parseFloat(o[3])/("%"===o[3].substr(-1)?100:255),parseFloat(e(o[4],"1.0"))):(o=w.exec(n),null!==o?u.fromHsl(parseFloat(o[1])/360,parseFloat(o[2])/100,parseFloat(o[3])/100,parseFloat(e(o[4],"1.0"))):void 0)))},u.packedLength=4,u.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.red,i[o++]=n.green,i[o++]=n.blue,i[o]=n.alpha},u.unpack=function(n,i,o){if(!r(n))throw new t("array is required");return i=e(i,0),r(o)||(o=new u),o.red=n[i++],o.green=n[i++],o.blue=n[i++],o.alpha=n[i],o},u.byteToFloat=function(e){return e/255},u.floatToByte=function(e){return 1===e?255:256*e|0},u.clone=function(e,t){return r(e)?r(t)?(t.red=e.red,t.green=e.green,t.blue=e.blue,t.alpha=e.alpha,t):new u(e.red,e.green,e.blue,e.alpha):void 0},u.equals=function(e,t){return e===t||r(e)&&r(t)&&e.red===t.red&&e.green===t.green&&e.blue===t.blue&&e.alpha===t.alpha},u.equalsArray=function(e,r,t){return e.red===r[t]&&e.green===r[t+1]&&e.blue===r[t+2]&&e.alpha===r[t+3]},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return this===e||r(e)&&Math.abs(this.red-e.red)<=t&&Math.abs(this.green-e.green)<=t&&Math.abs(this.blue-e.blue)<=t&&Math.abs(this.alpha-e.alpha)<=t},u.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},u.prototype.toCssColorString=function(){var e=u.floatToByte(this.red),r=u.floatToByte(this.green),t=u.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+r+","+t+")":"rgba("+e+","+r+","+t+","+this.alpha+")"},u.prototype.toBytes=function(e){var t=u.floatToByte(this.red),n=u.floatToByte(this.green),i=u.floatToByte(this.blue),o=u.floatToByte(this.alpha);return r(e)?(e[0]=t,e[1]=n,e[2]=i,e[3]=o,e):[t,n,i,o]},u.prototype.toRgba=function(){return l[0]=u.floatToByte(this.red),l[1]=u.floatToByte(this.green),l[2]=u.floatToByte(this.blue),l[3]=u.floatToByte(this.alpha),f[0]},u.prototype.brighten=function(e,n){if(!r(e))throw new t("magnitude is required.");if(0>e)throw new t("magnitude must be positive.");if(!r(n))throw new t("result is required.");return e=1-e,n.red=1-(1-this.red)*e,n.green=1-(1-this.green)*e,n.blue=1-(1-this.blue)*e,n.alpha=this.alpha,n},u.prototype.darken=function(e,n){if(!r(e))throw new t("magnitude is required.");if(0>e)throw new t("magnitude must be positive.");if(!r(n))throw new t("result is required.");return e=1-e,n.red=this.red*e,n.green=this.green*e,n.blue=this.blue*e,n.alpha=this.alpha,n},u.prototype.withAlpha=function(e,r){return u.fromAlpha(this,e,r)},u.ALICEBLUE=i(u.fromCssColorString("#F0F8FF")),u.ANTIQUEWHITE=i(u.fromCssColorString("#FAEBD7")),u.AQUA=i(u.fromCssColorString("#00FFFF")),u.AQUAMARINE=i(u.fromCssColorString("#7FFFD4")),u.AZURE=i(u.fromCssColorString("#F0FFFF")),u.BEIGE=i(u.fromCssColorString("#F5F5DC")),u.BISQUE=i(u.fromCssColorString("#FFE4C4")),u.BLACK=i(u.fromCssColorString("#000000")),u.BLANCHEDALMOND=i(u.fromCssColorString("#FFEBCD")),u.BLUE=i(u.fromCssColorString("#0000FF")),u.BLUEVIOLET=i(u.fromCssColorString("#8A2BE2")),u.BROWN=i(u.fromCssColorString("#A52A2A")),u.BURLYWOOD=i(u.fromCssColorString("#DEB887")),u.CADETBLUE=i(u.fromCssColorString("#5F9EA0")),u.CHARTREUSE=i(u.fromCssColorString("#7FFF00")),u.CHOCOLATE=i(u.fromCssColorString("#D2691E")),u.CORAL=i(u.fromCssColorString("#FF7F50")),u.CORNFLOWERBLUE=i(u.fromCssColorString("#6495ED")),u.CORNSILK=i(u.fromCssColorString("#FFF8DC")),u.CRIMSON=i(u.fromCssColorString("#DC143C")),u.CYAN=i(u.fromCssColorString("#00FFFF")),u.DARKBLUE=i(u.fromCssColorString("#00008B")),u.DARKCYAN=i(u.fromCssColorString("#008B8B")),u.DARKGOLDENROD=i(u.fromCssColorString("#B8860B")),u.DARKGRAY=i(u.fromCssColorString("#A9A9A9")),u.DARKGREEN=i(u.fromCssColorString("#006400")),u.DARKGREY=u.DARKGRAY,u.DARKKHAKI=i(u.fromCssColorString("#BDB76B")),u.DARKMAGENTA=i(u.fromCssColorString("#8B008B")),u.DARKOLIVEGREEN=i(u.fromCssColorString("#556B2F")),u.DARKORANGE=i(u.fromCssColorString("#FF8C00")),u.DARKORCHID=i(u.fromCssColorString("#9932CC")),u.DARKRED=i(u.fromCssColorString("#8B0000")),u.DARKSALMON=i(u.fromCssColorString("#E9967A")),u.DARKSEAGREEN=i(u.fromCssColorString("#8FBC8F")),u.DARKSLATEBLUE=i(u.fromCssColorString("#483D8B")),u.DARKSLATEGRAY=i(u.fromCssColorString("#2F4F4F")),u.DARKSLATEGREY=u.DARKSLATEGRAY,u.DARKTURQUOISE=i(u.fromCssColorString("#00CED1")),u.DARKVIOLET=i(u.fromCssColorString("#9400D3")),u.DEEPPINK=i(u.fromCssColorString("#FF1493")),u.DEEPSKYBLUE=i(u.fromCssColorString("#00BFFF")),u.DIMGRAY=i(u.fromCssColorString("#696969")),u.DIMGREY=u.DIMGRAY,u.DODGERBLUE=i(u.fromCssColorString("#1E90FF")),u.FIREBRICK=i(u.fromCssColorString("#B22222")),u.FLORALWHITE=i(u.fromCssColorString("#FFFAF0")),u.FORESTGREEN=i(u.fromCssColorString("#228B22")),u.FUSCHIA=i(u.fromCssColorString("#FF00FF")),u.GAINSBORO=i(u.fromCssColorString("#DCDCDC")),u.GHOSTWHITE=i(u.fromCssColorString("#F8F8FF")),u.GOLD=i(u.fromCssColorString("#FFD700")),u.GOLDENROD=i(u.fromCssColorString("#DAA520")),u.GRAY=i(u.fromCssColorString("#808080")),u.GREEN=i(u.fromCssColorString("#008000")),u.GREENYELLOW=i(u.fromCssColorString("#ADFF2F")),u.GREY=u.GRAY,u.HONEYDEW=i(u.fromCssColorString("#F0FFF0")),u.HOTPINK=i(u.fromCssColorString("#FF69B4")),u.INDIANRED=i(u.fromCssColorString("#CD5C5C")),u.INDIGO=i(u.fromCssColorString("#4B0082")),u.IVORY=i(u.fromCssColorString("#FFFFF0")),u.KHAKI=i(u.fromCssColorString("#F0E68C")),u.LAVENDER=i(u.fromCssColorString("#E6E6FA")),u.LAVENDAR_BLUSH=i(u.fromCssColorString("#FFF0F5")),u.LAWNGREEN=i(u.fromCssColorString("#7CFC00")),u.LEMONCHIFFON=i(u.fromCssColorString("#FFFACD")),u.LIGHTBLUE=i(u.fromCssColorString("#ADD8E6")),u.LIGHTCORAL=i(u.fromCssColorString("#F08080")),u.LIGHTCYAN=i(u.fromCssColorString("#E0FFFF")),u.LIGHTGOLDENRODYELLOW=i(u.fromCssColorString("#FAFAD2")),u.LIGHTGRAY=i(u.fromCssColorString("#D3D3D3")),u.LIGHTGREEN=i(u.fromCssColorString("#90EE90")),u.LIGHTGREY=u.LIGHTGRAY,u.LIGHTPINK=i(u.fromCssColorString("#FFB6C1")),u.LIGHTSEAGREEN=i(u.fromCssColorString("#20B2AA")),u.LIGHTSKYBLUE=i(u.fromCssColorString("#87CEFA")),u.LIGHTSLATEGRAY=i(u.fromCssColorString("#778899")),u.LIGHTSLATEGREY=u.LIGHTSLATEGRAY,u.LIGHTSTEELBLUE=i(u.fromCssColorString("#B0C4DE")),u.LIGHTYELLOW=i(u.fromCssColorString("#FFFFE0")),u.LIME=i(u.fromCssColorString("#00FF00")),u.LIMEGREEN=i(u.fromCssColorString("#32CD32")),u.LINEN=i(u.fromCssColorString("#FAF0E6")),u.MAGENTA=i(u.fromCssColorString("#FF00FF")),u.MAROON=i(u.fromCssColorString("#800000")),u.MEDIUMAQUAMARINE=i(u.fromCssColorString("#66CDAA")),u.MEDIUMBLUE=i(u.fromCssColorString("#0000CD")),u.MEDIUMORCHID=i(u.fromCssColorString("#BA55D3")),u.MEDIUMPURPLE=i(u.fromCssColorString("#9370DB")),u.MEDIUMSEAGREEN=i(u.fromCssColorString("#3CB371")),u.MEDIUMSLATEBLUE=i(u.fromCssColorString("#7B68EE")),u.MEDIUMSPRINGGREEN=i(u.fromCssColorString("#00FA9A")),u.MEDIUMTURQUOISE=i(u.fromCssColorString("#48D1CC")),u.MEDIUMVIOLETRED=i(u.fromCssColorString("#C71585")),u.MIDNIGHTBLUE=i(u.fromCssColorString("#191970")),u.MINTCREAM=i(u.fromCssColorString("#F5FFFA")),u.MISTYROSE=i(u.fromCssColorString("#FFE4E1")),u.MOCCASIN=i(u.fromCssColorString("#FFE4B5")),u.NAVAJOWHITE=i(u.fromCssColorString("#FFDEAD")),u.NAVY=i(u.fromCssColorString("#000080")),u.OLDLACE=i(u.fromCssColorString("#FDF5E6")),u.OLIVE=i(u.fromCssColorString("#808000")),u.OLIVEDRAB=i(u.fromCssColorString("#6B8E23")),u.ORANGE=i(u.fromCssColorString("#FFA500")),u.ORANGERED=i(u.fromCssColorString("#FF4500")),u.ORCHID=i(u.fromCssColorString("#DA70D6")),u.PALEGOLDENROD=i(u.fromCssColorString("#EEE8AA")),u.PALEGREEN=i(u.fromCssColorString("#98FB98")),u.PALETURQUOISE=i(u.fromCssColorString("#AFEEEE")),u.PALEVIOLETRED=i(u.fromCssColorString("#DB7093")),u.PAPAYAWHIP=i(u.fromCssColorString("#FFEFD5")),u.PEACHPUFF=i(u.fromCssColorString("#FFDAB9")),u.PERU=i(u.fromCssColorString("#CD853F")),u.PINK=i(u.fromCssColorString("#FFC0CB")),u.PLUM=i(u.fromCssColorString("#DDA0DD")),u.POWDERBLUE=i(u.fromCssColorString("#B0E0E6")),u.PURPLE=i(u.fromCssColorString("#800080")),u.RED=i(u.fromCssColorString("#FF0000")),u.ROSYBROWN=i(u.fromCssColorString("#BC8F8F")),u.ROYALBLUE=i(u.fromCssColorString("#4169E1")),u.SADDLEBROWN=i(u.fromCssColorString("#8B4513")),u.SALMON=i(u.fromCssColorString("#FA8072")),u.SANDYBROWN=i(u.fromCssColorString("#F4A460")),u.SEAGREEN=i(u.fromCssColorString("#2E8B57")),u.SEASHELL=i(u.fromCssColorString("#FFF5EE")),u.SIENNA=i(u.fromCssColorString("#A0522D")),u.SILVER=i(u.fromCssColorString("#C0C0C0")),u.SKYBLUE=i(u.fromCssColorString("#87CEEB")),u.SLATEBLUE=i(u.fromCssColorString("#6A5ACD")),u.SLATEGRAY=i(u.fromCssColorString("#708090")),u.SLATEGREY=u.SLATEGRAY,u.SNOW=i(u.fromCssColorString("#FFFAFA")),u.SPRINGGREEN=i(u.fromCssColorString("#00FF7F")),u.STEELBLUE=i(u.fromCssColorString("#4682B4")),u.TAN=i(u.fromCssColorString("#D2B48C")),u.TEAL=i(u.fromCssColorString("#008080")),u.THISTLE=i(u.fromCssColorString("#D8BFD8")),u.TOMATO=i(u.fromCssColorString("#FF6347")),u.TURQUOISE=i(u.fromCssColorString("#40E0D0")),u.VIOLET=i(u.fromCssColorString("#EE82EE")),u.WHEAT=i(u.fromCssColorString("#F5DEB3")),u.WHITE=i(u.fromCssColorString("#FFFFFF")),u.WHITESMOKE=i(u.fromCssColorString("#F5F5F5")),u.YELLOW=i(u.fromCssColorString("#FFFF00")),u.YELLOWGREEN=i(u.fromCssColorString("#9ACD32")),u.TRANSPARENT=i(new u(0,0,0,0)),u}),define("Renderer/WebGLConstants",["../Core/freezeObject"],function(e){"use strict";var r={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,
SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return e(r)}),define("Core/ComponentDatatype",["../Renderer/WebGLConstants","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,r,t,n,i,o){"use strict";if(!i.supportsTypedArrays())return{};var a={BYTE:e.BYTE,UNSIGNED_BYTE:e.UNSIGNED_BYTE,SHORT:e.SHORT,UNSIGNED_SHORT:e.UNSIGNED_SHORT,FLOAT:e.FLOAT,DOUBLE:e.DOUBLE};return a.getSizeInBytes=function(e){if(!t(e))throw new n("value is required.");switch(e){case a.BYTE:return Int8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.SHORT:return Int16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case a.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new n("componentDatatype is not a valid value.")}},a.fromTypedArray=function(e){return e instanceof Int8Array?a.BYTE:e instanceof Uint8Array?a.UNSIGNED_BYTE:e instanceof Int16Array?a.SHORT:e instanceof Uint16Array?a.UNSIGNED_SHORT:e instanceof Float32Array?a.FLOAT:e instanceof Float64Array?a.DOUBLE:void 0},a.validate=function(e){return t(e)&&(e===a.BYTE||e===a.UNSIGNED_BYTE||e===a.SHORT||e===a.UNSIGNED_SHORT||e===a.FLOAT||e===a.DOUBLE)},a.createTypedArray=function(e,r){if(!t(e))throw new n("componentDatatype is required.");if(!t(r))throw new n("valuesOrLength is required.");switch(e){case a.BYTE:return new Int8Array(r);case a.UNSIGNED_BYTE:return new Uint8Array(r);case a.SHORT:return new Int16Array(r);case a.UNSIGNED_SHORT:return new Uint16Array(r);case a.FLOAT:return new Float32Array(r);case a.DOUBLE:return new Float64Array(r);default:throw new n("componentDatatype is not a valid value.")}},a.createArrayBufferView=function(e,i,o,u){if(!t(e))throw new n("componentDatatype is required.");if(!t(i))throw new n("buffer is required.");switch(o=r(o,0),u=r(u,(i.byteLength-o)/a.getSizeInBytes(e)),e){case a.BYTE:return new Int8Array(i,o,u);case a.UNSIGNED_BYTE:return new Uint8Array(i,o,u);case a.SHORT:return new Int16Array(i,o,u);case a.UNSIGNED_SHORT:return new Uint16Array(i,o,u);case a.FLOAT:return new Float32Array(i,o,u);case a.DOUBLE:return new Float64Array(i,o,u);default:throw new n("componentDatatype is not a valid value.")}},o(a)}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var r={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(r)}),define("Core/PrimitiveType",["../Renderer/WebGLConstants","./freezeObject"],function(e,r){"use strict";var t={POINTS:e.POINTS,LINES:e.LINES,LINE_LOOP:e.LINE_LOOP,LINE_STRIP:e.LINE_STRIP,TRIANGLES:e.TRIANGLES,TRIANGLE_STRIP:e.TRIANGLE_STRIP,TRIANGLE_FAN:e.TRIANGLE_FAN,validate:function(e){return e===t.POINTS||e===t.LINES||e===t.LINE_LOOP||e===t.LINE_STRIP||e===t.TRIANGLES||e===t.TRIANGLE_STRIP||e===t.TRIANGLE_FAN}};return r(t)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,r,t,n,i){"use strict";var o=function(o){if(o=e(o,e.EMPTY_OBJECT),!r(o.attributes))throw new t("options.attributes is required.");this.attributes=o.attributes,this.indices=o.indices,this.primitiveType=e(o.primitiveType,i.TRIANGLES),this.boundingSphere=o.boundingSphere,this.geometryType=e(o.geometryType,n.NONE),this.boundingSphereCV=void 0};return o.computeNumberOfVertices=function(e){if(!r(e))throw new t("geometry is required.");var n=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&r(e.attributes[i])&&r(e.attributes[i].values)){var o=e.attributes[i],a=o.values.length/o.componentsPerAttribute;if(n!==a&&-1!==n)throw new t("All attribute lists must have the same number of attributes.");n=a}return n},o}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.componentDatatype))throw new t("options.componentDatatype is required.");if(!r(n.componentsPerAttribute))throw new t("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new t("options.componentsPerAttribute must be between 1 and 4.");if(!r(n.values))throw new t("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values};return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var r=function(r){r=e(r,e.EMPTY_OBJECT),this.position=r.position,this.normal=r.normal,this.st=r.st,this.binormal=r.binormal,this.tangent=r.tangent,this.color=r.color};return r}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t){this.x=e(r,0),this.y=e(t,0)};o.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new o(e,t)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t):new o(e.x,e.y):void 0},o.fromCartesian3=o.clone,o.fromCartesian4=o.clone,o.packedLength=2,o.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.x,i[o]=n.y},o.unpack=function(n,i,a){if(!r(n))throw new t("array is required");return i=e(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i],a},o.fromArray=o.unpack,o.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y)},o.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y)},o.minimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i},o.maximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitude(a)},o.distanceSquared=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitudeSquared(a)},o.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=o.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n},o.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y},o.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i},o.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i},o.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i},o.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i},o.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i},o.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n},o.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n};var u=new o;o.lerp=function(e,n,i,a){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(n,i,u),a=o.multiplyByScalar(e,1-i,a),o.add(u,a,a)};var s=new o,f=new o;o.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return o.normalize(e,s),o.normalize(n,f),i.acosClamped(o.dot(s,f))};var l=new o;return o.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=o.normalize(e,l);return o.abs(i,i),n=i.x<=i.y?o.clone(o.UNIT_X,n):o.clone(o.UNIT_Y,n)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},o.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]},o.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)},o.ZERO=n(new o(0,0)),o.UNIT_X=n(new o(1,0)),o.UNIT_Y=n(new o(0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r,t){return o.equalsEpsilon(this,e,r,t)},o.prototype.toString=function(){return"("+this.x+", "+this.y+")"},o}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,r,t,n,i){"use strict";var o={};o.octEncode=function(e,o){if(!t(e))throw new n("vector is required.");if(!t(o))throw new n("result is required.");var a=r.magnitudeSquared(e);if(Math.abs(a-1)>i.EPSILON6)throw new n("vector must be normalized.");if(o.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),o.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var u=o.x,s=o.y;o.x=(1-Math.abs(s))*i.signNotZero(u),o.y=(1-Math.abs(u))*i.signNotZero(s)}return o.x=i.toSNorm(o.x),o.y=i.toSNorm(o.y),o},o.octDecode=function(e,o,a){if(!t(a))throw new n("result is required.");if(0>e||e>255||0>o||o>255)throw new n("x and y must be a signed normalized integer between 0 and 255");if(a.x=i.fromSNorm(e),a.y=i.fromSNorm(o),a.z=1-(Math.abs(a.x)+Math.abs(a.y)),a.z<0){var u=a.x;a.x=(1-Math.abs(a.y))*i.signNotZero(u),a.y=(1-Math.abs(u))*i.signNotZero(a.y)}return r.normalize(a,a)},o.octPackFloat=function(e){if(!t(e))throw new n("encoded is required.");return 256*e.x+e.y};var a=new e;return o.octEncodeFloat=function(e){return o.octEncode(e,a),o.octPackFloat(a)},o.octDecodeFloat=function(e,r){if(!t(e))throw new n("value is required.");var i=e/256,a=Math.floor(i),u=256*(i-a);return o.octDecode(a,u,r)},o.octPack=function(e,r,i,u){if(!t(e))throw new n("v1 is required.");if(!t(r))throw new n("v2 is required.");if(!t(i))throw new n("v3 is required.");if(!t(u))throw new n("result is required.");var s=o.octEncodeFloat(e),f=o.octEncodeFloat(r),l=o.octEncode(i,a);return u.x=65536*l.x+s,u.y=65536*l.y+f,u},o.octUnpack=function(e,r,i,a){if(!t(e))throw new n("packed is required.");if(!t(r))throw new n("v1 is required.");if(!t(i))throw new n("v2 is required.");if(!t(a))throw new n("v3 is required.");var u=e.x/65536,s=Math.floor(u),f=65536*(u-s);u=e.y/65536;var l=Math.floor(u),c=65536*(u-l);o.octDecodeFloat(f,r),o.octDecodeFloat(c,i),o.octDecode(s,l,a)},o.compressTextureCoordinates=function(e){if(!t(e))throw new n("textureCoordinates is required.");var r=1===e.x?4095:4096*e.x|0,i=1===e.y?4095:4096*e.y|0;return 4096*r+i},o.decompressTextureCoordinates=function(e,r){if(!t(e))throw new n("compressed is required.");if(!t(r))throw new n("result is required.");var i=e/4096;return r.x=Math.floor(i)/4096,r.y=i-Math.floor(i),r},o}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i=new r,o=new r,a=new r,u=function(u,s,f,l,c){if(!(t(u)&&t(s)&&t(f)&&t(l)))throw new n("point, p0, p1, and p2 are required.");t(c)||(c=new r);var h,d,w,E,m,p,y,T;t(s.z)?(h=r.subtract(f,s,i),d=r.subtract(l,s,o),w=r.subtract(u,s,a),E=r.dot(h,h),m=r.dot(h,d),p=r.dot(h,w),y=r.dot(d,d),T=r.dot(d,w)):(h=e.subtract(f,s,i),d=e.subtract(l,s,o),w=e.subtract(u,s,a),E=e.dot(h,h),m=e.dot(h,d),p=e.dot(h,w),y=e.dot(d,d),T=e.dot(d,w));var A=1/(E*y-m*m);return c.y=(y*p-m*T)*A,c.z=(E*T-m*p)*A,c.x=1-c.y-c.z,c};return u}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)};n.encode=function(e,n){if(!r(e))throw new t("value is required");r(n)||(n={high:0,low:0});var i;return e>=0?(i=65536*Math.floor(e/65536),n.high=i,n.low=e-i):(i=65536*Math.floor(-e/65536),n.high=-i,n.low=e+i),n};var i={high:0,low:0};n.fromCartesian=function(e,o){if(!r(e))throw new t("cartesian is required");r(o)||(o=new n);var a=o.high,u=o.low;return n.encode(e.x,i),a.x=i.high,u.x=i.low,n.encode(e.y,i),a.y=i.high,u.y=i.low,n.encode(e.z,i),a.z=i.high,u.z=i.low,o};var o=new n;return n.writeElements=function(e,i,a){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("cartesianArray is required");if("number"!=typeof a||0>a)throw new t("index must be a number greater than or equal to 0.");n.fromCartesian(e,o);var u=o.high,s=o.low;i[a]=u.x,i[a+1]=u.y,i[a+2]=u.z,i[a+3]=s.x,i[a+4]=s.y,i[a+5]=s.z},n}),define("Core/GeometryInstance",["./defaultValue","./defined","./DeveloperError","./Matrix4"],function(e,r,t,n){"use strict";var i=function(i){if(i=e(i,e.EMPTY_OBJECT),!r(i.geometry))throw new t("options.geometry is required.");this.geometry=i.geometry,this.modelMatrix=n.clone(e(i.modelMatrix,n.IDENTITY)),this.id=i.id,this.pickPrimitive=i.pickPrimitive,this.attributes=e(i.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0};return i}),define("Core/IndexDatatype",["../Renderer/WebGLConstants","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o={UNSIGNED_BYTE:e.UNSIGNED_BYTE,UNSIGNED_SHORT:e.UNSIGNED_SHORT,UNSIGNED_INT:e.UNSIGNED_INT};return o.getSizeInBytes=function(e){switch(e){case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},o.validate=function(e){return r(e)&&(e===o.UNSIGNED_BYTE||e===o.UNSIGNED_SHORT||e===o.UNSIGNED_INT)},o.createTypedArray=function(e,n){if(!r(e))throw new t("numberOfVertices is required.");return e>=i.SIXTY_FOUR_KILOBYTES?new Uint32Array(n):new Uint16Array(n)},o.createTypedArrayFromArrayBuffer=function(e,n,o,a){if(!r(e))throw new t("numberOfVertices is required.");if(!r(n))throw new t("sourceArray is required.");if(!r(o))throw new t("byteOffset is required.");return e>=i.SIXTY_FOUR_KILOBYTES?new Uint32Array(n,o,a):new Uint16Array(n,o,a)},n(o)}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,r){"use strict";function t(e,t,n){var i=e+t;return r.sign(e)!==r.sign(t)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(t)))<n?0:i}var n={};return n.computeDiscriminant=function(r,t,n){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");var i=t*t-4*r*n;return i},n.computeRealRoots=function(n,i,o){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");var a;if(0===n)return 0===i?[]:[-o/i];if(0===i){if(0===o)return[0,0];var u=Math.abs(o),s=Math.abs(n);if(s>u&&u/s<r.EPSILON14)return[0,0];if(u>s&&s/u<r.EPSILON14)return[];if(a=-o/n,0>a)return[];var f=Math.sqrt(a);return[-f,f]}if(0===o)return a=-i/n,0>a?[a,0]:[0,a];var l=i*i,c=4*n*o,h=t(l,-c,r.EPSILON14);if(0>h)return[];var d=-.5*t(i,r.sign(i)*Math.sqrt(h),r.EPSILON14);return i>0?[d/n,o/d]:[o/d,d/n]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,r){"use strict";function t(e,r,t,n){var i,o,a=e,u=r/3,s=t/3,f=n,l=a*s,c=u*f,h=u*u,d=s*s,w=a*s-h,E=a*f-u*s,m=u*f-d,p=4*w*m-E*E;if(0>p){var y,T,A;h*c>=l*d?(y=a,T=w,A=-2*u*w+a*E):(y=f,T=m,A=-f*E+2*s*m);var R=0>A?-1:1,v=-R*Math.abs(y)*Math.sqrt(-p);o=-A+v;var _=o/2,g=0>_?-Math.pow(-_,1/3):Math.pow(_,1/3),S=o===v?-g:-T/g;return i=0>=T?g+S:-A/(g*g+S*S+T),h*c>=l*d?[(i-u)/a]:[-f/(i+s)]}var C=w,N=-2*u*w+a*E,I=m,O=-f*E+2*s*m,b=Math.sqrt(p),M=Math.sqrt(3)/2,q=Math.abs(Math.atan2(a*b,-N)/3);i=2*Math.sqrt(-C);var L=Math.cos(q);o=i*L;var F=i*(-L/2-M*Math.sin(q)),P=o+F>2*u?o-u:F-u,D=a,x=P/D;q=Math.abs(Math.atan2(f*b,-O)/3),i=2*Math.sqrt(-I),L=Math.cos(q),o=i*L,F=i*(-L/2-M*Math.sin(q));var U=-f,B=2*s>o+F?o+s:F+s,G=U/B,z=D*B,V=-P*B-D*U,H=P*U,W=(s*V-u*H)/(-u*V+s*z);return W>=x?G>=x?G>=W?[x,W,G]:[x,G,W]:[G,x,W]:G>=x?[W,x,G]:G>=W?[W,G,x]:[G,W,x]}var n={};return n.computeDiscriminant=function(r,t,n,i){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var o=r*r,a=t*t,u=n*n,s=i*i,f=18*r*t*n*i+a*u-27*o*s-4*(r*u*n+a*t*i);return f},n.computeRealRoots=function(n,i,o,a){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");if("number"!=typeof a)throw new e("d is a required number.");var u,s;if(0===n)return r.computeRealRoots(i,o,a);if(0===i){if(0===o){if(0===a)return[0,0,0];s=-a/n;var f=0>s?-Math.pow(-s,1/3):Math.pow(s,1/3);return[f,f,f]}return 0===a?(u=r.computeRealRoots(n,0,o),0===u.Length?[0]:[u[0],0,u[1]]):t(n,0,o,a)}return 0===o?0===a?(s=-i/n,0>s?[s,0,0]:[0,0,s]):t(n,i,0,a):0===a?(u=r.computeRealRoots(n,i,o),0===u.length?[0]:u[1]<=0?[u[0],u[1],0]:u[0]>=0?[0,u[0],u[1]]:[u[0],0,u[1]]):t(n,i,o,a)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,r,t,n){"use strict";function i(r,i,o,a){var u=r*r,s=i-3*u/8,f=o-i*r/2+u*r/8,l=a-o*r/4+i*u/16-3*u*u/256,c=e.computeRealRoots(1,2*s,s*s-4*l,-f*f);if(c.length>0){var h=-r/4,d=c[c.length-1];if(Math.abs(d)<t.EPSILON14){var w=n.computeRealRoots(1,s,l);if(2===w.length){var E,m=w[0],p=w[1];if(m>=0&&p>=0){var y=Math.sqrt(m),T=Math.sqrt(p);return[h-T,h-y,h+y,h+T]}if(m>=0&&0>p)return E=Math.sqrt(m),[h-E,h+E];if(0>m&&p>=0)return E=Math.sqrt(p),[h-E,h+E]}return[]}if(d>0){var A=Math.sqrt(d),R=(s+d-f/A)/2,v=(s+d+f/A)/2,_=n.computeRealRoots(1,A,R),g=n.computeRealRoots(1,-A,v);return 0!==_.length?(_[0]+=h,_[1]+=h,0!==g.length?(g[0]+=h,g[1]+=h,_[1]<=g[0]?[_[0],_[1],g[0],g[1]]:g[1]<=_[0]?[g[0],g[1],_[0],_[1]]:_[0]>=g[0]&&_[1]<=g[1]?[g[0],_[0],_[1],g[1]]:g[0]>=_[0]&&g[1]<=_[1]?[_[0],g[0],g[1],_[1]]:_[0]>g[0]&&_[0]<g[1]?[g[0],_[0],g[1],_[1]]:[_[0],g[0],_[1],g[1]]):_):0!==g.length?(g[0]+=h,g[1]+=h,g):[]}}return[]}function o(r,i,o,a){var u=o*o,s=i*i,f=r*r,l=-2*i,c=o*r+s-4*a,h=f*a-o*i*r+u,d=e.computeRealRoots(1,l,c,h);if(d.length>0){var w,E,m=d[0],p=i-m,y=p*p,T=r/2,A=p/2,R=y-4*a,v=y+4*Math.abs(a),_=f-4*m,g=f+4*Math.abs(m);if(0>m||_*v>R*g){var S=Math.sqrt(_);w=S/2,E=0===S?0:(r*A-o)/S}else{var C=Math.sqrt(R);w=0===C?0:(r*A-o)/C,E=C/2}var N,I;0===T&&0===w?(N=0,I=0):t.sign(T)===t.sign(w)?(N=T+w,I=m/N):(I=T-w,N=m/I);var O,b;0===A&&0===E?(O=0,b=0):t.sign(A)===t.sign(E)?(O=A+E,b=a/O):(b=A-E,O=a/b);var M=n.computeRealRoots(1,N,O),q=n.computeRealRoots(1,I,b);if(0!==M.length)return 0!==q.length?M[1]<=q[0]?[M[0],M[1],q[0],q[1]]:q[1]<=M[0]?[q[0],q[1],M[0],M[1]]:M[0]>=q[0]&&M[1]<=q[1]?[q[0],M[0],M[1],q[1]]:q[0]>=M[0]&&q[1]<=M[1]?[M[0],q[0],q[1],M[1]]:M[0]>q[0]&&M[0]<q[1]?[q[0],M[0],q[1],M[1]]:[M[0],q[0],M[1],q[1]]:M;if(0!==q.length)return q}return[]}var a={};return a.computeDiscriminant=function(e,t,n,i,o){if("number"!=typeof e)throw new r("a is a required number.");if("number"!=typeof t)throw new r("b is a required number.");if("number"!=typeof n)throw new r("c is a required number.");if("number"!=typeof i)throw new r("d is a required number.");if("number"!=typeof o)throw new r("e is a required number.");var a=e*e,u=a*e,s=t*t,f=s*t,l=n*n,c=l*n,h=i*i,d=h*i,w=o*o,E=w*o,m=s*l*h-4*f*d-4*e*c*h+18*e*t*n*d-27*a*h*h+256*u*E+o*(18*f*n*i-4*s*c+16*e*l*l-80*e*t*l*i-6*e*s*h+144*a*n*h)+w*(144*e*s*n-27*s*s-128*a*l-192*a*t*i);return m},a.computeRealRoots=function(n,a,u,s,f){if("number"!=typeof n)throw new r("a is a required number.");if("number"!=typeof a)throw new r("b is a required number.");if("number"!=typeof u)throw new r("c is a required number.");if("number"!=typeof s)throw new r("d is a required number.");if("number"!=typeof f)throw new r("e is a required number.");if(Math.abs(n)<t.EPSILON15)return e.computeRealRoots(a,u,s,f);var l=a/n,c=u/n,h=s/n,d=f/n,w=0>l?1:0;switch(w+=0>c?w+1:w,w+=0>h?w+1:w,w+=0>d?w+1:w){case 0:return i(l,c,h,d);case 1:return o(l,c,h,d);case 2:return o(l,c,h,d);case 3:return i(l,c,h,d);case 4:return i(l,c,h,d);case 5:return o(l,c,h,d);case 6:return i(l,c,h,d);case 7:return i(l,c,h,d);case 8:return o(l,c,h,d);case 9:return i(l,c,h,d);case 10:return i(l,c,h,d);case 11:return o(l,c,h,d);case 12:return i(l,c,h,d);case 13:return i(l,c,h,d);case 14:return i(l,c,h,d);case 15:return i(l,c,h,d);default:return void 0}},a}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i=function(t,n){n=e.clone(r(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(r(t,e.ZERO)),this.direction=n};return i.getPoint=function(r,i,o){if(!t(r))throw new n("ray is requred");if("number"!=typeof i)throw new n("t is a required number");return t(o)||(o=new e),o=e.multiplyByScalar(r.direction,i,o),e.add(r.origin,o,o)},i}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,r,t,n,i,o,a,u,s,f){"use strict";function l(r,a,u,s,f){if(!n(r))throw new i("ray is required.");if(!n(a))throw new i("p0 is required.");if(!n(u))throw new i("p1 is required.");if(!n(s))throw new i("p2 is required.");f=t(f,!1);var l,c,h,d,w,E=r.origin,R=r.direction,v=e.subtract(u,a,m),_=e.subtract(s,a,p),g=e.cross(R,_,y),S=e.dot(v,g);if(f){if(S<o.EPSILON6)return void 0;if(l=e.subtract(E,a,T),h=e.dot(l,g),0>h||h>S)return void 0;if(c=e.cross(l,v,A),d=e.dot(R,c),0>d||h+d>S)return void 0;w=e.dot(_,c)/S}else{if(Math.abs(S)<o.EPSILON6)return void 0;var C=1/S;if(l=e.subtract(E,a,T),h=e.dot(l,g)*C,0>h||h>1)return void 0;if(c=e.cross(l,v,A),d=e.dot(R,c)*C,0>d||h+d>1)return void 0;w=e.dot(_,c)*C}return w}function c(e,r,t,n){var i=r*r-4*e*t;if(0>i)return void 0;if(i>0){var o=1/(2*e),a=Math.sqrt(i),u=(-r+a)*o,s=(-r-a)*o;return s>u?(n.root0=u,n.root1=s):(n.root0=s,n.root1=u),n}var f=-r/(2*e);return 0===f?void 0:(n.root0=n.root1=f,n)}function h(r,t,i){n(i)||(i={});var o=r.origin,a=r.direction,u=t.center,s=t.radius*t.radius,f=e.subtract(o,u,y),l=e.dot(a,a),h=2*e.dot(a,f),d=e.magnitudeSquared(f)-s,w=c(l,h,d,v);return n(w)?(i.start=w.root0,i.stop=w.root1,i):void 0}function d(e,r,t){var n=e+r;return o.sign(e)!==o.sign(r)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(r)))<t?0:n}function w(r,t,n,i,f){var l,c=i*i,h=f*f,w=(r[a.COLUMN1ROW1]-r[a.COLUMN2ROW2])*h,E=f*(i*d(r[a.COLUMN1ROW0],r[a.COLUMN0ROW1],o.EPSILON15)+t.y),m=r[a.COLUMN0ROW0]*c+r[a.COLUMN2ROW2]*h+i*t.x+n,p=h*d(r[a.COLUMN2ROW1],r[a.COLUMN1ROW2],o.EPSILON15),y=f*(i*d(r[a.COLUMN2ROW0],r[a.COLUMN0ROW2])+t.z),T=[];if(0===y&&0===p){if(l=u.computeRealRoots(w,E,m),0===l.length)return T;var A=l[0],R=Math.sqrt(Math.max(1-A*A,0));if(T.push(new e(i,f*A,f*-R)),T.push(new e(i,f*A,f*R)),2===l.length){var v=l[1],_=Math.sqrt(Math.max(1-v*v,0));T.push(new e(i,f*v,f*-_)),T.push(new e(i,f*v,f*_))}return T}var g=y*y,S=p*p,C=w*w,N=y*p,I=C+S,O=2*(E*w+N),b=2*m*w+E*E-S+g,M=2*(m*E-N),q=m*m-g;if(0===I&&0===O&&0===b&&0===M)return T;l=s.computeRealRoots(I,O,b,M,q);var L=l.length;if(0===L)return T;for(var F=0;L>F;++F){var P,D=l[F],x=D*D,U=Math.max(1-x,0),B=Math.sqrt(U);P=o.sign(w)===o.sign(m)?d(w*x+m,E*D,o.EPSILON12):o.sign(m)===o.sign(E*D)?d(w*x,E*D+m,o.EPSILON12):d(w*x+E*D,m,o.EPSILON12);var G=d(p*D,y,o.EPSILON15),z=P*G;0>z?T.push(new e(i,f*D,f*B)):z>0?T.push(new e(i,f*D,f*-B)):0!==B?(T.push(new e(i,f*D,f*-B)),T.push(new e(i,f*D,f*B)),++F):T.push(new e(i,f*D,f*B))}return T}var E={};E.rayPlane=function(r,t,a){if(!n(r))throw new i("ray is required.");if(!n(t))throw new i("plane is required.");n(a)||(a=new e);var u=r.origin,s=r.direction,f=t.normal,l=e.dot(f,s);if(Math.abs(l)<o.EPSILON15)return void 0;var c=(-t.distance-e.dot(f,u))/l;return 0>c?void 0:(a=e.multiplyByScalar(s,c,a),e.add(u,a,a))};var m=new e,p=new e,y=new e,T=new e,A=new e;E.rayTriangle=function(r,t,i,o,a,u){var s=l(r,t,i,o,a);return!n(s)||0>s?void 0:(n(u)||(u=new e),e.multiplyByScalar(r.direction,s,u),e.add(r.origin,u,u))};var R=new f;E.lineSegmentTriangle=function(r,t,o,a,u,s,f){if(!n(r))throw new i("v0 is required.");if(!n(t))throw new i("v1 is required.");var c=R;e.clone(r,c.origin),e.subtract(t,r,c.direction),e.normalize(c.direction,c.direction);var h=l(c,o,a,u,s);return!n(h)||0>h||h>e.distance(r,t)?void 0:(n(f)||(f=new e),e.multiplyByScalar(c.direction,h,f),e.add(c.origin,f,f))};var v={root0:0,root1:0};E.raySphere=function(e,r,t){if(!n(e))throw new i("ray is required.");if(!n(r))throw new i("sphere is required.");return t=h(e,r,t),!n(t)||t.stop<0?void 0:(t.start=Math.max(t.start,0),t)};var _=new f;E.lineSegmentSphere=function(r,t,o,a){if(!n(r))throw new i("p0 is required.");if(!n(t))throw new i("p1 is required.");if(!n(o))throw new i("sphere is required.");var u=_,s=(e.clone(r,u.origin),e.subtract(t,r,u.direction)),f=e.magnitude(s);return e.normalize(s,s),a=h(u,o,a),!n(a)||a.stop<0||a.start>f?void 0:(a.start=Math.max(a.start,0),a.stop=Math.min(a.stop,f),a)};var g=new e,S=new e;E.rayEllipsoid=function(r,t){if(!n(r))throw new i("ray is required.");if(!n(t))throw new i("ellipsoid is required.");var o,a,u,s,f,l=t.oneOverRadii,c=e.multiplyComponents(l,r.origin,g),h=e.multiplyComponents(l,r.direction,S),d=e.magnitudeSquared(c),w=e.dot(c,h);if(d>1){if(w>=0)return void 0;var E=w*w;if(o=d-1,a=e.magnitudeSquared(h),u=a*o,u>E)return void 0;if(E>u){s=w*w-u,f=-w+Math.sqrt(s);var m=f/a,p=o/f;return p>m?{start:m,stop:p}:{start:p,stop:m}}var y=Math.sqrt(o/a);return{start:y,stop:y}}return 1>d?(o=d-1,a=e.magnitudeSquared(h),u=a*o,s=w*w-u,f=-w+Math.sqrt(s),{start:0,stop:f/a}):0>w?(a=e.magnitudeSquared(h),{start:0,stop:-w/a}):void 0};var C=new e,N=new e,I=new e,O=new e,b=new e,M=new a,q=new a,L=new a,F=new a,P=new a,D=new a,x=new a,U=new e,B=new e,G=new r;E.grazingAltitudeLocation=function(r,t){if(!n(r))throw new i("ray is required.");if(!n(t))throw new i("ellipsoid is required.");var u=r.origin,s=r.direction,f=t.geodeticSurfaceNormal(u,C);if(e.dot(s,f)>=0)return u;var l=n(this.rayEllipsoid(r,t)),c=t.transformPositionToScaledSpace(s,C),h=e.normalize(c,c),d=e.mostOrthogonalAxis(c,O),E=e.normalize(e.cross(d,h,N),N),m=e.normalize(e.cross(h,E,I),I),p=M;
p[0]=h.x,p[1]=h.y,p[2]=h.z,p[3]=E.x,p[4]=E.y,p[5]=E.z,p[6]=m.x,p[7]=m.y,p[8]=m.z;var y=a.transpose(p,q),T=a.fromScale(t.radii,L),A=a.fromScale(t.oneOverRadii,F),R=P;R[0]=0,R[1]=-s.z,R[2]=s.y,R[3]=s.z,R[4]=0,R[5]=-s.x,R[6]=-s.y,R[7]=s.x,R[8]=0;var v,_,g=a.multiply(a.multiply(y,A,D),R,D),S=a.multiply(a.multiply(g,T,x),p,x),z=a.multiplyByVector(g,u,b),V=w(S,e.negate(z,C),0,0,1),H=V.length;if(H>0){for(var W=e.clone(e.ZERO,B),Y=Number.NEGATIVE_INFINITY,X=0;H>X;++X){v=a.multiplyByVector(T,a.multiplyByVector(p,V[X],U),U);var k=e.normalize(e.subtract(v,u,O),O),K=e.dot(k,s);K>Y&&(Y=K,W=e.clone(v,W))}var Z=t.cartesianToCartographic(W,G);return Y=o.clamp(Y,0,1),_=e.magnitude(e.subtract(W,u,O))*Math.sqrt(1-Y*Y),_=l?-_:_,Z.height=_,t.cartographicToCartesian(Z,new e)}return void 0};var z=new e;return E.lineSegmentPlane=function(r,t,a,u){if(!n(r))throw new i("endPoint0 is required.");if(!n(t))throw new i("endPoint1 is required.");if(!n(a))throw new i("plane is required.");n(u)||(u=new e);var s=e.subtract(t,r,z),f=a.normal,l=e.dot(f,s);if(Math.abs(l)<o.EPSILON6)return void 0;var c=e.dot(f,r),h=-(a.distance+c)/l;return 0>h||h>1?void 0:(e.multiplyByScalar(s,h,u),e.add(r,u,u),u)},E.trianglePlaneIntersection=function(r,t,o,a){if(!(n(r)&&n(t)&&n(o)&&n(a)))throw new i("p0, p1, p2, and plane are required.");var u=a.normal,s=a.distance,f=e.dot(u,r)+s<0,l=e.dot(u,t)+s<0,c=e.dot(u,o)+s<0,h=0;h+=f?1:0,h+=l?1:0,h+=c?1:0;var d,w;if((1===h||2===h)&&(d=new e,w=new e),1===h){if(f)return E.lineSegmentPlane(r,t,a,d),E.lineSegmentPlane(r,o,a,w),{positions:[r,t,o,d,w],indices:[0,3,4,1,2,4,1,4,3]};if(l)return E.lineSegmentPlane(t,o,a,d),E.lineSegmentPlane(t,r,a,w),{positions:[r,t,o,d,w],indices:[1,3,4,2,0,4,2,4,3]};if(c)return E.lineSegmentPlane(o,r,a,d),E.lineSegmentPlane(o,t,a,w),{positions:[r,t,o,d,w],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===h){if(!f)return E.lineSegmentPlane(t,r,a,d),E.lineSegmentPlane(o,r,a,w),{positions:[r,t,o,d,w],indices:[1,2,4,1,4,3,0,3,4]};if(!l)return E.lineSegmentPlane(o,t,a,d),E.lineSegmentPlane(r,t,a,w),{positions:[r,t,o,d,w],indices:[2,0,4,2,4,3,1,3,4]};if(!c)return E.lineSegmentPlane(r,o,a,d),E.lineSegmentPlane(t,o,a,w),{positions:[r,t,o,d,w],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},E}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n={};return n.calculateACMR=function(n){n=e(n,e.EMPTY_OBJECT);var i=n.indices,o=n.maximumIndex,a=e(n.cacheSize,24);if(!r(i))throw new t("indices is required.");var u=i.length;if(3>u||u%3!==0)throw new t("indices length must be a multiple of three.");if(0>=o)throw new t("maximumIndex must be greater than zero.");if(3>a)throw new t("cacheSize must be greater than two.");if(!r(o)){o=0;for(var s=0,f=i[s];u>s;)f>o&&(o=f),++s,f=i[s]}for(var l=[],c=0;o+1>c;c++)l[c]=0;for(var h=a+1,d=0;u>d;++d)h-l[i[d]]>a&&(l[i[d]]=h,++h);return(h-a+1)/(u/3)},n.tipsify=function(n){function i(e,r,t,n){for(;r.length>=1;){var i=r[r.length-1];if(r.splice(r.length-1,1),e[i].numLiveTriangles>0)return i}for(;n>a;){if(e[a].numLiveTriangles>0)return++a,a-1;++a}return-1}function o(e,r,t,n,o,a,u){for(var s,f=-1,l=-1,c=0;c<t.length;){var h=t[c];n[h].numLiveTriangles&&(s=0,o-n[h].timeStamp+2*n[h].numLiveTriangles<=r&&(s=o-n[h].timeStamp),(s>l||-1===l)&&(l=s,f=h)),++c}return-1===f?i(n,a,e,u):f}n=e(n,e.EMPTY_OBJECT);var a,u=n.indices,s=n.maximumIndex,f=e(n.cacheSize,24);if(!r(u))throw new t("indices is required.");var l=u.length;if(3>l||l%3!==0)throw new t("indices length must be a multiple of three.");if(0>=s)throw new t("maximumIndex must be greater than zero.");if(3>f)throw new t("cacheSize must be greater than two.");var c=0,h=0,d=u[h],w=l;if(r(s))c=s+1;else{for(;w>h;)d>c&&(c=d),++h,d=u[h];if(-1===c)return 0;++c}for(var E=[],m=0;c>m;m++)E[m]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};h=0;for(var p=0;w>h;)E[u[h]].vertexTriangles.push(p),++E[u[h]].numLiveTriangles,E[u[h+1]].vertexTriangles.push(p),++E[u[h+1]].numLiveTriangles,E[u[h+2]].vertexTriangles.push(p),++E[u[h+2]].numLiveTriangles,++p,h+=3;var y=0,T=f+1;a=1;var A,R,v=[],_=[],g=0,S=[],C=l/3,N=[];for(m=0;C>m;m++)N[m]=!1;for(var I,O;-1!==y;){v=[],R=E[y],O=R.vertexTriangles.length;for(var b=0;O>b;++b)if(p=R.vertexTriangles[b],!N[p]){N[p]=!0,h=p+p+p;for(var M=0;3>M;++M)I=u[h],v.push(I),_.push(I),S[g]=I,++g,A=E[I],--A.numLiveTriangles,T-A.timeStamp>f&&(A.timeStamp=T,++T),++h}y=o(u,f,v,E,T,_,c)}return S},n}),define("Core/GeometryPipeline",["./AttributeCompression","./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryInstance","./GeometryType","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],function(e,r,t,n,i,o,a,u,s,f,l,c,h,d,w,E,m,p,y,T,A,R,v,_,g,S){"use strict";function C(e,r,t,n,i){e[r++]=t,e[r++]=n,e[r++]=n,e[r++]=i,e[r++]=i,e[r]=t}function N(e){for(var r=e.length,t=r/3*6,n=p.createTypedArray(r,t),i=0,o=0;r>o;o+=3,i+=6)C(n,i,e[o],e[o+1],e[o+2]);return n}function I(e){var r=e.length;if(r>=3){var t=6*(r-2),n=p.createTypedArray(r,t);C(n,0,e[0],e[1],e[2]);for(var i=6,o=3;r>o;++o,i+=6)C(n,i,e[o-1],e[o],e[o-2]);return n}return new Uint16Array}function O(e){if(e.length>0){for(var r=e.length-1,t=6*(r-1),n=p.createTypedArray(r,t),i=e[0],o=0,a=1;r>a;++a,o+=6)C(n,o,i,e[a],e[a+1]);return n}return new Uint16Array}function b(e){var r={};for(var t in e)if(e.hasOwnProperty(t)&&f(e[t])&&f(e[t].values)){var n=e[t];r[t]=new w({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return r}function M(e,r,t){for(var n in r)if(r.hasOwnProperty(n)&&f(r[n])&&f(r[n].values))for(var i=r[n],o=0;o<i.componentsPerAttribute;++o)e[n].values.push(i.values[t*i.componentsPerAttribute+o])}function q(e,r){if(f(r))for(var t=r.values,n=t.length,o=0;n>o;o+=3)i.unpack(t,o,oe),v.multiplyByPoint(e,oe,oe),i.pack(oe,t,o)}function L(e,r){if(f(r))for(var t=r.values,n=t.length,o=0;n>o;o+=3)i.unpack(t,o,oe),R.multiplyByVector(e,oe,oe),oe=i.normalize(oe,oe),i.pack(oe,t,o)}function F(e,r){var t,n=e.length,i={},o=e[0][r].attributes;for(t in o)if(o.hasOwnProperty(t)&&f(o[t])&&f(o[t].values)){for(var a=o[t],s=a.values.length,l=!0,c=1;n>c;++c){var h=e[c][r].attributes[t];if(!f(h)||a.componentDatatype!==h.componentDatatype||a.componentsPerAttribute!==h.componentsPerAttribute||a.normalize!==h.normalize){l=!1;break}s+=h.values.length}l&&(i[t]=new w({componentDatatype:a.componentDatatype,componentsPerAttribute:a.componentsPerAttribute,normalize:a.normalize,values:u.createTypedArray(a.componentDatatype,s)}))}return i}function P(e,r){var n,o,a,u,s=e.length,c=e[0].modelMatrix,h=f(e[0][r].indices),w=e[0][r].primitiveType;for(o=1;s>o;++o){if(!v.equals(e[o].modelMatrix,c))throw new l("All instances must have the same modelMatrix.");if(f(e[o][r].indices)!==h)throw new l("All instance geometries must have an indices or not have one.");if(e[o][r].primitiveType!==w)throw new l("All instance geometries must have the same primitiveType.")}var E,m,y,T=F(e,r);for(n in T)if(T.hasOwnProperty(n))for(E=T[n].values,u=0,o=0;s>o;++o)for(m=e[o][r].attributes[n].values,y=m.length,a=0;y>a;++a)E[u++]=m[a];var A;if(h){var R=0;for(o=0;s>o;++o)R+=e[o][r].indices.length;var _=d.computeNumberOfVertices(new d({attributes:T,primitiveType:g.POINTS})),S=p.createTypedArray(_,R),C=0,N=0;for(o=0;s>o;++o){var I=e[o][r].indices,O=I.length;for(u=0;O>u;++u)S[C++]=N+I[u];N+=d.computeNumberOfVertices(e[o][r])}A=S}var b,M=new i,q=0;for(o=0;s>o;++o){if(b=e[o][r].boundingSphere,!f(b)){M=void 0;break}i.add(b.center,M,M)}if(f(M))for(i.divideByScalar(M,s,M),o=0;s>o;++o){b=e[o][r].boundingSphere;var L=i.magnitude(i.subtract(b.center,M,se))+b.radius;L>q&&(q=L)}return new d({attributes:T,indices:A,primitiveType:w,boundingSphere:f(M)?new t(M,q):void 0})}function D(e){if(f(e.indices))return e;var r=d.computeNumberOfVertices(e);if(3>r)throw new l("The number of vertices must be at least three.");if(r%3!==0)throw new l("The number of vertices must be a multiple of three.");for(var t=p.createTypedArray(r,r),n=0;r>n;++n)t[n]=n;return e.indices=t,e}function x(e){var r=d.computeNumberOfVertices(e);if(3>r)throw new l("The number of vertices must be at least three.");var t=p.createTypedArray(r,3*(r-2));t[0]=1,t[1]=0,t[2]=2;for(var n=3,i=3;r>i;++i)t[n++]=i-1,t[n++]=0,t[n++]=i;return e.indices=t,e.primitiveType=g.TRIANGLES,e}function U(e){var r=d.computeNumberOfVertices(e);if(3>r)throw new l("The number of vertices must be at least 3.");var t=p.createTypedArray(r,3*(r-2));t[0]=0,t[1]=1,t[2]=2,r>3&&(t[3]=0,t[4]=2,t[5]=3);for(var n=6,i=3;r-1>i;i+=2)t[n++]=i,t[n++]=i-1,t[n++]=i+1,r>i+2&&(t[n++]=i,t[n++]=i+1,t[n++]=i+2);return e.indices=t,e.primitiveType=g.TRIANGLES,e}function B(e){if(f(e.indices))return e;var r=d.computeNumberOfVertices(e);if(2>r)throw new l("The number of vertices must be at least two.");if(r%2!==0)throw new l("The number of vertices must be a multiple of 2.");for(var t=p.createTypedArray(r,r),n=0;r>n;++n)t[n]=n;return e.indices=t,e}function G(e){var r=d.computeNumberOfVertices(e);if(2>r)throw new l("The number of vertices must be at least two.");var t=p.createTypedArray(r,2*(r-1));t[0]=0,t[1]=1;for(var n=2,i=2;r>i;++i)t[n++]=i-1,t[n++]=i;return e.indices=t,e.primitiveType=g.LINES,e}function z(e){var r=d.computeNumberOfVertices(e);if(2>r)throw new l("The number of vertices must be at least two.");var t=p.createTypedArray(r,2*r);t[0]=0,t[1]=1;for(var n=2,i=2;r>i;++i)t[n++]=i-1,t[n++]=i;return t[n++]=r-1,t[n]=0,e.indices=t,e.primitiveType=g.LINES,e}function V(e){switch(e.primitiveType){case g.TRIANGLE_FAN:return x(e);case g.TRIANGLE_STRIP:return U(e);case g.TRIANGLES:return D(e);case g.LINE_STRIP:return G(e);case g.LINE_LOOP:return z(e);case g.LINES:return B(e)}return e}function H(e,r){Math.abs(e.y)<A.EPSILON6&&(r?e.y=-A.EPSILON6:e.y=A.EPSILON6)}function W(e,r,t){if(0!==e.y&&0!==r.y&&0!==t.y)return H(e,e.y<0),H(r,r.y<0),void H(t,t.y<0);var n,i=Math.abs(e.y),o=Math.abs(r.y),a=Math.abs(t.y);n=i>o?i>a?A.sign(e.y):A.sign(t.y):o>a?A.sign(r.y):A.sign(t.y);var u=0>n;H(e,u),H(r,u),H(t,u)}function Y(e,r,t,n){i.add(e,i.multiplyByScalar(i.subtract(r,e,Ae),e.y/(e.y-r.y),Ae),t),i.clone(t,n),H(t,!0),H(n,!1)}function X(e,r,t){if(e.x>=0||r.x>=0||t.x>=0)return void 0;W(e,r,t);var n=e.y<0,i=r.y<0,o=t.y<0,a=0;a+=n?1:0,a+=i?1:0,a+=o?1:0;var u=Se.indices;1===a?(u[1]=3,u[2]=4,u[5]=6,u[7]=6,u[8]=5,n?(Y(e,r,Re,_e),Y(e,t,ve,ge),u[0]=0,u[3]=1,u[4]=2,u[6]=1):i?(Y(r,t,Re,_e),Y(r,e,ve,ge),u[0]=1,u[3]=2,u[4]=0,u[6]=2):o&&(Y(t,e,Re,_e),Y(t,r,ve,ge),u[0]=2,u[3]=0,u[4]=1,u[6]=0)):2===a&&(u[2]=4,u[4]=4,u[5]=3,u[7]=5,u[8]=6,n?i?o||(Y(t,e,Re,_e),Y(t,r,ve,ge),u[0]=0,u[1]=1,u[3]=0,u[6]=2):(Y(r,t,Re,_e),Y(r,e,ve,ge),u[0]=2,u[1]=0,u[3]=2,u[6]=1):(Y(e,r,Re,_e),Y(e,t,ve,ge),u[0]=1,u[1]=2,u[3]=1,u[6]=0));var s=Se.positions;return s[0]=e,s[1]=r,s[2]=t,s.length=3,(1===a||2===a)&&(s[3]=Re,s[4]=ve,s[5]=_e,s[6]=ge,s.length=7),Se}function k(e,r){var n=e.attributes;if(0===n.position.values.length)return void 0;for(var i in n)if(n.hasOwnProperty(i)&&f(n[i])&&f(n[i].values)){var o=n[i];o.values=u.createTypedArray(o.componentDatatype,o.values)}var a=d.computeNumberOfVertices(e);return e.indices=p.createTypedArray(a,e.indices),r&&(e.boundingSphere=t.fromVertices(n.position.values)),e}function K(e){var r=e.attributes,t={};for(var n in r)if(r.hasOwnProperty(n)&&f(r[n])&&f(r[n].values)){var i=r[n];t[n]=new w({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]})}return new d({attributes:t,indices:[],primitiveType:e.primitiveType})}function Z(e,r,t){var n=f(e.geometry.boundingSphere);r=k(r,n),t=k(t,n),f(t)&&!f(r)?e.geometry=t:!f(t)&&f(r)?e.geometry=r:(e.westHemisphereGeometry=r,e.eastHemisphereGeometry=t,e.geometry=void 0)}function j(e,t,o,a,u,s,l,c,h,d,w){if(f(s)||f(l)||f(c)||f(h)){var E=i.fromArray(u,3*e,Ce),m=i.fromArray(u,3*t,Ne),p=i.fromArray(u,3*o,Ie),y=r(a,E,m,p,Oe);if(f(s)){var T=i.fromArray(s,3*e,Ce),A=i.fromArray(s,3*t,Ne),R=i.fromArray(s,3*o,Ie);i.multiplyByScalar(T,y.x,T),i.multiplyByScalar(A,y.y,A),i.multiplyByScalar(R,y.z,R);var v=i.add(T,A,T);i.add(v,R,v),i.normalize(v,v),i.pack(v,d.normal.values,3*w)}if(f(l)){var _=i.fromArray(l,3*e,Ce),g=i.fromArray(l,3*t,Ne),S=i.fromArray(l,3*o,Ie);i.multiplyByScalar(_,y.x,_),i.multiplyByScalar(g,y.y,g),i.multiplyByScalar(S,y.z,S);var C=i.add(_,g,_);i.add(C,S,C),i.normalize(C,C),i.pack(C,d.binormal.values,3*w)}if(f(c)){var N=i.fromArray(c,3*e,Ce),I=i.fromArray(c,3*t,Ne),O=i.fromArray(c,3*o,Ie);i.multiplyByScalar(N,y.x,N),i.multiplyByScalar(I,y.y,I),i.multiplyByScalar(O,y.z,O);var b=i.add(N,I,N);i.add(b,O,b),i.normalize(b,b),i.pack(b,d.tangent.values,3*w)}if(f(h)){var M=n.fromArray(h,2*e,be),q=n.fromArray(h,2*t,Me),L=n.fromArray(h,2*o,qe);n.multiplyByScalar(M,y.x,M),n.multiplyByScalar(q,y.y,q),n.multiplyByScalar(L,y.z,L);var F=n.add(M,q,M);n.add(F,L,F),n.pack(F,d.st.values,2*w)}}}function Q(e,r,t,n,i,o){var a=e.position.values.length/3;if(-1!==i){var u=n[i],s=t[u];return-1===s?(t[u]=a,e.position.values.push(o.x,o.y,o.z),r.push(a),a):(r.push(s),s)}return e.position.values.push(o.x,o.y,o.z),r.push(a),a}function J(e){var r,t,n,o,a,u=e.geometry,s=u.attributes,l=s.position.values,c=f(s.normal)?s.normal.values:void 0,h=f(s.binormal)?s.binormal.values:void 0,d=f(s.tangent)?s.tangent.values:void 0,w=f(s.st)?s.st.values:void 0,E=u.indices,m=K(u),p=K(u),y=[];y.length=l.length/3;var T=[];for(T.length=l.length/3,a=0;a<y.length;++a)y[a]=-1,T[a]=-1;var A=E.length;for(a=0;A>a;a+=3){var R=E[a],v=E[a+1],_=E[a+2],g=i.fromArray(l,3*R),S=i.fromArray(l,3*v),C=i.fromArray(l,3*_),N=X(g,S,C);if(f(N)&&N.positions.length>3)for(var I=N.positions,O=N.indices,b=O.length,M=0;b>M;++M){var q=O[M],L=I[q];L.y<0?(r=p.attributes,t=p.indices,n=y):(r=m.attributes,t=m.indices,n=T),o=Q(r,t,n,E,3>q?a+q:-1,L),j(R,v,_,L,l,c,h,d,w,r,o)}else f(N)&&(g=N.positions[0],S=N.positions[1],C=N.positions[2]),g.y<0?(r=p.attributes,t=p.indices,n=y):(r=m.attributes,t=m.indices,n=T),o=Q(r,t,n,E,a,g),j(R,v,_,g,l,c,h,d,w,r,o),o=Q(r,t,n,E,a+1,S),j(R,v,_,S,l,c,h,d,w,r,o),o=Q(r,t,n,E,a+2,C),j(R,v,_,C,l,c,h,d,w,r,o)}Z(e,p,m)}function $(e){var r,t=e.geometry,n=t.attributes,o=n.position.values,a=t.indices,u=K(t),s=K(t),l=a.length,c=[];c.length=o.length/3;var h=[];for(h.length=o.length/3,r=0;r<c.length;++r)c[r]=-1,h[r]=-1;for(r=0;l>r;r+=2){var d=a[r],w=a[r+1],E=i.fromArray(o,3*d,Ce),m=i.fromArray(o,3*w,Ne);Math.abs(E.y)<A.EPSILON6&&(E.y<0?E.y=-A.EPSILON6:E.y=A.EPSILON6),Math.abs(m.y)<A.EPSILON6&&(m.y<0?m.y=-A.EPSILON6:m.y=A.EPSILON6);var p=u.attributes,y=u.indices,R=h,v=s.attributes,_=s.indices,g=c,S=T.lineSegmentPlane(E,m,Le,Ie);if(f(S)){var C=i.multiplyByScalar(i.UNIT_Y,5*A.EPSILON9,Fe);E.y<0&&(i.negate(C,C),p=s.attributes,y=s.indices,R=c,v=u.attributes,_=u.indices,g=h);var N=i.add(S,C,Pe);Q(p,y,R,a,r,E),Q(p,y,R,a,-1,N),i.negate(C,C),i.add(S,C,N),Q(v,_,g,a,-1,N),Q(v,_,g,a,r+1,m)}else{var I,O,b;E.y<0?(I=s.attributes,O=s.indices,b=c):(I=u.attributes,O=u.indices,b=h),Q(I,O,b,a,r,E),Q(I,O,b,a,r+1,m)}}Z(e,s,u)}function ee(e){var r,t,a,u=e.geometry,s=u.attributes,l=s.position.values,c=s.prevPosition.values,h=s.nextPosition.values,d=s.expandAndWidth.values,w=(u.indices,f(s.st)?s.st.values:void 0),E=f(s.color)?s.color.values:void 0,m=K(u),p=K(u),y=l.length/3;for(r=0;y>r;r+=4){var R=r,v=r+1,_=r+2,g=r+3,S=i.fromArray(l,3*R,Ue),C=i.fromArray(l,3*v,Be),N=i.fromArray(l,3*_,Ge),I=i.fromArray(l,3*g,ze);Math.abs(S.y)<A.EPSILON6&&(S.y=A.EPSILON6*(N.y<0?-1:1),C.y=S.y),Math.abs(N.y)<A.EPSILON6&&(N.y=A.EPSILON6*(S.y<0?-1:1),I.y=N.y);var O=m.attributes,b=m.indices,M=p.attributes,q=p.indices,L=T.lineSegmentPlane(S,N,Le,Ve);if(f(L)){var F=i.multiplyByScalar(i.UNIT_Y,5*A.EPSILON9,He);S.y<0&&(i.negate(F,F),O=p.attributes,b=p.indices,M=m.attributes,q=m.indices);var P=i.add(L,F,We);for(O.position.values.push(S.x,S.y,S.z,C.x,C.y,C.z),O.position.values.push(P.x,P.y,P.z),O.position.values.push(P.x,P.y,P.z),i.negate(F,F),i.add(L,F,P),M.position.values.push(P.x,P.y,P.z),M.position.values.push(P.x,P.y,P.z),M.position.values.push(N.x,N.y,N.z,I.x,I.y,I.z),t=3*R;3*R+6>t;++t)O.prevPosition.values.push(c[t]);for(O.prevPosition.values.push(S.x,S.y,S.z,S.x,S.y,S.z),M.prevPosition.values.push(S.x,S.y,S.z,S.x,S.y,S.z),t=3*_;3*_+6>t;++t)M.prevPosition.values.push(c[t]);for(t=3*R;3*R+6>t;++t)O.nextPosition.values.push(h[t]);for(O.nextPosition.values.push(N.x,N.y,N.z,N.x,N.y,N.z),M.nextPosition.values.push(N.x,N.y,N.z,N.x,N.y,N.z),t=3*_;3*_+6>t;++t)M.nextPosition.values.push(h[t]);var D=n.fromArray(d,2*R,De),x=Math.abs(D.y);O.expandAndWidth.values.push(-1,x,1,x),O.expandAndWidth.values.push(-1,-x,1,-x),M.expandAndWidth.values.push(-1,x,1,x),M.expandAndWidth.values.push(-1,-x,1,-x);var U=i.magnitudeSquared(i.subtract(L,S,ze));if(U/=i.magnitudeSquared(i.subtract(N,S,ze)),f(E)){var B=o.fromArray(E,4*R,Ye),G=o.fromArray(E,4*_,Ye),z=A.lerp(B.x,G.x,U),V=A.lerp(B.y,G.y,U),H=A.lerp(B.z,G.z,U),W=A.lerp(B.w,G.w,U);for(t=4*R;4*R+8>t;++t)O.color.values.push(E[t]);for(O.color.values.push(z,V,H,W),O.color.values.push(z,V,H,W),M.color.values.push(z,V,H,W),M.color.values.push(z,V,H,W),t=4*_;4*_+8>t;++t)M.color.values.push(E[t])}if(f(w)){var Y=n.fromArray(w,2*R,De),X=n.fromArray(w,2*(r+3),xe),k=A.lerp(Y.x,X.x,U);for(t=2*R;2*R+4>t;++t)O.st.values.push(w[t]);for(O.st.values.push(k,Y.y),O.st.values.push(k,X.y),M.st.values.push(k,Y.y),M.st.values.push(k,X.y),t=2*_;2*_+4>t;++t)M.st.values.push(w[t])}a=O.position.values.length/3-4,b.push(a,a+2,a+1),b.push(a+1,a+2,a+3),a=M.position.values.length/3-4,q.push(a,a+2,a+1),q.push(a+1,a+2,a+3)}else{var j,Q;for(S.y<0?(j=p.attributes,Q=p.indices):(j=m.attributes,Q=m.indices),j.position.values.push(S.x,S.y,S.z),j.position.values.push(C.x,C.y,C.z),j.position.values.push(N.x,N.y,N.z),j.position.values.push(I.x,I.y,I.z),t=3*r;3*r+12>t;++t)j.prevPosition.values.push(c[t]),j.nextPosition.values.push(h[t]);for(t=2*r;2*r+8>t;++t)j.expandAndWidth.values.push(d[t]),f(w)&&j.st.values.push(w[t]);if(f(E))for(t=4*r;4*r+16>t;++t)j.color.values.push(E[t]);a=j.position.values.length/3-4,Q.push(a,a+2,a+1),Q.push(a+1,a+2,a+3)}}Z(e,p,m)}var re={};re.toWireframe=function(e){if(!f(e))throw new l("geometry is required.");var r=e.indices;if(f(r)){switch(e.primitiveType){case g.TRIANGLES:e.indices=N(r);break;case g.TRIANGLE_STRIP:e.indices=I(r);break;case g.TRIANGLE_FAN:e.indices=O(r);break;default:throw new l("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=g.LINES}return e},re.createLineSegmentsForVectors=function(e,r,n){if(r=s(r,"normal"),!f(e))throw new l("geometry is required.");if(!f(e.attributes.position))throw new l("geometry.attributes.position is required.");if(!f(e.attributes[r]))throw new l("geometry.attributes must have an attribute with the same name as the attributeName parameter, "+r+".");n=s(n,1e4);for(var i=e.attributes.position.values,o=e.attributes[r].values,a=i.length,c=new Float64Array(2*a),h=0,E=0;a>E;E+=3)c[h++]=i[E],c[h++]=i[E+1],c[h++]=i[E+2],c[h++]=i[E]+o[E]*n,c[h++]=i[E+1]+o[E+1]*n,c[h++]=i[E+2]+o[E+2]*n;var m,p=e.boundingSphere;return f(p)&&(m=new t(p.center,p.radius+n)),new d({attributes:{position:new w({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:c})},primitiveType:g.LINES,boundingSphere:m})},re.createAttributeLocations=function(e){if(!f(e))throw new l("geometry is required.");var r,t=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent","compressedAttributes"],n=e.attributes,i={},o=0,a=t.length;for(r=0;a>r;++r){var u=t[r];f(n[u])&&(i[u]=o++)}for(var s in n)n.hasOwnProperty(s)&&!f(i[s])&&(i[s]=o++);return i},re.reorderForPreVertexCache=function(e){if(!f(e))throw new l("geometry is required.");var r=d.computeNumberOfVertices(e),t=e.indices;if(f(t)){for(var n=new Int32Array(r),i=0;r>i;i++)n[i]=-1;for(var o,a=t,s=a.length,c=p.createTypedArray(r,s),h=0,w=0,E=0;s>h;)o=n[a[h]],-1!==o?c[w]=o:(o=a[h],n[o]=E,c[w]=E,++E),++h,++w;e.indices=c;var m=e.attributes;for(var y in m)if(m.hasOwnProperty(y)&&f(m[y])&&f(m[y].values)){for(var T=m[y],A=T.values,R=0,v=T.componentsPerAttribute,_=u.createTypedArray(T.componentDatatype,E*v);r>R;){var g=n[R];if(-1!==g)for(i=0;v>i;i++)_[v*g+i]=A[v*R+i];++R}T.values=_}}return e},re.reorderForPostVertexCache=function(e,r){if(!f(e))throw new l("geometry is required.");var t=e.indices;if(e.primitiveType===g.TRIANGLES&&f(t)){for(var n=t.length,i=0,o=0;n>o;o++)t[o]>i&&(i=t[o]);e.indices=S.tipsify({indices:t,maximumIndex:i,cacheSize:r})}return e},re.fitToUnsignedShortIndices=function(e){if(!f(e))throw new l("geometry is required.");if(f(e.indices)&&e.primitiveType!==g.TRIANGLES&&e.primitiveType!==g.LINES&&e.primitiveType!==g.POINTS)throw new l("geometry.primitiveType must equal to PrimitiveType.TRIANGLES, PrimitiveType.LINES, or PrimitiveType.POINTS.");var r=[],t=d.computeNumberOfVertices(e);if(f(e.indices)&&t>=A.SIXTY_FOUR_KILOBYTES){var n,i=[],o=[],a=0,u=b(e.attributes),s=e.indices,c=s.length;e.primitiveType===g.TRIANGLES?n=3:e.primitiveType===g.LINES?n=2:e.primitiveType===g.POINTS&&(n=1);for(var h=0;c>h;h+=n){for(var w=0;n>w;++w){var E=s[h+w],m=i[E];f(m)||(m=a++,i[E]=m,M(u,e.attributes,E)),o.push(m)}a+n>=A.SIXTY_FOUR_KILOBYTES&&(r.push(new d({attributes:u,indices:o,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),i=[],o=[],a=0,u=b(e.attributes))}0!==o.length&&r.push(new d({attributes:u,indices:o,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else r.push(e);return r};var te=new i,ne=new a;re.projectTo2D=function(e,r,t,n,o){if(!f(e))throw new l("geometry is required.");if(!f(r))throw new l("attributeName is required.");if(!f(t))throw new l("attributeName3D is required.");if(!f(n))throw new l("attributeName2D is required.");if(!f(e.attributes[r]))throw new l("geometry must have attribute matching the attributeName argument: "+r+".");if(e.attributes[r].componentDatatype!==u.DOUBLE)throw new l("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");var a=e.attributes[r];o=f(o)?o:new h;for(var s=o.ellipsoid,c=a.values,d=new Float64Array(c.length),E=0,m=0;m<c.length;m+=3){var p=i.fromArray(c,m,te),y=s.cartesianToCartographic(p,ne);if(!f(y))throw new l("Could not project point ("+p.x+", "+p.y+", "+p.z+") to 2D.");var T=o.project(y,te);d[E++]=T.x,d[E++]=T.y,d[E++]=T.z}return e.attributes[t]=a,e.attributes[n]=new w({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:d}),delete e.attributes[r],e};var ie={high:0,low:0};re.encodeAttribute=function(e,r,t,n){if(!f(e))throw new l("geometry is required.");if(!f(r))throw new l("attributeName is required.");if(!f(t))throw new l("attributeHighName is required.");if(!f(n))throw new l("attributeLowName is required.");if(!f(e.attributes[r]))throw new l("geometry must have attribute matching the attributeName argument: "+r+".");if(e.attributes[r].componentDatatype!==u.DOUBLE)throw new l("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");for(var i=e.attributes[r],o=i.values,a=o.length,s=new Float32Array(a),h=new Float32Array(a),d=0;a>d;++d)c.encode(o[d],ie),s[d]=ie.high,h[d]=ie.low;var E=i.componentsPerAttribute;return e.attributes[t]=new w({componentDatatype:u.FLOAT,componentsPerAttribute:E,values:s}),e.attributes[n]=new w({componentDatatype:u.FLOAT,componentsPerAttribute:E,values:h}),delete e.attributes[r],e};var oe=new i,ae=new v,ue=new R;re.transformToWorldCoordinates=function(e){if(!f(e))throw new l("instance is required.");var r=e.modelMatrix;if(v.equals(r,v.IDENTITY))return e;var n=e.geometry.attributes;q(r,n.position),q(r,n.prevPosition),q(r,n.nextPosition),(f(n.normal)||f(n.binormal)||f(n.tangent))&&(v.inverse(r,ae),v.transpose(ae,ae),v.getRotation(ae,ue),L(ue,n.normal),L(ue,n.binormal),L(ue,n.tangent));var i=e.geometry.boundingSphere;return f(i)&&(e.geometry.boundingSphere=t.transform(i,r,i)),e.modelMatrix=v.clone(v.IDENTITY),e};var se=new i;re.combineInstances=function(e){if(!f(e)||e.length<1)throw new l("instances is required and must have length greater than zero.");for(var r=[],t=[],n=e.length,i=0;n>i;++i){var o=e[i];f(o.geometry)?r.push(o):t.push(o)}var a=[];return r.length>0&&a.push(P(r,"geometry")),t.length>0&&(a.push(P(t,"westHemisphereGeometry")),a.push(P(t,"eastHemisphereGeometry"))),a};var fe=new i,le=new i,ce=new i,he=new i;re.computeNormal=function(e){if(!f(e))throw new l("geometry is required.");if(!f(e.attributes.position)||!f(e.attributes.position.values))throw new l("geometry.attributes.position.values is required.");if(!f(e.indices))throw new l("geometry.indices is required.");if(e.indices.length<2||e.indices.length%3!==0)throw new l("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==g.TRIANGLES)throw new l("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var r=e.indices,t=e.attributes,n=t.position.values,o=t.position.values.length/3,a=r.length,s=new Array(o),c=new Array(a/3),h=new Array(a),d=0;o>d;d++)s[d]={indexOffset:0,count:0,currentCount:0};var E=0;for(d=0;a>d;d+=3){var m=r[d],p=r[d+1],y=r[d+2],T=3*m,A=3*p,R=3*y;le.x=n[T],le.y=n[T+1],le.z=n[T+2],ce.x=n[A],ce.y=n[A+1],ce.z=n[A+2],he.x=n[R],he.y=n[R+1],he.z=n[R+2],s[m].count++,s[p].count++,s[y].count++,i.subtract(ce,le,ce),i.subtract(he,le,he),c[E]=i.cross(ce,he,new i),E++}var v=0;for(d=0;o>d;d++)s[d].indexOffset+=v,v+=s[d].count;E=0;var _;for(d=0;a>d;d+=3){_=s[r[d]];var S=_.indexOffset+_.currentCount;h[S]=E,_.currentCount++,_=s[r[d+1]],S=_.indexOffset+_.currentCount,h[S]=E,_.currentCount++,_=s[r[d+2]],S=_.indexOffset+_.currentCount,h[S]=E,_.currentCount++,E++}var C=new Float32Array(3*o);for(d=0;o>d;d++){var N=3*d;if(_=s[d],_.count>0){for(i.clone(i.ZERO,fe),E=0;E<_.count;E++)i.add(fe,c[h[_.indexOffset+E]],fe);i.normalize(fe,fe),C[N]=fe.x,C[N+1]=fe.y,C[N+2]=fe.z}else C[N]=0,C[N+1]=0,C[N+2]=1}return e.attributes.normal=new w({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:C}),e};var de=new i,we=new i,Ee=new i;re.computeBinormalAndTangent=function(e){if(!f(e))throw new l("geometry is required.");var r=e.attributes,t=e.indices;if(!f(r.position)||!f(r.position.values))throw new l("geometry.attributes.position.values is required.");if(!f(r.normal)||!f(r.normal.values))throw new l("geometry.attributes.normal.values is required.");if(!f(r.st)||!f(r.st.values))throw new l("geometry.attributes.st.values is required.");if(!f(t))throw new l("geometry.indices is required.");if(t.length<2||t.length%3!==0)throw new l("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==g.TRIANGLES)throw new l("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var n=e.attributes.position.values,o=e.attributes.normal.values,a=e.attributes.st.values,s=e.attributes.position.values.length/3,c=t.length,h=new Array(3*s),d=0;d<h.length;d++)h[d]=0;var E,m,p;for(d=0;c>d;d+=3){var y=t[d],T=t[d+1],A=t[d+2];E=3*y,m=3*T,p=3*A;var R=2*y,v=2*T,_=2*A,S=n[E],C=n[E+1],N=n[E+2],I=a[R],O=a[R+1],b=a[v+1]-O,M=a[_+1]-O,q=1/((a[v]-I)*M-(a[_]-I)*b),L=(M*(n[m]-S)-b*(n[p]-S))*q,F=(M*(n[m+1]-C)-b*(n[p+1]-C))*q,P=(M*(n[m+2]-N)-b*(n[p+2]-N))*q;h[E]+=L,h[E+1]+=F,h[E+2]+=P,h[m]+=L,h[m+1]+=F,h[m+2]+=P,h[p]+=L,h[p+1]+=F,h[p+2]+=P}var D=new Float32Array(3*s),x=new Float32Array(3*s);for(d=0;s>d;d++){E=3*d,m=E+1,p=E+2;var U=i.fromArray(o,E,de),B=i.fromArray(h,E,Ee),G=i.dot(U,B);i.multiplyByScalar(U,G,we),i.normalize(i.subtract(B,we,B),B),x[E]=B.x,x[m]=B.y,x[p]=B.z,i.normalize(i.cross(U,B,B),B),D[E]=B.x,D[m]=B.y,D[p]=B.z}return e.attributes.tangent=new w({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:x}),e.attributes.binormal=new w({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:D}),e};var me=new n,pe=new i,ye=new i,Te=new i;re.compressVertices=function(r){if(!f(r))throw new l("geometry is required.");var t=r.attributes.normal,o=r.attributes.st;if(!f(t)&&!f(o))return r;var a,s,c,h,d=r.attributes.tangent,E=r.attributes.binormal;f(t)&&(a=t.values),f(o)&&(s=o.values),f(d)&&(c=d.values),E&&(h=E.values);var m=f(a)?a.length:s.length,p=f(a)?3:2,y=m/p,T=y,A=f(s)&&f(a)?2:1;A+=f(c)||f(h)?1:0,T*=A;for(var R=new Float32Array(T),v=0,_=0;y>_;++_){f(s)&&(n.fromArray(s,2*_,me),R[v++]=e.compressTextureCoordinates(me));var g=3*_;f(a)&&f(c)&&f(h)?(i.fromArray(a,g,pe),i.fromArray(c,g,ye),i.fromArray(h,g,Te),e.octPack(pe,ye,Te,me),R[v++]=me.x,R[v++]=me.y):(f(a)&&(i.fromArray(a,g,pe),R[v++]=e.octEncodeFloat(pe)),f(c)&&(i.fromArray(c,g,pe),R[v++]=e.octEncodeFloat(pe)),f(h)&&(i.fromArray(h,g,pe),R[v++]=e.octEncodeFloat(pe)))}return r.attributes.compressedAttributes=new w({componentDatatype:u.FLOAT,componentsPerAttribute:A,values:R}),f(a)&&delete r.attributes.normal,f(s)&&delete r.attributes.st,f(c)&&delete r.attributes.tangent,f(h)&&delete r.attributes.binormal,r};var Ae=new i,Re=new i,ve=new i,_e=new i,ge=new i,Se={positions:new Array(7),indices:new Array(9)},Ce=new i,Ne=new i,Ie=new i,Oe=new i,be=new n,Me=new n,qe=new n,Le=_.fromPointNormal(i.ZERO,i.UNIT_Y),Fe=new i,Pe=new i,De=new n,xe=new n,Ue=new i,Be=new i,Ge=new i,ze=new i,Ve=new i,He=new i,We=new i,Ye=new o;new o;return re.splitLongitude=function(e){if(!f(e))throw new l("instance is required.");var r=e.geometry,n=r.boundingSphere;if(f(n)){var i=n.center.x-n.radius;if(i>0||t.intersectPlane(n,_.ORIGIN_ZX_PLANE)!==y.INTERSECTING)return e}if(r.geometryType!==m.NONE)switch(r.geometryType){case m.POLYLINES:ee(e);break;case m.TRIANGLES:J(e);break;case m.LINES:$(e)}else V(r),r.primitiveType===g.TRIANGLES?J(e):r.primitiveType===g.LINES&&$(e);return e},re}),define("Core/WebMercatorProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,r,t,n,i,o,a,u){"use strict";var s=function(e){this._ellipsoid=t(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),s.mercatorAngleToGeodeticLatitude=function(e){return u.PI_OVER_TWO-2*Math.atan(Math.exp(-e))},s.geodeticLatitudeToMercatorAngle=function(e){e>s.MaximumLatitude?e=s.MaximumLatitude:e<-s.MaximumLatitude&&(e=-s.MaximumLatitude);var r=Math.sin(e);return.5*Math.log((1+r)/(1-r))},s.MaximumLatitude=s.mercatorAngleToGeodeticLatitude(Math.PI),s.prototype.project=function(r,t){var i=this._semimajorAxis,o=r.longitude*i,a=s.geodeticLatitudeToMercatorAngle(r.latitude)*i,u=r.height;return n(t)?(t.x=o,t.y=a,t.z=u,t):new e(o,a,u)},s.prototype.unproject=function(e,t){if(!n(e))throw new o("cartesian is required");var i=this._oneOverSemimajorAxis,a=e.x*i,u=s.mercatorAngleToGeodeticLatitude(e.y*i),f=e.z;return n(t)?(t.longitude=a,t.latitude=u,t.height=f,t):new r(a,u,f)},s}),define("Scene/PrimitivePipeline",["../Core/BoundingSphere","../Core/Color","../Core/ComponentDatatype","../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/Ellipsoid","../Core/FeatureDetection","../Core/GeographicProjection","../Core/Geometry","../Core/GeometryAttribute","../Core/GeometryAttributes","../Core/GeometryPipeline","../Core/IndexDatatype","../Core/Matrix4","../Core/WebMercatorProjection"],function(e,r,t,n,i,o,a,u,s,f,l,c,h,d,w,E){"use strict";function m(e,r,t){var n,i=!t,o=e.length;if(!i&&o>1){var a=e[0].modelMatrix;for(n=1;o>n;++n)if(!w.equals(a,e[n].modelMatrix)){i=!0;break}}if(i)for(n=0;o>n;++n)h.transformToWorldCoordinates(e[n]);else w.multiplyTransformation(r,e[0].modelMatrix,r)}function p(e,n){var i=e.attributes,o=i.position,a=4*(o.values.length/o.componentsPerAttribute);i.pickColor=new l({componentDatatype:t.UNSIGNED_BYTE,componentsPerAttribute:4,normalize:!0,values:new Uint8Array(a)});for(var u=r.floatToByte(n.red),s=r.floatToByte(n.green),f=r.floatToByte(n.blue),c=r.floatToByte(n.alpha),h=i.pickColor.values,d=0;a>d;d+=4)h[d]=u,h[d+1]=s,h[d+2]=f,h[d+3]=c}function y(e,r){
for(var t=e.length,n=0;t>n;++n){var o=e[n],a=r[n];i(o.geometry)?p(o.geometry,a):(p(o.westHemisphereGeometry,a),p(o.eastHemisphereGeometry,a))}}function T(e){var r,t=e.length,n=[],o=e[0].attributes;for(r in o)if(o.hasOwnProperty(r)){for(var a=o[r],u=!0,s=1;t>s;++s){var f=e[s].attributes[r];if(!i(f)||a.componentDatatype!==f.componentDatatype||a.componentsPerAttribute!==f.componentsPerAttribute||a.normalize!==f.normalize){u=!1;break}}u&&n.push(r)}return n}function A(e,r,n){for(var i=f.computeNumberOfVertices(r),o=n.length,a=0;o>a;++a){for(var u=n[a],s=e[u],c=s.componentDatatype,h=s.value,d=h.length,w=t.createTypedArray(c,i*d),E=0;i>E;++E)w.set(h,E*d);r.attributes[u]=new l({componentDatatype:c,componentsPerAttribute:d,normalize:s.normalize,values:w})}}function R(e,r){for(var t=e.length,n=0;t>n;++n){var o=e[n],a=o.attributes;i(o.geometry)?A(a,o.geometry,r):(A(a,o.westHemisphereGeometry,r),A(a,o.eastHemisphereGeometry,r))}}function v(r){var n,a,u=r.instances,s=r.pickIds,f=r.projection,l=r.elementIndexUintSupported,c=r.scene3DOnly,d=r.allowPicking,w=r.vertexCacheOptimize,E=r.compressVertices,p=r.modelMatrix,A=u.length,v=u[0].geometry.primitiveType;for(n=1;A>n;++n)if(u[n].geometry.primitiveType!==v)throw new o("All instance geometries must have the same primitiveType.");if(m(u,p,c),!c)for(n=0;A>n;++n)h.splitLongitude(u[n]);d&&y(u,s);var _=T(u);if(R(u,_),w)for(n=0;A>n;++n){var g=u[n];i(g.geometry)?(h.reorderForPostVertexCache(g.geometry),h.reorderForPreVertexCache(g.geometry)):(h.reorderForPostVertexCache(g.westHemisphereGeometry),h.reorderForPreVertexCache(g.westHemisphereGeometry),h.reorderForPostVertexCache(g.eastHemisphereGeometry),h.reorderForPreVertexCache(g.eastHemisphereGeometry))}var S=h.combineInstances(u);for(A=S.length,n=0;A>n;++n){a=S[n];var C,N=a.attributes;if(c)for(C in N)N.hasOwnProperty(C)&&N[C].componentDatatype===t.DOUBLE&&h.encodeAttribute(a,C,C+"3DHigh",C+"3DLow");else for(C in N)if(N.hasOwnProperty(C)&&N[C].componentDatatype===t.DOUBLE){var I=C+"3D",O=C+"2D";h.projectTo2D(a,C,I,O,f),i(a.boundingSphere)&&"position"===C&&(a.boundingSphereCV=e.fromVertices(a.attributes.position2D.values)),h.encodeAttribute(a,I,I+"High",I+"Low"),h.encodeAttribute(a,O,O+"High",O+"Low")}E&&h.compressVertices(a)}if(!l){var b=[];for(A=S.length,n=0;A>n;++n)a=S[n],b=b.concat(h.fitToUnsignedShortIndices(a));S=b}return S}function _(e,r,n){for(var i=[],o=e.attributes,a=n.length,u=0;a>u;++u){var s=n[u],f=o[s],l=f.componentDatatype;l===t.DOUBLE&&(l=t.FLOAT);var c=t.createTypedArray(l,f.values);i.push({index:r[s],componentDatatype:l,componentsPerAttribute:f.componentsPerAttribute,normalize:f.normalize,values:c}),delete o[s]}return i}function g(e,r,t,o,a,u,s,l,c){var h=f.computeNumberOfVertices(r);i(s[e])||(s[e]={boundingSphere:r.boundingSphere,boundingSphereCV:r.boundingSphereCV});for(var d=o.length,w=0;d>w;++w)for(var E=o[w],m=a[E],p=h;p>0;){for(var y,T=n(c[E],0),A=u[T],R=A.length,v=0;R>v&&(y=A[v],y.index!==m);++v);i(s[e][E])||(s[e][E]={dirty:!1,valid:!0,value:t[E].value,indices:[]});var _,g=y.values.length/y.componentsPerAttribute,S=n(l[E],0);g>S+p?(_=p,s[e][E].indices.push({attribute:y,offset:S,count:_}),l[E]=S+p):(_=g-S,s[e][E].indices.push({attribute:y,offset:S,count:_}),l[E]=0,c[E]=T+1),p-=_}}function S(e,r,t,n,o){var a,u,s,f=[],l=e.length,c={},h={};for(a=0;l>a;++a)u=e[a],s=u.attributes,i(u.geometry)&&g(a,u.geometry,s,o,n,t,f,c,h);for(a=0;l>a;++a)u=e[a],s=u.attributes,i(u.westHemisphereGeometry)&&g(a,u.westHemisphereGeometry,s,o,n,t,f,c,h);for(a=0;l>a;++a)u=e[a],s=u.attributes,i(u.eastHemisphereGeometry)&&g(a,u.eastHemisphereGeometry,s,o,n,t,f,c,h);for(l=r.length,a=0;l>a;++a){u=r[a],s=u.attributes;var d={};f.push(d);for(var w=o.length,E=0;w>E;++E){var m=o[E];d[m]={dirty:!1,valid:!1,value:s[m].value,indices:[]}}}return f}function C(e,r){var t=e.attributes;for(var n in t)if(t.hasOwnProperty(n)){var o=t[n];i(o)&&i(o.values)&&r.push(o.values.buffer)}i(e.indices)&&r.push(e.indices.buffer)}function N(e,r){for(var t=e.length,n=0;t>n;++n)C(e[n],r)}function I(e,r){for(var t=e.length,n=0;t>n;++n)for(var i=e[n],o=i.length,a=0;o>a;++a)r.push(i[a].values.buffer)}function O(r){for(var t=1,n=r.length,o=0;n>o;o++){var a=r[o];if(++t,i(a)){var u=a.attributes;t+=6+2*e.packedLength+(i(a.indices)?a.indices.length:0);for(var s in u)if(u.hasOwnProperty(s)&&i(u[s])){var f=u[s];t+=5+f.values.length}}}return t}function b(e,r){for(var t=e.length,n=new Uint32Array(e.length),i=0;t>i;++i)n[i]=e[i].toRgba();return r.push(n.buffer),n}function M(e){for(var t=e.length,n=new Array(t),i=0;t>i;i++)n[i]=r.fromRgba(e[i]);return n}function q(e){for(var r=e.length,t=1+17*r,n=0;r>n;n++){var o=e[n].attributes;for(var a in o)if(o.hasOwnProperty(a)&&i(o[a])){var u=o[a];t+=5+u.value.length}}return t}function L(e,r){var t=new Float64Array(q(e)),n={},o=[],a=e.length,u=0;t[u++]=a;for(var s=0;a>s;s++){var f=e[s];w.pack(f.modelMatrix,t,u),u+=w.packedLength;var l=f.attributes,c=[];for(var h in l)l.hasOwnProperty(h)&&i(l[h])&&(c.push(h),i(n[h])||(n[h]=o.length,o.push(h)));t[u++]=c.length;for(var d=0;d<c.length;d++){var E=c[d],m=l[E];t[u++]=n[E],t[u++]=m.componentDatatype,t[u++]=m.componentsPerAttribute,t[u++]=m.normalize,t[u++]=m.value.length,t.set(m.value,u),u+=m.value.length}}return r.push(t.buffer),{stringTable:o,packedData:t}}function F(e){for(var r=e.packedData,n=e.stringTable,i=new Array(r[0]),o=0,a=1;a<r.length;){var u=w.unpack(r,a);a+=w.packedLength;for(var s={},f=r[a++],l=0;f>l;l++){for(var c=n[r[a++]],h=r[a++],d=r[a++],E=0!==r[a++],m=r[a++],p=t.createTypedArray(h,m),y=0;m>y;y++)p[y]=r[a++];s[c]={componentDatatype:h,componentsPerAttribute:d,normalize:E,value:p}}i[o++]={attributes:s,modelMatrix:u}}return i}function P(r){for(var t=r.length,n=1+t,o=0;t>o;o++){var a=r[o];n+=2,n+=i(a.boundingSphere)?e.packedLength:0,n+=i(a.boundingSphereCV)?e.packedLength:0;for(var u in a)if(a.hasOwnProperty(u)&&i(a[u])&&"boundingSphere"!==u&&"boundingSphereCV"!==u){var s=a[u];n+=4+3*s.indices.length+s.value.length}}return n}function D(r,t){var n=new Float64Array(P(r)),o=[],a=[],u={},s=r.length,f=0;n[f++]=s;for(var l=0;s>l;l++){var c=r[l],h=c.boundingSphere,d=i(h);n[f++]=d?1:0,d&&(e.pack(h,n,f),f+=e.packedLength),h=c.boundingSphereCV,d=i(h),n[f++]=d?1:0,d&&(e.pack(h,n,f),f+=e.packedLength);var w=[];for(var E in c)c.hasOwnProperty(E)&&i(c[E])&&"boundingSphere"!==E&&"boundingSphereCV"!==E&&(w.push(E),i(u[E])||(u[E]=o.length,o.push(E)));n[f++]=w.length;for(var m=0;m<w.length;m++){var p=w[m],y=c[p];n[f++]=u[p],n[f++]=y.valid?1:0;var T=y.indices,A=T.length;n[f++]=A;for(var R=0;A>R;R++){var v=T[R];n[f++]=v.count,n[f++]=v.offset;var _=a.indexOf(v.attribute);-1===_&&(_=a.length,a.push(v.attribute)),n[f++]=_}n[f++]=y.value.length,n.set(y.value,f),f+=y.value.length}}return t.push(n.buffer),{stringTable:o,packedData:n,attributeTable:a}}function x(r,n){for(var i=r.stringTable,o=r.attributeTable,a=r.packedData,u=new Array(a[0]),s=0,f=1,l=a.length;l>f;){var c={},h=1===a[f++];h&&(c.boundingSphere=e.unpack(a,f),f+=e.packedLength),h=1===a[f++],h&&(c.boundingSphereCV=e.unpack(a,f),f+=e.packedLength);for(var d=a[f++],w=0;d>w;w++){for(var E=i[a[f++]],m=1===a[f++],p=a[f++],y=p>0?new Array(p):void 0,T=0;p>T;T++){var A={};A.count=a[f++],A.offset=a[f++],A.attribute=o[a[f++]],y[T]=A}for(var R=a[f++],v=m?t.createTypedArray(y[0].attribute.componentDatatype,R):new Array(R),_=0;R>_;_++)v[_]=a[f++];c[E]={dirty:!1,valid:m,indices:y,value:v}}u[s++]=c}return u}if(!u.supportsTypedArrays())return{};var U={};return U.combineGeometry=function(e){var r,t,n,o,a,u=e.instances,s=e.invalidInstances;if(u.length>0){r=v(e),t=h.createAttributeLocations(r[0]),o=T(u),n=[],a=r.length;for(var f=0;a>f;++f){var l=r[f];n.push(_(l,t,o))}}o=i(o)?o:T(s);var c=S(u,s,n,t,o);return{geometries:r,modelMatrix:e.modelMatrix,attributeLocations:t,vaAttributes:n,vaAttributeLocations:c,validInstancesIndices:e.validInstancesIndices,invalidInstancesIndices:e.invalidInstancesIndices}},U.packCreateGeometryResults=function(r,t){var n=new Float64Array(O(r)),o=[],a={},u=r.length,s=0;n[s++]=u;for(var f=0;u>f;f++){var l=r[f],c=i(l);if(n[s++]=c?1:0,c){n[s++]=l.primitiveType,n[s++]=l.geometryType;var h=i(l.boundingSphere)?1:0;n[s++]=h,h&&e.pack(l.boundingSphere,n,s),s+=e.packedLength;var d=i(l.boundingSphereCV)?1:0;n[s++]=d,d&&e.pack(l.boundingSphereCV,n,s),s+=e.packedLength;var w=l.attributes,E=[];for(var m in w)w.hasOwnProperty(m)&&i(w[m])&&(E.push(m),i(a[m])||(a[m]=o.length,o.push(m)));n[s++]=E.length;for(var p=0;p<E.length;p++){var y=E[p],T=w[y];n[s++]=a[y],n[s++]=T.componentDatatype,n[s++]=T.componentsPerAttribute,n[s++]=T.normalize?1:0,n[s++]=T.values.length,n.set(T.values,s),s+=T.values.length}var A=i(l.indices)?l.indices.length:0;n[s++]=A,A>0&&(n.set(l.indices,s),s+=A)}}return t.push(n.buffer),{stringTable:o,packedData:n}},U.unpackCreateGeometryResults=function(r){for(var n,i=r.stringTable,o=r.packedData,a=new Array(o[0]),u=0,s=1;s<o.length;){var h=1===o[s++];if(h){var w,E,m=o[s++],p=o[s++],y=1===o[s++];y&&(w=e.unpack(o,s)),s+=e.packedLength;var T=1===o[s++];T&&(E=e.unpack(o,s)),s+=e.packedLength;var A,R,v,_=new c,g=o[s++];for(n=0;g>n;n++){var S=i[o[s++]],C=o[s++];v=o[s++];var N=0!==o[s++];A=o[s++],R=t.createTypedArray(C,A);for(var I=0;A>I;I++)R[I]=o[s++];_[S]=new l({componentDatatype:C,componentsPerAttribute:v,normalize:N,values:R})}var O;if(A=o[s++],A>0){var b=R.length/v;for(O=d.createTypedArray(b,A),n=0;A>n;n++)O[n]=o[s++]}a[u++]=new f({primitiveType:m,geometryType:p,boundingSphere:w,indices:O,attributes:_})}else a[u++]=void 0}return a},U.packCombineGeometryParameters=function(e,r){for(var t=e.createGeometryResults,n=t.length,i=0;n>i;i++)r.push(t[i].packedData.buffer);var o;return e.allowPicking&&(o=b(e.pickIds,r)),{createGeometryResults:e.createGeometryResults,packedInstances:L(e.instances,r),packedPickIds:o,ellipsoid:e.ellipsoid,isGeographic:e.projection instanceof s,elementIndexUintSupported:e.elementIndexUintSupported,scene3DOnly:e.scene3DOnly,allowPicking:e.allowPicking,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:e.modelMatrix}},U.unpackCombineGeometryParameters=function(e){for(var r=F(e.packedInstances),t=e.allowPicking,n=t?M(e.packedPickIds):void 0,o=e.createGeometryResults,u=o.length,f=0,l=[],c=[],h=[],d=[],m=[],p=0;u>p;p++)for(var y=U.unpackCreateGeometryResults(o[p]),T=y.length,A=0;T>A;A++){var R=y[A],v=r[f];i(R)?(v.geometry=R,l.push(v),h.push(f),t&&m.push(n[f])):(c.push(v),d.push(f)),++f}var _=a.clone(e.ellipsoid),g=e.isGeographic?new s(_):new E(_);return{instances:l,invalidInstances:c,validInstancesIndices:h,invalidInstancesIndices:d,pickIds:m,ellipsoid:_,projection:g,elementIndexUintSupported:e.elementIndexUintSupported,scene3DOnly:e.scene3DOnly,allowPicking:e.allowPicking,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:w.clone(e.modelMatrix)}},U.packCombineGeometryResults=function(e,r){return i(e.geometries)&&(N(e.geometries,r),I(e.vaAttributes,r)),{geometries:e.geometries,attributeLocations:e.attributeLocations,vaAttributes:e.vaAttributes,packedVaAttributeLocations:D(e.vaAttributeLocations,r),modelMatrix:e.modelMatrix,validInstancesIndices:e.validInstancesIndices,invalidInstancesIndices:e.invalidInstancesIndices}},U.unpackCombineGeometryResults=function(e){return{geometries:e.geometries,attributeLocations:e.attributeLocations,vaAttributes:e.vaAttributes,perInstanceAttributeLocations:x(e.packedVaAttributeLocations,e.vaAttributes),modelMatrix:e.modelMatrix}},U}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,t,n,i){return r(e).then(t,n,i)}function r(e){var r,t;return e instanceof n?r=e:u(e)?(t=a(),e.then(function(e){t.resolve(e)},function(e){t.reject(e)},function(e){t.progress(e)}),r=t.promise):r=i(e),r}function t(r){return e(r,o)}function n(e){this.then=e}function i(e){var t=new n(function(t){try{return r(t?t(e):e)}catch(n){return o(n)}});return t}function o(e){var t=new n(function(t,n){try{return n?r(n(e)):o(e)}catch(i){return o(i)}});return t}function a(){function e(e,r,t){return h(e,r,t)}function t(e){return w(e)}function i(e){return w(o(e))}function u(e){return d(e)}var s,f,l,c,h,d,w;return f=new n(e),s={then:e,resolve:t,reject:i,progress:u,promise:f,resolver:{resolve:t,reject:i,progress:u}},l=[],c=[],h=function(e,r,t){var n,i;return n=a(),i="function"==typeof t?function(e){try{n.progress(t(e))}catch(r){n.progress(r)}}:function(e){n.progress(e)},l.push(function(t){t.then(e,r).then(n.resolve,n.reject,i)}),c.push(i),n.promise},d=function(e){return E(c,e),e},w=function(e){return e=r(e),h=e.then,w=r,d=p,E(l,e),c=l=R,e},s}function u(e){return e&&"function"==typeof e.then}function s(r,t,n,i,o){return m(2,arguments),e(r,function(r){function u(e){E(e)}function s(e){w(e)}var f,l,c,h,d,w,E,m,y,T;if(y=r.length>>>0,f=Math.max(0,Math.min(t,y)),c=[],l=y-f+1,h=[],d=a(),f)for(m=d.progress,E=function(e){h.push(e),--l||(w=E=p,d.reject(h))},w=function(e){c.push(e),--f||(w=E=p,d.resolve(c))},T=0;y>T;++T)T in r&&e(r[T],s,u,m);else d.resolve(c);return d.then(n,i,o)})}function f(e,r,t,n){function i(e){return r?r(e[0]):e[0]}return s(e,1,i,t,n)}function l(e,r,t,n){return m(1,arguments),h(e,y).then(r,t,n)}function c(){return h(arguments,y)}function h(r,t){return e(r,function(r){var n,i,o,u,s,f;if(o=i=r.length>>>0,n=[],f=a(),o)for(u=function(r,i){e(r,t).then(function(e){n[i]=e,--o||f.resolve(n)},f.reject)},s=0;i>s;s++)s in r?u(r[s],s):--o;else f.resolve(n);return f.promise})}function d(r,t){var n=A.call(arguments,1);return e(r,function(r){var i;return i=r.length,n[0]=function(r,n,o){return e(r,function(r){return e(n,function(e){return t(r,e,o,i)})})},T.apply(r,n)})}function w(r,t,n){var i=arguments.length>2;return e(r,function(e){return e=i?n:e,t.resolve(e),e},function(e){return t.reject(e),o(e)},t.progress)}function E(e,r){for(var t,n=0;t=e[n++];)t(r)}function m(e,r){for(var t,n=r.length;n>e;)if(t=r[--n],null!=t&&"function"!=typeof t)throw new Error("arg "+n+" must be a function")}function p(){}function y(e){return e}var T,A,R;return e.defer=a,e.resolve=r,e.reject=t,e.join=c,e.all=l,e.map=h,e.reduce=d,e.any=f,e.some=s,e.chain=w,e.isPromise=u,n.prototype={always:function(e,r){return this.then(e,e,r)},otherwise:function(e){return this.then(R,e)},"yield":function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(r){return l(r,function(r){return e.apply(R,r)})})}},A=[].slice,T=[].reduce||function(e){var r,t,n,i,o;if(o=0,r=Object(this),i=r.length>>>0,t=arguments,t.length<=1)for(;;){if(o in r){n=r[o++];break}if(++o>=i)throw new TypeError}else n=t[1];for(;i>o;++o)o in r&&(n=e(n,r[o],o,r));return n},e})}("function"==typeof define&&define.amd?define:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),define("Core/formatError",["./defined"],function(e){"use strict";var r=function(r){var t,n=r.name,i=r.message;t=e(n)&&e(i)?n+": "+i:r.toString();var o=r.stack;return e(o)&&(t+="\n"+o),t};return r}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined","../Core/formatError"],function(e,r,t){"use strict";var n=function(n){var i,o=[],a={id:void 0,result:void 0,error:void 0};return function(u){var s=u.data;o.length=0,a.id=s.id,a.error=void 0,a.result=void 0;try{a.result=n(s.parameters,o)}catch(f){f instanceof Error?a.error={name:f.name,message:f.message,stack:f.stack}:a.error=f}r(i)||(i=e(self.webkitPostMessage,self.postMessage)),s.canTransferArrayBuffer||(o.length=0);try{i(a,o)}catch(f){a.result=void 0,a.error="postMessage failed with error: "+t(f)+"\n  with responseMessage: "+JSON.stringify(a),i(a)}}};return n}),define("Workers/createGeometry",["../Core/defined","../Scene/PrimitivePipeline","../ThirdParty/when","./createTaskProcessorWorker","require"],function(e,r,t,n,i){"use strict";function o(r){var t=u[r];return e(t)||("object"==typeof exports?u[t]=t=i("Workers/"+r):i(["./"+r],function(e){t=e,u[t]=e})),t}function a(t,n){for(var i=t.subTasks,a=i.length,u=new Array(a),s=0;a>s;s++){var f=i[s],l=f.geometry,c=f.moduleName;if(e(c)){var h=o(c);u[s]=h(l,f.offset)}else u[s]=l}return r.packCreateGeometryResults(u,n)}var u={};return n(a)})}();