/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var r=Object.freeze;return e(r)||(r=function(e){return e}),r}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var r=function(e,r){return void 0!==e?e:r};return r.EMPTY_OBJECT=e({}),r}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var r=function(e){this.name="DeveloperError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r.throwInstantiationError=function(){throw new r("This function defines an interface and should not be called directly.")},r}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var t;for(this.mti==this.N+1&&this.init_genrand(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^r[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^r[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^r[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.signNotZero=function(e){return 0>e?-1:1},i.toSNorm=function(e){return Math.round(255*(.5*i.clamp(e,-1,1)+.5))},i.fromSNorm=function(e){return i.clamp(e,0,255)/255*2-1},i.sinh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r-t)},i.cosh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r+t)},i.lerp=function(e,r,t){return(1-t)*e+t*r},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=3*Math.PI*.5,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){if(!t(e))throw new n("degrees is required.");return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){if(!t(e))throw new n("radians is required.");return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){if(!t(e))throw new n("angle is required.");var r=i.TWO_PI,o=e-Math.floor(e/r)*r;return o<-Math.PI?o+r:o>=Math.PI?o-r:o},i.negativePiToPi=function(e){if(!t(e))throw new n("x is required.");return i.zeroToTwoPi(e+i.PI)-i.PI},i.zeroToTwoPi=function(e){if(!t(e))throw new n("x is required.");var r=i.mod(e,i.TWO_PI);return Math.abs(r)<i.EPSILON14&&Math.abs(e)>i.EPSILON14?i.TWO_PI:r},i.mod=function(e,r){if(!t(e))throw new n("m is required.");if(!t(r))throw new n("n is required.");return(e%r+r)%r},i.equalsEpsilon=function(e,i,o,a){if(!t(e))throw new n("left is required.");if(!t(i))throw new n("right is required.");if(!t(o))throw new n("relativeEpsilon is required.");a=r(a,o);var u=Math.abs(e-i);return a>=u||u<=o*Math.max(Math.abs(e),Math.abs(i))};var o=[1];i.factorial=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");var r=o.length;if(e>=r)for(var t=o[r-1],i=r;e>=i;i++)o.push(t*i);return o[e]},i.incrementWrap=function(e,i,o){if(o=r(o,0),!t(e))throw new n("n is required.");if(o>=i)throw new n("maximumValue must be greater than minimumValue.");return++e,e>i&&(e=o),e},i.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,r,i){if(!t(e))throw new n("value is required");if(!t(r))throw new n("min is required.");if(!t(i))throw new n("max is required.");return r>e?r:e>i?i:e};var a=new e;return i.setRandomNumberSeed=function(r){if(!t(r))throw new n("seed is required.");a=new e(r)},i.nextRandomNumber=function(){return a.random()},i.acosClamped=function(e){if(!t(e))throw new n("value is required.");return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){if(!t(e))throw new n("value is required.");return Math.asin(i.clamp(e,-1,1))},i.chordLength=function(e,r){if(!t(e))throw new n("angle is required.");if(!t(r))throw new n("radius is required.");return 2*r*Math.sin(.5*e)},i}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t,n){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0)};o.fromSpherical=function(n,i){if(!r(n))throw new t("spherical is required");r(i)||(i=new o);var a=n.clock,u=n.cone,s=e(n.magnitude,1),E=s*Math.sin(u);return i.x=E*Math.cos(a),i.y=E*Math.sin(a),i.z=s*Math.cos(u),i},o.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new o(e,t,n)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new o(e.x,e.y,e.z):void 0},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.x,i[o++]=n.y,i[o]=n.z},o.unpack=function(n,i,a){if(!r(n))throw new t("array is required");return i=e(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i],a},o.fromArray=o.unpack,o.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z)},o.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z)},o.minimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i},o.maximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitude(a)},o.distanceSquared=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitudeSquared(a)},o.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=o.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n},o.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z},o.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i},o.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i},o.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i},o.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i},o.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i},o.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n},o.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n};var u=new o;o.lerp=function(e,n,i,a){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(n,i,u),a=o.multiplyByScalar(e,1-i,a),o.add(u,a,a)};var s=new o,E=new o;o.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");o.normalize(e,s),o.normalize(n,E);var i=o.dot(s,E),a=o.magnitude(o.cross(s,E,s));return Math.atan2(a,i)};var f=new o;o.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=o.normalize(e,f);return o.abs(i,i),n=i.x<=i.y?i.x<=i.z?o.clone(o.UNIT_X,n):o.clone(o.UNIT_Z,n):i.y<=i.z?o.clone(o.UNIT_Y,n):o.clone(o.UNIT_Z,n)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},o.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]&&e.z===r[t+2]},o.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)&&i.equalsEpsilon(e.z,t.z,n,o)},o.cross=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");var o=e.x,a=e.y,u=e.z,s=n.x,E=n.y,f=n.z,w=a*f-u*E,c=u*s-o*f,h=o*E-a*s;return i.x=w,i.y=c,i.z=h,i},o.fromDegrees=function(e,n,a,u,s){if(!r(e))throw new t("longitude is required");if(!r(n))throw new t("latitude is required");var E=i.toRadians(e),f=i.toRadians(n);return o.fromRadians(E,f,a,u,s)};var w=new o,c=new o,h=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(n,i,a,u,s){if(!r(n))throw new t("longitude is required");if(!r(i))throw new t("latitude is required");a=e(a,0);var E=r(u)?u.radiiSquared:h,f=Math.cos(i);w.x=f*Math.cos(n),w.y=f*Math.sin(n),w.z=Math.sin(i),w=o.normalize(w,w),o.multiplyComponents(E,w,c);var d=Math.sqrt(o.dot(w,c));return c=o.divideByScalar(c,d,c),w=o.multiplyByScalar(w,a,w),r(s)||(s=new o),o.add(c,w,s)},o.fromDegreesArray=function(e,n,a){if(!r(e))throw new t("positions is required.");for(var u=new Array(e.length),s=0;s<e.length;s++)u[s]=i.toRadians(e[s]);return o.fromRadiansArray(u,n,a)},o.fromRadiansArray=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<2)throw new t("positions length cannot be less than 2.");if(e.length%2!==0)throw new t("positions length must be a multiple of 2.");var a=e.length;r(i)?i.length=a/2:i=new Array(a/2);for(var u=0;a>u;u+=2){var s=e[u],E=e[u+1];i[u/2]=o.fromRadians(s,E,0,n,i[u/2])}return i},o.fromDegreesArrayHeights=function(e,n,a){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(e.length%3!==0)throw new t("positions length must be a multiple of 3.");for(var u=new Array(e.length),s=0;s<e.length;s+=3)u[s]=i.toRadians(e[s]),u[s+1]=i.toRadians(e[s+1]),u[s+2]=e[s+2];return o.fromRadiansArrayHeights(u,n,a)},o.fromRadiansArrayHeights=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(e.length%3!==0)throw new t("positions length must be a multiple of 3.");var a=e.length;r(i)?i.length=a/3:i=new Array(a/3);for(var u=0;a>u;u+=3){var s=e[u],E=e[u+1],f=e[u+2];i[u/3]=o.fromRadians(s,E,f,n,i[u/3])}return i},o.ZERO=n(new o(0,0,0)),o.UNIT_X=n(new o(1,0,0)),o.UNIT_Y=n(new o(0,1,0)),o.UNIT_Z=n(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r,t){return o.equalsEpsilon(this,e,r,t)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t,n){this.longitude=e(r,0),this.latitude=e(t,0),this.height=e(n,0)};return o.fromRadians=function(n,i,a,u){if(!r(n))throw new t("longitude is required.");if(!r(i))throw new t("latitude is required.");return a=e(a,0),r(u)?(u.longitude=n,u.latitude=i,u.height=a,u):new o(n,i,a)},o.fromDegrees=function(e,n,a,u){if(!r(e))throw new t("longitude is required.");if(!r(n))throw new t("latitude is required.");return e=i.toRadians(e),n=i.toRadians(n),o.fromRadians(e,n,a,u)},o.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new o(e.longitude,e.latitude,e.height):void 0},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},o.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.longitude-n.longitude)<=i&&Math.abs(e.latitude-n.latitude)<=i&&Math.abs(e.height-n.height)<=i},o.ZERO=n(new o(0,0,0)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r){return o.equalsEpsilon(this,e,r)},o.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},o}),define("Core/deprecationWarning",["./defined","./DeveloperError"],function(e,r){"use strict";var t={},n=function(n,i){if(!e(n)||!e(i))throw new r("identifier and message are required.");e(t[n])||(t[n]=!0,console.log(i))};return n}),define("Core/defineProperties",["./defined"],function(e){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),t=Object.defineProperties;return r&&e(t)||(t=function(e){return e}),t}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,o,a,u){"use strict";function s(r,n,i,a){if(n=t(n,0),i=t(i,0),a=t(a,0),0>n||0>i||0>a)throw new o("All radii components must be greater than or equal to zero.");r._radii=new e(n,i,a),r._radiiSquared=new e(n*n,i*i,a*a),r._radiiToTheFourth=new e(n*n*n*n,i*i*i*i,a*a*a*a),r._oneOverRadii=new e(0===n?0:1/n,0===i?0:1/i,0===a?0:1/a),r._oneOverRadiiSquared=new e(0===n?0:1/(n*n),0===i?0:1/(i*i),0===a?0:1/(a*a)),r._minimumRadius=Math.min(n,i,a),r._maximumRadius=Math.max(n,i,a),r._centerToleranceSquared=u.EPSILON1}var E=function(e,r,t){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,s(this,e,r,t)};i(E.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),E.clone=function(r,t){if(!n(r))return void 0;var i=r._radii;return n(t)?(e.clone(i,t._radii),e.clone(r._radiiSquared,t._radiiSquared),e.clone(r._radiiToTheFourth,t._radiiToTheFourth),e.clone(r._oneOverRadii,t._oneOverRadii),e.clone(r._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=r._minimumRadius,t._maximumRadius=r._maximumRadius,t._centerToleranceSquared=r._centerToleranceSquared,t):new E(i.x,i.y,i.z)},E.fromCartesian3=function(e,r){return n(r)||(r=new E),n(e)?(s(r,e.x,e.y,e.z),r):r},E.WGS84=a(new E(6378137,6378137,6356752.314245179)),E.UNIT_SPHERE=a(new E(1,1,1)),E.MOON=a(new E(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),E.prototype.clone=function(e){return E.clone(this,e)},E.packedLength=e.packedLength,E.pack=function(r,i,a){if(!n(r))throw new o("value is required");if(!n(i))throw new o("array is required");a=t(a,0),e.pack(r._radii,i,a)},E.unpack=function(r,i,a){if(!n(r))throw new o("array is required");i=t(i,0);var u=e.unpack(r,i);return E.fromCartesian3(u,a)},E.prototype.geocentricSurfaceNormal=e.normalize,E.prototype.geodeticSurfaceNormalCartographic=function(r,t){if(!n(r))throw new o("cartographic is required.");var i=r.longitude,a=r.latitude,u=Math.cos(a),s=u*Math.cos(i),E=u*Math.sin(i),f=Math.sin(a);return n(t)||(t=new e),t.x=s,t.y=E,t.z=f,e.normalize(t,t)},E.prototype.geodeticSurfaceNormal=function(r,t){return n(t)||(t=new e),t=e.multiplyComponents(r,this._oneOverRadiiSquared,t),e.normalize(t,t)};var f=new e,w=new e;E.prototype.cartographicToCartesian=function(r,t){var i=f,o=w;this.geodeticSurfaceNormalCartographic(r,i),e.multiplyComponents(this._radiiSquared,i,o);var a=Math.sqrt(e.dot(i,o));return e.divideByScalar(o,a,o),e.multiplyByScalar(i,r.height,i),n(t)||(t=new e),e.add(o,i,t)},E.prototype.cartographicArrayToCartesianArray=function(e,r){if(!n(e))throw new o("cartographics is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;i++)r[i]=this.cartographicToCartesian(e[i],r[i]);return r};var c=new e,h=new e,d=new e;E.prototype.cartesianToCartographic=function(t,i){var o=this.scaleToGeodeticSurface(t,h);if(!n(o))return void 0;var a=this.geodeticSurfaceNormal(o,c),s=e.subtract(t,o,d),E=Math.atan2(a.y,a.x),f=Math.asin(a.z),w=u.sign(e.dot(s,t))*e.magnitude(s);return n(i)?(i.longitude=E,i.latitude=f,i.height=w,i):new r(E,f,w)},E.prototype.cartesianArrayToCartographicArray=function(e,r){if(!n(e))throw new o("cartesians is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;++i)r[i]=this.cartesianToCartographic(e[i],r[i]);return r};var l=new e,_=new e;return E.prototype.scaleToGeodeticSurface=function(r,t){if(!n(r))throw new o("cartesian is required.");var i=r.x,a=r.y,s=r.z,E=this._oneOverRadii,f=E.x,w=E.y,c=E.z,h=i*i*f*f,d=a*a*w*w,R=s*s*c*c,T=h+d+R,A=Math.sqrt(1/T),m=e.multiplyByScalar(r,A,l);if(T<this._centerToleranceSquared)return isFinite(A)?e.clone(m,t):void 0;var N=this._oneOverRadiiSquared,I=N.x,S=N.y,y=N.z,O=_;O.x=m.x*I*2,O.y=m.y*S*2,O.z=m.z*y*2;var p,M,q,C,U,L,P,F,v,g,x,D=(1-A)*e.magnitude(r)/(.5*e.magnitude(O)),B=0;do{D-=B,q=1/(1+D*I),C=1/(1+D*S),U=1/(1+D*y),L=q*q,P=C*C,F=U*U,v=L*q,g=P*C,x=F*U,p=h*L+d*P+R*F-1,M=h*v*I+d*g*S+R*x*y;var b=-2*M;B=p/b}while(Math.abs(p)>u.EPSILON12);return n(t)?(t.x=i*q,t.y=a*C,t.z=s*U,t):new e(i*q,a*C,s*U)},E.prototype.scaleToGeocentricSurface=function(r,t){if(!n(r))throw new o("cartesian is required.");n(t)||(t=new e);var i=r.x,a=r.y,u=r.z,s=this._oneOverRadiiSquared,E=1/Math.sqrt(i*i*s.x+a*a*s.y+u*u*s.z);return e.multiplyByScalar(r,E,t)},E.prototype.transformPositionToScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._oneOverRadii,t)},E.prototype.transformPositionFromScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._radii,t)},E.prototype.equals=function(r){return this===r||n(r)&&e.equals(this._radii,r._radii)},E.prototype.toString=function(){return this._radii.toString()},E}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,r,t,n,i,o,a){"use strict";var u=function(e){this._ellipsoid=t(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(r,t){var i=this._semimajorAxis,o=r.longitude*i,a=r.latitude*i,u=r.height;return n(t)?(t.x=o,t.y=a,t.z=u,t):new e(o,a,u)},u.prototype.unproject=function(e,t){if(!n(e))throw new o("cartesian is required");var i=this._oneOverSemimajorAxis,a=e.x*i,u=e.y*i,s=e.z;return n(t)?(t.longitude=a,t.latitude=u,t.height=s,t):new r(a,u,s)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var r={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(r)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var r=function(r,t){this.start=e(r,0),this.stop=e(t,0)};return r}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t,n,i){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0),this.w=e(i,0)};o.fromElements=function(e,t,n,i,a){return r(a)?(a.x=e,a.y=t,a.z=n,a.w=i,a):new o(e,t,n,i)},o.fromColor=function(e,n){if(!r(e))throw new t("color is required");return r(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new o(e.red,e.green,e.blue,e.alpha)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new o(e.x,e.y,e.z,e.w):void 0},o.packedLength=4,o.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.x,i[o++]=n.y,i[o++]=n.z,i[o]=n.w},o.unpack=function(n,i,a){if(!r(n))throw new t("array is required");return i=e(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i++],a.w=n[i],a},o.fromArray=o.unpack,o.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z,e.w)},o.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z,e.w)},o.minimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i.w=Math.min(e.w,n.w),i},o.maximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i.w=Math.max(e.w,n.w),i},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitude(a)},o.distanceSquared=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitudeSquared(a)},o.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=o.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n.w=e.w/i,n},o.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z+e.w*n.w},o.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i.w=e.w*n.w,i},o.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i.w=e.w+n.w,i},o.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i.w=e.w-n.w,i},o.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i.w=e.w*n,i},o.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i.w=e.w/n,i},o.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n.w=-e.w,n},o.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n.w=Math.abs(e.w),n};var u=new o;o.lerp=function(e,n,i,a){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(n,i,u),a=o.multiplyByScalar(e,1-i,a),o.add(u,a,a)};var s=new o;return o.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=o.normalize(e,s);return o.abs(i,i),n=i.x<=i.y?i.x<=i.z?i.x<=i.w?o.clone(o.UNIT_X,n):o.clone(o.UNIT_W,n):i.z<=i.w?o.clone(o.UNIT_Z,n):o.clone(o.UNIT_W,n):i.y<=i.z?i.y<=i.w?o.clone(o.UNIT_Y,n):o.clone(o.UNIT_W,n):i.z<=i.w?o.clone(o.UNIT_Z,n):o.clone(o.UNIT_W,n)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},o.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]&&e.z===r[t+2]&&e.w===r[t+3]},o.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)&&i.equalsEpsilon(e.z,t.z,n,o)&&i.equalsEpsilon(e.w,t.w,n,o)},o.ZERO=n(new o(0,0,0,0)),o.UNIT_X=n(new o(1,0,0,0)),o.UNIT_Y=n(new o(0,1,0,0)),o.UNIT_Z=n(new o(0,0,1,0)),o.UNIT_W=n(new o(0,0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r,t){return o.equalsEpsilon(this,e,r,t)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},o}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,o){"use strict";function a(e){for(var r=0,t=0;9>t;++t){var n=e[t];r+=n*n}return Math.sqrt(r)}function u(e){for(var r=0,t=0;3>t;++t){var n=e[E.getElementIndex(h[t],c[t])];r+=2*n*n}return Math.sqrt(r)}function s(e,r){for(var t=o.EPSILON15,n=0,i=1,a=0;3>a;++a){var u=Math.abs(e[E.getElementIndex(h[a],c[a])]);u>n&&(i=a,n=u)}var s=1,f=0,w=c[i],d=h[i];if(Math.abs(e[E.getElementIndex(d,w)])>t){var l,_=e[E.getElementIndex(d,d)],R=e[E.getElementIndex(w,w)],T=e[E.getElementIndex(d,w)],A=(_-R)/2/T;l=0>A?-1/(-A+Math.sqrt(1+A*A)):1/(A+Math.sqrt(1+A*A)),s=1/Math.sqrt(1+l*l),f=l*s}return r=E.clone(E.IDENTITY,r),r[E.getElementIndex(w,w)]=r[E.getElementIndex(d,d)]=s,r[E.getElementIndex(d,w)]=f,r[E.getElementIndex(w,d)]=-f,r}var E=function(e,t,n,i,o,a,u,s,E){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(o,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(a,0),this[8]=r(E,0)};E.packedLength=9,E.pack=function(e,i,o){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");o=r(o,0),i[o++]=e[0],i[o++]=e[1],i[o++]=e[2],i[o++]=e[3],i[o++]=e[4],i[o++]=e[5],i[o++]=e[6],i[o++]=e[7],i[o++]=e[8]},E.unpack=function(e,i,o){if(!t(e))throw new n("array is required");return i=r(i,0),t(o)||(o=new E),o[0]=e[i++],o[1]=e[i++],o[2]=e[i++],o[3]=e[i++],o[4]=e[i++],o[5]=e[i++],o[6]=e[i++],o[7]=e[i++],o[8]=e[i++],o},E.clone=function(e,r){return t(e)?t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):new E(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},E.fromArray=function(e,i,o){if(!t(e))throw new n("array is required");return i=r(i,0),t(o)||(o=new E),o[0]=e[i],o[1]=e[i+1],o[2]=e[i+2],o[3]=e[i+3],o[4]=e[i+4],o[5]=e[i+5],o[6]=e[i+6],o[7]=e[i+7],o[8]=e[i+8],o},E.fromColumnMajorArray=function(e,r){if(!t(e))throw new n("values parameter is required");return E.clone(e,r)},E.fromRowMajorArray=function(e,r){if(!t(e))throw new n("values is required.");return t(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new E(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},E.fromQuaternion=function(e,r){if(!t(e))throw new n("quaternion is required");var i=e.x*e.x,o=e.x*e.y,a=e.x*e.z,u=e.x*e.w,s=e.y*e.y,f=e.y*e.z,w=e.y*e.w,c=e.z*e.z,h=e.z*e.w,d=e.w*e.w,l=i-s-c+d,_=2*(o-h),R=2*(a+w),T=2*(o+h),A=-i+s-c+d,m=2*(f-u),N=2*(a-w),I=2*(f+u),S=-i-s+c+d;return t(r)?(r[0]=l,r[1]=T,r[2]=N,r[3]=_,r[4]=A,r[5]=I,r[6]=R,r[7]=m,r[8]=S,r):new E(l,_,R,T,A,m,N,I,S)},E.fromScale=function(e,r){if(!t(e))throw new n("scale is required.");return t(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new E(e.x,0,0,0,e.y,0,0,0,e.z)},E.fromUniformScale=function(e,r){if("number"!=typeof e)throw new n("scale is required.");return t(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new E(e,0,0,0,e,0,0,0,e)},E.fromCrossProduct=function(e,r){if(!t(e))throw new n("vector is required.");return t(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new E(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},E.fromRotationX=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=o,r[6]=0,r[7]=-o,r[8]=i,r):new E(1,0,0,0,i,-o,0,o,i)},E.fromRotationY=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=i,r[1]=0,r[2]=-o,r[3]=0,r[4]=1,r[5]=0,r[6]=o,r[7]=0,r[8]=i,r):new E(i,0,o,0,1,0,-o,0,i)},E.fromRotationZ=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=i,r[1]=o,r[2]=0,r[3]=-o,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new E(i,-o,0,o,i,0,0,0,1)},E.toArray=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},E.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>2)throw new n("row must be 0, 1, or 2.");if("number"!=typeof e||0>e||e>2)throw new n("column must be 0, 1, or 2.");return 3*e+r},E.getColumn=function(e,r,i){if(!t(e))throw new n("matrix is required.");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(i))throw new n("result is required");var o=3*r,a=e[o],u=e[o+1],s=e[o+2];return i.x=a,i.y=u,i.z=s,i},E.setColumn=function(e,r,i,o){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(o))throw new n("result is required");o=E.clone(e,o);var a=3*r;return o[a]=i.x,o[a+1]=i.y,o[a+2]=i.z,o},E.getRow=function(e,r,i){if(!t(e))throw new n("matrix is required.");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(i))throw new n("result is required");var o=e[r],a=e[r+3],u=e[r+6];
return i.x=o,i.y=a,i.z=u,i},E.setRow=function(e,r,i,o){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(o))throw new n("result is required");return o=E.clone(e,o),o[r]=i.x,o[r+3]=i.y,o[r+6]=i.z,o};var f=new e;E.getScale=function(r,i){if(!t(r))throw new n("matrix is required.");if(!t(i))throw new n("result is required");return i.x=e.magnitude(e.fromElements(r[0],r[1],r[2],f)),i.y=e.magnitude(e.fromElements(r[3],r[4],r[5],f)),i.z=e.magnitude(e.fromElements(r[6],r[7],r[8],f)),i};var w=new e;E.getMaximumScale=function(r){return E.getScale(r,w),e.maximumComponent(w)},E.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");var o=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],a=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],u=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],s=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],E=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],f=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],w=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],c=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],h=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return i[0]=o,i[1]=a,i[2]=u,i[3]=s,i[4]=E,i[5]=f,i[6]=w,i[7]=c,i[8]=h,i},E.add=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i[0]=e[0]+r[0],i[1]=e[1]+r[1],i[2]=e[2]+r[2],i[3]=e[3]+r[3],i[4]=e[4]+r[4],i[5]=e[5]+r[5],i[6]=e[6]+r[6],i[7]=e[7]+r[7],i[8]=e[8]+r[8],i},E.subtract=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],i[3]=e[3]-r[3],i[4]=e[4]-r[4],i[5]=e[5]-r[5],i[6]=e[6]-r[6],i[7]=e[7]-r[7],i[8]=e[8]-r[8],i},E.multiplyByVector=function(e,r,i){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("cartesian is required");if(!t(i))throw new n("result is required");var o=r.x,a=r.y,u=r.z,s=e[0]*o+e[3]*a+e[6]*u,E=e[1]*o+e[4]*a+e[7]*u,f=e[2]*o+e[5]*a+e[8]*u;return i.x=s,i.y=E,i.z=f,i},E.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scalar must be a number");if(!t(i))throw new n("result is required");return i[0]=e[0]*r,i[1]=e[1]*r,i[2]=e[2]*r,i[3]=e[3]*r,i[4]=e[4]*r,i[5]=e[5]*r,i[6]=e[6]*r,i[7]=e[7]*r,i[8]=e[8]*r,i},E.multiplyByScale=function(e,r,i){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("scale is required");if(!t(i))throw new n("result is required");return i[0]=e[0]*r.x,i[1]=e[1]*r.x,i[2]=e[2]*r.x,i[3]=e[3]*r.y,i[4]=e[4]*r.y,i[5]=e[5]*r.y,i[6]=e[6]*r.z,i[7]=e[7]*r.z,i[8]=e[8]*r.z,i},E.negate=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");return r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},E.transpose=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");var i=e[0],o=e[3],a=e[6],u=e[1],s=e[4],E=e[7],f=e[2],w=e[5],c=e[8];return r[0]=i,r[1]=o,r[2]=a,r[3]=u,r[4]=s,r[5]=E,r[6]=f,r[7]=w,r[8]=c,r};var c=[1,0,0],h=[2,2,1],d=new E,l=new E;return E.computeEigenDecomposition=function(e,r){if(!t(e))throw new n("matrix is required.");var i=o.EPSILON20,f=10,w=0,c=0;t(r)||(r={});for(var h=r.unitary=E.clone(E.IDENTITY,r.unitary),_=r.diagonal=E.clone(e,r.diagonal),R=i*a(_);f>c&&u(_)>R;)s(_,d),E.transpose(d,l),E.multiply(_,d,_),E.multiply(l,_,_),E.multiply(h,d,h),++w>2&&(++c,w=0);return r},E.abs=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");return r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},E.determinant=function(e){if(!t(e))throw new n("matrix is required");var r=e[0],i=e[3],o=e[6],a=e[1],u=e[4],s=e[7],E=e[2],f=e[5],w=e[8];return r*(u*w-f*s)+a*(f*o-i*w)+E*(i*s-u*o)},E.inverse=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");var i=e[0],a=e[1],u=e[2],s=e[3],f=e[4],w=e[5],c=e[6],h=e[7],d=e[8],l=E.determinant(e);if(Math.abs(l)<=o.EPSILON15)throw new n("matrix is not invertible");r[0]=f*d-h*w,r[1]=h*u-a*d,r[2]=a*w-f*u,r[3]=c*w-s*d,r[4]=i*d-c*u,r[5]=s*u-i*w,r[6]=s*h-c*f,r[7]=c*a-i*h,r[8]=i*f-s*a;var _=1/l;return E.multiplyByScalar(r,_,r)},E.equals=function(e,r){return e===r||t(e)&&t(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]},E.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon must be a number");return e===r||t(e)&&t(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},E.IDENTITY=i(new E(1,0,0,0,1,0,0,0,1)),E.ZERO=i(new E(0,0,0,0,0,0,0,0,0)),E.COLUMN0ROW0=0,E.COLUMN0ROW1=1,E.COLUMN0ROW2=2,E.COLUMN1ROW0=3,E.COLUMN1ROW1=4,E.COLUMN1ROW2=5,E.COLUMN2ROW0=6,E.COLUMN2ROW1=7,E.COLUMN2ROW2=8,E.prototype.clone=function(e){return E.clone(this,e)},E.prototype.equals=function(e){return E.equals(this,e)},E.equalsArray=function(e,r,t){return e[0]===r[t]&&e[1]===r[t+1]&&e[2]===r[t+2]&&e[3]===r[t+3]&&e[4]===r[t+4]&&e[5]===r[t+5]&&e[6]===r[t+6]&&e[7]===r[t+7]&&e[8]===r[t+8]},E.prototype.equalsEpsilon=function(e,r){return E.equalsEpsilon(this,e,r)},E.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},E}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var r=function(e){this.name="RuntimeError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,r,t,n,i,o,a,u,s){"use strict";var E=function(e,r,n,i,o,a,u,s,E,f,w,c,h,d,l,_){this[0]=t(e,0),this[1]=t(o,0),this[2]=t(E,0),this[3]=t(h,0),this[4]=t(r,0),this[5]=t(a,0),this[6]=t(f,0),this[7]=t(d,0),this[8]=t(n,0),this[9]=t(u,0),this[10]=t(w,0),this[11]=t(l,0),this[12]=t(i,0),this[13]=t(s,0),this[14]=t(c,0),this[15]=t(_,0)};E.packedLength=16,E.pack=function(e,r,o){if(!n(e))throw new i("value is required");if(!n(r))throw new i("array is required");o=t(o,0),r[o++]=e[0],r[o++]=e[1],r[o++]=e[2],r[o++]=e[3],r[o++]=e[4],r[o++]=e[5],r[o++]=e[6],r[o++]=e[7],r[o++]=e[8],r[o++]=e[9],r[o++]=e[10],r[o++]=e[11],r[o++]=e[12],r[o++]=e[13],r[o++]=e[14],r[o]=e[15]},E.unpack=function(e,r,o){if(!n(e))throw new i("array is required");return r=t(r,0),n(o)||(o=new E),o[0]=e[r++],o[1]=e[r++],o[2]=e[r++],o[3]=e[r++],o[4]=e[r++],o[5]=e[r++],o[6]=e[r++],o[7]=e[r++],o[8]=e[r++],o[9]=e[r++],o[10]=e[r++],o[11]=e[r++],o[12]=e[r++],o[13]=e[r++],o[14]=e[r++],o[15]=e[r],o},E.clone=function(e,r){return n(e)?n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):new E(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},E.fromArray=E.unpack,E.fromColumnMajorArray=function(e,r){if(!n(e))throw new i("values is required");return E.clone(e,r)},E.fromRowMajorArray=function(e,r){if(!n(e))throw new i("values is required.");return n(r)?(r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=e[1],r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=e[2],r[9]=e[6],r[10]=e[10],r[11]=e[14],r[12]=e[3],r[13]=e[7],r[14]=e[11],r[15]=e[15],r):new E(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},E.fromRotationTranslation=function(r,o,a){if(!n(r))throw new i("rotation is required.");return o=t(o,e.ZERO),n(a)?(a[0]=r[0],a[1]=r[1],a[2]=r[2],a[3]=0,a[4]=r[3],a[5]=r[4],a[6]=r[5],a[7]=0,a[8]=r[6],a[9]=r[7],a[10]=r[8],a[11]=0,a[12]=o.x,a[13]=o.y,a[14]=o.z,a[15]=1,a):new E(r[0],r[3],r[6],o.x,r[1],r[4],r[7],o.y,r[2],r[5],r[8],o.z,0,0,0,1)},E.fromTranslationQuaternionRotationScale=function(e,r,t,o){if(!n(e))throw new i("translation is required.");if(!n(r))throw new i("rotation is required.");if(!n(t))throw new i("scale is required.");n(o)||(o=new E);var a=t.x,u=t.y,s=t.z,f=r.x*r.x,w=r.x*r.y,c=r.x*r.z,h=r.x*r.w,d=r.y*r.y,l=r.y*r.z,_=r.y*r.w,R=r.z*r.z,T=r.z*r.w,A=r.w*r.w,m=f-d-R+A,N=2*(w-T),I=2*(c+_),S=2*(w+T),y=-f+d-R+A,O=2*(l-h),p=2*(c-_),M=2*(l+h),q=-f-d+R+A;return o[0]=m*a,o[1]=S*a,o[2]=p*a,o[3]=0,o[4]=N*u,o[5]=y*u,o[6]=M*u,o[7]=0,o[8]=I*s,o[9]=O*s,o[10]=q*s,o[11]=0,o[12]=e.x,o[13]=e.y,o[14]=e.z,o[15]=1,o},E.fromTranslation=function(e,r){if(!n(e))throw new i("translation is required.");return E.fromRotationTranslation(u.IDENTITY,e,r)},E.fromScale=function(e,r){if(!n(e))throw new i("scale is required.");return n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e.y,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e.z,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new E(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},E.fromUniformScale=function(e,r){if("number"!=typeof e)throw new i("scale is required.");return n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new E(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var f=new e,w=new e,c=new e;E.fromCamera=function(r,t){if(!n(r))throw new i("camera is required.");var o=r.eye,a=r.target,u=r.up;if(!n(o))throw new i("camera.eye is required.");if(!n(a))throw new i("camera.target is required.");if(!n(u))throw new i("camera.up is required.");e.normalize(e.subtract(a,o,f),f),e.normalize(e.cross(f,u,w),w),e.normalize(e.cross(w,f,c),c);var s=w.x,h=w.y,d=w.z,l=f.x,_=f.y,R=f.z,T=c.x,A=c.y,m=c.z,N=o.x,I=o.y,S=o.z,y=s*-N+h*-I+d*-S,O=T*-N+A*-I+m*-S,p=l*N+_*I+R*S;return n(t)?(t[0]=s,t[1]=T,t[2]=-l,t[3]=0,t[4]=h,t[5]=A,t[6]=-_,t[7]=0,t[8]=d,t[9]=m,t[10]=-R,t[11]=0,t[12]=y,t[13]=O,t[14]=p,t[15]=1,t):new E(s,h,d,y,T,A,m,O,-l,-_,-R,p,0,0,0,1)},E.computePerspectiveFieldOfView=function(e,r,t,o,a){if(0>=e||e>Math.PI)throw new i("fovY must be in [0, PI).");if(0>=r)throw new i("aspectRatio must be greater than zero.");if(0>=t)throw new i("near must be greater than zero.");if(0>=o)throw new i("far must be greater than zero.");if(!n(a))throw new i("result is required");var u=Math.tan(.5*e),s=1/u,E=s/r,f=(o+t)/(t-o),w=2*o*t/(t-o);return a[0]=E,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=s,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=f,a[11]=-1,a[12]=0,a[13]=0,a[14]=w,a[15]=0,a},E.computeOrthographicOffCenter=function(e,r,t,o,a,u,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(o))throw new i("top is required.");if(!n(a))throw new i("near is required.");if(!n(u))throw new i("far is required.");if(!n(s))throw new i("result is required");var E=1/(r-e),f=1/(o-t),w=1/(u-a),c=-(r+e)*E,h=-(o+t)*f,d=-(u+a)*w;return E*=2,f*=2,w*=-2,s[0]=E,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=f,s[6]=0,s[7]=0,s[8]=0,s[9]=0,s[10]=w,s[11]=0,s[12]=c,s[13]=h,s[14]=d,s[15]=1,s},E.computePerspectiveOffCenter=function(e,r,t,o,a,u,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(o))throw new i("top is required.");if(!n(a))throw new i("near is required.");if(!n(u))throw new i("far is required.");if(!n(s))throw new i("result is required");var E=2*a/(r-e),f=2*a/(o-t),w=(r+e)/(r-e),c=(o+t)/(o-t),h=-(u+a)/(u-a),d=-1,l=-2*u*a/(u-a);return s[0]=E,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=f,s[6]=0,s[7]=0,s[8]=w,s[9]=c,s[10]=h,s[11]=d,s[12]=0,s[13]=0,s[14]=l,s[15]=0,s},E.computeInfinitePerspectiveOffCenter=function(e,r,t,o,a,u){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(o))throw new i("top is required.");if(!n(a))throw new i("near is required.");if(!n(u))throw new i("result is required");var s=2*a/(r-e),E=2*a/(o-t),f=(r+e)/(r-e),w=(o+t)/(o-t),c=-1,h=-1,d=-2*a;return u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=E,u[6]=0,u[7]=0,u[8]=f,u[9]=w,u[10]=c,u[11]=h,u[12]=0,u[13]=0,u[14]=d,u[15]=0,u},E.computeViewportTransformation=function(e,r,o,a){if(!n(a))throw new i("result is required");e=t(e,t.EMPTY_OBJECT);var u=t(e.x,0),s=t(e.y,0),E=t(e.width,0),f=t(e.height,0);r=t(r,0),o=t(o,1);var w=.5*E,c=.5*f,h=.5*(o-r),d=w,l=c,_=h,R=u+w,T=s+c,A=r+h,m=1;return a[0]=d,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=l,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=_,a[11]=0,a[12]=R,a[13]=T,a[14]=A,a[15]=m,a},E.toArray=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},E.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>3)throw new i("row must be 0, 1, 2, or 3.");if("number"!=typeof e||0>e||e>3)throw new i("column must be 0, 1, 2, or 3.");return 4*e+r},E.getColumn=function(e,r,t){if(!n(e))throw new i("matrix is required.");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(t))throw new i("result is required");var o=4*r,a=e[o],u=e[o+1],s=e[o+2],E=e[o+3];return t.x=a,t.y=u,t.z=s,t.w=E,t},E.setColumn=function(e,r,t,o){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(o))throw new i("result is required");o=E.clone(e,o);var a=4*r;return o[a]=t.x,o[a+1]=t.y,o[a+2]=t.z,o[a+3]=t.w,o},E.setTranslation=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("translation is required");if(!n(t))throw new i("result is required");return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=r.x,t[13]=r.y,t[14]=r.z,t[15]=e[15],t},E.getRow=function(e,r,t){if(!n(e))throw new i("matrix is required.");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(t))throw new i("result is required");var o=e[r],a=e[r+4],u=e[r+8],s=e[r+12];return t.x=o,t.y=a,t.z=u,t.w=s,t},E.setRow=function(e,r,t,o){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(o))throw new i("result is required");return o=E.clone(e,o),o[r]=t.x,o[r+4]=t.y,o[r+8]=t.z,o[r+12]=t.w,o};var h=new e;E.getScale=function(r,t){if(!n(r))throw new i("matrix is required.");if(!n(t))throw new i("result is required");return t.x=e.magnitude(e.fromElements(r[0],r[1],r[2],h)),t.y=e.magnitude(e.fromElements(r[4],r[5],r[6],h)),t.z=e.magnitude(e.fromElements(r[8],r[9],r[10],h)),t};var d=new e;E.getMaximumScale=function(r){return E.getScale(r,d),e.maximumComponent(d)},E.multiply=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");var o=e[0],a=e[1],u=e[2],s=e[3],E=e[4],f=e[5],w=e[6],c=e[7],h=e[8],d=e[9],l=e[10],_=e[11],R=e[12],T=e[13],A=e[14],m=e[15],N=r[0],I=r[1],S=r[2],y=r[3],O=r[4],p=r[5],M=r[6],q=r[7],C=r[8],U=r[9],L=r[10],P=r[11],F=r[12],v=r[13],g=r[14],x=r[15],D=o*N+E*I+h*S+R*y,B=a*N+f*I+d*S+T*y,b=u*N+w*I+l*S+A*y,z=s*N+c*I+_*S+m*y,G=o*O+E*p+h*M+R*q,X=a*O+f*p+d*M+T*q,V=u*O+w*p+l*M+A*q,H=s*O+c*p+_*M+m*q,W=o*C+E*U+h*L+R*P,Y=a*C+f*U+d*L+T*P,K=u*C+w*U+l*L+A*P,k=s*C+c*U+_*L+m*P,Z=o*F+E*v+h*g+R*x,j=a*F+f*v+d*g+T*x,Q=u*F+w*v+l*g+A*x,J=s*F+c*v+_*g+m*x;return t[0]=D,t[1]=B,t[2]=b,t[3]=z,t[4]=G,t[5]=X,t[6]=V,t[7]=H,t[8]=W,t[9]=Y,t[10]=K,t[11]=k,t[12]=Z,t[13]=j,t[14]=Q,t[15]=J,t},E.add=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t[6]=e[6]+r[6],t[7]=e[7]+r[7],t[8]=e[8]+r[8],t[9]=e[9]+r[9],t[10]=e[10]+r[10],t[11]=e[11]+r[11],t[12]=e[12]+r[12],t[13]=e[13]+r[13],t[14]=e[14]+r[14],t[15]=e[15]+r[15],t},E.subtract=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t[4]=e[4]-r[4],t[5]=e[5]-r[5],t[6]=e[6]-r[6],t[7]=e[7]-r[7],t[8]=e[8]-r[8],t[9]=e[9]-r[9],t[10]=e[10]-r[10],t[11]=e[11]-r[11],t[12]=e[12]-r[12],t[13]=e[13]-r[13],t[14]=e[14]-r[14],t[15]=e[15]-r[15],t},E.multiplyTransformation=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");var o=e[0],a=e[1],u=e[2],s=e[4],E=e[5],f=e[6],w=e[8],c=e[9],h=e[10],d=e[12],l=e[13],_=e[14],R=r[0],T=r[1],A=r[2],m=r[4],N=r[5],I=r[6],S=r[8],y=r[9],O=r[10],p=r[12],M=r[13],q=r[14],C=o*R+s*T+w*A,U=a*R+E*T+c*A,L=u*R+f*T+h*A,P=o*m+s*N+w*I,F=a*m+E*N+c*I,v=u*m+f*N+h*I,g=o*S+s*y+w*O,x=a*S+E*y+c*O,D=u*S+f*y+h*O,B=o*p+s*M+w*q+d,b=a*p+E*M+c*q+l,z=u*p+f*M+h*q+_;return t[0]=C,t[1]=U,t[2]=L,t[3]=0,t[4]=P,t[5]=F,t[6]=v,t[7]=0,t[8]=g,t[9]=x,t[10]=D,t[11]=0,t[12]=B,t[13]=b,t[14]=z,t[15]=1,t},E.multiplyByMatrix3=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("rotation is required");if(!n(t))throw new i("result is required");var o=e[0],a=e[1],u=e[2],s=e[4],E=e[5],f=e[6],w=e[8],c=e[9],h=e[10],d=r[0],l=r[1],_=r[2],R=r[3],T=r[4],A=r[5],m=r[6],N=r[7],I=r[8],S=o*d+s*l+w*_,y=a*d+E*l+c*_,O=u*d+f*l+h*_,p=o*R+s*T+w*A,M=a*R+E*T+c*A,q=u*R+f*T+h*A,C=o*m+s*N+w*I,U=a*m+E*N+c*I,L=u*m+f*N+h*I;return t[0]=S,t[1]=y,t[2]=O,t[3]=0,t[4]=p,t[5]=M,t[6]=q,t[7]=0,t[8]=C,t[9]=U,t[10]=L,t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},E.multiplyByTranslation=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("translation is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,u=r.z,s=o*e[0]+a*e[4]+u*e[8]+e[12],E=o*e[1]+a*e[5]+u*e[9]+e[13],f=o*e[2]+a*e[6]+u*e[10]+e[14];return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=s,t[13]=E,t[14]=f,t[15]=e[15],t};var l=new e;E.multiplyByUniformScale=function(e,r,t){if(!n(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scale is required");if(!n(t))throw new i("result is required");return l.x=r,l.y=r,l.z=r,E.multiplyByScale(e,l,t)},E.multiplyByScale=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("scale is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,u=r.z;return 1===o&&1===a&&1===u?E.clone(e,t):(t[0]=o*e[0],t[1]=o*e[1],t[2]=o*e[2],t[3]=0,t[4]=a*e[4],t[5]=a*e[5],t[6]=a*e[6],t[7]=0,t[8]=u*e[8],t[9]=u*e[9],t[10]=u*e[10],t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=1,t)},E.multiplyByVector=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,u=r.z,s=r.w,E=e[0]*o+e[4]*a+e[8]*u+e[12]*s,f=e[1]*o+e[5]*a+e[9]*u+e[13]*s,w=e[2]*o+e[6]*a+e[10]*u+e[14]*s,c=e[3]*o+e[7]*a+e[11]*u+e[15]*s;return t.x=E,t.y=f,t.z=w,t.w=c,t},E.multiplyByPointAsVector=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,u=r.z,s=e[0]*o+e[4]*a+e[8]*u,E=e[1]*o+e[5]*a+e[9]*u,f=e[2]*o+e[6]*a+e[10]*u;return t.x=s,t.y=E,t.z=f,t},E.multiplyByPoint=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,u=r.z,s=e[0]*o+e[4]*a+e[8]*u+e[12],E=e[1]*o+e[5]*a+e[9]*u+e[13],f=e[2]*o+e[6]*a+e[10]*u+e[14];return t.x=s,t.y=E,t.z=f,t},E.multiplyByScalar=function(e,r,t){if(!n(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scalar must be a number");if(!n(t))throw new i("result is required");return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t},E.negate=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r[9]=-e[9],r[10]=-e[10],r[11]=-e[11],r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=-e[15],r},E.transpose=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");var t=e[1],o=e[2],a=e[3],u=e[6],s=e[7],E=e[11];return r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=t,r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=o,r[9]=u,r[10]=e[10],r[11]=e[14],r[12]=a,r[13]=s,r[14]=E,r[15]=e[15],r},E.abs=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r[9]=Math.abs(e[9]),r[10]=Math.abs(e[10]),r[11]=Math.abs(e[11]),r[12]=Math.abs(e[12]),r[13]=Math.abs(e[13]),r[14]=Math.abs(e[14]),r[15]=Math.abs(e[15]),r},E.equals=function(e,r){return e===r||n(e)&&n(r)&&e[12]===r[12]&&e[13]===r[13]&&e[14]===r[14]&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[8]===r[8]&&e[9]===r[9]&&e[10]===r[10]&&e[3]===r[3]&&e[7]===r[7]&&e[11]===r[11]&&e[15]===r[15]},E.equalsEpsilon=function(e,r,t){if("number"!=typeof t)throw new i("epsilon must be a number");return e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=t&&Math.abs(e[1]-r[1])<=t&&Math.abs(e[2]-r[2])<=t&&Math.abs(e[3]-r[3])<=t&&Math.abs(e[4]-r[4])<=t&&Math.abs(e[5]-r[5])<=t&&Math.abs(e[6]-r[6])<=t&&Math.abs(e[7]-r[7])<=t&&Math.abs(e[8]-r[8])<=t&&Math.abs(e[9]-r[9])<=t&&Math.abs(e[10]-r[10])<=t&&Math.abs(e[11]-r[11])<=t&&Math.abs(e[12]-r[12])<=t&&Math.abs(e[13]-r[13])<=t&&Math.abs(e[14]-r[14])<=t&&Math.abs(e[15]-r[15])<=t},E.getTranslation=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r.x=e[12],r.y=e[13],r.z=e[14],r},E.getRotation=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[4],r[4]=e[5],r[5]=e[6],r[6]=e[8],r[7]=e[9],r[8]=e[10],r};var _=new u,R=new u,T=new r,A=new r(0,0,0,1);return E.inverse=function(e,t){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("result is required");if(u.equalsEpsilon(E.getRotation(e,_),R,a.EPSILON7)&&r.equals(E.getRow(e,3,T),A))return t[0]=0,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=0,t[11]=0,t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=1,t;var o=e[0],f=e[4],w=e[8],c=e[12],h=e[1],d=e[5],l=e[9],m=e[13],N=e[2],I=e[6],S=e[10],y=e[14],O=e[3],p=e[7],M=e[11],q=e[15],C=S*q,U=y*M,L=I*q,P=y*p,F=I*M,v=S*p,g=N*q,x=y*O,D=N*M,B=S*O,b=N*p,z=I*O,G=C*d+P*l+F*m-(U*d+L*l+v*m),X=U*h+g*l+B*m-(C*h+x*l+D*m),V=L*h+x*d+b*m-(P*h+g*d+z*m),H=v*h+D*d+z*l-(F*h+B*d+b*l),W=U*f+L*w+v*c-(C*f+P*w+F*c),Y=C*o+x*w+D*c-(U*o+g*w+B*c),K=P*o+g*f+z*c-(L*o+x*f+b*c),k=F*o+B*f+b*w-(v*o+D*f+z*w);C=w*m,U=c*l,L=f*m,P=c*d,F=f*l,v=w*d,g=o*m,x=c*h,D=o*l,B=w*h,b=o*d,z=f*h;var Z=C*p+P*M+F*q-(U*p+L*M+v*q),j=U*O+g*M+B*q-(C*O+x*M+D*q),Q=L*O+x*p+b*q-(P*O+g*p+z*q),J=v*O+D*p+z*M-(F*O+B*p+b*M),$=L*S+v*y+U*I-(F*y+C*I+P*S),ee=D*y+C*N+x*S-(g*S+B*y+U*N),re=g*I+z*y+P*N-(b*y+L*N+x*I),te=b*S+F*N+B*I-(D*I+z*S+v*N),ne=o*G+f*X+w*V+c*H;if(Math.abs(ne)<a.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return ne=1/ne,t[0]=G*ne,t[1]=X*ne,t[2]=V*ne,t[3]=H*ne,t[4]=W*ne,t[5]=Y*ne,t[6]=K*ne,t[7]=k*ne,t[8]=Z*ne,t[9]=j*ne,t[10]=Q*ne,t[11]=J*ne,t[12]=$*ne,t[13]=ee*ne,t[14]=re*ne,t[15]=te*ne,t},E.inverseTransformation=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");var t=e[0],o=e[1],a=e[2],u=e[4],s=e[5],E=e[6],f=e[8],w=e[9],c=e[10],h=e[12],d=e[13],l=e[14],_=-t*h-o*d-a*l,R=-u*h-s*d-E*l,T=-f*h-w*d-c*l;return r[0]=t,r[1]=u,r[2]=f,r[3]=0,r[4]=o,r[5]=s,r[6]=w,r[7]=0,r[8]=a,r[9]=E,r[10]=c,r[11]=0,r[12]=_,r[13]=R,r[14]=T,r[15]=1,r},E.IDENTITY=o(new E(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),E.ZERO=o(new E(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),E.COLUMN0ROW0=0,E.COLUMN0ROW1=1,E.COLUMN0ROW2=2,E.COLUMN0ROW3=3,E.COLUMN1ROW0=4,E.COLUMN1ROW1=5,E.COLUMN1ROW2=6,E.COLUMN1ROW3=7,E.COLUMN2ROW0=8,E.COLUMN2ROW1=9,E.COLUMN2ROW2=10,E.COLUMN2ROW3=11,E.COLUMN3ROW0=12,E.COLUMN3ROW1=13,E.COLUMN3ROW2=14,E.COLUMN3ROW3=15,E.prototype.clone=function(e){return E.clone(this,e)},E.prototype.equals=function(e){return E.equals(this,e)},E.equalsArray=function(e,r,t){return e[0]===r[t]&&e[1]===r[t+1]&&e[2]===r[t+2]&&e[3]===r[t+3]&&e[4]===r[t+4]&&e[5]===r[t+5]&&e[6]===r[t+6]&&e[7]===r[t+7]&&e[8]===r[t+8]&&e[9]===r[t+9]&&e[10]===r[t+10]&&e[11]===r[t+11]&&e[12]===r[t+12]&&e[13]===r[t+13]&&e[14]===r[t+14]&&e[15]===r[t+15]},E.prototype.equalsEpsilon=function(e,r){return E.equalsEpsilon(this,e,r)},E.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},E}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,r,t,n){"use strict";var i=function(n,i){if(!r(n))throw new t("normal is required.");if(!r(i))throw new t("distance is required.");this.normal=e.clone(n),this.distance=i};i.fromPointNormal=function(n,o,a){if(!r(n))throw new t("point is required.");if(!r(o))throw new t("normal is required.");var u=-e.dot(o,n);return r(a)?(e.clone(o,a.normal),a.distance=u,a):new i(o,u)};var o=new e;return i.fromCartesian4=function(n,a){if(!r(n))throw new t("coefficients is required.");var u=e.fromCartesian4(n,o),s=n.w;return r(a)?(e.clone(u,a.normal),a.distance=s,a):new i(u,s)},i.getPointDistance=function(n,i){if(!r(n))throw new t("plane is required.");if(!r(i))throw new t("point is required.");return e.dot(n.normal,i)+n.distance},i.ORIGIN_XY_PLANE=n(new i(e.UNIT_Z,0)),i.ORIGIN_YZ_PLANE=n(new i(e.UNIT_X,0)),i.ORIGIN_ZX_PLANE=n(new i(e.UNIT_Y,0)),i}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,r,t,n,i,o,a,u){"use strict";var s=function(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)};n(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,o){if(!t(e))throw new i("value is required");if(!t(n))throw new i("array is required");o=r(o,0),n[o++]=e.west,n[o++]=e.south,n[o++]=e.east,n[o]=e.north},s.unpack=function(e,n,o){if(!t(e))throw new i("array is required");return n=r(n,0),t(o)||(o=new s),o.west=e[n++],o.south=e[n++],o.east=e[n++],o.north=e[n],o},s.computeWidth=function(e){if(!t(e))throw new i("rectangle is required.");var r=e.east,n=e.west;return n>r&&(r+=u.TWO_PI),r-n},s.computeHeight=function(e){if(!t(e))throw new i("rectangle is required.");return e.north-e.south},s.fromDegrees=function(e,n,i,o,a){return e=u.toRadians(r(e,0)),n=u.toRadians(r(n,0)),i=u.toRadians(r(i,0)),o=u.toRadians(r(o,0)),t(a)?(a.west=e,a.south=n,a.east=i,a.north=o,a):new s(e,n,i,o)},s.fromCartographicArray=function(e,r){if(!t(e))throw new i("cartographics is required.");for(var n=Number.MAX_VALUE,o=-Number.MAX_VALUE,a=Number.MAX_VALUE,u=-Number.MAX_VALUE,E=0,f=e.length;f>E;E++){var w=e[E];n=Math.min(n,w.longitude),o=Math.max(o,w.longitude),a=Math.min(a,w.latitude),u=Math.max(u,w.latitude)}return t(r)?(r.west=n,r.south=a,r.east=o,r.north=u,r):new s(n,a,o,u)},s.clone=function(e,r){return t(e)?t(r)?(r.west=e.west,r.south=e.south,r.east=e.east,r.north=e.north,r):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.west===r.west&&e.south===r.south&&e.east===r.east&&e.north===r.north},s.prototype.equalsEpsilon=function(e,r){if("number"!=typeof r)throw new i("epsilon is required and must be a number.");return t(e)&&Math.abs(this.west-e.west)<=r&&Math.abs(this.south-e.south)<=r&&Math.abs(this.east-e.east)<=r&&Math.abs(this.north-e.north)<=r},s.validate=function(e){if(!t(e))throw new i("rectangle is required");var r=e.north;if("number"!=typeof r)throw new i("north is required to be a number.");if(r<-u.PI_OVER_TWO||r>u.PI_OVER_TWO)throw new i("north must be in the interval [-Pi/2, Pi/2].");var n=e.south;if("number"!=typeof n)throw new i("south is required to be a number.");if(n<-u.PI_OVER_TWO||n>u.PI_OVER_TWO)throw new i("south must be in the interval [-Pi/2, Pi/2].");var o=e.west;if("number"!=typeof o)throw new i("west is required to be a number.");if(o<-Math.PI||o>Math.PI)throw new i("west must be in the interval [-Pi, Pi].");var a=e.east;if("number"!=typeof a)throw new i("east is required to be a number.");if(a<-Math.PI||a>Math.PI)throw new i("east must be in the interval [-Pi, Pi].")},s.southwest=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.west,n.latitude=r.south,n.height=0,n):new e(r.west,r.south)},s.northwest=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.west,n.latitude=r.north,n.height=0,n):new e(r.west,r.north)},s.northeast=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.east,n.latitude=r.north,n.height=0,n):new e(r.east,r.north)},s.southeast=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.east,n.latitude=r.south,n.height=0,n):new e(r.east,r.south)},s.center=function(r,n){if(!t(r))throw new i("rectangle is required");var o=r.east,a=r.west;a>o&&(o+=u.TWO_PI);var s=u.negativePiToPi(.5*(a+o)),E=.5*(r.south+r.north);return t(n)?(n.longitude=s,n.latitude=E,n.height=0,n):new e(s,E)},s.intersection=function(e,r,n){if(!t(e))throw new i("rectangle is required");if(!t(r))throw new i("otherRectangle is required.");var o=e.east,a=e.west,E=r.east,f=r.west;a>o&&E>0?o+=u.TWO_PI:f>E&&o>0&&(E+=u.TWO_PI),a>o&&0>f?f+=u.TWO_PI:f>E&&0>a&&(a+=u.TWO_PI);var w=u.negativePiToPi(Math.max(a,f)),c=u.negativePiToPi(Math.min(o,E));if((e.west<e.east||r.west<r.east)&&w>=c)return void 0;var h=Math.max(e.south,r.south),d=Math.min(e.north,r.north);return h>=d?void 0:t(n)?(n.west=w,n.south=h,n.east=c,n.north=d,n):new s(w,h,c,d)},s.contains=function(e,r){if(!t(e))throw new i("rectangle is required");if(!t(r))throw new i("cartographic is required.");var n=r.longitude,o=r.latitude,a=e.west,s=e.east;return a>s&&(s+=u.TWO_PI,0>n&&(n+=u.TWO_PI)),(n>a||u.equalsEpsilon(n,a,u.EPSILON14))&&(s>n||u.equalsEpsilon(n,s,u.EPSILON14))&&o>=e.south&&o<=e.north};var E=new e;return s.subsample=function(e,n,a,f){if(!t(e))throw new i("rectangle is required");n=r(n,o.WGS84),a=r(a,0),t(f)||(f=[]);var w=0,c=e.north,h=e.south,d=e.east,l=e.west,_=E;_.height=a,_.longitude=l,_.latitude=c,f[w]=n.cartographicToCartesian(_,f[w]),w++,_.longitude=d,f[w]=n.cartographicToCartesian(_,f[w]),w++,_.latitude=h,f[w]=n.cartographicToCartesian(_,f[w]),w++,_.longitude=l,f[w]=n.cartographicToCartesian(_,f[w]),w++,0>c?_.latitude=c:h>0?_.latitude=h:_.latitude=0;for(var R=1;8>R;++R)_.longitude=-Math.PI+R*u.PI_OVER_TWO,s.contains(e,_)&&(f[w]=n.cartographicToCartesian(_,f[w]),w++);return 0===_.latitude&&(_.longitude=l,f[w]=n.cartographicToCartesian(_,f[w]),w++,_.longitude=d,f[w]=n.cartographicToCartesian(_,f[w]),w++),f.length=w,f},s.MAX_VALUE=a(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Plane","./Rectangle"],function(e,r,t,n,i,o,a,u,s,E,f,w,c){
"use strict";var h=function(r,n){this.center=e.clone(t(r,e.ZERO)),this.radius=t(n,0)},d=new e,l=new e,_=new e,R=new e,T=new e,A=new e,m=new e,N=new e,I=new e,S=new e,y=new e,O=new e;h.fromPoints=function(r,t){if(n(t)||(t=new h),!n(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;for(var i=e.clone(r[0],m),o=e.clone(i,d),a=e.clone(i,l),u=e.clone(i,_),s=e.clone(i,R),E=e.clone(i,T),f=e.clone(i,A),w=r.length,c=1;w>c;c++){e.clone(r[c],i);var p=i.x,M=i.y,q=i.z;p<o.x&&e.clone(i,o),p>s.x&&e.clone(i,s),M<a.y&&e.clone(i,a),M>E.y&&e.clone(i,E),q<u.z&&e.clone(i,u),q>f.z&&e.clone(i,f)}var C=e.magnitudeSquared(e.subtract(s,o,N)),U=e.magnitudeSquared(e.subtract(E,a,N)),L=e.magnitudeSquared(e.subtract(f,u,N)),P=o,F=s,v=C;U>v&&(v=U,P=a,F=E),L>v&&(v=L,P=u,F=f);var g=I;g.x=.5*(P.x+F.x),g.y=.5*(P.y+F.y),g.z=.5*(P.z+F.z);var x=e.magnitudeSquared(e.subtract(F,g,N)),D=Math.sqrt(x),B=S;B.x=o.x,B.y=a.y,B.z=u.z;var b=y;b.x=s.x,b.y=E.y,b.z=f.z;var z=e.multiplyByScalar(e.add(B,b,N),.5,O),G=0;for(c=0;w>c;c++){e.clone(r[c],i);var X=e.magnitude(e.subtract(i,z,N));X>G&&(G=X);var V=e.magnitudeSquared(e.subtract(i,g,N));if(V>x){var H=Math.sqrt(V);D=.5*(D+H),x=D*D;var W=H-D;g.x=(D*g.x+W*i.x)/H,g.y=(D*g.y+W*i.y)/H,g.z=(D*g.z+W*i.z)/H}}return G>D?(e.clone(g,t.center),t.radius=D):(e.clone(z,t.center),t.radius=G),t};var p=new u,M=new e,q=new e,C=new r,U=new r;h.fromRectangle2D=function(e,r,t){return h.fromRectangleWithHeights2D(e,r,0,0,t)},h.fromRectangleWithHeights2D=function(r,i,o,a,u){if(n(u)||(u=new h),!n(r))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;i=t(i,p),c.southwest(r,C),C.height=o,c.northeast(r,U),U.height=a;var s=i.project(C,M),E=i.project(U,q),f=E.x-s.x,w=E.y-s.y,d=E.z-s.z;u.radius=.5*Math.sqrt(f*f+w*w+d*d);var l=u.center;return l.x=s.x+.5*f,l.y=s.y+.5*w,l.z=s.z+.5*d,u};var L=[];h.fromRectangle3D=function(e,r,i,o){r=t(r,a.WGS84),i=t(i,0);var u;return n(e)&&(u=c.subsample(e,r,i,L)),h.fromPoints(u,o)},h.fromVertices=function(r,i,a,u){if(n(u)||(u=new h),!n(r)||0===r.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;if(i=t(i,e.ZERO),a=t(a,3),3>a)throw new o("stride must be 3 or greater.");var s=m;s.x=r[0]+i.x,s.y=r[1]+i.y,s.z=r[2]+i.z;for(var E=e.clone(s,d),f=e.clone(s,l),w=e.clone(s,_),c=e.clone(s,R),p=e.clone(s,T),M=e.clone(s,A),q=r.length,C=0;q>C;C+=a){var U=r[C]+i.x,L=r[C+1]+i.y,P=r[C+2]+i.z;s.x=U,s.y=L,s.z=P,U<E.x&&e.clone(s,E),U>c.x&&e.clone(s,c),L<f.y&&e.clone(s,f),L>p.y&&e.clone(s,p),P<w.z&&e.clone(s,w),P>M.z&&e.clone(s,M)}var F=e.magnitudeSquared(e.subtract(c,E,N)),v=e.magnitudeSquared(e.subtract(p,f,N)),g=e.magnitudeSquared(e.subtract(M,w,N)),x=E,D=c,B=F;v>B&&(B=v,x=f,D=p),g>B&&(B=g,x=w,D=M);var b=I;b.x=.5*(x.x+D.x),b.y=.5*(x.y+D.y),b.z=.5*(x.z+D.z);var z=e.magnitudeSquared(e.subtract(D,b,N)),G=Math.sqrt(z),X=S;X.x=E.x,X.y=f.y,X.z=w.z;var V=y;V.x=c.x,V.y=p.y,V.z=M.z;var H=e.multiplyByScalar(e.add(X,V,N),.5,O),W=0;for(C=0;q>C;C+=a){s.x=r[C]+i.x,s.y=r[C+1]+i.y,s.z=r[C+2]+i.z;var Y=e.magnitude(e.subtract(s,H,N));Y>W&&(W=Y);var K=e.magnitudeSquared(e.subtract(s,b,N));if(K>z){var k=Math.sqrt(K);G=.5*(G+k),z=G*G;var Z=k-G;b.x=(G*b.x+Z*s.x)/k,b.y=(G*b.y+Z*s.y)/k,b.z=(G*b.z+Z*s.z)/k}}return W>G?(e.clone(b,u.center),u.radius=G):(e.clone(H,u.center),u.radius=W),u},h.fromCornerPoints=function(r,t,i){if(!n(r)||!n(t))throw new o("corner and oppositeCorner are required.");n(i)||(i=new h);var a=i.center;return e.add(r,t,a),e.multiplyByScalar(a,.5,a),i.radius=e.distance(a,t),i},h.fromEllipsoid=function(r,t){if(!n(r))throw new o("ellipsoid is required.");return n(t)||(t=new h),e.clone(e.ZERO,t.center),t.radius=r.maximumRadius,t};var P=new e;h.fromBoundingSpheres=function(r,t){if(n(t)||(t=new h),!n(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;var i=r.length;if(1===i)return h.clone(r[0],t);if(2===i)return h.union(r[0],r[1],t);for(var o=[],a=0;i>a;a++)o.push(r[a].center);t=h.fromPoints(o,t);var u=t.center,s=t.radius;for(a=0;i>a;a++){var E=r[a];s=Math.max(s,e.distance(u,E.center,P)+E.radius)}return t.radius=s,t},h.clone=function(r,t){return n(r)?n(t)?(t.center=e.clone(r.center,t.center),t.radius=r.radius,t):new h(r.center,r.radius):void 0},h.packedLength=4,h.pack=function(e,r,i){if(!n(e))throw new o("value is required");if(!n(r))throw new o("array is required");i=t(i,0);var a=e.center;r[i++]=a.x,r[i++]=a.y,r[i++]=a.z,r[i]=e.radius},h.unpack=function(e,r,i){if(!n(e))throw new o("array is required");r=t(r,0),n(i)||(i=new h);var a=i.center;return a.x=e[r++],a.y=e[r++],a.z=e[r++],i.radius=e[r],i};var F=new e,v=new e;h.union=function(r,t,i){if(!n(r))throw new o("left is required.");if(!n(t))throw new o("right is required.");n(i)||(i=new h);var a=r.center,u=r.radius,s=t.center,E=t.radius,f=e.subtract(s,a,F),w=e.magnitude(f);if(u>=w+E)return r.clone(i),i;if(E>=w+u)return t.clone(i),i;var c=.5*(u+w+E),d=e.multiplyByScalar(f,(-u+c)/w,v);return e.add(d,a,d),e.clone(d,i.center),i.radius=c,i};var g=new e;h.expand=function(r,t,i){if(!n(r))throw new o("sphere is required.");if(!n(t))throw new o("point is required.");i=h.clone(r,i);var a=e.magnitude(e.subtract(t,i.center,g));return a>i.radius&&(i.radius=a),i},h.intersectPlane=function(r,t){if(!n(r))throw new o("sphere is required.");if(!n(t))throw new o("plane is required.");var i=r.center,a=r.radius,u=t.normal,E=e.dot(u,i)+t.distance;return-a>E?s.OUTSIDE:a>E?s.INTERSECTING:s.INSIDE},h.transform=function(e,r,t){if(!n(e))throw new o("sphere is required.");if(!n(r))throw new o("transform is required.");return n(t)||(t=new h),t.center=f.multiplyByPoint(r,e.center,t.center),t.radius=f.getMaximumScale(r)*e.radius,t};var x=new e;h.distanceSquaredTo=function(r,t){if(!n(r))throw new o("sphere is required.");if(!n(t))throw new o("cartesian is required.");var i=e.subtract(r.center,t,x);return e.magnitudeSquared(i)-r.radius*r.radius},h.transformWithoutScale=function(e,r,t){if(!n(e))throw new o("sphere is required.");if(!n(r))throw new o("transform is required.");return n(t)||(t=new h),t.center=f.multiplyByPoint(r,e.center,t.center),t.radius=e.radius,t};var D=new e;h.computePlaneDistances=function(r,t,i,a){if(!n(r))throw new o("sphere is required.");if(!n(t))throw new o("position is required.");if(!n(i))throw new o("direction is required.");n(a)||(a=new E);var u=e.subtract(r.center,t,D),s=e.dot(i,u);return a.start=s-r.radius,a.stop=s+r.radius,a};for(var B=new e,b=new e,z=new e,G=new e,X=new e,V=new r,H=new Array(8),W=0;8>W;++W)H[W]=new e;var Y=new u;return h.projectTo2D=function(r,i,a){if(!n(r))throw new o("sphere is required.");i=t(i,Y);var u=i.ellipsoid,s=r.center,E=r.radius,f=u.geodeticSurfaceNormal(s,B),w=e.cross(e.UNIT_Z,f,b);e.normalize(w,w);var c=e.cross(f,w,z);e.normalize(c,c),e.multiplyByScalar(f,E,f),e.multiplyByScalar(c,E,c),e.multiplyByScalar(w,E,w);var d=e.negate(c,X),l=e.negate(w,G),_=H,R=_[0];e.add(f,c,R),e.add(R,w,R),R=_[1],e.add(f,c,R),e.add(R,l,R),R=_[2],e.add(f,d,R),e.add(R,l,R),R=_[3],e.add(f,d,R),e.add(R,w,R),e.negate(f,f),R=_[4],e.add(f,c,R),e.add(R,w,R),R=_[5],e.add(f,c,R),e.add(R,l,R),R=_[6],e.add(f,d,R),e.add(R,l,R),R=_[7],e.add(f,d,R),e.add(R,w,R);for(var T=_.length,A=0;T>A;++A){var m=_[A];e.add(s,m,m);var N=u.cartesianToCartographic(m,V);i.project(N,m)}a=h.fromPoints(_,a),s=a.center;var I=s.x,S=s.y,y=s.z;return s.x=y,s.y=I,s.z=S,a},h.isOccluded=function(e,r){if(!n(e))throw new o("sphere is required.");if(!n(r))throw new o("occluder is required.");return!r.isBoundingSphereVisible(e)},h.equals=function(r,t){return r===t||n(r)&&n(t)&&e.equals(r.center,t.center)&&r.radius===t.radius},h.prototype.intersectPlane=function(e){return h.intersectPlane(this,e)},h.prototype.distanceSquaredTo=function(e){return h.distanceSquaredTo(this,e)},h.prototype.computePlaneDistances=function(e,r,t){return h.computePlaneDistances(this,e,r,t)},h.prototype.isOccluded=function(e){return h.isOccluded(this,e)},h.prototype.equals=function(e){return h.equals(this,e)},h.prototype.clone=function(e){return h.clone(this,e)},h}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t){this.x=e(r,0),this.y=e(t,0)};o.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new o(e,t)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t):new o(e.x,e.y):void 0},o.fromCartesian3=o.clone,o.fromCartesian4=o.clone,o.packedLength=2,o.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.x,i[o]=n.y},o.unpack=function(n,i,a){if(!r(n))throw new t("array is required");return i=e(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i],a},o.fromArray=o.unpack,o.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y)},o.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y)},o.minimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i},o.maximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitude(a)},o.distanceSquared=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitudeSquared(a)},o.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=o.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n},o.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y},o.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i},o.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i},o.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i},o.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i},o.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i},o.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n},o.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n};var u=new o;o.lerp=function(e,n,i,a){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(n,i,u),a=o.multiplyByScalar(e,1-i,a),o.add(u,a,a)};var s=new o,E=new o;o.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return o.normalize(e,s),o.normalize(n,E),i.acosClamped(o.dot(s,E))};var f=new o;return o.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=o.normalize(e,f);return o.abs(i,i),n=i.x<=i.y?o.clone(o.UNIT_X,n):o.clone(o.UNIT_Y,n)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},o.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]},o.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)},o.ZERO=n(new o(0,0)),o.UNIT_X=n(new o(1,0)),o.UNIT_Y=n(new o(0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r,t){return o.equalsEpsilon(this,e,r,t)},o.prototype.toString=function(){return"("+this.x+", "+this.y+")"},o}),define("Renderer/WebGLConstants",["../Core/freezeObject"],function(e){"use strict";var r={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return e(r)}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,r){"use strict";var t,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return r(i,{element:{get:function(){return i.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(t))return t;t=!1;var r=document.body;if("function"==typeof r.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",t=!0;for(var i,o=["webkit","moz","o","ms","khtml"],a=0,u=o.length;u>a;++a){var s=o[a];i=s+"RequestFullscreen","function"==typeof r[i]?(n.requestFullscreen=i,t=!0):(i=s+"RequestFullScreen","function"==typeof r[i]&&(n.requestFullscreen=i,t=!0)),i=s+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=s+"FullscreenEnabled",e(document[i])?n.fullscreenEnabled=i:(i=s+"FullScreenEnabled",e(document[i])&&(n.fullscreenEnabled=i)),i=s+"FullscreenElement",e(document[i])?n.fullscreenElement=i:(i=s+"FullScreenElement",e(document[i])&&(n.fullscreenElement=i)),i=s+"fullscreenchange",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=s+"fullscreenerror",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenError"),n.fullscreenerror=i)}return t},i.requestFullscreen=function(e){i.supportsFullscreen()&&e[n.requestFullscreen]()},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,r,t){"use strict";function n(e){for(var r=e.split("."),t=0,n=r.length;n>t;++t)r[t]=parseInt(r[t],10);return r}function i(){if(!r(_)){_=!1;var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(_=!0,R=n(e[1]))}return _}function o(){return i()&&R}function a(){if(!r(T)&&(T=!1,!i()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(T=!0,A=n(e[1]))}return T}function u(){return a()&&A}function s(){if(!r(m)){m=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==e&&(m=!0,N=n(e[1]),N.isNightly=!!e[2])}return m}function E(){return s()&&N}function f(){if(!r(I)){I=!1;var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(I=!0,S=n(e[1]))):"Netscape"===navigator.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(I=!0,S=n(e[1])))}return I}function w(){return f()&&S}function c(){if(!r(y)){y=!1;var e=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(y=!0,O=n(e[1]))}return y}function h(){return r(p)||(p=/Windows/i.test(navigator.appVersion)),p}function d(){return c()&&O}function l(){return r(M)||(M=r(window.PointerEvent)&&(!r(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),M}var _,R,T,A,m,N,I,S,y,O,p,M,q={isChrome:i,chromeVersion:o,isSafari:a,safariVersion:u,isWebkit:s,webkitVersion:E,isInternetExplorer:f,internetExplorerVersion:w,isFirefox:c,firefoxVersion:d,isWindows:h,hardwareConcurrency:e(navigator.hardwareConcurrency,3),supportsPointerEvents:l};return q.supportsFullscreen=function(){return t.supportsFullscreen()},q.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},q.supportsWebWorkers=function(){return"undefined"!=typeof Worker},q}),define("Core/ComponentDatatype",["../Renderer/WebGLConstants","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,r,t,n,i,o){"use strict";if(!i.supportsTypedArrays())return{};var a={BYTE:e.BYTE,UNSIGNED_BYTE:e.UNSIGNED_BYTE,SHORT:e.SHORT,UNSIGNED_SHORT:e.UNSIGNED_SHORT,FLOAT:e.FLOAT,DOUBLE:e.DOUBLE};return a.getSizeInBytes=function(e){if(!t(e))throw new n("value is required.");switch(e){case a.BYTE:return Int8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.SHORT:return Int16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case a.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new n("componentDatatype is not a valid value.")}},a.fromTypedArray=function(e){return e instanceof Int8Array?a.BYTE:e instanceof Uint8Array?a.UNSIGNED_BYTE:e instanceof Int16Array?a.SHORT:e instanceof Uint16Array?a.UNSIGNED_SHORT:e instanceof Float32Array?a.FLOAT:e instanceof Float64Array?a.DOUBLE:void 0},a.validate=function(e){return t(e)&&(e===a.BYTE||e===a.UNSIGNED_BYTE||e===a.SHORT||e===a.UNSIGNED_SHORT||e===a.FLOAT||e===a.DOUBLE)},a.createTypedArray=function(e,r){if(!t(e))throw new n("componentDatatype is required.");if(!t(r))throw new n("valuesOrLength is required.");switch(e){case a.BYTE:return new Int8Array(r);case a.UNSIGNED_BYTE:return new Uint8Array(r);case a.SHORT:return new Int16Array(r);case a.UNSIGNED_SHORT:return new Uint16Array(r);case a.FLOAT:return new Float32Array(r);case a.DOUBLE:return new Float64Array(r);default:throw new n("componentDatatype is not a valid value.")}},a.createArrayBufferView=function(e,i,o,u){if(!t(e))throw new n("componentDatatype is required.");if(!t(i))throw new n("buffer is required.");switch(o=r(o,0),u=r(u,(i.byteLength-o)/a.getSizeInBytes(e)),e){case a.BYTE:return new Int8Array(i,o,u);case a.UNSIGNED_BYTE:return new Uint8Array(i,o,u);case a.SHORT:return new Int16Array(i,o,u);case a.UNSIGNED_SHORT:return new Uint16Array(i,o,u);case a.FLOAT:return new Float32Array(i,o,u);case a.DOUBLE:return new Float64Array(i,o,u);default:throw new n("componentDatatype is not a valid value.")}},o(a)}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var r={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(r)}),define("Core/PrimitiveType",["../Renderer/WebGLConstants","./freezeObject"],function(e,r){
"use strict";var t={POINTS:e.POINTS,LINES:e.LINES,LINE_LOOP:e.LINE_LOOP,LINE_STRIP:e.LINE_STRIP,TRIANGLES:e.TRIANGLES,TRIANGLE_STRIP:e.TRIANGLE_STRIP,TRIANGLE_FAN:e.TRIANGLE_FAN,validate:function(e){return e===t.POINTS||e===t.LINES||e===t.LINE_LOOP||e===t.LINE_STRIP||e===t.TRIANGLES||e===t.TRIANGLE_STRIP||e===t.TRIANGLE_FAN}};return r(t)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,r,t,n,i){"use strict";var o=function(o){if(o=e(o,e.EMPTY_OBJECT),!r(o.attributes))throw new t("options.attributes is required.");this.attributes=o.attributes,this.indices=o.indices,this.primitiveType=e(o.primitiveType,i.TRIANGLES),this.boundingSphere=o.boundingSphere,this.geometryType=e(o.geometryType,n.NONE),this.boundingSphereCV=void 0};return o.computeNumberOfVertices=function(e){if(!r(e))throw new t("geometry is required.");var n=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&r(e.attributes[i])&&r(e.attributes[i].values)){var o=e.attributes[i],a=o.values.length/o.componentsPerAttribute;if(n!==a&&-1!==n)throw new t("All attribute lists must have the same number of attributes.");n=a}return n},o}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.componentDatatype))throw new t("options.componentDatatype is required.");if(!r(n.componentsPerAttribute))throw new t("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new t("options.componentsPerAttribute must be between 1 and 4.");if(!r(n.values))throw new t("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values};return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var r=function(r){r=e(r,e.EMPTY_OBJECT),this.position=r.position,this.normal=r.normal,this.st=r.st,this.binormal=r.binormal,this.tangent=r.tangent,this.color=r.color};return r}),define("Core/IndexDatatype",["../Renderer/WebGLConstants","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o={UNSIGNED_BYTE:e.UNSIGNED_BYTE,UNSIGNED_SHORT:e.UNSIGNED_SHORT,UNSIGNED_INT:e.UNSIGNED_INT};return o.getSizeInBytes=function(e){switch(e){case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},o.validate=function(e){return r(e)&&(e===o.UNSIGNED_BYTE||e===o.UNSIGNED_SHORT||e===o.UNSIGNED_INT)},o.createTypedArray=function(e,n){if(!r(e))throw new t("numberOfVertices is required.");return e>=i.SIXTY_FOUR_KILOBYTES?new Uint32Array(n):new Uint16Array(n)},o.createTypedArrayFromArrayBuffer=function(e,n,o,a){if(!r(e))throw new t("numberOfVertices is required.");if(!r(n))throw new t("sourceArray is required.");if(!r(o))throw new t("byteOffset is required.");return e>=i.SIXTY_FOUR_KILOBYTES?new Uint32Array(n,o,a):new Uint16Array(n,o,a)},n(o)}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,r,t,n){"use strict";var i=function(r){r=e(r,e.EMPTY_OBJECT),this.position=e(r.position,!1),this.normal=e(r.normal,!1),this.st=e(r.st,!1),this.binormal=e(r.binormal,!1),this.tangent=e(r.tangent,!1),this.color=e(r.color,!1)};return i.POSITION_ONLY=n(new i({position:!0})),i.POSITION_AND_NORMAL=n(new i({position:!0,normal:!0})),i.POSITION_NORMAL_AND_ST=n(new i({position:!0,normal:!0,st:!0})),i.POSITION_AND_ST=n(new i({position:!0,st:!0})),i.POSITION_AND_COLOR=n(new i({position:!0,color:!0})),i.ALL=n(new i({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),i.DEFAULT=i.POSITION_NORMAL_AND_ST,i.packedLength=6,i.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.position?1:0,i[o++]=n.normal?1:0,i[o++]=n.st?1:0,i[o++]=n.binormal?1:0,i[o++]=n.tangent?1:0,i[o++]=n.color?1:0},i.unpack=function(n,o,a){if(!r(n))throw new t("array is required");return o=e(o,0),r(a)||(a=new i),a.position=1===n[o++],a.normal=1===n[o++],a.st=1===n[o++],a.binormal=1===n[o++],a.tangent=1===n[o++],a.color=1===n[o++],a},i.clone=function(e,t){return r(e)?(r(t)||(t=new i),t.position=e.position,t.normal=e.normal,t.st=e.st,t.binormal=e.binormal,t.tangent=e.tangent,t.color=e.color,t):void 0},i}),define("Core/EllipsoidGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType","./VertexFormat"],function(e,r,t,n,i,o,a,u,s,E,f,w,c,h,d){"use strict";var l=new t,_=new t,R=new t,T=new t,A=new t,m=new t(1,1,1),N=Math.cos,I=Math.sin,S=function(e){e=i(e,i.EMPTY_OBJECT);var r=i(e.radii,m),n=i(e.stackPartitions,64),o=i(e.slicePartitions,64),u=i(e.vertexFormat,d.DEFAULT);if(3>o)throw new a("options.slicePartitions cannot be less than three.");if(3>n)throw new a("options.stackPartitions cannot be less than three.");this._radii=t.clone(r),this._stackPartitions=n,this._slicePartitions=o,this._vertexFormat=d.clone(u),this._workerName="createEllipsoidGeometry"};S.packedLength=t.packedLength+d.packedLength+2,S.pack=function(e,r,n){if(!o(e))throw new a("value is required");if(!o(r))throw new a("array is required");n=i(n,0),t.pack(e._radii,r,n),n+=t.packedLength,d.pack(e._vertexFormat,r,n),n+=d.packedLength,r[n++]=e._stackPartitions,r[n]=e._slicePartitions};var y=new t,O=new d,p={radii:y,vertexFormat:O,stackPartitions:void 0,slicePartitions:void 0};return S.unpack=function(e,r,n){if(!o(e))throw new a("array is required");r=i(r,0);var u=t.unpack(e,r,y);r+=t.packedLength;var s=d.unpack(e,r,O);r+=d.packedLength;var E=e[r++],f=e[r];return o(n)?(n._radii=t.clone(u,n._radii),n._vertexFormat=d.clone(s,n._vertexFormat),n._stackPartitions=E,n._slicePartitions=f,n):(p.stackPartitions=E,p.slicePartitions=f,new S(p))},S.createGeometry=function(i){var o,a,d=i._radii,m=u.fromCartesian3(d),S=i._vertexFormat,y=i._slicePartitions+1,O=i._stackPartitions+1,p=O*y,M=new Float64Array(3*p),q=6*(y-1)*(O-1),C=w.createTypedArray(p,q),U=S.normal?new Float32Array(3*p):void 0,L=S.tangent?new Float32Array(3*p):void 0,P=S.binormal?new Float32Array(3*p):void 0,F=S.st?new Float32Array(2*p):void 0,v=new Array(y),g=new Array(y),x=0;for(o=0;y>o;o++){var D=c.TWO_PI*o/(y-1);v[o]=N(D),g[o]=I(D),M[x++]=0,M[x++]=0,M[x++]=d.z}for(o=1;O-1>o;o++){var B=Math.PI*o/(O-1),b=I(B),z=d.x*b,G=d.y*b,X=d.z*N(B);for(a=0;y>a;a++)M[x++]=v[a]*z,M[x++]=g[a]*G,M[x++]=X}for(o=0;y>o;o++)M[x++]=0,M[x++]=0,M[x++]=-d.z;var V=new f;S.position&&(V.position=new E({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:M}));var H=0,W=0,Y=0,K=0;if(S.st||S.normal||S.tangent||S.binormal){for(o=0;p>o;o++){var k=t.fromArray(M,3*o,l),Z=m.geodeticSurfaceNormal(k,_);if(S.st){var j=r.negate(Z,A);r.magnitude(j)<c.EPSILON6&&(x=3*(o+y*Math.floor(.5*O)),x>M.length&&(x=3*(o-y*Math.floor(.5*O))),t.fromArray(M,x,j),m.geodeticSurfaceNormal(j,j),r.negate(j,j)),F[H++]=Math.atan2(j.y,j.x)/c.TWO_PI+.5,F[H++]=Math.asin(Z.z)/Math.PI+.5}if(S.normal&&(U[W++]=Z.x,U[W++]=Z.y,U[W++]=Z.z),S.tangent||S.binormal){var Q=R;if(y>o||o>p-y-1?(t.cross(t.UNIT_X,Z,Q),t.normalize(Q,Q)):(t.cross(t.UNIT_Z,Z,Q),t.normalize(Q,Q)),S.tangent&&(L[Y++]=Q.x,L[Y++]=Q.y,L[Y++]=Q.z),S.binormal){var J=t.cross(Z,Q,T);t.normalize(J,J),P[K++]=J.x,P[K++]=J.y,P[K++]=J.z}}}S.st&&(V.st=new E({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:F})),S.normal&&(V.normal=new E({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:U})),S.tangent&&(V.tangent=new E({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:L})),S.binormal&&(V.binormal=new E({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:P}))}for(x=0,o=0;O>o;o++){var $=o*y,ee=(o+1)*y;for(a=0;y-1>a;a++)C[x++]=ee+a,C[x++]=ee+a+1,C[x++]=$+a+1,C[x++]=ee+a,C[x++]=$+a+1,C[x++]=$+a}return new s({attributes:V,indices:C,primitiveType:h.TRIANGLES,boundingSphere:e.fromEllipsoid(m)})},S}),define("Workers/createEllipsoidGeometry",["../Core/defined","../Core/EllipsoidGeometry"],function(e,r){"use strict";return function(t,n){return e(n)&&(t=r.unpack(t,n)),r.createGeometry(t)}})}();