/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var r=Object.freeze;return e(r)||(r=function(e){return e}),r}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var r=function(e,r){return void 0!==e?e:r};return r.EMPTY_OBJECT=e({}),r}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var r=function(e){this.name="DeveloperError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r.throwInstantiationError=function(){throw new r("This function defines an interface and should not be called directly.")},r}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var t;for(this.mti==this.N+1&&this.init_genrand(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^r[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^r[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^r[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.signNotZero=function(e){return 0>e?-1:1},i.toSNorm=function(e){return Math.round(255*(.5*i.clamp(e,-1,1)+.5))},i.fromSNorm=function(e){return i.clamp(e,0,255)/255*2-1},i.sinh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r-t)},i.cosh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r+t)},i.lerp=function(e,r,t){return(1-t)*e+t*r},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=3*Math.PI*.5,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){if(!t(e))throw new n("degrees is required.");return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){if(!t(e))throw new n("radians is required.");return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){if(!t(e))throw new n("angle is required.");var r=i.TWO_PI,o=e-Math.floor(e/r)*r;return o<-Math.PI?o+r:o>=Math.PI?o-r:o},i.negativePiToPi=function(e){if(!t(e))throw new n("x is required.");return i.zeroToTwoPi(e+i.PI)-i.PI},i.zeroToTwoPi=function(e){if(!t(e))throw new n("x is required.");var r=i.mod(e,i.TWO_PI);return Math.abs(r)<i.EPSILON14&&Math.abs(e)>i.EPSILON14?i.TWO_PI:r},i.mod=function(e,r){if(!t(e))throw new n("m is required.");if(!t(r))throw new n("n is required.");return(e%r+r)%r},i.equalsEpsilon=function(e,i,o,a){if(!t(e))throw new n("left is required.");if(!t(i))throw new n("right is required.");if(!t(o))throw new n("relativeEpsilon is required.");a=r(a,o);var u=Math.abs(e-i);return a>=u||u<=o*Math.max(Math.abs(e),Math.abs(i))};var o=[1];i.factorial=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");var r=o.length;if(e>=r)for(var t=o[r-1],i=r;e>=i;i++)o.push(t*i);return o[e]},i.incrementWrap=function(e,i,o){if(o=r(o,0),!t(e))throw new n("n is required.");if(o>=i)throw new n("maximumValue must be greater than minimumValue.");return++e,e>i&&(e=o),e},i.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,r,i){if(!t(e))throw new n("value is required");if(!t(r))throw new n("min is required.");if(!t(i))throw new n("max is required.");return r>e?r:e>i?i:e};var a=new e;return i.setRandomNumberSeed=function(r){if(!t(r))throw new n("seed is required.");a=new e(r)},i.nextRandomNumber=function(){return a.random()},i.acosClamped=function(e){if(!t(e))throw new n("value is required.");return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){if(!t(e))throw new n("value is required.");return Math.asin(i.clamp(e,-1,1))},i.chordLength=function(e,r){if(!t(e))throw new n("angle is required.");if(!t(r))throw new n("radius is required.");return 2*r*Math.sin(.5*e)},i}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t,n){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0)};o.fromSpherical=function(n,i){if(!r(n))throw new t("spherical is required");r(i)||(i=new o);var a=n.clock,u=n.cone,s=e(n.magnitude,1),c=s*Math.sin(u);return i.x=c*Math.cos(a),i.y=c*Math.sin(a),i.z=s*Math.cos(u),i},o.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new o(e,t,n)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new o(e.x,e.y,e.z):void 0},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.x,i[o++]=n.y,i[o]=n.z},o.unpack=function(n,i,a){if(!r(n))throw new t("array is required");return i=e(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i],a},o.fromArray=o.unpack,o.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z)},o.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z)},o.minimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i},o.maximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitude(a)},o.distanceSquared=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitudeSquared(a)},o.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=o.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n},o.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z},o.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i},o.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i},o.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i},o.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i},o.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i},o.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n},o.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n};var u=new o;o.lerp=function(e,n,i,a){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(n,i,u),a=o.multiplyByScalar(e,1-i,a),o.add(u,a,a)};var s=new o,c=new o;o.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");o.normalize(e,s),o.normalize(n,c);var i=o.dot(s,c),a=o.magnitude(o.cross(s,c,s));return Math.atan2(a,i)};var f=new o;o.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=o.normalize(e,f);return o.abs(i,i),n=i.x<=i.y?i.x<=i.z?o.clone(o.UNIT_X,n):o.clone(o.UNIT_Z,n):i.y<=i.z?o.clone(o.UNIT_Y,n):o.clone(o.UNIT_Z,n)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},o.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]&&e.z===r[t+2]},o.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)&&i.equalsEpsilon(e.z,t.z,n,o)},o.cross=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");var o=e.x,a=e.y,u=e.z,s=n.x,c=n.y,f=n.z,l=a*f-u*c,h=u*s-o*f,w=o*c-a*s;return i.x=l,i.y=h,i.z=w,i},o.fromDegrees=function(e,n,a,u,s){if(!r(e))throw new t("longitude is required");if(!r(n))throw new t("latitude is required");var c=i.toRadians(e),f=i.toRadians(n);return o.fromRadians(c,f,a,u,s)};var l=new o,h=new o,w=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(n,i,a,u,s){if(!r(n))throw new t("longitude is required");if(!r(i))throw new t("latitude is required");a=e(a,0);var c=r(u)?u.radiiSquared:w,f=Math.cos(i);l.x=f*Math.cos(n),l.y=f*Math.sin(n),l.z=Math.sin(i),l=o.normalize(l,l),o.multiplyComponents(c,l,h);var d=Math.sqrt(o.dot(l,h));return h=o.divideByScalar(h,d,h),l=o.multiplyByScalar(l,a,l),r(s)||(s=new o),o.add(h,l,s)},o.fromDegreesArray=function(e,n,a){if(!r(e))throw new t("positions is required.");for(var u=new Array(e.length),s=0;s<e.length;s++)u[s]=i.toRadians(e[s]);return o.fromRadiansArray(u,n,a)},o.fromRadiansArray=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<2)throw new t("positions length cannot be less than 2.");if(e.length%2!==0)throw new t("positions length must be a multiple of 2.");var a=e.length;r(i)?i.length=a/2:i=new Array(a/2);for(var u=0;a>u;u+=2){var s=e[u],c=e[u+1];i[u/2]=o.fromRadians(s,c,0,n,i[u/2])}return i},o.fromDegreesArrayHeights=function(e,n,a){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(e.length%3!==0)throw new t("positions length must be a multiple of 3.");for(var u=new Array(e.length),s=0;s<e.length;s+=3)u[s]=i.toRadians(e[s]),u[s+1]=i.toRadians(e[s+1]),u[s+2]=e[s+2];return o.fromRadiansArrayHeights(u,n,a)},o.fromRadiansArrayHeights=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(e.length%3!==0)throw new t("positions length must be a multiple of 3.");var a=e.length;r(i)?i.length=a/3:i=new Array(a/3);for(var u=0;a>u;u+=3){var s=e[u],c=e[u+1],f=e[u+2];i[u/3]=o.fromRadians(s,c,f,n,i[u/3])}return i},o.ZERO=n(new o(0,0,0)),o.UNIT_X=n(new o(1,0,0)),o.UNIT_Y=n(new o(0,1,0)),o.UNIT_Z=n(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r,t){return o.equalsEpsilon(this,e,r,t)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t,n){this.longitude=e(r,0),this.latitude=e(t,0),this.height=e(n,0)};return o.fromRadians=function(n,i,a,u){if(!r(n))throw new t("longitude is required.");if(!r(i))throw new t("latitude is required.");return a=e(a,0),r(u)?(u.longitude=n,u.latitude=i,u.height=a,u):new o(n,i,a)},o.fromDegrees=function(e,n,a,u){if(!r(e))throw new t("longitude is required.");if(!r(n))throw new t("latitude is required.");return e=i.toRadians(e),n=i.toRadians(n),o.fromRadians(e,n,a,u)},o.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new o(e.longitude,e.latitude,e.height):void 0},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},o.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.longitude-n.longitude)<=i&&Math.abs(e.latitude-n.latitude)<=i&&Math.abs(e.height-n.height)<=i},o.ZERO=n(new o(0,0,0)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r){return o.equalsEpsilon(this,e,r)},o.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},o}),define("Core/deprecationWarning",["./defined","./DeveloperError"],function(e,r){"use strict";var t={},n=function(n,i){if(!e(n)||!e(i))throw new r("identifier and message are required.");e(t[n])||(t[n]=!0,console.log(i))};return n}),define("Core/defineProperties",["./defined"],function(e){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),t=Object.defineProperties;return r&&e(t)||(t=function(e){return e}),t}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,o,a,u){"use strict";function s(r,n,i,a){if(n=t(n,0),i=t(i,0),a=t(a,0),0>n||0>i||0>a)throw new o("All radii components must be greater than or equal to zero.");r._radii=new e(n,i,a),r._radiiSquared=new e(n*n,i*i,a*a),r._radiiToTheFourth=new e(n*n*n*n,i*i*i*i,a*a*a*a),r._oneOverRadii=new e(0===n?0:1/n,0===i?0:1/i,0===a?0:1/a),r._oneOverRadiiSquared=new e(0===n?0:1/(n*n),0===i?0:1/(i*i),0===a?0:1/(a*a)),r._minimumRadius=Math.min(n,i,a),r._maximumRadius=Math.max(n,i,a),r._centerToleranceSquared=u.EPSILON1}var c=function(e,r,t){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,s(this,e,r,t)};i(c.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),c.clone=function(r,t){if(!n(r))return void 0;var i=r._radii;return n(t)?(e.clone(i,t._radii),e.clone(r._radiiSquared,t._radiiSquared),e.clone(r._radiiToTheFourth,t._radiiToTheFourth),e.clone(r._oneOverRadii,t._oneOverRadii),e.clone(r._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=r._minimumRadius,t._maximumRadius=r._maximumRadius,t._centerToleranceSquared=r._centerToleranceSquared,t):new c(i.x,i.y,i.z)},c.fromCartesian3=function(e,r){return n(r)||(r=new c),n(e)?(s(r,e.x,e.y,e.z),r):r},c.WGS84=a(new c(6378137,6378137,6356752.314245179)),c.UNIT_SPHERE=a(new c(1,1,1)),c.MOON=a(new c(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),c.prototype.clone=function(e){return c.clone(this,e)},c.packedLength=e.packedLength,c.pack=function(r,i,a){if(!n(r))throw new o("value is required");if(!n(i))throw new o("array is required");a=t(a,0),e.pack(r._radii,i,a)},c.unpack=function(r,i,a){if(!n(r))throw new o("array is required");i=t(i,0);var u=e.unpack(r,i);return c.fromCartesian3(u,a)},c.prototype.geocentricSurfaceNormal=e.normalize,c.prototype.geodeticSurfaceNormalCartographic=function(r,t){if(!n(r))throw new o("cartographic is required.");var i=r.longitude,a=r.latitude,u=Math.cos(a),s=u*Math.cos(i),c=u*Math.sin(i),f=Math.sin(a);return n(t)||(t=new e),t.x=s,t.y=c,t.z=f,e.normalize(t,t)},c.prototype.geodeticSurfaceNormal=function(r,t){return n(t)||(t=new e),t=e.multiplyComponents(r,this._oneOverRadiiSquared,t),e.normalize(t,t)};var f=new e,l=new e;c.prototype.cartographicToCartesian=function(r,t){var i=f,o=l;this.geodeticSurfaceNormalCartographic(r,i),e.multiplyComponents(this._radiiSquared,i,o);var a=Math.sqrt(e.dot(i,o));return e.divideByScalar(o,a,o),e.multiplyByScalar(i,r.height,i),n(t)||(t=new e),e.add(o,i,t)},c.prototype.cartographicArrayToCartesianArray=function(e,r){if(!n(e))throw new o("cartographics is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;i++)r[i]=this.cartographicToCartesian(e[i],r[i]);return r};var h=new e,w=new e,d=new e;c.prototype.cartesianToCartographic=function(t,i){var o=this.scaleToGeodeticSurface(t,w);if(!n(o))return void 0;var a=this.geodeticSurfaceNormal(o,h),s=e.subtract(t,o,d),c=Math.atan2(a.y,a.x),f=Math.asin(a.z),l=u.sign(e.dot(s,t))*e.magnitude(s);return n(i)?(i.longitude=c,i.latitude=f,i.height=l,i):new r(c,f,l)},c.prototype.cartesianArrayToCartographicArray=function(e,r){if(!n(e))throw new o("cartesians is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;++i)r[i]=this.cartesianToCartographic(e[i],r[i]);return r};var m=new e,E=new e;return c.prototype.scaleToGeodeticSurface=function(r,t){if(!n(r))throw new o("cartesian is required.");var i=r.x,a=r.y,s=r.z,c=this._oneOverRadii,f=c.x,l=c.y,h=c.z,w=i*i*f*f,d=a*a*l*l,p=s*s*h*h,y=w+d+p,_=Math.sqrt(1/y),T=e.multiplyByScalar(r,_,m);if(y<this._centerToleranceSquared)return isFinite(_)?e.clone(T,t):void 0;var R=this._oneOverRadiiSquared,A=R.x,v=R.y,N=R.z,I=E;I.x=T.x*A*2,I.y=T.y*v*2,I.z=T.z*N*2;var S,g,M,O,q,b,x,P,L,C,F,U=(1-_)*e.magnitude(r)/(.5*e.magnitude(I)),D=0;do{U-=D,M=1/(1+U*A),O=1/(1+U*v),q=1/(1+U*N),b=M*M,x=O*O,P=q*q,L=b*M,C=x*O,F=P*q,S=w*b+d*x+p*P-1,g=w*L*A+d*C*v+p*F*N;var B=-2*g;D=S/B}while(Math.abs(S)>u.EPSILON12);return n(t)?(t.x=i*M,t.y=a*O,t.z=s*q,t):new e(i*M,a*O,s*q)},c.prototype.scaleToGeocentricSurface=function(r,t){if(!n(r))throw new o("cartesian is required.");n(t)||(t=new e);var i=r.x,a=r.y,u=r.z,s=this._oneOverRadiiSquared,c=1/Math.sqrt(i*i*s.x+a*a*s.y+u*u*s.z);return e.multiplyByScalar(r,c,t)},c.prototype.transformPositionToScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._oneOverRadii,t)},c.prototype.transformPositionFromScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._radii,t)},c.prototype.equals=function(r){return this===r||n(r)&&e.equals(this._radii,r._radii)},c.prototype.toString=function(){return this._radii.toString()},c}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,r,t,n,i,o,a){"use strict";var u=function(e){this._ellipsoid=t(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(r,t){var i=this._semimajorAxis,o=r.longitude*i,a=r.latitude*i,u=r.height;return n(t)?(t.x=o,t.y=a,t.z=u,t):new e(o,a,u)},u.prototype.unproject=function(e,t){if(!n(e))throw new o("cartesian is required");var i=this._oneOverSemimajorAxis,a=e.x*i,u=e.y*i,s=e.z;return n(t)?(t.longitude=a,t.latitude=u,t.height=s,t):new r(a,u,s)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var r={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(r)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var r=function(r,t){this.start=e(r,0),this.stop=e(t,0)};return r}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t,n,i){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0),this.w=e(i,0)};o.fromElements=function(e,t,n,i,a){return r(a)?(a.x=e,a.y=t,a.z=n,a.w=i,a):new o(e,t,n,i)},o.fromColor=function(e,n){if(!r(e))throw new t("color is required");return r(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new o(e.red,e.green,e.blue,e.alpha)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new o(e.x,e.y,e.z,e.w):void 0},o.packedLength=4,o.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.x,i[o++]=n.y,i[o++]=n.z,i[o]=n.w},o.unpack=function(n,i,a){if(!r(n))throw new t("array is required");return i=e(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i++],a.w=n[i],a},o.fromArray=o.unpack,o.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z,e.w)},o.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z,e.w)},o.minimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i.w=Math.min(e.w,n.w),i},o.maximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i.w=Math.max(e.w,n.w),i},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitude(a)},o.distanceSquared=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitudeSquared(a)},o.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=o.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n.w=e.w/i,n},o.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z+e.w*n.w},o.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i.w=e.w*n.w,i},o.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i.w=e.w+n.w,i},o.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i.w=e.w-n.w,i},o.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i.w=e.w*n,i},o.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i.w=e.w/n,i},o.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n.w=-e.w,n},o.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n.w=Math.abs(e.w),n};var u=new o;o.lerp=function(e,n,i,a){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(n,i,u),a=o.multiplyByScalar(e,1-i,a),o.add(u,a,a)};var s=new o;return o.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=o.normalize(e,s);return o.abs(i,i),n=i.x<=i.y?i.x<=i.z?i.x<=i.w?o.clone(o.UNIT_X,n):o.clone(o.UNIT_W,n):i.z<=i.w?o.clone(o.UNIT_Z,n):o.clone(o.UNIT_W,n):i.y<=i.z?i.y<=i.w?o.clone(o.UNIT_Y,n):o.clone(o.UNIT_W,n):i.z<=i.w?o.clone(o.UNIT_Z,n):o.clone(o.UNIT_W,n)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},o.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]&&e.z===r[t+2]&&e.w===r[t+3]},o.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)&&i.equalsEpsilon(e.z,t.z,n,o)&&i.equalsEpsilon(e.w,t.w,n,o)},o.ZERO=n(new o(0,0,0,0)),o.UNIT_X=n(new o(1,0,0,0)),o.UNIT_Y=n(new o(0,1,0,0)),o.UNIT_Z=n(new o(0,0,1,0)),o.UNIT_W=n(new o(0,0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r,t){return o.equalsEpsilon(this,e,r,t)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},o}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,o){"use strict";function a(e){for(var r=0,t=0;9>t;++t){var n=e[t];r+=n*n}return Math.sqrt(r)}function u(e){for(var r=0,t=0;3>t;++t){var n=e[c.getElementIndex(w[t],h[t])];r+=2*n*n}return Math.sqrt(r)}function s(e,r){for(var t=o.EPSILON15,n=0,i=1,a=0;3>a;++a){var u=Math.abs(e[c.getElementIndex(w[a],h[a])]);u>n&&(i=a,n=u)}var s=1,f=0,l=h[i],d=w[i];if(Math.abs(e[c.getElementIndex(d,l)])>t){var m,E=e[c.getElementIndex(d,d)],p=e[c.getElementIndex(l,l)],y=e[c.getElementIndex(d,l)],_=(E-p)/2/y;m=0>_?-1/(-_+Math.sqrt(1+_*_)):1/(_+Math.sqrt(1+_*_)),s=1/Math.sqrt(1+m*m),f=m*s}return r=c.clone(c.IDENTITY,r),r[c.getElementIndex(l,l)]=r[c.getElementIndex(d,d)]=s,r[c.getElementIndex(d,l)]=f,r[c.getElementIndex(l,d)]=-f,r}var c=function(e,t,n,i,o,a,u,s,c){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(o,0),this[5]=r(s,0),this[6]=r(n,0),this[7]=r(a,0),this[8]=r(c,0)};c.packedLength=9,c.pack=function(e,i,o){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");o=r(o,0),i[o++]=e[0],i[o++]=e[1],i[o++]=e[2],i[o++]=e[3],i[o++]=e[4],i[o++]=e[5],i[o++]=e[6],i[o++]=e[7],i[o++]=e[8]},c.unpack=function(e,i,o){if(!t(e))throw new n("array is required");return i=r(i,0),t(o)||(o=new c),o[0]=e[i++],o[1]=e[i++],o[2]=e[i++],o[3]=e[i++],o[4]=e[i++],o[5]=e[i++],o[6]=e[i++],o[7]=e[i++],o[8]=e[i++],o},c.clone=function(e,r){return t(e)?t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):new c(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},c.fromArray=function(e,i,o){if(!t(e))throw new n("array is required");return i=r(i,0),t(o)||(o=new c),o[0]=e[i],o[1]=e[i+1],o[2]=e[i+2],o[3]=e[i+3],o[4]=e[i+4],o[5]=e[i+5],o[6]=e[i+6],o[7]=e[i+7],o[8]=e[i+8],o},c.fromColumnMajorArray=function(e,r){if(!t(e))throw new n("values parameter is required");return c.clone(e,r)},c.fromRowMajorArray=function(e,r){if(!t(e))throw new n("values is required.");return t(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},c.fromQuaternion=function(e,r){if(!t(e))throw new n("quaternion is required");var i=e.x*e.x,o=e.x*e.y,a=e.x*e.z,u=e.x*e.w,s=e.y*e.y,f=e.y*e.z,l=e.y*e.w,h=e.z*e.z,w=e.z*e.w,d=e.w*e.w,m=i-s-h+d,E=2*(o-w),p=2*(a+l),y=2*(o+w),_=-i+s-h+d,T=2*(f-u),R=2*(a-l),A=2*(f+u),v=-i-s+h+d;return t(r)?(r[0]=m,r[1]=y,r[2]=R,r[3]=E,r[4]=_,r[5]=A,r[6]=p,r[7]=T,r[8]=v,r):new c(m,E,p,y,_,T,R,A,v)},c.fromScale=function(e,r){if(!t(e))throw new n("scale is required.");return t(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new c(e.x,0,0,0,e.y,0,0,0,e.z)},c.fromUniformScale=function(e,r){if("number"!=typeof e)throw new n("scale is required.");return t(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new c(e,0,0,0,e,0,0,0,e)},c.fromCrossProduct=function(e,r){if(!t(e))throw new n("vector is required.");return t(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new c(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},c.fromRotationX=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=o,r[6]=0,r[7]=-o,r[8]=i,r):new c(1,0,0,0,i,-o,0,o,i)},c.fromRotationY=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=i,r[1]=0,r[2]=-o,r[3]=0,r[4]=1,r[5]=0,r[6]=o,r[7]=0,r[8]=i,r):new c(i,0,o,0,1,0,-o,0,i)},c.fromRotationZ=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=i,r[1]=o,r[2]=0,r[3]=-o,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new c(i,-o,0,o,i,0,0,0,1)},c.toArray=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},c.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>2)throw new n("row must be 0, 1, or 2.");if("number"!=typeof e||0>e||e>2)throw new n("column must be 0, 1, or 2.");return 3*e+r},c.getColumn=function(e,r,i){if(!t(e))throw new n("matrix is required.");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(i))throw new n("result is required");var o=3*r,a=e[o],u=e[o+1],s=e[o+2];return i.x=a,i.y=u,i.z=s,i},c.setColumn=function(e,r,i,o){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(o))throw new n("result is required");o=c.clone(e,o);var a=3*r;return o[a]=i.x,o[a+1]=i.y,o[a+2]=i.z,o},c.getRow=function(e,r,i){if(!t(e))throw new n("matrix is required.");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(i))throw new n("result is required");var o=e[r],a=e[r+3],u=e[r+6];
return i.x=o,i.y=a,i.z=u,i},c.setRow=function(e,r,i,o){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(o))throw new n("result is required");return o=c.clone(e,o),o[r]=i.x,o[r+3]=i.y,o[r+6]=i.z,o};var f=new e;c.getScale=function(r,i){if(!t(r))throw new n("matrix is required.");if(!t(i))throw new n("result is required");return i.x=e.magnitude(e.fromElements(r[0],r[1],r[2],f)),i.y=e.magnitude(e.fromElements(r[3],r[4],r[5],f)),i.z=e.magnitude(e.fromElements(r[6],r[7],r[8],f)),i};var l=new e;c.getMaximumScale=function(r){return c.getScale(r,l),e.maximumComponent(l)},c.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");var o=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],a=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],u=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],s=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],c=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],f=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],l=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],h=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],w=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return i[0]=o,i[1]=a,i[2]=u,i[3]=s,i[4]=c,i[5]=f,i[6]=l,i[7]=h,i[8]=w,i},c.add=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i[0]=e[0]+r[0],i[1]=e[1]+r[1],i[2]=e[2]+r[2],i[3]=e[3]+r[3],i[4]=e[4]+r[4],i[5]=e[5]+r[5],i[6]=e[6]+r[6],i[7]=e[7]+r[7],i[8]=e[8]+r[8],i},c.subtract=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],i[3]=e[3]-r[3],i[4]=e[4]-r[4],i[5]=e[5]-r[5],i[6]=e[6]-r[6],i[7]=e[7]-r[7],i[8]=e[8]-r[8],i},c.multiplyByVector=function(e,r,i){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("cartesian is required");if(!t(i))throw new n("result is required");var o=r.x,a=r.y,u=r.z,s=e[0]*o+e[3]*a+e[6]*u,c=e[1]*o+e[4]*a+e[7]*u,f=e[2]*o+e[5]*a+e[8]*u;return i.x=s,i.y=c,i.z=f,i},c.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scalar must be a number");if(!t(i))throw new n("result is required");return i[0]=e[0]*r,i[1]=e[1]*r,i[2]=e[2]*r,i[3]=e[3]*r,i[4]=e[4]*r,i[5]=e[5]*r,i[6]=e[6]*r,i[7]=e[7]*r,i[8]=e[8]*r,i},c.multiplyByScale=function(e,r,i){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("scale is required");if(!t(i))throw new n("result is required");return i[0]=e[0]*r.x,i[1]=e[1]*r.x,i[2]=e[2]*r.x,i[3]=e[3]*r.y,i[4]=e[4]*r.y,i[5]=e[5]*r.y,i[6]=e[6]*r.z,i[7]=e[7]*r.z,i[8]=e[8]*r.z,i},c.negate=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");return r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},c.transpose=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");var i=e[0],o=e[3],a=e[6],u=e[1],s=e[4],c=e[7],f=e[2],l=e[5],h=e[8];return r[0]=i,r[1]=o,r[2]=a,r[3]=u,r[4]=s,r[5]=c,r[6]=f,r[7]=l,r[8]=h,r};var h=[1,0,0],w=[2,2,1],d=new c,m=new c;return c.computeEigenDecomposition=function(e,r){if(!t(e))throw new n("matrix is required.");var i=o.EPSILON20,f=10,l=0,h=0;t(r)||(r={});for(var w=r.unitary=c.clone(c.IDENTITY,r.unitary),E=r.diagonal=c.clone(e,r.diagonal),p=i*a(E);f>h&&u(E)>p;)s(E,d),c.transpose(d,m),c.multiply(E,d,E),c.multiply(m,E,E),c.multiply(w,d,w),++l>2&&(++h,l=0);return r},c.abs=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");return r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},c.determinant=function(e){if(!t(e))throw new n("matrix is required");var r=e[0],i=e[3],o=e[6],a=e[1],u=e[4],s=e[7],c=e[2],f=e[5],l=e[8];return r*(u*l-f*s)+a*(f*o-i*l)+c*(i*s-u*o)},c.inverse=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");var i=e[0],a=e[1],u=e[2],s=e[3],f=e[4],l=e[5],h=e[6],w=e[7],d=e[8],m=c.determinant(e);if(Math.abs(m)<=o.EPSILON15)throw new n("matrix is not invertible");r[0]=f*d-w*l,r[1]=w*u-a*d,r[2]=a*l-f*u,r[3]=h*l-s*d,r[4]=i*d-h*u,r[5]=s*u-i*l,r[6]=s*w-h*f,r[7]=h*a-i*w,r[8]=i*f-s*a;var E=1/m;return c.multiplyByScalar(r,E,r)},c.equals=function(e,r){return e===r||t(e)&&t(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]},c.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon must be a number");return e===r||t(e)&&t(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},c.IDENTITY=i(new c(1,0,0,0,1,0,0,0,1)),c.ZERO=i(new c(0,0,0,0,0,0,0,0,0)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN1ROW0=3,c.COLUMN1ROW1=4,c.COLUMN1ROW2=5,c.COLUMN2ROW0=6,c.COLUMN2ROW1=7,c.COLUMN2ROW2=8,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,r,t){return e[0]===r[t]&&e[1]===r[t+1]&&e[2]===r[t+2]&&e[3]===r[t+3]&&e[4]===r[t+4]&&e[5]===r[t+5]&&e[6]===r[t+6]&&e[7]===r[t+7]&&e[8]===r[t+8]},c.prototype.equalsEpsilon=function(e,r){return c.equalsEpsilon(this,e,r)},c.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},c}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var r=function(e){this.name="RuntimeError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,r,t,n,i,o,a,u,s){"use strict";var c=function(e,r,n,i,o,a,u,s,c,f,l,h,w,d,m,E){this[0]=t(e,0),this[1]=t(o,0),this[2]=t(c,0),this[3]=t(w,0),this[4]=t(r,0),this[5]=t(a,0),this[6]=t(f,0),this[7]=t(d,0),this[8]=t(n,0),this[9]=t(u,0),this[10]=t(l,0),this[11]=t(m,0),this[12]=t(i,0),this[13]=t(s,0),this[14]=t(h,0),this[15]=t(E,0)};c.packedLength=16,c.pack=function(e,r,o){if(!n(e))throw new i("value is required");if(!n(r))throw new i("array is required");o=t(o,0),r[o++]=e[0],r[o++]=e[1],r[o++]=e[2],r[o++]=e[3],r[o++]=e[4],r[o++]=e[5],r[o++]=e[6],r[o++]=e[7],r[o++]=e[8],r[o++]=e[9],r[o++]=e[10],r[o++]=e[11],r[o++]=e[12],r[o++]=e[13],r[o++]=e[14],r[o]=e[15]},c.unpack=function(e,r,o){if(!n(e))throw new i("array is required");return r=t(r,0),n(o)||(o=new c),o[0]=e[r++],o[1]=e[r++],o[2]=e[r++],o[3]=e[r++],o[4]=e[r++],o[5]=e[r++],o[6]=e[r++],o[7]=e[r++],o[8]=e[r++],o[9]=e[r++],o[10]=e[r++],o[11]=e[r++],o[12]=e[r++],o[13]=e[r++],o[14]=e[r++],o[15]=e[r],o},c.clone=function(e,r){return n(e)?n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):new c(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},c.fromArray=c.unpack,c.fromColumnMajorArray=function(e,r){if(!n(e))throw new i("values is required");return c.clone(e,r)},c.fromRowMajorArray=function(e,r){if(!n(e))throw new i("values is required.");return n(r)?(r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=e[1],r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=e[2],r[9]=e[6],r[10]=e[10],r[11]=e[14],r[12]=e[3],r[13]=e[7],r[14]=e[11],r[15]=e[15],r):new c(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},c.fromRotationTranslation=function(r,o,a){if(!n(r))throw new i("rotation is required.");return o=t(o,e.ZERO),n(a)?(a[0]=r[0],a[1]=r[1],a[2]=r[2],a[3]=0,a[4]=r[3],a[5]=r[4],a[6]=r[5],a[7]=0,a[8]=r[6],a[9]=r[7],a[10]=r[8],a[11]=0,a[12]=o.x,a[13]=o.y,a[14]=o.z,a[15]=1,a):new c(r[0],r[3],r[6],o.x,r[1],r[4],r[7],o.y,r[2],r[5],r[8],o.z,0,0,0,1)},c.fromTranslationQuaternionRotationScale=function(e,r,t,o){if(!n(e))throw new i("translation is required.");if(!n(r))throw new i("rotation is required.");if(!n(t))throw new i("scale is required.");n(o)||(o=new c);var a=t.x,u=t.y,s=t.z,f=r.x*r.x,l=r.x*r.y,h=r.x*r.z,w=r.x*r.w,d=r.y*r.y,m=r.y*r.z,E=r.y*r.w,p=r.z*r.z,y=r.z*r.w,_=r.w*r.w,T=f-d-p+_,R=2*(l-y),A=2*(h+E),v=2*(l+y),N=-f+d-p+_,I=2*(m-w),S=2*(h-E),g=2*(m+w),M=-f-d+p+_;return o[0]=T*a,o[1]=v*a,o[2]=S*a,o[3]=0,o[4]=R*u,o[5]=N*u,o[6]=g*u,o[7]=0,o[8]=A*s,o[9]=I*s,o[10]=M*s,o[11]=0,o[12]=e.x,o[13]=e.y,o[14]=e.z,o[15]=1,o},c.fromTranslation=function(e,r){if(!n(e))throw new i("translation is required.");return c.fromRotationTranslation(u.IDENTITY,e,r)},c.fromScale=function(e,r){if(!n(e))throw new i("scale is required.");return n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e.y,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e.z,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new c(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},c.fromUniformScale=function(e,r){if("number"!=typeof e)throw new i("scale is required.");return n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new c(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var f=new e,l=new e,h=new e;c.fromCamera=function(r,t){if(!n(r))throw new i("camera is required.");var o=r.eye,a=r.target,u=r.up;if(!n(o))throw new i("camera.eye is required.");if(!n(a))throw new i("camera.target is required.");if(!n(u))throw new i("camera.up is required.");e.normalize(e.subtract(a,o,f),f),e.normalize(e.cross(f,u,l),l),e.normalize(e.cross(l,f,h),h);var s=l.x,w=l.y,d=l.z,m=f.x,E=f.y,p=f.z,y=h.x,_=h.y,T=h.z,R=o.x,A=o.y,v=o.z,N=s*-R+w*-A+d*-v,I=y*-R+_*-A+T*-v,S=m*R+E*A+p*v;return n(t)?(t[0]=s,t[1]=y,t[2]=-m,t[3]=0,t[4]=w,t[5]=_,t[6]=-E,t[7]=0,t[8]=d,t[9]=T,t[10]=-p,t[11]=0,t[12]=N,t[13]=I,t[14]=S,t[15]=1,t):new c(s,w,d,N,y,_,T,I,-m,-E,-p,S,0,0,0,1)},c.computePerspectiveFieldOfView=function(e,r,t,o,a){if(0>=e||e>Math.PI)throw new i("fovY must be in [0, PI).");if(0>=r)throw new i("aspectRatio must be greater than zero.");if(0>=t)throw new i("near must be greater than zero.");if(0>=o)throw new i("far must be greater than zero.");if(!n(a))throw new i("result is required");var u=Math.tan(.5*e),s=1/u,c=s/r,f=(o+t)/(t-o),l=2*o*t/(t-o);return a[0]=c,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=s,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=f,a[11]=-1,a[12]=0,a[13]=0,a[14]=l,a[15]=0,a},c.computeOrthographicOffCenter=function(e,r,t,o,a,u,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(o))throw new i("top is required.");if(!n(a))throw new i("near is required.");if(!n(u))throw new i("far is required.");if(!n(s))throw new i("result is required");var c=1/(r-e),f=1/(o-t),l=1/(u-a),h=-(r+e)*c,w=-(o+t)*f,d=-(u+a)*l;return c*=2,f*=2,l*=-2,s[0]=c,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=f,s[6]=0,s[7]=0,s[8]=0,s[9]=0,s[10]=l,s[11]=0,s[12]=h,s[13]=w,s[14]=d,s[15]=1,s},c.computePerspectiveOffCenter=function(e,r,t,o,a,u,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(o))throw new i("top is required.");if(!n(a))throw new i("near is required.");if(!n(u))throw new i("far is required.");if(!n(s))throw new i("result is required");var c=2*a/(r-e),f=2*a/(o-t),l=(r+e)/(r-e),h=(o+t)/(o-t),w=-(u+a)/(u-a),d=-1,m=-2*u*a/(u-a);return s[0]=c,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=f,s[6]=0,s[7]=0,s[8]=l,s[9]=h,s[10]=w,s[11]=d,s[12]=0,s[13]=0,s[14]=m,s[15]=0,s},c.computeInfinitePerspectiveOffCenter=function(e,r,t,o,a,u){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(o))throw new i("top is required.");if(!n(a))throw new i("near is required.");if(!n(u))throw new i("result is required");var s=2*a/(r-e),c=2*a/(o-t),f=(r+e)/(r-e),l=(o+t)/(o-t),h=-1,w=-1,d=-2*a;return u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=f,u[9]=l,u[10]=h,u[11]=w,u[12]=0,u[13]=0,u[14]=d,u[15]=0,u},c.computeViewportTransformation=function(e,r,o,a){if(!n(a))throw new i("result is required");e=t(e,t.EMPTY_OBJECT);var u=t(e.x,0),s=t(e.y,0),c=t(e.width,0),f=t(e.height,0);r=t(r,0),o=t(o,1);var l=.5*c,h=.5*f,w=.5*(o-r),d=l,m=h,E=w,p=u+l,y=s+h,_=r+w,T=1;return a[0]=d,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=m,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=E,a[11]=0,a[12]=p,a[13]=y,a[14]=_,a[15]=T,a},c.toArray=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},c.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>3)throw new i("row must be 0, 1, 2, or 3.");if("number"!=typeof e||0>e||e>3)throw new i("column must be 0, 1, 2, or 3.");return 4*e+r},c.getColumn=function(e,r,t){if(!n(e))throw new i("matrix is required.");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(t))throw new i("result is required");var o=4*r,a=e[o],u=e[o+1],s=e[o+2],c=e[o+3];return t.x=a,t.y=u,t.z=s,t.w=c,t},c.setColumn=function(e,r,t,o){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(o))throw new i("result is required");o=c.clone(e,o);var a=4*r;return o[a]=t.x,o[a+1]=t.y,o[a+2]=t.z,o[a+3]=t.w,o},c.setTranslation=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("translation is required");if(!n(t))throw new i("result is required");return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=r.x,t[13]=r.y,t[14]=r.z,t[15]=e[15],t},c.getRow=function(e,r,t){if(!n(e))throw new i("matrix is required.");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(t))throw new i("result is required");var o=e[r],a=e[r+4],u=e[r+8],s=e[r+12];return t.x=o,t.y=a,t.z=u,t.w=s,t},c.setRow=function(e,r,t,o){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(o))throw new i("result is required");return o=c.clone(e,o),o[r]=t.x,o[r+4]=t.y,o[r+8]=t.z,o[r+12]=t.w,o};var w=new e;c.getScale=function(r,t){if(!n(r))throw new i("matrix is required.");if(!n(t))throw new i("result is required");return t.x=e.magnitude(e.fromElements(r[0],r[1],r[2],w)),t.y=e.magnitude(e.fromElements(r[4],r[5],r[6],w)),t.z=e.magnitude(e.fromElements(r[8],r[9],r[10],w)),t};var d=new e;c.getMaximumScale=function(r){return c.getScale(r,d),e.maximumComponent(d)},c.multiply=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");var o=e[0],a=e[1],u=e[2],s=e[3],c=e[4],f=e[5],l=e[6],h=e[7],w=e[8],d=e[9],m=e[10],E=e[11],p=e[12],y=e[13],_=e[14],T=e[15],R=r[0],A=r[1],v=r[2],N=r[3],I=r[4],S=r[5],g=r[6],M=r[7],O=r[8],q=r[9],b=r[10],x=r[11],P=r[12],L=r[13],C=r[14],F=r[15],U=o*R+c*A+w*v+p*N,D=a*R+f*A+d*v+y*N,B=u*R+l*A+m*v+_*N,z=s*R+h*A+E*v+T*N,G=o*I+c*S+w*g+p*M,V=a*I+f*S+d*g+y*M,X=u*I+l*S+m*g+_*M,H=s*I+h*S+E*g+T*M,W=o*O+c*q+w*b+p*x,Y=a*O+f*q+d*b+y*x,k=u*O+l*q+m*b+_*x,K=s*O+h*q+E*b+T*x,Z=o*P+c*L+w*C+p*F,j=a*P+f*L+d*C+y*F,Q=u*P+l*L+m*C+_*F,J=s*P+h*L+E*C+T*F;return t[0]=U,t[1]=D,t[2]=B,t[3]=z,t[4]=G,t[5]=V,t[6]=X,t[7]=H,t[8]=W,t[9]=Y,t[10]=k,t[11]=K,t[12]=Z,t[13]=j,t[14]=Q,t[15]=J,t},c.add=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t[6]=e[6]+r[6],t[7]=e[7]+r[7],t[8]=e[8]+r[8],t[9]=e[9]+r[9],t[10]=e[10]+r[10],t[11]=e[11]+r[11],t[12]=e[12]+r[12],t[13]=e[13]+r[13],t[14]=e[14]+r[14],t[15]=e[15]+r[15],t},c.subtract=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t[4]=e[4]-r[4],t[5]=e[5]-r[5],t[6]=e[6]-r[6],t[7]=e[7]-r[7],t[8]=e[8]-r[8],t[9]=e[9]-r[9],t[10]=e[10]-r[10],t[11]=e[11]-r[11],t[12]=e[12]-r[12],t[13]=e[13]-r[13],t[14]=e[14]-r[14],t[15]=e[15]-r[15],t},c.multiplyTransformation=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");var o=e[0],a=e[1],u=e[2],s=e[4],c=e[5],f=e[6],l=e[8],h=e[9],w=e[10],d=e[12],m=e[13],E=e[14],p=r[0],y=r[1],_=r[2],T=r[4],R=r[5],A=r[6],v=r[8],N=r[9],I=r[10],S=r[12],g=r[13],M=r[14],O=o*p+s*y+l*_,q=a*p+c*y+h*_,b=u*p+f*y+w*_,x=o*T+s*R+l*A,P=a*T+c*R+h*A,L=u*T+f*R+w*A,C=o*v+s*N+l*I,F=a*v+c*N+h*I,U=u*v+f*N+w*I,D=o*S+s*g+l*M+d,B=a*S+c*g+h*M+m,z=u*S+f*g+w*M+E;return t[0]=O,t[1]=q,t[2]=b,t[3]=0,t[4]=x,t[5]=P,t[6]=L,t[7]=0,t[8]=C,t[9]=F,t[10]=U,t[11]=0,t[12]=D,t[13]=B,t[14]=z,t[15]=1,t},c.multiplyByMatrix3=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("rotation is required");if(!n(t))throw new i("result is required");var o=e[0],a=e[1],u=e[2],s=e[4],c=e[5],f=e[6],l=e[8],h=e[9],w=e[10],d=r[0],m=r[1],E=r[2],p=r[3],y=r[4],_=r[5],T=r[6],R=r[7],A=r[8],v=o*d+s*m+l*E,N=a*d+c*m+h*E,I=u*d+f*m+w*E,S=o*p+s*y+l*_,g=a*p+c*y+h*_,M=u*p+f*y+w*_,O=o*T+s*R+l*A,q=a*T+c*R+h*A,b=u*T+f*R+w*A;return t[0]=v,t[1]=N,t[2]=I,t[3]=0,t[4]=S,t[5]=g,t[6]=M,t[7]=0,t[8]=O,t[9]=q,t[10]=b,t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},c.multiplyByTranslation=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("translation is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,u=r.z,s=o*e[0]+a*e[4]+u*e[8]+e[12],c=o*e[1]+a*e[5]+u*e[9]+e[13],f=o*e[2]+a*e[6]+u*e[10]+e[14];return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=s,t[13]=c,t[14]=f,t[15]=e[15],t};var m=new e;c.multiplyByUniformScale=function(e,r,t){if(!n(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scale is required");if(!n(t))throw new i("result is required");return m.x=r,m.y=r,m.z=r,c.multiplyByScale(e,m,t)},c.multiplyByScale=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("scale is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,u=r.z;return 1===o&&1===a&&1===u?c.clone(e,t):(t[0]=o*e[0],t[1]=o*e[1],t[2]=o*e[2],t[3]=0,t[4]=a*e[4],t[5]=a*e[5],t[6]=a*e[6],t[7]=0,t[8]=u*e[8],t[9]=u*e[9],t[10]=u*e[10],t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=1,t)},c.multiplyByVector=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,u=r.z,s=r.w,c=e[0]*o+e[4]*a+e[8]*u+e[12]*s,f=e[1]*o+e[5]*a+e[9]*u+e[13]*s,l=e[2]*o+e[6]*a+e[10]*u+e[14]*s,h=e[3]*o+e[7]*a+e[11]*u+e[15]*s;return t.x=c,t.y=f,t.z=l,t.w=h,t},c.multiplyByPointAsVector=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,u=r.z,s=e[0]*o+e[4]*a+e[8]*u,c=e[1]*o+e[5]*a+e[9]*u,f=e[2]*o+e[6]*a+e[10]*u;return t.x=s,t.y=c,t.z=f,t},c.multiplyByPoint=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,u=r.z,s=e[0]*o+e[4]*a+e[8]*u+e[12],c=e[1]*o+e[5]*a+e[9]*u+e[13],f=e[2]*o+e[6]*a+e[10]*u+e[14];return t.x=s,t.y=c,t.z=f,t},c.multiplyByScalar=function(e,r,t){if(!n(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scalar must be a number");if(!n(t))throw new i("result is required");return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t},c.negate=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r[9]=-e[9],r[10]=-e[10],r[11]=-e[11],r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=-e[15],r},c.transpose=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");var t=e[1],o=e[2],a=e[3],u=e[6],s=e[7],c=e[11];return r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=t,r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=o,r[9]=u,r[10]=e[10],r[11]=e[14],r[12]=a,r[13]=s,r[14]=c,r[15]=e[15],r},c.abs=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r[9]=Math.abs(e[9]),r[10]=Math.abs(e[10]),r[11]=Math.abs(e[11]),r[12]=Math.abs(e[12]),r[13]=Math.abs(e[13]),r[14]=Math.abs(e[14]),r[15]=Math.abs(e[15]),r},c.equals=function(e,r){return e===r||n(e)&&n(r)&&e[12]===r[12]&&e[13]===r[13]&&e[14]===r[14]&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[8]===r[8]&&e[9]===r[9]&&e[10]===r[10]&&e[3]===r[3]&&e[7]===r[7]&&e[11]===r[11]&&e[15]===r[15]},c.equalsEpsilon=function(e,r,t){if("number"!=typeof t)throw new i("epsilon must be a number");return e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=t&&Math.abs(e[1]-r[1])<=t&&Math.abs(e[2]-r[2])<=t&&Math.abs(e[3]-r[3])<=t&&Math.abs(e[4]-r[4])<=t&&Math.abs(e[5]-r[5])<=t&&Math.abs(e[6]-r[6])<=t&&Math.abs(e[7]-r[7])<=t&&Math.abs(e[8]-r[8])<=t&&Math.abs(e[9]-r[9])<=t&&Math.abs(e[10]-r[10])<=t&&Math.abs(e[11]-r[11])<=t&&Math.abs(e[12]-r[12])<=t&&Math.abs(e[13]-r[13])<=t&&Math.abs(e[14]-r[14])<=t&&Math.abs(e[15]-r[15])<=t},c.getTranslation=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r.x=e[12],r.y=e[13],r.z=e[14],r},c.getRotation=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[4],r[4]=e[5],r[5]=e[6],r[6]=e[8],r[7]=e[9],r[8]=e[10],r};var E=new u,p=new u,y=new r,_=new r(0,0,0,1);return c.inverse=function(e,t){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("result is required");if(u.equalsEpsilon(c.getRotation(e,E),p,a.EPSILON7)&&r.equals(c.getRow(e,3,y),_))return t[0]=0,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=0,t[11]=0,t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=1,t;var o=e[0],f=e[4],l=e[8],h=e[12],w=e[1],d=e[5],m=e[9],T=e[13],R=e[2],A=e[6],v=e[10],N=e[14],I=e[3],S=e[7],g=e[11],M=e[15],O=v*M,q=N*g,b=A*M,x=N*S,P=A*g,L=v*S,C=R*M,F=N*I,U=R*g,D=v*I,B=R*S,z=A*I,G=O*d+x*m+P*T-(q*d+b*m+L*T),V=q*w+C*m+D*T-(O*w+F*m+U*T),X=b*w+F*d+B*T-(x*w+C*d+z*T),H=L*w+U*d+z*m-(P*w+D*d+B*m),W=q*f+b*l+L*h-(O*f+x*l+P*h),Y=O*o+F*l+U*h-(q*o+C*l+D*h),k=x*o+C*f+z*h-(b*o+F*f+B*h),K=P*o+D*f+B*l-(L*o+U*f+z*l);O=l*T,q=h*m,b=f*T,x=h*d,P=f*m,L=l*d,C=o*T,F=h*w,U=o*m,D=l*w,B=o*d,z=f*w;var Z=O*S+x*g+P*M-(q*S+b*g+L*M),j=q*I+C*g+D*M-(O*I+F*g+U*M),Q=b*I+F*S+B*M-(x*I+C*S+z*M),J=L*I+U*S+z*g-(P*I+D*S+B*g),$=b*v+L*N+q*A-(P*N+O*A+x*v),ee=U*N+O*R+F*v-(C*v+D*N+q*R),re=C*A+z*N+x*R-(B*N+b*R+F*A),te=B*v+P*R+D*A-(U*A+z*v+L*R),ne=o*G+f*V+l*X+h*H;if(Math.abs(ne)<a.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return ne=1/ne,t[0]=G*ne,t[1]=V*ne,t[2]=X*ne,t[3]=H*ne,t[4]=W*ne,t[5]=Y*ne,t[6]=k*ne,t[7]=K*ne,t[8]=Z*ne,t[9]=j*ne,t[10]=Q*ne,t[11]=J*ne,t[12]=$*ne,t[13]=ee*ne,t[14]=re*ne,t[15]=te*ne,t},c.inverseTransformation=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");var t=e[0],o=e[1],a=e[2],u=e[4],s=e[5],c=e[6],f=e[8],l=e[9],h=e[10],w=e[12],d=e[13],m=e[14],E=-t*w-o*d-a*m,p=-u*w-s*d-c*m,y=-f*w-l*d-h*m;return r[0]=t,r[1]=u,r[2]=f,r[3]=0,r[4]=o,r[5]=s,r[6]=l,r[7]=0,r[8]=a,r[9]=c,r[10]=h,r[11]=0,r[12]=E,r[13]=p,r[14]=y,r[15]=1,r},c.IDENTITY=o(new c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),c.ZERO=o(new c(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),c.COLUMN0ROW0=0,c.COLUMN0ROW1=1,c.COLUMN0ROW2=2,c.COLUMN0ROW3=3,c.COLUMN1ROW0=4,c.COLUMN1ROW1=5,c.COLUMN1ROW2=6,c.COLUMN1ROW3=7,c.COLUMN2ROW0=8,c.COLUMN2ROW1=9,c.COLUMN2ROW2=10,c.COLUMN2ROW3=11,c.COLUMN3ROW0=12,c.COLUMN3ROW1=13,c.COLUMN3ROW2=14,c.COLUMN3ROW3=15,c.prototype.clone=function(e){return c.clone(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.equalsArray=function(e,r,t){return e[0]===r[t]&&e[1]===r[t+1]&&e[2]===r[t+2]&&e[3]===r[t+3]&&e[4]===r[t+4]&&e[5]===r[t+5]&&e[6]===r[t+6]&&e[7]===r[t+7]&&e[8]===r[t+8]&&e[9]===r[t+9]&&e[10]===r[t+10]&&e[11]===r[t+11]&&e[12]===r[t+12]&&e[13]===r[t+13]&&e[14]===r[t+14]&&e[15]===r[t+15]},c.prototype.equalsEpsilon=function(e,r){return c.equalsEpsilon(this,e,r)},c.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},c}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,r,t,n){"use strict";var i=function(n,i){if(!r(n))throw new t("normal is required.");if(!r(i))throw new t("distance is required.");this.normal=e.clone(n),this.distance=i};i.fromPointNormal=function(n,o,a){if(!r(n))throw new t("point is required.");if(!r(o))throw new t("normal is required.");var u=-e.dot(o,n);return r(a)?(e.clone(o,a.normal),a.distance=u,a):new i(o,u)};var o=new e;return i.fromCartesian4=function(n,a){if(!r(n))throw new t("coefficients is required.");var u=e.fromCartesian4(n,o),s=n.w;return r(a)?(e.clone(u,a.normal),a.distance=s,a):new i(u,s)},i.getPointDistance=function(n,i){if(!r(n))throw new t("plane is required.");if(!r(i))throw new t("point is required.");return e.dot(n.normal,i)+n.distance},i.ORIGIN_XY_PLANE=n(new i(e.UNIT_Z,0)),i.ORIGIN_YZ_PLANE=n(new i(e.UNIT_X,0)),i.ORIGIN_ZX_PLANE=n(new i(e.UNIT_Y,0)),i}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,r,t,n,i,o,a,u){"use strict";var s=function(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)};n(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,n,o){if(!t(e))throw new i("value is required");if(!t(n))throw new i("array is required");o=r(o,0),n[o++]=e.west,n[o++]=e.south,n[o++]=e.east,n[o]=e.north},s.unpack=function(e,n,o){if(!t(e))throw new i("array is required");return n=r(n,0),t(o)||(o=new s),o.west=e[n++],o.south=e[n++],o.east=e[n++],o.north=e[n],o},s.computeWidth=function(e){if(!t(e))throw new i("rectangle is required.");var r=e.east,n=e.west;return n>r&&(r+=u.TWO_PI),r-n},s.computeHeight=function(e){if(!t(e))throw new i("rectangle is required.");return e.north-e.south},s.fromDegrees=function(e,n,i,o,a){return e=u.toRadians(r(e,0)),n=u.toRadians(r(n,0)),i=u.toRadians(r(i,0)),o=u.toRadians(r(o,0)),t(a)?(a.west=e,a.south=n,a.east=i,a.north=o,a):new s(e,n,i,o)},s.fromCartographicArray=function(e,r){if(!t(e))throw new i("cartographics is required.");for(var n=Number.MAX_VALUE,o=-Number.MAX_VALUE,a=Number.MAX_VALUE,u=-Number.MAX_VALUE,c=0,f=e.length;f>c;c++){var l=e[c];n=Math.min(n,l.longitude),o=Math.max(o,l.longitude),a=Math.min(a,l.latitude),u=Math.max(u,l.latitude)}return t(r)?(r.west=n,r.south=a,r.east=o,r.north=u,r):new s(n,a,o,u)},s.clone=function(e,r){return t(e)?t(r)?(r.west=e.west,r.south=e.south,r.east=e.east,r.north=e.north,r):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.west===r.west&&e.south===r.south&&e.east===r.east&&e.north===r.north},s.prototype.equalsEpsilon=function(e,r){if("number"!=typeof r)throw new i("epsilon is required and must be a number.");return t(e)&&Math.abs(this.west-e.west)<=r&&Math.abs(this.south-e.south)<=r&&Math.abs(this.east-e.east)<=r&&Math.abs(this.north-e.north)<=r},s.validate=function(e){if(!t(e))throw new i("rectangle is required");var r=e.north;if("number"!=typeof r)throw new i("north is required to be a number.");if(r<-u.PI_OVER_TWO||r>u.PI_OVER_TWO)throw new i("north must be in the interval [-Pi/2, Pi/2].");var n=e.south;if("number"!=typeof n)throw new i("south is required to be a number.");if(n<-u.PI_OVER_TWO||n>u.PI_OVER_TWO)throw new i("south must be in the interval [-Pi/2, Pi/2].");var o=e.west;if("number"!=typeof o)throw new i("west is required to be a number.");if(o<-Math.PI||o>Math.PI)throw new i("west must be in the interval [-Pi, Pi].");var a=e.east;if("number"!=typeof a)throw new i("east is required to be a number.");if(a<-Math.PI||a>Math.PI)throw new i("east must be in the interval [-Pi, Pi].")},s.southwest=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.west,n.latitude=r.south,n.height=0,n):new e(r.west,r.south)},s.northwest=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.west,n.latitude=r.north,n.height=0,n):new e(r.west,r.north)},s.northeast=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.east,n.latitude=r.north,n.height=0,n):new e(r.east,r.north)},s.southeast=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.east,n.latitude=r.south,n.height=0,n):new e(r.east,r.south)},s.center=function(r,n){if(!t(r))throw new i("rectangle is required");var o=r.east,a=r.west;a>o&&(o+=u.TWO_PI);var s=u.negativePiToPi(.5*(a+o)),c=.5*(r.south+r.north);return t(n)?(n.longitude=s,n.latitude=c,n.height=0,n):new e(s,c)},s.intersection=function(e,r,n){if(!t(e))throw new i("rectangle is required");if(!t(r))throw new i("otherRectangle is required.");var o=e.east,a=e.west,c=r.east,f=r.west;a>o&&c>0?o+=u.TWO_PI:f>c&&o>0&&(c+=u.TWO_PI),a>o&&0>f?f+=u.TWO_PI:f>c&&0>a&&(a+=u.TWO_PI);var l=u.negativePiToPi(Math.max(a,f)),h=u.negativePiToPi(Math.min(o,c));if((e.west<e.east||r.west<r.east)&&l>=h)return void 0;var w=Math.max(e.south,r.south),d=Math.min(e.north,r.north);return w>=d?void 0:t(n)?(n.west=l,n.south=w,n.east=h,n.north=d,n):new s(l,w,h,d)},s.contains=function(e,r){if(!t(e))throw new i("rectangle is required");if(!t(r))throw new i("cartographic is required.");var n=r.longitude,o=r.latitude,a=e.west,s=e.east;return a>s&&(s+=u.TWO_PI,0>n&&(n+=u.TWO_PI)),(n>a||u.equalsEpsilon(n,a,u.EPSILON14))&&(s>n||u.equalsEpsilon(n,s,u.EPSILON14))&&o>=e.south&&o<=e.north};var c=new e;return s.subsample=function(e,n,a,f){if(!t(e))throw new i("rectangle is required");n=r(n,o.WGS84),a=r(a,0),t(f)||(f=[]);var l=0,h=e.north,w=e.south,d=e.east,m=e.west,E=c;E.height=a,E.longitude=m,E.latitude=h,f[l]=n.cartographicToCartesian(E,f[l]),l++,E.longitude=d,f[l]=n.cartographicToCartesian(E,f[l]),l++,E.latitude=w,f[l]=n.cartographicToCartesian(E,f[l]),l++,E.longitude=m,f[l]=n.cartographicToCartesian(E,f[l]),l++,0>h?E.latitude=h:w>0?E.latitude=w:E.latitude=0;for(var p=1;8>p;++p)E.longitude=-Math.PI+p*u.PI_OVER_TWO,s.contains(e,E)&&(f[l]=n.cartographicToCartesian(E,f[l]),l++);return 0===E.latitude&&(E.longitude=m,f[l]=n.cartographicToCartesian(E,f[l]),l++,E.longitude=d,f[l]=n.cartographicToCartesian(E,f[l]),l++),f.length=l,f},s.MAX_VALUE=a(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Plane","./Rectangle"],function(e,r,t,n,i,o,a,u,s,c,f,l,h){
"use strict";var w=function(r,n){this.center=e.clone(t(r,e.ZERO)),this.radius=t(n,0)},d=new e,m=new e,E=new e,p=new e,y=new e,_=new e,T=new e,R=new e,A=new e,v=new e,N=new e,I=new e;w.fromPoints=function(r,t){if(n(t)||(t=new w),!n(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;for(var i=e.clone(r[0],T),o=e.clone(i,d),a=e.clone(i,m),u=e.clone(i,E),s=e.clone(i,p),c=e.clone(i,y),f=e.clone(i,_),l=r.length,h=1;l>h;h++){e.clone(r[h],i);var S=i.x,g=i.y,M=i.z;S<o.x&&e.clone(i,o),S>s.x&&e.clone(i,s),g<a.y&&e.clone(i,a),g>c.y&&e.clone(i,c),M<u.z&&e.clone(i,u),M>f.z&&e.clone(i,f)}var O=e.magnitudeSquared(e.subtract(s,o,R)),q=e.magnitudeSquared(e.subtract(c,a,R)),b=e.magnitudeSquared(e.subtract(f,u,R)),x=o,P=s,L=O;q>L&&(L=q,x=a,P=c),b>L&&(L=b,x=u,P=f);var C=A;C.x=.5*(x.x+P.x),C.y=.5*(x.y+P.y),C.z=.5*(x.z+P.z);var F=e.magnitudeSquared(e.subtract(P,C,R)),U=Math.sqrt(F),D=v;D.x=o.x,D.y=a.y,D.z=u.z;var B=N;B.x=s.x,B.y=c.y,B.z=f.z;var z=e.multiplyByScalar(e.add(D,B,R),.5,I),G=0;for(h=0;l>h;h++){e.clone(r[h],i);var V=e.magnitude(e.subtract(i,z,R));V>G&&(G=V);var X=e.magnitudeSquared(e.subtract(i,C,R));if(X>F){var H=Math.sqrt(X);U=.5*(U+H),F=U*U;var W=H-U;C.x=(U*C.x+W*i.x)/H,C.y=(U*C.y+W*i.y)/H,C.z=(U*C.z+W*i.z)/H}}return G>U?(e.clone(C,t.center),t.radius=U):(e.clone(z,t.center),t.radius=G),t};var S=new u,g=new e,M=new e,O=new r,q=new r;w.fromRectangle2D=function(e,r,t){return w.fromRectangleWithHeights2D(e,r,0,0,t)},w.fromRectangleWithHeights2D=function(r,i,o,a,u){if(n(u)||(u=new w),!n(r))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;i=t(i,S),h.southwest(r,O),O.height=o,h.northeast(r,q),q.height=a;var s=i.project(O,g),c=i.project(q,M),f=c.x-s.x,l=c.y-s.y,d=c.z-s.z;u.radius=.5*Math.sqrt(f*f+l*l+d*d);var m=u.center;return m.x=s.x+.5*f,m.y=s.y+.5*l,m.z=s.z+.5*d,u};var b=[];w.fromRectangle3D=function(e,r,i,o){r=t(r,a.WGS84),i=t(i,0);var u;return n(e)&&(u=h.subsample(e,r,i,b)),w.fromPoints(u,o)},w.fromVertices=function(r,i,a,u){if(n(u)||(u=new w),!n(r)||0===r.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;if(i=t(i,e.ZERO),a=t(a,3),3>a)throw new o("stride must be 3 or greater.");var s=T;s.x=r[0]+i.x,s.y=r[1]+i.y,s.z=r[2]+i.z;for(var c=e.clone(s,d),f=e.clone(s,m),l=e.clone(s,E),h=e.clone(s,p),S=e.clone(s,y),g=e.clone(s,_),M=r.length,O=0;M>O;O+=a){var q=r[O]+i.x,b=r[O+1]+i.y,x=r[O+2]+i.z;s.x=q,s.y=b,s.z=x,q<c.x&&e.clone(s,c),q>h.x&&e.clone(s,h),b<f.y&&e.clone(s,f),b>S.y&&e.clone(s,S),x<l.z&&e.clone(s,l),x>g.z&&e.clone(s,g)}var P=e.magnitudeSquared(e.subtract(h,c,R)),L=e.magnitudeSquared(e.subtract(S,f,R)),C=e.magnitudeSquared(e.subtract(g,l,R)),F=c,U=h,D=P;L>D&&(D=L,F=f,U=S),C>D&&(D=C,F=l,U=g);var B=A;B.x=.5*(F.x+U.x),B.y=.5*(F.y+U.y),B.z=.5*(F.z+U.z);var z=e.magnitudeSquared(e.subtract(U,B,R)),G=Math.sqrt(z),V=v;V.x=c.x,V.y=f.y,V.z=l.z;var X=N;X.x=h.x,X.y=S.y,X.z=g.z;var H=e.multiplyByScalar(e.add(V,X,R),.5,I),W=0;for(O=0;M>O;O+=a){s.x=r[O]+i.x,s.y=r[O+1]+i.y,s.z=r[O+2]+i.z;var Y=e.magnitude(e.subtract(s,H,R));Y>W&&(W=Y);var k=e.magnitudeSquared(e.subtract(s,B,R));if(k>z){var K=Math.sqrt(k);G=.5*(G+K),z=G*G;var Z=K-G;B.x=(G*B.x+Z*s.x)/K,B.y=(G*B.y+Z*s.y)/K,B.z=(G*B.z+Z*s.z)/K}}return W>G?(e.clone(B,u.center),u.radius=G):(e.clone(H,u.center),u.radius=W),u},w.fromCornerPoints=function(r,t,i){if(!n(r)||!n(t))throw new o("corner and oppositeCorner are required.");n(i)||(i=new w);var a=i.center;return e.add(r,t,a),e.multiplyByScalar(a,.5,a),i.radius=e.distance(a,t),i},w.fromEllipsoid=function(r,t){if(!n(r))throw new o("ellipsoid is required.");return n(t)||(t=new w),e.clone(e.ZERO,t.center),t.radius=r.maximumRadius,t};var x=new e;w.fromBoundingSpheres=function(r,t){if(n(t)||(t=new w),!n(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;var i=r.length;if(1===i)return w.clone(r[0],t);if(2===i)return w.union(r[0],r[1],t);for(var o=[],a=0;i>a;a++)o.push(r[a].center);t=w.fromPoints(o,t);var u=t.center,s=t.radius;for(a=0;i>a;a++){var c=r[a];s=Math.max(s,e.distance(u,c.center,x)+c.radius)}return t.radius=s,t},w.clone=function(r,t){return n(r)?n(t)?(t.center=e.clone(r.center,t.center),t.radius=r.radius,t):new w(r.center,r.radius):void 0},w.packedLength=4,w.pack=function(e,r,i){if(!n(e))throw new o("value is required");if(!n(r))throw new o("array is required");i=t(i,0);var a=e.center;r[i++]=a.x,r[i++]=a.y,r[i++]=a.z,r[i]=e.radius},w.unpack=function(e,r,i){if(!n(e))throw new o("array is required");r=t(r,0),n(i)||(i=new w);var a=i.center;return a.x=e[r++],a.y=e[r++],a.z=e[r++],i.radius=e[r],i};var P=new e,L=new e;w.union=function(r,t,i){if(!n(r))throw new o("left is required.");if(!n(t))throw new o("right is required.");n(i)||(i=new w);var a=r.center,u=r.radius,s=t.center,c=t.radius,f=e.subtract(s,a,P),l=e.magnitude(f);if(u>=l+c)return r.clone(i),i;if(c>=l+u)return t.clone(i),i;var h=.5*(u+l+c),d=e.multiplyByScalar(f,(-u+h)/l,L);return e.add(d,a,d),e.clone(d,i.center),i.radius=h,i};var C=new e;w.expand=function(r,t,i){if(!n(r))throw new o("sphere is required.");if(!n(t))throw new o("point is required.");i=w.clone(r,i);var a=e.magnitude(e.subtract(t,i.center,C));return a>i.radius&&(i.radius=a),i},w.intersectPlane=function(r,t){if(!n(r))throw new o("sphere is required.");if(!n(t))throw new o("plane is required.");var i=r.center,a=r.radius,u=t.normal,c=e.dot(u,i)+t.distance;return-a>c?s.OUTSIDE:a>c?s.INTERSECTING:s.INSIDE},w.transform=function(e,r,t){if(!n(e))throw new o("sphere is required.");if(!n(r))throw new o("transform is required.");return n(t)||(t=new w),t.center=f.multiplyByPoint(r,e.center,t.center),t.radius=f.getMaximumScale(r)*e.radius,t};var F=new e;w.distanceSquaredTo=function(r,t){if(!n(r))throw new o("sphere is required.");if(!n(t))throw new o("cartesian is required.");var i=e.subtract(r.center,t,F);return e.magnitudeSquared(i)-r.radius*r.radius},w.transformWithoutScale=function(e,r,t){if(!n(e))throw new o("sphere is required.");if(!n(r))throw new o("transform is required.");return n(t)||(t=new w),t.center=f.multiplyByPoint(r,e.center,t.center),t.radius=e.radius,t};var U=new e;w.computePlaneDistances=function(r,t,i,a){if(!n(r))throw new o("sphere is required.");if(!n(t))throw new o("position is required.");if(!n(i))throw new o("direction is required.");n(a)||(a=new c);var u=e.subtract(r.center,t,U),s=e.dot(i,u);return a.start=s-r.radius,a.stop=s+r.radius,a};for(var D=new e,B=new e,z=new e,G=new e,V=new e,X=new r,H=new Array(8),W=0;8>W;++W)H[W]=new e;var Y=new u;return w.projectTo2D=function(r,i,a){if(!n(r))throw new o("sphere is required.");i=t(i,Y);var u=i.ellipsoid,s=r.center,c=r.radius,f=u.geodeticSurfaceNormal(s,D),l=e.cross(e.UNIT_Z,f,B);e.normalize(l,l);var h=e.cross(f,l,z);e.normalize(h,h),e.multiplyByScalar(f,c,f),e.multiplyByScalar(h,c,h),e.multiplyByScalar(l,c,l);var d=e.negate(h,V),m=e.negate(l,G),E=H,p=E[0];e.add(f,h,p),e.add(p,l,p),p=E[1],e.add(f,h,p),e.add(p,m,p),p=E[2],e.add(f,d,p),e.add(p,m,p),p=E[3],e.add(f,d,p),e.add(p,l,p),e.negate(f,f),p=E[4],e.add(f,h,p),e.add(p,l,p),p=E[5],e.add(f,h,p),e.add(p,m,p),p=E[6],e.add(f,d,p),e.add(p,m,p),p=E[7],e.add(f,d,p),e.add(p,l,p);for(var y=E.length,_=0;y>_;++_){var T=E[_];e.add(s,T,T);var R=u.cartesianToCartographic(T,X);i.project(R,T)}a=w.fromPoints(E,a),s=a.center;var A=s.x,v=s.y,N=s.z;return s.x=N,s.y=A,s.z=v,a},w.isOccluded=function(e,r){if(!n(e))throw new o("sphere is required.");if(!n(r))throw new o("occluder is required.");return!r.isBoundingSphereVisible(e)},w.equals=function(r,t){return r===t||n(r)&&n(t)&&e.equals(r.center,t.center)&&r.radius===t.radius},w.prototype.intersectPlane=function(e){return w.intersectPlane(this,e)},w.prototype.distanceSquaredTo=function(e){return w.distanceSquaredTo(this,e)},w.prototype.computePlaneDistances=function(e,r,t){return w.computePlaneDistances(this,e,r,t)},w.prototype.isOccluded=function(e){return w.isOccluded(this,e)},w.prototype.equals=function(e){return w.equals(this,e)},w.prototype.clone=function(e){return w.clone(this,e)},w}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t){this.x=e(r,0),this.y=e(t,0)};o.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new o(e,t)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t):new o(e.x,e.y):void 0},o.fromCartesian3=o.clone,o.fromCartesian4=o.clone,o.packedLength=2,o.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.x,i[o]=n.y},o.unpack=function(n,i,a){if(!r(n))throw new t("array is required");return i=e(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i],a},o.fromArray=o.unpack,o.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y)},o.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y)},o.minimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i},o.maximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitude(a)},o.distanceSquared=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitudeSquared(a)},o.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=o.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n},o.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y},o.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i},o.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i},o.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i},o.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i},o.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i},o.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n},o.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n};var u=new o;o.lerp=function(e,n,i,a){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(n,i,u),a=o.multiplyByScalar(e,1-i,a),o.add(u,a,a)};var s=new o,c=new o;o.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return o.normalize(e,s),o.normalize(n,c),i.acosClamped(o.dot(s,c))};var f=new o;return o.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=o.normalize(e,f);return o.abs(i,i),n=i.x<=i.y?o.clone(o.UNIT_X,n):o.clone(o.UNIT_Y,n)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},o.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]},o.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)},o.ZERO=n(new o(0,0)),o.UNIT_X=n(new o(1,0)),o.UNIT_Y=n(new o(0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r,t){return o.equalsEpsilon(this,e,r,t)},o.prototype.toString=function(){return"("+this.x+", "+this.y+")"},o}),define("Renderer/WebGLConstants",["../Core/freezeObject"],function(e){"use strict";var r={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return e(r)}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,r){"use strict";var t,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return r(i,{element:{get:function(){return i.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(t))return t;t=!1;var r=document.body;if("function"==typeof r.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",t=!0;for(var i,o=["webkit","moz","o","ms","khtml"],a=0,u=o.length;u>a;++a){var s=o[a];i=s+"RequestFullscreen","function"==typeof r[i]?(n.requestFullscreen=i,t=!0):(i=s+"RequestFullScreen","function"==typeof r[i]&&(n.requestFullscreen=i,t=!0)),i=s+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=s+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=s+"FullscreenEnabled",e(document[i])?n.fullscreenEnabled=i:(i=s+"FullScreenEnabled",e(document[i])&&(n.fullscreenEnabled=i)),i=s+"FullscreenElement",e(document[i])?n.fullscreenElement=i:(i=s+"FullScreenElement",e(document[i])&&(n.fullscreenElement=i)),i=s+"fullscreenchange",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=s+"fullscreenerror",e(document["on"+i])&&("ms"===s&&(i="MSFullscreenError"),n.fullscreenerror=i)}return t},i.requestFullscreen=function(e){i.supportsFullscreen()&&e[n.requestFullscreen]()},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,r,t){"use strict";function n(e){for(var r=e.split("."),t=0,n=r.length;n>t;++t)r[t]=parseInt(r[t],10);return r}function i(){if(!r(E)){E=!1;var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(E=!0,p=n(e[1]))}return E}function o(){return i()&&p}function a(){if(!r(y)&&(y=!1,!i()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(y=!0,_=n(e[1]))}return y}function u(){return a()&&_}function s(){if(!r(T)){T=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==e&&(T=!0,R=n(e[1]),R.isNightly=!!e[2])}return T}function c(){return s()&&R}function f(){if(!r(A)){A=!1;var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(A=!0,v=n(e[1]))):"Netscape"===navigator.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(A=!0,v=n(e[1])))}return A}function l(){return f()&&v}function h(){if(!r(N)){N=!1;var e=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(N=!0,I=n(e[1]))}return N}function w(){return r(S)||(S=/Windows/i.test(navigator.appVersion)),S}function d(){return h()&&I}function m(){return r(g)||(g=r(window.PointerEvent)&&(!r(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),g}var E,p,y,_,T,R,A,v,N,I,S,g,M={isChrome:i,chromeVersion:o,isSafari:a,safariVersion:u,isWebkit:s,webkitVersion:c,isInternetExplorer:f,internetExplorerVersion:l,isFirefox:h,firefoxVersion:d,isWindows:w,hardwareConcurrency:e(navigator.hardwareConcurrency,3),supportsPointerEvents:m};return M.supportsFullscreen=function(){return t.supportsFullscreen()},M.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},M.supportsWebWorkers=function(){return"undefined"!=typeof Worker},M}),define("Core/ComponentDatatype",["../Renderer/WebGLConstants","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,r,t,n,i,o){"use strict";if(!i.supportsTypedArrays())return{};var a={BYTE:e.BYTE,UNSIGNED_BYTE:e.UNSIGNED_BYTE,SHORT:e.SHORT,UNSIGNED_SHORT:e.UNSIGNED_SHORT,FLOAT:e.FLOAT,DOUBLE:e.DOUBLE};return a.getSizeInBytes=function(e){if(!t(e))throw new n("value is required.");switch(e){case a.BYTE:return Int8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.SHORT:return Int16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case a.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new n("componentDatatype is not a valid value.")}},a.fromTypedArray=function(e){return e instanceof Int8Array?a.BYTE:e instanceof Uint8Array?a.UNSIGNED_BYTE:e instanceof Int16Array?a.SHORT:e instanceof Uint16Array?a.UNSIGNED_SHORT:e instanceof Float32Array?a.FLOAT:e instanceof Float64Array?a.DOUBLE:void 0},a.validate=function(e){return t(e)&&(e===a.BYTE||e===a.UNSIGNED_BYTE||e===a.SHORT||e===a.UNSIGNED_SHORT||e===a.FLOAT||e===a.DOUBLE)},a.createTypedArray=function(e,r){if(!t(e))throw new n("componentDatatype is required.");if(!t(r))throw new n("valuesOrLength is required.");switch(e){case a.BYTE:return new Int8Array(r);case a.UNSIGNED_BYTE:return new Uint8Array(r);case a.SHORT:return new Int16Array(r);case a.UNSIGNED_SHORT:return new Uint16Array(r);case a.FLOAT:return new Float32Array(r);case a.DOUBLE:return new Float64Array(r);default:throw new n("componentDatatype is not a valid value.")}},a.createArrayBufferView=function(e,i,o,u){if(!t(e))throw new n("componentDatatype is required.");if(!t(i))throw new n("buffer is required.");switch(o=r(o,0),u=r(u,(i.byteLength-o)/a.getSizeInBytes(e)),e){case a.BYTE:return new Int8Array(i,o,u);case a.UNSIGNED_BYTE:return new Uint8Array(i,o,u);case a.SHORT:return new Int16Array(i,o,u);case a.UNSIGNED_SHORT:return new Uint16Array(i,o,u);case a.FLOAT:return new Float32Array(i,o,u);case a.DOUBLE:return new Float64Array(i,o,u);default:throw new n("componentDatatype is not a valid value.")}},o(a)}),define("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,r,t,n,i,o,a,u){
"use strict";var s=function(e,t,n,i){this.x=r(e,0),this.y=r(t,0),this.z=r(n,0),this.w=r(i,0)},c=new e;s.fromAxisAngle=function(r,i,o){if(!t(r))throw new n("axis is required.");if("number"!=typeof i)throw new n("angle is required and must be a number.");var a=i/2,u=Math.sin(a);c=e.normalize(r,c);var f=c.x*u,l=c.y*u,h=c.z*u,w=Math.cos(a);return t(o)?(o.x=f,o.y=l,o.z=h,o.w=w,o):new s(f,l,h,w)};var f=[1,2,0],l=new Array(3);s.fromRotationMatrix=function(e,r){if(!t(e))throw new n("matrix is required.");var i,o,a,c,h,w=e[u.COLUMN0ROW0],d=e[u.COLUMN1ROW1],m=e[u.COLUMN2ROW2],E=w+d+m;if(E>0)i=Math.sqrt(E+1),h=.5*i,i=.5/i,o=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*i,a=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*i,c=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*i;else{var p=f,y=0;d>w&&(y=1),m>w&&m>d&&(y=2);var _=p[y],T=p[_];i=Math.sqrt(e[u.getElementIndex(y,y)]-e[u.getElementIndex(_,_)]-e[u.getElementIndex(T,T)]+1);var R=l;R[y]=.5*i,i=.5/i,h=(e[u.getElementIndex(T,_)]-e[u.getElementIndex(_,T)])*i,R[_]=(e[u.getElementIndex(_,y)]+e[u.getElementIndex(y,_)])*i,R[T]=(e[u.getElementIndex(T,y)]+e[u.getElementIndex(y,T)])*i,o=-R[0],a=-R[1],c=-R[2]}return t(r)?(r.x=o,r.y=a,r.z=c,r.w=h,r):new s(o,a,c,h)};var h=new s;s.fromHeadingPitchRoll=function(r,i,o,a){if(!t(r))throw new n("heading is required.");if(!t(i))throw new n("pitch is required.");if(!t(o))throw new n("roll is required.");var u=s.fromAxisAngle(e.UNIT_X,o,h),c=s.fromAxisAngle(e.UNIT_Y,-i,a);a=s.multiply(c,u,c);var f=s.fromAxisAngle(e.UNIT_Z,-r,h);return s.multiply(f,a,a)};var w=new e,d=new e,m=new s,E=new s,p=new s;s.packedLength=4,s.pack=function(e,i,o){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");o=r(o,0),i[o++]=e.x,i[o++]=e.y,i[o++]=e.z,i[o]=e.w},s.unpack=function(e,i,o){if(!t(e))throw new n("array is required");return i=r(i,0),t(o)||(o=new s),o.x=e[i],o.y=e[i+1],o.z=e[i+2],o.w=e[i+3],o},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,r,t,n){s.unpack(e,4*t,p),s.conjugate(p,p);for(var i=0,o=t-r+1;o>i;i++){var a=3*i;s.unpack(e,4*(r+i),m),s.multiply(m,p,m),m.w<0&&s.negate(m,m),s.computeAxis(m,w);var u=s.computeAngle(m);n[a]=w.x*u,n[a+1]=w.y*u,n[a+2]=w.z*u}},s.unpackInterpolationResult=function(r,n,i,o,a){t(a)||(a=new s),e.fromArray(r,0,d);var u=e.magnitude(d);return s.unpack(n,4*o,E),0===u?s.clone(s.IDENTITY,m):s.fromAxisAngle(d,u,m),s.multiply(m,E,a)},s.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,r){if(!t(e))throw new n("quaternion is required");if(!t(r))throw new n("result is required");return r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=e.w,r},s.magnitudeSquared=function(e){if(!t(e))throw new n("quaternion is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,r){if(!t(r))throw new n("result is required");var i=1/s.magnitude(e),o=e.x*i,a=e.y*i,u=e.z*i,c=e.w*i;return r.x=o,r.y=a,r.z=u,r.w=c,r},s.inverse=function(e,r){if(!t(r))throw new n("result is required");var i=s.magnitudeSquared(e);return r=s.conjugate(e,r),s.multiplyByScalar(r,1/i,r)},s.add=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i.x=e.x+r.x,i.y=e.y+r.y,i.z=e.z+r.z,i.w=e.w+r.w,i},s.subtract=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i.x=e.x-r.x,i.y=e.y-r.y,i.z=e.z-r.z,i.w=e.w-r.w,i},s.negate=function(e,r){if(!t(e))throw new n("quaternion is required");if(!t(r))throw new n("result is required");return r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r},s.dot=function(e,r){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");return e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w},s.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");var o=e.x,a=e.y,u=e.z,s=e.w,c=r.x,f=r.y,l=r.z,h=r.w,w=s*c+o*h+a*l-u*f,d=s*f-o*l+a*h+u*c,m=s*l+o*f-a*c+u*h,E=s*h-o*c-a*f-u*l;return i.x=w,i.y=d,i.z=m,i.w=E,i},s.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("quaternion is required");if("number"!=typeof r)throw new n("scalar is required and must be a number.");if(!t(i))throw new n("result is required");return i.x=e.x*r,i.y=e.y*r,i.z=e.z*r,i.w=e.w*r,i},s.divideByScalar=function(e,r,i){if(!t(e))throw new n("quaternion is required");if("number"!=typeof r)throw new n("scalar is required and must be a number.");if(!t(i))throw new n("result is required");return i.x=e.x/r,i.y=e.y/r,i.z=e.z/r,i.w=e.w/r,i},s.computeAxis=function(e,r){if(!t(e))throw new n("quaternion is required");if(!t(r))throw new n("result is required");var i=e.w;if(Math.abs(i-1)<a.EPSILON6)return r.x=r.y=r.z=0,r;var o=1/Math.sqrt(1-i*i);return r.x=e.x*o,r.y=e.y*o,r.z=e.z*o,r},s.computeAngle=function(e){if(!t(e))throw new n("quaternion is required");return Math.abs(e.w-1)<a.EPSILON6?0:2*Math.acos(e.w)};var y=new s;s.lerp=function(e,r,i,o){if(!t(e))throw new n("start is required.");if(!t(r))throw new n("end is required.");if("number"!=typeof i)throw new n("t is required and must be a number.");if(!t(o))throw new n("result is required");return y=s.multiplyByScalar(r,i,y),o=s.multiplyByScalar(e,1-i,o),s.add(y,o,o)};var _=new s,T=new s,R=new s;s.slerp=function(e,r,i,o){if(!t(e))throw new n("start is required.");if(!t(r))throw new n("end is required.");if("number"!=typeof i)throw new n("t is required and must be a number.");if(!t(o))throw new n("result is required");var u=s.dot(e,r),c=r;if(0>u&&(u=-u,c=_=s.negate(r,_)),1-u<a.EPSILON6)return s.lerp(e,c,i,o);var f=Math.acos(u);return T=s.multiplyByScalar(e,Math.sin((1-i)*f),T),R=s.multiplyByScalar(c,Math.sin(i*f),R),o=s.add(T,R,o),s.multiplyByScalar(o,1/Math.sin(f),o)},s.log=function(r,i){if(!t(r))throw new n("quaternion is required.");if(!t(i))throw new n("result is required");var o=a.acosClamped(r.w),u=0;return 0!==o&&(u=o/Math.sin(o)),e.multiplyByScalar(r,u,i)},s.exp=function(r,i){if(!t(r))throw new n("cartesian is required.");if(!t(i))throw new n("result is required");var o=e.magnitude(r),a=0;return 0!==o&&(a=Math.sin(o)/o),i.x=r.x*a,i.y=r.y*a,i.z=r.z*a,i.w=Math.cos(o),i};var A=new e,v=new e,N=new s,I=new s;s.computeInnerQuadrangle=function(r,i,o,a){if(!t(r)||!t(i)||!t(o))throw new n("q0, q1, and q2 are required.");if(!t(a))throw new n("result is required");var u=s.conjugate(i,N);s.multiply(u,o,I);var c=s.log(I,A);s.multiply(u,r,I);var f=s.log(I,v);return e.add(c,f,c),e.multiplyByScalar(c,.25,c),e.negate(c,c),s.exp(c,N),s.multiply(i,N,a)},s.squad=function(e,r,i,o,a,u){if(!(t(e)&&t(r)&&t(i)&&t(o)))throw new n("q0, q1, s0, and s1 are required.");if("number"!=typeof a)throw new n("t is required and must be a number.");if(!t(u))throw new n("result is required");var c=s.slerp(e,r,a,N),f=s.slerp(i,o,a,I);return s.slerp(c,f,2*a*(1-a),u)};for(var S=new s,g=1.9011074535173003,M=i.supportsTypedArrays()?new Float32Array(8):[],O=i.supportsTypedArrays()?new Float32Array(8):[],q=i.supportsTypedArrays()?new Float32Array(8):[],b=i.supportsTypedArrays()?new Float32Array(8):[],x=0;7>x;++x){var P=x+1,L=2*P+1;M[x]=1/(P*L),O[x]=P/L}return M[7]=g/136,O[7]=8*g/17,s.fastSlerp=function(e,r,i,o){if(!t(e))throw new n("start is required.");if(!t(r))throw new n("end is required.");if("number"!=typeof i)throw new n("t is required and must be a number.");if(!t(o))throw new n("result is required");var a,u=s.dot(e,r);u>=0?a=1:(a=-1,u=-u);for(var c=u-1,f=1-i,l=i*i,h=f*f,w=7;w>=0;--w)q[w]=(M[w]*l-O[w])*c,b[w]=(M[w]*h-O[w])*c;var d=a*i*(1+q[0]*(1+q[1]*(1+q[2]*(1+q[3]*(1+q[4]*(1+q[5]*(1+q[6]*(1+q[7])))))))),m=f*(1+b[0]*(1+b[1]*(1+b[2]*(1+b[3]*(1+b[4]*(1+b[5]*(1+b[6]*(1+b[7])))))))),E=s.multiplyByScalar(e,m,S);return s.multiplyByScalar(r,d,o),s.add(E,o,o)},s.fastSquad=function(e,r,i,o,a,u){if(!(t(e)&&t(r)&&t(i)&&t(o)))throw new n("q0, q1, s0, and s1 are required.");if("number"!=typeof a)throw new n("t is required and must be a number.");if(!t(u))throw new n("result is required");var c=s.fastSlerp(e,r,a,N),f=s.fastSlerp(i,o,a,I);return s.fastSlerp(c,f,2*a*(1-a),u)},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},s.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon is required and must be a number.");return e===r||t(e)&&t(r)&&Math.abs(e.x-r.x)<=i&&Math.abs(e.y-r.y)<=i&&Math.abs(e.z-r.z)<=i&&Math.abs(e.w-r.w)<=i},s.ZERO=o(new s(0,0,0,0)),s.IDENTITY=o(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,r){return s.equalsEpsilon(this,e,r)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/EllipseGeometryLibrary",["./Cartesian3","./Math","./Matrix3","./Quaternion"],function(e,r,t,n){"use strict";function i(r,i,o,f,l,h,w,d,m,E){var p=r+i;e.multiplyByScalar(f,Math.cos(p),a),e.multiplyByScalar(o,Math.sin(p),u),e.add(a,u,a);var y=Math.cos(r);y*=y;var _=Math.sin(r);_*=_;var T=h/Math.sqrt(w*y+l*_),R=T/d;return n.fromAxisAngle(a,R,s),t.fromQuaternion(s,c),t.multiplyByVector(c,m,E),e.normalize(E,E),e.multiplyByScalar(E,d,E),E}var o={},a=new e,u=new e,s=new n,c=new t,f=new e,l=new e,h=new e,w=new e;o.raisePositionsToHeight=function(r,t,n){for(var i=t.ellipsoid,o=t.height,a=t.extrudedHeight,u=n?r.length/3*2:r.length/3,s=new Float64Array(3*u),c=r.length,d=n?c:0,m=0;c>m;m+=3){var E=m+1,p=m+2,y=e.fromArray(r,m,f);i.scaleToGeodeticSurface(y,y);var _=e.clone(y,l),T=i.geodeticSurfaceNormal(y,w),R=e.multiplyByScalar(T,o,h);e.add(y,R,y),n&&(e.multiplyByScalar(T,a,R),e.add(_,R,_),s[m+d]=_.x,s[E+d]=_.y,s[p+d]=_.z),s[m]=y.x,s[E]=y.y,s[p]=y.z}return s};var d=new e,m=new e,E=new e;return o.computeEllipsePositions=function(t,n,o){var a=t.semiMinorAxis,u=t.semiMajorAxis,s=t.rotation,c=t.center,w=8*t.granularity,p=a*a,y=u*u,_=u*a,T=e.magnitude(c),R=e.normalize(c,d),A=e.cross(e.UNIT_Z,c,m);A=e.normalize(A,A);var v=e.cross(R,A,E),N=1+Math.ceil(r.PI_OVER_TWO/w),I=r.PI_OVER_TWO/(N-1),S=r.PI_OVER_TWO-N*I;0>S&&(N-=Math.ceil(Math.abs(S)/I));var g,M,O,q,b,x=2*N*(N+1),P=n?new Array(3*x):void 0,L=0,C=f,F=l,U=3*(2*N+2*(N-1)),D=U-1,B=0,z=o?new Array(U):void 0;for(S=r.PI_OVER_TWO,g=0;N>g;++g){if(C=i(S,s,v,A,p,_,y,T,R,C),F=i(Math.PI-S,s,v,A,p,_,y,T,R,F),n){for(P[L++]=C.x,P[L++]=C.y,P[L++]=C.z,O=2*g+2,M=1;O-1>M;++M)q=M/(O-1),b=e.lerp(C,F,q,h),P[L++]=b.x,P[L++]=b.y,P[L++]=b.z;P[L++]=F.x,P[L++]=F.y,P[L++]=F.z}o&&(z[D--]=C.z,z[D--]=C.y,z[D--]=C.x,0!==g&&(z[B++]=F.x,z[B++]=F.y,z[B++]=F.z)),S=r.PI_OVER_TWO-(g+1)*I}for(g=N;g>0;--g){if(S=r.PI_OVER_TWO-(g-1)*I,C=i(-S,s,v,A,p,_,y,T,R,C),F=i(S+Math.PI,s,v,A,p,_,y,T,R,F),n){for(P[L++]=C.x,P[L++]=C.y,P[L++]=C.z,O=2*(g-1)+2,M=1;O-1>M;++M)q=M/(O-1),b=e.lerp(C,F,q,h),P[L++]=b.x,P[L++]=b.y,P[L++]=b.z;P[L++]=F.x,P[L++]=F.y,P[L++]=F.z}o&&(z[D--]=C.z,z[D--]=C.y,z[D--]=C.x,1!==g&&(z[B++]=F.x,z[B++]=F.y,z[B++]=F.z))}var G={};return n&&(G.positions=P,G.numPts=N),o&&(G.outerPositions=z),G},o}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var r={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(r)}),define("Core/PrimitiveType",["../Renderer/WebGLConstants","./freezeObject"],function(e,r){"use strict";var t={POINTS:e.POINTS,LINES:e.LINES,LINE_LOOP:e.LINE_LOOP,LINE_STRIP:e.LINE_STRIP,TRIANGLES:e.TRIANGLES,TRIANGLE_STRIP:e.TRIANGLE_STRIP,TRIANGLE_FAN:e.TRIANGLE_FAN,validate:function(e){return e===t.POINTS||e===t.LINES||e===t.LINE_LOOP||e===t.LINE_STRIP||e===t.TRIANGLES||e===t.TRIANGLE_STRIP||e===t.TRIANGLE_FAN}};return r(t)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,r,t,n,i){"use strict";var o=function(o){if(o=e(o,e.EMPTY_OBJECT),!r(o.attributes))throw new t("options.attributes is required.");this.attributes=o.attributes,this.indices=o.indices,this.primitiveType=e(o.primitiveType,i.TRIANGLES),this.boundingSphere=o.boundingSphere,this.geometryType=e(o.geometryType,n.NONE),this.boundingSphereCV=void 0};return o.computeNumberOfVertices=function(e){if(!r(e))throw new t("geometry is required.");var n=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&r(e.attributes[i])&&r(e.attributes[i].values)){var o=e.attributes[i],a=o.values.length/o.componentsPerAttribute;if(n!==a&&-1!==n)throw new t("All attribute lists must have the same number of attributes.");n=a}return n},o}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.componentDatatype))throw new t("options.componentDatatype is required.");if(!r(n.componentsPerAttribute))throw new t("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new t("options.componentsPerAttribute must be between 1 and 4.");if(!r(n.values))throw new t("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values};return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var r=function(r){r=e(r,e.EMPTY_OBJECT),this.position=r.position,this.normal=r.normal,this.st=r.st,this.binormal=r.binormal,this.tangent=r.tangent,this.color=r.color};return r}),define("Core/GeometryInstance",["./defaultValue","./defined","./DeveloperError","./Matrix4"],function(e,r,t,n){"use strict";var i=function(i){if(i=e(i,e.EMPTY_OBJECT),!r(i.geometry))throw new t("options.geometry is required.");this.geometry=i.geometry,this.modelMatrix=n.clone(e(i.modelMatrix,n.IDENTITY)),this.id=i.id,this.pickPrimitive=i.pickPrimitive,this.attributes=e(i.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0};return i}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,r,t,n,i){"use strict";var o={};o.octEncode=function(e,o){if(!t(e))throw new n("vector is required.");if(!t(o))throw new n("result is required.");var a=r.magnitudeSquared(e);if(Math.abs(a-1)>i.EPSILON6)throw new n("vector must be normalized.");if(o.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),o.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var u=o.x,s=o.y;o.x=(1-Math.abs(s))*i.signNotZero(u),o.y=(1-Math.abs(u))*i.signNotZero(s)}return o.x=i.toSNorm(o.x),o.y=i.toSNorm(o.y),o},o.octDecode=function(e,o,a){if(!t(a))throw new n("result is required.");if(0>e||e>255||0>o||o>255)throw new n("x and y must be a signed normalized integer between 0 and 255");if(a.x=i.fromSNorm(e),a.y=i.fromSNorm(o),a.z=1-(Math.abs(a.x)+Math.abs(a.y)),a.z<0){var u=a.x;a.x=(1-Math.abs(a.y))*i.signNotZero(u),a.y=(1-Math.abs(u))*i.signNotZero(a.y)}return r.normalize(a,a)},o.octPackFloat=function(e){if(!t(e))throw new n("encoded is required.");return 256*e.x+e.y};var a=new e;return o.octEncodeFloat=function(e){return o.octEncode(e,a),o.octPackFloat(a)},o.octDecodeFloat=function(e,r){if(!t(e))throw new n("value is required.");var i=e/256,a=Math.floor(i),u=256*(i-a);return o.octDecode(a,u,r)},o.octPack=function(e,r,i,u){if(!t(e))throw new n("v1 is required.");if(!t(r))throw new n("v2 is required.");if(!t(i))throw new n("v3 is required.");if(!t(u))throw new n("result is required.");var s=o.octEncodeFloat(e),c=o.octEncodeFloat(r),f=o.octEncode(i,a);return u.x=65536*f.x+s,u.y=65536*f.y+c,u},o.octUnpack=function(e,r,i,a){if(!t(e))throw new n("packed is required.");if(!t(r))throw new n("v1 is required.");if(!t(i))throw new n("v2 is required.");if(!t(a))throw new n("v3 is required.");var u=e.x/65536,s=Math.floor(u),c=65536*(u-s);u=e.y/65536;var f=Math.floor(u),l=65536*(u-f);o.octDecodeFloat(c,r),o.octDecodeFloat(l,i),o.octDecode(s,f,a)},o.compressTextureCoordinates=function(e){if(!t(e))throw new n("textureCoordinates is required.");var r=1===e.x?4095:4096*e.x|0,i=1===e.y?4095:4096*e.y|0;return 4096*r+i},o.decompressTextureCoordinates=function(e,r){if(!t(e))throw new n("compressed is required.");if(!t(r))throw new n("result is required.");var i=e/4096;return r.x=Math.floor(i)/4096,r.y=i-Math.floor(i),r},o}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i=new r,o=new r,a=new r,u=function(u,s,c,f,l){if(!(t(u)&&t(s)&&t(c)&&t(f)))throw new n("point, p0, p1, and p2 are required.");t(l)||(l=new r);var h,w,d,m,E,p,y,_;t(s.z)?(h=r.subtract(c,s,i),w=r.subtract(f,s,o),d=r.subtract(u,s,a),m=r.dot(h,h),E=r.dot(h,w),p=r.dot(h,d),y=r.dot(w,w),_=r.dot(w,d)):(h=e.subtract(c,s,i),w=e.subtract(f,s,o),d=e.subtract(u,s,a),m=e.dot(h,h),E=e.dot(h,w),p=e.dot(h,d),y=e.dot(w,w),_=e.dot(w,d));var T=1/(m*y-E*E);return l.y=(y*p-E*_)*T,l.z=(m*_-E*p)*T,l.x=1-l.y-l.z,l};return u}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)};n.encode=function(e,n){if(!r(e))throw new t("value is required");r(n)||(n={high:0,low:0});var i;return e>=0?(i=65536*Math.floor(e/65536),n.high=i,n.low=e-i):(i=65536*Math.floor(-e/65536),n.high=-i,n.low=e+i),n};var i={high:0,low:0};n.fromCartesian=function(e,o){if(!r(e))throw new t("cartesian is required");r(o)||(o=new n);var a=o.high,u=o.low;return n.encode(e.x,i),a.x=i.high,u.x=i.low,n.encode(e.y,i),a.y=i.high,u.y=i.low,n.encode(e.z,i),a.z=i.high,u.z=i.low,o};var o=new n;return n.writeElements=function(e,i,a){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("cartesianArray is required");if("number"!=typeof a||0>a)throw new t("index must be a number greater than or equal to 0.");n.fromCartesian(e,o);var u=o.high,s=o.low;i[a]=u.x,i[a+1]=u.y,i[a+2]=u.z,i[a+3]=s.x,i[a+4]=s.y,i[a+5]=s.z},n}),define("Core/IndexDatatype",["../Renderer/WebGLConstants","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o={UNSIGNED_BYTE:e.UNSIGNED_BYTE,UNSIGNED_SHORT:e.UNSIGNED_SHORT,UNSIGNED_INT:e.UNSIGNED_INT};return o.getSizeInBytes=function(e){switch(e){case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},o.validate=function(e){return r(e)&&(e===o.UNSIGNED_BYTE||e===o.UNSIGNED_SHORT||e===o.UNSIGNED_INT)},o.createTypedArray=function(e,n){if(!r(e))throw new t("numberOfVertices is required.");return e>=i.SIXTY_FOUR_KILOBYTES?new Uint32Array(n):new Uint16Array(n)},o.createTypedArrayFromArrayBuffer=function(e,n,o,a){if(!r(e))throw new t("numberOfVertices is required.");if(!r(n))throw new t("sourceArray is required.");if(!r(o))throw new t("byteOffset is required.");return e>=i.SIXTY_FOUR_KILOBYTES?new Uint32Array(n,o,a):new Uint16Array(n,o,a)},n(o)}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,r){"use strict";function t(e,t,n){var i=e+t;return r.sign(e)!==r.sign(t)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(t)))<n?0:i}var n={};return n.computeDiscriminant=function(r,t,n){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");var i=t*t-4*r*n;return i},n.computeRealRoots=function(n,i,o){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");var a;if(0===n)return 0===i?[]:[-o/i];if(0===i){if(0===o)return[0,0];var u=Math.abs(o),s=Math.abs(n);if(s>u&&u/s<r.EPSILON14)return[0,0];if(u>s&&s/u<r.EPSILON14)return[];if(a=-o/n,0>a)return[];var c=Math.sqrt(a);return[-c,c]}if(0===o)return a=-i/n,0>a?[a,0]:[0,a];var f=i*i,l=4*n*o,h=t(f,-l,r.EPSILON14);if(0>h)return[];var w=-.5*t(i,r.sign(i)*Math.sqrt(h),r.EPSILON14);return i>0?[w/n,o/w]:[o/w,w/n]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,r){"use strict";function t(e,r,t,n){var i,o,a=e,u=r/3,s=t/3,c=n,f=a*s,l=u*c,h=u*u,w=s*s,d=a*s-h,m=a*c-u*s,E=u*c-w,p=4*d*E-m*m;if(0>p){var y,_,T;h*l>=f*w?(y=a,_=d,T=-2*u*d+a*m):(y=c,_=E,T=-c*m+2*s*E);var R=0>T?-1:1,A=-R*Math.abs(y)*Math.sqrt(-p);o=-T+A;var v=o/2,N=0>v?-Math.pow(-v,1/3):Math.pow(v,1/3),I=o===A?-N:-_/N;return i=0>=_?N+I:-T/(N*N+I*I+_),h*l>=f*w?[(i-u)/a]:[-c/(i+s)]}var S=d,g=-2*u*d+a*m,M=E,O=-c*m+2*s*E,q=Math.sqrt(p),b=Math.sqrt(3)/2,x=Math.abs(Math.atan2(a*q,-g)/3);i=2*Math.sqrt(-S);var P=Math.cos(x);o=i*P;var L=i*(-P/2-b*Math.sin(x)),C=o+L>2*u?o-u:L-u,F=a,U=C/F;x=Math.abs(Math.atan2(c*q,-O)/3),i=2*Math.sqrt(-M),P=Math.cos(x),o=i*P,L=i*(-P/2-b*Math.sin(x));var D=-c,B=2*s>o+L?o+s:L+s,z=D/B,G=F*B,V=-C*B-F*D,X=C*D,H=(s*V-u*X)/(-u*V+s*G);return H>=U?z>=U?z>=H?[U,H,z]:[U,z,H]:[z,U,H]:z>=U?[H,U,z]:z>=H?[H,z,U]:[z,H,U]}var n={};return n.computeDiscriminant=function(r,t,n,i){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var o=r*r,a=t*t,u=n*n,s=i*i,c=18*r*t*n*i+a*u-27*o*s-4*(r*u*n+a*t*i);return c},n.computeRealRoots=function(n,i,o,a){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");if("number"!=typeof a)throw new e("d is a required number.");var u,s;if(0===n)return r.computeRealRoots(i,o,a);if(0===i){if(0===o){if(0===a)return[0,0,0];s=-a/n;var c=0>s?-Math.pow(-s,1/3):Math.pow(s,1/3);return[c,c,c]}return 0===a?(u=r.computeRealRoots(n,0,o),0===u.Length?[0]:[u[0],0,u[1]]):t(n,0,o,a)}return 0===o?0===a?(s=-i/n,0>s?[s,0,0]:[0,0,s]):t(n,i,0,a):0===a?(u=r.computeRealRoots(n,i,o),0===u.length?[0]:u[1]<=0?[u[0],u[1],0]:u[0]>=0?[0,u[0],u[1]]:[u[0],0,u[1]]):t(n,i,o,a)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,r,t,n){"use strict";function i(r,i,o,a){var u=r*r,s=i-3*u/8,c=o-i*r/2+u*r/8,f=a-o*r/4+i*u/16-3*u*u/256,l=e.computeRealRoots(1,2*s,s*s-4*f,-c*c);if(l.length>0){var h=-r/4,w=l[l.length-1];if(Math.abs(w)<t.EPSILON14){var d=n.computeRealRoots(1,s,f);if(2===d.length){var m,E=d[0],p=d[1];if(E>=0&&p>=0){var y=Math.sqrt(E),_=Math.sqrt(p);return[h-_,h-y,h+y,h+_]}if(E>=0&&0>p)return m=Math.sqrt(E),[h-m,h+m];if(0>E&&p>=0)return m=Math.sqrt(p),[h-m,h+m]}return[]}if(w>0){var T=Math.sqrt(w),R=(s+w-c/T)/2,A=(s+w+c/T)/2,v=n.computeRealRoots(1,T,R),N=n.computeRealRoots(1,-T,A);return 0!==v.length?(v[0]+=h,v[1]+=h,0!==N.length?(N[0]+=h,N[1]+=h,v[1]<=N[0]?[v[0],v[1],N[0],N[1]]:N[1]<=v[0]?[N[0],N[1],v[0],v[1]]:v[0]>=N[0]&&v[1]<=N[1]?[N[0],v[0],v[1],N[1]]:N[0]>=v[0]&&N[1]<=v[1]?[v[0],N[0],N[1],v[1]]:v[0]>N[0]&&v[0]<N[1]?[N[0],v[0],N[1],v[1]]:[v[0],N[0],v[1],N[1]]):v):0!==N.length?(N[0]+=h,N[1]+=h,N):[]}}return[]}function o(r,i,o,a){var u=o*o,s=i*i,c=r*r,f=-2*i,l=o*r+s-4*a,h=c*a-o*i*r+u,w=e.computeRealRoots(1,f,l,h);if(w.length>0){var d,m,E=w[0],p=i-E,y=p*p,_=r/2,T=p/2,R=y-4*a,A=y+4*Math.abs(a),v=c-4*E,N=c+4*Math.abs(E);if(0>E||v*A>R*N){var I=Math.sqrt(v);d=I/2,m=0===I?0:(r*T-o)/I}else{var S=Math.sqrt(R);d=0===S?0:(r*T-o)/S,m=S/2}var g,M;0===_&&0===d?(g=0,M=0):t.sign(_)===t.sign(d)?(g=_+d,M=E/g):(M=_-d,g=E/M);var O,q;0===T&&0===m?(O=0,q=0):t.sign(T)===t.sign(m)?(O=T+m,q=a/O):(q=T-m,O=a/q);var b=n.computeRealRoots(1,g,O),x=n.computeRealRoots(1,M,q);if(0!==b.length)return 0!==x.length?b[1]<=x[0]?[b[0],b[1],x[0],x[1]]:x[1]<=b[0]?[x[0],x[1],b[0],b[1]]:b[0]>=x[0]&&b[1]<=x[1]?[x[0],b[0],b[1],x[1]]:x[0]>=b[0]&&x[1]<=b[1]?[b[0],x[0],x[1],b[1]]:b[0]>x[0]&&b[0]<x[1]?[x[0],b[0],x[1],b[1]]:[b[0],x[0],b[1],x[1]]:b;if(0!==x.length)return x}return[]}var a={};return a.computeDiscriminant=function(e,t,n,i,o){if("number"!=typeof e)throw new r("a is a required number.");if("number"!=typeof t)throw new r("b is a required number.");if("number"!=typeof n)throw new r("c is a required number.");if("number"!=typeof i)throw new r("d is a required number.");if("number"!=typeof o)throw new r("e is a required number.");var a=e*e,u=a*e,s=t*t,c=s*t,f=n*n,l=f*n,h=i*i,w=h*i,d=o*o,m=d*o,E=s*f*h-4*c*w-4*e*l*h+18*e*t*n*w-27*a*h*h+256*u*m+o*(18*c*n*i-4*s*l+16*e*f*f-80*e*t*f*i-6*e*s*h+144*a*n*h)+d*(144*e*s*n-27*s*s-128*a*f-192*a*t*i);return E},a.computeRealRoots=function(n,a,u,s,c){if("number"!=typeof n)throw new r("a is a required number.");if("number"!=typeof a)throw new r("b is a required number.");if("number"!=typeof u)throw new r("c is a required number.");if("number"!=typeof s)throw new r("d is a required number.");if("number"!=typeof c)throw new r("e is a required number.");if(Math.abs(n)<t.EPSILON15)return e.computeRealRoots(a,u,s,c);var f=a/n,l=u/n,h=s/n,w=c/n,d=0>f?1:0;switch(d+=0>l?d+1:d,d+=0>h?d+1:d,d+=0>w?d+1:d){case 0:return i(f,l,h,w);case 1:return o(f,l,h,w);case 2:return o(f,l,h,w);case 3:return i(f,l,h,w);case 4:return i(f,l,h,w);case 5:return o(f,l,h,w);case 6:return i(f,l,h,w);case 7:return i(f,l,h,w);case 8:return o(f,l,h,w);case 9:return i(f,l,h,w);case 10:return i(f,l,h,w);case 11:return o(f,l,h,w);case 12:return i(f,l,h,w);case 13:return i(f,l,h,w);case 14:return i(f,l,h,w);case 15:return i(f,l,h,w);default:return void 0}},a}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i=function(t,n){n=e.clone(r(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(r(t,e.ZERO)),this.direction=n};return i.getPoint=function(r,i,o){if(!t(r))throw new n("ray is requred");if("number"!=typeof i)throw new n("t is a required number");return t(o)||(o=new e),o=e.multiplyByScalar(r.direction,i,o),e.add(r.origin,o,o)},i}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,r,t,n,i,o,a,u,s,c){"use strict";function f(r,a,u,s,c){if(!n(r))throw new i("ray is required.");if(!n(a))throw new i("p0 is required.");if(!n(u))throw new i("p1 is required.");if(!n(s))throw new i("p2 is required.");c=t(c,!1);var f,l,h,w,d,m=r.origin,R=r.direction,A=e.subtract(u,a,E),v=e.subtract(s,a,p),N=e.cross(R,v,y),I=e.dot(A,N);if(c){if(I<o.EPSILON6)return void 0;if(f=e.subtract(m,a,_),h=e.dot(f,N),0>h||h>I)return void 0;if(l=e.cross(f,A,T),w=e.dot(R,l),0>w||h+w>I)return void 0;d=e.dot(v,l)/I}else{if(Math.abs(I)<o.EPSILON6)return void 0;var S=1/I;if(f=e.subtract(m,a,_),h=e.dot(f,N)*S,0>h||h>1)return void 0;if(l=e.cross(f,A,T),w=e.dot(R,l)*S,0>w||h+w>1)return void 0;d=e.dot(v,l)*S}return d}function l(e,r,t,n){var i=r*r-4*e*t;if(0>i)return void 0;if(i>0){var o=1/(2*e),a=Math.sqrt(i),u=(-r+a)*o,s=(-r-a)*o;return s>u?(n.root0=u,n.root1=s):(n.root0=s,n.root1=u),n}var c=-r/(2*e);return 0===c?void 0:(n.root0=n.root1=c,n)}function h(r,t,i){n(i)||(i={});var o=r.origin,a=r.direction,u=t.center,s=t.radius*t.radius,c=e.subtract(o,u,y),f=e.dot(a,a),h=2*e.dot(a,c),w=e.magnitudeSquared(c)-s,d=l(f,h,w,A);return n(d)?(i.start=d.root0,i.stop=d.root1,i):void 0}function w(e,r,t){var n=e+r;return o.sign(e)!==o.sign(r)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(r)))<t?0:n}function d(r,t,n,i,c){var f,l=i*i,h=c*c,d=(r[a.COLUMN1ROW1]-r[a.COLUMN2ROW2])*h,m=c*(i*w(r[a.COLUMN1ROW0],r[a.COLUMN0ROW1],o.EPSILON15)+t.y),E=r[a.COLUMN0ROW0]*l+r[a.COLUMN2ROW2]*h+i*t.x+n,p=h*w(r[a.COLUMN2ROW1],r[a.COLUMN1ROW2],o.EPSILON15),y=c*(i*w(r[a.COLUMN2ROW0],r[a.COLUMN0ROW2])+t.z),_=[];if(0===y&&0===p){if(f=u.computeRealRoots(d,m,E),0===f.length)return _;var T=f[0],R=Math.sqrt(Math.max(1-T*T,0));if(_.push(new e(i,c*T,c*-R)),_.push(new e(i,c*T,c*R)),2===f.length){var A=f[1],v=Math.sqrt(Math.max(1-A*A,0));_.push(new e(i,c*A,c*-v)),_.push(new e(i,c*A,c*v))}return _}var N=y*y,I=p*p,S=d*d,g=y*p,M=S+I,O=2*(m*d+g),q=2*E*d+m*m-I+N,b=2*(E*m-g),x=E*E-N;if(0===M&&0===O&&0===q&&0===b)return _;f=s.computeRealRoots(M,O,q,b,x);var P=f.length;if(0===P)return _;for(var L=0;P>L;++L){var C,F=f[L],U=F*F,D=Math.max(1-U,0),B=Math.sqrt(D);C=o.sign(d)===o.sign(E)?w(d*U+E,m*F,o.EPSILON12):o.sign(E)===o.sign(m*F)?w(d*U,m*F+E,o.EPSILON12):w(d*U+m*F,E,o.EPSILON12);var z=w(p*F,y,o.EPSILON15),G=C*z;0>G?_.push(new e(i,c*F,c*B)):G>0?_.push(new e(i,c*F,c*-B)):0!==B?(_.push(new e(i,c*F,c*-B)),_.push(new e(i,c*F,c*B)),++L):_.push(new e(i,c*F,c*B))}return _}var m={};m.rayPlane=function(r,t,a){if(!n(r))throw new i("ray is required.");if(!n(t))throw new i("plane is required.");n(a)||(a=new e);var u=r.origin,s=r.direction,c=t.normal,f=e.dot(c,s);if(Math.abs(f)<o.EPSILON15)return void 0;var l=(-t.distance-e.dot(c,u))/f;return 0>l?void 0:(a=e.multiplyByScalar(s,l,a),e.add(u,a,a))};var E=new e,p=new e,y=new e,_=new e,T=new e;m.rayTriangle=function(r,t,i,o,a,u){var s=f(r,t,i,o,a);return!n(s)||0>s?void 0:(n(u)||(u=new e),e.multiplyByScalar(r.direction,s,u),e.add(r.origin,u,u))};var R=new c;m.lineSegmentTriangle=function(r,t,o,a,u,s,c){if(!n(r))throw new i("v0 is required.");if(!n(t))throw new i("v1 is required.");var l=R;e.clone(r,l.origin),e.subtract(t,r,l.direction),e.normalize(l.direction,l.direction);var h=f(l,o,a,u,s);return!n(h)||0>h||h>e.distance(r,t)?void 0:(n(c)||(c=new e),e.multiplyByScalar(l.direction,h,c),e.add(l.origin,c,c))};var A={root0:0,root1:0};m.raySphere=function(e,r,t){if(!n(e))throw new i("ray is required.");if(!n(r))throw new i("sphere is required.");return t=h(e,r,t),!n(t)||t.stop<0?void 0:(t.start=Math.max(t.start,0),t)};var v=new c;m.lineSegmentSphere=function(r,t,o,a){if(!n(r))throw new i("p0 is required.");if(!n(t))throw new i("p1 is required.");if(!n(o))throw new i("sphere is required.");var u=v,s=(e.clone(r,u.origin),e.subtract(t,r,u.direction)),c=e.magnitude(s);return e.normalize(s,s),a=h(u,o,a),!n(a)||a.stop<0||a.start>c?void 0:(a.start=Math.max(a.start,0),a.stop=Math.min(a.stop,c),a)};var N=new e,I=new e;m.rayEllipsoid=function(r,t){if(!n(r))throw new i("ray is required.");if(!n(t))throw new i("ellipsoid is required.");var o,a,u,s,c,f=t.oneOverRadii,l=e.multiplyComponents(f,r.origin,N),h=e.multiplyComponents(f,r.direction,I),w=e.magnitudeSquared(l),d=e.dot(l,h);if(w>1){if(d>=0)return void 0;var m=d*d;if(o=w-1,a=e.magnitudeSquared(h),u=a*o,u>m)return void 0;if(m>u){s=d*d-u,c=-d+Math.sqrt(s);var E=c/a,p=o/c;return p>E?{start:E,stop:p}:{start:p,stop:E}}var y=Math.sqrt(o/a);return{start:y,stop:y}}return 1>w?(o=w-1,a=e.magnitudeSquared(h),u=a*o,s=d*d-u,c=-d+Math.sqrt(s),{start:0,stop:c/a}):0>d?(a=e.magnitudeSquared(h),{start:0,stop:-d/a}):void 0};var S=new e,g=new e,M=new e,O=new e,q=new e,b=new a,x=new a,P=new a,L=new a,C=new a,F=new a,U=new a,D=new e,B=new e,z=new r;m.grazingAltitudeLocation=function(r,t){if(!n(r))throw new i("ray is required.");if(!n(t))throw new i("ellipsoid is required.");var u=r.origin,s=r.direction,c=t.geodeticSurfaceNormal(u,S);if(e.dot(s,c)>=0)return u;var f=n(this.rayEllipsoid(r,t)),l=t.transformPositionToScaledSpace(s,S),h=e.normalize(l,l),w=e.mostOrthogonalAxis(l,O),m=e.normalize(e.cross(w,h,g),g),E=e.normalize(e.cross(h,m,M),M),p=b;p[0]=h.x,p[1]=h.y,p[2]=h.z,p[3]=m.x,p[4]=m.y,p[5]=m.z,p[6]=E.x,p[7]=E.y,p[8]=E.z;var y=a.transpose(p,x),_=a.fromScale(t.radii,P),T=a.fromScale(t.oneOverRadii,L),R=C;R[0]=0,R[1]=-s.z,R[2]=s.y,R[3]=s.z,R[4]=0,R[5]=-s.x,R[6]=-s.y,R[7]=s.x,R[8]=0;var A,v,N=a.multiply(a.multiply(y,T,F),R,F),I=a.multiply(a.multiply(N,_,U),p,U),G=a.multiplyByVector(N,u,q),V=d(I,e.negate(G,S),0,0,1),X=V.length;if(X>0){for(var H=e.clone(e.ZERO,B),W=Number.NEGATIVE_INFINITY,Y=0;X>Y;++Y){A=a.multiplyByVector(_,a.multiplyByVector(p,V[Y],D),D);var k=e.normalize(e.subtract(A,u,O),O),K=e.dot(k,s);K>W&&(W=K,H=e.clone(A,H))}var Z=t.cartesianToCartographic(H,z);return W=o.clamp(W,0,1),v=e.magnitude(e.subtract(H,u,O))*Math.sqrt(1-W*W),v=f?-v:v,Z.height=v,t.cartographicToCartesian(Z,new e)}return void 0};var G=new e;
return m.lineSegmentPlane=function(r,t,a,u){if(!n(r))throw new i("endPoint0 is required.");if(!n(t))throw new i("endPoint1 is required.");if(!n(a))throw new i("plane is required.");n(u)||(u=new e);var s=e.subtract(t,r,G),c=a.normal,f=e.dot(c,s);if(Math.abs(f)<o.EPSILON6)return void 0;var l=e.dot(c,r),h=-(a.distance+l)/f;return 0>h||h>1?void 0:(e.multiplyByScalar(s,h,u),e.add(r,u,u),u)},m.trianglePlaneIntersection=function(r,t,o,a){if(!(n(r)&&n(t)&&n(o)&&n(a)))throw new i("p0, p1, p2, and plane are required.");var u=a.normal,s=a.distance,c=e.dot(u,r)+s<0,f=e.dot(u,t)+s<0,l=e.dot(u,o)+s<0,h=0;h+=c?1:0,h+=f?1:0,h+=l?1:0;var w,d;if((1===h||2===h)&&(w=new e,d=new e),1===h){if(c)return m.lineSegmentPlane(r,t,a,w),m.lineSegmentPlane(r,o,a,d),{positions:[r,t,o,w,d],indices:[0,3,4,1,2,4,1,4,3]};if(f)return m.lineSegmentPlane(t,o,a,w),m.lineSegmentPlane(t,r,a,d),{positions:[r,t,o,w,d],indices:[1,3,4,2,0,4,2,4,3]};if(l)return m.lineSegmentPlane(o,r,a,w),m.lineSegmentPlane(o,t,a,d),{positions:[r,t,o,w,d],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===h){if(!c)return m.lineSegmentPlane(t,r,a,w),m.lineSegmentPlane(o,r,a,d),{positions:[r,t,o,w,d],indices:[1,2,4,1,4,3,0,3,4]};if(!f)return m.lineSegmentPlane(o,t,a,w),m.lineSegmentPlane(r,t,a,d),{positions:[r,t,o,w,d],indices:[2,0,4,2,4,3,1,3,4]};if(!l)return m.lineSegmentPlane(r,o,a,w),m.lineSegmentPlane(t,o,a,d),{positions:[r,t,o,w,d],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},m}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n={};return n.calculateACMR=function(n){n=e(n,e.EMPTY_OBJECT);var i=n.indices,o=n.maximumIndex,a=e(n.cacheSize,24);if(!r(i))throw new t("indices is required.");var u=i.length;if(3>u||u%3!==0)throw new t("indices length must be a multiple of three.");if(0>=o)throw new t("maximumIndex must be greater than zero.");if(3>a)throw new t("cacheSize must be greater than two.");if(!r(o)){o=0;for(var s=0,c=i[s];u>s;)c>o&&(o=c),++s,c=i[s]}for(var f=[],l=0;o+1>l;l++)f[l]=0;for(var h=a+1,w=0;u>w;++w)h-f[i[w]]>a&&(f[i[w]]=h,++h);return(h-a+1)/(u/3)},n.tipsify=function(n){function i(e,r,t,n){for(;r.length>=1;){var i=r[r.length-1];if(r.splice(r.length-1,1),e[i].numLiveTriangles>0)return i}for(;n>a;){if(e[a].numLiveTriangles>0)return++a,a-1;++a}return-1}function o(e,r,t,n,o,a,u){for(var s,c=-1,f=-1,l=0;l<t.length;){var h=t[l];n[h].numLiveTriangles&&(s=0,o-n[h].timeStamp+2*n[h].numLiveTriangles<=r&&(s=o-n[h].timeStamp),(s>f||-1===f)&&(f=s,c=h)),++l}return-1===c?i(n,a,e,u):c}n=e(n,e.EMPTY_OBJECT);var a,u=n.indices,s=n.maximumIndex,c=e(n.cacheSize,24);if(!r(u))throw new t("indices is required.");var f=u.length;if(3>f||f%3!==0)throw new t("indices length must be a multiple of three.");if(0>=s)throw new t("maximumIndex must be greater than zero.");if(3>c)throw new t("cacheSize must be greater than two.");var l=0,h=0,w=u[h],d=f;if(r(s))l=s+1;else{for(;d>h;)w>l&&(l=w),++h,w=u[h];if(-1===l)return 0;++l}for(var m=[],E=0;l>E;E++)m[E]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};h=0;for(var p=0;d>h;)m[u[h]].vertexTriangles.push(p),++m[u[h]].numLiveTriangles,m[u[h+1]].vertexTriangles.push(p),++m[u[h+1]].numLiveTriangles,m[u[h+2]].vertexTriangles.push(p),++m[u[h+2]].numLiveTriangles,++p,h+=3;var y=0,_=c+1;a=1;var T,R,A=[],v=[],N=0,I=[],S=f/3,g=[];for(E=0;S>E;E++)g[E]=!1;for(var M,O;-1!==y;){A=[],R=m[y],O=R.vertexTriangles.length;for(var q=0;O>q;++q)if(p=R.vertexTriangles[q],!g[p]){g[p]=!0,h=p+p+p;for(var b=0;3>b;++b)M=u[h],A.push(M),v.push(M),I[N]=M,++N,T=m[M],--T.numLiveTriangles,_-T.timeStamp>c&&(T.timeStamp=_,++_),++h}y=o(u,c,A,m,_,v,l)}return I},n}),define("Core/GeometryPipeline",["./AttributeCompression","./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryInstance","./GeometryType","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],function(e,r,t,n,i,o,a,u,s,c,f,l,h,w,d,m,E,p,y,_,T,R,A,v,N,I){"use strict";function S(e,r,t,n,i){e[r++]=t,e[r++]=n,e[r++]=n,e[r++]=i,e[r++]=i,e[r]=t}function g(e){for(var r=e.length,t=r/3*6,n=p.createTypedArray(r,t),i=0,o=0;r>o;o+=3,i+=6)S(n,i,e[o],e[o+1],e[o+2]);return n}function M(e){var r=e.length;if(r>=3){var t=6*(r-2),n=p.createTypedArray(r,t);S(n,0,e[0],e[1],e[2]);for(var i=6,o=3;r>o;++o,i+=6)S(n,i,e[o-1],e[o],e[o-2]);return n}return new Uint16Array}function O(e){if(e.length>0){for(var r=e.length-1,t=6*(r-1),n=p.createTypedArray(r,t),i=e[0],o=0,a=1;r>a;++a,o+=6)S(n,o,i,e[a],e[a+1]);return n}return new Uint16Array}function q(e){var r={};for(var t in e)if(e.hasOwnProperty(t)&&c(e[t])&&c(e[t].values)){var n=e[t];r[t]=new d({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return r}function b(e,r,t){for(var n in r)if(r.hasOwnProperty(n)&&c(r[n])&&c(r[n].values))for(var i=r[n],o=0;o<i.componentsPerAttribute;++o)e[n].values.push(i.values[t*i.componentsPerAttribute+o])}function x(e,r){if(c(r))for(var t=r.values,n=t.length,o=0;n>o;o+=3)i.unpack(t,o,oe),A.multiplyByPoint(e,oe,oe),i.pack(oe,t,o)}function P(e,r){if(c(r))for(var t=r.values,n=t.length,o=0;n>o;o+=3)i.unpack(t,o,oe),R.multiplyByVector(e,oe,oe),oe=i.normalize(oe,oe),i.pack(oe,t,o)}function L(e,r){var t,n=e.length,i={},o=e[0][r].attributes;for(t in o)if(o.hasOwnProperty(t)&&c(o[t])&&c(o[t].values)){for(var a=o[t],s=a.values.length,f=!0,l=1;n>l;++l){var h=e[l][r].attributes[t];if(!c(h)||a.componentDatatype!==h.componentDatatype||a.componentsPerAttribute!==h.componentsPerAttribute||a.normalize!==h.normalize){f=!1;break}s+=h.values.length}f&&(i[t]=new d({componentDatatype:a.componentDatatype,componentsPerAttribute:a.componentsPerAttribute,normalize:a.normalize,values:u.createTypedArray(a.componentDatatype,s)}))}return i}function C(e,r){var n,o,a,u,s=e.length,l=e[0].modelMatrix,h=c(e[0][r].indices),d=e[0][r].primitiveType;for(o=1;s>o;++o){if(!A.equals(e[o].modelMatrix,l))throw new f("All instances must have the same modelMatrix.");if(c(e[o][r].indices)!==h)throw new f("All instance geometries must have an indices or not have one.");if(e[o][r].primitiveType!==d)throw new f("All instance geometries must have the same primitiveType.")}var m,E,y,_=L(e,r);for(n in _)if(_.hasOwnProperty(n))for(m=_[n].values,u=0,o=0;s>o;++o)for(E=e[o][r].attributes[n].values,y=E.length,a=0;y>a;++a)m[u++]=E[a];var T;if(h){var R=0;for(o=0;s>o;++o)R+=e[o][r].indices.length;var v=w.computeNumberOfVertices(new w({attributes:_,primitiveType:N.POINTS})),I=p.createTypedArray(v,R),S=0,g=0;for(o=0;s>o;++o){var M=e[o][r].indices,O=M.length;for(u=0;O>u;++u)I[S++]=g+M[u];g+=w.computeNumberOfVertices(e[o][r])}T=I}var q,b=new i,x=0;for(o=0;s>o;++o){if(q=e[o][r].boundingSphere,!c(q)){b=void 0;break}i.add(q.center,b,b)}if(c(b))for(i.divideByScalar(b,s,b),o=0;s>o;++o){q=e[o][r].boundingSphere;var P=i.magnitude(i.subtract(q.center,b,se))+q.radius;P>x&&(x=P)}return new w({attributes:_,indices:T,primitiveType:d,boundingSphere:c(b)?new t(b,x):void 0})}function F(e){if(c(e.indices))return e;var r=w.computeNumberOfVertices(e);if(3>r)throw new f("The number of vertices must be at least three.");if(r%3!==0)throw new f("The number of vertices must be a multiple of three.");for(var t=p.createTypedArray(r,r),n=0;r>n;++n)t[n]=n;return e.indices=t,e}function U(e){var r=w.computeNumberOfVertices(e);if(3>r)throw new f("The number of vertices must be at least three.");var t=p.createTypedArray(r,3*(r-2));t[0]=1,t[1]=0,t[2]=2;for(var n=3,i=3;r>i;++i)t[n++]=i-1,t[n++]=0,t[n++]=i;return e.indices=t,e.primitiveType=N.TRIANGLES,e}function D(e){var r=w.computeNumberOfVertices(e);if(3>r)throw new f("The number of vertices must be at least 3.");var t=p.createTypedArray(r,3*(r-2));t[0]=0,t[1]=1,t[2]=2,r>3&&(t[3]=0,t[4]=2,t[5]=3);for(var n=6,i=3;r-1>i;i+=2)t[n++]=i,t[n++]=i-1,t[n++]=i+1,r>i+2&&(t[n++]=i,t[n++]=i+1,t[n++]=i+2);return e.indices=t,e.primitiveType=N.TRIANGLES,e}function B(e){if(c(e.indices))return e;var r=w.computeNumberOfVertices(e);if(2>r)throw new f("The number of vertices must be at least two.");if(r%2!==0)throw new f("The number of vertices must be a multiple of 2.");for(var t=p.createTypedArray(r,r),n=0;r>n;++n)t[n]=n;return e.indices=t,e}function z(e){var r=w.computeNumberOfVertices(e);if(2>r)throw new f("The number of vertices must be at least two.");var t=p.createTypedArray(r,2*(r-1));t[0]=0,t[1]=1;for(var n=2,i=2;r>i;++i)t[n++]=i-1,t[n++]=i;return e.indices=t,e.primitiveType=N.LINES,e}function G(e){var r=w.computeNumberOfVertices(e);if(2>r)throw new f("The number of vertices must be at least two.");var t=p.createTypedArray(r,2*r);t[0]=0,t[1]=1;for(var n=2,i=2;r>i;++i)t[n++]=i-1,t[n++]=i;return t[n++]=r-1,t[n]=0,e.indices=t,e.primitiveType=N.LINES,e}function V(e){switch(e.primitiveType){case N.TRIANGLE_FAN:return U(e);case N.TRIANGLE_STRIP:return D(e);case N.TRIANGLES:return F(e);case N.LINE_STRIP:return z(e);case N.LINE_LOOP:return G(e);case N.LINES:return B(e)}return e}function X(e,r){Math.abs(e.y)<T.EPSILON6&&(r?e.y=-T.EPSILON6:e.y=T.EPSILON6)}function H(e,r,t){if(0!==e.y&&0!==r.y&&0!==t.y)return X(e,e.y<0),X(r,r.y<0),void X(t,t.y<0);var n,i=Math.abs(e.y),o=Math.abs(r.y),a=Math.abs(t.y);n=i>o?i>a?T.sign(e.y):T.sign(t.y):o>a?T.sign(r.y):T.sign(t.y);var u=0>n;X(e,u),X(r,u),X(t,u)}function W(e,r,t,n){i.add(e,i.multiplyByScalar(i.subtract(r,e,Te),e.y/(e.y-r.y),Te),t),i.clone(t,n),X(t,!0),X(n,!1)}function Y(e,r,t){if(e.x>=0||r.x>=0||t.x>=0)return void 0;H(e,r,t);var n=e.y<0,i=r.y<0,o=t.y<0,a=0;a+=n?1:0,a+=i?1:0,a+=o?1:0;var u=Ie.indices;1===a?(u[1]=3,u[2]=4,u[5]=6,u[7]=6,u[8]=5,n?(W(e,r,Re,ve),W(e,t,Ae,Ne),u[0]=0,u[3]=1,u[4]=2,u[6]=1):i?(W(r,t,Re,ve),W(r,e,Ae,Ne),u[0]=1,u[3]=2,u[4]=0,u[6]=2):o&&(W(t,e,Re,ve),W(t,r,Ae,Ne),u[0]=2,u[3]=0,u[4]=1,u[6]=0)):2===a&&(u[2]=4,u[4]=4,u[5]=3,u[7]=5,u[8]=6,n?i?o||(W(t,e,Re,ve),W(t,r,Ae,Ne),u[0]=0,u[1]=1,u[3]=0,u[6]=2):(W(r,t,Re,ve),W(r,e,Ae,Ne),u[0]=2,u[1]=0,u[3]=2,u[6]=1):(W(e,r,Re,ve),W(e,t,Ae,Ne),u[0]=1,u[1]=2,u[3]=1,u[6]=0));var s=Ie.positions;return s[0]=e,s[1]=r,s[2]=t,s.length=3,(1===a||2===a)&&(s[3]=Re,s[4]=Ae,s[5]=ve,s[6]=Ne,s.length=7),Ie}function k(e,r){var n=e.attributes;if(0===n.position.values.length)return void 0;for(var i in n)if(n.hasOwnProperty(i)&&c(n[i])&&c(n[i].values)){var o=n[i];o.values=u.createTypedArray(o.componentDatatype,o.values)}var a=w.computeNumberOfVertices(e);return e.indices=p.createTypedArray(a,e.indices),r&&(e.boundingSphere=t.fromVertices(n.position.values)),e}function K(e){var r=e.attributes,t={};for(var n in r)if(r.hasOwnProperty(n)&&c(r[n])&&c(r[n].values)){var i=r[n];t[n]=new d({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]})}return new w({attributes:t,indices:[],primitiveType:e.primitiveType})}function Z(e,r,t){var n=c(e.geometry.boundingSphere);r=k(r,n),t=k(t,n),c(t)&&!c(r)?e.geometry=t:!c(t)&&c(r)?e.geometry=r:(e.westHemisphereGeometry=r,e.eastHemisphereGeometry=t,e.geometry=void 0)}function j(e,t,o,a,u,s,f,l,h,w,d){if(c(s)||c(f)||c(l)||c(h)){var m=i.fromArray(u,3*e,Se),E=i.fromArray(u,3*t,ge),p=i.fromArray(u,3*o,Me),y=r(a,m,E,p,Oe);if(c(s)){var _=i.fromArray(s,3*e,Se),T=i.fromArray(s,3*t,ge),R=i.fromArray(s,3*o,Me);i.multiplyByScalar(_,y.x,_),i.multiplyByScalar(T,y.y,T),i.multiplyByScalar(R,y.z,R);var A=i.add(_,T,_);i.add(A,R,A),i.normalize(A,A),i.pack(A,w.normal.values,3*d)}if(c(f)){var v=i.fromArray(f,3*e,Se),N=i.fromArray(f,3*t,ge),I=i.fromArray(f,3*o,Me);i.multiplyByScalar(v,y.x,v),i.multiplyByScalar(N,y.y,N),i.multiplyByScalar(I,y.z,I);var S=i.add(v,N,v);i.add(S,I,S),i.normalize(S,S),i.pack(S,w.binormal.values,3*d)}if(c(l)){var g=i.fromArray(l,3*e,Se),M=i.fromArray(l,3*t,ge),O=i.fromArray(l,3*o,Me);i.multiplyByScalar(g,y.x,g),i.multiplyByScalar(M,y.y,M),i.multiplyByScalar(O,y.z,O);var q=i.add(g,M,g);i.add(q,O,q),i.normalize(q,q),i.pack(q,w.tangent.values,3*d)}if(c(h)){var b=n.fromArray(h,2*e,qe),x=n.fromArray(h,2*t,be),P=n.fromArray(h,2*o,xe);n.multiplyByScalar(b,y.x,b),n.multiplyByScalar(x,y.y,x),n.multiplyByScalar(P,y.z,P);var L=n.add(b,x,b);n.add(L,P,L),n.pack(L,w.st.values,2*d)}}}function Q(e,r,t,n,i,o){var a=e.position.values.length/3;if(-1!==i){var u=n[i],s=t[u];return-1===s?(t[u]=a,e.position.values.push(o.x,o.y,o.z),r.push(a),a):(r.push(s),s)}return e.position.values.push(o.x,o.y,o.z),r.push(a),a}function J(e){var r,t,n,o,a,u=e.geometry,s=u.attributes,f=s.position.values,l=c(s.normal)?s.normal.values:void 0,h=c(s.binormal)?s.binormal.values:void 0,w=c(s.tangent)?s.tangent.values:void 0,d=c(s.st)?s.st.values:void 0,m=u.indices,E=K(u),p=K(u),y=[];y.length=f.length/3;var _=[];for(_.length=f.length/3,a=0;a<y.length;++a)y[a]=-1,_[a]=-1;var T=m.length;for(a=0;T>a;a+=3){var R=m[a],A=m[a+1],v=m[a+2],N=i.fromArray(f,3*R),I=i.fromArray(f,3*A),S=i.fromArray(f,3*v),g=Y(N,I,S);if(c(g)&&g.positions.length>3)for(var M=g.positions,O=g.indices,q=O.length,b=0;q>b;++b){var x=O[b],P=M[x];P.y<0?(r=p.attributes,t=p.indices,n=y):(r=E.attributes,t=E.indices,n=_),o=Q(r,t,n,m,3>x?a+x:-1,P),j(R,A,v,P,f,l,h,w,d,r,o)}else c(g)&&(N=g.positions[0],I=g.positions[1],S=g.positions[2]),N.y<0?(r=p.attributes,t=p.indices,n=y):(r=E.attributes,t=E.indices,n=_),o=Q(r,t,n,m,a,N),j(R,A,v,N,f,l,h,w,d,r,o),o=Q(r,t,n,m,a+1,I),j(R,A,v,I,f,l,h,w,d,r,o),o=Q(r,t,n,m,a+2,S),j(R,A,v,S,f,l,h,w,d,r,o)}Z(e,p,E)}function $(e){var r,t=e.geometry,n=t.attributes,o=n.position.values,a=t.indices,u=K(t),s=K(t),f=a.length,l=[];l.length=o.length/3;var h=[];for(h.length=o.length/3,r=0;r<l.length;++r)l[r]=-1,h[r]=-1;for(r=0;f>r;r+=2){var w=a[r],d=a[r+1],m=i.fromArray(o,3*w,Se),E=i.fromArray(o,3*d,ge);Math.abs(m.y)<T.EPSILON6&&(m.y<0?m.y=-T.EPSILON6:m.y=T.EPSILON6),Math.abs(E.y)<T.EPSILON6&&(E.y<0?E.y=-T.EPSILON6:E.y=T.EPSILON6);var p=u.attributes,y=u.indices,R=h,A=s.attributes,v=s.indices,N=l,I=_.lineSegmentPlane(m,E,Pe,Me);if(c(I)){var S=i.multiplyByScalar(i.UNIT_Y,5*T.EPSILON9,Le);m.y<0&&(i.negate(S,S),p=s.attributes,y=s.indices,R=l,A=u.attributes,v=u.indices,N=h);var g=i.add(I,S,Ce);Q(p,y,R,a,r,m),Q(p,y,R,a,-1,g),i.negate(S,S),i.add(I,S,g),Q(A,v,N,a,-1,g),Q(A,v,N,a,r+1,E)}else{var M,O,q;m.y<0?(M=s.attributes,O=s.indices,q=l):(M=u.attributes,O=u.indices,q=h),Q(M,O,q,a,r,m),Q(M,O,q,a,r+1,E)}}Z(e,s,u)}function ee(e){var r,t,a,u=e.geometry,s=u.attributes,f=s.position.values,l=s.prevPosition.values,h=s.nextPosition.values,w=s.expandAndWidth.values,d=(u.indices,c(s.st)?s.st.values:void 0),m=c(s.color)?s.color.values:void 0,E=K(u),p=K(u),y=f.length/3;for(r=0;y>r;r+=4){var R=r,A=r+1,v=r+2,N=r+3,I=i.fromArray(f,3*R,De),S=i.fromArray(f,3*A,Be),g=i.fromArray(f,3*v,ze),M=i.fromArray(f,3*N,Ge);Math.abs(I.y)<T.EPSILON6&&(I.y=T.EPSILON6*(g.y<0?-1:1),S.y=I.y),Math.abs(g.y)<T.EPSILON6&&(g.y=T.EPSILON6*(I.y<0?-1:1),M.y=g.y);var O=E.attributes,q=E.indices,b=p.attributes,x=p.indices,P=_.lineSegmentPlane(I,g,Pe,Ve);if(c(P)){var L=i.multiplyByScalar(i.UNIT_Y,5*T.EPSILON9,Xe);I.y<0&&(i.negate(L,L),O=p.attributes,q=p.indices,b=E.attributes,x=E.indices);var C=i.add(P,L,He);for(O.position.values.push(I.x,I.y,I.z,S.x,S.y,S.z),O.position.values.push(C.x,C.y,C.z),O.position.values.push(C.x,C.y,C.z),i.negate(L,L),i.add(P,L,C),b.position.values.push(C.x,C.y,C.z),b.position.values.push(C.x,C.y,C.z),b.position.values.push(g.x,g.y,g.z,M.x,M.y,M.z),t=3*R;3*R+6>t;++t)O.prevPosition.values.push(l[t]);for(O.prevPosition.values.push(I.x,I.y,I.z,I.x,I.y,I.z),b.prevPosition.values.push(I.x,I.y,I.z,I.x,I.y,I.z),t=3*v;3*v+6>t;++t)b.prevPosition.values.push(l[t]);for(t=3*R;3*R+6>t;++t)O.nextPosition.values.push(h[t]);for(O.nextPosition.values.push(g.x,g.y,g.z,g.x,g.y,g.z),b.nextPosition.values.push(g.x,g.y,g.z,g.x,g.y,g.z),t=3*v;3*v+6>t;++t)b.nextPosition.values.push(h[t]);var F=n.fromArray(w,2*R,Fe),U=Math.abs(F.y);O.expandAndWidth.values.push(-1,U,1,U),O.expandAndWidth.values.push(-1,-U,1,-U),b.expandAndWidth.values.push(-1,U,1,U),b.expandAndWidth.values.push(-1,-U,1,-U);var D=i.magnitudeSquared(i.subtract(P,I,Ge));if(D/=i.magnitudeSquared(i.subtract(g,I,Ge)),c(m)){var B=o.fromArray(m,4*R,We),z=o.fromArray(m,4*v,We),G=T.lerp(B.x,z.x,D),V=T.lerp(B.y,z.y,D),X=T.lerp(B.z,z.z,D),H=T.lerp(B.w,z.w,D);for(t=4*R;4*R+8>t;++t)O.color.values.push(m[t]);for(O.color.values.push(G,V,X,H),O.color.values.push(G,V,X,H),b.color.values.push(G,V,X,H),b.color.values.push(G,V,X,H),t=4*v;4*v+8>t;++t)b.color.values.push(m[t])}if(c(d)){var W=n.fromArray(d,2*R,Fe),Y=n.fromArray(d,2*(r+3),Ue),k=T.lerp(W.x,Y.x,D);for(t=2*R;2*R+4>t;++t)O.st.values.push(d[t]);for(O.st.values.push(k,W.y),O.st.values.push(k,Y.y),b.st.values.push(k,W.y),b.st.values.push(k,Y.y),t=2*v;2*v+4>t;++t)b.st.values.push(d[t])}a=O.position.values.length/3-4,q.push(a,a+2,a+1),q.push(a+1,a+2,a+3),a=b.position.values.length/3-4,x.push(a,a+2,a+1),x.push(a+1,a+2,a+3)}else{var j,Q;for(I.y<0?(j=p.attributes,Q=p.indices):(j=E.attributes,Q=E.indices),j.position.values.push(I.x,I.y,I.z),j.position.values.push(S.x,S.y,S.z),j.position.values.push(g.x,g.y,g.z),j.position.values.push(M.x,M.y,M.z),t=3*r;3*r+12>t;++t)j.prevPosition.values.push(l[t]),j.nextPosition.values.push(h[t]);for(t=2*r;2*r+8>t;++t)j.expandAndWidth.values.push(w[t]),c(d)&&j.st.values.push(d[t]);if(c(m))for(t=4*r;4*r+16>t;++t)j.color.values.push(m[t]);a=j.position.values.length/3-4,Q.push(a,a+2,a+1),Q.push(a+1,a+2,a+3)}}Z(e,p,E)}var re={};re.toWireframe=function(e){if(!c(e))throw new f("geometry is required.");var r=e.indices;if(c(r)){switch(e.primitiveType){case N.TRIANGLES:e.indices=g(r);break;case N.TRIANGLE_STRIP:e.indices=M(r);break;case N.TRIANGLE_FAN:e.indices=O(r);break;default:throw new f("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=N.LINES}return e},re.createLineSegmentsForVectors=function(e,r,n){if(r=s(r,"normal"),!c(e))throw new f("geometry is required.");if(!c(e.attributes.position))throw new f("geometry.attributes.position is required.");if(!c(e.attributes[r]))throw new f("geometry.attributes must have an attribute with the same name as the attributeName parameter, "+r+".");n=s(n,1e4);for(var i=e.attributes.position.values,o=e.attributes[r].values,a=i.length,l=new Float64Array(2*a),h=0,m=0;a>m;m+=3)l[h++]=i[m],l[h++]=i[m+1],l[h++]=i[m+2],l[h++]=i[m]+o[m]*n,l[h++]=i[m+1]+o[m+1]*n,l[h++]=i[m+2]+o[m+2]*n;var E,p=e.boundingSphere;return c(p)&&(E=new t(p.center,p.radius+n)),new w({attributes:{position:new d({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:l})},primitiveType:N.LINES,boundingSphere:E})},re.createAttributeLocations=function(e){if(!c(e))throw new f("geometry is required.");var r,t=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent","compressedAttributes"],n=e.attributes,i={},o=0,a=t.length;for(r=0;a>r;++r){var u=t[r];c(n[u])&&(i[u]=o++)}for(var s in n)n.hasOwnProperty(s)&&!c(i[s])&&(i[s]=o++);return i},re.reorderForPreVertexCache=function(e){if(!c(e))throw new f("geometry is required.");var r=w.computeNumberOfVertices(e),t=e.indices;if(c(t)){for(var n=new Int32Array(r),i=0;r>i;i++)n[i]=-1;for(var o,a=t,s=a.length,l=p.createTypedArray(r,s),h=0,d=0,m=0;s>h;)o=n[a[h]],-1!==o?l[d]=o:(o=a[h],n[o]=m,l[d]=m,++m),++h,++d;e.indices=l;var E=e.attributes;for(var y in E)if(E.hasOwnProperty(y)&&c(E[y])&&c(E[y].values)){for(var _=E[y],T=_.values,R=0,A=_.componentsPerAttribute,v=u.createTypedArray(_.componentDatatype,m*A);r>R;){var N=n[R];if(-1!==N)for(i=0;A>i;i++)v[A*N+i]=T[A*R+i];++R}_.values=v}}return e},re.reorderForPostVertexCache=function(e,r){if(!c(e))throw new f("geometry is required.");var t=e.indices;if(e.primitiveType===N.TRIANGLES&&c(t)){for(var n=t.length,i=0,o=0;n>o;o++)t[o]>i&&(i=t[o]);e.indices=I.tipsify({indices:t,maximumIndex:i,cacheSize:r})}return e},re.fitToUnsignedShortIndices=function(e){if(!c(e))throw new f("geometry is required.");if(c(e.indices)&&e.primitiveType!==N.TRIANGLES&&e.primitiveType!==N.LINES&&e.primitiveType!==N.POINTS)throw new f("geometry.primitiveType must equal to PrimitiveType.TRIANGLES, PrimitiveType.LINES, or PrimitiveType.POINTS.");var r=[],t=w.computeNumberOfVertices(e);if(c(e.indices)&&t>=T.SIXTY_FOUR_KILOBYTES){var n,i=[],o=[],a=0,u=q(e.attributes),s=e.indices,l=s.length;e.primitiveType===N.TRIANGLES?n=3:e.primitiveType===N.LINES?n=2:e.primitiveType===N.POINTS&&(n=1);for(var h=0;l>h;h+=n){for(var d=0;n>d;++d){var m=s[h+d],E=i[m];c(E)||(E=a++,i[m]=E,b(u,e.attributes,m)),o.push(E)}a+n>=T.SIXTY_FOUR_KILOBYTES&&(r.push(new w({attributes:u,indices:o,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),i=[],o=[],a=0,u=q(e.attributes))}0!==o.length&&r.push(new w({attributes:u,indices:o,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else r.push(e);return r};var te=new i,ne=new a;re.projectTo2D=function(e,r,t,n,o){if(!c(e))throw new f("geometry is required.");if(!c(r))throw new f("attributeName is required.");if(!c(t))throw new f("attributeName3D is required.");if(!c(n))throw new f("attributeName2D is required.");if(!c(e.attributes[r]))throw new f("geometry must have attribute matching the attributeName argument: "+r+".");if(e.attributes[r].componentDatatype!==u.DOUBLE)throw new f("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");var a=e.attributes[r];o=c(o)?o:new h;for(var s=o.ellipsoid,l=a.values,w=new Float64Array(l.length),m=0,E=0;E<l.length;E+=3){var p=i.fromArray(l,E,te),y=s.cartesianToCartographic(p,ne);if(!c(y))throw new f("Could not project point ("+p.x+", "+p.y+", "+p.z+") to 2D.");var _=o.project(y,te);w[m++]=_.x,w[m++]=_.y,w[m++]=_.z}return e.attributes[t]=a,e.attributes[n]=new d({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:w}),delete e.attributes[r],e};var ie={high:0,low:0};re.encodeAttribute=function(e,r,t,n){if(!c(e))throw new f("geometry is required.");if(!c(r))throw new f("attributeName is required.");if(!c(t))throw new f("attributeHighName is required.");if(!c(n))throw new f("attributeLowName is required.");if(!c(e.attributes[r]))throw new f("geometry must have attribute matching the attributeName argument: "+r+".");if(e.attributes[r].componentDatatype!==u.DOUBLE)throw new f("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");for(var i=e.attributes[r],o=i.values,a=o.length,s=new Float32Array(a),h=new Float32Array(a),w=0;a>w;++w)l.encode(o[w],ie),s[w]=ie.high,h[w]=ie.low;var m=i.componentsPerAttribute;return e.attributes[t]=new d({componentDatatype:u.FLOAT,componentsPerAttribute:m,values:s}),e.attributes[n]=new d({componentDatatype:u.FLOAT,componentsPerAttribute:m,values:h}),delete e.attributes[r],e};var oe=new i,ae=new A,ue=new R;re.transformToWorldCoordinates=function(e){if(!c(e))throw new f("instance is required.");var r=e.modelMatrix;if(A.equals(r,A.IDENTITY))return e;var n=e.geometry.attributes;x(r,n.position),x(r,n.prevPosition),x(r,n.nextPosition),(c(n.normal)||c(n.binormal)||c(n.tangent))&&(A.inverse(r,ae),A.transpose(ae,ae),A.getRotation(ae,ue),P(ue,n.normal),P(ue,n.binormal),P(ue,n.tangent));var i=e.geometry.boundingSphere;return c(i)&&(e.geometry.boundingSphere=t.transform(i,r,i)),e.modelMatrix=A.clone(A.IDENTITY),e};var se=new i;re.combineInstances=function(e){if(!c(e)||e.length<1)throw new f("instances is required and must have length greater than zero.");for(var r=[],t=[],n=e.length,i=0;n>i;++i){var o=e[i];c(o.geometry)?r.push(o):t.push(o)}var a=[];return r.length>0&&a.push(C(r,"geometry")),t.length>0&&(a.push(C(t,"westHemisphereGeometry")),a.push(C(t,"eastHemisphereGeometry"))),a};var ce=new i,fe=new i,le=new i,he=new i;re.computeNormal=function(e){if(!c(e))throw new f("geometry is required.");if(!c(e.attributes.position)||!c(e.attributes.position.values))throw new f("geometry.attributes.position.values is required.");if(!c(e.indices))throw new f("geometry.indices is required.");if(e.indices.length<2||e.indices.length%3!==0)throw new f("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==N.TRIANGLES)throw new f("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var r=e.indices,t=e.attributes,n=t.position.values,o=t.position.values.length/3,a=r.length,s=new Array(o),l=new Array(a/3),h=new Array(a),w=0;o>w;w++)s[w]={indexOffset:0,count:0,currentCount:0};var m=0;for(w=0;a>w;w+=3){var E=r[w],p=r[w+1],y=r[w+2],_=3*E,T=3*p,R=3*y;fe.x=n[_],fe.y=n[_+1],fe.z=n[_+2],le.x=n[T],le.y=n[T+1],le.z=n[T+2],he.x=n[R],he.y=n[R+1],he.z=n[R+2],s[E].count++,s[p].count++,s[y].count++,i.subtract(le,fe,le),i.subtract(he,fe,he),l[m]=i.cross(le,he,new i),m++}var A=0;for(w=0;o>w;w++)s[w].indexOffset+=A,A+=s[w].count;m=0;var v;for(w=0;a>w;w+=3){v=s[r[w]];var I=v.indexOffset+v.currentCount;h[I]=m,v.currentCount++,v=s[r[w+1]],I=v.indexOffset+v.currentCount,h[I]=m,v.currentCount++,v=s[r[w+2]],I=v.indexOffset+v.currentCount,h[I]=m,v.currentCount++,m++}var S=new Float32Array(3*o);for(w=0;o>w;w++){var g=3*w;if(v=s[w],v.count>0){for(i.clone(i.ZERO,ce),m=0;m<v.count;m++)i.add(ce,l[h[v.indexOffset+m]],ce);i.normalize(ce,ce),S[g]=ce.x,S[g+1]=ce.y,S[g+2]=ce.z}else S[g]=0,S[g+1]=0,S[g+2]=1}return e.attributes.normal=new d({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:S}),e};var we=new i,de=new i,me=new i;re.computeBinormalAndTangent=function(e){if(!c(e))throw new f("geometry is required.");var r=e.attributes,t=e.indices;if(!c(r.position)||!c(r.position.values))throw new f("geometry.attributes.position.values is required.");if(!c(r.normal)||!c(r.normal.values))throw new f("geometry.attributes.normal.values is required.");if(!c(r.st)||!c(r.st.values))throw new f("geometry.attributes.st.values is required.");if(!c(t))throw new f("geometry.indices is required.");if(t.length<2||t.length%3!==0)throw new f("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==N.TRIANGLES)throw new f("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var n=e.attributes.position.values,o=e.attributes.normal.values,a=e.attributes.st.values,s=e.attributes.position.values.length/3,l=t.length,h=new Array(3*s),w=0;w<h.length;w++)h[w]=0;var m,E,p;for(w=0;l>w;w+=3){var y=t[w],_=t[w+1],T=t[w+2];m=3*y,E=3*_,p=3*T;var R=2*y,A=2*_,v=2*T,I=n[m],S=n[m+1],g=n[m+2],M=a[R],O=a[R+1],q=a[A+1]-O,b=a[v+1]-O,x=1/((a[A]-M)*b-(a[v]-M)*q),P=(b*(n[E]-I)-q*(n[p]-I))*x,L=(b*(n[E+1]-S)-q*(n[p+1]-S))*x,C=(b*(n[E+2]-g)-q*(n[p+2]-g))*x;h[m]+=P,h[m+1]+=L,h[m+2]+=C,h[E]+=P,h[E+1]+=L,h[E+2]+=C,h[p]+=P,h[p+1]+=L,h[p+2]+=C}var F=new Float32Array(3*s),U=new Float32Array(3*s);for(w=0;s>w;w++){m=3*w,E=m+1,p=m+2;var D=i.fromArray(o,m,we),B=i.fromArray(h,m,me),z=i.dot(D,B);i.multiplyByScalar(D,z,de),i.normalize(i.subtract(B,de,B),B),U[m]=B.x,U[E]=B.y,U[p]=B.z,i.normalize(i.cross(D,B,B),B),F[m]=B.x,F[E]=B.y,F[p]=B.z}return e.attributes.tangent=new d({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:U}),e.attributes.binormal=new d({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:F}),e};var Ee=new n,pe=new i,ye=new i,_e=new i;re.compressVertices=function(r){if(!c(r))throw new f("geometry is required.");var t=r.attributes.normal,o=r.attributes.st;if(!c(t)&&!c(o))return r;var a,s,l,h,w=r.attributes.tangent,m=r.attributes.binormal;c(t)&&(a=t.values),c(o)&&(s=o.values),c(w)&&(l=w.values),m&&(h=m.values);var E=c(a)?a.length:s.length,p=c(a)?3:2,y=E/p,_=y,T=c(s)&&c(a)?2:1;T+=c(l)||c(h)?1:0,_*=T;for(var R=new Float32Array(_),A=0,v=0;y>v;++v){c(s)&&(n.fromArray(s,2*v,Ee),R[A++]=e.compressTextureCoordinates(Ee));var N=3*v;c(a)&&c(l)&&c(h)?(i.fromArray(a,N,pe),i.fromArray(l,N,ye),i.fromArray(h,N,_e),e.octPack(pe,ye,_e,Ee),R[A++]=Ee.x,R[A++]=Ee.y):(c(a)&&(i.fromArray(a,N,pe),R[A++]=e.octEncodeFloat(pe)),c(l)&&(i.fromArray(l,N,pe),R[A++]=e.octEncodeFloat(pe)),c(h)&&(i.fromArray(h,N,pe),R[A++]=e.octEncodeFloat(pe)))}return r.attributes.compressedAttributes=new d({componentDatatype:u.FLOAT,componentsPerAttribute:T,values:R}),c(a)&&delete r.attributes.normal,c(s)&&delete r.attributes.st,c(l)&&delete r.attributes.tangent,c(h)&&delete r.attributes.binormal,r};var Te=new i,Re=new i,Ae=new i,ve=new i,Ne=new i,Ie={positions:new Array(7),indices:new Array(9)},Se=new i,ge=new i,Me=new i,Oe=new i,qe=new n,be=new n,xe=new n,Pe=v.fromPointNormal(i.ZERO,i.UNIT_Y),Le=new i,Ce=new i,Fe=new n,Ue=new n,De=new i,Be=new i,ze=new i,Ge=new i,Ve=new i,Xe=new i,He=new i,We=new o;new o;return re.splitLongitude=function(e){if(!c(e))throw new f("instance is required.");var r=e.geometry,n=r.boundingSphere;if(c(n)){var i=n.center.x-n.radius;if(i>0||t.intersectPlane(n,v.ORIGIN_ZX_PLANE)!==y.INTERSECTING)return e}if(r.geometryType!==E.NONE)switch(r.geometryType){case E.POLYLINES:ee(e);break;case E.TRIANGLES:J(e);break;case E.LINES:$(e)}else V(r),r.primitiveType===N.TRIANGLES?J(e):r.primitiveType===N.LINES&&$(e);return e},re}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,r,t,n){"use strict";var i=function(r){r=e(r,e.EMPTY_OBJECT),this.position=e(r.position,!1),this.normal=e(r.normal,!1),this.st=e(r.st,!1),this.binormal=e(r.binormal,!1),this.tangent=e(r.tangent,!1),this.color=e(r.color,!1)};return i.POSITION_ONLY=n(new i({position:!0})),i.POSITION_AND_NORMAL=n(new i({position:!0,normal:!0})),i.POSITION_NORMAL_AND_ST=n(new i({position:!0,normal:!0,st:!0})),i.POSITION_AND_ST=n(new i({position:!0,st:!0})),i.POSITION_AND_COLOR=n(new i({position:!0,color:!0})),i.ALL=n(new i({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),i.DEFAULT=i.POSITION_NORMAL_AND_ST,i.packedLength=6,i.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.position?1:0,i[o++]=n.normal?1:0,i[o++]=n.st?1:0,i[o++]=n.binormal?1:0,i[o++]=n.tangent?1:0,i[o++]=n.color?1:0},i.unpack=function(n,o,a){if(!r(n))throw new t("array is required");return o=e(o,0),r(a)||(a=new i),a.position=1===n[o++],a.normal=1===n[o++],a.st=1===n[o++],a.binormal=1===n[o++],a.tangent=1===n[o++],a.color=1===n[o++],a},i.clone=function(e,t){return r(e)?(r(t)||(t=new i),t.position=e.position,t.normal=e.normal,t.st=e.st,t.binormal=e.binormal,t.tangent=e.tangent,t.color=e.color,t):void 0},i}),define("Core/EllipseGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EllipseGeometryLibrary","./Ellipsoid","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./Matrix3","./PrimitiveType","./Quaternion","./VertexFormat"],function(e,r,t,n,i,o,a,u,s,c,f,l,h,w,d,m,E,p,y,_,T,R){"use strict";function A(e,n,o){var a=n.vertexFormat,u=n.center,c=n.semiMajorAxis,l=n.semiMinorAxis,d=n.ellipsoid,m=n.stRotation,E=o?e.length/3*2:e.length/3,p=a.st?new Float32Array(2*E):void 0,_=a.normal?new Float32Array(3*E):void 0,R=a.tangent?new Float32Array(3*E):void 0,A=a.binormal?new Float32Array(3*E):void 0,v=0,N=C,I=F,S=U,g=new f(d),b=g.project(d.cartesianToCartographic(u,D),B),V=d.scaleToGeodeticSurface(u,M);d.geodeticSurfaceNormal(V,V);for(var X=T.fromAxisAngle(V,m,L),H=y.fromQuaternion(X,P),W=r.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,z),Y=r.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,G),k=e.length,K=o?k:0,Z=K/3*2,j=0;k>j;j+=3){var Q=j+1,J=j+2,$=t.fromArray(e,j,M);if(a.st){var ee=y.multiplyByVector(H,$,O),re=g.project(d.cartesianToCartographic(ee,D),q);t.subtract(re,b,re),x.x=(re.x+c)/(2*c),x.y=(re.y+l)/(2*l),W.x=Math.min(x.x,W.x),W.y=Math.min(x.y,W.y),Y.x=Math.max(x.x,Y.x),Y.y=Math.max(x.y,Y.y),o&&(p[v+Z]=x.x,p[v+1+Z]=x.y),p[v++]=x.x,p[v++]=x.y}N=d.geodeticSurfaceNormal($,N),(a.normal||a.tangent||a.binormal)&&((a.tangent||a.binormal)&&(I=t.cross(t.UNIT_Z,N,I),y.multiplyByVector(H,I,I)),a.normal&&(_[j]=N.x,_[Q]=N.y,_[J]=N.z,o&&(_[j+K]=-N.x,_[Q+K]=-N.y,_[J+K]=-N.z)),a.tangent&&(R[j]=I.x,R[Q]=I.y,R[J]=I.z,o&&(R[j+K]=-I.x,
R[Q+K]=-I.y,R[J+K]=-I.z)),a.binormal&&(S=t.cross(N,I,S),A[j]=S.x,A[Q]=S.y,A[J]=S.z,o&&(A[j+K]=S.x,A[Q+K]=S.y,A[J+K]=S.z)))}if(a.st){k=p.length;for(var te=0;k>te;te+=2)p[te]=(p[te]-W.x)/(Y.x-W.x),p[te+1]=(p[te+1]-W.y)/(Y.y-W.y)}var ne=new w;if(a.position){var ie=s.raisePositionsToHeight(e,n,o);ne.position=new h({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:ie})}return a.st&&(ne.st=new h({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:p})),a.normal&&(ne.normal=new h({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:_})),a.tangent&&(ne.tangent=new h({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:R})),a.binormal&&(ne.binormal=new h({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:A})),ne}function v(e){var r,t,n,i,o,a=new Array(2*e*(e+1)),u=0;for(i=1;e>i;++i){for(n=i*(i+1),r=(i-1)*i,a[u++]=n++,a[u++]=r,a[u++]=n,t=2*i,o=0;t-1>o;++o)a[u++]=n,a[u++]=r++,a[u++]=r,a[u++]=n++,a[u++]=r,a[u++]=n;a[u++]=n++,a[u++]=r,a[u++]=n}for(t=2*e,++n,++r,i=0;t-1>i;++i)a[u++]=n,a[u++]=r++,a[u++]=r,a[u++]=n++,a[u++]=r,a[u++]=n;for(++r,++n,i=e-1;i>0;--i){for(a[u++]=r++,a[u++]=r,a[u++]=n,t=2*i,o=0;t-1>o;++o)a[u++]=n,a[u++]=r++,a[u++]=r,a[u++]=n++,a[u++]=r,a[u++]=n;a[u++]=r++,a[u++]=r++,a[u++]=n++}return a}function N(r){var n=r.center;V=t.multiplyByScalar(r.ellipsoid.geodeticSurfaceNormal(n,V),r.height,V),V=t.add(n,V,V);var i=new e(V,r.semiMajorAxis),o=s.computeEllipsePositions(r,!0,!1),a=o.positions,u=o.numPts,c=A(a,r,!1),f=v(u);return f=E.createTypedArray(a.length/3,f),{boundingSphere:i,attributes:c,indices:f}}function I(e,n){var o=n.vertexFormat,a=n.center,u=n.semiMajorAxis,s=n.semiMinorAxis,c=n.ellipsoid,l=n.height,d=n.extrudedHeight,m=n.stRotation,E=e.length/3*2,p=new Float64Array(3*E),_=o.st?new Float32Array(2*E):void 0,R=o.normal?new Float32Array(3*E):void 0,A=o.tangent?new Float32Array(3*E):void 0,v=o.binormal?new Float32Array(3*E):void 0,N=0,I=C,S=F,g=U,V=new f(c),X=V.project(c.cartesianToCartographic(a,D),B),H=c.scaleToGeodeticSurface(a,M);c.geodeticSurfaceNormal(H,H);for(var W=T.fromAxisAngle(H,m,L),Y=y.fromQuaternion(W,P),k=r.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,z),K=r.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,G),Z=e.length,j=Z/3*2,Q=0;Z>Q;Q+=3){var J,$=Q+1,ee=Q+2,re=t.fromArray(e,Q,M);if(o.st){var te=y.multiplyByVector(Y,re,O),ne=V.project(c.cartesianToCartographic(te,D),q);t.subtract(ne,X,ne),x.x=(ne.x+u)/(2*u),x.y=(ne.y+s)/(2*s),k.x=Math.min(x.x,k.x),k.y=Math.min(x.y,k.y),K.x=Math.max(x.x,K.x),K.y=Math.max(x.y,K.y),_[N+j]=x.x,_[N+1+j]=x.y,_[N++]=x.x,_[N++]=x.y}re=c.scaleToGeodeticSurface(re,re),J=t.clone(re,O),I=c.geodeticSurfaceNormal(re,I);var ie=t.multiplyByScalar(I,l,b);if(re=t.add(re,ie,re),ie=t.multiplyByScalar(I,d,ie),J=t.add(J,ie,J),o.position&&(p[Q+Z]=J.x,p[$+Z]=J.y,p[ee+Z]=J.z,p[Q]=re.x,p[$]=re.y,p[ee]=re.z),o.normal||o.tangent||o.binormal){g=t.clone(I,g);var oe=t.fromArray(e,(Q+3)%Z,b);t.subtract(oe,re,oe);var ae=t.subtract(J,re,q);I=t.normalize(t.cross(ae,oe,I),I),o.normal&&(R[Q]=I.x,R[$]=I.y,R[ee]=I.z,R[Q+Z]=I.x,R[$+Z]=I.y,R[ee+Z]=I.z),o.tangent&&(S=t.normalize(t.cross(g,I,S),S),A[Q]=S.x,A[$]=S.y,A[ee]=S.z,A[Q+Z]=S.x,A[Q+1+Z]=S.y,A[Q+2+Z]=S.z),o.binormal&&(v[Q]=g.x,v[$]=g.y,v[ee]=g.z,v[Q+Z]=g.x,v[$+Z]=g.y,v[ee+Z]=g.z)}}if(o.st){Z=_.length;for(var ue=0;Z>ue;ue+=2)_[ue]=(_[ue]-k.x)/(K.x-k.x),_[ue+1]=(_[ue+1]-k.y)/(K.y-k.y)}var se=new w;return o.position&&(se.position=new h({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:p})),o.st&&(se.st=new h({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:_})),o.normal&&(se.normal=new h({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:R})),o.tangent&&(se.tangent=new h({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:A})),o.binormal&&(se.binormal=new h({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:v})),se}function S(e){for(var r=e.length/3,t=E.createTypedArray(r,6*r),n=0,i=0;r>i;i++){var o=i,a=i+r,u=(o+1)%r,s=u+r;t[n++]=o,t[n++]=a,t[n++]=u,t[n++]=u,t[n++]=a,t[n++]=s}return t}function g(r){var n=r.center,i=r.ellipsoid,o=r.semiMajorAxis,a=t.multiplyByScalar(i.geodeticSurfaceNormal(n,M),r.height,M);X.center=t.add(n,a,X.center),X.radius=o,a=t.multiplyByScalar(i.geodeticSurfaceNormal(n,a),r.extrudedHeight,a),H.center=t.add(n,a,H.center),H.radius=o;var u=s.computeEllipsePositions(r,!0,!0),c=u.positions,f=u.numPts,h=u.outerPositions,w=e.union(X,H),p=A(c,r,!0),y=v(f),T=y.length;y.length=2*T;for(var R=c.length/3,N=0;T>N;N+=3)y[N+T]=y[N+2]+R,y[N+1+T]=y[N+1]+R,y[N+2+T]=y[N]+R;var g=E.createTypedArray(2*R/3,y),O=new l({attributes:p,indices:g,primitiveType:_.TRIANGLES}),q=I(h,r);y=S(h);var b=E.createTypedArray(2*h.length/3,y),x=new l({attributes:q,indices:b,primitiveType:_.TRIANGLES}),P=m.combineInstances([new d({geometry:O}),new d({geometry:x})]);return{boundingSphere:w,attributes:P[0].attributes,indices:P[0].indices}}var M=new t,O=new t,q=new t,b=new t,x=new r,P=new y,L=new T,C=new t,F=new t,U=new t,D=new n,B=new t,z=new r,G=new r,V=new t,X=new e,H=new e,W=function(e){e=o(e,o.EMPTY_OBJECT);var r=e.center,n=o(e.ellipsoid,c.WGS84),i=e.semiMajorAxis,s=e.semiMinorAxis,f=o(e.granularity,p.RADIANS_PER_DEGREE),l=o(e.height,0),h=e.extrudedHeight,w=a(h)&&Math.abs(l-h)>1,d=o(e.vertexFormat,R.DEFAULT);if(!a(r))throw new u("center is required.");if(!a(i))throw new u("semiMajorAxis is required.");if(!a(s))throw new u("semiMinorAxis is required.");if(0>=i||0>=s)throw new u("Semi-major and semi-minor axes must be greater than zero.");if(s>i)throw new u("semiMajorAxis must be greater than or equal to the semiMinorAxis.");if(0>=f)throw new u("granularity must be greater than zero.");this._center=t.clone(r),this._semiMajorAxis=i,this._semiMinorAxis=s,this._ellipsoid=c.clone(n),this._rotation=o(e.rotation,0),this._stRotation=o(e.stRotation,0),this._height=l,this._granularity=f,this._vertexFormat=R.clone(d),this._extrudedHeight=o(h,l),this._extrude=w,this._workerName="createEllipseGeometry"};W.packedLength=t.packedLength+c.packedLength+R.packedLength+8,W.pack=function(e,r,n){if(!a(e))throw new u("value is required");if(!a(r))throw new u("array is required");n=o(n,0),t.pack(e._center,r,n),n+=t.packedLength,c.pack(e._ellipsoid,r,n),n+=c.packedLength,R.pack(e._vertexFormat,r,n),n+=R.packedLength,r[n++]=e._semiMajorAxis,r[n++]=e._semiMinorAxis,r[n++]=e._rotation,r[n++]=e._stRotation,r[n++]=e._height,r[n++]=e._granularity,r[n++]=e._extrudedHeight,r[n]=e._extrude?1:0};var Y=new t,k=new c,K=new R,Z={center:Y,ellipsoid:k,vertexFormat:K,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,stRotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0};return W.unpack=function(e,r,n){if(!a(e))throw new u("array is required");r=o(r,0);var i=t.unpack(e,r,Y);r+=t.packedLength;var s=c.unpack(e,r,k);r+=c.packedLength;var f=R.unpack(e,r,K);r+=R.packedLength;var l=e[r++],h=e[r++],w=e[r++],d=e[r++],m=e[r++],E=e[r++],p=e[r++],y=1===e[r];return a(n)?(n._center=t.clone(i,n._center),n._ellipsoid=c.clone(s,n._ellipsoid),n._vertexFormat=R.clone(f,n._vertexFormat),n._semiMajorAxis=l,n._semiMinorAxis=h,n._rotation=w,n._stRotation=d,n._height=m,n._granularity=E,n._extrudedHeight=p,n._extrude=y,n):(Z.height=m,Z.extrudedHeight=p,Z.granularity=E,Z.stRotation=d,Z.rotation=w,Z.semiMajorAxis=l,Z.semiMinorAxis=h,new W(Z))},W.createGeometry=function(e){e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);var r,t={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:e._height,extrudedHeight:e._extrudedHeight,granularity:e._granularity,vertexFormat:e._vertexFormat,stRotation:e._stRotation};return e._extrude?(t.extrudedHeight=Math.min(e._extrudedHeight,e._height),t.height=Math.max(e._extrudedHeight,e._height),r=g(t)):r=N(t),new l({attributes:r.attributes,indices:r.indices,primitiveType:_.TRIANGLES,boundingSphere:r.boundingSphere})},W.createShadowVolume=function(e,r,t){var n=e._granularity,i=e._ellipsoid,o=r(n,i),a=t(n,i);return new W({center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:i,stRotation:e._stRotation,granularity:n,extrudedHeight:o,height:a,vertexFormat:R.POSITION_ONLY})},W}),define("Workers/createEllipseGeometry",["../Core/Cartesian3","../Core/defined","../Core/EllipseGeometry","../Core/Ellipsoid"],function(e,r,t,n){"use strict";function i(i,o){return r(o)&&(i=t.unpack(i,o)),i._center=e.clone(i._center),i._ellipsoid=n.clone(i._ellipsoid),t.createGeometry(i)}return i})}();