/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var r=Object.freeze;return e(r)||(r=function(e){return e}),r}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var r=function(e,r){return void 0!==e?e:r};return r.EMPTY_OBJECT=e({}),r}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var r=function(e){this.name="DeveloperError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r.throwInstantiationError=function(){throw new r("This function defines an interface and should not be called directly.")},r}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var t;for(this.mti==this.N+1&&this.init_genrand(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^r[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^r[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^r[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,r,t,i){"use strict";var n={};n.EPSILON1=.1,n.EPSILON2=.01,n.EPSILON3=.001,n.EPSILON4=1e-4,n.EPSILON5=1e-5,n.EPSILON6=1e-6,n.EPSILON7=1e-7,n.EPSILON8=1e-8,n.EPSILON9=1e-9,n.EPSILON10=1e-10,n.EPSILON11=1e-11,n.EPSILON12=1e-12,n.EPSILON13=1e-13,n.EPSILON14=1e-14,n.EPSILON15=1e-15,n.EPSILON16=1e-16,n.EPSILON17=1e-17,n.EPSILON18=1e-18,n.EPSILON19=1e-19,n.EPSILON20=1e-20,n.GRAVITATIONALPARAMETER=3986004418e5,n.SOLAR_RADIUS=6955e5,n.LUNAR_RADIUS=1737400,n.SIXTY_FOUR_KILOBYTES=65536,n.sign=function(e){return e>0?1:0>e?-1:0},n.signNotZero=function(e){return 0>e?-1:1},n.toSNorm=function(e){return Math.round(255*(.5*n.clamp(e,-1,1)+.5))},n.fromSNorm=function(e){return n.clamp(e,0,255)/255*2-1},n.sinh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r-t)},n.cosh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r+t)},n.lerp=function(e,r,t){return(1-t)*e+t*r},n.PI=Math.PI,n.ONE_OVER_PI=1/Math.PI,n.PI_OVER_TWO=.5*Math.PI,n.PI_OVER_THREE=Math.PI/3,n.PI_OVER_FOUR=Math.PI/4,n.PI_OVER_SIX=Math.PI/6,n.THREE_PI_OVER_TWO=3*Math.PI*.5,n.TWO_PI=2*Math.PI,n.ONE_OVER_TWO_PI=1/(2*Math.PI),n.RADIANS_PER_DEGREE=Math.PI/180,n.DEGREES_PER_RADIAN=180/Math.PI,n.RADIANS_PER_ARCSECOND=n.RADIANS_PER_DEGREE/3600,n.toRadians=function(e){if(!t(e))throw new i("degrees is required.");return e*n.RADIANS_PER_DEGREE},n.toDegrees=function(e){if(!t(e))throw new i("radians is required.");return e*n.DEGREES_PER_RADIAN},n.convertLongitudeRange=function(e){if(!t(e))throw new i("angle is required.");var r=n.TWO_PI,o=e-Math.floor(e/r)*r;return o<-Math.PI?o+r:o>=Math.PI?o-r:o},n.negativePiToPi=function(e){if(!t(e))throw new i("x is required.");return n.zeroToTwoPi(e+n.PI)-n.PI},n.zeroToTwoPi=function(e){if(!t(e))throw new i("x is required.");var r=n.mod(e,n.TWO_PI);return Math.abs(r)<n.EPSILON14&&Math.abs(e)>n.EPSILON14?n.TWO_PI:r},n.mod=function(e,r){if(!t(e))throw new i("m is required.");if(!t(r))throw new i("n is required.");return(e%r+r)%r},n.equalsEpsilon=function(e,n,o,a){if(!t(e))throw new i("left is required.");if(!t(n))throw new i("right is required.");if(!t(o))throw new i("relativeEpsilon is required.");a=r(a,o);var u=Math.abs(e-n);return a>=u||u<=o*Math.max(Math.abs(e),Math.abs(n))};var o=[1];n.factorial=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");var r=o.length;if(e>=r)for(var t=o[r-1],n=r;e>=n;n++)o.push(t*n);return o[e]},n.incrementWrap=function(e,n,o){if(o=r(o,0),!t(e))throw new i("n is required.");if(o>=n)throw new i("maximumValue must be greater than minimumValue.");return++e,e>n&&(e=o),e},n.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},n.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},n.clamp=function(e,r,n){if(!t(e))throw new i("value is required");if(!t(r))throw new i("min is required.");if(!t(n))throw new i("max is required.");return r>e?r:e>n?n:e};var a=new e;return n.setRandomNumberSeed=function(r){if(!t(r))throw new i("seed is required.");a=new e(r)},n.nextRandomNumber=function(){return a.random()},n.acosClamped=function(e){if(!t(e))throw new i("value is required.");return Math.acos(n.clamp(e,-1,1))},n.asinClamped=function(e){if(!t(e))throw new i("value is required.");return Math.asin(n.clamp(e,-1,1))},n.chordLength=function(e,r){if(!t(e))throw new i("angle is required.");if(!t(r))throw new i("radius is required.");return 2*r*Math.sin(.5*e)},n}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n){"use strict";var o=function(r,t,i){this.x=e(r,0),this.y=e(t,0),this.z=e(i,0)};o.fromSpherical=function(i,n){if(!r(i))throw new t("spherical is required");r(n)||(n=new o);var a=i.clock,u=i.cone,s=e(i.magnitude,1),E=s*Math.sin(u);return n.x=E*Math.cos(a),n.y=E*Math.sin(a),n.z=s*Math.cos(u),n},o.fromElements=function(e,t,i,n){return r(n)?(n.x=e,n.y=t,n.z=i,n):new o(e,t,i)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new o(e.x,e.y,e.z):void 0},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(i,n,o){if(!r(i))throw new t("value is required");if(!r(n))throw new t("array is required");o=e(o,0),n[o++]=i.x,n[o++]=i.y,n[o]=i.z},o.unpack=function(i,n,a){if(!r(i))throw new t("array is required");return n=e(n,0),r(a)||(a=new o),a.x=i[n++],a.y=i[n++],a.z=i[n],a},o.fromArray=o.unpack,o.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z)},o.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z)},o.minimumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.min(e.x,i.x),n.y=Math.min(e.y,i.y),n.z=Math.min(e.z,i.z),n},o.maximumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.max(e.x,i.x),n.y=Math.max(e.y,i.y),n.z=Math.max(e.z,i.z),n},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,i){if(!r(e)||!r(i))throw new t("left and right are required.");return o.subtract(e,i,a),o.magnitude(a)},o.distanceSquared=function(e,i){if(!r(e)||!r(i))throw new t("left and right are required.");return o.subtract(e,i,a),o.magnitudeSquared(a)},o.normalize=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");var n=o.magnitude(e);return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i},o.dot=function(e,i){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");return e.x*i.x+e.y*i.y+e.z*i.z},o.multiplyComponents=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x*i.x,n.y=e.y*i.y,n.z=e.z*i.z,n},o.add=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x+i.x,n.y=e.y+i.y,n.z=e.z+i.z,n},o.subtract=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x-i.x,n.y=e.y-i.y,n.z=e.z-i.z,n},o.multiplyByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x*i,n.y=e.y*i,n.z=e.z*i,n},o.divideByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n},o.negate=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=-e.x,i.y=-e.y,i.z=-e.z,i},o.abs=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=Math.abs(e.x),i.y=Math.abs(e.y),i.z=Math.abs(e.z),i};var u=new o;o.lerp=function(e,i,n,a){if(!r(e))throw new t("start is required.");if(!r(i))throw new t("end is required.");if("number"!=typeof n)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(i,n,u),a=o.multiplyByScalar(e,1-n,a),o.add(u,a,a)};var s=new o,E=new o;o.angleBetween=function(e,i){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");o.normalize(e,s),o.normalize(i,E);var n=o.dot(s,E),a=o.magnitude(o.cross(s,E,s));return Math.atan2(a,n)};var w=new o;o.mostOrthogonalAxis=function(e,i){if(!r(e))throw new t("cartesian is required.");if(!r(i))throw new t("result is required.");var n=o.normalize(e,w);return o.abs(n,n),i=n.x<=n.y?n.x<=n.z?o.clone(o.UNIT_X,i):o.clone(o.UNIT_Z,i):n.y<=n.z?o.clone(o.UNIT_Y,i):o.clone(o.UNIT_Z,i)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},o.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]&&e.z===r[t+2]},o.equalsEpsilon=function(e,t,i,o){return e===t||r(e)&&r(t)&&n.equalsEpsilon(e.x,t.x,i,o)&&n.equalsEpsilon(e.y,t.y,i,o)&&n.equalsEpsilon(e.z,t.z,i,o)},o.cross=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");var o=e.x,a=e.y,u=e.z,s=i.x,E=i.y,w=i.z,f=a*w-u*E,h=u*s-o*w,c=o*E-a*s;return n.x=f,n.y=h,n.z=c,n},o.fromDegrees=function(e,i,a,u,s){if(!r(e))throw new t("longitude is required");if(!r(i))throw new t("latitude is required");var E=n.toRadians(e),w=n.toRadians(i);return o.fromRadians(E,w,a,u,s)};var f=new o,h=new o,c=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(i,n,a,u,s){if(!r(i))throw new t("longitude is required");if(!r(n))throw new t("latitude is required");a=e(a,0);var E=r(u)?u.radiiSquared:c,w=Math.cos(n);f.x=w*Math.cos(i),f.y=w*Math.sin(i),f.z=Math.sin(n),f=o.normalize(f,f),o.multiplyComponents(E,f,h);var l=Math.sqrt(o.dot(f,h));return h=o.divideByScalar(h,l,h),f=o.multiplyByScalar(f,a,f),r(s)||(s=new o),o.add(h,f,s)},o.fromDegreesArray=function(e,i,a){if(!r(e))throw new t("positions is required.");for(var u=new Array(e.length),s=0;s<e.length;s++)u[s]=n.toRadians(e[s]);return o.fromRadiansArray(u,i,a)},o.fromRadiansArray=function(e,i,n){if(!r(e))throw new t("positions is required.");if(e.length<2)throw new t("positions length cannot be less than 2.");if(e.length%2!==0)throw new t("positions length must be a multiple of 2.");var a=e.length;r(n)?n.length=a/2:n=new Array(a/2);for(var u=0;a>u;u+=2){var s=e[u],E=e[u+1];n[u/2]=o.fromRadians(s,E,0,i,n[u/2])}return n},o.fromDegreesArrayHeights=function(e,i,a){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(e.length%3!==0)throw new t("positions length must be a multiple of 3.");for(var u=new Array(e.length),s=0;s<e.length;s+=3)u[s]=n.toRadians(e[s]),u[s+1]=n.toRadians(e[s+1]),u[s+2]=e[s+2];return o.fromRadiansArrayHeights(u,i,a)},o.fromRadiansArrayHeights=function(e,i,n){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(e.length%3!==0)throw new t("positions length must be a multiple of 3.");var a=e.length;r(n)?n.length=a/3:n=new Array(a/3);for(var u=0;a>u;u+=3){var s=e[u],E=e[u+1],w=e[u+2];n[u/3]=o.fromRadians(s,E,w,i,n[u/3])}return n},o.ZERO=i(new o(0,0,0)),o.UNIT_X=i(new o(1,0,0)),o.UNIT_Y=i(new o(0,1,0)),o.UNIT_Z=i(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r,t){return o.equalsEpsilon(this,e,r,t)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n){"use strict";var o=function(r,t,i){this.longitude=e(r,0),this.latitude=e(t,0),this.height=e(i,0)};return o.fromRadians=function(i,n,a,u){if(!r(i))throw new t("longitude is required.");if(!r(n))throw new t("latitude is required.");return a=e(a,0),r(u)?(u.longitude=i,u.latitude=n,u.height=a,u):new o(i,n,a)},o.fromDegrees=function(e,i,a,u){if(!r(e))throw new t("longitude is required.");if(!r(i))throw new t("latitude is required.");return e=n.toRadians(e),i=n.toRadians(i),o.fromRadians(e,i,a,u)},o.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new o(e.longitude,e.latitude,e.height):void 0},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},o.equalsEpsilon=function(e,i,n){if("number"!=typeof n)throw new t("epsilon is required and must be a number.");return e===i||r(e)&&r(i)&&Math.abs(e.longitude-i.longitude)<=n&&Math.abs(e.latitude-i.latitude)<=n&&Math.abs(e.height-i.height)<=n},o.ZERO=i(new o(0,0,0)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r){return o.equalsEpsilon(this,e,r)},o.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},o}),define("Core/deprecationWarning",["./defined","./DeveloperError"],function(e,r){"use strict";var t={},i=function(i,n){if(!e(i)||!e(n))throw new r("identifier and message are required.");e(t[i])||(t[i]=!0,console.log(n))};return i}),define("Core/defineProperties",["./defined"],function(e){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),t=Object.defineProperties;return r&&e(t)||(t=function(e){return e}),t}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n,o,a,u){"use strict";function s(r,i,n,a){if(i=t(i,0),n=t(n,0),a=t(a,0),0>i||0>n||0>a)throw new o("All radii components must be greater than or equal to zero.");r._radii=new e(i,n,a),r._radiiSquared=new e(i*i,n*n,a*a),r._radiiToTheFourth=new e(i*i*i*i,n*n*n*n,a*a*a*a),r._oneOverRadii=new e(0===i?0:1/i,0===n?0:1/n,0===a?0:1/a),r._oneOverRadiiSquared=new e(0===i?0:1/(i*i),0===n?0:1/(n*n),0===a?0:1/(a*a)),r._minimumRadius=Math.min(i,n,a),r._maximumRadius=Math.max(i,n,a),r._centerToleranceSquared=u.EPSILON1}var E=function(e,r,t){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,s(this,e,r,t)};n(E.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),E.clone=function(r,t){if(!i(r))return void 0;var n=r._radii;return i(t)?(e.clone(n,t._radii),e.clone(r._radiiSquared,t._radiiSquared),e.clone(r._radiiToTheFourth,t._radiiToTheFourth),e.clone(r._oneOverRadii,t._oneOverRadii),e.clone(r._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=r._minimumRadius,t._maximumRadius=r._maximumRadius,t._centerToleranceSquared=r._centerToleranceSquared,t):new E(n.x,n.y,n.z)},E.fromCartesian3=function(e,r){return i(r)||(r=new E),i(e)?(s(r,e.x,e.y,e.z),r):r},E.WGS84=a(new E(6378137,6378137,6356752.314245179)),E.UNIT_SPHERE=a(new E(1,1,1)),E.MOON=a(new E(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),E.prototype.clone=function(e){return E.clone(this,e)},E.packedLength=e.packedLength,E.pack=function(r,n,a){if(!i(r))throw new o("value is required");if(!i(n))throw new o("array is required");a=t(a,0),e.pack(r._radii,n,a)},E.unpack=function(r,n,a){if(!i(r))throw new o("array is required");n=t(n,0);var u=e.unpack(r,n);return E.fromCartesian3(u,a)},E.prototype.geocentricSurfaceNormal=e.normalize,E.prototype.geodeticSurfaceNormalCartographic=function(r,t){if(!i(r))throw new o("cartographic is required.");var n=r.longitude,a=r.latitude,u=Math.cos(a),s=u*Math.cos(n),E=u*Math.sin(n),w=Math.sin(a);return i(t)||(t=new e),t.x=s,t.y=E,t.z=w,e.normalize(t,t)},E.prototype.geodeticSurfaceNormal=function(r,t){return i(t)||(t=new e),t=e.multiplyComponents(r,this._oneOverRadiiSquared,t),e.normalize(t,t)};var w=new e,f=new e;E.prototype.cartographicToCartesian=function(r,t){var n=w,o=f;this.geodeticSurfaceNormalCartographic(r,n),e.multiplyComponents(this._radiiSquared,n,o);var a=Math.sqrt(e.dot(n,o));return e.divideByScalar(o,a,o),e.multiplyByScalar(n,r.height,n),i(t)||(t=new e),e.add(o,n,t)},E.prototype.cartographicArrayToCartesianArray=function(e,r){if(!i(e))throw new o("cartographics is required.");var t=e.length;i(r)?r.length=t:r=new Array(t);for(var n=0;t>n;n++)r[n]=this.cartographicToCartesian(e[n],r[n]);return r};var h=new e,c=new e,l=new e;E.prototype.cartesianToCartographic=function(t,n){var o=this.scaleToGeodeticSurface(t,c);if(!i(o))return void 0;var a=this.geodeticSurfaceNormal(o,h),s=e.subtract(t,o,l),E=Math.atan2(a.y,a.x),w=Math.asin(a.z),f=u.sign(e.dot(s,t))*e.magnitude(s);return i(n)?(n.longitude=E,n.latitude=w,n.height=f,n):new r(E,w,f)},E.prototype.cartesianArrayToCartographicArray=function(e,r){if(!i(e))throw new o("cartesians is required.");var t=e.length;i(r)?r.length=t:r=new Array(t);for(var n=0;t>n;++n)r[n]=this.cartesianToCartographic(e[n],r[n]);return r};var d=new e,_=new e;return E.prototype.scaleToGeodeticSurface=function(r,t){if(!i(r))throw new o("cartesian is required.");var n=r.x,a=r.y,s=r.z,E=this._oneOverRadii,w=E.x,f=E.y,h=E.z,c=n*n*w*w,l=a*a*f*f,R=s*s*h*h,T=c+l+R,A=Math.sqrt(1/T),m=e.multiplyByScalar(r,A,d);if(T<this._centerToleranceSquared)return isFinite(A)?e.clone(m,t):void 0;var N=this._oneOverRadiiSquared,I=N.x,y=N.y,p=N.z,S=_;S.x=m.x*I*2,S.y=m.y*y*2,S.z=m.z*p*2;var M,O,q,g,C,v,x,L,U,P,F,D=(1-A)*e.magnitude(r)/(.5*e.magnitude(S)),B=0;do{D-=B,q=1/(1+D*I),g=1/(1+D*y),C=1/(1+D*p),v=q*q,x=g*g,L=C*C,U=v*q,P=x*g,F=L*C,M=c*v+l*x+R*L-1,O=c*U*I+l*P*y+R*F*p;var b=-2*O;B=M/b}while(Math.abs(M)>u.EPSILON12);return i(t)?(t.x=n*q,t.y=a*g,t.z=s*C,t):new e(n*q,a*g,s*C)},E.prototype.scaleToGeocentricSurface=function(r,t){if(!i(r))throw new o("cartesian is required.");i(t)||(t=new e);var n=r.x,a=r.y,u=r.z,s=this._oneOverRadiiSquared,E=1/Math.sqrt(n*n*s.x+a*a*s.y+u*u*s.z);return e.multiplyByScalar(r,E,t)},E.prototype.transformPositionToScaledSpace=function(r,t){return i(t)||(t=new e),e.multiplyComponents(r,this._oneOverRadii,t)},E.prototype.transformPositionFromScaledSpace=function(r,t){return i(t)||(t=new e),e.multiplyComponents(r,this._radii,t)},E.prototype.equals=function(r){return this===r||i(r)&&e.equals(this._radii,r._radii)},E.prototype.toString=function(){return this._radii.toString()},E}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,r,t,i,n,o,a){"use strict";var u=function(e){this._ellipsoid=t(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return n(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(r,t){var n=this._semimajorAxis,o=r.longitude*n,a=r.latitude*n,u=r.height;return i(t)?(t.x=o,t.y=a,t.z=u,t):new e(o,a,u)},u.prototype.unproject=function(e,t){if(!i(e))throw new o("cartesian is required");var n=this._oneOverSemimajorAxis,a=e.x*n,u=e.y*n,s=e.z;return i(t)?(t.longitude=a,t.latitude=u,t.height=s,t):new r(a,u,s)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var r={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(r)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var r=function(r,t){this.start=e(r,0),this.stop=e(t,0)};return r}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n){"use strict";var o=function(r,t,i,n){this.x=e(r,0),this.y=e(t,0),this.z=e(i,0),this.w=e(n,0)};o.fromElements=function(e,t,i,n,a){return r(a)?(a.x=e,a.y=t,a.z=i,a.w=n,a):new o(e,t,i,n)},o.fromColor=function(e,i){if(!r(e))throw new t("color is required");return r(i)?(i.x=e.red,i.y=e.green,i.z=e.blue,i.w=e.alpha,i):new o(e.red,e.green,e.blue,e.alpha)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new o(e.x,e.y,e.z,e.w):void 0},o.packedLength=4,o.pack=function(i,n,o){if(!r(i))throw new t("value is required");if(!r(n))throw new t("array is required");o=e(o,0),n[o++]=i.x,n[o++]=i.y,n[o++]=i.z,n[o]=i.w},o.unpack=function(i,n,a){if(!r(i))throw new t("array is required");return n=e(n,0),r(a)||(a=new o),a.x=i[n++],a.y=i[n++],a.z=i[n++],a.w=i[n],a},o.fromArray=o.unpack,o.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z,e.w)},o.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z,e.w)},o.minimumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.min(e.x,i.x),n.y=Math.min(e.y,i.y),n.z=Math.min(e.z,i.z),n.w=Math.min(e.w,i.w),n},o.maximumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.max(e.x,i.x),n.y=Math.max(e.y,i.y),n.z=Math.max(e.z,i.z),n.w=Math.max(e.w,i.w),n},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,i){if(!r(e)||!r(i))throw new t("left and right are required.");return o.subtract(e,i,a),o.magnitude(a)},o.distanceSquared=function(e,i){if(!r(e)||!r(i))throw new t("left and right are required.");return o.subtract(e,i,a),o.magnitudeSquared(a)},o.normalize=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");var n=o.magnitude(e);return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i.w=e.w/n,i},o.dot=function(e,i){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");return e.x*i.x+e.y*i.y+e.z*i.z+e.w*i.w},o.multiplyComponents=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x*i.x,n.y=e.y*i.y,n.z=e.z*i.z,n.w=e.w*i.w,n},o.add=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x+i.x,n.y=e.y+i.y,n.z=e.z+i.z,n.w=e.w+i.w,n},o.subtract=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x-i.x,n.y=e.y-i.y,n.z=e.z-i.z,n.w=e.w-i.w,n},o.multiplyByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x*i,n.y=e.y*i,n.z=e.z*i,n.w=e.w*i,n},o.divideByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n.w=e.w/i,n},o.negate=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=-e.x,i.y=-e.y,i.z=-e.z,i.w=-e.w,i},o.abs=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=Math.abs(e.x),i.y=Math.abs(e.y),i.z=Math.abs(e.z),i.w=Math.abs(e.w),i};var u=new o;o.lerp=function(e,i,n,a){if(!r(e))throw new t("start is required.");if(!r(i))throw new t("end is required.");if("number"!=typeof n)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(i,n,u),a=o.multiplyByScalar(e,1-n,a),o.add(u,a,a)};var s=new o;return o.mostOrthogonalAxis=function(e,i){if(!r(e))throw new t("cartesian is required.");if(!r(i))throw new t("result is required.");var n=o.normalize(e,s);return o.abs(n,n),i=n.x<=n.y?n.x<=n.z?n.x<=n.w?o.clone(o.UNIT_X,i):o.clone(o.UNIT_W,i):n.z<=n.w?o.clone(o.UNIT_Z,i):o.clone(o.UNIT_W,i):n.y<=n.z?n.y<=n.w?o.clone(o.UNIT_Y,i):o.clone(o.UNIT_W,i):n.z<=n.w?o.clone(o.UNIT_Z,i):o.clone(o.UNIT_W,i)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},o.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]&&e.z===r[t+2]&&e.w===r[t+3]},o.equalsEpsilon=function(e,t,i,o){return e===t||r(e)&&r(t)&&n.equalsEpsilon(e.x,t.x,i,o)&&n.equalsEpsilon(e.y,t.y,i,o)&&n.equalsEpsilon(e.z,t.z,i,o)&&n.equalsEpsilon(e.w,t.w,i,o)},o.ZERO=i(new o(0,0,0,0)),o.UNIT_X=i(new o(1,0,0,0)),o.UNIT_Y=i(new o(0,1,0,0)),o.UNIT_Z=i(new o(0,0,1,0)),o.UNIT_W=i(new o(0,0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r,t){return o.equalsEpsilon(this,e,r,t)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},o}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n,o){"use strict";function a(e){for(var r=0,t=0;9>t;++t){var i=e[t];r+=i*i}return Math.sqrt(r)}function u(e){for(var r=0,t=0;3>t;++t){var i=e[E.getElementIndex(c[t],h[t])];r+=2*i*i}return Math.sqrt(r)}function s(e,r){for(var t=o.EPSILON15,i=0,n=1,a=0;3>a;++a){var u=Math.abs(e[E.getElementIndex(c[a],h[a])]);u>i&&(n=a,i=u)}var s=1,w=0,f=h[n],l=c[n];if(Math.abs(e[E.getElementIndex(l,f)])>t){var d,_=e[E.getElementIndex(l,l)],R=e[E.getElementIndex(f,f)],T=e[E.getElementIndex(l,f)],A=(_-R)/2/T;d=0>A?-1/(-A+Math.sqrt(1+A*A)):1/(A+Math.sqrt(1+A*A)),s=1/Math.sqrt(1+d*d),w=d*s}return r=E.clone(E.IDENTITY,r),r[E.getElementIndex(f,f)]=r[E.getElementIndex(l,l)]=s,r[E.getElementIndex(l,f)]=w,r[E.getElementIndex(f,l)]=-w,r}var E=function(e,t,i,n,o,a,u,s,E){this[0]=r(e,0),this[1]=r(n,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(o,0),this[5]=r(s,0),this[6]=r(i,0),this[7]=r(a,0),this[8]=r(E,0)};E.packedLength=9,E.pack=function(e,n,o){if(!t(e))throw new i("value is required");if(!t(n))throw new i("array is required");o=r(o,0),n[o++]=e[0],n[o++]=e[1],n[o++]=e[2],n[o++]=e[3],n[o++]=e[4],n[o++]=e[5],n[o++]=e[6],n[o++]=e[7],n[o++]=e[8]},E.unpack=function(e,n,o){if(!t(e))throw new i("array is required");return n=r(n,0),t(o)||(o=new E),o[0]=e[n++],o[1]=e[n++],o[2]=e[n++],o[3]=e[n++],o[4]=e[n++],o[5]=e[n++],o[6]=e[n++],o[7]=e[n++],o[8]=e[n++],o},E.clone=function(e,r){return t(e)?t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):new E(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},E.fromArray=function(e,n,o){if(!t(e))throw new i("array is required");return n=r(n,0),t(o)||(o=new E),o[0]=e[n],o[1]=e[n+1],o[2]=e[n+2],o[3]=e[n+3],o[4]=e[n+4],o[5]=e[n+5],o[6]=e[n+6],o[7]=e[n+7],o[8]=e[n+8],o},E.fromColumnMajorArray=function(e,r){if(!t(e))throw new i("values parameter is required");return E.clone(e,r)},E.fromRowMajorArray=function(e,r){if(!t(e))throw new i("values is required.");return t(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new E(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},E.fromQuaternion=function(e,r){if(!t(e))throw new i("quaternion is required");var n=e.x*e.x,o=e.x*e.y,a=e.x*e.z,u=e.x*e.w,s=e.y*e.y,w=e.y*e.z,f=e.y*e.w,h=e.z*e.z,c=e.z*e.w,l=e.w*e.w,d=n-s-h+l,_=2*(o-c),R=2*(a+f),T=2*(o+c),A=-n+s-h+l,m=2*(w-u),N=2*(a-f),I=2*(w+u),y=-n-s+h+l;return t(r)?(r[0]=d,r[1]=T,r[2]=N,r[3]=_,r[4]=A,r[5]=I,r[6]=R,r[7]=m,r[8]=y,r):new E(d,_,R,T,A,m,N,I,y)},E.fromScale=function(e,r){if(!t(e))throw new i("scale is required.");return t(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new E(e.x,0,0,0,e.y,0,0,0,e.z)},E.fromUniformScale=function(e,r){if("number"!=typeof e)throw new i("scale is required.");return t(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new E(e,0,0,0,e,0,0,0,e)},E.fromCrossProduct=function(e,r){if(!t(e))throw new i("vector is required.");return t(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new E(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},E.fromRotationX=function(e,r){if(!t(e))throw new i("angle is required.");var n=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=n,r[5]=o,r[6]=0,r[7]=-o,r[8]=n,r):new E(1,0,0,0,n,-o,0,o,n)},E.fromRotationY=function(e,r){if(!t(e))throw new i("angle is required.");var n=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=n,r[1]=0,r[2]=-o,r[3]=0,r[4]=1,r[5]=0,r[6]=o,r[7]=0,r[8]=n,r):new E(n,0,o,0,1,0,-o,0,n)},E.fromRotationZ=function(e,r){if(!t(e))throw new i("angle is required.");var n=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=n,r[1]=o,r[2]=0,r[3]=-o,r[4]=n,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new E(n,-o,0,o,n,0,0,0,1)},E.toArray=function(e,r){if(!t(e))throw new i("matrix is required");return t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},E.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>2)throw new i("row must be 0, 1, or 2.");if("number"!=typeof e||0>e||e>2)throw new i("column must be 0, 1, or 2.");return 3*e+r},E.getColumn=function(e,r,n){if(!t(e))throw new i("matrix is required.");if("number"!=typeof r||0>r||r>2)throw new i("index must be 0, 1, or 2.");if(!t(n))throw new i("result is required");var o=3*r,a=e[o],u=e[o+1],s=e[o+2];return n.x=a,n.y=u,n.z=s,n},E.setColumn=function(e,r,n,o){if(!t(e))throw new i("matrix is required");if(!t(n))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new i("index must be 0, 1, or 2.");if(!t(o))throw new i("result is required");o=E.clone(e,o);var a=3*r;return o[a]=n.x,o[a+1]=n.y,o[a+2]=n.z,o},E.getRow=function(e,r,n){if(!t(e))throw new i("matrix is required.");if("number"!=typeof r||0>r||r>2)throw new i("index must be 0, 1, or 2.");if(!t(n))throw new i("result is required");var o=e[r],a=e[r+3],u=e[r+6];
return n.x=o,n.y=a,n.z=u,n},E.setRow=function(e,r,n,o){if(!t(e))throw new i("matrix is required");if(!t(n))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new i("index must be 0, 1, or 2.");if(!t(o))throw new i("result is required");return o=E.clone(e,o),o[r]=n.x,o[r+3]=n.y,o[r+6]=n.z,o};var w=new e;E.getScale=function(r,n){if(!t(r))throw new i("matrix is required.");if(!t(n))throw new i("result is required");return n.x=e.magnitude(e.fromElements(r[0],r[1],r[2],w)),n.y=e.magnitude(e.fromElements(r[3],r[4],r[5],w)),n.z=e.magnitude(e.fromElements(r[6],r[7],r[8],w)),n};var f=new e;E.getMaximumScale=function(r){return E.getScale(r,f),e.maximumComponent(f)},E.multiply=function(e,r,n){if(!t(e))throw new i("left is required");if(!t(r))throw new i("right is required");if(!t(n))throw new i("result is required");var o=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],a=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],u=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],s=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],E=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],w=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],f=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],h=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],c=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return n[0]=o,n[1]=a,n[2]=u,n[3]=s,n[4]=E,n[5]=w,n[6]=f,n[7]=h,n[8]=c,n},E.add=function(e,r,n){if(!t(e))throw new i("left is required");if(!t(r))throw new i("right is required");if(!t(n))throw new i("result is required");return n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n[4]=e[4]+r[4],n[5]=e[5]+r[5],n[6]=e[6]+r[6],n[7]=e[7]+r[7],n[8]=e[8]+r[8],n},E.subtract=function(e,r,n){if(!t(e))throw new i("left is required");if(!t(r))throw new i("right is required");if(!t(n))throw new i("result is required");return n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n[4]=e[4]-r[4],n[5]=e[5]-r[5],n[6]=e[6]-r[6],n[7]=e[7]-r[7],n[8]=e[8]-r[8],n},E.multiplyByVector=function(e,r,n){if(!t(e))throw new i("matrix is required");if(!t(r))throw new i("cartesian is required");if(!t(n))throw new i("result is required");var o=r.x,a=r.y,u=r.z,s=e[0]*o+e[3]*a+e[6]*u,E=e[1]*o+e[4]*a+e[7]*u,w=e[2]*o+e[5]*a+e[8]*u;return n.x=s,n.y=E,n.z=w,n},E.multiplyByScalar=function(e,r,n){if(!t(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scalar must be a number");if(!t(n))throw new i("result is required");return n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*r,n[7]=e[7]*r,n[8]=e[8]*r,n},E.multiplyByScale=function(e,r,n){if(!t(e))throw new i("matrix is required");if(!t(r))throw new i("scale is required");if(!t(n))throw new i("result is required");return n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.x,n[3]=e[3]*r.y,n[4]=e[4]*r.y,n[5]=e[5]*r.y,n[6]=e[6]*r.z,n[7]=e[7]*r.z,n[8]=e[8]*r.z,n},E.negate=function(e,r){if(!t(e))throw new i("matrix is required");if(!t(r))throw new i("result is required");return r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},E.transpose=function(e,r){if(!t(e))throw new i("matrix is required");if(!t(r))throw new i("result is required");var n=e[0],o=e[3],a=e[6],u=e[1],s=e[4],E=e[7],w=e[2],f=e[5],h=e[8];return r[0]=n,r[1]=o,r[2]=a,r[3]=u,r[4]=s,r[5]=E,r[6]=w,r[7]=f,r[8]=h,r};var h=[1,0,0],c=[2,2,1],l=new E,d=new E;return E.computeEigenDecomposition=function(e,r){if(!t(e))throw new i("matrix is required.");var n=o.EPSILON20,w=10,f=0,h=0;t(r)||(r={});for(var c=r.unitary=E.clone(E.IDENTITY,r.unitary),_=r.diagonal=E.clone(e,r.diagonal),R=n*a(_);w>h&&u(_)>R;)s(_,l),E.transpose(l,d),E.multiply(_,l,_),E.multiply(d,_,_),E.multiply(c,l,c),++f>2&&(++h,f=0);return r},E.abs=function(e,r){if(!t(e))throw new i("matrix is required");if(!t(r))throw new i("result is required");return r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},E.determinant=function(e){if(!t(e))throw new i("matrix is required");var r=e[0],n=e[3],o=e[6],a=e[1],u=e[4],s=e[7],E=e[2],w=e[5],f=e[8];return r*(u*f-w*s)+a*(w*o-n*f)+E*(n*s-u*o)},E.inverse=function(e,r){if(!t(e))throw new i("matrix is required");if(!t(r))throw new i("result is required");var n=e[0],a=e[1],u=e[2],s=e[3],w=e[4],f=e[5],h=e[6],c=e[7],l=e[8],d=E.determinant(e);if(Math.abs(d)<=o.EPSILON15)throw new i("matrix is not invertible");r[0]=w*l-c*f,r[1]=c*u-a*l,r[2]=a*f-w*u,r[3]=h*f-s*l,r[4]=n*l-h*u,r[5]=s*u-n*f,r[6]=s*c-h*w,r[7]=h*a-n*c,r[8]=n*w-s*a;var _=1/d;return E.multiplyByScalar(r,_,r)},E.equals=function(e,r){return e===r||t(e)&&t(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]},E.equalsEpsilon=function(e,r,n){if("number"!=typeof n)throw new i("epsilon must be a number");return e===r||t(e)&&t(r)&&Math.abs(e[0]-r[0])<=n&&Math.abs(e[1]-r[1])<=n&&Math.abs(e[2]-r[2])<=n&&Math.abs(e[3]-r[3])<=n&&Math.abs(e[4]-r[4])<=n&&Math.abs(e[5]-r[5])<=n&&Math.abs(e[6]-r[6])<=n&&Math.abs(e[7]-r[7])<=n&&Math.abs(e[8]-r[8])<=n},E.IDENTITY=n(new E(1,0,0,0,1,0,0,0,1)),E.ZERO=n(new E(0,0,0,0,0,0,0,0,0)),E.COLUMN0ROW0=0,E.COLUMN0ROW1=1,E.COLUMN0ROW2=2,E.COLUMN1ROW0=3,E.COLUMN1ROW1=4,E.COLUMN1ROW2=5,E.COLUMN2ROW0=6,E.COLUMN2ROW1=7,E.COLUMN2ROW2=8,E.prototype.clone=function(e){return E.clone(this,e)},E.prototype.equals=function(e){return E.equals(this,e)},E.equalsArray=function(e,r,t){return e[0]===r[t]&&e[1]===r[t+1]&&e[2]===r[t+2]&&e[3]===r[t+3]&&e[4]===r[t+4]&&e[5]===r[t+5]&&e[6]===r[t+6]&&e[7]===r[t+7]&&e[8]===r[t+8]},E.prototype.equalsEpsilon=function(e,r){return E.equalsEpsilon(this,e,r)},E.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},E}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var r=function(e){this.name="RuntimeError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,r,t,i,n,o,a,u,s){"use strict";var E=function(e,r,i,n,o,a,u,s,E,w,f,h,c,l,d,_){this[0]=t(e,0),this[1]=t(o,0),this[2]=t(E,0),this[3]=t(c,0),this[4]=t(r,0),this[5]=t(a,0),this[6]=t(w,0),this[7]=t(l,0),this[8]=t(i,0),this[9]=t(u,0),this[10]=t(f,0),this[11]=t(d,0),this[12]=t(n,0),this[13]=t(s,0),this[14]=t(h,0),this[15]=t(_,0)};E.packedLength=16,E.pack=function(e,r,o){if(!i(e))throw new n("value is required");if(!i(r))throw new n("array is required");o=t(o,0),r[o++]=e[0],r[o++]=e[1],r[o++]=e[2],r[o++]=e[3],r[o++]=e[4],r[o++]=e[5],r[o++]=e[6],r[o++]=e[7],r[o++]=e[8],r[o++]=e[9],r[o++]=e[10],r[o++]=e[11],r[o++]=e[12],r[o++]=e[13],r[o++]=e[14],r[o]=e[15]},E.unpack=function(e,r,o){if(!i(e))throw new n("array is required");return r=t(r,0),i(o)||(o=new E),o[0]=e[r++],o[1]=e[r++],o[2]=e[r++],o[3]=e[r++],o[4]=e[r++],o[5]=e[r++],o[6]=e[r++],o[7]=e[r++],o[8]=e[r++],o[9]=e[r++],o[10]=e[r++],o[11]=e[r++],o[12]=e[r++],o[13]=e[r++],o[14]=e[r++],o[15]=e[r],o},E.clone=function(e,r){return i(e)?i(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):new E(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},E.fromArray=E.unpack,E.fromColumnMajorArray=function(e,r){if(!i(e))throw new n("values is required");return E.clone(e,r)},E.fromRowMajorArray=function(e,r){if(!i(e))throw new n("values is required.");return i(r)?(r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=e[1],r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=e[2],r[9]=e[6],r[10]=e[10],r[11]=e[14],r[12]=e[3],r[13]=e[7],r[14]=e[11],r[15]=e[15],r):new E(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},E.fromRotationTranslation=function(r,o,a){if(!i(r))throw new n("rotation is required.");return o=t(o,e.ZERO),i(a)?(a[0]=r[0],a[1]=r[1],a[2]=r[2],a[3]=0,a[4]=r[3],a[5]=r[4],a[6]=r[5],a[7]=0,a[8]=r[6],a[9]=r[7],a[10]=r[8],a[11]=0,a[12]=o.x,a[13]=o.y,a[14]=o.z,a[15]=1,a):new E(r[0],r[3],r[6],o.x,r[1],r[4],r[7],o.y,r[2],r[5],r[8],o.z,0,0,0,1)},E.fromTranslationQuaternionRotationScale=function(e,r,t,o){if(!i(e))throw new n("translation is required.");if(!i(r))throw new n("rotation is required.");if(!i(t))throw new n("scale is required.");i(o)||(o=new E);var a=t.x,u=t.y,s=t.z,w=r.x*r.x,f=r.x*r.y,h=r.x*r.z,c=r.x*r.w,l=r.y*r.y,d=r.y*r.z,_=r.y*r.w,R=r.z*r.z,T=r.z*r.w,A=r.w*r.w,m=w-l-R+A,N=2*(f-T),I=2*(h+_),y=2*(f+T),p=-w+l-R+A,S=2*(d-c),M=2*(h-_),O=2*(d+c),q=-w-l+R+A;return o[0]=m*a,o[1]=y*a,o[2]=M*a,o[3]=0,o[4]=N*u,o[5]=p*u,o[6]=O*u,o[7]=0,o[8]=I*s,o[9]=S*s,o[10]=q*s,o[11]=0,o[12]=e.x,o[13]=e.y,o[14]=e.z,o[15]=1,o},E.fromTranslation=function(e,r){if(!i(e))throw new n("translation is required.");return E.fromRotationTranslation(u.IDENTITY,e,r)},E.fromScale=function(e,r){if(!i(e))throw new n("scale is required.");return i(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e.y,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e.z,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new E(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},E.fromUniformScale=function(e,r){if("number"!=typeof e)throw new n("scale is required.");return i(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new E(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var w=new e,f=new e,h=new e;E.fromCamera=function(r,t){if(!i(r))throw new n("camera is required.");var o=r.eye,a=r.target,u=r.up;if(!i(o))throw new n("camera.eye is required.");if(!i(a))throw new n("camera.target is required.");if(!i(u))throw new n("camera.up is required.");e.normalize(e.subtract(a,o,w),w),e.normalize(e.cross(w,u,f),f),e.normalize(e.cross(f,w,h),h);var s=f.x,c=f.y,l=f.z,d=w.x,_=w.y,R=w.z,T=h.x,A=h.y,m=h.z,N=o.x,I=o.y,y=o.z,p=s*-N+c*-I+l*-y,S=T*-N+A*-I+m*-y,M=d*N+_*I+R*y;return i(t)?(t[0]=s,t[1]=T,t[2]=-d,t[3]=0,t[4]=c,t[5]=A,t[6]=-_,t[7]=0,t[8]=l,t[9]=m,t[10]=-R,t[11]=0,t[12]=p,t[13]=S,t[14]=M,t[15]=1,t):new E(s,c,l,p,T,A,m,S,-d,-_,-R,M,0,0,0,1)},E.computePerspectiveFieldOfView=function(e,r,t,o,a){if(0>=e||e>Math.PI)throw new n("fovY must be in [0, PI).");if(0>=r)throw new n("aspectRatio must be greater than zero.");if(0>=t)throw new n("near must be greater than zero.");if(0>=o)throw new n("far must be greater than zero.");if(!i(a))throw new n("result is required");var u=Math.tan(.5*e),s=1/u,E=s/r,w=(o+t)/(t-o),f=2*o*t/(t-o);return a[0]=E,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=s,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=w,a[11]=-1,a[12]=0,a[13]=0,a[14]=f,a[15]=0,a},E.computeOrthographicOffCenter=function(e,r,t,o,a,u,s){if(!i(e))throw new n("left is required.");if(!i(r))throw new n("right is required.");if(!i(t))throw new n("bottom is required.");if(!i(o))throw new n("top is required.");if(!i(a))throw new n("near is required.");if(!i(u))throw new n("far is required.");if(!i(s))throw new n("result is required");var E=1/(r-e),w=1/(o-t),f=1/(u-a),h=-(r+e)*E,c=-(o+t)*w,l=-(u+a)*f;return E*=2,w*=2,f*=-2,s[0]=E,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=w,s[6]=0,s[7]=0,s[8]=0,s[9]=0,s[10]=f,s[11]=0,s[12]=h,s[13]=c,s[14]=l,s[15]=1,s},E.computePerspectiveOffCenter=function(e,r,t,o,a,u,s){if(!i(e))throw new n("left is required.");if(!i(r))throw new n("right is required.");if(!i(t))throw new n("bottom is required.");if(!i(o))throw new n("top is required.");if(!i(a))throw new n("near is required.");if(!i(u))throw new n("far is required.");if(!i(s))throw new n("result is required");var E=2*a/(r-e),w=2*a/(o-t),f=(r+e)/(r-e),h=(o+t)/(o-t),c=-(u+a)/(u-a),l=-1,d=-2*u*a/(u-a);return s[0]=E,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=w,s[6]=0,s[7]=0,s[8]=f,s[9]=h,s[10]=c,s[11]=l,s[12]=0,s[13]=0,s[14]=d,s[15]=0,s},E.computeInfinitePerspectiveOffCenter=function(e,r,t,o,a,u){if(!i(e))throw new n("left is required.");if(!i(r))throw new n("right is required.");if(!i(t))throw new n("bottom is required.");if(!i(o))throw new n("top is required.");if(!i(a))throw new n("near is required.");if(!i(u))throw new n("result is required");var s=2*a/(r-e),E=2*a/(o-t),w=(r+e)/(r-e),f=(o+t)/(o-t),h=-1,c=-1,l=-2*a;return u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=E,u[6]=0,u[7]=0,u[8]=w,u[9]=f,u[10]=h,u[11]=c,u[12]=0,u[13]=0,u[14]=l,u[15]=0,u},E.computeViewportTransformation=function(e,r,o,a){if(!i(a))throw new n("result is required");e=t(e,t.EMPTY_OBJECT);var u=t(e.x,0),s=t(e.y,0),E=t(e.width,0),w=t(e.height,0);r=t(r,0),o=t(o,1);var f=.5*E,h=.5*w,c=.5*(o-r),l=f,d=h,_=c,R=u+f,T=s+h,A=r+c,m=1;return a[0]=l,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=d,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=_,a[11]=0,a[12]=R,a[13]=T,a[14]=A,a[15]=m,a},E.toArray=function(e,r){if(!i(e))throw new n("matrix is required");return i(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},E.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>3)throw new n("row must be 0, 1, 2, or 3.");if("number"!=typeof e||0>e||e>3)throw new n("column must be 0, 1, 2, or 3.");return 4*e+r},E.getColumn=function(e,r,t){if(!i(e))throw new n("matrix is required.");if("number"!=typeof r||0>r||r>3)throw new n("index must be 0, 1, 2, or 3.");if(!i(t))throw new n("result is required");var o=4*r,a=e[o],u=e[o+1],s=e[o+2],E=e[o+3];return t.x=a,t.y=u,t.z=s,t.w=E,t},E.setColumn=function(e,r,t,o){if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new n("index must be 0, 1, 2, or 3.");if(!i(o))throw new n("result is required");o=E.clone(e,o);var a=4*r;return o[a]=t.x,o[a+1]=t.y,o[a+2]=t.z,o[a+3]=t.w,o},E.setTranslation=function(e,r,t){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("translation is required");if(!i(t))throw new n("result is required");return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=r.x,t[13]=r.y,t[14]=r.z,t[15]=e[15],t},E.getRow=function(e,r,t){if(!i(e))throw new n("matrix is required.");if("number"!=typeof r||0>r||r>3)throw new n("index must be 0, 1, 2, or 3.");if(!i(t))throw new n("result is required");var o=e[r],a=e[r+4],u=e[r+8],s=e[r+12];return t.x=o,t.y=a,t.z=u,t.w=s,t},E.setRow=function(e,r,t,o){if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new n("index must be 0, 1, 2, or 3.");if(!i(o))throw new n("result is required");return o=E.clone(e,o),o[r]=t.x,o[r+4]=t.y,o[r+8]=t.z,o[r+12]=t.w,o};var c=new e;E.getScale=function(r,t){if(!i(r))throw new n("matrix is required.");if(!i(t))throw new n("result is required");return t.x=e.magnitude(e.fromElements(r[0],r[1],r[2],c)),t.y=e.magnitude(e.fromElements(r[4],r[5],r[6],c)),t.z=e.magnitude(e.fromElements(r[8],r[9],r[10],c)),t};var l=new e;E.getMaximumScale=function(r){return E.getScale(r,l),e.maximumComponent(l)},E.multiply=function(e,r,t){if(!i(e))throw new n("left is required");if(!i(r))throw new n("right is required");if(!i(t))throw new n("result is required");var o=e[0],a=e[1],u=e[2],s=e[3],E=e[4],w=e[5],f=e[6],h=e[7],c=e[8],l=e[9],d=e[10],_=e[11],R=e[12],T=e[13],A=e[14],m=e[15],N=r[0],I=r[1],y=r[2],p=r[3],S=r[4],M=r[5],O=r[6],q=r[7],g=r[8],C=r[9],v=r[10],x=r[11],L=r[12],U=r[13],P=r[14],F=r[15],D=o*N+E*I+c*y+R*p,B=a*N+w*I+l*y+T*p,b=u*N+f*I+d*y+A*p,z=s*N+h*I+_*y+m*p,G=o*S+E*M+c*O+R*q,V=a*S+w*M+l*O+T*q,X=u*S+f*M+d*O+A*q,H=s*S+h*M+_*O+m*q,W=o*g+E*C+c*v+R*x,Y=a*g+w*C+l*v+T*x,K=u*g+f*C+d*v+A*x,k=s*g+h*C+_*v+m*x,j=o*L+E*U+c*P+R*F,Z=a*L+w*U+l*P+T*F,Q=u*L+f*U+d*P+A*F,J=s*L+h*U+_*P+m*F;return t[0]=D,t[1]=B,t[2]=b,t[3]=z,t[4]=G,t[5]=V,t[6]=X,t[7]=H,t[8]=W,t[9]=Y,t[10]=K,t[11]=k,t[12]=j,t[13]=Z,t[14]=Q,t[15]=J,t},E.add=function(e,r,t){if(!i(e))throw new n("left is required");if(!i(r))throw new n("right is required");if(!i(t))throw new n("result is required");return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t[6]=e[6]+r[6],t[7]=e[7]+r[7],t[8]=e[8]+r[8],t[9]=e[9]+r[9],t[10]=e[10]+r[10],t[11]=e[11]+r[11],t[12]=e[12]+r[12],t[13]=e[13]+r[13],t[14]=e[14]+r[14],t[15]=e[15]+r[15],t},E.subtract=function(e,r,t){if(!i(e))throw new n("left is required");if(!i(r))throw new n("right is required");if(!i(t))throw new n("result is required");return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t[4]=e[4]-r[4],t[5]=e[5]-r[5],t[6]=e[6]-r[6],t[7]=e[7]-r[7],t[8]=e[8]-r[8],t[9]=e[9]-r[9],t[10]=e[10]-r[10],t[11]=e[11]-r[11],t[12]=e[12]-r[12],t[13]=e[13]-r[13],t[14]=e[14]-r[14],t[15]=e[15]-r[15],t},E.multiplyTransformation=function(e,r,t){if(!i(e))throw new n("left is required");if(!i(r))throw new n("right is required");if(!i(t))throw new n("result is required");var o=e[0],a=e[1],u=e[2],s=e[4],E=e[5],w=e[6],f=e[8],h=e[9],c=e[10],l=e[12],d=e[13],_=e[14],R=r[0],T=r[1],A=r[2],m=r[4],N=r[5],I=r[6],y=r[8],p=r[9],S=r[10],M=r[12],O=r[13],q=r[14],g=o*R+s*T+f*A,C=a*R+E*T+h*A,v=u*R+w*T+c*A,x=o*m+s*N+f*I,L=a*m+E*N+h*I,U=u*m+w*N+c*I,P=o*y+s*p+f*S,F=a*y+E*p+h*S,D=u*y+w*p+c*S,B=o*M+s*O+f*q+l,b=a*M+E*O+h*q+d,z=u*M+w*O+c*q+_;return t[0]=g,t[1]=C,t[2]=v,t[3]=0,t[4]=x,t[5]=L,t[6]=U,t[7]=0,t[8]=P,t[9]=F,t[10]=D,t[11]=0,t[12]=B,t[13]=b,t[14]=z,t[15]=1,t},E.multiplyByMatrix3=function(e,r,t){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("rotation is required");if(!i(t))throw new n("result is required");var o=e[0],a=e[1],u=e[2],s=e[4],E=e[5],w=e[6],f=e[8],h=e[9],c=e[10],l=r[0],d=r[1],_=r[2],R=r[3],T=r[4],A=r[5],m=r[6],N=r[7],I=r[8],y=o*l+s*d+f*_,p=a*l+E*d+h*_,S=u*l+w*d+c*_,M=o*R+s*T+f*A,O=a*R+E*T+h*A,q=u*R+w*T+c*A,g=o*m+s*N+f*I,C=a*m+E*N+h*I,v=u*m+w*N+c*I;return t[0]=y,t[1]=p,t[2]=S,t[3]=0,t[4]=M,t[5]=O,t[6]=q,t[7]=0,t[8]=g,t[9]=C,t[10]=v,t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},E.multiplyByTranslation=function(e,r,t){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("translation is required");if(!i(t))throw new n("result is required");var o=r.x,a=r.y,u=r.z,s=o*e[0]+a*e[4]+u*e[8]+e[12],E=o*e[1]+a*e[5]+u*e[9]+e[13],w=o*e[2]+a*e[6]+u*e[10]+e[14];return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=s,t[13]=E,t[14]=w,t[15]=e[15],t};var d=new e;E.multiplyByUniformScale=function(e,r,t){if(!i(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scale is required");if(!i(t))throw new n("result is required");return d.x=r,d.y=r,d.z=r,E.multiplyByScale(e,d,t)},E.multiplyByScale=function(e,r,t){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("scale is required");if(!i(t))throw new n("result is required");var o=r.x,a=r.y,u=r.z;return 1===o&&1===a&&1===u?E.clone(e,t):(t[0]=o*e[0],t[1]=o*e[1],t[2]=o*e[2],t[3]=0,t[4]=a*e[4],t[5]=a*e[5],t[6]=a*e[6],t[7]=0,t[8]=u*e[8],t[9]=u*e[9],t[10]=u*e[10],t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=1,t)},E.multiplyByVector=function(e,r,t){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("cartesian is required");if(!i(t))throw new n("result is required");var o=r.x,a=r.y,u=r.z,s=r.w,E=e[0]*o+e[4]*a+e[8]*u+e[12]*s,w=e[1]*o+e[5]*a+e[9]*u+e[13]*s,f=e[2]*o+e[6]*a+e[10]*u+e[14]*s,h=e[3]*o+e[7]*a+e[11]*u+e[15]*s;return t.x=E,t.y=w,t.z=f,t.w=h,t},E.multiplyByPointAsVector=function(e,r,t){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("cartesian is required");if(!i(t))throw new n("result is required");var o=r.x,a=r.y,u=r.z,s=e[0]*o+e[4]*a+e[8]*u,E=e[1]*o+e[5]*a+e[9]*u,w=e[2]*o+e[6]*a+e[10]*u;return t.x=s,t.y=E,t.z=w,t},E.multiplyByPoint=function(e,r,t){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("cartesian is required");if(!i(t))throw new n("result is required");var o=r.x,a=r.y,u=r.z,s=e[0]*o+e[4]*a+e[8]*u+e[12],E=e[1]*o+e[5]*a+e[9]*u+e[13],w=e[2]*o+e[6]*a+e[10]*u+e[14];return t.x=s,t.y=E,t.z=w,t},E.multiplyByScalar=function(e,r,t){if(!i(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scalar must be a number");if(!i(t))throw new n("result is required");return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t},E.negate=function(e,r){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("result is required");return r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r[9]=-e[9],r[10]=-e[10],r[11]=-e[11],r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=-e[15],r},E.transpose=function(e,r){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("result is required");var t=e[1],o=e[2],a=e[3],u=e[6],s=e[7],E=e[11];return r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=t,r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=o,r[9]=u,r[10]=e[10],r[11]=e[14],r[12]=a,r[13]=s,r[14]=E,r[15]=e[15],r},E.abs=function(e,r){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("result is required");return r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r[9]=Math.abs(e[9]),r[10]=Math.abs(e[10]),r[11]=Math.abs(e[11]),r[12]=Math.abs(e[12]),r[13]=Math.abs(e[13]),r[14]=Math.abs(e[14]),r[15]=Math.abs(e[15]),r},E.equals=function(e,r){return e===r||i(e)&&i(r)&&e[12]===r[12]&&e[13]===r[13]&&e[14]===r[14]&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[8]===r[8]&&e[9]===r[9]&&e[10]===r[10]&&e[3]===r[3]&&e[7]===r[7]&&e[11]===r[11]&&e[15]===r[15]},E.equalsEpsilon=function(e,r,t){if("number"!=typeof t)throw new n("epsilon must be a number");return e===r||i(e)&&i(r)&&Math.abs(e[0]-r[0])<=t&&Math.abs(e[1]-r[1])<=t&&Math.abs(e[2]-r[2])<=t&&Math.abs(e[3]-r[3])<=t&&Math.abs(e[4]-r[4])<=t&&Math.abs(e[5]-r[5])<=t&&Math.abs(e[6]-r[6])<=t&&Math.abs(e[7]-r[7])<=t&&Math.abs(e[8]-r[8])<=t&&Math.abs(e[9]-r[9])<=t&&Math.abs(e[10]-r[10])<=t&&Math.abs(e[11]-r[11])<=t&&Math.abs(e[12]-r[12])<=t&&Math.abs(e[13]-r[13])<=t&&Math.abs(e[14]-r[14])<=t&&Math.abs(e[15]-r[15])<=t},E.getTranslation=function(e,r){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("result is required");return r.x=e[12],r.y=e[13],r.z=e[14],r},E.getRotation=function(e,r){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("result is required");return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[4],r[4]=e[5],r[5]=e[6],r[6]=e[8],r[7]=e[9],r[8]=e[10],r};var _=new u,R=new u,T=new r,A=new r(0,0,0,1);return E.inverse=function(e,t){if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("result is required");if(u.equalsEpsilon(E.getRotation(e,_),R,a.EPSILON7)&&r.equals(E.getRow(e,3,T),A))return t[0]=0,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=0,t[11]=0,t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=1,t;var o=e[0],w=e[4],f=e[8],h=e[12],c=e[1],l=e[5],d=e[9],m=e[13],N=e[2],I=e[6],y=e[10],p=e[14],S=e[3],M=e[7],O=e[11],q=e[15],g=y*q,C=p*O,v=I*q,x=p*M,L=I*O,U=y*M,P=N*q,F=p*S,D=N*O,B=y*S,b=N*M,z=I*S,G=g*l+x*d+L*m-(C*l+v*d+U*m),V=C*c+P*d+B*m-(g*c+F*d+D*m),X=v*c+F*l+b*m-(x*c+P*l+z*m),H=U*c+D*l+z*d-(L*c+B*l+b*d),W=C*w+v*f+U*h-(g*w+x*f+L*h),Y=g*o+F*f+D*h-(C*o+P*f+B*h),K=x*o+P*w+z*h-(v*o+F*w+b*h),k=L*o+B*w+b*f-(U*o+D*w+z*f);g=f*m,C=h*d,v=w*m,x=h*l,L=w*d,U=f*l,P=o*m,F=h*c,D=o*d,B=f*c,b=o*l,z=w*c;var j=g*M+x*O+L*q-(C*M+v*O+U*q),Z=C*S+P*O+B*q-(g*S+F*O+D*q),Q=v*S+F*M+b*q-(x*S+P*M+z*q),J=U*S+D*M+z*O-(L*S+B*M+b*O),$=v*y+U*p+C*I-(L*p+g*I+x*y),ee=D*p+g*N+F*y-(P*y+B*p+C*N),re=P*I+z*p+x*N-(b*p+v*N+F*I),te=b*y+L*N+B*I-(D*I+z*y+U*N),ie=o*G+w*V+f*X+h*H;if(Math.abs(ie)<a.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return ie=1/ie,t[0]=G*ie,t[1]=V*ie,t[2]=X*ie,t[3]=H*ie,t[4]=W*ie,t[5]=Y*ie,t[6]=K*ie,t[7]=k*ie,t[8]=j*ie,t[9]=Z*ie,t[10]=Q*ie,t[11]=J*ie,t[12]=$*ie,t[13]=ee*ie,t[14]=re*ie,t[15]=te*ie,t},E.inverseTransformation=function(e,r){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("result is required");var t=e[0],o=e[1],a=e[2],u=e[4],s=e[5],E=e[6],w=e[8],f=e[9],h=e[10],c=e[12],l=e[13],d=e[14],_=-t*c-o*l-a*d,R=-u*c-s*l-E*d,T=-w*c-f*l-h*d;return r[0]=t,r[1]=u,r[2]=w,r[3]=0,r[4]=o,r[5]=s,r[6]=f,r[7]=0,r[8]=a,r[9]=E,r[10]=h,r[11]=0,r[12]=_,r[13]=R,r[14]=T,r[15]=1,r},E.IDENTITY=o(new E(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),E.ZERO=o(new E(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),E.COLUMN0ROW0=0,E.COLUMN0ROW1=1,E.COLUMN0ROW2=2,E.COLUMN0ROW3=3,E.COLUMN1ROW0=4,E.COLUMN1ROW1=5,E.COLUMN1ROW2=6,E.COLUMN1ROW3=7,E.COLUMN2ROW0=8,E.COLUMN2ROW1=9,E.COLUMN2ROW2=10,E.COLUMN2ROW3=11,E.COLUMN3ROW0=12,E.COLUMN3ROW1=13,E.COLUMN3ROW2=14,E.COLUMN3ROW3=15,E.prototype.clone=function(e){return E.clone(this,e)},E.prototype.equals=function(e){return E.equals(this,e)},E.equalsArray=function(e,r,t){return e[0]===r[t]&&e[1]===r[t+1]&&e[2]===r[t+2]&&e[3]===r[t+3]&&e[4]===r[t+4]&&e[5]===r[t+5]&&e[6]===r[t+6]&&e[7]===r[t+7]&&e[8]===r[t+8]&&e[9]===r[t+9]&&e[10]===r[t+10]&&e[11]===r[t+11]&&e[12]===r[t+12]&&e[13]===r[t+13]&&e[14]===r[t+14]&&e[15]===r[t+15]},E.prototype.equalsEpsilon=function(e,r){return E.equalsEpsilon(this,e,r)},E.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},E}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,r,t,i){"use strict";var n=function(i,n){if(!r(i))throw new t("normal is required.");if(!r(n))throw new t("distance is required.");this.normal=e.clone(i),this.distance=n};n.fromPointNormal=function(i,o,a){if(!r(i))throw new t("point is required.");if(!r(o))throw new t("normal is required.");var u=-e.dot(o,i);return r(a)?(e.clone(o,a.normal),a.distance=u,a):new n(o,u)};var o=new e;return n.fromCartesian4=function(i,a){if(!r(i))throw new t("coefficients is required.");var u=e.fromCartesian4(i,o),s=i.w;return r(a)?(e.clone(u,a.normal),a.distance=s,a):new n(u,s)},n.getPointDistance=function(i,n){if(!r(i))throw new t("plane is required.");if(!r(n))throw new t("point is required.");return e.dot(i.normal,n)+i.distance},n.ORIGIN_XY_PLANE=i(new n(e.UNIT_Z,0)),n.ORIGIN_YZ_PLANE=i(new n(e.UNIT_X,0)),n.ORIGIN_ZX_PLANE=i(new n(e.UNIT_Y,0)),n}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,r,t,i,n,o,a,u){"use strict";var s=function(e,t,i,n){this.west=r(e,0),this.south=r(t,0),this.east=r(i,0),this.north=r(n,0)};i(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,i,o){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");o=r(o,0),i[o++]=e.west,i[o++]=e.south,i[o++]=e.east,i[o]=e.north},s.unpack=function(e,i,o){if(!t(e))throw new n("array is required");return i=r(i,0),t(o)||(o=new s),o.west=e[i++],o.south=e[i++],o.east=e[i++],o.north=e[i],o},s.computeWidth=function(e){if(!t(e))throw new n("rectangle is required.");var r=e.east,i=e.west;return i>r&&(r+=u.TWO_PI),r-i},s.computeHeight=function(e){if(!t(e))throw new n("rectangle is required.");return e.north-e.south},s.fromDegrees=function(e,i,n,o,a){return e=u.toRadians(r(e,0)),i=u.toRadians(r(i,0)),n=u.toRadians(r(n,0)),o=u.toRadians(r(o,0)),t(a)?(a.west=e,a.south=i,a.east=n,a.north=o,a):new s(e,i,n,o)},s.fromCartographicArray=function(e,r){if(!t(e))throw new n("cartographics is required.");for(var i=Number.MAX_VALUE,o=-Number.MAX_VALUE,a=Number.MAX_VALUE,u=-Number.MAX_VALUE,E=0,w=e.length;w>E;E++){var f=e[E];i=Math.min(i,f.longitude),o=Math.max(o,f.longitude),a=Math.min(a,f.latitude),u=Math.max(u,f.latitude)}return t(r)?(r.west=i,r.south=a,r.east=o,r.north=u,r):new s(i,a,o,u)},s.clone=function(e,r){return t(e)?t(r)?(r.west=e.west,r.south=e.south,r.east=e.east,r.north=e.north,r):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.west===r.west&&e.south===r.south&&e.east===r.east&&e.north===r.north},s.prototype.equalsEpsilon=function(e,r){if("number"!=typeof r)throw new n("epsilon is required and must be a number.");return t(e)&&Math.abs(this.west-e.west)<=r&&Math.abs(this.south-e.south)<=r&&Math.abs(this.east-e.east)<=r&&Math.abs(this.north-e.north)<=r},s.validate=function(e){if(!t(e))throw new n("rectangle is required");var r=e.north;if("number"!=typeof r)throw new n("north is required to be a number.");if(r<-u.PI_OVER_TWO||r>u.PI_OVER_TWO)throw new n("north must be in the interval [-Pi/2, Pi/2].");var i=e.south;if("number"!=typeof i)throw new n("south is required to be a number.");if(i<-u.PI_OVER_TWO||i>u.PI_OVER_TWO)throw new n("south must be in the interval [-Pi/2, Pi/2].");var o=e.west;if("number"!=typeof o)throw new n("west is required to be a number.");if(o<-Math.PI||o>Math.PI)throw new n("west must be in the interval [-Pi, Pi].");var a=e.east;if("number"!=typeof a)throw new n("east is required to be a number.");if(a<-Math.PI||a>Math.PI)throw new n("east must be in the interval [-Pi, Pi].")},s.southwest=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.west,i.latitude=r.south,i.height=0,i):new e(r.west,r.south)},s.northwest=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.west,i.latitude=r.north,i.height=0,i):new e(r.west,r.north)},s.northeast=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.east,i.latitude=r.north,i.height=0,i):new e(r.east,r.north)},s.southeast=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.east,i.latitude=r.south,i.height=0,i):new e(r.east,r.south)},s.center=function(r,i){if(!t(r))throw new n("rectangle is required");var o=r.east,a=r.west;a>o&&(o+=u.TWO_PI);var s=u.negativePiToPi(.5*(a+o)),E=.5*(r.south+r.north);return t(i)?(i.longitude=s,i.latitude=E,i.height=0,i):new e(s,E)},s.intersection=function(e,r,i){if(!t(e))throw new n("rectangle is required");if(!t(r))throw new n("otherRectangle is required.");var o=e.east,a=e.west,E=r.east,w=r.west;a>o&&E>0?o+=u.TWO_PI:w>E&&o>0&&(E+=u.TWO_PI),a>o&&0>w?w+=u.TWO_PI:w>E&&0>a&&(a+=u.TWO_PI);var f=u.negativePiToPi(Math.max(a,w)),h=u.negativePiToPi(Math.min(o,E));if((e.west<e.east||r.west<r.east)&&f>=h)return void 0;var c=Math.max(e.south,r.south),l=Math.min(e.north,r.north);return c>=l?void 0:t(i)?(i.west=f,i.south=c,i.east=h,i.north=l,i):new s(f,c,h,l)},s.contains=function(e,r){if(!t(e))throw new n("rectangle is required");if(!t(r))throw new n("cartographic is required.");var i=r.longitude,o=r.latitude,a=e.west,s=e.east;return a>s&&(s+=u.TWO_PI,0>i&&(i+=u.TWO_PI)),(i>a||u.equalsEpsilon(i,a,u.EPSILON14))&&(s>i||u.equalsEpsilon(i,s,u.EPSILON14))&&o>=e.south&&o<=e.north};var E=new e;return s.subsample=function(e,i,a,w){if(!t(e))throw new n("rectangle is required");i=r(i,o.WGS84),a=r(a,0),t(w)||(w=[]);var f=0,h=e.north,c=e.south,l=e.east,d=e.west,_=E;_.height=a,_.longitude=d,_.latitude=h,w[f]=i.cartographicToCartesian(_,w[f]),f++,_.longitude=l,w[f]=i.cartographicToCartesian(_,w[f]),f++,_.latitude=c,w[f]=i.cartographicToCartesian(_,w[f]),f++,_.longitude=d,w[f]=i.cartographicToCartesian(_,w[f]),f++,0>h?_.latitude=h:c>0?_.latitude=c:_.latitude=0;for(var R=1;8>R;++R)_.longitude=-Math.PI+R*u.PI_OVER_TWO,s.contains(e,_)&&(w[f]=i.cartographicToCartesian(_,w[f]),f++);return 0===_.latitude&&(_.longitude=d,w[f]=i.cartographicToCartesian(_,w[f]),f++,_.longitude=l,w[f]=i.cartographicToCartesian(_,w[f]),f++),w.length=f,w},s.MAX_VALUE=a(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Plane","./Rectangle"],function(e,r,t,i,n,o,a,u,s,E,w,f,h){
"use strict";var c=function(r,i){this.center=e.clone(t(r,e.ZERO)),this.radius=t(i,0)},l=new e,d=new e,_=new e,R=new e,T=new e,A=new e,m=new e,N=new e,I=new e,y=new e,p=new e,S=new e;c.fromPoints=function(r,t){if(i(t)||(t=new c),!i(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;for(var n=e.clone(r[0],m),o=e.clone(n,l),a=e.clone(n,d),u=e.clone(n,_),s=e.clone(n,R),E=e.clone(n,T),w=e.clone(n,A),f=r.length,h=1;f>h;h++){e.clone(r[h],n);var M=n.x,O=n.y,q=n.z;M<o.x&&e.clone(n,o),M>s.x&&e.clone(n,s),O<a.y&&e.clone(n,a),O>E.y&&e.clone(n,E),q<u.z&&e.clone(n,u),q>w.z&&e.clone(n,w)}var g=e.magnitudeSquared(e.subtract(s,o,N)),C=e.magnitudeSquared(e.subtract(E,a,N)),v=e.magnitudeSquared(e.subtract(w,u,N)),x=o,L=s,U=g;C>U&&(U=C,x=a,L=E),v>U&&(U=v,x=u,L=w);var P=I;P.x=.5*(x.x+L.x),P.y=.5*(x.y+L.y),P.z=.5*(x.z+L.z);var F=e.magnitudeSquared(e.subtract(L,P,N)),D=Math.sqrt(F),B=y;B.x=o.x,B.y=a.y,B.z=u.z;var b=p;b.x=s.x,b.y=E.y,b.z=w.z;var z=e.multiplyByScalar(e.add(B,b,N),.5,S),G=0;for(h=0;f>h;h++){e.clone(r[h],n);var V=e.magnitude(e.subtract(n,z,N));V>G&&(G=V);var X=e.magnitudeSquared(e.subtract(n,P,N));if(X>F){var H=Math.sqrt(X);D=.5*(D+H),F=D*D;var W=H-D;P.x=(D*P.x+W*n.x)/H,P.y=(D*P.y+W*n.y)/H,P.z=(D*P.z+W*n.z)/H}}return G>D?(e.clone(P,t.center),t.radius=D):(e.clone(z,t.center),t.radius=G),t};var M=new u,O=new e,q=new e,g=new r,C=new r;c.fromRectangle2D=function(e,r,t){return c.fromRectangleWithHeights2D(e,r,0,0,t)},c.fromRectangleWithHeights2D=function(r,n,o,a,u){if(i(u)||(u=new c),!i(r))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;n=t(n,M),h.southwest(r,g),g.height=o,h.northeast(r,C),C.height=a;var s=n.project(g,O),E=n.project(C,q),w=E.x-s.x,f=E.y-s.y,l=E.z-s.z;u.radius=.5*Math.sqrt(w*w+f*f+l*l);var d=u.center;return d.x=s.x+.5*w,d.y=s.y+.5*f,d.z=s.z+.5*l,u};var v=[];c.fromRectangle3D=function(e,r,n,o){r=t(r,a.WGS84),n=t(n,0);var u;return i(e)&&(u=h.subsample(e,r,n,v)),c.fromPoints(u,o)},c.fromVertices=function(r,n,a,u){if(i(u)||(u=new c),!i(r)||0===r.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;if(n=t(n,e.ZERO),a=t(a,3),3>a)throw new o("stride must be 3 or greater.");var s=m;s.x=r[0]+n.x,s.y=r[1]+n.y,s.z=r[2]+n.z;for(var E=e.clone(s,l),w=e.clone(s,d),f=e.clone(s,_),h=e.clone(s,R),M=e.clone(s,T),O=e.clone(s,A),q=r.length,g=0;q>g;g+=a){var C=r[g]+n.x,v=r[g+1]+n.y,x=r[g+2]+n.z;s.x=C,s.y=v,s.z=x,C<E.x&&e.clone(s,E),C>h.x&&e.clone(s,h),v<w.y&&e.clone(s,w),v>M.y&&e.clone(s,M),x<f.z&&e.clone(s,f),x>O.z&&e.clone(s,O)}var L=e.magnitudeSquared(e.subtract(h,E,N)),U=e.magnitudeSquared(e.subtract(M,w,N)),P=e.magnitudeSquared(e.subtract(O,f,N)),F=E,D=h,B=L;U>B&&(B=U,F=w,D=M),P>B&&(B=P,F=f,D=O);var b=I;b.x=.5*(F.x+D.x),b.y=.5*(F.y+D.y),b.z=.5*(F.z+D.z);var z=e.magnitudeSquared(e.subtract(D,b,N)),G=Math.sqrt(z),V=y;V.x=E.x,V.y=w.y,V.z=f.z;var X=p;X.x=h.x,X.y=M.y,X.z=O.z;var H=e.multiplyByScalar(e.add(V,X,N),.5,S),W=0;for(g=0;q>g;g+=a){s.x=r[g]+n.x,s.y=r[g+1]+n.y,s.z=r[g+2]+n.z;var Y=e.magnitude(e.subtract(s,H,N));Y>W&&(W=Y);var K=e.magnitudeSquared(e.subtract(s,b,N));if(K>z){var k=Math.sqrt(K);G=.5*(G+k),z=G*G;var j=k-G;b.x=(G*b.x+j*s.x)/k,b.y=(G*b.y+j*s.y)/k,b.z=(G*b.z+j*s.z)/k}}return W>G?(e.clone(b,u.center),u.radius=G):(e.clone(H,u.center),u.radius=W),u},c.fromCornerPoints=function(r,t,n){if(!i(r)||!i(t))throw new o("corner and oppositeCorner are required.");i(n)||(n=new c);var a=n.center;return e.add(r,t,a),e.multiplyByScalar(a,.5,a),n.radius=e.distance(a,t),n},c.fromEllipsoid=function(r,t){if(!i(r))throw new o("ellipsoid is required.");return i(t)||(t=new c),e.clone(e.ZERO,t.center),t.radius=r.maximumRadius,t};var x=new e;c.fromBoundingSpheres=function(r,t){if(i(t)||(t=new c),!i(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;var n=r.length;if(1===n)return c.clone(r[0],t);if(2===n)return c.union(r[0],r[1],t);for(var o=[],a=0;n>a;a++)o.push(r[a].center);t=c.fromPoints(o,t);var u=t.center,s=t.radius;for(a=0;n>a;a++){var E=r[a];s=Math.max(s,e.distance(u,E.center,x)+E.radius)}return t.radius=s,t},c.clone=function(r,t){return i(r)?i(t)?(t.center=e.clone(r.center,t.center),t.radius=r.radius,t):new c(r.center,r.radius):void 0},c.packedLength=4,c.pack=function(e,r,n){if(!i(e))throw new o("value is required");if(!i(r))throw new o("array is required");n=t(n,0);var a=e.center;r[n++]=a.x,r[n++]=a.y,r[n++]=a.z,r[n]=e.radius},c.unpack=function(e,r,n){if(!i(e))throw new o("array is required");r=t(r,0),i(n)||(n=new c);var a=n.center;return a.x=e[r++],a.y=e[r++],a.z=e[r++],n.radius=e[r],n};var L=new e,U=new e;c.union=function(r,t,n){if(!i(r))throw new o("left is required.");if(!i(t))throw new o("right is required.");i(n)||(n=new c);var a=r.center,u=r.radius,s=t.center,E=t.radius,w=e.subtract(s,a,L),f=e.magnitude(w);if(u>=f+E)return r.clone(n),n;if(E>=f+u)return t.clone(n),n;var h=.5*(u+f+E),l=e.multiplyByScalar(w,(-u+h)/f,U);return e.add(l,a,l),e.clone(l,n.center),n.radius=h,n};var P=new e;c.expand=function(r,t,n){if(!i(r))throw new o("sphere is required.");if(!i(t))throw new o("point is required.");n=c.clone(r,n);var a=e.magnitude(e.subtract(t,n.center,P));return a>n.radius&&(n.radius=a),n},c.intersectPlane=function(r,t){if(!i(r))throw new o("sphere is required.");if(!i(t))throw new o("plane is required.");var n=r.center,a=r.radius,u=t.normal,E=e.dot(u,n)+t.distance;return-a>E?s.OUTSIDE:a>E?s.INTERSECTING:s.INSIDE},c.transform=function(e,r,t){if(!i(e))throw new o("sphere is required.");if(!i(r))throw new o("transform is required.");return i(t)||(t=new c),t.center=w.multiplyByPoint(r,e.center,t.center),t.radius=w.getMaximumScale(r)*e.radius,t};var F=new e;c.distanceSquaredTo=function(r,t){if(!i(r))throw new o("sphere is required.");if(!i(t))throw new o("cartesian is required.");var n=e.subtract(r.center,t,F);return e.magnitudeSquared(n)-r.radius*r.radius},c.transformWithoutScale=function(e,r,t){if(!i(e))throw new o("sphere is required.");if(!i(r))throw new o("transform is required.");return i(t)||(t=new c),t.center=w.multiplyByPoint(r,e.center,t.center),t.radius=e.radius,t};var D=new e;c.computePlaneDistances=function(r,t,n,a){if(!i(r))throw new o("sphere is required.");if(!i(t))throw new o("position is required.");if(!i(n))throw new o("direction is required.");i(a)||(a=new E);var u=e.subtract(r.center,t,D),s=e.dot(n,u);return a.start=s-r.radius,a.stop=s+r.radius,a};for(var B=new e,b=new e,z=new e,G=new e,V=new e,X=new r,H=new Array(8),W=0;8>W;++W)H[W]=new e;var Y=new u;return c.projectTo2D=function(r,n,a){if(!i(r))throw new o("sphere is required.");n=t(n,Y);var u=n.ellipsoid,s=r.center,E=r.radius,w=u.geodeticSurfaceNormal(s,B),f=e.cross(e.UNIT_Z,w,b);e.normalize(f,f);var h=e.cross(w,f,z);e.normalize(h,h),e.multiplyByScalar(w,E,w),e.multiplyByScalar(h,E,h),e.multiplyByScalar(f,E,f);var l=e.negate(h,V),d=e.negate(f,G),_=H,R=_[0];e.add(w,h,R),e.add(R,f,R),R=_[1],e.add(w,h,R),e.add(R,d,R),R=_[2],e.add(w,l,R),e.add(R,d,R),R=_[3],e.add(w,l,R),e.add(R,f,R),e.negate(w,w),R=_[4],e.add(w,h,R),e.add(R,f,R),R=_[5],e.add(w,h,R),e.add(R,d,R),R=_[6],e.add(w,l,R),e.add(R,d,R),R=_[7],e.add(w,l,R),e.add(R,f,R);for(var T=_.length,A=0;T>A;++A){var m=_[A];e.add(s,m,m);var N=u.cartesianToCartographic(m,X);n.project(N,m)}a=c.fromPoints(_,a),s=a.center;var I=s.x,y=s.y,p=s.z;return s.x=p,s.y=I,s.z=y,a},c.isOccluded=function(e,r){if(!i(e))throw new o("sphere is required.");if(!i(r))throw new o("occluder is required.");return!r.isBoundingSphereVisible(e)},c.equals=function(r,t){return r===t||i(r)&&i(t)&&e.equals(r.center,t.center)&&r.radius===t.radius},c.prototype.intersectPlane=function(e){return c.intersectPlane(this,e)},c.prototype.distanceSquaredTo=function(e){return c.distanceSquaredTo(this,e)},c.prototype.computePlaneDistances=function(e,r,t){return c.computePlaneDistances(this,e,r,t)},c.prototype.isOccluded=function(e){return c.isOccluded(this,e)},c.prototype.equals=function(e){return c.equals(this,e)},c.prototype.clone=function(e){return c.clone(this,e)},c}),define("Renderer/WebGLConstants",["../Core/freezeObject"],function(e){"use strict";var r={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return e(r)}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,r){"use strict";var t,i={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},n={};return r(n,{element:{get:function(){return n.supportsFullscreen()?document[i.fullscreenElement]:void 0}},changeEventName:{get:function(){return n.supportsFullscreen()?i.fullscreenchange:void 0}},errorEventName:{get:function(){return n.supportsFullscreen()?i.fullscreenerror:void 0}},enabled:{get:function(){return n.supportsFullscreen()?document[i.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return n.supportsFullscreen()?null!==n.element:void 0}}}),n.supportsFullscreen=function(){if(e(t))return t;t=!1;var r=document.body;if("function"==typeof r.requestFullscreen)return i.requestFullscreen="requestFullscreen",i.exitFullscreen="exitFullscreen",i.fullscreenEnabled="fullscreenEnabled",i.fullscreenElement="fullscreenElement",i.fullscreenchange="fullscreenchange",i.fullscreenerror="fullscreenerror",t=!0;for(var n,o=["webkit","moz","o","ms","khtml"],a=0,u=o.length;u>a;++a){var s=o[a];n=s+"RequestFullscreen","function"==typeof r[n]?(i.requestFullscreen=n,t=!0):(n=s+"RequestFullScreen","function"==typeof r[n]&&(i.requestFullscreen=n,t=!0)),n=s+"ExitFullscreen","function"==typeof document[n]?i.exitFullscreen=n:(n=s+"CancelFullScreen","function"==typeof document[n]&&(i.exitFullscreen=n)),n=s+"FullscreenEnabled",e(document[n])?i.fullscreenEnabled=n:(n=s+"FullScreenEnabled",e(document[n])&&(i.fullscreenEnabled=n)),n=s+"FullscreenElement",e(document[n])?i.fullscreenElement=n:(n=s+"FullScreenElement",e(document[n])&&(i.fullscreenElement=n)),n=s+"fullscreenchange",e(document["on"+n])&&("ms"===s&&(n="MSFullscreenChange"),i.fullscreenchange=n),n=s+"fullscreenerror",e(document["on"+n])&&("ms"===s&&(n="MSFullscreenError"),i.fullscreenerror=n)}return t},n.requestFullscreen=function(e){n.supportsFullscreen()&&e[i.requestFullscreen]()},n.exitFullscreen=function(){n.supportsFullscreen()&&document[i.exitFullscreen]()},n}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,r,t){"use strict";function i(e){for(var r=e.split("."),t=0,i=r.length;i>t;++t)r[t]=parseInt(r[t],10);return r}function n(){if(!r(_)){_=!1;var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(_=!0,R=i(e[1]))}return _}function o(){return n()&&R}function a(){if(!r(T)&&(T=!1,!n()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(T=!0,A=i(e[1]))}return T}function u(){return a()&&A}function s(){if(!r(m)){m=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==e&&(m=!0,N=i(e[1]),N.isNightly=!!e[2])}return m}function E(){return s()&&N}function w(){if(!r(I)){I=!1;var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(I=!0,y=i(e[1]))):"Netscape"===navigator.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(I=!0,y=i(e[1])))}return I}function f(){return w()&&y}function h(){if(!r(p)){p=!1;var e=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(p=!0,S=i(e[1]))}return p}function c(){return r(M)||(M=/Windows/i.test(navigator.appVersion)),M}function l(){return h()&&S}function d(){return r(O)||(O=r(window.PointerEvent)&&(!r(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),O}var _,R,T,A,m,N,I,y,p,S,M,O,q={isChrome:n,chromeVersion:o,isSafari:a,safariVersion:u,isWebkit:s,webkitVersion:E,isInternetExplorer:w,internetExplorerVersion:f,isFirefox:h,firefoxVersion:l,isWindows:c,hardwareConcurrency:e(navigator.hardwareConcurrency,3),supportsPointerEvents:d};return q.supportsFullscreen=function(){return t.supportsFullscreen()},q.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},q.supportsWebWorkers=function(){return"undefined"!=typeof Worker},q}),define("Core/ComponentDatatype",["../Renderer/WebGLConstants","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,r,t,i,n,o){"use strict";if(!n.supportsTypedArrays())return{};var a={BYTE:e.BYTE,UNSIGNED_BYTE:e.UNSIGNED_BYTE,SHORT:e.SHORT,UNSIGNED_SHORT:e.UNSIGNED_SHORT,FLOAT:e.FLOAT,DOUBLE:e.DOUBLE};return a.getSizeInBytes=function(e){if(!t(e))throw new i("value is required.");switch(e){case a.BYTE:return Int8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.SHORT:return Int16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case a.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new i("componentDatatype is not a valid value.")}},a.fromTypedArray=function(e){return e instanceof Int8Array?a.BYTE:e instanceof Uint8Array?a.UNSIGNED_BYTE:e instanceof Int16Array?a.SHORT:e instanceof Uint16Array?a.UNSIGNED_SHORT:e instanceof Float32Array?a.FLOAT:e instanceof Float64Array?a.DOUBLE:void 0},a.validate=function(e){return t(e)&&(e===a.BYTE||e===a.UNSIGNED_BYTE||e===a.SHORT||e===a.UNSIGNED_SHORT||e===a.FLOAT||e===a.DOUBLE)},a.createTypedArray=function(e,r){if(!t(e))throw new i("componentDatatype is required.");if(!t(r))throw new i("valuesOrLength is required.");switch(e){case a.BYTE:return new Int8Array(r);case a.UNSIGNED_BYTE:return new Uint8Array(r);case a.SHORT:return new Int16Array(r);case a.UNSIGNED_SHORT:return new Uint16Array(r);case a.FLOAT:return new Float32Array(r);case a.DOUBLE:return new Float64Array(r);default:throw new i("componentDatatype is not a valid value.")}},a.createArrayBufferView=function(e,n,o,u){if(!t(e))throw new i("componentDatatype is required.");if(!t(n))throw new i("buffer is required.");switch(o=r(o,0),u=r(u,(n.byteLength-o)/a.getSizeInBytes(e)),e){case a.BYTE:return new Int8Array(n,o,u);case a.UNSIGNED_BYTE:return new Uint8Array(n,o,u);case a.SHORT:return new Int16Array(n,o,u);case a.UNSIGNED_SHORT:return new Uint16Array(n,o,u);case a.FLOAT:return new Float32Array(n,o,u);case a.DOUBLE:return new Float64Array(n,o,u);default:throw new i("componentDatatype is not a valid value.")}},o(a)}),define("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,r,t,i,n,o,a,u){"use strict";var s=function(e,t,i,n){this.x=r(e,0),this.y=r(t,0),this.z=r(i,0),this.w=r(n,0)},E=new e;s.fromAxisAngle=function(r,n,o){if(!t(r))throw new i("axis is required.");if("number"!=typeof n)throw new i("angle is required and must be a number.");var a=n/2,u=Math.sin(a);E=e.normalize(r,E);var w=E.x*u,f=E.y*u,h=E.z*u,c=Math.cos(a);return t(o)?(o.x=w,o.y=f,o.z=h,o.w=c,o):new s(w,f,h,c)};var w=[1,2,0],f=new Array(3);s.fromRotationMatrix=function(e,r){if(!t(e))throw new i("matrix is required.");var n,o,a,E,h,c=e[u.COLUMN0ROW0],l=e[u.COLUMN1ROW1],d=e[u.COLUMN2ROW2],_=c+l+d;if(_>0)n=Math.sqrt(_+1),h=.5*n,n=.5/n,o=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*n,a=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*n,E=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*n;else{var R=w,T=0;l>c&&(T=1),d>c&&d>l&&(T=2);var A=R[T],m=R[A];n=Math.sqrt(e[u.getElementIndex(T,T)]-e[u.getElementIndex(A,A)]-e[u.getElementIndex(m,m)]+1);var N=f;N[T]=.5*n,n=.5/n,h=(e[u.getElementIndex(m,A)]-e[u.getElementIndex(A,m)])*n,N[A]=(e[u.getElementIndex(A,T)]+e[u.getElementIndex(T,A)])*n,N[m]=(e[u.getElementIndex(m,T)]+e[u.getElementIndex(T,m)])*n,o=-N[0],a=-N[1],E=-N[2]}return t(r)?(r.x=o,r.y=a,r.z=E,r.w=h,r):new s(o,a,E,h)};var h=new s;s.fromHeadingPitchRoll=function(r,n,o,a){if(!t(r))throw new i("heading is required.");if(!t(n))throw new i("pitch is required.");if(!t(o))throw new i("roll is required.");var u=s.fromAxisAngle(e.UNIT_X,o,h),E=s.fromAxisAngle(e.UNIT_Y,-n,a);a=s.multiply(E,u,E);var w=s.fromAxisAngle(e.UNIT_Z,-r,h);return s.multiply(w,a,a)};var c=new e,l=new e,d=new s,_=new s,R=new s;s.packedLength=4,s.pack=function(e,n,o){if(!t(e))throw new i("value is required");if(!t(n))throw new i("array is required");o=r(o,0),n[o++]=e.x,n[o++]=e.y,n[o++]=e.z,n[o]=e.w},s.unpack=function(e,n,o){if(!t(e))throw new i("array is required");return n=r(n,0),t(o)||(o=new s),o.x=e[n],o.y=e[n+1],o.z=e[n+2],o.w=e[n+3],o},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,r,t,i){s.unpack(e,4*t,R),s.conjugate(R,R);for(var n=0,o=t-r+1;o>n;n++){var a=3*n;s.unpack(e,4*(r+n),d),s.multiply(d,R,d),d.w<0&&s.negate(d,d),s.computeAxis(d,c);var u=s.computeAngle(d);i[a]=c.x*u,i[a+1]=c.y*u,i[a+2]=c.z*u}},s.unpackInterpolationResult=function(r,i,n,o,a){t(a)||(a=new s),e.fromArray(r,0,l);var u=e.magnitude(l);return s.unpack(i,4*o,_),0===u?s.clone(s.IDENTITY,d):s.fromAxisAngle(l,u,d),s.multiply(d,_,a)},s.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,r){if(!t(e))throw new i("quaternion is required");if(!t(r))throw new i("result is required");return r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=e.w,r},s.magnitudeSquared=function(e){if(!t(e))throw new i("quaternion is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,r){if(!t(r))throw new i("result is required");var n=1/s.magnitude(e),o=e.x*n,a=e.y*n,u=e.z*n,E=e.w*n;return r.x=o,r.y=a,r.z=u,r.w=E,r},s.inverse=function(e,r){if(!t(r))throw new i("result is required");var n=s.magnitudeSquared(e);return r=s.conjugate(e,r),s.multiplyByScalar(r,1/n,r)},s.add=function(e,r,n){if(!t(e))throw new i("left is required");if(!t(r))throw new i("right is required");if(!t(n))throw new i("result is required");return n.x=e.x+r.x,n.y=e.y+r.y,n.z=e.z+r.z,n.w=e.w+r.w,n},s.subtract=function(e,r,n){if(!t(e))throw new i("left is required");if(!t(r))throw new i("right is required");if(!t(n))throw new i("result is required");return n.x=e.x-r.x,n.y=e.y-r.y,n.z=e.z-r.z,n.w=e.w-r.w,n},s.negate=function(e,r){if(!t(e))throw new i("quaternion is required");if(!t(r))throw new i("result is required");return r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r},s.dot=function(e,r){if(!t(e))throw new i("left is required");if(!t(r))throw new i("right is required");return e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w},s.multiply=function(e,r,n){if(!t(e))throw new i("left is required");if(!t(r))throw new i("right is required");if(!t(n))throw new i("result is required");var o=e.x,a=e.y,u=e.z,s=e.w,E=r.x,w=r.y,f=r.z,h=r.w,c=s*E+o*h+a*f-u*w,l=s*w-o*f+a*h+u*E,d=s*f+o*w-a*E+u*h,_=s*h-o*E-a*w-u*f;return n.x=c,n.y=l,n.z=d,n.w=_,n},s.multiplyByScalar=function(e,r,n){if(!t(e))throw new i("quaternion is required");if("number"!=typeof r)throw new i("scalar is required and must be a number.");if(!t(n))throw new i("result is required");return n.x=e.x*r,n.y=e.y*r,n.z=e.z*r,n.w=e.w*r,n},s.divideByScalar=function(e,r,n){if(!t(e))throw new i("quaternion is required");if("number"!=typeof r)throw new i("scalar is required and must be a number.");if(!t(n))throw new i("result is required");return n.x=e.x/r,n.y=e.y/r,n.z=e.z/r,n.w=e.w/r,n},s.computeAxis=function(e,r){if(!t(e))throw new i("quaternion is required");
if(!t(r))throw new i("result is required");var n=e.w;if(Math.abs(n-1)<a.EPSILON6)return r.x=r.y=r.z=0,r;var o=1/Math.sqrt(1-n*n);return r.x=e.x*o,r.y=e.y*o,r.z=e.z*o,r},s.computeAngle=function(e){if(!t(e))throw new i("quaternion is required");return Math.abs(e.w-1)<a.EPSILON6?0:2*Math.acos(e.w)};var T=new s;s.lerp=function(e,r,n,o){if(!t(e))throw new i("start is required.");if(!t(r))throw new i("end is required.");if("number"!=typeof n)throw new i("t is required and must be a number.");if(!t(o))throw new i("result is required");return T=s.multiplyByScalar(r,n,T),o=s.multiplyByScalar(e,1-n,o),s.add(T,o,o)};var A=new s,m=new s,N=new s;s.slerp=function(e,r,n,o){if(!t(e))throw new i("start is required.");if(!t(r))throw new i("end is required.");if("number"!=typeof n)throw new i("t is required and must be a number.");if(!t(o))throw new i("result is required");var u=s.dot(e,r),E=r;if(0>u&&(u=-u,E=A=s.negate(r,A)),1-u<a.EPSILON6)return s.lerp(e,E,n,o);var w=Math.acos(u);return m=s.multiplyByScalar(e,Math.sin((1-n)*w),m),N=s.multiplyByScalar(E,Math.sin(n*w),N),o=s.add(m,N,o),s.multiplyByScalar(o,1/Math.sin(w),o)},s.log=function(r,n){if(!t(r))throw new i("quaternion is required.");if(!t(n))throw new i("result is required");var o=a.acosClamped(r.w),u=0;return 0!==o&&(u=o/Math.sin(o)),e.multiplyByScalar(r,u,n)},s.exp=function(r,n){if(!t(r))throw new i("cartesian is required.");if(!t(n))throw new i("result is required");var o=e.magnitude(r),a=0;return 0!==o&&(a=Math.sin(o)/o),n.x=r.x*a,n.y=r.y*a,n.z=r.z*a,n.w=Math.cos(o),n};var I=new e,y=new e,p=new s,S=new s;s.computeInnerQuadrangle=function(r,n,o,a){if(!t(r)||!t(n)||!t(o))throw new i("q0, q1, and q2 are required.");if(!t(a))throw new i("result is required");var u=s.conjugate(n,p);s.multiply(u,o,S);var E=s.log(S,I);s.multiply(u,r,S);var w=s.log(S,y);return e.add(E,w,E),e.multiplyByScalar(E,.25,E),e.negate(E,E),s.exp(E,p),s.multiply(n,p,a)},s.squad=function(e,r,n,o,a,u){if(!(t(e)&&t(r)&&t(n)&&t(o)))throw new i("q0, q1, s0, and s1 are required.");if("number"!=typeof a)throw new i("t is required and must be a number.");if(!t(u))throw new i("result is required");var E=s.slerp(e,r,a,p),w=s.slerp(n,o,a,S);return s.slerp(E,w,2*a*(1-a),u)};for(var M=new s,O=1.9011074535173003,q=n.supportsTypedArrays()?new Float32Array(8):[],g=n.supportsTypedArrays()?new Float32Array(8):[],C=n.supportsTypedArrays()?new Float32Array(8):[],v=n.supportsTypedArrays()?new Float32Array(8):[],x=0;7>x;++x){var L=x+1,U=2*L+1;q[x]=1/(L*U),g[x]=L/U}return q[7]=O/136,g[7]=8*O/17,s.fastSlerp=function(e,r,n,o){if(!t(e))throw new i("start is required.");if(!t(r))throw new i("end is required.");if("number"!=typeof n)throw new i("t is required and must be a number.");if(!t(o))throw new i("result is required");var a,u=s.dot(e,r);u>=0?a=1:(a=-1,u=-u);for(var E=u-1,w=1-n,f=n*n,h=w*w,c=7;c>=0;--c)C[c]=(q[c]*f-g[c])*E,v[c]=(q[c]*h-g[c])*E;var l=a*n*(1+C[0]*(1+C[1]*(1+C[2]*(1+C[3]*(1+C[4]*(1+C[5]*(1+C[6]*(1+C[7])))))))),d=w*(1+v[0]*(1+v[1]*(1+v[2]*(1+v[3]*(1+v[4]*(1+v[5]*(1+v[6]*(1+v[7])))))))),_=s.multiplyByScalar(e,d,M);return s.multiplyByScalar(r,l,o),s.add(_,o,o)},s.fastSquad=function(e,r,n,o,a,u){if(!(t(e)&&t(r)&&t(n)&&t(o)))throw new i("q0, q1, s0, and s1 are required.");if("number"!=typeof a)throw new i("t is required and must be a number.");if(!t(u))throw new i("result is required");var E=s.fastSlerp(e,r,a,p),w=s.fastSlerp(n,o,a,S);return s.fastSlerp(E,w,2*a*(1-a),u)},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},s.equalsEpsilon=function(e,r,n){if("number"!=typeof n)throw new i("epsilon is required and must be a number.");return e===r||t(e)&&t(r)&&Math.abs(e.x-r.x)<=n&&Math.abs(e.y-r.y)<=n&&Math.abs(e.z-r.z)<=n&&Math.abs(e.w-r.w)<=n},s.ZERO=o(new s(0,0,0,0)),s.IDENTITY=o(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,r){return s.equalsEpsilon(this,e,r)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/EllipseGeometryLibrary",["./Cartesian3","./Math","./Matrix3","./Quaternion"],function(e,r,t,i){"use strict";function n(r,n,o,w,f,h,c,l,d,_){var R=r+n;e.multiplyByScalar(w,Math.cos(R),a),e.multiplyByScalar(o,Math.sin(R),u),e.add(a,u,a);var T=Math.cos(r);T*=T;var A=Math.sin(r);A*=A;var m=h/Math.sqrt(c*T+f*A),N=m/l;return i.fromAxisAngle(a,N,s),t.fromQuaternion(s,E),t.multiplyByVector(E,d,_),e.normalize(_,_),e.multiplyByScalar(_,l,_),_}var o={},a=new e,u=new e,s=new i,E=new t,w=new e,f=new e,h=new e,c=new e;o.raisePositionsToHeight=function(r,t,i){for(var n=t.ellipsoid,o=t.height,a=t.extrudedHeight,u=i?r.length/3*2:r.length/3,s=new Float64Array(3*u),E=r.length,l=i?E:0,d=0;E>d;d+=3){var _=d+1,R=d+2,T=e.fromArray(r,d,w);n.scaleToGeodeticSurface(T,T);var A=e.clone(T,f),m=n.geodeticSurfaceNormal(T,c),N=e.multiplyByScalar(m,o,h);e.add(T,N,T),i&&(e.multiplyByScalar(m,a,N),e.add(A,N,A),s[d+l]=A.x,s[_+l]=A.y,s[R+l]=A.z),s[d]=T.x,s[_]=T.y,s[R]=T.z}return s};var l=new e,d=new e,_=new e;return o.computeEllipsePositions=function(t,i,o){var a=t.semiMinorAxis,u=t.semiMajorAxis,s=t.rotation,E=t.center,c=8*t.granularity,R=a*a,T=u*u,A=u*a,m=e.magnitude(E),N=e.normalize(E,l),I=e.cross(e.UNIT_Z,E,d);I=e.normalize(I,I);var y=e.cross(N,I,_),p=1+Math.ceil(r.PI_OVER_TWO/c),S=r.PI_OVER_TWO/(p-1),M=r.PI_OVER_TWO-p*S;0>M&&(p-=Math.ceil(Math.abs(M)/S));var O,q,g,C,v,x=2*p*(p+1),L=i?new Array(3*x):void 0,U=0,P=w,F=f,D=3*(2*p+2*(p-1)),B=D-1,b=0,z=o?new Array(D):void 0;for(M=r.PI_OVER_TWO,O=0;p>O;++O){if(P=n(M,s,y,I,R,A,T,m,N,P),F=n(Math.PI-M,s,y,I,R,A,T,m,N,F),i){for(L[U++]=P.x,L[U++]=P.y,L[U++]=P.z,g=2*O+2,q=1;g-1>q;++q)C=q/(g-1),v=e.lerp(P,F,C,h),L[U++]=v.x,L[U++]=v.y,L[U++]=v.z;L[U++]=F.x,L[U++]=F.y,L[U++]=F.z}o&&(z[B--]=P.z,z[B--]=P.y,z[B--]=P.x,0!==O&&(z[b++]=F.x,z[b++]=F.y,z[b++]=F.z)),M=r.PI_OVER_TWO-(O+1)*S}for(O=p;O>0;--O){if(M=r.PI_OVER_TWO-(O-1)*S,P=n(-M,s,y,I,R,A,T,m,N,P),F=n(M+Math.PI,s,y,I,R,A,T,m,N,F),i){for(L[U++]=P.x,L[U++]=P.y,L[U++]=P.z,g=2*(O-1)+2,q=1;g-1>q;++q)C=q/(g-1),v=e.lerp(P,F,C,h),L[U++]=v.x,L[U++]=v.y,L[U++]=v.z;L[U++]=F.x,L[U++]=F.y,L[U++]=F.z}o&&(z[B--]=P.z,z[B--]=P.y,z[B--]=P.x,1!==O&&(z[b++]=F.x,z[b++]=F.y,z[b++]=F.z))}var G={};return i&&(G.positions=L,G.numPts=p),o&&(G.outerPositions=z),G},o}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var r={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(r)}),define("Core/PrimitiveType",["../Renderer/WebGLConstants","./freezeObject"],function(e,r){"use strict";var t={POINTS:e.POINTS,LINES:e.LINES,LINE_LOOP:e.LINE_LOOP,LINE_STRIP:e.LINE_STRIP,TRIANGLES:e.TRIANGLES,TRIANGLE_STRIP:e.TRIANGLE_STRIP,TRIANGLE_FAN:e.TRIANGLE_FAN,validate:function(e){return e===t.POINTS||e===t.LINES||e===t.LINE_LOOP||e===t.LINE_STRIP||e===t.TRIANGLES||e===t.TRIANGLE_STRIP||e===t.TRIANGLE_FAN}};return r(t)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,r,t,i,n){"use strict";var o=function(o){if(o=e(o,e.EMPTY_OBJECT),!r(o.attributes))throw new t("options.attributes is required.");this.attributes=o.attributes,this.indices=o.indices,this.primitiveType=e(o.primitiveType,n.TRIANGLES),this.boundingSphere=o.boundingSphere,this.geometryType=e(o.geometryType,i.NONE),this.boundingSphereCV=void 0};return o.computeNumberOfVertices=function(e){if(!r(e))throw new t("geometry is required.");var i=-1;for(var n in e.attributes)if(e.attributes.hasOwnProperty(n)&&r(e.attributes[n])&&r(e.attributes[n].values)){var o=e.attributes[n],a=o.values.length/o.componentsPerAttribute;if(i!==a&&-1!==i)throw new t("All attribute lists must have the same number of attributes.");i=a}return i},o}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var i=function(i){if(i=e(i,e.EMPTY_OBJECT),!r(i.componentDatatype))throw new t("options.componentDatatype is required.");if(!r(i.componentsPerAttribute))throw new t("options.componentsPerAttribute is required.");if(i.componentsPerAttribute<1||i.componentsPerAttribute>4)throw new t("options.componentsPerAttribute must be between 1 and 4.");if(!r(i.values))throw new t("options.values is required.");this.componentDatatype=i.componentDatatype,this.componentsPerAttribute=i.componentsPerAttribute,this.normalize=e(i.normalize,!1),this.values=i.values};return i}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var r=function(r){r=e(r,e.EMPTY_OBJECT),this.position=r.position,this.normal=r.normal,this.st=r.st,this.binormal=r.binormal,this.tangent=r.tangent,this.color=r.color};return r}),define("Core/IndexDatatype",["../Renderer/WebGLConstants","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n){"use strict";var o={UNSIGNED_BYTE:e.UNSIGNED_BYTE,UNSIGNED_SHORT:e.UNSIGNED_SHORT,UNSIGNED_INT:e.UNSIGNED_INT};return o.getSizeInBytes=function(e){switch(e){case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},o.validate=function(e){return r(e)&&(e===o.UNSIGNED_BYTE||e===o.UNSIGNED_SHORT||e===o.UNSIGNED_INT)},o.createTypedArray=function(e,i){if(!r(e))throw new t("numberOfVertices is required.");return e>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},o.createTypedArrayFromArrayBuffer=function(e,i,o,a){if(!r(e))throw new t("numberOfVertices is required.");if(!r(i))throw new t("sourceArray is required.");if(!r(o))throw new t("byteOffset is required.");return e>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(i,o,a):new Uint16Array(i,o,a)},i(o)}),define("Core/EllipseOutlineGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EllipseGeometryLibrary","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType"],function(e,r,t,i,n,o,a,u,s,E,w,f,h,c){"use strict";function l(i){var n=i.center;R=r.multiplyByScalar(i.ellipsoid.geodeticSurfaceNormal(n,R),i.height,R),R=r.add(n,R,R);for(var o=new e(R,i.semiMajorAxis),u=a.computeEllipsePositions(i,!1,!0).outerPositions,s=new w({position:new E({componentDatatype:t.DOUBLE,componentsPerAttribute:3,values:a.raisePositionsToHeight(u,i,!1)})}),h=u.length/3,c=f.createTypedArray(h,2*h),l=0,d=0;h>d;++d)c[l++]=d,c[l++]=(d+1)%h;return{boundingSphere:o,attributes:s,indices:c}}function d(n){var o=i(n.numberOfVerticalLines,16);o=Math.max(o,0);var u=n.center,s=n.ellipsoid,h=n.semiMajorAxis,c=r.multiplyByScalar(s.geodeticSurfaceNormal(u,_),n.height,_);T.center=r.add(u,c,T.center),T.radius=h,c=r.multiplyByScalar(s.geodeticSurfaceNormal(u,c),n.extrudedHeight,c),A.center=r.add(u,c,A.center),A.radius=h;var l=a.computeEllipsePositions(n,!1,!0).outerPositions,d=new w({position:new E({componentDatatype:t.DOUBLE,componentsPerAttribute:3,values:a.raisePositionsToHeight(l,n,!0)})});l=d.position.values;var R=e.union(T,A),m=l.length/3,N=f.createTypedArray(m,2*m+2*o);m/=2;var I,y=0;for(I=0;m>I;++I)N[y++]=I,N[y++]=(I+1)%m,N[y++]=I+m,N[y++]=(I+1)%m+m;var p;if(o>0){var S=Math.min(o,m);p=Math.round(m/S)}var M=Math.min(p*o,m);if(o>0)for(I=0;M>I;I+=p)N[y++]=I,N[y++]=I+m;return{boundingSphere:R,attributes:d,indices:N}}var _=new r,R=new r,T=new e,A=new e,m=function(e){e=i(e,i.EMPTY_OBJECT);var t=e.center,a=i(e.ellipsoid,u.WGS84),s=e.semiMajorAxis,E=e.semiMinorAxis,w=i(e.granularity,h.RADIANS_PER_DEGREE),f=i(e.height,0),c=e.extrudedHeight,l=n(c)&&Math.abs(f-c)>1;if(!n(t))throw new o("center is required.");if(!n(s))throw new o("semiMajorAxis is required.");if(!n(E))throw new o("semiMinorAxis is required.");if(0>=s||0>=E)throw new o("Semi-major and semi-minor axes must be greater than zero.");if(E>s)throw new o("semiMajorAxis must be greater than or equal to the semiMinorAxis.");if(0>=w)throw new o("granularity must be greater than zero.");this._center=r.clone(t),this._semiMajorAxis=s,this._semiMinorAxis=E,this._ellipsoid=u.clone(a),this._rotation=i(e.rotation,0),this._height=f,this._granularity=w,this._extrudedHeight=c,this._extrude=l,this._numberOfVerticalLines=Math.max(i(e.numberOfVerticalLines,16),0),this._workerName="createEllipseOutlineGeometry"};m.packedLength=r.packedLength+u.packedLength+9,m.pack=function(e,t,a){if(!n(e))throw new o("value is required");if(!n(t))throw new o("array is required");a=i(a,0),r.pack(e._center,t,a),a+=r.packedLength,u.pack(e._ellipsoid,t,a),a+=u.packedLength,t[a++]=e._semiMajorAxis,t[a++]=e._semiMinorAxis,t[a++]=e._rotation,t[a++]=e._height,t[a++]=e._granularity,t[a++]=n(e._extrudedHeight)?1:0,t[a++]=i(e._extrudedHeight,0),t[a++]=e._extrude?1:0,t[a]=e._numberOfVerticalLines};var N=new r,I=new u,y={center:N,ellipsoid:I,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0,numberOfVerticalLines:void 0};return m.unpack=function(e,t,a){if(!n(e))throw new o("array is required");t=i(t,0);var s=r.unpack(e,t,N);t+=r.packedLength;var E=u.unpack(e,t,I);t+=u.packedLength;var w=e[t++],f=e[t++],h=e[t++],c=e[t++],l=e[t++],d=e[t++],_=e[t++],R=1===e[t++],T=e[t];return n(a)?(a._center=r.clone(s,a._center),a._ellipsoid=u.clone(E,a._ellipsoid),a._semiMajorAxis=w,a._semiMinorAxis=f,a._rotation=h,a._height=c,a._granularity=l,a._extrudedHeight=d?_:void 0,a._extrude=R,a._numberOfVerticalLines=T,a):(y.height=c,y.extrudedHeight=d?_:void 0,y.granularity=l,y.rotation=h,y.semiMajorAxis=w,y.semiMinorAxis=f,y.numberOfVerticalLines=T,new m(y))},m.createGeometry=function(e){e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);var r,t={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:e._height,extrudedHeight:e._extrudedHeight,granularity:e._granularity,numberOfVerticalLines:e._numberOfVerticalLines};return e._extrude?(t.extrudedHeight=Math.min(e._extrudedHeight,e._height),t.height=Math.max(e._extrudedHeight,e._height),r=d(t)):r=l(t),new s({attributes:r.attributes,indices:r.indices,primitiveType:c.LINES,boundingSphere:r.boundingSphere})},m}),define("Core/CircleOutlineGeometry",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./EllipseOutlineGeometry","./Ellipsoid"],function(e,r,t,i,n,o){"use strict";var a=function(e){e=r(e,r.EMPTY_OBJECT);var o=e.radius;if(!t(o))throw new i("radius is required.");if(0>=o)throw new i("radius must be greater than zero.");var a={center:e.center,semiMajorAxis:o,semiMinorAxis:o,ellipsoid:e.ellipsoid,height:e.height,extrudedHeight:e.extrudedHeight,granularity:e.granularity,numberOfVerticalLines:e.numberOfVerticalLines};this._ellipseGeometry=new n(a),this._workerName="createCircleOutlineGeometry"};a.packedLength=n.packedLength,a.pack=function(e,r,o){if(!t(e))throw new i("value is required");n.pack(e._ellipseGeometry,r,o)};var u=new n({center:new e,semiMajorAxis:1,semiMinorAxis:1}),s={center:new e,radius:void 0,ellipsoid:o.clone(o.UNIT_SPHERE),height:void 0,extrudedHeight:void 0,granularity:void 0,numberOfVerticalLines:void 0,semiMajorAxis:void 0,semiMinorAxis:void 0};return a.unpack=function(r,i,E){var w=n.unpack(r,i,u);return s.center=e.clone(w._center,s.center),s.ellipsoid=o.clone(w._ellipsoid,s.ellipsoid),s.height=w._height,s.extrudedHeight=w._extrudedHeight,s.granularity=w._granularity,s.numberOfVerticalLines=w._numberOfVerticalLines,t(E)?(s.semiMajorAxis=w._semiMajorAxis,s.semiMinorAxis=w._semiMinorAxis,E._ellipseGeometry=new n(s),E):(s.radius=w._semiMajorAxis,new a(s))},a.createGeometry=function(e){return n.createGeometry(e._ellipseGeometry)},a}),define("Workers/createCircleOutlineGeometry",["../Core/Cartesian3","../Core/CircleOutlineGeometry","../Core/defined","../Core/Ellipsoid"],function(e,r,t,i){"use strict";function n(n,o){return t(o)&&(n=r.unpack(n,o)),n._ellipseGeometry._center=e.clone(n._ellipseGeometry._center),n._ellipseGeometry._ellipsoid=i.clone(n._ellipseGeometry._ellipsoid),r.createGeometry(n)}return n})}();