/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var r=Object.freeze;return e(r)||(r=function(e){return e}),r}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var r=function(e,r){return void 0!==e?e:r};return r.EMPTY_OBJECT=e({}),r}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var r=function(e){this.name="DeveloperError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r.throwInstantiationError=function(){throw new r("This function defines an interface and should not be called directly.")},r}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var t;for(this.mti==this.N+1&&this.init_genrand(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^r[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^r[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^r[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,r,t,i){"use strict";var n={};n.EPSILON1=.1,n.EPSILON2=.01,n.EPSILON3=.001,n.EPSILON4=1e-4,n.EPSILON5=1e-5,n.EPSILON6=1e-6,n.EPSILON7=1e-7,n.EPSILON8=1e-8,n.EPSILON9=1e-9,n.EPSILON10=1e-10,n.EPSILON11=1e-11,n.EPSILON12=1e-12,n.EPSILON13=1e-13,n.EPSILON14=1e-14,n.EPSILON15=1e-15,n.EPSILON16=1e-16,n.EPSILON17=1e-17,n.EPSILON18=1e-18,n.EPSILON19=1e-19,n.EPSILON20=1e-20,n.GRAVITATIONALPARAMETER=3986004418e5,n.SOLAR_RADIUS=6955e5,n.LUNAR_RADIUS=1737400,n.SIXTY_FOUR_KILOBYTES=65536,n.sign=function(e){return e>0?1:0>e?-1:0},n.signNotZero=function(e){return 0>e?-1:1},n.toSNorm=function(e){return Math.round(255*(.5*n.clamp(e,-1,1)+.5))},n.fromSNorm=function(e){return n.clamp(e,0,255)/255*2-1},n.sinh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r-t)},n.cosh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r+t)},n.lerp=function(e,r,t){return(1-t)*e+t*r},n.PI=Math.PI,n.ONE_OVER_PI=1/Math.PI,n.PI_OVER_TWO=.5*Math.PI,n.PI_OVER_THREE=Math.PI/3,n.PI_OVER_FOUR=Math.PI/4,n.PI_OVER_SIX=Math.PI/6,n.THREE_PI_OVER_TWO=3*Math.PI*.5,n.TWO_PI=2*Math.PI,n.ONE_OVER_TWO_PI=1/(2*Math.PI),n.RADIANS_PER_DEGREE=Math.PI/180,n.DEGREES_PER_RADIAN=180/Math.PI,n.RADIANS_PER_ARCSECOND=n.RADIANS_PER_DEGREE/3600,n.toRadians=function(e){if(!t(e))throw new i("degrees is required.");return e*n.RADIANS_PER_DEGREE},n.toDegrees=function(e){if(!t(e))throw new i("radians is required.");return e*n.DEGREES_PER_RADIAN},n.convertLongitudeRange=function(e){if(!t(e))throw new i("angle is required.");var r=n.TWO_PI,o=e-Math.floor(e/r)*r;return o<-Math.PI?o+r:o>=Math.PI?o-r:o},n.negativePiToPi=function(e){if(!t(e))throw new i("x is required.");return n.zeroToTwoPi(e+n.PI)-n.PI},n.zeroToTwoPi=function(e){if(!t(e))throw new i("x is required.");var r=n.mod(e,n.TWO_PI);return Math.abs(r)<n.EPSILON14&&Math.abs(e)>n.EPSILON14?n.TWO_PI:r},n.mod=function(e,r){if(!t(e))throw new i("m is required.");if(!t(r))throw new i("n is required.");return(e%r+r)%r},n.equalsEpsilon=function(e,n,o,a){if(!t(e))throw new i("left is required.");if(!t(n))throw new i("right is required.");if(!t(o))throw new i("relativeEpsilon is required.");a=r(a,o);var u=Math.abs(e-n);return a>=u||u<=o*Math.max(Math.abs(e),Math.abs(n))};var o=[1];n.factorial=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");var r=o.length;if(e>=r)for(var t=o[r-1],n=r;e>=n;n++)o.push(t*n);return o[e]},n.incrementWrap=function(e,n,o){if(o=r(o,0),!t(e))throw new i("n is required.");if(o>=n)throw new i("maximumValue must be greater than minimumValue.");return++e,e>n&&(e=o),e},n.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},n.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},n.clamp=function(e,r,n){if(!t(e))throw new i("value is required");if(!t(r))throw new i("min is required.");if(!t(n))throw new i("max is required.");return r>e?r:e>n?n:e};var a=new e;return n.setRandomNumberSeed=function(r){if(!t(r))throw new i("seed is required.");a=new e(r)},n.nextRandomNumber=function(){return a.random()},n.acosClamped=function(e){if(!t(e))throw new i("value is required.");return Math.acos(n.clamp(e,-1,1))},n.asinClamped=function(e){if(!t(e))throw new i("value is required.");return Math.asin(n.clamp(e,-1,1))},n.chordLength=function(e,r){if(!t(e))throw new i("angle is required.");if(!t(r))throw new i("radius is required.");return 2*r*Math.sin(.5*e)},n}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n){"use strict";var o=function(r,t,i){this.x=e(r,0),this.y=e(t,0),this.z=e(i,0)};o.fromSpherical=function(i,n){if(!r(i))throw new t("spherical is required");r(n)||(n=new o);var a=i.clock,u=i.cone,s=e(i.magnitude,1),l=s*Math.sin(u);return n.x=l*Math.cos(a),n.y=l*Math.sin(a),n.z=s*Math.cos(u),n},o.fromElements=function(e,t,i,n){return r(n)?(n.x=e,n.y=t,n.z=i,n):new o(e,t,i)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new o(e.x,e.y,e.z):void 0},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(i,n,o){if(!r(i))throw new t("value is required");if(!r(n))throw new t("array is required");o=e(o,0),n[o++]=i.x,n[o++]=i.y,n[o]=i.z},o.unpack=function(i,n,a){if(!r(i))throw new t("array is required");return n=e(n,0),r(a)||(a=new o),a.x=i[n++],a.y=i[n++],a.z=i[n],a},o.fromArray=o.unpack,o.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z)},o.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z)},o.minimumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.min(e.x,i.x),n.y=Math.min(e.y,i.y),n.z=Math.min(e.z,i.z),n},o.maximumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.max(e.x,i.x),n.y=Math.max(e.y,i.y),n.z=Math.max(e.z,i.z),n},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,i){if(!r(e)||!r(i))throw new t("left and right are required.");return o.subtract(e,i,a),o.magnitude(a)},o.distanceSquared=function(e,i){if(!r(e)||!r(i))throw new t("left and right are required.");return o.subtract(e,i,a),o.magnitudeSquared(a)},o.normalize=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");var n=o.magnitude(e);return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i},o.dot=function(e,i){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");return e.x*i.x+e.y*i.y+e.z*i.z},o.multiplyComponents=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x*i.x,n.y=e.y*i.y,n.z=e.z*i.z,n},o.add=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x+i.x,n.y=e.y+i.y,n.z=e.z+i.z,n},o.subtract=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x-i.x,n.y=e.y-i.y,n.z=e.z-i.z,n},o.multiplyByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x*i,n.y=e.y*i,n.z=e.z*i,n},o.divideByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n},o.negate=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=-e.x,i.y=-e.y,i.z=-e.z,i},o.abs=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=Math.abs(e.x),i.y=Math.abs(e.y),i.z=Math.abs(e.z),i};var u=new o;o.lerp=function(e,i,n,a){if(!r(e))throw new t("start is required.");if(!r(i))throw new t("end is required.");if("number"!=typeof n)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(i,n,u),a=o.multiplyByScalar(e,1-n,a),o.add(u,a,a)};var s=new o,l=new o;o.angleBetween=function(e,i){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");o.normalize(e,s),o.normalize(i,l);var n=o.dot(s,l),a=o.magnitude(o.cross(s,l,s));return Math.atan2(a,n)};var c=new o;o.mostOrthogonalAxis=function(e,i){if(!r(e))throw new t("cartesian is required.");if(!r(i))throw new t("result is required.");var n=o.normalize(e,c);return o.abs(n,n),i=n.x<=n.y?n.x<=n.z?o.clone(o.UNIT_X,i):o.clone(o.UNIT_Z,i):n.y<=n.z?o.clone(o.UNIT_Y,i):o.clone(o.UNIT_Z,i)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},o.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]&&e.z===r[t+2]},o.equalsEpsilon=function(e,t,i,o){return e===t||r(e)&&r(t)&&n.equalsEpsilon(e.x,t.x,i,o)&&n.equalsEpsilon(e.y,t.y,i,o)&&n.equalsEpsilon(e.z,t.z,i,o)},o.cross=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");var o=e.x,a=e.y,u=e.z,s=i.x,l=i.y,c=i.z,f=a*c-u*l,h=u*s-o*c,w=o*l-a*s;return n.x=f,n.y=h,n.z=w,n},o.fromDegrees=function(e,i,a,u,s){if(!r(e))throw new t("longitude is required");if(!r(i))throw new t("latitude is required");var l=n.toRadians(e),c=n.toRadians(i);return o.fromRadians(l,c,a,u,s)};var f=new o,h=new o,w=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(i,n,a,u,s){if(!r(i))throw new t("longitude is required");if(!r(n))throw new t("latitude is required");a=e(a,0);var l=r(u)?u.radiiSquared:w,c=Math.cos(n);f.x=c*Math.cos(i),f.y=c*Math.sin(i),f.z=Math.sin(n),f=o.normalize(f,f),o.multiplyComponents(l,f,h);var d=Math.sqrt(o.dot(f,h));return h=o.divideByScalar(h,d,h),f=o.multiplyByScalar(f,a,f),r(s)||(s=new o),o.add(h,f,s)},o.fromDegreesArray=function(e,i,a){if(!r(e))throw new t("positions is required.");for(var u=new Array(e.length),s=0;s<e.length;s++)u[s]=n.toRadians(e[s]);return o.fromRadiansArray(u,i,a)},o.fromRadiansArray=function(e,i,n){if(!r(e))throw new t("positions is required.");if(e.length<2)throw new t("positions length cannot be less than 2.");if(e.length%2!==0)throw new t("positions length must be a multiple of 2.");var a=e.length;r(n)?n.length=a/2:n=new Array(a/2);for(var u=0;a>u;u+=2){var s=e[u],l=e[u+1];n[u/2]=o.fromRadians(s,l,0,i,n[u/2])}return n},o.fromDegreesArrayHeights=function(e,i,a){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(e.length%3!==0)throw new t("positions length must be a multiple of 3.");for(var u=new Array(e.length),s=0;s<e.length;s+=3)u[s]=n.toRadians(e[s]),u[s+1]=n.toRadians(e[s+1]),u[s+2]=e[s+2];return o.fromRadiansArrayHeights(u,i,a)},o.fromRadiansArrayHeights=function(e,i,n){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(e.length%3!==0)throw new t("positions length must be a multiple of 3.");var a=e.length;r(n)?n.length=a/3:n=new Array(a/3);for(var u=0;a>u;u+=3){var s=e[u],l=e[u+1],c=e[u+2];n[u/3]=o.fromRadians(s,l,c,i,n[u/3])}return n},o.ZERO=i(new o(0,0,0)),o.UNIT_X=i(new o(1,0,0)),o.UNIT_Y=i(new o(0,1,0)),o.UNIT_Z=i(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r,t){return o.equalsEpsilon(this,e,r,t)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n){"use strict";var o=function(r,t,i){this.longitude=e(r,0),this.latitude=e(t,0),this.height=e(i,0)};return o.fromRadians=function(i,n,a,u){if(!r(i))throw new t("longitude is required.");if(!r(n))throw new t("latitude is required.");return a=e(a,0),r(u)?(u.longitude=i,u.latitude=n,u.height=a,u):new o(i,n,a)},o.fromDegrees=function(e,i,a,u){if(!r(e))throw new t("longitude is required.");if(!r(i))throw new t("latitude is required.");return e=n.toRadians(e),i=n.toRadians(i),o.fromRadians(e,i,a,u)},o.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new o(e.longitude,e.latitude,e.height):void 0},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},o.equalsEpsilon=function(e,i,n){if("number"!=typeof n)throw new t("epsilon is required and must be a number.");return e===i||r(e)&&r(i)&&Math.abs(e.longitude-i.longitude)<=n&&Math.abs(e.latitude-i.latitude)<=n&&Math.abs(e.height-i.height)<=n},o.ZERO=i(new o(0,0,0)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r){return o.equalsEpsilon(this,e,r)},o.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},o}),define("Core/deprecationWarning",["./defined","./DeveloperError"],function(e,r){"use strict";var t={},i=function(i,n){if(!e(i)||!e(n))throw new r("identifier and message are required.");e(t[i])||(t[i]=!0,console.log(n))};return i}),define("Core/defineProperties",["./defined"],function(e){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),t=Object.defineProperties;return r&&e(t)||(t=function(e){return e}),t}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n,o,a,u){"use strict";function s(r,i,n,a){if(i=t(i,0),n=t(n,0),a=t(a,0),0>i||0>n||0>a)throw new o("All radii components must be greater than or equal to zero.");r._radii=new e(i,n,a),r._radiiSquared=new e(i*i,n*n,a*a),r._radiiToTheFourth=new e(i*i*i*i,n*n*n*n,a*a*a*a),r._oneOverRadii=new e(0===i?0:1/i,0===n?0:1/n,0===a?0:1/a),r._oneOverRadiiSquared=new e(0===i?0:1/(i*i),0===n?0:1/(n*n),0===a?0:1/(a*a)),r._minimumRadius=Math.min(i,n,a),r._maximumRadius=Math.max(i,n,a),r._centerToleranceSquared=u.EPSILON1}var l=function(e,r,t){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,s(this,e,r,t)};n(l.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),l.clone=function(r,t){if(!i(r))return void 0;var n=r._radii;return i(t)?(e.clone(n,t._radii),e.clone(r._radiiSquared,t._radiiSquared),e.clone(r._radiiToTheFourth,t._radiiToTheFourth),e.clone(r._oneOverRadii,t._oneOverRadii),e.clone(r._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=r._minimumRadius,t._maximumRadius=r._maximumRadius,t._centerToleranceSquared=r._centerToleranceSquared,t):new l(n.x,n.y,n.z)},l.fromCartesian3=function(e,r){return i(r)||(r=new l),i(e)?(s(r,e.x,e.y,e.z),r):r},l.WGS84=a(new l(6378137,6378137,6356752.314245179)),l.UNIT_SPHERE=a(new l(1,1,1)),l.MOON=a(new l(u.LUNAR_RADIUS,u.LUNAR_RADIUS,u.LUNAR_RADIUS)),l.prototype.clone=function(e){return l.clone(this,e)},l.packedLength=e.packedLength,l.pack=function(r,n,a){if(!i(r))throw new o("value is required");if(!i(n))throw new o("array is required");a=t(a,0),e.pack(r._radii,n,a)},l.unpack=function(r,n,a){if(!i(r))throw new o("array is required");n=t(n,0);var u=e.unpack(r,n);return l.fromCartesian3(u,a)},l.prototype.geocentricSurfaceNormal=e.normalize,l.prototype.geodeticSurfaceNormalCartographic=function(r,t){if(!i(r))throw new o("cartographic is required.");var n=r.longitude,a=r.latitude,u=Math.cos(a),s=u*Math.cos(n),l=u*Math.sin(n),c=Math.sin(a);return i(t)||(t=new e),t.x=s,t.y=l,t.z=c,e.normalize(t,t)},l.prototype.geodeticSurfaceNormal=function(r,t){return i(t)||(t=new e),t=e.multiplyComponents(r,this._oneOverRadiiSquared,t),e.normalize(t,t)};var c=new e,f=new e;l.prototype.cartographicToCartesian=function(r,t){var n=c,o=f;this.geodeticSurfaceNormalCartographic(r,n),e.multiplyComponents(this._radiiSquared,n,o);var a=Math.sqrt(e.dot(n,o));return e.divideByScalar(o,a,o),e.multiplyByScalar(n,r.height,n),i(t)||(t=new e),e.add(o,n,t)},l.prototype.cartographicArrayToCartesianArray=function(e,r){if(!i(e))throw new o("cartographics is required.");var t=e.length;i(r)?r.length=t:r=new Array(t);for(var n=0;t>n;n++)r[n]=this.cartographicToCartesian(e[n],r[n]);return r};var h=new e,w=new e,d=new e;l.prototype.cartesianToCartographic=function(t,n){var o=this.scaleToGeodeticSurface(t,w);if(!i(o))return void 0;var a=this.geodeticSurfaceNormal(o,h),s=e.subtract(t,o,d),l=Math.atan2(a.y,a.x),c=Math.asin(a.z),f=u.sign(e.dot(s,t))*e.magnitude(s);return i(n)?(n.longitude=l,n.latitude=c,n.height=f,n):new r(l,c,f)},l.prototype.cartesianArrayToCartographicArray=function(e,r){if(!i(e))throw new o("cartesians is required.");var t=e.length;i(r)?r.length=t:r=new Array(t);for(var n=0;t>n;++n)r[n]=this.cartesianToCartographic(e[n],r[n]);return r};var m=new e,E=new e;return l.prototype.scaleToGeodeticSurface=function(r,t){if(!i(r))throw new o("cartesian is required.");var n=r.x,a=r.y,s=r.z,l=this._oneOverRadii,c=l.x,f=l.y,h=l.z,w=n*n*c*c,d=a*a*f*f,p=s*s*h*h,y=w+d+p,_=Math.sqrt(1/y),T=e.multiplyByScalar(r,_,m);if(y<this._centerToleranceSquared)return isFinite(_)?e.clone(T,t):void 0;var R=this._oneOverRadiiSquared,A=R.x,v=R.y,N=R.z,I=E;I.x=T.x*A*2,I.y=T.y*v*2,I.z=T.z*N*2;var S,g,M,O,q,x,b,P,L,C,F,U=(1-_)*e.magnitude(r)/(.5*e.magnitude(I)),D=0;do{U-=D,M=1/(1+U*A),O=1/(1+U*v),q=1/(1+U*N),x=M*M,b=O*O,P=q*q,L=x*M,C=b*O,F=P*q,S=w*x+d*b+p*P-1,g=w*L*A+d*C*v+p*F*N;var B=-2*g;D=S/B}while(Math.abs(S)>u.EPSILON12);return i(t)?(t.x=n*M,t.y=a*O,t.z=s*q,t):new e(n*M,a*O,s*q)},l.prototype.scaleToGeocentricSurface=function(r,t){if(!i(r))throw new o("cartesian is required.");i(t)||(t=new e);var n=r.x,a=r.y,u=r.z,s=this._oneOverRadiiSquared,l=1/Math.sqrt(n*n*s.x+a*a*s.y+u*u*s.z);return e.multiplyByScalar(r,l,t)},l.prototype.transformPositionToScaledSpace=function(r,t){return i(t)||(t=new e),e.multiplyComponents(r,this._oneOverRadii,t)},l.prototype.transformPositionFromScaledSpace=function(r,t){return i(t)||(t=new e),e.multiplyComponents(r,this._radii,t)},l.prototype.equals=function(r){return this===r||i(r)&&e.equals(this._radii,r._radii)},l.prototype.toString=function(){return this._radii.toString()},l}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,r,t,i,n,o,a){"use strict";var u=function(e){this._ellipsoid=t(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return n(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.prototype.project=function(r,t){var n=this._semimajorAxis,o=r.longitude*n,a=r.latitude*n,u=r.height;return i(t)?(t.x=o,t.y=a,t.z=u,t):new e(o,a,u)},u.prototype.unproject=function(e,t){if(!i(e))throw new o("cartesian is required");var n=this._oneOverSemimajorAxis,a=e.x*n,u=e.y*n,s=e.z;return i(t)?(t.longitude=a,t.latitude=u,t.height=s,t):new r(a,u,s)},u}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var r={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(r)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var r=function(r,t){this.start=e(r,0),this.stop=e(t,0)};return r}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n){"use strict";var o=function(r,t,i,n){this.x=e(r,0),this.y=e(t,0),this.z=e(i,0),this.w=e(n,0)};o.fromElements=function(e,t,i,n,a){return r(a)?(a.x=e,a.y=t,a.z=i,a.w=n,a):new o(e,t,i,n)},o.fromColor=function(e,i){if(!r(e))throw new t("color is required");return r(i)?(i.x=e.red,i.y=e.green,i.z=e.blue,i.w=e.alpha,i):new o(e.red,e.green,e.blue,e.alpha)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new o(e.x,e.y,e.z,e.w):void 0},o.packedLength=4,o.pack=function(i,n,o){if(!r(i))throw new t("value is required");if(!r(n))throw new t("array is required");o=e(o,0),n[o++]=i.x,n[o++]=i.y,n[o++]=i.z,n[o]=i.w},o.unpack=function(i,n,a){if(!r(i))throw new t("array is required");return n=e(n,0),r(a)||(a=new o),a.x=i[n++],a.y=i[n++],a.z=i[n++],a.w=i[n],a},o.fromArray=o.unpack,o.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z,e.w)},o.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z,e.w)},o.minimumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.min(e.x,i.x),n.y=Math.min(e.y,i.y),n.z=Math.min(e.z,i.z),n.w=Math.min(e.w,i.w),n},o.maximumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.max(e.x,i.x),n.y=Math.max(e.y,i.y),n.z=Math.max(e.z,i.z),n.w=Math.max(e.w,i.w),n},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,i){if(!r(e)||!r(i))throw new t("left and right are required.");return o.subtract(e,i,a),o.magnitude(a)},o.distanceSquared=function(e,i){if(!r(e)||!r(i))throw new t("left and right are required.");return o.subtract(e,i,a),o.magnitudeSquared(a)},o.normalize=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");var n=o.magnitude(e);return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i.w=e.w/n,i},o.dot=function(e,i){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");return e.x*i.x+e.y*i.y+e.z*i.z+e.w*i.w},o.multiplyComponents=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x*i.x,n.y=e.y*i.y,n.z=e.z*i.z,n.w=e.w*i.w,n},o.add=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x+i.x,n.y=e.y+i.y,n.z=e.z+i.z,n.w=e.w+i.w,n},o.subtract=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x-i.x,n.y=e.y-i.y,n.z=e.z-i.z,n.w=e.w-i.w,n},o.multiplyByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x*i,n.y=e.y*i,n.z=e.z*i,n.w=e.w*i,n},o.divideByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n.w=e.w/i,n},o.negate=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=-e.x,i.y=-e.y,i.z=-e.z,i.w=-e.w,i},o.abs=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=Math.abs(e.x),i.y=Math.abs(e.y),i.z=Math.abs(e.z),i.w=Math.abs(e.w),i};var u=new o;o.lerp=function(e,i,n,a){if(!r(e))throw new t("start is required.");if(!r(i))throw new t("end is required.");if("number"!=typeof n)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(i,n,u),a=o.multiplyByScalar(e,1-n,a),o.add(u,a,a)};var s=new o;return o.mostOrthogonalAxis=function(e,i){if(!r(e))throw new t("cartesian is required.");if(!r(i))throw new t("result is required.");var n=o.normalize(e,s);return o.abs(n,n),i=n.x<=n.y?n.x<=n.z?n.x<=n.w?o.clone(o.UNIT_X,i):o.clone(o.UNIT_W,i):n.z<=n.w?o.clone(o.UNIT_Z,i):o.clone(o.UNIT_W,i):n.y<=n.z?n.y<=n.w?o.clone(o.UNIT_Y,i):o.clone(o.UNIT_W,i):n.z<=n.w?o.clone(o.UNIT_Z,i):o.clone(o.UNIT_W,i)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},o.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]&&e.z===r[t+2]&&e.w===r[t+3]},o.equalsEpsilon=function(e,t,i,o){return e===t||r(e)&&r(t)&&n.equalsEpsilon(e.x,t.x,i,o)&&n.equalsEpsilon(e.y,t.y,i,o)&&n.equalsEpsilon(e.z,t.z,i,o)&&n.equalsEpsilon(e.w,t.w,i,o)},o.ZERO=i(new o(0,0,0,0)),o.UNIT_X=i(new o(1,0,0,0)),o.UNIT_Y=i(new o(0,1,0,0)),o.UNIT_Z=i(new o(0,0,1,0)),o.UNIT_W=i(new o(0,0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r,t){return o.equalsEpsilon(this,e,r,t)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},o}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n,o){"use strict";function a(e){for(var r=0,t=0;9>t;++t){var i=e[t];r+=i*i}return Math.sqrt(r)}function u(e){for(var r=0,t=0;3>t;++t){var i=e[l.getElementIndex(w[t],h[t])];r+=2*i*i}return Math.sqrt(r)}function s(e,r){for(var t=o.EPSILON15,i=0,n=1,a=0;3>a;++a){var u=Math.abs(e[l.getElementIndex(w[a],h[a])]);u>i&&(n=a,i=u)}var s=1,c=0,f=h[n],d=w[n];if(Math.abs(e[l.getElementIndex(d,f)])>t){var m,E=e[l.getElementIndex(d,d)],p=e[l.getElementIndex(f,f)],y=e[l.getElementIndex(d,f)],_=(E-p)/2/y;m=0>_?-1/(-_+Math.sqrt(1+_*_)):1/(_+Math.sqrt(1+_*_)),s=1/Math.sqrt(1+m*m),c=m*s}return r=l.clone(l.IDENTITY,r),r[l.getElementIndex(f,f)]=r[l.getElementIndex(d,d)]=s,r[l.getElementIndex(d,f)]=c,r[l.getElementIndex(f,d)]=-c,r}var l=function(e,t,i,n,o,a,u,s,l){this[0]=r(e,0),this[1]=r(n,0),this[2]=r(u,0),this[3]=r(t,0),this[4]=r(o,0),this[5]=r(s,0),this[6]=r(i,0),this[7]=r(a,0),this[8]=r(l,0)};l.packedLength=9,l.pack=function(e,n,o){if(!t(e))throw new i("value is required");if(!t(n))throw new i("array is required");o=r(o,0),n[o++]=e[0],n[o++]=e[1],n[o++]=e[2],n[o++]=e[3],n[o++]=e[4],n[o++]=e[5],n[o++]=e[6],n[o++]=e[7],n[o++]=e[8]},l.unpack=function(e,n,o){if(!t(e))throw new i("array is required");return n=r(n,0),t(o)||(o=new l),o[0]=e[n++],o[1]=e[n++],o[2]=e[n++],o[3]=e[n++],o[4]=e[n++],o[5]=e[n++],o[6]=e[n++],o[7]=e[n++],o[8]=e[n++],o},l.clone=function(e,r){return t(e)?t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):new l(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},l.fromArray=function(e,n,o){if(!t(e))throw new i("array is required");return n=r(n,0),t(o)||(o=new l),o[0]=e[n],o[1]=e[n+1],o[2]=e[n+2],o[3]=e[n+3],o[4]=e[n+4],o[5]=e[n+5],o[6]=e[n+6],o[7]=e[n+7],o[8]=e[n+8],o},l.fromColumnMajorArray=function(e,r){if(!t(e))throw new i("values parameter is required");return l.clone(e,r)},l.fromRowMajorArray=function(e,r){if(!t(e))throw new i("values is required.");return t(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},l.fromQuaternion=function(e,r){if(!t(e))throw new i("quaternion is required");var n=e.x*e.x,o=e.x*e.y,a=e.x*e.z,u=e.x*e.w,s=e.y*e.y,c=e.y*e.z,f=e.y*e.w,h=e.z*e.z,w=e.z*e.w,d=e.w*e.w,m=n-s-h+d,E=2*(o-w),p=2*(a+f),y=2*(o+w),_=-n+s-h+d,T=2*(c-u),R=2*(a-f),A=2*(c+u),v=-n-s+h+d;return t(r)?(r[0]=m,r[1]=y,r[2]=R,r[3]=E,r[4]=_,r[5]=A,r[6]=p,r[7]=T,r[8]=v,r):new l(m,E,p,y,_,T,R,A,v)},l.fromScale=function(e,r){if(!t(e))throw new i("scale is required.");return t(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new l(e.x,0,0,0,e.y,0,0,0,e.z)},l.fromUniformScale=function(e,r){if("number"!=typeof e)throw new i("scale is required.");return t(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new l(e,0,0,0,e,0,0,0,e)},l.fromCrossProduct=function(e,r){if(!t(e))throw new i("vector is required.");return t(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new l(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},l.fromRotationX=function(e,r){if(!t(e))throw new i("angle is required.");var n=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=n,r[5]=o,r[6]=0,r[7]=-o,r[8]=n,r):new l(1,0,0,0,n,-o,0,o,n)},l.fromRotationY=function(e,r){if(!t(e))throw new i("angle is required.");var n=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=n,r[1]=0,r[2]=-o,r[3]=0,r[4]=1,r[5]=0,r[6]=o,r[7]=0,r[8]=n,r):new l(n,0,o,0,1,0,-o,0,n)},l.fromRotationZ=function(e,r){if(!t(e))throw new i("angle is required.");var n=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=n,r[1]=o,r[2]=0,r[3]=-o,r[4]=n,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new l(n,-o,0,o,n,0,0,0,1)},l.toArray=function(e,r){if(!t(e))throw new i("matrix is required");return t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},l.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>2)throw new i("row must be 0, 1, or 2.");if("number"!=typeof e||0>e||e>2)throw new i("column must be 0, 1, or 2.");return 3*e+r},l.getColumn=function(e,r,n){if(!t(e))throw new i("matrix is required.");if("number"!=typeof r||0>r||r>2)throw new i("index must be 0, 1, or 2.");if(!t(n))throw new i("result is required");var o=3*r,a=e[o],u=e[o+1],s=e[o+2];return n.x=a,n.y=u,n.z=s,n},l.setColumn=function(e,r,n,o){if(!t(e))throw new i("matrix is required");if(!t(n))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new i("index must be 0, 1, or 2.");if(!t(o))throw new i("result is required");o=l.clone(e,o);var a=3*r;return o[a]=n.x,o[a+1]=n.y,o[a+2]=n.z,o},l.getRow=function(e,r,n){if(!t(e))throw new i("matrix is required.");if("number"!=typeof r||0>r||r>2)throw new i("index must be 0, 1, or 2.");if(!t(n))throw new i("result is required");var o=e[r],a=e[r+3],u=e[r+6];
return n.x=o,n.y=a,n.z=u,n},l.setRow=function(e,r,n,o){if(!t(e))throw new i("matrix is required");if(!t(n))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new i("index must be 0, 1, or 2.");if(!t(o))throw new i("result is required");return o=l.clone(e,o),o[r]=n.x,o[r+3]=n.y,o[r+6]=n.z,o};var c=new e;l.getScale=function(r,n){if(!t(r))throw new i("matrix is required.");if(!t(n))throw new i("result is required");return n.x=e.magnitude(e.fromElements(r[0],r[1],r[2],c)),n.y=e.magnitude(e.fromElements(r[3],r[4],r[5],c)),n.z=e.magnitude(e.fromElements(r[6],r[7],r[8],c)),n};var f=new e;l.getMaximumScale=function(r){return l.getScale(r,f),e.maximumComponent(f)},l.multiply=function(e,r,n){if(!t(e))throw new i("left is required");if(!t(r))throw new i("right is required");if(!t(n))throw new i("result is required");var o=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],a=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],u=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],s=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],l=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],c=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],f=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],h=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],w=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return n[0]=o,n[1]=a,n[2]=u,n[3]=s,n[4]=l,n[5]=c,n[6]=f,n[7]=h,n[8]=w,n},l.add=function(e,r,n){if(!t(e))throw new i("left is required");if(!t(r))throw new i("right is required");if(!t(n))throw new i("result is required");return n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n[4]=e[4]+r[4],n[5]=e[5]+r[5],n[6]=e[6]+r[6],n[7]=e[7]+r[7],n[8]=e[8]+r[8],n},l.subtract=function(e,r,n){if(!t(e))throw new i("left is required");if(!t(r))throw new i("right is required");if(!t(n))throw new i("result is required");return n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n[4]=e[4]-r[4],n[5]=e[5]-r[5],n[6]=e[6]-r[6],n[7]=e[7]-r[7],n[8]=e[8]-r[8],n},l.multiplyByVector=function(e,r,n){if(!t(e))throw new i("matrix is required");if(!t(r))throw new i("cartesian is required");if(!t(n))throw new i("result is required");var o=r.x,a=r.y,u=r.z,s=e[0]*o+e[3]*a+e[6]*u,l=e[1]*o+e[4]*a+e[7]*u,c=e[2]*o+e[5]*a+e[8]*u;return n.x=s,n.y=l,n.z=c,n},l.multiplyByScalar=function(e,r,n){if(!t(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scalar must be a number");if(!t(n))throw new i("result is required");return n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*r,n[7]=e[7]*r,n[8]=e[8]*r,n},l.multiplyByScale=function(e,r,n){if(!t(e))throw new i("matrix is required");if(!t(r))throw new i("scale is required");if(!t(n))throw new i("result is required");return n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.x,n[3]=e[3]*r.y,n[4]=e[4]*r.y,n[5]=e[5]*r.y,n[6]=e[6]*r.z,n[7]=e[7]*r.z,n[8]=e[8]*r.z,n},l.negate=function(e,r){if(!t(e))throw new i("matrix is required");if(!t(r))throw new i("result is required");return r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},l.transpose=function(e,r){if(!t(e))throw new i("matrix is required");if(!t(r))throw new i("result is required");var n=e[0],o=e[3],a=e[6],u=e[1],s=e[4],l=e[7],c=e[2],f=e[5],h=e[8];return r[0]=n,r[1]=o,r[2]=a,r[3]=u,r[4]=s,r[5]=l,r[6]=c,r[7]=f,r[8]=h,r};var h=[1,0,0],w=[2,2,1],d=new l,m=new l;return l.computeEigenDecomposition=function(e,r){if(!t(e))throw new i("matrix is required.");var n=o.EPSILON20,c=10,f=0,h=0;t(r)||(r={});for(var w=r.unitary=l.clone(l.IDENTITY,r.unitary),E=r.diagonal=l.clone(e,r.diagonal),p=n*a(E);c>h&&u(E)>p;)s(E,d),l.transpose(d,m),l.multiply(E,d,E),l.multiply(m,E,E),l.multiply(w,d,w),++f>2&&(++h,f=0);return r},l.abs=function(e,r){if(!t(e))throw new i("matrix is required");if(!t(r))throw new i("result is required");return r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},l.determinant=function(e){if(!t(e))throw new i("matrix is required");var r=e[0],n=e[3],o=e[6],a=e[1],u=e[4],s=e[7],l=e[2],c=e[5],f=e[8];return r*(u*f-c*s)+a*(c*o-n*f)+l*(n*s-u*o)},l.inverse=function(e,r){if(!t(e))throw new i("matrix is required");if(!t(r))throw new i("result is required");var n=e[0],a=e[1],u=e[2],s=e[3],c=e[4],f=e[5],h=e[6],w=e[7],d=e[8],m=l.determinant(e);if(Math.abs(m)<=o.EPSILON15)throw new i("matrix is not invertible");r[0]=c*d-w*f,r[1]=w*u-a*d,r[2]=a*f-c*u,r[3]=h*f-s*d,r[4]=n*d-h*u,r[5]=s*u-n*f,r[6]=s*w-h*c,r[7]=h*a-n*w,r[8]=n*c-s*a;var E=1/m;return l.multiplyByScalar(r,E,r)},l.equals=function(e,r){return e===r||t(e)&&t(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]},l.equalsEpsilon=function(e,r,n){if("number"!=typeof n)throw new i("epsilon must be a number");return e===r||t(e)&&t(r)&&Math.abs(e[0]-r[0])<=n&&Math.abs(e[1]-r[1])<=n&&Math.abs(e[2]-r[2])<=n&&Math.abs(e[3]-r[3])<=n&&Math.abs(e[4]-r[4])<=n&&Math.abs(e[5]-r[5])<=n&&Math.abs(e[6]-r[6])<=n&&Math.abs(e[7]-r[7])<=n&&Math.abs(e[8]-r[8])<=n},l.IDENTITY=n(new l(1,0,0,0,1,0,0,0,1)),l.ZERO=n(new l(0,0,0,0,0,0,0,0,0)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN1ROW0=3,l.COLUMN1ROW1=4,l.COLUMN1ROW2=5,l.COLUMN2ROW0=6,l.COLUMN2ROW1=7,l.COLUMN2ROW2=8,l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.equalsArray=function(e,r,t){return e[0]===r[t]&&e[1]===r[t+1]&&e[2]===r[t+2]&&e[3]===r[t+3]&&e[4]===r[t+4]&&e[5]===r[t+5]&&e[6]===r[t+6]&&e[7]===r[t+7]&&e[8]===r[t+8]},l.prototype.equalsEpsilon=function(e,r){return l.equalsEpsilon(this,e,r)},l.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},l}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var r=function(e){this.name="RuntimeError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,r,t,i,n,o,a,u,s){"use strict";var l=function(e,r,i,n,o,a,u,s,l,c,f,h,w,d,m,E){this[0]=t(e,0),this[1]=t(o,0),this[2]=t(l,0),this[3]=t(w,0),this[4]=t(r,0),this[5]=t(a,0),this[6]=t(c,0),this[7]=t(d,0),this[8]=t(i,0),this[9]=t(u,0),this[10]=t(f,0),this[11]=t(m,0),this[12]=t(n,0),this[13]=t(s,0),this[14]=t(h,0),this[15]=t(E,0)};l.packedLength=16,l.pack=function(e,r,o){if(!i(e))throw new n("value is required");if(!i(r))throw new n("array is required");o=t(o,0),r[o++]=e[0],r[o++]=e[1],r[o++]=e[2],r[o++]=e[3],r[o++]=e[4],r[o++]=e[5],r[o++]=e[6],r[o++]=e[7],r[o++]=e[8],r[o++]=e[9],r[o++]=e[10],r[o++]=e[11],r[o++]=e[12],r[o++]=e[13],r[o++]=e[14],r[o]=e[15]},l.unpack=function(e,r,o){if(!i(e))throw new n("array is required");return r=t(r,0),i(o)||(o=new l),o[0]=e[r++],o[1]=e[r++],o[2]=e[r++],o[3]=e[r++],o[4]=e[r++],o[5]=e[r++],o[6]=e[r++],o[7]=e[r++],o[8]=e[r++],o[9]=e[r++],o[10]=e[r++],o[11]=e[r++],o[12]=e[r++],o[13]=e[r++],o[14]=e[r++],o[15]=e[r],o},l.clone=function(e,r){return i(e)?i(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):new l(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},l.fromArray=l.unpack,l.fromColumnMajorArray=function(e,r){if(!i(e))throw new n("values is required");return l.clone(e,r)},l.fromRowMajorArray=function(e,r){if(!i(e))throw new n("values is required.");return i(r)?(r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=e[1],r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=e[2],r[9]=e[6],r[10]=e[10],r[11]=e[14],r[12]=e[3],r[13]=e[7],r[14]=e[11],r[15]=e[15],r):new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},l.fromRotationTranslation=function(r,o,a){if(!i(r))throw new n("rotation is required.");return o=t(o,e.ZERO),i(a)?(a[0]=r[0],a[1]=r[1],a[2]=r[2],a[3]=0,a[4]=r[3],a[5]=r[4],a[6]=r[5],a[7]=0,a[8]=r[6],a[9]=r[7],a[10]=r[8],a[11]=0,a[12]=o.x,a[13]=o.y,a[14]=o.z,a[15]=1,a):new l(r[0],r[3],r[6],o.x,r[1],r[4],r[7],o.y,r[2],r[5],r[8],o.z,0,0,0,1)},l.fromTranslationQuaternionRotationScale=function(e,r,t,o){if(!i(e))throw new n("translation is required.");if(!i(r))throw new n("rotation is required.");if(!i(t))throw new n("scale is required.");i(o)||(o=new l);var a=t.x,u=t.y,s=t.z,c=r.x*r.x,f=r.x*r.y,h=r.x*r.z,w=r.x*r.w,d=r.y*r.y,m=r.y*r.z,E=r.y*r.w,p=r.z*r.z,y=r.z*r.w,_=r.w*r.w,T=c-d-p+_,R=2*(f-y),A=2*(h+E),v=2*(f+y),N=-c+d-p+_,I=2*(m-w),S=2*(h-E),g=2*(m+w),M=-c-d+p+_;return o[0]=T*a,o[1]=v*a,o[2]=S*a,o[3]=0,o[4]=R*u,o[5]=N*u,o[6]=g*u,o[7]=0,o[8]=A*s,o[9]=I*s,o[10]=M*s,o[11]=0,o[12]=e.x,o[13]=e.y,o[14]=e.z,o[15]=1,o},l.fromTranslation=function(e,r){if(!i(e))throw new n("translation is required.");return l.fromRotationTranslation(u.IDENTITY,e,r)},l.fromScale=function(e,r){if(!i(e))throw new n("scale is required.");return i(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e.y,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e.z,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new l(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},l.fromUniformScale=function(e,r){if("number"!=typeof e)throw new n("scale is required.");return i(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new l(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var c=new e,f=new e,h=new e;l.fromCamera=function(r,t){if(!i(r))throw new n("camera is required.");var o=r.eye,a=r.target,u=r.up;if(!i(o))throw new n("camera.eye is required.");if(!i(a))throw new n("camera.target is required.");if(!i(u))throw new n("camera.up is required.");e.normalize(e.subtract(a,o,c),c),e.normalize(e.cross(c,u,f),f),e.normalize(e.cross(f,c,h),h);var s=f.x,w=f.y,d=f.z,m=c.x,E=c.y,p=c.z,y=h.x,_=h.y,T=h.z,R=o.x,A=o.y,v=o.z,N=s*-R+w*-A+d*-v,I=y*-R+_*-A+T*-v,S=m*R+E*A+p*v;return i(t)?(t[0]=s,t[1]=y,t[2]=-m,t[3]=0,t[4]=w,t[5]=_,t[6]=-E,t[7]=0,t[8]=d,t[9]=T,t[10]=-p,t[11]=0,t[12]=N,t[13]=I,t[14]=S,t[15]=1,t):new l(s,w,d,N,y,_,T,I,-m,-E,-p,S,0,0,0,1)},l.computePerspectiveFieldOfView=function(e,r,t,o,a){if(0>=e||e>Math.PI)throw new n("fovY must be in [0, PI).");if(0>=r)throw new n("aspectRatio must be greater than zero.");if(0>=t)throw new n("near must be greater than zero.");if(0>=o)throw new n("far must be greater than zero.");if(!i(a))throw new n("result is required");var u=Math.tan(.5*e),s=1/u,l=s/r,c=(o+t)/(t-o),f=2*o*t/(t-o);return a[0]=l,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=s,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=c,a[11]=-1,a[12]=0,a[13]=0,a[14]=f,a[15]=0,a},l.computeOrthographicOffCenter=function(e,r,t,o,a,u,s){if(!i(e))throw new n("left is required.");if(!i(r))throw new n("right is required.");if(!i(t))throw new n("bottom is required.");if(!i(o))throw new n("top is required.");if(!i(a))throw new n("near is required.");if(!i(u))throw new n("far is required.");if(!i(s))throw new n("result is required");var l=1/(r-e),c=1/(o-t),f=1/(u-a),h=-(r+e)*l,w=-(o+t)*c,d=-(u+a)*f;return l*=2,c*=2,f*=-2,s[0]=l,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=c,s[6]=0,s[7]=0,s[8]=0,s[9]=0,s[10]=f,s[11]=0,s[12]=h,s[13]=w,s[14]=d,s[15]=1,s},l.computePerspectiveOffCenter=function(e,r,t,o,a,u,s){if(!i(e))throw new n("left is required.");if(!i(r))throw new n("right is required.");if(!i(t))throw new n("bottom is required.");if(!i(o))throw new n("top is required.");if(!i(a))throw new n("near is required.");if(!i(u))throw new n("far is required.");if(!i(s))throw new n("result is required");var l=2*a/(r-e),c=2*a/(o-t),f=(r+e)/(r-e),h=(o+t)/(o-t),w=-(u+a)/(u-a),d=-1,m=-2*u*a/(u-a);return s[0]=l,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=c,s[6]=0,s[7]=0,s[8]=f,s[9]=h,s[10]=w,s[11]=d,s[12]=0,s[13]=0,s[14]=m,s[15]=0,s},l.computeInfinitePerspectiveOffCenter=function(e,r,t,o,a,u){if(!i(e))throw new n("left is required.");if(!i(r))throw new n("right is required.");if(!i(t))throw new n("bottom is required.");if(!i(o))throw new n("top is required.");if(!i(a))throw new n("near is required.");if(!i(u))throw new n("result is required");var s=2*a/(r-e),l=2*a/(o-t),c=(r+e)/(r-e),f=(o+t)/(o-t),h=-1,w=-1,d=-2*a;return u[0]=s,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=l,u[6]=0,u[7]=0,u[8]=c,u[9]=f,u[10]=h,u[11]=w,u[12]=0,u[13]=0,u[14]=d,u[15]=0,u},l.computeViewportTransformation=function(e,r,o,a){if(!i(a))throw new n("result is required");e=t(e,t.EMPTY_OBJECT);var u=t(e.x,0),s=t(e.y,0),l=t(e.width,0),c=t(e.height,0);r=t(r,0),o=t(o,1);var f=.5*l,h=.5*c,w=.5*(o-r),d=f,m=h,E=w,p=u+f,y=s+h,_=r+w,T=1;return a[0]=d,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=m,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=E,a[11]=0,a[12]=p,a[13]=y,a[14]=_,a[15]=T,a},l.toArray=function(e,r){if(!i(e))throw new n("matrix is required");return i(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},l.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>3)throw new n("row must be 0, 1, 2, or 3.");if("number"!=typeof e||0>e||e>3)throw new n("column must be 0, 1, 2, or 3.");return 4*e+r},l.getColumn=function(e,r,t){if(!i(e))throw new n("matrix is required.");if("number"!=typeof r||0>r||r>3)throw new n("index must be 0, 1, 2, or 3.");if(!i(t))throw new n("result is required");var o=4*r,a=e[o],u=e[o+1],s=e[o+2],l=e[o+3];return t.x=a,t.y=u,t.z=s,t.w=l,t},l.setColumn=function(e,r,t,o){if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new n("index must be 0, 1, 2, or 3.");if(!i(o))throw new n("result is required");o=l.clone(e,o);var a=4*r;return o[a]=t.x,o[a+1]=t.y,o[a+2]=t.z,o[a+3]=t.w,o},l.setTranslation=function(e,r,t){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("translation is required");if(!i(t))throw new n("result is required");return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=r.x,t[13]=r.y,t[14]=r.z,t[15]=e[15],t},l.getRow=function(e,r,t){if(!i(e))throw new n("matrix is required.");if("number"!=typeof r||0>r||r>3)throw new n("index must be 0, 1, 2, or 3.");if(!i(t))throw new n("result is required");var o=e[r],a=e[r+4],u=e[r+8],s=e[r+12];return t.x=o,t.y=a,t.z=u,t.w=s,t},l.setRow=function(e,r,t,o){if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new n("index must be 0, 1, 2, or 3.");if(!i(o))throw new n("result is required");return o=l.clone(e,o),o[r]=t.x,o[r+4]=t.y,o[r+8]=t.z,o[r+12]=t.w,o};var w=new e;l.getScale=function(r,t){if(!i(r))throw new n("matrix is required.");if(!i(t))throw new n("result is required");return t.x=e.magnitude(e.fromElements(r[0],r[1],r[2],w)),t.y=e.magnitude(e.fromElements(r[4],r[5],r[6],w)),t.z=e.magnitude(e.fromElements(r[8],r[9],r[10],w)),t};var d=new e;l.getMaximumScale=function(r){return l.getScale(r,d),e.maximumComponent(d)},l.multiply=function(e,r,t){if(!i(e))throw new n("left is required");if(!i(r))throw new n("right is required");if(!i(t))throw new n("result is required");var o=e[0],a=e[1],u=e[2],s=e[3],l=e[4],c=e[5],f=e[6],h=e[7],w=e[8],d=e[9],m=e[10],E=e[11],p=e[12],y=e[13],_=e[14],T=e[15],R=r[0],A=r[1],v=r[2],N=r[3],I=r[4],S=r[5],g=r[6],M=r[7],O=r[8],q=r[9],x=r[10],b=r[11],P=r[12],L=r[13],C=r[14],F=r[15],U=o*R+l*A+w*v+p*N,D=a*R+c*A+d*v+y*N,B=u*R+f*A+m*v+_*N,z=s*R+h*A+E*v+T*N,G=o*I+l*S+w*g+p*M,V=a*I+c*S+d*g+y*M,H=u*I+f*S+m*g+_*M,X=s*I+h*S+E*g+T*M,W=o*O+l*q+w*x+p*b,Y=a*O+c*q+d*x+y*b,k=u*O+f*q+m*x+_*b,K=s*O+h*q+E*x+T*b,j=o*P+l*L+w*C+p*F,Z=a*P+c*L+d*C+y*F,Q=u*P+f*L+m*C+_*F,J=s*P+h*L+E*C+T*F;return t[0]=U,t[1]=D,t[2]=B,t[3]=z,t[4]=G,t[5]=V,t[6]=H,t[7]=X,t[8]=W,t[9]=Y,t[10]=k,t[11]=K,t[12]=j,t[13]=Z,t[14]=Q,t[15]=J,t},l.add=function(e,r,t){if(!i(e))throw new n("left is required");if(!i(r))throw new n("right is required");if(!i(t))throw new n("result is required");return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t[6]=e[6]+r[6],t[7]=e[7]+r[7],t[8]=e[8]+r[8],t[9]=e[9]+r[9],t[10]=e[10]+r[10],t[11]=e[11]+r[11],t[12]=e[12]+r[12],t[13]=e[13]+r[13],t[14]=e[14]+r[14],t[15]=e[15]+r[15],t},l.subtract=function(e,r,t){if(!i(e))throw new n("left is required");if(!i(r))throw new n("right is required");if(!i(t))throw new n("result is required");return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t[4]=e[4]-r[4],t[5]=e[5]-r[5],t[6]=e[6]-r[6],t[7]=e[7]-r[7],t[8]=e[8]-r[8],t[9]=e[9]-r[9],t[10]=e[10]-r[10],t[11]=e[11]-r[11],t[12]=e[12]-r[12],t[13]=e[13]-r[13],t[14]=e[14]-r[14],t[15]=e[15]-r[15],t},l.multiplyTransformation=function(e,r,t){if(!i(e))throw new n("left is required");if(!i(r))throw new n("right is required");if(!i(t))throw new n("result is required");var o=e[0],a=e[1],u=e[2],s=e[4],l=e[5],c=e[6],f=e[8],h=e[9],w=e[10],d=e[12],m=e[13],E=e[14],p=r[0],y=r[1],_=r[2],T=r[4],R=r[5],A=r[6],v=r[8],N=r[9],I=r[10],S=r[12],g=r[13],M=r[14],O=o*p+s*y+f*_,q=a*p+l*y+h*_,x=u*p+c*y+w*_,b=o*T+s*R+f*A,P=a*T+l*R+h*A,L=u*T+c*R+w*A,C=o*v+s*N+f*I,F=a*v+l*N+h*I,U=u*v+c*N+w*I,D=o*S+s*g+f*M+d,B=a*S+l*g+h*M+m,z=u*S+c*g+w*M+E;return t[0]=O,t[1]=q,t[2]=x,t[3]=0,t[4]=b,t[5]=P,t[6]=L,t[7]=0,t[8]=C,t[9]=F,t[10]=U,t[11]=0,t[12]=D,t[13]=B,t[14]=z,t[15]=1,t},l.multiplyByMatrix3=function(e,r,t){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("rotation is required");if(!i(t))throw new n("result is required");var o=e[0],a=e[1],u=e[2],s=e[4],l=e[5],c=e[6],f=e[8],h=e[9],w=e[10],d=r[0],m=r[1],E=r[2],p=r[3],y=r[4],_=r[5],T=r[6],R=r[7],A=r[8],v=o*d+s*m+f*E,N=a*d+l*m+h*E,I=u*d+c*m+w*E,S=o*p+s*y+f*_,g=a*p+l*y+h*_,M=u*p+c*y+w*_,O=o*T+s*R+f*A,q=a*T+l*R+h*A,x=u*T+c*R+w*A;return t[0]=v,t[1]=N,t[2]=I,t[3]=0,t[4]=S,t[5]=g,t[6]=M,t[7]=0,t[8]=O,t[9]=q,t[10]=x,t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},l.multiplyByTranslation=function(e,r,t){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("translation is required");if(!i(t))throw new n("result is required");var o=r.x,a=r.y,u=r.z,s=o*e[0]+a*e[4]+u*e[8]+e[12],l=o*e[1]+a*e[5]+u*e[9]+e[13],c=o*e[2]+a*e[6]+u*e[10]+e[14];return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=s,t[13]=l,t[14]=c,t[15]=e[15],t};var m=new e;l.multiplyByUniformScale=function(e,r,t){if(!i(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scale is required");if(!i(t))throw new n("result is required");return m.x=r,m.y=r,m.z=r,l.multiplyByScale(e,m,t)},l.multiplyByScale=function(e,r,t){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("scale is required");if(!i(t))throw new n("result is required");var o=r.x,a=r.y,u=r.z;return 1===o&&1===a&&1===u?l.clone(e,t):(t[0]=o*e[0],t[1]=o*e[1],t[2]=o*e[2],t[3]=0,t[4]=a*e[4],t[5]=a*e[5],t[6]=a*e[6],t[7]=0,t[8]=u*e[8],t[9]=u*e[9],t[10]=u*e[10],t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=1,t)},l.multiplyByVector=function(e,r,t){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("cartesian is required");if(!i(t))throw new n("result is required");var o=r.x,a=r.y,u=r.z,s=r.w,l=e[0]*o+e[4]*a+e[8]*u+e[12]*s,c=e[1]*o+e[5]*a+e[9]*u+e[13]*s,f=e[2]*o+e[6]*a+e[10]*u+e[14]*s,h=e[3]*o+e[7]*a+e[11]*u+e[15]*s;return t.x=l,t.y=c,t.z=f,t.w=h,t},l.multiplyByPointAsVector=function(e,r,t){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("cartesian is required");if(!i(t))throw new n("result is required");var o=r.x,a=r.y,u=r.z,s=e[0]*o+e[4]*a+e[8]*u,l=e[1]*o+e[5]*a+e[9]*u,c=e[2]*o+e[6]*a+e[10]*u;return t.x=s,t.y=l,t.z=c,t},l.multiplyByPoint=function(e,r,t){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("cartesian is required");if(!i(t))throw new n("result is required");var o=r.x,a=r.y,u=r.z,s=e[0]*o+e[4]*a+e[8]*u+e[12],l=e[1]*o+e[5]*a+e[9]*u+e[13],c=e[2]*o+e[6]*a+e[10]*u+e[14];return t.x=s,t.y=l,t.z=c,t},l.multiplyByScalar=function(e,r,t){if(!i(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scalar must be a number");if(!i(t))throw new n("result is required");return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t},l.negate=function(e,r){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("result is required");return r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r[9]=-e[9],r[10]=-e[10],r[11]=-e[11],r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=-e[15],r},l.transpose=function(e,r){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("result is required");var t=e[1],o=e[2],a=e[3],u=e[6],s=e[7],l=e[11];return r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=t,r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=o,r[9]=u,r[10]=e[10],r[11]=e[14],r[12]=a,r[13]=s,r[14]=l,r[15]=e[15],r},l.abs=function(e,r){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("result is required");return r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r[9]=Math.abs(e[9]),r[10]=Math.abs(e[10]),r[11]=Math.abs(e[11]),r[12]=Math.abs(e[12]),r[13]=Math.abs(e[13]),r[14]=Math.abs(e[14]),r[15]=Math.abs(e[15]),r},l.equals=function(e,r){return e===r||i(e)&&i(r)&&e[12]===r[12]&&e[13]===r[13]&&e[14]===r[14]&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[8]===r[8]&&e[9]===r[9]&&e[10]===r[10]&&e[3]===r[3]&&e[7]===r[7]&&e[11]===r[11]&&e[15]===r[15]},l.equalsEpsilon=function(e,r,t){if("number"!=typeof t)throw new n("epsilon must be a number");return e===r||i(e)&&i(r)&&Math.abs(e[0]-r[0])<=t&&Math.abs(e[1]-r[1])<=t&&Math.abs(e[2]-r[2])<=t&&Math.abs(e[3]-r[3])<=t&&Math.abs(e[4]-r[4])<=t&&Math.abs(e[5]-r[5])<=t&&Math.abs(e[6]-r[6])<=t&&Math.abs(e[7]-r[7])<=t&&Math.abs(e[8]-r[8])<=t&&Math.abs(e[9]-r[9])<=t&&Math.abs(e[10]-r[10])<=t&&Math.abs(e[11]-r[11])<=t&&Math.abs(e[12]-r[12])<=t&&Math.abs(e[13]-r[13])<=t&&Math.abs(e[14]-r[14])<=t&&Math.abs(e[15]-r[15])<=t},l.getTranslation=function(e,r){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("result is required");return r.x=e[12],r.y=e[13],r.z=e[14],r},l.getRotation=function(e,r){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("result is required");return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[4],r[4]=e[5],r[5]=e[6],r[6]=e[8],r[7]=e[9],r[8]=e[10],r};var E=new u,p=new u,y=new r,_=new r(0,0,0,1);return l.inverse=function(e,t){if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("result is required");if(u.equalsEpsilon(l.getRotation(e,E),p,a.EPSILON7)&&r.equals(l.getRow(e,3,y),_))return t[0]=0,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=0,t[11]=0,t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=1,t;var o=e[0],c=e[4],f=e[8],h=e[12],w=e[1],d=e[5],m=e[9],T=e[13],R=e[2],A=e[6],v=e[10],N=e[14],I=e[3],S=e[7],g=e[11],M=e[15],O=v*M,q=N*g,x=A*M,b=N*S,P=A*g,L=v*S,C=R*M,F=N*I,U=R*g,D=v*I,B=R*S,z=A*I,G=O*d+b*m+P*T-(q*d+x*m+L*T),V=q*w+C*m+D*T-(O*w+F*m+U*T),H=x*w+F*d+B*T-(b*w+C*d+z*T),X=L*w+U*d+z*m-(P*w+D*d+B*m),W=q*c+x*f+L*h-(O*c+b*f+P*h),Y=O*o+F*f+U*h-(q*o+C*f+D*h),k=b*o+C*c+z*h-(x*o+F*c+B*h),K=P*o+D*c+B*f-(L*o+U*c+z*f);O=f*T,q=h*m,x=c*T,b=h*d,P=c*m,L=f*d,C=o*T,F=h*w,U=o*m,D=f*w,B=o*d,z=c*w;var j=O*S+b*g+P*M-(q*S+x*g+L*M),Z=q*I+C*g+D*M-(O*I+F*g+U*M),Q=x*I+F*S+B*M-(b*I+C*S+z*M),J=L*I+U*S+z*g-(P*I+D*S+B*g),$=x*v+L*N+q*A-(P*N+O*A+b*v),ee=U*N+O*R+F*v-(C*v+D*N+q*R),re=C*A+z*N+b*R-(B*N+x*R+F*A),te=B*v+P*R+D*A-(U*A+z*v+L*R),ie=o*G+c*V+f*H+h*X;if(Math.abs(ie)<a.EPSILON20)throw new s("matrix is not invertible because its determinate is zero.");return ie=1/ie,t[0]=G*ie,t[1]=V*ie,t[2]=H*ie,t[3]=X*ie,t[4]=W*ie,t[5]=Y*ie,t[6]=k*ie,t[7]=K*ie,t[8]=j*ie,t[9]=Z*ie,t[10]=Q*ie,t[11]=J*ie,t[12]=$*ie,t[13]=ee*ie,t[14]=re*ie,t[15]=te*ie,t},l.inverseTransformation=function(e,r){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("result is required");var t=e[0],o=e[1],a=e[2],u=e[4],s=e[5],l=e[6],c=e[8],f=e[9],h=e[10],w=e[12],d=e[13],m=e[14],E=-t*w-o*d-a*m,p=-u*w-s*d-l*m,y=-c*w-f*d-h*m;return r[0]=t,r[1]=u,r[2]=c,r[3]=0,r[4]=o,r[5]=s,r[6]=f,r[7]=0,r[8]=a,r[9]=l,r[10]=h,r[11]=0,r[12]=E,r[13]=p,r[14]=y,r[15]=1,r},l.IDENTITY=o(new l(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),l.ZERO=o(new l(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN0ROW3=3,l.COLUMN1ROW0=4,l.COLUMN1ROW1=5,l.COLUMN1ROW2=6,l.COLUMN1ROW3=7,l.COLUMN2ROW0=8,l.COLUMN2ROW1=9,l.COLUMN2ROW2=10,l.COLUMN2ROW3=11,l.COLUMN3ROW0=12,l.COLUMN3ROW1=13,l.COLUMN3ROW2=14,l.COLUMN3ROW3=15,l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.equalsArray=function(e,r,t){return e[0]===r[t]&&e[1]===r[t+1]&&e[2]===r[t+2]&&e[3]===r[t+3]&&e[4]===r[t+4]&&e[5]===r[t+5]&&e[6]===r[t+6]&&e[7]===r[t+7]&&e[8]===r[t+8]&&e[9]===r[t+9]&&e[10]===r[t+10]&&e[11]===r[t+11]&&e[12]===r[t+12]&&e[13]===r[t+13]&&e[14]===r[t+14]&&e[15]===r[t+15]},l.prototype.equalsEpsilon=function(e,r){return l.equalsEpsilon(this,e,r)},l.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},l}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,r,t,i){"use strict";var n=function(i,n){if(!r(i))throw new t("normal is required.");if(!r(n))throw new t("distance is required.");this.normal=e.clone(i),this.distance=n};n.fromPointNormal=function(i,o,a){if(!r(i))throw new t("point is required.");if(!r(o))throw new t("normal is required.");var u=-e.dot(o,i);return r(a)?(e.clone(o,a.normal),a.distance=u,a):new n(o,u)};var o=new e;return n.fromCartesian4=function(i,a){if(!r(i))throw new t("coefficients is required.");var u=e.fromCartesian4(i,o),s=i.w;return r(a)?(e.clone(u,a.normal),a.distance=s,a):new n(u,s)},n.getPointDistance=function(i,n){if(!r(i))throw new t("plane is required.");if(!r(n))throw new t("point is required.");return e.dot(i.normal,n)+i.distance},n.ORIGIN_XY_PLANE=i(new n(e.UNIT_Z,0)),n.ORIGIN_YZ_PLANE=i(new n(e.UNIT_X,0)),n.ORIGIN_ZX_PLANE=i(new n(e.UNIT_Y,0)),n}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,r,t,i,n,o,a,u){"use strict";var s=function(e,t,i,n){this.west=r(e,0),this.south=r(t,0),this.east=r(i,0),this.north=r(n,0)};i(s.prototype,{width:{get:function(){return s.computeWidth(this)}},height:{get:function(){return s.computeHeight(this)}}}),s.packedLength=4,s.pack=function(e,i,o){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");o=r(o,0),i[o++]=e.west,i[o++]=e.south,i[o++]=e.east,i[o]=e.north},s.unpack=function(e,i,o){if(!t(e))throw new n("array is required");return i=r(i,0),t(o)||(o=new s),o.west=e[i++],o.south=e[i++],o.east=e[i++],o.north=e[i],o},s.computeWidth=function(e){if(!t(e))throw new n("rectangle is required.");var r=e.east,i=e.west;return i>r&&(r+=u.TWO_PI),r-i},s.computeHeight=function(e){if(!t(e))throw new n("rectangle is required.");return e.north-e.south},s.fromDegrees=function(e,i,n,o,a){return e=u.toRadians(r(e,0)),i=u.toRadians(r(i,0)),n=u.toRadians(r(n,0)),o=u.toRadians(r(o,0)),t(a)?(a.west=e,a.south=i,a.east=n,a.north=o,a):new s(e,i,n,o)},s.fromCartographicArray=function(e,r){if(!t(e))throw new n("cartographics is required.");for(var i=Number.MAX_VALUE,o=-Number.MAX_VALUE,a=Number.MAX_VALUE,u=-Number.MAX_VALUE,l=0,c=e.length;c>l;l++){var f=e[l];i=Math.min(i,f.longitude),o=Math.max(o,f.longitude),a=Math.min(a,f.latitude),u=Math.max(u,f.latitude)}return t(r)?(r.west=i,r.south=a,r.east=o,r.north=u,r):new s(i,a,o,u)},s.clone=function(e,r){return t(e)?t(r)?(r.west=e.west,r.south=e.south,r.east=e.east,r.north=e.north,r):new s(e.west,e.south,e.east,e.north):void 0},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.west===r.west&&e.south===r.south&&e.east===r.east&&e.north===r.north},s.prototype.equalsEpsilon=function(e,r){if("number"!=typeof r)throw new n("epsilon is required and must be a number.");return t(e)&&Math.abs(this.west-e.west)<=r&&Math.abs(this.south-e.south)<=r&&Math.abs(this.east-e.east)<=r&&Math.abs(this.north-e.north)<=r},s.validate=function(e){if(!t(e))throw new n("rectangle is required");var r=e.north;if("number"!=typeof r)throw new n("north is required to be a number.");if(r<-u.PI_OVER_TWO||r>u.PI_OVER_TWO)throw new n("north must be in the interval [-Pi/2, Pi/2].");var i=e.south;if("number"!=typeof i)throw new n("south is required to be a number.");if(i<-u.PI_OVER_TWO||i>u.PI_OVER_TWO)throw new n("south must be in the interval [-Pi/2, Pi/2].");var o=e.west;if("number"!=typeof o)throw new n("west is required to be a number.");if(o<-Math.PI||o>Math.PI)throw new n("west must be in the interval [-Pi, Pi].");var a=e.east;if("number"!=typeof a)throw new n("east is required to be a number.");if(a<-Math.PI||a>Math.PI)throw new n("east must be in the interval [-Pi, Pi].")},s.southwest=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.west,i.latitude=r.south,i.height=0,i):new e(r.west,r.south)},s.northwest=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.west,i.latitude=r.north,i.height=0,i):new e(r.west,r.north)},s.northeast=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.east,i.latitude=r.north,i.height=0,i):new e(r.east,r.north)},s.southeast=function(r,i){if(!t(r))throw new n("rectangle is required");return t(i)?(i.longitude=r.east,i.latitude=r.south,i.height=0,i):new e(r.east,r.south)},s.center=function(r,i){if(!t(r))throw new n("rectangle is required");var o=r.east,a=r.west;a>o&&(o+=u.TWO_PI);var s=u.negativePiToPi(.5*(a+o)),l=.5*(r.south+r.north);return t(i)?(i.longitude=s,i.latitude=l,i.height=0,i):new e(s,l)},s.intersection=function(e,r,i){if(!t(e))throw new n("rectangle is required");if(!t(r))throw new n("otherRectangle is required.");var o=e.east,a=e.west,l=r.east,c=r.west;a>o&&l>0?o+=u.TWO_PI:c>l&&o>0&&(l+=u.TWO_PI),a>o&&0>c?c+=u.TWO_PI:c>l&&0>a&&(a+=u.TWO_PI);var f=u.negativePiToPi(Math.max(a,c)),h=u.negativePiToPi(Math.min(o,l));if((e.west<e.east||r.west<r.east)&&f>=h)return void 0;var w=Math.max(e.south,r.south),d=Math.min(e.north,r.north);return w>=d?void 0:t(i)?(i.west=f,i.south=w,i.east=h,i.north=d,i):new s(f,w,h,d)},s.contains=function(e,r){if(!t(e))throw new n("rectangle is required");if(!t(r))throw new n("cartographic is required.");var i=r.longitude,o=r.latitude,a=e.west,s=e.east;return a>s&&(s+=u.TWO_PI,0>i&&(i+=u.TWO_PI)),(i>a||u.equalsEpsilon(i,a,u.EPSILON14))&&(s>i||u.equalsEpsilon(i,s,u.EPSILON14))&&o>=e.south&&o<=e.north};var l=new e;return s.subsample=function(e,i,a,c){if(!t(e))throw new n("rectangle is required");i=r(i,o.WGS84),a=r(a,0),t(c)||(c=[]);var f=0,h=e.north,w=e.south,d=e.east,m=e.west,E=l;E.height=a,E.longitude=m,E.latitude=h,c[f]=i.cartographicToCartesian(E,c[f]),f++,E.longitude=d,c[f]=i.cartographicToCartesian(E,c[f]),f++,E.latitude=w,c[f]=i.cartographicToCartesian(E,c[f]),f++,E.longitude=m,c[f]=i.cartographicToCartesian(E,c[f]),f++,0>h?E.latitude=h:w>0?E.latitude=w:E.latitude=0;for(var p=1;8>p;++p)E.longitude=-Math.PI+p*u.PI_OVER_TWO,s.contains(e,E)&&(c[f]=i.cartographicToCartesian(E,c[f]),f++);return 0===E.latitude&&(E.longitude=m,c[f]=i.cartographicToCartesian(E,c[f]),f++,E.longitude=d,c[f]=i.cartographicToCartesian(E,c[f]),f++),c.length=f,c},s.MAX_VALUE=a(new s(-Math.PI,-u.PI_OVER_TWO,Math.PI,u.PI_OVER_TWO)),s}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Plane","./Rectangle"],function(e,r,t,i,n,o,a,u,s,l,c,f,h){
"use strict";var w=function(r,i){this.center=e.clone(t(r,e.ZERO)),this.radius=t(i,0)},d=new e,m=new e,E=new e,p=new e,y=new e,_=new e,T=new e,R=new e,A=new e,v=new e,N=new e,I=new e;w.fromPoints=function(r,t){if(i(t)||(t=new w),!i(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;for(var n=e.clone(r[0],T),o=e.clone(n,d),a=e.clone(n,m),u=e.clone(n,E),s=e.clone(n,p),l=e.clone(n,y),c=e.clone(n,_),f=r.length,h=1;f>h;h++){e.clone(r[h],n);var S=n.x,g=n.y,M=n.z;S<o.x&&e.clone(n,o),S>s.x&&e.clone(n,s),g<a.y&&e.clone(n,a),g>l.y&&e.clone(n,l),M<u.z&&e.clone(n,u),M>c.z&&e.clone(n,c)}var O=e.magnitudeSquared(e.subtract(s,o,R)),q=e.magnitudeSquared(e.subtract(l,a,R)),x=e.magnitudeSquared(e.subtract(c,u,R)),b=o,P=s,L=O;q>L&&(L=q,b=a,P=l),x>L&&(L=x,b=u,P=c);var C=A;C.x=.5*(b.x+P.x),C.y=.5*(b.y+P.y),C.z=.5*(b.z+P.z);var F=e.magnitudeSquared(e.subtract(P,C,R)),U=Math.sqrt(F),D=v;D.x=o.x,D.y=a.y,D.z=u.z;var B=N;B.x=s.x,B.y=l.y,B.z=c.z;var z=e.multiplyByScalar(e.add(D,B,R),.5,I),G=0;for(h=0;f>h;h++){e.clone(r[h],n);var V=e.magnitude(e.subtract(n,z,R));V>G&&(G=V);var H=e.magnitudeSquared(e.subtract(n,C,R));if(H>F){var X=Math.sqrt(H);U=.5*(U+X),F=U*U;var W=X-U;C.x=(U*C.x+W*n.x)/X,C.y=(U*C.y+W*n.y)/X,C.z=(U*C.z+W*n.z)/X}}return G>U?(e.clone(C,t.center),t.radius=U):(e.clone(z,t.center),t.radius=G),t};var S=new u,g=new e,M=new e,O=new r,q=new r;w.fromRectangle2D=function(e,r,t){return w.fromRectangleWithHeights2D(e,r,0,0,t)},w.fromRectangleWithHeights2D=function(r,n,o,a,u){if(i(u)||(u=new w),!i(r))return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;n=t(n,S),h.southwest(r,O),O.height=o,h.northeast(r,q),q.height=a;var s=n.project(O,g),l=n.project(q,M),c=l.x-s.x,f=l.y-s.y,d=l.z-s.z;u.radius=.5*Math.sqrt(c*c+f*f+d*d);var m=u.center;return m.x=s.x+.5*c,m.y=s.y+.5*f,m.z=s.z+.5*d,u};var x=[];w.fromRectangle3D=function(e,r,n,o){r=t(r,a.WGS84),n=t(n,0);var u;return i(e)&&(u=h.subsample(e,r,n,x)),w.fromPoints(u,o)},w.fromVertices=function(r,n,a,u){if(i(u)||(u=new w),!i(r)||0===r.length)return u.center=e.clone(e.ZERO,u.center),u.radius=0,u;if(n=t(n,e.ZERO),a=t(a,3),3>a)throw new o("stride must be 3 or greater.");var s=T;s.x=r[0]+n.x,s.y=r[1]+n.y,s.z=r[2]+n.z;for(var l=e.clone(s,d),c=e.clone(s,m),f=e.clone(s,E),h=e.clone(s,p),S=e.clone(s,y),g=e.clone(s,_),M=r.length,O=0;M>O;O+=a){var q=r[O]+n.x,x=r[O+1]+n.y,b=r[O+2]+n.z;s.x=q,s.y=x,s.z=b,q<l.x&&e.clone(s,l),q>h.x&&e.clone(s,h),x<c.y&&e.clone(s,c),x>S.y&&e.clone(s,S),b<f.z&&e.clone(s,f),b>g.z&&e.clone(s,g)}var P=e.magnitudeSquared(e.subtract(h,l,R)),L=e.magnitudeSquared(e.subtract(S,c,R)),C=e.magnitudeSquared(e.subtract(g,f,R)),F=l,U=h,D=P;L>D&&(D=L,F=c,U=S),C>D&&(D=C,F=f,U=g);var B=A;B.x=.5*(F.x+U.x),B.y=.5*(F.y+U.y),B.z=.5*(F.z+U.z);var z=e.magnitudeSquared(e.subtract(U,B,R)),G=Math.sqrt(z),V=v;V.x=l.x,V.y=c.y,V.z=f.z;var H=N;H.x=h.x,H.y=S.y,H.z=g.z;var X=e.multiplyByScalar(e.add(V,H,R),.5,I),W=0;for(O=0;M>O;O+=a){s.x=r[O]+n.x,s.y=r[O+1]+n.y,s.z=r[O+2]+n.z;var Y=e.magnitude(e.subtract(s,X,R));Y>W&&(W=Y);var k=e.magnitudeSquared(e.subtract(s,B,R));if(k>z){var K=Math.sqrt(k);G=.5*(G+K),z=G*G;var j=K-G;B.x=(G*B.x+j*s.x)/K,B.y=(G*B.y+j*s.y)/K,B.z=(G*B.z+j*s.z)/K}}return W>G?(e.clone(B,u.center),u.radius=G):(e.clone(X,u.center),u.radius=W),u},w.fromCornerPoints=function(r,t,n){if(!i(r)||!i(t))throw new o("corner and oppositeCorner are required.");i(n)||(n=new w);var a=n.center;return e.add(r,t,a),e.multiplyByScalar(a,.5,a),n.radius=e.distance(a,t),n},w.fromEllipsoid=function(r,t){if(!i(r))throw new o("ellipsoid is required.");return i(t)||(t=new w),e.clone(e.ZERO,t.center),t.radius=r.maximumRadius,t};var b=new e;w.fromBoundingSpheres=function(r,t){if(i(t)||(t=new w),!i(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;var n=r.length;if(1===n)return w.clone(r[0],t);if(2===n)return w.union(r[0],r[1],t);for(var o=[],a=0;n>a;a++)o.push(r[a].center);t=w.fromPoints(o,t);var u=t.center,s=t.radius;for(a=0;n>a;a++){var l=r[a];s=Math.max(s,e.distance(u,l.center,b)+l.radius)}return t.radius=s,t},w.clone=function(r,t){return i(r)?i(t)?(t.center=e.clone(r.center,t.center),t.radius=r.radius,t):new w(r.center,r.radius):void 0},w.packedLength=4,w.pack=function(e,r,n){if(!i(e))throw new o("value is required");if(!i(r))throw new o("array is required");n=t(n,0);var a=e.center;r[n++]=a.x,r[n++]=a.y,r[n++]=a.z,r[n]=e.radius},w.unpack=function(e,r,n){if(!i(e))throw new o("array is required");r=t(r,0),i(n)||(n=new w);var a=n.center;return a.x=e[r++],a.y=e[r++],a.z=e[r++],n.radius=e[r],n};var P=new e,L=new e;w.union=function(r,t,n){if(!i(r))throw new o("left is required.");if(!i(t))throw new o("right is required.");i(n)||(n=new w);var a=r.center,u=r.radius,s=t.center,l=t.radius,c=e.subtract(s,a,P),f=e.magnitude(c);if(u>=f+l)return r.clone(n),n;if(l>=f+u)return t.clone(n),n;var h=.5*(u+f+l),d=e.multiplyByScalar(c,(-u+h)/f,L);return e.add(d,a,d),e.clone(d,n.center),n.radius=h,n};var C=new e;w.expand=function(r,t,n){if(!i(r))throw new o("sphere is required.");if(!i(t))throw new o("point is required.");n=w.clone(r,n);var a=e.magnitude(e.subtract(t,n.center,C));return a>n.radius&&(n.radius=a),n},w.intersectPlane=function(r,t){if(!i(r))throw new o("sphere is required.");if(!i(t))throw new o("plane is required.");var n=r.center,a=r.radius,u=t.normal,l=e.dot(u,n)+t.distance;return-a>l?s.OUTSIDE:a>l?s.INTERSECTING:s.INSIDE},w.transform=function(e,r,t){if(!i(e))throw new o("sphere is required.");if(!i(r))throw new o("transform is required.");return i(t)||(t=new w),t.center=c.multiplyByPoint(r,e.center,t.center),t.radius=c.getMaximumScale(r)*e.radius,t};var F=new e;w.distanceSquaredTo=function(r,t){if(!i(r))throw new o("sphere is required.");if(!i(t))throw new o("cartesian is required.");var n=e.subtract(r.center,t,F);return e.magnitudeSquared(n)-r.radius*r.radius},w.transformWithoutScale=function(e,r,t){if(!i(e))throw new o("sphere is required.");if(!i(r))throw new o("transform is required.");return i(t)||(t=new w),t.center=c.multiplyByPoint(r,e.center,t.center),t.radius=e.radius,t};var U=new e;w.computePlaneDistances=function(r,t,n,a){if(!i(r))throw new o("sphere is required.");if(!i(t))throw new o("position is required.");if(!i(n))throw new o("direction is required.");i(a)||(a=new l);var u=e.subtract(r.center,t,U),s=e.dot(n,u);return a.start=s-r.radius,a.stop=s+r.radius,a};for(var D=new e,B=new e,z=new e,G=new e,V=new e,H=new r,X=new Array(8),W=0;8>W;++W)X[W]=new e;var Y=new u;return w.projectTo2D=function(r,n,a){if(!i(r))throw new o("sphere is required.");n=t(n,Y);var u=n.ellipsoid,s=r.center,l=r.radius,c=u.geodeticSurfaceNormal(s,D),f=e.cross(e.UNIT_Z,c,B);e.normalize(f,f);var h=e.cross(c,f,z);e.normalize(h,h),e.multiplyByScalar(c,l,c),e.multiplyByScalar(h,l,h),e.multiplyByScalar(f,l,f);var d=e.negate(h,V),m=e.negate(f,G),E=X,p=E[0];e.add(c,h,p),e.add(p,f,p),p=E[1],e.add(c,h,p),e.add(p,m,p),p=E[2],e.add(c,d,p),e.add(p,m,p),p=E[3],e.add(c,d,p),e.add(p,f,p),e.negate(c,c),p=E[4],e.add(c,h,p),e.add(p,f,p),p=E[5],e.add(c,h,p),e.add(p,m,p),p=E[6],e.add(c,d,p),e.add(p,m,p),p=E[7],e.add(c,d,p),e.add(p,f,p);for(var y=E.length,_=0;y>_;++_){var T=E[_];e.add(s,T,T);var R=u.cartesianToCartographic(T,H);n.project(R,T)}a=w.fromPoints(E,a),s=a.center;var A=s.x,v=s.y,N=s.z;return s.x=N,s.y=A,s.z=v,a},w.isOccluded=function(e,r){if(!i(e))throw new o("sphere is required.");if(!i(r))throw new o("occluder is required.");return!r.isBoundingSphereVisible(e)},w.equals=function(r,t){return r===t||i(r)&&i(t)&&e.equals(r.center,t.center)&&r.radius===t.radius},w.prototype.intersectPlane=function(e){return w.intersectPlane(this,e)},w.prototype.distanceSquaredTo=function(e){return w.distanceSquaredTo(this,e)},w.prototype.computePlaneDistances=function(e,r,t){return w.computePlaneDistances(this,e,r,t)},w.prototype.isOccluded=function(e){return w.isOccluded(this,e)},w.prototype.equals=function(e){return w.equals(this,e)},w.prototype.clone=function(e){return w.clone(this,e)},w}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n){"use strict";var o=function(r,t){this.x=e(r,0),this.y=e(t,0)};o.fromElements=function(e,t,i){return r(i)?(i.x=e,i.y=t,i):new o(e,t)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t):new o(e.x,e.y):void 0},o.fromCartesian3=o.clone,o.fromCartesian4=o.clone,o.packedLength=2,o.pack=function(i,n,o){if(!r(i))throw new t("value is required");if(!r(n))throw new t("array is required");o=e(o,0),n[o++]=i.x,n[o]=i.y},o.unpack=function(i,n,a){if(!r(i))throw new t("array is required");return n=e(n,0),r(a)||(a=new o),a.x=i[n++],a.y=i[n],a},o.fromArray=o.unpack,o.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y)},o.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y)},o.minimumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.min(e.x,i.x),n.y=Math.min(e.y,i.y),n},o.maximumByComponent=function(e,i,n){if(!r(e))throw new t("first is required.");if(!r(i))throw new t("second is required.");if(!r(n))throw new t("result is required.");return n.x=Math.max(e.x,i.x),n.y=Math.max(e.y,i.y),n},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,i){if(!r(e)||!r(i))throw new t("left and right are required.");return o.subtract(e,i,a),o.magnitude(a)},o.distanceSquared=function(e,i){if(!r(e)||!r(i))throw new t("left and right are required.");return o.subtract(e,i,a),o.magnitudeSquared(a)},o.normalize=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");var n=o.magnitude(e);return i.x=e.x/n,i.y=e.y/n,i},o.dot=function(e,i){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");return e.x*i.x+e.y*i.y},o.multiplyComponents=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x*i.x,n.y=e.y*i.y,n},o.add=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x+i.x,n.y=e.y+i.y,n},o.subtract=function(e,i,n){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");if(!r(n))throw new t("result is required");return n.x=e.x-i.x,n.y=e.y-i.y,n},o.multiplyByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x*i,n.y=e.y*i,n},o.divideByScalar=function(e,i,n){if(!r(e))throw new t("cartesian is required");if("number"!=typeof i)throw new t("scalar is required and must be a number.");if(!r(n))throw new t("result is required");return n.x=e.x/i,n.y=e.y/i,n},o.negate=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=-e.x,i.y=-e.y,i},o.abs=function(e,i){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("result is required");return i.x=Math.abs(e.x),i.y=Math.abs(e.y),i};var u=new o;o.lerp=function(e,i,n,a){if(!r(e))throw new t("start is required.");if(!r(i))throw new t("end is required.");if("number"!=typeof n)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(i,n,u),a=o.multiplyByScalar(e,1-n,a),o.add(u,a,a)};var s=new o,l=new o;o.angleBetween=function(e,i){if(!r(e))throw new t("left is required");if(!r(i))throw new t("right is required");return o.normalize(e,s),o.normalize(i,l),n.acosClamped(o.dot(s,l))};var c=new o;return o.mostOrthogonalAxis=function(e,i){if(!r(e))throw new t("cartesian is required.");if(!r(i))throw new t("result is required.");var n=o.normalize(e,c);return o.abs(n,n),i=n.x<=n.y?o.clone(o.UNIT_X,i):o.clone(o.UNIT_Y,i)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},o.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]},o.equalsEpsilon=function(e,t,i,o){return e===t||r(e)&&r(t)&&n.equalsEpsilon(e.x,t.x,i,o)&&n.equalsEpsilon(e.y,t.y,i,o)},o.ZERO=i(new o(0,0)),o.UNIT_X=i(new o(1,0)),o.UNIT_Y=i(new o(0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r,t){return o.equalsEpsilon(this,e,r,t)},o.prototype.toString=function(){return"("+this.x+", "+this.y+")"},o}),define("Renderer/WebGLConstants",["../Core/freezeObject"],function(e){"use strict";var r={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return e(r)}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,r){"use strict";var t,i={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},n={};return r(n,{element:{get:function(){return n.supportsFullscreen()?document[i.fullscreenElement]:void 0}},changeEventName:{get:function(){return n.supportsFullscreen()?i.fullscreenchange:void 0}},errorEventName:{get:function(){return n.supportsFullscreen()?i.fullscreenerror:void 0}},enabled:{get:function(){return n.supportsFullscreen()?document[i.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return n.supportsFullscreen()?null!==n.element:void 0}}}),n.supportsFullscreen=function(){if(e(t))return t;t=!1;var r=document.body;if("function"==typeof r.requestFullscreen)return i.requestFullscreen="requestFullscreen",i.exitFullscreen="exitFullscreen",i.fullscreenEnabled="fullscreenEnabled",i.fullscreenElement="fullscreenElement",i.fullscreenchange="fullscreenchange",i.fullscreenerror="fullscreenerror",t=!0;for(var n,o=["webkit","moz","o","ms","khtml"],a=0,u=o.length;u>a;++a){var s=o[a];n=s+"RequestFullscreen","function"==typeof r[n]?(i.requestFullscreen=n,t=!0):(n=s+"RequestFullScreen","function"==typeof r[n]&&(i.requestFullscreen=n,t=!0)),n=s+"ExitFullscreen","function"==typeof document[n]?i.exitFullscreen=n:(n=s+"CancelFullScreen","function"==typeof document[n]&&(i.exitFullscreen=n)),n=s+"FullscreenEnabled",e(document[n])?i.fullscreenEnabled=n:(n=s+"FullScreenEnabled",e(document[n])&&(i.fullscreenEnabled=n)),n=s+"FullscreenElement",e(document[n])?i.fullscreenElement=n:(n=s+"FullScreenElement",e(document[n])&&(i.fullscreenElement=n)),n=s+"fullscreenchange",e(document["on"+n])&&("ms"===s&&(n="MSFullscreenChange"),i.fullscreenchange=n),n=s+"fullscreenerror",e(document["on"+n])&&("ms"===s&&(n="MSFullscreenError"),i.fullscreenerror=n)}return t},n.requestFullscreen=function(e){n.supportsFullscreen()&&e[i.requestFullscreen]()},n.exitFullscreen=function(){n.supportsFullscreen()&&document[i.exitFullscreen]()},n}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,r,t){"use strict";function i(e){for(var r=e.split("."),t=0,i=r.length;i>t;++t)r[t]=parseInt(r[t],10);return r}function n(){if(!r(E)){E=!1;var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(E=!0,p=i(e[1]))}return E}function o(){return n()&&p}function a(){if(!r(y)&&(y=!1,!n()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(y=!0,_=i(e[1]))}return y}function u(){return a()&&_}function s(){if(!r(T)){T=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==e&&(T=!0,R=i(e[1]),R.isNightly=!!e[2])}return T}function l(){return s()&&R}function c(){if(!r(A)){A=!1;var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(A=!0,v=i(e[1]))):"Netscape"===navigator.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(A=!0,v=i(e[1])))}return A}function f(){return c()&&v}function h(){if(!r(N)){N=!1;var e=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(N=!0,I=i(e[1]))}return N}function w(){return r(S)||(S=/Windows/i.test(navigator.appVersion)),S}function d(){return h()&&I}function m(){return r(g)||(g=r(window.PointerEvent)&&(!r(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),g}var E,p,y,_,T,R,A,v,N,I,S,g,M={isChrome:n,chromeVersion:o,isSafari:a,safariVersion:u,isWebkit:s,webkitVersion:l,isInternetExplorer:c,internetExplorerVersion:f,isFirefox:h,firefoxVersion:d,isWindows:w,hardwareConcurrency:e(navigator.hardwareConcurrency,3),supportsPointerEvents:m};return M.supportsFullscreen=function(){return t.supportsFullscreen()},M.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},M.supportsWebWorkers=function(){return"undefined"!=typeof Worker},M}),define("Core/ComponentDatatype",["../Renderer/WebGLConstants","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,r,t,i,n,o){"use strict";if(!n.supportsTypedArrays())return{};var a={BYTE:e.BYTE,UNSIGNED_BYTE:e.UNSIGNED_BYTE,SHORT:e.SHORT,UNSIGNED_SHORT:e.UNSIGNED_SHORT,FLOAT:e.FLOAT,DOUBLE:e.DOUBLE};return a.getSizeInBytes=function(e){if(!t(e))throw new i("value is required.");switch(e){case a.BYTE:return Int8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.SHORT:return Int16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case a.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new i("componentDatatype is not a valid value.")}},a.fromTypedArray=function(e){return e instanceof Int8Array?a.BYTE:e instanceof Uint8Array?a.UNSIGNED_BYTE:e instanceof Int16Array?a.SHORT:e instanceof Uint16Array?a.UNSIGNED_SHORT:e instanceof Float32Array?a.FLOAT:e instanceof Float64Array?a.DOUBLE:void 0},a.validate=function(e){return t(e)&&(e===a.BYTE||e===a.UNSIGNED_BYTE||e===a.SHORT||e===a.UNSIGNED_SHORT||e===a.FLOAT||e===a.DOUBLE)},a.createTypedArray=function(e,r){if(!t(e))throw new i("componentDatatype is required.");if(!t(r))throw new i("valuesOrLength is required.");switch(e){case a.BYTE:return new Int8Array(r);case a.UNSIGNED_BYTE:return new Uint8Array(r);case a.SHORT:return new Int16Array(r);case a.UNSIGNED_SHORT:return new Uint16Array(r);case a.FLOAT:return new Float32Array(r);case a.DOUBLE:return new Float64Array(r);default:throw new i("componentDatatype is not a valid value.")}},a.createArrayBufferView=function(e,n,o,u){if(!t(e))throw new i("componentDatatype is required.");if(!t(n))throw new i("buffer is required.");switch(o=r(o,0),u=r(u,(n.byteLength-o)/a.getSizeInBytes(e)),e){case a.BYTE:return new Int8Array(n,o,u);case a.UNSIGNED_BYTE:return new Uint8Array(n,o,u);case a.SHORT:return new Int16Array(n,o,u);case a.UNSIGNED_SHORT:return new Uint16Array(n,o,u);case a.FLOAT:return new Float32Array(n,o,u);case a.DOUBLE:return new Float64Array(n,o,u);default:throw new i("componentDatatype is not a valid value.")}},o(a)}),define("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,r,t,i,n,o,a,u){
"use strict";var s=function(e,t,i,n){this.x=r(e,0),this.y=r(t,0),this.z=r(i,0),this.w=r(n,0)},l=new e;s.fromAxisAngle=function(r,n,o){if(!t(r))throw new i("axis is required.");if("number"!=typeof n)throw new i("angle is required and must be a number.");var a=n/2,u=Math.sin(a);l=e.normalize(r,l);var c=l.x*u,f=l.y*u,h=l.z*u,w=Math.cos(a);return t(o)?(o.x=c,o.y=f,o.z=h,o.w=w,o):new s(c,f,h,w)};var c=[1,2,0],f=new Array(3);s.fromRotationMatrix=function(e,r){if(!t(e))throw new i("matrix is required.");var n,o,a,l,h,w=e[u.COLUMN0ROW0],d=e[u.COLUMN1ROW1],m=e[u.COLUMN2ROW2],E=w+d+m;if(E>0)n=Math.sqrt(E+1),h=.5*n,n=.5/n,o=(e[u.COLUMN1ROW2]-e[u.COLUMN2ROW1])*n,a=(e[u.COLUMN2ROW0]-e[u.COLUMN0ROW2])*n,l=(e[u.COLUMN0ROW1]-e[u.COLUMN1ROW0])*n;else{var p=c,y=0;d>w&&(y=1),m>w&&m>d&&(y=2);var _=p[y],T=p[_];n=Math.sqrt(e[u.getElementIndex(y,y)]-e[u.getElementIndex(_,_)]-e[u.getElementIndex(T,T)]+1);var R=f;R[y]=.5*n,n=.5/n,h=(e[u.getElementIndex(T,_)]-e[u.getElementIndex(_,T)])*n,R[_]=(e[u.getElementIndex(_,y)]+e[u.getElementIndex(y,_)])*n,R[T]=(e[u.getElementIndex(T,y)]+e[u.getElementIndex(y,T)])*n,o=-R[0],a=-R[1],l=-R[2]}return t(r)?(r.x=o,r.y=a,r.z=l,r.w=h,r):new s(o,a,l,h)};var h=new s;s.fromHeadingPitchRoll=function(r,n,o,a){if(!t(r))throw new i("heading is required.");if(!t(n))throw new i("pitch is required.");if(!t(o))throw new i("roll is required.");var u=s.fromAxisAngle(e.UNIT_X,o,h),l=s.fromAxisAngle(e.UNIT_Y,-n,a);a=s.multiply(l,u,l);var c=s.fromAxisAngle(e.UNIT_Z,-r,h);return s.multiply(c,a,a)};var w=new e,d=new e,m=new s,E=new s,p=new s;s.packedLength=4,s.pack=function(e,n,o){if(!t(e))throw new i("value is required");if(!t(n))throw new i("array is required");o=r(o,0),n[o++]=e.x,n[o++]=e.y,n[o++]=e.z,n[o]=e.w},s.unpack=function(e,n,o){if(!t(e))throw new i("array is required");return n=r(n,0),t(o)||(o=new s),o.x=e[n],o.y=e[n+1],o.z=e[n+2],o.w=e[n+3],o},s.packedInterpolationLength=3,s.convertPackedArrayForInterpolation=function(e,r,t,i){s.unpack(e,4*t,p),s.conjugate(p,p);for(var n=0,o=t-r+1;o>n;n++){var a=3*n;s.unpack(e,4*(r+n),m),s.multiply(m,p,m),m.w<0&&s.negate(m,m),s.computeAxis(m,w);var u=s.computeAngle(m);i[a]=w.x*u,i[a+1]=w.y*u,i[a+2]=w.z*u}},s.unpackInterpolationResult=function(r,i,n,o,a){t(a)||(a=new s),e.fromArray(r,0,d);var u=e.magnitude(d);return s.unpack(i,4*o,E),0===u?s.clone(s.IDENTITY,m):s.fromAxisAngle(d,u,m),s.multiply(m,E,a)},s.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new s(e.x,e.y,e.z,e.w):void 0},s.conjugate=function(e,r){if(!t(e))throw new i("quaternion is required");if(!t(r))throw new i("result is required");return r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=e.w,r},s.magnitudeSquared=function(e){if(!t(e))throw new i("quaternion is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},s.magnitude=function(e){return Math.sqrt(s.magnitudeSquared(e))},s.normalize=function(e,r){if(!t(r))throw new i("result is required");var n=1/s.magnitude(e),o=e.x*n,a=e.y*n,u=e.z*n,l=e.w*n;return r.x=o,r.y=a,r.z=u,r.w=l,r},s.inverse=function(e,r){if(!t(r))throw new i("result is required");var n=s.magnitudeSquared(e);return r=s.conjugate(e,r),s.multiplyByScalar(r,1/n,r)},s.add=function(e,r,n){if(!t(e))throw new i("left is required");if(!t(r))throw new i("right is required");if(!t(n))throw new i("result is required");return n.x=e.x+r.x,n.y=e.y+r.y,n.z=e.z+r.z,n.w=e.w+r.w,n},s.subtract=function(e,r,n){if(!t(e))throw new i("left is required");if(!t(r))throw new i("right is required");if(!t(n))throw new i("result is required");return n.x=e.x-r.x,n.y=e.y-r.y,n.z=e.z-r.z,n.w=e.w-r.w,n},s.negate=function(e,r){if(!t(e))throw new i("quaternion is required");if(!t(r))throw new i("result is required");return r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r},s.dot=function(e,r){if(!t(e))throw new i("left is required");if(!t(r))throw new i("right is required");return e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w},s.multiply=function(e,r,n){if(!t(e))throw new i("left is required");if(!t(r))throw new i("right is required");if(!t(n))throw new i("result is required");var o=e.x,a=e.y,u=e.z,s=e.w,l=r.x,c=r.y,f=r.z,h=r.w,w=s*l+o*h+a*f-u*c,d=s*c-o*f+a*h+u*l,m=s*f+o*c-a*l+u*h,E=s*h-o*l-a*c-u*f;return n.x=w,n.y=d,n.z=m,n.w=E,n},s.multiplyByScalar=function(e,r,n){if(!t(e))throw new i("quaternion is required");if("number"!=typeof r)throw new i("scalar is required and must be a number.");if(!t(n))throw new i("result is required");return n.x=e.x*r,n.y=e.y*r,n.z=e.z*r,n.w=e.w*r,n},s.divideByScalar=function(e,r,n){if(!t(e))throw new i("quaternion is required");if("number"!=typeof r)throw new i("scalar is required and must be a number.");if(!t(n))throw new i("result is required");return n.x=e.x/r,n.y=e.y/r,n.z=e.z/r,n.w=e.w/r,n},s.computeAxis=function(e,r){if(!t(e))throw new i("quaternion is required");if(!t(r))throw new i("result is required");var n=e.w;if(Math.abs(n-1)<a.EPSILON6)return r.x=r.y=r.z=0,r;var o=1/Math.sqrt(1-n*n);return r.x=e.x*o,r.y=e.y*o,r.z=e.z*o,r},s.computeAngle=function(e){if(!t(e))throw new i("quaternion is required");return Math.abs(e.w-1)<a.EPSILON6?0:2*Math.acos(e.w)};var y=new s;s.lerp=function(e,r,n,o){if(!t(e))throw new i("start is required.");if(!t(r))throw new i("end is required.");if("number"!=typeof n)throw new i("t is required and must be a number.");if(!t(o))throw new i("result is required");return y=s.multiplyByScalar(r,n,y),o=s.multiplyByScalar(e,1-n,o),s.add(y,o,o)};var _=new s,T=new s,R=new s;s.slerp=function(e,r,n,o){if(!t(e))throw new i("start is required.");if(!t(r))throw new i("end is required.");if("number"!=typeof n)throw new i("t is required and must be a number.");if(!t(o))throw new i("result is required");var u=s.dot(e,r),l=r;if(0>u&&(u=-u,l=_=s.negate(r,_)),1-u<a.EPSILON6)return s.lerp(e,l,n,o);var c=Math.acos(u);return T=s.multiplyByScalar(e,Math.sin((1-n)*c),T),R=s.multiplyByScalar(l,Math.sin(n*c),R),o=s.add(T,R,o),s.multiplyByScalar(o,1/Math.sin(c),o)},s.log=function(r,n){if(!t(r))throw new i("quaternion is required.");if(!t(n))throw new i("result is required");var o=a.acosClamped(r.w),u=0;return 0!==o&&(u=o/Math.sin(o)),e.multiplyByScalar(r,u,n)},s.exp=function(r,n){if(!t(r))throw new i("cartesian is required.");if(!t(n))throw new i("result is required");var o=e.magnitude(r),a=0;return 0!==o&&(a=Math.sin(o)/o),n.x=r.x*a,n.y=r.y*a,n.z=r.z*a,n.w=Math.cos(o),n};var A=new e,v=new e,N=new s,I=new s;s.computeInnerQuadrangle=function(r,n,o,a){if(!t(r)||!t(n)||!t(o))throw new i("q0, q1, and q2 are required.");if(!t(a))throw new i("result is required");var u=s.conjugate(n,N);s.multiply(u,o,I);var l=s.log(I,A);s.multiply(u,r,I);var c=s.log(I,v);return e.add(l,c,l),e.multiplyByScalar(l,.25,l),e.negate(l,l),s.exp(l,N),s.multiply(n,N,a)},s.squad=function(e,r,n,o,a,u){if(!(t(e)&&t(r)&&t(n)&&t(o)))throw new i("q0, q1, s0, and s1 are required.");if("number"!=typeof a)throw new i("t is required and must be a number.");if(!t(u))throw new i("result is required");var l=s.slerp(e,r,a,N),c=s.slerp(n,o,a,I);return s.slerp(l,c,2*a*(1-a),u)};for(var S=new s,g=1.9011074535173003,M=n.supportsTypedArrays()?new Float32Array(8):[],O=n.supportsTypedArrays()?new Float32Array(8):[],q=n.supportsTypedArrays()?new Float32Array(8):[],x=n.supportsTypedArrays()?new Float32Array(8):[],b=0;7>b;++b){var P=b+1,L=2*P+1;M[b]=1/(P*L),O[b]=P/L}return M[7]=g/136,O[7]=8*g/17,s.fastSlerp=function(e,r,n,o){if(!t(e))throw new i("start is required.");if(!t(r))throw new i("end is required.");if("number"!=typeof n)throw new i("t is required and must be a number.");if(!t(o))throw new i("result is required");var a,u=s.dot(e,r);u>=0?a=1:(a=-1,u=-u);for(var l=u-1,c=1-n,f=n*n,h=c*c,w=7;w>=0;--w)q[w]=(M[w]*f-O[w])*l,x[w]=(M[w]*h-O[w])*l;var d=a*n*(1+q[0]*(1+q[1]*(1+q[2]*(1+q[3]*(1+q[4]*(1+q[5]*(1+q[6]*(1+q[7])))))))),m=c*(1+x[0]*(1+x[1]*(1+x[2]*(1+x[3]*(1+x[4]*(1+x[5]*(1+x[6]*(1+x[7])))))))),E=s.multiplyByScalar(e,m,S);return s.multiplyByScalar(r,d,o),s.add(E,o,o)},s.fastSquad=function(e,r,n,o,a,u){if(!(t(e)&&t(r)&&t(n)&&t(o)))throw new i("q0, q1, s0, and s1 are required.");if("number"!=typeof a)throw new i("t is required and must be a number.");if(!t(u))throw new i("result is required");var l=s.fastSlerp(e,r,a,N),c=s.fastSlerp(n,o,a,I);return s.fastSlerp(l,c,2*a*(1-a),u)},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},s.equalsEpsilon=function(e,r,n){if("number"!=typeof n)throw new i("epsilon is required and must be a number.");return e===r||t(e)&&t(r)&&Math.abs(e.x-r.x)<=n&&Math.abs(e.y-r.y)<=n&&Math.abs(e.z-r.z)<=n&&Math.abs(e.w-r.w)<=n},s.ZERO=o(new s(0,0,0,0)),s.IDENTITY=o(new s(0,0,0,1)),s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,r){return s.equalsEpsilon(this,e,r)},s.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},s}),define("Core/EllipseGeometryLibrary",["./Cartesian3","./Math","./Matrix3","./Quaternion"],function(e,r,t,i){"use strict";function n(r,n,o,c,f,h,w,d,m,E){var p=r+n;e.multiplyByScalar(c,Math.cos(p),a),e.multiplyByScalar(o,Math.sin(p),u),e.add(a,u,a);var y=Math.cos(r);y*=y;var _=Math.sin(r);_*=_;var T=h/Math.sqrt(w*y+f*_),R=T/d;return i.fromAxisAngle(a,R,s),t.fromQuaternion(s,l),t.multiplyByVector(l,m,E),e.normalize(E,E),e.multiplyByScalar(E,d,E),E}var o={},a=new e,u=new e,s=new i,l=new t,c=new e,f=new e,h=new e,w=new e;o.raisePositionsToHeight=function(r,t,i){for(var n=t.ellipsoid,o=t.height,a=t.extrudedHeight,u=i?r.length/3*2:r.length/3,s=new Float64Array(3*u),l=r.length,d=i?l:0,m=0;l>m;m+=3){var E=m+1,p=m+2,y=e.fromArray(r,m,c);n.scaleToGeodeticSurface(y,y);var _=e.clone(y,f),T=n.geodeticSurfaceNormal(y,w),R=e.multiplyByScalar(T,o,h);e.add(y,R,y),i&&(e.multiplyByScalar(T,a,R),e.add(_,R,_),s[m+d]=_.x,s[E+d]=_.y,s[p+d]=_.z),s[m]=y.x,s[E]=y.y,s[p]=y.z}return s};var d=new e,m=new e,E=new e;return o.computeEllipsePositions=function(t,i,o){var a=t.semiMinorAxis,u=t.semiMajorAxis,s=t.rotation,l=t.center,w=8*t.granularity,p=a*a,y=u*u,_=u*a,T=e.magnitude(l),R=e.normalize(l,d),A=e.cross(e.UNIT_Z,l,m);A=e.normalize(A,A);var v=e.cross(R,A,E),N=1+Math.ceil(r.PI_OVER_TWO/w),I=r.PI_OVER_TWO/(N-1),S=r.PI_OVER_TWO-N*I;0>S&&(N-=Math.ceil(Math.abs(S)/I));var g,M,O,q,x,b=2*N*(N+1),P=i?new Array(3*b):void 0,L=0,C=c,F=f,U=3*(2*N+2*(N-1)),D=U-1,B=0,z=o?new Array(U):void 0;for(S=r.PI_OVER_TWO,g=0;N>g;++g){if(C=n(S,s,v,A,p,_,y,T,R,C),F=n(Math.PI-S,s,v,A,p,_,y,T,R,F),i){for(P[L++]=C.x,P[L++]=C.y,P[L++]=C.z,O=2*g+2,M=1;O-1>M;++M)q=M/(O-1),x=e.lerp(C,F,q,h),P[L++]=x.x,P[L++]=x.y,P[L++]=x.z;P[L++]=F.x,P[L++]=F.y,P[L++]=F.z}o&&(z[D--]=C.z,z[D--]=C.y,z[D--]=C.x,0!==g&&(z[B++]=F.x,z[B++]=F.y,z[B++]=F.z)),S=r.PI_OVER_TWO-(g+1)*I}for(g=N;g>0;--g){if(S=r.PI_OVER_TWO-(g-1)*I,C=n(-S,s,v,A,p,_,y,T,R,C),F=n(S+Math.PI,s,v,A,p,_,y,T,R,F),i){for(P[L++]=C.x,P[L++]=C.y,P[L++]=C.z,O=2*(g-1)+2,M=1;O-1>M;++M)q=M/(O-1),x=e.lerp(C,F,q,h),P[L++]=x.x,P[L++]=x.y,P[L++]=x.z;P[L++]=F.x,P[L++]=F.y,P[L++]=F.z}o&&(z[D--]=C.z,z[D--]=C.y,z[D--]=C.x,1!==g&&(z[B++]=F.x,z[B++]=F.y,z[B++]=F.z))}var G={};return i&&(G.positions=P,G.numPts=N),o&&(G.outerPositions=z),G},o}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var r={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(r)}),define("Core/PrimitiveType",["../Renderer/WebGLConstants","./freezeObject"],function(e,r){"use strict";var t={POINTS:e.POINTS,LINES:e.LINES,LINE_LOOP:e.LINE_LOOP,LINE_STRIP:e.LINE_STRIP,TRIANGLES:e.TRIANGLES,TRIANGLE_STRIP:e.TRIANGLE_STRIP,TRIANGLE_FAN:e.TRIANGLE_FAN,validate:function(e){return e===t.POINTS||e===t.LINES||e===t.LINE_LOOP||e===t.LINE_STRIP||e===t.TRIANGLES||e===t.TRIANGLE_STRIP||e===t.TRIANGLE_FAN}};return r(t)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,r,t,i,n){"use strict";var o=function(o){if(o=e(o,e.EMPTY_OBJECT),!r(o.attributes))throw new t("options.attributes is required.");this.attributes=o.attributes,this.indices=o.indices,this.primitiveType=e(o.primitiveType,n.TRIANGLES),this.boundingSphere=o.boundingSphere,this.geometryType=e(o.geometryType,i.NONE),this.boundingSphereCV=void 0};return o.computeNumberOfVertices=function(e){if(!r(e))throw new t("geometry is required.");var i=-1;for(var n in e.attributes)if(e.attributes.hasOwnProperty(n)&&r(e.attributes[n])&&r(e.attributes[n].values)){var o=e.attributes[n],a=o.values.length/o.componentsPerAttribute;if(i!==a&&-1!==i)throw new t("All attribute lists must have the same number of attributes.");i=a}return i},o}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var i=function(i){if(i=e(i,e.EMPTY_OBJECT),!r(i.componentDatatype))throw new t("options.componentDatatype is required.");if(!r(i.componentsPerAttribute))throw new t("options.componentsPerAttribute is required.");if(i.componentsPerAttribute<1||i.componentsPerAttribute>4)throw new t("options.componentsPerAttribute must be between 1 and 4.");if(!r(i.values))throw new t("options.values is required.");this.componentDatatype=i.componentDatatype,this.componentsPerAttribute=i.componentsPerAttribute,this.normalize=e(i.normalize,!1),this.values=i.values};return i}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var r=function(r){r=e(r,e.EMPTY_OBJECT),this.position=r.position,this.normal=r.normal,this.st=r.st,this.binormal=r.binormal,this.tangent=r.tangent,this.color=r.color};return r}),define("Core/GeometryInstance",["./defaultValue","./defined","./DeveloperError","./Matrix4"],function(e,r,t,i){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.geometry))throw new t("options.geometry is required.");this.geometry=n.geometry,this.modelMatrix=i.clone(e(n.modelMatrix,i.IDENTITY)),this.id=n.id,this.pickPrimitive=n.pickPrimitive,this.attributes=e(n.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0};return n}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,r,t,i,n){"use strict";var o={};o.octEncode=function(e,o){if(!t(e))throw new i("vector is required.");if(!t(o))throw new i("result is required.");var a=r.magnitudeSquared(e);if(Math.abs(a-1)>n.EPSILON6)throw new i("vector must be normalized.");if(o.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),o.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var u=o.x,s=o.y;o.x=(1-Math.abs(s))*n.signNotZero(u),o.y=(1-Math.abs(u))*n.signNotZero(s)}return o.x=n.toSNorm(o.x),o.y=n.toSNorm(o.y),o},o.octDecode=function(e,o,a){if(!t(a))throw new i("result is required.");if(0>e||e>255||0>o||o>255)throw new i("x and y must be a signed normalized integer between 0 and 255");if(a.x=n.fromSNorm(e),a.y=n.fromSNorm(o),a.z=1-(Math.abs(a.x)+Math.abs(a.y)),a.z<0){var u=a.x;a.x=(1-Math.abs(a.y))*n.signNotZero(u),a.y=(1-Math.abs(u))*n.signNotZero(a.y)}return r.normalize(a,a)},o.octPackFloat=function(e){if(!t(e))throw new i("encoded is required.");return 256*e.x+e.y};var a=new e;return o.octEncodeFloat=function(e){return o.octEncode(e,a),o.octPackFloat(a)},o.octDecodeFloat=function(e,r){if(!t(e))throw new i("value is required.");var n=e/256,a=Math.floor(n),u=256*(n-a);return o.octDecode(a,u,r)},o.octPack=function(e,r,n,u){if(!t(e))throw new i("v1 is required.");if(!t(r))throw new i("v2 is required.");if(!t(n))throw new i("v3 is required.");if(!t(u))throw new i("result is required.");var s=o.octEncodeFloat(e),l=o.octEncodeFloat(r),c=o.octEncode(n,a);return u.x=65536*c.x+s,u.y=65536*c.y+l,u},o.octUnpack=function(e,r,n,a){if(!t(e))throw new i("packed is required.");if(!t(r))throw new i("v1 is required.");if(!t(n))throw new i("v2 is required.");if(!t(a))throw new i("v3 is required.");var u=e.x/65536,s=Math.floor(u),l=65536*(u-s);u=e.y/65536;var c=Math.floor(u),f=65536*(u-c);o.octDecodeFloat(l,r),o.octDecodeFloat(f,n),o.octDecode(s,c,a)},o.compressTextureCoordinates=function(e){if(!t(e))throw new i("textureCoordinates is required.");var r=1===e.x?4095:4096*e.x|0,n=1===e.y?4095:4096*e.y|0;return 4096*r+n},o.decompressTextureCoordinates=function(e,r){if(!t(e))throw new i("compressed is required.");if(!t(r))throw new i("result is required.");var n=e/4096;return r.x=Math.floor(n)/4096,r.y=n-Math.floor(n),r},o}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,r,t,i){"use strict";var n=new r,o=new r,a=new r,u=function(u,s,l,c,f){if(!(t(u)&&t(s)&&t(l)&&t(c)))throw new i("point, p0, p1, and p2 are required.");t(f)||(f=new r);var h,w,d,m,E,p,y,_;t(s.z)?(h=r.subtract(l,s,n),w=r.subtract(c,s,o),d=r.subtract(u,s,a),m=r.dot(h,h),E=r.dot(h,w),p=r.dot(h,d),y=r.dot(w,w),_=r.dot(w,d)):(h=e.subtract(l,s,n),w=e.subtract(c,s,o),d=e.subtract(u,s,a),m=e.dot(h,h),E=e.dot(h,w),p=e.dot(h,d),y=e.dot(w,w),_=e.dot(w,d));var T=1/(m*y-E*E);return f.y=(y*p-E*_)*T,f.z=(m*_-E*p)*T,f.x=1-f.y-f.z,f};return u}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,r,t){"use strict";var i=function(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)};i.encode=function(e,i){if(!r(e))throw new t("value is required");r(i)||(i={high:0,low:0});var n;return e>=0?(n=65536*Math.floor(e/65536),i.high=n,i.low=e-n):(n=65536*Math.floor(-e/65536),i.high=-n,i.low=e+n),i};var n={high:0,low:0};i.fromCartesian=function(e,o){if(!r(e))throw new t("cartesian is required");r(o)||(o=new i);var a=o.high,u=o.low;return i.encode(e.x,n),a.x=n.high,u.x=n.low,i.encode(e.y,n),a.y=n.high,u.y=n.low,i.encode(e.z,n),a.z=n.high,u.z=n.low,o};var o=new i;return i.writeElements=function(e,n,a){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("cartesianArray is required");if("number"!=typeof a||0>a)throw new t("index must be a number greater than or equal to 0.");i.fromCartesian(e,o);var u=o.high,s=o.low;n[a]=u.x,n[a+1]=u.y,n[a+2]=u.z,n[a+3]=s.x,n[a+4]=s.y,n[a+5]=s.z},i}),define("Core/IndexDatatype",["../Renderer/WebGLConstants","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,i,n){"use strict";var o={UNSIGNED_BYTE:e.UNSIGNED_BYTE,UNSIGNED_SHORT:e.UNSIGNED_SHORT,UNSIGNED_INT:e.UNSIGNED_INT};return o.getSizeInBytes=function(e){switch(e){case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},o.validate=function(e){return r(e)&&(e===o.UNSIGNED_BYTE||e===o.UNSIGNED_SHORT||e===o.UNSIGNED_INT)},o.createTypedArray=function(e,i){if(!r(e))throw new t("numberOfVertices is required.");return e>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},o.createTypedArrayFromArrayBuffer=function(e,i,o,a){if(!r(e))throw new t("numberOfVertices is required.");if(!r(i))throw new t("sourceArray is required.");if(!r(o))throw new t("byteOffset is required.");return e>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(i,o,a):new Uint16Array(i,o,a)},i(o)}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,r){"use strict";function t(e,t,i){var n=e+t;return r.sign(e)!==r.sign(t)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(t)))<i?0:n}var i={};return i.computeDiscriminant=function(r,t,i){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof i)throw new e("c is a required number.");var n=t*t-4*r*i;return n},i.computeRealRoots=function(i,n,o){if("number"!=typeof i)throw new e("a is a required number.");if("number"!=typeof n)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");var a;if(0===i)return 0===n?[]:[-o/n];if(0===n){if(0===o)return[0,0];var u=Math.abs(o),s=Math.abs(i);if(s>u&&u/s<r.EPSILON14)return[0,0];if(u>s&&s/u<r.EPSILON14)return[];if(a=-o/i,0>a)return[];var l=Math.sqrt(a);return[-l,l]}if(0===o)return a=-n/i,0>a?[a,0]:[0,a];var c=n*n,f=4*i*o,h=t(c,-f,r.EPSILON14);if(0>h)return[];var w=-.5*t(n,r.sign(n)*Math.sqrt(h),r.EPSILON14);return n>0?[w/i,o/w]:[o/w,w/i]},i}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,r){"use strict";function t(e,r,t,i){var n,o,a=e,u=r/3,s=t/3,l=i,c=a*s,f=u*l,h=u*u,w=s*s,d=a*s-h,m=a*l-u*s,E=u*l-w,p=4*d*E-m*m;if(0>p){var y,_,T;h*f>=c*w?(y=a,_=d,T=-2*u*d+a*m):(y=l,_=E,T=-l*m+2*s*E);var R=0>T?-1:1,A=-R*Math.abs(y)*Math.sqrt(-p);o=-T+A;var v=o/2,N=0>v?-Math.pow(-v,1/3):Math.pow(v,1/3),I=o===A?-N:-_/N;return n=0>=_?N+I:-T/(N*N+I*I+_),h*f>=c*w?[(n-u)/a]:[-l/(n+s)]}var S=d,g=-2*u*d+a*m,M=E,O=-l*m+2*s*E,q=Math.sqrt(p),x=Math.sqrt(3)/2,b=Math.abs(Math.atan2(a*q,-g)/3);n=2*Math.sqrt(-S);var P=Math.cos(b);o=n*P;var L=n*(-P/2-x*Math.sin(b)),C=o+L>2*u?o-u:L-u,F=a,U=C/F;b=Math.abs(Math.atan2(l*q,-O)/3),n=2*Math.sqrt(-M),P=Math.cos(b),o=n*P,L=n*(-P/2-x*Math.sin(b));var D=-l,B=2*s>o+L?o+s:L+s,z=D/B,G=F*B,V=-C*B-F*D,H=C*D,X=(s*V-u*H)/(-u*V+s*G);return X>=U?z>=U?z>=X?[U,X,z]:[U,z,X]:[z,U,X]:z>=U?[X,U,z]:z>=X?[X,z,U]:[z,X,U]}var i={};return i.computeDiscriminant=function(r,t,i,n){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof i)throw new e("c is a required number.");if("number"!=typeof n)throw new e("d is a required number.");var o=r*r,a=t*t,u=i*i,s=n*n,l=18*r*t*i*n+a*u-27*o*s-4*(r*u*i+a*t*n);return l},i.computeRealRoots=function(i,n,o,a){if("number"!=typeof i)throw new e("a is a required number.");if("number"!=typeof n)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");if("number"!=typeof a)throw new e("d is a required number.");var u,s;if(0===i)return r.computeRealRoots(n,o,a);if(0===n){if(0===o){if(0===a)return[0,0,0];s=-a/i;var l=0>s?-Math.pow(-s,1/3):Math.pow(s,1/3);return[l,l,l]}return 0===a?(u=r.computeRealRoots(i,0,o),0===u.Length?[0]:[u[0],0,u[1]]):t(i,0,o,a)}return 0===o?0===a?(s=-n/i,0>s?[s,0,0]:[0,0,s]):t(i,n,0,a):0===a?(u=r.computeRealRoots(i,n,o),0===u.length?[0]:u[1]<=0?[u[0],u[1],0]:u[0]>=0?[0,u[0],u[1]]:[u[0],0,u[1]]):t(i,n,o,a)},i}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,r,t,i){"use strict";function n(r,n,o,a){var u=r*r,s=n-3*u/8,l=o-n*r/2+u*r/8,c=a-o*r/4+n*u/16-3*u*u/256,f=e.computeRealRoots(1,2*s,s*s-4*c,-l*l);if(f.length>0){var h=-r/4,w=f[f.length-1];if(Math.abs(w)<t.EPSILON14){var d=i.computeRealRoots(1,s,c);if(2===d.length){var m,E=d[0],p=d[1];if(E>=0&&p>=0){var y=Math.sqrt(E),_=Math.sqrt(p);return[h-_,h-y,h+y,h+_]}if(E>=0&&0>p)return m=Math.sqrt(E),[h-m,h+m];if(0>E&&p>=0)return m=Math.sqrt(p),[h-m,h+m]}return[]}if(w>0){var T=Math.sqrt(w),R=(s+w-l/T)/2,A=(s+w+l/T)/2,v=i.computeRealRoots(1,T,R),N=i.computeRealRoots(1,-T,A);return 0!==v.length?(v[0]+=h,v[1]+=h,0!==N.length?(N[0]+=h,N[1]+=h,v[1]<=N[0]?[v[0],v[1],N[0],N[1]]:N[1]<=v[0]?[N[0],N[1],v[0],v[1]]:v[0]>=N[0]&&v[1]<=N[1]?[N[0],v[0],v[1],N[1]]:N[0]>=v[0]&&N[1]<=v[1]?[v[0],N[0],N[1],v[1]]:v[0]>N[0]&&v[0]<N[1]?[N[0],v[0],N[1],v[1]]:[v[0],N[0],v[1],N[1]]):v):0!==N.length?(N[0]+=h,N[1]+=h,N):[]}}return[]}function o(r,n,o,a){var u=o*o,s=n*n,l=r*r,c=-2*n,f=o*r+s-4*a,h=l*a-o*n*r+u,w=e.computeRealRoots(1,c,f,h);if(w.length>0){var d,m,E=w[0],p=n-E,y=p*p,_=r/2,T=p/2,R=y-4*a,A=y+4*Math.abs(a),v=l-4*E,N=l+4*Math.abs(E);if(0>E||v*A>R*N){var I=Math.sqrt(v);d=I/2,m=0===I?0:(r*T-o)/I}else{var S=Math.sqrt(R);d=0===S?0:(r*T-o)/S,m=S/2}var g,M;0===_&&0===d?(g=0,M=0):t.sign(_)===t.sign(d)?(g=_+d,M=E/g):(M=_-d,g=E/M);var O,q;0===T&&0===m?(O=0,q=0):t.sign(T)===t.sign(m)?(O=T+m,q=a/O):(q=T-m,O=a/q);var x=i.computeRealRoots(1,g,O),b=i.computeRealRoots(1,M,q);if(0!==x.length)return 0!==b.length?x[1]<=b[0]?[x[0],x[1],b[0],b[1]]:b[1]<=x[0]?[b[0],b[1],x[0],x[1]]:x[0]>=b[0]&&x[1]<=b[1]?[b[0],x[0],x[1],b[1]]:b[0]>=x[0]&&b[1]<=x[1]?[x[0],b[0],b[1],x[1]]:x[0]>b[0]&&x[0]<b[1]?[b[0],x[0],b[1],x[1]]:[x[0],b[0],x[1],b[1]]:x;if(0!==b.length)return b}return[]}var a={};return a.computeDiscriminant=function(e,t,i,n,o){if("number"!=typeof e)throw new r("a is a required number.");if("number"!=typeof t)throw new r("b is a required number.");if("number"!=typeof i)throw new r("c is a required number.");if("number"!=typeof n)throw new r("d is a required number.");if("number"!=typeof o)throw new r("e is a required number.");var a=e*e,u=a*e,s=t*t,l=s*t,c=i*i,f=c*i,h=n*n,w=h*n,d=o*o,m=d*o,E=s*c*h-4*l*w-4*e*f*h+18*e*t*i*w-27*a*h*h+256*u*m+o*(18*l*i*n-4*s*f+16*e*c*c-80*e*t*c*n-6*e*s*h+144*a*i*h)+d*(144*e*s*i-27*s*s-128*a*c-192*a*t*n);return E},a.computeRealRoots=function(i,a,u,s,l){if("number"!=typeof i)throw new r("a is a required number.");if("number"!=typeof a)throw new r("b is a required number.");if("number"!=typeof u)throw new r("c is a required number.");if("number"!=typeof s)throw new r("d is a required number.");if("number"!=typeof l)throw new r("e is a required number.");if(Math.abs(i)<t.EPSILON15)return e.computeRealRoots(a,u,s,l);var c=a/i,f=u/i,h=s/i,w=l/i,d=0>c?1:0;switch(d+=0>f?d+1:d,d+=0>h?d+1:d,d+=0>w?d+1:d){case 0:return n(c,f,h,w);case 1:return o(c,f,h,w);case 2:return o(c,f,h,w);case 3:return n(c,f,h,w);case 4:return n(c,f,h,w);case 5:return o(c,f,h,w);case 6:return n(c,f,h,w);case 7:return n(c,f,h,w);case 8:return o(c,f,h,w);case 9:return n(c,f,h,w);case 10:return n(c,f,h,w);case 11:return o(c,f,h,w);case 12:return n(c,f,h,w);case 13:return n(c,f,h,w);case 14:return n(c,f,h,w);case 15:return n(c,f,h,w);default:return void 0}},a}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,r,t,i){"use strict";var n=function(t,i){i=e.clone(r(i,e.ZERO)),e.equals(i,e.ZERO)||e.normalize(i,i),this.origin=e.clone(r(t,e.ZERO)),this.direction=i};return n.getPoint=function(r,n,o){if(!t(r))throw new i("ray is requred");if("number"!=typeof n)throw new i("t is a required number");return t(o)||(o=new e),o=e.multiplyByScalar(r.direction,n,o),e.add(r.origin,o,o)},n}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,r,t,i,n,o,a,u,s,l){"use strict";function c(r,a,u,s,l){if(!i(r))throw new n("ray is required.");if(!i(a))throw new n("p0 is required.");if(!i(u))throw new n("p1 is required.");if(!i(s))throw new n("p2 is required.");l=t(l,!1);var c,f,h,w,d,m=r.origin,R=r.direction,A=e.subtract(u,a,E),v=e.subtract(s,a,p),N=e.cross(R,v,y),I=e.dot(A,N);if(l){if(I<o.EPSILON6)return void 0;if(c=e.subtract(m,a,_),h=e.dot(c,N),0>h||h>I)return void 0;if(f=e.cross(c,A,T),w=e.dot(R,f),0>w||h+w>I)return void 0;d=e.dot(v,f)/I}else{if(Math.abs(I)<o.EPSILON6)return void 0;var S=1/I;if(c=e.subtract(m,a,_),h=e.dot(c,N)*S,0>h||h>1)return void 0;if(f=e.cross(c,A,T),w=e.dot(R,f)*S,0>w||h+w>1)return void 0;d=e.dot(v,f)*S}return d}function f(e,r,t,i){var n=r*r-4*e*t;if(0>n)return void 0;if(n>0){var o=1/(2*e),a=Math.sqrt(n),u=(-r+a)*o,s=(-r-a)*o;return s>u?(i.root0=u,i.root1=s):(i.root0=s,i.root1=u),i}var l=-r/(2*e);return 0===l?void 0:(i.root0=i.root1=l,i)}function h(r,t,n){i(n)||(n={});var o=r.origin,a=r.direction,u=t.center,s=t.radius*t.radius,l=e.subtract(o,u,y),c=e.dot(a,a),h=2*e.dot(a,l),w=e.magnitudeSquared(l)-s,d=f(c,h,w,A);return i(d)?(n.start=d.root0,n.stop=d.root1,n):void 0}function w(e,r,t){var i=e+r;return o.sign(e)!==o.sign(r)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(r)))<t?0:i}function d(r,t,i,n,l){var c,f=n*n,h=l*l,d=(r[a.COLUMN1ROW1]-r[a.COLUMN2ROW2])*h,m=l*(n*w(r[a.COLUMN1ROW0],r[a.COLUMN0ROW1],o.EPSILON15)+t.y),E=r[a.COLUMN0ROW0]*f+r[a.COLUMN2ROW2]*h+n*t.x+i,p=h*w(r[a.COLUMN2ROW1],r[a.COLUMN1ROW2],o.EPSILON15),y=l*(n*w(r[a.COLUMN2ROW0],r[a.COLUMN0ROW2])+t.z),_=[];if(0===y&&0===p){if(c=u.computeRealRoots(d,m,E),0===c.length)return _;var T=c[0],R=Math.sqrt(Math.max(1-T*T,0));if(_.push(new e(n,l*T,l*-R)),_.push(new e(n,l*T,l*R)),2===c.length){var A=c[1],v=Math.sqrt(Math.max(1-A*A,0));_.push(new e(n,l*A,l*-v)),_.push(new e(n,l*A,l*v))}return _}var N=y*y,I=p*p,S=d*d,g=y*p,M=S+I,O=2*(m*d+g),q=2*E*d+m*m-I+N,x=2*(E*m-g),b=E*E-N;if(0===M&&0===O&&0===q&&0===x)return _;c=s.computeRealRoots(M,O,q,x,b);var P=c.length;if(0===P)return _;for(var L=0;P>L;++L){var C,F=c[L],U=F*F,D=Math.max(1-U,0),B=Math.sqrt(D);C=o.sign(d)===o.sign(E)?w(d*U+E,m*F,o.EPSILON12):o.sign(E)===o.sign(m*F)?w(d*U,m*F+E,o.EPSILON12):w(d*U+m*F,E,o.EPSILON12);var z=w(p*F,y,o.EPSILON15),G=C*z;0>G?_.push(new e(n,l*F,l*B)):G>0?_.push(new e(n,l*F,l*-B)):0!==B?(_.push(new e(n,l*F,l*-B)),_.push(new e(n,l*F,l*B)),++L):_.push(new e(n,l*F,l*B))}return _}var m={};m.rayPlane=function(r,t,a){if(!i(r))throw new n("ray is required.");if(!i(t))throw new n("plane is required.");i(a)||(a=new e);var u=r.origin,s=r.direction,l=t.normal,c=e.dot(l,s);if(Math.abs(c)<o.EPSILON15)return void 0;var f=(-t.distance-e.dot(l,u))/c;return 0>f?void 0:(a=e.multiplyByScalar(s,f,a),e.add(u,a,a))};var E=new e,p=new e,y=new e,_=new e,T=new e;m.rayTriangle=function(r,t,n,o,a,u){var s=c(r,t,n,o,a);return!i(s)||0>s?void 0:(i(u)||(u=new e),e.multiplyByScalar(r.direction,s,u),e.add(r.origin,u,u))};var R=new l;m.lineSegmentTriangle=function(r,t,o,a,u,s,l){if(!i(r))throw new n("v0 is required.");if(!i(t))throw new n("v1 is required.");var f=R;e.clone(r,f.origin),e.subtract(t,r,f.direction),e.normalize(f.direction,f.direction);var h=c(f,o,a,u,s);return!i(h)||0>h||h>e.distance(r,t)?void 0:(i(l)||(l=new e),e.multiplyByScalar(f.direction,h,l),e.add(f.origin,l,l))};var A={root0:0,root1:0};m.raySphere=function(e,r,t){if(!i(e))throw new n("ray is required.");if(!i(r))throw new n("sphere is required.");return t=h(e,r,t),!i(t)||t.stop<0?void 0:(t.start=Math.max(t.start,0),t)};var v=new l;m.lineSegmentSphere=function(r,t,o,a){if(!i(r))throw new n("p0 is required.");if(!i(t))throw new n("p1 is required.");if(!i(o))throw new n("sphere is required.");var u=v,s=(e.clone(r,u.origin),e.subtract(t,r,u.direction)),l=e.magnitude(s);return e.normalize(s,s),a=h(u,o,a),!i(a)||a.stop<0||a.start>l?void 0:(a.start=Math.max(a.start,0),a.stop=Math.min(a.stop,l),a)};var N=new e,I=new e;m.rayEllipsoid=function(r,t){if(!i(r))throw new n("ray is required.");if(!i(t))throw new n("ellipsoid is required.");var o,a,u,s,l,c=t.oneOverRadii,f=e.multiplyComponents(c,r.origin,N),h=e.multiplyComponents(c,r.direction,I),w=e.magnitudeSquared(f),d=e.dot(f,h);if(w>1){if(d>=0)return void 0;var m=d*d;if(o=w-1,a=e.magnitudeSquared(h),u=a*o,u>m)return void 0;if(m>u){s=d*d-u,l=-d+Math.sqrt(s);var E=l/a,p=o/l;return p>E?{start:E,stop:p}:{start:p,stop:E}}var y=Math.sqrt(o/a);return{start:y,stop:y}}return 1>w?(o=w-1,a=e.magnitudeSquared(h),u=a*o,s=d*d-u,l=-d+Math.sqrt(s),{start:0,stop:l/a}):0>d?(a=e.magnitudeSquared(h),{start:0,stop:-d/a}):void 0};var S=new e,g=new e,M=new e,O=new e,q=new e,x=new a,b=new a,P=new a,L=new a,C=new a,F=new a,U=new a,D=new e,B=new e,z=new r;m.grazingAltitudeLocation=function(r,t){if(!i(r))throw new n("ray is required.");if(!i(t))throw new n("ellipsoid is required.");var u=r.origin,s=r.direction,l=t.geodeticSurfaceNormal(u,S);if(e.dot(s,l)>=0)return u;var c=i(this.rayEllipsoid(r,t)),f=t.transformPositionToScaledSpace(s,S),h=e.normalize(f,f),w=e.mostOrthogonalAxis(f,O),m=e.normalize(e.cross(w,h,g),g),E=e.normalize(e.cross(h,m,M),M),p=x;p[0]=h.x,p[1]=h.y,p[2]=h.z,p[3]=m.x,p[4]=m.y,p[5]=m.z,p[6]=E.x,p[7]=E.y,p[8]=E.z;var y=a.transpose(p,b),_=a.fromScale(t.radii,P),T=a.fromScale(t.oneOverRadii,L),R=C;R[0]=0,R[1]=-s.z,R[2]=s.y,R[3]=s.z,R[4]=0,R[5]=-s.x,R[6]=-s.y,R[7]=s.x,R[8]=0;var A,v,N=a.multiply(a.multiply(y,T,F),R,F),I=a.multiply(a.multiply(N,_,U),p,U),G=a.multiplyByVector(N,u,q),V=d(I,e.negate(G,S),0,0,1),H=V.length;if(H>0){for(var X=e.clone(e.ZERO,B),W=Number.NEGATIVE_INFINITY,Y=0;H>Y;++Y){A=a.multiplyByVector(_,a.multiplyByVector(p,V[Y],D),D);var k=e.normalize(e.subtract(A,u,O),O),K=e.dot(k,s);K>W&&(W=K,X=e.clone(A,X))}var j=t.cartesianToCartographic(X,z);return W=o.clamp(W,0,1),v=e.magnitude(e.subtract(X,u,O))*Math.sqrt(1-W*W),v=c?-v:v,j.height=v,t.cartographicToCartesian(j,new e)}return void 0};var G=new e;
return m.lineSegmentPlane=function(r,t,a,u){if(!i(r))throw new n("endPoint0 is required.");if(!i(t))throw new n("endPoint1 is required.");if(!i(a))throw new n("plane is required.");i(u)||(u=new e);var s=e.subtract(t,r,G),l=a.normal,c=e.dot(l,s);if(Math.abs(c)<o.EPSILON6)return void 0;var f=e.dot(l,r),h=-(a.distance+f)/c;return 0>h||h>1?void 0:(e.multiplyByScalar(s,h,u),e.add(r,u,u),u)},m.trianglePlaneIntersection=function(r,t,o,a){if(!(i(r)&&i(t)&&i(o)&&i(a)))throw new n("p0, p1, p2, and plane are required.");var u=a.normal,s=a.distance,l=e.dot(u,r)+s<0,c=e.dot(u,t)+s<0,f=e.dot(u,o)+s<0,h=0;h+=l?1:0,h+=c?1:0,h+=f?1:0;var w,d;if((1===h||2===h)&&(w=new e,d=new e),1===h){if(l)return m.lineSegmentPlane(r,t,a,w),m.lineSegmentPlane(r,o,a,d),{positions:[r,t,o,w,d],indices:[0,3,4,1,2,4,1,4,3]};if(c)return m.lineSegmentPlane(t,o,a,w),m.lineSegmentPlane(t,r,a,d),{positions:[r,t,o,w,d],indices:[1,3,4,2,0,4,2,4,3]};if(f)return m.lineSegmentPlane(o,r,a,w),m.lineSegmentPlane(o,t,a,d),{positions:[r,t,o,w,d],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===h){if(!l)return m.lineSegmentPlane(t,r,a,w),m.lineSegmentPlane(o,r,a,d),{positions:[r,t,o,w,d],indices:[1,2,4,1,4,3,0,3,4]};if(!c)return m.lineSegmentPlane(o,t,a,w),m.lineSegmentPlane(r,t,a,d),{positions:[r,t,o,w,d],indices:[2,0,4,2,4,3,1,3,4]};if(!f)return m.lineSegmentPlane(r,o,a,w),m.lineSegmentPlane(t,o,a,d),{positions:[r,t,o,w,d],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},m}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var i={};return i.calculateACMR=function(i){i=e(i,e.EMPTY_OBJECT);var n=i.indices,o=i.maximumIndex,a=e(i.cacheSize,24);if(!r(n))throw new t("indices is required.");var u=n.length;if(3>u||u%3!==0)throw new t("indices length must be a multiple of three.");if(0>=o)throw new t("maximumIndex must be greater than zero.");if(3>a)throw new t("cacheSize must be greater than two.");if(!r(o)){o=0;for(var s=0,l=n[s];u>s;)l>o&&(o=l),++s,l=n[s]}for(var c=[],f=0;o+1>f;f++)c[f]=0;for(var h=a+1,w=0;u>w;++w)h-c[n[w]]>a&&(c[n[w]]=h,++h);return(h-a+1)/(u/3)},i.tipsify=function(i){function n(e,r,t,i){for(;r.length>=1;){var n=r[r.length-1];if(r.splice(r.length-1,1),e[n].numLiveTriangles>0)return n}for(;i>a;){if(e[a].numLiveTriangles>0)return++a,a-1;++a}return-1}function o(e,r,t,i,o,a,u){for(var s,l=-1,c=-1,f=0;f<t.length;){var h=t[f];i[h].numLiveTriangles&&(s=0,o-i[h].timeStamp+2*i[h].numLiveTriangles<=r&&(s=o-i[h].timeStamp),(s>c||-1===c)&&(c=s,l=h)),++f}return-1===l?n(i,a,e,u):l}i=e(i,e.EMPTY_OBJECT);var a,u=i.indices,s=i.maximumIndex,l=e(i.cacheSize,24);if(!r(u))throw new t("indices is required.");var c=u.length;if(3>c||c%3!==0)throw new t("indices length must be a multiple of three.");if(0>=s)throw new t("maximumIndex must be greater than zero.");if(3>l)throw new t("cacheSize must be greater than two.");var f=0,h=0,w=u[h],d=c;if(r(s))f=s+1;else{for(;d>h;)w>f&&(f=w),++h,w=u[h];if(-1===f)return 0;++f}for(var m=[],E=0;f>E;E++)m[E]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};h=0;for(var p=0;d>h;)m[u[h]].vertexTriangles.push(p),++m[u[h]].numLiveTriangles,m[u[h+1]].vertexTriangles.push(p),++m[u[h+1]].numLiveTriangles,m[u[h+2]].vertexTriangles.push(p),++m[u[h+2]].numLiveTriangles,++p,h+=3;var y=0,_=l+1;a=1;var T,R,A=[],v=[],N=0,I=[],S=c/3,g=[];for(E=0;S>E;E++)g[E]=!1;for(var M,O;-1!==y;){A=[],R=m[y],O=R.vertexTriangles.length;for(var q=0;O>q;++q)if(p=R.vertexTriangles[q],!g[p]){g[p]=!0,h=p+p+p;for(var x=0;3>x;++x)M=u[h],A.push(M),v.push(M),I[N]=M,++N,T=m[M],--T.numLiveTriangles,_-T.timeStamp>l&&(T.timeStamp=_,++_),++h}y=o(u,l,A,m,_,v,f)}return I},i}),define("Core/GeometryPipeline",["./AttributeCompression","./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryInstance","./GeometryType","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],function(e,r,t,i,n,o,a,u,s,l,c,f,h,w,d,m,E,p,y,_,T,R,A,v,N,I){"use strict";function S(e,r,t,i,n){e[r++]=t,e[r++]=i,e[r++]=i,e[r++]=n,e[r++]=n,e[r]=t}function g(e){for(var r=e.length,t=r/3*6,i=p.createTypedArray(r,t),n=0,o=0;r>o;o+=3,n+=6)S(i,n,e[o],e[o+1],e[o+2]);return i}function M(e){var r=e.length;if(r>=3){var t=6*(r-2),i=p.createTypedArray(r,t);S(i,0,e[0],e[1],e[2]);for(var n=6,o=3;r>o;++o,n+=6)S(i,n,e[o-1],e[o],e[o-2]);return i}return new Uint16Array}function O(e){if(e.length>0){for(var r=e.length-1,t=6*(r-1),i=p.createTypedArray(r,t),n=e[0],o=0,a=1;r>a;++a,o+=6)S(i,o,n,e[a],e[a+1]);return i}return new Uint16Array}function q(e){var r={};for(var t in e)if(e.hasOwnProperty(t)&&l(e[t])&&l(e[t].values)){var i=e[t];r[t]=new d({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]})}return r}function x(e,r,t){for(var i in r)if(r.hasOwnProperty(i)&&l(r[i])&&l(r[i].values))for(var n=r[i],o=0;o<n.componentsPerAttribute;++o)e[i].values.push(n.values[t*n.componentsPerAttribute+o])}function b(e,r){if(l(r))for(var t=r.values,i=t.length,o=0;i>o;o+=3)n.unpack(t,o,oe),A.multiplyByPoint(e,oe,oe),n.pack(oe,t,o)}function P(e,r){if(l(r))for(var t=r.values,i=t.length,o=0;i>o;o+=3)n.unpack(t,o,oe),R.multiplyByVector(e,oe,oe),oe=n.normalize(oe,oe),n.pack(oe,t,o)}function L(e,r){var t,i=e.length,n={},o=e[0][r].attributes;for(t in o)if(o.hasOwnProperty(t)&&l(o[t])&&l(o[t].values)){for(var a=o[t],s=a.values.length,c=!0,f=1;i>f;++f){var h=e[f][r].attributes[t];if(!l(h)||a.componentDatatype!==h.componentDatatype||a.componentsPerAttribute!==h.componentsPerAttribute||a.normalize!==h.normalize){c=!1;break}s+=h.values.length}c&&(n[t]=new d({componentDatatype:a.componentDatatype,componentsPerAttribute:a.componentsPerAttribute,normalize:a.normalize,values:u.createTypedArray(a.componentDatatype,s)}))}return n}function C(e,r){var i,o,a,u,s=e.length,f=e[0].modelMatrix,h=l(e[0][r].indices),d=e[0][r].primitiveType;for(o=1;s>o;++o){if(!A.equals(e[o].modelMatrix,f))throw new c("All instances must have the same modelMatrix.");if(l(e[o][r].indices)!==h)throw new c("All instance geometries must have an indices or not have one.");if(e[o][r].primitiveType!==d)throw new c("All instance geometries must have the same primitiveType.")}var m,E,y,_=L(e,r);for(i in _)if(_.hasOwnProperty(i))for(m=_[i].values,u=0,o=0;s>o;++o)for(E=e[o][r].attributes[i].values,y=E.length,a=0;y>a;++a)m[u++]=E[a];var T;if(h){var R=0;for(o=0;s>o;++o)R+=e[o][r].indices.length;var v=w.computeNumberOfVertices(new w({attributes:_,primitiveType:N.POINTS})),I=p.createTypedArray(v,R),S=0,g=0;for(o=0;s>o;++o){var M=e[o][r].indices,O=M.length;for(u=0;O>u;++u)I[S++]=g+M[u];g+=w.computeNumberOfVertices(e[o][r])}T=I}var q,x=new n,b=0;for(o=0;s>o;++o){if(q=e[o][r].boundingSphere,!l(q)){x=void 0;break}n.add(q.center,x,x)}if(l(x))for(n.divideByScalar(x,s,x),o=0;s>o;++o){q=e[o][r].boundingSphere;var P=n.magnitude(n.subtract(q.center,x,se))+q.radius;P>b&&(b=P)}return new w({attributes:_,indices:T,primitiveType:d,boundingSphere:l(x)?new t(x,b):void 0})}function F(e){if(l(e.indices))return e;var r=w.computeNumberOfVertices(e);if(3>r)throw new c("The number of vertices must be at least three.");if(r%3!==0)throw new c("The number of vertices must be a multiple of three.");for(var t=p.createTypedArray(r,r),i=0;r>i;++i)t[i]=i;return e.indices=t,e}function U(e){var r=w.computeNumberOfVertices(e);if(3>r)throw new c("The number of vertices must be at least three.");var t=p.createTypedArray(r,3*(r-2));t[0]=1,t[1]=0,t[2]=2;for(var i=3,n=3;r>n;++n)t[i++]=n-1,t[i++]=0,t[i++]=n;return e.indices=t,e.primitiveType=N.TRIANGLES,e}function D(e){var r=w.computeNumberOfVertices(e);if(3>r)throw new c("The number of vertices must be at least 3.");var t=p.createTypedArray(r,3*(r-2));t[0]=0,t[1]=1,t[2]=2,r>3&&(t[3]=0,t[4]=2,t[5]=3);for(var i=6,n=3;r-1>n;n+=2)t[i++]=n,t[i++]=n-1,t[i++]=n+1,r>n+2&&(t[i++]=n,t[i++]=n+1,t[i++]=n+2);return e.indices=t,e.primitiveType=N.TRIANGLES,e}function B(e){if(l(e.indices))return e;var r=w.computeNumberOfVertices(e);if(2>r)throw new c("The number of vertices must be at least two.");if(r%2!==0)throw new c("The number of vertices must be a multiple of 2.");for(var t=p.createTypedArray(r,r),i=0;r>i;++i)t[i]=i;return e.indices=t,e}function z(e){var r=w.computeNumberOfVertices(e);if(2>r)throw new c("The number of vertices must be at least two.");var t=p.createTypedArray(r,2*(r-1));t[0]=0,t[1]=1;for(var i=2,n=2;r>n;++n)t[i++]=n-1,t[i++]=n;return e.indices=t,e.primitiveType=N.LINES,e}function G(e){var r=w.computeNumberOfVertices(e);if(2>r)throw new c("The number of vertices must be at least two.");var t=p.createTypedArray(r,2*r);t[0]=0,t[1]=1;for(var i=2,n=2;r>n;++n)t[i++]=n-1,t[i++]=n;return t[i++]=r-1,t[i]=0,e.indices=t,e.primitiveType=N.LINES,e}function V(e){switch(e.primitiveType){case N.TRIANGLE_FAN:return U(e);case N.TRIANGLE_STRIP:return D(e);case N.TRIANGLES:return F(e);case N.LINE_STRIP:return z(e);case N.LINE_LOOP:return G(e);case N.LINES:return B(e)}return e}function H(e,r){Math.abs(e.y)<T.EPSILON6&&(r?e.y=-T.EPSILON6:e.y=T.EPSILON6)}function X(e,r,t){if(0!==e.y&&0!==r.y&&0!==t.y)return H(e,e.y<0),H(r,r.y<0),void H(t,t.y<0);var i,n=Math.abs(e.y),o=Math.abs(r.y),a=Math.abs(t.y);i=n>o?n>a?T.sign(e.y):T.sign(t.y):o>a?T.sign(r.y):T.sign(t.y);var u=0>i;H(e,u),H(r,u),H(t,u)}function W(e,r,t,i){n.add(e,n.multiplyByScalar(n.subtract(r,e,Te),e.y/(e.y-r.y),Te),t),n.clone(t,i),H(t,!0),H(i,!1)}function Y(e,r,t){if(e.x>=0||r.x>=0||t.x>=0)return void 0;X(e,r,t);var i=e.y<0,n=r.y<0,o=t.y<0,a=0;a+=i?1:0,a+=n?1:0,a+=o?1:0;var u=Ie.indices;1===a?(u[1]=3,u[2]=4,u[5]=6,u[7]=6,u[8]=5,i?(W(e,r,Re,ve),W(e,t,Ae,Ne),u[0]=0,u[3]=1,u[4]=2,u[6]=1):n?(W(r,t,Re,ve),W(r,e,Ae,Ne),u[0]=1,u[3]=2,u[4]=0,u[6]=2):o&&(W(t,e,Re,ve),W(t,r,Ae,Ne),u[0]=2,u[3]=0,u[4]=1,u[6]=0)):2===a&&(u[2]=4,u[4]=4,u[5]=3,u[7]=5,u[8]=6,i?n?o||(W(t,e,Re,ve),W(t,r,Ae,Ne),u[0]=0,u[1]=1,u[3]=0,u[6]=2):(W(r,t,Re,ve),W(r,e,Ae,Ne),u[0]=2,u[1]=0,u[3]=2,u[6]=1):(W(e,r,Re,ve),W(e,t,Ae,Ne),u[0]=1,u[1]=2,u[3]=1,u[6]=0));var s=Ie.positions;return s[0]=e,s[1]=r,s[2]=t,s.length=3,(1===a||2===a)&&(s[3]=Re,s[4]=Ae,s[5]=ve,s[6]=Ne,s.length=7),Ie}function k(e,r){var i=e.attributes;if(0===i.position.values.length)return void 0;for(var n in i)if(i.hasOwnProperty(n)&&l(i[n])&&l(i[n].values)){var o=i[n];o.values=u.createTypedArray(o.componentDatatype,o.values)}var a=w.computeNumberOfVertices(e);return e.indices=p.createTypedArray(a,e.indices),r&&(e.boundingSphere=t.fromVertices(i.position.values)),e}function K(e){var r=e.attributes,t={};for(var i in r)if(r.hasOwnProperty(i)&&l(r[i])&&l(r[i].values)){var n=r[i];t[i]=new d({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return new w({attributes:t,indices:[],primitiveType:e.primitiveType})}function j(e,r,t){var i=l(e.geometry.boundingSphere);r=k(r,i),t=k(t,i),l(t)&&!l(r)?e.geometry=t:!l(t)&&l(r)?e.geometry=r:(e.westHemisphereGeometry=r,e.eastHemisphereGeometry=t,e.geometry=void 0)}function Z(e,t,o,a,u,s,c,f,h,w,d){if(l(s)||l(c)||l(f)||l(h)){var m=n.fromArray(u,3*e,Se),E=n.fromArray(u,3*t,ge),p=n.fromArray(u,3*o,Me),y=r(a,m,E,p,Oe);if(l(s)){var _=n.fromArray(s,3*e,Se),T=n.fromArray(s,3*t,ge),R=n.fromArray(s,3*o,Me);n.multiplyByScalar(_,y.x,_),n.multiplyByScalar(T,y.y,T),n.multiplyByScalar(R,y.z,R);var A=n.add(_,T,_);n.add(A,R,A),n.normalize(A,A),n.pack(A,w.normal.values,3*d)}if(l(c)){var v=n.fromArray(c,3*e,Se),N=n.fromArray(c,3*t,ge),I=n.fromArray(c,3*o,Me);n.multiplyByScalar(v,y.x,v),n.multiplyByScalar(N,y.y,N),n.multiplyByScalar(I,y.z,I);var S=n.add(v,N,v);n.add(S,I,S),n.normalize(S,S),n.pack(S,w.binormal.values,3*d)}if(l(f)){var g=n.fromArray(f,3*e,Se),M=n.fromArray(f,3*t,ge),O=n.fromArray(f,3*o,Me);n.multiplyByScalar(g,y.x,g),n.multiplyByScalar(M,y.y,M),n.multiplyByScalar(O,y.z,O);var q=n.add(g,M,g);n.add(q,O,q),n.normalize(q,q),n.pack(q,w.tangent.values,3*d)}if(l(h)){var x=i.fromArray(h,2*e,qe),b=i.fromArray(h,2*t,xe),P=i.fromArray(h,2*o,be);i.multiplyByScalar(x,y.x,x),i.multiplyByScalar(b,y.y,b),i.multiplyByScalar(P,y.z,P);var L=i.add(x,b,x);i.add(L,P,L),i.pack(L,w.st.values,2*d)}}}function Q(e,r,t,i,n,o){var a=e.position.values.length/3;if(-1!==n){var u=i[n],s=t[u];return-1===s?(t[u]=a,e.position.values.push(o.x,o.y,o.z),r.push(a),a):(r.push(s),s)}return e.position.values.push(o.x,o.y,o.z),r.push(a),a}function J(e){var r,t,i,o,a,u=e.geometry,s=u.attributes,c=s.position.values,f=l(s.normal)?s.normal.values:void 0,h=l(s.binormal)?s.binormal.values:void 0,w=l(s.tangent)?s.tangent.values:void 0,d=l(s.st)?s.st.values:void 0,m=u.indices,E=K(u),p=K(u),y=[];y.length=c.length/3;var _=[];for(_.length=c.length/3,a=0;a<y.length;++a)y[a]=-1,_[a]=-1;var T=m.length;for(a=0;T>a;a+=3){var R=m[a],A=m[a+1],v=m[a+2],N=n.fromArray(c,3*R),I=n.fromArray(c,3*A),S=n.fromArray(c,3*v),g=Y(N,I,S);if(l(g)&&g.positions.length>3)for(var M=g.positions,O=g.indices,q=O.length,x=0;q>x;++x){var b=O[x],P=M[b];P.y<0?(r=p.attributes,t=p.indices,i=y):(r=E.attributes,t=E.indices,i=_),o=Q(r,t,i,m,3>b?a+b:-1,P),Z(R,A,v,P,c,f,h,w,d,r,o)}else l(g)&&(N=g.positions[0],I=g.positions[1],S=g.positions[2]),N.y<0?(r=p.attributes,t=p.indices,i=y):(r=E.attributes,t=E.indices,i=_),o=Q(r,t,i,m,a,N),Z(R,A,v,N,c,f,h,w,d,r,o),o=Q(r,t,i,m,a+1,I),Z(R,A,v,I,c,f,h,w,d,r,o),o=Q(r,t,i,m,a+2,S),Z(R,A,v,S,c,f,h,w,d,r,o)}j(e,p,E)}function $(e){var r,t=e.geometry,i=t.attributes,o=i.position.values,a=t.indices,u=K(t),s=K(t),c=a.length,f=[];f.length=o.length/3;var h=[];for(h.length=o.length/3,r=0;r<f.length;++r)f[r]=-1,h[r]=-1;for(r=0;c>r;r+=2){var w=a[r],d=a[r+1],m=n.fromArray(o,3*w,Se),E=n.fromArray(o,3*d,ge);Math.abs(m.y)<T.EPSILON6&&(m.y<0?m.y=-T.EPSILON6:m.y=T.EPSILON6),Math.abs(E.y)<T.EPSILON6&&(E.y<0?E.y=-T.EPSILON6:E.y=T.EPSILON6);var p=u.attributes,y=u.indices,R=h,A=s.attributes,v=s.indices,N=f,I=_.lineSegmentPlane(m,E,Pe,Me);if(l(I)){var S=n.multiplyByScalar(n.UNIT_Y,5*T.EPSILON9,Le);m.y<0&&(n.negate(S,S),p=s.attributes,y=s.indices,R=f,A=u.attributes,v=u.indices,N=h);var g=n.add(I,S,Ce);Q(p,y,R,a,r,m),Q(p,y,R,a,-1,g),n.negate(S,S),n.add(I,S,g),Q(A,v,N,a,-1,g),Q(A,v,N,a,r+1,E)}else{var M,O,q;m.y<0?(M=s.attributes,O=s.indices,q=f):(M=u.attributes,O=u.indices,q=h),Q(M,O,q,a,r,m),Q(M,O,q,a,r+1,E)}}j(e,s,u)}function ee(e){var r,t,a,u=e.geometry,s=u.attributes,c=s.position.values,f=s.prevPosition.values,h=s.nextPosition.values,w=s.expandAndWidth.values,d=(u.indices,l(s.st)?s.st.values:void 0),m=l(s.color)?s.color.values:void 0,E=K(u),p=K(u),y=c.length/3;for(r=0;y>r;r+=4){var R=r,A=r+1,v=r+2,N=r+3,I=n.fromArray(c,3*R,De),S=n.fromArray(c,3*A,Be),g=n.fromArray(c,3*v,ze),M=n.fromArray(c,3*N,Ge);Math.abs(I.y)<T.EPSILON6&&(I.y=T.EPSILON6*(g.y<0?-1:1),S.y=I.y),Math.abs(g.y)<T.EPSILON6&&(g.y=T.EPSILON6*(I.y<0?-1:1),M.y=g.y);var O=E.attributes,q=E.indices,x=p.attributes,b=p.indices,P=_.lineSegmentPlane(I,g,Pe,Ve);if(l(P)){var L=n.multiplyByScalar(n.UNIT_Y,5*T.EPSILON9,He);I.y<0&&(n.negate(L,L),O=p.attributes,q=p.indices,x=E.attributes,b=E.indices);var C=n.add(P,L,Xe);for(O.position.values.push(I.x,I.y,I.z,S.x,S.y,S.z),O.position.values.push(C.x,C.y,C.z),O.position.values.push(C.x,C.y,C.z),n.negate(L,L),n.add(P,L,C),x.position.values.push(C.x,C.y,C.z),x.position.values.push(C.x,C.y,C.z),x.position.values.push(g.x,g.y,g.z,M.x,M.y,M.z),t=3*R;3*R+6>t;++t)O.prevPosition.values.push(f[t]);for(O.prevPosition.values.push(I.x,I.y,I.z,I.x,I.y,I.z),x.prevPosition.values.push(I.x,I.y,I.z,I.x,I.y,I.z),t=3*v;3*v+6>t;++t)x.prevPosition.values.push(f[t]);for(t=3*R;3*R+6>t;++t)O.nextPosition.values.push(h[t]);for(O.nextPosition.values.push(g.x,g.y,g.z,g.x,g.y,g.z),x.nextPosition.values.push(g.x,g.y,g.z,g.x,g.y,g.z),t=3*v;3*v+6>t;++t)x.nextPosition.values.push(h[t]);var F=i.fromArray(w,2*R,Fe),U=Math.abs(F.y);O.expandAndWidth.values.push(-1,U,1,U),O.expandAndWidth.values.push(-1,-U,1,-U),x.expandAndWidth.values.push(-1,U,1,U),x.expandAndWidth.values.push(-1,-U,1,-U);var D=n.magnitudeSquared(n.subtract(P,I,Ge));if(D/=n.magnitudeSquared(n.subtract(g,I,Ge)),l(m)){var B=o.fromArray(m,4*R,We),z=o.fromArray(m,4*v,We),G=T.lerp(B.x,z.x,D),V=T.lerp(B.y,z.y,D),H=T.lerp(B.z,z.z,D),X=T.lerp(B.w,z.w,D);for(t=4*R;4*R+8>t;++t)O.color.values.push(m[t]);for(O.color.values.push(G,V,H,X),O.color.values.push(G,V,H,X),x.color.values.push(G,V,H,X),x.color.values.push(G,V,H,X),t=4*v;4*v+8>t;++t)x.color.values.push(m[t])}if(l(d)){var W=i.fromArray(d,2*R,Fe),Y=i.fromArray(d,2*(r+3),Ue),k=T.lerp(W.x,Y.x,D);for(t=2*R;2*R+4>t;++t)O.st.values.push(d[t]);for(O.st.values.push(k,W.y),O.st.values.push(k,Y.y),x.st.values.push(k,W.y),x.st.values.push(k,Y.y),t=2*v;2*v+4>t;++t)x.st.values.push(d[t])}a=O.position.values.length/3-4,q.push(a,a+2,a+1),q.push(a+1,a+2,a+3),a=x.position.values.length/3-4,b.push(a,a+2,a+1),b.push(a+1,a+2,a+3)}else{var Z,Q;for(I.y<0?(Z=p.attributes,Q=p.indices):(Z=E.attributes,Q=E.indices),Z.position.values.push(I.x,I.y,I.z),Z.position.values.push(S.x,S.y,S.z),Z.position.values.push(g.x,g.y,g.z),Z.position.values.push(M.x,M.y,M.z),t=3*r;3*r+12>t;++t)Z.prevPosition.values.push(f[t]),Z.nextPosition.values.push(h[t]);for(t=2*r;2*r+8>t;++t)Z.expandAndWidth.values.push(w[t]),l(d)&&Z.st.values.push(d[t]);if(l(m))for(t=4*r;4*r+16>t;++t)Z.color.values.push(m[t]);a=Z.position.values.length/3-4,Q.push(a,a+2,a+1),Q.push(a+1,a+2,a+3)}}j(e,p,E)}var re={};re.toWireframe=function(e){if(!l(e))throw new c("geometry is required.");var r=e.indices;if(l(r)){switch(e.primitiveType){case N.TRIANGLES:e.indices=g(r);break;case N.TRIANGLE_STRIP:e.indices=M(r);break;case N.TRIANGLE_FAN:e.indices=O(r);break;default:throw new c("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=N.LINES}return e},re.createLineSegmentsForVectors=function(e,r,i){if(r=s(r,"normal"),!l(e))throw new c("geometry is required.");if(!l(e.attributes.position))throw new c("geometry.attributes.position is required.");if(!l(e.attributes[r]))throw new c("geometry.attributes must have an attribute with the same name as the attributeName parameter, "+r+".");i=s(i,1e4);for(var n=e.attributes.position.values,o=e.attributes[r].values,a=n.length,f=new Float64Array(2*a),h=0,m=0;a>m;m+=3)f[h++]=n[m],f[h++]=n[m+1],f[h++]=n[m+2],f[h++]=n[m]+o[m]*i,f[h++]=n[m+1]+o[m+1]*i,f[h++]=n[m+2]+o[m+2]*i;var E,p=e.boundingSphere;return l(p)&&(E=new t(p.center,p.radius+i)),new w({attributes:{position:new d({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:f})},primitiveType:N.LINES,boundingSphere:E})},re.createAttributeLocations=function(e){if(!l(e))throw new c("geometry is required.");var r,t=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent","compressedAttributes"],i=e.attributes,n={},o=0,a=t.length;for(r=0;a>r;++r){var u=t[r];l(i[u])&&(n[u]=o++)}for(var s in i)i.hasOwnProperty(s)&&!l(n[s])&&(n[s]=o++);return n},re.reorderForPreVertexCache=function(e){if(!l(e))throw new c("geometry is required.");var r=w.computeNumberOfVertices(e),t=e.indices;if(l(t)){for(var i=new Int32Array(r),n=0;r>n;n++)i[n]=-1;for(var o,a=t,s=a.length,f=p.createTypedArray(r,s),h=0,d=0,m=0;s>h;)o=i[a[h]],-1!==o?f[d]=o:(o=a[h],i[o]=m,f[d]=m,++m),++h,++d;e.indices=f;var E=e.attributes;for(var y in E)if(E.hasOwnProperty(y)&&l(E[y])&&l(E[y].values)){for(var _=E[y],T=_.values,R=0,A=_.componentsPerAttribute,v=u.createTypedArray(_.componentDatatype,m*A);r>R;){var N=i[R];if(-1!==N)for(n=0;A>n;n++)v[A*N+n]=T[A*R+n];++R}_.values=v}}return e},re.reorderForPostVertexCache=function(e,r){if(!l(e))throw new c("geometry is required.");var t=e.indices;if(e.primitiveType===N.TRIANGLES&&l(t)){for(var i=t.length,n=0,o=0;i>o;o++)t[o]>n&&(n=t[o]);e.indices=I.tipsify({indices:t,maximumIndex:n,cacheSize:r})}return e},re.fitToUnsignedShortIndices=function(e){if(!l(e))throw new c("geometry is required.");if(l(e.indices)&&e.primitiveType!==N.TRIANGLES&&e.primitiveType!==N.LINES&&e.primitiveType!==N.POINTS)throw new c("geometry.primitiveType must equal to PrimitiveType.TRIANGLES, PrimitiveType.LINES, or PrimitiveType.POINTS.");var r=[],t=w.computeNumberOfVertices(e);if(l(e.indices)&&t>=T.SIXTY_FOUR_KILOBYTES){var i,n=[],o=[],a=0,u=q(e.attributes),s=e.indices,f=s.length;e.primitiveType===N.TRIANGLES?i=3:e.primitiveType===N.LINES?i=2:e.primitiveType===N.POINTS&&(i=1);for(var h=0;f>h;h+=i){for(var d=0;i>d;++d){var m=s[h+d],E=n[m];l(E)||(E=a++,n[m]=E,x(u,e.attributes,m)),o.push(E)}a+i>=T.SIXTY_FOUR_KILOBYTES&&(r.push(new w({attributes:u,indices:o,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),n=[],o=[],a=0,u=q(e.attributes))}0!==o.length&&r.push(new w({attributes:u,indices:o,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else r.push(e);return r};var te=new n,ie=new a;re.projectTo2D=function(e,r,t,i,o){if(!l(e))throw new c("geometry is required.");if(!l(r))throw new c("attributeName is required.");if(!l(t))throw new c("attributeName3D is required.");if(!l(i))throw new c("attributeName2D is required.");if(!l(e.attributes[r]))throw new c("geometry must have attribute matching the attributeName argument: "+r+".");if(e.attributes[r].componentDatatype!==u.DOUBLE)throw new c("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");var a=e.attributes[r];o=l(o)?o:new h;for(var s=o.ellipsoid,f=a.values,w=new Float64Array(f.length),m=0,E=0;E<f.length;E+=3){var p=n.fromArray(f,E,te),y=s.cartesianToCartographic(p,ie);if(!l(y))throw new c("Could not project point ("+p.x+", "+p.y+", "+p.z+") to 2D.");var _=o.project(y,te);w[m++]=_.x,w[m++]=_.y,w[m++]=_.z}return e.attributes[t]=a,e.attributes[i]=new d({componentDatatype:u.DOUBLE,componentsPerAttribute:3,values:w}),delete e.attributes[r],e};var ne={high:0,low:0};re.encodeAttribute=function(e,r,t,i){if(!l(e))throw new c("geometry is required.");if(!l(r))throw new c("attributeName is required.");if(!l(t))throw new c("attributeHighName is required.");if(!l(i))throw new c("attributeLowName is required.");if(!l(e.attributes[r]))throw new c("geometry must have attribute matching the attributeName argument: "+r+".");if(e.attributes[r].componentDatatype!==u.DOUBLE)throw new c("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");for(var n=e.attributes[r],o=n.values,a=o.length,s=new Float32Array(a),h=new Float32Array(a),w=0;a>w;++w)f.encode(o[w],ne),s[w]=ne.high,h[w]=ne.low;var m=n.componentsPerAttribute;return e.attributes[t]=new d({componentDatatype:u.FLOAT,componentsPerAttribute:m,values:s}),e.attributes[i]=new d({componentDatatype:u.FLOAT,componentsPerAttribute:m,values:h}),delete e.attributes[r],e};var oe=new n,ae=new A,ue=new R;re.transformToWorldCoordinates=function(e){if(!l(e))throw new c("instance is required.");var r=e.modelMatrix;if(A.equals(r,A.IDENTITY))return e;var i=e.geometry.attributes;b(r,i.position),b(r,i.prevPosition),b(r,i.nextPosition),(l(i.normal)||l(i.binormal)||l(i.tangent))&&(A.inverse(r,ae),A.transpose(ae,ae),A.getRotation(ae,ue),P(ue,i.normal),P(ue,i.binormal),P(ue,i.tangent));var n=e.geometry.boundingSphere;return l(n)&&(e.geometry.boundingSphere=t.transform(n,r,n)),e.modelMatrix=A.clone(A.IDENTITY),e};var se=new n;re.combineInstances=function(e){if(!l(e)||e.length<1)throw new c("instances is required and must have length greater than zero.");for(var r=[],t=[],i=e.length,n=0;i>n;++n){var o=e[n];l(o.geometry)?r.push(o):t.push(o)}var a=[];return r.length>0&&a.push(C(r,"geometry")),t.length>0&&(a.push(C(t,"westHemisphereGeometry")),a.push(C(t,"eastHemisphereGeometry"))),a};var le=new n,ce=new n,fe=new n,he=new n;re.computeNormal=function(e){if(!l(e))throw new c("geometry is required.");if(!l(e.attributes.position)||!l(e.attributes.position.values))throw new c("geometry.attributes.position.values is required.");if(!l(e.indices))throw new c("geometry.indices is required.");if(e.indices.length<2||e.indices.length%3!==0)throw new c("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==N.TRIANGLES)throw new c("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var r=e.indices,t=e.attributes,i=t.position.values,o=t.position.values.length/3,a=r.length,s=new Array(o),f=new Array(a/3),h=new Array(a),w=0;o>w;w++)s[w]={indexOffset:0,count:0,currentCount:0};var m=0;for(w=0;a>w;w+=3){var E=r[w],p=r[w+1],y=r[w+2],_=3*E,T=3*p,R=3*y;ce.x=i[_],ce.y=i[_+1],ce.z=i[_+2],fe.x=i[T],fe.y=i[T+1],fe.z=i[T+2],he.x=i[R],he.y=i[R+1],he.z=i[R+2],s[E].count++,s[p].count++,s[y].count++,n.subtract(fe,ce,fe),n.subtract(he,ce,he),f[m]=n.cross(fe,he,new n),m++}var A=0;for(w=0;o>w;w++)s[w].indexOffset+=A,A+=s[w].count;m=0;var v;for(w=0;a>w;w+=3){v=s[r[w]];var I=v.indexOffset+v.currentCount;h[I]=m,v.currentCount++,v=s[r[w+1]],I=v.indexOffset+v.currentCount,h[I]=m,v.currentCount++,v=s[r[w+2]],I=v.indexOffset+v.currentCount,h[I]=m,v.currentCount++,m++}var S=new Float32Array(3*o);for(w=0;o>w;w++){var g=3*w;if(v=s[w],v.count>0){for(n.clone(n.ZERO,le),m=0;m<v.count;m++)n.add(le,f[h[v.indexOffset+m]],le);n.normalize(le,le),S[g]=le.x,S[g+1]=le.y,S[g+2]=le.z}else S[g]=0,S[g+1]=0,S[g+2]=1}return e.attributes.normal=new d({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:S}),e};var we=new n,de=new n,me=new n;re.computeBinormalAndTangent=function(e){if(!l(e))throw new c("geometry is required.");var r=e.attributes,t=e.indices;if(!l(r.position)||!l(r.position.values))throw new c("geometry.attributes.position.values is required.");if(!l(r.normal)||!l(r.normal.values))throw new c("geometry.attributes.normal.values is required.");if(!l(r.st)||!l(r.st.values))throw new c("geometry.attributes.st.values is required.");if(!l(t))throw new c("geometry.indices is required.");if(t.length<2||t.length%3!==0)throw new c("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==N.TRIANGLES)throw new c("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var i=e.attributes.position.values,o=e.attributes.normal.values,a=e.attributes.st.values,s=e.attributes.position.values.length/3,f=t.length,h=new Array(3*s),w=0;w<h.length;w++)h[w]=0;var m,E,p;for(w=0;f>w;w+=3){var y=t[w],_=t[w+1],T=t[w+2];m=3*y,E=3*_,p=3*T;var R=2*y,A=2*_,v=2*T,I=i[m],S=i[m+1],g=i[m+2],M=a[R],O=a[R+1],q=a[A+1]-O,x=a[v+1]-O,b=1/((a[A]-M)*x-(a[v]-M)*q),P=(x*(i[E]-I)-q*(i[p]-I))*b,L=(x*(i[E+1]-S)-q*(i[p+1]-S))*b,C=(x*(i[E+2]-g)-q*(i[p+2]-g))*b;h[m]+=P,h[m+1]+=L,h[m+2]+=C,h[E]+=P,h[E+1]+=L,h[E+2]+=C,h[p]+=P,h[p+1]+=L,h[p+2]+=C}var F=new Float32Array(3*s),U=new Float32Array(3*s);for(w=0;s>w;w++){m=3*w,E=m+1,p=m+2;var D=n.fromArray(o,m,we),B=n.fromArray(h,m,me),z=n.dot(D,B);n.multiplyByScalar(D,z,de),n.normalize(n.subtract(B,de,B),B),U[m]=B.x,U[E]=B.y,U[p]=B.z,n.normalize(n.cross(D,B,B),B),F[m]=B.x,F[E]=B.y,F[p]=B.z}return e.attributes.tangent=new d({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:U}),e.attributes.binormal=new d({componentDatatype:u.FLOAT,componentsPerAttribute:3,values:F}),e};var Ee=new i,pe=new n,ye=new n,_e=new n;re.compressVertices=function(r){if(!l(r))throw new c("geometry is required.");var t=r.attributes.normal,o=r.attributes.st;if(!l(t)&&!l(o))return r;var a,s,f,h,w=r.attributes.tangent,m=r.attributes.binormal;l(t)&&(a=t.values),l(o)&&(s=o.values),l(w)&&(f=w.values),m&&(h=m.values);var E=l(a)?a.length:s.length,p=l(a)?3:2,y=E/p,_=y,T=l(s)&&l(a)?2:1;T+=l(f)||l(h)?1:0,_*=T;for(var R=new Float32Array(_),A=0,v=0;y>v;++v){l(s)&&(i.fromArray(s,2*v,Ee),R[A++]=e.compressTextureCoordinates(Ee));var N=3*v;l(a)&&l(f)&&l(h)?(n.fromArray(a,N,pe),n.fromArray(f,N,ye),n.fromArray(h,N,_e),e.octPack(pe,ye,_e,Ee),R[A++]=Ee.x,R[A++]=Ee.y):(l(a)&&(n.fromArray(a,N,pe),R[A++]=e.octEncodeFloat(pe)),l(f)&&(n.fromArray(f,N,pe),R[A++]=e.octEncodeFloat(pe)),l(h)&&(n.fromArray(h,N,pe),R[A++]=e.octEncodeFloat(pe)))}return r.attributes.compressedAttributes=new d({componentDatatype:u.FLOAT,componentsPerAttribute:T,values:R}),l(a)&&delete r.attributes.normal,l(s)&&delete r.attributes.st,l(f)&&delete r.attributes.tangent,l(h)&&delete r.attributes.binormal,r};var Te=new n,Re=new n,Ae=new n,ve=new n,Ne=new n,Ie={positions:new Array(7),indices:new Array(9)},Se=new n,ge=new n,Me=new n,Oe=new n,qe=new i,xe=new i,be=new i,Pe=v.fromPointNormal(n.ZERO,n.UNIT_Y),Le=new n,Ce=new n,Fe=new i,Ue=new i,De=new n,Be=new n,ze=new n,Ge=new n,Ve=new n,He=new n,Xe=new n,We=new o;new o;return re.splitLongitude=function(e){if(!l(e))throw new c("instance is required.");var r=e.geometry,i=r.boundingSphere;if(l(i)){var n=i.center.x-i.radius;if(n>0||t.intersectPlane(i,v.ORIGIN_ZX_PLANE)!==y.INTERSECTING)return e}if(r.geometryType!==E.NONE)switch(r.geometryType){case E.POLYLINES:ee(e);break;case E.TRIANGLES:J(e);break;case E.LINES:$(e)}else V(r),r.primitiveType===N.TRIANGLES?J(e):r.primitiveType===N.LINES&&$(e);return e},re}),define("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,r,t,i){"use strict";var n=function(r){r=e(r,e.EMPTY_OBJECT),this.position=e(r.position,!1),this.normal=e(r.normal,!1),this.st=e(r.st,!1),this.binormal=e(r.binormal,!1),this.tangent=e(r.tangent,!1),this.color=e(r.color,!1)};return n.POSITION_ONLY=i(new n({position:!0})),n.POSITION_AND_NORMAL=i(new n({position:!0,normal:!0})),n.POSITION_NORMAL_AND_ST=i(new n({position:!0,normal:!0,st:!0})),n.POSITION_AND_ST=i(new n({position:!0,st:!0})),n.POSITION_AND_COLOR=i(new n({position:!0,color:!0})),n.ALL=i(new n({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),n.DEFAULT=n.POSITION_NORMAL_AND_ST,n.packedLength=6,n.pack=function(i,n,o){if(!r(i))throw new t("value is required");if(!r(n))throw new t("array is required");o=e(o,0),n[o++]=i.position?1:0,n[o++]=i.normal?1:0,n[o++]=i.st?1:0,n[o++]=i.binormal?1:0,n[o++]=i.tangent?1:0,n[o++]=i.color?1:0},n.unpack=function(i,o,a){if(!r(i))throw new t("array is required");return o=e(o,0),r(a)||(a=new n),a.position=1===i[o++],a.normal=1===i[o++],a.st=1===i[o++],a.binormal=1===i[o++],a.tangent=1===i[o++],a.color=1===i[o++],a},n.clone=function(e,t){return r(e)?(r(t)||(t=new n),t.position=e.position,t.normal=e.normal,t.st=e.st,t.binormal=e.binormal,t.tangent=e.tangent,t.color=e.color,t):void 0},n}),define("Core/EllipseGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EllipseGeometryLibrary","./Ellipsoid","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./Matrix3","./PrimitiveType","./Quaternion","./VertexFormat"],function(e,r,t,i,n,o,a,u,s,l,c,f,h,w,d,m,E,p,y,_,T,R){"use strict";function A(e,i,o){var a=i.vertexFormat,u=i.center,l=i.semiMajorAxis,f=i.semiMinorAxis,d=i.ellipsoid,m=i.stRotation,E=o?e.length/3*2:e.length/3,p=a.st?new Float32Array(2*E):void 0,_=a.normal?new Float32Array(3*E):void 0,R=a.tangent?new Float32Array(3*E):void 0,A=a.binormal?new Float32Array(3*E):void 0,v=0,N=C,I=F,S=U,g=new c(d),x=g.project(d.cartesianToCartographic(u,D),B),V=d.scaleToGeodeticSurface(u,M);d.geodeticSurfaceNormal(V,V);for(var H=T.fromAxisAngle(V,m,L),X=y.fromQuaternion(H,P),W=r.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,z),Y=r.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,G),k=e.length,K=o?k:0,j=K/3*2,Z=0;k>Z;Z+=3){var Q=Z+1,J=Z+2,$=t.fromArray(e,Z,M);if(a.st){var ee=y.multiplyByVector(X,$,O),re=g.project(d.cartesianToCartographic(ee,D),q);t.subtract(re,x,re),b.x=(re.x+l)/(2*l),b.y=(re.y+f)/(2*f),W.x=Math.min(b.x,W.x),W.y=Math.min(b.y,W.y),Y.x=Math.max(b.x,Y.x),Y.y=Math.max(b.y,Y.y),o&&(p[v+j]=b.x,p[v+1+j]=b.y),p[v++]=b.x,p[v++]=b.y}N=d.geodeticSurfaceNormal($,N),(a.normal||a.tangent||a.binormal)&&((a.tangent||a.binormal)&&(I=t.cross(t.UNIT_Z,N,I),y.multiplyByVector(X,I,I)),a.normal&&(_[Z]=N.x,_[Q]=N.y,_[J]=N.z,o&&(_[Z+K]=-N.x,_[Q+K]=-N.y,_[J+K]=-N.z)),a.tangent&&(R[Z]=I.x,R[Q]=I.y,R[J]=I.z,o&&(R[Z+K]=-I.x,
R[Q+K]=-I.y,R[J+K]=-I.z)),a.binormal&&(S=t.cross(N,I,S),A[Z]=S.x,A[Q]=S.y,A[J]=S.z,o&&(A[Z+K]=S.x,A[Q+K]=S.y,A[J+K]=S.z)))}if(a.st){k=p.length;for(var te=0;k>te;te+=2)p[te]=(p[te]-W.x)/(Y.x-W.x),p[te+1]=(p[te+1]-W.y)/(Y.y-W.y)}var ie=new w;if(a.position){var ne=s.raisePositionsToHeight(e,i,o);ie.position=new h({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:ne})}return a.st&&(ie.st=new h({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:p})),a.normal&&(ie.normal=new h({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:_})),a.tangent&&(ie.tangent=new h({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:R})),a.binormal&&(ie.binormal=new h({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:A})),ie}function v(e){var r,t,i,n,o,a=new Array(2*e*(e+1)),u=0;for(n=1;e>n;++n){for(i=n*(n+1),r=(n-1)*n,a[u++]=i++,a[u++]=r,a[u++]=i,t=2*n,o=0;t-1>o;++o)a[u++]=i,a[u++]=r++,a[u++]=r,a[u++]=i++,a[u++]=r,a[u++]=i;a[u++]=i++,a[u++]=r,a[u++]=i}for(t=2*e,++i,++r,n=0;t-1>n;++n)a[u++]=i,a[u++]=r++,a[u++]=r,a[u++]=i++,a[u++]=r,a[u++]=i;for(++r,++i,n=e-1;n>0;--n){for(a[u++]=r++,a[u++]=r,a[u++]=i,t=2*n,o=0;t-1>o;++o)a[u++]=i,a[u++]=r++,a[u++]=r,a[u++]=i++,a[u++]=r,a[u++]=i;a[u++]=r++,a[u++]=r++,a[u++]=i++}return a}function N(r){var i=r.center;V=t.multiplyByScalar(r.ellipsoid.geodeticSurfaceNormal(i,V),r.height,V),V=t.add(i,V,V);var n=new e(V,r.semiMajorAxis),o=s.computeEllipsePositions(r,!0,!1),a=o.positions,u=o.numPts,l=A(a,r,!1),c=v(u);return c=E.createTypedArray(a.length/3,c),{boundingSphere:n,attributes:l,indices:c}}function I(e,i){var o=i.vertexFormat,a=i.center,u=i.semiMajorAxis,s=i.semiMinorAxis,l=i.ellipsoid,f=i.height,d=i.extrudedHeight,m=i.stRotation,E=e.length/3*2,p=new Float64Array(3*E),_=o.st?new Float32Array(2*E):void 0,R=o.normal?new Float32Array(3*E):void 0,A=o.tangent?new Float32Array(3*E):void 0,v=o.binormal?new Float32Array(3*E):void 0,N=0,I=C,S=F,g=U,V=new c(l),H=V.project(l.cartesianToCartographic(a,D),B),X=l.scaleToGeodeticSurface(a,M);l.geodeticSurfaceNormal(X,X);for(var W=T.fromAxisAngle(X,m,L),Y=y.fromQuaternion(W,P),k=r.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,z),K=r.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,G),j=e.length,Z=j/3*2,Q=0;j>Q;Q+=3){var J,$=Q+1,ee=Q+2,re=t.fromArray(e,Q,M);if(o.st){var te=y.multiplyByVector(Y,re,O),ie=V.project(l.cartesianToCartographic(te,D),q);t.subtract(ie,H,ie),b.x=(ie.x+u)/(2*u),b.y=(ie.y+s)/(2*s),k.x=Math.min(b.x,k.x),k.y=Math.min(b.y,k.y),K.x=Math.max(b.x,K.x),K.y=Math.max(b.y,K.y),_[N+Z]=b.x,_[N+1+Z]=b.y,_[N++]=b.x,_[N++]=b.y}re=l.scaleToGeodeticSurface(re,re),J=t.clone(re,O),I=l.geodeticSurfaceNormal(re,I);var ne=t.multiplyByScalar(I,f,x);if(re=t.add(re,ne,re),ne=t.multiplyByScalar(I,d,ne),J=t.add(J,ne,J),o.position&&(p[Q+j]=J.x,p[$+j]=J.y,p[ee+j]=J.z,p[Q]=re.x,p[$]=re.y,p[ee]=re.z),o.normal||o.tangent||o.binormal){g=t.clone(I,g);var oe=t.fromArray(e,(Q+3)%j,x);t.subtract(oe,re,oe);var ae=t.subtract(J,re,q);I=t.normalize(t.cross(ae,oe,I),I),o.normal&&(R[Q]=I.x,R[$]=I.y,R[ee]=I.z,R[Q+j]=I.x,R[$+j]=I.y,R[ee+j]=I.z),o.tangent&&(S=t.normalize(t.cross(g,I,S),S),A[Q]=S.x,A[$]=S.y,A[ee]=S.z,A[Q+j]=S.x,A[Q+1+j]=S.y,A[Q+2+j]=S.z),o.binormal&&(v[Q]=g.x,v[$]=g.y,v[ee]=g.z,v[Q+j]=g.x,v[$+j]=g.y,v[ee+j]=g.z)}}if(o.st){j=_.length;for(var ue=0;j>ue;ue+=2)_[ue]=(_[ue]-k.x)/(K.x-k.x),_[ue+1]=(_[ue+1]-k.y)/(K.y-k.y)}var se=new w;return o.position&&(se.position=new h({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:p})),o.st&&(se.st=new h({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:_})),o.normal&&(se.normal=new h({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:R})),o.tangent&&(se.tangent=new h({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:A})),o.binormal&&(se.binormal=new h({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:v})),se}function S(e){for(var r=e.length/3,t=E.createTypedArray(r,6*r),i=0,n=0;r>n;n++){var o=n,a=n+r,u=(o+1)%r,s=u+r;t[i++]=o,t[i++]=a,t[i++]=u,t[i++]=u,t[i++]=a,t[i++]=s}return t}function g(r){var i=r.center,n=r.ellipsoid,o=r.semiMajorAxis,a=t.multiplyByScalar(n.geodeticSurfaceNormal(i,M),r.height,M);H.center=t.add(i,a,H.center),H.radius=o,a=t.multiplyByScalar(n.geodeticSurfaceNormal(i,a),r.extrudedHeight,a),X.center=t.add(i,a,X.center),X.radius=o;var u=s.computeEllipsePositions(r,!0,!0),l=u.positions,c=u.numPts,h=u.outerPositions,w=e.union(H,X),p=A(l,r,!0),y=v(c),T=y.length;y.length=2*T;for(var R=l.length/3,N=0;T>N;N+=3)y[N+T]=y[N+2]+R,y[N+1+T]=y[N+1]+R,y[N+2+T]=y[N]+R;var g=E.createTypedArray(2*R/3,y),O=new f({attributes:p,indices:g,primitiveType:_.TRIANGLES}),q=I(h,r);y=S(h);var x=E.createTypedArray(2*h.length/3,y),b=new f({attributes:q,indices:x,primitiveType:_.TRIANGLES}),P=m.combineInstances([new d({geometry:O}),new d({geometry:b})]);return{boundingSphere:w,attributes:P[0].attributes,indices:P[0].indices}}var M=new t,O=new t,q=new t,x=new t,b=new r,P=new y,L=new T,C=new t,F=new t,U=new t,D=new i,B=new t,z=new r,G=new r,V=new t,H=new e,X=new e,W=function(e){e=o(e,o.EMPTY_OBJECT);var r=e.center,i=o(e.ellipsoid,l.WGS84),n=e.semiMajorAxis,s=e.semiMinorAxis,c=o(e.granularity,p.RADIANS_PER_DEGREE),f=o(e.height,0),h=e.extrudedHeight,w=a(h)&&Math.abs(f-h)>1,d=o(e.vertexFormat,R.DEFAULT);if(!a(r))throw new u("center is required.");if(!a(n))throw new u("semiMajorAxis is required.");if(!a(s))throw new u("semiMinorAxis is required.");if(0>=n||0>=s)throw new u("Semi-major and semi-minor axes must be greater than zero.");if(s>n)throw new u("semiMajorAxis must be greater than or equal to the semiMinorAxis.");if(0>=c)throw new u("granularity must be greater than zero.");this._center=t.clone(r),this._semiMajorAxis=n,this._semiMinorAxis=s,this._ellipsoid=l.clone(i),this._rotation=o(e.rotation,0),this._stRotation=o(e.stRotation,0),this._height=f,this._granularity=c,this._vertexFormat=R.clone(d),this._extrudedHeight=o(h,f),this._extrude=w,this._workerName="createEllipseGeometry"};W.packedLength=t.packedLength+l.packedLength+R.packedLength+8,W.pack=function(e,r,i){if(!a(e))throw new u("value is required");if(!a(r))throw new u("array is required");i=o(i,0),t.pack(e._center,r,i),i+=t.packedLength,l.pack(e._ellipsoid,r,i),i+=l.packedLength,R.pack(e._vertexFormat,r,i),i+=R.packedLength,r[i++]=e._semiMajorAxis,r[i++]=e._semiMinorAxis,r[i++]=e._rotation,r[i++]=e._stRotation,r[i++]=e._height,r[i++]=e._granularity,r[i++]=e._extrudedHeight,r[i]=e._extrude?1:0};var Y=new t,k=new l,K=new R,j={center:Y,ellipsoid:k,vertexFormat:K,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,stRotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0};return W.unpack=function(e,r,i){if(!a(e))throw new u("array is required");r=o(r,0);var n=t.unpack(e,r,Y);r+=t.packedLength;var s=l.unpack(e,r,k);r+=l.packedLength;var c=R.unpack(e,r,K);r+=R.packedLength;var f=e[r++],h=e[r++],w=e[r++],d=e[r++],m=e[r++],E=e[r++],p=e[r++],y=1===e[r];return a(i)?(i._center=t.clone(n,i._center),i._ellipsoid=l.clone(s,i._ellipsoid),i._vertexFormat=R.clone(c,i._vertexFormat),i._semiMajorAxis=f,i._semiMinorAxis=h,i._rotation=w,i._stRotation=d,i._height=m,i._granularity=E,i._extrudedHeight=p,i._extrude=y,i):(j.height=m,j.extrudedHeight=p,j.granularity=E,j.stRotation=d,j.rotation=w,j.semiMajorAxis=f,j.semiMinorAxis=h,new W(j))},W.createGeometry=function(e){e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);var r,t={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:e._height,extrudedHeight:e._extrudedHeight,granularity:e._granularity,vertexFormat:e._vertexFormat,stRotation:e._stRotation};return e._extrude?(t.extrudedHeight=Math.min(e._extrudedHeight,e._height),t.height=Math.max(e._extrudedHeight,e._height),r=g(t)):r=N(t),new f({attributes:r.attributes,indices:r.indices,primitiveType:_.TRIANGLES,boundingSphere:r.boundingSphere})},W.createShadowVolume=function(e,r,t){var i=e._granularity,n=e._ellipsoid,o=r(i,n),a=t(i,n);return new W({center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:n,stRotation:e._stRotation,granularity:i,extrudedHeight:o,height:a,vertexFormat:R.POSITION_ONLY})},W}),define("Core/CircleGeometry",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./EllipseGeometry","./Ellipsoid","./Math","./VertexFormat"],function(e,r,t,i,n,o,a,u){"use strict";var s=function(e){e=r(e,r.EMPTY_OBJECT);var o=e.radius;if(!t(o))throw new i("radius is required.");if(0>=o)throw new i("radius must be greater than zero.");var a={center:e.center,semiMajorAxis:o,semiMinorAxis:o,ellipsoid:e.ellipsoid,height:e.height,extrudedHeight:e.extrudedHeight,granularity:e.granularity,vertexFormat:e.vertexFormat,stRotation:e.stRotation};this._ellipseGeometry=new n(a),this._workerName="createCircleGeometry"};s.packedLength=n.packedLength,s.pack=function(e,r,o){if(!t(e))throw new i("value is required");n.pack(e._ellipseGeometry,r,o)};var l=new n({center:new e,semiMajorAxis:1,semiMinorAxis:1}),c={center:new e,radius:void 0,ellipsoid:o.clone(o.UNIT_SPHERE),height:void 0,extrudedHeight:void 0,granularity:void 0,vertexFormat:new u,stRotation:void 0,semiMajorAxis:void 0,semiMinorAxis:void 0};return s.unpack=function(r,i,a){var f=n.unpack(r,i,l);return c.center=e.clone(f._center,c.center),c.ellipsoid=o.clone(f._ellipsoid,c.ellipsoid),c.height=f._height,c.extrudedHeight=f._extrudedHeight,c.granularity=f._granularity,c.vertexFormat=u.clone(f._vertexFormat,c.vertexFormat),c.stRotation=f._stRotation,t(a)?(c.semiMajorAxis=f._semiMajorAxis,c.semiMinorAxis=f._semiMinorAxis,a._ellipseGeometry=new n(c),a):(c.radius=f._semiMajorAxis,new s(c))},s.createGeometry=function(e){return n.createGeometry(e._ellipseGeometry)},s.createShadowVolume=function(e,r,t){var i=e._ellipseGeometry._granularity,n=e._ellipseGeometry._ellipsoid,o=r(i,n),a=t(i,n);return new s({center:e._ellipseGeometry._center,radius:e._ellipseGeometry._semiMajorAxis,ellipsoid:n,stRotation:e._ellipseGeometry._stRotation,granularity:i,extrudedHeight:o,height:a,vertexFormat:u.POSITION_ONLY})},s}),define("Workers/createCircleGeometry",["../Core/Cartesian3","../Core/CircleGeometry","../Core/defined","../Core/Ellipsoid"],function(e,r,t,i){"use strict";function n(n,o){return t(o)&&(n=r.unpack(n,o)),n._ellipseGeometry._center=e.clone(n._ellipseGeometry._center),n._ellipseGeometry._ellipsoid=i.clone(n._ellipseGeometry._ellipsoid),r.createGeometry(n)}return n})}();