/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

!function(){define("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),define("Core/freezeObject",["./defined"],function(e){"use strict";var r=Object.freeze;return e(r)||(r=function(e){return e}),r}),define("Core/defaultValue",["./freezeObject"],function(e){"use strict";var r=function(e,r){return void 0!==e?e:r};return r.EMPTY_OBJECT=e({}),r}),define("Core/DeveloperError",["./defined"],function(e){"use strict";var r=function(e){this.name="DeveloperError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r.throwInstantiationError=function(){throw new r("This function defines an interface and should not be called directly.")},r}),define("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var t;for(this.mti==this.N+1&&this.init_genrand(5489),t=0;t<this.N-this.M;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+this.M]^e>>>1^r[1&e];for(;t<this.N-1;t++)e=this.mt[t]&this.UPPER_MASK|this.mt[t+1]&this.LOWER_MASK,this.mt[t]=this.mt[t+(this.M-this.N)]^e>>>1^r[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^r[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),define("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i={};i.EPSILON1=.1,i.EPSILON2=.01,i.EPSILON3=.001,i.EPSILON4=1e-4,i.EPSILON5=1e-5,i.EPSILON6=1e-6,i.EPSILON7=1e-7,i.EPSILON8=1e-8,i.EPSILON9=1e-9,i.EPSILON10=1e-10,i.EPSILON11=1e-11,i.EPSILON12=1e-12,i.EPSILON13=1e-13,i.EPSILON14=1e-14,i.EPSILON15=1e-15,i.EPSILON16=1e-16,i.EPSILON17=1e-17,i.EPSILON18=1e-18,i.EPSILON19=1e-19,i.EPSILON20=1e-20,i.GRAVITATIONALPARAMETER=3986004418e5,i.SOLAR_RADIUS=6955e5,i.LUNAR_RADIUS=1737400,i.SIXTY_FOUR_KILOBYTES=65536,i.sign=function(e){return e>0?1:0>e?-1:0},i.signNotZero=function(e){return 0>e?-1:1},i.toSNorm=function(e){return Math.round(255*(.5*i.clamp(e,-1,1)+.5))},i.fromSNorm=function(e){return i.clamp(e,0,255)/255*2-1},i.sinh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r-t)},i.cosh=function(e){var r=Math.pow(Math.E,e),t=Math.pow(Math.E,-1*e);return.5*(r+t)},i.lerp=function(e,r,t){return(1-t)*e+t*r},i.PI=Math.PI,i.ONE_OVER_PI=1/Math.PI,i.PI_OVER_TWO=.5*Math.PI,i.PI_OVER_THREE=Math.PI/3,i.PI_OVER_FOUR=Math.PI/4,i.PI_OVER_SIX=Math.PI/6,i.THREE_PI_OVER_TWO=3*Math.PI*.5,i.TWO_PI=2*Math.PI,i.ONE_OVER_TWO_PI=1/(2*Math.PI),i.RADIANS_PER_DEGREE=Math.PI/180,i.DEGREES_PER_RADIAN=180/Math.PI,i.RADIANS_PER_ARCSECOND=i.RADIANS_PER_DEGREE/3600,i.toRadians=function(e){if(!t(e))throw new n("degrees is required.");return e*i.RADIANS_PER_DEGREE},i.toDegrees=function(e){if(!t(e))throw new n("radians is required.");return e*i.DEGREES_PER_RADIAN},i.convertLongitudeRange=function(e){if(!t(e))throw new n("angle is required.");var r=i.TWO_PI,o=e-Math.floor(e/r)*r;return o<-Math.PI?o+r:o>=Math.PI?o-r:o},i.negativePiToPi=function(e){if(!t(e))throw new n("x is required.");return i.zeroToTwoPi(e+i.PI)-i.PI},i.zeroToTwoPi=function(e){if(!t(e))throw new n("x is required.");var r=i.mod(e,i.TWO_PI);return Math.abs(r)<i.EPSILON14&&Math.abs(e)>i.EPSILON14?i.TWO_PI:r},i.mod=function(e,r){if(!t(e))throw new n("m is required.");if(!t(r))throw new n("n is required.");return(e%r+r)%r},i.equalsEpsilon=function(e,i,o,a){if(!t(e))throw new n("left is required.");if(!t(i))throw new n("right is required.");if(!t(o))throw new n("relativeEpsilon is required.");a=r(a,o);var s=Math.abs(e-i);return a>=s||s<=o*Math.max(Math.abs(e),Math.abs(i))};var o=[1];i.factorial=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");var r=o.length;if(e>=r)for(var t=o[r-1],i=r;e>=i;i++)o.push(t*i);return o[e]},i.incrementWrap=function(e,i,o){if(o=r(o,0),!t(e))throw new n("n is required.");if(o>=i)throw new n("maximumValue must be greater than minimumValue.");return++e,e>i&&(e=o),e},i.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},i.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new n("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},i.clamp=function(e,r,i){if(!t(e))throw new n("value is required");if(!t(r))throw new n("min is required.");if(!t(i))throw new n("max is required.");return r>e?r:e>i?i:e};var a=new e;return i.setRandomNumberSeed=function(r){if(!t(r))throw new n("seed is required.");a=new e(r)},i.nextRandomNumber=function(){return a.random()},i.acosClamped=function(e){if(!t(e))throw new n("value is required.");return Math.acos(i.clamp(e,-1,1))},i.asinClamped=function(e){if(!t(e))throw new n("value is required.");return Math.asin(i.clamp(e,-1,1))},i.chordLength=function(e,r){if(!t(e))throw new n("angle is required.");if(!t(r))throw new n("radius is required.");return 2*r*Math.sin(.5*e)},i}),define("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t,n){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0)};o.fromSpherical=function(n,i){if(!r(n))throw new t("spherical is required");r(i)||(i=new o);var a=n.clock,s=n.cone,u=e(n.magnitude,1),f=u*Math.sin(s);return i.x=f*Math.cos(a),i.y=f*Math.sin(a),i.z=u*Math.cos(s),i},o.fromElements=function(e,t,n,i){return r(i)?(i.x=e,i.y=t,i.z=n,i):new o(e,t,n)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t):new o(e.x,e.y,e.z):void 0},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.x,i[o++]=n.y,i[o]=n.z},o.unpack=function(n,i,a){if(!r(n))throw new t("array is required");return i=e(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i],a},o.fromArray=o.unpack,o.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z)},o.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z)},o.minimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i},o.maximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitude(a)},o.distanceSquared=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitudeSquared(a)},o.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=o.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n},o.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z},o.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i},o.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i},o.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i},o.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i},o.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i},o.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n},o.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n};var s=new o;o.lerp=function(e,n,i,a){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(n,i,s),a=o.multiplyByScalar(e,1-i,a),o.add(s,a,a)};var u=new o,f=new o;o.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");o.normalize(e,u),o.normalize(n,f);var i=o.dot(u,f),a=o.magnitude(o.cross(u,f,u));return Math.atan2(a,i)};var l=new o;o.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=o.normalize(e,l);return o.abs(i,i),n=i.x<=i.y?i.x<=i.z?o.clone(o.UNIT_X,n):o.clone(o.UNIT_Z,n):i.y<=i.z?o.clone(o.UNIT_Y,n):o.clone(o.UNIT_Z,n)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z},o.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]&&e.z===r[t+2]},o.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)&&i.equalsEpsilon(e.z,t.z,n,o)},o.cross=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");var o=e.x,a=e.y,s=e.z,u=n.x,f=n.y,l=n.z,c=a*l-s*f,h=s*u-o*l,d=o*f-a*u;return i.x=c,i.y=h,i.z=d,i},o.fromDegrees=function(e,n,a,s,u){if(!r(e))throw new t("longitude is required");if(!r(n))throw new t("latitude is required");var f=i.toRadians(e),l=i.toRadians(n);return o.fromRadians(f,l,a,s,u)};var c=new o,h=new o,d=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(n,i,a,s,u){if(!r(n))throw new t("longitude is required");if(!r(i))throw new t("latitude is required");a=e(a,0);var f=r(s)?s.radiiSquared:d,l=Math.cos(i);c.x=l*Math.cos(n),c.y=l*Math.sin(n),c.z=Math.sin(i),c=o.normalize(c,c),o.multiplyComponents(f,c,h);var w=Math.sqrt(o.dot(c,h));return h=o.divideByScalar(h,w,h),c=o.multiplyByScalar(c,a,c),r(u)||(u=new o),o.add(h,c,u)},o.fromDegreesArray=function(e,n,a){if(!r(e))throw new t("positions is required.");for(var s=new Array(e.length),u=0;u<e.length;u++)s[u]=i.toRadians(e[u]);return o.fromRadiansArray(s,n,a)},o.fromRadiansArray=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<2)throw new t("positions length cannot be less than 2.");if(e.length%2!==0)throw new t("positions length must be a multiple of 2.");var a=e.length;r(i)?i.length=a/2:i=new Array(a/2);for(var s=0;a>s;s+=2){var u=e[s],f=e[s+1];i[s/2]=o.fromRadians(u,f,0,n,i[s/2])}return i},o.fromDegreesArrayHeights=function(e,n,a){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(e.length%3!==0)throw new t("positions length must be a multiple of 3.");for(var s=new Array(e.length),u=0;u<e.length;u+=3)s[u]=i.toRadians(e[u]),s[u+1]=i.toRadians(e[u+1]),s[u+2]=e[u+2];return o.fromRadiansArrayHeights(s,n,a)},o.fromRadiansArrayHeights=function(e,n,i){if(!r(e))throw new t("positions is required.");if(e.length<3)throw new t("positions length cannot be less than 3.");if(e.length%3!==0)throw new t("positions length must be a multiple of 3.");var a=e.length;r(i)?i.length=a/3:i=new Array(a/3);for(var s=0;a>s;s+=3){var u=e[s],f=e[s+1],l=e[s+2];i[s/3]=o.fromRadians(u,f,l,n,i[s/3])}return i},o.ZERO=n(new o(0,0,0)),o.UNIT_X=n(new o(1,0,0)),o.UNIT_Y=n(new o(0,1,0)),o.UNIT_Z=n(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r,t){return o.equalsEpsilon(this,e,r,t)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),define("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t,n){this.longitude=e(r,0),this.latitude=e(t,0),this.height=e(n,0)};return o.fromRadians=function(n,i,a,s){if(!r(n))throw new t("longitude is required.");if(!r(i))throw new t("latitude is required.");return a=e(a,0),r(s)?(s.longitude=n,s.latitude=i,s.height=a,s):new o(n,i,a)},o.fromDegrees=function(e,n,a,s){if(!r(e))throw new t("longitude is required.");if(!r(n))throw new t("latitude is required.");return e=i.toRadians(e),n=i.toRadians(n),o.fromRadians(e,n,a,s)},o.clone=function(e,t){return r(e)?r(t)?(t.longitude=e.longitude,t.latitude=e.latitude,t.height=e.height,t):new o(e.longitude,e.latitude,e.height):void 0},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.longitude===t.longitude&&e.latitude===t.latitude&&e.height===t.height},o.equalsEpsilon=function(e,n,i){if("number"!=typeof i)throw new t("epsilon is required and must be a number.");return e===n||r(e)&&r(n)&&Math.abs(e.longitude-n.longitude)<=i&&Math.abs(e.latitude-n.latitude)<=i&&Math.abs(e.height-n.height)<=i},o.ZERO=n(new o(0,0,0)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r){return o.equalsEpsilon(this,e,r)},o.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},o}),define("Core/deprecationWarning",["./defined","./DeveloperError"],function(e,r){"use strict";var t={},n=function(n,i){if(!e(n)||!e(i))throw new r("identifier and message are required.");e(t[n])||(t[n]=!0,console.log(i))};return n}),define("Core/defineProperties",["./defined"],function(e){"use strict";var r=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),t=Object.defineProperties;return r&&e(t)||(t=function(e){return e}),t}),define("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,o,a,s){"use strict";function u(r,n,i,a){if(n=t(n,0),i=t(i,0),a=t(a,0),0>n||0>i||0>a)throw new o("All radii components must be greater than or equal to zero.");r._radii=new e(n,i,a),r._radiiSquared=new e(n*n,i*i,a*a),r._radiiToTheFourth=new e(n*n*n*n,i*i*i*i,a*a*a*a),r._oneOverRadii=new e(0===n?0:1/n,0===i?0:1/i,0===a?0:1/a),r._oneOverRadiiSquared=new e(0===n?0:1/(n*n),0===i?0:1/(i*i),0===a?0:1/(a*a)),r._minimumRadius=Math.min(n,i,a),r._maximumRadius=Math.max(n,i,a),r._centerToleranceSquared=s.EPSILON1}var f=function(e,r,t){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,u(this,e,r,t)};i(f.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),f.clone=function(r,t){if(!n(r))return void 0;var i=r._radii;return n(t)?(e.clone(i,t._radii),e.clone(r._radiiSquared,t._radiiSquared),e.clone(r._radiiToTheFourth,t._radiiToTheFourth),e.clone(r._oneOverRadii,t._oneOverRadii),e.clone(r._oneOverRadiiSquared,t._oneOverRadiiSquared),t._minimumRadius=r._minimumRadius,t._maximumRadius=r._maximumRadius,t._centerToleranceSquared=r._centerToleranceSquared,t):new f(i.x,i.y,i.z)},f.fromCartesian3=function(e,r){return n(r)||(r=new f),n(e)?(u(r,e.x,e.y,e.z),r):r},f.WGS84=a(new f(6378137,6378137,6356752.314245179)),f.UNIT_SPHERE=a(new f(1,1,1)),f.MOON=a(new f(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),f.prototype.clone=function(e){return f.clone(this,e)},f.packedLength=e.packedLength,f.pack=function(r,i,a){if(!n(r))throw new o("value is required");if(!n(i))throw new o("array is required");a=t(a,0),e.pack(r._radii,i,a)},f.unpack=function(r,i,a){if(!n(r))throw new o("array is required");i=t(i,0);var s=e.unpack(r,i);return f.fromCartesian3(s,a)},f.prototype.geocentricSurfaceNormal=e.normalize,f.prototype.geodeticSurfaceNormalCartographic=function(r,t){if(!n(r))throw new o("cartographic is required.");var i=r.longitude,a=r.latitude,s=Math.cos(a),u=s*Math.cos(i),f=s*Math.sin(i),l=Math.sin(a);return n(t)||(t=new e),t.x=u,t.y=f,t.z=l,e.normalize(t,t)},f.prototype.geodeticSurfaceNormal=function(r,t){return n(t)||(t=new e),t=e.multiplyComponents(r,this._oneOverRadiiSquared,t),e.normalize(t,t)};var l=new e,c=new e;f.prototype.cartographicToCartesian=function(r,t){var i=l,o=c;this.geodeticSurfaceNormalCartographic(r,i),e.multiplyComponents(this._radiiSquared,i,o);var a=Math.sqrt(e.dot(i,o));return e.divideByScalar(o,a,o),e.multiplyByScalar(i,r.height,i),n(t)||(t=new e),e.add(o,i,t)},f.prototype.cartographicArrayToCartesianArray=function(e,r){if(!n(e))throw new o("cartographics is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;i++)r[i]=this.cartographicToCartesian(e[i],r[i]);return r};var h=new e,d=new e,w=new e;f.prototype.cartesianToCartographic=function(t,i){var o=this.scaleToGeodeticSurface(t,d);if(!n(o))return void 0;var a=this.geodeticSurfaceNormal(o,h),u=e.subtract(t,o,w),f=Math.atan2(a.y,a.x),l=Math.asin(a.z),c=s.sign(e.dot(u,t))*e.magnitude(u);return n(i)?(i.longitude=f,i.latitude=l,i.height=c,i):new r(f,l,c)},f.prototype.cartesianArrayToCartographicArray=function(e,r){if(!n(e))throw new o("cartesians is required.");var t=e.length;n(r)?r.length=t:r=new Array(t);for(var i=0;t>i;++i)r[i]=this.cartesianToCartographic(e[i],r[i]);return r};var E=new e,m=new e;return f.prototype.scaleToGeodeticSurface=function(r,t){if(!n(r))throw new o("cartesian is required.");var i=r.x,a=r.y,u=r.z,f=this._oneOverRadii,l=f.x,c=f.y,h=f.z,d=i*i*l*l,w=a*a*c*c,p=u*u*h*h,T=d+w+p,y=Math.sqrt(1/T),R=e.multiplyByScalar(r,y,E);if(T<this._centerToleranceSquared)return isFinite(y)?e.clone(R,t):void 0;var A=this._oneOverRadiiSquared,v=A.x,_=A.y,S=A.z,g=m;g.x=R.x*v*2,g.y=R.y*_*2,g.z=R.z*S*2;var C,N,I,O,b,M,q,L,F,P,D,x=(1-y)*e.magnitude(r)/(.5*e.magnitude(g)),U=0;do{x-=U,I=1/(1+x*v),O=1/(1+x*_),b=1/(1+x*S),M=I*I,q=O*O,L=b*b,F=M*I,P=q*O,D=L*b,C=d*M+w*q+p*L-1,N=d*F*v+w*P*_+p*D*S;var B=-2*N;U=C/B}while(Math.abs(C)>s.EPSILON12);return n(t)?(t.x=i*I,t.y=a*O,t.z=u*b,t):new e(i*I,a*O,u*b)},f.prototype.scaleToGeocentricSurface=function(r,t){if(!n(r))throw new o("cartesian is required.");n(t)||(t=new e);var i=r.x,a=r.y,s=r.z,u=this._oneOverRadiiSquared,f=1/Math.sqrt(i*i*u.x+a*a*u.y+s*s*u.z);return e.multiplyByScalar(r,f,t)},f.prototype.transformPositionToScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._oneOverRadii,t)},f.prototype.transformPositionFromScaledSpace=function(r,t){return n(t)||(t=new e),e.multiplyComponents(r,this._radii,t)},f.prototype.equals=function(r){return this===r||n(r)&&e.equals(this._radii,r._radii)},f.prototype.toString=function(){return this._radii.toString()},f}),define("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,r,t,n,i,o,a){"use strict";var s=function(e){this._ellipsoid=t(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),s.prototype.project=function(r,t){var i=this._semimajorAxis,o=r.longitude*i,a=r.latitude*i,s=r.height;return n(t)?(t.x=o,t.y=a,t.z=s,t):new e(o,a,s)},s.prototype.unproject=function(e,t){if(!n(e))throw new o("cartesian is required");var i=this._oneOverSemimajorAxis,a=e.x*i,s=e.y*i,u=e.z;return n(t)?(t.longitude=a,t.latitude=s,t.height=u,t):new r(a,s,u)},s}),define("Core/Intersect",["./freezeObject"],function(e){"use strict";var r={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(r)}),define("Core/Interval",["./defaultValue"],function(e){"use strict";var r=function(r,t){this.start=e(r,0),this.stop=e(t,0)};return r}),define("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t,n,i){this.x=e(r,0),this.y=e(t,0),this.z=e(n,0),this.w=e(i,0)};o.fromElements=function(e,t,n,i,a){return r(a)?(a.x=e,a.y=t,a.z=n,a.w=i,a):new o(e,t,n,i)},o.fromColor=function(e,n){if(!r(e))throw new t("color is required");return r(n)?(n.x=e.red,n.y=e.green,n.z=e.blue,n.w=e.alpha,n):new o(e.red,e.green,e.blue,e.alpha)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new o(e.x,e.y,e.z,e.w):void 0},o.packedLength=4,o.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.x,i[o++]=n.y,i[o++]=n.z,i[o]=n.w},o.unpack=function(n,i,a){if(!r(n))throw new t("array is required");return i=e(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i++],a.z=n[i++],a.w=n[i],a},o.fromArray=o.unpack,o.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y,e.z,e.w)},o.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y,e.z,e.w)},o.minimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i.z=Math.min(e.z,n.z),i.w=Math.min(e.w,n.w),i},o.maximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i.z=Math.max(e.z,n.z),i.w=Math.max(e.w,n.w),i},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitude(a)},o.distanceSquared=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitudeSquared(a)},o.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=o.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n.w=e.w/i,n},o.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y+e.z*n.z+e.w*n.w},o.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i.z=e.z*n.z,i.w=e.w*n.w,i},o.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i.z=e.z+n.z,i.w=e.w+n.w,i},o.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i.z=e.z-n.z,i.w=e.w-n.w,i},o.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i.z=e.z*n,i.w=e.w*n,i},o.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i.w=e.w/n,i},o.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n.z=-e.z,n.w=-e.w,n},o.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n.z=Math.abs(e.z),n.w=Math.abs(e.w),n};var s=new o;o.lerp=function(e,n,i,a){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(n,i,s),a=o.multiplyByScalar(e,1-i,a),o.add(s,a,a)};var u=new o;return o.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=o.normalize(e,u);return o.abs(i,i),n=i.x<=i.y?i.x<=i.z?i.x<=i.w?o.clone(o.UNIT_X,n):o.clone(o.UNIT_W,n):i.z<=i.w?o.clone(o.UNIT_Z,n):o.clone(o.UNIT_W,n):i.y<=i.z?i.y<=i.w?o.clone(o.UNIT_Y,n):o.clone(o.UNIT_W,n):i.z<=i.w?o.clone(o.UNIT_Z,n):o.clone(o.UNIT_W,n)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},o.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]&&e.z===r[t+2]&&e.w===r[t+3]},o.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)&&i.equalsEpsilon(e.z,t.z,n,o)&&i.equalsEpsilon(e.w,t.w,n,o)},o.ZERO=n(new o(0,0,0,0)),o.UNIT_X=n(new o(1,0,0,0)),o.UNIT_Y=n(new o(0,1,0,0)),o.UNIT_Z=n(new o(0,0,1,0)),o.UNIT_W=n(new o(0,0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r,t){return o.equalsEpsilon(this,e,r,t)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},o}),define("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i,o){"use strict";function a(e){for(var r=0,t=0;9>t;++t){var n=e[t];r+=n*n}return Math.sqrt(r)}function s(e){for(var r=0,t=0;3>t;++t){var n=e[f.getElementIndex(d[t],h[t])];r+=2*n*n}return Math.sqrt(r)}function u(e,r){for(var t=o.EPSILON15,n=0,i=1,a=0;3>a;++a){var s=Math.abs(e[f.getElementIndex(d[a],h[a])]);s>n&&(i=a,n=s)}var u=1,l=0,c=h[i],w=d[i];if(Math.abs(e[f.getElementIndex(w,c)])>t){var E,m=e[f.getElementIndex(w,w)],p=e[f.getElementIndex(c,c)],T=e[f.getElementIndex(w,c)],y=(m-p)/2/T;E=0>y?-1/(-y+Math.sqrt(1+y*y)):1/(y+Math.sqrt(1+y*y)),u=1/Math.sqrt(1+E*E),l=E*u}return r=f.clone(f.IDENTITY,r),r[f.getElementIndex(c,c)]=r[f.getElementIndex(w,w)]=u,r[f.getElementIndex(w,c)]=l,r[f.getElementIndex(c,w)]=-l,r}var f=function(e,t,n,i,o,a,s,u,f){this[0]=r(e,0),this[1]=r(i,0),this[2]=r(s,0),this[3]=r(t,0),this[4]=r(o,0),this[5]=r(u,0),this[6]=r(n,0),this[7]=r(a,0),this[8]=r(f,0)};f.packedLength=9,f.pack=function(e,i,o){if(!t(e))throw new n("value is required");if(!t(i))throw new n("array is required");o=r(o,0),i[o++]=e[0],i[o++]=e[1],i[o++]=e[2],i[o++]=e[3],i[o++]=e[4],i[o++]=e[5],i[o++]=e[6],i[o++]=e[7],i[o++]=e[8]},f.unpack=function(e,i,o){if(!t(e))throw new n("array is required");return i=r(i,0),t(o)||(o=new f),o[0]=e[i++],o[1]=e[i++],o[2]=e[i++],o[3]=e[i++],o[4]=e[i++],o[5]=e[i++],o[6]=e[i++],o[7]=e[i++],o[8]=e[i++],o},f.clone=function(e,r){return t(e)?t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):new f(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},f.fromArray=function(e,i,o){if(!t(e))throw new n("array is required");return i=r(i,0),t(o)||(o=new f),o[0]=e[i],o[1]=e[i+1],o[2]=e[i+2],o[3]=e[i+3],o[4]=e[i+4],o[5]=e[i+5],o[6]=e[i+6],o[7]=e[i+7],o[8]=e[i+8],o},f.fromColumnMajorArray=function(e,r){if(!t(e))throw new n("values parameter is required");return f.clone(e,r)},f.fromRowMajorArray=function(e,r){if(!t(e))throw new n("values is required.");return t(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},f.fromQuaternion=function(e,r){if(!t(e))throw new n("quaternion is required");var i=e.x*e.x,o=e.x*e.y,a=e.x*e.z,s=e.x*e.w,u=e.y*e.y,l=e.y*e.z,c=e.y*e.w,h=e.z*e.z,d=e.z*e.w,w=e.w*e.w,E=i-u-h+w,m=2*(o-d),p=2*(a+c),T=2*(o+d),y=-i+u-h+w,R=2*(l-s),A=2*(a-c),v=2*(l+s),_=-i-u+h+w;return t(r)?(r[0]=E,r[1]=T,r[2]=A,r[3]=m,r[4]=y,r[5]=v,r[6]=p,r[7]=R,r[8]=_,r):new f(E,m,p,T,y,R,A,v,_)},f.fromScale=function(e,r){if(!t(e))throw new n("scale is required.");return t(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new f(e.x,0,0,0,e.y,0,0,0,e.z)},f.fromUniformScale=function(e,r){if("number"!=typeof e)throw new n("scale is required.");return t(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new f(e,0,0,0,e,0,0,0,e)},f.fromCrossProduct=function(e,r){if(!t(e))throw new n("vector is required.");return t(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new f(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},f.fromRotationX=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=i,r[5]=o,r[6]=0,r[7]=-o,r[8]=i,r):new f(1,0,0,0,i,-o,0,o,i)},f.fromRotationY=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=i,r[1]=0,r[2]=-o,r[3]=0,r[4]=1,r[5]=0,r[6]=o,r[7]=0,r[8]=i,r):new f(i,0,o,0,1,0,-o,0,i)},f.fromRotationZ=function(e,r){if(!t(e))throw new n("angle is required.");var i=Math.cos(e),o=Math.sin(e);return t(r)?(r[0]=i,r[1]=o,r[2]=0,r[3]=-o,r[4]=i,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new f(i,-o,0,o,i,0,0,0,1)},f.toArray=function(e,r){if(!t(e))throw new n("matrix is required");return t(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},f.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>2)throw new n("row must be 0, 1, or 2.");if("number"!=typeof e||0>e||e>2)throw new n("column must be 0, 1, or 2.");return 3*e+r},f.getColumn=function(e,r,i){if(!t(e))throw new n("matrix is required.");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(i))throw new n("result is required");var o=3*r,a=e[o],s=e[o+1],u=e[o+2];return i.x=a,i.y=s,i.z=u,i},f.setColumn=function(e,r,i,o){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(o))throw new n("result is required");o=f.clone(e,o);var a=3*r;return o[a]=i.x,o[a+1]=i.y,o[a+2]=i.z,o},f.getRow=function(e,r,i){if(!t(e))throw new n("matrix is required.");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(i))throw new n("result is required");var o=e[r],a=e[r+3],s=e[r+6];
return i.x=o,i.y=a,i.z=s,i},f.setRow=function(e,r,i,o){if(!t(e))throw new n("matrix is required");if(!t(i))throw new n("cartesian is required");if("number"!=typeof r||0>r||r>2)throw new n("index must be 0, 1, or 2.");if(!t(o))throw new n("result is required");return o=f.clone(e,o),o[r]=i.x,o[r+3]=i.y,o[r+6]=i.z,o};var l=new e;f.getScale=function(r,i){if(!t(r))throw new n("matrix is required.");if(!t(i))throw new n("result is required");return i.x=e.magnitude(e.fromElements(r[0],r[1],r[2],l)),i.y=e.magnitude(e.fromElements(r[3],r[4],r[5],l)),i.z=e.magnitude(e.fromElements(r[6],r[7],r[8],l)),i};var c=new e;f.getMaximumScale=function(r){return f.getScale(r,c),e.maximumComponent(c)},f.multiply=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");var o=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],a=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],s=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],u=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],f=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],l=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],c=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],h=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],d=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return i[0]=o,i[1]=a,i[2]=s,i[3]=u,i[4]=f,i[5]=l,i[6]=c,i[7]=h,i[8]=d,i},f.add=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i[0]=e[0]+r[0],i[1]=e[1]+r[1],i[2]=e[2]+r[2],i[3]=e[3]+r[3],i[4]=e[4]+r[4],i[5]=e[5]+r[5],i[6]=e[6]+r[6],i[7]=e[7]+r[7],i[8]=e[8]+r[8],i},f.subtract=function(e,r,i){if(!t(e))throw new n("left is required");if(!t(r))throw new n("right is required");if(!t(i))throw new n("result is required");return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],i[3]=e[3]-r[3],i[4]=e[4]-r[4],i[5]=e[5]-r[5],i[6]=e[6]-r[6],i[7]=e[7]-r[7],i[8]=e[8]-r[8],i},f.multiplyByVector=function(e,r,i){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("cartesian is required");if(!t(i))throw new n("result is required");var o=r.x,a=r.y,s=r.z,u=e[0]*o+e[3]*a+e[6]*s,f=e[1]*o+e[4]*a+e[7]*s,l=e[2]*o+e[5]*a+e[8]*s;return i.x=u,i.y=f,i.z=l,i},f.multiplyByScalar=function(e,r,i){if(!t(e))throw new n("matrix is required");if("number"!=typeof r)throw new n("scalar must be a number");if(!t(i))throw new n("result is required");return i[0]=e[0]*r,i[1]=e[1]*r,i[2]=e[2]*r,i[3]=e[3]*r,i[4]=e[4]*r,i[5]=e[5]*r,i[6]=e[6]*r,i[7]=e[7]*r,i[8]=e[8]*r,i},f.multiplyByScale=function(e,r,i){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("scale is required");if(!t(i))throw new n("result is required");return i[0]=e[0]*r.x,i[1]=e[1]*r.x,i[2]=e[2]*r.x,i[3]=e[3]*r.y,i[4]=e[4]*r.y,i[5]=e[5]*r.y,i[6]=e[6]*r.z,i[7]=e[7]*r.z,i[8]=e[8]*r.z,i},f.negate=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");return r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r},f.transpose=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");var i=e[0],o=e[3],a=e[6],s=e[1],u=e[4],f=e[7],l=e[2],c=e[5],h=e[8];return r[0]=i,r[1]=o,r[2]=a,r[3]=s,r[4]=u,r[5]=f,r[6]=l,r[7]=c,r[8]=h,r};var h=[1,0,0],d=[2,2,1],w=new f,E=new f;return f.computeEigenDecomposition=function(e,r){if(!t(e))throw new n("matrix is required.");var i=o.EPSILON20,l=10,c=0,h=0;t(r)||(r={});for(var d=r.unitary=f.clone(f.IDENTITY,r.unitary),m=r.diagonal=f.clone(e,r.diagonal),p=i*a(m);l>h&&s(m)>p;)u(m,w),f.transpose(w,E),f.multiply(m,w,m),f.multiply(E,m,m),f.multiply(d,w,d),++c>2&&(++h,c=0);return r},f.abs=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");return r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r},f.determinant=function(e){if(!t(e))throw new n("matrix is required");var r=e[0],i=e[3],o=e[6],a=e[1],s=e[4],u=e[7],f=e[2],l=e[5],c=e[8];return r*(s*c-l*u)+a*(l*o-i*c)+f*(i*u-s*o)},f.inverse=function(e,r){if(!t(e))throw new n("matrix is required");if(!t(r))throw new n("result is required");var i=e[0],a=e[1],s=e[2],u=e[3],l=e[4],c=e[5],h=e[6],d=e[7],w=e[8],E=f.determinant(e);if(Math.abs(E)<=o.EPSILON15)throw new n("matrix is not invertible");r[0]=l*w-d*c,r[1]=d*s-a*w,r[2]=a*c-l*s,r[3]=h*c-u*w,r[4]=i*w-h*s,r[5]=u*s-i*c,r[6]=u*d-h*l,r[7]=h*a-i*d,r[8]=i*l-u*a;var m=1/E;return f.multiplyByScalar(r,m,r)},f.equals=function(e,r){return e===r||t(e)&&t(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]},f.equalsEpsilon=function(e,r,i){if("number"!=typeof i)throw new n("epsilon must be a number");return e===r||t(e)&&t(r)&&Math.abs(e[0]-r[0])<=i&&Math.abs(e[1]-r[1])<=i&&Math.abs(e[2]-r[2])<=i&&Math.abs(e[3]-r[3])<=i&&Math.abs(e[4]-r[4])<=i&&Math.abs(e[5]-r[5])<=i&&Math.abs(e[6]-r[6])<=i&&Math.abs(e[7]-r[7])<=i&&Math.abs(e[8]-r[8])<=i},f.IDENTITY=i(new f(1,0,0,0,1,0,0,0,1)),f.ZERO=i(new f(0,0,0,0,0,0,0,0,0)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN1ROW0=3,f.COLUMN1ROW1=4,f.COLUMN1ROW2=5,f.COLUMN2ROW0=6,f.COLUMN2ROW1=7,f.COLUMN2ROW2=8,f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.equalsArray=function(e,r,t){return e[0]===r[t]&&e[1]===r[t+1]&&e[2]===r[t+2]&&e[3]===r[t+3]&&e[4]===r[t+4]&&e[5]===r[t+5]&&e[6]===r[t+6]&&e[7]===r[t+7]&&e[8]===r[t+8]},f.prototype.equalsEpsilon=function(e,r){return f.equalsEpsilon(this,e,r)},f.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},f}),define("Core/RuntimeError",["./defined"],function(e){"use strict";var r=function(e){this.name="RuntimeError",this.message=e;var r;try{throw new Error}catch(t){r=t.stack}this.stack=r};return r.prototype.toString=function(){var r=this.name+": "+this.message;return e(this.stack)&&(r+="\n"+this.stack.toString()),r},r}),define("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,r,t,n,i,o,a,s,u){"use strict";var f=function(e,r,n,i,o,a,s,u,f,l,c,h,d,w,E,m){this[0]=t(e,0),this[1]=t(o,0),this[2]=t(f,0),this[3]=t(d,0),this[4]=t(r,0),this[5]=t(a,0),this[6]=t(l,0),this[7]=t(w,0),this[8]=t(n,0),this[9]=t(s,0),this[10]=t(c,0),this[11]=t(E,0),this[12]=t(i,0),this[13]=t(u,0),this[14]=t(h,0),this[15]=t(m,0)};f.packedLength=16,f.pack=function(e,r,o){if(!n(e))throw new i("value is required");if(!n(r))throw new i("array is required");o=t(o,0),r[o++]=e[0],r[o++]=e[1],r[o++]=e[2],r[o++]=e[3],r[o++]=e[4],r[o++]=e[5],r[o++]=e[6],r[o++]=e[7],r[o++]=e[8],r[o++]=e[9],r[o++]=e[10],r[o++]=e[11],r[o++]=e[12],r[o++]=e[13],r[o++]=e[14],r[o]=e[15]},f.unpack=function(e,r,o){if(!n(e))throw new i("array is required");return r=t(r,0),n(o)||(o=new f),o[0]=e[r++],o[1]=e[r++],o[2]=e[r++],o[3]=e[r++],o[4]=e[r++],o[5]=e[r++],o[6]=e[r++],o[7]=e[r++],o[8]=e[r++],o[9]=e[r++],o[10]=e[r++],o[11]=e[r++],o[12]=e[r++],o[13]=e[r++],o[14]=e[r++],o[15]=e[r],o},f.clone=function(e,r){return n(e)?n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):new f(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},f.fromArray=f.unpack,f.fromColumnMajorArray=function(e,r){if(!n(e))throw new i("values is required");return f.clone(e,r)},f.fromRowMajorArray=function(e,r){if(!n(e))throw new i("values is required.");return n(r)?(r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=e[1],r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=e[2],r[9]=e[6],r[10]=e[10],r[11]=e[14],r[12]=e[3],r[13]=e[7],r[14]=e[11],r[15]=e[15],r):new f(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},f.fromRotationTranslation=function(r,o,a){if(!n(r))throw new i("rotation is required.");return o=t(o,e.ZERO),n(a)?(a[0]=r[0],a[1]=r[1],a[2]=r[2],a[3]=0,a[4]=r[3],a[5]=r[4],a[6]=r[5],a[7]=0,a[8]=r[6],a[9]=r[7],a[10]=r[8],a[11]=0,a[12]=o.x,a[13]=o.y,a[14]=o.z,a[15]=1,a):new f(r[0],r[3],r[6],o.x,r[1],r[4],r[7],o.y,r[2],r[5],r[8],o.z,0,0,0,1)},f.fromTranslationQuaternionRotationScale=function(e,r,t,o){if(!n(e))throw new i("translation is required.");if(!n(r))throw new i("rotation is required.");if(!n(t))throw new i("scale is required.");n(o)||(o=new f);var a=t.x,s=t.y,u=t.z,l=r.x*r.x,c=r.x*r.y,h=r.x*r.z,d=r.x*r.w,w=r.y*r.y,E=r.y*r.z,m=r.y*r.w,p=r.z*r.z,T=r.z*r.w,y=r.w*r.w,R=l-w-p+y,A=2*(c-T),v=2*(h+m),_=2*(c+T),S=-l+w-p+y,g=2*(E-d),C=2*(h-m),N=2*(E+d),I=-l-w+p+y;return o[0]=R*a,o[1]=_*a,o[2]=C*a,o[3]=0,o[4]=A*s,o[5]=S*s,o[6]=N*s,o[7]=0,o[8]=v*u,o[9]=g*u,o[10]=I*u,o[11]=0,o[12]=e.x,o[13]=e.y,o[14]=e.z,o[15]=1,o},f.fromTranslation=function(e,r){if(!n(e))throw new i("translation is required.");return f.fromRotationTranslation(s.IDENTITY,e,r)},f.fromScale=function(e,r){if(!n(e))throw new i("scale is required.");return n(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e.y,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e.z,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new f(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},f.fromUniformScale=function(e,r){if("number"!=typeof e)throw new i("scale is required.");return n(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new f(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var l=new e,c=new e,h=new e;f.fromCamera=function(r,t){if(!n(r))throw new i("camera is required.");var o=r.eye,a=r.target,s=r.up;if(!n(o))throw new i("camera.eye is required.");if(!n(a))throw new i("camera.target is required.");if(!n(s))throw new i("camera.up is required.");e.normalize(e.subtract(a,o,l),l),e.normalize(e.cross(l,s,c),c),e.normalize(e.cross(c,l,h),h);var u=c.x,d=c.y,w=c.z,E=l.x,m=l.y,p=l.z,T=h.x,y=h.y,R=h.z,A=o.x,v=o.y,_=o.z,S=u*-A+d*-v+w*-_,g=T*-A+y*-v+R*-_,C=E*A+m*v+p*_;return n(t)?(t[0]=u,t[1]=T,t[2]=-E,t[3]=0,t[4]=d,t[5]=y,t[6]=-m,t[7]=0,t[8]=w,t[9]=R,t[10]=-p,t[11]=0,t[12]=S,t[13]=g,t[14]=C,t[15]=1,t):new f(u,d,w,S,T,y,R,g,-E,-m,-p,C,0,0,0,1)},f.computePerspectiveFieldOfView=function(e,r,t,o,a){if(0>=e||e>Math.PI)throw new i("fovY must be in [0, PI).");if(0>=r)throw new i("aspectRatio must be greater than zero.");if(0>=t)throw new i("near must be greater than zero.");if(0>=o)throw new i("far must be greater than zero.");if(!n(a))throw new i("result is required");var s=Math.tan(.5*e),u=1/s,f=u/r,l=(o+t)/(t-o),c=2*o*t/(t-o);return a[0]=f,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=l,a[11]=-1,a[12]=0,a[13]=0,a[14]=c,a[15]=0,a},f.computeOrthographicOffCenter=function(e,r,t,o,a,s,u){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(o))throw new i("top is required.");if(!n(a))throw new i("near is required.");if(!n(s))throw new i("far is required.");if(!n(u))throw new i("result is required");var f=1/(r-e),l=1/(o-t),c=1/(s-a),h=-(r+e)*f,d=-(o+t)*l,w=-(s+a)*c;return f*=2,l*=2,c*=-2,u[0]=f,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=l,u[6]=0,u[7]=0,u[8]=0,u[9]=0,u[10]=c,u[11]=0,u[12]=h,u[13]=d,u[14]=w,u[15]=1,u},f.computePerspectiveOffCenter=function(e,r,t,o,a,s,u){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(o))throw new i("top is required.");if(!n(a))throw new i("near is required.");if(!n(s))throw new i("far is required.");if(!n(u))throw new i("result is required");var f=2*a/(r-e),l=2*a/(o-t),c=(r+e)/(r-e),h=(o+t)/(o-t),d=-(s+a)/(s-a),w=-1,E=-2*s*a/(s-a);return u[0]=f,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=l,u[6]=0,u[7]=0,u[8]=c,u[9]=h,u[10]=d,u[11]=w,u[12]=0,u[13]=0,u[14]=E,u[15]=0,u},f.computeInfinitePerspectiveOffCenter=function(e,r,t,o,a,s){if(!n(e))throw new i("left is required.");if(!n(r))throw new i("right is required.");if(!n(t))throw new i("bottom is required.");if(!n(o))throw new i("top is required.");if(!n(a))throw new i("near is required.");if(!n(s))throw new i("result is required");var u=2*a/(r-e),f=2*a/(o-t),l=(r+e)/(r-e),c=(o+t)/(o-t),h=-1,d=-1,w=-2*a;return s[0]=u,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=f,s[6]=0,s[7]=0,s[8]=l,s[9]=c,s[10]=h,s[11]=d,s[12]=0,s[13]=0,s[14]=w,s[15]=0,s},f.computeViewportTransformation=function(e,r,o,a){if(!n(a))throw new i("result is required");e=t(e,t.EMPTY_OBJECT);var s=t(e.x,0),u=t(e.y,0),f=t(e.width,0),l=t(e.height,0);r=t(r,0),o=t(o,1);var c=.5*f,h=.5*l,d=.5*(o-r),w=c,E=h,m=d,p=s+c,T=u+h,y=r+d,R=1;return a[0]=w,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=E,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=m,a[11]=0,a[12]=p,a[13]=T,a[14]=y,a[15]=R,a},f.toArray=function(e,r){if(!n(e))throw new i("matrix is required");return n(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},f.getElementIndex=function(e,r){if("number"!=typeof r||0>r||r>3)throw new i("row must be 0, 1, 2, or 3.");if("number"!=typeof e||0>e||e>3)throw new i("column must be 0, 1, 2, or 3.");return 4*e+r},f.getColumn=function(e,r,t){if(!n(e))throw new i("matrix is required.");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(t))throw new i("result is required");var o=4*r,a=e[o],s=e[o+1],u=e[o+2],f=e[o+3];return t.x=a,t.y=s,t.z=u,t.w=f,t},f.setColumn=function(e,r,t,o){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(o))throw new i("result is required");o=f.clone(e,o);var a=4*r;return o[a]=t.x,o[a+1]=t.y,o[a+2]=t.z,o[a+3]=t.w,o},f.setTranslation=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("translation is required");if(!n(t))throw new i("result is required");return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=r.x,t[13]=r.y,t[14]=r.z,t[15]=e[15],t},f.getRow=function(e,r,t){if(!n(e))throw new i("matrix is required.");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(t))throw new i("result is required");var o=e[r],a=e[r+4],s=e[r+8],u=e[r+12];return t.x=o,t.y=a,t.z=s,t.w=u,t},f.setRow=function(e,r,t,o){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("cartesian is required");if("number"!=typeof r||0>r||r>3)throw new i("index must be 0, 1, 2, or 3.");if(!n(o))throw new i("result is required");return o=f.clone(e,o),o[r]=t.x,o[r+4]=t.y,o[r+8]=t.z,o[r+12]=t.w,o};var d=new e;f.getScale=function(r,t){if(!n(r))throw new i("matrix is required.");if(!n(t))throw new i("result is required");return t.x=e.magnitude(e.fromElements(r[0],r[1],r[2],d)),t.y=e.magnitude(e.fromElements(r[4],r[5],r[6],d)),t.z=e.magnitude(e.fromElements(r[8],r[9],r[10],d)),t};var w=new e;f.getMaximumScale=function(r){return f.getScale(r,w),e.maximumComponent(w)},f.multiply=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");var o=e[0],a=e[1],s=e[2],u=e[3],f=e[4],l=e[5],c=e[6],h=e[7],d=e[8],w=e[9],E=e[10],m=e[11],p=e[12],T=e[13],y=e[14],R=e[15],A=r[0],v=r[1],_=r[2],S=r[3],g=r[4],C=r[5],N=r[6],I=r[7],O=r[8],b=r[9],M=r[10],q=r[11],L=r[12],F=r[13],P=r[14],D=r[15],x=o*A+f*v+d*_+p*S,U=a*A+l*v+w*_+T*S,B=s*A+c*v+E*_+y*S,G=u*A+h*v+m*_+R*S,z=o*g+f*C+d*N+p*I,V=a*g+l*C+w*N+T*I,H=s*g+c*C+E*N+y*I,W=u*g+h*C+m*N+R*I,Y=o*O+f*b+d*M+p*q,X=a*O+l*b+w*M+T*q,k=s*O+c*b+E*M+y*q,K=u*O+h*b+m*M+R*q,Z=o*L+f*F+d*P+p*D,j=a*L+l*F+w*P+T*D,Q=s*L+c*F+E*P+y*D,J=u*L+h*F+m*P+R*D;return t[0]=x,t[1]=U,t[2]=B,t[3]=G,t[4]=z,t[5]=V,t[6]=H,t[7]=W,t[8]=Y,t[9]=X,t[10]=k,t[11]=K,t[12]=Z,t[13]=j,t[14]=Q,t[15]=J,t},f.add=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t[3]=e[3]+r[3],t[4]=e[4]+r[4],t[5]=e[5]+r[5],t[6]=e[6]+r[6],t[7]=e[7]+r[7],t[8]=e[8]+r[8],t[9]=e[9]+r[9],t[10]=e[10]+r[10],t[11]=e[11]+r[11],t[12]=e[12]+r[12],t[13]=e[13]+r[13],t[14]=e[14]+r[14],t[15]=e[15]+r[15],t},f.subtract=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t[3]=e[3]-r[3],t[4]=e[4]-r[4],t[5]=e[5]-r[5],t[6]=e[6]-r[6],t[7]=e[7]-r[7],t[8]=e[8]-r[8],t[9]=e[9]-r[9],t[10]=e[10]-r[10],t[11]=e[11]-r[11],t[12]=e[12]-r[12],t[13]=e[13]-r[13],t[14]=e[14]-r[14],t[15]=e[15]-r[15],t},f.multiplyTransformation=function(e,r,t){if(!n(e))throw new i("left is required");if(!n(r))throw new i("right is required");if(!n(t))throw new i("result is required");var o=e[0],a=e[1],s=e[2],u=e[4],f=e[5],l=e[6],c=e[8],h=e[9],d=e[10],w=e[12],E=e[13],m=e[14],p=r[0],T=r[1],y=r[2],R=r[4],A=r[5],v=r[6],_=r[8],S=r[9],g=r[10],C=r[12],N=r[13],I=r[14],O=o*p+u*T+c*y,b=a*p+f*T+h*y,M=s*p+l*T+d*y,q=o*R+u*A+c*v,L=a*R+f*A+h*v,F=s*R+l*A+d*v,P=o*_+u*S+c*g,D=a*_+f*S+h*g,x=s*_+l*S+d*g,U=o*C+u*N+c*I+w,B=a*C+f*N+h*I+E,G=s*C+l*N+d*I+m;return t[0]=O,t[1]=b,t[2]=M,t[3]=0,t[4]=q,t[5]=L,t[6]=F,t[7]=0,t[8]=P,t[9]=D,t[10]=x,t[11]=0,t[12]=U,t[13]=B,t[14]=G,t[15]=1,t},f.multiplyByMatrix3=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("rotation is required");if(!n(t))throw new i("result is required");var o=e[0],a=e[1],s=e[2],u=e[4],f=e[5],l=e[6],c=e[8],h=e[9],d=e[10],w=r[0],E=r[1],m=r[2],p=r[3],T=r[4],y=r[5],R=r[6],A=r[7],v=r[8],_=o*w+u*E+c*m,S=a*w+f*E+h*m,g=s*w+l*E+d*m,C=o*p+u*T+c*y,N=a*p+f*T+h*y,I=s*p+l*T+d*y,O=o*R+u*A+c*v,b=a*R+f*A+h*v,M=s*R+l*A+d*v;return t[0]=_,t[1]=S,t[2]=g,t[3]=0,t[4]=C,t[5]=N,t[6]=I,t[7]=0,t[8]=O,t[9]=b,t[10]=M,t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},f.multiplyByTranslation=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("translation is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,s=r.z,u=o*e[0]+a*e[4]+s*e[8]+e[12],f=o*e[1]+a*e[5]+s*e[9]+e[13],l=o*e[2]+a*e[6]+s*e[10]+e[14];return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=u,t[13]=f,t[14]=l,t[15]=e[15],t};var E=new e;f.multiplyByUniformScale=function(e,r,t){if(!n(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scale is required");if(!n(t))throw new i("result is required");return E.x=r,E.y=r,E.z=r,f.multiplyByScale(e,E,t)},f.multiplyByScale=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("scale is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,s=r.z;return 1===o&&1===a&&1===s?f.clone(e,t):(t[0]=o*e[0],t[1]=o*e[1],t[2]=o*e[2],t[3]=0,t[4]=a*e[4],t[5]=a*e[5],t[6]=a*e[6],t[7]=0,t[8]=s*e[8],t[9]=s*e[9],t[10]=s*e[10],t[11]=0,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=1,t)},f.multiplyByVector=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,s=r.z,u=r.w,f=e[0]*o+e[4]*a+e[8]*s+e[12]*u,l=e[1]*o+e[5]*a+e[9]*s+e[13]*u,c=e[2]*o+e[6]*a+e[10]*s+e[14]*u,h=e[3]*o+e[7]*a+e[11]*s+e[15]*u;return t.x=f,t.y=l,t.z=c,t.w=h,t},f.multiplyByPointAsVector=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,s=r.z,u=e[0]*o+e[4]*a+e[8]*s,f=e[1]*o+e[5]*a+e[9]*s,l=e[2]*o+e[6]*a+e[10]*s;return t.x=u,t.y=f,t.z=l,t},f.multiplyByPoint=function(e,r,t){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("cartesian is required");if(!n(t))throw new i("result is required");var o=r.x,a=r.y,s=r.z,u=e[0]*o+e[4]*a+e[8]*s+e[12],f=e[1]*o+e[5]*a+e[9]*s+e[13],l=e[2]*o+e[6]*a+e[10]*s+e[14];return t.x=u,t.y=f,t.z=l,t},f.multiplyByScalar=function(e,r,t){if(!n(e))throw new i("matrix is required");if("number"!=typeof r)throw new i("scalar must be a number");if(!n(t))throw new i("result is required");return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*r,t[5]=e[5]*r,t[6]=e[6]*r,t[7]=e[7]*r,t[8]=e[8]*r,t[9]=e[9]*r,t[10]=e[10]*r,t[11]=e[11]*r,t[12]=e[12]*r,t[13]=e[13]*r,t[14]=e[14]*r,t[15]=e[15]*r,t},f.negate=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r[9]=-e[9],r[10]=-e[10],r[11]=-e[11],r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=-e[15],r},f.transpose=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");var t=e[1],o=e[2],a=e[3],s=e[6],u=e[7],f=e[11];return r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=t,r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=o,r[9]=s,r[10]=e[10],r[11]=e[14],r[12]=a,r[13]=u,r[14]=f,r[15]=e[15],r},f.abs=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r[9]=Math.abs(e[9]),r[10]=Math.abs(e[10]),r[11]=Math.abs(e[11]),r[12]=Math.abs(e[12]),r[13]=Math.abs(e[13]),r[14]=Math.abs(e[14]),r[15]=Math.abs(e[15]),r},f.equals=function(e,r){return e===r||n(e)&&n(r)&&e[12]===r[12]&&e[13]===r[13]&&e[14]===r[14]&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[8]===r[8]&&e[9]===r[9]&&e[10]===r[10]&&e[3]===r[3]&&e[7]===r[7]&&e[11]===r[11]&&e[15]===r[15]},f.equalsEpsilon=function(e,r,t){if("number"!=typeof t)throw new i("epsilon must be a number");return e===r||n(e)&&n(r)&&Math.abs(e[0]-r[0])<=t&&Math.abs(e[1]-r[1])<=t&&Math.abs(e[2]-r[2])<=t&&Math.abs(e[3]-r[3])<=t&&Math.abs(e[4]-r[4])<=t&&Math.abs(e[5]-r[5])<=t&&Math.abs(e[6]-r[6])<=t&&Math.abs(e[7]-r[7])<=t&&Math.abs(e[8]-r[8])<=t&&Math.abs(e[9]-r[9])<=t&&Math.abs(e[10]-r[10])<=t&&Math.abs(e[11]-r[11])<=t&&Math.abs(e[12]-r[12])<=t&&Math.abs(e[13]-r[13])<=t&&Math.abs(e[14]-r[14])<=t&&Math.abs(e[15]-r[15])<=t},f.getTranslation=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r.x=e[12],r.y=e[13],r.z=e[14],r},f.getRotation=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[4],r[4]=e[5],r[5]=e[6],r[6]=e[8],r[7]=e[9],r[8]=e[10],r};var m=new s,p=new s,T=new r,y=new r(0,0,0,1);return f.inverse=function(e,t){if(!n(e))throw new i("matrix is required");if(!n(t))throw new i("result is required");if(s.equalsEpsilon(f.getRotation(e,m),p,a.EPSILON7)&&r.equals(f.getRow(e,3,T),y))return t[0]=0,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=0,t[11]=0,t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=1,t;var o=e[0],l=e[4],c=e[8],h=e[12],d=e[1],w=e[5],E=e[9],R=e[13],A=e[2],v=e[6],_=e[10],S=e[14],g=e[3],C=e[7],N=e[11],I=e[15],O=_*I,b=S*N,M=v*I,q=S*C,L=v*N,F=_*C,P=A*I,D=S*g,x=A*N,U=_*g,B=A*C,G=v*g,z=O*w+q*E+L*R-(b*w+M*E+F*R),V=b*d+P*E+U*R-(O*d+D*E+x*R),H=M*d+D*w+B*R-(q*d+P*w+G*R),W=F*d+x*w+G*E-(L*d+U*w+B*E),Y=b*l+M*c+F*h-(O*l+q*c+L*h),X=O*o+D*c+x*h-(b*o+P*c+U*h),k=q*o+P*l+G*h-(M*o+D*l+B*h),K=L*o+U*l+B*c-(F*o+x*l+G*c);O=c*R,b=h*E,M=l*R,q=h*w,L=l*E,F=c*w,P=o*R,D=h*d,x=o*E,U=c*d,B=o*w,G=l*d;var Z=O*C+q*N+L*I-(b*C+M*N+F*I),j=b*g+P*N+U*I-(O*g+D*N+x*I),Q=M*g+D*C+B*I-(q*g+P*C+G*I),J=F*g+x*C+G*N-(L*g+U*C+B*N),$=M*_+F*S+b*v-(L*S+O*v+q*_),ee=x*S+O*A+D*_-(P*_+U*S+b*A),re=P*v+G*S+q*A-(B*S+M*A+D*v),te=B*_+L*A+U*v-(x*v+G*_+F*A),ne=o*z+l*V+c*H+h*W;if(Math.abs(ne)<a.EPSILON20)throw new u("matrix is not invertible because its determinate is zero.");return ne=1/ne,t[0]=z*ne,t[1]=V*ne,t[2]=H*ne,t[3]=W*ne,t[4]=Y*ne,t[5]=X*ne,t[6]=k*ne,t[7]=K*ne,t[8]=Z*ne,t[9]=j*ne,t[10]=Q*ne,t[11]=J*ne,t[12]=$*ne,t[13]=ee*ne,t[14]=re*ne,t[15]=te*ne,t},f.inverseTransformation=function(e,r){if(!n(e))throw new i("matrix is required");if(!n(r))throw new i("result is required");var t=e[0],o=e[1],a=e[2],s=e[4],u=e[5],f=e[6],l=e[8],c=e[9],h=e[10],d=e[12],w=e[13],E=e[14],m=-t*d-o*w-a*E,p=-s*d-u*w-f*E,T=-l*d-c*w-h*E;return r[0]=t,r[1]=s,r[2]=l,r[3]=0,r[4]=o,r[5]=u,r[6]=c,r[7]=0,r[8]=a,r[9]=f,r[10]=h,r[11]=0,r[12]=m,r[13]=p,r[14]=T,r[15]=1,r},f.IDENTITY=o(new f(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),f.ZERO=o(new f(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),f.COLUMN0ROW0=0,f.COLUMN0ROW1=1,f.COLUMN0ROW2=2,f.COLUMN0ROW3=3,f.COLUMN1ROW0=4,f.COLUMN1ROW1=5,f.COLUMN1ROW2=6,f.COLUMN1ROW3=7,f.COLUMN2ROW0=8,f.COLUMN2ROW1=9,f.COLUMN2ROW2=10,f.COLUMN2ROW3=11,f.COLUMN3ROW0=12,f.COLUMN3ROW1=13,f.COLUMN3ROW2=14,f.COLUMN3ROW3=15,f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f.equalsArray=function(e,r,t){return e[0]===r[t]&&e[1]===r[t+1]&&e[2]===r[t+2]&&e[3]===r[t+3]&&e[4]===r[t+4]&&e[5]===r[t+5]&&e[6]===r[t+6]&&e[7]===r[t+7]&&e[8]===r[t+8]&&e[9]===r[t+9]&&e[10]===r[t+10]&&e[11]===r[t+11]&&e[12]===r[t+12]&&e[13]===r[t+13]&&e[14]===r[t+14]&&e[15]===r[t+15]},f.prototype.equalsEpsilon=function(e,r){return f.equalsEpsilon(this,e,r)},f.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},f}),define("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,r,t,n){"use strict";var i=function(n,i){if(!r(n))throw new t("normal is required.");if(!r(i))throw new t("distance is required.");this.normal=e.clone(n),this.distance=i};i.fromPointNormal=function(n,o,a){if(!r(n))throw new t("point is required.");if(!r(o))throw new t("normal is required.");var s=-e.dot(o,n);return r(a)?(e.clone(o,a.normal),a.distance=s,a):new i(o,s)};var o=new e;return i.fromCartesian4=function(n,a){if(!r(n))throw new t("coefficients is required.");var s=e.fromCartesian4(n,o),u=n.w;return r(a)?(e.clone(s,a.normal),a.distance=u,a):new i(s,u)},i.getPointDistance=function(n,i){if(!r(n))throw new t("plane is required.");if(!r(i))throw new t("point is required.");return e.dot(n.normal,i)+n.distance},i.ORIGIN_XY_PLANE=n(new i(e.UNIT_Z,0)),i.ORIGIN_YZ_PLANE=n(new i(e.UNIT_X,0)),i.ORIGIN_ZX_PLANE=n(new i(e.UNIT_Y,0)),i}),define("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,r,t,n,i,o,a,s){"use strict";var u=function(e,t,n,i){this.west=r(e,0),this.south=r(t,0),this.east=r(n,0),this.north=r(i,0)};n(u.prototype,{width:{get:function(){return u.computeWidth(this)}},height:{get:function(){return u.computeHeight(this)}}}),u.packedLength=4,u.pack=function(e,n,o){if(!t(e))throw new i("value is required");if(!t(n))throw new i("array is required");o=r(o,0),n[o++]=e.west,n[o++]=e.south,n[o++]=e.east,n[o]=e.north},u.unpack=function(e,n,o){if(!t(e))throw new i("array is required");return n=r(n,0),t(o)||(o=new u),o.west=e[n++],o.south=e[n++],o.east=e[n++],o.north=e[n],o},u.computeWidth=function(e){if(!t(e))throw new i("rectangle is required.");var r=e.east,n=e.west;return n>r&&(r+=s.TWO_PI),r-n},u.computeHeight=function(e){if(!t(e))throw new i("rectangle is required.");return e.north-e.south},u.fromDegrees=function(e,n,i,o,a){return e=s.toRadians(r(e,0)),n=s.toRadians(r(n,0)),i=s.toRadians(r(i,0)),o=s.toRadians(r(o,0)),t(a)?(a.west=e,a.south=n,a.east=i,a.north=o,a):new u(e,n,i,o)},u.fromCartographicArray=function(e,r){if(!t(e))throw new i("cartographics is required.");for(var n=Number.MAX_VALUE,o=-Number.MAX_VALUE,a=Number.MAX_VALUE,s=-Number.MAX_VALUE,f=0,l=e.length;l>f;f++){var c=e[f];n=Math.min(n,c.longitude),o=Math.max(o,c.longitude),a=Math.min(a,c.latitude),s=Math.max(s,c.latitude)}return t(r)?(r.west=n,r.south=a,r.east=o,r.north=s,r):new u(n,a,o,s)},u.clone=function(e,r){return t(e)?t(r)?(r.west=e.west,r.south=e.south,r.east=e.east,r.north=e.north,r):new u(e.west,e.south,e.east,e.north):void 0},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.equals=function(e,r){return e===r||t(e)&&t(r)&&e.west===r.west&&e.south===r.south&&e.east===r.east&&e.north===r.north},u.prototype.equalsEpsilon=function(e,r){if("number"!=typeof r)throw new i("epsilon is required and must be a number.");return t(e)&&Math.abs(this.west-e.west)<=r&&Math.abs(this.south-e.south)<=r&&Math.abs(this.east-e.east)<=r&&Math.abs(this.north-e.north)<=r},u.validate=function(e){if(!t(e))throw new i("rectangle is required");var r=e.north;if("number"!=typeof r)throw new i("north is required to be a number.");if(r<-s.PI_OVER_TWO||r>s.PI_OVER_TWO)throw new i("north must be in the interval [-Pi/2, Pi/2].");var n=e.south;if("number"!=typeof n)throw new i("south is required to be a number.");if(n<-s.PI_OVER_TWO||n>s.PI_OVER_TWO)throw new i("south must be in the interval [-Pi/2, Pi/2].");var o=e.west;if("number"!=typeof o)throw new i("west is required to be a number.");if(o<-Math.PI||o>Math.PI)throw new i("west must be in the interval [-Pi, Pi].");var a=e.east;if("number"!=typeof a)throw new i("east is required to be a number.");if(a<-Math.PI||a>Math.PI)throw new i("east must be in the interval [-Pi, Pi].")},u.southwest=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.west,n.latitude=r.south,n.height=0,n):new e(r.west,r.south)},u.northwest=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.west,n.latitude=r.north,n.height=0,n):new e(r.west,r.north)},u.northeast=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.east,n.latitude=r.north,n.height=0,n):new e(r.east,r.north)},u.southeast=function(r,n){if(!t(r))throw new i("rectangle is required");return t(n)?(n.longitude=r.east,n.latitude=r.south,n.height=0,n):new e(r.east,r.south)},u.center=function(r,n){if(!t(r))throw new i("rectangle is required");var o=r.east,a=r.west;a>o&&(o+=s.TWO_PI);var u=s.negativePiToPi(.5*(a+o)),f=.5*(r.south+r.north);return t(n)?(n.longitude=u,n.latitude=f,n.height=0,n):new e(u,f)},u.intersection=function(e,r,n){if(!t(e))throw new i("rectangle is required");if(!t(r))throw new i("otherRectangle is required.");var o=e.east,a=e.west,f=r.east,l=r.west;a>o&&f>0?o+=s.TWO_PI:l>f&&o>0&&(f+=s.TWO_PI),a>o&&0>l?l+=s.TWO_PI:l>f&&0>a&&(a+=s.TWO_PI);var c=s.negativePiToPi(Math.max(a,l)),h=s.negativePiToPi(Math.min(o,f));if((e.west<e.east||r.west<r.east)&&c>=h)return void 0;var d=Math.max(e.south,r.south),w=Math.min(e.north,r.north);return d>=w?void 0:t(n)?(n.west=c,n.south=d,n.east=h,n.north=w,n):new u(c,d,h,w)},u.contains=function(e,r){if(!t(e))throw new i("rectangle is required");if(!t(r))throw new i("cartographic is required.");var n=r.longitude,o=r.latitude,a=e.west,u=e.east;return a>u&&(u+=s.TWO_PI,0>n&&(n+=s.TWO_PI)),(n>a||s.equalsEpsilon(n,a,s.EPSILON14))&&(u>n||s.equalsEpsilon(n,u,s.EPSILON14))&&o>=e.south&&o<=e.north};var f=new e;return u.subsample=function(e,n,a,l){if(!t(e))throw new i("rectangle is required");n=r(n,o.WGS84),a=r(a,0),t(l)||(l=[]);var c=0,h=e.north,d=e.south,w=e.east,E=e.west,m=f;m.height=a,m.longitude=E,m.latitude=h,l[c]=n.cartographicToCartesian(m,l[c]),c++,m.longitude=w,l[c]=n.cartographicToCartesian(m,l[c]),c++,m.latitude=d,l[c]=n.cartographicToCartesian(m,l[c]),c++,m.longitude=E,l[c]=n.cartographicToCartesian(m,l[c]),c++,0>h?m.latitude=h:d>0?m.latitude=d:m.latitude=0;for(var p=1;8>p;++p)m.longitude=-Math.PI+p*s.PI_OVER_TWO,u.contains(e,m)&&(l[c]=n.cartographicToCartesian(m,l[c]),c++);return 0===m.latitude&&(m.longitude=E,l[c]=n.cartographicToCartesian(m,l[c]),c++,m.longitude=w,l[c]=n.cartographicToCartesian(m,l[c]),c++),l.length=c,l},u.MAX_VALUE=a(new u(-Math.PI,-s.PI_OVER_TWO,Math.PI,s.PI_OVER_TWO)),u}),define("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Plane","./Rectangle"],function(e,r,t,n,i,o,a,s,u,f,l,c,h){
"use strict";var d=function(r,n){this.center=e.clone(t(r,e.ZERO)),this.radius=t(n,0)},w=new e,E=new e,m=new e,p=new e,T=new e,y=new e,R=new e,A=new e,v=new e,_=new e,S=new e,g=new e;d.fromPoints=function(r,t){if(n(t)||(t=new d),!n(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;for(var i=e.clone(r[0],R),o=e.clone(i,w),a=e.clone(i,E),s=e.clone(i,m),u=e.clone(i,p),f=e.clone(i,T),l=e.clone(i,y),c=r.length,h=1;c>h;h++){e.clone(r[h],i);var C=i.x,N=i.y,I=i.z;C<o.x&&e.clone(i,o),C>u.x&&e.clone(i,u),N<a.y&&e.clone(i,a),N>f.y&&e.clone(i,f),I<s.z&&e.clone(i,s),I>l.z&&e.clone(i,l)}var O=e.magnitudeSquared(e.subtract(u,o,A)),b=e.magnitudeSquared(e.subtract(f,a,A)),M=e.magnitudeSquared(e.subtract(l,s,A)),q=o,L=u,F=O;b>F&&(F=b,q=a,L=f),M>F&&(F=M,q=s,L=l);var P=v;P.x=.5*(q.x+L.x),P.y=.5*(q.y+L.y),P.z=.5*(q.z+L.z);var D=e.magnitudeSquared(e.subtract(L,P,A)),x=Math.sqrt(D),U=_;U.x=o.x,U.y=a.y,U.z=s.z;var B=S;B.x=u.x,B.y=f.y,B.z=l.z;var G=e.multiplyByScalar(e.add(U,B,A),.5,g),z=0;for(h=0;c>h;h++){e.clone(r[h],i);var V=e.magnitude(e.subtract(i,G,A));V>z&&(z=V);var H=e.magnitudeSquared(e.subtract(i,P,A));if(H>D){var W=Math.sqrt(H);x=.5*(x+W),D=x*x;var Y=W-x;P.x=(x*P.x+Y*i.x)/W,P.y=(x*P.y+Y*i.y)/W,P.z=(x*P.z+Y*i.z)/W}}return z>x?(e.clone(P,t.center),t.radius=x):(e.clone(G,t.center),t.radius=z),t};var C=new s,N=new e,I=new e,O=new r,b=new r;d.fromRectangle2D=function(e,r,t){return d.fromRectangleWithHeights2D(e,r,0,0,t)},d.fromRectangleWithHeights2D=function(r,i,o,a,s){if(n(s)||(s=new d),!n(r))return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;i=t(i,C),h.southwest(r,O),O.height=o,h.northeast(r,b),b.height=a;var u=i.project(O,N),f=i.project(b,I),l=f.x-u.x,c=f.y-u.y,w=f.z-u.z;s.radius=.5*Math.sqrt(l*l+c*c+w*w);var E=s.center;return E.x=u.x+.5*l,E.y=u.y+.5*c,E.z=u.z+.5*w,s};var M=[];d.fromRectangle3D=function(e,r,i,o){r=t(r,a.WGS84),i=t(i,0);var s;return n(e)&&(s=h.subsample(e,r,i,M)),d.fromPoints(s,o)},d.fromVertices=function(r,i,a,s){if(n(s)||(s=new d),!n(r)||0===r.length)return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;if(i=t(i,e.ZERO),a=t(a,3),3>a)throw new o("stride must be 3 or greater.");var u=R;u.x=r[0]+i.x,u.y=r[1]+i.y,u.z=r[2]+i.z;for(var f=e.clone(u,w),l=e.clone(u,E),c=e.clone(u,m),h=e.clone(u,p),C=e.clone(u,T),N=e.clone(u,y),I=r.length,O=0;I>O;O+=a){var b=r[O]+i.x,M=r[O+1]+i.y,q=r[O+2]+i.z;u.x=b,u.y=M,u.z=q,b<f.x&&e.clone(u,f),b>h.x&&e.clone(u,h),M<l.y&&e.clone(u,l),M>C.y&&e.clone(u,C),q<c.z&&e.clone(u,c),q>N.z&&e.clone(u,N)}var L=e.magnitudeSquared(e.subtract(h,f,A)),F=e.magnitudeSquared(e.subtract(C,l,A)),P=e.magnitudeSquared(e.subtract(N,c,A)),D=f,x=h,U=L;F>U&&(U=F,D=l,x=C),P>U&&(U=P,D=c,x=N);var B=v;B.x=.5*(D.x+x.x),B.y=.5*(D.y+x.y),B.z=.5*(D.z+x.z);var G=e.magnitudeSquared(e.subtract(x,B,A)),z=Math.sqrt(G),V=_;V.x=f.x,V.y=l.y,V.z=c.z;var H=S;H.x=h.x,H.y=C.y,H.z=N.z;var W=e.multiplyByScalar(e.add(V,H,A),.5,g),Y=0;for(O=0;I>O;O+=a){u.x=r[O]+i.x,u.y=r[O+1]+i.y,u.z=r[O+2]+i.z;var X=e.magnitude(e.subtract(u,W,A));X>Y&&(Y=X);var k=e.magnitudeSquared(e.subtract(u,B,A));if(k>G){var K=Math.sqrt(k);z=.5*(z+K),G=z*z;var Z=K-z;B.x=(z*B.x+Z*u.x)/K,B.y=(z*B.y+Z*u.y)/K,B.z=(z*B.z+Z*u.z)/K}}return Y>z?(e.clone(B,s.center),s.radius=z):(e.clone(W,s.center),s.radius=Y),s},d.fromCornerPoints=function(r,t,i){if(!n(r)||!n(t))throw new o("corner and oppositeCorner are required.");n(i)||(i=new d);var a=i.center;return e.add(r,t,a),e.multiplyByScalar(a,.5,a),i.radius=e.distance(a,t),i},d.fromEllipsoid=function(r,t){if(!n(r))throw new o("ellipsoid is required.");return n(t)||(t=new d),e.clone(e.ZERO,t.center),t.radius=r.maximumRadius,t};var q=new e;d.fromBoundingSpheres=function(r,t){if(n(t)||(t=new d),!n(r)||0===r.length)return t.center=e.clone(e.ZERO,t.center),t.radius=0,t;var i=r.length;if(1===i)return d.clone(r[0],t);if(2===i)return d.union(r[0],r[1],t);for(var o=[],a=0;i>a;a++)o.push(r[a].center);t=d.fromPoints(o,t);var s=t.center,u=t.radius;for(a=0;i>a;a++){var f=r[a];u=Math.max(u,e.distance(s,f.center,q)+f.radius)}return t.radius=u,t},d.clone=function(r,t){return n(r)?n(t)?(t.center=e.clone(r.center,t.center),t.radius=r.radius,t):new d(r.center,r.radius):void 0},d.packedLength=4,d.pack=function(e,r,i){if(!n(e))throw new o("value is required");if(!n(r))throw new o("array is required");i=t(i,0);var a=e.center;r[i++]=a.x,r[i++]=a.y,r[i++]=a.z,r[i]=e.radius},d.unpack=function(e,r,i){if(!n(e))throw new o("array is required");r=t(r,0),n(i)||(i=new d);var a=i.center;return a.x=e[r++],a.y=e[r++],a.z=e[r++],i.radius=e[r],i};var L=new e,F=new e;d.union=function(r,t,i){if(!n(r))throw new o("left is required.");if(!n(t))throw new o("right is required.");n(i)||(i=new d);var a=r.center,s=r.radius,u=t.center,f=t.radius,l=e.subtract(u,a,L),c=e.magnitude(l);if(s>=c+f)return r.clone(i),i;if(f>=c+s)return t.clone(i),i;var h=.5*(s+c+f),w=e.multiplyByScalar(l,(-s+h)/c,F);return e.add(w,a,w),e.clone(w,i.center),i.radius=h,i};var P=new e;d.expand=function(r,t,i){if(!n(r))throw new o("sphere is required.");if(!n(t))throw new o("point is required.");i=d.clone(r,i);var a=e.magnitude(e.subtract(t,i.center,P));return a>i.radius&&(i.radius=a),i},d.intersectPlane=function(r,t){if(!n(r))throw new o("sphere is required.");if(!n(t))throw new o("plane is required.");var i=r.center,a=r.radius,s=t.normal,f=e.dot(s,i)+t.distance;return-a>f?u.OUTSIDE:a>f?u.INTERSECTING:u.INSIDE},d.transform=function(e,r,t){if(!n(e))throw new o("sphere is required.");if(!n(r))throw new o("transform is required.");return n(t)||(t=new d),t.center=l.multiplyByPoint(r,e.center,t.center),t.radius=l.getMaximumScale(r)*e.radius,t};var D=new e;d.distanceSquaredTo=function(r,t){if(!n(r))throw new o("sphere is required.");if(!n(t))throw new o("cartesian is required.");var i=e.subtract(r.center,t,D);return e.magnitudeSquared(i)-r.radius*r.radius},d.transformWithoutScale=function(e,r,t){if(!n(e))throw new o("sphere is required.");if(!n(r))throw new o("transform is required.");return n(t)||(t=new d),t.center=l.multiplyByPoint(r,e.center,t.center),t.radius=e.radius,t};var x=new e;d.computePlaneDistances=function(r,t,i,a){if(!n(r))throw new o("sphere is required.");if(!n(t))throw new o("position is required.");if(!n(i))throw new o("direction is required.");n(a)||(a=new f);var s=e.subtract(r.center,t,x),u=e.dot(i,s);return a.start=u-r.radius,a.stop=u+r.radius,a};for(var U=new e,B=new e,G=new e,z=new e,V=new e,H=new r,W=new Array(8),Y=0;8>Y;++Y)W[Y]=new e;var X=new s;return d.projectTo2D=function(r,i,a){if(!n(r))throw new o("sphere is required.");i=t(i,X);var s=i.ellipsoid,u=r.center,f=r.radius,l=s.geodeticSurfaceNormal(u,U),c=e.cross(e.UNIT_Z,l,B);e.normalize(c,c);var h=e.cross(l,c,G);e.normalize(h,h),e.multiplyByScalar(l,f,l),e.multiplyByScalar(h,f,h),e.multiplyByScalar(c,f,c);var w=e.negate(h,V),E=e.negate(c,z),m=W,p=m[0];e.add(l,h,p),e.add(p,c,p),p=m[1],e.add(l,h,p),e.add(p,E,p),p=m[2],e.add(l,w,p),e.add(p,E,p),p=m[3],e.add(l,w,p),e.add(p,c,p),e.negate(l,l),p=m[4],e.add(l,h,p),e.add(p,c,p),p=m[5],e.add(l,h,p),e.add(p,E,p),p=m[6],e.add(l,w,p),e.add(p,E,p),p=m[7],e.add(l,w,p),e.add(p,c,p);for(var T=m.length,y=0;T>y;++y){var R=m[y];e.add(u,R,R);var A=s.cartesianToCartographic(R,H);i.project(A,R)}a=d.fromPoints(m,a),u=a.center;var v=u.x,_=u.y,S=u.z;return u.x=S,u.y=v,u.z=_,a},d.isOccluded=function(e,r){if(!n(e))throw new o("sphere is required.");if(!n(r))throw new o("occluder is required.");return!r.isBoundingSphereVisible(e)},d.equals=function(r,t){return r===t||n(r)&&n(t)&&e.equals(r.center,t.center)&&r.radius===t.radius},d.prototype.intersectPlane=function(e){return d.intersectPlane(this,e)},d.prototype.distanceSquaredTo=function(e){return d.distanceSquaredTo(this,e)},d.prototype.computePlaneDistances=function(e,r,t){return d.computePlaneDistances(this,e,r,t)},d.prototype.isOccluded=function(e){return d.isOccluded(this,e)},d.prototype.equals=function(e){return d.equals(this,e)},d.prototype.clone=function(e){return d.clone(this,e)},d}),define("Core/Fullscreen",["./defined","./defineProperties"],function(e,r){"use strict";var t,n={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},i={};return r(i,{element:{get:function(){return i.supportsFullscreen()?document[n.fullscreenElement]:void 0}},changeEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenchange:void 0}},errorEventName:{get:function(){return i.supportsFullscreen()?n.fullscreenerror:void 0}},enabled:{get:function(){return i.supportsFullscreen()?document[n.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return i.supportsFullscreen()?null!==i.element:void 0}}}),i.supportsFullscreen=function(){if(e(t))return t;t=!1;var r=document.body;if("function"==typeof r.requestFullscreen)return n.requestFullscreen="requestFullscreen",n.exitFullscreen="exitFullscreen",n.fullscreenEnabled="fullscreenEnabled",n.fullscreenElement="fullscreenElement",n.fullscreenchange="fullscreenchange",n.fullscreenerror="fullscreenerror",t=!0;for(var i,o=["webkit","moz","o","ms","khtml"],a=0,s=o.length;s>a;++a){var u=o[a];i=u+"RequestFullscreen","function"==typeof r[i]?(n.requestFullscreen=i,t=!0):(i=u+"RequestFullScreen","function"==typeof r[i]&&(n.requestFullscreen=i,t=!0)),i=u+"ExitFullscreen","function"==typeof document[i]?n.exitFullscreen=i:(i=u+"CancelFullScreen","function"==typeof document[i]&&(n.exitFullscreen=i)),i=u+"FullscreenEnabled",e(document[i])?n.fullscreenEnabled=i:(i=u+"FullScreenEnabled",e(document[i])&&(n.fullscreenEnabled=i)),i=u+"FullscreenElement",e(document[i])?n.fullscreenElement=i:(i=u+"FullScreenElement",e(document[i])&&(n.fullscreenElement=i)),i=u+"fullscreenchange",e(document["on"+i])&&("ms"===u&&(i="MSFullscreenChange"),n.fullscreenchange=i),i=u+"fullscreenerror",e(document["on"+i])&&("ms"===u&&(i="MSFullscreenError"),n.fullscreenerror=i)}return t},i.requestFullscreen=function(e){i.supportsFullscreen()&&e[n.requestFullscreen]()},i.exitFullscreen=function(){i.supportsFullscreen()&&document[n.exitFullscreen]()},i}),define("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,r,t){"use strict";function n(e){for(var r=e.split("."),t=0,n=r.length;n>t;++t)r[t]=parseInt(r[t],10);return r}function i(){if(!r(m)){m=!1;var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(m=!0,p=n(e[1]))}return m}function o(){return i()&&p}function a(){if(!r(T)&&(T=!1,!i()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(T=!0,y=n(e[1]))}return T}function s(){return a()&&y}function u(){if(!r(R)){R=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==e&&(R=!0,A=n(e[1]),A.isNightly=!!e[2])}return R}function f(){return u()&&A}function l(){if(!r(v)){v=!1;var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(v=!0,_=n(e[1]))):"Netscape"===navigator.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(v=!0,_=n(e[1])))}return v}function c(){return l()&&_}function h(){if(!r(S)){S=!1;var e=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(S=!0,g=n(e[1]))}return S}function d(){return r(C)||(C=/Windows/i.test(navigator.appVersion)),C}function w(){return h()&&g}function E(){return r(N)||(N=r(window.PointerEvent)&&(!r(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),N}var m,p,T,y,R,A,v,_,S,g,C,N,I={isChrome:i,chromeVersion:o,isSafari:a,safariVersion:s,isWebkit:u,webkitVersion:f,isInternetExplorer:l,internetExplorerVersion:c,isFirefox:h,firefoxVersion:w,isWindows:d,hardwareConcurrency:e(navigator.hardwareConcurrency,3),supportsPointerEvents:E};return I.supportsFullscreen=function(){return t.supportsFullscreen()},I.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},I.supportsWebWorkers=function(){return"undefined"!=typeof Worker},I}),define("Core/Color",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math"],function(e,r,t,n,i,o){"use strict";function a(e,r,t){return 0>t&&(t+=1),t>1&&(t-=1),1>6*t?e+6*(r-e)*t:1>2*t?r:2>3*t?e+(r-e)*(2/3-t)*6:e}var s=function(r,t,n,i){this.red=e(r,1),this.green=e(t,1),this.blue=e(n,1),this.alpha=e(i,1)};s.fromCartesian4=function(e,n){if(!r(e))throw new t("cartesian is required");return r(n)?(n.red=e.x,n.green=e.y,n.blue=e.z,n.alpha=e.w,n):new s(e.x,e.y,e.z,e.w)},s.fromBytes=function(t,n,i,o,a){return t=s.byteToFloat(e(t,255)),n=s.byteToFloat(e(n,255)),i=s.byteToFloat(e(i,255)),o=s.byteToFloat(e(o,255)),r(a)?(a.red=t,a.green=n,a.blue=i,a.alpha=o,a):new s(t,n,i,o)},s.fromAlpha=function(e,n,i){if(!r(e))throw new t("color is required");if(!r(n))throw new t("alpha is required");return r(i)?(i.red=e.red,i.green=e.green,i.blue=e.blue,i.alpha=n,i):new s(e.red,e.green,e.blue,n)};var u,f,l;n.supportsTypedArrays()&&(u=new ArrayBuffer(4),f=new Uint32Array(u),l=new Uint8Array(u)),s.fromRgba=function(e){return f[0]=e,s.fromBytes(l[0],l[1],l[2],l[3])},s.fromHsl=function(r,t,n,i){r=e(r,0)%1,t=e(t,0),n=e(n,0),i=e(i,1);var o=n,u=n,f=n;if(0!==t){var l;l=.5>n?n*(1+t):n+t-n*t;var c=2*n-l;o=a(c,l,r+1/3),u=a(c,l,r),f=a(c,l,r-1/3)}return new s(o,u,f,i)},s.fromRandom=function(n,i){n=e(n,e.EMPTY_OBJECT);var a=n.red;if(!r(a)){var u=e(n.minimumRed,0),f=e(n.maximumRed,1);if(u>f)throw new t("minimumRed must be less than or equal to maximumRed");a=u+o.nextRandomNumber()*(f-u)}var l=n.green;if(!r(l)){var c=e(n.minimumGreen,0),h=e(n.maximumGreen,1);if(c>h)throw new t("minimumGreen must be less than or equal to maximumGreen");l=c+o.nextRandomNumber()*(h-c)}var d=n.blue;if(!r(d)){var w=e(n.minimumBlue,0),E=e(n.maximumBlue,1);if(w>E)throw new t("minimumBlue must be less than or equal to maximumBlue");d=w+o.nextRandomNumber()*(E-w)}var m=n.alpha;if(!r(m)){var p=e(n.minimumAlpha,0),T=e(n.maximumAlpha,1);if(p>T)throw new t("minimumAlpha must be less than or equal to maximumAlpha");m=p+o.nextRandomNumber()*(T-p)}return r(i)?(i.red=a,i.green=l,i.blue=d,i.alpha=m,i):new s(a,l,d,m)};var c=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,h=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,d=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,w=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return s.fromCssColorString=function(n){if(!r(n))throw new t("color is required");var i=s[n.toUpperCase()];if(r(i))return s.clone(i);var o=c.exec(n);return null!==o?new s(parseInt(o[1],16)/15,parseInt(o[2],16)/15,parseInt(o[3],16)/15):(o=h.exec(n),null!==o?new s(parseInt(o[1],16)/255,parseInt(o[2],16)/255,parseInt(o[3],16)/255):(o=d.exec(n),null!==o?new s(parseFloat(o[1])/("%"===o[1].substr(-1)?100:255),parseFloat(o[2])/("%"===o[2].substr(-1)?100:255),parseFloat(o[3])/("%"===o[3].substr(-1)?100:255),parseFloat(e(o[4],"1.0"))):(o=w.exec(n),null!==o?s.fromHsl(parseFloat(o[1])/360,parseFloat(o[2])/100,parseFloat(o[3])/100,parseFloat(e(o[4],"1.0"))):void 0)))},s.packedLength=4,s.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.red,i[o++]=n.green,i[o++]=n.blue,i[o]=n.alpha},s.unpack=function(n,i,o){if(!r(n))throw new t("array is required");return i=e(i,0),r(o)||(o=new s),o.red=n[i++],o.green=n[i++],o.blue=n[i++],o.alpha=n[i],o},s.byteToFloat=function(e){return e/255},s.floatToByte=function(e){return 1===e?255:256*e|0},s.clone=function(e,t){return r(e)?r(t)?(t.red=e.red,t.green=e.green,t.blue=e.blue,t.alpha=e.alpha,t):new s(e.red,e.green,e.blue,e.alpha):void 0},s.equals=function(e,t){return e===t||r(e)&&r(t)&&e.red===t.red&&e.green===t.green&&e.blue===t.blue&&e.alpha===t.alpha},s.equalsArray=function(e,r,t){return e.red===r[t]&&e.green===r[t+1]&&e.blue===r[t+2]&&e.alpha===r[t+3]},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,t){return this===e||r(e)&&Math.abs(this.red-e.red)<=t&&Math.abs(this.green-e.green)<=t&&Math.abs(this.blue-e.blue)<=t&&Math.abs(this.alpha-e.alpha)<=t},s.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},s.prototype.toCssColorString=function(){var e=s.floatToByte(this.red),r=s.floatToByte(this.green),t=s.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+r+","+t+")":"rgba("+e+","+r+","+t+","+this.alpha+")"},s.prototype.toBytes=function(e){var t=s.floatToByte(this.red),n=s.floatToByte(this.green),i=s.floatToByte(this.blue),o=s.floatToByte(this.alpha);return r(e)?(e[0]=t,e[1]=n,e[2]=i,e[3]=o,e):[t,n,i,o]},s.prototype.toRgba=function(){return l[0]=s.floatToByte(this.red),l[1]=s.floatToByte(this.green),l[2]=s.floatToByte(this.blue),l[3]=s.floatToByte(this.alpha),f[0]},s.prototype.brighten=function(e,n){if(!r(e))throw new t("magnitude is required.");if(0>e)throw new t("magnitude must be positive.");if(!r(n))throw new t("result is required.");return e=1-e,n.red=1-(1-this.red)*e,n.green=1-(1-this.green)*e,n.blue=1-(1-this.blue)*e,n.alpha=this.alpha,n},s.prototype.darken=function(e,n){if(!r(e))throw new t("magnitude is required.");if(0>e)throw new t("magnitude must be positive.");if(!r(n))throw new t("result is required.");return e=1-e,n.red=this.red*e,n.green=this.green*e,n.blue=this.blue*e,n.alpha=this.alpha,n},s.prototype.withAlpha=function(e,r){return s.fromAlpha(this,e,r)},s.ALICEBLUE=i(s.fromCssColorString("#F0F8FF")),s.ANTIQUEWHITE=i(s.fromCssColorString("#FAEBD7")),s.AQUA=i(s.fromCssColorString("#00FFFF")),s.AQUAMARINE=i(s.fromCssColorString("#7FFFD4")),s.AZURE=i(s.fromCssColorString("#F0FFFF")),s.BEIGE=i(s.fromCssColorString("#F5F5DC")),s.BISQUE=i(s.fromCssColorString("#FFE4C4")),s.BLACK=i(s.fromCssColorString("#000000")),s.BLANCHEDALMOND=i(s.fromCssColorString("#FFEBCD")),s.BLUE=i(s.fromCssColorString("#0000FF")),s.BLUEVIOLET=i(s.fromCssColorString("#8A2BE2")),s.BROWN=i(s.fromCssColorString("#A52A2A")),s.BURLYWOOD=i(s.fromCssColorString("#DEB887")),s.CADETBLUE=i(s.fromCssColorString("#5F9EA0")),s.CHARTREUSE=i(s.fromCssColorString("#7FFF00")),s.CHOCOLATE=i(s.fromCssColorString("#D2691E")),s.CORAL=i(s.fromCssColorString("#FF7F50")),s.CORNFLOWERBLUE=i(s.fromCssColorString("#6495ED")),s.CORNSILK=i(s.fromCssColorString("#FFF8DC")),s.CRIMSON=i(s.fromCssColorString("#DC143C")),s.CYAN=i(s.fromCssColorString("#00FFFF")),s.DARKBLUE=i(s.fromCssColorString("#00008B")),s.DARKCYAN=i(s.fromCssColorString("#008B8B")),s.DARKGOLDENROD=i(s.fromCssColorString("#B8860B")),s.DARKGRAY=i(s.fromCssColorString("#A9A9A9")),s.DARKGREEN=i(s.fromCssColorString("#006400")),s.DARKGREY=s.DARKGRAY,s.DARKKHAKI=i(s.fromCssColorString("#BDB76B")),s.DARKMAGENTA=i(s.fromCssColorString("#8B008B")),s.DARKOLIVEGREEN=i(s.fromCssColorString("#556B2F")),s.DARKORANGE=i(s.fromCssColorString("#FF8C00")),s.DARKORCHID=i(s.fromCssColorString("#9932CC")),s.DARKRED=i(s.fromCssColorString("#8B0000")),s.DARKSALMON=i(s.fromCssColorString("#E9967A")),s.DARKSEAGREEN=i(s.fromCssColorString("#8FBC8F")),s.DARKSLATEBLUE=i(s.fromCssColorString("#483D8B")),s.DARKSLATEGRAY=i(s.fromCssColorString("#2F4F4F")),s.DARKSLATEGREY=s.DARKSLATEGRAY,s.DARKTURQUOISE=i(s.fromCssColorString("#00CED1")),s.DARKVIOLET=i(s.fromCssColorString("#9400D3")),s.DEEPPINK=i(s.fromCssColorString("#FF1493")),s.DEEPSKYBLUE=i(s.fromCssColorString("#00BFFF")),s.DIMGRAY=i(s.fromCssColorString("#696969")),s.DIMGREY=s.DIMGRAY,s.DODGERBLUE=i(s.fromCssColorString("#1E90FF")),s.FIREBRICK=i(s.fromCssColorString("#B22222")),s.FLORALWHITE=i(s.fromCssColorString("#FFFAF0")),s.FORESTGREEN=i(s.fromCssColorString("#228B22")),s.FUSCHIA=i(s.fromCssColorString("#FF00FF")),s.GAINSBORO=i(s.fromCssColorString("#DCDCDC")),s.GHOSTWHITE=i(s.fromCssColorString("#F8F8FF")),s.GOLD=i(s.fromCssColorString("#FFD700")),s.GOLDENROD=i(s.fromCssColorString("#DAA520")),s.GRAY=i(s.fromCssColorString("#808080")),s.GREEN=i(s.fromCssColorString("#008000")),s.GREENYELLOW=i(s.fromCssColorString("#ADFF2F")),s.GREY=s.GRAY,s.HONEYDEW=i(s.fromCssColorString("#F0FFF0")),s.HOTPINK=i(s.fromCssColorString("#FF69B4")),s.INDIANRED=i(s.fromCssColorString("#CD5C5C")),s.INDIGO=i(s.fromCssColorString("#4B0082")),s.IVORY=i(s.fromCssColorString("#FFFFF0")),s.KHAKI=i(s.fromCssColorString("#F0E68C")),s.LAVENDER=i(s.fromCssColorString("#E6E6FA")),s.LAVENDAR_BLUSH=i(s.fromCssColorString("#FFF0F5")),s.LAWNGREEN=i(s.fromCssColorString("#7CFC00")),s.LEMONCHIFFON=i(s.fromCssColorString("#FFFACD")),s.LIGHTBLUE=i(s.fromCssColorString("#ADD8E6")),s.LIGHTCORAL=i(s.fromCssColorString("#F08080")),s.LIGHTCYAN=i(s.fromCssColorString("#E0FFFF")),s.LIGHTGOLDENRODYELLOW=i(s.fromCssColorString("#FAFAD2")),s.LIGHTGRAY=i(s.fromCssColorString("#D3D3D3")),s.LIGHTGREEN=i(s.fromCssColorString("#90EE90")),s.LIGHTGREY=s.LIGHTGRAY,s.LIGHTPINK=i(s.fromCssColorString("#FFB6C1")),s.LIGHTSEAGREEN=i(s.fromCssColorString("#20B2AA")),s.LIGHTSKYBLUE=i(s.fromCssColorString("#87CEFA")),s.LIGHTSLATEGRAY=i(s.fromCssColorString("#778899")),s.LIGHTSLATEGREY=s.LIGHTSLATEGRAY,s.LIGHTSTEELBLUE=i(s.fromCssColorString("#B0C4DE")),s.LIGHTYELLOW=i(s.fromCssColorString("#FFFFE0")),s.LIME=i(s.fromCssColorString("#00FF00")),s.LIMEGREEN=i(s.fromCssColorString("#32CD32")),s.LINEN=i(s.fromCssColorString("#FAF0E6")),s.MAGENTA=i(s.fromCssColorString("#FF00FF")),s.MAROON=i(s.fromCssColorString("#800000")),s.MEDIUMAQUAMARINE=i(s.fromCssColorString("#66CDAA")),s.MEDIUMBLUE=i(s.fromCssColorString("#0000CD")),s.MEDIUMORCHID=i(s.fromCssColorString("#BA55D3")),s.MEDIUMPURPLE=i(s.fromCssColorString("#9370DB")),s.MEDIUMSEAGREEN=i(s.fromCssColorString("#3CB371")),s.MEDIUMSLATEBLUE=i(s.fromCssColorString("#7B68EE")),s.MEDIUMSPRINGGREEN=i(s.fromCssColorString("#00FA9A")),s.MEDIUMTURQUOISE=i(s.fromCssColorString("#48D1CC")),s.MEDIUMVIOLETRED=i(s.fromCssColorString("#C71585")),s.MIDNIGHTBLUE=i(s.fromCssColorString("#191970")),s.MINTCREAM=i(s.fromCssColorString("#F5FFFA")),s.MISTYROSE=i(s.fromCssColorString("#FFE4E1")),s.MOCCASIN=i(s.fromCssColorString("#FFE4B5")),s.NAVAJOWHITE=i(s.fromCssColorString("#FFDEAD")),s.NAVY=i(s.fromCssColorString("#000080")),s.OLDLACE=i(s.fromCssColorString("#FDF5E6")),s.OLIVE=i(s.fromCssColorString("#808000")),s.OLIVEDRAB=i(s.fromCssColorString("#6B8E23")),s.ORANGE=i(s.fromCssColorString("#FFA500")),s.ORANGERED=i(s.fromCssColorString("#FF4500")),s.ORCHID=i(s.fromCssColorString("#DA70D6")),s.PALEGOLDENROD=i(s.fromCssColorString("#EEE8AA")),s.PALEGREEN=i(s.fromCssColorString("#98FB98")),s.PALETURQUOISE=i(s.fromCssColorString("#AFEEEE")),s.PALEVIOLETRED=i(s.fromCssColorString("#DB7093")),s.PAPAYAWHIP=i(s.fromCssColorString("#FFEFD5")),s.PEACHPUFF=i(s.fromCssColorString("#FFDAB9")),s.PERU=i(s.fromCssColorString("#CD853F")),s.PINK=i(s.fromCssColorString("#FFC0CB")),s.PLUM=i(s.fromCssColorString("#DDA0DD")),s.POWDERBLUE=i(s.fromCssColorString("#B0E0E6")),s.PURPLE=i(s.fromCssColorString("#800080")),s.RED=i(s.fromCssColorString("#FF0000")),s.ROSYBROWN=i(s.fromCssColorString("#BC8F8F")),s.ROYALBLUE=i(s.fromCssColorString("#4169E1")),s.SADDLEBROWN=i(s.fromCssColorString("#8B4513")),s.SALMON=i(s.fromCssColorString("#FA8072")),s.SANDYBROWN=i(s.fromCssColorString("#F4A460")),s.SEAGREEN=i(s.fromCssColorString("#2E8B57")),s.SEASHELL=i(s.fromCssColorString("#FFF5EE")),s.SIENNA=i(s.fromCssColorString("#A0522D")),s.SILVER=i(s.fromCssColorString("#C0C0C0")),s.SKYBLUE=i(s.fromCssColorString("#87CEEB")),s.SLATEBLUE=i(s.fromCssColorString("#6A5ACD")),s.SLATEGRAY=i(s.fromCssColorString("#708090")),s.SLATEGREY=s.SLATEGRAY,s.SNOW=i(s.fromCssColorString("#FFFAFA")),s.SPRINGGREEN=i(s.fromCssColorString("#00FF7F")),s.STEELBLUE=i(s.fromCssColorString("#4682B4")),s.TAN=i(s.fromCssColorString("#D2B48C")),s.TEAL=i(s.fromCssColorString("#008080")),s.THISTLE=i(s.fromCssColorString("#D8BFD8")),s.TOMATO=i(s.fromCssColorString("#FF6347")),s.TURQUOISE=i(s.fromCssColorString("#40E0D0")),s.VIOLET=i(s.fromCssColorString("#EE82EE")),s.WHEAT=i(s.fromCssColorString("#F5DEB3")),s.WHITE=i(s.fromCssColorString("#FFFFFF")),s.WHITESMOKE=i(s.fromCssColorString("#F5F5F5")),s.YELLOW=i(s.fromCssColorString("#FFFF00")),s.YELLOWGREEN=i(s.fromCssColorString("#9ACD32")),s.TRANSPARENT=i(new s(0,0,0,0)),s}),define("Renderer/WebGLConstants",["../Core/freezeObject"],function(e){"use strict";var r={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,
SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return e(r)}),define("Core/ComponentDatatype",["../Renderer/WebGLConstants","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,r,t,n,i,o){"use strict";if(!i.supportsTypedArrays())return{};var a={BYTE:e.BYTE,UNSIGNED_BYTE:e.UNSIGNED_BYTE,SHORT:e.SHORT,UNSIGNED_SHORT:e.UNSIGNED_SHORT,FLOAT:e.FLOAT,DOUBLE:e.DOUBLE};return a.getSizeInBytes=function(e){if(!t(e))throw new n("value is required.");switch(e){case a.BYTE:return Int8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.SHORT:return Int16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case a.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new n("componentDatatype is not a valid value.")}},a.fromTypedArray=function(e){return e instanceof Int8Array?a.BYTE:e instanceof Uint8Array?a.UNSIGNED_BYTE:e instanceof Int16Array?a.SHORT:e instanceof Uint16Array?a.UNSIGNED_SHORT:e instanceof Float32Array?a.FLOAT:e instanceof Float64Array?a.DOUBLE:void 0},a.validate=function(e){return t(e)&&(e===a.BYTE||e===a.UNSIGNED_BYTE||e===a.SHORT||e===a.UNSIGNED_SHORT||e===a.FLOAT||e===a.DOUBLE)},a.createTypedArray=function(e,r){if(!t(e))throw new n("componentDatatype is required.");if(!t(r))throw new n("valuesOrLength is required.");switch(e){case a.BYTE:return new Int8Array(r);case a.UNSIGNED_BYTE:return new Uint8Array(r);case a.SHORT:return new Int16Array(r);case a.UNSIGNED_SHORT:return new Uint16Array(r);case a.FLOAT:return new Float32Array(r);case a.DOUBLE:return new Float64Array(r);default:throw new n("componentDatatype is not a valid value.")}},a.createArrayBufferView=function(e,i,o,s){if(!t(e))throw new n("componentDatatype is required.");if(!t(i))throw new n("buffer is required.");switch(o=r(o,0),s=r(s,(i.byteLength-o)/a.getSizeInBytes(e)),e){case a.BYTE:return new Int8Array(i,o,s);case a.UNSIGNED_BYTE:return new Uint8Array(i,o,s);case a.SHORT:return new Int16Array(i,o,s);case a.UNSIGNED_SHORT:return new Uint16Array(i,o,s);case a.FLOAT:return new Float32Array(i,o,s);case a.DOUBLE:return new Float64Array(i,o,s);default:throw new n("componentDatatype is not a valid value.")}},o(a)}),define("Core/GeometryType",["./freezeObject"],function(e){"use strict";var r={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(r)}),define("Core/PrimitiveType",["../Renderer/WebGLConstants","./freezeObject"],function(e,r){"use strict";var t={POINTS:e.POINTS,LINES:e.LINES,LINE_LOOP:e.LINE_LOOP,LINE_STRIP:e.LINE_STRIP,TRIANGLES:e.TRIANGLES,TRIANGLE_STRIP:e.TRIANGLE_STRIP,TRIANGLE_FAN:e.TRIANGLE_FAN,validate:function(e){return e===t.POINTS||e===t.LINES||e===t.LINE_LOOP||e===t.LINE_STRIP||e===t.TRIANGLES||e===t.TRIANGLE_STRIP||e===t.TRIANGLE_FAN}};return r(t)}),define("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,r,t,n,i){"use strict";var o=function(o){if(o=e(o,e.EMPTY_OBJECT),!r(o.attributes))throw new t("options.attributes is required.");this.attributes=o.attributes,this.indices=o.indices,this.primitiveType=e(o.primitiveType,i.TRIANGLES),this.boundingSphere=o.boundingSphere,this.geometryType=e(o.geometryType,n.NONE),this.boundingSphereCV=void 0};return o.computeNumberOfVertices=function(e){if(!r(e))throw new t("geometry is required.");var n=-1;for(var i in e.attributes)if(e.attributes.hasOwnProperty(i)&&r(e.attributes[i])&&r(e.attributes[i].values)){var o=e.attributes[i],a=o.values.length/o.componentsPerAttribute;if(n!==a&&-1!==n)throw new t("All attribute lists must have the same number of attributes.");n=a}return n},o}),define("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!r(n.componentDatatype))throw new t("options.componentDatatype is required.");if(!r(n.componentsPerAttribute))throw new t("options.componentsPerAttribute is required.");if(n.componentsPerAttribute<1||n.componentsPerAttribute>4)throw new t("options.componentsPerAttribute must be between 1 and 4.");if(!r(n.values))throw new t("options.values is required.");this.componentDatatype=n.componentDatatype,this.componentsPerAttribute=n.componentsPerAttribute,this.normalize=e(n.normalize,!1),this.values=n.values};return n}),define("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var r=function(r){r=e(r,e.EMPTY_OBJECT),this.position=r.position,this.normal=r.normal,this.st=r.st,this.binormal=r.binormal,this.tangent=r.tangent,this.color=r.color};return r}),define("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o=function(r,t){this.x=e(r,0),this.y=e(t,0)};o.fromElements=function(e,t,n){return r(n)?(n.x=e,n.y=t,n):new o(e,t)},o.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t):new o(e.x,e.y):void 0},o.fromCartesian3=o.clone,o.fromCartesian4=o.clone,o.packedLength=2,o.pack=function(n,i,o){if(!r(n))throw new t("value is required");if(!r(i))throw new t("array is required");o=e(o,0),i[o++]=n.x,i[o]=n.y},o.unpack=function(n,i,a){if(!r(n))throw new t("array is required");return i=e(i,0),r(a)||(a=new o),a.x=n[i++],a.y=n[i],a},o.fromArray=o.unpack,o.maximumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.max(e.x,e.y)},o.minimumComponent=function(e){if(!r(e))throw new t("cartesian is required");return Math.min(e.x,e.y)},o.minimumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.min(e.x,n.x),i.y=Math.min(e.y,n.y),i},o.maximumByComponent=function(e,n,i){if(!r(e))throw new t("first is required.");if(!r(n))throw new t("second is required.");if(!r(i))throw new t("result is required.");return i.x=Math.max(e.x,n.x),i.y=Math.max(e.y,n.y),i},o.magnitudeSquared=function(e){if(!r(e))throw new t("cartesian is required");return e.x*e.x+e.y*e.y},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitude(a)},o.distanceSquared=function(e,n){if(!r(e)||!r(n))throw new t("left and right are required.");return o.subtract(e,n,a),o.magnitudeSquared(a)},o.normalize=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");var i=o.magnitude(e);return n.x=e.x/i,n.y=e.y/i,n},o.dot=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return e.x*n.x+e.y*n.y},o.multiplyComponents=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x*n.x,i.y=e.y*n.y,i},o.add=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x+n.x,i.y=e.y+n.y,i},o.subtract=function(e,n,i){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");if(!r(i))throw new t("result is required");return i.x=e.x-n.x,i.y=e.y-n.y,i},o.multiplyByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x*n,i.y=e.y*n,i},o.divideByScalar=function(e,n,i){if(!r(e))throw new t("cartesian is required");if("number"!=typeof n)throw new t("scalar is required and must be a number.");if(!r(i))throw new t("result is required");return i.x=e.x/n,i.y=e.y/n,i},o.negate=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=-e.x,n.y=-e.y,n},o.abs=function(e,n){if(!r(e))throw new t("cartesian is required");if(!r(n))throw new t("result is required");return n.x=Math.abs(e.x),n.y=Math.abs(e.y),n};var s=new o;o.lerp=function(e,n,i,a){if(!r(e))throw new t("start is required.");if(!r(n))throw new t("end is required.");if("number"!=typeof i)throw new t("t is required and must be a number.");if(!r(a))throw new t("result is required.");return o.multiplyByScalar(n,i,s),a=o.multiplyByScalar(e,1-i,a),o.add(s,a,a)};var u=new o,f=new o;o.angleBetween=function(e,n){if(!r(e))throw new t("left is required");if(!r(n))throw new t("right is required");return o.normalize(e,u),o.normalize(n,f),i.acosClamped(o.dot(u,f))};var l=new o;return o.mostOrthogonalAxis=function(e,n){if(!r(e))throw new t("cartesian is required.");if(!r(n))throw new t("result is required.");var i=o.normalize(e,l);return o.abs(i,i),n=i.x<=i.y?o.clone(o.UNIT_X,n):o.clone(o.UNIT_Y,n)},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y},o.equalsArray=function(e,r,t){return e.x===r[t]&&e.y===r[t+1]},o.equalsEpsilon=function(e,t,n,o){return e===t||r(e)&&r(t)&&i.equalsEpsilon(e.x,t.x,n,o)&&i.equalsEpsilon(e.y,t.y,n,o)},o.ZERO=n(new o(0,0)),o.UNIT_X=n(new o(1,0)),o.UNIT_Y=n(new o(0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,r,t){return o.equalsEpsilon(this,e,r,t)},o.prototype.toString=function(){return"("+this.x+", "+this.y+")"},o}),define("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,r,t,n,i){"use strict";var o={};o.octEncode=function(e,o){if(!t(e))throw new n("vector is required.");if(!t(o))throw new n("result is required.");var a=r.magnitudeSquared(e);if(Math.abs(a-1)>i.EPSILON6)throw new n("vector must be normalized.");if(o.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),o.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var s=o.x,u=o.y;o.x=(1-Math.abs(u))*i.signNotZero(s),o.y=(1-Math.abs(s))*i.signNotZero(u)}return o.x=i.toSNorm(o.x),o.y=i.toSNorm(o.y),o},o.octDecode=function(e,o,a){if(!t(a))throw new n("result is required.");if(0>e||e>255||0>o||o>255)throw new n("x and y must be a signed normalized integer between 0 and 255");if(a.x=i.fromSNorm(e),a.y=i.fromSNorm(o),a.z=1-(Math.abs(a.x)+Math.abs(a.y)),a.z<0){var s=a.x;a.x=(1-Math.abs(a.y))*i.signNotZero(s),a.y=(1-Math.abs(s))*i.signNotZero(a.y)}return r.normalize(a,a)},o.octPackFloat=function(e){if(!t(e))throw new n("encoded is required.");return 256*e.x+e.y};var a=new e;return o.octEncodeFloat=function(e){return o.octEncode(e,a),o.octPackFloat(a)},o.octDecodeFloat=function(e,r){if(!t(e))throw new n("value is required.");var i=e/256,a=Math.floor(i),s=256*(i-a);return o.octDecode(a,s,r)},o.octPack=function(e,r,i,s){if(!t(e))throw new n("v1 is required.");if(!t(r))throw new n("v2 is required.");if(!t(i))throw new n("v3 is required.");if(!t(s))throw new n("result is required.");var u=o.octEncodeFloat(e),f=o.octEncodeFloat(r),l=o.octEncode(i,a);return s.x=65536*l.x+u,s.y=65536*l.y+f,s},o.octUnpack=function(e,r,i,a){if(!t(e))throw new n("packed is required.");if(!t(r))throw new n("v1 is required.");if(!t(i))throw new n("v2 is required.");if(!t(a))throw new n("v3 is required.");var s=e.x/65536,u=Math.floor(s),f=65536*(s-u);s=e.y/65536;var l=Math.floor(s),c=65536*(s-l);o.octDecodeFloat(f,r),o.octDecodeFloat(c,i),o.octDecode(u,l,a)},o.compressTextureCoordinates=function(e){if(!t(e))throw new n("textureCoordinates is required.");var r=1===e.x?4095:4096*e.x|0,i=1===e.y?4095:4096*e.y|0;return 4096*r+i},o.decompressTextureCoordinates=function(e,r){if(!t(e))throw new n("compressed is required.");if(!t(r))throw new n("result is required.");var i=e/4096;return r.x=Math.floor(i)/4096,r.y=i-Math.floor(i),r},o}),define("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i=new r,o=new r,a=new r,s=function(s,u,f,l,c){if(!(t(s)&&t(u)&&t(f)&&t(l)))throw new n("point, p0, p1, and p2 are required.");t(c)||(c=new r);var h,d,w,E,m,p,T,y;t(u.z)?(h=r.subtract(f,u,i),d=r.subtract(l,u,o),w=r.subtract(s,u,a),E=r.dot(h,h),m=r.dot(h,d),p=r.dot(h,w),T=r.dot(d,d),y=r.dot(d,w)):(h=e.subtract(f,u,i),d=e.subtract(l,u,o),w=e.subtract(s,u,a),E=e.dot(h,h),m=e.dot(h,d),p=e.dot(h,w),T=e.dot(d,d),y=e.dot(d,w));var R=1/(E*T-m*m);return c.y=(T*p-m*y)*R,c.z=(E*y-m*p)*R,c.x=1-c.y-c.z,c};return s}),define("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,r,t){"use strict";var n=function(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)};n.encode=function(e,n){if(!r(e))throw new t("value is required");r(n)||(n={high:0,low:0});var i;return e>=0?(i=65536*Math.floor(e/65536),n.high=i,n.low=e-i):(i=65536*Math.floor(-e/65536),n.high=-i,n.low=e+i),n};var i={high:0,low:0};n.fromCartesian=function(e,o){if(!r(e))throw new t("cartesian is required");r(o)||(o=new n);var a=o.high,s=o.low;return n.encode(e.x,i),a.x=i.high,s.x=i.low,n.encode(e.y,i),a.y=i.high,s.y=i.low,n.encode(e.z,i),a.z=i.high,s.z=i.low,o};var o=new n;return n.writeElements=function(e,i,a){if(!r(e))throw new t("cartesian is required");if(!r(i))throw new t("cartesianArray is required");if("number"!=typeof a||0>a)throw new t("index must be a number greater than or equal to 0.");n.fromCartesian(e,o);var s=o.high,u=o.low;i[a]=s.x,i[a+1]=s.y,i[a+2]=s.z,i[a+3]=u.x,i[a+4]=u.y,i[a+5]=u.z},n}),define("Core/GeometryInstance",["./defaultValue","./defined","./DeveloperError","./Matrix4"],function(e,r,t,n){"use strict";var i=function(i){if(i=e(i,e.EMPTY_OBJECT),!r(i.geometry))throw new t("options.geometry is required.");this.geometry=i.geometry,this.modelMatrix=n.clone(e(i.modelMatrix,n.IDENTITY)),this.id=i.id,this.pickPrimitive=i.pickPrimitive,this.attributes=e(i.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0};return i}),define("Core/IndexDatatype",["../Renderer/WebGLConstants","./defined","./DeveloperError","./freezeObject","./Math"],function(e,r,t,n,i){"use strict";var o={UNSIGNED_BYTE:e.UNSIGNED_BYTE,UNSIGNED_SHORT:e.UNSIGNED_SHORT,UNSIGNED_INT:e.UNSIGNED_INT};return o.getSizeInBytes=function(e){switch(e){case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new t("indexDatatype is required and must be a valid IndexDatatype constant.")},o.validate=function(e){return r(e)&&(e===o.UNSIGNED_BYTE||e===o.UNSIGNED_SHORT||e===o.UNSIGNED_INT)},o.createTypedArray=function(e,n){if(!r(e))throw new t("numberOfVertices is required.");return e>=i.SIXTY_FOUR_KILOBYTES?new Uint32Array(n):new Uint16Array(n)},o.createTypedArrayFromArrayBuffer=function(e,n,o,a){if(!r(e))throw new t("numberOfVertices is required.");if(!r(n))throw new t("sourceArray is required.");if(!r(o))throw new t("byteOffset is required.");return e>=i.SIXTY_FOUR_KILOBYTES?new Uint32Array(n,o,a):new Uint16Array(n,o,a)},n(o)}),define("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,r){"use strict";function t(e,t,n){var i=e+t;return r.sign(e)!==r.sign(t)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(t)))<n?0:i}var n={};return n.computeDiscriminant=function(r,t,n){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");var i=t*t-4*r*n;return i},n.computeRealRoots=function(n,i,o){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");var a;if(0===n)return 0===i?[]:[-o/i];if(0===i){if(0===o)return[0,0];var s=Math.abs(o),u=Math.abs(n);if(u>s&&s/u<r.EPSILON14)return[0,0];if(s>u&&u/s<r.EPSILON14)return[];if(a=-o/n,0>a)return[];var f=Math.sqrt(a);return[-f,f]}if(0===o)return a=-i/n,0>a?[a,0]:[0,a];var l=i*i,c=4*n*o,h=t(l,-c,r.EPSILON14);if(0>h)return[];var d=-.5*t(i,r.sign(i)*Math.sqrt(h),r.EPSILON14);return i>0?[d/n,o/d]:[o/d,d/n]},n}),define("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,r){"use strict";function t(e,r,t,n){var i,o,a=e,s=r/3,u=t/3,f=n,l=a*u,c=s*f,h=s*s,d=u*u,w=a*u-h,E=a*f-s*u,m=s*f-d,p=4*w*m-E*E;if(0>p){var T,y,R;h*c>=l*d?(T=a,y=w,R=-2*s*w+a*E):(T=f,y=m,R=-f*E+2*u*m);var A=0>R?-1:1,v=-A*Math.abs(T)*Math.sqrt(-p);o=-R+v;var _=o/2,S=0>_?-Math.pow(-_,1/3):Math.pow(_,1/3),g=o===v?-S:-y/S;return i=0>=y?S+g:-R/(S*S+g*g+y),h*c>=l*d?[(i-s)/a]:[-f/(i+u)]}var C=w,N=-2*s*w+a*E,I=m,O=-f*E+2*u*m,b=Math.sqrt(p),M=Math.sqrt(3)/2,q=Math.abs(Math.atan2(a*b,-N)/3);i=2*Math.sqrt(-C);var L=Math.cos(q);o=i*L;var F=i*(-L/2-M*Math.sin(q)),P=o+F>2*s?o-s:F-s,D=a,x=P/D;q=Math.abs(Math.atan2(f*b,-O)/3),i=2*Math.sqrt(-I),L=Math.cos(q),o=i*L,F=i*(-L/2-M*Math.sin(q));var U=-f,B=2*u>o+F?o+u:F+u,G=U/B,z=D*B,V=-P*B-D*U,H=P*U,W=(u*V-s*H)/(-s*V+u*z);return W>=x?G>=x?G>=W?[x,W,G]:[x,G,W]:[G,x,W]:G>=x?[W,x,G]:G>=W?[W,G,x]:[G,W,x]}var n={};return n.computeDiscriminant=function(r,t,n,i){if("number"!=typeof r)throw new e("a is a required number.");if("number"!=typeof t)throw new e("b is a required number.");if("number"!=typeof n)throw new e("c is a required number.");if("number"!=typeof i)throw new e("d is a required number.");var o=r*r,a=t*t,s=n*n,u=i*i,f=18*r*t*n*i+a*s-27*o*u-4*(r*s*n+a*t*i);return f},n.computeRealRoots=function(n,i,o,a){if("number"!=typeof n)throw new e("a is a required number.");if("number"!=typeof i)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");if("number"!=typeof a)throw new e("d is a required number.");var s,u;if(0===n)return r.computeRealRoots(i,o,a);if(0===i){if(0===o){if(0===a)return[0,0,0];u=-a/n;var f=0>u?-Math.pow(-u,1/3):Math.pow(u,1/3);return[f,f,f]}return 0===a?(s=r.computeRealRoots(n,0,o),0===s.Length?[0]:[s[0],0,s[1]]):t(n,0,o,a)}return 0===o?0===a?(u=-i/n,0>u?[u,0,0]:[0,0,u]):t(n,i,0,a):0===a?(s=r.computeRealRoots(n,i,o),0===s.length?[0]:s[1]<=0?[s[0],s[1],0]:s[0]>=0?[0,s[0],s[1]]:[s[0],0,s[1]]):t(n,i,o,a)},n}),define("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,r,t,n){"use strict";function i(r,i,o,a){var s=r*r,u=i-3*s/8,f=o-i*r/2+s*r/8,l=a-o*r/4+i*s/16-3*s*s/256,c=e.computeRealRoots(1,2*u,u*u-4*l,-f*f);if(c.length>0){var h=-r/4,d=c[c.length-1];if(Math.abs(d)<t.EPSILON14){var w=n.computeRealRoots(1,u,l);if(2===w.length){var E,m=w[0],p=w[1];if(m>=0&&p>=0){var T=Math.sqrt(m),y=Math.sqrt(p);return[h-y,h-T,h+T,h+y]}if(m>=0&&0>p)return E=Math.sqrt(m),[h-E,h+E];if(0>m&&p>=0)return E=Math.sqrt(p),[h-E,h+E]}return[]}if(d>0){var R=Math.sqrt(d),A=(u+d-f/R)/2,v=(u+d+f/R)/2,_=n.computeRealRoots(1,R,A),S=n.computeRealRoots(1,-R,v);return 0!==_.length?(_[0]+=h,_[1]+=h,0!==S.length?(S[0]+=h,S[1]+=h,_[1]<=S[0]?[_[0],_[1],S[0],S[1]]:S[1]<=_[0]?[S[0],S[1],_[0],_[1]]:_[0]>=S[0]&&_[1]<=S[1]?[S[0],_[0],_[1],S[1]]:S[0]>=_[0]&&S[1]<=_[1]?[_[0],S[0],S[1],_[1]]:_[0]>S[0]&&_[0]<S[1]?[S[0],_[0],S[1],_[1]]:[_[0],S[0],_[1],S[1]]):_):0!==S.length?(S[0]+=h,S[1]+=h,S):[]}}return[]}function o(r,i,o,a){var s=o*o,u=i*i,f=r*r,l=-2*i,c=o*r+u-4*a,h=f*a-o*i*r+s,d=e.computeRealRoots(1,l,c,h);if(d.length>0){var w,E,m=d[0],p=i-m,T=p*p,y=r/2,R=p/2,A=T-4*a,v=T+4*Math.abs(a),_=f-4*m,S=f+4*Math.abs(m);if(0>m||_*v>A*S){var g=Math.sqrt(_);w=g/2,E=0===g?0:(r*R-o)/g}else{var C=Math.sqrt(A);w=0===C?0:(r*R-o)/C,E=C/2}var N,I;0===y&&0===w?(N=0,I=0):t.sign(y)===t.sign(w)?(N=y+w,I=m/N):(I=y-w,N=m/I);var O,b;0===R&&0===E?(O=0,b=0):t.sign(R)===t.sign(E)?(O=R+E,b=a/O):(b=R-E,O=a/b);var M=n.computeRealRoots(1,N,O),q=n.computeRealRoots(1,I,b);if(0!==M.length)return 0!==q.length?M[1]<=q[0]?[M[0],M[1],q[0],q[1]]:q[1]<=M[0]?[q[0],q[1],M[0],M[1]]:M[0]>=q[0]&&M[1]<=q[1]?[q[0],M[0],M[1],q[1]]:q[0]>=M[0]&&q[1]<=M[1]?[M[0],q[0],q[1],M[1]]:M[0]>q[0]&&M[0]<q[1]?[q[0],M[0],q[1],M[1]]:[M[0],q[0],M[1],q[1]]:M;if(0!==q.length)return q}return[]}var a={};return a.computeDiscriminant=function(e,t,n,i,o){if("number"!=typeof e)throw new r("a is a required number.");if("number"!=typeof t)throw new r("b is a required number.");if("number"!=typeof n)throw new r("c is a required number.");if("number"!=typeof i)throw new r("d is a required number.");if("number"!=typeof o)throw new r("e is a required number.");var a=e*e,s=a*e,u=t*t,f=u*t,l=n*n,c=l*n,h=i*i,d=h*i,w=o*o,E=w*o,m=u*l*h-4*f*d-4*e*c*h+18*e*t*n*d-27*a*h*h+256*s*E+o*(18*f*n*i-4*u*c+16*e*l*l-80*e*t*l*i-6*e*u*h+144*a*n*h)+w*(144*e*u*n-27*u*u-128*a*l-192*a*t*i);return m},a.computeRealRoots=function(n,a,s,u,f){if("number"!=typeof n)throw new r("a is a required number.");if("number"!=typeof a)throw new r("b is a required number.");if("number"!=typeof s)throw new r("c is a required number.");if("number"!=typeof u)throw new r("d is a required number.");if("number"!=typeof f)throw new r("e is a required number.");if(Math.abs(n)<t.EPSILON15)return e.computeRealRoots(a,s,u,f);var l=a/n,c=s/n,h=u/n,d=f/n,w=0>l?1:0;switch(w+=0>c?w+1:w,w+=0>h?w+1:w,w+=0>d?w+1:w){case 0:return i(l,c,h,d);case 1:return o(l,c,h,d);case 2:return o(l,c,h,d);case 3:return i(l,c,h,d);case 4:return i(l,c,h,d);case 5:return o(l,c,h,d);case 6:return i(l,c,h,d);case 7:return i(l,c,h,d);case 8:return o(l,c,h,d);case 9:return i(l,c,h,d);case 10:return i(l,c,h,d);case 11:return o(l,c,h,d);case 12:return i(l,c,h,d);case 13:return i(l,c,h,d);case 14:return i(l,c,h,d);case 15:return i(l,c,h,d);default:return void 0}},a}),define("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,r,t,n){"use strict";var i=function(t,n){n=e.clone(r(n,e.ZERO)),e.equals(n,e.ZERO)||e.normalize(n,n),this.origin=e.clone(r(t,e.ZERO)),this.direction=n};return i.getPoint=function(r,i,o){if(!t(r))throw new n("ray is requred");if("number"!=typeof i)throw new n("t is a required number");return t(o)||(o=new e),o=e.multiplyByScalar(r.direction,i,o),e.add(r.origin,o,o)},i}),define("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,r,t,n,i,o,a,s,u,f){"use strict";function l(r,a,s,u,f){if(!n(r))throw new i("ray is required.");if(!n(a))throw new i("p0 is required.");if(!n(s))throw new i("p1 is required.");if(!n(u))throw new i("p2 is required.");f=t(f,!1);var l,c,h,d,w,E=r.origin,A=r.direction,v=e.subtract(s,a,m),_=e.subtract(u,a,p),S=e.cross(A,_,T),g=e.dot(v,S);if(f){if(g<o.EPSILON6)return void 0;if(l=e.subtract(E,a,y),h=e.dot(l,S),0>h||h>g)return void 0;if(c=e.cross(l,v,R),d=e.dot(A,c),0>d||h+d>g)return void 0;w=e.dot(_,c)/g}else{if(Math.abs(g)<o.EPSILON6)return void 0;var C=1/g;if(l=e.subtract(E,a,y),h=e.dot(l,S)*C,0>h||h>1)return void 0;if(c=e.cross(l,v,R),d=e.dot(A,c)*C,0>d||h+d>1)return void 0;w=e.dot(_,c)*C}return w}function c(e,r,t,n){var i=r*r-4*e*t;if(0>i)return void 0;if(i>0){var o=1/(2*e),a=Math.sqrt(i),s=(-r+a)*o,u=(-r-a)*o;return u>s?(n.root0=s,n.root1=u):(n.root0=u,n.root1=s),n}var f=-r/(2*e);return 0===f?void 0:(n.root0=n.root1=f,n)}function h(r,t,i){n(i)||(i={});var o=r.origin,a=r.direction,s=t.center,u=t.radius*t.radius,f=e.subtract(o,s,T),l=e.dot(a,a),h=2*e.dot(a,f),d=e.magnitudeSquared(f)-u,w=c(l,h,d,v);return n(w)?(i.start=w.root0,i.stop=w.root1,i):void 0}function d(e,r,t){var n=e+r;return o.sign(e)!==o.sign(r)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(r)))<t?0:n}function w(r,t,n,i,f){var l,c=i*i,h=f*f,w=(r[a.COLUMN1ROW1]-r[a.COLUMN2ROW2])*h,E=f*(i*d(r[a.COLUMN1ROW0],r[a.COLUMN0ROW1],o.EPSILON15)+t.y),m=r[a.COLUMN0ROW0]*c+r[a.COLUMN2ROW2]*h+i*t.x+n,p=h*d(r[a.COLUMN2ROW1],r[a.COLUMN1ROW2],o.EPSILON15),T=f*(i*d(r[a.COLUMN2ROW0],r[a.COLUMN0ROW2])+t.z),y=[];if(0===T&&0===p){if(l=s.computeRealRoots(w,E,m),0===l.length)return y;var R=l[0],A=Math.sqrt(Math.max(1-R*R,0));if(y.push(new e(i,f*R,f*-A)),y.push(new e(i,f*R,f*A)),2===l.length){var v=l[1],_=Math.sqrt(Math.max(1-v*v,0));y.push(new e(i,f*v,f*-_)),y.push(new e(i,f*v,f*_))}return y}var S=T*T,g=p*p,C=w*w,N=T*p,I=C+g,O=2*(E*w+N),b=2*m*w+E*E-g+S,M=2*(m*E-N),q=m*m-S;if(0===I&&0===O&&0===b&&0===M)return y;l=u.computeRealRoots(I,O,b,M,q);var L=l.length;if(0===L)return y;for(var F=0;L>F;++F){var P,D=l[F],x=D*D,U=Math.max(1-x,0),B=Math.sqrt(U);P=o.sign(w)===o.sign(m)?d(w*x+m,E*D,o.EPSILON12):o.sign(m)===o.sign(E*D)?d(w*x,E*D+m,o.EPSILON12):d(w*x+E*D,m,o.EPSILON12);var G=d(p*D,T,o.EPSILON15),z=P*G;0>z?y.push(new e(i,f*D,f*B)):z>0?y.push(new e(i,f*D,f*-B)):0!==B?(y.push(new e(i,f*D,f*-B)),y.push(new e(i,f*D,f*B)),++F):y.push(new e(i,f*D,f*B))}return y}var E={};E.rayPlane=function(r,t,a){if(!n(r))throw new i("ray is required.");if(!n(t))throw new i("plane is required.");n(a)||(a=new e);var s=r.origin,u=r.direction,f=t.normal,l=e.dot(f,u);if(Math.abs(l)<o.EPSILON15)return void 0;var c=(-t.distance-e.dot(f,s))/l;return 0>c?void 0:(a=e.multiplyByScalar(u,c,a),e.add(s,a,a))};var m=new e,p=new e,T=new e,y=new e,R=new e;E.rayTriangle=function(r,t,i,o,a,s){var u=l(r,t,i,o,a);return!n(u)||0>u?void 0:(n(s)||(s=new e),e.multiplyByScalar(r.direction,u,s),e.add(r.origin,s,s))};var A=new f;E.lineSegmentTriangle=function(r,t,o,a,s,u,f){if(!n(r))throw new i("v0 is required.");if(!n(t))throw new i("v1 is required.");var c=A;e.clone(r,c.origin),e.subtract(t,r,c.direction),e.normalize(c.direction,c.direction);var h=l(c,o,a,s,u);return!n(h)||0>h||h>e.distance(r,t)?void 0:(n(f)||(f=new e),e.multiplyByScalar(c.direction,h,f),e.add(c.origin,f,f))};var v={root0:0,root1:0};E.raySphere=function(e,r,t){if(!n(e))throw new i("ray is required.");if(!n(r))throw new i("sphere is required.");return t=h(e,r,t),!n(t)||t.stop<0?void 0:(t.start=Math.max(t.start,0),t)};var _=new f;E.lineSegmentSphere=function(r,t,o,a){if(!n(r))throw new i("p0 is required.");if(!n(t))throw new i("p1 is required.");if(!n(o))throw new i("sphere is required.");var s=_,u=(e.clone(r,s.origin),e.subtract(t,r,s.direction)),f=e.magnitude(u);return e.normalize(u,u),a=h(s,o,a),!n(a)||a.stop<0||a.start>f?void 0:(a.start=Math.max(a.start,0),a.stop=Math.min(a.stop,f),a)};var S=new e,g=new e;E.rayEllipsoid=function(r,t){if(!n(r))throw new i("ray is required.");if(!n(t))throw new i("ellipsoid is required.");var o,a,s,u,f,l=t.oneOverRadii,c=e.multiplyComponents(l,r.origin,S),h=e.multiplyComponents(l,r.direction,g),d=e.magnitudeSquared(c),w=e.dot(c,h);if(d>1){if(w>=0)return void 0;var E=w*w;if(o=d-1,a=e.magnitudeSquared(h),s=a*o,s>E)return void 0;if(E>s){u=w*w-s,f=-w+Math.sqrt(u);var m=f/a,p=o/f;return p>m?{start:m,stop:p}:{start:p,stop:m}}var T=Math.sqrt(o/a);return{start:T,stop:T}}return 1>d?(o=d-1,a=e.magnitudeSquared(h),s=a*o,u=w*w-s,f=-w+Math.sqrt(u),{start:0,stop:f/a}):0>w?(a=e.magnitudeSquared(h),{start:0,stop:-w/a}):void 0};var C=new e,N=new e,I=new e,O=new e,b=new e,M=new a,q=new a,L=new a,F=new a,P=new a,D=new a,x=new a,U=new e,B=new e,G=new r;E.grazingAltitudeLocation=function(r,t){if(!n(r))throw new i("ray is required.");if(!n(t))throw new i("ellipsoid is required.");var s=r.origin,u=r.direction,f=t.geodeticSurfaceNormal(s,C);if(e.dot(u,f)>=0)return s;var l=n(this.rayEllipsoid(r,t)),c=t.transformPositionToScaledSpace(u,C),h=e.normalize(c,c),d=e.mostOrthogonalAxis(c,O),E=e.normalize(e.cross(d,h,N),N),m=e.normalize(e.cross(h,E,I),I),p=M;
p[0]=h.x,p[1]=h.y,p[2]=h.z,p[3]=E.x,p[4]=E.y,p[5]=E.z,p[6]=m.x,p[7]=m.y,p[8]=m.z;var T=a.transpose(p,q),y=a.fromScale(t.radii,L),R=a.fromScale(t.oneOverRadii,F),A=P;A[0]=0,A[1]=-u.z,A[2]=u.y,A[3]=u.z,A[4]=0,A[5]=-u.x,A[6]=-u.y,A[7]=u.x,A[8]=0;var v,_,S=a.multiply(a.multiply(T,R,D),A,D),g=a.multiply(a.multiply(S,y,x),p,x),z=a.multiplyByVector(S,s,b),V=w(g,e.negate(z,C),0,0,1),H=V.length;if(H>0){for(var W=e.clone(e.ZERO,B),Y=Number.NEGATIVE_INFINITY,X=0;H>X;++X){v=a.multiplyByVector(y,a.multiplyByVector(p,V[X],U),U);var k=e.normalize(e.subtract(v,s,O),O),K=e.dot(k,u);K>Y&&(Y=K,W=e.clone(v,W))}var Z=t.cartesianToCartographic(W,G);return Y=o.clamp(Y,0,1),_=e.magnitude(e.subtract(W,s,O))*Math.sqrt(1-Y*Y),_=l?-_:_,Z.height=_,t.cartographicToCartesian(Z,new e)}return void 0};var z=new e;return E.lineSegmentPlane=function(r,t,a,s){if(!n(r))throw new i("endPoint0 is required.");if(!n(t))throw new i("endPoint1 is required.");if(!n(a))throw new i("plane is required.");n(s)||(s=new e);var u=e.subtract(t,r,z),f=a.normal,l=e.dot(f,u);if(Math.abs(l)<o.EPSILON6)return void 0;var c=e.dot(f,r),h=-(a.distance+c)/l;return 0>h||h>1?void 0:(e.multiplyByScalar(u,h,s),e.add(r,s,s),s)},E.trianglePlaneIntersection=function(r,t,o,a){if(!(n(r)&&n(t)&&n(o)&&n(a)))throw new i("p0, p1, p2, and plane are required.");var s=a.normal,u=a.distance,f=e.dot(s,r)+u<0,l=e.dot(s,t)+u<0,c=e.dot(s,o)+u<0,h=0;h+=f?1:0,h+=l?1:0,h+=c?1:0;var d,w;if((1===h||2===h)&&(d=new e,w=new e),1===h){if(f)return E.lineSegmentPlane(r,t,a,d),E.lineSegmentPlane(r,o,a,w),{positions:[r,t,o,d,w],indices:[0,3,4,1,2,4,1,4,3]};if(l)return E.lineSegmentPlane(t,o,a,d),E.lineSegmentPlane(t,r,a,w),{positions:[r,t,o,d,w],indices:[1,3,4,2,0,4,2,4,3]};if(c)return E.lineSegmentPlane(o,r,a,d),E.lineSegmentPlane(o,t,a,w),{positions:[r,t,o,d,w],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===h){if(!f)return E.lineSegmentPlane(t,r,a,d),E.lineSegmentPlane(o,r,a,w),{positions:[r,t,o,d,w],indices:[1,2,4,1,4,3,0,3,4]};if(!l)return E.lineSegmentPlane(o,t,a,d),E.lineSegmentPlane(r,t,a,w),{positions:[r,t,o,d,w],indices:[2,0,4,2,4,3,1,3,4]};if(!c)return E.lineSegmentPlane(r,o,a,d),E.lineSegmentPlane(t,o,a,w),{positions:[r,t,o,d,w],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},E}),define("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,r,t){"use strict";var n={};return n.calculateACMR=function(n){n=e(n,e.EMPTY_OBJECT);var i=n.indices,o=n.maximumIndex,a=e(n.cacheSize,24);if(!r(i))throw new t("indices is required.");var s=i.length;if(3>s||s%3!==0)throw new t("indices length must be a multiple of three.");if(0>=o)throw new t("maximumIndex must be greater than zero.");if(3>a)throw new t("cacheSize must be greater than two.");if(!r(o)){o=0;for(var u=0,f=i[u];s>u;)f>o&&(o=f),++u,f=i[u]}for(var l=[],c=0;o+1>c;c++)l[c]=0;for(var h=a+1,d=0;s>d;++d)h-l[i[d]]>a&&(l[i[d]]=h,++h);return(h-a+1)/(s/3)},n.tipsify=function(n){function i(e,r,t,n){for(;r.length>=1;){var i=r[r.length-1];if(r.splice(r.length-1,1),e[i].numLiveTriangles>0)return i}for(;n>a;){if(e[a].numLiveTriangles>0)return++a,a-1;++a}return-1}function o(e,r,t,n,o,a,s){for(var u,f=-1,l=-1,c=0;c<t.length;){var h=t[c];n[h].numLiveTriangles&&(u=0,o-n[h].timeStamp+2*n[h].numLiveTriangles<=r&&(u=o-n[h].timeStamp),(u>l||-1===l)&&(l=u,f=h)),++c}return-1===f?i(n,a,e,s):f}n=e(n,e.EMPTY_OBJECT);var a,s=n.indices,u=n.maximumIndex,f=e(n.cacheSize,24);if(!r(s))throw new t("indices is required.");var l=s.length;if(3>l||l%3!==0)throw new t("indices length must be a multiple of three.");if(0>=u)throw new t("maximumIndex must be greater than zero.");if(3>f)throw new t("cacheSize must be greater than two.");var c=0,h=0,d=s[h],w=l;if(r(u))c=u+1;else{for(;w>h;)d>c&&(c=d),++h,d=s[h];if(-1===c)return 0;++c}for(var E=[],m=0;c>m;m++)E[m]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};h=0;for(var p=0;w>h;)E[s[h]].vertexTriangles.push(p),++E[s[h]].numLiveTriangles,E[s[h+1]].vertexTriangles.push(p),++E[s[h+1]].numLiveTriangles,E[s[h+2]].vertexTriangles.push(p),++E[s[h+2]].numLiveTriangles,++p,h+=3;var T=0,y=f+1;a=1;var R,A,v=[],_=[],S=0,g=[],C=l/3,N=[];for(m=0;C>m;m++)N[m]=!1;for(var I,O;-1!==T;){v=[],A=E[T],O=A.vertexTriangles.length;for(var b=0;O>b;++b)if(p=A.vertexTriangles[b],!N[p]){N[p]=!0,h=p+p+p;for(var M=0;3>M;++M)I=s[h],v.push(I),_.push(I),g[S]=I,++S,R=E[I],--R.numLiveTriangles,y-R.timeStamp>f&&(R.timeStamp=y,++y),++h}T=o(s,f,v,E,y,_,c)}return g},n}),define("Core/GeometryPipeline",["./AttributeCompression","./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryInstance","./GeometryType","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],function(e,r,t,n,i,o,a,s,u,f,l,c,h,d,w,E,m,p,T,y,R,A,v,_,S,g){"use strict";function C(e,r,t,n,i){e[r++]=t,e[r++]=n,e[r++]=n,e[r++]=i,e[r++]=i,e[r]=t}function N(e){for(var r=e.length,t=r/3*6,n=p.createTypedArray(r,t),i=0,o=0;r>o;o+=3,i+=6)C(n,i,e[o],e[o+1],e[o+2]);return n}function I(e){var r=e.length;if(r>=3){var t=6*(r-2),n=p.createTypedArray(r,t);C(n,0,e[0],e[1],e[2]);for(var i=6,o=3;r>o;++o,i+=6)C(n,i,e[o-1],e[o],e[o-2]);return n}return new Uint16Array}function O(e){if(e.length>0){for(var r=e.length-1,t=6*(r-1),n=p.createTypedArray(r,t),i=e[0],o=0,a=1;r>a;++a,o+=6)C(n,o,i,e[a],e[a+1]);return n}return new Uint16Array}function b(e){var r={};for(var t in e)if(e.hasOwnProperty(t)&&f(e[t])&&f(e[t].values)){var n=e[t];r[t]=new w({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return r}function M(e,r,t){for(var n in r)if(r.hasOwnProperty(n)&&f(r[n])&&f(r[n].values))for(var i=r[n],o=0;o<i.componentsPerAttribute;++o)e[n].values.push(i.values[t*i.componentsPerAttribute+o])}function q(e,r){if(f(r))for(var t=r.values,n=t.length,o=0;n>o;o+=3)i.unpack(t,o,oe),v.multiplyByPoint(e,oe,oe),i.pack(oe,t,o)}function L(e,r){if(f(r))for(var t=r.values,n=t.length,o=0;n>o;o+=3)i.unpack(t,o,oe),A.multiplyByVector(e,oe,oe),oe=i.normalize(oe,oe),i.pack(oe,t,o)}function F(e,r){var t,n=e.length,i={},o=e[0][r].attributes;for(t in o)if(o.hasOwnProperty(t)&&f(o[t])&&f(o[t].values)){for(var a=o[t],u=a.values.length,l=!0,c=1;n>c;++c){var h=e[c][r].attributes[t];if(!f(h)||a.componentDatatype!==h.componentDatatype||a.componentsPerAttribute!==h.componentsPerAttribute||a.normalize!==h.normalize){l=!1;break}u+=h.values.length}l&&(i[t]=new w({componentDatatype:a.componentDatatype,componentsPerAttribute:a.componentsPerAttribute,normalize:a.normalize,values:s.createTypedArray(a.componentDatatype,u)}))}return i}function P(e,r){var n,o,a,s,u=e.length,c=e[0].modelMatrix,h=f(e[0][r].indices),w=e[0][r].primitiveType;for(o=1;u>o;++o){if(!v.equals(e[o].modelMatrix,c))throw new l("All instances must have the same modelMatrix.");if(f(e[o][r].indices)!==h)throw new l("All instance geometries must have an indices or not have one.");if(e[o][r].primitiveType!==w)throw new l("All instance geometries must have the same primitiveType.")}var E,m,T,y=F(e,r);for(n in y)if(y.hasOwnProperty(n))for(E=y[n].values,s=0,o=0;u>o;++o)for(m=e[o][r].attributes[n].values,T=m.length,a=0;T>a;++a)E[s++]=m[a];var R;if(h){var A=0;for(o=0;u>o;++o)A+=e[o][r].indices.length;var _=d.computeNumberOfVertices(new d({attributes:y,primitiveType:S.POINTS})),g=p.createTypedArray(_,A),C=0,N=0;for(o=0;u>o;++o){var I=e[o][r].indices,O=I.length;for(s=0;O>s;++s)g[C++]=N+I[s];N+=d.computeNumberOfVertices(e[o][r])}R=g}var b,M=new i,q=0;for(o=0;u>o;++o){if(b=e[o][r].boundingSphere,!f(b)){M=void 0;break}i.add(b.center,M,M)}if(f(M))for(i.divideByScalar(M,u,M),o=0;u>o;++o){b=e[o][r].boundingSphere;var L=i.magnitude(i.subtract(b.center,M,ue))+b.radius;L>q&&(q=L)}return new d({attributes:y,indices:R,primitiveType:w,boundingSphere:f(M)?new t(M,q):void 0})}function D(e){if(f(e.indices))return e;var r=d.computeNumberOfVertices(e);if(3>r)throw new l("The number of vertices must be at least three.");if(r%3!==0)throw new l("The number of vertices must be a multiple of three.");for(var t=p.createTypedArray(r,r),n=0;r>n;++n)t[n]=n;return e.indices=t,e}function x(e){var r=d.computeNumberOfVertices(e);if(3>r)throw new l("The number of vertices must be at least three.");var t=p.createTypedArray(r,3*(r-2));t[0]=1,t[1]=0,t[2]=2;for(var n=3,i=3;r>i;++i)t[n++]=i-1,t[n++]=0,t[n++]=i;return e.indices=t,e.primitiveType=S.TRIANGLES,e}function U(e){var r=d.computeNumberOfVertices(e);if(3>r)throw new l("The number of vertices must be at least 3.");var t=p.createTypedArray(r,3*(r-2));t[0]=0,t[1]=1,t[2]=2,r>3&&(t[3]=0,t[4]=2,t[5]=3);for(var n=6,i=3;r-1>i;i+=2)t[n++]=i,t[n++]=i-1,t[n++]=i+1,r>i+2&&(t[n++]=i,t[n++]=i+1,t[n++]=i+2);return e.indices=t,e.primitiveType=S.TRIANGLES,e}function B(e){if(f(e.indices))return e;var r=d.computeNumberOfVertices(e);if(2>r)throw new l("The number of vertices must be at least two.");if(r%2!==0)throw new l("The number of vertices must be a multiple of 2.");for(var t=p.createTypedArray(r,r),n=0;r>n;++n)t[n]=n;return e.indices=t,e}function G(e){var r=d.computeNumberOfVertices(e);if(2>r)throw new l("The number of vertices must be at least two.");var t=p.createTypedArray(r,2*(r-1));t[0]=0,t[1]=1;for(var n=2,i=2;r>i;++i)t[n++]=i-1,t[n++]=i;return e.indices=t,e.primitiveType=S.LINES,e}function z(e){var r=d.computeNumberOfVertices(e);if(2>r)throw new l("The number of vertices must be at least two.");var t=p.createTypedArray(r,2*r);t[0]=0,t[1]=1;for(var n=2,i=2;r>i;++i)t[n++]=i-1,t[n++]=i;return t[n++]=r-1,t[n]=0,e.indices=t,e.primitiveType=S.LINES,e}function V(e){switch(e.primitiveType){case S.TRIANGLE_FAN:return x(e);case S.TRIANGLE_STRIP:return U(e);case S.TRIANGLES:return D(e);case S.LINE_STRIP:return G(e);case S.LINE_LOOP:return z(e);case S.LINES:return B(e)}return e}function H(e,r){Math.abs(e.y)<R.EPSILON6&&(r?e.y=-R.EPSILON6:e.y=R.EPSILON6)}function W(e,r,t){if(0!==e.y&&0!==r.y&&0!==t.y)return H(e,e.y<0),H(r,r.y<0),void H(t,t.y<0);var n,i=Math.abs(e.y),o=Math.abs(r.y),a=Math.abs(t.y);n=i>o?i>a?R.sign(e.y):R.sign(t.y):o>a?R.sign(r.y):R.sign(t.y);var s=0>n;H(e,s),H(r,s),H(t,s)}function Y(e,r,t,n){i.add(e,i.multiplyByScalar(i.subtract(r,e,Re),e.y/(e.y-r.y),Re),t),i.clone(t,n),H(t,!0),H(n,!1)}function X(e,r,t){if(e.x>=0||r.x>=0||t.x>=0)return void 0;W(e,r,t);var n=e.y<0,i=r.y<0,o=t.y<0,a=0;a+=n?1:0,a+=i?1:0,a+=o?1:0;var s=ge.indices;1===a?(s[1]=3,s[2]=4,s[5]=6,s[7]=6,s[8]=5,n?(Y(e,r,Ae,_e),Y(e,t,ve,Se),s[0]=0,s[3]=1,s[4]=2,s[6]=1):i?(Y(r,t,Ae,_e),Y(r,e,ve,Se),s[0]=1,s[3]=2,s[4]=0,s[6]=2):o&&(Y(t,e,Ae,_e),Y(t,r,ve,Se),s[0]=2,s[3]=0,s[4]=1,s[6]=0)):2===a&&(s[2]=4,s[4]=4,s[5]=3,s[7]=5,s[8]=6,n?i?o||(Y(t,e,Ae,_e),Y(t,r,ve,Se),s[0]=0,s[1]=1,s[3]=0,s[6]=2):(Y(r,t,Ae,_e),Y(r,e,ve,Se),s[0]=2,s[1]=0,s[3]=2,s[6]=1):(Y(e,r,Ae,_e),Y(e,t,ve,Se),s[0]=1,s[1]=2,s[3]=1,s[6]=0));var u=ge.positions;return u[0]=e,u[1]=r,u[2]=t,u.length=3,(1===a||2===a)&&(u[3]=Ae,u[4]=ve,u[5]=_e,u[6]=Se,u.length=7),ge}function k(e,r){var n=e.attributes;if(0===n.position.values.length)return void 0;for(var i in n)if(n.hasOwnProperty(i)&&f(n[i])&&f(n[i].values)){var o=n[i];o.values=s.createTypedArray(o.componentDatatype,o.values)}var a=d.computeNumberOfVertices(e);return e.indices=p.createTypedArray(a,e.indices),r&&(e.boundingSphere=t.fromVertices(n.position.values)),e}function K(e){var r=e.attributes,t={};for(var n in r)if(r.hasOwnProperty(n)&&f(r[n])&&f(r[n].values)){var i=r[n];t[n]=new w({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]})}return new d({attributes:t,indices:[],primitiveType:e.primitiveType})}function Z(e,r,t){var n=f(e.geometry.boundingSphere);r=k(r,n),t=k(t,n),f(t)&&!f(r)?e.geometry=t:!f(t)&&f(r)?e.geometry=r:(e.westHemisphereGeometry=r,e.eastHemisphereGeometry=t,e.geometry=void 0)}function j(e,t,o,a,s,u,l,c,h,d,w){if(f(u)||f(l)||f(c)||f(h)){var E=i.fromArray(s,3*e,Ce),m=i.fromArray(s,3*t,Ne),p=i.fromArray(s,3*o,Ie),T=r(a,E,m,p,Oe);if(f(u)){var y=i.fromArray(u,3*e,Ce),R=i.fromArray(u,3*t,Ne),A=i.fromArray(u,3*o,Ie);i.multiplyByScalar(y,T.x,y),i.multiplyByScalar(R,T.y,R),i.multiplyByScalar(A,T.z,A);var v=i.add(y,R,y);i.add(v,A,v),i.normalize(v,v),i.pack(v,d.normal.values,3*w)}if(f(l)){var _=i.fromArray(l,3*e,Ce),S=i.fromArray(l,3*t,Ne),g=i.fromArray(l,3*o,Ie);i.multiplyByScalar(_,T.x,_),i.multiplyByScalar(S,T.y,S),i.multiplyByScalar(g,T.z,g);var C=i.add(_,S,_);i.add(C,g,C),i.normalize(C,C),i.pack(C,d.binormal.values,3*w)}if(f(c)){var N=i.fromArray(c,3*e,Ce),I=i.fromArray(c,3*t,Ne),O=i.fromArray(c,3*o,Ie);i.multiplyByScalar(N,T.x,N),i.multiplyByScalar(I,T.y,I),i.multiplyByScalar(O,T.z,O);var b=i.add(N,I,N);i.add(b,O,b),i.normalize(b,b),i.pack(b,d.tangent.values,3*w)}if(f(h)){var M=n.fromArray(h,2*e,be),q=n.fromArray(h,2*t,Me),L=n.fromArray(h,2*o,qe);n.multiplyByScalar(M,T.x,M),n.multiplyByScalar(q,T.y,q),n.multiplyByScalar(L,T.z,L);var F=n.add(M,q,M);n.add(F,L,F),n.pack(F,d.st.values,2*w)}}}function Q(e,r,t,n,i,o){var a=e.position.values.length/3;if(-1!==i){var s=n[i],u=t[s];return-1===u?(t[s]=a,e.position.values.push(o.x,o.y,o.z),r.push(a),a):(r.push(u),u)}return e.position.values.push(o.x,o.y,o.z),r.push(a),a}function J(e){var r,t,n,o,a,s=e.geometry,u=s.attributes,l=u.position.values,c=f(u.normal)?u.normal.values:void 0,h=f(u.binormal)?u.binormal.values:void 0,d=f(u.tangent)?u.tangent.values:void 0,w=f(u.st)?u.st.values:void 0,E=s.indices,m=K(s),p=K(s),T=[];T.length=l.length/3;var y=[];for(y.length=l.length/3,a=0;a<T.length;++a)T[a]=-1,y[a]=-1;var R=E.length;for(a=0;R>a;a+=3){var A=E[a],v=E[a+1],_=E[a+2],S=i.fromArray(l,3*A),g=i.fromArray(l,3*v),C=i.fromArray(l,3*_),N=X(S,g,C);if(f(N)&&N.positions.length>3)for(var I=N.positions,O=N.indices,b=O.length,M=0;b>M;++M){var q=O[M],L=I[q];L.y<0?(r=p.attributes,t=p.indices,n=T):(r=m.attributes,t=m.indices,n=y),o=Q(r,t,n,E,3>q?a+q:-1,L),j(A,v,_,L,l,c,h,d,w,r,o)}else f(N)&&(S=N.positions[0],g=N.positions[1],C=N.positions[2]),S.y<0?(r=p.attributes,t=p.indices,n=T):(r=m.attributes,t=m.indices,n=y),o=Q(r,t,n,E,a,S),j(A,v,_,S,l,c,h,d,w,r,o),o=Q(r,t,n,E,a+1,g),j(A,v,_,g,l,c,h,d,w,r,o),o=Q(r,t,n,E,a+2,C),j(A,v,_,C,l,c,h,d,w,r,o)}Z(e,p,m)}function $(e){var r,t=e.geometry,n=t.attributes,o=n.position.values,a=t.indices,s=K(t),u=K(t),l=a.length,c=[];c.length=o.length/3;var h=[];for(h.length=o.length/3,r=0;r<c.length;++r)c[r]=-1,h[r]=-1;for(r=0;l>r;r+=2){var d=a[r],w=a[r+1],E=i.fromArray(o,3*d,Ce),m=i.fromArray(o,3*w,Ne);Math.abs(E.y)<R.EPSILON6&&(E.y<0?E.y=-R.EPSILON6:E.y=R.EPSILON6),Math.abs(m.y)<R.EPSILON6&&(m.y<0?m.y=-R.EPSILON6:m.y=R.EPSILON6);var p=s.attributes,T=s.indices,A=h,v=u.attributes,_=u.indices,S=c,g=y.lineSegmentPlane(E,m,Le,Ie);if(f(g)){var C=i.multiplyByScalar(i.UNIT_Y,5*R.EPSILON9,Fe);E.y<0&&(i.negate(C,C),p=u.attributes,T=u.indices,A=c,v=s.attributes,_=s.indices,S=h);var N=i.add(g,C,Pe);Q(p,T,A,a,r,E),Q(p,T,A,a,-1,N),i.negate(C,C),i.add(g,C,N),Q(v,_,S,a,-1,N),Q(v,_,S,a,r+1,m)}else{var I,O,b;E.y<0?(I=u.attributes,O=u.indices,b=c):(I=s.attributes,O=s.indices,b=h),Q(I,O,b,a,r,E),Q(I,O,b,a,r+1,m)}}Z(e,u,s)}function ee(e){var r,t,a,s=e.geometry,u=s.attributes,l=u.position.values,c=u.prevPosition.values,h=u.nextPosition.values,d=u.expandAndWidth.values,w=(s.indices,f(u.st)?u.st.values:void 0),E=f(u.color)?u.color.values:void 0,m=K(s),p=K(s),T=l.length/3;for(r=0;T>r;r+=4){var A=r,v=r+1,_=r+2,S=r+3,g=i.fromArray(l,3*A,Ue),C=i.fromArray(l,3*v,Be),N=i.fromArray(l,3*_,Ge),I=i.fromArray(l,3*S,ze);Math.abs(g.y)<R.EPSILON6&&(g.y=R.EPSILON6*(N.y<0?-1:1),C.y=g.y),Math.abs(N.y)<R.EPSILON6&&(N.y=R.EPSILON6*(g.y<0?-1:1),I.y=N.y);var O=m.attributes,b=m.indices,M=p.attributes,q=p.indices,L=y.lineSegmentPlane(g,N,Le,Ve);if(f(L)){var F=i.multiplyByScalar(i.UNIT_Y,5*R.EPSILON9,He);g.y<0&&(i.negate(F,F),O=p.attributes,b=p.indices,M=m.attributes,q=m.indices);var P=i.add(L,F,We);for(O.position.values.push(g.x,g.y,g.z,C.x,C.y,C.z),O.position.values.push(P.x,P.y,P.z),O.position.values.push(P.x,P.y,P.z),i.negate(F,F),i.add(L,F,P),M.position.values.push(P.x,P.y,P.z),M.position.values.push(P.x,P.y,P.z),M.position.values.push(N.x,N.y,N.z,I.x,I.y,I.z),t=3*A;3*A+6>t;++t)O.prevPosition.values.push(c[t]);for(O.prevPosition.values.push(g.x,g.y,g.z,g.x,g.y,g.z),M.prevPosition.values.push(g.x,g.y,g.z,g.x,g.y,g.z),t=3*_;3*_+6>t;++t)M.prevPosition.values.push(c[t]);for(t=3*A;3*A+6>t;++t)O.nextPosition.values.push(h[t]);for(O.nextPosition.values.push(N.x,N.y,N.z,N.x,N.y,N.z),M.nextPosition.values.push(N.x,N.y,N.z,N.x,N.y,N.z),t=3*_;3*_+6>t;++t)M.nextPosition.values.push(h[t]);var D=n.fromArray(d,2*A,De),x=Math.abs(D.y);O.expandAndWidth.values.push(-1,x,1,x),O.expandAndWidth.values.push(-1,-x,1,-x),M.expandAndWidth.values.push(-1,x,1,x),M.expandAndWidth.values.push(-1,-x,1,-x);var U=i.magnitudeSquared(i.subtract(L,g,ze));if(U/=i.magnitudeSquared(i.subtract(N,g,ze)),f(E)){var B=o.fromArray(E,4*A,Ye),G=o.fromArray(E,4*_,Ye),z=R.lerp(B.x,G.x,U),V=R.lerp(B.y,G.y,U),H=R.lerp(B.z,G.z,U),W=R.lerp(B.w,G.w,U);for(t=4*A;4*A+8>t;++t)O.color.values.push(E[t]);for(O.color.values.push(z,V,H,W),O.color.values.push(z,V,H,W),M.color.values.push(z,V,H,W),M.color.values.push(z,V,H,W),t=4*_;4*_+8>t;++t)M.color.values.push(E[t])}if(f(w)){var Y=n.fromArray(w,2*A,De),X=n.fromArray(w,2*(r+3),xe),k=R.lerp(Y.x,X.x,U);for(t=2*A;2*A+4>t;++t)O.st.values.push(w[t]);for(O.st.values.push(k,Y.y),O.st.values.push(k,X.y),M.st.values.push(k,Y.y),M.st.values.push(k,X.y),t=2*_;2*_+4>t;++t)M.st.values.push(w[t])}a=O.position.values.length/3-4,b.push(a,a+2,a+1),b.push(a+1,a+2,a+3),a=M.position.values.length/3-4,q.push(a,a+2,a+1),q.push(a+1,a+2,a+3)}else{var j,Q;for(g.y<0?(j=p.attributes,Q=p.indices):(j=m.attributes,Q=m.indices),j.position.values.push(g.x,g.y,g.z),j.position.values.push(C.x,C.y,C.z),j.position.values.push(N.x,N.y,N.z),j.position.values.push(I.x,I.y,I.z),t=3*r;3*r+12>t;++t)j.prevPosition.values.push(c[t]),j.nextPosition.values.push(h[t]);for(t=2*r;2*r+8>t;++t)j.expandAndWidth.values.push(d[t]),f(w)&&j.st.values.push(w[t]);if(f(E))for(t=4*r;4*r+16>t;++t)j.color.values.push(E[t]);a=j.position.values.length/3-4,Q.push(a,a+2,a+1),Q.push(a+1,a+2,a+3)}}Z(e,p,m)}var re={};re.toWireframe=function(e){if(!f(e))throw new l("geometry is required.");var r=e.indices;if(f(r)){switch(e.primitiveType){case S.TRIANGLES:e.indices=N(r);break;case S.TRIANGLE_STRIP:e.indices=I(r);break;case S.TRIANGLE_FAN:e.indices=O(r);break;default:throw new l("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=S.LINES}return e},re.createLineSegmentsForVectors=function(e,r,n){if(r=u(r,"normal"),!f(e))throw new l("geometry is required.");if(!f(e.attributes.position))throw new l("geometry.attributes.position is required.");if(!f(e.attributes[r]))throw new l("geometry.attributes must have an attribute with the same name as the attributeName parameter, "+r+".");n=u(n,1e4);for(var i=e.attributes.position.values,o=e.attributes[r].values,a=i.length,c=new Float64Array(2*a),h=0,E=0;a>E;E+=3)c[h++]=i[E],c[h++]=i[E+1],c[h++]=i[E+2],c[h++]=i[E]+o[E]*n,c[h++]=i[E+1]+o[E+1]*n,c[h++]=i[E+2]+o[E+2]*n;var m,p=e.boundingSphere;return f(p)&&(m=new t(p.center,p.radius+n)),new d({attributes:{position:new w({componentDatatype:s.DOUBLE,componentsPerAttribute:3,values:c})},primitiveType:S.LINES,boundingSphere:m})},re.createAttributeLocations=function(e){if(!f(e))throw new l("geometry is required.");var r,t=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent","compressedAttributes"],n=e.attributes,i={},o=0,a=t.length;for(r=0;a>r;++r){var s=t[r];f(n[s])&&(i[s]=o++)}for(var u in n)n.hasOwnProperty(u)&&!f(i[u])&&(i[u]=o++);return i},re.reorderForPreVertexCache=function(e){if(!f(e))throw new l("geometry is required.");var r=d.computeNumberOfVertices(e),t=e.indices;if(f(t)){for(var n=new Int32Array(r),i=0;r>i;i++)n[i]=-1;for(var o,a=t,u=a.length,c=p.createTypedArray(r,u),h=0,w=0,E=0;u>h;)o=n[a[h]],-1!==o?c[w]=o:(o=a[h],n[o]=E,c[w]=E,++E),++h,++w;e.indices=c;var m=e.attributes;for(var T in m)if(m.hasOwnProperty(T)&&f(m[T])&&f(m[T].values)){for(var y=m[T],R=y.values,A=0,v=y.componentsPerAttribute,_=s.createTypedArray(y.componentDatatype,E*v);r>A;){var S=n[A];if(-1!==S)for(i=0;v>i;i++)_[v*S+i]=R[v*A+i];++A}y.values=_}}return e},re.reorderForPostVertexCache=function(e,r){if(!f(e))throw new l("geometry is required.");var t=e.indices;if(e.primitiveType===S.TRIANGLES&&f(t)){for(var n=t.length,i=0,o=0;n>o;o++)t[o]>i&&(i=t[o]);e.indices=g.tipsify({indices:t,maximumIndex:i,cacheSize:r})}return e},re.fitToUnsignedShortIndices=function(e){if(!f(e))throw new l("geometry is required.");if(f(e.indices)&&e.primitiveType!==S.TRIANGLES&&e.primitiveType!==S.LINES&&e.primitiveType!==S.POINTS)throw new l("geometry.primitiveType must equal to PrimitiveType.TRIANGLES, PrimitiveType.LINES, or PrimitiveType.POINTS.");var r=[],t=d.computeNumberOfVertices(e);if(f(e.indices)&&t>=R.SIXTY_FOUR_KILOBYTES){var n,i=[],o=[],a=0,s=b(e.attributes),u=e.indices,c=u.length;e.primitiveType===S.TRIANGLES?n=3:e.primitiveType===S.LINES?n=2:e.primitiveType===S.POINTS&&(n=1);for(var h=0;c>h;h+=n){for(var w=0;n>w;++w){var E=u[h+w],m=i[E];f(m)||(m=a++,i[E]=m,M(s,e.attributes,E)),o.push(m)}a+n>=R.SIXTY_FOUR_KILOBYTES&&(r.push(new d({attributes:s,indices:o,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),i=[],o=[],a=0,s=b(e.attributes))}0!==o.length&&r.push(new d({attributes:s,indices:o,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else r.push(e);return r};var te=new i,ne=new a;re.projectTo2D=function(e,r,t,n,o){if(!f(e))throw new l("geometry is required.");if(!f(r))throw new l("attributeName is required.");if(!f(t))throw new l("attributeName3D is required.");if(!f(n))throw new l("attributeName2D is required.");if(!f(e.attributes[r]))throw new l("geometry must have attribute matching the attributeName argument: "+r+".");if(e.attributes[r].componentDatatype!==s.DOUBLE)throw new l("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");var a=e.attributes[r];o=f(o)?o:new h;for(var u=o.ellipsoid,c=a.values,d=new Float64Array(c.length),E=0,m=0;m<c.length;m+=3){var p=i.fromArray(c,m,te),T=u.cartesianToCartographic(p,ne);if(!f(T))throw new l("Could not project point ("+p.x+", "+p.y+", "+p.z+") to 2D.");var y=o.project(T,te);d[E++]=y.x,d[E++]=y.y,d[E++]=y.z}return e.attributes[t]=a,e.attributes[n]=new w({componentDatatype:s.DOUBLE,componentsPerAttribute:3,values:d}),delete e.attributes[r],e};var ie={high:0,low:0};re.encodeAttribute=function(e,r,t,n){if(!f(e))throw new l("geometry is required.");if(!f(r))throw new l("attributeName is required.");if(!f(t))throw new l("attributeHighName is required.");if(!f(n))throw new l("attributeLowName is required.");if(!f(e.attributes[r]))throw new l("geometry must have attribute matching the attributeName argument: "+r+".");if(e.attributes[r].componentDatatype!==s.DOUBLE)throw new l("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");for(var i=e.attributes[r],o=i.values,a=o.length,u=new Float32Array(a),h=new Float32Array(a),d=0;a>d;++d)c.encode(o[d],ie),u[d]=ie.high,h[d]=ie.low;var E=i.componentsPerAttribute;return e.attributes[t]=new w({componentDatatype:s.FLOAT,componentsPerAttribute:E,values:u}),e.attributes[n]=new w({componentDatatype:s.FLOAT,componentsPerAttribute:E,values:h}),delete e.attributes[r],e};var oe=new i,ae=new v,se=new A;re.transformToWorldCoordinates=function(e){if(!f(e))throw new l("instance is required.");var r=e.modelMatrix;if(v.equals(r,v.IDENTITY))return e;var n=e.geometry.attributes;q(r,n.position),q(r,n.prevPosition),q(r,n.nextPosition),(f(n.normal)||f(n.binormal)||f(n.tangent))&&(v.inverse(r,ae),v.transpose(ae,ae),v.getRotation(ae,se),L(se,n.normal),L(se,n.binormal),L(se,n.tangent));var i=e.geometry.boundingSphere;return f(i)&&(e.geometry.boundingSphere=t.transform(i,r,i)),e.modelMatrix=v.clone(v.IDENTITY),e};var ue=new i;re.combineInstances=function(e){if(!f(e)||e.length<1)throw new l("instances is required and must have length greater than zero.");for(var r=[],t=[],n=e.length,i=0;n>i;++i){var o=e[i];f(o.geometry)?r.push(o):t.push(o)}var a=[];return r.length>0&&a.push(P(r,"geometry")),t.length>0&&(a.push(P(t,"westHemisphereGeometry")),a.push(P(t,"eastHemisphereGeometry"))),a};var fe=new i,le=new i,ce=new i,he=new i;re.computeNormal=function(e){if(!f(e))throw new l("geometry is required.");if(!f(e.attributes.position)||!f(e.attributes.position.values))throw new l("geometry.attributes.position.values is required.");if(!f(e.indices))throw new l("geometry.indices is required.");if(e.indices.length<2||e.indices.length%3!==0)throw new l("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==S.TRIANGLES)throw new l("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var r=e.indices,t=e.attributes,n=t.position.values,o=t.position.values.length/3,a=r.length,u=new Array(o),c=new Array(a/3),h=new Array(a),d=0;o>d;d++)u[d]={indexOffset:0,count:0,currentCount:0};var E=0;for(d=0;a>d;d+=3){var m=r[d],p=r[d+1],T=r[d+2],y=3*m,R=3*p,A=3*T;le.x=n[y],le.y=n[y+1],le.z=n[y+2],ce.x=n[R],ce.y=n[R+1],ce.z=n[R+2],he.x=n[A],he.y=n[A+1],he.z=n[A+2],u[m].count++,u[p].count++,u[T].count++,i.subtract(ce,le,ce),i.subtract(he,le,he),c[E]=i.cross(ce,he,new i),E++}var v=0;for(d=0;o>d;d++)u[d].indexOffset+=v,v+=u[d].count;E=0;var _;for(d=0;a>d;d+=3){_=u[r[d]];var g=_.indexOffset+_.currentCount;h[g]=E,_.currentCount++,_=u[r[d+1]],g=_.indexOffset+_.currentCount,h[g]=E,_.currentCount++,_=u[r[d+2]],g=_.indexOffset+_.currentCount,h[g]=E,_.currentCount++,E++}var C=new Float32Array(3*o);for(d=0;o>d;d++){var N=3*d;if(_=u[d],_.count>0){for(i.clone(i.ZERO,fe),E=0;E<_.count;E++)i.add(fe,c[h[_.indexOffset+E]],fe);i.normalize(fe,fe),C[N]=fe.x,C[N+1]=fe.y,C[N+2]=fe.z}else C[N]=0,C[N+1]=0,C[N+2]=1}return e.attributes.normal=new w({componentDatatype:s.FLOAT,componentsPerAttribute:3,values:C}),e};var de=new i,we=new i,Ee=new i;re.computeBinormalAndTangent=function(e){if(!f(e))throw new l("geometry is required.");var r=e.attributes,t=e.indices;if(!f(r.position)||!f(r.position.values))throw new l("geometry.attributes.position.values is required.");if(!f(r.normal)||!f(r.normal.values))throw new l("geometry.attributes.normal.values is required.");if(!f(r.st)||!f(r.st.values))throw new l("geometry.attributes.st.values is required.");if(!f(t))throw new l("geometry.indices is required.");if(t.length<2||t.length%3!==0)throw new l("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==S.TRIANGLES)throw new l("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var n=e.attributes.position.values,o=e.attributes.normal.values,a=e.attributes.st.values,u=e.attributes.position.values.length/3,c=t.length,h=new Array(3*u),d=0;d<h.length;d++)h[d]=0;var E,m,p;for(d=0;c>d;d+=3){var T=t[d],y=t[d+1],R=t[d+2];E=3*T,m=3*y,p=3*R;var A=2*T,v=2*y,_=2*R,g=n[E],C=n[E+1],N=n[E+2],I=a[A],O=a[A+1],b=a[v+1]-O,M=a[_+1]-O,q=1/((a[v]-I)*M-(a[_]-I)*b),L=(M*(n[m]-g)-b*(n[p]-g))*q,F=(M*(n[m+1]-C)-b*(n[p+1]-C))*q,P=(M*(n[m+2]-N)-b*(n[p+2]-N))*q;h[E]+=L,h[E+1]+=F,h[E+2]+=P,h[m]+=L,h[m+1]+=F,h[m+2]+=P,h[p]+=L,h[p+1]+=F,h[p+2]+=P}var D=new Float32Array(3*u),x=new Float32Array(3*u);for(d=0;u>d;d++){E=3*d,m=E+1,p=E+2;var U=i.fromArray(o,E,de),B=i.fromArray(h,E,Ee),G=i.dot(U,B);i.multiplyByScalar(U,G,we),i.normalize(i.subtract(B,we,B),B),x[E]=B.x,x[m]=B.y,x[p]=B.z,i.normalize(i.cross(U,B,B),B),D[E]=B.x,D[m]=B.y,D[p]=B.z}return e.attributes.tangent=new w({componentDatatype:s.FLOAT,componentsPerAttribute:3,values:x}),e.attributes.binormal=new w({componentDatatype:s.FLOAT,componentsPerAttribute:3,values:D}),e};var me=new n,pe=new i,Te=new i,ye=new i;re.compressVertices=function(r){if(!f(r))throw new l("geometry is required.");var t=r.attributes.normal,o=r.attributes.st;if(!f(t)&&!f(o))return r;var a,u,c,h,d=r.attributes.tangent,E=r.attributes.binormal;f(t)&&(a=t.values),f(o)&&(u=o.values),f(d)&&(c=d.values),E&&(h=E.values);var m=f(a)?a.length:u.length,p=f(a)?3:2,T=m/p,y=T,R=f(u)&&f(a)?2:1;R+=f(c)||f(h)?1:0,y*=R;for(var A=new Float32Array(y),v=0,_=0;T>_;++_){f(u)&&(n.fromArray(u,2*_,me),A[v++]=e.compressTextureCoordinates(me));var S=3*_;f(a)&&f(c)&&f(h)?(i.fromArray(a,S,pe),i.fromArray(c,S,Te),i.fromArray(h,S,ye),e.octPack(pe,Te,ye,me),A[v++]=me.x,A[v++]=me.y):(f(a)&&(i.fromArray(a,S,pe),A[v++]=e.octEncodeFloat(pe)),f(c)&&(i.fromArray(c,S,pe),A[v++]=e.octEncodeFloat(pe)),f(h)&&(i.fromArray(h,S,pe),A[v++]=e.octEncodeFloat(pe)))}return r.attributes.compressedAttributes=new w({componentDatatype:s.FLOAT,componentsPerAttribute:R,values:A}),f(a)&&delete r.attributes.normal,f(u)&&delete r.attributes.st,f(c)&&delete r.attributes.tangent,f(h)&&delete r.attributes.binormal,r};var Re=new i,Ae=new i,ve=new i,_e=new i,Se=new i,ge={positions:new Array(7),indices:new Array(9)},Ce=new i,Ne=new i,Ie=new i,Oe=new i,be=new n,Me=new n,qe=new n,Le=_.fromPointNormal(i.ZERO,i.UNIT_Y),Fe=new i,Pe=new i,De=new n,xe=new n,Ue=new i,Be=new i,Ge=new i,ze=new i,Ve=new i,He=new i,We=new i,Ye=new o;new o;return re.splitLongitude=function(e){if(!f(e))throw new l("instance is required.");var r=e.geometry,n=r.boundingSphere;if(f(n)){var i=n.center.x-n.radius;if(i>0||t.intersectPlane(n,_.ORIGIN_ZX_PLANE)!==T.INTERSECTING)return e}if(r.geometryType!==m.NONE)switch(r.geometryType){case m.POLYLINES:ee(e);break;case m.TRIANGLES:J(e);break;case m.LINES:$(e)}else V(r),r.primitiveType===S.TRIANGLES?J(e):r.primitiveType===S.LINES&&$(e);return e},re}),define("Core/WebMercatorProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,r,t,n,i,o,a,s){"use strict";var u=function(e){this._ellipsoid=t(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return i(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.mercatorAngleToGeodeticLatitude=function(e){return s.PI_OVER_TWO-2*Math.atan(Math.exp(-e))},u.geodeticLatitudeToMercatorAngle=function(e){e>u.MaximumLatitude?e=u.MaximumLatitude:e<-u.MaximumLatitude&&(e=-u.MaximumLatitude);var r=Math.sin(e);return.5*Math.log((1+r)/(1-r))},u.MaximumLatitude=u.mercatorAngleToGeodeticLatitude(Math.PI),u.prototype.project=function(r,t){var i=this._semimajorAxis,o=r.longitude*i,a=u.geodeticLatitudeToMercatorAngle(r.latitude)*i,s=r.height;return n(t)?(t.x=o,t.y=a,t.z=s,t):new e(o,a,s)},u.prototype.unproject=function(e,t){if(!n(e))throw new o("cartesian is required");var i=this._oneOverSemimajorAxis,a=e.x*i,s=u.mercatorAngleToGeodeticLatitude(e.y*i),f=e.z;return n(t)?(t.longitude=a,t.latitude=s,t.height=f,t):new r(a,s,f)},u}),define("Scene/PrimitivePipeline",["../Core/BoundingSphere","../Core/Color","../Core/ComponentDatatype","../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/Ellipsoid","../Core/FeatureDetection","../Core/GeographicProjection","../Core/Geometry","../Core/GeometryAttribute","../Core/GeometryAttributes","../Core/GeometryPipeline","../Core/IndexDatatype","../Core/Matrix4","../Core/WebMercatorProjection"],function(e,r,t,n,i,o,a,s,u,f,l,c,h,d,w,E){"use strict";function m(e,r,t){var n,i=!t,o=e.length;if(!i&&o>1){var a=e[0].modelMatrix;for(n=1;o>n;++n)if(!w.equals(a,e[n].modelMatrix)){i=!0;break}}if(i)for(n=0;o>n;++n)h.transformToWorldCoordinates(e[n]);else w.multiplyTransformation(r,e[0].modelMatrix,r)}function p(e,n){var i=e.attributes,o=i.position,a=4*(o.values.length/o.componentsPerAttribute);i.pickColor=new l({componentDatatype:t.UNSIGNED_BYTE,componentsPerAttribute:4,normalize:!0,values:new Uint8Array(a)});for(var s=r.floatToByte(n.red),u=r.floatToByte(n.green),f=r.floatToByte(n.blue),c=r.floatToByte(n.alpha),h=i.pickColor.values,d=0;a>d;d+=4)h[d]=s,h[d+1]=u,h[d+2]=f,h[d+3]=c}function T(e,r){
for(var t=e.length,n=0;t>n;++n){var o=e[n],a=r[n];i(o.geometry)?p(o.geometry,a):(p(o.westHemisphereGeometry,a),p(o.eastHemisphereGeometry,a))}}function y(e){var r,t=e.length,n=[],o=e[0].attributes;for(r in o)if(o.hasOwnProperty(r)){for(var a=o[r],s=!0,u=1;t>u;++u){var f=e[u].attributes[r];if(!i(f)||a.componentDatatype!==f.componentDatatype||a.componentsPerAttribute!==f.componentsPerAttribute||a.normalize!==f.normalize){s=!1;break}}s&&n.push(r)}return n}function R(e,r,n){for(var i=f.computeNumberOfVertices(r),o=n.length,a=0;o>a;++a){for(var s=n[a],u=e[s],c=u.componentDatatype,h=u.value,d=h.length,w=t.createTypedArray(c,i*d),E=0;i>E;++E)w.set(h,E*d);r.attributes[s]=new l({componentDatatype:c,componentsPerAttribute:d,normalize:u.normalize,values:w})}}function A(e,r){for(var t=e.length,n=0;t>n;++n){var o=e[n],a=o.attributes;i(o.geometry)?R(a,o.geometry,r):(R(a,o.westHemisphereGeometry,r),R(a,o.eastHemisphereGeometry,r))}}function v(r){var n,a,s=r.instances,u=r.pickIds,f=r.projection,l=r.elementIndexUintSupported,c=r.scene3DOnly,d=r.allowPicking,w=r.vertexCacheOptimize,E=r.compressVertices,p=r.modelMatrix,R=s.length,v=s[0].geometry.primitiveType;for(n=1;R>n;++n)if(s[n].geometry.primitiveType!==v)throw new o("All instance geometries must have the same primitiveType.");if(m(s,p,c),!c)for(n=0;R>n;++n)h.splitLongitude(s[n]);d&&T(s,u);var _=y(s);if(A(s,_),w)for(n=0;R>n;++n){var S=s[n];i(S.geometry)?(h.reorderForPostVertexCache(S.geometry),h.reorderForPreVertexCache(S.geometry)):(h.reorderForPostVertexCache(S.westHemisphereGeometry),h.reorderForPreVertexCache(S.westHemisphereGeometry),h.reorderForPostVertexCache(S.eastHemisphereGeometry),h.reorderForPreVertexCache(S.eastHemisphereGeometry))}var g=h.combineInstances(s);for(R=g.length,n=0;R>n;++n){a=g[n];var C,N=a.attributes;if(c)for(C in N)N.hasOwnProperty(C)&&N[C].componentDatatype===t.DOUBLE&&h.encodeAttribute(a,C,C+"3DHigh",C+"3DLow");else for(C in N)if(N.hasOwnProperty(C)&&N[C].componentDatatype===t.DOUBLE){var I=C+"3D",O=C+"2D";h.projectTo2D(a,C,I,O,f),i(a.boundingSphere)&&"position"===C&&(a.boundingSphereCV=e.fromVertices(a.attributes.position2D.values)),h.encodeAttribute(a,I,I+"High",I+"Low"),h.encodeAttribute(a,O,O+"High",O+"Low")}E&&h.compressVertices(a)}if(!l){var b=[];for(R=g.length,n=0;R>n;++n)a=g[n],b=b.concat(h.fitToUnsignedShortIndices(a));g=b}return g}function _(e,r,n){for(var i=[],o=e.attributes,a=n.length,s=0;a>s;++s){var u=n[s],f=o[u],l=f.componentDatatype;l===t.DOUBLE&&(l=t.FLOAT);var c=t.createTypedArray(l,f.values);i.push({index:r[u],componentDatatype:l,componentsPerAttribute:f.componentsPerAttribute,normalize:f.normalize,values:c}),delete o[u]}return i}function S(e,r,t,o,a,s,u,l,c){var h=f.computeNumberOfVertices(r);i(u[e])||(u[e]={boundingSphere:r.boundingSphere,boundingSphereCV:r.boundingSphereCV});for(var d=o.length,w=0;d>w;++w)for(var E=o[w],m=a[E],p=h;p>0;){for(var T,y=n(c[E],0),R=s[y],A=R.length,v=0;A>v&&(T=R[v],T.index!==m);++v);i(u[e][E])||(u[e][E]={dirty:!1,valid:!0,value:t[E].value,indices:[]});var _,S=T.values.length/T.componentsPerAttribute,g=n(l[E],0);S>g+p?(_=p,u[e][E].indices.push({attribute:T,offset:g,count:_}),l[E]=g+p):(_=S-g,u[e][E].indices.push({attribute:T,offset:g,count:_}),l[E]=0,c[E]=y+1),p-=_}}function g(e,r,t,n,o){var a,s,u,f=[],l=e.length,c={},h={};for(a=0;l>a;++a)s=e[a],u=s.attributes,i(s.geometry)&&S(a,s.geometry,u,o,n,t,f,c,h);for(a=0;l>a;++a)s=e[a],u=s.attributes,i(s.westHemisphereGeometry)&&S(a,s.westHemisphereGeometry,u,o,n,t,f,c,h);for(a=0;l>a;++a)s=e[a],u=s.attributes,i(s.eastHemisphereGeometry)&&S(a,s.eastHemisphereGeometry,u,o,n,t,f,c,h);for(l=r.length,a=0;l>a;++a){s=r[a],u=s.attributes;var d={};f.push(d);for(var w=o.length,E=0;w>E;++E){var m=o[E];d[m]={dirty:!1,valid:!1,value:u[m].value,indices:[]}}}return f}function C(e,r){var t=e.attributes;for(var n in t)if(t.hasOwnProperty(n)){var o=t[n];i(o)&&i(o.values)&&r.push(o.values.buffer)}i(e.indices)&&r.push(e.indices.buffer)}function N(e,r){for(var t=e.length,n=0;t>n;++n)C(e[n],r)}function I(e,r){for(var t=e.length,n=0;t>n;++n)for(var i=e[n],o=i.length,a=0;o>a;++a)r.push(i[a].values.buffer)}function O(r){for(var t=1,n=r.length,o=0;n>o;o++){var a=r[o];if(++t,i(a)){var s=a.attributes;t+=6+2*e.packedLength+(i(a.indices)?a.indices.length:0);for(var u in s)if(s.hasOwnProperty(u)&&i(s[u])){var f=s[u];t+=5+f.values.length}}}return t}function b(e,r){for(var t=e.length,n=new Uint32Array(e.length),i=0;t>i;++i)n[i]=e[i].toRgba();return r.push(n.buffer),n}function M(e){for(var t=e.length,n=new Array(t),i=0;t>i;i++)n[i]=r.fromRgba(e[i]);return n}function q(e){for(var r=e.length,t=1+17*r,n=0;r>n;n++){var o=e[n].attributes;for(var a in o)if(o.hasOwnProperty(a)&&i(o[a])){var s=o[a];t+=5+s.value.length}}return t}function L(e,r){var t=new Float64Array(q(e)),n={},o=[],a=e.length,s=0;t[s++]=a;for(var u=0;a>u;u++){var f=e[u];w.pack(f.modelMatrix,t,s),s+=w.packedLength;var l=f.attributes,c=[];for(var h in l)l.hasOwnProperty(h)&&i(l[h])&&(c.push(h),i(n[h])||(n[h]=o.length,o.push(h)));t[s++]=c.length;for(var d=0;d<c.length;d++){var E=c[d],m=l[E];t[s++]=n[E],t[s++]=m.componentDatatype,t[s++]=m.componentsPerAttribute,t[s++]=m.normalize,t[s++]=m.value.length,t.set(m.value,s),s+=m.value.length}}return r.push(t.buffer),{stringTable:o,packedData:t}}function F(e){for(var r=e.packedData,n=e.stringTable,i=new Array(r[0]),o=0,a=1;a<r.length;){var s=w.unpack(r,a);a+=w.packedLength;for(var u={},f=r[a++],l=0;f>l;l++){for(var c=n[r[a++]],h=r[a++],d=r[a++],E=0!==r[a++],m=r[a++],p=t.createTypedArray(h,m),T=0;m>T;T++)p[T]=r[a++];u[c]={componentDatatype:h,componentsPerAttribute:d,normalize:E,value:p}}i[o++]={attributes:u,modelMatrix:s}}return i}function P(r){for(var t=r.length,n=1+t,o=0;t>o;o++){var a=r[o];n+=2,n+=i(a.boundingSphere)?e.packedLength:0,n+=i(a.boundingSphereCV)?e.packedLength:0;for(var s in a)if(a.hasOwnProperty(s)&&i(a[s])&&"boundingSphere"!==s&&"boundingSphereCV"!==s){var u=a[s];n+=4+3*u.indices.length+u.value.length}}return n}function D(r,t){var n=new Float64Array(P(r)),o=[],a=[],s={},u=r.length,f=0;n[f++]=u;for(var l=0;u>l;l++){var c=r[l],h=c.boundingSphere,d=i(h);n[f++]=d?1:0,d&&(e.pack(h,n,f),f+=e.packedLength),h=c.boundingSphereCV,d=i(h),n[f++]=d?1:0,d&&(e.pack(h,n,f),f+=e.packedLength);var w=[];for(var E in c)c.hasOwnProperty(E)&&i(c[E])&&"boundingSphere"!==E&&"boundingSphereCV"!==E&&(w.push(E),i(s[E])||(s[E]=o.length,o.push(E)));n[f++]=w.length;for(var m=0;m<w.length;m++){var p=w[m],T=c[p];n[f++]=s[p],n[f++]=T.valid?1:0;var y=T.indices,R=y.length;n[f++]=R;for(var A=0;R>A;A++){var v=y[A];n[f++]=v.count,n[f++]=v.offset;var _=a.indexOf(v.attribute);-1===_&&(_=a.length,a.push(v.attribute)),n[f++]=_}n[f++]=T.value.length,n.set(T.value,f),f+=T.value.length}}return t.push(n.buffer),{stringTable:o,packedData:n,attributeTable:a}}function x(r,n){for(var i=r.stringTable,o=r.attributeTable,a=r.packedData,s=new Array(a[0]),u=0,f=1,l=a.length;l>f;){var c={},h=1===a[f++];h&&(c.boundingSphere=e.unpack(a,f),f+=e.packedLength),h=1===a[f++],h&&(c.boundingSphereCV=e.unpack(a,f),f+=e.packedLength);for(var d=a[f++],w=0;d>w;w++){for(var E=i[a[f++]],m=1===a[f++],p=a[f++],T=p>0?new Array(p):void 0,y=0;p>y;y++){var R={};R.count=a[f++],R.offset=a[f++],R.attribute=o[a[f++]],T[y]=R}for(var A=a[f++],v=m?t.createTypedArray(T[0].attribute.componentDatatype,A):new Array(A),_=0;A>_;_++)v[_]=a[f++];c[E]={dirty:!1,valid:m,indices:T,value:v}}s[u++]=c}return s}if(!s.supportsTypedArrays())return{};var U={};return U.combineGeometry=function(e){var r,t,n,o,a,s=e.instances,u=e.invalidInstances;if(s.length>0){r=v(e),t=h.createAttributeLocations(r[0]),o=y(s),n=[],a=r.length;for(var f=0;a>f;++f){var l=r[f];n.push(_(l,t,o))}}o=i(o)?o:y(u);var c=g(s,u,n,t,o);return{geometries:r,modelMatrix:e.modelMatrix,attributeLocations:t,vaAttributes:n,vaAttributeLocations:c,validInstancesIndices:e.validInstancesIndices,invalidInstancesIndices:e.invalidInstancesIndices}},U.packCreateGeometryResults=function(r,t){var n=new Float64Array(O(r)),o=[],a={},s=r.length,u=0;n[u++]=s;for(var f=0;s>f;f++){var l=r[f],c=i(l);if(n[u++]=c?1:0,c){n[u++]=l.primitiveType,n[u++]=l.geometryType;var h=i(l.boundingSphere)?1:0;n[u++]=h,h&&e.pack(l.boundingSphere,n,u),u+=e.packedLength;var d=i(l.boundingSphereCV)?1:0;n[u++]=d,d&&e.pack(l.boundingSphereCV,n,u),u+=e.packedLength;var w=l.attributes,E=[];for(var m in w)w.hasOwnProperty(m)&&i(w[m])&&(E.push(m),i(a[m])||(a[m]=o.length,o.push(m)));n[u++]=E.length;for(var p=0;p<E.length;p++){var T=E[p],y=w[T];n[u++]=a[T],n[u++]=y.componentDatatype,n[u++]=y.componentsPerAttribute,n[u++]=y.normalize?1:0,n[u++]=y.values.length,n.set(y.values,u),u+=y.values.length}var R=i(l.indices)?l.indices.length:0;n[u++]=R,R>0&&(n.set(l.indices,u),u+=R)}}return t.push(n.buffer),{stringTable:o,packedData:n}},U.unpackCreateGeometryResults=function(r){for(var n,i=r.stringTable,o=r.packedData,a=new Array(o[0]),s=0,u=1;u<o.length;){var h=1===o[u++];if(h){var w,E,m=o[u++],p=o[u++],T=1===o[u++];T&&(w=e.unpack(o,u)),u+=e.packedLength;var y=1===o[u++];y&&(E=e.unpack(o,u)),u+=e.packedLength;var R,A,v,_=new c,S=o[u++];for(n=0;S>n;n++){var g=i[o[u++]],C=o[u++];v=o[u++];var N=0!==o[u++];R=o[u++],A=t.createTypedArray(C,R);for(var I=0;R>I;I++)A[I]=o[u++];_[g]=new l({componentDatatype:C,componentsPerAttribute:v,normalize:N,values:A})}var O;if(R=o[u++],R>0){var b=A.length/v;for(O=d.createTypedArray(b,R),n=0;R>n;n++)O[n]=o[u++]}a[s++]=new f({primitiveType:m,geometryType:p,boundingSphere:w,indices:O,attributes:_})}else a[s++]=void 0}return a},U.packCombineGeometryParameters=function(e,r){for(var t=e.createGeometryResults,n=t.length,i=0;n>i;i++)r.push(t[i].packedData.buffer);var o;return e.allowPicking&&(o=b(e.pickIds,r)),{createGeometryResults:e.createGeometryResults,packedInstances:L(e.instances,r),packedPickIds:o,ellipsoid:e.ellipsoid,isGeographic:e.projection instanceof u,elementIndexUintSupported:e.elementIndexUintSupported,scene3DOnly:e.scene3DOnly,allowPicking:e.allowPicking,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:e.modelMatrix}},U.unpackCombineGeometryParameters=function(e){for(var r=F(e.packedInstances),t=e.allowPicking,n=t?M(e.packedPickIds):void 0,o=e.createGeometryResults,s=o.length,f=0,l=[],c=[],h=[],d=[],m=[],p=0;s>p;p++)for(var T=U.unpackCreateGeometryResults(o[p]),y=T.length,R=0;y>R;R++){var A=T[R],v=r[f];i(A)?(v.geometry=A,l.push(v),h.push(f),t&&m.push(n[f])):(c.push(v),d.push(f)),++f}var _=a.clone(e.ellipsoid),S=e.isGeographic?new u(_):new E(_);return{instances:l,invalidInstances:c,validInstancesIndices:h,invalidInstancesIndices:d,pickIds:m,ellipsoid:_,projection:S,elementIndexUintSupported:e.elementIndexUintSupported,scene3DOnly:e.scene3DOnly,allowPicking:e.allowPicking,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:w.clone(e.modelMatrix)}},U.packCombineGeometryResults=function(e,r){return i(e.geometries)&&(N(e.geometries,r),I(e.vaAttributes,r)),{geometries:e.geometries,attributeLocations:e.attributeLocations,vaAttributes:e.vaAttributes,packedVaAttributeLocations:D(e.vaAttributeLocations,r),modelMatrix:e.modelMatrix,validInstancesIndices:e.validInstancesIndices,invalidInstancesIndices:e.invalidInstancesIndices}},U.unpackCombineGeometryResults=function(e){return{geometries:e.geometries,attributeLocations:e.attributeLocations,vaAttributes:e.vaAttributes,perInstanceAttributeLocations:x(e.packedVaAttributeLocations,e.vaAttributes),modelMatrix:e.modelMatrix}},U}),define("Core/formatError",["./defined"],function(e){"use strict";var r=function(r){var t,n=r.name,i=r.message;t=e(n)&&e(i)?n+": "+i:r.toString();var o=r.stack;return e(o)&&(t+="\n"+o),t};return r}),define("Workers/createTaskProcessorWorker",["../Core/defaultValue","../Core/defined","../Core/formatError"],function(e,r,t){"use strict";var n=function(n){var i,o=[],a={id:void 0,result:void 0,error:void 0};return function(s){var u=s.data;o.length=0,a.id=u.id,a.error=void 0,a.result=void 0;try{a.result=n(u.parameters,o)}catch(f){f instanceof Error?a.error={name:f.name,message:f.message,stack:f.stack}:a.error=f}r(i)||(i=e(self.webkitPostMessage,self.postMessage)),u.canTransferArrayBuffer||(o.length=0);try{i(a,o)}catch(f){a.result=void 0,a.error="postMessage failed with error: "+t(f)+"\n  with responseMessage: "+JSON.stringify(a),i(a)}}};return n}),define("Workers/combineGeometry",["../Scene/PrimitivePipeline","./createTaskProcessorWorker"],function(e,r){"use strict";function t(r,t){var n=e.unpackCombineGeometryParameters(r),i=e.combineGeometry(n);return e.packCombineGeometryResults(i,t)}return r(t)})}();