/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2015 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
/**
 * @license almond 0.3.1 Copyright (c) 2011-2014, The Dojo Foundation All Rights Reserved.
 * Available via the MIT or new BSD license.
 * see: http://github.com/jrburke/almond for details
 */

/**
  @license
  when.js - https://github.com/cujojs/when

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries (http://cujojs.com/)
 *
 * Licensed under the MIT License at:
 * http://www.opensource.org/licenses/mit-license.php
 *
 * @version 1.7.1
 */

/**
@license
mersenne-twister.js - https://gist.github.com/banksean/300494

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
 * @license
 *
 * Grauw URI utilities
 *
 * See: http://hg.grauw.nl/grauw-lib/file/tip/src/uri.js
 *
 * @author Laurens Holst (http://www.grauw.nl/)
 *
 *   Copyright 2012 Laurens Holst
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

/**
@license
sprintf.js from the php.js project - https://github.com/kvz/phpjs
Directly from https://github.com/kvz/phpjs/blob/master/functions/strings/sprintf.js

php.js is copyright 2012 Kevin van Zonneveld.

Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
(http://kevin.vanzonneveld.net), Onno Marsman, Theriault, Michael White
(http://getsprink.com), Waldo Malqui Silva, Paulo Freitas, Jack, Jonas
Raoni Soares Silva (http://www.jsfromhell.com), Philip Peterson, Legaev
Andrey, Ates Goral (http://magnetiq.com), Alex, Ratheous, Martijn Wieringa,
Rafa? Kukawski (http://blog.kukawski.pl), lmeyrick
(https://sourceforge.net/projects/bcmath-js/), Nate, Philippe Baumann,
Enrique Gonzalez, Webtoolkit.info (http://www.webtoolkit.info/), Carlos R.
L. Rodrigues (http://www.jsfromhell.com), Ash Searle
(http://hexmen.com/blog/), Jani Hartikainen, travc, Ole Vrijenhoek,
Erkekjetter, Michael Grier, Rafa? Kukawski (http://kukawski.pl), Johnny
Mast (http://www.phpvrouwen.nl), T.Wild, d3x,
http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
Rafa? Kukawski (http://blog.kukawski.pl/), stag019, pilus, WebDevHobo
(http://webdevhobo.blogspot.com/), marrtins, GeekFG
(http://geekfg.blogspot.com), Andrea Giammarchi
(http://webreflection.blogspot.com), Arpad Ray (mailto:arpad@php.net),
gorthaur, Paul Smith, Tim de Koning (http://www.kingsquare.nl), Joris, Oleg
Eremeev, Steve Hilder, majak, gettimeofday, KELAN, Josh Fraser
(http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
Marc Palau, Martin
(http://www.erlenwiese.de/), Breaking Par Consulting Inc
(http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
Chris, Mirek Slugen, saulius, Alfonso Jimenez
(http://www.alfonsojimenez.com), Diplom@t (http://difane.com/), felix,
Mailfaker (http://www.weedem.fr/), Tyler Akins (http://rumkin.com), Caio
Ariede (http://caioariede.com), Robin, Kankrelune
(http://www.webfaktory.info/), Karol Kowalski, Imgen Tata
(http://www.myipdf.com/), mdsjack (http://www.mdsjack.bo.it), Dreamer,
Felix Geisendoerfer (http://www.debuggable.com/felix), Lars Fischer, AJ,
David, Aman Gupta, Michael White, Public Domain
(http://www.json.org/json2.js), Steven Levithan
(http://blog.stevenlevithan.com), Sakimori, Pellentesque Malesuada,
Thunder.m, Dj (http://phpjs.org/functions/htmlentities:425#comment_134018),
Steve Clay, David James, Francois, class_exists, nobbler, T. Wild, Itsacon
(http://www.itsacon.net/), date, Ole Vrijenhoek (http://www.nervous.nl/),
Fox, Raphael (Ao RUDLER), Marco, noname, Mateusz "loonquawl" Zalega, Frank
Forte, Arno, ger, mktime, john (http://www.jd-tech.net), Nick Kolosov
(http://sammy.ru), marc andreu, Scott Cariss, Douglas Crockford
(http://javascript.crockford.com), madipta, Slawomir Kaniecki,
ReverseSyntax, Nathan, Alex Wilson, kenneth, Bayron Guevara, Adam Wallner
(http://web2.bitbaro.hu/), paulo kuong, jmweb, Lincoln Ramsay, djmix,
Pyerre, Jon Hohle, Thiago Mata (http://thiagomata.blog.com), lmeyrick
(https://sourceforge.net/projects/bcmath-js/this.), Linuxworld, duncan,
Gilbert, Sanjoy Roy, Shingo, sankai, Oskar Larsson H?gfeldt
(http://oskar-lh.name/), Denny Wardhana, 0m3r, Everlasto, Subhasis Deb,
josh, jd, Pier Paolo Ramon (http://www.mastersoup.com/), P, merabi, Soren
Hansen, Eugene Bulkin (http://doubleaw.com/), Der Simon
(http://innerdom.sourceforge.net/), echo is bad, Ozh, XoraX
(http://www.xorax.info), EdorFaus, JB, J A R, Marc Jansen, Francesco, LH,
Stoyan Kyosev (http://www.svest.org/), nord_ua, omid
(http://phpjs.org/functions/380:380#comment_137122), Brad Touesnard, MeEtc
(http://yass.meetcweb.com), Peter-Paul Koch
(http://www.quirksmode.org/js/beat.html), Olivier Louvignes
(http://mg-crea.com/), T0bsn, Tim Wiel, Bryan Elliott, Jalal Berrami,
Martin, JT, David Randall, Thomas Beaucourt (http://www.webapp.fr), taith,
vlado houba, Pierre-Luc Paour, Kristof Coomans (SCK-CEN Belgian Nucleair
Research Centre), Martin Pool, Kirk Strobeck, Rick Waldron, Brant Messenger
(http://www.brantmessenger.com/), Devan Penner-Woelk, Saulo Vallory, Wagner
B. Soares, Artur Tchernychev, Valentina De Rosa, Jason Wong
(http://carrot.org/), Christoph, Daniel Esteban, strftime, Mick@el, rezna,
Simon Willison (http://simonwillison.net), Anton Ongson, Gabriel Paderni,
Marco van Oort, penutbutterjelly, Philipp Lenssen, Bjorn Roesbeke
(http://www.bjornroesbeke.be/), Bug?, Eric Nagel, Tomasz Wesolowski,
Evertjan Garretsen, Bobby Drake, Blues (http://tech.bluesmoon.info/), Luke
Godfrey, Pul, uestla, Alan C, Ulrich, Rafal Kukawski, Yves Sucaet,
sowberry, Norman "zEh" Fuchs, hitwork, Zahlii, johnrembo, Nick Callen,
Steven Levithan (stevenlevithan.com), ejsanders, Scott Baker, Brian Tafoya
(http://www.premasolutions.com/), Philippe Jausions
(http://pear.php.net/user/jausions), Aidan Lister
(http://aidanlister.com/), Rob, e-mike, HKM, ChaosNo1, metjay, strcasecmp,
strcmp, Taras Bogach, jpfle, Alexander Ermolaev
(http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, kilops, Orlando,
dptr1988, Le Torbi, James (http://www.james-bell.co.uk/), Pedro Tainha
(http://www.pedrotainha.com), James, Arnout Kazemier
(http://www.3rd-Eden.com), Chris McMacken, gabriel paderni, Yannoo,
FGFEmperor, baris ozdil, Tod Gentille, Greg Frazier, jakes, 3D-GRAF, Allan
Jensen (http://www.winternet.no), Howard Yeend, Benjamin Lupton, davook,
daniel airton wermann (http://wermann.com.br), Atli T¨®r, Maximusya, Ryan
W Tenney (http://ryan.10e.us), Alexander M Beedie, fearphage
(http://http/my.opera.com/fearphage/), Nathan Sepulveda, Victor, Matteo,
Billy, stensi, Cord, Manish, T.J. Leahy, Riddler
(http://www.frontierwebdev.com/), Rafa? Kukawski, FremyCompany, Matt
Bradley, Tim de Koning, Luis Salazar (http://www.freaky-media.com/), Diogo
Resende, Rival, Andrej Pavlovic, Garagoth, Le Torbi
(http://www.letorbi.de/), Dino, Josep Sanz (http://www.ws3.es/), rem,
Russell Walker (http://www.nbill.co.uk/), Jamie Beck
(http://www.terabit.ca/), setcookie, Michael, YUI Library:
http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html, Blues at
http://hacks.bluesmoon.info/strftime/strftime.js, Ben
(http://benblume.co.uk/), DtTvB
(http://dt.in.th/2008-09-16.string-length-in-bytes.html), Andreas, William,
meo, incidence, Cagri Ekin, Amirouche, Amir Habibi
(http://www.residence-mixte.com/), Luke Smith (http://lucassmith.name),
Kheang Hok Chin (http://www.distantia.ca/), Jay Klehr, Lorenzo Pisani,
Tony, Yen-Wei Liu, Greenseed, mk.keck, Leslie Hoare, dude, booeyOH, Ben
Bryan

Licensed under the MIT (MIT-LICENSE.txt) license.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/

// Copyright 2012 Google Inc., Apache 2.0 license.

/**
@license
tween.js - https://github.com/sole/tween.js

Copyright (c) 2010-2012 Tween.js authors.

Easing equations Copyright (c) 2001 Robert Penner http://robertpenner.com/easing/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

/**
  @license
  fontmetrics.js - https://github.com/Pomax/fontmetrics.js

  Copyright (C) 2011 by Mike "Pomax" Kamermans

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
**/

/**
@license
topojson - https://github.com/mbostock/topojson

Copyright (c) 2012, Michael Bostock
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

* The name Michael Bostock may not be used to endorse or promote products
  derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL MICHAEL BOSTOCK BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*!
 * Autolinker.js
 * 0.17.1
 *
 * Copyright(c) 2015 Gregory Jacobs <greg@greg-jacobs.com>
 * MIT Licensed. http://www.opensource.org/licenses/mit-license.php
 *
 * https://github.com/gregjacobs/Autolinker.js
 */

/**
@license
 Copyright (c) 2013 Gildas Lormeau. All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
 this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in
 the documentation and/or other materials provided with the distribution.

 3. The names of the authors may not be used to endorse or promote products
 derived from this software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JCRAFT,
 INC. OR ANY CONTRIBUTORS TO THIS SOFTWARE BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**/

/**
 * @license
 * Copyright (c) 2011 NVIDIA Corporation. All rights reserved.
 *
 * TO  THE MAXIMUM  EXTENT PERMITTED  BY APPLICABLE  LAW, THIS SOFTWARE  IS PROVIDED
 * *AS IS*  AND NVIDIA AND  ITS SUPPLIERS DISCLAIM  ALL WARRANTIES,  EITHER  EXPRESS
 * OR IMPLIED, INCLUDING, BUT NOT LIMITED  TO, NONINFRINGEMENT,IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT SHALL  NVIDIA 
 * OR ITS SUPPLIERS BE  LIABLE  FOR  ANY  DIRECT, SPECIAL,  INCIDENTAL,  INDIRECT,  OR  
 * CONSEQUENTIAL DAMAGES WHATSOEVER (INCLUDING, WITHOUT LIMITATION,  DAMAGES FOR LOSS 
 * OF BUSINESS PROFITS, BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR ANY 
 * OTHER PECUNIARY LOSS) ARISING OUT OF THE  USE OF OR INABILITY  TO USE THIS SOFTWARE, 
 * EVEN IF NVIDIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */

/**
 * @license
 * Copyright (c) 2000-2005, Sean O'Neil (s_p_oneil@hotmail.com)
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * * Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 * * Neither the name of the project nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Modifications made by Analytical Graphics, Inc.
 */

/**
 * @license
 * Knockout JavaScript library v3.2.0
 * (c) Steven Sanderson - http://knockoutjs.com/
 * License: MIT (http://www.opensource.org/licenses/mit-license.php)
 */

/**
 * @license
 * Knockout ES5 plugin - https://github.com/SteveSanderson/knockout-es5
 * Copyright (c) Steve Sanderson
 * MIT license
 */

!function(){var e,t,r;!function(i){function n(e,t){return w.call(e,t)}function o(e,t){var r,i,n,o,a,s,u,l,c,h,d,m=t&&t.split("/"),p=_.map,f=p&&p["*"]||{};if(e&&"."===e.charAt(0))if(t){for(e=e.split("/"),a=e.length-1,_.nodeIdCompat&&E.test(e[a])&&(e[a]=e[a].replace(E,"")),e=m.slice(0,m.length-1).concat(e),c=0;c<e.length;c+=1)if(d=e[c],"."===d)e.splice(c,1),c-=1;else if(".."===d){if(1===c&&(".."===e[2]||".."===e[0]))break;c>0&&(e.splice(c-1,2),c-=2)}e=e.join("/")}else 0===e.indexOf("./")&&(e=e.substring(2));if((m||f)&&p){for(r=e.split("/"),c=r.length;c>0;c-=1){if(i=r.slice(0,c).join("/"),m)for(h=m.length;h>0;h-=1)if(n=p[m.slice(0,h).join("/")],n&&(n=n[i])){o=n,s=c;break}if(o)break;!u&&f&&f[i]&&(u=f[i],l=c)}!o&&u&&(o=u,s=l),o&&(r.splice(0,s,o),e=r.join("/"))}return e}function a(e,t){return function(){var r=C.call(arguments,0);return"string"!=typeof r[0]&&1===r.length&&r.push(null),m.apply(i,r.concat([e,t]))}}function s(e){return function(t){return o(t,e)}}function u(e){return function(t){v[e]=t}}function l(e){if(n(g,e)){var t=g[e];delete g[e],y[e]=!0,d.apply(i,t)}if(!n(v,e)&&!n(y,e))throw new Error("No "+e);return v[e]}function c(e){var t,r=e?e.indexOf("!"):-1;return r>-1&&(t=e.substring(0,r),e=e.substring(r+1,e.length)),[t,e]}function h(e){return function(){return _&&_.config&&_.config[e]||{}}}var d,m,p,f,v={},g={},_={},y={},w=Object.prototype.hasOwnProperty,C=[].slice,E=/\.js$/;p=function(e,t){var r,i=c(e),n=i[0];return e=i[1],n&&(n=o(n,t),r=l(n)),n?e=r&&r.normalize?r.normalize(e,s(t)):o(e,t):(e=o(e,t),i=c(e),n=i[0],e=i[1],n&&(r=l(n))),{f:n?n+"!"+e:e,n:e,pr:n,p:r}},f={require:function(e){return a(e)},exports:function(e){var t=v[e];return"undefined"!=typeof t?t:v[e]={}},module:function(e){return{id:e,uri:"",exports:v[e],config:h(e)}}},d=function(e,t,r,o){var s,c,h,d,m,_,w=[],C=typeof r;if(o=o||e,"undefined"===C||"function"===C){for(t=!t.length&&r.length?["require","exports","module"]:t,m=0;m<t.length;m+=1)if(d=p(t[m],o),c=d.f,"require"===c)w[m]=f.require(e);else if("exports"===c)w[m]=f.exports(e),_=!0;else if("module"===c)s=w[m]=f.module(e);else if(n(v,c)||n(g,c)||n(y,c))w[m]=l(c);else{if(!d.p)throw new Error(e+" missing "+c);d.p.load(d.n,a(o,!0),u(c),{}),w[m]=v[c]}h=r?r.apply(v[e],w):void 0,e&&(s&&s.exports!==i&&s.exports!==v[e]?v[e]=s.exports:h===i&&_||(v[e]=h))}else e&&(v[e]=r)},e=t=m=function(e,t,r,n,o){if("string"==typeof e)return f[e]?f[e](t):l(p(e,t).f);if(!e.splice){if(_=e,_.deps&&m(_.deps,_.callback),!t)return;t.splice?(e=t,t=r,r=null):e=i}return t=t||function(){},"function"==typeof r&&(r=n,n=o),n?d(i,e,t,r):setTimeout(function(){d(i,e,t,r)},4),m},m.config=function(e){return m(e)},e._defined=v,r=function(e,t,r){if("string"!=typeof e)throw new Error("See almond README: incorrect module build, no module name");t.splice||(r=t,t=[]),n(v,e)||n(g,e)||(g[e]=[e,t,r])},r.amd={jQuery:!0}}(),r("Core/appendForwardSlash",[],function(){"use strict";var e=function(e){return(0===e.length||"/"!==e[e.length-1])&&(e+="/"),e};return e}),function(e){"use strict";e("ThirdParty/when",[],function(){function e(e,r,i,n){return t(e).then(r,i,n)}function t(e){var t,r;return e instanceof i?t=e:s(e)?(r=a(),e.then(function(e){r.resolve(e)},function(e){r.reject(e)},function(e){r.progress(e)}),t=r.promise):t=n(e),t}function r(t){return e(t,o)}function i(e){this.then=e}function n(e){var r=new i(function(r){try{return t(r?r(e):e)}catch(i){return o(i)}});return r}function o(e){var r=new i(function(r,i){try{return i?t(i(e)):o(e)}catch(n){return o(n)}});return r}function a(){function e(e,t,r){return d(e,t,r)}function r(e){return p(e)}function n(e){return p(o(e))}function s(e){return m(e)}var u,l,c,h,d,m,p;return l=new i(e),u={then:e,resolve:r,reject:n,progress:s,promise:l,resolver:{resolve:r,reject:n,progress:s}},c=[],h=[],d=function(e,t,r){var i,n;return i=a(),n="function"==typeof r?function(e){try{i.progress(r(e))}catch(t){i.progress(t)}}:function(e){i.progress(e)},c.push(function(r){r.then(e,t).then(i.resolve,i.reject,n)}),h.push(n),i.promise},m=function(e){return f(h,e),e},p=function(e){return e=t(e),d=e.then,p=t,m=g,f(c,e),h=c=C,e},u}function s(e){return e&&"function"==typeof e.then}function u(t,r,i,n,o){return v(2,arguments),e(t,function(t){function s(e){f(e)}function u(e){p(e)}var l,c,h,d,m,p,f,v,_,y;if(_=t.length>>>0,l=Math.max(0,Math.min(r,_)),h=[],c=_-l+1,d=[],m=a(),l)for(v=m.progress,f=function(e){d.push(e),--c||(p=f=g,m.reject(d))},p=function(e){h.push(e),--l||(p=f=g,m.resolve(h))},y=0;_>y;++y)y in t&&e(t[y],u,s,v);else m.resolve(h);return m.then(i,n,o)})}function l(e,t,r,i){function n(e){return t?t(e[0]):e[0]}return u(e,1,n,r,i)}function c(e,t,r,i){return v(1,arguments),d(e,_).then(t,r,i)}function h(){return d(arguments,_)}function d(t,r){return e(t,function(t){var i,n,o,s,u,l;if(o=n=t.length>>>0,i=[],l=a(),o)for(s=function(t,n){e(t,r).then(function(e){i[n]=e,--o||l.resolve(i)},l.reject)},u=0;n>u;u++)u in t?s(t[u],u):--o;else l.resolve(i);return l.promise})}function m(t,r){var i=w.call(arguments,1);return e(t,function(t){var n;return n=t.length,i[0]=function(t,i,o){return e(t,function(t){return e(i,function(e){return r(t,e,o,n)})})},y.apply(t,i)})}function p(t,r,i){var n=arguments.length>2;return e(t,function(e){return e=n?i:e,r.resolve(e),e},function(e){return r.reject(e),o(e)},r.progress)}function f(e,t){for(var r,i=0;r=e[i++];)r(t)}function v(e,t){for(var r,i=t.length;i>e;)if(r=t[--i],null!=r&&"function"!=typeof r)throw new Error("arg "+i+" must be a function")}function g(){}function _(e){return e}var y,w,C;return e.defer=a,e.resolve=t,e.reject=r,e.join=h,e.all=c,e.map=d,e.reduce=m,e.any=l,e.some=u,e.chain=p,e.isPromise=s,i.prototype={always:function(e,t){return this.then(e,e,t)},otherwise:function(e){return this.then(C,e)},"yield":function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(t){return c(t,function(t){return e.apply(C,t)})})}},w=[].slice,y=[].reduce||function(e){var t,r,i,n,o;if(o=0,t=Object(this),n=t.length>>>0,r=arguments,r.length<=1)for(;;){if(o in t){i=t[o++];break}if(++o>=n)throw new TypeError}else i=r[1];for(;n>o;++o)o in t&&(i=e(i,t[o],o,t));return i},e})}("function"==typeof r&&r.amd?r:function(e){"object"==typeof exports?module.exports=e():this.when=e()}),r("Core/defined",[],function(){"use strict";var e=function(e){return void 0!==e};return e}),r("Core/defineProperties",["./defined"],function(e){"use strict";var t=function(){try{return"x"in Object.defineProperty({},"x",{})}catch(e){return!1}}(),r=Object.defineProperties;return t&&e(r)||(r=function(e){return e}),r}),r("Core/DeveloperError",["./defined"],function(e){"use strict";var t=function(e){this.name="DeveloperError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t.throwInstantiationError=function(){throw new t("This function defines an interface and should not be called directly.")},t}),r("Core/Credit",["./defined","./defineProperties","./DeveloperError"],function(e,t,r){"use strict";var i=0,n={},o=function(t,o,a){var s=e(a),u=e(o),l=e(t);if(!l&&!u&&!s)throw new r("text, imageUrl or link is required");l||u||(t=a),this._text=t,this._imageUrl=o,this._link=a,this._hasLink=s,this._hasImage=u;var c,h=JSON.stringify([t,o,a]);e(n[h])?c=n[h]:(c=i++,n[h]=c),this._id=c};return t(o.prototype,{text:{get:function(){return this._text}},imageUrl:{get:function(){return this._imageUrl}},link:{get:function(){return this._link}},id:{get:function(){return this._id}}}),o.prototype.hasImage=function(){return this._hasImage},o.prototype.hasLink=function(){return this._hasLink},o.equals=function(t,r){return t===r||e(t)&&e(r)&&t._id===r._id},o.prototype.equals=function(e){return o.equals(this,e)},o}),r("Core/freezeObject",["./defined"],function(e){"use strict";var t=Object.freeze;return e(t)||(t=function(e){return e}),t}),r("Core/defaultValue",["./freezeObject"],function(e){"use strict";var t=function(e,t){return void 0!==e?e:t};return t.EMPTY_OBJECT=e({}),t}),r("ThirdParty/mersenne-twister",[],function(){var e=function(e){void 0==e&&(e=(new Date).getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)};return e.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(1812433253*((4294901760&e)>>>16)<<16)+1812433253*(65535&e)+this.mti,this.mt[this.mti]>>>=0}},e.prototype.genrand_int32=function(){var e,t=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var r;for(this.mti==this.N+1&&this.init_genrand(5489),r=0;r<this.N-this.M;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+this.M]^e>>>1^t[1&e];for(;r<this.N-1;r++)e=this.mt[r]&this.UPPER_MASK|this.mt[r+1]&this.LOWER_MASK,this.mt[r]=this.mt[r+(this.M-this.N)]^e>>>1^t[1&e];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^t[1&e],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0},e.prototype.random=function(){return this.genrand_int32()*(1/4294967296)},e}),r("Core/Math",["../ThirdParty/mersenne-twister","./defaultValue","./defined","./DeveloperError"],function(e,t,r,i){"use strict";var n={};n.EPSILON1=.1,n.EPSILON2=.01,n.EPSILON3=.001,n.EPSILON4=1e-4,n.EPSILON5=1e-5,n.EPSILON6=1e-6,n.EPSILON7=1e-7,n.EPSILON8=1e-8,n.EPSILON9=1e-9,n.EPSILON10=1e-10,n.EPSILON11=1e-11,n.EPSILON12=1e-12,n.EPSILON13=1e-13,n.EPSILON14=1e-14,n.EPSILON15=1e-15,n.EPSILON16=1e-16,n.EPSILON17=1e-17,n.EPSILON18=1e-18,n.EPSILON19=1e-19,n.EPSILON20=1e-20,n.GRAVITATIONALPARAMETER=3986004418e5,n.SOLAR_RADIUS=6955e5,n.LUNAR_RADIUS=1737400,n.SIXTY_FOUR_KILOBYTES=65536,n.sign=function(e){return e>0?1:0>e?-1:0},n.signNotZero=function(e){return 0>e?-1:1},n.toSNorm=function(e){return Math.round(255*(.5*n.clamp(e,-1,1)+.5))},n.fromSNorm=function(e){return n.clamp(e,0,255)/255*2-1},n.sinh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t-r)},n.cosh=function(e){var t=Math.pow(Math.E,e),r=Math.pow(Math.E,-1*e);return.5*(t+r)},n.lerp=function(e,t,r){return(1-r)*e+r*t},n.PI=Math.PI,n.ONE_OVER_PI=1/Math.PI,n.PI_OVER_TWO=.5*Math.PI,n.PI_OVER_THREE=Math.PI/3,n.PI_OVER_FOUR=Math.PI/4,n.PI_OVER_SIX=Math.PI/6,n.THREE_PI_OVER_TWO=3*Math.PI*.5,n.TWO_PI=2*Math.PI,n.ONE_OVER_TWO_PI=1/(2*Math.PI),n.RADIANS_PER_DEGREE=Math.PI/180,n.DEGREES_PER_RADIAN=180/Math.PI,n.RADIANS_PER_ARCSECOND=n.RADIANS_PER_DEGREE/3600,n.toRadians=function(e){if(!r(e))throw new i("degrees is required.");return e*n.RADIANS_PER_DEGREE},n.toDegrees=function(e){if(!r(e))throw new i("radians is required.");return e*n.DEGREES_PER_RADIAN},n.convertLongitudeRange=function(e){if(!r(e))throw new i("angle is required.");var t=n.TWO_PI,o=e-Math.floor(e/t)*t;return o<-Math.PI?o+t:o>=Math.PI?o-t:o},n.negativePiToPi=function(e){if(!r(e))throw new i("x is required.");return n.zeroToTwoPi(e+n.PI)-n.PI},n.zeroToTwoPi=function(e){if(!r(e))throw new i("x is required.");var t=n.mod(e,n.TWO_PI);return Math.abs(t)<n.EPSILON14&&Math.abs(e)>n.EPSILON14?n.TWO_PI:t},n.mod=function(e,t){if(!r(e))throw new i("m is required.");if(!r(t))throw new i("n is required.");return(e%t+t)%t},n.equalsEpsilon=function(e,n,o,a){if(!r(e))throw new i("left is required.");if(!r(n))throw new i("right is required.");if(!r(o))throw new i("relativeEpsilon is required.");a=t(a,o);var s=Math.abs(e-n);return a>=s||s<=o*Math.max(Math.abs(e),Math.abs(n))};var o=[1];n.factorial=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");var t=o.length;if(e>=t)for(var r=o[t-1],n=t;e>=n;n++)o.push(r*n);return o[e]},n.incrementWrap=function(e,n,o){if(o=t(o,0),!r(e))throw new i("n is required.");if(o>=n)throw new i("maximumValue must be greater than minimumValue.");return++e,e>n&&(e=o),e},n.isPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");return 0!==e&&0===(e&e-1)},n.nextPowerOfTwo=function(e){if("number"!=typeof e||0>e)throw new i("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e},n.clamp=function(e,t,n){if(!r(e))throw new i("value is required");if(!r(t))throw new i("min is required.");if(!r(n))throw new i("max is required.");return t>e?t:e>n?n:e};var a=new e;return n.setRandomNumberSeed=function(t){if(!r(t))throw new i("seed is required.");a=new e(t)},n.nextRandomNumber=function(){return a.random()},n.acosClamped=function(e){if(!r(e))throw new i("value is required.");return Math.acos(n.clamp(e,-1,1))},n.asinClamped=function(e){if(!r(e))throw new i("value is required.");return Math.asin(n.clamp(e,-1,1))},n.chordLength=function(e,t){if(!r(e))throw new i("angle is required.");if(!r(t))throw new i("radius is required.");return 2*t*Math.sin(.5*e)},n}),r("Core/Cartesian3",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,i,n){"use strict";var o=function(t,r,i){this.x=e(t,0),this.y=e(r,0),this.z=e(i,0)};o.fromSpherical=function(i,n){if(!t(i))throw new r("spherical is required");t(n)||(n=new o);var a=i.clock,s=i.cone,u=e(i.magnitude,1),l=u*Math.sin(s);return n.x=l*Math.cos(a),n.y=l*Math.sin(a),n.z=u*Math.cos(s),n},o.fromElements=function(e,r,i,n){return t(n)?(n.x=e,n.y=r,n.z=i,n):new o(e,r,i)},o.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r):new o(e.x,e.y,e.z):void 0},o.fromCartesian4=o.clone,o.packedLength=3,o.pack=function(i,n,o){if(!t(i))throw new r("value is required");if(!t(n))throw new r("array is required");o=e(o,0),n[o++]=i.x,n[o++]=i.y,n[o]=i.z},o.unpack=function(i,n,a){if(!t(i))throw new r("array is required");return n=e(n,0),t(a)||(a=new o),a.x=i[n++],a.y=i[n++],a.z=i[n],a},o.fromArray=o.unpack,o.maximumComponent=function(e){if(!t(e))throw new r("cartesian is required");return Math.max(e.x,e.y,e.z)},o.minimumComponent=function(e){if(!t(e))throw new r("cartesian is required");return Math.min(e.x,e.y,e.z)},o.minimumByComponent=function(e,i,n){if(!t(e))throw new r("first is required.");if(!t(i))throw new r("second is required.");if(!t(n))throw new r("result is required.");return n.x=Math.min(e.x,i.x),n.y=Math.min(e.y,i.y),n.z=Math.min(e.z,i.z),n},o.maximumByComponent=function(e,i,n){if(!t(e))throw new r("first is required.");if(!t(i))throw new r("second is required.");if(!t(n))throw new r("result is required.");return n.x=Math.max(e.x,i.x),n.y=Math.max(e.y,i.y),n.z=Math.max(e.z,i.z),n},o.magnitudeSquared=function(e){if(!t(e))throw new r("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,i){if(!t(e)||!t(i))throw new r("left and right are required.");return o.subtract(e,i,a),o.magnitude(a)},o.distanceSquared=function(e,i){if(!t(e)||!t(i))throw new r("left and right are required.");return o.subtract(e,i,a),o.magnitudeSquared(a)},o.normalize=function(e,i){if(!t(e))throw new r("cartesian is required");if(!t(i))throw new r("result is required");var n=o.magnitude(e);return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i},o.dot=function(e,i){if(!t(e))throw new r("left is required");if(!t(i))throw new r("right is required");return e.x*i.x+e.y*i.y+e.z*i.z},o.multiplyComponents=function(e,i,n){if(!t(e))throw new r("left is required");if(!t(i))throw new r("right is required");if(!t(n))throw new r("result is required");return n.x=e.x*i.x,n.y=e.y*i.y,n.z=e.z*i.z,n},o.add=function(e,i,n){if(!t(e))throw new r("left is required");if(!t(i))throw new r("right is required");if(!t(n))throw new r("result is required");return n.x=e.x+i.x,n.y=e.y+i.y,n.z=e.z+i.z,n},o.subtract=function(e,i,n){if(!t(e))throw new r("left is required");if(!t(i))throw new r("right is required");if(!t(n))throw new r("result is required");return n.x=e.x-i.x,n.y=e.y-i.y,n.z=e.z-i.z,n},o.multiplyByScalar=function(e,i,n){if(!t(e))throw new r("cartesian is required");if("number"!=typeof i)throw new r("scalar is required and must be a number.");if(!t(n))throw new r("result is required");return n.x=e.x*i,n.y=e.y*i,n.z=e.z*i,n},o.divideByScalar=function(e,i,n){if(!t(e))throw new r("cartesian is required");if("number"!=typeof i)throw new r("scalar is required and must be a number.");if(!t(n))throw new r("result is required");return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n},o.negate=function(e,i){if(!t(e))throw new r("cartesian is required");if(!t(i))throw new r("result is required");return i.x=-e.x,i.y=-e.y,i.z=-e.z,i},o.abs=function(e,i){if(!t(e))throw new r("cartesian is required");if(!t(i))throw new r("result is required");return i.x=Math.abs(e.x),i.y=Math.abs(e.y),i.z=Math.abs(e.z),i};var s=new o;o.lerp=function(e,i,n,a){if(!t(e))throw new r("start is required.");if(!t(i))throw new r("end is required.");if("number"!=typeof n)throw new r("t is required and must be a number.");if(!t(a))throw new r("result is required.");return o.multiplyByScalar(i,n,s),a=o.multiplyByScalar(e,1-n,a),o.add(s,a,a)};var u=new o,l=new o;o.angleBetween=function(e,i){if(!t(e))throw new r("left is required");if(!t(i))throw new r("right is required");o.normalize(e,u),o.normalize(i,l);var n=o.dot(u,l),a=o.magnitude(o.cross(u,l,u));return Math.atan2(a,n)};var c=new o;o.mostOrthogonalAxis=function(e,i){if(!t(e))throw new r("cartesian is required.");if(!t(i))throw new r("result is required.");var n=o.normalize(e,c);return o.abs(n,n),i=n.x<=n.y?n.x<=n.z?o.clone(o.UNIT_X,i):o.clone(o.UNIT_Z,i):n.y<=n.z?o.clone(o.UNIT_Y,i):o.clone(o.UNIT_Z,i)},o.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]},o.equalsEpsilon=function(e,r,i,o){return e===r||t(e)&&t(r)&&n.equalsEpsilon(e.x,r.x,i,o)&&n.equalsEpsilon(e.y,r.y,i,o)&&n.equalsEpsilon(e.z,r.z,i,o)},o.cross=function(e,i,n){if(!t(e))throw new r("left is required");if(!t(i))throw new r("right is required");if(!t(n))throw new r("result is required");var o=e.x,a=e.y,s=e.z,u=i.x,l=i.y,c=i.z,h=a*c-s*l,d=s*u-o*c,m=o*l-a*u;return n.x=h,n.y=d,n.z=m,n},o.fromDegrees=function(e,i,a,s,u){if(!t(e))throw new r("longitude is required");if(!t(i))throw new r("latitude is required");var l=n.toRadians(e),c=n.toRadians(i);return o.fromRadians(l,c,a,s,u)};var h=new o,d=new o,m=new o(40680631590769,40680631590769,40408299984661.445);return o.fromRadians=function(i,n,a,s,u){if(!t(i))throw new r("longitude is required");if(!t(n))throw new r("latitude is required");a=e(a,0);var l=t(s)?s.radiiSquared:m,c=Math.cos(n);h.x=c*Math.cos(i),h.y=c*Math.sin(i),h.z=Math.sin(n),h=o.normalize(h,h),o.multiplyComponents(l,h,d);var p=Math.sqrt(o.dot(h,d));return d=o.divideByScalar(d,p,d),h=o.multiplyByScalar(h,a,h),t(u)||(u=new o),o.add(d,h,u)},o.fromDegreesArray=function(e,i,a){if(!t(e))throw new r("positions is required.");for(var s=new Array(e.length),u=0;u<e.length;u++)s[u]=n.toRadians(e[u]);return o.fromRadiansArray(s,i,a)},o.fromRadiansArray=function(e,i,n){if(!t(e))throw new r("positions is required.");if(e.length<2)throw new r("positions length cannot be less than 2.");if(e.length%2!==0)throw new r("positions length must be a multiple of 2.");var a=e.length;t(n)?n.length=a/2:n=new Array(a/2);for(var s=0;a>s;s+=2){var u=e[s],l=e[s+1];n[s/2]=o.fromRadians(u,l,0,i,n[s/2])}return n},o.fromDegreesArrayHeights=function(e,i,a){if(!t(e))throw new r("positions is required.");if(e.length<3)throw new r("positions length cannot be less than 3.");if(e.length%3!==0)throw new r("positions length must be a multiple of 3.");for(var s=new Array(e.length),u=0;u<e.length;u+=3)s[u]=n.toRadians(e[u]),s[u+1]=n.toRadians(e[u+1]),s[u+2]=e[u+2];return o.fromRadiansArrayHeights(s,i,a)},o.fromRadiansArrayHeights=function(e,i,n){if(!t(e))throw new r("positions is required.");if(e.length<3)throw new r("positions length cannot be less than 3.");if(e.length%3!==0)throw new r("positions length must be a multiple of 3.");var a=e.length;t(n)?n.length=a/3:n=new Array(a/3);for(var s=0;a>s;s+=3){var u=e[s],l=e[s+1],c=e[s+2];n[s/3]=o.fromRadians(u,l,c,i,n[s/3])}return n},o.ZERO=i(new o(0,0,0)),o.UNIT_X=i(new o(1,0,0)),o.UNIT_Y=i(new o(0,1,0)),o.UNIT_Z=i(new o(0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},o}),r("Core/Cartographic",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,i,n){"use strict";var o=function(t,r,i){this.longitude=e(t,0),this.latitude=e(r,0),this.height=e(i,0)};return o.fromRadians=function(i,n,a,s){if(!t(i))throw new r("longitude is required.");if(!t(n))throw new r("latitude is required.");return a=e(a,0),t(s)?(s.longitude=i,s.latitude=n,s.height=a,s):new o(i,n,a)},o.fromDegrees=function(e,i,a,s){if(!t(e))throw new r("longitude is required.");if(!t(i))throw new r("latitude is required.");return e=n.toRadians(e),i=n.toRadians(i),o.fromRadians(e,i,a,s)},o.clone=function(e,r){return t(e)?t(r)?(r.longitude=e.longitude,r.latitude=e.latitude,r.height=e.height,r):new o(e.longitude,e.latitude,e.height):void 0},o.equals=function(e,r){return e===r||t(e)&&t(r)&&e.longitude===r.longitude&&e.latitude===r.latitude&&e.height===r.height},o.equalsEpsilon=function(e,i,n){if("number"!=typeof n)throw new r("epsilon is required and must be a number.");return e===i||t(e)&&t(i)&&Math.abs(e.longitude-i.longitude)<=n&&Math.abs(e.latitude-i.latitude)<=n&&Math.abs(e.height-i.height)<=n},o.ZERO=i(new o(0,0,0)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t){return o.equalsEpsilon(this,e,t)},o.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"},o}),r("Core/Ellipsoid",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./Math"],function(e,t,r,i,n,o,a,s){"use strict";function u(t,i,n,a){if(i=r(i,0),n=r(n,0),a=r(a,0),0>i||0>n||0>a)throw new o("All radii components must be greater than or equal to zero.");t._radii=new e(i,n,a),t._radiiSquared=new e(i*i,n*n,a*a),t._radiiToTheFourth=new e(i*i*i*i,n*n*n*n,a*a*a*a),t._oneOverRadii=new e(0===i?0:1/i,0===n?0:1/n,0===a?0:1/a),t._oneOverRadiiSquared=new e(0===i?0:1/(i*i),0===n?0:1/(n*n),0===a?0:1/(a*a)),t._minimumRadius=Math.min(i,n,a),t._maximumRadius=Math.max(i,n,a),t._centerToleranceSquared=s.EPSILON1}var l=function(e,t,r){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,u(this,e,t,r)};n(l.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}}),l.clone=function(t,r){if(!i(t))return void 0;var n=t._radii;return i(r)?(e.clone(n,r._radii),e.clone(t._radiiSquared,r._radiiSquared),e.clone(t._radiiToTheFourth,r._radiiToTheFourth),e.clone(t._oneOverRadii,r._oneOverRadii),e.clone(t._oneOverRadiiSquared,r._oneOverRadiiSquared),r._minimumRadius=t._minimumRadius,r._maximumRadius=t._maximumRadius,r._centerToleranceSquared=t._centerToleranceSquared,r):new l(n.x,n.y,n.z)},l.fromCartesian3=function(e,t){return i(t)||(t=new l),i(e)?(u(t,e.x,e.y,e.z),t):t},l.WGS84=a(new l(6378137,6378137,6356752.314245179)),l.UNIT_SPHERE=a(new l(1,1,1)),l.MOON=a(new l(s.LUNAR_RADIUS,s.LUNAR_RADIUS,s.LUNAR_RADIUS)),l.prototype.clone=function(e){return l.clone(this,e)},l.packedLength=e.packedLength,l.pack=function(t,n,a){if(!i(t))throw new o("value is required");if(!i(n))throw new o("array is required");a=r(a,0),e.pack(t._radii,n,a)},l.unpack=function(t,n,a){if(!i(t))throw new o("array is required");n=r(n,0);var s=e.unpack(t,n);return l.fromCartesian3(s,a)},l.prototype.geocentricSurfaceNormal=e.normalize,l.prototype.geodeticSurfaceNormalCartographic=function(t,r){if(!i(t))throw new o("cartographic is required.");var n=t.longitude,a=t.latitude,s=Math.cos(a),u=s*Math.cos(n),l=s*Math.sin(n),c=Math.sin(a);return i(r)||(r=new e),r.x=u,r.y=l,r.z=c,e.normalize(r,r)},l.prototype.geodeticSurfaceNormal=function(t,r){return i(r)||(r=new e),r=e.multiplyComponents(t,this._oneOverRadiiSquared,r),e.normalize(r,r)};var c=new e,h=new e;l.prototype.cartographicToCartesian=function(t,r){var n=c,o=h;this.geodeticSurfaceNormalCartographic(t,n),e.multiplyComponents(this._radiiSquared,n,o);var a=Math.sqrt(e.dot(n,o));return e.divideByScalar(o,a,o),e.multiplyByScalar(n,t.height,n),i(r)||(r=new e),e.add(o,n,r)},l.prototype.cartographicArrayToCartesianArray=function(e,t){if(!i(e))throw new o("cartographics is required.");var r=e.length;i(t)?t.length=r:t=new Array(r);for(var n=0;r>n;n++)t[n]=this.cartographicToCartesian(e[n],t[n]);return t};var d=new e,m=new e,p=new e;l.prototype.cartesianToCartographic=function(r,n){var o=this.scaleToGeodeticSurface(r,m);if(!i(o))return void 0;var a=this.geodeticSurfaceNormal(o,d),u=e.subtract(r,o,p),l=Math.atan2(a.y,a.x),c=Math.asin(a.z),h=s.sign(e.dot(u,r))*e.magnitude(u);return i(n)?(n.longitude=l,n.latitude=c,n.height=h,n):new t(l,c,h)},l.prototype.cartesianArrayToCartographicArray=function(e,t){if(!i(e))throw new o("cartesians is required.");var r=e.length;i(t)?t.length=r:t=new Array(r);for(var n=0;r>n;++n)t[n]=this.cartesianToCartographic(e[n],t[n]);return t};var f=new e,v=new e;return l.prototype.scaleToGeodeticSurface=function(t,r){if(!i(t))throw new o("cartesian is required.");var n=t.x,a=t.y,u=t.z,l=this._oneOverRadii,c=l.x,h=l.y,d=l.z,m=n*n*c*c,p=a*a*h*h,g=u*u*d*d,_=m+p+g,y=Math.sqrt(1/_),w=e.multiplyByScalar(t,y,f);if(_<this._centerToleranceSquared)return isFinite(y)?e.clone(w,r):void 0;var C=this._oneOverRadiiSquared,E=C.x,S=C.y,b=C.z,T=v;T.x=w.x*E*2,T.y=w.y*S*2,T.z=w.z*b*2;var x,P,A,I,D,M,R,O,N,L,F,B=(1-y)*e.magnitude(t)/(.5*e.magnitude(T)),z=0;do{B-=z,A=1/(1+B*E),I=1/(1+B*S),D=1/(1+B*b),M=A*A,R=I*I,O=D*D,N=M*A,L=R*I,F=O*D,x=m*M+p*R+g*O-1,P=m*N*E+p*L*S+g*F*b;var V=-2*P;z=x/V}while(Math.abs(x)>s.EPSILON12);return i(r)?(r.x=n*A,r.y=a*I,r.z=u*D,r):new e(n*A,a*I,u*D)},l.prototype.scaleToGeocentricSurface=function(t,r){if(!i(t))throw new o("cartesian is required.");i(r)||(r=new e);var n=t.x,a=t.y,s=t.z,u=this._oneOverRadiiSquared,l=1/Math.sqrt(n*n*u.x+a*a*u.y+s*s*u.z);return e.multiplyByScalar(t,l,r)},l.prototype.transformPositionToScaledSpace=function(t,r){return i(r)||(r=new e),e.multiplyComponents(t,this._oneOverRadii,r)},l.prototype.transformPositionFromScaledSpace=function(t,r){return i(r)||(r=new e),e.multiplyComponents(t,this._radii,r)},l.prototype.equals=function(t){return this===t||i(t)&&e.equals(this._radii,t._radii)},l.prototype.toString=function(){return this._radii.toString()},l}),r("Core/Event",["./defined","./defineProperties","./DeveloperError"],function(e,t,r){"use strict";var i=function(){this._listeners=[],this._scopes=[],this._toRemove=[],this._insideRaiseEvent=!1};return t(i.prototype,{numberOfListeners:{get:function(){return this._listeners.length-this._toRemove.length}}}),i.prototype.addEventListener=function(e,t){if("function"!=typeof e)throw new r("listener is required and must be a function.");this._listeners.push(e),this._scopes.push(t);var i=this;return function(){i.removeEventListener(e,t)}},i.prototype.removeEventListener=function(e,t){if("function"!=typeof e)throw new r("listener is required and must be a function.");for(var i=this._listeners,n=this._scopes,o=-1,a=0;a<i.length;a++)if(i[a]===e&&n[a]===t){o=a;break}return-1!==o?(this._insideRaiseEvent?(this._toRemove.push(o),i[o]=void 0,n[o]=void 0):(i.splice(o,1),n.splice(o,1)),!0):!1},i.prototype.raiseEvent=function(){this._insideRaiseEvent=!0;var t,r=this._listeners,i=this._scopes,n=r.length;for(t=0;n>t;t++){var o=r[t];e(o)&&r[t].apply(i[t],arguments)}var a=this._toRemove;for(n=a.length,t=0;n>t;t++){var s=a[t];r.splice(s,1),i.splice(s,1)}a.length=0,this._insideRaiseEvent=!1},i}),r("Core/Cartesian2",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,i,n){"use strict";var o=function(t,r){this.x=e(t,0),this.y=e(r,0)};o.fromElements=function(e,r,i){return t(i)?(i.x=e,i.y=r,i):new o(e,r)},o.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r):new o(e.x,e.y):void 0},o.fromCartesian3=o.clone,o.fromCartesian4=o.clone,o.packedLength=2,o.pack=function(i,n,o){if(!t(i))throw new r("value is required");if(!t(n))throw new r("array is required");o=e(o,0),n[o++]=i.x,n[o]=i.y},o.unpack=function(i,n,a){if(!t(i))throw new r("array is required");return n=e(n,0),t(a)||(a=new o),a.x=i[n++],a.y=i[n],a},o.fromArray=o.unpack,o.maximumComponent=function(e){if(!t(e))throw new r("cartesian is required");return Math.max(e.x,e.y)},o.minimumComponent=function(e){if(!t(e))throw new r("cartesian is required");return Math.min(e.x,e.y)},o.minimumByComponent=function(e,i,n){if(!t(e))throw new r("first is required.");if(!t(i))throw new r("second is required.");if(!t(n))throw new r("result is required.");return n.x=Math.min(e.x,i.x),n.y=Math.min(e.y,i.y),n},o.maximumByComponent=function(e,i,n){if(!t(e))throw new r("first is required.");if(!t(i))throw new r("second is required.");if(!t(n))throw new r("result is required.");return n.x=Math.max(e.x,i.x),n.y=Math.max(e.y,i.y),n},o.magnitudeSquared=function(e){if(!t(e))throw new r("cartesian is required");return e.x*e.x+e.y*e.y},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,i){if(!t(e)||!t(i))throw new r("left and right are required.");return o.subtract(e,i,a),o.magnitude(a)},o.distanceSquared=function(e,i){if(!t(e)||!t(i))throw new r("left and right are required.");return o.subtract(e,i,a),o.magnitudeSquared(a)},o.normalize=function(e,i){if(!t(e))throw new r("cartesian is required");if(!t(i))throw new r("result is required");var n=o.magnitude(e);return i.x=e.x/n,i.y=e.y/n,i},o.dot=function(e,i){if(!t(e))throw new r("left is required");if(!t(i))throw new r("right is required");return e.x*i.x+e.y*i.y},o.multiplyComponents=function(e,i,n){if(!t(e))throw new r("left is required");if(!t(i))throw new r("right is required");if(!t(n))throw new r("result is required");return n.x=e.x*i.x,n.y=e.y*i.y,n},o.add=function(e,i,n){if(!t(e))throw new r("left is required");if(!t(i))throw new r("right is required");if(!t(n))throw new r("result is required");return n.x=e.x+i.x,n.y=e.y+i.y,n},o.subtract=function(e,i,n){if(!t(e))throw new r("left is required");if(!t(i))throw new r("right is required");if(!t(n))throw new r("result is required");return n.x=e.x-i.x,n.y=e.y-i.y,n},o.multiplyByScalar=function(e,i,n){if(!t(e))throw new r("cartesian is required");if("number"!=typeof i)throw new r("scalar is required and must be a number.");if(!t(n))throw new r("result is required");return n.x=e.x*i,n.y=e.y*i,n},o.divideByScalar=function(e,i,n){if(!t(e))throw new r("cartesian is required");if("number"!=typeof i)throw new r("scalar is required and must be a number.");if(!t(n))throw new r("result is required");return n.x=e.x/i,n.y=e.y/i,n},o.negate=function(e,i){if(!t(e))throw new r("cartesian is required");if(!t(i))throw new r("result is required");return i.x=-e.x,i.y=-e.y,i},o.abs=function(e,i){if(!t(e))throw new r("cartesian is required");if(!t(i))throw new r("result is required");return i.x=Math.abs(e.x),i.y=Math.abs(e.y),i};var s=new o;o.lerp=function(e,i,n,a){if(!t(e))throw new r("start is required.");if(!t(i))throw new r("end is required.");if("number"!=typeof n)throw new r("t is required and must be a number.");
if(!t(a))throw new r("result is required.");return o.multiplyByScalar(i,n,s),a=o.multiplyByScalar(e,1-n,a),o.add(s,a,a)};var u=new o,l=new o;o.angleBetween=function(e,i){if(!t(e))throw new r("left is required");if(!t(i))throw new r("right is required");return o.normalize(e,u),o.normalize(i,l),n.acosClamped(o.dot(u,l))};var c=new o;return o.mostOrthogonalAxis=function(e,i){if(!t(e))throw new r("cartesian is required.");if(!t(i))throw new r("result is required.");var n=o.normalize(e,c);return o.abs(n,n),i=n.x<=n.y?o.clone(o.UNIT_X,i):o.clone(o.UNIT_Y,i)},o.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]},o.equalsEpsilon=function(e,r,i,o){return e===r||t(e)&&t(r)&&n.equalsEpsilon(e.x,r.x,i,o)&&n.equalsEpsilon(e.y,r.y,i,o)},o.ZERO=i(new o(0,0)),o.UNIT_X=i(new o(1,0)),o.UNIT_Y=i(new o(0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+")"},o}),r("Core/GeographicProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid"],function(e,t,r,i,n,o,a){"use strict";var s=function(e){this._ellipsoid=r(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return n(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),s.prototype.project=function(t,r){var n=this._semimajorAxis,o=t.longitude*n,a=t.latitude*n,s=t.height;return i(r)?(r.x=o,r.y=a,r.z=s,r):new e(o,a,s)},s.prototype.unproject=function(e,r){if(!i(e))throw new o("cartesian is required");var n=this._oneOverSemimajorAxis,a=e.x*n,s=e.y*n,u=e.z;return i(r)?(r.longitude=a,r.latitude=s,r.height=u,r):new t(a,s,u)},s}),r("Core/Rectangle",["./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./freezeObject","./Math"],function(e,t,r,i,n,o,a,s){"use strict";var u=function(e,r,i,n){this.west=t(e,0),this.south=t(r,0),this.east=t(i,0),this.north=t(n,0)};i(u.prototype,{width:{get:function(){return u.computeWidth(this)}},height:{get:function(){return u.computeHeight(this)}}}),u.packedLength=4,u.pack=function(e,i,o){if(!r(e))throw new n("value is required");if(!r(i))throw new n("array is required");o=t(o,0),i[o++]=e.west,i[o++]=e.south,i[o++]=e.east,i[o]=e.north},u.unpack=function(e,i,o){if(!r(e))throw new n("array is required");return i=t(i,0),r(o)||(o=new u),o.west=e[i++],o.south=e[i++],o.east=e[i++],o.north=e[i],o},u.computeWidth=function(e){if(!r(e))throw new n("rectangle is required.");var t=e.east,i=e.west;return i>t&&(t+=s.TWO_PI),t-i},u.computeHeight=function(e){if(!r(e))throw new n("rectangle is required.");return e.north-e.south},u.fromDegrees=function(e,i,n,o,a){return e=s.toRadians(t(e,0)),i=s.toRadians(t(i,0)),n=s.toRadians(t(n,0)),o=s.toRadians(t(o,0)),r(a)?(a.west=e,a.south=i,a.east=n,a.north=o,a):new u(e,i,n,o)},u.fromCartographicArray=function(e,t){if(!r(e))throw new n("cartographics is required.");for(var i=Number.MAX_VALUE,o=-Number.MAX_VALUE,a=Number.MAX_VALUE,s=-Number.MAX_VALUE,l=0,c=e.length;c>l;l++){var h=e[l];i=Math.min(i,h.longitude),o=Math.max(o,h.longitude),a=Math.min(a,h.latitude),s=Math.max(s,h.latitude)}return r(t)?(t.west=i,t.south=a,t.east=o,t.north=s,t):new u(i,a,o,s)},u.clone=function(e,t){return r(e)?r(t)?(t.west=e.west,t.south=e.south,t.east=e.east,t.north=e.north,t):new u(e.west,e.south,e.east,e.north):void 0},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.equals=function(e,t){return e===t||r(e)&&r(t)&&e.west===t.west&&e.south===t.south&&e.east===t.east&&e.north===t.north},u.prototype.equalsEpsilon=function(e,t){if("number"!=typeof t)throw new n("epsilon is required and must be a number.");return r(e)&&Math.abs(this.west-e.west)<=t&&Math.abs(this.south-e.south)<=t&&Math.abs(this.east-e.east)<=t&&Math.abs(this.north-e.north)<=t},u.validate=function(e){if(!r(e))throw new n("rectangle is required");var t=e.north;if("number"!=typeof t)throw new n("north is required to be a number.");if(t<-s.PI_OVER_TWO||t>s.PI_OVER_TWO)throw new n("north must be in the interval [-Pi/2, Pi/2].");var i=e.south;if("number"!=typeof i)throw new n("south is required to be a number.");if(i<-s.PI_OVER_TWO||i>s.PI_OVER_TWO)throw new n("south must be in the interval [-Pi/2, Pi/2].");var o=e.west;if("number"!=typeof o)throw new n("west is required to be a number.");if(o<-Math.PI||o>Math.PI)throw new n("west must be in the interval [-Pi, Pi].");var a=e.east;if("number"!=typeof a)throw new n("east is required to be a number.");if(a<-Math.PI||a>Math.PI)throw new n("east must be in the interval [-Pi, Pi].")},u.southwest=function(t,i){if(!r(t))throw new n("rectangle is required");return r(i)?(i.longitude=t.west,i.latitude=t.south,i.height=0,i):new e(t.west,t.south)},u.northwest=function(t,i){if(!r(t))throw new n("rectangle is required");return r(i)?(i.longitude=t.west,i.latitude=t.north,i.height=0,i):new e(t.west,t.north)},u.northeast=function(t,i){if(!r(t))throw new n("rectangle is required");return r(i)?(i.longitude=t.east,i.latitude=t.north,i.height=0,i):new e(t.east,t.north)},u.southeast=function(t,i){if(!r(t))throw new n("rectangle is required");return r(i)?(i.longitude=t.east,i.latitude=t.south,i.height=0,i):new e(t.east,t.south)},u.center=function(t,i){if(!r(t))throw new n("rectangle is required");var o=t.east,a=t.west;a>o&&(o+=s.TWO_PI);var u=s.negativePiToPi(.5*(a+o)),l=.5*(t.south+t.north);return r(i)?(i.longitude=u,i.latitude=l,i.height=0,i):new e(u,l)},u.intersection=function(e,t,i){if(!r(e))throw new n("rectangle is required");if(!r(t))throw new n("otherRectangle is required.");var o=e.east,a=e.west,l=t.east,c=t.west;a>o&&l>0?o+=s.TWO_PI:c>l&&o>0&&(l+=s.TWO_PI),a>o&&0>c?c+=s.TWO_PI:c>l&&0>a&&(a+=s.TWO_PI);var h=s.negativePiToPi(Math.max(a,c)),d=s.negativePiToPi(Math.min(o,l));if((e.west<e.east||t.west<t.east)&&h>=d)return void 0;var m=Math.max(e.south,t.south),p=Math.min(e.north,t.north);return m>=p?void 0:r(i)?(i.west=h,i.south=m,i.east=d,i.north=p,i):new u(h,m,d,p)},u.contains=function(e,t){if(!r(e))throw new n("rectangle is required");if(!r(t))throw new n("cartographic is required.");var i=t.longitude,o=t.latitude,a=e.west,u=e.east;return a>u&&(u+=s.TWO_PI,0>i&&(i+=s.TWO_PI)),(i>a||s.equalsEpsilon(i,a,s.EPSILON14))&&(u>i||s.equalsEpsilon(i,u,s.EPSILON14))&&o>=e.south&&o<=e.north};var l=new e;return u.subsample=function(e,i,a,c){if(!r(e))throw new n("rectangle is required");i=t(i,o.WGS84),a=t(a,0),r(c)||(c=[]);var h=0,d=e.north,m=e.south,p=e.east,f=e.west,v=l;v.height=a,v.longitude=f,v.latitude=d,c[h]=i.cartographicToCartesian(v,c[h]),h++,v.longitude=p,c[h]=i.cartographicToCartesian(v,c[h]),h++,v.latitude=m,c[h]=i.cartographicToCartesian(v,c[h]),h++,v.longitude=f,c[h]=i.cartographicToCartesian(v,c[h]),h++,0>d?v.latitude=d:m>0?v.latitude=m:v.latitude=0;for(var g=1;8>g;++g)v.longitude=-Math.PI+g*s.PI_OVER_TWO,u.contains(e,v)&&(c[h]=i.cartographicToCartesian(v,c[h]),h++);return 0===v.latitude&&(v.longitude=f,c[h]=i.cartographicToCartesian(v,c[h]),h++,v.longitude=p,c[h]=i.cartographicToCartesian(v,c[h]),h++),c.length=h,c},u.MAX_VALUE=a(new u(-Math.PI,-s.PI_OVER_TWO,Math.PI,s.PI_OVER_TWO)),u}),r("Core/GeographicTilingScheme",["./Cartesian2","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./GeographicProjection","./Math","./Rectangle"],function(e,t,r,i,n,o,a,s,u){"use strict";var l=function(e){e=t(e,{}),this._ellipsoid=t(e.ellipsoid,o.WGS84),this._rectangle=t(e.rectangle,u.MAX_VALUE),this._projection=new a(this._ellipsoid),this._numberOfLevelZeroTilesX=t(e.numberOfLevelZeroTilesX,2),this._numberOfLevelZeroTilesY=t(e.numberOfLevelZeroTilesY,1)};return i(l.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},rectangle:{get:function(){return this._rectangle}},projection:{get:function(){return this._projection}}}),l.prototype.getNumberOfXTilesAtLevel=function(e){return this._numberOfLevelZeroTilesX<<e},l.prototype.getNumberOfYTilesAtLevel=function(e){return this._numberOfLevelZeroTilesY<<e},l.prototype.rectangleToNativeRectangle=function(e,t){if(!r(e))throw new n("rectangle is required.");var i=s.toDegrees(e.west),o=s.toDegrees(e.south),a=s.toDegrees(e.east),l=s.toDegrees(e.north);return r(t)?(t.west=i,t.south=o,t.east=a,t.north=l,t):new u(i,o,a,l)},l.prototype.tileXYToNativeRectangle=function(e,t,r,i){var n=this.tileXYToRectangle(e,t,r,i);return n.west=s.toDegrees(n.west),n.south=s.toDegrees(n.south),n.east=s.toDegrees(n.east),n.north=s.toDegrees(n.north),n},l.prototype.tileXYToRectangle=function(e,t,i,n){var o=this._rectangle,a=this.getNumberOfXTilesAtLevel(i),s=this.getNumberOfYTilesAtLevel(i),l=o.width/a,c=e*l+o.west,h=(e+1)*l+o.west,d=o.height/s,m=o.north-t*d,p=o.north-(t+1)*d;return r(n)||(n=new u(c,p,h,m)),n.west=c,n.south=p,n.east=h,n.north=m,n},l.prototype.positionToTileXY=function(t,i,n){var o=this._rectangle;if(!u.contains(o,t))return void 0;var a=this.getNumberOfXTilesAtLevel(i),l=this.getNumberOfYTilesAtLevel(i),c=o.width/a,h=o.height/l,d=t.longitude;o.east<o.west&&(d+=s.TWO_PI);var m=(d-o.west)/c|0;m>=a&&(m=a-1);var p=(o.north-t.latitude)/h|0;return p>=l&&(p=l-1),r(n)?(n.x=m,n.y=p,n):new e(m,p)},l}),r("Core/getImagePixels",["./defined"],function(e){"use strict";var t={},r=function(r,i,n){e(i)||(i=r.width),e(n)||(n=r.height);var o=t[i];e(o)||(o={},t[i]=o);var a=o[n];if(!e(a)){var s=document.createElement("canvas");s.width=i,s.height=n,a=s.getContext("2d"),a.globalCompositeOperation="copy",o[n]=a}return a.drawImage(r,0,0,i,n),a.getImageData(0,0,i,n).data};return r}),r("Core/HeightmapTessellator",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./freezeObject","./Math","./Rectangle"],function(e,t,r,i,n,o,a,s){"use strict";var u={};return u.DEFAULT_STRUCTURE=o({heightScale:1,heightOffset:0,elementsPerHeight:1,stride:1,elementMultiplier:256,isBigEndian:!1}),u.computeVertices=function(o){if(!r(o)||!r(o.heightmap))throw new i("options.heightmap is required.");if(!r(o.width)||!r(o.height))throw new i("options.width and options.height are required.");if(!r(o.vertices))throw new i("options.vertices is required.");if(!r(o.nativeRectangle))throw new i("options.nativeRectangle is required.");if(!r(o.skirtHeight))throw new i("options.skirtHeight is required.");var l,c,h,d,m=Math.cos,p=Math.sin,f=Math.sqrt,v=Math.atan,g=Math.exp,_=a.PI_OVER_TWO,y=a.toRadians,w=o.vertices,C=o.heightmap,E=o.width,S=o.height,b=o.skirtHeight,T=t(o.isGeographic,!0),x=t(o.ellipsoid,n.WGS84),P=1/x.maximumRadius,A=o.nativeRectangle,I=o.rectangle;r(I)?(l=I.west,c=I.south,h=I.east,d=I.north):T?(l=y(A.west),c=y(A.south),h=y(A.east),d=y(A.north)):(l=A.west*P,c=_-2*v(g(-A.south*P)),h=A.east*P,d=_-2*v(g(-A.north*P)));var D=t(o.relativeToCenter,e.ZERO),M=t(o.structure,u.DEFAULT_STRUCTURE),R=t(M.heightScale,u.DEFAULT_STRUCTURE.heightScale),O=t(M.heightOffset,u.DEFAULT_STRUCTURE.heightOffset),N=t(M.elementsPerHeight,u.DEFAULT_STRUCTURE.elementsPerHeight),L=t(M.stride,u.DEFAULT_STRUCTURE.stride),F=t(M.elementMultiplier,u.DEFAULT_STRUCTURE.elementMultiplier),B=t(M.isBigEndian,u.DEFAULT_STRUCTURE.isBigEndian),z=s.computeWidth(A)/(E-1),V=s.computeHeight(A)/(S-1),k=x.radiiSquared,U=k.x,q=k.y,G=k.z,W=0,H=65536,j=-65536,Y=0,X=S,Z=0,K=E;b>0&&(--Y,++X,--Z,++K);for(var Q=Y;X>Q;++Q){var J=Q;0>J&&(J=0),J>=S&&(J=S-1);var $=A.north-V*J;$=T?y($):_-2*v(g(-$*P));for(var ee=m($),te=p($),re=G*te,ie=($-c)/(d-c),ne=Z;K>ne;++ne){var oe=ne;0>oe&&(oe=0),oe>=E&&(oe=E-1);var ae=A.west+z*oe;T?ae=y(ae):ae*=P;var se,ue=J*E*L+oe*L;if(1===N)se=C[ue];else{se=0;var le;if(B)for(le=0;N>le;++le)se=se*F+C[ue+le];else for(le=N-1;le>=0;--le)se=se*F+C[ue+le]}se=se*R+O,j=Math.max(j,se),H=Math.min(H,se),(ne!==oe||Q!==J)&&(se-=b);var ce=ee*m(ae),he=ee*p(ae),de=U*ce,me=q*he,pe=f(de*ce+me*he+re*te),fe=1/pe,ve=de*fe,ge=me*fe,_e=re*fe;w[W++]=ve+ce*se-D.x,w[W++]=ge+he*se-D.y,w[W++]=_e+te*se-D.z,w[W++]=se;var ye=(ae-l)/(h-l);w[W++]=ye,w[W++]=ie}}return{maximumHeight:j,minimumHeight:H}},u}),r("ThirdParty/Uri",[],function(){function e(t){if(t instanceof e)this.scheme=t.scheme,this.authority=t.authority,this.path=t.path,this.query=t.query,this.fragment=t.fragment;else if(t){var r=i.exec(t);this.scheme=r[1],this.authority=r[2],this.path=r[3],this.query=r[4],this.fragment=r[5]}}function t(e){var t=unescape(e);return o.test(t)?t:e.toUpperCase()}function r(e,t,r,i){return(t||"")+r.toLowerCase()+(i||"")}e.prototype.scheme=null,e.prototype.authority=null,e.prototype.path="",e.prototype.query=null,e.prototype.fragment=null;var i=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");e.prototype.getScheme=function(){return this.scheme},e.prototype.getAuthority=function(){return this.authority},e.prototype.getPath=function(){return this.path},e.prototype.getQuery=function(){return this.query},e.prototype.getFragment=function(){return this.fragment},e.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},e.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},e.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},e.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(a,r).replace(n,t)),this.path&&(this.path=this.path.replace(n,t)),this.query&&(this.query=this.query.replace(n,t)),this.fragment&&(this.fragment=this.fragment.replace(n,t))};var n=/%[0-9a-z]{2}/gi,o=/[a-zA-Z0-9\-\._~]/,a=/(.*@)?([^@:]*)(:.*)?/;return e.prototype.resolve=function(t){var r=new e;return this.scheme?(r.scheme=this.scheme,r.authority=this.authority,r.path=this.path,r.query=this.query):(r.scheme=t.scheme,this.authority?(r.authority=this.authority,r.path=this.path,r.query=this.query):(r.authority=t.authority,""==this.path?(r.path=t.path,r.query=this.query||t.query):("/"==this.path.charAt(0)?(r.path=this.path,r.removeDotSegments()):(t.authority&&""==t.path?r.path="/"+this.path:r.path=t.path.substring(0,t.path.lastIndexOf("/")+1)+this.path,r.removeDotSegments()),r.query=this.query))),r.fragment=this.fragment,r},e.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),r=[],i=""==t[0];i&&t.shift();for(""==t[0]?t.shift():null;t.length;)e=t.shift(),".."==e?r.pop():"."!=e&&r.push(e);("."==e||".."==e)&&r.push(""),i&&r.unshift(""),this.path=r.join("/")},e.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},e}),r("Core/buildModuleUrl",["../ThirdParty/Uri","./defined","./DeveloperError","require"],function(e,t,r,i){"use strict";function n(){for(var e=document.getElementsByTagName("script"),t=0,r=e.length;r>t;++t){var i=e[t].getAttribute("src"),n=h.exec(i);if(null!==n)return n[1]}return void 0}function o(){if(t(u))return u;var i;if(i="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:n(),!t(i))throw new r("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return u=new e(i).resolve(new e(document.location.href))}function a(e){return i.toUrl("../"+e)}function s(t){return new e(t).resolve(o()).toString()}var u,l,c,h=/((?:.*\/)|^)cesium[\w-]*\.js(?:\W|$)/i,d=function(e){t(l)||(l=t(i.toUrl)?a:s),t(c)||(c=document.createElement("a"));var r=l(e);return c.href=r,c.href=c.href,c.href};return d._cesiumScriptRegex=h,d.setBaseUrl=function(t){u=new e(t).resolve(new e(document.location.href))},d}),r("Core/destroyObject",["./defaultValue","./DeveloperError"],function(e,t){"use strict";function r(){return!0}var i=function(i,n){function o(){throw new t(n)}n=e(n,"This object was destroyed, i.e., destroy() was called.");for(var a in i)"function"==typeof i[a]&&(i[a]=o);return void(i.isDestroyed=r)};return i}),r("Core/isCrossOriginUrl",["./defined"],function(e){"use strict";var t,r=function(r){e(t)||(t=document.createElement("a")),t.href=window.location.href;var i=t.host,n=t.protocol;return t.href=r,t.href=t.href,n!==t.protocol||i!==t.host};return r}),r("Core/RuntimeError",["./defined"],function(e){"use strict";var t=function(e){this.name="RuntimeError",this.message=e;var t;try{throw new Error}catch(r){t=r.stack}this.stack=t};return t.prototype.toString=function(){var t=this.name+": "+this.message;return e(this.stack)&&(t+="\n"+this.stack.toString()),t},t}),r("Core/TaskProcessor",["../ThirdParty/Uri","../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./destroyObject","./DeveloperError","./isCrossOriginUrl","./RuntimeError","require"],function(e,t,r,i,n,o,a,s,u,l){"use strict";function c(){if(!n(v._canTransferArrayBuffer)){var e=new Worker(d("Workers/transferTypedArrayTest.js"));e.postMessage=i(e.webkitPostMessage,e.postMessage);var r=99,o=new Int8Array([r]);try{e.postMessage({array:o},[o.buffer])}catch(a){return v._canTransferArrayBuffer=!1,v._canTransferArrayBuffer}var s=t.defer();e.onmessage=function(t){var i=t.data.array,o=n(i)&&i[0]===r;s.resolve(o),e.terminate(),v._canTransferArrayBuffer=o},v._canTransferArrayBuffer=s.promise}return v._canTransferArrayBuffer}function h(e,t){--e._activeTasks;var r=t.id;if(n(r)){var i=e._deferreds,o=i[r];if(n(t.error)){var s=t.error;"RuntimeError"===s.name?(s=new u(t.error.message),s.stack=t.error.stack):"DeveloperError"===s.name&&(s=new a(t.error.message),s.stack=t.error.stack),o.reject(s)}else o.resolve(t.result);delete i[r]}}function d(e){var t=r(e);if(s(t)){var i,n='importScripts("'+t+'");';try{i=new Blob([n],{type:"application/javascript"})}catch(o){var a=window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder||window.MSBlobBuilder,u=new a;u.append(n),i=u.getBlob("application/javascript")}var l=window.URL||window.webkitURL;t=l.createObjectURL(i)}return t}function m(){return n(f)||(f=d("Workers/cesiumWorkerBootstrapper.js")),f}function p(t){var o=new Worker(m());o.postMessage=i(o.webkitPostMessage,o.postMessage);var a={loaderConfig:{},workerModule:v._workerModulePrefix+t._workerName};if(n(v._loaderConfig))a.loaderConfig=v._loaderConfig;else if(n(l.toUrl)){var s=new e("..").resolve(new e(r("Workers/cesiumWorkerBootstrapper.js"))).toString();a.loaderConfig.baseUrl=s}else a.loaderConfig.paths={Workers:r("Workers")};return o.postMessage(a),o.onmessage=function(e){h(t,e.data)},o}var f,v=function(e,t){this._workerName=e,this._maximumActiveTasks=i(t,5),this._activeTasks=0,this._deferreds={},this._nextID=0},g=[];return v.prototype.scheduleTask=function(e,r){if(n(this._worker)||(this._worker=p(this)),this._activeTasks>=this._maximumActiveTasks)return void 0;++this._activeTasks;var i=this;return t(c(),function(o){n(r)?o||(r.length=0):r=g;var a=i._nextID++,s=t.defer();return i._deferreds[a]=s,i._worker.postMessage({id:a,parameters:e,canTransferArrayBuffer:o},r),s.promise})},v.prototype.isDestroyed=function(){return!1},v.prototype.destroy=function(){return n(this._worker)&&this._worker.terminate(),o(this)},v._defaultWorkerModulePrefix="Workers/",v._workerModulePrefix=v._defaultWorkerModulePrefix,v._loaderConfig=void 0,v._canTransferArrayBuffer=void 0,v}),r("Core/TerrainMesh",["../Core/defaultValue"],function(e){"use strict";var t=function(t,r,i,n,o,a,s,u,l){this.center=t,this.vertices=r,this.stride=e(u,6),this.indices=i,this.minimumHeight=n,this.maximumHeight=o,this.boundingSphere3D=a,this.occludeePointInScaledSpace=s,this.orientedBoundingBox=l};return t}),r("Core/TerrainProvider",["./defined","./defineProperties","./DeveloperError","./Math"],function(e,t,r,i){"use strict";var n=function(){r.throwInstantiationError()};t(n.prototype,{errorEvent:{get:r.throwInstantiationError},credit:{get:r.throwInstantiationError},tilingScheme:{get:r.throwInstantiationError},ready:{get:r.throwInstantiationError},hasWaterMask:{get:r.throwInstantiationError},hasVertexNormals:{get:r.throwInstantiationError}});var o=[];return n.getRegularGridIndices=function(t,n){if(t*n>=i.SIXTY_FOUR_KILOBYTES)throw new r("The total number of vertices (width * height) must be less than 65536.");var a=o[t];e(a)||(o[t]=a=[]);var s=a[n];if(!e(s)){s=a[n]=new Uint16Array((t-1)*(n-1)*6);for(var u=0,l=0,c=0;n-1>c;++c){for(var h=0;t-1>h;++h){var d=u,m=d+t,p=m+1,f=d+1;s[l++]=d,s[l++]=m,s[l++]=f,s[l++]=f,s[l++]=m,s[l++]=p,++u}++u}}return s},n.heightmapTerrainQuality=.25,n.getEstimatedLevelZeroGeometricErrorForAHeightmap=function(e,t,r){return 2*e.maximumRadius*Math.PI*n.heightmapTerrainQuality/(t*r)},n.prototype.requestTileGeometry=r.throwInstantiationError,n.prototype.getLevelMaximumGeometricError=r.throwInstantiationError,n.prototype.getTileDataAvailable=r.throwInstantiationError,n}),r("Core/HeightmapTerrainData",["../ThirdParty/when","./defaultValue","./defined","./defineProperties","./DeveloperError","./GeographicTilingScheme","./HeightmapTessellator","./Math","./Rectangle","./TaskProcessor","./TerrainMesh","./TerrainProvider"],function(e,t,r,i,n,o,a,s,u,l,c,h){"use strict";function d(e,t,r,i,n,o,a,s){var u=1,l=e._width,c=e._height,h=o*(l-1),d=h+l-1,m=a*(c-1),p=m+c-1,f=1<<u;h/=f,d/=f,m/=f,p/=f;var v=r*(l-1),g=i*(c-1);h-=v,d-=v,m-=g,p-=g;var _,w,C=0|h,E=0|d,S=0|m,b=0|p,T=E-C+1,x=b-S+1,P=e._buffer,A=e._structure,I=T*x,D=I*A.stride,M=new P.constructor(D),R=0,O=A.stride;if(O>1)for(w=S;b>=w;++w)for(_=C;E>=_;++_)for(var N=(w*l+_)*O,L=0;O>L;++L)M[R++]=P[N+L];else for(w=S;b>=w;++w)for(_=C;E>=_;++_)M[R++]=P[w*l+_];return new y({buffer:M,width:T,height:x,childTileMask:0,structure:e._structure,createdByUpsampling:!0})}function m(e,t,r,i,n,o,a,u){var l,c,h,d,m=e._width,v=e._height,g=e._structure,w=g.stride,C=e._buffer,E=new C.constructor(m*v*w),S=t.tileXYToRectangle(r,i,n),b=t.tileXYToRectangle(o,a,u);if(w>1){var T=g.elementsPerHeight,x=g.elementMultiplier,P=g.isBigEndian,A=Math.pow(x,T-1);for(c=0;v>c;++c)for(h=s.lerp(b.north,b.south,c/(v-1)),l=0;m>l;++l){d=s.lerp(b.west,b.east,l/(m-1));var I=f(C,T,x,w,P,S,m,v,d,h);_(E,T,x,A,w,P,c*m+l,I)}}else for(c=0;v>c;++c)for(h=s.lerp(b.north,b.south,c/(v-1)),l=0;m>l;++l)d=s.lerp(b.west,b.east,l/(m-1)),E[c*m+l]=p(C,S,m,v,d,h);return new y({buffer:E,width:m,height:v,childTileMask:0,structure:e._structure,createdByUpsampling:!0})}function p(e,t,r,i,n,o){var a=(n-t.west)*(r-1)/(t.east-t.west),s=(o-t.south)*(i-1)/(t.north-t.south),u=0|a,l=u+1;l>=r&&(l=r-1,u=r-2);var c=0|s,h=c+1;h>=i&&(h=i-1,c=i-2);var d=a-u,m=s-c;c=i-1-c,h=i-1-h;var p=e[c*r+u],f=e[c*r+l],g=e[h*r+u],_=e[h*r+l];return v(d,m,p,f,g,_)}function f(e,t,r,i,n,o,a,s,u,l){var c=(u-o.west)*(a-1)/(o.east-o.west),h=(l-o.south)*(s-1)/(o.north-o.south),d=0|c,m=d+1;m>=a&&(m=a-1,d=a-2);var p=0|h,f=p+1;f>=s&&(f=s-1,p=s-2);var _=c-d,y=h-p;p=s-1-p,f=s-1-f;var w=g(e,t,r,i,n,p*a+d),C=g(e,t,r,i,n,p*a+m),E=g(e,t,r,i,n,f*a+d),S=g(e,t,r,i,n,f*a+m);return v(_,y,w,C,E,S)}function v(e,t,r,i,n,o){return e>t?r+e*(i-r)+t*(o-i):r+e*(o-n)+t*(n-r)}function g(e,t,r,i,n,o){o*=i;var a,s=0;if(n)for(a=0;t>a;++a)s=s*r+e[o+a];else for(a=t-1;a>=0;--a)s=s*r+e[o+a];return s}function _(e,t,r,i,n,o,a,s){a*=n;var u;if(o)for(u=0;t>u;++u)e[a+u]=s/i|0,s-=e[a+u]*i,i/=r;else for(u=t-1;u>=0;--u)e[a+u]=s/i|0,s-=e[a+u]*i,i/=r}var y=function(e){if(!r(e)||!r(e.buffer))throw new n("options.buffer is required.");if(!r(e.width))throw new n("options.width is required.");if(!r(e.height))throw new n("options.height is required.");this._buffer=e.buffer,this._width=e.width,this._height=e.height,this._childTileMask=t(e.childTileMask,15);var i=a.DEFAULT_STRUCTURE,o=e.structure;r(o)?o!==i&&(o.heightScale=t(o.heightScale,i.heightScale),o.heightOffset=t(o.heightOffset,i.heightOffset),o.elementsPerHeight=t(o.elementsPerHeight,i.elementsPerHeight),o.stride=t(o.stride,i.stride),o.elementMultiplier=t(o.elementMultiplier,i.elementMultiplier),o.isBigEndian=t(o.isBigEndian,i.isBigEndian)):o=i,this._structure=o,this._createdByUpsampling=t(e.createdByUpsampling,!1),this._waterMask=e.waterMask};i(y.prototype,{waterMask:{get:function(){return this._waterMask}}});var w=new l("createVerticesFromHeightmap");return y.prototype.createMesh=function(t,i,a,s){if(!r(t))throw new n("tilingScheme is required.");if(!r(i))throw new n("x is required.");if(!r(a))throw new n("y is required.");if(!r(s))throw new n("level is required.");var l=t.ellipsoid,d=t.tileXYToNativeRectangle(i,a,s),m=t.tileXYToRectangle(i,a,s),p=l.cartographicToCartesian(u.center(m)),f=this._structure,v=h.getEstimatedLevelZeroGeometricErrorForAHeightmap(l,this._width,t.getNumberOfXTilesAtLevel(0)),g=v/(1<<s),_=w.scheduleTask({heightmap:this._buffer,structure:f,width:this._width,height:this._height,nativeRectangle:d,rectangle:m,relativeToCenter:p,ellipsoid:l,skirtHeight:Math.min(4*g,1e3),isGeographic:t instanceof o});return r(_)?e(_,function(e){return new c(p,new Float32Array(e.vertices),h.getRegularGridIndices(e.gridWidth,e.gridHeight),e.minimumHeight,e.maximumHeight,e.boundingSphere3D,e.occludeePointInScaledSpace,6,e.orientedBoundingBox)}):void 0},y.prototype.interpolateHeight=function(e,t,r){var i,n=this._width,o=this._height,a=this._structure,s=a.stride;if(s>1){var u=a.elementsPerHeight,l=a.elementMultiplier,c=a.isBigEndian;i=f(this._buffer,u,l,s,c,e,n,o,t,r)}else i=p(this._buffer,e,n,o,t,r);return i*a.heightScale+a.heightOffset},y.prototype.upsample=function(e,t,i,o,a,s,u){if(!r(e))throw new n("tilingScheme is required.");if(!r(t))throw new n("thisX is required.");if(!r(i))throw new n("thisY is required.");if(!r(o))throw new n("thisLevel is required.");if(!r(a))throw new n("descendantX is required.");if(!r(s))throw new n("descendantY is required.");if(!r(u))throw new n("descendantLevel is required.");var l=u-o;if(l>1)throw new n("Upsampling through more than one level at a time is not currently supported.");var c;return c=this._width%2===1&&this._height%2===1?d(this,e,t,i,o,a,s,u):m(this,e,t,i,o,a,s,u)},y.prototype.isChildAvailable=function(e,t,i,o){if(!r(e))throw new n("thisX is required.");if(!r(t))throw new n("thisY is required.");if(!r(i))throw new n("childX is required.");if(!r(o))throw new n("childY is required.");var a=2;return i!==2*e&&++a,o!==2*t&&(a-=2),0!==(this._childTileMask&1<<a)},y.prototype.wasCreatedByUpsampling=function(){return this._createdByUpsampling},y}),r("Core/loadImage",["../ThirdParty/when","./defaultValue","./defined","./DeveloperError","./isCrossOriginUrl"],function(e,t,r,i,n){"use strict";var o=/^data:/,a=function(s,u){if(!r(s))throw new i("url is required.");return u=t(u,!0),e(s,function(t){var r;r=o.test(t)||!u?!1:n(t);var i=e.defer();return a.createImage(t,r,i),i.promise})};return a.createImage=function(e,t,r){var i=new Image;i.onload=function(){r.resolve(i)},i.onerror=function(e){r.reject(e)},t&&(i.crossOrigin=""),i.src=e},a.defaultCreateImage=a.createImage,a}),r("Core/throttleRequestByServer",["../ThirdParty/Uri","../ThirdParty/when","./defaultValue"],function(e,t,r){"use strict";function i(t){var r=new e(t).resolve(o);r.normalize();var i=r.authority;return/:/.test(i)||(i=i+":"+("https"===r.scheme?"443":"80")),i}var n={},o=new e(document.location.href),a=function(e,o){var s=i(e),u=r(n[s],0);return u>=a.maximumRequestsPerServer?void 0:(n[s]=u+1,t(o(e),function(e){return n[s]--,e}).otherwise(function(e){return n[s]--,t.reject(e)}))};return a.maximumRequestsPerServer=6,a}),r("Core/ArcGisImageServerTerrainProvider",["../ThirdParty/when","./Credit","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Event","./GeographicTilingScheme","./getImagePixels","./HeightmapTerrainData","./loadImage","./Math","./TerrainProvider","./throttleRequestByServer"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p){"use strict";var f=function(e){if(!i(e)||!i(e.url))throw new o("options.url is required.");this._url=e.url,this._token=e.token,this._tilingScheme=e.tilingScheme,i(this._tilingScheme)||(this._tilingScheme=new u({ellipsoid:r(e.ellipsoid,a.WGS84)})),this._heightmapWidth=65,this._levelZeroMaximumGeometricError=m.getEstimatedLevelZeroGeometricErrorForAHeightmap(this._tilingScheme.ellipsoid,this._heightmapWidth,this._tilingScheme.getNumberOfXTilesAtLevel(0)),this._proxy=e.proxy,this._terrainDataStructure={heightScale:.001,heightOffset:-1e3,elementsPerHeight:3,stride:4,elementMultiplier:256,isBigEndian:!0},this._errorEvent=new s;var n=e.credit;"string"==typeof n&&(n=new t(n)),this._credit=n};return n(f.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){return this._credit}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return!0}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}}}),f.prototype.requestTileGeometry=function(t,r,n){var o=this._tilingScheme.tileXYToRectangle(t,r,n),a=(o.east-o.west)/(this._heightmapWidth-1),s=(o.north-o.south)/(this._heightmapWidth-1);o.west-=.5*a,o.east+=.5*a,o.south-=.5*s,o.north+=.5*s;var u=d.toDegrees(o.west)+"%2C"+d.toDegrees(o.south)+"%2C"+d.toDegrees(o.east)+"%2C"+d.toDegrees(o.north),m=this._url+"/exportImage?interpolation=RSP_BilinearInterpolation&format=tiff&f=image&size="+this._heightmapWidth+"%2C"+this._heightmapWidth+"&bboxSR=4326&imageSR=4326&bbox="+u;this._token&&(m+="&token="+this._token);var f=this._proxy;i(f)&&(m=f.getURL(m));var v=p(m,h);if(!i(v))return void 0;var g=this;return e(v,function(e){return new c({buffer:l(e),width:g._heightmapWidth,height:g._heightmapWidth,childTileMask:15,structure:g._terrainDataStructure})})},f.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},f.prototype.getTileDataAvailable=function(e,t,r){return void 0},f}),r("Core/AssociativeArray",["./defined","./defineProperties","./DeveloperError"],function(e,t,r){"use strict";var i=function(){this._array=[],this._hash={}};return t(i.prototype,{length:{get:function(){return this._array.length}},values:{get:function(){return this._array}}}),i.prototype.contains=function(t){if("string"!=typeof t&&"number"!=typeof t)throw new r("key is required to be a string or number.");return e(this._hash[t])},i.prototype.set=function(e,t){if("string"!=typeof e&&"number"!=typeof e)throw new r("key is required to be a string or number.");var i=this._hash[e];t!==i&&(this.remove(e),this._hash[e]=t,this._array.push(t))},i.prototype.get=function(e){if("string"!=typeof e&&"number"!=typeof e)throw new r("key is required to be a string or number.");return this._hash[e]},i.prototype.remove=function(t){if(e(t)&&"string"!=typeof t&&"number"!=typeof t)throw new r("key is required to be a string or number.");var i=this._hash[t],n=e(i);if(n){var o=this._array;o.splice(o.indexOf(i),1),delete this._hash[t]}return n},i.prototype.removeAll=function(){var e=this._array;e.length>0&&(this._hash={},e.length=0)},i}),r("Core/AttributeCompression",["./Cartesian2","./Cartesian3","./defined","./DeveloperError","./Math"],function(e,t,r,i,n){"use strict";var o={};o.octEncode=function(e,o){if(!r(e))throw new i("vector is required.");if(!r(o))throw new i("result is required.");var a=t.magnitudeSquared(e);if(Math.abs(a-1)>n.EPSILON6)throw new i("vector must be normalized.");if(o.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),o.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var s=o.x,u=o.y;o.x=(1-Math.abs(u))*n.signNotZero(s),o.y=(1-Math.abs(s))*n.signNotZero(u)}return o.x=n.toSNorm(o.x),o.y=n.toSNorm(o.y),o},o.octDecode=function(e,o,a){if(!r(a))throw new i("result is required.");if(0>e||e>255||0>o||o>255)throw new i("x and y must be a signed normalized integer between 0 and 255");if(a.x=n.fromSNorm(e),a.y=n.fromSNorm(o),a.z=1-(Math.abs(a.x)+Math.abs(a.y)),a.z<0){var s=a.x;a.x=(1-Math.abs(a.y))*n.signNotZero(s),a.y=(1-Math.abs(s))*n.signNotZero(a.y)}return t.normalize(a,a)},o.octPackFloat=function(e){if(!r(e))throw new i("encoded is required.");return 256*e.x+e.y};var a=new e;return o.octEncodeFloat=function(e){return o.octEncode(e,a),o.octPackFloat(a)},o.octDecodeFloat=function(e,t){
if(!r(e))throw new i("value is required.");var n=e/256,a=Math.floor(n),s=256*(n-a);return o.octDecode(a,s,t)},o.octPack=function(e,t,n,s){if(!r(e))throw new i("v1 is required.");if(!r(t))throw new i("v2 is required.");if(!r(n))throw new i("v3 is required.");if(!r(s))throw new i("result is required.");var u=o.octEncodeFloat(e),l=o.octEncodeFloat(t),c=o.octEncode(n,a);return s.x=65536*c.x+u,s.y=65536*c.y+l,s},o.octUnpack=function(e,t,n,a){if(!r(e))throw new i("packed is required.");if(!r(t))throw new i("v1 is required.");if(!r(n))throw new i("v2 is required.");if(!r(a))throw new i("v3 is required.");var s=e.x/65536,u=Math.floor(s),l=65536*(s-u);s=e.y/65536;var c=Math.floor(s),h=65536*(s-c);o.octDecodeFloat(l,t),o.octDecodeFloat(h,n),o.octDecode(u,c,a)},o.compressTextureCoordinates=function(e){if(!r(e))throw new i("textureCoordinates is required.");var t=1===e.x?4095:4096*e.x|0,n=1===e.y?4095:4096*e.y|0;return 4096*t+n},o.decompressTextureCoordinates=function(e,t){if(!r(e))throw new i("compressed is required.");if(!r(t))throw new i("result is required.");var n=e/4096;return t.x=Math.floor(n)/4096,t.y=n-Math.floor(n),t},o}),r("Core/deprecationWarning",["./defined","./DeveloperError"],function(e,t){"use strict";var r={},i=function(i,n){if(!e(i)||!e(n))throw new t("identifier and message are required.");e(r[i])||(r[i]=!0,console.log(n))};return i}),r("Core/Intersect",["./freezeObject"],function(e){"use strict";var t={OUTSIDE:-1,INTERSECTING:0,INSIDE:1};return e(t)}),r("Core/Plane",["./Cartesian3","./defined","./DeveloperError","./freezeObject"],function(e,t,r,i){"use strict";var n=function(i,n){if(!t(i))throw new r("normal is required.");if(!t(n))throw new r("distance is required.");this.normal=e.clone(i),this.distance=n};n.fromPointNormal=function(i,o,a){if(!t(i))throw new r("point is required.");if(!t(o))throw new r("normal is required.");var s=-e.dot(o,i);return t(a)?(e.clone(o,a.normal),a.distance=s,a):new n(o,s)};var o=new e;return n.fromCartesian4=function(i,a){if(!t(i))throw new r("coefficients is required.");var s=e.fromCartesian4(i,o),u=i.w;return t(a)?(e.clone(s,a.normal),a.distance=u,a):new n(s,u)},n.getPointDistance=function(i,n){if(!t(i))throw new r("plane is required.");if(!t(n))throw new r("point is required.");return e.dot(i.normal,n)+i.distance},n.ORIGIN_XY_PLANE=i(new n(e.UNIT_Z,0)),n.ORIGIN_YZ_PLANE=i(new n(e.UNIT_X,0)),n.ORIGIN_ZX_PLANE=i(new n(e.UNIT_Y,0)),n}),r("Core/AxisAlignedBoundingBox",["./Cartesian3","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Intersect","./Plane"],function(e,t,r,i,n,o,a){"use strict";var s=function(i,n,o){this.minimum=e.clone(t(i,e.ZERO)),this.maximum=e.clone(t(n,e.ZERO)),r(o)?o=e.clone(o):(o=e.add(this.minimum,this.maximum,new e),e.multiplyByScalar(o,.5,o)),this.center=o};s.fromPoints=function(t,i){if(r(i)||(i=new s),!r(t)||0===t.length)return i.minimum=e.clone(e.ZERO,i.minimum),i.maximum=e.clone(e.ZERO,i.maximum),i.center=e.clone(e.ZERO,i.center),i;for(var n=t[0].x,o=t[0].y,a=t[0].z,u=t[0].x,l=t[0].y,c=t[0].z,h=t.length,d=1;h>d;d++){var m=t[d],p=m.x,f=m.y,v=m.z;n=Math.min(p,n),u=Math.max(p,u),o=Math.min(f,o),l=Math.max(f,l),a=Math.min(v,a),c=Math.max(v,c)}var g=i.minimum;g.x=n,g.y=o,g.z=a;var _=i.maximum;_.x=u,_.y=l,_.z=c;var y=e.add(g,_,i.center);return e.multiplyByScalar(y,.5,y),i},s.clone=function(t,i){return r(t)?r(i)?(i.minimum=e.clone(t.minimum,i.minimum),i.maximum=e.clone(t.maximum,i.maximum),i.center=e.clone(t.center,i.center),i):new s(t.minimum,t.maximum):void 0},s.equals=function(t,i){return t===i||r(t)&&r(i)&&e.equals(t.center,i.center)&&e.equals(t.minimum,i.minimum)&&e.equals(t.maximum,i.maximum)};var u=new e;return s.intersectPlane=function(t,i){if(!r(t))throw new n("box is required.");if(!r(i))throw new n("plane is required.");u=e.subtract(t.maximum,t.minimum,u);var a=e.multiplyByScalar(u,.5,u),s=i.normal,l=a.x*Math.abs(s.x)+a.y*Math.abs(s.y)+a.z*Math.abs(s.z),c=e.dot(t.center,s)+i.distance;return c-l>0?o.INSIDE:0>c+l?o.OUTSIDE:o.INTERSECTING},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.intersectPlane=function(e){return s.intersectPlane(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s}),r("Core/barycentricCoordinates",["./Cartesian2","./Cartesian3","./defined","./DeveloperError"],function(e,t,r,i){"use strict";var n=new t,o=new t,a=new t,s=function(s,u,l,c,h){if(!(r(s)&&r(u)&&r(l)&&r(c)))throw new i("point, p0, p1, and p2 are required.");r(h)||(h=new t);var d,m,p,f,v,g,_,y;r(u.z)?(d=t.subtract(l,u,n),m=t.subtract(c,u,o),p=t.subtract(s,u,a),f=t.dot(d,d),v=t.dot(d,m),g=t.dot(d,p),_=t.dot(m,m),y=t.dot(m,p)):(d=e.subtract(l,u,n),m=e.subtract(c,u,o),p=e.subtract(s,u,a),f=e.dot(d,d),v=e.dot(d,m),g=e.dot(d,p),_=e.dot(m,m),y=e.dot(m,p));var w=1/(f*_-v*v);return h.y=(_*g-v*y)*w,h.z=(f*y-v*g)*w,h.x=1-h.y-h.z,h};return s}),r("Core/binarySearch",["./defined","./DeveloperError"],function(e,t){"use strict";var r=function(r,i,n){if(!e(r))throw new t("array is required.");if(!e(i))throw new t("itemToFind is required.");if(!e(n))throw new t("comparator is required.");for(var o,a,s=0,u=r.length-1;u>=s;)if(o=~~((s+u)/2),a=n(r[o],i),0>a)s=o+1;else{if(!(a>0))return o;u=o-1}return~(u+1)};return r}),r("Core/BingMapsApi",["./defined"],function(e){"use strict";var t={};t.defaultKey=void 0;var r=!1;return t.getKey=function(i){return e(i)?i:e(t.defaultKey)?t.defaultKey:(r||(console.log("This application is using Cesium's default Bing Maps key.  Please create a new key for the application as soon as possible and prior to deployment by visiting https://www.bingmapsportal.com/, and provide your key to Cesium by setting the Cesium.BingMapsApi.defaultKey property before constructing the CesiumWidget or any other object that uses the Bing Maps API."),r=!0),"Aj1ony_-Typ-KjG9SJWiKSHY23U1KmK7yAmZa9lDmuF2osXWkcZ22VPsqmCt0TCt")},t}),r("Core/BoundingRectangle",["./Cartesian2","./Cartographic","./defaultValue","./defined","./DeveloperError","./GeographicProjection","./Intersect","./Rectangle"],function(e,t,r,i,n,o,a,s){"use strict";var u=function(e,t,i,n){this.x=r(e,0),this.y=r(t,0),this.width=r(i,0),this.height=r(n,0)};u.fromPoints=function(e,t){if(i(t)||(t=new u),!i(e)||0===e.length)return t.x=0,t.y=0,t.width=0,t.height=0,t;for(var r=e.length,n=e[0].x,o=e[0].y,a=e[0].x,s=e[0].y,l=1;r>l;l++){var c=e[l],h=c.x,d=c.y;n=Math.min(h,n),a=Math.max(h,a),o=Math.min(d,o),s=Math.max(d,s)}return t.x=n,t.y=o,t.width=a-n,t.height=s-o,t};var l=new o,c=new t,h=new t;return u.fromRectangle=function(t,n,o){if(i(o)||(o=new u),!i(t))return o.x=0,o.y=0,o.width=0,o.height=0,o;n=r(n,l);var a=n.project(s.southwest(t,c)),d=n.project(s.northeast(t,h));return e.subtract(d,a,d),o.x=a.x,o.y=a.y,o.width=d.x,o.height=d.y,o},u.clone=function(e,t){return i(e)?i(t)?(t.x=e.x,t.y=e.y,t.width=e.width,t.height=e.height,t):new u(e.x,e.y,e.width,e.height):void 0},u.union=function(e,t,r){if(!i(e))throw new n("left is required.");if(!i(t))throw new n("right is required.");i(r)||(r=new u);var o=Math.min(e.x,t.x),a=Math.min(e.y,t.y),s=Math.max(e.x+e.width,t.x+t.width),l=Math.max(e.y+e.height,t.y+t.height);return r.x=o,r.y=a,r.width=s-o,r.height=l-a,r},u.expand=function(e,t,r){if(!i(e))throw new n("rectangle is required.");if(!i(t))throw new n("point is required.");r=u.clone(e,r);var o=t.x-r.x,a=t.y-r.y;return o>r.width?r.width=o:0>o&&(r.width-=o,r.x=t.x),a>r.height?r.height=a:0>a&&(r.height-=a,r.y=t.y),r},u.intersect=function(e,t){if(!i(e))throw new n("left is required.");if(!i(t))throw new n("right is required.");var r=e.x,o=e.y,s=t.x,u=t.y;return r>s+t.width||r+e.width<s||o+e.height<u||o>u+t.height?a.OUTSIDE:a.INTERSECTING},u.equals=function(e,t){return e===t||i(e)&&i(t)&&e.x===t.x&&e.y===t.y&&e.width===t.width&&e.height===t.height},u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.intersect=function(e){return u.intersect(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u}),r("Core/Interval",["./defaultValue"],function(e){"use strict";var t=function(t,r){this.start=e(t,0),this.stop=e(r,0)};return t}),r("Core/Cartesian4",["./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,i,n){"use strict";var o=function(t,r,i,n){this.x=e(t,0),this.y=e(r,0),this.z=e(i,0),this.w=e(n,0)};o.fromElements=function(e,r,i,n,a){return t(a)?(a.x=e,a.y=r,a.z=i,a.w=n,a):new o(e,r,i,n)},o.fromColor=function(e,i){if(!t(e))throw new r("color is required");return t(i)?(i.x=e.red,i.y=e.green,i.z=e.blue,i.w=e.alpha,i):new o(e.red,e.green,e.blue,e.alpha)},o.clone=function(e,r){return t(e)?t(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new o(e.x,e.y,e.z,e.w):void 0},o.packedLength=4,o.pack=function(i,n,o){if(!t(i))throw new r("value is required");if(!t(n))throw new r("array is required");o=e(o,0),n[o++]=i.x,n[o++]=i.y,n[o++]=i.z,n[o]=i.w},o.unpack=function(i,n,a){if(!t(i))throw new r("array is required");return n=e(n,0),t(a)||(a=new o),a.x=i[n++],a.y=i[n++],a.z=i[n++],a.w=i[n],a},o.fromArray=o.unpack,o.maximumComponent=function(e){if(!t(e))throw new r("cartesian is required");return Math.max(e.x,e.y,e.z,e.w)},o.minimumComponent=function(e){if(!t(e))throw new r("cartesian is required");return Math.min(e.x,e.y,e.z,e.w)},o.minimumByComponent=function(e,i,n){if(!t(e))throw new r("first is required.");if(!t(i))throw new r("second is required.");if(!t(n))throw new r("result is required.");return n.x=Math.min(e.x,i.x),n.y=Math.min(e.y,i.y),n.z=Math.min(e.z,i.z),n.w=Math.min(e.w,i.w),n},o.maximumByComponent=function(e,i,n){if(!t(e))throw new r("first is required.");if(!t(i))throw new r("second is required.");if(!t(n))throw new r("result is required.");return n.x=Math.max(e.x,i.x),n.y=Math.max(e.y,i.y),n.z=Math.max(e.z,i.z),n.w=Math.max(e.w,i.w),n},o.magnitudeSquared=function(e){if(!t(e))throw new r("cartesian is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},o.magnitude=function(e){return Math.sqrt(o.magnitudeSquared(e))};var a=new o;o.distance=function(e,i){if(!t(e)||!t(i))throw new r("left and right are required.");return o.subtract(e,i,a),o.magnitude(a)},o.distanceSquared=function(e,i){if(!t(e)||!t(i))throw new r("left and right are required.");return o.subtract(e,i,a),o.magnitudeSquared(a)},o.normalize=function(e,i){if(!t(e))throw new r("cartesian is required");if(!t(i))throw new r("result is required");var n=o.magnitude(e);return i.x=e.x/n,i.y=e.y/n,i.z=e.z/n,i.w=e.w/n,i},o.dot=function(e,i){if(!t(e))throw new r("left is required");if(!t(i))throw new r("right is required");return e.x*i.x+e.y*i.y+e.z*i.z+e.w*i.w},o.multiplyComponents=function(e,i,n){if(!t(e))throw new r("left is required");if(!t(i))throw new r("right is required");if(!t(n))throw new r("result is required");return n.x=e.x*i.x,n.y=e.y*i.y,n.z=e.z*i.z,n.w=e.w*i.w,n},o.add=function(e,i,n){if(!t(e))throw new r("left is required");if(!t(i))throw new r("right is required");if(!t(n))throw new r("result is required");return n.x=e.x+i.x,n.y=e.y+i.y,n.z=e.z+i.z,n.w=e.w+i.w,n},o.subtract=function(e,i,n){if(!t(e))throw new r("left is required");if(!t(i))throw new r("right is required");if(!t(n))throw new r("result is required");return n.x=e.x-i.x,n.y=e.y-i.y,n.z=e.z-i.z,n.w=e.w-i.w,n},o.multiplyByScalar=function(e,i,n){if(!t(e))throw new r("cartesian is required");if("number"!=typeof i)throw new r("scalar is required and must be a number.");if(!t(n))throw new r("result is required");return n.x=e.x*i,n.y=e.y*i,n.z=e.z*i,n.w=e.w*i,n},o.divideByScalar=function(e,i,n){if(!t(e))throw new r("cartesian is required");if("number"!=typeof i)throw new r("scalar is required and must be a number.");if(!t(n))throw new r("result is required");return n.x=e.x/i,n.y=e.y/i,n.z=e.z/i,n.w=e.w/i,n},o.negate=function(e,i){if(!t(e))throw new r("cartesian is required");if(!t(i))throw new r("result is required");return i.x=-e.x,i.y=-e.y,i.z=-e.z,i.w=-e.w,i},o.abs=function(e,i){if(!t(e))throw new r("cartesian is required");if(!t(i))throw new r("result is required");return i.x=Math.abs(e.x),i.y=Math.abs(e.y),i.z=Math.abs(e.z),i.w=Math.abs(e.w),i};var s=new o;o.lerp=function(e,i,n,a){if(!t(e))throw new r("start is required.");if(!t(i))throw new r("end is required.");if("number"!=typeof n)throw new r("t is required and must be a number.");if(!t(a))throw new r("result is required.");return o.multiplyByScalar(i,n,s),a=o.multiplyByScalar(e,1-n,a),o.add(s,a,a)};var u=new o;return o.mostOrthogonalAxis=function(e,i){if(!t(e))throw new r("cartesian is required.");if(!t(i))throw new r("result is required.");var n=o.normalize(e,u);return o.abs(n,n),i=n.x<=n.y?n.x<=n.z?n.x<=n.w?o.clone(o.UNIT_X,i):o.clone(o.UNIT_W,i):n.z<=n.w?o.clone(o.UNIT_Z,i):o.clone(o.UNIT_W,i):n.y<=n.z?n.y<=n.w?o.clone(o.UNIT_Y,i):o.clone(o.UNIT_W,i):n.z<=n.w?o.clone(o.UNIT_Z,i):o.clone(o.UNIT_W,i)},o.equals=function(e,r){return e===r||t(e)&&t(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w},o.equalsArray=function(e,t,r){return e.x===t[r]&&e.y===t[r+1]&&e.z===t[r+2]&&e.w===t[r+3]},o.equalsEpsilon=function(e,r,i,o){return e===r||t(e)&&t(r)&&n.equalsEpsilon(e.x,r.x,i,o)&&n.equalsEpsilon(e.y,r.y,i,o)&&n.equalsEpsilon(e.z,r.z,i,o)&&n.equalsEpsilon(e.w,r.w,i,o)},o.ZERO=i(new o(0,0,0,0)),o.UNIT_X=i(new o(1,0,0,0)),o.UNIT_Y=i(new o(0,1,0,0)),o.UNIT_Z=i(new o(0,0,1,0)),o.UNIT_W=i(new o(0,0,0,1)),o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t,r){return o.equalsEpsilon(this,e,t,r)},o.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},o}),r("Core/Matrix3",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,i,n,o){"use strict";function a(e){for(var t=0,r=0;9>r;++r){var i=e[r];t+=i*i}return Math.sqrt(t)}function s(e){for(var t=0,r=0;3>r;++r){var i=e[l.getElementIndex(m[r],d[r])];t+=2*i*i}return Math.sqrt(t)}function u(e,t){for(var r=o.EPSILON15,i=0,n=1,a=0;3>a;++a){var s=Math.abs(e[l.getElementIndex(m[a],d[a])]);s>i&&(n=a,i=s)}var u=1,c=0,h=d[n],p=m[n];if(Math.abs(e[l.getElementIndex(p,h)])>r){var f,v=e[l.getElementIndex(p,p)],g=e[l.getElementIndex(h,h)],_=e[l.getElementIndex(p,h)],y=(v-g)/2/_;f=0>y?-1/(-y+Math.sqrt(1+y*y)):1/(y+Math.sqrt(1+y*y)),u=1/Math.sqrt(1+f*f),c=f*u}return t=l.clone(l.IDENTITY,t),t[l.getElementIndex(h,h)]=t[l.getElementIndex(p,p)]=u,t[l.getElementIndex(p,h)]=c,t[l.getElementIndex(h,p)]=-c,t}var l=function(e,r,i,n,o,a,s,u,l){this[0]=t(e,0),this[1]=t(n,0),this[2]=t(s,0),this[3]=t(r,0),this[4]=t(o,0),this[5]=t(u,0),this[6]=t(i,0),this[7]=t(a,0),this[8]=t(l,0)};l.packedLength=9,l.pack=function(e,n,o){if(!r(e))throw new i("value is required");if(!r(n))throw new i("array is required");o=t(o,0),n[o++]=e[0],n[o++]=e[1],n[o++]=e[2],n[o++]=e[3],n[o++]=e[4],n[o++]=e[5],n[o++]=e[6],n[o++]=e[7],n[o++]=e[8]},l.unpack=function(e,n,o){if(!r(e))throw new i("array is required");return n=t(n,0),r(o)||(o=new l),o[0]=e[n++],o[1]=e[n++],o[2]=e[n++],o[3]=e[n++],o[4]=e[n++],o[5]=e[n++],o[6]=e[n++],o[7]=e[n++],o[8]=e[n++],o},l.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new l(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]):void 0},l.fromArray=function(e,n,o){if(!r(e))throw new i("array is required");return n=t(n,0),r(o)||(o=new l),o[0]=e[n],o[1]=e[n+1],o[2]=e[n+2],o[3]=e[n+3],o[4]=e[n+4],o[5]=e[n+5],o[6]=e[n+6],o[7]=e[n+7],o[8]=e[n+8],o},l.fromColumnMajorArray=function(e,t){if(!r(e))throw new i("values parameter is required");return l.clone(e,t)},l.fromRowMajorArray=function(e,t){if(!r(e))throw new i("values is required.");return r(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},l.fromQuaternion=function(e,t){if(!r(e))throw new i("quaternion is required");var n=e.x*e.x,o=e.x*e.y,a=e.x*e.z,s=e.x*e.w,u=e.y*e.y,c=e.y*e.z,h=e.y*e.w,d=e.z*e.z,m=e.z*e.w,p=e.w*e.w,f=n-u-d+p,v=2*(o-m),g=2*(a+h),_=2*(o+m),y=-n+u-d+p,w=2*(c-s),C=2*(a-h),E=2*(c+s),S=-n-u+d+p;return r(t)?(t[0]=f,t[1]=_,t[2]=C,t[3]=v,t[4]=y,t[5]=E,t[6]=g,t[7]=w,t[8]=S,t):new l(f,v,g,_,y,w,C,E,S)},l.fromScale=function(e,t){if(!r(e))throw new i("scale is required.");return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new l(e.x,0,0,0,e.y,0,0,0,e.z)},l.fromUniformScale=function(e,t){if("number"!=typeof e)throw new i("scale is required.");return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new l(e,0,0,0,e,0,0,0,e)},l.fromCrossProduct=function(e,t){if(!r(e))throw new i("vector is required.");return r(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new l(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},l.fromRotationX=function(e,t){if(!r(e))throw new i("angle is required.");var n=Math.cos(e),o=Math.sin(e);return r(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=n,t[5]=o,t[6]=0,t[7]=-o,t[8]=n,t):new l(1,0,0,0,n,-o,0,o,n)},l.fromRotationY=function(e,t){if(!r(e))throw new i("angle is required.");var n=Math.cos(e),o=Math.sin(e);return r(t)?(t[0]=n,t[1]=0,t[2]=-o,t[3]=0,t[4]=1,t[5]=0,t[6]=o,t[7]=0,t[8]=n,t):new l(n,0,o,0,1,0,-o,0,n)},l.fromRotationZ=function(e,t){if(!r(e))throw new i("angle is required.");var n=Math.cos(e),o=Math.sin(e);return r(t)?(t[0]=n,t[1]=o,t[2]=0,t[3]=-o,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new l(n,-o,0,o,n,0,0,0,1)},l.toArray=function(e,t){if(!r(e))throw new i("matrix is required");return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},l.getElementIndex=function(e,t){if("number"!=typeof t||0>t||t>2)throw new i("row must be 0, 1, or 2.");if("number"!=typeof e||0>e||e>2)throw new i("column must be 0, 1, or 2.");return 3*e+t},l.getColumn=function(e,t,n){if(!r(e))throw new i("matrix is required.");if("number"!=typeof t||0>t||t>2)throw new i("index must be 0, 1, or 2.");if(!r(n))throw new i("result is required");var o=3*t,a=e[o],s=e[o+1],u=e[o+2];return n.x=a,n.y=s,n.z=u,n},l.setColumn=function(e,t,n,o){if(!r(e))throw new i("matrix is required");if(!r(n))throw new i("cartesian is required");if("number"!=typeof t||0>t||t>2)throw new i("index must be 0, 1, or 2.");if(!r(o))throw new i("result is required");o=l.clone(e,o);var a=3*t;return o[a]=n.x,o[a+1]=n.y,o[a+2]=n.z,o},l.getRow=function(e,t,n){if(!r(e))throw new i("matrix is required.");if("number"!=typeof t||0>t||t>2)throw new i("index must be 0, 1, or 2.");if(!r(n))throw new i("result is required");var o=e[t],a=e[t+3],s=e[t+6];return n.x=o,n.y=a,n.z=s,n},l.setRow=function(e,t,n,o){if(!r(e))throw new i("matrix is required");if(!r(n))throw new i("cartesian is required");if("number"!=typeof t||0>t||t>2)throw new i("index must be 0, 1, or 2.");if(!r(o))throw new i("result is required");return o=l.clone(e,o),o[t]=n.x,o[t+3]=n.y,o[t+6]=n.z,o};var c=new e;l.getScale=function(t,n){if(!r(t))throw new i("matrix is required.");if(!r(n))throw new i("result is required");return n.x=e.magnitude(e.fromElements(t[0],t[1],t[2],c)),n.y=e.magnitude(e.fromElements(t[3],t[4],t[5],c)),n.z=e.magnitude(e.fromElements(t[6],t[7],t[8],c)),n};var h=new e;l.getMaximumScale=function(t){return l.getScale(t,h),e.maximumComponent(h)},l.multiply=function(e,t,n){if(!r(e))throw new i("left is required");if(!r(t))throw new i("right is required");if(!r(n))throw new i("result is required");var o=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],a=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],s=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],u=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],l=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],c=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],h=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],d=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],m=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return n[0]=o,n[1]=a,n[2]=s,n[3]=u,n[4]=l,n[5]=c,n[6]=h,n[7]=d,n[8]=m,n},l.add=function(e,t,n){if(!r(e))throw new i("left is required");if(!r(t))throw new i("right is required");if(!r(n))throw new i("result is required");return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n},l.subtract=function(e,t,n){if(!r(e))throw new i("left is required");if(!r(t))throw new i("right is required");if(!r(n))throw new i("result is required");return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n},l.multiplyByVector=function(e,t,n){if(!r(e))throw new i("matrix is required");if(!r(t))throw new i("cartesian is required");if(!r(n))throw new i("result is required");var o=t.x,a=t.y,s=t.z,u=e[0]*o+e[3]*a+e[6]*s,l=e[1]*o+e[4]*a+e[7]*s,c=e[2]*o+e[5]*a+e[8]*s;return n.x=u,n.y=l,n.z=c,n},l.multiplyByScalar=function(e,t,n){if(!r(e))throw new i("matrix is required");if("number"!=typeof t)throw new i("scalar must be a number");if(!r(n))throw new i("result is required");return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n},l.multiplyByScale=function(e,t,n){if(!r(e))throw new i("matrix is required");if(!r(t))throw new i("scale is required");if(!r(n))throw new i("result is required");return n[0]=e[0]*t.x,n[1]=e[1]*t.x,n[2]=e[2]*t.x,n[3]=e[3]*t.y,n[4]=e[4]*t.y,n[5]=e[5]*t.y,n[6]=e[6]*t.z,n[7]=e[7]*t.z,n[8]=e[8]*t.z,n},l.negate=function(e,t){if(!r(e))throw new i("matrix is required");if(!r(t))throw new i("result is required");return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},l.transpose=function(e,t){if(!r(e))throw new i("matrix is required");if(!r(t))throw new i("result is required");var n=e[0],o=e[3],a=e[6],s=e[1],u=e[4],l=e[7],c=e[2],h=e[5],d=e[8];return t[0]=n,t[1]=o,t[2]=a,t[3]=s,t[4]=u,t[5]=l,t[6]=c,t[7]=h,t[8]=d,t};var d=[1,0,0],m=[2,2,1],p=new l,f=new l;return l.computeEigenDecomposition=function(e,t){if(!r(e))throw new i("matrix is required.");var n=o.EPSILON20,c=10,h=0,d=0;r(t)||(t={});for(var m=t.unitary=l.clone(l.IDENTITY,t.unitary),v=t.diagonal=l.clone(e,t.diagonal),g=n*a(v);c>d&&s(v)>g;)u(v,p),l.transpose(p,f),l.multiply(v,p,v),l.multiply(f,v,v),l.multiply(m,p,m),++h>2&&(++d,h=0);return t},l.abs=function(e,t){if(!r(e))throw new i("matrix is required");if(!r(t))throw new i("result is required");return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},l.determinant=function(e){if(!r(e))throw new i("matrix is required");var t=e[0],n=e[3],o=e[6],a=e[1],s=e[4],u=e[7],l=e[2],c=e[5],h=e[8];return t*(s*h-c*u)+a*(c*o-n*h)+l*(n*u-s*o)},l.inverse=function(e,t){if(!r(e))throw new i("matrix is required");if(!r(t))throw new i("result is required");var n=e[0],a=e[1],s=e[2],u=e[3],c=e[4],h=e[5],d=e[6],m=e[7],p=e[8],f=l.determinant(e);if(Math.abs(f)<=o.EPSILON15)throw new i("matrix is not invertible");t[0]=c*p-m*h,t[1]=m*s-a*p,t[2]=a*h-c*s,t[3]=d*h-u*p,t[4]=n*p-d*s,t[5]=u*s-n*h,t[6]=u*m-d*c,t[7]=d*a-n*m,t[8]=n*c-u*a;var v=1/f;return l.multiplyByScalar(t,v,t)},l.equals=function(e,t){return e===t||r(e)&&r(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},l.equalsEpsilon=function(e,t,n){if("number"!=typeof n)throw new i("epsilon must be a number");return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n},l.IDENTITY=n(new l(1,0,0,0,1,0,0,0,1)),l.ZERO=n(new l(0,0,0,0,0,0,0,0,0)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN1ROW0=3,l.COLUMN1ROW1=4,l.COLUMN1ROW2=5,l.COLUMN2ROW0=6,l.COLUMN2ROW1=7,l.COLUMN2ROW2=8,l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]},l.prototype.equalsEpsilon=function(e,t){return l.equalsEpsilon(this,e,t)},l.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},l}),r("Core/Matrix4",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./freezeObject","./Math","./Matrix3","./RuntimeError"],function(e,t,r,i,n,o,a,s,u){"use strict";var l=function(e,t,i,n,o,a,s,u,l,c,h,d,m,p,f,v){this[0]=r(e,0),this[1]=r(o,0),this[2]=r(l,0),this[3]=r(m,0),this[4]=r(t,0),this[5]=r(a,0),this[6]=r(c,0),this[7]=r(p,0),this[8]=r(i,0),this[9]=r(s,0),this[10]=r(h,0),this[11]=r(f,0),this[12]=r(n,0),this[13]=r(u,0),this[14]=r(d,0),this[15]=r(v,0)};l.packedLength=16,l.pack=function(e,t,o){if(!i(e))throw new n("value is required");if(!i(t))throw new n("array is required");o=r(o,0),t[o++]=e[0],t[o++]=e[1],t[o++]=e[2],t[o++]=e[3],t[o++]=e[4],t[o++]=e[5],t[o++]=e[6],t[o++]=e[7],t[o++]=e[8],t[o++]=e[9],t[o++]=e[10],t[o++]=e[11],t[o++]=e[12],t[o++]=e[13],t[o++]=e[14],t[o]=e[15]},l.unpack=function(e,t,o){if(!i(e))throw new n("array is required");return t=r(t,0),i(o)||(o=new l),o[0]=e[t++],o[1]=e[t++],o[2]=e[t++],o[3]=e[t++],o[4]=e[t++],o[5]=e[t++],o[6]=e[t++],o[7]=e[t++],o[8]=e[t++],o[9]=e[t++],o[10]=e[t++],o[11]=e[t++],o[12]=e[t++],o[13]=e[t++],o[14]=e[t++],o[15]=e[t],o},l.clone=function(e,t){return i(e)?i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new l(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15]):void 0},l.fromArray=l.unpack,l.fromColumnMajorArray=function(e,t){if(!i(e))throw new n("values is required");return l.clone(e,t)},l.fromRowMajorArray=function(e,t){if(!i(e))throw new n("values is required.");return i(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new l(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},l.fromRotationTranslation=function(t,o,a){if(!i(t))throw new n("rotation is required.");return o=r(o,e.ZERO),i(a)?(a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=0,a[4]=t[3],a[5]=t[4],a[6]=t[5],a[7]=0,a[8]=t[6],a[9]=t[7],a[10]=t[8],a[11]=0,a[12]=o.x,a[13]=o.y,a[14]=o.z,a[15]=1,a):new l(t[0],t[3],t[6],o.x,t[1],t[4],t[7],o.y,t[2],t[5],t[8],o.z,0,0,0,1)},l.fromTranslationQuaternionRotationScale=function(e,t,r,o){if(!i(e))throw new n("translation is required.");if(!i(t))throw new n("rotation is required.");if(!i(r))throw new n("scale is required.");i(o)||(o=new l);var a=r.x,s=r.y,u=r.z,c=t.x*t.x,h=t.x*t.y,d=t.x*t.z,m=t.x*t.w,p=t.y*t.y,f=t.y*t.z,v=t.y*t.w,g=t.z*t.z,_=t.z*t.w,y=t.w*t.w,w=c-p-g+y,C=2*(h-_),E=2*(d+v),S=2*(h+_),b=-c+p-g+y,T=2*(f-m),x=2*(d-v),P=2*(f+m),A=-c-p+g+y;return o[0]=w*a,o[1]=S*a,o[2]=x*a,o[3]=0,o[4]=C*s,o[5]=b*s,o[6]=P*s,o[7]=0,o[8]=E*u,o[9]=T*u,o[10]=A*u,o[11]=0,o[12]=e.x,o[13]=e.y,o[14]=e.z,o[15]=1,o},l.fromTranslation=function(e,t){if(!i(e))throw new n("translation is required.");return l.fromRotationTranslation(s.IDENTITY,e,t)},l.fromScale=function(e,t){if(!i(e))throw new n("scale is required.");return i(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new l(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},l.fromUniformScale=function(e,t){if("number"!=typeof e)throw new n("scale is required.");return i(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new l(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var c=new e,h=new e,d=new e;l.fromCamera=function(t,r){if(!i(t))throw new n("camera is required.");var o=t.eye,a=t.target,s=t.up;if(!i(o))throw new n("camera.eye is required.");if(!i(a))throw new n("camera.target is required.");if(!i(s))throw new n("camera.up is required.");e.normalize(e.subtract(a,o,c),c),e.normalize(e.cross(c,s,h),h),e.normalize(e.cross(h,c,d),d);var u=h.x,m=h.y,p=h.z,f=c.x,v=c.y,g=c.z,_=d.x,y=d.y,w=d.z,C=o.x,E=o.y,S=o.z,b=u*-C+m*-E+p*-S,T=_*-C+y*-E+w*-S,x=f*C+v*E+g*S;return i(r)?(r[0]=u,r[1]=_,r[2]=-f,r[3]=0,r[4]=m,r[5]=y,r[6]=-v,r[7]=0,r[8]=p,r[9]=w,r[10]=-g,r[11]=0,r[12]=b,r[13]=T,r[14]=x,r[15]=1,r):new l(u,m,p,b,_,y,w,T,-f,-v,-g,x,0,0,0,1)},l.computePerspectiveFieldOfView=function(e,t,r,o,a){if(0>=e||e>Math.PI)throw new n("fovY must be in [0, PI).");if(0>=t)throw new n("aspectRatio must be greater than zero.");if(0>=r)throw new n("near must be greater than zero.");if(0>=o)throw new n("far must be greater than zero.");if(!i(a))throw new n("result is required");var s=Math.tan(.5*e),u=1/s,l=u/t,c=(o+r)/(r-o),h=2*o*r/(r-o);return a[0]=l,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=u,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=c,a[11]=-1,a[12]=0,a[13]=0,a[14]=h,a[15]=0,a},l.computeOrthographicOffCenter=function(e,t,r,o,a,s,u){if(!i(e))throw new n("left is required.");if(!i(t))throw new n("right is required.");if(!i(r))throw new n("bottom is required.");if(!i(o))throw new n("top is required.");if(!i(a))throw new n("near is required.");if(!i(s))throw new n("far is required.");if(!i(u))throw new n("result is required");var l=1/(t-e),c=1/(o-r),h=1/(s-a),d=-(t+e)*l,m=-(o+r)*c,p=-(s+a)*h;return l*=2,c*=2,h*=-2,u[0]=l,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=0,u[9]=0,u[10]=h,u[11]=0,u[12]=d,u[13]=m,u[14]=p,u[15]=1,u},l.computePerspectiveOffCenter=function(e,t,r,o,a,s,u){if(!i(e))throw new n("left is required.");if(!i(t))throw new n("right is required.");if(!i(r))throw new n("bottom is required.");if(!i(o))throw new n("top is required.");if(!i(a))throw new n("near is required.");if(!i(s))throw new n("far is required.");if(!i(u))throw new n("result is required");var l=2*a/(t-e),c=2*a/(o-r),h=(t+e)/(t-e),d=(o+r)/(o-r),m=-(s+a)/(s-a),p=-1,f=-2*s*a/(s-a);return u[0]=l,u[1]=0,u[2]=0,u[3]=0,u[4]=0,u[5]=c,u[6]=0,u[7]=0,u[8]=h,u[9]=d,u[10]=m,u[11]=p,u[12]=0,u[13]=0,u[14]=f,u[15]=0,u},l.computeInfinitePerspectiveOffCenter=function(e,t,r,o,a,s){if(!i(e))throw new n("left is required.");if(!i(t))throw new n("right is required.");if(!i(r))throw new n("bottom is required.");if(!i(o))throw new n("top is required.");if(!i(a))throw new n("near is required.");if(!i(s))throw new n("result is required");var u=2*a/(t-e),l=2*a/(o-r),c=(t+e)/(t-e),h=(o+r)/(o-r),d=-1,m=-1,p=-2*a;return s[0]=u,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=l,s[6]=0,s[7]=0,s[8]=c,s[9]=h,s[10]=d,s[11]=m,s[12]=0,s[13]=0,s[14]=p,s[15]=0,s},l.computeViewportTransformation=function(e,t,o,a){if(!i(a))throw new n("result is required");e=r(e,r.EMPTY_OBJECT);var s=r(e.x,0),u=r(e.y,0),l=r(e.width,0),c=r(e.height,0);t=r(t,0),o=r(o,1);var h=.5*l,d=.5*c,m=.5*(o-t),p=h,f=d,v=m,g=s+h,_=u+d,y=t+m,w=1;return a[0]=p,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=f,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=v,a[11]=0,a[12]=g,a[13]=_,a[14]=y,a[15]=w,a},l.toArray=function(e,t){if(!i(e))throw new n("matrix is required");return i(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},l.getElementIndex=function(e,t){if("number"!=typeof t||0>t||t>3)throw new n("row must be 0, 1, 2, or 3.");if("number"!=typeof e||0>e||e>3)throw new n("column must be 0, 1, 2, or 3.");return 4*e+t},l.getColumn=function(e,t,r){if(!i(e))throw new n("matrix is required.");if("number"!=typeof t||0>t||t>3)throw new n("index must be 0, 1, 2, or 3.");if(!i(r))throw new n("result is required");var o=4*t,a=e[o],s=e[o+1],u=e[o+2],l=e[o+3];return r.x=a,r.y=s,r.z=u,r.w=l,r},l.setColumn=function(e,t,r,o){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("cartesian is required");if("number"!=typeof t||0>t||t>3)throw new n("index must be 0, 1, 2, or 3.");if(!i(o))throw new n("result is required");o=l.clone(e,o);var a=4*t;return o[a]=r.x,o[a+1]=r.y,o[a+2]=r.z,o[a+3]=r.w,o},l.setTranslation=function(e,t,r){
if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("translation is required");if(!i(r))throw new n("result is required");return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=t.x,r[13]=t.y,r[14]=t.z,r[15]=e[15],r},l.getRow=function(e,t,r){if(!i(e))throw new n("matrix is required.");if("number"!=typeof t||0>t||t>3)throw new n("index must be 0, 1, 2, or 3.");if(!i(r))throw new n("result is required");var o=e[t],a=e[t+4],s=e[t+8],u=e[t+12];return r.x=o,r.y=a,r.z=s,r.w=u,r},l.setRow=function(e,t,r,o){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("cartesian is required");if("number"!=typeof t||0>t||t>3)throw new n("index must be 0, 1, 2, or 3.");if(!i(o))throw new n("result is required");return o=l.clone(e,o),o[t]=r.x,o[t+4]=r.y,o[t+8]=r.z,o[t+12]=r.w,o};var m=new e;l.getScale=function(t,r){if(!i(t))throw new n("matrix is required.");if(!i(r))throw new n("result is required");return r.x=e.magnitude(e.fromElements(t[0],t[1],t[2],m)),r.y=e.magnitude(e.fromElements(t[4],t[5],t[6],m)),r.z=e.magnitude(e.fromElements(t[8],t[9],t[10],m)),r};var p=new e;l.getMaximumScale=function(t){return l.getScale(t,p),e.maximumComponent(p)},l.multiply=function(e,t,r){if(!i(e))throw new n("left is required");if(!i(t))throw new n("right is required");if(!i(r))throw new n("result is required");var o=e[0],a=e[1],s=e[2],u=e[3],l=e[4],c=e[5],h=e[6],d=e[7],m=e[8],p=e[9],f=e[10],v=e[11],g=e[12],_=e[13],y=e[14],w=e[15],C=t[0],E=t[1],S=t[2],b=t[3],T=t[4],x=t[5],P=t[6],A=t[7],I=t[8],D=t[9],M=t[10],R=t[11],O=t[12],N=t[13],L=t[14],F=t[15],B=o*C+l*E+m*S+g*b,z=a*C+c*E+p*S+_*b,V=s*C+h*E+f*S+y*b,k=u*C+d*E+v*S+w*b,U=o*T+l*x+m*P+g*A,q=a*T+c*x+p*P+_*A,G=s*T+h*x+f*P+y*A,W=u*T+d*x+v*P+w*A,H=o*I+l*D+m*M+g*R,j=a*I+c*D+p*M+_*R,Y=s*I+h*D+f*M+y*R,X=u*I+d*D+v*M+w*R,Z=o*O+l*N+m*L+g*F,K=a*O+c*N+p*L+_*F,Q=s*O+h*N+f*L+y*F,J=u*O+d*N+v*L+w*F;return r[0]=B,r[1]=z,r[2]=V,r[3]=k,r[4]=U,r[5]=q,r[6]=G,r[7]=W,r[8]=H,r[9]=j,r[10]=Y,r[11]=X,r[12]=Z,r[13]=K,r[14]=Q,r[15]=J,r},l.add=function(e,t,r){if(!i(e))throw new n("left is required");if(!i(t))throw new n("right is required");if(!i(r))throw new n("result is required");return r[0]=e[0]+t[0],r[1]=e[1]+t[1],r[2]=e[2]+t[2],r[3]=e[3]+t[3],r[4]=e[4]+t[4],r[5]=e[5]+t[5],r[6]=e[6]+t[6],r[7]=e[7]+t[7],r[8]=e[8]+t[8],r[9]=e[9]+t[9],r[10]=e[10]+t[10],r[11]=e[11]+t[11],r[12]=e[12]+t[12],r[13]=e[13]+t[13],r[14]=e[14]+t[14],r[15]=e[15]+t[15],r},l.subtract=function(e,t,r){if(!i(e))throw new n("left is required");if(!i(t))throw new n("right is required");if(!i(r))throw new n("result is required");return r[0]=e[0]-t[0],r[1]=e[1]-t[1],r[2]=e[2]-t[2],r[3]=e[3]-t[3],r[4]=e[4]-t[4],r[5]=e[5]-t[5],r[6]=e[6]-t[6],r[7]=e[7]-t[7],r[8]=e[8]-t[8],r[9]=e[9]-t[9],r[10]=e[10]-t[10],r[11]=e[11]-t[11],r[12]=e[12]-t[12],r[13]=e[13]-t[13],r[14]=e[14]-t[14],r[15]=e[15]-t[15],r},l.multiplyTransformation=function(e,t,r){if(!i(e))throw new n("left is required");if(!i(t))throw new n("right is required");if(!i(r))throw new n("result is required");var o=e[0],a=e[1],s=e[2],u=e[4],l=e[5],c=e[6],h=e[8],d=e[9],m=e[10],p=e[12],f=e[13],v=e[14],g=t[0],_=t[1],y=t[2],w=t[4],C=t[5],E=t[6],S=t[8],b=t[9],T=t[10],x=t[12],P=t[13],A=t[14],I=o*g+u*_+h*y,D=a*g+l*_+d*y,M=s*g+c*_+m*y,R=o*w+u*C+h*E,O=a*w+l*C+d*E,N=s*w+c*C+m*E,L=o*S+u*b+h*T,F=a*S+l*b+d*T,B=s*S+c*b+m*T,z=o*x+u*P+h*A+p,V=a*x+l*P+d*A+f,k=s*x+c*P+m*A+v;return r[0]=I,r[1]=D,r[2]=M,r[3]=0,r[4]=R,r[5]=O,r[6]=N,r[7]=0,r[8]=L,r[9]=F,r[10]=B,r[11]=0,r[12]=z,r[13]=V,r[14]=k,r[15]=1,r},l.multiplyByMatrix3=function(e,t,r){if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("rotation is required");if(!i(r))throw new n("result is required");var o=e[0],a=e[1],s=e[2],u=e[4],l=e[5],c=e[6],h=e[8],d=e[9],m=e[10],p=t[0],f=t[1],v=t[2],g=t[3],_=t[4],y=t[5],w=t[6],C=t[7],E=t[8],S=o*p+u*f+h*v,b=a*p+l*f+d*v,T=s*p+c*f+m*v,x=o*g+u*_+h*y,P=a*g+l*_+d*y,A=s*g+c*_+m*y,I=o*w+u*C+h*E,D=a*w+l*C+d*E,M=s*w+c*C+m*E;return r[0]=S,r[1]=b,r[2]=T,r[3]=0,r[4]=x,r[5]=P,r[6]=A,r[7]=0,r[8]=I,r[9]=D,r[10]=M,r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r},l.multiplyByTranslation=function(e,t,r){if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("translation is required");if(!i(r))throw new n("result is required");var o=t.x,a=t.y,s=t.z,u=o*e[0]+a*e[4]+s*e[8]+e[12],l=o*e[1]+a*e[5]+s*e[9]+e[13],c=o*e[2]+a*e[6]+s*e[10]+e[14];return r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=u,r[13]=l,r[14]=c,r[15]=e[15],r};var f=new e;l.multiplyByUniformScale=function(e,t,r){if(!i(e))throw new n("matrix is required");if("number"!=typeof t)throw new n("scale is required");if(!i(r))throw new n("result is required");return f.x=t,f.y=t,f.z=t,l.multiplyByScale(e,f,r)},l.multiplyByScale=function(e,t,r){if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("scale is required");if(!i(r))throw new n("result is required");var o=t.x,a=t.y,s=t.z;return 1===o&&1===a&&1===s?l.clone(e,r):(r[0]=o*e[0],r[1]=o*e[1],r[2]=o*e[2],r[3]=0,r[4]=a*e[4],r[5]=a*e[5],r[6]=a*e[6],r[7]=0,r[8]=s*e[8],r[9]=s*e[9],r[10]=s*e[10],r[11]=0,r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=1,r)},l.multiplyByVector=function(e,t,r){if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("cartesian is required");if(!i(r))throw new n("result is required");var o=t.x,a=t.y,s=t.z,u=t.w,l=e[0]*o+e[4]*a+e[8]*s+e[12]*u,c=e[1]*o+e[5]*a+e[9]*s+e[13]*u,h=e[2]*o+e[6]*a+e[10]*s+e[14]*u,d=e[3]*o+e[7]*a+e[11]*s+e[15]*u;return r.x=l,r.y=c,r.z=h,r.w=d,r},l.multiplyByPointAsVector=function(e,t,r){if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("cartesian is required");if(!i(r))throw new n("result is required");var o=t.x,a=t.y,s=t.z,u=e[0]*o+e[4]*a+e[8]*s,l=e[1]*o+e[5]*a+e[9]*s,c=e[2]*o+e[6]*a+e[10]*s;return r.x=u,r.y=l,r.z=c,r},l.multiplyByPoint=function(e,t,r){if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("cartesian is required");if(!i(r))throw new n("result is required");var o=t.x,a=t.y,s=t.z,u=e[0]*o+e[4]*a+e[8]*s+e[12],l=e[1]*o+e[5]*a+e[9]*s+e[13],c=e[2]*o+e[6]*a+e[10]*s+e[14];return r.x=u,r.y=l,r.z=c,r},l.multiplyByScalar=function(e,t,r){if(!i(e))throw new n("matrix is required");if("number"!=typeof t)throw new n("scalar must be a number");if(!i(r))throw new n("result is required");return r[0]=e[0]*t,r[1]=e[1]*t,r[2]=e[2]*t,r[3]=e[3]*t,r[4]=e[4]*t,r[5]=e[5]*t,r[6]=e[6]*t,r[7]=e[7]*t,r[8]=e[8]*t,r[9]=e[9]*t,r[10]=e[10]*t,r[11]=e[11]*t,r[12]=e[12]*t,r[13]=e[13]*t,r[14]=e[14]*t,r[15]=e[15]*t,r},l.negate=function(e,t){if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("result is required");return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},l.transpose=function(e,t){if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("result is required");var r=e[1],o=e[2],a=e[3],s=e[6],u=e[7],l=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=r,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=o,t[9]=s,t[10]=e[10],t[11]=e[14],t[12]=a,t[13]=u,t[14]=l,t[15]=e[15],t},l.abs=function(e,t){if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("result is required");return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},l.equals=function(e,t){return e===t||i(e)&&i(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},l.equalsEpsilon=function(e,t,r){if("number"!=typeof r)throw new n("epsilon must be a number");return e===t||i(e)&&i(t)&&Math.abs(e[0]-t[0])<=r&&Math.abs(e[1]-t[1])<=r&&Math.abs(e[2]-t[2])<=r&&Math.abs(e[3]-t[3])<=r&&Math.abs(e[4]-t[4])<=r&&Math.abs(e[5]-t[5])<=r&&Math.abs(e[6]-t[6])<=r&&Math.abs(e[7]-t[7])<=r&&Math.abs(e[8]-t[8])<=r&&Math.abs(e[9]-t[9])<=r&&Math.abs(e[10]-t[10])<=r&&Math.abs(e[11]-t[11])<=r&&Math.abs(e[12]-t[12])<=r&&Math.abs(e[13]-t[13])<=r&&Math.abs(e[14]-t[14])<=r&&Math.abs(e[15]-t[15])<=r},l.getTranslation=function(e,t){if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("result is required");return t.x=e[12],t.y=e[13],t.z=e[14],t},l.getRotation=function(e,t){if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("result is required");return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var v=new s,g=new s,_=new t,y=new t(0,0,0,1);return l.inverse=function(e,r){if(!i(e))throw new n("matrix is required");if(!i(r))throw new n("result is required");if(s.equalsEpsilon(l.getRotation(e,v),g,a.EPSILON7)&&t.equals(l.getRow(e,3,_),y))return r[0]=0,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=0,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=0,r[11]=0,r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=1,r;var o=e[0],c=e[4],h=e[8],d=e[12],m=e[1],p=e[5],f=e[9],w=e[13],C=e[2],E=e[6],S=e[10],b=e[14],T=e[3],x=e[7],P=e[11],A=e[15],I=S*A,D=b*P,M=E*A,R=b*x,O=E*P,N=S*x,L=C*A,F=b*T,B=C*P,z=S*T,V=C*x,k=E*T,U=I*p+R*f+O*w-(D*p+M*f+N*w),q=D*m+L*f+z*w-(I*m+F*f+B*w),G=M*m+F*p+V*w-(R*m+L*p+k*w),W=N*m+B*p+k*f-(O*m+z*p+V*f),H=D*c+M*h+N*d-(I*c+R*h+O*d),j=I*o+F*h+B*d-(D*o+L*h+z*d),Y=R*o+L*c+k*d-(M*o+F*c+V*d),X=O*o+z*c+V*h-(N*o+B*c+k*h);I=h*w,D=d*f,M=c*w,R=d*p,O=c*f,N=h*p,L=o*w,F=d*m,B=o*f,z=h*m,V=o*p,k=c*m;var Z=I*x+R*P+O*A-(D*x+M*P+N*A),K=D*T+L*P+z*A-(I*T+F*P+B*A),Q=M*T+F*x+V*A-(R*T+L*x+k*A),J=N*T+B*x+k*P-(O*T+z*x+V*P),$=M*S+N*b+D*E-(O*b+I*E+R*S),ee=B*b+I*C+F*S-(L*S+z*b+D*C),te=L*E+k*b+R*C-(V*b+M*C+F*E),re=V*S+O*C+z*E-(B*E+k*S+N*C),ie=o*U+c*q+h*G+d*W;if(Math.abs(ie)<a.EPSILON20)throw new u("matrix is not invertible because its determinate is zero.");return ie=1/ie,r[0]=U*ie,r[1]=q*ie,r[2]=G*ie,r[3]=W*ie,r[4]=H*ie,r[5]=j*ie,r[6]=Y*ie,r[7]=X*ie,r[8]=Z*ie,r[9]=K*ie,r[10]=Q*ie,r[11]=J*ie,r[12]=$*ie,r[13]=ee*ie,r[14]=te*ie,r[15]=re*ie,r},l.inverseTransformation=function(e,t){if(!i(e))throw new n("matrix is required");if(!i(t))throw new n("result is required");var r=e[0],o=e[1],a=e[2],s=e[4],u=e[5],l=e[6],c=e[8],h=e[9],d=e[10],m=e[12],p=e[13],f=e[14],v=-r*m-o*p-a*f,g=-s*m-u*p-l*f,_=-c*m-h*p-d*f;return t[0]=r,t[1]=s,t[2]=c,t[3]=0,t[4]=o,t[5]=u,t[6]=h,t[7]=0,t[8]=a,t[9]=l,t[10]=d,t[11]=0,t[12]=v,t[13]=g,t[14]=_,t[15]=1,t},l.IDENTITY=o(new l(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),l.ZERO=o(new l(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),l.COLUMN0ROW0=0,l.COLUMN0ROW1=1,l.COLUMN0ROW2=2,l.COLUMN0ROW3=3,l.COLUMN1ROW0=4,l.COLUMN1ROW1=5,l.COLUMN1ROW2=6,l.COLUMN1ROW3=7,l.COLUMN2ROW0=8,l.COLUMN2ROW1=9,l.COLUMN2ROW2=10,l.COLUMN2ROW3=11,l.COLUMN3ROW0=12,l.COLUMN3ROW1=13,l.COLUMN3ROW2=14,l.COLUMN3ROW3=15,l.prototype.clone=function(e){return l.clone(this,e)},l.prototype.equals=function(e){return l.equals(this,e)},l.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]&&e[4]===t[r+4]&&e[5]===t[r+5]&&e[6]===t[r+6]&&e[7]===t[r+7]&&e[8]===t[r+8]&&e[9]===t[r+9]&&e[10]===t[r+10]&&e[11]===t[r+11]&&e[12]===t[r+12]&&e[13]===t[r+13]&&e[14]===t[r+14]&&e[15]===t[r+15]},l.prototype.equalsEpsilon=function(e,t){return l.equalsEpsilon(this,e,t)},l.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"},l}),r("Core/BoundingSphere",["./Cartesian3","./Cartographic","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Ellipsoid","./GeographicProjection","./Intersect","./Interval","./Matrix4","./Plane","./Rectangle"],function(e,t,r,i,n,o,a,s,u,l,c,h,d){"use strict";var m=function(t,i){this.center=e.clone(r(t,e.ZERO)),this.radius=r(i,0)},p=new e,f=new e,v=new e,g=new e,_=new e,y=new e,w=new e,C=new e,E=new e,S=new e,b=new e,T=new e;m.fromPoints=function(t,r){if(i(r)||(r=new m),!i(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;for(var n=e.clone(t[0],w),o=e.clone(n,p),a=e.clone(n,f),s=e.clone(n,v),u=e.clone(n,g),l=e.clone(n,_),c=e.clone(n,y),h=t.length,d=1;h>d;d++){e.clone(t[d],n);var x=n.x,P=n.y,A=n.z;x<o.x&&e.clone(n,o),x>u.x&&e.clone(n,u),P<a.y&&e.clone(n,a),P>l.y&&e.clone(n,l),A<s.z&&e.clone(n,s),A>c.z&&e.clone(n,c)}var I=e.magnitudeSquared(e.subtract(u,o,C)),D=e.magnitudeSquared(e.subtract(l,a,C)),M=e.magnitudeSquared(e.subtract(c,s,C)),R=o,O=u,N=I;D>N&&(N=D,R=a,O=l),M>N&&(N=M,R=s,O=c);var L=E;L.x=.5*(R.x+O.x),L.y=.5*(R.y+O.y),L.z=.5*(R.z+O.z);var F=e.magnitudeSquared(e.subtract(O,L,C)),B=Math.sqrt(F),z=S;z.x=o.x,z.y=a.y,z.z=s.z;var V=b;V.x=u.x,V.y=l.y,V.z=c.z;var k=e.multiplyByScalar(e.add(z,V,C),.5,T),U=0;for(d=0;h>d;d++){e.clone(t[d],n);var q=e.magnitude(e.subtract(n,k,C));q>U&&(U=q);var G=e.magnitudeSquared(e.subtract(n,L,C));if(G>F){var W=Math.sqrt(G);B=.5*(B+W),F=B*B;var H=W-B;L.x=(B*L.x+H*n.x)/W,L.y=(B*L.y+H*n.y)/W,L.z=(B*L.z+H*n.z)/W}}return U>B?(e.clone(L,r.center),r.radius=B):(e.clone(k,r.center),r.radius=U),r};var x=new s,P=new e,A=new e,I=new t,D=new t;m.fromRectangle2D=function(e,t,r){return m.fromRectangleWithHeights2D(e,t,0,0,r)},m.fromRectangleWithHeights2D=function(t,n,o,a,s){if(i(s)||(s=new m),!i(t))return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;n=r(n,x),d.southwest(t,I),I.height=o,d.northeast(t,D),D.height=a;var u=n.project(I,P),l=n.project(D,A),c=l.x-u.x,h=l.y-u.y,p=l.z-u.z;s.radius=.5*Math.sqrt(c*c+h*h+p*p);var f=s.center;return f.x=u.x+.5*c,f.y=u.y+.5*h,f.z=u.z+.5*p,s};var M=[];m.fromRectangle3D=function(e,t,n,o){t=r(t,a.WGS84),n=r(n,0);var s;return i(e)&&(s=d.subsample(e,t,n,M)),m.fromPoints(s,o)},m.fromVertices=function(t,n,a,s){if(i(s)||(s=new m),!i(t)||0===t.length)return s.center=e.clone(e.ZERO,s.center),s.radius=0,s;if(n=r(n,e.ZERO),a=r(a,3),3>a)throw new o("stride must be 3 or greater.");var u=w;u.x=t[0]+n.x,u.y=t[1]+n.y,u.z=t[2]+n.z;for(var l=e.clone(u,p),c=e.clone(u,f),h=e.clone(u,v),d=e.clone(u,g),x=e.clone(u,_),P=e.clone(u,y),A=t.length,I=0;A>I;I+=a){var D=t[I]+n.x,M=t[I+1]+n.y,R=t[I+2]+n.z;u.x=D,u.y=M,u.z=R,D<l.x&&e.clone(u,l),D>d.x&&e.clone(u,d),M<c.y&&e.clone(u,c),M>x.y&&e.clone(u,x),R<h.z&&e.clone(u,h),R>P.z&&e.clone(u,P)}var O=e.magnitudeSquared(e.subtract(d,l,C)),N=e.magnitudeSquared(e.subtract(x,c,C)),L=e.magnitudeSquared(e.subtract(P,h,C)),F=l,B=d,z=O;N>z&&(z=N,F=c,B=x),L>z&&(z=L,F=h,B=P);var V=E;V.x=.5*(F.x+B.x),V.y=.5*(F.y+B.y),V.z=.5*(F.z+B.z);var k=e.magnitudeSquared(e.subtract(B,V,C)),U=Math.sqrt(k),q=S;q.x=l.x,q.y=c.y,q.z=h.z;var G=b;G.x=d.x,G.y=x.y,G.z=P.z;var W=e.multiplyByScalar(e.add(q,G,C),.5,T),H=0;for(I=0;A>I;I+=a){u.x=t[I]+n.x,u.y=t[I+1]+n.y,u.z=t[I+2]+n.z;var j=e.magnitude(e.subtract(u,W,C));j>H&&(H=j);var Y=e.magnitudeSquared(e.subtract(u,V,C));if(Y>k){var X=Math.sqrt(Y);U=.5*(U+X),k=U*U;var Z=X-U;V.x=(U*V.x+Z*u.x)/X,V.y=(U*V.y+Z*u.y)/X,V.z=(U*V.z+Z*u.z)/X}}return H>U?(e.clone(V,s.center),s.radius=U):(e.clone(W,s.center),s.radius=H),s},m.fromCornerPoints=function(t,r,n){if(!i(t)||!i(r))throw new o("corner and oppositeCorner are required.");i(n)||(n=new m);var a=n.center;return e.add(t,r,a),e.multiplyByScalar(a,.5,a),n.radius=e.distance(a,r),n},m.fromEllipsoid=function(t,r){if(!i(t))throw new o("ellipsoid is required.");return i(r)||(r=new m),e.clone(e.ZERO,r.center),r.radius=t.maximumRadius,r};var R=new e;m.fromBoundingSpheres=function(t,r){if(i(r)||(r=new m),!i(t)||0===t.length)return r.center=e.clone(e.ZERO,r.center),r.radius=0,r;var n=t.length;if(1===n)return m.clone(t[0],r);if(2===n)return m.union(t[0],t[1],r);for(var o=[],a=0;n>a;a++)o.push(t[a].center);r=m.fromPoints(o,r);var s=r.center,u=r.radius;for(a=0;n>a;a++){var l=t[a];u=Math.max(u,e.distance(s,l.center,R)+l.radius)}return r.radius=u,r},m.clone=function(t,r){return i(t)?i(r)?(r.center=e.clone(t.center,r.center),r.radius=t.radius,r):new m(t.center,t.radius):void 0},m.packedLength=4,m.pack=function(e,t,n){if(!i(e))throw new o("value is required");if(!i(t))throw new o("array is required");n=r(n,0);var a=e.center;t[n++]=a.x,t[n++]=a.y,t[n++]=a.z,t[n]=e.radius},m.unpack=function(e,t,n){if(!i(e))throw new o("array is required");t=r(t,0),i(n)||(n=new m);var a=n.center;return a.x=e[t++],a.y=e[t++],a.z=e[t++],n.radius=e[t],n};var O=new e,N=new e;m.union=function(t,r,n){if(!i(t))throw new o("left is required.");if(!i(r))throw new o("right is required.");i(n)||(n=new m);var a=t.center,s=t.radius,u=r.center,l=r.radius,c=e.subtract(u,a,O),h=e.magnitude(c);if(s>=h+l)return t.clone(n),n;if(l>=h+s)return r.clone(n),n;var d=.5*(s+h+l),p=e.multiplyByScalar(c,(-s+d)/h,N);return e.add(p,a,p),e.clone(p,n.center),n.radius=d,n};var L=new e;m.expand=function(t,r,n){if(!i(t))throw new o("sphere is required.");if(!i(r))throw new o("point is required.");n=m.clone(t,n);var a=e.magnitude(e.subtract(r,n.center,L));return a>n.radius&&(n.radius=a),n},m.intersectPlane=function(t,r){if(!i(t))throw new o("sphere is required.");if(!i(r))throw new o("plane is required.");var n=t.center,a=t.radius,s=r.normal,l=e.dot(s,n)+r.distance;return-a>l?u.OUTSIDE:a>l?u.INTERSECTING:u.INSIDE},m.transform=function(e,t,r){if(!i(e))throw new o("sphere is required.");if(!i(t))throw new o("transform is required.");return i(r)||(r=new m),r.center=c.multiplyByPoint(t,e.center,r.center),r.radius=c.getMaximumScale(t)*e.radius,r};var F=new e;m.distanceSquaredTo=function(t,r){if(!i(t))throw new o("sphere is required.");if(!i(r))throw new o("cartesian is required.");var n=e.subtract(t.center,r,F);return e.magnitudeSquared(n)-t.radius*t.radius},m.transformWithoutScale=function(e,t,r){if(!i(e))throw new o("sphere is required.");if(!i(t))throw new o("transform is required.");return i(r)||(r=new m),r.center=c.multiplyByPoint(t,e.center,r.center),r.radius=e.radius,r};var B=new e;m.computePlaneDistances=function(t,r,n,a){if(!i(t))throw new o("sphere is required.");if(!i(r))throw new o("position is required.");if(!i(n))throw new o("direction is required.");i(a)||(a=new l);var s=e.subtract(t.center,r,B),u=e.dot(n,s);return a.start=u-t.radius,a.stop=u+t.radius,a};for(var z=new e,V=new e,k=new e,U=new e,q=new e,G=new t,W=new Array(8),H=0;8>H;++H)W[H]=new e;var j=new s;return m.projectTo2D=function(t,n,a){if(!i(t))throw new o("sphere is required.");n=r(n,j);var s=n.ellipsoid,u=t.center,l=t.radius,c=s.geodeticSurfaceNormal(u,z),h=e.cross(e.UNIT_Z,c,V);e.normalize(h,h);var d=e.cross(c,h,k);e.normalize(d,d),e.multiplyByScalar(c,l,c),e.multiplyByScalar(d,l,d),e.multiplyByScalar(h,l,h);var p=e.negate(d,q),f=e.negate(h,U),v=W,g=v[0];e.add(c,d,g),e.add(g,h,g),g=v[1],e.add(c,d,g),e.add(g,f,g),g=v[2],e.add(c,p,g),e.add(g,f,g),g=v[3],e.add(c,p,g),e.add(g,h,g),e.negate(c,c),g=v[4],e.add(c,d,g),e.add(g,h,g),g=v[5],e.add(c,d,g),e.add(g,f,g),g=v[6],e.add(c,p,g),e.add(g,f,g),g=v[7],e.add(c,p,g),e.add(g,h,g);for(var _=v.length,y=0;_>y;++y){var w=v[y];e.add(u,w,w);var C=s.cartesianToCartographic(w,G);n.project(C,w)}a=m.fromPoints(v,a),u=a.center;var E=u.x,S=u.y,b=u.z;return u.x=b,u.y=E,u.z=S,a},m.isOccluded=function(e,t){if(!i(e))throw new o("sphere is required.");if(!i(t))throw new o("occluder is required.");return!t.isBoundingSphereVisible(e)},m.equals=function(t,r){return t===r||i(t)&&i(r)&&e.equals(t.center,r.center)&&t.radius===r.radius},m.prototype.intersectPlane=function(e){return m.intersectPlane(this,e)},m.prototype.distanceSquaredTo=function(e){return m.distanceSquaredTo(this,e)},m.prototype.computePlaneDistances=function(e,t,r){return m.computePlaneDistances(this,e,t,r)},m.prototype.isOccluded=function(e){return m.isOccluded(this,e)},m.prototype.equals=function(e){return m.equals(this,e)},m.prototype.clone=function(e){return m.clone(this,e)},m}),r("Renderer/WebGLConstants",["../Core/freezeObject"],function(e){"use strict";var t={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,
UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503};return e(t)}),r("Core/Fullscreen",["./defined","./defineProperties"],function(e,t){"use strict";var r,i={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},n={};return t(n,{element:{get:function(){return n.supportsFullscreen()?document[i.fullscreenElement]:void 0}},changeEventName:{get:function(){return n.supportsFullscreen()?i.fullscreenchange:void 0}},errorEventName:{get:function(){return n.supportsFullscreen()?i.fullscreenerror:void 0}},enabled:{get:function(){return n.supportsFullscreen()?document[i.fullscreenEnabled]:void 0}},fullscreen:{get:function(){return n.supportsFullscreen()?null!==n.element:void 0}}}),n.supportsFullscreen=function(){if(e(r))return r;r=!1;var t=document.body;if("function"==typeof t.requestFullscreen)return i.requestFullscreen="requestFullscreen",i.exitFullscreen="exitFullscreen",i.fullscreenEnabled="fullscreenEnabled",i.fullscreenElement="fullscreenElement",i.fullscreenchange="fullscreenchange",i.fullscreenerror="fullscreenerror",r=!0;for(var n,o=["webkit","moz","o","ms","khtml"],a=0,s=o.length;s>a;++a){var u=o[a];n=u+"RequestFullscreen","function"==typeof t[n]?(i.requestFullscreen=n,r=!0):(n=u+"RequestFullScreen","function"==typeof t[n]&&(i.requestFullscreen=n,r=!0)),n=u+"ExitFullscreen","function"==typeof document[n]?i.exitFullscreen=n:(n=u+"CancelFullScreen","function"==typeof document[n]&&(i.exitFullscreen=n)),n=u+"FullscreenEnabled",e(document[n])?i.fullscreenEnabled=n:(n=u+"FullScreenEnabled",e(document[n])&&(i.fullscreenEnabled=n)),n=u+"FullscreenElement",e(document[n])?i.fullscreenElement=n:(n=u+"FullScreenElement",e(document[n])&&(i.fullscreenElement=n)),n=u+"fullscreenchange",e(document["on"+n])&&("ms"===u&&(n="MSFullscreenChange"),i.fullscreenchange=n),n=u+"fullscreenerror",e(document["on"+n])&&("ms"===u&&(n="MSFullscreenError"),i.fullscreenerror=n)}return r},n.requestFullscreen=function(e){n.supportsFullscreen()&&e[i.requestFullscreen]()},n.exitFullscreen=function(){n.supportsFullscreen()&&document[i.exitFullscreen]()},n}),r("Core/FeatureDetection",["./defaultValue","./defined","./Fullscreen"],function(e,t,r){"use strict";function i(e){for(var t=e.split("."),r=0,i=t.length;i>r;++r)t[r]=parseInt(t[r],10);return t}function n(){if(!t(v)){v=!1;var e=/ Chrome\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(v=!0,g=i(e[1]))}return v}function o(){return n()&&g}function a(){if(!t(_)&&(_=!1,!n()&&/ Safari\/[\.0-9]+/.test(navigator.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(_=!0,y=i(e[1]))}return _}function s(){return a()&&y}function u(){if(!t(w)){w=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(navigator.userAgent);null!==e&&(w=!0,C=i(e[1]),C.isNightly=!!e[2])}return w}function l(){return u()&&C}function c(){if(!t(E)){E=!1;var e;"Microsoft Internet Explorer"===navigator.appName?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(E=!0,S=i(e[1]))):"Netscape"===navigator.appName&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(navigator.userAgent),null!==e&&(E=!0,S=i(e[1])))}return E}function h(){return c()&&S}function d(){if(!t(b)){b=!1;var e=/Firefox\/([\.0-9]+)/.exec(navigator.userAgent);null!==e&&(b=!0,T=i(e[1]))}return b}function m(){return t(x)||(x=/Windows/i.test(navigator.appVersion)),x}function p(){return d()&&T}function f(){return t(P)||(P=t(window.PointerEvent)&&(!t(window.navigator.pointerEnabled)||window.navigator.pointerEnabled)),P}var v,g,_,y,w,C,E,S,b,T,x,P,A={isChrome:n,chromeVersion:o,isSafari:a,safariVersion:s,isWebkit:u,webkitVersion:l,isInternetExplorer:c,internetExplorerVersion:h,isFirefox:d,firefoxVersion:p,isWindows:m,hardwareConcurrency:e(navigator.hardwareConcurrency,3),supportsPointerEvents:f};return A.supportsFullscreen=function(){return r.supportsFullscreen()},A.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},A.supportsWebWorkers=function(){return"undefined"!=typeof Worker},A}),r("Core/ComponentDatatype",["../Renderer/WebGLConstants","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject"],function(e,t,r,i,n,o){"use strict";if(!n.supportsTypedArrays())return{};var a={BYTE:e.BYTE,UNSIGNED_BYTE:e.UNSIGNED_BYTE,SHORT:e.SHORT,UNSIGNED_SHORT:e.UNSIGNED_SHORT,FLOAT:e.FLOAT,DOUBLE:e.DOUBLE};return a.getSizeInBytes=function(e){if(!r(e))throw new i("value is required.");switch(e){case a.BYTE:return Int8Array.BYTES_PER_ELEMENT;case a.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case a.SHORT:return Int16Array.BYTES_PER_ELEMENT;case a.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case a.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case a.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new i("componentDatatype is not a valid value.")}},a.fromTypedArray=function(e){return e instanceof Int8Array?a.BYTE:e instanceof Uint8Array?a.UNSIGNED_BYTE:e instanceof Int16Array?a.SHORT:e instanceof Uint16Array?a.UNSIGNED_SHORT:e instanceof Float32Array?a.FLOAT:e instanceof Float64Array?a.DOUBLE:void 0},a.validate=function(e){return r(e)&&(e===a.BYTE||e===a.UNSIGNED_BYTE||e===a.SHORT||e===a.UNSIGNED_SHORT||e===a.FLOAT||e===a.DOUBLE)},a.createTypedArray=function(e,t){if(!r(e))throw new i("componentDatatype is required.");if(!r(t))throw new i("valuesOrLength is required.");switch(e){case a.BYTE:return new Int8Array(t);case a.UNSIGNED_BYTE:return new Uint8Array(t);case a.SHORT:return new Int16Array(t);case a.UNSIGNED_SHORT:return new Uint16Array(t);case a.FLOAT:return new Float32Array(t);case a.DOUBLE:return new Float64Array(t);default:throw new i("componentDatatype is not a valid value.")}},a.createArrayBufferView=function(e,n,o,s){if(!r(e))throw new i("componentDatatype is required.");if(!r(n))throw new i("buffer is required.");switch(o=t(o,0),s=t(s,(n.byteLength-o)/a.getSizeInBytes(e)),e){case a.BYTE:return new Int8Array(n,o,s);case a.UNSIGNED_BYTE:return new Uint8Array(n,o,s);case a.SHORT:return new Int16Array(n,o,s);case a.UNSIGNED_SHORT:return new Uint16Array(n,o,s);case a.FLOAT:return new Float32Array(n,o,s);case a.DOUBLE:return new Float64Array(n,o,s);default:throw new i("componentDatatype is not a valid value.")}},o(a)}),r("Core/GeometryType",["./freezeObject"],function(e){"use strict";var t={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3};return e(t)}),r("Core/PrimitiveType",["../Renderer/WebGLConstants","./freezeObject"],function(e,t){"use strict";var r={POINTS:e.POINTS,LINES:e.LINES,LINE_LOOP:e.LINE_LOOP,LINE_STRIP:e.LINE_STRIP,TRIANGLES:e.TRIANGLES,TRIANGLE_STRIP:e.TRIANGLE_STRIP,TRIANGLE_FAN:e.TRIANGLE_FAN,validate:function(e){return e===r.POINTS||e===r.LINES||e===r.LINE_LOOP||e===r.LINE_STRIP||e===r.TRIANGLES||e===r.TRIANGLE_STRIP||e===r.TRIANGLE_FAN}};return t(r)}),r("Core/Geometry",["./defaultValue","./defined","./DeveloperError","./GeometryType","./PrimitiveType"],function(e,t,r,i,n){"use strict";var o=function(o){if(o=e(o,e.EMPTY_OBJECT),!t(o.attributes))throw new r("options.attributes is required.");this.attributes=o.attributes,this.indices=o.indices,this.primitiveType=e(o.primitiveType,n.TRIANGLES),this.boundingSphere=o.boundingSphere,this.geometryType=e(o.geometryType,i.NONE),this.boundingSphereCV=void 0};return o.computeNumberOfVertices=function(e){if(!t(e))throw new r("geometry is required.");var i=-1;for(var n in e.attributes)if(e.attributes.hasOwnProperty(n)&&t(e.attributes[n])&&t(e.attributes[n].values)){var o=e.attributes[n],a=o.values.length/o.componentsPerAttribute;if(i!==a&&-1!==i)throw new r("All attribute lists must have the same number of attributes.");i=a}return i},o}),r("Core/GeometryAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var i=function(i){if(i=e(i,e.EMPTY_OBJECT),!t(i.componentDatatype))throw new r("options.componentDatatype is required.");if(!t(i.componentsPerAttribute))throw new r("options.componentsPerAttribute is required.");if(i.componentsPerAttribute<1||i.componentsPerAttribute>4)throw new r("options.componentsPerAttribute must be between 1 and 4.");if(!t(i.values))throw new r("options.values is required.");this.componentDatatype=i.componentDatatype,this.componentsPerAttribute=i.componentsPerAttribute,this.normalize=e(i.normalize,!1),this.values=i.values};return i}),r("Core/GeometryAttributes",["./defaultValue"],function(e){"use strict";var t=function(t){t=e(t,e.EMPTY_OBJECT),this.position=t.position,this.normal=t.normal,this.st=t.st,this.binormal=t.binormal,this.tangent=t.tangent,this.color=t.color};return t}),r("Core/VertexFormat",["./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,i){"use strict";var n=function(t){t=e(t,e.EMPTY_OBJECT),this.position=e(t.position,!1),this.normal=e(t.normal,!1),this.st=e(t.st,!1),this.binormal=e(t.binormal,!1),this.tangent=e(t.tangent,!1),this.color=e(t.color,!1)};return n.POSITION_ONLY=i(new n({position:!0})),n.POSITION_AND_NORMAL=i(new n({position:!0,normal:!0})),n.POSITION_NORMAL_AND_ST=i(new n({position:!0,normal:!0,st:!0})),n.POSITION_AND_ST=i(new n({position:!0,st:!0})),n.POSITION_AND_COLOR=i(new n({position:!0,color:!0})),n.ALL=i(new n({position:!0,normal:!0,st:!0,binormal:!0,tangent:!0})),n.DEFAULT=n.POSITION_NORMAL_AND_ST,n.packedLength=6,n.pack=function(i,n,o){if(!t(i))throw new r("value is required");if(!t(n))throw new r("array is required");o=e(o,0),n[o++]=i.position?1:0,n[o++]=i.normal?1:0,n[o++]=i.st?1:0,n[o++]=i.binormal?1:0,n[o++]=i.tangent?1:0,n[o++]=i.color?1:0},n.unpack=function(i,o,a){if(!t(i))throw new r("array is required");return o=e(o,0),t(a)||(a=new n),a.position=1===i[o++],a.normal=1===i[o++],a.st=1===i[o++],a.binormal=1===i[o++],a.tangent=1===i[o++],a.color=1===i[o++],a},n.clone=function(e,r){return t(e)?(t(r)||(r=new n),r.position=e.position,r.normal=e.normal,r.st=e.st,r.binormal=e.binormal,r.tangent=e.tangent,r.color=e.color,r):void 0},n}),r("Core/BoxGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Geometry","./GeometryAttribute","./GeometryAttributes","./PrimitiveType","./VertexFormat"],function(e,t,r,i,n,o,a,s,u,l,c,h){"use strict";var d=new t,m=function(e){e=i(e,i.EMPTY_OBJECT);var r=e.minimum,s=e.maximum;if(!n(r)&&n(e.minimumCorner)&&(r=e.minimumCorner,o("BoxGeometry","options.minimumCorner is deprecated. Use options.minimum instead.")),!n(s)&&n(e.maximumCorner)&&(s=e.maximumCorner,o("BoxGeometry","options.maximumCorner is deprecated. Use options.maximum instead.")),!n(r))throw new a("options.minimum is required.");if(!n(s))throw new a("options.maximum is required");var u=i(e.vertexFormat,h.DEFAULT);this._minimum=t.clone(r),this._maximum=t.clone(s),this._vertexFormat=u,this._workerName="createBoxGeometry"};m.fromDimensions=function(e){e=i(e,i.EMPTY_OBJECT);var r=e.dimensions;if(!n(r))throw new a("options.dimensions is required.");if(r.x<0||r.y<0||r.z<0)throw new a("All dimensions components must be greater than or equal to zero.");var o=t.multiplyByScalar(r,.5,new t);return new m({minimum:t.negate(o,new t),maximum:o,vertexFormat:e.vertexFormat})},m.fromAxisAlignedBoundingBox=function(e){if(!n(e))throw new a("boundingBox is required.");return new m({minimum:e.minimum,maximum:e.maximum})},m.fromAxisAlignedBoundingBox=function(e){if(!n(e))throw new a("boundingBox is required.");return new m({minimum:e.minimum,maximum:e.maximum})},m.packedLength=2*t.packedLength+h.packedLength,m.pack=function(e,r,o){if(!n(e))throw new a("value is required");if(!n(r))throw new a("array is required");o=i(o,0),t.pack(e._minimum,r,o),t.pack(e._maximum,r,o+t.packedLength),h.pack(e._vertexFormat,r,o+2*t.packedLength)};var p=new t,f=new t,v=new h,g={minimum:p,maximum:f,vertexFormat:v};return m.unpack=function(e,r,o){if(!n(e))throw new a("array is required");r=i(r,0);var s=t.unpack(e,r,p),u=t.unpack(e,r+t.packedLength,f),l=h.unpack(e,r+2*t.packedLength,v);return n(o)?(o._minimum=t.clone(s,o._minimum),o._maximum=t.clone(u,o._maximum),o._vertexFormat=h.clone(l,o._vertexFormat),o):new m(g)},m.createGeometry=function(i){var n,o,a=i._minimum,h=i._maximum,m=i._vertexFormat,p=new l;if(m.position&&(m.st||m.normal||m.binormal||m.tangent)){if(m.position&&(o=new Float64Array(72),o[0]=a.x,o[1]=a.y,o[2]=h.z,o[3]=h.x,o[4]=a.y,o[5]=h.z,o[6]=h.x,o[7]=h.y,o[8]=h.z,o[9]=a.x,o[10]=h.y,o[11]=h.z,o[12]=a.x,o[13]=a.y,o[14]=a.z,o[15]=h.x,o[16]=a.y,o[17]=a.z,o[18]=h.x,o[19]=h.y,o[20]=a.z,o[21]=a.x,o[22]=h.y,o[23]=a.z,o[24]=h.x,o[25]=a.y,o[26]=a.z,o[27]=h.x,o[28]=h.y,o[29]=a.z,o[30]=h.x,o[31]=h.y,o[32]=h.z,o[33]=h.x,o[34]=a.y,o[35]=h.z,o[36]=a.x,o[37]=a.y,o[38]=a.z,o[39]=a.x,o[40]=h.y,o[41]=a.z,o[42]=a.x,o[43]=h.y,o[44]=h.z,o[45]=a.x,o[46]=a.y,o[47]=h.z,o[48]=a.x,o[49]=h.y,o[50]=a.z,o[51]=h.x,o[52]=h.y,o[53]=a.z,o[54]=h.x,o[55]=h.y,o[56]=h.z,o[57]=a.x,o[58]=h.y,o[59]=h.z,o[60]=a.x,o[61]=a.y,o[62]=a.z,o[63]=h.x,o[64]=a.y,o[65]=a.z,o[66]=h.x,o[67]=a.y,o[68]=h.z,o[69]=a.x,o[70]=a.y,o[71]=h.z,p.position=new u({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:o})),m.normal){var f=new Float32Array(72);f[0]=0,f[1]=0,f[2]=1,f[3]=0,f[4]=0,f[5]=1,f[6]=0,f[7]=0,f[8]=1,f[9]=0,f[10]=0,f[11]=1,f[12]=0,f[13]=0,f[14]=-1,f[15]=0,f[16]=0,f[17]=-1,f[18]=0,f[19]=0,f[20]=-1,f[21]=0,f[22]=0,f[23]=-1,f[24]=1,f[25]=0,f[26]=0,f[27]=1,f[28]=0,f[29]=0,f[30]=1,f[31]=0,f[32]=0,f[33]=1,f[34]=0,f[35]=0,f[36]=-1,f[37]=0,f[38]=0,f[39]=-1,f[40]=0,f[41]=0,f[42]=-1,f[43]=0,f[44]=0,f[45]=-1,f[46]=0,f[47]=0,f[48]=0,f[49]=1,f[50]=0,f[51]=0,f[52]=1,f[53]=0,f[54]=0,f[55]=1,f[56]=0,f[57]=0,f[58]=1,f[59]=0,f[60]=0,f[61]=-1,f[62]=0,f[63]=0,f[64]=-1,f[65]=0,f[66]=0,f[67]=-1,f[68]=0,f[69]=0,f[70]=-1,f[71]=0,p.normal=new u({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:f})}if(m.st){var v=new Float32Array(48);v[0]=0,v[1]=0,v[2]=1,v[3]=0,v[4]=1,v[5]=1,v[6]=0,v[7]=1,v[8]=1,v[9]=0,v[10]=0,v[11]=0,v[12]=0,v[13]=1,v[14]=1,v[15]=1,v[16]=0,v[17]=0,v[18]=1,v[19]=0,v[20]=1,v[21]=1,v[22]=0,v[23]=1,v[24]=1,v[25]=0,v[26]=0,v[27]=0,v[28]=0,v[29]=1,v[30]=1,v[31]=1,v[32]=1,v[33]=0,v[34]=0,v[35]=0,v[36]=0,v[37]=1,v[38]=1,v[39]=1,v[40]=0,v[41]=0,v[42]=1,v[43]=0,v[44]=1,v[45]=1,v[46]=0,v[47]=1,p.st=new u({componentDatatype:r.FLOAT,componentsPerAttribute:2,values:v})}if(m.tangent){var g=new Float32Array(72);g[0]=1,g[1]=0,g[2]=0,g[3]=1,g[4]=0,g[5]=0,g[6]=1,g[7]=0,g[8]=0,g[9]=1,g[10]=0,g[11]=0,g[12]=-1,g[13]=0,g[14]=0,g[15]=-1,g[16]=0,g[17]=0,g[18]=-1,g[19]=0,g[20]=0,g[21]=-1,g[22]=0,g[23]=0,g[24]=0,g[25]=1,g[26]=0,g[27]=0,g[28]=1,g[29]=0,g[30]=0,g[31]=1,g[32]=0,g[33]=0,g[34]=1,g[35]=0,g[36]=0,g[37]=-1,g[38]=0,g[39]=0,g[40]=-1,g[41]=0,g[42]=0,g[43]=-1,g[44]=0,g[45]=0,g[46]=-1,g[47]=0,g[48]=-1,g[49]=0,g[50]=0,g[51]=-1,g[52]=0,g[53]=0,g[54]=-1,g[55]=0,g[56]=0,g[57]=-1,g[58]=0,g[59]=0,g[60]=1,g[61]=0,g[62]=0,g[63]=1,g[64]=0,g[65]=0,g[66]=1,g[67]=0,g[68]=0,g[69]=1,g[70]=0,g[71]=0,p.tangent=new u({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:g})}if(m.binormal){var _=new Float32Array(72);_[0]=0,_[1]=1,_[2]=0,_[3]=0,_[4]=1,_[5]=0,_[6]=0,_[7]=1,_[8]=0,_[9]=0,_[10]=1,_[11]=0,_[12]=0,_[13]=1,_[14]=0,_[15]=0,_[16]=1,_[17]=0,_[18]=0,_[19]=1,_[20]=0,_[21]=0,_[22]=1,_[23]=0,_[24]=0,_[25]=0,_[26]=1,_[27]=0,_[28]=0,_[29]=1,_[30]=0,_[31]=0,_[32]=1,_[33]=0,_[34]=0,_[35]=1,_[36]=0,_[37]=0,_[38]=1,_[39]=0,_[40]=0,_[41]=1,_[42]=0,_[43]=0,_[44]=1,_[45]=0,_[46]=0,_[47]=1,_[48]=0,_[49]=0,_[50]=1,_[51]=0,_[52]=0,_[53]=1,_[54]=0,_[55]=0,_[56]=1,_[57]=0,_[58]=0,_[59]=1,_[60]=0,_[61]=0,_[62]=1,_[63]=0,_[64]=0,_[65]=1,_[66]=0,_[67]=0,_[68]=1,_[69]=0,_[70]=0,_[71]=1,p.binormal=new u({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:_})}n=new Uint16Array(36),n[0]=0,n[1]=1,n[2]=2,n[3]=0,n[4]=2,n[5]=3,n[6]=6,n[7]=5,n[8]=4,n[9]=7,n[10]=6,n[11]=4,n[12]=8,n[13]=9,n[14]=10,n[15]=8,n[16]=10,n[17]=11,n[18]=14,n[19]=13,n[20]=12,n[21]=15,n[22]=14,n[23]=12,n[24]=18,n[25]=17,n[26]=16,n[27]=19,n[28]=18,n[29]=16,n[30]=20,n[31]=21,n[32]=22,n[33]=20,n[34]=22,n[35]=23}else o=new Float64Array(24),o[0]=a.x,o[1]=a.y,o[2]=a.z,o[3]=h.x,o[4]=a.y,o[5]=a.z,o[6]=h.x,o[7]=h.y,o[8]=a.z,o[9]=a.x,o[10]=h.y,o[11]=a.z,o[12]=a.x,o[13]=a.y,o[14]=h.z,o[15]=h.x,o[16]=a.y,o[17]=h.z,o[18]=h.x,o[19]=h.y,o[20]=h.z,o[21]=a.x,o[22]=h.y,o[23]=h.z,p.position=new u({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:o}),n=new Uint16Array(36),n[0]=4,n[1]=5,n[2]=6,n[3]=4,n[4]=6,n[5]=7,n[6]=1,n[7]=0,n[8]=3,n[9]=1,n[10]=3,n[11]=2,n[12]=1,n[13]=6,n[14]=5,n[15]=1,n[16]=2,n[17]=6,n[18]=2,n[19]=3,n[20]=7,n[21]=2,n[22]=7,n[23]=6,n[24]=3,n[25]=0,n[26]=4,n[27]=3,n[28]=4,n[29]=7,n[30]=0,n[31]=1,n[32]=5,n[33]=0,n[34]=5,n[35]=4;var y=t.subtract(h,a,d),w=.5*t.magnitude(y);return new s({attributes:p,indices:n,primitiveType:c.TRIANGLES,boundingSphere:new e(t.ZERO,w)})},m}),r("Core/BoxOutlineGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./deprecationWarning","./DeveloperError","./Geometry","./GeometryAttribute","./GeometryAttributes","./PrimitiveType"],function(e,t,r,i,n,o,a,s,u,l,c){"use strict";var h=new t,d=function(e){e=i(e,i.EMPTY_OBJECT);var r=e.minimum,s=e.maximum;if(!n(r)&&n(e.minimumCorner)&&(r=e.minimumCorner,o("BoxOutlineGeometry","options.minimumCorner is deprecated. Use options.minimum instead.")),!n(s)&&n(e.maximumCorner)&&(s=e.maximumCorner,o("BoxOutlineGeometry","options.maximumCorner is deprecated. Use options.maximum instead.")),!n(r))throw new a("options.minimum is required.");if(!n(s))throw new a("options.maximum is required");this._min=t.clone(r),this._max=t.clone(s),this._workerName="createBoxOutlineGeometry"};d.fromDimensions=function(e){e=i(e,i.EMPTY_OBJECT);var r=e.dimensions;if(!n(r))throw new a("options.dimensions is required.");if(r.x<0||r.y<0||r.z<0)throw new a("All dimensions components must be greater than or equal to zero.");var o=t.multiplyByScalar(r,.5,new t);return new d({minimum:t.negate(o,new t),maximum:o})},d.fromAxisAlignedBoundingBox=function(e){if(!n(e))throw new a("boundingBox is required.");return new d({minimum:e.minimum,maximum:e.maximum})},d.packedLength=2*t.packedLength,d.pack=function(e,r,o){if(!n(e))throw new a("value is required");if(!n(r))throw new a("array is required");o=i(o,0),t.pack(e._min,r,o),t.pack(e._max,r,o+t.packedLength)};var m=new t,p=new t,f={minimum:m,maximum:p};return d.unpack=function(e,r,o){if(!n(e))throw new a("array is required");r=i(r,0);var s=t.unpack(e,r,m),u=t.unpack(e,r+t.packedLength,p);return n(o)?(o._min=t.clone(s,o._min),o._max=t.clone(u,o._max),o):new d(f)},d.createGeometry=function(i){var n=i._min,o=i._max,a=new l,d=new Uint16Array(24),m=new Float64Array(24);m[0]=n.x,m[1]=n.y,m[2]=n.z,m[3]=o.x,m[4]=n.y,m[5]=n.z,m[6]=o.x,m[7]=o.y,m[8]=n.z,m[9]=n.x,m[10]=o.y,m[11]=n.z,m[12]=n.x,m[13]=n.y,m[14]=o.z,m[15]=o.x,m[16]=n.y,m[17]=o.z,m[18]=o.x,m[19]=o.y,m[20]=o.z,m[21]=n.x,m[22]=o.y,m[23]=o.z,a.position=new u({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:m}),d[0]=4,d[1]=5,d[2]=5,d[3]=6,d[4]=6,d[5]=7,d[6]=7,d[7]=4,d[8]=0,d[9]=1,d[10]=1,d[11]=2,d[12]=2,d[13]=3,d[14]=3,d[15]=0,d[16]=0,d[17]=4,d[18]=1,d[19]=5,d[20]=2,d[21]=6,d[22]=3,d[23]=7;var p=t.subtract(o,n,h),f=.5*t.magnitude(p);return new s({attributes:a,indices:d,primitiveType:c.LINES,boundingSphere:new e(t.ZERO,f)})},d}),r("Core/cancelAnimationFrame",["./defined"],function(e){"use strict";var t=window.cancelAnimationFrame;!function(){if(!e(t))for(var r=["webkit","moz","ms","o"],i=0,n=r.length;n>i&&!e(t);)t=window[r[i]+"CancelAnimationFrame"],e(t)||(t=window[r[i]+"CancelRequestAnimationFrame"]),++i;e(t)||(t=clearTimeout)}();var r=function(e){t(e)};return r}),r("Core/Spline",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var i=function(){this.times=void 0,this.points=void 0,r.throwInstantiationError()};return i.prototype.evaluate=r.throwInstantiationError,i.prototype.findTimeInterval=function(i,n){var o=this.times,a=o.length;if(!t(i))throw new r("time is required.");if(i<o[0]||i>o[a-1])throw new r("time is out of range.");if(n=e(n,0),i>=o[n]){if(a>n+1&&i<o[n+1])return n;if(a>n+2&&i<o[n+2])return n+1}else if(n-1>=0&&i>=o[n-1])return n-1;var s;if(i>o[n])for(s=n;a-1>s&&!(i>=o[s]&&i<o[s+1]);++s);else for(s=n-1;s>=0&&!(i>=o[s]&&i<o[s+1]);--s);return s===a-1&&(s=a-2),s},i}),r("Core/LinearSpline",["./Cartesian3","./defaultValue","./defined","./defineProperties","./DeveloperError","./Spline"],function(e,t,r,i,n,o){"use strict";var a=function(e){e=t(e,t.EMPTY_OBJECT);var i=e.points,o=e.times;if(!r(i)||!r(o))throw new n("points and times are required.");if(i.length<2)throw new n("points.length must be greater than or equal to 2.");if(o.length!==i.length)throw new n("times.length must be equal to points.length.");this._times=o,this._points=i,this._lastTimeIndex=0};return i(a.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}}}),a.prototype.findTimeInterval=o.prototype.findTimeInterval,a.prototype.evaluate=function(t,i){var n=this.points,o=this.times,a=this._lastTimeIndex=this.findTimeInterval(t,this._lastTimeIndex),s=(t-o[a])/(o[a+1]-o[a]);return r(i)||(i=new e),e.lerp(n[a],n[a+1],s,i)},a}),r("Core/TridiagonalSystemSolver",["./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";var i={};return i.solve=function(i,n,o,a){if(!(t(i)&&i instanceof Array))throw new r("The array lower is required.");if(!(t(n)&&n instanceof Array))throw new r("The array diagonal is required.");if(!(t(o)&&o instanceof Array))throw new r("The array upper is required.");if(!(t(a)&&a instanceof Array))throw new r("The array right is required.");if(n.length!==a.length)throw new r("diagonal and right must have the same lengths.");if(i.length!==o.length)throw new r("lower and upper must have the same lengths.");if(i.length!==n.length-1)throw new r("lower and upper must be one less than the length of diagonal.");var s,u=new Array(o.length),l=new Array(a.length),c=new Array(a.length);for(s=0;s<l.length;s++)l[s]=new e,c[s]=new e;u[0]=o[0]/n[0],l[0]=e.multiplyByScalar(a[0],1/n[0],l[0]);var h;for(s=1;s<u.length;++s)h=1/(n[s]-u[s-1]*i[s-1]),u[s]=o[s]*h,l[s]=e.subtract(a[s],e.multiplyByScalar(l[s-1],i[s-1],l[s]),l[s]),l[s]=e.multiplyByScalar(l[s],h,l[s]);for(h=1/(n[s]-u[s-1]*i[s-1]),l[s]=e.subtract(a[s],e.multiplyByScalar(l[s-1],i[s-1],l[s]),l[s]),l[s]=e.multiplyByScalar(l[s],h,l[s]),c[c.length-1]=l[l.length-1],s=c.length-2;s>=0;--s)c[s]=e.subtract(l[s],e.multiplyByScalar(c[s+1],u[s],c[s]),c[s]);return c},i}),r("Core/HermiteSpline",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./defineProperties","./DeveloperError","./LinearSpline","./Matrix4","./Spline","./TridiagonalSystemSolver"],function(e,t,r,i,n,o,a,s,u,l){"use strict";function c(t,r,n){var o=d,a=p,s=m,u=f;o.length=a.length=t.length-1,s.length=u.length=t.length;var c;o[0]=s[0]=1,a[0]=0;var h=u[0];for(i(h)||(h=u[0]=new e),e.clone(r,h),c=1;c<o.length-1;++c)o[c]=a[c]=1,s[c]=4,h=u[c],i(h)||(h=u[c]=new e),e.subtract(t[c+1],t[c-1],h),e.multiplyByScalar(h,3,h);return o[c]=0,a[c]=1,s[c]=4,h=u[c],i(h)||(h=u[c]=new e),e.subtract(t[c+1],t[c-1],h),e.multiplyByScalar(h,3,h),s[c+1]=1,h=u[c+1],i(h)||(h=u[c+1]=new e),e.clone(n,h),l.solve(o,s,a,u)}function h(t){var r=d,n=p,o=m,a=f;r.length=n.length=t.length-1,o.length=a.length=t.length;var s;r[0]=n[0]=1,o[0]=2;var u=a[0];for(i(u)||(u=a[0]=new e),e.subtract(t[1],t[0],u),e.multiplyByScalar(u,3,u),s=1;s<r.length;++s)r[s]=n[s]=1,o[s]=4,u=a[s],i(u)||(u=a[s]=new e),e.subtract(t[s+1],t[s-1],u),e.multiplyByScalar(u,3,u);return o[s]=2,u=a[s],i(u)||(u=a[s]=new e),e.subtract(t[s],t[s-1],u),e.multiplyByScalar(u,3,u),l.solve(r,o,n,a)}var d=[],m=[],p=[],f=[],v=function(e){e=r(e,r.EMPTY_OBJECT);var t=e.points,n=e.times,a=e.inTangents,s=e.outTangents;if(!(i(t)&&i(n)&&i(a)&&i(s)))throw new o("times, points, inTangents, and outTangents are required.");if(t.length<2)throw new o("points.length must be greater than or equal to 2.");if(n.length!==t.length)throw new o("times.length must be equal to points.length.");if(a.length!==s.length||a.length!==t.length-1)throw new o("inTangents and outTangents must have a length equal to points.length - 1.");this._times=n,this._points=t,this._inTangents=a,this._outTangents=s,this._lastTimeIndex=0};n(v.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}},inTangents:{get:function(){return this._inTangents}},outTangents:{get:function(){return this._outTangents}}}),v.createC1=function(e){e=r(e,r.EMPTY_OBJECT);var t=e.times,n=e.points,a=e.tangents;if(!i(n)||!i(t)||!i(a))throw new o("points, times and tangents are required.");if(n.length<2)throw new o("points.length must be greater than or equal to 2.");if(t.length!==n.length||t.length!==a.length)throw new o("times, points and tangents must have the same length.");var s=a.slice(0,a.length-1),u=a.slice(1,a.length);return new v({times:t,points:n,inTangents:u,outTangents:s})},v.createNaturalCubic=function(e){e=r(e,r.EMPTY_OBJECT);var t=e.times,n=e.points;if(!i(n)||!i(t))throw new o("points and times are required.");if(n.length<2)throw new o("points.length must be greater than or equal to 2.");if(t.length!==n.length)throw new o("times.length must be equal to points.length.");if(n.length<3)return new a({points:n,times:t});var s=h(n),u=s.slice(0,s.length-1),l=s.slice(1,s.length);return new v({times:t,points:n,inTangents:l,outTangents:u})},v.createClampedCubic=function(e){e=r(e,r.EMPTY_OBJECT);var t=e.times,n=e.points,s=e.firstTangent,u=e.lastTangent;if(!(i(n)&&i(t)&&i(s)&&i(u)))throw new o("points, times, firstTangent and lastTangent are required.");if(n.length<2)throw new o("points.length must be greater than or equal to 2.");if(t.length!==n.length)throw new o("times.length must be equal to points.length.");if(n.length<3)return new a({points:n,times:t});var l=c(n,s,u),h=l.slice(0,l.length-1),d=l.slice(1,l.length);return new v({times:t,points:n,inTangents:d,outTangents:h})},v.hermiteCoefficientMatrix=new s(2,-3,0,1,-2,3,0,0,1,-2,1,0,1,-1,0,0),v.prototype.findTimeInterval=u.prototype.findTimeInterval;var g=new t,_=new e;return v.prototype.evaluate=function(t,r){i(r)||(r=new e);var n=this.points,o=this.times,a=this.inTangents,u=this.outTangents,l=this._lastTimeIndex=this.findTimeInterval(t,this._lastTimeIndex),c=(t-o[l])/(o[l+1]-o[l]),h=g;h.z=c,h.y=c*c,h.x=h.y*c,h.w=1;var d=s.multiplyByVector(v.hermiteCoefficientMatrix,h,h);return r=e.multiplyByScalar(n[l],d.x,r),e.multiplyByScalar(n[l+1],d.y,_),e.add(r,_,r),e.multiplyByScalar(u[l],d.z,_),e.add(r,_,r),e.multiplyByScalar(a[l],d.w,_),e.add(r,_,r)},v}),r("Core/CatmullRomSpline",["./Cartesian3","./Cartesian4","./defaultValue","./defined","./defineProperties","./DeveloperError","./HermiteSpline","./Matrix4","./Spline"],function(e,t,r,i,n,o,a,s,u){"use strict";function l(t){var r=t.points,n=t.times;if(r.length<3){var o=n[0],u=1/(n[1]-o),l=r[0],m=r[1];return function(t,r){i(r)||(r=new e);var n=(t-o)*u;return e.lerp(l,m,n,r)}}return function(o,u){i(u)||(u=new e);var l=t._lastTimeIndex=t.findTimeInterval(o,t._lastTimeIndex),m=(o-n[l])/(n[l+1]-n[l]),p=c;p.z=m,p.y=m*m,p.x=p.y*m,p.w=1;var v,g,_,y,w;return 0===l?(v=r[0],g=r[1],_=t.firstTangent,y=e.subtract(r[2],v,h),e.multiplyByScalar(y,.5,y),w=s.multiplyByVector(a.hermiteCoefficientMatrix,p,p)):l===r.length-2?(v=r[l],g=r[l+1],y=t.lastTangent,_=e.subtract(g,r[l-1],h),e.multiplyByScalar(_,.5,_),w=s.multiplyByVector(a.hermiteCoefficientMatrix,p,p)):(v=r[l-1],g=r[l],_=r[l+1],y=r[l+2],w=s.multiplyByVector(f.catmullRomCoefficientMatrix,p,p)),u=e.multiplyByScalar(v,w.x,u),e.multiplyByScalar(g,w.y,d),e.add(u,d,u),e.multiplyByScalar(_,w.z,d),e.add(u,d,u),e.multiplyByScalar(y,w.w,d),e.add(u,d,u)}}var c=new t,h=new e,d=new e,m=new e,p=new e,f=function(t){t=r(t,r.EMPTY_OBJECT);var n=t.points,a=t.times,s=t.firstTangent,u=t.lastTangent;if(!i(n)||!i(a))throw new o("points and times are required.");if(n.length<2)throw new o("points.length must be greater than or equal to 2.");if(a.length!==n.length)throw new o("times.length must be equal to points.length.");if(n.length>2&&(i(s)||(s=m,e.multiplyByScalar(n[1],2,s),e.subtract(s,n[2],s),e.subtract(s,n[0],s),e.multiplyByScalar(s,.5,s)),!i(u))){var c=n.length-1;u=p,e.multiplyByScalar(n[c-1],2,u),e.subtract(n[c],u,u),e.add(u,n[c-2],u),e.multiplyByScalar(u,.5,u)}this._times=a,this._points=n,this._firstTangent=e.clone(s),this._lastTangent=e.clone(u),this._evaluateFunction=l(this),this._lastTimeIndex=0};return n(f.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}},firstTangent:{get:function(){return this._firstTangent}},lastTangent:{get:function(){return this._lastTangent}}}),f.catmullRomCoefficientMatrix=new s(-.5,1,-.5,0,1.5,-2.5,0,1,-1.5,2,.5,0,.5,-.5,0,0),f.prototype.findTimeInterval=u.prototype.findTimeInterval,f.prototype.evaluate=function(e,t){return this._evaluateFunction(e,t)},f}),r("Core/IndexDatatype",["../Renderer/WebGLConstants","./defined","./DeveloperError","./freezeObject","./Math"],function(e,t,r,i,n){"use strict";var o={UNSIGNED_BYTE:e.UNSIGNED_BYTE,UNSIGNED_SHORT:e.UNSIGNED_SHORT,UNSIGNED_INT:e.UNSIGNED_INT};return o.getSizeInBytes=function(e){switch(e){case o.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case o.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case o.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new r("indexDatatype is required and must be a valid IndexDatatype constant.")},o.validate=function(e){return t(e)&&(e===o.UNSIGNED_BYTE||e===o.UNSIGNED_SHORT||e===o.UNSIGNED_INT)},o.createTypedArray=function(e,i){if(!t(e))throw new r("numberOfVertices is required.");return e>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(i):new Uint16Array(i)},o.createTypedArrayFromArrayBuffer=function(e,i,o,a){if(!t(e))throw new r("numberOfVertices is required.");if(!t(i))throw new r("sourceArray is required.");if(!t(o))throw new r("byteOffset is required.");return e>=n.SIXTY_FOUR_KILOBYTES?new Uint32Array(i,o,a):new Uint16Array(i,o,a)},i(o)}),r("Core/definedNotNull",[],function(){"use strict";var e=function(e){return void 0!==e&&null!==e};return e}),r("Core/joinUrls",["../ThirdParty/Uri","./defaultValue","./defined","./definedNotNull","./DeveloperError"],function(e,t,r,i,n){"use strict";var o=function(o,a,s){if(!r(o))throw new n("first is required");if(!r(a))throw new n("second is required");s=t(s,!0),o instanceof e||(o=new e(o)),a instanceof e||(a=new e(a));var u="";i(o.scheme)&&(u+=o.scheme+":"),i(o.authority)&&(u+="//"+o.authority,""!==o.path&&(u=u.replace(/\/?$/,"/"),o.path=o.path.replace(/^\/?/g,""))),u+=s?o.path.replace(/\/?$/,"/")+a.path.replace(/^\/?/g,""):o.path+a.path;var l=i(o.query),c=i(a.query);l&&c?u+="?"+o.query+"&"+a.query:l&&!c?u+="?"+o.query:!l&&c&&(u+="?"+a.query);var h=i(a.fragment);return i(o.fragment)&&!h?u+="#"+o.fragment:h&&(u+="#"+a.fragment),u};return o}),r("Core/parseResponseHeaders",[],function(){"use strict";var e=function(e){var t={};if(!e)return t;for(var r=e.split("\r\n"),i=0;i<r.length;++i){var n=r[i],o=n.indexOf(": ");if(o>0){var a=n.substring(0,o),s=n.substring(o+2);t[a]=s}}return t};return e}),r("Core/RequestErrorEvent",["./defined","./parseResponseHeaders"],function(e,t){"use strict";var r=function(e,r,i){this.statusCode=e,this.response=r,this.responseHeaders=i,"string"==typeof this.responseHeaders&&(this.responseHeaders=t(this.responseHeaders));
};return r.prototype.toString=function(){var t="Request has failed.";return e(this.statusCode)&&(t+=" Status Code: "+this.statusCode),t},r}),r("Core/loadWithXhr",["../ThirdParty/when","./defaultValue","./defined","./DeveloperError","./RequestErrorEvent","./RuntimeError"],function(e,t,r,i,n,o){"use strict";function a(e,t){var r=decodeURIComponent(t);return e?atob(r):r}function s(e,t){for(var r=a(e,t),i=new ArrayBuffer(r.length),n=new Uint8Array(i),o=0;o<r.length;o++)n[o]=r.charCodeAt(o);return i}function u(e,r){r=t(r,"");var n=e[1],o=!!e[2],u=e[3];switch(r){case"":case"text":return a(o,u);case"arraybuffer":return s(o,u);case"blob":var l=s(o,u);return new Blob([l],{type:n});case"document":var c=new DOMParser;return c.parseFromString(a(o,u),n);case"json":return JSON.parse(a(o,u));default:throw new i("Unhandled responseType: "+r)}}var l=function(n){if(n=t(n,t.EMPTY_OBJECT),!r(n.url))throw new i("options.url is required.");var o=n.responseType,a=t(n.method,"GET"),s=n.data,u=n.headers,c=n.overrideMimeType;return e(n.url,function(t){var r=e.defer();return l.load(t,o,a,s,u,r,c),r.promise})},c=/^data:(.*?)(;base64)?,(.*)$/;return l.load=function(e,t,i,a,s,l,h){var d=c.exec(e);if(null!==d)return void l.resolve(u(d,t));var m=new XMLHttpRequest;if(r(h)&&r(m.overrideMimeType)&&m.overrideMimeType(h),m.open(i,e,!0),r(s))for(var p in s)s.hasOwnProperty(p)&&m.setRequestHeader(p,s[p]);r(t)&&(m.responseType=t),m.onload=function(){200===m.status?r(m.response)?l.resolve(m.response):r(m.responseXML)&&m.responseXML.hasChildNodes()?l.resolve(m.responseXML):r(m.responseText)?l.resolve(m.responseText):l.reject(new o("unknown XMLHttpRequest response type.")):l.reject(new n(m.status,m.response,m.getAllResponseHeaders()))},m.onerror=function(e){l.reject(new n)},m.send(a)},l.defaultLoad=l.load,l}),r("Core/loadArrayBuffer",["./loadWithXhr"],function(e){"use strict";var t=function(t,r){return e({url:t,responseType:"arraybuffer",headers:r})};return t}),r("Core/clone",["./defaultValue"],function(e){"use strict";var t=function(r,i){if(null===r||"object"!=typeof r)return r;i=e(i,!1);var n=new r.constructor;for(var o in r)if(r.hasOwnProperty(o)){var a=r[o];i&&(a=t(a,i)),n[o]=a}return n};return t}),r("Core/loadText",["./loadWithXhr"],function(e){"use strict";var t=function(t,r){return e({url:t,headers:r})};return t}),r("Core/loadJson",["./clone","./defined","./DeveloperError","./loadText"],function(e,t,r,i){"use strict";var n={Accept:"application/json,*/*;q=0.01"},o=function(o,a){if(!t(o))throw new r("url is required.");return t(a)?t(a.Accept)||(a=e(a),a.Accept=n.Accept):a=n,i(o,a).then(function(e){return JSON.parse(e)})};return o}),r("Core/QuadraticRealPolynomial",["./DeveloperError","./Math"],function(e,t){"use strict";function r(e,r,i){var n=e+r;return t.sign(e)!==t.sign(r)&&Math.abs(n/Math.max(Math.abs(e),Math.abs(r)))<i?0:n}var i={};return i.computeDiscriminant=function(t,r,i){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof i)throw new e("c is a required number.");var n=r*r-4*t*i;return n},i.computeRealRoots=function(i,n,o){if("number"!=typeof i)throw new e("a is a required number.");if("number"!=typeof n)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");var a;if(0===i)return 0===n?[]:[-o/n];if(0===n){if(0===o)return[0,0];var s=Math.abs(o),u=Math.abs(i);if(u>s&&s/u<t.EPSILON14)return[0,0];if(s>u&&u/s<t.EPSILON14)return[];if(a=-o/i,0>a)return[];var l=Math.sqrt(a);return[-l,l]}if(0===o)return a=-n/i,0>a?[a,0]:[0,a];var c=n*n,h=4*i*o,d=r(c,-h,t.EPSILON14);if(0>d)return[];var m=-.5*r(n,t.sign(n)*Math.sqrt(d),t.EPSILON14);return n>0?[m/i,o/m]:[o/m,m/i]},i}),r("Core/CubicRealPolynomial",["./DeveloperError","./QuadraticRealPolynomial"],function(e,t){"use strict";function r(e,t,r,i){var n,o,a=e,s=t/3,u=r/3,l=i,c=a*u,h=s*l,d=s*s,m=u*u,p=a*u-d,f=a*l-s*u,v=s*l-m,g=4*p*v-f*f;if(0>g){var _,y,w;d*h>=c*m?(_=a,y=p,w=-2*s*p+a*f):(_=l,y=v,w=-l*f+2*u*v);var C=0>w?-1:1,E=-C*Math.abs(_)*Math.sqrt(-g);o=-w+E;var S=o/2,b=0>S?-Math.pow(-S,1/3):Math.pow(S,1/3),T=o===E?-b:-y/b;return n=0>=y?b+T:-w/(b*b+T*T+y),d*h>=c*m?[(n-s)/a]:[-l/(n+u)]}var x=p,P=-2*s*p+a*f,A=v,I=-l*f+2*u*v,D=Math.sqrt(g),M=Math.sqrt(3)/2,R=Math.abs(Math.atan2(a*D,-P)/3);n=2*Math.sqrt(-x);var O=Math.cos(R);o=n*O;var N=n*(-O/2-M*Math.sin(R)),L=o+N>2*s?o-s:N-s,F=a,B=L/F;R=Math.abs(Math.atan2(l*D,-I)/3),n=2*Math.sqrt(-A),O=Math.cos(R),o=n*O,N=n*(-O/2-M*Math.sin(R));var z=-l,V=2*u>o+N?o+u:N+u,k=z/V,U=F*V,q=-L*V-F*z,G=L*z,W=(u*q-s*G)/(-s*q+u*U);return W>=B?k>=B?k>=W?[B,W,k]:[B,k,W]:[k,B,W]:k>=B?[W,B,k]:k>=W?[W,k,B]:[k,W,B]}var i={};return i.computeDiscriminant=function(t,r,i,n){if("number"!=typeof t)throw new e("a is a required number.");if("number"!=typeof r)throw new e("b is a required number.");if("number"!=typeof i)throw new e("c is a required number.");if("number"!=typeof n)throw new e("d is a required number.");var o=t*t,a=r*r,s=i*i,u=n*n,l=18*t*r*i*n+a*s-27*o*u-4*(t*s*i+a*r*n);return l},i.computeRealRoots=function(i,n,o,a){if("number"!=typeof i)throw new e("a is a required number.");if("number"!=typeof n)throw new e("b is a required number.");if("number"!=typeof o)throw new e("c is a required number.");if("number"!=typeof a)throw new e("d is a required number.");var s,u;if(0===i)return t.computeRealRoots(n,o,a);if(0===n){if(0===o){if(0===a)return[0,0,0];u=-a/i;var l=0>u?-Math.pow(-u,1/3):Math.pow(u,1/3);return[l,l,l]}return 0===a?(s=t.computeRealRoots(i,0,o),0===s.Length?[0]:[s[0],0,s[1]]):r(i,0,o,a)}return 0===o?0===a?(u=-n/i,0>u?[u,0,0]:[0,0,u]):r(i,n,0,a):0===a?(s=t.computeRealRoots(i,n,o),0===s.length?[0]:s[1]<=0?[s[0],s[1],0]:s[0]>=0?[0,s[0],s[1]]:[s[0],0,s[1]]):r(i,n,o,a)},i}),r("Core/QuarticRealPolynomial",["./CubicRealPolynomial","./DeveloperError","./Math","./QuadraticRealPolynomial"],function(e,t,r,i){"use strict";function n(t,n,o,a){var s=t*t,u=n-3*s/8,l=o-n*t/2+s*t/8,c=a-o*t/4+n*s/16-3*s*s/256,h=e.computeRealRoots(1,2*u,u*u-4*c,-l*l);if(h.length>0){var d=-t/4,m=h[h.length-1];if(Math.abs(m)<r.EPSILON14){var p=i.computeRealRoots(1,u,c);if(2===p.length){var f,v=p[0],g=p[1];if(v>=0&&g>=0){var _=Math.sqrt(v),y=Math.sqrt(g);return[d-y,d-_,d+_,d+y]}if(v>=0&&0>g)return f=Math.sqrt(v),[d-f,d+f];if(0>v&&g>=0)return f=Math.sqrt(g),[d-f,d+f]}return[]}if(m>0){var w=Math.sqrt(m),C=(u+m-l/w)/2,E=(u+m+l/w)/2,S=i.computeRealRoots(1,w,C),b=i.computeRealRoots(1,-w,E);return 0!==S.length?(S[0]+=d,S[1]+=d,0!==b.length?(b[0]+=d,b[1]+=d,S[1]<=b[0]?[S[0],S[1],b[0],b[1]]:b[1]<=S[0]?[b[0],b[1],S[0],S[1]]:S[0]>=b[0]&&S[1]<=b[1]?[b[0],S[0],S[1],b[1]]:b[0]>=S[0]&&b[1]<=S[1]?[S[0],b[0],b[1],S[1]]:S[0]>b[0]&&S[0]<b[1]?[b[0],S[0],b[1],S[1]]:[S[0],b[0],S[1],b[1]]):S):0!==b.length?(b[0]+=d,b[1]+=d,b):[]}}return[]}function o(t,n,o,a){var s=o*o,u=n*n,l=t*t,c=-2*n,h=o*t+u-4*a,d=l*a-o*n*t+s,m=e.computeRealRoots(1,c,h,d);if(m.length>0){var p,f,v=m[0],g=n-v,_=g*g,y=t/2,w=g/2,C=_-4*a,E=_+4*Math.abs(a),S=l-4*v,b=l+4*Math.abs(v);if(0>v||S*E>C*b){var T=Math.sqrt(S);p=T/2,f=0===T?0:(t*w-o)/T}else{var x=Math.sqrt(C);p=0===x?0:(t*w-o)/x,f=x/2}var P,A;0===y&&0===p?(P=0,A=0):r.sign(y)===r.sign(p)?(P=y+p,A=v/P):(A=y-p,P=v/A);var I,D;0===w&&0===f?(I=0,D=0):r.sign(w)===r.sign(f)?(I=w+f,D=a/I):(D=w-f,I=a/D);var M=i.computeRealRoots(1,P,I),R=i.computeRealRoots(1,A,D);if(0!==M.length)return 0!==R.length?M[1]<=R[0]?[M[0],M[1],R[0],R[1]]:R[1]<=M[0]?[R[0],R[1],M[0],M[1]]:M[0]>=R[0]&&M[1]<=R[1]?[R[0],M[0],M[1],R[1]]:R[0]>=M[0]&&R[1]<=M[1]?[M[0],R[0],R[1],M[1]]:M[0]>R[0]&&M[0]<R[1]?[R[0],M[0],R[1],M[1]]:[M[0],R[0],M[1],R[1]]:M;if(0!==R.length)return R}return[]}var a={};return a.computeDiscriminant=function(e,r,i,n,o){if("number"!=typeof e)throw new t("a is a required number.");if("number"!=typeof r)throw new t("b is a required number.");if("number"!=typeof i)throw new t("c is a required number.");if("number"!=typeof n)throw new t("d is a required number.");if("number"!=typeof o)throw new t("e is a required number.");var a=e*e,s=a*e,u=r*r,l=u*r,c=i*i,h=c*i,d=n*n,m=d*n,p=o*o,f=p*o,v=u*c*d-4*l*m-4*e*h*d+18*e*r*i*m-27*a*d*d+256*s*f+o*(18*l*i*n-4*u*h+16*e*c*c-80*e*r*c*n-6*e*u*d+144*a*i*d)+p*(144*e*u*i-27*u*u-128*a*c-192*a*r*n);return v},a.computeRealRoots=function(i,a,s,u,l){if("number"!=typeof i)throw new t("a is a required number.");if("number"!=typeof a)throw new t("b is a required number.");if("number"!=typeof s)throw new t("c is a required number.");if("number"!=typeof u)throw new t("d is a required number.");if("number"!=typeof l)throw new t("e is a required number.");if(Math.abs(i)<r.EPSILON15)return e.computeRealRoots(a,s,u,l);var c=a/i,h=s/i,d=u/i,m=l/i,p=0>c?1:0;switch(p+=0>h?p+1:p,p+=0>d?p+1:p,p+=0>m?p+1:p){case 0:return n(c,h,d,m);case 1:return o(c,h,d,m);case 2:return o(c,h,d,m);case 3:return n(c,h,d,m);case 4:return n(c,h,d,m);case 5:return o(c,h,d,m);case 6:return n(c,h,d,m);case 7:return n(c,h,d,m);case 8:return o(c,h,d,m);case 9:return n(c,h,d,m);case 10:return n(c,h,d,m);case 11:return o(c,h,d,m);case 12:return n(c,h,d,m);case 13:return n(c,h,d,m);case 14:return n(c,h,d,m);case 15:return n(c,h,d,m);default:return void 0}},a}),r("Core/Ray",["./Cartesian3","./defaultValue","./defined","./DeveloperError"],function(e,t,r,i){"use strict";var n=function(r,i){i=e.clone(t(i,e.ZERO)),e.equals(i,e.ZERO)||e.normalize(i,i),this.origin=e.clone(t(r,e.ZERO)),this.direction=i};return n.getPoint=function(t,n,o){if(!r(t))throw new i("ray is requred");if("number"!=typeof n)throw new i("t is a required number");return r(o)||(o=new e),o=e.multiplyByScalar(t.direction,n,o),e.add(t.origin,o,o)},n}),r("Core/IntersectionTests",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Math","./Matrix3","./QuadraticRealPolynomial","./QuarticRealPolynomial","./Ray"],function(e,t,r,i,n,o,a,s,u,l){"use strict";function c(t,a,s,u,l){if(!i(t))throw new n("ray is required.");if(!i(a))throw new n("p0 is required.");if(!i(s))throw new n("p1 is required.");if(!i(u))throw new n("p2 is required.");l=r(l,!1);var c,h,d,m,p,f=t.origin,C=t.direction,E=e.subtract(s,a,v),S=e.subtract(u,a,g),b=e.cross(C,S,_),T=e.dot(E,b);if(l){if(T<o.EPSILON6)return void 0;if(c=e.subtract(f,a,y),d=e.dot(c,b),0>d||d>T)return void 0;if(h=e.cross(c,E,w),m=e.dot(C,h),0>m||d+m>T)return void 0;p=e.dot(S,h)/T}else{if(Math.abs(T)<o.EPSILON6)return void 0;var x=1/T;if(c=e.subtract(f,a,y),d=e.dot(c,b)*x,0>d||d>1)return void 0;if(h=e.cross(c,E,w),m=e.dot(C,h)*x,0>m||d+m>1)return void 0;p=e.dot(S,h)*x}return p}function h(e,t,r,i){var n=t*t-4*e*r;if(0>n)return void 0;if(n>0){var o=1/(2*e),a=Math.sqrt(n),s=(-t+a)*o,u=(-t-a)*o;return u>s?(i.root0=s,i.root1=u):(i.root0=u,i.root1=s),i}var l=-t/(2*e);return 0===l?void 0:(i.root0=i.root1=l,i)}function d(t,r,n){i(n)||(n={});var o=t.origin,a=t.direction,s=r.center,u=r.radius*r.radius,l=e.subtract(o,s,_),c=e.dot(a,a),d=2*e.dot(a,l),m=e.magnitudeSquared(l)-u,p=h(c,d,m,E);return i(p)?(n.start=p.root0,n.stop=p.root1,n):void 0}function m(e,t,r){var i=e+t;return o.sign(e)!==o.sign(t)&&Math.abs(i/Math.max(Math.abs(e),Math.abs(t)))<r?0:i}function p(t,r,i,n,l){var c,h=n*n,d=l*l,p=(t[a.COLUMN1ROW1]-t[a.COLUMN2ROW2])*d,f=l*(n*m(t[a.COLUMN1ROW0],t[a.COLUMN0ROW1],o.EPSILON15)+r.y),v=t[a.COLUMN0ROW0]*h+t[a.COLUMN2ROW2]*d+n*r.x+i,g=d*m(t[a.COLUMN2ROW1],t[a.COLUMN1ROW2],o.EPSILON15),_=l*(n*m(t[a.COLUMN2ROW0],t[a.COLUMN0ROW2])+r.z),y=[];if(0===_&&0===g){if(c=s.computeRealRoots(p,f,v),0===c.length)return y;var w=c[0],C=Math.sqrt(Math.max(1-w*w,0));if(y.push(new e(n,l*w,l*-C)),y.push(new e(n,l*w,l*C)),2===c.length){var E=c[1],S=Math.sqrt(Math.max(1-E*E,0));y.push(new e(n,l*E,l*-S)),y.push(new e(n,l*E,l*S))}return y}var b=_*_,T=g*g,x=p*p,P=_*g,A=x+T,I=2*(f*p+P),D=2*v*p+f*f-T+b,M=2*(v*f-P),R=v*v-b;if(0===A&&0===I&&0===D&&0===M)return y;c=u.computeRealRoots(A,I,D,M,R);var O=c.length;if(0===O)return y;for(var N=0;O>N;++N){var L,F=c[N],B=F*F,z=Math.max(1-B,0),V=Math.sqrt(z);L=o.sign(p)===o.sign(v)?m(p*B+v,f*F,o.EPSILON12):o.sign(v)===o.sign(f*F)?m(p*B,f*F+v,o.EPSILON12):m(p*B+f*F,v,o.EPSILON12);var k=m(g*F,_,o.EPSILON15),U=L*k;0>U?y.push(new e(n,l*F,l*V)):U>0?y.push(new e(n,l*F,l*-V)):0!==V?(y.push(new e(n,l*F,l*-V)),y.push(new e(n,l*F,l*V)),++N):y.push(new e(n,l*F,l*V))}return y}var f={};f.rayPlane=function(t,r,a){if(!i(t))throw new n("ray is required.");if(!i(r))throw new n("plane is required.");i(a)||(a=new e);var s=t.origin,u=t.direction,l=r.normal,c=e.dot(l,u);if(Math.abs(c)<o.EPSILON15)return void 0;var h=(-r.distance-e.dot(l,s))/c;return 0>h?void 0:(a=e.multiplyByScalar(u,h,a),e.add(s,a,a))};var v=new e,g=new e,_=new e,y=new e,w=new e;f.rayTriangle=function(t,r,n,o,a,s){var u=c(t,r,n,o,a);return!i(u)||0>u?void 0:(i(s)||(s=new e),e.multiplyByScalar(t.direction,u,s),e.add(t.origin,s,s))};var C=new l;f.lineSegmentTriangle=function(t,r,o,a,s,u,l){if(!i(t))throw new n("v0 is required.");if(!i(r))throw new n("v1 is required.");var h=C;e.clone(t,h.origin),e.subtract(r,t,h.direction),e.normalize(h.direction,h.direction);var d=c(h,o,a,s,u);return!i(d)||0>d||d>e.distance(t,r)?void 0:(i(l)||(l=new e),e.multiplyByScalar(h.direction,d,l),e.add(h.origin,l,l))};var E={root0:0,root1:0};f.raySphere=function(e,t,r){if(!i(e))throw new n("ray is required.");if(!i(t))throw new n("sphere is required.");return r=d(e,t,r),!i(r)||r.stop<0?void 0:(r.start=Math.max(r.start,0),r)};var S=new l;f.lineSegmentSphere=function(t,r,o,a){if(!i(t))throw new n("p0 is required.");if(!i(r))throw new n("p1 is required.");if(!i(o))throw new n("sphere is required.");var s=S,u=(e.clone(t,s.origin),e.subtract(r,t,s.direction)),l=e.magnitude(u);return e.normalize(u,u),a=d(s,o,a),!i(a)||a.stop<0||a.start>l?void 0:(a.start=Math.max(a.start,0),a.stop=Math.min(a.stop,l),a)};var b=new e,T=new e;f.rayEllipsoid=function(t,r){if(!i(t))throw new n("ray is required.");if(!i(r))throw new n("ellipsoid is required.");var o,a,s,u,l,c=r.oneOverRadii,h=e.multiplyComponents(c,t.origin,b),d=e.multiplyComponents(c,t.direction,T),m=e.magnitudeSquared(h),p=e.dot(h,d);if(m>1){if(p>=0)return void 0;var f=p*p;if(o=m-1,a=e.magnitudeSquared(d),s=a*o,s>f)return void 0;if(f>s){u=p*p-s,l=-p+Math.sqrt(u);var v=l/a,g=o/l;return g>v?{start:v,stop:g}:{start:g,stop:v}}var _=Math.sqrt(o/a);return{start:_,stop:_}}return 1>m?(o=m-1,a=e.magnitudeSquared(d),s=a*o,u=p*p-s,l=-p+Math.sqrt(u),{start:0,stop:l/a}):0>p?(a=e.magnitudeSquared(d),{start:0,stop:-p/a}):void 0};var x=new e,P=new e,A=new e,I=new e,D=new e,M=new a,R=new a,O=new a,N=new a,L=new a,F=new a,B=new a,z=new e,V=new e,k=new t;f.grazingAltitudeLocation=function(t,r){if(!i(t))throw new n("ray is required.");if(!i(r))throw new n("ellipsoid is required.");var s=t.origin,u=t.direction,l=r.geodeticSurfaceNormal(s,x);if(e.dot(u,l)>=0)return s;var c=i(this.rayEllipsoid(t,r)),h=r.transformPositionToScaledSpace(u,x),d=e.normalize(h,h),m=e.mostOrthogonalAxis(h,I),f=e.normalize(e.cross(m,d,P),P),v=e.normalize(e.cross(d,f,A),A),g=M;g[0]=d.x,g[1]=d.y,g[2]=d.z,g[3]=f.x,g[4]=f.y,g[5]=f.z,g[6]=v.x,g[7]=v.y,g[8]=v.z;var _=a.transpose(g,R),y=a.fromScale(r.radii,O),w=a.fromScale(r.oneOverRadii,N),C=L;C[0]=0,C[1]=-u.z,C[2]=u.y,C[3]=u.z,C[4]=0,C[5]=-u.x,C[6]=-u.y,C[7]=u.x,C[8]=0;var E,S,b=a.multiply(a.multiply(_,w,F),C,F),T=a.multiply(a.multiply(b,y,B),g,B),U=a.multiplyByVector(b,s,D),q=p(T,e.negate(U,x),0,0,1),G=q.length;if(G>0){for(var W=e.clone(e.ZERO,V),H=Number.NEGATIVE_INFINITY,j=0;G>j;++j){E=a.multiplyByVector(y,a.multiplyByVector(g,q[j],z),z);var Y=e.normalize(e.subtract(E,s,I),I),X=e.dot(Y,u);X>H&&(H=X,W=e.clone(E,W))}var Z=r.cartesianToCartographic(W,k);return H=o.clamp(H,0,1),S=e.magnitude(e.subtract(W,s,I))*Math.sqrt(1-H*H),S=c?-S:S,Z.height=S,r.cartographicToCartesian(Z,new e)}return void 0};var U=new e;return f.lineSegmentPlane=function(t,r,a,s){if(!i(t))throw new n("endPoint0 is required.");if(!i(r))throw new n("endPoint1 is required.");if(!i(a))throw new n("plane is required.");i(s)||(s=new e);var u=e.subtract(r,t,U),l=a.normal,c=e.dot(l,u);if(Math.abs(c)<o.EPSILON6)return void 0;var h=e.dot(l,t),d=-(a.distance+h)/c;return 0>d||d>1?void 0:(e.multiplyByScalar(u,d,s),e.add(t,s,s),s)},f.trianglePlaneIntersection=function(t,r,o,a){if(!(i(t)&&i(r)&&i(o)&&i(a)))throw new n("p0, p1, p2, and plane are required.");var s=a.normal,u=a.distance,l=e.dot(s,t)+u<0,c=e.dot(s,r)+u<0,h=e.dot(s,o)+u<0,d=0;d+=l?1:0,d+=c?1:0,d+=h?1:0;var m,p;if((1===d||2===d)&&(m=new e,p=new e),1===d){if(l)return f.lineSegmentPlane(t,r,a,m),f.lineSegmentPlane(t,o,a,p),{positions:[t,r,o,m,p],indices:[0,3,4,1,2,4,1,4,3]};if(c)return f.lineSegmentPlane(r,o,a,m),f.lineSegmentPlane(r,t,a,p),{positions:[t,r,o,m,p],indices:[1,3,4,2,0,4,2,4,3]};if(h)return f.lineSegmentPlane(o,t,a,m),f.lineSegmentPlane(o,r,a,p),{positions:[t,r,o,m,p],indices:[2,3,4,0,1,4,0,4,3]}}else if(2===d){if(!l)return f.lineSegmentPlane(r,t,a,m),f.lineSegmentPlane(o,t,a,p),{positions:[t,r,o,m,p],indices:[1,2,4,1,4,3,0,3,4]};if(!c)return f.lineSegmentPlane(o,r,a,m),f.lineSegmentPlane(t,r,a,p),{positions:[t,r,o,m,p],indices:[2,0,4,2,4,3,1,3,4]};if(!h)return f.lineSegmentPlane(t,o,a,m),f.lineSegmentPlane(r,o,a,p),{positions:[t,r,o,m,p],indices:[0,1,4,0,4,3,2,3,4]}}return void 0},f}),r("Core/EarthOrientationParametersSample",[],function(){"use strict";var e=function(e,t,r,i,n){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=r,this.yPoleOffset=i,this.ut1MinusUtc=n};return e}),r("ThirdParty/sprintf",[],function(){function e(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,t=arguments,r=0,i=t[r++],n=function(e,t,r,i){r||(r=" ");var n=e.length>=t?"":Array(1+t-e.length>>>0).join(r);return i?e+n:n+e},o=function(e,t,r,i,o,a){var s=i-e.length;return s>0&&(e=r||!o?n(e,i,a,r):e.slice(0,t.length)+n("",s,"0",!0)+e.slice(t.length)),e},a=function(e,t,r,i,a,s,u){var l=e>>>0;return r=r&&l&&{2:"0b",8:"0",16:"0x"}[t]||"",e=r+n(l.toString(t),s||0,"0",!1),o(e,r,i,a,u)},s=function(e,t,r,i,n,a){return null!=i&&(e=e.slice(0,i)),o(e,"",t,r,n,a)},u=function(e,i,u,l,c,h,d){var m,p,f,v,g;if("%%"==e)return"%";for(var _=!1,y="",w=!1,C=!1,E=" ",S=u.length,b=0;u&&S>b;b++)switch(u.charAt(b)){case" ":y=" ";break;case"+":y="+";break;case"-":_=!0;break;case"'":E=u.charAt(b+1);break;case"0":w=!0;break;case"#":C=!0}if(l=l?"*"==l?+t[r++]:"*"==l.charAt(0)?+t[l.slice(1,-1)]:+l:0,0>l&&(l=-l,_=!0),!isFinite(l))throw new Error("sprintf: (minimum-)width must be finite");switch(h=h?"*"==h?+t[r++]:"*"==h.charAt(0)?+t[h.slice(1,-1)]:+h:"fFeE".indexOf(d)>-1?6:"d"==d?0:void 0,g=i?t[i.slice(0,-1)]:t[r++],d){case"s":return s(String(g),_,l,h,w,E);case"c":return s(String.fromCharCode(+g),_,l,h,w);case"b":return a(g,2,C,_,l,h,w);case"o":return a(g,8,C,_,l,h,w);case"x":return a(g,16,C,_,l,h,w);case"X":return a(g,16,C,_,l,h,w).toUpperCase();case"u":return a(g,10,C,_,l,h,w);case"i":case"d":return m=+g||0,m=Math.round(m-m%1),p=0>m?"-":y,g=p+n(String(Math.abs(m)),h,"0",!1),o(g,p,_,l,w);case"e":case"E":case"f":case"F":case"g":case"G":return m=+g,p=0>m?"-":y,f=["toExponential","toFixed","toPrecision"]["efg".indexOf(d.toLowerCase())],v=["toString","toUpperCase"]["eEfFgG".indexOf(d)%2],g=p+Math.abs(m)[f](h),o(g,p,_,l,w)[v]();default:return e}};return i.replace(e,u)}return e}),r("Core/GregorianDate",[],function(){"use strict";var e=function(e,t,r,i,n,o,a,s){this.year=e,this.month=t,this.day=r,this.hour=i,this.minute=n,this.second=o,this.millisecond=a,this.isLeapSecond=s};return e}),r("Core/isLeapYear",["./DeveloperError"],function(e){"use strict";function t(t){if(null===t||isNaN(t))throw new e("year is required and must be a number.");return t%4===0&&t%100!==0||t%400===0}return t}),r("Core/LeapSecond",[],function(){"use strict";var e=function(e,t){this.julianDate=e,this.offset=t};return e}),r("Core/TimeConstants",["./freezeObject"],function(e){"use strict";var t={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5};return e(t)}),r("Core/TimeStandard",["./freezeObject"],function(e){"use strict";var t={UTC:0,TAI:1};return e(t)}),r("Core/JulianDate",["../ThirdParty/sprintf","./binarySearch","./defaultValue","./defined","./DeveloperError","./GregorianDate","./isLeapYear","./LeapSecond","./TimeConstants","./TimeStandard"],function(e,t,r,i,n,o,a,s,u,l){"use strict";function c(e,t){return I.compare(e.julianDate,t.julianDate)}function h(e){_.julianDate=e;var r=I.leapSeconds,i=t(r,_,c);0>i&&(i=~i),i>=r.length&&(i=r.length-1);var n=r[i].offset;if(i>0){var o=I.secondsDifference(r[i].julianDate,e);o>n&&(i--,n=r[i].offset)}I.addSeconds(e,n,e)}function d(e,r){_.julianDate=e;var i=I.leapSeconds,n=t(i,_,c);if(0>n&&(n=~n),0===n)return I.addSeconds(e,-i[0].offset,r);if(n>=i.length)return I.addSeconds(e,-i[n-1].offset,r);var o=I.secondsDifference(i[n].julianDate,e);return 0===o?I.addSeconds(e,-i[n].offset,r):1>=o?void 0:I.addSeconds(e,-i[--n].offset,r)}function m(e,t,r){var i=t/u.SECONDS_PER_DAY|0;return e+=i,t-=u.SECONDS_PER_DAY*i,0>t&&(e--,t+=u.SECONDS_PER_DAY),r.dayNumber=e,r.secondsOfDay=t,r}function p(e,t,r,i,n,o,a){var s=(t-14)/12|0,l=e+4800+s,c=(1461*l/4|0)+(367*(t-2-12*s)/12|0)-(3*((l+100)/100|0)/4|0)+r-32075;i-=12,0>i&&(i+=24);var h=o+(i*u.SECONDS_PER_HOUR+n*u.SECONDS_PER_MINUTE+a*u.SECONDS_PER_MILLISECOND);return h>=43200&&(c-=1),[c,h]}var f=new o,v=[31,28,31,30,31,30,31,31,30,31,30,31],g=29,_=new s,y=/^(\d{4})$/,w=/^(\d{4})-(\d{2})$/,C=/^(\d{4})-?(\d{3})$/,E=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,S=/^(\d{4})-?(\d{2})-?(\d{2})$/,b=/([Z+\-])?(\d{2})?:?(\d{2})?$/,T=/^(\d{2})(\.\d+)?/.source+b.source,x=/^(\d{2}):?(\d{2})(\.\d+)?/.source+b.source,P=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+b.source,A="Invalid ISO 8601 date.",I=function(e,t,i){this.dayNumber=void 0,this.secondsOfDay=void 0,e=r(e,0),t=r(t,0),i=r(i,l.UTC);var n=0|e;t+=(e-n)*u.SECONDS_PER_DAY,m(n,t,this),i===l.UTC&&h(this)};I.fromDate=function(e,t){if(!(e instanceof Date)||isNaN(e.getTime()))throw new n("date must be a valid JavaScript Date.");var r=p(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return i(t)?(m(r[0],r[1],t),h(t),t):new I(r[0],r[1],l.UTC)},I.fromIso8601=function(e,t){if("string"!=typeof e)throw new n(A);e=e.replace(",",".");var r,o,s,u=e.split("T"),c=1,d=1,f=0,_=0,b=0,D=0,M=u[0],R=u[1];if(!i(M))throw new n(A);var O;if(u=M.match(S),null!==u){if(O=M.split("-").length-1,O>0&&2!==O)throw new n(A);r=+u[1],c=+u[2],d=+u[3]}else if(u=M.match(w),null!==u)r=+u[1],c=+u[2];else if(u=M.match(y),null!==u)r=+u[1];else{var N;if(u=M.match(C),null!==u){if(r=+u[1],N=+u[2],s=a(r),1>N||s&&N>366||!s&&N>365)throw new n(A)}else{if(u=M.match(E),null===u)throw new n(A);r=+u[1];var L=+u[2],F=+u[3]||0;if(O=M.split("-").length-1,O>0&&(!i(u[3])&&1!==O||i(u[3])&&2!==O))throw new n(A);var B=new Date(Date.UTC(r,0,4));N=7*L+F-B.getUTCDay()-3}o=new Date(Date.UTC(r,0,1)),o.setUTCDate(N),c=o.getUTCMonth()+1,d=o.getUTCDate()}if(s=a(r),1>c||c>12||1>d||(2!==c||!s)&&d>v[c-1]||s&&2===c&&d>g)throw new n(A);var z;if(i(R)){if(u=R.match(P),null!==u){if(O=R.split(":").length-1,O>0&&2!==O&&3!==O)throw new n(A);f=+u[1],_=+u[2],b=+u[3],D=1e3*+(u[4]||0),z=5}else if(u=R.match(x),null!==u){if(O=R.split(":").length-1,O>0&&1!==O)throw new n(A);f=+u[1],_=+u[2],b=60*+(u[3]||0),z=4}else{if(u=R.match(T),null===u)throw new n(A);f=+u[1],_=60*+(u[2]||0),z=3}if(_>=60||b>=61||f>24||24===f&&(_>0||b>0||D>0))throw new n(A);var V=u[z],k=+u[z+1],U=+(u[z+2]||0);switch(V){case"+":f-=k,_-=U;break;case"-":f+=k,_+=U;break;case"Z":break;default:_+=new Date(Date.UTC(r,c-1,d,f,_)).getTimezoneOffset()}}else _+=new Date(r,c-1,d).getTimezoneOffset();var q=60===b;for(q&&b--;_>=60;)_-=60,f++;for(;f>=24;)f-=24,d++;for(o=s&&2===c?g:v[c-1];d>o;)d-=o,c++,c>12&&(c-=12,r++),o=s&&2===c?g:v[c-1];for(;0>_;)_+=60,f--;for(;0>f;)f+=24,d--;for(;1>d;)c--,1>c&&(c+=12,r--),o=s&&2===c?g:v[c-1],d+=o;var G=p(r,c,d,f,_,b,D);return i(t)?(m(G[0],G[1],t),h(t)):t=new I(G[0],G[1],l.UTC),q&&I.addSeconds(t,1,t),t},I.now=function(e){return I.fromDate(new Date,e)};var D=new I(0,0,l.TAI);return I.toGregorianDate=function(e,t){if(!i(e))throw new n("julianDate is required.");var r=!1,a=d(e,D);i(a)||(I.addSeconds(e,-1,D),a=d(D,D),r=!0);var s=a.dayNumber,l=a.secondsOfDay;l>=43200&&(s+=1);var c=s+68569|0,h=4*c/146097|0;c=c-((146097*h+3)/4|0)|0;var m=4e3*(c+1)/1461001|0;c=c-(1461*m/4|0)+31|0;var p=80*c/2447|0,f=c-(2447*p/80|0)|0;c=p/11|0;var v=p+2-12*c|0,g=100*(h-49)+m+c|0,_=l/u.SECONDS_PER_HOUR|0,y=l-_*u.SECONDS_PER_HOUR,w=y/u.SECONDS_PER_MINUTE|0;y-=w*u.SECONDS_PER_MINUTE;var C=0|y,E=(y-C)/u.SECONDS_PER_MILLISECOND;return _+=12,_>23&&(_-=24),r&&(C+=1),i(t)?(t.year=g,t.month=v,t.day=f,t.hour=_,t.minute=w,t.second=C,t.millisecond=E,t.isLeapSecond=r,t):new o(g,v,f,_,w,C,E,r)},I.toDate=function(e){if(!i(e))throw new n("julianDate is required.");var t=I.toGregorianDate(e,f),r=t.second;return t.isLeapSecond&&(r-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,r,t.millisecond))},I.toIso8601=function(t,r){if(!i(t))throw new n("julianDate is required.");var o,a=I.toGregorianDate(t,a);return i(r)||0===a.millisecond?i(r)&&0!==r?(o=(.01*a.millisecond).toFixed(r).replace(".","").slice(0,r),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",a.year,a.month,a.day,a.hour,a.minute,a.second,o)):e("%04d-%02d-%02dT%02d:%02d:%02dZ",a.year,a.month,a.day,a.hour,a.minute,a.second):(o=(.01*a.millisecond).toString().replace(".",""),e("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",a.year,a.month,a.day,a.hour,a.minute,a.second,o))},I.clone=function(e,t){return i(e)?i(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new I(e.dayNumber,e.secondsOfDay,l.TAI):void 0},I.compare=function(e,t){if(!i(e))throw new n("left is required.");if(!i(t))throw new n("right is required.");var r=e.dayNumber-t.dayNumber;return 0!==r?r:e.secondsOfDay-t.secondsOfDay},I.equals=function(e,t){return e===t||i(e)&&i(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},I.equalsEpsilon=function(e,t,r){if(!i(r))throw new n("epsilon is required.");return e===t||i(e)&&i(t)&&Math.abs(I.secondsDifference(e,t))<=r},I.totalDays=function(e){if(!i(e))throw new n("julianDate is required.");return e.dayNumber+e.secondsOfDay/u.SECONDS_PER_DAY},I.secondsDifference=function(e,t){if(!i(e))throw new n("left is required.");if(!i(t))throw new n("right is required.");var r=(e.dayNumber-t.dayNumber)*u.SECONDS_PER_DAY;return r+(e.secondsOfDay-t.secondsOfDay)},I.daysDifference=function(e,t){if(!i(e))throw new n("left is required.");if(!i(t))throw new n("right is required.");var r=e.dayNumber-t.dayNumber,o=(e.secondsOfDay-t.secondsOfDay)/u.SECONDS_PER_DAY;return r+o},I.computeTaiMinusUtc=function(e){_.julianDate=e;var r=I.leapSeconds,i=t(r,_,c);return 0>i&&(i=~i,--i,0>i&&(i=0)),r[i].offset},I.addSeconds=function(e,t,r){if(!i(e))throw new n("julianDate is required.");if(!i(t))throw new n("seconds is required.");if(!i(r))throw new n("result is required.");return m(e.dayNumber,e.secondsOfDay+t,r)},I.addMinutes=function(e,t,r){if(!i(e))throw new n("julianDate is required.");if(!i(t))throw new n("minutes is required.");if(!i(r))throw new n("result is required.");var o=e.secondsOfDay+t*u.SECONDS_PER_MINUTE;return m(e.dayNumber,o,r)},I.addHours=function(e,t,r){if(!i(e))throw new n("julianDate is required.");if(!i(t))throw new n("hours is required.");if(!i(r))throw new n("result is required.");var o=e.secondsOfDay+t*u.SECONDS_PER_HOUR;return m(e.dayNumber,o,r)},I.addDays=function(e,t,r){if(!i(e))throw new n("julianDate is required.");if(!i(t))throw new n("days is required.");if(!i(r))throw new n("result is required.");var o=e.dayNumber+t;return m(o,e.secondsOfDay,r)},I.lessThan=function(e,t){return I.compare(e,t)<0},I.lessThanOrEquals=function(e,t){return I.compare(e,t)<=0},I.greaterThan=function(e,t){return I.compare(e,t)>0},I.greaterThanOrEquals=function(e,t){return I.compare(e,t)>=0},I.prototype.clone=function(e){return I.clone(this,e)},I.prototype.equals=function(e){return I.equals(this,e)},I.prototype.equalsEpsilon=function(e,t){return I.equalsEpsilon(this,e,t)},I.prototype.toString=function(){return I.toIso8601(this)},I.leapSeconds=[new s(new I(2441317,43210,l.TAI),10),new s(new I(2441499,43211,l.TAI),11),new s(new I(2441683,43212,l.TAI),12),new s(new I(2442048,43213,l.TAI),13),new s(new I(2442413,43214,l.TAI),14),new s(new I(2442778,43215,l.TAI),15),new s(new I(2443144,43216,l.TAI),16),new s(new I(2443509,43217,l.TAI),17),new s(new I(2443874,43218,l.TAI),18),new s(new I(2444239,43219,l.TAI),19),new s(new I(2444786,43220,l.TAI),20),new s(new I(2445151,43221,l.TAI),21),new s(new I(2445516,43222,l.TAI),22),new s(new I(2446247,43223,l.TAI),23),new s(new I(2447161,43224,l.TAI),24),new s(new I(2447892,43225,l.TAI),25),new s(new I(2448257,43226,l.TAI),26),new s(new I(2448804,43227,l.TAI),27),new s(new I(2449169,43228,l.TAI),28),new s(new I(2449534,43229,l.TAI),29),new s(new I(2450083,43230,l.TAI),30),new s(new I(2450630,43231,l.TAI),31),new s(new I(2451179,43232,l.TAI),32),new s(new I(2453736,43233,l.TAI),33),new s(new I(2454832,43234,l.TAI),34),new s(new I(2456109,43235,l.TAI),35),new s(new I(2457204,43236,l.TAI),36)],I}),r("Core/EarthOrientationParameters",["../ThirdParty/when","./binarySearch","./defaultValue","./defined","./EarthOrientationParametersSample","./freezeObject","./JulianDate","./LeapSecond","./loadJson","./RuntimeError","./TimeConstants","./TimeStandard"],function(e,t,r,i,n,o,a,s,u,l,c,h){"use strict";function d(e,t){return a.compare(e.julianDate,t)}function m(e,r){if(!i(r.columnNames))return void(e._dataError="Error in loaded EOP data: The columnNames property is required.");if(!i(r.samples))return void(e._dataError="Error in loaded EOP data: The samples property is required.");var n=r.columnNames.indexOf("modifiedJulianDateUtc"),o=r.columnNames.indexOf("xPoleWanderRadians"),u=r.columnNames.indexOf("yPoleWanderRadians"),l=r.columnNames.indexOf("ut1MinusUtcSeconds"),m=r.columnNames.indexOf("xCelestialPoleOffsetRadians"),p=r.columnNames.indexOf("yCelestialPoleOffsetRadians"),f=r.columnNames.indexOf("taiMinusUtcSeconds");if(0>n||0>o||0>u||0>l||0>m||0>p||0>f)return void(e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns");var v=e._samples=r.samples,g=e._dates=[];e._dateColumn=n,e._xPoleWanderRadiansColumn=o,e._yPoleWanderRadiansColumn=u,e._ut1MinusUtcSecondsColumn=l,e._xCelestialPoleOffsetRadiansColumn=m,e._yCelestialPoleOffsetRadiansColumn=p,e._taiMinusUtcSecondsColumn=f,e._columnCount=r.columnNames.length,e._lastIndex=void 0;for(var _,y=e._addNewLeapSeconds,w=0,C=v.length;C>w;w+=e._columnCount){var E=v[w+n],S=v[w+f],b=E+c.MODIFIED_JULIAN_DATE_DIFFERENCE,T=new a(b,S,h.TAI);if(g.push(T),y){if(S!==_&&i(_)){var x=a.leapSeconds,P=t(x,T,d);if(0>P){var A=new s(T,S);x.splice(~P,0,A)}}_=S}}}function p(e,t,r,i,n){var o=r*i;n.xPoleWander=t[o+e._xPoleWanderRadiansColumn],n.yPoleWander=t[o+e._yPoleWanderRadiansColumn],n.xPoleOffset=t[o+e._xCelestialPoleOffsetRadiansColumn],n.yPoleOffset=t[o+e._yCelestialPoleOffsetRadiansColumn],n.ut1MinusUtc=t[o+e._ut1MinusUtcSecondsColumn]}function f(e,t,r){return t+e*(r-t)}function v(e,t,r,i,n,o,s){var u=e._columnCount;if(o>t.length-1)return s.xPoleWander=0,s.yPoleWander=0,s.xPoleOffset=0,s.yPoleOffset=0,s.ut1MinusUtc=0,s;var l=t[n],c=t[o];if(l.equals(c)||i.equals(l))return p(e,r,n,u,s),s;if(i.equals(c))return p(e,r,o,u,s),s;var h=a.secondsDifference(i,l)/a.secondsDifference(c,l),d=n*u,m=o*u,v=r[d+e._ut1MinusUtcSecondsColumn],g=r[m+e._ut1MinusUtcSecondsColumn],_=g-v;if(_>.5||-.5>_){var y=r[d+e._taiMinusUtcSecondsColumn],w=r[m+e._taiMinusUtcSecondsColumn];y!==w&&(c.equals(i)?v=g:g-=w-y)}return s.xPoleWander=f(h,r[d+e._xPoleWanderRadiansColumn],r[m+e._xPoleWanderRadiansColumn]),s.yPoleWander=f(h,r[d+e._yPoleWanderRadiansColumn],r[m+e._yPoleWanderRadiansColumn]),s.xPoleOffset=f(h,r[d+e._xCelestialPoleOffsetRadiansColumn],r[m+e._xCelestialPoleOffsetRadiansColumn]),
s.yPoleOffset=f(h,r[d+e._yCelestialPoleOffsetRadiansColumn],r[m+e._yCelestialPoleOffsetRadiansColumn]),s.ut1MinusUtc=f(h,v,g),s}var g=function(t){if(t=r(t,r.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=r(t.addNewLeapSeconds,!0),i(t.data))m(this,t.data);else if(i(t.url)){var n=this;this._downloadPromise=e(u(t.url),function(e){m(n,e)},function(){n._dataError="An error occurred while retrieving the EOP data from the URL "+t.url+"."})}else m(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})};return g.NONE=o({getPromiseToLoad:function(){return e()},compute:function(e,t){return i(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new n(0,0,0,0,0),t}}),g.prototype.getPromiseToLoad=function(){return e(this._downloadPromise)},g.prototype.compute=function(e,r){if(!i(this._samples)){if(i(this._dataError))throw new l(this._dataError);return void 0}if(i(r)||(r=new n(0,0,0,0,0)),0===this._samples.length)return r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0,r;var o=this._dates,s=this._lastIndex,u=0,c=0;if(i(s)){var h=o[s],d=o[s+1],m=a.lessThanOrEquals(h,e),p=!i(d),f=p||a.greaterThanOrEquals(d,e);if(m&&f)return u=s,!p&&d.equals(e)&&++u,c=u+1,v(this,o,this._samples,e,u,c,r),r}var g=t(o,e,a.compare,this._dateColumn);return g>=0?(g<o.length-1&&o[g+1].equals(e)&&++g,u=g,c=g):(c=~g,u=c-1,0>u&&(u=0)),this._lastIndex=u,v(this,o,this._samples,e,u,c,r),r},g}),r("Core/Iau2006XysSample",[],function(){"use strict";var e=function(e,t,r){this.x=e,this.y=t,this.s=r};return e}),r("Core/Iau2006XysData",["../ThirdParty/when","./buildModuleUrl","./defaultValue","./defined","./Iau2006XysSample","./JulianDate","./loadJson","./TimeStandard"],function(e,t,r,i,n,o,a,s){"use strict";function u(e,t,r){var i=h;return i.dayNumber=t,i.secondsOfDay=r,o.daysDifference(i,e._sampleZeroDateTT)}function l(r,n){if(r._chunkDownloadsInProgress[n])return r._chunkDownloadsInProgress[n];var o=e.defer();r._chunkDownloadsInProgress[n]=o;var s,u=r._xysFileUrlTemplate;return s=i(u)?u.replace("{0}",n):t("Assets/IAU2006_XYS/IAU2006_XYS_"+n+".json"),e(a(s),function(e){r._chunkDownloadsInProgress[n]=!1;for(var t=r._samples,i=e.samples,a=n*r._samplesPerXysFile*3,s=0,u=i.length;u>s;++s)t[a+s]=i[s];o.resolve()}),o.promise}var c=function(e){e=r(e,r.EMPTY_OBJECT),this._xysFileUrlTemplate=e.xysFileUrlTemplate,this._interpolationOrder=r(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=r(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new o(this._sampleZeroJulianEphemerisDate,0,s.TAI),this._stepSizeDays=r(e.stepSizeDays,1),this._samplesPerXysFile=r(e.samplesPerXysFile,1e3),this._totalSamples=r(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,i=this._denominators=new Array(t+1),n=this._xTable=new Array(t+1),a=Math.pow(this._stepSizeDays,t),u=0;t>=u;++u){i[u]=a,n[u]=u*this._stepSizeDays;for(var l=0;t>=l;++l)l!==u&&(i[u]*=u-l);i[u]=1/i[u]}this._work=new Array(t+1),this._coef=new Array(t+1)},h=new o(0,0,s.TAI);return c.prototype.preload=function(t,r,i,n){var o=u(this,t,r),a=u(this,i,n),s=o/this._stepSizeDays-this._interpolationOrder/2|0;0>s&&(s=0);var c=a/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;c>=this._totalSamples&&(c=this._totalSamples-1);for(var h=s/this._samplesPerXysFile|0,d=c/this._samplesPerXysFile|0,m=[],p=h;d>=p;++p)m.push(l(this,p));return e.all(m)},c.prototype.computeXysRadians=function(e,t,r){var o=u(this,e,t);if(0>o)return void 0;var a=o/this._stepSizeDays|0;if(a>=this._totalSamples)return void 0;var s=this._interpolationOrder,c=a-(s/2|0);0>c&&(c=0);var h=c+s;h>=this._totalSamples&&(h=this._totalSamples-1,c=h-s,0>c&&(c=0));var d=!1,m=this._samples;if(i(m[3*c])||(l(this,c/this._samplesPerXysFile|0),d=!0),i(m[3*h])||(l(this,h/this._samplesPerXysFile|0),d=!0),d)return void 0;i(r)?(r.x=0,r.y=0,r.s=0):r=new n(0,0,0);var p,f,v=o-c*this._stepSizeDays,g=this._work,_=this._denominators,y=this._coef,w=this._xTable;for(p=0;s>=p;++p)g[p]=v-w[p];for(p=0;s>=p;++p){for(y[p]=1,f=0;s>=f;++f)f!==p&&(y[p]*=g[f]);y[p]*=_[p];var C=3*(c+p);r.x+=y[p]*m[C++],r.y+=y[p]*m[C++],r.s+=y[p]*m[C]}return r},c}),r("Core/Quaternion",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math","./Matrix3"],function(e,t,r,i,n,o,a,s){"use strict";var u=function(e,r,i,n){this.x=t(e,0),this.y=t(r,0),this.z=t(i,0),this.w=t(n,0)},l=new e;u.fromAxisAngle=function(t,n,o){if(!r(t))throw new i("axis is required.");if("number"!=typeof n)throw new i("angle is required and must be a number.");var a=n/2,s=Math.sin(a);l=e.normalize(t,l);var c=l.x*s,h=l.y*s,d=l.z*s,m=Math.cos(a);return r(o)?(o.x=c,o.y=h,o.z=d,o.w=m,o):new u(c,h,d,m)};var c=[1,2,0],h=new Array(3);u.fromRotationMatrix=function(e,t){if(!r(e))throw new i("matrix is required.");var n,o,a,l,d,m=e[s.COLUMN0ROW0],p=e[s.COLUMN1ROW1],f=e[s.COLUMN2ROW2],v=m+p+f;if(v>0)n=Math.sqrt(v+1),d=.5*n,n=.5/n,o=(e[s.COLUMN1ROW2]-e[s.COLUMN2ROW1])*n,a=(e[s.COLUMN2ROW0]-e[s.COLUMN0ROW2])*n,l=(e[s.COLUMN0ROW1]-e[s.COLUMN1ROW0])*n;else{var g=c,_=0;p>m&&(_=1),f>m&&f>p&&(_=2);var y=g[_],w=g[y];n=Math.sqrt(e[s.getElementIndex(_,_)]-e[s.getElementIndex(y,y)]-e[s.getElementIndex(w,w)]+1);var C=h;C[_]=.5*n,n=.5/n,d=(e[s.getElementIndex(w,y)]-e[s.getElementIndex(y,w)])*n,C[y]=(e[s.getElementIndex(y,_)]+e[s.getElementIndex(_,y)])*n,C[w]=(e[s.getElementIndex(w,_)]+e[s.getElementIndex(_,w)])*n,o=-C[0],a=-C[1],l=-C[2]}return r(t)?(t.x=o,t.y=a,t.z=l,t.w=d,t):new u(o,a,l,d)};var d=new u;u.fromHeadingPitchRoll=function(t,n,o,a){if(!r(t))throw new i("heading is required.");if(!r(n))throw new i("pitch is required.");if(!r(o))throw new i("roll is required.");var s=u.fromAxisAngle(e.UNIT_X,o,d),l=u.fromAxisAngle(e.UNIT_Y,-n,a);a=u.multiply(l,s,l);var c=u.fromAxisAngle(e.UNIT_Z,-t,d);return u.multiply(c,a,a)};var m=new e,p=new e,f=new u,v=new u,g=new u;u.packedLength=4,u.pack=function(e,n,o){if(!r(e))throw new i("value is required");if(!r(n))throw new i("array is required");o=t(o,0),n[o++]=e.x,n[o++]=e.y,n[o++]=e.z,n[o]=e.w},u.unpack=function(e,n,o){if(!r(e))throw new i("array is required");return n=t(n,0),r(o)||(o=new u),o.x=e[n],o.y=e[n+1],o.z=e[n+2],o.w=e[n+3],o},u.packedInterpolationLength=3,u.convertPackedArrayForInterpolation=function(e,t,r,i){u.unpack(e,4*r,g),u.conjugate(g,g);for(var n=0,o=r-t+1;o>n;n++){var a=3*n;u.unpack(e,4*(t+n),f),u.multiply(f,g,f),f.w<0&&u.negate(f,f),u.computeAxis(f,m);var s=u.computeAngle(f);i[a]=m.x*s,i[a+1]=m.y*s,i[a+2]=m.z*s}},u.unpackInterpolationResult=function(t,i,n,o,a){r(a)||(a=new u),e.fromArray(t,0,p);var s=e.magnitude(p);return u.unpack(i,4*o,v),0===s?u.clone(u.IDENTITY,f):u.fromAxisAngle(p,s,f),u.multiply(f,v,a)},u.clone=function(e,t){return r(e)?r(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new u(e.x,e.y,e.z,e.w):void 0},u.conjugate=function(e,t){if(!r(e))throw new i("quaternion is required");if(!r(t))throw new i("result is required");return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t},u.magnitudeSquared=function(e){if(!r(e))throw new i("quaternion is required");return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},u.magnitude=function(e){return Math.sqrt(u.magnitudeSquared(e))},u.normalize=function(e,t){if(!r(t))throw new i("result is required");var n=1/u.magnitude(e),o=e.x*n,a=e.y*n,s=e.z*n,l=e.w*n;return t.x=o,t.y=a,t.z=s,t.w=l,t},u.inverse=function(e,t){if(!r(t))throw new i("result is required");var n=u.magnitudeSquared(e);return t=u.conjugate(e,t),u.multiplyByScalar(t,1/n,t)},u.add=function(e,t,n){if(!r(e))throw new i("left is required");if(!r(t))throw new i("right is required");if(!r(n))throw new i("result is required");return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n},u.subtract=function(e,t,n){if(!r(e))throw new i("left is required");if(!r(t))throw new i("right is required");if(!r(n))throw new i("result is required");return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n},u.negate=function(e,t){if(!r(e))throw new i("quaternion is required");if(!r(t))throw new i("result is required");return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},u.dot=function(e,t){if(!r(e))throw new i("left is required");if(!r(t))throw new i("right is required");return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},u.multiply=function(e,t,n){if(!r(e))throw new i("left is required");if(!r(t))throw new i("right is required");if(!r(n))throw new i("result is required");var o=e.x,a=e.y,s=e.z,u=e.w,l=t.x,c=t.y,h=t.z,d=t.w,m=u*l+o*d+a*h-s*c,p=u*c-o*h+a*d+s*l,f=u*h+o*c-a*l+s*d,v=u*d-o*l-a*c-s*h;return n.x=m,n.y=p,n.z=f,n.w=v,n},u.multiplyByScalar=function(e,t,n){if(!r(e))throw new i("quaternion is required");if("number"!=typeof t)throw new i("scalar is required and must be a number.");if(!r(n))throw new i("result is required");return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n},u.divideByScalar=function(e,t,n){if(!r(e))throw new i("quaternion is required");if("number"!=typeof t)throw new i("scalar is required and must be a number.");if(!r(n))throw new i("result is required");return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n},u.computeAxis=function(e,t){if(!r(e))throw new i("quaternion is required");if(!r(t))throw new i("result is required");var n=e.w;if(Math.abs(n-1)<a.EPSILON6)return t.x=t.y=t.z=0,t;var o=1/Math.sqrt(1-n*n);return t.x=e.x*o,t.y=e.y*o,t.z=e.z*o,t},u.computeAngle=function(e){if(!r(e))throw new i("quaternion is required");return Math.abs(e.w-1)<a.EPSILON6?0:2*Math.acos(e.w)};var _=new u;u.lerp=function(e,t,n,o){if(!r(e))throw new i("start is required.");if(!r(t))throw new i("end is required.");if("number"!=typeof n)throw new i("t is required and must be a number.");if(!r(o))throw new i("result is required");return _=u.multiplyByScalar(t,n,_),o=u.multiplyByScalar(e,1-n,o),u.add(_,o,o)};var y=new u,w=new u,C=new u;u.slerp=function(e,t,n,o){if(!r(e))throw new i("start is required.");if(!r(t))throw new i("end is required.");if("number"!=typeof n)throw new i("t is required and must be a number.");if(!r(o))throw new i("result is required");var s=u.dot(e,t),l=t;if(0>s&&(s=-s,l=y=u.negate(t,y)),1-s<a.EPSILON6)return u.lerp(e,l,n,o);var c=Math.acos(s);return w=u.multiplyByScalar(e,Math.sin((1-n)*c),w),C=u.multiplyByScalar(l,Math.sin(n*c),C),o=u.add(w,C,o),u.multiplyByScalar(o,1/Math.sin(c),o)},u.log=function(t,n){if(!r(t))throw new i("quaternion is required.");if(!r(n))throw new i("result is required");var o=a.acosClamped(t.w),s=0;return 0!==o&&(s=o/Math.sin(o)),e.multiplyByScalar(t,s,n)},u.exp=function(t,n){if(!r(t))throw new i("cartesian is required.");if(!r(n))throw new i("result is required");var o=e.magnitude(t),a=0;return 0!==o&&(a=Math.sin(o)/o),n.x=t.x*a,n.y=t.y*a,n.z=t.z*a,n.w=Math.cos(o),n};var E=new e,S=new e,b=new u,T=new u;u.computeInnerQuadrangle=function(t,n,o,a){if(!r(t)||!r(n)||!r(o))throw new i("q0, q1, and q2 are required.");if(!r(a))throw new i("result is required");var s=u.conjugate(n,b);u.multiply(s,o,T);var l=u.log(T,E);u.multiply(s,t,T);var c=u.log(T,S);return e.add(l,c,l),e.multiplyByScalar(l,.25,l),e.negate(l,l),u.exp(l,b),u.multiply(n,b,a)},u.squad=function(e,t,n,o,a,s){if(!(r(e)&&r(t)&&r(n)&&r(o)))throw new i("q0, q1, s0, and s1 are required.");if("number"!=typeof a)throw new i("t is required and must be a number.");if(!r(s))throw new i("result is required");var l=u.slerp(e,t,a,b),c=u.slerp(n,o,a,T);return u.slerp(l,c,2*a*(1-a),s)};for(var x=new u,P=1.9011074535173003,A=n.supportsTypedArrays()?new Float32Array(8):[],I=n.supportsTypedArrays()?new Float32Array(8):[],D=n.supportsTypedArrays()?new Float32Array(8):[],M=n.supportsTypedArrays()?new Float32Array(8):[],R=0;7>R;++R){var O=R+1,N=2*O+1;A[R]=1/(O*N),I[R]=O/N}return A[7]=P/136,I[7]=8*P/17,u.fastSlerp=function(e,t,n,o){if(!r(e))throw new i("start is required.");if(!r(t))throw new i("end is required.");if("number"!=typeof n)throw new i("t is required and must be a number.");if(!r(o))throw new i("result is required");var a,s=u.dot(e,t);s>=0?a=1:(a=-1,s=-s);for(var l=s-1,c=1-n,h=n*n,d=c*c,m=7;m>=0;--m)D[m]=(A[m]*h-I[m])*l,M[m]=(A[m]*d-I[m])*l;var p=a*n*(1+D[0]*(1+D[1]*(1+D[2]*(1+D[3]*(1+D[4]*(1+D[5]*(1+D[6]*(1+D[7])))))))),f=c*(1+M[0]*(1+M[1]*(1+M[2]*(1+M[3]*(1+M[4]*(1+M[5]*(1+M[6]*(1+M[7])))))))),v=u.multiplyByScalar(e,f,x);return u.multiplyByScalar(t,p,o),u.add(v,o,o)},u.fastSquad=function(e,t,n,o,a,s){if(!(r(e)&&r(t)&&r(n)&&r(o)))throw new i("q0, q1, s0, and s1 are required.");if("number"!=typeof a)throw new i("t is required and must be a number.");if(!r(s))throw new i("result is required");var l=u.fastSlerp(e,t,a,b),c=u.fastSlerp(n,o,a,T);return u.fastSlerp(l,c,2*a*(1-a),s)},u.equals=function(e,t){return e===t||r(e)&&r(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},u.equalsEpsilon=function(e,t,n){if("number"!=typeof n)throw new i("epsilon is required and must be a number.");return e===t||r(e)&&r(t)&&Math.abs(e.x-t.x)<=n&&Math.abs(e.y-t.y)<=n&&Math.abs(e.z-t.z)<=n&&Math.abs(e.w-t.w)<=n},u.ZERO=o(new u(0,0,0,0)),u.IDENTITY=o(new u(0,0,0,1)),u.prototype.clone=function(e){return u.clone(this,e)},u.prototype.equals=function(e){return u.equals(this,e)},u.prototype.equalsEpsilon=function(e,t){return u.equalsEpsilon(this,e,t)},u.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"},u}),r("Core/Transforms",["../ThirdParty/when","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./DeveloperError","./EarthOrientationParameters","./EarthOrientationParametersSample","./Ellipsoid","./Iau2006XysData","./Iau2006XysSample","./JulianDate","./Math","./Matrix3","./Matrix4","./Quaternion","./TimeConstants"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f,v,g){"use strict";var _={},y=new r,w=new r,C=new r;_.eastNorthUpToFixedFrame=function(e,t,i){if(!o(e))throw new a("origin is required.");if(m.equalsEpsilon(e.x,0,m.EPSILON14)&&m.equalsEpsilon(e.y,0,m.EPSILON14)){var s=m.sign(e.z);return o(i)?(i[0]=0,i[1]=1,i[2]=0,i[3]=0,i[4]=-s,i[5]=0,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=s,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i):new f(0,-s,0,e.x,1,0,0,e.y,0,0,s,e.z,0,0,0,1)}var u=y,c=w,h=C;return t=n(t,l.WGS84),t.geodeticSurfaceNormal(e,u),c.x=-e.y,c.y=e.x,c.z=0,r.normalize(c,c),r.cross(u,c,h),o(i)?(i[0]=c.x,i[1]=c.y,i[2]=c.z,i[3]=0,i[4]=h.x,i[5]=h.y,i[6]=h.z,i[7]=0,i[8]=u.x,i[9]=u.y,i[10]=u.z,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i):new f(c.x,h.x,u.x,e.x,c.y,h.y,u.y,e.y,c.z,h.z,u.z,e.z,0,0,0,1)};var E=new r,S=new r,b=new r;_.northEastDownToFixedFrame=function(e,t,i){if(!o(e))throw new a("origin is required.");if(m.equalsEpsilon(e.x,0,m.EPSILON14)&&m.equalsEpsilon(e.y,0,m.EPSILON14)){var s=m.sign(e.z);return o(i)?(i[0]=-s,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=1,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=-s,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i):new f(-s,0,0,e.x,0,1,0,e.y,0,0,-s,e.z,0,0,0,1)}var u=E,c=S,h=b;return t=n(t,l.WGS84),t.geodeticSurfaceNormal(e,u),c.x=-e.y,c.y=e.x,c.z=0,r.normalize(c,c),r.cross(u,c,h),o(i)?(i[0]=h.x,i[1]=h.y,i[2]=h.z,i[3]=0,i[4]=c.x,i[5]=c.y,i[6]=c.z,i[7]=0,i[8]=-u.x,i[9]=-u.y,i[10]=-u.z,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i):new f(h.x,c.x,-u.x,e.x,h.y,c.y,-u.y,e.y,h.z,c.z,-u.z,e.z,0,0,0,1)},_.northUpEastToFixedFrame=function(e,t,i){if(!o(e))throw new a("origin is required.");if(m.equalsEpsilon(e.x,0,m.EPSILON14)&&m.equalsEpsilon(e.y,0,m.EPSILON14)){var s=m.sign(e.z);return o(i)?(i[0]=-s,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=0,i[6]=s,i[7]=0,i[8]=0,i[9]=1,i[10]=0,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i):new f(-s,0,0,e.x,0,0,1,e.y,0,s,0,e.z,0,0,0,1)}var u=y,c=w,h=C;return t=n(t,l.WGS84),t.geodeticSurfaceNormal(e,u),c.x=-e.y,c.y=e.x,c.z=0,r.normalize(c,c),r.cross(u,c,h),o(i)?(i[0]=h.x,i[1]=h.y,i[2]=h.z,i[3]=0,i[4]=u.x,i[5]=u.y,i[6]=u.z,i[7]=0,i[8]=c.x,i[9]=c.y,i[10]=c.z,i[11]=0,i[12]=e.x,i[13]=e.y,i[14]=e.z,i[15]=1,i):new f(h.x,u.x,c.x,e.x,h.y,u.y,c.y,e.y,h.z,u.z,c.z,e.z,0,0,0,1)};var T=new v,x=new r(1,1,1),P=new f;_.headingPitchRollToFixedFrame=function(e,t,i,n,o,a){var s=v.fromHeadingPitchRoll(t,i,n,T),u=f.fromTranslationQuaternionRotationScale(r.ZERO,s,x,P);return a=_.eastNorthUpToFixedFrame(e,o,a),f.multiply(a,u,a)};var A=new f,I=new p;_.headingPitchRollQuaternion=function(e,t,r,i,n,o){var a=_.headingPitchRollToFixedFrame(e,t,r,i,n,A),s=f.getRotation(a,I);return v.fromRotationMatrix(s,o)};var D=24110.54841,M=8640184.812866,R=.093104,O=-62e-7,N=1.1772758384668e-19,L=72921158553e-15,F=m.TWO_PI/86400,B=new d;_.computeTemeToPseudoFixedMatrix=function(e,t){if(!o(e))throw new a("date is required.");B=d.addSeconds(e,-d.computeTaiMinusUtc(e),B);var r,i=B.dayNumber,n=B.secondsOfDay,s=i-2451545;r=n>=43200?(s+.5)/g.DAYS_PER_JULIAN_CENTURY:(s-.5)/g.DAYS_PER_JULIAN_CENTURY;var u=D+r*(M+r*(R+r*O)),l=u*F%m.TWO_PI,c=L+N*(i-2451545.5),h=(n+.5*g.SECONDS_PER_DAY)%g.SECONDS_PER_DAY,f=l+c*h,v=Math.cos(f),_=Math.sin(f);return o(t)?(t[0]=v,t[1]=-_,t[2]=0,t[3]=_,t[4]=v,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new p(v,_,0,-_,v,0,0,0,1)},_.iau2006XysData=new c,_.earthOrientationParameters=s.NONE;var z=32.184,V=2451545;_.preloadIcrfFixed=function(t){var r=t.start.dayNumber,i=t.start.secondsOfDay+z,n=t.stop.dayNumber,o=t.stop.secondsOfDay+z,a=_.iau2006XysData.preload(r,i,n,o),s=_.earthOrientationParameters.getPromiseToLoad();return e.all([a,s])},_.computeIcrfToFixedMatrix=function(e,t){if(!o(e))throw new a("date is required.");o(t)||(t=new p);var r=_.computeFixedToIcrfMatrix(e,t);return o(r)?p.transpose(r,t):void 0};var k=new h(0,0,0),U=new u(0,0,0,0,0,0),q=new p,G=new p;_.computeFixedToIcrfMatrix=function(e,t){if(!o(e))throw new a("date is required.");o(t)||(t=new p);var r=_.earthOrientationParameters.compute(e,U);if(!o(r))return void 0;var i=e.dayNumber,n=e.secondsOfDay+z,s=_.iau2006XysData.computeXysRadians(i,n,k);if(!o(s))return void 0;var u=s.x+r.xPoleOffset,l=s.y+r.yPoleOffset,c=1/(1+Math.sqrt(1-u*u-l*l)),h=q;h[0]=1-c*u*u,h[3]=-c*u*l,h[6]=u,h[1]=-c*u*l,h[4]=1-c*l*l,h[7]=l,h[2]=-u,h[5]=-l,h[8]=1-c*(u*u+l*l);var f=p.fromRotationZ(-s.s,G),v=p.multiply(h,f,q),y=e.dayNumber,w=e.secondsOfDay-d.computeTaiMinusUtc(e)+r.ut1MinusUtc,C=y-2451545,E=w/g.SECONDS_PER_DAY,S=.779057273264+E+.00273781191135448*(C+E);S=S%1*m.TWO_PI;var b=p.fromRotationZ(S,G),T=p.multiply(v,b,q),x=Math.cos(r.xPoleWander),P=Math.cos(r.yPoleWander),A=Math.sin(r.xPoleWander),I=Math.sin(r.yPoleWander),D=i-V+n/g.SECONDS_PER_DAY;D/=36525;var M=-47e-6*D*m.RADIANS_PER_DEGREE/3600,R=Math.cos(M),O=Math.sin(M),N=G;return N[0]=x*R,N[1]=x*O,N[2]=A,N[3]=-P*O+I*A*R,N[4]=P*R+I*A*O,N[5]=-I*x,N[6]=-I*O-P*A*R,N[7]=I*R-P*A*O,N[8]=P*x,p.multiply(T,N,t)};var W=new i;_.pointToWindowCoordinates=function(e,t,r,i){return i=_.pointToGLWindowCoordinates(e,t,r,i),i.y=2*t[5]-i.y,i},_.pointToGLWindowCoordinates=function(e,r,n,s){if(!o(e))throw new a("modelViewProjectionMatrix is required.");if(!o(r))throw new a("viewportTransformation is required.");if(!o(n))throw new a("point is required.");o(s)||(s=new t);var u=W;return f.multiplyByVector(e,i.fromElements(n.x,n.y,n.z,1,u),u),i.multiplyByScalar(u,1/u.w,u),f.multiplyByVector(r,u,u),t.fromCartesian4(u,s)};var H=new r,j=new r,Y=new r;return _.rotationMatrixFromPositionVelocity=function(e,t,i,s){if(!o(e))throw new a("position is required.");if(!o(t))throw new a("velocity is required.");var u=n(i,l.WGS84).geodeticSurfaceNormal(e,H),c=r.cross(t,u,j);r.equalsEpsilon(c,r.ZERO,m.EPSILON6)&&(c=r.clone(r.UNIT_X,c));var h=r.cross(c,t,Y);return r.cross(t,h,c),r.negate(c,c),o(s)||(s=new p),s[0]=t.x,s[1]=t.y,s[2]=t.z,s[3]=c.x,s[4]=c.y,s[5]=c.z,s[6]=h.x,s[7]=h.y,s[8]=h.z,s},_}),r("Core/EllipsoidTangentPlane",["./AxisAlignedBoundingBox","./Cartesian2","./Cartesian3","./Cartesian4","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./IntersectionTests","./Matrix3","./Matrix4","./Plane","./Ray","./Transforms"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p){"use strict";var f=new i,v=function(e,t){if(!o(e))throw new s("origin is required.");if(t=n(t,u.WGS84),e=t.scaleToGeodeticSurface(e),!o(e))throw new s("origin must not be at the center of the ellipsoid.");var i=p.eastNorthUpToFixedFrame(e,t);this._ellipsoid=t,this._origin=e,this._xAxis=r.fromCartesian4(h.getColumn(i,0,f)),this._yAxis=r.fromCartesian4(h.getColumn(i,1,f));var a=r.fromCartesian4(h.getColumn(i,2,f));this._plane=d.fromPointNormal(e,a)};a(v.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},origin:{get:function(){return this._origin}},plane:{get:function(){return this._plane}},xAxis:{get:function(){return this._xAxis}},yAxis:{get:function(){return this._yAxis}},zAxis:{get:function(){return this._plane.normal}}});var g=new e;v.fromPoints=function(t,r){if(!o(t))throw new s("cartesians is required.");var i=e.fromPoints(t,g);return new v(i.center,r)};var _=new m,y=new r;v.prototype.projectPointOntoPlane=function(e,i){if(!o(e))throw new s("cartesian is required.");var n=_;n.origin=e,r.normalize(e,n.direction);var a=l.rayPlane(n,this._plane,y);if(o(a)||(r.negate(n.direction,n.direction),a=l.rayPlane(n,this._plane,y)),o(a)){var u=r.subtract(a,this._origin,a),c=r.dot(this._xAxis,u),h=r.dot(this._yAxis,u);return o(i)?(i.x=c,i.y=h,i):new t(c,h)}return void 0},v.prototype.projectPointsOntoPlane=function(e,t){if(!o(e))throw new s("cartesians is required.");o(t)||(t=[]);for(var r=0,i=e.length,n=0;i>n;n++){var a=this.projectPointOntoPlane(e[n],t[r]);o(a)&&(t[r]=a,r++)}return t.length=r,t},v.prototype.projectPointToNearestOnPlane=function(e,i){if(!o(e))throw new s("cartesian is required.");o(i)||(i=new t);var n=_;n.origin=e,r.clone(this._plane.normal,n.direction);var a=l.rayPlane(n,this._plane,y);o(a)||(r.negate(n.direction,n.direction),a=l.rayPlane(n,this._plane,y));var u=r.subtract(a,this._origin,a),c=r.dot(this._xAxis,u),h=r.dot(this._yAxis,u);return i.x=c,i.y=h,i},v.prototype.projectPointsToNearestOnPlane=function(e,t){if(!o(e))throw new s("cartesians is required.");o(t)||(t=[]);var r=e.length;t.length=r;for(var i=0;r>i;i++)t[i]=this.projectPointToNearestOnPlane(e[i],t[i]);return t};var w=new r;return v.prototype.projectPointsOntoEllipsoid=function(e,t){if(!o(e))throw new s("cartesians is required.");var i=e.length;o(t)?t.length=i:t=new Array(i);for(var n=this._ellipsoid,a=this._origin,u=this._xAxis,l=this._yAxis,c=w,h=0;i>h;++h){var d=e[h];r.multiplyByScalar(u,d.x,c),o(t[h])||(t[h]=new r);var m=r.add(a,c,t[h]);r.multiplyByScalar(l,d.y,c),r.add(m,c,m),n.scaleToGeocentricSurface(m,m)}return t},v}),r("Core/OrientedBoundingBox",["./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Intersect","./Interval","./Math","./Matrix3","./Plane","./Rectangle"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p){"use strict";var f=function(e,t){this.center=r.clone(n(e,r.ZERO)),this.halfAxes=d.clone(n(t,d.ZERO))},v=new r,g=new r,_=new r,y=new r,w=new r,C=new d,E={unitary:new d,diagonal:new d};f.fromPoints=function(e,t){if(o(t)||(t=new f),!o(e)||0===e.length)return t.halfAxes=d.ZERO,t.center=r.ZERO,t;var i,n=e.length,a=r.clone(e[0],v);for(i=1;n>i;i++)r.add(a,e[i],a);var s=1/n;r.multiplyByScalar(a,s,a);var u,l=0,c=0,h=0,m=0,p=0,S=0;for(i=0;n>i;i++)u=r.subtract(e[i],a,g),l+=u.x*u.x,c+=u.x*u.y,h+=u.x*u.z,m+=u.y*u.y,p+=u.y*u.z,S+=u.z*u.z;l*=s,c*=s,h*=s,m*=s,p*=s,S*=s;var b=C;b[0]=l,b[1]=c,b[2]=h,b[3]=c,b[4]=m,b[5]=p,b[6]=h,b[7]=p,b[8]=S;var T=d.computeEigenDecomposition(b,E),x=d.transpose(T.unitary,t.halfAxes);u=r.subtract(e[0],a,g);var P=d.multiplyByVector(x,u,_),A=r.clone(P,y),I=r.clone(P,w);for(i=1;n>i;i++)u=r.subtract(e[i],a,u),d.multiplyByVector(x,u,P),r.minimumByComponent(I,P,I),r.maximumByComponent(A,P,A);var D=r.add(I,A,_);r.multiplyByScalar(D,.5,D),d.multiplyByVector(x,D,D),r.add(a,D,t.center);var M=r.subtract(A,I,_);return r.multiplyByScalar(M,.5,M),d.multiplyByScale(t.halfAxes,M,t.halfAxes),t};var S=new r,b=new r,T=function(e,t,i,n,s,u,l,c){if(!(o(t)&&o(i)&&o(n)&&o(s)&&o(u)&&o(l)))throw new a("all extents (minimum/maximum X/Y/Z) are required.");o(c)||(c=new f);var h=c.halfAxes;d.setColumn(h,0,e.xAxis,h),d.setColumn(h,1,e.yAxis,h),d.setColumn(h,2,e.zAxis,h);var m=S;m.x=(t+i)/2,m.y=(n+s)/2,m.z=(u+l)/2;var p=b;p.x=(i-t)/2,p.y=(s-n)/2,p.z=(l-u)/2;var v=c.center;return m=d.multiplyByVector(h,m,m),r.add(e.origin,m,v),d.multiplyByScale(h,p,h),c},x=new i,P=new r,A=[new i,new i,new i,new i,new i,new i,new i,new i],I=[new r,new r,new r,new r,new r,new r,new r,new r],D=[new t,new t,new t,new t,new t,new t,new t,new t];f.fromRectangle=function(e,t,r,i,l){if(!o(e))throw new a("rectangle is required");if(e.width<0||e.width>h.PI)throw new a("Rectangle width must be between 0 and pi");if(e.height<0||e.height>h.PI)throw new a("Rectangle height must be between 0 and pi");if(o(i)&&!h.equalsEpsilon(i.radii.x,i.radii.y,h.EPSILON15))throw new a("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");t=n(t,0),r=n(r,0),i=n(i,s.WGS84);var c=p.center(e,x),d=i.cartographicToCartesian(c,P),f=new u(d,i),v=f.plane,g=A[0],_=A[1],y=A[2],w=A[3],C=A[4],E=A[5],S=A[6],b=A[7],M=c.longitude,R=e.south<0&&e.north>0?0:c.latitude;S.latitude=E.latitude=C.latitude=e.south,b.latitude=w.latitude=R,g.latitude=_.latitude=y.latitude=e.north,S.longitude=b.longitude=g.longitude=e.west,E.longitude=_.longitude=M,C.longitude=w.longitude=y.longitude=e.east,y.height=_.height=g.height=b.height=S.height=E.height=C.height=w.height=r,i.cartographicArrayToCartesianArray(A,I),f.projectPointsToNearestOnPlane(I,D);var O=Math.min(D[6].x,D[7].x,D[0].x),N=Math.max(D[2].x,D[3].x,D[4].x),L=Math.min(D[4].y,D[5].y,D[6].y),F=Math.max(D[0].y,D[1].y,D[2].y);y.height=g.height=C.height=S.height=t,i.cartographicArrayToCartesianArray(A,I);var B=Math.min(m.getPointDistance(v,I[0]),m.getPointDistance(v,I[2]),m.getPointDistance(v,I[4]),m.getPointDistance(v,I[6])),z=r;return T(f,O,N,L,F,B,z,l)},f.clone=function(e,t){return o(e)?o(t)?(r.clone(e.center,t.center),d.clone(e.halfAxes,t.halfAxes),t):new f(e.center,e.halfAxes):void 0},f.intersectPlane=function(e,t){if(!o(e))throw new a("box is required.");if(!o(t))throw new a("plane is required.");var i=e.center,n=t.normal,s=e.halfAxes,u=n.x,c=n.y,h=n.z,m=Math.abs(u*s[d.COLUMN0ROW0]+c*s[d.COLUMN0ROW1]+h*s[d.COLUMN0ROW2])+Math.abs(u*s[d.COLUMN1ROW0]+c*s[d.COLUMN1ROW1]+h*s[d.COLUMN1ROW2])+Math.abs(u*s[d.COLUMN2ROW0]+c*s[d.COLUMN2ROW1]+h*s[d.COLUMN2ROW2]),p=r.dot(n,i)+t.distance;return-m>=p?l.OUTSIDE:p>=m?l.INSIDE:l.INTERSECTING};var M=new r,R=new r,O=new r,N=new r;f.distanceSquaredTo=function(e,t){if(!o(e))throw new a("box is required.");if(!o(t))throw new a("cartesian is required.");var i=r.subtract(t,e.center,S),n=e.halfAxes,s=d.getColumn(n,0,M),u=d.getColumn(n,1,R),l=d.getColumn(n,2,O),c=r.magnitude(s),h=r.magnitude(u),m=r.magnitude(l);r.normalize(s,s),r.normalize(u,u),r.normalize(l,l);var p=N;p.x=r.dot(i,s),p.y=r.dot(i,u),p.z=r.dot(i,l);var f,v=0;return p.x<-c?(f=p.x+c,v+=f*f):p.x>c&&(f=p.x-c,v+=f*f),p.y<-h?(f=p.y+h,v+=f*f):p.y>h&&(f=p.y-h,v+=f*f),p.z<-m?(f=p.z+m,v+=f*f):p.z>m&&(f=p.z-m,v+=f*f),v};var L=new r,F=new r;new r;f.computePlaneDistances=function(e,t,i,n){if(!o(e))throw new a("box is required.");if(!o(t))throw new a("position is required.");if(!o(i))throw new a("direction is required.");o(n)||(n=new c);var s=Number.POSITIVE_INFINITY,u=Number.NEGATIVE_INFINITY,l=e.center,h=e.halfAxes,m=d.getColumn(h,0,M),p=d.getColumn(h,1,R),f=d.getColumn(h,2,O),v=r.add(m,p,L);r.add(v,f,v),r.add(v,l,v);var g=r.subtract(v,t,F),_=r.dot(i,g);return s=Math.min(_,s),u=Math.max(_,u),r.add(l,m,v),r.add(v,p,v),r.subtract(v,f,v),r.subtract(v,t,g),_=r.dot(i,g),s=Math.min(_,s),u=Math.max(_,u),r.add(l,m,v),r.subtract(v,p,v),r.add(v,f,v),r.subtract(v,t,g),_=r.dot(i,g),s=Math.min(_,s),u=Math.max(_,u),r.add(l,m,v),r.subtract(v,p,v),r.subtract(v,f,v),r.subtract(v,t,g),_=r.dot(i,g),s=Math.min(_,s),u=Math.max(_,u),r.subtract(l,m,v),r.add(v,p,v),r.add(v,f,v),r.subtract(v,t,g),_=r.dot(i,g),s=Math.min(_,s),u=Math.max(_,u),r.subtract(l,m,v),r.add(v,p,v),r.subtract(v,f,v),r.subtract(v,t,g),_=r.dot(i,g),s=Math.min(_,s),u=Math.max(_,u),r.subtract(l,m,v),r.subtract(v,p,v),r.add(v,f,v),r.subtract(v,t,g),_=r.dot(i,g),s=Math.min(_,s),u=Math.max(_,u),r.subtract(l,m,v),r.subtract(v,p,v),r.subtract(v,f,v),r.subtract(v,t,g),_=r.dot(i,g),s=Math.min(_,s),u=Math.max(_,u),n.start=s,n.stop=u,n};var B=new e;return f.isOccluded=function(e,t){if(!o(e))throw new a("box is required.");if(!o(t))throw new a("occluder is required.");var i=e.halfAxes,n=d.getColumn(i,0,M),s=d.getColumn(i,1,R),u=d.getColumn(i,2,O),l=r.magnitude(n),c=r.magnitude(s),h=r.magnitude(u),m=B;return m.center=r.clone(e.center,m.center),m.radius=Math.max(l,c,h),!t.isBoundingSphereVisible(m)},f.prototype.intersectPlane=function(e){return f.intersectPlane(this,e)},f.prototype.distanceSquaredTo=function(e){return f.distanceSquaredTo(this,e)},f.prototype.computePlaneDistances=function(e,t,r){return f.computePlaneDistances(this,e,t,r)},f.prototype.isOccluded=function(e){return f.isOccluded(this,e)},f.equals=function(e,t){return e===t||o(e)&&o(t)&&r.equals(e.center,t.center)&&d.equals(e.halfAxes,t.halfAxes)},f.prototype.clone=function(e){return f.clone(this,e)},f.prototype.equals=function(e){return f.equals(this,e)},f}),r("Core/Intersections2D",["./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";var i={};return i.clipTriangleAtAxisAlignedThreshold=function(e,i,n,o,a,s){if(!t(e))throw new r("threshold is required.");if(!t(i))throw new r("keepAbove is required.");if(!t(n))throw new r("u0 is required.");if(!t(o))throw new r("u1 is required.");if(!t(a))throw new r("u2 is required.");t(s)?s.length=0:s=[];var u,l,c;i?(u=e>n,l=e>o,c=e>a):(u=n>e,l=o>e,c=a>e);var h,d,m,p,f,v,g=u+l+c;return 1===g?u?(h=(e-n)/(o-n),d=(e-n)/(a-n),s.push(1),s.push(2),1!==d&&(s.push(-1),s.push(0),s.push(2),s.push(d)),1!==h&&(s.push(-1),s.push(0),s.push(1),s.push(h))):l?(m=(e-o)/(a-o),p=(e-o)/(n-o),s.push(2),s.push(0),1!==p&&(s.push(-1),s.push(1),s.push(0),s.push(p)),1!==m&&(s.push(-1),s.push(1),s.push(2),s.push(m))):c&&(f=(e-a)/(n-a),v=(e-a)/(o-a),s.push(0),s.push(1),1!==v&&(s.push(-1),s.push(2),s.push(1),s.push(v)),1!==f&&(s.push(-1),s.push(2),s.push(0),s.push(f))):2===g?u||n===e?l||o===e?c||a===e||(d=(e-n)/(a-n),m=(e-o)/(a-o),s.push(2),s.push(-1),s.push(0),s.push(2),s.push(d),s.push(-1),s.push(1),s.push(2),s.push(m)):(v=(e-a)/(o-a),h=(e-n)/(o-n),s.push(1),s.push(-1),s.push(2),s.push(1),s.push(v),s.push(-1),s.push(0),s.push(1),s.push(h)):(p=(e-o)/(n-o),f=(e-a)/(n-a),s.push(0),s.push(-1),s.push(1),s.push(0),s.push(p),s.push(-1),s.push(2),s.push(0),s.push(f)):3===g||(s.push(0),s.push(1),s.push(2)),s},i.computeBarycentricCoordinates=function(i,n,o,a,s,u,l,c,h){if(!t(i))throw new r("x is required.");if(!t(n))throw new r("y is required.");if(!t(o))throw new r("x1 is required.");if(!t(a))throw new r("y1 is required.");if(!t(s))throw new r("x2 is required.");if(!t(u))throw new r("y2 is required.");if(!t(l))throw new r("x3 is required.");if(!t(c))throw new r("y3 is required.");var d=o-l,m=l-s,p=u-c,f=a-c,v=1/(p*d+m*f),g=n-c,_=i-l,y=(p*_+m*g)*v,w=(-f*_+d*g)*v,C=1-y-w;return t(h)?(h.x=y,h.y=w,h.z=C,h):new e(y,w,C)},i}),r("Core/QuantizedMeshTerrainData",["../ThirdParty/when","./BoundingSphere","./Cartesian3","./defaultValue","./defined","./defineProperties","./DeveloperError","./IndexDatatype","./Intersections2D","./Math","./OrientedBoundingBox","./TaskProcessor","./TerrainMesh"],function(e,t,r,i,n,o,a,s,u,l,c,h,d){"use strict";function m(e,t,r){f.length=e.length;for(var i=!1,n=0,o=e.length;o>n;++n)f[n]=e[n],i=i||n>0&&t(e[n-1],e[n])>0;return i?(f.sort(t),s.createTypedArray(r,f)):e}var p=function(e){function t(e,t){return u[e]-u[t]}function r(e,t){return s[e]-s[t];
}if(!n(e)||!n(e.quantizedVertices))throw new a("options.quantizedVertices is required.");if(!n(e.indices))throw new a("options.indices is required.");if(!n(e.minimumHeight))throw new a("options.minimumHeight is required.");if(!n(e.maximumHeight))throw new a("options.maximumHeight is required.");if(!n(e.maximumHeight))throw new a("options.maximumHeight is required.");if(!n(e.boundingSphere))throw new a("options.boundingSphere is required.");if(!n(e.horizonOcclusionPoint))throw new a("options.horizonOcclusionPoint is required.");if(!n(e.westIndices))throw new a("options.westIndices is required.");if(!n(e.southIndices))throw new a("options.southIndices is required.");if(!n(e.eastIndices))throw new a("options.eastIndices is required.");if(!n(e.northIndices))throw new a("options.northIndices is required.");if(!n(e.westSkirtHeight))throw new a("options.westSkirtHeight is required.");if(!n(e.southSkirtHeight))throw new a("options.southSkirtHeight is required.");if(!n(e.eastSkirtHeight))throw new a("options.eastSkirtHeight is required.");if(!n(e.northSkirtHeight))throw new a("options.northSkirtHeight is required.");this._quantizedVertices=e.quantizedVertices,this._encodedNormals=e.encodedNormals,this._indices=e.indices,this._minimumHeight=e.minimumHeight,this._maximumHeight=e.maximumHeight,this._boundingSphere=e.boundingSphere,this._orientedBoundingBox=e.orientedBoundingBox,this._horizonOcclusionPoint=e.horizonOcclusionPoint;var o=this._quantizedVertices.length/3,s=this._uValues=this._quantizedVertices.subarray(0,o),u=this._vValues=this._quantizedVertices.subarray(o,2*o);this._heightValues=this._quantizedVertices.subarray(2*o,3*o);this._westIndices=m(e.westIndices,t,o),this._southIndices=m(e.southIndices,r,o),this._eastIndices=m(e.eastIndices,t,o),this._northIndices=m(e.northIndices,r,o),this._westSkirtHeight=e.westSkirtHeight,this._southSkirtHeight=e.southSkirtHeight,this._eastSkirtHeight=e.eastSkirtHeight,this._northSkirtHeight=e.northSkirtHeight,this._childTileMask=i(e.childTileMask,15),this._createdByUpsampling=i(e.createdByUpsampling,!1),this._waterMask=e.waterMask};o(p.prototype,{waterMask:{get:function(){return this._waterMask}}});var f=[],v=new h("createVerticesFromQuantizedTerrainMesh");p.prototype.createMesh=function(t,r,i,o){if(!n(t))throw new a("tilingScheme is required.");if(!n(r))throw new a("x is required.");if(!n(i))throw new a("y is required.");if(!n(o))throw new a("level is required.");var u=t.ellipsoid,l=t.tileXYToRectangle(r,i,o),c=v.scheduleTask({minimumHeight:this._minimumHeight,maximumHeight:this._maximumHeight,quantizedVertices:this._quantizedVertices,octEncodedNormals:this._encodedNormals,indices:this._indices,westIndices:this._westIndices,southIndices:this._southIndices,eastIndices:this._eastIndices,northIndices:this._northIndices,westSkirtHeight:this._westSkirtHeight,southSkirtHeight:this._southSkirtHeight,eastSkirtHeight:this._eastSkirtHeight,northSkirtHeight:this._northSkirtHeight,rectangle:l,relativeToCenter:this._boundingSphere.center,ellipsoid:u});if(!n(c))return void 0;var h=this;return e(c,function(e){var t=h._quantizedVertices.length/3;t+=h._westIndices.length+h._southIndices.length+h._eastIndices.length+h._northIndices.length;var r=s.createTypedArray(t,e.indices);return new d(h._boundingSphere.center,new Float32Array(e.vertices),r,h._minimumHeight,h._maximumHeight,h._boundingSphere,h._horizonOcclusionPoint,n(h._encodedNormals)?7:6,h._orientedBoundingBox)})};var g=new h("upsampleQuantizedTerrainMesh");p.prototype.upsample=function(i,o,u,l,h,d,m){if(!n(i))throw new a("tilingScheme is required.");if(!n(o))throw new a("thisX is required.");if(!n(u))throw new a("thisY is required.");if(!n(l))throw new a("thisLevel is required.");if(!n(h))throw new a("descendantX is required.");if(!n(d))throw new a("descendantY is required.");if(!n(m))throw new a("descendantLevel is required.");var f=m-l;if(f>1)throw new a("Upsampling through more than one level at a time is not currently supported.");var v=2*o!==h,_=2*u===d,y=i.ellipsoid,w=i.tileXYToRectangle(h,d,m),C=g.scheduleTask({vertices:this._quantizedVertices,indices:this._indices,encodedNormals:this._encodedNormals,minimumHeight:this._minimumHeight,maximumHeight:this._maximumHeight,isEastChild:v,isNorthChild:_,childRectangle:w,ellipsoid:y});if(!n(C))return void 0;var E=Math.min(this._westSkirtHeight,this._eastSkirtHeight);E=Math.min(E,this._southSkirtHeight),E=Math.min(E,this._northSkirtHeight);var S=v?.5*E:this._westSkirtHeight,b=_?.5*E:this._southSkirtHeight,T=v?this._eastSkirtHeight:.5*E,x=_?this._northSkirtHeight:.5*E;return e(C,function(e){var i,o=new Uint16Array(e.vertices),a=s.createTypedArray(o.length/3,e.indices);return n(e.encodedNormals)&&(i=new Uint8Array(e.encodedNormals)),new p({quantizedVertices:o,indices:a,encodedNormals:i,minimumHeight:e.minimumHeight,maximumHeight:e.maximumHeight,boundingSphere:t.clone(e.boundingSphere),orientedBoundingBox:c.clone(e.orientedBoundingBox),horizonOcclusionPoint:r.clone(e.horizonOcclusionPoint),westIndices:e.westIndices,southIndices:e.southIndices,eastIndices:e.eastIndices,northIndices:e.northIndices,westSkirtHeight:S,southSkirtHeight:b,eastSkirtHeight:T,northSkirtHeight:x,childTileMask:0,createdByUpsampling:!0})})};var _=32767,y=new r;return p.prototype.interpolateHeight=function(e,t,r){var i=l.clamp((t-e.west)/e.width,0,1);i*=_;var n=l.clamp((r-e.south)/e.height,0,1);n*=_;for(var o=this._uValues,a=this._vValues,s=this._heightValues,c=this._indices,h=0,d=c.length;d>h;h+=3){var m=c[h],p=c[h+1],f=c[h+2],v=o[m],g=o[p],w=o[f],C=a[m],E=a[p],S=a[f],b=u.computeBarycentricCoordinates(i,n,v,C,g,E,w,S,y);if(b.x>=-1e-15&&b.y>=-1e-15&&b.z>=-1e-15){var T=b.x*s[m]+b.y*s[p]+b.z*s[f];return l.lerp(this._minimumHeight,this._maximumHeight,T/_)}}return void 0},p.prototype.isChildAvailable=function(e,t,r,i){if(!n(e))throw new a("thisX is required.");if(!n(t))throw new a("thisY is required.");if(!n(r))throw new a("childX is required.");if(!n(i))throw new a("childY is required.");var o=2;return r!==2*e&&++o,i!==2*t&&(o-=2),0!==(this._childTileMask&1<<o)},p.prototype.wasCreatedByUpsampling=function(){return this._createdByUpsampling},p}),r("Core/formatError",["./defined"],function(e){"use strict";var t=function(t){var r,i=t.name,n=t.message;r=e(i)&&e(n)?i+": "+n:t.toString();var o=t.stack;return e(o)&&(r+="\n"+o),r};return t}),r("Core/TileProviderError",["./defaultValue","./defined","./formatError"],function(e,t,r){"use strict";var i=function(t,r,i,n,o,a,s){this.provider=t,this.message=r,this.x=i,this.y=n,this.level=o,this.timesRetried=e(a,0),this.retry=!1,this.error=s};return i.handleError=function(e,n,o,a,s,u,l,c,h){var d=e;return t(e)?(d.provider=n,d.message=a,d.x=s,d.y=u,d.level=l,d.retry=!1,d.error=h,++d.timesRetried):d=new i(n,a,s,u,l,0,h),o.numberOfListeners>0?o.raiseEvent(d):console.log('An error occurred in "'+n.constructor.name+'": '+r(a)),d.retry&&t(c)&&c(),d},i.handleSuccess=function(e){t(e)&&(e.timesRetried=-1)},i}),r("Core/CesiumTerrainProvider",["../ThirdParty/Uri","../ThirdParty/when","./BoundingSphere","./Cartesian3","./Credit","./defaultValue","./defined","./defineProperties","./DeveloperError","./Event","./GeographicTilingScheme","./HeightmapTerrainData","./IndexDatatype","./joinUrls","./loadArrayBuffer","./loadJson","./Math","./Matrix3","./OrientedBoundingBox","./QuantizedMeshTerrainData","./RuntimeError","./TerrainProvider","./throttleRequestByServer","./TileProviderError"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f,v,g,_,y,w,C,E,S){"use strict";function b(e){if(a(e)&&0!==e.length){var t=e.join("-");return{Accept:"application/vnd.quantized-mesh;extensions="+t+",application/octet-stream;q=0.9,*/*;q=0.01"}}return{Accept:"application/vnd.quantized-mesh,application/octet-stream;q=0.9,*/*;q=0.01"}}function T(e,t,r,i,n,o){var a=new Uint16Array(t,0,e._heightmapWidth*e._heightmapWidth);return new h({buffer:a,childTileMask:new Uint8Array(t,a.byteLength,1)[0],waterMask:new Uint8Array(t,a.byteLength+1,t.byteLength-a.byteLength-1),width:e._heightmapWidth,height:e._heightmapWidth,structure:e._heightmapStructure})}function x(e,t,n,o,a,s){function u(e){return e>>1^-(1&e)}var l=0,c=3,h=c+1,m=Float64Array.BYTES_PER_ELEMENT*c,p=Float64Array.BYTES_PER_ELEMENT*h,f=3,g=Uint16Array.BYTES_PER_ELEMENT*f,w=3,C=Uint16Array.BYTES_PER_ELEMENT,E=C*w,S=new DataView(t),b=new i(S.getFloat64(l,!0),S.getFloat64(l+8,!0),S.getFloat64(l+16,!0));l+=m;var T=S.getFloat32(l,!0);l+=Float32Array.BYTES_PER_ELEMENT;var x=S.getFloat32(l,!0);l+=Float32Array.BYTES_PER_ELEMENT;var A=new r(new i(S.getFloat64(l,!0),S.getFloat64(l+8,!0),S.getFloat64(l+16,!0)),S.getFloat64(l+m,!0));l+=p;var I=new i(S.getFloat64(l,!0),S.getFloat64(l+8,!0),S.getFloat64(l+16,!0));l+=m;var M=S.getUint32(l,!0);l+=Uint32Array.BYTES_PER_ELEMENT;var R=new Uint16Array(t,l,3*M);l+=M*g,M>65536&&(C=Uint32Array.BYTES_PER_ELEMENT,E=C*w);var O,N=R.subarray(0,M),L=R.subarray(M,2*M),F=R.subarray(2*M,3*M),B=0,z=0,V=0;for(O=0;M>O;++O)B+=u(N[O]),z+=u(L[O]),V+=u(F[O]),N[O]=B,L[O]=z,F[O]=V;l%C!==0&&(l+=C-l%C);var k=S.getUint32(l,!0);l+=Uint32Array.BYTES_PER_ELEMENT;var U=d.createTypedArrayFromArrayBuffer(M,t,l,k*w);l+=k*E;var q=0;for(O=0;O<U.length;++O){var G=U[O];U[O]=q-G,0===G&&++q}var W=S.getUint32(l,!0);l+=Uint32Array.BYTES_PER_ELEMENT;var H=d.createTypedArrayFromArrayBuffer(M,t,l,W);l+=W*C;var j=S.getUint32(l,!0);l+=Uint32Array.BYTES_PER_ELEMENT;var Y=d.createTypedArrayFromArrayBuffer(M,t,l,j);l+=j*C;var X=S.getUint32(l,!0);l+=Uint32Array.BYTES_PER_ELEMENT;var Z=d.createTypedArrayFromArrayBuffer(M,t,l,X);l+=X*C;var K=S.getUint32(l,!0);l+=Uint32Array.BYTES_PER_ELEMENT;var Q=d.createTypedArrayFromArrayBuffer(M,t,l,K);l+=K*C;for(var J,$;l<S.byteLength;){var ee=S.getUint8(l,!0);l+=Uint8Array.BYTES_PER_ELEMENT;var te=S.getUint32(l,e._littleEndianExtensionSize);l+=Uint32Array.BYTES_PER_ELEMENT,ee===D.OCT_VERTEX_NORMALS&&e._requestVertexNormals?J=new Uint8Array(t,l,2*M):ee===D.WATER_MASK&&e._requestWaterMask&&($=new Uint8Array(t,l,te)),l+=te}var re,ie=5*e.getLevelMaximumGeometricError(n),ne=e._tilingScheme.tileXYToRectangle(o,a,n);return ne.width<v.PI_OVER_TWO+v.EPSILON5&&(re=_.fromRectangle(ne,T,x,e._tilingScheme.ellipsoid)),new y({center:b,minimumHeight:T,maximumHeight:x,boundingSphere:A,orientedBoundingBox:re,horizonOcclusionPoint:I,quantizedVertices:R,encodedNormals:J,indices:U,westIndices:H,southIndices:Y,eastIndices:Z,northIndices:Q,westSkirtHeight:ie,southSkirtHeight:ie,eastSkirtHeight:ie,northSkirtHeight:ie,childTileMask:P(e,n,o,s),waterMask:$})}function P(e,t,r,i){var n=e._availableTiles;if(!n||0===n.length)return 15;var o=t+1;if(o>=n.length)return 0;var a=n[o],s=0;return s|=A(a,2*r,2*i)?1:0,s|=A(a,2*r+1,2*i)?2:0,s|=A(a,2*r,2*i+1)?4:0,s|=A(a,2*r+1,2*i+1)?8:0}function A(e,t,r){for(var i=0,n=e.length;n>i;++i){var o=e[i];if(t>=o.startX&&t<=o.endX&&r>=o.startY&&r<=o.endY)return!0}return!1}var I=function(r){function i(t){var r;if(!t.format)return r="The tile format is not specified in the layer.json file.",void(v=S.handleError(v,g,g._errorEvent,r,void 0,void 0,void 0,h));if(!t.tiles||0===t.tiles.length)return r="The layer.json file does not specify any tile URL templates.",void(v=S.handleError(v,g,g._errorEvent,r,void 0,void 0,void 0,h));if("heightmap-1.0"===t.format)g._heightmapStructure={heightScale:.2,heightOffset:-1e3,elementsPerHeight:1,stride:1,elementMultiplier:256,isBigEndian:!1},g._hasWaterMask=!0,g._requestWaterMask=!0;else if(0!==t.format.indexOf("quantized-mesh-1."))return r='The tile format "'+t.format+'" is invalid or not supported.',void(v=S.handleError(v,g,g._errorEvent,r,void 0,void 0,void 0,h));g._tileUrlTemplates=t.tiles;for(var i=0;i<g._tileUrlTemplates.length;++i){var o=new e(g._tileUrlTemplates[i]),s=new e(g._url);o.authority&&!s.authority&&(s.authority=o.authority,s.scheme=o.scheme),g._tileUrlTemplates[i]=m(s,o).toString().replace("{version}",t.version)}g._availableTiles=t.available,!a(g._credit)&&a(t.attribution)&&null!==t.attribution&&(g._credit=new n(t.attribution)),a(t.extensions)&&-1!==t.extensions.indexOf("octvertexnormals")?g._hasVertexNormals=!0:a(t.extensions)&&-1!==t.extensions.indexOf("vertexnormals")&&(g._hasVertexNormals=!0,g._littleEndianExtensionSize=!1),a(t.extensions)&&-1!==t.extensions.indexOf("watermask")&&(g._hasWaterMask=!0),g._ready=!0}function s(e){if(a(e)&&404===e.statusCode)return void i({tilejson:"2.1.0",format:"heightmap-1.0",version:"1.0.0",scheme:"tms",tiles:["{z}/{x}/{y}.terrain?v={version}"]});var t="An error occurred while accessing "+p+".";v=S.handleError(v,g,g._errorEvent,t,void 0,void 0,void 0,h)}function h(){var e=f(p);t(e,i,s)}if(!a(r)||!a(r.url))throw new u("options.url is required.");this._url=r.url,this._proxy=r.proxy,this._tilingScheme=new c({numberOfLevelZeroTilesX:2,numberOfLevelZeroTilesY:1,ellipsoid:r.ellipsoid}),this._heightmapWidth=65,this._levelZeroMaximumGeometricError=C.getEstimatedLevelZeroGeometricErrorForAHeightmap(this._tilingScheme.ellipsoid,this._heightmapWidth,this._tilingScheme.getNumberOfXTilesAtLevel(0)),this._heightmapStructure=void 0,this._hasWaterMask=!1,this._hasVertexNormals=!1,this._requestVertexNormals=o(r.requestVertexNormals,!1),this._littleEndianExtensionSize=!0,this._requestWaterMask=o(r.requestWaterMask,!1),this._errorEvent=new l;var d=r.credit;"string"==typeof d&&(d=new n(d)),this._credit=d,this._ready=!1;var p=m(this._url,"layer.json");a(this._proxy)&&(p=this._proxy.getURL(p));var v,g=this;h()},D={OCT_VERTEX_NORMALS:1,WATER_MASK:2};return I.prototype.requestTileGeometry=function(e,r,i,n){if(!this._ready)throw new u("requestTileGeometry must not be called before the terrain provider is ready.");var s=this._tileUrlTemplates;if(0===s.length)return void 0;var l=this._tilingScheme.getNumberOfYTilesAtLevel(i),c=l-r-1,h=s[(e+c+i)%s.length].replace("{z}",i).replace("{x}",e).replace("{y}",c),d=this._proxy;a(d)&&(h=d.getURL(h));var m,f=[];this._requestVertexNormals&&this._hasVertexNormals&&f.push(this._littleEndianExtensionSize?"octvertexnormals":"vertexnormals"),this._requestWaterMask&&this._hasWaterMask&&f.push("watermask");var v=function(e){return p(e,b(f))};if(n=o(n,!0)){if(m=E(h,v),!a(m))return void 0}else m=v(h);var g=this;return t(m,function(t){return a(g._heightmapStructure)?T(g,t,i,e,r,c):x(g,t,i,e,r,c)})},s(I.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){if(!this._ready)throw new u("credit must not be called before the terrain provider is ready.");return this._credit}},tilingScheme:{get:function(){if(!this._ready)throw new u("tilingScheme must not be called before the terrain provider is ready.");return this._tilingScheme}},ready:{get:function(){return this._ready}},hasWaterMask:{get:function(){if(!this._ready)throw new u("hasWaterMask must not be called before the terrain provider is ready.");return this._hasWaterMask&&this._requestWaterMask}},hasVertexNormals:{get:function(){if(!this._ready)throw new u("hasVertexNormals must not be called before the terrain provider is ready.");return this._hasVertexNormals&&this._requestVertexNormals}},requestVertexNormals:{get:function(){return this._requestVertexNormals}},requestWaterMask:{get:function(){return this._requestWaterMask}}}),I.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},I.prototype.getTileDataAvailable=function(e,t,r){var i=this._availableTiles;if(i&&0!==i.length){if(r>=i.length)return!1;var n=i[r],o=this._tilingScheme.getNumberOfYTilesAtLevel(r),a=o-t-1;return A(n,e,a)}return void 0},I}),r("Core/EllipseGeometryLibrary",["./Cartesian3","./Math","./Matrix3","./Quaternion"],function(e,t,r,i){"use strict";function n(t,n,o,c,h,d,m,p,f,v){var g=t+n;e.multiplyByScalar(c,Math.cos(g),a),e.multiplyByScalar(o,Math.sin(g),s),e.add(a,s,a);var _=Math.cos(t);_*=_;var y=Math.sin(t);y*=y;var w=d/Math.sqrt(m*_+h*y),C=w/p;return i.fromAxisAngle(a,C,u),r.fromQuaternion(u,l),r.multiplyByVector(l,f,v),e.normalize(v,v),e.multiplyByScalar(v,p,v),v}var o={},a=new e,s=new e,u=new i,l=new r,c=new e,h=new e,d=new e,m=new e;o.raisePositionsToHeight=function(t,r,i){for(var n=r.ellipsoid,o=r.height,a=r.extrudedHeight,s=i?t.length/3*2:t.length/3,u=new Float64Array(3*s),l=t.length,p=i?l:0,f=0;l>f;f+=3){var v=f+1,g=f+2,_=e.fromArray(t,f,c);n.scaleToGeodeticSurface(_,_);var y=e.clone(_,h),w=n.geodeticSurfaceNormal(_,m),C=e.multiplyByScalar(w,o,d);e.add(_,C,_),i&&(e.multiplyByScalar(w,a,C),e.add(y,C,y),u[f+p]=y.x,u[v+p]=y.y,u[g+p]=y.z),u[f]=_.x,u[v]=_.y,u[g]=_.z}return u};var p=new e,f=new e,v=new e;return o.computeEllipsePositions=function(r,i,o){var a=r.semiMinorAxis,s=r.semiMajorAxis,u=r.rotation,l=r.center,m=8*r.granularity,g=a*a,_=s*s,y=s*a,w=e.magnitude(l),C=e.normalize(l,p),E=e.cross(e.UNIT_Z,l,f);E=e.normalize(E,E);var S=e.cross(C,E,v),b=1+Math.ceil(t.PI_OVER_TWO/m),T=t.PI_OVER_TWO/(b-1),x=t.PI_OVER_TWO-b*T;0>x&&(b-=Math.ceil(Math.abs(x)/T));var P,A,I,D,M,R=2*b*(b+1),O=i?new Array(3*R):void 0,N=0,L=c,F=h,B=3*(2*b+2*(b-1)),z=B-1,V=0,k=o?new Array(B):void 0;for(x=t.PI_OVER_TWO,P=0;b>P;++P){if(L=n(x,u,S,E,g,y,_,w,C,L),F=n(Math.PI-x,u,S,E,g,y,_,w,C,F),i){for(O[N++]=L.x,O[N++]=L.y,O[N++]=L.z,I=2*P+2,A=1;I-1>A;++A)D=A/(I-1),M=e.lerp(L,F,D,d),O[N++]=M.x,O[N++]=M.y,O[N++]=M.z;O[N++]=F.x,O[N++]=F.y,O[N++]=F.z}o&&(k[z--]=L.z,k[z--]=L.y,k[z--]=L.x,0!==P&&(k[V++]=F.x,k[V++]=F.y,k[V++]=F.z)),x=t.PI_OVER_TWO-(P+1)*T}for(P=b;P>0;--P){if(x=t.PI_OVER_TWO-(P-1)*T,L=n(-x,u,S,E,g,y,_,w,C,L),F=n(x+Math.PI,u,S,E,g,y,_,w,C,F),i){for(O[N++]=L.x,O[N++]=L.y,O[N++]=L.z,I=2*(P-1)+2,A=1;I-1>A;++A)D=A/(I-1),M=e.lerp(L,F,D,d),O[N++]=M.x,O[N++]=M.y,O[N++]=M.z;O[N++]=F.x,O[N++]=F.y,O[N++]=F.z}o&&(k[z--]=L.z,k[z--]=L.y,k[z--]=L.x,1!==P&&(k[V++]=F.x,k[V++]=F.y,k[V++]=F.z))}var U={};return i&&(U.positions=O,U.numPts=b),o&&(U.outerPositions=k),U},o}),r("Core/GeometryInstance",["./defaultValue","./defined","./DeveloperError","./Matrix4"],function(e,t,r,i){"use strict";var n=function(n){if(n=e(n,e.EMPTY_OBJECT),!t(n.geometry))throw new r("options.geometry is required.");this.geometry=n.geometry,this.modelMatrix=i.clone(e(n.modelMatrix,i.IDENTITY)),this.id=n.id,this.pickPrimitive=n.pickPrimitive,this.attributes=e(n.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0};return n}),r("Core/EncodedCartesian3",["./Cartesian3","./defined","./DeveloperError"],function(e,t,r){"use strict";var i=function(){this.high=e.clone(e.ZERO),this.low=e.clone(e.ZERO)};i.encode=function(e,i){if(!t(e))throw new r("value is required");t(i)||(i={high:0,low:0});var n;return e>=0?(n=65536*Math.floor(e/65536),i.high=n,i.low=e-n):(n=65536*Math.floor(-e/65536),i.high=-n,i.low=e+n),i};var n={high:0,low:0};i.fromCartesian=function(e,o){if(!t(e))throw new r("cartesian is required");t(o)||(o=new i);var a=o.high,s=o.low;return i.encode(e.x,n),a.x=n.high,s.x=n.low,i.encode(e.y,n),a.y=n.high,s.y=n.low,i.encode(e.z,n),a.z=n.high,s.z=n.low,o};var o=new i;return i.writeElements=function(e,n,a){if(!t(e))throw new r("cartesian is required");if(!t(n))throw new r("cartesianArray is required");if("number"!=typeof a||0>a)throw new r("index must be a number greater than or equal to 0.");i.fromCartesian(e,o);var s=o.high,u=o.low;n[a]=s.x,n[a+1]=s.y,n[a+2]=s.z,n[a+3]=u.x,n[a+4]=u.y,n[a+5]=u.z},i}),r("Core/Tipsify",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var i={};return i.calculateACMR=function(i){i=e(i,e.EMPTY_OBJECT);var n=i.indices,o=i.maximumIndex,a=e(i.cacheSize,24);if(!t(n))throw new r("indices is required.");var s=n.length;if(3>s||s%3!==0)throw new r("indices length must be a multiple of three.");if(0>=o)throw new r("maximumIndex must be greater than zero.");if(3>a)throw new r("cacheSize must be greater than two.");if(!t(o)){o=0;for(var u=0,l=n[u];s>u;)l>o&&(o=l),++u,l=n[u]}for(var c=[],h=0;o+1>h;h++)c[h]=0;for(var d=a+1,m=0;s>m;++m)d-c[n[m]]>a&&(c[n[m]]=d,++d);return(d-a+1)/(s/3)},i.tipsify=function(i){function n(e,t,r,i){for(;t.length>=1;){var n=t[t.length-1];if(t.splice(t.length-1,1),e[n].numLiveTriangles>0)return n}for(;i>a;){if(e[a].numLiveTriangles>0)return++a,a-1;++a}return-1}function o(e,t,r,i,o,a,s){for(var u,l=-1,c=-1,h=0;h<r.length;){var d=r[h];i[d].numLiveTriangles&&(u=0,o-i[d].timeStamp+2*i[d].numLiveTriangles<=t&&(u=o-i[d].timeStamp),(u>c||-1===c)&&(c=u,l=d)),++h}return-1===l?n(i,a,e,s):l}i=e(i,e.EMPTY_OBJECT);var a,s=i.indices,u=i.maximumIndex,l=e(i.cacheSize,24);if(!t(s))throw new r("indices is required.");var c=s.length;if(3>c||c%3!==0)throw new r("indices length must be a multiple of three.");if(0>=u)throw new r("maximumIndex must be greater than zero.");if(3>l)throw new r("cacheSize must be greater than two.");var h=0,d=0,m=s[d],p=c;if(t(u))h=u+1;else{for(;p>d;)m>h&&(h=m),++d,m=s[d];if(-1===h)return 0;++h}for(var f=[],v=0;h>v;v++)f[v]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};d=0;for(var g=0;p>d;)f[s[d]].vertexTriangles.push(g),++f[s[d]].numLiveTriangles,f[s[d+1]].vertexTriangles.push(g),++f[s[d+1]].numLiveTriangles,f[s[d+2]].vertexTriangles.push(g),++f[s[d+2]].numLiveTriangles,++g,d+=3;var _=0,y=l+1;a=1;var w,C,E=[],S=[],b=0,T=[],x=c/3,P=[];for(v=0;x>v;v++)P[v]=!1;for(var A,I;-1!==_;){E=[],C=f[_],I=C.vertexTriangles.length;for(var D=0;I>D;++D)if(g=C.vertexTriangles[D],!P[g]){P[g]=!0,d=g+g+g;for(var M=0;3>M;++M)A=s[d],E.push(A),S.push(A),T[b]=A,++b,w=f[A],--w.numLiveTriangles,y-w.timeStamp>l&&(w.timeStamp=y,++y),++d}_=o(s,l,E,f,y,S,h)}return T},i}),r("Core/GeometryPipeline",["./AttributeCompression","./barycentricCoordinates","./BoundingSphere","./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EncodedCartesian3","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryInstance","./GeometryType","./IndexDatatype","./Intersect","./IntersectionTests","./Math","./Matrix3","./Matrix4","./Plane","./PrimitiveType","./Tipsify"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f,v,g,_,y,w,C,E,S,b,T){"use strict";function x(e,t,r,i,n){e[t++]=r,e[t++]=i,e[t++]=i,e[t++]=n,e[t++]=n,e[t]=r}function P(e){for(var t=e.length,r=t/3*6,i=g.createTypedArray(t,r),n=0,o=0;t>o;o+=3,n+=6)x(i,n,e[o],e[o+1],e[o+2]);return i}function A(e){var t=e.length;if(t>=3){var r=6*(t-2),i=g.createTypedArray(t,r);x(i,0,e[0],e[1],e[2]);for(var n=6,o=3;t>o;++o,n+=6)x(i,n,e[o-1],e[o],e[o-2]);return i}return new Uint16Array}function I(e){if(e.length>0){for(var t=e.length-1,r=6*(t-1),i=g.createTypedArray(t,r),n=e[0],o=0,a=1;t>a;++a,o+=6)x(i,o,n,e[a],e[a+1]);return i}return new Uint16Array}function D(e){var t={};for(var r in e)if(e.hasOwnProperty(r)&&l(e[r])&&l(e[r].values)){var i=e[r];t[r]=new p({componentDatatype:i.componentDatatype,componentsPerAttribute:i.componentsPerAttribute,normalize:i.normalize,values:[]})}return t}function M(e,t,r){for(var i in t)if(t.hasOwnProperty(i)&&l(t[i])&&l(t[i].values))for(var n=t[i],o=0;o<n.componentsPerAttribute;++o)e[i].values.push(n.values[r*n.componentsPerAttribute+o])}function R(e,t){if(l(t))for(var r=t.values,i=r.length,o=0;i>o;o+=3)n.unpack(r,o,oe),E.multiplyByPoint(e,oe,oe),n.pack(oe,r,o)}function O(e,t){if(l(t))for(var r=t.values,i=r.length,o=0;i>o;o+=3)n.unpack(r,o,oe),C.multiplyByVector(e,oe,oe),oe=n.normalize(oe,oe),n.pack(oe,r,o)}function N(e,t){var r,i=e.length,n={},o=e[0][t].attributes;for(r in o)if(o.hasOwnProperty(r)&&l(o[r])&&l(o[r].values)){for(var a=o[r],u=a.values.length,c=!0,h=1;i>h;++h){var d=e[h][t].attributes[r];if(!l(d)||a.componentDatatype!==d.componentDatatype||a.componentsPerAttribute!==d.componentsPerAttribute||a.normalize!==d.normalize){c=!1;break}u+=d.values.length}c&&(n[r]=new p({componentDatatype:a.componentDatatype,componentsPerAttribute:a.componentsPerAttribute,normalize:a.normalize,values:s.createTypedArray(a.componentDatatype,u)}))}return n}function L(e,t){var i,o,a,s,u=e.length,h=e[0].modelMatrix,d=l(e[0][t].indices),p=e[0][t].primitiveType;for(o=1;u>o;++o){if(!E.equals(e[o].modelMatrix,h))throw new c("All instances must have the same modelMatrix.");if(l(e[o][t].indices)!==d)throw new c("All instance geometries must have an indices or not have one.");if(e[o][t].primitiveType!==p)throw new c("All instance geometries must have the same primitiveType.")}var f,v,_,y=N(e,t);for(i in y)if(y.hasOwnProperty(i))for(f=y[i].values,s=0,o=0;u>o;++o)for(v=e[o][t].attributes[i].values,_=v.length,a=0;_>a;++a)f[s++]=v[a];var w;if(d){var C=0;for(o=0;u>o;++o)C+=e[o][t].indices.length;var S=m.computeNumberOfVertices(new m({attributes:y,primitiveType:b.POINTS})),T=g.createTypedArray(S,C),x=0,P=0;for(o=0;u>o;++o){var A=e[o][t].indices,I=A.length;for(s=0;I>s;++s)T[x++]=P+A[s];P+=m.computeNumberOfVertices(e[o][t])}w=T}var D,M=new n,R=0;for(o=0;u>o;++o){if(D=e[o][t].boundingSphere,!l(D)){M=void 0;break}n.add(D.center,M,M)}if(l(M))for(n.divideByScalar(M,u,M),o=0;u>o;++o){D=e[o][t].boundingSphere;var O=n.magnitude(n.subtract(D.center,M,ue))+D.radius;O>R&&(R=O)}return new m({attributes:y,indices:w,primitiveType:p,boundingSphere:l(M)?new r(M,R):void 0})}function F(e){if(l(e.indices))return e;var t=m.computeNumberOfVertices(e);if(3>t)throw new c("The number of vertices must be at least three.");if(t%3!==0)throw new c("The number of vertices must be a multiple of three.");for(var r=g.createTypedArray(t,t),i=0;t>i;++i)r[i]=i;return e.indices=r,e}function B(e){var t=m.computeNumberOfVertices(e);if(3>t)throw new c("The number of vertices must be at least three.");var r=g.createTypedArray(t,3*(t-2));r[0]=1,r[1]=0,r[2]=2;for(var i=3,n=3;t>n;++n)r[i++]=n-1,r[i++]=0,r[i++]=n;return e.indices=r,e.primitiveType=b.TRIANGLES,e}function z(e){var t=m.computeNumberOfVertices(e);if(3>t)throw new c("The number of vertices must be at least 3.");var r=g.createTypedArray(t,3*(t-2));r[0]=0,r[1]=1,r[2]=2,t>3&&(r[3]=0,r[4]=2,r[5]=3);for(var i=6,n=3;t-1>n;n+=2)r[i++]=n,r[i++]=n-1,r[i++]=n+1,t>n+2&&(r[i++]=n,r[i++]=n+1,r[i++]=n+2);return e.indices=r,e.primitiveType=b.TRIANGLES,e}function V(e){if(l(e.indices))return e;var t=m.computeNumberOfVertices(e);if(2>t)throw new c("The number of vertices must be at least two.");if(t%2!==0)throw new c("The number of vertices must be a multiple of 2.");for(var r=g.createTypedArray(t,t),i=0;t>i;++i)r[i]=i;return e.indices=r,e}function k(e){var t=m.computeNumberOfVertices(e);if(2>t)throw new c("The number of vertices must be at least two.");var r=g.createTypedArray(t,2*(t-1));r[0]=0,r[1]=1;for(var i=2,n=2;t>n;++n)r[i++]=n-1,r[i++]=n;return e.indices=r,e.primitiveType=b.LINES,e}function U(e){var t=m.computeNumberOfVertices(e);if(2>t)throw new c("The number of vertices must be at least two.");var r=g.createTypedArray(t,2*t);r[0]=0,r[1]=1;for(var i=2,n=2;t>n;++n)r[i++]=n-1,r[i++]=n;return r[i++]=t-1,r[i]=0,e.indices=r,e.primitiveType=b.LINES,e}function q(e){switch(e.primitiveType){case b.TRIANGLE_FAN:return B(e);case b.TRIANGLE_STRIP:return z(e);case b.TRIANGLES:return F(e);case b.LINE_STRIP:return k(e);case b.LINE_LOOP:return U(e);case b.LINES:return V(e)}return e}function G(e,t){Math.abs(e.y)<w.EPSILON6&&(t?e.y=-w.EPSILON6:e.y=w.EPSILON6)}function W(e,t,r){if(0!==e.y&&0!==t.y&&0!==r.y)return G(e,e.y<0),G(t,t.y<0),void G(r,r.y<0);var i,n=Math.abs(e.y),o=Math.abs(t.y),a=Math.abs(r.y);i=n>o?n>a?w.sign(e.y):w.sign(r.y):o>a?w.sign(t.y):w.sign(r.y);var s=0>i;G(e,s),G(t,s),G(r,s)}function H(e,t,r,i){n.add(e,n.multiplyByScalar(n.subtract(t,e,we),e.y/(e.y-t.y),we),r),n.clone(r,i),G(r,!0),G(i,!1)}function j(e,t,r){if(e.x>=0||t.x>=0||r.x>=0)return void 0;W(e,t,r);var i=e.y<0,n=t.y<0,o=r.y<0,a=0;a+=i?1:0,a+=n?1:0,a+=o?1:0;var s=Te.indices;1===a?(s[1]=3,s[2]=4,s[5]=6,s[7]=6,s[8]=5,i?(H(e,t,Ce,Se),H(e,r,Ee,be),s[0]=0,s[3]=1,s[4]=2,s[6]=1):n?(H(t,r,Ce,Se),H(t,e,Ee,be),s[0]=1,s[3]=2,s[4]=0,s[6]=2):o&&(H(r,e,Ce,Se),H(r,t,Ee,be),s[0]=2,s[3]=0,s[4]=1,s[6]=0)):2===a&&(s[2]=4,s[4]=4,s[5]=3,s[7]=5,s[8]=6,i?n?o||(H(r,e,Ce,Se),H(r,t,Ee,be),s[0]=0,s[1]=1,s[3]=0,s[6]=2):(H(t,r,Ce,Se),H(t,e,Ee,be),s[0]=2,s[1]=0,s[3]=2,s[6]=1):(H(e,t,Ce,Se),H(e,r,Ee,be),s[0]=1,s[1]=2,s[3]=1,s[6]=0));var u=Te.positions;return u[0]=e,u[1]=t,u[2]=r,u.length=3,(1===a||2===a)&&(u[3]=Ce,u[4]=Ee,u[5]=Se,u[6]=be,u.length=7),Te}function Y(e,t){var i=e.attributes;if(0===i.position.values.length)return void 0;for(var n in i)if(i.hasOwnProperty(n)&&l(i[n])&&l(i[n].values)){var o=i[n];o.values=s.createTypedArray(o.componentDatatype,o.values)}var a=m.computeNumberOfVertices(e);return e.indices=g.createTypedArray(a,e.indices),t&&(e.boundingSphere=r.fromVertices(i.position.values)),e}function X(e){var t=e.attributes,r={};for(var i in t)if(t.hasOwnProperty(i)&&l(t[i])&&l(t[i].values)){var n=t[i];r[i]=new p({componentDatatype:n.componentDatatype,componentsPerAttribute:n.componentsPerAttribute,normalize:n.normalize,values:[]})}return new m({attributes:r,indices:[],primitiveType:e.primitiveType})}function Z(e,t,r){var i=l(e.geometry.boundingSphere);t=Y(t,i),r=Y(r,i),l(r)&&!l(t)?e.geometry=r:!l(r)&&l(t)?e.geometry=t:(e.westHemisphereGeometry=t,e.eastHemisphereGeometry=r,e.geometry=void 0)}function K(e,r,o,a,s,u,c,h,d,m,p){if(l(u)||l(c)||l(h)||l(d)){var f=n.fromArray(s,3*e,xe),v=n.fromArray(s,3*r,Pe),g=n.fromArray(s,3*o,Ae),_=t(a,f,v,g,Ie);if(l(u)){var y=n.fromArray(u,3*e,xe),w=n.fromArray(u,3*r,Pe),C=n.fromArray(u,3*o,Ae);n.multiplyByScalar(y,_.x,y),n.multiplyByScalar(w,_.y,w),n.multiplyByScalar(C,_.z,C);var E=n.add(y,w,y);n.add(E,C,E),n.normalize(E,E),n.pack(E,m.normal.values,3*p)}if(l(c)){var S=n.fromArray(c,3*e,xe),b=n.fromArray(c,3*r,Pe),T=n.fromArray(c,3*o,Ae);n.multiplyByScalar(S,_.x,S),n.multiplyByScalar(b,_.y,b),n.multiplyByScalar(T,_.z,T);var x=n.add(S,b,S);n.add(x,T,x),n.normalize(x,x),n.pack(x,m.binormal.values,3*p)}if(l(h)){var P=n.fromArray(h,3*e,xe),A=n.fromArray(h,3*r,Pe),I=n.fromArray(h,3*o,Ae);n.multiplyByScalar(P,_.x,P),n.multiplyByScalar(A,_.y,A),n.multiplyByScalar(I,_.z,I);var D=n.add(P,A,P);n.add(D,I,D),n.normalize(D,D),n.pack(D,m.tangent.values,3*p)}if(l(d)){var M=i.fromArray(d,2*e,De),R=i.fromArray(d,2*r,Me),O=i.fromArray(d,2*o,Re);i.multiplyByScalar(M,_.x,M),i.multiplyByScalar(R,_.y,R),i.multiplyByScalar(O,_.z,O);var N=i.add(M,R,M);i.add(N,O,N),i.pack(N,m.st.values,2*p)}}}function Q(e,t,r,i,n,o){var a=e.position.values.length/3;if(-1!==n){var s=i[n],u=r[s];return-1===u?(r[s]=a,e.position.values.push(o.x,o.y,o.z),t.push(a),a):(t.push(u),u)}return e.position.values.push(o.x,o.y,o.z),t.push(a),a}function J(e){var t,r,i,o,a,s=e.geometry,u=s.attributes,c=u.position.values,h=l(u.normal)?u.normal.values:void 0,d=l(u.binormal)?u.binormal.values:void 0,m=l(u.tangent)?u.tangent.values:void 0,p=l(u.st)?u.st.values:void 0,f=s.indices,v=X(s),g=X(s),_=[];_.length=c.length/3;var y=[];for(y.length=c.length/3,a=0;a<_.length;++a)_[a]=-1,y[a]=-1;var w=f.length;for(a=0;w>a;a+=3){var C=f[a],E=f[a+1],S=f[a+2],b=n.fromArray(c,3*C),T=n.fromArray(c,3*E),x=n.fromArray(c,3*S),P=j(b,T,x);if(l(P)&&P.positions.length>3)for(var A=P.positions,I=P.indices,D=I.length,M=0;D>M;++M){var R=I[M],O=A[R];O.y<0?(t=g.attributes,r=g.indices,i=_):(t=v.attributes,r=v.indices,i=y),o=Q(t,r,i,f,3>R?a+R:-1,O),K(C,E,S,O,c,h,d,m,p,t,o)}else l(P)&&(b=P.positions[0],T=P.positions[1],x=P.positions[2]),b.y<0?(t=g.attributes,r=g.indices,i=_):(t=v.attributes,r=v.indices,i=y),o=Q(t,r,i,f,a,b),K(C,E,S,b,c,h,d,m,p,t,o),o=Q(t,r,i,f,a+1,T),K(C,E,S,T,c,h,d,m,p,t,o),o=Q(t,r,i,f,a+2,x),K(C,E,S,x,c,h,d,m,p,t,o)}Z(e,g,v)}function $(e){var t,r=e.geometry,i=r.attributes,o=i.position.values,a=r.indices,s=X(r),u=X(r),c=a.length,h=[];h.length=o.length/3;var d=[];for(d.length=o.length/3,t=0;t<h.length;++t)h[t]=-1,d[t]=-1;for(t=0;c>t;t+=2){var m=a[t],p=a[t+1],f=n.fromArray(o,3*m,xe),v=n.fromArray(o,3*p,Pe);Math.abs(f.y)<w.EPSILON6&&(f.y<0?f.y=-w.EPSILON6:f.y=w.EPSILON6),Math.abs(v.y)<w.EPSILON6&&(v.y<0?v.y=-w.EPSILON6:v.y=w.EPSILON6);var g=s.attributes,_=s.indices,C=d,E=u.attributes,S=u.indices,b=h,T=y.lineSegmentPlane(f,v,Oe,Ae);if(l(T)){var x=n.multiplyByScalar(n.UNIT_Y,5*w.EPSILON9,Ne);f.y<0&&(n.negate(x,x),g=u.attributes,_=u.indices,C=h,E=s.attributes,S=s.indices,b=d);var P=n.add(T,x,Le);Q(g,_,C,a,t,f),Q(g,_,C,a,-1,P),n.negate(x,x),n.add(T,x,P),Q(E,S,b,a,-1,P),Q(E,S,b,a,t+1,v)}else{var A,I,D;f.y<0?(A=u.attributes,I=u.indices,D=h):(A=s.attributes,
I=s.indices,D=d),Q(A,I,D,a,t,f),Q(A,I,D,a,t+1,v)}}Z(e,u,s)}function ee(e){var t,r,a,s=e.geometry,u=s.attributes,c=u.position.values,h=u.prevPosition.values,d=u.nextPosition.values,m=u.expandAndWidth.values,p=(s.indices,l(u.st)?u.st.values:void 0),f=l(u.color)?u.color.values:void 0,v=X(s),g=X(s),_=c.length/3;for(t=0;_>t;t+=4){var C=t,E=t+1,S=t+2,b=t+3,T=n.fromArray(c,3*C,ze),x=n.fromArray(c,3*E,Ve),P=n.fromArray(c,3*S,ke),A=n.fromArray(c,3*b,Ue);Math.abs(T.y)<w.EPSILON6&&(T.y=w.EPSILON6*(P.y<0?-1:1),x.y=T.y),Math.abs(P.y)<w.EPSILON6&&(P.y=w.EPSILON6*(T.y<0?-1:1),A.y=P.y);var I=v.attributes,D=v.indices,M=g.attributes,R=g.indices,O=y.lineSegmentPlane(T,P,Oe,qe);if(l(O)){var N=n.multiplyByScalar(n.UNIT_Y,5*w.EPSILON9,Ge);T.y<0&&(n.negate(N,N),I=g.attributes,D=g.indices,M=v.attributes,R=v.indices);var L=n.add(O,N,We);for(I.position.values.push(T.x,T.y,T.z,x.x,x.y,x.z),I.position.values.push(L.x,L.y,L.z),I.position.values.push(L.x,L.y,L.z),n.negate(N,N),n.add(O,N,L),M.position.values.push(L.x,L.y,L.z),M.position.values.push(L.x,L.y,L.z),M.position.values.push(P.x,P.y,P.z,A.x,A.y,A.z),r=3*C;3*C+6>r;++r)I.prevPosition.values.push(h[r]);for(I.prevPosition.values.push(T.x,T.y,T.z,T.x,T.y,T.z),M.prevPosition.values.push(T.x,T.y,T.z,T.x,T.y,T.z),r=3*S;3*S+6>r;++r)M.prevPosition.values.push(h[r]);for(r=3*C;3*C+6>r;++r)I.nextPosition.values.push(d[r]);for(I.nextPosition.values.push(P.x,P.y,P.z,P.x,P.y,P.z),M.nextPosition.values.push(P.x,P.y,P.z,P.x,P.y,P.z),r=3*S;3*S+6>r;++r)M.nextPosition.values.push(d[r]);var F=i.fromArray(m,2*C,Fe),B=Math.abs(F.y);I.expandAndWidth.values.push(-1,B,1,B),I.expandAndWidth.values.push(-1,-B,1,-B),M.expandAndWidth.values.push(-1,B,1,B),M.expandAndWidth.values.push(-1,-B,1,-B);var z=n.magnitudeSquared(n.subtract(O,T,Ue));if(z/=n.magnitudeSquared(n.subtract(P,T,Ue)),l(f)){var V=o.fromArray(f,4*C,He),k=o.fromArray(f,4*S,He),U=w.lerp(V.x,k.x,z),q=w.lerp(V.y,k.y,z),G=w.lerp(V.z,k.z,z),W=w.lerp(V.w,k.w,z);for(r=4*C;4*C+8>r;++r)I.color.values.push(f[r]);for(I.color.values.push(U,q,G,W),I.color.values.push(U,q,G,W),M.color.values.push(U,q,G,W),M.color.values.push(U,q,G,W),r=4*S;4*S+8>r;++r)M.color.values.push(f[r])}if(l(p)){var H=i.fromArray(p,2*C,Fe),j=i.fromArray(p,2*(t+3),Be),Y=w.lerp(H.x,j.x,z);for(r=2*C;2*C+4>r;++r)I.st.values.push(p[r]);for(I.st.values.push(Y,H.y),I.st.values.push(Y,j.y),M.st.values.push(Y,H.y),M.st.values.push(Y,j.y),r=2*S;2*S+4>r;++r)M.st.values.push(p[r])}a=I.position.values.length/3-4,D.push(a,a+2,a+1),D.push(a+1,a+2,a+3),a=M.position.values.length/3-4,R.push(a,a+2,a+1),R.push(a+1,a+2,a+3)}else{var K,Q;for(T.y<0?(K=g.attributes,Q=g.indices):(K=v.attributes,Q=v.indices),K.position.values.push(T.x,T.y,T.z),K.position.values.push(x.x,x.y,x.z),K.position.values.push(P.x,P.y,P.z),K.position.values.push(A.x,A.y,A.z),r=3*t;3*t+12>r;++r)K.prevPosition.values.push(h[r]),K.nextPosition.values.push(d[r]);for(r=2*t;2*t+8>r;++r)K.expandAndWidth.values.push(m[r]),l(p)&&K.st.values.push(p[r]);if(l(f))for(r=4*t;4*t+16>r;++r)K.color.values.push(f[r]);a=K.position.values.length/3-4,Q.push(a,a+2,a+1),Q.push(a+1,a+2,a+3)}}Z(e,g,v)}var te={};te.toWireframe=function(e){if(!l(e))throw new c("geometry is required.");var t=e.indices;if(l(t)){switch(e.primitiveType){case b.TRIANGLES:e.indices=P(t);break;case b.TRIANGLE_STRIP:e.indices=A(t);break;case b.TRIANGLE_FAN:e.indices=I(t);break;default:throw new c("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=b.LINES}return e},te.createLineSegmentsForVectors=function(e,t,i){if(t=u(t,"normal"),!l(e))throw new c("geometry is required.");if(!l(e.attributes.position))throw new c("geometry.attributes.position is required.");if(!l(e.attributes[t]))throw new c("geometry.attributes must have an attribute with the same name as the attributeName parameter, "+t+".");i=u(i,1e4);for(var n=e.attributes.position.values,o=e.attributes[t].values,a=n.length,h=new Float64Array(2*a),d=0,f=0;a>f;f+=3)h[d++]=n[f],h[d++]=n[f+1],h[d++]=n[f+2],h[d++]=n[f]+o[f]*i,h[d++]=n[f+1]+o[f+1]*i,h[d++]=n[f+2]+o[f+2]*i;var v,g=e.boundingSphere;return l(g)&&(v=new r(g.center,g.radius+i)),new m({attributes:{position:new p({componentDatatype:s.DOUBLE,componentsPerAttribute:3,values:h})},primitiveType:b.LINES,boundingSphere:v})},te.createAttributeLocations=function(e){if(!l(e))throw new c("geometry is required.");var t,r=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","binormal","tangent","compressedAttributes"],i=e.attributes,n={},o=0,a=r.length;for(t=0;a>t;++t){var s=r[t];l(i[s])&&(n[s]=o++)}for(var u in i)i.hasOwnProperty(u)&&!l(n[u])&&(n[u]=o++);return n},te.reorderForPreVertexCache=function(e){if(!l(e))throw new c("geometry is required.");var t=m.computeNumberOfVertices(e),r=e.indices;if(l(r)){for(var i=new Int32Array(t),n=0;t>n;n++)i[n]=-1;for(var o,a=r,u=a.length,h=g.createTypedArray(t,u),d=0,p=0,f=0;u>d;)o=i[a[d]],-1!==o?h[p]=o:(o=a[d],i[o]=f,h[p]=f,++f),++d,++p;e.indices=h;var v=e.attributes;for(var _ in v)if(v.hasOwnProperty(_)&&l(v[_])&&l(v[_].values)){for(var y=v[_],w=y.values,C=0,E=y.componentsPerAttribute,S=s.createTypedArray(y.componentDatatype,f*E);t>C;){var b=i[C];if(-1!==b)for(n=0;E>n;n++)S[E*b+n]=w[E*C+n];++C}y.values=S}}return e},te.reorderForPostVertexCache=function(e,t){if(!l(e))throw new c("geometry is required.");var r=e.indices;if(e.primitiveType===b.TRIANGLES&&l(r)){for(var i=r.length,n=0,o=0;i>o;o++)r[o]>n&&(n=r[o]);e.indices=T.tipsify({indices:r,maximumIndex:n,cacheSize:t})}return e},te.fitToUnsignedShortIndices=function(e){if(!l(e))throw new c("geometry is required.");if(l(e.indices)&&e.primitiveType!==b.TRIANGLES&&e.primitiveType!==b.LINES&&e.primitiveType!==b.POINTS)throw new c("geometry.primitiveType must equal to PrimitiveType.TRIANGLES, PrimitiveType.LINES, or PrimitiveType.POINTS.");var t=[],r=m.computeNumberOfVertices(e);if(l(e.indices)&&r>=w.SIXTY_FOUR_KILOBYTES){var i,n=[],o=[],a=0,s=D(e.attributes),u=e.indices,h=u.length;e.primitiveType===b.TRIANGLES?i=3:e.primitiveType===b.LINES?i=2:e.primitiveType===b.POINTS&&(i=1);for(var d=0;h>d;d+=i){for(var p=0;i>p;++p){var f=u[d+p],v=n[f];l(v)||(v=a++,n[f]=v,M(s,e.attributes,f)),o.push(v)}a+i>=w.SIXTY_FOUR_KILOBYTES&&(t.push(new m({attributes:s,indices:o,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),n=[],o=[],a=0,s=D(e.attributes))}0!==o.length&&t.push(new m({attributes:s,indices:o,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else t.push(e);return t};var re=new n,ie=new a;te.projectTo2D=function(e,t,r,i,o){if(!l(e))throw new c("geometry is required.");if(!l(t))throw new c("attributeName is required.");if(!l(r))throw new c("attributeName3D is required.");if(!l(i))throw new c("attributeName2D is required.");if(!l(e.attributes[t]))throw new c("geometry must have attribute matching the attributeName argument: "+t+".");if(e.attributes[t].componentDatatype!==s.DOUBLE)throw new c("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");var a=e.attributes[t];o=l(o)?o:new d;for(var u=o.ellipsoid,h=a.values,m=new Float64Array(h.length),f=0,v=0;v<h.length;v+=3){var g=n.fromArray(h,v,re),_=u.cartesianToCartographic(g,ie);if(!l(_))throw new c("Could not project point ("+g.x+", "+g.y+", "+g.z+") to 2D.");var y=o.project(_,re);m[f++]=y.x,m[f++]=y.y,m[f++]=y.z}return e.attributes[r]=a,e.attributes[i]=new p({componentDatatype:s.DOUBLE,componentsPerAttribute:3,values:m}),delete e.attributes[t],e};var ne={high:0,low:0};te.encodeAttribute=function(e,t,r,i){if(!l(e))throw new c("geometry is required.");if(!l(t))throw new c("attributeName is required.");if(!l(r))throw new c("attributeHighName is required.");if(!l(i))throw new c("attributeLowName is required.");if(!l(e.attributes[t]))throw new c("geometry must have attribute matching the attributeName argument: "+t+".");if(e.attributes[t].componentDatatype!==s.DOUBLE)throw new c("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");for(var n=e.attributes[t],o=n.values,a=o.length,u=new Float32Array(a),d=new Float32Array(a),m=0;a>m;++m)h.encode(o[m],ne),u[m]=ne.high,d[m]=ne.low;var f=n.componentsPerAttribute;return e.attributes[r]=new p({componentDatatype:s.FLOAT,componentsPerAttribute:f,values:u}),e.attributes[i]=new p({componentDatatype:s.FLOAT,componentsPerAttribute:f,values:d}),delete e.attributes[t],e};var oe=new n,ae=new E,se=new C;te.transformToWorldCoordinates=function(e){if(!l(e))throw new c("instance is required.");var t=e.modelMatrix;if(E.equals(t,E.IDENTITY))return e;var i=e.geometry.attributes;R(t,i.position),R(t,i.prevPosition),R(t,i.nextPosition),(l(i.normal)||l(i.binormal)||l(i.tangent))&&(E.inverse(t,ae),E.transpose(ae,ae),E.getRotation(ae,se),O(se,i.normal),O(se,i.binormal),O(se,i.tangent));var n=e.geometry.boundingSphere;return l(n)&&(e.geometry.boundingSphere=r.transform(n,t,n)),e.modelMatrix=E.clone(E.IDENTITY),e};var ue=new n;te.combineInstances=function(e){if(!l(e)||e.length<1)throw new c("instances is required and must have length greater than zero.");for(var t=[],r=[],i=e.length,n=0;i>n;++n){var o=e[n];l(o.geometry)?t.push(o):r.push(o)}var a=[];return t.length>0&&a.push(L(t,"geometry")),r.length>0&&(a.push(L(r,"westHemisphereGeometry")),a.push(L(r,"eastHemisphereGeometry"))),a};var le=new n,ce=new n,he=new n,de=new n;te.computeNormal=function(e){if(!l(e))throw new c("geometry is required.");if(!l(e.attributes.position)||!l(e.attributes.position.values))throw new c("geometry.attributes.position.values is required.");if(!l(e.indices))throw new c("geometry.indices is required.");if(e.indices.length<2||e.indices.length%3!==0)throw new c("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==b.TRIANGLES)throw new c("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var t=e.indices,r=e.attributes,i=r.position.values,o=r.position.values.length/3,a=t.length,u=new Array(o),h=new Array(a/3),d=new Array(a),m=0;o>m;m++)u[m]={indexOffset:0,count:0,currentCount:0};var f=0;for(m=0;a>m;m+=3){var v=t[m],g=t[m+1],_=t[m+2],y=3*v,w=3*g,C=3*_;ce.x=i[y],ce.y=i[y+1],ce.z=i[y+2],he.x=i[w],he.y=i[w+1],he.z=i[w+2],de.x=i[C],de.y=i[C+1],de.z=i[C+2],u[v].count++,u[g].count++,u[_].count++,n.subtract(he,ce,he),n.subtract(de,ce,de),h[f]=n.cross(he,de,new n),f++}var E=0;for(m=0;o>m;m++)u[m].indexOffset+=E,E+=u[m].count;f=0;var S;for(m=0;a>m;m+=3){S=u[t[m]];var T=S.indexOffset+S.currentCount;d[T]=f,S.currentCount++,S=u[t[m+1]],T=S.indexOffset+S.currentCount,d[T]=f,S.currentCount++,S=u[t[m+2]],T=S.indexOffset+S.currentCount,d[T]=f,S.currentCount++,f++}var x=new Float32Array(3*o);for(m=0;o>m;m++){var P=3*m;if(S=u[m],S.count>0){for(n.clone(n.ZERO,le),f=0;f<S.count;f++)n.add(le,h[d[S.indexOffset+f]],le);n.normalize(le,le),x[P]=le.x,x[P+1]=le.y,x[P+2]=le.z}else x[P]=0,x[P+1]=0,x[P+2]=1}return e.attributes.normal=new p({componentDatatype:s.FLOAT,componentsPerAttribute:3,values:x}),e};var me=new n,pe=new n,fe=new n;te.computeBinormalAndTangent=function(e){if(!l(e))throw new c("geometry is required.");var t=e.attributes,r=e.indices;if(!l(t.position)||!l(t.position.values))throw new c("geometry.attributes.position.values is required.");if(!l(t.normal)||!l(t.normal.values))throw new c("geometry.attributes.normal.values is required.");if(!l(t.st)||!l(t.st.values))throw new c("geometry.attributes.st.values is required.");if(!l(r))throw new c("geometry.indices is required.");if(r.length<2||r.length%3!==0)throw new c("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==b.TRIANGLES)throw new c("geometry.primitiveType must be PrimitiveType.TRIANGLES.");for(var i=e.attributes.position.values,o=e.attributes.normal.values,a=e.attributes.st.values,u=e.attributes.position.values.length/3,h=r.length,d=new Array(3*u),m=0;m<d.length;m++)d[m]=0;var f,v,g;for(m=0;h>m;m+=3){var _=r[m],y=r[m+1],w=r[m+2];f=3*_,v=3*y,g=3*w;var C=2*_,E=2*y,S=2*w,T=i[f],x=i[f+1],P=i[f+2],A=a[C],I=a[C+1],D=a[E+1]-I,M=a[S+1]-I,R=1/((a[E]-A)*M-(a[S]-A)*D),O=(M*(i[v]-T)-D*(i[g]-T))*R,N=(M*(i[v+1]-x)-D*(i[g+1]-x))*R,L=(M*(i[v+2]-P)-D*(i[g+2]-P))*R;d[f]+=O,d[f+1]+=N,d[f+2]+=L,d[v]+=O,d[v+1]+=N,d[v+2]+=L,d[g]+=O,d[g+1]+=N,d[g+2]+=L}var F=new Float32Array(3*u),B=new Float32Array(3*u);for(m=0;u>m;m++){f=3*m,v=f+1,g=f+2;var z=n.fromArray(o,f,me),V=n.fromArray(d,f,fe),k=n.dot(z,V);n.multiplyByScalar(z,k,pe),n.normalize(n.subtract(V,pe,V),V),B[f]=V.x,B[v]=V.y,B[g]=V.z,n.normalize(n.cross(z,V,V),V),F[f]=V.x,F[v]=V.y,F[g]=V.z}return e.attributes.tangent=new p({componentDatatype:s.FLOAT,componentsPerAttribute:3,values:B}),e.attributes.binormal=new p({componentDatatype:s.FLOAT,componentsPerAttribute:3,values:F}),e};var ve=new i,ge=new n,_e=new n,ye=new n;te.compressVertices=function(t){if(!l(t))throw new c("geometry is required.");var r=t.attributes.normal,o=t.attributes.st;if(!l(r)&&!l(o))return t;var a,u,h,d,m=t.attributes.tangent,f=t.attributes.binormal;l(r)&&(a=r.values),l(o)&&(u=o.values),l(m)&&(h=m.values),f&&(d=f.values);var v=l(a)?a.length:u.length,g=l(a)?3:2,_=v/g,y=_,w=l(u)&&l(a)?2:1;w+=l(h)||l(d)?1:0,y*=w;for(var C=new Float32Array(y),E=0,S=0;_>S;++S){l(u)&&(i.fromArray(u,2*S,ve),C[E++]=e.compressTextureCoordinates(ve));var b=3*S;l(a)&&l(h)&&l(d)?(n.fromArray(a,b,ge),n.fromArray(h,b,_e),n.fromArray(d,b,ye),e.octPack(ge,_e,ye,ve),C[E++]=ve.x,C[E++]=ve.y):(l(a)&&(n.fromArray(a,b,ge),C[E++]=e.octEncodeFloat(ge)),l(h)&&(n.fromArray(h,b,ge),C[E++]=e.octEncodeFloat(ge)),l(d)&&(n.fromArray(d,b,ge),C[E++]=e.octEncodeFloat(ge)))}return t.attributes.compressedAttributes=new p({componentDatatype:s.FLOAT,componentsPerAttribute:w,values:C}),l(a)&&delete t.attributes.normal,l(u)&&delete t.attributes.st,l(h)&&delete t.attributes.tangent,l(d)&&delete t.attributes.binormal,t};var we=new n,Ce=new n,Ee=new n,Se=new n,be=new n,Te={positions:new Array(7),indices:new Array(9)},xe=new n,Pe=new n,Ae=new n,Ie=new n,De=new i,Me=new i,Re=new i,Oe=S.fromPointNormal(n.ZERO,n.UNIT_Y),Ne=new n,Le=new n,Fe=new i,Be=new i,ze=new n,Ve=new n,ke=new n,Ue=new n,qe=new n,Ge=new n,We=new n,He=new o;new o;return te.splitLongitude=function(e){if(!l(e))throw new c("instance is required.");var t=e.geometry,i=t.boundingSphere;if(l(i)){var n=i.center.x-i.radius;if(n>0||r.intersectPlane(i,S.ORIGIN_ZX_PLANE)!==_.INTERSECTING)return e}if(t.geometryType!==v.NONE)switch(t.geometryType){case v.POLYLINES:ee(e);break;case v.TRIANGLES:J(e);break;case v.LINES:$(e)}else q(t),t.primitiveType===b.TRIANGLES?J(e):t.primitiveType===b.LINES&&$(e);return e},te}),r("Core/EllipseGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EllipseGeometryLibrary","./Ellipsoid","./GeographicProjection","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./Matrix3","./PrimitiveType","./Quaternion","./VertexFormat"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f,v,g,_,y,w,C){"use strict";function E(e,i,o){var a=i.vertexFormat,s=i.center,l=i.semiMajorAxis,h=i.semiMinorAxis,p=i.ellipsoid,f=i.stRotation,v=o?e.length/3*2:e.length/3,g=a.st?new Float32Array(2*v):void 0,y=a.normal?new Float32Array(3*v):void 0,C=a.tangent?new Float32Array(3*v):void 0,E=a.binormal?new Float32Array(3*v):void 0,S=0,b=L,T=F,x=B,P=new c(p),M=P.project(p.cartesianToCartographic(s,z),V),q=p.scaleToGeodeticSurface(s,A);p.geodeticSurfaceNormal(q,q);for(var G=w.fromAxisAngle(q,f,N),W=_.fromQuaternion(G,O),H=t.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,k),j=t.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,U),Y=e.length,X=o?Y:0,Z=X/3*2,K=0;Y>K;K+=3){var Q=K+1,J=K+2,$=r.fromArray(e,K,A);if(a.st){var ee=_.multiplyByVector(W,$,I),te=P.project(p.cartesianToCartographic(ee,z),D);r.subtract(te,M,te),R.x=(te.x+l)/(2*l),R.y=(te.y+h)/(2*h),H.x=Math.min(R.x,H.x),H.y=Math.min(R.y,H.y),j.x=Math.max(R.x,j.x),j.y=Math.max(R.y,j.y),o&&(g[S+Z]=R.x,g[S+1+Z]=R.y),g[S++]=R.x,g[S++]=R.y}b=p.geodeticSurfaceNormal($,b),(a.normal||a.tangent||a.binormal)&&((a.tangent||a.binormal)&&(T=r.cross(r.UNIT_Z,b,T),_.multiplyByVector(W,T,T)),a.normal&&(y[K]=b.x,y[Q]=b.y,y[J]=b.z,o&&(y[K+X]=-b.x,y[Q+X]=-b.y,y[J+X]=-b.z)),a.tangent&&(C[K]=T.x,C[Q]=T.y,C[J]=T.z,o&&(C[K+X]=-T.x,C[Q+X]=-T.y,C[J+X]=-T.z)),a.binormal&&(x=r.cross(b,T,x),E[K]=x.x,E[Q]=x.y,E[J]=x.z,o&&(E[K+X]=x.x,E[Q+X]=x.y,E[J+X]=x.z)))}if(a.st){Y=g.length;for(var re=0;Y>re;re+=2)g[re]=(g[re]-H.x)/(j.x-H.x),g[re+1]=(g[re+1]-H.y)/(j.y-H.y)}var ie=new m;if(a.position){var ne=u.raisePositionsToHeight(e,i,o);ie.position=new d({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:ne})}return a.st&&(ie.st=new d({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:g})),a.normal&&(ie.normal=new d({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:y})),a.tangent&&(ie.tangent=new d({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:C})),a.binormal&&(ie.binormal=new d({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:E})),ie}function S(e){var t,r,i,n,o,a=new Array(2*e*(e+1)),s=0;for(n=1;e>n;++n){for(i=n*(n+1),t=(n-1)*n,a[s++]=i++,a[s++]=t,a[s++]=i,r=2*n,o=0;r-1>o;++o)a[s++]=i,a[s++]=t++,a[s++]=t,a[s++]=i++,a[s++]=t,a[s++]=i;a[s++]=i++,a[s++]=t,a[s++]=i}for(r=2*e,++i,++t,n=0;r-1>n;++n)a[s++]=i,a[s++]=t++,a[s++]=t,a[s++]=i++,a[s++]=t,a[s++]=i;for(++t,++i,n=e-1;n>0;--n){for(a[s++]=t++,a[s++]=t,a[s++]=i,r=2*n,o=0;r-1>o;++o)a[s++]=i,a[s++]=t++,a[s++]=t,a[s++]=i++,a[s++]=t,a[s++]=i;a[s++]=t++,a[s++]=t++,a[s++]=i++}return a}function b(t){var i=t.center;q=r.multiplyByScalar(t.ellipsoid.geodeticSurfaceNormal(i,q),t.height,q),q=r.add(i,q,q);var n=new e(q,t.semiMajorAxis),o=u.computeEllipsePositions(t,!0,!1),a=o.positions,s=o.numPts,l=E(a,t,!1),c=S(s);return c=v.createTypedArray(a.length/3,c),{boundingSphere:n,attributes:l,indices:c}}function T(e,i){var o=i.vertexFormat,a=i.center,s=i.semiMajorAxis,u=i.semiMinorAxis,l=i.ellipsoid,h=i.height,p=i.extrudedHeight,f=i.stRotation,v=e.length/3*2,g=new Float64Array(3*v),y=o.st?new Float32Array(2*v):void 0,C=o.normal?new Float32Array(3*v):void 0,E=o.tangent?new Float32Array(3*v):void 0,S=o.binormal?new Float32Array(3*v):void 0,b=0,T=L,x=F,P=B,q=new c(l),G=q.project(l.cartesianToCartographic(a,z),V),W=l.scaleToGeodeticSurface(a,A);l.geodeticSurfaceNormal(W,W);for(var H=w.fromAxisAngle(W,f,N),j=_.fromQuaternion(H,O),Y=t.fromElements(Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,k),X=t.fromElements(Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,U),Z=e.length,K=Z/3*2,Q=0;Z>Q;Q+=3){var J,$=Q+1,ee=Q+2,te=r.fromArray(e,Q,A);if(o.st){var re=_.multiplyByVector(j,te,I),ie=q.project(l.cartesianToCartographic(re,z),D);r.subtract(ie,G,ie),R.x=(ie.x+s)/(2*s),R.y=(ie.y+u)/(2*u),Y.x=Math.min(R.x,Y.x),Y.y=Math.min(R.y,Y.y),X.x=Math.max(R.x,X.x),X.y=Math.max(R.y,X.y),y[b+K]=R.x,y[b+1+K]=R.y,y[b++]=R.x,y[b++]=R.y}te=l.scaleToGeodeticSurface(te,te),J=r.clone(te,I),T=l.geodeticSurfaceNormal(te,T);var ne=r.multiplyByScalar(T,h,M);if(te=r.add(te,ne,te),ne=r.multiplyByScalar(T,p,ne),J=r.add(J,ne,J),o.position&&(g[Q+Z]=J.x,g[$+Z]=J.y,g[ee+Z]=J.z,g[Q]=te.x,g[$]=te.y,g[ee]=te.z),o.normal||o.tangent||o.binormal){P=r.clone(T,P);var oe=r.fromArray(e,(Q+3)%Z,M);r.subtract(oe,te,oe);var ae=r.subtract(J,te,D);T=r.normalize(r.cross(ae,oe,T),T),o.normal&&(C[Q]=T.x,C[$]=T.y,C[ee]=T.z,C[Q+Z]=T.x,C[$+Z]=T.y,C[ee+Z]=T.z),o.tangent&&(x=r.normalize(r.cross(P,T,x),x),E[Q]=x.x,E[$]=x.y,E[ee]=x.z,E[Q+Z]=x.x,E[Q+1+Z]=x.y,E[Q+2+Z]=x.z),o.binormal&&(S[Q]=P.x,S[$]=P.y,S[ee]=P.z,S[Q+Z]=P.x,S[$+Z]=P.y,S[ee+Z]=P.z)}}if(o.st){Z=y.length;for(var se=0;Z>se;se+=2)y[se]=(y[se]-Y.x)/(X.x-Y.x),y[se+1]=(y[se+1]-Y.y)/(X.y-Y.y)}var ue=new m;return o.position&&(ue.position=new d({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:g})),o.st&&(ue.st=new d({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:y})),o.normal&&(ue.normal=new d({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:C})),o.tangent&&(ue.tangent=new d({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:E})),o.binormal&&(ue.binormal=new d({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:S})),ue}function x(e){for(var t=e.length/3,r=v.createTypedArray(t,6*t),i=0,n=0;t>n;n++){var o=n,a=n+t,s=(o+1)%t,u=s+t;r[i++]=o,r[i++]=a,r[i++]=s,r[i++]=s,r[i++]=a,r[i++]=u}return r}function P(t){var i=t.center,n=t.ellipsoid,o=t.semiMajorAxis,a=r.multiplyByScalar(n.geodeticSurfaceNormal(i,A),t.height,A);G.center=r.add(i,a,G.center),G.radius=o,a=r.multiplyByScalar(n.geodeticSurfaceNormal(i,a),t.extrudedHeight,a),W.center=r.add(i,a,W.center),W.radius=o;var s=u.computeEllipsePositions(t,!0,!0),l=s.positions,c=s.numPts,d=s.outerPositions,m=e.union(G,W),g=E(l,t,!0),_=S(c),w=_.length;_.length=2*w;for(var C=l.length/3,b=0;w>b;b+=3)_[b+w]=_[b+2]+C,_[b+1+w]=_[b+1]+C,_[b+2+w]=_[b]+C;var P=v.createTypedArray(2*C/3,_),I=new h({attributes:g,indices:P,primitiveType:y.TRIANGLES}),D=T(d,t);_=x(d);var M=v.createTypedArray(2*d.length/3,_),R=new h({attributes:D,indices:M,primitiveType:y.TRIANGLES}),O=f.combineInstances([new p({geometry:I}),new p({geometry:R})]);return{boundingSphere:m,attributes:O[0].attributes,indices:O[0].indices}}var A=new r,I=new r,D=new r,M=new r,R=new t,O=new _,N=new w,L=new r,F=new r,B=new r,z=new i,V=new r,k=new t,U=new t,q=new r,G=new e,W=new e,H=function(e){e=o(e,o.EMPTY_OBJECT);var t=e.center,i=o(e.ellipsoid,l.WGS84),n=e.semiMajorAxis,u=e.semiMinorAxis,c=o(e.granularity,g.RADIANS_PER_DEGREE),h=o(e.height,0),d=e.extrudedHeight,m=a(d)&&Math.abs(h-d)>1,p=o(e.vertexFormat,C.DEFAULT);if(!a(t))throw new s("center is required.");if(!a(n))throw new s("semiMajorAxis is required.");if(!a(u))throw new s("semiMinorAxis is required.");if(0>=n||0>=u)throw new s("Semi-major and semi-minor axes must be greater than zero.");if(u>n)throw new s("semiMajorAxis must be greater than or equal to the semiMinorAxis.");if(0>=c)throw new s("granularity must be greater than zero.");this._center=r.clone(t),this._semiMajorAxis=n,this._semiMinorAxis=u,this._ellipsoid=l.clone(i),this._rotation=o(e.rotation,0),this._stRotation=o(e.stRotation,0),this._height=h,this._granularity=c,this._vertexFormat=C.clone(p),this._extrudedHeight=o(d,h),this._extrude=m,this._workerName="createEllipseGeometry"};H.packedLength=r.packedLength+l.packedLength+C.packedLength+8,H.pack=function(e,t,i){if(!a(e))throw new s("value is required");if(!a(t))throw new s("array is required");i=o(i,0),r.pack(e._center,t,i),i+=r.packedLength,l.pack(e._ellipsoid,t,i),i+=l.packedLength,C.pack(e._vertexFormat,t,i),i+=C.packedLength,t[i++]=e._semiMajorAxis,t[i++]=e._semiMinorAxis,t[i++]=e._rotation,t[i++]=e._stRotation,t[i++]=e._height,t[i++]=e._granularity,t[i++]=e._extrudedHeight,t[i]=e._extrude?1:0};var j=new r,Y=new l,X=new C,Z={center:j,ellipsoid:Y,vertexFormat:X,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,stRotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0};return H.unpack=function(e,t,i){if(!a(e))throw new s("array is required");t=o(t,0);var n=r.unpack(e,t,j);t+=r.packedLength;var u=l.unpack(e,t,Y);t+=l.packedLength;var c=C.unpack(e,t,X);t+=C.packedLength;var h=e[t++],d=e[t++],m=e[t++],p=e[t++],f=e[t++],v=e[t++],g=e[t++],_=1===e[t];return a(i)?(i._center=r.clone(n,i._center),i._ellipsoid=l.clone(u,i._ellipsoid),i._vertexFormat=C.clone(c,i._vertexFormat),i._semiMajorAxis=h,i._semiMinorAxis=d,i._rotation=m,i._stRotation=p,i._height=f,i._granularity=v,i._extrudedHeight=g,i._extrude=_,i):(Z.height=f,Z.extrudedHeight=g,Z.granularity=v,Z.stRotation=p,Z.rotation=m,Z.semiMajorAxis=h,Z.semiMinorAxis=d,new H(Z))},H.createGeometry=function(e){e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);var t,r={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:e._height,extrudedHeight:e._extrudedHeight,granularity:e._granularity,vertexFormat:e._vertexFormat,stRotation:e._stRotation};return e._extrude?(r.extrudedHeight=Math.min(e._extrudedHeight,e._height),r.height=Math.max(e._extrudedHeight,e._height),t=P(r)):t=b(r),new h({attributes:t.attributes,indices:t.indices,primitiveType:y.TRIANGLES,boundingSphere:t.boundingSphere})},H.createShadowVolume=function(e,t,r){var i=e._granularity,n=e._ellipsoid,o=t(i,n),a=r(i,n);return new H({center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:n,stRotation:e._stRotation,granularity:i,extrudedHeight:o,height:a,vertexFormat:C.POSITION_ONLY})},H}),r("Core/CircleGeometry",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./EllipseGeometry","./Ellipsoid","./Math","./VertexFormat"],function(e,t,r,i,n,o,a,s){"use strict";var u=function(e){e=t(e,t.EMPTY_OBJECT);var o=e.radius;if(!r(o))throw new i("radius is required.");if(0>=o)throw new i("radius must be greater than zero.");var a={center:e.center,semiMajorAxis:o,semiMinorAxis:o,ellipsoid:e.ellipsoid,height:e.height,extrudedHeight:e.extrudedHeight,granularity:e.granularity,vertexFormat:e.vertexFormat,stRotation:e.stRotation};this._ellipseGeometry=new n(a),this._workerName="createCircleGeometry"};u.packedLength=n.packedLength,u.pack=function(e,t,o){if(!r(e))throw new i("value is required");n.pack(e._ellipseGeometry,t,o)};var l=new n({center:new e,semiMajorAxis:1,semiMinorAxis:1}),c={center:new e,radius:void 0,ellipsoid:o.clone(o.UNIT_SPHERE),height:void 0,extrudedHeight:void 0,granularity:void 0,vertexFormat:new s,stRotation:void 0,semiMajorAxis:void 0,semiMinorAxis:void 0};return u.unpack=function(t,i,a){var h=n.unpack(t,i,l);return c.center=e.clone(h._center,c.center),c.ellipsoid=o.clone(h._ellipsoid,c.ellipsoid),c.height=h._height,c.extrudedHeight=h._extrudedHeight,c.granularity=h._granularity,c.vertexFormat=s.clone(h._vertexFormat,c.vertexFormat),c.stRotation=h._stRotation,r(a)?(c.semiMajorAxis=h._semiMajorAxis,c.semiMinorAxis=h._semiMinorAxis,a._ellipseGeometry=new n(c),a):(c.radius=h._semiMajorAxis,new u(c))},u.createGeometry=function(e){return n.createGeometry(e._ellipseGeometry)},u.createShadowVolume=function(e,t,r){var i=e._ellipseGeometry._granularity,n=e._ellipseGeometry._ellipsoid,o=t(i,n),a=r(i,n);return new u({center:e._ellipseGeometry._center,radius:e._ellipseGeometry._semiMajorAxis,ellipsoid:n,stRotation:e._ellipseGeometry._stRotation,granularity:i,extrudedHeight:o,height:a,vertexFormat:s.POSITION_ONLY})},u}),r("Core/EllipseOutlineGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./EllipseGeometryLibrary","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m){"use strict";function p(i){var n=i.center;g=t.multiplyByScalar(i.ellipsoid.geodeticSurfaceNormal(n,g),i.height,g),g=t.add(n,g,g);for(var o=new e(g,i.semiMajorAxis),s=a.computeEllipsePositions(i,!1,!0).outerPositions,u=new c({position:new l({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:a.raisePositionsToHeight(s,i,!1)})}),d=s.length/3,m=h.createTypedArray(d,2*d),p=0,f=0;d>f;++f)m[p++]=f,m[p++]=(f+1)%d;return{boundingSphere:o,attributes:u,indices:m}}function f(n){var o=i(n.numberOfVerticalLines,16);o=Math.max(o,0);var s=n.center,u=n.ellipsoid,d=n.semiMajorAxis,m=t.multiplyByScalar(u.geodeticSurfaceNormal(s,v),n.height,v);_.center=t.add(s,m,_.center),_.radius=d,m=t.multiplyByScalar(u.geodeticSurfaceNormal(s,m),n.extrudedHeight,m),y.center=t.add(s,m,y.center),y.radius=d;var p=a.computeEllipsePositions(n,!1,!0).outerPositions,f=new c({position:new l({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:a.raisePositionsToHeight(p,n,!0)})});p=f.position.values;var g=e.union(_,y),w=p.length/3,C=h.createTypedArray(w,2*w+2*o);w/=2;var E,S=0;for(E=0;w>E;++E)C[S++]=E,C[S++]=(E+1)%w,C[S++]=E+w,C[S++]=(E+1)%w+w;var b;if(o>0){var T=Math.min(o,w);b=Math.round(w/T)}var x=Math.min(b*o,w);if(o>0)for(E=0;x>E;E+=b)C[S++]=E,C[S++]=E+w;return{boundingSphere:g,attributes:f,indices:C}}var v=new t,g=new t,_=new e,y=new e,w=function(e){e=i(e,i.EMPTY_OBJECT);var r=e.center,a=i(e.ellipsoid,s.WGS84),u=e.semiMajorAxis,l=e.semiMinorAxis,c=i(e.granularity,d.RADIANS_PER_DEGREE),h=i(e.height,0),m=e.extrudedHeight,p=n(m)&&Math.abs(h-m)>1;if(!n(r))throw new o("center is required.");if(!n(u))throw new o("semiMajorAxis is required.");if(!n(l))throw new o("semiMinorAxis is required.");if(0>=u||0>=l)throw new o("Semi-major and semi-minor axes must be greater than zero.");if(l>u)throw new o("semiMajorAxis must be greater than or equal to the semiMinorAxis.");if(0>=c)throw new o("granularity must be greater than zero.");this._center=t.clone(r),this._semiMajorAxis=u,this._semiMinorAxis=l,this._ellipsoid=s.clone(a),this._rotation=i(e.rotation,0),this._height=h,this._granularity=c,this._extrudedHeight=m,this._extrude=p,this._numberOfVerticalLines=Math.max(i(e.numberOfVerticalLines,16),0),this._workerName="createEllipseOutlineGeometry"};w.packedLength=t.packedLength+s.packedLength+9,w.pack=function(e,r,a){if(!n(e))throw new o("value is required");if(!n(r))throw new o("array is required");a=i(a,0),t.pack(e._center,r,a),a+=t.packedLength,s.pack(e._ellipsoid,r,a),a+=s.packedLength,r[a++]=e._semiMajorAxis,r[a++]=e._semiMinorAxis,r[a++]=e._rotation,r[a++]=e._height,r[a++]=e._granularity,r[a++]=n(e._extrudedHeight)?1:0,r[a++]=i(e._extrudedHeight,0),r[a++]=e._extrude?1:0,r[a]=e._numberOfVerticalLines};var C=new t,E=new s,S={center:C,ellipsoid:E,semiMajorAxis:void 0,semiMinorAxis:void 0,rotation:void 0,height:void 0,granularity:void 0,extrudedHeight:void 0,numberOfVerticalLines:void 0};return w.unpack=function(e,r,a){if(!n(e))throw new o("array is required");r=i(r,0);var u=t.unpack(e,r,C);r+=t.packedLength;var l=s.unpack(e,r,E);r+=s.packedLength;var c=e[r++],h=e[r++],d=e[r++],m=e[r++],p=e[r++],f=e[r++],v=e[r++],g=1===e[r++],_=e[r];return n(a)?(a._center=t.clone(u,a._center),a._ellipsoid=s.clone(l,a._ellipsoid),a._semiMajorAxis=c,a._semiMinorAxis=h,a._rotation=d,a._height=m,a._granularity=p,a._extrudedHeight=f?v:void 0,a._extrude=g,a._numberOfVerticalLines=_,a):(S.height=m,S.extrudedHeight=f?v:void 0,S.granularity=p,S.rotation=d,S.semiMajorAxis=c,S.semiMinorAxis=h,S.numberOfVerticalLines=_,new w(S))},w.createGeometry=function(e){e._center=e._ellipsoid.scaleToGeodeticSurface(e._center,e._center);var t,r={center:e._center,semiMajorAxis:e._semiMajorAxis,semiMinorAxis:e._semiMinorAxis,ellipsoid:e._ellipsoid,rotation:e._rotation,height:e._height,extrudedHeight:e._extrudedHeight,granularity:e._granularity,numberOfVerticalLines:e._numberOfVerticalLines};return e._extrude?(r.extrudedHeight=Math.min(e._extrudedHeight,e._height),r.height=Math.max(e._extrudedHeight,e._height),t=f(r)):t=p(r),new u({attributes:t.attributes,indices:t.indices,primitiveType:m.LINES,boundingSphere:t.boundingSphere})},w}),r("Core/CircleOutlineGeometry",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./EllipseOutlineGeometry","./Ellipsoid"],function(e,t,r,i,n,o){"use strict";var a=function(e){e=t(e,t.EMPTY_OBJECT);var o=e.radius;if(!r(o))throw new i("radius is required.");if(0>=o)throw new i("radius must be greater than zero.");var a={center:e.center,semiMajorAxis:o,semiMinorAxis:o,ellipsoid:e.ellipsoid,height:e.height,extrudedHeight:e.extrudedHeight,granularity:e.granularity,numberOfVerticalLines:e.numberOfVerticalLines};this._ellipseGeometry=new n(a),this._workerName="createCircleOutlineGeometry"};a.packedLength=n.packedLength,a.pack=function(e,t,o){if(!r(e))throw new i("value is required");n.pack(e._ellipseGeometry,t,o)};var s=new n({center:new e,semiMajorAxis:1,semiMinorAxis:1}),u={center:new e,radius:void 0,ellipsoid:o.clone(o.UNIT_SPHERE),height:void 0,extrudedHeight:void 0,granularity:void 0,numberOfVerticalLines:void 0,semiMajorAxis:void 0,semiMinorAxis:void 0};return a.unpack=function(t,i,l){var c=n.unpack(t,i,s);return u.center=e.clone(c._center,u.center),u.ellipsoid=o.clone(c._ellipsoid,u.ellipsoid),
u.height=c._height,u.extrudedHeight=c._extrudedHeight,u.granularity=c._granularity,u.numberOfVerticalLines=c._numberOfVerticalLines,r(l)?(u.semiMajorAxis=c._semiMajorAxis,u.semiMinorAxis=c._semiMinorAxis,l._ellipseGeometry=new n(u),l):(u.radius=c._semiMajorAxis,new a(u))},a.createGeometry=function(e){return n.createGeometry(e._ellipseGeometry)},a}),r("Core/ClockRange",["./freezeObject"],function(e){"use strict";var t={UNBOUNDED:0,CLAMPED:1,LOOP_STOP:2};return e(t)}),r("Core/ClockStep",["./freezeObject"],function(e){"use strict";var t={TICK_DEPENDENT:0,SYSTEM_CLOCK_MULTIPLIER:1,SYSTEM_CLOCK:2};return e(t)}),r("Core/getTimestamp",["./defined"],function(e){"use strict";var t;return t="undefined"!=typeof performance&&e(performance.now)?function(){return performance.now()}:function(){return Date.now()}}),r("Core/Clock",["./ClockRange","./ClockStep","./defaultValue","./defined","./DeveloperError","./Event","./getTimestamp","./JulianDate"],function(e,t,r,i,n,o,a,s){"use strict";var u=function(u){u=r(u,r.EMPTY_OBJECT);var l=u.startTime,c=!i(l),h=u.stopTime,d=!i(h),m=u.currentTime,p=!i(m);if(c&&d&&p?(m=s.now(),l=s.clone(m),h=s.addDays(m,1,new s)):c&&d?(l=s.clone(m),h=s.addDays(m,1,new s)):c&&p?(l=s.addDays(h,-1,new s),m=s.clone(l)):p&&d?(m=s.clone(l),h=s.addDays(l,1,new s)):p?m=s.clone(l):d?h=s.addDays(m,1,new s):c&&(l=s.clone(m)),s.greaterThan(l,h))throw new n("startTime must come before stopTime.");this.startTime=l,this.stopTime=h,this.currentTime=m,this.multiplier=r(u.multiplier,1),this.clockStep=r(u.clockStep,t.SYSTEM_CLOCK_MULTIPLIER),this.clockRange=r(u.clockRange,e.UNBOUNDED),this.canAnimate=r(u.canAnimate,!0),this.shouldAnimate=r(u.shouldAnimate,!0),this.onTick=new o,this._lastSystemTime=a()};return u.prototype.tick=function(){var r=a(),i=s.clone(this.currentTime),n=this.startTime,o=this.stopTime,u=this.multiplier;if(this.canAnimate&&this.shouldAnimate)if(this.clockStep===t.SYSTEM_CLOCK)i=s.now(i);else{if(this.clockStep===t.TICK_DEPENDENT)i=s.addSeconds(i,u,i);else{var l=r-this._lastSystemTime;i=s.addSeconds(i,u*(l/1e3),i)}if(this.clockRange===e.CLAMPED)s.lessThan(i,n)?i=s.clone(n,i):s.greaterThan(i,o)&&(i=s.clone(o,i));else if(this.clockRange===e.LOOP_STOP)for(s.lessThan(i,n)&&(i=s.clone(n,i));s.greaterThan(i,o);)i=s.addSeconds(n,s.secondsDifference(i,o),i)}return this.currentTime=i,this._lastSystemTime=r,this.onTick.raiseEvent(this),i},u}),r("Core/Color",["./defaultValue","./defined","./DeveloperError","./FeatureDetection","./freezeObject","./Math"],function(e,t,r,i,n,o){"use strict";function a(e,t,r){return 0>r&&(r+=1),r>1&&(r-=1),1>6*r?e+6*(t-e)*r:1>2*r?t:2>3*r?e+(t-e)*(2/3-r)*6:e}var s=function(t,r,i,n){this.red=e(t,1),this.green=e(r,1),this.blue=e(i,1),this.alpha=e(n,1)};s.fromCartesian4=function(e,i){if(!t(e))throw new r("cartesian is required");return t(i)?(i.red=e.x,i.green=e.y,i.blue=e.z,i.alpha=e.w,i):new s(e.x,e.y,e.z,e.w)},s.fromBytes=function(r,i,n,o,a){return r=s.byteToFloat(e(r,255)),i=s.byteToFloat(e(i,255)),n=s.byteToFloat(e(n,255)),o=s.byteToFloat(e(o,255)),t(a)?(a.red=r,a.green=i,a.blue=n,a.alpha=o,a):new s(r,i,n,o)},s.fromAlpha=function(e,i,n){if(!t(e))throw new r("color is required");if(!t(i))throw new r("alpha is required");return t(n)?(n.red=e.red,n.green=e.green,n.blue=e.blue,n.alpha=i,n):new s(e.red,e.green,e.blue,i)};var u,l,c;i.supportsTypedArrays()&&(u=new ArrayBuffer(4),l=new Uint32Array(u),c=new Uint8Array(u)),s.fromRgba=function(e){return l[0]=e,s.fromBytes(c[0],c[1],c[2],c[3])},s.fromHsl=function(t,r,i,n){t=e(t,0)%1,r=e(r,0),i=e(i,0),n=e(n,1);var o=i,u=i,l=i;if(0!==r){var c;c=.5>i?i*(1+r):i+r-i*r;var h=2*i-c;o=a(h,c,t+1/3),u=a(h,c,t),l=a(h,c,t-1/3)}return new s(o,u,l,n)},s.fromRandom=function(i,n){i=e(i,e.EMPTY_OBJECT);var a=i.red;if(!t(a)){var u=e(i.minimumRed,0),l=e(i.maximumRed,1);if(u>l)throw new r("minimumRed must be less than or equal to maximumRed");a=u+o.nextRandomNumber()*(l-u)}var c=i.green;if(!t(c)){var h=e(i.minimumGreen,0),d=e(i.maximumGreen,1);if(h>d)throw new r("minimumGreen must be less than or equal to maximumGreen");c=h+o.nextRandomNumber()*(d-h)}var m=i.blue;if(!t(m)){var p=e(i.minimumBlue,0),f=e(i.maximumBlue,1);if(p>f)throw new r("minimumBlue must be less than or equal to maximumBlue");m=p+o.nextRandomNumber()*(f-p)}var v=i.alpha;if(!t(v)){var g=e(i.minimumAlpha,0),_=e(i.maximumAlpha,1);if(g>_)throw new r("minimumAlpha must be less than or equal to maximumAlpha");v=g+o.nextRandomNumber()*(_-g)}return t(n)?(n.red=a,n.green=c,n.blue=m,n.alpha=v,n):new s(a,c,m,v)};var h=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,d=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,m=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,p=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;return s.fromCssColorString=function(i){if(!t(i))throw new r("color is required");var n=s[i.toUpperCase()];if(t(n))return s.clone(n);var o=h.exec(i);return null!==o?new s(parseInt(o[1],16)/15,parseInt(o[2],16)/15,parseInt(o[3],16)/15):(o=d.exec(i),null!==o?new s(parseInt(o[1],16)/255,parseInt(o[2],16)/255,parseInt(o[3],16)/255):(o=m.exec(i),null!==o?new s(parseFloat(o[1])/("%"===o[1].substr(-1)?100:255),parseFloat(o[2])/("%"===o[2].substr(-1)?100:255),parseFloat(o[3])/("%"===o[3].substr(-1)?100:255),parseFloat(e(o[4],"1.0"))):(o=p.exec(i),null!==o?s.fromHsl(parseFloat(o[1])/360,parseFloat(o[2])/100,parseFloat(o[3])/100,parseFloat(e(o[4],"1.0"))):void 0)))},s.packedLength=4,s.pack=function(i,n,o){if(!t(i))throw new r("value is required");if(!t(n))throw new r("array is required");o=e(o,0),n[o++]=i.red,n[o++]=i.green,n[o++]=i.blue,n[o]=i.alpha},s.unpack=function(i,n,o){if(!t(i))throw new r("array is required");return n=e(n,0),t(o)||(o=new s),o.red=i[n++],o.green=i[n++],o.blue=i[n++],o.alpha=i[n],o},s.byteToFloat=function(e){return e/255},s.floatToByte=function(e){return 1===e?255:256*e|0},s.clone=function(e,r){return t(e)?t(r)?(r.red=e.red,r.green=e.green,r.blue=e.blue,r.alpha=e.alpha,r):new s(e.red,e.green,e.blue,e.alpha):void 0},s.equals=function(e,r){return e===r||t(e)&&t(r)&&e.red===r.red&&e.green===r.green&&e.blue===r.blue&&e.alpha===r.alpha},s.equalsArray=function(e,t,r){return e.red===t[r]&&e.green===t[r+1]&&e.blue===t[r+2]&&e.alpha===t[r+3]},s.prototype.clone=function(e){return s.clone(this,e)},s.prototype.equals=function(e){return s.equals(this,e)},s.prototype.equalsEpsilon=function(e,r){return this===e||t(e)&&Math.abs(this.red-e.red)<=r&&Math.abs(this.green-e.green)<=r&&Math.abs(this.blue-e.blue)<=r&&Math.abs(this.alpha-e.alpha)<=r},s.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"},s.prototype.toCssColorString=function(){var e=s.floatToByte(this.red),t=s.floatToByte(this.green),r=s.floatToByte(this.blue);return 1===this.alpha?"rgb("+e+","+t+","+r+")":"rgba("+e+","+t+","+r+","+this.alpha+")"},s.prototype.toBytes=function(e){var r=s.floatToByte(this.red),i=s.floatToByte(this.green),n=s.floatToByte(this.blue),o=s.floatToByte(this.alpha);return t(e)?(e[0]=r,e[1]=i,e[2]=n,e[3]=o,e):[r,i,n,o]},s.prototype.toRgba=function(){return c[0]=s.floatToByte(this.red),c[1]=s.floatToByte(this.green),c[2]=s.floatToByte(this.blue),c[3]=s.floatToByte(this.alpha),l[0]},s.prototype.brighten=function(e,i){if(!t(e))throw new r("magnitude is required.");if(0>e)throw new r("magnitude must be positive.");if(!t(i))throw new r("result is required.");return e=1-e,i.red=1-(1-this.red)*e,i.green=1-(1-this.green)*e,i.blue=1-(1-this.blue)*e,i.alpha=this.alpha,i},s.prototype.darken=function(e,i){if(!t(e))throw new r("magnitude is required.");if(0>e)throw new r("magnitude must be positive.");if(!t(i))throw new r("result is required.");return e=1-e,i.red=this.red*e,i.green=this.green*e,i.blue=this.blue*e,i.alpha=this.alpha,i},s.prototype.withAlpha=function(e,t){return s.fromAlpha(this,e,t)},s.ALICEBLUE=n(s.fromCssColorString("#F0F8FF")),s.ANTIQUEWHITE=n(s.fromCssColorString("#FAEBD7")),s.AQUA=n(s.fromCssColorString("#00FFFF")),s.AQUAMARINE=n(s.fromCssColorString("#7FFFD4")),s.AZURE=n(s.fromCssColorString("#F0FFFF")),s.BEIGE=n(s.fromCssColorString("#F5F5DC")),s.BISQUE=n(s.fromCssColorString("#FFE4C4")),s.BLACK=n(s.fromCssColorString("#000000")),s.BLANCHEDALMOND=n(s.fromCssColorString("#FFEBCD")),s.BLUE=n(s.fromCssColorString("#0000FF")),s.BLUEVIOLET=n(s.fromCssColorString("#8A2BE2")),s.BROWN=n(s.fromCssColorString("#A52A2A")),s.BURLYWOOD=n(s.fromCssColorString("#DEB887")),s.CADETBLUE=n(s.fromCssColorString("#5F9EA0")),s.CHARTREUSE=n(s.fromCssColorString("#7FFF00")),s.CHOCOLATE=n(s.fromCssColorString("#D2691E")),s.CORAL=n(s.fromCssColorString("#FF7F50")),s.CORNFLOWERBLUE=n(s.fromCssColorString("#6495ED")),s.CORNSILK=n(s.fromCssColorString("#FFF8DC")),s.CRIMSON=n(s.fromCssColorString("#DC143C")),s.CYAN=n(s.fromCssColorString("#00FFFF")),s.DARKBLUE=n(s.fromCssColorString("#00008B")),s.DARKCYAN=n(s.fromCssColorString("#008B8B")),s.DARKGOLDENROD=n(s.fromCssColorString("#B8860B")),s.DARKGRAY=n(s.fromCssColorString("#A9A9A9")),s.DARKGREEN=n(s.fromCssColorString("#006400")),s.DARKGREY=s.DARKGRAY,s.DARKKHAKI=n(s.fromCssColorString("#BDB76B")),s.DARKMAGENTA=n(s.fromCssColorString("#8B008B")),s.DARKOLIVEGREEN=n(s.fromCssColorString("#556B2F")),s.DARKORANGE=n(s.fromCssColorString("#FF8C00")),s.DARKORCHID=n(s.fromCssColorString("#9932CC")),s.DARKRED=n(s.fromCssColorString("#8B0000")),s.DARKSALMON=n(s.fromCssColorString("#E9967A")),s.DARKSEAGREEN=n(s.fromCssColorString("#8FBC8F")),s.DARKSLATEBLUE=n(s.fromCssColorString("#483D8B")),s.DARKSLATEGRAY=n(s.fromCssColorString("#2F4F4F")),s.DARKSLATEGREY=s.DARKSLATEGRAY,s.DARKTURQUOISE=n(s.fromCssColorString("#00CED1")),s.DARKVIOLET=n(s.fromCssColorString("#9400D3")),s.DEEPPINK=n(s.fromCssColorString("#FF1493")),s.DEEPSKYBLUE=n(s.fromCssColorString("#00BFFF")),s.DIMGRAY=n(s.fromCssColorString("#696969")),s.DIMGREY=s.DIMGRAY,s.DODGERBLUE=n(s.fromCssColorString("#1E90FF")),s.FIREBRICK=n(s.fromCssColorString("#B22222")),s.FLORALWHITE=n(s.fromCssColorString("#FFFAF0")),s.FORESTGREEN=n(s.fromCssColorString("#228B22")),s.FUSCHIA=n(s.fromCssColorString("#FF00FF")),s.GAINSBORO=n(s.fromCssColorString("#DCDCDC")),s.GHOSTWHITE=n(s.fromCssColorString("#F8F8FF")),s.GOLD=n(s.fromCssColorString("#FFD700")),s.GOLDENROD=n(s.fromCssColorString("#DAA520")),s.GRAY=n(s.fromCssColorString("#808080")),s.GREEN=n(s.fromCssColorString("#008000")),s.GREENYELLOW=n(s.fromCssColorString("#ADFF2F")),s.GREY=s.GRAY,s.HONEYDEW=n(s.fromCssColorString("#F0FFF0")),s.HOTPINK=n(s.fromCssColorString("#FF69B4")),s.INDIANRED=n(s.fromCssColorString("#CD5C5C")),s.INDIGO=n(s.fromCssColorString("#4B0082")),s.IVORY=n(s.fromCssColorString("#FFFFF0")),s.KHAKI=n(s.fromCssColorString("#F0E68C")),s.LAVENDER=n(s.fromCssColorString("#E6E6FA")),s.LAVENDAR_BLUSH=n(s.fromCssColorString("#FFF0F5")),s.LAWNGREEN=n(s.fromCssColorString("#7CFC00")),s.LEMONCHIFFON=n(s.fromCssColorString("#FFFACD")),s.LIGHTBLUE=n(s.fromCssColorString("#ADD8E6")),s.LIGHTCORAL=n(s.fromCssColorString("#F08080")),s.LIGHTCYAN=n(s.fromCssColorString("#E0FFFF")),s.LIGHTGOLDENRODYELLOW=n(s.fromCssColorString("#FAFAD2")),s.LIGHTGRAY=n(s.fromCssColorString("#D3D3D3")),s.LIGHTGREEN=n(s.fromCssColorString("#90EE90")),s.LIGHTGREY=s.LIGHTGRAY,s.LIGHTPINK=n(s.fromCssColorString("#FFB6C1")),s.LIGHTSEAGREEN=n(s.fromCssColorString("#20B2AA")),s.LIGHTSKYBLUE=n(s.fromCssColorString("#87CEFA")),s.LIGHTSLATEGRAY=n(s.fromCssColorString("#778899")),s.LIGHTSLATEGREY=s.LIGHTSLATEGRAY,s.LIGHTSTEELBLUE=n(s.fromCssColorString("#B0C4DE")),s.LIGHTYELLOW=n(s.fromCssColorString("#FFFFE0")),s.LIME=n(s.fromCssColorString("#00FF00")),s.LIMEGREEN=n(s.fromCssColorString("#32CD32")),s.LINEN=n(s.fromCssColorString("#FAF0E6")),s.MAGENTA=n(s.fromCssColorString("#FF00FF")),s.MAROON=n(s.fromCssColorString("#800000")),s.MEDIUMAQUAMARINE=n(s.fromCssColorString("#66CDAA")),s.MEDIUMBLUE=n(s.fromCssColorString("#0000CD")),s.MEDIUMORCHID=n(s.fromCssColorString("#BA55D3")),s.MEDIUMPURPLE=n(s.fromCssColorString("#9370DB")),s.MEDIUMSEAGREEN=n(s.fromCssColorString("#3CB371")),s.MEDIUMSLATEBLUE=n(s.fromCssColorString("#7B68EE")),s.MEDIUMSPRINGGREEN=n(s.fromCssColorString("#00FA9A")),s.MEDIUMTURQUOISE=n(s.fromCssColorString("#48D1CC")),s.MEDIUMVIOLETRED=n(s.fromCssColorString("#C71585")),s.MIDNIGHTBLUE=n(s.fromCssColorString("#191970")),s.MINTCREAM=n(s.fromCssColorString("#F5FFFA")),s.MISTYROSE=n(s.fromCssColorString("#FFE4E1")),s.MOCCASIN=n(s.fromCssColorString("#FFE4B5")),s.NAVAJOWHITE=n(s.fromCssColorString("#FFDEAD")),s.NAVY=n(s.fromCssColorString("#000080")),s.OLDLACE=n(s.fromCssColorString("#FDF5E6")),s.OLIVE=n(s.fromCssColorString("#808000")),s.OLIVEDRAB=n(s.fromCssColorString("#6B8E23")),s.ORANGE=n(s.fromCssColorString("#FFA500")),s.ORANGERED=n(s.fromCssColorString("#FF4500")),s.ORCHID=n(s.fromCssColorString("#DA70D6")),s.PALEGOLDENROD=n(s.fromCssColorString("#EEE8AA")),s.PALEGREEN=n(s.fromCssColorString("#98FB98")),s.PALETURQUOISE=n(s.fromCssColorString("#AFEEEE")),s.PALEVIOLETRED=n(s.fromCssColorString("#DB7093")),s.PAPAYAWHIP=n(s.fromCssColorString("#FFEFD5")),s.PEACHPUFF=n(s.fromCssColorString("#FFDAB9")),s.PERU=n(s.fromCssColorString("#CD853F")),s.PINK=n(s.fromCssColorString("#FFC0CB")),s.PLUM=n(s.fromCssColorString("#DDA0DD")),s.POWDERBLUE=n(s.fromCssColorString("#B0E0E6")),s.PURPLE=n(s.fromCssColorString("#800080")),s.RED=n(s.fromCssColorString("#FF0000")),s.ROSYBROWN=n(s.fromCssColorString("#BC8F8F")),s.ROYALBLUE=n(s.fromCssColorString("#4169E1")),s.SADDLEBROWN=n(s.fromCssColorString("#8B4513")),s.SALMON=n(s.fromCssColorString("#FA8072")),s.SANDYBROWN=n(s.fromCssColorString("#F4A460")),s.SEAGREEN=n(s.fromCssColorString("#2E8B57")),s.SEASHELL=n(s.fromCssColorString("#FFF5EE")),s.SIENNA=n(s.fromCssColorString("#A0522D")),s.SILVER=n(s.fromCssColorString("#C0C0C0")),s.SKYBLUE=n(s.fromCssColorString("#87CEEB")),s.SLATEBLUE=n(s.fromCssColorString("#6A5ACD")),s.SLATEGRAY=n(s.fromCssColorString("#708090")),s.SLATEGREY=s.SLATEGRAY,s.SNOW=n(s.fromCssColorString("#FFFAFA")),s.SPRINGGREEN=n(s.fromCssColorString("#00FF7F")),s.STEELBLUE=n(s.fromCssColorString("#4682B4")),s.TAN=n(s.fromCssColorString("#D2B48C")),s.TEAL=n(s.fromCssColorString("#008080")),s.THISTLE=n(s.fromCssColorString("#D8BFD8")),s.TOMATO=n(s.fromCssColorString("#FF6347")),s.TURQUOISE=n(s.fromCssColorString("#40E0D0")),s.VIOLET=n(s.fromCssColorString("#EE82EE")),s.WHEAT=n(s.fromCssColorString("#F5DEB3")),s.WHITE=n(s.fromCssColorString("#FFFFFF")),s.WHITESMOKE=n(s.fromCssColorString("#F5F5F5")),s.YELLOW=n(s.fromCssColorString("#FFFF00")),s.YELLOWGREEN=n(s.fromCssColorString("#9ACD32")),s.TRANSPARENT=n(new s(0,0,0,0)),s}),r("Core/ColorGeometryInstanceAttribute",["./Color","./ComponentDatatype","./defaultValue","./defined","./defineProperties","./DeveloperError"],function(e,t,r,i,n,o){"use strict";var a=function(t,i,n,o){t=r(t,1),i=r(i,1),n=r(n,1),o=r(o,1),this.value=new Uint8Array([e.floatToByte(t),e.floatToByte(i),e.floatToByte(n),e.floatToByte(o)])};return n(a.prototype,{componentDatatype:{get:function(){return t.UNSIGNED_BYTE}},componentsPerAttribute:{get:function(){return 4}},normalize:{get:function(){return!0}}}),a.fromColor=function(e){if(!i(e))throw new o("color is required.");return new a(e.red,e.green,e.blue,e.alpha)},a.toValue=function(e,t){if(!i(e))throw new o("color is required.");return i(t)?e.toBytes(t):new Uint8Array(e.toBytes())},a}),r("Core/combine",["./defaultValue","./defined"],function(e,t){"use strict";var r=function(i,n,o){o=e(o,!1);var a,s,u,l={},c=t(i),h=t(n);if(c)for(a in i)i.hasOwnProperty(a)&&(s=i[a],h&&o&&"object"==typeof s&&n.hasOwnProperty(a)?(u=n[a],"object"==typeof u?l[a]=r(s,u,o):l[a]=s):l[a]=s);if(h)for(a in n)n.hasOwnProperty(a)&&!l.hasOwnProperty(a)&&(u=n[a],l[a]=u);return l};return r}),r("Core/CornerType",["./freezeObject"],function(e){"use strict";var t={ROUNDED:0,MITERED:1,BEVELED:2};return e(t)}),r("Core/isArray",["./defined"],function(e){"use strict";var t=Array.isArray;return e(t)||(t=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),t}),r("Core/EllipsoidGeodesic",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,t,r,i,n,o,a,s){"use strict";function u(e){var t=e._uSquared,r=e._ellipsoid.maximumRadius,i=e._ellipsoid.minimumRadius,n=(r-i)/r,o=Math.cos(e._startHeading),a=Math.sin(e._startHeading),s=(1-n)*Math.tan(e._start.latitude),u=1/Math.sqrt(1+s*s),l=u*s,c=Math.atan2(s,o),h=u*a,d=h*h,m=1-d,p=Math.sqrt(m),f=t/4,v=f*f,g=v*f,_=v*v,y=1+f-3*v/4+5*g/4-175*_/64,w=1-f+15*v/8-35*g/8,C=1-3*f+35*v/4,E=1-5*f,S=y*c-w*Math.sin(2*c)*f/2-C*Math.sin(4*c)*v/16-E*Math.sin(6*c)*g/48-5*Math.sin(8*c)*_/512,b=e._constants;b.a=r,b.b=i,b.f=n,b.cosineHeading=o,b.sineHeading=a,b.tanU=s,b.cosineU=u,b.sineU=l,b.sigma=c,b.sineAlpha=h,b.sineSquaredAlpha=d,b.cosineSquaredAlpha=m,b.cosineAlpha=p,b.u2Over4=f,b.u4Over16=v,b.u6Over64=g,b.u8Over256=_,b.a0=y,b.a1=w,b.a2=C,b.a3=E,b.distanceRatio=S}function l(e,t){return e*t*(4+e*(4-3*t))/16}function c(e,t,r,i,n,o,a){var s=l(e,r);return(1-s)*e*t*(i+s*n*(a+s*o*(2*a*a-1)))}function h(e,t,r,i,n,o,a){var u,l,h,d,m,p=(t-r)/t,f=o-i,v=Math.atan((1-p)*Math.tan(n)),g=Math.atan((1-p)*Math.tan(a)),_=Math.cos(v),y=Math.sin(v),w=Math.cos(g),C=Math.sin(g),E=_*w,S=_*C,b=y*C,T=y*w,x=f,P=s.TWO_PI,A=Math.cos(x),I=Math.sin(x);do{A=Math.cos(x),I=Math.sin(x);var D=S-T*A;h=Math.sqrt(w*w*I*I+D*D),l=b+E*A,u=Math.atan2(h,l);var M;0===h?(M=0,d=1):(M=E*I/h,d=1-M*M),P=x,m=l-2*b/d,isNaN(m)&&(m=0),x=f+c(p,M,d,u,h,l,m)}while(Math.abs(x-P)>s.EPSILON12);var R=d*(t*t-r*r)/(r*r),O=1+R*(4096+R*(R*(320-175*R)-768))/16384,N=R*(256+R*(R*(74-47*R)-128))/1024,L=m*m,F=N*h*(m+N*(l*(2*L-1)-N*m*(4*h*h-3)*(4*L-3)/6)/4),B=r*O*(u-F),z=Math.atan2(w*I,S-T*A),V=Math.atan2(_*I,S*A-T);e._distance=B,e._startHeading=z,e._endHeading=V,e._uSquared=R}function d(r,i,n,a){var s=e.normalize(a.cartographicToCartesian(i,p),m),l=e.normalize(a.cartographicToCartesian(n,p),p);if(Math.abs(Math.abs(e.angleBetween(s,l))-Math.PI)<.0125)throw new o("geodesic position is not unique");h(r,a.maximumRadius,a.minimumRadius,i.longitude,i.latitude,n.longitude,n.latitude),r._start=t.clone(i,r._start),r._end=t.clone(n,r._end),r._start.height=0,r._end.height=0,u(r)}var m=new e,p=new e,f=function(e,n,o){var s=r(o,a.WGS84);this._ellipsoid=s,this._start=new t,this._end=new t,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,i(e)&&i(n)&&d(this,e,n,s)};return n(f.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){if(!i(this._distance))throw new o("set end positions before getting surfaceDistance");return this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){if(!i(this._distance))throw new o("set end positions before getting startHeading");return this._startHeading}},endHeading:{get:function(){if(!i(this._distance))throw new o("set end positions before getting endHeading");return this._endHeading}}}),f.prototype.setEndPoints=function(e,t){if(!i(e))throw new o("start cartographic position is required");if(!i(t))throw new o("end cartgraphic position is required");d(this,e,t,this._ellipsoid)},f.prototype.interpolateUsingFraction=function(e,t){return this.interpolateUsingSurfaceDistance(this._distance*e,t)},f.prototype.interpolateUsingSurfaceDistance=function(e,r){if(!i(this._distance))throw new o("start and end must be set before calling funciton interpolateUsingSurfaceDistance");var n=this._constants,a=n.distanceRatio+e/n.b,s=Math.cos(2*a),u=Math.cos(4*a),l=Math.cos(6*a),h=Math.sin(2*a),d=Math.sin(4*a),m=Math.sin(6*a),p=Math.sin(8*a),f=a*a,v=a*f,g=n.u8Over256,_=n.u2Over4,y=n.u6Over64,w=n.u4Over16,C=2*v*g*s/3+a*(1-_+7*w/4-15*y/4+579*g/64-(w-15*y/4+187*g/16)*s-(5*y/4-115*g/16)*u-29*g*l/16)+(_/2-w+71*y/32-85*g/16)*h+(5*w/16-5*y/4+383*g/96)*d-f*((y-11*g/2)*h+5*g*d/2)+(29*y/96-29*g/16)*m+539*g*p/1536,E=Math.asin(Math.sin(C)*n.cosineAlpha),S=Math.atan(n.a/n.b*Math.tan(E));C-=n.sigma;var b=Math.cos(2*n.sigma+C),T=Math.sin(C),x=Math.cos(C),P=n.cosineU*x,A=n.sineU*T,I=Math.atan2(T*n.sineHeading,P-A*n.cosineHeading),D=I-c(n.f,n.sineAlpha,n.cosineSquaredAlpha,C,T,x,b);return i(r)?(r.longitude=this._start.longitude+D,r.latitude=S,r.height=0,r):new t(this._start.longitude+D,S,0)},f}),r("Core/PolylinePipeline",["./Cartesian3","./Cartographic","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidGeodesic","./IntersectionTests","./isArray","./Math","./Matrix4","./Plane"],function(e,t,r,i,n,o,a,s,u,l,c,h){"use strict";function d(e,t,r){var i=b;i.length=e;var n;if(t===r){for(n=0;e>n;n++)i[n]=t;return i}var o=r-t,a=o/e;for(n=0;e>n;n++){var s=t+n*a;i[n]=s}return i}function m(t,r,i,n,o,a,s,u){var l=n.scaleToGeodeticSurface(t,A),c=n.scaleToGeodeticSurface(r,I),h=p.numberOfPoints(t,r,i),m=n.cartesianToCartographic(l,T),f=n.cartesianToCartographic(c,x),v=d(h,o,a);D.setEndPoints(m,f);var g=D.surfaceDistance/h,_=u;m.height=o;var y=n.cartographicToCartesian(m,P);e.pack(y,s,_),_+=3;for(var w=1;h>w;w++){var C=D.interpolateUsingSurfaceDistance(w*g,x);C.height=v[w],y=n.cartographicToCartesian(C,P),e.pack(y,s,_),_+=3}return _}var p={};p.numberOfPoints=function(t,r,i){var n=e.distance(t,r);return Math.ceil(n/i)};var f=new t;p.extractHeights=function(e,t){for(var r=e.length,i=new Array(r),n=0;r>n;n++){var o=e[n];i[n]=t.cartesianToCartographic(o,f).height}return i};var v=new c,g=new e,_=new e,y=new h(e.ZERO,0),w=new e,C=new h(e.ZERO,0),E=new e,S=new e,b=[],T=new t,x=new t,P=new e,A=new e,I=new e,D=new a;p.wrapLongitude=function(t,n){var o=[],a=[];if(i(t)&&t.length>0){n=r(n,c.IDENTITY);var u=c.inverseTransformation(n,v),l=c.multiplyByPoint(u,e.ZERO,g),d=c.multiplyByPointAsVector(u,e.UNIT_Y,_),m=h.fromPointNormal(l,d,y),p=c.multiplyByPointAsVector(u,e.UNIT_X,w),f=h.fromPointNormal(l,p,C),b=1;o.push(e.clone(t[0]));for(var T=o[0],x=t.length,P=1;x>P;++P){var A=t[P];if(h.getPointDistance(f,T)<0||h.getPointDistance(f,A)<0){var I=s.lineSegmentPlane(T,A,m,E);if(i(I)){var D=e.multiplyByScalar(d,5e-9,S);h.getPointDistance(m,T)<0&&e.negate(D,D),o.push(e.add(I,D,new e)),a.push(b+1),e.negate(D,D),o.push(e.add(I,D,new e)),b=1}}o.push(e.clone(t[P])),b++,T=A}a.push(b)}return{positions:o,lengths:a}};var M=l.EPSILON7;return p.removeDuplicates=function(t){if(!i(t))throw new n("positions is required.");var r=t.length;if(2>r)return t;var o,a,s;for(o=1;r>o&&(a=t[o-1],s=t[o],!e.equalsEpsilon(a,s,M));++o);if(o===r)return t;for(var u=t.slice(0,o);r>o;++o)s=t[o],e.equalsEpsilon(a,s,M)||(u.push(e.clone(s)),a=s);return u},p.generateArc=function(t){i(t)||(t={});var a=t.positions;if(!i(a))throw new n("options.positions is required.");var s=a.length,c=r(t.ellipsoid,o.WGS84),h=r(t.height,0);if(1>s)return[];if(1===s){var d=c.scaleToGeodeticSurface(a[0],A);if(0!==h){var f=c.geodeticSurfaceNormal(d,P);e.multiplyByScalar(f,h,f),e.add(d,f,d)}return[d.x,d.y,d.z]}var v=t.minDistance;if(!i(v)){var g=r(t.granularity,l.RADIANS_PER_DEGREE);v=l.chordLength(g,c.maximumRadius)}var _,y=0;for(_=0;s-1>_;_++)y+=p.numberOfPoints(a[_],a[_+1],v);var w=3*(y+1),C=new Array(w),E=0,S=u(h);for(_=0;s-1>_;_++){var x=a[_],I=a[_+1],D=S?h[_]:h,M=S?h[_+1]:h;E=m(x,I,v,c,D,M,C,E)}b.length=0;var R=a[s-1],O=c.cartesianToCartographic(R,T);O.height=S?h[s-1]:h;var N=c.cartographicToCartesian(O,P);return e.pack(N,C,w-3),C},p.generateCartesianArc=function(t){for(var r=p.generateArc(t),i=r.length/3,n=new Array(i),o=0;i>o;o++)n[o]=e.unpack(r,3*o);return n},p}),r("Core/PolylineVolumeGeometryLibrary",["./Cartesian2","./Cartesian3","./Cartesian4","./Cartographic","./CornerType","./EllipsoidTangentPlane","./Math","./Matrix3","./Matrix4","./PolylinePipeline","./Quaternion","./Transforms"],function(e,t,r,i,n,o,a,s,u,l,c,h){"use strict";function d(e,t){for(var r=new Array(e.length),i=0;i<e.length;i++){var n=e[i];N=t.cartesianToCartographic(n,N),r[i]=N.height,e[i]=t.scaleToGeodeticSurface(n,n)}return r}function m(e,r,i,n){var o,a=e[0],s=e[1],u=t.angleBetween(a,s),l=Math.ceil(u/n),c=new Array(l);if(r===i){for(o=0;l>o;o++)c[o]=r;return c.push(i),c}var h=i-r,d=h/l;for(o=1;l>o;o++){var m=r+o*d;c[o]=m}return c[0]=r,c.push(i),c}function p(r,i,n,a){var s=new o(n,a),u=s.projectPointOntoPlane(t.add(n,r,Y),Y),l=s.projectPointOntoPlane(t.add(n,i,X),X),c=e.angleBetween(u,l);return l.x*u.y-l.y*u.x>=0?-c:c}function f(e,r,i,n,o,a,l,c){var d=k,m=U;F=h.eastNorthUpToFixedFrame(e,o,F),d=u.multiplyByPointAsVector(F,L,d),d=t.normalize(d,d);var f=p(d,r,e,o);z=s.fromRotationZ(f,z),q.z=a,F=u.multiplyTransformation(F,u.fromRotationTranslation(z,q,B),F);var v=V;v[0]=l;for(var g=0;c>g;g++)for(var _=0;_<i.length;_+=3)m=t.fromArray(i,_,m),m=s.multiplyByVector(v,m,m),m=u.multiplyByPoint(F,m,m),n.push(m.x,m.y,m.z);return n}function v(e,r,i,n,o,a,s){for(var u=0;u<e.length;u+=3){var l=t.fromArray(e,u,G);n=f(l,r,i,n,o,a[u/3],s,1)}return n}function g(e,t){var r=e.length,i=new Array(6*r),n=0,o=t.x+t.width/2,a=t.y+t.height/2,s=e[0];i[n++]=s.x-o,i[n++]=0,i[n++]=s.y-a;for(var u=1;r>u;u++){s=e[u];var l=s.x-o,c=s.y-a;i[n++]=l,i[n++]=0,i[n++]=c,i[n++]=l,i[n++]=0,i[n++]=c}return s=e[0],i[n++]=s.x-o,i[n++]=0,i[n++]=s.y-a,i}function _(e,t){for(var r=e.length,i=new Array(3*r),n=0,o=t.x+t.width/2,a=t.y+t.height/2,s=0;r>s;s++)i[n++]=e[s].x-o,i[n++]=0,i[n++]=e[s].y-a;return i}function y(e,r,i,o,u,l,h,d,m,p){var v,g=t.angleBetween(t.subtract(r,e,M),t.subtract(i,e,R)),_=o===n.BEVELED?0:Math.ceil(g/a.toRadians(5));v=u?s.fromQuaternion(c.fromAxisAngle(t.negate(e,M),g/(_+1),W),j):s.fromQuaternion(c.fromAxisAngle(e,g/(_+1),W),j);var y,w;if(r=t.clone(r,H),_>0)for(var C=p?2:1,E=0;_>E;E++)r=s.multiplyByVector(v,r,r),y=t.subtract(r,e,M),y=t.normalize(y,y),u||(y=t.negate(y,y)),w=l.scaleToGeodeticSurface(r,R),h=f(w,y,d,h,l,m,1,C);else y=t.subtract(r,e,M),y=t.normalize(y,y),u||(y=t.negate(y,y)),w=l.scaleToGeodeticSurface(r,R),h=f(w,y,d,h,l,m,1,1),i=t.clone(i,H),y=t.subtract(i,e,M),y=t.normalize(y,y),u||(y=t.negate(y,y)),w=l.scaleToGeodeticSurface(i,R),h=f(w,y,d,h,l,m,1,1);return h}function w(e,t){return a.equalsEpsilon(e.latitude,t.latitude,a.EPSILON6)&&a.equalsEpsilon(e.longitude,t.longitude,a.EPSILON6)}var C=[new t,new t],E=new t,S=new t,b=new t,T=new t,x=new t,P=new t,A=new t,I=new t,D=new t,M=new t,R=new t,O={},N=new i,L=new t(-1,0,0),F=new u,B=new u,z=new s,V=s.IDENTITY.clone(),k=new t,U=new r,q=new t,G=new t,W=new c,H=new t,j=new s;O.removeDuplicatesFromShape=function(t){for(var r=t.length,i=[],n=r-1,o=0;r>o;n=o++){var a=t[n],s=t[o];e.equals(a,s)||i.push(s)}return i};var Y=new t,X=new t;O.angleIsGreaterThanPi=function(e,r,i,n){var a=new o(i,n),s=a.projectPointOntoPlane(t.add(i,e,Y),Y),u=a.projectPointOntoPlane(t.add(i,r,X),X);return u.x*s.y-u.y*s.x>=0};var Z=new i,K=new i;O.removeDuplicatesFromPositions=function(e,t){var r=e.length;if(2>r)return e.slice(0);var i=[];i.push(e[0]);for(var n=1;r>n;++n){var o=e[n-1],a=e[n],s=t.cartesianToCartographic(o,Z),u=t.cartesianToCartographic(a,K);w(s,u)||i.push(a)}return i};var Q=new t,J=new t;return O.computePositions=function(e,r,i,o,s){var u=o._ellipsoid,c=d(e,u),h=o._granularity,p=o._cornerType,w=s?g(r,i):_(r,i),R=s?_(r,i):void 0,N=i.height/2,L=i.width/2,F=e.length,B=[],z=s?[]:void 0,V=E,k=S,U=b,q=T,G=x,W=P,H=A,j=I,Y=D,X=e[0],Z=e[1];q=u.geodeticSurfaceNormal(X,q),V=t.subtract(Z,X,V),V=t.normalize(V,V),j=t.cross(q,V,j),j=t.normalize(j,j);var K=c[0],$=c[1];s&&(z=f(X,j,R,z,u,K+N,1,1)),Y=t.clone(X,Y),X=Z,k=t.negate(V,k);for(var ee,te,re=1;F-1>re;re++){var ie=s?2:1;Z=e[re+1],V=t.subtract(Z,X,V),V=t.normalize(V,V),U=t.add(V,k,U),U=t.normalize(U,U),q=u.geodeticSurfaceNormal(X,q);var ne=t.multiplyByScalar(q,t.dot(V,q),Q);t.subtract(V,ne,ne),t.normalize(ne,ne);var oe=t.multiplyByScalar(q,t.dot(k,q),J);t.subtract(k,oe,oe),t.normalize(oe,oe);var ae=!a.equalsEpsilon(Math.abs(t.dot(ne,oe)),1,a.EPSILON7);if(ae){U=t.cross(U,q,U),U=t.cross(q,U,U),U=t.normalize(U,U);var se=1/Math.max(.25,t.magnitude(t.cross(U,k,M))),ue=O.angleIsGreaterThanPi(V,k,X,u);ue?(G=t.add(X,t.multiplyByScalar(U,se*L,U),G),W=t.add(G,t.multiplyByScalar(j,L,W),W),C[0]=t.clone(Y,C[0]),C[1]=t.clone(W,C[1]),ee=m(C,K+N,$+N,h),te=l.generateArc({positions:C,granularity:h,ellipsoid:u}),B=v(te,j,w,B,u,ee,1),j=t.cross(q,V,j),j=t.normalize(j,j),H=t.add(G,t.multiplyByScalar(j,L,H),H),p===n.ROUNDED||p===n.BEVELED?y(G,W,H,p,ue,u,B,w,$+N,s):(U=t.negate(U,U),B=f(X,U,w,B,u,$+N,se,ie)),Y=t.clone(H,Y)):(G=t.add(X,t.multiplyByScalar(U,se*L,U),G),W=t.add(G,t.multiplyByScalar(j,-L,W),W),C[0]=t.clone(Y,C[0]),C[1]=t.clone(W,C[1]),ee=m(C,K+N,$+N,h),te=l.generateArc({positions:C,granularity:h,ellipsoid:u}),B=v(te,j,w,B,u,ee,1),j=t.cross(q,V,j),j=t.normalize(j,j),H=t.add(G,t.multiplyByScalar(j,-L,H),H),p===n.ROUNDED||p===n.BEVELED?y(G,W,H,p,ue,u,B,w,$+N,s):B=f(X,U,w,B,u,$+N,se,ie),Y=t.clone(H,Y)),k=t.negate(V,k)}else B=f(Y,j,w,B,u,K+N,1,1),Y=X;K=$,$=c[re+1],X=Z}C[0]=t.clone(Y,C[0]),C[1]=t.clone(X,C[1]),ee=m(C,K+N,$+N,h),te=l.generateArc({positions:C,granularity:h,ellipsoid:u}),B=v(te,j,w,B,u,ee,1),s&&(z=f(X,j,R,z,u,$+N,1,1)),F=B.length;var le=s?F+z.length:F,ce=new Float64Array(le);return ce.set(B),s&&ce.set(z,F),ce},O}),r("Core/CorridorGeometryLibrary",["./Cartesian3","./CornerType","./defined","./isArray","./Math","./Matrix3","./PolylinePipeline","./PolylineVolumeGeometryLibrary","./Quaternion"],function(e,t,r,i,n,o,a,s,u){"use strict";function l(r,i,a,s,l){var c=e.angleBetween(e.subtract(i,r,f),e.subtract(a,r,v)),h=s===t.BEVELED?1:Math.ceil(c/n.toRadians(5))+1,d=3*h,m=new Array(d);m[d-3]=a.x,m[d-2]=a.y,m[d-1]=a.z;var p;p=l?o.fromQuaternion(u.fromAxisAngle(e.negate(r,f),c/h,D),M):o.fromQuaternion(u.fromAxisAngle(r,c/h,D),M);var g=0;i=e.clone(i,f);for(var _=0;h>_;_++)i=o.multiplyByVector(p,i,i),m[g++]=i.x,m[g++]=i.y,m[g++]=i.z;return m}function c(r){var i=w,n=C,o=E,a=r[1];n=e.fromArray(r[1],a.length-3,n),o=e.fromArray(r[0],0,o),i=e.multiplyByScalar(e.add(n,o,i),.5,i);var s=l(i,n,o,t.ROUNDED,!1),u=r.length-1,c=r[u-1];a=r[u],n=e.fromArray(c,c.length-3,n),o=e.fromArray(a,0,o),i=e.multiplyByScalar(e.add(n,o,i),.5,i);var h=l(i,n,o,t.ROUNDED,!1);return[s,h]}function h(t,r,i,n){var o=f;return n?o=e.add(t,r,o):(r=e.negate(r,r),o=e.add(t,r,o)),[o.x,o.y,o.z,i.x,i.y,i.z]}function d(t,r,i,n){for(var o=new Array(t.length),a=new Array(t.length),s=e.multiplyByScalar(r,i,f),u=e.negate(s,v),l=0,c=t.length-1,h=0;h<t.length;h+=3){var d=e.fromArray(t,h,g),m=e.add(d,u,_);o[l++]=m.x,o[l++]=m.y,o[l++]=m.z;var p=e.add(d,s,_);a[c--]=p.z,a[c--]=p.y,a[c--]=p.x}return n.push(o,a),n}function m(e,t){for(var r=0;r<e.length;r++)e[r]=t.scaleToGeodeticSurface(e[r],e[r]);return e}var p={},f=new e,v=new e,g=new e,_=new e,y=[new e,new e],w=new e,C=new e,E=new e,S=new e,b=new e,T=new e,x=new e,P=new e,A=new e,I=new e,D=new u,M=new o;p.addAttribute=function(e,t,i,n){var o=t.x,a=t.y,s=t.z;r(i)&&(e[i]=o,e[i+1]=a,e[i+2]=s),r(n)&&(e[n]=s,e[n-1]=a,e[n-2]=o)};var R=new e,O=new e;p.computePositions=function(r){var i=r.granularity,o=r.positions,u=r.ellipsoid;o=m(o,u);var p=r.width/2,v=r.cornerType,g=r.saveAttributes,_=w,D=C,M=E,N=S,L=b,F=T,B=x,z=P,V=A,k=I,U=[],q=g?[]:void 0,G=g?[]:void 0,W=o[0],H=o[1];D=e.normalize(e.subtract(H,W,D),D),_=u.geodeticSurfaceNormal(W,_),N=e.normalize(e.cross(_,D,N),N),g&&(q.push(N.x,N.y,N.z),G.push(_.x,_.y,_.z)),B=e.clone(W,B),W=H,M=e.negate(D,M);var j,Y,X=[],Z=o.length;for(Y=1;Z-1>Y;Y++){_=u.geodeticSurfaceNormal(W,_),H=o[Y+1],D=e.normalize(e.subtract(H,W,D),D),L=e.normalize(e.add(D,M,L),L);var K=e.multiplyByScalar(_,e.dot(D,_),R);e.subtract(D,K,K),e.normalize(K,K);var Q=e.multiplyByScalar(_,e.dot(M,_),O);e.subtract(M,Q,Q),e.normalize(Q,Q);var J=!n.equalsEpsilon(Math.abs(e.dot(K,Q)),1,n.EPSILON7);if(J){L=e.cross(L,_,L),L=e.cross(_,L,L);var $=p/Math.max(.25,e.magnitude(e.cross(L,M,f))),ee=s.angleIsGreaterThanPi(D,M,W,u);L=e.multiplyByScalar(L,$,L),ee?(z=e.add(W,L,z),k=e.add(z,e.multiplyByScalar(N,p,k),k),V=e.add(z,e.multiplyByScalar(N,2*p,V),V),y[0]=e.clone(B,y[0]),y[1]=e.clone(k,y[1]),j=a.generateArc({positions:y,granularity:i,ellipsoid:u}),U=d(j,N,p,U),g&&(q.push(N.x,N.y,N.z),G.push(_.x,_.y,_.z)),F=e.clone(V,F),N=e.normalize(e.cross(_,D,N),N),V=e.add(z,e.multiplyByScalar(N,2*p,V),V),
B=e.add(z,e.multiplyByScalar(N,p,B),B),v===t.ROUNDED||v===t.BEVELED?X.push({leftPositions:l(z,F,V,v,ee)}):X.push({leftPositions:h(W,e.negate(L,L),V,ee)})):(V=e.add(W,L,V),k=e.add(V,e.negate(e.multiplyByScalar(N,p,k),k),k),z=e.add(V,e.negate(e.multiplyByScalar(N,2*p,z),z),z),y[0]=e.clone(B,y[0]),y[1]=e.clone(k,y[1]),j=a.generateArc({positions:y,granularity:i,ellipsoid:u}),U=d(j,N,p,U),g&&(q.push(N.x,N.y,N.z),G.push(_.x,_.y,_.z)),F=e.clone(z,F),N=e.normalize(e.cross(_,D,N),N),z=e.add(V,e.negate(e.multiplyByScalar(N,2*p,z),z),z),B=e.add(V,e.negate(e.multiplyByScalar(N,p,B),B),B),v===t.ROUNDED||v===t.BEVELED?X.push({rightPositions:l(V,F,z,v,ee)}):X.push({rightPositions:h(W,L,z,ee)})),M=e.negate(D,M)}W=H}_=u.geodeticSurfaceNormal(W,_),y[0]=e.clone(B,y[0]),y[1]=e.clone(W,y[1]),j=a.generateArc({positions:y,granularity:i,ellipsoid:u}),U=d(j,N,p,U),g&&(q.push(N.x,N.y,N.z),G.push(_.x,_.y,_.z));var te;return v===t.ROUNDED&&(te=c(U)),{positions:U,corners:X,lefts:q,normals:G,endPositions:te}};var N=new e,L=new e;return p.scaleToGeodeticHeight=function(t,r,n,o){var a=t.length,s=i(o)?o:new Array(t.length);s.length=t.length;for(var u=r,l=0;a>l;l+=3){var c=n.scaleToGeodeticSurface(e.fromArray(t,l,L),L),h=N;0!==r&&(h=n.geodeticSurfaceNormal(c,h),h=e.multiplyByScalar(h,u,h),c=e.add(c,h,c)),s[l]=c.x,s[l+1]=c.y,s[l+2]=c.z}return s},p}),r("Core/CorridorGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./CornerType","./CorridorGeometryLibrary","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PolylinePipeline","./PrimitiveType","./VertexFormat"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f,v){"use strict";function g(e,r,i,o,a,s){var u=e.normals,l=e.tangents,c=e.binormals,h=t.normalize(t.cross(i,r,A),A);s.normal&&n.addAttribute(u,r,o,a),s.binormal&&n.addAttribute(c,i,o,a),s.tangent&&n.addAttribute(l,h,o,a)}function _(e,i,o){var s,u,l,p=e.positions,f=e.corners,v=e.endPositions,_=e.lefts,y=e.normals,w=new h,C=0,x=0,D=0;for(u=0;u<p.length;u+=2)l=p[u].length-3,C+=l,D+=2*l,x+=p[u+1].length-3;for(C+=3,x+=3,u=0;u<f.length;u++){s=f[u];var M=f[u].leftPositions;a(M)?(l=M.length,C+=l,D+=l):(l=f[u].rightPositions.length,x+=l,D+=l)}var R,O=a(v);O&&(R=v[0].length-3,C+=R,x+=R,R/=3,D+=6*R);var N,L,F,B,z,V,k=C+x,U=new Float64Array(k),q=i.normal?new Float32Array(k):void 0,G=i.tangent?new Float32Array(k):void 0,W=i.binormal?new Float32Array(k):void 0,H={normals:q,tangents:G,binormals:W},j=0,Y=k-1,X=E,Z=S,K=R/2,Q=d.createTypedArray(k/3,D),J=0;if(O){V=b,z=T;var $=v[0];for(X=t.fromArray(y,0,X),Z=t.fromArray(_,0,Z),u=0;K>u;u++)V=t.fromArray($,3*(K-1-u),V),z=t.fromArray($,3*(K+u),z),n.addAttribute(U,z,j),n.addAttribute(U,V,void 0,Y),g(H,X,Z,j,Y,i),L=j/3,B=L+1,N=(Y-2)/3,F=N-1,Q[J++]=N,Q[J++]=L,Q[J++]=F,Q[J++]=F,Q[J++]=L,Q[J++]=B,j+=3,Y-=3}var ee=0,te=0,re=p[ee++],ie=p[ee++];U.set(re,j),U.set(ie,Y-ie.length+1),Z=t.fromArray(_,te,Z);var ne,oe;for(l=ie.length-3,u=0;l>u;u+=3)ne=o.geodeticSurfaceNormal(t.fromArray(re,u,A),A),oe=o.geodeticSurfaceNormal(t.fromArray(ie,l-u,I),I),X=t.normalize(t.add(ne,oe,X),X),g(H,X,Z,j,Y,i),L=j/3,B=L+1,N=(Y-2)/3,F=N-1,Q[J++]=N,Q[J++]=L,Q[J++]=F,Q[J++]=F,Q[J++]=L,Q[J++]=B,j+=3,Y-=3;for(ne=o.geodeticSurfaceNormal(t.fromArray(re,l,A),A),oe=o.geodeticSurfaceNormal(t.fromArray(ie,l,I),I),X=t.normalize(t.add(ne,oe,X),X),te+=3,u=0;u<f.length;u++){var ae;s=f[u];var se,ue,le=s.leftPositions,ce=s.rightPositions,he=P,de=b,me=T;if(X=t.fromArray(y,te,X),a(le)){for(g(H,X,Z,void 0,Y,i),Y-=3,se=B,ue=F,ae=0;ae<le.length/3;ae++)he=t.fromArray(le,3*ae,he),Q[J++]=se,Q[J++]=ue-ae-1,Q[J++]=ue-ae,n.addAttribute(U,he,void 0,Y),de=t.fromArray(U,3*(ue-ae-1),de),me=t.fromArray(U,3*se,me),Z=t.normalize(t.subtract(de,me,Z),Z),g(H,X,Z,void 0,Y,i),Y-=3;he=t.fromArray(U,3*se,he),de=t.subtract(t.fromArray(U,3*ue,de),he,de),me=t.subtract(t.fromArray(U,3*(ue-ae),me),he,me),Z=t.normalize(t.add(de,me,Z),Z),g(H,X,Z,j,void 0,i),j+=3}else{for(g(H,X,Z,j,void 0,i),j+=3,se=F,ue=B,ae=0;ae<ce.length/3;ae++)he=t.fromArray(ce,3*ae,he),Q[J++]=se,Q[J++]=ue+ae,Q[J++]=ue+ae+1,n.addAttribute(U,he,j),de=t.fromArray(U,3*se,de),me=t.fromArray(U,3*(ue+ae),me),Z=t.normalize(t.subtract(de,me,Z),Z),g(H,X,Z,j,void 0,i),j+=3;he=t.fromArray(U,3*se,he),de=t.subtract(t.fromArray(U,3*(ue+ae),de),he,de),me=t.subtract(t.fromArray(U,3*ue,me),he,me),Z=t.normalize(t.negate(t.add(me,de,Z),Z),Z),g(H,X,Z,void 0,Y,i),Y-=3}for(re=p[ee++],ie=p[ee++],re.splice(0,3),ie.splice(ie.length-3,3),U.set(re,j),U.set(ie,Y-ie.length+1),l=ie.length-3,te+=3,Z=t.fromArray(_,te,Z),ae=0;ae<ie.length;ae+=3)ne=o.geodeticSurfaceNormal(t.fromArray(re,ae,A),A),oe=o.geodeticSurfaceNormal(t.fromArray(ie,l-ae,I),I),X=t.normalize(t.add(ne,oe,X),X),g(H,X,Z,j,Y,i),B=j/3,L=B-1,F=(Y-2)/3,N=F+1,Q[J++]=N,Q[J++]=L,Q[J++]=F,Q[J++]=F,Q[J++]=L,Q[J++]=B,j+=3,Y-=3;j-=3,Y+=3}if(X=t.fromArray(y,y.length-3,X),g(H,X,Z,j,Y,i),O){j+=3,Y-=3,V=b,z=T;var pe=v[1];for(u=0;K>u;u++)V=t.fromArray(pe,3*(R-u-1),V),z=t.fromArray(pe,3*u,z),n.addAttribute(U,V,void 0,Y),n.addAttribute(U,z,j),g(H,X,Z,j,Y,i),B=j/3,L=B-1,F=(Y-2)/3,N=F+1,Q[J++]=N,Q[J++]=L,Q[J++]=F,Q[J++]=F,Q[J++]=L,Q[J++]=B,j+=3,Y-=3}if(w.position=new c({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:U}),i.st){var fe,ve,ge=new Float32Array(k/3*2),_e=0;if(O){C/=3,x/=3;var ye=Math.PI/(R+1);ve=1/(C-R+1),fe=1/(x-R+1);var we,Ce=R/2;for(u=Ce+1;R+1>u;u++)we=m.PI_OVER_TWO+ye*u,ge[_e++]=fe*(1+Math.cos(we)),ge[_e++]=.5*(1+Math.sin(we));for(u=1;x-R+1>u;u++)ge[_e++]=u*fe,ge[_e++]=0;for(u=R;u>Ce;u--)we=m.PI_OVER_TWO-u*ye,ge[_e++]=1-fe*(1+Math.cos(we)),ge[_e++]=.5*(1+Math.sin(we));for(u=Ce;u>0;u--)we=m.PI_OVER_TWO-ye*u,ge[_e++]=1-ve*(1+Math.cos(we)),ge[_e++]=.5*(1+Math.sin(we));for(u=C-R;u>0;u--)ge[_e++]=u*ve,ge[_e++]=1;for(u=1;Ce+1>u;u++)we=m.PI_OVER_TWO+ye*u,ge[_e++]=ve*(1+Math.cos(we)),ge[_e++]=.5*(1+Math.sin(we))}else{for(C/=3,x/=3,ve=1/(C-1),fe=1/(x-1),u=0;x>u;u++)ge[_e++]=u*fe,ge[_e++]=0;for(u=C;u>0;u--)ge[_e++]=(u-1)*ve,ge[_e++]=1}w.st=new c({componentDatatype:r.FLOAT,componentsPerAttribute:2,values:ge})}return i.normal&&(w.normal=new c({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:H.normals})),i.tangent&&(w.tangent=new c({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:H.tangents})),i.binormal&&(w.binormal=new c({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:H.binormals})),{attributes:w,indices:Q}}function y(e,r){if(!(r.normal||r.binormal||r.tangent||r.st))return e;var i,o,a=e.position.values;(r.normal||r.binormal)&&(i=e.normal.values,o=e.binormal.values);var s,u=e.position.values.length/18,l=3*u,c=2*u,h=2*l;if(r.normal||r.binormal||r.tangent){var d=r.normal?new Float32Array(6*l):void 0,m=r.binormal?new Float32Array(6*l):void 0,p=r.tangent?new Float32Array(6*l):void 0,f=E,v=S,g=b,_=T,y=x,w=P,C=h;for(s=0;l>s;s+=3){var A=C+h;f=t.fromArray(a,s,f),v=t.fromArray(a,s+l,v),g=t.fromArray(a,(s+3)%l,g),v=t.subtract(v,f,v),g=t.subtract(g,f,g),_=t.normalize(t.cross(v,g,_),_),r.normal&&(n.addAttribute(d,_,A),n.addAttribute(d,_,A+3),n.addAttribute(d,_,C),n.addAttribute(d,_,C+3)),(r.tangent||r.binormal)&&(w=t.fromArray(i,s,w),r.binormal&&(n.addAttribute(m,w,A),n.addAttribute(m,w,A+3),n.addAttribute(m,w,C),n.addAttribute(m,w,C+3)),r.tangent&&(y=t.normalize(t.cross(w,_,y),y),n.addAttribute(p,y,A),n.addAttribute(p,y,A+3),n.addAttribute(p,y,C),n.addAttribute(p,y,C+3))),C+=6}if(r.normal){for(d.set(i),s=0;l>s;s+=3)d[s+l]=-i[s],d[s+l+1]=-i[s+1],d[s+l+2]=-i[s+2];e.normal.values=d}else e.normal=void 0;if(r.binormal?(m.set(o),m.set(o,l),e.binormal.values=m):e.binormal=void 0,r.tangent){var I=e.tangent.values;p.set(I),p.set(I,l),e.tangent.values=p}}if(r.st){var D=e.st.values,M=new Float32Array(6*c);M.set(D),M.set(D,c);for(var R=2*c,O=0;2>O;O++){for(M[R++]=D[0],M[R++]=D[1],s=2;c>s;s+=2){var N=D[s],L=D[s+1];M[R++]=N,M[R++]=L,M[R++]=N,M[R++]=L}M[R++]=D[0],M[R++]=D[1]}e.st.values=M}return e}function w(e,t,r){r[t++]=e[0],r[t++]=e[1],r[t++]=e[2];for(var i=3;i<e.length;i+=3){var n=e[i],o=e[i+1],a=e[i+2];r[t++]=n,r[t++]=o,r[t++]=a,r[t++]=n,r[t++]=o,r[t++]=a}return r[t++]=e[0],r[t++]=e[1],r[t++]=e[2],r}function C(e,t){var r=new v({position:t.positon,normal:t.normal||t.binormal,tangent:t.tangent,binormal:t.normal||t.binormal,st:t.st}),i=e.ellipsoid,o=n.computePositions(e),a=_(o,r,i),s=e.height,u=e.extrudedHeight,l=a.attributes,c=a.indices,h=l.position.values,m=h.length,p=new Float64Array(6*m),f=new Float64Array(m);f.set(h);var g=new Float64Array(4*m);h=n.scaleToGeodeticHeight(h,s,i,h),g=w(h,0,g),f=n.scaleToGeodeticHeight(f,u,i,f),g=w(f,2*m,g),p.set(h),p.set(f,m),p.set(g,2*m),l.position.values=p,m/=3;var C,E=c.length,S=m+m,b=d.createTypedArray(p.length/3,2*E+3*S);b.set(c);var T=E;for(C=0;E>C;C+=3){var x=c[C],P=c[C+1],A=c[C+2];b[T++]=A+m,b[T++]=P+m,b[T++]=x+m}l=y(l,t);var I,D,M,R;for(C=0;S>C;C+=2)I=C+S,D=I+S,M=I+1,R=D+1,b[T++]=I,b[T++]=D,b[T++]=M,b[T++]=M,b[T++]=D,b[T++]=R;return{attributes:l,indices:b}}var E=new t,S=new t,b=new t,T=new t,x=new t,P=new t,A=new t,I=new t,D=function(e){e=o(e,o.EMPTY_OBJECT);var r=e.positions,n=e.width;if(!a(r))throw new s("options.positions is required.");if(!a(n))throw new s("options.width is required.");this._positions=r,this._ellipsoid=u.clone(o(e.ellipsoid,u.WGS84)),this._vertexFormat=v.clone(o(e.vertexFormat,v.DEFAULT)),this._width=n,this._height=o(e.height,0),this._extrudedHeight=o(e.extrudedHeight,this._height),this._cornerType=o(e.cornerType,i.ROUNDED),this._granularity=o(e.granularity,m.RADIANS_PER_DEGREE),this._workerName="createCorridorGeometry",this.packedLength=1+r.length*t.packedLength+u.packedLength+v.packedLength+5};D.pack=function(e,r,i){if(!a(e))throw new s("value is required");if(!a(r))throw new s("array is required");i=o(i,0);var n=e._positions,l=n.length;r[i++]=l;for(var c=0;l>c;++c,i+=t.packedLength)t.pack(n[c],r,i);u.pack(e._ellipsoid,r,i),i+=u.packedLength,v.pack(e._vertexFormat,r,i),i+=v.packedLength,r[i++]=e._width,r[i++]=e._height,r[i++]=e._extrudedHeight,r[i++]=e._cornerType,r[i]=e._granularity};var M=u.clone(u.UNIT_SPHERE),R=new v,O={positions:void 0,ellipsoid:M,vertexFormat:R,width:void 0,height:void 0,extrudedHeight:void 0,cornerType:void 0,granularity:void 0};return D.unpack=function(e,r,i){if(!a(e))throw new s("array is required");r=o(r,0);for(var n=e[r++],l=new Array(n),c=0;n>c;++c,r+=t.packedLength)l[c]=t.unpack(e,r);var h=u.unpack(e,r,M);r+=u.packedLength;var d=v.unpack(e,r,R);r+=v.packedLength;var m=e[r++],p=e[r++],f=e[r++],g=e[r++],_=e[r];return a(i)?(i._positions=l,i._ellipsoid=u.clone(h,i._ellipsoid),i._vertexFormat=v.clone(d,i._vertexFormat),i._width=m,i._height=p,i._extrudedHeight=f,i._cornerType=g,i._granularity=_,i):(O.positions=l,O.width=m,O.height=p,O.extrudedHeight=f,O.cornerType=g,O.granularity=_,new D(O))},D.createGeometry=function(t){var r=t._positions,i=t._height,o=t._extrudedHeight,a=i!==o,s=p.removeDuplicates(r);if(s.length<2)return void 0;var u,c=t._ellipsoid,h=t._vertexFormat,d={ellipsoid:c,positions:s,width:t._width,cornerType:t._cornerType,granularity:t._granularity,saveAttributes:!0};if(a){var m=Math.max(i,o);o=Math.min(i,o),i=m,d.height=i,d.extrudedHeight=o,u=C(d,h)}else{var v=n.computePositions(d);u=_(v,h,c),u.attributes.position.values=n.scaleToGeodeticHeight(u.attributes.position.values,i,c,u.attributes.position.values)}var g=u.attributes,y=e.fromVertices(g.position.values,void 0,3);return h.position||(u.attributes.position.values=void 0),new l({attributes:g,indices:u.indices,primitiveType:f.TRIANGLES,boundingSphere:y})},D.createShadowVolume=function(e,t,r){var i=e._granularity,n=e._ellipsoid,o=t(i,n),a=r(i,n);return new D({positions:e._positions,width:e._width,cornerType:e._cornerType,ellipsoid:n,granularity:i,extrudedHeight:o,height:a,vertexFormat:v.POSITION_ONLY})},D}),r("Core/CorridorOutlineGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./CornerType","./CorridorGeometryLibrary","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PolylinePipeline","./PrimitiveType"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f){"use strict";function v(e,o){var s,u,l,m=[],p=e.positions,f=e.corners,v=e.endPositions,g=new h,C=0,E=0,S=0;for(u=0;u<p.length;u+=2)l=p[u].length-3,C+=l,S+=l/3*4,E+=p[u+1].length-3;for(C+=3,E+=3,u=0;u<f.length;u++){s=f[u];var b=f[u].leftPositions;a(b)?(l=b.length,C+=l,S+=l/3*2):(l=f[u].rightPositions.length,E+=l,S+=l/3*2)}var T,x=a(v);x&&(T=v[0].length-3,C+=T,E+=T,T/=3,S+=4*T);var P,A,I,D,M,R,O=C+E,N=new Float64Array(O),L=0,F=O-1,B=T/2,z=d.createTypedArray(O/3,S+4),V=0;if(z[V++]=L/3,z[V++]=(F-2)/3,x){m.push(L/3),R=_,M=y;var k=v[0];for(u=0;B>u;u++)R=t.fromArray(k,3*(B-1-u),R),M=t.fromArray(k,3*(B+u),M),n.addAttribute(N,M,L),n.addAttribute(N,R,void 0,F),A=L/3,D=A+1,P=(F-2)/3,I=P-1,z[V++]=P,z[V++]=I,z[V++]=A,z[V++]=D,L+=3,F-=3}var U=0,q=p[U++],G=p[U++];for(N.set(q,L),N.set(G,F-G.length+1),l=G.length-3,m.push(L/3,(F-2)/3),u=0;l>u;u+=3)A=L/3,D=A+1,P=(F-2)/3,I=P-1,z[V++]=P,z[V++]=I,z[V++]=A,z[V++]=D,L+=3,F-=3;for(u=0;u<f.length;u++){var W;s=f[u];var H,j=s.leftPositions,Y=s.rightPositions,X=w;if(a(j)){for(F-=3,H=I,m.push(D),W=0;W<j.length/3;W++)X=t.fromArray(j,3*W,X),z[V++]=H-W-1,z[V++]=H-W,n.addAttribute(N,X,void 0,F),F-=3;m.push(H-Math.floor(j.length/6)),o===i.BEVELED&&m.push((F-2)/3+1),L+=3}else{for(L+=3,H=D,m.push(I),W=0;W<Y.length/3;W++)X=t.fromArray(Y,3*W,X),z[V++]=H+W,z[V++]=H+W+1,n.addAttribute(N,X,L),L+=3;m.push(H+Math.floor(Y.length/6)),o===i.BEVELED&&m.push(L/3-1),F-=3}for(q=p[U++],G=p[U++],q.splice(0,3),G.splice(G.length-3,3),N.set(q,L),N.set(G,F-G.length+1),l=G.length-3,W=0;W<G.length;W+=3)D=L/3,A=D-1,I=(F-2)/3,P=I+1,z[V++]=P,z[V++]=I,z[V++]=A,z[V++]=D,L+=3,F-=3;L-=3,F+=3,m.push(L/3,(F-2)/3)}if(x){L+=3,F-=3,R=_,M=y;var Z=v[1];for(u=0;B>u;u++)R=t.fromArray(Z,3*(T-u-1),R),M=t.fromArray(Z,3*u,M),n.addAttribute(N,R,void 0,F),n.addAttribute(N,M,L),D=L/3,A=D-1,I=(F-2)/3,P=I+1,z[V++]=P,z[V++]=I,z[V++]=A,z[V++]=D,L+=3,F-=3;m.push(L/3)}else m.push(L/3,(F-2)/3);return z[V++]=L/3,z[V++]=(F-2)/3,g.position=new c({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:N}),{attributes:g,indices:z,wallIndices:m}}function g(e){var t=e.ellipsoid,r=n.computePositions(e),i=v(r,e.cornerType),o=i.wallIndices,a=e.height,s=e.extrudedHeight,u=i.attributes,l=i.indices,c=u.position.values,h=c.length,m=new Float64Array(h);m.set(c);var p=new Float64Array(2*h);c=n.scaleToGeodeticHeight(c,a,t,c),m=n.scaleToGeodeticHeight(m,s,t,m),p.set(c),p.set(m,h),u.position.values=p,h/=3;var f,g=l.length,_=d.createTypedArray(p.length/3,2*(g+o.length));_.set(l);var y=g;for(f=0;g>f;f+=2){var w=l[f],C=l[f+1];_[y++]=w+h,_[y++]=C+h}var E,S;for(f=0;f<o.length;f++)E=o[f],S=E+h,_[y++]=E,_[y++]=S;return{attributes:u,indices:_}}var _=new t,y=new t,w=new t,C=function(e){e=o(e,o.EMPTY_OBJECT);var r=e.positions,n=e.width;if(!a(r))throw new s("options.positions is required.");if(!a(n))throw new s("options.width is required.");this._positions=r,this._ellipsoid=u.clone(o(e.ellipsoid,u.WGS84)),this._width=n,this._height=o(e.height,0),this._extrudedHeight=o(e.extrudedHeight,this._height),this._cornerType=o(e.cornerType,i.ROUNDED),this._granularity=o(e.granularity,m.RADIANS_PER_DEGREE),this._workerName="createCorridorOutlineGeometry",this.packedLength=1+r.length*t.packedLength+u.packedLength+5};C.pack=function(e,r,i){if(!a(e))throw new s("value is required");if(!a(r))throw new s("array is required");i=o(i,0);var n=e._positions,l=n.length;r[i++]=l;for(var c=0;l>c;++c,i+=t.packedLength)t.pack(n[c],r,i);u.pack(e._ellipsoid,r,i),i+=u.packedLength,r[i++]=e._width,r[i++]=e._height,r[i++]=e._extrudedHeight,r[i++]=e._cornerType,r[i]=e._granularity};var E=u.clone(u.UNIT_SPHERE),S={positions:void 0,ellipsoid:E,width:void 0,height:void 0,extrudedHeight:void 0,cornerType:void 0,granularity:void 0};return C.unpack=function(e,r,i){if(!a(e))throw new s("array is required");r=o(r,0);for(var n=e[r++],l=new Array(n),c=0;n>c;++c,r+=t.packedLength)l[c]=t.unpack(e,r);var h=u.unpack(e,r,E);r+=u.packedLength;var d=e[r++],m=e[r++],p=e[r++],f=e[r++],v=e[r];return a(i)?(i._positions=l,i._ellipsoid=u.clone(h,i._ellipsoid),i._width=d,i._height=m,i._extrudedHeight=p,i._cornerType=f,i._granularity=v,i):(S.positions=l,S.width=d,S.height=m,S.extrudedHeight=p,S.cornerType=f,S.granularity=v,new C(S))},C.createGeometry=function(t){var r=t._positions,i=t._height,o=t._extrudedHeight,a=i!==o,s=p.removeDuplicates(r);if(s.length<2)return void 0;var u,c=t._ellipsoid,h={ellipsoid:c,positions:s,width:t._width,cornerType:t._cornerType,granularity:t._granularity,saveAttributes:!1};if(a){var d=Math.max(i,o);o=Math.min(i,o),i=d,h.height=i,h.extrudedHeight=o,u=g(h)}else{var m=n.computePositions(h);u=v(m,h.cornerType),u.attributes.position.values=n.scaleToGeodeticHeight(u.attributes.position.values,i,c,u.attributes.position.values)}var _=u.attributes,y=e.fromVertices(_.position.values,void 0,3);return new l({attributes:_,indices:u.indices,primitiveType:f.LINES,boundingSphere:y})},C}),r("Core/createGuid",[],function(){"use strict";var e=function(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(e){var t=16*Math.random()|0,r="x"===e?t:3&t|8;return r.toString(16)})};return e}),r("Core/CylinderGeometryLibrary",["./Math"],function(e){"use strict";var t={};return t.computePositions=function(t,r,i,n,o){var a,s=.5*t,u=-s,l=n+n,c=o?2*l:l,h=new Float64Array(3*c),d=0,m=0,p=o?3*l:0,f=o?3*(l+n):3*n;for(a=0;n>a;a++){var v=a/n*e.TWO_PI,g=Math.cos(v),_=Math.sin(v),y=g*i,w=_*i,C=g*r,E=_*r;h[m+p]=y,h[m+p+1]=w,h[m+p+2]=u,h[m+f]=C,h[m+f+1]=E,h[m+f+2]=s,m+=3,o&&(h[d++]=y,h[d++]=w,h[d++]=u,h[d++]=C,h[d++]=E,h[d++]=s)}return h},t}),r("Core/CylinderGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./CylinderGeometryLibrary","./defaultValue","./defined","./DeveloperError","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType","./VertexFormat"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p){"use strict";var f=new t,v=new r,g=new r,_=new r,y=new r,w=function(e){e=o(e,o.EMPTY_OBJECT);var t=e.length,r=e.topRadius,i=e.bottomRadius,n=o(e.vertexFormat,p.DEFAULT),u=o(e.slices,128);if(!a(t)||0>=t)throw new s("options.length must be greater than 0.");if(!a(r)||0>r)throw new s("options.topRadius must be greater than 0.");if(!a(i)||0>i)throw new s("options.bottomRadius must be greater than 0.");if(0===i&&0===r)throw new s("bottomRadius and topRadius cannot both equal 0.");if(3>u)throw new s("options.slices must be greater that 3.");this._length=t,this._topRadius=r,this._bottomRadius=i,this._vertexFormat=p.clone(n),this._slices=u,this._workerName="createCylinderGeometry"};w.packedLength=p.packedLength+4,w.pack=function(e,t,r){if(!a(e))throw new s("value is required");if(!a(t))throw new s("array is required");r=o(r,0),p.pack(e._vertexFormat,t,r),r+=p.packedLength,t[r++]=e._length,t[r++]=e._topRadius,t[r++]=e._bottomRadius,t[r]=e._slices};var C=new p,E={vertexFormat:C,length:void 0,topRadius:void 0,bottomRadius:void 0,slices:void 0};return w.unpack=function(e,t,r){if(!a(e))throw new s("array is required");t=o(t,0);var i=p.unpack(e,t,C);t+=p.packedLength;var n=e[t++],u=e[t++],l=e[t++],c=e[t];return a(r)?(r._vertexFormat=p.clone(i,r._vertexFormat),r._length=n,r._topRadius=u,r._bottomRadius=l,r._slices=c,r):(E.length=n,E.topRadius=u,E.bottomRadius=l,E.slices=c,new w(E))},w.createGeometry=function(o){var a,s=o._length,p=o._topRadius,w=o._bottomRadius,C=o._vertexFormat,E=o._slices,S=E+E,b=E+S,T=S+S,x=n.computePositions(s,p,w,E,!0),P=C.st?new Float32Array(2*T):void 0,A=C.normal?new Float32Array(3*T):void 0,I=C.tangent?new Float32Array(3*T):void 0,D=C.binormal?new Float32Array(3*T):void 0,M=C.normal||C.tangent||C.binormal;if(M){var R=C.tangent||C.binormal,O=0,N=0,L=0,F=v;F.z=0;var B=_,z=g;for(a=0;E>a;a++){var V=a/E*d.TWO_PI,k=Math.cos(V),U=Math.sin(V);M&&(F.x=k,F.y=U,R&&(B=r.normalize(r.cross(r.UNIT_Z,F,B),B)),C.normal&&(A[O++]=k,A[O++]=U,A[O++]=0,A[O++]=k,A[O++]=U,A[O++]=0),C.tangent&&(I[N++]=B.x,I[N++]=B.y,I[N++]=B.z,I[N++]=B.x,I[N++]=B.y,I[N++]=B.z),C.binormal&&(z=r.normalize(r.cross(F,B,z),z),D[L++]=z.x,D[L++]=z.y,D[L++]=z.z,D[L++]=z.x,D[L++]=z.y,D[L++]=z.z))}for(a=0;E>a;a++)C.normal&&(A[O++]=0,A[O++]=0,A[O++]=-1),C.tangent&&(I[N++]=1,I[N++]=0,I[N++]=0),C.binormal&&(D[L++]=0,D[L++]=-1,D[L++]=0);for(a=0;E>a;a++)C.normal&&(A[O++]=0,A[O++]=0,A[O++]=1),C.tangent&&(I[N++]=1,I[N++]=0,I[N++]=0),C.binormal&&(D[L++]=0,D[L++]=1,D[L++]=0)}var q=12*E-12,G=h.createTypedArray(T,q),W=0,H=0;for(a=0;E-1>a;a++)G[W++]=H,G[W++]=H+2,G[W++]=H+3,G[W++]=H,G[W++]=H+3,G[W++]=H+1,H+=2;for(G[W++]=S-2,G[W++]=0,G[W++]=1,G[W++]=S-2,G[W++]=1,G[W++]=S-1,a=1;E-1>a;a++)G[W++]=S+a+1,G[W++]=S+a,G[W++]=S;for(a=1;E-1>a;a++)G[W++]=b,G[W++]=b+a,G[W++]=b+a+1;var j=0;if(C.st){var Y=Math.max(p,w);for(a=0;T>a;a++){var X=r.fromArray(x,3*a,y);P[j++]=(X.x+Y)/(2*Y),P[j++]=(X.y+Y)/(2*Y)}}var Z=new c;C.position&&(Z.position=new l({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:x})),C.normal&&(Z.normal=new l({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:A})),C.tangent&&(Z.tangent=new l({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:I})),C.binormal&&(Z.binormal=new l({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:D})),C.st&&(Z.st=new l({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:P})),f.x=.5*s,f.y=Math.max(w,p);var K=new e(r.ZERO,t.magnitude(f));return new u({attributes:Z,indices:G,primitiveType:m.TRIANGLES,boundingSphere:K})},w}),r("Core/CylinderOutlineGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./CylinderGeometryLibrary","./defaultValue","./defined","./DeveloperError","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./PrimitiveType"],function(e,t,r,i,n,o,a,s,u,l,c,h,d){"use strict";var m=new t,p=function(e){e=o(e,o.EMPTY_OBJECT);var t=e.length,r=e.topRadius,i=e.bottomRadius,n=o(e.slices,128),u=Math.max(o(e.numberOfVerticalLines,16),0);if(!a(t)||0>=t)throw new s("options.length must be greater than 0.");if(!a(r)||0>r)throw new s("options.topRadius must be greater than 0.");if(!a(i)||0>i)throw new s("options.bottomRadius must be greater than 0.");if(0===i&&0===r)throw new s("bottomRadius and topRadius cannot both equal 0.");if(3>n)throw new s("options.slices must be greater that 3.");this._length=t,this._topRadius=r,this._bottomRadius=i,this._slices=n,this._numberOfVerticalLines=u,this._workerName="createCylinderOutlineGeometry"};p.packedLength=5,p.pack=function(e,t,r){if(!a(e))throw new s("value is required");if(!a(t))throw new s("array is required");r=o(r,0),t[r++]=e._length,t[r++]=e._topRadius,t[r++]=e._bottomRadius,t[r++]=e._slices,t[r]=e._numberOfVerticalLines};var f={length:void 0,topRadius:void 0,bottomRadius:void 0,slices:void 0,numberOfVerticalLines:void 0};return p.unpack=function(e,t,r){if(!a(e))throw new s("array is required");t=o(t,0);var i=e[t++],n=e[t++],u=e[t++],l=e[t++],c=e[t];return a(r)?(r._length=i,r._topRadius=n,r._bottomRadius=u,r._slices=l,r._numberOfVerticalLines=c,r):(f.length=i,f.topRadius=n,f.bottomRadius=u,f.slices=l,f.numberOfVerticalLines=c,new p(f))},p.createGeometry=function(o){var a,s=o._length,p=o._topRadius,f=o._bottomRadius,v=o._slices,g=o._numberOfVerticalLines,_=2*v,y=n.computePositions(s,p,f,v,!1),w=2*v;if(g>0){var C=Math.min(g,v);a=Math.round(v/C),w+=C}for(var E=h.createTypedArray(_,2*w),S=0,b=0;v-1>b;b++)E[S++]=b,E[S++]=b+1,E[S++]=b+v,E[S++]=b+1+v;if(E[S++]=v-1,E[S++]=0,E[S++]=v+v-1,E[S++]=v,g>0)for(b=0;v>b;b+=a)E[S++]=b,E[S++]=b+v;var T=new c;T.position=new l({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:y}),m.x=.5*s,m.y=Math.max(f,p);var x=new e(r.ZERO,t.magnitude(m));return new u({attributes:T,indices:E,primitiveType:d.LINES,boundingSphere:x})},p}),r("Core/DefaultProxy",[],function(){"use strict";var e=function(e){this.proxy=e};return e.prototype.getURL=function(e){return this.proxy+"?"+encodeURIComponent(e)},e}),r("ThirdParty/Tween",[],function(){void 0===Date.now&&(Date.now=function(){return(new Date).valueOf()});var e=e||function(){var e=[];return{REVISION:"13",getAll:function(){return e},removeAll:function(){e=[]},add:function(t){e.push(t)},remove:function(t){var r=e.indexOf(t);-1!==r&&e.splice(r,1)},update:function(t){if(0===e.length)return!1;var r=0;for(t=void 0!==t?t:"undefined"!=typeof window&&void 0!==window.performance&&void 0!==window.performance.now?window.performance.now():Date.now();r<e.length;)e[r].update(t)?r++:e.splice(r,1);return!0}}}();return e.Tween=function(t){var r=t,i={},n={},o={},a=1e3,s=0,u=!1,l=!1,c=!1,h=0,d=null,m=e.Easing.Linear.None,p=e.Interpolation.Linear,f=[],v=null,g=!1,_=null,y=null,w=null;for(var C in t)i[C]=parseFloat(t[C],10);this.to=function(e,t){return void 0!==t&&(a=t),n=e,this},this.start=function(t){e.add(this),l=!0,g=!1,d=void 0!==t?t:"undefined"!=typeof window&&void 0!==window.performance&&void 0!==window.performance.now?window.performance.now():Date.now(),d+=h;for(var a in n){if(n[a]instanceof Array){if(0===n[a].length)continue;n[a]=[r[a]].concat(n[a])}i[a]=r[a],i[a]instanceof Array==!1&&(i[a]*=1),o[a]=i[a]||0}return this},this.stop=function(){return l?(e.remove(this),l=!1,null!==w&&w.call(r),this.stopChainedTweens(),this):this},this.stopChainedTweens=function(){for(var e=0,t=f.length;t>e;e++)f[e].stop()},this.delay=function(e){return h=e,this},this.repeat=function(e){return s=e,this},this.yoyo=function(e){return u=e,this},this.easing=function(e){return m=e,this},this.interpolation=function(e){return p=e,this},this.chain=function(){return f=arguments,this},this.onStart=function(e){return v=e,this},this.onUpdate=function(e){return _=e,this},this.onComplete=function(e){return y=e,this},this.onStop=function(e){return w=e,this},this.update=function(e){var t;if(d>e)return!0;g===!1&&(null!==v&&v.call(r),g=!0);var l=(e-d)/a;l=l>1?1:l;var w=m(l);for(t in n){var C=i[t]||0,E=n[t];E instanceof Array?r[t]=p(E,w):("string"==typeof E&&(E=C+parseFloat(E,10)),"number"==typeof E&&(r[t]=C+(E-C)*w))}if(null!==_&&_.call(r,w),1==l){if(s>0){isFinite(s)&&s--;for(t in o){if("string"==typeof n[t]&&(o[t]=o[t]+parseFloat(n[t],10)),u){var S=o[t];o[t]=n[t],n[t]=S}i[t]=o[t]}return u&&(c=!c),d=e+h,!0}null!==y&&y.call(r);for(var b=0,T=f.length;T>b;b++)f[b].start(e);return!1}return!0}},e.Easing={Linear:{None:function(e){return e}},Quadratic:{In:function(e){return e*e},Out:function(e){return e*(2-e)},InOut:function(e){return(e*=2)<1?.5*e*e:-.5*(--e*(e-2)-1)}},Cubic:{In:function(e){return e*e*e},Out:function(e){return--e*e*e+1},InOut:function(e){return(e*=2)<1?.5*e*e*e:.5*((e-=2)*e*e+2)}},Quartic:{In:function(e){return e*e*e*e},Out:function(e){return 1- --e*e*e*e},InOut:function(e){return(e*=2)<1?.5*e*e*e*e:-.5*((e-=2)*e*e*e-2)}},Quintic:{In:function(e){return e*e*e*e*e},Out:function(e){return--e*e*e*e*e+1},InOut:function(e){return(e*=2)<1?.5*e*e*e*e*e:.5*((e-=2)*e*e*e*e+2)}},Sinusoidal:{In:function(e){return 1-Math.cos(e*Math.PI/2)},Out:function(e){return Math.sin(e*Math.PI/2)},InOut:function(e){return.5*(1-Math.cos(Math.PI*e))}},Exponential:{In:function(e){return 0===e?0:Math.pow(1024,e-1)},Out:function(e){return 1===e?1:1-Math.pow(2,-10*e)},InOut:function(e){return 0===e?0:1===e?1:(e*=2)<1?.5*Math.pow(1024,e-1):.5*(-Math.pow(2,-10*(e-1))+2)}},Circular:{In:function(e){return 1-Math.sqrt(1-e*e)},Out:function(e){return Math.sqrt(1- --e*e)},InOut:function(e){return(e*=2)<1?-.5*(Math.sqrt(1-e*e)-1):.5*(Math.sqrt(1-(e-=2)*e)+1)}},Elastic:{In:function(e){var t,r=.1,i=.4;return 0===e?0:1===e?1:(!r||1>r?(r=1,t=i/4):t=i*Math.asin(1/r)/(2*Math.PI),-(r*Math.pow(2,10*(e-=1))*Math.sin(2*(e-t)*Math.PI/i)))},Out:function(e){var t,r=.1,i=.4;return 0===e?0:1===e?1:(!r||1>r?(r=1,t=i/4):t=i*Math.asin(1/r)/(2*Math.PI),r*Math.pow(2,-10*e)*Math.sin(2*(e-t)*Math.PI/i)+1)},InOut:function(e){var t,r=.1,i=.4;return 0===e?0:1===e?1:(!r||1>r?(r=1,t=i/4):t=i*Math.asin(1/r)/(2*Math.PI),(e*=2)<1?-.5*r*Math.pow(2,10*(e-=1))*Math.sin(2*(e-t)*Math.PI/i):r*Math.pow(2,-10*(e-=1))*Math.sin(2*(e-t)*Math.PI/i)*.5+1)}},Back:{In:function(e){var t=1.70158;return e*e*((t+1)*e-t)},Out:function(e){var t=1.70158;return--e*e*((t+1)*e+t)+1},InOut:function(e){var t=2.5949095;return(e*=2)<1?.5*e*e*((t+1)*e-t):.5*((e-=2)*e*((t+1)*e+t)+2)}},Bounce:{In:function(t){return 1-e.Easing.Bounce.Out(1-t)},Out:function(e){return 1/2.75>e?7.5625*e*e:2/2.75>e?7.5625*(e-=1.5/2.75)*e+.75:2.5/2.75>e?7.5625*(e-=2.25/2.75)*e+.9375:7.5625*(e-=2.625/2.75)*e+.984375},InOut:function(t){return.5>t?.5*e.Easing.Bounce.In(2*t):.5*e.Easing.Bounce.Out(2*t-1)+.5}}},e.Interpolation={Linear:function(t,r){var i=t.length-1,n=i*r,o=Math.floor(n),a=e.Interpolation.Utils.Linear;return 0>r?a(t[0],t[1],n):r>1?a(t[i],t[i-1],i-n):a(t[o],t[o+1>i?i:o+1],n-o)},Bezier:function(t,r){var i,n=0,o=t.length-1,a=Math.pow,s=e.Interpolation.Utils.Bernstein;for(i=0;o>=i;i++)n+=a(1-r,o-i)*a(r,i)*t[i]*s(o,i);return n},CatmullRom:function(t,r){var i=t.length-1,n=i*r,o=Math.floor(n),a=e.Interpolation.Utils.CatmullRom;return t[0]===t[i]?(0>r&&(o=Math.floor(n=i*(1+r))),a(t[(o-1+i)%i],t[o],t[(o+1)%i],t[(o+2)%i],n-o)):0>r?t[0]-(a(t[0],t[0],t[1],t[1],-n)-t[0]):r>1?t[i]-(a(t[i],t[i],t[i-1],t[i-1],n-i)-t[i]):a(t[o?o-1:0],t[o],t[o+1>i?i:o+1],t[o+2>i?i:o+2],n-o)},Utils:{Linear:function(e,t,r){return(t-e)*r+e},Bernstein:function(t,r){var i=e.Interpolation.Utils.Factorial;return i(t)/i(r)/i(t-r)},Factorial:function(){var e=[1];return function(t){var r,i=1;if(e[t])return e[t];for(r=t;r>1;r--)i*=r;return e[t]=i}}(),CatmullRom:function(e,t,r,i,n){var o=.5*(r-e),a=.5*(i-t),s=n*n,u=n*s;return(2*t-2*r+o+a)*u+(-3*t+3*r-2*o-a)*s+o*n+t}}},e}),r("Core/EasingFunction",["../ThirdParty/Tween","./freezeObject"],function(e,t){"use strict";var r={LINEAR_NONE:e.Easing.Linear.None,QUADRACTIC_IN:e.Easing.Quadratic.In,QUADRACTIC_OUT:e.Easing.Quadratic.Out,QUADRACTIC_IN_OUT:e.Easing.Quadratic.InOut,CUBIC_IN:e.Easing.Cubic.In,CUBIC_OUT:e.Easing.Cubic.Out,CUBIC_IN_OUT:e.Easing.Cubic.InOut,QUARTIC_IN:e.Easing.Quartic.In,QUARTIC_OUT:e.Easing.Quartic.Out,QUARTIC_IN_OUT:e.Easing.Quartic.InOut,QUINTIC_IN:e.Easing.Quintic.In,QUINTIC_OUT:e.Easing.Quintic.Out,QUINTIC_IN_OUT:e.Easing.Quintic.InOut,SINUSOIDAL_IN:e.Easing.Sinusoidal.In,SINUSOIDAL_OUT:e.Easing.Sinusoidal.Out,SINUSOIDAL_IN_OUT:e.Easing.Sinusoidal.InOut,EXPONENTIAL_IN:e.Easing.Exponential.In,EXPONENTIAL_OUT:e.Easing.Exponential.Out,EXPONENTIAL_IN_OUT:e.Easing.Exponential.InOut,CIRCULAR_IN:e.Easing.Circular.In,CIRCULAR_OUT:e.Easing.Circular.Out,CIRCULAR_IN_OUT:e.Easing.Circular.InOut,ELASTIC_IN:e.Easing.Elastic.In,ELASTIC_OUT:e.Easing.Elastic.Out,ELASTIC_IN_OUT:e.Easing.Elastic.InOut,BACK_IN:e.Easing.Back.In,BACK_OUT:e.Easing.Back.Out,BACK_IN_OUT:e.Easing.Back.InOut,BOUNCE_IN:e.Easing.Bounce.In,BOUNCE_OUT:e.Easing.Bounce.Out,BOUNCE_IN_OUT:e.Easing.Bounce.InOut};return t(r)}),r("Core/EllipsoidalOccluder",["./BoundingSphere","./Cartesian3","./defaultValue","./defined","./defineProperties","./DeveloperError","./Rectangle"],function(e,t,r,i,n,o,a){"use strict";function s(e,r,i){var n=e.transformPositionToScaledSpace(r,p),o=t.magnitudeSquared(n),a=Math.sqrt(o),s=t.divideByScalar(n,a,f);o=Math.max(1,o),a=Math.max(1,a);var u=t.dot(s,i),l=t.magnitude(t.cross(s,i,s)),c=1/a,h=Math.sqrt(o-1)*c;return 1/(u*c-l*h)}function u(e,r,i){return 0>=r||r===1/0||r!==r?void 0:t.multiplyByScalar(e,r,i)}function l(e,r){return e.transformPositionToScaledSpace(r,v),t.normalize(v,v)}var c=function(e,r){if(!i(e))throw new o("ellipsoid is required.");this._ellipsoid=e,this._cameraPosition=new t,this._cameraPositionInScaledSpace=new t,this._distanceToLimbInScaledSpaceSquared=0,i(r)&&(this.cameraPosition=r)};n(c.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},cameraPosition:{get:function(){return this._cameraPosition},set:function(e){var r=this._ellipsoid,i=r.transformPositionToScaledSpace(e,this._cameraPositionInScaledSpace),n=t.magnitudeSquared(i)-1;t.clone(e,this._cameraPosition),this._cameraPositionInScaledSpace=i,this._distanceToLimbInScaledSpaceSquared=n}}});var h=new t;c.prototype.isPointVisible=function(e){var t=this._ellipsoid,r=t.transformPositionToScaledSpace(e,h);
return this.isScaledSpacePointVisible(r)},c.prototype.isScaledSpacePointVisible=function(e){if(this._distanceToLimbInScaledSpaceSquared<0)return!0;var r=this._cameraPositionInScaledSpace,i=this._distanceToLimbInScaledSpaceSquared,n=t.subtract(e,r,h),o=-t.dot(n,r),a=o>i&&o*o/t.magnitudeSquared(n)>i;return!a},c.prototype.computeHorizonCullingPoint=function(e,r,n){if(!i(e))throw new o("directionToPoint is required");if(!i(r))throw new o("positions is required");i(n)||(n=new t);for(var a=this._ellipsoid,c=l(a,e),h=0,d=0,m=r.length;m>d;++d){var p=r[d],f=s(a,p,c);h=Math.max(h,f)}return u(c,h,n)};var d=new t;c.prototype.computeHorizonCullingPointFromVertices=function(e,n,a,c,h){if(!i(e))throw new o("directionToPoint is required");if(!i(n))throw new o("vertices is required");if(!i(a))throw new o("stride is required");i(h)||(h=new t),c=r(c,t.ZERO);for(var m=this._ellipsoid,p=l(m,e),f=0,v=0,g=n.length;g>v;v+=a){d.x=n[v]+c.x,d.y=n[v+1]+c.y,d.z=n[v+2]+c.z;var _=s(m,d,p);f=Math.max(f,_)}return u(p,f,h)};var m=[];c.prototype.computeHorizonCullingPointFromRectangle=function(r,n,s){if(!i(r))throw new o("rectangle is required.");var u=a.subsample(r,n,0,m),l=e.fromPoints(u);return t.magnitude(l.center)<.1*n.minimumRadius?void 0:this.computeHorizonCullingPoint(l.center,u,s)};var p=new t,f=new t,v=new t;return c}),r("Core/EllipsoidGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType","./VertexFormat"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p){"use strict";var f=new r,v=new r,g=new r,_=new r,y=new r,w=new r(1,1,1),C=Math.cos,E=Math.sin,S=function(e){e=n(e,n.EMPTY_OBJECT);var t=n(e.radii,w),i=n(e.stackPartitions,64),o=n(e.slicePartitions,64),s=n(e.vertexFormat,p.DEFAULT);if(3>o)throw new a("options.slicePartitions cannot be less than three.");if(3>i)throw new a("options.stackPartitions cannot be less than three.");this._radii=r.clone(t),this._stackPartitions=i,this._slicePartitions=o,this._vertexFormat=p.clone(s),this._workerName="createEllipsoidGeometry"};S.packedLength=r.packedLength+p.packedLength+2,S.pack=function(e,t,i){if(!o(e))throw new a("value is required");if(!o(t))throw new a("array is required");i=n(i,0),r.pack(e._radii,t,i),i+=r.packedLength,p.pack(e._vertexFormat,t,i),i+=p.packedLength,t[i++]=e._stackPartitions,t[i]=e._slicePartitions};var b=new r,T=new p,x={radii:b,vertexFormat:T,stackPartitions:void 0,slicePartitions:void 0};return S.unpack=function(e,t,i){if(!o(e))throw new a("array is required");t=n(t,0);var s=r.unpack(e,t,b);t+=r.packedLength;var u=p.unpack(e,t,T);t+=p.packedLength;var l=e[t++],c=e[t];return o(i)?(i._radii=r.clone(s,i._radii),i._vertexFormat=p.clone(u,i._vertexFormat),i._stackPartitions=l,i._slicePartitions=c,i):(x.stackPartitions=l,x.slicePartitions=c,new S(x))},S.createGeometry=function(n){var o,a,p=n._radii,w=s.fromCartesian3(p),S=n._vertexFormat,b=n._slicePartitions+1,T=n._stackPartitions+1,x=T*b,P=new Float64Array(3*x),A=6*(b-1)*(T-1),I=h.createTypedArray(x,A),D=S.normal?new Float32Array(3*x):void 0,M=S.tangent?new Float32Array(3*x):void 0,R=S.binormal?new Float32Array(3*x):void 0,O=S.st?new Float32Array(2*x):void 0,N=new Array(b),L=new Array(b),F=0;for(o=0;b>o;o++){var B=d.TWO_PI*o/(b-1);N[o]=C(B),L[o]=E(B),P[F++]=0,P[F++]=0,P[F++]=p.z}for(o=1;T-1>o;o++){var z=Math.PI*o/(T-1),V=E(z),k=p.x*V,U=p.y*V,q=p.z*C(z);for(a=0;b>a;a++)P[F++]=N[a]*k,P[F++]=L[a]*U,P[F++]=q}for(o=0;b>o;o++)P[F++]=0,P[F++]=0,P[F++]=-p.z;var G=new c;S.position&&(G.position=new l({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:P}));var W=0,H=0,j=0,Y=0;if(S.st||S.normal||S.tangent||S.binormal){for(o=0;x>o;o++){var X=r.fromArray(P,3*o,f),Z=w.geodeticSurfaceNormal(X,v);if(S.st){var K=t.negate(Z,y);t.magnitude(K)<d.EPSILON6&&(F=3*(o+b*Math.floor(.5*T)),F>P.length&&(F=3*(o-b*Math.floor(.5*T))),r.fromArray(P,F,K),w.geodeticSurfaceNormal(K,K),t.negate(K,K)),O[W++]=Math.atan2(K.y,K.x)/d.TWO_PI+.5,O[W++]=Math.asin(Z.z)/Math.PI+.5}if(S.normal&&(D[H++]=Z.x,D[H++]=Z.y,D[H++]=Z.z),S.tangent||S.binormal){var Q=g;if(b>o||o>x-b-1?(r.cross(r.UNIT_X,Z,Q),r.normalize(Q,Q)):(r.cross(r.UNIT_Z,Z,Q),r.normalize(Q,Q)),S.tangent&&(M[j++]=Q.x,M[j++]=Q.y,M[j++]=Q.z),S.binormal){var J=r.cross(Z,Q,_);r.normalize(J,J),R[Y++]=J.x,R[Y++]=J.y,R[Y++]=J.z}}}S.st&&(G.st=new l({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:O})),S.normal&&(G.normal=new l({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:D})),S.tangent&&(G.tangent=new l({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:M})),S.binormal&&(G.binormal=new l({componentDatatype:i.FLOAT,componentsPerAttribute:3,values:R}))}for(F=0,o=0;T>o;o++){var $=o*b,ee=(o+1)*b;for(a=0;b-1>a;a++)I[F++]=ee+a,I[F++]=ee+a+1,I[F++]=$+a+1,I[F++]=ee+a,I[F++]=$+a+1,I[F++]=$+a}return new u({attributes:G,indices:I,primitiveType:m.TRIANGLES,boundingSphere:e.fromEllipsoid(w)})},S}),r("Core/EllipsoidOutlineGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType"],function(e,t,r,i,n,o,a,s,u,l,c,h,d){"use strict";var m=new t(1,1,1),p=Math.cos,f=Math.sin,v=function(e){e=i(e,i.EMPTY_OBJECT);var r=i(e.radii,m),n=i(e.stackPartitions,10),a=i(e.slicePartitions,8),s=i(e.subdivisions,128);if(1>n)throw new o("options.stackPartitions cannot be less than 1");if(0>a)throw new o("options.slicePartitions cannot be less than 0");if(0>s)throw new o("options.subdivisions must be greater than or equal to zero.");this._radii=t.clone(r),this._stackPartitions=n,this._slicePartitions=a,this._subdivisions=s,this._workerName="createEllipsoidOutlineGeometry"};v.packedLength=t.packedLength+3,v.pack=function(e,r,a){if(!n(e))throw new o("value is required");if(!n(r))throw new o("array is required");a=i(a,0),t.pack(e._radii,r,a),a+=t.packedLength,r[a++]=e._stackPartitions,r[a++]=e._slicePartitions,r[a]=e._subdivisions};var g=new t,_={radii:g,stackPartitions:void 0,slicePartitions:void 0,subdivisions:void 0};return v.unpack=function(e,r,a){if(!n(e))throw new o("array is required");r=i(r,0);var s=t.unpack(e,r,g);r+=t.packedLength;var u=e[r++],l=e[r++],c=e[r++];return n(a)?(a._radii=t.clone(s,a._radii),a._stackPartitions=u,a._slicePartitions=l,a._subdivisions=c,a):(_.stackPartitions=u,_.slicePartitions=l,_.subdivisions=c,new v(_))},v.createGeometry=function(t){var i,n,o,m,v,g,_=t._radii,y=a.fromCartesian3(_),w=t._stackPartitions,C=t._slicePartitions,E=t._subdivisions,S=E*(w+C-1),b=S-C+2,T=new Float64Array(3*b),x=c.createTypedArray(b,2*S),P=0,A=new Array(E),I=new Array(E);for(i=0;E>i;i++)o=h.TWO_PI*i/E,A[i]=p(o),I[i]=f(o);for(i=1;w>i;i++)for(m=Math.PI*i/w,v=p(m),g=f(m),n=0;E>n;n++)T[P++]=_.x*A[n]*g,T[P++]=_.y*I[n]*g,T[P++]=_.z*v;for(A.length=C,I.length=C,i=0;C>i;i++)o=h.TWO_PI*i/C,A[i]=p(o),I[i]=f(o);for(T[P++]=0,T[P++]=0,T[P++]=_.z,i=1;E>i;i++)for(m=Math.PI*i/E,v=p(m),g=f(m),n=0;C>n;n++)T[P++]=_.x*A[n]*g,T[P++]=_.y*I[n]*g,T[P++]=_.z*v;for(T[P++]=0,T[P++]=0,T[P++]=-_.z,P=0,i=0;w-1>i;++i){var D=i*E;for(n=0;E-1>n;++n)x[P++]=D+n,x[P++]=D+n+1;x[P++]=D+E-1,x[P++]=D}var M=E*(w-1);for(n=1;C+1>n;++n)x[P++]=M,x[P++]=M+n;for(i=0;E-2>i;++i){var R=i*C+1+M,O=(i+1)*C+1+M;for(n=0;C-1>n;++n)x[P++]=O+n,x[P++]=R+n;x[P++]=O+C-1,x[P++]=R+C-1}var N=T.length/3-1;for(n=N-1;n>N-C-1;--n)x[P++]=N,x[P++]=n;var L=new l({position:new u({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:T})});return new s({attributes:L,indices:x,primitiveType:d.LINES,boundingSphere:e.fromEllipsoid(y)})},v}),r("Core/EllipsoidTerrainProvider",["./defaultValue","./defined","./defineProperties","./Ellipsoid","./Event","./GeographicTilingScheme","./HeightmapTerrainData","./TerrainProvider"],function(e,t,r,i,n,o,a,s){"use strict";var u=function(r){r=e(r,{}),this._tilingScheme=r.tilingScheme,t(this._tilingScheme)||(this._tilingScheme=new o({ellipsoid:e(r.ellipsoid,i.WGS84)})),this._levelZeroMaximumGeometricError=s.getEstimatedLevelZeroGeometricErrorForAHeightmap(this._tilingScheme.ellipsoid,64,this._tilingScheme.getNumberOfXTilesAtLevel(0));var u=16,l=16;this._terrainData=new a({buffer:new Uint8Array(u*l),width:16,height:16}),this._errorEvent=new n};return r(u.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){return void 0}},tilingScheme:{get:function(){return this._tilingScheme}},ready:{get:function(){return!0}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}}}),u.prototype.requestTileGeometry=function(e,t,r,i){return this._terrainData},u.prototype.getLevelMaximumGeometricError=function(e){return this._levelZeroMaximumGeometricError/(1<<e)},u.prototype.getTileDataAvailable=function(e,t,r){return void 0},u}),r("Core/EventHelper",["./defined","./DeveloperError"],function(e,t){"use strict";var r=function(){this._removalFunctions=[]};return r.prototype.add=function(r,i,n){if(!e(r))throw new t("event is required");var o=r.addEventListener(i,n);this._removalFunctions.push(o);var a=this;return function(){o();var e=a._removalFunctions;e.splice(e.indexOf(o),1)}},r.prototype.removeAll=function(){for(var e=this._removalFunctions,t=0,r=e.length;r>t;++t)e[t]();e.length=0},r}),r("Core/ExtrapolationType",["./freezeObject"],function(e){"use strict";var t={NONE:0,HOLD:1,EXTRAPOLATE:2};return e(t)}),r("Core/GeometryInstanceAttribute",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var i=function(i){if(i=e(i,e.EMPTY_OBJECT),!t(i.componentDatatype))throw new r("options.componentDatatype is required.");if(!t(i.componentsPerAttribute))throw new r("options.componentsPerAttribute is required.");if(i.componentsPerAttribute<1||i.componentsPerAttribute>4)throw new r("options.componentsPerAttribute must be between 1 and 4.");if(!t(i.value))throw new r("options.value is required.");this.componentDatatype=i.componentDatatype,this.componentsPerAttribute=i.componentsPerAttribute,this.normalize=e(i.normalize,!1),this.value=i.value};return i}),r("Core/getFilenameFromUri",["../ThirdParty/Uri","./defined","./DeveloperError"],function(e,t,r){"use strict";var i=function(i){if(!t(i))throw new r("uri is required.");var n=new e(i);n.normalize();var o=n.path,a=o.lastIndexOf("/");return-1!==a&&(o=o.substr(a+1)),o};return i}),r("Core/getStringFromTypedArray",["./defined","./DeveloperError"],function(e,t){"use strict";var r=function(i){if(!e(i))throw new t("uint8Array is required.");return r.decode(i)};return r.decodeWithTextDecoder=function(e){var t=new TextDecoder("utf-8");return t.decode(e)},r.decodeWithFromCharCode=function(e){for(var t="",r=e.length,i=0;r>i;++i)t+=String.fromCharCode(e[i]);return t},"undefined"!=typeof TextDecoder?r.decode=r.decodeWithTextDecoder:r.decode=r.decodeWithFromCharCode,r}),r("Core/HeadingPitchRange",["./defaultValue","./defined"],function(e,t){"use strict";var r=function(t,r,i){this.heading=e(t,0),this.pitch=e(r,0),this.range=e(i,0)};return r.clone=function(e,i){return t(e)?(t(i)||(i=new r),i.heading=e.heading,i.pitch=e.pitch,i.range=e.range,i):void 0},r}),r("Core/HermitePolynomialApproximation",["./defaultValue","./defined","./DeveloperError","./Math"],function(e,t,r,i){"use strict";function n(e,t,r,i,o,a){var s,u,l,c=0;if(i>0){for(u=0;o>u;u++){for(s=!1,l=0;l<a.length&&!s;l++)u===a[l]&&(s=!0);s||(a.push(u),c+=n(e,t,r,i-1,o,a),a.splice(a.length-1,1))}return c}for(c=1,u=0;o>u;u++){for(s=!1,l=0;l<a.length&&!s;l++)u===a[l]&&(s=!0);s||(c*=e-r[t[u]])}return c}function o(e,t,r,n,o,a){for(var s,u,l=-1,c=t.length,h=c*(c+1)/2,d=0;o>d;d++){var m=Math.floor(d*h);for(s=0;c>s;s++)u=t[s]*o*(a+1)+d,e[m+s]=n[u];for(var p=1;c>p;p++){var f=0,v=Math.floor(p*(1-p)/2)+c*p,g=!1;for(s=0;c-p>s;s++){var _,y,w=r[t[s]],C=r[t[s+p]];if(0>=C-w)u=t[s]*o*(a+1)+o*p+d,_=n[u],y=_/i.factorial(p),e[m+v+f]=y,f++;else{var E=Math.floor((p-1)*(2-p)/2)+c*(p-1);_=e[m+E+s+1]-e[m+E+s],y=_/(C-w),e[m+v+f]=y,f++}g=g||0!==_}g&&(l=Math.max(l,p))}}return l}var a=i.factorial,s={type:"Hermite"};s.getRequiredDataPoints=function(i,n){if(n=e(n,0),!t(i))throw new r("degree is required.");if(0>i)throw new r("degree must be 0 or greater.");if(0>n)throw new r("inputOrder must be 0 or greater.");return Math.max(Math.floor((i+1)/(n+1)),2)},s.interpolateOrderZero=function(e,r,i,o,s){t(s)||(s=new Array(o));var u,l,c,h,d,m,p=r.length,f=new Array(o);for(u=0;o>u;u++){s[u]=0;var v=new Array(p);for(f[u]=v,l=0;p>l;l++)v[l]=[]}var g=p,_=new Array(g);for(u=0;g>u;u++)_[u]=u;var y=p-1;for(h=0;o>h;h++){for(l=0;g>l;l++)m=_[l]*o+h,f[h][0].push(i[m]);for(u=1;g>u;u++){var w=!1;for(l=0;g-u>l;l++){var C,E=r[_[l]],S=r[_[l+u]];0>=S-E?(m=_[l]*o+o*u+h,C=i[m],f[h][u].push(C/a(u))):(C=f[h][u-1][l+1]-f[h][u-1][l],f[h][u].push(C/(S-E))),w=w||0!==C}w||(y=u-1)}}for(c=0,d=0;d>=c;c++)for(u=c;y>=u;u++){var b=n(e,_,r,c,u,[]);for(h=0;o>h;h++){var T=f[h][u][0];s[h+c*o]+=T*b}}return s};var u=[];return s.interpolate=function(e,r,i,a,s,l,c){var h=a*(l+1);t(c)||(c=new Array(h));for(var d=0;h>d;d++)c[d]=0;for(var m=r.length,p=new Array(m*(s+1)),f=0;m>f;f++)for(var v=0;s+1>v;v++)p[f*(s+1)+v]=f;for(var g=p.length,_=u,y=o(_,p,r,i,a,s),w=[],C=g*(g+1)/2,E=Math.min(y,l),S=0;E>=S;S++)for(f=S;y>=f;f++){w.length=0;for(var b=n(e,p,r,S,f,w),T=Math.floor(f*(1-f)/2)+g*f,x=0;a>x;x++){var P=Math.floor(x*C),A=_[P+T];c[x+S*a]+=A*b}}return c},s}),r("Core/IauOrientationParameters",[],function(){"use strict";var e=function(e,t,r,i){this.rightAscension=e,this.declination=t,this.rotation=r,this.rotationRate=i};return e}),r("Core/Iau2000Orientation",["./defined","./IauOrientationParameters","./JulianDate","./Math","./TimeConstants"],function(e,t,r,i,n){"use strict";var o={},a=32.184,s=2451545,u=-.0529921,l=-.1059842,c=13.0120009,h=13.3407154,d=.9856003,m=26.4057084,p=13.064993,f=.3287146,v=1.7484877,g=-.1589763,_=.0036096,y=.1643573,w=12.9590088,C=new r;return o.ComputeMoon=function(o,E){e(o)||(o=r.now()),C=r.addSeconds(o,a,C);var S=r.totalDays(C)-s,b=S/n.DAYS_PER_JULIAN_CENTURY,T=(125.045+u*S)*i.RADIANS_PER_DEGREE,x=(250.089+l*S)*i.RADIANS_PER_DEGREE,P=(260.008+c*S)*i.RADIANS_PER_DEGREE,A=(176.625+h*S)*i.RADIANS_PER_DEGREE,I=(357.529+d*S)*i.RADIANS_PER_DEGREE,D=(311.589+m*S)*i.RADIANS_PER_DEGREE,M=(134.963+p*S)*i.RADIANS_PER_DEGREE,R=(276.617+f*S)*i.RADIANS_PER_DEGREE,O=(34.226+v*S)*i.RADIANS_PER_DEGREE,N=(15.134+g*S)*i.RADIANS_PER_DEGREE,L=(119.743+_*S)*i.RADIANS_PER_DEGREE,F=(239.961+y*S)*i.RADIANS_PER_DEGREE,B=(25.053+w*S)*i.RADIANS_PER_DEGREE,z=Math.sin(T),V=Math.sin(x),k=Math.sin(P),U=Math.sin(A),q=Math.sin(I),G=Math.sin(D),W=Math.sin(M),H=Math.sin(R),j=Math.sin(O),Y=Math.sin(N),X=Math.sin(L),Z=Math.sin(F),K=Math.sin(B),Q=Math.cos(T),J=Math.cos(x),$=Math.cos(P),ee=Math.cos(A),te=Math.cos(I),re=Math.cos(D),ie=Math.cos(M),ne=Math.cos(R),oe=Math.cos(O),ae=Math.cos(N),se=Math.cos(L),ue=Math.cos(F),le=Math.cos(B),ce=(269.9949+.0031*b-3.8787*z-.1204*V+.07*k-.0172*U+.0072*G-.0052*Y+.0043*K)*i.RADIANS_PER_DEGREE,he=(66.5392+.013*b+1.5419*Q+.0239*J-.0278*$+.0068*ee-.0029*re+9e-4*ie+8e-4*ae-9e-4*le)*i.RADIANS_PER_DEGREE,de=(38.3213+13.17635815*S-1.4e-12*S*S+3.561*z+.1208*V-.0642*k+.0158*U+.0252*q-.0066*G-.0047*W-.0046*H+.0028*j+.0052*Y+.004*X+.0019*Z-.0044*K)*i.RADIANS_PER_DEGREE,me=(13.17635815-2.8e-12*S+3.561*Q*u+.1208*J*l-.0642*$*c+.0158*ee*h+.0252*te*d-.0066*re*m-.0047*ie*p-.0046*ne*f+.0028*oe*v+.0052*ae*g+.004*se*_+.0019*ue*y-.0044*le*w)/86400*i.RADIANS_PER_DEGREE;return e(E)||(E=new t),E.rightAscension=ce,E.declination=he,E.rotation=de,E.rotationRate=me,E},o}),r("Core/IauOrientationAxes",["./Cartesian3","./defined","./Iau2000Orientation","./JulianDate","./Math","./Matrix3","./Quaternion"],function(e,t,r,i,n,o,a){"use strict";function s(r,i,a){var s=l;s.x=Math.cos(r+n.PI_OVER_TWO),s.y=Math.sin(r+n.PI_OVER_TWO),s.z=0;var u=Math.cos(i),d=h;d.x=u*Math.cos(r),d.y=u*Math.sin(r),d.z=Math.sin(i);var m=e.cross(d,s,c);return t(a)||(a=new o),a[0]=s.x,a[1]=m.x,a[2]=d.x,a[3]=s.y,a[4]=m.y,a[5]=d.y,a[6]=s.z,a[7]=m.z,a[8]=d.z,a}var u=function(e){t(e)&&"function"==typeof e||(e=r.ComputeMoon),this._computeFunction=e},l=new e,c=new e,h=new e,d=new o,m=new a;return u.prototype.evaluate=function(r,u){t(r)||(r=i.now());var l=this._computeFunction(r),c=s(l.rightAscension,l.declination,u),h=n.zeroToTwoPi(l.rotation),p=a.fromAxisAngle(e.UNIT_Z,h,m),f=o.fromQuaternion(a.conjugate(p,p),d),v=o.multiply(f,c,c);return v},u}),r("Core/InterpolationAlgorithm",["./DeveloperError"],function(e){"use strict";var t={};return t.type=void 0,t.getRequiredDataPoints=e.throwInstantiationError,t.interpolateOrderZero=e.throwInstantiationError,t.interpolate=e.throwInstantiationError,t}),r("Core/TimeInterval",["./defaultValue","./defined","./defineProperties","./DeveloperError","./freezeObject","./JulianDate"],function(e,t,r,i,n,o){"use strict";var a=function(r){r=e(r,e.EMPTY_OBJECT),this.start=t(r.start)?o.clone(r.start):new o,this.stop=t(r.stop)?o.clone(r.stop):new o,this.data=r.data,this.isStartIncluded=e(r.isStartIncluded,!0),this.isStopIncluded=e(r.isStopIncluded,!0)};r(a.prototype,{isEmpty:{get:function(){var e=o.compare(this.stop,this.start);return 0>e||0===e&&(!this.isStartIncluded||!this.isStopIncluded)}}});var s={start:void 0,stop:void 0,isStartIncluded:void 0,isStopIncluded:void 0,data:void 0};return a.fromIso8601=function(r,n){if(!t(r))throw new i("options is required.");if(!t(r.iso8601))throw new i("options.iso8601 is required.");var u=r.iso8601.split("/"),l=o.fromIso8601(u[0]),c=o.fromIso8601(u[1]),h=e(r.isStartIncluded,!0),d=e(r.isStopIncluded,!0),m=r.data;return t(n)?(n.start=l,n.stop=c,n.isStartIncluded=h,n.isStopIncluded=d,n.data=m,n):(s.start=l,s.stop=c,s.isStartIncluded=h,s.isStopIncluded=d,s.data=m,new a(s))},a.toIso8601=function(e,r){if(!t(e))throw new i("timeInterval is required.");return o.toIso8601(e.start,r)+"/"+o.toIso8601(e.stop,r)},a.clone=function(e,r){return t(e)?t(r)?(r.start=e.start,r.stop=e.stop,r.isStartIncluded=e.isStartIncluded,r.isStopIncluded=e.isStopIncluded,r.data=e.data,r):new a(e):void 0},a.equals=function(e,r,i){return e===r||t(e)&&t(r)&&(e.isEmpty&&r.isEmpty||e.isStartIncluded===r.isStartIncluded&&e.isStopIncluded===r.isStopIncluded&&o.equals(e.start,r.start)&&o.equals(e.stop,r.stop)&&(e.data===r.data||t(i)&&i(e.data,r.data)))},a.equalsEpsilon=function(e,r,n,a){if("number"!=typeof n)throw new i("epsilon is required and must be a number.");return e===r||t(e)&&t(r)&&(e.isEmpty&&r.isEmpty||e.isStartIncluded===r.isStartIncluded&&e.isStopIncluded===r.isStopIncluded&&o.equalsEpsilon(e.start,r.start,n)&&o.equalsEpsilon(e.stop,r.stop,n)&&(e.data===r.data||t(a)&&a(e.data,r.data)))},a.intersect=function(e,r,n,s){if(!t(e))throw new i("left is required.");if(!t(n))throw new i("result is required.");if(!t(r))return a.clone(a.EMPTY,n);var u=e.start,l=e.stop,c=r.start,h=r.stop,d=o.greaterThanOrEquals(c,u)&&o.greaterThanOrEquals(l,c),m=!d&&o.lessThanOrEquals(c,u)&&o.lessThanOrEquals(u,h);if(!d&&!m)return a.clone(a.EMPTY,n);var p=e.isStartIncluded,f=e.isStopIncluded,v=r.isStartIncluded,g=r.isStopIncluded,_=o.lessThan(l,h);return n.start=d?c:u,n.isStartIncluded=p&&v||!o.equals(c,u)&&(d&&v||m&&p),n.stop=_?l:h,n.isStopIncluded=_?f:f&&g||!o.equals(h,l)&&g,n.data=t(s)?s(e.data,r.data):e.data,n},a.contains=function(e,r){if(!t(e))throw new i("timeInterval is required.");if(!t(r))throw new i("julianDate is required.");if(e.isEmpty)return!1;var n=o.compare(e.start,r);if(0===n)return e.isStartIncluded;var a=o.compare(r,e.stop);return 0===a?e.isStopIncluded:0>n&&0>a},a.prototype.clone=function(e){return a.clone(this,e)},a.prototype.equals=function(e,t){return a.equals(this,e,t)},a.prototype.equalsEpsilon=function(e,t,r){return a.equalsEpsilon(this,e,t,r)},a.prototype.toString=function(){return a.toIso8601(this)},a.EMPTY=n(new a({start:new o,stop:new o,isStartIncluded:!1,isStopIncluded:!1})),a}),r("Core/Iso8601",["./freezeObject","./JulianDate","./TimeInterval"],function(e,t,r){"use strict";var i=e(t.fromIso8601("0000-01-01T00:00:00Z")),n=e(t.fromIso8601("9999-12-31T24:00:00Z")),o=e(new r({start:i,stop:n})),a={MINIMUM_VALUE:i,MAXIMUM_VALUE:n,MAXIMUM_INTERVAL:o};return a}),r("Core/objectToQuery",["./defined","./DeveloperError","./isArray"],function(e,t,r){"use strict";var i=function(i){if(!e(i))throw new t("obj is required.");var n="";for(var o in i)if(i.hasOwnProperty(o)){var a=i[o],s=encodeURIComponent(o)+"=";if(r(a))for(var u=0,l=a.length;l>u;++u)n+=s+encodeURIComponent(a[u])+"&";else n+=s+encodeURIComponent(a)+"&"}return n=n.slice(0,-1)};return i}),r("Core/queryToObject",["./defined","./DeveloperError","./isArray"],function(e,t,r){"use strict";var i=function(i){if(!e(i))throw new t("queryString is required.");var n={};if(""===i)return n;for(var o=i.replace(/\+/g,"%20").split("&"),a=0,s=o.length;s>a;++a){var u=o[a].split("="),l=decodeURIComponent(u[0]),c=u[1];c=e(c)?decodeURIComponent(c):"";var h=n[l];"string"==typeof h?n[l]=[h,c]:r(h)?h.push(c):n[l]=c}return n};return i}),r("Core/loadJsonp",["../ThirdParty/Uri","../ThirdParty/when","./combine","./defaultValue","./defined","./DeveloperError","./objectToQuery","./queryToObject"],function(e,t,r,i,n,o,a,s){"use strict";var u=function(l,c){if(!n(l))throw new o("url is required.");c=i(c,i.EMPTY_OBJECT);var h;do h="loadJsonp"+Math.random().toString().substring(2,8);while(n(window[h]));var d=t.defer();window[h]=function(e){d.resolve(e);try{delete window[h]}catch(t){window[h]=void 0}};var m=new e(l),p=s(i(m.query,""));n(c.parameters)&&(p=r(c.parameters,p));var f=i(c.callbackParameterName,"callback");p[f]=h,m.query=a(p),l=m.toString();var v=c.proxy;return n(v)&&(l=v.getURL(l)),u.loadAndExecuteScript(l,h,d),d.promise};return u.loadAndExecuteScript=function(e,t,r){var i=document.createElement("script");i.async=!0,i.src=e;var n=document.getElementsByTagName("head")[0];i.onload=function(){i.onload=void 0,n.removeChild(i)},i.onerror=function(e){r.reject(e)},n.appendChild(i)},u.defaultLoadAndExecuteScript=u.loadAndExecuteScript,u}),r("Core/jsonp",["./deprecationWarning","./loadJsonp"],function(e,t){"use strict";var r=function(r,i){e("jsonp","jsonp is deprecated. Use loadJsonp instead."),t(r,i)};return r.loadAndExecuteScript=function(e,r,i){t.loadAndExecuteScript(e,r,i)},r.defaultLoadAndExecuteScript=r.loadAndExecuteScript,r}),r("Core/KeyboardEventModifier",["./freezeObject"],function(e){"use strict";var t={SHIFT:0,CTRL:1,ALT:2};return e(t)}),r("Core/LagrangePolynomialApproximation",["./defined"],function(e){"use strict";var t={type:"Lagrange"};return t.getRequiredDataPoints=function(e){return Math.max(e+1,2)},t.interpolateOrderZero=function(t,r,i,n,o){e(o)||(o=new Array(n));var a,s,u=r.length;for(a=0;n>a;a++)o[a]=0;for(a=0;u>a;a++){var l=1;for(s=0;u>s;s++)if(s!==a){var c=r[a]-r[s];l*=(t-r[s])/c}for(s=0;n>s;s++)o[s]+=l*i[a*n+s]}return o},t}),r("Core/LinearApproximation",["./defined","./DeveloperError"],function(e,t){"use strict";var r={type:"Linear"};return r.getRequiredDataPoints=function(e){return 2},r.interpolateOrderZero=function(r,i,n,o,a){if(2!==i.length)throw new t("The xTable provided to the linear interpolator must have exactly two elements.");if(0>=o)throw new t("There must be at least 1 dependent variable for each independent variable.");e(a)||(a=new Array(o));var s,u,l,c=i[0],h=i[1];if(c===h)throw new t("Divide by zero error: xTable[0] and xTable[1] are equal");for(s=0;o>s;s++)u=n[s],l=n[s+o],a[s]=((l-u)*r+h*u-c*l)/(h-c);return a},r}),r("Core/loadBlob",["./loadWithXhr"],function(e){"use strict";var t=function(t,r){return e({url:t,responseType:"blob",headers:r})};return t}),r("Core/loadImageFromTypedArray",["../ThirdParty/when","./defined","./DeveloperError","./loadImage"],function(e,t,r,i){"use strict";var n=function(n,o){if(!t(n))throw new r("uint8Array is required.");if(!t(o))throw new r("format is required.");var a=new Blob([n],{type:o}),s=window.URL.createObjectURL(a);return i(s,!1).then(function(e){return window.URL.revokeObjectURL(s),e},function(t){return window.URL.revokeObjectURL(s),e.reject(t)})};return n}),r("Core/loadImageViaBlob",["../ThirdParty/when","./loadBlob","./loadImage"],function(e,t,r){"use strict";var i=/^data:/,n=function(n){return i.test(n)?r(n):t(n).then(function(t){var i=window.URL.createObjectURL(t);return r(i,!1).then(function(e){return e.blob=t,window.URL.revokeObjectURL(i),e},function(t){return window.URL.revokeObjectURL(i),e.reject(t)})})},o=function(){try{var e=new XMLHttpRequest;return e.open("GET","#",!0),e.responseType="blob","blob"===e.responseType}catch(t){return!1}}();return o?n:r}),r("Core/loadXML",["./loadWithXhr"],function(e){"use strict";var t=function(t,r){return e({url:t,responseType:"document",headers:r,overrideMimeType:"text/xml"})};return t}),r("Core/MapboxApi",["./defined"],function(e){"use strict";var t={};t.defaultAccessToken=void 0;var r=!1;return t.getAccessToken=function(i){return e(i)?i:e(t.defaultAccessToken)?t.defaultAccessToken:(r||(console.log("This application is using Cesium's default Mapbox access token.  Please create a new access token for the application as soon as possible and prior to deployment by visiting https://www.mapbox.com/account/apps/, and provide your token to Cesium by setting the Cesium.MapboxApi.defaultAccessToken property before constructing the CesiumWidget or any other object that uses the Mapbox API."),r=!0),"pk.eyJ1IjoiYW5hbHl0aWNhbGdyYXBoaWNzIiwiYSI6IjA2YzBjOTM3YzFlYzljYmQ5NDAxZWI1Y2ZjNzZlM2E1In0.vDZL2SPFEpi_f7ziAIP_yw")},t}),r("Core/MapProjection",["./defineProperties","./DeveloperError"],function(e,t){"use strict";var r=function(){t.throwInstantiationError()};return e(r.prototype,{ellipsoid:{get:t.throwInstantiationError}}),r.prototype.project=t.throwInstantiationError,r.prototype.unproject=t.throwInstantiationError,r}),r("Core/Matrix2",["./Cartesian2","./defaultValue","./defined","./DeveloperError","./freezeObject"],function(e,t,r,i,n){"use strict";var o=function(e,r,i,n){this[0]=t(e,0),this[1]=t(i,0),this[2]=t(r,0),this[3]=t(n,0)};o.packedLength=4,o.pack=function(e,n,o){if(!r(e))throw new i("value is required");if(!r(n))throw new i("array is required");o=t(o,0),n[o++]=e[0],n[o++]=e[1],n[o++]=e[2],n[o++]=e[3]},o.unpack=function(e,n,a){if(!r(e))throw new i("array is required");return n=t(n,0),r(a)||(a=new o),a[0]=e[n++],a[1]=e[n++],a[2]=e[n++],a[3]=e[n++],a},o.clone=function(e,t){return r(e)?r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):new o(e[0],e[2],e[1],e[3]):void 0},o.fromArray=function(e,n,a){if(!r(e))throw new i("array is required");return n=t(n,0),r(a)||(a=new o),a[0]=e[n],a[1]=e[n+1],a[2]=e[n+2],a[3]=e[n+3],a},o.fromColumnMajorArray=function(e,t){if(!r(e))throw new i("values parameter is required");return o.clone(e,t)},o.fromRowMajorArray=function(e,t){if(!r(e))throw new i("values is required.");return r(t)?(t[0]=e[0],t[1]=e[2],t[2]=e[1],t[3]=e[3],t):new o(e[0],e[1],e[2],e[3])},o.fromScale=function(e,t){if(!r(e))throw new i("scale is required.");return r(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=e.y,t):new o(e.x,0,0,e.y)},o.fromUniformScale=function(e,t){if("number"!=typeof e)throw new i("scale is required.");return r(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=e,t):new o(e,0,0,e)},o.fromRotation=function(e,t){if(!r(e))throw new i("angle is required.");var n=Math.cos(e),a=Math.sin(e);return r(t)?(t[0]=n,t[1]=a,t[2]=-a,t[3]=n,t):new o(n,-a,a,n)},o.toArray=function(e,t){if(!r(e))throw new i("matrix is required");return r(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t):[e[0],e[1],e[2],e[3]]},o.getElementIndex=function(e,t){if("number"!=typeof t||0>t||t>1)throw new i("row must be 0 or 1.");if("number"!=typeof e||0>e||e>1)throw new i("column must be 0 or 1.");return 2*e+t},o.getColumn=function(e,t,n){if(!r(e))throw new i("matrix is required.");if("number"!=typeof t||0>t||t>1)throw new i("index must be 0 or 1.");if(!r(n))throw new i("result is required");var o=2*t,a=e[o],s=e[o+1];return n.x=a,n.y=s,n},o.setColumn=function(e,t,n,a){if(!r(e))throw new i("matrix is required");if(!r(n))throw new i("cartesian is required");if("number"!=typeof t||0>t||t>1)throw new i("index must be 0 or 1.");if(!r(a))throw new i("result is required");a=o.clone(e,a);var s=2*t;return a[s]=n.x,a[s+1]=n.y,a},o.getRow=function(e,t,n){if(!r(e))throw new i("matrix is required.");if("number"!=typeof t||0>t||t>1)throw new i("index must be 0 or 1.");if(!r(n))throw new i("result is required");var o=e[t],a=e[t+2];return n.x=o,n.y=a,n},o.setRow=function(e,t,n,a){if(!r(e))throw new i("matrix is required");if(!r(n))throw new i("cartesian is required");if("number"!=typeof t||0>t||t>1)throw new i("index must be 0 or 1.");if(!r(a))throw new i("result is required");return a=o.clone(e,a),a[t]=n.x,a[t+2]=n.y,a};var a=new e;o.getScale=function(t,n){if(!r(t))throw new i("matrix is required.");if(!r(n))throw new i("result is required");return n.x=e.magnitude(e.fromElements(t[0],t[1],a)),n.y=e.magnitude(e.fromElements(t[2],t[3],a)),n};var s=new e;return o.getMaximumScale=function(t){return o.getScale(t,s),e.maximumComponent(s)},o.multiply=function(e,t,n){if(!r(e))throw new i("left is required");if(!r(t))throw new i("right is required");if(!r(n))throw new i("result is required");var o=e[0]*t[0]+e[2]*t[1],a=e[0]*t[2]+e[2]*t[3],s=e[1]*t[0]+e[3]*t[1],u=e[1]*t[2]+e[3]*t[3];return n[0]=o,n[1]=s,n[2]=a,n[3]=u,n},o.add=function(e,t,n){if(!r(e))throw new i("left is required");if(!r(t))throw new i("right is required");if(!r(n))throw new i("result is required");return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n},o.subtract=function(e,t,n){if(!r(e))throw new i("left is required");if(!r(t))throw new i("right is required");if(!r(n))throw new i("result is required");return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n},o.multiplyByVector=function(e,t,n){if(!r(e))throw new i("matrix is required");if(!r(t))throw new i("cartesian is required");if(!r(n))throw new i("result is required");var o=e[0]*t.x+e[2]*t.y,a=e[1]*t.x+e[3]*t.y;return n.x=o,n.y=a,n},o.multiplyByScalar=function(e,t,n){if(!r(e))throw new i("matrix is required");if("number"!=typeof t)throw new i("scalar is required and must be a number");if(!r(n))throw new i("result is required");return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n},o.multiplyByScale=function(e,t,n){if(!r(e))throw new i("matrix is required");if(!r(t))throw new i("scale is required");if(!r(n))throw new i("result is required");return n[0]=e[0]*t.x,n[1]=e[1]*t.x,n[2]=e[2]*t.y,n[3]=e[3]*t.y,n},o.negate=function(e,t){if(!r(e))throw new i("matrix is required");if(!r(t))throw new i("result is required");return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t},o.transpose=function(e,t){if(!r(e))throw new i("matrix is required");if(!r(t))throw new i("result is required");var n=e[0],o=e[2],a=e[1],s=e[3];return t[0]=n,t[1]=o,t[2]=a,t[3]=s,t},o.abs=function(e,t){if(!r(e))throw new i("matrix is required");if(!r(t))throw new i("result is required");return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t},o.equals=function(e,t){return e===t||r(e)&&r(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]},o.equalsArray=function(e,t,r){return e[0]===t[r]&&e[1]===t[r+1]&&e[2]===t[r+2]&&e[3]===t[r+3]},o.equalsEpsilon=function(e,t,n){if("number"!=typeof n)throw new i("epsilon must be a number");return e===t||r(e)&&r(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n},o.IDENTITY=n(new o(1,0,0,1)),o.ZERO=n(new o(0,0,0,0)),o.COLUMN0ROW0=0,o.COLUMN0ROW1=1,o.COLUMN1ROW0=2,o.COLUMN1ROW1=3,o.prototype.clone=function(e){return o.clone(this,e)},o.prototype.equals=function(e){return o.equals(this,e)},o.prototype.equalsEpsilon=function(e,t){return o.equalsEpsilon(this,e,t)},o.prototype.toString=function(){return"("+this[0]+", "+this[2]+")\n("+this[1]+", "+this[3]+")"},o}),r("Core/mergeSort",["./defined","./DeveloperError"],function(e,t){"use strict";function r(e,t,r,i,a,s){var u,l,c=a-i+1,h=s-a,d=n,m=o;for(u=0;c>u;++u)d[u]=e[i+u];for(l=0;h>l;++l)m[l]=e[a+l+1];u=0,l=0;for(var p=i;s>=p;++p){var f=d[u],v=m[l];c>u&&(l>=h||t(f,v,r)<=0)?(e[p]=f,++u):h>l&&(e[p]=v,++l)}}function i(e,t,n,o,a){
if(!(o>=a)){var s=Math.floor(.5*(o+a));i(e,t,n,o,s),i(e,t,n,s+1,a),r(e,t,n,o,s,a)}}var n=[],o=[],a=function(r,a,s){if(!e(r))throw new t("array is required.");if(!e(a))throw new t("comparator is required.");var u=r.length,l=Math.ceil(.5*u);n.length=l,o.length=l,i(r,a,s,0,u-1),n.length=0,o.length=0};return a}),r("Core/NearFarScalar",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var i=function(t,r,i,n){this.near=e(t,0),this.nearValue=e(r,0),this.far=e(i,1),this.farValue=e(n,0)};return i.clone=function(e,r){return t(e)?t(r)?(r.near=e.near,r.nearValue=e.nearValue,r.far=e.far,r.farValue=e.farValue,r):new i(e.near,e.nearValue,e.far,e.farValue):void 0},i.packedLength=4,i.pack=function(i,n,o){if(!t(i))throw new r("value is required");if(!t(n))throw new r("array is required");o=e(o,0),n[o++]=i.near,n[o++]=i.nearValue,n[o++]=i.far,n[o]=i.farValue},i.unpack=function(n,o,a){if(!t(n))throw new r("array is required");return o=e(o,0),t(a)||(a=new i),a.near=n[o++],a.nearValue=n[o++],a.far=n[o++],a.farValue=n[o],a},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.near===r.near&&e.nearValue===r.nearValue&&e.far===r.far&&e.farValue===r.farValue},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equals=function(e){return i.equals(this,e)},i}),r("Core/Visibility",["./freezeObject"],function(e){"use strict";var t={NONE:-1,PARTIAL:0,FULL:1};return e(t)}),r("Core/Occluder",["./BoundingSphere","./Cartesian3","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math","./Rectangle","./Visibility"],function(e,t,r,i,n,o,a,s,u,l){"use strict";var c=function(e,r){if(!i(e))throw new o("occluderBoundingSphere is required.");if(!i(r))throw new o("camera position is required.");this._occluderPosition=t.clone(e.center),this._occluderRadius=e.radius,this._horizonDistance=0,this._horizonPlaneNormal=void 0,this._horizonPlanePosition=void 0,this._cameraPosition=void 0,this.cameraPosition=r},h=new t;n(c.prototype,{position:{get:function(){return this._occluderPosition}},radius:{get:function(){return this._occluderRadius}},cameraPosition:{set:function(e){if(!i(e))throw new o("cameraPosition is required.");e=t.clone(e,this._cameraPosition);var r,n,a,s=t.subtract(this._occluderPosition,e,h),u=t.magnitudeSquared(s),l=this._occluderRadius*this._occluderRadius;if(u>l){r=Math.sqrt(u-l),u=1/Math.sqrt(u),n=t.multiplyByScalar(s,u,h);var c=r*r*u;a=t.add(e,t.multiplyByScalar(n,c,h),h)}else r=Number.MAX_VALUE;this._horizonDistance=r,this._horizonPlaneNormal=n,this._horizonPlanePosition=a,this._cameraPosition=e}}}),c.fromBoundingSphere=function(e,r,n){if(!i(e))throw new o("occluderBoundingSphere is required.");if(!i(r))throw new o("camera position is required.");return i(n)?(t.clone(e.center,n._occluderPosition),n._occluderRadius=e.radius,n.cameraPosition=r,n):new c(e,r)};var d=new t;c.prototype.isPointVisible=function(e){if(this._horizonDistance!==Number.MAX_VALUE){var r=t.subtract(e,this._occluderPosition,d),i=this._occluderRadius;if(i=t.magnitudeSquared(r)-i*i,i>0)return i=Math.sqrt(i)+this._horizonDistance,r=t.subtract(e,this._cameraPosition,r),i*i>t.magnitudeSquared(r)}return!1};var m=new t;c.prototype.isBoundingSphereVisible=function(e){var r=t.clone(e.center,m),i=e.radius;if(this._horizonDistance!==Number.MAX_VALUE){var n=t.subtract(r,this._occluderPosition,d),o=this._occluderRadius-i;if(o=t.magnitudeSquared(n)-o*o,i<this._occluderRadius)return o>0?(o=Math.sqrt(o)+this._horizonDistance,n=t.subtract(r,this._cameraPosition,n),o*o+i*i>t.magnitudeSquared(n)):!1;if(o>0){n=t.subtract(r,this._cameraPosition,n);var a=t.magnitudeSquared(n),s=this._occluderRadius*this._occluderRadius,u=i*i;return(this._horizonDistance*this._horizonDistance+s)*u>a*s?!0:(o=Math.sqrt(o)+this._horizonDistance,o*o+u>a)}return!0}return!1};var p=new t;c.prototype.computeVisibility=function(e){if(!i(e))throw new o("occludeeBS is required.");var r=t.clone(e.center),n=e.radius;if(n>this._occluderRadius)return l.FULL;if(this._horizonDistance!==Number.MAX_VALUE){var a=t.subtract(r,this._occluderPosition,p),s=this._occluderRadius-n,u=t.magnitudeSquared(a);if(s=u-s*s,s>0){s=Math.sqrt(s)+this._horizonDistance,a=t.subtract(r,this._cameraPosition,a);var c=t.magnitudeSquared(a);return c>s*s+n*n?l.NONE:(s=this._occluderRadius+n,s=u-s*s,s>0?(s=Math.sqrt(s)+this._horizonDistance,s*s+n*n>c?l.FULL:l.PARTIAL):(a=t.subtract(r,this._horizonPlanePosition,a),t.dot(a,this._horizonPlaneNormal)>-n?l.PARTIAL:l.FULL))}}return l.NONE};var f=new t;c.computeOccludeePoint=function(e,r,n){if(!i(e))throw new o("occluderBoundingSphere is required.");if(!i(n))throw new o("positions is required.");if(0===n.length)throw new o("positions must contain at least one element");var a=t.clone(r),s=t.clone(e.center),u=e.radius,l=n.length;if(t.equals(s,r))throw new o("occludeePosition must be different than occluderBoundingSphere.center");var h=t.normalize(t.subtract(a,s,f),f),d=-t.dot(h,s),m=c._anyRotationVector(s,h,d),p=c._horizonToPlaneNormalDotProduct(e,h,d,m,n[0]);if(!p)return void 0;for(var v,g=1;l>g;++g){if(v=c._horizonToPlaneNormalDotProduct(e,h,d,m,n[g]),!v)return void 0;p>v&&(p=v)}if(.0017453283658983088>p)return void 0;var _=u/p;return t.add(s,t.multiplyByScalar(h,_,f),f)};var v=[];c.computeOccludeePointFromRectangle=function(n,s){if(!i(n))throw new o("rectangle is required.");s=r(s,a.WGS84);var l=u.subsample(n,s,0,v),h=e.fromPoints(l),d=t.ZERO;return t.equals(d,h.center)?void 0:c.computeOccludeePoint(new e(d,s.minimumRadius),h.center,l)};var g=new t;c._anyRotationVector=function(e,r,i){var n=t.abs(r,g),o=n.x>n.y?0:1;(0===o&&n.z>n.x||1===o&&n.z>n.y)&&(o=2);var a,s=new t;0===o?(n.x=e.x,n.y=e.y+1,n.z=e.z+1,a=t.UNIT_X):1===o?(n.x=e.x+1,n.y=e.y,n.z=e.z+1,a=t.UNIT_Y):(n.x=e.x+1,n.y=e.y+1,n.z=e.z,a=t.UNIT_Z);var u=(t.dot(r,n)+i)/-t.dot(r,a);return t.normalize(t.subtract(t.add(n,t.multiplyByScalar(a,u,s),n),e,n),n)};var _=new t;c._rotationVector=function(e,r,i,n,o){var a=t.subtract(n,e,_);if(a=t.normalize(a,a),t.dot(r,a)<.9999999847691291){var u=t.cross(r,a,a),l=t.magnitude(u);if(l>s.EPSILON13)return t.normalize(u,new t)}return o};var y=new t,w=new t,C=new t,E=new t;return c._horizonToPlaneNormalDotProduct=function(e,r,i,n,o){var a=t.clone(o,y),s=t.clone(e.center,w),u=e.radius,l=t.subtract(s,a,C),c=t.magnitudeSquared(l),h=u*u;if(h>c)return!1;var d=c-h,m=Math.sqrt(d),p=Math.sqrt(c),f=1/p,v=m*f,g=v*m;l=t.normalize(l,l);var _=t.add(a,t.multiplyByScalar(l,g,E),E),S=Math.sqrt(d-g*g),b=this._rotationVector(s,r,i,a,n),T=t.fromElements(b.x*b.x*l.x+(b.x*b.y-b.z)*l.y+(b.x*b.z+b.y)*l.z,(b.x*b.y+b.z)*l.x+b.y*b.y*l.y+(b.y*b.z-b.x)*l.z,(b.x*b.z-b.y)*l.x+(b.y*b.z+b.x)*l.y+b.z*b.z*l.z,y);T=t.normalize(T,T);var x=t.multiplyByScalar(T,S,y);b=t.normalize(t.subtract(t.add(_,x,C),s,C),C);var P=t.dot(r,b);b=t.normalize(t.subtract(t.subtract(_,x,b),s,b),b);var A=t.dot(r,b);return A>P?P:A},c}),r("Core/Packable",["./DeveloperError"],function(e){"use strict";var t={packedLength:void 0,pack:e.throwInstantiationError,unpack:e.throwInstantiationError};return t}),r("Core/PackableForInterpolation",["./DeveloperError"],function(e){"use strict";var t={packedInterpolationLength:void 0,convertPackedArrayForInterpolation:e.throwInstantiationError,unpackInterpolationResult:e.throwInstantiationError};return t}),r("ThirdParty/measureText",[],function(){var e=function(e,t){return document.defaultView.getComputedStyle(e,null).getPropertyValue(t)},t=function(t,r,i,n){var o=t.measureText(r),a=e(t.canvas,"font-family"),s=e(t.canvas,"font-size").replace("px",""),u=!/\S/.test(r);o.fontsize=s;var l=document.createElement("div");l.style.position="absolute",l.style.opacity=0,l.style.font=s+"px "+a,l.innerHTML=r+"<br/>"+r,document.body.appendChild(l),o.leading=1.2*s;var c=e(l,"height");if(c=c.replace("px",""),c>=2*s&&(o.leading=c/2|0),document.body.removeChild(l),u)o.ascent=0,o.descent=0,o.bounds={minx:0,maxx:o.width,miny:0,maxy:0},o.height=0;else{var h=document.createElement("canvas"),d=100;h.width=o.width+d,h.height=3*s,h.style.opacity=1,h.style.fontFamily=a,h.style.fontSize=s;var m=h.getContext("2d");m.font=s+"px "+a;var p=h.width,f=h.height,v=f/2;m.fillStyle="white",m.fillRect(-1,-1,p+2,f+2),i&&(m.strokeStyle="black",m.lineWidth=t.lineWidth,m.strokeText(r,d/2,v)),n&&(m.fillStyle="black",m.fillText(r,d/2,v));for(var g=m.getImageData(0,0,p,f).data,_=0,y=4*p,w=g.length;++_<w&&255===g[_];);var C=_/y|0;for(_=w-1;--_>0&&255===g[_];);var E=_/y|0;for(_=0;w>_&&255===g[_];)_+=y,_>=w&&(_=_-w+4);var S=_%y/4|0,b=1;for(_=w-3;_>=0&&255===g[_];)_-=y,0>_&&(_=w-3-4*b++);var T=_%y/4+1|0;o.ascent=v-C,o.descent=E-v,o.bounds={minx:S-d/2,maxx:T-d/2,miny:0,maxy:E-C},o.height=1+(E-C)}return o};return t}),r("Core/writeTextToCanvas",["../ThirdParty/measureText","./Color","./defaultValue","./defined","./DeveloperError"],function(e,t,r,i,n){"use strict";var o,a=function(a,s){if(!i(a))throw new n("text is required.");if(""===a)return void 0;s=r(s,r.EMPTY_OBJECT);var u=r(s.font,"10px sans-serif"),l=r(s.stroke,!1),c=r(s.fill,!0),h=r(s.strokeWidth,1),d=document.createElement("canvas");d.width=1,d.height=1,d.style.font=u;var m=d.getContext("2d");i(o)||(i(m.imageSmoothingEnabled)?o="imageSmoothingEnabled":i(m.mozImageSmoothingEnabled)?o="mozImageSmoothingEnabled":i(m.webkitImageSmoothingEnabled)?o="webkitImageSmoothingEnabled":i(m.msImageSmoothingEnabled)&&(o="msImageSmoothingEnabled")),m.font=u,m.lineJoin="round",m.lineWidth=h,m[o]=!1,m.textBaseline=r(s.textBaseline,"bottom"),d.style.visibility="hidden",document.body.appendChild(d);var p=e(m,a,l,c);p.computedWidth=Math.max(p.width,p.bounds.maxx-p.bounds.minx),d.dimensions=p,document.body.removeChild(d),d.style.visibility="";var f=p.height-p.ascent;d.width=p.computedWidth,d.height=p.height;var v=d.height-f;if(m.font=u,m.lineJoin="round",m.lineWidth=h,m[o]=!1,l){var g=r(s.strokeColor,t.BLACK);m.strokeStyle=g.toCssColorString(),m.strokeText(a,0,v)}if(c){var _=r(s.fillColor,t.WHITE);m.fillStyle=_.toCssColorString(),m.fillText(a,0,v)}return d};return a}),r("Core/PinBuilder",["./buildModuleUrl","./Color","./defined","./DeveloperError","./loadImage","./writeTextToCanvas"],function(e,t,r,i,n,o){"use strict";function a(e,t,r){e.save(),e.scale(r/24,r/24),e.fillStyle=t.toCssColorString(),e.strokeStyle=t.brighten(.6,c).toCssColorString(),e.lineWidth=.846,e.beginPath(),e.moveTo(6.72,.422),e.lineTo(17.28,.422),e.bezierCurveTo(18.553,.422,19.577,1.758,19.577,3.415),e.lineTo(19.577,10.973),e.bezierCurveTo(19.577,12.63,18.553,13.966,17.282,13.966),e.lineTo(14.386,14.008),e.lineTo(11.826,23.578),e.lineTo(9.614,14.008),e.lineTo(6.719,13.965),e.bezierCurveTo(5.446,13.983,4.422,12.629,4.422,10.972),e.lineTo(4.422,3.416),e.bezierCurveTo(4.423,1.76,5.447,.423,6.718,.423),e.closePath(),e.fill(),e.stroke(),e.restore()}function s(e,r,i){var n=i/2.5,o=n,a=n;r.width>r.height?a=n*(r.height/r.width):r.width<r.height&&(o=n*(r.width/r.height));var s=(i-o)/2,u=7/24*i-a/2;e.globalCompositeOperation="destination-out",e.drawImage(r,s-1,u,o,a),e.drawImage(r,s,u-1,o,a),e.drawImage(r,s+1,u,o,a),e.drawImage(r,s,u+1,o,a),e.globalCompositeOperation="destination-over",e.fillStyle=t.BLACK.toCssColorString(),e.fillRect(s-1,u-1,o+1,a+1),e.globalCompositeOperation="destination-out",e.drawImage(r,s,u,o,a),e.globalCompositeOperation="destination-over",e.fillStyle=t.WHITE.toCssColorString(),e.fillRect(s,u,o,a)}function u(e,t,i,u,l){h[0]=e,h[1]=t,h[2]=i,h[3]=u;var c=JSON.stringify(h),d=l[c];if(r(d))return d;var m=document.createElement("canvas");m.width=u,m.height=u;var p=m.getContext("2d");if(a(p,i,u),r(e)){var f=n(e).then(function(e){return s(p,e,u),l[c]=m,m});return l[c]=f,f}if(r(t)){var v=o(t,{font:"bold "+u+"px sans-serif"});s(p,v,u)}return l[c]=m,m}var l=function(){this._cache={}};l.prototype.fromColor=function(e,t){if(!r(e))throw new i("color is required");if(!r(t))throw new i("size is required");return u(void 0,void 0,e,t,this._cache)},l.prototype.fromUrl=function(e,t,n){if(!r(e))throw new i("url is required");if(!r(t))throw new i("color is required");if(!r(n))throw new i("size is required");return u(e,void 0,t,n,this._cache)},l.prototype.fromMakiIconId=function(t,n,o){if(!r(t))throw new i("id is required");if(!r(n))throw new i("color is required");if(!r(o))throw new i("size is required");return u(e("Assets/Textures/maki/"+encodeURIComponent(t)+".png"),void 0,n,o,this._cache)},l.prototype.fromText=function(e,t,n){if(!r(e))throw new i("text is required");if(!r(t))throw new i("color is required");if(!r(n))throw new i("size is required");return u(void 0,e,t,n,this._cache)};var c=new t,h=new Array(4);return l}),r("Core/PixelFormat",["../Renderer/WebGLConstants","./freezeObject"],function(e,t){"use strict";var r={DEPTH_COMPONENT:e.DEPTH_COMPONENT,DEPTH_STENCIL:e.DEPTH_STENCIL,ALPHA:e.ALPHA,RGB:e.RGB,RGBA:e.RGBA,LUMINANCE:e.LUMINANCE,LUMINANCE_ALPHA:e.LUMINANCE_ALPHA,validate:function(e){return e===r.DEPTH_COMPONENT||e===r.DEPTH_STENCIL||e===r.ALPHA||e===r.RGB||e===r.RGBA||e===r.LUMINANCE||e===r.LUMINANCE_ALPHA},isColorFormat:function(e){return e===r.ALPHA||e===r.RGB||e===r.RGBA||e===r.LUMINANCE||e===r.LUMINANCE_ALPHA},isDepthFormat:function(e){return e===r.DEPTH_COMPONENT||e===r.DEPTH_STENCIL}};return t(r)}),r("Core/pointInsideTriangle",["./barycentricCoordinates","./Cartesian3"],function(e,t){"use strict";var r=new t,i=function(t,i,n,o){return e(t,i,n,o,r),r.x>0&&r.y>0&&r.z>0};return i}),r("Core/Queue",[],function(){"use strict";var e=function(){this._array=[],this._offset=0,this.length=0};return e.prototype.enqueue=function(e){this._array.push(e),this.length++},e.prototype.dequeue=function(){if(0===this.length)return void 0;var e=this._array,t=this._offset,r=e[t];return e[t]=void 0,t++,t>10&&2*t>e.length&&(this._array=e.slice(t),t=0),this._offset=t,this.length--,r},e.prototype.contains=function(e){return-1!==this._array.indexOf(e)},e.prototype.clear=function(){this._array.length=this._offset=this.length=0},e.prototype.sort=function(e){this._offset>0&&(this._array=this._array.slice(this._offset),this._offset=0),this._array.sort(e)},e}),r("Core/WindingOrder",["../Renderer/WebGLConstants","./freezeObject"],function(e,t){"use strict";var r={CLOCKWISE:e.CW,COUNTER_CLOCKWISE:e.CCW,validate:function(e){return e===r.CLOCKWISE||e===r.COUNTER_CLOCKWISE}};return t(r)}),r("Core/PolygonPipeline",["./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./Math","./pointInsideTriangle","./PolylinePipeline","./PrimitiveType","./Queue","./WindingOrder"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f){"use strict";function v(t,r,i){var n=e.subtract(r,t,F),o=e.subtract(i,r,B);return n.x*o.y-n.y*o.x>=0}function g(e){for(var t=e[0].x,r=0,i=0;i<e.length;i++)e[i].x>t&&(t=e[i].x,r=i);return r}function _(e){for(var t=e[0][0].x,r=0,i=0;i<e.length;i++){var n=e[i][g(e[i])].x;n>t&&(t=n,r=i)}return r}function y(e){for(var t=[],r=0;r<e.length;r++){var i=e[(r-1+e.length)%e.length],n=e[r],o=e[(r+1)%e.length];v(i,n,o)||t.push(n)}return t}function w(t,r){for(var i=0;i<t.length;i++)if(e.equals(r,t[i]))return i;return-1}function C(r,n,o){o=i(o,[]);var a=Number.MAX_VALUE,s=g(n),u=new e(n[s].x,r.y);o.push(s),o.push((s+1)%n.length);for(var l=n[0].x,c=l,h=1;h<n.length;++h)n[h].x<l?l=n[h].x:n[h].x>c&&(c=n[h].x);c+=c-l;var d=new t(c,r.y,0);for(h=0;h<n.length;h++){var m=n[h],p=n[(h+1)%n.length];if((m.x>=r.x||p.x>=r.x)&&(m.y>=r.y&&p.y<=r.y||m.y<=r.y&&p.y>=r.y)){var f=(p.y-m.y)*(d.x-r.x)-(p.x-m.x)*(d.y-r.y);if(0!==f){f=1/f;var v=((p.x-m.x)*(r.y-m.y)-(p.y-m.y)*(r.x-m.x))*f,_=((d.x-r.x)*(r.y-m.y)-(d.y-r.y)*(r.x-m.x))*f;if(v>=0&&1>=v&&_>=0&&1>=_){var y=new e(r.x+v*(d.x-r.x),r.y+v*(d.y-r.y)),w=e.subtract(y,r,z);f=e.magnitudeSquared(w),a>f&&(u=y,a=f,o[0]=h,o[1]=(h+1)%n.length)}}}}return u}function E(t,r){var i=_(r),n=r[i],o=g(n),a=n[o],s=[],u=C(a,t,s),l=w(t,u);if(-1!==l)return l;var d=e.magnitudeSquared(e.subtract(t[s[0]],a,V)),m=e.magnitudeSquared(e.subtract(t[s[1]],a,V)),p=m>d?t[s[0]]:t[s[1]],f=y(t),v=f.indexOf(p);-1!==v&&f.splice(v,1);for(var E=[],S=0;S<f.length;S++){var b=f[S];h(b,a,u,p)&&E.push(b)}var T=Number.MAX_VALUE;if(E.length>0){var x=e.fromElements(1,0,V);for(S=0;S<E.length;S++){var P=e.subtract(E[S],a,k),A=e.magnitude(x)*e.magnitudeSquared(P);if(0!==A){var I=Math.abs(c.acosClamped(e.dot(x,P)/A));T>I&&(T=I,p=E[S])}}}return t.indexOf(p)}function S(e,r,i){for(var n=ee.computeWindingOrder2D(e),o=0;o<r.length;o++){var a=r[o];t.equals(a[0],a[a.length-1])||a.push(a[0]);var u=ee.computeWindingOrder2D(a);u===n&&a.reverse()}var l=s.fromPoints(e,i),c=l.projectPointsOntoPlane(e),h=[];for(o=0;o<r.length;o++)h.push(l.projectPointsOntoPlane(r[o]));var d=E(c,h),m=_(h),p=g(h[m]),f=r[m],v=[];for(o=0;o<e.length;o++)v.push(e[o]);var y,w=[];if(0!==p)for(y=0;y<=f.length;y++){var C=(y+p)%f.length;0!==C&&w.push(f[C])}else for(y=0;y<f.length;y++)w.push(f[(y+p)%f.length]);var S=v.lastIndexOf(e[d]);w.push(e[S]);var b=v.slice(0,S+1),T=v.slice(S+1);return v=b.concat(w,T),r.splice(m,1),v}function b(e){var t=c.nextRandomNumber(),r=Math.floor(t*e);return r===e&&r--,r}function T(e,t,r,i){var n=i[e].position,o=i[t].position,a=i[r].position,s=a.x,u=a.y,l=n.x-s,c=n.y-u,h=o.x-s,d=o.y-u;return l*d-c*h}function x(e,t){return e.x*t.y-e.y*t.x}function P(e,t){var r=t.length,i=c.mod(e-1,r),n=c.mod(e+1,r);return 0===T(i,n,e,t)?!1:!0}function A(t,r){return e.magnitudeSquared(r)<e.magnitudeSquared(t)}function I(t,r,i){if(!P(t,i))return t;var n=i[t].position,o=i[r].position,a=i.length,s=c.mod(t-1,a);if(!P(s,i))return s;var u=c.mod(t+1,a);if(!P(u,i))return u;var l=e.subtract(i[s].position,n,G),h=e.subtract(i[u].position,n,W),d=e.subtract(o,n,H),m=x(l,d),p=x(h,d);if(0===m)return A(l,d)?U:q;if(0===p)return A(h,d)?U:q;var f=x(l,h);return 0>f?0>m&&p>0?U:q:f>0?m>0&&0>p?q:U:void 0}function D(e,t,r){return(e>t||e>r)&&(t>e||r>e)||t===r&&t===e}function M(t,r,i,n){var o=e.subtract(i,t,Y),a=r.x*n.y-r.y*n.x,s=a*a,u=e.magnitudeSquared(r),l=e.magnitudeSquared(n);if(s>j*u*l){var c=(o.x*n.y-o.y*n.x)/a;return e.add(t,e.multiplyByScalar(r,c,Y),Y)}return void 0}function R(t,r,i){for(var o=e.subtract(r,t,X),a=i.length,s=0;a>s;s++){var u=i[s].position,l=i[c.mod(s+1,a)].position;if(!(e.equals(t,u)||e.equals(r,l)||e.equals(t,l)||e.equals(r,u))){var h=e.subtract(l,u,Z),d=M(t,o,u,h);if(n(d)&&!(e.equals(d,t)||e.equals(d,r)||e.equals(d,u)||e.equals(d,l))){var m=d.x,p=d.y,f=D(m,t.x,r.x)&&D(p,t.y,r.y)&&D(m,u.x,l.x)&&D(p,u.y,l.y);if(f)return!0}}}return!1}function O(t,r,i){var n=I(t,r,i);if(n>=0)return n;var o=I(r,t,i);return o>=0?o:n!==U||o!==U||R(i[t].position,i[r].position,i)||e.equals(i[t].position,i[r].position)?Q:K}function N(e){return 0===T(1,2,0,e)}function L(e){var t=e.length;if(3===t)return N(e)?[]:[e[0].index,e[1].index,e[2].index];if(e.length<3)throw new o("Invalid polygon: must have at least three vertices.");for(var r,i,n=0,a=10*e.length,s=Q;K>s&&n++<a;){for(r=b(e.length),i=r+1;Math.abs(r-i)<2||Math.abs(r-i)>e.length-2;)i=b(e.length);if(r>i){var u=r;r=i,i=u}s=O(r,i,e)}if(s===K){var l=e.splice(r,i-r+1,e[r],e[i]);return L(e).concat(L(l))}return s>=0?(e.splice(s,1),L(e)):[]}var F=new e,B=new e,z=new e,V=new e(1,0),k=new e,U=-1,q=-2,G=new t,W=new t,H=new t,j=c.EPSILON14,Y=new e,X=(new e,new e),Z=new e,K=-1,Q=-2,J=new t,$=new t,ee={};ee.removeDuplicates=function(e){if(!n(e))throw new o("positions is required.");var r=d.removeDuplicates(e);return t.equals(r[0],r[r.length-1])?r.slice(1):r},ee.computeArea2D=function(e){if(!n(e))throw new o("positions is required.");if(e.length<3)throw new o("At least three positions are required.");for(var t=e.length,r=0,i=t-1,a=0;t>a;i=a++){var s=e[i],u=e[a];r+=s.x*u.y-u.x*s.y}return.5*r},ee.computeWindingOrder2D=function(e){var t=ee.computeArea2D(e);return t>0?f.COUNTER_CLOCKWISE:f.CLOCKWISE},ee.triangulate=function(e){if(!n(e))throw new o("positions is required.");if(e.length<3)throw new o("At least three positions are required.");for(var t=e.length,r=[],i=0;t>i;++i)r[i]={position:e[i],index:i};return L(r)};var te=new t,re=new t,ie=new t,ne=new t,oe=new t,ae=new t,se=new t;return ee.computeSubdivision=function(e,a,s,h){if(h=i(h,c.RADIANS_PER_DEGREE),!n(e))throw new o("ellipsoid is required.");if(!n(a))throw new o("positions is required.");if(!n(s))throw new o("indices is required.");if(s.length<3)throw new o("At least three indices are required.");if(s.length%3!==0)throw new o("The number of indices must be divisable by three.");if(0>=h)throw new o("granularity must be greater than zero.");var d,p=s.slice(0),f=a.length,v=new Array(3*f),g=0;for(d=0;f>d;d++){var _=a[d];v[g++]=_.x,v[g++]=_.y,v[g++]=_.z}for(var y=[],w={},C=e.maximumRadius,E=c.chordLength(h,C),S=E*E;p.length>0;){var b,T,x=p.pop(),P=p.pop(),A=p.pop(),I=t.fromArray(v,3*A,te),D=t.fromArray(v,3*P,re),M=t.fromArray(v,3*x,ie),R=t.multiplyByScalar(t.normalize(I,ne),C,ne),O=t.multiplyByScalar(t.normalize(D,oe),C,oe),N=t.multiplyByScalar(t.normalize(M,ae),C,ae),L=t.magnitudeSquared(t.subtract(R,O,se)),F=t.magnitudeSquared(t.subtract(O,N,se)),B=t.magnitudeSquared(t.subtract(N,R,se)),z=Math.max(L,F,B);z>S?L===z?(b=Math.min(A,P)+" "+Math.max(A,P),d=w[b],n(d)||(T=t.add(I,D,se),t.multiplyByScalar(T,.5,T),v.push(T.x,T.y,T.z),d=v.length/3-1,w[b]=d),p.push(A,d,x),p.push(d,P,x)):F===z?(b=Math.min(P,x)+" "+Math.max(P,x),d=w[b],n(d)||(T=t.add(D,M,se),t.multiplyByScalar(T,.5,T),v.push(T.x,T.y,T.z),d=v.length/3-1,w[b]=d),p.push(P,d,A),p.push(d,x,A)):B===z&&(b=Math.min(x,A)+" "+Math.max(x,A),d=w[b],n(d)||(T=t.add(M,I,se),t.multiplyByScalar(T,.5,T),v.push(T.x,T.y,T.z),d=v.length/3-1,w[b]=d),p.push(x,d,P),p.push(d,A,P)):(y.push(A),y.push(P),y.push(x))}return new u({attributes:{position:new l({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:v})},indices:y,primitiveType:m.TRIANGLES})},ee.scaleToGeodeticHeight=function(e,r,o,s){o=i(o,a.WGS84);var u=J,l=$;if(r=i(r,0),s=i(s,!0),n(e)&&n(e.attributes)&&n(e.attributes.position))for(var c=e.attributes.position.values,h=c.length,d=0;h>d;d+=3)t.fromArray(c,d,l),s&&(l=o.scaleToGeodeticSurface(l,l)),u=o.geodeticSurfaceNormal(l,u),t.multiplyByScalar(u,r,u),t.add(l,u,l),c[d]=l.x,c[d+1]=l.y,c[d+2]=l.z;return e},ee.eliminateHoles=function(e,r,s){if(!n(e))throw new o("outerRing is required.");if(0===e.length)throw new o("outerRing must not be empty.");if(!n(r))throw new o("innerRings is required.");s=i(s,a.WGS84);for(var u=[],l=0;l<r.length;l++){for(var c=[],h=0;h<r[l].length;h++)c.push(t.clone(r[l][h]));u.push(c)}for(var d=e;u.length>0;)d=S(d,u,s);return d},ee}),r("Core/PolygonGeometryLibrary",["./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PolygonPipeline","./PrimitiveType","./Queue","./WindingOrder"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p){"use strict";function f(t,r,i,n){return e.subtract(r,t,g),e.multiplyByScalar(g,i/n,g),e.add(t,g,g),[g.x,g.y,g.z]}var v={};v.computeHierarchyPackedLength=function(t){for(var r=0,n=[t];n.length>0;){var o=n.pop();if(i(o)){r+=2;var a=o.positions,s=o.holes;if(i(a)&&(r+=a.length*e.packedLength),i(s))for(var u=s.length,l=0;u>l;++l)n.push(s[l])}}return r},v.packPolygonHierarchy=function(t,r,n){for(var o=[t];o.length>0;){var a=o.pop();if(i(a)){var s=a.positions,u=a.holes;if(r[n++]=i(s)?s.length:0,r[n++]=i(u)?u.length:0,i(s))for(var l=s.length,c=0;l>c;++c,n+=3)e.pack(s[c],r,n);if(i(u))for(var h=u.length,d=0;h>d;++d)o.push(u[d])}}return n},v.unpackPolygonHierarchy=function(t,r){for(var i=t[r++],n=t[r++],o=new Array(i),a=n>0?new Array(n):void 0,s=0;i>s;++s,r+=e.packedLength)o[s]=e.unpack(t,r);for(var u=0;n>u;++u)a[u]=v.unpackPolygonHierarchy(t,r),r=a[u].startingIndex,delete a[u].startingIndex;return{positions:o,holes:a,startingIndex:r}};var g=new e;v.subdivideLineCount=function(t,r,i){var n=e.distance(t,r),o=n/i,a=Math.max(0,Math.ceil(Math.log(o)/Math.log(2)));return Math.pow(2,a)},v.subdivideLine=function(t,r,n,o){var a=v.subdivideLineCount(t,r,n),s=e.distance(t,r),u=s/a;i(o)||(o=[]);var l=o;l.length=3*a;for(var c=0,h=0;a>h;h++){var d=f(t,r,h*u,s);l[c++]=d[0],l[c++]=d[1],l[c++]=d[2]}return l};var _=new e,y=new e,w=new e,C=new e;v.scaleToGeodeticHeightExtruded=function(t,o,a,s,u){s=r(s,n.WGS84);var l=_,c=y,h=w,d=C;if(i(t)&&i(t.attributes)&&i(t.attributes.position))for(var m=t.attributes.position.values,p=m.length/2,f=0;p>f;f+=3)e.fromArray(m,f,h),s.geodeticSurfaceNormal(h,l),d=s.scaleToGeodeticSurface(h,d),c=e.multiplyByScalar(l,a,c),c=e.add(d,c,c),m[f+p]=c.x,m[f+1+p]=c.y,m[f+2+p]=c.z,u&&(d=e.clone(h,d)),c=e.multiplyByScalar(l,o,c),c=e.add(d,c,c),m[f]=c.x,m[f+1]=c.y,m[f+2]=c.z;return t},v.polygonsFromHierarchy=function(e){var t=[],r=[],n=new m;for(n.enqueue(e);0!==n.length;){var o=n.dequeue(),a=o.positions,s=o.holes;if(a=h.removeDuplicates(a),!(a.length<3)){for(var u=i(s)?s.length:0,l=[],c=0;u>c;c++){var d=s[c];if(d.positions=h.removeDuplicates(d.positions),!(d.positions.length<3)){l.push(d.positions);var p=0;i(d.holes)&&(p=d.holes.length);for(var f=0;p>f;f++)n.enqueue(d.holes[f])}}r.push({outerRing:a,holes:l});var v=l.length>0?h.eliminateHoles(a,l):a;t.push(v)}}return{hierarchy:r,polygons:t}};var E=[];v.createGeometryFromPositions=function(e,r,i,n){var u=o.fromPoints(r,e),l=u.projectPointsOntoPlane(r,E),c=h.computeWindingOrder2D(l);c===p.CLOCKWISE&&(l.reverse(),r=r.slice().reverse());var m=h.triangulate(l);if(m.length<3&&(m=[0,1,2]),n){for(var f=r.length,v=new Array(3*f),g=0,_=0;f>_;_++){var y=r[_];v[g++]=y.x,v[g++]=y.y,v[g++]=y.z}return new a({attributes:{position:new s({componentDatatype:t.DOUBLE,componentsPerAttribute:3,values:v})},indices:m,primitiveType:d.TRIANGLES})}return h.computeSubdivision(e,r,m,i)};var S=[],b=new e,T=new e;return v.computeWallGeometry=function(r,i,n,o){var h,m,p,f,g,_=r.length,y=0;if(o)for(m=3*_*2,h=new Array(2*m),p=0;_>p;p++)f=r[p],g=r[(p+1)%_],h[y]=h[y+m]=f.x,++y,h[y]=h[y+m]=f.y,++y,h[y]=h[y+m]=f.z,++y,h[y]=h[y+m]=g.x,++y,h[y]=h[y+m]=g.y,++y,h[y]=h[y+m]=g.z,++y;else{var w=c.chordLength(n,i.maximumRadius),C=0;for(p=0;_>p;p++)C+=v.subdivideLineCount(r[p],r[(p+1)%_],w);for(m=3*(C+_),h=new Array(2*m),p=0;_>p;p++){f=r[p],g=r[(p+1)%_];for(var E=v.subdivideLine(f,g,w,S),x=E.length,P=0;x>P;++P,++y)h[y]=E[P],h[y+m]=E[P];h[y]=g.x,h[y+m]=g.x,++y,h[y]=g.y,h[y+m]=g.y,++y,h[y]=g.z,h[y+m]=g.z,++y}}_=h.length;var A=l.createTypedArray(_/3,_-6*r.length),I=0;for(_/=6,p=0;_>p;p++){var D=p,M=D+1,R=D+_,O=R+1;f=e.fromArray(h,3*D,b),g=e.fromArray(h,3*M,T),e.equalsEpsilon(f,g,c.EPSILON14)||(A[I++]=D,A[I++]=R,A[I++]=M,A[I++]=M,A[I++]=R,A[I++]=O)}return new a({attributes:new u({position:new s({componentDatatype:t.DOUBLE,componentsPerAttribute:3,values:h})}),indices:A,primitiveType:d.TRIANGLES})},v}),r("Core/PolygonGeometry",["./BoundingRectangle","./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./Matrix3","./PolygonGeometryLibrary","./PolygonPipeline","./Quaternion","./VertexFormat","./WindingOrder"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f,v,g,_,y,w,C,E){"use strict";function S(e,t,r,n){for(var o=w.fromAxisAngle(e._plane.normal,r,A),s=g.fromQuaternion(o,I),u=Number.POSITIVE_INFINITY,l=Number.NEGATIVE_INFINITY,c=Number.POSITIVE_INFINITY,h=Number.NEGATIVE_INFINITY,d=t.length,m=0;d>m;++m){var p=i.clone(t[m],P);g.multiplyByVector(s,p,p);var f=e.projectPointOntoPlane(p,x);a(f)&&(u=Math.min(u,f.x),l=Math.max(l,f.x),c=Math.min(c,f.y),h=Math.max(h,f.y))}return n.x=u,n.y=c,n.width=l-u,n.height=h-c,n}function b(e,t,o,a,s,u,c){if(e.st||e.normal||e.tangent||e.binormal){var d=l.fromPoints(o,a),m=S(d,o,s,D),p=B;p.x=m.x,p.y=m.y;var f=t.attributes.position.values,_=f.length,y=e.st?new Float32Array(2*(_/3)):void 0,C=e.normal?new Float32Array(_):void 0,E=e.tangent?new Float32Array(_):void 0,b=e.binormal?new Float32Array(_):void 0,T=0,x=0,P=R,A=O,I=N,q=!0,G=w.fromAxisAngle(d._plane.normal,s,k),W=g.fromQuaternion(G,U),H=_/2,j=_/3;u&&(_/=2);for(var Y=0;_>Y;Y+=3){var X=i.fromArray(f,Y,V);if(e.st){var Z=g.multiplyByVector(W,X,M),K=d.projectPointOntoPlane(Z,z);r.subtract(K,p,K),u&&(y[T+j]=K.x/m.width,y[T+1+j]=K.y/m.height),y[T]=K.x/m.width,y[T+1]=K.y/m.height,T+=2}if(e.normal||e.tangent||e.binormal){var Q=x+1,J=x+2;if(c){if(_>Y+3){var $=i.fromArray(f,Y+3,L);if(q){var ee=i.fromArray(f,Y+_,F);i.subtract($,X,$),i.subtract(ee,X,ee),P=i.normalize(i.cross(ee,$,P),P),q=!1}i.equalsEpsilon($,X,v.EPSILON10)&&(q=!0)}(e.tangent||e.binormal)&&(I=a.geodeticSurfaceNormal(X,I),e.tangent&&(A=i.normalize(i.cross(I,P,A),A)))}else P=a.geodeticSurfaceNormal(X,P),(e.tangent||e.binormal)&&(A=i.cross(i.UNIT_Z,P,A),A=i.normalize(g.multiplyByVector(W,A,A),A),e.binormal&&(I=i.normalize(i.cross(P,A,I),I)));e.normal&&(u&&!c?(C[x+H]=-P.x,C[Q+H]=-P.y,C[J+H]=-P.z):(C[x+H]=P.x,C[Q+H]=P.y,C[J+H]=P.z),C[x]=P.x,C[Q]=P.y,C[J]=P.z),e.tangent&&(u&&!c?(E[x+H]=-A.x,E[Q+H]=-A.y,E[J+H]=-A.z):(E[x+H]=A.x,E[Q+H]=A.y,E[J+H]=A.z),E[x]=A.x,E[Q]=A.y,E[J]=A.z),e.binormal&&(u&&(b[x+H]=I.x,b[Q+H]=I.y,b[J+H]=I.z),b[x]=I.x,b[Q]=I.y,b[J]=I.z),x+=3}}e.st&&(t.attributes.st=new h({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:y})),e.normal&&(t.attributes.normal=new h({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:C})),e.tangent&&(t.attributes.tangent=new h({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:E})),e.binormal&&(t.attributes.binormal=new h({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:b}))}return t}function T(e,t,r,i,o){var a=_.createGeometryFromPositions(e,t,r,o),s=a.attributes.position.values,u=a.indices,p=s.concat(s),v=p.length/3,g=f.createTypedArray(v,2*u.length);g.set(u);var w,C=u.length,S=v/2;for(w=0;C>w;w+=3){var b=g[w]+S,T=g[w+1]+S,x=g[w+2]+S;g[w+C]=x,g[w+1+C]=T,g[w+2+C]=b}var P=new c({attributes:new d({position:new h({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:p})}),indices:g,primitiveType:a.primitiveType}),A={topAndBottom:new m({geometry:P}),walls:[]},I=i.outerRing,D=l.fromPoints(I,e),M=D.projectPointsOntoPlane(I,q),R=y.computeWindingOrder2D(M);R===E.CLOCKWISE&&(I=I.slice().reverse());var O=_.computeWallGeometry(I,e,r,o);A.walls.push(new m({geometry:O}));var N=i.holes;for(w=0;w<N.length;w++){var L=N[w];D=l.fromPoints(L,e),M=D.projectPointsOntoPlane(L,q),R=y.computeWindingOrder2D(M),R===E.COUNTER_CLOCKWISE&&(L=L.slice().reverse()),O=_.computeWallGeometry(L,e,r),A.walls.push(new m({geometry:O}))}return A}var x=new r,P=new i,A=new w,I=new g,D=new e,M=new i,R=new i,O=new i,N=new i,L=new i,F=new i,B=new r,z=new r,V=new i,k=new w,U=new g,q=[],G=function(e){if(!a(e)||!a(e.polygonHierarchy))throw new s("options.polygonHierarchy is required.");var t=e.polygonHierarchy,r=o(e.vertexFormat,C.DEFAULT),i=o(e.ellipsoid,u.WGS84),n=o(e.granularity,v.RADIANS_PER_DEGREE),l=o(e.stRotation,0),c=o(e.height,0),h=o(e.perPositionHeight,!1),d=e.extrudedHeight,m=a(d);if(m&&!h){var p=d;d=Math.min(p,c),c=Math.max(p,c)}this._vertexFormat=C.clone(r),this._ellipsoid=u.clone(i),this._granularity=n,this._stRotation=l,this._height=c,this._extrudedHeight=o(d,0),this._extrude=m,this._polygonHierarchy=t,this._perPositionHeight=h,this._workerName="createPolygonGeometry",this.packedLength=_.computeHierarchyPackedLength(t)+u.packedLength+C.packedLength+7};G.fromPositions=function(e){if(e=o(e,o.EMPTY_OBJECT),!a(e.positions))throw new s("options.positions is required.");var t={polygonHierarchy:{positions:e.positions},height:e.height,extrudedHeight:e.extrudedHeight,vertexFormat:e.vertexFormat,stRotation:e.stRotation,ellipsoid:e.ellipsoid,granularity:e.granularity,perPositionHeight:e.perPositionHeight};return new G(t)},G.pack=function(e,t,r){if(!a(e))throw new s("value is required");if(!a(t))throw new s("array is required");r=o(r,0),r=_.packPolygonHierarchy(e._polygonHierarchy,t,r),u.pack(e._ellipsoid,t,r),r+=u.packedLength,C.pack(e._vertexFormat,t,r),r+=C.packedLength,t[r++]=e._height,t[r++]=e._extrudedHeight,t[r++]=e._granularity,t[r++]=e._stRotation,t[r++]=e._extrude?1:0,t[r++]=e._perPositionHeight?1:0,t[r]=e.packedLength;
};var W=u.clone(u.UNIT_SPHERE),H=new C,j={polygonHierarchy:{}};return G.unpack=function(e,t,r){if(!a(e))throw new s("array is required");t=o(t,0);var i=_.unpackPolygonHierarchy(e,t);t=i.startingIndex,delete i.startingIndex;var n=u.unpack(e,t,W);t+=u.packedLength;var l=C.unpack(e,t,H);t+=C.packedLength;var c=e[t++],h=e[t++],d=e[t++],m=e[t++],p=1===e[t++],f=1===e[t++],v=e[t];return a(r)||(r=new G(j)),r._polygonHierarchy=i,r._ellipsoid=u.clone(n,r._ellipsoid),r._vertexFormat=C.clone(l,r._vertexFormat),r._height=c,r._extrudedHeight=h,r._granularity=d,r._stRotation=m,r._extrude=p,r._perPositionHeight=f,r.packedLength=v,r},G.createGeometry=function(e){var r,i,n,o=e._vertexFormat,a=e._ellipsoid,s=e._granularity,u=e._stRotation,l=e._height,h=e._extrudedHeight,d=e._extrude,v=e._polygonHierarchy,g=e._perPositionHeight,w=_.polygonsFromHierarchy(v),C=w.hierarchy,E=w.polygons;if(0===E.length)return void 0;n=E[0];var S,x,P=[];if(d)for(x=0;x<E.length;x++){S=T(a,E[x],s,C[x],g),i=S.topAndBottom,i.geometry=_.scaleToGeodeticHeightExtruded(i.geometry,l,h,a,g),i.geometry=b(o,i.geometry,n,a,u,!0,!1),P.push(i),r=S.walls;for(var A=0;A<r.length;A++){var I=r[A];I.geometry=_.scaleToGeodeticHeightExtruded(I.geometry,l,h,a,g),I.geometry=b(o,I.geometry,n,a,u,!0,!0),P.push(I)}}else for(x=0;x<E.length;x++)S=new m({geometry:_.createGeometryFromPositions(a,E[x],s,g)}),S.geometry=y.scaleToGeodeticHeight(S.geometry,l,a,!g),S.geometry=b(o,S.geometry,n,a,u,!1,!1),P.push(S);S=p.combineInstances(P)[0],S.attributes.position.values=new Float64Array(S.attributes.position.values),S.indices=f.createTypedArray(S.attributes.position.values.length/3,S.indices);var D=S.attributes,M=t.fromVertices(D.position.values);return o.position||delete D.position,new c({attributes:D,indices:S.indices,primitiveType:S.primitiveType,boundingSphere:M})},G.createShadowVolume=function(e,t,r){var i=e._granularity,n=e._ellipsoid,o=t(i,n),a=r(i,n);return new G({polygonHierarchy:e._polygonHierarchy,ellipsoid:n,stRotation:e._stRotation,granularity:i,perPositionHeight:!1,extrudedHeight:o,height:a,vertexFormat:C.POSITION_ONLY})},G}),r("Core/PolygonHierarchy",["./defined"],function(e){"use strict";var t=function(t,r){this.positions=e(t)?t:[],this.holes=e(r)?r:[]};return t}),r("Core/PolygonOutlineGeometry",["./BoundingSphere","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./EllipsoidTangentPlane","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./PolygonGeometryLibrary","./PolygonPipeline","./PrimitiveType","./Queue","./WindingOrder"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f,v,g,_){"use strict";function y(e,r,i,n){var o=a.fromPoints(r,e),h=o.projectPointsOntoPlane(r,C),m=f.computeWindingOrder2D(h);m===_.CLOCKWISE&&(h.reverse(),r=r.slice().reverse());var g,y,w=r.length,S=0;if(n)for(g=new Float64Array(2*w*3),y=0;w>y;y++){var b=r[y],T=r[(y+1)%w];g[S++]=b.x,g[S++]=b.y,g[S++]=b.z,g[S++]=T.x,g[S++]=T.y,g[S++]=T.z}else{var x=0;for(y=0;w>y;y++)x+=p.subdivideLineCount(r[y],r[(y+1)%w],i);for(g=new Float64Array(3*x),y=0;w>y;y++)for(var P=p.subdivideLine(r[y],r[(y+1)%w],i,E),A=P.length,I=0;A>I;++I)g[S++]=P[I]}w=g.length/3;var D=2*w,M=d.createTypedArray(w,D);for(S=0,y=0;w-1>y;y++)M[S++]=y,M[S++]=y+1;return M[S++]=w-1,M[S++]=0,new c({geometry:new s({attributes:new l({position:new u({componentDatatype:t.DOUBLE,componentsPerAttribute:3,values:g})}),indices:M,primitiveType:v.LINES})})}function w(e,r,i,n){var o=a.fromPoints(r,e),h=o.projectPointsOntoPlane(r,C),m=f.computeWindingOrder2D(h);m===_.CLOCKWISE&&(h.reverse(),r=r.slice().reverse());var g,y,w=r.length,S=new Array(w),b=0;if(n)for(g=new Float64Array(2*w*3*2),y=0;w>y;++y){S[y]=b/3;var T=r[y],x=r[(y+1)%w];g[b++]=T.x,g[b++]=T.y,g[b++]=T.z,g[b++]=x.x,g[b++]=x.y,g[b++]=x.z}else{var P=0;for(y=0;w>y;y++)P+=p.subdivideLineCount(r[y],r[(y+1)%w],i);for(g=new Float64Array(3*P*2),y=0;w>y;++y){S[y]=b/3;for(var A=p.subdivideLine(r[y],r[(y+1)%w],i,E),I=A.length,D=0;I>D;++D)g[b++]=A[D]}}w=g.length/6;var M=S.length,R=2*(2*w+M),O=d.createTypedArray(w,R);for(b=0,y=0;w>y;++y)O[b++]=y,O[b++]=(y+1)%w,O[b++]=y+w,O[b++]=(y+1)%w+w;for(y=0;M>y;y++){var N=S[y];O[b++]=N,O[b++]=N+w}return new c({geometry:new s({attributes:new l({position:new u({componentDatatype:t.DOUBLE,componentsPerAttribute:3,values:g})}),indices:O,primitiveType:v.LINES})})}var C=[],E=[],S=function(e){if(!i(e)||!i(e.polygonHierarchy))throw new n("options.polygonHierarchy is required.");var t=e.polygonHierarchy,a=r(e.ellipsoid,o.WGS84),s=r(e.granularity,m.RADIANS_PER_DEGREE),u=r(e.height,0),l=r(e.perPositionHeight,!1),c=e.extrudedHeight,h=i(c);if(h&&!l){var d=c;c=Math.min(d,u),u=Math.max(d,u)}this._ellipsoid=o.clone(a),this._granularity=s,this._height=u,this._extrudedHeight=r(c,0),this._extrude=h,this._polygonHierarchy=t,this._perPositionHeight=l,this._workerName="createPolygonOutlineGeometry",this.packedLength=p.computeHierarchyPackedLength(t)+o.packedLength+6};S.pack=function(e,t,a){if(!i(e))throw new n("value is required");if(!i(t))throw new n("array is required");a=r(a,0),a=p.packPolygonHierarchy(e._polygonHierarchy,t,a),o.pack(e._ellipsoid,t,a),a+=o.packedLength,t[a++]=e._height,t[a++]=e._extrudedHeight,t[a++]=e._granularity,t[a++]=e._extrude?1:0,t[a++]=e._perPositionHeight?1:0,t[a++]=e.packedLength};var b=o.clone(o.UNIT_SPHERE),T={polygonHierarchy:{}};return S.unpack=function(e,t,a){if(!i(e))throw new n("array is required");t=r(t,0);var s=p.unpackPolygonHierarchy(e,t);t=s.startingIndex,delete s.startingIndex;var u=o.unpack(e,t,b);t+=o.packedLength;var l=e[t++],c=e[t++],h=e[t++],d=1===e[t++],m=1===e[t++],f=e[t++];return i(a)||(a=new S(T)),a._polygonHierarchy=s,a._ellipsoid=o.clone(u,a._ellipsoid),a._height=l,a._extrudedHeight=c,a._granularity=h,a._extrude=d,a._perPositionHeight=m,a.packedLength=f,a},S.fromPositions=function(e){if(e=r(e,r.EMPTY_OBJECT),!i(e.positions))throw new n("options.positions is required.");var t={polygonHierarchy:{positions:e.positions},height:e.height,extrudedHeight:e.extrudedHeight,ellipsoid:e.ellipsoid,granularity:e.granularity,perPositionHeight:e.perPositionHeight};return new S(t)},S.createGeometry=function(t){var r=t._ellipsoid,n=t._granularity,o=t._height,a=t._extrudedHeight,u=t._extrude,l=t._polygonHierarchy,c=t._perPositionHeight,d=[],v=new g;v.enqueue(l);for(var _;0!==v.length;){var C=v.dequeue(),E=C.positions;if(E=f.removeDuplicates(E),!(E.length<3)){var S=C.holes?C.holes.length:0;for(_=0;S>_;_++){var b=C.holes[_];if(b.positions=f.removeDuplicates(b.positions),!(b.positions.length<3)){d.push(b.positions);var T=0;i(b.holes)&&(T=b.holes.length);for(var x=0;T>x;x++)v.enqueue(b.holes[x])}}d.push(E)}}if(0===d.length)return void 0;var P,A=[],I=m.chordLength(n,r.maximumRadius);if(u)for(_=0;_<d.length;_++)P=w(r,d[_],I,c),P.geometry=p.scaleToGeodeticHeightExtruded(P.geometry,o,a,r,c),A.push(P);else for(_=0;_<d.length;_++)P=y(r,d[_],I,c),P.geometry=f.scaleToGeodeticHeight(P.geometry,o,r,!c),A.push(P);P=h.combineInstances(A)[0];var D=e.fromVertices(P.attributes.position.values);return new s({attributes:P.attributes,indices:P.indices,primitiveType:P.primitiveType,boundingSphere:D})},S}),r("Core/PolylineGeometry",["./BoundingSphere","./Cartesian3","./Color","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryType","./IndexDatatype","./Math","./PolylinePipeline","./PrimitiveType","./VertexFormat"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f,v){"use strict";function g(e,t,i,n,o){var a=_;a.length=o;var s,u=i.red,l=i.green,c=i.blue,h=i.alpha,d=n.red,m=n.green,p=n.blue,f=n.alpha;if(r.equals(i,n)){for(s=0;o>s;s++)a[s]=r.clone(i);return a}var v=(d-u)/o,g=(m-l)/o,y=(p-c)/o,w=(f-h)/o;for(s=0;o>s;s++)a[s]=new r(u+s*v,l+s*g,c+s*y,h+s*w);return a}var _=[],y=function(e){e=n(e,n.EMPTY_OBJECT);var i=e.positions,u=e.colors,l=n(e.width,1),c=n(e.colorsPerVertex,!1);if(!o(i)||i.length<2)throw new a("At least two positions are required.");if(1>l)throw new a("width must be greater than or equal to one.");if(o(u)&&(c&&u.length<i.length||!c&&u.length<i.length-1))throw new a("colors has an invalid length.");this._positions=i,this._colors=u,this._width=l,this._colorsPerVertex=c,this._vertexFormat=v.clone(n(e.vertexFormat,v.DEFAULT)),this._followSurface=n(e.followSurface,!0),this._granularity=n(e.granularity,m.RADIANS_PER_DEGREE),this._ellipsoid=s.clone(n(e.ellipsoid,s.WGS84)),this._workerName="createPolylineGeometry";var h=1+i.length*t.packedLength;h+=o(u)?1+u.length*r.packedLength:1,this.packedLength=h+s.packedLength+v.packedLength+4};y.pack=function(e,i,u){if(!o(e))throw new a("value is required");if(!o(i))throw new a("array is required");u=n(u,0);var l,c=e._positions,h=c.length;for(i[u++]=h,l=0;h>l;++l,u+=t.packedLength)t.pack(c[l],i,u);var d=e._colors;for(h=o(d)?d.length:0,i[u++]=h,l=0;h>l;++l,u+=r.packedLength)r.pack(d[l],i,u);s.pack(e._ellipsoid,i,u),u+=s.packedLength,v.pack(e._vertexFormat,i,u),u+=v.packedLength,i[u++]=e._width,i[u++]=e._colorsPerVertex?1:0,i[u++]=e._followSurface?1:0,i[u]=e._granularity};var w=s.clone(s.UNIT_SPHERE),C=new v,E={positions:void 0,colors:void 0,ellipsoid:w,vertexFormat:C,width:void 0,colorsPerVertex:void 0,followSurface:void 0,granularity:void 0};y.unpack=function(e,i,u){if(!o(e))throw new a("array is required");i=n(i,0);var l,c=e[i++],h=new Array(c);for(l=0;c>l;++l,i+=t.packedLength)h[l]=t.unpack(e,i);c=e[i++];var d=c>0?new Array(c):void 0;for(l=0;c>l;++l,i+=r.packedLength)d[l]=r.unpack(e,i);var m=s.unpack(e,i,w);i+=s.packedLength;var p=v.unpack(e,i,C);i+=v.packedLength;var f=e[i++],g=1===e[i++],_=1===e[i++],S=e[i];return o(u)?(u._positions=h,u._colors=d,u._ellipsoid=s.clone(m,u._ellipsoid),u._vertexFormat=v.clone(p,u._vertexFormat),u._width=f,u._colorsPerVertex=g,u._followSurface=_,u._granularity=S,u):(E.positions=h,E.colors=d,E.width=f,E.colorsPerVertex=g,E.followSurface=_,E.granularity=S,new y(E))};var S=new t,b=new t,T=new t,x=new t;return y.createGeometry=function(n){var a,s,v,y=n._width,w=n._vertexFormat,C=n._colors,E=n._colorsPerVertex,P=n._followSurface,A=n._granularity,I=n._ellipsoid,D=m.chordLength(A,I.maximumRadius),M=p.removeDuplicates(n._positions),R=M.length;if(2>R)return void 0;if(P){var O=p.extractHeights(M,I);if(o(C)){var N=1;for(a=0;R-1>a;++a)N+=p.numberOfPoints(M[a],M[a+1],D);var L=new Array(N),F=0;for(a=0;R-1>a;++a){var B=M[a],z=M[a+1],V=C[a],k=p.numberOfPoints(B,z,D);if(E&&N>a){var U=C[a+1],q=g(B,z,V,U,k),G=q.length;for(s=0;G>s;++s)L[F++]=q[s]}else for(s=0;k>s;++s)L[F++]=r.clone(V)}L[F]=r.clone(C[C.length-1]),C=L,_.length=0}M=p.generateCartesianArc({positions:M,minDistance:D,ellipsoid:I,height:O})}R=M.length;var W,H=4*R-4,j=new Float64Array(3*H),Y=new Float64Array(3*H),X=new Float64Array(3*H),Z=new Float32Array(2*H),K=w.st?new Float32Array(2*H):void 0,Q=o(C)?new Uint8Array(4*H):void 0,J=0,$=0,ee=0,te=0;for(s=0;R>s;++s){0===s?(W=S,t.subtract(M[0],M[1],W),t.add(M[0],W,W)):W=M[s-1],t.clone(W,T),t.clone(M[s],b),s===R-1?(W=S,t.subtract(M[R-1],M[R-2],W),t.add(M[R-1],W,W)):W=M[s+1],t.clone(W,x);var re,ie;o(Q)&&(re=0===s||E?C[s]:C[s-1],s!==R-1&&(ie=C[s]));var ne=0===s?2:0,oe=s===R-1?2:4;for(v=ne;oe>v;++v){t.pack(b,j,J),t.pack(T,Y,J),t.pack(x,X,J),J+=3;var ae=0>v-2?-1:1;if(Z[$++]=2*(v%2)-1,Z[$++]=ae*y,w.st&&(K[ee++]=s/(R-1),K[ee++]=Math.max(Z[$-2],0)),o(Q)){var se=2>v?re:ie;Q[te++]=r.floatToByte(se.red),Q[te++]=r.floatToByte(se.green),Q[te++]=r.floatToByte(se.blue),Q[te++]=r.floatToByte(se.alpha)}}}var ue=new c;ue.position=new l({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:j}),ue.prevPosition=new l({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:Y}),ue.nextPosition=new l({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:X}),ue.expandAndWidth=new l({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:Z}),w.st&&(ue.st=new l({componentDatatype:i.FLOAT,componentsPerAttribute:2,values:K})),o(Q)&&(ue.color=new l({componentDatatype:i.UNSIGNED_BYTE,componentsPerAttribute:4,values:Q,normalize:!0}));var le=d.createTypedArray(H,6*R-6),ce=0,he=0,de=R-1;for(s=0;de>s;++s)le[he++]=ce,le[he++]=ce+2,le[he++]=ce+1,le[he++]=ce+1,le[he++]=ce+2,le[he++]=ce+3,ce+=4;return new u({attributes:ue,indices:le,primitiveType:f.TRIANGLES,boundingSphere:e.fromPoints(M),geometryType:h.POLYLINES})},y}),r("Core/PolylineVolumeGeometry",["./BoundingRectangle","./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./CornerType","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryPipeline","./IndexDatatype","./Math","./PolygonPipeline","./PolylineVolumeGeometryLibrary","./PrimitiveType","./VertexFormat","./WindingOrder"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f,v,g,_,y,w){"use strict";function C(e,r,i,o){var a=new d;o.position&&(a.position=new h({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:e}));var s,u,l,f,g,y,w=r.length,C=e.length/3,E=(C-2*w)/(2*w),S=v.triangulate(r),b=(E-1)*w*6+2*S.length,T=p.createTypedArray(C,b),x=2*w,P=0;for(s=0;E-1>s;s++){for(u=0;w-1>u;u++)l=2*u+s*w*2,y=l+x,f=l+1,g=f+x,T[P++]=f,T[P++]=l,T[P++]=g,T[P++]=g,T[P++]=l,T[P++]=y;l=2*w-2+s*w*2,f=l+1,g=f+x,y=l+x,T[P++]=f,T[P++]=l,T[P++]=g,T[P++]=g,T[P++]=l,T[P++]=y}if(o.st||o.tangent||o.binormal){var A,I,D=new Float32Array(2*C),M=1/(E-1),R=1/i.height,O=i.height/2,N=0;for(s=0;E>s;s++){for(A=s*M,I=R*(r[0].y+O),D[N++]=A,D[N++]=I,u=1;w>u;u++)I=R*(r[u].y+O),D[N++]=A,D[N++]=I,D[N++]=A,D[N++]=I;I=R*(r[0].y+O),D[N++]=A,D[N++]=I}for(u=0;w>u;u++)A=0,I=R*(r[u].y+O),D[N++]=A,D[N++]=I;for(u=0;w>u;u++)A=(E-1)*M,I=R*(r[u].y+O),D[N++]=A,D[N++]=I;a.st=new h({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:new Float32Array(D)})}var L=C-2*w;for(s=0;s<S.length;s+=3){var F=S[s]+L,B=S[s+1]+L,z=S[s+2]+L;T[P++]=F,T[P++]=B,T[P++]=z,T[P++]=z+w,T[P++]=B+w,T[P++]=F+w}var V=new c({attributes:a,indices:T,boundingSphere:t.fromVertices(e),primitiveType:_.TRIANGLES});return o.normal&&(V=m.computeNormal(V)),(o.tangent||o.binormal)&&(V=m.computeBinormalAndTangent(V),o.tangent||(V.attributes.tangent=void 0),o.binormal||(V.attributes.binormal=void 0),o.st||(V.attributes.st=void 0)),V}var E=function(e){e=a(e,a.EMPTY_OBJECT);var t=e.polylinePositions,n=e.shapePositions;if(!s(t))throw new u("options.polylinePositions is required.");if(!s(n))throw new u("options.shapePositions is required.");this._positions=t,this._shape=n,this._ellipsoid=l.clone(a(e.ellipsoid,l.WGS84)),this._cornerType=a(e.cornerType,o.ROUNDED),this._vertexFormat=y.clone(a(e.vertexFormat,y.DEFAULT)),this._granularity=a(e.granularity,f.RADIANS_PER_DEGREE),this._workerName="createPolylineVolumeGeometry";var c=1+t.length*i.packedLength;c+=1+n.length*r.packedLength,this.packedLength=c+l.packedLength+y.packedLength+2};E.pack=function(e,t,n){if(!s(e))throw new u("value is required");if(!s(t))throw new u("array is required");n=a(n,0);var o,c=e._positions,h=c.length;for(t[n++]=h,o=0;h>o;++o,n+=i.packedLength)i.pack(c[o],t,n);var d=e._shape;for(h=d.length,t[n++]=h,o=0;h>o;++o,n+=r.packedLength)r.pack(d[o],t,n);l.pack(e._ellipsoid,t,n),n+=l.packedLength,y.pack(e._vertexFormat,t,n),n+=y.packedLength,t[n++]=e._cornerType,t[n]=e._granularity};var S=l.clone(l.UNIT_SPHERE),b=new y,T={polylinePositions:void 0,shapePositions:void 0,ellipsoid:S,vertexFormat:b,cornerType:void 0,granularity:void 0};E.unpack=function(e,t,n){if(!s(e))throw new u("array is required");t=a(t,0);var o,c=e[t++],h=new Array(c);for(o=0;c>o;++o,t+=i.packedLength)h[o]=i.unpack(e,t);c=e[t++];var d=new Array(c);for(o=0;c>o;++o,t+=r.packedLength)d[o]=r.unpack(e,t);var m=l.unpack(e,t,S);t+=l.packedLength;var p=y.unpack(e,t,b);t+=y.packedLength;var f=e[t++],v=e[t];return s(n)?(n._positions=h,n._shape=d,n._ellipsoid=l.clone(m,n._ellipsoid),n._vertexFormat=y.clone(p,n._vertexFormat),n._cornerType=f,n._granularity=v,n):(T.polylinePositions=h,T.shapePositions=d,T.cornerType=f,T.granularity=v,new E(T))};var x=new e;return E.createGeometry=function(t){var r=t._positions,i=g.removeDuplicatesFromPositions(r,t._ellipsoid),n=t._shape;if(n=g.removeDuplicatesFromShape(n),i.length<2||n.length<3)return void 0;v.computeWindingOrder2D(n)===w.CLOCKWISE&&n.reverse();var o=e.fromPoints(n,x),a=g.computePositions(i,n,o,t,!0);return C(a,n,o,t._vertexFormat)},E}),r("Core/PolylineVolumeOutlineGeometry",["./BoundingRectangle","./BoundingSphere","./Cartesian2","./Cartesian3","./ComponentDatatype","./CornerType","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PolygonPipeline","./PolylineVolumeGeometryLibrary","./PrimitiveType","./WindingOrder"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f,v,g,_){"use strict";function y(e,r){var i=new d;i.position=new h({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:e});var o,a,s=r.length,u=i.position.values.length/3,l=e.length/3,p=l/s,f=m.createTypedArray(u,2*s*(p+1)),v=0;o=0;var _=o*s;for(a=0;s-1>a;a++)f[v++]=a+_,f[v++]=a+_+1;for(f[v++]=s-1+_,f[v++]=_,o=p-1,_=o*s,a=0;s-1>a;a++)f[v++]=a+_,f[v++]=a+_+1;for(f[v++]=s-1+_,f[v++]=_,o=0;p-1>o;o++){var y=s*o,w=y+s;for(a=0;s>a;a++)f[v++]=a+y,f[v++]=a+w}var C=new c({attributes:i,indices:m.createTypedArray(u,f),boundingSphere:t.fromVertices(e),primitiveType:g.LINES});return C}var w=function(e){e=a(e,a.EMPTY_OBJECT);var t=e.polylinePositions,n=e.shapePositions;if(!s(t))throw new u("options.polylinePositions is required.");if(!s(n))throw new u("options.shapePositions is required.");this._positions=t,this._shape=n,this._ellipsoid=l.clone(a(e.ellipsoid,l.WGS84)),this._cornerType=a(e.cornerType,o.ROUNDED),this._granularity=a(e.granularity,p.RADIANS_PER_DEGREE),this._workerName="createPolylineVolumeOutlineGeometry";var c=1+t.length*i.packedLength;c+=1+n.length*r.packedLength,this.packedLength=c+l.packedLength+2};w.pack=function(e,t,n){if(!s(e))throw new u("value is required");if(!s(t))throw new u("array is required");n=a(n,0);var o,c=e._positions,h=c.length;for(t[n++]=h,o=0;h>o;++o,n+=i.packedLength)i.pack(c[o],t,n);var d=e._shape;for(h=d.length,t[n++]=h,o=0;h>o;++o,n+=r.packedLength)r.pack(d[o],t,n);l.pack(e._ellipsoid,t,n),n+=l.packedLength,t[n++]=e._cornerType,t[n]=e._granularity};var C=l.clone(l.UNIT_SPHERE),E={polylinePositions:void 0,shapePositions:void 0,ellipsoid:C,height:void 0,cornerType:void 0,granularity:void 0};w.unpack=function(e,t,n){if(!s(e))throw new u("array is required");t=a(t,0);var o,c=e[t++],h=new Array(c);for(o=0;c>o;++o,t+=i.packedLength)h[o]=i.unpack(e,t);c=e[t++];var d=new Array(c);for(o=0;c>o;++o,t+=r.packedLength)d[o]=r.unpack(e,t);var m=l.unpack(e,t,C);t+=l.packedLength;var p=e[t++],f=e[t];return s(n)?(n._positions=h,n._shape=d,n._ellipsoid=l.clone(m,n._ellipsoid),n._cornerType=p,n._granularity=f,n):(E.polylinePositions=h,E.shapePositions=d,E.cornerType=p,E.granularity=f,new w(E))};var S=new e;return w.createGeometry=function(t){var r=t._positions,i=v.removeDuplicatesFromPositions(r,t._ellipsoid),n=t._shape;if(n=v.removeDuplicatesFromShape(n),i.length<2||n.length<3)return void 0;f.computeWindingOrder2D(n)===_.CLOCKWISE&&n.reverse();var o=e.fromPoints(n,S),a=v.computePositions(i,n,o,t,!1);return y(a,n)},w}),r("Core/QuaternionSpline",["./defaultValue","./defined","./defineProperties","./DeveloperError","./Quaternion","./Spline"],function(e,t,r,i,n,o){"use strict";function a(e,r,i){var o=e.length,a=new Array(o);a[0]=t(r)?r:e[0],a[o-1]=t(i)?i:e[o-1];for(var s=1;o-1>s;++s)a[s]=n.computeInnerQuadrangle(e[s-1],e[s],e[s+1],new n);return a}function s(e){var r=e.points,i=e.innerQuadrangles,o=e.times;if(r.length<3){var a=o[0],s=1/(o[1]-a),u=r[0],l=r[1];return function(e,r){t(r)||(r=new n);var i=(e-a)*s;return n.fastSlerp(u,l,i,r)}}return function(a,s){t(s)||(s=new n);var u=e._lastTimeIndex=e.findTimeInterval(a,e._lastTimeIndex),l=(a-o[u])/(o[u+1]-o[u]),c=r[u],h=r[u+1],d=i[u],m=i[u+1];return n.fastSquad(c,h,d,m,l,s)}}var u=function(r){r=e(r,e.EMPTY_OBJECT);var n=r.points,o=r.times,u=r.firstInnerQuadrangle,l=r.lastInnerQuadrangle;if(!t(n)||!t(o))throw new i("points and times are required.");if(n.length<2)throw new i("points.length must be greater than or equal to 2.");if(o.length!==n.length)throw new i("times.length must be equal to points.length.");var c=a(n,u,l);this._times=o,this._points=n,this._innerQuadrangles=c,this._evaluateFunction=s(this),this._lastTimeIndex=0};return r(u.prototype,{times:{get:function(){return this._times}},points:{get:function(){return this._points}},innerQuadrangles:{get:function(){return this._innerQuadrangles}}}),u.prototype.findTimeInterval=o.prototype.findTimeInterval,u.prototype.evaluate=function(e,t){return this._evaluateFunction(e,t)},u}),r("Core/RectangleGeometryLibrary",["./Cartesian3","./Cartographic","./defined","./DeveloperError","./GeographicProjection","./Math","./Matrix2","./Rectangle"],function(e,t,r,i,n,o,a,s){"use strict";var u=Math.cos,l=Math.sin,c=Math.sqrt,h={};h.computePosition=function(e,t,i,n,o){var s=e.ellipsoid.radiiSquared,h=e.nwCorner,d=e.rectangle,m=h.latitude-e.granYCos*t+i*e.granXSin,p=u(m),f=l(m),v=s.z*f,g=h.longitude+t*e.granYSin+i*e.granXCos,_=p*u(g),y=p*l(g),w=s.x*_,C=s.y*y,E=c(w*_+C*y+v*f);n.x=w/E,n.y=C/E,n.z=v/E,r(e.vertexFormat)&&e.vertexFormat.st&&(o.x=(g-d.west)*e.lonScalar-.5,o.y=(m-d.south)*e.latScalar-.5,a.multiplyByVector(e.textureMatrix,o,o),o.x+=.5,o.y+=.5)};var d=new a,m=new e,p=new t,f=new e,v=new n;return h.computeOptions=function(t,n,u){var l,c,h,g,_,y=t._granularity,w=t._ellipsoid,C=t._surfaceHeight,E=t._rotation,S=t._extrudedHeight,b=n.east,T=n.west,x=n.north,P=n.south,A=x-P;T>b?(_=o.TWO_PI-T+b,l=Math.ceil(_/y)+1,c=Math.ceil(A/y)+1,h=_/(l-1),g=A/(c-1)):(_=b-T,l=Math.ceil(_/y)+1,c=Math.ceil(A/y)+1,h=_/(l-1),g=A/(c-1)),u=s.northwest(n,u);var I=s.center(n,p),D=g,M=h,R=0,O=0;if(r(E)){var N=Math.cos(E);D*=N,M*=N;var L=Math.sin(E);R=g*L,O=h*L,m=v.project(u,m),f=v.project(I,f),m=e.subtract(m,f,m);var F=a.fromRotation(E,d);m=a.multiplyByVector(F,m,m),m=e.add(m,f,m),u=v.unproject(m,u);var B=u.latitude,z=B+(l-1)*O,V=B-D*(c-1),k=B-D*(c-1)+(l-1)*O;x=Math.max(B,z,V,k),P=Math.min(B,z,V,k);var U=u.longitude,q=U+(l-1)*M,G=U+(c-1)*R,W=U+(c-1)*R+(l-1)*M;if(b=Math.max(U,q,G,W),T=Math.min(U,q,G,W),x<-o.PI_OVER_TWO||x>o.PI_OVER_TWO||P<-o.PI_OVER_TWO||P>o.PI_OVER_TWO)throw new i("Rotated extent is invalid.");n.north=x,n.south=P,n.east=b,n.west=T}return{granYCos:D,granYSin:R,granXCos:M,granXSin:O,ellipsoid:w,width:l,height:c,surfaceHeight:C,extrudedHeight:S,nwCorner:u,rectangle:n}},h}),r("Core/RectangleGeometry",["./BoundingSphere","./Cartesian2","./Cartesian3","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./GeometryInstance","./GeometryPipeline","./IndexDatatype","./Math","./Matrix2","./Matrix3","./PolygonPipeline","./PrimitiveType","./Quaternion","./Rectangle","./RectangleGeometryLibrary","./VertexFormat"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f,v,g,_,y,w,C,E,S){"use strict";function b(e,t){var r=new l({attributes:new h,primitiveType:y.TRIANGLES});return r.attributes.position=new c({componentDatatype:n.DOUBLE,componentsPerAttribute:3,values:t.positions}),e.normal&&(r.attributes.normal=new c({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:t.normals})),e.tangent&&(r.attributes.tangent=new c({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:t.tangents})),e.binormal&&(r.attributes.binormal=new c({componentDatatype:n.FLOAT,componentsPerAttribute:3,values:t.binormals})),r}function T(e,t,i,n){for(var o=e.length,a=t.normal?new Float32Array(o):void 0,s=t.tangent?new Float32Array(o):void 0,u=t.binormal?new Float32Array(o):void 0,l=0,c=N,h=O,d=R,m=0;o>m;m+=3){var p=r.fromArray(e,m,M),f=l+1,v=l+2;(t.normal||t.tangent||t.binormal)&&(d=i.geodeticSurfaceNormal(p,d),(t.tangent||t.binormal)&&(r.cross(r.UNIT_Z,d,h),g.multiplyByVector(n,h,h),r.normalize(h,h),t.binormal&&r.normalize(r.cross(d,h,c),c)),t.normal&&(a[l]=d.x,a[f]=d.y,a[v]=d.z),t.tangent&&(s[l]=h.x,s[f]=h.y,s[v]=h.z),t.binormal&&(u[l]=c.x,u[f]=c.y,u[v]=c.z)),l+=3}return b(t,{positions:e,normals:a,tangents:s,binormals:u})}function x(e,t,i){for(var n=e.length,o=t.normal?new Float32Array(n):void 0,a=t.tangent?new Float32Array(n):void 0,s=t.binormal?new Float32Array(n):void 0,u=0,l=0,c=0,h=!0,d=N,m=O,p=R,v=0;n>v;v+=6){var g=r.fromArray(e,v,M);if(t.normal||t.tangent||t.binormal){var _=r.fromArray(e,(v+6)%n,V);if(h){var y=r.fromArray(e,(v+3)%n,k);r.subtract(_,g,_),r.subtract(y,g,y),p=r.normalize(r.cross(y,_,p),p),h=!1}r.equalsEpsilon(_,g,f.EPSILON10)&&(h=!0),(t.tangent||t.binormal)&&(d=i.geodeticSurfaceNormal(g,d),t.tangent&&(m=r.normalize(r.cross(d,p,m),m))),t.normal&&(o[u++]=p.x,o[u++]=p.y,o[u++]=p.z,o[u++]=p.x,o[u++]=p.y,o[u++]=p.z),t.tangent&&(a[l++]=m.x,a[l++]=m.y,a[l++]=m.z,a[l++]=m.x,a[l++]=m.y,a[l++]=m.z),t.binormal&&(s[c++]=d.x,s[c++]=d.y,s[c++]=d.z,s[c++]=d.x,s[c++]=d.y,s[c++]=d.z)}}return b(t,{positions:e,normals:o,tangents:a,binormals:s})}function P(e){for(var t=e.vertexFormat,r=e.ellipsoid,i=e.size,o=e.height,a=e.width,s=t.position?new Float64Array(3*i):void 0,u=t.st?new Float32Array(2*i):void 0,l=0,h=0,d=M,m=F,f=Number.MAX_VALUE,v=Number.MAX_VALUE,g=Number.MIN_VALUE,_=Number.MIN_VALUE,y=0;o>y;++y)for(var w=0;a>w;++w)E.computePosition(e,y,w,d,m),s[l++]=d.x,s[l++]=d.y,s[l++]=d.z,t.st&&(u[h++]=m.x,u[h++]=m.y,f=Math.min(f,m.x),v=Math.min(v,m.y),g=Math.max(g,m.x),_=Math.max(_,m.y));if(t.st&&(0>f||0>v||g>1||_>1))for(var C=0;C<u.length;C+=2)u[C]=(u[C]-f)/(g-f),u[C+1]=(u[C+1]-v)/(_-v);for(var S=T(s,t,r,e.tangentRotationMatrix),b=6*(a-1)*(o-1),x=p.createTypedArray(i,b),P=0,A=0,I=0;o-1>I;++I){for(var D=0;a-1>D;++D){var R=P,O=R+a,N=O+1,L=R+1;x[A++]=R,x[A++]=O,x[A++]=L,x[A++]=L,x[A++]=O,x[A++]=N,++P}++P}return S.indices=x,t.st&&(S.attributes.st=new c({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:u})),S}function A(e,t,r,i,n){return e[t++]=i[r],e[t++]=i[r+1],e[t++]=i[r+2],e[t++]=n[r],e[t++]=n[r+1],e[t++]=n[r+2],e}function I(e,t,r,i){return e[t++]=i[r],e[t++]=i[r+1],e[t++]=i[r],e[t++]=i[r+1],e}function D(e){var t,i=e.vertexFormat,o=e.surfaceHeight,a=e.extrudedHeight,s=Math.min(a,o),u=Math.max(a,o),l=e.height,h=e.width,v=e.ellipsoid,g=P(e);if(f.equalsEpsilon(s,u,f.EPSILON10))return g;g=_.scaleToGeodeticHeight(g,u,v,!1);var y=new Float64Array(g.attributes.position.values),w=y.length,C=2*w,E=new Float64Array(C);E.set(y),g=_.scaleToGeodeticHeight(g,s,v);var S=g.attributes.position.values;E.set(S,w),g.attributes.position.values=E;var b,T=i.normal?new Float32Array(C):void 0,D=i.tangent?new Float32Array(C):void 0,M=i.binormal?new Float32Array(C):void 0,R=i.st?new Float32Array(C/3*2):void 0;if(i.normal){var O=g.attributes.normal.values;for(T.set(O),t=0;w>t;t++)O[t]=-O[t];T.set(O,w),g.attributes.normal.values=T}if(i.tangent){var N=g.attributes.tangent.values;for(D.set(N),t=0;w>t;t++)N[t]=-N[t];D.set(N,w),g.attributes.tangent.values=D}if(i.binormal){var L=g.attributes.binormal.values;M.set(L),M.set(L,w),g.attributes.binormal.values=M}i.st&&(b=g.attributes.st.values,R.set(b),R.set(b,w/3*2),g.attributes.st.values=R);var F=g.indices,B=F.length,z=w/3,U=p.createTypedArray(C/3,2*B);for(U.set(F),t=0;B>t;t+=3)U[t+B]=F[t+2]+z,U[t+1+B]=F[t+1]+z,U[t+2+B]=F[t]+z;g.indices=U;var q=2*h+2*l-4,G=2*(q+4),W=new Float64Array(3*G),H=i.st?new Float32Array(2*G):void 0,j=0,Y=0,X=h*l;for(t=0;X>t;t+=h)W=A(W,j,3*t,y,S),j+=6,i.st&&(H=I(H,Y,2*t,b),Y+=4);for(t=X-h;X>t;t++)W=A(W,j,3*t,y,S),j+=6,i.st&&(H=I(H,Y,2*t,b),Y+=4);for(t=X-1;t>0;t-=h)W=A(W,j,3*t,y,S),j+=6,i.st&&(H=I(H,Y,2*t,b),Y+=4);for(t=h-1;t>=0;t--)W=A(W,j,3*t,y,S),j+=6,i.st&&(H=I(H,Y,2*t,b),Y+=4);var Z=x(W,i,v);i.st&&(Z.attributes.st=new c({componentDatatype:n.FLOAT,componentsPerAttribute:2,values:H}));var K,Q,J,$,ee=p.createTypedArray(G,6*q);w=W.length/3;var te=0;for(t=0;w-1>t;t+=2){K=t,$=(K+2)%w;var re=r.fromArray(W,3*K,V),ie=r.fromArray(W,3*$,k);r.equalsEpsilon(re,ie,f.EPSILON10)||(Q=(K+1)%w,J=(Q+2)%w,ee[te++]=K,ee[te++]=Q,ee[te++]=$,ee[te++]=$,ee[te++]=Q,ee[te++]=J)}return Z.indices=ee,Z=m.combineInstances([new d({geometry:g}),new d({geometry:Z})]),Z[0]}var M=new r,R=new r,O=new r,N=new r,L=new C,F=new t,B=new e,z=new e,V=new r,k=new r,U=function(e){e=o(e,o.EMPTY_OBJECT);var t=e.rectangle,r=o(e.granularity,f.RADIANS_PER_DEGREE),i=o(e.ellipsoid,u.WGS84),n=o(e.height,0),l=o(e.rotation,0),c=o(e.stRotation,0),h=o(e.vertexFormat,S.DEFAULT),d=e.extrudedHeight,m=a(d),p=o(e.closeTop,!0),v=o(e.closeBottom,!0);if(!a(t))throw new s("rectangle is required.");if(C.validate(t),t.north<t.south)throw new s("options.rectangle.north must be greater than options.rectangle.south");this._rectangle=t,this._granularity=r,this._ellipsoid=u.clone(i),this._surfaceHeight=n,this._rotation=l,this._stRotation=c,this._vertexFormat=S.clone(h),this._extrudedHeight=o(d,0),this._extrude=m,this._closeTop=p,this._closeBottom=v,this._workerName="createRectangleGeometry"};U.packedLength=C.packedLength+u.packedLength+S.packedLength+8,U.pack=function(e,t,r){if(!a(e))throw new s("value is required");if(!a(t))throw new s("array is required");r=o(r,0),C.pack(e._rectangle,t,r),r+=C.packedLength,u.pack(e._ellipsoid,t,r),r+=u.packedLength,S.pack(e._vertexFormat,t,r),r+=S.packedLength,t[r++]=e._granularity,t[r++]=e._surfaceHeight,t[r++]=e._rotation,t[r++]=e._stRotation,t[r++]=e._extrudedHeight,t[r++]=e._extrude?1:0,t[r++]=e._closeTop?1:0,t[r]=e._closeBottom?1:0};var q=new C,G=u.clone(u.UNIT_SPHERE),W=new S,H={rectangle:q,ellipsoid:G,vertexFormat:W,granularity:void 0,height:void 0,rotation:void 0,stRotation:void 0,extrudedHeight:void 0,closeTop:void 0,closeBottom:void 0};U.unpack=function(e,t,r){if(!a(e))throw new s("array is required");t=o(t,0);var i=C.unpack(e,t,q);t+=C.packedLength;var n=u.unpack(e,t,G);t+=u.packedLength;var l=S.unpack(e,t,W);t+=S.packedLength;var c=e[t++],h=e[t++],d=e[t++],m=e[t++],p=e[t++],f=1===e[t++],v=1===e[t++],g=1===e[t];return a(r)?(r._rectangle=C.clone(i,r._rectangle),r._ellipsoid=u.clone(n,r._ellipsoid),r._vertexFormat=S.clone(l,r._vertexFormat),r._granularity=c,r._surfaceHeight=h,r._rotation=d,r._stRotation=m,r._extrudedHeight=f?p:void 0,r._extrude=f,r._closeTop=v,r._closeBottom=g,r):(H.granularity=c,H.height=h,H.rotation=d,H.stRotation=m,H.extrudedHeight=f?p:void 0,H.closeTop=v,H.closeBottom=g,new U(H))};var j=new v,Y=new g,X=new i,Z=new w,K=new i;return U.createGeometry=function(t){var i=C.clone(t._rectangle,L),n=t._ellipsoid,o=t._surfaceHeight,s=t._extrude,u=t._extrudedHeight,c=t._stRotation,d=t._vertexFormat,m=E.computeOptions(t,i,X),p=j,f=Y;if(a(c)){v.fromRotation(-c,p);var y=C.center(i,K),S=n.cartographicToCartesian(y,V);r.normalize(S,S),w.fromAxisAngle(S,-c,Z),g.fromQuaternion(Z,f)}else v.clone(v.IDENTITY,p),g.clone(g.IDENTITY,f);m.lonScalar=1/i.width,m.latScalar=1/i.height,m.vertexFormat=d,m.textureMatrix=p,m.tangentRotationMatrix=f,m.size=m.width*m.height;var b,T;if(i=t._rectangle,s){b=D(m);var x=e.fromRectangle3D(i,n,o,z),A=e.fromRectangle3D(i,n,u,B);T=e.union(x,A)}else b=P(m),b=_.scaleToGeodeticHeight(b,o,n,!1),T=e.fromRectangle3D(i,n,o);return d.position||delete b.attributes.position,new l({attributes:new h(b.attributes),indices:b.indices,primitiveType:b.primitiveType,boundingSphere:T})},U.createShadowVolume=function(e,t,r){var i=e._granularity,n=e._ellipsoid,o=t(i,n),a=r(i,n);return new U({rectangle:e._rectangle,rotation:e._rotation,ellipsoid:n,stRotation:e._stRotation,granularity:i,extrudedHeight:a,height:o,closeTop:!0,closeBottom:!0,vertexFormat:S.POSITION_ONLY})},U}),r("Core/RectangleOutlineGeometry",["./BoundingSphere","./Cartesian3","./Cartographic","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PolygonPipeline","./PrimitiveType","./Rectangle","./RectangleGeometryLibrary"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f,v){"use strict";function g(e){var t,r=e.size,n=e.height,o=e.width,a=new Float64Array(3*r),s=0,d=0,m=C;for(t=0;o>t;t++)v.computePosition(e,d,t,m),a[s++]=m.x,a[s++]=m.y,a[s++]=m.z;for(t=o-1,d=1;n>d;d++)v.computePosition(e,d,t,m),
a[s++]=m.x,a[s++]=m.y,a[s++]=m.z;for(d=n-1,t=o-2;t>=0;t--)v.computePosition(e,d,t,m),a[s++]=m.x,a[s++]=m.y,a[s++]=m.z;for(t=0,d=n-2;d>0;d--)v.computePosition(e,d,t,m),a[s++]=m.x,a[s++]=m.y,a[s++]=m.z;for(var f=a.length/3*2,g=h.createTypedArray(a.length/3,f),_=0,y=0;y<a.length/3-1;y++)g[_++]=y,g[_++]=y+1;g[_++]=a.length/3-1,g[_++]=0;var w=new u({attributes:new c,primitiveType:p.LINES});return w.attributes.position=new l({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:a}),w.indices=g,w}function _(e){var t=e.surfaceHeight,r=e.extrudedHeight,i=e.ellipsoid,n=Math.min(r,t),o=Math.max(r,t),a=g(e);if(d.equalsEpsilon(n,o,d.EPSILON10))return a;var s=e.height,u=e.width;a=m.scaleToGeodeticHeight(a,o,i,!1);var l=a.attributes.position.values,c=l.length,p=new Float64Array(2*c);p.set(l),a=m.scaleToGeodeticHeight(a,n,i);var f=a.attributes.position.values;p.set(f,c),a.attributes.position.values=p;var v=p.length/3*2+8,_=h.createTypedArray(p.length/3,v);c=p.length/6;for(var y=0,w=0;c-1>w;w++)_[y++]=w,_[y++]=w+1,_[y++]=w+c,_[y++]=w+c+1;return _[y++]=c-1,_[y++]=0,_[y++]=c+c-1,_[y++]=c,_[y++]=0,_[y++]=c,_[y++]=u-1,_[y++]=c+u-1,_[y++]=u+s-2,_[y++]=u+s-2+c,_[y++]=2*u+s-3,_[y++]=2*u+s-3+c,a.indices=_,a}var y=new e,w=new e,C=new t,E=new f,S=function(e){e=n(e,n.EMPTY_OBJECT);var t=e.rectangle,r=n(e.granularity,d.RADIANS_PER_DEGREE),i=n(e.ellipsoid,s.WGS84),u=n(e.height,0),l=n(e.rotation,0),c=e.extrudedHeight;if(!o(t))throw new a("rectangle is required.");if(f.validate(t),t.north<t.south)throw new a("options.rectangle.north must be greater than options.rectangle.south");this._rectangle=t,this._granularity=r,this._ellipsoid=i,this._surfaceHeight=u,this._rotation=l,this._extrudedHeight=c,this._workerName="createRectangleOutlineGeometry"};S.packedLength=f.packedLength+s.packedLength+5,S.pack=function(e,t,r){if(!o(e))throw new a("value is required");if(!o(t))throw new a("array is required");r=n(r,0),f.pack(e._rectangle,t,r),r+=f.packedLength,s.pack(e._ellipsoid,t,r),r+=s.packedLength,t[r++]=e._granularity,t[r++]=e._surfaceHeight,t[r++]=e._rotation,t[r++]=o(e._extrudedHeight)?1:0,t[r]=n(e._extrudedHeight,0)};var b=new f,T=s.clone(s.UNIT_SPHERE),x={rectangle:b,ellipsoid:T,granularity:void 0,height:void 0,rotation:void 0,extrudedHeight:void 0};S.unpack=function(e,t,r){if(!o(e))throw new a("array is required");t=n(t,0);var i=f.unpack(e,t,b);t+=f.packedLength;var u=s.unpack(e,t,T);t+=s.packedLength;var l=e[t++],c=e[t++],h=e[t++],d=e[t++],m=e[t];return o(r)?(r._rectangle=f.clone(i,r._rectangle),r._ellipsoid=s.clone(u,r._ellipsoid),r._surfaceHeight=c,r._rotation=h,r._extrudedHeight=d?m:void 0,r):(x.granularity=l,x.height=c,x.rotation=h,x.extrudedHeight=d?m:void 0,new S(x))};var P=new r;return S.createGeometry=function(t){var r=f.clone(t._rectangle,E),i=t._ellipsoid,n=t._surfaceHeight,a=t._extrudedHeight,s=v.computeOptions(t,r,P);s.size=2*s.width+2*s.height-4;var l,c;if(r=t._rectangle,o(a)){l=_(s);var h=e.fromRectangle3D(r,i,n,w),d=e.fromRectangle3D(r,i,a,y);c=e.union(h,d)}else l=g(s),l=m.scaleToGeodeticHeight(l,n,i,!1),c=e.fromRectangle3D(r,i,n);return new u({attributes:l.attributes,indices:l.indices,primitiveType:p.LINES,boundingSphere:c})},S}),r("Core/ReferenceFrame",["./freezeObject"],function(e){"use strict";var t={FIXED:0,INERTIAL:1};return e(t)}),r("Core/requestAnimationFrame",["./defined","./getTimestamp"],function(e,t){"use strict";var r=window.requestAnimationFrame;!function(){if(!e(r))for(var i=["webkit","moz","ms","o"],n=0,o=i.length;o>n&&!e(r);)r=window[i[n]+"RequestAnimationFrame"],++n;if(!e(r)){var a=1e3/60,s=0;r=function(e){var r=t(),i=Math.max(a-(r-s),0);return s=r+i,setTimeout(function(){e(s)},i)}}}();var i=function(e){return r(e)};return i}),r("Core/sampleTerrain",["../ThirdParty/when","./defined","./DeveloperError"],function(e,t,r){"use strict";function i(t,r,i){var a,s=t.tilingScheme,u=[],l={};for(a=0;a<i.length;++a){var c=s.positionToTileXY(i[a],r),h=c.toString();if(!l.hasOwnProperty(h)){var d={x:c.x,y:c.y,level:r,tilingScheme:s,terrainProvider:t,positions:[]};l[h]=d,u.push(d)}l[h].positions.push(i[a])}var m=[];for(a=0;a<u.length;++a){var p=u[a],f=p.terrainProvider.requestTileGeometry(p.x,p.y,p.level,!1),v=e(f,n(p),o(p));m.push(v)}return e.all(m,function(){return i})}function n(e){var t=e.positions,r=e.tilingScheme.tileXYToRectangle(e.x,e.y,e.level);return function(e){for(var i=0;i<t.length;++i){var n=t[i];n.height=e.interpolateHeight(r,n.longitude,n.latitude)}}}function o(e){var t=e.positions;return function(){for(var e=0;e<t.length;++e){var r=t[e];r.height=void 0}}}var a=function(n,o,a){function s(){n.ready?e(i(n,o,a),function(e){u.resolve(e)}):setTimeout(s,10)}if(!t(n))throw new r("terrainProvider is required.");if(!t(o))throw new r("level is required.");if(!t(a))throw new r("positions is required.");var u=e.defer();return s(),u.promise};return a}),r("Core/ScreenSpaceEventType",["./freezeObject"],function(e){"use strict";var t={LEFT_DOWN:0,LEFT_UP:1,LEFT_CLICK:2,LEFT_DOUBLE_CLICK:3,RIGHT_DOWN:5,RIGHT_UP:6,RIGHT_CLICK:7,RIGHT_DOUBLE_CLICK:8,MIDDLE_DOWN:10,MIDDLE_UP:11,MIDDLE_CLICK:12,MIDDLE_DOUBLE_CLICK:13,MOUSE_MOVE:15,WHEEL:16,PINCH_START:17,PINCH_END:18,PINCH_MOVE:19};return e(t)}),r("Core/ScreenSpaceEventHandler",["./AssociativeArray","./Cartesian2","./defaultValue","./defined","./destroyObject","./DeveloperError","./FeatureDetection","./KeyboardEventModifier","./ScreenSpaceEventType"],function(e,t,r,i,n,o,a,s,u){"use strict";function l(e,t,r){var i=e._element;if(i===document)return r.x=t.clientX,r.y=t.clientY,r;var n=i.getBoundingClientRect();return r.x=t.clientX-n.left,r.y=t.clientY-n.top,r}function c(e,t){var r=e;return i(t)&&(r+="+"+t),r}function h(e){return e.shiftKey?s.SHIFT:e.ctrlKey?s.CTRL:e.altKey?s.ALT:void 0}function d(e,t,r,i){var n=function(t){i(e,t)};r.addEventListener(t,n,!1),e._removalFunctions.push(function(){r.removeEventListener(t,n,!1)})}function m(e){var t=e._element,r=i(t.disableRootEvents)?t:document;a.supportsPointerEvents()?(d(e,"pointerdown",t,T),d(e,"pointerup",t,x),d(e,"pointermove",t,P)):(d(e,"mousedown",t,f),d(e,"mouseup",r,v),d(e,"mousemove",r,g),d(e,"touchstart",t,w),d(e,"touchend",r,C),d(e,"touchmove",r,S)),d(e,"dblclick",t,_);var n;n="onwheel"in t?"wheel":i(document.onmousewheel)?"mousewheel":"DOMMouseScroll",d(e,n,t,y)}function p(e){for(var t=e._removalFunctions,r=0;r<t.length;++r)t[r]()}function f(e,r){if(!e._seenAnyTouchEvents){var n=r.button;e._buttonDown=n;var o;if(n===A.LEFT)o=u.LEFT_DOWN;else if(n===A.MIDDLE)o=u.MIDDLE_DOWN;else{if(n!==A.RIGHT)return;o=u.RIGHT_DOWN}var a=l(e,r,e._primaryPosition);t.clone(a,e._primaryStartPosition),t.clone(a,e._primaryPreviousPosition);var s=h(r),c=e.getInputAction(o,s);i(c)&&(t.clone(a,I.position),c(I),r.preventDefault())}}function v(e,r){if(!e._seenAnyTouchEvents){var n=r.button;e._buttonDown=void 0;var o,a;if(n===A.LEFT)o=u.LEFT_UP,a=u.LEFT_CLICK;else if(n===A.MIDDLE)o=u.MIDDLE_UP,a=u.MIDDLE_CLICK;else{if(n!==A.RIGHT)return;o=u.RIGHT_UP,a=u.RIGHT_CLICK}var s=h(r),c=e.getInputAction(o,s),d=e.getInputAction(a,s);if(i(c)||i(d)){var m=l(e,r,e._primaryPosition);if(i(c)&&(t.clone(m,D.position),c(D)),i(d)){var p=e._primaryStartPosition,f=p.x-m.x,v=p.y-m.y,g=Math.sqrt(f*f+v*v);g<e._clickPixelTolerance&&(t.clone(m,M.position),d(M))}}}}function g(e,r){if(!e._seenAnyTouchEvents){var n=h(r),o=l(e,r,e._primaryPosition),a=e._primaryPreviousPosition,s=e.getInputAction(u.MOUSE_MOVE,n);i(s)&&(t.clone(a,R.startPosition),t.clone(o,R.endPosition),s(R)),t.clone(o,a),i(e._buttonDown)&&r.preventDefault()}}function _(e,t){var r,n=t.button;if(n===A.LEFT)r=u.LEFT_DOUBLE_CLICK;else if(n===A.MIDDLE)r=u.MIDDLE_DOUBLE_CLICK;else{if(n!==A.RIGHT)return;r=u.RIGHT_DOUBLE_CLICK}var o=h(t),a=e.getInputAction(r,o);i(a)&&(l(e,t,O.position),a(O))}function y(e,t){var r;if(i(t.deltaY)){var n=t.deltaMode;r=n===t.DOM_DELTA_PIXEL?-t.deltaY:n===t.DOM_DELTA_LINE?40*-t.deltaY:120*-t.deltaY}else r=t.detail>0?-120*t.detail:t.wheelDelta;if(i(r)){var o=h(t),a=e.getInputAction(u.WHEEL,o);i(a)&&(a(r),t.preventDefault())}}function w(e,r){e._seenAnyTouchEvents=!0;var i,n,o,a=r.changedTouches,s=a.length,u=e._positions;for(i=0;s>i;++i)n=a[i],o=n.identifier,u.set(o,l(e,n,new t));E(e,r);var c=e._previousPositions;for(i=0;s>i;++i)n=a[i],o=n.identifier,c.set(o,t.clone(u.get(o)))}function C(e,t){e._seenAnyTouchEvents=!0;var r,i,n,o=t.changedTouches,a=o.length,s=e._positions;for(r=0;a>r;++r)i=o[r],n=i.identifier,s.remove(n);E(e,t);var u=e._previousPositions;for(r=0;a>r;++r)i=o[r],n=i.identifier,u.remove(n)}function E(e,r){var n,o,a=h(r),s=e._positions,l=e._previousPositions,c=s.length;if(1!==c&&e._buttonDown===A.LEFT&&(e._buttonDown=void 0,n=e.getInputAction(u.LEFT_UP,a),i(n)&&(t.clone(e._primaryPosition,F.position),n(F)),0===c&&(o=e.getInputAction(u.LEFT_CLICK,a),i(o)))){var d=e._primaryStartPosition,m=l.values[0],p=d.x-m.x,f=d.y-m.y,v=Math.sqrt(p*p+f*f);v<e._clickPixelTolerance&&(t.clone(e._primaryPosition,B.position),o(B))}if(2!==c&&e._isPinching&&(e._isPinching=!1,n=e.getInputAction(u.PINCH_END,a),i(n)&&n()),1===c){var g=s.values[0];t.clone(g,e._primaryPosition),t.clone(g,e._primaryStartPosition),t.clone(g,e._primaryPreviousPosition),e._buttonDown=A.LEFT,n=e.getInputAction(u.LEFT_DOWN,a),i(n)&&(t.clone(g,N.position),n(N)),r.preventDefault()}2===c&&(e._isPinching=!0,n=e.getInputAction(u.PINCH_START,a),i(n)&&(t.clone(s.values[0],L.position1),t.clone(s.values[1],L.position2),n(L)))}function S(e,r){e._seenAnyTouchEvents=!0;var n,o,a,s=r.changedTouches,u=s.length,c=e._positions;for(n=0;u>n;++n){o=s[n],a=o.identifier;var h=c.get(a);i(h)&&l(e,o,h)}b(e,r);var d=e._previousPositions;for(n=0;u>n;++n)o=s[n],a=o.identifier,t.clone(c.get(a),d.get(a))}function b(e,r){var n,o=h(r),a=e._positions,s=e._previousPositions,l=a.length;if(1===l&&e._buttonDown===A.LEFT){var c=a.values[0];t.clone(c,e._primaryPosition);var d=e._primaryPreviousPosition;n=e.getInputAction(u.MOUSE_MOVE,o),i(n)&&(t.clone(d,z.startPosition),t.clone(c,z.endPosition),n(z)),t.clone(c,d),r.preventDefault()}else if(2===l&&e._isPinching&&(n=e.getInputAction(u.PINCH_MOVE,o),i(n))){var m=a.values[0],p=a.values[1],f=s.values[0],v=s.values[1],g=p.x-m.x,_=p.y-m.y,y=.25*Math.sqrt(g*g+_*_),w=v.x-f.x,C=v.y-f.y,E=.25*Math.sqrt(w*w+C*C),S=.125*(p.y+m.y),b=.125*(v.y+f.y),T=Math.atan2(_,g),x=Math.atan2(C,w);t.fromElements(0,E,V.distance.startPosition),t.fromElements(0,y,V.distance.endPosition),t.fromElements(x,b,V.angleAndHeight.startPosition),t.fromElements(T,S,V.angleAndHeight.endPosition),n(V)}}function T(e,r){if(r.target.setPointerCapture(r.pointerId),"touch"===r.pointerType){var i=e._positions,n=r.pointerId;i.set(n,l(e,r,new t)),E(e,r);var o=e._previousPositions;o.set(n,t.clone(i.get(n)))}else f(e,r)}function x(e,t){if("touch"===t.pointerType){var r=e._positions,i=t.pointerId;r.remove(i),E(e,t);var n=e._previousPositions;n.remove(i)}else v(e,t)}function P(e,r){if("touch"===r.pointerType){var i=e._positions,n=r.pointerId;l(e,r,i.get(n)),b(e,r);var o=e._previousPositions;t.clone(i.get(n),o.get(n))}else g(e,r)}var A={LEFT:0,MIDDLE:1,RIGHT:2},I={position:new t},D={position:new t},M={position:new t},R={startPosition:new t,endPosition:new t},O={position:new t},N={position:new t},L={position1:new t,position2:new t},F={position:new t},B={position:new t},z={startPosition:new t,endPosition:new t},V={distance:{startPosition:new t,endPosition:new t},angleAndHeight:{startPosition:new t,endPosition:new t}},k=function(i){this._inputEvents={},this._buttonDown=void 0,this._isPinching=!1,this._seenAnyTouchEvents=!1,this._primaryStartPosition=new t,this._primaryPosition=new t,this._primaryPreviousPosition=new t,this._positions=new e,this._previousPositions=new e,this._removalFunctions=[],this._clickPixelTolerance=5,this._element=r(i,document),m(this)};return k.prototype.setInputAction=function(e,t,r){if(!i(e))throw new o("action is required.");if(!i(t))throw new o("type is required.");var n=c(t,r);this._inputEvents[n]=e},k.prototype.getInputAction=function(e,t){if(!i(e))throw new o("type is required.");var r=c(e,t);return this._inputEvents[r]},k.prototype.removeInputAction=function(e,t){if(!i(e))throw new o("type is required.");var r=c(e,t);delete this._inputEvents[r]},k.prototype.isDestroyed=function(){return!1},k.prototype.destroy=function(){return p(this),n(this)},k}),r("Core/ShowGeometryInstanceAttribute",["./ComponentDatatype","./defaultValue","./defined","./defineProperties","./DeveloperError"],function(e,t,r,i,n){"use strict";var o=function(e){e=t(e,!0),this.value=o.toValue(e)};return i(o.prototype,{componentDatatype:{get:function(){return e.UNSIGNED_BYTE}},componentsPerAttribute:{get:function(){return 1}},normalize:{get:function(){return!1}}}),o.toValue=function(e,t){if(!r(e))throw new n("show is required.");return r(t)?(t[0]=e,t):new Uint8Array([e])},o}),r("Core/Simon1994PlanetaryPositions",["./Cartesian3","./defined","./DeveloperError","./JulianDate","./Math","./Matrix3","./TimeConstants","./TimeStandard"],function(e,t,r,i,n,o,a,s){"use strict";function u(e){var t=6.239996+.0172019696544*e;return.001657*Math.sin(t+.01671*Math.sin(t))}function l(e,t){t=i.addSeconds(e,w,t);var r=i.totalDays(t)-C;return t=i.addSeconds(t,u(r),t)}function c(i,a,s,u,l,c,m,p){if(0>s&&(s=-s,l+=n.PI),0>s||s>n.PI)throw new r("The inclination is out of range. Inclination must be greater than or equal to zero and less than or equal to Pi radians.");var v=i*(1-a),g=u-l,_=l,y=d(c-u,a),w=h(a,0);if("Hyperbolic"===w&&Math.abs(n.negativePiToPi(y))>=Math.acos(-1/a))throw new r("The true anomaly of the hyperbolic orbit lies outside of the bounds of the hyperbola.");f(g,s,_,I);var C=v*(1+a),E=Math.cos(y),S=Math.sin(y),b=1+a*E;if(b<=n.Epsilon10)throw new r("elements cannot be converted to cartesian");var T=C/b;return t(p)?(p.x=T*E,p.y=T*S,p.z=0):p=new e(T*E,T*S,0),o.multiplyByVector(I,p,p)}function h(e,t){if(0>e)throw new r("eccentricity cannot be negative.");return t>=e?"Circular":1-t>e?"Elliptical":1+t>=e?"Parabolic":"Hyperbolic"}function d(e,t){if(0>t||t>=1)throw new r("eccentricity out of range.");var i=m(e,t);return p(i,t)}function m(e,t){if(0>t||t>=1)throw new r("eccentricity out of range.");var i=Math.floor(e/n.TWO_PI);e-=i*n.TWO_PI;var o,a=e+t*Math.sin(e)/(1-Math.sin(e+t)+Math.sin(e)),s=Number.MAX_VALUE;for(o=0;D>o&&Math.abs(s-a)>M;++o){s=a;var u=s-t*Math.sin(s)-e,l=1-t*Math.cos(s);a=s-u/l}if(o>=D)throw new r("Kepler equation did not converge");return s=a+i*n.TWO_PI}function p(e,t){if(0>t||t>=1)throw new r("eccentricity out of range.");var i=Math.floor(e/n.TWO_PI);e-=i*n.TWO_PI;var o=Math.cos(e)-t,a=Math.sin(e)*Math.sqrt(1-t*t),s=Math.atan2(a,o);return s=n.zeroToTwoPi(s),0>e&&(s-=n.TWO_PI),s+=i*n.TWO_PI}function f(e,i,a,s){if(0>i||i>n.PI)throw new r("inclination out of range");var u=Math.cos(e),l=Math.sin(e),c=Math.cos(i),h=Math.sin(i),d=Math.cos(a),m=Math.sin(a);return t(s)?(s[0]=d*u-m*l*c,s[1]=m*u+d*l*c,s[2]=l*h,s[3]=-d*l-m*u*c,s[4]=-m*l+d*u*c,s[5]=u*h,s[6]=m*h,s[7]=-d*h,s[8]=c):s=new o(d*u-m*l*c,-d*l-m*u*c,m*h,m*u+d*l*c,-m*l+d*u*c,-d*h,l*h,u*h,c),s}function v(e,t){l(e,Ie);var r=Ie.dayNumber-E.dayNumber+(Ie.secondsOfDay-E.secondsOfDay)/a.SECONDS_PER_DAY,i=r/(10*a.DAYS_PER_JULIAN_CENTURY),n=.3595362*i,o=R+G*Math.cos(L*n)+Q*Math.sin(L*n)+W*Math.cos(F*n)+J*Math.sin(F*n)+H*Math.cos(B*n)+$*Math.sin(B*n)+j*Math.cos(z*n)+ee*Math.sin(z*n)+Y*Math.cos(V*n)+te*Math.sin(V*n)+X*Math.cos(k*n)+re*Math.sin(k*n)+Z*Math.cos(U*n)+ie*Math.sin(U*n)+K*Math.cos(q*n)+ne*Math.sin(q*n),s=O+N*i+me*Math.cos(oe*n)+Ce*Math.sin(oe*n)+pe*Math.cos(ae*n)+Ee*Math.sin(ae*n)+fe*Math.cos(se*n)+Se*Math.sin(se*n)+ve*Math.cos(ue*n)+be*Math.sin(ue*n)+ge*Math.cos(le*n)+Te*Math.sin(le*n)+_e*Math.cos(ce*n)+xe*Math.sin(ce*n)+ye*Math.cos(he*n)+Pe*Math.sin(he*n)+we*Math.cos(de*n)+Ae*Math.sin(de*n),u=.0167086342-.0004203654*i,h=102.93734808*x+11612.3529*P*i,d=469.97289*P*i,m=174.87317577*x-8679.27034*P*i;return c(o,u,d,h,m,s,b,t)}function g(e,t){l(e,Ie);var r=Ie.dayNumber-E.dayNumber+(Ie.secondsOfDay-E.secondsOfDay)/a.SECONDS_PER_DAY,i=r/a.DAYS_PER_JULIAN_CENTURY,n=i*i,o=n*i,s=o*i,u=383397.7725+.004*i,h=.055545526-1.6e-8*i,d=5.15668983*x,m=-8e-5*i+.02966*n-42e-6*o-1.3e-7*s,p=83.35324312*x,f=14643420.2669*i-38.2702*n-.045047*o+21301e-8*s,v=125.04455501*x,g=-6967919.3631*i+6.3602*n+.007625*o-3586e-8*s,_=218.31664563*x,y=1732559343.4847*i-6.391*n+.006588*o-3169e-8*s,w=297.85019547*x+P*(1602961601.209*i-6.3706*n+.006593*o-3169e-8*s),C=93.27209062*x+P*(1739527262.8478*i-12.7512*n-.001037*o+417e-8*s),b=134.96340251*x+P*(1717915923.2178*i+31.8792*n+.051635*o-2447e-7*s),A=357.52910918*x+P*(129596581.0481*i-.5532*n+136e-6*o-1149e-8*s),I=310.17137918*x-P*(6967051.436*i+6.2068*n+.007618*o-3219e-8*s),D=2*w,M=4*w,R=6*w,O=2*b,N=3*b,L=4*b,F=2*C;u+=3400.4*Math.cos(D)-635.6*Math.cos(D-b)-235.6*Math.cos(b)+218.1*Math.cos(D-A)+181*Math.cos(D+b),h+=.014216*Math.cos(D-b)+.008551*Math.cos(D-O)-.001383*Math.cos(b)+.001356*Math.cos(D+b)-.001147*Math.cos(M-N)-914e-6*Math.cos(M-O)+869e-6*Math.cos(D-A-b)-627e-6*Math.cos(D)-394e-6*Math.cos(M-L)+282e-6*Math.cos(D-A-O)-279e-6*Math.cos(w-b)-236e-6*Math.cos(O)+231e-6*Math.cos(M)+229e-6*Math.cos(R-L)-201e-6*Math.cos(O-F),m+=486.26*Math.cos(D-F)-40.13*Math.cos(D)+37.51*Math.cos(F)+25.73*Math.cos(O-F)+19.97*Math.cos(D-A-F),f+=-55609*Math.sin(D-b)-34711*Math.sin(D-O)-9792*Math.sin(b)+9385*Math.sin(M-N)+7505*Math.sin(M-O)+5318*Math.sin(D+b)+3484*Math.sin(M-L)-3417*Math.sin(D-A-b)-2530*Math.sin(R-L)-2376*Math.sin(D)-2075*Math.sin(D-N)-1883*Math.sin(O)-1736*Math.sin(R-5*b)+1626*Math.sin(A)-1370*Math.sin(R-N),g+=-5392*Math.sin(D-F)-540*Math.sin(A)-441*Math.sin(D)+423*Math.sin(F)-288*Math.sin(O-F),y+=-3332.9*Math.sin(D)+1197.4*Math.sin(D-b)-662.5*Math.sin(A)+396.3*Math.sin(b)-218*Math.sin(D-A);var B=2*I,z=3*I;m+=46.997*Math.cos(I)*i-.614*Math.cos(D-F+I)*i+.614*Math.cos(D-F-I)*i-.0297*Math.cos(B)*n-.0335*Math.cos(I)*n+.0012*Math.cos(D-F+B)*n-16e-5*Math.cos(I)*o+4e-5*Math.cos(z)*o+4e-5*Math.cos(B)*o;var V=2.116*Math.sin(I)*i-.111*Math.sin(D-F-I)*i-.0015*Math.sin(I)*n;f+=V,y+=V,g+=-520.77*Math.sin(I)*i+13.66*Math.sin(D-F+I)*i+1.12*Math.sin(D-I)*i-1.06*Math.sin(F-I)*i+.66*Math.sin(B)*n+.371*Math.sin(I)*n-.035*Math.sin(D-F+B)*n-.015*Math.sin(D-F+I)*n+.0014*Math.sin(I)*o-.0011*Math.sin(z)*o-9e-4*Math.sin(B)*o,u*=T;var k=d+m*P,U=p+f*P,q=_+y*P,G=v+g*P;return c(u,h,k,U,G,q,S,t)}function _(t,r){return r=g(t,r),e.multiplyByScalar(r,Me,r)}var y={},w=32.184,C=2451545,E=new i(2451545,0,s.TAI),S=398600435e6,b=1.012300034*S*328900.56,T=1e3,x=n.RADIANS_PER_DEGREE,P=n.RADIANS_PER_ARCSECOND,A=14959787e4,I=new o,D=50,M=n.EPSILON8,R=1.0000010178*A,O=100.46645683*x,N=1295977422.83429*P,L=16002,F=21863,B=32004,z=10931,V=14529,k=16368,U=15318,q=32794,G=64e-7*A,W=-152*1e-7*A,H=62e-7*A,j=-8e-7*A,Y=32e-7*A,X=-41*1e-7*A,Z=19e-7*A,K=-11*1e-7*A,Q=-150*1e-7*A,J=-46*1e-7*A,$=68*1e-7*A,ee=54e-7*A,te=14e-7*A,re=24e-7*A,ie=-28*1e-7*A,ne=22e-7*A,oe=10,ae=16002,se=21863,ue=10931,le=1473,ce=32004,he=4387,de=73,me=-325*1e-7,pe=-322*1e-7,fe=-79*1e-7,ve=232*1e-7,ge=-52*1e-7,_e=97e-7,ye=55e-7,we=-41*1e-7,Ce=-105*1e-7,Ee=-137*1e-7,Se=258e-7,be=35e-7,Te=-116*1e-7,xe=-88*1e-7,Pe=-112*1e-7,Ae=-80*1e-7,Ie=new i(0,0,s.TAI),De=.012300034,Me=De/(De+1)*-1,Re=new o(1.0000000000000002,5.619723173785822e-16,4.690511510146299e-19,-5.154129427414611e-16,.9174820620691819,-.39777715593191376,-2.23970096136568e-16,.39777715593191376,.9174820620691819),Oe=new e;return y.computeSunPositionInEarthInertialFrame=function(r,n){return t(r)||(r=i.now()),t(n)||(n=new e),Oe=v(r,Oe),n=e.negate(Oe,n),_(r,Oe),e.subtract(n,Oe,n),o.multiplyByVector(Re,n,n),n},y.computeMoonPositionInEarthInertialFrame=function(e,r){return t(e)||(e=i.now()),r=g(e,r),o.multiplyByVector(Re,r,r),r},y}),r("Core/SimplePolylineGeometry",["./BoundingSphere","./Cartesian3","./Color","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PolylinePipeline","./PrimitiveType"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p){"use strict";function f(e,t,i,n,o,a,s){var u,l=m.numberOfPoints(e,t,o),c=i.red,h=i.green,d=i.blue,p=i.alpha,f=n.red,v=n.green,g=n.blue,_=n.alpha;if(r.equals(i,n)){for(u=0;l>u;u++)a[s++]=r.floatToByte(c),a[s++]=r.floatToByte(h),a[s++]=r.floatToByte(d),a[s++]=r.floatToByte(p);return s}var y=(f-c)/l,w=(v-h)/l,C=(g-d)/l,E=(_-p)/l,S=s;for(u=0;l>u;u++)a[S++]=r.floatToByte(c+u*y),a[S++]=r.floatToByte(h+u*w),a[S++]=r.floatToByte(d+u*C),a[S++]=r.floatToByte(p+u*E);return S}var v=function(e){e=n(e,n.EMPTY_OBJECT);var i=e.positions,u=e.colors,l=n(e.colorsPerVertex,!1);if(!o(i)||i.length<2)throw new a("At least two positions are required.");if(o(u)&&(l&&u.length<i.length||!l&&u.length<i.length-1))throw new a("colors has an invalid length.");this._positions=i,this._colors=u,this._colorsPerVertex=l,this._followSurface=n(e.followSurface,!0),this._granularity=n(e.granularity,d.RADIANS_PER_DEGREE),this._ellipsoid=n(e.ellipsoid,s.WGS84),this._workerName="createSimplePolylineGeometry";var c=1+i.length*t.packedLength;c+=o(u)?1+u.length*r.packedLength:1,this.packedLength=c+s.packedLength+3};v.pack=function(e,i,u){if(!o(e))throw new a("value is required");if(!o(i))throw new a("array is required");u=n(u,0);var l,c=e._positions,h=c.length;for(i[u++]=h,l=0;h>l;++l,u+=t.packedLength)t.pack(c[l],i,u);var d=e._colors;for(h=o(d)?d.length:0,i[u++]=h,l=0;h>l;++l,u+=r.packedLength)r.pack(d[l],i,u);s.pack(e._ellipsoid,i,u),u+=s.packedLength,i[u++]=e._colorsPerVertex?1:0,i[u++]=e._followSurface?1:0,i[u]=e._granularity},v.unpack=function(e,i,u){if(!o(e))throw new a("array is required");i=n(i,0);var l,c=e[i++],h=new Array(c);for(l=0;c>l;++l,i+=t.packedLength)h[l]=t.unpack(e,i);c=e[i++];var d=c>0?new Array(c):void 0;for(l=0;c>l;++l,i+=r.packedLength)d[l]=r.unpack(e,i);var m=s.unpack(e,i);i+=s.packedLength;var p=1===e[i++],f=1===e[i++],g=e[i];return o(u)?(u._positions=h,u._colors=d,u._ellipsoid=m,u._colorsPerVertex=p,u._followSurface=f,u._granularity=g,u):new v({positions:h,colors:d,ellipsoid:m,colorsPerVertex:p,followSurface:f,granularity:g})};var g=new Array(2),_=new Array(2),y={positions:g,height:_,ellipsoid:void 0,minDistance:void 0};return v.createGeometry=function(n){var a,s,v,w,C,E=n._positions,S=n._colors,b=n._colorsPerVertex,T=n._followSurface,x=n._granularity,P=n._ellipsoid,A=d.chordLength(x,P.maximumRadius),I=o(S)&&!b,D=E.length,M=0;if(T){var R=m.extractHeights(E,P),O=y;if(O.minDistance=A,O.ellipsoid=P,I){var N=0;for(a=0;D-1>a;a++)N+=m.numberOfPoints(E[a],E[a+1],A)+1;s=new Float64Array(3*N),w=new Uint8Array(4*N),O.positions=g,O.height=_;var L=0;for(a=0;D-1>a;++a){g[0]=E[a],g[1]=E[a+1],_[0]=R[a],_[1]=R[a+1];var F=m.generateArc(O);if(o(S)){var B=F.length/3;C=S[a];for(var z=0;B>z;++z)w[L++]=r.floatToByte(C.red),w[L++]=r.floatToByte(C.green),w[L++]=r.floatToByte(C.blue),w[L++]=r.floatToByte(C.alpha)}s.set(F,M),M+=F.length}}else if(O.positions=E,O.height=R,s=new Float64Array(m.generateArc(O)),o(S)){for(w=new Uint8Array(s.length/3*4),a=0;D-1>a;++a){var V=E[a],k=E[a+1],U=S[a],q=S[a+1];M=f(V,k,U,q,A,w,M)}var G=S[D-1];w[M++]=r.floatToByte(G.red),w[M++]=r.floatToByte(G.green),w[M++]=r.floatToByte(G.blue),w[M++]=r.floatToByte(G.alpha)}}else{v=I?2*D-2:D,s=new Float64Array(3*v),w=o(S)?new Uint8Array(4*v):void 0;var W=0,H=0;for(a=0;D>a;++a){var j=E[a];if(I&&a>0&&(t.pack(j,s,W),W+=3,C=S[a-1],w[H++]=r.floatToByte(C.red),w[H++]=r.floatToByte(C.green),w[H++]=r.floatToByte(C.blue),w[H++]=r.floatToByte(C.alpha)),I&&a===D-1)break;t.pack(j,s,W),W+=3,o(S)&&(C=S[a],w[H++]=r.floatToByte(C.red),w[H++]=r.floatToByte(C.green),w[H++]=r.floatToByte(C.blue),w[H++]=r.floatToByte(C.alpha))}}var Y=new c;Y.position=new l({componentDatatype:i.DOUBLE,componentsPerAttribute:3,values:s}),o(S)&&(Y.color=new l({componentDatatype:i.UNSIGNED_BYTE,componentsPerAttribute:4,values:w,normalize:!0})),v=s.length/3;var X=2*(v-1),Z=h.createTypedArray(v,X),K=0;for(a=0;v-1>a;++a)Z[K++]=a,Z[K++]=a+1;return new u({attributes:Y,indices:Z,primitiveType:p.LINES,boundingSphere:e.fromPoints(E)})},v}),r("Core/SphereGeometry",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./EllipsoidGeometry","./VertexFormat"],function(e,t,r,i,n,o){"use strict";var a=function(r){var i=t(r.radius,1),o=new e(i,i,i),a={radii:o,stackPartitions:r.stackPartitions,slicePartitions:r.slicePartitions,vertexFormat:r.vertexFormat};this._ellipsoidGeometry=new n(a),this._workerName="createSphereGeometry"};a.packedLength=n.packedLength,a.pack=function(e,t,o){if(!r(e))throw new i("value is required");n.pack(e._ellipsoidGeometry,t,o)};var s=new n,u={radius:void 0,radii:new e,vertexFormat:new o,stackPartitions:void 0,slicePartitions:void 0};return a.unpack=function(t,i,l){var c=n.unpack(t,i,s);return u.vertexFormat=o.clone(c._vertexFormat,u.vertexFormat),u.stackPartitions=c._stackPartitions,u.slicePartitions=c._slicePartitions,r(l)?(e.clone(c._radii,u.radii),l._ellipsoidGeometry=new n(u),l):(u.radius=c._radii.x,new a(u))},a.createGeometry=function(e){return n.createGeometry(e._ellipsoidGeometry)},a}),r("Core/SphereOutlineGeometry",["./Cartesian3","./defaultValue","./defined","./DeveloperError","./EllipsoidOutlineGeometry"],function(e,t,r,i,n){"use strict";var o=function(r){var i=t(r.radius,1),o=new e(i,i,i),a={radii:o,stackPartitions:r.stackPartitions,slicePartitions:r.slicePartitions,subdivisions:r.subdivisions};this._ellipsoidGeometry=new n(a),this._workerName="createSphereOutlineGeometry"};o.packedLength=n.packedLength,o.pack=function(e,t,o){if(!r(e))throw new i("value is required");n.pack(e._ellipsoidGeometry,t,o)};var a=new n,s={radius:void 0,radii:new e,stackPartitions:void 0,slicePartitions:void 0,subdivisions:void 0};return o.unpack=function(t,i,u){var l=n.unpack(t,i,a);return s.stackPartitions=l._stackPartitions,s.slicePartitions=l._slicePartitions,s.subdivisions=l._subdivisions,r(u)?(e.clone(l._radii,s.radii),u._ellipsoidGeometry=new n(s),u):(s.radius=l._radii.x,new o(s))},o.createGeometry=function(e){return n.createGeometry(e._ellipsoidGeometry)},o}),r("Core/Spherical",["./defaultValue","./defined","./DeveloperError"],function(e,t,r){"use strict";var i=function(t,r,i){this.clock=e(t,0),this.cone=e(r,0),this.magnitude=e(i,1)};return i.fromCartesian3=function(e,n){if(!t(e))throw new r("cartesian3 is required");var o=e.x,a=e.y,s=e.z,u=o*o+a*a;return t(n)||(n=new i),n.clock=Math.atan2(a,o),n.cone=Math.atan2(Math.sqrt(u),s),n.magnitude=Math.sqrt(u+s*s),n},i.clone=function(e,r){return t(e)?t(r)?(r.clock=e.clock,r.cone=e.cone,r.magnitude=e.magnitude,r):new i(e.clock,e.cone,e.magnitude):void 0},i.normalize=function(e,n){if(!t(e))throw new r("spherical is required");return t(n)?(n.clock=e.clock,n.cone=e.cone,n.magnitude=1,n):new i(e.clock,e.cone,1)},i.equals=function(e,r){return e===r||t(e)&&t(r)&&e.clock===r.clock&&e.cone===r.cone&&e.magnitude===r.magnitude},i.equalsEpsilon=function(r,i,n){return n=e(n,0),r===i||t(r)&&t(i)&&Math.abs(r.clock-i.clock)<=n&&Math.abs(r.cone-i.cone)<=n&&Math.abs(r.magnitude-i.magnitude)<=n},i.prototype.equals=function(e){return i.equals(this,e)},i.prototype.clone=function(e){return i.clone(this,e)},i.prototype.equalsEpsilon=function(e,t){return i.equalsEpsilon(this,e,t)},i.prototype.toString=function(){return"("+this.clock+", "+this.cone+", "+this.magnitude+")"},i}),r("Core/subdivideArray",["./defined","./DeveloperError"],function(e,t){"use strict";var r=function(r,i){if(!e(r))throw new t("array is required.");if(!e(i)||1>i)throw new t("numberOfArrays must be greater than 0.");for(var n=[],o=r.length,a=0;o>a;){var s=Math.ceil((o-a)/i--);n.push(r.slice(a,a+s)),a+=s}return n};return r}),r("Core/TerrainData",["./defineProperties","./DeveloperError"],function(e,t){"use strict";var r=function(){t.throwInstantiationError()};return e(r.prototype,{waterMask:{get:t.throwInstantiationError}}),r.prototype.interpolateHeight=t.throwInstantiationError,r.prototype.isChildAvailable=t.throwInstantiationError,r.prototype.createMesh=t.throwInstantiationError,r.prototype.upsample=t.throwInstantiationError,r.prototype.wasCreatedByUpsampling=t.throwInstantiationError,r}),r("Core/TilingScheme",["./defineProperties","./DeveloperError"],function(e,t){"use strict";var r=function(e){throw new t("This type should not be instantiated directly.  Instead, use WebMercatorTilingScheme or GeographicTilingScheme.")};return e(r.prototype,{ellipsoid:{get:t.throwInstantiationError},rectangle:{get:t.throwInstantiationError},projection:{get:t.throwInstantiationError}}),r.prototype.getNumberOfXTilesAtLevel=t.throwInstantiationError,r.prototype.getNumberOfYTilesAtLevel=t.throwInstantiationError,r.prototype.rectangleToNativeRectangle=t.throwInstantiationError,r.prototype.tileXYToNativeRectangle=t.throwInstantiationError,r.prototype.tileXYToRectangle=t.throwInstantiationError,r.prototype.positionToTileXY=t.throwInstantiationError,r}),r("Core/TimeIntervalCollection",["./binarySearch","./defaultValue","./defined","./defineProperties","./DeveloperError","./Event","./JulianDate","./TimeInterval"],function(e,t,r,i,n,o,a,s){"use strict";function u(e,t){return a.compare(e.start,t.start)}var l=function(e){if(this._intervals=[],this._changedEvent=new o,r(e))for(var t=e.length,i=0;t>i;i++)this.addInterval(e[i])};i(l.prototype,{changedEvent:{get:function(){return this._changedEvent}},start:{get:function(){var e=this._intervals;return 0===e.length?void 0:e[0].start}},isStartIncluded:{get:function(){var e=this._intervals;return 0===e.length?!1:e[0].isStartIncluded}},stop:{get:function(){var e=this._intervals,t=e.length;return 0===t?void 0:e[t-1].stop}},isStopIncluded:{get:function(){var e=this._intervals,t=e.length;return 0===t?!1:e[t-1].isStopIncluded}},length:{get:function(){return this._intervals.length}},isEmpty:{get:function(){return 0===this._intervals.length}}}),l.prototype.equals=function(e,t){if(this===e)return!0;if(!(e instanceof l))return!1;var r=this._intervals,i=e._intervals,n=r.length;if(n!==i.length)return!1;for(var o=0;n>o;o++)if(!s.equals(r[o],i[o],t))return!1;return!0},l.prototype.get=function(e){if(!r(e))throw new n("index is required.");return this._intervals[e]},l.prototype.removeAll=function(){this._intervals.length>0&&(this._intervals.length=0,this._changedEvent.raiseEvent(this))},l.prototype.findIntervalContainingDate=function(e){var t=this.indexOf(e);return t>=0?this._intervals[t]:void 0},l.prototype.findDataForIntervalContainingDate=function(e){var t=this.indexOf(e);return t>=0?this._intervals[t].data:void 0},l.prototype.contains=function(e){return this.indexOf(e)>=0};var c=new s;return l.prototype.indexOf=function(t){if(!r(t))throw new n("date is required");var i=this._intervals;c.start=t,c.stop=t;var o=e(i,c,u);return o>=0?i[o].isStartIncluded?o:o>0&&i[o-1].stop.equals(t)&&i[o-1].isStopIncluded?o-1:~o:(o=~o,o>0&&o-1<i.length&&s.contains(i[o-1],t)?o-1:~o)},l.prototype.findInterval=function(e){e=t(e,t.EMPTY_OBJECT);for(var i=e.start,n=e.stop,o=e.isStartIncluded,a=e.isStopIncluded,s=this._intervals,u=0,l=s.length;l>u;u++){var c=s[u];if(!(r(i)&&!c.start.equals(i)||r(n)&&!c.stop.equals(n)||r(o)&&c.isStartIncluded!==o||r(a)&&c.isStopIncluded!==a))return s[u]}return void 0},l.prototype.addInterval=function(t,i){if(!r(t))throw new n("interval is required");if(!t.isEmpty){var o,l,c=this._intervals;if(0===c.length||a.greaterThan(t.start,c[c.length-1].stop))return c.push(t),void this._changedEvent.raiseEvent(this);for(l=e(c,t,u),0>l?l=~l:l>0&&t.isStartIncluded&&c[l-1].isStartIncluded&&c[l-1].start.equals(t.start)?--l:l<c.length&&!t.isStartIncluded&&c[l].isStartIncluded&&c[l].start.equals(t.start)&&++l,l>0&&(o=a.compare(c[l-1].stop,t.start),(o>0||0===o&&(c[l-1].isStopIncluded||t.isStartIncluded))&&((r(i)?i(c[l-1].data,t.data):c[l-1].data===t.data)?(t=new s(a.greaterThan(t.stop,c[l-1].stop)?{start:c[l-1].start,stop:t.stop,isStartIncluded:c[l-1].isStartIncluded,isStopIncluded:t.isStopIncluded,data:t.data}:{start:c[l-1].start,stop:c[l-1].stop,isStartIncluded:c[l-1].isStartIncluded,isStopIncluded:c[l-1].isStopIncluded||t.stop.equals(c[l-1].stop)&&t.isStopIncluded,data:t.data}),c.splice(l-1,1),--l):(o=a.compare(c[l-1].stop,t.stop),o>0||0===o&&c[l-1].isStopIncluded&&!t.isStopIncluded?c.splice(l-1,1,new s({
start:c[l-1].start,stop:t.start,isStartIncluded:c[l-1].isStartIncluded,isStopIncluded:!t.isStartIncluded,data:c[l-1].data}),new s({start:t.stop,stop:c[l-1].stop,isStartIncluded:!t.isStopIncluded,isStopIncluded:c[l-1].isStopIncluded,data:c[l-1].data})):c[l-1]=new s({start:c[l-1].start,stop:t.start,isStartIncluded:c[l-1].isStartIncluded,isStopIncluded:!t.isStartIncluded,data:c[l-1].data}))));l<c.length&&(o=a.compare(t.stop,c[l].start),o>0||0===o&&(t.isStopIncluded||c[l].isStartIncluded));)if(r(i)?i(c[l].data,t.data):c[l].data===t.data)t=new s({start:t.start,stop:a.greaterThan(c[l].stop,t.stop)?c[l].stop:t.stop,isStartIncluded:t.isStartIncluded,isStopIncluded:a.greaterThan(c[l].stop,t.stop)?c[l].isStopIncluded:t.isStopIncluded,data:t.data}),c.splice(l,1);else{if(c[l]=new s({start:t.stop,stop:c[l].stop,isStartIncluded:!t.isStopIncluded,isStopIncluded:c[l].isStopIncluded,data:c[l].data}),!c[l].isEmpty)break;c.splice(l,1)}c.splice(l,0,t),this._changedEvent.raiseEvent(this)}},l.prototype.removeInterval=function(t){if(!r(t))throw new n("interval is required");if(t.isEmpty)return!1;var i=!1,o=this._intervals,l=e(o,t,u);0>l&&(l=~l);var c=t.start,h=t.stop,d=t.isStartIncluded,m=t.isStopIncluded;if(l>0){var p=o[l-1],f=p.stop;(a.greaterThan(f,c)||s.equals(f,c)&&p.isStopIncluded&&d)&&(i=!0,(a.greaterThan(f,h)||p.isStopIncluded&&!m&&s.equals(f,h))&&o.splice(l,0,new s({start:h,stop:f,isStartIncluded:!m,isStopIncluded:p.isStopIncluded,data:p.data})),o[l-1]=new s({start:p.start,stop:c,isStartIncluded:p.isStartIncluded,isStopIncluded:!d,data:p.data}))}var v=o[l];for(l<o.length&&!d&&v.isStartIncluded&&c.equals(v.start)&&(i=!0,o.splice(l,0,new s({start:v.start,stop:v.start,isStartIncluded:!0,isStopIncluded:!0,data:v.data})),++l,v=o[l]);l<o.length&&a.greaterThan(h,v.stop);)i=!0,o.splice(l,1);return l<o.length&&h.equals(v.stop)&&(i=!0,!m&&v.isStopIncluded?(l+1<o.length&&o[l+1].start.equals(h)&&v.data===o[l+1].data?(o.splice(l,1),v=new s({start:v.start,stop:v.stop,isStartIncluded:!0,isStopIncluded:v.isStopIncluded,data:v.data})):v=new s({start:h,stop:h,isStartIncluded:!0,isStopIncluded:!0,data:v.data}),o[l]=v):o.splice(l,1)),l<o.length&&(a.greaterThan(h,v.start)||h.equals(v.start)&&m&&v.isStartIncluded)&&(i=!0,o[l]=new s({start:h,stop:v.stop,isStartIncluded:!m,isStopIncluded:v.isStopIncluded,data:v.data})),i&&this._changedEvent.raiseEvent(this),i},l.prototype.intersect=function(e,t,i){if(!r(e))throw new n("other is required.");for(var o=0,u=0,c=new l,h=this._intervals,d=e._intervals;o<h.length&&u<d.length;){var m=h[o],p=d[u];if(a.lessThan(m.stop,p.start))++o;else if(a.lessThan(p.stop,m.start))++u;else{if(r(i)||r(t)&&t(m.data,p.data)||!r(t)&&p.data===m.data){var f=s.intersect(m,p,new s,i);f.isEmpty||c.addInterval(f,t)}a.lessThan(m.stop,p.stop)||m.stop.equals(p.stop)&&!m.isStopIncluded&&p.isStopIncluded?++o:++u}}return c},l}),r("Core/VRTheWorldTerrainProvider",["../ThirdParty/when","./Credit","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Event","./GeographicTilingScheme","./getImagePixels","./HeightmapTerrainData","./loadImage","./loadXML","./Math","./Rectangle","./TerrainProvider","./throttleRequestByServer","./TileProviderError"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f,v,g){"use strict";function _(e,t){this.rectangle=e,this.maxLevel=t}function y(e,t,r,n){for(var o=e._tilingScheme,a=e._rectangles,s=o.tileXYToRectangle(t,r,n),u=0,l=0;l<a.length&&15!==u;++l){var c=a[l];if(!(c.maxLevel<=n)){var h=c.rectangle,d=p.intersection(h,s,E);i(d)&&(w(o,h,2*t,2*r,n+1)&&(u|=4),w(o,h,2*t+1,2*r,n+1)&&(u|=8),w(o,h,2*t,2*r+1,n+1)&&(u|=1),w(o,h,2*t+1,2*r+1,n+1)&&(u|=2))}}return u}function w(e,t,r,n,o){var a=e.tileXYToRectangle(r,n,o);return i(p.intersection(a,t,E))}var C=function(n){function l(e){var t=e.getElementsByTagName("SRS")[0].textContent;if("EPSG:4326"!==t)return void c("SRS "+t+" is not supported.");w._tilingScheme=new u({ellipsoid:C});var r=e.getElementsByTagName("TileFormat")[0];w._heightmapWidth=parseInt(r.getAttribute("width"),10),w._heightmapHeight=parseInt(r.getAttribute("height"),10),w._levelZeroMaximumGeometricError=f.getEstimatedLevelZeroGeometricErrorForAHeightmap(C,Math.min(w._heightmapWidth,w._heightmapHeight),w._tilingScheme.getNumberOfXTilesAtLevel(0));for(var i=e.getElementsByTagName("DataExtent"),n=0;n<i.length;++n){var o=i[n],a=m.toRadians(parseFloat(o.getAttribute("minx"))),s=m.toRadians(parseFloat(o.getAttribute("miny"))),l=m.toRadians(parseFloat(o.getAttribute("maxx"))),h=m.toRadians(parseFloat(o.getAttribute("maxy"))),d=parseInt(o.getAttribute("maxlevel"),10);w._rectangles.push(new _(new p(a,s,l,h),d))}w._ready=!0}function c(e){var t=r(e,"An error occurred while accessing "+w._url+".");y=g.handleError(y,w,w._errorEvent,t,void 0,void 0,void 0,h)}function h(){e(d(w._url),l,c)}if(n=r(n,r.EMPTY_OBJECT),!i(n.url))throw new o("options.url is required.");this._url=n.url,this._url.length>0&&"/"!==this._url[this._url.length-1]&&(this._url+="/"),this._errorEvent=new s,this._ready=!1,this._proxy=n.proxy,this._terrainDataStructure={heightScale:.001,heightOffset:-1e3,elementsPerHeight:3,stride:4,elementMultiplier:256,isBigEndian:!0};var v=n.credit;"string"==typeof v&&(v=new t(v)),this._credit=v,this._tilingScheme=void 0,this._rectangles=[];var y,w=this,C=r(n.ellipsoid,a.WGS84);h()};n(C.prototype,{errorEvent:{get:function(){return this._errorEvent}},credit:{get:function(){return this._credit}},tilingScheme:{get:function(){if(!this.ready)throw new o("requestTileGeometry must not be called before ready returns true.");return this._tilingScheme}},ready:{get:function(){return this._ready}},hasWaterMask:{get:function(){return!1}},hasVertexNormals:{get:function(){return!1}}}),C.prototype.requestTileGeometry=function(t,n,a,s){if(!this.ready)throw new o("requestTileGeometry must not be called before ready returns true.");var u=this._tilingScheme.getNumberOfYTilesAtLevel(a),d=this._url+a+"/"+t+"/"+(u-n-1)+".tif?cesium=true",m=this._proxy;i(m)&&(d=m.getURL(d));var p;if(s=r(s,!0)){if(p=v(d,h),!i(p))return void 0}else p=h(d);var f=this;return e(p,function(e){return new c({buffer:l(e),width:f._heightmapWidth,height:f._heightmapHeight,childTileMask:y(f,t,n,a),structure:f._terrainDataStructure})})},C.prototype.getLevelMaximumGeometricError=function(e){if(!this.ready)throw new o("requestTileGeometry must not be called before ready returns true.");return this._levelZeroMaximumGeometricError/(1<<e)};var E=new p;return C.prototype.getTileDataAvailable=function(e,t,r){return void 0},C}),r("Core/WallGeometryLibrary",["./Cartographic","./defined","./DeveloperError","./EllipsoidTangentPlane","./Math","./PolygonPipeline","./PolylinePipeline","./WindingOrder"],function(e,t,r,i,n,o,a,s){"use strict";function u(e,t){return n.equalsEpsilon(e.latitude,t.latitude,n.EPSILON14)&&n.equalsEpsilon(e.longitude,t.longitude,n.EPSILON14)}function l(r,i,n,o){var a=i.length;if(2>a)return{positions:i};var s=t(o),l=t(n),c=new Array(a),m=new Array(a),p=new Array(a),f=i[0];c[0]=f;var v=r.cartesianToCartographic(f,h);l&&(v.height=n[0]),m[0]=v.height,s?p[0]=o[0]:p[0]=0;for(var g=1,_=1;a>_;++_){var y=i[_],w=r.cartesianToCartographic(y,d);l&&(w.height=n[_]),u(v,w)?v.height<w.height&&(m[g-1]=w.height):(c[g]=y,m[g]=w.height,s?p[g]=o[_]:p[g]=0,e.clone(w,v),++g)}return c.length=g,m.length=g,p.length=g,{positions:c,topHeights:m,bottomHeights:p}}var c={},h=new e,d=new e,m=new Array(2),p=new Array(2),f={positions:void 0,height:void 0,granularity:void 0,ellipsoid:void 0};return c.computePositions=function(e,t,r,u,c,h){var d=l(e,t,r,u);if(t=d.positions,r=d.topHeights,u=d.bottomHeights,t.length<2)return void 0;if(t.length>=3){var v=i.fromPoints(t,e),g=v.projectPointsOntoPlane(t);o.computeWindingOrder2D(g)===s.CLOCKWISE&&(t.reverse(),r.reverse(),u.reverse())}var _,y,w=t.length,C=n.chordLength(c,e.maximumRadius),E=f;if(E.minDistance=C,E.ellipsoid=e,h){var S,b=0;for(S=0;w-1>S;S++)b+=a.numberOfPoints(t[S],t[S+1],C)+1;_=new Float64Array(3*b),y=new Float64Array(3*b);var T=m,x=p;E.positions=T,E.height=x;var P=0;for(S=0;w-1>S;S++){T[0]=t[S],T[1]=t[S+1],x[0]=r[S],x[1]=r[S+1];var A=a.generateArc(E);_.set(A,P),x[0]=u[S],x[1]=u[S+1],y.set(a.generateArc(E),P),P+=A.length}}else E.positions=t,E.height=r,_=new Float64Array(a.generateArc(E)),E.height=u,y=new Float64Array(a.generateArc(E));return{bottomPositions:y,topPositions:_}},c}),r("Core/WallGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType","./VertexFormat","./WallGeometryLibrary"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p){"use strict";var f=new t,v=new t,g=new t,_=new t,y=new t,w=new t,C=new t,E=new t,S=function(e){e=i(e,i.EMPTY_OBJECT);var r=e.positions,s=e.maximumHeights,u=e.minimumHeights;if(!n(r))throw new o("options.positions is required.");if(r.length<2)throw new o("options.positions length must be greater than or equal to 2.");if(n(s)&&s.length!==r.length)throw new o("options.positions and options.maximumHeights must have the same length.");if(n(u)&&u.length!==r.length)throw new o("options.positions and options.minimumHeights must have the same length.");var l=i(e.vertexFormat,m.DEFAULT),c=i(e.granularity,h.RADIANS_PER_DEGREE),d=i(e.ellipsoid,a.WGS84);this._positions=r,this._minimumHeights=u,this._maximumHeights=s,this._vertexFormat=m.clone(l),this._granularity=c,this._ellipsoid=a.clone(d),this._workerName="createWallGeometry";var p=1+r.length*t.packedLength+2;n(u)&&(p+=u.length),n(s)&&(p+=s.length),this.packedLength=p+a.packedLength+m.packedLength+1};S.pack=function(e,r,s){if(!n(e))throw new o("value is required");if(!n(r))throw new o("array is required");s=i(s,0);var u,l=e._positions,c=l.length;for(r[s++]=c,u=0;c>u;++u,s+=t.packedLength)t.pack(l[u],r,s);var h=e._minimumHeights;if(c=n(h)?h.length:0,r[s++]=c,n(h))for(u=0;c>u;++u)r[s++]=h[u];var d=e._maximumHeights;if(c=n(d)?d.length:0,r[s++]=c,n(d))for(u=0;c>u;++u)r[s++]=d[u];a.pack(e._ellipsoid,r,s),s+=a.packedLength,m.pack(e._vertexFormat,r,s),s+=m.packedLength,r[s]=e._granularity};var b=a.clone(a.UNIT_SPHERE),T=new m,x={positions:void 0,minimumHeights:void 0,maximumHeights:void 0,ellipsoid:b,vertexFormat:T,granularity:void 0};return S.unpack=function(e,r,s){if(!n(e))throw new o("array is required");r=i(r,0);var u,l=e[r++],c=new Array(l);for(u=0;l>u;++u,r+=t.packedLength)c[u]=t.unpack(e,r);l=e[r++];var h;if(l>0)for(h=new Array(l),u=0;l>u;++u)h[u]=e[r++];l=e[r++];var d;if(l>0)for(d=new Array(l),u=0;l>u;++u)d[u]=e[r++];var p=a.unpack(e,r,b);r+=a.packedLength;var f=m.unpack(e,r,T);r+=m.packedLength;var v=e[r];return n(s)?(s._positions=c,s._minimumHeights=h,s._maximumHeights=d,s._ellipsoid=a.clone(p,s._ellipsoid),s._vertexFormat=m.clone(f,s._vertexFormat),s._granularity=v,s):(x.positions=c,x.minimumHeights=h,x.maximumHeights=d,x.granularity=v,new S(x))},S.fromConstantHeights=function(e){e=i(e,i.EMPTY_OBJECT);var t=e.positions;if(!n(t))throw new o("options.positions is required.");var r,a,s=e.minimumHeight,u=e.maximumHeight,l=n(s),c=n(u);if(l||c){var h=t.length;r=l?new Array(h):void 0,a=c?new Array(h):void 0;for(var d=0;h>d;++d)l&&(r[d]=s),c&&(a[d]=u)}var m={positions:t,maximumHeights:a,minimumHeights:r,ellipsoid:e.ellipsoid,vertexFormat:e.vertexFormat};return new S(m)},S.createGeometry=function(i){var o=i._positions,a=i._minimumHeights,m=i._maximumHeights,S=i._vertexFormat,b=i._granularity,T=i._ellipsoid,x=p.computePositions(T,o,m,a,b,!0);if(!n(x))return void 0;var P=x.bottomPositions,A=x.topPositions,I=A.length,D=2*I,M=S.position?new Float64Array(D):void 0,R=S.normal?new Float32Array(D):void 0,O=S.tangent?new Float32Array(D):void 0,N=S.binormal?new Float32Array(D):void 0,L=S.st?new Float32Array(D/3*2):void 0,F=0,B=0,z=0,V=0,k=0,U=E,q=C,G=w,W=!0;I/=3;var H,j=0,Y=1/(I-o.length+1);for(H=0;I>H;++H){var X=3*H,Z=t.fromArray(A,X,f),K=t.fromArray(P,X,v);if(S.position&&(M[F++]=K.x,M[F++]=K.y,M[F++]=K.z,M[F++]=Z.x,M[F++]=Z.y,M[F++]=Z.z),S.st&&(L[k++]=j,L[k++]=0,L[k++]=j,L[k++]=1),S.normal||S.tangent||S.binormal){var Q,J=t.clone(t.ZERO,y),$=T.scaleToGeodeticSurface(t.fromArray(A,X,v),v);if(I>H+1&&(Q=T.scaleToGeodeticSurface(t.fromArray(A,X+3,g),g),J=t.fromArray(A,X+3,y)),W){var ee=t.subtract(J,Z,_),te=t.subtract($,Z,f);U=t.normalize(t.cross(te,ee,U),U),W=!1}t.equalsEpsilon(Q,$,h.EPSILON10)?W=!0:(j+=Y,S.tangent&&(q=t.normalize(t.subtract(Q,$,q),q)),S.binormal&&(G=t.normalize(t.cross(U,q,G),G))),S.normal&&(R[B++]=U.x,R[B++]=U.y,R[B++]=U.z,R[B++]=U.x,R[B++]=U.y,R[B++]=U.z),S.tangent&&(O[V++]=q.x,O[V++]=q.y,O[V++]=q.z,O[V++]=q.x,O[V++]=q.y,O[V++]=q.z),S.binormal&&(N[z++]=G.x,N[z++]=G.y,N[z++]=G.z,N[z++]=G.x,N[z++]=G.y,N[z++]=G.z)}}var re=new l;S.position&&(re.position=new u({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:M})),S.normal&&(re.normal=new u({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:R})),S.tangent&&(re.tangent=new u({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:O})),S.binormal&&(re.binormal=new u({componentDatatype:r.FLOAT,componentsPerAttribute:3,values:N})),S.st&&(re.st=new u({componentDatatype:r.FLOAT,componentsPerAttribute:2,values:L}));var ie=D/3;D-=6;var ne=c.createTypedArray(ie,D),oe=0;for(H=0;ie-2>H;H+=2){var ae=H,se=H+2,ue=t.fromArray(M,3*ae,f),le=t.fromArray(M,3*se,v);if(!t.equalsEpsilon(ue,le,h.EPSILON10)){var ce=H+1,he=H+3;ne[oe++]=ce,ne[oe++]=ae,ne[oe++]=he,ne[oe++]=he,ne[oe++]=ae,ne[oe++]=se}}return new s({attributes:re,indices:ne,primitiveType:d.TRIANGLES,boundingSphere:new e.fromVertices(M)})},S}),r("Core/WallOutlineGeometry",["./BoundingSphere","./Cartesian3","./ComponentDatatype","./defaultValue","./defined","./DeveloperError","./Ellipsoid","./Geometry","./GeometryAttribute","./GeometryAttributes","./IndexDatatype","./Math","./PrimitiveType","./WallGeometryLibrary"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m){"use strict";var p=new t,f=new t,v=function(e){e=i(e,i.EMPTY_OBJECT);var r=e.positions,s=e.maximumHeights,u=e.minimumHeights;if(!n(r))throw new o("options.positions is required.");if(r.length<2)throw new o("options.positions length must be greater than or equal to 2.");if(n(s)&&s.length!==r.length)throw new o("options.positions and options.maximumHeights must have the same length.");if(n(u)&&u.length!==r.length)throw new o("options.positions and options.minimumHeights must have the same length.");var l=i(e.granularity,h.RADIANS_PER_DEGREE),c=i(e.ellipsoid,a.WGS84);this._positions=r,this._minimumHeights=u,this._maximumHeights=s,this._granularity=l,this._ellipsoid=a.clone(c),this._workerName="createWallOutlineGeometry";var d=1+r.length*t.packedLength+2;n(u)&&(d+=u.length),n(s)&&(d+=s.length),this.packedLength=d+a.packedLength+1};v.pack=function(e,r,s){if(!n(e))throw new o("value is required");if(!n(r))throw new o("array is required");s=i(s,0);var u,l=e._positions,c=l.length;for(r[s++]=c,u=0;c>u;++u,s+=t.packedLength)t.pack(l[u],r,s);var h=e._minimumHeights;if(c=n(h)?h.length:0,r[s++]=c,n(h))for(u=0;c>u;++u)r[s++]=h[u];var d=e._maximumHeights;if(c=n(d)?d.length:0,r[s++]=c,n(d))for(u=0;c>u;++u)r[s++]=d[u];a.pack(e._ellipsoid,r,s),s+=a.packedLength,r[s]=e._granularity};var g=a.clone(a.UNIT_SPHERE),_={positions:void 0,minimumHeights:void 0,maximumHeights:void 0,ellipsoid:g,granularity:void 0};return v.unpack=function(e,r,s){if(!n(e))throw new o("array is required");r=i(r,0);var u,l=e[r++],c=new Array(l);for(u=0;l>u;++u,r+=t.packedLength)c[u]=t.unpack(e,r);l=e[r++];var h;if(l>0)for(h=new Array(l),u=0;l>u;++u)h[u]=e[r++];l=e[r++];var d;if(l>0)for(d=new Array(l),u=0;l>u;++u)d[u]=e[r++];var m=a.unpack(e,r,g);r+=a.packedLength;var p=e[r];return n(s)?(s._positions=c,s._minimumHeights=h,s._maximumHeights=d,s._ellipsoid=a.clone(m,s._ellipsoid),s._granularity=p,s):(_.positions=c,_.minimumHeights=h,_.maximumHeights=d,_.granularity=p,new v(_))},v.fromConstantHeights=function(e){e=i(e,i.EMPTY_OBJECT);var t=e.positions;if(!n(t))throw new o("options.positions is required.");var r,a,s=e.minimumHeight,u=e.maximumHeight,l=n(s),c=n(u);if(l||c){var h=t.length;r=l?new Array(h):void 0,a=c?new Array(h):void 0;for(var d=0;h>d;++d)l&&(r[d]=s),c&&(a[d]=u)}var m={positions:t,maximumHeights:a,minimumHeights:r,ellipsoid:e.ellipsoid};return new v(m)},v.createGeometry=function(i){var o=i._positions,a=i._minimumHeights,v=i._maximumHeights,g=i._granularity,_=i._ellipsoid,y=m.computePositions(_,o,v,a,g,!1);if(!n(y))return void 0;var w=y.bottomPositions,C=y.topPositions,E=C.length,S=2*E,b=new Float64Array(S),T=0;E/=3;var x;for(x=0;E>x;++x){var P=3*x,A=t.fromArray(C,P,p),I=t.fromArray(w,P,f);b[T++]=I.x,b[T++]=I.y,b[T++]=I.z,b[T++]=A.x,b[T++]=A.y,b[T++]=A.z}var D=new l({position:new u({componentDatatype:r.DOUBLE,componentsPerAttribute:3,values:b})}),M=S/3;S=2*M-4+M;var R=c.createTypedArray(M,S),O=0;for(x=0;M-2>x;x+=2){var N=x,L=x+2,F=t.fromArray(b,3*N,p),B=t.fromArray(b,3*L,f);if(!t.equalsEpsilon(F,B,h.EPSILON10)){var z=x+1,V=x+3;R[O++]=z,R[O++]=N,R[O++]=z,R[O++]=V,R[O++]=N,R[O++]=L}}return R[O++]=M-2,R[O++]=M-1,new s({attributes:D,indices:R,primitiveType:d.LINES,boundingSphere:new e.fromVertices(b)})},v}),r("Core/WebMercatorProjection",["./Cartesian3","./Cartographic","./defaultValue","./defined","./defineProperties","./DeveloperError","./Ellipsoid","./Math"],function(e,t,r,i,n,o,a,s){"use strict";var u=function(e){this._ellipsoid=r(e,a.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis};return n(u.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),u.mercatorAngleToGeodeticLatitude=function(e){return s.PI_OVER_TWO-2*Math.atan(Math.exp(-e))},u.geodeticLatitudeToMercatorAngle=function(e){e>u.MaximumLatitude?e=u.MaximumLatitude:e<-u.MaximumLatitude&&(e=-u.MaximumLatitude);var t=Math.sin(e);return.5*Math.log((1+t)/(1-t))},u.MaximumLatitude=u.mercatorAngleToGeodeticLatitude(Math.PI),u.prototype.project=function(t,r){var n=this._semimajorAxis,o=t.longitude*n,a=u.geodeticLatitudeToMercatorAngle(t.latitude)*n,s=t.height;return i(r)?(r.x=o,r.y=a,r.z=s,r):new e(o,a,s)},u.prototype.unproject=function(e,r){if(!i(e))throw new o("cartesian is required");var n=this._oneOverSemimajorAxis,a=e.x*n,s=u.mercatorAngleToGeodeticLatitude(e.y*n),l=e.z;return i(r)?(r.longitude=a,r.latitude=s,r.height=l,r):new t(a,s,l)},u}),r("Core/WebMercatorTilingScheme",["./Cartesian2","./defaultValue","./defined","./defineProperties","./Ellipsoid","./Rectangle","./WebMercatorProjection"],function(e,t,r,i,n,o,a){"use strict";var s=function(i){if(i=t(i,{}),this._ellipsoid=t(i.ellipsoid,n.WGS84),this._numberOfLevelZeroTilesX=t(i.numberOfLevelZeroTilesX,1),this._numberOfLevelZeroTilesY=t(i.numberOfLevelZeroTilesY,1),this._projection=new a(this._ellipsoid),r(i.rectangleSouthwestInMeters)&&r(i.rectangleNortheastInMeters))this._rectangleSouthwestInMeters=i.rectangleSouthwestInMeters,this._rectangleNortheastInMeters=i.rectangleNortheastInMeters;else{var s=this._ellipsoid.maximumRadius*Math.PI;this._rectangleSouthwestInMeters=new e(-s,-s),this._rectangleNortheastInMeters=new e(s,s)}var u=this._projection.unproject(this._rectangleSouthwestInMeters),l=this._projection.unproject(this._rectangleNortheastInMeters);this._rectangle=new o(u.longitude,u.latitude,l.longitude,l.latitude)};return i(s.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},rectangle:{get:function(){return this._rectangle}},projection:{get:function(){return this._projection}}}),s.prototype.getNumberOfXTilesAtLevel=function(e){return this._numberOfLevelZeroTilesX<<e},s.prototype.getNumberOfYTilesAtLevel=function(e){return this._numberOfLevelZeroTilesY<<e},s.prototype.rectangleToNativeRectangle=function(e,t){var i=this._projection,n=i.project(o.southwest(e)),a=i.project(o.northeast(e));return r(t)?(t.west=n.x,t.south=n.y,t.east=a.x,t.north=a.y,t):new o(n.x,n.y,a.x,a.y)},s.prototype.tileXYToNativeRectangle=function(e,t,i,n){var a=this.getNumberOfXTilesAtLevel(i),s=this.getNumberOfYTilesAtLevel(i),u=(this._rectangleNortheastInMeters.x-this._rectangleSouthwestInMeters.x)/a,l=this._rectangleSouthwestInMeters.x+e*u,c=this._rectangleSouthwestInMeters.x+(e+1)*u,h=(this._rectangleNortheastInMeters.y-this._rectangleSouthwestInMeters.y)/s,d=this._rectangleNortheastInMeters.y-t*h,m=this._rectangleNortheastInMeters.y-(t+1)*h;return r(n)?(n.west=l,n.south=m,n.east=c,n.north=d,n):new o(l,m,c,d)},s.prototype.tileXYToRectangle=function(t,r,i,n){var o=this.tileXYToNativeRectangle(t,r,i,n),a=this._projection,s=a.unproject(new e(o.west,o.south)),u=a.unproject(new e(o.east,o.north));return o.west=s.longitude,o.south=s.latitude,o.east=u.longitude,o.north=u.latitude,o},s.prototype.positionToTileXY=function(t,i,n){var a=this._rectangle;if(!o.contains(a,t))return void 0;var s=this.getNumberOfXTilesAtLevel(i),u=this.getNumberOfYTilesAtLevel(i),l=this._rectangleNortheastInMeters.x-this._rectangleSouthwestInMeters.x,c=l/s,h=this._rectangleNortheastInMeters.y-this._rectangleSouthwestInMeters.y,d=h/u,m=this._projection,p=m.project(t),f=p.x-this._rectangleSouthwestInMeters.x,v=this._rectangleNortheastInMeters.y-p.y,g=f/c|0;g>=s&&(g=s-1);var _=v/d|0;return _>=u&&(_=u-1),r(n)?(n.x=g,n.y=_,n):new e(g,_)},s}),r("Core/wrapFunction",["./DeveloperError"],function(e){"use strict";var t=function(t,r,i){if("function"!=typeof r)throw new e("oldFunction is required to be a function.");if("function"!=typeof i)throw new e("oldFunction is required to be a function.");return function(){i.apply(t,arguments),r.apply(t,arguments)}};return t}),r("DataSources/ConstantProperty",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event"],function(e,t,r,i,n){"use strict";var o=function(e){this._value=void 0,this._hasClone=!1,this._hasEquals=!1,this._definitionChanged=new n,this.setValue(e)};return r(o.prototype,{isConstant:{value:!0},definitionChanged:{get:function(){return this._definitionChanged}}}),o.prototype.getValue=function(e,t){return this._hasClone?this._value.clone(t):this._value},o.prototype.setValue=function(e){var r=this._value;if(r!==e){var i=t(e),n=i&&"function"==typeof e.clone,o=i&&"function"==typeof e.equals;this._hasClone=n,this._hasEquals=o;var a=!o||!e.equals(r);a&&(this._value=n?e.clone():e,this._definitionChanged.raiseEvent(this))}},o.prototype.equals=function(e){return this===e||e instanceof o&&(!this._hasEquals&&this._value===e._value||this._hasEquals&&this._value.equals(e._value))},o}),r("DataSources/createPropertyDescriptor",["../Core/defaultValue","../Core/defined","./ConstantProperty"],function(e,t,r){"use strict";function i(e,r,i,n,o){return{configurable:n,get:function(){return this[r]},set:function(n){var a=this[r],s=this[i];t(s)&&(s(),this[i]=void 0);var u=t(n);u&&!t(n.getValue)&&t(o)&&(n=o(n)),a!==n&&(this[r]=n,this._definitionChanged.raiseEvent(this,e,n,a)),t(n)&&t(n.definitionChanged)&&(this[i]=n.definitionChanged.addEventListener(function(){this._definitionChanged.raiseEvent(this,e,n,n)},this))}}}function n(e){return new r(e)}function o(t,r,o){return i(t,"_"+t.toString(),"_"+t.toString()+"Subscription",e(r,!1),e(o,n))}return o}),r("DataSources/BillboardGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createPropertyDescriptor"],function(e,t,r,i,n,o){"use strict";var a=function(t){this._image=void 0,this._imageSubscription=void 0,this._imageSubRegion=void 0,this._imageSubRegionSubscription=void 0,this._width=void 0,this._widthSubscription=void 0,this._height=void 0,this._heightSubscription=void 0,this._scale=void 0,this._scaleSubscription=void 0,this._rotation=void 0,this._rotationSubscription=void 0,this._alignedAxis=void 0,this._alignedAxisSubscription=void 0,this._horizontalOrigin=void 0,this._horizontalOriginSubscription=void 0,this._verticalOrigin=void 0,this._verticalOriginSubscription=void 0,this._color=void 0,this._colorSubscription=void 0,this._eyeOffset=void 0,this._eyeOffsetSubscription=void 0,this._pixelOffset=void 0,this._pixelOffsetSubscription=void 0,this._show=void 0,this._showSubscription=void 0,this._scaleByDistance=void 0,this._scaleByDistanceSubscription=void 0,this._translucencyByDistance=void 0,this._translucencyByDistanceSubscription=void 0,this._pixelOffsetScaleByDistance=void 0,this._pixelOffsetScaleByDistanceSubscription=void 0,this._sizeInMeters=void 0,this._sizeInMetersSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))};return r(a.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},image:o("image"),imageSubRegion:o("imageSubRegion"),scale:o("scale"),rotation:o("rotation"),alignedAxis:o("alignedAxis"),horizontalOrigin:o("horizontalOrigin"),verticalOrigin:o("verticalOrigin"),color:o("color"),eyeOffset:o("eyeOffset"),pixelOffset:o("pixelOffset"),show:o("show"),width:o("width"),height:o("height"),scaleByDistance:o("scaleByDistance"),translucencyByDistance:o("translucencyByDistance"),pixelOffsetScaleByDistance:o("pixelOffsetScaleByDistance"),sizeInMeters:o("sizeInMeters")}),a.prototype.clone=function(e){return t(e)?(e.color=this._color,e.eyeOffset=this._eyeOffset,e.horizontalOrigin=this._horizontalOrigin,e.image=this._image,e.imageSubRegion=this._imageSubRegion,e.pixelOffset=this._pixelOffset,e.scale=this._scale,e.rotation=this._rotation,e.alignedAxis=this._alignedAxis,e.show=this._show,e.verticalOrigin=this._verticalOrigin,e.width=this._width,e.height=this._height,e.scaleByDistance=this._scaleByDistance,e.translucencyByDistance=this._translucencyByDistance,e.pixelOffsetScaleByDistance=this._pixelOffsetScaleByDistance,e.sizeInMeters=this._sizeInMeters,e):new a(this)},a.prototype.merge=function(r){if(!t(r))throw new i("source is required.");this.color=e(this._color,r.color),this.eyeOffset=e(this._eyeOffset,r.eyeOffset),this.horizontalOrigin=e(this._horizontalOrigin,r.horizontalOrigin),this.image=e(this._image,r.image),this.imageSubRegion=e(this._imageSubRegion,r.imageSubRegion),this.pixelOffset=e(this._pixelOffset,r.pixelOffset),this.scale=e(this._scale,r.scale),this.rotation=e(this._rotation,r.rotation),this.alignedAxis=e(this._alignedAxis,r.alignedAxis),this.show=e(this._show,r.show),this.verticalOrigin=e(this._verticalOrigin,r.verticalOrigin),this.width=e(this._width,r.width),this.height=e(this._height,r.height),this.scaleByDistance=e(this._scaleByDistance,r.scaleByDistance),this.translucencyByDistance=e(this._translucencyByDistance,r.translucencyByDistance),this.pixelOffsetScaleByDistance=e(this._pixelOffsetScaleByDistance,r.pixelOffsetScaleByDistance),this.sizeInMeters=e(this._sizeInMeters,r.sizeInMeters)},a}),r("Renderer/BufferUsage",["../Core/freezeObject","./WebGLConstants"],function(e,t){"use strict";var r={STREAM_DRAW:t.STREAM_DRAW,STATIC_DRAW:t.STATIC_DRAW,DYNAMIC_DRAW:t.DYNAMIC_DRAW,validate:function(e){return e===r.STREAM_DRAW||e===r.STATIC_DRAW||e===r.DYNAMIC_DRAW}};return e(r)}),r("Renderer/Buffer",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/IndexDatatype","./BufferUsage","./WebGLConstants"],function(e,t,r,i,n,o,a,s){"use strict";var u=function(r){if(r=e(r,e.EMPTY_OBJECT),!t(r.context))throw new n("options.context is required.");if(!t(r.typedArray)&&!t(r.sizeInBytes))throw new n("Either options.sizeInBytes or options.typedArray is required.");if(t(r.typedArray)&&t(r.sizeInBytes))throw new n("Cannot pass in both options.sizeInBytes and options.typedArray.");if(t(r.typedArray)&&("object"!=typeof r.typedArray||"number"!=typeof r.typedArray.byteLength))throw new n("options.typedArray must be a typed array");if(!a.validate(r.usage))throw new n("usage is invalid.");var i=r.context._gl,o=r.bufferTarget,s=r.typedArray,u=r.sizeInBytes,l=r.usage,c=t(s);if(c&&(u=s.byteLength),0>=u)throw new n("Buffer size must be greater than zero.");var h=i.createBuffer();i.bindBuffer(o,h),i.bufferData(o,c?s:u,l),i.bindBuffer(o,null),this._gl=i,this._bufferTarget=o,this._sizeInBytes=u,this._usage=l,this._buffer=h,this.vertexArrayDestroyable=!0};return u.createVertexBuffer=function(e){if(!t(e.context))throw new n("options.context is required.");return new u({context:e.context,bufferTarget:s.ARRAY_BUFFER,typedArray:e.typedArray,sizeInBytes:e.sizeInBytes,usage:e.usage})},u.createIndexBuffer=function(e){if(!t(e.context))throw new n("options.context is required.");if(!o.validate(e.indexDatatype))throw new n("Invalid indexDatatype.");if(e.indexDatatype===o.UNSIGNED_INT&&!e.context.elementIndexUint)throw new n("IndexDatatype.UNSIGNED_INT requires OES_element_index_uint, which is not supported on this system.  Check context.elementIndexUint.");var i=e.context,a=e.indexDatatype,l=o.getSizeInBytes(a),c=new u({context:i,bufferTarget:s.ELEMENT_ARRAY_BUFFER,typedArray:e.typedArray,sizeInBytes:e.sizeInBytes,usage:e.usage}),h=c.sizeInBytes/l;return r(c,{indexDatatype:{get:function(){return a}},bytesPerIndex:{get:function(){return l}},numberOfIndices:{get:function(){return h}}}),c},r(u.prototype,{sizeInBytes:{get:function(){return this._sizeInBytes}},usage:{get:function(){return this._usage}}}),u.prototype._getBuffer=function(){return this._buffer},u.prototype.copyFromArrayView=function(t,r){if(r=e(r,0),!t)throw new n("arrayView is required.");if(r+t.byteLength>this._sizeInBytes)throw new n("This buffer is not large enough.");var i=this._gl,o=this._bufferTarget;i.bindBuffer(o,this._buffer),i.bufferSubData(o,r,t),i.bindBuffer(o,null)},u.prototype.isDestroyed=function(){return!1},u.prototype.destroy=function(){return this._gl.deleteBuffer(this._buffer),i(this)},u}),r("Renderer/DrawCommand",["../Core/defaultValue","../Core/PrimitiveType"],function(e,t){"use strict";var r=function(r){r=e(r,e.EMPTY_OBJECT),this.boundingVolume=r.boundingVolume,this.orientedBoundingBox=r.orientedBoundingBox,this.cull=e(r.cull,!0),this.modelMatrix=r.modelMatrix,this.primitiveType=e(r.primitiveType,t.TRIANGLES),this.vertexArray=r.vertexArray,this.count=r.count,this.offset=e(r.offset,0),this.instanceCount=e(r.instanceCount,0),this.shaderProgram=r.shaderProgram,this.uniformMap=r.uniformMap,this.renderState=r.renderState,this.framebuffer=r.framebuffer,this.pass=r.pass,this.executeInClosestFrustum=e(r.executeInClosestFrustum,!1),this.owner=r.owner,this.debugShowBoundingVolume=e(r.debugShowBoundingVolume,!1),this.debugOverlappingFrustums=0,this.oit=void 0};return r.prototype.execute=function(e,t,r,i){e.draw(this,t,r,i)},r}),r("Renderer/ContextLimits",["../Core/defineProperties"],function(e){"use strict";var t={_maximumCombinedTextureImageUnits:0,_maximumCubeMapSize:0,_maximumFragmentUniformVectors:0,_maximumTextureImageUnits:0,_maximumRenderbufferSize:0,_maximumTextureSize:0,_maximumVaryingVectors:0,_maximumVertexAttributes:0,_maximumVertexTextureImageUnits:0,_maximumVertexUniformVectors:0,_minimumAliasedLineWidth:0,_maximumAliasedLineWidth:0,_minimumAliasedPointSize:0,_maximumAliasedPointSize:0,_maximumViewportWidth:0,_maximumViewportHeight:0,_maximumTextureFilterAnisotropy:0,_maximumDrawBuffers:0,_maximumColorAttachments:0,_highpFloatSupported:!1,_highpIntSupported:!1};return e(t,{maximumCombinedTextureImageUnits:{get:function(){return t._maximumCombinedTextureImageUnits}},maximumCubeMapSize:{get:function(){return t._maximumCubeMapSize}},maximumFragmentUniformVectors:{get:function(){return t._maximumFragmentUniformVectors}},maximumTextureImageUnits:{get:function(){return t._maximumTextureImageUnits}},maximumRenderbufferSize:{get:function(){return t._maximumRenderbufferSize}},maximumTextureSize:{get:function(){return t._maximumTextureSize}},maximumVaryingVectors:{get:function(){return t._maximumVaryingVectors}},maximumVertexAttributes:{get:function(){return t._maximumVertexAttributes}},maximumVertexTextureImageUnits:{get:function(){return t._maximumVertexTextureImageUnits}},maximumVertexUniformVectors:{get:function(){return t._maximumVertexUniformVectors}},minimumAliasedLineWidth:{get:function(){return t._minimumAliasedLineWidth}},maximumAliasedLineWidth:{get:function(){return t._maximumAliasedLineWidth}},minimumAliasedPointSize:{get:function(){
return t._minimumAliasedPointSize}},maximumAliasedPointSize:{get:function(){return t._maximumAliasedPointSize}},maximumViewportWidth:{get:function(){return t._maximumViewportWidth}},maximumViewportHeight:{get:function(){return t._maximumViewportHeight}},maximumTextureFilterAnisotropy:{get:function(){return t._maximumTextureFilterAnisotropy}},maximumDrawBuffers:{get:function(){return t._maximumDrawBuffers}},maximumColorAttachments:{get:function(){return t._maximumColorAttachments}},highpFloatSupported:{get:function(){return t._highpFloatSupported}},highpIntSupported:{get:function(){return t._highpIntSupported}}}),t}),r("Renderer/RenderState",["../Core/BoundingRectangle","../Core/Color","../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/RuntimeError","../Core/WindingOrder","./ContextLimits","./WebGLConstants"],function(e,t,r,i,n,o,a,s,u){"use strict";function l(e){return e===u.FUNC_ADD||e===u.FUNC_SUBTRACT||e===u.FUNC_REVERSE_SUBTRACT}function c(e){return e===u.ZERO||e===u.ONE||e===u.SRC_COLOR||e===u.ONE_MINUS_SRC_COLOR||e===u.DST_COLOR||e===u.ONE_MINUS_DST_COLOR||e===u.SRC_ALPHA||e===u.ONE_MINUS_SRC_ALPHA||e===u.DST_ALPHA||e===u.ONE_MINUS_DST_ALPHA||e===u.CONSTANT_COLOR||e===u.ONE_MINUS_CONSTANT_COLOR||e===u.CONSTANT_ALPHA||e===u.ONE_MINUS_CONSTANT_ALPHA||e===u.SRC_ALPHA_SATURATE}function h(e){return e===u.FRONT||e===u.BACK||e===u.FRONT_AND_BACK}function d(e){return e===u.NEVER||e===u.LESS||e===u.EQUAL||e===u.LEQUAL||e===u.GREATER||e===u.NOTEQUAL||e===u.GEQUAL||e===u.ALWAYS}function m(e){return e===u.NEVER||e===u.LESS||e===u.EQUAL||e===u.LEQUAL||e===u.GREATER||e===u.NOTEQUAL||e===u.GEQUAL||e===u.ALWAYS}function p(e){return e===u.ZERO||e===u.KEEP||e===u.REPLACE||e===u.INCR||e===u.DECR||e===u.INVERT||e===u.INCR_WRAP||e===u.DECR_WRAP}function f(e,t,r){r?e.enable(t):e.disable(t)}function v(e,t){e.frontFace(t.frontFace)}function g(e,t){var r=t.cull,i=r.enabled;f(e,e.CULL_FACE,i),i&&e.cullFace(r.face)}function _(e,t){e.lineWidth(t.lineWidth)}function y(e,t){var r=t.polygonOffset,i=r.enabled;f(e,e.POLYGON_OFFSET_FILL,i),i&&e.polygonOffset(r.factor,r.units)}function w(e,t,r){var n=t.scissorTest,o=i(r.scissorTest)?r.scissorTest.enabled:n.enabled;if(f(e,e.SCISSOR_TEST,o),o){var a=i(r.scissorTest)?r.scissorTest.rectangle:n.rectangle;e.scissor(a.x,a.y,a.width,a.height)}}function C(e,t){var r=t.depthRange;e.depthRange(r.near,r.far)}function E(e,t){var r=t.depthTest,i=r.enabled;f(e,e.DEPTH_TEST,i),i&&e.depthFunc(r.func)}function S(e,t){var r=t.colorMask;e.colorMask(r.red,r.green,r.blue,r.alpha)}function b(e,t){e.depthMask(t.depthMask)}function T(e,t){e.stencilMask(t.stencilMask)}function x(e,t,r){var n=t.blending,o=i(r.blendingEnabled)?r.blendingEnabled:n.enabled;f(e,e.BLEND,o),o&&(O(e,n.color),e.blendEquationSeparate(n.equationRgb,n.equationAlpha),e.blendFuncSeparate(n.functionSourceRgb,n.functionDestinationRgb,n.functionSourceAlpha,n.functionDestinationAlpha))}function P(e,t){var r=t.stencilTest,i=r.enabled;if(f(e,e.STENCIL_TEST,i),i){var n=r.frontFunction,o=r.backFunction,a=r.reference,s=r.mask;e.stencilFunc(r.frontFunction,r.reference,r.mask),e.stencilFuncSeparate(e.BACK,o,a,s),e.stencilFuncSeparate(e.FRONT,n,a,s);var u=r.frontOperation,l=u.fail,c=u.zFail,h=u.zPass;e.stencilOpSeparate(e.FRONT,l,c,h);var d=r.backOperation,m=d.fail,p=d.zFail,v=d.zPass;e.stencilOpSeparate(e.BACK,m,p,v)}}function A(e,t,r){var n=t.viewport;i(n)||(n=L,n.width=r.context.drawingBufferWidth,n.height=r.context.drawingBufferHeight),r.context.uniformState.viewport=n,e.viewport(n.x,n.y,n.width,n.height)}function I(e,t){var r=[];return e.frontFace!==t.frontFace&&r.push(v),(e.cull.enabled!==t.cull.enabled||e.cull.face!==t.cull.face)&&r.push(g),e.lineWidth!==t.lineWidth&&r.push(_),(e.polygonOffset.enabled!==t.polygonOffset.enabled||e.polygonOffset.factor!==t.polygonOffset.factor||e.polygonOffset.units!==t.polygonOffset.units)&&r.push(y),(e.depthRange.near!==t.depthRange.near||e.depthRange.far!==t.depthRange.far)&&r.push(C),(e.depthTest.enabled!==t.depthTest.enabled||e.depthTest.func!==t.depthTest.func)&&r.push(E),(e.colorMask.red!==t.colorMask.red||e.colorMask.green!==t.colorMask.green||e.colorMask.blue!==t.colorMask.blue||e.colorMask.alpha!==t.colorMask.alpha)&&r.push(S),e.depthMask!==t.depthMask&&r.push(b),e.stencilMask!==t.stencilMask&&r.push(T),(e.stencilTest.enabled!==t.stencilTest.enabled||e.stencilTest.frontFunction!==t.stencilTest.frontFunction||e.stencilTest.backFunction!==t.stencilTest.backFunction||e.stencilTest.reference!==t.stencilTest.reference||e.stencilTest.mask!==t.stencilTest.mask||e.stencilTest.frontOperation.fail!==t.stencilTest.frontOperation.fail||e.stencilTest.frontOperation.zFail!==t.stencilTest.frontOperation.zFail||e.stencilTest.backOperation.fail!==t.stencilTest.backOperation.fail||e.stencilTest.backOperation.zFail!==t.stencilTest.backOperation.zFail||e.stencilTest.backOperation.zPass!==t.stencilTest.backOperation.zPass)&&r.push(P),(e.sampleCoverage.enabled!==t.sampleCoverage.enabled||e.sampleCoverage.value!==t.sampleCoverage.value||e.sampleCoverage.invert!==t.sampleCoverage.invert)&&r.push(N),r}var D=function(o){var f=r(o,{}),v=r(f.cull,{}),g=r(f.polygonOffset,{}),_=r(f.scissorTest,{}),y=r(_.rectangle,{}),w=r(f.depthRange,{}),C=r(f.depthTest,{}),E=r(f.colorMask,{}),S=r(f.blending,{}),b=r(S.color,{}),T=r(f.stencilTest,{}),x=r(T.frontOperation,{}),P=r(T.backOperation,{}),A=r(f.sampleCoverage,{}),I=f.viewport;if(this.frontFace=r(f.frontFace,a.COUNTER_CLOCKWISE),this.cull={enabled:r(v.enabled,!1),face:r(v.face,u.BACK)},this.lineWidth=r(f.lineWidth,1),this.polygonOffset={enabled:r(g.enabled,!1),factor:r(g.factor,0),units:r(g.units,0)},this.scissorTest={enabled:r(_.enabled,!1),rectangle:e.clone(y)},this.depthRange={near:r(w.near,0),far:r(w.far,1)},this.depthTest={enabled:r(C.enabled,!1),func:r(C.func,u.LESS)},this.colorMask={red:r(E.red,!0),green:r(E.green,!0),blue:r(E.blue,!0),alpha:r(E.alpha,!0)},this.depthMask=r(f.depthMask,!0),this.stencilMask=r(f.stencilMask,-1),this.blending={enabled:r(S.enabled,!1),color:new t(r(b.red,0),r(b.green,0),r(b.blue,0),r(b.alpha,0)),equationRgb:r(S.equationRgb,u.FUNC_ADD),equationAlpha:r(S.equationAlpha,u.FUNC_ADD),functionSourceRgb:r(S.functionSourceRgb,u.ONE),functionSourceAlpha:r(S.functionSourceAlpha,u.ONE),functionDestinationRgb:r(S.functionDestinationRgb,u.ZERO),functionDestinationAlpha:r(S.functionDestinationAlpha,u.ZERO)},this.stencilTest={enabled:r(T.enabled,!1),frontFunction:r(T.frontFunction,u.ALWAYS),backFunction:r(T.backFunction,u.ALWAYS),reference:r(T.reference,0),mask:r(T.mask,-1),frontOperation:{fail:r(x.fail,u.KEEP),zFail:r(x.zFail,u.KEEP),zPass:r(x.zPass,u.KEEP)},backOperation:{fail:r(P.fail,u.KEEP),zFail:r(P.zFail,u.KEEP),zPass:r(P.zPass,u.KEEP)}},this.sampleCoverage={enabled:r(A.enabled,!1),value:r(A.value,1),invert:r(A.invert,!1)},this.viewport=i(I)?new e(I.x,I.y,I.width,I.height):void 0,this.lineWidth<s.minimumAliasedLineWidth||this.lineWidth>s.maximumAliasedLineWidth)throw new n("renderState.lineWidth is out of range.  Check minimumAliasedLineWidth and maximumAliasedLineWidth.");if(!a.validate(this.frontFace))throw new n("Invalid renderState.frontFace.");if(!h(this.cull.face))throw new n("Invalid renderState.cull.face.");if(this.scissorTest.rectangle.width<0||this.scissorTest.rectangle.height<0)throw new n("renderState.scissorTest.rectangle.width and renderState.scissorTest.rectangle.height must be greater than or equal to zero.");if(this.depthRange.near>this.depthRange.far)throw new n("renderState.depthRange.near can not be greater than renderState.depthRange.far.");if(this.depthRange.near<0)throw new n("renderState.depthRange.near must be greater than or equal to zero.");if(this.depthRange.far>1)throw new n("renderState.depthRange.far must be less than or equal to one.");if(!d(this.depthTest.func))throw new n("Invalid renderState.depthTest.func.");if(this.blending.color.red<0||this.blending.color.red>1||this.blending.color.green<0||this.blending.color.green>1||this.blending.color.blue<0||this.blending.color.blue>1||this.blending.color.alpha<0||this.blending.color.alpha>1)throw new n("renderState.blending.color components must be greater than or equal to zero and less than or equal to one.");if(!l(this.blending.equationRgb))throw new n("Invalid renderState.blending.equationRgb.");if(!l(this.blending.equationAlpha))throw new n("Invalid renderState.blending.equationAlpha.");if(!c(this.blending.functionSourceRgb))throw new n("Invalid renderState.blending.functionSourceRgb.");if(!c(this.blending.functionSourceAlpha))throw new n("Invalid renderState.blending.functionSourceAlpha.");if(!c(this.blending.functionDestinationRgb))throw new n("Invalid renderState.blending.functionDestinationRgb.");if(!c(this.blending.functionDestinationAlpha))throw new n("Invalid renderState.blending.functionDestinationAlpha.");if(!m(this.stencilTest.frontFunction))throw new n("Invalid renderState.stencilTest.frontFunction.");if(!m(this.stencilTest.backFunction))throw new n("Invalid renderState.stencilTest.backFunction.");if(!p(this.stencilTest.frontOperation.fail))throw new n("Invalid renderState.stencilTest.frontOperation.fail.");if(!p(this.stencilTest.frontOperation.zFail))throw new n("Invalid renderState.stencilTest.frontOperation.zFail.");if(!p(this.stencilTest.frontOperation.zPass))throw new n("Invalid renderState.stencilTest.frontOperation.zPass.");if(!p(this.stencilTest.backOperation.fail))throw new n("Invalid renderState.stencilTest.backOperation.fail.");if(!p(this.stencilTest.backOperation.zFail))throw new n("Invalid renderState.stencilTest.backOperation.zFail.");if(!p(this.stencilTest.backOperation.zPass))throw new n("Invalid renderState.stencilTest.backOperation.zPass.");if(i(this.viewport)){if(this.viewport.width<0)throw new n("renderState.viewport.width must be greater than or equal to zero.");if(this.viewport.height<0)throw new n("renderState.viewport.height must be greater than or equal to zero.");if(this.viewport.width>s.maximumViewportWidth)throw new n("renderState.viewport.width must be less than or equal to the maximum viewport width ("+s.maximumViewportWidth.toString()+").  Check maximumViewportWidth.");if(this.viewport.height>s.maximumViewportHeight)throw new n("renderState.viewport.height must be less than or equal to the maximum viewport height ("+s.maximumViewportHeight.toString()+").  Check maximumViewportHeight.")}this.id=0,this._applyFunctions=[]},M=0,R={};D.fromCache=function(e){var t=JSON.stringify(e),r=R[t];if(i(r))return++r.referenceCount,r.state;var n=new D(e),o=JSON.stringify(n);return r=R[o],i(r)||(n.id=M++,r={referenceCount:0,state:n},R[o]=r),++r.referenceCount,R[t]={referenceCount:1,state:r.state},r.state},D.removeFromCache=function(e){var t=new D(e),r=JSON.stringify(t),n=R[r],o=JSON.stringify(e),a=R[o];i(a)&&(--a.referenceCount,0===a.referenceCount&&(delete R[o],i(n)&&--n.referenceCount)),i(n)&&0===n.referenceCount&&delete R[r]},D.getCache=function(){return R},D.clearCache=function(){R={}};var O=function(e,t){e.blendColor(t.red,t.green,t.blue,t.alpha)},N=function(e,t){var r=t.sampleCoverage,i=r.enabled;f(e,e.SAMPLE_COVERAGE,i),i&&e.sampleCoverage(r.value,r.invert)},L=new e;return D.apply=function(e,t,r){v(e,t),g(e,t),_(e,t),y(e,t),C(e,t),E(e,t),S(e,t),b(e,t),T(e,t),P(e,t),N(e,t),w(e,t,r),x(e,t,r),A(e,t,r)},D.partialApply=function(e,t,r,n,o,a){if(t!==r){var s=r._applyFunctions[t.id];i(s)||(s=I(t,r),r._applyFunctions[t.id]=s);for(var u=s.length,l=0;u>l;++l)s[l](e,r)}var c=i(n.scissorTest)?n.scissorTest:t.scissorTest,h=i(o.scissorTest)?o.scissorTest:r.scissorTest;(c!==h||a)&&w(e,r,o);var d=i(n.blendingEnabled)?n.blendingEnabled:t.blending.enabled,m=i(o.blendingEnabled)?o.blendingEnabled:r.blending.enabled;(d!==m||m&&t.blending!==r.blending)&&x(e,r,o),(t!==r||n.context!==o.context)&&A(e,r,o)},D.getState=function(r){if(!i(r))throw new n("renderState is required.");return{frontFace:r.frontFace,cull:{enabled:r.cull.enabled,face:r.cull.face},lineWidth:r.lineWidth,polygonOffset:{enabled:r.polygonOffset.enabled,factor:r.polygonOffset.factor,units:r.polygonOffset.units},scissorTest:{enabled:r.scissorTest.enabled,rectangle:e.clone(r.scissorTest.rectangle)},depthRange:{near:r.depthRange.near,far:r.depthRange.far},depthTest:{enabled:r.depthTest.enabled,func:r.depthTest.func},colorMask:{red:r.colorMask.red,green:r.colorMask.green,blue:r.colorMask.blue,alpha:r.colorMask.alpha},depthMask:r.depthMask,stencilMask:r.stencilMask,blending:{enabled:r.blending.enabled,color:t.clone(r.blending.color),equationRgb:r.blending.equationRgb,equationAlpha:r.blending.equationAlpha,functionSourceRgb:r.blending.functionSourceRgb,functionSourceAlpha:r.blending.functionSourceAlpha,functionDestinationRgb:r.blending.functionDestinationRgb,functionDestinationAlpha:r.blending.functionDestinationAlpha},stencilTest:{enabled:r.stencilTest.enabled,frontFunction:r.stencilTest.frontFunction,backFunction:r.stencilTest.backFunction,reference:r.stencilTest.reference,mask:r.stencilTest.mask,frontOperation:{fail:r.stencilTest.frontOperation.fail,zFail:r.stencilTest.frontOperation.zFail,zPass:r.stencilTest.frontOperation.zPass},backOperation:{fail:r.stencilTest.backOperation.fail,zFail:r.stencilTest.backOperation.zFail,zPass:r.stencilTest.backOperation.zPass}},sampleCoverage:{enabled:r.sampleCoverage.enabled,value:r.sampleCoverage.value,invert:r.sampleCoverage.invert},viewport:i(r.viewport)?e.clone(r.viewport):void 0}},D}),r("Renderer/AutomaticUniforms",["../Core/Cartesian3","../Core/Matrix4","./WebGLConstants"],function(e,t,r){"use strict";var i=new e,n=function(e){this._size=e.size,this._datatype=e.datatype,this.getValue=e.getValue};if("undefined"==typeof WebGLRenderingContext)return{};var o={};o[r.FLOAT]="float",o[r.FLOAT_VEC2]="vec2",o[r.FLOAT_VEC3]="vec3",o[r.FLOAT_VEC4]="vec4",o[r.INT]="int",o[r.INT_VEC2]="ivec2",o[r.INT_VEC3]="ivec3",o[r.INT_VEC4]="ivec4",o[r.BOOL]="bool",o[r.BOOL_VEC2]="bvec2",o[r.BOOL_VEC3]="bvec3",o[r.BOOL_VEC4]="bvec4",o[r.FLOAT_MAT2]="mat2",o[r.FLOAT_MAT3]="mat3",o[r.FLOAT_MAT4]="mat4",o[r.SAMPLER_2D]="sampler2D",o[r.SAMPLER_CUBE]="samplerCube",n.prototype.getDeclaration=function(e){var t="uniform "+o[this._datatype]+" "+e,r=this._size;return t+=1===r?";":"["+r.toString()+"];"};var a={czm_viewport:new n({size:1,datatype:r.FLOAT_VEC4,getValue:function(e){return e.viewportCartesian4}}),czm_viewportOrthographic:new n({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.viewportOrthographic}}),czm_viewportTransformation:new n({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.viewportTransformation}}),czm_globeDepthTexture:new n({size:1,datatype:r.SAMPLER_2D,getValue:function(e){return e.globeDepthTexture}}),czm_model:new n({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.model}}),czm_inverseModel:new n({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.inverseModel}}),czm_view:new n({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.view}}),czm_view3D:new n({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.view3D}}),czm_viewRotation:new n({size:1,datatype:r.FLOAT_MAT3,getValue:function(e){return e.viewRotation}}),czm_viewRotation3D:new n({size:1,datatype:r.FLOAT_MAT3,getValue:function(e){return e.viewRotation3D}}),czm_inverseView:new n({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.inverseView}}),czm_inverseView3D:new n({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.inverseView3D}}),czm_inverseViewRotation:new n({size:1,datatype:r.FLOAT_MAT3,getValue:function(e){return e.inverseViewRotation}}),czm_inverseViewRotation3D:new n({size:1,datatype:r.FLOAT_MAT3,getValue:function(e){return e.inverseViewRotation3D}}),czm_projection:new n({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.projection}}),czm_inverseProjection:new n({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.inverseProjection}}),czm_inverseProjectionOIT:new n({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.inverseProjectionOIT}}),czm_infiniteProjection:new n({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.infiniteProjection}}),czm_modelView:new n({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.modelView}}),czm_modelView3D:new n({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.modelView3D}}),czm_modelViewRelativeToEye:new n({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.modelViewRelativeToEye}}),czm_inverseModelView:new n({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.inverseModelView}}),czm_inverseModelView3D:new n({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.inverseModelView3D}}),czm_viewProjection:new n({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.viewProjection}}),czm_inverseViewProjection:new n({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.inverseViewProjection}}),czm_modelViewProjection:new n({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.modelViewProjection}}),czm_inverseModelViewProjection:new n({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.inverseModelViewProjection}}),czm_modelViewProjectionRelativeToEye:new n({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.modelViewProjectionRelativeToEye}}),czm_modelViewInfiniteProjection:new n({size:1,datatype:r.FLOAT_MAT4,getValue:function(e){return e.modelViewInfiniteProjection}}),czm_normal:new n({size:1,datatype:r.FLOAT_MAT3,getValue:function(e){return e.normal}}),czm_normal3D:new n({size:1,datatype:r.FLOAT_MAT3,getValue:function(e){return e.normal3D}}),czm_inverseNormal:new n({size:1,datatype:r.FLOAT_MAT3,getValue:function(e){return e.inverseNormal}}),czm_inverseNormal3D:new n({size:1,datatype:r.FLOAT_MAT3,getValue:function(e){return e.inverseNormal3D}}),czm_eyeHeight2D:new n({size:1,datatype:r.FLOAT_VEC2,getValue:function(e){return e.eyeHeight2D}}),czm_entireFrustum:new n({size:1,datatype:r.FLOAT_VEC2,getValue:function(e){return e.entireFrustum}}),czm_currentFrustum:new n({size:1,datatype:r.FLOAT_VEC2,getValue:function(e){return e.currentFrustum}}),czm_frustumPlanes:new n({size:1,datatype:r.FLOAT_VEC4,getValue:function(e){return e.frustumPlanes}}),czm_sunPositionWC:new n({size:1,datatype:r.FLOAT_VEC3,getValue:function(e){return e.sunPositionWC}}),czm_sunPositionColumbusView:new n({size:1,datatype:r.FLOAT_VEC3,getValue:function(e){return e.sunPositionColumbusView}}),czm_sunDirectionEC:new n({size:1,datatype:r.FLOAT_VEC3,getValue:function(e){return e.sunDirectionEC}}),czm_sunDirectionWC:new n({size:1,datatype:r.FLOAT_VEC3,getValue:function(e){return e.sunDirectionWC}}),czm_moonDirectionEC:new n({size:1,datatype:r.FLOAT_VEC3,getValue:function(e){return e.moonDirectionEC}}),czm_encodedCameraPositionMCHigh:new n({size:1,datatype:r.FLOAT_VEC3,getValue:function(e){return e.encodedCameraPositionMCHigh}}),czm_encodedCameraPositionMCLow:new n({size:1,datatype:r.FLOAT_VEC3,getValue:function(e){return e.encodedCameraPositionMCLow}}),czm_viewerPositionWC:new n({size:1,datatype:r.FLOAT_VEC3,getValue:function(e){return t.getTranslation(e.inverseView,i)}}),czm_frameNumber:new n({size:1,datatype:r.FLOAT,getValue:function(e){return e.frameState.frameNumber}}),czm_morphTime:new n({size:1,datatype:r.FLOAT,getValue:function(e){return e.frameState.morphTime}}),czm_sceneMode:new n({size:1,datatype:r.FLOAT,getValue:function(e){return e.frameState.mode}}),czm_temeToPseudoFixed:new n({size:1,datatype:r.FLOAT_MAT3,getValue:function(e){return e.temeToPseudoFixedMatrix}}),czm_resolutionScale:new n({size:1,datatype:r.FLOAT,getValue:function(e){return e.resolutionScale}})};return a}),r("Renderer/createUniform",["../Core/Cartesian2","../Core/Cartesian3","../Core/Cartesian4","../Core/Color","../Core/defined","../Core/DeveloperError","../Core/Matrix2","../Core/Matrix3","../Core/Matrix4","../Core/RuntimeError"],function(e,t,r,i,n,o,a,s,u,l){"use strict";function c(e,t,r,i){this.name=r,this.value=void 0,this._value=0,this._gl=e,this._location=i}function h(t,r,i,n){this.name=i,this.value=void 0,this._value=new e,this._gl=t,this._location=n}function d(e,t,r,i){this.name=r,this.value=void 0,this._value=void 0,this._gl=e,this._location=i}function m(e,t,r,i){this.name=r,this.value=void 0,this._value=void 0,this._gl=e,this._location=i}function p(e,t,r,i){this.name=r,this.value=void 0,this._gl=e,this._location=i,this.textureUnitIndex=void 0}function f(e,t,r,i){this.name=r,this.value=void 0,this._value=0,this._gl=e,this._location=i}function v(t,r,i,n){this.name=i,this.value=void 0,this._value=new e,this._gl=t,this._location=n}function g(e,r,i,n){this.name=i,this.value=void 0,this._value=new t,this._gl=e,this._location=n}function _(e,t,i,n){this.name=i,this.value=void 0,this._value=new r,this._gl=e,this._location=n}function y(e,t,r,i){this.name=r,this.value=void 0,this._value=new Float32Array(4),this._gl=e,this._location=i}function w(e,t,r,i){this.name=r,this.value=void 0,this._value=new Float32Array(9),this._gl=e,this._location=i}function C(e,t,r,i){this.name=r,this.value=void 0,this._value=new Float32Array(16),this._gl=e,this._location=i}var E=function(e,t,r,i){switch(t.type){case e.FLOAT:return new c(e,t,r,i);case e.FLOAT_VEC2:return new h(e,t,r,i);case e.FLOAT_VEC3:return new d(e,t,r,i);case e.FLOAT_VEC4:return new m(e,t,r,i);case e.SAMPLER_2D:case e.SAMPLER_CUBE:return new p(e,t,r,i);case e.INT:case e.BOOL:return new f(e,t,r,i);case e.INT_VEC2:case e.BOOL_VEC2:return new v(e,t,r,i);case e.INT_VEC3:case e.BOOL_VEC3:return new g(e,t,r,i);case e.INT_VEC4:case e.BOOL_VEC4:return new _(e,t,r,i);case e.FLOAT_MAT2:return new y(e,t,r,i);case e.FLOAT_MAT3:return new w(e,t,r,i);case e.FLOAT_MAT4:return new C(e,t,r,i);default:throw new l("Unrecognized uniform type: "+t.type+' for uniform "'+r+'".')}};return c.prototype.set=function(){this.value!==this._value&&(this._value=this.value,this._gl.uniform1f(this._location,this.value))},h.prototype.set=function(){var t=this.value;e.equals(t,this._value)||(e.clone(t,this._value),this._gl.uniform2f(this._location,t.x,t.y))},d.prototype.set=function(){var e=this.value;if(n(e.red))i.equals(e,this._value)||(this._value=i.clone(e,this._value),this._gl.uniform3f(this._location,e.red,e.green,e.blue));else{if(!n(e.x))throw new o('Invalid vec3 value for uniform "'+this._activethis.name+'".');t.equals(e,this._value)||(this._value=t.clone(e,this._value),this._gl.uniform3f(this._location,e.x,e.y,e.z))}},m.prototype.set=function(){var e=this.value;if(n(e.red))i.equals(e,this._value)||(this._value=i.clone(e,this._value),this._gl.uniform4f(this._location,e.red,e.green,e.blue,e.alpha));else{if(!n(e.x))throw new o('Invalid vec4 value for uniform "'+this._activethis.name+'".');r.equals(e,this._value)||(this._value=r.clone(e,this._value),this._gl.uniform4f(this._location,e.x,e.y,e.z,e.w))}},p.prototype.set=function(){var e=this._gl;e.activeTexture(e.TEXTURE0+this.textureUnitIndex);var t=this.value;e.bindTexture(t._target,t._texture)},p.prototype._setSampler=function(e){return this.textureUnitIndex=e,this._gl.uniform1i(this._location,e),e+1},f.prototype.set=function(){this.value!==this._value&&(this._value=this.value,this._gl.uniform1i(this._location,this.value))},v.prototype.set=function(){var t=this.value;e.equals(t,this._value)||(e.clone(t,this._value),this._gl.uniform2i(this._location,t.x,t.y))},g.prototype.set=function(){var e=this.value;t.equals(e,this._value)||(t.clone(e,this._value),this._gl.uniform3i(this._location,e.x,e.y,e.z))},_.prototype.set=function(){var e=this.value;r.equals(e,this._value)||(r.clone(e,this._value),this._gl.uniform4i(this._location,e.x,e.y,e.z,e.w))},y.prototype.set=function(){a.equalsArray(this.value,this._value,0)||(a.toArray(this.value,this._value),this._gl.uniformMatrix2fv(this._location,!1,this._value))},w.prototype.set=function(){s.equalsArray(this.value,this._value,0)||(s.toArray(this.value,this._value),this._gl.uniformMatrix3fv(this._location,!1,this._value))},C.prototype.set=function(){u.equalsArray(this.value,this._value,0)||(u.toArray(this.value,this._value),this._gl.uniformMatrix4fv(this._location,!1,this._value))},E}),r("Renderer/createUniformArray",["../Core/Cartesian2","../Core/Cartesian3","../Core/Cartesian4","../Core/Color","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Matrix2","../Core/Matrix3","../Core/Matrix4","../Core/RuntimeError"],function(e,t,r,i,n,o,a,s,u,l,c){"use strict";function h(e,t,r,i){var n=i.length;this.name=r,this.value=new Array(n),this._value=new Float32Array(n),this._gl=e,this._location=i[0]}function d(e,t,r,i){var n=i.length;this.name=r,this.value=new Array(n),this._value=new Float32Array(2*n),this._gl=e,this._location=i[0]}function m(e,t,r,i){var n=i.length;this.name=r,this.value=new Array(n),this._value=new Float32Array(3*n),this._gl=e,this._location=i[0]}function p(e,t,r,i){var n=i.length;this.name=r,this.value=new Array(n),this._value=new Float32Array(4*n),this._gl=e,this._location=i[0]}function f(e,t,r,i){var n=i.length;this.name=r,this.value=new Array(n),this._value=new Float32Array(n),this._gl=e,this._locations=i,this.textureUnitIndex=void 0}function v(e,t,r,i){var n=i.length;this.name=r,this.value=new Array(n),this._value=new Int32Array(n),this._gl=e,this._location=i[0]}function g(e,t,r,i){var n=i.length;this.name=r,this.value=new Array(n),this._value=new Int32Array(2*n),this._gl=e,this._location=i[0]}function _(e,t,r,i){var n=i.length;this.name=r,this.value=new Array(n),this._value=new Int32Array(3*n),this._gl=e,this._location=i[0]}function y(e,t,r,i){var n=i.length;this.name=r,this.value=new Array(n),this._value=new Int32Array(4*n),this._gl=e,this._location=i[0]}function w(e,t,r,i){var n=i.length;this.name=r,this.value=new Array(n),this._value=new Float32Array(4*n),this._gl=e,this._location=i[0]}function C(e,t,r,i){var n=i.length;this.name=r,this.value=new Array(n),this._value=new Float32Array(9*n),this._gl=e,this._location=i[0]}function E(e,t,r,i){var n=i.length;this.name=r,this.value=new Array(n),this._value=new Float32Array(16*n),this._gl=e,this._location=i[0]}var S=function(e,t,r,i){switch(t.type){case e.FLOAT:return new h(e,t,r,i);case e.FLOAT_VEC2:return new d(e,t,r,i);case e.FLOAT_VEC3:return new m(e,t,r,i);case e.FLOAT_VEC4:return new p(e,t,r,i);case e.SAMPLER_2D:case e.SAMPLER_CUBE:return new f(e,t,r,i);case e.INT:case e.BOOL:return new v(e,t,r,i);case e.INT_VEC2:case e.BOOL_VEC2:return new g(e,t,r,i);case e.INT_VEC3:case e.BOOL_VEC3:return new _(e,t,r,i);case e.INT_VEC4:case e.BOOL_VEC4:return new y(e,t,r,i);case e.FLOAT_MAT2:return new w(e,t,r,i);case e.FLOAT_MAT3:return new C(e,t,r,i);case e.FLOAT_MAT4:return new E(e,t,r,i);default:throw new c("Unrecognized uniform type: "+t.type+' for uniform "'+r+'".')}};return h.prototype.set=function(){for(var e=this.value,t=e.length,r=this._value,i=!1,n=0;t>n;++n){var o=e[n];o!==r[n]&&(r[n]=o,i=!0)}i&&this._gl.uniform1fv(this._location,r)},d.prototype.set=function(){for(var t=this.value,r=t.length,i=this._value,n=!1,o=0,a=0;r>a;++a){var s=t[a];e.equalsArray(s,i,o)||(e.pack(s,i,o),n=!0),o+=2}n&&this._gl.uniform2fv(this._location,i)},m.prototype.set=function(){for(var e=this.value,r=e.length,i=this._value,o=!1,s=0,u=0;r>u;++u){var l=e[u];if(n(l.red))(l.red!==i[s]||l.green!==i[s+1]||l.blue!==i[s+2])&&(i[s]=l.red,i[s+1]=l.green,i[s+2]=l.blue,o=!0);else{if(!n(l.x))throw new a("Invalid vec3 value.");t.equalsArray(l,i,s)||(t.pack(l,i,s),o=!0)}s+=3}o&&this._gl.uniform3fv(this._location,i)},p.prototype.set=function(){for(var e=this.value,t=e.length,o=this._value,s=!1,u=0,l=0;t>l;++l){var c=e[l];if(n(c.red))i.equalsArray(c,o,u)||(i.pack(c,o,u),s=!0);else{if(!n(c.x))throw new a("Invalid vec4 value.");r.equalsArray(c,o,u)||(r.pack(c,o,u),s=!0)}u+=4}s&&this._gl.uniform4fv(this._location,o)},f.prototype.set=function(){for(var e=this._gl,t=e.TEXTURE0+this.textureUnitIndex,r=this.value,i=r.length,n=0;i>n;++n){var o=r[n];e.activeTexture(t+n),e.bindTexture(o._target,o._texture)}},f.prototype._setSampler=function(e){this.textureUnitIndex=e;for(var t=this._locations,r=t.length,i=0;r>i;++i){var n=e+i;this._gl.uniform1i(t[i],n)}return e+r},v.prototype.set=function(){for(var e=this.value,t=e.length,r=this._value,i=!1,n=0;t>n;++n){var o=e[n];o!==r[n]&&(r[n]=o,i=!0)}i&&this._gl.uniform1iv(this._location,r)},g.prototype.set=function(){for(var t=this.value,r=t.length,i=this._value,n=!1,o=0,a=0;r>a;++a){var s=t[a];e.equalsArray(s,i,o)||(e.pack(s,i,o),n=!0),o+=2}n&&this._gl.uniform2iv(this._location,i)},_.prototype.set=function(){for(var e=this.value,r=e.length,i=this._value,n=!1,o=0,a=0;r>a;++a){var s=e[a];t.equalsArray(s,i,o)||(t.pack(s,i,o),n=!0),o+=3}n&&this._gl.uniform3iv(this._location,i)},y.prototype.set=function(){for(var e=this.value,t=e.length,i=this._value,n=!1,o=0,a=0;t>a;++a){var s=e[a];r.equalsArray(s,i,o)||(r.pack(s,i,o),n=!0),o+=4}n&&this._gl.uniform4iv(this._location,i)},w.prototype.set=function(){for(var e=this.value,t=e.length,r=this._value,i=!1,n=0,o=0;t>o;++o){var a=e[o];s.equalsArray(a,r,n)||(s.pack(a,r,n),i=!0),n+=4}i&&this._gl.uniformMatrix2fv(this._location,!1,r)},C.prototype.set=function(){for(var e=this.value,t=e.length,r=this._value,i=!1,n=0,o=0;t>o;++o){var a=e[o];u.equalsArray(a,r,n)||(u.pack(a,r,n),i=!0),n+=9}i&&this._gl.uniformMatrix3fv(this._location,!1,r)},E.prototype.set=function(){for(var e=this.value,t=e.length,r=this._value,i=!1,n=0,o=0;t>o;++o){var a=e[o];l.equalsArray(a,r,n)||(l.pack(a,r,n),i=!0),n+=16}i&&this._gl.uniformMatrix4fv(this._location,!1,r)},S}),r("Renderer/ShaderProgram",["../Core/defaultValue","../Core/defined","../Core/definedNotNull","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/RuntimeError","./AutomaticUniforms","./ContextLimits","./createUniform","./createUniformArray"],function(e,t,r,i,n,o,a,s,u,l,c){"use strict";function h(e){var t=[],i=e.match(/uniform.*?(?![^{]*})(?=[=\[;])/g);if(r(i))for(var n=i.length,o=0;n>o;o++){var a=i[o].trim(),s=a.slice(a.lastIndexOf(" ")+1);t.push(s)}return t}function d(e,t){var r={};if(!u.highpFloatSupported||!u.highpIntSupported){var i,n,o,a,s=h(e),l=h(t),c=s.length,d=l.length;for(i=0;c>i;i++)for(n=0;d>n;n++)if(s[i]===l[n]){o=s[i],a="czm_mediump_"+o;var m=new RegExp(o+"\\b","g");t=t.replace(m,a),r[a]=o}}return{fragmentShaderText:t,duplicateUniformNames:r}}function m(e,r){var i=r._vertexShaderText,n=r._fragmentShaderText,o=e.createShader(e.VERTEX_SHADER);e.shaderSource(o,i),e.compileShader(o);var s=e.createShader(e.FRAGMENT_SHADER);e.shaderSource(s,n),e.compileShader(s);var u=e.createProgram();e.attachShader(u,o),e.attachShader(u,s),e.deleteShader(o),e.deleteShader(s);var l=r._attributeLocations;if(t(l))for(var c in l)l.hasOwnProperty(c)&&e.bindAttribLocation(u,l[c],c);e.linkProgram(u);var h;if(!e.getProgramParameter(u,e.LINK_STATUS)){var d=r._debugShaders;if(!e.getShaderParameter(s,e.COMPILE_STATUS)){if(h=e.getShaderInfoLog(s),console.error(C+"Fragment shader compile log: "+h),t(d)){var m=d.getTranslatedShaderSource(s);""!==m?console.error(C+"Translated fragment shader source:\n"+m):console.error(C+"Fragment shader translation failed.")}throw e.deleteProgram(u),new a("Fragment shader failed to compile.  Compile log: "+h)}if(!e.getShaderParameter(o,e.COMPILE_STATUS)){if(h=e.getShaderInfoLog(o),console.error(C+"Vertex shader compile log: "+h),t(d)){var p=d.getTranslatedShaderSource(o);""!==p?console.error(C+"Translated vertex shader source:\n"+p):console.error(C+"Vertex shader translation failed.")}throw e.deleteProgram(u),new a("Vertex shader failed to compile.  Compile log: "+h)}throw h=e.getProgramInfoLog(u),console.error(C+"Shader program link log: "+h),t(d)&&(console.error(C+"Translated vertex shader source:\n"+d.getTranslatedShaderSource(o)),console.error(C+"Translated fragment shader source:\n"+d.getTranslatedShaderSource(s))),e.deleteProgram(u),new a("Program failed to link.  Link log: "+h)}var f=r._logShaderCompilation;return f&&(h=e.getShaderInfoLog(o),t(h)&&h.length>0&&console.log(C+"Vertex shader compile log: "+h)),f&&(h=e.getShaderInfoLog(s),t(h)&&h.length>0&&console.log(C+"Fragment shader compile log: "+h)),f&&(h=e.getProgramInfoLog(u),
t(h)&&h.length>0&&console.log(C+"Shader program link log: "+h)),u}function p(e,t,r){for(var i={},n=0;r>n;++n){var o=e.getActiveAttrib(t,n),a=e.getAttribLocation(t,o.name);i[o.name]={name:o.name,type:o.type,index:a}}return i}function f(e,r){for(var i={},n=[],o=[],a=e.getProgramParameter(r,e.ACTIVE_UNIFORMS),s=0;a>s;++s){var u=e.getActiveUniform(r,s),h="[0]",d=-1!==u.name.indexOf(h,u.name.length-h.length)?u.name.slice(0,u.name.length-3):u.name;if(0!==d.indexOf("gl_"))if(u.name.indexOf("[")<0){var m=e.getUniformLocation(r,d);if(null!==m){var p=l(e,u,d,m);i[d]=p,n.push(p),p._setSampler&&o.push(p)}}else{var f,v,g,_,y=d.indexOf("[");if(y>=0){if(f=i[d.slice(0,y)],!t(f))continue;v=f._locations,v.length<=1&&(g=f.value,_=e.getUniformLocation(r,d),null!==_&&(v.push(_),g.push(e.getUniform(r,_))))}else{v=[];for(var w=0;w<u.size;++w)_=e.getUniformLocation(r,d+"["+w+"]"),null!==_&&v.push(_);f=c(e,u,d,v),i[d]=f,n.push(f),f._setSampler&&o.push(f)}}}return{uniformsByName:i,uniforms:n,samplerUniforms:o}}function v(e,r){var i=[],n=[];for(var o in r)if(r.hasOwnProperty(o)){var a=r[o],u=o,l=e._duplicateUniformNames[u];t(l)&&(a.name=l,u=l);var c=s[u];t(c)?i.push({uniform:a,automaticUniform:c}):n.push(a)}return{automaticUniforms:i,manualUniforms:n}}function g(e,t,r){e.useProgram(t);for(var i=0,n=r.length,o=0;n>o;++o)i=r[o]._setSampler(i);return e.useProgram(null),i}function _(e){if(!t(e._program)){var r=e._gl,i=m(r,e,e._debugShaders),n=r.getProgramParameter(i,r.ACTIVE_ATTRIBUTES),o=f(r,i),a=v(e,o.uniformsByName);e._program=i,e._numberOfVertexAttributes=n,e._vertexAttributes=p(r,i,n),e._uniformsByName=o.uniformsByName,e._uniforms=o.uniforms,e._automaticUniforms=a.automaticUniforms,e._manualUniforms=a.manualUniforms,e.maximumTextureUnitIndex=g(r,i,o.samplerUniforms)}}var y=0,w=function(e){var t=d(e.vertexShaderText,e.fragmentShaderText);this._gl=e.gl,this._logShaderCompilation=e.logShaderCompilation,this._debugShaders=e.debugShaders,this._attributeLocations=e.attributeLocations,this._program=void 0,this._numberOfVertexAttributes=void 0,this._vertexAttributes=void 0,this._uniformsByName=void 0,this._uniforms=void 0,this._automaticUniforms=void 0,this._manualUniforms=void 0,this._duplicateUniformNames=t.duplicateUniformNames,this._cachedShader=void 0,this.maximumTextureUnitIndex=void 0,this._vertexShaderSource=e.vertexShaderSource,this._vertexShaderText=e.vertexShaderText,this._fragmentShaderSource=e.fragmentShaderSource,this._fragmentShaderText=t.fragmentShaderText,this.id=y++};w.fromCache=function(r){if(r=e(r,e.EMPTY_OBJECT),!t(r.context))throw new o("options.context is required.");return r.context.shaderCache.getShaderProgram(r)},w.replaceCache=function(r){if(r=e(r,e.EMPTY_OBJECT),!t(r.context))throw new o("options.context is required.");return r.context.shaderCache.replaceShaderProgram(r)},i(w.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},vertexAttributes:{get:function(){return _(this),this._vertexAttributes}},numberOfVertexAttributes:{get:function(){return _(this),this._numberOfVertexAttributes}},allUniforms:{get:function(){return _(this),this._uniformsByName}}});var C="[Cesium WebGL] ";return w.prototype._bind=function(){_(this),this._gl.useProgram(this._program)},w.prototype._setUniforms=function(e,r,i){var n,a;if(t(e)){var s=this._manualUniforms;for(n=s.length,a=0;n>a;++a){var u=s[a];u.value=e[u.name]()}}var l=this._automaticUniforms;for(n=l.length,a=0;n>a;++a){var c=l[a];c.uniform.value=c.automaticUniform.getValue(r)}var h=this._uniforms;for(n=h.length,a=0;n>a;++a)h[a].set();if(i){var d=this._gl,m=this._program;if(d.validateProgram(m),!d.getProgramParameter(m,d.VALIDATE_STATUS))throw new o("Program validation failed.  Program info log: "+d.getProgramInfoLog(m))}},w.prototype.isDestroyed=function(){return!1},w.prototype.destroy=function(){return void this._cachedShader.cache.releaseShaderProgram(this)},w.prototype.finalDestroy=function(){return this._gl.deleteProgram(this._program),n(this)},w}),r("Shaders/Builtin/Constants/degreesPerRadian",[],function(){"use strict";return"const float czm_degreesPerRadian = 57.29577951308232;\n"}),r("Shaders/Builtin/Constants/depthRange",[],function(){"use strict";return"const czm_depthRangeStruct czm_depthRange = czm_depthRangeStruct(0.0, 1.0);\n"}),r("Shaders/Builtin/Constants/epsilon1",[],function(){"use strict";return"const float czm_epsilon1 = 0.1;\n"}),r("Shaders/Builtin/Constants/epsilon2",[],function(){"use strict";return"const float czm_epsilon2 = 0.01;\n"}),r("Shaders/Builtin/Constants/epsilon3",[],function(){"use strict";return"const float czm_epsilon3 = 0.001;\n"}),r("Shaders/Builtin/Constants/epsilon4",[],function(){"use strict";return"const float czm_epsilon4 = 0.0001;\n"}),r("Shaders/Builtin/Constants/epsilon5",[],function(){"use strict";return"const float czm_epsilon5 = 0.00001;\n"}),r("Shaders/Builtin/Constants/epsilon6",[],function(){"use strict";return"const float czm_epsilon6 = 0.000001;\n"}),r("Shaders/Builtin/Constants/epsilon7",[],function(){"use strict";return"const float czm_epsilon7 = 0.0000001;\n"}),r("Shaders/Builtin/Constants/infinity",[],function(){"use strict";return"const float czm_infinity = 5906376272000.0;\n"}),r("Shaders/Builtin/Constants/oneOverPi",[],function(){"use strict";return"const float czm_oneOverPi = 0.3183098861837907;\n"}),r("Shaders/Builtin/Constants/oneOverTwoPi",[],function(){"use strict";return"const float czm_oneOverTwoPi = 0.15915494309189535;\n"}),r("Shaders/Builtin/Constants/pi",[],function(){"use strict";return"const float czm_pi = 3.141592653589793;\n"}),r("Shaders/Builtin/Constants/piOverFour",[],function(){"use strict";return"const float czm_piOverFour = 0.7853981633974483;\n"}),r("Shaders/Builtin/Constants/piOverSix",[],function(){"use strict";return"const float czm_piOverSix = 0.5235987755982988;\n"}),r("Shaders/Builtin/Constants/piOverThree",[],function(){"use strict";return"const float czm_piOverThree = 1.0471975511965976;\n"}),r("Shaders/Builtin/Constants/piOverTwo",[],function(){"use strict";return"const float czm_piOverTwo = 1.5707963267948966;\n"}),r("Shaders/Builtin/Constants/radiansPerDegree",[],function(){"use strict";return"const float czm_radiansPerDegree = 0.017453292519943295;\n"}),r("Shaders/Builtin/Constants/sceneMode2D",[],function(){"use strict";return"const float czm_sceneMode2D = 2.0;\n"}),r("Shaders/Builtin/Constants/sceneMode3D",[],function(){"use strict";return"const float czm_sceneMode3D = 3.0;\n"}),r("Shaders/Builtin/Constants/sceneModeColumbusView",[],function(){"use strict";return"const float czm_sceneModeColumbusView = 1.0;\n"}),r("Shaders/Builtin/Constants/sceneModeMorphing",[],function(){"use strict";return"const float czm_sceneModeMorphing = 0.0;\n"}),r("Shaders/Builtin/Constants/solarRadius",[],function(){"use strict";return"const float czm_solarRadius = 695500000.0;\n"}),r("Shaders/Builtin/Constants/threePiOver2",[],function(){"use strict";return"const float czm_threePiOver2 = 4.71238898038469;\n"}),r("Shaders/Builtin/Constants/twoPi",[],function(){"use strict";return"const float czm_twoPi = 6.283185307179586;\n"}),r("Shaders/Builtin/Constants/webMercatorMaxLatitude",[],function(){"use strict";return"const float czm_webMercatorMaxLatitude = 1.4844222297453324;\n"}),r("Shaders/Builtin/Structs/depthRangeStruct",[],function(){"use strict";return"struct czm_depthRangeStruct\n{\nfloat near;\nfloat far;\n};\n"}),r("Shaders/Builtin/Structs/ellipsoid",[],function(){"use strict";return"struct czm_ellipsoid\n{\nvec3 center;\nvec3 radii;\nvec3 inverseRadii;\nvec3 inverseRadiiSquared;\n};\n"}),r("Shaders/Builtin/Structs/material",[],function(){"use strict";return"struct czm_material\n{\nvec3 diffuse;\nfloat specular;\nfloat shininess;\nvec3 normal;\nvec3 emission;\nfloat alpha;\n};\n"}),r("Shaders/Builtin/Structs/materialInput",[],function(){"use strict";return"struct czm_materialInput\n{\nfloat s;\nvec2 st;\nvec3 str;\nvec3 normalEC;\nmat3 tangentToEyeMatrix;\nvec3 positionToEyeEC;\n};\n"}),r("Shaders/Builtin/Structs/ray",[],function(){"use strict";return"struct czm_ray\n{\nvec3 origin;\nvec3 direction;\n};\n"}),r("Shaders/Builtin/Structs/raySegment",[],function(){"use strict";return"struct czm_raySegment\n{\nfloat start;\nfloat stop;\n};\nconst czm_raySegment czm_emptyRaySegment = czm_raySegment(-czm_infinity, -czm_infinity);\nconst czm_raySegment czm_fullRaySegment = czm_raySegment(0.0, czm_infinity);\n"}),r("Shaders/Builtin/Functions/alphaWeight",[],function(){"use strict";return"float czm_alphaWeight(float a)\n{\nfloat z;\nif (czm_sceneMode != czm_sceneMode2D)\n{\nfloat x = 2.0 * (gl_FragCoord.x - czm_viewport.x) / czm_viewport.z - 1.0;\nfloat y = 2.0 * (gl_FragCoord.y - czm_viewport.y) / czm_viewport.w - 1.0;\nz = (gl_FragCoord.z - czm_viewportTransformation[3][2]) / czm_viewportTransformation[2][2];\nvec4 q = vec4(x, y, z, 0.0);\nq /= gl_FragCoord.w;\nz = (czm_inverseProjectionOIT * q).z;\n}\nelse\n{\nz = gl_FragCoord.z * (czm_currentFrustum.y - czm_currentFrustum.x) + czm_currentFrustum.x;\n}\nreturn pow(a + 0.01, 4.0) + max(1e-2, min(3.0 * 1e3, 100.0 / (1e-5 + pow(abs(z) / 10.0, 3.0) + pow(abs(z) / 200.0, 6.0))));\n}\n"}),r("Shaders/Builtin/Functions/antialias",[],function(){"use strict";return"vec4 czm_antialias(vec4 color1, vec4 color2, vec4 currentColor, float dist, float fuzzFactor)\n{\nfloat val1 = clamp(dist / fuzzFactor, 0.0, 1.0);\nfloat val2 = clamp((dist - 0.5) / fuzzFactor, 0.0, 1.0);\nval1 = val1 * (1.0 - val2);\nval1 = val1 * val1 * (3.0 - (2.0 * val1));\nval1 = pow(val1, 0.5);\nvec4 midColor = (color1 + color2) * 0.5;\nreturn mix(midColor, currentColor, val1);\n}\nvec4 czm_antialias(vec4 color1, vec4 color2, vec4 currentColor, float dist)\n{\nreturn czm_antialias(color1, color2, currentColor, dist, 0.1);\n}\n"}),r("Shaders/Builtin/Functions/columbusViewMorph",[],function(){"use strict";return"vec4 czm_columbusViewMorph(vec4 position2D, vec4 position3D, float time)\n{\nvec3 p = mix(position2D.xyz, position3D.xyz, time);\nreturn vec4(p, 1.0);\n}\n"}),r("Shaders/Builtin/Functions/computePosition",[],function(){"use strict";return"vec4 czm_computePosition();\n"}),r("Shaders/Builtin/Functions/cosineAndSine",[],function(){"use strict";return"vec2 cordic(float angle)\n{\nvec2 vector = vec2(6.0725293500888267e-1, 0.0);\nfloat sense = (angle < 0.0) ? -1.0 : 1.0;\nmat2 rotation = mat2(1.0, sense, -sense, 1.0);\nvector = rotation * vector;\nangle -= sense * 7.8539816339744828e-1;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfloat factor = sense * 5.0e-1;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 4.6364760900080609e-1;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 2.5e-1;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 2.4497866312686414e-1;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.25e-1;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 1.2435499454676144e-1;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 6.25e-2;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 6.2418809995957350e-2;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 3.125e-2;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 3.1239833430268277e-2;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.5625e-2;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 1.5623728620476831e-2;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 7.8125e-3;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 7.8123410601011111e-3;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 3.90625e-3;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 3.9062301319669718e-3;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.953125e-3;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 1.9531225164788188e-3;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 9.765625e-4;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 9.7656218955931946e-4;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 4.8828125e-4;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 4.8828121119489829e-4;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 2.44140625e-4;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 2.4414062014936177e-4;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.220703125e-4;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 1.2207031189367021e-4;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 6.103515625e-5;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 6.1035156174208773e-5;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 3.0517578125e-5;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 3.0517578115526096e-5;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.52587890625e-5;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 1.5258789061315762e-5;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 7.62939453125e-6;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 7.6293945311019700e-6;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 3.814697265625e-6;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 3.8146972656064961e-6;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.9073486328125e-6;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 1.9073486328101870e-6;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 9.5367431640625e-7;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 9.5367431640596084e-7;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 4.76837158203125e-7;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 4.7683715820308884e-7;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 2.384185791015625e-7;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nangle -= sense * 2.3841857910155797e-7;\nsense = (angle < 0.0) ? -1.0 : 1.0;\nfactor = sense * 1.1920928955078125e-7;\nrotation[0][1] = factor;\nrotation[1][0] = -factor;\nvector = rotation * vector;\nreturn vector;\n}\nvec2 czm_cosineAndSine(float angle)\n{\nif (angle < -czm_piOverTwo || angle > czm_piOverTwo)\n{\nif (angle < 0.0)\n{\nreturn -cordic(angle + czm_pi);\n}\nelse\n{\nreturn -cordic(angle - czm_pi);\n}\n}\nelse\n{\nreturn cordic(angle);\n}\n}\n"}),r("Shaders/Builtin/Functions/decompressTextureCoordinates",[],function(){"use strict";return"vec2 czm_decompressTextureCoordinates(float encoded)\n{\nfloat temp = encoded / 4096.0;\nfloat stx = floor(temp) / 4096.0;\nfloat sty = temp - floor(temp);\nreturn vec2(stx, sty);\n}\n"}),r("Shaders/Builtin/Functions/eastNorthUpToEyeCoordinates",[],function(){"use strict";return"mat3 czm_eastNorthUpToEyeCoordinates(vec3 positionMC, vec3 normalEC)\n{\nvec3 tangentMC = normalize(vec3(-positionMC.y, positionMC.x, 0.0));\nvec3 tangentEC = normalize(czm_normal3D * tangentMC);\nvec3 bitangentEC = normalize(cross(normalEC, tangentEC));\nreturn mat3(\ntangentEC.x,   tangentEC.y,   tangentEC.z,\nbitangentEC.x, bitangentEC.y, bitangentEC.z,\nnormalEC.x,    normalEC.y,    normalEC.z);\n}\n"}),r("Shaders/Builtin/Functions/ellipsoidContainsPoint",[],function(){"use strict";return"bool czm_ellipsoidContainsPoint(czm_ellipsoid ellipsoid, vec3 point)\n{\nvec3 scaled = ellipsoid.inverseRadii * (czm_inverseModelView * vec4(point, 1.0)).xyz;\nreturn (dot(scaled, scaled) <= 1.0);\n}\n"}),r("Shaders/Builtin/Functions/ellipsoidNew",[],function(){"use strict";return"czm_ellipsoid czm_ellipsoidNew(vec3 center, vec3 radii)\n{\nvec3 inverseRadii = vec3(1.0 / radii.x, 1.0 / radii.y, 1.0 / radii.z);\nvec3 inverseRadiiSquared = inverseRadii * inverseRadii;\nczm_ellipsoid temp = czm_ellipsoid(center, radii, inverseRadii, inverseRadiiSquared);\nreturn temp;\n}\n"}),r("Shaders/Builtin/Functions/ellipsoidWgs84TextureCoordinates",[],function(){"use strict";return"vec2 czm_ellipsoidWgs84TextureCoordinates(vec3 normal)\n{\nreturn vec2(atan(normal.y, normal.x) * czm_oneOverTwoPi + 0.5, asin(normal.z) * czm_oneOverPi + 0.5);\n}\n"}),r("Shaders/Builtin/Functions/equalsEpsilon",[],function(){"use strict";return"bool czm_equalsEpsilon(vec4 left, vec4 right, float epsilon) {\nreturn all(lessThanEqual(abs(left - right), vec4(epsilon)));\n}\nbool czm_equalsEpsilon(vec3 left, vec3 right, float epsilon) {\nreturn all(lessThanEqual(abs(left - right), vec3(epsilon)));\n}\nbool czm_equalsEpsilon(vec2 left, vec2 right, float epsilon) {\nreturn all(lessThanEqual(abs(left - right), vec2(epsilon)));\n}\nbool czm_equalsEpsilon(float left, float right, float epsilon) {\nreturn (abs(left - right) <= epsilon);\n}\n"}),r("Shaders/Builtin/Functions/eyeOffset",[],function(){"use strict";return"vec4 czm_eyeOffset(vec4 positionEC, vec3 eyeOffset)\n{\nvec4 p = positionEC;\nvec4 zEyeOffset = normalize(p) * eyeOffset.z;\np.xy += eyeOffset.xy + zEyeOffset.xy;\np.z += zEyeOffset.z;\nreturn p;\n}\n"}),r("Shaders/Builtin/Functions/eyeToWindowCoordinates",[],function(){"use strict";return"vec4 czm_eyeToWindowCoordinates(vec4 positionEC)\n{\nvec4 q = czm_projection * positionEC;\nq.xyz /= q.w;\nq.xyz = (czm_viewportTransformation * vec4(q.xyz, 1.0)).xyz;\nreturn q;\n}\n"}),r("Shaders/Builtin/Functions/geodeticSurfaceNormal",[],function(){"use strict";return"vec3 czm_geodeticSurfaceNormal(vec3 positionOnEllipsoid, vec3 ellipsoidCenter, vec3 oneOverEllipsoidRadiiSquared)\n{\nreturn normalize((positionOnEllipsoid - ellipsoidCenter) * oneOverEllipsoidRadiiSquared);\n}\n"}),r("Shaders/Builtin/Functions/getDefaultMaterial",[],function(){"use strict";return"czm_material czm_getDefaultMaterial(czm_materialInput materialInput)\n{\nczm_material material;\nmaterial.diffuse = vec3(0.0);\nmaterial.specular = 0.0;\nmaterial.shininess = 1.0;\nmaterial.normal = materialInput.normalEC;\nmaterial.emission = vec3(0.0);\nmaterial.alpha = 1.0;\nreturn material;\n}\n"}),r("Shaders/Builtin/Functions/getLambertDiffuse",[],function(){"use strict";return"float czm_getLambertDiffuse(vec3 lightDirectionEC, vec3 normalEC)\n{\nreturn max(dot(lightDirectionEC, normalEC), 0.0);\n}\n"}),r("Shaders/Builtin/Functions/getSpecular",[],function(){"use strict";return"float czm_getSpecular(vec3 lightDirectionEC, vec3 toEyeEC, vec3 normalEC, float shininess)\n{\nvec3 toReflectedLight = reflect(-lightDirectionEC, normalEC);\nfloat specular = max(dot(toReflectedLight, toEyeEC), 0.0);\nreturn pow(specular, shininess);\n}\n"}),r("Shaders/Builtin/Functions/getWaterNoise",[],function(){"use strict";return"vec4 czm_getWaterNoise(sampler2D normalMap, vec2 uv, float time, float angleInRadians)\n{\nfloat cosAngle = cos(angleInRadians);\nfloat sinAngle = sin(angleInRadians);\nvec2 s0 = vec2(1.0/17.0, 0.0);\nvec2 s1 = vec2(-1.0/29.0, 0.0);\nvec2 s2 = vec2(1.0/101.0, 1.0/59.0);\nvec2 s3 = vec2(-1.0/109.0, -1.0/57.0);\ns0 = vec2((cosAngle * s0.x) - (sinAngle * s0.y), (sinAngle * s0.x) + (cosAngle * s0.y));\ns1 = vec2((cosAngle * s1.x) - (sinAngle * s1.y), (sinAngle * s1.x) + (cosAngle * s1.y));\ns2 = vec2((cosAngle * s2.x) - (sinAngle * s2.y), (sinAngle * s2.x) + (cosAngle * s2.y));\ns3 = vec2((cosAngle * s3.x) - (sinAngle * s3.y), (sinAngle * s3.x) + (cosAngle * s3.y));\nvec2 uv0 = (uv/103.0) + (time * s0);\nvec2 uv1 = uv/107.0 + (time * s1) + vec2(0.23);\nvec2 uv2 = uv/vec2(897.0, 983.0) + (time * s2) + vec2(0.51);\nvec2 uv3 = uv/vec2(991.0, 877.0) + (time * s3) + vec2(0.71);\nuv0 = fract(uv0);\nuv1 = fract(uv1);\nuv2 = fract(uv2);\nuv3 = fract(uv3);\nvec4 noise = (texture2D(normalMap, uv0)) +\n(texture2D(normalMap, uv1)) +\n(texture2D(normalMap, uv2)) +\n(texture2D(normalMap, uv3));\nreturn ((noise / 4.0) - 0.5) * 2.0;\n}\n"}),r("Shaders/Builtin/Functions/getWgs84EllipsoidEC",[],function(){"use strict";return"czm_ellipsoid czm_getWgs84EllipsoidEC()\n{\nvec3 radii = vec3(6378137.0, 6378137.0, 6356752.314245);\nvec3 inverseRadii = vec3(1.0 / radii.x, 1.0 / radii.y, 1.0 / radii.z);\nvec3 inverseRadiiSquared = inverseRadii * inverseRadii;\nczm_ellipsoid temp = czm_ellipsoid(czm_view[3].xyz, radii, inverseRadii, inverseRadiiSquared);\nreturn temp;\n}\n"}),r("Shaders/Builtin/Functions/hue",[],function(){"use strict";return"vec3 czm_hue(vec3 rgb, float adjustment)\n{\nconst mat3 toYIQ = mat3(0.299,     0.587,     0.114,\n0.595716, -0.274453, -0.321263,\n0.211456, -0.522591,  0.311135);\nconst mat3 toRGB = mat3(1.0,  0.9563,  0.6210,\n1.0, -0.2721, -0.6474,\n1.0, -1.107,   1.7046);\nvec3 yiq = toYIQ * rgb;\nfloat hue = atan(yiq.z, yiq.y) + adjustment;\nfloat chroma = sqrt(yiq.z * yiq.z + yiq.y * yiq.y);\nvec3 color = vec3(yiq.x, chroma * cos(hue), chroma * sin(hue));\nreturn toRGB * color;\n}\n"}),r("Shaders/Builtin/Functions/isEmpty",[],function(){"use strict";return"bool czm_isEmpty(czm_raySegment interval)\n{\nreturn (interval.stop < 0.0);\n}\n"}),r("Shaders/Builtin/Functions/isFull",[],function(){"use strict";return"bool czm_isFull(czm_raySegment interval)\n{\nreturn (interval.start == 0.0 && interval.stop == czm_infinity);\n}\n"}),r("Shaders/Builtin/Functions/latitudeToWebMercatorFraction",[],function(){"use strict";return"float czm_latitudeToWebMercatorFraction(float latitude, float southMercatorY, float oneOverMercatorHeight)\n{\nfloat sinLatitude = sin(latitude);\nfloat mercatorY = 0.5 * log((1.0 + sinLatitude) / (1.0 - sinLatitude));\nreturn (mercatorY - southMercatorY) * oneOverMercatorHeight;\n}\n"}),r("Shaders/Builtin/Functions/luminance",[],function(){"use strict";return"float czm_luminance(vec3 rgb)\n{\nconst vec3 W = vec3(0.2125, 0.7154, 0.0721);\nreturn dot(rgb, W);\n}\n"}),r("Shaders/Builtin/Functions/metersPerPixel",[],function(){"use strict";return"float czm_metersPerPixel(vec4 positionEC)\n{\nfloat width = czm_viewport.z;\nfloat height = czm_viewport.w;\nfloat pixelWidth;\nfloat pixelHeight;\nfloat top = czm_frustumPlanes.x;\nfloat bottom = czm_frustumPlanes.y;\nfloat left = czm_frustumPlanes.z;\nfloat right = czm_frustumPlanes.w;\nif (czm_sceneMode == czm_sceneMode2D)\n{\nfloat frustumWidth = right - left;\nfloat frustumHeight = top - bottom;\npixelWidth = frustumWidth / width;\npixelHeight = frustumHeight / height;\n}\nelse\n{\nfloat distanceToPixel = -positionEC.z;\nfloat inverseNear = 1.0 / czm_currentFrustum.x;\nfloat tanTheta = top * inverseNear;\npixelHeight = 2.0 * distanceToPixel * tanTheta / height;\ntanTheta = right * inverseNear;\npixelWidth = 2.0 * distanceToPixel * tanTheta / width;\n}\nreturn max(pixelWidth, pixelHeight);\n}\n"}),r("Shaders/Builtin/Functions/modelToWindowCoordinates",[],function(){"use strict";return"vec4 czm_modelToWindowCoordinates(vec4 position)\n{\nvec4 q = czm_modelViewProjection * position;\nq.xyz /= q.w;\nq.xyz = (czm_viewportTransformation * vec4(q.xyz, 1.0)).xyz;\nreturn q;\n}\n"}),r("Shaders/Builtin/Functions/multiplyWithColorBalance",[],function(){"use strict";return"vec3 czm_multiplyWithColorBalance(vec3 left, vec3 right)\n{\nconst vec3 W = vec3(0.2125, 0.7154, 0.0721);\nvec3 target = left * right;\nfloat leftLuminance = dot(left, W);\nfloat rightLuminance = dot(right, W);\nfloat targetLuminance = dot(target, W);\nreturn ((leftLuminance + rightLuminance) / (2.0 * targetLuminance)) * target;\n}\n"}),r("Shaders/Builtin/Functions/nearFarScalar",[],function(){"use strict";return"float czm_nearFarScalar(vec4 nearFarScalar, float cameraDistSq)\n{\nfloat valueAtMin = nearFarScalar.y;\nfloat valueAtMax = nearFarScalar.w;\nfloat nearDistanceSq = nearFarScalar.x * nearFarScalar.x;\nfloat farDistanceSq = nearFarScalar.z * nearFarScalar.z;\nfloat t = (cameraDistSq - nearDistanceSq) / (farDistanceSq - nearDistanceSq);\nt = pow(clamp(t, 0.0, 1.0), 0.2);\nreturn mix(valueAtMin, valueAtMax, t);\n}\n"}),r("Shaders/Builtin/Functions/octDecode",[],function(){"use strict";return"vec3 czm_octDecode(vec2 encoded)\n{\nencoded = encoded / 255.0 * 2.0 - 1.0;\nvec3 v = vec3(encoded.x, encoded.y, 1.0 - abs(encoded.x) - abs(encoded.y));\nif (v.z < 0.0)\n{\nv.xy = (1.0 - abs(v.yx)) * czm_signNotZero(v.xy);\n}\nreturn normalize(v);\n}\nvec3 czm_octDecode(float encoded)\n{\nfloat temp = encoded / 256.0;\nfloat x = floor(temp);\nfloat y = (temp - x) * 256.0;\nreturn czm_octDecode(vec2(x, y));\n}\nvoid czm_octDecode(vec2 encoded, out vec3 vector1, out vec3 vector2, out vec3 vector3)\n{\nfloat temp = encoded.x / 65536.0;\nfloat x = floor(temp);\nfloat encodedFloat1 = (temp - x) * 65536.0;\ntemp = encoded.y / 65536.0;\nfloat y = floor(temp);\nfloat encodedFloat2 = (temp - y) * 65536.0;\nvector1 = czm_octDecode(encodedFloat1);\nvector2 = czm_octDecode(encodedFloat2);\nvector3 = czm_octDecode(vec2(x, y));\n}\n"}),r("Shaders/Builtin/Functions/packDepth",[],function(){"use strict";return"vec4 czm_packDepth(float depth)\n{\nvec4 enc = vec4(1.0, 255.0, 65025.0, 160581375.0) * depth;\nenc = fract(enc);\nenc -= enc.yzww * vec4(1.0 / 255.0, 1.0 / 255.0, 1.0 / 255.0, 0.0);\nreturn enc;\n}\n"}),r("Shaders/Builtin/Functions/phong",[],function(){"use strict";return"float czm_private_getLambertDiffuseOfMaterial(vec3 lightDirectionEC, czm_material material)\n{\nreturn czm_getLambertDiffuse(lightDirectionEC, material.normal);\n}\nfloat czm_private_getSpecularOfMaterial(vec3 lightDirectionEC, vec3 toEyeEC, czm_material material)\n{\nreturn czm_getSpecular(lightDirectionEC, toEyeEC, material.normal, material.shininess);\n}\nvec4 czm_phong(vec3 toEye, czm_material material)\n{\nfloat diffuse = czm_private_getLambertDiffuseOfMaterial(vec3(0.0, 0.0, 1.0), material);\nif (czm_sceneMode == czm_sceneMode3D) {\ndiffuse += czm_private_getLambertDiffuseOfMaterial(vec3(0.0, 1.0, 0.0), material);\n}\nfloat specular = czm_private_getSpecularOfMaterial(czm_sunDirectionEC, toEye, material) + czm_private_getSpecularOfMaterial(czm_moonDirectionEC, toEye, material);\nvec3 materialDiffuse = material.diffuse * 0.5;\nvec3 ambient = materialDiffuse;\nvec3 color = ambient + material.emission;\ncolor += materialDiffuse * diffuse;\ncolor += material.specular * specular;\nreturn vec4(color, material.alpha);\n}\nvec4 czm_private_phong(vec3 toEye, czm_material material)\n{\nfloat diffuse = czm_private_getLambertDiffuseOfMaterial(czm_sunDirectionEC, material);\nfloat specular = czm_private_getSpecularOfMaterial(czm_sunDirectionEC, toEye, material);\nvec3 ambient = vec3(0.0);\nvec3 color = ambient + material.emission;\ncolor += material.diffuse * diffuse;\ncolor += material.specular * specular;\nreturn vec4(color, material.alpha);\n}\n"}),r("Shaders/Builtin/Functions/pointAlongRay",[],function(){"use strict";return"vec3 czm_pointAlongRay(czm_ray ray, float time)\n{\nreturn ray.origin + (time * ray.direction);\n}\n"}),r("Shaders/Builtin/Functions/rayEllipsoidIntersectionInterval",[],function(){"use strict";return"czm_raySegment czm_rayEllipsoidIntersectionInterval(czm_ray ray, czm_ellipsoid ellipsoid)\n{\nvec3 q = ellipsoid.inverseRadii * (czm_inverseModelView * vec4(ray.origin, 1.0)).xyz;\nvec3 w = ellipsoid.inverseRadii * (czm_inverseModelView * vec4(ray.direction, 0.0)).xyz;\nq = q - ellipsoid.inverseRadii * (czm_inverseModelView * vec4(ellipsoid.center, 1.0)).xyz;\nfloat q2 = dot(q, q);\nfloat qw = dot(q, w);\nif (q2 > 1.0)\n{\nif (qw >= 0.0)\n{\nreturn czm_emptyRaySegment;\n}\nelse\n{\nfloat qw2 = qw * qw;\nfloat difference = q2 - 1.0;\nfloat w2 = dot(w, w);\nfloat product = w2 * difference;\nif (qw2 < product)\n{\nreturn czm_emptyRaySegment;\n}\nelse if (qw2 > product)\n{\nfloat discriminant = qw * qw - product;\nfloat temp = -qw + sqrt(discriminant);\nfloat root0 = temp / w2;\nfloat root1 = difference / temp;\nif (root0 < root1)\n{\nczm_raySegment i = czm_raySegment(root0, root1);\nreturn i;\n}\nelse\n{\nczm_raySegment i = czm_raySegment(root1, root0);\nreturn i;\n}\n}\nelse\n{\nfloat root = sqrt(difference / w2);\nczm_raySegment i = czm_raySegment(root, root);\nreturn i;\n}\n}\n}\nelse if (q2 < 1.0)\n{\nfloat difference = q2 - 1.0;\nfloat w2 = dot(w, w);\nfloat product = w2 * difference;\nfloat discriminant = qw * qw - product;\nfloat temp = -qw + sqrt(discriminant);\nczm_raySegment i = czm_raySegment(0.0, temp / w2);\nreturn i;\n}\nelse\n{\nif (qw < 0.0)\n{\nfloat w2 = dot(w, w);\nczm_raySegment i = czm_raySegment(0.0, -qw / w2);\nreturn i;\n}\nelse\n{\nreturn czm_emptyRaySegment;\n}\n}\n}\n"}),r("Shaders/Builtin/Functions/RGBToXYZ",[],function(){"use strict";return"vec3 czm_RGBToXYZ(vec3 rgb)\n{\nconst mat3 RGB2XYZ = mat3(0.4124, 0.2126, 0.0193,\n0.3576, 0.7152, 0.1192,\n0.1805, 0.0722, 0.9505);\nvec3 xyz = RGB2XYZ * rgb;\nvec3 Yxy;\nYxy.r = xyz.g;\nfloat temp = dot(vec3(1.0), xyz);\nYxy.gb = xyz.rg / temp;\nreturn Yxy;\n}\n"}),r("Shaders/Builtin/Functions/saturation",[],function(){"use strict";return"vec3 czm_saturation(vec3 rgb, float adjustment)\n{\nconst vec3 W = vec3(0.2125, 0.7154, 0.0721);\nvec3 intensity = vec3(dot(rgb, W));\nreturn mix(intensity, rgb, adjustment);\n}\n"}),r("Shaders/Builtin/Functions/signNotZero",[],function(){"use strict";return"float czm_signNotZero(float value)\n{\nreturn value >= 0.0 ? 1.0 : -1.0;\n}\nvec2 czm_signNotZero(vec2 value)\n{\nreturn vec2(czm_signNotZero(value.x), czm_signNotZero(value.y));\n}\nvec3 czm_signNotZero(vec3 value)\n{\nreturn vec3(czm_signNotZero(value.x), czm_signNotZero(value.y), czm_signNotZero(value.z));\n}\nvec4 czm_signNotZero(vec4 value)\n{\nreturn vec4(czm_signNotZero(value.x), czm_signNotZero(value.y), czm_signNotZero(value.z), czm_signNotZero(value.w));\n}\n"}),r("Shaders/Builtin/Functions/tangentToEyeSpaceMatrix",[],function(){"use strict";return"mat3 czm_tangentToEyeSpaceMatrix(vec3 normalEC, vec3 tangentEC, vec3 binormalEC)\n{\nvec3 normal = normalize(normalEC);\nvec3 tangent = normalize(tangentEC);\nvec3 binormal = normalize(binormalEC);\nreturn mat3(tangent.x,  tangent.y,  tangent.z,\nbinormal.x, binormal.y, binormal.z,\nnormal.x,   normal.y,   normal.z);\n}\n"}),r("Shaders/Builtin/Functions/translateRelativeToEye",[],function(){"use strict";return"vec4 czm_translateRelativeToEye(vec3 high, vec3 low)\n{\nvec3 highDifference = high - czm_encodedCameraPositionMCHigh;\nvec3 lowDifference = low - czm_encodedCameraPositionMCLow;\nreturn vec4(highDifference + lowDifference, 1.0);\n}\n"}),r("Shaders/Builtin/Functions/translucentPhong",[],function(){"use strict";return"vec4 czm_translucentPhong(vec3 toEye, czm_material material)\n{\nfloat diffuse = czm_getLambertDiffuse(vec3(0.0, 0.0, 1.0), material.normal);\nif (czm_sceneMode == czm_sceneMode3D) {\ndiffuse += czm_getLambertDiffuse(vec3(0.0, 1.0, 0.0), material.normal);\n}\ndiffuse = clamp(diffuse, 0.0, 1.0);\nfloat specular = czm_getSpecular(czm_sunDirectionEC, toEye, material.normal, material.shininess);\nspecular += czm_getSpecular(czm_moonDirectionEC, toEye, material.normal, material.shininess);\nvec3 materialDiffuse = material.diffuse * 0.5;\nvec3 ambient = materialDiffuse;\nvec3 color = ambient + material.emission;\ncolor += materialDiffuse * diffuse;\ncolor += material.specular * specular;\nreturn vec4(color, material.alpha);\n}\n"}),r("Shaders/Builtin/Functions/transpose",[],function(){"use strict";return"mat2 czm_transpose(mat2 matrix)\n{\nreturn mat2(\nmatrix[0][0], matrix[1][0],\nmatrix[0][1], matrix[1][1]);\n}\nmat3 czm_transpose(mat3 matrix)\n{\nreturn mat3(\nmatrix[0][0], matrix[1][0], matrix[2][0],\nmatrix[0][1], matrix[1][1], matrix[2][1],\nmatrix[0][2], matrix[1][2], matrix[2][2]);\n}\nmat4 czm_transpose(mat4 matrix)\n{\nreturn mat4(\nmatrix[0][0], matrix[1][0], matrix[2][0], matrix[3][0],\nmatrix[0][1], matrix[1][1], matrix[2][1], matrix[3][1],\nmatrix[0][2], matrix[1][2], matrix[2][2], matrix[3][2],\nmatrix[0][3], matrix[1][3], matrix[2][3], matrix[3][3]);\n}\n";
}),r("Shaders/Builtin/Functions/unpackDepth",[],function(){"use strict";return"float czm_unpackDepth(vec4 packedDepth)\n{\nreturn dot(packedDepth, vec4(1.0, 1.0 / 255.0, 1.0 / 65025.0, 1.0 / 160581375.0));\n}\n"}),r("Shaders/Builtin/Functions/windowToEyeCoordinates",[],function(){"use strict";return"vec4 czm_windowToEyeCoordinates(vec4 fragmentCoordinate)\n{\nfloat x = 2.0 * (fragmentCoordinate.x - czm_viewport.x) / czm_viewport.z - 1.0;\nfloat y = 2.0 * (fragmentCoordinate.y - czm_viewport.y) / czm_viewport.w - 1.0;\nfloat z = (fragmentCoordinate.z - czm_viewportTransformation[3][2]) / czm_viewportTransformation[2][2];\nvec4 q = vec4(x, y, z, 1.0);\nq /= fragmentCoordinate.w;\nq = czm_inverseProjection * q;\nreturn q;\n}\n"}),r("Shaders/Builtin/Functions/XYZToRGB",[],function(){"use strict";return"vec3 czm_XYZToRGB(vec3 Yxy)\n{\nconst mat3 XYZ2RGB = mat3( 3.2405, -0.9693,  0.0556,\n-1.5371,  1.8760, -0.2040,\n-0.4985,  0.0416,  1.0572);\nvec3 xyz;\nxyz.r = Yxy.r * Yxy.g / Yxy.b;\nxyz.g = Yxy.r;\nxyz.b = Yxy.r * (1.0 - Yxy.g - Yxy.b) / Yxy.b;\nreturn XYZ2RGB * xyz;\n}\n"}),r("Shaders/Builtin/CzmBuiltins",["./Constants/degreesPerRadian","./Constants/depthRange","./Constants/epsilon1","./Constants/epsilon2","./Constants/epsilon3","./Constants/epsilon4","./Constants/epsilon5","./Constants/epsilon6","./Constants/epsilon7","./Constants/infinity","./Constants/oneOverPi","./Constants/oneOverTwoPi","./Constants/pi","./Constants/piOverFour","./Constants/piOverSix","./Constants/piOverThree","./Constants/piOverTwo","./Constants/radiansPerDegree","./Constants/sceneMode2D","./Constants/sceneMode3D","./Constants/sceneModeColumbusView","./Constants/sceneModeMorphing","./Constants/solarRadius","./Constants/threePiOver2","./Constants/twoPi","./Constants/webMercatorMaxLatitude","./Structs/depthRangeStruct","./Structs/ellipsoid","./Structs/material","./Structs/materialInput","./Structs/ray","./Structs/raySegment","./Functions/alphaWeight","./Functions/antialias","./Functions/columbusViewMorph","./Functions/computePosition","./Functions/cosineAndSine","./Functions/decompressTextureCoordinates","./Functions/eastNorthUpToEyeCoordinates","./Functions/ellipsoidContainsPoint","./Functions/ellipsoidNew","./Functions/ellipsoidWgs84TextureCoordinates","./Functions/equalsEpsilon","./Functions/eyeOffset","./Functions/eyeToWindowCoordinates","./Functions/geodeticSurfaceNormal","./Functions/getDefaultMaterial","./Functions/getLambertDiffuse","./Functions/getSpecular","./Functions/getWaterNoise","./Functions/getWgs84EllipsoidEC","./Functions/hue","./Functions/isEmpty","./Functions/isFull","./Functions/latitudeToWebMercatorFraction","./Functions/luminance","./Functions/metersPerPixel","./Functions/modelToWindowCoordinates","./Functions/multiplyWithColorBalance","./Functions/nearFarScalar","./Functions/octDecode","./Functions/packDepth","./Functions/phong","./Functions/pointAlongRay","./Functions/rayEllipsoidIntersectionInterval","./Functions/RGBToXYZ","./Functions/saturation","./Functions/signNotZero","./Functions/tangentToEyeSpaceMatrix","./Functions/translateRelativeToEye","./Functions/translucentPhong","./Functions/transpose","./Functions/unpackDepth","./Functions/windowToEyeCoordinates","./Functions/XYZToRGB"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f,v,g,_,y,w,C,E,S,b,T,x,P,A,I,D,M,R,O,N,L,F,B,z,V,k,U,q,G,W,H,j,Y,X,Z,K,Q,J,$,ee,te,re,ie,ne,oe,ae,se,ue,le,ce,he,de,me,pe,fe,ve,ge,_e,ye,we){"use strict";return{czm_degreesPerRadian:e,czm_depthRange:t,czm_epsilon1:r,czm_epsilon2:i,czm_epsilon3:n,czm_epsilon4:o,czm_epsilon5:a,czm_epsilon6:s,czm_epsilon7:u,czm_infinity:l,czm_oneOverPi:c,czm_oneOverTwoPi:h,czm_pi:d,czm_piOverFour:m,czm_piOverSix:p,czm_piOverThree:f,czm_piOverTwo:v,czm_radiansPerDegree:g,czm_sceneMode2D:_,czm_sceneMode3D:y,czm_sceneModeColumbusView:w,czm_sceneModeMorphing:C,czm_solarRadius:E,czm_threePiOver2:S,czm_twoPi:b,czm_webMercatorMaxLatitude:T,czm_depthRangeStruct:x,czm_ellipsoid:P,czm_material:A,czm_materialInput:I,czm_ray:D,czm_raySegment:M,czm_alphaWeight:R,czm_antialias:O,czm_columbusViewMorph:N,czm_computePosition:L,czm_cosineAndSine:F,czm_decompressTextureCoordinates:B,czm_eastNorthUpToEyeCoordinates:z,czm_ellipsoidContainsPoint:V,czm_ellipsoidNew:k,czm_ellipsoidWgs84TextureCoordinates:U,czm_equalsEpsilon:q,czm_eyeOffset:G,czm_eyeToWindowCoordinates:W,czm_geodeticSurfaceNormal:H,czm_getDefaultMaterial:j,czm_getLambertDiffuse:Y,czm_getSpecular:X,czm_getWaterNoise:Z,czm_getWgs84EllipsoidEC:K,czm_hue:Q,czm_isEmpty:J,czm_isFull:$,czm_latitudeToWebMercatorFraction:ee,czm_luminance:te,czm_metersPerPixel:re,czm_modelToWindowCoordinates:ie,czm_multiplyWithColorBalance:ne,czm_nearFarScalar:oe,czm_octDecode:ae,czm_packDepth:se,czm_phong:ue,czm_pointAlongRay:le,czm_rayEllipsoidIntersectionInterval:ce,czm_RGBToXYZ:he,czm_saturation:de,czm_signNotZero:me,czm_tangentToEyeSpaceMatrix:pe,czm_translateRelativeToEye:fe,czm_translucentPhong:ve,czm_transpose:ge,czm_unpackDepth:_e,czm_windowToEyeCoordinates:ye,czm_XYZToRGB:we}}),r("Renderer/ShaderSource",["../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Shaders/Builtin/CzmBuiltins","./AutomaticUniforms"],function(e,t,r,i,n){"use strict";function o(e){return e=e.replace(/\/\/.*/g,""),e.replace(/\/\*\*[\s\S]*?\*\//gm,function(e){for(var t=e.match(/\n/gm).length,r="",i=0;t>i;++i)r+="\n";return r})}function a(e,r,i){for(var n,a=0;a<i.length;++a)i[a].name===e&&(n=i[a]);return t(n)||(r=o(r),n={name:e,glslSource:r,dependsOn:[],requiredBy:[],evaluated:!1},i.push(n)),n}function s(e,r){if(!e.evaluated){e.evaluated=!0;var i=e.glslSource.match(/\bczm_[a-zA-Z0-9_]*/g);t(i)&&null!==i&&(i=i.filter(function(e,t){return i.indexOf(e)===t}),i.forEach(function(t){if(t!==e.name&&h._czmBuiltinsAndUniforms.hasOwnProperty(t)){var i=a(t,h._czmBuiltinsAndUniforms[t],r);e.dependsOn.push(i),i.requiredBy.push(e),s(i,r)}}))}}function u(e){for(var t=[],i=[];e.length>0;){var n=e.pop();i.push(n),0===n.requiredBy.length&&t.push(n)}for(;t.length>0;){var o=t.shift();e.push(o);for(var a=0;a<o.dependsOn.length;++a){var s=o.dependsOn[a],u=s.requiredBy.indexOf(o);s.requiredBy.splice(u,1),0===s.requiredBy.length&&t.push(s)}}for(var l=[],c=0;c<i.length;++c)0!==i[c].requiredBy.length&&l.push(i[c]);if(0!==l.length){var h="A circular dependency was found in the following built-in functions/structs/constants: \n";for(c=0;c<l.length;++c)h=h+l[c].name+"\n";throw new r(h)}}function l(e){var t=[],r=a("main",e,t);s(r,t),u(t);for(var i="",n=t.length-1;n>=0;--n)i=i+t[n].glslSource+"\n";return i.replace(r.glslSource,"")}function c(e,i){var n,a,s="",u=e.sources;if(t(u))for(n=0,a=u.length;a>n;++n)s+="\n#line 0\n"+u[n];s=o(s);var c;s=s.replace(/#version\s+(.*?)\n/gm,function(e,i){if(t(c)&&c!==i)throw new r("inconsistent versions found: "+c+" and "+i);return c=i,"\n"}),s=s.replace(/precision\s(lowp|mediump|highp)\s(float|int);/,"");var d=e.pickColorQualifier;t(d)&&(s=h.createPickFragmentShaderSource(s,d));var m="";t(c)&&(m="#version "+c),i&&(m+="#ifdef GL_FRAGMENT_PRECISION_HIGH\n    precision highp float;\n#else\n    precision mediump float;\n#endif\n\n");var p=e.defines;if(t(p))for(n=0,a=p.length;a>n;++n){var f=p[n];0!==f.length&&(m+="#define "+f+"\n")}return e.includeBuiltIns&&(m+=l(s)),m+="\n#line 0\n",m+=s}var h=function(i){i=e(i,e.EMPTY_OBJECT);var n=i.pickColorQualifier;if(t(n)&&"uniform"!==n&&"varying"!==n)throw new r("options.pickColorQualifier must be 'uniform' or 'varying'.");this.defines=t(i.defines)?i.defines.slice(0):[],this.sources=t(i.sources)?i.sources.slice(0):[],this.pickColorQualifier=n,this.includeBuiltIns=e(i.includeBuiltIns,!0)};h.prototype.clone=function(){return new h({sources:this.sources,defines:this.defines,pickColorQuantifier:this.pickColorQualifier,includeBuiltIns:this.includeBuiltIns})},h.replaceMain=function(e,t){return t="void "+t+"()",e.replace(/void\s+main\s*\(\s*(?:void)?\s*\)/g,t)},h.prototype.createCombinedVertexShader=function(){return c(this,!1)},h.prototype.createCombinedFragmentShader=function(){return c(this,!0)},h._czmBuiltinsAndUniforms={};for(var d in i)i.hasOwnProperty(d)&&(h._czmBuiltinsAndUniforms[d]=i[d]);for(var m in n)if(n.hasOwnProperty(m)){var p=n[m];"function"==typeof p.getDeclaration&&(h._czmBuiltinsAndUniforms[m]=p.getDeclaration(m))}return h.createPickVertexShaderSource=function(e){var t=h.replaceMain(e,"czm_old_main"),r="attribute vec4 pickColor; \nvarying vec4 czm_pickColor; \nvoid main() \n{ \n    czm_old_main(); \n    czm_pickColor = pickColor; \n}";return t+"\n"+r},h.createPickFragmentShaderSource=function(e,t){var r=h.replaceMain(e,"czm_old_main"),i=t+" vec4 czm_pickColor; \nvoid main() \n{ \n    czm_old_main(); \n    if (gl_FragColor.a == 0.0) { \n       discard; \n    } \n    gl_FragColor = czm_pickColor; \n}";return r+"\n"+i},h}),r("Renderer/VertexArray",["../Core/ComponentDatatype","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Geometry","../Core/IndexDatatype","../Core/Math","../Core/RuntimeError","./Buffer","./BufferUsage","./ContextLimits"],function(e,t,r,i,n,o,a,s,u,l,c,h,d){"use strict";function m(i,n,a,s){var u=r(n.vertexBuffer),l=r(n.value),c=n.value?n.value.length:n.componentsPerAttribute;if(!u&&!l)throw new o("attribute must have a vertexBuffer or a value.");if(u&&l)throw new o("attribute cannot have both a vertexBuffer and a value.  It must have either a vertexBuffer property defining per-vertex data or a value property defining data for all vertices.");if(1!==c&&2!==c&&3!==c&&4!==c){if(l)throw new o("attribute.value.length must be in the range [1, 4].");throw new o("attribute.componentsPerAttribute must be in the range [1, 4].")}if(r(n.componentDatatype)&&!e.validate(n.componentDatatype))throw new o("attribute must have a valid componentDatatype or not specify it.");if(r(n.strideInBytes)&&n.strideInBytes>255)throw new o("attribute must have a strideInBytes less than or equal to 255 or not specify it.");if(r(n.instanceDivisor)&&n.instanceDivisor>0&&!s.instancedArrays)throw new o("instanced arrays is not supported");if(r(n.instanceDivisor)&&n.instanceDivisor<0)throw new o("attribute must have an instanceDivisor greater than or equal to zero");if(r(n.instanceDivisor)&&l)throw new o("attribute cannot have have an instanceDivisor if it is not backed by a buffer");if(r(n.instanceDivisor)&&n.instanceDivisor>0&&0===n.index)throw new o("attribute zero cannot have an instanceDivisor greater than 0");var h={index:t(n.index,a),enabled:t(n.enabled,!0),vertexBuffer:n.vertexBuffer,value:l?n.value.slice(0):void 0,componentsPerAttribute:c,componentDatatype:t(n.componentDatatype,e.FLOAT),normalize:t(n.normalize,!1),offsetInBytes:t(n.offsetInBytes,0),strideInBytes:t(n.strideInBytes,0),instanceDivisor:t(n.instanceDivisor,0)};if(u)h.vertexAttrib=function(e){var t=this.index;e.bindBuffer(e.ARRAY_BUFFER,this.vertexBuffer._getBuffer()),e.vertexAttribPointer(t,this.componentsPerAttribute,this.componentDatatype,this.normalize,this.strideInBytes,this.offsetInBytes),e.enableVertexAttribArray(t),this.instanceDivisor>0&&(s.glVertexAttribDivisor(t,this.instanceDivisor),s._vertexAttribDivisors[t]=this.instanceDivisor,s._previousDrawInstanced=!0)},h.disableVertexAttribArray=function(e){e.disableVertexAttribArray(this.index),this.instanceDivisor>0&&s.glVertexAttribDivisor(a,0)};else{switch(h.componentsPerAttribute){case 1:h.vertexAttrib=function(e){e.vertexAttrib1fv(this.index,this.value)};break;case 2:h.vertexAttrib=function(e){e.vertexAttrib2fv(this.index,this.value)};break;case 3:h.vertexAttrib=function(e){e.vertexAttrib3fv(this.index,this.value)};break;case 4:h.vertexAttrib=function(e){e.vertexAttrib4fv(this.index,this.value)}}h.disableVertexAttribArray=function(e){}}i.push(h)}function p(e,t,i){for(var n=0;n<t.length;++n){var o=t[n];o.enabled&&o.vertexAttrib(e)}r(i)&&e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,i._getBuffer())}function f(e){return e.values.length/e.componentsPerAttribute}function v(t){return e.getSizeInBytes(t.componentDatatype)*t.componentsPerAttribute}function g(t){var i,n,o,a=[];for(n in t)t.hasOwnProperty(n)&&r(t[n])&&r(t[n].values)&&(a.push(n),t[n].componentDatatype===e.DOUBLE&&(t[n].componentDatatype=e.FLOAT,t[n].values=e.createTypedArray(e.FLOAT,t[n].values)));var s,u=a.length;if(u>0)for(s=f(t[a[0]]),i=1;u>i;++i){var c=f(t[a[i]]);if(c!==s)throw new l("Each attribute list must have the same number of vertices.  Attribute "+a[i]+" has a different number of vertices ("+c.toString()+") than attribute "+a[0]+" ("+s.toString()+").")}a.sort(function(r,i){return e.getSizeInBytes(t[i].componentDatatype)-e.getSizeInBytes(t[r].componentDatatype)});var h=0,d={};for(i=0;u>i;++i)n=a[i],o=t[n],d[n]=h,h+=v(o);if(h>0){var m=e.getSizeInBytes(t[a[0]].componentDatatype),p=h%m;0!==p&&(h+=m-p);var g=s*h,_=new ArrayBuffer(g),y={};for(i=0;u>i;++i){n=a[i];var w=e.getSizeInBytes(t[n].componentDatatype);y[n]={pointer:e.createTypedArray(t[n].componentDatatype,_),index:d[n]/w,strideInComponentType:h/w}}for(i=0;s>i;++i)for(var C=0;u>C;++C){n=a[C],o=t[n];for(var E=o.values,S=y[n],b=S.pointer,T=o.componentsPerAttribute,x=0;T>x;++x)b[S.index+x]=E[i*T+x];S.index+=S.strideInComponentType}return{buffer:_,offsetsInBytes:d,vertexSizeInBytes:h}}return void 0}function _(e){var t=e._context,r=e._hasInstancedAttributes;if(r||t._previousDrawInstanced){t._previousDrawInstanced=r;var i,n=t._vertexAttribDivisors,o=e._attributes,a=d.maximumVertexAttributes;if(r){var s=o.length;for(i=0;s>i;++i){var u=o[i];if(u.enabled){var l=u.instanceDivisor,c=u.index;l!==n[c]&&(t.glVertexAttribDivisor(c,l),n[c]=l)}}}else for(i=0;a>i;++i)n[i]>0&&(t.glVertexAttribDivisor(i,0),n[i]=0)}}var y=function(i){if(i=t(i,t.EMPTY_OBJECT),!r(i.context))throw new o("options.context is required.");if(!r(i.attributes))throw new o("options.attributes is required.");var n,a=i.context,s=a._gl,u=i.attributes,l=i.indexBuffer,c=[],h=1,d=!1,f=u.length;for(n=0;f>n;++n)m(c,u[n],n,a);for(f=c.length,n=0;f>n;++n){var v=c[n];if(r(v.vertexBuffer)&&0===v.instanceDivisor){var g=v.strideInBytes||v.componentsPerAttribute*e.getSizeInBytes(v.componentDatatype);h=v.vertexBuffer.sizeInBytes/g;break}}for(n=0;f>n;++n)if(c[n].instanceDivisor>0){d=!0;break}var _={};for(n=0;f>n;++n){var y=c[n].index;if(_[y])throw new o("Index "+y+" is used by more than one attribute.");_[y]=!0}var w;a.vertexArrayObject&&(w=a.glCreateVertexArray(),a.glBindVertexArray(w),p(s,c,l),a.glBindVertexArray(null)),this._numberOfVertices=h,this._hasInstancedAttributes=d,this._context=a,this._gl=s,this._vao=w,this._attributes=c,this._indexBuffer=l};return y.fromGeometry=function(i){if(i=t(i,t.EMPTY_OBJECT),!r(i.context))throw new o("options.context is required.");var n,l,d,m=i.context,p=t(i.geometry,t.EMPTY_OBJECT),f=t(i.bufferUsage,h.DYNAMIC_DRAW),v=t(i.attributeLocations,t.EMPTY_OBJECT),_=t(i.interleave,!1),w=i.vertexArrayAttributes,C=r(w)?w:[],E=p.attributes;if(_){var S=g(E);if(r(S)){d=c.createVertexBuffer({context:m,typedArray:S.buffer,usage:f});var b=S.offsetsInBytes,T=S.vertexSizeInBytes;for(n in E)E.hasOwnProperty(n)&&r(E[n])&&(l=E[n],r(l.values)?C.push({index:v[n],vertexBuffer:d,componentDatatype:l.componentDatatype,componentsPerAttribute:l.componentsPerAttribute,normalize:l.normalize,offsetInBytes:b[n],strideInBytes:T}):C.push({index:v[n],value:l.value,componentDatatype:l.componentDatatype,normalize:l.normalize}))}}else for(n in E)if(E.hasOwnProperty(n)&&r(E[n])){l=E[n];var x=l.componentDatatype;x===e.DOUBLE&&(x=e.FLOAT),d=void 0,r(l.values)&&(d=c.createVertexBuffer({context:m,typedArray:e.createTypedArray(x,l.values),usage:f})),C.push({index:v[n],vertexBuffer:d,value:l.value,componentDatatype:x,componentsPerAttribute:l.componentsPerAttribute,normalize:l.normalize})}var P,A=p.indices;return r(A)&&(P=a.computeNumberOfVertices(p)>=u.SIXTY_FOUR_KILOBYTES&&m.elementIndexUint?c.createIndexBuffer({context:m,typedArray:new Uint32Array(A),usage:f,indexDatatype:s.UNSIGNED_INT}):c.createIndexBuffer({context:m,typedArray:new Uint16Array(A),usage:f,indexDatatype:s.UNSIGNED_SHORT})),new y({context:m,attributes:C,indexBuffer:P})},i(y.prototype,{numberOfAttributes:{get:function(){return this._attributes.length}},numberOfVertices:{get:function(){return this._numberOfVertices}},indexBuffer:{get:function(){return this._indexBuffer}}}),y.prototype.getAttribute=function(e){if(!r(e))throw new o("index is required.");return this._attributes[e]},y.prototype._bind=function(){r(this._vao)?(this._context.glBindVertexArray(this._vao),this._context.instancedArrays&&_(this)):p(this._gl,this._attributes,this._indexBuffer)},y.prototype._unBind=function(){if(r(this._vao))this._context.glBindVertexArray(null);else{for(var e=this._attributes,t=this._gl,i=0;i<e.length;++i){var n=e[i];n.enabled&&n.disableVertexAttribArray(t)}this._indexBuffer&&t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,null)}},y.prototype.isDestroyed=function(){return!1},y.prototype.destroy=function(){for(var e=this._attributes,t=0;t<e.length;++t){var i=e[t].vertexBuffer;r(i)&&!i.isDestroyed()&&i.vertexArrayDestroyable&&i.destroy()}var o=this._indexBuffer;return r(o)&&!o.isDestroyed()&&o.vertexArrayDestroyable&&o.destroy(),r(this._vao)&&this._context.glDeleteVertexArray(this._vao),n(this)},y}),r("Renderer/VertexArrayFacade",["../Core/ComponentDatatype","../Core/defaultValue","../Core/defined","../Core/destroyObject","../Core/DeveloperError","../Core/Math","./Buffer","./BufferUsage","./VertexArray"],function(e,t,r,i,n,o,a,s,u){"use strict";function l(e,t){if(t.needsCommit&&t.vertexSizeInBytes>0){t.needsCommit=!1;var i=t.vertexBuffer,n=e._size*t.vertexSizeInBytes,o=r(i);if(!o||i.sizeInBytes<n)return o&&i.destroy(),t.vertexBuffer=a.createVertexBuffer({context:e._context,typedArray:t.arrayBuffer,usage:t.usage}),t.vertexBuffer.vertexArrayDestroyable=!1,!0;t.vertexBuffer.copyFromArrayView(t.arrayBuffer)}return!1}function c(e,t,r){if(e.needsCommit&&e.vertexSizeInBytes>0){var i=e.vertexSizeInBytes*t,n=e.vertexSizeInBytes*r;e.vertexBuffer.copyFromArrayView(new Uint8Array(e.arrayBuffer,i,n),i)}}function h(e){var t=e.va;if(r(t)){for(var i=t.length,n=0;i>n;++n)t[n].va.destroy();e.va=void 0}}var d=function(i,o,a,s){function u(t,r){return e.getSizeInBytes(r.componentDatatype)-e.getSizeInBytes(t.componentDatatype)}if(!i)throw new n("context is required.");if(!o||0===o.length)throw new n("At least one attribute is required.");var l=d._verifyAttributes(o);a=t(a,0);for(var c,h,m=[],p={},f=l.length,v=0;f>v;++v){var g=l[v];g.vertexBuffer?m.push(g):(h=g.usage,c=p[h],r(c)||(c=p[h]=[]),c.push(g))}this._allBuffers=[];for(h in p)if(p.hasOwnProperty(h)){c=p[h],c.sort(u);var _=d._vertexSizeInBytes(c),y=c[0].usage,w={vertexSizeInBytes:_,vertexBuffer:void 0,usage:y,needsCommit:!1,arrayBuffer:void 0,arrayViews:d._createArrayViews(c,_)};this._allBuffers.push(w)}this._size=0,this._instanced=t(s,!1),this._precreated=m,this._context=i,this.writers=void 0,this.va=void 0,this.resize(a)};d._verifyAttributes=function(r){for(var i=[],o=0;o<r.length;++o){var a=r[o],u={index:t(a.index,o),enabled:t(a.enabled,!0),componentsPerAttribute:a.componentsPerAttribute,componentDatatype:t(a.componentDatatype,e.FLOAT),normalize:t(a.normalize,!1),vertexBuffer:a.vertexBuffer,usage:t(a.usage,s.STATIC_DRAW)};if(i.push(u),1!==u.componentsPerAttribute&&2!==u.componentsPerAttribute&&3!==u.componentsPerAttribute&&4!==u.componentsPerAttribute)throw new n("attribute.componentsPerAttribute must be in the range [1, 4].");var l=u.componentDatatype;if(!e.validate(l))throw new n("Attribute must have a valid componentDatatype or not specify it.");if(!s.validate(u.usage))throw new n("Attribute must have a valid usage or not specify it.")}for(var c=new Array(i.length),h=0;h<i.length;++h){var d=i[h],m=d.index;if(c[m])throw new n("Index "+m+" is used by more than one attribute.");c[m]=!0}return i},d._vertexSizeInBytes=function(t){for(var r=0,i=t.length,n=0;i>n;++n){var o=t[n];r+=o.componentsPerAttribute*e.getSizeInBytes(o.componentDatatype)}var a=i>0?e.getSizeInBytes(t[0].componentDatatype):0,s=a>0?r%a:0,u=0===s?0:a-s;return r+=u},d._createArrayViews=function(t,r){for(var i=[],n=0,o=t.length,a=0;o>a;++a){var s=t[a],u=s.componentDatatype;i.push({index:s.index,enabled:s.enabled,componentsPerAttribute:s.componentsPerAttribute,componentDatatype:u,normalize:s.normalize,offsetInBytes:n,vertexSizeInComponentType:r/e.getSizeInBytes(u),view:void 0}),n+=s.componentsPerAttribute*e.getSizeInBytes(u)}return i},d.prototype.resize=function(e){this._size=e;var t=this._allBuffers;this.writers=[];for(var r=0,i=t.length;i>r;++r){var n=t[r];d._resize(n,this._size),d._appendWriters(this.writers,n)}h(this)},d._resize=function(t,i){if(t.vertexSizeInBytes>0){var n=new ArrayBuffer(i*t.vertexSizeInBytes);if(r(t.arrayBuffer))for(var o=new Uint8Array(n),a=new Uint8Array(t.arrayBuffer),s=a.length,u=0;s>u;++u)o[u]=a[u];for(var l=t.arrayViews,c=l.length,h=0;c>h;++h){var d=l[h];d.view=e.createArrayBufferView(d.componentDatatype,n,d.offsetInBytes)}t.arrayBuffer=n}};var m=[function(e,t,r){return function(i,n){t[i*r]=n,e.needsCommit=!0}},function(e,t,r){return function(i,n,o){var a=i*r;t[a]=n,t[a+1]=o,e.needsCommit=!0}},function(e,t,r){return function(i,n,o,a){var s=i*r;t[s]=n,t[s+1]=o,t[s+2]=a,e.needsCommit=!0}},function(e,t,r){return function(i,n,o,a,s){var u=i*r;t[u]=n,t[u+1]=o,t[u+2]=a,t[u+3]=s,e.needsCommit=!0}}];return d._appendWriters=function(e,t){for(var r=t.arrayViews,i=r.length,n=0;i>n;++n){var o=r[n];e[o.index]=m[o.componentsPerAttribute-1](t,o.view,o.vertexSizeInComponentType)}},d.prototype.commit=function(e){var t,i,n,a=!1,s=this._allBuffers;for(i=0,n=s.length;n>i;++i)t=s[i],a=l(this,t)||a;if(a||!r(this.va)){h(this);for(var c=this.va=[],m=r(e)?Math.ceil(this._size/(o.SIXTY_FOUR_KILOBYTES-1)):1,p=0;m>p;++p){var f=[];for(i=0,n=s.length;n>i;++i){t=s[i];var v=p*t.vertexSizeInBytes*(o.SIXTY_FOUR_KILOBYTES-1);d._appendAttributes(f,t,v,this._instanced)}f=f.concat(this._precreated),c.push({va:new u({context:this._context,attributes:f,indexBuffer:e}),indicesCount:1.5*(p!==m-1?o.SIXTY_FOUR_KILOBYTES-1:this._size%(o.SIXTY_FOUR_KILOBYTES-1))})}}},d._appendAttributes=function(e,t,r,i){for(var n=t.arrayViews,o=n.length,a=0;o>a;++a){var s=n[a];e.push({index:s.index,enabled:s.enabled,componentsPerAttribute:s.componentsPerAttribute,componentDatatype:s.componentDatatype,normalize:s.normalize,vertexBuffer:t.vertexBuffer,offsetInBytes:r+s.offsetInBytes,strideInBytes:t.vertexSizeInBytes,instanceDivisor:i?1:0})}},d.prototype.subCommit=function(e,t){if(0>e||e>=this._size)throw new n("offsetInVertices must be greater than or equal to zero and less than the vertex array size.");if(e+t>this._size)throw new n("offsetInVertices + lengthInVertices cannot exceed the vertex array size.");for(var r=this._allBuffers,i=0,o=r.length;o>i;++i)c(r[i],e,t)},d.prototype.endSubCommits=function(){for(var e=this._allBuffers,t=0,r=e.length;r>t;++t)e[t].needsCommit=!1},d.prototype.isDestroyed=function(){return!1},d.prototype.destroy=function(){for(var e=this._allBuffers,t=0,r=e.length;r>t;++t){var n=e[t];n.vertexBuffer=n.vertexBuffer&&n.vertexBuffer.destroy()}return h(this),i(this)},d}),r("Shaders/BillboardCollectionFS",[],function(){"use strict";return"uniform sampler2D u_atlas;\nvarying vec2 v_textureCoordinates;\n#ifdef RENDER_FOR_PICK\nvarying vec4 v_pickColor;\n#else\nvarying vec4 v_color;\n#endif\nvoid main()\n{\n#ifdef RENDER_FOR_PICK\nvec4 vertexColor = vec4(1.0, 1.0, 1.0, 1.0);\n#else\nvec4 vertexColor = v_color;\n#endif\nvec4 color = texture2D(u_atlas, v_textureCoordinates) * vertexColor;\nif (color.a == 0.0)\n{\ndiscard;\n}\n#ifdef RENDER_FOR_PICK\ngl_FragColor = v_pickColor;\n#else\ngl_FragColor = color;\n#endif\n}\n"}),r("Shaders/BillboardCollectionVS",[],function(){"use strict";return"#ifdef INSTANCED\nattribute vec2 direction;\n#endif\nattribute vec4 positionHighAndScale;\nattribute vec4 positionLowAndRotation;\nattribute vec4 compressedAttribute0;\nattribute vec4 compressedAttribute1;\nattribute vec4 compressedAttribute2;\nattribute vec4 eyeOffset;\nattribute vec4 scaleByDistance;\nattribute vec4 pixelOffsetScaleByDistance;\nvarying vec2 v_textureCoordinates;\n#ifdef RENDER_FOR_PICK\nvarying vec4 v_pickColor;\n#else\nvarying vec4 v_color;\n#endif\nconst float UPPER_BOUND = 32768.0;\nconst float SHIFT_LEFT16 = 65536.0;\nconst float SHIFT_LEFT8 = 256.0;\nconst float SHIFT_LEFT7 = 128.0;\nconst float SHIFT_LEFT5 = 32.0;\nconst float SHIFT_LEFT3 = 8.0;\nconst float SHIFT_LEFT2 = 4.0;\nconst float SHIFT_LEFT1 = 2.0;\nconst float SHIFT_RIGHT8 = 1.0 / 256.0;\nconst float SHIFT_RIGHT7 = 1.0 / 128.0;\nconst float SHIFT_RIGHT5 = 1.0 / 32.0;\nconst float SHIFT_RIGHT3 = 1.0 / 8.0;\nconst float SHIFT_RIGHT2 = 1.0 / 4.0;\nconst float SHIFT_RIGHT1 = 1.0 / 2.0;\nvec4 computePositionWindowCoordinates(vec4 positionEC, vec2 imageSize, float scale, vec2 direction, vec2 origin, vec2 translate, vec2 pixelOffset, vec3 alignedAxis, float rotation, bool sizeInMeters)\n{\nvec2 halfSize = imageSize * scale * czm_resolutionScale;\nhalfSize *= ((direction * 2.0) - 1.0);\nif (sizeInMeters)\n{\npositionEC.xy += halfSize;\n}\nvec4 positionWC = czm_eyeToWindowCoordinates(positionEC);\nif (sizeInMeters)\n{\npositionWC.xy += (origin * abs(halfSize)) / czm_metersPerPixel(positionEC);\n}\nelse\n{\npositionWC.xy += (origin * abs(halfSize));\n}\n#if defined(ROTATION) || defined(ALIGNED_AXIS)\nif (!all(equal(alignedAxis, vec3(0.0))) || rotation != 0.0)\n{\nfloat angle = rotation;\nif (!all(equal(alignedAxis, vec3(0.0))))\n{\nvec3 pos = positionEC.xyz + czm_encodedCameraPositionMCHigh + czm_encodedCameraPositionMCLow;\nvec3 normal = normalize(cross(alignedAxis, pos));\nvec4 tangent = vec4(normalize(cross(pos, normal)), 0.0);\ntangent = czm_modelViewProjection * tangent;\nangle += sign(-tangent.x) * acos(tangent.y / length(tangent.xy));\n}\nfloat cosTheta = cos(angle);\nfloat sinTheta = sin(angle);\nmat2 rotationMatrix = mat2(cosTheta, sinTheta, -sinTheta, cosTheta);\nhalfSize = rotationMatrix * halfSize;\n}\n#endif\nif (!sizeInMeters)\n{\npositionWC.xy += halfSize;\n}\npositionWC.xy += translate;\npositionWC.xy += (pixelOffset * czm_resolutionScale);\nreturn positionWC;\n}\nvoid main()\n{\nvec3 positionHigh = positionHighAndScale.xyz;\nvec3 positionLow = positionLowAndRotation.xyz;\nfloat scale = positionHighAndScale.w;\n#if defined(ROTATION) || defined(ALIGNED_AXIS)\nfloat rotation = positionLowAndRotation.w;\n#else\nfloat rotation = 0.0;\n#endif\nfloat compressed = compressedAttribute0.x;\nvec2 pixelOffset;\npixelOffset.x = floor(compressed * SHIFT_RIGHT7);\ncompressed -= pixelOffset.x * SHIFT_LEFT7;\npixelOffset.x -= UPPER_BOUND;\nvec2 origin;\norigin.x = floor(compressed * SHIFT_RIGHT5);\ncompressed -= origin.x * SHIFT_LEFT5;\norigin.y = floor(compressed * SHIFT_RIGHT3);\ncompressed -= origin.y * SHIFT_LEFT3;\norigin -= vec2(1.0);\nfloat show = floor(compressed * SHIFT_RIGHT2);\ncompressed -= show * SHIFT_LEFT2;\n#ifdef INSTANCED\nvec2 textureCoordinatesBottomLeft = czm_decompressTextureCoordinates(compressedAttribute0.w);\nvec2 textureCoordinatesRange = czm_decompressTextureCoordinates(eyeOffset.w);\nvec2 textureCoordinates = textureCoordinatesBottomLeft + direction * textureCoordinatesRange;\n#else\nvec2 direction;\ndirection.x = floor(compressed * SHIFT_RIGHT1);\ndirection.y = compressed - direction.x * SHIFT_LEFT1;\nvec2 textureCoordinates = czm_decompressTextureCoordinates(compressedAttribute0.w);\n#endif\nfloat temp = compressedAttribute0.y  * SHIFT_RIGHT8;\npixelOffset.y = -(floor(temp) - UPPER_BOUND);\nvec2 translate;\ntranslate.y = (temp - floor(temp)) * SHIFT_LEFT16;\ntemp = compressedAttribute0.z * SHIFT_RIGHT8;\ntranslate.x = floor(temp) - UPPER_BOUND;\ntranslate.y += (temp - floor(temp)) * SHIFT_LEFT8;\ntranslate.y -= UPPER_BOUND;\ntemp = compressedAttribute1.x * SHIFT_RIGHT8;\nvec2 imageSize = vec2(floor(temp), compressedAttribute2.w);\n#ifdef EYE_DISTANCE_TRANSLUCENCY\nvec4 translucencyByDistance;\ntranslucencyByDistance.x = compressedAttribute1.z;\ntranslucencyByDistance.z = compressedAttribute1.w;\ntranslucencyByDistance.y = ((temp - floor(temp)) * SHIFT_LEFT8) / 255.0;\ntemp = compressedAttribute1.y * SHIFT_RIGHT8;\ntranslucencyByDistance.w = ((temp - floor(temp)) * SHIFT_LEFT8) / 255.0;\n#endif\n#ifdef ALIGNED_AXIS\nvec3 alignedAxis = czm_octDecode(floor(compressedAttribute1.y * SHIFT_RIGHT8));\n#else\nvec3 alignedAxis = vec3(0.0);\n#endif\n#ifdef RENDER_FOR_PICK\ntemp = compressedAttribute2.y;\n#else\ntemp = compressedAttribute2.x;\n#endif\nvec4 color;\ntemp = temp * SHIFT_RIGHT8;\ncolor.b = (temp - floor(temp)) * SHIFT_LEFT8;\ntemp = floor(temp) * SHIFT_RIGHT8;\ncolor.g = (temp - floor(temp)) * SHIFT_LEFT8;\ncolor.r = floor(temp);\ntemp = compressedAttribute2.z * SHIFT_RIGHT8;\nbool sizeInMeters = (temp - floor(temp)) * SHIFT_LEFT8 > 0.0;\ntemp = floor(temp) * SHIFT_RIGHT8;\n#ifdef RENDER_FOR_PICK\ncolor.a = (temp - floor(temp)) * SHIFT_LEFT8;\nvec4 pickColor = color / 255.0;\n#else\ncolor.a = floor(temp);\ncolor /= 255.0;\n#endif\nvec4 p = czm_translateRelativeToEye(positionHigh, positionLow);\nvec4 positionEC = czm_modelViewRelativeToEye * p;\npositionEC = czm_eyeOffset(positionEC, eyeOffset.xyz);\npositionEC.xyz *= show;\n#if defined(EYE_DISTANCE_SCALING) || defined(EYE_DISTANCE_TRANSLUCENCY) || defined(EYE_DISTANCE_PIXEL_OFFSET)\nfloat lengthSq;\nif (czm_sceneMode == czm_sceneMode2D)\n{\nlengthSq = czm_eyeHeight2D.y;\n}\nelse\n{\nlengthSq = dot(positionEC.xyz, positionEC.xyz);\n}\n#endif\n#ifdef EYE_DISTANCE_SCALING\nscale *= czm_nearFarScalar(scaleByDistance, lengthSq);\nif (scale == 0.0)\n{\npositionEC.xyz = vec3(0.0);\n}\n#endif\nfloat translucency = 1.0;\n#ifdef EYE_DISTANCE_TRANSLUCENCY\ntranslucency = czm_nearFarScalar(translucencyByDistance, lengthSq);\nif (translucency == 0.0)\n{\npositionEC.xyz = vec3(0.0);\n}\n#endif\n#ifdef EYE_DISTANCE_PIXEL_OFFSET\nfloat pixelOffsetScale = czm_nearFarScalar(pixelOffsetScaleByDistance, lengthSq);\npixelOffset *= pixelOffsetScale;\n#endif\n#ifdef CLAMPED_TO_GROUND\npositionEC.z *= 0.995;\norigin.y = 1.0;\n#endif\nvec4 positionWC = computePositionWindowCoordinates(positionEC, imageSize, scale, direction, origin, translate, pixelOffset, alignedAxis, rotation, sizeInMeters);\ngl_Position = czm_viewportOrthographic * vec4(positionWC.xy, -positionWC.z, 1.0);\nv_textureCoordinates = textureCoordinates;\n#ifdef RENDER_FOR_PICK\nv_pickColor = pickColor;\n#else\nv_color = color;\nv_color.a *= translucency;\n#endif\n}\n"}),r("Scene/HeightReference",["../Core/freezeObject"],function(e){"use strict";var t={NONE:0,CLAMP_TO_GROUND:1,RELATIVE_TO_GROUND:2};return e(t)}),r("Scene/HorizontalOrigin",["../Core/freezeObject"],function(e){"use strict";var t={CENTER:0,LEFT:1,RIGHT:-1};return e(t)}),r("Scene/SceneMode",["../Core/freezeObject"],function(e){"use strict";var t={MORPHING:0,COLUMBUS_VIEW:1,SCENE2D:2,SCENE3D:3};return t.getMorphTime=function(e){return e===t.SCENE3D?1:e===t.MORPHING?void 0:0},e(t)}),r("Scene/SceneTransforms",["../Core/BoundingRectangle","../Core/Cartesian2","../Core/Cartesian3","../Core/Cartesian4","../Core/Cartographic","../Core/defined","../Core/DeveloperError","../Core/Math","../Core/Matrix4","./SceneMode"],function(e,t,r,i,n,o,a,s,u,l){"use strict";var c={},h=new i(0,0,0,1),d=new i,m=new u;c.wgs84ToWindowCoordinates=function(e,t,r){if(!o(e))throw new a("scene is required.");if(!o(t))throw new a("position is required.");var n=c.computeActualWgs84Position(e.frameState,t,h);if(!o(n))return void 0;var s=e.camera,p=u.multiply(s.frustum.projectionMatrix,s.viewMatrix,m);return u.multiplyByVector(p,i.fromElements(n.x,n.y,n.z,1,d),d),d.z<0&&e.mode!==l.SCENE2D?void 0:(r=c.clipToGLWindowCoordinates(e,d,r),r.y=e.canvas.clientHeight-r.y,r)},c.wgs84ToDrawingBufferCoordinates=function(e,t,r){if(!o(e))throw new a("scene is required.");if(!o(t))throw new a("position is required.");var n=c.computeActualWgs84Position(e.frameState,t,h);if(!o(n))return void 0;var s=e.camera,p=u.multiply(s.frustum.projectionMatrix,s.viewMatrix,m);return u.multiplyByVector(p,i.fromElements(n.x,n.y,n.z,1,d),d),d.z<0&&e.mode!==l.SCENE2D?void 0:c.clipToDrawingBufferCoordinates(e,d,r);
};var p=new r,f=new n;c.computeActualWgs84Position=function(e,t,i){var n=e.mode;if(n===l.SCENE3D)return r.clone(t,i);var a=e.mapProjection,u=a.ellipsoid.cartesianToCartographic(t,f);if(!o(u))return void 0;if(a.project(u,p),n===l.COLUMBUS_VIEW)return r.fromElements(p.z,p.x,p.y,i);if(n===l.SCENE2D)return r.fromElements(0,p.x,p.y,i);var c=e.morphTime;return r.fromElements(s.lerp(p.z,t.x,c),s.lerp(p.x,t.y,c),s.lerp(p.y,t.z,c),i)};var v=new r,g=new r,_=new e,y=new u;c.clipToGLWindowCoordinates=function(e,i,n){var o=e.canvas;return r.divideByScalar(i,i.w,v),_.width=o.clientWidth,_.height=o.clientHeight,u.computeViewportTransformation(_,0,1,y),u.multiplyByPoint(y,v,g),t.fromCartesian3(g,n)},c.clipToDrawingBufferCoordinates=function(e,i,n){return r.divideByScalar(i,i.w,v),_.width=e.drawingBufferWidth,_.height=e.drawingBufferHeight,u.computeViewportTransformation(_,0,1,y),u.multiplyByPoint(y,v,g),t.fromCartesian3(g,n)},c.transformWindowToDrawingBuffer=function(e,r,i){var n=e.canvas,o=e.drawingBufferWidth/n.clientWidth,a=e.drawingBufferHeight/n.clientHeight;return t.fromElements(r.x*o,r.y*a,i)};var w=new i,C=new i;return c.drawingBufferToWgs84Coordinates=function(e,t,n,o){var a=e.context,s=a.uniformState,l=s.viewport,c=(s.viewportTransformation,i.clone(i.UNIT_W,w));c.x=(t.x-l.x)/l.width*2-1,c.y=(t.y-l.y)/l.height*2-1,c.z=2*n-1,c.w=1;var h=u.multiplyByVector(s.inverseViewProjection,c,C),d=1/h.w;return r.multiplyByScalar(h,d,h),r.fromCartesian4(h,o)},c}),r("Scene/VerticalOrigin",["../Core/freezeObject"],function(e){"use strict";var t={CENTER:0,BOTTOM:1,TOP:-1};return e(t)}),r("Scene/Billboard",["../Core/BoundingRectangle","../Core/Cartesian2","../Core/Cartesian3","../Core/Cartesian4","../Core/Cartographic","../Core/Color","../Core/createGuid","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Matrix4","../Core/NearFarScalar","./HeightReference","./HorizontalOrigin","./SceneMode","./SceneTransforms","./VerticalOrigin"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f,v,g){"use strict";function _(e,t){var r=e._billboardCollection;u(r)&&(r._updateBillboard(e,t),e._dirty=!0)}var y=function(e,i){if(e=s(e,s.EMPTY_OBJECT),u(e.scaleByDistance)&&e.scaleByDistance.far<=e.scaleByDistance.near)throw new c("scaleByDistance.far must be greater than scaleByDistance.near.");if(u(e.translucencyByDistance)&&e.translucencyByDistance.far<=e.translucencyByDistance.near)throw new c("translucencyByDistance.far must be greater than translucencyByDistance.near.");if(u(e.pixelOffsetScaleByDistance)&&e.pixelOffsetScaleByDistance.far<=e.pixelOffsetScaleByDistance.near)throw new c("pixelOffsetScaleByDistance.far must be greater than pixelOffsetScaleByDistance.near.");this._show=s(e.show,!0),this._position=r.clone(s(e.position,r.ZERO)),this._actualPosition=r.clone(this._position),this._pixelOffset=t.clone(s(e.pixelOffset,t.ZERO)),this._translate=new t(0,0),this._eyeOffset=r.clone(s(e.eyeOffset,r.ZERO)),this._verticalOrigin=s(e.verticalOrigin,g.CENTER),this._horizontalOrigin=s(e.horizontalOrigin,p.CENTER),this._scale=s(e.scale,1),this._color=o.clone(s(e.color,o.WHITE)),this._rotation=s(e.rotation,0),this._alignedAxis=r.clone(s(e.alignedAxis,r.ZERO)),this._width=e.width,this._height=e.height,this._scaleByDistance=e.scaleByDistance,this._translucencyByDistance=e.translucencyByDistance,this._pixelOffsetScaleByDistance=e.pixelOffsetScaleByDistance,this._heightReference=s(e.heightReference,m.NONE),this._sizeInMeters=s(e.sizeInMeters,!1),this._id=e.id,this._collection=s(e.collection,i),this._pickId=void 0,this._pickPrimitive=s(e._pickPrimitive,this),this._billboardCollection=i,this._dirty=!1,this._index=-1,this._imageIndex=-1,this._imageIndexPromise=void 0,this._imageId=void 0,this._image=void 0,this._imageSubRegion=void 0,this._imageWidth=void 0,this._imageHeight=void 0;var n=e.image,l=e.imageId;u(n)&&(u(l)||(l="string"==typeof n?n:u(n.src)?n.src:a()),this._imageId=l,this._image=n),u(e.imageSubRegion)&&(this._imageId=l,this._imageSubRegion=e.imageSubRegion),u(this._billboardCollection._textureAtlas)&&this._loadImage(),this._actualClampedPosition=void 0,this._removeCallbackFunc=void 0,this._mode=f.SCENE3D,this._updateClamping()},w=y.SHOW_INDEX=0,C=y.POSITION_INDEX=1,E=y.PIXEL_OFFSET_INDEX=2,S=y.EYE_OFFSET_INDEX=3,b=y.HORIZONTAL_ORIGIN_INDEX=4,T=y.VERTICAL_ORIGIN_INDEX=5,x=y.SCALE_INDEX=6,P=y.IMAGE_INDEX_INDEX=7,A=y.COLOR_INDEX=8,I=y.ROTATION_INDEX=9,D=y.ALIGNED_AXIS_INDEX=10,M=y.SCALE_BY_DISTANCE_INDEX=11,R=y.TRANSLUCENCY_BY_DISTANCE_INDEX=12,O=y.PIXEL_OFFSET_SCALE_BY_DISTANCE_INDEX=13;y.NUMBER_OF_PROPERTIES=14,l(y.prototype,{show:{get:function(){return this._show},set:function(e){if(!u(e))throw new c("value is required.");this._show!==e&&(this._show=e,_(this,w))}},position:{get:function(){return this._position},set:function(e){if(!u(e))throw new c("value is required.");var t=this._position;r.equals(t,e)||(r.clone(e,t),r.clone(e,this._actualPosition),this._updateClamping(),_(this,C))}},heightReference:{get:function(){return this._heightReference},set:function(e){if(!u(e))throw new c("value is required.");var t=this._heightReference;e!==t&&(this._heightReference=e,this._updateClamping(),_(this,C))}},pixelOffset:{get:function(){return this._pixelOffset},set:function(e){if(!u(e))throw new c("value is required.");var r=this._pixelOffset;t.equals(r,e)||(t.clone(e,r),_(this,E))}},scaleByDistance:{get:function(){return this._scaleByDistance},set:function(e){if(u(e)&&e.far<=e.near)throw new c("far distance must be greater than near distance.");var t=this._scaleByDistance;d.equals(t,e)||(this._scaleByDistance=d.clone(e,t),_(this,M))}},translucencyByDistance:{get:function(){return this._translucencyByDistance},set:function(e){if(u(e)&&e.far<=e.near)throw new c("far distance must be greater than near distance.");var t=this._translucencyByDistance;d.equals(t,e)||(this._translucencyByDistance=d.clone(e,t),_(this,R))}},pixelOffsetScaleByDistance:{get:function(){return this._pixelOffsetScaleByDistance},set:function(e){if(u(e)&&e.far<=e.near)throw new c("far distance must be greater than near distance.");var t=this._pixelOffsetScaleByDistance;d.equals(t,e)||(this._pixelOffsetScaleByDistance=d.clone(e,t),_(this,O))}},eyeOffset:{get:function(){return this._eyeOffset},set:function(e){if(!u(e))throw new c("value is required.");var t=this._eyeOffset;r.equals(t,e)||(r.clone(e,t),_(this,S))}},horizontalOrigin:{get:function(){return this._horizontalOrigin},set:function(e){if(!u(e))throw new c("value is required.");this._horizontalOrigin!==e&&(this._horizontalOrigin=e,_(this,b))}},verticalOrigin:{get:function(){return this._verticalOrigin},set:function(e){if(!u(e))throw new c("value is required.");this._verticalOrigin!==e&&(this._verticalOrigin=e,_(this,T))}},scale:{get:function(){return this._scale},set:function(e){if(!u(e))throw new c("value is required.");this._scale!==e&&(this._scale=e,_(this,x))}},color:{get:function(){return this._color},set:function(e){if(!u(e))throw new c("value is required.");var t=this._color;o.equals(t,e)||(o.clone(e,t),_(this,A))}},rotation:{get:function(){return this._rotation},set:function(e){if(!u(e))throw new c("value is required.");this._rotation!==e&&(this._rotation=e,_(this,I))}},alignedAxis:{get:function(){return this._alignedAxis},set:function(e){if(!u(e))throw new c("value is required.");var t=this._alignedAxis;r.equals(t,e)||(r.clone(e,t),_(this,D))}},width:{get:function(){return s(this._width,this._imageWidth)},set:function(e){this._width!==e&&(this._width=e,_(this,P))}},height:{get:function(){return s(this._height,this._imageHeight)},set:function(e){this._height!==e&&(this._height=e,_(this,P))}},sizeInMeters:{get:function(){return this._sizeInMeters},set:function(e){this._sizeInMeters!==e&&(this._sizeInMeters=e,_(this,A))}},id:{get:function(){return this._id},set:function(e){this._id=e,u(this._pickId)&&(this._pickId.object.id=e)}},pickPrimitive:{get:function(){return this._pickPrimitive},set:function(e){this._pickPrimitive=e,u(this._pickId)&&(this._pickId.object.primitive=e)}},image:{get:function(){return this._imageId},set:function(e){u(e)?"string"==typeof e?this.setImage(e,e):u(e.src)?this.setImage(e.src,e):this.setImage(a(),e):(this._imageIndex=-1,this._imageSubRegion=void 0,this._imageId=void 0,this._image=void 0,this._imageIndexPromise=void 0,_(this,P))}},ready:{get:function(){return-1!==this._imageIndex}},_clampedPosition:{get:function(){return this._actualClampedPosition},set:function(e){this._actualClampedPosition=r.clone(e,this._actualClampedPosition),_(this,C)}}}),y.prototype.getPickId=function(e){return u(this._pickId)||(this._pickId=e.createPickId({primitive:this._pickPrimitive,collection:this._collection,id:this._id})),this._pickId},y.prototype._updateClamping=function(){y._updateClamping(this._billboardCollection,this)};var N=new n,L=new r;y._updateClamping=function(e,t){var i=e._scene;if(u(i)){var o=i.globe,a=o.ellipsoid,s=o._surface,l=i.frameState.mode,h=i.frameState.mapProjection,d=l!==t._mode;if(t._mode=l,(t._heightReference===m.NONE||d)&&u(t._removeCallbackFunc)&&(t._removeCallbackFunc(),t._removeCallbackFunc=void 0,t._clampedPosition=void 0),t._heightReference!==m.NONE&&u(t._position)){var p=a.cartesianToCartographic(t._position);if(u(p)){u(t._removeCallbackFunc)&&t._removeCallbackFunc();var v=function(e){if(t._heightReference===m.RELATIVE_TO_GROUND)if(t._mode===f.SCENE3D){var i=a.cartesianToCartographic(e,N);i.height+=p.height,a.cartographicToCartesian(i,e)}else e.x+=p.height;t._clampedPosition=r.clone(e,t._clampedPosition)};t._removeCallbackFunc=s.updateHeight(p,v);var g=o.getHeight(p);u(g)&&(n.clone(p,N),N.height=g,t._mode===f.SCENE3D?a.cartographicToCartesian(N,L):(h.project(N,L),r.fromElements(L.z,L.x,L.y,L)),v(L))}}}else if(t._heightReference!==m.NONE)throw new c("Height reference is not supported.")},y.prototype._loadImage=function(){var t,r=this._billboardCollection._textureAtlas,i=this._imageId,n=this._image,o=this._imageSubRegion;if(u(n)&&(t=r.addImage(i,n)),u(o)&&(t=r.addSubRegion(i,o)),this._imageIndexPromise=t,u(t)){var a=this;t.then(function(t){if(a._imageId===i&&a._image===n&&e.equals(a._imageSubRegion,o)){var s=r.textureCoordinates[t];a._imageWidth=r.texture.width*s.width,a._imageHeight=r.texture.height*s.height,a._imageIndex=t,a._ready=!0,a._image=void 0,a._imageIndexPromise=void 0,_(a,P)}}).otherwise(function(e){console.error("Error loading image for billboard: "+e),a._imageIndexPromise=void 0})}},y.prototype.setImage=function(e,t){if(!u(e))throw new c("id is required.");if(!u(t))throw new c("image is required.");this._imageId!==e&&(this._imageIndex=-1,this._imageSubRegion=void 0,this._imageId=e,this._image=t,u(this._billboardCollection._textureAtlas)&&this._loadImage())},y.prototype.setImageSubRegion=function(t,r){if(!u(t))throw new c("id is required.");if(!u(r))throw new c("subRegion is required.");this._imageId===t&&e.equals(this._imageSubRegion,r)||(this._imageIndex=-1,this._imageId=t,this._imageSubRegion=e.clone(r),u(this._billboardCollection._textureAtlas)&&this._loadImage())},y.prototype._setTranslate=function(e){if(!u(e))throw new c("value is required.");var r=this._translate;t.equals(r,e)||(t.clone(e,r),_(this,E))},y.prototype._getActualPosition=function(){return u(this._clampedPosition)?this._clampedPosition:this._actualPosition},y.prototype._setActualPosition=function(e){u(this._clampedPosition)||r.clone(e,this._actualPosition),_(this,C)};var F=new i;y._computeActualPosition=function(e,t,r,i){return u(e._clampedPosition)?(r.mode!==e._mode&&e._updateClamping(),e._clampedPosition):r.mode===f.SCENE3D?t:(h.multiplyByPoint(i,t,F),v.computeActualWgs84Position(r,F))};var B=new h,z=new i,V=new r,k=new t,U=new t;y._computeScreenSpacePosition=function(e,n,o,a,s,u){var l=s.camera,c=l.viewMatrix,d=l.frustum.projectionMatrix,m=h.multiplyTransformation(c,e,B),p=h.multiplyByVector(m,i.fromElements(n.x,n.y,n.z,1,z),z),f=r.multiplyComponents(o,r.normalize(p,V),V);p.x+=o.x+f.x,p.y+=o.y+f.y,p.z+=f.z;var g=h.multiplyByVector(d,p,z),_=v.clipToGLWindowCoordinates(s,g,u);a=t.clone(a,U),a.y=-a.y;var y=t.multiplyByScalar(a,s.context.uniformState.resolutionScale,k);return _.x+=y.x,_.y+=y.y,_};var q=new t(0,0);return y.prototype.computeScreenSpacePosition=function(e,r){var i=this._billboardCollection;if(u(r)||(r=new t),!u(i))throw new c("Billboard must be in a collection.  Was it removed?");if(!u(e))throw new c("scene is required.");t.clone(this._pixelOffset,q),t.add(q,this._translate,q);var n=i.modelMatrix,o=this._getActualPosition(),a=y._computeScreenSpacePosition(n,o,this._eyeOffset,q,e,r);return a.y=e.canvas.clientHeight-a.y,a},y.prototype.equals=function(i){return this===i||u(i)&&this._id===i._id&&r.equals(this._position,i._position)&&this._imageId===i._imageId&&this._show===i._show&&this._scale===i._scale&&this._verticalOrigin===i._verticalOrigin&&this._horizontalOrigin===i._horizontalOrigin&&e.equals(this._imageSubRegion,i._imageSubRegion)&&o.equals(this._color,i._color)&&t.equals(this._pixelOffset,i._pixelOffset)&&t.equals(this._translate,i._translate)&&r.equals(this._eyeOffset,i._eyeOffset)&&d.equals(this._scaleByDistance,i._scaleByDistance)&&d.equals(this._translucencyByDistance,i._translucencyByDistance)&&d.equals(this._pixelOffsetScaleByDistance,i._pixelOffsetScaleByDistance)},y.prototype._destroy=function(){u(this._customData)&&(this._billboardCollection._scene.globe._surface.removeTileCustomData(this._customData),this._customData=void 0),this.image=void 0,this._pickId=this._pickId&&this._pickId.destroy(),this._billboardCollection=void 0},y}),r("Scene/BlendEquation",["../Core/freezeObject","../Renderer/WebGLConstants"],function(e,t){"use strict";var r={ADD:t.FUNC_ADD,SUBTRACT:t.FUNC_SUBTRACT,REVERSE_SUBTRACT:t.FUNC_REVERSE_SUBTRACT};return e(r)}),r("Scene/BlendFunction",["../Core/freezeObject","../Renderer/WebGLConstants"],function(e,t){"use strict";var r={ZERO:t.ZERO,ONE:t.ONE,SOURCE_COLOR:t.SRC_COLOR,ONE_MINUS_SOURCE_COLOR:t.ONE_MINUS_SRC_COLOR,DESTINATION_COLOR:t.DST_COLOR,ONE_MINUS_DESTINATION_COLOR:t.ONE_MINUS_DST_COLOR,SOURCE_ALPHA:t.SRC_ALPHA,ONE_MINUS_SOURCE_ALPHA:t.ONE_MINUS_SRC_ALPHA,DESTINATION_ALPHA:t.DST_ALPHA,ONE_MINUS_DESTINATION_ALPHA:t.ONE_MINUS_DST_ALPHA,CONSTANT_COLOR:t.CONSTANT_COLOR,ONE_MINUS_CONSTANT_COLOR:t.ONE_MINUS_CONSTANT_ALPHA,CONSTANT_ALPHA:t.CONSTANT_ALPHA,ONE_MINUS_CONSTANT_ALPHA:t.ONE_MINUS_CONSTANT_ALPHA,SOURCE_ALPHA_SATURATE:t.SRC_ALPHA_SATURATE};return e(r)}),r("Scene/BlendingState",["../Core/freezeObject","./BlendEquation","./BlendFunction"],function(e,t,r){"use strict";var i={DISABLED:e({enabled:!1}),ALPHA_BLEND:e({enabled:!0,equationRgb:t.ADD,equationAlpha:t.ADD,functionSourceRgb:r.SOURCE_ALPHA,functionSourceAlpha:r.SOURCE_ALPHA,functionDestinationRgb:r.ONE_MINUS_SOURCE_ALPHA,functionDestinationAlpha:r.ONE_MINUS_SOURCE_ALPHA}),PRE_MULTIPLIED_ALPHA_BLEND:e({enabled:!0,equationRgb:t.ADD,equationAlpha:t.ADD,functionSourceRgb:r.ONE,functionSourceAlpha:r.ONE,functionDestinationRgb:r.ONE_MINUS_SOURCE_ALPHA,functionDestinationAlpha:r.ONE_MINUS_SOURCE_ALPHA}),ADDITIVE_BLEND:e({enabled:!0,equationRgb:t.ADD,equationAlpha:t.ADD,functionSourceRgb:r.SOURCE_ALPHA,functionSourceAlpha:r.SOURCE_ALPHA,functionDestinationRgb:r.ONE,functionDestinationAlpha:r.ONE})};return e(i)}),r("Scene/Pass",["../Core/freezeObject"],function(e){"use strict";var t={COMPUTE:0,GLOBE:1,GROUND:2,OPAQUE:3,TRANSLUCENT:4,OVERLAY:5,NUMBER_OF_PASSES:6};return e(t)}),r("Renderer/Framebuffer",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/PixelFormat","./ContextLimits"],function(e,t,r,i,n,o,a){"use strict";function s(e,t,r){var i=e._gl;i.framebufferTexture2D(i.FRAMEBUFFER,t,r._target,r._texture,0)}function u(e,t,r){var i=e._gl;i.framebufferRenderbuffer(i.FRAMEBUFFER,t,i.RENDERBUFFER,r._getRenderbuffer())}var l=function(r){if(r=e(r,e.EMPTY_OBJECT),!t(r.context))throw new n("options.context is required.");var i=r.context._gl,l=a.maximumColorAttachments;if(this._gl=i,this._framebuffer=i.createFramebuffer(),this._colorTextures=[],this._colorRenderbuffers=[],this._activeColorAttachments=[],this._depthTexture=void 0,this._depthRenderbuffer=void 0,this._stencilRenderbuffer=void 0,this._depthStencilTexture=void 0,this._depthStencilRenderbuffer=void 0,this.destroyAttachments=e(r.destroyAttachments,!0),t(r.colorTextures)&&t(r.colorRenderbuffers))throw new n("Cannot have both color texture and color renderbuffer attachments.");if(t(r.depthTexture)&&t(r.depthRenderbuffer))throw new n("Cannot have both a depth texture and depth renderbuffer attachment.");if(t(r.depthStencilTexture)&&t(r.depthStencilRenderbuffer))throw new n("Cannot have both a depth-stencil texture and depth-stencil renderbuffer attachment.");var c=t(r.depthTexture)||t(r.depthRenderbuffer),h=t(r.depthStencilTexture)||t(r.depthStencilRenderbuffer);if(c&&h)throw new n("Cannot have both a depth and depth-stencil attachment.");if(t(r.stencilRenderbuffer)&&h)throw new n("Cannot have both a stencil and depth-stencil attachment.");if(c&&t(r.stencilRenderbuffer))throw new n("Cannot have both a depth and stencil attachment.");this._bind();var d,m,p,f,v;if(t(r.colorTextures)){var g=r.colorTextures;if(f=this._colorTextures.length=this._activeColorAttachments.length=g.length,f>l)throw new n("The number of color attachments exceeds the number supported.");for(p=0;f>p;++p){if(d=g[p],!o.isColorFormat(d.pixelFormat))throw new n("The color-texture pixel-format must be a color format.");v=this._gl.COLOR_ATTACHMENT0+p,s(this,v,d),this._activeColorAttachments[p]=v,this._colorTextures[p]=d}}if(t(r.colorRenderbuffers)){var _=r.colorRenderbuffers;if(f=this._colorRenderbuffers.length=this._activeColorAttachments.length=_.length,f>l)throw new n("The number of color attachments exceeds the number supported.");for(p=0;f>p;++p)m=_[p],v=this._gl.COLOR_ATTACHMENT0+p,u(this,v,m),this._activeColorAttachments[p]=v,this._colorRenderbuffers[p]=m}if(t(r.depthTexture)){if(d=r.depthTexture,d.pixelFormat!==o.DEPTH_COMPONENT)throw new n("The depth-texture pixel-format must be DEPTH_COMPONENT.");s(this,this._gl.DEPTH_ATTACHMENT,d),this._depthTexture=d}if(t(r.depthRenderbuffer)&&(m=r.depthRenderbuffer,u(this,this._gl.DEPTH_ATTACHMENT,m),this._depthRenderbuffer=m),t(r.stencilRenderbuffer)&&(m=r.stencilRenderbuffer,u(this,this._gl.STENCIL_ATTACHMENT,m),this._stencilRenderbuffer=m),t(r.depthStencilTexture)){if(d=r.depthStencilTexture,d.pixelFormat!==o.DEPTH_STENCIL)throw new n("The depth-stencil pixel-format must be DEPTH_STENCIL.");s(this,this._gl.DEPTH_STENCIL_ATTACHMENT,d),this._depthStencilTexture=d}t(r.depthStencilRenderbuffer)&&(m=r.depthStencilRenderbuffer,u(this,this._gl.DEPTH_STENCIL_ATTACHMENT,m),this._depthStencilRenderbuffer=m),this._unBind()};return r(l.prototype,{status:{get:function(){this._bind();var e=this._gl.checkFramebufferStatus(this._gl.FRAMEBUFFER);return this._unBind(),e}},numberOfColorAttachments:{get:function(){return this._activeColorAttachments.length}},depthTexture:{get:function(){return this._depthTexture}},depthRenderbuffer:{get:function(){return this._depthRenderbuffer}},stencilRenderbuffer:{get:function(){return this._stencilRenderbuffer}},depthStencilTexture:{get:function(){return this._depthStencilTexture}},depthStencilRenderbuffer:{get:function(){return this._depthStencilRenderbuffer}},hasDepthAttachment:{get:function(){return!!(this.depthTexture||this.depthRenderbuffer||this.depthStencilTexture||this.depthStencilRenderbuffer)}}}),l.prototype._bind=function(){var e=this._gl;e.bindFramebuffer(e.FRAMEBUFFER,this._framebuffer)},l.prototype._unBind=function(){var e=this._gl;e.bindFramebuffer(e.FRAMEBUFFER,null)},l.prototype._getActiveColorAttachments=function(){return this._activeColorAttachments},l.prototype.getColorTexture=function(e){if(!t(e)||0>e||e>=this._colorTextures.length)throw new n("index is required, must be greater than or equal to zero and must be less than the number of color attachments.");return this._colorTextures[e]},l.prototype.getColorRenderbuffer=function(e){if(!t(e)||0>e||e>=this._colorRenderbuffers.length)throw new n("index is required, must be greater than or equal to zero and must be less than the number of color attachments.");return this._colorRenderbuffers[e]},l.prototype.isDestroyed=function(){return!1},l.prototype.destroy=function(){if(this.destroyAttachments){for(var e=0,r=this._colorTextures,n=r.length;n>e;++e){var o=r[e];t(o)&&o.destroy()}var a=this._colorRenderbuffers;for(n=a.length,e=0;n>e;++e){var s=a[e];t(s)&&s.destroy()}this._depthTexture=this._depthTexture&&this._depthTexture.destroy(),this._depthRenderbuffer=this._depthRenderbuffer&&this._depthRenderbuffer.destroy(),this._stencilRenderbuffer=this._stencilRenderbuffer&&this._stencilRenderbuffer.destroy(),this._depthStencilTexture=this._depthStencilTexture&&this._depthStencilTexture.destroy(),this._depthStencilRenderbuffer=this._depthStencilRenderbuffer&&this._depthStencilRenderbuffer.destroy()}return this._gl.deleteFramebuffer(this._framebuffer),i(this)},l}),r("Renderer/MipmapHint",["../Core/freezeObject","./WebGLConstants"],function(e,t){"use strict";var r={DONT_CARE:t.DONT_CARE,FASTEST:t.FASTEST,NICEST:t.NICEST,validate:function(e){return e===r.DONT_CARE||e===r.FASTEST||e===r.NICEST}};return e(r)}),r("Renderer/PixelDatatype",["../Core/freezeObject","./WebGLConstants"],function(e,t){"use strict";var r={UNSIGNED_BYTE:t.UNSIGNED_BYTE,UNSIGNED_SHORT:t.UNSIGNED_SHORT,UNSIGNED_INT:t.UNSIGNED_INT,FLOAT:t.FLOAT,UNSIGNED_INT_24_8:t.UNSIGNED_INT_24_8,UNSIGNED_SHORT_4_4_4_4:t.UNSIGNED_SHORT_4_4_4_4,UNSIGNED_SHORT_5_5_5_1:t.UNSIGNED_SHORT_5_5_5_1,UNSIGNED_SHORT_5_6_5:t.UNSIGNED_SHORT_5_6_5,validate:function(e){return e===r.UNSIGNED_BYTE||e===r.UNSIGNED_SHORT||e===r.UNSIGNED_INT||e===r.FLOAT||e===r.UNSIGNED_INT_24_8||e===r.UNSIGNED_SHORT_4_4_4_4||e===r.UNSIGNED_SHORT_5_5_5_1||e===r.UNSIGNED_SHORT_5_6_5}};return e(r)}),r("Renderer/TextureMagnificationFilter",["../Core/freezeObject","./WebGLConstants"],function(e,t){"use strict";var r={NEAREST:t.NEAREST,LINEAR:t.LINEAR,validate:function(e){return e===r.NEAREST||e===r.LINEAR}};return e(r)}),r("Renderer/TextureMinificationFilter",["../Core/freezeObject","./WebGLConstants"],function(e,t){"use strict";var r={NEAREST:t.NEAREST,LINEAR:t.LINEAR,NEAREST_MIPMAP_NEAREST:t.NEAREST_MIPMAP_NEAREST,LINEAR_MIPMAP_NEAREST:t.LINEAR_MIPMAP_NEAREST,NEAREST_MIPMAP_LINEAR:t.NEAREST_MIPMAP_LINEAR,LINEAR_MIPMAP_LINEAR:t.LINEAR_MIPMAP_LINEAR,validate:function(e){return e===r.NEAREST||e===r.LINEAR||e===r.NEAREST_MIPMAP_NEAREST||e===r.LINEAR_MIPMAP_NEAREST||e===r.NEAREST_MIPMAP_LINEAR||e===r.LINEAR_MIPMAP_LINEAR}};return e(r)}),r("Renderer/TextureWrap",["../Core/freezeObject","./WebGLConstants"],function(e,t){"use strict";var r={CLAMP_TO_EDGE:t.CLAMP_TO_EDGE,REPEAT:t.REPEAT,MIRRORED_REPEAT:t.MIRRORED_REPEAT,validate:function(e){return e===r.CLAMP_TO_EDGE||e===r.REPEAT||e===r.MIRRORED_REPEAT}};return e(r)}),r("Renderer/Sampler",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","./TextureMagnificationFilter","./TextureMinificationFilter","./TextureWrap"],function(e,t,r,i,n,o,a){"use strict";var s=function(r){r=e(r,e.EMPTY_OBJECT);var s=e(r.wrapS,a.CLAMP_TO_EDGE),u=e(r.wrapT,a.CLAMP_TO_EDGE),l=e(r.minificationFilter,o.LINEAR),c=e(r.magnificationFilter,n.LINEAR),h=t(r.maximumAnisotropy)?r.maximumAnisotropy:1;if(!a.validate(s))throw new i("Invalid sampler.wrapS.");if(!a.validate(u))throw new i("Invalid sampler.wrapT.");if(!o.validate(l))throw new i("Invalid sampler.minificationFilter.");if(!n.validate(c))throw new i("Invalid sampler.magnificationFilter.");if(1>h)throw new i("sampler.maximumAnisotropy must be greater than or equal to one.");this._wrapS=s,this._wrapT=u,this._minificationFilter=l,this._magnificationFilter=c,this._maximumAnisotropy=h};return r(s.prototype,{wrapS:{get:function(){return this._wrapS}},wrapT:{get:function(){return this._wrapT}},minificationFilter:{get:function(){return this._minificationFilter}},magnificationFilter:{get:function(){return this._magnificationFilter}},maximumAnisotropy:{get:function(){return this._maximumAnisotropy}}}),s}),r("Renderer/Texture",["../Core/Cartesian2","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Math","../Core/PixelFormat","./ContextLimits","./MipmapHint","./PixelDatatype","./Sampler","./TextureMagnificationFilter","./TextureMinificationFilter","./TextureWrap","./WebGLConstants"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f){"use strict";var v=function(i){if(i=t(i,t.EMPTY_OBJECT),!r(i.context))throw new o("options.context is required.");var n=i.context,a=i.source,l=r(a)?a.width:i.width,d=r(a)?a.height:i.height,m=t(i.pixelFormat,s.RGBA),p=t(i.pixelDatatype,c.UNSIGNED_BYTE),v=m;if(n.webgl2&&(m===s.DEPTH_STENCIL?v=f.DEPTH24_STENCIL8:m===s.DEPTH_COMPONENT&&(p===c.UNSIGNED_SHORT?v=f.DEPTH_COMPONENT16:p===c.UNSIGNED_INT&&(v=f.DEPTH_COMPONENT24))),!r(l)||!r(d))throw new o("options requires a source field to create an initialized texture or width and height fields to create a blank texture.");if(0>=l)throw new o("Width must be greater than zero.");if(l>u.maximumTextureSize)throw new o("Width must be less than or equal to the maximum texture size ("+u.maximumTextureSize+").  Check maximumTextureSize.");if(0>=d)throw new o("Height must be greater than zero.");if(d>u.maximumTextureSize)throw new o("Height must be less than or equal to the maximum texture size ("+u.maximumTextureSize+").  Check maximumTextureSize.");if(!s.validate(m))throw new o("Invalid options.pixelFormat.");if(!c.validate(p))throw new o("Invalid options.pixelDatatype.");if(m===s.DEPTH_COMPONENT&&p!==c.UNSIGNED_SHORT&&p!==c.UNSIGNED_INT)throw new o("When options.pixelFormat is DEPTH_COMPONENT, options.pixelDatatype must be UNSIGNED_SHORT or UNSIGNED_INT.");if(m===s.DEPTH_STENCIL&&p!==c.UNSIGNED_INT_24_8)throw new o("When options.pixelFormat is DEPTH_STENCIL, options.pixelDatatype must be UNSIGNED_INT_24_8.");if(p===c.FLOAT&&!n.floatingPointTexture)throw new o("When options.pixelDatatype is FLOAT, this WebGL implementation must support the OES_texture_float extension.  Check context.floatingPointTexture.");if(s.isDepthFormat(m)){if(r(a))throw new o("When options.pixelFormat is DEPTH_COMPONENT or DEPTH_STENCIL, source cannot be provided.");if(!n.depthTexture)throw new o("When options.pixelFormat is DEPTH_COMPONENT or DEPTH_STENCIL, this WebGL implementation must support WEBGL_depth_texture.  Check context.depthTexture.")}var g=i.preMultiplyAlpha||m===s.RGB||m===s.LUMINANCE,_=t(i.flipY,!0),y=n._gl,w=y.TEXTURE_2D,C=y.createTexture();y.activeTexture(y.TEXTURE0),y.bindTexture(w,C),r(a)?(y.pixelStorei(y.UNPACK_PREMULTIPLY_ALPHA_WEBGL,g),y.pixelStorei(y.UNPACK_FLIP_Y_WEBGL,_),r(a.arrayBufferView)?y.texImage2D(w,0,v,l,d,0,m,p,a.arrayBufferView):r(a.framebuffer)?(a.framebuffer!==n.defaultFramebuffer&&a.framebuffer._bind(),y.copyTexImage2D(w,0,v,a.xOffset,a.yOffset,l,d,0),a.framebuffer!==n.defaultFramebuffer&&a.framebuffer._unBind()):y.texImage2D(w,0,v,m,p,a)):y.texImage2D(w,0,v,l,d,0,m,p,null),y.bindTexture(w,null),this._context=n,this._textureFilterAnisotropic=n._textureFilterAnisotropic,this._textureTarget=w,this._texture=C,this._pixelFormat=m,this._pixelDatatype=p,this._width=l,this._height=d,this._dimensions=new e(l,d),this._preMultiplyAlpha=g,this._flipY=_,this._sampler=void 0,this.sampler=new h};return v.fromFramebuffer=function(e){if(e=t(e,t.EMPTY_OBJECT),!r(e.context))throw new o("options.context is required.");var i=e.context,n=i._gl,a=t(e.pixelFormat,s.RGB),u=t(e.framebufferXOffset,0),l=t(e.framebufferYOffset,0),c=t(e.width,n.drawingBufferWidth),h=t(e.height,n.drawingBufferHeight),d=e.framebuffer;if(!r(e.context))throw new o("context is required.");if(!s.validate(a))throw new o("Invalid pixelFormat.");if(s.isDepthFormat(a))throw new o("pixelFormat cannot be DEPTH_COMPONENT or DEPTH_STENCIL.");if(0>u)throw new o("framebufferXOffset must be greater than or equal to zero.");if(0>l)throw new o("framebufferYOffset must be greater than or equal to zero.");if(u+c>n.drawingBufferWidth)throw new o("framebufferXOffset + width must be less than or equal to drawingBufferWidth");if(l+h>n.drawingBufferHeight)throw new o("framebufferYOffset + height must be less than or equal to drawingBufferHeight.");var m=new v({context:i,width:c,height:h,pixelFormat:a,source:{framebuffer:r(d)?d:i.defaultFramebuffer,xOffset:u,yOffset:l,width:c,height:h}});return m},i(v.prototype,{sampler:{get:function(){return this._sampler},set:function(e){var t=e.minificationFilter,i=e.magnificationFilter,n=t===m.NEAREST_MIPMAP_NEAREST||t===m.NEAREST_MIPMAP_LINEAR||t===m.LINEAR_MIPMAP_NEAREST||t===m.LINEAR_MIPMAP_LINEAR;this._pixelDatatype===c.FLOAT&&(t=n?m.NEAREST_MIPMAP_NEAREST:m.NEAREST,i=d.NEAREST);var o=this._context._gl,a=this._textureTarget;o.activeTexture(o.TEXTURE0),o.bindTexture(a,this._texture),o.texParameteri(a,o.TEXTURE_MIN_FILTER,t),o.texParameteri(a,o.TEXTURE_MAG_FILTER,i),o.texParameteri(a,o.TEXTURE_WRAP_S,e.wrapS),o.texParameteri(a,o.TEXTURE_WRAP_T,e.wrapT),r(this._textureFilterAnisotropic)&&o.texParameteri(a,this._textureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,e.maximumAnisotropy),o.bindTexture(a,null),this._sampler=e}},pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},dimensions:{get:function(){return this._dimensions}},preMultiplyAlpha:{get:function(){return this._preMultiplyAlpha}},flipY:{get:function(){return this._flipY}},width:{get:function(){return this._width}},height:{get:function(){return this._height}},_target:{get:function(){return this._textureTarget}}}),v.prototype.copyFrom=function(e,i,n){if(i=t(i,0),n=t(n,0),!r(e))throw new o("source is required.");if(s.isDepthFormat(this._pixelFormat))throw new o("Cannot call copyFrom when the texture pixel format is DEPTH_COMPONENT or DEPTH_STENCIL.");if(0>i)throw new o("xOffset must be greater than or equal to zero.");if(0>n)throw new o("yOffset must be greater than or equal to zero.");if(i+e.width>this._width)throw new o("xOffset + source.width must be less than or equal to width.");if(n+e.height>this._height)throw new o("yOffset + source.height must be less than or equal to height.");var a=this._context._gl,u=this._textureTarget;a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,this._preMultiplyAlpha),a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,this._flipY),a.activeTexture(a.TEXTURE0),a.bindTexture(u,this._texture),e.arrayBufferView?a.texSubImage2D(u,0,i,n,e.width,e.height,this._pixelFormat,this._pixelDatatype,e.arrayBufferView):a.texSubImage2D(u,0,i,n,this._pixelFormat,this._pixelDatatype,e),a.bindTexture(u,null)},v.prototype.copyFromFramebuffer=function(e,r,i,n,a,u){if(e=t(e,0),r=t(r,0),i=t(i,0),n=t(n,0),a=t(a,this._width),u=t(u,this._height),s.isDepthFormat(this._pixelFormat))throw new o("Cannot call copyFromFramebuffer when the texture pixel format is DEPTH_COMPONENT or DEPTH_STENCIL.");if(this._pixelDatatype===c.FLOAT)throw new o("Cannot call copyFromFramebuffer when the texture pixel data type is FLOAT.");if(0>e)throw new o("xOffset must be greater than or equal to zero.");if(0>r)throw new o("yOffset must be greater than or equal to zero.");if(0>i)throw new o("framebufferXOffset must be greater than or equal to zero.");if(0>n)throw new o("framebufferYOffset must be greater than or equal to zero.");if(e+a>this._width)throw new o("xOffset + width must be less than or equal to width.");if(r+u>this._height)throw new o("yOffset + height must be less than or equal to height.");var l=this._context._gl,h=this._textureTarget;l.activeTexture(l.TEXTURE0),l.bindTexture(h,this._texture),l.copyTexSubImage2D(h,0,e,r,i,n,a,u),l.bindTexture(h,null)},v.prototype.generateMipmap=function(e){if(e=t(e,l.DONT_CARE),s.isDepthFormat(this._pixelFormat))throw new o("Cannot call generateMipmap when the texture pixel format is DEPTH_COMPONENT or DEPTH_STENCIL.");if(this._width>1&&!a.isPowerOfTwo(this._width))throw new o("width must be a power of two to call generateMipmap().");
if(this._height>1&&!a.isPowerOfTwo(this._height))throw new o("height must be a power of two to call generateMipmap().");if(!l.validate(e))throw new o("hint is invalid.");var r=this._context._gl,i=this._textureTarget;r.hint(r.GENERATE_MIPMAP_HINT,e),r.activeTexture(r.TEXTURE0),r.bindTexture(i,this._texture),r.generateMipmap(i),r.bindTexture(i,null)},v.prototype.isDestroyed=function(){return!1},v.prototype.destroy=function(){return this._context._gl.deleteTexture(this._texture),n(this)},v}),r("Scene/TextureAtlas",["../Core/BoundingRectangle","../Core/Cartesian2","../Core/createGuid","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/loadImage","../Core/PixelFormat","../Core/RuntimeError","../Renderer/Framebuffer","../Renderer/RenderState","../Renderer/Texture","../ThirdParty/when"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p){"use strict";function f(e,r,n,o,a){this.bottomLeft=i(e,t.ZERO),this.topRight=i(r,t.ZERO),this.childNode1=n,this.childNode2=o,this.imageIndex=a}function v(r,i){var o=r._context,a=r.numberOfImages,s=2;if(a>0){var u=r._texture.width,l=r._texture.height,c=s*(u+i.width+r._borderWidthInPixels),p=s*(l+i.height+r._borderWidthInPixels),v=u/c,g=l/p,_=new f(new t(u+r._borderWidthInPixels,0),new t(c,l)),y=new f(new t,new t(c,l),r._root,_),w=new f(new t(0,l+r._borderWidthInPixels),new t(c,p)),C=new f(new t,new t(c,p),y,w);r._root=C;for(var E=0;E<r._textureCoordinates.length;E++){var S=r._textureCoordinates[E];n(S)&&(S.x*=v,S.y*=g,S.width*=v,S.height*=g)}var b=new m({context:r._context,width:c,height:p,pixelFormat:r._pixelFormat}),T=new h({context:o,colorTextures:[b],destroyAttachments:!1}),x=r._copyCommand,P={viewport:new e(0,0,u,l)};x.renderState=d.fromCache(P),T._bind(),x.execute(r._context),T._unBind(),T.destroy(),r._texture=b,d.removeFromCache(P),x.renderState=void 0}else{var A=s*(i.width+r._borderWidthInPixels),I=s*(i.height+r._borderWidthInPixels);r._texture=r._texture&&r._texture.destroy(),r._texture=new m({context:r._context,width:A,height:I,pixelFormat:r._pixelFormat}),r._root=new f(new t,new t(A,I))}}function g(e,r,i){if(!n(r))return void 0;if(!n(r.childNode1)&&!n(r.childNode2)){if(n(r.imageIndex))return void 0;var o=r.topRight.x-r.bottomLeft.x,a=r.topRight.y-r.bottomLeft.y,s=o-i.width,u=a-i.height;if(0>s||0>u)return void 0;if(0===s&&0===u)return r;if(s>u){r.childNode1=new f(new t(r.bottomLeft.x,r.bottomLeft.y),new t(r.bottomLeft.x+i.width,r.topRight.y));var l=r.bottomLeft.x+i.width+e._borderWidthInPixels;l<r.topRight.x&&(r.childNode2=new f(new t(l,r.bottomLeft.y),new t(r.topRight.x,r.topRight.y)))}else{r.childNode1=new f(new t(r.bottomLeft.x,r.bottomLeft.y),new t(r.topRight.x,r.bottomLeft.y+i.height));var c=r.bottomLeft.y+i.height+e._borderWidthInPixels;c<r.topRight.y&&(r.childNode2=new f(new t(r.bottomLeft.x,c),new t(r.topRight.x,r.topRight.y)))}return g(e,r.childNode1,i)}return g(e,r.childNode1,i)||g(e,r.childNode2,i)}function _(t,i,o){var a=g(t,t._root,i);if(n(a)){a.imageIndex=o;var s=t._texture.width,u=t._texture.height,l=a.topRight.x-a.bottomLeft.x,c=a.topRight.y-a.bottomLeft.y,h=a.bottomLeft.x/s,d=a.bottomLeft.y/u,m=l/s,p=c/u;t._textureCoordinates[o]=new e(h,d,m,p),t._texture.copyFrom(i,a.bottomLeft.x,a.bottomLeft.y)}else v(t,i),_(t,i,o);t._guid=r()}var y=new t(16,16),w=function(e){e=i(e,i.EMPTY_OBJECT);var o=i(e.borderWidthInPixels,1),a=i(e.initialSize,y);if(!n(e.context))throw new s("context is required.");if(0>o)throw new s("borderWidthInPixels must be greater than or equal to zero.");if(a.x<1||a.y<1)throw new s("initialSize must be greater than zero.");this._context=e.context,this._pixelFormat=i(e.pixelFormat,l.RGBA),this._borderWidthInPixels=o,this._textureCoordinates=[],this._guid=r(),this._idHash={},this._texture=new m({context:this._context,width:a.x,height:a.y,pixelFormat:this._pixelFormat}),this._root=new f(new t,new t(a.x,a.y));var u=this,c={u_texture:function(){return u._texture}},h="uniform sampler2D u_texture;\nvarying vec2 v_textureCoordinates;\nvoid main()\n{\n    gl_FragColor = texture2D(u_texture, v_textureCoordinates);\n}\n";this._copyCommand=this._context.createViewportQuadCommand(h,{uniformMap:c})};return o(w.prototype,{borderWidthInPixels:{get:function(){return this._borderWidthInPixels}},textureCoordinates:{get:function(){return this._textureCoordinates}},texture:{get:function(){return this._texture}},numberOfImages:{get:function(){return this._textureCoordinates.length}},guid:{get:function(){return this._guid}}}),w.prototype.addImage=function(e,t){if(!n(e))throw new s("id is required.");if(!n(t))throw new s("image is required.");var r=this._idHash[e];if(n(r))return r;if("function"==typeof t){if(t=t(e),!n(t))throw new s("image is required.")}else"string"==typeof t&&(t=u(t));var i=this;return r=p(t,function(e){if(i.isDestroyed())return-1;var t=i.numberOfImages;return _(i,e,t),t}),this._idHash[e]=r,r},w.prototype.addSubRegion=function(t,i){if(!n(t))throw new s("id is required.");if(!n(i))throw new s("subRegion is required.");var o=this._idHash[t];if(!n(o))throw new c('image with id "'+t+'" not found in the atlas.');var a=this;return p(o,function(t){if(-1===t)return-1;var n=a._texture.width,o=a._texture.height,s=a.numberOfImages,u=a._textureCoordinates[t],l=u.x+i.x/n,c=u.y+i.y/o,h=i.width/n,d=i.height/o;return a._textureCoordinates.push(new e(l,c,h,d)),a._guid=r(),s})},w.prototype.isDestroyed=function(){return!1},w.prototype.destroy=function(){return this._texture=this._texture&&this._texture.destroy(),a(this)},w}),r("Scene/BillboardCollection",["../Core/AttributeCompression","../Core/BoundingSphere","../Core/Cartesian2","../Core/Cartesian3","../Core/Color","../Core/ComponentDatatype","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/EncodedCartesian3","../Core/IndexDatatype","../Core/Math","../Core/Matrix4","../Renderer/Buffer","../Renderer/BufferUsage","../Renderer/DrawCommand","../Renderer/RenderState","../Renderer/ShaderProgram","../Renderer/ShaderSource","../Renderer/VertexArrayFacade","../Shaders/BillboardCollectionFS","../Shaders/BillboardCollectionVS","./Billboard","./BlendingState","./HorizontalOrigin","./Pass","./SceneMode","./TextureAtlas"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f,v,g,_,y,w,C,E,S,b,T,x,P,A,I){"use strict";function D(e){for(var t=e.length,r=0;t>r;++r)e[r]&&e[r]._destroy()}function M(e){if(e._billboardsRemoved){e._billboardsRemoved=!1;for(var t=[],r=e._billboards,i=r.length,n=0,o=0;i>n;++n){var a=r[n];a&&(a._index=o++,t.push(a))}e._billboards=t}}function R(e){var t=16384,r=e.cache.billboardCollection_indexBufferBatched;if(s(r))return r;for(var i=6*t-6,n=new Uint16Array(i),o=0,a=0;i>o;o+=6,a+=4)n[o]=a,n[o+1]=a+1,n[o+2]=a+2,n[o+3]=a+0,n[o+4]=a+2,n[o+5]=a+3;return r=f.createIndexBuffer({context:e,typedArray:n,usage:v.STATIC_DRAW,indexDatatype:d.UNSIGNED_SHORT}),r.vertexArrayDestroyable=!1,e.cache.billboardCollection_indexBufferBatched=r,r}function O(e){var t=e.cache.billboardCollection_indexBufferInstanced;return s(t)?t:(t=f.createIndexBuffer({context:e,typedArray:new Uint16Array([0,1,2,0,2,3]),usage:v.STATIC_DRAW,indexDatatype:d.UNSIGNED_SHORT}),t.vertexArrayDestroyable=!1,e.cache.billboardCollection_indexBufferInstanced=t,t)}function N(e){var t=e.cache.billboardCollection_vertexBufferInstanced;return s(t)?t:(t=f.createVertexBuffer({context:e,typedArray:new Float32Array([0,0,1,0,1,1,0,1]),usage:v.STATIC_DRAW}),t.vertexArrayDestroyable=!1,e.cache.billboardCollection_vertexBufferInstanced=t,t)}function L(e,t,r,i){var n=[{index:Y.positionHighAndScale,componentsPerAttribute:4,componentDatatype:o.FLOAT,usage:r[Z]},{index:Y.positionLowAndRotation,componentsPerAttribute:4,componentDatatype:o.FLOAT,usage:r[Z]},{index:Y.compressedAttribute0,componentsPerAttribute:4,componentDatatype:o.FLOAT,usage:r[K]},{index:Y.compressedAttribute1,componentsPerAttribute:4,componentDatatype:o.FLOAT,usage:r[ae]},{index:Y.compressedAttribute2,componentsPerAttribute:4,componentDatatype:o.FLOAT,usage:r[re]},{index:Y.eyeOffset,componentsPerAttribute:4,componentDatatype:o.FLOAT,usage:r[Q]},{index:Y.scaleByDistance,componentsPerAttribute:4,componentDatatype:o.FLOAT,usage:r[oe]},{index:Y.pixelOffsetScaleByDistance,componentsPerAttribute:4,componentDatatype:o.FLOAT,usage:r[se]}];i&&n.push({index:Y.direction,componentsPerAttribute:2,componentDatatype:o.FLOAT,vertexBuffer:N(e)});var a=i?t:4*t;return new C(e,n,a,i)}function F(e,r,i,n,o){var a,s=n[Y.positionHighAndScale],u=n[Y.positionLowAndRotation],l=o._getActualPosition();e._mode===A.SCENE3D&&(t.expand(e._baseVolume,l,e._baseVolume),e._boundingVolumeDirty=!0),h.fromCartesian(l,me);var c=o.scale,d=o.rotation;0!==d&&(e._shaderRotation=!0),e._maxScale=Math.max(e._maxScale,c);var m=me.high,p=me.low;e._instanced?(a=o._index,s(a,m.x,m.y,m.z,c),u(a,p.x,p.y,p.z,d)):(a=4*o._index,s(a+0,m.x,m.y,m.z,c),s(a+1,m.x,m.y,m.z,c),s(a+2,m.x,m.y,m.z,c),s(a+3,m.x,m.y,m.z,c),u(a+0,p.x,p.y,p.z,d),u(a+1,p.x,p.y,p.z,d),u(a+2,p.x,p.y,p.z,d),u(a+3,p.x,p.y,p.z,d))}function B(t,r,i,n,o){var a,u=n[Y.compressedAttribute0],l=o.pixelOffset,h=l.x,d=l.y,p=o._translate,f=p.x,v=p.y;t._maxPixelOffset=Math.max(t._maxPixelOffset,Math.abs(h+f),Math.abs(-d+v));var g=o.horizontalOrigin,_=o.verticalOrigin,y=o.show;0===o.color.alpha&&(y=!1),t._allHorizontalCenter=t._allHorizontalCenter&&g===x.CENTER,t._allVerticalCenter=t._allVerticalCenter&&_===x.CENTER;var w=0,C=0,E=0,S=0,b=o._imageIndex;if(-1!==b){var T=i[b];if(!s(T))throw new c("Invalid billboard image index: "+b);w=T.x,C=T.y,E=T.width,S=T.height}var P=w+E,A=C+S,I=Math.floor(m.clamp(h,-fe,fe)+fe)*_e;I+=(g+1)*ye,I+=(_+1)*we,I+=(y?1:0)*Ce;var D=Math.floor(m.clamp(d,-fe,fe)+fe)*ge,M=Math.floor(m.clamp(f,-fe,fe)+fe)*ge,R=(m.clamp(v,-fe,fe)+fe)*Ee,O=Math.floor(R),N=Math.floor((R-O)*ge);D+=O,M+=N,pe.x=w,pe.y=C;var L=e.compressTextureCoordinates(pe);pe.x=P;var F=e.compressTextureCoordinates(pe);pe.y=A;var B=e.compressTextureCoordinates(pe);pe.x=w;var z=e.compressTextureCoordinates(pe);t._instanced?(a=o._index,u(a,I,D,M,L)):(a=4*o._index,u(a+0,I+Se,D,M,L),u(a+1,I+be,D,M,F),u(a+2,I+Te,D,M,B),u(a+3,I+xe,D,M,z))}function z(t,r,n,o,u){var l,h=o[Y.compressedAttribute1],d=u.alignedAxis;i.equals(d,i.ZERO)||(t._shaderAlignedAxis=!0);var p=0,f=1,v=1,g=1,_=u.translucencyByDistance;s(_)&&(p=_.near,f=_.nearValue,v=_.far,g=_.farValue,(1!==f||1!==g)&&(t._shaderTranslucencyByDistance=!0));var y=0,w=u._imageIndex;if(-1!==w){var C=n[w];if(!s(C))throw new c("Invalid billboard image index: "+w);y=C.width}var E=t._textureAtlas.texture.width,S=Math.ceil(.5*a(u.width,E*y));t._maxSize=Math.max(t._maxSize,S);var b=m.clamp(S,0,ve),T=0;Math.abs(i.magnitudeSquared(d)-1)<m.EPSILON6&&(T=e.octEncodeFloat(d)),f=m.clamp(f,0,1),f=1===f?255:255*f|0,b=b*ge+f,g=m.clamp(g,0,1),g=1===g?255:255*g|0,T=T*ge+g,t._instanced?(l=u._index,h(l,b,T,p,v)):(l=4*u._index,h(l+0,b,T,p,v),h(l+1,b,T,p,v),h(l+2,b,T,p,v),h(l+3,b,T,p,v))}function V(e,t,r,i,o){var u,l=i[Y.compressedAttribute2],h=o.color,d=o.getPickId(t).color,m=o.sizeInMeters?1:0;e._allSizedInMeters=e._allSizedInMeters&&1===m;var p=0,f=o._imageIndex;if(-1!==f){var v=r[f];if(!s(v))throw new c("Invalid billboard image index: "+f);p=v.height}var g=e._textureAtlas.texture.dimensions,_=Math.ceil(.5*a(o.height,g.y*p));e._maxSize=Math.max(e._maxSize,_);var y=n.floatToByte(h.red),w=n.floatToByte(h.green),C=n.floatToByte(h.blue),E=y*ve+w*ge+C;y=n.floatToByte(d.red),w=n.floatToByte(d.green),C=n.floatToByte(d.blue);var S=y*ve+w*ge+C,b=n.floatToByte(h.alpha)*ve+n.floatToByte(d.alpha)*ge+m;e._instanced?(u=o._index,l(u,E,S,b,_)):(u=4*o._index,l(u+0,E,S,b,_),l(u+1,E,S,b,_),l(u+2,E,S,b,_),l(u+3,E,S,b,_))}function k(t,r,i,n,o){var a,u=n[Y.eyeOffset],l=o.eyeOffset;if(t._maxEyeOffset=Math.max(t._maxEyeOffset,Math.abs(l.x),Math.abs(l.y),Math.abs(l.z)),t._instanced){var h=0,d=0,m=o._imageIndex;if(-1!==m){var p=i[m];if(!s(p))throw new c("Invalid billboard image index: "+m);h=p.width,d=p.height}pe.x=h,pe.y=d;var f=e.compressTextureCoordinates(pe);a=o._index,u(a,l.x,l.y,l.z,f)}else a=4*o._index,u(a+0,l.x,l.y,l.z,0),u(a+1,l.x,l.y,l.z,0),u(a+2,l.x,l.y,l.z,0),u(a+3,l.x,l.y,l.z,0)}function U(e,t,r,i,n){var o,a=i[Y.scaleByDistance],u=0,l=1,c=1,h=1,d=n.scaleByDistance;s(d)&&(u=d.near,l=d.nearValue,c=d.far,h=d.farValue,(1!==l||1!==h)&&(e._shaderScaleByDistance=!0)),e._instanced?(o=n._index,a(o,u,l,c,h)):(o=4*n._index,a(o+0,u,l,c,h),a(o+1,u,l,c,h),a(o+2,u,l,c,h),a(o+3,u,l,c,h))}function q(e,t,r,i,n){var o,a=i[Y.pixelOffsetScaleByDistance],u=0,l=1,c=1,h=1,d=n.pixelOffsetScaleByDistance;s(d)&&(u=d.near,l=d.nearValue,c=d.far,h=d.farValue,(1!==l||1!==h)&&(e._shaderPixelOffsetScaleByDistance=!0)),e._instanced?(o=n._index,a(o,u,l,c,h)):(o=4*n._index,a(o+0,u,l,c,h),a(o+1,u,l,c,h),a(o+2,u,l,c,h),a(o+3,u,l,c,h))}function G(e,t,r,i,n){F(e,t,r,i,n),B(e,t,r,i,n),z(e,t,r,i,n),V(e,t,r,i,n),k(e,t,r,i,n),U(e,t,r,i,n),q(e,t,r,i,n)}function W(e,r,i,n,o,a){var u;n.mode===A.SCENE3D?(u=e._baseVolume,e._boundingVolumeDirty=!0):u=e._baseVolume2D;for(var l=[],c=0;i>c;++c){var h=r[c],d=h.position,m=b._computeActualPosition(h,d,n,o);s(m)&&(h._setActualPosition(m),a?l.push(m):t.expand(u,m,u))}a&&t.fromPoints(l,u)}function H(e,t){var r=t.mode,i=e._billboards,n=e._billboardsToUpdate,o=e._modelMatrix;e._createVertexArray||e._mode!==r||r!==A.SCENE3D&&!p.equals(o,e.modelMatrix)?(e._mode=r,p.clone(e.modelMatrix,o),e._createVertexArray=!0,(r===A.SCENE3D||r===A.SCENE2D||r===A.COLUMBUS_VIEW)&&W(e,i,i.length,t,o,!0)):r===A.MORPHING?W(e,i,i.length,t,o,!0):(r===A.SCENE2D||r===A.COLUMBUS_VIEW)&&W(e,n,e._billboardsToUpdateIndex,t,o,!1)}function j(e,t,r){var n=1;if(!e._allSizedInMeters||0!==e._maxPixelOffset){var o=t.camera,a=o.frustum,s=i.subtract(o.positionWC,r.center,Ae),u=i.multiplyByScalar(o.directionWC,i.dot(s,o.directionWC),Ie),l=Math.max(0,i.magnitude(u)-r.radius),c=t.context,h=a.getPixelDimensions(c.drawingBufferWidth,c.drawingBufferHeight,l,Pe);n=Math.max(h.x,h.y)}var d=n*e._maxScale*e._maxSize*2;e._allHorizontalCenter&&e._allVerticalCenter&&(d*=.5);var m=n*e._maxPixelOffset+e._maxEyeOffset;r.radius+=d+m}var Y,X=b.SHOW_INDEX,Z=b.POSITION_INDEX,K=b.PIXEL_OFFSET_INDEX,Q=b.EYE_OFFSET_INDEX,J=b.HORIZONTAL_ORIGIN_INDEX,$=b.VERTICAL_ORIGIN_INDEX,ee=b.SCALE_INDEX,te=b.IMAGE_INDEX_INDEX,re=b.COLOR_INDEX,ie=b.ROTATION_INDEX,ne=b.ALIGNED_AXIS_INDEX,oe=b.SCALE_BY_DISTANCE_INDEX,ae=b.TRANSLUCENCY_BY_DISTANCE_INDEX,se=b.PIXEL_OFFSET_SCALE_BY_DISTANCE_INDEX,ue=b.NUMBER_OF_PROPERTIES,le={positionHighAndScale:0,positionLowAndRotation:1,compressedAttribute0:2,compressedAttribute1:3,compressedAttribute2:4,eyeOffset:5,scaleByDistance:6,pixelOffsetScaleByDistance:7},ce={direction:0,positionHighAndScale:1,positionLowAndRotation:2,compressedAttribute0:3,compressedAttribute1:4,compressedAttribute2:5,eyeOffset:6,scaleByDistance:7,pixelOffsetScaleByDistance:8},he=function(e){e=a(e,a.EMPTY_OBJECT),this._scene=e.scene,this._textureAtlas=void 0,this._textureAtlasGUID=void 0,this._destroyTextureAtlas=!0,this._sp=void 0,this._rs=void 0,this._vaf=void 0,this._spPick=void 0,this._billboards=[],this._billboardsToUpdate=[],this._billboardsToUpdateIndex=0,this._billboardsRemoved=!1,this._createVertexArray=!1,this._shaderRotation=!1,this._compiledShaderRotation=!1,this._compiledShaderRotationPick=!1,this._shaderAlignedAxis=!1,this._compiledShaderAlignedAxis=!1,this._compiledShaderAlignedAxisPick=!1,this._shaderScaleByDistance=!1,this._compiledShaderScaleByDistance=!1,this._compiledShaderScaleByDistancePick=!1,this._shaderTranslucencyByDistance=!1,this._compiledShaderTranslucencyByDistance=!1,this._compiledShaderTranslucencyByDistancePick=!1,this._shaderPixelOffsetScaleByDistance=!1,this._compiledShaderPixelOffsetScaleByDistance=!1,this._compiledShaderPixelOffsetScaleByDistancePick=!1,this._propertiesChanged=new Uint32Array(ue),this._maxSize=0,this._maxEyeOffset=0,this._maxScale=1,this._maxPixelOffset=0,this._allHorizontalCenter=!0,this._allVerticalCenter=!0,this._allSizedInMeters=!0,this._baseVolume=new t,this._baseVolumeWC=new t,this._baseVolume2D=new t,this._boundingVolume=new t,this._boundingVolumeDirty=!1,this._colorCommands=[],this._pickCommands=[],this.modelMatrix=p.clone(a(e.modelMatrix,p.IDENTITY)),this._modelMatrix=p.clone(p.IDENTITY),this.debugShowBoundingVolume=a(e.debugShowBoundingVolume,!1),this._mode=A.SCENE3D,this._buffersUsage=[v.STATIC_DRAW,v.STATIC_DRAW,v.STATIC_DRAW,v.STATIC_DRAW,v.STATIC_DRAW,v.STATIC_DRAW,v.STATIC_DRAW,v.STATIC_DRAW,v.STATIC_DRAW,v.STATIC_DRAW,v.STATIC_DRAW,v.STATIC_DRAW,v.STATIC_DRAW,v.STATIC_DRAW];var r=this;this._uniforms={u_atlas:function(){return r._textureAtlas.texture}}};u(he.prototype,{length:{get:function(){return M(this),this._billboards.length}},textureAtlas:{get:function(){return this._textureAtlas},set:function(e){this._textureAtlas!==e&&(this._textureAtlas=this._destroyTextureAtlas&&this._textureAtlas&&this._textureAtlas.destroy(),this._textureAtlas=e,this._createVertexArray=!0)}},destroyTextureAtlas:{get:function(){return this._destroyTextureAtlas},set:function(e){this._destroyTextureAtlas=e}}}),he.prototype.add=function(e){var t=new b(e,this);return t._index=this._billboards.length,this._billboards.push(t),this._createVertexArray=!0,t},he.prototype.remove=function(e){return this.contains(e)?(this._billboards[e._index]=null,this._billboardsRemoved=!0,this._createVertexArray=!0,e._destroy(),!0):!1},he.prototype.removeAll=function(){D(this._billboards),this._billboards=[],this._billboardsToUpdate=[],this._billboardsToUpdateIndex=0,this._billboardsRemoved=!1,this._createVertexArray=!0},he.prototype._updateBillboard=function(e,t){e._dirty||(this._billboardsToUpdate[this._billboardsToUpdateIndex++]=e),++this._propertiesChanged[t]},he.prototype.contains=function(e){return s(e)&&e._billboardCollection===this},he.prototype.get=function(e){if(!s(e))throw new c("index is required.");return M(this),this._billboards[e]};var de;he.prototype.computeNewBuffersUsage=function(){for(var e=this._buffersUsage,t=!1,r=this._propertiesChanged,i=0;ue>i;++i){var n=0===r[i]?v.STATIC_DRAW:v.STREAM_DRAW;t=t||e[i]!==n,e[i]=n}return t};var me=new h,pe=new r,fe=32768,ve=65536,ge=256,_e=128,ye=32,we=8,Ce=4,Ee=1/256,Se=0,be=2,Te=3,xe=1,Pe=new r,Ae=new i,Ie=new i,De=[];return he.prototype.update=function(e){M(this);var r=this._billboards,i=r.length,n=e.context;this._instanced=n.instancedArrays,Y=this._instanced?ce:le,de=this._instanced?O:R;var o=this._textureAtlas;if(!s(o)){o=this._textureAtlas=new I({context:n});for(var a=0;i>a;++a)r[a]._loadImage()}var u=o.textureCoordinates;if(0!==u.length){H(this,e),r=this._billboards,i=r.length;var l=this._billboardsToUpdate,c=this._billboardsToUpdateIndex,h=this._propertiesChanged,d=o.guid,m=this._createVertexArray||this._textureAtlasGUID!==d;this._textureAtlasGUID=d;var f,v=e.passes,C=v.pick;if(m||!C&&this.computeNewBuffersUsage()){this._createVertexArray=!1;for(var b=0;ue>b;++b)h[b]=0;if(this._vaf=this._vaf&&this._vaf.destroy(),i>0){this._vaf=L(n,i,this._buffersUsage,this._instanced),f=this._vaf.writers;for(var x=0;i>x;++x){var D=this._billboards[x];D._dirty=!1,G(this,n,u,f,D)}this._vaf.commit(de(n))}this._billboardsToUpdateIndex=0}else if(c>0){var N=De;N.length=0,(h[Z]||h[ie]||h[ee])&&N.push(F),(h[te]||h[K]||h[J]||h[$]||h[X])&&(N.push(B),this._instanced&&N.push(k)),(h[te]||h[ne]||h[ae])&&N.push(z),(h[te]||h[re])&&N.push(V),h[Q]&&N.push(k),h[oe]&&N.push(U),h[se]&&N.push(q);var W=N.length;if(f=this._vaf.writers,c/i>.1){for(var he=0;c>he;++he){var me=l[he];me._dirty=!1;for(var pe=0;W>pe;++pe)N[pe](this,n,u,f,me)}this._vaf.commit(de(n))}else{for(var fe=0;c>fe;++fe){var ve=l[fe];ve._dirty=!1;for(var ge=0;W>ge;++ge)N[ge](this,n,u,f,ve);this._instanced?this._vaf.subCommit(ve._index,1):this._vaf.subCommit(4*ve._index,4)}this._vaf.endSubCommits()}this._billboardsToUpdateIndex=0}if(c>1.5*i&&(l.length=i),s(this._vaf)&&s(this._vaf.va)){this._boundingVolumeDirty&&(this._boundingVolumeDirty=!1,t.transform(this._baseVolume,this.modelMatrix,this._baseVolumeWC));var _e,ye=p.IDENTITY;e.mode===A.SCENE3D?(ye=this.modelMatrix,_e=t.clone(this._baseVolumeWC,this._boundingVolume)):_e=t.clone(this._baseVolume2D,this._boundingVolume),j(this,e,_e);var we,Ce,Ee,Se,be,Te,xe=e.commandList;if(v.render){var Pe=this._colorCommands;for(s(this._rs)||(this._rs=_.fromCache({depthTest:{enabled:!0},blending:T.ALPHA_BLEND})),s(this._sp)&&this._shaderRotation===this._compiledShaderRotation&&this._shaderAlignedAxis===this._compiledShaderAlignedAxis&&this._shaderScaleByDistance===this._compiledShaderScaleByDistance&&this._shaderTranslucencyByDistance===this._compiledShaderTranslucencyByDistance&&this._shaderPixelOffsetScaleByDistance===this._compiledShaderPixelOffsetScaleByDistance||(Se=new w({sources:[S]}),this._instanced&&Se.defines.push("INSTANCED"),this._shaderRotation&&Se.defines.push("ROTATION"),this._shaderAlignedAxis&&Se.defines.push("ALIGNED_AXIS"),this._shaderScaleByDistance&&Se.defines.push("EYE_DISTANCE_SCALING"),this._shaderTranslucencyByDistance&&Se.defines.push("EYE_DISTANCE_TRANSLUCENCY"),this._shaderPixelOffsetScaleByDistance&&Se.defines.push("EYE_DISTANCE_PIXEL_OFFSET"),s(this._scene)&&Se.defines.push("CLAMPED_TO_GROUND"),this._sp=y.replaceCache({context:n,shaderProgram:this._sp,vertexShaderSource:Se,fragmentShaderSource:E,attributeLocations:Y}),this._compiledShaderRotation=this._shaderRotation,this._compiledShaderAlignedAxis=this._shaderAlignedAxis,this._compiledShaderScaleByDistance=this._shaderScaleByDistance,this._compiledShaderTranslucencyByDistance=this._shaderTranslucencyByDistance,this._compiledShaderPixelOffsetScaleByDistance=this._shaderPixelOffsetScaleByDistance),we=this._vaf.va,Ce=we.length,Pe.length=Ce,Te=0;Ce>Te;++Te)Ee=Pe[Te],s(Ee)||(Ee=Pe[Te]=new g({pass:P.OPAQUE,owner:this})),Ee.boundingVolume=_e,Ee.modelMatrix=ye,Ee.count=we[Te].indicesCount,Ee.shaderProgram=this._sp,Ee.uniformMap=this._uniforms,Ee.vertexArray=we[Te].va,Ee.renderState=this._rs,Ee.debugShowBoundingVolume=this.debugShowBoundingVolume,this._instanced&&(Ee.count=6,Ee.instanceCount=i),xe.push(Ee)}if(C){var Ae=this._pickCommands;for(s(this._spPick)&&this._shaderRotation===this._compiledShaderRotationPick&&this._shaderAlignedAxis===this._compiledShaderAlignedAxisPick&&this._shaderScaleByDistance===this._compiledShaderScaleByDistancePick&&this._shaderTranslucencyByDistance===this._compiledShaderTranslucencyByDistancePick&&this._shaderPixelOffsetScaleByDistance===this._compiledShaderPixelOffsetScaleByDistancePick||(Se=new w({defines:["RENDER_FOR_PICK"],sources:[S]}),this._instanced&&Se.defines.push("INSTANCED"),this._shaderRotation&&Se.defines.push("ROTATION"),this._shaderAlignedAxis&&Se.defines.push("ALIGNED_AXIS"),this._shaderScaleByDistance&&Se.defines.push("EYE_DISTANCE_SCALING"),this._shaderTranslucencyByDistance&&Se.defines.push("EYE_DISTANCE_TRANSLUCENCY"),this._shaderPixelOffsetScaleByDistance&&Se.defines.push("EYE_DISTANCE_PIXEL_OFFSET"),s(this._scene)&&Se.defines.push("CLAMPED_TO_GROUND"),be=new w({defines:["RENDER_FOR_PICK"],sources:[E]}),this._spPick=y.replaceCache({context:n,shaderProgram:this._spPick,vertexShaderSource:Se,fragmentShaderSource:be,attributeLocations:Y}),this._compiledShaderRotationPick=this._shaderRotation,this._compiledShaderAlignedAxisPick=this._shaderAlignedAxis,this._compiledShaderScaleByDistancePick=this._shaderScaleByDistance,this._compiledShaderTranslucencyByDistancePick=this._shaderTranslucencyByDistance,this._compiledShaderPixelOffsetScaleByDistancePick=this._shaderPixelOffsetScaleByDistance),we=this._vaf.va,Ce=we.length,Ae.length=Ce,Te=0;Ce>Te;++Te)Ee=Ae[Te],s(Ee)||(Ee=Ae[Te]=new g({pass:P.OPAQUE,owner:this})),Ee.boundingVolume=_e,Ee.modelMatrix=ye,Ee.count=we[Te].indicesCount,Ee.shaderProgram=this._spPick,Ee.uniformMap=this._uniforms,Ee.vertexArray=we[Te].va,Ee.renderState=this._rs,this._instanced&&(Ee.count=6,Ee.instanceCount=i),xe.push(Ee)}}}},he.prototype.isDestroyed=function(){return!1},he.prototype.destroy=function(){return this._textureAtlas=this._destroyTextureAtlas&&this._textureAtlas&&this._textureAtlas.destroy(),this._sp=this._sp&&this._sp.destroy(),this._spPick=this._spPick&&this._spPick.destroy(),this._vaf=this._vaf&&this._vaf.destroy(),D(this._billboards),l(this)},he}),r("DataSources/BoundingSphereState",["../Core/freezeObject"],function(e){"use strict";var t={DONE:0,PENDING:1,FAILED:2};return e(t)}),r("DataSources/Property",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Iso8601"],function(e,t,r,i,n){"use strict";var o=function(){i.throwInstantiationError()};return r(o.prototype,{isConstant:{get:i.throwInstantiationError},definitionChanged:{get:i.throwInstantiationError}}),o.prototype.getValue=i.throwInstantiationError,o.prototype.equals=i.throwInstantiationError,o.equals=function(e,r){return e===r||t(e)&&e.equals(r)},o.arrayEquals=function(e,r){if(e===r)return!0;if(!t(e)||!t(r)||e.length!==r.length)return!1;for(var i=e.length,n=0;i>n;n++)if(!o.equals(e[n],r[n]))return!1;return!0},o.isConstant=function(e){return!t(e)||e.isConstant},o.getValueOrUndefined=function(e,r,i){return t(e)?e.getValue(r,i):void 0},o.getValueOrDefault=function(r,i,n,o){return t(r)?e(r.getValue(i,o),n):n},o.getValueOrClonedDefault=function(e,r,i,n){var o;return t(e)&&(o=e.getValue(r,n)),t(o)||(o=i.clone(o)),o},o}),r("DataSources/BillboardVisualizer",["../Core/AssociativeArray","../Core/BoundingRectangle","../Core/Cartesian2","../Core/Cartesian3","../Core/Color","../Core/defined","../Core/destroyObject","../Core/DeveloperError","../Core/NearFarScalar","../Scene/BillboardCollection","../Scene/HorizontalOrigin","../Scene/VerticalOrigin","./BoundingSphereState","./Property"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m){"use strict";function p(e,t){if(o(e)){var r=e.billboard;o(r)&&(e.textureValue=void 0,e.billboard=void 0,r.show=!1,r.image=void 0,t.push(r._index))}}var f=n.WHITE,v=i.ZERO,g=r.ZERO,_=1,y=0,w=i.ZERO,C=c.CENTER,E=h.CENTER,S=!1,b=new i,T=new n,x=new i,P=new r,A=new u,I=new u,D=new u,M=new t,R=function(e){this.entity=e,this.billboard=void 0,this.textureValue=void 0},O=function(t,r){if(!o(t))throw new s("scene is required.");if(!o(r))throw new s("entityCollection is required.");r.collectionChanged.addEventListener(O.prototype._onCollectionChanged,this),this._scene=t,this._unusedIndexes=[],this._billboardCollection=void 0,this._entityCollection=r,this._items=new e,this._onCollectionChanged(r,r.values,[],[])};return O.prototype.update=function(e){if(!o(e))throw new s("time is required.");for(var t=this._items.values,r=this._unusedIndexes,i=0,n=t.length;n>i;i++){var a,u=t[i],c=u.entity,h=c._billboard,d=u.billboard,R=c.isShowing&&c.isAvailable(e)&&m.getValueOrDefault(h._show,e,!0);if(R&&(b=m.getValueOrUndefined(c._position,e,b),a=m.getValueOrUndefined(h._image,e),R=o(b)&&o(a)),R){if(!o(d)){var O=this._billboardCollection;o(O)||(O=new l,this._billboardCollection=O,this._scene.primitives.add(O));var N=r.length;d=N>0?O.get(r.pop()):O.add(),d.id=c,d.image=void 0,u.billboard=d}d.show=R,u.textureValue!==a&&(d.image=a,u.textureValue=a),d.position=b,d.color=m.getValueOrDefault(h._color,e,f,T),d.eyeOffset=m.getValueOrDefault(h._eyeOffset,e,v,x),d.pixelOffset=m.getValueOrDefault(h._pixelOffset,e,g,P),d.scale=m.getValueOrDefault(h._scale,e,_),d.rotation=m.getValueOrDefault(h._rotation,e,y),d.alignedAxis=m.getValueOrDefault(h._alignedAxis,e,w),d.horizontalOrigin=m.getValueOrDefault(h._horizontalOrigin,e,C),d.verticalOrigin=m.getValueOrDefault(h._verticalOrigin,e,E),d.width=m.getValueOrUndefined(h._width,e),d.height=m.getValueOrUndefined(h._height,e),d.scaleByDistance=m.getValueOrUndefined(h._scaleByDistance,e,A),d.translucencyByDistance=m.getValueOrUndefined(h._translucencyByDistance,e,I),d.pixelOffsetScaleByDistance=m.getValueOrUndefined(h._pixelOffsetScaleByDistance,e,D),d.sizeInMeters=m.getValueOrDefault(h._sizeInMeters,S);var L=m.getValueOrUndefined(h._imageSubRegion,e,M);o(L)&&d.setImageSubRegion(d._imageId,L)}else p(u,r)}return!0},O.prototype.getBoundingSphere=function(e,t){if(!o(e))throw new s("entity is required.");if(!o(t))throw new s("result is required.");var r=this._items.get(e.id);return o(r)&&o(r.billboard)?(t.center=i.clone(r.billboard.position,t.center),t.radius=0,d.DONE):d.FAILED},O.prototype.isDestroyed=function(){return!1},O.prototype.destroy=function(){return this._entityCollection.collectionChanged.removeEventListener(O.prototype._onCollectionChanged,this),o(this._billboardCollection)&&this._scene.primitives.remove(this._billboardCollection),a(this)},O.prototype._onCollectionChanged=function(e,t,r,i){var n,a,s=this._unusedIndexes,u=this._items;for(n=t.length-1;n>-1;n--)a=t[n],o(a._billboard)&&o(a._position)&&u.set(a.id,new R(a));for(n=i.length-1;n>-1;n--)a=i[n],o(a._billboard)&&o(a._position)?u.contains(a.id)||u.set(a.id,new R(a)):(p(u.get(a.id),s),u.remove(a.id));for(n=r.length-1;n>-1;n--)a=r[n],p(u.get(a.id),s),u.remove(a.id)},O}),r("Shaders/Appearances/AllMaterialAppearanceFS",[],function(){"use strict";return"varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec3 v_tangentEC;\nvarying vec3 v_binormalEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nmat3 tangentToEyeMatrix = czm_tangentToEyeSpaceMatrix(v_normalEC, v_tangentEC, v_binormalEC);\nvec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.tangentToEyeMatrix = tangentToEyeMatrix;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nmaterialInput.st = v_st;\nczm_material material = czm_getMaterial(materialInput);\n#ifdef FLAT\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material);\n#endif\n}\n"}),r("Shaders/Appearances/AllMaterialAppearanceVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute vec3 tangent;\nattribute vec3 binormal;\nattribute vec2 st;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec3 v_tangentEC;\nvarying vec3 v_binormalEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\nv_tangentEC = czm_normal * tangent;\nv_binormalEC = czm_normal * binormal;\nv_st = st;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n"}),r("Shaders/Appearances/BasicMaterialAppearanceFS",[],function(){"use strict";return"varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nvec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nczm_material material = czm_getMaterial(materialInput);\n#ifdef FLAT\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material);\n#endif\n}\n"}),r("Shaders/Appearances/BasicMaterialAppearanceVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n"}),r("Shaders/Appearances/TexturedMaterialAppearanceFS",[],function(){"use strict";return"varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nvec3 normalEC = normalize(v_normalEC);;\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nmaterialInput.st = v_st;\nczm_material material = czm_getMaterial(materialInput);\n#ifdef FLAT\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n#else\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material);\n#endif\n}\n";
}),r("Shaders/Appearances/TexturedMaterialAppearanceVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute vec2 st;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec2 v_st;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\nv_st = st;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n"}),r("Scene/CullFace",["../Core/freezeObject","../Renderer/WebGLConstants"],function(e,t){"use strict";var r={FRONT:t.FRONT,BACK:t.BACK,FRONT_AND_BACK:t.FRONT_AND_BACK};return e(r)}),r("Scene/Appearance",["../Core/clone","../Core/combine","../Core/defaultValue","../Core/defined","../Core/defineProperties","./BlendingState","./CullFace"],function(e,t,r,i,n,o,a){"use strict";var s=function(e){e=r(e,r.EMPTY_OBJECT),this.material=e.material,this.translucent=r(e.translucent,!0),this._vertexShaderSource=e.vertexShaderSource,this._fragmentShaderSource=e.fragmentShaderSource,this._renderState=e.renderState,this._closed=r(e.closed,!1)};return n(s.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}}}),s.prototype.getFragmentShaderSource=function(){var e=[];return this.flat&&e.push("#define FLAT"),this.faceForward&&e.push("#define FACE_FORWARD"),i(this.material)&&e.push(this.material.shaderSource),e.push(this.fragmentShaderSource),e.join("\n")},s.prototype.isTranslucent=function(){return i(this.material)&&this.material.isTranslucent()||!i(this.material)&&this.translucent},s.prototype.getRenderState=function(){var t=this.isTranslucent(),r=e(this.renderState,!1);return t?(r.depthMask=!1,r.blending=o.ALPHA_BLEND):r.depthMask=!0,r},s.getDefaultRenderState=function(e,r,n){var s={depthTest:{enabled:!0}};return e&&(s.depthMask=!1,s.blending=o.ALPHA_BLEND),r&&(s.cull={enabled:!0,face:a.BACK}),i(n)&&(s=t(n,s,!0)),s},s}),r("Renderer/CubeMapFace",["../Core/defaultValue","../Core/defineProperties","../Core/DeveloperError","./PixelDatatype"],function(e,t,r,i){"use strict";var n=function(e,t,r,i,n,o,a,s,u){this._gl=e,this._texture=t,this._textureTarget=r,this._targetFace=i,this._pixelFormat=n,this._pixelDatatype=o,this._size=a,this._preMultiplyAlpha=s,this._flipY=u};return t(n.prototype,{pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},_target:{get:function(){return this._targetFace}}}),n.prototype.copyFrom=function(t,i,n){if(i=e(i,0),n=e(n,0),!t)throw new r("source is required.");if(0>i)throw new r("xOffset must be greater than or equal to zero.");if(0>n)throw new r("yOffset must be greater than or equal to zero.");if(i+t.width>this._size)throw new r("xOffset + source.width must be less than or equal to width.");if(n+t.height>this._size)throw new r("yOffset + source.height must be less than or equal to height.");var o=this._gl,a=this._textureTarget;o.pixelStorei(o.UNPACK_PREMULTIPLY_ALPHA_WEBGL,this._preMultiplyAlpha),o.pixelStorei(o.UNPACK_FLIP_Y_WEBGL,this._flipY),o.activeTexture(o.TEXTURE0),o.bindTexture(a,this._texture),t.arrayBufferView?o.texSubImage2D(this._targetFace,0,i,n,t.width,t.height,this._pixelFormat,this._pixelDatatype,t.arrayBufferView):o.texSubImage2D(this._targetFace,0,i,n,this._pixelFormat,this._pixelDatatype,t),o.bindTexture(a,null)},n.prototype.copyFromFramebuffer=function(t,n,o,a,s,u){if(t=e(t,0),n=e(n,0),o=e(o,0),a=e(a,0),s=e(s,this._size),u=e(u,this._size),0>t)throw new r("xOffset must be greater than or equal to zero.");if(0>n)throw new r("yOffset must be greater than or equal to zero.");if(0>o)throw new r("framebufferXOffset must be greater than or equal to zero.");if(0>a)throw new r("framebufferYOffset must be greater than or equal to zero.");if(t+s>this._size)throw new r("xOffset + source.width must be less than or equal to width.");if(n+u>this._size)throw new r("yOffset + source.height must be less than or equal to height.");if(this._pixelDatatype===i.FLOAT)throw new r("Cannot call copyFromFramebuffer when the texture pixel data type is FLOAT.");var l=this._gl,c=this._textureTarget;l.activeTexture(l.TEXTURE0),l.bindTexture(c,this._texture),l.copyTexSubImage2D(this._targetFace,0,t,n,o,a,s,u),l.bindTexture(c,null)},n}),r("Renderer/CubeMap",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Math","../Core/PixelFormat","./ContextLimits","./CubeMapFace","./MipmapHint","./PixelDatatype","./Sampler","./TextureMagnificationFilter","./TextureMinificationFilter","./TextureWrap"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p){"use strict";var f=function(r){function i(e,t){t.arrayBufferView?C.texImage2D(e,0,g,v,v,0,g,_,t.arrayBufferView):C.texImage2D(e,0,g,g,_,t)}if(r=e(r,e.EMPTY_OBJECT),!t(r.context))throw new n("options.context is required.");var o,l,d=r.context,m=r.source;if(t(m)){var p=[m.positiveX,m.negativeX,m.positiveY,m.negativeY,m.positiveZ,m.negativeZ];if(!(p[0]&&p[1]&&p[2]&&p[3]&&p[4]&&p[5]))throw new n("options.source requires positiveX, negativeX, positiveY, negativeY, positiveZ, and negativeZ faces.");o=p[0].width,l=p[0].height;for(var f=1;6>f;++f)if(Number(p[f].width)!==o||Number(p[f].height)!==l)throw new n("Each face in options.source must have the same width and height.")}else o=r.width,l=r.height;var v=o,g=e(r.pixelFormat,a.RGBA),_=e(r.pixelDatatype,c.UNSIGNED_BYTE);if(!t(o)||!t(l))throw new n("options requires a source field to create an initialized cube map or width and height fields to create a blank cube map.");if(o!==l)throw new n("Width must equal height.");if(0>=v)throw new n("Width and height must be greater than zero.");if(v>s.maximumCubeMapSize)throw new n("Width and height must be less than or equal to the maximum cube map size ("+s.maximumCubeMapSize+").  Check maximumCubeMapSize.");if(!a.validate(g))throw new n("Invalid options.pixelFormat.");if(a.isDepthFormat(g))throw new n("options.pixelFormat cannot be DEPTH_COMPONENT or DEPTH_STENCIL.");if(!c.validate(_))throw new n("Invalid options.pixelDatatype.");if(_===c.FLOAT&&!d.floatingPointTexture)throw new n("When options.pixelDatatype is FLOAT, this WebGL implementation must support the OES_texture_float extension.");var y=r.preMultiplyAlpha||g===a.RGB||g===a.LUMINANCE,w=e(r.flipY,!0),C=d._gl,E=C.TEXTURE_CUBE_MAP,S=C.createTexture();C.activeTexture(C.TEXTURE0),C.bindTexture(E,S),t(m)?(C.pixelStorei(C.UNPACK_PREMULTIPLY_ALPHA_WEBGL,y),C.pixelStorei(C.UNPACK_FLIP_Y_WEBGL,w),i(C.TEXTURE_CUBE_MAP_POSITIVE_X,m.positiveX),i(C.TEXTURE_CUBE_MAP_NEGATIVE_X,m.negativeX),i(C.TEXTURE_CUBE_MAP_POSITIVE_Y,m.positiveY),i(C.TEXTURE_CUBE_MAP_NEGATIVE_Y,m.negativeY),i(C.TEXTURE_CUBE_MAP_POSITIVE_Z,m.positiveZ),i(C.TEXTURE_CUBE_MAP_NEGATIVE_Z,m.negativeZ)):(C.texImage2D(C.TEXTURE_CUBE_MAP_POSITIVE_X,0,g,v,v,0,g,_,null),C.texImage2D(C.TEXTURE_CUBE_MAP_NEGATIVE_X,0,g,v,v,0,g,_,null),C.texImage2D(C.TEXTURE_CUBE_MAP_POSITIVE_Y,0,g,v,v,0,g,_,null),C.texImage2D(C.TEXTURE_CUBE_MAP_NEGATIVE_Y,0,g,v,v,0,g,_,null),C.texImage2D(C.TEXTURE_CUBE_MAP_POSITIVE_Z,0,g,v,v,0,g,_,null),C.texImage2D(C.TEXTURE_CUBE_MAP_NEGATIVE_Z,0,g,v,v,0,g,_,null)),C.bindTexture(E,null),this._gl=C,this._textureFilterAnisotropic=d._textureFilterAnisotropic,this._textureTarget=E,this._texture=S,this._pixelFormat=g,this._pixelDatatype=_,this._size=v,this._preMultiplyAlpha=y,this._flipY=w,this._sampler=void 0,this._positiveX=new u(C,S,E,C.TEXTURE_CUBE_MAP_POSITIVE_X,g,_,v,y,w),this._negativeX=new u(C,S,E,C.TEXTURE_CUBE_MAP_NEGATIVE_X,g,_,v,y,w),this._positiveY=new u(C,S,E,C.TEXTURE_CUBE_MAP_POSITIVE_Y,g,_,v,y,w),this._negativeY=new u(C,S,E,C.TEXTURE_CUBE_MAP_NEGATIVE_Y,g,_,v,y,w),this._positiveZ=new u(C,S,E,C.TEXTURE_CUBE_MAP_POSITIVE_Z,g,_,v,y,w),this._negativeZ=new u(C,S,E,C.TEXTURE_CUBE_MAP_NEGATIVE_Z,g,_,v,y,w),this.sampler=new h};return r(f.prototype,{positiveX:{get:function(){return this._positiveX}},negativeX:{get:function(){return this._negativeX}},positiveY:{get:function(){return this._positiveY}},negativeY:{get:function(){return this._negativeY}},positiveZ:{get:function(){return this._positiveZ}},negativeZ:{get:function(){return this._negativeZ}},sampler:{get:function(){return this._sampler},set:function(e){var r=e.minificationFilter,i=e.magnificationFilter,n=r===m.NEAREST_MIPMAP_NEAREST||r===m.NEAREST_MIPMAP_LINEAR||r===m.LINEAR_MIPMAP_NEAREST||r===m.LINEAR_MIPMAP_LINEAR;this._pixelDatatype===c.FLOAT&&(r=n?m.NEAREST_MIPMAP_NEAREST:m.NEAREST,i=d.NEAREST);var o=this._gl,a=this._textureTarget;o.activeTexture(o.TEXTURE0),o.bindTexture(a,this._texture),o.texParameteri(a,o.TEXTURE_MIN_FILTER,r),o.texParameteri(a,o.TEXTURE_MAG_FILTER,i),o.texParameteri(a,o.TEXTURE_WRAP_S,e.wrapS),o.texParameteri(a,o.TEXTURE_WRAP_T,e.wrapT),t(this._textureFilterAnisotropic)&&o.texParameteri(a,this._textureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,e.maximumAnisotropy),o.bindTexture(a,null),this._sampler=e}},pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},width:{get:function(){return this._size}},height:{get:function(){return this._size}},preMultiplyAlpha:{get:function(){return this._preMultiplyAlpha}},flipY:{get:function(){return this._flipY}},_target:{get:function(){return this._textureTarget}}}),f.prototype.generateMipmap=function(t){if(t=e(t,l.DONT_CARE),this._size>1&&!o.isPowerOfTwo(this._size))throw new n("width and height must be a power of two to call generateMipmap().");if(!l.validate(t))throw new n("hint is invalid.");var r=this._gl,i=this._textureTarget;r.hint(r.GENERATE_MIPMAP_HINT,t),r.activeTexture(r.TEXTURE0),r.bindTexture(i,this._texture),r.generateMipmap(i),r.bindTexture(i,null)},f.prototype.isDestroyed=function(){return!1},f.prototype.destroy=function(){return this._gl.deleteTexture(this._texture),this._positiveX=i(this._positiveX),this._negativeX=i(this._negativeX),this._positiveY=i(this._positiveY),this._negativeY=i(this._negativeY),this._positiveZ=i(this._positiveZ),this._negativeZ=i(this._negativeZ),i(this)},f}),r("Shaders/Materials/BumpMapMaterial",[],function(){"use strict";return"uniform sampler2D image;\nuniform float strength;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nvec2 centerPixel = fract(repeat * st);\nfloat centerBump = texture2D(image, centerPixel).channel;\nfloat imageWidth = float(imageDimensions.x);\nvec2 rightPixel = fract(repeat * (st + vec2(1.0 / imageWidth, 0.0)));\nfloat rightBump = texture2D(image, rightPixel).channel;\nfloat imageHeight = float(imageDimensions.y);\nvec2 leftPixel = fract(repeat * (st + vec2(0.0, 1.0 / imageHeight)));\nfloat topBump = texture2D(image, leftPixel).channel;\nvec3 normalTangentSpace = normalize(vec3(centerBump - rightBump, centerBump - topBump, clamp(1.0 - strength, 0.1, 1.0)));\nvec3 normalEC = materialInput.tangentToEyeMatrix * normalTangentSpace;\nmaterial.normal = normalEC;\nmaterial.diffuse = vec3(0.01);\nreturn material;\n}\n"}),r("Shaders/Materials/CheckerboardMaterial",[],function(){"use strict";return"uniform vec4 lightColor;\nuniform vec4 darkColor;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat b = mod(floor(repeat.s * st.s) + floor(repeat.t * st.t), 2.0);\nfloat scaledWidth = fract(repeat.s * st.s);\nscaledWidth = abs(scaledWidth - floor(scaledWidth + 0.5));\nfloat scaledHeight = fract(repeat.t * st.t);\nscaledHeight = abs(scaledHeight - floor(scaledHeight + 0.5));\nfloat value = min(scaledWidth, scaledHeight);\nvec4 currentColor = mix(lightColor, darkColor, b);\nvec4 color = czm_antialias(lightColor, darkColor, currentColor, value, 0.03);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n"}),r("Shaders/Materials/DotMaterial",[],function(){"use strict";return"uniform vec4 lightColor;\nuniform vec4 darkColor;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat b = smoothstep(0.3, 0.32, length(fract(repeat * materialInput.st) - 0.5));\nvec4 color = mix(lightColor, darkColor, b);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n"}),r("Shaders/Materials/FadeMaterial",[],function(){"use strict";return"uniform vec4 fadeInColor;\nuniform vec4 fadeOutColor;\nuniform float maximumDistance;\nuniform bool repeat;\nuniform vec2 fadeDirection;\nuniform vec2 time;\nfloat getTime(float t, float coord)\n{\nfloat scalar = 1.0 / maximumDistance;\nfloat q  = distance(t, coord) * scalar;\nif (repeat)\n{\nfloat r = distance(t, coord + 1.0) * scalar;\nfloat s = distance(t, coord - 1.0) * scalar;\nq = min(min(r, s), q);\n}\nreturn clamp(q, 0.0, 1.0);\n}\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat s = getTime(time.x, st.s) * fadeDirection.s;\nfloat t = getTime(time.y, st.t) * fadeDirection.t;\nfloat u = length(vec2(s, t));\nvec4 color = mix(fadeInColor, fadeOutColor, u);\nmaterial.emission = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n"}),r("Shaders/Materials/GridMaterial",[],function(){"use strict";return"#ifdef GL_OES_standard_derivatives\n#extension GL_OES_standard_derivatives : enable\n#endif\nuniform vec4 color;\nuniform float cellAlpha;\nuniform vec2 lineCount;\nuniform vec2 lineThickness;\nuniform vec2 lineOffset;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat scaledWidth = fract(lineCount.s * st.s - lineOffset.s);\nscaledWidth = abs(scaledWidth - floor(scaledWidth + 0.5));\nfloat scaledHeight = fract(lineCount.t * st.t - lineOffset.t);\nscaledHeight = abs(scaledHeight - floor(scaledHeight + 0.5));\nfloat value;\n#ifdef GL_OES_standard_derivatives\nconst float fuzz = 1.2;\nvec2 thickness = (lineThickness * czm_resolutionScale) - 1.0;\nvec2 dx = abs(dFdx(st));\nvec2 dy = abs(dFdy(st));\nvec2 dF = vec2(max(dx.s, dy.s), max(dx.t, dy.t)) * lineCount;\nvalue = min(\nsmoothstep(dF.s * thickness.s, dF.s * (fuzz + thickness.s), scaledWidth),\nsmoothstep(dF.t * thickness.t, dF.t * (fuzz + thickness.t), scaledHeight));\n#else\nconst float fuzz = 0.05;\nvec2 range = 0.5 - (lineThickness * 0.05);\nvalue = min(\n1.0 - smoothstep(range.s, range.s + fuzz, scaledWidth),\n1.0 - smoothstep(range.t, range.t + fuzz, scaledHeight));\n#endif\nfloat dRim = 1.0 - abs(dot(materialInput.normalEC, normalize(materialInput.positionToEyeEC)));\nfloat sRim = smoothstep(0.8, 1.0, dRim);\nvalue *= (1.0 - sRim);\nvec3 halfColor = color.rgb * 0.5;\nmaterial.diffuse = halfColor;\nmaterial.emission = halfColor;\nmaterial.alpha = color.a * (1.0 - ((1.0 - cellAlpha) * value));\nreturn material;\n}\n"}),r("Shaders/Materials/NormalMapMaterial",[],function(){"use strict";return"uniform sampler2D image;\nuniform float strength;\nuniform vec2 repeat;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec4 textureValue = texture2D(image, fract(repeat * materialInput.st));\nvec3 normalTangentSpace = textureValue.channels;\nnormalTangentSpace.xy = normalTangentSpace.xy * 2.0 - 1.0;\nnormalTangentSpace.z = clamp(1.0 - strength, 0.1, 1.0);\nnormalTangentSpace = normalize(normalTangentSpace);\nvec3 normalEC = materialInput.tangentToEyeMatrix * normalTangentSpace;\nmaterial.normal = normalEC;\nreturn material;\n}\n"}),r("Shaders/Materials/PolylineArrowMaterial",[],function(){"use strict";return"#extension GL_OES_standard_derivatives : enable\nuniform vec4 color;\nvarying float v_width;\nfloat getPointOnLine(vec2 p0, vec2 p1, float x)\n{\nfloat slope = (p0.y - p1.y) / (p0.x - p1.x);\nreturn slope * (x - p0.x) + p0.y;\n}\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat base = 1.0 - abs(fwidth(st.s)) * 10.0;\nvec2 center = vec2(1.0, 0.5);\nfloat ptOnUpperLine = getPointOnLine(vec2(base, 1.0), center, st.s);\nfloat ptOnLowerLine = getPointOnLine(vec2(base, 0.0), center, st.s);\nfloat halfWidth = 0.15;\nfloat s = step(0.5 - halfWidth, st.t);\ns *= 1.0 - step(0.5 + halfWidth, st.t);\ns *= 1.0 - step(base, st.s);\nfloat t = step(base, materialInput.st.s);\nt *= 1.0 - step(ptOnUpperLine, st.t);\nt *= step(ptOnLowerLine, st.t);\nfloat dist;\nif (st.s < base)\n{\nfloat d1 = abs(st.t - (0.5 - halfWidth));\nfloat d2 = abs(st.t - (0.5 + halfWidth));\ndist = min(d1, d2);\n}\nelse\n{\nfloat d1 = czm_infinity;\nif (st.t < 0.5 - halfWidth && st.t > 0.5 + halfWidth)\n{\nd1 = abs(st.s - base);\n}\nfloat d2 = abs(st.t - ptOnUpperLine);\nfloat d3 = abs(st.t - ptOnLowerLine);\ndist = min(min(d1, d2), d3);\n}\nvec4 outsideColor = vec4(0.0);\nvec4 currentColor = mix(outsideColor, color, clamp(s + t, 0.0, 1.0));\nvec4 outColor = czm_antialias(outsideColor, color, currentColor, dist);\nmaterial.diffuse = outColor.rgb;\nmaterial.alpha = outColor.a;\nreturn material;\n}\n"}),r("Shaders/Materials/PolylineGlowMaterial",[],function(){"use strict";return"uniform vec4 color;\nuniform float glowPower;\nvarying float v_width;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat glow = glowPower / abs(st.t - 0.5) - (glowPower / 0.5);\nmaterial.emission = max(vec3(glow - 1.0 + color.rgb), color.rgb);\nmaterial.alpha = clamp(0.0, 1.0, glow) * color.a;\nreturn material;\n}\n"}),r("Shaders/Materials/PolylineOutlineMaterial",[],function(){"use strict";return"uniform vec4 color;\nuniform vec4 outlineColor;\nuniform float outlineWidth;\nvarying float v_width;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nvec2 st = materialInput.st;\nfloat halfInteriorWidth =  0.5 * (v_width - outlineWidth) / v_width;\nfloat b = step(0.5 - halfInteriorWidth, st.t);\nb *= 1.0 - step(0.5 + halfInteriorWidth, st.t);\nfloat d1 = abs(st.t - (0.5 - halfInteriorWidth));\nfloat d2 = abs(st.t - (0.5 + halfInteriorWidth));\nfloat dist = min(d1, d2);\nvec4 currentColor = mix(outlineColor, color, b);\nvec4 outColor = czm_antialias(outlineColor, color, currentColor, dist);\nmaterial.diffuse = outColor.rgb;\nmaterial.alpha = outColor.a;\nreturn material;\n}\n"}),r("Shaders/Materials/RimLightingMaterial",[],function(){"use strict";return"uniform vec4 color;\nuniform vec4 rimColor;\nuniform float width;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat d = 1.0 - dot(materialInput.normalEC, normalize(materialInput.positionToEyeEC));\nfloat s = smoothstep(1.0 - width, 1.0, d);\nmaterial.diffuse = color.rgb;\nmaterial.emission = rimColor.rgb * s;\nmaterial.alpha = mix(color.a, rimColor.a, s);\nreturn material;\n}\n"}),r("Shaders/Materials/StripeMaterial",[],function(){"use strict";return"uniform vec4 evenColor;\nuniform vec4 oddColor;\nuniform float offset;\nuniform float repeat;\nuniform bool horizontal;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat coord = mix(materialInput.st.s, materialInput.st.t, float(horizontal));\nfloat value = fract((coord - offset) * (repeat * 0.5));\nfloat dist = min(value, min(abs(value - 0.5), 1.0 - value));\nvec4 currentColor = mix(evenColor, oddColor, step(0.5, value));\nvec4 color = czm_antialias(evenColor, oddColor, currentColor, dist);\nmaterial.diffuse = color.rgb;\nmaterial.alpha = color.a;\nreturn material;\n}\n"}),r("Shaders/Materials/Water",[],function(){"use strict";return"uniform sampler2D specularMap;\nuniform sampler2D normalMap;\nuniform vec4 baseWaterColor;\nuniform vec4 blendColor;\nuniform float frequency;\nuniform float animationSpeed;\nuniform float amplitude;\nuniform float specularIntensity;\nuniform float fadeFactor;\nczm_material czm_getMaterial(czm_materialInput materialInput)\n{\nczm_material material = czm_getDefaultMaterial(materialInput);\nfloat time = czm_frameNumber * animationSpeed;\nfloat fade = max(1.0, (length(materialInput.positionToEyeEC) / 10000000000.0) * frequency * fadeFactor);\nfloat specularMapValue = texture2D(specularMap, materialInput.st).r;\nvec4 noise = czm_getWaterNoise(normalMap, materialInput.st * frequency, time, 0.0);\nvec3 normalTangentSpace = noise.xyz * vec3(1.0, 1.0, (1.0 / amplitude));\nnormalTangentSpace.xy /= fade;\nnormalTangentSpace = mix(vec3(0.0, 0.0, 50.0), normalTangentSpace, specularMapValue);\nnormalTangentSpace = normalize(normalTangentSpace);\nfloat tsPerturbationRatio = clamp(dot(normalTangentSpace, vec3(0.0, 0.0, 1.0)), 0.0, 1.0);\nmaterial.alpha = specularMapValue;\nmaterial.diffuse = mix(blendColor.rgb, baseWaterColor.rgb, specularMapValue);\nmaterial.diffuse += (0.1 * tsPerturbationRatio);\nmaterial.normal = normalize(materialInput.tangentToEyeMatrix * normalTangentSpace);\nmaterial.specular = specularIntensity;\nmaterial.shininess = 10.0;\nreturn material;\n}\n"}),r("Scene/Material",["../Core/Cartesian2","../Core/clone","../Core/Color","../Core/combine","../Core/createGuid","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/isArray","../Core/loadImage","../Core/Matrix2","../Core/Matrix3","../Core/Matrix4","../Renderer/CubeMap","../Renderer/Texture","../Shaders/Materials/BumpMapMaterial","../Shaders/Materials/CheckerboardMaterial","../Shaders/Materials/DotMaterial","../Shaders/Materials/FadeMaterial","../Shaders/Materials/GridMaterial","../Shaders/Materials/NormalMapMaterial","../Shaders/Materials/PolylineArrowMaterial","../Shaders/Materials/PolylineGlowMaterial","../Shaders/Materials/PolylineOutlineMaterial","../Shaders/Materials/RimLightingMaterial","../Shaders/Materials/StripeMaterial","../Shaders/Materials/Water","../ThirdParty/when"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f,v,g,_,y,w,C,E,S,b,T,x,P,A,I){"use strict";function D(e,r){e=o(e,o.EMPTY_OBJECT),r._strict=o(e.strict,!1),r._count=o(e.count,0),r._template=t(o(e.fabric,o.EMPTY_OBJECT)),r._template.uniforms=t(o(r._template.uniforms,o.EMPTY_OBJECT)),r._template.materials=t(o(r._template.materials,o.EMPTY_OBJECT)),r.type=a(r._template.type)?r._template.type:n(),r.shaderSource="",r.materials={},r.uniforms={},r._uniforms={},r._translucentFunctions=[];var s,u=W._materialCache.getMaterial(r.type);if(a(u)){var l=t(u.fabric,!0);r._template=i(r._template,l,!0),s=u.translucent}N(r),a(u)||W._materialCache.addMaterial(r.type,r),L(r),z(r),U(r);var c=0===r._translucentFunctions.length?!0:void 0;if(s=o(s,c),s=o(e.translucent,s),a(s))if("function"==typeof s){var h=function(){return s(r)};r._translucentFunctions.push(h)}else r._translucentFunctions.push(s)}function M(e,t,r,i){if(a(e))for(var n in e)if(e.hasOwnProperty(n)){var o=-1!==t.indexOf(n);(i&&!o||!i&&o)&&r(n,t)}}function R(e,t){for(var r="fabric: property name '"+e+"' is not valid. It should be ",i=0;i<t.length;i++){var n="'"+t[i]+"'";r+=i===t.length-1?"or "+n+".":n+", "}throw new l(r)}function O(e,t){var r="fabric: uniforms and materials cannot share the same property '"+e+"'";throw new l(r)}function N(e){var t=e._template,r=t.uniforms,i=t.materials,n=t.components;if(a(n)&&a(t.source))throw new l("fabric: cannot have source and components in the same template.");M(t,H,R,!0),M(n,j,R,!0);var o=[];for(var s in i)i.hasOwnProperty(s)&&o.push(s);M(r,o,O,!1)}function L(e){var t=e._template.components,r=e._template.source;if(a(r))e.shaderSource+=r+"\n";else{if(e.shaderSource+="czm_material czm_getMaterial(czm_materialInput materialInput)\n{\n",e.shaderSource+="czm_material material = czm_getDefaultMaterial(materialInput);\n",a(t))for(var i in t)t.hasOwnProperty(i)&&(e.shaderSource+="material."+i+" = "+t[i]+";\n");e.shaderSource+="return material;\n}\n"}}function F(e){return function(t,r){var i,n,o=t.uniforms,s=o[e],u=t._textures[e];if(s instanceof v&&s!==u){t._texturePaths[e]=void 0;var l=t._textures[e];return l!==t._defaultTexture&&l.destroy(),t._textures[e]=s,i=e+"Dimensions",void(o.hasOwnProperty(i)&&(n=o[i],n.x=s._width,n.y=s._height))}a(u)||(t._texturePaths[e]=void 0,a(t._defaultTexture)||(t._defaultTexture=r.defaultTexture),u=t._textures[e]=t._defaultTexture,i=e+"Dimensions",o.hasOwnProperty(i)&&(n=o[i],n.x=u._width,n.y=u._height)),s!==W.DefaultImageId&&s!==t._texturePaths[e]&&("string"==typeof s?I(h(s),function(r){t._loadedImages.push({id:e,image:r})}):s instanceof HTMLCanvasElement&&t._loadedImages.push({id:e,image:s}),t._texturePaths[e]=s)}}function B(e){return function(t,r){var i=t.uniforms[e];if(i instanceof f){var n=t._textures[e];return n!==t._defaultTexture&&n.destroy(),t._texturePaths[e]=void 0,void(t._textures[e]=i)}if(a(t._textures[e])||(t._texturePaths[e]=void 0,t._textures[e]=r.defaultCubeMap),i!==W.DefaultCubeMapId){var o=i.positiveX+i.negativeX+i.positiveY+i.negativeY+i.positiveZ+i.negativeZ;if(o!==t._texturePaths[e]){var s=[h(i.positiveX),h(i.negativeX),h(i.positiveY),h(i.negativeY),h(i.positiveZ),h(i.negativeZ)];I.all(s).then(function(r){t._loadedCubeMaps.push({id:e,images:r})}),t._texturePaths[e]=o}}}}function z(e){var t=e._template.uniforms;for(var r in t)t.hasOwnProperty(r)&&V(e,r)}function V(e,t){var r=e._strict,i=e._template.uniforms,n=i[t],o=k(n);if(!a(o))throw new l("fabric: uniform '"+t+"' has invalid type.");if("channels"===o){if(0===q(e,t,n,!1)&&r)throw new l("strict: shader source does not use channels '"+t+"'.")}else{if("sampler2D"===o){var s=t+"Dimensions";G(e,s)>0&&(i[s]={type:"ivec3",x:1,y:1},V(e,s))}var u=new RegExp("uniform\\s+"+o+"\\s+"+t+"\\s*;");if(!u.test(e.shaderSource)){var c="uniform "+o+" "+t+";";e.shaderSource=c+e.shaderSource}var h=t+"_"+e._count++;if(1===q(e,t,h)&&r)throw new l("strict: shader source does not use uniform '"+t+"'.");if(e.uniforms[t]=n,"sampler2D"===o)e._uniforms[h]=function(){return e._textures[t]},e._updateFunctions.push(F(t));else if("samplerCube"===o)e._uniforms[h]=function(){return e._textures[t]},e._updateFunctions.push(B(t));else if(-1!==o.indexOf("mat")){var d=new Y[o];e._uniforms[h]=function(){return Y[o].fromColumnMajorArray(e.uniforms[t],d)}}else e._uniforms[h]=function(){return e.uniforms[t]}}}function k(e){var t=e.type;if(!a(t)){var r=typeof e;if("number"===r)t="float";else if("boolean"===r)t="bool";else if("string"===r||e instanceof HTMLCanvasElement)t=/^([rgba]){1,4}$/i.test(e)?"channels":e===W.DefaultCubeMapId?"samplerCube":"sampler2D";else if("object"===r)if(c(e))(4===e.length||9===e.length||16===e.length)&&(t="mat"+Math.sqrt(e.length));else{var i=0;for(var n in e)e.hasOwnProperty(n)&&(i+=1);i>=2&&4>=i?t="vec"+i:6===i&&(t="samplerCube")}}return t}function U(e){var t=e._strict,r=e._template.materials;for(var n in r)if(r.hasOwnProperty(n)){var o=new W({strict:t,fabric:r[n],count:e._count});e._count=o._count,e._uniforms=i(e._uniforms,o._uniforms,!0),e.materials[n]=o,e._translucentFunctions=e._translucentFunctions.concat(o._translucentFunctions);var a="czm_getMaterial",s=a+"_"+e._count++;q(o,a,s),e.shaderSource=o.shaderSource+e.shaderSource;var u=s+"(materialInput)";if(0===q(e,n,u)&&t)throw new l("strict: shader source does not use material '"+n+"'.")}}function q(e,t,r,i){i=o(i,!0);var n=0,a="([\\w])?",s="([\\w"+(i?".":"")+"])?",u=new RegExp(s+t+a,"g");return e.shaderSource=e.shaderSource.replace(u,function(e,t,i){return t||i?e:(n+=1,r)}),n}function G(e,t,r){return q(e,t,t,r)}var W=function(e){this.type=void 0,this.shaderSource=void 0,this.materials=void 0,this.uniforms=void 0,this._uniforms=void 0,this.translucent=void 0,this._strict=void 0,this._template=void 0,this._count=void 0,this._texturePaths={},this._loadedImages=[],this._loadedCubeMaps=[],this._textures={},this._updateFunctions=[],this._defaultTexture=void 0,D(e,this),s(this,{type:{value:this.type,writable:!1}}),a(W._uniformList[this.type])||(W._uniformList[this.type]=Object.keys(this._uniforms))};W._uniformList={},W.fromType=function(e,t){if(!a(W._materialCache.getMaterial(e)))throw new l("material with type '"+e+"' does not exist.");var r=new W({fabric:{type:e}});if(a(t))for(var i in t)t.hasOwnProperty(i)&&(r.uniforms[i]=t[i]);return r},W.prototype.isTranslucent=function(){if(a(this.translucent))return"function"==typeof this.translucent?this.translucent():this.translucent;for(var e=!0,t=this._translucentFunctions,r=t.length,i=0;r>i;++i){var n=t[i];if(e="function"==typeof n?e&&n():e&&n,!e)break}return e},W.prototype.update=function(e){var t,r,i=this._loadedImages,n=i.length;for(t=0;n>t;++t){var o=i[t];r=o.id;var a=o.image,s=new v({context:e,source:a});this._textures[r]=s;var u=r+"Dimensions";if(this.uniforms.hasOwnProperty(u)){var l=this.uniforms[u];l.x=s._width,l.y=s._height}}i.length=0;var c=this._loadedCubeMaps;for(n=c.length,t=0;n>t;++t){var h=c[t];r=h.id;var d=h.images,m=new f({context:e,source:{positiveX:d[0],negativeX:d[1],positiveY:d[2],negativeY:d[3],positiveZ:d[4],negativeZ:d[5]}});this._textures[r]=m}c.length=0;var p=this._updateFunctions;for(n=p.length,t=0;n>t;++t)p[t](this,e);var g=this.materials;for(var _ in g)g.hasOwnProperty(_)&&g[_].update(e)},W.prototype.isDestroyed=function(){return!1},W.prototype.destroy=function(){var e=this._textures;for(var t in e)if(e.hasOwnProperty(t)){var r=e[t];r!==this._defaultTexture&&r.destroy()}var i=this.materials;for(var n in i)i.hasOwnProperty(n)&&i[n].destroy();return u(this)};var H=["type","materials","uniforms","components","source"],j=["diffuse","specular","shininess","normal","emission","alpha"],Y={mat2:d,mat3:m,mat4:p};return W._materialCache={_materials:{},addMaterial:function(e,t){this._materials[e]=t},getMaterial:function(e){return this._materials[e]}},W.DefaultImageId="czm_defaultImage",W.DefaultCubeMapId="czm_defaultCubeMap",W.ColorType="Color",W._materialCache.addMaterial(W.ColorType,{fabric:{type:W.ColorType,uniforms:{color:new r(1,0,0,.5)},components:{diffuse:"color.rgb",alpha:"color.a"}},translucent:function(e){return e.uniforms.color.alpha<1}}),W.ImageType="Image",W._materialCache.addMaterial(W.ImageType,{fabric:{type:W.ImageType,uniforms:{image:W.DefaultImageId,repeat:new e(1,1)},components:{diffuse:"texture2D(image, fract(repeat * materialInput.st)).rgb",alpha:"texture2D(image, fract(repeat * materialInput.st)).a"}},translucent:!0}),W.DiffuseMapType="DiffuseMap",W._materialCache.addMaterial(W.DiffuseMapType,{fabric:{type:W.DiffuseMapType,uniforms:{image:W.DefaultImageId,channels:"rgb",repeat:new e(1,1)},components:{diffuse:"texture2D(image, fract(repeat * materialInput.st)).channels"}},translucent:!1}),W.AlphaMapType="AlphaMap",W._materialCache.addMaterial(W.AlphaMapType,{fabric:{type:W.AlphaMapType,uniforms:{image:W.DefaultImageId,channel:"a",repeat:new e(1,1)},components:{alpha:"texture2D(image, fract(repeat * materialInput.st)).channel"}},translucent:!0}),W.SpecularMapType="SpecularMap",W._materialCache.addMaterial(W.SpecularMapType,{fabric:{type:W.SpecularMapType,uniforms:{image:W.DefaultImageId,channel:"r",repeat:new e(1,1)},components:{specular:"texture2D(image, fract(repeat * materialInput.st)).channel"}},translucent:!1}),W.EmissionMapType="EmissionMap",W._materialCache.addMaterial(W.EmissionMapType,{fabric:{type:W.EmissionMapType,uniforms:{image:W.DefaultImageId,channels:"rgb",repeat:new e(1,1)},components:{emission:"texture2D(image, fract(repeat * materialInput.st)).channels"}},translucent:!1}),W.BumpMapType="BumpMap",W._materialCache.addMaterial(W.BumpMapType,{fabric:{type:W.BumpMapType,uniforms:{image:W.DefaultImageId,channel:"r",strength:.8,
repeat:new e(1,1)},source:g},translucent:!1}),W.NormalMapType="NormalMap",W._materialCache.addMaterial(W.NormalMapType,{fabric:{type:W.NormalMapType,uniforms:{image:W.DefaultImageId,channels:"rgb",strength:.8,repeat:new e(1,1)},source:E},translucent:!1}),W.GridType="Grid",W._materialCache.addMaterial(W.GridType,{fabric:{type:W.GridType,uniforms:{color:new r(0,1,0,1),cellAlpha:.1,lineCount:new e(8,8),lineThickness:new e(1,1),lineOffset:new e(0,0)},source:C},translucent:function(e){var t=e.uniforms;return t.color.alpha<1||t.cellAlpha<1}}),W.StripeType="Stripe",W._materialCache.addMaterial(W.StripeType,{fabric:{type:W.StripeType,uniforms:{horizontal:!0,evenColor:new r(1,1,1,.5),oddColor:new r(0,0,1,.5),offset:0,repeat:5},source:P},translucent:function(e){var t=e.uniforms;return t.evenColor.alpha<1||t.oddColor.alpha<0}}),W.CheckerboardType="Checkerboard",W._materialCache.addMaterial(W.CheckerboardType,{fabric:{type:W.CheckerboardType,uniforms:{lightColor:new r(1,1,1,.5),darkColor:new r(0,0,0,.5),repeat:new e(5,5)},source:_},translucent:function(e){var t=e.uniforms;return t.lightColor.alpha<1||t.darkColor.alpha<0}}),W.DotType="Dot",W._materialCache.addMaterial(W.DotType,{fabric:{type:W.DotType,uniforms:{lightColor:new r(1,1,0,.75),darkColor:new r(0,1,1,.75),repeat:new e(5,5)},source:y},translucent:function(e){var t=e.uniforms;return t.lightColor.alpha<1||t.darkColor.alpha<0}}),W.WaterType="Water",W._materialCache.addMaterial(W.WaterType,{fabric:{type:W.WaterType,uniforms:{baseWaterColor:new r(.2,.3,.6,1),blendColor:new r(0,1,.699,1),specularMap:W.DefaultImageId,normalMap:W.DefaultImageId,frequency:10,animationSpeed:.01,amplitude:1,specularIntensity:.5,fadeFactor:1},source:A},translucent:function(e){var t=e.uniforms;return t.baseWaterColor.alpha<1||t.blendColor.alpha<0}}),W.RimLightingType="RimLighting",W._materialCache.addMaterial(W.RimLightingType,{fabric:{type:W.RimLightingType,uniforms:{color:new r(1,0,0,.7),rimColor:new r(1,1,1,.4),width:.3},source:x},translucent:function(e){var t=e.uniforms;return t.color.alpha<1||t.rimColor.alpha<0}}),W.FadeType="Fade",W._materialCache.addMaterial(W.FadeType,{fabric:{type:W.FadeType,uniforms:{fadeInColor:new r(1,0,0,1),fadeOutColor:new r(0,0,0,0),maximumDistance:.5,repeat:!0,fadeDirection:{x:!0,y:!0},time:new e(.5,.5)},source:w},translucent:function(e){var t=e.uniforms;return t.fadeInColor.alpha<1||t.fadeOutColor.alpha<0}}),W.PolylineArrowType="PolylineArrow",W._materialCache.addMaterial(W.PolylineArrowType,{fabric:{type:W.PolylineArrowType,uniforms:{color:new r(1,1,1,1)},source:S},translucent:!0}),W.PolylineGlowType="PolylineGlow",W._materialCache.addMaterial(W.PolylineGlowType,{fabric:{type:W.PolylineGlowType,uniforms:{color:new r(0,.5,1,1),glowPower:.25},source:b},translucent:!0}),W.PolylineOutlineType="PolylineOutline",W._materialCache.addMaterial(W.PolylineOutlineType,{fabric:{type:W.PolylineOutlineType,uniforms:{color:new r(1,1,1,1),outlineColor:new r(1,0,0,1),outlineWidth:1},source:T},translucent:function(e){var t=e.uniforms;return t.color.alpha<1||t.outlineColor.alpha<1}}),W}),r("Scene/MaterialAppearance",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/freezeObject","../Core/VertexFormat","../Shaders/Appearances/AllMaterialAppearanceFS","../Shaders/Appearances/AllMaterialAppearanceVS","../Shaders/Appearances/BasicMaterialAppearanceFS","../Shaders/Appearances/BasicMaterialAppearanceVS","../Shaders/Appearances/TexturedMaterialAppearanceFS","../Shaders/Appearances/TexturedMaterialAppearanceVS","./Appearance","./Material"],function(e,t,r,i,n,o,a,s,u,l,c,h,d){"use strict";var m=function(r){r=e(r,e.EMPTY_OBJECT);var i=e(r.translucent,!0),n=e(r.closed,!1),o=e(r.materialSupport,m.MaterialSupport.TEXTURED);this.material=t(r.material)?r.material:d.fromType(d.ColorType),this.translucent=i,this._vertexShaderSource=e(r.vertexShaderSource,o.vertexShaderSource),this._fragmentShaderSource=e(r.fragmentShaderSource,o.fragmentShaderSource),this._renderState=h.getDefaultRenderState(i,n,r.renderState),this._closed=n,this._materialSupport=o,this._vertexFormat=o.vertexFormat,this._flat=e(r.flat,!1),this._faceForward=e(r.faceForward,!n)};return r(m.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}},materialSupport:{get:function(){return this._materialSupport}},vertexFormat:{get:function(){return this._vertexFormat}},flat:{get:function(){return this._flat}},faceForward:{get:function(){return this._faceForward}}}),m.prototype.getFragmentShaderSource=h.prototype.getFragmentShaderSource,m.prototype.isTranslucent=h.prototype.isTranslucent,m.prototype.getRenderState=h.prototype.getRenderState,m.MaterialSupport={BASIC:i({vertexFormat:n.POSITION_AND_NORMAL,vertexShaderSource:u,fragmentShaderSource:s}),TEXTURED:i({vertexFormat:n.POSITION_NORMAL_AND_ST,vertexShaderSource:c,fragmentShaderSource:l}),ALL:i({vertexFormat:n.ALL,vertexShaderSource:a,fragmentShaderSource:o})},m}),r("Shaders/Appearances/PerInstanceColorAppearanceFS",[],function(){"use strict";return"varying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec4 v_color;\nvoid main()\n{\nvec3 positionToEyeEC = -v_positionEC;\nvec3 normalEC = normalize(v_normalEC);\n#ifdef FACE_FORWARD\nnormalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);\n#endif\nczm_materialInput materialInput;\nmaterialInput.normalEC = normalEC;\nmaterialInput.positionToEyeEC = positionToEyeEC;\nczm_material material = czm_getDefaultMaterial(materialInput);\nmaterial.diffuse = v_color.rgb;\nmaterial.alpha = v_color.a;\ngl_FragColor = czm_phong(normalize(positionToEyeEC), material);\n}\n"}),r("Shaders/Appearances/PerInstanceColorAppearanceVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 normal;\nattribute vec4 color;\nvarying vec3 v_positionEC;\nvarying vec3 v_normalEC;\nvarying vec4 v_color;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_positionEC = (czm_modelViewRelativeToEye * p).xyz;\nv_normalEC = czm_normal * normal;\nv_color = color;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n"}),r("Shaders/Appearances/PerInstanceFlatColorAppearanceFS",[],function(){"use strict";return"varying vec4 v_color;\nvoid main()\n{\ngl_FragColor = v_color;\n}\n"}),r("Shaders/Appearances/PerInstanceFlatColorAppearanceVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec4 color;\nvarying vec4 v_color;\nvoid main()\n{\nvec4 p = czm_computePosition();\nv_color = color;\ngl_Position = czm_modelViewProjectionRelativeToEye * p;\n}\n"}),r("Scene/PerInstanceColorAppearance",["../Core/defaultValue","../Core/defineProperties","../Core/VertexFormat","../Shaders/Appearances/PerInstanceColorAppearanceFS","../Shaders/Appearances/PerInstanceColorAppearanceVS","../Shaders/Appearances/PerInstanceFlatColorAppearanceFS","../Shaders/Appearances/PerInstanceFlatColorAppearanceVS","./Appearance"],function(e,t,r,i,n,o,a,s){"use strict";var u=function(t){t=e(t,e.EMPTY_OBJECT);var r=e(t.translucent,!0),l=e(t.closed,!1),c=e(t.flat,!1),h=c?a:n,d=c?o:i,m=c?u.FLAT_VERTEX_FORMAT:u.VERTEX_FORMAT;this.material=void 0,this.translucent=r,this._vertexShaderSource=e(t.vertexShaderSource,h),this._fragmentShaderSource=e(t.fragmentShaderSource,d),this._renderState=s.getDefaultRenderState(r,l,t.renderState),this._closed=l,this._vertexFormat=m,this._flat=c,this._faceForward=e(t.faceForward,!l)};return t(u.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}},vertexFormat:{get:function(){return this._vertexFormat}},flat:{get:function(){return this._flat}},faceForward:{get:function(){return this._faceForward}}}),u.VERTEX_FORMAT=r.POSITION_AND_NORMAL,u.FLAT_VERTEX_FORMAT=r.POSITION_ONLY,u.prototype.getFragmentShaderSource=s.prototype.getFragmentShaderSource,u.prototype.isTranslucent=s.prototype.isTranslucent,u.prototype.getRenderState=s.prototype.getRenderState,u}),r("Scene/PrimitivePipeline",["../Core/BoundingSphere","../Core/Color","../Core/ComponentDatatype","../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/Ellipsoid","../Core/FeatureDetection","../Core/GeographicProjection","../Core/Geometry","../Core/GeometryAttribute","../Core/GeometryAttributes","../Core/GeometryPipeline","../Core/IndexDatatype","../Core/Matrix4","../Core/WebMercatorProjection"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f){"use strict";function v(e,t,r){var i,n=!r,o=e.length;if(!n&&o>1){var a=e[0].modelMatrix;for(i=1;o>i;++i)if(!p.equals(a,e[i].modelMatrix)){n=!0;break}}if(n)for(i=0;o>i;++i)d.transformToWorldCoordinates(e[i]);else p.multiplyTransformation(t,e[0].modelMatrix,t)}function g(e,i){var n=e.attributes,o=n.position,a=4*(o.values.length/o.componentsPerAttribute);n.pickColor=new c({componentDatatype:r.UNSIGNED_BYTE,componentsPerAttribute:4,normalize:!0,values:new Uint8Array(a)});for(var s=t.floatToByte(i.red),u=t.floatToByte(i.green),l=t.floatToByte(i.blue),h=t.floatToByte(i.alpha),d=n.pickColor.values,m=0;a>m;m+=4)d[m]=s,d[m+1]=u,d[m+2]=l,d[m+3]=h}function _(e,t){for(var r=e.length,i=0;r>i;++i){var o=e[i],a=t[i];n(o.geometry)?g(o.geometry,a):(g(o.westHemisphereGeometry,a),g(o.eastHemisphereGeometry,a))}}function y(e){var t,r=e.length,i=[],o=e[0].attributes;for(t in o)if(o.hasOwnProperty(t)){for(var a=o[t],s=!0,u=1;r>u;++u){var l=e[u].attributes[t];if(!n(l)||a.componentDatatype!==l.componentDatatype||a.componentsPerAttribute!==l.componentsPerAttribute||a.normalize!==l.normalize){s=!1;break}}s&&i.push(t)}return i}function w(e,t,i){for(var n=l.computeNumberOfVertices(t),o=i.length,a=0;o>a;++a){for(var s=i[a],u=e[s],h=u.componentDatatype,d=u.value,m=d.length,p=r.createTypedArray(h,n*m),f=0;n>f;++f)p.set(d,f*m);t.attributes[s]=new c({componentDatatype:h,componentsPerAttribute:m,normalize:u.normalize,values:p})}}function C(e,t){for(var r=e.length,i=0;r>i;++i){var o=e[i],a=o.attributes;n(o.geometry)?w(a,o.geometry,t):(w(a,o.westHemisphereGeometry,t),w(a,o.eastHemisphereGeometry,t))}}function E(t){var i,a,s=t.instances,u=t.pickIds,l=t.projection,c=t.elementIndexUintSupported,h=t.scene3DOnly,m=t.allowPicking,p=t.vertexCacheOptimize,f=t.compressVertices,g=t.modelMatrix,w=s.length,E=s[0].geometry.primitiveType;for(i=1;w>i;++i)if(s[i].geometry.primitiveType!==E)throw new o("All instance geometries must have the same primitiveType.");if(v(s,g,h),!h)for(i=0;w>i;++i)d.splitLongitude(s[i]);m&&_(s,u);var S=y(s);if(C(s,S),p)for(i=0;w>i;++i){var b=s[i];n(b.geometry)?(d.reorderForPostVertexCache(b.geometry),d.reorderForPreVertexCache(b.geometry)):(d.reorderForPostVertexCache(b.westHemisphereGeometry),d.reorderForPreVertexCache(b.westHemisphereGeometry),d.reorderForPostVertexCache(b.eastHemisphereGeometry),d.reorderForPreVertexCache(b.eastHemisphereGeometry))}var T=d.combineInstances(s);for(w=T.length,i=0;w>i;++i){a=T[i];var x,P=a.attributes;if(h)for(x in P)P.hasOwnProperty(x)&&P[x].componentDatatype===r.DOUBLE&&d.encodeAttribute(a,x,x+"3DHigh",x+"3DLow");else for(x in P)if(P.hasOwnProperty(x)&&P[x].componentDatatype===r.DOUBLE){var A=x+"3D",I=x+"2D";d.projectTo2D(a,x,A,I,l),n(a.boundingSphere)&&"position"===x&&(a.boundingSphereCV=e.fromVertices(a.attributes.position2D.values)),d.encodeAttribute(a,A,A+"High",A+"Low"),d.encodeAttribute(a,I,I+"High",I+"Low")}f&&d.compressVertices(a)}if(!c){var D=[];for(w=T.length,i=0;w>i;++i)a=T[i],D=D.concat(d.fitToUnsignedShortIndices(a));T=D}return T}function S(e,t,i){for(var n=[],o=e.attributes,a=i.length,s=0;a>s;++s){var u=i[s],l=o[u],c=l.componentDatatype;c===r.DOUBLE&&(c=r.FLOAT);var h=r.createTypedArray(c,l.values);n.push({index:t[u],componentDatatype:c,componentsPerAttribute:l.componentsPerAttribute,normalize:l.normalize,values:h}),delete o[u]}return n}function b(e,t,r,o,a,s,u,c,h){var d=l.computeNumberOfVertices(t);n(u[e])||(u[e]={boundingSphere:t.boundingSphere,boundingSphereCV:t.boundingSphereCV});for(var m=o.length,p=0;m>p;++p)for(var f=o[p],v=a[f],g=d;g>0;){for(var _,y=i(h[f],0),w=s[y],C=w.length,E=0;C>E&&(_=w[E],_.index!==v);++E);n(u[e][f])||(u[e][f]={dirty:!1,valid:!0,value:r[f].value,indices:[]});var S,b=_.values.length/_.componentsPerAttribute,T=i(c[f],0);b>T+g?(S=g,u[e][f].indices.push({attribute:_,offset:T,count:S}),c[f]=T+g):(S=b-T,u[e][f].indices.push({attribute:_,offset:T,count:S}),c[f]=0,h[f]=y+1),g-=S}}function T(e,t,r,i,o){var a,s,u,l=[],c=e.length,h={},d={};for(a=0;c>a;++a)s=e[a],u=s.attributes,n(s.geometry)&&b(a,s.geometry,u,o,i,r,l,h,d);for(a=0;c>a;++a)s=e[a],u=s.attributes,n(s.westHemisphereGeometry)&&b(a,s.westHemisphereGeometry,u,o,i,r,l,h,d);for(a=0;c>a;++a)s=e[a],u=s.attributes,n(s.eastHemisphereGeometry)&&b(a,s.eastHemisphereGeometry,u,o,i,r,l,h,d);for(c=t.length,a=0;c>a;++a){s=t[a],u=s.attributes;var m={};l.push(m);for(var p=o.length,f=0;p>f;++f){var v=o[f];m[v]={dirty:!1,valid:!1,value:u[v].value,indices:[]}}}return l}function x(e,t){var r=e.attributes;for(var i in r)if(r.hasOwnProperty(i)){var o=r[i];n(o)&&n(o.values)&&t.push(o.values.buffer)}n(e.indices)&&t.push(e.indices.buffer)}function P(e,t){for(var r=e.length,i=0;r>i;++i)x(e[i],t)}function A(e,t){for(var r=e.length,i=0;r>i;++i)for(var n=e[i],o=n.length,a=0;o>a;++a)t.push(n[a].values.buffer)}function I(t){for(var r=1,i=t.length,o=0;i>o;o++){var a=t[o];if(++r,n(a)){var s=a.attributes;r+=6+2*e.packedLength+(n(a.indices)?a.indices.length:0);for(var u in s)if(s.hasOwnProperty(u)&&n(s[u])){var l=s[u];r+=5+l.values.length}}}return r}function D(e,t){for(var r=e.length,i=new Uint32Array(e.length),n=0;r>n;++n)i[n]=e[n].toRgba();return t.push(i.buffer),i}function M(e){for(var r=e.length,i=new Array(r),n=0;r>n;n++)i[n]=t.fromRgba(e[n]);return i}function R(e){for(var t=e.length,r=1+17*t,i=0;t>i;i++){var o=e[i].attributes;for(var a in o)if(o.hasOwnProperty(a)&&n(o[a])){var s=o[a];r+=5+s.value.length}}return r}function O(e,t){var r=new Float64Array(R(e)),i={},o=[],a=e.length,s=0;r[s++]=a;for(var u=0;a>u;u++){var l=e[u];p.pack(l.modelMatrix,r,s),s+=p.packedLength;var c=l.attributes,h=[];for(var d in c)c.hasOwnProperty(d)&&n(c[d])&&(h.push(d),n(i[d])||(i[d]=o.length,o.push(d)));r[s++]=h.length;for(var m=0;m<h.length;m++){var f=h[m],v=c[f];r[s++]=i[f],r[s++]=v.componentDatatype,r[s++]=v.componentsPerAttribute,r[s++]=v.normalize,r[s++]=v.value.length,r.set(v.value,s),s+=v.value.length}}return t.push(r.buffer),{stringTable:o,packedData:r}}function N(e){for(var t=e.packedData,i=e.stringTable,n=new Array(t[0]),o=0,a=1;a<t.length;){var s=p.unpack(t,a);a+=p.packedLength;for(var u={},l=t[a++],c=0;l>c;c++){for(var h=i[t[a++]],d=t[a++],m=t[a++],f=0!==t[a++],v=t[a++],g=r.createTypedArray(d,v),_=0;v>_;_++)g[_]=t[a++];u[h]={componentDatatype:d,componentsPerAttribute:m,normalize:f,value:g}}n[o++]={attributes:u,modelMatrix:s}}return n}function L(t){for(var r=t.length,i=1+r,o=0;r>o;o++){var a=t[o];i+=2,i+=n(a.boundingSphere)?e.packedLength:0,i+=n(a.boundingSphereCV)?e.packedLength:0;for(var s in a)if(a.hasOwnProperty(s)&&n(a[s])&&"boundingSphere"!==s&&"boundingSphereCV"!==s){var u=a[s];i+=4+3*u.indices.length+u.value.length}}return i}function F(t,r){var i=new Float64Array(L(t)),o=[],a=[],s={},u=t.length,l=0;i[l++]=u;for(var c=0;u>c;c++){var h=t[c],d=h.boundingSphere,m=n(d);i[l++]=m?1:0,m&&(e.pack(d,i,l),l+=e.packedLength),d=h.boundingSphereCV,m=n(d),i[l++]=m?1:0,m&&(e.pack(d,i,l),l+=e.packedLength);var p=[];for(var f in h)h.hasOwnProperty(f)&&n(h[f])&&"boundingSphere"!==f&&"boundingSphereCV"!==f&&(p.push(f),n(s[f])||(s[f]=o.length,o.push(f)));i[l++]=p.length;for(var v=0;v<p.length;v++){var g=p[v],_=h[g];i[l++]=s[g],i[l++]=_.valid?1:0;var y=_.indices,w=y.length;i[l++]=w;for(var C=0;w>C;C++){var E=y[C];i[l++]=E.count,i[l++]=E.offset;var S=a.indexOf(E.attribute);-1===S&&(S=a.length,a.push(E.attribute)),i[l++]=S}i[l++]=_.value.length,i.set(_.value,l),l+=_.value.length}}return r.push(i.buffer),{stringTable:o,packedData:i,attributeTable:a}}function B(t,i){for(var n=t.stringTable,o=t.attributeTable,a=t.packedData,s=new Array(a[0]),u=0,l=1,c=a.length;c>l;){var h={},d=1===a[l++];d&&(h.boundingSphere=e.unpack(a,l),l+=e.packedLength),d=1===a[l++],d&&(h.boundingSphereCV=e.unpack(a,l),l+=e.packedLength);for(var m=a[l++],p=0;m>p;p++){for(var f=n[a[l++]],v=1===a[l++],g=a[l++],_=g>0?new Array(g):void 0,y=0;g>y;y++){var w={};w.count=a[l++],w.offset=a[l++],w.attribute=o[a[l++]],_[y]=w}for(var C=a[l++],E=v?r.createTypedArray(_[0].attribute.componentDatatype,C):new Array(C),S=0;C>S;S++)E[S]=a[l++];h[f]={dirty:!1,valid:v,indices:_,value:E}}s[u++]=h}return s}if(!s.supportsTypedArrays())return{};var z={};return z.combineGeometry=function(e){var t,r,i,o,a,s=e.instances,u=e.invalidInstances;if(s.length>0){t=E(e),r=d.createAttributeLocations(t[0]),o=y(s),i=[],a=t.length;for(var l=0;a>l;++l){var c=t[l];i.push(S(c,r,o))}}o=n(o)?o:y(u);var h=T(s,u,i,r,o);return{geometries:t,modelMatrix:e.modelMatrix,attributeLocations:r,vaAttributes:i,vaAttributeLocations:h,validInstancesIndices:e.validInstancesIndices,invalidInstancesIndices:e.invalidInstancesIndices}},z.packCreateGeometryResults=function(t,r){var i=new Float64Array(I(t)),o=[],a={},s=t.length,u=0;i[u++]=s;for(var l=0;s>l;l++){var c=t[l],h=n(c);if(i[u++]=h?1:0,h){i[u++]=c.primitiveType,i[u++]=c.geometryType;var d=n(c.boundingSphere)?1:0;i[u++]=d,d&&e.pack(c.boundingSphere,i,u),u+=e.packedLength;var m=n(c.boundingSphereCV)?1:0;i[u++]=m,m&&e.pack(c.boundingSphereCV,i,u),u+=e.packedLength;var p=c.attributes,f=[];for(var v in p)p.hasOwnProperty(v)&&n(p[v])&&(f.push(v),n(a[v])||(a[v]=o.length,o.push(v)));i[u++]=f.length;for(var g=0;g<f.length;g++){var _=f[g],y=p[_];i[u++]=a[_],i[u++]=y.componentDatatype,i[u++]=y.componentsPerAttribute,i[u++]=y.normalize?1:0,i[u++]=y.values.length,i.set(y.values,u),u+=y.values.length}var w=n(c.indices)?c.indices.length:0;i[u++]=w,w>0&&(i.set(c.indices,u),u+=w)}}return r.push(i.buffer),{stringTable:o,packedData:i}},z.unpackCreateGeometryResults=function(t){for(var i,n=t.stringTable,o=t.packedData,a=new Array(o[0]),s=0,u=1;u<o.length;){var d=1===o[u++];if(d){var p,f,v=o[u++],g=o[u++],_=1===o[u++];_&&(p=e.unpack(o,u)),u+=e.packedLength;var y=1===o[u++];y&&(f=e.unpack(o,u)),u+=e.packedLength;var w,C,E,S=new h,b=o[u++];for(i=0;b>i;i++){var T=n[o[u++]],x=o[u++];E=o[u++];var P=0!==o[u++];w=o[u++],C=r.createTypedArray(x,w);for(var A=0;w>A;A++)C[A]=o[u++];S[T]=new c({componentDatatype:x,componentsPerAttribute:E,normalize:P,values:C})}var I;if(w=o[u++],w>0){var D=C.length/E;for(I=m.createTypedArray(D,w),i=0;w>i;i++)I[i]=o[u++]}a[s++]=new l({primitiveType:v,geometryType:g,boundingSphere:p,indices:I,attributes:S})}else a[s++]=void 0}return a},z.packCombineGeometryParameters=function(e,t){for(var r=e.createGeometryResults,i=r.length,n=0;i>n;n++)t.push(r[n].packedData.buffer);var o;return e.allowPicking&&(o=D(e.pickIds,t)),{createGeometryResults:e.createGeometryResults,packedInstances:O(e.instances,t),packedPickIds:o,ellipsoid:e.ellipsoid,isGeographic:e.projection instanceof u,elementIndexUintSupported:e.elementIndexUintSupported,scene3DOnly:e.scene3DOnly,allowPicking:e.allowPicking,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:e.modelMatrix}},z.unpackCombineGeometryParameters=function(e){for(var t=N(e.packedInstances),r=e.allowPicking,i=r?M(e.packedPickIds):void 0,o=e.createGeometryResults,s=o.length,l=0,c=[],h=[],d=[],m=[],v=[],g=0;s>g;g++)for(var _=z.unpackCreateGeometryResults(o[g]),y=_.length,w=0;y>w;w++){var C=_[w],E=t[l];n(C)?(E.geometry=C,c.push(E),d.push(l),r&&v.push(i[l])):(h.push(E),m.push(l)),++l}var S=a.clone(e.ellipsoid),b=e.isGeographic?new u(S):new f(S);return{instances:c,invalidInstances:h,validInstancesIndices:d,invalidInstancesIndices:m,pickIds:v,ellipsoid:S,projection:b,elementIndexUintSupported:e.elementIndexUintSupported,scene3DOnly:e.scene3DOnly,allowPicking:e.allowPicking,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:p.clone(e.modelMatrix)}},z.packCombineGeometryResults=function(e,t){return n(e.geometries)&&(P(e.geometries,t),A(e.vaAttributes,t)),{geometries:e.geometries,attributeLocations:e.attributeLocations,vaAttributes:e.vaAttributes,packedVaAttributeLocations:F(e.vaAttributeLocations,t),modelMatrix:e.modelMatrix,validInstancesIndices:e.validInstancesIndices,invalidInstancesIndices:e.invalidInstancesIndices}},z.unpackCombineGeometryResults=function(e){return{geometries:e.geometries,attributeLocations:e.attributeLocations,vaAttributes:e.vaAttributes,perInstanceAttributeLocations:B(e.packedVaAttributeLocations,e.vaAttributes),modelMatrix:e.modelMatrix}},z}),r("Scene/PrimitiveState",["../Core/freezeObject"],function(e){"use strict";var t={READY:0,CREATING:1,CREATED:2,COMBINING:3,COMBINED:4,COMPLETE:5,FAILED:6};return e(t)}),r("Scene/Primitive",["../Core/BoundingSphere","../Core/clone","../Core/combine","../Core/ComponentDatatype","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/FeatureDetection","../Core/Geometry","../Core/GeometryAttribute","../Core/GeometryAttributes","../Core/GeometryInstance","../Core/GeometryInstanceAttribute","../Core/isArray","../Core/Matrix4","../Core/subdivideArray","../Core/TaskProcessor","../Renderer/Buffer","../Renderer/BufferUsage","../Renderer/DrawCommand","../Renderer/RenderState","../Renderer/ShaderProgram","../Renderer/ShaderSource","../Renderer/VertexArray","../ThirdParty/when","./CullFace","./Pass","./PrimitivePipeline","./PrimitiveState","./SceneMode"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f,v,g,_,y,w,C,E,S,b,T,x,P,A,I,D,M){"use strict";function R(e){return new h({componentDatatype:e.componentDatatype,componentsPerAttribute:e.componentsPerAttribute,normalize:e.normalize,values:new e.values.constructor(e.values)})}function O(t){var r=t.attributes,i=new d;for(var n in r)r.hasOwnProperty(n)&&o(r[n])&&(i[n]=R(r[n]));var a;if(o(t.indices)){var s=t.indices;a=new s.constructor(s)}return new c({attributes:i,indices:a,primitiveType:t.primitiveType,boundingSphere:e.clone(t.boundingSphere)})}function N(e){return new p({componentDatatype:e.componentDatatype,componentsPerAttribute:e.componentsPerAttribute,normalize:e.normalize,value:new e.value.constructor(e.value)})}function L(e,t){var r=e.attributes,i={};for(var n in r)r.hasOwnProperty(n)&&(i[n]=N(r[n]));return new m({geometry:t,modelMatrix:v.clone(e.modelMatrix),attributes:i,pickPrimitive:e.pickPrimitive,id:e.id})}function F(e,t){if(!e.compressVertices)return t;var r=-1!==t.search(/attribute\s+vec3\s+normal;/g),i=-1!==t.search(/attribute\s+vec2\s+st;/g);if(!r&&!i)return t;var n=-1!==t.search(/attribute\s+vec3\s+tangent;/g),o=-1!==t.search(/attribute\s+vec3\s+binormal;/g),a=i&&r?2:1;a+=n||o?1:0;var s=a>1?"vec"+a:"float",u="compressedAttributes",l="attribute "+s+" "+u+";",c="",h="";if(i){c+="vec2 st;\n";var d=a>1?u+".x":u;h+="    st = czm_decompressTextureCoordinates("+d+");\n"}r&&n&&o?(c+="vec3 normal;\nvec3 tangent;\nvec3 binormal;\n",h+="    czm_octDecode("+u+"."+(i?"yz":"xy")+", normal, tangent, binormal);\n"):(r&&(c+="vec3 normal;\n",h+="    normal = czm_octDecode("+u+(a>1?"."+(i?"y":"x"):"")+");\n"),n&&(c+="vec3 tangent;\n",h+="    tangent = czm_octDecode("+u+"."+(i&&r?"z":"y")+");\n"),o&&(c+="vec3 binormal;\n",h+="    binormal = czm_octDecode("+u+"."+(i&&r?"z":"y")+");\n"));var m=t;m=m.replace(/attribute\s+vec3\s+normal;/g,""),m=m.replace(/attribute\s+vec2\s+st;/g,""),m=m.replace(/attribute\s+vec3\s+tangent;/g,""),m=m.replace(/attribute\s+vec3\s+binormal;/g,""),m=b.replaceMain(m,"czm_non_compressed_main");var p="void main() \n{ \n"+h+"    czm_non_compressed_main(); \n}";return[l,c,m,p].join("\n")}function B(e,t){var r=e.vertexAttributes;for(var i in r)if(r.hasOwnProperty(i)&&!o(t[i]))throw new u("Appearance/Geometry mismatch.  The appearance requires vertex shader attribute input '"+i+"', which was not computed as part of the Geometry.  Use the appearance's vertexFormat property when constructing the geometry.")}function z(e,t,r){for(var i=[],a=r.length,s=0;a>s;++s){var u={primitive:n(r[s].pickPrimitive,t)};o(r[s].id)&&(u.id=r[s].id);var l=e.createPickId(u);t._pickIds.push(l),i.push(l.color)}return i}function V(e,t){return function(){return e[t]}}function k(e,t){var r,i,a,s,l=e._instanceIds;if(e._state===D.READY){r=f(e.geometryInstances)?e.geometryInstances:[e.geometryInstances];var c=e._numberOfInstances=r.length,h=[],d=[];for(a=0;c>a;++a){if(i=r[a].geometry,l.push(r[a].id),!o(i._workerName))throw new u("_workerName must be defined for asynchronous geometry.");d.push({moduleName:i._workerName,geometry:i})}if(!o($))for($=new Array(ee),a=0;ee>a;a++)$[a]=new _("createGeometry",Number.POSITIVE_INFINITY);var m;for(d=g(d,ee),a=0;a<d.length;a++){var p=0,y=d[a],w=y.length;for(s=0;w>s;++s)m=y[s],i=m.geometry,o(i.constructor.pack)&&(m.offset=p,p+=n(i.constructor.packedLength,i.packedLength));var C;if(p>0){var E=new Float64Array(p);for(C=[E.buffer],s=0;w>s;++s)m=y[s],i=m.geometry,o(i.constructor.pack)&&(i.constructor.pack(i,E,m.offset),m.geometry=E)}h.push($[a].scheduleTask({subTasks:d[a]},C))}e._state=D.CREATING,x.all(h,function(t){e._createGeometryResults=t,e._state=D.CREATED}).otherwise(function(r){K(e,t,D.FAILED,r)})}else if(e._state===D.CREATED){var S=[];r=f(e.geometryInstances)?e.geometryInstances:[e.geometryInstances];var b=e.allowPicking,T=t.scene3DOnly,P=t.mapProjection,A=te.scheduleTask(I.packCombineGeometryParameters({createGeometryResults:e._createGeometryResults,instances:r,pickIds:b?z(t.context,e,r):void 0,ellipsoid:P.ellipsoid,projection:P,elementIndexUintSupported:t.context.elementIndexUint,scene3DOnly:T,allowPicking:b,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:e.modelMatrix},S),S);e._createGeometryResults=void 0,e._state=D.COMBINING,x(A,function(r){var i=I.unpackCombineGeometryResults(r);e._geometries=i.geometries,e._attributeLocations=i.attributeLocations,e._vaAttributes=i.vaAttributes,e._perInstanceAttributeLocations=i.perInstanceAttributeLocations,e.modelMatrix=v.clone(i.modelMatrix,e.modelMatrix),e._validModelMatrix=!v.equals(e.modelMatrix,v.IDENTITY);for(var n=r.validInstancesIndices,a=r.invalidInstancesIndices,s=e._instanceIds,u=new Array(s.length),l=n.length,c=0;l>c;++c)u[c]=s[n[c]];for(var h=a.length,d=0;h>d;++d)u[l+d]=s[a[d]];e._instanceIds=u,o(e._geometries)?e._state=D.COMBINED:K(e,t,D.FAILED,void 0)}).otherwise(function(r){K(e,t,D.FAILED,r)})}}function U(e,t){var r,i,n=f(e.geometryInstances)?e.geometryInstances:[e.geometryInstances],a=e._numberOfInstances=n.length,s=new Array(a),u=new Array(a),l=[],c=e._instanceIds,h=0;for(i=0;a>i;i++){r=n[i];var d,m=r.geometry;d=o(m.attributes)&&o(m.primitiveType)?O(m):m.constructor.createGeometry(m),o(d)?(s[h]=d,u[h++]=L(r,d),c.push(r.id)):l.push(r)}s.length=h,u.length=h;var p=e.allowPicking,g=t.scene3DOnly,_=t.mapProjection,y=I.combineGeometry({instances:u,invalidInstances:l,pickIds:p?z(t.context,e,u):void 0,ellipsoid:_.ellipsoid,projection:_,elementIndexUintSupported:t.context.elementIndexUint,scene3DOnly:g,allowPicking:p,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:e.modelMatrix});for(e._geometries=y.geometries,e._attributeLocations=y.attributeLocations,e._vaAttributes=y.vaAttributes,e._perInstanceAttributeLocations=y.vaAttributeLocations,e.modelMatrix=v.clone(y.modelMatrix,e.modelMatrix),e._validModelMatrix=!v.equals(e.modelMatrix,v.IDENTITY),i=0;i<l.length;++i)r=l[i],c.push(r.id);o(e._geometries)?e._state=D.COMBINED:K(e,t,D.FAILED,void 0)}function q(t,r){for(var i=t._attributeLocations,n=t._geometries,a=t._vaAttributes,s=r.scene3DOnly,u=r.context,l=[],c=n.length,h=0;c>h;++h){for(var d=n[h],m=a[h],p=m.length,f=0;p>f;++f){var v=m[f];v.vertexBuffer=y.createVertexBuffer({context:u,typedArray:v.values,usage:w.DYNAMIC_DRAW}),delete v.values}if(l.push(T.fromGeometry({context:u,geometry:d,attributeLocations:i,bufferUsage:w.STATIC_DRAW,interleave:t._interleave,vertexArrayAttributes:m})),o(t._createBoundingVolumeFunction))t._createBoundingVolumeFunction(r,d);else if(t._boundingSpheres.push(e.clone(d.boundingSphere)),t._boundingSphereWC.push(new e),!s){var g=d.boundingSphereCV.center,_=g.x,C=g.y,E=g.z;g.x=E,g.y=_,g.z=C,t._boundingSphereCV.push(e.clone(d.boundingSphereCV)),t._boundingSphere2D.push(new e),t._boundingSphereMorph.push(new e)}}t._va=l,t._primitiveType=n[0].primitiveType,t.releaseGeometryInstances&&(t.geometryInstances=void 0),t._geometries=void 0,K(t,r,D.COMPLETE,void 0)}function G(e,r,i,n){var o,a=i.getRenderState();n?(o=t(a,!1),o.cull={enabled:!0,face:P.BACK},e._frontFaceRS=E.fromCache(o),o.cull.face=P.FRONT,e._backFaceRS=E.fromCache(o)):(e._frontFaceRS=E.fromCache(a),e._backFaceRS=e._frontFaceRS),e.allowPicking?n?(o=t(a,!1),o.cull={enabled:!1},e._pickRS=E.fromCache(o)):e._pickRS=e._frontFaceRS:(o=t(a,!1),o.colorMask={red:!1,green:!1,blue:!1,alpha:!1},n?(o.cull={enabled:!1},e._pickRS=E.fromCache(o)):e._pickRS=E.fromCache(o))}function W(e,t,r){var i=t.context,n=Q._createColumbusViewShader(r.vertexShaderSource,t.scene3DOnly);n=Q._appendShowToShader(e,n),n=F(e,n);var o=r.getFragmentShaderSource(),a=e._attributeLocations;if(e._sp=S.replaceCache({context:i,shaderProgram:e._sp,vertexShaderSource:n,fragmentShaderSource:o,attributeLocations:a}),B(e._sp,a),e.allowPicking){var s=new b({sources:[o],pickColorQualifier:"varying"});e._pickSP=S.replaceCache({context:i,shaderProgram:e._pickSP,vertexShaderSource:b.createPickVertexShaderSource(n),fragmentShaderSource:s,attributeLocations:a})}else e._pickSP=S.fromCache({context:i,vertexShaderSource:n,fragmentShaderSource:o,attributeLocations:a});B(e._pickSP,a)}function H(e,t,i,n,a,s,l){var c=o(i)?i._uniforms:void 0,h={},d=t.uniforms;if(o(d))for(var m in d)if(d.hasOwnProperty(m)){if(o(c)&&o(c[m]))throw new u("Appearance and material have a uniform with the same name: "+m);h[m]=V(d,m)}var p=r(h,c),f=n?A.TRANSLUCENT:A.OPAQUE;s.length=e._va.length*(a?2:1),l.length=e._va.length;for(var v=s.length,g=0,_=0,y=0;v>y;++y){var w;a&&(w=s[y],o(w)||(w=s[y]=new C({owner:e,primitiveType:e._primitiveType})),w.vertexArray=e._va[_],w.renderState=e._backFaceRS,w.shaderProgram=e._sp,w.uniformMap=p,w.pass=f,++y),w=s[y],o(w)||(w=s[y]=new C({owner:e,primitiveType:e._primitiveType})),w.vertexArray=e._va[_],w.renderState=e._frontFaceRS,w.shaderProgram=e._sp,w.uniformMap=p,w.pass=f;var E=l[g];o(E)||(E=l[g]=new C({owner:e,primitiveType:e._primitiveType})),E.vertexArray=e._va[_],E.renderState=e._pickRS,E.shaderProgram=e._pickSP,E.uniformMap=p,E.pass=f,++g,++_}}function j(e){if(0!==e._dirtyAttributes.length){for(var t=e._dirtyAttributes,r=t.length,n=0;r>n;++n){for(var o=t[n],a=o.value,s=o.indices,u=s.length,l=0;u>l;++l){for(var c=s[l],h=c.offset,d=c.count,m=c.attribute,p=m.componentDatatype,f=m.componentsPerAttribute,v=i.createTypedArray(p,d*f),g=0;d>g;++g)v.set(a,g*f);var _=h*f*i.getSizeInBytes(p);m.vertexBuffer.copyFromArrayView(v,_)}o.dirty=!1}t.length=0}}function Y(t,r,i,n,a,s,l,c){if(r.mode!==M.SCENE3D&&!v.equals(a,v.IDENTITY))throw new u("Primitive.modelMatrix is only supported in 3D mode.");if(!v.equals(a,t._modelMatrix)){v.clone(a,t._modelMatrix);for(var h=t._boundingSpheres.length,d=0;h>d;++d){var m=t._boundingSpheres[d];o(m)&&(t._boundingSphereWC[d]=e.transform(m,a,t._boundingSphereWC[d]),r.scene3DOnly||(t._boundingSphere2D[d]=e.clone(t._boundingSphereCV[d],t._boundingSphere2D[d]),t._boundingSphere2D[d].center.x=0,t._boundingSphereMorph[d]=e.union(t._boundingSphereWC[d],t._boundingSphereCV[d])))}}var p;r.mode===M.SCENE3D?p=t._boundingSphereWC:r.mode===M.COLUMBUS_VIEW?p=t._boundingSphereCV:r.mode===M.SCENE2D&&o(t._boundingSphere2D)?p=t._boundingSphere2D:o(t._boundingSphereMorph)&&(p=t._boundingSphereMorph);var f=r.commandList,g=r.passes;if(g.render)for(var _=i.length,y=0;_>y;++y){
var w=c?Math.floor(y/2):y;i[y].modelMatrix=a,i[y].boundingVolume=p[w],i[y].cull=s,i[y].debugShowBoundingVolume=l,f.push(i[y])}if(g.pick)for(var C=n.length,E=0;C>E;++E)n[E].modelMatrix=a,n[E].boundingVolume=p[E],n[E].cull=s,f.push(n[E])}function X(e,t){var r=t[e];return function(){return o(r)&&o(r.value)?t[e].value:r}}function Z(e,t,r){return function(i){if(!o(i)||!o(i.length)||i.length<1||i.length>4)throw new u("value must be and array with length between 1 and 4.");var n=t[e];n.value=i,!n.dirty&&n.valid&&(r.push(n),n.dirty=!0)}}function K(e,t,r,i){e._error=i,e._state=r,t.afterRender.push(function(){e._ready=e._state===D.COMPLETE||e._state===D.FAILED,o(i)?e._readyPromise.reject(i):e._readyPromise.resolve(e)})}var Q=function(e){e=n(e,n.EMPTY_OBJECT),this.geometryInstances=e.geometryInstances,this.appearance=e.appearance,this._appearance=void 0,this._material=void 0,this.modelMatrix=v.clone(n(e.modelMatrix,v.IDENTITY)),this._modelMatrix=new v,this.show=n(e.show,!0),this._vertexCacheOptimize=n(e.vertexCacheOptimize,!1),this._interleave=n(e.interleave,!1),this._releaseGeometryInstances=n(e.releaseGeometryInstances,!0),this._allowPicking=n(e.allowPicking,!0),this._asynchronous=n(e.asynchronous,!0),this._compressVertices=n(e.compressVertices,!0),this.cull=n(e.cull,!0),this.debugShowBoundingVolume=n(e.debugShowBoundingVolume,!1),this._translucent=void 0,this._state=D.READY,this._geometries=[],this._vaAttributes=void 0,this._error=void 0,this._numberOfInstances=0,this._validModelMatrix=!1,this._boundingSpheres=[],this._boundingSphereWC=[],this._boundingSphereCV=[],this._boundingSphere2D=[],this._boundingSphereMorph=[],this._perInstanceAttributeLocations=void 0,this._perInstanceAttributeCache=[],this._instanceIds=[],this._lastPerInstanceAttributeIndex=0,this._dirtyAttributes=[],this._va=[],this._attributeLocations=void 0,this._primitiveType=void 0,this._frontFaceRS=void 0,this._backFaceRS=void 0,this._sp=void 0,this._pickRS=void 0,this._pickSP=void 0,this._pickIds=[],this._colorCommands=[],this._pickCommands=[],this._createBoundingVolumeFunction=e._createBoundingVolumeFunction,this._createRenderStatesFunction=e._createRenderStatesFunction,this._createShaderProgramFunction=e._createShaderProgramFunction,this._createCommandsFunction=e._createCommandsFunction,this._updateAndQueueCommandsFunction=e._updateAndQueueCommandsFunction,this._createGeometryResults=void 0,this._ready=!1,this._readyPromise=x.defer()};a(Q.prototype,{vertexCacheOptimize:{get:function(){return this._vertexCacheOptimize}},interleave:{get:function(){return this._interleave}},releaseGeometryInstances:{get:function(){return this._releaseGeometryInstances}},allowPicking:{get:function(){return this._allowPicking}},asynchronous:{get:function(){return this._asynchronous}},compressVertices:{get:function(){return this._compressVertices}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise}}});var J=/attribute\s+vec(?:3|4)\s+(.*)3DHigh;/g;Q._createColumbusViewShader=function(e,t){for(var r,i="",n="",o="";null!==(r=J.exec(e));){var a=r[1],s="vec4 czm_compute"+a[0].toUpperCase()+a.substr(1)+"()";"vec4 czm_computePosition()"!==s&&(i+=s+";\n"),t?o+=s+"\n{\n    return czm_translateRelativeToEye("+a+"3DHigh, "+a+"3DLow);\n}\n\n":(n+="attribute vec3 "+a+"2DHigh;\nattribute vec3 "+a+"2DLow;\n",o+=s+"\n{\n    vec4 p;\n    if (czm_morphTime == 1.0)\n    {\n        p = czm_translateRelativeToEye("+a+"3DHigh, "+a+"3DLow);\n    }\n    else if (czm_morphTime == 0.0)\n    {\n        p = czm_translateRelativeToEye("+a+"2DHigh.zxy, "+a+"2DLow.zxy);\n    }\n    else\n    {\n        p = czm_columbusViewMorph(\n                czm_translateRelativeToEye("+a+"2DHigh.zxy, "+a+"2DLow.zxy),\n                czm_translateRelativeToEye("+a+"3DHigh, "+a+"3DLow),\n                czm_morphTime);\n    }\n    return p;\n}\n\n")}return[i,n,e,o].join("\n")},Q._appendShowToShader=function(e,t){if(!o(e._attributeLocations.show))return t;var r=b.replaceMain(t,"czm_non_show_main"),i="attribute float show;\nvoid main() \n{ \n    czm_non_show_main(); \n    gl_Position *= show; \n}";return r+"\n"+i};var $,ee=Math.max(l.hardwareConcurrency-1,1),te=new _("combineGeometry",Number.POSITIVE_INFINITY);return Q.prototype.update=function(e){if(!(!o(this.geometryInstances)&&0===this._va.length||o(this.geometryInstances)&&f(this.geometryInstances)&&0===this.geometryInstances.length||!o(this.appearance)||e.mode!==M.SCENE3D&&e.scene3DOnly||!e.passes.render&&!e.passes.pick)){if(o(this._error))throw this._error;if(this._state!==D.FAILED&&(this._state!==D.COMPLETE&&this._state!==D.COMBINED&&(this.asynchronous?k(this,e):U(this,e)),this._state===D.COMBINED&&q(this,e),this.show&&this._state===D.COMPLETE)){var t=this.appearance,r=t.material,i=!1,a=!1;this._appearance!==t?(this._appearance=t,this._material=r,i=!0,a=!0):this._material!==r&&(this._material=r,a=!0);var s=this._appearance.isTranslucent();this._translucent!==s&&(this._translucent=s,i=!0);var u=e.context;o(this._material)&&this._material.update(u);var l=t.closed&&s;if(i){var c=n(this._createRenderStatesFunction,G);c(this,u,t,l)}if(a){var h=n(this._createShaderProgramFunction,W);h(this,e,t)}if(i||a){var d=n(this._createCommandsFunction,H);d(this,t,r,s,l,this._colorCommands,this._pickCommands)}j(this);var m=n(this._updateAndQueueCommandsFunction,Y);m(this,e,this._colorCommands,this._pickCommands,this.modelMatrix,this.cull,this.debugShowBoundingVolume,l)}}},Q.prototype.getGeometryInstanceAttributes=function(e){if(!o(e))throw new u("id is required");if(!o(this._perInstanceAttributeLocations))throw new u("must call update before calling getGeometryInstanceAttributes");for(var t=-1,r=this._lastPerInstanceAttributeIndex,i=this._instanceIds,n=i.length,s=0;n>s;++s){var l=(r+s)%n;if(e===i[l]){t=l;break}}if(-1===t)return void 0;var c=this._perInstanceAttributeCache[t];if(o(c))return c;var h=this._perInstanceAttributeLocations[t];c={};var d={},m=!1;for(var p in h)h.hasOwnProperty(p)&&(m=!0,d[p]={get:X(p,h)},"boundingSphere"!==p&&"boundingSphereCV"!==p&&(d[p].set=Z(p,h,this._dirtyAttributes)));return m&&a(c,d),this._lastPerInstanceAttributeIndex=t,this._perInstanceAttributeCache[t]=c,c},Q.prototype.isDestroyed=function(){return!1},Q.prototype.destroy=function(){var e,t;this._sp=this._sp&&this._sp.destroy(),this._pickSP=this._pickSP&&this._pickSP.destroy();var r=this._va;for(e=r.length,t=0;e>t;++t)r[t].destroy();this._va=void 0;var i=this._pickIds;for(e=i.length,t=0;e>t;++t)i[t].destroy();return this._pickIds=void 0,this._instanceIds=void 0,this._perInstanceAttributeCache=void 0,this._perInstanceAttributeLocations=void 0,this._attributeLocations=void 0,this._dirtyAttributes=void 0,s(this)},Q}),r("DataSources/ColorMaterialProperty",["../Core/Color","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./ConstantProperty","./createPropertyDescriptor","./Property"],function(e,t,r,i,n,o,a,s){"use strict";var u=function(e){this._definitionChanged=new n,this._color=void 0,this._colorSubscription=void 0,this.color=e};return r(u.prototype,{isConstant:{get:function(){return s.isConstant(this._color)}},definitionChanged:{get:function(){return this._definitionChanged}},color:a("color")}),u.prototype.getType=function(e){return"Color"},u.prototype.getValue=function(r,i){return t(i)||(i={}),i.color=s.getValueOrClonedDefault(this._color,r,e.WHITE,i.color),i},u.prototype.equals=function(e){return this===e||e instanceof u&&s.equals(this._color,e._color)},u}),r("DataSources/dynamicGeometryGetBoundingSphere",["../Core/BoundingSphere","../Core/defined","../Core/DeveloperError","./BoundingSphereState"],function(e,t,r,i){"use strict";var n=function(n,o,a,s){if(!t(n))throw new r("entity is required.");if(!t(s))throw new r("result is required.");var u;return t(o)&&o.show&&o.ready&&(u=o.getGeometryInstanceAttributes(n),t(u)&&t(u.boundingSphere))?(e.transform(u.boundingSphere,o.modelMatrix,s),i.DONE):t(a)&&a.show&&a.ready&&(u=a.getGeometryInstanceAttributes(n),t(u)&&t(u.boundingSphere))?(e.transform(u.boundingSphere,a.modelMatrix,s),i.DONE):t(o)&&!o.ready||t(a)&&!a.ready?i.PENDING:i.FAILED};return n}),r("DataSources/MaterialProperty",["../Core/Color","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Scene/Material"],function(e,t,r,i,n){"use strict";var o=function(){i.throwInstantiationError()};return r(o.prototype,{isConstant:{get:i.throwInstantiationError},definitionChanged:{get:i.throwInstantiationError}}),o.prototype.getType=i.throwInstantiationError,o.prototype.getValue=i.throwInstantiationError,o.prototype.equals=i.throwInstantiationError,o.getValue=function(r,i,o){var a;return t(i)&&(a=i.getType(r),t(a))?(t(o)&&o.type===a||(o=n.fromType(a)),i.getValue(r,o.uniforms),o):(t(o)&&o.type===n.ColorType||(o=n.fromType(n.ColorType)),e.clone(e.WHITE,o.uniforms.color),o)},o}),r("DataSources/BoxGeometryUpdater",["../Core/BoxGeometry","../Core/BoxOutlineGeometry","../Core/Color","../Core/ColorGeometryInstanceAttribute","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Event","../Core/GeometryInstance","../Core/Iso8601","../Core/ShowGeometryInstanceAttribute","../Scene/MaterialAppearance","../Scene/PerInstanceColorAppearance","../Scene/Primitive","./ColorMaterialProperty","./ConstantProperty","./dynamicGeometryGetBoundingSphere","./MaterialProperty","./Property"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f,v,g,_,y,w){"use strict";var C=new v(r.WHITE),E=new g(!0),S=new g(!0),b=new g(!1),T=new g(r.BLACK),x=new r,P=function(e){this.id=e,this.vertexFormat=void 0,this.dimensions=void 0},A=function(e,t){if(!o(e))throw new u("entity is required");if(!o(t))throw new u("scene is required");this._entity=e,this._scene=t,this._entitySubscription=e.definitionChanged.addEventListener(A.prototype._onEntityPropertyChanged,this),this._fillEnabled=!1,this._dynamic=!1,this._outlineEnabled=!1,this._geometryChanged=new l,this._showProperty=void 0,this._materialProperty=void 0,this._hasConstantOutline=!0,this._showOutlineProperty=void 0,this._outlineColorProperty=void 0,this._outlineWidth=1,this._options=new P(e),this._onEntityPropertyChanged(e,"box",e.box,void 0)};a(A,{perInstanceColorAppearanceType:{value:p},materialAppearanceType:{value:m}}),a(A.prototype,{entity:{get:function(){return this._entity}},fillEnabled:{get:function(){return this._fillEnabled}},hasConstantFill:{get:function(){return!this._fillEnabled||!o(this._entity.availability)&&w.isConstant(this._showProperty)&&w.isConstant(this._fillProperty)}},fillMaterialProperty:{get:function(){return this._materialProperty}},outlineEnabled:{get:function(){return this._outlineEnabled}},hasConstantOutline:{get:function(){return!this._outlineEnabled||!o(this._entity.availability)&&w.isConstant(this._showProperty)&&w.isConstant(this._showOutlineProperty)}},outlineColorProperty:{get:function(){return this._outlineColorProperty}},outlineWidth:{get:function(){return this._outlineWidth}},isDynamic:{get:function(){return this._dynamic}},isClosed:{value:!0},geometryChanged:{get:function(){return this._geometryChanged}}}),A.prototype.isOutlineVisible=function(e){var t=this._entity;return this._outlineEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)},A.prototype.isFilled=function(e){var t=this._entity;return this._fillEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._fillProperty.getValue(e)},A.prototype.createFillGeometryInstance=function(t){if(!o(t))throw new u("time is required.");if(!this._fillEnabled)throw new u("This instance does not represent a filled geometry.");var n,a,s=this._entity,l=s.isAvailable(t),m=new d(l&&s.isShowing&&this._showProperty.getValue(t)&&this._fillProperty.getValue(t));if(this._materialProperty instanceof v){var p=r.WHITE;o(this._materialProperty.color)&&(this._materialProperty.color.isConstant||l)&&(p=this._materialProperty.color.getValue(t)),a=i.fromColor(p),n={show:m,color:a}}else n={show:m};return new c({id:s,geometry:e.fromDimensions(this._options),modelMatrix:s._getModelMatrix(h.MINIMUM_VALUE),attributes:n})},A.prototype.createOutlineGeometryInstance=function(e){if(!o(e))throw new u("time is required.");if(!this._outlineEnabled)throw new u("This instance does not represent an outlined geometry.");var n=this._entity,a=n.isAvailable(e),s=w.getValueOrDefault(this._outlineColorProperty,e,r.BLACK);return new c({id:n,geometry:t.fromDimensions(this._options),modelMatrix:n._getModelMatrix(h.MINIMUM_VALUE),attributes:{show:new d(a&&n.isShowing&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)),color:i.fromColor(s)}})},A.prototype.isDestroyed=function(){return!1},A.prototype.destroy=function(){this._entitySubscription(),s(this)},A.prototype._onEntityPropertyChanged=function(e,t,r,i){if("availability"===t||"position"===t||"orientation"===t||"box"===t){var a=this._entity.box;if(!o(a))return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var s=a.fill,u=o(s)&&s.isConstant?s.getValue(h.MINIMUM_VALUE):!0,l=a.outline,c=o(l);if(c&&l.isConstant&&(c=l.getValue(h.MINIMUM_VALUE)),!u&&!c)return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var d=a.dimensions,f=e.position,g=a.show;if(!o(d)||!o(f)||o(g)&&g.isConstant&&!g.getValue(h.MINIMUM_VALUE))return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var _=n(a.material,C),y=_ instanceof v;this._materialProperty=_,this._fillProperty=n(s,S),this._showProperty=n(g,E),this._showOutlineProperty=n(a.outline,b),this._outlineColorProperty=c?n(a.outlineColor,T):void 0;var x=a.outlineWidth;if(this._fillEnabled=u,this._outlineEnabled=c,f.isConstant&&w.isConstant(e.orientation)&&d.isConstant&&w.isConstant(x)){var P=this._options;P.vertexFormat=y?p.VERTEX_FORMAT:m.MaterialSupport.TEXTURED.vertexFormat,P.dimensions=d.getValue(h.MINIMUM_VALUE,P.dimensions),this._outlineWidth=o(x)?x.getValue(h.MINIMUM_VALUE):1,this._dynamic=!1,this._geometryChanged.raiseEvent(this)}else this._dynamic||(this._dynamic=!0,this._geometryChanged.raiseEvent(this))}},A.prototype.createDynamicUpdater=function(e){if(!this._dynamic)throw new u("This instance does not represent dynamic geometry.");if(!o(e))throw new u("primitives is required.");return new I(e,this)};var I=function(e,t){this._primitives=e,this._primitive=void 0,this._outlinePrimitive=void 0,this._geometryUpdater=t,this._options=new P(t._entity)};return I.prototype.update=function(n){if(!o(n))throw new u("time is required.");var a=this._primitives;a.removeAndDestroy(this._primitive),a.removeAndDestroy(this._outlinePrimitive),this._primitive=void 0,this._outlinePrimitive=void 0;var s=this._geometryUpdater,l=s._entity,h=l.box;if(l.isShowing&&l.isAvailable(n)&&w.getValueOrDefault(h.show,n,!0)){var d=this._options,v=l._getModelMatrix(n),g=w.getValueOrUndefined(h.dimensions,n,d.dimensions);if(o(v)&&o(g)){if(d.dimensions=g,w.getValueOrDefault(h.fill,n,!0)){var _=y.getValue(n,s.fillMaterialProperty,this._material);this._material=_;var C=new m({material:_,translucent:_.isTranslucent(),closed:!0});d.vertexFormat=C.vertexFormat,this._primitive=a.add(new f({geometryInstances:new c({id:l,geometry:e.fromDimensions(d),modelMatrix:v}),appearance:C,asynchronous:!1}))}if(w.getValueOrDefault(h.outline,n,!1)){d.vertexFormat=p.VERTEX_FORMAT;var E=w.getValueOrClonedDefault(h.outlineColor,n,r.BLACK,x),S=w.getValueOrDefault(h.outlineWidth,n,1),b=1!==E.alpha;this._outlinePrimitive=a.add(new f({geometryInstances:new c({id:l,geometry:t.fromDimensions(d),modelMatrix:v,attributes:{color:i.fromColor(E)}}),appearance:new p({flat:!0,translucent:b,renderState:{lineWidth:s._scene.clampLineWidth(S)}}),asynchronous:!1}))}}}},I.prototype.getBoundingSphere=function(e,t){return _(e,this._primitive,this._outlinePrimitive,t)},I.prototype.isDestroyed=function(){return!1},I.prototype.destroy=function(){var e=this._primitives;e.removeAndDestroy(this._primitive),e.removeAndDestroy(this._outlinePrimitive),s(this)},A}),r("DataSources/ImageMaterialProperty",["../Core/Cartesian2","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/Event","./createPropertyDescriptor","./Property"],function(e,t,r,i,n,o,a){"use strict";var s=new e(1,1),u=function(e){e=t(e,t.EMPTY_OBJECT),this._definitionChanged=new n,this._image=void 0,this._imageSubscription=void 0,this._repeat=void 0,this._repeatSubscription=void 0,this.image=e.image,this.repeat=e.repeat};return i(u.prototype,{isConstant:{get:function(){return a.isConstant(this._image)&&a.isConstant(this._repeat)}},definitionChanged:{get:function(){return this._definitionChanged}},image:o("image"),repeat:o("repeat")}),u.prototype.getType=function(e){return"Image"},u.prototype.getValue=function(e,t){return r(t)||(t={}),t.image=a.getValueOrUndefined(this._image,e),t.repeat=a.getValueOrClonedDefault(this._repeat,e,s,t.repeat),t},u.prototype.equals=function(e){return this===e||e instanceof u&&a.equals(this._image,e._image)&&a.equals(this._repeat,e._repeat)},u}),r("DataSources/createMaterialPropertyDescriptor",["../Core/Color","../Core/DeveloperError","./ColorMaterialProperty","./createPropertyDescriptor","./ImageMaterialProperty"],function(e,t,r,i,n){"use strict";function o(i){if(i instanceof e)return new r(i);if("string"==typeof i||i instanceof HTMLCanvasElement){var o=new n;return o.image=i,o}throw new t("Unable to infer material type: "+i)}function a(e,t){return i(e,t,o)}return a}),r("DataSources/BoxGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,r,i,n,o,a){"use strict";var s=function(t){this._dimensions=void 0,this._dimensionsSubscription=void 0,this._show=void 0,this._showSubscription=void 0,this._fill=void 0,this._fillSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._outline=void 0,this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))};return r(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:a("show"),dimensions:a("dimensions"),material:o("material"),fill:a("fill"),outline:a("outline"),outlineColor:a("outlineColor"),outlineWidth:a("outlineWidth")}),s.prototype.clone=function(e){return t(e)?(e.dimensions=this.dimensions,e.show=this.show,e.material=this.material,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e):new s(this)},s.prototype.merge=function(r){if(!t(r))throw new i("source is required.");this.dimensions=e(this.dimensions,r.dimensions),this.show=e(this.show,r.show),this.material=e(this.material,r.material),this.fill=e(this.fill,r.fill),this.outline=e(this.outline,r.outline),this.outlineColor=e(this.outlineColor,r.outlineColor),this.outlineWidth=e(this.outlineWidth,r.outlineWidth)},s}),r("DataSources/CallbackProperty",["../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event"],function(e,t,r,i){"use strict";var n=function(e,t){this._callback=void 0,this._isConstant=void 0,this._definitionChanged=new i,this.setCallback(e,t)};return t(n.prototype,{isConstant:{get:function(){return this._isConstant}},definitionChanged:{get:function(){return this._definitionChanged}}}),n.prototype.getValue=function(e,t){return this._callback(e,t)},n.prototype.setCallback=function(t,i){if(!e(t))throw new r("callback is required.");if(!e(i))throw new r("isConstant is required.");var n=this._callback!==t||this._isConstant!==i;this._callback=t,this._isConstant=i,n&&this._definitionChanged.raiseEvent(this)},n.prototype.equals=function(e){return this===e||e instanceof n&&this._callback===e._callback&&this._isConstant===e._isConstant},n}),r("DataSources/CheckerboardMaterialProperty",["../Core/Cartesian2","../Core/Color","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/Event","./createPropertyDescriptor","./Property"],function(e,t,r,i,n,o,a,s){"use strict";var u=t.WHITE,l=t.BLACK,c=new e(2,2),h=function(e){e=r(e,r.EMPTY_OBJECT),this._definitionChanged=new o,this._evenColor=void 0,this._evenColorSubscription=void 0,this._oddColor=void 0,this._oddColorSubscription=void 0,this._repeat=void 0,this._repeatSubscription=void 0,this.evenColor=e.evenColor,this.oddColor=e.oddColor,this.repeat=e.repeat};return n(h.prototype,{isConstant:{get:function(){return s.isConstant(this._evenColor)&&s.isConstant(this._oddColor)&&s.isConstant(this._repeat)}},definitionChanged:{get:function(){return this._definitionChanged}},evenColor:a("evenColor"),oddColor:a("oddColor"),repeat:a("repeat")}),h.prototype.getType=function(e){return"Checkerboard"},h.prototype.getValue=function(e,t){return i(t)||(t={}),t.lightColor=s.getValueOrClonedDefault(this._evenColor,e,u,t.lightColor),t.darkColor=s.getValueOrClonedDefault(this._oddColor,e,l,t.darkColor),t.repeat=s.getValueOrDefault(this._repeat,e,c),t},h.prototype.equals=function(e){return this===e||e instanceof h&&s.equals(this._evenColor,e._evenColor)&&s.equals(this._oddColor,e._oddColor)&&s.equals(this._repeat,e._repeat)},h}),r("DataSources/PositionProperty",["../Core/Cartesian3","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Matrix3","../Core/ReferenceFrame","../Core/Transforms"],function(e,t,r,i,n,o,a){"use strict";var s=function(){i.throwInstantiationError()};r(s.prototype,{isConstant:{get:i.throwInstantiationError},definitionChanged:{get:i.throwInstantiationError},referenceFrame:{get:i.throwInstantiationError}}),s.prototype.getValue=i.throwInstantiationError,s.prototype.getValueInReferenceFrame=i.throwInstantiationError,s.prototype.equals=i.throwInstantiationError;var u=new n;return s.convertToReferenceFrame=function(r,i,s,l,c){if(!t(i))return i;if(t(c)||(c=new e),s===l)return e.clone(i,c);var h=a.computeIcrfToFixedMatrix(r,u);return t(h)||(h=a.computeTemeToPseudoFixedMatrix(r,u)),s===o.INERTIAL?n.multiplyByVector(h,i,c):s===o.FIXED?n.multiplyByVector(n.transpose(h,u),i,c):void 0},s}),r("DataSources/ConstantPositionProperty",["../Core/Cartesian3","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/ReferenceFrame","./PositionProperty"],function(e,t,r,i,n,o,a,s){"use strict";var u=function(r,i){this._definitionChanged=new o,this._value=e.clone(r),this._referenceFrame=t(i,a.FIXED)};return i(u.prototype,{isConstant:{get:function(){return!r(this._value)||this._referenceFrame===a.FIXED}},definitionChanged:{get:function(){return this._definitionChanged}},referenceFrame:{get:function(){return this._referenceFrame}}}),u.prototype.getValue=function(e,t){return this.getValueInReferenceFrame(e,a.FIXED,t)},u.prototype.setValue=function(t,i){var n=!1;e.equals(this._value,t)||(n=!0,this._value=e.clone(t)),r(i)&&this._referenceFrame!==i&&(n=!0,this._referenceFrame=i),n&&this._definitionChanged.raiseEvent(this)},u.prototype.getValueInReferenceFrame=function(e,t,i){if(!r(e))throw new n("time is required.");if(!r(t))throw new n("referenceFrame is required.");return s.convertToReferenceFrame(e,this._value,this._referenceFrame,t,i)},u.prototype.equals=function(t){return this===t||t instanceof u&&e.equals(this._value,t._value)&&this._referenceFrame===t._referenceFrame},u}),r("DataSources/CorridorGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,r,i,n,o,a){"use strict";var s=function(t){this._show=void 0,this._showSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._positions=void 0,this._positionsSubscription=void 0,this._height=void 0,this._heightSubscription=void 0,this._extrudedHeight=void 0,this._extrudedHeightSubscription=void 0,this._granularity=void 0,this._granularitySubscription=void 0,this._width=void 0,this._widthSubscription=void 0,this._cornerType=void 0,this._cornerTypeSubscription=void 0,this._fill=void 0,this._fillSubscription=void 0,this._outline=void 0,this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))};return r(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:a("show"),material:o("material"),positions:a("positions"),height:a("height"),extrudedHeight:a("extrudedHeight"),granularity:a("granularity"),width:a("width"),fill:a("fill"),outline:a("outline"),outlineColor:a("outlineColor"),outlineWidth:a("outlineWidth"),cornerType:a("cornerType")}),s.prototype.clone=function(e){return t(e)?(e.show=this.show,e.material=this.material,e.positions=this.positions,e.height=this.height,e.extrudedHeight=this.extrudedHeight,e.granularity=this.granularity,e.width=this.width,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.cornerType=this.cornerType,e):new s(this)},s.prototype.merge=function(r){if(!t(r))throw new i("source is required.");this.show=e(this.show,r.show),this.material=e(this.material,r.material),this.positions=e(this.positions,r.positions),this.height=e(this.height,r.height),this.extrudedHeight=e(this.extrudedHeight,r.extrudedHeight),this.granularity=e(this.granularity,r.granularity),this.width=e(this.width,r.width),this.fill=e(this.fill,r.fill),this.outline=e(this.outline,r.outline),this.outlineColor=e(this.outlineColor,r.outlineColor),this.outlineWidth=e(this.outlineWidth,r.outlineWidth),this.cornerType=e(this.cornerType,r.cornerType)},s}),r("DataSources/createRawPropertyDescriptor",["./createPropertyDescriptor"],function(e){"use strict";function t(e){return e}function r(r,i){return e(r,i,t)}return r}),r("DataSources/CylinderGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,r,i,n,o,a){"use strict";var s=function(t){this._length=void 0,this._lengthSubscription=void 0,this._topRadius=void 0,this._topRadiusSubscription=void 0,this._bottomRadius=void 0,this._bottomRadiusSubscription=void 0,this._numberOfVerticalLines=void 0,this._numberOfVerticalLinesSubscription=void 0,this._slices=void 0,this._slicesSubscription=void 0,this._show=void 0,this._showSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._fill=void 0,this._fillSubscription=void 0,this._outline=void 0,this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))};return r(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},length:a("length"),topRadius:a("topRadius"),bottomRadius:a("bottomRadius"),numberOfVerticalLines:a("numberOfVerticalLines"),slices:a("slices"),show:a("show"),material:o("material"),fill:a("fill"),outline:a("outline"),outlineColor:a("outlineColor"),outlineWidth:a("outlineWidth")}),s.prototype.clone=function(e){return t(e)?(e.bottomRadius=this.bottomRadius,e.length=this.length,e.topRadius=this.topRadius,e.show=this.show,e.material=this.material,e.numberOfVerticalLines=this.numberOfVerticalLines,e.slices=this.slices,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e):new s(this)},s.prototype.merge=function(r){if(!t(r))throw new i("source is required.");this.bottomRadius=e(this.bottomRadius,r.bottomRadius),this.length=e(this.length,r.length),this.topRadius=e(this.topRadius,r.topRadius),this.show=e(this.show,r.show),this.material=e(this.material,r.material),this.numberOfVerticalLines=e(this.numberOfVerticalLines,r.numberOfVerticalLines),this.slices=e(this.slices,r.slices),this.fill=e(this.fill,r.fill),this.outline=e(this.outline,r.outline),this.outlineColor=e(this.outlineColor,r.outlineColor),this.outlineWidth=e(this.outlineWidth,r.outlineWidth)},s}),r("DataSources/EllipseGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,r,i,n,o,a){"use strict";var s=function(t){this._semiMajorAxis=void 0,this._semiMajorAxisSubscription=void 0,this._semiMinorAxis=void 0,this._semiMinorAxisSubscription=void 0,this._rotation=void 0,this._rotationSubscription=void 0,this._show=void 0,this._showSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._height=void 0,this._heightSubscription=void 0,this._extrudedHeight=void 0,this._extrudedHeightSubscription=void 0,this._granularity=void 0,this._granularitySubscription=void 0,this._stRotation=void 0,this._stRotationSubscription=void 0,this._fill=void 0,this._fillSubscription=void 0,this._outline=void 0,this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._numberOfVerticalLines=void 0,this._numberOfVerticalLinesSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))};return r(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},semiMajorAxis:a("semiMajorAxis"),semiMinorAxis:a("semiMinorAxis"),rotation:a("rotation"),show:a("show"),material:o("material"),height:a("height"),extrudedHeight:a("extrudedHeight"),granularity:a("granularity"),stRotation:a("stRotation"),fill:a("fill"),outline:a("outline"),outlineColor:a("outlineColor"),outlineWidth:a("outlineWidth"),numberOfVerticalLines:a("numberOfVerticalLines")}),s.prototype.clone=function(e){return t(e)?(e.rotation=this.rotation,e.semiMajorAxis=this.semiMajorAxis,e.semiMinorAxis=this.semiMinorAxis,e.show=this.show,e.material=this.material,e.height=this.height,e.extrudedHeight=this.extrudedHeight,e.granularity=this.granularity,e.stRotation=this.stRotation,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.numberOfVerticalLines=this.numberOfVerticalLines,e):new s(this)},s.prototype.merge=function(r){if(!t(r))throw new i("source is required.");this.rotation=e(this.rotation,r.rotation),this.semiMajorAxis=e(this.semiMajorAxis,r.semiMajorAxis),this.semiMinorAxis=e(this.semiMinorAxis,r.semiMinorAxis),this.show=e(this.show,r.show),this.material=e(this.material,r.material),this.height=e(this.height,r.height),this.extrudedHeight=e(this.extrudedHeight,r.extrudedHeight),this.granularity=e(this.granularity,r.granularity),this.stRotation=e(this.stRotation,r.stRotation),this.fill=e(this.fill,r.fill),this.outline=e(this.outline,r.outline),this.outlineColor=e(this.outlineColor,r.outlineColor),this.outlineWidth=e(this.outlineWidth,r.outlineWidth),this.numberOfVerticalLines=e(this.numberOfVerticalLines,r.numberOfVerticalLines)},s}),r("DataSources/EllipsoidGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,r,i,n,o,a){"use strict";var s=function(t){this._show=void 0,this._showSubscription=void 0,this._radii=void 0,this._radiiSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._stackPartitions=void 0,this._stackPartitionsSubscription=void 0,this._slicePartitions=void 0,this._slicePartitionsSubscription=void 0,this._subdivisions=void 0,this._subdivisionsSubscription=void 0,this._fill=void 0,this._fillSubscription=void 0,this._outline=void 0,
this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))};return r(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:a("show"),radii:a("radii"),material:o("material"),fill:a("fill"),outline:a("outline"),outlineColor:a("outlineColor"),outlineWidth:a("outlineWidth"),stackPartitions:a("stackPartitions"),slicePartitions:a("slicePartitions"),subdivisions:a("subdivisions")}),s.prototype.clone=function(e){return t(e)?(e.show=this.show,e.radii=this.radii,e.material=this.material,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.stackPartitions=this.stackPartitions,e.slicePartitions=this.slicePartitions,e.subdivisions=this.subdivisions,e):new s(this)},s.prototype.merge=function(r){if(!t(r))throw new i("source is required.");this.show=e(this.show,r.show),this.radii=e(this.radii,r.radii),this.material=e(this.material,r.material),this.fill=e(this.fill,r.fill),this.outline=e(this.outline,r.outline),this.outlineColor=e(this.outlineColor,r.outlineColor),this.outlineWidth=e(this.outlineWidth,r.outlineWidth),this.stackPartitions=e(this.stackPartitions,r.stackPartitions),this.slicePartitions=e(this.slicePartitions,r.slicePartitions),this.subdivisions=e(this.subdivisions,r.subdivisions)},s}),r("DataSources/LabelGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createPropertyDescriptor"],function(e,t,r,i,n,o){"use strict";var a=function(t){this._text=void 0,this._textSubscription=void 0,this._font=void 0,this._fontSubscription=void 0,this._style=void 0,this._styleSubscription=void 0,this._fillColor=void 0,this._fillColorSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._horizontalOrigin=void 0,this._horizontalOriginSubscription=void 0,this._verticalOrigin=void 0,this._verticalOriginSubscription=void 0,this._eyeOffset=void 0,this._eyeOffsetSubscription=void 0,this._pixelOffset=void 0,this._pixelOffsetSubscription=void 0,this._scale=void 0,this._scaleSubscription=void 0,this._show=void 0,this._showSubscription=void 0,this._translucencyByDistance=void 0,this._translucencyByDistanceSubscription=void 0,this._pixelOffsetScaleByDistance=void 0,this._pixelOffsetScaleByDistanceSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))};return r(a.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},text:o("text"),font:o("font"),style:o("style"),fillColor:o("fillColor"),outlineColor:o("outlineColor"),outlineWidth:o("outlineWidth"),horizontalOrigin:o("horizontalOrigin"),verticalOrigin:o("verticalOrigin"),eyeOffset:o("eyeOffset"),pixelOffset:o("pixelOffset"),scale:o("scale"),show:o("show"),translucencyByDistance:o("translucencyByDistance"),pixelOffsetScaleByDistance:o("pixelOffsetScaleByDistance")}),a.prototype.clone=function(e){return t(e)?(e.text=this.text,e.font=this.font,e.show=this.show,e.style=this.style,e.fillColor=this.fillColor,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.scale=this.scale,e.horizontalOrigin=this.horizontalOrigin,e.verticalOrigin=this.verticalOrigin,e.eyeOffset=this.eyeOffset,e.pixelOffset=this.pixelOffset,e.translucencyByDistance=this.translucencyByDistance,e.pixelOffsetScaleByDistance=this.pixelOffsetScaleByDistance,e):new a(this)},a.prototype.merge=function(r){if(!t(r))throw new i("source is required.");this.text=e(this.text,r.text),this.font=e(this.font,r.font),this.show=e(this.show,r.show),this.style=e(this.style,r.style),this.fillColor=e(this.fillColor,r.fillColor),this.outlineColor=e(this.outlineColor,r.outlineColor),this.outlineWidth=e(this.outlineWidth,r.outlineWidth),this.scale=e(this.scale,r.scale),this.horizontalOrigin=e(this.horizontalOrigin,r.horizontalOrigin),this.verticalOrigin=e(this.verticalOrigin,r.verticalOrigin),this.eyeOffset=e(this.eyeOffset,r.eyeOffset),this.pixelOffset=e(this.pixelOffset,r.pixelOffset),this.translucencyByDistance=e(this._translucencyByDistance,r.translucencyByDistance),this.pixelOffsetScaleByDistance=e(this._pixelOffsetScaleByDistance,r.pixelOffsetScaleByDistance)},a}),r("DataSources/ModelGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createPropertyDescriptor"],function(e,t,r,i,n,o){"use strict";var a=function(t){this._show=void 0,this._showSubscription=void 0,this._scale=void 0,this._scaleSubscription=void 0,this._minimumPixelSize=void 0,this._minimumPixelSizeSubscription=void 0,this._uri=void 0,this._uriSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))};return r(a.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:o("show"),scale:o("scale"),minimumPixelSize:o("minimumPixelSize"),uri:o("uri")}),a.prototype.clone=function(e){return t(e)?(e.show=this.show,e.scale=this.scale,e.minimumPixelSize=this.minimumPixelSize,e.uri=this.uri,e):new a(this)},a.prototype.merge=function(r){if(!t(r))throw new i("source is required.");this.show=e(this.show,r.show),this.scale=e(this.scale,r.scale),this.minimumPixelSize=e(this.minimumPixelSize,r.minimumPixelSize),this.uri=e(this.uri,r.uri)},a}),r("DataSources/PathGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,r,i,n,o,a){"use strict";var s=function(t){this._material=void 0,this._materialSubscription=void 0,this._show=void 0,this._showSubscription=void 0,this._width=void 0,this._widthSubscription=void 0,this._resolution=void 0,this._resolutionSubscription=void 0,this._leadTime=void 0,this._leadTimeSubscription=void 0,this._trailTime=void 0,this._trailTimeSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))};return r(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:a("show"),material:o("material"),width:a("width"),resolution:a("resolution"),leadTime:a("leadTime"),trailTime:a("trailTime")}),s.prototype.clone=function(e){return t(e)?(e.material=this.material,e.width=this.width,e.resolution=this.resolution,e.show=this.show,e.leadTime=this.leadTime,e.trailTime=this.trailTime,e):new s(this)},s.prototype.merge=function(r){if(!t(r))throw new i("source is required.");this.material=e(this.material,r.material),this.width=e(this.width,r.width),this.resolution=e(this.resolution,r.resolution),this.show=e(this.show,r.show),this.leadTime=e(this.leadTime,r.leadTime),this.trailTime=e(this.trailTime,r.trailTime)},s}),r("DataSources/PointGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createPropertyDescriptor"],function(e,t,r,i,n,o){"use strict";var a=function(t){this._color=void 0,this._colorSubscription=void 0,this._pixelSize=void 0,this._pixelSizeSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._show=void 0,this._showSubscription=void 0,this._scaleByDistance=void 0,this._scaleByDistanceSubscription=void 0,this._translucencyByDistance=void 0,this._translucencyByDistanceSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))};return r(a.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},color:o("color"),pixelSize:o("pixelSize"),outlineColor:o("outlineColor"),outlineWidth:o("outlineWidth"),show:o("show"),scaleByDistance:o("scaleByDistance"),translucencyByDistance:o("translucencyByDistance")}),a.prototype.clone=function(e){return t(e)?(e.color=this.color,e.pixelSize=this.pixelSize,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.show=this.show,e.scaleByDistance=this.scaleByDistance,e.translucencyByDistance=this._translucencyByDistance,e):new a(this)},a.prototype.merge=function(r){if(!t(r))throw new i("source is required.");this.color=e(this.color,r.color),this.pixelSize=e(this.pixelSize,r.pixelSize),this.outlineColor=e(this.outlineColor,r.outlineColor),this.outlineWidth=e(this.outlineWidth,r.outlineWidth),this.show=e(this.show,r.show),this.scaleByDistance=e(this.scaleByDistance,r.scaleByDistance),this.translucencyByDistance=e(this._translucencyByDistance,r.translucencyByDistance)},a}),r("DataSources/PolygonGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,r,i,n,o,a){"use strict";var s=function(t){this._show=void 0,this._showSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._hierarchy=void 0,this._hierarchySubscription=void 0,this._height=void 0,this._heightSubscription=void 0,this._extrudedHeight=void 0,this._extrudedHeightSubscription=void 0,this._granularity=void 0,this._granularitySubscription=void 0,this._stRotation=void 0,this._stRotationSubscription=void 0,this._perPositionHeight=void 0,this._perPositionHeightSubscription=void 0,this._outline=void 0,this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._definitionChanged=new n,this._fill=void 0,this._fillSubscription=void 0,this.merge(e(t,e.EMPTY_OBJECT))};return r(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:a("show"),material:o("material"),hierarchy:a("hierarchy"),height:a("height"),extrudedHeight:a("extrudedHeight"),granularity:a("granularity"),stRotation:a("stRotation"),fill:a("fill"),outline:a("outline"),outlineColor:a("outlineColor"),outlineWidth:a("outlineWidth"),perPositionHeight:a("perPositionHeight")}),s.prototype.clone=function(e){return t(e)?(e.show=this.show,e.material=this.material,e.hierarchy=this.hierarchy,e.height=this.height,e.extrudedHeight=this.extrudedHeight,e.granularity=this.granularity,e.stRotation=this.stRotation,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.perPositionHeight=this.perPositionHeight,e):new s(this)},s.prototype.merge=function(r){if(!t(r))throw new i("source is required.");this.show=e(this.show,r.show),this.material=e(this.material,r.material),this.hierarchy=e(this.hierarchy,r.hierarchy),this.height=e(this.height,r.height),this.extrudedHeight=e(this.extrudedHeight,r.extrudedHeight),this.granularity=e(this.granularity,r.granularity),this.stRotation=e(this.stRotation,r.stRotation),this.fill=e(this.fill,r.fill),this.outline=e(this.outline,r.outline),this.outlineColor=e(this.outlineColor,r.outlineColor),this.outlineWidth=e(this.outlineWidth,r.outlineWidth),this.perPositionHeight=e(this.perPositionHeight,r.perPositionHeight)},s}),r("DataSources/PolylineGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,r,i,n,o,a){"use strict";var s=function(t){this._show=void 0,this._showSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._positions=void 0,this._positionsSubscription=void 0,this._followSurface=void 0,this._followSurfaceSubscription=void 0,this._granularity=void 0,this._granularitySubscription=void 0,this._widthSubscription=void 0,this._width=void 0,this._widthSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))};return r(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:a("show"),material:o("material"),positions:a("positions"),width:a("width"),followSurface:a("followSurface"),granularity:a("granularity")}),s.prototype.clone=function(e){return t(e)?(e.show=this.show,e.material=this.material,e.positions=this.positions,e.width=this.width,e.followSurface=this.followSurface,e.granularity=this.granularity,e):new s(this)},s.prototype.merge=function(r){if(!t(r))throw new i("source is required.");this.show=e(this.show,r.show),this.material=e(this.material,r.material),this.positions=e(this.positions,r.positions),this.width=e(this.width,r.width),this.followSurface=e(this.followSurface,r.followSurface),this.granularity=e(this.granularity,r.granularity)},s}),r("DataSources/PolylineVolumeGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,r,i,n,o,a){"use strict";var s=function(t){this._show=void 0,this._showSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._positions=void 0,this._positionsSubscription=void 0,this._shape=void 0,this._shapeSubscription=void 0,this._granularity=void 0,this._granularitySubscription=void 0,this._cornerType=void 0,this._cornerTypeSubscription=void 0,this._fill=void 0,this._fillSubscription=void 0,this._outline=void 0,this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))};return r(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:a("show"),material:o("material"),positions:a("positions"),shape:a("shape"),granularity:a("granularity"),fill:a("fill"),outline:a("outline"),outlineColor:a("outlineColor"),outlineWidth:a("outlineWidth"),cornerType:a("cornerType")}),s.prototype.clone=function(e){return t(e)?(e.show=this.show,e.material=this.material,e.positions=this.positions,e.shape=this.shape,e.granularity=this.granularity,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.cornerType=this.cornerType,e):new s(this)},s.prototype.merge=function(r){if(!t(r))throw new i("source is required.");this.show=e(this.show,r.show),this.material=e(this.material,r.material),this.positions=e(this.positions,r.positions),this.shape=e(this.shape,r.shape),this.granularity=e(this.granularity,r.granularity),this.fill=e(this.fill,r.fill),this.outline=e(this.outline,r.outline),this.outlineColor=e(this.outlineColor,r.outlineColor),this.outlineWidth=e(this.outlineWidth,r.outlineWidth),this.cornerType=e(this.cornerType,r.cornerType)},s}),r("DataSources/RectangleGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,r,i,n,o,a){"use strict";var s=function(t){this._show=void 0,this._showSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._coordinates=void 0,this._coordinatesSubscription=void 0,this._height=void 0,this._heightSubscription=void 0,this._extrudedHeight=void 0,this._extrudedHeightSubscription=void 0,this._granularity=void 0,this._granularitySubscription=void 0,this._stRotation=void 0,this._stRotationSubscription=void 0,this._rotation=void 0,this._rotationSubscription=void 0,this._closeTop=void 0,this._closeTopSubscription=void 0,this._closeBottom=void 0,this._closeBottomSubscription=void 0,this._fill=void 0,this._fillSubscription=void 0,this._outline=void 0,this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))};return r(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:a("show"),coordinates:a("coordinates"),material:o("material"),height:a("height"),extrudedHeight:a("extrudedHeight"),granularity:a("granularity"),stRotation:a("stRotation"),rotation:a("rotation"),fill:a("fill"),outline:a("outline"),outlineColor:a("outlineColor"),outlineWidth:a("outlineWidth"),closeTop:a("closeTop"),closeBottom:a("closeBottom")}),s.prototype.clone=function(e){return t(e)?(e.show=this.show,e.coordinates=this.coordinates,e.material=this.material,e.height=this.height,e.extrudedHeight=this.extrudedHeight,e.granularity=this.granularity,e.stRotation=this.stRotation,e.rotation=this.rotation,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.closeTop=this.closeTop,e.closeBottom=this.closeBottom,e):new s(this)},s.prototype.merge=function(r){if(!t(r))throw new i("source is required.");this.show=e(this.show,r.show),this.coordinates=e(this.coordinates,r.coordinates),this.material=e(this.material,r.material),this.height=e(this.height,r.height),this.extrudedHeight=e(this.extrudedHeight,r.extrudedHeight),this.granularity=e(this.granularity,r.granularity),this.stRotation=e(this.stRotation,r.stRotation),this.rotation=e(this.rotation,r.rotation),this.fill=e(this.fill,r.fill),this.outline=e(this.outline,r.outline),this.outlineColor=e(this.outlineColor,r.outlineColor),this.outlineWidth=e(this.outlineWidth,r.outlineWidth),this.closeTop=e(this.closeTop,r.closeTop),this.closeBottom=e(this.closeBottom,r.closeBottom)},s}),r("DataSources/WallGraphics",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./createMaterialPropertyDescriptor","./createPropertyDescriptor"],function(e,t,r,i,n,o,a){"use strict";var s=function(t){this._show=void 0,this._showSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._positions=void 0,this._positionsSubscription=void 0,this._minimumHeights=void 0,this._minimumHeightsSubscription=void 0,this._maximumHeights=void 0,this._maximumHeightsSubscription=void 0,this._granularity=void 0,this._granularitySubscription=void 0,this._fill=void 0,this._fillSubscription=void 0,this._outline=void 0,this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._definitionChanged=new n,this.merge(e(t,e.EMPTY_OBJECT))};return r(s.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:a("show"),material:o("material"),positions:a("positions"),minimumHeights:a("minimumHeights"),maximumHeights:a("maximumHeights"),granularity:a("granularity"),fill:a("fill"),outline:a("outline"),outlineColor:a("outlineColor"),outlineWidth:a("outlineWidth")}),s.prototype.clone=function(e){return t(e)?(e.show=this.show,e.material=this.material,e.positions=this.positions,e.minimumHeights=this.minimumHeights,e.maximumHeights=this.maximumHeights,e.granularity=this.granularity,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e):new s(this)},s.prototype.merge=function(r){if(!t(r))throw new i("source is required.");this.show=e(this.show,r.show),this.material=e(this.material,r.material),this.positions=e(this.positions,r.positions),this.minimumHeights=e(this.minimumHeights,r.minimumHeights),this.maximumHeights=e(this.maximumHeights,r.maximumHeights),this.granularity=e(this.granularity,r.granularity),this.fill=e(this.fill,r.fill),this.outline=e(this.outline,r.outline),this.outlineColor=e(this.outlineColor,r.outlineColor),this.outlineWidth=e(this.outlineWidth,r.outlineWidth)},s}),r("DataSources/Entity",["../Core/Cartesian3","../Core/createGuid","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/Matrix3","../Core/Matrix4","../Core/Quaternion","../Core/Transforms","./BillboardGraphics","./BoxGraphics","./ConstantPositionProperty","./CorridorGraphics","./createPropertyDescriptor","./createRawPropertyDescriptor","./CylinderGraphics","./EllipseGraphics","./EllipsoidGraphics","./LabelGraphics","./ModelGraphics","./PathGraphics","./PointGraphics","./PolygonGraphics","./PolylineGraphics","./PolylineVolumeGraphics","./Property","./RectangleGraphics","./WallGraphics"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f,v,g,_,y,w,C,E,S,b,T,x,P,A,I){"use strict";function D(e){return new m(e)}function M(e){return f(e,void 0,D)}function R(e,t){return f(e,void 0,function(e){return e instanceof t?e:new t(e)})}function O(e,t,r){for(var i=t.length,n=0;i>n;n++){var o=t[n],a=o._show,s=!r&&a,u=r&&a;s!==u&&O(o,o._children,r)}e._definitionChanged.raiseEvent(e,"isShowing",r,!r)}var N=function(e){e=r(e,r.EMPTY_OBJECT);var n=e.id;i(n)||(n=t()),this._availability=void 0,this._id=n,this._definitionChanged=new a,this._name=e.name,this._show=r(e.show,!0),this._parent=void 0,this._propertyNames=["billboard","box","corridor","cylinder","description","ellipse","ellipsoid","label","model","orientation","path","point","polygon","polyline","polylineVolume","position","rectangle","viewFrom","wall"],this._billboard=void 0,this._billboardSubscription=void 0,this._box=void 0,this._boxSubscription=void 0,this._corridor=void 0,this._corridorSubscription=void 0,this._cylinder=void 0,this._cylinderSubscription=void 0,this._description=void 0,this._descriptionSubscription=void 0,this._ellipse=void 0,this._ellipseSubscription=void 0,this._ellipsoid=void 0,this._ellipsoidSubscription=void 0,this._label=void 0,this._labelSubscription=void 0,this._model=void 0,this._modelSubscription=void 0,this._orientation=void 0,this._orientationSubscription=void 0,this._path=void 0,this._pathSubscription=void 0,this._point=void 0,this._pointSubscription=void 0,this._polygon=void 0,this._polygonSubscription=void 0,this._polyline=void 0,this._polylineSubscription=void 0,this._polylineVolume=void 0,this._polylineVolumeSubscription=void 0,this._position=void 0,this._positionSubscription=void 0,this._rectangle=void 0,this._rectangleSubscription=void 0,this._viewFrom=void 0,this._viewFromSubscription=void 0,this._wall=void 0,this._wallSubscription=void 0,this._children=[],this.parent=e.parent,this.merge(e)};n(N.prototype,{availability:v("availability"),id:{get:function(){return this._id}},definitionChanged:{get:function(){return this._definitionChanged}},name:v("name"),show:{get:function(){return this._show},set:function(e){if(!i(e))throw new o("value is required.");if(e!==this._show){var t=this.isShowing;this._show=e;var r=this.isShowing;t!==r&&O(this,this._children,r),this._definitionChanged.raiseEvent(this,"show",e,!e)}}},isShowing:{get:function(){return this._show&&(!i(this._parent)||this._parent.isShowing)}},parent:{get:function(){return this._parent},set:function(e){var t=this._parent;if(t!==e){var r=this.isShowing;if(i(t)){var n=t._children.indexOf(this);t._children.splice(n,1)}this._parent=e,e._children.push(this);var o=this.isShowing;r!==o&&O(this,this._children,o),this._definitionChanged.raiseEvent(this,"parent",e,t)}}},propertyNames:{get:function(){return this._propertyNames}},billboard:R("billboard",h),box:R("box",d),corridor:R("corridor",p),cylinder:R("cylinder",g),description:f("description"),ellipse:R("ellipse",_),ellipsoid:R("ellipsoid",y),label:R("label",w),model:R("model",C),orientation:f("orientation"),path:R("path",E),point:R("point",S),polygon:R("polygon",b),polyline:R("polyline",T),polylineVolume:R("polylineVolume",x),position:M("position"),rectangle:R("rectangle",A),viewFrom:f("viewFrom"),wall:R("wall",I)}),N.prototype.isAvailable=function(e){if(!i(e))throw new o("time is required.");var t=this._availability;return!i(t)||t.contains(e)},N.prototype.addProperty=function(e){var t=this._propertyNames;if(!i(e))throw new o("propertyName is required.");if(-1!==t.indexOf(e))throw new o(e+" is already a registered property.");if(e in this)throw new o(e+" is a reserved property name.");t.push(e),Object.defineProperty(this,e,v(e,!0))},N.prototype.removeProperty=function(e){var t=this._propertyNames;if(!i(e))throw new o("propertyName is required.");if(-1===t.indexOf(e))throw new o(e+" is not a registered property.");this._propertyNames.push(e),delete this[e]},N.prototype.merge=function(e){if(!i(e))throw new o("source is required.");this.name=r(this.name,e.name),this.availability=r(e.availability,this.availability);for(var t=this._propertyNames,n=i(e._propertyNames)?e._propertyNames:Object.keys(e),a=n.length,s=0;a>s;s++){var u=n[s];if("parent"!==u){var l=this[u],c=e[u];i(l)||-1!==t.indexOf(u)||this.addProperty(u),i(c)&&(i(l)?i(l.merge)&&l.merge(c):i(c.merge)&&i(c.clone)?this[u]=c.clone():this[u]=c)}}};var L=new s,F=new e,B=new l;return N.prototype._getModelMatrix=function(e,t){var r=P.getValueOrUndefined(this._position,e,F);if(!i(r))return void 0;var n=P.getValueOrUndefined(this._orientation,e,B);return t=i(n)?u.fromRotationTranslation(s.fromQuaternion(n,L),r,t):c.eastNorthUpToFixedFrame(r,void 0,t)},N}),r("DataSources/EntityCollection",["../Core/AssociativeArray","../Core/createGuid","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/Iso8601","../Core/JulianDate","../Core/RuntimeError","../Core/TimeInterval","./Entity"],function(e,t,r,i,n,o,a,s,u,l,c){"use strict";function h(e){if(0===e._suspendCount){var t=e._addedEntities,r=e._removedEntities,i=e._changedEntities;(0!==i.length||0!==t.length||0!==r.length)&&(e._collectionChanged.raiseEvent(e,t.values,r.values,i.values),t.removeAll(),r.removeAll(),i.removeAll())}}var d={id:void 0},m=function(){this._entities=new e,this._addedEntities=new e,this._removedEntities=new e,this._changedEntities=new e,this._suspendCount=0,this._collectionChanged=new o,this._id=t()};return m.prototype.suspendEvents=function(){this._suspendCount++},m.prototype.resumeEvents=function(){if(0===this._suspendCount)throw new n("resumeEvents can not be called before suspendEvents.");this._suspendCount--,h(this)},m.collectionChangedEventCallback=void 0,i(m.prototype,{collectionChanged:{get:function(){return this._collectionChanged}},id:{get:function(){return this._id}},values:{get:function(){return this._entities.values}}}),m.prototype.computeAvailability=function(){for(var e=a.MAXIMUM_VALUE,t=a.MINIMUM_VALUE,i=this._entities.values,n=0,o=i.length;o>n;n++){var u=i[n],c=u.availability;if(r(c)){var h=c.start,d=c.stop;s.lessThan(h,e)&&!h.equals(a.MINIMUM_VALUE)&&(e=h),s.greaterThan(d,t)&&!d.equals(a.MAXIMUM_VALUE)&&(t=d)}}return a.MAXIMUM_VALUE.equals(e)&&(e=a.MINIMUM_VALUE),a.MINIMUM_VALUE.equals(t)&&(t=a.MAXIMUM_VALUE),new l({start:e,stop:t})},m.prototype.add=function(e){if(!r(e))throw new n("entity is required.");e instanceof c||(e=new c(e));var t=e.id,i=this._entities;if(i.contains(t))throw new u("An entity with id "+t+" already exists in this collection.");i.set(t,e);this._removedEntities;return this._removedEntities.remove(t)||this._addedEntities.set(t,e),e.definitionChanged.addEventListener(m.prototype._onEntityDefinitionChanged,this),h(this),e},m.prototype.remove=function(e){return r(e)?this.removeById(e.id):!1},m.prototype.contains=function(e){if(!r(e))throw new n("entity is required");return this._entities.get(e.id)===e},m.prototype.removeById=function(e){if(!r(e))return!1;var t=this._entities,i=t.get(e);return this._entities.remove(e)?(this._addedEntities.remove(e)||(this._removedEntities.set(e,i),this._changedEntities.remove(e)),this._entities.remove(e),i.definitionChanged.removeEventListener(m.prototype._onEntityDefinitionChanged,this),h(this),!0):!1},m.prototype.removeAll=function(){for(var e=this._entities,t=e.length,i=e.values,n=this._addedEntities,o=this._removedEntities,a=0;t>a;a++){var s=i[a],u=s.id,l=n.get(u);r(l)||(s.definitionChanged.removeEventListener(m.prototype._onEntityDefinitionChanged,this),o.set(u,s))}e.removeAll(),n.removeAll(),this._changedEntities.removeAll(),h(this)},m.prototype.getById=function(e){if(!r(e))throw new n("id is required.");return this._entities.get(e)},m.prototype.getOrCreateEntity=function(e){if(!r(e))throw new n("id is required.");var t=this._entities.get(e);return r(t)||(d.id=e,t=new c(d),this.add(t)),t},m.prototype._onEntityDefinitionChanged=function(e){var t=e.id;this._addedEntities.contains(t)||this._changedEntities.set(t,e),h(this)},m}),r("DataSources/CompositeEntityCollection",["../Core/createGuid","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Math","./Entity","./EntityCollection"],function(e,t,r,i,n,o,a){"use strict";function s(e){for(var t=e.propertyNames,r=t.length,i=0;r>i;i++)e[t[i]]=void 0}function u(e,t,r,i){p[0]=r,p[1]=i.id,t[JSON.stringify(p)]=i.definitionChanged.addEventListener(f.prototype._onDefinitionChanged,e)}function l(e,t,r,i){p[0]=r,p[1]=i.id;var n=JSON.stringify(p);t[n](),t[n]=void 0}function c(e){if(e._shouldRecomposite=!0,0===e._suspendCount){var r,i,n,c,h,d,p=e._collections,v=p.length,g=e._collectionsCopy,_=g.length,y=e._composite,w=new a,C=e._eventHash;for(r=0;_>r;r++)for(h=g[r],h.collectionChanged.removeEventListener(f.prototype._onCollectionChanged,e),n=h.values,d=h.id,c=n.length-1;c>-1;c--)i=n[c],l(e,C,d,i);for(r=v-1;r>=0;r--)for(h=p[r],h.collectionChanged.addEventListener(f.prototype._onCollectionChanged,e),n=h.values,d=h.id,c=n.length-1;c>-1;c--){i=n[c],u(e,C,d,i);var E=w.getById(i.id);t(E)||(E=y.getById(i.id),t(E)?s(E):(m.id=i.id,E=new o(m)),w.add(E)),E.merge(i)}e._collectionsCopy=p.slice(0),y.suspendEvents(),y.removeAll();var S=w.values;for(r=0;r<S.length;r++)y.add(S[r]);y.resumeEvents()}}function h(e,r){if(!t(r))throw new i("collection is required.");var n=e.indexOf(r);if(-1===n)throw new i("collection is not in this composite.");return n}function d(e,t,r){var i=e._collections;if(t=n.clamp(t,0,i.length-1),r=n.clamp(r,0,i.length-1),t!==r){var o=i[t];i[t]=i[r],i[r]=o,c(e)}}var m={id:void 0},p=new Array(2),f=function(r){this._composite=new a,this._suspendCount=0,this._collections=t(r)?r.slice():[],this._collectionsCopy=[],this._id=e(),this._eventHash={},c(this),this._shouldRecomposite=!1};return r(f.prototype,{collectionChanged:{get:function(){return this._composite._collectionChanged}},id:{get:function(){return this._id}},values:{get:function(){return this._composite.values}}}),f.prototype.addCollection=function(e,r){var n=t(r);if(!t(e))throw new i("collection is required.");if(n){if(0>r)throw new i("index must be greater than or equal to zero.");if(r>this._collections.length)throw new i("index must be less than or equal to the number of collections.")}n?this._collections.splice(r,0,e):(r=this._collections.length,this._collections.push(e)),c(this)},f.prototype.removeCollection=function(e){var t=this._collections.indexOf(e);return-1!==t?(this._collections.splice(t,1),c(this),!0):!1},f.prototype.removeAllCollections=function(){this._collections.length=0,c(this)},f.prototype.containsCollection=function(e){return-1!==this._collections.indexOf(e)},f.prototype.contains=function(e){return this._composite.contains(e)},f.prototype.indexOfCollection=function(e){return this._collections.indexOf(e)},f.prototype.getCollection=function(e){if(!t(e))throw new i("index is required.","index");return this._collections[e]},f.prototype.getCollectionsLength=function(){return this._collections.length},f.prototype.raiseCollection=function(e){var t=h(this._collections,e);d(this,t,t+1)},f.prototype.lowerCollection=function(e){var t=h(this._collections,e);d(this,t,t-1)},f.prototype.raiseCollectionToTop=function(e){var t=h(this._collections,e);t!==this._collections.length-1&&(this._collections.splice(t,1),this._collections.push(e),c(this))},f.prototype.lowerCollectionToBottom=function(e){var t=h(this._collections,e);0!==t&&(this._collections.splice(t,1),this._collections.splice(0,0,e),c(this))},f.prototype.suspendEvents=function(){this._suspendCount++,this._composite.suspendEvents()},f.prototype.resumeEvents=function(){if(0===this._suspendCount)throw new i("resumeEvents can not be called before suspendEvents.");this._suspendCount--,this._shouldRecomposite&&0===this._suspendCount&&(c(this),this._shouldRecomposite=!1),this._composite.resumeEvents()},f.prototype.computeAvailability=function(){return this._composite.computeAvailability()},f.prototype.getById=function(e){
return this._composite.getById(e)},f.prototype._onCollectionChanged=function(e,r,i){var n=this._collectionsCopy,a=n.length,c=this._composite;c.suspendEvents();var h,d,p,f,v=i.length,g=this._eventHash,_=e.id;for(h=0;v>h;h++){var y=i[h];l(this,g,_,y);var w=y.id;for(d=a-1;d>=0;d--)p=n[d].getById(w),t(p)&&(t(f)||(f=c.getById(w),s(f)),f.merge(p));t(f)||c.removeById(w),f=void 0}var C=r.length;for(h=0;C>h;h++){var E=r[h];u(this,g,_,E);var S=E.id;for(d=a-1;d>=0;d--)p=n[d].getById(S),t(p)&&(t(f)||(f=c.getById(S),t(f)?s(f):(m.id=S,f=new o(m),c.add(f))),f.merge(p));f=void 0}c.resumeEvents()},f.prototype._onDefinitionChanged=function(e,r,i,n){for(var o=this._collections,a=this._composite,s=o.length,u=e.id,l=a.getById(u),c=l[r],h=!t(c),d=!0,m=s-1;m>=0;m--){var p=o[m].getById(e.id);if(t(p)){var f=p[r];if(t(f)){if(d){if(d=!1,!t(f.merge)||!t(f.clone)){c=f;break}c=f.clone(c)}c.merge(f)}}}h&&-1===l.propertyNames.indexOf(r)&&l.addProperty(r),l[r]=c},f}),r("DataSources/CompositeProperty",["../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/EventHelper","../Core/TimeIntervalCollection","./Property"],function(e,t,r,i,n,o,a){"use strict";function s(t,r,i,n){var o=function(){i.raiseEvent(t)},a=[];r.removeAll();for(var s=n.length,u=0;s>u;u++){var l=n.get(u);e(l.data)&&-1===a.indexOf(l.data)&&r.add(l.data.definitionChanged,o)}}var u=function(){this._eventHelper=new n,this._definitionChanged=new i,this._intervals=new o,this._intervals.changedEvent.addEventListener(u.prototype._intervalsChanged,this)};return t(u.prototype,{isConstant:{get:function(){return this._intervals.isEmpty}},definitionChanged:{get:function(){return this._definitionChanged}},intervals:{get:function(){return this._intervals}}}),u.prototype.getValue=function(t,i){if(!e(t))throw new r("time is required");var n=this._intervals.findDataForIntervalContainingDate(t);return e(n)?n.getValue(t,i):void 0},u.prototype.equals=function(e){return this===e||e instanceof u&&this._intervals.equals(e._intervals,a.equals)},u.prototype._intervalsChanged=function(){s(this,this._eventHelper,this._definitionChanged,this._intervals),this._definitionChanged.raiseEvent(this)},u}),r("DataSources/CompositeMaterialProperty",["../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","./CompositeProperty","./Property"],function(e,t,r,i,n,o){"use strict";var a=function(){this._definitionChanged=new i,this._composite=new n,this._composite.definitionChanged.addEventListener(a.prototype._raiseDefinitionChanged,this)};return t(a.prototype,{isConstant:{get:function(){return this._composite.isConstant}},definitionChanged:{get:function(){return this._definitionChanged}},intervals:{get:function(){return this._composite._intervals}}}),a.prototype.getType=function(t){if(!e(t))throw new r("time is required");var i=this._composite._intervals.findDataForIntervalContainingDate(t);return e(i)?i.getType(t):void 0},a.prototype.getValue=function(t,i){if(!e(t))throw new r("time is required");var n=this._composite._intervals.findDataForIntervalContainingDate(t);return e(n)?n.getValue(t,i):void 0},a.prototype.equals=function(e){return this===e||e instanceof a&&this._composite.equals(e._composite,o.equals)},a.prototype._raiseDefinitionChanged=function(){this._definitionChanged.raiseEvent(this)},a}),r("DataSources/CompositePositionProperty",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/ReferenceFrame","./CompositeProperty","./Property"],function(e,t,r,i,n,o,a,s){"use strict";var u=function(t){this._referenceFrame=e(t,o.FIXED),this._definitionChanged=new n,this._composite=new a,this._composite.definitionChanged.addEventListener(u.prototype._raiseDefinitionChanged,this)};return r(u.prototype,{isConstant:{get:function(){return this._composite.isConstant}},definitionChanged:{get:function(){return this._definitionChanged}},intervals:{get:function(){return this._composite.intervals}},referenceFrame:{get:function(){return this._referenceFrame},set:function(e){this._referenceFrame=e}}}),u.prototype.getValue=function(e,t){return this.getValueInReferenceFrame(e,o.FIXED,t)},u.prototype.getValueInReferenceFrame=function(e,r,n){if(!t(e))throw new i("time is required.");if(!t(r))throw new i("referenceFrame is required.");var o=this._composite._intervals.findDataForIntervalContainingDate(e);return t(o)?o.getValueInReferenceFrame(e,r,n):void 0},u.prototype.equals=function(e){return this===e||e instanceof u&&this._referenceFrame===e._referenceFrame&&this._composite.equals(e._composite,s.equals)},u.prototype._raiseDefinitionChanged=function(){this._definitionChanged.raiseEvent(this)},u}),r("DataSources/CorridorGeometryUpdater",["../Core/Color","../Core/ColorGeometryInstanceAttribute","../Core/CorridorGeometry","../Core/CorridorOutlineGeometry","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Event","../Core/GeometryInstance","../Core/Iso8601","../Core/ShowGeometryInstanceAttribute","../Scene/MaterialAppearance","../Scene/PerInstanceColorAppearance","../Scene/Primitive","./ColorMaterialProperty","./ConstantProperty","./dynamicGeometryGetBoundingSphere","./MaterialProperty","./Property"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f,v,g,_,y,w){"use strict";var C=new v(e.WHITE),E=new g(!0),S=new g(!0),b=new g(!1),T=new g(e.BLACK),x=new e,P=function(e){this.id=e,this.vertexFormat=void 0,this.positions=void 0,this.width=void 0,this.cornerType=void 0,this.height=void 0,this.extrudedHeight=void 0,this.granularity=void 0},A=function(e,t){if(!o(e))throw new u("entity is required");if(!o(t))throw new u("scene is required");this._entity=e,this._scene=t,this._entitySubscription=e.definitionChanged.addEventListener(A.prototype._onEntityPropertyChanged,this),this._fillEnabled=!1,this._isClosed=!1,this._dynamic=!1,this._outlineEnabled=!1,this._geometryChanged=new l,this._showProperty=void 0,this._materialProperty=void 0,this._hasConstantOutline=!0,this._showOutlineProperty=void 0,this._outlineColorProperty=void 0,this._outlineWidth=1,this._options=new P(e),this._onEntityPropertyChanged(e,"corridor",e.corridor,void 0)};a(A,{perInstanceColorAppearanceType:{value:p},materialAppearanceType:{value:m}}),a(A.prototype,{entity:{get:function(){return this._entity}},fillEnabled:{get:function(){return this._fillEnabled}},hasConstantFill:{get:function(){return!this._fillEnabled||!o(this._entity.availability)&&w.isConstant(this._showProperty)&&w.isConstant(this._fillProperty)}},fillMaterialProperty:{get:function(){return this._materialProperty}},outlineEnabled:{get:function(){return this._outlineEnabled}},hasConstantOutline:{get:function(){return!this._outlineEnabled||!o(this._entity.availability)&&w.isConstant(this._showProperty)&&w.isConstant(this._showOutlineProperty)}},outlineColorProperty:{get:function(){return this._outlineColorProperty}},outlineWidth:{get:function(){return this._outlineWidth}},isDynamic:{get:function(){return this._dynamic}},isClosed:{get:function(){return this._isClosed}},geometryChanged:{get:function(){return this._geometryChanged}}}),A.prototype.isOutlineVisible=function(e){var t=this._entity;return this._outlineEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)},A.prototype.isFilled=function(e){var t=this._entity;return this._fillEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._fillProperty.getValue(e)},A.prototype.createFillGeometryInstance=function(i){if(!o(i))throw new u("time is required.");if(!this._fillEnabled)throw new u("This instance does not represent a filled geometry.");var n,a,s=this._entity,l=s.isAvailable(i),h=new d(l&&s.isShowing&&this._showProperty.getValue(i)&&this._fillProperty.getValue(i));if(this._materialProperty instanceof v){var m=e.WHITE;o(this._materialProperty.color)&&(this._materialProperty.color.isConstant||l)&&(m=this._materialProperty.color.getValue(i)),a=t.fromColor(m),n={show:h,color:a}}else n={show:h};return new c({id:s,geometry:new r(this._options),attributes:n})},A.prototype.createOutlineGeometryInstance=function(r){if(!o(r))throw new u("time is required.");if(!this._outlineEnabled)throw new u("This instance does not represent an outlined geometry.");var n=this._entity,a=n.isAvailable(r),s=w.getValueOrDefault(this._outlineColorProperty,r,e.BLACK);return new c({id:n,geometry:new i(this._options),attributes:{show:new d(a&&n.isShowing&&this._showProperty.getValue(r)&&this._showOutlineProperty.getValue(r)),color:t.fromColor(s)}})},A.prototype.isDestroyed=function(){return!1},A.prototype.destroy=function(){this._entitySubscription(),s(this)},A.prototype._onEntityPropertyChanged=function(e,t,r,i){if("availability"===t||"corridor"===t){var a=this._entity.corridor;if(!o(a))return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var s=a.fill,u=o(s)&&s.isConstant?s.getValue(h.MINIMUM_VALUE):!0,l=a.outline,c=o(l);if(c&&l.isConstant&&(c=l.getValue(h.MINIMUM_VALUE)),!u&&!c)return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var d=a.positions,f=a.show;if(o(f)&&f.isConstant&&!f.getValue(h.MINIMUM_VALUE)||!o(d))return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var g=n(a.material,C),_=g instanceof v;this._materialProperty=g,this._fillProperty=n(s,S),this._showProperty=n(f,E),this._showOutlineProperty=n(a.outline,b),this._outlineColorProperty=c?n(a.outlineColor,T):void 0;var y=a.height,x=a.extrudedHeight,P=a.granularity,A=a.width,I=a.outlineWidth,D=a.cornerType;if(this._isClosed=o(x),this._fillEnabled=u,this._outlineEnabled=c,d.isConstant&&w.isConstant(y)&&w.isConstant(x)&&w.isConstant(P)&&w.isConstant(A)&&w.isConstant(I)&&w.isConstant(D)){var M=this._options;M.vertexFormat=_?p.VERTEX_FORMAT:m.MaterialSupport.TEXTURED.vertexFormat,M.positions=d.getValue(h.MINIMUM_VALUE,M.positions),M.height=o(y)?y.getValue(h.MINIMUM_VALUE):void 0,M.extrudedHeight=o(x)?x.getValue(h.MINIMUM_VALUE):void 0,M.granularity=o(P)?P.getValue(h.MINIMUM_VALUE):void 0,M.width=o(A)?A.getValue(h.MINIMUM_VALUE):void 0,M.cornerType=o(D)?D.getValue(h.MINIMUM_VALUE):void 0,this._outlineWidth=o(I)?I.getValue(h.MINIMUM_VALUE):1,this._dynamic=!1,this._geometryChanged.raiseEvent(this)}else this._dynamic||(this._dynamic=!0,this._geometryChanged.raiseEvent(this))}},A.prototype.createDynamicUpdater=function(e){if(!this._dynamic)throw new u("This instance does not represent dynamic geometry.");if(!o(e))throw new u("primitives is required.");return new I(e,this)};var I=function(e,t){this._primitives=e,this._primitive=void 0,this._outlinePrimitive=void 0,this._geometryUpdater=t,this._options=new P(t._entity)};return I.prototype.update=function(n){if(!o(n))throw new u("time is required.");var a=this._primitives;a.removeAndDestroy(this._primitive),a.removeAndDestroy(this._outlinePrimitive),this._primitive=void 0,this._outlinePrimitive=void 0;var s=this._geometryUpdater,l=s._entity,h=l.corridor;if(l.isShowing&&l.isAvailable(n)&&w.getValueOrDefault(h.show,n,!0)){var d=this._options,v=w.getValueOrUndefined(h.positions,n,d.positions),g=w.getValueOrUndefined(h.width,n);if(o(v)&&o(g)){if(d.positions=v,d.width=g,d.height=w.getValueOrUndefined(h.height,n),d.extrudedHeight=w.getValueOrUndefined(h.extrudedHeight,n),d.granularity=w.getValueOrUndefined(h.granularity,n),d.cornerType=w.getValueOrUndefined(h.cornerType,n),!o(h.fill)||h.fill.getValue(n)){var _=y.getValue(n,s.fillMaterialProperty,this._material);this._material=_;var C=new m({material:_,translucent:_.isTranslucent(),closed:o(d.extrudedHeight)});d.vertexFormat=C.vertexFormat,this._primitive=a.add(new f({geometryInstances:new c({id:l,geometry:new r(d)}),appearance:C,asynchronous:!1}))}if(o(h.outline)&&h.outline.getValue(n)){d.vertexFormat=p.VERTEX_FORMAT;var E=w.getValueOrClonedDefault(h.outlineColor,n,e.BLACK,x),S=w.getValueOrDefault(h.outlineWidth,n,1),b=1!==E.alpha;this._outlinePrimitive=a.add(new f({geometryInstances:new c({id:l,geometry:new i(d),attributes:{color:t.fromColor(E)}}),appearance:new p({flat:!0,translucent:b,renderState:{lineWidth:s._scene.clampLineWidth(S)}}),asynchronous:!1}))}}}},I.prototype.getBoundingSphere=function(e,t){return _(e,this._primitive,this._outlinePrimitive,t)},I.prototype.isDestroyed=function(){return!1},I.prototype.destroy=function(){var e=this._primitives;e.removeAndDestroy(this._primitive),e.removeAndDestroy(this._outlinePrimitive),s(this)},A}),r("DataSources/DataSource",["../Core/defineProperties","../Core/DeveloperError"],function(e,t){"use strict";var r=function(){t.throwInstantiationError()};return e(r.prototype,{name:{get:t.throwInstantiationError},clock:{get:t.throwInstantiationError},entities:{get:t.throwInstantiationError},isLoading:{get:t.throwInstantiationError},changedEvent:{get:t.throwInstantiationError},errorEvent:{get:t.throwInstantiationError},loadingEvent:{get:t.throwInstantiationError}}),r.prototype.update=t.throwInstantiationError,r.setLoading=function(e,t){e._isLoading!==t&&(t?e._entityCollection.suspendEvents():e._entityCollection.resumeEvents(),e._isLoading=t,e._loading.raiseEvent(e,t))},r}),r("DataSources/CustomDataSource",["../Core/defineProperties","../Core/Event","./DataSource","./EntityCollection"],function(e,t,r,i){"use strict";var n=function(e){this._name=e,this._clock=void 0,this._changed=new t,this._error=new t,this._isLoading=!1,this._loading=new t,this._entityCollection=new i};return e(n.prototype,{name:{get:function(){return this._name},set:function(e){this._name!==e&&(this._name=e,this._changed.raiseEvent(this))}},clock:{get:function(){return this._clock},set:function(e){this._clock!==e&&(this._clock=e,this._changed.raiseEvent(this))}},entities:{get:function(){return this._entityCollection}},isLoading:{get:function(){return this._isLoading},set:function(e){r.setLoading(this,e)}},changedEvent:{get:function(){return this._changed}},errorEvent:{get:function(){return this._error}},loadingEvent:{get:function(){return this._loading}}}),n}),r("DataSources/CylinderGeometryUpdater",["../Core/Cartesian3","../Core/Color","../Core/ColorGeometryInstanceAttribute","../Core/CylinderGeometry","../Core/CylinderOutlineGeometry","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Event","../Core/GeometryInstance","../Core/Iso8601","../Core/ShowGeometryInstanceAttribute","../Scene/MaterialAppearance","../Scene/PerInstanceColorAppearance","../Scene/Primitive","./ColorMaterialProperty","./ConstantProperty","./dynamicGeometryGetBoundingSphere","./MaterialProperty","./Property"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f,v,g,_,y,w,C){"use strict";var E=new g(t.WHITE),S=new _(!0),b=new _(!0),T=new _(!1),x=new _(t.BLACK),P=new t,A=function(e){this.id=e,this.vertexFormat=void 0,this.length=void 0,this.topRadius=void 0,this.bottomRadius=void 0,this.slices=void 0,this.numberOfVerticalLines=void 0},I=function(e,t){if(!a(e))throw new l("entity is required");if(!a(t))throw new l("scene is required");this._entity=e,this._scene=t,this._entitySubscription=e.definitionChanged.addEventListener(I.prototype._onEntityPropertyChanged,this),this._fillEnabled=!1,this._dynamic=!1,this._outlineEnabled=!1,this._geometryChanged=new c,this._showProperty=void 0,this._materialProperty=void 0,this._hasConstantOutline=!0,this._showOutlineProperty=void 0,this._outlineColorProperty=void 0,this._outlineWidth=1,this._options=new A(e),this._onEntityPropertyChanged(e,"cylinder",e.cylinder,void 0)};s(I,{perInstanceColorAppearanceType:{value:f},materialAppearanceType:{value:p}}),s(I.prototype,{entity:{get:function(){return this._entity}},fillEnabled:{get:function(){return this._fillEnabled}},hasConstantFill:{get:function(){return!this._fillEnabled||!a(this._entity.availability)&&C.isConstant(this._showProperty)&&C.isConstant(this._fillProperty)}},fillMaterialProperty:{get:function(){return this._materialProperty}},outlineEnabled:{get:function(){return this._outlineEnabled}},hasConstantOutline:{get:function(){return!this._outlineEnabled||!a(this._entity.availability)&&C.isConstant(this._showProperty)&&C.isConstant(this._showOutlineProperty)}},outlineColorProperty:{get:function(){return this._outlineColorProperty}},outlineWidth:{get:function(){return this._outlineWidth}},isDynamic:{get:function(){return this._dynamic}},isClosed:{value:!0},geometryChanged:{get:function(){return this._geometryChanged}}}),I.prototype.isOutlineVisible=function(e){var t=this._entity;return this._outlineEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)},I.prototype.isFilled=function(e){var t=this._entity;return this._fillEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._fillProperty.getValue(e)},I.prototype.createFillGeometryInstance=function(e){if(!a(e))throw new l("time is required.");if(!this._fillEnabled)throw new l("This instance does not represent a filled geometry.");var n,o,s=this._entity,u=s.isAvailable(e),c=new m(u&&s.isShowing&&this._showProperty.getValue(e)&&this._fillProperty.getValue(e));if(this._materialProperty instanceof g){var p=t.WHITE;a(this._materialProperty.color)&&(this._materialProperty.color.isConstant||u)&&(p=this._materialProperty.color.getValue(e)),o=r.fromColor(p),n={show:c,color:o}}else n={show:c};return new h({id:s,geometry:new i(this._options),modelMatrix:s._getModelMatrix(d.MINIMUM_VALUE),attributes:n})},I.prototype.createOutlineGeometryInstance=function(e){if(!a(e))throw new l("time is required.");if(!this._outlineEnabled)throw new l("This instance does not represent an outlined geometry.");var i=this._entity,o=i.isAvailable(e),s=C.getValueOrDefault(this._outlineColorProperty,e,t.BLACK);return new h({id:i,geometry:new n(this._options),modelMatrix:i._getModelMatrix(d.MINIMUM_VALUE),attributes:{show:new m(o&&i.isShowing&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)),color:r.fromColor(s)}})},I.prototype.isDestroyed=function(){return!1},I.prototype.destroy=function(){this._entitySubscription(),u(this)},I.prototype._onEntityPropertyChanged=function(e,t,r,i){if("availability"===t||"position"===t||"orientation"===t||"cylinder"===t){var n=e.cylinder;if(!a(n))return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var s=n.fill,u=a(s)&&s.isConstant?s.getValue(d.MINIMUM_VALUE):!0,l=n.outline,c=a(l);if(c&&l.isConstant&&(c=l.getValue(d.MINIMUM_VALUE)),!u&&!c)return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var h=e.position,m=n.length,v=n.topRadius,_=n.bottomRadius,y=n.show;if(a(y)&&y.isConstant&&!y.getValue(d.MINIMUM_VALUE)||!a(h)||!a(m)||!a(v)||!a(_))return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var w=o(n.material,E),P=w instanceof g;this._materialProperty=w,this._fillProperty=o(s,b),this._showProperty=o(y,S),this._showOutlineProperty=o(n.outline,T),this._outlineColorProperty=c?o(n.outlineColor,x):void 0;var A=n.slices,I=n.outlineWidth,D=n.numberOfVerticalLines;if(this._fillEnabled=u,this._outlineEnabled=c,h.isConstant&&C.isConstant(e.orientation)&&m.isConstant&&v.isConstant&&_.isConstant&&C.isConstant(A)&&C.isConstant(I)&&C.isConstant(D)){var M=this._options;M.vertexFormat=P?f.VERTEX_FORMAT:p.MaterialSupport.TEXTURED.vertexFormat,M.length=m.getValue(d.MINIMUM_VALUE),M.topRadius=v.getValue(d.MINIMUM_VALUE),M.bottomRadius=_.getValue(d.MINIMUM_VALUE),M.slices=a(A)?A.getValue(d.MINIMUM_VALUE):void 0,M.numberOfVerticalLines=a(D)?D.getValue(d.MINIMUM_VALUE):void 0,this._outlineWidth=a(I)?I.getValue(d.MINIMUM_VALUE):1,this._dynamic=!1,this._geometryChanged.raiseEvent(this)}else this._dynamic||(this._dynamic=!0,this._geometryChanged.raiseEvent(this))}},I.prototype.createDynamicUpdater=function(e){if(!this._dynamic)throw new l("This instance does not represent dynamic geometry.");if(!a(e))throw new l("primitives is required.");return new D(e,this)};var D=function(e,t){this._primitives=e,this._primitive=void 0,this._outlinePrimitive=void 0,this._geometryUpdater=t,this._options=new A(t._entity)};return D.prototype.update=function(e){if(!a(e))throw new l("time is required.");var o=this._primitives;o.removeAndDestroy(this._primitive),o.removeAndDestroy(this._outlinePrimitive),this._primitive=void 0,this._outlinePrimitive=void 0;var s=this._geometryUpdater,u=s._entity,c=u.cylinder;if(u.isShowing&&u.isAvailable(e)&&C.getValueOrDefault(c.show,e,!0)){var d=this._options,m=u._getModelMatrix(e),g=C.getValueOrUndefined(c.length,e),_=C.getValueOrUndefined(c.topRadius,e),y=C.getValueOrUndefined(c.bottomRadius,e);if(a(m)&&a(g)&&a(_)&&a(y)){if(d.length=g,d.topRadius=_,d.bottomRadius=y,d.slices=C.getValueOrUndefined(c.slices,e),d.numberOfVerticalLines=C.getValueOrUndefined(c.numberOfVerticalLines,e),C.getValueOrDefault(c.fill,e,!0)){var E=w.getValue(e,s.fillMaterialProperty,this._material);this._material=E;var S=new p({material:E,translucent:E.isTranslucent(),closed:!0});d.vertexFormat=S.vertexFormat,this._primitive=o.add(new v({geometryInstances:new h({id:u,geometry:new i(d),modelMatrix:m}),appearance:S,asynchronous:!1}))}if(C.getValueOrDefault(c.outline,e,!1)){d.vertexFormat=f.VERTEX_FORMAT;var b=C.getValueOrClonedDefault(c.outlineColor,e,t.BLACK,P),T=C.getValueOrDefault(c.outlineWidth,e,1),x=1!==b.alpha;this._outlinePrimitive=o.add(new v({geometryInstances:new h({id:u,geometry:new n(d),modelMatrix:m,attributes:{color:r.fromColor(b)}}),appearance:new f({flat:!0,translucent:x,renderState:{lineWidth:s._scene.clampLineWidth(T)}}),asynchronous:!1}))}}}},D.prototype.getBoundingSphere=function(e,t){return y(e,this._primitive,this._outlinePrimitive,t)},D.prototype.isDestroyed=function(){return!1},D.prototype.destroy=function(){var e=this._primitives;e.removeAndDestroy(this._primitive),e.removeAndDestroy(this._outlinePrimitive),u(this)},I}),r("Scene/LabelStyle",["../Core/freezeObject"],function(e){"use strict";var t={FILL:0,OUTLINE:1,FILL_AND_OUTLINE:2};return e(t)}),r("DataSources/DataSourceClock",["../Core/Clock","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/JulianDate","./createRawPropertyDescriptor"],function(e,t,r,i,n,o,a,s){"use strict";var u=function(){this._startTime=void 0,this._stopTime=void 0,this._currentTime=void 0,this._clockRange=void 0,this._clockStep=void 0,this._multiplier=void 0,this._definitionChanged=new o};return i(u.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},startTime:s("startTime"),stopTime:s("stopTime"),currentTime:s("currentTime"),clockRange:s("clockRange"),clockStep:s("clockStep"),multiplier:s("multiplier")}),u.prototype.clone=function(e){return r(e)||(e=new u),e.startTime=this.startTime,e.stopTime=this.stopTime,e.currentTime=this.currentTime,e.clockRange=this.clockRange,e.clockStep=this.clockStep,e.multiplier=this.multiplier,e},u.prototype.equals=function(e){return this===e||r(e)&&a.equals(this.startTime,e.startTime)&&a.equals(this.stopTime,e.stopTime)&&a.equals(this.currentTime,e.currentTime)&&this.clockRange===e.clockRange&&this.clockStep===e.clockStep&&this.multiplier===e.multiplier},u.prototype.merge=function(e){if(!r(e))throw new n("source is required.");this.startTime=t(this.startTime,e.startTime),this.stopTime=t(this.stopTime,e.stopTime),this.currentTime=t(this.currentTime,e.currentTime),this.clockRange=t(this.clockRange,e.clockRange),this.clockStep=t(this.clockStep,e.clockStep),this.multiplier=t(this.multiplier,e.multiplier)},u.prototype.getValue=function(t){return r(t)||(t=new e),t.startTime=this.startTime,t.stopTime=this.stopTime,t.clockRange=this.clockRange,t.clockStep=this.clockStep,t.multiplier=this.multiplier,t.currentTime=this.currentTime,t},u}),r("DataSources/GridMaterialProperty",["../Core/Cartesian2","../Core/Color","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/Event","./createPropertyDescriptor","./Property"],function(e,t,r,i,n,o,a,s){"use strict";var u=t.WHITE,l=.1,c=new e(8,8),h=new e(0,0),d=new e(1,1),m=function(e){e=r(e,r.EMPTY_OBJECT),this._definitionChanged=new o,this._color=void 0,this._colorSubscription=void 0,this._cellAlpha=void 0,this._cellAlphaSubscription=void 0,this._lineCount=void 0,this._lineCountSubscription=void 0,this._lineThickness=void 0,this._lineThicknessSubscription=void 0,this._lineOffset=void 0,this._lineOffsetSubscription=void 0,this.color=e.color,this.cellAlpha=e.cellAlpha,this.lineCount=e.lineCount,this.lineThickness=e.lineThickness,this.lineOffset=e.lineOffset};return n(m.prototype,{isConstant:{get:function(){return s.isConstant(this._color)&&s.isConstant(this._cellAlpha)&&s.isConstant(this._lineCount)&&s.isConstant(this._lineThickness)&&s.isConstant(this._lineOffset)}},definitionChanged:{get:function(){return this._definitionChanged}},color:a("color"),cellAlpha:a("cellAlpha"),lineCount:a("lineCount"),lineThickness:a("lineThickness"),lineOffset:a("lineOffset")}),m.prototype.getType=function(e){return"Grid"},m.prototype.getValue=function(e,t){return i(t)||(t={}),t.color=s.getValueOrClonedDefault(this._color,e,u,t.color),t.cellAlpha=s.getValueOrDefault(this._cellAlpha,e,l),t.lineCount=s.getValueOrClonedDefault(this._lineCount,e,c,t.lineCount),t.lineThickness=s.getValueOrClonedDefault(this._lineThickness,e,d,t.lineThickness),t.lineOffset=s.getValueOrClonedDefault(this._lineOffset,e,h,t.lineOffset),t},m.prototype.equals=function(e){return this===e||e instanceof m&&s.equals(this._color,e._color)&&s.equals(this._cellAlpha,e._cellAlpha)&&s.equals(this._lineCount,e._lineCount)&&s.equals(this._lineThickness,e._lineThickness)&&s.equals(this._lineOffset,e._lineOffset)},m}),r("DataSources/PolylineGlowMaterialProperty",["../Core/Color","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/Event","./createPropertyDescriptor","./Property"],function(e,t,r,i,n,o,a){"use strict";var s=e.WHITE,u=.25,l=function(e){e=t(e,t.EMPTY_OBJECT),this._definitionChanged=new n,this._color=void 0,this._colorSubscription=void 0,this._glowPower=void 0,this._glowPowerSubscription=void 0,this.color=e.color,this.glowPower=e.glowPower};return i(l.prototype,{isConstant:{get:function(){return a.isConstant(this._color)&&a.isConstant(this._glow)}},definitionChanged:{get:function(){return this._definitionChanged}},color:o("color"),glowPower:o("glowPower")}),l.prototype.getType=function(e){return"PolylineGlow"},l.prototype.getValue=function(e,t){return r(t)||(t={}),t.color=a.getValueOrClonedDefault(this._color,e,s,t.color),t.glowPower=a.getValueOrDefault(this._glowPower,e,u,t.glowPower),t},l.prototype.equals=function(e){return this===e||e instanceof l&&a.equals(this._color,e._color)&&a.equals(this._glowPower,e._glowPower)},l}),r("DataSources/PolylineOutlineMaterialProperty",["../Core/Color","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/Event","./createPropertyDescriptor","./Property"],function(e,t,r,i,n,o,a){"use strict";var s=e.WHITE,u=e.BLACK,l=1,c=function(e){e=t(e,t.EMPTY_OBJECT),this._definitionChanged=new n,this._color=void 0,this._colorSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this.color=e.color,this.outlineColor=e.outlineColor,this.outlineWidth=e.outlineWidth};return i(c.prototype,{isConstant:{get:function(){return a.isConstant(this._color)&&a.isConstant(this._outlineColor)&&a.isConstant(this._outlineWidth)}},definitionChanged:{get:function(){return this._definitionChanged}},color:o("color"),outlineColor:o("outlineColor"),outlineWidth:o("outlineWidth")}),c.prototype.getType=function(e){return"PolylineOutline"},c.prototype.getValue=function(e,t){return r(t)||(t={}),t.color=a.getValueOrClonedDefault(this._color,e,s,t.color),t.outlineColor=a.getValueOrClonedDefault(this._outlineColor,e,u,t.outlineColor),t.outlineWidth=a.getValueOrDefault(this._outlineWidth,e,l),t},c.prototype.equals=function(e){return this===e||e instanceof c&&a.equals(this._color,e._color)&&a.equals(this._outlineColor,e._outlineColor)&&a.equals(this._outlineWidth,e._outlineWidth)},c}),r("DataSources/PositionPropertyArray",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/EventHelper","../Core/ReferenceFrame","./Property"],function(e,t,r,i,n,o,a,s){"use strict";var u=function(t,r){this._value=void 0,this._definitionChanged=new n,this._eventHelper=new o,this._referenceFrame=e(r,a.FIXED),this.setValue(t)};return r(u.prototype,{isConstant:{get:function(){var e=this._value;if(!t(e))return!0;for(var r=e.length,i=0;r>i;i++)if(!s.isConstant(e[i]))return!1;return!0}},definitionChanged:{get:function(){return this._definitionChanged}},referenceFrame:{get:function(){return this._referenceFrame}}}),u.prototype.getValue=function(e,t){return this.getValueInReferenceFrame(e,a.FIXED,t)},u.prototype.getValueInReferenceFrame=function(e,r,n){if(!t(e))throw new i("time is required.");if(!t(r))throw new i("referenceFrame is required.");var o=this._value;if(!t(o))return void 0;var a=o.length;t(n)||(n=new Array(a));for(var s=0,u=0;a>s;){var l=o[s],c=l.getValueInReferenceFrame(e,r,n[s]);t(c)&&(n[u]=c,u++),s++}return n.length=u,n},u.prototype.setValue=function(e){var r=this._eventHelper;if(r.removeAll(),t(e)){this._value=e.slice();for(var i=e.length,n=0;i>n;n++){var o=e[n];t(o)&&r.add(o.definitionChanged,u.prototype._raiseDefinitionChanged,this)}}else this._value=void 0;this._definitionChanged.raiseEvent(this)},u.prototype.equals=function(e){return this===e||e instanceof u&&this._referenceFrame===e._referenceFrame&&s.arrayEquals(this._value,e._value)},u.prototype._raiseDefinitionChanged=function(){this._definitionChanged.raiseEvent(this)},u}),r("DataSources/ReferenceProperty",["../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/RuntimeError","./Property"],function(e,t,r,i,n,o){"use strict";function a(t){var r=!0;if(t._resolveEntity){var i=t._targetCollection.getById(t._targetId);if(e(i)?(i.definitionChanged.addEventListener(u.prototype._onTargetEntityDefinitionChanged,t),t._targetEntity=i,t._resolveEntity=!1):(i=t._targetEntity,r=!1),!e(i))throw new n('target entity "'+t._targetId+'" could not be resolved.')}return r}function s(t){var r=t._targetProperty;if(t._resolveProperty){var i=a(t),o=t._targetPropertyNames;r=t._targetEntity;for(var s=o.length,u=0;s>u&&e(r);u++)r=r[o[u]];if(e(r))t._targetProperty=r,t._resolveProperty=!i;else if(!e(t._targetProperty))throw new n('targetProperty "'+t._targetId+"."+o.join(".")+'" could not be resolved.')}return r}var u=function(t,n,o){if(!e(t))throw new r("targetCollection is required.");if(!e(n)||""===n)throw new r("targetId is required.");if(!e(o)||0===o.length)throw new r("targetPropertyNames is required.");for(var a=0;a<o.length;a++){var s=o[a];if(!e(s)||""===s)throw new r("reference contains invalid properties.")}this._targetCollection=t,this._targetId=n,this._targetPropertyNames=o,this._targetProperty=void 0,this._targetEntity=void 0,this._definitionChanged=new i,this._resolveEntity=!0,this._resolveProperty=!0,t.collectionChanged.addEventListener(u.prototype._onCollectionChanged,this)};return t(u.prototype,{isConstant:{get:function(){return o.isConstant(s(this))}},definitionChanged:{get:function(){return this._definitionChanged}},referenceFrame:{get:function(){return s(this).referenceFrame}},targetId:{get:function(){return this._targetId}},targetCollection:{get:function(){return this._targetCollection}},targetPropertyNames:{get:function(){return this._targetPropertyNames}},resolvedProperty:{get:function(){return s(this)}}}),u.fromString=function(t,i){
if(!e(t))throw new r("targetCollection is required.");if(!e(i))throw new r("referenceString is required.");for(var n,o=[],a=!0,s=!1,l="",c=0;c<i.length;++c){var h=i.charAt(c);s?(l+=h,s=!1):"\\"===h?s=!0:a&&"#"===h?(n=l,a=!1,l=""):a||"."!==h?l+=h:(o.push(l),l="")}return o.push(l),new u(t,n,o)},u.prototype.getValue=function(e,t){return s(this).getValue(e,t)},u.prototype.getValueInReferenceFrame=function(e,t,r){return s(this).getValueInReferenceFrame(e,t,r)},u.prototype.getType=function(e){return s(this).getType(e)},u.prototype.equals=function(e){if(this===e)return!0;var t=this._targetPropertyNames,r=e._targetPropertyNames;if(this._targetCollection!==e._targetCollection||this._targetId!==e._targetId||t.length!==r.length)return!1;for(var i=this._targetPropertyNames.length,n=0;i>n;n++)if(t[n]!==r[n])return!1;return!0},u.prototype._onTargetEntityDefinitionChanged=function(e,t,r,i){this._targetPropertyNames[0]===t&&(this._resolveProperty=!0,this._definitionChanged.raiseEvent(this))},u.prototype._onCollectionChanged=function(t,r,i){var n=this._targetEntity;e(n)&&(-1!==i.indexOf(n)?(n.definitionChanged.removeEventListener(u.prototype._onTargetEntityDefinitionChanged,this),this._resolveEntity=!0,this._resolveProperty=!0):this._resolveEntity&&(s(this),this._resolveEntity||this._definitionChanged.raiseEvent(this)))},u}),r("DataSources/Rotation",["../Core/defaultValue","../Core/defined","../Core/DeveloperError","../Core/Math"],function(e,t,r,i){"use strict";var n={packedLength:1,pack:function(i,n,o){if(!t(i))throw new r("value is required");if(!t(n))throw new r("array is required");o=e(o,0),n[o]=i},unpack:function(i,n,o){if(!t(i))throw new r("array is required");return n=e(n,0),i[n]},convertPackedArrayForInterpolation:function(n,o,a,s){if(!t(n))throw new r("packedArray is required");o=e(o,0),a=e(a,n.length);for(var u,l=0,c=a-o+1;c>l;l++){var h=n[o+l];0===l||Math.abs(u-h)<Math.PI?s[l]=h:s[l]=h-i.TWO_PI,u=h}},unpackInterpolationResult:function(e,n,o,a,s){if(!t(e))throw new r("array is required");if(!t(n))throw new r("sourceArray is required");return s=e[0],0>s?s+i.TWO_PI:s}};return n}),r("DataSources/SampledProperty",["../Core/binarySearch","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/ExtrapolationType","../Core/JulianDate","../Core/LinearApproximation"],function(e,t,r,i,n,o,a,s,u){"use strict";function l(e,t,r){var i,n=e.length,o=r.length,a=n+o;if(e.length=a,n!==t){var s=n-1;for(i=a-1;i>=t;i--)e[i]=e[s--]}for(i=0;o>i;i++)e[t++]=r[i]}function c(e,t){return e instanceof s?e:"string"==typeof e?s.fromIso8601(e):s.addSeconds(t,e,new s)}var h={packedLength:1,pack:function(e,r,i){i=t(i,0),r[i]=e},unpack:function(e,r,i){return r=t(r,0),e[r]}},d=[],m=[],p=function(t,i,n,o,a){for(var u,h,p,f,v,g,_=0;_<o.length;){v=c(o[_],t),p=e(i,v,s.compare);var y=0,w=0;if(0>p){for(p=~p,f=p*a,h=void 0,g=i[p];_<o.length&&(v=c(o[_],t),!(r(h)&&s.compare(h,v)>=0||r(g)&&s.compare(v,g)>=0));){for(d[y++]=v,_+=1,u=0;a>u;u++)m[w++]=o[_],_+=1;h=v}y>0&&(m.length=w,l(n,f,m),d.length=y,l(i,p,d))}else{for(u=0;a>u;u++)_++,n[p*a+u]=o[_];_++}}},f=function(e,i){if(!r(e))throw new n("type is required.");var s=e;s===Number&&(s=h);var l,c=s.packedLength,d=t(s.packedInterpolationLength,c),m=0;if(r(i)){var p=i.length;l=new Array(p);for(var f=0;p>f;f++){var v=i[f];v===Number&&(v=h);var g=v.packedLength;c+=g,d+=t(v.packedInterpolationLength,g),l[f]=v}m=p}this._type=e,this._innerType=s,this._interpolationDegree=1,this._interpolationAlgorithm=u,this._numberOfPoints=0,this._times=[],this._values=[],this._xTable=[],this._yTable=[],this._packedLength=c,this._packedInterpolationLength=d,this._updateTableLength=!0,this._interpolationResult=new Array(d),this._definitionChanged=new o,this._derivativeTypes=i,this._innerDerivativeTypes=l,this._inputOrder=m,this._forwardExtrapolationType=a.NONE,this._forwardExtrapolationDuration=0,this._backwardExtrapolationType=a.NONE,this._backwardExtrapolationDuration=0};return i(f.prototype,{isConstant:{get:function(){return 0===this._values.length}},definitionChanged:{get:function(){return this._definitionChanged}},type:{get:function(){return this._type}},derivativeTypes:{get:function(){return this._derivativeTypes}},interpolationDegree:{get:function(){return this._interpolationDegree}},interpolationAlgorithm:{get:function(){return this._interpolationAlgorithm}},forwardExtrapolationType:{get:function(){return this._forwardExtrapolationType},set:function(e){this._forwardExtrapolationType!==e&&(this._forwardExtrapolationType=e,this._definitionChanged.raiseEvent(this))}},forwardExtrapolationDuration:{get:function(){return this._forwardExtrapolationDuration},set:function(e){this._forwardExtrapolationDuration!==e&&(this._forwardExtrapolationDuration=e,this._definitionChanged.raiseEvent(this))}},backwardExtrapolationType:{get:function(){return this._backwardExtrapolationType},set:function(e){this._backwardExtrapolationType!==e&&(this._backwardExtrapolationType=e,this._definitionChanged.raiseEvent(this))}},backwardExtrapolationDuration:{get:function(){return this._backwardExtrapolationDuration},set:function(e){this._backwardExtrapolationDuration!==e&&(this._backwardExtrapolationDuration=e,this._definitionChanged.raiseEvent(this))}}}),f.prototype.getValue=function(t,i){if(!r(t))throw new n("time is required.");var o=this._times,u=o.length;if(0===u)return void 0;var l,c=this._innerType,h=this._values,d=e(o,t,s.compare);if(0>d){if(d=~d,0===d){var m=o[d];if(l=this._backwardExtrapolationDuration,this._backwardExtrapolationType===a.NONE||0!==l&&s.secondsDifference(m,t)>l)return void 0;if(this._backwardExtrapolationType===a.HOLD)return c.unpack(h,0,i)}if(d>=u){d=u-1;var p=o[d];if(l=this._forwardExtrapolationDuration,this._forwardExtrapolationType===a.NONE||0!==l&&s.secondsDifference(t,p)>l)return void 0;if(this._forwardExtrapolationType===a.HOLD)return d=u-1,c.unpack(h,d*c.packedLength,i)}var f=this._xTable,v=this._yTable,g=this._interpolationAlgorithm,_=this._packedInterpolationLength,y=this._inputOrder;if(this._updateTableLength){this._updateTableLength=!1;var w=Math.min(g.getRequiredDataPoints(this._interpolationDegree,y),u);w!==this._numberOfPoints&&(this._numberOfPoints=w,f.length=w,v.length=w*_)}var C=this._numberOfPoints-1;if(1>C)return void 0;var E=0,S=u-1,b=S-E+1;if(C+1>b);else{var T=d-(C/2|0)-1;E>T&&(T=E);var x=T+C;x>S&&(x=S,T=x-C,E>T&&(T=E)),E=T,S=x}for(var P=S-E+1,A=0;P>A;++A)f[A]=s.secondsDifference(o[E+A],o[S]);if(r(c.convertPackedArrayForInterpolation))c.convertPackedArrayForInterpolation(h,E,S,v);else for(var I=0,D=this._packedLength,M=E*D,R=(S+1)*D;R>M;)v[I]=h[M],M++,I++;var O,N=s.secondsDifference(t,o[S]);if(0!==y&&r(g.interpolate)){var L=Math.floor(_/(y+1));O=g.interpolate(N,f,v,L,y,y,this._interpolationResult)}else O=g.interpolateOrderZero(N,f,v,_,this._interpolationResult);return r(c.unpackInterpolationResult)?c.unpackInterpolationResult(O,h,E,S,i):c.unpack(O,0,i)}return c.unpack(h,d*this._packedLength,i)},f.prototype.setInterpolationOptions=function(e){if(!r(e))throw new n("options is required.");var t=!1,i=e.interpolationAlgorithm,o=e.interpolationDegree;this._interpolationAlgorithm!==i&&(this._interpolationAlgorithm=i,t=!0),this._interpolationDegree!==o&&(this._interpolationDegree=o,t=!0),t&&(this._updateTableLength=!0,this._definitionChanged.raiseEvent(this))},f.prototype.addSample=function(e,t,i){var o=this._innerDerivativeTypes,a=r(o);if(!r(e))throw new n("time is required.");if(!r(t))throw new n("value is required.");if(a&&!r(i))throw new n("derivatives is required.");var s=this._innerType,u=[];if(u.push(e),s.pack(t,u,u.length),a)for(var l=o.length,c=0;l>c;c++)o[c].pack(i[c],u,u.length);p(void 0,this._times,this._values,u,this._packedLength),this._updateTableLength=!0,this._definitionChanged.raiseEvent(this)},f.prototype.addSamples=function(e,t,i){var o=this._innerDerivativeTypes,a=r(o);if(!r(e))throw new n("times is required.");if(!r(t))throw new n("values is required.");if(e.length!==t.length)throw new n("times and values must be the same length.");if(a&&(!r(i)||i.length!==e.length))throw new n("times and derivativeValues must be the same length.");for(var s=this._innerType,u=e.length,l=[],c=0;u>c;c++)if(l.push(e[c]),s.pack(t[c],l,l.length),a)for(var h=i[c],d=o.length,m=0;d>m;m++)o[m].pack(h[m],l,l.length);p(void 0,this._times,this._values,l,this._packedLength),this._updateTableLength=!0,this._definitionChanged.raiseEvent(this)},f.prototype.addSamplesPackedArray=function(e,t){if(!r(e))throw new n("packedSamples is required.");p(t,this._times,this._values,e,this._packedLength),this._updateTableLength=!0,this._definitionChanged.raiseEvent(this)},f.prototype.equals=function(e){if(this===e)return!0;if(!r(e))return!1;if(this._type!==e._type||this._interpolationDegree!==e._interpolationDegree||this._interpolationAlgorithm!==e._interpolationAlgorithm)return!1;var t=this._derivativeTypes,i=r(t),n=e._derivativeTypes,o=r(n);if(i!==o)return!1;var a,u;if(i){if(u=t.length,u!==n.length)return!1;for(a=0;u>a;a++)if(t[a]!==n[a])return!1}var l=this._times,c=e._times;if(u=l.length,u!==c.length)return!1;for(a=0;u>a;a++)if(!s.equals(l[a],c[a]))return!1;var h=this._values,d=e._values;for(a=0;u>a;a++)if(h[a]!==d[a])return!1;return!0},f._mergeNewSamples=p,f}),r("DataSources/SampledPositionProperty",["../Core/Cartesian3","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/ReferenceFrame","./PositionProperty","./Property","./SampledProperty"],function(e,t,r,i,n,o,a,s,u,l){"use strict";var c=function(r,i){i=t(i,0);var n;if(i>0){n=new Array(i);for(var s=0;i>s;s++)n[s]=e}this._numberOfDerivatives=i,this._property=new l(e,n),this._definitionChanged=new o,this._referenceFrame=t(r,a.FIXED),this._property._definitionChanged.addEventListener(function(){this._definitionChanged.raiseEvent(this)},this)};return i(c.prototype,{isConstant:{get:function(){return this._property.isConstant}},definitionChanged:{get:function(){return this._definitionChanged}},referenceFrame:{get:function(){return this._referenceFrame}},interpolationDegree:{get:function(){return this._property.interpolationDegree}},interpolationAlgorithm:{get:function(){return this._property.interpolationAlgorithm}},numberOfDerivatives:{get:function(){return this._numberOfDerivatives}},forwardExtrapolationType:{get:function(){return this._property.forwardExtrapolationType},set:function(e){this._property.forwardExtrapolationType=e}},forwardExtrapolationDuration:{get:function(){return this._property.forwardExtrapolationDuration},set:function(e){this._property.forwardExtrapolationDuration=e}},backwardExtrapolationType:{get:function(){return this._property.backwardExtrapolationType},set:function(e){this._property.backwardExtrapolationType=e}},backwardExtrapolationDuration:{get:function(){return this._property.backwardExtrapolationDuration},set:function(e){this._property.backwardExtrapolationDuration=e}}}),c.prototype.getValue=function(e,t){return this.getValueInReferenceFrame(e,a.FIXED,t)},c.prototype.getValueInReferenceFrame=function(e,t,i){if(!r(e))throw new n("time is required.");if(!r(t))throw new n("referenceFrame is required.");return i=this._property.getValue(e,i),r(i)?s.convertToReferenceFrame(e,i,this._referenceFrame,t,i):void 0},c.prototype.setInterpolationOptions=function(e){this._property.setInterpolationOptions(e)},c.prototype.addSample=function(e,t,i){var o=this._numberOfDerivatives;if(o>0&&(!r(i)||i.length!==o))throw new n("derivatives length must be equal to the number of derivatives.");this._property.addSample(e,t,i)},c.prototype.addSamples=function(e,t,r){this._property.addSamples(e,t,r)},c.prototype.addSamplesPackedArray=function(e,t){this._property.addSamplesPackedArray(e,t)},c.prototype.equals=function(e){return this===e||e instanceof c&&u.equals(this._property,e._property)&&this._referenceFrame===e._referenceFrame},c}),r("DataSources/StripeOrientation",["../Core/freezeObject"],function(e){"use strict";var t={HORIZONTAL:0,VERTICAL:1};return e(t)}),r("DataSources/StripeMaterialProperty",["../Core/Color","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/Event","./createPropertyDescriptor","./Property","./StripeOrientation"],function(e,t,r,i,n,o,a,s){"use strict";var u=s.HORIZONTAL,l=e.WHITE,c=e.BLACK,h=0,d=1,m=function(e){e=t(e,t.EMPTY_OBJECT),this._definitionChanged=new n,this._orientation=void 0,this._orientationSubscription=void 0,this._evenColor=void 0,this._evenColorSubscription=void 0,this._oddColor=void 0,this._oddColorSubscription=void 0,this._offset=void 0,this._offsetSubscription=void 0,this._repeat=void 0,this._repeatSubscription=void 0,this.orientation=e.orientation,this.evenColor=e.evenColor,this.oddColor=e.oddColor,this.offset=e.offset,this.repeat=e.repeat};return i(m.prototype,{isConstant:{get:function(){return a.isConstant(this._orientation)&&a.isConstant(this._evenColor)&&a.isConstant(this._oddColor)&&a.isConstant(this._offset)&&a.isConstant(this._repeat)}},definitionChanged:{get:function(){return this._definitionChanged}},orientation:o("orientation"),evenColor:o("evenColor"),oddColor:o("oddColor"),offset:o("offset"),repeat:o("repeat")}),m.prototype.getType=function(e){return"Stripe"},m.prototype.getValue=function(e,t){return r(t)||(t={}),t.horizontal=a.getValueOrDefault(this._orientation,e,u)===s.HORIZONTAL,t.evenColor=a.getValueOrClonedDefault(this._evenColor,e,l,t.evenColor),t.oddColor=a.getValueOrClonedDefault(this._oddColor,e,c,t.oddColor),t.offset=a.getValueOrDefault(this._offset,e,h),t.repeat=a.getValueOrDefault(this._repeat,e,d),t},m.prototype.equals=function(e){return this===e||e instanceof m&&a.equals(this._orientation,e._orientation)&&a.equals(this._evenColor,e._evenColor)&&a.equals(this._oddColor,e._oddColor)&&a.equals(this._offset,e._offset)&&a.equals(this._repeat,e._repeat)},m}),r("DataSources/TimeIntervalCollectionPositionProperty",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/ReferenceFrame","../Core/TimeIntervalCollection","./PositionProperty","./Property"],function(e,t,r,i,n,o,a,s,u){"use strict";var l=function(t){this._definitionChanged=new n,this._intervals=new a,this._intervals.changedEvent.addEventListener(l.prototype._intervalsChanged,this),this._referenceFrame=e(t,o.FIXED)};return r(l.prototype,{isConstant:{get:function(){return this._intervals.isEmpty}},definitionChanged:{get:function(){return this._definitionChanged}},intervals:{get:function(){return this._intervals}},referenceFrame:{get:function(){return this._referenceFrame}}}),l.prototype.getValue=function(e,t){return this.getValueInReferenceFrame(e,o.FIXED,t)},l.prototype.getValueInReferenceFrame=function(e,r,n){if(!t(e))throw new i("time is required.");if(!t(r))throw new i("referenceFrame is required.");var o=this._intervals.findDataForIntervalContainingDate(e);return t(o)?s.convertToReferenceFrame(e,o,this._referenceFrame,r,n):void 0},l.prototype.equals=function(e){return this===e||e instanceof l&&this._intervals.equals(e._intervals,u.equals)&&this._referenceFrame===e._referenceFrame},l.prototype._intervalsChanged=function(){this._definitionChanged.raiseEvent(this)},l}),r("DataSources/TimeIntervalCollectionProperty",["../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/TimeIntervalCollection","./Property"],function(e,t,r,i,n,o){"use strict";var a=function(){this._definitionChanged=new i,this._intervals=new n,this._intervals.changedEvent.addEventListener(a.prototype._intervalsChanged,this)};return t(a.prototype,{isConstant:{get:function(){return this._intervals.isEmpty}},definitionChanged:{get:function(){return this._definitionChanged}},intervals:{get:function(){return this._intervals}}}),a.prototype.getValue=function(t,i){if(!e(t))throw new r("time is required");var n=this._intervals.findDataForIntervalContainingDate(t);return e(n)&&"function"==typeof n.clone?n.clone(i):n},a.prototype.equals=function(e){return this===e||e instanceof a&&this._intervals.equals(e._intervals,o.equals)},a.prototype._intervalsChanged=function(){this._definitionChanged.raiseEvent(this)},a}),r("DataSources/CzmlDataSource",["../Core/Cartesian2","../Core/Cartesian3","../Core/Cartographic","../Core/ClockRange","../Core/ClockStep","../Core/Color","../Core/createGuid","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Ellipsoid","../Core/Event","../Core/ExtrapolationType","../Core/getFilenameFromUri","../Core/HermitePolynomialApproximation","../Core/isArray","../Core/Iso8601","../Core/JulianDate","../Core/LagrangePolynomialApproximation","../Core/LinearApproximation","../Core/loadJson","../Core/Math","../Core/Quaternion","../Core/Rectangle","../Core/ReferenceFrame","../Core/RuntimeError","../Core/Spherical","../Core/TimeInterval","../Core/TimeIntervalCollection","../Scene/HorizontalOrigin","../Scene/LabelStyle","../Scene/VerticalOrigin","../ThirdParty/Uri","../ThirdParty/when","./BillboardGraphics","./ColorMaterialProperty","./CompositeMaterialProperty","./CompositePositionProperty","./CompositeProperty","./ConstantPositionProperty","./ConstantProperty","./DataSource","./DataSourceClock","./EllipseGraphics","./EllipsoidGraphics","./EntityCollection","./GridMaterialProperty","./ImageMaterialProperty","./LabelGraphics","./ModelGraphics","./PathGraphics","./PointGraphics","./PolygonGraphics","./PolylineGlowMaterialProperty","./PolylineGraphics","./PolylineOutlineMaterialProperty","./PositionPropertyArray","./RectangleGraphics","./ReferenceProperty","./Rotation","./SampledPositionProperty","./SampledProperty","./StripeMaterialProperty","./StripeOrientation","./TimeIntervalCollectionPositionProperty","./TimeIntervalCollectionProperty","./WallGraphics"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f,v,g,_,y,w,C,E,S,b,T,x,P,A,I,D,M,R,O,N,L,F,B,z,V,k,U,q,G,W,H,j,Y,X,Z,K,Q,J,$,ee,te,re,ie,ne,oe,ae,se,ue,le,ce,he,de,me){"use strict";function pe(e,t){return"#"===t[0]&&(t=$e+t),oe.fromString(e,t)}function fe(e){var t=e.rgbaf;if(u(t))return t;var r=e.rgba;if(!u(r))return void 0;if(r.length===o.length)return[o.byteToFloat(r[0]),o.byteToFloat(r[1]),o.byteToFloat(r[2]),o.byteToFloat(r[3])];var i=r.length;t=new Array(i);for(var n=0;i>n;n+=5)t[n]=r[n],t[n+1]=o.byteToFloat(r[n+1]),t[n+2]=o.byteToFloat(r[n+2]),t[n+3]=o.byteToFloat(r[n+3]),t[n+4]=o.byteToFloat(r[n+4]);return t}function ve(e,t){var r=s(e.uri,e);if(u(t)){var i=new O(document.location.href);t=new O(t),r=new O(r).resolve(t.resolve(i)).toString()}return r}function ge(e){var t=e.wsenDegrees;if(u(t)){for(var r=t.length,i=0;r>i;i++)t[i]=E.toRadians(t[i]);return t}return e.wsen}function _e(e){if(u(e.cartesian))return e.cartesian;if(u(e.cartesianVelocity))return e.cartesianVelocity;if(u(e.unitCartesian))return e.unitCartesian;var r,i,n,o=e.unitSpherical;if(u(o)){if(i=o.length,2===i)tt.clock=o[0],tt.cone=o[1],t.fromSpherical(tt,et),n=[et.x,et.y,et.z];else{var a=0;for(n=new Array(i/3*4),r=0;i>r;r+=4)n[r]=o[a++],tt.clock=o[a++],tt.cone=o[a++],t.fromSpherical(tt,et),n[r+1]=et.x,n[r+2]=et.y,n[r+3]=et.z}return n}var s=e.cartographicRadians;if(u(s)){if(3===s.length)rt.longitude=s[0],rt.latitude=s[1],rt.height=s[2],h.WGS84.cartographicToCartesian(rt,et),n=[et.x,et.y,et.z];else for(i=s.length,n=new Array(i),r=0;i>r;r+=4)rt.longitude=s[r+1],rt.latitude=s[r+2],rt.height=s[r+3],h.WGS84.cartographicToCartesian(rt,et),n[r]=s[r],n[r+1]=et.x,n[r+2]=et.y,n[r+3]=et.z;return n}var l=e.cartographicDegrees;if(!u(l))throw new x(JSON.stringify(e)+" is not a valid CZML interval.");if(3===l.length)rt.longitude=E.toRadians(l[0]),rt.latitude=E.toRadians(l[1]),rt.height=l[2],h.WGS84.cartographicToCartesian(rt,et),n=[et.x,et.y,et.z];else for(i=l.length,n=new Array(i),r=0;i>r;r+=4)rt.longitude=E.toRadians(l[r+1]),rt.latitude=E.toRadians(l[r+2]),rt.height=l[r+3],h.WGS84.cartographicToCartesian(rt,et),n[r]=l[r],n[r+1]=et.x,n[r+2]=et.y,n[r+3]=et.z;return n}function ye(e,t){var r=e[t],i=e[t+1],n=e[t+2],o=e[t+3],a=1/Math.sqrt(r*r+i*i+n*n+o*o);e[t]=r*a,e[t+1]=i*a,e[t+2]=n*a,e[t+3]=o*a}function we(e){var t=e.unitQuaternion;if(u(t)){if(4===t.length)return ye(t,0),t;for(var r=1;r<t.length;r+=5)ye(t,r)}return t}function Ce(r,i,n){switch(r){case Boolean:return s(i["boolean"],i);case e:return i.cartesian2;case t:return _e(i);case o:return fe(i);case ce:return ce[s(i.stripeOrientation,i)];case D:return D[s(i.horizontalOrigin,i)];case Image:return ve(i,n);case _:return _.fromIso8601(s(i.date,i));case M:return M[s(i.labelStyle,i)];case ae:return s(i.number,i);case Number:return s(i.number,i);case String:return s(i.string,i);case Array:return i.array;case S:return we(i);case b:return ge(i);case O:return ve(i,n);case R:return R[s(i.verticalOrigin,i)];default:throw new x(r)}}function Ee(e,t){var r=e.interpolationAlgorithm;(u(r)||u(e.interpolationDegree))&&t.setInterpolationOptions({interpolationAlgorithm:nt[r],interpolationDegree:e.interpolationDegree});var i=e.forwardExtrapolationType;u(i)&&(t.forwardExtrapolationType=m[i]);var n=e.forwardExtrapolationDuration;u(n)&&(t.forwardExtrapolationDuration=n);var o=e.backwardExtrapolationType;u(o)&&(t.backwardExtrapolationType=m[o]);var a=e.backwardExtrapolationDuration;u(a)&&(t.backwardExtrapolationDuration=a)}function Se(e,t,r,i,n,o,a){var l,c=i.interval;u(c)?(ot.iso8601=c,l=A.fromIso8601(ot),u(n)&&(l=A.intersect(l,n,it))):u(n)&&(l=n);var h,d,m,p,f=u(i.reference),v=u(l)&&!l.equals(g.MAXIMUM_INTERVAL);f||(m=Ce(e,i,o),h=s(e.packedLength,1),p=s(m.length,1),d=!u(i.array)&&"string"!=typeof m&&p>h);var y="function"==typeof e.unpack&&e!==ae;if(!d&&!v)return void(f?t[r]=pe(a,i.reference):y?t[r]=new U(e.unpack(m,0)):t[r]=new U(m));var w,C=t[r],E=i.epoch;if(u(E)&&(w=_.fromIso8601(E)),d&&!v)return C instanceof ue||(C=new ue(e),t[r]=C),C.addSamplesPackedArray(m,w),void Ee(i,C);var S;if(!d&&v)return l=l.clone(),f?l.data=pe(a,i.reference):y?l.data=e.unpack(m,0):l.data=m,u(C)||(C=f?new V:new de,t[r]=C),void(!f&&C instanceof de?C.intervals.addInterval(l):C instanceof V?(l.data=f?l.data:new U(l.data),C.intervals.addInterval(l)):(S=g.MAXIMUM_INTERVAL.clone(),S.data=C,C=new V,t[r]=C,C.intervals.addInterval(S),l.data=f?l.data:new U(l.data),C.intervals.addInterval(l)));u(C)||(C=new V,t[r]=C),C instanceof V||(S=g.MAXIMUM_INTERVAL.clone(),S.data=C,C=new V,t[r]=C,C.intervals.addInterval(S));var b=C.intervals;S=b.findInterval(l),u(S)&&S.data instanceof ue||(S=l.clone(),S.data=new ue(e),b.addInterval(S)),S.data.addSamplesPackedArray(m,w),Ee(i,S.data)}function be(e,t,r,i,n,o,a){if(u(i))if(v(i))for(var s=0,l=i.length;l>s;s++)Se(e,t,r,i[s],n,o,a);else Se(e,t,r,i,n,o,a)}function Te(e,r,i,n,o,a){var l,c=i.interval;u(c)?(ot.iso8601=c,l=A.fromIso8601(ot),u(n)&&(l=A.intersect(l,n,it))):u(n)&&(l=n);var h,d,m,p=!1,f=u(i.cartesianVelocity)?1:0,v=t.packedLength*(f+1),y=u(i.reference),w=u(l)&&!l.equals(g.MAXIMUM_INTERVAL);if(y||(h=s(T[i.referenceFrame],void 0),d=_e(i),m=s(d.length,1),p=m>v),!p&&!w)return void(y?e[r]=pe(a,i.reference):e[r]=new k(t.unpack(d),h));var C,E=e[r],S=i.epoch;if(u(S)&&(C=_.fromIso8601(S)),p&&!w)return(!(E instanceof se)||u(h)&&E.referenceFrame!==h)&&(E=new se(h,f),e[r]=E),E.addSamplesPackedArray(d,C),void Ee(i,E);var b;if(!p&&w)return l=l.clone(),y?l.data=pe(a,i.reference):l.data=t.unpack(d),u(E)||(E=y?new z(h):new he(h),e[r]=E),void(!y&&E instanceof he&&u(h)&&E.referenceFrame===h?E.intervals.addInterval(l):E instanceof z?(l.data=y?l.data:new k(l.data,h),E.intervals.addInterval(l)):(b=g.MAXIMUM_INTERVAL.clone(),b.data=E,E=new z(E.referenceFrame),e[r]=E,E.intervals.addInterval(b),l.data=y?l.data:new k(l.data,h),E.intervals.addInterval(l)));u(E)?E instanceof z||(b=g.MAXIMUM_INTERVAL.clone(),b.data=E,E=new z(E.referenceFrame),e[r]=E,E.intervals.addInterval(b)):(E=new z(h),e[r]=E);var x=E.intervals;b=x.findInterval(l),u(b)&&b.data instanceof se&&(!u(h)||b.data.referenceFrame===h)||(b=l.clone(),b.data=new se(h,f),x.addInterval(b)),b.data.addSamplesPackedArray(d,C),Ee(i,b.data)}function xe(e,t,r,i,n,o){if(u(r))if(v(r))for(var a=0,s=r.length;s>a;a++)Te(e,t,r[a],i,n,o);else Te(e,t,r,i,n,o)}function Pe(t,r,i,n,a,s){var l,c=i.interval;u(c)?(ot.iso8601=c,l=A.fromIso8601(ot),u(n)&&(l=A.intersect(l,n,it))):u(n)&&(l=n);var h,d,m=t[r];if(u(l)){m instanceof B||(m=new B,t[r]=m);var p=m.intervals;d=p.findInterval({start:l.start,stop:l.stop}),u(d)?h=d.data:(d=l.clone(),p.addInterval(d))}else h=m;var f;u(i.solidColor)?(h instanceof F||(h=new F),f=i.solidColor,be(o,h,"color",f.color,void 0,void 0,s)):u(i.grid)?(h instanceof Y||(h=new Y),f=i.grid,be(o,h,"color",f.color,void 0,a,s),be(Number,h,"cellAlpha",f.cellAlpha,void 0,a,s),be(e,h,"lineThickness",f.lineThickness,void 0,a,s),be(e,h,"lineOffset",f.lineOffset,void 0,a,s),be(e,h,"lineCount",f.lineCount,void 0,a,s)):u(i.image)?(h instanceof X||(h=new X),f=i.image,be(Image,h,"image",f.image,void 0,a,s),be(e,h,"repeat",f.repeat,void 0,a,s)):u(i.stripe)?(h instanceof le||(h=new le),f=i.stripe,be(ce,h,"orientation",f.orientation,void 0,a,s),be(o,h,"evenColor",f.evenColor,void 0,a,s),be(o,h,"oddColor",f.oddColor,void 0,a,s),be(Number,h,"offset",f.offset,void 0,a,s),be(Number,h,"repeat",f.repeat,void 0,a,s)):u(i.polylineOutline)?(h instanceof re||(h=new re),f=i.polylineOutline,be(o,h,"color",f.color,void 0,a,s),be(o,h,"outlineColor",f.outlineColor,void 0,a,s),be(Number,h,"outlineWidth",f.outlineWidth,void 0,a,s)):u(i.polylineGlow)&&(h instanceof ee||(h=new ee),f=i.polylineGlow,be(o,h,"color",f.color,void 0,a,s),be(Number,h,"glowPower",f.glowPower,void 0,a,s)),u(d)?d.data=h:t[r]=h}function Ae(e,t,r,i,n,o){if(u(r))if(v(r))for(var a=0,s=r.length;s>a;a++)Pe(e,t,r[a],i,n,o);else Pe(e,t,r,i,n,o)}function Ie(e,t,r,i){e.name=s(t.name,e.name)}function De(e,t,r,i){var n=t.description;u(n)&&be(String,e,"description",n,void 0,i,r)}function Me(e,t,r,i){var n=t.position;u(n)&&xe(e,"position",n,void 0,i,r)}function Re(e,r,i,n){var o=r.viewFrom;u(o)&&be(t,e,"viewFrom",o,void 0,n,i)}function Oe(e,t,r,i){var n=t.orientation;u(n)&&be(S,e,"orientation",n,void 0,i,r)}function Ne(e,r,i,n){var o,a,s=i.references;if(u(s)){var l=[];for(o=0,a=s.length;a>o;o++)l.push(pe(n,s[o]));var c=i.interval;if(u(c)){if(c=A.fromIso8601(c),!(e[r]instanceof z)){c.data=new ie(l);var d=new z;d.intervals.addInterval(c),e[r]=d}}else e[r]=new ie(l)}else{var m=[],p=i.cartesian;if(u(p)){for(o=0,a=p.length;a>o;o+=3)m.push(new t(p[o],p[o+1],p[o+2]));i.array=m}else if(p=i.cartographicRadians,u(p)){for(o=0,a=p.length;a>o;o+=3)rt.longitude=p[o],rt.latitude=p[o+1],rt.height=p[o+2],m.push(h.WGS84.cartographicToCartesian(rt));i.array=m}else if(p=i.cartographicDegrees,u(p)){for(o=0,a=p.length;a>o;o+=3)m.push(t.fromDegrees(p[o],p[o+1],p[o+2]));i.array=m}u(i.array)&&be(Array,e,r,i,void 0,void 0,n)}}function Le(e,t,r,i){if(u(r))if(v(r))for(var n=r.length,o=0;n>o;o++)Ne(e,t,r[o],i);else Ne(e,t,r,i)}function Fe(e,t,r,i){var n,o=t.availability;if(u(o)){var a;if(v(o))for(var s=o.length,l=0;s>l;l++)u(a)||(a=new I),ot.iso8601=o[l],n=A.fromIso8601(ot),a.addInterval(n);else ot.iso8601=o,n=A.fromIso8601(ot),a=new I,a.addInterval(n);e.availability=a}}function Be(r,i,n,a){var s=i.billboard;if(u(s)){var l,c=s.interval;u(c)&&(ot.iso8601=c,l=A.fromIso8601(ot));var h=r.billboard;u(h)||(r.billboard=h=new L),be(o,h,"color",s.color,l,a,n),be(t,h,"eyeOffset",s.eyeOffset,l,a,n),be(D,h,"horizontalOrigin",s.horizontalOrigin,l,a,n),be(Image,h,"image",s.image,l,a,n),be(e,h,"pixelOffset",s.pixelOffset,l,a,n),be(Number,h,"scale",s.scale,l,a,n),be(ae,h,"rotation",s.rotation,l,a,n),be(t,h,"alignedAxis",s.alignedAxis,l,a,n),be(Boolean,h,"show",s.show,l,a,n),be(R,h,"verticalOrigin",s.verticalOrigin,l,a,n),be(Boolean,h,"sizeInMeters",s.sizeInMeters,l,a,n)}}function ze(e,t){var r=e.version;if(u(r)&&"string"==typeof r){var i=r.split(".");if(2===i.length){if("1"!==i[0])throw new x("Cesium only supports CZML version 1.");t._version=r}}if(!u(t._version))throw new x("CZML version information invalid.  It is expected to be a property on the document object in the <Major>.<Minor> version format.");var n=t._documentPacket;u(e.name)&&(n.name=e.name);var o=e.clock;if(u(o)){var a=n.clock;u(a)?(a.interval=s(o.interval,a.interval),a.currentTime=s(o.currentTime,a.currentTime),a.range=s(o.range,a.range),a.step=s(o.step,a.step),a.multiplier=s(o.multiplier,a.multiplier)):n.clock={interval:o.interval,currentTime:o.currentTime,range:o.range,step:o.step,multiplier:o.multiplier}}}function Ve(e,t,r,i){var n=t.ellipse;if(u(n)){var a,s=n.interval;u(s)&&(ot.iso8601=s,a=A.fromIso8601(ot));var l=e.ellipse;u(l)||(e.ellipse=l=new W),be(Boolean,l,"show",n.show,a,i,r),be(ae,l,"rotation",n.rotation,a,i,r),be(Number,l,"semiMajorAxis",n.semiMajorAxis,a,i,r),be(Number,l,"semiMinorAxis",n.semiMinorAxis,a,i,r),be(Number,l,"height",n.height,a,i,r),be(Number,l,"extrudedHeight",n.extrudedHeight,a,i,r),be(Number,l,"granularity",n.granularity,a,i,r),be(ae,l,"stRotation",n.stRotation,a,i,r),Ae(l,"material",n.material,a,i,r),be(Boolean,l,"fill",n.fill,a,i,r),be(Boolean,l,"outline",n.outline,a,i,r),be(o,l,"outlineColor",n.outlineColor,a,i,r),be(Number,l,"outlineWidth",n.outlineWidth,a,i,r),be(Number,l,"numberOfVerticalLines",n.numberOfVerticalLines,a,i,r)}}function ke(e,r,i,n){var a=r.ellipsoid;if(u(a)){var s,l=a.interval;u(l)&&(ot.iso8601=l,s=A.fromIso8601(ot));var c=e.ellipsoid;u(c)||(e.ellipsoid=c=new H),be(Boolean,c,"show",a.show,s,n,i),be(t,c,"radii",a.radii,s,n,i),Ae(c,"material",a.material,s,n,i),be(Boolean,c,"fill",a.fill,s,n,i),be(Boolean,c,"outline",a.outline,s,n,i),be(o,c,"outlineColor",a.outlineColor,s,n,i),be(Number,c,"outlineWidth",a.outlineWidth,s,n,i)}}function Ue(r,i,n,a){var s=i.label;if(u(s)){var l,c=s.interval;u(c)&&(ot.iso8601=c,l=A.fromIso8601(ot));var h=r.label;u(h)||(r.label=h=new Z),be(o,h,"fillColor",s.fillColor,l,a,n),be(o,h,"outlineColor",s.outlineColor,l,a,n),be(Number,h,"outlineWidth",s.outlineWidth,l,a,n),be(t,h,"eyeOffset",s.eyeOffset,l,a,n),be(D,h,"horizontalOrigin",s.horizontalOrigin,l,a,n),be(String,h,"text",s.text,l,a,n),be(e,h,"pixelOffset",s.pixelOffset,l,a,n),be(Number,h,"scale",s.scale,l,a,n),be(Boolean,h,"show",s.show,l,a,n),be(R,h,"verticalOrigin",s.verticalOrigin,l,a,n),be(String,h,"font",s.font,l,a,n),be(M,h,"style",s.style,l,a,n)}}function qe(e,t,r,i){var n=t.model;if(u(n)){var o,a=n.interval;u(a)&&(ot.iso8601=a,o=A.fromIso8601(ot));var s=e.model;u(s)||(e.model=s=new K),be(Boolean,s,"show",n.show,o,i,r),be(Number,s,"scale",n.scale,o,i,r),be(Number,s,"minimumPixelSize",n.minimumPixelSize,o,i,r),be(O,s,"uri",n.gltf,o,i,r)}}function Ge(e,t,r,i){var n=t.path;if(u(n)){var o,a=n.interval;u(a)&&(ot.iso8601=a,o=A.fromIso8601(ot));var s=e.path;u(s)||(e.path=s=new Q),be(Boolean,s,"show",n.show,o,i,r),be(Number,s,"width",n.width,o,i,r),be(Number,s,"resolution",n.resolution,o,i,r),be(Number,s,"leadTime",n.leadTime,o,i,r),be(Number,s,"trailTime",n.trailTime,o,i,r),Ae(s,"material",n.material,o,i,r)}}function We(e,t,r,i){var n=t.point;if(u(n)){var a,s=n.interval;u(s)&&(ot.iso8601=s,a=A.fromIso8601(ot));var l=e.point;u(l)||(e.point=l=new J),be(o,l,"color",n.color,a,i,r),be(Number,l,"pixelSize",n.pixelSize,a,i,r),be(o,l,"outlineColor",n.outlineColor,a,i,r),be(Number,l,"outlineWidth",n.outlineWidth,a,i,r),be(Boolean,l,"show",n.show,a,i,r)}}function He(e,t,r,i){var n=t.polygon;if(u(n)){var a,s=n.interval;u(s)&&(ot.iso8601=s,a=A.fromIso8601(ot));var l=e.polygon;u(l)||(e.polygon=l=new $),be(Boolean,l,"show",n.show,a,i,r),Ae(l,"material",n.material,a,i,r),be(Number,l,"height",n.height,a,i,r),be(Number,l,"extrudedHeight",n.extrudedHeight,a,i,r),be(Number,l,"granularity",n.granularity,a,i,r),be(ae,l,"stRotation",n.stRotation,a,i,r),be(Boolean,l,"fill",n.fill,a,i,r),be(Boolean,l,"outline",n.outline,a,i,r),be(o,l,"outlineColor",n.outlineColor,a,i,r),be(Number,l,"outlineWidth",n.outlineWidth,a,i,r),be(Boolean,l,"perPositionHeight",n.perPositionHeight,a,i,r),Le(l,"hierarchy",n.positions,r)}}function je(e,t,r,i){var n=t.rectangle;if(u(n)){var a,s=n.interval;u(s)&&(ot.iso8601=s,a=A.fromIso8601(ot));var l=e.rectangle;u(l)||(e.rectangle=l=new ne),be(Boolean,l,"show",n.show,a,i,r),
be(b,l,"coordinates",n.coordinates,a,i,r),Ae(l,"material",n.material,a,i,r),be(Number,l,"height",n.height,a,i,r),be(Number,l,"extrudedHeight",n.extrudedHeight,a,i,r),be(Number,l,"granularity",n.granularity,a,i,r),be(ae,l,"rotation",n.rotation,a,i,r),be(ae,l,"stRotation",n.stRotation,a,i,r),be(Boolean,l,"fill",n.fill,a,i,r),be(Boolean,l,"outline",n.outline,a,i,r),be(o,l,"outlineColor",n.outlineColor,a,i,r),be(Number,l,"outlineWidth",n.outlineWidth,a,i,r),be(Boolean,l,"closeBottom",n.closeBottom,a,i,r),be(Boolean,l,"closeTop",n.closeTop,a,i,r)}}function Ye(e,t,r,i){var n=t.wall;if(u(n)){var a,s=n.interval;u(s)&&(ot.iso8601=s,a=A.fromIso8601(ot));var l=e.wall;u(l)||(e.wall=l=new me),be(Boolean,l,"show",n.show,a,i,r),Ae(l,"material",n.material,a,i,r),be(Array,l,"minimumHeights",n.minimumHeights,a,i,r),be(Array,l,"maximumHeights",n.maximumHeights,a,i,r),be(Number,l,"granularity",n.granularity,a,i,r),be(Boolean,l,"fill",n.fill,a,i,r),be(Boolean,l,"outline",n.outline,a,i,r),be(o,l,"outlineColor",n.outlineColor,a,i,r),be(Number,l,"outlineWidth",n.outlineWidth,a,i,r),Le(l,"positions",n.positions,r)}}function Xe(e,t,r,i){var n=t.polyline;if(u(n)){var o,a=n.interval;u(a)&&(ot.iso8601=a,o=A.fromIso8601(ot));var s=e.polyline;u(s)||(e.polyline=s=new te),be(Boolean,s,"show",n.show,o,i,r),be(Number,s,"width",n.width,o,i,r),Ae(s,"material",n.material,o,i,r),be(Boolean,s,"followSurface",n.followSurface,o,i,r),be(Number,s,"granularity",n.granularity,o,i,r),Le(s,"positions",n.positions,r)}}function Ze(e,t,r,i,n){var o=e.id;if(u(o)||(o=a()),$e=o,!u(n._version)&&"document"!==o)throw new x("The first CZML packet is required to be the document object.");if(e["delete"]===!0)t.removeById(o);else if("document"===o)ze(e,n);else{var s=t.getOrCreateEntity(o),l=e.parent;u(l)&&(s.parent=t.getOrCreateEntity(l));for(var c=r.length-1;c>-1;c--)r[c](s,e,t,i)}$e=void 0}function Ke(e){var t,r=e._documentPacket.clock;if(!u(r)){if(!u(e._clock)){var o=e._entityCollection.computeAvailability();if(!o.start.equals(g.MINIMUM_VALUE)){var a=o.start,l=o.stop,c=_.secondsDifference(l,a),h=Math.round(c/120);return t=new G,t.startTime=_.clone(a),t.stopTime=_.clone(l),t.clockRange=i.LOOP_STOP,t.multiplier=h,t.currentTime=_.clone(a),t.clockStep=n.SYSTEM_CLOCK_MULTIPLIER,e._clock=t,!0}}return!1}if(u(e._clock)?t=e._clock.clone():(t=new G,t.startTime=g.MINIMUM_VALUE.clone(),t.stopTime=g.MAXIMUM_VALUE.clone(),t.currentTime=g.MINIMUM_VALUE.clone(),t.clockRange=i.LOOP_STOP,t.clockStep=n.SYSTEM_CLOCK_MULTIPLIER,t.multiplier=1),u(r.interval)){ot.iso8601=r.interval;var d=A.fromIso8601(ot);t.startTime=d.start,t.stopTime=d.stop}return u(r.currentTime)&&(t.currentTime=_.fromIso8601(r.currentTime)),u(r.range)&&(t.clockRange=s(i[r.range],i.LOOP_STOP)),u(r.step)&&(t.clockStep=s(n[r.step],n.SYSTEM_CLOCK_MULTIPLIER)),u(r.multiplier)&&(t.multiplier=r.multiplier),t.equals(e._clock)?!1:(e._clock=t.clone(e._clock),!0)}function Qe(e,t,r,i){if(!u(t))throw new c("czml is required.");r=s(r,s.EMPTY_OBJECT);var n=t,o=r.sourceUri;return"string"==typeof t&&(n=C(t),o=s(o,t)),q.setLoading(e,!0),N(n,function(t){return Je(e,t,o,i)}).otherwise(function(t){return q.setLoading(e,!1),e._error.raiseEvent(e,t),window.console.log(t),N.reject(t)})}function Je(e,t,r,i){q.setLoading(e,!0);var n=e._entityCollection;i&&(e._version=void 0,e._documentPacket=new at,n.removeAll()),st._processCzml(t,n,r,void 0,e);var o=Ke(e),a=e._documentPacket;return u(a.name)&&e._name!==a.name?(e._name=a.name,o=!0):!u(e._name)&&u(r)&&(e._name=p(r),o=!0),q.setLoading(e,!1),o&&e._changed.raiseEvent(e),e}var $e,et=new t,tt=new P,rt=new r,it=new A,nt={HERMITE:f,LAGRANGE:y,LINEAR:w},ot={iso8601:void 0},at=function(){this.name=void 0,this.clock=void 0},st=function(e){this._name=e,this._changed=new d,this._error=new d,this._isLoading=!1,this._loading=new d,this._clock=void 0,this._documentPacket=new at,this._version=void 0,this._entityCollection=new j};return st.load=function(e,t){return(new st).load(e,t)},l(st.prototype,{name:{get:function(){return this._name}},clock:{get:function(){return this._clock}},entities:{get:function(){return this._entityCollection}},isLoading:{get:function(){return this._isLoading}},changedEvent:{get:function(){return this._changed}},errorEvent:{get:function(){return this._error}},loadingEvent:{get:function(){return this._loading}}}),st.updaters=[Be,Ve,ke,Ue,qe,Ie,De,Ge,We,He,Xe,je,Me,Re,Ye,Oe,Fe],st.prototype.process=function(e,t){return Qe(this,e,t,!1)},st.prototype.load=function(e,t){return Qe(this,e,t,!0)},st.processPacketData=be,st.processPositionPacketData=xe,st.processMaterialPacketData=Ae,st._processCzml=function(e,t,r,i,n){if(i=u(i)?i:st.updaters,v(e))for(var o=0,a=e.length;a>o;o++)Ze(e[o],t,i,r,n);else Ze(e,t,i,r,n)},st}),r("DataSources/DataSourceCollection",["../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Event","../ThirdParty/when"],function(e,t,r,i,n,o,a){"use strict";var s=function(){this._dataSources=[],this._dataSourceAdded=new o,this._dataSourceRemoved=new o};return r(s.prototype,{length:{get:function(){return this._dataSources.length}},dataSourceAdded:{get:function(){return this._dataSourceAdded}},dataSourceRemoved:{get:function(){return this._dataSourceRemoved}}}),s.prototype.add=function(e){if(!t(e))throw new n("dataSource is required.");var r=this,i=this._dataSources;return a(e,function(e){return i===r._dataSources&&(r._dataSources.push(e),r._dataSourceAdded.raiseEvent(r,e)),e})},s.prototype.remove=function(t,r){r=e(r,!1);var i=this._dataSources.indexOf(t);return-1!==i?(this._dataSources.splice(i,1),this._dataSourceRemoved.raiseEvent(this,t),r&&"function"==typeof t.destroy&&t.destroy(),!0):!1},s.prototype.removeAll=function(t){t=e(t,!1);for(var r=this._dataSources,i=0,n=r.length;n>i;++i){var o=r[i];this._dataSourceRemoved.raiseEvent(this,o),t&&"function"==typeof o.destroy&&o.destroy()}this._dataSources=[]},s.prototype.contains=function(e){return-1!==this.indexOf(e)},s.prototype.indexOf=function(e){return this._dataSources.indexOf(e)},s.prototype.get=function(e){if(!t(e))throw new n("index is required.");return this._dataSources[e]},s.prototype.isDestroyed=function(){return!1},s.prototype.destroy=function(){return this.removeAll(!0),i(this)},s}),r("DataSources/EllipseGeometryUpdater",["../Core/Color","../Core/ColorGeometryInstanceAttribute","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/EllipseGeometry","../Core/EllipseOutlineGeometry","../Core/Event","../Core/GeometryInstance","../Core/Iso8601","../Core/ShowGeometryInstanceAttribute","../Scene/MaterialAppearance","../Scene/PerInstanceColorAppearance","../Scene/Primitive","./ColorMaterialProperty","./ConstantProperty","./dynamicGeometryGetBoundingSphere","./MaterialProperty","./Property"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f,v,g,_,y,w){"use strict";var C=new v(e.WHITE),E=new g(!0),S=new g(!0),b=new g(!1),T=new g(e.BLACK),x=new e,P=function(e){this.id=e,this.vertexFormat=void 0,this.center=void 0,this.semiMajorAxis=void 0,this.semiMinorAxis=void 0,this.rotation=void 0,this.height=void 0,this.extrudedHeight=void 0,this.granularity=void 0,this.stRotation=void 0,this.numberOfVerticalLines=void 0},A=function(e,t){if(!i(e))throw new a("entity is required");if(!i(t))throw new a("scene is required");this._entity=e,this._scene=t,this._entitySubscription=e.definitionChanged.addEventListener(A.prototype._onEntityPropertyChanged,this),this._fillEnabled=!1,this._isClosed=!1,this._dynamic=!1,this._outlineEnabled=!1,this._geometryChanged=new l,this._showProperty=void 0,this._materialProperty=void 0,this._hasConstantOutline=!0,this._showOutlineProperty=void 0,this._outlineColorProperty=void 0,this._outlineWidth=1,this._options=new P(e),this._onEntityPropertyChanged(e,"ellipse",e.ellipse,void 0)};n(A,{perInstanceColorAppearanceType:{value:p},materialAppearanceType:{value:m}}),n(A.prototype,{entity:{get:function(){return this._entity}},fillEnabled:{get:function(){return this._fillEnabled}},hasConstantFill:{get:function(){return!this._fillEnabled||!i(this._entity.availability)&&w.isConstant(this._showProperty)&&w.isConstant(this._fillProperty)}},fillMaterialProperty:{get:function(){return this._materialProperty}},outlineEnabled:{get:function(){return this._outlineEnabled}},hasConstantOutline:{get:function(){return!this._outlineEnabled||!i(this._entity.availability)&&w.isConstant(this._showProperty)&&w.isConstant(this._showOutlineProperty)}},outlineColorProperty:{get:function(){return this._outlineColorProperty}},outlineWidth:{get:function(){return this._outlineWidth}},isDynamic:{get:function(){return this._dynamic}},isClosed:{get:function(){return this._isClosed}},geometryChanged:{get:function(){return this._geometryChanged}}}),A.prototype.isOutlineVisible=function(e){var t=this._entity;return this._outlineEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)},A.prototype.isFilled=function(e){var t=this._entity;return this._fillEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._fillProperty.getValue(e)},A.prototype.createFillGeometryInstance=function(r){if(!i(r))throw new a("time is required.");if(!this._fillEnabled)throw new a("This instance does not represent a filled geometry.");var n,o,u=this._entity,l=u.isAvailable(r),h=new d(l&&u.isShowing&&this._showProperty.getValue(r)&&this._fillProperty.getValue(r));if(this._materialProperty instanceof v){var m=e.WHITE;i(this._materialProperty.color)&&(this._materialProperty.color.isConstant||l)&&(m=this._materialProperty.color.getValue(r)),o=t.fromColor(m),n={show:h,color:o}}else n={show:h};return new c({id:u,geometry:new s(this._options),attributes:n})},A.prototype.createOutlineGeometryInstance=function(r){if(!i(r))throw new a("time is required.");if(!this._outlineEnabled)throw new a("This instance does not represent an outlined geometry.");var n=this._entity,o=n.isAvailable(r),s=w.getValueOrDefault(this._outlineColorProperty,r,e.BLACK);return new c({id:n,geometry:new u(this._options),attributes:{show:new d(o&&n.isShowing&&this._showProperty.getValue(r)&&this._showOutlineProperty.getValue(r)),color:t.fromColor(s)}})},A.prototype.isDestroyed=function(){return!1},A.prototype.destroy=function(){this._entitySubscription(),o(this)},A.prototype._onEntityPropertyChanged=function(e,t,n,o){if("availability"===t||"position"===t||"ellipse"===t){var a=this._entity.ellipse;if(!i(a))return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var s=a.fill,u=i(s)&&s.isConstant?s.getValue(h.MINIMUM_VALUE):!0,l=a.outline,c=i(l);if(c&&l.isConstant&&(c=l.getValue(h.MINIMUM_VALUE)),!u&&!c)return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var d=this._entity.position,f=a.semiMajorAxis,g=a.semiMinorAxis,_=a.show;if(i(_)&&_.isConstant&&!_.getValue(h.MINIMUM_VALUE)||!i(d)||!i(f)||!i(g))return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var y=r(a.material,C),x=y instanceof v;this._materialProperty=y,this._fillProperty=r(s,S),this._showProperty=r(_,E),this._showOutlineProperty=r(a.outline,b),this._outlineColorProperty=c?r(a.outlineColor,T):void 0;var P=a.rotation,A=a.height,I=a.extrudedHeight,D=a.granularity,M=a.stRotation,R=a.outlineWidth,O=a.numberOfVerticalLines;if(this._isClosed=i(I),this._fillEnabled=u,this._outlineEnabled=c,d.isConstant&&f.isConstant&&g.isConstant&&w.isConstant(P)&&w.isConstant(A)&&w.isConstant(I)&&w.isConstant(D)&&w.isConstant(M)&&w.isConstant(R)&&w.isConstant(O)){var N=this._options;N.vertexFormat=x?p.VERTEX_FORMAT:m.MaterialSupport.TEXTURED.vertexFormat,N.center=d.getValue(h.MINIMUM_VALUE,N.center),N.semiMajorAxis=f.getValue(h.MINIMUM_VALUE,N.semiMajorAxis),N.semiMinorAxis=g.getValue(h.MINIMUM_VALUE,N.semiMinorAxis),N.rotation=i(P)?P.getValue(h.MINIMUM_VALUE):void 0,N.height=i(A)?A.getValue(h.MINIMUM_VALUE):void 0,N.extrudedHeight=i(I)?I.getValue(h.MINIMUM_VALUE):void 0,N.granularity=i(D)?D.getValue(h.MINIMUM_VALUE):void 0,N.stRotation=i(M)?M.getValue(h.MINIMUM_VALUE):void 0,N.numberOfVerticalLines=i(O)?O.getValue(h.MINIMUM_VALUE):void 0,this._outlineWidth=i(R)?R.getValue(h.MINIMUM_VALUE):1,this._dynamic=!1,this._geometryChanged.raiseEvent(this)}else this._dynamic||(this._dynamic=!0,this._geometryChanged.raiseEvent(this))}},A.prototype.createDynamicUpdater=function(e){if(!this._dynamic)throw new a("This instance does not represent dynamic geometry.");if(!i(e))throw new a("primitives is required.");return new I(e,this)};var I=function(e,t){this._primitives=e,this._primitive=void 0,this._outlinePrimitive=void 0,this._geometryUpdater=t,this._options=new P(t._entity)};return I.prototype.update=function(r){if(!i(r))throw new a("time is required.");var n=this._primitives;n.removeAndDestroy(this._primitive),n.removeAndDestroy(this._outlinePrimitive),this._primitive=void 0,this._outlinePrimitive=void 0;var o=this._geometryUpdater,l=o._entity,h=l.ellipse;if(l.isShowing&&l.isAvailable(r)&&w.getValueOrDefault(h.show,r,!0)){var d=this._options,v=w.getValueOrUndefined(l.position,r,d.center),g=w.getValueOrUndefined(h.semiMajorAxis,r),_=w.getValueOrUndefined(h.semiMinorAxis,r);if(i(v)&&i(g)&&i(_)){if(d.center=v,d.semiMajorAxis=g,d.semiMinorAxis=_,d.rotation=w.getValueOrUndefined(h.rotation,r),d.height=w.getValueOrUndefined(h.height,r),d.extrudedHeight=w.getValueOrUndefined(h.extrudedHeight,r),d.granularity=w.getValueOrUndefined(h.granularity,r),d.stRotation=w.getValueOrUndefined(h.stRotation,r),d.numberOfVerticalLines=w.getValueOrUndefined(h.numberOfVerticalLines,r),w.getValueOrDefault(h.fill,r,!0)){var C=y.getValue(r,o.fillMaterialProperty,this._material);this._material=C;var E=new m({material:C,translucent:C.isTranslucent(),closed:i(d.extrudedHeight)});d.vertexFormat=E.vertexFormat,this._primitive=n.add(new f({geometryInstances:new c({id:l,geometry:new s(d)}),appearance:E,asynchronous:!1}))}if(w.getValueOrDefault(h.outline,r,!1)){d.vertexFormat=p.VERTEX_FORMAT;var S=w.getValueOrClonedDefault(h.outlineColor,r,e.BLACK,x),b=w.getValueOrDefault(h.outlineWidth,r,1),T=1!==S.alpha;this._outlinePrimitive=n.add(new f({geometryInstances:new c({id:l,geometry:new u(d),attributes:{color:t.fromColor(S)}}),appearance:new p({flat:!0,translucent:T,renderState:{lineWidth:o._scene.clampLineWidth(b)}}),asynchronous:!1}))}}}},I.prototype.getBoundingSphere=function(e,t){return _(e,this._primitive,this._outlinePrimitive,t)},I.prototype.isDestroyed=function(){return!1},I.prototype.destroy=function(){var e=this._primitives;e.removeAndDestroy(this._primitive),e.removeAndDestroy(this._outlinePrimitive),o(this)},A}),r("DataSources/EllipsoidGeometryUpdater",["../Core/Cartesian3","../Core/Color","../Core/ColorGeometryInstanceAttribute","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/EllipsoidGeometry","../Core/EllipsoidOutlineGeometry","../Core/Event","../Core/GeometryInstance","../Core/Iso8601","../Core/Matrix4","../Core/ShowGeometryInstanceAttribute","../Scene/MaterialAppearance","../Scene/PerInstanceColorAppearance","../Scene/Primitive","../Scene/SceneMode","./ColorMaterialProperty","./ConstantProperty","./dynamicGeometryGetBoundingSphere","./MaterialProperty","./Property"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f,v,g,_,y,w,C,E,S){"use strict";var b=new y(t.WHITE),T=new w(!0),x=new w(!0),P=new w(!1),A=new w(t.BLACK),I=new e,D=new t,M=new e(1,1,1),R=function(e){this.id=e,this.vertexFormat=void 0,this.radii=void 0,this.stackPartitions=void 0,this.slicePartitions=void 0,this.subdivisions=void 0},O=function(e,t){if(!n(e))throw new s("entity is required");if(!n(t))throw new s("scene is required");this._scene=t,this._entity=e,this._entitySubscription=e.definitionChanged.addEventListener(O.prototype._onEntityPropertyChanged,this),this._fillEnabled=!1,this._dynamic=!1,this._outlineEnabled=!1,this._geometryChanged=new c,this._showProperty=void 0,this._materialProperty=void 0,this._hasConstantOutline=!0,this._showOutlineProperty=void 0,this._outlineColorProperty=void 0,this._outlineWidth=1,this._options=new R(e),this._onEntityPropertyChanged(e,"ellipsoid",e.ellipsoid,void 0)};o(O,{perInstanceColorAppearanceType:{value:v},materialAppearanceType:{value:f}}),o(O.prototype,{entity:{get:function(){return this._entity}},fillEnabled:{get:function(){return this._fillEnabled}},hasConstantFill:{get:function(){return!this._fillEnabled||!n(this._entity.availability)&&S.isConstant(this._showProperty)&&S.isConstant(this._fillProperty)}},fillMaterialProperty:{get:function(){return this._materialProperty}},outlineEnabled:{get:function(){return this._outlineEnabled}},hasConstantOutline:{get:function(){return!this._outlineEnabled||!n(this._entity.availability)&&S.isConstant(this._showProperty)&&S.isConstant(this._showOutlineProperty)}},outlineColorProperty:{get:function(){return this._outlineColorProperty}},outlineWidth:{get:function(){return this._outlineWidth}},isDynamic:{get:function(){return this._dynamic}},isClosed:{value:!0},geometryChanged:{get:function(){return this._geometryChanged}}}),O.prototype.isOutlineVisible=function(e){var t=this._entity;return this._outlineEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)},O.prototype.isFilled=function(e){var t=this._entity;return this._fillEnabled&&t.isAvailable(e)&&this._showProperty.getValue(e)&&this._fillProperty.getValue(e)},O.prototype.createFillGeometryInstance=function(e){if(!n(e))throw new s("time is required.");if(!this._fillEnabled)throw new s("This instance does not represent a filled geometry.");var i,o,a=this._entity,l=a.isAvailable(e),c=new p(l&&a.isShowing&&this._showProperty.getValue(e)&&this._fillProperty.getValue(e));if(this._materialProperty instanceof y){var m=t.WHITE;n(this._materialProperty.color)&&(this._materialProperty.color.isConstant||l)&&(m=this._materialProperty.color.getValue(e)),o=r.fromColor(m),i={show:c,color:o}}else i={show:c};return new h({id:a,geometry:new u(this._options),modelMatrix:a._getModelMatrix(d.MINIMUM_VALUE),attributes:i})},O.prototype.createOutlineGeometryInstance=function(e){if(!n(e))throw new s("time is required.");if(!this._outlineEnabled)throw new s("This instance does not represent an outlined geometry.");var i=this._entity,o=i.isAvailable(e),a=S.getValueOrDefault(this._outlineColorProperty,e,t.BLACK);return new h({id:i,geometry:new l(this._options),modelMatrix:i._getModelMatrix(d.MINIMUM_VALUE),attributes:{show:new p(o&&i.isShowing&&this._showProperty.getValue(e)&&this._showOutlineProperty.getValue(e)),color:r.fromColor(a)}})},O.prototype.isDestroyed=function(){return!1},O.prototype.destroy=function(){this._entitySubscription(),a(this)},O.prototype._onEntityPropertyChanged=function(e,t,r,o){if("availability"===t||"position"===t||"orientation"===t||"ellipsoid"===t){var a=e.ellipsoid;if(!n(a))return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var s=a.fill,u=n(s)&&s.isConstant?s.getValue(d.MINIMUM_VALUE):!0,l=a.outline,c=n(l);if(c&&l.isConstant&&(c=l.getValue(d.MINIMUM_VALUE)),!u&&!c)return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var h=e.position,m=a.radii,p=a.show;if(n(p)&&p.isConstant&&!p.getValue(d.MINIMUM_VALUE)||!n(h)||!n(m))return void((this._fillEnabled||this._outlineEnabled)&&(this._fillEnabled=!1,this._outlineEnabled=!1,this._geometryChanged.raiseEvent(this)));var g=i(a.material,b),_=g instanceof y;this._materialProperty=g,this._fillProperty=i(s,x),this._showProperty=i(p,T),this._showOutlineProperty=i(a.outline,P),this._outlineColorProperty=c?i(a.outlineColor,A):void 0,this._fillEnabled=u,this._outlineEnabled=c;var w=a.stackPartitions,C=a.slicePartitions,E=a.outlineWidth,I=a.subdivisions;if(h.isConstant&&S.isConstant(e.orientation)&&m.isConstant&&S.isConstant(w)&&S.isConstant(C)&&S.isConstant(E)&&S.isConstant(I)){var D=this._options;D.vertexFormat=_?v.VERTEX_FORMAT:f.MaterialSupport.TEXTURED.vertexFormat,D.radii=m.getValue(d.MINIMUM_VALUE,D.radii),D.stackPartitions=n(w)?w.getValue(d.MINIMUM_VALUE):void 0,D.slicePartitions=n(C)?C.getValue(d.MINIMUM_VALUE):void 0,D.subdivisions=n(I)?I.getValue(d.MINIMUM_VALUE):void 0,this._outlineWidth=n(E)?E.getValue(d.MINIMUM_VALUE):1,this._dynamic=!1,this._geometryChanged.raiseEvent(this)}else this._dynamic||(this._dynamic=!0,this._geometryChanged.raiseEvent(this))}},O.prototype.createDynamicUpdater=function(e){if(!this._dynamic)throw new s("This instance does not represent dynamic geometry.");if(!n(e))throw new s("primitives is required.");return new N(e,this)};var N=function(e,t){this._entity=t._entity,this._scene=t._scene,this._primitives=e,this._primitive=void 0,this._outlinePrimitive=void 0,this._geometryUpdater=t,this._options=new R(t._entity),this._modelMatrix=new m,this._material=void 0,this._attributes=void 0,this._outlineAttributes=void 0,this._lastSceneMode=void 0,this._lastShow=void 0,this._lastOutlineShow=void 0,this._lastOutlineWidth=void 0,this._lastOutlineColor=void 0};return N.prototype.update=function(e){if(!n(e))throw new s("time is required.");var o=this._entity,a=o.ellipsoid;if(!o.isShowing||!o.isAvailable(e)||!S.getValueOrDefault(a.show,e,!0))return n(this._primitive)&&(this._primitive.show=!1),void(n(this._outlinePrimitive)&&(this._outlinePrimitive.show=!1));var c=S.getValueOrUndefined(a.radii,e,I),d=o._getModelMatrix(e,this._modelMatrix);if(!n(d)||!n(c))return n(this._primitive)&&(this._primitive.show=!1),void(n(this._outlinePrimitive)&&(this._outlinePrimitive.show=!1));var y,w=S.getValueOrDefault(a.fill,e,!0),C=S.getValueOrDefault(a.outline,e,!1),T=S.getValueOrClonedDefault(a.outlineColor,e,t.BLACK,D),x=E.getValue(e,i(a.material,b),this._material);this._material=x;var P=S.getValueOrUndefined(a.stackPartitions,e),A=S.getValueOrUndefined(a.slicePartitions,e),R=S.getValueOrUndefined(a.subdivisions,e),O=S.getValueOrDefault(a.outlineWidth,e,1),N=this._scene.mode,L=N===_.SCENE3D,F=this._options,B=!L||this._lastSceneMode!==N||!n(this._primitive)||F.stackPartitions!==P||F.slicePartitions!==A||F.subdivisions!==R||this._lastOutlineWidth!==O;if(B){var z=this._primitives;z.removeAndDestroy(this._primitive),z.removeAndDestroy(this._outlinePrimitive),this._primitive=void 0,this._outlinePrimitive=void 0,this._lastSceneMode=N,this._lastOutlineWidth=O,F.stackPartitions=P,F.slicePartitions=A,F.subdivisions=R,F.radii=L?M:c,y=new f({material:x,translucent:x.isTranslucent(),closed:!0}),F.vertexFormat=y.vertexFormat,this._primitive=z.add(new g({geometryInstances:new h({id:o,geometry:new u(F),modelMatrix:L?void 0:d,attributes:{show:new p(w)}}),appearance:y,asynchronous:!1})),F.vertexFormat=v.VERTEX_FORMAT,this._outlinePrimitive=z.add(new g({geometryInstances:new h({id:o,geometry:new l(F),modelMatrix:L?void 0:d,attributes:{show:new p(C),color:r.fromColor(T)}}),appearance:new v({flat:!0,translucent:1!==T.alpha,renderState:{lineWidth:this._geometryUpdater._scene.clampLineWidth(O)}}),asynchronous:!1})),this._lastShow=w,this._lastOutlineShow=C,this._lastOutlineColor=t.clone(T,this._lastOutlineColor)}else if(this._primitive.ready){var V=this._primitive,k=this._outlinePrimitive;V.show=!0,k.show=!0,y=V.appearance,y.material=x;var U=this._attributes;n(U)||(U=V.getGeometryInstanceAttributes(o),this._attributes=U),w!==this._lastShow&&(U.show=p.toValue(w,U.show),this._lastShow=w);var q=this._outlineAttributes;n(q)||(q=k.getGeometryInstanceAttributes(o),this._outlineAttributes=q),C!==this._lastOutlineShow&&(q.show=p.toValue(C,q.show),this._lastOutlineShow=C),t.equals(T,this._lastOutlineColor)||(q.color=r.toValue(T,q.color),t.clone(T,this._lastOutlineColor))}L&&(c.x=Math.max(c.x,.001),c.y=Math.max(c.y,.001),c.z=Math.max(c.z,.001),d=m.multiplyByScale(d,c,d),this._primitive.modelMatrix=d,this._outlinePrimitive.modelMatrix=d)},N.prototype.getBoundingSphere=function(e,t){return C(e,this._primitive,this._outlinePrimitive,t)},N.prototype.isDestroyed=function(){return!1},N.prototype.destroy=function(){var e=this._primitives;e.removeAndDestroy(this._primitive),e.removeAndDestroy(this._outlinePrimitive),a(this)},O}),r("DataSources/StaticGeometryColorBatch",["../Core/AssociativeArray","../Core/Color","../Core/ColorGeometryInstanceAttribute","../Core/defined","../Core/ShowGeometryInstanceAttribute","../Scene/Primitive","./BoundingSphereState"],function(e,t,r,i,n,o,a){"use strict";var s=new t,u=function(t,r,i,n){this.translucent=r,this.appearanceType=i,this.closed=n,this.primitives=t,this.createPrimitive=!1,this.primitive=void 0,this.oldPrimitive=void 0,this.geometry=new e,this.updaters=new e,this.updatersWithAttributes=new e,this.attributes=new e,this.subscriptions=new e,this.showsUpdated=new e,this.itemsToRemove=[]};u.prototype.add=function(e,t){var r=e.entity.id;if(this.createPrimitive=!0,this.geometry.set(r,t),this.updaters.set(r,e),e.hasConstantFill&&e.fillMaterialProperty.isConstant){var i=this;this.subscriptions.set(r,e.entity.definitionChanged.addEventListener(function(t,r,n,o){"isShowing"===r&&i.showsUpdated.set(t.id,e)}))}else this.updatersWithAttributes.set(r,e)},u.prototype.remove=function(e){var t=e.entity.id;if(this.createPrimitive=this.geometry.remove(t)||this.createPrimitive,this.updaters.remove(t)){this.updatersWithAttributes.remove(t);var r=this.subscriptions.get(t);i(r)&&(r(),this.subscriptions.remove(t))}},u.prototype.update=function(e){var a,u,l=!0,c=0,h=this.primitive,d=this.primitives;if(this.createPrimitive){var m=this.geometry.values,p=m.length;if(p>0){for(i(h)&&(i(this.oldPrimitive)?d.remove(h):this.oldPrimitive=h),u=0;p>u;u++){var f=m[u],v=f.attributes;a=this.attributes.get(f.id.id),i(a)&&(i(v.show)&&(v.show.value=a.show),i(v.color)&&(v.color.value=a.color))}h=new o({asynchronous:!0,geometryInstances:m,appearance:new this.appearanceType({translucent:this.translucent,closed:this.closed})}),d.add(h),l=!1}else{i(h)&&(d.remove(h),h=void 0);var g=this.oldPrimitive;i(g)&&(d.remove(g),this.oldPrimitive=void 0)}this.attributes.removeAll(),this.primitive=h,this.createPrimitive=!1}else if(i(h)&&h.ready){i(this.oldPrimitive)&&(d.remove(this.oldPrimitive),this.oldPrimitive=void 0);var _=this.updatersWithAttributes.values,y=_.length;for(u=0;y>u;u++){var w=_[u],C=this.geometry.get(w.entity.id);if(a=this.attributes.get(C.id.id),i(a)||(a=h.getGeometryInstanceAttributes(C.id),this.attributes.set(C.id.id,a)),!w.fillMaterialProperty.isConstant){var E=w.fillMaterialProperty.color;E.getValue(e,s),t.equals(a._lastColor,s)||(a._lastColor=t.clone(s,a._lastColor),a.color=r.toValue(s,a.color),(this.translucent&&255===a.color[3]||!this.translucent&&255!==a.color[3])&&(this.itemsToRemove[c++]=w))}var S=w.entity.isShowing&&(w.hasConstantFill||w.isFilled(e)),b=1===a.show[0];S!==b&&(a.show=n.toValue(S,a.show))}this.updateShows(h)}else i(h)&&!h.ready&&(l=!1);return this.itemsToRemove.length=c,l},u.prototype.updateShows=function(e){for(var t=this.showsUpdated.values,r=t.length,o=0;r>o;o++){var a=t[o],s=this.geometry.get(a.entity.id),u=this.attributes.get(s.id.id);i(u)||(u=e.getGeometryInstanceAttributes(s.id),this.attributes.set(s.id.id,u));var l=a.entity.isShowing,c=1===u.show[0];l!==c&&(u.show=n.toValue(l,u.show))}this.showsUpdated.removeAll()},u.prototype.contains=function(e){return this.updaters.contains(e.id)},u.prototype.getBoundingSphere=function(e,t){var r=this.primitive;if(!r.ready)return a.PENDING;var n=r.getGeometryInstanceAttributes(e);return!i(n)||!i(n.boundingSphere)||i(n.show)&&0===n.show[0]?a.FAILED:(n.boundingSphere.clone(t),a.DONE)},u.prototype.removeAllPrimitives=function(){var e=this.primitives,t=this.primitive;i(t)&&(e.remove(t),this.primitive=void 0,this.geometry.removeAll(),this.updaters.removeAll());var r=this.oldPrimitive;i(r)&&(e.remove(r),this.oldPrimitive=void 0)};var l=function(e,t,r){this._solidBatch=new u(e,!1,t,r),this._translucentBatch=new u(e,!0,t,r)};return l.prototype.add=function(e,t){var r=t.createFillGeometryInstance(e);255===r.attributes.color.value[3]?this._solidBatch.add(t,r):this._translucentBatch.add(t,r)},l.prototype.remove=function(e){this._solidBatch.remove(e)||this._translucentBatch.remove(e)},l.prototype.update=function(e){var t,r,i=this._solidBatch.update(e);i=this._translucentBatch.update(e)&&i;var n=this._solidBatch.itemsToRemove,o=n.length;if(o>0)for(t=0;o>t;t++)r=n[t],this._solidBatch.remove(r),this._translucentBatch.add(r,r.createFillGeometryInstance(e));n=this._translucentBatch.itemsToRemove;var a=n.length;if(a>0)for(t=0;a>t;t++)r=n[t],this._translucentBatch.remove(r),this._solidBatch.add(r,r.createFillGeometryInstance(e));return(o>0||a>0)&&(i=this._solidBatch.update(e)&&i,i=this._translucentBatch.update(e)&&i),i},l.prototype.getBoundingSphere=function(e,t){return this._solidBatch.contains(e)?this._solidBatch.getBoundingSphere(e,t):this._translucentBatch.contains(e)?this._translucentBatch.getBoundingSphere(e,t):a.FAILED},l.prototype.removeAllPrimitives=function(){this._solidBatch.removeAllPrimitives(),this._translucentBatch.removeAllPrimitives()},l}),r("DataSources/StaticGeometryPerMaterialBatch",["../Core/AssociativeArray","../Core/defined","../Core/ShowGeometryInstanceAttribute","../Scene/Primitive","./BoundingSphereState","./MaterialProperty"],function(e,t,r,i,n,o){"use strict";var a=function(t,r,i,n){this.primitives=t,this.appearanceType=r,this.materialProperty=i,this.closed=n,this.updaters=new e,this.createPrimitive=!0,this.primitive=void 0,this.oldPrimitive=void 0,this.geometry=new e,this.material=void 0,this.updatersWithAttributes=new e,this.attributes=new e,this.invalidated=!1,this.removeMaterialSubscription=i.definitionChanged.addEventListener(a.prototype.onMaterialChanged,this),this.subscriptions=new e,this.showsUpdated=new e};a.prototype.onMaterialChanged=function(){this.invalidated=!0},a.prototype.isMaterial=function(e){var r=this.materialProperty,i=e.fillMaterialProperty;return i===r?!0:t(r)?r.equals(i):!1},a.prototype.add=function(e,t){var r=t.entity.id;if(this.updaters.set(r,t),this.geometry.set(r,t.createFillGeometryInstance(e)),t.hasConstantFill&&t.fillMaterialProperty.isConstant){var i=this;this.subscriptions.set(r,t.entity.definitionChanged.addEventListener(function(e,r,n,o){"isShowing"===r&&i.showsUpdated.set(e.id,t)}))}else this.updatersWithAttributes.set(r,t);this.createPrimitive=!0},a.prototype.remove=function(e){var r=e.entity.id,i=this.updaters.remove(r);if(i){this.geometry.remove(r),this.updatersWithAttributes.remove(r);var n=this.subscriptions.get(r);t(n)&&(n(),this.subscriptions.remove(r))}return this.createPrimitive=i,i},a.prototype.update=function(e){var n,a,s=!0,u=this.primitive,l=this.primitives,c=this.geometry.values;if(this.createPrimitive){var h=c.length;if(h>0){for(t(u)&&(t(this.oldPrimitive)?l.remove(u):this.oldPrimitive=u),a=0;h>a;a++){var d=c[a],m=d.attributes;n=this.attributes.get(d.id.id),t(n)&&(t(m.show)&&(m.show.value=n.show),t(m.color)&&(m.color.value=n.color))}this.material=o.getValue(e,this.materialProperty,this.material),u=new i({asynchronous:!0,geometryInstances:c,appearance:new this.appearanceType({material:this.material,translucent:this.material.isTranslucent(),closed:this.closed})}),l.add(u),s=!1}else{t(u)&&(l.remove(u),u=void 0);var p=this.oldPrimitive;t(p)&&(l.remove(p),this.oldPrimitive=void 0)}this.attributes.removeAll(),this.primitive=u,this.createPrimitive=!1}else if(t(u)&&u.ready){t(this.oldPrimitive)&&(l.remove(this.oldPrimitive),this.oldPrimitive=void 0),this.material=o.getValue(e,this.materialProperty,this.material),this.primitive.appearance.material=this.material;var f=this.updatersWithAttributes.values,v=f.length;for(a=0;v>a;a++){var g=f[a],_=g.entity,y=this.geometry.get(_.id);n=this.attributes.get(y.id.id),t(n)||(n=u.getGeometryInstanceAttributes(y.id),
this.attributes.set(y.id.id,n));var w=_.isShowing&&(g.hasConstantFill||g.isFilled(e)),C=1===n.show[0];w!==C&&(n.show=r.toValue(w,n.show))}this.updateShows(u)}else t(u)&&!u.ready&&(s=!1);return s},a.prototype.updateShows=function(e){for(var i=this.showsUpdated.values,n=i.length,o=0;n>o;o++){var a=i[o],s=a.entity,u=this.geometry.get(s.id),l=this.attributes.get(u.id.id);t(l)||(l=e.getGeometryInstanceAttributes(u.id),this.attributes.set(u.id.id,l));var c=s.isShowing,h=1===l.show[0];c!==h&&(l.show=r.toValue(c,l.show))}this.showsUpdated.removeAll()},a.prototype.contains=function(e){return this.updaters.contains(e.id)},a.prototype.getBoundingSphere=function(e,r){var i=this.primitive;if(!i.ready)return n.PENDING;var o=i.getGeometryInstanceAttributes(e);return!t(o)||!t(o.boundingSphere)||t(o.show)&&0===o.show[0]?n.FAILED:(o.boundingSphere.clone(r),n.DONE)},a.prototype.destroy=function(e){var r=this.primitive,i=this.primitives;t(r)&&i.remove(r);var n=this.oldPrimitive;t(n)&&i.remove(n),this.removeMaterialSubscription()};var s=function(e,t,r){this._items=[],this._primitives=e,this._appearanceType=t,this._closed=r};return s.prototype.add=function(e,t){for(var r=this._items,i=r.length,n=0;i>n;n++){var o=r[n];if(o.isMaterial(t))return void o.add(e,t)}var s=new a(this._primitives,this._appearanceType,t.fillMaterialProperty,this._closed);s.add(e,t),r.push(s)},s.prototype.remove=function(e){for(var t=this._items,r=t.length,i=r-1;i>=0;i--){var n=t[i];if(n.remove(e)){0===n.updaters.length&&(t.splice(i,1),n.destroy());break}}},s.prototype.update=function(e){var t,r=this._items,i=r.length;for(t=i-1;t>=0;t--){var n=r[t];if(n.invalidated){r.splice(t,1);for(var o=n.updaters.values,a=o.length,s=0;a>s;s++)this.add(e,o[s]);n.destroy()}}var u=!0;for(t=0;i>t;t++)u=r[t].update(e)&&u;return u},s.prototype.getBoundingSphere=function(e,t){for(var r=this._items,i=r.length,o=0;i>o;o++){var a=r[o];if(a.contains(e))return a.getBoundingSphere(e,t)}return n.FAILED},s.prototype.removeAllPrimitives=function(){for(var e=this._items,t=e.length,r=0;t>r;r++)e[r].destroy();this._items.length=0},s}),r("DataSources/StaticOutlineGeometryBatch",["../Core/AssociativeArray","../Core/Color","../Core/ColorGeometryInstanceAttribute","../Core/defined","../Core/ShowGeometryInstanceAttribute","../Scene/PerInstanceColorAppearance","../Scene/Primitive","./BoundingSphereState"],function(e,t,r,i,n,o,a,s){"use strict";var u=function(t,r,i){this.translucent=r,this.primitives=t,this.createPrimitive=!1,this.primitive=void 0,this.oldPrimitive=void 0,this.geometry=new e,this.updaters=new e,this.updatersWithAttributes=new e,this.attributes=new e,this.itemsToRemove=[],this.width=i,this.subscriptions=new e,this.showsUpdated=new e};u.prototype.add=function(e,t){var r=e.entity.id;if(this.createPrimitive=!0,this.geometry.set(r,t),this.updaters.set(r,e),e.hasConstantOutline&&e.outlineColorProperty.isConstant){var i=this;this.subscriptions.set(r,e.entity.definitionChanged.addEventListener(function(t,r,n,o){"isShowing"===r&&i.showsUpdated.set(t.id,e)}))}else this.updatersWithAttributes.set(r,e)},u.prototype.remove=function(e){var t=e.entity.id;if(this.createPrimitive=this.geometry.remove(t)||this.createPrimitive,this.updaters.remove(t)){this.updatersWithAttributes.remove(t);var r=this.subscriptions.get(t);i(r)&&(r(),this.subscriptions.remove(t))}};var l=new t;u.prototype.update=function(e){var s,u,c=!0,h=0,d=this.primitive,m=this.primitives;if(this.createPrimitive){var p=this.geometry.values,f=p.length;if(f>0){for(i(d)&&(i(this.oldPrimitive)?m.remove(d):this.oldPrimitive=d),u=0;f>u;u++){var v=p[u],g=v.attributes;s=this.attributes.get(v.id.id),i(s)&&(i(g.show)&&(g.show.value=s.show),i(g.color)&&(g.color.value=s.color))}d=new a({asynchronous:!0,geometryInstances:p,appearance:new o({flat:!0,translucent:this.translucent,renderState:{lineWidth:this.width}})}),m.add(d),c=!1}else{i(d)&&(m.remove(d),d=void 0);var _=this.oldPrimitive;i(_)&&(m.remove(_),this.oldPrimitive=void 0)}this.attributes.removeAll(),this.primitive=d,this.createPrimitive=!1}else if(i(d)&&d.ready){i(this.oldPrimitive)&&(m.remove(this.oldPrimitive),this.oldPrimitive=void 0);var y=this.updatersWithAttributes.values,w=y.length;for(u=0;w>u;u++){var C=y[u],E=this.geometry.get(C.entity.id);if(s=this.attributes.get(E.id.id),i(s)||(s=d.getGeometryInstanceAttributes(E.id),this.attributes.set(E.id.id,s)),!C.outlineColorProperty.isConstant){var S=C.outlineColorProperty;S.getValue(e,l),t.equals(s._lastColor,l)||(s._lastColor=t.clone(l,s._lastColor),s.color=r.toValue(l,s.color),(this.translucent&&255===s.color[3]||!this.translucent&&255!==s.color[3])&&(this.itemsToRemove[h++]=C))}var b=C.entity.isShowing&&(C.hasConstantOutline||C.isOutlineVisible(e)),T=1===s.show[0];b!==T&&(s.show=n.toValue(b,s.show))}this.updateShows(d)}else i(d)&&!d.ready&&(c=!1);return this.itemsToRemove.length=h,c},u.prototype.updateShows=function(e){for(var t=this.showsUpdated.values,r=t.length,o=0;r>o;o++){var a=t[o],s=this.geometry.get(a.entity.id),u=this.attributes.get(s.id.id);i(u)||(u=e.getGeometryInstanceAttributes(s.id),this.attributes.set(s.id.id,u));var l=a.entity.isShowing,c=1===u.show[0];l!==c&&(u.show=n.toValue(l,u.show))}this.showsUpdated.removeAll()},u.prototype.contains=function(e){return this.updaters.contains(e.id)},u.prototype.getBoundingSphere=function(e,t){var r=this.primitive;if(!r.ready)return s.PENDING;var n=r.getGeometryInstanceAttributes(e);return!i(n)||!i(n.boundingSphere)||i(n.show)&&0===n.show[0]?s.FAILED:(n.boundingSphere.clone(t),s.DONE)},u.prototype.removeAllPrimitives=function(){var e=this.primitives,t=this.primitive;i(t)&&(e.remove(t),this.primitive=void 0,this.geometry.removeAll(),this.updaters.removeAll());var r=this.oldPrimitive;i(r)&&(e.remove(r),this.oldPrimitive=void 0)};var c=function(t,r){this._primitives=t,this._scene=r,this._solidBatches=new e,this._translucentBatches=new e};return c.prototype.add=function(e,t){var r,n,o=t.createOutlineGeometryInstance(e),a=this._scene.clampLineWidth(t.outlineWidth);255===o.attributes.color.value[3]?(r=this._solidBatches,n=r.get(a),i(n)||(n=new u(this._primitives,!1,a),r.set(a,n)),n.add(t,o)):(r=this._translucentBatches,n=r.get(a),i(n)||(n=new u(this._primitives,!0,a),r.set(a,n)),n.add(t,o))},c.prototype.remove=function(e){var t,r=this._solidBatches.values,i=r.length;for(t=0;i>t;t++)if(r[t].remove(e))return;var n=this._translucentBatches.values,o=n.length;for(t=0;o>t;t++)if(n[t].remove(e))return},c.prototype.update=function(e){var t,r,i,n,o,a=this._solidBatches.values,s=a.length,u=this._translucentBatches.values,l=u.length,c=!0,h=!1;do{for(h=!1,r=0;s>r;r++){n=a[r],c=n.update(e),o=n.itemsToRemove;var d=o.length;if(d>0)for(h=!0,t=0;d>t;t++)i=o[t],n.remove(i),this.add(e,i)}for(r=0;l>r;r++){n=u[r],c=n.update(e),o=n.itemsToRemove;var m=o.length;if(m>0)for(h=!0,t=0;m>t;t++)i=o[t],n.remove(i),this.add(e,i)}}while(h);return c},c.prototype.getBoundingSphere=function(e,t){var r,i=this._solidBatches.values,n=i.length;for(r=0;n>r;r++){var o=i[r];if(o.contains(e))return o.getBoundingSphere(e,t)}var a=this._translucentBatches.values,u=a.length;for(r=0;u>r;r++){var l=a[r];if(l.contains(e))return l.getBoundingSphere(e,t)}return s.FAILED},c.prototype.removeAllPrimitives=function(){var e,t=this._solidBatches.values,r=t.length;for(e=0;r>e;e++)t[e].removeAllPrimitives();var i=this._translucentBatches.values,n=i.length;for(e=0;n>e;e++)i[e].removeAllPrimitives()},c}),r("DataSources/GeometryVisualizer",["../Core/AssociativeArray","../Core/BoundingSphere","../Core/defined","../Core/destroyObject","../Core/DeveloperError","./BoundingSphereState","./ColorMaterialProperty","./StaticGeometryColorBatch","./StaticGeometryPerMaterialBatch","./StaticOutlineGeometryBatch"],function(e,t,r,i,n,o,a,s,u,l){"use strict";function c(e,t){for(var r=e._batches,i=r.length,n=0;i>n;n++)r[n].remove(t)}function h(e,t,r){return r.isDynamic?void e._dynamicBatch.add(t,r):(r.outlineEnabled&&e._outlineBatch.add(t,r),void(r.fillEnabled&&(r.isClosed?r.fillMaterialProperty instanceof a?e._closedColorBatch.add(t,r):e._closedMaterialBatch.add(t,r):r.fillMaterialProperty instanceof a?e._openColorBatch.add(t,r):e._openMaterialBatch.add(t,r))))}var d=[],m=function(t){this._primitives=t,this._dynamicUpdaters=new e};m.prototype.add=function(e,t){this._dynamicUpdaters.set(t.entity.id,t.createDynamicUpdater(this._primitives))},m.prototype.remove=function(e){var t=e.entity.id,i=this._dynamicUpdaters.get(t);r(i)&&(this._dynamicUpdaters.remove(t),i.destroy())},m.prototype.update=function(e){for(var t=this._dynamicUpdaters.values,r=0,i=t.length;i>r;r++)t[r].update(e);return!0},m.prototype.removeAllPrimitives=function(){for(var e=this._dynamicUpdaters.values,t=0,r=e.length;r>t;t++)e[t].destroy();this._dynamicUpdaters.removeAll()},m.prototype.getBoundingSphere=function(e,t){var i=this._dynamicUpdaters.get(e.id);return r(i)&&r(i.getBoundingSphere)?i.getBoundingSphere(e,t):o.FAILED};var p=function(t,i,o){if(!r(t))throw new n("type is required.");if(!r(i))throw new n("scene is required.");if(!r(o))throw new n("entityCollection is required.");this._type=t;var a=i.primitives;this._scene=i,this._primitives=a,this._entityCollection=void 0,this._addedObjects=new e,this._removedObjects=new e,this._changedObjects=new e,this._outlineBatch=new l(a,i),this._closedColorBatch=new s(a,t.perInstanceColorAppearanceType,!0),this._closedMaterialBatch=new u(a,t.materialAppearanceType,!0),this._openColorBatch=new s(a,t.perInstanceColorAppearanceType,!1),this._openMaterialBatch=new u(a,t.materialAppearanceType,!1),this._dynamicBatch=new m(a),this._batches=[this._closedColorBatch,this._closedMaterialBatch,this._openColorBatch,this._openMaterialBatch,this._dynamicBatch,this._outlineBatch],this._subscriptions=new e,this._updaters=new e,this._entityCollection=o,o.collectionChanged.addEventListener(p.prototype._onCollectionChanged,this),this._onCollectionChanged(o,o.values,d)};p.prototype.update=function(e){if(!r(e))throw new n("time is required.");var t,i,o,a,s=this._addedObjects,u=s.values,l=this._removedObjects,d=l.values,m=this._changedObjects,f=m.values;for(t=f.length-1;t>-1;t--)i=f[t],o=i.id,a=this._updaters.get(o),a.entity===i?(c(this,a),h(this,e,a)):(d.push(i),u.push(i));for(t=d.length-1;t>-1;t--)i=d[t],o=i.id,a=this._updaters.get(o),c(this,a),a.destroy(),this._updaters.remove(o),this._subscriptions.get(o)(),this._subscriptions.remove(o);for(t=u.length-1;t>-1;t--)i=u[t],o=i.id,a=new this._type(i,this._scene),this._updaters.set(o,a),h(this,e,a),this._subscriptions.set(o,a.geometryChanged.addEventListener(p._onGeometryChanged,this));s.removeAll(),l.removeAll(),m.removeAll();var v=!0,g=this._batches,_=g.length;for(t=0;_>t;t++)v=g[t].update(e)&&v;return v};var f=[],v=new t;return p.prototype.getBoundingSphere=function(e,i){if(!r(e))throw new n("entity is required.");if(!r(i))throw new n("result is required.");for(var a=f,s=v,u=0,l=o.DONE,c=this._batches,h=c.length,d=0;h>d;d++){if(l=c[d].getBoundingSphere(e,s),l===o.PENDING)return o.PENDING;l===o.DONE&&(a[u]=t.clone(s,a[u]),u++)}return 0===u?o.FAILED:(a.length=u,t.fromBoundingSpheres(a,i),o.DONE)},p.prototype.isDestroyed=function(){return!1},p.prototype.destroy=function(){this._entityCollection.collectionChanged.removeEventListener(p.prototype._onCollectionChanged,this),this._addedObjects.removeAll(),this._removedObjects.removeAll();var e,t=this._batches,r=t.length;for(e=0;r>e;e++)t[e].removeAllPrimitives();var n=this._subscriptions.values;for(r=n.length,e=0;r>e;e++)n[e]();return this._subscriptions.removeAll(),i(this)},p._onGeometryChanged=function(e){var t=this._removedObjects,i=this._changedObjects,n=e.entity,o=n.id;r(t.get(o))||r(i.get(o))||i.set(o,n)},p.prototype._onCollectionChanged=function(e,t,r){var i,n,o,a=this._addedObjects,s=this._removedObjects,u=this._changedObjects;for(i=r.length-1;i>-1;i--)o=r[i],n=o.id,a.remove(n)||(s.set(n,o),u.remove(n));for(i=t.length-1;i>-1;i--)o=t[i],n=o.id,s.remove(n)?u.set(n,o):a.set(n,o)},p}),r("Scene/Label",["../Core/Cartesian2","../Core/Cartesian3","../Core/Color","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/NearFarScalar","./Billboard","./HeightReference","./HorizontalOrigin","./LabelStyle","./VerticalOrigin"],function(e,t,r,i,n,o,a,s,u,l,c,h,d){"use strict";function m(e){e._rebindAllGlyphs||e._repositionAllGlyphs||e._labelCollection._labelsToUpdate.push(e),e._rebindAllGlyphs=!0}function p(e){e._rebindAllGlyphs||e._repositionAllGlyphs||e._labelCollection._labelsToUpdate.push(e),e._repositionAllGlyphs=!0}var f=function(o,s){if(o=i(o,i.EMPTY_OBJECT),n(o.translucencyByDistance)&&o.translucencyByDistance.far<=o.translucencyByDistance.near)throw new a("translucencyByDistance.far must be greater than translucencyByDistance.near.");if(n(o.pixelOffsetScaleByDistance)&&o.pixelOffsetScaleByDistance.far<=o.pixelOffsetScaleByDistance.near)throw new a("pixelOffsetScaleByDistance.far must be greater than pixelOffsetScaleByDistance.near.");this._text=i(o.text,""),this._show=i(o.show,!0),this._font=i(o.font,"30px sans-serif"),this._fillColor=r.clone(i(o.fillColor,r.WHITE)),this._outlineColor=r.clone(i(o.outlineColor,r.BLACK)),this._outlineWidth=i(o.outlineWidth,1),this._style=i(o.style,h.FILL),this._verticalOrigin=i(o.verticalOrigin,d.BOTTOM),this._horizontalOrigin=i(o.horizontalOrigin,c.LEFT),this._pixelOffset=e.clone(i(o.pixelOffset,e.ZERO)),this._eyeOffset=t.clone(i(o.eyeOffset,t.ZERO)),this._position=t.clone(i(o.position,t.ZERO)),this._scale=i(o.scale,1),this._id=o.id,this._translucencyByDistance=o.translucencyByDistance,this._pixelOffsetScaleByDistance=o.pixelOffsetScaleByDistance,this._heightReference=i(o.heightReference,l.NONE),this._labelCollection=s,this._glyphs=[],this._rebindAllGlyphs=!0,this._repositionAllGlyphs=!0,this._actualClampedPosition=void 0,this._removeCallbackFunc=void 0,this._mode=void 0,this._updateClamping()};return o(f.prototype,{show:{get:function(){return this._show},set:function(e){if(!n(e))throw new a("value is required.");if(this._show!==e){this._show=e;for(var t=this._glyphs,r=0,i=t.length;i>r;r++){var o=t[r];n(o.billboard)&&(o.billboard.show=e)}}}},position:{get:function(){return this._position},set:function(e){if(!n(e))throw new a("value is required.");var r=this._position;if(!t.equals(r,e))if(t.clone(e,r),this._heightReference===l.NONE)for(var i=this._glyphs,o=0,s=i.length;s>o;o++){var u=i[o];n(u.billboard)&&(u.billboard.position=e)}else this._updateClamping()}},heightReference:{get:function(){return this._heightReference},set:function(e){if(!n(e))throw new a("value is required.");e!==this._heightReference&&(this._heightReference=e,this._updateClamping())}},text:{get:function(){return this._text},set:function(e){if(!n(e))throw new a("value is required.");this._text!==e&&(this._text=e,m(this))}},font:{get:function(){return this._font},set:function(e){if(!n(e))throw new a("value is required.");this._font!==e&&(this._font=e,m(this))}},fillColor:{get:function(){return this._fillColor},set:function(e){if(!n(e))throw new a("value is required.");var t=this._fillColor;r.equals(t,e)||(r.clone(e,t),m(this))}},outlineColor:{get:function(){return this._outlineColor},set:function(e){if(!n(e))throw new a("value is required.");var t=this._outlineColor;r.equals(t,e)||(r.clone(e,t),m(this))}},outlineWidth:{get:function(){return this._outlineWidth},set:function(e){if(!n(e))throw new a("value is required.");this._outlineWidth!==e&&(this._outlineWidth=e,m(this))}},style:{get:function(){return this._style},set:function(e){if(!n(e))throw new a("value is required.");this._style!==e&&(this._style=e,m(this))}},pixelOffset:{get:function(){return this._pixelOffset},set:function(t){if(!n(t))throw new a("value is required.");var r=this._pixelOffset;if(!e.equals(r,t)){e.clone(t,r);for(var i=this._glyphs,o=0,s=i.length;s>o;o++){var u=i[o];n(u.billboard)&&(u.billboard.pixelOffset=t)}}}},translucencyByDistance:{get:function(){return this._translucencyByDistance},set:function(e){if(n(e)&&e.far<=e.near)throw new a("far distance must be greater than near distance.");var t=this._translucencyByDistance;if(!s.equals(t,e)){this._translucencyByDistance=s.clone(e,t);for(var r=this._glyphs,i=0,o=r.length;o>i;i++){var u=r[i];n(u.billboard)&&(u.billboard.translucencyByDistance=e)}}}},pixelOffsetScaleByDistance:{get:function(){return this._pixelOffsetScaleByDistance},set:function(e){if(n(e)&&e.far<=e.near)throw new a("far distance must be greater than near distance.");var t=this._pixelOffsetScaleByDistance;if(!s.equals(t,e)){this._pixelOffsetScaleByDistance=s.clone(e,t);for(var r=this._glyphs,i=0,o=r.length;o>i;i++){var u=r[i];n(u.billboard)&&(u.billboard.pixelOffsetScaleByDistance=e)}}}},eyeOffset:{get:function(){return this._eyeOffset},set:function(e){if(!n(e))throw new a("value is required.");var r=this._eyeOffset;if(!t.equals(r,e)){t.clone(e,r);for(var i=this._glyphs,o=0,s=i.length;s>o;o++){var u=i[o];n(u.billboard)&&(u.billboard.eyeOffset=e)}}}},horizontalOrigin:{get:function(){return this._horizontalOrigin},set:function(e){if(!n(e))throw new a("value is required.");this._horizontalOrigin!==e&&(this._horizontalOrigin=e,p(this))}},verticalOrigin:{get:function(){return this._verticalOrigin},set:function(e){if(!n(e))throw new a("value is required.");if(this._verticalOrigin!==e){this._verticalOrigin=e;for(var t=this._glyphs,r=0,i=t.length;i>r;r++){var o=t[r];n(o.billboard)&&(o.billboard.verticalOrigin=e)}p(this)}}},scale:{get:function(){return this._scale},set:function(e){if(!n(e))throw new a("value is required.");if(this._scale!==e){this._scale=e;for(var t=this._glyphs,r=0,i=t.length;i>r;r++){var o=t[r];n(o.billboard)&&(o.billboard.scale=e)}p(this)}}},id:{get:function(){return this._id},set:function(e){if(this._id!==e){this._id=e;for(var t=this._glyphs,r=0,i=t.length;i>r;r++){var o=t[r];n(o.billboard)&&(o.billboard.id=e)}}}},_clampedPosition:{get:function(){return this._actualClampedPosition},set:function(e){this._actualClampedPosition=t.clone(e,this._actualClampedPosition);for(var r=this._glyphs,i=0,o=r.length;o>i;i++){var a=r[i];n(a.billboard)&&(a.billboard.position=e)}}}}),f.prototype._updateClamping=function(){u._updateClamping(this._labelCollection,this)},f.prototype.computeScreenSpacePosition=function(t,r){if(!n(t))throw new a("scene is required.");n(r)||(r=new e);var i=this._labelCollection,o=i.modelMatrix,s=u._computeActualPosition(this,this._position,t.frameState,o),l=u._computeScreenSpacePosition(o,s,this._eyeOffset,this._pixelOffset,t,r);return l.y=t.canvas.clientHeight-l.y,l},f.prototype.equals=function(i){return this===i||n(i)&&this._show===i._show&&this._scale===i._scale&&this._style===i._style&&this._verticalOrigin===i._verticalOrigin&&this._horizontalOrigin===i._horizontalOrigin&&this._text===i._text&&this._font===i._font&&t.equals(this._position,i._position)&&r.equals(this._fillColor,i._fillColor)&&r.equals(this._outlineColor,i._outlineColor)&&e.equals(this._pixelOffset,i._pixelOffset)&&t.equals(this._eyeOffset,i._eyeOffset)&&s.equals(this._translucencyByDistance,i._translucencyByDistance)&&s.equals(this._pixelOffsetScaleByDistance,i._pixelOffsetScaleByDistance)&&this._id===i._id},f.prototype.isDestroyed=function(){return!1},f}),r("Scene/LabelCollection",["../Core/Cartesian2","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Matrix4","../Core/writeTextToCanvas","./BillboardCollection","./HorizontalOrigin","./Label","./LabelStyle","./TextureAtlas","./VerticalOrigin"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m){"use strict";function p(){this.textureInfo=void 0,this.dimensions=void 0,this.billboard=void 0}function f(e,t,r){this.labelCollection=e,this.index=t,this.dimensions=r}function v(e,t,r,i,n,o,a){return E.font=t,E.fillColor=r,E.strokeColor=i,E.strokeWidth=n,a===m.BOTTOM?E.textBaseline="bottom":a===m.TOP?E.textBaseline="top":E.textBaseline="middle",E.fill=o===h.FILL||o===h.FILL_AND_OUTLINE,E.stroke=o===h.OUTLINE||o===h.FILL_AND_OUTLINE,s(e,E)}function g(e,t){t.textureInfo=void 0,t.dimensions=void 0;var i=t.billboard;r(i)&&(i.show=!1,i.image=void 0,e._spareBillboards.push(i),t.billboard=void 0)}function _(e,t,r,i){e.addImage(t,r).then(function(e,t){i.index=e})}function y(e,t){var i,n,o,a=t._text,s=a.length,u=t._glyphs,c=u.length;if(c>s)for(n=s;c>n;++n)g(e,u[n]);u.length=s;var h=e._glyphTextureCache;for(o=0;s>o;++o){var d=a.charAt(o),m=t._font,y=t._fillColor,w=t._outlineColor,C=t._outlineWidth,E=t._style,S=t._verticalOrigin,b=JSON.stringify([d,m,y.toRgba(),w.toRgba(),C,+E,+S]),T=h[b];if(!r(T)){var x=v(d,m,y,w,C,E,S);T=new f(e,-1,x.dimensions),h[b]=T,x.width>0&&x.height>0&&_(e._textureAtlas,b,x,T)}if(i=u[o],r(i)?-1===T.index?g(e,i):r(i.textureInfo)&&(i.textureInfo=void 0):(i=new p,u[o]=i),i.textureInfo=T,i.dimensions=T.dimensions,-1!==T.index){var P=i.billboard;r(P)||(P=e._spareBillboards.length>0?e._spareBillboards.pop():e._billboardCollection.add({collection:e}),i.billboard=P),P.show=t._show,P.position=t._position,P.eyeOffset=t._eyeOffset,P.pixelOffset=t._pixelOffset,P.horizontalOrigin=l.LEFT,P.verticalOrigin=t._verticalOrigin,P.scale=t._scale,P.pickPrimitive=t,P.id=t._id,P.image=b,P.translucencyByDistance=t._translucencyByDistance,P.pixelOffsetScaleByDistance=t._pixelOffsetScaleByDistance}}t._repositionAllGlyphs=!0}function w(e,t){var i,n,o=e._glyphs,a=0,s=0,u=0,c=o.length;for(u=0;c>u;++u)i=o[u],n=i.dimensions,a+=n.computedWidth,s=Math.max(s,n.height);var h=e._scale,d=e._horizontalOrigin,p=0;d===l.CENTER?p-=a/2*h:d===l.RIGHT&&(p-=a*h),S.x=p*t,S.y=0;var f=e._verticalOrigin;for(u=0;c>u;++u)i=o[u],n=i.dimensions,f===m.BOTTOM||n.height===s?S.y=-n.descent*h:f===m.TOP?S.y=-(s-n.height)*h-n.descent*h:f===m.CENTER&&(S.y=-(s-n.height)/2*h-n.descent*h),S.y*=t,r(i.billboard)&&i.billboard._setTranslate(S),S.x+=n.computedWidth*h*t}function C(e,t){for(var i=t._glyphs,o=0,a=i.length;a>o;++o)g(e,i[o]);t._labelCollection=void 0,r(t._removeCallbackFunc)&&t._removeCallbackFunc(),n(t)}var E={},S=new e,b=function(e){e=t(e,t.EMPTY_OBJECT),this._scene=e.scene,this._textureAtlas=void 0,this._billboardCollection=new u({scene:this._scene}),this._billboardCollection.destroyTextureAtlas=!1,this._spareBillboards=[],this._glyphTextureCache={},this._labels=[],this._labelsToUpdate=[],this._totalGlyphCount=0,this._resolutionScale=void 0,this.modelMatrix=a.clone(t(e.modelMatrix,a.IDENTITY)),this.debugShowBoundingVolume=t(e.debugShowBoundingVolume,!1)};return i(b.prototype,{length:{get:function(){return this._labels.length}}}),b.prototype.add=function(e){var t=new c(e,this);return this._labels.push(t),this._labelsToUpdate.push(t),t},b.prototype.remove=function(e){if(r(e)&&e._labelCollection===this){var t=this._labels.indexOf(e);if(-1!==t)return this._labels.splice(t,1),C(this,e),!0}return!1},b.prototype.removeAll=function(){for(var e=this._labels,t=0,r=e.length;r>t;++t)C(this,e[t]);e.length=0},b.prototype.contains=function(e){return r(e)&&e._labelCollection===this},b.prototype.get=function(e){if(!r(e))throw new o("index is required.");return this._labels[e]},b.prototype.update=function(e){var t=this._billboardCollection;t.modelMatrix=this.modelMatrix,t.debugShowBoundingVolume=this.debugShowBoundingVolume;var i=e.context;r(this._textureAtlas)||(this._textureAtlas=new d({context:i}),t.textureAtlas=this._textureAtlas);var n=i.uniformState,o=n.resolutionScale,a=this._resolutionScale!==o;this._resolutionScale=o;var s;s=a?this._labels:this._labelsToUpdate;for(var u=s.length,l=0;u>l;++l){var c=s[l];if(!c.isDestroyed()){var h=c._glyphs.length;c._rebindAllGlyphs&&(y(this,c),c._rebindAllGlyphs=!1),(a||c._repositionAllGlyphs)&&(w(c,o),c._repositionAllGlyphs=!1);var m=c._glyphs.length-h;this._totalGlyphCount+=m}}this._labelsToUpdate.length=0,t.update(e)},b.prototype.isDestroyed=function(){return!1},b.prototype.destroy=function(){return this.removeAll(),this._billboardCollection=this._billboardCollection.destroy(),this._textureAtlas=this._textureAtlas&&this._textureAtlas.destroy(),n(this)},b}),r("DataSources/LabelVisualizer",["../Core/AssociativeArray","../Core/Cartesian2","../Core/Cartesian3","../Core/Color","../Core/defined","../Core/destroyObject","../Core/DeveloperError","../Core/NearFarScalar","../Scene/HorizontalOrigin","../Scene/LabelCollection","../Scene/LabelStyle","../Scene/VerticalOrigin","./BoundingSphereState","./Property"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m){"use strict";function p(e,t){if(n(e)){var r=e.label;n(r)&&(t.push(e.index),r.show=!1,e.label=void 0,e.index=-1)}}var f=1,v="30px sans-serif",g=c.FILL,_=i.WHITE,y=i.BLACK,w=1,C=t.ZERO,E=r.ZERO,S=u.CENTER,b=h.CENTER,T=new r,x=new i,P=new i,A=new r,I=new t,D=new s,M=new s,R=function(e){this.entity=e,this.label=void 0,this.index=void 0},O=function(t,r){if(!n(t))throw new a("scene is required.");if(!n(r))throw new a("entityCollection is required.");r.collectionChanged.addEventListener(O.prototype._onCollectionChanged,this),this._scene=t,this._unusedIndexes=[],this._labelCollection=void 0,this._entityCollection=r,this._items=new e,this._onCollectionChanged(r,r.values,[],[])};return O.prototype.update=function(e){if(!n(e))throw new a("time is required.");for(var t=this._items.values,r=this._unusedIndexes,i=0,o=t.length;o>i;i++){var s,u=t[i],c=u.entity,h=c._label,d=u.label,R=c.isShowing&&c.isAvailable(e)&&m.getValueOrDefault(h._show,e,!0);if(R&&(T=m.getValueOrUndefined(c._position,e,T),s=m.getValueOrUndefined(h._text,e),R=n(T)&&n(s)),R){if(!n(d)){var O=this._labelCollection;n(O)||(O=new l,this._labelCollection=O,this._scene.primitives.add(O));var N=r.length;if(N>0){var L=r.pop();u.index=L,d=O.get(L)}else d=O.add(),u.index=O.length-1;d.id=c,u.label=d}d.show=!0,d.position=T,d.text=s,d.scale=m.getValueOrDefault(h._scale,e,f),d.font=m.getValueOrDefault(h._font,e,v),d.style=m.getValueOrDefault(h._style,e,g),d.fillColor=m.getValueOrDefault(h._fillColor,e,_,x),d.outlineColor=m.getValueOrDefault(h._outlineColor,e,y,P),d.outlineWidth=m.getValueOrDefault(h._outlineWidth,e,w),d.pixelOffset=m.getValueOrDefault(h._pixelOffset,e,C,I),d.eyeOffset=m.getValueOrDefault(h._eyeOffset,e,E,A),d.horizontalOrigin=m.getValueOrDefault(h._horizontalOrigin,e,S),d.verticalOrigin=m.getValueOrDefault(h._verticalOrigin,e,b),d.translucencyByDistance=m.getValueOrUndefined(h._translucencyByDistance,e,D),d.pixelOffsetScaleByDistance=m.getValueOrUndefined(h._pixelOffsetScaleByDistance,e,M)}else p(u,r)}return!0},O.prototype.getBoundingSphere=function(e,t){if(!n(e))throw new a("entity is required.");if(!n(t))throw new a("result is required.");var i=this._items.get(e.id);return n(i)&&n(i.label)?(t.center=r.clone(i.label.position,t.center),t.radius=0,d.DONE):d.FAILED},O.prototype.isDestroyed=function(){return!1},O.prototype.destroy=function(){return this._entityCollection.collectionChanged.removeEventListener(O.prototype._onCollectionChanged,this),n(this._labelCollection)&&this._scene.primitives.remove(this._labelCollection),o(this)},O.prototype._onCollectionChanged=function(e,t,r,i){var o,a,s=this._unusedIndexes,u=this._items;for(o=t.length-1;o>-1;o--)a=t[o],n(a._label)&&n(a._position)&&u.set(a.id,new R(a));for(o=i.length-1;o>-1;o--)a=i[o],n(a._label)&&n(a._position)?u.contains(a.id)||u.set(a.id,new R(a)):(p(u.get(a.id),s),u.remove(a.id));for(o=r.length-1;o>-1;o--)a=r[o],p(u.get(a.id),s),u.remove(a.id)},O}),r("ThirdParty/gltfDefaults",["../Core/defaultValue","../Core/defined","../Renderer/WebGLConstants"],function(e,t,r){"use strict";function i(r){t(r.accessors)||(r.accessors={});var i=r.accessors;for(var n in i)if(i.hasOwnProperty(n)){var o=i[n];o.byteStride=e(o.byteStride,0)}}function n(r){t(r.animations)||(r.animations={});var i=r.animations;for(var n in i)if(i.hasOwnProperty(n)){var o=i[n];t(o.channels)||(o.channels=[]),t(o.parameters)||(o.parameters={}),t(o.samplers)||(o.samplers={});var a=i.samplers;for(var s in a)if(a.hasOwnProperty(s)){var u=a[s];u.interpolation=e(u.interpolation,"LINEAR")}}}function o(r){t(r.asset)||(r.asset={});var i=r.asset;t(i.profile)&&"string"!=typeof i.profile||(i.profile={});var n=i.profile;i.premultipliedAlpha=e(r.asset.premultipliedAlpha,!1),n.api=e(n.api,"WebGL"),n.version=e(n.version,"1.0.2"),i.version=e(r.version,"0.9")}function a(r){t(r.buffers)||(r.buffers={});var i=r.buffers;for(var n in i)if(i.hasOwnProperty(n)){var o=i[n];o.type=e(o.type,"arraybuffer")}}function s(e){t(e.bufferViews)||(e.bufferViews={})}function u(e){t(e.cameras)||(e.cameras={})}function l(e){t(e.images)||(e.images={})}function c(r){t(r.lights)||(r.lights={});var i=r.lights;for(var n in i)if(i.hasOwnProperty(n)){var o=i[n];if("ambient"===o.type){t(o.ambient)||(o.ambient={});var a=o.ambient;t(a.color)||(a.color=[1,1,1])}else if("directional"===o.type){t(o.directional)||(o.directional={});var s=o.directional;t(s.color)||(s.color=[1,1,1])}else if("point"===o.type){t(o.point)||(o.point={});var u=o.point;t(u.color)||(u.color=[1,1,1]),u.constantAttenuation=e(u.constantAttenuation,1),u.linearAttenuation=e(u.linearAttenuation,0),u.quadraticAttenuation=e(u.quadraticAttenuation,0)}else if("spot"===o.type){t(o.spot)||(o.spot={});var l=o.spot;t(l.color)||(l.color=[1,1,1]),l.constantAttenuation=e(l.constantAttenuation,1),l.fallOffAngle=e(l.fallOffAngle,3.14159265),l.fallOffExponent=e(l.fallOffExponent,0),l.linearAttenuation=e(l.linearAttenuation,0),l.quadraticAttenuation=e(l.quadraticAttenuation,0)}}}function h(e){t(e.materials)||(e.materials={});var r=e.materials;for(var i in r)if(r.hasOwnProperty(i)){var n=r[i].instanceTechnique;t(n.values)||(n.values={})}}function d(i){t(i.meshes)||(i.meshes={});var n=i.meshes;for(var o in n)if(n.hasOwnProperty(o)){var a=n[o];t(a.primitives)||(a.primitives=[]);for(var s=a.primitives.length,u=s.length,l=0;u>l;++l){var c=s[l];t(c.attributes)||(c.attributes={});var h=e(c.primitive,r.TRIANGLES);c.mode=e(c.mode,h)}}}function m(e){t(e.nodes)||(e.nodes={});var r=e.nodes;for(var i in r)if(r.hasOwnProperty(i)){var n=r[i];t(n.children)||(n.children=[]),t(n.matrix)||(t(n.translation)&&t(n.rotation)&&t(n.scale)?(t(n.translation)||(n.translation=[0,0,0]),t(n.rotation)||(n.rotation=[1,0,0,0]),t(n.scale)||(n.scale=[1,1,1])):n.matrix=[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1])}}function p(e){t(e.programs)||(e.programs={});var r=e.programs;for(var i in r)if(r.hasOwnProperty(i)){var n=r[i];t(n.attributes)||(n.attributes=[])}}function f(i){t(i.samplers)||(i.samplers={});var n=i.samplers;for(var o in n)if(n.hasOwnProperty(o)){var a=n[o];a.magFilter=e(a.magFilter,r.LINEAR),a.minFilter=e(a.minFilter,r.NEAREST_MIPMAP_LINEAR),a.wrapS=e(a.wrapS,r.REPEAT),a.wrapT=e(a.wrapT,r.REPEAT)}}function v(e){t(e.scenes)||(e.scenes={});var r=e.scenes;for(var i in r)if(r.hasOwnProperty(i)){var n=r[i];t(n.node)||(n.node=[])}}function g(e){t(e.shaders)||(e.shaders={})}function _(e){t(e.skins)||(e.skins={});var r=e.skins;for(var i in r)if(r.hasOwnProperty(i)){var n=r[i];t(n.bindShapeMatrix)&&(n.bindShapeMatrix=[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1])}}function y(e){t(e.enable)||(e.enable=[]),t(e.disable)||(e.disable=[])}function w(e){t(e.techniques)||(e.techniques={});var r=e.techniques;for(var i in r)if(r.hasOwnProperty(i)){var n=r[i];t(n.parameters)||(n.parameters={});var o=n.passes;for(var a in o)if(o.hasOwnProperty(a)){var s=o[a],u=s.instanceProgram;t(u.attributes)||(u.attributes={}),t(u.uniforms)||(u.uniforms={}),t(s.states)||(s.states={}),y(s.states)}}}function C(i){t(i.textures)||(i.textures={});var n=i.textures;for(var o in n)if(n.hasOwnProperty(o)){var a=n[o];a.format=e(a.format,r.RGBA),a.internalFormat=e(a.internalFormat,a.format),a.target=e(a.target,r.TEXTURE_2D),a.type=e(a.type,r.UNSIGNED_BYTE)}}var E=function(e){return t(e)?(t(e.allExtensions)||(e.allExtensions=[]),i(e),n(e),o(e),a(e),s(e),u(e),l(e),c(e),h(e),d(e),m(e),p(e),f(e),v(e),g(e),_(e),w(e),C(e),e):void 0};return E}),r("Scene/getModelAccessor",["../Core/ComponentDatatype"],function(e){"use strict";var t={SCALAR:1,VEC2:2,VEC3:3,VEC4:4,MAT2:4,MAT3:9,MAT4:16},r=function(r){var i=r.componentType,n=t[r.type];return{componentsPerAttribute:n,createArrayBufferView:function(t,r,o){return e.createArrayBufferView(i,t,r,n*o)}}};return r;
}),r("Scene/ModelAnimationCache",["../Core/Cartesian3","../Core/defaultValue","../Core/defined","../Core/LinearSpline","../Core/Matrix4","../Core/Quaternion","../Core/QuaternionSpline","../Renderer/WebGLConstants","./getModelAccessor"],function(e,t,r,i,n,o,a,s,u){"use strict";function l(e,r){var i=e.gltf,n=i.buffers,o=i.bufferViews,a=o[r.bufferView],s=n[a.buffer],l=a.byteOffset+r.byteOffset,c=r.count*u(r).componentsPerAttribute;return e.cacheKey+"//"+t(s.path,"")+"/"+l+"/"+c}function c(e,t,r){return e.cacheKey+"//"+t+"/"+r}var h=function(){},d={},m=new e;h.getAnimationParameterValues=function(t,i){var n=l(t,i),a=d[n];if(!r(a)){var c,h=t._loadResources,p=t.gltf,f=p.bufferViews,v=f[i.bufferView],g=i.componentType,_=i.type,y=i.count,w=h.getBuffer(v),C=u(i).createArrayBufferView(w.buffer,w.byteOffset+i.byteOffset,y);if(g===s.FLOAT&&"SCALAR"===_)a=C;else if(g===s.FLOAT&&"VEC3"===_)for(a=new Array(y),c=0;y>c;++c)a[c]=e.fromArray(C,3*c);else if(g===s.FLOAT&&"VEC4"===_)for(a=new Array(y),c=0;y>c;++c){var E=4*c;a[c]=o.fromAxisAngle(e.fromArray(C,E,m),C[E+3])}r(t.cacheKey)&&(d[n]=a)}return a};var p={},f=function(e){this._value=e};f.prototype.evaluate=function(e,t){return this._value},h.getAnimationSpline=function(e,t,n,o,u,l){var h=c(e,t,o),d=p[h];if(!r(d)){var m=l[u.input],v=e.gltf.accessors[n.parameters[u.output]],g=l[u.output];if(1===m.length&&1===g.length)d=new f(g[0]);else{var _=v.componentType,y=v.type;"LINEAR"===u.interpolation&&(_===s.FLOAT&&"VEC3"===y?d=new i({times:m,points:g}):_===s.FLOAT&&"VEC4"===y&&(d=new a({times:m,points:g})))}r(e.cacheKey)&&(p[h]=d)}return d};var v={};return h.getSkinInverseBindMatrices=function(e,t){var i=l(e,t),o=v[i];if(!r(o)){var a=e._loadResources,c=e.gltf,h=c.bufferViews,d=h[t.bufferView],m=t.componentType,p=t.type,f=t.count,g=a.getBuffer(d),_=u(t).createArrayBufferView(g.buffer,g.byteOffset+t.byteOffset,f);if(o=new Array(f),m===s.FLOAT&&"MAT4"===p)for(var y=0;f>y;++y)o[y]=n.fromArray(_,16*y);v[i]=o}return o},h}),r("Scene/ModelAnimationLoop",["../Core/freezeObject"],function(e){"use strict";var t={NONE:0,REPEAT:1,MIRRORED_REPEAT:2};return e(t)}),r("Scene/ModelAnimationState",["../Core/freezeObject"],function(e){"use strict";return e({STOPPED:0,ANIMATING:1})}),r("Scene/ModelAnimation",["../Core/defaultValue","../Core/defineProperties","../Core/Event","../Core/JulianDate","./ModelAnimationLoop","./ModelAnimationState"],function(e,t,r,i,n,o){"use strict";var a=function(t,a,s){this._name=t.name,this._startTime=i.clone(t.startTime),this._delay=e(t.delay,0),this._stopTime=t.stopTime,this.removeOnStop=e(t.removeOnStop,!1),this._speedup=e(t.speedup,1),this._reverse=e(t.reverse,!1),this._loop=e(t.loop,n.NONE),this.start=new r,this.update=new r,this.stop=new r,this._state=o.STOPPED,this._runtimeAnimation=s,this._computedStartTime=void 0,this._duration=void 0;var u=this;this._raiseStartEvent=function(){u.start.raiseEvent(a,u)},this._updateEventTime=0,this._raiseUpdateEvent=function(){u.update.raiseEvent(a,u,u._updateEventTime)},this._raiseStopEvent=function(){u.stop.raiseEvent(a,u)}};return t(a.prototype,{name:{get:function(){return this._name}},startTime:{get:function(){return this._startTime}},delay:{get:function(){return this._delay}},stopTime:{get:function(){return this._stopTime}},speedup:{get:function(){return this._speedup}},reverse:{get:function(){return this._reverse}},loop:{get:function(){return this._loop}}}),a}),r("Scene/ModelAnimationCollection",["../Core/clone","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Event","../Core/JulianDate","../Core/Math","./ModelAnimation","./ModelAnimationLoop","./ModelAnimationState"],function(e,t,r,i,n,o,a,s,u,l,c){"use strict";function h(e,t){for(var r=e.channelEvaluators,i=r.length,n=0;i>n;++n)r[n](t)}function d(e,t,r){return function(){e.animationRemoved.raiseEvent(t,r)}}var m=function(e){this.animationAdded=new o,this.animationRemoved=new o,this._model=e,this._scheduledAnimations=[],this._previousTime=void 0};i(m.prototype,{length:{get:function(){return this._scheduledAnimations.length}}}),m.prototype.add=function(e){e=t(e,t.EMPTY_OBJECT);var i=this._model,o=i._runtime.animations;if(!r(o))throw new n("Animations are not loaded.  Wait for Model.readyPromise to resolve.");var a=o[e.name];if(!r(a))throw new n("options.name must be a valid animation name.");if(r(e.speedup)&&e.speedup<=0)throw new n("options.speedup must be greater than zero.");var s=new u(e,i,a);return this._scheduledAnimations.push(s),this.animationAdded.raiseEvent(i,s),s},m.prototype.addAll=function(i){if(i=t(i,t.EMPTY_OBJECT),!r(this._model._runtime.animations))throw new n("Animations are not loaded.  Wait for Model.readyPromise to resolve.");if(r(i.speedup)&&i.speedup<=0)throw new n("options.speedup must be greater than zero.");i=e(i);for(var o=[],a=this._model._animationIds,s=a.length,u=0;s>u;++u)i.name=a[u],o.push(this.add(i));return o},m.prototype.remove=function(e){if(r(e)){var t=this._scheduledAnimations,i=t.indexOf(e);if(-1!==i)return t.splice(i,1),this.animationRemoved.raiseEvent(this._model,e),!0}return!1},m.prototype.removeAll=function(){var e=this._model,t=this._scheduledAnimations,r=t.length;this._scheduledAnimations=[];for(var i=0;r>i;++i)this.animationRemoved.raiseEvent(e,t[i])},m.prototype.contains=function(e){return r(e)?-1!==this._scheduledAnimations.indexOf(e):!1},m.prototype.get=function(e){if(!r(e))throw new n("index is required.");return this._scheduledAnimations[e]};var p=[];return m.prototype.update=function(e){if(a.equals(e.time,this._previousTime))return!1;this._previousTime=a.clone(e.time,this._previousTime);for(var i=!1,n=e.time,o=this._model,u=this._scheduledAnimations,m=u.length,f=0;m>f;++f){var v=u[f],g=v._runtimeAnimation;r(v._computedStartTime)||(v._computedStartTime=a.addSeconds(t(v.startTime,n),v.delay,new a)),r(v._duration)||(v._duration=g.stopTime*(1/v.speedup));var _=v._computedStartTime,y=v._duration,w=v.stopTime,C=0!==y?a.secondsDifference(n,_)/y:0,E=C>=0,S=E&&(1>=C||v.loop===l.REPEAT||v.loop===l.MIRRORED_REPEAT)&&(!r(w)||a.lessThanOrEquals(n,w));if(S){if(v._state===c.STOPPED&&(v._state=c.ANIMATING,v.start.numberOfListeners>0&&e.afterRender.push(v._raiseStartEvent)),v.loop===l.REPEAT)C-=Math.floor(C);else if(v.loop===l.MIRRORED_REPEAT){var b=Math.floor(C),T=C-b;C=b%2===1?1-T:T}v.reverse&&(C=1-C);var x=C*y*v.speedup;x=s.clamp(x,g.startTime,g.stopTime),h(g,x),v.update.numberOfListeners>0&&(v._updateEventTime=x,e.afterRender.push(v._raiseUpdateEvent)),i=!0}else E&&v._state===c.ANIMATING&&(v._state=c.STOPPED,v.stop.numberOfListeners>0&&e.afterRender.push(v._raiseStopEvent),v.removeOnStop&&p.push(v))}m=p.length;for(var P=0;m>P;++P){var A=p[P];u.splice(u.indexOf(A),1),e.afterRender.push(d(this,o,A))}return p.length=0,i},m}),r("Scene/ModelMaterial",["../Core/defined","../Core/defineProperties","../Core/DeveloperError"],function(e,t,r){"use strict";var i=function(e,t,r){this._name=t.name,this._id=r,this._uniformMap=e._uniformMaps[r]};return t(i.prototype,{name:{get:function(){return this._name}},id:{get:function(){return this._id}}}),i.prototype.setValue=function(t,i){if(!e(t))throw new r("name is required.");var n=this._uniformMap.values[t];if(!e(n))throw new r("name must match a parameter name in the material's technique that is targetable and not optimized out.");n.value=n.clone(i,n.value)},i.prototype.getValue=function(t){if(!e(t))throw new r("name is required.");var i=this._uniformMap.values[t];return e(i)?i.value:void 0},i}),r("Scene/ModelMesh",["../Core/defineProperties"],function(e){"use strict";var t=function(e,t,r){for(var i=[],n=e.primitives,o=n.length,a=0;o>a;++a){var s=n[a];i[a]=t[s.material]}this._name=e.name,this._materials=i,this._id=r};return e(t.prototype,{name:{get:function(){return this._name}},id:{get:function(){return this._id}},materials:{get:function(){return this._materials}}}),t}),r("Scene/ModelNode",["../Core/defaultValue","../Core/defineProperties","../Core/Matrix4"],function(e,t,r){"use strict";var i=function(e,t,i,n,o){this._model=e,this._runtimeNode=i,this._name=t.name,this._id=n,this.useMatrix=!1,this._show=!0,this._matrix=r.clone(o)};return t(i.prototype,{name:{get:function(){return this._name}},id:{get:function(){return this._id}},show:{get:function(){return this._show},set:function(e){this._show!==e&&(this._show=e,this._model._perNodeShowDirty=!0)}},matrix:{get:function(){return this._matrix},set:function(e){this._matrix=r.clone(e,this._matrix),this.useMatrix=!0;var t=this._model;t._cesiumAnimationsDirty=!0,this._runtimeNode.dirtyNumber=t._maxDirtyNumber}}}),i.prototype.setMatrix=function(e){r.clone(e,this._matrix)},i}),r("Scene/Model",["../Core/BoundingSphere","../Core/Cartesian2","../Core/Cartesian3","../Core/Cartesian4","../Core/clone","../Core/combine","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/destroyObject","../Core/DeveloperError","../Core/Event","../Core/FeatureDetection","../Core/getStringFromTypedArray","../Core/IndexDatatype","../Core/loadArrayBuffer","../Core/loadImage","../Core/loadImageFromTypedArray","../Core/loadText","../Core/Math","../Core/Matrix2","../Core/Matrix3","../Core/Matrix4","../Core/PrimitiveType","../Core/Quaternion","../Core/Queue","../Core/RuntimeError","../Renderer/Buffer","../Renderer/BufferUsage","../Renderer/DrawCommand","../Renderer/RenderState","../Renderer/Sampler","../Renderer/ShaderProgram","../Renderer/ShaderSource","../Renderer/Texture","../Renderer/TextureMinificationFilter","../Renderer/TextureWrap","../Renderer/VertexArray","../Renderer/WebGLConstants","../ThirdParty/gltfDefaults","../ThirdParty/Uri","../ThirdParty/when","./getModelAccessor","./ModelAnimationCache","./ModelAnimationCollection","./ModelMaterial","./ModelMesh","./ModelNode","./Pass","./SceneMode"],function(e,t,r,i,n,o,a,s,u,l,c,h,d,m,p,f,v,g,_,y,w,C,E,S,b,T,x,P,A,I,D,M,R,O,N,L,F,B,z,V,k,U,q,G,W,H,j,Y,X,Z){"use strict";function K(){this.buffersToCreate=new T,this.buffers={},this.pendingBufferLoads=0,this.programsToCreate=new T,this.shaders={},this.pendingShaderLoads=0,this.texturesToCreate=new T,this.pendingTextureLoads=0,this.texturesToCreateFromBufferView=new T,this.pendingBufferViewToImage=0,this.createSamplers=!0,this.createSkins=!0,this.createRuntimeAnimations=!0,this.createVertexArrays=!0,this.createRenderStates=!0,this.createUniformMaps=!0,this.createRuntimeNodes=!0,this.skinnedNodesNames=[]}function Q(e,t){e._cachedGltf=t,e._animationIds=J(t)}function J(e){var t=[];if(s(e)&&s(e.gltf)){var r=e.gltf.animations;for(var i in r)r.hasOwnProperty(i)&&t.push(i)}return t}function $(e){var t="",r=e.lastIndexOf("/");return-1!==r&&(t=e.substring(0,r+1)),t}function ee(e){var t=new k(document.location.href),r=new k(e);return r.resolve(t).toString()}function te(e,t,r){return e.subarray(t,t+r)}function re(e){return e.byteLength<4?!1:"glTF"===m(e.subarray(0,4))}function ie(e){if(!re(e))throw new c("bgltf is not a valid Binary glTF file.");var t=new DataView(e.buffer,e.byteOffset,e.byteLength),r=0;r+=yt;var i=t.getUint32(r,!0);if(1!==i)throw new c("Only glTF Binary version 1 is supported.  Version "+i+" is not.");r+=yt,r+=yt;var n=t.getUint32(r,!0);r+=yt;var o=t.getUint32(r,!0);r+=yt;var a=m(te(e,n,o));return JSON.parse(a)}function ne(e,t,r){if(e._state!==pt.LOADED)throw new c("The model is not loaded.  Use Model.readyPromise or wait for Model.ready to be true.");if(!s(r))throw new c("name is required.");return e._runtime[t][r]}function oe(t){for(var i=t.nodes,n=t.meshes,o=t.accessors,u=t.scenes[t.scene].nodes,l=u.length,c=[],h=new r(Number.MAX_VALUE,Number.MAX_VALUE,Number.MAX_VALUE),d=new r(Number.MIN_VALUE,Number.MIN_VALUE,Number.MIN_VALUE),m=0;l>m;++m){var p=i[u[m]];for(p._transformToRoot=fe(p),c.push(p);c.length>0;){p=c.pop();var f=p._transformToRoot,v=a(p.meshes,s(p.instanceSkin)?p.instanceSkin.meshes:void 0);if(s(v))for(var g=v.length,_=0;g>_;++_)for(var y=n[v[_]].primitives,w=y.length,C=0;w>C;++C){var S=y[C].attributes.POSITION;if(s(S)){var b=o[S],T=r.fromArray(b.min,0,wt),x=r.fromArray(b.max,0,Ct);s(h)&&s(d)&&(E.multiplyByPoint(f,T,T),E.multiplyByPoint(f,x,x),r.minimumByComponent(h,T,h),r.maximumByComponent(d,x,d))}}for(var P=p.children,A=P.length,I=0;A>I;++I){var D=i[P[I]];D._transformToRoot=fe(D),E.multiplyTransformation(f,D._transformToRoot,D._transformToRoot),c.push(D)}delete p._transformToRoot}}var M=e.fromCornerPoints(h,d);return e.transformWithoutScale(M,dt,M)}function ae(e,t,r){return function(){e._loadError=new x("Failed to load "+t+": "+r),e._state=pt.FAILED}}function se(e,t){return function(r){var i=e._loadResources;i.buffers[t]=new Uint8Array(r),--i.pendingBufferLoads}}function ue(e){var t=e.gltf.buffers;for(var r in t)if(t.hasOwnProperty(r)){var i=t[r];if("CESIUM_binary_glTF"===r){var n=e._loadResources;n.buffers[r]=e._cachedGltf.bgltf}else if("arraybuffer"===i.type){++e._loadResources.pendingBufferLoads;var o=new k(i.uri),a=o.resolve(e._baseUri).toString();f(a).then(se(e,r)).otherwise(ae(e,"buffer",a))}else"text"===i.type}}function le(e){var t=e.gltf.bufferViews;for(var r in t)t.hasOwnProperty(r)&&t[r].target===z.ARRAY_BUFFER&&e._loadResources.buffersToCreate.enqueue(r)}function ce(e,t){return function(r){var i=e._loadResources;i.shaders[t]={source:r,bufferView:void 0},--i.pendingShaderLoads}}function he(e){var t=e.gltf.shaders;for(var r in t)if(t.hasOwnProperty(r)){var i=t[r];if(s(i.extensions)&&s(i.extensions.CESIUM_binary_glTF))e._loadResources.shaders[r]={source:void 0,bufferView:i.extensions.CESIUM_binary_glTF.bufferView};else{++e._loadResources.pendingShaderLoads;var n=new k(i.uri),o=n.resolve(e._baseUri).toString();_(o).then(ce(e,r)).otherwise(ae(e,"shader",o))}}}function de(e){var t=e.gltf.programs;for(var r in t)t.hasOwnProperty(r)&&e._loadResources.programsToCreate.enqueue(r)}function me(e,t){return function(r){var i=e._loadResources;--i.pendingTextureLoads,i.texturesToCreate.enqueue({name:t,image:r,bufferView:void 0})}}function pe(e){var t=e.gltf.images,r=e.gltf.textures;for(var i in r)if(r.hasOwnProperty(i)){var n=t[r[i].source];if(s(n.extensions)&&s(n.extensions.CESIUM_binary_glTF)){var o=n.extensions.CESIUM_binary_glTF;e._loadResources.texturesToCreateFromBufferView.enqueue({name:i,image:void 0,bufferView:o.bufferView,mimeType:o.mimeType})}else{++e._loadResources.pendingTextureLoads;var a=new k(n.uri),u=a.resolve(e._baseUri).toString();v(u).then(me(e,i)).otherwise(ae(e,"image",u))}}}function fe(e){if(s(e.matrix))return E.fromArray(e.matrix);var t=r.fromArray(e.rotation,0,Et);return E.fromTranslationQuaternionRotationScale(r.fromArray(e.translation,0,St),b.fromAxisAngle(t,e.rotation[3],bt),r.fromArray(e.scale,0,Tt))}function ve(e){var t={},r={},i=[],n=e._loadResources.skinnedNodesNames,o=e.gltf.nodes;for(var a in o)if(o.hasOwnProperty(a)){var u=o[a],l={matrix:void 0,translation:void 0,rotation:void 0,scale:void 0,computedShow:!0,transformToRoot:new E,computedMatrix:new E,dirtyNumber:0,commands:[],inverseBindMatrices:void 0,bindShapeMatrix:void 0,joints:[],computedJointMatrices:[],jointName:u.jointName,children:[],parents:[],publicNode:void 0};l.publicNode=new Y(e,u,l,a,fe(u)),t[a]=l,r[u.name]=l,s(u.instanceSkin)&&(n.push(a),i.push(l))}e._runtime.nodes=t,e._runtime.nodesByName=r,e._runtime.skinnedNodes=i}function ge(e){var t={},r={},i=e.gltf.materials,n=e._uniformMaps;for(var o in i)if(i.hasOwnProperty(o)){n[o]={uniformMap:void 0,values:void 0,jointMatrixUniformName:void 0};var a=i[o],s=new H(e,a,o);t[a.name]=s,r[o]=s}e._runtime.materialsByName=t,e._runtime.materialsById=r}function _e(e){var t={},r=e._runtime.materialsById,i=e.gltf.meshes;for(var n in i)if(i.hasOwnProperty(n)){var o=i[n];t[o.name]=new j(o,r,n)}e._runtime.meshesByName=t}function ye(e){e._loadRendererResourcesFromCache||(ue(e),le(e),he(e),de(e),pe(e)),ge(e),_e(e),ve(e)}function we(e,t){var r=e._loadResources;if(0===r.pendingBufferLoads){for(var i,n=e.gltf.bufferViews,o=e._rendererResources.buffers;r.buffersToCreate.length>0;){var a=r.buffersToCreate.dequeue();i=n[a];var u=P.createVertexBuffer({context:t,typedArray:r.getBuffer(i),usage:A.STATIC_DRAW});u.vertexArrayDestroyable=!1,o[a]=u}var l=e.gltf.accessors;for(var c in l)if(l.hasOwnProperty(c)){var h=l[c];if(i=n[h.bufferView],i.target===z.ELEMENT_ARRAY_BUFFER&&!s(o[h.bufferView])){var d=P.createIndexBuffer({context:t,typedArray:r.getBuffer(i),usage:A.STATIC_DRAW,indexDatatype:h.componentType});d.vertexArrayDestroyable=!1,o[h.bufferView]=d}}}}function Ce(e){for(var t={},r=e.length,i=0;r>i;++i)t[e[i]]=i;return t}function Ee(e,t){if(s(t.source))return t.source;var r=e._loadResources,i=e.gltf,n=i.bufferViews[t.bufferView];return m(r.getBuffer(n))}function Se(e,t,r){var i=t.gltf.programs,n=t._loadResources.shaders,o=i[e],a=Ce(o.attributes),s=Ee(t,n[o.vertexShader]),u=Ee(t,n[o.fragmentShader]);if(t._rendererResources.programs[e]=R.fromCache({context:r,vertexShaderSource:s,fragmentShaderSource:u,attributeLocations:a}),t.allowPicking){var l=new O({sources:[u],pickColorQualifier:"uniform"});t._rendererResources.pickPrograms[e]=R.fromCache({context:r,vertexShaderSource:s,fragmentShaderSource:l,attributeLocations:a})}}function be(e,t){var r,i=e._loadResources;if(0===i.pendingShaderLoads&&0===i.pendingBufferLoads)if(e.asynchronous)i.programsToCreate.length>0&&(r=i.programsToCreate.dequeue(),Se(r,e,t));else for(;i.programsToCreate.length>0;)r=i.programsToCreate.dequeue(),Se(r,e,t)}function Te(e,t){return function(r){e.texturesToCreate.enqueue({name:t.name,image:r,bufferView:void 0}),--e.pendingBufferViewToImage}}function xe(e){var t=e._loadResources;if(0===t.pendingBufferLoads)for(;t.texturesToCreateFromBufferView.length>0;){var r=t.texturesToCreateFromBufferView.dequeue(),i=e.gltf,n=i.bufferViews[r.bufferView],o=Te(t,r),a=ae(e,"image","name: "+r.name+", bufferView: "+r.bufferView);g(t.getBuffer(n),r.mimeType).then(o).otherwise(a),++t.pendingBufferViewToImage}}function Pe(e,t){var r=e._loadResources;if(r.createSamplers){r.createSamplers=!1;var i=e._rendererResources.samplers,n=e.gltf.samplers;for(var o in n)if(n.hasOwnProperty(o)){var a=n[o];i[o]=new M({wrapS:a.wrapS,wrapT:a.wrapT,minificationFilter:a.minFilter,magnificationFilter:a.magFilter})}}}function Ae(e,t,r){var i=t.gltf.textures,n=i[e.name],o=t._rendererResources.samplers,a=o[n.sampler],s=a.minificationFilter===L.NEAREST_MIPMAP_NEAREST||a.minificationFilter===L.NEAREST_MIPMAP_LINEAR||a.minificationFilter===L.LINEAR_MIPMAP_NEAREST||a.minificationFilter===L.LINEAR_MIPMAP_LINEAR,u=s||a.wrapS===F.REPEAT||a.wrapS===F.MIRRORED_REPEAT||a.wrapT===F.REPEAT||a.wrapT===F.MIRRORED_REPEAT,l=e.image,c=!y.isPowerOfTwo(l.width)||!y.isPowerOfTwo(l.height);if(u&&c){var h=document.createElement("canvas");h.width=y.nextPowerOfTwo(l.width),h.height=y.nextPowerOfTwo(l.height);var d=h.getContext("2d");d.drawImage(l,0,0,l.width,l.height,0,0,h.width,h.height),l=h}var m;n.target===z.TEXTURE_2D&&(m=new N({context:r,source:l,pixelFormat:n.internalFormat,pixelDatatype:n.type,flipY:!1})),s&&m.generateMipmap(),m.sampler=a,t._rendererResources.textures[e.name]=m}function Ie(e,t){var r,i=e._loadResources;if(e.asynchronous)i.texturesToCreate.length>0&&(r=i.texturesToCreate.dequeue(),Ae(r,e,t));else for(;i.texturesToCreate.length>0;)r=i.texturesToCreate.dequeue(),Ae(r,e,t)}function De(e,t){var r=e.gltf,i=(r.programs,r.techniques),n=r.materials,o={},a=i[n[t.material].instanceTechnique.technique],s=a.parameters,u=a.passes[a.pass],l=u.instanceProgram,c=l.attributes,h=e._rendererResources.programs[l.program].vertexAttributes;for(var d in h)if(h.hasOwnProperty(d)){var m=s[c[d]];o[m.semantic]=h[d].index}return o}function Me(e,t){for(var r=e.length,i=0;r>i;++i)for(var n=[e[i]];n.length>0;){var o=n.pop();if(o.jointName===t)return o;for(var a=o.children,s=a.length,u=0;s>u;++u)n.push(a[u])}return void 0}function Re(e,t){for(var r=e.gltf,i=r.skins,n=r.nodes,o=e._runtime.nodes,a=e._loadResources.skinnedNodesNames,s=a.length,u=0;s>u;++u){var l=a[u],c=o[l],h=n[l].instanceSkin,d=t[h.skin];c.inverseBindMatrices=d.inverseBindMatrices,c.bindShapeMatrix=d.bindShapeMatrix;for(var m=[],p=h.skeletons,f=p.length,v=0;f>v;++v)m.push(o[p[v]]);for(var g=i[h.skin].jointNames,_=g.length,y=0;_>y;++y){var w=g[y];c.joints.push(Me(m,w))}}}function Oe(e){var t=e._loadResources;if(0===t.pendingBufferLoads&&t.createSkins){t.createSkins=!1;var r=e.gltf,i=r.accessors,n=r.skins,o={};for(var a in n)if(n.hasOwnProperty(a)){var s,u=n[a],l=i[u.inverseBindMatrices];E.equals(u.bindShapeMatrix,E.IDENTITY)||(s=E.clone(u.bindShapeMatrix)),o[a]={inverseBindMatrices:G.getSkinInverseBindMatrices(e,l),bindShapeMatrix:s}}Re(e,o)}}function Ne(e,t,r,i){return function(n){t[r]=i.evaluate(n,t[r]),t.dirtyNumber=e._maxDirtyNumber}}function Le(e){var t=e._loadResources;if(t.finishedPendingLoads()&&t.createRuntimeAnimations){t.createRuntimeAnimations=!1,e._runtime.animations={};var r,i=e._runtime.nodes,n=e.gltf.animations,o=e.gltf.accessors;for(var a in n)if(n.hasOwnProperty(a)){var s=n[a],u=s.channels,l=s.parameters,c=s.samplers,h={};for(r in l)l.hasOwnProperty(r)&&(h[r]=G.getAnimationParameterValues(e,o[l[r]]));for(var d=Number.MAX_VALUE,m=-Number.MAX_VALUE,p=u.length,f=new Array(p),v=0;p>v;++v){var g=u[v],_=g.target,y=c[g.sampler],w=h[y.input];d=Math.min(d,w[0]),m=Math.max(m,w[w.length-1]);var C=G.getAnimationSpline(e,a,s,g.sampler,y,h);f[v]=Ne(e,i[_.id],_.path,C)}e._runtime.animations[a]={startTime:d,stopTime:m,channelEvaluators:f}}}}function Fe(e,t){var r=e._loadResources;if(r.finishedBuffersCreation()&&r.finishedProgramCreation()&&r.createVertexArrays){r.createVertexArrays=!1;var i=e._rendererResources.buffers,n=e._rendererResources.vertexArrays,o=e.gltf,a=o.accessors,u=o.meshes;for(var l in u)if(u.hasOwnProperty(l))for(var c=u[l].primitives,h=c.length,d=0;h>d;++d){var m=c[d],p=De(e,m),f=[],v=m.attributes;for(var g in v)if(v.hasOwnProperty(g)){var _=p[g];if(s(_)){var y=a[v[g]];f.push({index:_,vertexBuffer:i[y.bufferView],componentsPerAttribute:q(y).componentsPerAttribute,componentDatatype:y.componentType,normalize:!1,offsetInBytes:y.byteOffset,strideInBytes:y.byteStride})}}var w=a[m.indices],C=i[w.bufferView];n[l+".primitive."+d]=new B({context:t,attributes:f,indexBuffer:C})}}}function Be(e){var t={};t[z.BLEND]=!1,t[z.CULL_FACE]=!1,t[z.DEPTH_TEST]=!1,t[z.POLYGON_OFFSET_FILL]=!1,t[z.SCISSOR_TEST]=!1;var r,i=e.enable,n=i.length;for(r=0;n>r;++r)t[i[r]]=!0;return t}function ze(e,t){var r=e._loadResources;if(r.createRenderStates){r.createRenderStates=!1;var i=e._rendererResources.renderStates,n=e.gltf.techniques;for(var o in n)if(n.hasOwnProperty(o)){var u=n[o],l=u.passes[u.pass],c=l.states,h=Be(c),d=a(c.functions,a.EMPTY_OBJECT),m=a(d.blendColor,[0,0,0,0]),p=a(d.blendEquationSeparate,[z.FUNC_ADD,z.FUNC_ADD]),f=a(d.blendFuncSeparate,[z.ONE,z.ONE,z.ZERO,z.ZERO]),v=a(d.colorMask,[!0,!0,!0,!0]),g=a(d.depthRange,[0,1]),_=a(d.polygonOffset,[0,0]),y=a(d.scissor,[0,0,0,0]);i[o]=D.fromCache({frontFace:s(d.frontFace)?d.frontFace[0]:z.CCW,cull:{enabled:h[z.CULL_FACE],face:s(d.cullFace)?d.cullFace[0]:z.BACK},lineWidth:s(d.lineWidth)?d.lineWidth[0]:1,polygonOffset:{enabled:h[z.POLYGON_OFFSET_FILL],factor:_[0],units:_[1]},scissorTest:{enabled:h[z.SCISSOR_TEST],rectangle:{x:y[0],y:y[1],width:y[2],height:y[3]}},depthRange:{near:g[0],far:g[1]},depthTest:{enabled:h[z.DEPTH_TEST],func:s(d.depthFunc)?d.depthFunc[0]:z.LESS},colorMask:{red:v[0],green:v[1],blue:v[2],alpha:v[3]},depthMask:s(d.depthMask)?d.depthMask[0]:!0,blending:{enabled:h[z.BLEND],color:{red:m[0],green:m[1],blue:m[2],alpha:m[3]},equationRgb:p[0],equationAlpha:p[1],functionSourceRgb:f[0],functionSourceAlpha:f[1],functionDestinationRgb:f[2],functionDestinationAlpha:f[3]}})}}}function Ve(e,t){var r={value:e,clone:function(e,t){return e},func:function(){return r.value}};return r}function ke(e,r){var i={value:t.fromArray(e),clone:t.clone,func:function(){return i.value}};return i}function Ue(e,t){var i={value:r.fromArray(e),clone:r.clone,func:function(){return i.value}};return i}function qe(e,t){var r={value:i.fromArray(e),clone:i.clone,func:function(){return r.value}};return r}function Ge(e,t){var r={value:w.fromColumnMajorArray(e),clone:w.clone,func:function(){return r.value}};return r}function We(e,t){var r={value:C.fromColumnMajorArray(e),clone:C.clone,func:function(){return r.value}};return r}function He(e,t){var r={value:E.fromColumnMajorArray(e),clone:E.clone,func:function(){return r.value}};return r}function je(e,t){var r={value:t._rendererResources.textures[e],clone:function(e,t){return e},func:function(){return r.value}};return r}function Ye(e,t){var r=t._runtime.nodes[e];return function(){return r.computedMatrix}}function Xe(e,t){var r=e._loadResources;if(r.finishedTextureCreation()&&r.finishedProgramCreation()&&r.createUniformMaps){r.createUniformMaps=!1;var i=e.gltf,n=i.materials,o=i.techniques,a=(i.programs,e._uniformMaps);for(var u in n)if(n.hasOwnProperty(u)){var l,c=n[u],h=c.instanceTechnique,d=h.values,m=o[h.technique],p=m.parameters,f=m.passes[m.pass],v=f.instanceProgram,g=v.uniforms,_={},y={};for(var w in g)if(g.hasOwnProperty(w)){var C=g[w],E=p[C];if(s(d[C])){var S=Pt[E.type](d[C],e);_[w]=S.func,y[C]=S}else if(s(E.semantic))"JOINTMATRIX"!==E.semantic?_[w]=xt[E.semantic](t.uniformState,e):l=w;else if(s(E.source))_[w]=Ye(E.source,e);else if(s(E.value)){var b=Pt[E.type](E.value,e);_[w]=b.func,y[C]=b}}var T=a[u];T.uniformMap=_,T.values=y,T.jointMatrixUniformName=l}}}function Ze(e){return function(){return e}}function Ke(e){return function(){return e.computedJointMatrices}}function Qe(t,i,n,u){for(var l=t._nodeCommands,c=t._pickIds,h=t.allowPicking,d=t._runtime.meshesByName,m=(t.debugShowBoundingVolume,t._rendererResources),f=m.vertexArrays,v=m.programs,g=m.pickPrograms,_=m.renderStates,y=t._uniformMaps,w=t.gltf,C=w.accessors,S=w.meshes,b=w.techniques,T=w.materials,x=s(i.meshes)?i.meshes:i.instanceSkin.meshes,P=x.length,A=0;P>A;++A)for(var D=x[A],M=S[D],R=M.primitives,O=R.length,N=0;O>N;++N){var L,F=R[N],B=C[F.indices],z=T[F.material].instanceTechnique,V=b[z.technique],k=V.passes[V.pass],U=k.instanceProgram,q=F.attributes.POSITION;if(s(q)){var G=C[q];L=e.fromCornerPoints(r.fromArray(G.min),r.fromArray(G.max))}var W=f[D+".primitive."+N],H=B.count,j=B.byteOffset/p.getSizeInBytes(B.componentType),Y=y[F.material],Z=Y.uniformMap;if(s(Y.jointMatrixUniformName)){var K={};K[Y.jointMatrixUniformName]=Ke(n),Z=o(Z,K)}var Q,J=_[z.technique],$=J.blending.enabled,ee={primitive:a(t.pickPrimitive,t),id:t.id,node:n.publicNode,mesh:d[M.name]},te=new I({boundingVolume:new e,modelMatrix:new E,primitiveType:F.mode,vertexArray:W,count:H,offset:j,shaderProgram:v[U.program],uniformMap:Z,renderState:J,owner:ee,pass:$?X.TRANSLUCENT:X.OPAQUE});if(h){var re=u.createPickId(ee);c.push(re);var ie=o(Z,{czm_pickColor:Ze(re.color)});Q=new I({boundingVolume:new e,modelMatrix:new E,primitiveType:F.mode,vertexArray:W,count:H,offset:j,shaderProgram:g[U.program],uniformMap:ie,renderState:J,owner:ee,pass:$?X.TRANSLUCENT:X.OPAQUE})}var ne={show:!0,boundingSphere:L,command:te,pickCommand:Q};n.commands.push(ne),l.push(ne)}}function Je(e,t){var i=e._loadResources;if(i.finishedPendingLoads()&&i.finishedResourceCreation()&&i.createRuntimeNodes){i.createRuntimeNodes=!1;for(var n=[],o=e._runtime.nodes,a=e.gltf,u=a.nodes,l=a.scenes[a.scene],c=l.nodes,h=c.length,d=[],m=new r,p=0;h>p;++p)for(d.push({parentRuntimeNode:void 0,gltfNode:u[c[p]],id:c[p]});d.length>0;){var f=d.pop(),v=f.parentRuntimeNode,g=f.gltfNode,_=o[f.id];0===_.parents.length&&(s(g.matrix)?_.matrix=E.fromColumnMajorArray(g.matrix):(m=r.fromArray(g.rotation,0,m),_.translation=r.fromArray(g.translation),_.rotation=b.fromAxisAngle(m,g.rotation[3]),_.scale=r.fromArray(g.scale))),s(v)?(v.children.push(_),_.parents.push(v)):n.push(_),(s(g.meshes)||s(g.instanceSkin))&&Qe(e,g,_,t);for(var y=g.children,w=y.length,C=0;w>C;++C)d.push({parentRuntimeNode:_,gltfNode:u[y[C]],id:y[C]})}e._runtime.rootNodes=n,e._runtime.nodes=o}}function $e(e,t){if(e._loadRendererResourcesFromCache){var r=e._rendererResources,i=e._cachedRendererResources;r.buffers=i.buffers,r.vertexArrays=i.vertexArrays,r.programs=i.programs,r.pickPrograms=i.pickPrograms,r.textures=i.textures,r.samplers=i.samplers,r.renderStates=i.renderStates}else we(e,t),be(e,t),Pe(e,t),xe(e),Ie(e,t);Oe(e),Le(e),e._loadRendererResourcesFromCache||(Fe(e,t),ze(e,t)),Xe(e,t),Je(e,t)}function et(e,t){var r=e.publicNode,i=r.matrix;r.useMatrix&&s(i)?E.clone(i,t):s(e.matrix)?E.clone(e.matrix,t):(E.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t),r.setMatrix(t))}function tt(t,i,n){for(var o=t._maxDirtyNumber,a=t.allowPicking,u=t._runtime.rootNodes,l=u.length,c=At,h=t._computedModelMatrix,d=0;l>d;++d){var m=u[d];for(et(m,m.transformToRoot),c.push(m);c.length>0;){m=c.pop();var p=m.transformToRoot,f=m.commands;if(m.dirtyNumber===o||i||n){var v=f.length;if(v>0)for(var g=0;v>g;++g){var _=f[g],y=_.command;if(E.multiplyTransformation(h,p,y.modelMatrix),e.transform(_.boundingSphere,y.modelMatrix,y.boundingVolume),s(t._rtcCenter)&&r.add(t._rtcCenter,y.boundingVolume.center,y.boundingVolume.center),a){var w=_.pickCommand;E.clone(y.modelMatrix,w.modelMatrix),e.clone(y.boundingVolume,w.boundingVolume)}}else m.computedMatrix=E.multiplyTransformation(h,p,m.computedMatrix)}for(var C=m.children,S=C.length,b=0;S>b;++b){var T=C[b];T.dirtyNumber=Math.max(T.dirtyNumber,m.dirtyNumber),(T.dirtyNumber===o||n)&&(et(T,T.transformToRoot),E.multiplyTransformation(p,T.transformToRoot,T.transformToRoot)),c.push(T)}}}++t._maxDirtyNumber}function rt(e){for(var t=e._runtime.skinnedNodes,r=t.length,i=0;r>i;++i){var n=t[i];It=E.inverseTransformation(n.transformToRoot,It);for(var o=n.computedJointMatrices,a=n.joints,u=n.bindShapeMatrix,l=n.inverseBindMatrices,c=l.length,h=0;c>h;++h)s(o[h])||(o[h]=new E),o[h]=E.multiplyTransformation(It,a[h].transformToRoot,o[h]),o[h]=E.multiplyTransformation(o[h],l[h],o[h]),s(u)&&(o[h]=E.multiplyTransformation(o[h],u,o[h]))}}function it(e){for(var t=e._runtime.rootNodes,r=t.length,i=At,n=0;r>n;++n){var o=t[n];for(o.computedShow=o.publicNode.show,i.push(o);i.length>0;){o=i.pop();for(var a=o.computedShow,s=o.commands,u=s.length,l=0;u>l;++l)s[l].show=a;for(var c=o.children,h=c.length,d=0;h>d;++d){var m=c[d];m.computedShow=a&&m.publicNode.show,i.push(m)}}}}function nt(e,t){var r=e.id;if(e._id!==r){e._id=r;for(var i=e._pickIds,n=i.length,o=0;n>o;++o)i[o].object.id=r}}function ot(e){if(e._debugWireframe!==e.debugWireframe){e._debugWireframe=e.debugWireframe;for(var t=e.debugWireframe?S.LINES:S.TRIANGLES,r=e._nodeCommands,i=r.length,n=0;i>n;++n)r[n].command.primitiveType=t}}function at(e){if(e.debugShowBoundingVolume!==e._debugShowBoundingVolume){e._debugShowBoundingVolume=e.debugShowBoundingVolume;for(var t=e.debugShowBoundingVolume,r=e._nodeCommands,i=r.length,n=0;i>n;n++)r[n].command.debugShowBoundingVolume=t}}function st(e,t,i,n){var o=n.camera,a=o.frustum,s=r.subtract(o.positionWC,e,Mt),u=r.multiplyByScalar(o.directionWC,r.dot(s,o.directionWC),Rt),l=Math.max(a.near,r.magnitude(u)-t),c=a.getPixelDimensions(i.drawingBufferWidth,i.drawingBufferHeight,l,Dt),h=Math.max(c.x,c.y);return h}function ut(e,t,i){var n=e.scale;if(0!==e.minimumPixelSize){var o=Math.max(t.drawingBufferWidth,t.drawingBufferHeight),a=e.modelMatrix;Ot.x=a[12],Ot.y=a[13],Ot.z=a[14],s(e._rtcCenter)&&r.add(e._rtcCenter,Ot,Ot);var u=e.boundingSphere.radius,l=st(Ot,u,t,i),c=1/l,h=Math.min(2*c*u,o);h<e.minimumPixelSize&&(n=e.minimumPixelSize*l/(2*e._initialRadius))}return n}function lt(e){s(e._cacheKey)&&s(e._cachedGltf)&&0===--e._cachedGltf.count&&delete gt[e._cacheKey],e._cachedGltf=void 0}function ct(e){for(var t in e)e.hasOwnProperty(t)&&e[t].destroy()}function ht(e){ct(e.buffers),ct(e.vertexArrays),ct(e.programs),ct(e.pickPrograms),ct(e.textures)}if(!d.supportsTypedArrays())return{};var dt=E.fromRotationTranslation(C.fromRotationX(y.PI_OVER_TWO)),mt=new r,pt={NEEDS_LOAD:0,LOADING:1,LOADED:2,FAILED:3},ft="model/vnd.gltf.binary,model/vnd.gltf+json;q=0.8,application/json;q=0.2,*/*;q=0.01";K.prototype.getBuffer=function(e){return te(this.buffers[e.buffer],e.byteOffset,e.byteLength)},K.prototype.finishedPendingLoads=function(){
return 0===this.pendingBufferLoads&&0===this.pendingShaderLoads&&0===this.pendingTextureLoads},K.prototype.finishedResourceCreation=function(){return 0===this.buffersToCreate.length&&0===this.programsToCreate.length&&0===this.texturesToCreate.length&&0===this.texturesToCreateFromBufferView.length&&0===this.pendingBufferViewToImage},K.prototype.finishedBuffersCreation=function(){return 0===this.pendingBufferLoads&&0===this.buffersToCreate.length},K.prototype.finishedProgramCreation=function(){return 0===this.pendingShaderLoads&&0===this.programsToCreate.length},K.prototype.finishedTextureCreation=function(){return 0===this.pendingTextureLoads&&0===this.texturesToCreate.length&&0===this.texturesToCreateFromBufferView.length&&0===this.pendingBufferViewToImage};var vt=function(e){this._gltf=V(e.gltf),this._bgltf=e.bgltf,this.ready=e.ready,this.modelsToLoad=[],this.count=0};u(vt.prototype,{gltf:{set:function(e){this._gltf=V(e)},get:function(){return this._gltf}},bgltf:{get:function(){return this._bgltf}}}),vt.prototype.makeReady=function(e,t){this.gltf=e,this._bgltf=t;for(var r=this.modelsToLoad,i=r.length,n=0;i>n;++n){var o=r[n];o.isDestroyed()||Q(o,this)}this.modelsToLoad=void 0,this.ready=!0};var gt={},_t=function(t){t=a(t,a.EMPTY_OBJECT);var r=t.cacheKey;this._cacheKey=r,this._cachedGltf=void 0,this._releaseGltfJson=a(t.releaseGltfJson,!1),this._animationIds=void 0;var i;if(s(r)&&s(gt[r])&&gt[r].ready)i=gt[r],++i.count;else{var n=t.gltf;s(n)&&(n instanceof ArrayBuffer&&(n=new Uint8Array(n)),i=new vt(n instanceof Uint8Array?{gltf:ie(n),bgltf:n,ready:!0}:{gltf:t.gltf,ready:!0}),i.count=1,s(r)&&(gt[r]=i))}Q(this,i),this._basePath=a(t.basePath,"");var o=new k(document.location.href),u=new k(this._basePath);this._baseUri=u.resolve(o),this.show=a(t.show,!0),this.modelMatrix=E.clone(a(t.modelMatrix,E.IDENTITY)),this._modelMatrix=E.clone(this.modelMatrix),this.scale=a(t.scale,1),this._scale=this.scale,this.minimumPixelSize=a(t.minimumPixelSize,0),this._minimumPixelSize=this.minimumPixelSize,this.id=t.id,this._id=t.id,this.pickPrimitive=t.pickPrimitive,this._allowPicking=a(t.allowPicking,!0),this._ready=!1,this._readyPromise=U.defer(),this.activeAnimations=new W(this),this._asynchronous=a(t.asynchronous,!0),this.debugShowBoundingVolume=a(t.debugShowBoundingVolume,!1),this._debugShowBoundingVolume=!1,this.debugWireframe=a(t.debugWireframe,!1),this._debugWireframe=!1,this._computedModelMatrix=new E,this._initialRadius=void 0,this._boundingSphere=void 0,this._scaledBoundingSphere=new e,this._state=pt.NEEDS_LOAD,this._loadError=void 0,this._loadResources=void 0,this._perNodeShowDirty=!1,this._cesiumAnimationsDirty=!1,this._maxDirtyNumber=0,this._runtime={animations:void 0,rootNodes:void 0,nodes:void 0,nodesByName:void 0,skinnedNodes:void 0,meshesByName:void 0,materialsByName:void 0,materialsById:void 0},this._uniformMaps={},this._rendererResources={buffers:{},vertexArrays:{},programs:{},pickPrograms:{},textures:{},samplers:{},renderStates:{}},this._cachedRendererResources=void 0,this._loadRendererResourcesFromCache=!1,this._nodeCommands=[],this._pickIds=[],this._rtcCenter=void 0,this._rtcCenterEye=void 0};u(_t.prototype,{gltf:{get:function(){return s(this._cachedGltf)?this._cachedGltf.gltf:void 0}},releaseGltfJson:{get:function(){return this._releaseGltfJson}},cacheKey:{get:function(){return this._cacheKey}},basePath:{get:function(){return this._basePath}},boundingSphere:{get:function(){if(this._state!==pt.LOADED)throw new c("The model is not loaded.  Use Model.readyPromise or wait for Model.ready to be true.");var e=E.getScale(this.modelMatrix,mt);r.multiplyByScalar(e,this.scale,e);var t=this._scaledBoundingSphere;return t.center=r.multiplyComponents(this._boundingSphere.center,e,t.center),t.radius=r.maximumComponent(e)*this._initialRadius,s(this._rtcCenter)&&r.add(this._rtcCenter,t.center,t.center),t}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise}},asynchronous:{get:function(){return this._asynchronous}},allowPicking:{get:function(){return this._allowPicking}}});var yt=Uint32Array.BYTES_PER_ELEMENT;_t.fromGltf=function(e){if(!s(e)||!s(e.url))throw new c("options.url is required");var t=e.url,r=a(e.cacheKey,ee(t));e=n(e),e.basePath=$(t),e.cacheKey=r;var i=new _t(e);e.headers=s(e.headers)?n(e.headers):{},s(e.headers.Accept)||(e.headers.Accept=ft);var o=gt[r];return s(o)?o.ready||(++o.count,o.modelsToLoad.push(i)):(o=new vt({ready:!1}),o.count=1,o.modelsToLoad.push(i),Q(i,o),gt[r]=o,f(t,e.headers).then(function(e){var t=new Uint8Array(e);if(re(t))o.makeReady(ie(t),t);else{var r=m(t);o.makeReady(JSON.parse(r))}}).otherwise(ae(i,"model",t))),i},_t._gltfCache=gt,_t.prototype.getNode=function(e){var t=ne(this,"nodesByName",e);return s(t)?t.publicNode:void 0},_t.prototype.getMesh=function(e){return ne(this,"meshesByName",e)},_t.prototype.getMaterial=function(e){return ne(this,"materialsByName",e)};var wt=new r,Ct=new r,Et=new r,St=new r,bt=new b,Tt=new r,xt={MODEL:function(e,t){return function(){return e.model}},VIEW:function(e,t){return function(){return e.view}},PROJECTION:function(e,t){return function(){return e.projection}},MODELVIEW:function(e,t){return function(){return e.modelView}},CESIUM_RTC_MODELVIEW:function(e,t){var r=new E;return function(){return E.setTranslation(e.modelView,t._rtcCenterEye,r)}},MODELVIEWPROJECTION:function(e,t){return function(){return e.modelViewProjection}},MODELINVERSE:function(e,t){return function(){return e.inverseModel}},VIEWINVERSE:function(e,t){return function(){return e.inverseView}},PROJECTIONINVERSE:function(e,t){return function(){return e.inverseProjection}},MODELVIEWINVERSE:function(e,t){return function(){return e.inverseModelView}},MODELVIEWPROJECTIONINVERSE:function(e,t){return function(){return e.inverseModelViewProjection}},MODELINVERSETRANSPOSE:function(e,t){return function(){return e.inverseTranposeModel}},MODELVIEWINVERSETRANSPOSE:function(e,t){return function(){return e.normal}},VIEWPORT:function(e,t){return function(){return e.viewportCartesian4}}},Pt={};"undefined"!=typeof WebGLRenderingContext&&(Pt[z.FLOAT]=Ve,Pt[z.FLOAT_VEC2]=ke,Pt[z.FLOAT_VEC3]=Ue,Pt[z.FLOAT_VEC4]=qe,Pt[z.INT]=Ve,Pt[z.INT_VEC2]=ke,Pt[z.INT_VEC3]=Ue,Pt[z.INT_VEC4]=qe,Pt[z.BOOL]=Ve,Pt[z.BOOL_VEC2]=ke,Pt[z.BOOL_VEC3]=Ue,Pt[z.BOOL_VEC4]=qe,Pt[z.FLOAT_MAT2]=Ge,Pt[z.FLOAT_MAT3]=We,Pt[z.FLOAT_MAT4]=He,Pt[z.SAMPLER_2D]=je);var At=[],It=new E,Dt=new t,Mt=new r,Rt=new r,Ot=new r,Nt=function(e,t){this.buffers=void 0,this.vertexArrays=void 0,this.programs=void 0,this.pickPrograms=void 0,this.textures=void 0,this.samplers=void 0,this.renderStates=void 0,this.ready=!1,this.context=e,this.cacheKey=t,this.count=0};return Nt.prototype.release=function(){return 0===--this.count?(s(this.cacheKey)&&delete this.context.cache.modelRendererResourceCache[this.cacheKey],ht(this),l(this)):void 0},_t.prototype.update=function(e){if(e.mode===Z.SCENE3D){var t=e.context;if(this._state===pt.NEEDS_LOAD&&s(this.gltf)){var i,n=this.cacheKey;if(s(n)){t.cache.modelRendererResourceCache=a(t.cache.modelRendererResourceCache,{});var o=t.cache.modelRendererResourceCache;if(i=o[this.cacheKey],s(i)){if(!i.ready)return;++i.count,this._loadRendererResourcesFromCache=!0}else i=new Nt(t,n),i.count=1,o[this.cacheKey]=i;this._cachedRendererResources=i}else i=new Nt(t),i.count=1,this._cachedRendererResources=i;this._state=pt.LOADING,this._boundingSphere=oe(this.gltf),this._initialRadius=this._boundingSphere.radius;var u=this.gltf.extensions;s(u)&&s(u.CESIUM_RTC)&&(this._rtcCenter=r.fromArray(u.CESIUM_RTC.center),this._rtcCenterEye=new r),this._loadResources=new K,ye(this)}var l=!1;if(this._state===pt.FAILED)throw this._loadError;if(this._state===pt.LOADING){$e(this,t);var c=this._loadResources;if(c.finishedPendingLoads()&&c.finishedResourceCreation()){this._state=pt.LOADED,this._loadResources=void 0;var h=this._rendererResources,d=this._cachedRendererResources;d.buffers=h.buffers,d.vertexArrays=h.vertexArrays,d.programs=h.programs,d.pickPrograms=h.pickPrograms,d.textures=h.textures,d.samplers=h.samplers,d.renderStates=h.renderStates,d.ready=!0,this.releaseGltfJson&&lt(this),l=!0}}var m=this.show&&0!==this.scale;if(m&&this._state===pt.LOADED||l){var p=this.activeAnimations.update(e)||this._cesiumAnimationsDirty;this._cesiumAnimationsDirty=!1;var f=!E.equals(this._modelMatrix,this.modelMatrix)||this._scale!==this.scale||this._minimumPixelSize!==this.minimumPixelSize||0!==this.minimumPixelSize;if(f||l){E.clone(this.modelMatrix,this._modelMatrix),this._scale=this.scale,this._minimumPixelSize=this.minimumPixelSize;var v=ut(this,t,e),g=this._computedModelMatrix;E.multiplyByUniformScale(this.modelMatrix,v,g),E.multiplyTransformation(g,dt,g)}(p||f||l)&&(tt(this,f,l),(p||l)&&rt(this)),this._perNodeShowDirty&&(this._perNodeShowDirty=!1,it(this)),nt(this,t),ot(this),at(this),s(this._rtcCenter)&&E.multiplyByPoint(e.camera.viewMatrix,this._rtcCenter,this._rtcCenterEye)}if(l){var _=this;return void e.afterRender.push(function(){_._ready=!0,_.readyPromise.resolve(_)})}if(m){var y,w,C=e.commandList,S=e.passes,b=this._nodeCommands,T=b.length;if(S.render)for(y=0;T>y;++y)w=b[y],w.show&&C.push(w.command);if(S.pick)for(y=0;T>y;++y)w=b[y],w.show&&C.push(w.pickCommand)}}},_t.prototype.isDestroyed=function(){return!1},_t.prototype.destroy=function(){this._rendererResources=void 0,this._cachedRendererResources=this._cachedRendererResources&&this._cachedRendererResources.release();for(var e=this._pickIds,t=e.length,r=0;t>r;++r)e[r].destroy();return lt(this),l(this)},_t}),r("DataSources/ModelVisualizer",["../Core/AssociativeArray","../Core/BoundingSphere","../Core/Cartesian3","../Core/defined","../Core/destroyObject","../Core/DeveloperError","../Core/Matrix4","../Scene/Model","../Scene/ModelAnimationLoop","./BoundingSphereState","./Property"],function(e,t,r,i,n,o,a,s,u,l,c){"use strict";function h(e,t,r,n){var o=r[t.id];i(o)&&(n.removeAndDestroy(o.modelPrimitive),delete r[t.id])}function d(e){e.activeAnimations.addAll({loop:u.REPEAT})}function m(e){console.error(e)}var p=1,f=0,v=function(t,r){if(!i(t))throw new o("scene is required.");if(!i(r))throw new o("entityCollection is required.");r.collectionChanged.addEventListener(v.prototype._onCollectionChanged,this),this._scene=t,this._primitives=t.primitives,this._entityCollection=r,this._modelHash={},this._entitiesToVisualize=new e,this._modelMatrixScratch=new a,this._onCollectionChanged(r,r.values,[],[])};return v.prototype.update=function(e){if(!i(e))throw new o("time is required.");for(var t=(this._scene.context,this._entitiesToVisualize.values),r=this._modelHash,n=this._primitives,u=(this._scene,0),l=t.length;l>u;u++){var h,v,g=t[u],_=g._model,y=r[g.id],w=g.isShowing&&g.isAvailable(e)&&c.getValueOrDefault(_._show,e,!0);if(w&&(v=g._getModelMatrix(e,this._modelMatrixScratch),h=c.getValueOrUndefined(_._uri,e),w=i(v)&&i(h)),w){var C=i(y)?y.modelPrimitive:void 0;i(C)&&h===y.uri||(i(C)&&(n.removeAndDestroy(C),delete r[g.id]),C=s.fromGltf({url:h}),C.readyPromise.then(d).otherwise(m),C.id=g,n.add(C),y={modelPrimitive:C,uri:h},r[g.id]=y),C.show=!0,C.scale=c.getValueOrDefault(_._scale,e,p),C.minimumPixelSize=c.getValueOrDefault(_._minimumPixelSize,e,f),C.modelMatrix=a.clone(v,C.modelMatrix)}else i(y)&&(y.modelPrimitive.show=!1)}return!0},v.prototype.isDestroyed=function(){return!1},v.prototype.destroy=function(){this._entityCollection.collectionChanged.removeEventListener(v.prototype._onCollectionChanged,this);for(var e=this._entitiesToVisualize.values,t=this._modelHash,r=this._primitives,i=e.length-1;i>-1;i--)h(this,e[i],t,r);return n(this)},v.prototype.getBoundingSphere=function(e,r){if(!i(e))throw new o("entity is required.");if(!i(r))throw new o("result is required.");var n=this._modelHash[e.id];if(!i(n))return l.FAILED;var a=n.modelPrimitive;return i(a)&&a.show?a.ready?(t.transform(a.boundingSphere,a.modelMatrix,r),l.DONE):l.PENDING:l.FAILED},v.prototype._onCollectionChanged=function(e,t,r,n){var o,a,s=this._entitiesToVisualize,u=this._modelHash,l=this._primitives;for(o=t.length-1;o>-1;o--)a=t[o],i(a._model)&&i(a._position)&&s.set(a.id,a);for(o=n.length-1;o>-1;o--)a=n[o],i(a._model)&&i(a._position)?s.set(a.id,a):(h(this,a,u,l),s.remove(a.id));for(o=r.length-1;o>-1;o--)a=r[o],h(this,a,u,l),s.remove(a.id)},v}),r("Shaders/PolylineCommon",[],function(){"use strict";return"void clipLineSegmentToNearPlane(\nvec3 p0,\nvec3 p1,\nout vec4 positionWC,\nout bool clipped,\nout bool culledByNearPlane)\n{\nculledByNearPlane = false;\nclipped = false;\nvec3 p1ToP0 = p1 - p0;\nfloat magnitude = length(p1ToP0);\nvec3 direction = normalize(p1ToP0);\nfloat endPoint0Distance =  -(czm_currentFrustum.x + p0.z);\nfloat denominator = -direction.z;\nif (endPoint0Distance < 0.0 && abs(denominator) < czm_epsilon7)\n{\nculledByNearPlane = true;\n}\nelse if (endPoint0Distance < 0.0 && abs(denominator) > czm_epsilon7)\n{\nfloat t = (czm_currentFrustum.x + p0.z) / denominator;\nif (t < 0.0 || t > magnitude)\n{\nculledByNearPlane = true;\n}\nelse\n{\np0 = p0 + t * direction;\nclipped = true;\n}\n}\npositionWC = czm_eyeToWindowCoordinates(vec4(p0, 1.0));\n}\nvec4 getPolylineWindowCoordinates(vec4 position, vec4 previous, vec4 next, float expandDirection, float width, bool usePrevious) {\nvec4 endPointWC, p0, p1;\nbool culledByNearPlane, clipped;\nvec4 positionEC = czm_modelViewRelativeToEye * position;\nvec4 prevEC = czm_modelViewRelativeToEye * previous;\nvec4 nextEC = czm_modelViewRelativeToEye * next;\nclipLineSegmentToNearPlane(prevEC.xyz, positionEC.xyz, p0, clipped, culledByNearPlane);\nclipLineSegmentToNearPlane(nextEC.xyz, positionEC.xyz, p1, clipped, culledByNearPlane);\nclipLineSegmentToNearPlane(positionEC.xyz, usePrevious ? prevEC.xyz : nextEC.xyz, endPointWC, clipped, culledByNearPlane);\nif (culledByNearPlane)\n{\nreturn vec4(0.0, 0.0, 0.0, 1.0);\n}\nvec2 prevWC = normalize(p0.xy - endPointWC.xy);\nvec2 nextWC = normalize(p1.xy - endPointWC.xy);\nfloat expandWidth = width * 0.5;\nvec2 direction;\nif (czm_equalsEpsilon(normalize(previous.xyz - position.xyz), vec3(0.0), czm_epsilon1) || czm_equalsEpsilon(prevWC, -nextWC, czm_epsilon1))\n{\ndirection = vec2(-nextWC.y, nextWC.x);\n}\nelse if (czm_equalsEpsilon(normalize(next.xyz - position.xyz), vec3(0.0), czm_epsilon1) || clipped)\n{\ndirection = vec2(prevWC.y, -prevWC.x);\n}\nelse\n{\nvec2 normal = vec2(-nextWC.y, nextWC.x);\ndirection = normalize((nextWC + prevWC) * 0.5);\nif (dot(direction, normal) < 0.0)\n{\ndirection = -direction;\n}\nfloat sinAngle = abs(direction.x * nextWC.y - direction.y * nextWC.x);\nexpandWidth = clamp(expandWidth / sinAngle, 0.0, width * 2.0);\n}\nvec2 offset = direction * expandDirection * expandWidth * czm_resolutionScale;\nreturn vec4(endPointWC.xy + offset, -endPointWC.z, 1.0);\n}\n"}),r("Shaders/PolylineFS",[],function(){"use strict";return"varying vec2 v_st;\nvoid main()\n{\nczm_materialInput materialInput;\nmaterialInput.s = v_st.s;\nmaterialInput.st = v_st;\nmaterialInput.str = vec3(v_st, 0.0);\nczm_material material = czm_getMaterial(materialInput);\ngl_FragColor = vec4(material.diffuse + material.emission, material.alpha);\n}\n"}),r("Shaders/PolylineVS",[],function(){"use strict";return"attribute vec3 position3DHigh;\nattribute vec3 position3DLow;\nattribute vec3 position2DHigh;\nattribute vec3 position2DLow;\nattribute vec3 prevPosition3DHigh;\nattribute vec3 prevPosition3DLow;\nattribute vec3 prevPosition2DHigh;\nattribute vec3 prevPosition2DLow;\nattribute vec3 nextPosition3DHigh;\nattribute vec3 nextPosition3DLow;\nattribute vec3 nextPosition2DHigh;\nattribute vec3 nextPosition2DLow;\nattribute vec4 texCoordExpandWidthAndShow;\nattribute vec4 pickColor;\nvarying vec2  v_st;\nvarying float v_width;\nvarying vec4  czm_pickColor;\nvoid main()\n{\nfloat texCoord = texCoordExpandWidthAndShow.x;\nfloat expandDir = texCoordExpandWidthAndShow.y;\nfloat width = abs(texCoordExpandWidthAndShow.z) + 0.5;\nbool usePrev = texCoordExpandWidthAndShow.z < 0.0;\nfloat show = texCoordExpandWidthAndShow.w;\nvec4 p, prev, next;\nif (czm_morphTime == 1.0)\n{\np = czm_translateRelativeToEye(position3DHigh.xyz, position3DLow.xyz);\nprev = czm_translateRelativeToEye(prevPosition3DHigh.xyz, prevPosition3DLow.xyz);\nnext = czm_translateRelativeToEye(nextPosition3DHigh.xyz, nextPosition3DLow.xyz);\n}\nelse if (czm_morphTime == 0.0)\n{\np = czm_translateRelativeToEye(position2DHigh.zxy, position2DLow.zxy);\nprev = czm_translateRelativeToEye(prevPosition2DHigh.zxy, prevPosition2DLow.zxy);\nnext = czm_translateRelativeToEye(nextPosition2DHigh.zxy, nextPosition2DLow.zxy);\n}\nelse\n{\np = czm_columbusViewMorph(\nczm_translateRelativeToEye(position2DHigh.zxy, position2DLow.zxy),\nczm_translateRelativeToEye(position3DHigh.xyz, position3DLow.xyz),\nczm_morphTime);\nprev = czm_columbusViewMorph(\nczm_translateRelativeToEye(prevPosition2DHigh.zxy, prevPosition2DLow.zxy),\nczm_translateRelativeToEye(prevPosition3DHigh.xyz, prevPosition3DLow.xyz),\nczm_morphTime);\nnext = czm_columbusViewMorph(\nczm_translateRelativeToEye(nextPosition2DHigh.zxy, nextPosition2DLow.zxy),\nczm_translateRelativeToEye(nextPosition3DHigh.xyz, nextPosition3DLow.xyz),\nczm_morphTime);\n}\nvec4 positionWC = getPolylineWindowCoordinates(p, prev, next, expandDir, width, usePrev);\ngl_Position = czm_viewportOrthographic * positionWC * show;\nv_st = vec2(texCoord, clamp(expandDir, 0.0, 1.0));\nv_width = width;\nczm_pickColor = pickColor;\n}\n"}),r("Scene/Polyline",["../Core/BoundingSphere","../Core/Cartesian3","../Core/Color","../Core/defaultValue","../Core/defined","../Core/defineProperties","../Core/DeveloperError","../Core/Matrix4","../Core/PolylinePipeline","./Material"],function(e,t,r,i,n,o,a,s,u,l){"use strict";function c(e,t){++e._propertiesChanged[t];var r=e._polylineCollection;n(r)&&(r._updatePolyline(e,t),e._dirty=!0)}var h=function(o,a){o=i(o,i.EMPTY_OBJECT),this._show=i(o.show,!0),this._width=i(o.width,1),this._loop=i(o.loop,!1),this._material=o.material,n(this._material)||(this._material=l.fromType(l.ColorType,{color:new r(1,1,1,1)}));var c=o.positions;n(c)||(c=[]),this._positions=c,this._actualPositions=u.removeDuplicates(c),this._loop&&this._actualPositions.length>2&&(this._actualPositions===this._positions&&(this._actualPositions=c.slice()),this._actualPositions.push(t.clone(this._actualPositions[0]))),this._length=this._actualPositions.length,this._id=o.id;var h;n(a)&&(h=s.clone(a.modelMatrix)),this._modelMatrix=h,this._segments=u.wrapLongitude(this._actualPositions,h),this._actualLength=void 0,this._propertiesChanged=new Uint32Array(g),this._polylineCollection=a,this._dirty=!1,this._pickId=void 0,this._boundingVolume=e.fromPoints(this._actualPositions),this._boundingVolumeWC=e.transform(this._boundingVolume,this._modelMatrix),this._boundingVolume2D=new e},d=h.SHOW_INDEX=0,m=h.WIDTH_INDEX=1,p=h.POSITION_INDEX=2,f=h.MATERIAL_INDEX=3,v=h.POSITION_SIZE_INDEX=4,g=h.NUMBER_OF_PROPERTIES=5;return o(h.prototype,{show:{get:function(){return this._show},set:function(e){if(!n(e))throw new a("value is required.