"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReceiptRuleSet = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const receipt_rule_1 = require("./receipt-rule");
const ses_generated_1 = require("./ses.generated");
/**
 * A new or imported receipt rule set.
 */
class ReceiptRuleSetBase extends core_1.Resource {
    /**
     * Adds a new receipt rule in this rule set.
     *
     * The new rule is added after
     * the last added rule unless `after` is specified.
     *
     * @stability stable
     */
    addRule(id, options) {
        var _b;
        this.lastAddedRule = new receipt_rule_1.ReceiptRule(this, id, {
            after: (_b = this.lastAddedRule) !== null && _b !== void 0 ? _b : undefined,
            ruleSet: this,
            ...options,
        });
        return this.lastAddedRule;
    }
    /**
     * Adds a drop spam rule.
     *
     * @stability stable
     */
    addDropSpamRule() {
        const dropSpam = new receipt_rule_1.DropSpamReceiptRule(this, 'DropSpam', {
            ruleSet: this,
        });
        this.lastAddedRule = dropSpam.rule;
    }
}
/**
 * A new receipt rule set.
 *
 * @stability stable
 */
class ReceiptRuleSet extends ReceiptRuleSetBase {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.receiptRuleSetName,
        });
        const resource = new ses_generated_1.CfnReceiptRuleSet(this, 'Resource', {
            ruleSetName: this.physicalName,
        });
        this.receiptRuleSetName = resource.ref;
        if (props) {
            const rules = props.rules || [];
            rules.forEach((ruleOption, idx) => this.addRule(`Rule${idx}`, ruleOption));
            if (props.dropSpam) {
                this.addDropSpamRule();
            }
        }
    }
    /**
     * Import an exported receipt rule set.
     *
     * @stability stable
     */
    static fromReceiptRuleSetName(scope, id, receiptRuleSetName) {
        class Import extends ReceiptRuleSetBase {
            constructor() {
                super(...arguments);
                this.receiptRuleSetName = receiptRuleSetName;
            }
        }
        return new Import(scope, id);
    }
}
exports.ReceiptRuleSet = ReceiptRuleSet;
_a = JSII_RTTI_SYMBOL_1;
ReceiptRuleSet[_a] = { fqn: "@aws-cdk/aws-ses.ReceiptRuleSet", version: "1.112.0" };
//# sourceMappingURL=data:application/json;base64,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