#
# Copyright The NOMAD Authors.
#
# This file is part of NOMAD.
# See https://nomad-lab.eu for further info.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from .abinit.parser import AbinitParser
from .atk.parser import ATKParser
from .ams.parser import AMSParser
from .bigdft.parser import BigDFTParser
from .castep.parser import CastepParser
from .charmm.parser import CharmmParser
from .cp2k.parser import CP2KParser
from .cpmd.parser import CPMDParser
from .crystal.parser import CrystalParser
from .dmol3.parser import Dmol3Parser
from .elk.parser import ElkParser
from .exciting.parser import ExcitingParser
from .fhiaims.parser import FHIAimsParser
from .fleur.parser import FleurParser
from .fplo.parser import FploParser
from .gamess.parser import GamessParser
from .gaussian.parser import GaussianParser
from .gpaw.parser import GPAWParser
from .molcas.parser import MolcasParser
from .mopac.parser import MopacParser
from .nwchem.parser import NWChemParser
from .octopus.parser import OctopusParser
from .onetep.parser import OnetepParser
from .openmx.parser import OpenmxParser
from .orca.parser import OrcaParser
from .psi4.parser import Psi4Parser
from .qball.parser import QBallParser
from .qbox.parser import QboxParser
from .quantumespresso.parser import QuantumEspressoParser
from .siesta.parser import SiestaParser
from .turbomole.parser import TurbomoleParser
from .vasp.parser import VASPParser
from .wien2k.parser import Wien2kParser
from .yambo.parser import YamboParser
from .abacus.parser import ABACUSParser
from .wannier90.parser import Wannier90Parser
from .w2dynamics.parser import W2DynamicsParser
from .soliddmft.parser import SolidDMFTParser
