from _typeshed import Incomplete
from fwhunt_scan.uefi_analyzer import NvramVariable as NvramVariable, UefiAnalyzer as UefiAnalyzer, UefiGuid as UefiGuid, UefiProtocol as UefiProtocol, UefiService as UefiService
from typing import Any

logger: Incomplete

class CodePattern:
    pattern: Incomplete
    place: Incomplete
    unspecified: Incomplete
    def __init__(self, pattern: str, place: str | None) -> None: ...
    @property
    def __dict__(self): ...

class UefiRuleVariant:
    def __init__(self, rule_content: dict[str, Any]) -> None: ...
    @property
    def code(self) -> dict[str, list[CodePattern]]: ...
    @property
    def strings(self) -> dict[str, list[str]]: ...
    @property
    def wide_strings(self) -> dict[str, list[dict[str, str]]]: ...
    @property
    def hex_strings(self) -> dict[str, list[str]]: ...
    @property
    def nvram_vars(self) -> dict[str, list[NvramVariable]]: ...
    @property
    def protocols(self) -> dict[str, list[UefiProtocol]]: ...
    @property
    def ppi_list(self) -> dict[str, list[UefiProtocol]]: ...
    @property
    def guids(self) -> dict[str, list[UefiGuid]]: ...

class UefiRule:
    def __init__(self, rule_path: str | None = None, rule_content: str | None = None) -> None: ...
    @property
    def author(self) -> str | None: ...
    @property
    def name(self) -> str | None: ...
    @property
    def version(self) -> str | None: ...
    @property
    def namespace(self) -> str | None: ...
    @property
    def license(self) -> str | None: ...
    @property
    def cve_number(self) -> str | None: ...
    @property
    def vendor_id(self) -> str | None: ...
    @property
    def cvss_score(self) -> str | None: ...
    @property
    def advisory(self) -> str | None: ...
    @property
    def description(self) -> str | None: ...
    @property
    def url(self) -> str | None: ...
    @property
    def target(self) -> str | None: ...
    @property
    def volume_guids(self) -> list[str]: ...
    @property
    def variants(self) -> dict[str, UefiRuleVariant]: ...

class UefiScannerError(Exception):
    value: Incomplete
    def __init__(self, value: str) -> None: ...

class UefiScannerRes:
    rule: Incomplete
    variant_label: Incomplete
    res: Incomplete
    def __init__(self, rule: UefiRule, variant_label: str, res: bool) -> None: ...

class UefiScanner:
    PROTOCOL: int
    PPI: int
    def __init__(self, uefi_analyzer: UefiAnalyzer, uefi_rules: list[UefiRule]) -> None: ...
    @property
    def results(self) -> list[UefiScannerRes]: ...
